# Drew Houston - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Drew Houston, the co-founder and CEO of Dropbox.

---

### [00:00:00] Lenny Rachitsky

**English:**
People just don't realize the wild journey that you have been on over the past 18 years building this company. It feels like there's almost been these three eras of Dropbox. The first era of you're killing it.

**中文翻译:**
人们可能没有意识到，在过去的 18 年里，你在打造这家公司的过程中经历了一段多么疯狂的旅程。感觉 Dropbox 几乎经历了三个时代。第一个时代是你们势如破竹的时期。

---

### [00:00:10] Drew Houston

**English:**
For the first several years, it was doubling, 10-xing every year. Taping user counts that we printed out to the wall, and then running out of space on the wall. Having to put 100,000 users, 200,000, 500,000, 1,000,000, 10,000,000 on the ceiling.

**中文翻译:**
在最初的几年里，公司每年都在翻倍，甚至增长 10 倍。我们将打印出来的用户数量贴在墙上，后来墙上都没地方贴了。我们不得不把 10 万、20 万、50 万、100 万、1000 万用户的数字贴到天花板上。

---

### [00:00:23] Lenny Rachitsky

**English:**
And there's the second era, which I'll just say, everyone's trying to kill you.

**中文翻译:**
然后是第二个时代，我称之为“所有人都在试图干掉你”的时代。

---

### [00:00:26] Drew Houston

**English:**
We started getting all the incumbents. Apple, Microsoft, Google. All of them launched competing products, but weirdly, it was sort of like you see the videos where there's the mushroom cloud in the distance. You see it. But you don't hear, or notice it. It was also clear that winter was coming.

**中文翻译:**
我们开始面对所有的老牌巨头。苹果、微软、谷歌，他们都推出了竞争产品。但奇怪的是，这有点像你在视频里看到远处的蘑菇云：你能看到它，但你听不到声音，也感觉不到震动。但很明显，寒冬将至。

---

### [00:00:41] Lenny Rachitsky

**English:**
It feels like the year 2015 was a pivotal year where things started to shift.

**中文翻译:**
感觉 2015 年是一个关键的转折点，事情开始发生变化。

---

### [00:00:45] Drew Houston

**English:**
I'd start to hear a louder set of critics inside, and outside the company. Less than a year later, Google Photos launches. And not only does it provide a lot of the same value, but they also gave you free unlimited storage for life. And so, they just totally nuked our business model.

**中文翻译:**
我开始听到公司内外越来越大的批评声。不到一年后，Google Photos 发布了。它不仅提供了许多相同的功能价值，还提供了终身免费的无限存储空间。所以，他们完全摧毁（nuke）了我们的商业模式。

---

### [00:01:02] Lenny Rachitsky

**English:**
You end up fighting wars on three or four fronts against the big kahunas that have infinite cash, and can do whatever they want.

**中文翻译:**
你最终在三四个战线上与那些拥有无限现金、可以随心所欲的大佬们作战。

---

### [00:01:08] Drew Houston

**English:**
So it killed Carousel, killed Mailbox, went all-in on productivity. And I wish I could say, "Then, everything got better." It was the opposite, actually. The narrative completely flipped on the company. Suddenly, your employees don't want to wear your T-shirt anymore. Everybody's looking to you, and is wondering, "How the hell did you get us in this situation?"

**中文翻译:**
所以我们关掉了 Carousel，关掉了 Mailbox，全力投入到生产力工具上。我真希望我能说：“然后一切都变好了。”但事实恰恰相反。关于公司的舆论完全反转了。突然间，你的员工不再想穿印有公司 Logo 的 T 恤了。每个人都看着你，心里在想：“你到底是怎么把我们带进这种境地的？”

---

### [00:01:28] Lenny Rachitsky

**English:**
Today, my guest is Drew Houston. This may be the most interesting, and most useful episode of my podcast so far. Especially if you're a founder, or if you someday want to be a founder. Drew shares the very real talk story of what it's been like to build Dropbox over the past 18 years. Including the ups, and especially the downs. He shares stories that he's never shared before, the struggles he's been through that very few people know about, what it's like to compete with big tech, how he's thinking about the future of the company. And also, what he's learned about himself throughout the journey.

**中文翻译:**
今天的嘉宾是 Drew Houston。这可能是我播客至今最有趣、最有用的一集。特别是如果你是一名创始人，或者有一天想成为创始人。Drew 分享了过去 18 年打造 Dropbox 的真实故事，包括高光时刻，尤其是低谷时期。他分享了一些从未公开过的故事，那些极少数人知道的挣扎，与科技巨头竞争的感受，他对公司未来的思考，以及他在这段旅程中对自己有哪些新的认识。

---

### [00:02:01] Lenny Rachitsky (Continued)

**English:**
This is a very special episode that I suspect founders will be studying for years to come. A big thank you to Drew for sharing these stories and lessons with us. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app, or YouTube. It's the best way to avoid missing feature episodes, and it helps the podcast tremendously. With that, I bring you Drew Houston. This episode is brought to you by Paragon. The integration infrastructure for B2B SaaS companies.

**中文翻译:**
这是一个非常特别的章节，我怀疑创始人们在未来几年都会反复研究。非常感谢 Drew 与我们分享这些故事和教训。如果你喜欢这个播客，别忘了在你的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对播客有很大帮助。现在，让我们欢迎 Drew Houston。本集节目由 Paragon 赞助，它是 B2B SaaS 公司的集成基础设施。

---

### [00:02:28] Lenny Rachitsky (Sponsor: Paragon)

**English:**
Is AI on your 2025 product roadmap? Whether you need to enable RAG with your user's external data like Google Drive files, Gong transcripts, or Jira tickets, or build AI agents that can automate work across your users' other tools. Integrations are the foundation, but building all these integrations in-house will cost you years of engineering. Time you don't have given the fast pace of AI. That's where Paragon's all-in-one integration platform comes in. Build scalable workflows to ingest all of your users' external data into your RAG pipelines.

**中文翻译:**
AI 在你 2025 年的产品路线图中吗？无论你是需要利用用户的外部数据（如 Google Drive 文件、Gong 转录稿或 Jira 工单）来实现 RAG（检索增强生成），还是构建能够跨用户其他工具自动执行任务的 AI 代理，集成都是基础。但是，内部构建所有这些集成将耗费数年的工程时间，而在 AI 飞速发展的今天，你没有那么多时间。这就是 Paragon 全方位集成平台发挥作用的地方。构建可扩展的工作流，将用户的所有外部数据摄取到你的 RAG 管道中。

---

### [00:02:59] Lenny Rachitsky (Sponsor: Paragon Continued)

**English:**
And leverage ActionKit, their latest product, to instantly give your AI agents access to over 100 integrations, and 1,000s of third-party actions with a single API call. Leading AI companies like AI21, You.com, 11x, and Coffee.ai are already shipping new integrations seven times faster with Paragon. Keeping their engineers focused on core product development. Ready to accelerate your AI roadmap this year? Visit useparagon.com/Lenny to get a free MVP of your next product integration.

**中文翻译:**
利用他们最新的产品 ActionKit，只需一次 API 调用，即可让你的 AI 代理立即访问 100 多个集成和数千个第三方操作。AI21、You.com、11x 和 Coffee.ai 等领先的 AI 公司已经通过 Paragon 将新集成的发布速度提高了 7 倍，让他们的工程师能够专注于核心产品开发。准备好加速今年的 AI 路线图了吗？访问 useparagon.com/Lenny，获取你下一个产品集成的免费 MVP。

---

### [00:03:33] Lenny Rachitsky (Sponsor: Explo)

**English:**
This episode is brought to you by Explo. A game changer for customer-facing analytics, and data reporting. Are your users craving more dashboards, reports, and analytics within your product? Are you tired of trying to build it yourself? As a product leader, you probably have these requests in your roadmap, but the struggle to prioritize them is real. Building analytics from scratch can be time-consuming, expensive, and a really challenging process. Enter, Explo. Explo is a fully white-labeled embedded analytics solution designed entirely with your user in mind. Getting started is easy.

**中文翻译:**
本集节目由 Explo 赞助。它是面向客户的分析和数据报告领域的游戏规则改变者。你的用户是否渴望在你的产品中看到更多的仪表板、报告和分析功能？你是否厌倦了尝试自己构建这些功能？作为产品负责人，你的路线图中可能已经有了这些需求，但优先级的权衡确实很困难。从头开始构建分析功能既耗时又昂贵，而且过程极具挑战性。Explo 应运而生。Explo 是一个完全白标（white-labeled）的嵌入式分析解决方案，完全从用户的角度出发设计。上手非常简单。

---

### [00:04:08] Lenny Rachitsky (Sponsor: Explo Continued)

**English:**
Explo connects to any relational database, or warehouse. And with its low-code functionality, you can build and style dashboards in minutes. Once you're ready, simply embed the dashboard, or report into your application with a tiny code snippet. The best part? Your end users can use Explo's AI features for their own report, and dashboard generation. Eliminating customer data requests for your support team. Build, and embed a fully white-labeled analytics experience in days. Try it for free at explo.co/Lenny. That's E-X-P-L-O dot C-O slash Lenny. Drew, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Explo 可以连接到任何关系型数据库或数据仓库。凭借其低代码功能，你可以在几分钟内构建并美化仪表板。准备就绪后，只需通过一小段代码将仪表板或报告嵌入到你的应用程序中。最棒的部分是？你的最终用户可以使用 Explo 的 AI 功能生成他们自己的报告和仪表板，从而消除对支持团队的客户数据请求。在几天内构建并嵌入完全白标的分析体验。在 explo.co/Lenny 免费试用。Drew，非常感谢你能来。欢迎来到播客。

---

### [00:04:51] Drew Houston

**English:**
Oh, thank you, Lenny. It's great to be here.

**中文翻译:**
哦，谢谢你，Lenny。很高兴来到这里。

---

### [00:04:53] Lenny Rachitsky

**English:**
I have been so looking forward to this conversation for so many reasons. One, is I feel like people just don't realize the wild journey that you have been on over the past 18 years building this company. You told me a few of these stories when we had dinner recently, and I was just like, "You need to come on the podcast, and tell this stuff. I think it'll be really useful to a lot of people."
(00:05:12):
And then also, I feel like you're just a very real talk founder that isn't afraid to share what's really going on. I think a lot of founders don't actually tell you the things they're going through. It's always, "Killing it. We're killing it all the time." So for all those reasons, I'm really excited to have this chat, and this opportunity to stand with you and hear these stories. So thank you again for doing this.

**中文翻译:**
出于很多原因，我一直非常期待这次对话。首先，我觉得人们根本没有意识到你在过去 18 年打造这家公司的过程中经历了多么疯狂的旅程。最近我们一起吃晚饭时，你给我讲了其中一些故事，我当时就想：“你一定要上播客讲讲这些，我觉得这对很多人都会非常有用。”
(00:05:12):
其次，我觉得你是一个非常敢说真话的创始人，不害怕分享真实情况。我觉得很多创始人并不会告诉你他们真实经历的事情，总是说“我们做得很好，一直都很棒”。所以基于这些原因，我非常兴奋能有这次机会和你坐下来听这些故事。再次感谢你。

---

### [00:05:29] Drew Houston

**English:**
Me too, and I've been a big fan of the podcast.

**中文翻译:**
我也是，我一直是这个播客的忠实粉丝。

---

### [00:05:31] Lenny Rachitsky

**English:**
Oh.

**中文翻译:**
噢。

---

### [00:05:32] Drew Houston

**English:**
I learned a lot.

**中文翻译:**
我学到了很多。

---

### [00:05:33] Lenny Rachitsky

**English:**
Oh, wow. I appreciate that. The way I'm thinking we structure this conversation is, as an outsider, it feels like there's almost been these three eras of Dropbox. And tell me if I am missing something, but essentially, it feels like there's the first era of you're killing it. Just up and to the right killing it. Dropbox is on fire.
(00:05:52):
And then, there's the second era that I think fewer people know about, which I'll just say, everyone was trying to kill you. All the incumbents are coming after you. I like that it leads you to sigh. This is going to be good. And then, there's the current era. I'll say the third era of just rethinking what Dropbox could be. Does that sound roughly right? That's a good way to think about that?

**中文翻译:**
噢，哇，非常感谢。我设想的对话结构是这样的：作为一个局外人，感觉 Dropbox 几乎经历了三个时代。如果我漏掉了什么请告诉我，但基本上，第一个时代是你们势不可挡的时期，业务一路飙升，Dropbox 火遍全网。
(00:05:52):
然后是第二个时代，我觉得知道的人比较少，就是“所有人都在试图干掉你”的时期。所有的老牌巨头都在追杀你。我看到你叹了口气，这说明接下来的内容会很精彩。最后是现在的时代，也就是第三个时代，重新思考 Dropbox 的未来。这听起来大致准确吗？这是一个好的思考方式吗？

---

### [00:06:11] Drew Houston

**English:**
I think that's right. Yep.

**中文翻译:**
我觉得没错。是的。

---

### [00:06:12] Lenny Rachitsky

**English:**
Okay, awesome. So let's start with this first era, and spend some time here. Which is, I think, the era most people know you for. There's the big Hacker News launch, the demo video of the thumb drive you're always losing, the referral program everyone's always studying. You're almost the epitome of viral growth. And so, let's just talk about just things here that maybe people don't know about. Maybe some moments that are really important to you, memories that stand out to you. So maybe just start wherever you want to start about this time of the history of Dropbox.

**中文翻译:**
太好了。那我们就从第一个时代开始，多花点时间聊聊。我想这是大多数人认识你的时代。有著名的 Hacker News 发布，有那个关于总是丢 U 盘的演示视频，还有每个人都在研究的推荐计划（referral program）。你几乎就是病毒式增长的代名词。所以，让我们聊聊那些人们可能不知道的事情，聊聊对你来说非常重要的时刻，或者让你记忆深刻的回忆。你可以从 Dropbox 历史中这段时间的任何地方开始。

---

### [00:06:41] Drew Houston

**English:**
I mean, I started Dropbox more out of just personal frustration, and it really felt like something that only I was super interested in as far as file syncing. And focusing on one customer, which is myself. And then there's the story of me forgetting my thumb drive on a trip to New York, and things like that, and coding. I won't get into all that. I had a lot of friends who were in Y Combinator, and many friends who had moved from Boston where I was living out to California. And doing that whole pilgrimage, or kind of maybe one-way pilgrimage.
(00:07:14):
And feeling a little bit left out, but then also having this idea for Dropbox. And then I think some of the most memorable things were the moments where Dropbox really felt like it was taking on a life of its own, or maybe it belonged to the internet, and not so much to me anymore. So for example, we had a lot of success with these demo videos. First, was just getting into Y Combinator. It sort of worked backwards from thinking about, "What does Paul Graham do all day?" And my hypothesis was that he just hits refresh on Hacker News like everyone else. Like me, like everyone else.

**中文翻译:**
我是说，我创办 Dropbox 更多是出于个人的沮丧，当时感觉文件同步这种事只有我一个人超级感兴趣。我只专注于一个客户，那就是我自己。然后就是那个我去纽约旅行忘了带 U 盘的故事，诸如此类，还有写代码。我就不细说了。我有很多朋友在 Y Combinator (YC)，很多朋友从我当时住的波士顿搬到了加州，进行那种“朝圣”，或者说“单程朝圣”。
(00:07:14):
我感到有点被冷落了，但同时我有了 Dropbox 的想法。我觉得最难忘的一些时刻是，Dropbox 真的感觉开始有了自己的生命，或者说它属于互联网，而不再仅仅属于我。例如，我们的演示视频取得了巨大成功。首先是为了进入 YC。我当时反向思考：“Paul Graham 整天都在干什么？”我的假设是，他就像其他人一样，像我一样，不停地刷新 Hacker News。

---

### [00:07:46] Lenny Rachitsky

**English:**
This was you trying to figure out how to get Paul Graham's attention?

**中文翻译:**
这是你在想办法引起 Paul Graham 的注意？

---

### [00:07:49] Drew Houston

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:07:49] Lenny Rachitsky

**English:**
I love that. "What does Paul Graham do all day?" Okay.

**中文翻译:**
我喜欢这个思路。“Paul Graham 整天都在干什么？” 好的。

---

### [00:07:52] Drew Houston

**English:**
Yeah. Well, my first company was doing online SAT prep, and I was 21 when I started that. But in the world, there's a lot that Y Combinator has in common with college admissions. You have 1,000,000 people applying for very few spots. And the more you can get some kind of hook, or find some kind of side door. That was the thinking, and I was like, "All right. Well, if I can create some kind of viral video, put it on Hacker News, get Paul's attention, that'd be one way to do it."
(00:08:21):
And that was inspired by a book called Guerrilla Marketing that I had read, which is basically how to do marketing if you have no money. Which was a good fit for where we were. I say, "We." It was just me at the time. And sure enough, I made this video that was basically a pretty straightforward screencast of Dropbox. Showing it working on my computer, and then it hit the top of Hacker News for two days. I don't think it can really happen anymore, but sure enough, we got a note from Paul saying, "Hey, this is interesting, but you need a co-founder."
(00:08:56):
Which was a problem because it's clear that the YC application deadline for the next cycle was maybe a week or two away. So Paul was basically sending me a helpful note that, "I know you're not dating anyone, but you need to be married in the next two weeks if you want to get into YC." So I ended up finding my co-founder, Arash, and there's just story after story like that in the early days. So I'd say the first chapter was characterized by just feels like one moment I'm sort of paddling in the ocean alone on a little board. The next, I'm just like a hundred feet off the ground on this tidal wave trying to stay on.

**中文翻译:**
是的。我的第一家公司是做在线 SAT 培训的，我 21 岁开始做那个。但在某种程度上，YC 与大学录取有很多共同点：有 100 万人申请极少数的名额。你越能找到某种“钩子”或“侧门”就越好。这就是当时的思路，我想：“好吧，如果我能制作某种病毒视频，发到 Hacker News 上，引起 Paul 的注意，那也是一种办法。”
(00:08:21):
这受到了我读过的一本叫《游击营销》（Guerrilla Marketing）的书的启发，书里讲的是如果你没钱该怎么做营销。这非常适合我们当时的情况。我说“我们”，其实当时只有我一个人。果然，我做了一个视频，基本上就是一个非常直白的 Dropbox 屏幕录像，展示它在我的电脑上运行。然后它在 Hacker News 榜首待了两天。我觉得这种事现在不太可能发生了。但果然，我们收到了 Paul 的简讯，说：“嘿，这很有趣，但你需要一个联合创始人。”
(00:08:56):
这成了个问题，因为下一轮 YC 申请截止日期大概只有一两周了。所以 Paul 基本上是在给我发一个有用的提醒：“我知道你现在还没对象，但如果你想进 YC，你得在接下来的两周内结婚。”所以我最终找到了我的联合创始人 Arash。早期有很多这样的故事。所以我会说，第一章的特点是，前一刻我感觉自己还独自在海上划着小板，下一刻我就像在百英尺高的巨浪尖上，拼命想稳住。

---

### [00:09:32] Lenny Rachitsky

**English:**
How long does this period last of just Hacker News to something starts to change? How long is this up and to the right period?

**中文翻译:**
从 Hacker News 发布到情况开始发生变化，这段时间持续了多久？这种“一路向上”的时期持续了多久？

---

### [00:09:40] Drew Houston

**English:**
It was the first several years. So I started the company back in 2007. I might have been 24 at the time, moved to California. And so, I'd say it was first probably seven years from 2007 to 2014 were really that crazy fever dream .com experience where it's a blur. I mean, basically, get into Y Combinator. After we finish Y Combinator, that culminates in Demo Day, and getting your first investors. At Demo Day was this guy named Pejman Nozad who is an angel investor who also owned a rug store in Palo Alto. He runs Pear there.

**中文翻译:**
是最初的几年。我在 2007 年创办了这家公司。当时我大概 24 岁，搬到了加州。所以，我会说从 2007 年到 2014 年的前七年真的是那种疯狂的、如梦似幻的互联网公司经历，一切都很模糊。我是说，基本上是进入 YC，结束 YC 后，在 Demo Day 达到高潮并获得第一批投资者。在 Demo Day，遇到了一个叫 Pejman Nozad 的人，他是一名天使投资人，当时在帕罗奥图还开着一家地毯店。他现在在那经营 Pear VC。

---

### [00:10:24] Lenny Rachitsky

**English:**
Oh, and he runs Pear. [inaudible 00:10:25].

**中文翻译:**
哦，他经营 Pear。[听不清]。

---

### [00:10:24] Drew Houston

**English:**
Yeah, and he runs Pear now. He introduced us to Sequoia. He came with us to the pitch, which I learned later it was unusual. And that was on a Friday, and then Saturday Mike Moritz is in our apartment. But anyway, so we raised money from Sequoia, and that was a seed round in 2007. So right after we finished Y Combinator. And then, basically, you start with a pretty narrow circle of what you're working on.
(00:10:53):
I mean, right in the beginning it's just really just coding, and talking to customers. But that circle kept expanding pretty rapidly. So in 2007, we were just building the first prototype of the product. It was in closed beta for about a year. And in end of 2008, we launched at what's now TechCrunch Disrupt. Our demo totally failed. The wifi wasn't working on stage, so a live demo is quite underwhelming. So that took a few years off my life, but fortunately, we had accumulated this big beta waiting list from basically doing another version of that Hacker News video.
(00:11:33):
Engineered to be even more viral, and have all these memes, and things in it. But similarly, a few minute demo video of, "What's Dropbox? And here's moving stuff between a Windows PC, and a Mac. And here's all these little Easter eggs about the HD DVD encryption key, or [inaudible 00:11:50] who was one of the first YouTubers. Tom Cruise jumping on a couch in Scientology." This was a long time ago. 15 years ago, or something. But we put this video on Dig, and Reddit. And our beta waiting list went from 5,000 to 85,000 people overnight.
(00:12:09):
So we got this initial seed audience by chasing that early adopter set. And then, we also figured out these viral motions around our referral program, and shared folders. And so Dropbox started expanding virally for the first several years. And then a lot of the engineering that we applied to the product of Dropbox can't have a bad day when it comes to your wedding photos, and tax returns, and all the things people put in Dropbox. So we took a while to get the beta right before we felt comfortable opening up to the broader public.
(00:12:40):
But then, we applied that same engineering mentality to these viral loops. And this was all the era when social media was exploding, and Facebook, and Facebook platform. All these startups were setting new land speed records for fastest to 1,000,000 users, or 10,000,000 users. Things like Zynga. And all of this was built on this emerging playbook of virality, which in turn came from epidemiology. The study of the spread of viruses turned out to be a good parallel for the consumer internet. Draw your own conclusions.
(00:13:13):
And then we were like, "Oh, there's no reason this wouldn't work for Dropbox." And some of our early investors, Hadi and Ali Partovi, talked to us about how Facebook thought about growth. And then there were a lot of great people in the early days who had really fine-tuned, and mastered a lot of that. We tried many things. Conventional, and unconventional. But the things around virality, and the referral program really worked.
(00:13:39):
And so for the first several years, it was just doubling, 10-xing every year. Taping user counts that we printed out to the wall, and then running out of space on the wall. Having to put a 100,000, 200,000, 500,000, 1,000,000, 10,000,000 on the ceiling. So it was wild. And it was super fun, but it was also super stressful. But going from maybe $6,000,000 valuation in 2007, to $27,000,000 in 2008, to then $4,000,000,000 valuation in 2011, being on magazine covers. Just that whole experience was wild.

**中文翻译:**
是的，他现在经营 Pear。他把我们介绍给了红杉资本（Sequoia）。他陪我们一起去参加了融资路演，后来我才知道这很不寻常。那是周五，然后周六 Mike Moritz（红杉合伙人）就出现在我们的公寓里了。总之，我们在 2007 年从红杉那里筹到了钱，那是种子轮，就在我们刚结束 YC 之后。然后，基本上你开始从一个很小的圈子开始工作。
(00:10:53):
我的意思是，刚开始真的只是写代码和与客户交流。但那个圈子扩张得非常快。2007 年，我们还在构建产品的第一个原型。它进行了大约一年的封闭测试。2008 年底，我们在现在的 TechCrunch Disrupt 上发布。我们的演示完全失败了，台上的 Wifi 坏了，所以现场演示非常平淡。那次经历让我折寿了好几年。但幸运的是，我们通过制作另一个版本的 Hacker News 视频积累了庞大的测试等待名单。
(00:11:33):
那个视频被设计得更具病毒性，里面加入了很多梗（memes）。同样是一个几分钟的演示视频，介绍“什么是 Dropbox？看，这是在 Windows PC 和 Mac 之间移动文件。这里还有关于 HD DVD 加密密钥的小彩蛋，或者是关于最早的 YouTuber 之一 [听不清] 的梗，还有汤姆·克鲁斯在科学教节目里跳沙发。”那是很久以前的事了，大概 15 年前。我们将视频发到了 Digg 和 Reddit 上，我们的测试等待名单一夜之间从 5000 人增加到了 8.5 万人。
(00:12:09):
所以我们通过追逐早期采用者群体获得了最初的种子用户。然后，我们还围绕推荐计划和共享文件夹找到了这些病毒式传播的动力。因此，Dropbox 在最初的几年里开始呈病毒式扩张。我们在产品工程上投入了大量精力，因为 Dropbox 在处理你的婚纱照、纳税申报单以及人们放入其中的所有东西时，绝不能出差错。所以我们花了一段时间才完善测试版，然后才放心向更广泛的公众开放。
(01:12:40):
然后，我们将同样的工程思维应用到了这些病毒循环中。那正是社交媒体爆炸的时代，Facebook 及其平台崛起。所有这些初创公司都在刷新达到 100 万或 1000 万用户的最快纪录，比如 Zynga。所有这些都建立在当时新兴的病毒式传播策略之上，而这又源于流行病学。对病毒传播的研究被证明是消费级互联网的一个很好的类比。你可以得出自己的结论。
(00:13:13):
然后我们想：“噢，没有理由这在 Dropbox 上行不通。”我们的一些早期投资者，Hadi 和 Ali Partovi，跟我们谈过 Facebook 是如何思考增长的。早期有很多优秀的人已经精通并掌握了这些方法。我们尝试了很多东西，常规的和非常规的。但关于病毒式传播和推荐计划的东西确实奏效了。
(00:13:39):
所以在最初的几年里，业务每年都在翻倍、增长 10 倍。我们把打印出来的用户数贴在墙上，墙上没地方了，就贴到天花板上：10 万、20 万、50 万、100 万、1000 万。那太疯狂了。超级有趣，但也超级有压力。从 2007 年大约 600 万美元的估值，到 2008 年的 2700 万美元，再到 2011 年的 40 亿美元估值，还登上了杂志封面。整个经历简直太疯狂了。

---

### [00:14:19] Lenny Rachitsky

**English:**
The visual of the user numbers extending onto the ceiling is such a good one. Of just how quickly things grew. Okay. So let's transition to the second era. So things have been going great, keeps growing. Obviously, challenges along the way, but it feels like it's just grow, grow, grow. It feels like the year 2015 was a pivotal year where things started to shift. Does that sound right?

**中文翻译:**
用户数字一直延伸到天花板上的画面感太强了，说明增长速度真的惊人。好，那我们转入第二个时代。一切进展顺利，持续增长。虽然一路上也有挑战，但感觉就是一直在增长、增长、增长。感觉 2015 年是一个关键年份，事情开始发生转变。听起来对吗？

---

### [00:14:43] Drew Houston

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:14:44] Lenny Rachitsky

**English:**
Okay. Yeah. Let's talk about that.

**中文翻译:**
好，那我们聊聊那个。

---

### [00:14:46] Drew Houston

**English:**
Yeah. Maybe the end of the first era, the start of our teenage years, would've been around 2013, or 2014. And maybe before that. 2011, 2012, we started getting all the incumbents, or all the big platform companies. Apple, Microsoft, Google. All of them launched competing products in one form, or another. But weirdly, it was like you see the videos where there's the mushroom cloud in the distance. You see it. But you don't hear, or notice it. So it mostly just seemed like nothing happened.
(00:15:27):
When Steve Jobs was on stage in 2011 announcing iCloud, calling out Dropbox by name as something that will be viewed as archaic. And similarly, we always felt like we were in the shadow of the hammer of Google launching Google Drive, which had been rumored long before we even started the company. For the first several years, we were just sort of quivering, waiting for the shoe to drop. And the product's launched, but you would never be able to look at our numbers and see when that happened. And the press often writes about competition like, "Oh, it's a shotgun blast."
(00:16:06):
When, later, I would learn it's more of a boa constrictor. But the end of that first chapter really culminated in us recognizing that we experienced a lot of benefits of being this kind of product for everyone. And in fact, it would be kind of hard for me to describe in the early days who Dropbox is for, or what it does. It was similar to what's a phone for, or what's a computer for? And in the beginning, that was a blessing. It meant that those viral loops would really work. Pretty much everybody you would hit would have a need for something like Dropbox. Either a personal need, or a work need, or both.
(00:16:43):
But we recognized even back then before competition that, "Hey, people are using us primarily for things like backup, backing up their devices, or storage. People are using us for photo sharing. People are using us as a collaborative space at work, and often, in huge companies." And then, we felt that there was a lot of tension between these use cases. So for example, the ideal file server replacement for an IT admin is going to look quite different from the ideal consumer photo sharing app. And we also recognize things like, "Well, we're going to be competing in many cases with the device, or the operating system."
(00:17:22):
When you look at something like iCloud, it's like, "Yeah. When you turn on your iPhone for the first time, it's probably not going to give you an ad for Dropbox." So we're like, "Hey, we need to address some of these issues," and expanded to some new areas to diversify. The first two things we did were, after getting enough complaints from IT administrators asking us what the hell these photo sharing features were for, we pulled all the photo sharing functionality out into a separate and new app we called Carousel. Where the basic value prop was phones, to that point, were limited in their storage by the amount of physical storage on the device.
(00:18:00):
We're like, "This is silly. You should be able to have your whole life in your pocket." So be able to store everything in the cloud, but have the experience be as if everything were locally there through a lot of caching, and sleight of hand, and thumbnails, and things like that. So there's much engineering there. And then, secondly, we saw people were using us at work, and we're like, "Well, there's a lot of different adjacent workflows." And there was a startup called Mailbox that built the first great mobile email client. Had a lot of funny parallels. They had a [inaudible 00:18:26]-

**中文翻译:**
是的。也许第一时代的结束，也就是我们“青少年时期”的开始，是在 2013 或 2014 年左右。甚至在那之前，2011、2012 年，我们开始面对所有的老牌巨头，或者说所有的大型平台公司。苹果、微软、谷歌，他们都以某种形式推出了竞争产品。但奇怪的是，这就像你看到远处有蘑菇云的视频：你能看到它，但你听不到声音，也察觉不到。所以大部分时间看起来就像什么都没发生一样。
(00:15:27):
2011 年史蒂夫·乔布斯在台上发布 iCloud 时，点名提到 Dropbox，说它将被视为过时的东西。同样地，我们一直觉得自己处在谷歌发布 Google Drive 的阴影之下，而关于 Google Drive 的传闻在我们创办公司之前就有了。在最初的几年里，我们只是在发抖，等着另一只靴子落地。产品发布了，但你永远无法从我们的数据中看出那是哪天发生的。媒体经常把竞争写得像“散弹枪射击”一样猛烈。
(00:16:06):
但后来我才明白，竞争更像是一条“大蟒蛇”（boa constrictor，指缓慢勒死对手）。第一章的结束最终让我们意识到，作为一种“面向所有人”的产品，我们获得了很多好处。事实上，在早期我很难描述 Dropbox 是给谁用的，或者它是做什么的。它类似于“电话是干什么的”或“电脑是干什么的”。起初，这是一种福气，意味着病毒循环非常有效。几乎你遇到的每个人都有类似 Dropbox 的需求，无论是个人需求、工作需求，还是两者兼有。
(00:16:43):
但甚至在竞争出现之前我们就意识到：“嘿，人们主要把我们用于备份、备份设备或存储。人们用我们分享照片。人们把我们作为工作的协作空间，而且通常是在大公司里。”然后，我们感觉到这些用例之间存在很大张力。例如，IT 管理员理想中的文件服务器替代方案，与理想的消费者照片共享应用看起来会大不相同。我们也意识到：“好吧，在很多情况下，我们将与设备或操作系统竞争。”
(00:17:22):
当你看到像 iCloud 这样的东西时，你会想：“是的，当你第一次打开 iPhone 时，它可能不会给你弹 Dropbox 的广告。”所以我们觉得：“嘿，我们需要解决这些问题，”并扩展到一些新领域以实现多元化。我们做的前两件事是：在收到 IT 管理员足够的投诉，问我们这些照片共享功能到底是干什么用的之后，我们将所有照片共享功能抽离出来，做成了一个名为 Carousel 的独立新应用。其核心价值主张是：当时的手机存储受限于设备物理空间。
(00:18:00):
我们觉得：“这太傻了。你应该能把整个生活装进兜里。”所以要把所有东西存入云端，但通过大量的缓存、障眼法和缩略图等技术，让体验就像所有东西都在本地一样。这涉及很多工程工作。其次，我们看到人们在工作中使用我们，我们想：“好吧，有很多不同的相邻工作流。”当时有一家名为 Mailbox 的初创公司，开发了第一个伟大的移动端邮件客户端。有很多有趣的相似之处，他们也有一个 [听不清]-

---

### [00:18:26] Lenny Rachitsky

**English:**
Oh, that's right. They're famous for that waitlist.

**中文翻译:**
噢，没错。他们因为那个等待名单而闻名。

---

### [00:18:28] Drew Houston

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:18:28] Lenny Rachitsky

**English:**
That's a really good point.

**中文翻译:**
这确实是个很好的点。

---

### [00:18:29] Drew Houston

**English:**
Which was crazy.

**中文翻译:**
那太疯狂了。

---

### [00:18:30] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:18:30] Drew Houston

**English:**
And so we're like, "I don't know. Maybe this is going to be our Instagram," and so we bought those guys. And then 2014, I'm on stage painting this picture of Dropbox's future. I'm like, "We're going to help be the way that you remember your life. We're going to be your productivity. The new productivity suite on your phone," and all these things. But then it was this dissonance where there were so many things that were going right, and certainly the numbers, user numbers, revenue numbers. We were sort of accidentally cash flow positive maybe a year after launching.
(00:19:06):
It was also clear that winter was coming, or that things weren't exactly as they seemed. Then the start of the second chapter, 2015, I'd start to hear a louder set of critics inside, and outside the company. And I'd been thinking for a long time like, "All right, man, we're really fighting wars on all these very disparate fronts." We're with storage. We're competing with the device to back up the device with photo sharing, or competing with Facebook, Snap, Instagram, Google, Apple.
(00:19:47):
On productivity, we're competing with Microsoft, and Google. And then, there's a whole new cohort of companies like Slack. And then, there's this experience of one day I am standing on stage talking about how Carousel, and Mailbox, and everything are the future of the company. Less than a year later, Google Photos launches. And not only does it provide a lot of the same value, and in many ways very inspired by what we had done, but they also gave you free unlimited storage for life. Not just photos, but video.
(00:20:24):
And so they just totally nuked our business model in ways that were bad enough in terms of just their obvious impact, but even worse because it was so easily anticipated. So this became a very public, and personal embarrassment for me. How could we not have predicted that, or been out in front of that? And then, that started this period. I'd say that was the beginning of chapter two where it was we went from the company that could do no wrong to the company that could do no right, which was a big flip. It was probably early summer, maybe late spring, when Google Photos launched.
(00:21:10):
At first, I'm just thinking like, "Okay. This was a big miss on my part. How do we get out of this? We need to tackle some of these competitive issues much more ahead on." And then, what's the problem? Well, the problem is that every incumbent is going to copy your product. They're going to bundle it with our platforms, and then they're going to kill the economics. And that was clear what was going to happen with Google Photos. It was very similar product experience bundled with Android, bundled with all of Google's different touch points, and then free.
(00:21:51):
So that was problematic enough for Carousel, but I'm like, "Wait, this is going to happen with everything that we're doing. Same thing with Mailbox." I had even pitch the founders to join Dropbox by saying, "Look, you're going to wake up tomorrow, and Gmail, and Apple Mail, and everything is just going to have these swipes and snoozes. The UI, it's not a durable source of advantage. We'll buy that problem from you."
(00:22:19):
And that's exactly what happened. So I'm like, "All right. Even in theory, how do we deal with this?" And I'd gotten the criticism over the years that Dropbox is a commodity, and investors in the early days would be like, "Hey, this is kind a graveyard of a space, and DOA." And I thought, "Well, how do other companies deal with this kind of competition, and commodities?" So there's a great book by AG Lafley and Roger Martin called Playing to Win.

**中文翻译:**
所以我们想：“我不知道，也许这会成为我们的 Instagram，”于是我们收购了他们。2014 年，我在台上描绘 Dropbox 未来的蓝图。我说：“我们将成为你铭记生活的方式。我们将成为你的生产力工具，你手机上全新的生产力套件，”诸如此类。但随后出现了一种不和谐感：虽然有很多事情进展顺利，尤其是数据、用户数、收入。我们在发布大约一年后就“意外地”实现了现金流转正。
(00:19:06):
但同样明显的是，寒冬将至，或者说事情并不像表面看起来那样。然后是第二章的开始，2015 年，我开始听到公司内外越来越大的批评声。我思考了很久：“好吧，伙计，我们真的在这些截然不同的战线上作战。”在存储领域，我们与设备竞争备份功能；在照片共享领域，我们与 Facebook、Snap、Instagram、谷歌、苹果竞争。
(00:19:47):
在生产力领域，我们与微软和谷歌竞争。然后，还有像 Slack 这样的一批新公司。接着发生了这样的事：前一天我还站在台上谈论 Carousel、Mailbox 以及一切如何代表公司的未来；不到一年后，Google Photos 发布了。它不仅提供了很多相同的价值，而且在很多方面都深受我们所做工作的启发，更重要的是，他们还提供了终身免费的无限存储空间。不仅是照片，还有视频。
(00:20:24):
所以他们完全摧毁了我们的商业模式，其显而易见的影响已经够糟了，但更糟的是，这原本是很容易预见到的。这对我来说成了一个非常公开且个人的尴尬。我们怎么可能没有预见到这一点，或者没有走在前面呢？于是，这段时期开始了。我会说那是第二章的开始，我们从一家“不会犯错的公司”变成了“做什么都不对的公司”，这是一个巨大的反转。Google Photos 发布时大概是初夏，也可能是晚春。
(00:21:10):
起初，我只是在想：“好吧，这是我的重大失误。我们该如何摆脱困境？我们需要更正面地解决这些竞争问题。”那么，问题是什么？问题是，每一个老牌巨头都会抄袭你的产品，他们会把产品与自己的平台捆绑，然后摧毁经济效益。Google Photos 的情况很明显：非常相似的产品体验，捆绑在 Android 中，捆绑在谷歌的所有触点中，而且免费。
(00:21:51):
这对 Carousel 来说已经够成问题了，但我心想：“等等，这会发生在我们做的每一件事上。Mailbox 也是一样。”我甚至曾劝说 Mailbox 的创始人加入 Dropbox，我说：“听着，你明天醒来，Gmail、Apple Mail 和所有东西都会有这些滑动和推迟功能。UI 并不是持久的竞争优势。我们把这个难题从你手里买过来。”
(00:22:19):
事实也确实如此。所以我心想：“好吧，即使在理论上，我们该如何应对？”这些年来我一直听到批评说 Dropbox 是一种大宗商品（commodity），早期的投资者会说：“嘿，这个领域简直是坟场，一出生就死（DOA）。”我想：“那么，其他公司是如何处理这种竞争和大宗商品的？”当时有一本 AG Lafley 和 Roger Martin 写的很棒的书，叫《赢在战略》（Playing to Win）。

---

### [00:22:53] Lenny Rachitsky

**English:**
Roger's been on the podcast.

**中文翻译:**
Roger 上过这个播客。

---

### [00:22:54] Drew Houston

**English:**
Yeah. I'm a huge fan of Roger's. And I was like, "All right. Well, if we think we're selling a commodity, try literally selling paper towels." Which is what AG, and Procter & Gamble, and a lot of CPG companies do. And AG was the CEO of Procter & Gamble at the time. And basically, he and Roger did this download of how they think about competition, and markets, and advantage. And a lot of it's thinking really critically about where do you play, and how do you win?
(00:23:28):
So being very selective about the markets you're in, and only being in markets where you can have a leadership position. And then, being really crisp about what is your leadership position? And so that was a very timely thing to read in terms of, "All right. Dropbox looks like one product, but it's really participating in many different markets. And our big risk might be that we're the number two best thing in each of those markets, which would be a bad situation."
(00:23:55):
Another really influential book was Only the Paranoid Survive by Andy Grove, and I'd been a big fan of Andy's. High Output Management is another great book of his, which was my introduction to management. At least, his theory of management. So just loved that book. And then Only the Paranoid Survive talks about Intel's experience where they actually had something like this happen that I wasn't aware of, and we all know Intel as the microprocessor company, Intel Inside. At least in the 80s, 90s.
(00:24:27):
But before, they were in microprocessors. They sold memory, RAM. In the 70s, they were running into a situation where they were really high growth, successful business selling memory. But then, they had these Japanese competitors that were just building memory faster, better, cheaper. Just on every dimension. And potentially, also, things like anti-competitive things where the government might be subsidizing these manufacturers. This feeling not only they might just be better at the game, but there's also not a level playing field.
(00:25:05):
But meanwhile, you wouldn't see it in their numbers. They're still growing. And just that there were these weird dissonant experiences where salespeople just suddenly have problems selling into accounts that used to be a slam dunk, or things that used to work just stop working. And this happens. Blackberry's, and Nokia's best sales years happened in the years after launching the iPhone. So these things don't actually change immediately. And so Andy labeled these moments strategic inflection points for a company, and I'm like, "Yeah. Then, we're definitely in a strategic inflection point."
(00:25:40):
But they were dealing with, "Oka., our whole business is memory. How do we deal with this competition?" And there's this little vignette where he and Gordon Moore, one of the other co-founders of Intel, said, "Hey, let's pretend we're consultants to ourselves. What would we do?" And what they immediately decided was, "Oh, well, we clearly get out of the memory business, and put all of our chips on this sketchy little microprocessor thing that was much smaller. But very high growth, and potentially big market." And then they're like, "Well, why don't we do that?"
(00:26:10):
Only problem with that is it's like Google saying, "Yeah. Let's get out of search, and go all in on Gmail, or something, or YouTube." So it just seemed insane. Andy cautions in the book that, "Look, most of the time CEOs want options. They want to hedge their bets, but what you really want to do in these strategic inflection points is go all in one thing." Or as Mark Twain put it, "Put all your eggs in one basket, and watch that basket." And I was like, "All right. This makes sense to me, but man, this is going to be painful." So we go away for 4th of July. I'm with my family in New Hampshire. I reread the book, I come back. All right. I'm like, "Well, we really got to do it." Then, I just killed Carousel, killed Mailbox. Went all in on productivity...

**中文翻译:**
是的，我是 Roger 的超级粉丝。我想：“好吧，如果我们觉得自己是在卖大宗商品，那就想想字面意义上的卖纸巾吧。”这正是 AG、宝洁（P&G）和很多快消品（CPG）公司所做的。AG 当时是宝洁的 CEO。基本上，他和 Roger 深入探讨了他们如何思考竞争、市场和优势。其中很大一部分是批判性地思考：你在哪里竞争（Where do you play），以及你如何获胜（How do you win）？
(00:23:28):
所以要对你进入的市场非常有选择性，只进入那些你能占据领导地位的市场。然后，要非常明确你的领导地位是什么。在那个时间点读到这些非常及时，我想：“好吧，Dropbox 看起来像是一个产品，但它实际上参与了许多不同的市场。我们最大的风险可能是我们在每个市场都只是‘第二好’的东西，那将是一个糟糕的局面。”
(00:23:55):
另一本非常有影响力的书是安迪·格鲁夫（Andy Grove）的《只有偏执狂才能生存》（Only the Paranoid Survive）。我一直是安迪的超级粉丝。他的另一本名著《高产出管理》（High Output Management）是我管理的启蒙书，至少是他的管理理论。我非常喜欢那本书。而《只有偏执狂才能生存》讲述了英特尔的经历，他们实际上也发生过类似的事情，而我以前并不知道。我们都知道英特尔是一家微处理器公司，“Intel Inside”，至少在 80、90 年代是这样。
(00:24:27):
但在进入微处理器领域之前，他们是卖内存（RAM）的。在 70 年代，他们卖内存的业务增长非常快，非常成功。但随后，他们遇到了日本竞争对手，这些对手制造内存的速度更快、质量更好、价格更低。在每一个维度上都是如此。而且可能还存在反竞争行为，比如政府可能在补贴这些制造商。这种感觉不仅是对手可能更擅长这个游戏，而且竞争环境也不公平。
(00:25:05):
但与此同时，你从他们的数据中看不出问题，他们仍在增长。只是会出现一些奇怪的不和谐体验：销售人员突然发现，以前轻而易举就能拿下的客户现在很难搞定，或者以前行之有效的方法突然失效了。这种情况确实会发生。黑莓和诺基亚销售额最高的年份，其实是在 iPhone 发布后的几年。所以这些事情并不会立即改变。安迪将这些时刻称为公司的“战略转折点”，我想：“是的，我们肯定处于一个战略转折点。”
(00:25:40):
但他们当时面临的是：“好吧，我们的整个业务都是内存。我们该如何应对这种竞争？”书里有一个小片段，他和英特尔的另一位联合创始人戈登·摩尔（Gordon Moore）说：“嘿，让我们假设我们是自己的顾问。我们会怎么做？”他们立即决定：“噢，那我们显然会退出内存业务，把所有的筹码都押在这个当时还不太起眼、规模小得多的微处理器上。虽然它很小，但增长极快，且潜力巨大。”然后他们想：“那我们为什么不现在就这么做呢？”
(00:26:10):
唯一的问题是，这就像谷歌说：“是的，让我们退出搜索业务，全力投入 Gmail 或 YouTube 之类的。”这看起来简直疯了。安迪在书里警告说：“看，大多数时候 CEO 都想要选择权，他们想要对冲风险，但在这些战略转折点，你真正需要做的是全力以赴做一件事。”或者正如马克·吐温所说：“把所有的鸡蛋放在一个篮子里，然后看好那个篮子。”我想：“好吧，这对我来说很有道理，但天哪，这会很痛苦。”于是我们在 7 月 4 日放假。我和家人在纽黑文，我重读了那本书，回来后，我想：“好吧，我们真的得这么做。”然后，我关掉了 Carousel，关掉了 Mailbox，全力投入到生产力工具上……

---

### [00:27:00] Drew Houston

**English:**
Killed mailbox, went all in on productivity. To some extent, that was a relatively easy decision because most of our subscribers, 80% of people paying for Dropbox were using it at work. But that meant foreclosing on photo sharing and consumer and storage and all these things that Dropbox had become synonymous with and to this day are some of the things that we're most recognized for. And I wish I could say then everything got better. It was the opposite, actually, the narrative completely flipped on the company. The press started, we killed these new products, and then internally and externally, the narrative became super negative. Articles would come out every week or two, like, oh, Dropbox could be the first dead deck of corn. And then sometimes we've all seen this in tech companies get in this washing machine of self-perpetuating negative press. And if it goes deep enough, I mean, Uber had this for a while later, Meta's had this over their history, lots of companies where you just can't get the monkey off your back.
(00:28:06):
And then because what the reporters end up doing is they basically park their metaphorical van behind your office. They interview all the people that you just fired and then print everything that they say anonymously as if it were facts. And there's a lot of truth to what the press were saying, so I can't really blame them or saying they were being unfair, but it immediately put recruiting into this deep freeze. You're just in the situation. You've started this company, it's been super successful, and then suddenly your employees don't want to wear your T-shirt anymore. And frankly, you don't even want to wear your T-shirt anymore. It's just your pride in your own company takes a big hit.
(00:28:50):
And meanwhile, I've talked mostly about the external market competitive forces, but inside the company was a mess too. The business's revenue had scaled so much faster than our ability to hire and build the right infrastructure and operations internally. And so everybody's just panicking and being like, "All right, well good, Drew, we're not doing Carousel, we're not doing Mailbox. What are we doing?" And the truth was like, if I knew the answer to that, we would be doing it, but it's just this is going to take some time to figure out. So it was pretty tough when everybody's looking to you as the founder and CEO looking for quick fixes and answers, and also just wondering, how the hell did you get us in this situation?

**中文翻译:**
关掉了 Mailbox，全力投入生产力工具。在某种程度上，这是一个相对容易的决定，因为我们大部分的订阅用户，80% 的付费用户都是在工作中使用 Dropbox。但这意味着要放弃照片共享、消费者存储以及所有那些 Dropbox 已经成为其代名词的东西，直到今天，这些仍是我们最广为人知的标签。我真希望我能说在那之后一切都变好了。事实恰恰相反，关于公司的舆论完全反转了。媒体开始报道我们砍掉了这些新产品，随后公司内外，舆论变得极其负面。每隔一两周就会有文章出来，比如：“噢，Dropbox 可能会成为第一个死掉的‘十角兽’（dead decacorn，估值超百亿美元的公司）。”有时我们都见过这种情况，科技公司陷入了这种自我循环的负面舆论“洗衣机”里。如果陷得足够深，我是说，后来的 Uber 经历过，Meta 在历史上也经历过，很多公司都无法摆脱这种困扰。
(00:28:06):
然后，记者们所做的就是把他们隐喻中的“采访车”停在你的办公室后面。他们采访所有你刚解雇的人，然后把他们匿名说的每一句话都当作事实印出来。媒体说的很多话其实是有道理的，所以我不能真的责怪他们或说他们不公平，但这立即让招聘陷入了冰封期。你就处在那种境地：你创办了这家公司，它曾超级成功，然后突然间你的员工不想再穿公司的 T 恤了。坦白说，你甚至自己都不想穿了。你对公司的自豪感遭受了沉重打击。
(00:28:50):
与此同时，我刚才主要说的是外部市场竞争力量，但公司内部也是一团糟。业务收入的增长速度远远超过了我们招聘和建立内部基础设施及运营的能力。所以每个人都在恐慌，在想：“好吧，Drew，我们不做 Carousel 了，不做 Mailbox 了，那我们到底要做什么？”而事实是，如果我知道答案，我们早就去做了，但这需要时间去摸索。所以当每个人都看着你这个创始人兼 CEO，寻求快速解决方案和答案，同时还在心里嘀咕“你到底是怎么把我们带进这种境地的”时，那种感觉真的很难受。

---

### [00:29:36] Lenny Rachitsky

**English:**
Wow. So we're going to talk about how you're actually turning things around and the work you're doing now, learning from this experience. But I have a lot of questions about this part of the journey.

**中文翻译:**
哇。所以我们待会儿会聊聊你实际上是如何扭转局面的，以及你现在正在做的工作，还有从这段经历中学到的教训。但关于这段旅程，我还有很多问题。

---

### [00:29:45] Drew Houston

**English:**
Yeah, yeah.

**中文翻译:**
好的，好的。

---

### [00:29:46] Lenny Rachitsky

**English:**
Just to almost summarize the journey, it's like launch, killing it, viral, find all these opportunities, find all these big markets. You start three different product lines. There's the enterprise use case, there's the consumer file storage use case, there's photo sharing, there's productivity, and then basically every big incumbent's like, okay, great, we're going to come eat your lunch. And you end up fighting wars on three or four fronts against the big kahunas that have infinite cash and can do whatever they want. It's interesting the way you described the Apple launch of just like it was this mushroom cloud you didn't quite see for a while, but the Google Photos launch was like, okay, that was more clear of like, okay, this is bad news. I know it's always easy in hindsight of like, oh, I should have done something different when Apple launched this thing. But is there anything maybe you could have done, or was it even possible to have adjusted course at that point? Or was it like, okay, this is tough and we need time to figure it out?

**中文翻译:**
简单总结一下这段旅程：发布，势如破竹，病毒式增长，发现所有这些机会，发现所有这些大市场。你开始了三条不同的产品线：企业用例、消费者文件存储、照片共享、生产力工具。然后基本上每个大巨头都说：好极了，我们要来抢你的生意了。你最终在三四个战线上与那些拥有无限现金、随心所欲的大佬们作战。你描述苹果发布会的方式很有趣，就像一朵你暂时没看到的蘑菇云，但 Google Photos 的发布就很明确了：好吧，这是个坏消息。我知道事后诸葛亮总是很容易，比如“当苹果发布那个东西时，我本该做点不同的事”。但当时有没有什么是你本可以做的，或者在那时调整航向是否可能？还是说，当时的情况就是“好吧，这很艰难，我们需要时间来解决”？

---

### [00:30:45] Drew Houston

**English:**
Well, we panicked about the Apple thing too, because that also, that created a much smaller version of the tempest in a teapot that the Google Photos did. It was just much less public. Or it was just less obvious that we would be so out position. And actually we were more surprised to the upside when it's Google Drive launches, iCloud launches, OneDrive launches. And even as they build version two that we just didn't really notice that much of a problem. And I also studied over the years what happened in Netscape and companies like [inaudible 00:31:27] MySpace or these other cautionary tales. And interestingly, Internet Explorer was a thing that eventually undermined Netscape enough to permanently throw it into a negative trajectory. But Internet Explorer 1.0, 2.0, even maybe 3.0 just weren't that good and didn't really do anything but Internet Explorer 4.0, 5.0 and all the bundling, that really made a big difference, or big negative difference.
(00:31:55):
And then another thing that was interesting was, so there's a big time lag where between when these products launch and when they actually have an impact, because often it's not so much the existence of the product or it's availability, it's the constant bundling or the constant iteration, or it's the boa constrictor, in any given second, it's not much tighter, but over the following day, you're in a bad place.
(00:32:24):
But another thing that was interesting was one cool thing that we got to do and moving to California is you get to actually meet people who had been at these companies. And one of those people was a guy named Bill Campbell who was at Netscape during that whole period, and I had asked him, I'm like, "Man, that's really unfair. That sucks what happened with Microsoft and bundling with Windows and all these things and the antitrust and this and that." And he's looked at me, he laughed at and snorted and he's like, "Microsoft did not kill us. We killed ourselves." And so that was the other half of what was the problem within Dropbox was a lot of our wounds were self-inflicted in that we were struggling to keep scaling and launching all these products. And the Dropbox products had stagnated.
(00:33:25):
And I started to learn the hard way that, okay, yeah, I now understand what Bill is talking about, because we were hiring all these smart people, but the things we would do as a company would seem really stupid. And then some of these things were me personally, like yeah, I knew about from reading all these different things, but for whatever reason, I guess we just kept going anyhow. We were just too confident in our ability to respond, or we got lulled into this complacency, we were like, " Oh, well." Because it hasn't been a problem, it won't be a problem in the future.
(00:34:03):
But I'd say there's something about the Google Photos launch that just really set things off kilter. And then also for me personally, I think, I'd go from feeling good but stressed out all the time to mostly feeling bad all the time. And I just remember leaving, really trying to get away from the office for a little bit during this period, picked my teeth up off the ground. And the good news, I bought a place in Hawaii, so I was doing that in Hawaii, but didn't feel very good in any way.
(00:34:42):
And then I learned. I had to really figure out a lot of different things for myself to be the leader that could get us through this. Because mostly what I felt was like, man, I felt like we'd been doing such a good job, but now, man, if I really screw this up, or maybe I don't know what I'm doing. And then I had to really reset on a number of fronts. One is I just remember thinking my 18-year-old self would be like, what the hell are you complaining about? You did it. This is so great, and yet I felt so bad about things. And so I'm like, yeah, both of those things are true. How do I navigate that? And I think one part that was really helpful is getting a sense of equanimity basically, and doing a lot around mindfulness and meditation to distance... One thing that happens when you're a founder and your company succeeds is your identity is fused with the company. And so it's easy to get into a situation where you only feel good if the company's... Or how you feel is how the company is doing, and you need to separate that a little bit. So what that looked like for me is recognizing, yeah, there's really not an easy button that keeps things up and to the right forever. And most of the entrepreneurs that are my heroes had various periods of wandering in the desert. Those things instead of just being problems were probably the crucible that forged the people that they became. So the presence of badness is not necessarily you are bad. And it's like, yeah, now you're just getting your stripes as an entrepreneur.
(00:36:41):
And people were really helpful during that period. So I mentioned Bill Campbell. He was nice enough that we just stayed in touch and he would take me out to dinner every now and then. And I would be freaking out, but I was always surprised he'd never seemed to be freaking out. And mostly he'd just be saying like, all right, he'd dust you off and smack you and say, get your ass back out there. And he was literally a coach of the Columbia football team in addition to being a great technology executive and advisor to many of the great founders that I looked up to. He was really helpful because he helped me believe in myself even when I wouldn't believe in myself. And then people like Andy Grove who had written all these books, I'm like, well, at least I'm having this problem. But yeah, then that raised a question for me. I'm like, okay, I've been through this chapter one where everything's up and to the right, but I ran out of merit badges or Xbox achievements to collect. I was like, we did it. We got the product to this many users, we got it to where we got this valuation, or let me back up. So my whole life, or it's common, I think for a lot of founders, especially if you get good grades and stuff, you follow pretty linear path from childhood, from first get the right test scores, then get into the right college, get into the right college, take the right classes, get the right internship, get the right job. And early startup life is like that a lot. It's like, okay, have an idea. Find a co-founder, get into Y Combinator, get funding from Sequoia.
(00:38:22):
Watch an MVP just in 10 million, a hundred million, billion valuation. And I felt like we'd cleared all that. And so actually one of the other problems was, I don't even know what Dropbox needs to be and I don't even know what I need that I want to be in the world. And so part of this was also reconnecting to some kind of sense of purpose, because if I was really honest with myself, I was like, well, I'm just checking boxes and advancing and leveling up like a video game or something, but now I'm here. I'm like, all right, is it just big numbers bigger? It's also not that fun to just launch something that you put your soul into and then just have it get crushed with these competitors. It's even worse when you're bringing all these hundred other people who worked on that thing through that meat grinder too.
(00:39:10):
So are we just inventing things 10 minutes before Google and Apple do? If not, what are we doing? And then if we're really, really honest with ourselves, I think it's hard to argue that no one would've invented cloud photo gallery that wasn't constrained to your local storage. So I had to really rethink what does the company need to do. That actually took a longer time to answer than I wanted, but then also just what do I want to do? And I was like, well, you know what? I'm going to do this.
(00:39:45):
What I ended up settling on was like, look, coming back to my 18-year-old self, I was like, all right, stop complaining. This is a pretty good situation. You wanted something where the learning curve would be steep. Here it is. You get to do this really meaningful work to build things for millions of people, work with awesome teammates. There's always good things about it, and you've chosen this life, so stop complaining about the burdens because it's really dangerous if you start to resent the job or feel like a victim because that's just corrosive to everything else that you can get in this spin cycle.

**中文翻译:**
其实我们也对苹果的事感到恐慌，因为那也引发了一场小规模的“茶壶里的风暴”，就像 Google Photos 那样，只是没那么公开。或者说，我们当时没那么明显地意识到自己会处于如此不利的地位。实际上，当 Google Drive、iCloud、OneDrive 发布时，我们反而对结果感到惊喜，甚至当他们推出第二版时，我们都没觉得有什么大问题。这些年来我也研究过 Netscape 的遭遇，还有像 [听不清] MySpace 或其他前车之鉴。有趣的是，Internet Explorer 最终削弱了 Netscape，使其永久陷入负面轨道。但 IE 1.0、2.0 甚至 3.0 其实并没那么好，也没起什么作用，直到 IE 4.0、5.0 以及各种捆绑销售，才真正产生了巨大的负面影响。
(00:31:55):
另一件有趣的事是，这些产品发布到产生实际影响之间有很大的时间滞后。因为通常起作用的不是产品的存在或可用性，而是持续的捆绑、持续的迭代。就像大蟒蛇一样，在任何一秒钟它都没有勒得更紧，但过了一天，你就陷入绝境了。
(00:32:24):
还有一件有趣的事，搬到加州的一个好处是你可以真正见到那些曾在这些公司工作过的人。其中一位是 Bill Campbell，他在 Netscape 经历过整个时期。我曾问他：“伙计，那太不公平了。微软通过 Windows 捆绑销售，还有反垄断调查之类的，那太糟糕了。”他看着我，嗤笑了一声说：“微软没有杀掉我们，是我们杀掉了自己。”这就是 Dropbox 内部问题的另一半：我们的很多伤口是自找的，因为我们当时在苦苦支撑规模扩张并发布所有这些产品，而 Dropbox 的核心产品却停滞不前了。
(00:33:25):
我开始通过惨痛的教训明白 Bill 在说什么。因为我们雇佣了所有这些聪明人，但我们作为一家公司所做的事情却显得非常愚蠢。其中一些是我个人的问题，比如，是的，我通过阅读了解了各种理论，但出于某种原因，我想我们还是照旧进行下去了。我们对自己的应对能力过于自信，或者陷入了这种自满情绪，觉得：“噢，好吧，既然以前没出问题，以后也不会出问题。”
(00:34:03):
但我想说，Google Photos 的发布确实让一切都乱了套。对我个人而言，我从感觉良好但压力山大，变成了大部分时间都感觉很糟。我记得那段时间我真的想离开办公室一会儿，去“捡起被打掉的牙齿”。好消息是我在夏威夷买了个房子，所以我是在夏威夷疗伤的，但无论如何感觉都不好。
(00:34:42):
然后我明白了，我必须为自己理清很多事情，才能成为那个能带领我们度过难关的领导者。因为我当时最大的感受是：“天哪，我觉得我们一直做得很好，但现在，如果我真的搞砸了，或者也许我根本不知道自己在做什么。”我必须在多个方面重新开始。首先，我记得我在想，18 岁的我会说：“你到底在抱怨什么？你做到了，这太棒了。”然而我却感觉非常糟糕。所以我对自己说：“是的，这两件事都是真的。我该如何应对？”我觉得非常有帮助的一点是获得一种“沉着感”（equanimity），通过正念和冥想来拉开距离……当你是创始人且公司成功时，你的身份会与公司融合。所以很容易陷入一种境地：只有公司好你才感觉好，或者你的心情完全取决于公司的表现。你需要把这两者分开。对我来说，这意味着意识到：确实没有一个“简易按钮”能让事情永远一路向上。我心目中英雄般的企业家大多经历过“在荒漠中徘徊”的时期。这些经历不仅不是问题，反而可能是锻造他们的熔炉。所以，糟糕情况的存在并不代表你这个人很糟糕。这只是你作为企业家在“晋级”过程中必须经历的磨炼。
(00:36:41):
在那段时期，人们给了我很大帮助。我提到了 Bill Campbell。他非常友善，我们一直保持联系，他偶尔会带我出去吃饭。我当时吓坏了，但我总是惊讶于他似乎从未惊慌失措。他大多只是说：“好吧，”然后拍拍你，让你振作起来，说：“滚回战场去。”他曾是哥伦比亚大学足球队的教练，同时也是伟大的科技高管，还是许多我仰慕的伟大创始人的顾问。他非常有帮助，因为即使在我都不相信自己的时候，他也能帮我重拾信心。还有像安迪·格鲁夫这样写了这么多书的人，我想：“好吧，至少我也遇到了这种问题。”但随后这给我提出了一个问题：我已经度过了第一章，一切都一路向上，但我已经拿完了所有的“功勋章”或 Xbox 成就。我想：“我们做到了，产品有了这么多用户，达到了这个估值。”或者让我退一步说：我的一生，或者对很多创始人来说都很常见，尤其是如果你成绩好，你会走一条非常线性的道路：先拿到好的考试分数，然后进入好的大学，选好的课，拿好的实习，找好的工作。早期创业生活也是如此：有个想法，找个合伙人，进 YC，拿红杉的钱。
(00:38:22):
看着 MVP 达到 1000 万、1 亿、10 亿的估值。我觉得我们已经完成了所有这些。所以实际上另一个问题是：我甚至不知道 Dropbox 应该成为什么，我甚至不知道我想在这个世界上成为什么样的人。所以这部分也是为了重新连接某种使命感。因为如果我对自己诚实，我会觉得：“好吧，我只是在像玩游戏一样打怪升级、完成任务，但我现在到了这里，难道只是为了让数字变得更大吗？”而且，投入灵魂去做一件事，然后看着它被竞争对手碾碎，这并不好玩。更糟糕的是，你还带着一百个为此努力的人一起进入这个“绞肉机”。
(00:39:10):
所以，我们只是在谷歌和苹果行动前 10 分钟发明东西吗？如果不是，那我们在做什么？如果我们对自己非常诚实，我认为很难反驳说，如果没有我们，别人就不会发明不限于本地存储的云端相册。所以我必须重新思考公司需要做什么。这花了我比预期更长的时间去回答。然后还有：我想做什么？我想：“你知道吗，我要做这件事。”
(00:39:45):
我最终确定的想法是：看，回到 18 岁的我，我会说：“行了，别抱怨了。这已经是很棒的处境了。你想要陡峭的学习曲线，现在它就在这儿。你可以做非常有意义的工作，为数百万人打造产品，与优秀的队友共事。这其中总有美好的一面。你选择了这种生活，所以别再抱怨负担了，因为如果你开始怨恨这份工作或觉得自己是受害者，那是很危险的，那会腐蚀你在这种循环中能得到的一切。”

---

### [00:40:20] Lenny Rachitsky

**English:**
What helped you come to that place? Because that sounds like a very hard place to get to and a very important place. Was that Bill Campbell advice? How long did it take you to go from this is not going well and life sucks to, okay, let's look at it this way?

**中文翻译:**
是什么帮助你达到那种心态的？因为那听起来是一个很难达到但又非常重要的地方。是 Bill Campbell 的建议吗？你花了多长时间才从“事情进展不顺，生活一团糟”转变为“好吧，让我们换个角度看问题”？

---

### [00:40:35] Drew Houston

**English:**
I think there were a couple unlocks that were pretty fast, but I think again, this was not like, oh, then I felt better and we lived happily ever after at all. There were some moments of recognition where I was able to, I always try to get away from the mayhem or the whirlwind and recenter myself and do think weeks and things like that. And so those were really helpful because I felt when I diagnosed, well, when I'm on this treadmill and just firefighting or how did I miss this important thing? It's like, well, basically the root causes of being on the treadmills, I was too busy firing to aim, and then I thought I would do my aiming on vacations and things like that. But no, I need to get off the treadmill every now and then and make the space to really address some of these bigger questions.
(00:41:31):
Because it's not like I didn't forget about them. They just were always below the fold on my to-do list to deal with. And then until a few years go by and you're like, wait. Yeah, we really were just strategically out of position. The other way I came to some of these conclusions is a combination of things. So I think picking up a meditation or mindfulness practice, having therapists personally, having coaches, having friends and mentors, other founder friends. And so I wouldn't say it was any one thing, but I think you have to build this whole ecosystem of support around yourself and recognize no one's going to do that for you. And it's super important.
(00:42:12):
And then to Bill's other point, he was like, yeah, Microsoft wasn't killing us, we were killing ourselves, I think having to ask some hard questions to myself of, yeah, some of these wounds were self-inflicted. As much as there might be, I could look at this and say, oh, Microsoft is mean, or Google was mean, or Apple was mean, but I'm like, I drove the ship towards these rocks. So that's one downside of being founder, CEO. You can't blame the last guy. I think one of the big questions every founder has to figure out is not just, how do I have equanimity? What's my purpose? But then also, what am I doing that is destroying the company?
(00:42:57):
Because everybody's got strengths and weaknesses, but as CEO, both your strengths and your weaknesses are massively amplified and a lot of blind spots in your personality can become huge cultural dysfunctions in the company. And so step one to dealing with that is building awareness. And one thing that floated around the company for a while was the Enneagram, which on the surface is a personality typing thing like Myers-Briggs. I often describe it as it's like Myers-Briggs, but actually useful. The way it works is it's a personality typing system. You get a number from one through nine that's your dominant... Or there's nine types that are numbered. It's similar to Myers-Briggs in that Myers-Briggs has 16 types of letters like ENFJ or different things. But I find that Myers-Briggs is more descriptive. So it tells you, okay, you're an introvert, not an extrovert or vice versa. You're judging instead of perceiving. But I could never really work out what that meant. And so it's descriptive versus predictive or causal.
(00:44:06):
Enneagram I find is the theory that is really about your fundamental motivations. What are you running towards and what are you running away from? And the theory goes through some combination of your wiring from your genetics and your early childhood. Your autopilot is fixed after your childhood in that you just have instinctive responses to things. Now it's autopilot. It doesn't mean it's your destiny. You could override it, but it's super important to become aware of what are you running from and towards. And the Enneagram gives you a really good map to do that.
(00:44:44):
And so I'm reading this book and it starts by you type yourself, and I'm rolling my eyes. I'm like, okay, I'm a seven. What's a seven? And then you read, each type has its own chapter and you read the chapter and I was like, oh my God, this completely describes who I am down to my core. And I was almost looking over my shoulder. Who the hell did this? I thought I was a special snowflake, but apparently not. Okay, I'm listening. And [inaudible 00:45:16] with a lot of my early coaching experiences, which are, you do a 360, your coach sits you down, they're like, here are your strengths. In my case, it would be things like, oh, you're really creative and you like new ideas. That's okay. And second, you really love people. You build great relationships with people. I'm like, okay. Uh-huh. Third, you're really comfortable in chaos and resilient. I was like, this coaching thing is great. See, yeah, that was my first coach. And then you flip to your development areas because no one calls them weaknesses.
(00:45:49):
It's like, all right, one is you're bored by routine and really undisciplined. Second is you're really conflict avoidant. And third is you're intuitive, but you're also pretty chaotic and don't create enough structure for people so they're mostly confused. And when you pair the two together, you're like, oh, wait. Yeah, I'm creative and like new ideas, but I'm bored by routine and I'm a bit of a space cadet. All right, you love good relationships with people, but you don't want to make them unhappy so you don't tell them the truth basically about things that are difficult to hear. And it's going to be a similar map of things depending on your personality type or circumstances. But the Enneagram was that map for me to be like, okay, I've got these things that are genuinely great, but I need to address these downsides of the company's conflict avoidant, so we're not telling the truth and then making a bunch of predictable mistakes, or I'm creating this really chaotic environment where people don't know what they're supposed to be doing.
(00:46:57):
That's a problem. My personality is quite directly, I'm going to torpedo the company unless I do something about it. The same is true for any founder. And I'm a type seven, it's the enthusiast. It's like, again, central casting is like a lot of new things and creative and love just interesting things. But then a space cadet, FOMO, some of the shadow side of it, and every type has a thing like that. So really understanding, okay then, I was also just frustrated in the day-to-day of my work, I'm like, yeah, I'm not really getting to do these creative things where I'm too busy firing to aim. I'm missing these bigger picture things that are really taking the ship way too close to the rocks. Okay. Then I need to then understand what those things are and either work on myself or hire the right people who don't have those issues or one way or another, just make it so the company is not so exposed to my personal dysfunction.
(00:47:56):
And so yeah, it was a whole constellation of things like that where it's like, all right, we have to get... I mean, after this whole tailspin, we got to work. I'm like, all right, first business issues. The most urgent issues were just blowing all this cash. We need to get the P&L to look a lot better and get out of this land grab mode or fighting with Google on giving more free storage away or just being in these fundamentally unprofitable things. And so we did that. We cut the unprofitable parts of the business. We turned cash flow positive in 2016, maybe several months after this reckoning, and that set the tracks for getting into a billion run rate in 2017, going public in 2018.
(00:48:40):
We had to come up with a new vision and mission for the company, which I'll maybe save for chapter three. And then I was also just trying to do things that helped sustain me through the difficult things. I'm like, well, I am an engineer. As a little kid, I was coding since childhood. I knew I wanted be a founder. I didn't know I wanted be a CEO, so I backed into being a CEO. And then, so I'm like, man, there's a lot of tedious things about being an executive. So I was like, I'm going to find ways to automate tedious parts of my job and learn machine learning in 2016 and '17, and that ended up being really important later on. But then also it's just coming to terms with my job and what I wanted to do from a personal perspective, which included things like, oh, I'm lucky in that being a CEO is, I always wanted a steep learning curve.
(00:49:33):
In a lot of professions like in sports or math or chess or certain academic fields, you peak in your twenties or thirties. CEO's not like that. You can go your whole life and still not be a master. So I'm like, for better or worse, it's pretty cool that I can do this kind of work. And then I don't really get that much out of just chasing bigger numbers. The thing that is my favorite thing about Dropbox is looking over someone's shoulder in Starbucks and seeing if the little Dropbox icon is there. Building something that becomes a verb, taking some of the pain out of technology, things like that. So really reorienting. Yeah, it's not about just the external scoreboard just much. It's more about the craft of being a great CEO and building things I'm really proud of or really making a difference. And so those kinds of things, none of them all coalesce. It's like this lens that slowly and stubbornly comes into focus, but making the time to have some of that reflection was super important.

**中文翻译:**
我觉得有几个关键点突破得很快，但再次强调，这并不是说“然后我就感觉好多了，从此过上了幸福生活”。有一些觉醒时刻，我总是试图逃离混乱或旋涡，重新找回自我，做一些“思考周”（think weeks）之类的事情。这些非常有帮助，因为当我诊断时发现，当我处在那种“跑步机”上不停救火时，我怎么会漏掉这么重要的事情？原因基本上是：我忙于开火而忘了瞄准。我原以为我可以在度假时瞄准，但不行，我需要时不时地离开跑步机，腾出空间来真正处理这些大问题。
(00:41:31):
因为我并不是忘了这些问题，它们只是总排在我的待办事项列表的最下面。直到几年过去，你才发现：“等等，我们在战略上真的完全偏离了位置。”我得出这些结论的另一种方式是多种因素的结合：开始冥想或正念练习，找私人心理医生，找教练，找朋友和导师，以及其他创始人朋友。所以我不会说这是某一件具体的事，但你必须在自己周围建立起一整套支持生态系统，并意识到没有人会替你做这件事，这超级重要。
(00:42:12):
回到 Bill 的另一点，他说微软没有杀掉我们，是我们杀掉了自己。我必须问自己一些尖锐的问题：是的，有些伤口是自找的。尽管我可以看这件事并说：“噢，微软很坏，或者谷歌很坏，或者苹果很坏，”但我意识到是我把船开向了礁石。这是作为创始人兼 CEO 的一个弊端：你不能责怪前任。我认为每个创始人必须弄清楚的大问题不仅是“我如何保持沉着？我的使命是什么？”，还有“我正在做的哪些事情正在摧毁公司？”
(00:42:57):
因为每个人都有优点和缺点，但作为 CEO，你的优点和缺点都会被无限放大，你性格中的很多盲点可能会变成公司巨大的文化功能障碍。处理这件事的第一步是建立觉知。公司里流传了一段时间的东西是“九型人格”（Enneagram），表面上它像迈尔斯-布里格斯（MBTI）那样的性格分类。我经常形容它像 MBTI，但真的有用。它的工作原理是一个性格分类系统，你会得到一个 1 到 9 的数字作为你的主导类型。它与 MBTI 相似，MBTI 有 16 种类型，如 ENFJ 等。但我发现 MBTI 更多是描述性的，它告诉你：好吧，你是个内向者而不是外向者，或者反之。你是判断型而不是感知型。但我永远无法真正理解那意味着什么。它是描述性的，而不是预测性或因果性的。
(00:44:06):
我发现九型人格理论真正关乎你的根本动机：你在追求什么，你在逃避什么？理论认为，通过遗传和早期童年的结合，你的“自动驾驶模式”在童年后就固定了，你对事物会有本能的反应。现在它是自动驾驶，并不意味着它是你的命运，你可以覆盖它，但意识到你在逃避什么和追求什么超级重要。九型人格为你提供了一张很好的地图。
(00:44:44):
我读那本书时，开始要给自己定型，我翻了个白眼。我想：“好吧，我是 7 号。7 号是什么？”然后你读每一章，读到那一章时，我心想：“天哪，这完全描述了核心的我。”我甚至回头看，到底是谁写的？我以为我是个独特的雪花，但显然不是。好吧，我听进去了。这与我早期的很多教练经验相吻合：你做一个 360 度评估，教练让你坐下说：“这是你的优点。”在我的案例中，可能是：“噢，你非常有创意，喜欢新点子。”这没问题。第二，“你非常热爱人类，能与人建立很好的关系。”我想：“好吧，嗯哼。”第三，“你在混乱中非常自在，很有韧性。”我想：“这教练课真不错。”那是我的第一个教练。然后你翻到“发展领域”，因为没人会称之为弱点。
(00:45:49):
它是这样的：第一，“你对常规感到厌倦，非常没有纪律。”第二，“你非常逃避冲突。”第三，“你很有直觉，但也相当混乱，没有为人们建立足够的结构，所以他们大多感到困惑。”当你把这两者结合起来看，你会发现：“噢，等等。是的，我有创意、喜欢新点子，但我讨厌常规，有点像个‘太空人’（space cadet，指心不在焉）。好吧，你喜欢与人保持良好关系，但你不想让他们不开心，所以你基本上不告诉他们那些难以启听的真相。”根据你的性格类型或情况，这会是一张类似的地图。但九型人格对我来说就是那张地图，让我意识到：“好吧，我有一些真正伟大的特质，但我需要解决这些负面影响：公司逃避冲突，所以我们不讲真话，然后犯下一堆可预见的错误；或者我创造了这个极其混乱的环境，人们不知道自己该做什么。”
(00:46:57):
那是个问题。我的性格非常直接地在“鱼雷攻击”公司，除非我做点什么。对任何创始人来说都是如此。我是 7 号，即“活跃型/热衷者”。典型特征是喜欢很多新事物，有创意，热爱有趣的事。但缺点是像个太空人、有 FOMO（错失恐惧症），以及一些阴暗面。每个类型都有类似的东西。所以真正理解了这一点后，我也对日常工作感到沮丧，我想：“是的，我没有真正去做这些创意的事情，因为我忙于开火而忘了瞄准。我错过了这些大局观的事情，这真的让船开得离礁石太近了。”好吧，那我需要理解这些事情是什么，要么改变自己，要么雇佣那些没有这些问题的人，或者以某种方式让公司不再那么容易受到我个人功能障碍的影响。
(00:47:56):
所以，这是一系列类似事情的集合。在经历了整个“尾旋”之后，我们开始工作。我想：“好吧，首先是业务问题。”最紧迫的问题是正在挥霍大量现金。我们需要让损益表（P&L）看起来好得多，退出这种“圈地模式”，或者不再和谷歌死磕免费存储，或者退出那些根本不赚钱的业务。所以我们这么做了。我们砍掉了不盈利的业务。我们在 2016 年实现了现金流转正，就在这次反思几个月后。这为 2017 年达到 10 亿美元的年化收入、2018 年上市铺平了道路。
(00:48:40):
我们必须为公司提出新的愿景和使命，这我可能会留到第三章讲。同时我也在尝试做一些能支撑我度过难关的事情。我想：“好吧，我是个工程师。我从小就开始写代码。我知道我想成为创始人，但我不知道我想成为 CEO，所以我是误打误撞成了 CEO。”然后我想：“天哪，当高管有很多乏味的事情。”所以我对自己说：“我要找到自动化工作中乏味部分的方法，并在 2016 和 2017 年学习机器学习。”这在后来变得非常重要。但同时，这也是在接受我的工作，并从个人角度思考我想做什么。这包括意识到：我很幸运，因为当 CEO 意味着我一直想要的陡峭学习曲线。
(00:49:33):
在很多职业中，比如体育、数学、国际象棋或某些学术领域，你在二三十岁就达到巅峰了。CEO 不是这样的，你可以做一辈子仍然不是大师。我想：“无论好坏，能做这种工作都很酷。”而且，我并不能从仅仅追求更大的数字中获得那么多。我最喜欢 Dropbox 的一点是，在星巴克从别人肩膀后面看过去，看看有没有那个小小的 Dropbox 图标。打造一个成为动词的产品，消除技术带来的痛苦，诸如此类。所以要重新定位：是的，这不仅仅关乎外部的计分板，更多关乎成为一名伟大 CEO 的手艺，打造让我真正自豪的东西，或者真正产生影响。这些事情并不是一下子全部发生的，它就像一个镜头，缓慢而顽固地变得清晰，但腾出时间来进行这种反思是超级重要的。

---

### [00:50:36] Lenny Rachitsky

**English:**
So much of what you're describing makes me think about founder mode in a lot of different ways. One is your point about how you didn't have a lot of time to think about where things might be going and how the markets are shifting, and that has to happen, basically, no one else is going to do that if it's not you. Also, just this idea of how much of the solution was you understanding yourself better, reflecting on where you have strengths and weaknesses. Also, I'll mention, so before I had Brian Chesky on the podcast, I asked you, "What should I ask Brian?" And you asked me to ask him basically about founder mode, which was the first time I think you talked about it, and now it's like this whole thing. So you've been in the middle of all that for a long time. I guess just any thoughts on the importance of that and how you think about that as a founder?

**中文翻译:**
你描述的很多内容让我想到了“创始人模式”（founder mode）的很多不同方面。一是你提到的，你没有太多时间思考事情的走向和市场的变化，而这必须发生，基本上如果不是你，没人会去做这件事。还有，解决方案中有很大一部分是你更好地了解自己，反思自己的优缺点。另外我想提一下，在我邀请 Brian Chesky 上播客之前，我问你：“我该问 Brian 什么？”你让我问他关于“创始人模式”的问题，我想那是你第一次谈到它，而现在这已经成了一个大热门话题。所以你一直处于这个话题的中心。我想知道你对它的重要性有什么看法，作为创始人你是如何思考它的？

---

### [00:51:19] Drew Houston

**English:**
So founder mode means a lot of things to a lot of people. So it's a bit of a Rorschach test, but I think parts of it that really resonate with me are, there's this evolution you go on as a founder where you don't know what you're doing and everything is new and unfamiliar. And then you're also very involved in all the details because there's no one else to be involved in the details. It's not like someone else is coding for you if you're just in your room at home. But then over time, you have to, there's this, Ben Horowitz calls it the Product-CEO Paradox, where the first way that companies die is from founders not letting go. And so you need to learn to scale yourself and hand off your responsibilities and operate at a higher level of abstraction. But then the second way that companies kill themselves is the founders get too far away.
(00:52:23):
And I felt like I had done that. That's a big part of the problem that led to a lot of this chaos at the end of chapter two, where I was like, oh, man, I'm on this treadmill. I'm doing stuff, but I'm clearly not setting the right direction. Or people are confused or it's not working, and I was too distant from the product. And then there's all kinds of issues you can get into as you hire an executive team and get that to function well. And so I think there's a debate to what extent founder mode is a mindset or a destination. To me, I think the destination part is pretty important. I think it's like after that learning journey, suddenly you have this conviction from actually knowing, from having lived experience and navigating a lot of these things where suddenly it's a lot clearer.
(00:53:10):
You don't have the same kind of confusion or learning curve problem. And then if you start out being too far leaned in, then you lean out too far. And I think a lot of that founder mode flip is when you're like, hey, this is not the company I want to be running. I need to be more involved. I need to stop making excuses. And basically, I also don't want to apologize or negotiate all the time for the kind of company that I want to be part of and run. So I had that too over time, maybe more towards a chapter three, some of those elements of... And I don't know if there's a way to get to this destination without some level of pain. Certainly the Elons and Steve Jobs of the world had big spans of wandering in the desert where they were not as cool as they are-

**中文翻译:**
“创始人模式”对不同的人有不同的含义，它有点像罗夏墨迹测试。但我觉得其中让我产生共鸣的部分是：作为创始人，你会经历一个进化的过程。起初你不知道自己在做什么，一切都是新鲜而陌生的。然后你会非常深入细节，因为没有别人去处理细节。如果你只是独自在房间里，没人会替你写代码。但随着时间的推移，你必须——本·霍罗维茨（Ben Horowitz）称之为“产品-CEO 悖论”——公司死掉的第一种方式是创始人不愿放手。所以你需要学习扩展自己，移交职责，并在更高的抽象层面上运作。但公司自杀的第二种方式是创始人离得太远了。
(00:52:23):
我觉得我当时就犯了那个错。那是导致第二章末尾许多混乱的一个重要原因。当时我想：“噢，伙计，我在跑步机上忙个不停，我在做事，但我显然没有设定正确的方向。”或者人们感到困惑，或者事情进展不顺，而我离产品太远了。当你雇佣高管团队并试图让他们良好运作时，你会遇到各种问题。所以我觉得关于“创始人模式”在多大程度上是一种心态或一个终点，还存在争论。对我来说，我觉得“终点”这部分很重要。就像在经历了那段学习旅程后，你突然有了一种信念，这种信念来自于真实的认知、生活经验和对许多事情的驾驭，突然间一切都变得清晰多了。
(00:53:10):
你不再有那种困惑或学习曲线的问题。如果你一开始介入太深，然后又退得太远，我认为很多“创始人模式”的反转发生在你意识到：“嘿，这不是我想经营的公司。我需要更多地参与。我需要停止找借口。”基本上，我也不想总是为了我想参与和经营的那种公司而道歉或不断妥协。随着时间的推移，我也经历了这些，也许更多是在第三章，其中一些元素……我不知道是否有一种方法可以在没有痛苦的情况下到达这个终点。当然，像埃隆（马斯克）和史蒂夫·乔布斯这样的人都经历过漫长的“荒漠徘徊期”，那时他们并不像现在这么酷——

---

### [00:54:00] Drew Houston

**English:**
... spans of wandering in the desert where they were not as cool as they are today. The things they were doing weren't working, and they managed things very differently in that sort of post wandering phase. Suddenly had this level of conviction, and intuition that they might not have had before, or they sanded down some of their more counterproductive instincts. Again, there's a lot of surface area.
(00:54:27):
I don't know if anybody has a common definition of founder mode, but certainly that evolution, the way I think about is it is very difficult. One of the hardest things when you're running a company is that you're hiring all these execs who the only thing you know is they know a lot more about the subject matter than you do. What does it even mean to bring someone in, bring an exec who had managed a double-digit billion dollar P&L at Google, and what am I supposed to tell him how sales works or marketing? It's easy to be too leaned out there where you're not really setting a clear direction. Each founder is going to have their own things that are easy, things that are harder. Step one is being aware of them, and then being intentional about, how do I offset those things? Then you eventually get to a point where the learning curve flattens out. You actually do have some experience, and you can have a lot more conviction about what the company should do, and where you want it to go.

**中文翻译:**
……在荒漠中徘徊的时期，那时他们并不像今天这样风光。他们当时做的事情并不奏效，而在那种“徘徊期”之后，他们管理事物的方式变得非常不同。突然间，他们拥有了以前可能不具备的那种信念和直觉，或者他们磨平了一些更具反作用的本能。同样，这里面涉及的范畴很广。
(00:54:27):
我不知道是否有人对“创始人模式”有一个共同的定义，但这种进化过程，我思考它的方式是：这非常困难。经营公司最难的事情之一是，你雇佣了所有这些高管，你唯一知道的是他们在专业领域比你懂得多得多。引进一个曾在谷歌管理过百亿美元损益表的高管意味着什么？我该怎么告诉他销售或营销是怎么运作的？在这种情况下，很容易退缩得太远，以至于你没有设定明确的方向。每个创始人都会有自己擅长和不擅长的事情。第一步是意识到这些，然后有意识地思考：我该如何抵消这些弱点？最终你会达到一个学习曲线变平缓的阶段，你确实有了一些经验，你可以对公司应该做什么以及你想让它走向何方拥有更多的信念。

---

### [00:55:25] Lenny Rachitsky

**English:**
Awesome. The way you described it to me, which has really stuck with me, is as a founder, as you said, you're in there leaning in, doing, on top of everything, micromanaging. Then you lead out, and hire execs that you think are smarter than you, and delegate more. Then it's like, "Oh, things aren't going great," and come right back into it.

**中文翻译:**
太棒了。你向我描述它的方式让我印象非常深刻：作为创始人，正如你所说，你一开始是深度介入、亲力亲为、掌控一切、微观管理。然后你退出来，雇佣你认为比你聪明的高管，并进行更多授权。接着发现：“噢，事情进展得不太好，”然后又重新杀回来。

---

### [00:55:40] Drew Houston

**English:**
Yeah. Specifically, it's often well-intended or it's often even not conscious, but as you hire these execs, and then you also build up an HR function, you get coaches, and things like that, and then the things are not going well, one thing that can happen is you start collecting all this feedback. People are like, "Wait, if I can give Drew some negative feedback, then maybe I can displace some of the ..." It's sort of easy to get into a situation where you're sort of being my to-do list of problems, just weaknesses, and flaws I needed to work on was super long, way longer than anyone else's. On the one hand I'm like, "Yes, I am wholly accountable, and responsible for everything in the company as its CEO." That's not wrong. But you can end up just carrying too much of the water, so a lot of it ended up having to be this pushing back a bit. Be like, "All right, yes, there are things I need to work on, but that can't be an excuse for my execs to somehow evade accountability."
(00:56:52):
There's these sorts of systemic things that can creep in for sure. Then you get this feedback, and you're like, "Now, I'm doing all this behavior," or, "Now, I'm behaving in ways that I don't think are really right." Or I'm like, "Everything is just negotiated compromise with everyone on the roadmap or on how we behave or strategy." At some point you end up blowing that up as a founder, and that was certainly my experience.

**中文翻译:**
是的。具体来说，这通常是出于好意，甚至往往是无意识的。但当你雇佣了这些高管，建立了 HR 职能，找了教练等等，而事情进展不顺时，可能会发生的一件事是你开始收集所有这些反馈。人们会想：“等等，如果我能给 Drew 一些负面反馈，也许我就能转移一些……”很容易陷入一种境地，即我的“问题待办清单”（也就是我需要改进的弱点和缺陷）变得超级长，比其他任何人都长。一方面我想：“是的，作为 CEO，我对公司的一切负有全部责任。”这没错。但你最终可能会承担过多的压力，所以很多时候不得不进行一些反击。就像：“好吧，是的，我确实有需要改进的地方，但这不能成为我的高管们逃避责任的借口。”
(00:56:52):
肯定会有这类系统性的问题滋生。然后你收到这些反馈，你会想：“现在我正在做所有这些行为，”或者“现在我的行为方式我觉得并不正确。”或者我觉得：“路线图、行为方式或战略上的每一件事都只是在和每个人进行谈判妥协。”在某个时刻，作为创始人，你最终会炸掉这一切，这确实是我的经历。

---

### [00:57:19] Lenny Rachitsky (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company as top-notch security practices, things get complicated fast. Now, you can assess risk, secure the trust of your customers, and automate compliance for SOC 2, ISO 27001, HIPAA, and more. With a single platform, Vanta.
(00:57:39):
Vanta's market leading trust management platform helps you continuously monitor compliance alongside reporting, and tracking risks. Plus, you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to vanta.com/lenny. That's V-A-N-T-A.com/lenny.

**中文翻译:**
本集节目由 Vanta 赞助。在确保公司拥有顶尖安全实践方面，事情很快就会变得复杂。现在，你可以通过 Vanta 这一个平台来评估风险、赢得客户信任，并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。
(00:57:39):
Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险。此外，通过 Vanta AI 填写安全问卷，你可以节省数小时的时间。加入成千上万家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的全球公司。访问 vanta.com/lenny，即可享受 Vanta 1000 美元的折扣。

---

### [00:58:11] Lenny Rachitsky

**English:**
I think this is a great segue to get into chapter three. Basically, what I understand from what you're going through right now is you're rebooting the team, you're rebooting the core business, you're rebooting the product. I think it might be good to start with the team. You talked a few times about just how you feel like you got to a point where the team wasn't shipping as much as you thought you would, as much as you think they should. Talk about maybe that part of it, of just realizing, "Hey, this part of the business needs to change. Then we can talk about the product, and the direction you've discovered."

**中文翻译:**
我认为这是一个进入第三章的绝佳过渡。基本上，我理解你现在正在经历的是：重启团队、重启核心业务、重启产品。我想从团队开始可能比较好。你几次提到，你觉得团队到了一个不再像你预期的那样、或者不像他们应该做的那样频繁发布产品的阶段。聊聊那部分吧，你是如何意识到“嘿，这部分业务需要改变”的。然后我们可以聊聊产品和你发现的方向。

---

### [00:58:42] Drew Houston

**English:**
My playbook as an entrepreneur is to get really frustrated by something, and then try to solve that personally. I'll cover the team, and what direction we ended up choosing together. My first frustration was forgetting a thumb drive, and then wanting to never have that problem again.
(00:59:03):
But my second big frustration was like, "Man, this scaling this company was way harder than it should have been." Thank God I had people like Bill, Andy, friends, mentors to guide me along. A lot of people don't have access to that. But I feel like I could have written myself postcards that would've made this a little bit easier. Or, there are just some things that don't make sense about how you scale a company. There seem to be things that are really broken about the way we work in general.
(00:59:40):
As I was piecing through a lot of the challenges, I'm like, "All right, what should Dropbox do?" We should probably not do things that would've been invented by everybody else 10 minutes later. Where are the problems that are not solving themselves? One problem I felt like was not solving itself was this problem of being just on this treadmill where I'm like, "I'm working really hard. I'm in meetings all day, emails all night. Is this it?"
(01:00:08):
First of all problem, no complaints. But I'm like, "This is so weird. Yeah, I'm making huge strategic mistakes, because I'm too busy firing the aim, and I'm upset at myself about a lot of these things." But then I look left, look right, I'm like, "Wait, everybody is too busy firing the aim." Everybody is on the same treadmill.
(01:00:28):
I'm like, "This is bizarre. Who's winning here?" It's like if I was working hard, and the company is benefiting, then no problem. But I'm very busy, but I'm not really productive. I'm not putting in a lot of creative input. Then the company's not getting a lot of creative output. It just seems like lose, lose, lose all around.
(01:00:50):
I'm like, "Why are we on this treadmill?" We know from brain science that people are most happy, most productive, fulfilled, engaged, kind of everything you want, where we'd rattle off the same list, like when people are focused, when there's some kind of flow state, when they've had enough sleep, when they have a sense of purpose. We know all that. Yet we go to work, and it's like this cage fight of who's busiest, who's gotten the least sleep, who's most inbox zero. Then you look at the environment on our screens, now, especially after COVID, we live with that.
(01:01:33):
That's where we work. We don't work in an office, no matter what flavor of hybrid you are, you're working on a screen. COVID relocated us from offices to screens. You look what's on that screen, it's like, "Yeah, if you wanted to design a working environment that made it impossible to ever focus, ever get into a flow state, bombard you with just constant interruptions, distractions, and busy work, then yeah, you can squint and see me even before COVID, but definitely after.
(01:01:59):
But that people are like, "Yeah, I'm really not feeling great." I'm not feeling super engaged because half of my work is bullshit, the other half I'm just distracted to death. I'm like, "Why is this this? All right. Maybe Dropbox doesn't have to exist. Maybe we did the thing. Maybe I should go." Maybe I'm ready for the tech bro ascendancy. Maybe I should be flying cars, space, cancer, climate ...

**中文翻译:**
作为一名企业家，我的策略是：对某件事感到非常沮丧，然后尝试亲自解决它。我会讲讲团队，以及我们最终共同选择的方向。我的第一个沮丧是忘了带 U 盘，然后想再也不要遇到那个问题。
(00:59:03):
但我的第二个大沮丧是：“天哪，扩展这家公司比它本该有的难度要大得多。”谢天谢地，我有像 Bill、Andy 这样的人，还有朋友和导师引导我。很多人没有这些资源。但我觉得我本可以给自己写些“明信片”，让这一切变得容易一点。或者说，关于如何扩展一家公司，有些事情是不合逻辑的。我们通常的工作方式似乎存在一些严重的问题。
(00:59:40):
当我梳理这些挑战时，我想：“好吧，Dropbox 应该做什么？”我们可能不应该去做那些别人在 10 分钟后就能发明出来的东西。哪些问题是无法自我解决的？我觉得有一个无法自我解决的问题就是：处在那种“跑步机”上，我想：“我工作非常努力，整天开会，整晚回邮件。难道这就是全部吗？”
(01:00:08):
首先声明，我不是在抱怨。但我心想：“这太奇怪了。是的，我正在犯巨大的战略错误，因为我忙于开火而忘了瞄准，我对自己做的很多事感到不满。”但当我向左看、向右看，我发现：“等等，每个人都忙于开火而忘了瞄准。”每个人都在同一台跑步机上。
(01:00:28):
我想：“这太荒谬了。谁赢了？”如果我努力工作，公司受益，那没问题。但我非常忙，却并没有真正的产出。我没有投入很多创意，公司也就没有得到很多创意产出。这看起来就像是全方位的输、输、输。
(01:00:50):
我想：“我们为什么要在跑步机上？”我们从脑科学中知道，人们在专注、处于某种“心流状态”、睡眠充足、有使命感时，是最快乐、最高效、最有成就感和参与感的。我们都知道这些。然而我们去上班，却像是在进行一场“笼斗”，比谁最忙、谁睡得最少、谁的收件箱最先清零。然后你看看我们屏幕上的环境，现在，特别是在疫情之后，我们就生活在其中。
(01:01:33):
那是我们工作的地方。无论你是哪种混合办公模式，你都是在屏幕上工作。疫情把我们从办公室搬到了屏幕上。你看看屏幕上有什么：“是的，如果你想设计一个让人永远无法专注、永远无法进入心流状态、充斥着不断的干扰、分心和琐碎工作的环境，那么你眯起眼就能看到我，甚至在疫情前就是这样，疫情后更是如此。”
(01:01:59):
人们会说：“是的，我感觉真的不太好。”我感觉参与感不强，因为我一半的工作是废话，另一半我快被分心折磨死了。我想：“为什么会这样？好吧。也许 Dropbox 没必要存在了。也许我们已经完成了使命。也许我该走了。”也许我准备好加入那些“科技大佬”的行列，去搞飞行汽车、太空探索、癌症研究、气候变化……

---

### [01:02:26] Lenny Rachitsky

**English:**
Ayahuasca.

**中文翻译:**
死藤水（Ayahuasca，指灵修）。

---

### [01:02:28] Drew Houston

**English:**
Yeah, right. But then I would talk to people who were actually working on those things, and they were on the same treadmill. I interviewed this director of engineering at SpaceX. I was like, "Oh my God, you're actually going to Mars. This is so cool. How do you guys work together? How are you going to get to Mars?" He's like, "I don't really understand the question."
(01:02:50):
I'm like, "What tools do you use? How do you work together? How are we going to get to Mars?" The answer was basically, "We're going to get to Mars through a lot of emails, and a lot of files." I was like, "Oh, my God." Most of the time, we correctly think about technology as just like force multiplier, like the amplifier of our abilities. But from another perspective, we're only as good as organizations as our tools, or tools can become the limiting factor. It's really a problem when the mechanism through which we were getting work done has gone from being a force multiplier, and amplifier to a suppressor. We are the frogs in the boiling water where this kind happen one day at a time.
(01:03:36):
All the people working on those things, and there are many others, they're all dealing with the same issues of, "I can't focus my tools. I'm fighting with my tools." Somehow the tools went from helping us get the work done to becoming the work, as we layer. It went from 5 of them, to 10 of them, to 500 of them.
(01:03:51):
Yeah. I'm like, "All right. If Einstein were alive today, what would his day be like?" He would wake up. He'd have to delete a bunch of LinkedIn notifications. He'd get down to work, start writing equations, and then someone would Slack him, and interrupt him. Then he'd get back to work. Would we still understand relativity if Einstein were living in that kind of working environment? Probably not.
(01:04:17):
Even just visiting my dad at work when I was a kid, a lot of things were the same. He had a phone, a PC and an office, but he could turn his phone off. He got 5 emails a day, not 500. He would literally come home from work with a briefcase, put it down, and stop thinking about work. Then when he would be in the office, he could close the door, and actually get stuff done.
(01:04:40):
I'm not saying we should go back to the early 90's, but I'm saying it wasn't always like this. The whole frontier of productivity at the time felt like it was just taking us in the wrong direction. Things like Slack, which are wonderful tools, also chop up your day into little fragments, and make you cognitively diabetic. There's a lot of empty carbs in our collaboration, and our collaboration tools.
(01:05:05):
I'm like, "Okay, here is a problem that's not solving itself. Actually, none of our competitors even are framing the problem correctly. What we should be recognizing is that our ultimate non-renewable resource is our time, our attention, mostly our brain power, our creative energy. I think as a civilization, we're going to, hopefully in 5 or 10 years be like, "Man, we took this crazy detour where we basically hooked up that brain power to this thing that was just burning off half of it as friction with our tools." That was dumb. Yet no company was even talking about this, let alone fixing it.
(01:05:49):
Then we came up with a new Dropbox mission. It became Dropbox is designing a more enlightened way of working, because the way we were working is unenlightened, unexamined. Meanwhile, we were patient zero as the company. No one was doing a lot of thinking. Everybody's kind of busy. Everybody's bumping into each other. There were a lot of cultural problems. Like that we were faster. Your company grows, and rises, the easier it is for new people in the company to think they hit a home run instead of starting on third base. A lot of complacency, entitlement, and preoccupation with things other than our customers or other than our products set in.
(01:06:37):
It wasn't all bad. I think there were a lot of good things we had to pay attention to. We were scaling up the business financially. We were getting ready to go public. We had to mature a lot of things, but we lost sight of the place that money is coming from is from our customers, and the thing they really want is a great experience.
(01:06:58):
We've been tackling this in a lot of different ways. First is just things like after COVID hit, suddenly the world is working in a completely different way. We saw this as a big opportunity, not just a crisis. Or once you got past the crisis part of COVID, there was a big opportunity. COVID kind of wrecked everything, but we didn't have to put the floorboards back down in the same places. I'm a big fan of people like Peter Drucker, and lots of people who think about the nature of work, and this idea of we're finally decoupling work from our physical location. It's a big deal. It's probably one of the biggest changes to knowledge work in our lifetimes. Or even since Drucker coined that term knowledge work in 1959.
(01:07:44):
It's like, "Cool. For the first time, we can actually design how we work in ways that our parents couldn't, or the way that most of us just receive how we work from our parents." But like, "Hey, we can actually do things completely differently." We came up with this whole virtual first model where we're 90% remote, but then most importantly, we're trying to rebuild the new product stack for distributed work. I'll talk a little bit about where the new things we're doing, and then I'll come back to how we're rebooting some of the core.
(01:08:16):
But initially, after COVID, we studied a lot of how other remote first companies had worked. We synthesized with a lot of primary research of other companies like GitLab, Automattic, and others who had been doing this for a long time. We collated all that, synthesized a common playbook, open sourced it. If anybody's curious about this, you could find Dropbox. We've open sourced our virtual first toolkit. Then since COVID, designing a working model very in line with our new mission with a lot of benefits. It really works. The employee retention, satisfaction, engagement or offer separates all the things we care about have been significantly up since COVID. There's many factors to that, but there's a lot that's working about the model. But really, we're approaching it from a product standpoint.
(01:09:07):
In deciding to turn Dropbox into this lab for distributed work, we're like, "Okay, when you open up your laptop in 2025, 2030, what do you see?" Hopefully, there's some new stuff or some things that are different on there. What are those things, and how do we bring them back?
(01:09:20):
One of the first things you lose when you go distributed is context. We get a lot. You get a lot for free from osmosis. Just, "Oh, hey, how are you doing? How's this?" Or, "Oh, do you have that thing?" But then when you're remote, then a lot of that gets replaced with endless video meetings, and lots of Slack messages, which is super inefficient.
(01:09:41):
Also, one thing that was clear across the board from all the successful remote first companies was you have to be more documented, but then you have a lot more documents. This started turning up very obvious problems, which is like, "Wait, why do I have 1 search box at home, and 10 search boxes at work? Why is it easier to search all of human knowledge than my company's knowledge? Why is this problem getting worse not better every year?" If you think about it, we've got 10 search boxes that you search 10% of our stuff. I'm like, "We should just fix this."
(01:10:14):
Again, even just as a frustrated user, maybe 2018, 2019, I'm having this problem myself. I'm like, "It's really hard to find stuff." Plus there's always cool vector search stuff, and deep learning stuff happening. Even for ChatGPT, I'm going to make a personal search engine that takes us, so I shouldn't have to, right? If I search for strategy, and the title of the document is plan, it should get it right, and the matching should be fuzzy. Then I built something like this. I'm like, "Oh my God, it completely works."

**中文翻译:**
是的，没错。但后来我与那些真正从事这些工作的人交谈，发现他们也在同一台跑步机上。我采访了 SpaceX 的一位工程总监。我说：“天哪，你们真的要去火星了，这太酷了。你们是怎么协作的？你们打算怎么去火星？”他回答说：“我不太明白你的问题。”
(01:02:50):
我说：“你们用什么工具？怎么一起工作？我们要怎么去火星？”答案基本上是：“我们将通过大量的电子邮件和大量的文件去火星。”我心想：“噢，我的天。”大多数时候，我们正确地将技术视为力量倍增器，视为我们能力的放大器。但从另一个角度看，我们的组织能力仅取决于我们的工具，或者说工具可能成为限制因素。当我们的工作机制从力量倍增器和放大器变成抑制器时，这真的是个大问题。我们就像温水里的青蛙，这种变化一天天在发生。
(01:03:36):
所有从事这些工作的人，还有许多其他人，都在处理同样的问题：“我无法专注于我的工具，我在与我的工具搏斗。”不知何故，随着我们不断叠加工具，工具从帮助我们完成工作变成了工作本身。从 5 个增加到 10 个，再到 500 个。
(01:03:51):
我想：“好吧，如果爱因斯坦活在今天，他的一天会是什么样子？”他醒来，不得不删除一堆 LinkedIn 通知。他坐下来工作，开始写方程式，然后有人发 Slack 消息打断他。然后他再回到工作中。如果爱因斯坦生活在那种工作环境中，我们还能理解相对论吗？可能不行。
(01:04:17):
甚至当我小时候去我爸办公室看他工作时，很多事情都是一样的：他有电话、电脑和办公室，但他可以关掉电话。他一天收到 5 封邮件，而不是 500 封。他下班回家真的会拎着公文包，放下它，然后停止思考工作。当他在办公室时，他可以关上门，真正把事情做完。
(01:04:40):
我不是说我们应该回到 90 年代初，但我是说情况并不总是这样的。当时整个生产力的前沿感觉都在把我们带向错误的方向。像 Slack 这样美妙的工具，也会把你的时间切成碎片，让你患上“认知糖尿病”。我们的协作和协作工具中充满了大量的“空热量碳水化合物”。
(01:05:05):
我想：“好吧，这是一个无法自我解决的问题。事实上，我们的竞争对手甚至都没有正确地界定这个问题。我们应该认识到，我们最终的不可再生资源是我们的时间、我们的注意力，主要是我们的脑力、我们的创造性能量。我认为作为一个文明，我们希望在 5 到 10 年后会说：‘天哪，我们绕了这么大一个弯路，基本上是把脑力连接到了这个东西上，而这个东西的一半能量都作为与工具的摩擦力被消耗掉了。’那太蠢了。然而没有一家公司在谈论这个，更不用说修复它了。”
(01:05:49):
于是我们提出了新的 Dropbox 使命：Dropbox 正在设计一种更开明（enlightened）的工作方式。因为我们过去的工作方式是不开明的、未经审视的。与此同时，我们公司本身就是“零号病人”。没有人进行深入思考，每个人都很忙，每个人都在互相碰撞。有很多文化问题。比如我们曾经跑得很快，但随着公司成长，新员工很容易觉得自己是打出了本垒打，而不是从三垒开始。大量的自满、特权感以及对客户或产品以外事物的关注开始滋生。
(01:06:37):
这并不全是坏事。我认为有很多好的方面我们需要关注。我们在财务上扩大了业务规模，准备上市。我们必须让很多事情成熟起来，但我们忽视了钱是从客户那里来的，而他们真正想要的是极佳的体验。
(01:06:58):
我们一直在以多种方式解决这个问题。首先是疫情爆发后，世界突然以完全不同的方式运作。我们认为这是一个巨大的机会，而不仅仅是危机。一旦你度过了疫情的危机阶段，就会发现巨大的机会。疫情破坏了一切，但我们不必在原处重新铺设地板。我是彼得·德鲁克（Peter Drucker）等人的忠实粉丝，他们思考工作的本质，以及我们终于将工作与物理位置脱钩的想法。这是一件大事，可能是我们这辈子知识工作最大的变化之一，甚至是自德鲁克在 1959 年创造“知识工作”这个词以来最大的变化。
(01:07:44):
我想：“太酷了。我们第一次可以真正设计我们的工作方式，而这是我们父母无法做到的，或者说我们大多数人只是从父母那里继承了工作方式。但是，嘿，我们实际上可以做完全不同的事情。”我们提出了整个“虚拟优先”（Virtual First）模式，我们 90% 的时间是远程办公，但最重要的是，我们正试图为分布式工作重建新的产品栈。我会谈谈我们正在做的新东西，然后再回到我们如何重启核心业务。
(01:08:16):
最初在疫情之后，我们研究了很多其他远程优先公司的运作方式。我们综合了对 GitLab、Automattic 等长期从事此类工作的公司的初步研究。我们整理了所有这些，综合出一套通用的策略，并将其开源。如果有人对此感兴趣，可以搜索 Dropbox，我们已经开源了我们的“虚拟优先工具包”。自疫情以来，我们设计了一个非常符合我们新使命的工作模式，带来了很多好处。它真的很有效：自疫情以来，员工留存率、满意度、参与度等我们关心的所有指标都显著上升。这有很多因素，但这个模式确实发挥了作用。但实际上，我们是从产品角度出发的。
(01:09:07):
在决定将 Dropbox 变成分布式工作的实验室时，我们想：“好吧，当你打开 2025 年、2030 年的笔记本电脑时，你会看到什么？”希望上面会有一些新的东西，或者一些不同的东西。那些东西是什么？我们如何把它们带回来？
(01:09:20):
当你进入分布式办公时，你首先失去的东西之一就是“上下文”（context）。在办公室，你可以通过渗透作用免费获得很多信息：比如“嘿，你最近怎么样？那个怎么样？”或者“噢，你有那个东西吗？”但当你远程办公时，很多东西被无休止的视频会议和大量的 Slack 消息取代了，这非常低效。
(01:09:41):
此外，所有成功的远程优先公司都有一个明确的共识：你必须更加文档化，但这样你就会有更多的文档。这开始暴露出非常明显的问题，比如：“等等，为什么我在家只有一个搜索框，在公司却有 10 个搜索框？为什么搜索全人类的知识比搜索我公司的知识更容易？为什么这个问题每年都在恶化而不是好转？”如果你仔细想想，我们有 10 个搜索框，每个只能搜索 10% 的东西。我想：“我们应该解决这个问题。”
(01:10:14):
同样，即使只是作为一个沮丧的用户，大概在 2018、2019 年，我自己也遇到了这个问题。我想：“找东西真的很难。”加上一直有很酷的向量搜索和深度学习技术出现。甚至在 ChatGPT 出现之前，我就想做一个个人搜索引擎，我不应该手动去找，对吧？如果我搜索“战略”（strategy），而文档标题是“计划”（plan），它应该能找对，匹配应该是模糊的。然后我做了一个类似这样的东西。我想：“噢我的天，它完全有效。”

---

### [01:10:42] Lenny Rachitsky

**English:**
You built this yourself, you're saying?

**中文翻译:**
你是说你自己做了这个？

---

### [01:10:45] Drew Houston

**English:**
Yeah, it went nowhere for a couple of years, but then after COVID, and after we're dealing with all these information problems, I'm like, "Yeah, we should be the company that helps you get the right information at the right time to the right person." I built that little hacked up search engine thing that I made, might be an ingredient to this.
(01:11:08):
We bought a little company called Command E that was doing universal search, and we created this new product called Dropbox Dash. Basically, Dash connects to all your different apps. It gives you universal search. Then obviously after ChatGPT, not only can you do conventional search, but you can ask questions in natural language, and answer a lot of the questions that ChatGPT can't because it's not connected to your stuff. If you ask ChatGPT like, "When does my lease expire? Where's that slide from last year's product launch," can't tell you because it's not personalized. Because it's not connected to your information. We did all of that for this whole connector platform where we index the known universe of SaaS apps, have this kind of intelligence engine that brings all of it into a common representation, and lets you do conventional search, natural language search.
(01:11:58):
Then more than that, we want to organize your working life for you. Stepping back even further, often it happens that a company likes to starts solving a problem, and that problem is never permanently solved. In a lot of ways, Dash is the biggest, best embodiment of solving the same kinds of problems I started Dropbox to begin with. Because on the one hand, I was talking about thumb drive, but I wasn't, really. If you think about the higher level job to be done, I was like, "No, the real issue is that it's super hard to find my stuff, organize my stuff, share my stuff, and secure my stuff."
(01:12:36):
In the beginning that was like my stuff was my files, and the scattering was across devices. Now, the stuff is tabs in my browser, and cloud tools. But it's a lot of the same problems. We've talked a lot about search, but then organize is still a big problem. There's no desktop folder or desktop as in the physical realm, when you're in your browser. It's just this ocean of content that washes by you. Then you get tired. You nuke the whole environment. But there's nothing to come back to. There's no collection concept. Files have folders, songs have playlists, links have ... If you're getting ready for board meeting or remodeling a house, there's no common container. If you have a Google doc, and a 10 gig, 4K video, and an air table, this is a new problem.
(01:13:25):
Dash also has this thing called Stacks, and has basically smart collections that helps make sharing a lot easier. But again, a lot of this was an intersection of like, "Yeah, how has work changed since COVID? What crazy little science projects have I done? Then how should one find, organize, and share their information in the cloud era? If I were to build Dropbox today, what would it look like?" Dash is first part of the answer. We're super excited. But we just launched it two months ago, and signed up our first customers. Then I can come back to just rebooting the core business too. I think one of the big challenges or lessons from this whole period is that one, is as part of the problem we had with competition, and this chapter two was external, but a lot of it was internal, where we couldn't organize ourselves effectively. The business has scaled so much faster than our ability to manage it. First is to recognize this is not an unusual problem. Many companies, not all, but certainly many, and actually many in SaaS productivity have this sophomore slump where you have the super successful first product, but then it's challenging to build the next platinum album. Dropbox has fallen into that category. You could say Zoom, Slack, others.
(01:14:58):
First, it's easy to feel bad about it yourself, but no, you're not. This is actually a very common problem. Then there's a lot of solutions. People devise lots of solutions to this. Part of it's structural. Your company has to go from a pretty fun, and stable state of a functional organization where you have engineering in product design, there's one product, and there's one customer. Everybody's working, we are all in the same direction for the same team to then when you have multiple products, then you have all these conflicts. How much should we invest in the core business versus the new thing? Who should have authority in the company? You try to build multiple products in a functional org, but then you lose accountability.
(01:15:50):
People are like, "I'm spending a lot. I'm trying to make Dropbox work. I'm trying to make mailbox work. I'm trying to make paperwork, and all these things." Then you respond by breaking up into groups or business units. We have a product business unit, product GM structure. Then you have to refactor things to have a common technical platform, and all the GNA functions. There's this metamorphosis, and maturation you need to go through that is mega obvious to experienced people. That you're just totally blindsided by this if you're solving it by trial and error. There's a great book, Zone to Win, that talks about some of this, what needs to happen internally by Geoffrey Moore.
(01:16:35):
Then there's a lot of cultural problems that set in. We just touched on some of them at a high level. But whether you're in a company or an empire, a civilization, what gets you to the top turns out to be pretty similar things. You have this outsider, challenger mentality where you have to eat what you kill, and the odds are against you. Through hard work, learning, and grinding, you start moving up the curve faster. But then once you're successful, then there's a temptation to take the foot off the gas or enjoy the finer things in life or just focus on other things, be it other than what got you there. I think what we experienced, many other companies experienced, Bill Campbell experienced in Netscape, the success plants, the seeds of failure in terms of complacency, entitlements, or taking your eye off of what got you to be successful in the first place, yeah, I went from earning a lot of the early stage startup founder merit badges to earning the stagnation, and irrelevance merit badge. Now, the turnaround merit badge. Part of that is the turnaround playbook.
(01:17:47):
Okay, first, it's just getting out of this delusional state where you think you're great, just splashing cold water on everyone, and be like, "Look, we haven't shipped any. Last three years, the only thing our customers have really meaningfully seen from our product is a price increase. What the hell are we doing?"
(01:18:08):
A lot of it is getting back to like, "Hey, we have to focus on craft. We have to embrace a growth mindset and learning. We have to stop blaming external factors or displacing blame. We have to be a high agency culture." There's a cultural transformation that you have to personally embody, and be clear about.
(01:18:29):
Then in our case, we had to reboot the whole exec team. We've had all the time getting the right kind of leadership team in place for the end of chapter two and three. Part of what happens in conjunction with a lot of the cultural stuff I just talked about, is also you can have this as the talent flywheels flying forward, and flies in reverse. You have a new set of issues where you get all these amazing people in the company, but they want to work for Facebook, not MySpace. You start having retention problems when the narrative goes negative. We start bleeding talents, and then it's also really hard to hire people for the same reasons. Especially, as I think about where the big lessons from chapter two that we've addressed in chapter three, the seniority gap is something that can accumulate because much of the talent can fly to the next shiny thing. What you do in response typically is, you promote a lot of people internally, which is good for them. It seems good for them in the short term, because they're just getting a lot more authority, and responsibility quickly. People like that on day one. But it's a problem because suddenly people are solving problems through trial and error. Things may be new to them that are not new to the industry, and suddenly no knowns to the industry are unknown and knowns to those leaders. Then usually you can get around that by hiring a layer of experienced execs or having enough of them in the company. But in the talent wars of the late teens, we were in the situation as were many companies where, any exec you talked to with any experience had five offers from fan companies for three times the comp, and a third of the workload, or 10 offers from pre-IPO startups, and C-level roles. These are offers in hand. The only thing that really worked to even just keep the lights on was basically giving people double promotions so that they could justify someone who's a director at company X, making him a VP at Dropbox. Then you had to do that because they literally had offers in hand of many millions of dollars a year. Otherwise, you'd just hire no one. That cooled off a lot after the correction in SaaS, after we got more of our vision straight, and certainly after we've been working on things like Dash.
(01:20:59):
But that seniority gap is really rough. Where ...

**中文翻译:**
是的，它搁置了几年。但在疫情之后，在我们处理所有这些信息问题时，我想：“是的，我们应该成为那家帮助你在正确的时间将正确的信息传递给正确的人的公司。”我做的那个简陋的搜索引擎原型可能成了其中的一个要素。
(01:11:08):
我们收购了一家做通用搜索的小公司 Command E，并创建了这个名为 Dropbox Dash 的新产品。基本上，Dash 连接你所有的不同应用，为你提供通用搜索。显然在 ChatGPT 之后，你不仅可以进行常规搜索，还可以用自然语言提问，并回答很多 ChatGPT 无法回答的问题，因为它没有连接到你的私人数据。如果你问 ChatGPT：“我的租约什么时候到期？去年产品发布会的幻灯片在哪？”它无法告诉你，因为它没有个性化，没有连接到你的信息。我们为整个连接器平台做了所有这些工作，索引了 SaaS 应用的已知宇宙，拥有这种智能引擎，将所有内容带入一个通用的表示形式，让你进行常规搜索和自然语言搜索。
(01:11:58):
不仅如此，我们还想为你组织你的工作生活。退一步说，通常一家公司喜欢开始解决一个问题，而那个问题永远不会被永久解决。在很多方面，Dash 是解决我最初创办 Dropbox 时遇到的同类问题的最大、最好的体现。因为一方面，我当时在谈论 U 盘，但其实不完全是。如果你思考更高层次的“待办任务”（job to be done），我会说：“不，真正的问题是很难找到我的东西、组织我的东西、分享我的东西和保护我的东西。”
(01:12:36):
起初，“我的东西”是我的文件，分散在不同设备上。现在，“东西”是浏览器里的标签页和云端工具。但很多问题是一样的。我们谈了很多搜索，但“组织”仍然是一个大问题。当你在浏览器中时，没有物理领域那样的“桌面文件夹”或“桌面”。它只是冲刷着你的内容的海洋。然后你累了，关掉所有页面，但下次回来时什么都没有。没有“集合”的概念。文件有文件夹，歌曲有播放列表，链接有……如果你正在准备董事会会议或装修房子，没有一个通用的容器。如果你有一个 Google 文档、一个 10G 的 4K 视频和一个 Airtable，这是一个新问题。
(01:13:25):
Dash 还有一个叫 Stacks 的功能，基本上是智能集合，让分享变得容易得多。但同样，这很多是交集：“是的，疫情以来工作发生了什么变化？我做过哪些疯狂的小科学项目？在云时代，一个人应该如何查找、组织和分享他们的信息？如果我今天创办 Dropbox，它会是什么样子？”Dash 是答案的第一部分。我们非常兴奋。我们两个月前刚发布它，并签约了第一批客户。然后我也可以回到重启核心业务的话题。我认为这段时期的重大挑战或教训之一是：我们在第二章遇到的竞争问题有一部分是外部的，但很大一部分是内部的，即我们无法有效地组织自己。业务规模的增长速度远远超过了我们的管理能力。首先要认识到这并非罕见的问题。许多公司（并非全部，但确实很多），尤其是 SaaS 生产力领域的公司，都会遇到这种“大二滑坡”（sophomore slump）：你有一个超级成功的首款产品，但要打造下一张“白金专辑”却极具挑战。Dropbox 就属于这一类。你也可以说 Zoom、Slack 等也是如此。
(01:14:58):
首先，你很容易为此感到自责，但其实不必。这实际上是一个非常普遍的问题。对此有很多解决方案。人们设计了很多方案，其中一部分是结构性的。你的公司必须从一个非常有趣且稳定的职能型组织（functional organization）——即你有工程、产品、设计，只有一个产品和一个客户，每个人都朝着同一个方向努力——转变为当你拥有多个产品时，你会遇到所有这些冲突：我们应该在核心业务上投入多少，在新事物上投入多少？谁应该在公司拥有权威？你尝试在职能型组织中构建多个产品，但随后你会失去问责制。
(01:15:50):
人们会说：“我花了很多钱，我正努力让 Dropbox 运转，努力让 Mailbox 运转，努力让 Paper 运转。”然后你的应对方式是拆分成小组或业务单元（BU）。我们采用了产品业务单元、产品 GM（总经理）结构。然后你必须重构，建立通用的技术平台和所有的 G&A（行政管理）职能。你需要经历这种蜕变和成熟，这对有经验的人来说是显而易见的，但如果你是通过试错来解决，你会被完全打个措手不及。杰弗里·摩尔（Geoffrey Moore）有一本很棒的书叫《跨越鸿沟：赢在转折点》（Zone to Win），讲述了公司内部需要发生的变化。
(01:16:35):
然后会出现很多文化问题。我们刚才在高层面上触及了一些。但无论是在一家公司、一个帝国还是一个文明中，让你登上顶峰的因素往往非常相似：你拥有一种局外人、挑战者的心态，你必须“猎杀才能生存”，而且胜算并不在你这边。通过努力工作、学习和磨练，你开始更快地向上移动。但一旦你成功了，就会有一种诱惑：松开油门，享受生活中的美好事物，或者只关注那些让你成功的因素以外的事情。我认为我们所经历的，许多其他公司也经历过，Bill Campbell 在 Netscape 也经历过：成功播下了失败的种子，表现为自满、特权感，或者不再关注最初让你成功的因素。是的，我从赢得很多早期创业创始人的“功勋章”，变成了赢得“停滞和无关紧要”的勋章。现在，是“扭转局面”的勋章。这其中一部分就是扭转局面的策略。
(01:17:47):
好吧，首先，就是摆脱这种认为自己很伟大的妄想状态，给每个人泼冷水，说：“看，我们什么都没发布。过去三年，我们的客户从我们的产品中看到的唯一有意义的变化就是涨价。我们到底在干什么？”
(01:18:08):
很大一部分是回到：“嘿，我们必须专注于手艺（craft）。我们必须拥抱增长心态和学习。我们必须停止责怪外部因素或推卸责任。我们必须建立一种‘高自主性’（high agency）的文化。”这是一种你必须亲自践行并明确表达的文化转型。
(01:18:29):
然后在我们的案例中，我们不得不重启整个高管团队。我们花了很长时间在第二章末尾和第三章建立起合适的领导团队。与我刚才谈到的文化因素相结合，还会发生一件事：人才飞轮可能会向前转，也可能会倒转。你会遇到一系列新问题：公司里有很多了不起的人，但他们想为 Facebook 工作，而不是 MySpace。当舆论变负面时，你会遇到留存问题。人才开始流失，由于同样的原因，招聘也变得非常困难。特别是当我思考第三章中解决的第二章重大教训时，“资历断层”（seniority gap）是会累积的，因为很多优秀人才会飞向下一个闪亮的新事物。你通常的应对方式是：在内部提拔很多人，这对他们来说是好事，短期内看起来也不错，因为他们很快获得了更多的权力和责任。人们在第一天都喜欢这样。但这是一个问题，因为突然间人们在通过试错来解决问题。对他们来说是新鲜的事物，对行业来说可能并不新鲜，突然间行业内的“已知常识”对这些领导者来说成了“未知”。通常你可以通过雇佣一层有经验的高管或在公司保留足够多的资深人士来解决这个问题。但在 2010 年代末的人才大战中，我们和许多公司一样处于这种境地：你谈过的任何有经验的高管，手里都有 5 个来自大厂（FANG）的 Offer，薪水是你的三倍，工作量是你的三分之一；或者有 10 个来自准上市初创公司的 C-level 职位的 Offer。这些都是到手的 Offer。唯一能维持公司运转的方法基本上是给人们“双重晋升”，这样他们才能证明：让一个在 X 公司的总监来 Dropbox 当副总裁是合理的。你不得不这么做，因为他们手里真的有年薪数百万美元的 Offer。否则，你一个人也招不到。在 SaaS 行业回调、我们的愿景变得清晰，特别是我们开始做 Dash 之后，这种情况缓解了很多。
(01:20:59):
但那种“资历断层”真的很痛苦。在那里……

---

### [01:21:00] Drew Houston

**English:**
Seniority gap is really rough where you need to have enough experienced people in the company who can then train your high potential people. And again, that sounds obvious, but it's very difficult to do that in an environment where the talent flywheel is going in your direction and then starts flying away from you really quickly. And then through the battlefield promotions and these double promotions on hiring, you can end up a situation where there's a huge voltage drop in terms of people's matching between what your company needs and what they know how to do. And that also doesn't mean hire only experienced people either because then you're splicing in a lot of outside DNA into your organism. But what you want is to keep it roughly in balance. I mean 60-40, 40-60, 50-50, whatever. But your high potential people also lose out if they don't have experienced people learning from.
(01:22:00):
So that's a little bit, I think that it was a big part of the stagnation. Again, it's not because the people, but this was something that I was doing to my team. So it's not them or certainly on my watch, but I think it's a dynamic you have to be careful of like do we have the right balance of people who are super high potential and talented, but doing their thing for the first time? Are they paired with people who have been there, done that, this is not the biggest job of their life, and that they can help those people up the learning curve faster such that the aggregate learning rate of your company is what it needs to be.

**中文翻译:**
资历断层真的很艰难，因为你需要公司里有足够多的有经验的人，他们可以培训那些高潜力的人才。再次强调，这听起来显而易见，但在人才飞轮原本朝向你、然后突然迅速离你而去的情况下，要做到这一点非常困难。通过“火线提拔”和招聘时的“双重晋升”，你最终可能会遇到这样一种情况：在公司需求与员工能力匹配方面出现了巨大的“电压降”（voltage drop）。这也不意味着只雇佣有经验的人，因为那样你会向你的组织中注入过多的外部 DNA。你想要的是保持大致的平衡，比如 60-40、40-60 或 50-50。如果高潜力人才没有经验丰富的人可以学习，他们也会蒙受损失。
(01:22:00):
所以我认为这是停滞的一个重要原因。再次强调，这不是因为人的问题，而是我对我团队所做的事情。所以不是他们的问题，当然是在我的任期内发生的。但我认为这是一种你必须警惕的动态：我们是否在“超级高潜力、有才华但第一次做这件事的人”与“曾经经历过、这并非他们人生中最大挑战、可以帮助前者更快提升学习曲线的人”之间取得了平衡？这样你公司的整体学习率才能达到应有的水平。

---

### [01:22:41] Lenny Rachitsky

**English:**
Man, I feel like there's a book here of lessons for founders, things that you never hear about until-

**中文翻译:**
伙计，我觉得这里面有一本书的素材，全是给创始人的教训，那些你从未听过的事情，直到——

---

### [01:22:51] Drew Houston

**English:**
Mind the seniority gap.

**中文翻译:**
警惕资历断层。

---

### [01:22:55] Lenny Rachitsky

**English:**
That's one of so many. People think about becoming founders, they start companies, "Oh, I'm going to start a company, there we go." And then, they think about that first part of the journey that you talked about. And most people don't even get that part. And the best case scenario is you experience a ton of growth. And then, the way you described it to me previously is you hit the final bosses where showing all the success and they're like, "Oh, I see there's a big market here. Let's go after it." And you're battling Apple and Google and Microsoft and Meta, and a lot of people don't think about that and how that's the future if you do well.

**中文翻译:**
这只是众多教训中的一个。人们想成为创始人，他们创办公司，“噢，我要开公司了，开始吧。”然后他们想到的是你谈到的旅程的第一部分。大多数人甚至连那部分都达不到。而最好的情况是你经历了巨大的增长。接着，就像你之前向我描述的那样，你遇到了“最终大 Boss”：当你展示了所有的成功，他们会说：“噢，我看到这里有一个大市场，让我们去抢过来吧。”然后你就在和苹果、谷歌、微软、Meta 战斗。很多人没有想到这一点，也没想到如果你做得好，这就是你的未来。

---

### [01:23:28] Drew Houston

**English:**
Yeah, every time you move up a league, your reward is a stronger and better opponent and potentially more unlevel playing field. And that's just the way it is. You can't control that. All you can control is how you respond. And so, you want your company's response to embrace that challenge and use it as a mechanism to get stronger. Easy to say, hard to do.

**中文翻译:**
是的，每当你升入一个更高的联赛，你的奖励就是更强大、更优秀的对手，以及可能更加不公平的竞争环境。事实就是这样，你无法控制。你唯一能控制的是你如何应对。所以，你希望你公司的应对方式是拥抱挑战，并将其作为变得更强大的机制。说起来容易，做起来难。

---

### [01:23:51] Lenny Rachitsky

**English:**
Yeah. So maybe just to start reflecting on some of the lessons from this journey, because there's a lot here. One question people may be wondering is, should I even be a founder? Should I start a company? A lot of people, there's a lot of pain that you've been sharing of the challenge of starting companies. What do you tell people that are asking you like, "Hey, should I start a company? Am I right to be a founder?" Is there any advice there that you could share?

**中文翻译:**
是的。所以也许我们可以开始反思这段旅程中的一些教训，因为这里面有很多内容。人们可能会想的一个问题是：我到底该不该当创始人？我该创办公司吗？你分享了很多创办公司的痛苦和挑战。对于那些问你“嘿，我该创办公司吗？我适合当创始人吗？”的人，你有什么可以分享的建议吗？

---

### [01:24:18] Drew Houston

**English:**
I don't know what made me want to be a founder. I just showed up that way. And so, there's probably some chemical imbalance of some form that causes people to do it, but I had a lot of insecurity about should I be a CEO? Because coming from the technical side, because I was like, I can do the engineering and technology, but all I know about being a CEO is I do not know how to do all of those things that CEOs do, and I do not look like that, I do not talk like that, it's intimidating.
(01:24:46):
So I think first is it doesn't have to be an all or nothing decision. I mean, obviously it's all encompassing decision to become, to start a company, but you'll have many points along the way where you can keep calibrating. And I think the biggest thing is, or advice I got from one of the founders of a company where I worked was I was like, oh, should I be CEO? Should I not be CEO? Should I be CTO? He's like, "Look, just try it, be CEO, see how it goes."
(01:25:17):
Initially, I thought I was like, all right, well I'm going to get the company to 100 million valuation and the trend will just be going faster, faster and faster, faster. And instead of just getting thrown off of it, I'll just hit stop and retire. And I thought that sounded like a great plan. But then, moving to the Bay Area, you suddenly meet, you throw a rock and hit 10 people who've done that. And what do you learn? This was just shocking to me because I talked to one of the advisors I mentioned earlier. He's like, "Yeah, the day I sold my company was the saddest day of my life." I'm like, "What?" As a 24-year-old, and he's like, "Yeah. Well, I just felt like the company had drifted away from what it was supposed to be and I just didn't like it." I think they're certain in the founder mode trough where you're like, wait, things are screwed up and it's on my watch, but I'm not really sure what happened and what do I do about it? So I think burnout is the biggest thing that will kill you. And so, I think that's why these coping methods and getting your own head is important, but if you do that, then it's also this amazing experience. And then often so many founders go back and start another company and another company. And you don't have to, but there's a reason that people do that because there's just a lot of rewarding aspects of it, building great things with great people that impact huge populations.
(01:26:42):
What I found is that founders keep doing this because they love it in some way, or at least have a love-hate relationship with it or can't imagine something else that they would otherwise be doing and I'm probably the same way. But I think to get through that, you have to, Ben Horowitz also said the hardest thing for a CEO is to manage your own psychology. And we've talked a lot about, yeah, first you have to be aware of what your psychology is, and then how do you make sure you're not resenting or hating your company or yourself and view...
(01:27:18):
I think the hardest thing for a founder, challenge is not optional. You're going to be challenged, but the suffering is optional. You don't actually have to suffer. I mean, look, there's crunch periods or times where it's taxing, but it doesn't have to be this experience of suffering all the way or burning out or being really angry and sad all the time. Although certainly, in my experience that I did get in periods where I was just sad and angry all the time. So you need to figure out how do you work your way out of that.

**中文翻译:**
我不知道是什么让我想要成为一名创始人，我天生就是这样。所以，可能某种形式的化学物质失衡导致人们这样做。但我对于是否应该担任 CEO 有很多不安全感。因为我是技术出身，我想我可以搞定工程和技术，但我对当 CEO 的唯一了解就是：我不知道 CEO 做的那些事该怎么做，我长得不像 CEO，说话也不像，这让人望而生畏。
(01:24:46):
所以我觉得首先，这不一定是一个“全有或全无”的决定。我的意思是，显然创办公司是一个全方位的决定，但一路上你会有很多点可以不断校准。我认为最重要的一点，或者说我从以前工作过的一家公司的创始人那里得到的建议是——当时我纠结：“噢，我该当 CEO 吗？还是不当？我该当 CTO 吗？”他说：“听着，就去试试，当 CEO，看看情况如何。”
(01:25:17):
最初我想的是：好吧，我要把公司做到 1 亿美元估值，增长趋势会越来越快。然后，我不会被甩下车，而是直接按停止键然后退休。我觉得这听起来是个伟大的计划。但后来搬到湾区，你突然发现，随便扔块石头都能砸到 10 个做过这种事的人。你学到了什么？这对我来说非常震撼，因为我曾和之前提到的一位顾问聊天，他说：“是的，卖掉公司的那天是我一生中最悲伤的一天。”作为一个 24 岁的小伙子，我心想：“什么？”他说：“是的，我只是觉得公司已经偏离了它本该有的样子，我不喜欢它了。”我认为在“创始人模式”的低谷期，你会觉得：等等，事情搞砸了，是在我的任期内发生的，但我不太确定发生了什么，我该怎么办？所以我认为“倦怠”（burnout）是杀伤力最大的东西。这就是为什么应对方法和理清自己的思绪很重要，但如果你做到了，这也会是一段奇妙的经历。很多创始人会回去创办第二家、第三家公司。你没必要这么做，但人们这样做是有原因的，因为这其中有很多回报丰厚的方面：与优秀的人一起打造伟大的事物，影响庞大的人群。
(01:26:42):
我发现创始人之所以坚持做下去，是因为他们在某种程度上热爱它，或者至少有一种爱恨交织的关系，或者无法想象自己还能做别的什么。我可能也是这样。但要度过难关，你必须——本·霍罗维茨也说过——CEO 最难的事情是管理自己的心理。我们谈了很多，是的，首先你必须意识到你的心理状态，然后确保你不会怨恨或讨厌你的公司或你自己。
(01:27:18):
我认为对创始人来说最难的一点是：挑战是必选项，你肯定会受到挑战，但痛苦是可选项。你实际上不必受苦。我的意思是，看，会有关键时期或费力的时刻，但不一定非要是全程受苦、倦怠或整天愤怒和悲伤。虽然在我的经历中，确实有过整天悲伤和愤怒的时期。所以你需要弄清楚如何从中走出来。

---

### [01:27:47] Lenny Rachitsky

**English:**
So along those lines, I'm curious, so you've shared a few things that have helped you level up as a leader and push through that. You mentioned meditation, Bill Campbell, a coach. You mentioned a few books. What has helped you continue to level up and stay ahead of where the company needs you? Sometimes you fell behind, sometimes you're ahead. What are some tips for founders that are trying to stay ahead of where things are going?

**中文翻译:**
沿着这个思路，我很好奇，你分享了一些帮助你作为领导者提升并度过难关的方法。你提到了冥想、Bill Campbell、教练，还提到了一些书。是什么帮助你持续提升并走在公司需求的前面？有时你落后了，有时你领先了。对于那些试图走在形势前面的创始人，你有什么建议吗？

---

### [01:28:12] Drew Houston

**English:**
Well, I think first thing is I think a theme that's carried throughout a lot of these different chapters is you have to figure out what game you're playing and what the rules are when the game keeps changing. So I like in addition to the Enneagram or coding, I also like a long time video game player and there's a great game called, everybody's familiar with StarCraft. It's an awesome game. I think it has many lessons and riddles for an aspiring entrepreneur, many parallels with running a company. I'll save that for another one.
(01:28:54):
But this idea, Mindshare is a big resource. It's not actually how much money or economy or land or whatever or-

**中文翻译:**
嗯，我认为首先，贯穿这些不同章节的一个主题是：你必须弄清楚你正在玩什么游戏，以及当游戏规则不断变化时，规则是什么。除了九型人格或写代码，我还长期玩电子游戏。有一款伟大的游戏叫《星际争霸》（StarCraft），大家都很熟悉。这是一款很棒的游戏。我认为它对有抱负的企业家有很多教训和谜题，与经营公司有很多相似之处。我留到下次再说。
(01:28:54):
但这个想法是：心智份额（Mindshare）是一项重要资源。它实际上不是你有多少钱、经济实力、土地或——

---

### [01:29:03] Lenny Rachitsky

**English:**
Actions?

**中文翻译:**
操作数（APM）？

---

### [01:29:03] Drew Houston

**English:**
Military. Yeah, it's like you can only do so much or think about so much, your attention, but that's actually not the big lesson. In StarCraft and other games, there's this concept of there's a micro and macro, and I would add to that, there's also the meta game. Okay, so what's that? Micro in these games, something like StarCraft is like, all right, can you click really fast and move your people and build things really quickly? And it's like the mechanics. Every second, how many hundreds of things are you doing per minute or how many things are you doing per second? And that's like a conditioning and practice and one kind of thing.
(01:29:43):
Then, there's the macro game. Well, could come back to the micro, in a product context or in a startup context, that might be things like, all right, how do I, often the stuff around product design and technology and distribution. So early founders especially are going to be totally fixated on here's how I make this great design and here's how the engineering works and here's how we get users and here's how our sales motion works, or here's how our viral loop works or things like that. And it's very in the details.
(01:30:12):
And then, there's the macro game. In StarCraft, that might be things like, well, clicking a lot is important, but overall you're really managing your economy. So do you have more expansions and resources than the other player? Are you building up your military? Are you getting your balance of the investment in economy and military? Are you scouting? Do you know what the other person's doing? It's more strategic and conceptual. So things in the startup realm that would feel more like that are more like, all right, not just the mechanics of how does this feature work, but more like, all right, what's the business model? What's the market? Who are my competitors? How do I differentiate myself? How's this all going to evolve over time as the category goes from super high growth to more mature, things like that? And you respond, okay, we got to go from one product to multiple products, so then we have to reorganize the company that way and we blah, blah, blah.
(01:31:11):
And then I'd say there's also this, the meta game, which in gaming is a pretty specific thing. It's like some combination of the game itself gets updated so that as the creators, they make this unit stronger and this area unit is stronger, and this ground unit weaker and try to keep this big system in balance. And then, also as this community of players figures out new strategies and this big repeated game of rock paper, scissors, people figure out, okay, this one strategy is now categorically better. And it's always this adversarial thing that's always shifting. And so, playing StarCraft in 2020 is pretty different from playing StarCraft in 2015 or 2010 because everything, both the players are shifting and the game itself is shifting. And the game, it's usually not shifting a lot. So it's really more of an ecological effect.
(01:32:02):
So I think it's super important. And then, in a startup context, what's the meta game? Well, I'd say some of it is just business cycles. So I think you'll have, as you see, there's this boom in the late teens in SaaS and in tech. There's a bit of an AI boom happening right now. It's not that different from what, or parts of it are not that different from what happened with the dotcom era in '99, 2000 or the web 2.0 era in 2007 or others. And then, you have these bust times like 2008 and 2000, 2001, et cetera. So there's a market cycle thing that often creates similar dynamics where it's like five years ago every tech company was hiring the maximal number of people that it could. And then, that created one talent dynamic. Now, it's a lot of companies are keeping high comp flat or negative, so that's just a very different thing. But even those are cyclical.
(01:33:03):
Then, you want to identify how is this game of business actually fundamentally permanently changing? So for example, we launched Dash, we usually do a press thing, conventional press, tech press, we got almost no coverage for it. And yet all the stuff we did on social or going direct was way, way, way more impactful. And it's not just Dropbox or in tech, but it's also presidential election. All the candidates are on podcasts. Yes, they're on CNN too, but not really. So that's just a new thing. How do you manage the brand of your company or launch products, things like that. The nature of marketing is changing. And that changed when, in 2007 too, instead of hiring PR firms and buying AdWords and stuff, we were creating these viral videos and we were using math from epidemiology to create these viral loops. In a lot of ways, Dropbox took that, transplanted that consumer internet playbook into business software.
(01:34:10):
But the thing is you need to understand what game you're playing and you need to get good at the micro. It's not that the meta is more important than the micro, it's like you need to do all three at the same time. And so, that's really the hard part. And then, when things are shifting. And the way you know what game you're playing is to be systematic about training yourself and probably the single most useful, or at least important to me piece of advice I could give is you have to figure out how to keep your personal growth curve ahead of the company's growth curve. The single most important impactful thing for me has been reading because talk about this micro, macro, meta games or abstractions, this is the kind of stuff you can learn from history.
(01:34:55):
Learning what happened in Netscape ended up being pretty important to what happened at Dropbox in 2014. Learning what happened to Procter & Gamble and selling makeup ended up actually being pretty relevant. So I think having a broad information diet is really important. And I've collated a list of books that were really impactful to me. You can find a way to share that. All right, I'd be happy to share that.

**中文翻译:**
军事力量。是的，就像你只能做这么多，或者只能思考这么多，你的注意力有限。但这其实不是最大的教训。在《星际争霸》和其他游戏中，有“微操”（micro）和“大局观”（macro）的概念，我还要加上一个“元游戏”（meta game）。那是什么？在这些游戏中，比如《星际争霸》，微操就是：你能否快速点击，移动你的单位，快速建造东西？这关乎操作技巧。每一秒钟，你每分钟做几百个动作，或者每秒钟做几个动作？这是一种条件反射和练习。
(01:29:43):
然后是大局观。回到产品或初创公司的语境，微操可能是：我如何处理产品设计、技术和分发。早期创始人尤其会完全专注于：我如何做出这个伟大的设计，工程如何运作，我们如何获取用户，我们的销售流程如何运作，或者我们的病毒循环如何运作。这非常注重细节。
(01:30:12):
接着是大局观。在《星际争霸》中，这可能是：点击很多次很重要，但总体上你是在管理你的经济。你是否比对手拥有更多的分基地和资源？你是否在扩充军队？你是否平衡了经济和军事的投入？你是否在侦察？你知道对方在做什么吗？这更具战略性和概念性。在创业领域，这更像是：不仅是这个功能如何运作的机制，而是：商业模式是什么？市场在哪里？我的竞争对手是谁？我如何实现差异化？随着品类从超高速增长转向成熟，这一切将如何演变？然后你做出反应：好吧，我们必须从单一产品转向多产品，所以我们必须以这种方式重组公司，等等。
(01:31:11):
然后我会说还有“元游戏”（meta game），这在游戏界是一个很具体的词。它就像是游戏本身会更新，创作者会让这个单位变强，让那个空军单位变强，让那个地面单位变弱，试图保持大系统的平衡。同时，随着玩家群体摸索出新策略，在这个巨大的“石头剪刀布”重复博弈中，人们发现：好吧，这一种策略现在绝对更好。这总是一个不断变化的对抗过程。所以，2020 年玩《星际争霸》与 2015 年或 2010 年玩非常不同，因为玩家在变，游戏本身也在变。虽然游戏本身变化不大，但更多是一种生态效应。
(01:32:02):
所以我认为这超级重要。在创业语境下，什么是元游戏？我会说其中一部分就是商业周期。你会看到，2010 年代末 SaaS 和科技行业有一波繁荣。现在正有一波 AI 热潮。这与 1999、2000 年的互联网泡沫，或者 2007 年的 Web 2.0 时代并没有本质区别。然后你会遇到像 2008 年、2000 年、2001 年那样的萧条期。市场周期往往会创造类似的动态：比如五年前，每家科技公司都在尽可能多地招人，这创造了一种人才动态；现在，很多公司保持高薪不动甚至降薪，这又是完全不同的情况。但这些都是周期性的。
(01:33:03):
然后，你要识别商业游戏究竟在哪些方面发生了根本性的、永久性的变化。例如，我们发布 Dash 时，通常会做常规媒体公关、科技媒体公关，但我们几乎没得到什么报道。然而，我们在社交媒体上做的所有事情，或者直接面向用户的事情，影响力要大得多。这不仅发生在 Dropbox 或科技界，总统选举也是如此：所有候选人都上播客。是的，他们也上 CNN，但那不再是重点了。这就是新事物。你如何管理公司品牌，如何发布产品，诸如此类。营销的本质正在改变。这在 2007 年也变过：我们没有雇佣公关公司或购买 AdWords 广告，而是制作病毒视频，利用流行病学的数学模型来创建病毒循环。在很多方面，Dropbox 将消费级互联网的策略移植到了商业软件中。
(01:34:10):
但关键是，你需要了解你正在玩什么游戏，并且你需要擅长微操。并不是说元游戏比微操更重要，而是你需要同时做好这三点。这才是最难的部分。当事情发生变化时，了解你正在玩什么游戏的方法是系统地训练自己。我能给出的最有用、或者至少对我来说最重要的建议是：你必须设法让你的个人成长曲线领先于公司的成长曲线。对我来说，最重要、最有影响力的一件事就是阅读。因为谈到微操、大局观、元游戏或抽象概念，这些都是你可以从历史中学到的东西。
(01:34:55):
了解 Netscape 发生了什么，对 2014 年 Dropbox 发生的事情变得非常重要。了解宝洁如何卖化妆品，结果证明也非常相关。所以我认为拥有广泛的信息摄取非常重要。我整理了一份对我影响很大的书单，你可以找个办法分享出来。我很乐意分享。

---

### [01:35:18] Lenny Rachitsky

**English:**
Absolutely.

**中文翻译:**
当然。

---

### [01:35:20] Drew Houston

**English:**
But in a lot of ways, as a CEO, you have to be right about a lot of things, especially and including things you haven't done before. And I think from that perspective at least, I'd say there's things that are challenging for your head and things that are challenging for your heart. The head challenge is one that's more like, all right, how do I cultivate wisdom really quickly? And so, in addition to a lot of technical books about here's how you do marketing or product or management or things like that. So it could be around higher level, almost philosophical when it's things like Buffett or Munger or Bezos would be more on that end of the spectrum. But it's not just reading. I think having a community of people that you can learn from is really important. And I've also found it's interesting, you learn having stable of people that are at the same stage as you, couple people, a couple stages ahead, 2 years ahead, 5 years ahead, 20 years ahead.

**中文翻译:**
但在很多方面，作为 CEO，你必须在很多事情上做对，尤其是包括那些你以前从未做过的事情。我认为至少从那个角度来看，有些事情挑战你的头脑，有些事情挑战你的内心。头脑的挑战更多是：好吧，我如何快速培养智慧？所以，除了大量关于如何做营销、产品或管理的专业书籍外，还可以读一些更高层次、近乎哲学的东西，比如巴菲特、芒格或贝佐斯的作品，他们处于光谱的那一端。但不仅仅是阅读，我认为拥有一个可以互相学习的社区非常重要。我还发现一件有趣的事：你需要有一群处于同一阶段的人，几个领先你几个阶段的人，领先 2 年、5 年、20 年的人。

---

### [01:36:23] Lenny Rachitsky

**English:**
And this is founders, other CEOs?

**中文翻译:**
这些是创始人，其他 CEO 吗？

---

### [01:36:25] Drew Houston

**English:**
Other founders, founders and CEOs, exactly, because you'll learn different things from them. So first of all, when you're in the early innings, you'll actually get more useful advice often from your peers because they're going through the same thing. So it's like, how do I raise a seed round? You're going to get a lot more out of someone who did that a year ago or is doing that now. Then if I asked the doc, "How do you raise a seed round?" He'd be like, "I don't remember. Just build a good company."
(01:36:55):
And you'll see that as you talk to people at different phases. I think again, early stage it's more about the micro, about the product and distribution, then there's this continuum. So then it's about your business model and monetization and the financials, then it's about defensibility and maintaining that advantage. And as you talk to, as I talked to my peers would be more about the product. That was the scaffold I would see over founders.
(01:37:26):
And then, people that were further out, actually they still knew all the micro stuff and had feelings about it, but they're almost philosophical in nature like philosophers and just very broad intellectually and drawing lots of distinctions from lots of different things and knew a lot about a lot. And I think most of the tenured founders that I'm, most of the founder CEOs who've been at it for 10, 20 years plus, I'm at 17, almost all of them read voraciously. So I think combination of reading and community are the most important things.
(01:38:02):
But then, the last thing is being systematic about it. So in line with what does it mean to keep your personal growth curve ahead of the company's growth curve? I think one way to do that exercise is think about is always be working back from, in one year from now, what will I wish I had been learning today? Two years, five years? And often, those to-do lists are pretty different.
(01:38:23):
So in 2008, I would've been focused on just getting users for Dropbox, but then looking ahead to a year later, I would've been building the first business functions in the company, and then five years later, it would be thinking about how do we fight with Google and Microsoft and all these other things. And then, for my own skills, it would be like 2008 where like how do I raise a scale to venture round and what do all these terms mean and things like that. But then, how do I be a great leader, great manager, comfortable speaking publicly, things like that. And the things that are further out are often the most intimidating, but you also have the most time to learn and you often can psych yourself out in terms of like, oh, this is just new and uncomfortable. And I did say this is one of the hard challenges. You're always going to have that feeling of discomfort. And instinctively, what you're going to want to do is run away from it because you're human. It's uncomfortable to feel like to confront these things that you're not good at or might be embarrassing or threatening. And so, I think an important part of being a founder is learning to run towards that feeling not away from it. That's a big part of your learning rate is the extent to which you're pushing yourself beyond discomfort.
(01:39:43):
And so having that list of a year from now, two years from now, five years from now, what can I start learning today? And then, recognizing these things, they're all trainable. So in five weeks you're not going to be a great guitar player or surgeon or manager, leader, but in five years you can put a pretty big dent in those problems. And people who enter college and leave college often have a lot more relevant knowledge after those four years. So just having that growth mindset.
(01:40:16):
And I'd say the last piece of it that is also tricky in addition to going from a heart or mindset perspective going towards discomfort and in addition to a lot of the other stuff we talked about being like how do you have a sense of equanimity, you're not burning out and finding a sustainable pace. I think the other thing is often smart people have more trouble learning than otherwise. And there's this great article that I, it's probably my most handed out articles probably from the '70s or '80s or something called Teaching Smart People How to Learn. Because what ends up happening is the more book smart you are or the more you were identified as gifted or intelligent as a kid, the more not knowing something or being wrong, it's not just not knowing something or being wrong, it's like an assault on your identity.
(01:41:11):
And so, I found that one of the best predictors of an exact continuity of this scale, it's not just what they know or what they can do, but the extent to which they can actually be aware of their failures and not blame or dismiss things because smart people have a really fast rationalization hamster. They can convince themselves that, well, here's how they were technically right even though clearly they were wrong or clearly the thing didn't work out and they let themselves off the hook. And all of this happens unconsciously as a protective mechanism.
(01:41:47):
So I think finding ways to take responsibility or always have a mindset of what if I were a hundred percent responsible for this? What if it was no one else's fault? What if it's entirely in my control? And those things are never true, but that's always... Or with perfect hindsight, what would I have done differently? And just owning things ends up being more painful in the short run, but then some painful hours can save painful years. And there's a great book on that mindset stuff, the 15 Principles of Conscious Leadership, Diana Chapman and some co-authors, and she's been a coach and friend of mine. She's amazing and it has really helped me on that front. But really, how do you train your head and train your heart? There's different things you do for each, but all in service of keeping your personal growth curve ahead of the company's growth curve.

**中文翻译:**
是的，其他创始人、创始人兼 CEO，正是如此，因为你会从他们身上学到不同的东西。首先，当你处于早期阶段时，你通常会从同行那里得到更多有用的建议，因为他们正在经历同样的事情。比如：“我该如何进行种子轮融资？”从一个一年前做过这件事或现在正在做这件事的人那里，你会学到更多。如果我问一个老手：“你如何进行种子轮融资？”他可能会说：“我不记得了，只要打造一家好公司就行。”
(01:36:55):
当你与处于不同阶段的人交谈时，你会发现这一点。我认为早期更多关乎微操，关乎产品和分发。然后是一个连续体：接着关乎商业模式、变现和财务；再接着关乎防御性和维持优势。当我与同行交谈时，更多是关于产品。这是我在创始人身上看到的阶梯。
(01:37:26):
而那些走得更远的人，实际上他们仍然了解所有的微操细节并有自己的见解，但他们本质上更像哲学家，知识面非常广，能从许多不同的事物中归纳出细微差别，博学多才。我认为大多数资深创始人，那些做了 10 年、20 年以上的创始人 CEO（我已经做了 17 年），几乎所有人都是贪婪的阅读者。所以阅读和社区的结合是最重要的事情。
(01:38:02):
最后一点是系统化。为了让个人成长曲线领先于公司的成长曲线，我认为一种练习方式是：始终从未来反推。一年后，我会希望自己今天学到了什么？两年后、五年后呢？通常，这些待办清单是非常不同的。
(01:38:23):
在 2008 年，我会专注于为 Dropbox 获取用户。但展望一年后，我会专注于建立公司的第一批业务职能；五年后，会思考如何与谷歌、微软等巨头竞争。对于我自己的技能，2008 年我会想如何进行风险融资、这些条款是什么意思；但之后，我会想如何成为一名伟大的领导者、伟大的管理者、如何自如地进行公开演讲等等。那些遥远的事情往往最让人畏惧，但你也有最多的时间去学习。你经常会因为事情陌生和不舒服而退缩。我说过这是最难的挑战之一：你总会有那种不舒服的感觉。本能地，你会想逃避，因为你是人类。面对你不擅长、可能尴尬或具有威胁性的事情，感觉很不舒服。所以，我认为成为创始人的一个重要部分是学会跑向那种感觉，而不是逃避。你的学习率很大程度上取决于你在多大程度上把自己推向不适区。
(01:39:43):
所以，列出一年后、两年后、五年后的清单，看看今天可以开始学习什么。然后意识到，这些事情都是可以训练的。在五周内你不会成为伟大的吉他手、外科医生或管理者，但在五年内你可以极大地解决这些问题。进入大学和离开大学的人，在四年后通常会拥有更多相关的知识。所以只要拥有那种增长心态。
(01:40:16):
最后一部分也很棘手，除了从内心或心态层面跑向不适，以及我们谈到的保持沉着、不倦怠、寻找可持续的节奏外，我认为另一件事是：聪明人往往比普通人更难学习。有一篇伟大的文章，可能是我分发次数最多的文章，大概是 70 或 80 年代的，叫《教聪明人如何学习》（Teaching Smart People How to Learn）。因为事实是，你越是书本上的聪明人，或者小时候被认定为有天赋或聪明的孩子，那么“不知道某事”或“犯错”就不再仅仅是不知道或犯错，而成了对你身份的攻击。
(01:41:11):
所以我发现，预测一个高管在这个规模下能否持续发展的最佳指标之一，不仅是他们知道什么或能做什么，而是他们在多大程度上能意识到自己的失败，并且不推卸责任或轻视问题。因为聪明人脑子里有一个跑得飞快的“合理化仓鼠”，他们可以让自己相信，即使显然错了或事情没成，他们在技术上也是对的，从而让自己摆脱责任。这一切都是作为一种保护机制无意识发生的。
(01:41:47):
所以，我认为要寻找承担责任的方法，或者始终保持一种心态：如果我对这件事负 100% 的责任会怎样？如果这不是别人的错呢？如果这完全在我的控制之下呢？这些假设永远不完全真实，但这就是……或者拥有完美的后见之明，我会做哪些不同的选择？在短期内，承担责任会更痛苦，但几个小时的痛苦可以节省几年的痛苦。关于这种心态有一本很棒的书叫《意识领导力的 15 条原则》（The 15 Principles of Conscious Leadership），作者是 Diana Chapman 和几位合著者，她一直是我的教练和朋友。她非常了不起，在那方面给了我很大帮助。但归根结底，你如何训练你的头脑和内心？每一项都有不同的方法，但都是为了让你的个人成长曲线领先于公司的成长曲线。

---

### [01:42:39] Lenny Rachitsky

**English:**
I love how tactically your advice is. There's this piece of advice of think what do I need to know a year from now, two years from now, five years from now, this reading list, this idea of having staggered staged founders in a community to help you along this journey, this article about how smart people learn and how to get past this block. So I love just how concrete a lot of this stuff is. So then, just zooming out and maybe final reflections on this journey, as you described this, it's basically the epitome of the hero's journey that you've been on here. Things are good, trouble appears, you enter this other land of everyone coming at you trying to squash you in every direction, battling them, and then emerging now into this new land with all the things you've learned, coming back to the original idea of what Dropbox could have been. So I think that's partly why it's so interesting is it's the epitome of-

**中文翻译:**
我喜欢你的建议如此具有战术性。比如思考一年、两年、五年后需要知道什么，那个书单，在社区中拥有不同阶段的创始人来帮助你，还有关于聪明人如何学习以及如何突破障碍的文章。我喜欢这些东西的具体程度。那么，放大来看，也许是对这段旅程的最后反思：正如你所描述的，这基本上是你经历的一场“英雄之旅”的缩影。起初一切都好，麻烦出现，你进入了另一个领地，所有人都在各个方向试图压垮你，你与他们战斗，现在带着你学到的所有东西出现在这片新土地上，回到了 Dropbox 最初可能成为的样子。我想这就是为什么它如此有趣，它是——的缩影。

---

### [01:43:29] Drew Houston

**English:**
But we still got to make it fully out of the, we're on our way up, we're clawing our way back up.

**中文翻译:**
但我们仍然需要完全走出来，我们正在向上的路上，我们正在努力爬回巅峰。

---

### [01:43:37] Lenny Rachitsky

**English:**
The dragon's still out there. The incumbents still exist.

**中文翻译:**
巨龙依然存在，老牌巨头依然在那。

---

### [01:43:41] Drew Houston

**English:**
And by the way, it will always be like that. You're never done with that. It's not like you reach the A-top or you don't have to if you don't want it.

**中文翻译:**
顺便说一句，情况永远会是这样。你永远无法彻底完成。并不是说你达到了顶峰就结束了，除非你不想再玩下去了。

---

### [01:43:53] Lenny Rachitsky

**English:**
And it makes me think about, as you're talking, people think about product market fit and something, a lesson from this journey is just like product market fit is not a binary. You will have it now. You've got it and you have it and will last forever. It's constantly being broken by other people or if there's something you've discovered that is a big market. And maybe final reflection on the story you've shared things that might be helpful to people, just the journey you've been on that might be helpful to founders who are going through this right now or will probably go through this.

**中文翻译:**
听你说话让我想到，人们常谈论“产品市场契合度”（PMF），而这段旅程的一个教训是：PMF 并不是非黑即白的。并不是说你现在拥有了它，它就会永远持续下去。它不断被别人打破，或者如果你发现了一个大市场，竞争就会随之而来。也许最后再反思一下你分享的故事中对人们有帮助的部分，特别是对那些正在经历或可能经历这些的创始人们。

---

### [01:44:20] Drew Houston

**English:**
I think it's important to remember we're all really lucky to be able to do this kind of work. And the things that I got out of... When I was 18, the things I thought I would get out of starting company would've been the things you would think. It'd be like, oh, I'll be really well-known or really rich or build these awesome things. I think there's benefits to that, but what I've grown to appreciate a lot more is over time is this thing or the experience and the journey of starting a company can really be of forge for a better character or there's transfer. A lot of what you learn here is transferable in many different domains.
(01:45:11):
I just had a little kid, Charlie, he's one-year-old, so I know we're both in new dad mode, but I'm like, it's made me a better husband, it'll make me a better father, made me a better person. And then, I just say, listen, there's no easy button where things are just up to the right and so don't look for one and don't feel bad if things are difficult. But ultimately, one of the biggest surprises about being able to spend time with all these interesting people and founder CEOs who've created these iconic companies is at the end of the day, they do it because they love it.
(01:45:56):
And so, I think learning to decouple... That doesn't mean they're always having a good time at all. Most of them use metaphors like Jensen or Eli, like chewing broken glass, staring into the abyss, and yet for a lot of these people, there's at the end of the day, nothing they'd rather do. So I think finding the gun in that.

**中文翻译:**
我认为重要的是要记住，我们能做这种工作真的很幸运。当我 18 岁时，我以为创办公司能得到的东西就是你通常想的那些：出名、变富、打造酷炫的东西。我认为这些确实有好处，但随着时间的推移，我越来越感激的是：创办公司的经历和旅程真的可以成为磨炼更好性格的熔炉，或者说这是一种迁移。你在这里学到的很多东西在许多不同领域都是通用的。
(01:45:11):
我刚有了个孩子 Charlie，他一岁了，我知道我们都处于“新手爸爸”模式。我觉得这段旅程让我成为了更好的丈夫，也会让我成为更好的父亲，让我成为了更好的人。然后我想说，听着，没有一个“简易按钮”能让事情永远一路向上，所以不要去找它，如果事情变得困难，也不要觉得难受。但最终，能与所有这些有趣的人、那些创造了标志性公司的创始人 CEO 们共处，最大的惊喜之一是：归根结底，他们这样做是因为他们热爱它。
(01:45:56):
所以，我认为学会解耦……这并不意味着他们总是过得很开心。他们中的大多数人会使用像黄仁勋（Jensen）或埃隆（Elon）那样的比喻，比如“嚼着碎玻璃凝视深渊”。然而对于这些人中的大多数来说，到头来，没有比这更让他们想做的事了。所以，我认为要从中找到乐趣。

---

### [01:46:19] Lenny Rachitsky

**English:**
I'm very excited to follow the next chapter of your journey. I am really thankful that you shared these stories. I think this is going to be helpful to a lot of people. I think this is a story that people study for a long time because it's common and not talked about much. Drew, thank you so much for being here. For folks that want to maybe check out what you're building, anything you want to share, where should they go?

**中文翻译:**
我非常期待关注你旅程的下一个章节。我真的很感谢你分享这些故事。我认为这对很多人都会有帮助。我认为这是一个人们会研究很长时间的故事，因为它很普遍，但很少被谈论。Drew，非常感谢你能来。对于那些想看看你正在打造的产品的人，有什么想分享的吗？他们该去哪里？

---

### [01:46:40] Drew Houston

**English:**
I'm just Drew Houston on all the socials and then we got our new product, Dropbox Dash, dropbox.com/dash. Right now, it's for companies. We'll have a downloadable version. You could just get on your phone or your computer soon. But Lenny, this is awesome, super fun, really big fan of what you do.

**中文翻译:**
在所有社交媒体上搜 Drew Houston 就能找到我。我们还有新产品 Dropbox Dash，网址是 dropbox.com/dash。目前它是面向公司的，我们很快会推出下载版，你可以在手机或电脑上使用。Lenny，这太棒了，超级有趣，我是你的忠实粉丝。

---

### [01:46:59] Lenny Rachitsky

**English:**
Awesome. Same. Drew, thank you so much for being here.

**中文翻译:**
太棒了，我也是。Drew，非常感谢你能来。

---

### [01:47:03] Drew Houston

**English:**
Thanks.

**中文翻译:**
谢谢。

---

### [01:47:04] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。