# Eeke de Milliano - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Eeke de Milliano.

---

### [00:00:00] Eeke de Milliano

**English:**
Process, by definition, is variance reducing. You're introducing it, because you worry that the variance in your org is too high. You want people to sort of meet a certain standard.

**中文翻译:**
从定义上讲，流程是为了减少差异（variance reducing）。你引入流程，是因为你担心组织内部的差异性太高。你希望大家都能达到某种特定的标准。

---

### [00:00:13] Eeke de Milliano

**English:**
And the cost of that is obviously, while you are reducing the standard and bringing folks up to the average, you're also bringing other folks down to the average. And oftentimes, the folks you're bringing down are your highest performers, your most creative thinkers. The folks who, I think actually don't really need process to do their best work.

**中文翻译:**
而这样做显然是有代价的：当你通过降低标准将一部分人拉到平均水平时，你同时也把另一部分人拉低到了平均水平。通常情况下，那些被拉低的人正是你公司里表现最优秀、最有创造力的思考者。我认为，这些人其实根本不需要流程就能做出最出色的工作。

---

### [00:00:34] Eeke de Milliano

**English:**
And so, that, I think is always the tension that you have with process. And obviously one of the reasons why companies introduce process much more and more, as companies get bigger, is because it's harder to get all these folks who don't need processing. You actually want to reduce the variance.

**中文翻译:**
所以，我认为这就是流程中始终存在的张力。显然，随着公司规模变大，公司会越来越多地引入流程，原因之一就是很难招到那么多不需要流程的人。你实际上是想减少这种不确定性和差异。

---

### [00:00:52] Lenny

**English:**
Welcome to Lenny's podcast, where I interview world-class product leaders and growth experts, to learn from their hard own experiences, building and scaling today's most successful companies.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，从他们建立和扩展当今最成功公司的宝贵经验中学习。

---

### [00:01:01] Lenny

**English:**
Today, my guest is Eeke de Milliano. Eeke is head of product at Retool. Prior to that, she was a longtime PM at Stripe. She was actually one of their very first PMs, where she helped build some of their foundational products like Stripe Checkout, Stripe Connect, Stripe Radar, and Stripe Chargeback Protection.

**中文翻译:**
今天的嘉宾是 Eeke de Milliano。Eeke 目前是 Retool 的产品负责人。在此之前，她是 Stripe 的资深产品经理（PM）。她实际上是 Stripe 最早的几位 PM 之一，参与构建了许多基础产品，如 Stripe Checkout、Stripe Connect、Stripe Radar 和 Stripe 拒付保护（Chargeback Protection）。

---

### [00:01:18] Lenny

**English:**
I had a total blast chatting with Eeke. We covered Stripe's internal culture and what makes it so unique and innovative. How to foster and protect innovation at your own company. What is the right amount of process by stage of company? How to build a talent portfolio. And so much more.

**中文翻译:**
我和 Eeke 聊得非常开心。我们探讨了 Stripe 的内部文化以及是什么让它如此独特且具有创新性；如何在自己的公司培养和保护创新；不同阶段的公司适合多少程度的流程；如何构建人才组合，以及更多精彩内容。

---

### [00:01:32] Lenny

**English:**
I am really excited for you to hear this episode. And with that, I bring you Eeke de Milliano, after a short word from our wonderful sponsors.

**中文翻译:**
我非常期待大家听到这一集。在听完我们优秀的赞助商简短介绍后，让我们欢迎 Eeke de Milliano。

---

### [00:01:41] Lenny

**English:**
Today's episode is brought to you by Miro, an online visual whiteboard that's designed specifically for teams like yours and mine. I have a quick request. Head on over to my board at Miro.com/Lenny and let me know which guest you'd love for me to have on in 2023.

**中文翻译:**
本集节目由 Miro 赞助播出。Miro 是一款专为你我这样的团队设计的在线视觉白板。我有一个小请求：请访问我在 Miro.com/Lenny 上的看板，告诉我你希望我在 2023 年邀请哪位嘉宾。

---

### [00:01:56] Lenny

**English:**
And while you're on the Miro board, feel free to play around with the tool. It's a great shared space to work closely with your colleagues, to capture ideas, get feedback, and iterate quickly and easily on anything you're working on.

**中文翻译:**
当你访问 Miro 看板时，可以尽情体验这个工具。它是一个极佳的共享空间，可以让你与同事紧密协作、捕捉灵感、获取反馈，并对你正在进行的任何工作进行快速、轻松的迭代。

---

### [00:02:06] Lenny

**English:**
For example, in Miro, you can build out your product strategy by brainstorming with sticky notes, comments, live reactions, a voting tool. Even an estimation app, to scope out your team sprints.

**中文翻译:**
例如，在 Miro 中，你可以通过便签、评论、实时反应和投票工具进行头脑风暴，从而构建你的产品策略。甚至还有一个估算应用，用来规划团队的冲刺（sprints）范围。

---

### [00:02:16] Lenny

**English:**
Your whole distributed team can come together around a wireframe and draw ideas with a pen tool. Or even put mocks right into the Miro board.

**中文翻译:**
你整个分布式团队可以围绕一个原型图（wireframe）聚在一起，用画笔工具勾勒想法，甚至可以直接把模型图（mocks）放进 Miro 看板里。

---

### [00:02:24] Lenny

**English:**
And, with one of Miro's readymade templates, you can go from discovery and research, to your product roadmap, to customer journey flows, to final mocks. You get the picture.

**中文翻译:**
而且，利用 Miro 现成的模板，你可以完成从发现和研究，到产品路线图，再到客户旅程图，最后到最终模型图的全过程。你懂我意思吧。

---

### [00:02:33] Lenny

**English:**
Head on over to Miro.com/Lenny to leave your suggestions. That's M-I-R-O.com/Lenny.

**中文翻译:**
请访问 Miro.com/Lenny 留下你的建议。网址是 M-I-R-O.com/Lenny。

---

### [00:02:41] Lenny

**English:**
This episode is brought to you by Notion. If you haven't heard of Notion, where have you been? I use Notion to coordinate this very podcast, including my content calendar, my sponsors, and prepping guests for the launch of each episode.

**中文翻译:**
本集节目由 Notion 赞助。如果你还没听说过 Notion，那你最近都去哪儿了？我用 Notion 来协调这个播客的所有事务，包括内容日历、赞助商沟通，以及为每集节目的发布准备嘉宾资料。

---

### [00:02:55] Lenny

**English:**
Notion is an all-in-one team collaboration tool that combines note-taking, document sharing, wikis, project management, and much more, into one space that's simple, powerful and beautifully designed.

**中文翻译:**
Notion 是一款全能的团队协作工具，它将笔记、文档共享、维基（wikis）、项目管理等功能整合在一个简洁、强大且设计精美的空间里。

---

### [00:03:06] Lenny

**English:**
And not only does it allow you to be more efficient in your work life, but you can easily transition to using it in your personal life, which is another feature that truly sets Notion apart. The other day, I started a home project and immediately opened up Notion to help me organize it all.

**中文翻译:**
它不仅能让你在工作中更高效，还能轻松过渡到个人生活中使用，这是 Notion 真正脱颖而出的另一个特点。前几天，我开始了一个家庭项目，立刻就打开 Notion 来帮我整理一切。

---

### [00:03:21] Lenny

**English:**
Learn more and get started for free at Notion.com/LennysPod. Take the first step towards an organized happy team, today. Again, at Notion.com/LennysPod.

**中文翻译:**
访问 Notion.com/LennysPod 了解更多信息并免费开始使用。今天就迈出走向有序、快乐团队的第一步。网址再次重复：Notion.com/LennysPod。

---

### [00:03:36] Lenny

**English:**
Eeke, welcome to the podcast.

**中文翻译:**
Eeke，欢迎来到播客。

---

### [00:03:39] Eeke de Milliano

**English:**
Thanks so much for having me, Lenny.

**中文翻译:**
非常感谢邀请我，Lenny。

---

### [00:03:41] Lenny

**English:**
It's absolutely my pleasure. A bunch of people have told me that I need to have you on this podcast. And actually, a big thank you to Snir Kodesh, who I believe is a colleague of yours, who gave me a bunch of interesting questions to ask you. So, I hope you're ready.

**中文翻译:**
这是我的荣幸。很多人都跟我说一定要请你来。实际上，要特别感谢 Snir Kodesh，我相信他是你的同事，他给了我很多有趣的问题来问你。所以，希望你准备好了。

---

### [00:03:53] Eeke de Milliano

**English:**
Awesome. Very ready. Snir is the best, so yeah, I'm excited.

**中文翻译:**
太棒了，准备好了。Snir 是最棒的，所以我很期待。

---

### [00:03:57] Lenny

**English:**
So you're currently head of product at Retool, but before that you spent a lot of time at Stripe. You spent six years at Stripe. And so, before we get to Retool, I actually want to spend a little time on Stripe.

**中文翻译:**
你目前是 Retool 的产品负责人，但在此之前你在 Stripe 待了很长时间，整整六年。所以在聊 Retool 之前，我想先花点时间聊聊 Stripe。

---

### [00:04:08] Lenny

**English:**
To set a little foundation, could you just talk about some of the things you worked on at Stripe? And maybe some of the things you're most proud of, during that time?

**中文翻译:**
为了做点铺垫，你能谈谈你在 Stripe 工作期间负责的一些项目吗？或者在那段时间里你最引以为豪的事情？

---

### [00:04:15] Eeke de Milliano

**English:**
Yeah. So when I joined Stripe, I joined Stripe in 2013. It was pretty small at the time, it was around 50 people. And Stripe didn't have any product managers at that time.

**中文翻译:**
好的。我是 2013 年加入 Stripe 的。当时公司规模很小，大约只有 50 人。那时候 Stripe 还没有任何产品经理。

---

### [00:04:23] Eeke de Milliano

**English:**
And I think Stripe was kind of famous for that. And it really wasn't because we were anti-PM in any way. It was mostly just because we were building this product for developers. We had a lot of really talented engineers, who were essentially doing the PM job.

**中文翻译:**
我想 Stripe 当时因此而闻名。这并不是因为我们反对 PM，主要是因为我们是在为开发者构建产品。我们有很多非常有才华的工程师，他们实际上承担了 PM 的工作。

---

### [00:04:36] Eeke de Milliano

**English:**
So I actually joined Stripe as the first account executive, which I think is pretty funny, now that I've seen real account executives do their jobs. Because I really just had no business doing that job. But it also really wasn't your typical sales job, in that most of Stripes volume was inbound. So I was really just spending all of my day talking to customers, helping them figure out how Stripe might work for their particular business flows, and payment models.

**中文翻译:**
所以我最初是以第一位客户经理（AE）的身份加入 Stripe 的。现在回想起来觉得挺好笑的，因为在见识过真正的 AE 是如何工作的之后，我发现我当时根本不具备做那份工作的素质。但那也不是典型的销售工作，因为 Stripe 的大部分业务量都是主动找上门的（inbound）。所以我整天都在和客户交流，帮他们弄清楚 Stripe 如何适配他们特定的业务流程和支付模型。

---

### [00:05:03] Eeke de Milliano

**English:**
And a lot of it was, I think, what PMs do. It was just talking to customers, understanding their pain points, and really helping them figure out how the product might do that. And to this day, when people ask me, "Hey, what's your advice for going into product management?" I'm like, "Well, you should go get a sales job. I think it's pretty valuable."

**中文翻译:**
我觉得那份工作的很多内容其实就是 PM 在做的：与客户交谈，了解他们的痛点，并真正帮助他们弄清楚产品如何解决这些问题。直到今天，当人们问我“进入产品管理领域有什么建议”时，我会说：“你应该先去做一份销售工作，我认为这非常有价值。”

---

### [00:05:21] Eeke de Milliano

**English:**
But, it's kind of a long story to explain that, at the time there was this one sort of business model, the two-sided marketplace business model, that was just becoming huge. And you can't even really sort of imagine that now, but back then, Airbnb, Lyft, Uber, all those marketplaces, it was quite a new way of doing business.

**中文翻译:**
说来话长，当时有一种业务模式——双边市场（two-sided marketplace）模式——正开始爆发。现在你可能很难想象，但在那时，Airbnb、Lyft、Uber 这些平台，都是非常新颖的商业模式。

---

### [00:05:41] Eeke de Milliano

**English:**
And so, I was talking to all these customers and they had pretty complicated payment needs. So it was like, one payer putting in funds and it's getting paid out to a recipient. So an Airbnb guest and an Airbnb host. Or multiple payers putting funds in and it's getting paid out to one recipient, like a GoFundMe campaign. Or one payer putting in money and it going out to multiple recipients, like with ClassPass, where you get a subscription and then it gets paid out to a bunch of studios.

**中文翻译:**
我当时接触的这些客户都有非常复杂的支付需求。比如，一个付款人存入资金，然后支付给一个收款人（如 Airbnb 的房客和房东）；或者多个付款人存入资金支付给一个收款人（如 GoFundMe 的众筹活动）；再或者一个付款人付钱，分发给多个收款人（如 ClassPass，你买一个订阅，然后钱会分发给很多健身工作室）。

---

### [00:06:10] Eeke de Milliano

**English:**
And then on top of that, all these platforms and marketplaces started having all these pretty complex regulatory and compliance requirements that were pretty different, country to country.

**中文翻译:**
除此之外，所有这些平台和市场开始面临非常复杂的监管和合规要求，而且各国之间差异巨大。

---

### [00:06:18] Eeke de Milliano

**English:**
So it was just this really complicated financial infrastructure problem, and Stripe actually didn't really have the right solution for it. And no one else in the market did, either.

**中文翻译:**
所以这是一个非常复杂的金融基础设施问题，而当时的 Stripe 并没有合适的解决方案，市场上其他公司也没有。

---

### [00:06:28] Eeke de Milliano

**English:**
So at the time, this Stripe engineer, Brian Krausz, started poking around at this problem. Because I was talking to so many of these customers, we started talking about this problem together and poking around. And that actually resulted in us launching this sort of evolution of this product that we had at the time, called Stripe Connect.

**中文翻译:**
当时，Stripe 的工程师 Brian Krausz 开始研究这个问题。因为我接触了大量此类客户，我们便开始一起讨论并探索。这最终促使我们推出了当时已有产品的一个进化版，叫做 Stripe Connect。

---

### [00:06:46] Eeke de Milliano

**English:**
That was easily, I think, one of my favorite products I worked on. Not only, it ended up actually being really quite significant for Stripe's business. But also, because it was the first product and I think that's always pretty special.

**中文翻译:**
那绝对是我最喜欢的产品之一。不仅因为它最终对 Stripe 的业务产生了重大影响，还因为它是我的第一个产品，我觉得这总是很特别。

---

### [00:06:58] Eeke de Milliano

**English:**
And then, the second product that I think of very fondly during my time at Stripe, was this product, Stripe Radar. So Stripe obviously processes a lot of payments. Wherever there's money, fraudsters will kind of follow.

**中文翻译:**
我在 Stripe 期间非常喜欢的第二个产品是 Stripe Radar。Stripe 处理大量支付业务，而哪里有钱，骗子就会跟到哪里。

---

### [00:07:12] Eeke de Milliano

**English:**
And there were certainly some merchants who were just particularly vulnerable to payments fraud. So, someone's using stolen credit card information to essentially purchase a good.

**中文翻译:**
确实有一些商家特别容易受到支付欺诈的影响。比如，有人使用盗取的信用卡信息来购买商品。

---

### [00:07:21] Eeke de Milliano

**English:**
And if you're not in payments, this is going to sound kind of shocking. But if a merchant processes a payment from a customer and that customer used a stolen credit card, the merchant is ultimately on the hook for those funds. So it can be detrimental. The merchant who's trying to run a real business is just losing all of this money, because there are all of these frauds who are buying stuff from them online.

**中文翻译:**
如果你不从事支付行业，这听起来可能有点震惊：如果商家处理了一笔来自客户的付款，而该客户使用的是盗刷信用卡，那么商家最终要承担这笔资金的损失。这可能是致命的。那些正经经营生意的商家会因为这些在线购物的骗子而损失惨重。

---

### [00:07:48] Eeke de Milliano

**English:**
So I really liked working on that product. So the product at Stripe was essentially, we built a bunch of machine learning models to try and predict when a payment was fraudulent. And then we built a product on top of that, to help customers understand why we were blocking payments, and help them write their own rules around that too.

**中文翻译:**
所以我非常喜欢做这个产品。Stripe 的这个产品本质上是我们构建了一系列机器学习模型，试图预测一笔付款是否具有欺诈性。然后我们在其基础上构建了一个产品，帮助客户理解我们为什么要拦截某些付款，并帮助他们制定自己的规则。

---

### [00:08:03] Eeke de Milliano

**English:**
And that was really fun, both from an anthropological perspective. Because we were kind of hanging out in corners of the internet where you wouldn't usually go if you were doing only legal things. So we were trying to understand who these fraudsters were.

**中文翻译:**
这非常有趣，甚至带点人类学色彩。因为我们会出没于互联网的一些隐秘角落，如果你只做合法的事情，通常是不会去那里的。我们试图了解这些骗子到底是谁。

---

### [00:08:16] Eeke de Milliano

**English:**
But it was also really cool from a product perspective, because of all the kind of complicated product questions around how humans should interact with AI and models. And I imagine a lot of the folks in the latest movement in AI are thinking a lot about that too. It's like, "How do you explain a model to humans? How do you let them interact with it?"

**中文翻译:**
从产品角度来看也很酷，因为涉及很多关于人类如何与 AI 和模型交互的复杂产品问题。我想现在 AI 浪潮中的很多人也在思考这些问题，比如：“你如何向人类解释一个模型？你如何让他们与之交互？”

---

### [00:08:33] Eeke de Milliano

**English:**
So, both those things were really, really neat.

**中文翻译:**
所以，这两件事都非常非常有意思。

---

### [00:08:37] Lenny

**English:**
I actually use Stripe for my newsletter. It's how folks subscribe. And when I log into my Stripe Dashboard, there's so many products. I don't even know what many of them do. But I've often seen Radar being pitched to me as something I should pay for.

**中文翻译:**
我的时事通讯（newsletter）其实就在用 Stripe，那是读者订阅的方式。当我登录 Stripe 后台时，看到的产品太多了，很多我甚至不知道是干什么的。但我经常看到 Radar 被推荐给我，说是我应该付费使用的功能。

---

### [00:08:53] Eeke de Milliano

**English:**
Nice.

**中文翻译:**
太好了。

---

### [00:08:53] Lenny

**English:**
And I feel like I should probably turn it on. That sounds really useful.

**中文翻译:**
我觉得我可能真的应该开启它，听起来非常有用。

---

### [00:08:57] Lenny

**English:**
One thing, that I want to dig in on... So you said when you joined, there were no PMs at Stripe. How many PMs were there when you moved into product at Stripe?

**中文翻译:**
有一件事我想深入了解一下……你说你加入时 Stripe 没有 PM。那么当你转岗到产品部门时，Stripe 有多少个 PM？

---

### [00:09:06] Eeke de Milliano

**English:**
That a great question. I want to say maybe three or four.

**中文翻译:**
问得好。我想大概只有三四个吧。

---

### [00:09:10] Lenny

**English:**
Wow. Incredible.

**中文翻译:**
哇，不可思议。

---

### [00:09:12] Eeke de Milliano

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:09:13] Lenny

**English:**
And you said Stripe is kind of known for being really late to PM and... I don't know if I want to say anti-PM, but there's a lot of sense of, "Why do we need PMs? We have amazing engineers who can decide what to build."

**中文翻译:**
你提到 Stripe 以很晚才引入 PM 而闻名……我不知道该不该用“反 PM”这个词，但当时确实有一种很强的氛围：“为什么我们需要 PM？我们有这么出色的工程师，他们可以决定该造什么。”

---

### [00:09:23] Lenny

**English:**
Is there anything you can share around that general philosophy of Stripe? And was it effective? Was it good? Because a lot of companies are anti-PM. And I think they always point to Stripe, and Snap is another example of, "We don't need PMs. Look how far these companies got with without PMs."

**中文翻译:**
关于 Stripe 的这种普遍哲学，你有什么可以分享的吗？这种做法有效吗？好吗？因为很多公司都反 PM，他们总是拿 Stripe 举例，Snap 是另一个例子，说：“我们不需要 PM，看这些公司在没有 PM 的情况下走了多远。”

---

### [00:09:38] Lenny

**English:**
Is there something unique to Stripe that allowed them not to have PMs? I think there was like 200 employees probably, by the time they had their first PM.

**中文翻译:**
Stripe 是否有什么独特之处让他们可以不设 PM？我想在他们招第一个 PM 时，公司大概已经有 200 名员工了吧。

---

### [00:09:44] Eeke de Milliano

**English:**
I think we actually had our first PM at... I want to say at about 100 employees.

**中文翻译:**
我想我们招第一个 PM 时……大概是在 100 人左右的时候。

---

### [00:09:47] Lenny

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:09:48] Eeke de Milliano

**English:**
But yeah, no, it was late in the game. And actually, maybe just to pattern match. Retool also didn't really have PMs for a while.

**中文翻译:**
但确实，在那个阶段已经算很晚了。实际上，做个类比，Retool 在一段时间内也没有真正的 PM。

---

### [00:09:57] Eeke de Milliano

**English:**
And I think actually both in the Stripe case and the Retool case, the thing that both of these companies have in common is, you're building for developers. The people who are building the product are the customers in a lot of ways. So, they get it. There's really no reason why you should have, in some ways, a middle man trying to figure out, "Hey, who's the customer, and what is it that they need?" And what are their pain points?"

**中文翻译:**
我认为 Stripe 和 Retool 的共同点在于：你是在为开发者构建产品。在很多方面，构建产品的人本身就是目标客户。所以，他们懂。在某种程度上，确实没有理由非要一个“中间人”去琢磨：“嘿，客户是谁？他们需要什么？他们的痛点是什么？”

---

### [00:10:19] Eeke de Milliano

**English:**
And I think the moment at which it became clear, "We really do need PMs at Stripe." And I think we felt the same way at Retool is, your customer base starts expanding. You start having different kinds of customers. You need to understand the whole market, all of the ICPs that you're going after.

**中文翻译:**
我认为在 Stripe（以及后来的 Retool）意识到“我们真的需要 PM”的时刻，是当你的客户群开始扩大时。你开始拥有不同类型的客户，你需要了解整个市场，以及你正在追求的所有理想客户画像（ICPs）。

---

### [00:10:35] Eeke de Milliano

**English:**
And the organization gets more complex. I think Stripe... Gosh, in particular, it's just an extremely matrixed organization in business. Because every time you launch a product, you're having to think about, "Well, how do we do this in other countries? There's different financial infrastructure. How do we think about the legal side, the compliance side, et cetera?"

**中文翻译:**
而且组织变得更加复杂。Stripe 尤其如此，它的业务是一个极其复杂的矩阵式组织。因为每当你发布一个产品，你都必须考虑：“在其他国家怎么做？那里的金融基础设施不同。法律层面、合规层面怎么考虑？”等等。

---

### [00:10:51] Eeke de Milliano

**English:**
And I think PMs can really kind of bring that whole story together and make the whole machine move. In addition to understanding the customers, and the value prop, and what the overall strategy was.

**中文翻译:**
我认为 PM 能够真正把这些碎片拼凑在一起，让整个机器运转起来。除了理解客户、价值主张和整体战略之外，这正是 PM 的作用。

---

### [00:11:04] Lenny

**English:**
That's a really good reminder of, engineers and designers can do the work of a PM, but often they don't want to. There's a lot of non-fun parts to it. They're like, "Oh, I wish we could have someone here do these things." And PMs enjoy that work. They're good at it. And so, eventually engineers and designers realize, "Okay, I see why maybe we should hire a PM."

**中文翻译:**
这是一个很好的提醒：工程师和设计师可以做 PM 的工作，但通常他们不想做。PM 工作中有很多无趣的部分。他们会想：“噢，我希望有人能来处理这些杂事。”而 PM 喜欢这些工作，也擅长这些。所以最终工程师和设计师会意识到：“好吧，我明白为什么我们该招个 PM 了。”

---

### [00:11:23] Eeke de Milliano

**English:**
I say this often actually, to folks who are thinking about going into product management. "That's awesome. Just be really, really sure about what you're signing up for."

**中文翻译:**
我经常对那些想进入产品管理领域的人说：“这很棒，但请务必清楚你到底在申请一份什么样的差事。”

---

### [00:11:33] Eeke de Milliano

**English:**
It's kind of the same as, I think a lot of people want to become a manager. But just so you know, being a manager is like, "Hey, you're doing performance reviews a lot. And you're in one-on-ones a lot." You have to really love that kind of work. And I think in the product management case, it's also like, you're constantly working across a lot of different teams. You're trying to influence a lot of people who don't report into you directly, to do a bunch of stuff.

**中文翻译:**
这有点像很多人想当经理。但你要知道，当经理意味着你要做大量的绩效评估，开大量的 1 对 1 会议。你必须真心热爱这类工作。在产品管理中也是如此，你不断地跨团队协作，试图影响许多并不直接向你汇报的人去完成一堆事情。

---

### [00:11:54] Eeke de Milliano

**English:**
And if you love that, that's great. But you've got to be sure you know you're signing up for it.

**中文翻译:**
如果你热爱这些，那太好了。但你必须确定自己知道这背后的代价。

---

### [00:12:00] Lenny

**English:**
Yeah, that's a really good comparison. When I first became a manager, I was an engineer, actually. And I was managing engineers. And then, when I moved on to something as an IC engineer, again, I was like, "I will never manage again. That was no fun at all. Why would I want to do this?"

**中文翻译:**
是的，这个类比很到位。我第一次当经理时其实是个工程师，管理其他工程师。后来当我重新做回独立贡献者（IC）工程师时，我想：“我再也不想当经理了，一点意思都没有，我为什么要干这个？”

---

### [00:12:12] Lenny

**English:**
And I imagine people get into product thinking they're going to have all this control, power, influence. And then they're like, "Oh my God, this job is so freaking crazy. What did I sign up for?"

**中文翻译:**
我猜很多人进入产品领域是觉得会有掌控感、权力和影响力。结果他们会发现：“天呐，这工作简直疯了，我到底签了什么合同？”

---

### [00:12:20] Eeke de Milliano

**English:**
It's so hard.

**中文翻译:**
真的很难。

---

### [00:12:23] Lenny

**English:**
Yeah. That reminds me, something that I heard you did at Stripe is, you wrote their internal culture guide. It was like a quick start guide to culture at Stripe, that I think was maybe shared with early employees.

**中文翻译:**
是的。这让我想起，我听说你在 Stripe 做过一件事：你编写了他们的内部文化指南。那就像是 Stripe 文化的快速入门指南，我想当时可能是分享给早期员工看的。

---

### [00:12:33] Lenny

**English:**
And if that's true, I'm curious what it is about Stripe's culture? If you could just briefly share just what makes Stripe so special. Clearly, it's one of the most successful companies in the world, in history. I know there's been a a slowdown with the market. Everyone's slowed down a bit.

**中文翻译:**
如果是真的，我很想知道 Stripe 的文化到底是什么样的？你能简要分享一下是什么让 Stripe 如此特别吗？显然，它是历史上全球最成功的公司之一。我知道最近市场有所放缓，大家都慢下来了。

---

### [00:12:48] Lenny

**English:**
But it feels like Stripe has been incredibly successful and continues to innovate like crazy. Hires incredible people. People that are starting amazing companies.

**中文翻译:**
但感觉 Stripe 一直非常成功，并且持续疯狂创新。他们雇佣了极其优秀的人才，这些人后来又创办了许多了不起的公司。

---

### [00:12:56] Lenny

**English:**
So I guess back to my question, what is it that you think makes Stripe's culture unique and special?

**中文翻译:**
所以回到我的问题，你认为是什么让 Stripe 的文化如此独特和特别？

---

### [00:13:01] Eeke de Milliano

**English:**
Yeah, that quick guide to Stripe's culture. I think we wrote it, maybe when we were around 150 people or so. And we actually wrote it to share with candidates.

**中文翻译:**
是的，那份 Stripe 文化快速指南。我想我们写它的时候，公司大概有 150 人左右。我们写它的初衷其实是分享给求职者的。

---

### [00:13:10] Eeke de Milliano

**English:**
Because the idea was like, "Look, we're kind of opinionated about how we do things here. Most companies struggle to describe what their culture is. Like, how does a fish describe water? But it's worthwhile getting a sense of the things that we feel opinionated about, and that you might like or you might not like."

**中文翻译:**
因为我们的想法是：“看，我们对这里的做事方式很有主见。大多数公司都很难描述自己的文化是什么，就像鱼很难描述水一样。但让你了解一下我们坚持的东西是很有价值的，你可能会喜欢，也可能不会。”

---

### [00:13:29] Eeke de Milliano

**English:**
And actually, when we put out the guide, our metric of success was that, more of the right people would apply to Stripe and fewer of the wrong people. And there was a whole section in there, I was like, "Hey, look, we work pretty hard here and that is certainly not for everyone. And hopefully you're excited to come and work really hard with colleagues who really care, and that's the reward." So, that's maybe one example.

**中文翻译:**
实际上，当我们发布这份指南时，我们的成功指标是：让更多对的人申请 Stripe，让不合适的人少申请。指南里有一整个章节大概是说：“嘿，听着，我们这里工作很努力，这肯定不适合所有人。希望你能因为能和一群真正投入的同事一起努力工作而感到兴奋，这就是回报。”这可能是一个例子。

---

### [00:13:56] Eeke de Milliano

**English:**
On Stripe's culture and what's made it so successful. I've really been thinking a lot about, "Were there one or two pivotal points or decisions for Stripe, that really set it on its path to success?" And I don't think there are, actually. Every time I'm like, "Well, if this hadn't happened..."

**中文翻译:**
关于 Stripe 的文化以及是什么让它如此成功，我一直在思考：“Stripe 是否有一两个关键点或决策，真正奠定了它的成功之路？”其实我觉得并没有。每当我想到“如果这件事没发生……”

---

### [00:14:16] Eeke de Milliano

**English:**
I can always reason my way into, "If these other things would've happened, Stripe would've kind of ended up in the same place."

**中文翻译:**
我总能推导出：“如果发生了其他这些事，Stripe 最终也会达到同样的高度。”

---

### [00:14:24] Eeke de Milliano

**English:**
So I think what Stripe was actually particularly good at... And by the way, you should take all this with a humongous grain of salt, because I haven't worked there since 2019. But, at least my experience when I was there, what Stripe was really good at was just making, not just one or two good decisions. It was making a lot of really good decisions all the time, big or small.

**中文翻译:**
所以我认为 Stripe 真正擅长的是……顺便说一下，这些观点仅供参考，因为我自 2019 年起就不在那里工作了。但至少根据我当时的经验，Stripe 擅长的不仅仅是做出一两个好决策，而是始终如一地做出大量正确的决策，无论大小。

---

### [00:14:44] Eeke de Milliano

**English:**
And that, I think, was quite cultural. There was this humongous respect and enthusiasm for thinking. It was such a part of the culture. One of the values was, think rigorously. Every meeting was very much like, "Hey, how do we think about this thing from first principle?"

**中文翻译:**
我认为这在很大程度上是文化使然。公司内部对“思考”有着巨大的尊重和热情。这是文化的一部分。其中一个价值观就是“严谨思考”（think rigorously）。每次会议都非常强调：“嘿，我们如何从第一性原理出发来思考这件事？”

---

### [00:15:03] Eeke de Milliano

**English:**
No one would ever say, for example, "It's a best practice to do X." People would be like, "Well, why?" You had to go a few levels deeper. So that was, I think, one piece.

**中文翻译:**
例如，没有人会说“做 X 是最佳实践”。人们会问：“为什么？”你必须深入挖掘几个层次。我认为这是其中一点。

---

### [00:15:14] Eeke de Milliano

**English:**
The other piece... And a lot has been written about this already. Stripe had a very strong writing culture. All communication was along from writing business reviews, strategy memos, product reviews. There was a lot of writing that happened.

**中文翻译:**
另一点……关于这一点已经有很多文章写过了。Stripe 有非常深厚的写作文化。所有的沟通都伴随着写作：业务回顾、战略备忘录、产品评论。公司内部有大量的写作。

---

### [00:15:26] Eeke de Milliano

**English:**
I very strongly believe this. I don't think you can be a good writer, unless you're a clear thinker. And if you couldn't write well, I think it was actually pretty hard to be successful at Stripe, at least in the early days. So I think Stripe just cultivated a lot of really good writers, and by input into that, a lot of really good thinkers.

**中文翻译:**
我坚信这一点：除非你思维清晰，否则你无法成为一名优秀的写作者。如果你写不好，我认为在 Stripe 很难获得成功，至少在早期是这样。所以我觉得 Stripe 培养了大量优秀的写作者，进而也培养了大量优秀的思考者。

---

### [00:15:44] Eeke de Milliano

**English:**
And then, I think the last thing that Stripe was really good at, was not overthinking decisions. Because that's kind of the flip side of this really rigorous approach, is that you lock yourself into a room and can't come out for five days. You have to be good at making a lot of decisions, and the right decisions, quickly.

**中文翻译:**
最后，我认为 Stripe 真正擅长的另一件事是不过度纠结决策。因为这种严谨方法的反面就是你把自己锁在房间里五天出不来。你必须擅长快速做出大量正确的决策。

---

### [00:16:01] Eeke de Milliano

**English:**
And one of the things that we would always sort of kick around a lot was just the idea of, "Is it a trapdoor decision?" Which I think is an Amazon concept.

**中文翻译:**
我们经常讨论的一个概念是：“这是一个‘陷阱门’（trapdoor）决策吗？”我想这是亚马逊提出的概念。

---

### [00:16:12] Lenny

**English:**
One-way door, or two-way door.

**中文翻译:**
单向门还是双向门。

---

### [00:16:13] Eeke de Milliano

**English:**
It's like, "If you make this decision, is it one door, or is it two doors? Can you come back from this decision?"

**中文翻译:**
就像是：“如果你做了这个决定，它是单向的还是双向的？你能撤回这个决定吗？”

---

### [00:16:16] Eeke de Milliano

**English:**
And I thought Stripe was actually really good at being rigorous... Back to the rigorous point. About what actually was a trapdoor decision.

**中文翻译:**
我觉得 Stripe 在严谨性上做得非常好……回到严谨这一点，他们能准确判断什么才是真正的“陷阱门”决策。

---

### [00:16:22] Eeke de Milliano

**English:**
So I think a lot of people, for example, think pricing is a trapdoor decision. But actually, it's really easy to grandfather your existing users into some existing pricing model and change pricing for future users. And if you believe that the product's going to be successful, your early users are only going to be a fraction of that pricing model.

**中文翻译:**
例如，很多人认为定价是一个不可逆的决策。但实际上，让现有用户保留旧价格模型（grandfathering），同时为新用户更改定价是非常容易的。如果你相信产品会成功，那么早期用户只占未来定价模型用户的一小部分。

---

### [00:16:41] Eeke de Milliano

**English:**
And if the product's not successful, then Who cares if you change the pricing model? So I think that's a really good example of, people think that's a trapdoor decision, but actually you can move much more quickly on that decision than you think.

**中文翻译:**
如果产品不成功，谁会在乎你改不改定价模型呢？所以这是一个很好的例子：人们以为那是不可逆决策，但实际上你可以比想象中更快地做出决定。

---

### [00:16:52] Eeke de Milliano

**English:**
And then, a decision that definitely felt to us very much like a trapdoor decision, that I think Stripe took a long time being really rigorous about, was titles. I think Stripe's kind of famous for not really having titles.

**中文翻译:**
而另一个对我们来说确实像“陷阱门”的决策——我认为 Stripe 花了很长时间严谨对待的——是职衔（titles）。Stripe 以不怎么设职衔而闻名。

---

### [00:17:03] Eeke de Milliano

**English:**
And I think it was right to be rigorous around that decision, because once you've given someone a title, you can't really take it away. So you better be sure about the title you want to give someone.

**中文翻译:**
我认为在这个决策上保持严谨是正确的，因为一旦你给了某人一个职衔，你就很难收回。所以你最好确定你想给某人什么样的职衔。

---

### [00:17:16] Lenny

**English:**
Yeah, the titles are hilarious. I put together a career ladder doc of all company leveling names across all the big companies.

**中文翻译:**
是的，职衔很有趣。我整理过一份所有大公司的职业阶梯文档，记录了各家的职级名称。

---

### [00:17:26] Eeke de Milliano

**English:**
Is everyone a lead, at Stripe?

**中文翻译:**
在 Stripe 是不是每个人都是“负责人”（Lead）？

---

### [00:17:26] Lenny

**English:**
And it's like, product manager, product manager, product manager, product manager... Yeah. And there's a lead here and there. Yeah, VPs are basically a product manager or a product leader, something like that.

**中文翻译:**
基本上就是产品经理、产品经理、产品经理……是的，偶尔会有个负责人。VP 基本上也就是个产品经理或产品领导者之类的。

---

### [00:17:36] Eeke de Milliano

**English:**
Yep. Yeah.

**中文翻译:**
没错。

---

### [00:17:37] Lenny

**English:**
Hilarious. You talked about this idea of first principles. People talk about that often as, "We want to be first principle thinkers. We're going to think from first principles."

**中文翻译:**
太有意思了。你提到了第一性原理。人们经常说：“我们想成为第一性原理思考者，我们要从第一性原理出发。”

---

### [00:17:47] Lenny

**English:**
How did Stripe actually operationalize that, implement that? Or was that just founder, top-down, continued questioning people, and that trickles down? Or is there anything else that they did to instill that mentality?

**中文翻译:**
Stripe 实际上是如何操作和执行这一点的？是仅仅靠创始人自上而下地不断质问员工，然后这种风气向下渗透？还是他们做了其他什么事情来灌输这种心态？

---

### [00:17:57] Eeke de Milliano

**English:**
I definitely think it's founder, top-down. They were really good about hiring people who thought that way, too. So it's just all that stuff. It just really, really trickles.

**中文翻译:**
我绝对认为这是创始人自上而下的影响。他们也非常擅长雇佣那些同样思考方式的人。所以这些东西就是这样层层渗透的。

---

### [00:18:05] Eeke de Milliano

**English:**
And actually, to this day, when I'm preparing a memo, or a board deck, or something. I imagine in my head, I'm like, "What if I had to present this to Patrick?" And my ideas just get so much better, because I can sort of think about the questions they would ask.

**中文翻译:**
事实上，直到今天，当我准备备忘录或董事会简报时，我脑子里都会想：“如果我要把这个演示给 Patrick（Stripe 创始人）看会怎样？”我的想法会因此变得好得多，因为我可以预想到他们会问的问题。

---

### [00:18:23] Eeke de Milliano

**English:**
So, I think that was one. I think the other one was just sort of this writing culture piece. Once you start writing things down, you realize, "Hey, that actually doesn't make a lot of sense."

**中文翻译:**
所以，我认为那是其一。其二就是写作文化。一旦你开始把东西写下来，你就会意识到：“嘿，这其实逻辑不通。”

---

### [00:18:33] Eeke de Milliano

**English:**
And then, I think the third thing actually was, there was just always a lot of questioning about the status quo. So if something had been done in an industry for a long time, people would always be like, "Well, why was it done that way?"

**中文翻译:**
第三点实际上是，公司内部总是对现状充满质疑。如果某个行业长期以来一直以某种方式运作，人们总会问：“为什么非要那样做？”

---

### [00:18:46] Eeke de Milliano

**English:**
And I think this is actually how Stripe got its start. I think when Stripe started, if you wanted to set up a merchant account, it could take weeks. And everyone just assumed that's what it took. And of course John and Patrick were like, "Well, it doesn't actually make that much sense why it should take that long."

**中文翻译:**
我认为这正是 Stripe 的起家之道。Stripe 创立时，如果你想开设一个商家账户，可能需要几周时间。大家都理所当然地认为就该这么久。而 John 和 Patrick 则认为：“这根本没道理，为什么要花那么长时间。”

---

### [00:19:00] Lenny

**English:**
You shared some of the values... I don't know if they're just called values, core values, at Stripe. But, is there other ones you can share? You said one is think rigorous, or don't overthink. What are the other values at Stripe?

**中文翻译:**
你分享了一些价值观……我不知道在 Stripe 它们是不是就叫价值观或核心价值观。还有其他的吗？你说一个是严谨思考，一个是不要过度思考。Stripe 还有哪些价值观？

---

### [00:19:10] Eeke de Milliano

**English:**
Yeah, think rigorously was one. And I think they might have actually updated these on the website recently, so my recollection is very likely out of date.

**中文翻译:**
是的，“严谨思考”是其中之一。我想他们最近可能在官网上更新了这些内容，所以我的记忆很可能已经过时了。

---

### [00:19:19] Eeke de Milliano

**English:**
And Stripe would call them operating principles, actually. Which, I think is actually better. Because values, you can't really tell people what to value. Everyone has their own value set. But you can tell people like, "Hey, here's how we operate."

**中文翻译:**
Stripe 实际上称之为“运营原则”（operating principles）。我觉得这个说法更好。因为对于“价值观”，你很难告诉别人该看重什么，每个人都有自己的价值观。但你可以告诉大家：“嘿，这是我们的运作方式。”

---

### [00:19:32] Eeke de Milliano

**English:**
Another one that I loved was, move with urgency and focus. It was just really this idea that you're biggest compatriot and your biggest enemy as a startup, is time. So you have to move really, really, really fast on it.

**中文翻译:**
另一个我非常喜欢的是“带着紧迫感和专注力行动”。这其实就是一种理念：作为一家初创公司，你最大的盟友和最大的敌人都是时间。所以你必须行动得非常、非常、非常快。

---

### [00:19:48] Eeke de Milliano

**English:**
Customers first, was the other one. Or, users first, as Stripe would refer to customers as users. So those are some of my favorites.

**中文翻译:**
“客户至上”是另一个。或者叫“用户至上”，因为 Stripe 习惯把客户称为用户。这些是我最喜欢的几个。

---

### [00:19:56] Lenny

**English:**
When I think back to what made Airbnb special in a similar way, the values... We call them core values. I think were actually really, really important, and turned the company into what it ended up being. And I was actually there around the time they created these values.

**中文翻译:**
回想起来，Airbnb 也有类似的特质，那些价值观……我们称之为核心价值观。我认为它们确实非常重要，塑造了公司最终的模样。当时制定这些价值观时，我正好在场。

---

### [00:20:08] Eeke de Milliano

**English:**
Oh, awesome.

**中文翻译:**
噢，太棒了。

---

### [00:20:09] Lenny

**English:**
I'm curious, at Stripe, do you have any recollection of how they came to these operating principles? Because, as I mentioned, founders are listening. "How do I come up with these for our company?"

**中文翻译:**
我很想知道，在 Stripe，你还记得他们是如何制定出这些运营原则的吗？因为正如我提到的，有很多创始人在听这个播客，他们想知道：“我该如何为我的公司制定这些原则？”

---

### [00:20:19] Eeke de Milliano

**English:**
I'm pretty sure Patrick wrote them. Yeah. I think they came from... Patrick and John wrote them.

**中文翻译:**
我很确定是 Patrick 写的。是的，我想是 Patrick 和 John 写的。

---

### [00:20:26] Eeke de Milliano

**English:**
Actually, the other value that I love... I don't think they have it anymore, but it was good, the operating principles. Micro pessimists, macro optimists.

**中文翻译:**
实际上，另一个我喜欢的价值观……我不确定他们现在是否还保留着，但它作为运营原则非常好：微观上的悲观主义者，宏观上的乐观主义者。

---

### [00:20:33] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:20:34] Eeke de Milliano

**English:**
Yeah. It was just this idea that, "In the long term, we expect the curve to go up. We very much believe in the upward trajectory of just about everything. But on the day-to-day decisions, on the minutiae, we're quite critical. How do we make sure this thing works?" And we'd think about all the ways in which it doesn't work.

**中文翻译:**
是的。它的核心理念是：“从长远来看，我们预期曲线会向上增长。我们坚信几乎所有事物都处于上升轨道。但在日常决策和细节上，我们非常挑剔。我们如何确保这件事能成？”我们会思考所有可能失败的情况。

---

### [00:20:53] Lenny

**English:**
So zooming out a little bit. We've been talking about Stripe. Retool also is a very first principles, innovative company.

**中文翻译:**
稍微把视野放大一点。我们一直在聊 Stripe。Retool 也是一家非常强调第一性原理、极具创新性的公司。

---

### [00:20:59] Lenny

**English:**
Something that I think of when I think of Retool is, during the wild market days of long ago, last year. I know Retool was very conservative in how they raised money, and the valuations they raised at. Which, looking back, ended up being a really good idea. While everyone's raising at $100 billion, I think their last round is a few billion. And it's a very reasonable, conservative way to think about fundraising.

**中文翻译:**
想到 Retool，我就会想到去年市场疯狂的那段日子。我知道 Retool 在融资方式和估值上非常保守。回过头来看，这真的是个好主意。当大家都在以 1000 亿美元的估值融资时，我想他们的最后一轮融资只有几十亿美元。这是一种非常理性、保守的融资思路。

---

### [00:21:23] Lenny

**English:**
And so, I guess just thinking about innovation in general. Why do you think some teams are able to run innovation machines, continue to put out new products, disrupt industries, while other companies kind of plod along and stay conservative?

**中文翻译:**
所以，我想聊聊普遍意义上的创新。为什么你认为有些团队能够像创新机器一样运转，不断推出新产品、颠覆行业，而其他公司却只是步履蹒跚、固步自封？

---

### [00:21:37] Lenny

**English:**
Is there anything you've seen, something you bring to teams you work on, to help foster innovation and big thinking?

**中文翻译:**
你有没有见过什么，或者你带给团队什么东西，来帮助培养创新和宏大思考？

---

### [00:21:43] Eeke de Milliano

**English:**
Yeah, I actually think about the extremes of that question. So not, "Why are some teams innovative?" But, "Why isn't every team innovative?" I feel like no one wakes up in the morning and thinks, "Yeah, today I want to work on boring, incremental stuff."

**中文翻译:**
是的，我其实会从这个问题的反面去思考。不是问“为什么有些团队有创新力”，而是问“为什么不是每个团队都有创新力？”我觉得没有人会在早上醒来时想：“太好了，今天我想做点无聊的、微小的修补工作。”

---

### [00:21:57] Eeke de Milliano

**English:**
But, most teams do end up working on pretty incremental stuff. I always wonder, "What is it that's stopping folks from being creative and thinking bigger?" And I think it comes down to a couple of things that companies do sort of unwillingly, or not even realizing it.

**中文翻译:**
但大多数团队最终确实都在做非常琐碎的增量工作。我一直在想：“是什么阻碍了人们发挥创意和进行更宏大的思考？”我认为这归结为公司在无意中或未察觉的情况下做的几件事。

---

### [00:22:14] Eeke de Milliano

**English:**
And one is this fear of failure. I think leaders want the upside of innovation, but they're not really willing to deal with the cost of innovation. Which is like, "Look, if you're going to swing big, you will invariably stumble sometimes."

**中文翻译:**
第一点是畏惧失败。我认为领导者想要创新的收益，但他们并不真正愿意承担创新的成本。这个成本就是：“听着，如果你想大干一场，你不可避免地会偶尔跌倒。”

---

### [00:22:29] Eeke de Milliano

**English:**
So I think if you want to mitigate that, you have to start shining light on failure. That's really the only way. You have to start normalizing it a little bit. And obviously, if an individual, or if a team is consistently failing and not learning. That, you need to deal with.

**中文翻译:**
所以如果你想缓解这种恐惧，你必须开始正视失败。这是唯一的办法。你必须让失败变得常态化一点。当然，如果个人或团队持续失败且不吸取教训，那是你需要处理的问题。

---

### [00:22:46] Eeke de Milliano

**English:**
But I think sometimes it's good to fail. And when you do fail, use it as an opportunity. Don't squander that moment to not learn.

**中文翻译:**
但我认为有时候失败是好事。当你失败时，把它当作一个机会。不要浪费那个学习的时刻。

---

### [00:22:57] Eeke de Milliano

**English:**
But yeah, one example is, instead of calling something a postmortem, call it a retrospective, so that it's a positive thing. Like, "Hey, we're learning from this thing."

**中文翻译:**
是的，举个例子，不要把某件事称为“事后剖析”（postmortem），而要称之为“回顾”（retrospective），这样它就变成了一件积极的事情。就像是：“嘿，我们从这件事中学到了东西。”

---

### [00:23:07] Eeke de Milliano

**English:**
And then, I think the other way to kind of mitigate the feeling of failure is, you have to figure out how to give folks more at BATS. Because obviously, anything that takes one year to ship, and you haven't gotten any customer feedback, the stakes of that are just going to feel so, so high. If you get it wrong, it's going to be devastating. So you have to figure out how to lower the stakes.

**中文翻译:**
我认为另一种缓解失败感的方法是，你必须想办法给员工更多的“击球机会”（at BATS）。因为显然，任何需要一年时间才能发布且期间没有任何客户反馈的项目，其风险都会让人感觉非常非常高。如果你搞砸了，那将是毁灭性的。所以你必须想办法降低风险。

---

### [00:23:27] Eeke de Milliano

**English:**
And honestly, I think in some ways it's kind of easy. It's like, "Look, don't put too many resources against these bigger swings. Have them be small teams." And then also, just get customer feedback as quickly as possible. Don't wait until the thing is perfect. And that way, you can limit the risk.

**中文翻译:**
老实说，我觉得这在某种程度上挺简单的。比如：“听着，不要在这些大胆的尝试上投入过多资源，让它们保持小团队运作。”同时，尽可能快地获取客户反馈。不要等到东西完美了才拿出来。这样你就能限制风险。

---

### [00:23:44] Eeke de Milliano

**English:**
So yeah, I think fear of failure, that's definitely one thing that stops teams from being innovative.

**中文翻译:**
所以，畏惧失败绝对是阻碍团队创新的一个因素。

---

### [00:23:49] Eeke de Milliano

**English:**
There's a very practical one. Sometimes teams are just getting bogged down by really urgent work. There's too much tech debt. There's too much product debt. Bugs, instability. It's a massive hierarchy of needs. There's just no way that they're going to be able to focus on the enlightened, bigger, creative stuff if they're just heads-down dealing with incidents all day. So if that's the case, yeah, diagnose it and get your team out of that.

**中文翻译:**
还有一个非常现实的原因。有时团队只是被紧急工作拖垮了。有太多的技术债、产品债、Bug 和不稳定性。这是一个巨大的需求层次结构。如果他们整天都在埋头处理突发事件，根本不可能专注于那些更有远见、更宏大、更有创意的事情。如果是这种情况，那就去诊断问题，把你的团队从泥潭中拉出来。

---

### [00:24:18] Eeke de Milliano

**English:**
And then, I think the last reason why teams aren't always that innovative is because, I think thinking big is really hard. And to some people it comes pretty naturally. But for most of us mortal souls, it's just really, really hard. And it takes time. And when you're at a startup and you're just grinding day-in, day-out, you're treading water just trying to make it through the day.

**中文翻译:**
我认为团队不总是那么有创新精神的最后一个原因是：宏大思考真的很累。对某些人来说这很自然，但对我们大多数凡夫俗子来说，这真的非常非常难。而且这需要时间。当你在一家初创公司日复一日地拼命工作时，你只是在勉强维持现状，试图熬过这一天。

---

### [00:24:45] Eeke de Milliano

**English:**
Taking the time to really think about the strategy, and where things should go, and get creative. It's pretty hard. So I call this... You have to give teams permission to think. So create these moments in your company culture, in your overall business processes, where you're asking people, you're literally saying, "Hey, this is part of your job to think bigger."

**中文翻译:**
花时间去真正思考战略、发展方向并发挥创意，这很难。所以我把这称为……你必须给团队“思考的许可”。在你的公司文化和整体业务流程中创造这些时刻，明确告诉大家：“嘿，进行更宏大的思考也是你工作的一部分。”

---

### [00:25:09] Eeke de Milliano

**English:**
So at Retool, we have these team charters and we do team planning. And at the bottom of every team charter we have a section called, Think Bigger. "With 20% more time, what would you do that isn't on this list already?"

**中文翻译:**
在 Retool，我们有团队章程（team charters）并进行团队规划。在每份团队章程的底部，我们都有一个名为“Think Bigger”的板块。内容是：“如果多给你 20% 的时间，你会做哪些目前不在清单上的事情？”

---

### [00:25:21] Eeke de Milliano

**English:**
And then another really neat tradition that we had at Stripe, and we have a Retool now, too. Is this thing called, Crazy Ideas. So at the beginning of every year, David will send out a blank doc to the org and it's titled Crazy Ideas.

**中文翻译:**
我们在 Stripe 还有一个非常棒的传统，现在 Retool 也有，那就是“疯狂想法”（Crazy Ideas）。每年年初，David 都会向全公司发送一份标题为“Crazy Ideas”的空白文档。

---

### [00:25:39] Eeke de Milliano

**English:**
The Prompt is, "Crazy ideas are ideas that we shouldn't, obviously, do. There's a 90% chance that they make no sense. But in the 10% chance that they do, they will make a 10x to 100x difference for the retail business." And then, it's literally just a request for crazy ideas.

**中文翻译:**
提示语是：“疯狂想法是指那些我们显然不该做的想法。它们有 90% 的概率是毫无意义的。但如果有 10% 的机会它们是有意义的，它们将为 Retool 的业务带来 10 倍甚至 100 倍的改变。”然后，这纯粹就是征集各种疯狂的想法。

---

### [00:25:57] Eeke de Milliano

**English:**
And the org loves it. It's amazing. The energy around it is so cool. And it's not just product ideas, it's different ways of how we should run our organization. Or, it's really cool marketing ideas in there.

**中文翻译:**
全公司都非常喜欢这个活动。太棒了，那种氛围非常酷。而且不只是产品创意，还有关于如何运作组织的不同方式，或者非常酷的营销点子。

---

### [00:26:12] Eeke de Milliano

**English:**
So, that doc is awesome. And whenever I have a down day, I just scroll through that doc.

**中文翻译:**
所以，那份文档非常棒。每当我心情低落时，我就会翻翻那份文档。

---

### [00:26:17] Lenny

**English:**
I know that you've launched three different products this year which I want to talk about, which maybe came out of this big thinking. But a couple more questions just to dig into some of the stuff you just shared.

**中文翻译:**
我知道你们今年发布了三个不同的产品，我想聊聊这些，它们可能就源于这种宏大思考。但在那之前，我想再问几个问题，深入探讨一下你刚才分享的内容。

---

### [00:26:26] Lenny

**English:**
One is this big doc of awesome ideas. What's come out of that? Because I think of hackathons, and people have all this energy, and it's exciting. And then they do all these cool things and they don't go anywhere.

**中文翻译:**
一个是那份装满绝妙点子的大文档。它最终产出了什么？因为我想到了黑客松（hackathons），大家充满活力，非常兴奋，做出了很多酷炫的东西，但最后往往不了了之。

---

### [00:26:35] Lenny

**English:**
Do things come out of this? Does it lead to actual ideas that people follow up on?

**中文翻译:**
这文档真的有产出吗？它是否促成了人们后续跟进的实际想法？

---

### [00:26:38] Eeke de Milliano

**English:**
Yeah. Yeah, yeah. So every year that we send out the doc, we look at the doc from the past year, and we're like, "Okay, did we do anything on this list?" And consistently, we do anywhere between three to eight things on the list.

**中文翻译:**
有的，有的。每年我们发出新文档时，都会回顾去年的文档，看看：“好吧，清单上的事我们做了吗？”结果是，我们每年都能稳定地完成清单上的三到八件事。

---

### [00:26:49] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:26:50] Eeke de Milliano

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:26:51] Lenny

**English:**
Is there an example of a product that launched, that came from that list, that comes to mind?

**中文翻译:**
你能想到哪个已经发布的产品是来自那个清单的吗？

---

### [00:26:54] Eeke de Milliano

**English:**
Actually, at least one, if not two of the three products that we launched this last year were on the crazy ideas list at one point. Like, a year ago, if you'd asked me, "What is Retool's product?" I would've told you, "Retool helps you build internal frontends really, really fast."

**中文翻译:**
事实上，去年我们发布的三个产品中，至少有一个（如果不是两个的话）曾出现在疯狂想法清单上。比如一年前，如果你问我“Retool 的产品是什么？”，我会告诉你：“Retool 帮助你非常快速地构建内部前端。”

---

### [00:27:09] Eeke de Milliano

**English:**
But if you were trying to schedule a query to run at a later point in time, or have something trigger, or run an ETL task, you couldn't do that in Retool. So that was actually one of the crazy ideas. And that ended up becoming Retool Workflows, which we launched just last year, in November.

**中文翻译:**
但如果你想安排一个查询在稍后运行，或者设置某种触发器，或者运行一个 ETL 任务，你在 Retool 里是做不到的。所以这其实就是当时的疯狂想法之一。它最终变成了 Retool Workflows，我们在去年 11 月刚刚发布。

---

### [00:27:28] Lenny

**English:**
Okay. We're definitely going to chat a bit about that. I want to go back to the two other suggestions you had. One is embrace failure, make it okay to fail. And then two is, don't let people get sucked into urgent stuff, and have time to focus on important stuff.

**中文翻译:**
好的，我们待会儿一定要聊聊那个。我想回到你刚才提的另外两个建议。一个是拥抱失败，让失败变得可以接受；另一个是不要让员工陷入紧急事务，要留出时间专注于重要事务。

---

### [00:27:42] Lenny

**English:**
Is there an example of just how to help people embrace failure? You talked about retrospectives. Is there anything else that you've found works, either as a tactic, as a process, as a framework, just to help people get out of that?

**中文翻译:**
有没有具体的例子来说明如何帮助人们拥抱失败？你提到了回顾会议。还有没有其他你觉得有效的策略、流程或框架，能帮助人们摆脱那种对失败的恐惧？

---

### [00:27:55] Lenny

**English:**
Because I hear that a lot, "Embrace failure." And then people are like, "Oh, but I failed and I suck." So yeah, is there anything else along those lines that you found effective to create that feeling?

**中文翻译:**
因为我经常听到“拥抱失败”这种话，但人们心里想的是：“噢，但我失败了，我太烂了。”所以，还有什么其他方法能有效营造出那种（真正接受失败的）氛围吗？

---

### [00:28:04] Eeke de Milliano

**English:**
To me, it's always in the follow-ups. So have people talk about the failure in these sort of public forums, where usually you talk about the successes. So have someone actually write a note that's like, "Hey, here are all my learnings from this thing that we did." And send it to the org.

**中文翻译:**
对我来说，关键在于后续跟进。让人们在通常讨论成功的公共场合谈论失败。比如让某人写一份笔记，说：“嘿，这是我们做这件事的所有教训”，然后发给全公司。

---

### [00:28:18] Eeke de Milliano

**English:**
At Retool we have a shipped email list. If you ship something, you'll always send to that.

**中文翻译:**
在 Retool，我们有一个“已发布”（shipped）邮件列表。如果你发布了什么东西，你总会发到那里。

---

### [00:28:24] Eeke de Milliano

**English:**
Have them send that email to the org. It's just an awesome way to celebrate. Or have them present it all-hands and share what they learned. And it almost always results in, I think, a really positive twist.

**翻译:**
让他们把那封（关于失败教训的）邮件发给全公司。这其实是一种很棒的庆祝方式。或者让他们在全员大会上演示并分享学到的东西。我认为这几乎总能带来非常积极的转变。

---

### [00:28:38] Lenny

**English:**
At Airbnb, I think for a period, there was an award for the biggest failure project and feature.

**中文翻译:**
在 Airbnb，我想有一段时间，还专门设立了一个“最大失败项目和功能奖”。

---

### [00:28:42] Eeke de Milliano

**English:**
Really? That's so cool.

**中文翻译:**
真的吗？那太酷了。

---

### [00:28:43] Lenny

**English:**
Yeah, like a trophy or something. It was a short-lived idea, but it was funny.

**中文翻译:**
是的，还有个奖杯之类的。这个想法没持续多久，但挺有意思的。

---

### [00:28:47] Eeke de Milliano

**English:**
Yeah, yeah, yeah.

**中文翻译:**
是啊，是啊。

---

### [00:28:48] Lenny

**English:**
And then, on the second bullet point of urgency, giving people a chance to think longer term. Is there anything there, that you found to be actually effective, to create that culture, and give PMs and product teams a chance to think longer term, and not just be stuck in the fires that they're dealing with?

**中文翻译:**
关于第二点“紧迫感”，即给人们机会进行长期思考。有没有什么你觉得真正有效的方法，可以创造这种文化，让 PM 和产品团队有机会进行长期思考，而不是整天陷在救火的工作中？

---

### [00:29:02] Eeke de Milliano

**English:**
There's a couple of top-down things, and a couple of bottom-up things.

**中文翻译:**
有一些自上而下的方法，也有一些自下而上的方法。

---

### [00:29:06] Eeke de Milliano

**English:**
On the top-down, sometimes you just have to be willing to fund someone with something. Like, they come to you with an idea and you're like, "Look, yeah, take an engineer and go do it." And you just have to give folks that sort of organizational buy-in.

**中文翻译:**
在自上而下方面，有时你必须愿意为某人的想法提供资源。比如，他们带着一个点子来找你，你说：“听着，行，带上一名工程师去试试吧。”你必须给予这种组织层面的支持。

---

### [00:29:21] Eeke de Milliano

**English:**
Actually, I was thinking back to that engineer, Brian Krausz at Stripe, who started poking around on this marketplace model. And I was thinking, I can't remember a moment when someone formally said to him, "This is now your job." I think he just went and looked, and went and dug into it. And at some point, I think a manager was like, "All right, this is now your job."

**中文翻译:**
实际上，我想到了 Stripe 的那位工程师 Brian Krausz，他开始钻研市场模型。我在想，我不记得有哪个时刻有人正式对他说：“这现在是你的工作了。”我想他只是自己去观察、去挖掘，然后在某个时刻，经理说：“好吧，这现在就是你的工作了。”

---

### [00:29:43] Eeke de Milliano

**English:**
But yeah, no, I think you have to be able to fund folks' time and give that. Hackathons, I think, are pretty good for that stuff. It is kind of a moment for folks to take a step back.

**中文翻译:**
但没错，我认为你必须能够为员工的时间买单并给予支持。黑客松在这方面就很不错，它给了大家一个退后一步思考的机会。

---

### [00:29:55] Eeke de Milliano

**English:**
And then, I think more than anything, in people's planning processes, I really like asking folks the 20% more time question. Or the other question was, "Look, if you doubled the team today, what would you do?" That shows up in our planning processes as well.

**中文翻译:**
然后，我觉得最重要的是，在规划流程中，我非常喜欢问大家那个“多出 20% 时间”的问题。或者另一个问题：“看，如果今天团队规模翻倍，你会做什么？”这也会出现在我们的规划流程中。

---

### [00:30:08] Eeke de Milliano

**English:**
And I think it really helps people kind of break out of this... I think you end up planning towards the team that you have and not the team that you should have. So, that's how folks can break out of that process.

**中文翻译:**
我认为这真的能帮助人们跳出……我觉得人们往往会根据现有的团队来做规划，而不是根据应该拥有的团队来规划。这就是人们跳出原有流程的方式。

---

### [00:30:20] Lenny

**English:**
Awesome. I really like the think bigger bucket in your planning docs. Just like, "What would you do if you had more resources?" Maybe a quick question there. Is there a bunch of detail that you ask them to put into that, or is it just a bullet point of big ideas?

**中文翻译:**
太棒了。我很喜欢你们规划文档里的“Think Bigger”板块。就像是“如果你有更多资源你会做什么？”顺便问一下，你会要求他们在那里写很多细节吗，还是只是一些大想法的要点？

---

### [00:30:32] Eeke de Milliano

**English:**
Folks can just go crazy on it. It's however they want to take it. I've seen folks actually create entire demos.

**中文翻译:**
大家可以尽情发挥。随他们怎么写。我见过有人甚至为此制作了完整的演示 Demo。

---

### [00:30:40] Eeke de Milliano

**English:**
But I actually think the trick is less structure, in those cases. Because you don't really want to sort of pigeonhole... Or make it even that intimidating for folks. If someone just wants to write down a few bullets, that's great.

**中文翻译:**
但我其实认为，在这种情况下，诀窍在于减少结构。因为你不想限制他们的思维……或者让这件事变得太吓人。如果有人只想写几个要点，那也很好。

---

### [00:30:53] Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next-generation A/B testing platform, built by Airbnb alums for modern growth teams. Companies like Netlify, Contentful and Cameo rely on Eppo to power their experiments.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 A/B 测试平台。Netlify、Contentful 和 Cameo 等公司都依赖 Eppo 来支持他们的实验。

---

### [00:31:07] Lenny

**English:**
Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern growth team stack. This leads to a waste of time building internal tools, or trying to run your experiments through a clunky marketing tool.

**中文翻译:**
无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能与现代增长团队的技术栈完美集成。这导致人们要么浪费时间构建内部工具，要么试图通过笨重的营销工具来运行实验。

---

### [00:31:21] Lenny

**English:**
When I was at Airbnb, one of the things that I loved about our experimentation platform, was being able to easily slice results by device, by country, and by user stage. Eppo does all that and more. Delivering results quickly, avoiding annoying prolonged analytics cycles, and helping you easily get to the root cause of any issue you discover.

**中文翻译:**
当我在 Airbnb 时，我最喜欢我们的实验平台的一点是，能够轻松地按设备、国家和用户阶段来切分结果。Eppo 实现了这一切甚至更多。它能快速交付结果，避免烦人的漫长分析周期，并帮助你轻松找到发现的任何问题的根本原因。

---

### [00:31:41] Lenny

**English:**
Eppo lets you go beyond basic click-through metrics and instead, use their North Star metrics like activation, retention, subscriptions and payments. And Eppo supports tests on the frontend, the backend, email marketing, and even machine learning clients.

**中文翻译:**
Eppo 让你超越基础的点击率指标，转而使用北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。

---

### [00:31:55] Lenny

**English:**
Check out Eppo at GetEppo.com. Get E-P-P-O.com and 10x your experiment velocity.

**中文翻译:**
访问 GetEppo.com 了解 Eppo。访问 E-P-P-O.com，让你的实验速度提升 10 倍。

---

### [00:32:03] Lenny

**English:**
Okay, so you launched three new products this year. Usually, companies are lucky to launch one product a year. A few questions.

**中文翻译:**
好，你们今年发布了三个新产品。通常情况下，公司一年能发布一个产品就很幸运了。我有几个问题。

---

### [00:32:11] Lenny

**English:**
One, just tell us what those three were, in case people are interested and want to check them out. Two is, was that a good idea? Is it good to launch three new products in a year?

**中文翻译:**
第一，告诉我们这三个产品是什么，以防听众感兴趣想去看看。第二，这是一个好主意吗？一年发布三个新产品真的好吗？

---

### [00:32:19] Lenny

**English:**
And then three, what did you do organizationally, to allow for this to happen? Because that feels really ambitious and rare, and I'm curious what you learned from that.

**中文翻译:**
第三，你在组织层面做了什么来促成这件事？因为这听起来非常有野心且罕见，我很想知道你从中学习到了什么。

---

### [00:32:28] Eeke de Milliano

**English:**
So the three products we launched, one was Retool Workflows that I talked to you a little bit about. It's like, if you want to be able to, essentially create a workflow. Like schedule an alert, run a task, you can kind of do it in the Retool way. Where it's this visual, sort of easier builder of creating these different sort of workflows. But you can write your own code on top of it, as well.

**中文翻译:**
我们发布的三个产品中，一个是 Retool Workflows，我刚才提到过。它让你能够创建工作流，比如安排警报、运行任务，你可以用 Retool 的方式来做，即通过这种视觉化的、更简单的构建器来创建各种工作流，但你也可以在上面编写自己的代码。

---

### [00:32:50] Eeke de Milliano

**English:**
The second product is Retool Mobile. So you could pretty easily build incredible web apps with Retool. But there are plenty of folks who don't sit behind their laptop at a desk all day. And for those folks... We had a lot of companies who were like, "I want a mobile native app." And so, we launched that product.

**中文翻译:**
第二个产品是 Retool Mobile。你可以用 Retool 轻松构建出色的 Web 应用，但有很多人并不是整天坐在笔记本电脑前工作的。对于这些人……很多公司跟我们说：“我想要一个移动原生应用。”于是，我们推出了这个产品。

---

### [00:33:09] Eeke de Milliano

**English:**
And then the third product was Retool Database. So until very recently, if you came to Retool, you could connect your data via your APIs, your database, directly into Retool.

**中文翻译:**
第三个产品是 Retool Database。直到最近，如果你使用 Retool，你可以通过 API 或数据库直接将数据连接到 Retool。

---

### [00:33:20] Eeke de Milliano

**English:**
But what we found is that actually, a lot of folks either don't have access to their database, or they're just trying to build an internal tool and they don't necessarily want to store that data in their production database.

**中文翻译:**
但我们发现，实际上很多人要么没有数据库访问权限，要么只是想构建一个内部工具，并不一定想把这些数据存储在生产数据库中。

---

### [00:33:29] Eeke de Milliano

**English:**
So we built... Essentially, we spin up a post [inaudible 00:33:32] database for you. And you can just access it via a really nice UI and manage it directly in Retool.

**中文翻译:**
所以我们构建了……本质上，我们为你启动一个 PostgreSQL 数据库。你可以通过非常漂亮的 UI 访问它，并直接在 Retool 中进行管理。

---

### [00:33:38] Lenny

**English:**
Amazing. Okay, back to the other two questions.

**中文翻译:**
太棒了。好，回到另外两个问题。

---

### [00:33:42] Eeke de Milliano

**English:**
Yes. Okay. So I think your second question was, "Was this a good idea?"

**中文翻译:**
好的。我想你的第二个问题是：“这是一个好主意吗？”

---

### [00:33:44] Lenny

**English:**
Right.

**中文翻译:**
对。

---

### [00:33:46] Eeke de Milliano

**English:**
Yeah. You know what? I think in hindsight, if I were to do it again, I think sequencing it would've been slightly better. Just because, I think what we ended up doing is, we ended up launching the idea behind all three of these products at around the same time. And they all ended up maturing at around the same time, and that was just a lot of headspace from the org. Even though actually, the teams themselves were not that big.

**中文翻译:**
是的。你知道吗？事后看来，如果让我重来一次，我认为按顺序发布（sequencing）会稍微好一点。因为我们最终是在同一时间启动了这三个产品的构思，它们也几乎在同一时间成熟，这占据了组织大量的精力。尽管实际上，团队本身并不大。

---

### [00:34:18] Eeke de Milliano

**English:**
It was just like, we had all these products and we were just waiting for them to launch and waiting for them to launch. Whereas, maybe if we'd sequenced it, I think that would've felt more satisfying to the whole organization.

**中文翻译:**
感觉就像我们手里攥着所有这些产品，一直在等啊等，等着发布。而如果我们按顺序来，我想整个组织的感觉会更充实、更满意。

---

### [00:34:28] Eeke de Milliano

**English:**
But, I mean, it ended up working out. I think that's kind of the crazy thing. It's like, we were able to pull off launching these three products.

**中文翻译:**
但我的意思是，结果还不错。我觉得这挺疯狂的：我们居然真的成功发布了这三个产品。

---

### [00:34:36] Eeke de Milliano

**English:**
And by the way, I should caveat that, the further I get along my career, the more I realize I'm just kind of building on the shoulders of giants. And a lot of these ideas, et cetera, were very much in the works and were happening before I came along.

**中文翻译:**
顺便说一下，我得说明一点：随着职业生涯的发展，我越发意识到我只是站在巨人的肩膀上。很多这些想法和项目在我加入之前就已经在筹备和进行中了。

---

### [00:34:50] Eeke de Milliano

**English:**
But yeah, it was really neat to see how we got that all over the finish line in a year.

**中文翻译:**
但能在一年内看到我们把这些全部推过终点线，真的很了不起。

---

### [00:34:55] Lenny

**English:**
And then, the last question there is just, what do you think you did to allow for this? Because it's pretty rare you can build so much. And I know the team's not huge. How many people work at Retool, roughly?

**中文翻译:**
最后一个问题是，你认为你做了什么才促成了这一切？因为能构建这么多东西是非常罕见的。我知道团队规模并不大。Retool 大约有多少员工？

---

### [00:35:05] Eeke de Milliano

**English:**
Today, we're around 300 people.

**中文翻译:**
目前大约有 300 人。

---

### [00:35:07] Lenny

**English:**
Yeah. So how do you structure an org to build three and launch... I didn't realize they launched around the same time. It's like, I'm picturing Elon Musk launching three rockets at once. How do you allow for that to happen?

**中文翻译:**
是的。那么你如何构建一个组织来同时开发并发布三个……我之前没意识到它们是几乎同时发布的。这让我想象到埃隆·马斯克同时发射三枚火箭。你是如何让这种事发生的？

---

### [00:35:20] Eeke de Milliano

**English:**
Yeah, I'm sure our product marketing team felt that way. Yeah, a couple of things. We started really small with all of these initiatives.

**中文翻译:**
是的，我确信我们的产品营销团队也有同感。有几点原因。首先，我们所有的这些计划最初规模都非常小。

---

### [00:35:30] Eeke de Milliano

**English:**
So I think I mentioned, we really had one or two people working on each of these products for the first six months. So it was one engineer and one designer, or one engineer and one PM. And they really didn't get funding until it was clear that there was something there.

**中文翻译:**
正如我提到的，在最初的六个月里，每个产品实际上只有一两个人负责。可能是一名工程师加一名设计师，或者一名工程师加一名 PM。在确定这个方向有戏之前，他们并没有获得真正的资源投入。

---

### [00:35:46] Eeke de Milliano

**English:**
So those teams, they spent a ton of time with customers. They spent a ton of time building, a ton of time prototyping. And it was kind of the moment where it was like, "Okay, they are there." That we started bringing more people onto the team.

**中文翻译:**
所以这些团队花了大量时间与客户沟通，花了大量时间构建和制作原型。直到那个时刻——即“好吧，东西成型了”——我们才开始向团队增加人手。

---

### [00:35:59] Eeke de Milliano

**English:**
So, that was the first piece. The second piece is that, we really treated them like startups. We're like, Retool's the VC, and Retool funds with resources and Retool's existing customer base. Which is obviously quite valuable, because you have all these customers you can market to and promote to.

**中文翻译:**
这是第一点。第二点是，我们真的把它们当作初创公司来对待。Retool 就像是风投（VC），Retool 提供资源和现有的客户群。这显然非常有价值，因为你已经有了可以进行营销和推广的客户。

---

### [00:36:15] Eeke de Milliano

**English:**
But then, the teams really had to prove that ROI. Either in engagement, or eventually revenue, in order to be able to move forward.

**中文翻译:**
但随后，这些团队必须真正证明其投资回报率（ROI），无论是通过用户参与度还是最终的收入，才能继续推进。

---

### [00:36:25] Eeke de Milliano

**English:**
And then the third thing... And this one, actually I think it can be quite controversial. Is, we were really deliberate about keeping these teams separate from the rest of the org, especially early on. Now, a lot of them, they're very much a part of the overall organizational processes.

**中文翻译:**
第三点……这一点其实可能很有争议。那就是，我们非常刻意地让这些团队与组织的其他部分保持独立，尤其是在早期。现在，他们中的大多数已经完全融入了整体的组织流程。

---

### [00:36:42] Eeke de Milliano

**English:**
But very early on, they were running on their own. They were meeting quite independently with one, or two, or three folks from the leadership team. And they were also just quite separate from the product itself.

**中文翻译:**
但在非常早期的时候，他们是独立运行的。他们会独立地与领导团队的一两名成员开会。而且他们在产品层面也与核心产品相当独立。

---

### [00:36:56] Eeke de Milliano

**English:**
I think Retool Mobile's actually a really good example, where we had a lot of debate about whether or not we should build Retool Mobile out of the core web app builder. Because a lot of the primitives are the same.

**中文翻译:**
我认为 Retool Mobile 就是一个很好的例子。当时我们对于是否应该在核心 Web 应用构建器的基础上开发 Retool Mobile 进行了大量辩论，因为很多基础组件（primitives）是相同的。

---

### [00:37:09] Eeke de Milliano

**English:**
And we eventually decided that we were going to run it as a separate team, because we wanted the team to be able to move really, really quickly. And we didn't want it to get bogged down in, what are just the realities of running a product that has product market fit, like bugs, yada, yada, et cetera.

**中文翻译:**
最终我们决定将其作为一个独立的团队来运行，因为我们希望这个团队能够行动得非常、非常快。我们不希望它被那些已经达到产品市场匹配（PMF）的产品所面临的现实问题所拖累，比如 Bug 处理等等。

---

### [00:37:24] Eeke de Milliano

**English:**
And I think that was absolutely the right call, because Retool Mobile actually has quite a different target customer. Which, we only really realized maybe like halfway through the project. And I don't think we would've been able to really understand that, or even get broader in that kind of thinking, had we sort of been stuck in the core retail product.

**中文翻译:**
我认为这绝对是正确的决定，因为 Retool Mobile 实际上有着相当不同的目标客户。这一点我们直到项目进行到一半时才真正意识到。如果我们一直困在核心产品里，我想我们无法真正理解这一点，甚至无法展开那种更广阔的思考。

---

### [00:37:43] Eeke de Milliano

**English:**
But yeah, there was a cost to that, too. Which is like, "Okay, now we have these two products, and we have to..." I think obviously the strength will be, "How do all these products interact with each other, and how do they build on top of each other?"

**中文翻译:**
当然，这也有代价。那就是：“好吧，现在我们有了这两个产品，我们必须……”显然，未来的优势将在于“这些产品如何相互交互，以及它们如何相互构建？”

---

### [00:37:52] Eeke de Milliano

**English:**
So, we have to go and invest in that now. But I think it's totally worth it, because your team can just move more quickly, be more independent, and think more independently, too.

**中文翻译:**
所以我们现在必须在这方面进行投入。但我认为这完全值得，因为你的团队可以行动得更快、更独立，思考也更独立。

---

### [00:38:00] Lenny

**English:**
In the time that you worked at Stripe and Retool... I know we chatted before we started recording. You think a lot about, "What is the right level of process for companies at different stages?"

**中文翻译:**
在你于 Stripe 和 Retool 工作期间……我知道我们在录音前聊过。你经常思考：“不同阶段的公司适合什么程度的流程？”

---

### [00:38:12] Lenny

**English:**
And I'd love to just hear your thoughts, because I know that's a challenge a lot of companies face. "How much do we put in now? Do we get inspiration from big companies? Do we try to stay lean?"

**中文翻译:**
我很想听听你的想法，因为我知道这是很多公司面临的挑战。“我们现在该投入多少流程？我们要向大公司学习吗？还是尽量保持精简？”

---

### [00:38:22] Lenny

**English:**
Something here, that we actually run into. I'll just mention briefly that, there was a huge resistance to process for a long time. And so the product team was just kind of a little crazy for a bit. And then we were like, "Okay, we need product development process. We need deadlines and specs." And that helped a lot.

**中文翻译:**
这是我们确实会遇到的问题。我简单提一下，很长一段时间里，人们对流程有巨大的抵触。所以产品团队一度有点疯狂。后来我们意识到：“好吧，我们需要产品开发流程，我们需要截止日期和规格说明（specs）。”这确实帮了大忙。

---

### [00:38:40] Lenny

**English:**
So let me ask again, just how do you think about the right level of process for a stage of company, and what have you learned there?

**中文翻译:**
所以我再问一次，你如何看待不同阶段公司所需的流程水平？你从中学习到了什么？

---

### [00:38:45] Eeke de Milliano

**English:**
Yeah. What I would really love from companies is just sort of like this time capsule, where you can see what their processes were when they were like 20 people, and 50 people, and 100 people, and 500 people.

**中文翻译:**
是的。我非常希望公司能提供一种“时间胶囊”，让你能看到他们在 20 人、50 人、100 人和 500 人规模时的流程分别是怎样的。

---

### [00:38:55] Eeke de Milliano

**English:**
Because when we were at Stripe and we were trying to figure out our planning process, we actually talked to Amazon, and Atlassian, and Apple, and all these companies that we really, really respect and look up to.

**中文翻译:**
因为当我们在 Stripe 试图摸索规划流程时，我们实际上咨询了亚马逊、Atlassian、苹果等所有这些我们非常尊敬和仰慕的公司。

---

### [00:39:07] Eeke de Milliano

**English:**
And I remember taking down notes from these companies and being like, "Yeah, this is awesome, but there's no way that this will work for Stripe." Stripe was so much smaller than any of these companies.

**中文翻译:**
我记得当时记下了这些公司的笔记，心想：“是的，这很棒，但这对 Stripe 绝对行不通。”当时的 Stripe 比这些公司中的任何一家都要小得多。

---

### [00:39:17] Eeke de Milliano

**English:**
So yeah, they were showing us where we had to go, but no idea how to get there. And so, yeah, Lenny, maybe you can help us figure out time capsules for companies and what processes make sense.

**中文翻译:**
所以，他们向我们展示了终点，但没告诉我们如何到达那里。所以，Lenny，也许你可以帮我们搞清楚公司的“时间胶囊”以及什么样的流程是有意义的。

---

### [00:39:27] Lenny

**English:**
Yeah. I am working on that, roughly.

**中文翻译:**
是的，我大致正在做这件事。

---

### [00:39:28] Eeke de Milliano

**English:**
Oh, nice.

**中文翻译:**
噢，太好了。

---

### [00:39:30] Lenny

**English:**
I'm going company by company, about how they think process and about process. And then maybe I'll check in every couple of years.

**中文翻译:**
我正在一家一家公司地调研，看他们如何看待流程。也许每隔几年我就会去回访一下。

---

### [00:39:36] Eeke de Milliano

**English:**
Cool. I love that. But yeah, to answer your question directly. Process... Yeah, it really gives people a bitter taste in their mouth, I think.

**中文翻译:**
酷，我喜欢这个。回到你的问题。流程……我觉得它确实会让人们感到反感。

---

### [00:39:47] Eeke de Milliano

**English:**
Process, by definition, is variance reducing. You're introducing it, because you worry that the variance in your org is too high. You want people to sort of meet a certain standard.

**中文翻译:**
从定义上讲，流程是为了减少差异。你引入它，是因为你担心组织的差异性太高。你希望大家都能达到某种标准。

---

### [00:40:00] Eeke de Milliano

**English:**
And the cost of that is obviously, while you are reducing the standard and bringing folks up to the average, you're also bringing other folks down to the average. And oftentimes, the folks you're bringing down are your highest performers, your most creative thinkers. The folks who, I think actually don't really need process to do their best work.

**中文翻译:**
而代价显而易见：当你通过降低标准把落后的人拉到平均水平时，你也把优秀的人拉低到了平均水平。通常，那些被拉低的人正是你最顶尖的员工、最有创意的思考者。我认为这些人其实根本不需要流程就能发挥出最佳水平。

---

### [00:40:21] Eeke de Milliano

**English:**
And so, that, I think is always the tension that you have with process. And obviously one of the reasons why companies introduce process much more and more, as companies get bigger, is because it's harder to get all these folks who don't need processing. You actually want to reduce the variance.

**中文翻译:**
所以，我认为这就是流程中始终存在的张力。显然，随着公司规模扩大，引入流程的原因之一是很难招到那么多不需要流程的人。你实际上是想减少这种不确定性。

---

### [00:40:38] Eeke de Milliano

**English:**
This is actually a little bit of an aside, but it's kind of relevant, so I'm just going to mention it. And you can feel free to let me know if it's too much of an aside.

**中文翻译:**
这其实有点扯远了，但又挺相关的，所以我提一下。如果你觉得太偏题了随时告诉我。

---

### [00:40:44] Lenny

**English:**
Let's get into it.

**中文翻译:**
没关系，展开说说。

---

### [00:40:47] Eeke de Milliano

**English:**
But, I was just listening to this awesome podcast with Russ Roberts, who's a professor. He hosts EconTalk. I don't know if you listen to it.

**中文翻译:**
我最近在听 Russ Roberts 教授的一个很棒的播客，他主持《EconTalk》。不知道你听过没。

---

### [00:40:56] Eeke de Milliano

**English:**
And he was in interviewing this guy, Ian Leslie, who's this great writer and has just written this article that's... Basically, something along the lines of what it means to be human in the age of AI.

**中文翻译:**
他当时在采访 Ian Leslie，一位很棒的作家。他刚写了一篇文章，大意是关于在 AI 时代“人”意味着什么。

---

### [00:41:07] Eeke de Milliano

**English:**
And I thought he just articulated this idea well. Which is, we're all really so impressed when we see ChatGPT-3 spit out this piece of writing that feels very human-like.

**中文翻译:**
我觉得他把这个观点表达得很好：当我们看到 ChatGPT-3 写出非常有“人味”的文章时，我们都感到非常震撼。

---

### [00:41:20] Eeke de Milliano

**English:**
But what we're kind of forgetting is that, over the last 10, 20, 30 years, we're actually asking humans to be a lot more robot-like. In that, we're really asking everyone to standardize in a lot of ways. And we're making people a lot more formulaic. If you think about how we teach people to write, it's like, "Well, there's five paragraphs. And there's your opening paragraph. And you state your topic."

**中文翻译:**
但我们有点忘了，在过去的 10、20、30 年里，我们实际上一直在要求人类变得更像机器人。我们要求每个人在很多方面都标准化，让人们变得更加公式化。想想我们是怎么教人写作的：“好，写五段话。这是开头段，陈述你的主题。”

---

### [00:41:43] Eeke de Milliano

**English:**
So anyway, I think the point is, the more formulaic, the more sort of mass produced you're trying to make something. The more you kind of quench people's creativity, and the further away you get from the really, really high highs. And that, to me, is the cost of process, and rules, and templates.

**中文翻译:**
总之，我认为重点在于，你越是追求公式化、越是追求大规模产出，你就越是在扼杀人们的创造力，也就越难达到那种极致的高水平。对我来说，这就是流程、规则和模板的代价。

---

### [00:42:05] Eeke de Milliano

**English:**
So if you're going to introduce it, be really, really sure that you're okay with that cost. And give folks escape hatches.

**中文翻译:**
所以如果你要引入流程，请务必确定你能接受这个代价。并且给人们留出“逃生舱口”（escape hatches）。

---

### [00:42:13] Eeke de Milliano

**English:**
So I've started referring to this as the MVP, the minimum viable process. So if I give folks a template, I'm like, "Look, use the template. But if you want to break out of it, please absolutely do." And I've started writing this at the top of templates now.

**中文翻译:**
所以我开始把这称为 MVP——最小可行性流程（minimum viable process）。如果我给员工一个模板，我会说：“看，用这个模板。但如果你想打破它，请务必这样做。”我现在开始在模板的顶部写上这句话。

---

### [00:42:26] Eeke de Milliano

**English:**
It's like, "If this doesn't work for what you're trying to explain, don't use it. But just know that this is the minimum viable thing. We're setting the bar here, but go higher if you can, please."

**中文翻译:**
就像是：“如果这不适合你想表达的内容，就别用它。但请记住，这是最低限度的要求。我们在这里设定了标准，但如果可以的话，请超越它。”

---

### [00:42:38] Eeke de Milliano

**English:**
So anyway, that's my sort of long drive on process. With all that said, I do think that companies, there's just a set of documents that are really, really viable. That every sort of level of the organization should have throughout its lifecycle.

**中文翻译:**
总之，这就是我对流程的一长串看法。话虽如此，我确实认为公司需要一套非常非常实用的文档，组织中的每个层级在整个生命周期中都应该拥有这些文档。

---

### [00:43:00] Eeke de Milliano

**English:**
But those documents, to me, are the charter. So, "What is your mission, your vision and your strategy?" The goals, "What are you aiming to do and how are you going to measure success?" And then the roadmap, "What is the thing that you're shipping?"

**中文翻译:**
对我来说，这些文档包括：章程（Charter），即“你的使命、愿景和战略是什么？”；目标（Goals），即“你的目标是什么，你将如何衡量成功？”；以及路线图（Roadmap），即“你要发布什么东西？”

---

### [00:43:15] Eeke de Milliano

**English:**
And I think the whole company needs these, the whole function. So in product, you need all three of these. And then, within each team you need all three of these.

**中文翻译:**
我认为整个公司都需要这些，整个职能部门也需要。在产品部门，你需要这三样；在每个团队内部，你也需要这三样。

---

### [00:43:26] Eeke de Milliano

**English:**
And I've kind of noticed two things about this framework for myself. One, I've actually noticed that teams often work their way from the bottom-up, versus top-down. They start with a roadmap. They're like, "What are all the things we're going to ship?" Especially early on. And then they kind of work their way into a charter. But I think it's really, really worth it to start from the top-down.

**中文翻译:**
关于这个框架，我注意到了两点。第一，我发现团队通常是自下而上而不是自上而下地开展工作。他们从路线图开始，想：“我们要发布哪些东西？”尤其是在早期。然后他们才慢慢摸索出章程。但我认为，从上到下开始是非常值得的。

---

### [00:43:47] Eeke de Milliano

**English:**
And then, the second thing that I've noticed is that your time horizon really shifts as you get more mature. So if you're very early on, you don't have PMF, you should have a charter, but your charter should be like three months in the future. Because you can't look that much further.

**中文翻译:**
第二点是，随着你变得成熟，你的时间视野（time horizon）会发生巨大变化。如果你处于非常早期，还没有达到产品市场匹配（PMF），你应该有一个章程，但你的章程应该只看未来三个月。因为你看不出那么远。

---

### [00:44:01] Eeke de Milliano

**English:**
And if you're a company that's humming and going, your charter is probably... The horizon's maybe a decade.

**中文翻译:**
而如果你是一家步入正轨、高速运转的公司，你的章程视野可能是……十年。

---

### [00:44:11] Lenny

**English:**
Wow. There is so much there. I could go into so many different directions. One thing I wanted to follow up on a little bit, is this idea... Such a great point. That process brings the best people down and kind of averages them out to create consistency.

**中文翻译:**
哇，信息量太大了。我可以从很多方向深入。我想跟进的一点是……这个观点太棒了：流程会拉低最优秀的人，把他们平均化以创造一致性。

---

### [00:44:28] Lenny

**English:**
And I'm curious if there's anything else you've seen succeed in allowing the best and most innovative brains to just do their thing. I know part of it is probably hiring amazing people. But yeah, is there anything else that's an escape hatch of just like, "Oh yeah, this person, just go. Go figure this out."

**中文翻译:**
我很想知道，你是否还见过其他成功的方法，能让最优秀、最有创新头脑的人尽情发挥？我知道其中一部分可能是雇佣优秀的人才。但除此之外，还有没有其他的“逃生舱口”，比如：“噢，这个人，随他去吧，让他自己去搞定。”

---

### [00:44:45] Eeke de Milliano

**English:**
To me, the unlock for organizations is managers, for this. Because you need managers to both detect the high performers and be like, "This person doesn't need the process." And then you need managers to give that person air cover to be like, "We're honestly..." Because what you're doing is, you're giving them some special treatment and you need to be kind of okay with that.

**中文翻译:**
对我来说，组织实现这一点的关键在于经理。因为你需要经理去发现那些高绩效者，并意识到“这个人不需要流程”。然后你需要经理为那个人提供“空中掩护”，说：“我们坦白讲……”因为你实际上是在给他们特殊待遇，你必须接受这一点。

---

### [00:45:02] Eeke de Milliano

**English:**
And you also need to be okay with the organizational cost for that. Claire, who used to be the COO of Stripe, would always say, "Are you willing to break the org for this person?" And I always thought that was a really nice framing. And you kind of need to decide who you want to do it for, too.

**中文翻译:**
你还必须接受由此带来的组织成本。Stripe 的前 COO Claire 总是会问：“你愿意为了这个人打破组织规则吗？”我一直觉得这是一个非常好的切入点。你也需要决定你愿意为谁这样做。

---

### [00:45:17] Eeke de Milliano

**English:**
But yeah, some people are just that good that like, "Yeah, of course you'll break the org for them." They're going to break the org in the best way possible.

**中文翻译:**
是的，有些人就是那么优秀，以至于你会觉得：“当然，为了他们打破规则完全值得。”他们会以最好的方式“打破”组织。

---

### [00:45:27] Lenny

**English:**
Yeah. I love that term. I think Claire's coming on this podcast. She just wrote a book, right? Is that the same person?

**中文翻译:**
是的，我喜欢这个说法。我想 Claire 也要来这个播客了。她刚写了一本书，对吧？是同一个人吗？

---

### [00:45:29] Eeke de Milliano

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:45:30] Lenny

**English:**
Okay, great.

**中文翻译:**
好的，太棒了。

---

### [00:45:30] Eeke de Milliano

**English:**
Yeah, she just wrote a book. Yep.

**中文翻译:**
是的，她刚写了本书。

---

### [00:45:33] Lenny

**English:**
All right, we just booked her. Come, and maybe we'll spend some time together.

**中文翻译:**
太好了，我们刚约好她。到时候也许我们可以一起聊聊。

---

### [00:45:36] Eeke de Milliano

**English:**
That's awesome.

**中文翻译:**
那太棒了。

---

### [00:45:37] Lenny

**English:**
Do you have any other product building philosophies that you found especially useful in your time at Stripe, and Retool, and anywhere else?

**中文翻译:**
你在 Stripe、Retool 或其他地方工作期间，还有什么特别实用的产品构建哲学吗？

---

### [00:45:45] Eeke de Milliano

**English:**
I have a couple of, I guess, specific mental models that I use. The first is, build for your best user, not your worst user.

**中文翻译:**
我有几个常用的具体思维模型。第一个是：为你的最佳用户构建产品，而不是为最差用户。

---

### [00:45:53] Eeke de Milliano

**English:**
And what I mean by that is, I think it's actually really easy to get stuck, or to focus on, "What if there's abuse of this product?" Or think about all the ways in which the product won't be used well. And then you end up sort of shaping the product in these really weird funky ways to make up for that.

**中文翻译:**
我的意思是，人们很容易陷入这种思维：“如果有人滥用这个产品怎么办？”或者思考产品可能被错误使用的所有方式。然后你最终会为了弥补这些可能性，把产品塑造成非常奇怪、别扭的样子。

---

### [00:46:11] Eeke de Milliano

**English:**
Whereas in reality, the worst users, they should be a fraction of your users anyway. So you shouldn't really be building for them.

**中文翻译:**
而现实中，最差的用户无论如何都只占你用户的一小部分。所以你真的不应该为了他们而构建产品。

---

### [00:46:19] Eeke de Milliano

**English:**
I think a really good example of this is onboarding processes. Where, you're probably going to be building an onboarding process, where you're trying to collect a lot of data. Or trying to figure out, "Hey, how do I help this user who maybe isn't well suited for my product to be successful?"

**中文翻译:**
我认为一个很好的例子是新手引导（onboarding）流程。你可能会构建一个试图收集大量数据的新手引导，或者试图弄清楚：“嘿，我该如何帮助这个可能并不适合我产品的用户获得成功？”

---

### [00:46:37] Eeke de Milliano

**English:**
Really, you should just be building an onboarding process for the user who's going to jump into your product and get it immediately.

**中文翻译:**
实际上，你应该为那些一进入你的产品就能立刻上手并理解它的用户构建新手引导。

---

### [00:46:42] Eeke de Milliano

**English:**
I was thinking about this actually just the other day. Because we were in this product review, and we were talking about this other new product that we're thinking of exploring.

**中文翻译:**
前几天我还在想这件事。当时我们在进行产品评审，讨论我们想探索的另一个新产品。

---

### [00:46:48] Lenny

**English:**
More products? It never ends.

**中文翻译:**
还有新产品？真是没完没了。

---

### [00:46:52] Eeke de Milliano

**English:**
Yeah, exactly. And we're kind of going down this path of like, "Oh, well if this gets really big, there's going to be all this abuse of the product." And Anthony, our founder was like, "Wouldn't that be an amazing problem to have?" And we're like, "Yeah, that's a really good point."

**中文翻译:**
是的，没错。我们当时有点陷入这种思维：“噢，如果这个产品做大了，会有各种滥用行为。”我们的创始人 Anthony 说：“如果真的遇到那种问题，那不是一个‘幸福的烦恼’吗？”我们心想：“是的，说得太对了。”

---

### [00:47:03] Eeke de Milliano

**English:**
So we kind of put that on the back burner.

**中文翻译:**
所以我们就把那个担忧先搁置了。

---

### [00:47:07] Lenny

**English:**
That's an interesting approach, because usually you're trying to optimize a flow, get more people through it, which are the least good users.You're saying you found more success just focusing...

**中文翻译:**
这是一个很有趣的方法。因为通常人们会试图优化流程，让更多人通过，而这些人往往是那些最不核心的用户。你是说你发现专注于核心用户更成功……

---

### [00:47:16] Lenny

**English:**
Is this more initially, focus on the users that will understand this, and be excited about it, and make that work really well. And then, over time, build on that?

**中文翻译:**
这是指在初期，专注于那些能理解并对产品感到兴奋的用户，把那部分体验做得非常好，然后随着时间的推移再在此基础上扩展吗？

---

### [00:47:23] Eeke de Milliano

**English:**
Yeah, totally. Yeah, sure. If you're going to look at the end, and you're trying to optimize, et cetera, absolutely. But in that sort of early product development stage, it's just not worth it to be too focused on that.

**中文翻译:**
是的，完全正确。当然，如果你已经到了后期，想要进行优化等等，那绝对要考虑。但在早期产品开发阶段，过度关注这些是不值得的。

---

### [00:47:33] Lenny

**English:**
Got it. Sweet.

**中文翻译:**
明白了，太棒了。

---

### [00:47:34] Eeke de Milliano

**English:**
So, that's one. The other one, our head of design, Ryan, always kind of reminds us of is, build the scooter, not the axle.

**中文翻译:**
这是其一。另一个是我们的设计负责人 Ryan 经常提醒我们的：要造滑板车，而不是造车轴。

---

### [00:47:44] Eeke de Milliano

**English:**
So if you're trying to build the minimum viable product for a car, don't build just the wheels and the axle, build the scooter first. And then from there, you build the bicycle, and the motorcycle, and then the car.

**中文翻译:**
如果你想为一辆汽车构建最小可行性产品（MVP），不要只造轮子和车轴，先造一辆滑板车。然后在此基础上，你再造自行车、摩托车，最后才是汽车。

---

### [00:47:54] Eeke de Milliano

**English:**
And it's always just such a good reminder. You always want to start building the whole thing. But really try and think about the slice that gets the customer to complete value on a smaller thing first.

**中文翻译:**
这总是一个很好的提醒。你总是想一开始就构建整个东西。但要真正尝试去思考那个能让客户在较小的事物上首先获得完整价值的切片。

---

### [00:48:06] Eeke de Milliano

**English:**
So with Retool Mobile for example, there's just so much you could be building there. And we decided very specifically, "Hey, we're only going to build this for companies that have field workers and they would need to do inventory management."

**中文翻译:**
以 Retool Mobile 为例，你可以构建的东西太多了。我们非常明确地决定：“嘿，我们只为那些拥有外勤人员且需要进行库存管理的公司构建这个产品。”

---

### [00:48:18] Eeke de Milliano

**English:**
And it's a very specific slice, but it helps get through from something that was actually viable, beginning to end.

**中文翻译:**
这是一个非常具体的切片，但它有助于完成一个从头到尾真正可行的东西。

---

### [00:48:25] Lenny

**English:**
Got it. So it's an approach for MVPs, basically. Make something simple and functional, not just something barely... Not actually working, but getting you to some dream product eventually.

**中文翻译:**
明白了。所以这基本上是做 MVP 的一种方法。做一个简单且功能完备的东西，而不仅仅是一个勉强能看、实际上不能用，却承诺最终会带你走向梦想产品的东西。

---

### [00:48:37] Eeke de Milliano

**English:**
Yeah. And then the last one is this idea of 70/20/10 split investments. I really think that a lot of product management can sometimes be reduced to funnels and portfolios.

**中文翻译:**
是的。最后一个是 70/20/10 的投资分配比例。我真的认为，很多产品管理工作有时可以简化为漏斗（funnels）和组合（portfolios）。

---

### [00:48:51] Eeke de Milliano

**English:**
So the 70/20/10 investments model in my head is just like, 70% of your building time should really be going to your core product, that has product market fit. 20% of your time should be going to strategic initiatives that aren't core, but they're strategic to the company, that you know have to do them. And then, 10% of your time should be going towards bets.

**中文翻译:**
我脑海中的 70/20/10 投资模型是：70% 的开发时间应该投入到已经达到产品市场匹配的核心产品上；20% 的时间应该投入到非核心但对公司具有战略意义、你必须做的战略计划上；剩下的 10% 应该用于各种尝试和赌注（bets）。

---

### [00:49:11] Lenny

**English:**
That's actually exactly the same heuristic I've always used. One question there is, how do you think about maintenance and bugs within that?

**中文翻译:**
这实际上和我一直使用的启发式方法完全一样。一个问题是：你如何将维护和 Bug 处理纳入这个比例？

---

### [00:49:19] Eeke de Milliano

**English:**
Yeah. To me, that falls squarely in the 70%. So yeah, core product, tech debt, sort of the maintenance mode type stuff. And core product, obviously you're also doing a bunch of new stuff there too.

**中文翻译:**
是的。对我来说，这完全属于那 70%。所以，核心产品、技术债、维护模式之类的工作都在这里。当然，在核心产品中，你显然也会做很多新功能。

---

### [00:49:31] Eeke de Milliano

**English:**
But yeah, no more than 70% of your resources should be going there.

**中文翻译:**
但没错，投入在那里的资源不应超过 70%。

---

### [00:49:35] Lenny

**English:**
What did you say the 20% was?

**中文翻译:**
你刚才说那 20% 是什么？

---

### [00:49:37] Eeke de Milliano

**English:**
Strategic initiatives that aren't your core, but you just know, based on your strategy, you have to do these things.

**中文翻译:**
非核心但你根据战略知道必须去做的战略计划。

---

### [00:49:45] Lenny

**English:**
Got it. So the way I break it up is, 20% is where I put bugs and maintenance. And then 10% was big, ambitious bets. So it was similar ratios, but different things go into the buckets.

**中文翻译:**
明白了。我的划分方式是：20% 用于 Bug 和维护，10% 用于宏大且有野心的赌注。比例相似，但桶里装的东西不太一样。

---

### [00:49:56] Eeke de Milliano

**English:**
Cool.

**中文翻译:**
酷。

---

### [00:49:57] Lenny

**English:**
But, let me ask a similar question. How do you, at Retool, and maybe even at Stripe, think about finding time to do maintenance and bugs? Do you build it into roadmaps? Do you set off time to just fix all the bugs? I know it's probably an evolution, and it goes back and forth. But, any thoughts?

**中文翻译:**
但我问一个类似的问题。在 Retool，甚至可能在 Stripe，你们如何考虑留出时间处理维护和 Bug？是把它们写进路线图吗？还是专门拨出时间来修复所有 Bug？我知道这可能是一个演变的过程，会反复调整。你有什么想法吗？

---

### [00:50:11] Eeke de Milliano

**English:**
Yeah. This, I think, is really one of the trickiest parts of product management, in my mind.

**中文翻译:**
是的。在我看来，这确实是产品管理中最棘手的部分之一。

---

### [00:50:18] Eeke de Milliano

**English:**
We don't have a company-wide sort of process on this. It's pretty team specific. Some teams do Friday bug bashes. Other teams are just, as products roll out, will work on them as they go.

**中文翻译:**
我们在这方面没有全公司统一的流程。这非常取决于具体的团队。有些团队会在周五进行 Bug 大扫除（bug bashes）；有些团队则是在产品发布过程中随手解决。

---

### [00:50:33] Eeke de Milliano

**English:**
I was actually speaking to a product manager at a different company, who mentioned that they just spent the last 18 months doing just product polish and bugs. And I think they landed in a place where they had to do it, because they just had so much debt. But luckily, we're not there yet.

**中文翻译:**
我最近和另一家公司的 PM 聊天，他提到他们过去 18 个月只做产品打磨和修复 Bug。我想他们是到了不得不这么做的地步，因为欠了太多债。但幸运的是，我们还没到那个地步。

---

### [00:50:54] Eeke de Milliano

**English:**
Right now, we let most of the teams just kind of do it themselves and figure out what makes sense for them.

**中文翻译:**
目前，我们让大多数团队自己决定，找出最适合他们的方式。

---

### [00:50:59] Lenny

**English:**
Okay. Awesome. I wanted to go back to something that I've heard about Retool, that you all are really good at. Which is PM's being really close to customers. And I'm curious what you've done there, or what the team has done there, that it's been really effective?

**中文翻译:**
好的，太棒了。我想回到我听到的关于 Retool 的一点，那是你们非常擅长的：PM 与客户保持非常紧密的联系。我很想知道你们在那方面做了什么，或者团队做了什么，让它变得如此有效？

---

### [00:51:13] Eeke de Milliano

**English:**
Well, I do think every good product team figures out how to get close to customers. But just based off of my observations from Retool, and what I've seen at other companies, there are a couple things that are more pronounced at Retool than I've seen in a lot of other places.

**中文翻译:**
我认为每个优秀的产品团队都会想办法接近客户。但根据我对 Retool 的观察以及我在其他公司的见闻，Retool 有几点比其他地方更突出。

---

### [00:51:28] Eeke de Milliano

**English:**
The first is, we have a lot of PMs who used to be in customer-facing roles, at Retool. I obviously am a big fan of that. I think there's just nothing like really understanding the value of your product, at the moment where a customer actually has to put money down. And so, I really like that about PMs, who have had those conversations with customers and they really get it.

**中文翻译:**
第一，在 Retool，我们有很多 PM 以前做过面向客户的工作。我显然非常推崇这一点。我认为，没有什么比在客户真正需要掏钱的那一刻去理解产品的价值更深刻的了。所以我非常喜欢那些与客户交流过并真正理解他们的 PM。

---

### [00:51:53] Eeke de Milliano

**English:**
Second is, because the retail product is so technical... And I do think this just depends on what product you have. Our PMs are really, very technical. Everyone has either a CS degree, or has done some sort of engineering in the past.

**中文翻译:**
第二，因为 Retool 的产品非常技术化……我认为这取决于你做什么产品。我们的 PM 真的非常懂技术，每个人要么有计算机科学（CS）学位，要么过去做过某种工程工作。

---

### [00:52:06] Eeke de Milliano

**English:**
Third is, we use Slack very heavily to talk to our customers and interact with them. So at this point, I think we have hundreds of Slack channels with customers. Every time we're testing a new product, or a new customer who's somewhat large, comes online. We will work with them in Slack, to get there off-the-cuff feedback, just back and forth. It's really nice. We just have this direct line to them, which is awesome.

**中文翻译:**
第三，我们非常频繁地使用 Slack 与客户交流和互动。目前，我想我们有数百个与客户沟通的 Slack 频道。每当我们测试新产品，或者有大客户上线时，我们都会在 Slack 中与他们协作，获取即时反馈，反复沟通。这非常好，我们有一条直接联系他们的渠道。

---

### [00:52:34] Eeke de Milliano

**English:**
And the fourth thing we do is, we use Retool to build Retool. So our product roadmap lives in a Retool app. And the app that we use to have feature flags for particular features, is a Retool app. So PMs are just in the product all day long, every day. They're their own customers in a lot of ways, and that really helps as well.

**中文翻译:**
第四点是，我们用 Retool 来构建 Retool。我们的产品路线图就在一个 Retool 应用里。我们用来管理特定功能开关（feature flags）的应用也是一个 Retool 应用。所以 PM 们整天都在使用这个产品。在很多方面，他们就是自己的客户，这非常有帮助。

---

### [00:52:57] Lenny

**English:**
Wow, I didn't know that. That is very cool. So you build a task management product using Retool?

**中文翻译:**
哇，我以前不知道这个。太酷了。所以你们用 Retool 构建了一个任务管理产品？

---

### [00:53:03] Eeke de Milliano

**English:**
Oh, yeah. Well, we built many... Basically, all of our internal tooling happens in Retool. Like, our PMs, all their team dashboards are in Retool. All of their task tracking is in Retool. Submitting linear requests or bug requests happens in Retool, and then goes to Linear. So yeah, it's how we run the company.

**中文翻译:**
噢，是的。我们构建了很多……基本上，我们所有的内部工具都是在 Retool 中运行的。比如我们 PM 的所有团队仪表盘都在 Retool 里，所有的任务追踪都在 Retool 里。提交 Linear 请求或 Bug 请求也是在 Retool 里完成，然后同步到 Linear。所以，这就是我们运作公司的方式。

---

### [00:53:23] Lenny

**English:**
You haven't been able to replace Linear yet? That's cool. I'm a big fan of Linear.

**中文翻译:**
你们还没能取代 Linear 吗？挺好的，我是 Linear 的忠实粉丝。

---

### [00:53:29] Lenny

**English:**
Okay, two more questions and then I'll let you go. One is around product growth. Which, I don't want to get too into. We've talked about it a bunch on this podcast.

**中文翻译:**
好，最后两个问题，然后我就放你走。一个是关于产品增长的，我不想深入讨论，因为我们在播客里聊过很多次了。

---

### [00:53:37] Lenny

**English:**
But, it's interesting that Stripe was very product-led growth. It was just self-serve PMs, engineers, whoever, just started using it. It grew and became enterprisey down the road.

**中文翻译:**
但有趣的是，Stripe 是非常典型的产品驱动增长（PLG）。它就是自助式的，PM、工程师或任何人直接开始使用。它逐渐壮大，后来才变得具有企业级特性。

---

### [00:53:49] Lenny

**English:**
Retool, on the other hand, I think people think it's product-led growth. I imagine it's actually sales-led, mostly.

**中文翻译:**
另一方面，Retool，我想人们可能以为它是产品驱动增长，但我猜它实际上主要是销售驱动的。

---

### [00:53:54] Lenny

**English:**
And so, I just curious what you've learned about the difference between building product and leading product teams within a sales-led org, versus a product-led org.

**中文翻译:**
所以我很好奇，在销售驱动的组织和产品驱动的组织中构建产品和领导产品团队，你学到了哪些区别？

---

### [00:54:04] Eeke de Milliano

**English:**
I have a couple of insights on that. One interesting insight is that, teams that have one always want the other.

**中文翻译:**
我有几点心得。一个有趣的发现是：拥有其中一种模式的团队总是渴望另一种。

---

### [00:54:10] Lenny

**English:**
That's so true.

**中文翻译:**
太真实了。

---

### [00:54:12] Eeke de Milliano

**English:**
Whenever I talk to candidates, I feel like you can always tell what their company has, because they'll be asking a lot of questions about the opposite. If they're probably a growth company they'll be like, "Well, how are you guys thinking about Enterprise?"

**中文翻译:**
每当我面试候选人时，我觉得你总能一眼看出他们公司是什么模式，因为他们会问很多关于相反模式的问题。如果他们来自增长型公司，他们会问：“你们是怎么考虑企业级市场的？”

---

### [00:54:24] Eeke de Milliano

**English:**
And then, if they are more of a sales-led growth company, they're like, "Well, how are you guys thinking about your self-serve motion, or your product-led growth?"

**中文翻译:**
如果他们来自销售驱动型公司，他们会问：“你们是怎么考虑自助服务流程或产品驱动增长的？”

---

### [00:54:31] Eeke de Milliano

**English:**
And my main takeaway, just in... And I don't know if I would even use the dichotomy of product-led growth, or sales-led growth, with Retool. I think we do have a lot of product-led growth. But we work with a lot of enterprise customers, and a lot of our revenue comes from enterprise customers, and we have a fantastic sales team.

**中文翻译:**
我的主要体会是……我甚至不知道是否该用 PLG 或销售驱动这种二分法来形容 Retool。我认为我们确实有很多产品驱动增长，但我们也服务于大量企业客户，很大一部分收入来自企业客户，而且我们有一支非常棒的销售团队。

---

### [00:54:49] Eeke de Milliano

**English:**
And I think the main thing is that, you just have to really figure out your interaction mechanisms with sales. And that just has to be so, so tight.

**中文翻译:**
我认为最关键的一点是，你必须真正理顺与销售部门的互动机制。这种联系必须非常、非常紧密。

---

### [00:55:00] Eeke de Milliano

**English:**
And it goes in both directions. There's obviously, how you get feedback from them, because they are so often on the front lines talking to customers. Moreso than product managers, even.

**中文翻译:**
而且这是双向的。显然，一方面是你如何从他们那里获得反馈，因为他们经常在第一线与客户交谈，甚至比 PM 还要频繁。

---

### [00:55:08] Eeke de Milliano

**English:**
But it also goes the other way. If you are going to ship something, or if you are going to put out a roadmap, like, "How do you make sure that the sales team has everything that they need..." The sales, and in Retool's case, the success team and the support team, "Has everything they need to accurately talk to customers about that?"

**中文翻译:**
但另一方面也同样重要。如果你要发布什么东西，或者要公布路线图，你如何确保销售团队（在 Retool 还有客户成功团队和支持团队）拥有他们所需的一切，以便准确地向客户传达信息？

---

### [00:55:26] Eeke de Milliano

**English:**
And I've always actually found that really hard, because it's really hard to figure out the right altitude. If you're giving a presentation on the roadmap, people are either going to feel like it's too high level. Or, it's too low level for folks who maybe are new.

**中文翻译:**
我一直觉得这很难，因为很难把握好“高度”。如果你做一个路线图演示，人们要么觉得太宏观，要么对新人来说又太细节。

---

### [00:55:40] Eeke de Milliano

**English:**
So this year, we're actually trying something different. We are doing a science fair. Where, each product team has a little booth. And they get to stand there, and anyone who has questions about the product can come... You know, from the go-to-market side, can come and ask questions, and get demos, and go as deep as they need to.

**中文翻译:**
所以今年我们尝试了一些不同的东西。我们正在举办一个“科学博览会”（science fair）。每个产品团队都有一个小展位，他们站在那里，任何对产品有疑问的人（比如市场部门的人）都可以过来提问、看演示，并根据需要深入了解。

---

### [00:55:57] Eeke de Milliano

**English:**
So, I'll let you know how that goes. But I'm excited to experiment with it.

**中文翻译:**
我会告诉你结果如何，但我对这个实验感到很兴奋。

---

### [00:56:04] Lenny

**English:**
Okay. Are there going to be foam core boards, and will there be ribbons?

**中文翻译:**
好。会有泡沫板展板和丝带奖章吗？

---

### [00:56:08] Eeke de Milliano

**English:**
There may be prizes. Who knows?

**中文翻译:**
可能会有奖品，谁知道呢？

---

### [00:56:10] Lenny

**English:**
Oh my God. I can't wait to see a picture of this. Final topic. You have this concept that you call the product talent portfolio. What does that mean, and how have you found that useful in your product leadership life?

**中文翻译:**
天呐，我等不及想看照片了。最后一个话题。你有一个叫做“产品人才组合”（product talent portfolio）的概念。那是什么意思？在你的产品领导生涯中，你觉得它有什么用？

---

### [00:56:25] Eeke de Milliano

**English:**
Yeah. Yeah, it's back to like, all of product management is portfolios and funnels.

**中文翻译:**
是的。又回到了那个观点：所有的产品管理都是组合和漏斗。

---

### [00:56:29] Eeke de Milliano

**English:**
I think it's really tempting as a manager, to build a team in your image, because you understand their skillsets and you value those skillsets. And you're going to be able to detect and assess those skillsets better.

**中文翻译:**
我认为作为一名经理，很容易倾向于按照自己的样子去组建团队，因为你了解那些技能组合并看重它们，你也更擅长发现和评估这些技能。

---

### [00:56:43] Eeke de Milliano

**English:**
But the best product teams, in my mind, have really figured out how to balance the talent portfolio. So instead of having a bunch of PMs who all spike in one particular area, figure out how you can create complimentary skillsets for the whole PM team, so the whole is much stronger.

**中文翻译:**
但在我看来，最好的产品团队真正懂得如何平衡人才组合。与其拥有一群在某个特定领域都很强（spike）的 PM，不如想办法为整个 PM 团队创造互补的技能组合，这样整体实力会更强。

---

### [00:57:04] Eeke de Milliano

**English:**
And one way in which I like to do that is, I really like to balance product teams with homegrown product managers, who really get the product. They've probably been in it. They're amazing culture carriers, often. They really set the tone. But they may not have seen product management at other companies, and they may not have some of the more conventional and traditional product management skillsets.

**中文翻译:**
我喜欢的一种方式是，在产品团队中平衡“内部培养”的 PM。他们非常了解产品，可能一直参与其中，通常是优秀的文化传承者，能奠定基调。但他们可能没见过其他公司的产品管理方式，可能缺乏一些更常规、更传统的产品管理技能。

---

### [00:57:25] Eeke de Milliano

**English:**
So I want to balance that with product managers who've come from other companies, and have done it, and can bring a little bit more of that product manager rigor. Even though they don't have, in the Retool case, the core Retool product management vibe.

**中文翻译:**
所以我希望用那些来自其他公司、有实战经验的 PM 来平衡，他们能带来更多的产品管理严谨性。尽管他们可能没有 Retool 核心的那种产品管理氛围。

---

### [00:57:41] Eeke de Milliano

**English:**
So, that's one example. I think there's others as well. Some PMs are just incredible execution machines. Other PMs are amazing visionaries. You kind of want a little bit of all of them.

**中文翻译:**
这是一个例子。我想还有其他的。有些 PM 是极其出色的执行机器，有些 PM 是了不起的愿景家。你希望每种人都有一点。

---

### [00:57:51] Eeke de Milliano

**English:**
And you want to also balance within all of your different pillars. So we have three different sort of product pillars at Retool, and there's leads for all those pillars. And I always push the leads to hire people who don't look like them, so that we have balance everywhere.

**中文翻译:**
你还希望在不同的业务支柱（pillars）之间实现平衡。在 Retool 我们有三个不同的产品支柱，每个支柱都有负责人。我总是敦促这些负责人去雇佣那些和他们不像的人，这样我们就能在各处实现平衡。

---

### [00:58:08] Lenny

**English:**
I love that. Do you, actively, as you're hiring, "Hey, well you're strong in these areas. Here's the person we need, here. We want this specific, super strategy minded person." Is that actually how you think about this?

**中文翻译:**
我喜欢这一点。你在招聘时会主动想：“嘿，你在这些领域很强，但我们需要这样一个人，我们需要一个特别有战略头脑的人。”你真的是这样思考的吗？

---

### [00:58:20] Eeke de Milliano

**English:**
Yeah. I do a little personal exercise for myself every six months, where I chart out the team that we have today, and write down all of the strengths that we have, all of the weaknesses that we have, as a team. And then I try to hire specifically for those weaknesses.

**中文翻译:**
是的。我每六个月会给自己做一个小练习：画出我们现有的团队图谱，写下我们作为一个团队所有的优势和劣势。然后我会有针对性地针对这些劣势进行招聘。

---

### [00:58:35] Lenny

**English:**
Amazing. Any last pieces of wisdom or thoughts, before we get to our very exciting lightning round?

**中文翻译:**
太棒了。在进入我们非常精彩的闪电轮提问之前，还有什么最后的智慧或想法要分享吗？

---

### [00:58:42] Eeke de Milliano

**English:**
I think that's it on my end.

**中文翻译:**
我这边差不多就这些了。

---

### [00:58:43] Lenny

**English:**
Okay. We got through everything I was hoping to get through.

**中文翻译:**
好的，我们完成了所有我希望能涵盖的内容。

---

### [00:58:46] Lenny

**English:**
So with that, we've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
那么，我们进入了非常精彩的闪电轮。我有六个问题要问你。准备好了吗？

---

### [00:58:52] Eeke de Milliano

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [00:58:53] Lenny

**English:**
What are two or three books that you recommend most, to other people?

**中文翻译:**
你最推荐给别人的两三本书是什么？

---

### [00:58:57] Eeke de Milliano

**English:**
Bird by Bird: Instructions on Writing and Life by Anne Lamott. It's incredible. So touching. Really, really great. Also, I think product managers should be great writers. So, I love that.

**中文翻译:**
Anne Lamott 的《一只鸟接着一只鸟》（Bird by Bird: Instructions on Writing and Life）。这本书棒极了，非常感人。而且我认为 PM 应该成为优秀的写作者，所以我很喜欢这本书。

---

### [00:59:08] Eeke de Milliano

**English:**
And then the other book that I was going to say, but I'm glad you mentioned Claire, is Claire's book, Scaling People, which is coming out. I had a very small hand in ghost writing for her a little bit, in the first draft. So I use a lot of the early chapters from that book still, in management. And I still recommend the tactics in there, so I'm excited for her to get it out.

**中文翻译:**
另一本我想说的书——很高兴你提到了 Claire——是 Claire 即将出版的新书《Scaling People》。我在初稿时曾参与了一点点代笔工作。在管理中，我至今仍在使用那本书早期章节里的很多内容。我依然推荐其中的策略，所以我很期待这本书出版。

---

### [00:59:29] Lenny

**English:**
Wow. I've been hearing about ghost writing as a career recently, and it feels like it could be an option for you down the road.

**中文翻译:**
哇。我最近听说代笔也是一种职业选择，感觉这以后也可以是你的一个选项。

---

### [00:59:36] Lenny

**English:**
I'm excited to read the book. I haven't gotten a copy yet. I think you could pre-order it now, and we'll link to it in the show notes.

**中文翻译:**
我很期待读这本书，我还没拿到副本。我想现在可以预订了，我们会把链接放在节目介绍里。

---

### [00:59:41] Eeke de Milliano

**English:**
Nice.

**中文翻译:**
太好了。

---

### [00:59:42] Lenny

**English:**
What's a favorite other podcast that you like to listen to, other than maybe the one you're on right now?

**中文翻译:**
除了你现在参加的这个，你最喜欢听的播客是什么？

---

### [00:59:46] Eeke de Milliano

**English:**
Yeah, this one's great. I can't choose between these two, though. One is Lex Fridman. And then the other is EconTalk by Russ Roberts. I really like that both of them are... Their agenda is curiosity, which I love.

**中文翻译:**
是的，这个播客很棒。不过我在另外两个之间很难抉择：一个是 Lex Fridman 的播客，另一个是 Russ Roberts 的《EconTalk》。我非常喜欢他们的一点是：他们的核心驱动力是好奇心。

---

### [00:59:59] Lenny

**English:**
Totally resonate there. What is a favorite recent movie or TV show that you've enjoyed?

**中文翻译:**
完全共鸣。最近你喜欢的电影或电视剧是什么？

---

### [01:00:04] Eeke de Milliano

**English:**
Is it too basic to say White Lotus?

**中文翻译:**
说《白莲花度假村》（White Lotus）会不会太大众化了？

---

### [01:00:07] Lenny

**English:**
Cool. That's the most mentioned one, which says a lot, right? That just says how good that is, because I love it too. But, that works. Season one or season two?

**中文翻译:**
没事。那是被提到次数最多的，这说明了很多问题，对吧？说明它真的很好看，因为我也喜欢。没问题。第一季还是第二季？

---

### [01:00:17] Eeke de Milliano

**English:**
Oh, season two, all the way.

**中文翻译:**
噢，绝对是第二季。

---

### [01:00:19] Lenny

**English:**
Yeah, same. I'm excited for season three. No spoilers. Favorite interview question that you like to ask candidates?

**中文翻译:**
我也一样。我很期待第三季。不剧透了。你最喜欢问候选人的面试问题是什么？

---

### [01:00:27] Eeke de Milliano

**English:**
To what do you attribute your success? And you can't say luck.

**中文翻译:**
“你将你的成功归功于什么？而且你不能说是运气。”

---

### [01:00:32] Lenny

**English:**
Interesting. Because most people look for, do they believe it's luck, versus their innate skill? So you don't even allow them to say luck? Interesting.

**中文翻译:**
有趣。因为大多数人会观察候选人是相信运气还是相信自己的天赋。你甚至不允许他们说是运气？真有意思。

---

### [01:00:41] Eeke de Milliano

**English:**
Yeah. Because I think humble people will always say luck in some way. And I always kind of wanted to know, "How self aware are you, and how curious are you?"

**中文翻译:**
是的。因为我认为谦虚的人总会以某种方式提到运气。而我总是想知道：“你的自我意识有多强？你的好奇心有多大？”

---

### [01:00:51] Eeke de Milliano

**English:**
And I think people who have really gone back and reflected on why are they where they are today, really says a lot about how they think about the world.

**中文翻译:**
我认为那些真正回过头去反思自己为何能取得今天成就的人，能体现出他们是如何思考这个世界的。

---

### [01:01:03] Lenny

**English:**
I love that. What are some SaaS tools that you love, or use often, at your current company, or anywhere else?

**中文翻译:**
我喜欢这个。有哪些你喜欢或经常使用的 SaaS 工具，无论是在现在的公司还是其他地方？

---

### [01:01:08] Eeke de Milliano

**English:**
Yeah. Well, first and foremost, it's Retool. And then, the other SaaS tools that we use a lot, Slack, Gong, Linear and FullStory.

**中文翻译:**
是的。首先当然是 Retool。然后我们经常使用的其他 SaaS 工具还有 Slack、Gong、Linear 和 FullStory。

---

### [01:01:18] Lenny

**English:**
Awesome. Favorite new product that you found, maybe in life, maybe at work?

**中文翻译:**
太棒了。你最近发现的最喜欢的、无论是在生活还是工作中的新产品是什么？

---

### [01:01:24] Eeke de Milliano

**English:**
Yeah. Have you heard of Rewind?

**中文翻译:**
是的。你听说过 Rewind 吗？

---

### [01:01:27] Lenny

**English:**
Yes, I have it running right now.

**中文翻译:**
听说过，我现在就在运行它。

---

### [01:01:31] Eeke de Milliano

**English:**
Nice. Yeah. I mean, I think it's really incredible what they've done.

**中文翻译:**
太好了。我是说，我觉得他们做出的东西真的很不可思议。

---

### [01:01:35] Lenny

**English:**
Maybe describe it briefly, just so folks know what that is.

**中文翻译:**
也许可以简要描述一下，让大家知道那是什么。

---

### [01:01:38] Eeke de Milliano

**English:**
It basically records everything that you're doing on your computer and then makes it really easy for you to search it. Which, it's just incredible. I don't know if you work this way, Lenny. But I feel like nowadays, I don't really go to tabs anymore. I kind of directly search for the thing that I'm searching for. And I think Rewind just fits that user behavior so, so well.

**中文翻译:**
它基本上会记录你在电脑上做的一切，然后让你非常容易地进行搜索。这真的很神奇。我不知道你是不是这样工作的，Lenny，但我感觉现在我不再去翻标签页了，我直接搜索我想找的东西。我认为 Rewind 非常完美地契合了这种用户行为。

---

### [01:02:06] Lenny

**English:**
Amazing. Eeke, this was so much fun. We got through everything I was hoping for, and more.

**中文翻译:**
太棒了。Eeke，这次聊天非常愉快。我们聊完了我希望涵盖的所有内容，甚至更多。

---

### [01:02:09] Lenny

**English:**
Two final questions. Where can folks find you online if they want to reach out, learn more, see what you're up to? And, how can listeners be useful to you?

**中文翻译:**
最后两个问题。如果人们想联系你、了解更多信息或关注你的动态，可以在哪里找到你？以及，听众可以为你做些什么？

---

### [01:02:16] Eeke de Milliano

**English:**
Definitely find me online on Twitter. It's @EekeDM. And, how can they help us? Try out the Retool product and give us some feedback.

**中文翻译:**
可以在 Twitter 上找我，账号是 @EekeDM。至于如何帮助我们：去试用一下 Retool 产品并给我们一些反馈。

---

### [01:02:25] Lenny

**English:**
Amazing. Retool.com, right?

**中文翻译:**
太棒了。是 Retool.com，对吧？

---

### [01:02:25] Eeke de Milliano

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:02:26] Lenny

**English:**
Awesome. Thank you again, for being here.

**中文翻译:**
太好了。再次感谢你的到来。

---

### [01:02:28] Eeke de Milliano

**English:**
Thanks, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### [01:02:31] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app.

**中文翻译:**
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。

---

### [01:02:39] Lenny

**English:**
Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all the past episodes or learn more about the show, at LennysPodcast.com. See you in the next episode.

**中文翻译:**
此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。您可以在 LennysPodcast.com 找到所有往期节目或了解更多信息。下期节目再见。