# Elena Verna 2.0 - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Elena Verna on Product-Led Sales.

---

### (00:00:00) Elena Verna

**English:**
The most important thing in product-led sales is that there is a different configuration internally of collaboration that needs to occur. In traditional sales world, marketing creates pipeline for sales. Sales sells product. Product engages with a paid user to drive retention. In the product-led sales, product acquires and activates a customer and product creates pipeline for sales, so relationship is not that there's a go-to-market org with marketing and sales and product just kind of throws features across the fence for them to sell.

The collaboration here is between product and sales, but that means the product has to take on accountability over pipeline. The worst thing that you can do is to say, "I'm going to do product-led growth," or, "I'm going to do product-led sales and I'm going to do it in marketing." Recipe for disaster. You'll be failure mode within six months because product has to take accountability over selling of the product itself.

**中文翻译:**
在产品驱动型销售（Product-Led Sales, PLS）中，最重要的一点是内部协作模式需要发生转变。在传统的销售世界里，市场部为销售部创造线索管线（Pipeline），销售部负责卖产品，产品部则与付费用户互动以驱动留存。但在产品驱动型销售中，产品负责获取和激活客户，并且产品要为销售创造线索管线。因此，这种关系不再是那种“市场和销售组成一个业务部门（GTM org），而产品部只是把功能‘扔过围栏’让他们去卖”的模式。

这里的协作发生在产品和销售之间，但这意味着产品团队必须对销售管线承担责任。你最不该做的事就是说：“我要做产品驱动型增长（PLG）”或者“我要做产品驱动型销售（PLS），而且我要把它放在市场部去做”。那是灾难的药方。六个月内你就会陷入失败模式，因为产品团队必须对产品本身的销售承担起责任。

---

### (00:01:09) Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today, my guest is Elena Verna. If that name sounds familiar, Elena is a return guest and you be the judge, but I think this episode is even better than the first, which is a very high bar because that first episode continues to be one of the most popular of the podcast. Elena has worked at or advised companies like Miro, Amplitude, SurveyMonkey, MongoDB, Netlify, and a dozen others. She's also a longtime instructor and EIR at Reforge where she helped create their experimentation, monetization, growth, leadership, and their soon-to-be released PLG course.

In this conversation, we go incredibly deep into the emerging space of product-led sales. Elena explains what exactly is product-led sales, how it fits together with product-led growth and sales-led growth, who and when you should consider investing product-led sales, how product-led sales changes your approach to sales and marketing, what sorts of data, tooling, and people you need in place to do it well, and what common pitfalls you need to avoid. I've said this before and I'll say it again, Elena is possibly the smartest and most experienced growth person in the world, especially when it comes to B2B, and I never get tired of learning from her. Enjoy this episode with Elena Verna after a short word from our sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Elena Verna。如果这个名字听起来很耳熟，那是因为 Elena 是我们的回头客。你可以自己评判，但我认为这一集甚至比第一集还要精彩——这可是个很高的标准，因为第一集至今仍是本播客最受欢迎的节目之一。Elena 曾在 Miro、Amplitude、SurveyMonkey、MongoDB、Netlify 等十几家公司工作或担任顾问。她还是 Reforge 的长期讲师和入驻企业家（EIR），参与创建了他们的实验、变现、增长、领导力课程，以及即将发布的 PLG 课程。

在这次对话中，我们将深入探讨“产品驱动型销售”这一新兴领域。Elena 解释了究竟什么是产品驱动型销售，它如何与产品驱动型增长（PLG）和销售驱动型增长（SLG）相结合，谁应该以及何时应该考虑投资 PLS，PLS 如何改变你的销售和市场策略，你需要什么样的数据、工具和人才来做好它，以及需要避免哪些常见陷阱。我以前说过，现在还要再说一遍：Elena 可能是世界上最聪明、经验最丰富的增长专家，尤其是在 B2B 领域，我永远听不够她的教诲。在听完赞助商的简短介绍后，请尽情享受与 Elena Verna 的这一集。

---

### (00:02:35) Lenny (Sponsorships)

**English:**
This episode is brought to you by Linear. Let's be honest, the issue tracker isn't very helpful. Why is it that it always seems to be working against you instead of working for you? Why does it feel like such a chore to use? Well, Linear is different. It's incredibly fast, beautifully designed, and it comes with powerful workflows that streamline your entire product development process from issue tracking all the way to managing product roadmaps. Linear is designed for the way modern software teams work.

What users love about Linear are the powerful keyboard shortcuts, efficient GitHub integrations, cycles that actually create progress and built-in project updates that keep everyone in sync. In short, it just works. Linear is the default tool of choice among startups and it powers a wide range of large established companies such as Vercel, Retool, and Cash App. See for yourself why product teams describe using Linear as magical. Visit linear.app/lenny to try Linear for free with your team and get 25% off when you upgrade. That's linear.app/lenny.

This episode is brought to you by Braintrust, where the world's most innovative companies go to find talent fast so that they can innovate faster. Let's be honest, it's a lot of work to build a company, and if you want to stay ahead of the game, you need to be able to hire the right talent quickly and confidently. Braintrust is the first decentralized talent network where you can find, hire, and manage high-quality contractors in engineering, design, and product for a fraction of the cost of agencies. Braintrust charges a flat rate of only 10%, unlike agency fees of up to 70%, so you can make your budget go four times further. Plus, they're the only network that takes 0% of what the talent makes, so they're able to attract and retain the world's best tech talent.

Take it from DoorDash, Airbnb, Plaid, and hundreds of other high-growth startups that have shaved their hiring process from months to weeks at less than a quarter of the cost by hiring through Braintrust's network of 20,000 high-quality vetted candidates ready to work. Whether you're looking to fill in gaps, upscale your staff, or build a team for that dream project that finally got funded, contact Braintrust and you'll matched with three candidates in just 48 hours. Visit usebraintrust.com/lenny or find them in my show notes for today's episode. That's usebraintrust.com/lenny for when you need talent yesterday.

**中文翻译:**
本集节目由 Linear 赞助。老实说，一般的任务追踪工具并不好用。为什么它们总是像在跟你作对，而不是在帮你？为什么用起来感觉像在做苦力？Linear 则不同。它速度极快，设计精美，并配有强大的工作流，能简化从问题追踪到管理产品路线图的整个开发过程。Linear 是为现代软件团队的工作方式而设计的。

用户喜爱 Linear 的原因在于其强大的键盘快捷键、高效的 GitHub 集成、真正能推动进度的“周期（Cycles）”功能，以及能让所有人保持同步的内置项目更新。简而言之，它就是好用。Linear 是初创公司的首选工具，也为 Vercel、Retool 和 Cash App 等大型成熟公司提供动力。亲自去看看为什么产品团队形容使用 Linear 像“魔法”一样。访问 linear.app/lenny 免费试用，升级时可享受 75 折优惠。

本集节目由 Braintrust 赞助。全球最具创新力的公司都在这里快速寻找人才，以便更快地进行创新。建立一家公司很辛苦，如果你想保持领先，就需要快速且自信地聘请到合适的人才。Braintrust 是首个去中心化的人才网络，你可以在这里找到、聘请和管理工程、设计和产品方面的高质量承包商，而成本仅为传统代理机构的一小部分。Braintrust 仅收取 10% 的固定费率，而不像代理机构那样收取高达 70% 的费用，因此你的预算可以发挥四倍的作用。此外，他们是唯一一家不从人才收入中抽成的网络，因此能够吸引并留住全球顶尖的技术人才。

DoorDash、Airbnb、Plaid 以及数百家高增长初创公司都通过 Braintrust 将招聘流程从数月缩短至数周，成本不到四分之一。无论你是想填补空缺、提升员工技能，还是为刚获得资金的梦想项目组建团队，联系 Braintrust，你将在 48 小时内匹配到三位候选人。访问 usebraintrust.com/lenny 了解更多。

---

### (00:05:06) Lenny

**English:**
Elena, welcome back to the podcast.

**中文翻译:**
Elena，欢迎回到播客。

---

### (00:05:09) Elena Verna

**English:**
Thank you for having me back. I thought I would be the first returning guest. I'm a little bit upset that I am been beat by Casey, so you should explain yourself on that one.

**中文翻译:**
谢谢你再次邀请我。我本以为我会是第一个回归的嘉宾。看到被 Casey 抢先了，我还有点小不爽，所以你得解释一下。

---

### (00:05:19) Lenny

**English:**
Okay, here's the explanation. You're the first that we rebooked back and then this one just kind of got pushed a little bit and Casey had a slot earlier, so technically you were the first scheduled return guest.

**中文翻译:**
好，解释如下：你是我们第一个决定再次邀约的人，只是这一集的录制往后推了一点，而 Casey 的档期比较靠前。所以从技术上讲，你是第一个被“预定”的回头客。

---

### (00:05:31) Elena Verna

**English:**
All right, all right. I'll accept that.

**中文翻译:**
行吧，行吧。我接受这个解释。

---

### (00:05:34) Lenny

**English:**
Okay, great. I'm off the hook. I guess I'll just say I am really excited to have you back. Your episode that we did maybe a year ago is still one of the most popular episodes of all time. I still see people tweeting about it and sharing it, and so I am really excited to have you back and have a take two.

**中文翻译:**
太好了，我总算解围了。我想说，我真的很兴奋能请你回来。我们大约一年前做的那一集至今仍是有史以来最受欢迎的节目之一。我经常看到人们在 Twitter 上讨论和分享它，所以我非常期待这次的“第二季”。

---

### (00:05:48) Elena Verna

**English:**
I'm excited to be back. Let's dive in.

**中文翻译:**
我也很高兴回来。我们开始吧。

---

### (00:05:51) Lenny

**English:**
Before we get into the content, when we met last time you were Interim Head of Growth at Amplitude. What are you up to now? What's happened in the past year?

**中文翻译:**
在进入正题之前，上次见面时你还是 Amplitude 的临时增长负责人。你现在在忙什么？过去这一年发生了什么？

---

### (00:06:00) Elena Verna

**English:**
I just wrapped up interim gig at Amplitude in February, so it's just been a couple of months since then. I'm passively exploring if I'm going to take another interim position, but between interim roles I always take about six to eight months of break because interim rolls are very intense because there's so many deliverables that are loaded in in the first year that you're working at the company, so I'm just advising. I have incredible companies that I started advising such as Veed.io and Sanity and Clockwise, and I'm building up my next level of frameworks that I'm going to dive into potentially a new interim position to prototype.

**中文翻译:**
我刚在二月份结束了在 Amplitude 的临时职位，所以才过去两个月。我正在被动地观察是否要接下一个临时职位，但在两个职位之间，我通常会休息六到八个月。因为临时职位非常高压，入职第一年就有大量的交付任务。所以现在我只是做顾问。我开始为一些非常棒的公司提供咨询，比如 Veed.io、Sanity 和 Clockwise。同时，我也在构建我下一阶段的框架，准备在下一个可能的临时职位中进行原型测试。

---

### (00:06:38) Lenny

**English:**
Ooh. If people are listening to this and they're like, "How do I get to work with Elena?", should people reach out to you? Are you booked up? What do you suggest?

**中文翻译:**
噢。如果有人听了节目在想：“我怎么才能和 Elena 合作？”，他们应该联系你吗？你现在排满了吗？你有什么建议？

---

### (00:06:47) Elena Verna

**English:**
I'll never take down an opportunity to have a great conversation and to learn about the business and to see how I can be helpful, but I'm not proactively sourcing clients, but that doesn't mean that I don't have availability to schedule something in the future.

**中文翻译:**
我从不拒绝进行一次深度交流、了解业务并看看我能提供什么帮助的机会。虽然我没有在主动寻找客户，但这并不意味着我未来没有档期。

---

### (00:07:02) Lenny

**English:**
Awesome, so if it's amazing enough, you're open to it?

**中文翻译:**
太棒了，所以如果项目足够吸引人，你是开放的？

---

### (00:07:05) Elena Verna

**English:**
Absolutely, always.

**中文翻译:**
当然，一直如此。

---

### (00:07:06) Lenny

**English:**
Okay, great. I love that. I feel the same way. FOMO. FOMO kicks in. Anyway, as you know, we're going to be devoting this entire podcast to just one topic, which is product-led sales, which is this go-to-market motion that seems to have emerged over the past year maybe a bit longer and just feels like there's this increasing amount of interest and also this increasing amount of confusion around what it is, how to approach it, who it's right for. We're going to spend the next hour diving really deep into product-led sales.

**中文翻译:**
好极了。我也有同感，这就是 FOMO（错失恐惧症）在作祟。言归正传，如你所知，我们这期播客将专门讨论一个话题：产品驱动型销售（Product-Led Sales, PLS）。这种市场进入模式在过去一年左右的时间里兴起，大家对它的兴趣越来越浓，但同时也存在很多困惑——它到底是什么，如何实施，适合谁。接下来的一个小时，我们将深入探讨 PLS。

---

### (00:07:39) Elena Verna

**English:**
Let's go for it.

**中文翻译:**
开始吧。

---

### (00:07:40) Lenny

**English:**
Let's do it. Okay, so let's just start with a bigger picture kind of question of just, how do you define product-led sales? What is product-led sales, especially when it comes to what is it versus product-led growth?

**中文翻译:**
好。让我们从大局出发：你如何定义产品驱动型销售？它到底是什么，特别是它与产品驱动型增长（PLG）的区别在哪里？

---

### (00:07:54) Elena Verna

**English:**
Great question, so let's start with product-led growth. We've talked about it a little bit in our first episode, but let's revisit the topic. Product led growth is all about product's ability to self-serve activate, self-serve engage, and convert that usage to a monetization opportunity. You bring people, you get them to an aha moment into the habit loops, and then you able to extract value back out of them. Extraction of the value can be direct where you're actually capturing revenue from them, or it can be indirect where they're participating in your growth model via virality or user-generated content and bring additional business through the doors.

Let's talk about direct phase to capture that value. There's self-serve monetization, so I'm using product self-serve. I go to the pricing page. I find the plan that best suits me on features that I want to unlock or usage that I want to unlock and I buy it. However, that's not the only way to monetize that usage. You can monetize that usage with sales, too. Why? Self-serve monetization has a cap of about $10,000. That's just how much we're able to process on the credit cards before they start getting flagged and declined by the banks and how much we as a consumers and prosumers are even willing to put on our credit card because not all credit cards have limits of over 10, 20, 30, $40,000.

Self-serve monetization is very much a prosumer use case where an individual is trying to solve the problem on their own. Product-led sales converts the usage that you've generated via self-serve into a sales opportunity and it attaches a salesperson to close a much larger contract, which can be 15, 20, a hundred thousand dollars in order to bring an enterprise-level solution to a company that has already been using it in a self-serve manner.

**中文翻译:**
好问题。我们先从产品驱动型增长（PLG）说起。我们在第一集聊过，现在复习一下。PLG 的核心是产品能够让用户自助激活、自助参与，并将这种使用转化为变现机会。你吸引用户进来，让他们体验到“Aha Moment（惊喜时刻）”，进入习惯循环，然后你就能从中提取价值。这种价值提取可以是直接的（直接获取收入），也可以是间接的（用户通过病毒式传播或生成内容参与你的增长模型，带来更多业务）。

我们来谈谈直接获取价值的阶段。有一种是“自助变现”：我自助使用产品，去定价页面，找到最适合我的功能或使用额度的方案，然后购买。然而，这并不是变现使用量的唯一方式。你也可以通过销售来变现。为什么？因为自助变现有一个大约 1 万美元的上限。这主要是因为信用卡支付的限制，超过这个数额银行就会标记或拒绝交易；而且作为消费者或“专业消费者（Prosumer）”，我们也不太愿意在信用卡上刷掉几万美元。

自助变现主要针对的是个人试图解决自己问题的场景。而产品驱动型销售（PLS）则是将你通过自助服务产生的使用量转化为销售机会，并接入销售人员去签下更大的合同（可能是 1.5 万、2 万甚至 10 万美元），从而为一家已经在自助使用该产品的公司提供企业级解决方案。

---

### (00:09:44) Lenny

**English:**
Amazing. Would you say that product-led growth has always been in a sense product-led sales because sales was involved and theirs has been kind of like way of describing it? Or is this a new trend and way of approaching product-led growth?

**中文翻译:**
太棒了。你会说 PLG 在某种意义上一直就是 PLS 吗？因为销售一直参与其中，这只是换了个说法？还是说这是一种处理 PLG 的新趋势和新方法？

---

### (00:09:59) Elena Verna

**English:**
Product-led growth has actually started more on individual use case—so an individual has a problem. They have a job to be done. They come into the product and they solve it, and that was product-led growth in a nutshell for a lot of the B2B companies. However, if you're going to attach a salesperson, there is nobody in the company that is going to pay 10, 15, $20,000 for one individual to solve their problem. Product-led sales assumes that there's a migration from an individual use case that you acquired an end user with and an escalation into an enterprise-level solution that solves enterprise-level problems. Let me break it down and let me use just, for example, Amplitude as an example.

Amplitude, individual, what is individual wanted with Amplitude? I need data at my fingertips to make better decisions for my product, so I'm going to put an Amplitude SDK into my product and it gives me behavioral data to help me build my pillar better. What is the company-level solution? Well, it's more self-serve ability of the data. It's democratization of data. It's enhanced insights in the more data-driven culture. That's what company's solving for. Individual is not solving for data-driven culture. Individual is just solving for data insights for them. Company's solving for data-driven culture.

In product-led growth, you can just have an individual be very happy with their solution for their job to be done. However, what product-led sales assumes is that there is an escalator to an enterprise-level solution, and enterprise escalator is valuable to attach sales resources to because products fundamentally do a really bad job at communicating enterprise-level value prop. They're very good at showing you as a user what you can do. They've very terrible at showing what organization actually can benefit out of the solution.

Sales can tell that story. Sales can bridge that gap, and then you can increase the perceived value in order to bridge the gap to that $15,000, 20, hundred-thousand dollar contract. I would say self-serve monetization is very much an individual use case versus product-led sales is turning that individual use case and self-serve usage into a sales pipeline with enterprise-level value.

**中文翻译:**
PLG 最初更多是基于个人用例的——个人遇到了问题，有待办任务（Job to be done），他们进入产品并解决它。对很多 B2B 公司来说，这就是 PLG 的核心。但是，如果你要接入销售人员，公司里没人会为了解决一个人的问题而支付 1 万、2 万美元。PLS 假设存在一种迁移：从你获取最终用户的个人用例，升级到解决企业级问题的企业级解决方案。让我以 Amplitude 为例来说明。

对于个人用户，他们用 Amplitude 想干什么？“我需要触手可及的数据来为我的产品做更好的决策，所以我把 Amplitude SDK 放入产品，它给我行为数据，帮我把功能模块做得更好。”那公司层面的解决方案是什么？是数据的自助服务能力，是数据民主化，是在数据驱动文化中获得更深层的洞察。这是公司要解决的问题。个人不关心“数据驱动文化”，个人只关心自己的数据洞察。公司才关心文化。

在 PLG 中，你可能只需要让个人对解决其任务的方案感到满意。但 PLS 假设有一个通往企业级方案的“自动扶梯”。这个扶梯值得投入销售资源，因为产品本身在传达“企业级价值主张”方面做得非常差。产品非常擅长告诉你作为一个用户能做什么，但在展示整个组织能从中获得什么收益方面却很糟糕。

销售可以讲好这个故事。销售可以弥补这个差距，从而提高感知价值，签下 1.5 万到 10 万美元的合同。我会说，自助变现主要是个人用例，而 PLS 是将个人用例和自助使用量转化为具有企业级价值的销售管线。

---

### (00:12:28) Lenny

**English:**
I really like that way of thinking about it. Basically product-led growth has a ceiling. You're only going to get so high in terms of spend. You can only explain things so much to a potential user and then sales comes in and solves a lot of those problems, and product-led sales is essentially this. I think you even have this visualization now that I'm thinking about as a bridge. Right, yeah, this bridge between the two, and so in this world of product-led sales, does sales as a function, outbound sales, continue to exist? One, and then two, is it radically different in this world of product-led sales?

**中文翻译:**
我很喜欢这种思考方式。基本上 PLG 是有天花板的，支出额度只能到那儿。你对潜在用户的解释能力也是有限的，然后销售介入解决这些问题。PLS 本质上就是这个。我想起你甚至有一个视觉化的模型，把它描述为一座“桥梁”。没错，连接两者的桥梁。那么在 PLS 的世界里，销售这个职能——比如主动外呼销售（Outbound Sales）——还会继续存在吗？如果存在，它在 PLS 世界里会有翻天覆地的变化吗？

---

### (00:12:59) Elena Verna

**English:**
Yeah, so to understand how sales should be applied in the situation, you need to understand end user's motivation, ability, and permission. Simple organization, so for example, if the end user is very motivated, they have full sense of ability to solve the problem and they have all of the permission from organization, or maybe not even permission, maybe forgiveness from organization, to go and explore and bring in a new solution. Then, it can be a very much organic motion up that escalator. However, that's not always the case. A lot of times the end users miss permission of solving enterprise-level problems. There's lots of stakeholders, there's a committee that has to make a decision. It impacts departments outside of their purview and maybe they even lack ability to do it. Maybe they can do their little job to be done, but not the entire enterprise-level integration.

In my Amplitude example, yeah, I can drop an SDK in my product area, but how do I convince entire product to adopt Amplitude and put an SDK on every single interaction across the entire app? There is different level problem statements, and this is where product-led sales is either can be a truly organic motion where people raise their hands, they submit sales forms and there's already a need, a desire, an understanding of it, or end user might hit friction points. Product-led sales has to bridge those friction points by either attracting the right decision-makers to the process so they can find an enterprise buyer out there. They can understand who's the champion and what their capabilities and what their permission levels are. They can create a committee for the decision.

There is... They almost slap a bandaid on the problem of people not be able to and not wanting to necessarily resolve the problem on their own. They can be very powerful with that as well as marketing because we cannot forget about marketing where they can educate of how to help people bridge that gap and how to sell things internally.

**中文翻译:**
是的。要理解销售在这种情况下如何应用，你需要理解最终用户的“动机、能力和许可”。举个简单的例子：如果最终用户动力很强，完全有能力解决问题，并且得到了组织的许可（或者甚至不需要许可，先斩后奏），那么这可能是一个非常自然的升级过程。但情况并非总是如此。很多时候，最终用户没有权限去解决企业级问题。这涉及很多利益相关者，需要委员会做决定，会影响到他们管辖范围之外的部门，甚至他们可能缺乏实施能力。也许他们能搞定自己的小任务，但搞不定整个企业级的集成。

在 Amplitude 的例子中，我可以在我的产品区域放一个 SDK，但我如何说服整个产品团队都采用 Amplitude，并在整个 App 的每一次交互中都放上 SDK？这是不同层面的问题陈述。这就是 PLS 发挥作用的地方：它既可以是一种纯自然的运动（人们主动举手、提交销售表单，因为已经有了需求和理解），也可以是在用户遇到阻力时介入。PLS 必须通过吸引正确的决策者进入流程来弥补这些阻力点。销售可以找到企业买家，识别谁是内部拥护者（Champion），了解他们的能力和权限，组建决策委员会。

销售就像是给“人们无法或不想靠自己解决问题”的情况贴上了一块强力胶布。销售在这方面非常强大，市场部也是如此，因为我们不能忘记市场部的作用——他们可以教育用户如何弥补差距，以及如何在公司内部推销这套方案。

---

### (00:15:06) Lenny

**English:**
You mentioned this idea of enterprise-level problems. It might help if you give an example or two of what those might be. Then, also, just what are examples of companies that are doing enterprise or product-led sales well just to kind of give people a mental model as you're talking about some of this stuff?

**中文翻译:**
你提到了“企业级问题”这个概念。如果你能举一两个例子说明这些问题是什么，会很有帮助。另外，有哪些公司在企业级或产品驱动型销售方面做得很好？这能给听众建立一个心理模型。

---

### (00:15:22) Elena Verna

**English:**
Sure, so let's go through a couple of them. Let's go through Miro. Miro is an online whiteboarding platform. What is individual problem that people come to Miro to solve? They have a workshop they need to facilitate. Maybe they need a board to just do brainwriting in and they use Miro for individual jobs to be done. However, what Miro is designed for is a team-level problem. I come in and I bring you in and we collaborate together, so now there's two, three, four people involved, but even that is still on the project level, it's on the team level. Nobody's going to pay a hundred thousand dollars to solve a team-level small problem that is solving. What is the enterprise-level problem? It's increased innovation, it's increased productivity across the entire team because now we have this new outlet in which we can collaborate.

Now, can Miro very clearly show increase in productivity across the organization by using the product? No. Can sales tell the story? Yes. Miro takes you from an individual user to a team step, and then sales bridges the gap to an enterprise. Let's give another example of Figma. In Figma, I come in as a designer and I just need a better way to capture feedback from my stakeholders, a more scalable way to capture it so I can iterate on the perfect design. What is it at the team level? Now there is a team that can collaborate with me more openly. I can capture more feedback from more stakeholders faster and get the project done sooner.

What is it on the enterprise level? Well, on enterprise level, our designs are just better fit the business needs. They have faster turnaround time and our product is performing better. That's an enterprise-level value prop and, again, we're, I think, in the product development space gotten a little bit lazy of actually showcasing that enterprise value in product. We rely on excellence of sales team to tell that story. I do hope that changes, by the way, in the future, that we put more pressure on the products to take it all the way up the escalator so we don't have to be a hundred percent dependent on the sales team going and showcasing that story. The product can really empower that escalator from the starting point till the end on its own.

**中文翻译:**
当然。我们来看几个例子。先看 Miro。Miro 是一个在线白板平台。个人用 Miro 解决什么问题？他们需要主持一个研讨会，或者需要一个白板做头脑风暴。这是个人任务。然而，Miro 的设计初衷是解决团队层面的问题：我进来，把你拉进来，我们一起协作。现在涉及三四个人了，但这仍然是项目层面、团队层面的。没人会为了解决一个团队的小问题支付 10 万美元。那企业级问题是什么？是提升整个组织的创新能力，是提高全公司的生产力，因为我们有了一个全新的协作出口。

那么，Miro 能通过产品界面清晰地展示全公司生产力的提升吗？不能。销售能讲好这个故事吗？能。Miro 把你从个人用户带到团队阶段，然后销售弥补通往企业级的差距。再举个 Figma 的例子。作为设计师，我用 Figma 是为了更好地收集利益相关者的反馈，以便迭代出完美的设计。在团队层面，团队可以更开放地协作，反馈更快，项目完成更早。

在企业层面呢？企业层面的价值是：我们的设计更符合业务需求，周转时间更快，产品表现更好。这就是企业级价值主张。我觉得在产品开发领域，我们变得有点懒惰了，不再在产品中展示这种企业价值，而是依赖优秀的销售团队去讲故事。顺便说一下，我希望未来能有所改变，我们应该给产品施加更多压力，让它自己完成这段“升级”，而不是百分之百依赖销售。产品本身应该有能力从起点到终点驱动这种升级。

---

### (00:17:42) Lenny

**English:**
I want to dig into that for sure. I know that's something you just shared on LinkedIn recently and I thought that was a really interesting topic, but before we get there, let's talk about this bridge a little bit more. People might be listening to this that are maybe a product-led growth company and they may feel like, "Hey, wait, we're already doing this. We have this product-led growth motion, we have a sales team. They figure out who to talk to." What exactly is in that bridge that makes product-led sales so interesting? I imagine it's like helping you identify who to go after, helping people go further and further and escalate it themselves. How do you think about that bridge between product and sales?

**中文翻译:**
我确实想深入探讨这一点。我知道你最近在 LinkedIn 上分享过这个，我觉得很有意思。但在那之前，我们再多聊聊这座“桥梁”。听众里可能有人在 PLG 公司工作，他们会觉得：“等等，我们已经在这么做了。我们有 PLG 模式，也有销售团队，他们知道该找谁谈。”那么，这座桥梁中到底包含什么，让 PLS 变得如此特别？我猜它包括识别目标客户、帮助用户自我升级等。你如何看待产品和销售之间的这座桥梁？

---

### (00:18:15) Elena Verna

**English:**
Let's talk about how product-led growth companies start with product-led sales. It usually starts by an organic demand from a user base. They reach out to them through support channels by just pinging people who work at the company saying, "Hey, I want to purchase this for my entire company." That's an organic pool that you start feeling from product-led growth model into enterprise sales world and, by the way, you should never hire any salespeople until you feel that pool because if nobody's asking to purchase, then you cannot just hire an SDR and make a purchase happen. You need to see those hand-raisers, you need to see those people demanding an enterprise-level adoption. Then, you hire starts hiring salespeople to actually suffice that demand and that's great, and you're starting to do sales and surfacing really addressing organic demand within your product.

That organic demand very quickly dries up if you rely on hand-raisers of your champions. If you rely on having enterprise buyers in your user base that are asking to just sign on the dotted line, then you have a very limited ceiling for your growth because what majority of the usage transforms to be is to have product qualification that there's a meaningful sales conversation that could occur based on the signals within usage that the buyer is missing. 90% of product-led sales is converting the usage into an opportunity by finding a buyer outside, by finding the decision-maker outside. This is where marketing and sales are so crucial in the process. Connecting that decision-maker to the usage and then driving an opportunity through sales funnel all the way to closed one deal.

It's great when you start having sales team and you're surfacing this organic demand. That's beautiful and power to you. Just it doesn't last very long just because end user fundamentally does not equal enterprise buyer and that organic demand ends up plateauing very shortly because you cannot just make enterprise buyers happen from your users.

**中文翻译:**
我们来聊聊 PLG 公司是如何开始做 PLS 的。通常始于用户群的自发需求。他们通过支持渠道联系公司，或者直接找员工说：“嘿，我想为全公司购买这个。”这就是你从 PLG 模型进入企业销售世界的“自发池”。顺便说一下，在你感受到这个池子的拉力之前，千万不要雇佣任何销售人员。因为如果没有人要求购买，你不可能只靠雇个 SDR（销售开发代表）就让交易发生。你需要看到那些“举手的人”，看到那些要求企业级采用的人。然后，你开始雇佣销售来满足这种需求，这很棒，你开始在产品中处理自发需求。

但如果你只依赖这些“拥护者”主动举手，这种自发需求很快就会枯竭。如果你只指望用户群里有企业买家主动要求签字，你的增长天花板会非常低。因为大多数使用情况需要转化为“产品合格（Product Qualification）”——即根据使用信号判断，即使买家还没出现，也可以进行有意义的销售对话。PLS 的 90% 工作是通过在外部寻找买家和决策者，将使用量转化为机会。这就是市场和销售在流程中如此关键的原因：将外部决策者与内部使用情况联系起来，然后通过销售漏斗推动机会，直到成交。

刚开始有销售团队并处理自发需求是很棒的，这很好。但它持续不了多久，因为最终用户从根本上不等于企业买家。自发需求很快就会进入平台期，因为你无法仅凭现有用户就凭空变出企业买家。

---

### (00:20:31) Lenny

**English:**
If a founder is listening to this right now and they're like, "Okay, so I have maybe a product-led growth component, they're self-serve, maybe I have a sales team, maybe I don't," what's a sign that your product is a fit for investing in product-led sales? Essentially every product-led growth-oriented company should be eventually investing in this area. Or is there certain companies that are like, "No, you don't need to worry about it, just stay product-led growth forever or just stay sales-led growth forever?"

**中文翻译:**
如果现在有一位创始人正在听节目，他想：“好吧，我有 PLG 部分，有自助服务，可能有销售团队，也可能没有。”那么，什么样的迹象表明产品适合投资 PLS？是不是基本上每家 PLG 公司最终都应该投资这个领域？还是说有些公司可以永远只做 PLG 或者永远只做销售驱动（SLG）？

---

### (00:20:57) Elena Verna

**English:**
To have product-led sales means you're going upmarket—period. That means you going for contract values that are probably over your sales floor, so the minimum that the sales is willing to engage and close, which is traditionally around $15,000. If you're going for contract values of $15,000, that means you're probably trying to close a hundred, $200,000 contracts as well. Who can handle a hundred, $200,000 contract? It's not going to be a small startup. It's not going to be an SMB. It's probably going to be higher end of more of a mid-market segment, so 200 employees-plus. More likely it's going to be towards the enterprise segment of a thousand employees-plus.

If you are not ready to go upmarket, I would say keep it easy on the product-led sales because sales means quotas. Sales means large contract values. Sales means you are going upmarket whether you like it or not, and some products, they should stay in the prosumer individual space. Maybe they're geared towards contractors or freelancers or squarely towards startups. Those persons are not interested in talking to sales in the first place. They have much lower bearing of how much they're willing to spend, so their price sensitivity is much higher. They prefer to do all self-serve in the first place, so it's really need to be conscious about what that will do to your go-to-market motion because it definitely skews it and pulls it up.

**中文翻译:**
做 PLS 就意味着你要进军高端市场（Upmarket）——就这么简单。这意味着你追求的合同价值可能超过了你的“销售底线”（即销售人员愿意介入并成交的最低金额，传统上约为 1.5 万美元）。如果你追求 1.5 万美元的合同，那你可能也在尝试签下 10 万或 20 万美元的合同。谁能负担得起 10 万、20 万美元的合同？不会是小初创公司，也不会是普通中小企业（SMB）。它可能是中型市场的高端客户（200 人以上），更有可能是企业级客户（1000 人以上）。

如果你还没准备好进军高端市场，我会建议对 PLS 保持谨慎。因为销售意味着指标（Quotas），意味着大额合同，意味着无论你喜不喜欢，你都在往高端走。有些产品就应该留在“专业个人（Prosumer）”领域，比如针对承包商、自由职业者或初创公司的产品。这些人根本没兴趣跟销售谈，他们的预算上限低，价格敏感度高，更倾向于全程自助。所以你必须清醒地认识到 PLS 会对你的市场进入模式产生什么影响，因为它肯定会拉高你的定位。

---

### (00:22:36) Lenny

**English:**
Got it, so what I'm hearing is that if you're starting as a self-serve-oriented product and you're starting to maybe hire for a salesperson, is the approach start approaching it from product-led sales motion versus now we're going to add the sales independent team that's kind of doing their own thing?

**中文翻译:**
明白了。所以我的理解是，如果你从自助服务产品起步，准备雇佣销售人员，那么你应该从 PLS 模式切入，而不是直接加一个各干各的独立销售团队？

---

### (00:22:55) Elena Verna

**English:**
Right, so there's two ways to get to product-led sales. First little wave is that we talked about, I start as product-led growth company. I really started with this individual use case and I'm escalating to a company-level value prop and this is what I need product-led sales for. On the other side, I might start as a top-down sales traditional organization, so I have product that I only sell through sales. Those are usually anchored at larger segments in the first place. In order to build a top-down sales engine, you're most likely going after enterprise segment of a thousand-plus employees or maybe upper mid-market of 500 employees-plus. The reason to go into product-led sales is either your existing top-down motion is not working because customers need to see value before they sign the contract. They want to see that usage and at least the first signs of perceived value before they sign on the dotted line.

Or you're going downmarket and your fixed cost of sale that you have from the traditional sales motion does not scale. It stays fairly constant, yet your contract values are starting to drop as you're doing downmarket, so you want to create a lot more automation in the selling process to remove as many as possible humans out of it. You can approach it from both ways. Adding PLS on top of product-led growth or adding PLS on top of existing sales-led growth. For PLG, you're going upmarket by adding PLS. For SLG or sales-led growth, by adding PLS you're going downmarket.

**中文翻译:**
没错。通往 PLS 有两条路。第一条是我们聊过的：从 PLG 公司起步，从个人用例升级到公司级价值主张，这时你需要 PLS。另一条路是：你可能是一家传统的自上而下（Top-down）销售组织，产品只通过销售卖。这类公司通常一开始就锚定在大客户段。为了建立这种引擎，你通常针对 1000 人以上的企业或 500 人以上的中高端市场。这类公司转向 PLS 的原因有两个：一是现有的自上而下模式失灵了，因为客户在签合同前想先看到价值，他们想在签字前看到实际的使用情况和初步的感知价值。

原因之二是：你正在向低端市场（Downmarket）扩张，而传统销售模式的固定销售成本无法随之缩减。成本保持不变，但合同金额却在下降，所以你想在销售过程中引入更多自动化，尽可能减少人力投入。所以你可以从两个方向切入：在 PLG 之上增加 PLS（进军高端市场），或者在现有的 SLG 之上增加 PLS（进军低端市场）。

---

### (00:24:27) Lenny

**English:**
Awesome, and we're going to talk about how to actually build this infrastructure and what's required, but it reminds me one of the biggest takeaways from our first podcast and something I've quoted many times now, is your bet that every sales-led growth company needs to add a product-led growth element. Otherwise, they'll be disrupted by someone that does. Is that still your perspective?

**中文翻译:**
太棒了。我们待会儿会聊如何构建基础设施。这让我想起我们第一期播客中最大的收获之一，也是我多次引用的一句话：你打赌每家销售驱动型（SLG）公司都需要加入 PLG 元素，否则就会被那些加入 PLG 的对手颠覆。这仍然是你的观点吗？

---

### (00:24:49) Elena Verna

**English:**
Absolutely. Now, I think there's different stages of, what does it mean to add product-led growth elements? I think every sales-led company should be putting pressure on product to assist with the sales process. That does not mean that there is product-led growth, but there is a product assist in the existing sales-led motion that can materialize into product-led growth if you can truly solve for self-serve activation, self-serve engagement, and have product be able to sell itself. The biggest difference here that starts to come in, and that is so apparent in every single company, is that in B2B, unfortunately, we've let go of the products having accountability over monetization model. We've gotten into the spiral of product just builds a product and it throws it over the fence to marketing and sales to sell.

Marketing and sales have done an incredible job over the last couple of decades of coming up with these stories and elaborate playbooks of how to attract enterprise buyers and how to sell them this product. Product literally only obsesses after contract is closed and there's usage that starts materialize after contract close. We've alleviated our product management in B2B from monetization ownership. When a SLG company actually goes into product-assisted tactics or product-led growth, the biggest pain point is actually educating product team on how can you get product to sell itself, which is all about monetization awareness, monetization friction of conversion to get into the paid plan, and then having actual correct value metrics that are understood self-serve by the customer.

I mean, yes, I agree with you. Every single... I agree with myself, so I should say that every single sales-led company should at least add some product-assisted tactics, but I would even take it further that every sales-led company should start educating and putting pressure on the product to own monetization components of the business.

**中文翻译:**
绝对是。现在我认为“加入 PLG 元素”有不同的阶段。我认为每家销售驱动型公司都应该向产品团队施压，让他们协助销售流程。这并不意味着立刻实现 PLG，而是在现有的销售驱动模式中加入“产品辅助（Product Assist）”。如果你能真正解决自助激活、自助参与，并让产品能够自我销售，那么这种辅助最终会演变成 PLG。这里最明显的区别是：在 B2B 领域，不幸的是，我们让产品团队放弃了对变现模型的责任。我们陷入了一个怪圈：产品部只管造产品，然后把它“扔过围栏”给市场和销售去卖。

在过去的几十年里，市场和销售在讲故事、制定复杂的剧本以吸引企业买家方面做得非常出色。而产品团队往往只在合同签署、使用量开始显现后才介入。我们减轻了 B2B 产品管理在变现方面的责任。当一家 SLG 公司真正尝试产品辅助策略或 PLG 时，最大的痛点其实是教育产品团队如何让产品自我销售——这涉及变现意识、降低付费转化阻力，以及建立客户能自助理解的正确价值指标。

所以，是的，我同意你的看法。或者说我同意我自己的看法：每家销售驱动型公司至少应该加入一些产品辅助策略。我甚至想更进一步：每家销售驱动型公司都应该开始教育并向产品团队施压，让他们承担起业务变现部分的责任。

---

### (00:26:50) Lenny

**English:**
Let's pull on that thread a little bit more. What does that actually look like? Does the head of product for that or the head of product or specific group PMs, let's say, have revenue goals and responsible for P&L and things like that? Or what does that generally look like when they start to own revenue?

**中文翻译:**
让我们顺着这个话题再深入一点。这具体看起来是什么样的？是产品负责人，还是特定的组 PM（Group PM），会有收入目标并负责损益（P&L）之类的吗？当他们开始负责收入时，通常是什么情况？

---

### (00:27:08) Elena Verna

**English:**
There's two ways that you can own revenue. Revenue stream one will be your self-serve revenue, and if there's self-serve revenue, that means product is selling literally itself, so yes, there has to be somebody in product that has self-serve revenue target.

Now, a lot of times it doesn't fall in the core product managers. A lot of times it falls on the growth team, and that's because core product management is really focused on feature deliverability and just that incremental expansion of the core use case, and growth product management owns the product distribution strategy. Then, the PLG case, it would be a true self-serve monetization model. Now, when it comes to PLS, you don't own revenue target in my opinion, but what you do own is the pipeline that was created by product that you have a handshake with sales team over.

What that materializes in is product qualified accounts, and it's actually a product threshold of engagement that differs from activation and it differs from core engagement. It's what volume, velocity, feature breadth, or behavioral signals that account is throwing that says, "Hey, right now is the time to engage with sales." That is the bridge to monetization, that product team should own as a... even on the core team in order to drive a healthy, predictable, and sustainable pipeline to sales.

**中文翻译:**
承担收入责任有两种方式。第一种是“自助服务收入”。如果有自助收入，意味着产品确实在自我销售，那么产品团队中必须有人背负自助收入目标。

通常这不会落在核心产品经理（Core PM）身上，而是落在增长团队身上。因为核心产品管理专注于功能交付和核心用例的增量扩展，而增长产品管理负责产品分发策略。在 PLG 案例中，这就是真正的自助变现模型。而在 PLS（产品驱动型销售）中，我认为你不需要背负最终的收入目标，但你需要负责由产品创造的、并与销售团队达成共识的“销售管线（Pipeline）”。

这具体体现为“产品合格账户（Product Qualified Accounts, PQA）”。它实际上是一个产品参与度的阈值，不同于激活，也不同于核心参与度。它是指账户表现出的使用量、速度、功能广度或行为信号，这些信号在说：“嘿，现在是销售介入的最佳时机。”这就是通往变现的桥梁，产品团队（甚至是核心团队）应该负责这一点，以便为销售提供健康、可预测且可持续的管线。

---

### (00:28:38) Lenny

**English:**
Okay, so this is a really important topic. There's this concept you just described, product qualified account. It might be a good time to define a couple other acronyms and kind of compare them. THere's PQA, there's PQL, product-qualified lead. There's marketing-qualified lead. Can you just maybe describe the suite of acronyms? Then, I want to follow up on the PQA because that seems really important.

**中文翻译:**
好，这是一个非常重要的话题。你刚才描述了 PQA（产品合格账户）的概念。现在可能是定义并比较其他几个缩写的好时机。有 PQA，有 PQL（产品合格线索），还有 MQL（营销合格线索）。你能描述一下这一系列缩写吗？然后我想跟进一下 PQA，因为这看起来非常关键。

---

### (00:28:59) Elena Verna

**English:**
I'll start with PQA just because we just breezed over it. PQA is product-qualified account. It's on account level, it's aggregation of multiple users that are using the account. It might be on the overall logo level, so let's say you've attracted a company, so you qualify PQA across the entire company usage, or it might be on a specific team or workspace level depending on what is the better predictor for you and who the sales team is going to be engaging with. Product qualification is very much product metrics. It's the volume of use, it's the velocity change. For example, yesterday I've been adding one user per day and then today I've added 15 users to account. That's a velocity change that you need to pay attention to. Or there is a feature usage that can be highly correlative to enterprise interest. That product should be driving towards every single account reaching in order to qualify them for sales conversation.

Now, within the PQA, there may or may not be PQL, so PQL is a product-qualified lead. Lead assumes there is a person in the account that I can go and sell to. Now, leads are those buyers. They're those decision-makers in the account, and if you have a smaller segment, so for example you had more in small businesses or lower end of mid-market segment, you may very have PQLs in there because user is maybe equals buyer. User can make those buyer decisions. However, the more you move up the market, the more end user is many steps separated from the buyer, so you might have very healthy usage and you might have a PQA that is off the charts, but you don't have a PQL in it.

If you just stick your sales against that account, you're going to have a very terrible situation and very terrible user journey where users are like, "Why is sales talking to me? I have no decision-making power in my organization. I love the product, but please leave me alone." This is where you get a bunch of cold outbound, and I put big quotations on outbound emails that are just not getting returned. You need to very clearly understand who's your buying persona and, are they in your user base? If they are, you have a PQL. Pass them, go for it, but if they're not, go find it out there. This is where MQL concept really comes into play because then marketing has to still qualify a lead to bring it and connect it to PQA. PQA can have a PQL as a user already in the user base, or you might need an MQL with marketing or sales, bringing their lead over and connecting them with the usage.

**中文翻译:**
我先从 PQA 开始，因为刚才提到了。PQA 是“产品合格账户”。它是账户层面的，是使用该账户的多个用户的聚合。它可能是公司层面的（比如你吸引了一家公司，你根据全公司的使用情况来评定 PQA），也可能是特定团队或工作区层面的，取决于哪个指标预测效果更好，以及销售团队要跟谁对接。产品合格评定主要看产品指标：使用量、速度变化。例如，昨天每天增加 1 个用户，今天突然增加了 15 个，这就是需要关注的速度变化。或者某些功能的使用与企业级兴趣高度相关。产品团队应该推动每个账户达到这些指标，从而获得销售对话的资格。

在 PQA 内部，可能存在也可能不存在 PQL（产品合格线索）。“线索（Lead）”假设账户里有一个我可以去推销的人。线索就是那些买家，那些决策者。如果你针对的是小型企业或中型市场低端客户，你可能有很多 PQL，因为用户往往就是买家，用户可以做购买决定。然而，你越往高端市场走，最终用户与买家之间的距离就越远。你可能拥有非常健康的使用量，PQA 指标爆表，但里面没有 PQL（即没有决策者在用产品）。

如果你直接让销售去对接那个账户，会造成非常糟糕的用户体验。用户会想：“销售为什么要找我？我在公司没有决策权。我喜欢这个产品，但请别烦我。”这就是为什么会出现一堆石沉大海的“冷外呼（Cold Outbound）”邮件。你需要非常清楚你的买家画像是谁，以及他们是否在你的用户群中。如果在，你就有 PQL，直接上吧。如果不在，去外面找。这就是 MQL（营销合格线索）发挥作用的地方：市场部需要识别一个线索，将其带进来并与现有的 PQA（产品使用情况）联系起来。PQA 里的用户可能是 PQL，也可能需要市场或销售从外部带入一个 MQL 并将其与使用数据挂钩。

---

### (00:31:43) Lenny

**English:**
Amazing, so we're going to share a link. You have this awesome visual that shows kind of like the funnel of PQAs and PQLs funneling into sales along with marketing qualified leads. Basically there's a kind of instead of one path to sales, knowing who to talk to, now there's two. Product is funneling you people that are qualified, and then marketing following you people that are qualified.

**中文翻译:**
太棒了，我们会分享一个链接。你有一个很棒的视觉图，展示了 PQA 和 PQL 如何与 MQL 一起汇入销售漏斗。基本上，现在不再只有一条通往销售、寻找谈话对象的路径，而是有两条：产品部为你输送合格的人选，市场部也为你输送合格的人选。

---

### (00:32:06) Elena Verna

**English:**
There is a third path. There might be a marketing funneling people that have no usage whatsoever and that is a true top-down lead, so you have three buckets of lead attribution that is coming in. I have usage and one of the users is my lead. I have usage. I have no lead in the account. Marketing is bringing me the lead, but I have to leverage that usage against that lead or have a lead coming through, there is no usage. I have to sell the entire thing still to them, so there's no context that I can use of existing usage. Those three channels are super important to identify. They all have very different conversion rates. They all have different playbooks of how you close them and, honestly, they require often different sales team to go after them because it's a very different sales enablement.

**中文翻译:**
其实还有第三条路径。市场部可能会输送完全没有使用过产品的人，这是真正的“自上而下”线索。所以你有三类线索归因：1. 有使用量，且其中一个用户就是我的线索；2. 有使用量，但账户里没有线索，市场部把线索找来，我需要利用现有的使用数据去说服这个线索；3. 有线索进来，但完全没有使用量，我必须从零开始向他们推销，没有任何现成的使用背景可以利用。识别这三个渠道至关重要。它们的转化率完全不同，成交剧本也不同，坦白说，通常需要不同的销售团队去跟进，因为所需的销售赋能（Sales Enablement）完全不同。

---

### (00:32:51) Lenny

**English:**
You remind me of... You have so many hilarious memes that you share on LinkedIn. By the way, everyone listening should go follow Elena on LinkedIn and subscribe to our newsletter because it's hilarious and also informative. It's a magical combination. One of my favorite memes of yours is The Shining one that we just kind of touched on where someone's just using a product for five minutes and then, "Hey, do you want to," a sales guy just reaches out with the ax, "Hey, do you want to chat?"

**中文翻译:**
你让我想起……你在 LinkedIn 上分享了好多搞笑的梗图（Memes）。顺便说一下，听众们都应该去 LinkedIn 关注 Elena 并订阅她的通讯，因为既搞笑又涨知识，简直是神仙组合。我最喜欢的梗图之一是关于《闪灵》的，我们刚才也提到了：有人刚用了五分钟产品，销售员就拿着斧头劈门进来问：“嘿，想聊聊吗？”

---

### (00:33:18) Elena Verna

**English:**
That actually... It's painfully true. That's one of my most highly engaged memes that I've put out there. I have also one of the urinals where the man using the urinal and then like one comes over. A salesperson comes over. "Would you like to chat about our enterprise plan?" it's like 10 urinals and he's right next to yours.

**中文翻译:**
那张图……其实真实得让人心痛。那是我互动率最高的梗图之一。我还有一张关于小便池的：一个人正在用小便池，旁边明明有 10 个空位，销售员偏偏凑到他紧挨着的那个位子问：“想聊聊我们的企业版方案吗？”

---

### (00:33:36) Elena Verna

**English:**
Yeah, exactly, so the piece here that a lot of companies miss, unfortunately, is that they jam product-led sales into a traditional top-down sales playbook. Now, what does that mean? In traditional top-down sales book, an MQL that you have or a lead that you gather already is in consideration cycles for your enterprise-level offering. However, in product-led sales, a new user that signs up, they know we're close to enterprise-level consideration. They're just trying to complete an individual job to be done. They're not solving a problem for their company. If you can imagine, it is like a very large funnel. You start with just users looking for problem solve. Then, you transition to awareness, consideration, and intent channels for team level problem. Then, you escalate for awareness, consideration, and intent channels for enterprise-level problem.

Top-down sales process goes after the bottom of that funnel where there's already an intent to solve company-level problem versus at the very top is where product-led growth starts on individual-level problem. It's a different timeline. If you go after individual user that just signs up for the account and you reach out to them 10 minutes later after sign-up asking, "What's your budget and are you ready to buy?", it's a complete mismatch of where they are in their consideration journey. You cannot consider a new product sign-up an MQL in the traditional sense. They're just not there yet. They have a fraction of the enterprise problem that they're solving and they're not ready to buy.

**中文翻译:**
没错。不幸的是，很多公司错过的一点是：他们把 PLS 硬塞进传统的自上而下销售剧本里。这意味着什么？在传统剧本中，一个 MQL 或你获取的线索已经处于对企业级方案的“考虑周期”中了。但在 PLS 中，一个刚注册的新用户离“企业级考虑”还差得远呢。他们只是想完成一个个人任务，并不是在为公司解决问题。你可以想象这是一个巨大的漏斗：最顶端是寻找问题解决方案的个人用户；然后过渡到团队层面问题的意识、考虑和意向阶段；最后才升级到企业级问题的意识、考虑和意向阶段。

自上而下的销售流程针对的是漏斗底部——即已经有了解决公司层面问题的意向；而 PLG 从最顶端的个人问题开始。这是不同的时间线。如果你在个人用户注册 10 分钟后就联系他们问：“你的预算是多少？准备好购买了吗？”，这与他们在考虑旅程中所处的位置完全错位。你不能按传统意义把新注册用户当成 MQL。他们还没到那一步，他们解决的只是企业问题的一小部分，还没准备好购买。

---

### (00:35:26) Lenny

**English:**
That's especially annoying because there's so many SaaS products now and everyone is coming for you, especially if you're at an awesome company that they're trying to sell.

**中文翻译:**
这确实特别烦人，因为现在 SaaS 产品太多了，每个人都在盯着你，尤其是如果你在一家他们梦寐以求的大公司工作。

---

### (00:35:35) Elena Verna

**English:**
Yeah, I mean anytime I even started... I remember I started at Amplitude when I started a year ago, it's like my inbox was just filled with like, "Now you're doing this, now you're doing this. Buy, buy, buy." I mean, I don't know, I can't even notice anything in that outbound unless somebody reaches out to me with something authentic that is already usage-based, it's ignore.

**中文翻译:**
是的。我记得一年前刚入职 Amplitude 时，我的收件箱瞬间被塞满了：“既然你现在在做这个，买买买吧。”除非有人能基于我已有的使用情况，发来一些真实、有诚意的内容，否则我根本不会理会那些外呼邮件，全部忽略。

---

### (00:35:59) Lenny

**English:**
It's going to get worse with GPT-oriented cold outbound emails. Oh my God.

**中文翻译:**
有了 GPT 生成的冷外呼邮件，情况只会变得更糟。天呐。

---

### (00:35:59) Elena Verna

**English:**
Absolutely.

**中文翻译:**
绝对的。

---

### (00:36:05) Lenny (Sponsorships)

**English:**
This episode is brought to you by rows.com. The world runs on spreadsheets. You probably have a tab open with a spreadsheet right now, but the spreadsheet product you're using today was designed decades ago and it shows. They live in silos away from your business data. They weren't made to be used on a phone, and if you want to do even the simplest automation, you have to figure out complex scripts that are a nightmare to maintain. Rows is different. It combines a modern spreadsheet editor, data integrations with APIs and your business tools, and a slick sharing experience that turns any spreadsheet into a beautiful interactive website that you'll be proud to share.

**中文翻译:**
本集节目由 rows.com 赞助。世界运行在电子表格之上。你现在可能就开着一个表格标签页。但你今天使用的表格产品是几十年前设计的，弊端显而易见：它们与业务数据隔绝，不适合手机使用，即使是最简单的自动化也需要复杂的脚本。Rows 则不同。它结合了现代编辑器、API 集成和流畅的分享体验，能将任何表格变成精美的互动网站。

---

### (00:37:17) Lenny

**English:**
Okay, so let's shift to actually, how do you actually do this? How do you actually build a system of product-led sales? I feel like there's maybe three buckets. There's, what data do you need? What infrastructure systems do you need in place? Then, what are the people you need in place and how do you resource it? Maybe let's start with the data. What sort of data do you need in order to do this well?

**中文翻译:**
好，让我们转向实操：具体怎么做？如何构建一个 PLS 系统？我觉得可以分为三个维度：1. 需要什么数据？2. 需要什么基础设施和系统？3. 需要什么样的人才以及如何配置资源？我们先从数据开始。为了做好 PLS，你需要什么样的数据？

---

### (00:37:36) Elena Verna

**English:**
There's different levels of scale on how you should be attacking this problem. First of all, it starts with just top-down intuition. What are the signals that you're seeing around the accounts that are highly correlative to sales being very excited about this hand-raiser or about the sales form submit out of the usage? You just start with that. It's as simple as, how many of others are exhibiting those signals? When you have very low lead volume still, you don't want to get too complicated with it at the beginning. You want to be very transparent. You want to just understand what sales are seeing, what they get excited about, and feed them as many accounts that fit that model.

The one thing is not to do is just to start sending every single user to sales because that's the fastest way for sales to say, "This product channel is garbage and I don't ever want to see a lead from it again." They have such close rates and their quota, their salary depends on their ability to close that they just start disregarding this as a meaningful channel.

Now, the second escalation to it is, okay, now you will know intuition, but now let's actually look at the reality of who is hand-raising in the product. You look at the signal of who looks like a hand-raiser, smells like a hand-raiser, acts like a hand-raiser, but is not hand-raising. That's a maybe very simple regression model. It might be just a simple histogram analysis that you do of what differentiates people that are hand-raising from people that are not hand-raising and who else fits into criteria and looks like a hand-raiser based on those differences.

That should be your first PQA model. It should be very simple. It should just be if you can run a linear regression against some of the top coefficient that you notice so you know which has the biggest weight to predictability and you go with that. The main piece here is to involve sales very early on so you're partnering with them. You are not just dumping it on them and that you have a very strong feedback cycles from sales or whether what you've identified is correct or not correct because PQA definitions should not be static. They're constantly evolving. Just because it's right right now, that doesn't mean it's going to be right next quarter, so you have to have a lot of rituals with sales team to gather that feedback.

**中文翻译:**
解决这个问题有不同的规模级别。首先，从“自上而下的直觉”开始。你观察到哪些账户信号会让销售感到兴奋？比如哪些使用行为会导致用户主动举手或提交销售表单？你就从这些开始。简单来说，就是看还有多少人表现出同样的信号。当线索量还很小时，不要搞得太复杂。你要保持透明，了解销售看到了什么、对什么感兴趣，然后把符合该模型的账户推给他们。

绝对不能做的一件事是：把每一个用户都推给销售。这是让销售认为“产品渠道全是垃圾，我再也不想看到这里的线索”的最快方法。销售有成交率要求，他们的工资取决于成交能力，一旦质量太差，他们就会完全忽视这个渠道。

第二阶段是：在直觉的基础上，观察产品中真正“举手”的人。看看那些“看起来像、闻起来像、行动起来像”举手者，但实际上还没举手的人。这可以是一个非常简单的回归模型，或者简单的直方图分析，看看举手者和非举手者的区别在哪里，还有谁符合这些特征。

这就是你的第一个 PQA 模型。它应该非常简单，比如针对你注意到的几个主要系数运行线性回归，找出预测权重最大的指标。关键是要尽早让销售参与进来，与他们合作，而不是直接把东西扔给他们。你需要与销售建立强大的反馈循环，确认你识别的信号是否准确。因为 PQA 的定义不是静态的，它在不断进化。现在对的，下个季度可能就不对了，所以你需要和销售团队建立定期的沟通机制（Rituals）来收集反馈。

---

### (00:40:03) Lenny

**English:**
One thing I'll mention is Amplitude and Mixpanel both have a regression tool that help you identify correlations and causal kind of connections between metrics, so maybe shout-out there. I think it's called Compass and then Mixpanel's I think is called Signal.

**中文翻译:**
我想提一下，Amplitude 和 Mixpanel 都有回归分析工具，可以帮你识别指标之间的相关性和因果联系。Amplitude 的叫 Compass，Mixpanel 的好像叫 Signal。

---

### (00:41:04) Elena Verna

**English:**
I don't know if I would start there right from the beginning unless you actually understand the data because buying a platform will not bridge the gap for you understanding what actually matters in your data. Buying a platform or using a third-party solution will help you scale your efforts once you hit the first first, let's say, data sales fit that you can then scale and disincrease distribution of.

**中文翻译:**
我不确定是否应该一开始就用这些工具，除非你已经真正理解了数据。因为买一个平台并不能帮你理解数据中真正重要的东西。一旦你达到了所谓的“数据-销售契合（Data-Sales Fit）”，购买平台或使用第三方方案才能帮你扩大规模。

---

### (00:41:30) Lenny

**English:**
Data sales fit. Wow, that's a new term. There we go. I have not heard that before. Data sales fit. I love it, so you're saying basically start manually to make sure you fully understand what's going on?

**中文翻译:**
“数据-销售契合”。哇，这是个新词。我以前没听过，太棒了。所以你的意思是，基本上先手动操作，确保完全理解发生了什么？

---

### (00:41:41) Elena Verna

**English:**
That's my take. Yeah. I just... I have a hard time scaling something that I don't fully understand because data can tell you lies and you can just fit any story that you want into data. I need to really understand it and how it fits and what you are observing and that it makes sense before you go and start using automation on it.

**中文翻译:**
这是我的观点。是的。我很难去规模化一个我不完全理解的东西，因为数据会撒谎，你可以把任何故事强加给数据。在开始自动化之前，我需要真正理解它，理解它如何契合，以及你观察到的现象是否合乎逻辑。

---

### (00:42:00) Lenny

**English:**
Cool. Okay, and then just one last question on what you were just talking about, which is finding correlations and causal relationships between usage and users and understanding who to send to sales. What are some common metrics and attributes that you've found that are indicative of they should go to sales?

**中文翻译:**
酷。关于你刚才说的寻找使用情况与用户之间的相关性和因果关系，以及确定该把谁送给销售，最后一个问题：你发现哪些常见的指标和属性预示着他们应该被交给销售？

---

### (00:42:17) Elena Verna

**English:**
One of the most important things is to create network effects within the company, within a team, which each additional team member added to an account benefits from everybody else. This does not mean you have to have platform network effects. You're not trying to be LinkedIn. You're not trying to be Instagram. Those are platform network effects. What you are trying to create is the value of each additional user into account. What that means, I'm going to go through slight deviation here is that there should not be only pulling mechanism where I pull you into my account. There also should be pushing mechanism. Any new sign-up that happens from the company that already has an account in my system should be presented with an option to join that account, not just create a brand new account.

What you don't want to create is hundreds of rogue individual accounts that don't know about each other. We as humans, we are creatures of community, we're creatures of we like to be surrounded by people, to be validated by people, and at least you want to create that herd mentality inside of the company and push and pull people into the account. One of the biggest PQAs is number of users in the company using your product. By the way, the magic number is usually seven. The more time you have seven or more users in the company and there's like some weird parallel here to seven friends at Facebook and seven collections at LinkedIn, but seven I've seen very often as a check mark. "Hey, there's enough value here distributed across multiple people inside the company that there might be an enterprise conversation to be had."

The second-most important is usually some sort of volume threshold. For example, for Amplitude, it's number of events that you're sending through, which means that you are really starting to tackle your entire application with analytics as opposed to just a small portion. Or with Miro, it was number of boards that you have in the account. With Figma, I think it's number of revisions that you have on any given design. The last one I would say is velocity. Velocity is the trickiest one just because we don't have a very easy way to measure velocity in our transactional data, but it's actually one of the most powerful one that triggers the right timing for the involvement because the change in velocity either number of users being added or events being sent or storage that is being utilized is usually a fantastic predictor.

**中文翻译:**
最重要的事情之一是在公司内部、团队内部创造“网络效应”，即账户中每增加一个成员，其他人都能从中受益。这并不意味着你必须拥有平台级的网络效应（你不是在做 LinkedIn 或 Instagram）。你要创造的是每个新增用户对账户产生的价值。这意味着，不应该只有“拉取”机制（我把你拉进我的账户），还应该有“推送”机制：任何来自已有账户公司的后续注册者，都应该被提示加入现有账户，而不是创建一个全新的孤立账户。

你最不想看到的是几百个互相不知道对方存在的“流浪”个人账户。人类是社群动物，喜欢被人群包围，喜欢被他人认可。你至少要在公司内部创造这种“从众效应”，把人们推拉进同一个账户。最重要的 PQA 指标之一就是公司内使用产品的用户数。顺便说一下，那个神奇的数字通常是“7”。一旦公司里有 7 个或更多用户，这就像 Facebook 的“7 个好友”或 LinkedIn 的“7 个联系人”一样，是一个关键节点。这标志着价值已经在公司多人之间分布，可以进行企业级对话了。

第二重要的通常是某种“量”的阈值。例如 Amplitude 是发送的事件数（意味着你开始对整个 App 进行分析，而不仅仅是一小部分）；Miro 是账户里的白板数；Figma 可能是某个设计的修订次数。最后一个是“速度（Velocity）”。速度是最难测量的，因为交易数据中很难直接体现，但它却是触发介入时机最强大的指标之一。无论是新增用户速度、事件发送速度还是存储空间消耗速度的变化，通常都是极佳的预测指标。

---

### (00:45:04) Lenny

**English:**
Amazing. Okay, so kind of like the simplest model to tell you there's a peak-y way is number of users usage and velocity.

**中文翻译:**
太棒了。所以最简单的 PQA 模型就是：用户数、使用量和速度。

---

### (00:45:05) Elena Verna

**English:**
Yep—and users, by the way, can be either usage of velocity metric, too. It's just like if you're going to do anything, just look at whichever accounts have most users. It's like an 80-20 rule. For 20% of the efforts, you're probably going to get 80% of the value.

**中文翻译:**
没错。顺便说一下，用户数本身也可以作为使用量或速度指标。如果你只想做一件事，那就看哪些账户的用户数最多。这符合 80/20 原则：投入 20% 的精力，就能获得 80% 的价值。

---

### (00:45:25) Elena Verna

**English:**
I would say that it's very important to identify behavioral signals as well, and I'll give an example. At Miro, we had a very strong behavioral signal that if there is an admin switch in the account, some sort of evaluation is happening. Admin transfer, new admin being assigned, that should be ding, ding, ding, all of the bells are ringing that you should maybe reach out to that person and see what's going on. The other one that is fascinating is your terms of use pages, your privacy and policy. Nobody cares about it unless they're considering enterprise deal. If you see anybody from account land on your terms of use pages, reach out to that person. More likely than not, you have a buyer on the hook and you can assist them in increasing their perceived value.

**中文翻译:**
我还想说，识别行为信号也非常重要。举个例子：在 Miro，我们发现一个非常强的信号——如果账户发生了管理员变更（Admin Switch），通常意味着某种评估正在进行。管理员转让、新管理员任命，这些都应该是“叮叮叮”的警报声，提醒你应该联系那个人看看发生了什么。另一个很有趣的信号是你的“服务条款”或“隐私政策”页面。除非是在考虑企业级交易，否则没人关心这些。如果你看到某个账户的人浏览了服务条款页面，赶紧联系他。很有可能你已经钓到了一条大鱼（买家），你可以协助他们提升感知价值。

---

### (00:46:26) Elena Verna

**English:**
... signals are, by the way, universal. We looked at it at MongoDB, it was very much true, so these things of when you... What in product constitutes evaluation process? What are the enterprise buyers are looking for? I wouldn't say, by the way, watching a webinar or landing on an enterprise landing page is a good behavioral signal because it might be annoying that I just like on accident landed on a landing page and now I'm being spammed by outbound SDR sequence. More meaningful actions that are deeper with an engagement user journey are incredible predictors.

**中文翻译:**
顺便说一下，这些信号是通用的。我们在 MongoDB 也观察到了同样的情况。产品中的哪些行为构成了评估过程？企业买家在寻找什么？我不认为观看网络研讨会或访问企业落地页是好的行为信号，因为如果我只是不小心点进去，结果就被 SDR 的外呼邮件轰炸，那会很烦人。用户旅程中更深层次、更有意义的动作才是不可思议的预测指标。

---

### (00:47:15) Elena Verna

**English:**
I think you have to look at the channel effectiveness. You have only so many channels to communicate with a customer. Email is obvious. You can communicate with them in app. You can have some sort of chatbot. Maybe you can deploy some sort of paid marketing, maybe social or retargeting display ads, but those are very expensive to utilize. Stepping back and thinking when it's the right time to reach out. How can I grab their attention? If you highly saturated the channel that is your primary for reaching out to the user, they're not going to react even if it's more of a right time for them to react.

**中文翻译:**
我认为你必须关注渠道的有效性。你与客户沟通的渠道有限：邮件、应用内消息、聊天机器人、付费营销（社交媒体或重定向广告）。退一步想，什么时候是联系的最佳时机？我该如何吸引他们的注意？如果你过度消耗了主要的沟通渠道，即使时机对了，用户也不会有反应了。

---

### (00:49:07) Lenny

**English:**
Amazing. Okay, so let's continue down this track of what it takes to implement a product-led sales motion. Just talked about the data component. What about just systems and infrastructure and tooling? What do you recommend there as a start?

**中文翻译:**
太棒了。让我们继续探讨实施 PLS 模式所需的条件。刚才聊了数据部分，那么系统、基础设施和工具呢？你建议从哪里开始？

---

### (00:49:23) Elena Verna

**English:**
I approach the subject always as an evolution, not a revolution, so start with your existing systems as much as possible. I would say the biggest mistakes to avoid if your sales team is very heavily embedded into Salesforce, don't try to have them switch to a different solution. It's just not going to work. You need to try to figure out how to embed what you need the data into Salesforce, not get them to use some other third-party tool. Then, I wouldn't jump into any big commitments until I really prove out viability of product-led sales motion before automating any of it. I'm more of kind of Wizard of Oz it as fast as much as possible to get the initial traction so then we can validate that there is investment to be had in scaling it and there's a business value in it.

**中文翻译:**
我对待这个话题的态度始终是“演变”而非“革命”。所以，尽可能从现有系统开始。要避免的最大错误是：如果你的销售团队已经深度依赖 Salesforce，千万别让他们切换到另一个方案。那行不通。你需要想办法把数据嵌入到 Salesforce 中，而不是让他们去用别的第三方工具。此外，在真正证明 PLS 模式的可行性之前，我不会做任何大的投入或自动化。我更倾向于尽可能快地用“绿野仙踪”模式（Wizard of Oz，即前端看起来是自动的，后端其实是人工操作）来获得初步牵引力，从而验证其商业价值，然后再决定是否投资规模化。

---

### (00:51:09) Elena Verna

**English:**
For PLS, the people that you need is product managers that will be able to get account to PQA stage. You will need salespeople that will understand which usage triggered PQA and how to apply that information to find a buyer and to enable a buyer to convert them to an opportunity. You need marketing to educate both the end user or enterprise buyer on why the value of this enterprise solution is going to make sense to you, and you need analytics team. You need a data analyst that will continuously dig in the data to find correlative signals that you can test causation in. Those are the four people that you need, product, analytics, marketing, sale. I should say engineering, too, obviously, but I'm kind of bundling them together with product.

**中文翻译:**
对于 PLS，你需要的人才包括：能够将账户推向 PQA 阶段的产品经理；能够理解是哪些使用行为触发了 PQA，并利用这些信息找到买家、转化机会的销售人员；需要市场部来教育最终用户或企业买家，让他们明白企业级方案的价值；还需要分析团队，需要一名数据分析师不断挖掘数据，寻找相关信号并测试因果关系。这就是你需要的四类人：产品、分析、市场、销售。当然还有工程团队，但我通常把他们和产品归在一起。

---

### (00:53:01) Elena Verna

**English:**
No, just have somebody support to do it. Have somebody on finance do it. You do it. I've been on chat myself plenty of times trying to close the deals just to understand what's the sales process for the customers looks like. Then, you can figure out who to actually hire and who to actually scale, but for PLS that starts in PLG, you actually just start with more of blend of an SZR and AE together because you don't need two separations. The same person can both outbound to a customer and close them at the same time, and then you can go into specialization of the role. Start small, start nimble, prove it out, scale along the way, but have marketing and analytics support you the entire journey.

**中文翻译:**
不，先找人兼职支持一下。让财务的人做，或者你自己做。我自己就曾多次亲自上线聊天去谈单子，只是为了理解客户眼中的销售流程是什么样的。然后你才能弄清楚该雇谁、该扩展谁。对于从 PLG 起步的 PLS，你其实可以先找一个兼具 SDR（销售开发）和 AE（客户经理）职责的人，因为初期不需要分得那么细。同一个人可以既负责外呼又负责成交，之后再进行职能细分。从小规模、灵活开始，边证明边扩展，但要确保市场和分析团队全程提供支持。

---

### (00:55:19) Elena Verna

**English:**
The most important thing in product-led sales is that there is a different configuration internally of collaboration that needs to occur. In traditional sales world, marketing creates pipeline for sales. Sales sells product. Product engages with a paid user to drive retention. In the product-led sales, product acquires and activates a customer and product creates pipeline for sales. Relationship is not that there's a go-to-market org with marketing and sales, and product just kind of throws features across the fence for them to sell.

The collaboration here is between product and sales, but that means the product has to take on accountability over pipeline. The worst thing that you can do is to say, "I'm going to do product-led growth," or, "I'm going to do product-led sales and I'm going to do it in marketing." Recipe for disaster. You'll be failure mode within six months because product has to take accountability over selling of the product itself.

**中文翻译:**
PLS 中最重要的一点是内部协作配置的改变。在传统销售世界，市场部为销售部创造管线，销售部卖产品，产品部负责付费用户的留存。在 PLS 中，产品负责获取和激活客户，并为销售创造管线。这种关系不再是“业务部门（市场+销售）在前面，产品部在后面扔功能”。

这里的协作是产品与销售之间的，这意味着产品必须对管线承担责任。最糟糕的做法是说：“我要做 PLG 或 PLS，但我把它放在市场部。”那是灾难，六个月内必败，因为产品团队必须对产品本身的销售负责。

---

### (00:57:36) Lenny

**English:**
When you say accountable, what does that actually look like? Is it like their OKRs have certain goals around, "Here's how many PQAs you're driving?" Is it a number? What does accountable mean in this—

**中文翻译:**
当你提到“负责（Accountable）”时，具体是什么样的？是他们的 OKR 里有类似“驱动多少个 PQA”的目标吗？是一个具体的数字吗？在这种语境下，“负责”意味着什么？

---

### (00:57:46) Elena Verna

**English:**
I think so. Every product has some sort of goals and they definitely should have goals on keeping healthy, engaged user base. They should definitely have goals in terms of maybe feature utilization or customer satisfaction, but what I'm saying is to have also some sort of monetization goals. What that is for each company, I think, differs depending on their level of comfort and how close they are to revenue capture mechanism. Let's say at Miro, our head of growth product had a self-serve revenue target on her back. She drove it. She had revenue goal that she had to hit in product and she shared marketing because I ran marketing in that company. We shared a pipeline goal creation because pipeline cannot be created without marketing, too.

**中文翻译:**
我认为是的。每个产品都有目标，比如保持健康、活跃的用户群，或者功能利用率、客户满意度。但我想说的是，也要有某种“变现目标”。具体是什么，取决于每家公司的接受程度以及他们离收入获取机制的距离。比如在 Miro，我们的增长产品负责人背负着自助服务收入目标。她在产品端推动这个目标的实现，并与市场部（当时我负责市场部）共享目标。我们共同承担管线创建目标，因为没有市场部的参与，管线也无法建立。

---

### (01:00:11) Elena Verna

**English:**
In free to pay conversion, there's three pillars that you constantly need to work on, and one pillar dominates them all. It's monetization awareness. Simple as that. If you have a freemium product, I guarantee you 75% of your customers in freemium product are not aware of what you're selling. Only focusing on monetization awareness can give you incredible output on driving monetization, and it's really it's product's ability to communicate via feature walls, via usage walls, via trials, or what the value of the paid offering is.

**中文翻译:**
在“免费转付费”的转化中，有三个支柱需要不断优化，其中一个支柱压倒一切：那就是“变现意识（Monetization Awareness）”。就这么简单。如果你有一个免费增值（Freemium）产品，我敢保证 75% 的免费用户根本不知道你在卖什么。仅仅关注变现意识就能在驱动变现方面产生惊人的效果。这实际上是产品通过功能墙（Feature Walls）、使用量墙、试用期等方式传达付费方案价值的能力。

---

### (01:06:39) Elena Verna

**English:**
Let's just go through some summary that we've mentioned already throughout our conversation. Don't treat PLS as a traditional top-down sales process. Every single user does not equal. It's a opportunity for you to co-chase after. You need to understand the right triggers and usage. They can help you automate qualification process, so it's almost automating some of the SDR efforts to say, "When is the right time for my sales, for my human that I'm paying a lot of money, to intervene into this account and add value?"

**中文翻译:**
让我们总结一下刚才提到的几点。首先，不要把 PLS 当作传统的自上而下销售流程。并不是每一个用户都等同于一个机会。你需要理解正确的触发信号和使用行为，这能帮你自动化“合格评定”过程。这几乎是在自动化 SDR 的部分工作，即判断：“什么时候才是让那些我付了高薪的销售人员介入并提供价值的最佳时机？”

---

### (01:09:29) Elena Verna

**English:**
Yes, so in terms of benchmarks, first of all, it's time to get from individual usage, when that user comes in to have a single job to be done, to creating an enterprise-level contract. It does not happen in hours. It does not happen in days. It doesn't even happen in months of usage. A couple of benchmarks for y'all across Netlify, Miro, or Amplitude, which are all of the companies I worked at. It was 12 months plus of usage that had to happen before sales contracts can be created on sustainable way.

**中文翻译:**
是的，关于基准指标（Benchmarks），首先是从个人使用（用户进来完成单一任务）到签订企业级合同所需的时间。这不会在几小时或几天内发生，甚至不会在几个月内发生。根据我在 Netlify、Miro 和 Amplitude 的经验，通常需要 12 个月以上的使用积累，才能以可持续的方式产生销售合同。

---

### (01:13:27) Elena Verna

**English:**
Well, I wonder how much a rise in AI is going to automate some of those sales conversations. It's not going to be truly product-led growth because it's not like just the product's it's going to sell itself. What if on the other side of that chat or other side of that email or even a Zoom call because they can do a deep fake of anybody, it's going to be AI selling to you and giving you very deep and personalized answers? I am curious to see how that's going to evolve because the plethora of information that AI can surface to you in a very personalized manner in a matter of seconds is far stronger than any human or even content management system can do at the moment.

**中文翻译:**
我在想，AI 的兴起会在多大程度上自动化这些销售对话。这不会是纯粹的 PLG，因为不只是产品在自我销售。如果聊天框、邮件甚至 Zoom 电话（毕竟现在可以深度伪造任何人）的另一端是 AI 在向你推销，并提供非常深度、个性化的回答呢？我很想看看这会如何演变，因为 AI 在几秒钟内能为你呈现的个性化信息量，远超目前任何人类或内容管理系统。

---

### (01:14:23) Lenny

**English:**
Elena, this was everything I was hoping it would be. I imagine this episode will be even more popular than your first one. Thank you so much for making time and getting into such detail in all the things we talked about. Two final questions. Where can folks find online if they want to reach out, learn more? How can listeners be useful to you?

**中文翻译:**
Elena，这集完全达到了我的预期。我猜这一集会比你的第一集更受欢迎。非常感谢你抽时间分享这么多细节。最后两个问题：如果大家想联系你或了解更多，去哪里找你？听众们能为你做点什么？

---

### (01:14:42) Elena Verna

**English:**
I'm on LinkedIn a lot, but I have started my own Substack, so please subscribe to my newsletter if you can. I put more short content on LinkedIn and longer form explanations in my Substack, not to compete with your Lenny Newsletter—but these are plenty of room for everyone.

**中文翻译:**
我经常上 LinkedIn，但我最近也开了自己的 Substack，所以如果可以的话，请订阅我的通讯。我会在 LinkedIn 发一些短内容，在 Substack 发长篇解析。这并不是要和你的《Lenny's Newsletter》竞争——这个市场足够大，容得下所有人。

---

### (01:15:37) Lenny

**English:**
Well, you're one of the best at doing that, and thank you again for doing this.

**中文翻译:**
你是这方面的顶尖专家，再次感谢你的参与。

---

### (01:15:41) Elena Verna

**English:**
Thank you for having me, Lenny.

**中文翻译:**
谢谢邀请我，Lenny。

---

### (01:15:42) Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。另外，请考虑给我们评分或留言，这能帮助更多听众发现这个播客。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期见。