# Elena Verna 3.0 - 双语对照

This is the complete bilingual transcript for **Lenny's Podcast: Elena Verna 3.0**.

---

### [00:00:00] Elena Verna

**English:**
Growth is a fairly new field. You have a lot of renowned interest in growth hacks, like what is the sure things to get growth. In the age of social media everybody and anybody tries to share their tips and tricks. Oftentimes things that are completely out of context or they are very specific to one example and actually do not apply as a pattern.

**中文翻译:**
增长是一个相当新的领域。大家对“增长黑客”（growth hacks）有着极大的兴趣，比如寻找那些能确保增长的“必杀技”。在社交媒体时代，任何人都想分享他们的技巧和招数。但通常这些东西完全脱离了背景，或者只适用于某个特定案例，实际上并不能作为一种普遍模式来套用。

---

### [00:00:21] Lenny Rachitsky

**English:**
We're going to start with growth tactics that never work. If you see these items on your roadmap, you should probably not do them. What's number one?

**中文翻译:**
我们先从那些“永远无效”的增长策略开始。如果你在路线图（roadmap）上看到这些项目，你可能就不该去做。第一个是什么？

---

### [00:00:26] Elena Verna

**English:**
We live in tech. There's always lots of startups and startups obviously looking to grow. There is a huge misconception in the field that in order to get growth going, you need a growth team. To figure out your product market fit and how to distribute it, it's not something that you can outsource to somebody.

**中文翻译:**
我们身处科技行业，总是有很多初创公司，而初创公司显然都在寻求增长。这个领域存在一个巨大的误区：认为要启动增长，就必须先有一个增长团队。但实际上，弄清楚你的产品市场契合度（PMF）以及如何分发产品，并不是你可以外包给别人的事情。

---

### [00:00:42] Lenny Rachitsky

**English:**
Powerful words. I'm loving this list already.

**中文翻译:**
一针见血。我已经开始喜欢这个清单了。

---

### [00:00:45] Elena Verna

**English:**
Number two, this was my favorite and it might be a little spicy. Never ever once have I seen a rebrand or redesign, especially of UK marketing site produce good performance results. New CMO comes in designing their website or designing the brand as if it was reflection of their personal taste, and oftentimes it's promised with our acquisition is going to go up and it never materializes into anything meaningful.

**中文翻译:**
第二个，这是我的最爱，可能有点“辛辣”。我从来没有见过任何一次品牌重塑（rebrand）或重新设计（redesign）——尤其是营销网站的重新设计——能产生良好的业绩结果。新任 CMO 上任后，往往会按照自己的个人品味重新设计网站或品牌，并承诺这会提升获客量（acquisition），但这种承诺从未转化为任何实质性的成果。

---

### [00:01:12] Lenny Rachitsky

**English:**
A lot of contrary intakes here, I love this.

**中文翻译:**
这里有很多反直觉的观点，我喜欢。

---

### [00:01:14] Elena Verna

**English:**
Number three, if every single one of your initiatives that you're doing on growth is an experiment that's a problem. It's almost like a disease, like a paralyzing disease.

**中文翻译:**
第三个，如果你做的每一项增长举措都是一个“实验”，那就有问题了。这简直像一种病，一种让人瘫痪的病。

---

### [00:01:28] Lenny Rachitsky

**English:**
Today my guest is Elena Verna, my first ever third time repeat guest. Elena is the smartest person that I know on B2B Growth. She's also hilarious. She's led growth at companies like Miro Amplitude, Dropbox, and SurveyMonkey. She's advised dozens of companies on growth including Superhuman, MongoDB, Netlify, Similarweb, Sanity, Maze, so many more. In our conversation, Elena shares 10 growth strategies and tactics that never work yet that she keeps seeing people and companies invest lots of resources into. She also covers her three favorite growth frameworks that help you wrap your head around how to think about growth, and she also does a short dive into the non-traditional career paths that we both went down. If you spend any time working on product growth or lead people or work with people working on growth, this episode is for you. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that, I bring you Elena Verna.

**中文翻译:**
今天的嘉宾是 Elena Verna，她是我节目中首位三次做客的嘉宾。Elena 是我认识的在 B2B 增长领域最聪明的人，而且她非常幽默。她曾在 Miro、Amplitude、Dropbox 和 SurveyMonkey 等公司领导增长工作。她还为数十家公司提供增长咨询，包括 Superhuman、MongoDB、Netlify、Similarweb、Sanity、Maze 等等。在我们的对话中，Elena 分享了 10 种永远无效的增长策略和战术，尽管这些策略无效，但她仍看到许多人和公司投入大量资源。她还介绍了她最喜欢的三个增长框架，帮助你理清增长思路，并简要探讨了我们两人都走过的非传统职业道路。如果你从事产品增长工作、领导增长团队或与增长人员合作，这一集就是为你准备的。如果你喜欢这个播客，别忘了在订阅并关注。这是避免错过未来节目的最好方式，也对本节目有巨大帮助。下面，让我们欢迎 Elena Verna。

---

### [00:02:32] Lenny Rachitsky (Ad Segment: Sinch)

**English:**
This episode is brought to you by Sinch the customer communications cloud. Here's the thing about digital customer communications, whether you're sending marketing campaigns, verification codes or account alerts, you need them to reach users reliably. That's where Sinch comes in. Over 150,000 businesses, including eight of the top 10 largest tech companies globally use Sinch's API to build messaging, email and calling into their products. And there's something big happening in messaging that product teams need to know about, Rich Communication Services or RCS, think of RCS as SMS 2.0. Instead of getting texts from a random number, your users will see your verified company name and logo without needing to download anything new. It's a more secure and branded experience, plus you get features like interactive carousels and suggested replies. And here's why this matters. US carriers are starting to adopt RCS. Sinch is already helping major brands send RCS messages around the world and they're helping Lenny's podcast listeners get registered first before the rush hits the US market. Learn more and get started at sinch.com/Lenny. That's S-I-N-C-H.com/Lenny.

**中文翻译:**
本集节目由客户沟通云平台 Sinch 赞助。关于数字化客户沟通，无论是发送营销活动、验证码还是账户提醒，你都需要它们可靠地送达用户。这就是 Sinch 的用武之地。超过 15 万家企业，包括全球前十大科技公司中的八家，都在使用 Sinch 的 API 将短信、邮件和通话功能集成到他们的产品中。目前消息领域正在发生一件产品团队需要了解的大事：富通信服务（RCS）。你可以把 RCS 看作是短信 2.0。用户收到的不再是来自随机号码的文本，而是能看到你经过验证的公司名称和 Logo，且无需下载任何新应用。这是一种更安全、更具品牌感的体验，此外你还可以获得交互式轮播图和建议回复等功能。这之所以重要，是因为美国运营商正开始采用 RCS。Sinch 已经在帮助全球各大品牌发送 RCS 消息，并正在帮助 Lenny 播客的听众在美国市场爆发前优先完成注册。欲了解更多信息并开始使用，请访问 sinch.com/Lenny。

---

### [00:03:45] Lenny Rachitsky (Ad Segment: Vanta)

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast, now you can assess risk, secure the trust of your customers, and automate compliance for SOC 2, ISO 27001, HIPAA and more with a single platform, Vanta. Vanta's market-leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risks. Plus, you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to Vanta.com/Lenny. That's V-A-N-T-A.com/Lenny.

**中文翻译:**
本集节目由 Vanta 赞助。在确保公司拥有顶尖安全实践方面，事情往往会迅速变得复杂。现在，你可以通过 Vanta 这一个平台来评估风险、赢得客户信任，并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险。此外，你还可以通过 Vanta AI 完成安全问卷，从而节省数小时的时间。加入全球数千家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的公司吧。访问 Vanta.com/Lenny 即可享受 1000 美元的优惠。

---

### [00:04:40] Lenny Rachitsky

**English:**
Elena, thank you so much for being here. Welcome back to the podcast, our first ever third-time repeat guest. What an honor Dancing if you're not watching on video. Thank you for being here. I was actually just looking at our first episode, which we recorded almost over two years ago, September of 2022, and someone just today left a comment. People are still finding and watching it, and this comment encapsulates why I love having you on this podcast. This person said, "Wow, every word from Elena encapsulates years of knowledge. This is one to digest, slowly go back to and put on repeat. Thanks for sharing your experience with the world"

**中文翻译:**
Elena，非常感谢你能来。欢迎回到播客，你可是我们首位三次做客的嘉宾。真是荣幸（如果你没看视频的话，她正在跳舞）。谢谢你能来。我刚才还在看我们两年前（2022 年 9 月）录制的第一集，就在今天还有人留言。大家仍在不断发现并观看那一集，这条评论完美概括了为什么我喜欢请你来。那个人说：“哇，Elena 的每一句话都凝聚了多年的知识。这一集值得慢慢消化，反复回味。感谢你向世界分享你的经验。”

---

### [00:05:23] Elena Verna

**English:**
Thank you for having me. And my north star metric is insights per minute. That's what I try to use whenever I have any live meetings with people so it squarely fits within what I'm optimizing for. That's great.

**中文翻译:**
谢谢你的邀请。我的“北极星指标”（North Star Metric）是“每分钟洞察量”（insights per minute）。这是我在与人进行任何现场会议时努力达到的目标，所以这完全符合我正在优化的方向。太棒了。

---

### [00:05:37] Lenny Rachitsky

**English:**
That needs to be my KPI on this podcast, "Insights per minute."

**中文翻译:**
那也得成为我这个播客的 KPI，“每分钟洞察量”。

---

### [00:05:40] Elena Verna

**English:**
I think you have it. I think your insights per minute is pretty high.

**中文翻译:**
我觉得你已经做到了。你的每分钟洞察量相当高。

---

### [00:05:44] Lenny Rachitsky

**English:**
That is. I do shoot for that, although I have learned you also needed to feel good and feel their story. There's an interesting combo stuff. You can't just be insight, insight, insight.

**中文翻译:**
确实，我一直在追求这个目标，尽管我也学到了，你还需要让听众感觉良好，感受到嘉宾的故事。这是一种有趣的结合。你不能只是不停地抛出洞察、洞察、洞察。

---

### [00:05:54] Elena Verna

**English:**
It's all about how you present them too. Storytelling is a big portion of it actually to stick.

**中文翻译:**
这也取决于你如何呈现它们。讲故事（Storytelling）实际上是让这些洞察深入人心的重要部分。

---

### [00:06:00] Lenny Rachitsky

**English:**
Already insight. That's an insight right there. There's two areas that I want to spend time on with you, and these are areas I know you've been thinking a lot about. One is growth tactics that never work, that people keep spending time on and waste their time on. And I know you have a nice list of things you've seen that just don't work that people keep trying. And then two is growth frameworks, your favorite growth frameworks to help people wrap their mind around how to think about growth and grow their product. We're going to start with growth tactics that never works. Maybe just frame what we're going to talk about, talk about what this list and collection of tactics that we're going to talk about is.

**中文翻译:**
这本身就是一个洞察。我想和你探讨两个领域，我知道你最近一直在思考这些。一是那些“永远无效”的增长策略，人们却一直在上面浪费时间。我知道你有一份清单，列出了那些你见过无效却仍有人不断尝试的事情。二是增长框架，也就是你最喜欢的那些能帮助人们理清增长思路、推动产品增长的框架。我们先从无效的增长策略开始。也许你可以先做个铺垫，谈谈我们要讨论的这份策略清单到底是什么。

---

### [00:06:36] Elena Verna

**English:**
Growth is a fairly new field compared to marketing or product management or engineering. There's a lot of people that are now accumulated that have 10 years or so experience, but there's also a lot of newcomers and because there's ratio of actually newcomers, it's much higher than those people that have five, 10 years of experience of doing growth. You have a lot of renowned interest in growth hacks. What is the sure things to get growth? What is the sure thing to get that metric up? How can I contribute to success with the company the fastest way possible? All of these shortcuts and obviously in the age of social media where everybody and anybody tries to share their tips and tricks and this and that, people are grasping for oftentimes things that are completely out of context or they are very specific to one example and actually do not apply as a pattern or simply not even applicable to their type of business whatsoever.

**中文翻译:**
与营销、产品管理或工程相比，增长是一个相当新的领域。虽然现在已经积累了一批拥有 10 年左右经验的人，但也有大量的新人，而且新人的比例远高于那些有 5 到 10 年增长经验的人。大家对“增长黑客”有着极大的兴趣。什么是确保增长的手段？什么是提升指标的必杀技？我如何以最快的方式为公司的成功做出贡献？所有这些捷径，再加上在社交媒体时代，每个人都在分享他们的技巧和招数，导致人们经常去抓取那些完全脱离背景的东西，或者那些只针对特定案例、无法作为模式套用，甚至根本不适用于他们业务类型的东西。

(00:07:35):
**English:**
There's just a lot of failure happening in growth teams. Actually, I think growth teams are becoming one of those departments that has a higher head of growth firing rate than even CMOs because people are coming in, there's a bunch of expectations, "Hey, you're ahead of growth or you are a growth pm or you're a growth marketer, you're supposed to drive growth." And when that growth does not happen, here comes the axe and people off they go and the recycle and cycle starts all over in order to populate those positions. I think that there's just a lot of misinformation I would say probably out there in terms of what growth actually is and how it should be done in the companies. And today I just want to cover some of the biggest ones that I see as a patterns as I'm advising companies, as I'm operating in companies because it's just so blatant yet there's very few pieces of information on this for people to learn from.

**中文翻译:**
增长团队中存在大量的失败。事实上，我认为增长团队正成为那种“增长负责人”（Head of Growth）被解雇率甚至高于 CMO 的部门。因为人们入职时带着一堆期望：“嘿，你是增长负责人，或者是增长 PM，或者是增长营销人员，你应该推动增长。”当增长没有发生时，裁员的大斧就落下了，人们离开，然后为了填补这些职位，循环往复。我认为关于增长到底是什么以及公司应该如何做增长，外界存在大量的误导信息。今天，我想涵盖一些我在咨询和运营公司时看到的、最明显的模式，因为这些问题虽然显而易见，但可供人们学习的相关信息却很少。

---

### [00:08:31] Lenny Rachitsky

**English:**
Amazing. What's number one?

**中文翻译:**
太棒了。第一个是什么？

---

### [00:08:34] Elena Verna

**English:**
Number one, I have to start with hiring. There's lots of positions open all the time. There's so many from head of growth to growth PM there's a lot of rotation, as I said that is happening in the field. Very few growth people actually stay in the job for over a year or two years. There's a lot of constant churn and constant rehiring. And when you doing hiring, there's a lot of mistakes that are actually happening in hiring that I just want to start off on the list. It's not a roadmap item, but oh my gosh, there's just so much fault that is happening here. And I did write about it on your blog of hiring for growth. There's a little bit of a reference to that and one of the biggest latent issues that I see is hiring too soon for growth.

**中文翻译:**
第一点，我必须从招聘开始。这个领域一直有很多职位空缺，从增长负责人到增长 PM，正如我所说，人员流动非常频繁。很少有增长人员能在同一份工作上待超过一两年。这里存在不断的流失和不断的重新招聘。在招聘过程中，实际上发生了很多错误，我想以此作为清单的开始。这虽然不是路线图上的具体项目，但天哪，这里的错误实在太多了。我也在你的博客上写过关于“为增长而招聘”的文章，其中提到的一个最大的潜在问题就是：过早地为增长而招聘。

(00:09:17):
**English:**
We live in tech, there's always lots of startups. Startups are obviously looking to grow and there is a huge misconception in the shield that in order to get growth going, you need a growth team, absolutely not true. In order to get the growth going in the company, a founder and the founding team have to figure out how to make it grow to the first, let's say a million, 5 million, 10 million in ARR. Some of the companies don't even create growth teams until they're a hundred, 200 million in ARR because to figure out your product market fit and how to distribute it's not something that you can outsource to somebody. It's not somebody that with a shiny resume can come over and all of a sudden wave a magic wand and all of a sudden you have viral campaigns and a bunch of signups coming through and everybody's paying and everybody's retaining.

**中文翻译:**
我们身处科技圈，总是有很多初创公司。初创公司显然都想增长，但行业内有一个巨大的误区，认为要启动增长就必须有一个增长团队，这绝对是错误的。要让公司启动增长，创始人及其创始团队必须弄清楚如何让公司增长到最初的 100 万、500 万甚至 1000 万美元的 ARR（年度经常性收入）。有些公司甚至直到 ARR 达到 1 亿或 2 亿美元时才建立增长团队。因为弄清楚产品市场契合度以及如何分发产品，并不是你可以外包给别人的。不是说一个简历光鲜的人过来，挥挥魔法棒，突然间你就有了一堆病毒式营销活动，一堆注册用户，而且每个人都付钱、每个人都留存。

(00:10:09):
**English:**
That just doesn't happen. I see that mistake happening a lot. I really believe that the founder led growth is not being popularized enough that you do not need growth teams until you actually can start running experiments on your user base, which means that you have volume of users that you can learn from and optimize and innovate on, and that first wave of growth has to be founder led. And there's two specific reasons that I incur on, which is before you have growth team, before you would think about growth team first you need to have solid PMF, product market fit, means that you have a solution to a problem and you have customers not only coming in and solving that problem with your solution, but they're also retaining and staying with you. There is a good retention. You can use channel score of how many people would say that they cannot live without your product as well, but there's some sort of PMF. And then number two, you have data growth cannot function without data. If you have 10 users or 10 customers, that's not data, that's a G-sheet with your customers and you don't need a growth team for that. Until you have data that you can actually do an analysis and you can create hypotheses on and you can start applying experimentation, don't even think about growth team.

**中文翻译:**
那种事根本不会发生。我经常看到这种错误。我坚信“创始人驱动的增长”（founder led growth）还没有得到足够的普及。在你能真正开始对用户群进行实验之前，你不需要增长团队。这意味着你需要有足够的用户量来学习、优化和创新，而第一波增长必须由创始人主导。我有两个具体的理由：在考虑建立增长团队之前，首先你需要有稳固的 PMF（产品市场契合度），这意味着你有一个解决问题的方案，并且客户不仅在使用你的方案解决问题，而且还能留存下来。你可以参考 Sean Ellis 的测试（即有多少人会因为无法再使用你的产品而感到非常遗憾），总之要有某种形式的 PMF。第二，你必须有数据。没有数据，增长工作就无法开展。如果你只有 10 个用户或 10 个客户，那不叫数据，那只是一个客户名单表格，你不需要增长团队来处理。直到你拥有可以进行分析、建立假设并开始应用实验的数据之前，根本不要考虑增长团队。

---

### [00:11:32] Lenny Rachitsky

**English:**
Just to summarize a few of the things you just said, just for folks, you basically have seen startups look for a head of growth to join and solve their growth problem and your insight there is just almost always that is not going to be the solution to your problem until you have strong retention already, have a really high score on the channel score if don't have a ton of data yet and party advice is just the founder should continue to do this for as long as possible. A million ARR is one milestone a lot of people recommend. To your point, a lot of companies wait lot longer.

**中文翻译:**
为了帮大家总结一下你刚才说的几点：你基本上看到初创公司在寻找增长负责人来加入并解决他们的增长问题，而你的见解是，除非你已经有了强大的留存，在 PMF 测试中得分很高，否则这几乎永远不会是解决问题的办法。如果你还没有大量数据，你的建议是创始人应该尽可能长时间地亲自负责增长。100 万美元 ARR 是很多人推荐的一个里程碑，但正如你所说，很多公司会等得更久。

---

### [00:12:06] Elena Verna

**English:**
Yes. And honestly, the longer you wait, the better it is because that way your entire company will be trained to be responsible for growth as opposed to putting this one island with a growth team and saying, "They're going to be growing," and what is the rest of the company doing? Honestly, the longer you wait, the better.

**中文翻译:**
是的。坦白说，等得越久越好。因为这样一来，你的整个公司都会被训练成对增长负责，而不是把增长团队孤立成一个岛屿，然后说“他们负责增长”，那公司的其他人都在干什么呢？说真的，等得越久越好。

---

### [00:12:24] Lenny Rachitsky

**English:**
As you talk about this, sales is a part of what you described here, like hiring your first sales person. And I guess how do you think about your first head of growth versus salesperson? Is there anything advice there is? Like for B2B SaaS, you probably don't hire head of growth for even longer, you hire sales first or what's your advice?

**中文翻译:**
当你谈到这一点时，销售也是你描述的一部分，比如招聘第一个销售人员。那么你如何看待第一个增长负责人与销售人员的先后顺序？有什么建议吗？比如对于 B2B SaaS 公司，你可能更晚才招聘增长负责人，而是先招销售？

---

### [00:12:42] Elena Verna

**English:**
It depends on how you're actually going to collect the monies. If your money collection is going to happen through sales team primarily, then you absolutely should be hiring sales way before growth. In fact, in the sales led companies, growth teams are not necessarily needed even that much. You might have a growth marketing team, which is really a demand gen team that is rebranded for growth marketing so they can charge you 20 to 30% more in their salaries, but at the end of the day, sales is doing your monetization. They are doing your activation, they are doing your retention and success efforts. For sales like companies, yeah, higher sales, absolutely. Unless you're starting to do self-serve revenue.

**中文翻译:**
这取决于你实际上打算如何收钱。如果你的收入主要通过销售团队获取，那么你绝对应该在增长人员之前先招销售。事实上，在销售驱动型（sales-led）公司中，增长团队甚至没那么必要。你可能有一个增长营销团队，但那其实只是换了名字的“需求挖掘”（demand gen）团队，改名是为了能多拿 20% 到 30% 的薪水。但归根结底，销售在负责变现（monetization）、激活（activation）、留存和客户成功。对于销售驱动型公司，绝对要先招销售。除非你开始做“自助服务”（self-serve）收入。

(00:13:23):
**English:**
You're trying to have product sell itself through potentially freemium acquisition, trial acquisition or you actually having product led activation, monetization, that's when you would need a growth person. If you're starting with self-serve monetization, growth hire should be frankly first before sales. Your sales are going to be more opportunistic in nature versus if you sales led company, go ahead, hire sales, wait for growth until you are ready to overlay product-led growth on top of your sales motion.

**中文翻译:**
如果你试图让产品通过免费增值（freemium）或试用（trial）来自己销售，或者你实际上拥有产品驱动的激活和变现，那时候你才需要增长人员。如果你是从自助服务变现开始的，坦率地说，增长人员的招聘应该先于销售。在这种情况下，你的销售更具机会主义性质。反之，如果你是销售驱动型公司，那就先招销售，等到你准备好在销售流程之上叠加“产品驱动增长”（PLG）时再考虑增长人员。

---

### [00:13:57] Lenny Rachitsky

**English:**
That's an excellent clarification. Basically what I'm hearing, the advice is hire your ahead of growth only when you have clear product market fit and you're a product-led company and beyond a millionaire ARR ideally something like that.

**中文翻译:**
这是一个非常棒的澄清。我听到的建议是：只有当你有了明确的 PMF，并且你是一家产品驱动型公司，且 ARR 超过 100 万美元时，才去招聘增长负责人。

---

### [00:14:11] Elena Verna

**English:**
Right. And I won't say you're product-led company. You are relying on product-led motion to resolve a lot of the growth levers within you because you don't have to be fully product-led company. But if product, let's say acquires people, let's say with the SEO or SEM, and then its product is meant to activate them and then sales closes them, sales would be obviously important as well, but growth would have to come in a little bit sooner as well. If you have any product-led components where product is responsible for acquisition, activation, monetization or retention, that's where growth comes in.

**中文翻译:**
对。我不会说你必须是一家完全的产品驱动型公司。只要你依靠产品驱动的动作来解决内部的很多增长杠杆即可。比如，如果产品通过 SEO 或 SEM 获取用户，然后产品负责激活他们，最后由销售来完成转化，那么销售显然很重要，但增长人员也需要更早介入。只要你有任何产品驱动的组件——即产品负责获客、激活、变现或留存——那就是增长人员发挥作用的地方。

---

### [00:14:48] Lenny Rachitsky

**English:**
We talked deeply about that specific topic in our first conversation, just for folks, want to go deeper there. There's lot there.

**中文翻译:**
我们在第一次对话中深入探讨过这个特定话题，想深入了解的听众可以去听那一集，内容非常丰富。

---

### [00:14:53] Elena Verna

**English:**
I need to bring it back. This is keeps happening. I need to repeat it. You need to repeat it three times right before it sticks to people. Hopefully this is the third time.

**中文翻译:**
我得把它带回来。这种误区一直在发生。我需要重复它。你得重复三次，人们才能记住。希望这是第三次。

---

### [00:15:01] Lenny Rachitsky

**English:**
Absolutely. I'm only saying that because people may be wanting more of what you're describing and I will point them to our first episode, which gives deep on that one topic.

**中文翻译:**
当然。我这么说是因为听众可能想听更多你描述的内容，我会引导他们去看我们的第一集，那一集对这个话题有很深的探讨。

---

### [00:15:09] Elena Verna

**English:**
Amazing.

**中文翻译:**
太好了。

---

### [00:15:10] Lenny Rachitsky

**English:**
Excellent. Anything else before we move on to number two?

**中文翻译:**
非常好。在进入第二个话题之前还有什么要补充的吗？

---

### [00:15:13] Elena Verna

**English:**
No, let's move on to number two.

**中文翻译:**
没有了，我们进入第二个。

---

### [00:15:14] Lenny Rachitsky

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### [00:15:16] Elena Verna

**English:**
Number two, this is on the other side on the matured company where I see a trend over and over, and it's becoming even more prominent right now of when companies growth slows down, which inevitably happens for a lot of businesses, it happens for a variety of reasons. We're not going to go into the reasons as to why growth can be slowing down and then they hire a shiny growth head to fix the problem, to basically saying, "Our business is slowing down. We are on the decline. We're going to bring this person, or we're going to put this team together and our growth is going to accelerate." That just does not happen. If you have the overall business slowing down, your head of growth is destined to fail because the reason business is slowing down is much deeper than not having a growth team.

**中文翻译:**
第二个，这是针对成熟公司的。我反复看到一个趋势，而且现在变得越来越明显：当公司增长放缓时（这对很多企业来说是不可避免的，原因多种多样，我们不细谈原因），他们会聘请一位光鲜亮丽的增长负责人来解决问题，基本上就是说：“我们的业务正在放缓，处于下滑状态。我们要请这个人来，或者组建这个团队，然后我们的增长就会加速。”这根本不会发生。如果你的整体业务在放缓，你的增长负责人注定会失败，因为业务放缓的原因远比“没有增长团队”要深层得多。

(00:16:03):
**English:**
Growth team can optimize, growth can maybe lift it by 10, 15%. Maybe that's enough for you. Even that is on the upper end of what growth team will be able to do if there is a slow-down trajectory. But what's important is that if you have core product and core marketing issues, growth team will not be able to fix them for you. You're going to have to address the big elephant in the room as to why business is slowing down in the first place as opposed to just plopping a growth team on the issue and expecting them to do miracles while the rest of the business continues chugging on the same trajectory that caused the slowdown in the first place.

**中文翻译:**
增长团队可以进行优化，也许能提升 10% 到 15%。也许这对你来说足够了。但即便如此，在业务处于下滑轨道时，这已经是增长团队能做的上限了。重要的是，如果你存在核心产品和核心营销问题，增长团队是无法为你解决的。你必须正视那个“房间里的大象”，弄清楚业务最初放缓的原因，而不是仅仅把增长团队扔到问题上，指望他们创造奇迹，而业务的其他部分却继续沿着导致放缓的旧轨道运行。

---

### [00:16:41] Lenny Rachitsky

**English:**
Wow, I've never heard this point before and it's such an important one and it's very related to your first point. Growth isn't going to build a product people want, they will help you grow it.

**中文翻译:**
哇，我以前从未听过这个观点，这太重要了，而且与你的第一点密切相关。增长团队不会去打造一个人们想要的产品，他们是帮你去增长它。

---

### [00:16:53] Elena Verna

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:16:54] Lenny Rachitsky

**English:**
If your business is slowing, your product market fit basically might be disappearing and growth isn't solving that problem.

**中文翻译:**
如果你的业务在放缓，基本上意味着你的 PMF 可能正在消失，而增长团队解决不了这个问题。

---

### [00:16:59] Elena Verna

**English:**
Disappearing, it may be degrading, it may be being eaten by a competitor because there's somebody that is stomping on your territory. The point is growth can amplify great product market fit and growth can help you grow faster once you are already growing. But if you are slowing down and you have issues with either your go-to-market strategy or your core product strategy with your core product market fit, growth is going to be absolutely helpless to do anything. And it's honestly, it's a huge waste of money because at those size of the companies, you would make fairly large growth teams in order to tackle every single product flow and interface that is already out there and invented.

**中文翻译:**
可能是消失，也可能是退化，或者是被竞争对手蚕食，因为有人闯入了你的领地。关键在于，增长可以放大良好的 PMF，当你已经在增长时，增长团队可以帮你长得更快。但如果你正在放缓，且你的进入市场（GTM）策略、核心产品策略或核心 PMF 出了问题，增长团队将完全无能为力。坦白说，这是巨大的金钱浪费，因为在那种规模的公司，你会组建相当庞大的增长团队来处理现有的每一个产品流程和界面。

(00:17:45):
**English:**
It's a huge expense. ROI on it, maybe at least one to one. What you put into it, you might get that much out of it, but it's not going to be enough to create a J curve of the reacceleration by just relying on growth team. I think it's just like this is where the name growth team plays against it because, "We're looking for growth. Do you have a growth team?" No. I don't have a better idea by the way how to name it, but this is where I think it's misunderstood that there's the silver bullet of a perfect head of growth, perfect growth team that can reverse the trajectory of the business.

**中文翻译:**
这是一笔巨大的开支。它的投资回报率（ROI）可能顶多是 1:1。你投入多少，可能也就收回多少，但仅仅依靠增长团队是不足以创造出重新加速的“J 曲线”的。我觉得这就是“增长团队”这个名字带来的负面影响，因为人们会想：“我们需要增长，你有增长团队吗？”不。顺便说一下，我也没有更好的命名建议，但我认为这就是误解所在——认为存在一个完美的增长负责人或增长团队这种“银弹”（silver bullet），能够扭转业务的下滑轨迹。

---

### [00:18:26] Lenny Rachitsky

**English:**
Then for folks that are thinking about, "Wow, maybe I should be hiring head of growth," when should you hire head of growth? When you're an established company.

**中文翻译:**
那么对于那些在想“哇，也许我该招个增长负责人”的人来说，如果是成熟公司，什么时候该招呢？

---

### [00:18:33] Elena Verna

**English:**
If you are declining in your revenue growth or whatever other metric that you're looking at, your weekly active users or whatnot, see at least that you're able to plateau it so you can stop the decline. There is already a visible trajectory that your core product and your core marketing teams are able to at least reverse the degradation of the metrics. Ideally, you would even start to see some immediate signs of life that there is potential in the business, in the pockets, and then you can put growth into it to really blow it up to the full extent. But if you are on a decline, just don't do it because there's going to be very disappointing results in the year or so.

**中文翻译:**
如果你在收入增长或其他指标（如周活用户等）上处于下滑状态，至少要先看到你能让它进入平台期，从而止住下滑。要看到核心产品和核心营销团队已经能够扭转指标恶化的趋势。理想情况下，你甚至应该开始看到一些复苏的迹象，看到业务中潜藏的潜力，然后你再投入增长力量去全面引爆它。但如果你正处于下滑中，千万别这么做，因为一年左右之后的结果会让你非常失望。

---

### [00:19:18] Lenny Rachitsky

**English:**
Amazing. Great one, let's move on. Number three.

**中文翻译:**
太棒了。很有启发，我们继续。第三个。

---

### [00:19:23] Elena Verna

**English:**
Number three, this is my favorite, and it might be a little spicy because if there's any marketers listening out here, but doing rebrand more specifically, homepage redesign to drive growth. This is what hurts me so much and I've lived through so many of these and never ever once have I seen a rebrand or redesign, especially a UK marketing site, produce good performance results. Now, there's many reasons as to why you might want to do a rebrand, why you might want to design your marketing site because you're trying to enter a new market, new category, your product has evolved and you need to do a full update. But those are almost like it's a logging indicator that something needs to change and you're changing it and then you know that you're going to have to optimize the hell out of it in order to actually bring it even to the previous performance results.

**中文翻译:**
第三个，这是我的最爱，而且可能有点“辛辣”，特别是如果有营销人员在听的话：通过品牌重塑，更具体地说是通过“首页重新设计”来驱动增长。这让我非常痛心，我经历过太多次了，但我从未见过任何一次品牌重塑或重新设计（尤其是营销网站的重新设计）能产生良好的业绩结果。当然，你可能有很多理由想要重塑品牌或重新设计营销网站，比如你正尝试进入新市场、新类别，或者你的产品已经进化，需要全面更新。但这些几乎就像是一个滞后指标，表明某些东西需要改变，你改了，然后你知道你必须拼命优化它，才能让它的表现恢复到之前的水平。

(00:20:22):
**English:**
It's like a stepping stone back, but there is a much bigger room for upside that you can get to, but you are going to have to work to get to that upside. But yet so many companies, there's a story that happens all the time. I hire a new CMO, new CMO comes in, they're like, "What's inside my house here? My house is not designed to my liking. Let me repaint these walls. I want this shade of blue. Let me put the couches over here." And they start almost designing their website or designing the brand as if it was reflection of their personal taste. And oftentimes it's promised with our acquisition is going to go up, our category penetration is going to go up, our education or awareness is going to go up.

**中文翻译:**
这就像是先退后一步，虽然未来可能有更大的上升空间，但你必须付出努力才能达到那个高度。然而，在很多公司，总是在上演同样的故事：聘请了一位新 CMO，新 CMO 一上任就说：“我这房子里都是些什么呀？这装修我不喜欢。我要重刷墙壁，我要这种蓝色，沙发要放这儿。”他们开始设计网站或品牌，仿佛那是他们个人品味的体现。而且通常他们会承诺：我们的获客会增加，我们的品类渗透率会提高，我们的用户教育或知名度会提升。

(00:21:10):
**English:**
And it never materializes into anything meaningful because again, if you're doing it as a step towards unlocking new global maxima, sure, I love that. Do it. Go after it. Know that you have a ton of work ahead of you in order to actually unlock that global maxima. But to ever promise a homepage redesign or marketing site redesign in order to drive more acquisition is a failed promise that is going to be led by lots of agency money spending, often a million dollars plus, lots of arguing about which shade of blue your brand color is going to be, and eight to 10 months at the minimum of development and very lackluster results afterwards.

**中文翻译:**
但这些承诺从未转化为任何有意义的结果。因为，如果你把它当作解锁新的“全局最优解”（global maxima）的一步，那没问题，我支持，去做吧。但你要知道，为了真正解锁那个最优解，你面前还有大量的工作。但是，如果承诺通过重新设计首页或营销网站来驱动更多获客，那就是一个注定失败的承诺。这通常会导致在代理商身上花费巨资（往往超过 100 万美元），在品牌颜色该用哪种蓝色上争论不休，至少经历 8 到 10 个月的开发周期，而最后的结果却非常平庸。

---

### [00:21:58] Lenny Rachitsky

**English:**
Oh man, I'm loving this list already. This is great. To your point, it may still be worth doing if you're coming into it eyes wide open, this isn't going to drive growth, but we're setting ourselves up for a future brand that's world-class and we know our current brand stinks and our homepage needs to be refreshed. If you're aware, it's not going to drive growth, it might be okay.

**中文翻译:**
天哪，我已经爱上这个清单了。太棒了。正如你所说，如果你是清醒地去做这件事，那可能还是值得的——比如你知道这不会驱动增长，但我们是在为未来的世界级品牌打基础，我们知道现在的品牌很烂，首页需要刷新。如果你意识到这不会带来增长，那可能还好。

---

### [00:22:19] Elena Verna

**English:**
Every single time I've seen a marketing site at least rebrand, it's been a step back in performance that then is being treated as a fire drill to fix. Just don't do it if you expect immediate results out of it, or at least educate the team on how long it's going to take to get to the point where you think that there's going to be upside away from your original brand.

**中文翻译:**
我见过的每一次营销网站品牌重塑，起初都是业绩的倒退，然后被当作紧急任务去修复。如果你期望立即见效，那就别做；或者至少要教育团队，让他们知道需要多长时间才能达到你预想的、超越原品牌的增长点。

---

### [00:22:48] Lenny Rachitsky

**English:**
I've experienced this not just with marketing sites, but most redesigns. Redesign of the product.

**中文翻译:**
我不止在营销网站上经历过这种情况，大多数重新设计都是如此。比如产品的重新设计。

---

### [00:22:53] Elena Verna

**English:**
Product redesign. How much product and engineering work comes into just changing a logo in your product or changing colors? It's insane. With no results ever, there's no results.

**中文翻译:**
产品重新设计。仅仅为了更改产品中的 Logo 或颜色，需要投入多少产品和工程工作？简直疯了。而且从来没有结果，完全没有。

---

### [00:23:06] Lenny Rachitsky

**English:**
And to your point, it's like, "We've spent six months redoing onboarding. Everything we've built builds on this new design and experience, we can't not launch it. Every team is working on this new world, we're just going to launch it and then we're going to claw back. We're going to figure out how to get it back." That's how it goes.

**中文翻译:**
正如你所说，情况往往是：“我们花了六个月重新做新手引导（onboarding）。我们构建的一切都基于这个新设计和体验，我们不能不发布。每个团队都在为这个新世界努力，我们就先发布，然后再想办法把失去的指标‘抠’回来。我们会想办法恢复的。”事情就是这样发展的。

---

### [00:23:26] Elena Verna

**English:**
It's a new starting point and that starting point is going to be much lower than your current optimized experience that you have. Whether it's well optimized or not optimized, it doesn't matter. It's gone through some level of optimization versus rebrand is always a shot in the dark. It might be prettier, sure, but that doesn't mean it's going to perform well. Obviously never say never. Sometimes it might work, and if it worked for you, I am so glad. But that's an outlier and don't treat it as a pattern.

**中文翻译:**
这是一个新的起点，而这个起点往往比你当前经过优化的体验要低得多。无论当前体验优化得好不好，它至少经历过某种程度的优化，而品牌重塑总是在盲目尝试。它可能更漂亮，当然，但这并不意味着它表现会更好。当然，凡事无绝对。有时它可能有效，如果对你有效，我为你高兴。但那是特例，不要把它当作普遍规律。

---

### [00:23:57] Lenny Rachitsky

**English:**
And I was just going to say, I think everyone listening to this that is working on something like this is probably thinking, "No, I think we have a good shot at this. We've really thought deeply about this and it might actually be really positive." In your experience, it sounds like you've seen it work occasionally, or is it just never?

**中文翻译:**
我正想说，我觉得每个正在听这段对话且正在做类似项目的人可能都在想：“不，我觉得我们很有机会。我们真的深入思考过，结果可能会非常积极。”在你的经验中，你见过偶尔成功的案例吗，还是说从来没有？

---

### [00:24:15] Elena Verna

**English:**
The best I've ever seen is that it produced net neutral results and it produced us better ability to optimize towards something bigger. That's the best case scenario. So if you're working on it, my biggest advice is not to say you stop. Just understand that the goal here is not to drive at launch, in the seven-day readout after launch, some increased performance. The goal here should be, we will launch, we will probably see a hit, model out and forecast for a hit, and then give yourself two to three months at the minimum, ideally more like six months, to really optimize it back to a good standing where it can potentially outperform. But you need to bake in that three to six months of work after the launch, which is what a lot of companies and teams forget to do because they just move on. Because it's like big initiative, big pop, and off we go to our next project.

**中文翻译:**
我见过最好的情况是产生了“净中性”（net neutral）的结果，并让我们拥有了更好的能力去向更大的目标优化。那是最好的情况。所以如果你正在做这件事，我最大的建议不是让你停止，而是要明白：目标不是在发布时，或者发布后的七天数据中看到业绩增长。目标应该是：我们会发布，我们可能会看到数据下滑，我们要为此建模并预测下滑，然后给自己至少两到三个月（理想情况下是六个月）的时间，真正把它优化回良好的状态，使其有可能超越以往。但你需要把发布后三到六个月的工作量计算在内，而这正是很多公司和团队忘记做的，因为他们发布完就直接去做下一个项目了。因为这被视为“重大举措”，发布完就大功告成了。

---

### [00:25:08] Lenny Rachitsky

**English:**
I love that we're only at number three. This is amazing. Let's do number four.

**中文翻译:**
我太喜欢这个了，我们才讲到第三个。太棒了。来，第四个。

---

### [00:25:13] Elena Verna

**English:**
Number four is obsessing over your competition. Okay, so there's a little bit of a gotcha here. I tear down companies all the time. I have thousands of Gmail accounts that I sign up for any and every product. I go through their entire experience. I look at their monetization strategies. I look at their activation. I do it across direct competition of the company that I'm working with as well. I want to know what I'm playing against. So knowing what your competition is doing is extremely important. Being inspired by some aspects of what your competition is doing in their experience is a wonderful place to originate an ideation or potentially try to implement into your product as well.

**中文翻译:**
第四个是“痴迷于竞争对手”。这里有个微妙的地方。我经常对公司进行拆解（tear down）。我有成千上万个 Gmail 账号，用来注册各种产品。我会体验他们的整个流程，研究他们的变现策略和激活方式。我也会针对我所服务的公司的直接竞争对手做这些。我想知道我的对手是谁。所以，了解竞争对手在做什么极其重要。从竞争对手的体验中获得某些方面的启发，是产生构思或尝试在自己产品中实施的好方法。

(00:26:20):
**English:**
But blatantly saying, "Hey, we're going to copy all of these best tactics or all of these flows because, hey, they're doing better than us. Let's just rip them and do exactly the same. Why isn't our onboarding looks the same as this onboarding? This company is so successful." That's where things really go wrong because every single experience is very unique to their customer, to their channel. You don't even know if you're getting their actual experience or you use some tester cell or you're getting some personalized thing based on where you signed up from, who you said that you are. So you don't even know what actually the overall thing looks like most of the time and putting that into your product, it just leads to very subpar results. And there's a lot of drive, especially to have it as a shortcut. "Okay, we don't want to go through this ideation or user research. We don't want to do user interviews, but we don't want to do A/B testing. It works for them. It must work for us. Let's just go and do it." And it fails 95% of the time.

**中文翻译:**
但如果公然说：“嘿，我们要抄袭所有这些最佳策略或流程，因为他们做得比我们好。我们就照搬过来，做得一模一样。为什么我们的新手引导不像他们那样？那家公司太成功了。”这就是真正出问题的地方。因为每一种体验对于其客户和渠道来说都是非常独特的。你甚至不知道你看到的是否是他们的真实体验，或者你只是在某个测试组里，或者你看到的是基于你的注册地、身份信息的个性化内容。所以大多数时候你甚至不知道全貌是什么，直接把它放进你的产品，只会导致非常平庸的结果。很多人想把它当作捷径：“好吧，我们不想做构思或用户研究，不想做用户访谈，也不想做 A/B 测试。既然对他们有效，那对我们也一定有效。直接做吧。”结果 95% 的情况下都会失败。

(00:27:08):
**English:**
Now, there are certain pieces that I would rightly recommend. I already said inspiration. I use it for inspiration all the time. I'm like, "Okay, what's cool? What is everybody doing?" So because I want to just stay in the know on what other people are implementing and hopefully if it's in the control experience, it works and it worked better. I use web archives a ton for locked out pages too. I'm like, okay, how did it look last year? Why does their whole page look this way, or the pricing page? And I analyze that and I try to extrapolate some results. I also think that there is a lot of patterns you start to notice as you start tearing down all of these companies. You're like, "Oh, these elements are always the same." That means all of these companies are arriving to these things and they seem to be winning elements. And you can take those elements and put them into your product, but you can never skip the ideation, the design, the user research, the customer interview, the experimentation step.

**中文翻译:**
当然，有些部分我是推荐的。我刚才提到了“启发”。我一直用它来寻找灵感：“好吧，有什么酷的东西？大家都在做什么？”因为我想了解别人在实施什么，并希望如果那是经过对照实验的体验，它能更有效。我也经常使用网页存档（web archives）来查看那些非公开页面。我会看：去年是什么样子的？为什么他们的整个页面或定价页面长这样？我会分析并尝试推断出一些结果。我还认为，当你开始拆解所有这些公司时，你会注意到很多模式。你会发现：“哦，这些元素总是一样的。”这意味着所有这些公司都得出了同样的结论，这些似乎是致胜元素。你可以把这些元素放入你的产品，但你永远不能跳过构思、设计、用户研究、客户访谈和实验这些步骤。

(00:28:04):
**English:**
And you should always balance it with actually innovating yourself in your product. Because copying competition is like the fastest way to mediocrity because you'll never be a leader if you copied somebody else. Leader is by default is somebody that is able to separate themselves from the pack in something else. And if you are trying to just be, I don't know who is ever trying to be the mediocre middle of the pack, but maybe it's a good starting point, but never the end goal. The only other thing that I'll say before I'll stop talking is benchmarks. Benchmarks are also very dangerous here to use because benchmarks are usually done on all of the competition, on all of the softwares out there. And the way people define numbers is so different from company to company. Even if you look as something as simple as signups. Okay, how many signups should you be on average getting? Or your conversion from prospecting visitor to a signup? Or from a signup to activated user? It's so depends on how do you define prospect visitor? Some companies define it as all traffic. Some define it as new traffic. Some of them define it on the new IP address, new persistent id. How Google analytics defines it. How Amplitude defines it.

**中文翻译:**
你始终应该在参考对手与产品创新之间取得平衡。因为抄袭竞争对手是通往平庸的最快途径——如果你只是模仿别人，你永远成不了领导者。领导者在定义上就是那些能够在某些方面脱颖而出的人。如果你只是想成为……我不知道谁会想成为平庸的中游水平，也许那是一个好的起点，但绝不是终极目标。在我结束这个话题前，还要提一下“基准数据”（benchmarks）。在这里使用基准数据也非常危险，因为基准数据通常是基于所有竞争对手、所有软件得出的。而不同公司对数字的定义千差万别。即使是像“注册量”这样简单的东西：你平均应该获得多少注册？或者从潜在访问者到注册的转化率？或者从注册到激活用户的转化率？这完全取决于你如何定义“潜在访问者”。有些公司定义为所有流量，有些定义为新流量，有些基于新 IP 地址或新持久 ID。Google Analytics 的定义和 Amplitude 的定义也不同。

(00:29:21):
**English:**
So all of these definitions are so different. So taking also any benchmark that is derived from competition and saying, "This is where we should be," is also so dangerous because it might not even be applicable depending on how you define the metric. And one of the things that all of those benchmarking data fails is to actually look at specific definitions. And that's not to say that benchmarks are not extremely valuable data point in your decision making because it's an input that you should leverage to say what it could be possible. But to just blindly it and set it is just a sure way to fail any of your initiatives and efforts.

**中文翻译:**
所以所有这些定义都大不相同。因此，采用任何源自竞争对手的基准数据并说“这就是我们应该达到的水平”是非常危险的，因为根据你对指标的定义，它可能根本不适用。所有这些基准数据失败的原因之一就是没有考察具体的定义。这并不是说基准数据在决策中没有极高的价值，它是一个你应该利用的输入，用来说明什么是可能的。但如果只是盲目地设定它，那肯定会让你的任何举措和努力都以失败告终。

---

### [00:30:04] Lenny Rachitsky

**English:**
You're telling me that there's no shortcuts?

**中文翻译:**
你是说根本没有捷径？

---

### [00:30:10] Elena Verna

**English:**
I wish there were. I mean, I've been doing this for over 15 years. If there were any shortcuts, I'd be all over them. There are patterns and there are frameworks, but there's no shortcuts.

**中文翻译:**
我也希望有。我做这行已经超过 15 年了，如果有任何捷径，我早就全用上了。有模式，有框架，但没有捷径。

---

### [00:30:20] Lenny Rachitsky

**English:**
So people hearing this, they're like, "Okay, don't copy the competition. Use it for inspiration." It's a little hard to know exactly the line between those two. Is there an example that you can think of where you took really interesting inspiration from someone and it worked for a company you're working with? Or you copied someone and it's just like, "Oh, that failed. That was a bad idea."

**中文翻译:**
听众听到这里可能会想：“好吧，不要抄袭竞争对手，要寻找灵感。”但这两者之间的界限很难把握。你能举个例子吗？比如你从某人那里得到了非常有趣的启发，并成功应用到了你服务的公司？或者你抄袭了某人，结果却失败了？

---

### [00:30:41] Elena Verna

**English:**
I use competition to understand the general framework of how people collect some information or resolve certain steps. So, for example, a sharing model so many products like, "Hey, can you share this with somebody?" Well, you can go and spend so much time of figuring out how it should look. Or you can go to Slack, you can go to Figma, you can go to Nero, you can go to Notion. Like, okay, Google, how are they doing sharing model? You can look at all of that and say, "Okay, here's all of the common elements that all of them have. Here's the pieces that I think will apply to my product. Here's things that do not, and here's what I can derive from it."

**中文翻译:**
我利用竞争对手来了解人们收集信息或解决某些步骤的通用框架。例如“分享模型”，很多产品都有“嘿，你能把这个分享给别人吗？”的功能。你可以花大量时间去研究它应该长什么样，或者你可以去看看 Slack、Figma、Miro、Notion。比如，看看 Google 是怎么做分享模型的。你可以观察所有这些，然后说：“好吧，这是他们共有的所有元素。这是我认为适用于我产品的部分，这是不适用的，这是我可以推导出来的东西。”

(00:31:19):
**English:**
I use it as an input into ideation, but I never use it as a destination for the result, if that makes sense. Because it's very helpful to not start from scratch. The empty start problem is real and competition is a wonderful way to not have that and to have input into it, but never to just say, "Oh, we can skip the design cycle off we go," or, "Just slap our colors on it. If it works for them, it's going to work for us." So I have extensive Nero boards with everybody's onboarding flows, with everybody's pricing pages, their sharing model, their invite colleagues models that I reference all the time.

**中文翻译:**
我把它作为构思的输入，但从不把它作为结果的终点，你明白我的意思吗？因为不从零开始是非常有帮助的。“空白起点”问题是真实存在的，而竞争对手是避免这个问题并获得输入的好方法。但绝不能说：“哦，我们可以跳过设计周期直接开始，”或者“直接换上我们的颜色就行，既然对他们有效，对我们也一定有效。”所以我有很多 Miro 看板，上面记录了每个人的新手引导流程、定价页面、分享模型、邀请同事模型，我经常参考这些。

(00:32:00):
**English:**
But they've never been the exact thing that I would use for any company as opposed to say, "Hey, I think this is a great starting point for you. Here are the things that I think will work very well for your company and for your product and take these elements. The rest you need to go and do themselves, so at least that way there's a starting point." And this is why I also started doing a lot more of my own, almost, prototypes, like skeletons of here's the elements that you should do in these flows. I have one for pricing page, I have one for homepage, but you need to put in your own [inaudible 00:32:36] into it, in order for it to actually work.

**中文翻译:**
但我从未把它们原封不动地用在任何公司身上，而是会说：“嘿，我认为这对你来说是一个很好的起点。这些是我认为非常适合你公司和产品的元素，拿走这些元素。剩下的你需要自己去做，这样至少有了一个起点。”这也是为什么我开始做更多自己的原型，就像骨架一样，列出你在这些流程中应该具备的元素。我有定价页面的模板，也有首页的模板，但你必须加入你自己的灵魂，它才能真正发挥作用。

---

### [00:32:39] Lenny Rachitsky

**English:**
What made me realize this back in the day was thinking at Airbnb, especially, thinking about people looking at our flow and being like, they've got it all figured out. We're just going to copy what they've done, so thoughtful and have tested everything. And knowing how that has not happened and how so much of this was guesswork and we hate so much of it. Just thinking about people trying to copy this thinking we know what we're doing. It's like, "What are you guys even thinking?"

**中文翻译:**
当年在 Airbnb 时，我意识到了一点：特别是想到人们看着我们的流程，心想“他们肯定都搞清楚了，我们就照抄他们的，他们考虑得太周到了，而且测试过一切”。但实际上，很多时候根本不是那样，很多都是瞎猜的，我们自己都讨厌其中的很多部分。想到人们因为觉得我们知道自己在做什么而试图抄袭，我就想：“你们到底在想什么呢？”

---

### [00:33:02] Elena Verna

**English:**
Oh my God, I actually had that happen to me. At Dropbox not so long ago, somebody reached out and they're like, "Oh, I looked." It was like some page on activation flow and they're like, "Oh, I love this page. This is so cool. I love what you've done here. I'm going to go take it to my company." I'm like, "We haven't touched it in 10 years. This page is only visible for small cohort of people. Please don't do it. Please don't copy it. It performs like shit. I know it's out there, but it's not meant to be out there. Nobody thoughtfully put it out there." So that's definitely a huge failure point that you can run into.

**中文翻译:**
天哪，我也遇到过这种事。不久前在 Dropbox，有人联系我说：“哦，我看了你们激活流程中的某个页面，太酷了，我好喜欢。我要把它搬到我公司去。”我心想：“那个页面我们已经 10 年没动过了，而且只对一小部分人可见。请千万别这么做，别抄它。它的表现烂透了。我知道它在那儿，但它不该在那儿，根本没人用心地去维护它。”所以这绝对是你可能遇到的一个巨大失败点。

---

### [00:33:42] Lenny Rachitsky

**English:**
Right, if it's like a fancy company, assume they're just so smart and diligent about every little pixel and decision.

**中文翻译:**
没错，如果是一家大名鼎鼎的公司，人们就会假设他们非常聪明，对每一个像素和每一个决定都非常勤勉。

---

### [00:33:48] Elena Verna

**English:**
If people only knew of how much craziness is happening in those big companies and how much chaos there is.

**中文翻译:**
如果人们知道那些大公司里有多少疯狂的事情，以及有多少混乱就好了。

---

### [00:33:57] Lenny Rachitsky

**English:**
Oh man, that's a whole other podcast episode.

**中文翻译:**
天哪，那完全可以另做一集播客了。

---

### [00:33:59] Elena Verna

**English:**
Whole other podcasts, yes.

**中文翻译:**
完全可以，没错。

---

### [00:34:00] Lenny Rachitsky

**English:**
Okay, number five.

**中文翻译:**
好，第五个。

---

### [00:34:02] Elena Verna

**English:**
Okay, I have this one. It's a little bit Meta, but I see it happening all the time. We love to think that our problems are unique. I'm working in this company and we have this gross problem and we need to go and figure out the solution from the grounds up. Maybe this is a little bit related to the competition point, but I'm very sorry to break it to all of you, but your problem is not unique. I am 99% sure of that. Your problem has been felt by somebody somewhere in probably many, many places and you trying to re-engineer solution is time lost to market and has a huge opportunity cost.

**中文翻译:**
好，这个有点“元”（Meta），但我经常看到这种情况。我们总喜欢认为自己的问题是独一无二的。“我在这家公司工作，我们遇到了这个增长问题，我们需要从头开始寻找解决方案。”这可能与竞争对手那一点有点关系，但我很抱歉要告诉大家：你的问题并不独特。我 99% 确定。你的问题肯定在某些地方被某些人遇到过，而且可能在很多地方都发生过。你试图重新设计解决方案，是在浪费进入市场的时间，并且有着巨大的机会成本。

(00:35:41):
**English:**
So my biggest thing that I try to get people is don't think that you have unique problems. You don't. I know we love to. It'd be fun to have something unique to learn, but with so many startups, with so many people in our industry, in your industry, whichever industry that is, your problem has been solved by somebody. Or at least that there's a lot of failures on the problem that you should be learning from. And number one thing that whenever you have an initiative or whenever you have a metric that you need to go and move, to not start from scratch, ever. Do not start from scratch. It's the worst thing that you can do because you can waste so many cycles on trying to do something that probably has already been solved, which means how do you approach this as a result?

**中文翻译:**
所以我最想告诉大家的是：不要认为你有独特的问题。你没有。我知道我们喜欢这么想，学点独特的东西很有趣，但有这么多初创公司，有这么多人在我们的行业、你的行业，无论哪个行业，你的问题肯定已经被某人解决过了。或者至少在那个问题上已经有很多失败案例值得你学习。最重要的一点是：每当你有一个举措或需要提升某个指标时，永远不要从零开始。千万不要从零开始。这是你能做的最糟糕的事，因为你会浪费大量周期去尝试那些可能已经被解决的事情。那么，你应该如何应对呢？

(00:36:26):
**English:**
Well, you can look at competition and how they're solving the problem. That's one input, for sure. You should go find people that have solved this problem because there are people there and people love to talk about what they do. So take advantage of that human psychology and go find those people and just ask them, "How did you do it? What did you do? What happened?" Obviously, not all the time everybody's going to respond, but we have LinkedIn, we have X. Go out there, find the people that you think or ask around in your network of who you think might have similar solutions and just go talk to people. It would be incredible shortcut if you're talking about an actual hack that is a hack to get to an optimal solution.

**中文翻译:**
你可以看看竞争对手是如何解决这个问题的，这肯定是一个输入。你应该去找那些解决过这个问题的人，因为这样的人确实存在，而且人们喜欢谈论他们所做的事情。利用这种人类心理，去找那些人，直接问他们：“你是怎么做的？你做了什么？结果如何？”显然，不是每个人都会回应，但我们有 LinkedIn，有 X（原 Twitter）。去那里找你认为可能有类似解决方案的人，或者在你的社交网络中打听一下，然后去和他们聊聊。如果你在谈论真正的“黑客手段”，那么这就是通往最优解的绝佳捷径。

(00:36:43):
**English:**
And then the last thing that I would also say is that solving any one problem uniquely is extremely inefficient. We are evolving so fast in our market, you need to be able to patternize your solutions. Patternize, is that a word? Make patterns. Make patterns out of your solutions. So more you can stop looking at as a unique data point or unique problem and more as there is, I need to fit it into existing pattern or I need to figure out the framework on how to solve not only this problem but other problems. The faster you'll be able to get at least to like 60% of the solution there. And then you can do very authentic implementation of whatever you want to do. But to go from zero to 60 manually, as a one-off, we do not have time in the industry right now to do it, unless you want to be left behind.

**中文翻译:**
最后我想说的是，独特地解决任何一个问题都是极其低效的。我们的市场进化得如此之快，你需要能够将你的解决方案“模式化”。Patternize，有这个词吗？就是建立模式。从你的解决方案中总结出模式。你越是能停止将其视为独特的数据点或独特的问题，越是能将其视为“我需要将其放入现有模式”或“我需要弄清楚不仅解决这个问题、还能解决其他问题的框架”，你就越快能达到至少 60% 的解决方案。然后，你可以对你想做的任何事情进行非常真实的实施。但在目前的行业环境下，除非你想被甩在后面，否则我们没有时间手动地、一次性地从 0 做到 60。

---

### [00:37:23] Lenny Rachitsky

**English:**
Bam. Powerful words. Is there an example that comes to mind of you doing this either the wrong way of just thinking this was unique and realizing I should have talked to people, or where you actually realized something was not unique?

**中文翻译:**
砰！很有力量。你能想到一个例子吗？比如你曾以错误的方式处理问题，认为它是独特的，后来才意识到应该找人聊聊；或者你意识到某件事其实并不独特？

---

### [00:37:37] Elena Verna

**English:**
I'll give you actually an example that I had when I was at Nero. At Nero, we were first trying to stand up community, and I was tasked to do it, and I've never done it before. So I was banging my head around against the wall and I'm like, "Okay, how do I do it? What software do we use? Where do we acquire users? What kind of content is going to go in there?" So I was approaching it almost like a finding product market fit, and I will fail so much doing it. And I honestly only have a year to get to some sort of traction before this is going to get shut down because company is impatient, company is moving fast. So if this is going to be a failure point, it's either going to be taken away from me, which is fair, or we is going to close the door on it, which would be a huge failure both on my point and for company as a whole.

**中文翻译:**
我给你举个我在 Miro（原名 Nero）时的例子。在 Miro，我们最初尝试建立社区，我被委派负责这件事，但我以前从未做过。所以我当时一筹莫展：“好吧，我该怎么做？用什么软件？从哪里获取用户？里面应该放什么内容？”我当时几乎是像寻找 PMF 一样去处理它，结果遭遇了很多失败。坦白说，我只有一年的时间来取得某种进展，否则这个项目就会被关掉，因为公司没有耐心，发展很快。所以如果这成了失败点，要么项目会被从我手中拿走（这很公平），要么公司会彻底放弃它，这对我和公司来说都是巨大的失败。

(00:38:29):
**English:**
So I went and I started talking to a bunch of people that have done communities, and I remember talking to Caroline from Atlassian who has stood up community. I actually hired her as an advisor afterwards and she's like, "Well, are you talking about a user community or an agency community or a partner community?" And I'm like, my mind was blown. I'm like, "I even considering all of these angles because I was just literally thinking about users only." And she's like, "Well, you shouldn't necessarily start with the user community. If you want some results out of it, go to agency or partner communities first." She would applying it to me in a structural way for me to grasp my head around it and then implement something that had much better results at the end that I wouldn't even gotten to probably until six, eight months later, if I didn't talk to her.

**中文翻译:**
于是我开始去和一群做过社区的人聊。我记得和 Atlassian 的 Caroline 聊过，她建立过社区。后来我甚至聘请她担任顾问。她问我：“你是在谈论用户社区、代理商社区还是合作伙伴社区？”我当时惊呆了。我说：“我甚至没考虑过这些角度，因为我满脑子想的都只是用户。”她说：“你不一定非要从用户社区开始。如果你想看到成效，先去尝试代理商或合作伙伴社区。”她以一种结构化的方式向我解释，让我理清了思路，然后实施了一些最终效果好得多的方案。如果不和她聊，我可能要到六、八个月后才能想到这些。

(00:39:19):
**English:**
So I think it has to come with a place of knowing that you don't know everything and humility to say, "Hey, I need help," and I might have a already fancy title. At that point, I was an interim CMO at Nero and I'm like, "I don't know how to do this." And it actually earns you a lot more credit than you think. And a lot of people are afraid to admit that they don't know how to solve a problem and that's why they start from scratch. But you need to really put your ego aside and get some help faster than trying to hit every single failure point along the way.

**中文翻译:**
所以我觉得，你必须意识到自己并非无所不知，并且要谦虚地说：“嘿，我需要帮助。”即便我当时已经有了显赫的头衔——那时我是 Miro 的代理 CMO——但我还是说：“我不知道该怎么做。”实际上，这为你赢得的信任比你想象的要多。很多人害怕承认自己不知道如何解决问题，所以他们才从零开始。但你真的需要放下自尊，尽快寻求帮助，而不是在这一路上撞遍每一个失败点。

---

### [00:40:02] Lenny Rachitsky

**English:**
And the thing that'll really hurt your ego is failing. And so the more you could do to avoid failing and being successful with this initiative by talking to people, doing research.

**中文翻译:**
而真正会伤害你自尊的是失败。所以，通过与人交流、做研究，你能做的越多，就越能避免失败，让这项举措获得成功。

---

### [00:40:12] Elena Verna

**English:**
And to be fair, failure is going to be unavoidable. If you talk about growth, growth is about failure. My big motto, life motto on growth is that you have to fail to learn. You can't just constantly succeed. Success is an output of a lot of failures, but the question is, how much time do you have to fail? And a lot of times we don't realize how many failure cycles we're going to have to go through before we get a success, and that company, or even market, has no time for that. So still expect to fail, sure, but the timeline for failures is going to be shortened quite a bit.

**中文翻译:**
公平地说，失败是不可避免的。谈到增长，增长就意味着失败。我关于增长的人生格言是：你必须通过失败来学习。你不可能一直成功。成功是大量失败后的产出。但问题是，你有多少时间去失败？很多时候我们没有意识到在获得成功之前需要经历多少个失败周期，而公司甚至市场都没有时间等你。所以，当然还是要预料到会失败，但失败的时间线会被大大缩短。

---

### [00:40:54] Lenny Rachitsky

**English:**
Okay, so we've gone halfway through your list. There's 10 items on this list, right?

**中文翻译:**
好，我们已经讲完清单的一半了。清单上一共有 10 项，对吧？

---

### [00:40:58] Elena Verna

**English:**
Yes, yes. There's 10 items. Next one is a good one.

**中文翻译:**
是的，10 项。下一个很精彩。

---

### [00:41:01] Lenny Rachitsky (Ad Segment: OneSchema)

**English:**
I'm excited to chat with Christina Gilbert, the founder of OneSchema, one of our longtime podcast sponsors. Hi, Christina. What is the latest with OneSchema? I know you now work with some of my favorite companies like Ramp, Vanta, Scale, and Watershed. I heard that you just launched a new product to help product teams import CSVs from especially tricky systems like ERPs.

**中文翻译:**
很高兴能与 OneSchema 的创始人 Christina Gilbert 聊天，OneSchema 是我们播客的长期赞助商之一。嗨，Christina。OneSchema 最近有什么新动态？我知道你们现在与 Ramp、Vanta、Scale 和 Watershed 等我非常喜欢的公司合作。我听说你们刚刚推出了一款新产品，帮助产品团队从 ERP 等特别棘手的系统中导入 CSV 文件。

(00:41:47):
**Christina Gilbert:**
**English:**
Yes, so we just launched OneSchema file feeds, which allows you to build an integration with any system in 15 minutes as long as you can export a CSV to an SFTP folder. We see our customers all the time getting stuck with hacks and workarounds and the product teams that we work with don't have to turn down prospects because their systems are too hard to integrate with. We allow our customers to offer thousands of integrations without involving their engineering team at all.

**中文翻译:**
是的，我们刚刚推出了 OneSchema 文件馈送（file feeds），只要你能将 CSV 导出到 SFTP 文件夹，它就能让你在 15 分钟内构建与任何系统的集成。我们经常看到客户被各种临时方案和变通方法困扰，而与我们合作的产品团队不必因为对方系统太难集成而拒绝潜在客户。我们让客户无需工程团队参与即可提供数千种集成。

(00:41:47):
**Lenny Rachitsky:**
**English:**
I can tell you that if team had to build integrations like this, how nice would it be to be able to take this off my roadmap and instead use something like OneSchema and not just to build it, but also to maintain it forever?

**中文翻译:**
我可以告诉你，如果团队必须构建这样的集成，能把它从路线图中拿掉，转而使用 OneSchema 之类的工具，不仅是构建，还能永久维护，那该有多好。

(00:41:59):
**Christina Gilbert:**
**English:**
Absolutely, Lenny. We've heard so many horror stories of multi-day outages from even just a handful of ad records. We are laser-focused on integration reliability to help teams end all of those distractions that come up with integrations. We have a built-in validation layer that stops any bad data from entering your system, and OneSchema will notify your team immediately of any data that looks incorrect.

**中文翻译:**
绝对如此，Lenny。我们听过太多因为几条错误记录就导致长达数天停机的惨痛故事。我们专注于集成的可靠性，帮助团队消除集成带来的所有干扰。我们有一个内置的验证层，可以阻止任何错误数据进入你的系统，OneSchema 会立即通知你的团队任何看起来不正确的数据。

(00:42:19):
**Lenny Rachitsky:**
**English:**
I know that importing incorrect data can cause all kinds of pain for your customers and quickly lose their trust. Christina, thank you for joining us and if you want to learn more, head on over to oneschema.co. That's oneschema.co.

**中文翻译:**
我知道导入错误数据会给客户带来各种痛苦，并迅速失去他们的信任。Christina，感谢你加入我们。如果你想了解更多信息，请访问 oneschema.co。

---

### [00:42:33] Lenny Rachitsky

**English:**
Let me summarize the first five real quick and then we'll keep going. So the first is, wait longer than you think to hire a head of growth. Wait until you have product market fit, maybe a million, or especially if you're self-serve oriented. Number two is if your growth is declining, the head of growth won't solve that problem. First, stop the decline at least. Third is redesigning your homepage, marketing page. Rebranding is not only not going to help you grow, it's going to probably hurt growth and slow things down. And so just go into that wide eyes wide open. Four is don't just copy the competition and assume they know what they're doing and assume that what they do is going to work for you. Use it as inspiration. On the other hand, look at get inspiration from experts, competition, trends, things like that to help you solve your problem, which you think is no one solved before. It turns out every problem you're solving someone has solved in some way, most likely.

**中文翻译:**
让我快速总结一下前五个，然后我们继续。第一，招聘增长负责人的时间要比你想象的晚。等到你有 PMF，ARR 达到 100 万美元左右，特别是如果你是以自助服务为导向的。第二，如果你的增长正在下滑，增长负责人解决不了这个问题。至少要先止住下滑。第三，重新设计首页、营销页面或重塑品牌不仅不会帮你增长，还可能损害增长并拖慢进度。所以做这些事时要保持清醒。第四，不要只是抄袭竞争对手，假设他们知道自己在做什么，或者假设他们的做法对你也有效。要把这当作启发。另一方面，从专家、竞争对手、趋势等方面寻找灵感，帮助你解决那些你认为从未有人解决过的问题。事实证明，你正在解决的每个问题，很可能都已经有人以某种方式解决过了。

---

### [00:43:30] Elena Verna

**English:**
Yes, especially in growth. I mean, I know this can apply to a lot of product management and to marketing as well, but in growth, when you're talking about how do I lift activation or have a really big drop off between activation and monetization? These things are a lot more patternized than you would expect them to be, so go and find those patterns as opposed to trying to re-engineer it.

**中文翻译:**
是的，特别是在增长领域。我知道这也可以应用于产品管理和营销，但在增长领域，当你讨论“如何提升激活率”或“激活与变现之间存在巨大缺口”时，这些事情比你想象的要更加模式化。所以去寻找那些模式，而不是试图重新设计。

---

### [00:43:55] Lenny Rachitsky

**English:**
Amazing. Okay, let's keep going. Number six.

**中文翻译:**
太棒了。好，我们继续。第六个。

---

### [00:43:57] Elena Verna

**English:**
So next one. Next one is a little spicy one too, and that is part of growth you owning some channels. A lot of growth teams own acquisition. So owning channels and growth prioritizing SEO, SEM, social, is one of the biggest mistakes I think a growth team can do. Now, obviously, I'm not saying don't do SEO, or don't do SEM, so organic search or paid search. I'm not saying that. However, as a growth team, your number one priority is to create your own or your earned channel. So channel that you've earned and that nobody else can compete in but you.

**中文翻译:**
下一个，这个也有点“辛辣”，那就是关于增长团队拥有某些渠道的问题。很多增长团队负责获客（acquisition）。我认为增长团队犯下的最大错误之一就是优先考虑 SEO、SEM 和社交媒体。当然，我不是说不要做 SEO 或 SEM（即自然搜索或付费搜索）。我不是那个意思。然而，作为一个增长团队，你的首要任务是创建你自己的或“赢得的渠道”（earned channel）。也就是你赢得的、除了你之外没人能竞争的渠道。

(00:44:45):
**English:**
What do I mean by that? When you're doing organic search or paid search, you're making Google richer. Great for Google. Google is an incredible company, but by dumping money into paid marketing, you are paying them and you're paying for their distribution and access to their distribution. If you're doing social too, like you're doing, let's say, Instagram or whatnot, paid advertising in Instagram, that's great, but all of that works on algorithm. An algorithm can giveth, but algorithm can also taketh away at any point. And you have no control because you don't own those channels. You are playing with other players and you're competing against them in somebody else's channel.

**中文翻译:**
我这是什么意思呢？当你做自然搜索或付费搜索时，你是在让 Google 变得更富有。对 Google 来说很好，它是一家了不起的公司。但通过把钱投入付费营销，你是在付钱给他们，购买他们的分发能力和分发渠道。如果你做社交媒体，比如在 Instagram 上做付费广告，那也很好，但所有这些都依赖于算法。算法可以给你流量，也可以随时夺走流量。你没有控制权，因为你不拥有这些渠道。你是在别人的渠道里和其他玩家竞争。

(00:45:29):
**English:**
Now, on the other side, there can be your own earned channel. What is earned channel? It really goes into the concept of product-led growth acquisition, which means you're relying on virality, on word of mouth, on user-generated content in order to attract new acquisition through top of the funnel. So why is that earned and why do I put that above, let's say organic search, which is SEO, obviously, is wonderful? But again, search just goes to Google. That's great. Versus if you build your own user-generated content in your own community, nobody else can compete with you in that. That is yours. Your competitors cannot buy their eyeballs. Their people are going to be attracting other people.

**中文翻译:**
而另一方面，可以是属于你自己的“赢得的渠道”。什么是赢得的渠道？这实际上涉及产品驱动增长（PLG）获客的概念，意味着你依靠病毒式传播（virality）、口碑、用户生成内容（UGC），通过漏斗顶部吸引新用户。为什么说这是“赢得”的，为什么我把它排在 SEO 之上？SEO 当然很棒，但搜索流量最终还是流向 Google。相比之下，如果你在自己的社区建立了自己的用户生成内容，没人能在这方面与你竞争。那是属于你的。你的竞争对手无法买断这些关注。你的用户会吸引其他用户。

(00:47:05):
**English:**
Referrals from people to people are everything. So, Lenny, if I, let's say I sign up for, say, Superhuman and I invite you into it. That is much stronger acquisition tactic versus you looking for and finding Superhuman, let's say on paid marketing advertisements. And especially with our age right now where search as an interface is changing towards AI interface and the AI interface is giving a lot less credit to all of the content. Content is almost becoming a database and there's a new UI that is being developed on it. Before it was Google was the UI, and now AI is coming in with a new UI, and there's not as much control that you have over this new UI that is being developed. Focusing on these earned channels that you own becomes the outmost priority. And if you don't have them on your growth roadmap, you are going to be in some really big trouble over the next year to two years because your cost of acquisition is only going to go up. Your competition and those channel is only going to go up. You're constantly going to be praying to algorithm Gods to giveth your way, but again, they can taketh at any point. And it's really one of those fundamental growth team failure points if they don't spend enough time on virality and user generated content to create their own earned acquisition.

**中文翻译:**
人与人之间的推荐（referrals）就是一切。所以，Lenny，如果我注册了 Superhuman 并邀请你加入，这比你在付费广告上看到并找到 Superhuman 要强力得多。特别是在我们现在的时代，搜索界面正在向 AI 界面转变，而 AI 界面对内容的归功要少得多。内容几乎变成了一个数据库，而上面正在开发新的 UI。以前 Google 是 UI，现在 AI 带着新 UI 进场了，你对这个新 UI 的控制力没那么强。因此，专注于你拥有的这些“赢得的渠道”成了重中之重。如果你的增长路线图上没有这些，你在未来一两年内会遇到大麻烦，因为你的获客成本只会上升，竞争只会加剧。你会不断地向“算法之神”祈祷赐予流量，但他们随时可以收回。如果增长团队不花足够的时间在病毒式传播和用户生成内容上，以创造属于自己的“赢得的获客”，那这就是最根本的失败点之一。

---

### [00:47:48] Lenny Rachitsky

**English:**
Wow. Okay. This is incredible. This is its own podcast episode in theory that we could do of how to actually do this. We're not going to cover the strategy. Also, this may not necessarily work for every company. Your point is, you can grow other ways, but this is by far the most powerful, most effective, cheapest, most likely to succeed. If you can figure this out.

**中文翻译:**
哇。好。这太不可思议了。理论上这可以单独做一集播客，讲讲具体怎么做。我们今天不讨论具体策略。而且，这不一定适用于每家公司。你的观点是，你可以通过其他方式增长，但如果你能搞定这一点，它就是目前最强大、最有效、最便宜、最可能成功的。

---

### [00:48:08] Elena Verna

**English:**
It's not cheapest. It's actually cost a lot of product and engineering and even marketing resources to stand up. So it's not the cost of a budget, but it's cost of people that will have to work to create your own channel, so to speak, for acquisition. And you're right, maybe that's not for everybody, but it's actually applicable to more products than people realize. Because, every single product has some sort of team functionality, some sort of roles that they need to do. Every product can drive word of mouth loop... Well, actually, that's not true. Not every product can drive word of mouth loop, but they can drive recommendations and they can create user generated content.

**中文翻译:**
它不是最便宜的。实际上，建立它需要耗费大量的产品、工程甚至营销资源。所以它不是预算成本，而是人力成本，需要人们去创造属于你自己的获客渠道。你说得对，也许这不适合所有人，但它适用的产品其实比人们意识到的要多。因为每个产品都有某种团队功能，某种需要完成的角色。每个产品都可以驱动口碑循环……好吧，其实也不尽然，不是每个产品都能驱动口碑循环，但它们可以驱动推荐，可以创造用户生成内容。

(00:48:46):
**English:**
One of those tactics usually applies to at least one product. So there is an opportunity to create some sort of earned channel, even though it might feel unnatural at the beginning depending on how you reach PMF and how you've scaled in the first couple of stages of it. But if you are not exploring it and if you are not investing into it or at least trying and failing within it, I think that you are really leaving too much of your growth future into the hands of somebody else that you have low control over.

**中文翻译:**
这些策略中通常至少有一个适用于某种产品。所以，即使一开始感觉不自然（取决于你如何达到 PMF 以及在最初几个阶段如何规模化），也存在创建某种“赢得的渠道”的机会。但如果你不去探索、不投入，或者至少不去尝试和经历失败，我认为你真的是把增长的未来交到了你无法控制的别人手中。

---

### [00:49:19] Lenny Rachitsky

**English:**
So the advice here is your growth team. It's okay if they work on SEM, pay growth basically and SEO, but most of your effort and investment should be in earned channel, owned channels, specifically virality generated content?

**中文翻译:**
所以这里的建议是：增长团队可以做 SEM（基本上是付费增长）和 SEO，但大部分精力和投入应该放在“赢得的渠道”和“自有渠道”上，特别是病毒式传播和生成内容？

---

### [00:49:35] Elena Verna

**English:**
Diversify. Just diversify your strategy. So not all of it is reliant on somebody else giving you access to their distribution. Now, for example, a Dropbox, over 50% of acquisition comes through sharing. So I load something into my Dropbox, maybe I need to send it out for signature. Maybe I need to just share this file to transfer it to somebody. Maybe I just need to share this file as a final delivery to my clients that I was working with. Well, that recipient then is now aware of Dropbox, so it solved the brand awareness.

**中文翻译:**
多样化。让你的策略多样化。这样你就不会完全依赖别人给你分发渠道。例如，在 Dropbox，超过 50% 的获客来自“分享”。我把东西上传到 Dropbox，可能需要发出去签名，或者只是分享文件传给别人，或者作为最终成果发给客户。那么，接收者就知道了 Dropbox，这解决了品牌知名度问题。

(00:50:09):
**English:**
By that action of sharing, you actually almost activated that recipient too, so you don't need to educate them anymore on how the product works and whatnot. And the percentage of those recipients sign up to become Dropbox users, and that accounts for 50% of acquisition. That is a stable earned channel that nobody can compete with, and it's only for Dropbox to lose, so to speak. And we actually had our own growth pod focused on it. Because to optimize both sender experience and the recipient experience, because it was such a powerful growth and growth engine that driven the company, and every business should have an attempt at one of these.

**中文翻译:**
通过分享这个动作，你实际上几乎也激活了那个接收者，所以你不再需要教育他们产品是如何运作的。一定比例的接收者会注册成为 Dropbox 用户，这占了获客量的 50%。这是一个稳定的、没人能竞争的“赢得的渠道”，可以说只有 Dropbox 自己能搞砸它。我们当时甚至有专门的增长小组（growth pod）负责这个，去优化发送者和接收者的体验，因为它是一个驱动公司的强大增长引擎。每个企业都应该尝试建立一个这样的引擎。

---

### [00:50:51] Lenny Rachitsky

**English:**
I think this is going to be a really good push for a lot of growth teams to think about what could we do here? Number seven. Four to go

**中文翻译:**
我认为这会极大地推动很多增长团队去思考：我们能在这里做些什么？第七个，还剩四个。

---

### [00:50:58] Elena Verna

**English:**
Number seven. We've talked about this at least a little bit in our last podcast too. But I see this as a question that comes up all the time and something that people are afraid of to invest, which is a mistake. Every single company starts with their growth efforts focused either on product-led growth. Hey, I'm going to have everything being done self-serve or on sales in marketing. I'm going to have sales team and then I'm going to have marketing team and they're going to do all of the work and my product is just going to create the functionality. And that's good and fine for a while depending on how long that while is. But not overlaying every single way that you can grow through product, through marketing and through sales as an evolution. Is a huge mistake that a lot of growth teams fail to iterate on and innovate on.

**中文翻译:**
第七个。我们在上一期播客中也稍微提到过。但我发现这是一个经常出现的问题，也是人们害怕投入的地方，而这是一个错误。每家公司在开始增长工作时，要么专注于产品驱动增长（PLG）——“嘿，我要让一切都通过自助服务完成”；要么专注于销售和营销——“我要有销售团队和营销团队，他们负责所有工作，我的产品只负责提供功能”。这在一段时间内是可行的，取决于这段时间有多长。但是，如果不把通过产品、营销和销售增长的每一种方式作为一种进化来相互叠加，那就是一个巨大的错误，很多增长团队都没能在这方面进行迭代和创新。

(00:51:53):
**English:**
The way that I best be comparing it is if product has a product-market fit, which is great, that product-market fit is not going to last that product forever. They're always going to have to have a second horizon. They're always going to have to have a product-market fit expansion efforts in order to continue to grab as many people and solve as many people's problems as possible and increasing their team. Well, the same comes with growth. If you have a growth model that works for you, that's wonderful, good for you. Optimize it, grow it, scale it, create a team that will be nurturing it and that will be amplifying it, but you're going to need to evolve it, and that evolution needs to come through overlaying other growth models on top of it.

**中文翻译:**
我最好的类比是：如果产品有了 PMF，这很好，但 PMF 不会永远持续下去。他们总是需要有“第二增长曲线”，总是需要进行 PMF 扩展，以便继续吸引更多人、解决更多人的问题并扩大团队。增长也是如此。如果你有一个行之有效的增长模型，那太棒了。优化它、发展它、规模化它，建立一个团队去培育和放大它，但你还需要让它进化，而这种进化需要通过在其之上叠加其他增长模型来实现。

(00:52:48):
**English:**
So, A, you are diversified away from just one growth model failing, because a lot of times you're going to get into a situation of law. I love Andrew Chen's article here. It's called a Law of Shitty Clickthroughs. Where if you over-optimize the same thing over and over again, it has minimal returns, and some growth models have very limited time spans. Some of them are huge, some can grow for sharing loop at Dropbox. It's 17 years in the making and it's still firing. Good for it. That's amazing. But that's very much an anomaly. Most of growth loops spin out their ability to produce meaningful results for you within the first five to six to seven years.

**中文翻译:**
这样一来，首先，你可以实现多样化，避免单一增长模型失效。因为很多时候你会遇到一种“定律”。我很喜欢 Andrew Chen 的那篇文章，叫《糟糕点击率定律》（Law of Shitty Clickthroughs）。如果你一遍又一遍地过度优化同一件事，回报会变得微乎其微，而且有些增长模型的寿命非常有限。有些很庞大，比如 Dropbox 的分享循环，已经存在 17 年了且依然有效。那太棒了，但那是个特例。大多数增长循环在最初的五到七年内就会耗尽产生显著结果的能力。

(00:53:21):
**English:**
So continuously overlaying those different growth models, and what I'm specifically talking about is product-led growth, marketing- led growth, sales-led growth, and introducing it into this ecosystem constantly is what really separates companies that can continue growing for a long periods of times versus the ones that can see a really big blip, potentially even unicorn type of growth rates of 70, 80, whatever plus percent, and then it starts to slow down. And don't wait until that slowdown happens. You need to really start thinking about different ways that you can attract people to grow so you are not leaving a gap in the market that somebody else can enter and own. As opposed to you playing in every way in where you can interact with your customer.

**中文翻译:**
因此，不断叠加不同的增长模型——具体来说就是产品驱动增长、营销驱动增长、销售驱动增长，并将它们不断引入这个生态系统——这才是区分那些能长期持续增长的公司与那些只能看到昙花一现（即使增长率达到 70%、80% 甚至更高，然后就开始放缓）的公司的关键。不要等到放缓发生才去行动。你需要真正开始思考吸引用户增长的不同方式，这样你就不会在市场上留下空隙让别人进入并占领。相反，你应该在与客户互动的每一个环节都发挥作用。

---

### [00:54:13] Lenny Rachitsky

**English:**
The way I think about this is the S-curves of every growth model and growth lever, right? Eventually it'll help and then slow down and see you want to find the next S-curve on things that'll grow your business.

**中文翻译:**
我的理解是，每个增长模型和增长杠杆都有其 S 曲线，对吧？它最终会起作用，然后放缓，所以你想找到下一个能让业务增长的 S 曲线。

---

### [00:54:24] Elena Verna

**English:**
Yes, absolutely. The way that I see it often is that especially when growth teams, they hit a really big result out of some initiative, they just keep trying to focus on that over and over again. And sometimes that focus is warranted. Like I said, our sharing loop at Dropbox has its own growth team against it. Great, but at the same time, a lot that's not warranted for all of the... Or you need to realize that there's not more choose to squeeze out of this thing and then you need to go and you need to move on. Which actually brings me to a little bit of a next thing too, is you need to do it every 18 months. Because a lot of them are going to fail. And every five years or so, you for sure need new channel, new growth loops, new tactics, new engines so to speak, to power your growth engine.

**中文翻译:**
是的，绝对如此。我经常看到，特别是当增长团队从某项举措中获得巨大成果时，他们就会一遍又一遍地专注于此。有时这种专注是合理的，就像我说的，Dropbox 的分享循环有专门的增长团队。这很好，但同时，很多时候并不值得……或者你需要意识到，这件事已经榨不出更多油水了，你需要继续前进。这引出了我的下一个观点：你需要每 18 个月尝试一次。因为其中很多都会失败。大约每五年，你肯定需要新的渠道、新的增长循环、新的策略、新的引擎来驱动你的增长。

(00:55:39):
**English:**
Whether it's overlaying sales on top of self-serve, whether you're doing a lot of, let's say virality right now in terms of acquisition and you're going into marketing a lot heavier. But every five years something big has to start taking a big portion of your volume. And for that every 18 months you need to introduce something new in order for it to continue evolving.

**中文翻译:**
无论是将销售叠加在自助服务之上，还是你现在在获客方面做了很多病毒式传播，然后开始加大营销力度。每五年，必须有一些重大的新东西开始占据你业务量的很大一部分。为此，你每 18 个月就需要引入一些新东西，以保持持续进化。

---

### [00:55:49] Lenny Rachitsky

**English:**
18 months.

**中文翻译:**
18 个月。

---

### [00:55:40] Elena Verna

**English:**
Sorry. Yeah. Every 18 months you need to introduce something new in order for it to continue evolving.

**中文翻译:**
抱歉，是的。每 18 个月你需要引入一些新东西，以便让它持续进化。

---

### [00:55:49] Lenny Rachitsky

**English:**
And was that number eight of the list we're going through or that's like a bonus piece of advice?

**中文翻译:**
那是清单上的第八项，还是额外的建议？

---

### [00:55:52] Elena Verna

**English:**
No, that's just a bonus piece of advice.

**中文翻译:**
不，那只是额外的建议。

---

### [00:55:55] Lenny Rachitsky

**English:**
Okay, cool. Okay, got it. And so the advice here essentially is you'll find something that is helping you grow, assume that will slow down at some point, start thinking about other levers and growth models to layer on top of that.

**中文翻译:**
好，明白了。所以这里的建议本质上是：你会找到一些帮助你增长的东西，但要假设它在某个时间点会放缓，开始思考其他杠杆和增长模型来叠加在上面。

---

### [00:56:08] Elena Verna

**English:**
Yeah.

**中文翻译:**
没错。

---

### [00:56:10] Lenny Rachitsky

**English:**
Something I've seen, let me know if you agree, is usually there's going to be one lever that has most of your growth for a long, long time, and so all other things are not going to be as big, but they are still important.

**中文翻译:**
我观察到的一点是（看你是否同意），通常会有一个杠杆在很长一段时间内占据大部分增长，所以其他东西可能没那么大，但它们仍然很重要。

---

### [00:56:20] Elena Verna

**English:**
So the way I think about it is I try to focus 20 to 25% of growth teams time annually. Not every given sprint or not every given quarter, but annually to introduce a new growth loop, or to introduce a new channel, or to introduce something new that can potentially bring us additional umpth to our growth engine. I know that a lot of it is going to fail. None of it is gold on any growth metrics because you cannot goal it immediately, let's say on monetization or immediately acquisition. You're just going to cut it at its knees immediately if you're not going to let it evolve into something that can be monetized, that can be responsible for acquisition.

**中文翻译:**
我的想法是，我尝试让增长团队每年投入 20% 到 25% 的时间（不是每个冲刺或每个季度，而是全年）来引入新的增长循环、新渠道或新事物，从而为我们的增长引擎带来额外的动力。我知道其中很多会失败。这些尝试最初都不会有明确的增长指标目标，因为你不能立即要求它实现变现或获客。如果你不让它进化成可以变现或负责获客的东西，你就会立刻扼杀它。

(00:57:18):
**English:**
Example on Mirrorverse, which is a user-generated content library of all of the mirror boards that people create, it took us probably 18 months until we started putting metrics expectations on it. Before that, it was a thing that we were testing. And it was being used by a lot of people, but we're like, we don't even know exactly quite how this is going to fit all together. And then it started taking off as both engagement engine as well as acquisition engine. But it's important to constantly give your team room to try those new ideas. Otherwise, you're going to find yourself that your growth loops and your growth engine is slowing down and you don't have time to find that second horizon. And that is the worst situation to be in. That's where growth starts to slow down. And to recover out of that is impossible because you need revenue. You need revenue, you need revenue, you need revenue. And these growth loops on average take six months, a year, a year and a half to start producing even visible revenue. So that's why you need to start layering it very soon into your initiatives.

**中文翻译:**
以 Miroverse 为例，它是一个由用户创建的所有 Miro 画板组成的库。我们花了大概 18 个月才开始对它设定指标期望。在那之前，它只是一个我们在测试的东西。很多人在使用它，但我们当时甚至不确定它将如何融入整体。后来，它开始作为参与引擎和获客引擎爆发。但重要的是要不断给团队空间去尝试这些新想法。否则，你会发现你的增长循环和增长引擎正在放缓，而你却没有时间去寻找“第二曲线”。那是处境最糟糕的时候。当增长开始放缓时，想要恢复是不可能的，因为你需要收入、收入、收入。而这些增长循环平均需要六个月、一年甚至一年半才能开始产生可见的收入。这就是为什么你需要尽早将它们叠加到你的举措中。

---

### [00:58:13] Lenny Rachitsky

**English:**
To make this even more concrete for people that are starting to like, oh, shit I got to do this. Can you just give us a list that doesn't have to be exhaustive of potential growth loops, levers, methods, engines for folks to consider? You've mentioned a few, but just give a list of people like, okay, got it. Maybe we'll try one of these.

**中文翻译:**
为了让那些开始觉得“天哪，我得做这个”的人更明白，你能列举一些潜在的增长循环、杠杆、方法或引擎供大家参考吗？不需要穷尽所有。你已经提到了一些，但请给出一个清单，让大家觉得：“好吧，明白了，也许我们可以试试其中一个。”

---

### [00:58:29] Elena Verna

**English:**
I'm really big on creating a growth loop out of user generated content. I think with everything that is happening with AI and SEO at the moment, your biggest claim to fame on content strategy will be harnessing user generated content. Whether it's user generated templates, whether it's user generated case studies, review, whatever it is you need to start investing into it now, creating a library out of it, using it for activation purposes, using it then for acquisition purposes, using community to spark the conversations around it. That can be a really wonderful strategy that everybody should consider of whether there's juice in it within your product.

**中文翻译:**
我非常推崇利用用户生成内容（UGC）创建增长循环。考虑到目前 AI 和 SEO 的种种变化，你在内容策略上的最大胜算将是利用 UGC。无论是用户生成的模板、案例研究还是评论，你现在就需要开始投入，建立一个库，将其用于激活和获客，并利用社区引发围绕它的讨论。这是一个非常棒的策略，每个人都应该考虑自己的产品中是否有这方面的潜力。

(00:59:23):
**English:**
Other ones can be, hey, we're a very, let's say individualistic product, but can we actually create a referral mechanism for it? For B2C, that's actually very straightforward. A lot of B2C products thrive on referrals. For B2B, It can be more of invitation of other team members into the product to complete other jobs to be done. Hey, I've done this. I need my manager to see it. Can I create a report to share with my manager? And all of a sudden it starts to spread within the company. So creating additional almost product functionality that then creates these loops potentially for you. So it can be a slew of things. Obviously, I would highly recommend just understanding all of the menus of these earned tactics. I should do a blog post on it actually. And then just see what works for you or not. Because at least ideation step a bit has to happen. If especially you're relying on search engines for your acquisition, start thinking about some of the earned channels as soon as possible.

**中文翻译:**
其他的可以是：嘿，我们是一个非常个人化的产品，但我们能为它创建一个推荐机制吗？对于 B2C 来说，这非常直接，很多 B2C 产品依靠推荐而繁荣。对于 B2B，它更多是邀请其他团队成员进入产品以完成其他任务。比如：“嘿，我做完了这个，我需要让经理看到。我能生成一份报告分享给经理吗？”突然间，它就开始在公司内部传播。所以，创建额外的产品功能，从而为你创造这些循环。这可以是一系列事情。显然，我强烈建议去了解所有这些“赢得的策略”。实际上我应该为此写篇博客。然后看看哪些对你有效。因为至少需要经历构思阶段。特别是如果你依赖搜索引擎获客，请尽快开始考虑一些“赢得的渠道”。

---

### [01:00:22] Lenny Rachitsky

**English:**
And even though you recommend spend more time on earned channels, owned channels, there's also explore SEO, explore paid growth, right? Sales?

**中文翻译:**
尽管你建议在“赢得的渠道”和“自有渠道”上花更多时间，但也还是要探索 SEO、付费增长和销售，对吧？

---

### [01:00:33] Elena Verna

**English:**
Absolutely. I mean, almost everybody that's paid, arguably almost too soon potentially. There's a point to make that shouldn't be. A company should not be doing paid right now, but SEO, social resellers, all of those are wonderful tactics. Obviously, I skew very heavily towards earned channels just because once you stand that up, that's a gift that just keeps on giving and nobody can take that away from you. But that doesn't mean that other tactics and other channels should not be explored as well.

**中文翻译:**
绝对如此。我的意思是，几乎每个人都在做付费，甚至可能做得太早了。有些公司现在根本不该做付费。但 SEO、社交媒体、分销商，这些都是极好的策略。显然，我非常倾向于“赢得的渠道”，因为一旦建立起来，它就是一份源源不断的礼物，没人能从你手中夺走。但这并不意味着不应该探索其他策略和渠道。

---

### [01:01:06] Lenny Rachitsky

**English:**
Amazing. Let's keep going. So we have three to go. Number eight.

**中文翻译:**
太棒了。我们继续，还剩三个。第八个。

---

### [01:01:10] Elena Verna

**English:**
So number eight, this one's kind of a doozy and I think a lot of people don't do it. I don't know why they don't do it. I think it's such an incredible ability to propel forward. And that is, what doesn't work, as I said in the previous growth tactics, is trying to think that each problem is unique and you need to solve it on your own. Maybe this is not so much does it work, but not hiring advisors is something that I do not recommend for you to do. You can get access to anybody for one hour a week. Yeah, you'll have to pay them. So nobody's going to volunteer their hour. We're all very, very busy. But hiring advisors is the biggest career amplification and your business amplification can possibly do. Because to create a network of people that have all of these data points and those all of the other patterns that you can do is something that can just propel you so far forward.

**中文翻译:**
第八个，这个挺厉害的，我觉得很多人都没做。我不知道为什么他们不做，我认为这是一种极强的推动力。正如我在之前的增长策略中所说，行不通的做法是认为每个问题都是独特的，需要你自己去解决。也许这与其说“是否有效”，不如说我不建议你不请顾问。你可以每周花一小时接触到任何人。当然，你得付钱，没人会义务劳动，大家都很忙。但聘请顾问是你职业生涯和业务增长所能做的最大放大器。因为建立一个拥有所有这些数据点和模式的人脉网络，能把你推向远方。

(01:02:16):
**English:**
That doesn't mean you have to do everything advisor says. That's not the point. They're not the strategy setter. But they are additional input into your decision-making that you otherwise wouldn't have. You can go and hire somebody from Atlassian. You can go and hire somebody from Airbnb that have been and lived through all of this and they can help you solving your problem. So I think any growth team that does not have an advisor is a growth team that is underperforming. Because even me who I've advised so many companies, I've operated at so many companies, I don't know everything. Every time I take an operator role, I hire advisors for myself. Because that is the fastest way to learn anything, and I often see these teams that just try to figure out everything on their own and not have any advisors on their boards, so to speak.

**中文翻译:**
这并不意味着你必须照搬顾问说的每一句话。那不是重点。他们不是战略制定者，但他们为你提供了原本无法获得的决策输入。你可以去请 Atlassian 的人，也可以请 Airbnb 的人，他们经历过这一切，可以帮你解决问题。所以我认为，任何没有顾问的增长团队都是表现不佳的团队。因为即使是我，咨询过这么多公司，运营过这么多公司，我也并非无所不知。每当我担任运营角色时，我都会为自己聘请顾问。因为那是学习任何东西最快的方式。我经常看到有些团队试图靠自己搞定一切，而不请任何顾问。

(01:03:11):
**English:**
I'm not even talking like an official board. I'm talking not even an advisory board. But you can hire somebody as a contractor that will be your advisor, I think is a huge mistake, especially in this day and age. Because we have a big asymmetry of information. In our field, there's very little available to learn because we're all very cagey because of competition. But at the end of the day, people know a lot of the stuff and how it worked for them internally, and I highly, highly encourage you to not try to wing it on your own.

**中文翻译:**
我说的甚至不是正式的董事会，也不是顾问委员会。你可以以承包商的形式聘请某人作为你的顾问。我认为不请顾问是一个巨大的错误，尤其是在当今时代。因为我们面临着巨大的信息不对称。在我们的领域，可供学习的东西很少，因为由于竞争，大家都很谨慎。但归根结底，人们知道很多内部运作的细节，我强烈建议你不要试图独自摸索。

---

### [01:03:45] Lenny Rachitsky

**English:**
Along those lines, there's also advice of just like, don't worry about advisors. You never know if they're going to be useful. There's all these hanger-ons that join your startup and want to help, but they're not helpful. If you give one tip for a founder or team that's interviewing advisors, looking for an advisor to vet them to help them find people that are actually great, what would your tip be?

**中文翻译:**
说到这儿，也有人建议说别管什么顾问，你永远不知道他们是否有用。有很多“跟风者”加入初创公司想帮忙，但其实没啥用。如果你要给正在面试或寻找顾问的创始人或团队一个建议，教他们如何筛选出真正优秀的人，你的建议会是什么？

---

### [01:04:07] Elena Verna

**English:**
I have actually a good one. Many advisors might not like it though. I think that you should not hire an advisor until you do some sort of workshop with them on the problem that you're experiencing. See them in action. See what kind of information they can provide to you, because any advisor that is cagey about what they know is not the type of advisor that you're going to want to have on your team. You want to have somebody that has lived through it that can talk to you, to your face about it, that is able to have hard conversations. That is able to provide you necessary examples. That is able to give you and connect dots for you for necessary patterns. So instead of just saying, "Oh, this person looks good, let me hire them as an advisor." Say, "Hey, let's have a workshop first. I have this problem. I think that you can help me fix it."

**中文翻译:**
我确实有一个好主意，虽然很多顾问可能不喜欢。我认为在你就所面临的问题与他们进行某种形式的“工作坊”（workshop）之前，不应该聘请他们。要看他们的实际表现。看他们能为你提供什么样的信息，因为任何对自己所知遮遮掩掩的顾问都不是你想要的。你想要的是那些亲历过这些、能当面和你交流、能进行艰难对话的人。他们能为你提供必要的案例，能为你连接各个环节并总结出必要的模式。所以，不要只是说“哦，这个人看起来不错，请他当顾问吧”，而是要说：“嘿，我们先办个工作坊。我遇到了这个问题，我认为你能帮我解决。”

(01:04:57):
**English:**
Pay them for it, whatever their rate is for that workshop, for sure. See how they actually interact with your team and then hire them on ongoing retainer bases. Because that creates an interview loop that is very practical, that is very quick to understand whether you can work with them, they can work with you, and whether they have anything to contribute to you. And then every single month evaluate whether that advisor should stay with you. Some advisors, they only need to be with the company for three months and off they go, that's fine. Some of them might stick with you for four or five years, but every single month you should go and say, did they add any value? I'm not saying that advisors should have any monetary expectations like revenue attribution, so to speak to them. But did you find value in having conversations with them? Did they offer anything valuable to you?

**中文翻译:**
当然要付钱，无论那个工作坊的费率是多少。看看他们如何与你的团队互动，然后再决定是否以长期聘用的方式雇佣他们。因为这创造了一个非常实际的面试循环，能让你很快了解你们是否合拍，以及他们是否能为你做出贡献。然后每个月评估一次该顾问是否应该留下来。有些顾问只需要在公司待三个月，这没问题。有些可能会待四五年。但每个月你都应该问问：他们增加价值了吗？我不是说顾问应该有具体的收入归因等金钱指标，而是说：你觉得和他们交谈有价值吗？他们提供了有价值的东西吗？

---

### [01:05:49] Lenny Rachitsky

**English:**
That was an awesome tip. And I could see why people would be like, "God damn. Elena, don't say that." It makes so much sense. Here we go. Number nine. Here we go.

**中文翻译:**
这个建议太棒了。我能理解为什么有人会说：“该死，Elena，别说出来。”但这非常有道理。好，第九个。

---

### [01:05:59] Elena Verna

**English:**
My last one is also that I see something way too often nowadays on growth teams specifically. This is very, very gross problem. And that is too much risk averseness on growth, where you're starting to test everything. If every single one of your initiatives that you're doing on growth is an experiment, that's a problem and that is something that you should take a look at and say, what am I doing and why do I need a precise scientific measurement for every single thing that I touch in order for it to go to production or to hit the market? It's almost like a disease, like a paralyzing disease, that slows down progress, that slows down velocity, that slows down learnings, that creates very terrible consequences to the output that growth teams produce.

**中文翻译:**
我的最后一个也是我最近在增长团队中经常看到的。这是一个非常严重的问题：在增长上过于规避风险，以至于开始测试一切。如果你做的每一项增长举措都是一个实验，那就有问题了。你应该审视一下自己：“我在做什么？为什么我接触的每一件事都需要精确的科学测量才能投入生产或推向市场？”这简直像一种病，一种让人瘫痪的病，它拖慢了进度，降低了速度，减缓了学习，并对增长团队的产出造成了非常糟糕的后果。

(01:07:39):
**English:**
And it's a little bit counterintuitive, because experimentation is a way to do growth for growth teams and it's their process. Growth teams are meant to experiment, but I also think that experimenting on everything is something that is quite terrible once the team starts to get locked into that state, and it's really hard to get out of because they're then afraid to do any change until or unless that they test.

**中文翻译:**
这有点反直觉，因为实验是增长团队开展工作的方式，是他们的流程。增长团队本来就应该做实验，但我认为，一旦团队陷入“对一切都做实验”的状态，那是相当可怕的，而且很难摆脱，因为他们会变得不敢做任何改变，除非经过测试。

---

### [01:07:39] Lenny Rachitsky

**English:**
So where do you find that balance? I imagine people hearing this are like, oh, yes, this makes sense to me, and then they continue to test basically everything. What's kind of some heuristics you'd recommend for knowing, okay, just don't test that. Don't worry about it. You don't need credit for that win.

**中文翻译:**
那么如何找到平衡点呢？我能想象人们听到这里会说：“哦，是的，这对我很有启发”，然后继续测试几乎所有东西。你有什么启发式的方法（heuristics）可以推荐，让大家知道“好吧，这个就别测了，别担心，你不需要为这次胜利邀功”？

---

### [01:07:52] Elena Verna

**English:**
First of all, I think that people should trust their intuition a little bit more. Data is good, but data is only good if you have enough of it. So if you have low volume real estate, that is going to take you eight months to reach some sort of answer. Do you really want to test it for eight months? What's the point of it? My rule of thumb, if we cannot collect the sample size in the month, we shouldn't test it, period. Because it's just then it's not fast enough. We should just go and do pre versus post. Pre versus post is pretty powerful. It's also a way to assess your impact and you can still roll back if it doesn't work. But don't think that everything needs a scientific explanation to whether it needs to be moved forward or not.

**中文翻译:**
首先，我认为人们应该多信任一点自己的直觉。数据是好东西，但前提是你得有足够的数据。如果你是在一个流量很小的地方，需要八个月才能得出结论，你真的想测八个月吗？意义何在？我的经验法则是：如果一个月内无法收集到足够的样本量，我们就不测，就这么简单。因为那样速度不够快。我们应该直接做“前后对比”（pre versus post）。前后对比非常强大，它也是评估影响的一种方式，如果不行，你仍然可以回滚。但不要认为每件事都需要科学解释才能决定是否推进。

(01:08:36):
**English:**
Also, experimentation cannot be the way that people make decisions in the company. There's still so much about knowing your user, understanding the market for your brain to connect all of those dots and to know what needs to be an experience that your customers are going to want. That if scientific data, like a very tight determination of the probability that this is a success, it's important, absolutely do it because it might be a really big strategical pivot that you're planning to do. So it's a data point to validate that all of this extra work will be needed. It might be a very high traffic real estate that even 0.1% difference will mean millions of dollars for you.

**中文翻译:**
此外，实验不能成为公司做决策的唯一方式。了解用户、理解市场，让你的大脑连接这些点，弄清楚客户想要什么样的体验，这些仍然非常重要。如果科学数据（比如对成功概率的严密测定）很重要，那绝对要做，因为这可能涉及你计划进行的重大战略转型。所以它是一个验证是否需要这些额外工作的关键数据点。或者它可能是一个流量极大的地方，即使 0.1% 的差异也意味着数百万美元。

(01:09:17):
**English:**
But other than that, it should be just go, go, go. Do pre versus post. By the way, I'm not saying just release and move on. Release, do seven day, 24 hour readout, seven day readout, 28 day readout, even come back to it a year later and measure some of the retention or extension data that is associated with it. But to test everything is debilitating to growth teams and app paralyzes them in its place. So kind of look at your initiatives and say, where do I need precision? And it's important and I can get it best in that versus where we should just go for it. And yeah, we will fail there too, and that's okay. And we can roll back and we can figure out how to make it better. But failure is going to happen regardless.

**中文翻译:**
但除此之外，就应该勇往直前。做前后对比。顺便说一下，我不是说发布完就完事了。发布后，要做 24 小时数据读取、7 天数据读取、28 天数据读取，甚至一年后再回来衡量相关的留存或扩展数据。但测试一切会让增长团队变得虚弱，让他们陷入瘫痪。所以审视你的举措并问：哪里需要精确度？哪里通过实验能获得最好的结果？而哪里我们应该直接去做？是的，我们也会在那里失败，这没关系。我们可以回滚，可以想办法做得更好。但无论如何，失败总会发生。

(01:10:08):
**English:**
In statistics, six is tricky. Many people take it for face value versus it's just like a directional data point to say there's likely new distribution that has maybe a different mean, and 5% of the chances. If you measure in 95% statistical significance, you might not even be there, and yet really take it for so granted. Oh, it's going to drive this much lift. So I just think that people stop in this age of data, almost rely enough on their element intuition.

**中文翻译:**
在统计学中，数据是很微妙的。很多人只看表面价值，而它其实只是一个方向性的数据点，说明可能有新的分布，可能有不同的均值，以及 5% 的概率。如果你追求 95% 的统计显著性，你可能根本达不到，但人们却想当然地认为：“哦，它会带来这么多提升。”所以我认为在这个数据时代，人们已经不再足够依赖自己的直觉了。

---

### [01:10:42] Lenny Rachitsky

**English:**
A lot of contrary intakes here, I love this. Elena, we've reached number 10. And I know number 10 is like a special one where it's more than one. Quick. Fire.

**中文翻译:**
这里有很多反直觉的观点，我喜欢。Elena，我们讲到第 10 个了。我知道第 10 个很特别，包含不止一项。快问快答环节开始。

---

### [01:10:53] Elena Verna

**English:**
So number 10 is going to be my little fire round. My fire round on little things that I just see people spending way too much time on it. It hurts my heart, because it's not going to drive any results on them. So number one. Color optimizations. Because the love of God, a blue is a blue is a blue. As long as it's accessible and as long as it's bright enough, off you go. You do not need to test the shades of blue or test it against green or so on. Pick a color, move on, please don't spend time on it. That's an early 2000s tactic. It doesn't work anymore. We pass that in technology sector.

**中文翻译:**
第 10 个是我的“快闪环节”。我会列举一些我看到人们花费太多时间的小事。这让我很痛心，因为这些事根本不会带来任何结果。第一，颜色优化。看在上帝的份上，蓝色就是蓝色。只要它符合无障碍标准（accessible）且足够明亮，就行了。你不需要测试蓝色的深浅，或者拿它和绿色对比。选个颜色，继续前进，请不要在这上面浪费时间。那是 2000 年代初的策略，现在已经过时了，科技行业已经跨过了那个阶段。

(01:11:26):
**English:**
Number two. Third party signups. A lot of times we think, oh, we're going to get so much more acquisition if we add Google Auth or if we add Facebook Auth or Slack Auth or Microsoft Auth, whichever auth you want to add to it. In some cases, it's very important to have third party auth. So for example, if you are a developer product, please have a GitHub auth. It's kind of unnecessary. The developers already have the account there, have them connect with it as opposed to create a new one. However, if you're a productivity product, email is fine for the longest time. Gmail is nice. It's not going to drive more acquisition for you. You're just going to do a makeshift, and two more people using it. It's not going to create incrementality, it's not going to improve your activation, it's not going to improve your retention. It's not a growth tactic. It's part of you just customer experience that you want to invest into.

**中文翻译:**
第二，第三方登录。很多时候我们认为，如果我们增加 Google 登录、Facebook 登录、Slack 登录或微软登录，获客量就会大增。在某些情况下，第三方登录确实很重要。例如，如果你是开发者产品，请务必提供 GitHub 登录。开发者已经在那里有账号了，让他们直接连接，而不是创建新账号。然而，如果你是生产力产品，长期以来用邮箱登录就足够了。Gmail 登录固然不错，但它不会为你带来更多获客。你只是做了一个小改动，多了两个人用它而已。它不会带来增量，不会改善激活，也不会改善留存。这不是增长策略，这只是你想投入的客户体验的一部分。

(01:12:00):
**English:**
Number three, on the fire round, one email wonders. We stress too much about this one email that we're going to send to this one customer group. And we're like, oh gosh, how much lift is it going to cost? It'll never cause any lift. You will never work as a one-off email. Too few people open it on average, 25% open rate. At best you'll get 40 to 50% open rate. Too few people click it. One email will never do anything. If you're going to go into email, please think about it as a series about communication, about how it interacts with product communication. It's a whole strategy. It's a whole thing. Please don't stress about one-off email. Never test a change in one email. It'll never work. You're going to have to do the whole god damn thing and see how it's going to do. Not just one email, just never going to work.

**中文翻译:**
第三，“一封邮件奇迹”。我们对发给特定客户群的那一封邮件过于焦虑。我们会想：“天哪，它会带来多少提升？”它永远不会带来任何提升。单发一封邮件是行不通的。平均只有 25% 的打开率，太少了。哪怕最好也就 40% 到 50%。点击的人更少。一封邮件改变不了任何事。如果你要做邮件营销，请将其视为一系列沟通，思考它如何与产品沟通互动。这是一个完整的策略。请不要为单封邮件焦虑，也不要测试单封邮件的改动。那没用。你必须做一整套方案，看看效果如何。只靠一封邮件是永远行不通的。

---

### [01:13:03] Lenny Rachitsky

**English:**
I'm definitely guilty of this one. That is a really good one for sure. And it's so obvious in hindsight, so I love that you share that.

**中文翻译:**
我确实在这方面犯过错。这绝对是一个很好的建议。事后看来显而易见，所以我很喜欢你分享这一点。

---

### [01:13:09] Elena Verna

**English:**
Yes. And then the last one, growth teams are often too obsessed about removing friction. Because if we remove the steps, then more people are going to get to the destination. And to an extent, if you cause horrible friction in your product where it's just confusing about what the next step is, I agree, go fix the friction of the cognitive load that it takes to complete a step. That is the friction that you should be working on. However, just removing steps or yanking or simplifying things to an oblivion where you lose an identity of what you even do or what you're capable of doing is a completely failed growth tactic.

**中文翻译:**
是的。最后一个：增长团队往往过于痴迷于“消除摩擦”。因为觉得如果减少步骤，就会有更多人到达终点。在某种程度上，如果你的产品存在糟糕的摩擦，让人搞不清楚下一步该做什么，我同意，去修复那些完成步骤所需的“认知负荷”摩擦。那是你应该努力的方向。然而，仅仅为了减少步骤而随意删减或简化，以至于让产品失去了特色，甚至让人不知道你是做什么的或能做什么，这就是一个彻底失败的增长策略。

(01:14:08):
**English:**
So simplifying may be an initiative of a different problem that you're solving, but if you ever have a line item on your roadmap that says simplified onboarding, please cross it out. It's not going to work because simplifying onboarding is an action. What is the problem that you're solving? You're never trying to solve a problem of simplifying. You always have a problem of people are confused in it, but people don't know where to go or they get lost in it or they're not educated enough. That is the problem. And simplifying might be a solution, but it can never be a problem on its own. And too many growth teams are just obsessed with this notion that came out I think in early 2000s, like, oh, simplifying is the biggest growth hack that you can do. Do it. It's only a solution to a very specific problem set of too much complexity.

**中文翻译:**
所以，“简化”可能是解决另一个问题的举措，但如果你的路线图上有一项叫“简化新手引导”，请把它划掉。这行不通，因为“简化新手引导”是一个动作。你到底在解决什么问题？你永远不是在解决“简化”这个问题。你面临的问题通常是：人们感到困惑，不知道该去哪里，或者迷失了方向，或者没有得到足够的引导。那才是问题。简化可能是一个解决方案，但它本身永远不是一个问题。太多增长团队痴迷于那个大概源自 2000 年代初的观念，觉得“简化是最大的增长黑客手段”。去做吧，但它只是针对“过于复杂”这一特定问题的解决方案。

---

### [01:14:48] Lenny Rachitsky

**English:**
Wow, that was a big one to end on. That I think will help a lot of people avoid wasting time. Again, a whole other podcast conversation probably focus just on onboarding advice that you probably have, that I know you have. We've reached the last item. Is there anything else you want to share about this list before we move on?

**中文翻译:**
哇，这个结尾很有分量。我认为这会帮助很多人避免浪费时间。同样，这可能又是一个可以单独聊一集的新手引导建议话题，我知道你有很多这方面的见解。我们讲完了最后一项。在继续之前，关于这个清单你还有什么想分享的吗？

---

### [01:15:07] Elena Verna

**English:**
No, I think we've spent too much time. We're ready to go.

**中文翻译:**
没有了，我觉得我们花的时间够多了。准备好继续了。

---

### [01:15:09] Lenny Rachitsky

**English:**
Not too much. Just enough time. And kind of on a note, I want to call an audible, and so we were going to talk through all of your favorite frameworks. I like the way this conversation has gone. I don't want people to get overwhelmed with information. So one idea is just list maybe your favorite growth frameworks just for folks to go check these out and not spend too much time on each one.

**中文翻译:**
不算多，时间刚刚好。我想临时调整一下（call an audible）：我们原本打算详细讨论你所有最喜欢的框架，但我很喜欢现在的谈话节奏，不想让听众感到信息过载。所以，不如你直接列出你最喜欢的增长框架，让大家自己去查阅，我们不在每个框架上花太多时间。

---

### [01:15:30] Elena Verna

**English:**
Yep, let's do that.

**中文翻译:**
好，就这么办。

---

### [01:15:31] Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:15:32] Elena Verna

**English:**
Great. So the list of my favorite growth frameworks. And to me framework by the way, it's not a solution, it's a pattern. It's a pattern that exists across almost every single company out there and it's a starting point for your ideation and to figure out how you can almost shortcut to possible list of solutions as opposed to trying to figure out too hard of how to even define a problem on its own. So number one, it's probably expected if anybody has read anything or listened to me talk is growth loops. I think anybody who thinks about growth and anybody who thinks about growth in the funnel fashion versus understanding what the growth loops are is missing out on the ability to create sustainable growth engine. So it's very important to think about action, reaction that generates another action and it's a self-contained flywheel they can spin. A lot of resources on it at Reforge, Brian Balfour and Casey Winters and Andrew Chen wrote a lot about this.

**中文翻译:**
太好了。这是我最喜欢的增长框架清单。顺便说一下，对我来说，框架不是解决方案，而是一种模式。它是几乎存在于每家公司的模式，是你构思的起点，能让你几乎走捷径找到可能的解决方案，而不是费劲地去定义问题本身。第一，如果你读过我的文章或听过我的演讲，应该能猜到：增长循环（Growth Loops）。我认为任何思考增长的人，如果只用“漏斗”思维而不能理解增长循环，就会失去建立可持续增长引擎的能力。思考“动作-反应-产生另一个动作”非常重要，这是一个可以自转的闭环飞轮。Reforge 上有很多相关资源，Brian Balfour、Casey Winters 和 Andrew Chen 都写过很多关于这个的内容。

(01:16:33):
**English:**
Highly recommend anybody looking into. My next favorite growth framework's actually written by you, Lenny, and Dan, which is a race car framework. Everybody has a really hard time often thinking about what are all of them parts of growth initiatives and which are long-term, short-term, how much are they going to actually produce in results? And race car framework is wonderful because it separates different initiatives into, hey, there's some engines, loops that are just going to keep on spinning. There's some fuel that you're going to need to add into it, potentially like paid marketing dollars. There are some turbo boosts that you may have in your race car that are going to be, let's say big user conferences that you're going to hold as a product or there's [inaudible 01:17:22] and optimizations that you're going to need to do pouring oil into that engine so that actually performs correctly. It's beautiful. I talk about it all the time with everybody.

**中文翻译:**
强烈推荐大家去研究。我下一个最喜欢的增长框架实际上是你（Lenny）和 Dan 写的，即“赛车框架”（Race Car Framework）。大家经常很难理清增长举措的所有组成部分，哪些是长期的、短期的，实际能产生多少结果？赛车框架非常棒，因为它将不同的举措分开了：嘿，有些是引擎（循环），它们会持续转动；有些是你需要添加的燃料，比如付费营销资金；有些是你赛车里的涡轮增压，比如举办大型用户大会；还有一些是你需要做的优化（给引擎倒油），以确保其正常运行。这个框架太美妙了，我经常和所有人提起它。

(01:17:31):
**English:**
The next favorite growth framework for me comes from Bengali and that's adjacent to user theory. I think that was very powerful in terms of thinking about growth evolution. And as we talked about adding different growth models to your growth ecosystem, different growth loops, but also adjacent users which are outside of your ideal customer profiles or ICP, outside of your core user and how growth team can really bring them in and add additional oomph to your product without even expansion of product market fit by just optimizing their experiences. I'm going to stop at these three because I think those are the most powerful ones.

**中文翻译:**
我下一个最喜欢的增长框架来自 Bangaly Kaba，即“邻近用户理论”（Adjacent User Theory）。我认为在思考增长演进方面，这个理论非常强大。正如我们讨论过的，向增长生态系统添加不同的增长模型和循环，同时也包括那些处于理想客户画像（ICP）之外、核心用户之外的“邻近用户”。增长团队如何真正吸引他们，在不扩展 PMF 的情况下，仅通过优化他们的体验就为产品增加额外的动力。我就停在这三个，因为我认为它们是最强大的。

---

### [01:18:09] Lenny Rachitsky

**English:**
Cool. On that last one, [inaudible 01:18:11] Bengali was on the podcast. We'll link to that episode if you want to go deeper on the adjacent using user theory. I love how that was a few minutes on things that could change people's life if they adopt one of these frameworks and learn how to think about growth in this way. It's such a powerful mental model for thinking about all this stuff you've been talking about this entire conversation.

**中文翻译:**
酷。关于最后一个，Bangaly Kaba 曾经上过这个播客，如果你想深入了解邻近用户理论，我们会附上那一集的链接。我很喜欢刚才这几分钟，如果人们能采用这些框架并学会这样思考增长，真的能改变他们的职业生涯。对于思考我们整场谈话中提到的这些内容，这是一种非常强大的心智模型。

---

### [01:18:30] Elena Verna

**English:**
Yes, those frameworks are like my church in my mind of my system of beliefs of how I think about growth and how I think about it on a strategic level of owning it as a strategy, not just like a tactic or an initiative.

**中文翻译:**
是的，这些框架就像我脑海中的“教堂”，是我关于如何思考增长的信仰体系。我从战略层面思考增长，将其视为一种战略，而不仅仅是一种战术或举措。

---

### [01:18:47] Lenny Rachitsky

**English:**
The church of Elena Verna. Amazing. Okay, so before we wrap up, I want to bring us over to Contrarian Corner, recurring segment on this podcast where I like to ask the guest if there's something they believe that most other people don't believe. Contrarian opinion you might say. Is there anything that comes to mind?

**中文翻译:**
Elena Verna 的“教堂”。太棒了。好，在结束之前，我想进入“反直觉角落”（Contrarian Corner），这是我们播客的一个固定环节，我喜欢问嘉宾是否有某种他们深信不疑但大多数人不相信的观点。也就是所谓的“反直觉观点”。你能想到什么吗？

---

### [01:19:08] Elena Verna

**English:**
I do have a very contrarian opinion, although it's not so much related to growth as opposed to maybe your personal growth and my contrarian opinion is that full-time jobs are not the best way to monetize the skill that you have. It's one of the packages that everybody should evaluate and take advantage of, but too many people blindly default to that package and don't explore other options that are both available on the market as well as best suited for their personalities, for their interests, and for their skill set. It's like a default plan that everybody subscribes to that is faulty in itself.

**中文翻译:**
我确实有一个非常反直觉的观点，虽然它与增长本身关系不大，更多是关于个人成长：全职工作（full-time jobs）并不是将你的技能变现的最佳方式。它只是每个人都应该评估和利用的“方案包”之一，但太多人盲目地默认选择这个方案，而不去探索市场上存在的、更适合他们性格、兴趣和技能组合的其他选项。这就像一个每个人都订阅的默认计划，但它本身是有缺陷的。

---

### [01:20:08] Lenny Rachitsky

**English:**
Wow. Okay. Wait, we got to hear more. So what are some other packages? I think we're buying some of these packages, these other options, but I guess what should people be thinking about when you say this in terms of what can they actually do and explore?

**中文翻译:**
哇。好。等等，我们得听听更多细节。还有哪些其他的“方案包”？我想我们正在购买其中一些方案，但我想知道，当你说这些时，人们应该思考什么？他们实际上可以做些什么、探索些什么？

---

### [01:20:08] Elena Verna

**English:**
I'll premise it to saying I don't want to rain parade on full-time roles. They're wonderful on video ability, to learn to get the expertise and depending on which career stage you are at full-time roles might be the absolute necessity for you to move on to and unlock the next level. However, full-time roles boxes into one company that may not be a great fit for us culturally, for our skills, for our ambitions, for our interests. Life is too short for that and ability to really go and figure out your own best monetization model, just like you work on that for your business, you should work for that on yourself without an assumption oftentimes is the only option that you should have.

**中文翻译:**
我先声明，我不想泼全职工作的冷水。全职工作在学习、获取专业知识方面非常棒，而且根据你所处的职业阶段，全职工作可能是你进入下一阶段的绝对必要条件。然而，全职工作会将你框在一家公司里，而这家公司在文化、技能、抱负或兴趣上可能并不适合你。人生苦短，你应该像为业务寻找最佳变现模型一样，为自己寻找最佳变现模型，而不是默认全职工作是唯一的选择。

(01:20:56):
**English:**
So what are the other options? There's so many, obviously the couple known ones. Freelancing, you can be a contractor. I do a lot of advising and consulting because for my brain of how I work and how I like to puzzle solve and pattern match, it works much better to be horizontal across many companies versus vertical on one specific one. But that doesn't mean I still don't take those vertical engagements to deepen my knowledge into any specific topic. But overall it's a lot more interesting for me to pattern match across multiple companies and help them grow as opposed to just focusing on one.

**中文翻译:**
那么还有哪些选择？有很多，显然有几个广为人知的：自由职业（Freelancing），你可以做承包商。我做了很多顾问和咨询工作，因为根据我的大脑运作方式，我喜欢解决难题和模式匹配，横向服务于多家公司比纵向深耕于一家公司更适合我。但这并不意味着我不接受纵向的深度参与，以加深我对特定主题的了解。但总的来说，跨多家公司进行模式匹配并帮助它们增长，比只专注于一家公司要有趣得多。

(01:21:34):
**English:**
There's interim engagements where there's a predetermined end date to your agreement. There's fractional engagements where you're working part-time on something as opposed to engulfing yourself completely. There's other ways to create courses, there's a way to create newsletters and monetize them like you're doing such a fantastic job. So there's just so many options and people are sometimes paralyzed by fear of instability, that it creates when you start to explore other options because you don't have that contract with that one company that provides you that paycheck every two weeks to rely on. But at the same time you can create diversification for your career and you depend on when you need to pull that trigger and when is the right time for you to explore. But to spend your entire career only assuming full-time is the only way I think is a complete mistake that a lot of people are doing.

**中文翻译:**
还有“过渡期聘用”（interim engagements），即协议有预定的结束日期。还有“分时聘用”（fractional engagements），即你兼职做某件事，而不是全身心投入。还有其他方式，比如创建课程，或者像你做得这么棒的创建 Newsletter 并变现。选择真的很多，但人们有时会被对“不稳定”的恐惧所麻痹，因为当你开始探索其他选项时，你不再拥有那家每两周给你发一次工资的公司可以依靠。但与此同时，你可以为你的职业生涯创造多样化。这取决于你何时需要扣动扳机，以及何时是探索的最佳时机。但我认为，整个职业生涯都只假设全职工作是唯一途径，是很多人正在犯的一个彻底错误。

---

### [01:22:33] Lenny Rachitsky

**English:**
One of my favorite posts of yours along these lines, which is around increasing... What you want to do is increase optionality and I guess talk about that because I think it's a really powerful piece of advice.

**中文翻译:**
我最喜欢你写的关于这方面的文章之一，就是关于增加……你想要做的是增加“选择权”（optionality）。我想请你谈谈这个，因为我认为这是一个非常有力的建议。

---

### [01:22:46] Elena Verna

**English:**
So this advice of career optionality, being the ultimate north star for anybody in their professional journey is something that I'm very strong on because a lot of people have the goal of, I don't know, maybe I want to be a VP or I want to become a CEO. Or I don't know, I want to be a manager and I want to people manage. And this becomes their north star and they start working towards it. But a lot of people when they get to their perceived corporate ladder north stars find themselves extremely dissatisfied, depressed even by how terrible that job is. Could people manage your job? I wouldn't wish it on my worst enemy because it's a terrible job if you don't enjoy it and you don't know if you're going to like it until you actually do it.

**中文翻译:**
将“职业选择权”作为任何职业旅程的终极北极星，这是我非常坚持的观点。因为很多人设定的目标是：“我想当副总裁”或者“我想当 CEO”，或者“我想当经理带团队”。这成了他们的北极星，他们开始为此努力。但很多人当他们爬到所谓的职场阶梯顶端时，却发现自己极其不满，甚至因为那份工作太糟糕而感到沮丧。带人的工作？如果我不喜欢，我甚至不会把它强加给我的死对头，因为如果你不享受它，那是一份糟糕的工作，而且在你真正做之前，你不知道自己是否会喜欢。

(01:23:33):
**English:**
So I think setting a title as your goal, which so many of us have titles as goals, is very wrong way to think about it as opposed to saying, "Hey, my goal professional is actually to have options so I can choose what I want to do. So I can choose what fits my life right now that I can choose what fits my skills and that fits my personality and that makes me happy." And to get career optionality, if that's your goal, you start thinking about your progression a lot differently. You're not starting to think about it of what will get me to the next title. You start thinking about what will can I do next year that will increase my option pool? And that's very different than just getting to a higher title.

**中文翻译:**
所以我认为，把“头衔”设定为目标（我们很多人都这么做）是非常错误的思考方式。相反，你应该说：“嘿，我的职业目标实际上是拥有选择权，这样我就可以选择我想做的事，选择适合我目前生活、适合我技能、适合我性格并让我快乐的事。”如果你的目标是获得职业选择权，你对职业发展的思考方式就会大不相同。你不会去想“什么能让我升职”，而是会想“明年我能做些什么来增加我的选择池？”这与仅仅获得更高的头衔有很大不同。

(01:23:54):
**English:**
And if you start thinking about evaluating opportunities or whether you should stay at the company, whether you should move at the company from the lens of does it increase my options if I stay at this company for one more year or does it keep it the same or does it actually potentially decrease? That is the right way to find your ultimate happy place and happy job that brings you energy, that brings you happiness versus just going for a title and then being very disappointed with what that brings along with it.

**中文翻译:**
如果你开始从这个角度评估机会，或者考虑是否应该留在公司，或者是否应该跳槽——即“如果我在这家公司再待一年，它是会增加我的选择权，还是保持不变，甚至可能减少？”——这才是找到最终让你快乐的地方和工作的正确方式。这种工作能带给你能量和幸福，而不是仅仅为了一个头衔，最后却对它带来的东西感到非常失望。

---

### [01:24:48] Lenny Rachitsky

**English:**
Amazing advice. So important and something I'll add that I think is a balance to what people may be feeling here is like, oh, I'll just bounce around all the best logo companies and create this killer resume. I think you also need to build depth and actual experience that you can tap into if you do any of these things. For example, a lot of people want to jump to like I'm going to be a newsletter person, I'm going to start a podcast, be an advisor before they've done anything real and you have nothing to actually base your advice on and that part is very important.

**中文翻译:**
极好的建议。非常重要。我想补充一点，作为对大家可能产生的一种想法的平衡：有人可能会想“哦，那我就在所有大厂之间跳来跳去，打造一份完美的简历”。我认为你还需要建立深度和实际经验，这样当你做这些事情时才有底气。例如，很多人在还没做出任何实绩之前，就想跳去做 Newsletter、做播客、当顾问，但你根本没有可以支撑你建议的基础，那部分非常重要。

---

### [01:25:16] Elena Verna

**English:**
You have to earn your right to unlock optionality and earning that right does usually lie within full-time jobs. That is a universal truth. But then at some point you should start not just looking at full- time jobs as the only option that you have. You should start to think about when can you start unlocking new ones and testing the market on it.

**中文翻译:**
你必须赢得解锁选择权的权利，而赢得这种权利通常确实需要通过全职工作。这是一个普遍真理。但在某个时间点，你不应该再仅仅把全职工作视为唯一的选择。你应该开始思考什么时候可以开始解锁新的选项，并为此测试市场。

---

### [01:25:39] Lenny Rachitsky

**English:**
The other point is that you've been a great example of is it's not a one-way door. You can have full-time job, go to something else, go back to full-time job, be an advisor, be an intern person, be a newsletter person. You do that really well.

**中文翻译:**
另一点是，你就是一个很好的例子：这不是一扇单向门。你可以做全职工作，然后去做别的，再回到全职工作，或者当顾问、做过渡期高管、写 Newsletter。你在这方面做得非常好。

---

### [01:25:53] Elena Verna

**English:**
You should have to do it all. It's all a menu of options and you pick a menu item that fits your best in any given point of your life. It's never say never and never shut the door on anything. Absolutely.

**中文翻译:**
你应该尝试一切。这就像一份选项菜单，你在人生的任何特定时刻选择最适合你的那一项。永远不要说绝不，也永远不要对任何事情关上大门。绝对如此。

---

### [01:26:03] Lenny Rachitsky

**English:**
Oh my god, Elena, this was incredible. Before we get to our very exciting lighting round, is there anything else you want to share or leave listeners with, maybe a last nugget or thought or not because covered a lot already.

**中文翻译:**
天哪，Elena，这太精彩了。在进入激动人心的快问快答环节之前，你还有什么想分享或留给听众的吗？也许是最后一点心得或想法？或者没有也行，因为我们已经讲了很多了。

---

### [01:26:13] Elena Verna

**English:**
No, I think we've covered so much. I don't want to overwhelm.

**中文翻译:**
没有了，我觉得我们涵盖的内容已经够多了，不想让大家过载。

---

### [01:26:16] Lenny Rachitsky

**English:**
Let's do it. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
那我们开始吧。现在进入激动人心的快问快答环节。准备好了吗？

---

### [01:26:21] Elena Verna

**English:**
Yes, I'm ready.

**中文翻译:**
准备好了。

---

### [01:26:22] Lenny Rachitsky

**English:**
First question, surprise, surprise. What are two or three books you've recommended most to other people?

**中文翻译:**
第一个问题，不出所料：你向别人推荐最多的两三本书是什么？

---

### [01:26:27] Elena Verna

**English:**
Okay, so I just finished this book that I love so much, it's not a professional book, but it's Project Hail Mary by Andy Weir. It's the same author that wrote Martian. Martian also was made into a movie. So good, so good. Can't put it down. I think I read it like two days straight. So highly recommend that. And the next one that I also started reading right now is Body Burst. Body Burst is so good. It's actually takes into account AI and how we can upload our consciousness in AI and what can happen with that. So highly recommend that, I think it's actually closer to what potentially can be in the truth for us in the future than not. But I'm a big sci-fi geek, so I read mostly sci-fi books.

**中文翻译:**
好，我刚读完一本非常喜欢的书，不是专业书，是安迪·威尔（Andy Weir）的《挽救计划》（Project Hail Mary）。他也是《火星救援》的作者。《火星救援》还被拍成了电影。这本书太棒了，简直爱不释手，我连着读了两天。强烈推荐。另一本我刚开始读的是《波波提》（Bobiverse，此处 Elena 误说为 Body Burst）。它非常精彩，探讨了 AI 以及我们如何将意识上传到 AI 中，以及会发生什么。我也强烈推荐，我觉得这可能比我们想象的更接近未来的真相。我是个十足的科幻迷，所以大部分读的都是科幻书。

---

### [01:27:14] Lenny Rachitsky

**English:**
I have a sci-fi recommendation for you that comes from Noah Smith. I love his newsletters called Noah Opinion and he has a list of his favorite sci-fi books that I've been working my way through. It's called, you may have read it by Werner Vogel, Fire Upon The Deep. Have you heard of this?

**中文翻译:**
我也有个科幻书推荐给你，来自 Noah Smith。我很喜欢他的 Newsletter《Noah Opinion》，他有一份最喜欢的科幻书单，我一直在读。书名叫《深渊上的火》（A Fire Upon the Deep），作者是弗诺·文奇（Vernor Vinge）。你听过吗？

---

### [01:27:14] Elena Verna

**English:**
No, I have not.

**中文翻译:**
没有，没听过。

---

### [01:27:29] Lenny Rachitsky

**English:**
Okay. It's described as not a sci-fi but space, like a space opera where it's epic, the most epic scale of universe story.

**中文翻译:**
好。它被描述为不仅仅是科幻，更像是太空歌剧，非常宏大，是宇宙尺度上最史诗般的故事。

---

### [01:27:38] Elena Verna

**English:**
I'll download it tonight, it'll be on my list.

**中文翻译:**
我今晚就下载，把它列入我的书单。

---

### [01:27:41] Lenny Rachitsky

**English:**
It takes a little bit to get into. It's quite unique, but you just keep going and it's incredible and AI plays a big role in it actually.

**中文翻译:**
入门可能需要一点时间，它非常独特，但只要你读下去，就会发现它不可思议，而且 AI 在其中扮演了重要角色。

---

### [01:27:48] Elena Verna

**English:**
That's awesome. I'll download it.

**中文翻译:**
太棒了，我会下载的。

---

### [01:27:49] Lenny Rachitsky

**English:**
There you go. Okay, question number two. Favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
好。第二个问题：最近你非常喜欢的电影或电视剧是什么？

---

### [01:27:55] Elena Verna

**English:**
Yes. I just got to watching Beef on Netflix. It's so good. I'm not going to spoil it for anybody, Beef. You should watch it. It's a limited series. It's so good. I love Veep on HBO. So funny. I've probably watched it two times already the entire series and I'll probably watch it more because it just cracks me up every time. I think this is actually how our government works, so I'm very intrigued by that. And then the last one that I really liked that is coming up with the season two now. So you should catch up with season one is Last One of Us. If you don't like zombie movies or zombie shows, don't watch it. But if zombie and apocalypse is your cup of tea, Last One of Us is so good.

**中文翻译:**
好。我刚看了 Netflix 上的《怒呛人生》（Beef）。太棒了，我不会剧透，你们应该去看看，这是一部限定剧。我还喜欢 HBO 的《副总统》（Veep），太搞笑了。整部剧我可能已经看了两遍，可能还会再看，因为每次都能让我笑翻。我觉得我们的政府实际上就是那样运作的，所以我对此很着迷。最后一部我很喜欢的是《最后生还者》（The Last of Us），第二季快出了，所以你应该赶快补完第一季。如果你不喜欢丧尸片，那就别看；但如果你喜欢丧尸和末世题材，《最后生还者》真的非常棒。

---

### [01:28:44] Lenny Rachitsky

**English:**
Or the Last of Us? Or Last One of Us? Last of Us.

**中文翻译:**
是《最后生还者》（The Last of Us）吗？

---

### [01:28:44] Elena Verna

**English:**
Is it Last of Us?

**中文翻译:**
是叫《最后生还者》吗？

---

### [01:28:48] Lenny Rachitsky

**English:**
I'm Googling while we talk, Last of Us. I think it's Last of Us. Yeah, the Last of Us.

**中文翻译:**
我边聊边搜，是《最后生还者》。我想是这个名字。

---

### [01:28:53] Elena Verna

**English:**
Oh, Last of Us. Okay, Last of Us.

**中文翻译:**
哦，《最后生还者》。好的。

---

### [01:28:56] Lenny Rachitsky

**English:**
You're saying there's a third season coming soon. That's exciting. I didn't know that.

**中文翻译:**
你是说第三季快出了？那太让人兴奋了，我之前不知道。

---

### [01:28:58] Elena Verna

**English:**
Yeah, it's so good.

**中文翻译:**
是的，非常棒。

---

### [01:29:00] Lenny Rachitsky

**English:**
Okay, I love it as well. Great pick. Okay. Your favorite product you recently discovered that you really like?

**中文翻译:**
好，我也很喜欢。选得好。下一个：你最近发现并非常喜欢的电子产品或产品是什么？

---

### [01:29:08] Elena Verna

**English:**
I recently discovered that they make heated shoes and that changed my life. My feet are always cold and they are boots that actually have heated wires through them and I'm obsessed.

**中文翻译:**
我最近发现竟然有“发热鞋”，这改变了我的生活。我的脚总是很冷，那些靴子里真的有发热丝，我简直着迷了。

---

### [01:29:22] Lenny Rachitsky

**English:**
And are you like charging it, like USB plugin kind of thing?

**中文翻译:**
你是怎么给它充电的？像 USB 插件那种吗？

---

### [01:29:25] Elena Verna

**English:**
Yeah, I just come in, I plug them in and then I go outside and I'm warm and I think it's magical. I have a jacket, also heated jacket, now I have shoes. I just need my gloves and I'll be all set.

**中文翻译:**
是的，我回来就把它们插上电，然后出门时就很暖和，我觉得这太神奇了。我有一件发热夹克，现在有了发热鞋，我只需要再买副发热手套就齐活了。

---

### [01:29:40] Lenny Rachitsky

**English:**
I love the USB powered clothing. And we should know you live not in Silicon Valley, you live on the East Coast sort of?

**中文翻译:**
我喜欢 USB 供电的衣物。顺便说一下，你不住在硅谷，你住在东海岸那边？

---

### [01:29:46] Elena Verna

**English:**
Central. In Central. The coldest it gets is 30s here, but I'm always cold, so this is just my love language is something heated that I can sit on. I'm that cat sits underneath the light all the time. And then I also just got AirPod Max, my headphones. I couldn't connect it to my computer. Still technical issues on that, but I love them. The sound is amazing. That's my new favorite gadget that I'm obsessed about.

**中文翻译:**
中部，在美中地区。这里最冷的时候大概是华氏 30 多度（约 0 摄氏度），但我总是觉得冷，所以我的“爱之语”就是能坐在发热的东西上面。我就是那种总是蹲在灯光下的猫。另外，我刚买了 AirPod Max 耳机。虽然还没连上电脑（还有点技术问题），但我很喜欢它们，音质太棒了。这是我最近痴迷的新玩意儿。

---

### [01:30:14] Lenny Rachitsky

**English:**
What a cool combination, heated shoes and AirPods. Two more questions. Do you have a favorite life motto that you often come back to that you find useful in work and life?

**中文翻译:**
发热鞋配 AirPods，真是酷炫的组合。最后两个问题：你有没有什么常用的人生格言，觉得在工作和生活中都很有用？

---

### [01:30:25] Elena Verna

**English:**
Yeah, it's really one, progress over perfection. I think that you just need to... The velocity of information is far more important than something that I think is perfect and perfection is an outcome that you get to. But progress over perfection all day, any day.

**中文翻译:**
有的，就是那句：完成胜过完美（Progress over perfection）。我认为信息的获取速度远比我认为的“完美”更重要，完美只是你最终达到的一个结果。无论何时何地，完成都胜过完美。

---

### [01:30:47] Lenny Rachitsky

**English:**
Very appropriate for a head of growth person.

**中文翻译:**
非常适合增长负责人。

---

### [01:30:51] Elena Verna

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:30:51] Lenny Rachitsky

**English:**
Final question. You're not only one of the smartest people I've met on growth, you're also one of the funniest people on social media, especially on LinkedIn. If people aren't following you, they should. They will not only learn, they'll also be highly entertained. Is there a favorite meme that you created that you are very proud of that you can describe that we might want to link to?

**中文翻译:**
最后一个问题。你不仅是我见过的在增长领域最聪明的人之一，也是社交媒体（尤其是 LinkedIn）上最幽默的人之一。如果大家还没关注你，一定要去关注。他们不仅能学到东西，还能获得极大的娱乐。你有没有什么自己创作的、非常自豪的表情包（meme）可以描述一下？我们可以附上链接。

---

### [01:31:13] Elena Verna

**English:**
Yeah, so I also want to say a lot of people hate me for doing so much memes as well because they think it's not serious. And I actually, I want to rebuttal that really quickly because I think humor is the best way to disarm people and to point out very painful situations that we're facing with every single day or conundrums without putting anybody on defense. Because we can all laugh at the absurdity of the lives that we live in every single day. And a picture's worth a thousand words. And sometimes memes are just the best way to communicate the most complex situations that we are facing within our corporate world. And they help us understand how common all of those situations are. We're not unique. You're not feeling alone by feeling down about what happened. Everybody's going through the same thing. So that's why I love memes because they help connect people on both sides.

**中文翻译:**
好。我也想说，很多人因为我发太多表情包而讨厌我，觉得我不够严肃。我想快速反驳一下：我认为幽默是解除人们武装的最好方式，它能指出我们每天面临的痛苦处境或难题，而不会让任何人产生防御心理。因为我们都可以对日常生活的荒谬一笑了之。一图胜千言。有时，表情包是沟通我们在公司世界中面临的最复杂情况的最佳方式。它们帮助我们理解这些情况是多么普遍。我们并不独特。当你因为发生的事情感到沮丧时，你并不孤单，每个人都在经历同样的事情。这就是为什么我喜欢表情包，因为它们能连接各方。

(01:32:05):
**English:**
Even if you're making fun of one side because they're like, yeah, that is true and this is so funny. So I'm a big proponent of that just because I think it's actually a better way to both unite people and just talk about hard problems that otherwise would be not read if you put it in words. But my favorite meme is actually one of the first ones that I've created and I think it's from Family Guy where they have an elephant and the penguin standing and then there's Moses I think, or some biblical character saying, "What the hell is this?" Looking at the elephant and the penguin. And the result of it is a child that has a penguin body and an elephant head. And if you think about elephant as product and penguin as marketing, what the hell is this is gross. Which is a byproduct, a weird, weird byproduct, product and marketing merged together that doesn't really fit with either, yet it's its own entity. I don't know. I think that that's the best to describe to people what [inaudible 01:33:14] is.

**中文翻译:**
即使你是在取笑某一方，他们也会觉得：“是的，那是真的，太搞笑了。”所以我非常支持这种方式，因为它能团结人们，并以一种如果写成文字可能没人会读的方式来讨论难题。我最喜欢的表情包其实是我最早创作的之一，我想是来自《盖酷家庭》（Family Guy）：有一头大象和一只企鹅站在一起，然后摩西（或者某个圣经人物）看着大象和企鹅问：“这到底是个什么玩意儿？”结果产下的后代是企鹅的身体和大象的头。如果你把大象看作“产品”，把企鹅看作“营销”，那么这个“到底是什么玩意儿”的东西就是“增长”（Growth）。它是一个副产品，一个非常奇怪的副产品，是产品和营销融合在一起，既不完全属于任何一方，却又是一个独立的实体。我觉得这是向人们描述增长是什么的最好方式。

---

### [01:33:14] Lenny Rachitsky

**English:**
So appropriate. Also, it's hard to describe a meme and make it feel funny. So good job. Thank you for doing that. We'll link to this meme in our show notes. Elena, this was incredible. Thank you again. Thank you for being our first ever third return guest. Hopefully there will be many more episodes of Elena Verna. Two final questions. Where can folks find you online if they want to reach out and learn more and how can listeners be useful to you?

**中文翻译:**
太贴切了。而且，描述一个表情包并让它听起来好笑是很困难的，你做得很好。谢谢。我们会在节目笔记中附上这个表情包的链接。Elena，这太精彩了。再次感谢你，感谢你成为我们首位三次回归的嘉宾。希望未来还有更多 Elena Verna 的节目。最后两个问题：如果大家想联系你或了解更多信息，可以在哪里找到你？听众能为你做些什么？

---

### [01:33:37] Elena Verna

**English:**
Find me on LinkedIn or my Substack. I'm not competing with you Lenny, but I share a lot of my thoughts and everything that I learned on my own Substack. It's just elenaverna.com. LinkedIn is for all of my memes, so go there if you want to laugh, but if you want to learn from what I'm learning, go to my Substack. And how you can be useful? Tell me what problems you're facing now. Don't tell me, oh, how growth is slowing down, what should I do? I can't help you with that, too broad, but if you're having a situation, there's often really good [inaudible 01:34:09] for me to go and write about it or to do more research about it. So I just love to hear what some people's minds, so I can both help them connect their dots as well as learn about it myself.

**中文翻译:**
在 LinkedIn 或我的 Substack 上找我。Lenny，我不是在和你竞争，但我会在我自己的 Substack 上分享很多想法和我学到的东西，网址是 elenaverna.com。LinkedIn 是发表情包的地方，如果你想笑就去那里；如果你想学习我正在学习的东西，就去我的 Substack。至于大家能帮我做什么？告诉我你现在面临的问题。不要只说“哦，增长放缓了，我该怎么办？”，那太宽泛了，我帮不了你。但如果你有一个具体的情况，那通常是我去写作或做更多研究的好素材。我喜欢听听大家在想什么，这样我既能帮他们理清思路，自己也能从中学习。

---

### [01:34:20] Lenny Rachitsky

**English:**
And what's the best way for them to do that? Is it like DM me on LinkedIn, any other-

**中文翻译:**
那最好的方式是什么？在 LinkedIn 上私信你，还是别的？

---

### [01:34:24] Elena Verna

**English:**
DM me on LinkedIn or just reply to my Substack newsletter email. It goes directly into my personal inbox, so I read every single one of them.

**中文翻译:**
在 LinkedIn 上私信我，或者直接回复我的 Substack 邮件。回复会直接发到我的个人收件箱，每一封我都会读。

---

### [01:34:32] Lenny Rachitsky

**English:**
That is a really good tip. People don't know that when you get an email on Substack, if you reply, just goes straight to the author.

**中文翻译:**
这是一个非常好的提示。很多人不知道，当你收到 Substack 的邮件并回复时，它会直接发给作者。

---

### [01:34:37] Elena Verna

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:34:38] Lenny Rachitsky

**English:**
Elena, thank you so much for being here.

**中文翻译:**
Elena，非常感谢你能来。

---

### [01:34:41] Elena Verna

**English:**
Okay, thank you for having me, Lenny.

**中文翻译:**
好的，谢谢你的邀请，Lenny。

---

### [01:34:43] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at LennysPodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 LennysPodcast.com 找到所有往期节目或了解更多信息。下期节目再见。