# Elena Verna 4.0 - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Elena Verna.

---

### [00:00:00] Lenny Rachitsky

**English:**
You're ahead of growth at Lovable on track to be the fastest or one of the fastest growing companies in history.

**中文翻译:**
你是 Lovable 的增长负责人，这家公司正有望成为历史上增长最快或最快的公司之一。

---

### [00:00:06] Elena Verna

**English:**
We're over 200 million in ARR. At this point, we're 100 people large, the pace here is insane.

**中文翻译:**
我们的年度经常性收入（ARR）已经超过了 2 亿美元。目前我们只有 100 人的规模，这里的节奏简直疯狂。

---

### [00:00:12] Lenny Rachitsky

**English:**
You said that you've had to throw out most of your growth playbook.

**中文翻译:**
你说过你不得不扔掉大部分以前的增长手册（Playbook）。

---

### [00:00:14] Elena Verna

**English:**
I feel like only 30 to 40% of what I've learned in the last 15 to 20 years of being in growth transfers here because we just need to invest in such bigger bets, and innovate, and create new growth loops here, everybody and their mother is starting a vibe coding business nowadays, and we need to figure out how to be ahead of them. And to be ahead of them is not optimization of the problem, it's reinvention of the solution. I just feel like I usually spend maybe 5% innovating on growth in my previous roles, right now, I'm spending 95% innovating on growth, and only 5% on optimization.

**中文翻译:**
我觉得过去 15 到 20 年增长生涯中学到的东西，只有 30% 到 40% 能迁移到这里。因为我们必须投入更大的赌注，去创新，去创造新的增长循环。现在几乎所有人都在搞“氛围编程”（vibe coding，指通过 AI 直觉化编程）业务，我们需要想办法领先于他们。而要保持领先，靠的不是对问题的优化，而是对解决方案的重塑。我感觉以前在其他职位上，我可能只花 5% 的时间在增长创新上，而现在，我 95% 的精力都在创新，只有 5% 在做优化。

---

### [00:00:48] Lenny Rachitsky

**English:**
What do you find is actually moving the needle?

**中文翻译:**
你发现真正能产生实质影响（Moving the needle）的是什么？

---

### [00:00:50] Elena Verna

**English:**
One of our biggest strategy is building in public, and it's coupled with employee socials, founder-led socials. And another one is giving your product away a lot, this is part of our growth secret sauce. You have to remove the barrier of entry. If somebody, one of our users stands up and say, hey, I'm going to have a hackathon at my work on Lovable, can you give us some free credits to play with? Why would we prevent a person who wants to do all of the marketing and activating for us from using us? We're like, take it, how much do you need?

**中文翻译:**
我们最大的策略之一是“公开构建”（Building in public），并结合员工社交媒体和创始人主导的社交宣传。另一个策略是大量免费赠送产品，这是我们增长的“秘密酱汁”。你必须消除准入门槛。如果我们的一个用户站出来说：“嘿，我要在公司举办一场基于 Lovable 的黑客松，能给我们一些免费额度吗？”我们为什么要阻止一个愿意为我们做所有营销和激活工作的人呢？我们会说：“拿去吧，你需要多少？”

---

### [00:01:22] Lenny Rachitsky

**English:**
The trick is get more people to try it, just ship things you can talk about.

**中文翻译:**
秘诀就是让更多人去尝试，只发布那些值得被谈论的东西。

---

### [00:01:25] Elena Verna

**English:**
The only way to create a word of mouth loop is just to blow their socks off.

**中文翻译:**
创造口碑循环的唯一方法就是让他们彻底惊艳（Blow their socks off）。

---

### [00:01:31] Lenny Rachitsky

**English:**
Today, my guest is Elena Verna, head of growth at Lovable. In under one year after launching, with fewer than 100 people, Lovable hit 200 million ARR, which is one of, if not the fastest ramp to 200 million ARR in history, and growth is still accelerating. They've also recently raised a series B at a $6 billion valuation. So, with that, there's a lot to learn about what Lovable has figured out about growth. This is Elena's fourth visit to the podcast, a record, she is my favorite growth mind, and in our conversation, we talk about how the growth playbook has fundamentally changed for AI companies. What works now, what no longer works, and what has surprised her most about how Lovable grows.

**中文翻译:**
今天的嘉宾是 Lovable 的增长负责人 Elena Verna。在上线不到一年的时间里，Lovable 凭借不到 100 人的团队，ARR 突破了 2 亿美元，这即使不是历史上最快达到 2 亿 ARR 的记录，也是最快之一，而且增长仍在加速。他们最近还以 60 亿美元的估值完成了 B 轮融资。因此，关于 Lovable 在增长方面的经验，有很多值得学习的地方。这是 Elena 第四次来到本播客，创下了记录。她是我最喜欢的增长专家。在我们的对话中，我们讨论了 AI 公司的增长手册发生了怎样的根本性变化。现在什么有效，什么不再有效，以及 Lovable 的增长方式中哪些最让她感到意外。

---

### [00:02:13] Lenny Rachitsky

**English:**
She also shares her advice about whether working at an AI company is right for you, some incredibly interesting insights into Lovable's secret sauce for growth, the unique ways they operate internally, their approach to building minimal, Lovable products, also how they hire, and also how product market fit as a concept is no longer what it used to be, and how every company basically has to recapture product market fit every three months. This episode is incredibly tactical, and you will leave this conversation smarter on so many levels. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube.

**中文翻译:**
她还分享了关于“在 AI 公司工作是否适合你”的建议，以及 Lovable 增长秘诀中一些非常有趣的见解：他们独特的内部运营方式、构建“最小可爱产品”（Minimal Lovable Products）的方法、招聘方式，以及“产品市场契合”（PMF）这一概念如何不再像以前那样一劳永逸，基本上每家公司每三个月就得重新寻找一次 PMF。这一集的内容极具实操性，你会从多个维度变得更睿智。如果你喜欢这个播客，别忘了在你的播客应用或 YouTube 上订阅和关注。

---

### [00:02:47] Lenny Rachitsky

**English:**
And if you become an annual subscriber of my newsletter, you get a year free of 19 incredible premium products, including a year free of Lovable, Replit, Bolt, n8n, Linear, Devin, PostHog, Superhuman, Descript, Wispr Flow, Perplexity, Warp, Granola, Magic Patterns, raycast, ChatPRD, Mobbin, and Stripe Atlas. Head on over to Lennysnewsletter.com and click Product Pass. With that, I bring you Elena Vernon, after a short word from our sponsors. [Sponsor messages for WorkOS and v0 by Vercel omitted for brevity in this translation, but available in original text].

**中文翻译:**
如果你成为我时事通讯（Newsletter）的年度订阅者，你将免费获得 19 款顶级付费产品的一年使用权，包括 Lovable, Replit, Bolt, n8n, Linear, Devin, PostHog, Superhuman, Descript, Wispr Flow, Perplexity, Warp, Granola, Magic Patterns, raycast, ChatPRD, Mobbin 和 Stripe Atlas。请访问 Lennysnewsletter.com 并点击 Product Pass。接下来，在听完赞助商的简短介绍后，我将为你带来 Elena Verna 的访谈。[WorkOS 和 Vercel v0 的赞助广告略]。

---

### [00:05:24] Elena Verna

**English:**
Thank you for having me.

**中文翻译:**
谢谢你邀请我。

---

### [00:05:26] Lenny Rachitsky

**English:**
As you know, this is a record fourth time back to the podcast, no one else has ever achieved this feat. I feel like you're basically my co-host now.

**中文翻译:**
如你所知，这是你第四次回到这个播客，创下了记录，还没人能达到这个成就。我觉得你现在基本上就是我的联合主持人了。

---

### [00:05:36] Elena Verna

**English:**
I love it. Thank you for inviting me back, I'm very proud record holder in this regard.

**中文翻译:**
我很喜欢这个说法。谢谢你再次邀请我，我很自豪能成为这个记录的保持者。

---

### [00:05:41] Lenny Rachitsky

**English:**
What I love about you coming back each time, it feels like every time you come back, you're just doing something even more epic and exciting. And so, these days, as we'll hear in the intro, you're head of growth at Lovable, which no big deal on track to be the fastest or one of the fastest growing companies in history, depending on the metric that you track. Let's talk about just the scale and growth of Lovable to give people a sense of just how incredible this is. I'll share a bit of this in intro, but just what are some stats you can share about just how things are going Lovable?

**中文翻译:**
我最喜欢你每次回来的地方在于，感觉你每次回来都在做一些更宏大、更令人兴奋的事情。正如我们在开场白中听到的，你现在是 Lovable 的增长负责人。这家公司正处于成为历史上增长最快（或最快之一）的轨道上，这取决于你追踪的指标。让我们谈谈 Lovable 的规模和增长，让大家感受一下这有多不可思议。我在介绍中提到了一些，但关于 Lovable 的现状，你还能分享哪些数据？

---

### [00:06:08] Elena Verna

**English:**
So, we are just a little bit over one year's old since we launched. The company actually did exist as a GPT engineer before, but it officially launched in the third week of November last year, in 2024. So, for us, we've hit over $200 million in annual recurring revenue before we even hit our one-year milestone since being launched. Which is pretty incredible. You, Lenny, actually have a really great blog post on how quickly it takes for companies usually to get to their first million ARR, and it's usually multiple years. So, this is definitely a unicorn, I don't think this is a standard. There's a couple of things that account for it, and we can talk about it, and the growth is only accelerating, so it's compounding, which is great. Because we had our 100 million in end of July, and just four months later we were at 200 million.

**中文翻译:**
我们上线刚满一年多一点。公司之前其实是以 GPT Engineer 的身份存在的，但正式上线是在去年（2024年）11 月的第三周。所以，我们在上线不到一年的时间里，年度经常性收入（ARR）就突破了 2 亿美元。这确实很不可思议。Lenny，你其实写过一篇非常棒的博客，讲的是公司通常需要多长时间才能达到第一个 100 万美元的 ARR，通常需要好几年。所以这绝对是个“独角兽”，我不认为这是常态。有几个原因促成了这一点，我们可以聊聊。而且增长还在加速，正在产生复利效应，这很棒。因为我们在 7 月底达到了 1 亿 ARR，仅仅四个月后就达到了 2 亿。

---

### [00:07:02] Elena Verna

**English:**
So, seven months to, well, maybe eight months, to 100 million, another four months to get to 200 million. And from users too, we already have over eight million users that have tried Lovable, we have, as you can imagine, to feed that 200 million, hundreds of thousands of paid subscribers as well that are paying for us, so things are going great and we'll talk about why.

**中文翻译:**
所以，用了七个月，或者说八个月达到 1 亿，又用了四个月达到 2 亿。在用户方面，已经有超过 800 万用户尝试过 Lovable。你可以想象，为了支撑那 2 亿的收入，我们还有数十万的付费订阅用户。所以一切进展顺利，我们会讨论其中的原因。

---

### [00:07:27] Lenny Rachitsky

**English:**
Okay. Absurd. I think people are getting used to these insane numbers, and not long ago is like, okay, if you hit a million ARR in a year, you're doing pretty well.

**中文翻译:**
太荒谬了。我觉得人们已经开始习惯这些疯狂的数字了，而在不久前，如果你能在一年内达到 100 万 ARR，就已经表现得很出色了。

---

### [00:07:36] Elena Verna

**English:**
Yeah, yeah. I think still you're doing pretty well if you have a million ARR in one year. This is one of the once in a lifetime type of companies, and the category, the way that it's evolving. So, I want to make sure that people don't all of a sudden set this as a benchmark for success because it should never be. In some categories, it might be even faster as we continue evolving technology, but I don't think that it's realistic to expect it out of your business that you're starting right now.

**中文翻译:**
没错。我觉得如果你能在一年内达到 100 万 ARR，依然是非常出色的。这是一家“一生难遇一次”的公司，而且这个品类的演变方式也很特殊。所以，我希望大家不要突然把这当作成功的基准，因为它绝不应该是基准。在某些领域，随着技术的演进，可能会更快，但我认为对于你现在正在创办的企业来说，期望这种速度是不现实的。

---

### [00:08:08] Lenny Rachitsky

**English:**
That is such an important point you're making there, it's so discouraging to founders to hear these stories of getting 200 million. And again, this is ARR. There's a lot of companies, especially in the data labeling space, I've had them all on the podcast, that are very fast-growing, but they're not recurring revenue. There's also, they pay out their people to do this data labeling. So, the revenue numbers there don't really equate. Recurring $200 million a year is absurd.

**中文翻译:**
你提到的这一点非常重要。对于创始人来说，听到这种达到 2 亿规模的故事可能会很受打击。而且再强调一次，这是 ARR（经常性收入）。有很多公司，特别是在数据标注领域，我都请他们上过播客，他们增长很快，但不是经常性收入。而且他们还要付钱给标注员，所以那些收入数字并不对等。一年 2 亿美元的经常性收入简直是天文数字。

---

### [00:08:36] Elena Verna

**English:**
Yeah, it is absurd. I really want to make sure that people understand as we go through this episode as to why it's happening, because part of it is on Lovable, part of it is just in the market and how it's moving. So, when you're setting yourself as a benchmark, so you know which benchmarks you actually to use, and whether Lovable is the benchmark that you should be using.

**中文翻译:**
是的，很荒谬。我真的希望在这一集中让大家理解为什么会发生这种情况，因为一部分原因在于 Lovable 自身，另一部分在于市场及其走向。这样当你设定自己的基准时，你就会知道该参考哪些指标，以及 Lovable 是否是你应该参考的基准。

---

### [00:09:19] Lenny Rachitsky

**English:**
Cool. I'm going to get into that next. Last question, just I want to see what you can share here. A lot of people look at these numbers, a lot of people are very skeptical these are lasting, durable numbers. Like who are these people? How is there $200 million being spent on Lovable? Anything you can add about, just give people confidence, is this real, this is going to last, this is a really durable business.

**中文翻译:**
太好了，接下来我们就聊这个。最后一个问题，我想看看你能分享些什么。很多人看到这些数字会非常怀疑它们是否持久、稳固。比如，这些用户是谁？怎么会有 2 亿美元花在 Lovable 上？关于这一点你有什么补充，能让大家有信心相信这是真实的、可持续的、是一个真正稳固的业务吗？

---

### [00:09:19] Elena Verna

**English:**
Well, I saw Stripe receipts, so it is real, as far as I'm concerned, unless Stripe dashboard is lying to us. But it is money getting deposited in our bank account. But let's talk about who is actually contributing to that number. We do have a really large use case of people starting their own companies on Lovable, so we call it a founder use case. Where somebody that is non-technical, that has never been able to code or create a piece of software is now able to come in and actually build an app completely from scratch. And some of them are already monetizing it, some of it just using it [inaudible 00:09:52] for other services, or some physical goods, for example, that they're selling. Some of them are just still building. And we monetize on the act of building, so that progression of building up to your product market fit takes quite a bit of time.

**中文翻译:**
嗯，我亲眼看到了 Stripe 的收据，所以据我所知它是真实的，除非 Stripe 的仪表盘在骗我们。钱确实存进了我们的银行账户。让我们聊聊到底是谁在贡献这些数字。我们有一个非常庞大的用例，就是人们在 Lovable 上创办自己的公司，我们称之为“创始人用例”。一些非技术背景、从未写过代码或开发过软件的人，现在可以进来从零开始构建一个完整的应用。其中一些人已经开始变现了，有些是用于其他服务，或者销售实物商品。还有一些人仍在构建中。我们的变现点在于“构建”这个行为，而从构建到达到产品市场契合（PMF）的过程是需要相当长的时间的。

---

### [00:10:06] Elena Verna

**English:**
And even with Lovable, we're so much more efficient and effective compared to hiring an engineer in terms of the price, but it still takes time. So, we have a lot of founders, whether it's B2C, whether there's B2B, so consumer products, business products, e-commerce, whatever it is. But on the other side, we have a lot of employees within companies using Lovable as well, where they're building internal tools, or they're building prototypes, they're building landing pages. So, that is another use case that is very relevant and quite efficient for us, but then there is a hype and discovery that is happening as well. Because when I think about software, I think about it, I talked to John Cutler actually, and he gave me this framework that is completely stuck in my mind, of software always goes through capabilities stage first, so what is possible to actually create with this?

**中文翻译:**
即使有了 Lovable，虽然在价格上比雇佣工程师高效得多，但仍然需要时间。所以我们有很多创始人，无论是做 B2C 还是 B2B，消费品、商业产品、电子商务等等。另一方面，我们也有很多公司内部的员工在使用 Lovable，他们用它构建内部工具、原型或落地页。这是另一个非常相关且对我们来说很高效的用例。此外，还有一种“热度与探索”正在发生。当我思考软件时，我想到 John Cutler 给我讲过的一个框架，它深深印在我的脑海里：软件总是先经历“能力阶段”，即：用这个东西到底能创造出什么？

---

### [00:11:00] Elena Verna

**English:**
Then, it needs to transition into value, of how is it that am I going to get value out of this? And then you can start thinking about scaling it, of which aspects of my life and my work that can actually go in? And we're right now very much in the capability stage with vibe coding, because everybody's just exploring, what can I do? And the beautiful thing here is that what you can do changes every month to three months. So, you constantly need to come back and you need to see what has changed. So, a lot of people use it for personal reasons. I build myself apps, tutoring apps for my kid, so he has to answer questions in order to get some screen time accumulated for him. I build my own portfolio.

**中文翻译:**
然后，它需要过渡到“价值阶段”，即：我如何从中获得价值？接着你才能开始考虑“规模化”，即：我生活和工作的哪些方面可以引入它？目前在“氛围编程”领域，我们还处于能力阶段，因为大家都在探索：我能做什么？最美妙的一点是，你能做的事情每隔一到三个月就会发生变化。所以你需要不断回来看看有什么新进展。很多人出于个人原因使用它。我给自己开发应用，比如给我孩子的辅导应用，他必须回答问题才能积累看屏幕的时间。我还构建了自己的作品集。

---

### [00:11:40] Elena Verna

**English:**
I see people doing wonderful things, my favorite story that I always say, there's this man that created a proposal on Lovable. So, his fiance had to answer questions and she had to complete this game, and then at the end there was this big reveal and he proposed to her. But people just unlock the most creative things that they build on Lovable, and that's where the revenue is coming from. The one piece that is working very well for us in terms of how our monetization model is, set up and how it interjects with your activation moment, which we can also cover, but that is what's driving both conversion and retention rates.

**中文翻译:**
我看到人们在做各种精彩的事情。我最喜欢讲的一个故事是，有个男人在 Lovable 上做了一个求婚应用。他的未婚妻必须回答问题并完成游戏，最后是大揭秘，他向她求婚。人们在 Lovable 上解锁了极其富有创意的构建，这就是收入的来源。我们的变现模型设置得非常好，它与用户的“激活时刻”紧密结合（我们稍后也可以聊聊这个），这正是推动转化率和留存率的关键。

---

### [00:12:17] Lenny Rachitsky

**English:**
Let me ask you one question that's on people's minds, I imagine, as you talk about this, just what does retention look like?

**中文翻译:**
我想问一个大家肯定都在想的问题：留存率（Retention）看起来怎么样？

---

### [00:12:22] Elena Verna

**English:**
Yeah. So, retention, really, I look at it in two ways, retention, that it comes as a subscriber retention. So, how much [inaudible 00:12:32] subscribers do we get, and how many of them are we capable of renewing? There's also very important aspect of it is, how many of them can we expand? Because if you can get positive or above 100% net dollar retention, which is super important metric for investors... If you don't know about net dollar retention, please read it up, that's like a superpower to get bigger multiple if you can show NDR that is over 100. And then there's actually engagement retention as well, because that is the leading indicator for how your paid retention is going to look like. For paid retention, I know there is so much on the market of, oh, this is a high product, and it's a leaky bucket, and it has really high churn rates.

**中文翻译:**
好的。关于留存，我主要从两个方面来看。首先是订阅用户留存：我们获得了多少订阅者，其中有多少能续订？还有一个非常重要的方面是“扩张”：我们能从现有用户中挖掘多少增量？如果你能获得正向或超过 100% 的净金额留存率（NDR），这对投资者来说是极其重要的指标。如果你还不了解 NDR，请去查一下，如果你能展示超过 100 的 NDR，那是获得更高估值倍数的“超能力”。其次是参与度留存（Engagement Retention），因为它是付费留存的领先指标。关于付费留存，我知道市场上有很多说法，比如“这只是个热度产品”、“它是个漏水桶”、“流失率极高”。

---

### [00:13:10] Elena Verna

**English:**
Although, I shouldn't share, it's not public numbers for us to share actual retention, however, what I can say, it's on par with benchmarks of other B2B SaaS products that I've ever worked at. And I worked with Miro, Dropbox, SurveyMonkey, Netlify, Amplitude, and others. So, are we absolutely crushing with paid retention? No. Are we where most of the other companies are? Yes. Our NDR is quite good because when people build, they want to buy more credits to build. So, we're seeing really good revenue retention, but we're honestly more focused right now on engagement retention than even paid retention because our North Star is just to get as much usage as possible, and we will fix and tune our monetization model afterwards. So, engagement retention, I would say, is a by far bigger priority focus for us at the moment.

**中文翻译:**
虽然我不该分享，因为实际留存率不是公开数据，但我可以告诉你的是，它与我工作过的其他 B2B SaaS 产品的基准持平。我曾在 Miro, Dropbox, SurveyMonkey, Netlify, Amplitude 等公司工作过。那么，我们的付费留存是绝对碾压级的吗？不是。我们是否处于大多数公司的平均水平？是的。我们的 NDR 相当不错，因为当人们在构建时，他们会想购买更多额度。所以我们看到了非常好的收入留存。但坦白说，比起付费留存，我们现在更关注参与度留存，因为我们的北极星指标是尽可能获得更多的使用量，之后我们再去调整和优化变现模型。所以，参与度留存目前是我们优先级最高的关注点。

---

### [00:14:04] Lenny Rachitsky

**English:**
That is incredibly interesting, and I'm optimistic to hear because of the growth rate. Rarely is growth rate this high and retention is on par with great companies.

**中文翻译:**
这非常有趣，听到这个我很乐观。很少有增长率这么高，同时留存率还能与优秀公司持平的情况。

---

### [00:14:15] Elena Verna

**English:**
Yeah. And I'll just say too, which is a little bit maybe counterintuitive would be to a lot of companies, we don't optimize for revenue at all. In fact, internally, we have a lot of discussions about how can we give more products away, how can we reduce our revenue growth rate by just getting more paid subscribers, more users using Lovable, to just get bigger share of the market. So, our revenue is an outcome of us just trying to get more people through the door, not us trying to optimize for revenue per user, or to get them to monetize at the higher rate. So, there's a very interesting path here, where, by actually focusing on the inputs, like you should, it translates to a good output, but we don't look at that output as something that we're trying to grow.

**中文翻译:**
是的。我还要说一点，对很多公司来说可能有点反直觉：我们根本不针对收入进行优化。事实上，在内部，我们有很多讨论是关于如何赠送更多产品，如何通过吸引更多付费订阅者和用户使用 Lovable 来降低收入增长率（相对值），从而获得更大的市场份额。所以，我们的收入只是我们努力吸引更多人进门的一个“结果”，而不是我们试图优化人均收入或提高变现率的目标。这是一个非常有趣的路径：通过专注于你应该关注的“投入”，它转化为了良好的“产出”，但我们并不把那个产出看作我们要刻意增长的东西。

---

### [00:15:02] Lenny Rachitsky

**English:**
Let's talk about growth, let's talk about what you've learned about growth in this space. You had this post online where you said that you've had to throw out most of your growth playbook. This is a huge deal, you've led growth a lot of really successful companies. Lovable is growing incredibly well, this tells me there's a lot we can learn from what you've seen. So, tell us what you're seeing, what's still working, what's not working, what you've learned about what it takes to drive growth at a company like Lovable.

**中文翻译:**
让我们聊聊增长，聊聊你在这一领域学到的东西。你在网上发过一篇文章，说你不得不扔掉大部分增长手册。这可是件大事，你曾在很多非常成功的公司领导过增长。Lovable 增长得如此之快，这说明从你的见解中有很多值得学习的地方。所以，告诉我们你看到了什么，什么依然有效，什么不再有效，以及在 Lovable 这样的公司推动增长需要具备什么。

---

### [00:15:28] Elena Verna

**English:**
Yeah. I would say that in any other role that I've come into before, I felt confident in about 80% of the patterns that I can bring to that role, meaning that I can identify inputs, understand which framework applies. I know a lot of examples that fit in within that framework, so we just need to localize a solution and push, and it was quite productive in terms of getting a company those additional acquisition, conversion, engagement, monetization rates. So, I felt very repetitive in a way, after some time, because I feel like I'm just coming in and copy, pasting, copy, pasting... And although every single company loves to say that they have unique problems, at the end of the day, all of the problems were very similar. And I felt like I was doing the same job over and over again. When I started at Lovable, the one thing to me that was very clear is that this company was growing like crazy before I joined.

**中文翻译:**
是的。我想说，在以前我担任的任何职位中，我对自己能带入该职位的模式（Patterns）大约有 80% 的信心。这意味着我可以识别投入，理解适用哪个框架。我知道很多符合该框架的例子，所以我们只需要将解决方案本地化并推进，在获取、转化、参与和变现率方面就会非常高效。所以，一段时间后，我感到某种程度上的重复，感觉自己只是在不断地复制、粘贴、复制、粘贴……虽然每家公司都喜欢说自己有独特的问题，但归根结底，所有问题都非常相似。我觉得自己一遍又一遍地做着同样的工作。当我开始在 Lovable 工作时，有一点对我来说非常明确：在我加入之前，这家公司就已经在疯狂增长了。

---

### [00:16:21] Elena Verna

**English:**
So, I want to make sure that there's not that much value on what I have even added today, because this company is on the tear, and yes, we're rounding the edges and removing barriers for growth, so we're not standing in our own way, but there's something more magical happening here that is not a pattern that I've ever seen before. It's not a framework that I can even conceptualize in my head. And plus, it's a new category that I've never seen, or I've never been in a company that is in a new emerging category, that hits fast moving water so quickly. And that's the difference because when you're usually trying to create a new category, it takes years. I know it's every marketer's dream to create a new category, but it takes decades often to really get that much hype and adoption around it. Versus with vibe coating, this hype seemed to have happened really quickly.

**中文翻译:**
所以，我想明确一点，我今天所做的贡献可能并没有那么大的价值，因为这家公司本身就势如破竹。是的，我们在修剪边缘、消除增长障碍，确保我们不挡自己的路，但这里发生了一些更神奇的事情，那不是我以前见过的任何模式。它甚至不是我脑海中能构思出的框架。此外，这是一个我从未见过的全新类别，或者说我从未在一家处于新兴类别、且如此迅速进入“湍流期”的公司待过。这就是区别，因为通常当你试图创建一个新类别时，需要好几年。我知道创建新类别是每个营销人的梦想，但通常需要几十年才能获得如此大的热度和采用率。而对于“氛围编程”，这种热度似乎发生得非常快。

---

### [00:17:16] Elena Verna

**English:**
It's like it's hit the nerve with the market. So, yes, we're at the right place, we're at the right time, but we're also in really fast moving waters, and the demand that is coming to us, we need to capture it mostly, we don't need to generate a lot of it yet. But at the same time, it comes with the really big downfalls of we're not in control of a lot of our growth. Let's be honest about it, there's so much incredible word of mouth that is happening, and we're trying to grow that, but to enable as much of that as possible, but the company is moving, we're just hanging on to it as fast as possible, and making sure that we're not going to hit a wall, so to speak, in front of us, and that the wheels are greased, and that all of the pieces are in places. It's like your race car framework that you have as well.

**中文翻译:**
它就像触动了市场的神经。所以，是的，我们在正确的时间出现在了正确的地点，但我们也处于水流极快的地方。对于涌向我们的需求，我们主要需要做的是捕捉它，而不是去创造它。但与此同时，这也带来了一个巨大的弊端：我们无法掌控大部分的增长。坦白说，现在有如此惊人的口碑在传播，我们正努力扩大这种口碑，并尽可能地促成它。但公司跑得太快了，我们只是在拼命跟上，确保我们不会撞到前面的墙，确保轮子润滑良好，所有零件都各就各位。这就像你提到的那个“赛车框架”一样。

---

### [00:18:05] Elena Verna

**English:**
We're really just putting a lot of oil into it, and figuring out what is our engine actually going to be that is going to take us forward. But when I'm thinking about the patterns here, and what I have to unlearn, I feel like only 30 to 40% of what I've learned in the last 15 to 20 years of being in growth transfers here. And some of it is very straightforward, okay, this is how you're going to do paid marketing, this is how you're going to do some of the habitual retention, here's the free to pay maybe monetization frameworks that still stand. But the rest of it, honestly, it doesn't feel like it even matters anymore, because we just need to invest in such bigger bets, and innovate, and create new growth loops here, as opposed to trying to optimize it to the moon and beyond, which I usually be focused on in a scaled business like this.

**中文翻译:**
我们真的只是在不断加油，并弄清楚到底什么样的引擎能带我们前进。但当我思考这里的模式以及我必须“忘掉”的东西时，我觉得过去 15 到 20 年增长经验中只有 30% 到 40% 是适用的。其中一些很直观，比如：如何做付费营销，如何做习惯性留存，还有一些“免费转付费”的变现框架依然成立。但剩下的部分，坦白说，感觉已经不重要了。因为我们需要投入更大的赌注，去创新，去创造新的增长循环，而不是像我在这种规模的业务中通常做的那样，试图把它优化到极致。

---

### [00:18:57] Lenny Rachitsky

**English:**
Let's follow those threads. So, what is it that no longer is worth it in this bucket of just like, let's not spend any time on this thing, and then what do you find is actually moving the needle?

**中文翻译:**
让我们顺着这个思路聊。在“不值得花时间”的那个桶里，有哪些东西？而你发现真正能产生影响的又是什么？

---

### [00:19:06] Elena Verna

**English:**
Not worth it, in growth, most of the people spend most of the time optimizing existing user journeys. So, you already have maybe some of your growth loops that you understand that you try to optimize or you just know, hey, there's big drop-offs from acquisition to activation, let me go figure out how to... I can tweak the dials to get it done. Here, what I find is that optimizations are just not worth our time. So, a lot of the times my growth team actually ends up working on new features, or just standing up new growth loops one after another, and yes, there's of course the saying of more growth loops does not mean more growth, but at the same time, the market is moving so quickly, you need to stand up a bunch of initiatives to capture it because it's perishable.

**中文翻译:**
不值得做的：在增长领域，大多数人把大部分时间花在优化现有的用户旅程上。比如，你已经有了一些你理解的增长循环，你试图优化它们，或者你知道从获取到激活有很大的流失，于是你想办法去微调。但在 Lovable，我发现优化根本不值得我们花时间。所以，很多时候我的增长团队实际上是在开发新功能，或者一个接一个地建立新的增长循环。是的，当然有种说法是“更多的增长循环并不意味着更多的增长”，但与此同时，市场变化太快了，你需要启动一系列举措来捕捉它，因为机会是稍纵即逝的。

---

### [00:19:54] Elena Verna

**English:**
Or we also have so much competition. We're not alone here, so we can't ignore that there's everybody in their mother is starting a vibe coding business nowadays, and we need to figure out how to be ahead of them. And to be ahead of them is not optimization of the problem, it's reinvention of the solution. So, I just feel like I usually spend maybe 5%, maybe 10% if I'm lucky, innovating on growth in my roles, in my previous roles, right now, I'm spending 95% innovating on growth, and only 5% on optimization. And most of my frameworks are on optimization because it's really hard to come up with frameworks for innovation because by default there, by definition, they're innovative.

**中文翻译:**
而且我们的竞争也非常激烈。我们并不孤单，不能忽视现在几乎所有人都在搞“氛围编程”业务，我们需要想办法领先。而保持领先靠的不是优化问题，而是重塑解决方案。所以我感觉，以前在我的职位上，我可能只花 5%，运气好能有 10% 的时间在增长创新上，而现在，我 95% 的时间都在创新，只有 5% 在做优化。我大部分的框架都是关于优化的，因为很难为创新制定框架——根据定义，创新本身就是打破常规的。

---

### [00:20:38] Lenny Rachitsky

**English:**
What I'm hearing here is new features. Launching new features, [inaudible 00:20:42] product is one of the bigger growth levers, versus you have a bunch of cool stuff, make it easier to use, increase activation, reduce friction, things like that.

**中文翻译:**
我听到的是“新功能”。发布新功能是更大的增长杠杆之一，而不是守着一堆酷炫的东西，去让它变得更易用、提高激活率、减少摩擦之类的。

---

### [00:20:51] Elena Verna

**English:**
Yeah. And for example, we on growth team launched integration with Shopify, to enable e-commerce use case, because we're like, hey, there's already people trying to come in and do it, Shopify was open for integration with us, let's go lean into it so people can vibe code their storefronts. That came out of growth, that usually would never come out of growth. Why would growth team ever invest into a core product integration? Or we enabled voice mode for people so they can actually chat with Lovable using their voice, as opposed to only having type. And that's also, it's a feature, it's a core product feature, but we're like, hey, it's going to help people to converse with Lovable more, it's going to increase the engagement.

**中文翻译:**
没错。举个例子，我们的增长团队推出了与 Shopify 的集成，以支持电子商务用例。因为我们发现已经有人尝试这么做了，而 Shopify 也愿意与我们集成，所以我们就投入进去，让人们可以“氛围编程”他们的店面。这是增长团队发起的，通常增长团队绝不会做这种事。增长团队为什么要投资核心产品的集成？再比如，我们为用户开启了语音模式，这样他们就可以用语音与 Lovable 交流，而不仅仅是打字。这也是一个功能，一个核心产品功能，但我们认为它能帮助人们更多地与 Lovable 交流，从而提高参与度。

---

### [00:21:32] Elena Verna

**English:**
One area that we've spent very little time in is activation, because usually I spend majority of my time in activation because there's so many awareness things that need to happen, and so many things that we need to smooth out experience for the users in order for them to get through that setup moment, to aha moment, to the habit loop, and here you're just interacting with agent. So, we, at the beginning, we're like, the agent team that we have here is working a lot on it. Why would we go in there and do anything? It's like our core team is responsible for activation. Now, we're starting to move into doing agent work ourselves, so all of a sudden growth team is not just doing product surfaces, now we're doing agentic workflows and codifying agent instructions in order for customers to activate better.

**中文翻译:**
我们花时间极少的一个领域是“激活”。通常我会把大部分时间花在激活上，因为有很多认知层面的工作要做，有很多用户体验需要磨平，才能让用户度过设置阶段，到达“顿悟时刻”（Aha moment），进入习惯循环。但在 Lovable，你只是在与 Agent（智能体）交互。所以一开始我们觉得，Agent 团队已经在做很多工作了，我们为什么要插手？感觉核心团队就负责了激活。现在，我们开始自己动手做 Agent 相关的工作了，所以突然之间，增长团队不仅在做产品表面，还在做 Agent 工作流，编写 Agent 指令，以便让客户更好地激活。

---

### [00:22:21] Elena Verna

**English:**
So, the work fundamentally, I feel like has gotten deeper into product, and deeper into actual core product functionality, as opposed to just being a smoothing surface on the outer layers.

**中文翻译:**
所以从根本上说，我觉得工作已经深入到了产品内部，深入到了核心产品功能，而不仅仅是在外层做一些修修补补的工作。

---

### [00:22:35] Lenny Rachitsky

**English:**
Okay, that is also a very big deal, every growth person that's ever been on this podcast, including you, always talks about the power of activation, just how much opportunity there is to get people to this aha moment, realize the value of this product, that increases retention and increases everything. And what you're saying here is you barely spend any time on activation because in a company like Lovable, there's a prompt, you give it what you want, it generates a thing, and that's basically all it is. And so, the impact is to make that agent better... basically all it is. And so the impact is to make that agent better at that thing, versus micro-optimize every step.

**中文翻译:**
好的，这确实也是件大事。上过这个播客的每个增长专家（包括你）总是会谈论激活的力量，谈论让用户到达“顿悟时刻”、意识到产品价值有多少机会，从而提高留存和一切指标。而你在这里说，你几乎不花时间在激活上，因为在 Lovable 这样的公司，用户输入提示词，告诉它想要什么，它生成东西，基本上就是这样。所以，产生影响的方式是让 Agent 变得更好……基本上就是这样，而不是去微调每一个步骤。

---

### [00:23:07] Elena Verna

**English:**
And our agent team spends night and day thinking about it. So I've never been at a company where core team thinks so much about activation, thinks so much about that first generation, thinks so much about reaching a-ha moment. So it's more weaved in into DNA of the overall company, which takes the pressure off of me to only have to focus on it. Because otherwise, yeah, I would be in that experience all the time.

**中文翻译:**
我们的 Agent 团队日以继夜地在思考这个问题。我从未在任何一家公司见过核心团队如此关注激活，如此关注第一次生成，如此关注如何达到“顿悟时刻”。所以它更多地融入了整个公司的 DNA，这减轻了我的压力，让我不必只盯着这一点。否则，我肯定会整天泡在那个体验优化里。

---

### [00:23:32] Elena Verna

**English:**
But I feel a lot more at ease, because everybody's thinking about it and everybody's working on making agents better. And agent, the beauty of it is it doesn't matter if it's actually first generation or if it's your Nth generation. It just needs to be a better generation. Agent needs to understand your intent better, and think and reason behind it. So it improves the entire lifecycle immediately as opposed to having to only work on that first experience per se.

**中文翻译:**
但我感到轻松多了，因为每个人都在思考这件事，每个人都在努力让 Agent 变得更好。Agent 的美妙之处在于，无论它是第一代还是第 N 代，它只需要成为更好的一代。Agent 需要更好地理解你的意图，并在背后进行思考和推理。这样它就能立即改善整个生命周期，而不仅仅是针对第一次体验。

---

### [00:23:59] Lenny Rachitsky

**English:**
And what you're not saying is, "Don't care about that experience," it's, "The team building that is already obsessed with making that activation experience better and better."

**中文翻译:**
你并不是在说“不关心那个体验”，而是说“构建那个体验的团队已经痴迷于让激活体验变得越来越好”。

---

### [00:24:07] Elena Verna

**English:**
Exactly, exactly. I love that, because that's the core product functionality at this point. And before people would spend more time building deeper features, or deeper use cases, or trying to improve some platform functionality. And now the core team, they're obsessed about that first experience because that is core product.

**中文翻译:**
没错，正是如此。我喜欢这一点，因为这现在就是核心产品功能。以前人们会花更多时间构建更深层的功能、更深层的用例，或者试图改进某些平台功能。而现在，核心团队对第一次体验非常痴迷，因为那就是核心产品。

---

### [00:24:29] Lenny Rachitsky

**English:**
Another lever that I've noticed, especially with Lovable, and I'm seeing it more and more on social media is just founders telling you what's going on. I think this connects really deeply with the new features. Launch new features. Say Anton is just like, "Hey, check out this cool new thing. Check out our growth numbers." Is that a big growth lever too?

**中文翻译:**
我注意到的另一个杠杆，特别是在 Lovable 身上，而且在社交媒体上越来越多见，就是创始人亲自告诉你发生了什么。我觉得这与“新功能”紧密相连。发布新功能，然后 Anton（Lovable 创始人）就会发：“嘿，看看这个酷炫的新东西。看看我们的增长数据。”这也是一个巨大的增长杠杆吗？

---

### [00:24:47] Elena Verna

**English:**
Yeah. So one of our biggest strategy is building in public. Building in public, and it's coupled with employee socials, founder-led socials for sure. This is difficult for larger companies. But when you're smaller and you still have a little bit more narrative control with everybody on your team, plus you have so much more trust within the organization, where people are going to say the right things because they understand what actually has happened, that ability to just really quickly deliver the message to the market becomes really important.

**中文翻译:**
是的。所以我们最大的策略之一就是“公开构建”。公开构建，并结合员工社交和创始人主导的社交。这对大公司来说很难。但当你规模较小时，你对团队中每个人的叙事控制力更强，而且组织内部有更多的信任，大家会说正确的话，因为他们了解实际发生了什么，这种快速向市场传递信息的能力变得非常重要。

---

### [00:25:21] Elena Verna

**English:**
Now, we still do the big launches, so we still have everything tiered into tier three, two, one. Tier ones are going to happen as big moments that we're going to really rally as a company behind. And it's going to be something that is meant to step function, change our product market fit, and we're going to do a bunch of activities behind it.

**中文翻译:**
当然，我们仍然会进行大型发布，我们将所有发布分为三级、二级和一级。一级发布是重大时刻，全公司都会全力以赴。它旨在实现阶梯式跨越，改变我们的产品市场契合度，我们会为此开展一系列活动。

---

### [00:25:40] Elena Verna

**English:**
But at the same time, what's really important to us is to maintain noise in the market. And that noise in the market happens by us shipping every day, every other day, multiple times per day and just talking about it constantly. Interestingly enough, it's actually works fantastic resurrection strategy, because people are like, "Oh, there's more things here. I need to go check it out."

**中文翻译:**
但与此同时，对我们来说非常重要的一点是保持市场上的“噪音”。这种噪音是通过我们每天、每隔一天、甚至每天多次发布新东西，并不断谈论它来实现的。有趣的是，这实际上是一个极好的“复活”策略，因为人们会觉得：“噢，这里又有新东西了，我得去看看。”

---

### [00:26:03] Elena Verna

**English:**
It also works as a great reengagement strategy. So instead of sending newsletters to say, "Here's the market trends or here's the user stories," people are literally logging into their social to say, "Okay, what has Lovable shipped now?" It's like, "What is the change?" So it's interesting to them to see, because from the time that they voice their opinion on what needs to happen to actual delivery is so short, so they feel heard. And they are heard, because that's how we prioritize all of the things that we're shipping. But it's interesting, because I've never been in a company that tries to maintain so much just shipping velocity to maintain a certain amount of noise that it feels like the product is alive. It's changing every single week. And then there's these big amplifications, turbo boost so to speak, in the race car model, that then go out and they fundamentally create a step function change in that product market fit as a whole. And that is a retention strategy I can get behind any day and all day. I only hope that we can maintain it as we continue scaling.

**中文翻译:**
它也是一个很好的重新参与策略。与其发送写着“这是市场趋势”或“这是用户故事”的邮件，人们现在会登录社交媒体看：“好吧，Lovable 现在又发布了什么？”就像在看“有什么变化？”这对他们来说很有趣，因为从他们提出意见到实际交付的时间非常短，所以他们感到被倾听了。他们确实被倾听了，因为这就是我们确定发布优先级的方式。有趣的是，我从未在任何一家公司见过为了维持一定的噪音量而保持如此高的发布频率，这让产品感觉是“活着”的。它每周都在变化。然后还有那些重大的放大效应，也就是赛车模型中的“涡轮增压”，它们会从根本上让整个产品市场契合度产生阶梯式变化。这是一种我全心全意支持的留存策略。我只希望随着我们继续规模化，我们能保持住这种节奏。

---

### [00:27:07] Lenny Rachitsky

**English:**
Sounds stressful. This reminds me, I had a... Gaurav, he's the CEO of Mirage. Used to be called Captions, which is a really successful AI video company startup. And they have a policy of you ship a marketable feature every week. That's how their company operates. And it's the same thing, it's just ship things you can talk about.

**中文翻译:**
听起来压力很大。这让我想起 Mirage（以前叫 Captions，一家非常成功的 AI 视频创业公司）的 CEO Gaurav。他们有一项政策：每周发布一个具有营销价值的功能。这就是他们公司的运作方式。异曲同工，就是发布那些值得被谈论的东西。

---

### [00:27:27] Elena Verna

**English:**
Velocity of shipping is our number one core value in development team. So we do anything and everything to just keep it going up, up, up and into the right. And by the way, this also means that everybody has a little bit of marketer within them. We have very lean product organization. We actually lean on our engineers to do a lot of product work. We call them product engineers, and they have to go and they have to announce the thing that they've shipped. It doesn't just funnel through marketing.

**中文翻译:**
“发布速度”是我们开发团队的第一核心价值观。所以我们竭尽所能让它保持上升趋势。顺便说一句，这也意味着每个人内心都有一点营销人员的影子。我们的产品组织非常精简。我们实际上依靠工程师来做很多产品工作。我们称他们为“产品工程师”，他们必须亲自去宣布自己发布的东西，而不仅仅是通过营销部门。

---

### [00:27:57] Elena Verna

**English:**
So there is a lot of autonomy, a lot of agency that needs to happen with this type of velocity. Because otherwise, you have to have enormous marketing team to staff that. So it has to come with some roles and responsibilities. Redefinition on the team as well.

**中文翻译:**
因此，在这种速度下，需要极大的自主性和能动性。否则，你必须拥有庞大的营销团队来支撑。所以这伴随着团队角色和职责的重新定义。

---

### [00:28:13] Lenny Rachitsky

**English:**
Let's talk about marketing. That's something else you've written about is just marketing is changing in a big way, their role in growth. How does marketing play a role in all of this?

**中文翻译:**
让我们聊聊营销。你也写过关于营销正在发生巨大变化的文章，以及它在增长中的角色。营销在这一切中扮演什么角色？

---

### [00:28:21] Elena Verna

**English:**
On one side, marketing channels are changing. On the other side, marketing's involvement into everything that product does is changing. And then number three, I think even marketing organizations in terms of where they hire the most are changing as a result as well. So I'll talk about second one first, just because we just talked about shipping, and that is... Yeah, you still have your product marketers, you still have your channel managers. But they focus more on the big things and the narratives.

**中文翻译:**
一方面，营销渠道在变。另一方面，营销对产品各项工作的参与度也在变。第三，我认为营销组织的招聘重点也因此发生了变化。我先说第二点，因为我们刚聊到发布。是的，你仍然有产品营销人员，仍然有渠道经理。但他们更多地关注大事和叙事。

---

### [00:28:49] Elena Verna

**English:**
Although it's difficult, because the narrative even changes all the time. As these functionalities come through, usually you can come up with a positioning and messaging, and you can have it for years and create all of the campaigns around it. Now, you have it for three months, and then the product changes. So the cycles here are really, really short. And for smaller changes, because cycles are so short, they spend so much time actually focusing on it as they should.

**中文翻译:**
虽然这很难，因为叙事本身也在不断变化。当这些功能推出时，通常你可以想出一个定位和信息，然后用上好几年，并围绕它开展所有活动。而现在，你只能用三个月，然后产品就变了。所以这里的周期非常非常短。对于较小的变化，因为周期太短，他们会按部就班地花很多时间去关注。

---

### [00:29:15] Elena Verna

**English:**
But some of these smaller changes just cannot be supported by marketing. You have to delegate it to your product and engineering team to do their own marketing, because otherwise, again, you'd have to have an enormous marketing team in order to support it all.

**中文翻译:**
但其中一些较小的变化，营销部门根本支持不过来。你必须授权给你的产品和工程团队去做他们自己的营销，否则，你还是得需要一个庞大的营销团队来支撑这一切。

---

### [00:29:27] Elena Verna

**English:**
But at the same time, channels in which marketing right now works I think are changing quite a bit. And not enough people I feel like are freaking out and talking about it, as opposed to moving just in the same direction over and over again. And the changes that I'm seeing is that it has been very clear to me that when you're talking about marketing organic strategy, if you asked me that five years ago, I would've said that's SEO. It's search engine optimization. Go on Google, that's your organic marketing strategy.

**中文翻译:**
但与此同时，我认为营销目前运作的渠道也在发生巨大变化。我觉得还没有足够多的人为此感到震惊并展开讨论，大家似乎只是在同一个方向上原地踏步。我看到的转变是：如果你五年前问我什么是营销的“自然增长策略”（Organic strategy），我会说是 SEO（搜索引擎优化）。去 Google 霸榜，那就是你的自然营销策略。

---

### [00:29:58] Elena Verna

**English:**
If you ask me what's your organic marketing strategy right now, to me it's all about social. Which is what is my CEO posting? What is my team posting? What is my creator economy doing? Influencer marketing, and across all of the social platforms. That is my organic, which is... That one's paid, to be fair. But when I think about organic, there is still a lot of that word of mouth. What are my users posting on social? What are they talking about it? What are they sharing?

**中文翻译:**
如果你现在问我什么是自然营销策略，对我来说，全是社交媒体。也就是：我的 CEO 在发什么？我的团队在发什么？我的创作者经济在做什么？网红营销，以及跨所有社交平台的活动。那就是我的自然增长，虽然公平地说，网红营销是付费的。但当我想到“自然”时，仍然有很多口碑因素：我的用户在社交媒体上发什么？他们在谈论什么？他们在分享什么？

---

### [00:30:26] Elena Verna

**English:**
Which is a mind shift, because I've been always... Especially in B2B, so focused on search. And now I feel like it's been completely pushed even further into consumerization territory, and it has become all about social no matter how B2B you are, because that's where eyeballs are at.

**中文翻译:**
这是一个思维转变，因为我以前一直——特别是在 B2B 领域——非常关注搜索。而现在我觉得它已经完全被推向了“消费化”领域，无论你的业务多么 B2B，现在都变成了社交媒体的天下，因为眼球都在那里。

---

### [00:30:44] Lenny Rachitsky

**English:**
That is fascinating. And so when you talk about socials, what are you finding is most helpful? Is it Twitter/X? Is it LinkedIn? Is it YouTube, TikTok, Instagram?

**中文翻译:**
这太迷人了。那么当你谈到社交媒体时，你发现哪些最有用？是 Twitter/X？LinkedIn？还是 YouTube, TikTok, Instagram？

---

### [00:30:52] Elena Verna

**English:**
For founder socials, our employee socials, X and LinkedIn are fantastic sources. Especially for B2B, because that's where all of the BBWB people are at. But you cannot just have ChatGPT write your copy and post it, you need to show personality. There needs to be humanity that it goes through it. And it's not natural for everybody, and it feels very awkward sometimes to start. But it's important to people to see who is building the company, because there's so much competition now on functionality, so they can rally behind a team.

**中文翻译:**
对于创始人社交和员工社交，X 和 LinkedIn 是极好的来源。特别是对于 B2B，因为那是职场人士聚集的地方。但你不能只是让 ChatGPT 写好文案然后发布，你需要展示个性。内容中需要有人情味。这对每个人来说并不都是自然的，有时开始时会觉得很尴尬。但让人们看到是谁在创办这家公司很重要，因为现在功能上的竞争太激烈了，所以人们会选择支持一个团队。

---

### [00:31:28] Elena Verna

**English:**
So they want to have a team that they want to win. And for that, you need to be vulnerable, you need to be authentic, obviously, but you just need to be yourself. That corporate scrubbing has to completely fall off, which is obviously going to pull in as the company scales. But at least at the beginning, that is your chance to stand out.

**中文翻译:**
他们希望支持一个他们想让其获胜的团队。为此，你需要展示脆弱的一面，需要真诚，显然，你只需要做你自己。那种“企业公关腔”必须完全去掉，虽然随着公司规模扩大，这种腔调难免会回来。但至少在开始阶段，这是你脱颖而出的机会。

---

### [00:31:52] Elena Verna

**English:**
And then your customers posting about you. So that word of mouth of really creating a product that creates something for customers that is worth talking about. It gives them stories that they want to share, that feels empowering to them to tell to others like they're unlocking a secret. They feel proud of what they have created.

**中文翻译:**
然后是你的客户发布关于你的内容。那种口碑来自于创造一个真正能为客户提供谈资的产品。它给了他们想要分享的故事，让他们在告诉别人时感到充满力量，就像在揭开一个秘密。他们为自己创造的东西感到自豪。

---

### [00:32:14] Elena Verna

**English:**
Which what we focus a lot on, Lovable on, to have that feeling of, "Oh my gosh, I have superpowers now and I can't wait to tell others. I cannot wait to show others what is happening." So on both of those sides, to me, that is very much organic. If you aren't a consumer, then Instagram, TikTok are very much a go as well.

**中文翻译:**
这就是我们在 Lovable 上非常关注的一点：让用户产生“天哪，我现在拥有了超能力，我等不及要告诉别人了，等不及要向别人展示发生了什么”的感觉。对我来说，这两方面都非常属于自然增长。如果你做的是 C 端，那么 Instagram 和 TikTok 也是必选。

---

### [00:32:35] Lenny Rachitsky

**English:**
The CEO clearly is an important variable in this, them. In this case, Anton just tweeting, "Here's what's going on Lovable. Here's how fast it's growing. He's something we've learned."

**中文翻译:**
CEO 显然是其中的一个重要变量。在这个案例中，Anton 只是发推说：“Lovable 进展如何。增长有多快。这是我们学到的东西。”

---

### [00:32:44] Elena Verna

**English:**
It is.

**中文翻译:**
确实如此。

---

### [00:32:44] Lenny Rachitsky

**English:**
We had the CEO of Gamma on recently, granted, and he's exactly the same thing. Just sharing a bunch of lessons, journey building in public, a big part of the growth lever. And your point here is okay, so it's the CEO. But then it's also how do you get your customers to share things on socials? And then there's a paid influencer component.

**中文翻译:**
我们最近请过 Gamma 的 CEO Grant，他也是完全一样。分享一堆教训，公开构建的过程，这是增长杠杆的重要组成部分。你的观点是：好的，首先是 CEO。但接着是如何让你的客户在社交媒体上分享？然后还有付费网红营销的部分。

---

### [00:33:01] Elena Verna

**English:**
Yes, the customer is difficult one. That's a word of mouth loop that you need to stand up. The only way to create a word of mouth loop is just to blow their socks off when they actually experience your product. We have a almost unfair advantage, because our product is called Lovable. So by default, we're trying to create absolute lovable experiences. That is a mentality internally. If it's not lovable, we're not going to ship it. And the best way to fix a bug at Lovable is to say, "This is not lovable," and everybody just jumps on it to fix it right there and then. Sprints, no sprints, it doesn't matter, it's getting fixed right now.

**中文翻译:**
是的，客户这一环很难。那是你需要建立的口碑循环。创造口碑循环的唯一方法就是在他们体验你的产品时，让他们彻底惊艳。我们有一个近乎“不公平”的优势，因为我们的产品就叫 Lovable（可爱/讨人喜欢）。所以默认情况下，我们就在努力创造绝对讨人喜欢的体验。这是内部的一种心态。如果它不讨人喜欢，我们就不会发布。在 Lovable 修复 Bug 的最好方法就是说：“这不可爱（not lovable）”，然后每个人都会立刻跳出来修复它。有没有冲刺周期（Sprints）不重要，现在就得修好。

---

### [00:33:40] Elena Verna

**English:**
So from that perspective, we have that culture already embedded as part of our brand and it's part of our name which helps us a lot. But the point is that you feel that brand through every interaction. I talk to my designer all the time, how can we add more love marks into the product? How can we prioritize more unique interactions? The little elements that make up that feeling of this product is speaking to me. It's like, "It feels something that is unique." It has personality behind it.

**中文翻译:**
所以从这个角度来看，这种文化已经作为品牌的一部分嵌入了我们的名字中，这对我们帮助很大。但重点是，你在每一次交互中都能感受到那个品牌。我经常和我的设计师交流：我们如何在产品中加入更多的“爱心印记”？我们如何优先考虑更独特的交互？那些构成“这个产品在和我对话”感觉的小元素。就像是：“它感觉很独特。”它背后有个性。

---

### [00:34:08] Elena Verna

**English:**
So we put all of the brand work actually into our product. When you think about Lovable, people think about a brand, but we don't have a brand marketing team yet. So it's all just through product interactions, and some of those building and public moments of the people behind those product interactions that is our strategy.

**中文翻译:**
所以我们实际上把所有的品牌工作都投入到了产品中。当你想到 Lovable 时，人们会想到一个品牌，但我们还没有品牌营销团队。所以这全是通过产品交互，以及产品交互背后的人在“公开构建”时的点滴来实现的，这就是我们的策略。

---

### [00:34:28] Elena Verna

**English:**
And then there's influencer marketing. Interestingly enough, influencer marketing is 10 times bigger for us than paid social. So yeah, we do some paid social as well, and it's working decently. It's quite expensive from payback period, we're still optimizing it. As I said, we're pretty early on in all of these channels. But influencer marketing is something that has worked from the beginning at Lovable. And a reason behind it is that influencer marketing, especially on the socials, it gives you an opportunity to have a little video and interaction. And Lovable is all about seeing like, "Oh my gosh, this is what I can do, and this is possible." So that drives people to go and try it themselves.

**中文翻译:**
然后是网红营销。有趣的是，网红营销对我们的贡献是付费社交广告的 10 倍。所以，是的，我们也做一些付费社交广告，效果还行。但从回本周期来看相当昂贵，我们还在优化。正如我所说，我们在所有这些渠道上都处于早期阶段。但网红营销从 Lovable 创立之初就非常有效。背后的原因是，网红营销（特别是在社交媒体上）给了你展示短视频和互动的机会。而 Lovable 的核心就是让人看到：“噢我的天，这就是我能做的，这是可能的。”这会驱动人们去亲自尝试。

---

### [00:35:07] Elena Verna

**English:**
So that's why social works very well for us, because it's not really a written value proposition. Nobody knows what vibe coding is. But you watch 10 seconds of it and you go, "Whew, that's new. Let me go give it a try."

**中文翻译:**
这就是为什么社交媒体对我们非常有效，因为它不是一种书面的价值主张。没人知道什么是“氛围编程”。但你看了 10 秒钟视频，你会说：“哇，这很新鲜，让我去试试。”

---

### [00:35:18] Lenny Rachitsky

**English:**
Who would've thought that a head of growth, who is traditionally seen as data, metrics, spreadsheets, drive KPIs is like, "Okay, how do we make this more lovable? How do we add more moments of delight?"

**中文翻译:**
谁能想到，一个传统上被视为看数据、指标、表格、驱动 KPI 的增长负责人，竟然在想：“好吧，我们如何让它更讨人喜欢？我们如何增加更多愉悦的时刻？”

---

### [00:35:31] Elena Verna

**English:**
I know. My joke is at the end of my Lovable journey whenever... Hopefully it never comes to an end. But at the end I'll be a growth brand person. Hi, my name is Elena, I do brand now. But I actually see it as part of growth strategy to make sure that that brand shines through every single interaction. And I always talk to my team about it, because that is one big lever in our growth story.

**中文翻译:**
我知道。我的笑话是，等我在 Lovable 的旅程结束时——希望永远不会结束——我会变成一个“增长品牌人”。“嗨，我叫 Elena，我现在做品牌了。”但我实际上将其视为增长策略的一部分，即确保品牌在每一次交互中都闪闪发光。我总是和我的团队谈论这件事，因为那是我们增长故事中的一个巨大杠杆。

---

### [00:35:58] Lenny Rachitsky

**English:**
Yeah, so I think that's a really important point to highlight. The reason Lovable is growing so fast is it is a product people love. You've made something people want. And the word of mouth spreads, because it's something that blows people's socks off as you said. So it feels like that's the first thing you got to get right.

**中文翻译:**
是的，我认为这一点非常值得强调。Lovable 增长如此之快的原因在于它是一个人们喜爱的产品。你做出了人们想要的东西。口碑之所以传播，是因为正如你所说，它让人感到惊艳。所以感觉那是你必须做对的第一件事。

---

### [00:36:13] Elena Verna

**English:**
Yes. Well, the first thing you have to get right is you have to be at the right place at the right time and you have to be in fast moving waters. Let's not discount how fast this category is exploding on its own. So this cannot happen in every single category that you're starting to build a product. But the way to stand out in the super crowded category is to create experiences that speak to people.

**中文翻译:**
是的。嗯，你必须做对的第一件事是：在正确的时间出现在正确的地点，并且处于快速流动的趋势中。我们不能忽视这个品类本身爆发的速度有多快。所以这不会发生在你开始构建产品的每一个品类中。但在一个超级拥挤的品类中脱颖而出的方法，就是创造能与人产生共鸣的体验。

---

### [00:36:33] Elena Verna

**English:**
That I think is something that a lot of people deprioritize, because they still prioritize functionality over humanity within software. And I think that we're actually moving to the new era of software that needs to feel human, that people want to interact with, not just utility of it. Because cost of software is coming down so much to develop that we now can actually invest into emotional feel of that software, as opposed to only just focus on creating the utility out of it.

**中文翻译:**
我认为这是很多人不重视的一点，因为他们仍然认为软件的功能性高于人性化。我认为我们实际上正在进入软件的新时代，软件需要感觉像人，人们想要与之互动，而不仅仅是把它当作工具。因为软件开发的成本已经大幅下降，我们现在实际上可以投资于软件的情感感受，而不仅仅是专注于创造它的实用性。

---

### [00:37:04] Elena Verna

**English:**
So to me, it's a... I love this move, because I hate nothing more than going to software that is just so painful to use that I lose some brain cells as I'm interacting with it, versus software that I feel I get energy out of. And for Lovable for me, I cannot wait on some of the projects that I have to go and vibe code myself. That's the highlight of my day. I bring in my daughter and I'm like, "Let's go do this." Like, "What do you think that needs to be done?" Because I just get so much energy out of doing it. And that is the feeling you cannot create by looking at it as a utility problem.

**中文翻译:**
所以对我来说，我喜欢这种转变。因为我最讨厌的就是使用那些极其痛苦、交互时感觉在消耗脑细胞的软件，我更喜欢那些让我感到获得能量的软件。对我来说，在 Lovable 上，我迫不及待地想去亲自“氛围编程”一些项目。那是我一天的亮点。我会带上我女儿说：“咱们来做这个吧。”比如：“你觉得这里该怎么弄？”因为做这件事让我感到精力充沛。如果你只把它看作一个实用性问题，是无法创造出这种感觉的。

---

### [00:37:42] Lenny Rachitsky

**English:**
The way I think about it, the way what you're describing is it's almost table stakes have increased, and now it's so easy to build. Now the big differentiator is experience, design, delight.

**中文翻译:**
我的理解是，正如你所描述的，现在的“入场门槛”已经提高了，因为构建变得如此容易。现在的核心差异化在于体验、设计和愉悦感。

---

### [00:38:09] Elena Verna

**English:**
Exactly, and it has to translate through every single interaction. So your designer has to be one of your first hires now in startups. It's not just about the engineering, so to speak, utility. And you have to think through every single interaction of, does this communicate our brand or not?

**中文翻译:**
没错，而且这必须体现在每一次交互中。所以现在设计师必须是创业公司的首批员工之一。这不仅仅关乎工程或实用性。你必须思考每一次交互：这是否传达了我们的品牌？

---

### [00:38:28] Lenny Rachitsky

**English:**
So along those lines, I want to come back to something you talked about, which is launching new features as a huge growth lever. The big question there is just how do you maintain quality and cohesiveness as all these people are empowered to ship stuff? Is there anything else there you've seen that works well to help avoid just the Frankenstein product that's endless features that you want to tweet about?

**中文翻译:**
顺着这个思路，我想回到你提到的“发布新功能作为巨大增长杠杆”这一点。大问题是：当所有人都被授权发布东西时，你如何保持质量和连贯性？你有没有看到什么好的方法，能避免产品变成一个“科学怪人”（Frankenstein），即为了发推特而堆砌无尽的功能？

---

### [00:38:59] Elena Verna

**English:**
Yeah. One part of it is not something that you can codify, but it's the type of people that you hire that are going to go and ship these things. We at Lovable try to hire the absolute best talent available out there that we can bring in, and that we can source and that we can attract to grow with. And what do I mean by that best talent? It's not that somebody who has been at really large companies, or somebody that has really done a lot of logos or has big success stories behind them. It's somebody who is extremely passionate about their job.

**中文翻译:**
是的。其中一部分是无法成文的，那就是你雇佣的那些去发布这些东西的人。在 Lovable，我们努力雇佣我们能找到的、能吸引到的最顶尖人才，并与他们共同成长。我所说的“顶尖人才”是什么意思？并不是指那些在大公司待过的人，或者做过很多大项目、有很多成功故事的人。而是指那些对工作极其充满激情的人。

---

### [00:39:18] Elena Verna

**English:**
It's their hobby. They love to work. They have fire in their belly. This is not a paycheck for them, they want to do this for some ulterior reason. This is the biggest opportunity of their life, so this is global maximum against any other opportunities that are in front of them at the moment. So that's very important for us.

**中文翻译:**
工作就是他们的爱好。他们热爱工作。他们胸中有一团火。对他们来说，这不仅仅是一份薪水，他们是为了某种更深层的理由而做这件事。这是他们人生中最大的机会，是目前摆在他们面前的所有机会中的“全局最优解”。这对我们非常重要。

---

### [00:39:45] Elena Verna

**English:**
We want people to come and do their absolute best work at Lovable. It's very important, and you can feel it in this office. People are wired up. They are so high on how can we make this better? How can we deliver more to our customers? And that's very different compared to usually how companies grow where like, "Okay, yeah, the check, check, check. They fit the skillset, let's bring them in." But is that passion, is that fire behind it?

**中文翻译:**
我们希望人们来到 Lovable 做出他们一生中最好的工作。这非常重要，你在办公室里就能感受到。人们都处于兴奋状态。他们非常热衷于：我们如何让它变得更好？我们如何为客户提供更多价值？这与通常公司的成长方式非常不同，通常是：“好吧，勾选，勾选，勾选。他们符合技能要求，让他们进来吧。”但背后有那种激情和火焰吗？

---

### [00:40:25] Elena Verna

**English:**
And then the second piece is that we work really hard on just addressing what's the success here looks like? What is it that we're building? What use cases are we building for? And then because we hire these people that are so passionate about it, the other two skills, by the way, that are super important is high agency and high autonomy. I can figure out things that are tangential to me that I don't need other specialties, so to speak. I don't need a marketer to go launch something, I can go figure it out. And I have high agency, I can go do it myself. I'm going to own it all the way from start to finish. Those are very important, something that we screen for and something that we look for in our culture.

**中文翻译:**
第二点是，我们非常努力地去明确：这里的成功是什么样子的？我们正在构建什么？我们为哪些用例构建？而且，因为我们雇佣了这些充满激情的人，顺便说一下，另外两个超级重要的技能是“高能动性”和“高自主性”。我可以搞定与我相关的边缘事务，不需要其他专业人员。我不需要营销人员去发布东西，我可以自己搞定。我有很强的能动性，我可以自己动手。我会从头到尾负责到底。这些非常重要，是我们筛选人才的标准，也是我们文化中所追求的。

---

### [00:41:00] Elena Verna

**English:**
On the hiring of these incredible people, as we all know, it's very hard to hire people these days, especially the best. What have you seen Lovable does differently or does well that helps them recruit the best?

**中文翻译:**
关于雇佣这些优秀人才，众所周知，现在招人很难，尤其是招顶尖人才。你看到 Lovable 有什么不同之处或做得好的地方，能帮助他们招到最优秀的人？

---

### [00:41:10] Elena Verna

**English:**
Yes, and especially recruit in Stockholm. The main office here is in Stockholm. We're asking a lot of people to relocate, which is no small feat. Now some of it makes it easy, because of how much hype we created around our product. People want to come work for us. They're reaching out to us. They're saying, "I love what you're doing, I want to join it." So that we have a cheat code to it, because we have... Most of the time when we reach out to somebody, they say, "Yeah, I would love to explore." So building that product that is highly lovable also creates a really great recruiting brand for you as well. So make sure that there's multiple benefits to that.

**中文翻译:**
是的，特别是在斯德哥尔摩招聘。我们的总部在这里。我们要求很多人搬迁，这可不是件容易的事。现在，由于我们围绕产品创造了巨大的热度，这让事情变得容易了一些。人们想来为我们工作。他们主动联系我们说：“我喜欢你们正在做的事情，我想加入。”所以我们有一个“作弊码”，因为大多数时候当我们联系某人时，他们会说：“是的，我很想聊聊。”所以，构建一个高度讨人喜欢的产品，也会为你创造一个极好的招聘品牌。确保这能带来多重收益。

---

### [00:41:56] Elena Verna

**English:**
But second of all, we do a lot of trials for people. So trial work to see them in action. A work trial to see them in action for a couple of days. We pay them as part of the work trial. We have some probation periods that we start people on, because this company is not for everybody. As I said in the podcast in the beginning, the pace here is insane. I went on vacation for the first time. So I've been here for six months. I went on vacation for 10 days. I came back, I felt like I needed to onboard from the beginning. Everything changed.

**中文翻译:**
其次，我们对候选人进行大量的试用。也就是“工作试用”（Work trial），看他们实际工作几天的表现。我们会支付试用期的薪水。我们会让人们先进入一段试用期，因为这家公司并不适合所有人。正如我在播客开头所说，这里的节奏非常疯狂。我入职六个月后第一次休假，休了 10 天。回来后，我觉得自己需要重新入职培训。一切都变了。

---

### [00:42:44] Elena Verna

**English:**
And when I'm in it, I feel like it's an evolution. But the fact that just being gone for 10 days, it feels like a complete revolution in the company. That pace is just not for everybody, and that's okay. Because I'm a very firm believer that there's different cultures and different environments that the best fit for different personalities and different people. So we try to be very upfront with how things are and how chaotic they are, and we prioritize people that don't look for clarity. We can create clarity out of chaos because it is absolutely chaotic otherwise. And if we start to look for people that can explain it to us, that's the only way that we can succeed.

**中文翻译:**
当我在其中的时候，我觉得这是一种演变。但仅仅离开 10 天，感觉公司发生了一场彻底的革命。这种节奏并不适合所有人，这没关系。因为我坚信，不同的文化和环境适合不同的性格和人。所以我们尽量坦诚地说明情况有多么混乱，我们优先考虑那些不刻意追求“清晰度”的人。我们可以从混乱中创造清晰，因为除此之外这里绝对是一片混乱。如果我们开始寻找那些能向我们解释混乱的人，那是我们成功的唯一途径。

---

### [00:43:17] Lenny Rachitsky

**English:**
Let me try to summarize the growth levers that you're finding are working, and I'm trying to think about this from the perspective of an AI startup trying to think about, "Hey, shoot, how do we grow faster? What has Lovable figured out?" So it feels like number one is just build something lovable, something that blows people's socks off, but also in a market that is growing that people want to pay money for.

**中文翻译:**
让我试着总结一下你发现有效的增长杠杆。我试着从一个 AI 创业公司的角度来思考：“嘿，该死，我们怎么才能增长得更快？Lovable 发现了什么？”感觉第一条就是：构建一些讨人喜欢的东西，一些让人惊艳的东西，但也要在一个增长的、人们愿意付钱的市场中。

---

### [00:43:46] Elena Verna

**English:**
I call it minimum lovable product. It shouldn't be minimal viable product anymore. Viability is left back in 2010s. Now it's minimal lovable product. That's the only thing that matters.

**中文翻译:**
我称之为“最小可爱产品”（Minimum Lovable Product）。它不应该再是“最小可行产品”（MVP）了。“可行性”是 2010 年代的东西。现在是 MLP。那是唯一重要的事情。

---

### [00:44:12] Elena Verna

**English:**
Yeah. Well, it's the feedback cycle. It's just completely collapsed. You can go from idea to some product that is functioning to user feedback within a day if you want to, depending on how fast that you want to run or how complex the product is. For missions, it took us a couple of weeks to vibe code it to the point to where... I have a full-time vibe coder on my team. He's amazing. So he wanted to create videos. He did a bunch of designs for it too. It took him a couple of weeks, we're testing it now and then we'll push it in the product. But it's a completely different development lifecycle.

**中文翻译:**
是的。嗯，反馈周期已经完全坍塌了。如果你愿意，你可以从一个想法，到做出一个能运行的产品，再到获得用户反馈，在一天之内完成，这取决于你想跑多快或产品有多复杂。对于“任务”功能，我们花了几个星期进行“氛围编程”，直到……我的团队里有一个全职的“氛围程序员”。他很棒。他想制作视频，还为此做了一堆设计。他花了几周时间，我们现在正在测试，然后会把它推送到产品中。但这是一种完全不同的开发生命周期。

---

### [00:45:19] Lenny Rachitsky

**English:**
I saw you launch this on LinkedIn. To me, it looked like a full product launch. It is interesting to hear this is just a prototype.

**中文翻译:**
我看到你在 LinkedIn 上发布了这个。对我来说，它看起来像是一个完整的产品发布。听到这只是个原型，真有意思。

---

### [00:45:26] Elena Verna

**English:**
Yeah, it's minimum lovable product.

**中文翻译:**
是的，它是“最小可爱产品”。

---

### [00:45:30] Lenny Rachitsky

**English:**
Minimum lovable product. Okay, I got to ask you, you said you had a full-time vibe coder. What the heck is this? Is this an engineer? Is this something else? What is a full-time vibe coder?

**中文翻译:**
最小可爱产品。好吧，我得问你，你说你有一个全职的“氛围程序员”（Vibe coder）。这到底是什么鬼？是工程师吗？还是别的什么？什么是全职氛围程序员？

---

### [00:46:00] Elena Verna

**English:**
Great question. This is a new job role that is actually popping up here and there. It's absolutely fascinating to watch this development, because I see vibe coding as a skill being added to a lot of job descriptions. For designers, for product managers, for marketers, which I think is a really interesting shift. Finally, Excel can move over. We have a new skill to add that is super empowering and not 30 years old, but vibe coder, so his name is Lazar and he actually was chief of staff in his previous role so he's not technical at all. He's self-taught in technical aspects of it, but he was very early on in the vibe coding wave so he learned a lot about it. He was user of all of the vibe coding tools, Lovable included.

**中文翻译:**
好问题。这是一个正在各处冒出来的新职位。观察这种发展绝对令人着迷，因为我看到“氛围编程”作为一项技能被添加到许多职位描述中。设计师、产品经理、营销人员，我认为这是一个非常有趣的转变。终于，Excel 可以靠边站了。我们有了一项全新的、极具赋能感的技能。这位氛围程序员叫 Lazar，他之前的职位其实是幕僚长（Chief of Staff），所以他完全没有技术背景。他在技术方面是自学的，但他很早就接触了氛围编程浪潮，所以学到了很多。他是所有氛围编程工具的用户，包括 Lovable。

---

### [00:47:03] Elena Verna

**English:**
And when I was coming into the role, I'm like, "I have so many projects that I will vibe code myself," so I run this woman only hackathon, SheBuilds. I vibe coded the first version of that site and submission process for applications, and then other people came in and started building on top of it. But I vibe coded, but then I don't have enough time sometimes because I need to run around and I want to push out so many different initiatives that I want to test in the market with our own product. So we connected on social and I'm like, "Would you join us?" And he joined us first part-time. I'm like, "You're bringing so much value."

**中文翻译:**
当我入职时，我想：“我有这么多项目要亲自去氛围编程。”比如我举办了一个女性专属的黑客松 SheBuilds。我亲自氛围编程了那个网站的第一版和申请提交流程，然后其他人进来开始在上面构建。但我虽然会氛围编程，但我有时没有足够的时间，因为我需要到处跑，而且我想推出很多不同的举措来用我们自己的产品测试市场。所以我们在社交媒体上联系上了，我问：“你想加入我们吗？”他先是兼职加入。我说：“你带来的价值太大了。”

---

### [00:47:31] Elena Verna

**English:**
For example, we partnered with Shopify, and he created a bunch of Shopify Lovable templates, vibe coded for us. And it's been so helpful to have somebody like that that is just pushing all of these things out. And he's an absolute expert, so he's teaching us all too of what is possible with Lovable because he's on the cutting edge of constantly pushing it to the limit. I really enjoy having that role, which I've never had before in my life and in my team.

**中文翻译:**
例如，我们与 Shopify 合作，他为我们氛围编程了一堆 Shopify Lovable 模板。有这样一个人不断把这些东西推出来，真的非常有帮助。他是个绝对的专家，所以他也在教我们所有人 Lovable 的可能性，因为他处于不断挑战极限的最前沿。我非常喜欢这个角色，这是我职业生涯和团队中从未有过的。

---

### [00:48:41] Lenny Rachitsky

**English:**
Let me go back to summarize just real quick the growth levers, I want to move in a somewhat different direction. Things that help Lovable grow. One is just build something that blows your socks off, as you said. I love these phrases out here. The second is make noise in the market. And the way that Lovable does this, the CEO's tweeting constantly. You build something that blows people's socks off so that they share things on socials themselves, plus this influencer marketing component, and just this idea of building in public has been really helpful. This point about activation being embedded within the product team of the AI agent essentially, so it's essentially not the growth team thinking about activation. It's the product team that is building the AI magic that is obsessed with activation. It feels like those are the main growth levers. Is there anything else that I missed?

**中文翻译:**
让我快速回到增长杠杆的总结，然后我想换个方向。帮助 Lovable 增长的因素：第一，正如你所说，构建让人惊艳的东西。我喜欢这些表达。第二，在市场上制造噪音。Lovable 的做法是：CEO 不断发推；构建让人惊艳的东西，让用户自发在社交媒体分享；加上网红营销；以及“公开构建”的理念。还有一点是，激活被嵌入到了 AI Agent 的产品团队中，所以本质上不是增长团队在思考激活，而是构建 AI 魔法的产品团队在痴迷于激活。感觉这些是主要的增长杠杆。还有我遗漏的吗？

---

### [00:50:38] Elena Verna

**English:**
Community. I think community is really important here because you need to bring people together as they're exploring these capabilities and as they're seeing what's possible so they can bounce off each other and they can help each other out. I would say community also amplifies that word of mouth. It amplifies all of the social posting. It amplifies retention mechanisms for you as well. The community has been a huge part of Lovable's success as well, and that's something that was started very early on.

**中文翻译:**
社区。我认为社区在这里非常重要，因为当人们在探索这些能力、观察各种可能性时，你需要把他们聚集在一起，这样他们可以互相交流、互相帮助。我想说，社区也放大了口碑，放大了所有的社交发布，也为你增强了留存机制。社区一直是 Lovable 成功的巨大组成部分，而且是很早就开始建立的。

---

### [00:51:05] Elena Verna

**English:**
It runs on Discord, so it's nothing fancy. It's not like we build anything completely from scratch for ourselves. And it has hundreds of thousands of members and it's very lively. We have community managers that are making sure that all of the questions get answered and the right groups are being created. We have incredible ambassador program now as well of people doing it. I would say community here, again, of really making software more human is very important role. Now, obviously not everybody can build a community, but maybe at least plugging in into somebody's community is quite important as well.

**中文翻译:**
它在 Discord 上运行，没什么花哨的。我们并不是为自己从头开始构建了什么。它有数十万成员，非常活跃。我们有社区经理确保所有问题都得到解答，并创建正确的群组。我们现在还有一个非常棒的大使计划。我想说，社区在“让软件更具人情味”方面扮演了非常重要的角色。当然，显然不是每个人都能建立一个社区，但至少接入别人的社区也是非常重要的。

---

### [00:51:48] Elena Verna

**English:**
Another one is giving your product away a lot. And for AI products, it may feel counterintuitive because they're so costly. Every single interaction with an AI product costs companies something. There's an LLM pass-through cost that is coming through. And a lot of, especially traditional tech companies I see are gating AI immediately behind the paywall because they're sitting on a really cush, high margin profile, and the moment that you start giving AI away for free, you're cutting into those margins like a knife through the butter. Now, at the same time, AI being so new and the capabilities being so new, you have to remove the barrier of entry. You have to give a lot of your product away for free. But by the way, I don't just mean freemium. Freemium to me is just a baseline. If you're in the new category, you need to let people explore what it is free and get that initial wow moment.

**中文翻译:**
另一个是大量赠送你的产品。对于 AI 产品来说，这可能感觉很反直觉，因为成本太高了。与 AI 产品的每一次交互都会产生成本。会有 LLM（大语言模型）的调用成本。我看到很多公司，特别是传统科技公司，立即将 AI 锁在付费墙后面，因为他们习惯了舒适的高利润率，一旦你开始免费赠送 AI，你就像用刀切黄油一样削减了这些利润。但与此同时，AI 如此之新，能力也如此之新，你必须消除准入门槛。你必须免费赠送大量产品。顺便说一句，我指的不只是“免费增值”（Freemium）模式。对我来说，免费增值只是底线。如果你处于一个新类别，你需要让人们免费探索它是什么，并获得最初的“惊叹时刻”（Wow moment）。

---

### [00:52:48] Elena Verna

**English:**
It's not aha moment, by the way. It doesn't need to be aha moment anymore. It just needs to be a wow moment. And for Lovable, it's that first preview generation after your first prompt, even though it's absolutely not going to be complete thing of what you want to build, but you just go, "This is possible? I had no idea. I want to keep building." And it becomes an addictive exercise.

**中文翻译:**
顺便说一下，那不是“顿悟时刻”。它不再需要是顿悟时刻了，只需要是一个“惊叹时刻”。对于 Lovable 来说，就是你输入第一个提示词后的第一次预览生成，尽管它绝对不会是你想要构建的完整东西，但你会惊呼：“这竟然是可能的？我完全没想到。我想继续构建。”这变成了一种让人上瘾的过程。

---

### [00:53:08] Elena Verna

**English:**
But we also give so many of our Lovable credits away to every event, to every hackathon. If you want to host a Lovable hackathon, we will sponsor it and give all of the participants credits away for free. We give them away as candy and we basically track them over our LLM costs on freemium and giveaways as our marketing costs, and it doesn't go into our something we need to reduce to make our margins better. It goes into, this is something that we need to spend more in because this is part of our growth secret sauce.

**中文翻译:**
我们还会为每个活动、每个黑客松赠送大量的 Lovable 额度。如果你想举办 Lovable 黑客松，我们会赞助并为所有参与者免费提供额度。我们像发糖果一样把它们送出去，我们基本上把这些免费模式和赠送产生的 LLM 成本追踪为我们的“营销成本”，它不属于我们需要削减以提高利润率的项目。它属于“我们需要投入更多”的项目，因为这是我们增长秘密酱汁的一部分。

---

### [00:53:41] Lenny Rachitsky

**English:**
Okay, I want to hear more about the growth secret sauce. That is extremely interesting. I haven't heard of that as a strategy, and I can see why this makes sense. If the strategy is blow people's socks off so they can tell their friends, post on all socials, the trick is get more people to try it. And it's such a new, crazy thing. Why would I pay money? Why would I even go take the effort to try sign up for an account? I don't know what this is. I don't know what I'm doing with it. So I could see how this loop goes faster and faster by giving it away.

**中文翻译:**
好的，我想听更多关于增长秘密酱汁的内容。这非常有趣。我还没听说过把这作为一种策略，但我能理解为什么它有效。如果策略是让人惊艳，让他们告诉朋友，在所有社交媒体上发布，那么秘诀就是让更多人尝试。这是一个如此新颖、疯狂的东西。我为什么要付钱？我为什么要费劲去注册账号？我不知道这是什么，不知道能用它做什么。所以我能看到通过赠送，这个循环是如何越转越快的。

---

### [00:54:10] Elena Verna

**English:**
Exactly. And again, this is very uncomfortable sometimes for companies that A, either used to really... AI companies have lower profile of margins. That's absolutely true. To find an AI company with 80%, 90% margin profile is absolutely impossible, let's be real. We're all sitting somewhere in a 40% or so, which is a lot smaller. So any time that you look at those AI costs as your cost center, that's when you're in trouble. You fundamentally have to flip the script and say, "I need to expose to people of what is possible and I need to remove the monetization friction out of it."

**中文翻译:**
没错。而且，这对某些公司来说有时非常不舒服。首先，AI 公司的利润率确实较低。这是事实。要找到一家利润率在 80% 或 90% 的 AI 公司绝对是不可能的，咱们现实点。我们都处于 40% 左右的水平，这要小得多。所以，任何时候如果你把这些 AI 成本看作你的“成本中心”，你就麻烦了。你必须从根本上反转剧本，说：“我需要向人们展示什么是可能的，我需要消除其中的变现摩擦。”

---

### [00:54:59] Elena Verna

**English:**
Because if you don't, nobody's ever going to try it, or you're going to be very easily overtaken by a competitor that will give it away. And let's face it, once you hook people, they're more likely going to stay with you. So you obviously have to still work on the retention strategy there. But if you can have, like for our case, if somebody, one of our users stands up and say, "Hey, I'm going to have a hackathon at my work on Lovable. Can you give us all some free credits to play with?" Why would we prevent a person who wants to do all of the marketing and activating job for us in their company from using us?

**中文翻译:**
因为如果你不这样做，就没人会尝试，或者你很容易被那些愿意免费赠送的竞争对手超越。而且说实话，一旦你吸引住了用户，他们更有可能留在你这里。当然，你仍然需要制定留存策略。但如果你能像我们这样，当我们的一个用户站出来说：“嘿，我要在公司办黑客松，能给我们一些免费额度吗？”我们为什么要阻止一个愿意在他们公司为我们做所有营销和激活工作的人呢？

---

### [00:55:21] Elena Verna

**English:**
Of course, we're like, "Take it. How much do you need? How much would you like? We will sponsor it all. We will give you anything that you need." So we're really leaning into people that are wanting to show this magic to those around you and empowering them as much as possible. And that is something that is actually applies to every single product. And I agree, this is not a growth strategy that I've ever applied in my life on giving product away as much as possible, but it is something that is more and more becoming something that I see that is absolutely non-negotiable.

**中文翻译:**
当然，我们会说：“拿去吧。你需要多少？想要多少？我们全额赞助。我们会提供你需要的任何东西。”所以我们真的在依靠那些想向周围人展示这种魔法的人，并尽可能地赋能他们。这实际上适用于每一个产品。我同意，这并不是我职业生涯中应用过的增长策略（即尽可能多地赠送产品），但它正日益成为我眼中绝对不可妥协的一环。

---

### [00:55:51] Lenny Rachitsky

**English:**
What I'm feeling is the more mind-blowing it is, the more you should give it away for free. Especially in a competitive market where everyone is... It's hard. There's so many companies trying to do this thing, and so it's almost like the better you are, the more you should give it away.

**中文翻译:**
我的感觉是，产品越是让人大开眼界，你就越应该免费赠送。特别是在一个竞争激烈的市场中，每个人都在……这很难。有这么多公司在尝试做这件事，所以几乎就像是：你做得越好，你就越应该把它送出去。

---

### [00:56:08] Elena Verna

**English:**
Right. And this also explains why so much VC money has to be raised for these sorts of companies because this is not cheap. Like you said, you're paying all these foundational models a lot of money.

**中文翻译:**
对。这也解释了为什么这类公司必须筹集这么多风投资金，因为这并不便宜。正如你所说，你要付给这些基础模型公司很多钱。

---

### [00:56:16] Elena Verna

**English:**
Yes and no. I'm only going to say no is because, so take a look at Lovable, we're over 200 million in ARR. At this point, we're 100 people large so our headcount costs are very low. 200 million ARR, I didn't realize 100 people work at Lovable. Yes. And six months ago, we had 30 people working at Lovable so we triple. So for us, it's a really big deal. We tripled our company size.

**中文翻译:**
是也不是。我说“不是”的原因是，看看 Lovable，我们的 ARR 超过 2 亿。目前我们只有 100 人，所以我们的人头成本非常低。（Lenny：2 亿 ARR，我没意识到 Lovable 只有 100 人。）是的。六个月前，我们只有 30 人，所以我们翻了三倍。对我们来说，这是件大事，公司规模翻了三倍。

---

### [00:56:44] Elena Verna

**English:**
We're going to quadruple it by the end of, yeah, I know. We're big boy and girls now. But for perspective of the headcount costs, it's minimal. We have very little in that going on. We are not spending a lot on paid marketing so we're not a big paid marketing driver. Yeah, we're spending on influencer marketing, but it's not majority of our growth. It's low double digits to be fair because it's not why we're successful. It's amplifying our success and it's helping us reach new audiences. We don't have really large sales team, we have only a couple sales folks, and they're just starting to ramp up their enterprise efforts so we don't have really big enterprise demand gen costs as well.

**中文翻译:**
到年底我们会翻四倍，我知道。我们现在是大孩子了。但从人头成本的角度来看，它是极小的。我们在那方面的支出很少。我们没有在付费营销上花很多钱，所以我们不是靠付费营销驱动的。是的，我们在网红营销上有支出，但那不是我们增长的大头。公平地说，它只占低两位数比例，因为那不是我们成功的原因。它是在放大我们的成功，帮助我们触达新受众。我们没有庞大的销售团队，只有几个销售人员，他们才刚刚开始加强企业端的工作，所以我们也没有巨大的企业端需求生成成本。

---

### [00:57:42] Elena Verna

**English:**
From that perspective, if you look at the equation and you say, "Well, okay, if you're not going to do a lot of paid marketing, if you're not going to do a lot of sales, because we're really only working on hand raisers of people that are saying right now that they want to buy Lovable, then whereas you don't have big costs, so you can spend it on product." That is the beautiful part because when we are giving our product away to our customers, we're not competing with other companies in that space, because they're just going to use Lovable in their hackathon. We're on their own, and we're not competing on AdWords or in paid Google where everybody's buying real estate for eyeballs. From that perspective, I think about it more as a shift of where we spend in costs. And honestly, it's more efficient way to do paid marketing almost in a sense because of the cost per eyeball that we get there is quite a bit lower compared to if we were trying to compete it on Google.

**中文翻译:**
从这个角度看，如果你看这个等式并说：“好吧，如果你不做大量付费营销，不做大量销售（因为我们目前只服务于那些主动举手说想买 Lovable 的人），那么你就没有巨大的成本，所以你可以把钱花在产品上。”这就是美妙之处，因为当我们把产品送给客户时，我们并没有在那个空间里与其他公司竞争，因为他们只是在黑客松里使用 Lovable。我们是独占的，我们没有在 AdWords 或 Google 付费搜索上竞争，那里每个人都在买地盘抢眼球。从这个角度看，我认为这更多是成本支出的转移。坦白说，从某种意义上说，这是一种更高效的付费营销方式，因为我们获得的“单次眼球成本”比在 Google 上竞争要低得多。

---

### [00:58:30] Lenny Rachitsky

**English:**
That is an incredibly important point you're making there. It's not like you're generating an incredible amount of revenue, so there is money available to spend. And what you're saying is because it's been spreading through word of mouth mostly, you're not spending tons of money on salespeople, you're not spending tons of money on paid ads. This is just an amazing way to get more people to use it, so it's like a marketing cost.

**中文翻译:**
你提到的这一点极其重要。并不是说你们没在产生巨额收入，所以有钱可花。你的意思是，因为主要靠口碑传播，你们没有在销售人员和付费广告上砸重金。这只是让更多人使用它的一种绝佳方式，所以它就像是一项营销成本。

---

### [00:58:54] Elena Verna

**English:**
This is product-led growth. Supercharge. To the max, supercharged. Yes, because you're literally using your product to drive that awareness by giving it away to the agents in your ecosystem that will do that distribution for you.

**中文翻译:**
这就是产品驱动增长（PLG）。超级加倍。极致的超级加倍。是的，因为你实际上是在通过将产品赠送给生态系统中的代理人，让他们为你进行分发，从而驱动认知。

---

### [00:59:11] Lenny Rachitsky

**English:**
So fascinating. What a wild world we're living in. Free stuff for everyone.

**中文翻译:**
太迷人了。我们生活在一个多么疯狂的世界。每个人都有免费的东西。

---

### [00:59:17] Elena Verna

**English:**
Yes. I mean, it's great for consumers. This is a great time to be a consumer. You have so many options. Everybody's throwing themselves at you, giving your product away for free so it's great to be in the market right now. I think the power should be with consumer always, but with software, power has not been with consumer previously because we were forced to use towards some solutions because of either how they were chosen for us or what was available in the market. And now that supply is almost infinite, the demand from the consumers can be very picky and the one that serves the best will win.

**中文翻译:**
是的。我是说，这对消费者来说太棒了。现在是做消费者的好时机。你有这么多选择。每个人都向你投怀送抱，免费赠送产品，所以现在处于这个市场中很棒。我认为权力应该永远在消费者手中，但在软件领域，以前权力并不在消费者手中，因为我们要么被迫接受别人为我们选好的方案，要么只能用市场上仅有的东西。而现在供应几乎是无限的，消费者的需求可以非常挑剔，服务最好的那一个将会胜出。

---

### [00:59:52] Lenny Rachitsky

**English:**
And I think again, it's important to highlight. This is not some kind of VC subsidized bubble-ish sort of thing. There is a lot of money being generated that you are spending to help it grow faster. It's not some kind of, we're just raising more money to give away more money. You're actually making your own money. It's not driven by VC money. Obviously, it helps.

**中文翻译:**
我想再次强调，这并不是某种风投补贴的泡沫式的东西。你们正在产生大量的收入，并把这些钱花在加速增长上。这不像是“我们只是筹集更多钱来送出更多钱”。你们实际上是在赚自己的钱。它不是由风投资金驱动的，虽然风投显然有帮助。

---

### [01:00:09] Elena Verna

**English:**
I can't comment on specific margin details for us, but at the same time, the money that we're raising on VC is for future development and hardening our business, not because we will not be able to survive without it.

**中文翻译:**
我不能评论具体的利润细节，但与此同时，我们筹集的风投资金是为了未来的开发和巩固业务，而不是因为没有它我们就活不下去。

---

### [01:00:22] Lenny Rachitsky

**English:**
Awesome. Okay, great segue too. I want to talk about product-market fit in competition. You have this really interesting post that I don't think people grasp yet, which is that product-market fit is no longer this, we've done it. Product-market fit and we're up into the right. Now we just grow, go, grow. Now we hire salespeople, it's going to be great. You've written that just product-market fit is no longer this like you've done it and you're good. It's this endless fight to keep it. Talk about what you're seeing there.

**中文翻译:**
太棒了。这也是个很好的过渡。我想聊聊竞争中的产品市场契合（PMF）。你发过一篇非常有趣的帖子，我觉得人们还没完全领会，那就是：PMF 不再是那种“我们做到了，PMF 达成，曲线一路上扬，现在只要增长、增长、增长，招销售，一切都会变好”的状态。你写过，PMF 不再是那种“一旦达成，万事大吉”的东西。它是一场为了守住它而进行的无休止的战斗。谈谈你在那方面的见解。

---

### [01:00:49] Elena Verna

**English:**
I'll first start with what I've felt at least before when people were talking about product-market fit, that yeah, obviously always product-market fit is an evolving thing, but the rate of that evolution was measured in years. What is it that you need the next product-market fit step function change, which often was called second horizon or third horizon. Sometimes five, 10 years, sometimes even longer that you'd need, depending on how good and hard your initial product-market fit was, but you'd spend years scaling the original product-market fit. It was like blitz growth stage. Marketing, sales, growth was very important that you just try to get it to as many people as possible. And then once you have saturation or the cost to getting to the marginal people becomes too high, you start thinking, "Okay, what else can I offer to help me reach additional people or sell more to existing users that I already have?"

**中文翻译:**
我先说说我以前对 PMF 的感觉。虽然 PMF 显然一直是一个演变的过程，但那种演变的速度是以“年”为单位衡量的。你需要的下一个 PMF 阶梯式变化（通常被称为第二曲线或第三曲线），有时需要 5 年、10 年甚至更久，这取决于你最初的 PMF 有多稳固。你会花数年时间去规模化最初的 PMF。那就像是闪电式增长阶段。营销、销售、增长非常重要，你只需努力触达尽可能多的人。一旦达到饱和，或者获取边际用户的成本变得太高，你才开始思考：“好吧，我还能提供什么来触达更多人，或者向现有用户卖更多东西？”

---

### [01:01:39] Elena Verna

**English:**
And again, the main point here is it would take years to get to that stage where it became a question that you had to face really hard face-to-face. Now, it's three months, and all of a sudden you have to face that question again. And it's happening because of two things, in my opinion. Number one, in AI technology of what LLM is capable of doing changes still very rapidly with new model release, with each new model release. I think we'll stabilize at some point and then it's going to become more marginal, but we're not there yet. So every three months or so, every single AI LLM provider creates a step function change in what is possible with that LLM.

**中文翻译:**
再次强调，重点是以前需要数年才会面临这个严峻的问题。而现在，是三个月，突然之间你就得再次面对这个问题。在我看来，原因有两点。第一，AI 技术中 LLM（大语言模型）的能力随着每一次新模型的发布仍在飞速变化。我认为最终会趋于稳定，变得更加边际化，但现在还没到那个阶段。所以大约每三个月，每一个 AI 模型提供商都会让 LLM 的可能性产生一次阶梯式的跨越。

---

### [01:02:36] Elena Verna

**English:**
The tricky piece here is that it's not enough to just wait for that technology to get better and then start building on top. You have to build beforehand to make a bet and then it's the LLM to catch up because when that model releases, you already need to have that functionality available. That piece is, I've never been in a company where the fundamental capabilities are still changing so rapidly, and that's the product part. The product can leap to the new expectations, but let's not talk about the market part as well. Consumer expectations have never changed this fast before.

**中文翻译:**
棘手的地方在于，仅仅等待技术变好然后再在其上构建是不够的。你必须提前构建、提前下注，然后等 LLM 来追赶，因为当模型发布时，你已经需要让那个功能可用了。我从未在任何一家公司见过基础能力变化如此之快，这是产品部分。产品可以跃升到新的预期，但别忘了市场部分。消费者的预期从未像现在这样变化得如此之快。

---

### [01:03:31] Elena Verna

**English:**
What we expected ChatGPT to be able to do and answer and how we wanted it to talk to us eight months ago versus now is night and day and the deep thinking mode, and how deeply you can go into answering questions and what is capable of building on top of it. Consumer perception has never changed this fast too. It's this unprecedented time of consumers all of a sudden in a month saying, "Oh, it's not doing this yet. I'm bouncing." Before, again, consumer perceptions would be years to take. It's actually technology would sometimes be able to already address it, but consumer perception has not been changed yet so it would take a long time.

**中文翻译:**
八个月前我们对 ChatGPT 的期望，以及我们希望它如何与我们对话，与现在相比简直是天壤之别。现在的深度思考模式、回答问题的深度以及在其上构建的能力都完全不同了。消费者的认知也从未改变得这么快。这是一个前所未有的时代，消费者可能突然在一个月内就说：“噢，它还不能做这个，我走了。”以前，消费者的认知转变需要数年。实际上，有时技术已经可以解决了，但消费者的认知还没变，所以需要很长时间。

---

### [01:04:08] Elena Verna

**English:**
We're in this really weird part where both product and market is shifting so rapidly that every three months, I feel like we have to recapture our product-market fit and not just recapture on the same technology and with same customers. It's both of those pieces of the equation change every three months, and it's terrifying in a way. It's also very confusing in a way because we're $200 million company, and we're not solely focused on marketing and sales because we still have to recapture our product-market fit.

**中文翻译:**
我们正处于一个非常奇怪的阶段，产品和市场都在如此迅速地移动，以至于每三个月，我都觉得我们必须重新捕捉我们的 PMF，而且不仅仅是在相同的技术和相同的客户群上。等式的两端每三个月都在变，这在某种程度上很可怕。在某种程度上也很令人困惑，因为我们是一家 2 亿美元规模的公司，但我们不能只专注于营销和销售，因为我们仍然需要重新捕捉我们的 PMF。

---

### [01:04:26] Elena Verna

**English:**
You know that the team that finds your product-market fit is very different than the team that usually scales your company, yet we have to find the team that is capable of doing both on ongoing basis. Now, I think every AI company is on this product-market fit treadmill. Hopefully that treadmill speed slows down. If not, I think we're going to come up with crazy things of what this LLM and AI will be able to do if it's going to continue at this cusp, but it's a weird place to be in because every three months we have to throttle on our scaling efforts and just reinvent and then scale again. But it's like short blitz of growth, not these long year long commitments.

**中文翻译:**
你知道，寻找 PMF 的团队与通常规模化公司的团队是非常不同的，然而我们必须找到一支能够持续同时完成这两项任务的团队。现在，我认为每家 AI 公司都处在“PMF 跑步机”上。希望跑步机的速度能慢下来。如果不是，如果它继续保持这种势头，我想我们会看到 LLM 和 AI 能做出的疯狂事情。但处在这个位置很奇怪，因为每三个月我们就得放慢规模化的脚步，去重新发明，然后再规模化。这就像是短期的闪电式增长，而不是长达数年的承诺。

---

### [01:05:09] Lenny Rachitsky

**English:**
What makes this very real is just this week, apparently OpenAI had this whole code red moment where even though OpenAI by far the leading AI assistant over almost a billion, I think monthly active users, basically synonymous with AI around the world, with Gemini 3 launching, their market share just started to dip really quickly. I think they lost six something percent in a week. And so even OpenAI, ChatGPT, the original, the one that everyone uses constantly is in danger.

**中文翻译:**
让这一切变得非常真实的是，就在本周，OpenAI 显然经历了一个“红色代码”时刻。尽管 OpenAI 是目前领先的 AI 助手，拥有近 10 亿月活用户，几乎是全球 AI 的代名词，但随着 Gemini 3 的发布，他们的市场份额开始迅速下滑。我想他们在一周内损失了 6% 左右。所以即使是 OpenAI，即使是每个人都在用的 ChatGPT，也处于危险之中。

---

### [01:05:39] Elena Verna

**English:**
It's like nobody's future is bulletproof yet. And 10 years ago, if you asked me if a $200 million company was at risk in losing product-market fit in the next three months if it's experiencing 10% month-over-month growth, I would've said, "You're crazy." And now that's the reality that we live in. And I don't know, it's fascinating to world in. What a time to be alive.

**中文翻译:**
就像还没有谁的未来是刀枪不入的。10 年前，如果你问我一家月增长 10%、年收入 2 亿美元的公司是否会在未来三个月内面临失去 PMF 的风险，我会说：“你疯了。”而现在，这就是我们生活的现实。我不知道该说什么，这个世界太迷人了。真是个伟大的时代。

---

### [01:06:04] Lenny Rachitsky

**English:**
Time to be alive and very stressful, but the prize at the end is massive. That's why this is worth doing, not just monetarily, but just the impact it's going to have on the world, the way we people build and ship.

**中文翻译:**
伟大的时代，但也压力巨大，不过最后的奖赏是巨大的。这就是为什么这件事值得做，不仅是为了金钱，更是为了它将对世界产生的影响，以及人们构建和发布产品的方式。

---

### [01:06:17] Elena Verna

**English:**
Exactly. The ceiling of what is possible has been raised so massively that we haven't even became too closest to even see it, I believe. I think that that's the exciting part of it.

**中文翻译:**
没错。可能性的天花板已经被抬得如此之高，以至于我相信我们甚至还没接近到能看见它的程度。我认为这就是令人兴奋的地方。

---

### [01:06:29] Lenny Rachitsky

**English:**
The way I've seen you write about this product-market fit challenge is the traditional approach is you have these core users that are using it happy with it, and then you expand to the adjacent users and expand to the next. You're basically just trying to recapture that same core constantly and don't even have time to go adjacent.

**中文翻译:**
我看到你写过关于 PMF 挑战的内容：传统方法是，你有一群核心用户，他们用得很开心，然后你扩展到“相邻用户”（Adjacent users），再扩展到下一群。而现在，你基本上只是在不断地试图重新捕捉同一群核心用户，甚至没有时间去触达相邻用户。

---

### [01:06:44] Elena Verna

**English:**
Yeah. Bangaly wrote a really wonderful article. It was many years ago at this point on adjacent user theory in that your product-market fit expansion when you're in no growth stages, the biggest opportunity for you to go after is this what you call the adjacent user, which are just outside of your core user. They have somewhat similar needs, but maybe they're in different geo, maybe they have slightly different use case, slightly different needs. And your biggest way to continue growing a product-market fit without having to go to next horizon is to capture that next group of users.

**中文翻译:**
是的。Bangaly 很多年前写过一篇关于“相邻用户理论”的精彩文章。当你处于增长停滞阶段时，PMF 扩张的最大机会就是去追求所谓的“相邻用户”，即那些刚好处于你核心用户圈层之外的人。他们有类似的需求，但可能在不同的地区，或者有略微不同的用例和需求。在不进入下一个大阶段的情况下，继续增长 PMF 的最大方式就是捕捉下一组用户。

---

### [01:07:39] Elena Verna

**English:**
The interesting piece here of how I relate to it, we still have the core users. And by the way, those core users are mostly pioneers right now that are excited by the capabilities. Then there's latent majority that is filled with adjacent users. And the issue right now, which I'm actually quite worried about us as a category is that we're constantly focusing on recapturing the pioneers. We don't have time to go after adjacent users, and I'm worried of whether there's going to be a gap in the space where we actually going to alienate the latent majority because we're so hyper focused on just staying top of mind and top capabilities on the pioneers.

**中文翻译:**
有趣的地方在于，我们现在仍然只有核心用户。顺便说一下，这些核心用户目前大多是那些对新技术能力感到兴奋的“先锋”。然后是充满相邻用户的“潜在大多数”。目前的问题是——我其实挺担心我们这个品类的——我们一直在专注于重新捕捉那些先锋。我们没时间去追求相邻用户，我担心这会导致空间中出现断层，我们实际上会疏远潜在的大多数，因为我们太过于专注于在先锋群体中保持领先地位和最强能力。

---

### [01:08:31] Lenny Rachitsky

**English:**
I completely see what you're thinking there. A brand could just become known as that's just for startups and prototyping and it's not for serious work.

**中文翻译:**
我完全明白你的想法。一个品牌可能会变得只被认为是“给创业公司和做原型用的”，而不是为了严肃的工作。

---

### [01:08:38] Elena Verna

**English:**
Yeah, or it's for techies. It's for tech people. It never actually enters the people outside of our little bubble that we live in.

**中文翻译:**
是的，或者它是给“极客”用的，给技术人员用的。它从未真正进入我们生活的那个小圈子之外的人群。

---

### [01:08:50] Lenny Rachitsky

**English:**
We touched on this a little bit of just working in AI, working on AI companies, challenging, stressful, a lot of work. What's your advice for folks that are thinking about, should I join a Lovable? Should I join a Cursor? Should I just go work at Google?

**中文翻译:**
我们稍微触及了一点关于在 AI 领域工作、在 AI 公司工作的话题：充满挑战、压力大、工作量大。对于那些正在考虑“我该加入 Lovable 吗？该加入 Cursor 吗？还是该去 Google 工作？”的人，你有什么建议？

---

### [01:09:13] Elena Verna

**English:**
I really believe that there's different... You need to understand what's the environment that is right for you. Just please understand that AI companies are very hectic at the moment. They're very unstable by definition of that product-market fit treadmill, about that distribution of how they're actually distribute to the market, really changing about how product is even being developed in the first place. So if you are very comfortable in being in that messy middle and really comfortable of converting chaos into clarity for you and those around you, then yeah, AI company is a wonderful place for you to really absorb new skill sets right now.

**中文翻译:**
我真的相信有不同的……你需要了解什么样的环境适合你。请务必理解，AI 公司目前非常繁忙。根据“PMF 跑步机”的定义，它们非常不稳定，分发方式在变，甚至产品最初的开发方式也在变。所以，如果你非常习惯处于那种“混乱的中间地带”，并且非常擅长为你和周围的人化混乱为清晰，那么是的，AI 公司现在是你吸收新技能的绝佳场所。

---

### [01:10:02] Elena Verna

**English:**
Because even before joining Lovable, when I kept seeing AI, I'm like, "My gosh, I'm so tired of seeing AI everywhere. Is it really changing the world? Is it really changing the way people work?" And I was at Dropbox before, and yeah, we would use AI here and there and I would use ChatGPT. I've never used AI there the way I use AI at Lovable and the things that I'm capable of accomplishing at Lovable, and I don't know if I ever would've made that leap so fast unless I joined Lovable.

**中文翻译:**
因为即使在加入 Lovable 之前，当我不断看到 AI 时，我会想：“天哪，我厌倦了到处看到 AI。它真的在改变世界吗？它真的在改变人们的工作方式吗？”我以前在 Dropbox，是的，我们会偶尔用用 AI，我也会用 ChatGPT。但在那里，我从未像在 Lovable 这样使用 AI，也从未像在 Lovable 这样能完成这么多事情。如果不是加入了 Lovable，我不知道自己是否能这么快完成这个跨越。

---

### [01:10:47] Elena Verna

**English:**
Now, I don't think AI is replacing everybody's job, so please don't look at it as that cliche saying. I actually often call AI as average intelligence that helps me get the platform up. And then I add my human thinking and my human creativity on top of it to get it to the next level. But at least I can get this base level done with AI really freaking quickly.

**中文翻译:**
现在，我不认为 AI 会取代每个人的工作，所以请不要把它看作那种陈词滥调。我实际上经常把 AI 称为“平均智能”（Average Intelligence），它帮我搭建起平台。然后我在其上加入我的个人思考和人类创造力，将其提升到下一个水平。但至少，我可以利用 AI 非常快地完成基础层面的工作。

---

### [01:11:11] Elena Verna

**English:**
So from that perspective, I think if you want to leapfrog on what it means to be AI native employee and how to use all of these AI tools, you should go to AI company. But if you know that your superpower is in more structure and more definition and a really high specialty of things, because in AI companies, they're all fairly small, so you'll have to generalize quite a bit and have a lot of ownership, all of areas that you usually maybe not have ownership over, then you shouldn't join it, because AI companies will evolve to be more stable too.

**中文翻译:**
所以从这个角度来看，如果你想在成为“AI 原生员工”以及如何使用这些 AI 工具方面实现跨越式发展，你应该去 AI 公司。但如果你知道你的超能力在于更多的结构化、更多的定义和极高的专业化，那么你可能不该加入。因为在 AI 公司，规模通常都很小，你必须做很多通才的工作，拥有极强的所有权意识，负责很多你平时可能不负责的领域。当然，AI 公司最终也会演变得更加稳定。

---

### [01:12:00] Lenny Rachitsky

**English:**
Yeah. My sense is if you want work-life balance, don't join one of these companies, because that's just not the way they work.

**中文翻译:**
是的。我的感觉是，如果你想要工作与生活的平衡（Work-life balance），就不要加入这些公司，因为那不是它们的运作方式。

---

### [01:12:07] Elena Verna

**English:**
I don't know if I'd go that far. I mean, I have family, I have two kids. I feel like I have a very good work-life balance, but I put in boundaries for myself. I know when I need time off because I know when my brain starts to overheat, so to speak. But I also know that work is my hobby and it's my passion, and this is the best work of my life that I'm doing right now. There's no other place that I'd rather be than to be here.

**中文翻译:**
我不知道我会不会说得那么绝对。我是说，我有家庭，有两个孩子。我觉得我有很好的工作生活平衡，但我为自己设定了界限。我知道什么时候需要休息，因为我知道我的大脑什么时候开始“过热”。但我也知道工作是我的爱好，是我的激情所在，我现在正在做我一生中最好的工作。除了这里，我哪儿也不想去。

---

### [01:12:33] Elena Verna

**English:**
So I think that you just need to be more careful about setting your own boundaries that you know you need. But I mean, let's face it, I don't think anybody has work-life balance, regardless of a company that they work at, even at Google or Microsoft or any of the others. I think everybody's freaking out and running as fast as they can, it's just they're running it in different structures.

**中文翻译:**
所以我认为你只需要更谨慎地设定你需要的界限。但我的意思是，面对现实吧，我不认为任何人有真正的工作生活平衡，无论他们在哪家公司工作，即使是在 Google、微软或其他任何公司。我觉得每个人都在焦虑，都在拼命奔跑，只是奔跑的结构不同而已。

---

### [01:12:58] Lenny Rachitsky

**English:**
I'm really glad you said that and corrected me there, that it is possible to work at a company, one of, if not the fastest-growing company in history and actually have work-life balance to get sleep, to spend time with your kids and family.

**中文翻译:**
我很高兴你这么说并纠正了我。在一家历史上增长最快（或最快之一）的公司工作，实际上是有可能拥有工作生活平衡的——能睡觉，能花时间陪孩子和家人。

---

### [01:13:11] Elena Verna

**English:**
You just have to protect it ruthlessly, but you also need to be realistic with how much is expected out of you, and you need to feel confident that you'll be able to deliver it. And by the way, you won't be able to deliver it unless you use AI in many aspects of your work life. So that's the piece that helps you actually get to hit those expectations of outcomes that you need to do and the velocity. But I'm very protective of my personal time with kids. Why did I have children if I'm not going to spend time with them? So those are part of the non-negotiables that I bring along with me in every single work.

**中文翻译:**
你必须无情地保护它，但你也需要现实地对待别人对你的期望，并且你需要有信心能够交付成果。顺便说一句，除非你在工作的许多方面使用 AI，否则你无法完成交付。AI 能帮助你达到预期的产出和速度。但我非常保护我陪孩子的私人时间。如果我不打算花时间陪孩子，我为什么要生孩子呢？所以这些是我在每一份工作中都带在身边的“不可谈判项”。

---

### [01:13:59] Elena Verna

**English:**
So first of all, I would not think about it as a work-life balance. There's no such thing as balance. So balance feels like, "Oh, I have enough time for everything." I don't have enough time for anything, but I prioritize my family in some moments, I prioritize work in other moments, and I don't try to balance the two. I go where I'm needed and where I go, and I feel like I'm not going to regret the choices that I'm making today. So I'm constantly trying to put myself in the future and say, "Will I resent myself if I make this choice right now?" And if the answer is yes, I don't make that choice.

**中文翻译:**
首先，我不会把它看作“工作生活平衡”。根本没有平衡这回事。平衡给人的感觉是：“噢，我有足够的时间做所有事。”我其实没有足够的时间做任何事，但我会在某些时刻优先考虑家庭，在另一些时刻优先考虑工作，我不会试图去平衡两者。我出现在需要我的地方，我觉得我不会后悔今天所做的选择。所以我不断尝试把自己放在未来，问自己：“如果我现在做这个选择，未来我会怨恨自己吗？”如果答案是肯定的，我就不做那个选择。

---

### [01:14:43] Elena Verna

**English:**
So I think that just making in the moment, in every day, when sometimes in-the-hour decisions, to me, works better than trying to balance something that is completely unachievable and it feels overwhelming to even think about. But I prioritize this in my sleep, my health, my workout schedule, my kids, my family, my husband, and just my downtime because I know that I'm most creative once I have separation from work, because then I come in with all cylinders firing and I have so many more ideas about it. So to me, it's actually part of doing my best work is to take time off.

**中文翻译:**
所以我认为，活在当下，在每一天、甚至每一小时做决定，对我来说比试图去平衡一些完全无法实现、甚至想起来就让人崩溃的事情更有效。我会优先考虑睡眠、健康、健身计划、孩子、家庭、丈夫，以及我的休息时间。因为我知道，一旦我与工作分离，我才是最有创造力的。当我回来时，我会火力全开，会有更多的想法。所以对我来说，休息实际上是做出最好工作的一部分。

---

### [01:15:18] Lenny Rachitsky

**English:**
That is really great advice. I want to touch on what it's like to work at Lovable because it feels like Lovable is at the cutting edge of what working in product is going to be. So you mentioned a little bit about how you're always talking to AI, asking questions. Is there any other kind of anecdotes of just how people operate at Lovable that is really unique or weird or funny or interesting that might be helpful for people to try in their company?

**中文翻译:**
这真是非常棒的建议。我想聊聊在 Lovable 工作是什么感觉，因为感觉 Lovable 处于未来产品工作方式的最前沿。你提到了一点关于你总是和 AI 对话、提问。还有没有其他关于 Lovable 运作方式的轶事——独特的、奇怪的、有趣的或有意思的，可能对其他公司有参考价值？

---

### [01:15:43] Elena Verna

**English:**
Yeah. I mean, we use Lovable at Lovable a lot. All of our internal tools are built on Lovables. We actually have our first hackathon on Lovable happening next week, where our entire company is just going to take full day to vibe code and see what we actually have happen. We prototype everything on Lovable. So our specs, yeah, we do still have a written spec, but it always accompanied by a lovable prototype that everybody can interact with and to click around with and provide feedback. And everybody bunches in and also does some edits if they have any better ideas.

**中文翻译:**
是的。我是说，我们在 Lovable 内部大量使用 Lovable。我们所有的内部工具都是在 Lovable 上构建的。实际上，我们下周就要举办第一场内部 Lovable 黑客松，全公司将花一整天时间进行“氛围编程”，看看会发生什么。我们在 Lovable 上做所有的原型。所以我们的规格说明书（Specs），虽然我们确实还有书面规格，但它总是伴随着一个 Lovable 原型，每个人都可以交互、点击并提供反馈。如果有人有更好的主意，大家都会聚在一起进行修改。

---

### [01:16:16] Elena Verna

**English:**
So I create mocks on Lovable. So for example, we need to make some pricing changes, or pricing page changes. I take a screenshot of our pricing page. I go to Lovable as I recreate this pricing page, make these changes, and then I send that to my engineering team saying, "Hey, this is what I want to happen." And then they take it from there.

**中文翻译:**
我会在 Lovable 上制作 Mockup（模型）。例如，我们需要对定价或定价页面进行一些更改。我会截一张定价页面的图，去 Lovable 重新创建这个页面，做出修改，然后发给我的工程团队说：“嘿，这就是我想要的效果。”然后他们接手。

---

### [01:16:37] Elena Verna

**English:**
And ChatGPT, I use a lot for brainstorming, especially the deep thinking mode. I love it. It takes a long time, but it's so worth it. Sometimes it has crazy ideas. Sometimes it was like, "Yeah, this is nothing new to me." So it's not interesting, but it gets me thinking and it gives me a look at the different angles. And I use Granola a lot, for example, because to me, it's super helpful to get AI summaries of the meetings and it's very powerful for me. I use Wispr Flow a lot because I feel like I have no time to type anymore. So I just talk to my phone and talk to my laptop all the time in order to do it.

**中文翻译:**
我经常用 ChatGPT 进行头脑风暴，特别是深度思考模式。我很喜欢它。虽然花的时间长，但非常值得。有时它会有疯狂的想法，有时它会说：“是的，这对我来说没什么新鲜的。”虽然不一定有趣，但它能引发我的思考，让我从不同角度看问题。我还经常用 Granola，因为它能帮我生成会议的 AI 摘要，对我来说非常强大。我也经常用 Wispr Flow，因为我觉得我没时间打字了。所以我总是对着手机和电脑说话来完成工作。

---

### [01:17:33] Elena Verna

**English:**
But we're even thinking about all of the customer support automations that are done through AI. Every single aspect of what we do, question is asked, what can AI do here first, and then how we can add ourselves into the equation. But Lovable for us, having unlimited credits at Lovable is a pretty awesome perk, I have to say. I sometimes have to pinch myself. I'm like, "I get paid to vibe code." It looks so fun.

**中文翻译:**
我们甚至在考虑所有通过 AI 完成的客户支持自动化。我们工作的每一个方面，都会先问一个问题：AI 在这里能先做什么？然后我们再考虑如何把自己加入到等式中。但对我们来说，在 Lovable 拥有无限额度是一个非常棒的福利。我有时得掐自己一下，我想：“我竟然拿工资来玩氛围编程。”这看起来太有趣了。

---

### [01:18:19] Elena Verna

**English:**
So for me, especially for product and growth, and even marketing in some capacity, when I have an idea in my head, it sounds so freaking cool. And sometimes I put it on paper and it's like, "Ah, we need to do it." And then I go and try to vibe code it, and I'm like, "Oh, I don't see the magic anymore," or I can't envision it anymore. Or sometimes I'm like, "Yeah. Yeah," and there's more, there's more. So to me, it actually has helped really complete the ideation process for me quite a bit, because then I actually try to go and build it, and it breaks down some of the elements of what's important, what's not.

**中文翻译:**
所以对我来说，特别是在产品、增长甚至某种程度上的营销方面，当我脑子里有一个想法时，它听起来酷毙了。有时我把它写在纸上，觉得：“啊，我们必须做这个。”然后我去尝试氛围编程，结果发现：“噢，我感觉不到那种魔力了，”或者我无法再想象它了。或者有时我会觉得：“对，对，还有更多，还有更多。”所以对我来说，它实际上帮我相当完整地完成了构思过程，因为我会尝试去构建它，这会分解出哪些元素重要，哪些不重要。

---

### [01:19:12] Elena Verna

**English:**
So to me, it's been great because sometimes we envision things that are so much better than the reality. And before, until it hands it off to design, designers would do it for us and try to make it awesome versus I often stop my ideas in tracks super early on without pushing it forward. Versus other times I might've pushed it for too far too long, even through design queue or even pitching to leadership. And I find that very powerful because it calibrates me really quickly.

**中文翻译:**
所以对我来说这很棒，因为有时我们设想的东西比现实好得多。以前，在交给设计之前，设计师会为我们做这些并努力让它变得很棒；而现在，我经常在非常早期就停止那些不切实际的想法，不再推进。而在其他时候，我可能会把一个想法推进得太远、太久，甚至进入了设计队列或向领导层汇报。我发现这非常强大，因为它能让我迅速校准。

---

### [01:19:44] Lenny Rachitsky

**English:**
Awesome. Okay. Last question. I want to talk about something that you've written about that I think it's a really important topic, something that we should surface, is you wrote this post called I'm Worried About Women In Tech. Talk about what you're seeing here, what you're noticing, what you think might be going in the wrong direction.

**中文翻译:**
太棒了。最后一个问题。我想聊聊你写过的一个我认为非常重要的话题，一个我们应该摆上台面的话题。你写过一篇帖子叫《我担心科技界的女性》。谈谈你在这里看到了什么，注意到了什么，以及你认为哪些方面可能走错了方向。

---

### [01:20:07] Elena Verna

**English:**
There's conflicting data points about how women are keeping up with AI technology and wave, because there's a bunch of reports that has been done that show massive gap between women adopting AI versus men adopting AI, which points the story that men are just widening the gap of accessibility for technology. And whoever's adopting AI right now is getting paid the most, gets the most opportunities. I mean, we're seeing insane acqui-hires right now, where people are getting paid more for their talent than for the companies that they've created. And that's a really interesting trend that is occurring, and a lot of it is fueled on this wave of AI.

**中文翻译:**
关于女性如何跟上 AI 技术浪潮，存在一些相互矛盾的数据点。有一系列报告显示，女性采用 AI 与男性采用 AI 之间存在巨大差距，这说明男性正在扩大技术获取能力的差距。而目前采用 AI 的人薪水最高，机会最多。我是说，我们现在看到了疯狂的“人才收购”（Acqui-hires），人们因为才华而获得的报酬甚至超过了他们创办的公司。这是一个非常有趣的趋势，而其中很大一部分是由这股 AI 浪潮推动的。

---

### [01:20:47] Elena Verna

**English:**
And women are not really present there. If you can think about one million-dollar acqui-hire that has been in the news that is a woman, I can't think of one. If you look at AI companies and their CEOs, most of it is men. If you look at the company's composition in AI companies, it's mostly men. To me, this really came to the head of when I came to Lovable, and I'm like, "It's pink, it's purple brand. It's a heart. It's lovable." I'm like, "I'm sure this is where it's 50/50 men versus a woman." And although we don't collect this information, but just through third-party autofill, we saw it's like 20% at most. And I'm like, "What is happening? Not again. Why is this, again, not being adopted by a woman?"

**中文翻译:**
而女性在其中并不活跃。如果你能想到一个在新闻中出现的、价值百万美元人才收购案中的女性，我一个也想不到。如果你看 AI 公司及其 CEO，大部分是男性。如果你看 AI 公司的员工构成，大部分也是男性。对我来说，当我来到 Lovable 时，这种感觉达到了顶峰。我想：“这是一个粉色、紫色的品牌，有一个爱心，叫 Lovable。”我想：“我敢肯定这里的男女比例是 50/50。”虽然我们不收集这些信息，但通过第三方自动填充工具，我们发现女性比例最多只有 20%。我想：“发生了什么？又来了。为什么女性又一次没有采用这项技术？”

---

### [01:21:35] Elena Verna

**English:**
And obviously I don't know all of the answers. I think that this is early on that we can shortcut it. And by the way, I also don't want to put this as a indication that men are to blame because I think men are doing wonderful job really spearheading the horizons and showing us what's possible and leading the charge. I'm just afraid that so many women are stuck in that latent majority that is just not catching up. And my worry is that it's going to affect the hireable talent. It's going to step us back again in the composition of the workplace, of the diversity.

**中文翻译:**
显然我不知道所有的答案。我认为现在还处于早期，我们可以走捷径解决它。顺便说一句，我也不想把这归咎于男性，因为我认为男性在开拓视野、展示可能性和带头冲锋方面做得非常出色。我只是担心很多女性被困在了那个无法跟上的“潜在大多数”中。我的担忧是，这将影响可雇佣的人才库，会让我们的职场构成和多样性再次倒退。

---

### [01:22:50] Lenny Rachitsky

**English:**
Yeah. The thing that struck with me from your post is there has been a lot of progress being made in the last decade, and now AI is just kind of turning it all back, turning it all around.

**中文翻译:**
是的。你帖子里最触动我的一点是：过去十年已经取得了很大进步，而现在 AI 似乎正在让一切倒退。

---

### [01:23:00] Elena Verna

**English:**
Hopefully not. I think that we're early on enough that we can bridge the gap. I think sometimes women just need space and ability to discover it, and that's what we're doing at Lovable. We have this initiative, SheBuilds, where we create a hackathon for women only and we give them unlimited access to Lovable for 48 hours, and they come together as a community and they build together. And there's beautiful things that start to come out of it, which I've never anticipated before.

**中文翻译:**
希望不会。我认为我们还处于早期，可以弥补这个差距。我认为有时女性只需要空间和发现它的能力，这就是我们在 Lovable 所做的。我们有一个名为 SheBuilds 的倡议，我们举办仅限女性参加的黑客松，为她们提供 48 小时的 Lovable 无限访问权限，她们作为一个社区聚集在一起共同构建。从中产生了一些我以前从未预料到的美好事物。

---

### [01:23:31] Elena Verna

**English:**
But so many women in that hackathon for us build help with their elderly parents or with their kids or with the household or for their church group or for the kids' basketball team solutions, which have hyper-local, hyper-relevant, very needed for what they need in their life and something that was never been able to build before because of how expensive software was, because it would never going to become potentially a hundred-million-dollar companies, but it also doesn't need to be anymore. So I just want to bring women to build more and vibe code more so we can have more diversity in software that is even created because I think that we all have a unique take on what problems that we can solve, and I want everybody's voices to be heard.

**中文翻译:**
在那场黑客松中，很多女性构建了帮助年迈父母、孩子、家务、教会团体或孩子篮球队的解决方案。这些方案具有超本地化、超相关性，是她们生活中非常需要的，而以前由于软件开发太贵，这些东西从未被构建出来，因为它们可能永远不会成为价值一亿美元的公司。但现在，它们不再需要成为大公司也能存在。所以我只想让女性更多地参与构建，更多地参与氛围编程，这样我们创造的软件就能有更多的多样性。因为我认为我们对可以解决的问题都有独特的见解，我希望每个人的声音都能被听到。

---

### [01:24:17] Lenny Rachitsky

**English:**
I'll give the URL for SheBuilds. I pulled it up while you're talking, shebuilds.lovable.app. It's fully vibe coded on Lovable. That's so cool. Minimal Lovable product. There it is. So when is this happening? Is this December 15th, 18th? Oh, yeah, it's coming up.

**中文翻译:**
我来提供一下 SheBuilds 的网址，你说话时我查了一下：shebuilds.lovable.app。它是完全在 Lovable 上氛围编程出来的。太酷了。最小可爱产品，就是它。那么什么时候举行？是 12 月 15 日到 18 日吗？噢，是的，快到了。

---

### [01:24:33] Elena Verna

**English:**
Yeah, we're running it constantly. So our next cohort starts December 15th, but we're going to have more. We're planning a massive one on International Women's Day. So that's the one that if you can, come join us.

**中文翻译:**
是的，我们一直在举办。我们的下一期从 12 月 15 日开始，但之后还会有更多。我们正计划在国际妇女节举办一场大规模的。如果可以的话，欢迎加入我们。

---

### [01:24:48] Lenny Rachitsky

**English:**
Awesome. And we'll link to that post if people want to get a deeper perspective, what you're saying. Elena, is there anything else that you wanted to share? Is there anything else you want to remind people of before we get to your one-question lightning round?

**中文翻译:**
太棒了。如果大家想深入了解你的观点，我们会附上那篇帖子的链接。Elena，在进入单问题闪电轮之前，你还有什么想分享或提醒大家的吗？

---

### [01:25:38] Elena Verna

**English:**
I guess the only other thing that I will share is for AI companies when it comes to hiring. It's really interesting, also, kind of the shift in the type of personas that end up being hired that I see. For me, at least it's quite different compared to anywhere that I worked before. And that is, there's this narrative going in the market always that new hires, sorry, new grads have no jobs in the market left because all of the entry-level jobs are automated. I actually think that's quite false, because new grads, especially AI-native new grads... So it's very important for kids that are entering into the, I shouldn't say kids, young adults that are entering into the workforce that they really know AI.

**中文翻译:**
我想我唯一想分享的其他事情是关于 AI 公司的招聘。我看到的被雇佣的人才画像（Personas）的转变非常有趣。对我来说，这至少与我以前工作过的任何地方都大不相同。市场上一直有一种说法：新员工，抱歉，是应届毕业生，在市场上已经没有工作了，因为所有的入门级工作都被自动化了。我实际上认为这是错误的，因为应届生，特别是“AI 原生”的应届生……所以对于进入职场的年轻人（我不该说孩子，是年轻人）来说，真正了解 AI 是非常重要的。

---

### [01:26:43] Elena Verna

**English:**
We have multiple new graduates at Lovable that are working, and I learned so much from them. And you need to obviously have the right atmosphere where people with experience, like a old guard like me, that can look at the new guard and really hear them and see them and really change the way that I operate based on how they do things. So make sure that you bring some of that fresh talent that doesn't understand any of the baggage that we came from and that can really look at the future in technology and what can unlock from a completely new lens.

**中文翻译:**
在 Lovable，我们有几位正在工作的应届毕业生，我从他们身上学到了很多。显然，你需要一种正确的氛围，让像我这样有经验的“老卫兵”能够观察“新卫兵”，真正倾听他们、观察他们，并根据他们的做事方式改变我的运作方式。所以，确保你引入一些没有我们这种历史包袱的新鲜人才，他们能真正从一个全新的视角看待技术的未来以及可以解锁的东西。

---

### [01:27:32] Elena Verna

**English:**
And then it's also interesting that there's a really high demand for ex-founders now, for those people that truly have a lot of agency and high autonomy. So instead of just having people that have been working in the corporate world, the failed startup founders are now hot demand for a lot of these AI companies. So these personas that we traditionally would not prioritize in companies to hire are now becoming the hottest commodity and the highest-going talent, which I think is fascinating and is the wonderful thing that is changing how the culture inside operates.

**中文翻译:**
此外，有趣的是，现在对“前创始人”的需求非常高，因为这些人真正拥有极强的能动性和高度的自主性。所以，与其只招那些在企业界工作过的人，那些失败的创业公司创始人现在成了许多 AI 公司的抢手货。这些我们传统上不会优先考虑雇佣的人才画像，现在正成为最炙手可热的商品和最高端的人才。我认为这很迷人，也是改变内部文化运作方式的美妙之事。

---

### [01:28:09] Lenny Rachitsky

**English:**
That is really interesting and really empowering, just this idea that if you need grad, there's hope. You're not going to be out of a job. And you might have an advantage. Yeah.

**中文翻译:**
这非常有趣，也非常赋能。这种想法让应届生看到了希望：你不会失业，而且你可能还拥有优势。

---

### [01:28:18] Elena Verna

**English:**
You have to lead with that. That's the thing. You have to lead with the things that you are capable of achieving, knowing what you have with AI, because that is a lot of people. Especially in traditional tech or in more traditional companies, they're looking for somebody to show them because it's really hard to figure it out on your own versus coming in and seeing and then copying.

**中文翻译:**
你必须以此为先导。这就是关键。你必须展示你在拥有 AI 的情况下能够实现的成果，因为很多人，特别是在传统科技或更传统的公司中，他们正在寻找能向他们展示的人，因为靠自己摸索很难，而进来观察然后模仿则容易得多。

---

### [01:28:37] Lenny Rachitsky

**English:**
Well, Elena, with that, we've reached our very exciting lightning round. Because it's your fourth time, I'm not going to ask you all the questions I always ask you. So I'm just going to ask you one question. So Lovable is based in Stockholm, Sweden. I'm curious, just what's something you love about Stockholm that you weren't expecting? Is there a food, a restaurant? I don't know, something.

**中文翻译:**
好了，Elena，至此我们进入了非常令人兴奋的闪电轮。因为这是你第四次来，我不会问那些我总是问你的问题。我只问你一个问题：Lovable 总部位于瑞典斯德哥尔摩。我很好奇，斯德哥尔摩有什么让你意想不到并爱上的东西？某种食物？一家餐厅？或者别的什么？

---

### [01:28:55] Elena Verna

**English:**
Well, you always have to say Swedish meatballs. I mean, I've never liked meatballs before, and now it's so good here. It's so good. So every time, one of my meals here throughout the day involves it. But I actually really love their... I don't know, they just taste different and they're... And they smell like the Ikea. It's not like the Ikea Swedish meatballs.

**中文翻译:**
嗯，你肯定得说瑞典肉丸。我是说，我以前从不喜欢肉丸，但这里的肉丸太好吃了。真的太棒了。所以我每天在这里总有一餐会包含它。但我真的很喜欢它们的……我不知道，它们尝起来就是不一样。而且它们闻起来像宜家（Ikea），但不是那种宜家卖的瑞典肉丸。

---

### [01:29:19] Elena Verna

**English:**
Well, I have been to Ikea here, because that is a Swedish company too. It reminded me of in-person Amazon. It was absolutely incredible. Ikea here is next level. But food, Swedish meatballs for sure. Honestly, how clean the city is, it's kind of incredible. The architecture, everything is so built out. It's picture perfect like it's on a card. I don't know. It's different compared to most of the large cities that I've been at that are little bit more worn down.

**中文翻译:**
我确实去过这里的宜家，因为那也是一家瑞典公司。它让我想起了“线下版的亚马逊”。绝对不可思议，这里的宜家是另一个档次的。但说到食物，肯定首选瑞典肉丸。坦白说，这座城市的干净程度令人难以置信。建筑、一切都规划得很好。它就像明信片一样完美。我不知道该怎么形容，与我待过的那些略显破旧的大城市相比，这里非常不同。

---

### [01:29:49] Lenny Rachitsky

**English:**
So fun. Makes me want to visit and get some meatballs.

**中文翻译:**
太有意思了。让我也想去参观一下，顺便吃点肉丸。

---

### [01:29:54] Elena Verna

**English:**
Yeah, and visit during the summer. Otherwise, the daylight here is really tight during the winter.

**中文翻译:**
是的，记得夏天去。否则，这里的冬天天黑得非常早。

---

### [01:30:06] Lenny Rachitsky

**English:**
Okay. Good tip. Okay. Two final questions. Where can folks find you online if they want to reach out, maybe learn more? And how can listeners be useful to you?

**中文翻译:**
好的，好建议。最后两个问题：如果大家想联系你或了解更多，可以在哪里找到你？听众们能为你提供什么帮助？

---

### [01:30:06] Elena Verna

**English:**
Yes. Please find me online on LinkedIn. Please feel free to follow me. Always engage on my post if you want to engage with me because that's the place that I always talk to people. I have my newsletter as well that baby steps compared to what Lenny has, but it's elenaverna.com. That's where I post most of my findings that I experience at my work. So if you want to continue seeing how my thinking evolves or the patterns that I notice, that's where to find me.

**中文翻译:**
好的。请在 LinkedIn 上找我。欢迎关注我。如果你想和我交流，请随时在我的帖子下互动，因为那是我经常与人交谈的地方。我也有自己的时事通讯（Newsletter），虽然比起 Lenny 的还只是起步阶段，网址是 elenaverna.com。那是我就工作中的发现进行总结的地方。所以如果你想继续关注我的思维演变或我注意到的模式，可以在那里找到我。

---

### [01:30:35] Elena Verna

**English:**
And how to be useful to me? Really pressure test my thinking because so many things are changing right now. I'm honestly not even sure myself of what is a pattern versus what is just a data point. So I'd love to just engage in as many conversations as possible and hear your opinions because that will help us as an industry just understand what is actually happening and makes more sense out of this whole thing.

**中文翻译:**
至于如何帮到我？请尽情挑战我的想法，因为现在一切都在变化。坦白说，我自己也不确定什么是普遍模式，什么只是单一数据点。所以我很乐意参与尽可能多的对话，听听你们的意见，因为这将帮助我们整个行业理解到底发生了什么，并让这一切变得更有意义。

---

### [01:30:59] Lenny Rachitsky

**English:**
I'm just going to double click on your newsletter. Definitely subscribe to it. It's incredibly good. Everything we've talked about here, Elena has written about in her newsletter in large part and goes even deeper. It's just elenaverna.com. If you're reading this on your podcast app or YouTube, you could just look at her name and just type it .com and you'll find it, and subscribe and you'll be really happy. Elena, thank you so much for being here. This was amazing, everything I wanted it to be. Thank you for sharing. I know you have a lot of work to do, so I appreciate you making time for this and for joining us.

**中文翻译:**
我要再次推荐你的时事通讯。一定要订阅它，真的非常棒。我们今天谈到的一切，Elena 很大程度上都在她的 Newsletter 里写过，而且写得更深。网址就是 elenaverna.com。如果你正在播客应用或 YouTube 上看这个，直接搜她的名字加 .com 就能找到。订阅它，你会有很大收获。Elena，非常感谢你能来。这太棒了，完全达到了我的预期。谢谢你的分享。我知道你有很多工作要做，非常感谢你抽时间参加我们的节目。

---

### [01:31:26] Elena Verna

**English:**
Thank you for having me. Really appreciate you.

**中文翻译:**
谢谢你邀请我。非常感谢。

---

### [01:31:29] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。