# Emilie Gerber - 双语对照

This is the complete bilingual transcript for **Lenny’s Podcast** featuring **Emilie Gerber**, founder of Six Eastern.

---

### [00:00:00] Emilie Gerber

**English:**
No one ever gets this tactical in PR. There's just so much theoretical conversation and examining the big blunders, but at the end of the day, if you're a startup that wants to get coverage for your company, you need to know actually the steps to take to do it.

**中文翻译:**
在公关领域，很少有人会讲得这么具有实操性。市面上充斥着太多的理论探讨和对重大失误的分析，但归根结底，如果你是一家想要获得媒体报道的初创公司，你需要知道具体该怎么做。

---

### [00:00:13] Lenny

**English:**
You mentioned a bunch of amazing companies you've worked with, Ram Perplexity. Most products won't have this interesting of a story to tell. How do you help find something that is a nugget?

**中文翻译:**
你提到了一系列合作过的优秀公司，比如 Ramp 和 Perplexity。但大多数产品并没有这么有趣的故事可讲。你如何帮助他们挖掘出那些有价值的“素材（nugget）”呢？

---

### [00:00:21] Emilie Gerber

**English:**
You can get so in the weeds with your own messaging that you want to set up this massive problem statement, you want to make it a huge trend story, but if you're very straightforward and you're pattern matching, it's generally actually going to work.

**中文翻译:**
你可能会深陷于自己的话术细节中（in the weeds），总想抛出一个宏大的问题陈述，或者把它包装成一个巨大的趋势故事。但实际上，如果你表现得非常直接，并且能够做到“模式匹配（pattern matching）”，通常效果反而会更好。

---

### [00:00:32] Lenny

**English:**
So I asked you to bring some examples of pitches that are great and also examples of pitches that could be better.

**中文翻译:**
所以我请你带了一些优秀的推介（pitch）案例，以及一些有待改进的案例。

---

### [00:00:39] Emilie Gerber

**English:**
I want to read one to you and then I want to see if you can tell me what this company does.

**中文翻译:**
我想读一个给你听，然后看看你能不能告诉我这家公司到底是做什么的。

---

### [00:00:44] Lenny

**English:**
Deal. Today, my guest is Emilie Gerber. Emilie is the founder and CEO of Six Eastern, a PR agency that has worked with over 100 tech companies, from stealth startups to publicly traded companies, helping them get press, build awareness, and level up their PR and comms strategy. Before starting her own firm, she worked at Uber where she led PR for the business development team and B2B programs. Prior to that, she worked at Box on product communications with a focus on product launches and partnership announcements. In our conversation, Emilie shares so many golden nuggets of advice on how to get press that I lost count.

**中文翻译:**
一言为定。今天的嘉宾是 Emilie Gerber。Emilie 是 Six Eastern 的创始人兼 CEO，这是一家公关机构，曾与 100 多家科技公司合作，从隐身模式（stealth）的初创公司到上市公司都有，帮助他们获得媒体报道、建立知名度并提升公关和传播策略。在创办自己的公司之前，她曾在 Uber 工作，负责业务发展团队和 B2B 项目的公关。在此之前，她在 Box 负责产品传播，重点是产品发布和合作伙伴公告。在我们的对话中，Emilie 分享了太多关于如何获得媒体报道的干货（golden nuggets），多到我都数不清了。

---

### [00:01:23] Lenny

**English:**
We talk about which publications to target depending on your market and story, how to craft your pitch and your outreach to reporters, how to actually reach reporters, and also how to craft your product story for people to pay attention to what you're doing, why warm introductions to reporters aren't actually that important, how to find podcasts and newsletters to pitch that might be even more effective than traditional media, how much it would cost you to work with a PR agency instead of doing it yourself, and how much lead time you need if you do that.

**中文翻译:**
我们讨论了如何根据你的市场和故事选择目标媒体；如何撰写推介信并联系记者；如何实际触达记者；以及如何打造你的产品故事以吸引人们的关注。我们还聊到了为什么记者的“熟人介绍（warm introductions）”其实没那么重要；如何寻找可能比传统媒体更有效的播客和时事通讯（newsletters）进行推介；聘请公关公司而非亲力亲为的成本是多少；以及如果你这样做需要多少准备时间（lead time）。

---

### [00:01:50] Lenny

**English:**
Also, we go through a few real-life examples of press and outreach, both good examples and bad examples, and what we can learn from those. Also, we look at a pitch that Emilie sent to me about a podcast guest that is a client of hers that worked, and this guest is coming out in the future, so we look at what was effective about that pitch, and so much more. If you enjoy this podcast, don't forget to subscribe and follow on your favorite podcasting app or YouTube, it's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that, I bring you Emilie Gerber after a short word from our sponsors.

**中文翻译:**
此外，我们还分析了几个真实的媒体报道和外联案例，包括正面和反面的例子，以及我们可以从中汲取什么教训。我们还研究了 Emilie 发给我的一封推介信，那是关于她的一位客户作为播客嘉宾的申请，那个推介成功了，这位嘉宾将在未来上线，所以我们分析了那封推介信的有效之处，还有更多精彩内容。如果你喜欢本播客，别忘了在你不常用的播客应用或 YouTube 上订阅和关注，这是避免错过未来节目的最好方式，也对本节目有巨大帮助。下面，在听完赞助商的简短介绍后，让我们欢迎 Emilie Gerber。

---

### [00:02:25] Lenny

**English:**
Let me tell you about a product called Sprig. Next gen product teams like Figma and Notion rely on Sprig to build products that people love. Sprig is an AI-powered platform that enables you to collect relevant product experience insights from the right users, so you can make product decisions quickly and confidently. Here's how it works. It all starts with Sprig's precise targeting, which allows you to trigger in-app studies based on users' characteristics and actions taken in product. Then Sprig's AI is layered on top of all studies to instantly surface your product's biggest learnings. Sprig Surveys enables you to target specific users to get relevant and timely feedback. Sprig Replays enables you to capture targeted session clips to see your product experience firsthand. Sprig's AI is a game changer for product teams, they're the only platform with product level AI, meaning it analyzes data across all of your studies to centralize the most important product opportunities, trends, and correlations in one real-time feed. Visit sprig.com/lenny to learn more and get 10% off. That's S-P-R-I-G.com/lenny.

**中文翻译:**
让我向你介绍一款名为 Sprig 的产品。像 Figma 和 Notion 这样的下一代产品团队都依赖 Sprig 来打造深受用户喜爱的产品。Sprig 是一个人工智能驱动的平台，能让你从目标用户那里收集相关的产品体验洞察，从而快速、自信地做出产品决策。它的工作原理如下：首先是 Sprig 的精准定位，允许你根据用户的特征和在产品中的行为触发应用内研究（in-app studies）。然后，Sprig 的 AI 会叠加在所有研究之上，瞬间呈现出产品中最重要的发现。Sprig Surveys 让你能针对特定用户获取相关且及时的反馈。Sprig Replays 让你能捕捉特定的会话片段，亲眼观察产品体验。Sprig 的 AI 是产品团队的“游戏规则改变者”，他们是唯一拥有产品级 AI 的平台，这意味着它能分析你所有研究中的数据，将最重要的产品机会、趋势和关联性集中在一个实时信息流中。访问 sprig.com/lenny 了解更多并享受九折优惠。

---

### [00:03:27] Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next-generation AB testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams. Companies like Twitch, Miro, ClickUp, and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and for understanding the performance of new features, and Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does. When I was at Airbnb, one of the things that I loved most was our experimentation platform. Bracket set up experiments easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more with advanced statistical methods that can help you shave weeks off experiment time and accessible UI for diving deeper into performance and out-of-the-box reporting that helps you avoid annoying prolonged analytics cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the AB testing flywheel, EPO powers experimentation across every use case, including product, growth, machine learning, monetization, and email marketing. Check out Eppo at getepo.com/lenny and 10 X your experiment velocity. That's get E-P-P-O.com/lenny. Emilie, thank you so much for being here and welcome to the podcast.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 AB 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依赖 Eppo 来支持他们的实验。实验对于推动增长和了解新功能表现越来越重要，Eppo 能帮助你提高实验速度（velocity），同时实现其他商业工具无法提供的严谨深度分析。我在 Airbnb 时，最喜欢的东西之一就是我们的实验平台。我可以轻松设置实验、排除故障并独立分析表现。Eppo 拥有先进的统计方法，可以帮你缩短数周的实验时间，其易用的 UI 和开箱即用的报告能帮你避免烦人的漫长分析周期。Eppo 还能让你轻松与团队分享实验洞察，激发 AB 测试飞轮的新灵感。Eppo 支持各种场景的实验，包括产品、增长、机器学习、变现和邮件营销。访问 getepo.com/lenny，让你的实验速度提升 10 倍。Emilie，非常感谢你能来，欢迎来到本播客。

---

### [00:04:59] Emilie Gerber

**English:**
Yeah, thank you for having me.

**中文翻译:**
好的，谢谢你邀请我。

---

### [00:05:01] Lenny

**English:**
So we're going to be talking about press. A lot of people say that trying to get press isn't really worth your time. It doesn't drive signups, it doesn't drive growth. You could spend your time on other things and have a lot more impact there, and I know that you have a really interesting perspective on second order effects of press and other benefits. So I'm curious to hear, what's your perspective on this idea, that press isn't really worth people's time and how can press be helpful?

**中文翻译:**
我们要聊聊媒体报道（press）。很多人说争取媒体报道其实不值得花时间，因为它不带来注册，也不带来增长。你可以把时间花在其他事情上，产生更大的影响。我知道你对媒体报道的“二阶效应（second order effects）”和其他好处有非常有趣的见解。所以我很好奇，你对“媒体报道不值得花时间”这个观点怎么看？媒体报道到底有什么用？

---

### [00:05:27] Emilie Gerber

**English:**
Yeah, when we were emailing about it, talking about some of the articles that you were in, some of the coverage that you got, I was thinking about how, in your case, you have multiple audiences. You have your customers, which in a way, are your listeners and the people that are engaging with your content. So in a way, you're a B2C business, but in another way, you're a B2B business. Obviously, you have sponsors and you're trying to attract really great guests to come on the show, and so there's a second order piece of the press is validating that you're something that a software company wants to sponsor. So internally, they're making those decisions. Not everyone might know Lenny's podcast, but they could send around a CNBC article and see that this is something very legit and something that people care about. It just signals that third-party validation that I think is really important, and that ties back to, when you look at a SaaS company or something and they're making decisions, having that validation, I think, and that credibility goes a really long way.

**中文翻译:**
是的，当我们通过邮件交流你参与的一些文章和报道时，我在想，以你为例，你拥有多重受众。你有客户，某种程度上就是你的听众和参与你内容的人，所以你像是一家 B2C 企业；但另一方面，你也是一家 B2B 企业。显然，你有赞助商，你还要吸引优秀的嘉宾上节目。媒体报道的二阶效应就在于“验证（validating）”——证明你是一个软件公司愿意赞助的对象。在公司内部做决策时，可能不是每个人都知道 Lenny 的播客，但他们可以转发一篇 CNBC 的文章，看到这是一个非常正规且受人关注的项目。这传递了一种我认为非常重要的“第三方背书（third-party validation）”。这可以追溯到 SaaS 公司做决策时，这种验证和公信力能起到很大的作用。

---

### [00:06:24] Emilie Gerber

**English:**
Especially for a company that might be early stage, they've raised a little bit of money, I think sometimes the buyers are skeptical of engaging with new tools, because they're worried they might not raise more funding, or it might go away tomorrow, and so the more that you can validate the business through things that's not just you doing personally that other people are doing, I think the better. So I think, yeah, that's the value from the B2B perspective and it's not necessarily going to directly drive signups, but when that AE is sending their sales emails and they can link to a story, I think that really helps. Also, candidates too, when you're reaching... If it's a recruiter reaching out on LinkedIn and they only have 100 characters to make their pitch, linking to that story can be really powerful.

**中文翻译:**
特别是对于那些可能处于早期阶段、刚融了一点钱的公司，买家有时会对使用新工具持怀疑态度，因为他们担心公司可能融不到下一轮资，或者明天就倒闭了。因此，你越能通过非个人行为（即他人的评价）来验证业务，效果就越好。所以，这就是 B2B 视角的价值。它不一定会直接带来注册，但当客户经理（AE）发送销售邮件并附上报道链接时，真的很有帮助。对于求职者也是如此，如果招聘人员在 LinkedIn 上联系他们，只有 100 个字符的空间来做推介，链接到那篇报道会非常有说服力。

---

### [00:07:03] Emilie Gerber

**English:**
So those are some of the second-order effects for B2B. And then, on the consumer side, it's a much more complex issue. There's affiliate marketing, which is this whole world of paid, where you're getting product reviews and that sort of thing, and that's not really an area that I'm an expert on, but we do work with some consumer companies where press is a major driver of growth. So for instance, Perplexity, they have invested essentially zero in any paid marketing, they don't have a marketing person even, but they do do PR. And so essentially, after their most recent announcement, they saw a massive spike in growth, a massive spike in signups, pro users, all of that. And I think, in that case, the reason PR works so well is...

**中文翻译:**
这些是 B2B 的一些二阶效应。而在消费者（C端）方面，情况要复杂得多。存在“联盟营销（affiliate marketing）”，这是一个付费领域，涉及产品测评之类的内容，那不是我擅长的领域。但我们确实与一些消费类公司合作，在这些公司中，媒体报道是增长的主要驱动力。例如 Perplexity，他们在付费营销上的投入基本为零，甚至没有专门的营销人员，但他们做公关（PR）。基本上，在他们最近一次发布公告后，他们看到了增长的巨大爆发，注册量、专业版用户等都大幅增加。我认为在这种情况下，公关之所以如此有效是因为……

---

### [00:07:47] Emilie Gerber

**English:**
First of all, it's something that's very easy to grasp. Google alternative. I know how to use Google, I've used Google a million times, you can go to perplexity.com. The barrier to trying the product is very low, you can quickly type in a query, get the answer, and then see the power of the tool. It takes one time to see the power of the tool. So in that case, I think just organic press is enough to generate that. There's not a long process to get the customers interested, so... Yeah. I mentioned very case to case, but in those instances, it works well,

**中文翻译:**
首先，它非常容易理解——“Google 的替代品”。我知道怎么用 Google，我用过无数次，你可以直接去 perplexity.com。尝试产品的门槛非常低，你可以快速输入一个查询，得到答案，然后立刻看到工具的强大。只需一次，你就能领略它的威力。所以在这种情况下，我认为仅仅是“自然媒体报道（organic press）”就足以产生这种效果。不需要漫长的过程来吸引客户兴趣。所以，虽然是因情况而异，但在这些案例中效果很好。

---

### [00:08:18] Lenny

**English:**
Man, there's so many threads I want to follow here. That was such an interesting answer. And by the way, I love Perplexity. I once tweeted a result I had when I was using Perplexity, and that was one of their default questions you could ask about strawberries. Apparently, strawberries are not one fruit, strawberries are a bundle of fruits and every little piece of a strawberry, those little red things, are individual fruits all bundled together, which blew my mind. I was like, "I need to share this," and so I wonder how much of their growth just comes from crazy things like that.

**中文翻译:**
天哪，这里有很多我想深入探讨的线索。这个回答太有趣了。顺便说一下，我也很喜欢 Perplexity。我曾经发过一条推文，展示我使用 Perplexity 的结果，那是关于草莓的一个默认问题。显然，草莓并不是一种水果，而是一簇水果，草莓上的每一个小红点都是独立的水果聚在一起，这让我大开眼界。我当时想，“我必须分享这个”，所以我很好奇他们的增长有多少是来自于这类疯狂的小知识。

---

### [00:08:45] Emilie Gerber

**English:**
Yeah, it's like the kind of tool where your mom could try it and instantly know how to use it. Yeah. It's good for weird questions, like what you just shared. That's where it comes in really handy.

**中文翻译:**
是的，它就是那种连你妈妈尝试一下都能立刻学会怎么用的工具。它非常适合处理像你刚才分享的那种古怪问题，那正是它大显身手的地方。

---

### [00:08:55] Lenny

**English:**
You did a great job just defaulting, "Here's weird questions you could ask," and then, wow, what an answer. Okay, so on the B2B side, I think this is really interesting. When people are thinking about doing the calculus of, "Is it worth investing and trying to get press for a B2B business?" Related to what we were talking about offline. So when I got these stories in Fast company, I got a story in CNBC, I got a story in Entrepreneur Magazine, and I was telling you I've seen zero growth impact from all these stories. And you'd think like, "Wow." I had a story in the magazine, Entrepreneur Magazine, print edition, and nothing comes from it as far as I can tell.

**中文翻译:**
你做得很好，默认就提供“你可以问的古怪问题”，然后，哇，答案太棒了。好，关于 B2B 方面，我觉得这很有趣。当人们在权衡（doing the calculus）“为 B2B 业务投资争取媒体报道是否值得”时，这与我们线下聊到的内容有关。当我在《Fast Company》、CNBC、《Entrepreneur》杂志上获得报道时，我告诉你，我没看到这些报道带来任何增长影响。你会觉得，“哇，我都上《Entrepreneur》杂志的印刷版了”，但据我所知，什么也没发生。

---

### [00:09:30] Emilie Gerber

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:09:30] Lenny

**English:**
And your point, which really stuck with me, is the real benefit isn't that first order growth impact, it's... And I've been doing this, it's when I'm emailing potential guests telling them, "Hey, check out my work or my profile in these magazines." And just having those little logos is really powerful, and that's why you see those logos on people's websites. So is your advice here, basically, for B2B businesses than most? If the pie chart of impact of press, most of that percentage is just having a logo of an awesome publication on your website and your outbound emails, and things like that?

**中文翻译:**
你的观点让我印象深刻：真正的益处不是那种一阶的增长影响，而是……我也一直在这么做，就是当我给潜在嘉宾发邮件时，我会说：“嘿，看看我在这些杂志上的作品或简介。”拥有那些小 Logo 真的非常有力量，这就是为什么你会看到人们在网站上放这些 Logo。所以你的建议是，对于大多数 B2B 企业来说，如果把媒体报道的影响力做成饼图，大部分比例其实就是为了在网站和外发邮件里放一个牛逼媒体的 Logo？

---

### [00:10:06] Emilie Gerber

**English:**
Yeah, the logo is a piece of it and then also the storytelling part. Maybe they're not going to read eight paragraphs that you wrote about your business, but if it's in the format of an article, I think they're more likely to take the time to do it. One other, I guess, aspect of it is content. So for instance, the articles that people want to write about you are not about necessarily how great your podcast is, which it is, but more about how you created this business. And so it's more through the lens of you're an entrepreneur, you have built this media empire, and so that's not necessarily the kind of story that's going to drive your core audience to sign up, and so contents is part of it, too. And so we work with companies where we get them great stories about their company culture and cool initiatives that they're doing, because reporters are interested in that topic. That's not going to help their sales, but it might help with something like recruiting. And so yeah, I think thinking... That's the other piece of it, is thinking through the content.

**中文翻译:**
是的，Logo 是一部分，另一部分是叙事。人们可能不会读你写的关于自己业务的八段文字，但如果它是以文章的形式呈现，他们更有可能花时间去读。另一个方面是内容。例如，人们想写的关于你的文章，不一定非得是你的播客有多棒（虽然确实很棒），而更多是关于你如何创立这项业务的。它是从“你是一个企业家，建立了一个媒体帝国”的角度出发的，这种故事不一定会吸引你的核心受众去注册，所以内容本身也是一部分。我们会帮一些公司在媒体上发布关于公司文化或酷炫举措的故事，因为记者对这些话题感兴趣。这虽然对销售没帮助，但可能对招聘有帮助。所以，思考内容是公关的另一个关键点。

---

### [00:11:03] Lenny

**English:**
That's such a good point, because the story they're going to write about you isn't, "This is the best product you've ever seen," this is, "Look at this interesting journey this startup has gone on," and that's not going to convince your customers, it's going to convince other people just to read this publication, but the fact that they wrote about you is really beneficial. And then you're saying B2C, most of the benefit is actually driving growth and you've seen lots of examples of press driving significant growth.

**中文翻译:**
这个点太好了，因为他们要写的关于你的故事不是“这是你见过最好的产品”，而是“看看这家初创公司经历的有趣旅程”。这说服不了你的客户，只能吸引读者阅读该刊物，但“他们报道了你”这个事实本身是非常有益的。然后你提到 B2C，大部分益处实际上是驱动增长，而且你见过很多媒体报道驱动显著增长的例子。

---

### [00:11:27] Emilie Gerber

**English:**
Yeah, I think it can be and I think this is one where, yeah, it a little more case-to-case, because we have some clients where they need to invest heavily in affiliate, because product reviews are what they need or they want to be on lists of the best vacuum cleaner, or whatever category, and it's less about getting them big features. And so there's different ways of doing it for B2C. But yeah, I do think it's like... Yeah, there's two camps, affiliate or not affiliate.

**中文翻译:**
是的，我认为确实如此。不过这更取决于具体情况，因为我们有些客户需要重金投入“联盟营销（affiliate）”，因为他们需要的是产品测评，或者想进入“最佳吸尘器”之类的榜单，而不是追求深度专题报道。所以 B2C 有不同的玩法。但我确实认为可以分为两派：联盟营销派和非联盟营销派。

---

### [00:12:00] Lenny

**English:**
Can you actually explain this affiliate bucket? Because I'm not actually that familiar with it.

**中文翻译:**
你能解释一下这个“联盟营销（affiliate）”范畴吗？因为我其实不太熟悉。

---

### [00:12:00] Emilie Gerber

**English:**
I can. However, we actually don't do affiliate marketing, so there's probably going to be a lot of people that have a much more insightful perspective on it, but affiliate is essentially when you work with a publication to give them a percentage of any sales that come from the piece of the article. And so if you look at Business Insider's list of best personal finance tools, it'll say at the top that they're getting commission. So they track the links, they figure out a certain percentage, and then they basically get a percentage of all the sales that come in, and it's very common. I would say most consumer companies are doing this, but yes, there's entire agencies that are dedicated to that field.

**中文翻译:**
可以。不过我们其实不做联盟营销，所以可能有很多人比我有更深刻的见解。简单来说，联盟营销就是你与媒体合作，从该文章带来的销售额中给他们一定比例的提成。如果你看《Business Insider》的“最佳个人理财工具”列表，顶部会注明他们会收取佣金。他们追踪链接，计算百分比，然后从带来的销售额中拿成。这非常普遍，大多数消费类公司都在这么做，甚至有专门负责这一领域的代理机构。

---

### [00:12:38] Lenny

**English:**
Wow, I didn't actually know that was such a big thing. I've heard of affiliate marketing where you get paid for promoting something, I didn't know Business Insider did this as a revenue.

**中文翻译:**
哇，我真不知道这已经成了一个这么大的产业。我听过联盟营销是推广东西拿钱，但我不知道《Business Insider》也把这当作收入来源。

---

### [00:12:48] Emilie Gerber

**English:**
Yeah, and I don't want to call out just... I mean, I would say every publication that's doing product reviews for the most part, I believe, it's a very common practice.

**中文翻译:**
是的，我不想只点名某一家……我的意思是，据我所知，绝大多数做产品测评的媒体，这都是非常普遍的做法。

---

### [00:12:58] Lenny

**English:**
Wow. All right, already learning a lot. Okay, so I definitely want to start talking about how to actually get press for your product, but one quick question about fundraising announcements. So I'm an investor in a lot of companies, very often, they email me and ask for advice how to get press and, most of the time, it's a fundraising milestone. When is it worth investing trying to get press and fundraising? Like always worth trying, rarely worth your effort? Does it have to be some really impressive fundraising moment? What do you suggest?

**中文翻译:**
哇，已经学到很多了。好，我非常想开始聊聊如何为产品争取媒体报道，但在那之前，关于“融资公告”有个小问题。我投资了很多公司，他们经常发邮件问我如何获得媒体报道，大多数时候都是因为融资到了某个里程碑。什么时候值得为融资消息投入精力去争取报道？是永远值得一试，还是很少值得费力？必须是非常惊人的融资时刻吗？你有什么建议？

---

### [00:13:32] Emilie Gerber

**English:**
I also think not all PR people are going to agree with this, but I do think funding rounds, you can always get a reporter to cover if you go about it the right way. I mean, we scope out projects that are just for funding announcements, we've never had to not finish that project or we've never... I wouldn't do that if it wasn't possible, so I think there's a couple of reasons that it sometimes doesn't work out. But I guess just to take a step back on funding stories, a lot of founders automatically think that, "I raise money, so TechCrunch will cover this." The reality is... Someone tweeted, actually someone from another agency, I should... Propeller PR, they tweeted that they counted how many funding stories TechCrunch did in a week, and it was nine, so they had written nine funding stories in one week. And then they counted how many funding rounds actually happened that week by looking at Axis Parata and Fortune Term Sheet, and it was like 50.

**中文翻译:**
我想并不是所有的公关人员都会同意这一点，但我认为，只要方法得当，融资轮次总能吸引记者报道。我的意思是，我们会承接专门针对融资公告的项目，而且从未失败过。如果不可行，我也不会接。我觉得有时不成功是有原因的。但退一步说，关于融资故事，很多创始人自动认为“我融到钱了，TechCrunch 就会报道”。现实是……有人发过推文，好像是另一家机构 Propeller PR 的人，他们统计了 TechCrunch 一周报道了多少融资故事，结果是 9 个。然后他们通过查看 Axios Pro Rata 和 Fortune Term Sheet 统计了那一周实际发生的融资轮次，大约有 50 个。

---

### [00:14:26] Emilie Gerber

**English:**
So it seems... When you go to TechCrunch, it looks like, "It's all funding stories, so mine should be one of these." That's not the case at all. But I do think, if you go about it the right way, you can be one of those nine. And I'm talking about TechCrunch specifically here only because the reality is they are the publication that's going to be most likely to write your funding story, that's just kind of the way it works. And it's not a bad thing, they're actually... They don't have a paywall, they tend to do a very good job, they understand it. It's a well-oiled machine, and so we know if you've done a story with them, it's going to pretty much go how you want to plan it. So when you go to pitch a funding story, I think the first thing that founders, or whoever is reaching out on behalf of the company, does wrong is they convolute the message.

**中文翻译:**
所以看起来……当你打开 TechCrunch，满眼都是融资故事，你会觉得“我的也应该是其中之一”。事实并非如此。但我认为，如果你方法正确，你可以成为那 9 个之一。我这里专门提到 TechCrunch，是因为现实中他们是最有可能写你融资故事的媒体，行业规则就是这样。这并不是坏事，他们其实……没有付费墙，做得非常专业，很懂行。这是一个运转良好的机器，所以我们知道如果你和他们合作，事情基本上会按计划进行。当你去推介融资故事时，我认为创始人或代表公司的人犯的第一个错误就是把信息搞得太复杂。

---

### [00:15:10] Emilie Gerber

**English:**
When we pitch a funding story, we make it very clear, "Hey, we're reaching out with a startup launch or funding. We're offering this to you as an exclusive, meaning we're not going to pitch anyone else if you take the story. Here's the amount that's raised, here's the space that... Here's the space they're in and here are the investors." I think you can get so in the weeds with your own messaging, that you want to set up this massive problem statement, you want to make it a huge trend story. You don't really say what you're trying to accomplish from it, but if you're very straightforward and you're pattern matching, "Hey, this TechCrunch reporter is the one that covers FinTech. I have a FinTech funding round, here's the reason my FinTech funding round matters." It's generally actually going to work and now it does 100% takes follow up.

**中文翻译:**
当我们推介融资故事时，我们会说得很清楚：“嘿，我们有一家初创公司的发布或融资消息。我们向你提供‘独家（exclusive）’，意味着如果你接了这个故事，我们就不会再找别人。这是融资金额，这是他们所在的领域，这是投资者。”我觉得你可能会陷入自己的话术细节中，总想建立一个宏大的问题陈述，或者把它做成一个巨大的趋势故事，却没说清楚你想达到什么目的。但如果你非常直接，并且进行“模式匹配”——“嘿，这位 TechCrunch 记者是负责金融科技（FinTech）领域的。我有一个金融科技的融资轮次，这是为什么它很重要的原因。”这通常是有效的。当然，这 100% 需要后续跟进。

---

### [00:15:50] Emilie Gerber

**English:**
You're not shooting off one email, you are respectfully following up. When I follow up, I like to come in with some new information, whether it's something they had tweeted in the past couple of days, a new article that they wrote, very respectful. I try to wait three or four days. If it's not going anywhere, then try someone else. Do that three or four times with the most relevant reporters. Generally, I think it works. Yeah, I think if you can just be really concise and direct and say what you're looking for out of the relationship, it tends to be a pretty easy process. And yeah, TechCrunch is one publication, but this actually goes for a bunch.

**中文翻译:**
你不是只发一封邮件就完事了，你要礼貌地跟进。当我跟进时，我喜欢带入一些新信息，比如他们过去几天发的推文，或者他们写的新文章，表现得非常尊重。我会尝试等待三四天。如果没进展，就换个人试试。对最相关的记者重复这个过程三四次。通常我认为是有效的。是的，如果你能保持简洁直接，并说明你希望从这段关系中得到什么，过程往往会比较顺利。TechCrunch 只是其中一家媒体，但这套方法适用于很多媒体。

---

### [00:16:24] Lenny

**English:**
Amazing. I love that we're already getting into tactical advice for how to actually get press. So that was essentially for fundraising and the notes I took is keep it really simple, "Here's how much we raise, here's our investors. Here's one line about why this matters." I want to talk later about how pitching press is different for customers, because with customers, I think this is probably the mistake a lot of people make, and we don't have to get into this just yet, but you want to paint the picture of the market and trends and, "Here's where the market's going and why this is huge and why this is a solution to your problem," versus, "Bam, this is interesting for this reason," and that's it.

**中文翻译:**
太棒了。我喜欢我们已经进入了如何获得媒体报道的实操建议。关于融资，我记下的笔记是：保持简单，“这是融资金额，这是投资者，这是为什么这很重要的一句话总结。”我稍后想聊聊面向客户的推介有何不同，因为对于客户，我觉得很多人会犯错（我们先不深入），你可能想描绘市场蓝图和趋势，“市场正走向何方，为什么这前景巨大，为什么这是解决你问题的方案”，而不是直接说“砰，因为这个原因，这很有趣”，然后就没了。

---

### [00:16:56] Emilie Gerber

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:16:57] Lenny

**English:**
Okay. I want to talk about publications to target and what each one is best suited for. So you're talking about how TechCrunch is essentially really good for fundraising. When I think about other publications, there's like Axios and Verge, I don't know if they do press stories like this. Wall Street Journal, New York Times, things like that. So I guess, what are the different publications people should have on their list of target? And then, what are each of them most aligned to, story-wise?

**中文翻译:**
好。我想聊聊目标媒体以及各自最适合报道什么。你提到 TechCrunch 非常适合融资消息。当我想到其他媒体时，比如 Axios 和 The Verge，我不知道他们是否做这类报道。还有《华尔街日报》、《纽约时报》之类的。所以，人们的目标清单上应该有哪些不同的媒体？从故事的角度来看，它们各自最契合什么？

---

### [00:17:28] Emilie Gerber

**English:**
I really love this question. I feel like no one ever gets this tactical in PR. There's just so much theoretical conversation and examining the big blunders and... It's all so high level, but at the end of the day, if you are a startup that wants to get coverage for your company, you need to know actually the steps to take to do it. So yeah, I appreciate that question. I'm going to answer it, but also answer it with the caveat that media changes so much and so fast. For instance, just a couple weeks ago, TechCrunch decided they no longer accept op-eds, which is... It's actually huge news for us, because we love doing op-eds in TechCrunch, and so things change all the time, but I will talk about it in its current state. So yes, TechCrunch, a go-to for a lot of funding announcements. A go-to for some product news, too, even sometimes.

**中文翻译:**
我非常喜欢这个问题。我觉得在公关领域，很少有人讲得这么细。有太多的理论对话和对重大失误的剖析……都太高大上了。但归根结底，如果你是一家想要获得报道的初创公司，你需要知道具体的执行步骤。所以我很感谢这个问题。我会回答它，但也要提醒一点：媒体行业变化极快。例如，就在几周前，TechCrunch 决定不再接受“评论文章（op-eds）”，这对我们来说是巨大的新闻，因为我们喜欢在 TechCrunch 发评论文章。所以情况一直在变，但我会根据现状来谈。是的，TechCrunch 是很多融资公告的首选，有时也是一些产品新闻的首选。

---

### [00:18:15] Emilie Gerber

**English:**
I would say the areas where they don't have dedicated beat reporters, where we tend to end up not working with them, are health tech-related companies and even MarTech, too. We've struggled to find the right folks to cover those kinds of stories. So not everything, but generally, if you do your digging, you're able to find a relevant beat reporter or a couple of relevant beat reporters, and it's not just about getting coverage there. They have TechCrunch Disrupt, you can apply for speaking at that conference, and that sometimes actually directly turns into coverage. They have The Found Podcast, which interviews founders, and so if you have a really compelling founder story or topical founder story, that can be an excellent avenue to go as well. They have The Equity Pod, which is investment advice, so it's not just thinking about getting that one funding story with them, there are other ways to work with TechCrunch.

**中文翻译:**
我会说，在他们没有专门“跑线记者（beat reporters）”的领域，我们往往不会找他们，比如医疗科技相关的公司，甚至营销科技（MarTech）也是。我们很难找到合适的人来报道这类故事。所以不是涵盖所有领域，但通常如果你深入挖掘，总能找到一两个相关的跑线记者。而且不仅仅是为了获得报道，他们还有 TechCrunch Disrupt 大会，你可以申请演讲，有时这会直接转化为报道。他们还有《The Found》播客采访创始人，如果你有引人入胜的创始人故事或话题性故事，那也是一个极好的渠道。他们还有《The Equity》播客提供投资建议。所以不要只想着发一篇融资故事，和 TechCrunch 合作还有很多其他方式。

---

### [00:19:02] Emilie Gerber

**English:**
And I actually have heard really great feedback from clients on TechCrunch driving website traffic, the day of the announcement, especially... I haven't really been able to pinpoint when that does or doesn't happen. I'm trying to figure out if there's trends among that, but I have... Clients have sent me screenshots from the day of the announcement and they've seen a nice pickup from TechCrunch, so I think a lot of that comes down to the fact that they don't have a paywall, but their stuff tends to do really well. So it's a great spot, especially for that first piece on your company. Axios is really strong on the FinTech side, on the healthcare side, they have some really great beat reporters. The one thing I'll say about them is they're very deals-focused, so 100% would need to either have funding. If you're announcing a partnership that has a monetary component, that they would cover that. An acquisition they would consider covering, but they're not going to be... You should never pitch them on a product announcement.

**中文翻译:**
我确实听过客户的反馈，说 TechCrunch 在发布公告当天能带来巨大的网站流量。我还没能完全确定这种情况发生的规律，但我看过客户发来的截图，TechCrunch 带来的引流效果很棒。我认为这很大程度上归功于他们没有付费墙，而且内容质量很高。所以这是一个绝佳的位置，尤其是作为公司的第一篇报道。Axios 在金融科技和医疗保健方面非常强势，有一些很棒的跑线记者。关于他们，我要说的一点是，他们非常关注“交易（deals）”，所以你必须有融资消息。如果你宣布一个涉及金钱的合作伙伴关系，他们可能会报道；如果是收购，他们也会考虑。但你永远不要向他们推介产品发布。

---

### [00:19:58] Emilie Gerber

**English:**
And I think they might just get annoyed. There's a couple exceptions, a couple of the reporters might have little columns where they feature product-related things, but that's just not their bread and butter. And actually, Axios recently launched, or I guess has been launching over the past year or so, local editions. So they're really branching into local news, and so that can actually be a really nice way to get an Axios hit if you have a region-specific story. So I highly recommend checking that out. Another publication that we work with a bunch is Business Insider. If you struggle to pitch your funding story but really want it out in the world, they are big on the pitch deck stories. Those are a little controversial. Some founders, they're like, "This is not what I want my story to be about, I do not want to share my pitch deck."

**中文翻译:**
我觉得他们可能会感到厌烦。虽然有少数例外，有些记者可能有专门介绍产品的小专栏，但那不是他们的主业。实际上，Axios 最近（或者说过去一年左右）推出了地方版。他们正深入地方新闻，所以如果你有一个特定地区的故事，这可能是登上 Axios 的好方法。我强烈建议关注一下。另一家我们经常合作的媒体是《Business Insider》。如果你在推介融资故事时遇到困难，但又非常想发布，他们非常喜欢“融资计划书（pitch deck）”类的故事。这类故事有点争议，有些创始人会觉得“这不是我想讲的故事，我不想分享我的计划书”。

---

### [00:20:44] Emilie Gerber

**English:**
But if you are in the camp of... You're open to that and you can redact, it does not need to have all the financials, it does not need to have the growth metrics, that can be a really great way to get a piece of coverage on your business. And the way that I explain it to clients is you're just getting all your core messages out there in a very direct way. You're sharing exactly what you shared with investors, that's not necessarily a bad thing. And sometimes clients will put in some customer slides, too, and so you can really make it a little bit more like what you're looking for. So yes, if you're looking for a funding story, TechCrunch passed, others passed, that's a good option. They also are huge on the entrepreneurial journey pieces, similar to the CNBC article that you got, but they really want metrics, they really push for metrics, so how much you're making, how much you're spending.

**中文翻译:**
但如果你属于那种……持开放态度并且可以对敏感信息进行脱敏处理的人，它不需要包含所有的财务数据或增长指标，这可能是获得业务报道的一个极好方式。我向客户解释的方式是：你只是以一种非常直接的方式把核心信息传递出去。你分享的正是你分享给投资者的东西，这不一定是坏事。有时客户还会加入一些关于客户的幻灯片，所以你可以把它打造成你想要的样子。所以，如果你想发融资故事，TechCrunch 拒绝了，其他媒体也拒绝了，这是一个好选择。他们也非常看重“创业历程”类的文章，类似于你上的那篇 CNBC 文章，但他们非常看重指标，会极力要求提供数据，比如你赚了多少，花了多少。

---

### [00:21:35] Emilie Gerber

**English:**
They love those kinds of stories, so it's not necessarily about how much you raise, but for people that have really built a business. And then the last thing for Business Insider, they do a bunch of these lists of top startups, of top professionals in the field. We love doing those, they're generally a really light list, and they put out a call for submissions. Takes five minutes and it's a way to get into Business Insider. There's so many of them, it's become a joke within my newsletter, because every week, there's five more and it's the most obscure different categories. Like top sports marketing professionals helping TikTok stars. I don't know, it's always a very niche ask, but those could be really great. Then a couple more.

**中文翻译:**
他们喜欢这类故事，所以不一定是关于你融了多少钱，而是关于那些真正建立起业务的人。关于《Business Insider》最后一点是，他们会做很多“顶级初创公司”或“领域内顶级专业人士”的榜单。我们很喜欢做这些，通常是很轻松的列表，他们会发布征稿通知。只需五分钟，这就是进入《Business Insider》的一种方式。这类榜单太多了，在我的时事通讯里都成了一个笑话，因为每周都会多出五个，而且类别极其冷门。比如“帮助 TikTok 明星的顶级体育营销专业人士”。我也不知道，总是非常小众的要求，但这些可能非常有用。然后再说几个。

---

### [00:22:16] Emilie Gerber

**English:**
VentureBeat is huge for AI news. We pitch them all the time for any client that we work with that is building AI capabilities, has a new offering related to AI, perfect publication for that. Fast Company is perfect for anything related to future of work, how people work. Really great for design, media, I would say perfect for any company that fits in those categories. They're also really open to op-eds, especially with leadership advice in them. And last but not least, on the list of ones that we work with most often, I would say is Forbes. Especially on the award side, they have the FinTech 50, AI 50, Forbes Under 30, all of that. And you're not going to get a feature with one of their main reporters until you're a bit further along, but they do have that really strong contributor network, which is much... A lower bar in what they'll accept, in a way. They're more open to covering earlier stage companies, so that's worth checking out, too. So those are my top ones, I'll stop there.

**中文翻译:**
VentureBeat 在 AI 新闻方面影响力巨大。我们经常向他们推介那些正在构建 AI 能力或有 AI 相关新产品的客户，那是完美的发布平台。《Fast Company》非常适合任何与“未来工作方式”或“人们如何工作”相关的内容。它对设计、媒体也非常友好，适合属于这些类别的任何公司。他们对评论文章也非常开放，尤其是包含领导力建议的文章。最后但同样重要的是《福布斯》。特别是在奖项方面，他们有金融科技 50 强、AI 50 强、福布斯 30 位 30 岁以下精英榜等等。在你发展到一定阶段之前，你很难获得他们主要记者的深度专题报道，但他们确实拥有强大的“撰稿人网络（contributor network）”，某种程度上准入门槛较低。他们对报道早期公司更开放，所以也值得关注。这些是我最推荐的，先说这么多。

---

### [00:23:15] Lenny

**English:**
That's amazing. And those are the most commonly requested and the ones you mostly go after?

**中文翻译:**
太棒了。这些是客户最常要求的，也是你们主要争取的媒体吗？

---

### [00:23:20] Emilie Gerber

**English:**
Yeah, they're the most realistic for most startups. There are ones like The Verge, and they're a little more gadget-focused and just areas that we don't necessarily touch, but could be good for some companies as well.

**中文翻译:**
是的，对于大多数初创公司来说，这些是最现实的目标。还有像 The Verge 这样的媒体，他们更关注数码产品（gadgets），那不是我们经常涉足的领域，但对某些公司来说可能也很合适。

---

### [00:23:33] Lenny

**English:**
Got it, and then... I was going to say this for later, but there's obviously New York Times and The Wall Street Journal. Thoughts on going after those?

**中文翻译:**
明白了。然后……我本来想晚点再问，但显然还有《纽约时报》和《华尔街日报》。对于争取这些媒体有什么看法？

---

### [00:23:42] Emilie Gerber

**English:**
Yeah, we do get those questions all the time. I would say it comes up on calls with founders, "I want one out of every five." And really, when you look at... I make a joke sometimes like, "If you want those, just have a crisis and they'll write about it." Fire your CEO or do really intense layoffs and have some regulatory issue.

**中文翻译:**
是的，我们经常被问到这个问题。在和创始人的通话中，总有人说“我希望每五篇报道里就有一篇是这些媒体的”。但实际上，我有时会开玩笑说：“如果你想上这些媒体，只要搞出个危机，他们就会写了。”比如解雇你的 CEO，或者进行大规模裁员，或者出现监管问题。

---

### [00:24:00] Emilie Gerber

**English:**
Playoffs and have some regulatory issue and you'll get a story there.

**中文翻译:**
裁员或者出现监管问题，你就能在那儿获得报道。

---

### [00:24:04] Lenny

**English:**
Uber got a lot of stories there.

**中文翻译:**
Uber 当初在那儿可有不少故事。

---

### [00:24:06] Emilie Gerber

**English:**
Yeah, I can show some examples there. When you look at earlier stage companies that are getting coverage in those publications, that's what's happening. Now, let's say you're a tiny bit further along and you're series B, series C, maybe even series C, and you're looking for coverage in those publications, there's a couple criteria that they're always going to want if it's to write a feature on your company. One is your valuation, so that needs to be something that you're sharing on the record. Two is your hard business metrics, usually revenue, sometimes something else. And so oftentimes they'll tell founders that and immediately they're like, "Oh, well we're not sharing that." So I'm like, "Okay, well that's kind of the end of the conversation." Sometimes it can be shared on background, but as a general rule, you're expected to share that sort of thing. So that's kind of a nonstarter a lot of times.

**中文翻译:**
是的，我可以举出一些例子。当你看到早期公司在这些刊物上获得报道时，通常就是因为这些事。现在，假设你发展得稍微好一点，到了 B 轮、C 轮，你想在这些媒体上获得报道，如果他们要写一篇关于你公司的专题，通常有两个标准：一是你的估值，这必须是你可以公开记录（on the record）分享的；二是你的硬性业务指标，通常是营收，有时是其他数据。记者经常会告诉创始人这些要求，创始人立刻就说：“噢，我们不分享这些。”于是我就说：“好吧，那谈话基本上就结束了。”有时可以作为“背景信息（on background）”分享，但通常情况下，你被期望分享这类信息。所以这在很多时候是谈不拢的。

---

### [00:24:51] Emilie Gerber

**English:**
I totally think it makes sense to build relationships with the relevant beat reporters and ideally shoot for... When I say build relationships, I just mean shoot for an intro meeting on behalf of the clients, or they can reach out directly with those kinds of reporters, but they're just not going to write a feature on your company. If anything, you are going to be one or two sentences in a larger story of something that they're writing about. And yeah, that's just the nature of their coverage. And then when you look at something like CNBC, they're targeting people that want to learn about public markets. And so if you're not a public company, they have their CNBC Disruptor 50 list, which is focused on companies that will soon be at that stage, but it's not going to be a place for early stage companies.

**中文翻译:**
我完全认为与相关的跑线记者建立关系是有意义的，理想情况下是争取……当我提到建立关系时，我只是指代表客户争取一个介绍性的会面，或者他们可以直接联系那些记者，但他们就是不会为你的公司写专题报道。如果有的话，你也只是他们正在写的某篇大报道中的一两句话。是的，这就是他们报道的性质。再看像 CNBC 这样的媒体，他们的目标受众是想了解公开市场的人。所以如果你不是上市公司，他们有“CNBC Disruptor 50”榜单，关注的是即将达到那个阶段的公司，但它不适合早期公司。

---

### [00:25:32] Lenny

**English:**
When I have these pieces in past company and CNBC, it was such a weird experience where I chat with them for half an hour and then it just comes out, and I have no idea what they're going to write about. Could be a complete tear down of everything I'm doing and you have no idea. How do you help try to avoid that sort of story? I know you have no control. Obviously reporters can write what they want to write about. Do you have any advice for how to avoid them writing something really negative about you?

**中文翻译:**
当我在《Fast Company》和 CNBC 上有报道时，那是一种很奇怪的经历：我和他们聊了半小时，然后报道就出来了，我完全不知道他们会写什么。可能是对我所做的一切进行彻底的抨击，而你事先一无所知。你如何帮助避免这类故事？我知道你无法控制，记者显然可以写他们想写的东西。你有什么建议可以避免他们写一些关于你的负面内容吗？

---

### [00:25:58] Emilie Gerber

**English:**
Generally, if it's something that you're being briefed in advance, unless it is around something negative that's going on, it's just not their intention, it's just not going to happen. But what is a bigger issue is it not being the angle or the messaging that the company wants. And so part of that, there's absolutely nothing that we can do. Reporters are not our employees. We're not paying them to write these pieces. They have to maintain their editorial integrity. And so I consider it my job to educate the founders and spokespeople that we work with that we cannot change anything the story says. What we can do is correct any factual inaccuracies, and we do that all the time. If something is factually wrong, we can get it replaced. But if they don't like that they were called, put in a category of software that they don't identify with, that's not something that we can fix.

**中文翻译:**
通常情况下，如果你提前接到了简报，除非是围绕正在发生的负面事件，否则那不是他们的意图，负面报道也就不会发生。但更大的问题是，报道的角度或传达的信息可能不是公司想要的。对此，我们完全无能为力。记者不是我们的员工，我们没付钱让他们写这些文章。他们必须保持编辑独立性。因此，我认为我的工作是教育与我们合作的创始人和发言人：我们无法改变故事的任何内容。我们能做的是纠正任何事实错误，我们一直在这么做。如果事实有误，我们可以要求更正。但如果他们只是不喜欢被归类为某种他们不认同的软件类别，那是我们无法修复的。

---

### [00:26:50] Emilie Gerber

**English:**
Another thing that you can do though to prevent that from happening is just really ensuring that the spokesperson before talking to the reporter is going to nail the messages that they want. The more that you can reiterate over and over again how you want the article to be, I think the more likely that it'll land in the reporter's head and make sure that the reporter really understands what you're building and what your goals are. And all you can do is really use the briefing and the materials that you provide to kind of sway and influence, but there's not much beyond that.

**中文翻译:**
不过，为了防止这种情况发生，你可以做的另一件事是：确保发言人在与记者交谈之前，已经牢牢掌握了他们想要传达的信息。你越是反复强调你希望文章呈现的样子，它就越有可能印在记者的脑海里，确保记者真正理解你正在构建的东西和你的目标。你真正能做的就是利用简报和提供的材料来进行某种程度的引导和影响，除此之外别无他法。

---

### [00:27:20] Lenny

**English:**
So we've talked about all these publications. These are ones to consider going after. You also mentioned podcasts and awards as something people go after. Is there a tip you could share of how to find aligned podcasts or awards, like how you find a list of here we should go after these?

**中文翻译:**
我们聊了这么多媒体，这些都是值得考虑的目标。你还提到了播客和奖项也是人们追求的目标。你能分享一些技巧吗？如何找到契合的播客或奖项？比如你怎么列出“我们应该争取这些”的清单？

---

### [00:27:35] Emilie Gerber

**English:**
We use Google. We just use search engines basically for finding everything. And the way that we go about it is first figuring out who their customers are and what vertical they're in, and then just doing searches for podcasts that are within that vertical. But it's not as easy as just reaching out to the ones that pop up first. The next step is a qualitative analysis. First of all, do they have vendor CEOs or vendor executives on their show? Let's say your product is sold to product managers. Maybe they only have product managers on the show. So instead you don't put the CEO forward and you put the right spokesperson-

**中文翻译:**
我们用 Google。基本上我们用搜索引擎来找一切。我们的方法是先弄清楚他们的客户是谁，他们属于哪个垂直领域，然后搜索该领域内的播客。但这并不像联系搜索结果排在第一位的那些那么简单。下一步是“定性分析（qualitative analysis）”。首先，他们的节目会邀请供应商的 CEO 或高管吗？假设你的产品是卖给产品经理的，也许该节目只邀请产品经理。所以，这种情况下你不要推介 CEO，而是推介合适的发言人——

---

### [00:28:11] Lenny

**English:**
Who could that be? What podcast might that be referring to?

**中文翻译:**
那会是谁呢？这指的是哪个播客呢？（注：Lenny 在开玩笑指他自己的播客）

---

### [00:28:12] Emilie Gerber

**English:**
Yeah, right? But this could be for CFOs. So let's say you sell into CFOs. Don't pitch your CEO for that podcast. Get a CFO and then pitch your CFO for that podcast. I'm very for companies hiring folks, or hiring so the roles that they sell into, it helps us a lot. So if your audience is a CFO, it really helps if you have a CFO. If your audience is a CMO, it really helps if you have a CMO, and that actually when your earlier stage isn't always the case, and so it's a lot harder to pitch. So I think that's the second part of the qualitative analysis.

**中文翻译:**
是吧？但这也可以针对 CFO。假设你卖东西给 CFO，不要为那个播客推介你的 CEO。找一个 CFO，然后推介你的 CFO 上节目。我非常支持公司雇佣那些他们所针对的职能角色的人，这对我们很有帮助。如果你的受众是 CFO，如果你自己公司就有 CFO，那就很有帮助。如果受众是 CMO，有 CMO 就很好。但在早期阶段，情况往往并非如此，所以推介起来要困难得多。我认为这是定性分析的第二部分。

---

### [00:28:48] Emilie Gerber

**English:**
The third is, podcasts really come and go, make sure... It sounds obvious, but make sure it's one that's actively producing. When you Google ones, half of them are not going to be active podcasts. And then the third is actually listening to at least part of one episode, making sure the quality is high, making sure it's the kind of thing you even want to associate yourself with. And then just looking at who the past guests are, is that the kind of peers that you want to associate yourself with? And then one other thing that you can do is just in conversations with customers, find out what they're listening to, find out what they're watching, find out their media diet. It doesn't have to be a big crazy survey that you send to your entire customer base. It can be casual. If you're farther along, it's great if you can make that a more formal sort of process, but it doesn't necessarily need to be.

**中文翻译:**
第三点是，播客真的来得快去得也快，要确保……这听起来很显而易见，但要确保它还在活跃更新。当你 Google 时，一半的播客可能已经停更了。然后是实际听一下至少一集的一部分，确保质量很高，确保那是你想与之关联的节目。再看看过去的嘉宾是谁，那是你想结交的同行吗？另一件事是，在与客户交谈时，了解他们在听什么、看什么，了解他们的“媒体食谱（media diet）”。不需要向整个客户群发送疯狂的大型调查，随口问问就行。如果你发展得比较成熟了，能把它变成一个更正式的过程当然更好，但也不一定非得如此。

---

### [00:29:33] Emilie Gerber

**English:**
And then in terms of reaching out, I highly recommend figuring out who the host is, just doing the research, figuring out who the host is, and then just sending them a casual note. I'm a big fan of just reaching out on LinkedIn and saying, "Hey, love the show. Are you open to guest ideas?" I don't even mention the client or anything, just opening the door. I just feel like that's so much more approachable and friendly than starting with a big pitch. And I think so many people start with this very long email introducing themselves or going really deep and you don't have to do that. And especially because maybe only one out of every 10 replies, it'll also save you a lot of time if you just start with something really lightweight.

**中文翻译:**
至于联系方式，我强烈建议弄清楚主持人是谁，做点研究，然后发一封随意的简信。我很喜欢在 LinkedIn 上联系并说：“嘿，很喜欢你的节目。你接受嘉宾建议吗？”我甚至不提客户或任何具体内容，只是敲敲门。我觉得这比一开始就抛出一大堆推介要亲切友好得多。我觉得很多人一开始就发一封很长的邮件介绍自己或深入细节，其实没必要。特别是考虑到可能每 10 个人里只有 1 个会回复，如果你从非常轻量的内容开始，也能为你节省很多时间。

---

### [00:30:15] Lenny

**English:**
I think that actually works really well. That's what I find is if it's a simple little message, I'm like, yeah, let me know what you got in mind. Even though 99% of the time it doesn't work out, sometimes it works out great. And so I find, sure, let's just see what you got. And then usually I'm just like, "Nope, sorry, not a fit."

**中文翻译:**
我觉得这确实很有效。我发现如果是一条简单的小消息，我会回：“好啊，说说你的想法。”虽然 99% 的情况下都不合适，但有时效果非常好。所以我觉得，行吧，看看你有什么。然后通常我只是回：“不，抱歉，不合适。”

---

### [00:30:28] Emilie Gerber

**English:**
And you get the reply that way. If you send the initial pitch and the reporter or podcast host isn't interested, chances are they won't reply. But if you just start with something friendly and they reply, they'll feel like, I guess a little more of a connection there, and so at least you'll get an answer. Whereas otherwise, you might not get an answer at all.

**中文翻译:**
这样你就能得到回复。如果你直接发推介信，而记者或播客主持人不感兴趣，他们很可能根本不回。但如果你先从友好的问候开始，他们回复了，就会建立起一点点联系，至少你能得到一个明确的答复。否则，你可能石沉大海。

---

### [00:30:48] Lenny

**English:**
On the survey piece I think that's a great idea, and I've seen a few of my sponsors do this where they ask their customers, what podcast do you listen to? What newsletters do you read? Which is such a simple idea, but I think people don't do that. And just from that you could figure out, okay, here's the podcast we got to get on. Here's the newsletters we want to run after.

**中文翻译:**
关于调查那个点，我觉得是个很棒的主意。我见过一些赞助商这样做，他们问客户：你听什么播客？读什么时事通讯？这主意很简单，但我觉得很多人都没做。仅仅通过这一点，你就能弄清楚：好，这是我们必须上的播客，这是我们要争取的时事通讯。

---

### [00:31:06] Lenny

**English:**
I want to talk about how to actually pitch well. But before that, we've been talking a bit about who to reach out to and how to do that. So there's a few questions here. It's just like how important is it to have a warm connection to a reporter? If you don't have that, what's the best way to reach out to them? Is it LinkedIn, is it Twitter DMs, something else? What advice do you have about, just before we get into the structure of the pitch, figuring out who to pitch and then how to get to that advice?

**中文翻译:**
我想聊聊如何真正做好推介。但在那之前，我们聊了联系谁以及怎么联系。这里有几个问题：与记者建立“熟人关系（warm connection）”有多重要？如果没有，联系他们的最佳方式是什么？是 LinkedIn，Twitter 私信，还是别的？在进入推介结构之前，关于确定推介对象以及如何触达他们，你有什么建议？

---

### [00:31:34] Emilie Gerber

**English:**
Who are your relationships question comes up on a lot of our calls with founders as well. I'd like to pose the question to you. Did we have a relationship before this?

**中文翻译:**
“你有什么人脉关系”这个问题在我和创始人的通话中也经常出现。我想反问你一个问题：在这之前我们认识吗？

---

### [00:31:43] Lenny

**English:**
Nope.

**中文翻译:**
不认识。

---

### [00:31:44] Emilie Gerber

**English:**
Exactly. I'm of the belief that it does not matter as much as many people think it does. And I explained this on calls where they ask, "Oh, tell me about your Rolodex, or who is your relationships with?" First of all, media's changing so fast. So sure, maybe there is a reporter that we worked with recently. They might have a completely different beat in six months. They might be at a very different publication. So it's not sustainable to build an entire career on having relationships with certain publications.

**中文翻译:**
没错。我认为人脉并没有很多人想象的那么重要。我在电话里解释过，当他们问“噢，告诉我你的联系人名录（Rolodex），或者你和谁有关系”时。首先，媒体变化太快了。当然，也许我们最近刚和某位记者合作过，但六个月后他可能负责完全不同的领域，或者去了完全不同的媒体。所以，把整个职业生涯建立在与某些媒体的关系上是不可持续的。

---

### [00:32:17] Emilie Gerber

**English:**
And media is changing too. Now, podcasts and Substack and newsletters, it is just changing too fast. And so I think cold outreach done well is just as effective. The only thing that a relationship will get you is an open and an answer. And so any good reporter is not going to be making their editorial decisions based on who their friends are. That's just not the nature. It shouldn't be the nature of the industry, and it's not. Maybe it'll get you an intro coffee, but that's about it. It's not going to get you coverage. They're not going to cover your news because there's a relationship there. I think the much harder and more important part is being good at writing really thoughtful notes to the right people.

**中文翻译:**
媒体形式也在变。现在有了播客、Substack 和时事通讯，变化太快了。所以我认为，做得好的“冷启动外联（cold outreach）”同样有效。关系唯一能带给你的是邮件被打开和得到回复。任何优秀的记者都不会根据谁是他的朋友来做编辑决策。这不符合行业本质，事实也不是这样。也许关系能让你约到一杯介绍性的咖啡，但仅此而已。它不会带给你报道，他们不会因为有交情就报道你的新闻。我认为更难也更重要的一点是，擅长给对的人写非常周到的信件。

---

### [00:32:57] Emilie Gerber

**English:**
And in a way, now we do have a relationship, and so it can come from a cold email, but now it's easier for me to pitch you because you know my name and we've spoken and we've worked together. And so for me, I'm a big fan of being helpful to reporters, and I tend to just keep it professional and pitch them on stories. I don't necessarily feel like going to drinks or having coffee all the time is crucial to building those relationships. A lot of the reporters that I work with regularly, I've never met in person, and that's okay, but it can be great for getting answers I would say. That's where the relationships can be helpful.

**中文翻译:**
某种程度上，现在我们确实有了关系，虽然它始于一封冷邮件，但现在我再向你推介就容易多了，因为你知道我的名字，我们聊过天，合作过。对我来说，我非常推崇对记者提供帮助，我倾向于保持专业并向他们推介故事。我不觉得非得经常去喝酒或喝咖啡才能建立关系。很多我经常合作的记者，我从未见过面，这没关系，但关系对于获得答复确实很有帮助。这就是关系的用武之地。

---

### [00:33:35] Emilie Gerber

**English:**
And then once you have worked with a reporter on a story, it's true that maybe they'll be more likely to come back when they're working on something related, use you as a source, quote you in articles that are relevant. So once there's something there, that's great and you should totally nurture it, but it's not all about calling in favors.

**中文翻译:**
一旦你和记者合作过一个故事，确实，当他们写相关内容时，可能更有可能回来找你，把你当作消息源，或者在相关文章中引用你的话。所以一旦建立了联系，那很棒，你应该好好维护，但这并不全是关于“动用人情”。

---

### [00:33:52] Lenny

**English:**
Awesome. Okay. And then in terms of how to reach reporters, what do you find most effective?

**中文翻译:**
太棒了。好，那么在触达记者的方式上，你觉得什么最有效？

---

### [00:33:59] Emilie Gerber

**English:**
Yeah, I'm pro all platform approach. So sometimes reporters will tweet that they're working on a story about something, and rather than me sending them an email with my pitch, I'll say, "Hey, 10 words on why this person is the person you should talk to," and then send a link to an article on them and that's my entire pitch. And honestly, it's sometimes more effective than when I spend 30 minutes writing a really thoughtful email. So I'm a fan of that. I'm a fan of DMs, short, concise, direct DMs. Sometimes LinkedIn, although for whatever reason I feel like that works better with on the podcast side with hosts.

**中文翻译:**
是的，我支持全平台触达。有时记者会发推文说他们正在写关于某事的报道，我不会发一封长邮件，而是回一句：“嘿，用 10 个字告诉你为什么这个人是你该聊的对象”，然后附上一个关于他们的文章链接，这就是我全部的推介。老实说，这有时比我花 30 分钟写一封周到的邮件更有效。所以我很喜欢这种方式。我也喜欢私信（DMs），简短、简洁、直接的私信。有时也用 LinkedIn，尽管出于某种原因，我觉得 LinkedIn 在联系播客主持人时效果更好。

---

### [00:34:38] Emilie Gerber

**English:**
And of course email, we totally email. When I email a reporter, I love to make the subject line just as clear as possible as what the goal is and why I'm emailing them. And so let's say it's for a recurring column that they have, I'll put the name of that column and the person that I think should be included in the subject line. And even that for a reporter, it's like, oh, they actually know. They actually know I write this column and they're suggesting a guest for this column. It's so direct, it's so clear.

**中文翻译:**
当然还有邮件，我们绝对会发邮件。当我给记者发邮件时，我喜欢让标题尽可能清晰，说明目的以及我为什么要联系他们。假设是为了他们一个定期更新的专栏，我会在标题里写上专栏的名字和我认为应该加入的人选。对记者来说，这就像是：“噢，他们真的知道我在写这个专栏，而且在为这个专栏推荐嘉宾。”这非常直接、清晰。

---

### [00:35:06] Emilie Gerber

**English:**
I think just saying what your intentions are right away. Are you trying to get a Q&A? Are you trying to get a story? Are you trying to get a funding story, like I mentioned before, is very crucial, and keeping it short. I would say my most successful pitches are three sentences and anytime... Sometimes it needs to be longer than that, and generally I feel like my pitch is weaker for that reason. Attention spans are short, and so the more concise you can make it, the better. And then just sometimes I'll start with one platform. I'll start with an email and that doesn't work, so I'll go somewhere else. But I try to make it very human and respectful. So using language like, "Hey, I know your inbox is probably slammed. Sorry to annoy. Trying you one more time here."

**中文翻译:**
我认为立刻说明你的意图非常关键。你是想争取一个问答采访？还是一个故事报道？或者是像我之前提到的融资故事？而且要保持简短。我会说我最成功的推介通常只有三句话。有时需要更长，但通常我觉得推介信因此变得更无力了。人们的注意力很短，所以越简洁越好。有时我会先试一个平台，比如先发邮件，如果不奏效，再换个地方。但我尽量表现得非常人性化且尊重。比如用这样的语言：“嘿，我知道你的收件箱可能爆满了。抱歉打扰，最后再试着联系你一次。”

---

### [00:35:49] Emilie Gerber

**English:**
Another thing that actually can work really well is pointing out gaps in their coverage too, and talking about things that they should be talking about. Like, Hey, my client's noticing this trend. I know you've covered it from this point of view, but no one's talking about it from this point of view. That can be really helpful because it shows that you are actually paying attention to what they are writing, but in a way that you're demonstrating that you have some critical thinking going on, not just, I liked your article on X, which is a common practice that PR people use is I like this, and then jump to your pitch. So yeah, giving it a little more thoughtful, pointing out gaps in coverage.

**中文翻译:**
另一件非常有效的事是指出他们报道中的空白，谈谈他们应该关注但还没关注的事。比如：“嘿，我的客户注意到了这个趋势。我知道你从这个角度报道过，但还没人从那个角度谈过。”这很有帮助，因为它表明你确实在关注他们写的东西，并且展示了你的批判性思维，而不仅仅是说“我喜欢你关于 X 的文章”，那是公关人员常用的套路——先夸一句，然后立刻跳到推介。所以，多一点思考，指出报道的空白。

---

### [00:36:25] Emilie Gerber

**English:**
And then the last piece is, especially if you don't have hard news that you're pitching, having something pretty controversial to say. So we work with a lot of AI companies. If nine of them have one stance on something happening in the field and one has the other stance, chances are that one is going to be the one that a reporter wants to talk to because they are getting so many pitches on this topic, but they want to write a balanced article, they need that opposing view. And so we really push our clients to have something unique and different and bold to say. And it obviously has to be a strategic decision for the business. You don't want to go commenting on regulatory things if it sounds like you don't want to necessarily be a part of that conversation, but there are I think instances where it can make a lot of sense to say something that's a little bit bold and controversial.

**中文翻译:**
最后一点是，特别是如果你推介的不是硬新闻，那就说点有争议的话。我们和很多 AI 公司合作。如果九家公司对领域内发生的某件事持一种立场，而另一家持相反立场，那么记者很可能想找那一家聊聊。因为他们收到了太多关于这个话题的推介，但为了写出一篇平衡的报道，他们需要那个对立的观点。所以我们极力推动客户去表达一些独特、不同且大胆的见解。当然，这必须是业务上的战略决策。如果不想卷入监管话题，你就不该去评论，但我认为在某些情况下，说一些大胆且有争议的话是非常有意义的。

---

### [00:37:15] Lenny

**English:**
That last piece is really interesting. Is there an example that comes to mind where you had a controversial contrarian pitch?

**中文翻译:**
最后一点很有趣。你能想到一个你做过的具有争议性或反直觉（contrarian）的推介案例吗？

---

### [00:37:23] Emilie Gerber

**English:**
Yeah, so we work with a company called Clockwise, which essentially manages your calendar and allows time for focus time within your workday. They move things around for you. And a couple of months ago, Shopify got tons of positive press for essentially canceling all their recurring meetings, and everyone was very intrigued by this strategy. Press was generally quite positive towards it, and so we knew that if we just wrote another piece saying, "Oh, this is great," no one would want to publish that. It had been said in a million different ways. So we looked at the topic a little more critically and we're like, okay, is this actually enough to change meeting culture within a business? And we kind of identified all these other things that we think need to happen in order to really change the culture in a way that's going to be sustainable and long-term versus just blanket deleting of calendar meetings.

**中文翻译:**
有的。我们与一家名为 Clockwise 的公司合作，它主要管理你的日历，并在工作日为你留出专注时间，它会自动帮你调整日程。几个月前，Shopify 因为取消了所有定期会议而获得了大量正面报道，大家对这个策略非常感兴趣。媒体普遍持积极态度。我们知道，如果我们只是再写一篇说“噢，这太棒了”的文章，没人会愿意发表，因为这种话已经被说烂了。所以我们更批判性地看待这个话题：这真的足以改变企业的会议文化吗？我们确定了其他一些我们认为必须发生的事情，才能以可持续和长期的方式真正改变文化，而不仅仅是简单粗暴地删除日历会议。

---

### [00:38:14] Emilie Gerber

**English:**
And so we ended up turning this into an op-ed, so something that together we wrote and then pitched a publication. And yeah, the title was "Shopify's Meeting Cost Calculator Does Not Address the Issue of Wasted Time". And so it wasn't necessarily saying it was a horrible idea, but it was putting a little bit more of a critical eye towards it. And Fast Company was interested in the idea and they posted the piece by the CEO, Matt Martin, and it was a great thing for us to comment on. And so yeah, I think it doesn't necessarily need to be something where you're coming out against it, but just proposing something that's a little more thoughtful on the topic.

**中文翻译:**
于是我们把它变成了一篇评论文章（op-ed），由我们共同撰写并推介给媒体。标题是《Shopify 的会议成本计算器并未解决时间浪费的问题》。这并不是说那是个糟糕的主意，而是用更批判的眼光来看待它。《Fast Company》对这个想法很感兴趣，发表了 CEO Matt Martin 写的这篇文章。这对我们来说是一个很好的切入点。所以，不一定非要反对某事，只要针对该话题提出一些更深刻的见解即可。

---

### [00:38:53] Lenny

**English:**
Just hearing that it sounds like such an obvious thing to do. Basically a reporter is looking for an interesting story to write about. If you tell them something interesting that they could put out, that's a win-win for everybody. So makes a ton of sense. Let me try to summarize the advice you've shared so far when you're, say DMing a reporter, your advice so far is basically be very direct. Just tell them, "Hey, I'm looking for..." What's an example of being direct? Is it like I'm looking for a story on this fundraising announcement?

**中文翻译:**
听起来这似乎是理所当然的事。基本上记者就是在寻找有趣的故事。如果你告诉他们一些有趣的、可以发表的东西，那是双赢。这非常有道理。让我试着总结一下你目前分享的建议：当你给记者发私信时，你的建议是保持直接。直接告诉他们：“嘿，我想争取……”什么是“直接”的例子？是像“我想为这个融资公告争取一篇报道”这样吗？

---

### [00:39:19] Emilie Gerber

**English:**
I wouldn't say I'm looking for. I don't know, just I would say if it was a DM, I would say, "Reaching out from X company. Would love to offer you the launch story alongside their funding if you're open to it." And usually I'd either say the amount and the investors or the company name. If you give them both, you're kind of just giving them the story and they could run with it right away. That's actually an important distinction. And so you could either say, "Reaching out with this Martech company that's raised 8 million from X Investors. Really interesting approach, they're taking on X incumbent. Do you want the exclusive?" That's kind of how I would phrase it.

**中文翻译:**
我不会说“我想争取”。如果是私信，我会说：“我是 X 公司的。如果你感兴趣，我想为你提供他们融资伴随的产品发布故事。”通常我会说出金额和投资者，或者公司名称。如果你把两者都说了，你基本上就把故事全抖出来了，他们可能会直接发。这其实是一个重要的区别。所以你可以说：“联系你是关于这家筹集了 800 万美元的营销科技公司，投资者是 X。他们挑战老牌巨头 X 的方式非常有趣。想要独家吗？”我大概会这么措辞。

---

### [00:39:59] Lenny

**English:**
Okay, awesome. Then, try to keep it to three sentences. And you're saying sometimes when you go longer, you actually end up backfiring each time. Sometimes include a link to a story they've written or some other story about the company that might give them some context. Is that right?

**中文翻译:**
好，太棒了。然后，尽量保持在三句话以内。你说有时写长了反而会适得其反。有时附上他们写过的报道链接，或者关于公司的其他报道，给他们一些背景信息。对吗？

---

### [00:40:15] Emilie Gerber

**English:**
Yeah. And a caveat on that is, if a competing publication just wrote a bigger similar feature on that, they're not going to want to see that. And so I would use that strategically. If it's a piece from a while ago on a different topic that does share a lot of info, I'll include it, but I'm not necessarily going to include something that might seem like why would I cover this when this was just written about.

**中文翻译:**
是的。但要注意一点：如果竞争媒体刚刚写了一篇更大、类似的专题报道，他们就不想看到那个。所以要策略性地使用。如果那是很久以前关于不同话题的一篇文章，但包含很多信息，我会附上；但我不会附上那些会让记者觉得“既然刚有人写过，我为什么还要写”的内容。

---

### [00:40:37] Lenny

**English:**
Good point. You also talked about how try to acknowledge their inbox is probably slammed, and this is taking some time maybe in follow-ups, especially like, Hey, I realize your inbox is slammed, just thought I'd come back to this. Then you talk about this idea of identifying gaps in the writing, like, Hey, it seems like you cover Gen AI. There's this trend that we've been noticing that maybe it would be interesting to cover. And then something controversial or something a little contrarian that would get them. Oh yeah, this could be a really interesting story. Awesome.

**中文翻译:**
好点子。你也提到要承认他们的收件箱可能爆满了，尤其是在跟进时，比如：“嘿，我知道你收件箱爆满了，只是想再提一下这件事。”然后你谈到了指出报道空白的想法，比如：“嘿，看来你在报道生成式 AI。我们注意到一个趋势，也许报道一下会很有趣。”还有一些争议性或反直觉的内容，能让他们觉得：“噢对，这可能是一个非常有趣的故事。”太棒了。

---

### [00:41:08] Emilie Gerber

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:41:09] Lenny

**English:**
Is there anything else broadly in terms of pitch advice to get the attention of a reporter that comes to mind? And I know this is a lifetime of experience and it's hard to summarize all of it, but anything else?

**中文翻译:**
在吸引记者注意的推介建议方面，还有什么能想到的吗？我知道这是毕生的经验，很难全部总结，但还有别的吗？

---

### [00:41:24] Emilie Gerber

**English:**
Well, one topic, maybe this would be covered elsewhere, but one topic I think is talking about incumbents that this company is taking on. So a lot of companies want to position themselves as category creators, and I actually hate that. It doesn't work. It doesn't land with press, and most of the time it's not totally true. And so instead, it's actually really great when you can talk about how you are doing what X household name does, but better for X reasons, and that works so well. I'll put that in subject lines. I'll put company taking on whatever Salesforce with X approach. It's so successful because instantly it gives the reporter a frame of reference. And so it gives the reporter, oh, I know what Salesforce does, so I can understand how this solution would be better. And a lot of companies really want to position themselves as the first to do anything in a certain space. They love the idea of category creating, creating these little marketing phrases that they use for the new category. And that's fine if perhaps that works on the sales side, but on the PR side, I would never have put that in a pitch.

**中文翻译:**
嗯，有一个话题，也许在别处也会提到，就是谈论这家公司正在挑战的“老牌巨头（incumbents）”。很多公司想把自己定位为“品类开创者（category creators）”，我其实很讨厌这一点。这行不通，媒体不买账，而且大多数时候这并非完全属实。相反，如果你能谈谈你如何做着某家家喻户晓的公司（X）正在做的事，但因为 X 原因做得更好，效果会非常好。我会把这写进标题。我会写“某公司以 X 方式挑战 Salesforce”。这非常成功，因为它立刻给了记者一个参照系。记者会想：“噢，我知道 Salesforce 是做什么的，所以我能理解为什么这个方案更好。”很多公司真的想把自己定位成某个领域的先行者。他们迷恋“品类开创”的概念，创造各种营销词汇。如果这在销售端管用，那没问题；但在公关端，我绝不会把这些放进推介信里。

---

### [00:42:35] Lenny

**English:**
There's just going to be a meta comment, but the two topics that are most controversial in this podcast that I have both sides of opinions on is the power of category creation and jobs to be done.

**中文翻译:**
这只是一个形而上的评论，但在本播客中，我听到的两种观点对立最严重的话题就是“品类开创的力量”和“待办任务（Jobs to be Done）”理论。

---

### [00:42:48] Emilie Gerber

**English:**
Oh, really?

**中文翻译:**
噢，真的吗？

---

### [00:42:49] Lenny

**English:**
There's a lot of passion on both sides.

**中文翻译:**
双方都非常有激情。

---

### [00:42:52] Emilie Gerber

**English:**
I mean, sure, you can point to examples of the two companies that have done category creation well, but it's two out of what, thousands?

**中文翻译:**
我的意思是，当然，你可以举出两家把品类开创做得很好的公司，但在成千上万家公司里，也就这两家吧？

---

### [00:43:06] Lenny

**English:**
I love it. I'm going to keep poking this hornet's nest. I love it. Okay. But you're saying in your experience doesn't work when pitching reporters?

**中文翻译:**
我喜欢这个话题。我会继续捅这个马蜂窝的。好，但你是说根据你的经验，这在向记者推介时行不通？

---

### [00:43:10] Emilie Gerber

**English:**
For PR. Yeah, simply for PR. In other areas of the business I can't comment on, but for PR, it's just not a useful tactic.

**中文翻译:**
仅就公关而言。是的，纯粹从公关角度。业务的其他领域我无法评论，但对于公关，这并不是一个有效的策略。

---

### [00:43:18] Lenny

**English:**
Okay, awesome. This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast. Now, you can assess risk, secure the trust of your customers, and automate compliance for SOC 2, ISO 27001, HIPAA and more with a single platform, Vanta. Vanta's market leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risks. Plus you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to Vanta.com/lenny. That's Vanta.com/lenny.

**中文翻译:**
好，太棒了。本集节目由 Vanta 赞助。当涉及到确保你的公司拥有顶级的安全实践时，事情很快就会变得复杂。现在，你可以通过 Vanta 这一个平台来评估风险、赢得客户信任，并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险。此外，你还可以通过 Vanta AI 填写安全问卷，节省数小时的时间。加入全球数千家使用 Vanta 自动化证据收集、统一风险管理并简化安全审查的公司吧。访问 Vanta.com/lenny 即可享受 1000 美元的优惠。

---

### [00:44:12] Lenny

**English:**
So I asked you to bring some examples of pitches that are great, and also examples of pitches that could be better, and I know... Yeah. Okay, cool. So thank you for doing the homework. Let's pull them up and then I'd love to just show people what you find has been really effective and works great about these examples and then what somebody could have done better, whatever you want to share about that example.

**中文翻译:**
所以我请你带了一些优秀的推介案例，以及一些有待改进的案例。好，太酷了。谢谢你做的功课。让我们把它们展示出来，我很想向大家展示你认为这些案例中哪些地方非常有效、表现出色，以及哪些地方可以做得更好。

---

### [00:44:35] Emilie Gerber

**English:**
Sure. Sounds good. I guess since we're on the topic of category creating versus not category creating, I'll start with an example that's very relevant to that. So we worked with RAMP in their very early days, and one of their first product announcements that we did together was the launch of their bill pay offering. And so at the time, I think they were like a three billion dollar company, something along those lines. So big, but not as big as they are today. Product news rarely gets big feature coverage, especially for something along the lines of a bill pay offering for B2B companies.

**中文翻译:**
好的。既然我们聊到了品类开创与否的话题，我就从一个非常相关的例子开始。我们在 Ramp 早期就与他们合作，我们共同完成的首批产品发布之一是他们的账单支付（bill pay）功能。当时，我想他们大概是一家估值 30 亿美元的公司。虽然很大，但还没像今天这么大。产品新闻很少能获得深度专题报道，尤其是像 B2B 公司的账单支付功能这种东西。

---

### [00:45:09] Emilie Gerber

**English:**
And so essentially the way that we framed the story was how RAMP was now able to take on Bill.com, which at the time I'm not sure if it still is, was one of the best performing FinTech IPOs public company that really had still only captured two percent of this market overall. And so by positioning it as allowing them to take on this massive incumbent that was getting a lot of press, we actually were able to get a CNBC story on the launch of this product. Generally they won't even consider product stories, but they really liked the angle of this underdog doing something that could take on a piece of market share from them.

**中文翻译:**
所以，我们构思故事的方式是：Ramp 现在如何能够挑战 Bill.com。当时（我不确定现在还是不是）Bill.com 是表现最好的金融科技 IPO 上市公司之一，但实际上它只占领了整个市场的 2%。通过将其定位为挑战这家备受媒体关注的巨头，我们成功在 CNBC 上获得了一篇关于该产品发布的报道。通常他们根本不考虑产品故事，但他们非常喜欢这个“挑战者（underdog）”试图从巨头手中夺取市场份额的角度。

---

### [00:45:47] Emilie Gerber

**English:**
And the next day there was actually another story about how Bill.com stock had gone down and they did make mention of RAMP's news in that story. So it ended up really just, it was a very powerful way of telling the narrative there. And another way, if we hadn't pitched it like that would've just been RAMP brings simple, seamless, streamlined ability to do vendor payments and new finance offering, first of its kind. All these things that might be how you would talk in your customer emails, but if I had pitched it that way, probably wouldn't have been a story. So if we had pitched it as them creating a new category of this all in one software, which I mean, yeah, it could be argued, that's another way to tell the story. I don't think CNBC would've been interested.

**中文翻译:**
第二天，实际上出现了另一篇关于 Bill.com 股价下跌的报道，在那篇报道中他们确实提到了 Ramp 的新闻。所以这最终成了一种非常强大的叙事方式。换一种方式，如果我们没那样推介，可能就是：“Ramp 带来了简单、无缝、流线型的供应商支付能力和全新的金融产品，首创之举。”这些话你可能会在给客户的邮件里说，但如果我这样推介，可能根本成不了一个新闻故事。如果我们把它推介为“开创全能软件的新品类”（虽然也可以这么说），我觉得 CNBC 不会感兴趣。

---

### [00:46:34] Lenny

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:46:36] Emilie Gerber

**English:**
So, okay, another example, we work with a company called Column Tax, which is embedded tax filing software. So essentially they work with other FinTech's to allow people to file their taxes within the tools that they already use. And last year they partnered with a company called Propel that offers SNAP benefits. So essentially for low income families to receive the government benefits to offer tax filing directly within the app that they've created. And that was one thing that they were doing amidst many other customers, that they had lots of different threads we could pull on with them, but we decided to really just focus our press strategy on that one initiative because it allowed us to tell macro story about TurboTax had to pay all these fines for practices that many considered unsavory around calling themselves free but not really being free. The IRS is building a free filing system, but it's in its very early days.

**中文翻译:**
好，另一个例子。我们与一家名为 Column Tax 的公司合作，这是一家嵌入式报税软件公司。基本上，他们与其他金融科技公司合作，让人们在已经使用的工具中报税。去年，他们与一家名为 Propel 的公司合作，后者提供 SNAP（粮食券）福利。基本上是让低收入家庭在他们创建的应用中直接报税。在众多客户中，这只是他们正在做的众多事情之一，我们有很多线索可以挖掘，但我们决定将媒体策略重点放在这一个举措上。因为它让我们能讲一个宏观故事：TurboTax 因为被认为不光彩的行为（自称免费但并非真的免费）而不得不支付巨额罚款；IRS 正在建立免费报税系统，但还处于早期阶段。

---

### [00:47:35] Emilie Gerber

**English:**
So the fact that they were having this offering that was supporting a lot of low income families, and I believe 40% of the people that filed their taxes with Column hadn't filed taxes in the previous year, so hadn't gotten a return. It's like identifying the piece of the story that's most interesting and then doubling down on that. So we were able to get a great fast company piece instead of pitching this macro here are Column Tax's latest growth metrics, and they're announcing a partnership with Propel. And so it's like...

**中文翻译:**
所以，他们提供的这项服务支持了大量低收入家庭，而且我相信通过 Column 报税的人中有 40% 前一年没有报税，因此没拿到退税。这就像是找出一个故事中最有趣的部分，然后全力以赴。因此，我们成功在《Fast Company》上获得了一篇很棒的报道，而不是推介那种宏大的“这是 Column Tax 最新的增长指标，他们宣布与 Propel 合作”。所以这就像是……

---

### [00:48:00] Emilie Gerber

**English:**
Growth metrics, and they're announcing a partnership with Propeller. And so it's figuring out how to tie it to these things that people actually care about, and not just the company's messaging I think is our job.

**中文翻译:**
……增长指标，以及宣布与 Propel 合作。我认为我们的工作是弄清楚如何将其与人们真正关心的事情联系起来，而不仅仅是传达公司的信息。

---

### [00:48:12] Lenny

**English:**
Amazing, is there any other examples? Otherwise, I'll share your pitch of someone coming on my podcast, and what worked about that.

**中文翻译:**
太棒了，还有其他例子吗？否则，我就要分享你为某位嘉宾上我播客所做的推介，以及为什么它奏效了。

---

### [00:48:20] Emilie Gerber

**English:**
I do want to share one more, because it's my favorite. I want to share my favorite funding story that I worked on. And so I'm actually going to pull it up, because this one is very graphic, in terms of how we went about showing the product. So we worked with a company called Gamma, which is essentially bringing a PowerPoint into something that's much more modern, and interactive, and usable. So when we did their launch, they were a seed stage company, we tried to get really creative with how we could display or talk about the company. And so instead of doing your standard company blog posts, we actually made a Gamma presentation, and we kind of included all these fun elements that made it really interesting to reporters. So firstly, it's a visual platform. So we created... Or actually I don't want to take credit for this. The Gamma team created this great visual.

**中文翻译:**
我确实想再分享一个，因为那是我的最爱。我想分享我参与过的最喜欢的融资故事。我正把它调出来，因为在展示产品方面，这个案例非常形象。我们与一家名为 Gamma 的公司合作，它基本上是将 PowerPoint 变成更现代、更具交互性且更易用的东西。当我们为他们做发布时，他们还是一家种子轮公司，我们尝试在展示或谈论公司的方式上发挥创意。我们没有写标准的官方博客文章，而是直接制作了一个 Gamma 演示文稿，并加入了很多有趣的元素，让记者觉得非常有趣。首先，它是一个视觉平台。所以我们制作了……其实我不想揽功，是 Gamma 团队制作了这个很棒的视觉效果。

---

### [00:49:11] Emilie Gerber

**English:**
And we kept it very to the point. Every year, half a billion people create presentations in Google Slides and PowerPoint. We're not using marketing language here, we're talking in a very direct way, we're including fund visuals. We talk about Gamma's mission, pretty short, this is not a long essay on why the company exists. And then we include some customer love, so they're early stage, so we didn't really have necessarily growth metrics that we wanted to share. So we tried to make it a little bit more personal, and focus on actual users and what they're saying, while also showing the product capability here. And then instead of doing a long thing on each investor, we just bulleted who the investors are, which is very to the point, easy for a reporter to repurpose.

**中文翻译:**
我们保持言简意赅。每年有 5 亿人用 Google Slides 和 PowerPoint 制作演示文稿。我们在这里不使用营销术语，而是用非常直接的方式交谈，并加入有趣的视觉效果。我们谈到了 Gamma 的使命，非常简短，这不是一篇关于公司为何存在的长篇大论。然后我们加入了一些客户的好评，因为他们处于早期阶段，我们不一定有想分享的增长指标。所以我们试着让它更具人情味，专注于真实用户及其评价，同时也展示了产品功能。此外，我们没有为每个投资者写长篇介绍，只是列出了投资者的要点，非常简练，方便记者直接引用。

---

### [00:49:55] Emilie Gerber

**English:**
And the fun part that I really loved, is we did a video from the lead investor talking about why she invested, instead of including an investor quote. So it's a little bit different than what you expect. And their videos are fun, because they have all these interactive elements. And yeah, team photo, make it a little more personal. And that was about it. But anyways, it was a very successful story, and I believe the title of the TechCrunch article that we got as a result was Gamma Brings PowerPoint into the 21st Century. Exactly, that's exactly what we're talking. Maybe they are creating a new category, we weren't talking about it then, we're talking about how it's better than the existing solutions. And so yeah, I guess the piece of advice there, is feel free to get kind of fun and creative with it, and don't just follow the typical issuing press release format.

**中文翻译:**
我最喜欢的有趣部分是，我们让领投人拍了一段视频谈论她为什么投资，而不是引用一段投资者的名言。这和你预期的有点不同。他们的视频很有趣，因为有很多交互元素。还有团队照片，让它更具人情味。大概就是这样。总之，这是一个非常成功的故事，我记得最终获得的 TechCrunch 文章标题是《Gamma 将 PowerPoint 带入 21 世纪》。没错，这正是我们所谈论的。也许他们正在开创一个新类别，但我们当时没谈那个，我们谈论的是它如何优于现有解决方案。所以，我的建议是，尽管发挥趣味和创意，不要只遵循典型的发布新闻稿格式。

---

### [00:50:42] Lenny

**English:**
And is that something we could link to for people to check out? Is that just on their site?

**中文翻译:**
那是我们可以提供链接让大家查看的东西吗？就在他们的网站上吗？

---

### [00:50:42] Emilie Gerber

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:50:42] Lenny

**English:**
Okay, amazing.

**中文翻译:**
好，太棒了。

---

### [00:50:46] Emilie Gerber

**English:**
Yeah, I actually had to for some reason do some digging to get it. But yeah, I have it now, so I can give it to you.

**中文翻译:**
是的，出于某种原因，我实际上得挖掘一下才能找到它。但我现在有了，可以给你。

---

### [00:50:52] Lenny

**English:**
Okay, great. And the way that you use that is when you sent emails or DMs to reporters, you included this link?

**中文翻译:**
好，太好了。你使用它的方式是，当你给记者发邮件或私信时，附上这个链接？

---

### [00:50:58] Emilie Gerber

**English:**
After they had that they're potentially interested, because again, if I had shared it right off the bat, it would be their prerogative to just publish it essentially or share it publicly. And I guess one important note, is everything you say to a reporter in an email is on the record, and so that's why I make the point on not sharing the entire story right off the bat.

**中文翻译:**
是在他们表现出潜在兴趣之后。因为再说一次，如果我一开始就分享，他们就有权直接发布或公开分享。我想一个重要的注意事项是：你在邮件中对记者说的每一句话都是“公开记录（on the record）”的，这就是为什么我强调不要一开始就分享整个故事。

---

### [00:51:19] Lenny

**English:**
Got it. So many companies won't have... They're not a deck product, so they can't do something like this. But the takeaways for other folks here, is be just very human in the language, the investors are just bullet points, make it fun, add some visuals, don't just have blurbs, and paragraphs, and things like that.

**中文翻译:**
明白了。很多公司没有……他们不是做演示文稿产品的，所以做不出这种东西。但对其他人来说，这里的启示是：语言要有人情味，投资者信息只用要点列出，让内容有趣，加入视觉效果，不要只有简介、段落之类的东西。

---

### [00:51:41] Emilie Gerber

**English:**
Yeah. I think reporters are used to getting the same thing all the time, and so this one obviously worked well for the format. But I think we try to always think of, what can we do that's slightly different for this one? Or how can we make this a little more fun? I guess the one exception, if the product is very technical, and you have a very technical audience, and you're probably going to work with a very technical reporter, it's totally fine to talk to your audience in those cases, and you don't need to necessarily dumb it down so everyone can understand. But that doesn't mean... I mean, you can do that while still using clear and concise language.

**中文翻译:**
是的。我觉得记者已经习惯了总是收到同样的东西，所以这个案例在格式上显然很奏效。但我们总是试着去想：针对这一个，我们能做点什么稍微不同的？或者怎么能让它更有趣一点？我想唯一的例外是，如果产品非常技术化，受众也非常技术化，而你可能要和一位非常技术化的记者打交道，那么在这些情况下直接对你的受众说话是完全没问题的，你不需要为了让每个人都懂而刻意简化。但这并不意味着……我的意思是，你可以在保持语言清晰简洁的同时做到这一点。

---

### [00:52:18] Lenny

**English:**
Okay, so let me share the element of the pitch that you sent me, that convinced me to bring this guest on. So this is going to be the chief product officer at NewBank. I barely know anything about NewBank. And so in your email to me, you basically had just two bullet points, and the way you put is, "Two fun facts about NewBank, growth has been 80 to 90% organic because of the way they try to make customers fanatical about the product." And to me that's like, "Wow, that's very rare, is 80, 90% of your growth being organic." So to me is like, "That's an interesting story." And then the other tidbit is, "NewBank is bigger than Coinbase, Robinhood, Affirm, SoFi, and Lemonade combined. Seriously, so much bigger than people in the US realize." Which I 100% did not realize. So to me both were just like, "Okay, this is an interesting story to tell, I think people would be very curious to hear how a company like this operates." So now I'm going to start getting all these emails from people, all these couple bullet points.

**中文翻译:**
好，让我分享一下你发给我的推介信中的元素，正是它说服了我邀请这位嘉宾。这位嘉宾是 NuBank 的首席产品官。我对 NuBank 几乎一无所知。在发给我的邮件中，你基本上只写了两个要点，你是这样写的：“关于 NuBank 的两个趣事：由于他们努力让客户对产品产生狂热，80% 到 90% 的增长都是自然增长（organic）。”对我来说，“哇，这太罕见了，80%、90% 的增长都是自然的。”所以我觉得“这是一个有趣的故事”。另一个花絮是：“NuBank 比 Coinbase、Robinhood、Affirm、SoFi 和 Lemonade 加起来还要大。说真的，比美国人意识到的要大得多。”我百分之百没意识到这一点。所以对我来说，这两点都让我觉得：“好，这是一个值得讲的故事，我想人们会很好奇这样一家公司是如何运作的。”现在我肯定会开始收到一大堆这种只有几个要点的邮件了。

---

### [00:53:15] Emilie Gerber

**English:**
They're going to combine a bunch of companies, and see which they're bigger than.

**中文翻译:**
他们会把一堆公司组合起来，看看自己比谁大。

---

### [00:53:19] Lenny

**English:**
Yeah, or use AI to help them figure this out. But I think what you identified here is just what I get excited about. Is there any advice there of just what you did there that other people can learn from?

**中文翻译:**
是的，或者用 AI 来帮他们算。但我认为你在这里识别出的正是我感兴趣的东西。关于你那次推介的做法，有什么其他人可以学习的建议吗？

---

### [00:53:32] Emilie Gerber

**English:**
Yeah. I mean, I think with pitching you, speaking to the audience, it's not just about having... You don't want the most well-known CEOs all the time, you're not looking just for the biggest companies and the most well-known people. You're looking for the things that they can talk about, and how the things that they can talk about are relevant to your audience. And with the first bullet, it was indexing on that. The second bullet was more so like, "Hey, you might not know about this company." And it's a little bit of a unique one, I wouldn't necessarily always include that. But to me the first bullet was really what mattered, because it wasn't just about the fact that they were a huge company, it's that they grew in a unique way, and I knew that was the kind of thing that you'd be interested in.

**中文翻译:**
有的。我的意思是，在向你推介时，要针对受众说话。你并不总是想要最知名的 CEO，你寻找的不只是最大的公司和最出名的人。你寻找的是他们能聊的话题，以及这些话题如何与你的受众相关。第一个要点就是针对这一点的。第二个要点更像是：“嘿，你可能不知道这家公司。”这有点独特，我不一定总会包含这种。但对我来说，第一个要点才是真正关键的，因为这不仅仅在于他们是一家大公司，而在于他们以一种独特的方式增长，我知道那是你会感兴趣的东西。

---

### [00:54:13] Lenny

**English:**
And how did you figure that out? Is it from emails we were exchanging ahead of that? Is it listening to some podcasts? How did you get to those conclusions?

**中文翻译:**
你是怎么发现这一点的？是从我们之前的邮件交流中？还是听了一些播客？你是如何得出这些结论的？

---

### [00:54:21] Emilie Gerber

**English:**
Yeah, listening certainly helps. But I do think just figuring out... If you even just scrolled the names of all the episodes that you've done, it would be pretty easy to spot a trend there. And so you're not talking about product launches, you are not talking about entrepreneurial journeys, you're talking about tactical lessons. And so pitching people based on those sort of things, I don't even think you necessarily need to listen to a whole bunch of episodes most of the time, maybe occasionally you want to gut check something before you reach out. But yeah, you can tell a lot just by doing a little bit of research.

**中文翻译:**
是的，听节目肯定有帮助。但我认为只要……如果你哪怕只是翻一下你做过的所有节目的标题，也很容易发现其中的趋势。你谈论的不是产品发布，不是创业历程，而是实操经验（tactical lessons）。所以根据这些内容来推介人选，我觉得大多数时候甚至不需要听完一大堆节目，也许偶尔在联系之前需要核实一下。但是，只要做一点点研究，你就能了解很多。

---

### [00:54:53] Emilie Gerber

**English:**
And then we did have a little back and forth, because I will take responsibility, I did try pitching you on a CEO at one point, which I know you don't have on as guests.

**中文翻译:**
然后我们确实有过一些来回沟通，因为我要承担责任，我曾经试过向你推介一位 CEO，而我知道你通常不请 CEO 当嘉宾。

---

### [00:55:03] Lenny

**English:**
Once in a while, very rarely.

**中文翻译:**
偶尔会请，非常罕见。

---

### [00:55:08] Emilie Gerber

**English:**
Yeah, actually, there's obviously some exceptions. But I had known the subject matter you were looking for, but I did not spot the trend that you've never had CEOs on. So I think my pitch was actually okay, but the spokesperson was not the kind of person that you would want on. So maybe you won't get it right 100% of the time, but you can tell a lot just by doing some searches.

**中文翻译:**
是的，显然有些例外。但我当时知道你寻找的主题，却没发现你几乎不请 CEO 的趋势。所以我觉得我的推介内容其实还可以，但发言人不是你想要的那类人。所以也许你无法做到 100% 正确，但通过搜索确实能了解很多。

---

### [00:55:24] Lenny

**English:**
And oftentimes I just reply, "Here's my policy." And then, "Okay, good to know." Kind of along these lines, something I wanted to ask earlier, you mentioned a few publications to go after, and then how to pitch people. Obviously the way that you're describing takes a bunch of time. How many people are you often emailing, DMing per attempt to get a story? Because it sounds like it's not a ton, and so you have time to do these sorts of custom pitches. Or is it a lot higher than it sounds?

**中文翻译:**
通常我只是回复：“这是我的原则。”然后对方回：“好，知道了。”顺着这个思路，我刚才想问的是，你提到了几家可以争取的媒体，以及如何推介。显然，你描述的这种方式非常耗时。为了争取一个报道，你通常会给多少人发邮件或私信？因为听起来人数并不多，所以你才有时间做这种定制化的推介。还是说人数其实比听起来要多得多？

---

### [00:55:51] Emilie Gerber

**English:**
I would say for hard news, funding, the startup launch, those sort of things, less, and I try to really stagger it because we're offering exclusives, and I highly recommend offering exclusives. So the worst thing that can happen is two reporters reply, and are both interested, and you have to go back to one and say, "Nevermind." And sometimes that's okay if they left you, if it's been a week or something, they hadn't gotten back, and they'll understand. So it's fine to move on without getting an answer. So I would say, yeah, with the funding story, it could be anywhere from one to six reporters on average, sometimes more. With stuff like general just outreach, relationship building, trying to get on podcasts, it kind of is a numbers game, and you really have to balance quality and quantity.

**中文翻译:**
我会说，对于硬新闻、融资、初创公司发布这类事情，人数较少。我会尽量错开时间，因为我们提供的是“独家”，我也强烈建议提供独家。最糟糕的情况是两个记者都回复并表示感兴趣，你不得不回绝其中一个说：“算了。”有时如果他们晾了你一周没回，你直接找别人也是可以的，他们会理解。所以没有得到答复就继续找下一个人是没问题的。对于融资故事，平均可能是 1 到 6 位记者，有时更多。而对于普通的外联、建立关系、争取上播客，这在某种程度上是数字游戏，你必须平衡质量和数量。

---

### [00:56:38] Emilie Gerber

**English:**
And that's why I love starting with the first note and not saying much, and just saying, "Hey, you open to guest ideas?" Because it allows you to do more. I'd rather do that than send a bad pitch, and not have it be targeted to the right sort of audience. And so that's kind of a way to play the numbers game while still being respectful. But yeah, I mean, with some clients maybe they get one opportunity for every 20 or 30 things that we send. And so yeah, we try not to do... We don't do blasting media, it's not about sending the same pitch to a single list of people. It's figuring out, which ones do I want to really double down on because they're the perfect target? And you'll keep trying, you'll be really custom, which deserve maybe a slightly higher level note, which deserve a DM, and just figuring out your strategy from that.

**中文翻译:**
这就是为什么我喜欢从第一封简短的信开始，只说：“嘿，你接受嘉宾建议吗？”因为这能让你联系更多人。我宁愿这样做，也不愿发一个糟糕的、没有针对正确受众的推介。这是一种既能玩转数字游戏又能保持尊重的方式。不过，对于某些客户，可能每发送 20 或 30 次尝试才能获得一个机会。所以我们尽量不……我们不做“媒体群发（blasting media）”，不是把同样的推介发给一长串名单。而是弄清楚：哪些是我真正想全力以赴争取的，因为他们是完美的目标？然后你会不断尝试，非常定制化，决定哪些值得发一封更高级别的信，哪些值得发私信，并以此制定策略。

---

### [00:57:27] Lenny

**English:**
Awesome, okay. Do you have examples of pitches, announcements that were not as effective as they could have been, and advice for how they could have been better?

**中文翻译:**
好，明白了。你有没有一些推介或公告的例子，是效果不如预期的，以及关于如何改进的建议？

---

### [00:57:37] Emilie Gerber

**English:**
Yeah, I have some excerpts that I pulled from press releases where I think there's room for improvement. So Lenny, I want to read one to you, and then I want to see if you can tell me what this company does. Okay, "Today X announced their workflow automation product, which combines AI assistance, human in the loop collaboration, and a robust multiplayer experience to help teams save time."

**中文翻译:**
有的，我从一些新闻稿中摘录了一些我认为有改进空间的内容。Lenny，我想读一段给你听，看看你能不能告诉我这家公司是做什么的。听好了：“今天，X 公司宣布了他们的工作流自动化产品，该产品结合了 AI 辅助、人机协作（human in the loop collaboration）以及强大的多玩家体验（multiplayer experience），旨在帮助团队节省时间。”

---

### [00:58:03] Lenny

**English:**
Absolutely no idea what's going on.

**中文翻译:**
完全不知道在说什么。

---

### [00:58:05] Emilie Gerber

**English:**
You kind of gained something from workflow automation, and then after that it's like, "Wait, what?"

**中文翻译:**
你大概能从“工作流自动化”里猜到点什么，但后面那些就让人觉得：“等等，啥？”

---

### [00:58:05] Lenny

**English:**
Just a bunch of things.

**中文翻译:**
就是一堆词儿。

---

### [00:58:10] Emilie Gerber

**English:**
Okay, now let me read to an excerpt from the TechCrunch article, and this is how TechCrunch positioned it, "A new automation startup is setting out to eat Zapier's lunch. It helps people tackle mundane and repetitive tasks, and goes beyond the triggers and actions popularized by similar platforms like Zapier." So to me, yeah, it's a better version of Zapier, where they aren't just doing triggers and actions, and there's a little more substance and depth to it. If you know what Zapier is, you can kind of start to figure out what they do based on that.

**中文翻译:**
好，现在让我读一段 TechCrunch 文章的摘录，看看 TechCrunch 是如何定位它的：“一家新的自动化初创公司正准备抢走 Zapier 的饭碗。它帮助人们处理单调重复的任务，并且超越了像 Zapier 这样类似平台所普及的‘触发与动作’模式。”对我来说，是的，它就是一个更好版本的 Zapier，不只是做触发和动作，更有实质内容和深度。如果你知道 Zapier 是什么，你就能据此推断出他们是做什么的。

---

### [00:58:41] Lenny

**English:**
Yeah, it comes back to your point about referencing incumbent to help you understand what the heck you're talking about

**中文翻译:**
是的，这又回到了你之前的观点：引用老牌巨头来帮助理解你到底在说什么。

---

### [00:58:47] Emilie Gerber

**English:**
And you wouldn't necessarily need to do that in your press release, but I think they could have been a lot clearer, and not use... Because terms like robust multiplayer experience, that makes it sound like a game. Are we talking about just collaborative multiple users? Human in the loop collaboration, isn't all collaboration between humans, and we're all in the loop? AI assistance, that just means they use AI. So yeah, sometimes I push my clients to like, "Okay, let's talk through what each of these phrases actually means. And if you can't articulate it, then let's change it to the way that you just articulated it, and it might be more successful." So yeah, that's a good way to do it. And just read it out loud, read it out loud and see if someone understands it.

**中文翻译:**
你不一定非要在新闻稿里这么写，但我认为他们本可以写得更清楚，而不是使用……因为像“强大的多玩家体验”这种词，听起来像是个游戏。我们是在谈论多人协作吗？“人机协作”，难道所有的协作不都是人与人之间、大家都在参与吗？“AI 辅助”，那只是意味着他们用了 AI。所以，有时我会逼我的客户：“好，让我们聊聊这些短语到底是什么意思。如果你说不清楚，那就把它改成你刚才描述的样子，这样可能会更成功。”是的，这是一个好方法。还有就是大声读出来，看看别人能不能听懂。

---

### [00:59:34] Lenny

**English:**
Someone hearing this is like, "How could possibly anybody think that was great? How did these come about, these really bad descriptions?" I know it's hard to come up with something really short and pithy, but where do these come from?

**中文翻译:**
听众可能会想：“怎么会有人觉得那段话写得好呢？这些糟糕的描述是怎么产生的？”我知道想出简短精炼的话很难，但这些词儿到底是从哪儿冒出来的？

---

### [00:59:49] Emilie Gerber

**English:**
It's just a culture within marketing and comms, of this is how we're supposed to write. And I just think that's a majority of how people do it, and they think it sounds smart, or they think it sounds more professional. I just think it's just how people are trained. And so even when we bring on someone new, part of my job is stripping away at a lot of that, and getting people... Everyone's capable of talking like a human being, we do it every day. But it's stripping away that thing that goes off in your head that you're supposed to be writing in a very marketingy way. Because I would say at least 50% of releases are like that, it's not a small problem.

**中文翻译:**
这只是营销和传播领域的一种文化，觉得“我们就该这么写”。我认为大多数人都是这么做的，他们觉得这样听起来很聪明，或者更专业。我觉得这就是人们受训的方式。所以即使当我们招新人时，我的部分工作就是剥离这些东西，让人们……每个人都能像正常人一样说话，我们每天都在这么做。但关键是要剥离你脑子里那个“我应该用营销腔写作”的念头。我会说至少 50% 的新闻稿都是那样的，这不是个小问题。

---

### [01:00:30] Lenny

**English:**
I love the advice you shared of just trying to say it out loud, hearing yourself, what does it sound like? Do you have any other tips for trying to make it something people get and connect to? I know that, again, it takes a lot of time to really do well and it's very context specific, but is there any other tricks that you find help you communicate what you're actually offering?

**中文翻译:**
我喜欢你分享的建议：试着大声说出来，听听自己说的是什么。你还有其他技巧能让人们理解并产生共鸣吗？我知道这需要很多时间才能做好，而且非常取决于语境，但还有什么诀窍能帮助沟通你到底在提供什么吗？

---

### [01:00:48] Emilie Gerber

**English:**
It's talking through the basic questions, what does this product do? Who is it for? Who are your customers? If you can answer each of those in one sentence... What product launch are we talking about here? If you can just answer each of those verbally, chances are you're not going to be far away from what you're looking for. Because when I talk to marketers, and founders, and teams, generally in the conversations I have no trouble understanding what they're talking about. They can articulate it just fine, it's only in the writing that it gets that way. So actually I think it's kind of easier to solve than many might realize. And then also I think there is some skill involved in removing words, not over explaining, you can make things more concise. But at the bare minimum, just strip out all the jargon, that's the first step.

**中文翻译:**
就是理清几个基本问题：这个产品是做什么的？它是给谁用的？你的客户是谁？如果你能用一句话回答每一个问题……我们在这里讨论的是什么产品发布？如果你能口头回答这些问题，通常你就离目标不远了。因为当我与营销人员、创始人和团队交谈时，通常我理解他们的话完全没问题。他们能表达得很清楚，只是到了写作时才变成那样。所以实际上，我认为这比许多人意识到的更容易解决。此外，我认为删减词汇、不过度解释也是一种技巧，你可以让内容更简洁。但最起码，剥离所有的行业术语（jargon），这是第一步。

---

### [01:01:36] Lenny

**English:**
I love it. So one way to think about it is, just think about, what does it do? Who is it for? Who are the customers? Is there something else along those lines that you shared there as a bullet point?

**中文翻译:**
太棒了。所以一种思考方式就是：它做什么？给谁用？客户是谁？关于这一点，你还有其他的要点分享吗？

---

### [01:01:45] Emilie Gerber

**English:**
Well, I mean, if you're talking about what makes this business interesting? Why should people care? And not over indexing on that. I think that's just one part of the overall story, is why people should care about this business. And then what's new? Is it growth metrics? Is it the customer piece? Is it product? What makes this timely and relevant right now?

**中文翻译:**
嗯，我的意思是，如果你在谈论“是什么让这项业务有趣？”“人们为什么要关心？”不要过度纠结于此。我认为这只是整个故事的一部分，即人们为什么要关心这项业务。然后是“有什么新消息？”是增长指标？是客户案例？还是产品？是什么让它在当下具有时效性和相关性？

---

### [01:02:08] Lenny

**English:**
Okay, awesome. There's actually this awesome Twitter thread from a couple of days ago, where the CEO of Product Hunt did this thread where he asked people, "Share your tagline, and I will give you a much better version of the tagline." And he's really good at this. So I'm going to link to it in the show notes, where he can give you an example of what it looks like from bad to good.

**中文翻译:**
好，太棒了。实际上几天前有一条很棒的 Twitter 线程，Product Hunt 的 CEO 发起的，他让人们“分享你的标语（tagline），我会给你一个更好的版本”。他非常擅长这个。我会把链接放在节目介绍里，他可以给你展示从糟糕到优秀的例子。

---

### [01:02:26] Emilie Gerber

**English:**
I love that. That's exactly the kind of thing I would love to do too, because it's so fun and so easy.

**中文翻译:**
我喜欢那个。那正是我也想做的事情，因为太有趣也太简单了。

---

### [01:02:33] Lenny

**English:**
It's easy if you're good at it, most people are not great at it. You mentioned press release in this example, you shared thoughts on value of press release, traditional press release versus not.

**中文翻译:**
如果你擅长的话确实简单，但大多数人并不擅长。你在例子中提到了新闻稿（press release），你对新闻稿的价值怎么看？传统新闻稿与非传统形式相比呢？

---

### [01:02:44] Emilie Gerber

**English:**
Press releases came about because reporters would be checking news wires for ideas of what stories they want to write. No reporters do that anymore, or a very small percentage, I don't know any reporters that do that anymore. So now it's this thing where you go to one of the PR distribution services, you pay them anywhere between 300 to $2,000, that's literally what it costs, and they put it on the wire. And for the more expensive services, it does get syndicated to this press release section of some business websites. No one, in my opinion, goes there for their news. I've personally never read an article, like a Yahoo Finance article, that was a press release syndication. So in that sense, they are not helpful for getting eyeballs. They also require... Going back to that more marketing form of writing, they require that you write like that.

**中文翻译:**
新闻稿之所以出现，是因为记者以前会查看“新闻通讯社（news wires）”来寻找写作灵感。现在已经没有记者这么做了，或者比例极小，我一个都不认识。所以现在的情况是，你去公关分发服务商那里，支付 300 到 2000 美元不等（这就是实际成本），他们帮你发到通讯社。对于更昂贵的服务，它确实会被同步（syndicated）到一些商业网站的新闻稿板块。但在我看来，没人会去那里看新闻。我个人从未读过一篇像雅虎财经那样的文章是来自新闻稿同步的。所以从这个意义上说，它们对吸引眼球毫无帮助。而且它们还要求……回到那种营销腔的写作方式，它们要求你必须那样写。

---

### [01:03:39] Emilie Gerber

**English:**
The standard press release format, it's so formulaic, and I think it actually encourages that more marketing speak. The benefit is that you're getting all the news details in one place, so it's relevant for a reporter. However, you can do the exact same thing in a blog post. And the blog post can be this first person piece of content that's written by either the founder, or the product lead, or whatever executive, that has a lot more flexibility in the style. You can write it however you want, it can still include all the same news elements. And it's much more shareable on social, you're not going to share a link to a press release on your Twitter or on your LinkedIn, but a blog, for sure. You can add your own graphics, it's great.

**中文翻译:**
标准的新闻稿格式非常公式化，我认为它实际上助长了营销腔。它的好处是把所有新闻细节集中在一个地方，方便记者查阅。然而，你完全可以在博客文章中做同样的事。博客文章可以是第一人称的内容，由创始人、产品负责人或任何高管撰写，风格上灵活得多。你可以随心所欲地写，同时包含所有相同的新闻元素。而且它在社交媒体上更容易分享，你不会在 Twitter 或 LinkedIn 上分享新闻稿链接，但博客肯定会。你还可以加入自己的图表，这很棒。

---

### [01:04:21] Emilie Gerber

**English:**
And you're also encouraging people to go to something that lives on your website versus this black hole of a newsletter. I should be fair, so I think that the reason that people say that they still do them, is that it helps with SEO. However, I've read a few articles that have said that Google no longer does prioritize press releases in SEO, so I don't know how much that holds up. And that it signals to the market that the company is more serious, so that's a perception thing. I personally think that blogs actually signal a more modern, kind of cool company than a press release. But at a certain stage in your growth, public companies, they do press releases for earnings, makes 100% sense. There are certain rules around when companies do need to issue press releases, so there's still a use case for them, I just think your average early to mid-stage startup doesn't need them.

**中文翻译:**
你还在鼓励人们访问你网站上的内容，而不是掉进新闻稿分发的黑洞。公平地说，人们坚持发新闻稿的原因之一是觉得它有助于 SEO（搜索引擎优化）。然而，我读过几篇文章说 Google 不再优先考虑 SEO 中的新闻稿，所以我不知道这还有多大用。还有人觉得这向市场传递了公司很正规的信号，这是一种认知问题。我个人认为，博客其实比新闻稿更能传递出一种现代、酷炫的公司形象。但在发展的某个阶段，比如上市公司，他们为了财报发新闻稿，这百分之百合理。关于公司何时必须发布新闻稿是有特定规则的，所以它们仍有使用场景，我只是觉得普通的早期到中期初创公司不需要它们。

---

### [01:05:10] Lenny

**English:**
This mention of blogs is where I wanted to go next actually, so it's a good segue. But before we do that, is there any other examples that you wanted to share of less than ideal ways of pitching a product?

**中文翻译:**
提到博客正好是我接下来想聊的，这是一个很好的过渡。但在那之前，你还有其他关于“不太理想的产品推介方式”的例子想分享吗？

---

### [01:05:21] Emilie Gerber

**English:**
One sentence I found in a press release that a lot of companies want to include that I always try to remove is... Well here, I'll give you the sentence, "Since exiting stealth in May, we've witnessed a 700% increase in organizations using our product." You're saying that since you were in stealth to now you saw a 700% increase, so you could have had one customer, now you have seven. And it's every company wants to do these percentage growth stats when they just launched, and I've never seen reporters include that in their stories.

**中文翻译:**
我在新闻稿中发现很多公司都想加的一句话，而我总是试图删掉它，那就是……我读给你听：“自 5 月份结束隐身模式以来，我们见证了使用我们产品的组织增加了 700%。”你是在说从隐身到现在增长了 700%，那可能意味着你以前只有 1 个客户，现在有 7 个。每家公司刚发布时都想用这种百分比增长数据，但我从未见过记者把这种数据写进报道里。

---

### [01:05:50] Emilie Gerber

**English:**
And so there are ways to give signals of how fast you're growing without being that kind of disingenuous. One way that you could put something similar is, "Our revenue hit six figures at the end of last year, and has been growing about 30% each quarter, with 40% of adoption coming from the enterprise sector." So you're giving color to the growth, and you can kind of play with that, it doesn't need to be exactly something like that. But if you can make it a little more specific, I'm not against doing percentages, but I think there's a way to balance that with something that seems a little more realistic.

**中文翻译:**
所以，有很多方法可以展示你的增长速度，而不需要显得那么虚伪。你可以这样写：“我们的营收在去年年底达到了六位数，并且每季度增长约 30%，其中 40% 的采用来自企业级市场。”这样你就为增长增加了细节，你可以灵活处理，不一定要完全照搬。如果你能写得更具体一点，我不反对用百分比，但我认为应该用一些看起来更真实的东西来平衡。

---

### [01:06:25] Lenny

**English:**
Or, "We went from zero to six figures in ARR in X months."

**中文翻译:**
或者，“我们在 X 个月内实现了 ARR（年度经常性收入）从零到六位数的突破。”

---

### [01:06:29] Emilie Gerber

**English:**
Yeah, no, totally. And it doesn't need to be huge, especially if you're doing your first story, they're not expecting that you're necessarily going to have massive revenue. And so I think founders might sometimes be concerned that it's not going to seem big enough or significant enough, whereas from working with a lot of companies, it's kind of the case across the board.

**中文翻译:**
是的，完全正确。而且数额不需要很大，特别是当你做第一篇报道时，他们并不指望你一定有巨额营收。我觉得创始人有时会担心数据看起来不够大或不够重要，但根据我与这么多公司合作的经验，大家的情况其实都差不多。

---

### [01:06:49] Lenny

**English:**
You mentioned a bunch of amazing companies, you've worked with Ramp, Perplexity, a few others. And people may feel like, of course you're getting pressed, those are amazing. Ramp grew to a 100 million AR in two years, Perplexity is this killer AI product, everyone's talking about AI. Most products are not that, they don't have as interesting of a story to tell. Is there either an example you could share of a company that didn't have an amazing story to tell, that you created an interesting story out of? Or just any advice for, how do you help find something that is a nugget that gets people excited?

**中文翻译:**
你提到了一堆了不起的公司，你合作过 Ramp、Perplexity 等等。人们可能会觉得，当然你能获得报道，因为那些公司太牛了。Ramp 在两年内增长到 1 亿 ARR，Perplexity 是杀手级的 AI 产品，现在人人都在谈论 AI。但大多数产品并非如此，它们没有那么有趣的故事。你能不能分享一个例子，关于一家原本故事平平的公司，你如何挖掘出了有趣的故事？或者有什么建议，如何帮助找到那些能让人兴奋的“素材（nugget）”？

---

### [01:07:23] Emilie Gerber

**English:**
So some of the examples I gave, so Clockwise and Column Tax aren't as big as some of the other brands I mentioned. So that's certainly actually the bulk of our business, I would say 80% of the companies we work with are at a stage where they haven't reached that kind of mass awareness yet. Another really great company that we work with is Entropy. And so essentially they work with transaction data, they're an API. It's a very technical tool, it's not something that necessarily every reporter is going to instantly understand. But for them, we've actually really leaned into the founder story. She's this incredible woman who moved to the US, and actually struggled with getting her first apartment here because of the way that our credit scoring system is set up. And one of the use cases for what she's building actually directly relates to how our credit system could change in the future, and so we've been really leaning into that angle. And her personal story is really powerful. And so maybe sometimes the product isn't going to be something that you can easily pitch, but you can kind of find those other personal angles in or pull on certain threads.

**中文翻译:**
我之前举的一些例子，比如 Clockwise 和 Column Tax，规模都没有我提到的其他品牌那么大。这实际上是我们业务的大头，我会说 80% 与我们合作的公司都处于尚未达到大众知名度的阶段。我们合作的另一家很棒的公司是 Entropy。他们主要处理交易数据，是一个 API。这是一个非常技术化的工具，不一定每个记者都能立刻理解。但对于他们，我们实际上非常倚重创始人的故事。她是一位了不起的女性，移民到美国，最初因为我们的信用评分系统而很难租到第一套公寓。而她正在构建的产品的一个用例，恰恰直接关系到未来信用系统可能发生的变化，所以我们一直非常侧重这个角度。她的个人故事非常有力量。所以，有时产品可能不容易推介，但你可以找到其他个人角度或挖掘某些线索。

---

### [01:08:33] Lenny

**English:**
And there it connects back to find the publication that cares about these sorts of personal stories, because TechCrunch probably won't.

**中文翻译:**
这就又回到了寻找关注这类个人故事的媒体，因为 TechCrunch 可能不会感兴趣。

---

### [01:08:40] Emilie Gerber

**English:**
Yeah. But she spoke at Money20/20, so it's useful for speaking abstracts too. Actually it was on a panel with Column Tax, we got them on together at Money20/20.

**中文翻译:**
是的。但她在 Money20/20 大会上发过言，所以这对演讲摘要也很有用。实际上，她和 Column Tax 一起参加了一个小组讨论，我们让他们在 Money20/20 上同台了。

---

### [01:08:52] Lenny

**English:**
What a win.

**中文翻译:**
真是个大胜利。

---

### [01:08:56] Emilie Gerber

**English:**
No, and we love doing that, it's so fun when you do have multiple companies that you can connect. Actually, that's kind of a good macro point as well. It doesn't always need to just be about you, if you have an idea for a conference session, reaching out to colleagues that you've worked with at other companies, peers, people that are building other things that maybe don't compete better in a similar space, and packaging that up as like, "Hey, this could be a really strong panel." It's actually way more successful than just pitching yourself.

**中文翻译:**
是的，我们很喜欢这样做。当你能把多家公司联系起来时，非常有趣。实际上，这也是一个很好的宏观观点：不一定总是关于你自己。如果你有一个会议议题的想法，联系你在其他公司合作过的同事、同行，或者在类似领域做非竞争性产品的人，把他们包装在一起说：“嘿，这可能是一个非常强大的小组讨论。”这实际上比只推介你自己要成功得多。

---

### [01:09:24] Lenny

**English:**
Awesome, okay. So you've mentioned a couple of times the rise of newsletters and podcasts. So there's kind of two buckets of questions here. One is going after these kind of non-traditional media platforms, and then the other is building your own following, and building a following on Twitter, for example. I know you worked closely with the CEO of Vox who's really good at this, and basically doesn't need press. Elon is amazing at this, maybe that's why he bought Twitter, he has this huge platform to talk about all the stuff. So maybe in the first bucket, talking about when you're trying to decide, should I go after traditional media, Vox, and VentureBeat, and Axios, and all these guys? Versus I'm going to go for newsletters. As an example, Ramp got a lot of benefit from Not Boring, that newsletter with Packy, who wrote about them constantly and loved it. And they're sponsored posts, and organic posts. So I guess the question there is just, how do you think about going after podcasts, newsletters, Twitter, LinkedIn, influencery platformy people versus traditional press?

**中文翻译:**
好，太棒了。你几次提到了时事通讯和播客的兴起。这里有两类问题：一类是争取这些非传统媒体平台；另一类是建立自己的受众，比如在 Twitter 上建立关注。我知道你曾与 Box 的 CEO（Aaron Levie）密切合作，他非常擅长这个，基本上不需要媒体报道。马斯克在这方面也很惊人，也许这就是他买下 Twitter 的原因，他有一个巨大的平台来谈论所有事情。所以第一类问题是，当你决定是该争取传统媒体（如 Vox, VentureBeat, Axios 等），还是该争取时事通讯时，你怎么想？例如，Ramp 从 Packy 的《Not Boring》时事通讯中获益匪浅，Packy 经常写他们而且很喜欢。既有赞助贴也有自然贴。所以问题是，你如何看待争取播客、时事通讯、Twitter、LinkedIn 上的网红/平台型人物，与传统媒体之间的权衡？

---

### [01:10:31] Emilie Gerber

**English:**
I think of newsletters and podcasts actually in the camp of, if we're pitching traditional press, we're 100% pitching those. Social is its own ball game, but I would not leave out newsletters and podcasts from any core PR strategy. To me, it's now just a part of any PR program that we're going to run, because it's just part of media now. And to me, it's just a very important part of media. In terms of social, I think doing social well is very hard. So you gave Aaron from Vox as an example, that was all 100% him. I think I helped with one tweet once about a Microsoft partnership that we did, and I was so excited.

**中文翻译:**
我实际上把时事通讯和播客归为一类：如果我们推介传统媒体，我们也 100% 会推介这些。社交媒体是另一回事，但我不会在任何核心公关策略中漏掉时事通讯和播客。对我来说，它们现在是我们运行的任何公关项目的一部分，因为它们就是媒体的一部分。而且对我来说，它们是媒体中非常重要的一部分。至于社交媒体，我认为做好社交媒体非常难。你举了 Box 的 Aaron 为例，那 100% 是他亲力亲为。我想我曾经帮他写过一条关于我们与微软合作的推文，当时我兴奋极了。

---

### [01:11:10] Lenny

**English:**
How did it do?

**中文翻译:**
效果怎么样？

---

### [01:11:11] Emilie Gerber

**English:**
Actually really good. A publication ended up writing a story on the tweet about Microsoft and Vox partnership because of it. Yeah, so that was fun. But generally it's not always something that you can just turn on by hiring an agency. And I've seen many companies try doing that, and not necessarily see as much success as they'd hoped for. So if a founder is naturally good at that stuff, lean into it as much as humanly possible, go for it. If they're not, and you're trying to outsource it, it can be done to some success. But I don't necessarily think it's as easy as just posting three times a week on relevant topics, there has to be more going on there. I think that if the spokesperson or the executive that you're trying to build the presence of is willing to... Going back to what I said earlier, kind of push the limit.

**中文翻译:**
实际上非常好。一家媒体最终根据那条关于微软和 Box 合作的推文写了一篇报道。是的，那很有趣。但通常情况下，这并不总是你雇个代理机构就能立刻搞定的。我见过很多公司尝试这样做，但未必能看到预期的成功。所以，如果创始人天生擅长这些，那就尽可能地发挥这个优势，放手去做。如果他们不擅长，而你试图外包，也能取得一定成功。但我并不认为这只是每周在相关话题上发三次帖那么简单，背后必须有更多东西。我认为，如果你试图建立知名度的发言人或高管愿意……回到我之前说的，挑战一下极限。

---

### [01:12:00] Emilie Gerber

**English:**
... Presence of is willing to, going back to what I said earlier, push the limit on opinions that they have, be bold, be controversial, then it could be worth potentially investing in. And I have seen it play out where reporters have seen those posts and used and quoted things in their articles as a result, so it can tie to your traditional media strategy a little bit, they're not necessarily fully siloed, but I would say if you're considering investing in social to just do corporate channels and not think about executives, you're really leaving a lot on the table. Corporate channels, it's very hard to build a following.

**中文翻译:**
……如果他们愿意在观点上挑战极限，大胆且具有争议性，那么投资社交媒体可能是有价值的。我见过这样的情况：记者看到了这些帖子，并在文章中引用了其中的内容。所以它可以与你的传统媒体策略挂钩，它们并非完全孤立。但我要说，如果你考虑投资社交媒体却只做公司官方账号而不考虑高管个人账号，那你真的错失了很多机会。公司官方账号很难建立起追随者。

---

### [01:12:39] Emilie Gerber

**English:**
To get someone to follow a brand and care about a brand, you have to be bringing something new to the table, because they don't want to read your latest blog post, they don't want to read a relevant article that your social person just decided to put out there. When you have an executive, you're following a personality, you're following a person, ideally there's more flexibility with tone, all of that sort of stuff. And so I think it's important to think about it from the people perspective and not just the brand perspective.

**中文翻译:**
要让某人关注一个品牌并关心它，你必须带来一些新东西，因为他们不想读你最新的博客文章，也不想读你的社交媒体运营人员决定发布的某篇相关文章。当你关注一位高管时，你关注的是一个性格，一个真实的人，理想情况下语调更有灵活性，诸如此类。所以我认为从“人”的角度而不仅仅是“品牌”的角度来思考是很重要的。

---

### [01:13:07] Lenny

**English:**
So just to make it clear, the CEO or some execs should be the people tweeting and LinkedIn, and not the company as a brand?

**中文翻译:**
所以明确一下，应该是 CEO 或某些高管在 Twitter 和 LinkedIn 上发声，而不是以公司品牌的形式？

---

### [01:13:17] Emilie Gerber

**English:**
Yeah. And I don't know. I think that it can be a little industry specific as well for where it makes sense to be investing in the corporate channels. And you certainly can do that sort of thing. But I also think if you're going to do that, have an exec that you're also trying a social strategy with. Don't just do the plain corporate channels.

**中文翻译:**
是的。不过我也觉得这在某种程度上取决于行业，决定了在哪些领域投资公司官方渠道是有意义的。你当然可以做官方渠道。但我认为如果你打算这样做，也要同时为一位高管尝试社交媒体策略。不要只做枯燥的公司官方渠道。

---

### [01:13:36] Lenny

**English:**
When I think of a brand doing this really well, it's Duolingo. They're just so hilarious and so ridiculous in there. And I don't know if the key is just funny is the way to go, and that's how you get any attention, but they're so funny and creative in their videos, especially TikTok.

**中文翻译:**
当我想到一个品牌在这方面做得很好时，我会想到多邻国（Duolingo）。他们在社交媒体上简直太搞笑了，太荒谬了。我不知道“搞笑”是不是唯一的出路，是不是只有这样才能获得关注，但他们的视频确实非常有趣且有创意，尤其是在 TikTok 上。

---

### [01:13:50] Emilie Gerber

**English:**
It's interesting though, we're getting to the point where even brands having a personality on social is becoming its own meme. People are making fun of how all the fast food brands all are like these Gen Z like TikTok-

**中文翻译:**
有趣的是，我们现在正处于这样一个阶段：甚至连“品牌在社交媒体上拥有人格”本身也变成了一个梗（meme）。人们在嘲笑所有的快餐品牌现在都表现得像那些 Gen Z 的 TikTok 用户——

---

### [01:13:59] Lenny

**English:**
And they're all replying to each other on Twitter threads.

**中文翻译:**
而且他们还在 Twitter 线程里互相回复。

---

### [01:14:02] Emilie Gerber

**English:**
Yeah. And so things change quickly. So, yes, that was a good strategy, but you just have to stay on top of it.

**中文翻译:**
是的。所以情况变化很快。没错，那曾是一个好策略，但你必须紧跟潮流。

---

### [01:14:11] Lenny

**English:**
So you talked about how if this comes naturally to you as a founder, obviously do it. I'm guessing for most people it doesn't. Do you find that it can work if you're just like, "I know this is important, I need to tweet often and share things," have you seen that work or is it just like it's just probably not going to be something that works great for you?

**中文翻译:**
你提到如果作为创始人这对你来说是天性，那就去做。我猜对大多数人来说并非如此。你觉得如果只是抱着“我知道这很重要，我需要经常发推分享东西”的心态，这能奏效吗？你见过这种方式成功的例子吗，还是说这可能不太适合这类人？

---

### [01:14:31] Emilie Gerber

**English:**
Yeah, I think it can work to some extent. Maybe you're not going necessarily be going viral or getting hundreds or tens of thousands of followers. But for me personally I push myself to post on LinkedIn at least once a month, because every time I post we get at least one client inbound and maybe a candidate inbound. And so if you test it and you start to see value, push yourself to do it even if it doesn't come naturally. And that's, I guess, the nice thing about social is it's easy to test out. You can try doing it, you can post for a while, even for a month or two, see how it's going, and then adjust your strategy accordingly.

**中文翻译:**
是的，我认为在某种程度上是可以奏效的。也许你不会一夜爆红，或者获得成千上万的粉丝。但对我个人来说，我强迫自己每月至少在 LinkedIn 上发一次帖，因为每次发帖我们至少能获得一个潜在客户咨询，也许还有一个求职者咨询。所以如果你测试并开始看到价值，即使它不是你的天性，也要强迫自己去做。我想社交媒体的好处就在于它很容易测试。你可以尝试做一段时间，发一两个月看看效果，然后相应地调整策略。

---

### [01:15:06] Emilie Gerber

**English:**
But, yes, I think for a lot of execs that we work with, it does feel like it's something that's really hard, there's a lot of overthinking, making sure it's right. You can get really in your head about it, and I totally understand that because I feel the same way. And so if it's taking up so much of your time and bandwidth just thinking about your social strategy, then I guess you can weigh if it makes sense to do that, but I think pushing yourself to try it is a great idea.

**中文翻译:**
但是，是的，对于许多与我们合作的高管来说，这确实感觉很难，会有很多过度思考，总想确保万无一失。你会为此感到非常焦虑，我完全理解，因为我也有同感。所以，如果仅仅是思考社交策略就占用了你太多的时间和精力，那么我想你可以权衡一下这样做是否有意义，但我认为强迫自己尝试一下是个好主意。

---

### [01:15:31] Lenny

**English:**
And then Aaron specifically is very good at this, is there anything that you learned from his approach to tweeting specifically? I don't know if he uses other platforms. That works really well for him.

**中文翻译:**
Aaron（Box CEO）特别擅长这个，你从他发推特的方式中学到了什么特别的东西吗？我不知道他是否使用其他平台。那对他非常有效。

---

### [01:15:42] Emilie Gerber

**English:**
I actually think I just learned so much. So it was my first in-house job, so I had worked in an agency, I hadn't worked internally at a company before, and I think I just learned so much about comms best practices from him in general, just even beyond social. He was so good at figuring out how to comment on things happening in the news, having just the right stance that was both interesting to the reporter but not necessarily threatening to the business, and just capitalizing on all those moments. And I just watched how that worked and I was like, "This is how good PR is." And it's like the space that they're in is not necessarily one that reporters are all writing about, but he was able to insert himself in those conversations really well. And I think also at the time that I was there at least just really valued press and was willing to put the time in and do the briefings.

**中文翻译:**
我真的学到了很多。那是我的第一份甲方（in-house）工作，之前我一直在公关公司工作，没在公司内部待过。我觉得我从他那里学到了很多关于传播的最佳实践，甚至超出了社交媒体的范畴。他非常擅长评论新闻中发生的事情，能找到恰到好处的立场——既能引起记者的兴趣，又不会对业务造成威胁，并且能利用好所有这些时刻。我观察他是如何运作的，心想：“这就是优秀的公关。”他们所在的领域并不一定是记者们都在写的热门领域，但他能很好地把自己插入到那些对话中。而且我认为至少在我工作的那段时间，他非常重视媒体，愿意投入时间并亲自参与简报。

---

### [01:16:34] Emilie Gerber

**English:**
And so just getting to hear how he speaks over and over again was really helpful. And then on Twitter, I think it clearly just comes naturally to him, and so it wasn't necessarily something that needed to... Like I mentioned, how some execs will spend all this time thinking through to the point where it could get in the way of other things. I think that's not the case there. And if anything, it just helped the business. And actually with his Twitter presence, I would say it a good example too of stuff getting included in articles, like I mentioned in that Microsoft article. So it helps the PR strategy as well.

**中文翻译:**
所以，一遍又一遍地听他如何表达真的很有帮助。在 Twitter 上，显然这对他来说是天性，所以不一定需要……像我提到的，有些高管会花大量时间思考，以至于妨碍了其他工作。我觉得他不是那样。如果说有什么影响的话，那就是它帮助了业务。实际上，他的 Twitter 存在感也是一个很好的例子，说明内容会被纳入文章中，就像我提到的那篇微软文章。所以它也对公关策略有帮助。

---

### [01:17:10] Lenny

**English:**
Amazing. And we'll link to his Twitter account. This is Aaron, CEO of Box, by the way. I think I mentioned at the beginning and then we just started talking about Aaron. Also, I realize, he tweets about this sometimes, he actually makes money from Twitter, and now the Twitter pays you for views and things and they share ads, he makes thousands of dollars also from X now, by the way, not Twitter.

**中文翻译:**
太棒了。我们会附上他的 Twitter 账号链接。顺便说一下，这位是 Box 的 CEO Aaron。我想我开头提过，然后我们就开始聊 Aaron 了。另外我发现，他有时也会发推提到这个，他实际上能从 Twitter 赚钱，现在 Twitter 会根据浏览量等给你付钱，他们会分享广告收益，顺便说一下，他现在从 X（不再叫 Twitter 了）也能赚到几千美元。

---

### [01:17:29] Emilie Gerber

**English:**
That's so funny.

**中文翻译:**
太有意思了。

---

### [01:17:30] Lenny

**English:**
Yeah, it's pretty ridiculous. I think I've gone through every question that I had for you. I'm curious if there's anything else that you think might be helpful to share or cover or leave listeners with.

**中文翻译:**
是的，挺不可思议的。我想我已经问完了所有想问你的问题。我很好奇你是否觉得还有什么其他值得分享、涵盖或留给听众的内容。

---

### [01:17:43] Emilie Gerber

**English:**
I can leave with one very tactical media opportunity that I love.

**中文翻译:**
我可以分享一个我非常喜欢的、极具实操性的媒体机会。

---

### [01:17:51] Lenny

**English:**
Amazing.

**中文翻译:**
太棒了。

---

### [01:17:52] Emilie Gerber

**English:**
Okay, so here it is. It's a way to get a morning brew feature pretty somewhat easily. So they have this series called Morning Brew Coworking series, and they have it for Emerging Tech Brew, they have it for HR Brew, all their verticals. I think there's a CFO one, marketing one. And essentially if you go to the series, the coworking series, either at the top or the bottom, there's something where it's like, "If you want to be featured, click on this link and fill out this form," and it's about 10 questions. If you keep your answers interesting and fun and not too self-promotional, we've had, I would say, 50% success rate with getting execs featured that way. And all you have to do is submit through a Google form.

**中文翻译:**
好，就是这个。这是一种相对容易获得《Morning Brew》报道的方法。他们有一个名为“Morning Brew Coworking”的系列，涵盖了 Emerging Tech Brew、HR Brew 等所有垂直领域。我想还有针对 CFO 和营销人员的。基本上，如果你去那个 Coworking 系列页面，无论在顶部还是底部，都会有一个类似“如果你想被报道，请点击此链接并填写此表单”的东西，大约有 10 个问题。如果你能保持回答有趣、好玩且不过于自我推销，我会说，我们通过这种方式让高管获得报道的成功率达到了 50%。你所要做的就是通过 Google 表单提交。

---

### [01:18:48] Emilie Gerber

**English:**
And it's just one of my favorite media opportunities right now. It doesn't need to be CEO, actually probably shouldn't be a CEO in a lot of instances, but it's basically intended to help readers understand what the day-to-day looks in certain jobs and just get a little insight into the people that are in these jobs. And so I guess I just wanted to share that as something that you could do today for over 10 minutes and potentially get a story. Although, maybe not after you post this, so we'll see if they get an influx.

**中文翻译:**
这是我目前最喜欢的媒体机会之一。不一定非得是 CEO，实际上在很多情况下可能不应该是 CEO。它的初衷是帮助读者了解某些工作的日常生活，并对从事这些工作的人有一些深入了解。所以我想分享这个，作为你今天花 10 分钟就能做的事，并有可能获得一篇报道。不过，在你发布这集节目后可能就不一定了，看看他们会不会收到大量申请。

---

### [01:19:03] Lenny

**English:**
We're going to take down Mailbrew. Funny enough, they have an interview with Zuck today that they published on Morning Brew, so it could be you alongside Zuck.

**中文翻译:**
我们要把 Mailbrew 给挤爆了。有趣的是，他们今天在 Morning Brew 上发表了对扎克伯格的采访，所以你可能会和扎克伯格出现在一起。

---

### [01:19:10] Emilie Gerber

**English:**
There you go, yeah.

**中文翻译:**
没错，就是这样。

---

### [01:19:13] Lenny

**English:**
Maybe before we get to our very exciting lightning round, it might be fun to chat about how to pick a PR agency. Obviously you run one. When people are trying to decide who to work with and also when to decide to pick and work with a PR agency versus doing it themselves, what advice can you share when they're trying to make that big decision?

**中文翻译:**
在进入非常令人兴奋的闪电轮环节之前，聊聊如何选择公关公司可能会很有趣。显然你自己就经营着一家。当人们试图决定与谁合作，以及何时决定聘请公关公司而不是亲力亲为时，你能分享什么建议来帮助他们做这个重大决定吗？

---

### [01:19:33] Emilie Gerber

**English:**
I think there's an assumption that bigger, more well-known agencies are going to do a better job. I think a lot of those bigger, well-known agencies are used to working with a lot of household brands. And so their strategies tend to be very reactive, focus in the messaging, maybe have to turn down a bunch of opportunities, control what people say. That is the polar opposite in my opinion of doing startup PR. Startup PR, you got to experiment, you got to try new things, you got to be scrappy, you got to be fast. We actually personally love diving into pitching right away rather than spending several months on messaging just testing and market right away. And so don't assume just because they have the huge logos... To your point, you're like, "Oh, well, you work with [inaudible 01:20:16] Perplexity, does that mean you know how to work with all these tiny companies?"

**中文翻译:**
我认为人们往往假设规模更大、更知名的机构会做得更好。我觉得很多大型知名机构习惯于与家喻户晓的品牌合作。因此，他们的策略往往是非常被动的（reactive），专注于话术，可能不得不拒绝一堆机会，控制人们的言论。在我看来，这与做初创公司公关完全相反。初创公司公关需要实验，需要尝试新事物，需要灵活（scrappy），需要快速。我们个人非常喜欢立即投入推介，而不是花几个月时间打磨话术，我们会直接去市场测试。所以不要仅仅因为他们有巨大的 Logo 就做假设……就像你说的：“噢，既然你和 Perplexity 合作，那是否意味着你知道如何与这些微型公司合作？”

---

### [01:20:19] Emilie Gerber

**English:**
That's not necessarily a good thing, so don't just go buy the big logos. I would say that's my first piece of advice. My second piece of advice is find out what month one looks like with them. If month one is them just doing intake calls and learning about the company, and you're a startup that's still really paying close attention to how much money you're spending, you're not going to necessarily want to partner with an agency that needs a three-month ramp up cycle. And so really tactically understand what those first few months look like. I think that's something that I've noticed is a lot of agencies take a while before they get their hands dirty and start doing things. My third piece of advice would be writing recent writing samples. To the point of all those press release excerpts I shared, is that how they write? If it is, maybe they're not the right agency. So ask them. That's so easy. That's so easy to do.

**中文翻译:**
那不一定是好事，所以不要只看大 Logo。这是我的第一条建议。第二条建议是：了解与他们合作的第一个月是什么样的。如果第一个月他们只是在做访谈和了解公司，而你是一家仍然非常关注开支的初创公司，你未必想与一家需要三个月启动周期（ramp up cycle）的机构合作。所以要从实操层面了解前几个月的工作内容。我注意到很多机构在真正开始干活之前要花很长时间。第三条建议是看最近的写作样本。回到我分享的那些新闻稿摘录，那是他们的写作风格吗？如果是，也许他们不是合适的机构。直接问他们要，这非常简单。

---

### [01:21:14] Emilie Gerber

**English:**
Just ask them for a couple recent blogs or releases, whatever they tend to go for, and read those. And, of course, wins too. You want to see what kind of stories they're getting, but that's a little more obvious. A lot of people have already talked about this, so I'll just mention briefly, it's important to meet with the actual team you're working on, not just the founder of the agency. So asking who's our day-to-day going to be? Can we chat with them really quick? One thing I would say don't do is an extensive RFP process. We actually as an agency don't participate in RFPs. The two times I've done it, I have regretted it just because of the amount of work going in versus the value that's there. And it's you're asking a team to do a lot of free work for you, and generally I think the best players are not going to do that, so you're going to weed out some of the best players if you're asking them to do a lot of free upfront work. So those are a few considerations.

**中文翻译:**
向他们要几篇最近的博客或新闻稿，看看他们擅长什么，然后读一读。当然，还有“战绩（wins）”。你想看看他们能争取到什么样的报道，但这比较显而易见。很多人都谈过这一点，我就简单提一下：重要的是要见到实际负责你项目的团队，而不仅仅是机构的创始人。所以要问：谁是我们的日常对接人？我们能和他们聊聊吗？还有一点，我建议不要搞大规模的 RFP（招标方案征集）过程。作为一家机构，我们其实不参加 RFP。我做过两次，都后悔了，因为投入的工作量与产生的价值不成正比。你是在要求一个团队为你做大量的免费工作，通常我认为最优秀的公关人不会这样做，所以如果你要求做大量免费的前期工作，你可能会把一些最优秀的人才排除在外。这些就是一些考虑因素。

---

### [01:22:06] Lenny

**English:**
Perfect. And then just two more questions, because I imagine this is what people are thinking about when they're trying to decide should we find somebody is how long ahead of time they should find someone before something big is happening? And then just what's a budget they should have in mind for something like this? What's a minimum or a range, whatever you think would be helpful for people to understand here's how much you're probably going to be investing here?

**中文翻译:**
太完美了。还有最后两个问题，因为我想当人们决定是否找人帮忙时，会考虑：在重大事件发生前多久应该找好人？以及这类事情的预算大概是多少？最低限额或范围是多少？你认为有什么信息能帮助人们理解大概需要投入多少资金？

---

### [01:22:27] Emilie Gerber

**English:**
Start times can vary from agency to agency. I think we can get started the week that a client needs us to, so maybe I'm not best equipped to answer this, but I would say before an announcement happens, you probably want to kick off six weeks in advance. So when we start with the company, it's like we're working on the blog, we're doing a media training, we're doing the media outreach, we're getting quotes from investors, or coordinating with all the parties, making sure images are being created so it's not just pitching and securing the article. So I would say buffer with time to pitch, make sure that the reporter is actually able to cover it. Six weeks is ideal. I would also note I highly recommend not having a firm date that you think you need to announce something and going instead with when a reporter is able to cover your story.

**中文翻译:**
启动时间因机构而异。我想我们可以在客户需要的当周就开始，所以我可能不是回答这个问题的最佳人选，但我会说，在公告发布之前，你可能需要提前六周启动。当我们开始与一家公司合作时，我们要写博客、做媒体培训、进行媒体外联、获取投资者的引言、与各方协调、确保制作好图片，所以不仅仅是推介和锁定文章。所以我建议留出推介的缓冲时间，确保记者确实有档期报道。六周是理想的。我还想提醒一点，我强烈建议不要设定一个死板的发布日期，而是根据记者什么时候能报道你的故事来定。

---

### [01:23:12] Emilie Gerber

**English:**
We get so many clients that come to us and they have this set date in their head, but there's not usually a real reason for it. It's like they're planning around it, it's like they have other comms they want to go out that day, but if you can optimize for the reporter over the timing, you're going to see such a better outcome because getting the first choice reporter is going to drive way more for your business than announcing it four days sooner. So leaving a little bit of flexibility for that agency is key. And I've even seen companies like issue a press release for big news with no coverage because they had stuck to a certain day and were very rigid about it, and they didn't get any stories for that reason. And so I think a good agency would counsel to offer that flexibility.

**中文翻译:**
我们有很多客户来找我们时，脑子里已经定死了一个日期，但通常并没有真正的理由。就像他们是围绕这个日期做计划，或者那天还有其他传播内容要发布。但如果你能优先考虑记者而不是时机，你会看到好得多的结果。因为争取到首选记者的报道对你业务的推动作用，远比提前四天发布要大得多。所以，给公关机构留一点灵活性是关键。我甚至见过有的公司发布了重大新闻的新闻稿，却没有任何媒体报道，就是因为他们死守某个日期，非常僵化，结果因此没得到任何故事报道。所以我认为一个好的机构会建议提供这种灵活性。

---

### [01:23:54] Emilie Gerber

**English:**
So six weeks I think is the ideal amount of time. And then budget, I would say the lowest end would probably be about 10K a month for an agency. You can find consultants, I think the best ones would be at least 8K a month, but for a small boutique agency starts at 10. I'll just be transparent, I'm very open about our pricing, our rates start at 15K a month for our retainers, and actually that's for a series A companies generally what they're at. And then I would say unless you are a global business that needs basically different teams for different product lines, which happens when you're a Microsoft of the world, that's another story. But if you're just a series C startup that's getting a lot of attention, I wouldn't go beyond 30K probably. There are plenty of agencies that go into the 50s and 60s a month, but that's just a whole nother world, and I'm not an expert on that part.

**中文翻译:**
所以我觉得六周是理想的时间。至于预算，我会说公关代理机构的最低门槛大概是每月 1 万美元。你可以找顾问，我想最优秀的顾问每月至少要 8000 美元，但对于小型精品机构，起步价是 1 万。我就透明一点，我对我们的定价非常公开，我们的月费（retainers）起步价是 1.5 万美元，这通常是 A 轮公司的水平。然后我会说，除非你是一家全球性企业，需要为不同的产品线配备不同的团队（比如微软那种规模），那是另一回事。但如果你只是一家备受关注的 C 轮初创公司，我可能不会超过每月 3 万美元。有很多机构每月收费 5、6 万美元，但那是另一个世界了，我不是那方面的专家。

---

### [01:24:56] Lenny

**English:**
Amazing. Thank you for sharing all that. What if you're going for just a one-off, just help me get one story, what's a range there for budget you should expect?

**中文翻译:**
太棒了。谢谢你分享这些。如果是为了单次合作（one-off），比如只帮我争取一个报道，预算范围大概是多少？

---

### [01:25:04] Emilie Gerber

**English:**
I would say between 10 and 20. And you might be able to find a consultant that'll do it for eight.

**中文翻译:**
我会说在 1 万到 2 万美元之间。你也许能找到一个愿意收 8000 美元的顾问。

---

### [01:25:12] Lenny

**English:**
Amazing. So helpful. Emilie, is there anything else you want to share before we get to our very exciting lightning round?

**中文翻译:**
太棒了。非常有帮助。Emilie，在进入我们非常令人兴奋的闪电轮之前，你还有什么想分享的吗？

---

### [01:25:19] Emilie Gerber

**English:**
No. I'm ready.

**中文翻译:**
没有了。我准备好了。

---

### [01:25:20] Lenny

**English:**
Well, welcome to our very exciting lightning round. I've got six questions. Are you ready?

**中文翻译:**
好，欢迎来到我们非常令人兴奋的闪电轮。我有六个问题。准备好了吗？

---

### [01:25:25] Emilie Gerber

**English:**
I am.

**中文翻译:**
准备好了。

---

### [01:25:26] Lenny

**English:**
First question, what are two or three books you've recommended most to other people?

**中文翻译:**
第一个问题，你向别人推荐最多的两三本书是什么？

---

### [01:25:32] Emilie Gerber

**English:**
I have one that's very top of mind right now, so it's How to Change Your Mind by Michael Pollan. Actually, I leave tonight for a week long psilocybin retreat.

**中文翻译:**
我脑子里现在最先想到的一本是 Michael Pollan 的《如何改变你的心智》（How to Change Your Mind）。实际上，我今晚就要出发去参加一个为期一周的裸盖菇素（psilocybin，迷幻药成分）静修营。

---

### [01:25:46] Lenny

**English:**
We should have done this... N [inaudible 01:25:48]

**中文翻译:**
我们本该在那之后做这个……（笑）

---

### [01:25:52] Emilie Gerber

**English:**
I know. I would be getting much more philosophical maybe.

**中文翻译:**
我知道。到那时我可能会变得更有哲理。

---

### [01:25:53] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:25:56] Emilie Gerber

**English:**
So very excited, I'm going to Jamaica.

**中文翻译:**
非常兴奋，我要去牙买加。

---

### [01:25:58] Lenny

**English:**
Amazing.

**中文翻译:**
太棒了。

---

### [01:26:00] Emilie Gerber

**English:**
And ever since researching that field, there's the whole concept of changing your neural pathways is just very fascinating to me. And just opening up and shifting perspectives is something that I think will actually help me a lot just even in running a company, being a better leader, I think we're at a stage in our growth right now where we're hiring a lot and there's a lot of pressure and I just want to make sure I'm bringing my best self forward every day. And so I'm really excited about it.

**中文翻译:**
自从研究那个领域以来，“改变神经通路”的整个概念就让我非常着迷。我认为敞开心扉和转变视角实际上会对我管理公司、成为更好的领导者有很大帮助。我觉得我们现在正处于增长阶段，招聘任务重，压力也很大，我只想确保每天都能展现出最好的自己。所以我真的很期待。

---

### [01:26:27] Lenny

**English:**
What an amazing answer. This is going to be part of your set and setting this interview, but hopefully you can get it out of your mind.

**中文翻译:**
多么精彩的回答。这次采访将成为你“心境与环境（set and setting）”的一部分，但希望你能暂时把它抛在脑后。

---

### [01:26:34] Emilie Gerber

**English:**
No, totally. I was nervous. I'm like, "It's actually really great that this is happening and then I can completely unplug after it. And so I think it's actually good timing.

**中文翻译:**
不，完全没问题。我之前还挺紧张的。我想：“这事儿现在发生其实挺好的，之后我就可以彻底断网放松了。”所以我认为时机正好。

---

### [01:26:34] Lenny

**English:**
I'm excited to hear how it goes.

**中文翻译:**
我很期待听到后续。

---

### [01:26:45] Emilie Gerber

**English:**
I'm not a big book recommender. I have ADHD and reading full books is very hard for me, and so I'm just going to leave you with that one. I can do the occasional beach read I'll really focus, but it's not my main format of content consumption.

**中文翻译:**
我不太爱推荐书。我有 ADHD（多动症），读完一整本书对我来说很难，所以我只推荐那一本。偶尔在海滩上读读书我能集中注意力，但那不是我获取内容的主要方式。

---

### [01:27:01] Lenny

**English:**
Amazing. All right, great answer. One's plenty. Do you have a favorite movie or TV show you've really enjoyed?

**中文翻译:**
太棒了。好，很棒的回答。一本就够了。你有没有非常喜欢的电影或电视剧？

---

### [01:27:08] Emilie Gerber

**English:**
My favorite genre is post-apocalyptic, end of the world survival. I need to mention my all time favorite show, because it would be bad not to. So Walking Dead is my comfort TV show, I can watch it when I'm going to sleep at night, but my most recent favorite was Yellowjackets. Are you familiar?

**中文翻译:**
我最喜欢的类型是后末日、世界末日生存类。我必须提到我一直以来最喜欢的剧，否则就太遗憾了。所以《行尸走肉》（Walking Dead）是我的“治愈剧”，我晚上睡觉前都能看。但我最近最喜欢的是《黄蜂》（Yellowjackets）。你熟悉吗？

---

### [01:27:30] Lenny

**English:**
I've seen the poster on my TV, but I've not watched it.

**中文翻译:**
我在电视上看过海报，但没看过。

---

### [01:27:35] Emilie Gerber

**English:**
Nice. I discovered it a little late. I think the second season finished and they're working on the third. But it has plane crash, and it has just shocking moment after shocking moment like cannibalism, very weird stuff. And it's one of those shows that sticks in your mind, which I like where you're thinking about it afterwards. It's kind of creepy.

**中文翻译:**
不错。我发现得有点晚。我想第二季已经播完了，他们正在拍第三季。它有空难，还有接连不断的震惊时刻，比如同类相食，非常诡异的东西。它是那种会留在你脑海里的剧，我喜欢那种看完之后还会思考的感觉。有点毛骨悚然。

---

### [01:27:59] Lenny

**English:**
Wow. I thought you were going for Last of Us, but I now have to watch this show.

**中文翻译:**
哇。我以为你会说《最后生还者》（Last of Us），但我现在必须去看看这部剧了。

---

### [01:28:05] Emilie Gerber

**English:**
No, I watched Last of Us and I didn't feel like it had enough survival elements to it. It was like storytelling in that environment, but it wasn't actually a survival post-apocalyptic show in the way that I was looking for.

**中文翻译:**
不，我看过《最后生还者》，我觉得它的生存元素不够多。它更像是在那个环境下的叙事，而不是我所寻找的那种纯粹的后末日生存剧。

---

### [01:28:17] Lenny

**English:**
Hardcore. Do you have a favorite interview question you like to ask? And you could take this in any direction you want.

**中文翻译:**
硬核。你有没有最喜欢的面试问题？你可以从任何角度回答。

---

### [01:28:25] Emilie Gerber

**English:**
Yeah. I have a new one. We actually just revamped our interview process, so I wanted to make it harder. So my new favorite question is if a client comes to you and they're convinced they have something that's press worthy, like an announcement that they think should be, I don't know, in the Wall Street Journal or something, and you know for a fact that it isn't, what steps do you take? What do you do next? And I like that question because they can handle it, one, from the client relations standpoint, how do you communicate with the client when they say something like that, but it's also a critical thinking and creativity question of how do you take a no and turn it into a yes? How do you take what they're giving you and make it into something interesting? And so I like to dig into that, and they can use a real example if they want, but I also think a lot of our job is pushing back in a way. And so that also shows if they're able and willing to push back.

**中文翻译:**
有的。我有一个新问题。我们最近刚改进了面试流程，我想让它更难一点。我最喜欢的新问题是：如果一个客户来找你，他们坚信自己有一些值得报道的东西，比如他们认为应该上《华尔街日报》之类的公告，而你确切地知道它不值得，你会采取什么步骤？接下来你会怎么做？我喜欢这个问题，因为它可以考察：第一，从客户关系的角度，当客户提出这种要求时你如何沟通；第二，这是一个批判性思维和创造力的问题——你如何把一个“不”变成“是”？你如何把他们给你的东西变成有趣的东西？我喜欢深入探讨这一点，如果他们愿意，可以使用真实的例子。我也认为我们的很多工作在某种程度上是“回绝（pushing back）”。所以这也能展示他们是否能够且愿意回绝客户。

---

### [01:29:17] Lenny

**English:**
I'm so curious to hear people's answer to that. Do you have a favorite product that you recently discovered that you love?

**中文翻译:**
我很想听听人们对这个问题的回答。你最近有没有发现什么非常喜欢的产品？

---

### [01:29:24] Emilie Gerber

**English:**
I was very skeptical of Apple Vision Pro and I was making fun of it at the beginning, and the first time I tried it, I completely changed my tune, I'm so into it, I'm ordering one, and I'm very excited for actually using it for work. I think it could be a really good use case for just my day-to-day at work. After I had tried it, the next day I messaged a bunch of clients that I thought could have relevant applications for it. I'm like, "Do we have an Apple Vision Pro strategy? Are we billing to talk about it publicly yet?" Because sometimes it's tying back to the PR conversation, I love if you're willing to push the envelope on stuff that you are building or are going to do and getting ahead of those conversations, so that's a lot of conversations I'm having right now is trying to convince clients to talk about that.

**中文翻译:**
我最初对 Apple Vision Pro 非常怀疑，甚至嘲笑它。但当我第一次尝试它时，我完全改变了看法。我非常喜欢它，正准备订购一个，而且我很兴奋能把它用于工作。我觉得它在我日常工作中会是一个非常好的用例。在我尝试过之后，第二天我就给一堆我认为可能有相关应用的客户发了消息。我问：“我们有 Apple Vision Pro 策略吗？我们准备好公开谈论它了吗？”因为有时这会回到公关话题：我喜欢你愿意在正在构建或将要做的东西上突破极限，并走在这些对话的前面。所以我现在正在进行很多对话，试图说服客户谈论这个。

---

### [01:30:10] Lenny

**English:**
So you have an Apple Vision Pro strategy, amazing.

**中文翻译:**
所以你有一个 Apple Vision Pro 策略，太棒了。

---

### [01:30:13] Emilie Gerber

**English:**
And then my other one, which is very self-serving, because they are a client, but I do use them every day, is Perplexity. I find it so helpful even just for like I'm working on an award submission, I forgot how much funding a client has raised, asking them that instead of opening five different Google links and trying to find the answer, it's just huge for quick information. Or writing a bio for an executive, getting just the TLDR of what they've done in their past, it's so good for PR use cases, and I actually think marketing and PR is going to be one of the core work applications for them.

**中文翻译:**
另一个例子有点私心，因为他们是我的客户，但我确实每天都在用，那就是 Perplexity。我觉得它非常有帮助，哪怕只是当我写奖项申请时，忘记了客户融了多少钱，直接问它，而不是打开五个不同的 Google 链接去找答案，这对于快速获取信息来说太重要了。或者为高管写简介，快速获取他们过去经历的摘要（TLDR），这非常适合公关场景。我实际上认为营销和公关将是他们的核心工作应用领域之一。

---

### [01:30:52] Lenny

**English:**
I've also already shared how much I love Perplexity, I have the Chrome extension installed. I probably use it at least once a day for podcast interview prep along with a bunch of other stuff. So good find for customer. I think they're going to do great. Wish I was an investor.

**中文翻译:**
我也分享过我有多喜欢 Perplexity，我安装了 Chrome 扩展程序。我大概每天至少用它一次来准备播客采访，还有很多其他事情。真是个很棒的客户。我觉得他们会做得很好。真希望我是他们的投资者。

---

### [01:31:07] Emilie Gerber

**English:**
I'm the happy investor. I rarely angel invest and I was...

**中文翻译:**
我就是那个快乐的投资者。我很少做天使投资，但我当时……

---

### [01:31:12] Lenny

**English:**
Drinks on Emilie someday.

**中文翻译:**
哪天得让 Emilie 请喝酒。

---

### [01:31:15] Emilie Gerber

**English:**
There we go.

**中文翻译:**
没问题。

---

### [01:31:16] Lenny

**English:**
That's awesome. Good job.

**中文翻译:**
太棒了。干得好。

---

### [01:31:18] Emilie Gerber

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:31:18] Lenny

**English:**
Okay, two more questions. Do you have a favorite life motto that you often come back to, share with friends or family, either in work or in life?

**中文翻译:**
好，最后两个问题。你有没有最喜欢的人生格言，经常会想起，或者与亲友分享，无论是在工作还是生活中？

---

### [01:31:26] Emilie Gerber

**English:**
Strong opinions loosely held, I'm a very opinionated trust my gut kind of person, but that doesn't mean I'm not willing to change my mind on things and be wrong. I first heard it from an influencer [inaudible 01:31:38] and then I Googled it, and apparently... What was it? Jeff Bezos also said it at one point, so I have no idea the origin of the quote, but I think that's a good one. You can still be really opinionated in life, but that doesn't mean you always are going to be right.

**中文翻译:**
“强烈的观点，松散的持有（Strong opinions loosely held）”。我是一个非常有主见、相信直觉的人，但这并不意味着我不愿意改变主意或承认错误。我最早是从一位网红那里听到的，然后我 Google 了一下，显然……好像杰夫·贝佐斯也说过。所以我不知道这句话的出处，但我认为这是一句格言。在生活中你仍然可以非常有主见，但这并不意味着你永远是对的。

---

### [01:31:52] Lenny

**English:**
Emilie, this was everything I hoped it would be. I feel like this is going to help so many people get awesome press. Thank you again so much for being here. Two final questions. Where can folks find you and reach out if they want to learn more or work with you? And how can listeners be useful to you?

**中文翻译:**
Emilie，这次访谈完全达到了我的预期。我觉得这会帮助很多人获得出色的媒体报道。再次感谢你能来。最后两个问题：如果人们想了解更多或与你合作，可以在哪里找到你并联系你？听众能为你提供什么帮助？

---

### [01:32:06] Emilie Gerber

**English:**
Our website is sixeastern.com and our email is hello@sixeastern.com, so you can find us there. And actually I have a newsletter called On Background. It's on Substack. And really what it's intended to be is a place for people to find these tactical opportunities, so it has media moves, it has reporters that are working on stories, it has awards that are open, all of this stuff that basically an intern in an agency would spend their days researching we put into a newsletter. And so its main audience is PR people, but I actually think it could be a great resource for people within companies that don't have PR teams to stay on top of stuff. So I guess to be helpful, feel free to subscribe. And then other than that, we're hiring, so if you happen to be a PR person that got this far in the episode, always looking for great people to bring on.

**中文翻译:**
我们的网站是 sixeastern.com，邮箱是 hello@sixeastern.com。实际上我有一个名为《On Background》的时事通讯，在 Substack 上。它的初衷是让人们找到这些实操机会，包括媒体动态、正在写故事的记者、开放申请的奖项等等。基本上，公关公司实习生整天研究的东西，我们都放进了这个时事通讯里。它的主要受众是公关人员，但我认为对于那些没有公关团队的公司内部人员来说，这也是一个了解动态的好资源。所以，如果想帮忙，欢迎订阅。除此之外，我们正在招聘，如果你恰好是一位听到这里的公关人，我们一直在寻找优秀的人才加入。

---

### [01:32:57] Lenny

**English:**
Amazing. Is there anything specific you're looking for in people you're hiring for people that may want to reach out other than they've been in PR?

**中文翻译:**
太棒了。除了有公关经验外，你对想联系你的应聘者有什么具体要求吗？

---

### [01:33:02] Emilie Gerber

**English:**
Ideally some B2B experience. I think doing B2B PR is very different from doing consumer PR. If you work with startups, that's a huge plus, you know how to be kind of scrappy and fast. And also people that just love to be really hands-on and doing the actual work. We're very flat, so we're not a place where there's much managing of teams. So it's really much more like a consultancy than anything else.

**中文翻译:**
理想情况下要有 B2B 经验。我认为做 B2B 公关与做消费类公关非常不同。如果你有与初创公司合作的经验，那是一个巨大的加分项，因为你知道如何灵活且快速地行动。还有就是那些热爱亲自动手、做实际工作的人。我们的组织非常扁平，所以我们这里没有太多的团队管理工作。它其实更像是一家咨询公司。

---

### [01:33:24] Lenny

**English:**
Amazing. Emilie, thank you so much for being here.

**中文翻译:**
太棒了。Emilie，非常感谢你能来。

---

### [01:33:27] Emilie Gerber

**English:**
Yeah, it was so fun. Thank you so much.

**中文翻译:**
是的，非常有趣。非常感谢。

---

### [01:33:29] Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。