# Eoghan McCabe - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Eoghan McCabe.

---

### [00:00:00] Eoghan McCabe

**English:**
You don't have a choice. AI is going to disrupt in the most aggressive violent ways. If you're not in it, you're about to get kicked out of all of it.

**中文翻译:**
你别无选择。AI 将以最激进、甚至可以说是粗暴的方式颠覆现状。如果你不参与其中，你很快就会被彻底踢出局。

---

### [00:00:08] Lenny Rachitsky

**English:**
You have very successfully shifted late stage SaaS business to an AI-first agent-based business.

**中文翻译:**
你非常成功地将一家处于成熟期（late stage）的 SaaS 企业转型为一家以 AI 为先、以智能体（agent-based）为核心的企业。

---

### [00:00:15] Eoghan McCabe

**English:**
Fin is our AI agent who will pass 100 million ARR with Fin in less than three quarters.

**中文翻译:**
Fin 是我们的 AI 智能体，它将在不到三个季度的时间里，为我们带来超过 1 亿美元的年度经常性收入（ARR）。

---

### [00:00:20] Lenny Rachitsky

**English:**
Let's talk about how you made this actually happen.

**中文翻译:**
让我们聊聊你是如何让这一切真正发生的。

---

### [00:00:22] Eoghan McCabe

**English:**
We were about to hit $0 net new ARR, which means we would've been in negative growth territory.

**中文翻译:**
当时我们的净新增 ARR（net new ARR）即将归零，这意味着我们本快要进入负增长区间了。

---

### [00:00:28] Lenny Rachitsky

**English:**
So, ChatGPT launches. Was it just like this is it, we got to go all in on this thing?

**中文翻译:**
所以，当 ChatGPT 发布时，你是不是立刻觉得“就是它了，我们必须全力以赴”？

---

### [00:00:33] Eoghan McCabe

**English:**
I said, we need to become a wartime company. If we don't fight for this, we are dead. I jumped hard on AI, but I also restarted the culture. I rewrote the values designed to be a sharp knife to cut out the parts of the company that I just knew wouldn't be effective.

**中文翻译:**
我说，我们需要成为一家“战时公司”。如果我们不为此而战，我们就死定了。我全力投入 AI，但同时也重启了公司文化。我重写了价值观，将其设计成一把快刀，用来切除公司中那些我知道不再有效的腐朽部分。

---

### [00:00:48] Lenny Rachitsky

**English:**
If you're trying to make the shift and it's just not moving, you may need to go hardcore founder mode.

**中文翻译:**
如果你正尝试转型却推不动，你可能需要进入硬核的“创始人模式”（founder mode）。

---

### [00:00:52] Eoghan McCabe

**English:**
The way that greatness is created is that you find a CEO who's willing to make brave hard decisions and own the results.

**中文翻译:**
创造伟大的方式是：找到一位愿意做出勇敢且艰难的决定，并对结果负责的 CEO。

---

### [00:00:59] Lenny Rachitsky

**English:**
What percentage of the employees kind of turned over during this period?

**中文翻译:**
在那段时期，员工的流失率大概是多少？

---

### [00:01:02] Eoghan McCabe

**English:**
Ultimately like 40%.

**中文翻译:**
最终大约是 40%。

---

### [00:01:04] Lenny Rachitsky

**English:**
You said there was a soft coup. Is there more you could share about that?

**中文翻译:**
你提到曾发生过一场“软政变”。关于这一点，你能分享更多细节吗？

---

### [00:01:09] Lenny Rachitsky

**English:**
Today my guest is Eoghan McCabe. This is the first in a series of conversations that I'm having with founders who have successfully transformed their established SaaS or marketplace businesses into an AI first company that is growing like crazy and overtaking their decade plus old business. So, many companies and product teams and founders are trying to navigate this very tricky time where every industry is being disrupted by AI, and my goal here is to help you essentially disrupt yourself before somebody else does. The story of Intercom's transformation into Fin is incredible. Their traditional business was valued at billions of dollars, was making hundreds of millions of dollars in ARR, but growth started to plateau and was even about to go negative. Six weeks after GPT-3.5 Came out, they had a working prototype of what is now Fin and Eoghan and the team decided to go all in on AI.

**中文翻译:**
今天的嘉宾是 Eoghan McCabe。这是我与一系列创始人的对话中的第一场，这些创始人都成功地将他们成熟的 SaaS 或平台业务转型为 AI 优先的公司，且增长极其迅猛，甚至超越了他们经营了十多年的老业务。现在，许多公司、产品团队和创始人都试图在这个棘手的时期寻找方向，因为每个行业都在被 AI 颠覆。我的目标是帮助你在别人颠覆你之前，先完成“自我颠覆”。Intercom 转型为 Fin 的故事非常不可思议。他们的传统业务估值数十亿美元，ARR 高达数亿，但增长开始陷入停滞，甚至即将转负。在 GPT-3.5 发布六周后，他们就拿出了现在 Fin 的原型，Eoghan 和团队决定全线押注 AI。

---

### [00:01:57] Lenny Rachitsky (Continued)

**English:**
Today Fin is growing like crazy already at eight digits in ARR and Intercom is on track to be growing faster than every public software company by next year. In our conversation, Eoghan gets very real and honest about what it takes to win right now. What do you have to do to turn the ship around at Intercom in spite of a lot of pushback and even a soft coup attempt, what he believes people still don't understand about what is happening in software and AI and so much more. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a year free of a bunch of incredible products including Lovable, Replit, Bolt n8n, Linear, Superhuman Descript, Whisper Flow, Gamma Perplexity, Warp, Granola, Magic Patterns, Raycast, and Mobbin. Check it out at lennysnewsletter.com and click bundle. With that, I bring you Eoghan McCabe.

**中文翻译:**
如今，Fin 的增长势头惊人，ARR 已达八位数，Intercom 有望在明年成为增长最快的上市软件公司。在我们的对话中，Eoghan 非常真实、坦诚地分享了当下获胜所需的条件。为了扭转 Intercom 的局面，尽管面临重重阻力甚至是一场“软政变”企图，他必须做些什么；以及他认为人们对于软件和 AI 领域正在发生的事情还有哪些误解。如果你喜欢这个播客，别忘了在应用或 YouTube 上订阅。此外，如果你成为我时事通讯的年度订阅者，你可以免费获得一年的一系列优秀产品，包括 Lovable, Replit, Bolt n8n, Linear, Superhuman 等。请访问 lennysnewsletter.com 查看。下面，让我们欢迎 Eoghan McCabe。

---

### [00:02:48] Lenny Rachitsky (Sponsorship)

**English:**
This episode is brought to you by Great Question the all-in-one UX research platform. Loved by teams at Brex, Canva, Intuit and more. One of the most common things I hear from PMs and founders that I talked to is I know I should be speaking to customers more, but I just don't have the time or the tools. That's exactly the gap Great Question fills. Great Question makes it easy for anyone on your team, not just researchers, to recruit participants, run interviews, send surveys, test prototypes, and then share it all with powerful video clips. It's everything you need to put your customers at the center of your product decisions. With a prompt as simple as why did users choose us over competitors, Great question not only reveals what your customers have already shared, but it also makes it incredibly easy to ask them in the moment for fresh insights from the right segment. Picture this, your roadmap's clear, your team's aligned, you're shipping with confidence and you're building exactly what your customers need. Head to greatquestion.com/lenny to get started.

**中文翻译:**
本集节目由全方位用户体验（UX）研究平台 Great Question 赞助。Brex、Canva、Intuit 等团队都在使用它。我从 PM 和创始人那里听到的最常见的话之一是：“我知道我应该多和客户交流，但我就是没有时间或工具。”这正是 Great Question 填补的空白。它让团队中的任何人（不仅仅是研究员）都能轻松招募参与者、进行访谈、发送调查、测试原型，并分享视频片段。它能帮助你将客户置于产品决策的核心。只需输入简单的提示语，如“为什么用户选择我们而不是竞争对手”，Great Question 不仅能展示客户已分享的内容，还能让你轻松获取特定用户群的最新见解。想象一下，你的路线图清晰，团队步调一致，信心十足地交付客户真正需要的产品。请访问 greatquestion.com/lenny 开始使用。

---

### [00:03:44] Lenny Rachitsky (Sponsorship)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know like Vercel, Webflow and Loom. WorkOS also recently acquired Warrant, the fine grain authorization service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube. This enables fast authorization checks at enormous scale while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on, SCIM or user management, you should consider WorkOS. It's a drop-in replacement for Auth0 and supports up to 1 million monthly active users for free. Check it out at workos.com to learn more. That's workos.com.

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，客户迟早会要求 SAML 身份验证和 SCIM 配置等企业级功能。WorkOS 能让你快速、无痛地为应用添加这些功能。他们的 API 易于理解，让你能快速交付并专注于核心功能。如今，包括 Vercel、Webflow 和 Loom 在内的数百家公司都在使用 WorkOS。WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于 Google 为 Google Docs 和 YouTube 设计的 Zanzibar 授权系统，支持大规模的快速授权检查，同时保持灵活性。如果你正考虑构建基于角色的访问控制（RBAC）、单点登录（SSO）或用户管理，WorkOS 是 Auth0 的理想替代方案，且支持多达 100 万月活用户免费使用。访问 workos.com 了解更多。

---

### [00:05:05] Lenny Rachitsky

**English:**
Eoghan, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Eoghan，非常感谢你能来，欢迎来到我们的播客。

---

### [00:05:09] Eoghan McCabe

**English:**
Thank you. Great to be here.

**中文翻译:**
谢谢，很高兴来到这里。

---

### [00:05:10] Lenny Rachitsky

**English:**
You have done something quite extraordinary with Intercom, something that a lot of founders and product teams are trying to do, which is to navigate this very scary disruption that's happening as a result of AI to most businesses. You have very successfully shifted, as you described, a late-stage SaaS business to an AI-first agent-based very successful business. I want to use the time to extract as much as I can out of your journey so that people that are trying to navigate this and having a hard time can have less pain, less suffering and will hopefully get to something that works. To give people a sense of just how well things have gone. Can you share some stats about the current state of the business, how it's going?

**中文翻译:**
你在 Intercom 所做的事情非常了不起，这也是许多创始人和产品团队正试图做的事：应对 AI 给大多数业务带来的可怕冲击。正如你所描述的，你成功地将一家成熟期的 SaaS 企业转型为一家非常成功的、以 AI 为先、以智能体为核心的企业。我想利用这段时间尽可能多地挖掘你的心路历程，让那些正在艰难应对转型的人少走弯路、少受点苦，并最终找到行之有效的方案。为了让大家了解目前进展有多顺利，你能分享一些关于业务现状的数据吗？

---

### [00:05:53] Eoghan McCabe

**English:**
Currently across the business we benchmark ourselves against all public software companies. There's like 120 something B2B software companies. We're like in the 15th percentile for ARR growth, so we're up there. Fin, which is our AI agent, which is the future of the business, the thing that will disrupt the old business. It's growing north of 300%. It took off really fast like all these other AI companies you hear of the first year, it grew from one to 12 million ARR. We're now in solid mid eight digit ARR growth there, we'll pass 100 million ARR with Fin in less than three quarters. And yeah, Fin, we're in the customer experience category with Fin, so it's one of these agents that helps do all your customer work and they all started with service and in that category we are the biggest by customer count, biggest by revenue, best by performance benchmarks. We win all our head-to-heads and our direct competitor bake-offs. We're rated number one on G2, so I think we're doing pretty well. We're doing far better than we imagined at this point.

**中文翻译:**
目前，我们将整个业务与所有上市软件公司进行基准对比。大约有 120 多家 B2B 软件公司，我们的 ARR 增长率排在前 15% 左右，所以表现很出色。Fin 是我们的 AI 智能体，也是业务的未来，是颠覆旧业务的核心。它的增长率超过了 300%。它像你听到的其他 AI 公司一样起飞得非常快，第一年 ARR 就从 100 万增长到 1200 万。现在我们的 ARR 增长稳居八位数中期，Fin 的 ARR 将在不到三个季度内突破 1 亿。Fin 属于客户体验（CX）类别，这种智能体能处理所有的客户工作，通常从服务（Service）开始。在这个类别中，无论是客户数量、收入还是性能基准，我们都是最大的。我们在所有正面交锋和竞品评测中都胜出了。我们在 G2 上排名第一，所以我觉得我们做得相当不错，远超我们现阶段的预期。

---

### [00:07:00] Lenny Rachitsky

**English:**
Okay. This sounds like the dream for a lot of founders, especially ones that are stuck with their existing business that isn't going very far. So, let's get to that. Let's talk about the beginning of this journey. You had a business that was working, people used it, loved it, over 100 million ARR I believe. Talk about just the state of the business at the point roughly when you decided I really need to make a big change and go AI first.

**中文翻译:**
这听起来是很多创始人的梦想，尤其是那些被困在增长乏力的旧业务中的人。那我们切入正题吧，聊聊这段旅程的起点。你当时拥有一项运作良好的业务，用户喜欢它，ARR 我相信超过了 1 亿。请谈谈在你决定必须做出重大改变、转向 AI 优先时，业务大致处于什么状态？

---

### [00:07:23] Eoghan McCabe

**English:**
It was already in the hundreds of millions, Intercom is 14 years and change now. Part of the story is that in 2020 I had been sick for a couple years. The background is I had mold toxins and later I found out that I got a tick bite and that messed me up. And so I left the CEO role in 2020 and a lot of the mistakes I had been making when I was sick got worse. We became what a lot of late stage software companies are today, which is a bit bloated. We lost some energy. Our strategy was diluted and unfocused. We're trying to do all the things for all the people.

**中文翻译:**
当时收入已经是数亿级别了，Intercom 成立至今已有 14 年多。故事的一部分是，在 2020 年之前我已经病了几年。背景是我中了霉菌毒素，后来发现是被蜱虫叮咬了，这把我搞垮了。所以我在 2020 年卸任了 CEO，而我在生病期间犯下的许多错误在之后变得更糟。我们变得像今天许多成熟期软件公司一样，有些臃肿，失去了活力。我们的战略被稀释了，缺乏重点，试图为所有人做所有事。

---

### [00:08:06] Eoghan McCabe (Continued)

**English:**
We didn't know what problems we were already solving and for who, and the result was very slow revenue growth in the low single digit percent and I was away for two years unsatisfied where the business was going. We had this post COVID sugar rush, which a lot of big companies at that stage did in 2021. Everyone's valuation and revenue was through the roof and that hit a lot of problems in a lot of these companies and we had five quarters of success of sequential decline in our net new ARR and we were about to hit $0 net new ARR which means we would've been in negative growth territory. We never got there. I managed to stop it before we got there, but we were falling each quarter and I found that I, despite my wishes to go and have new adventures, still had a lot of pride for this damn thing and didn't want to see it.

**中文翻译:**
我们不知道自己到底在为谁解决什么问题，结果就是收入增长非常缓慢，仅为低个位数。我离开了两年，对业务的发展方向很不满意。2021 年我们经历了“后疫情时代的糖效亢奋期”（sugar rush），当时很多大公司都这样，估值和收入都飞涨，但这掩盖了很多公司的问题。随后我们的净新增 ARR 连续五个季度下滑，眼看就要归零，这意味着我们将进入负增长。虽然我最终在跌到底之前止住了颓势，但当时每个季度都在下滑。我发现，尽管我想去开启新的冒险，但我对这家公司仍有很强的自豪感，不想看着它垮掉。

---

### [00:09:15] Eoghan McCabe (Continued)

**English:**
And in a way that was so different from the way it started, it started with so much hope and optimism like so many companies do, and it was about to fade away. So, that was when I felt like I need to go back and I need to make a change. I went back and one month later ChatGPT was announced, so it would be really neat and tidy to be able to say that the AI transformation came, I knew I couldn't be on the sidelines, I had to save this thing from the coming disruption. Actually, I got whacked across the head by this AI thing, but it also ended up being a gift.

**中文翻译:**
它现在的样子和刚开始时完全不同。刚开始时充满希望和乐观，就像很多公司一样，但现在它却快要消亡了。所以那时我觉得我必须回去，必须做出改变。我回去一个月后，ChatGPT 发布了。如果我说我预见到了 AI 转型，知道不能袖手旁观，必须从即将到来的颠覆中拯救公司，那听起来会很完美。但实际上，我是被 AI 这件事“当头一棒”打醒的，不过它最终成了一份礼物。

---

### [00:09:55] Lenny Rachitsky

**English:**
So, ChatGPT launches, was it just like this is it, we got to go all in on this thing? Was it like, hmm, let's watch this thing? How quickly was it clear that this is the future, this isn't working what we're doing?

**中文翻译:**
所以 ChatGPT 发布后，你是立刻觉得“就是它了，我们要全押”，还是觉得“嗯，再观察看看”？你花了多久才意识到这就是未来，而我们现在的做法行不通？

---

### [00:10:06] Eoghan McCabe

**English:**
We and I were very lucky and that we had an AI group already. We were in the customer communication business, chiefly doing customer service. We were building bots, but they were rudimentary AI. We had a bunch of our own machine learning that did Q&A for customer service, but it required a phenomenal amount of setup and was kind of crappy. But we had a number of AI engineers in the company already, and so when GPT 3.5 came out, they said, this is different and it didn't take long for people to start to imagine that this is going to be pretty disruptive to service. And it started where we imagined that this was going to just wreck everyone selling seats, everyone in the conventional SaaS game.

**中文翻译:**
我和公司都非常幸运，因为我们已经有一个 AI 小组了。我们从事客户沟通业务，主要是客户服务。我们当时也在做机器人，但那是很原始的 AI。我们有一套自己的机器学习系统来处理客服问答，但它需要极其复杂的设置，而且效果挺差的。但公司里已经有一些 AI 工程师了，所以当 GPT-3.5 出来时，他们说：“这个不一样。”没过多久，大家就开始意识到这会对服务行业产生巨大的颠覆。最初我们预感到，这会摧毁所有靠卖席位（selling seats）赚钱的人，摧毁传统 SaaS 游戏里的所有人。

---

### [00:10:52] Eoghan McCabe (Continued)

**English:**
And we believed that was quite possible for some couple years after that moment. But we were only six weeks into the launch of GPT 3.5 when we actually had a beta version of Fin. I got a text from Des, my co-founder, a week or so after the launch of GPT 3.5 and he said, "The AI team have something interesting and they actually think we could make a product out of this." And this was long before there's now no doubt 100 service agents. We had something very early working and part of what we had to our advantage also was that we had this giant base 30,000 paying customers, hundreds of thousands of active users, millions of their users, billions of data points.

**中文翻译:**
在那之后的几年里，我们一直认为那是很有可能的。但在 GPT-3.5 发布仅六周后，我们就拿出了 Fin 的测试版。GPT-3.5 发布一周左右，我收到了联合创始人 Des 的短信，他说：“AI 团队搞出了一些有趣的东西，他们觉得我们可以据此做一个产品。”那是在现在这上百个服务智能体出现之前很久的事。我们很早就有了可运行的东西，我们的优势还在于拥有庞大的基础：3 万名付费客户、数十万活跃用户、数百万终端用户以及数十亿个数据点。

---

### [00:11:42] Eoghan McCabe (Continued)

**English:**
So, we had a lot to play with and so we jumped on it. Now obviously it's fun to tell that once again to the idea of this brave Maverick move, and I won't discount the fact that we were brave, but we were coming from a point of having nothing to lose. So, we certainly are unique. I don't know a single company of our size and age that has pivoted this hard to AI and being as successful as we have been, but we also previously were screwed. We were in a really tough spot, so had no choice. So, I'll take the kudos and credit, but also have a lot of empathy for companies that weren't as in as much trouble as we were, and so try to thread the needle and sustain the old business while adding to it with the new AI stuff.

**中文翻译:**
所以我们有很多可以发挥的空间，于是我们果断投入。现在回过头来把它描述成一次勇敢的、特立独行的行动当然很有趣，我不否认我们很勇敢，但我们当时处于“没什么可失去”的境地。所以我们确实很独特。在同等规模和资历的公司中，我还没见过哪家能像我们这样如此彻底地转向 AI 并取得成功的，但这也是因为我们之前已经陷入了绝境。我们当时处境艰难，别无选择。所以，我接受赞誉，但也非常理解那些处境没那么糟糕的公司，他们试图在维持旧业务的同时加入新的 AI 元素，想要两头兼顾。

---

### [00:12:34] Lenny Rachitsky

**English:**
Something I heard from someone that worked at Intercom, correct me if this is not correct, you've always been very anti-bot in the customer support business because you didn't like how impersonal it was. It just didn't feel like the way you wanted to build a business, and then now that's what you do. Talk about just that transition.

**中文翻译:**
我听一位在 Intercom 工作过的人说（如果不对请纠正我），你以前在客服业务中一直非常反对机器人，因为你觉得它太没有人情味了。那似乎不是你想要的经营方式，但现在你却在做这个。谈谈这个转变吧。

---

### [00:12:50] Eoghan McCabe

**English:**
Yeah, I know it's a fun and ironic twist. Our mission from the early days was make internet business personal. And when I came back and we started to lean into AI, I started to wonder, does that mission make any sense anymore? Now, part of our lean into AI is that we had no choice not only for the business, we needed something new, but also we saw that this is the future and you can't fight the future. You must be part of it. And so okay, fuck, we're going to be part of it. And ultimately, and it's very easy to tell yourself these little stories. So, I'm open to anyone telling me this is bullshit, but when I interrogate myself, my soul and my mind, I don't think it is, when I interrogate my heart and my mind, I don't think it is.

**中文翻译:**
是的，我知道这是一个有趣且讽刺的转折。我们早期的使命是“让互联网业务更具人情味”。当我回来并开始转向 AI 时，我开始怀疑这个使命是否还有意义。我们转向 AI 的部分原因不仅是业务需要新东西，还因为我们看到这就是未来，你无法对抗未来，你必须成为其中的一部分。所以，好吧，去他的，我们要参与其中。最终，虽然编造一些小故事很容易，我也接受别人说这是胡扯，但当我审视自己的灵魂和思想时，我不觉得这是胡扯。

---

### [00:13:43] Eoghan McCabe (Continued)

**English:**
But I'm now of the belief that providing a customer with a highly engaged, instantly available expert, consistent, fast, charismatic, funny, friendly, personal agent available for literally every single customer every minute of the day around the clock is so much more personal than making them wait 2, 3, 4 days for a crappy canned response. And so that's the irony and the magic and the wonder of AI, even if it does make us ask some hard questions of ourselves and think carefully about its impact on humanity, it actually is superior at the things we describe as personal and human, relative to humans themselves. And so that's where I'm at today. Yeah, maybe it's a bunch of fancy post rationalization, but honestly that's really where I stand.

**中文翻译:**
我现在坚信，为客户提供一个高度参与、即时响应、专业、稳定、快速、有魅力、幽默且友好的个性化智能体，全天候为每一位客户服务，这比让他们等上两三天只为了得到一个差劲的自动回复要有人情味得多。这就是 AI 的讽刺、魔力和奇妙之处。尽管它让我们不得不反思一些深刻的问题，思考它对人类的影响，但在我们所描述的“个性化”和“人性化”方面，它实际上比人类本身做得更好。这就是我现在的看法。也许这只是一堆华丽的事后合理化，但坦白说，这就是我的真实想法。

---

### [00:14:59] Lenny Rachitsky

**English:**
I think data has shown people often prefer not to talk to humans just to solve problems that can just be solved. It's a lot of stress to try to figure out how to talk to some support agent that doesn't know anything about what's going on.

**中文翻译:**
我认为数据已经表明，如果问题能被直接解决，人们通常更愿意不和人类交流。试图弄清楚如何与一个对情况一无所知的客服人员沟通，本身就是一种巨大的压力。

---

### [00:15:10] Eoghan McCabe

**English:**
Yes, and the AI is just better. Look at Waymo. So, Waymo doesn't crash. It has 3.5 times less crashes than humans. It doesn't bother you or bug you. I like to chat with an Uber driver as much as the next guy, but not always. It doesn't have hygiene problems. It doesn't take wrong turns. I mean it just doesn't do all these things that really bug people. And it's really interesting to see Uber now offer women the option to call only female drivers, and I guarantee the reason they're doing that is because women love Waymo because they feel safer. AI is so often superior and humans are going to be far better at other things. I'm pro-human, I love humans. I really want humans in the mix for all things in the rest of my life, but when it comes to practical, productive, efficient, and effective value, the glue in between the human parts of our lives, I actually want AI and robotics.

**中文翻译:**
没错，而且 AI 就是更好。看看 Waymo，它不会撞车，事故率比人类低 3.5 倍。它不会打扰你。我也喜欢和 Uber 司机聊天，但并非总是如此。它没有卫生问题，不会走错路。它不会做那些真正让人心烦的事。很有趣的是，Uber 现在允许女性选择仅限女性司机，我敢保证这是因为女性喜欢 Waymo，因为她们觉得更安全。AI 在很多方面都更优越，而人类将在其他事情上表现得更好。我是支持人类的，我爱人类，我希望生活中处处有人类的参与。但在涉及实际、生产力、效率和有效价值时，在连接我们生活各部分的“粘合剂”环节，我其实更想要 AI 和机器人。

---

### [00:16:21] Lenny Rachitsky

**English:**
Before we start talking about how you actually made this transformation a success, one other piece of history is just your pricing strategy historically has been not liked by people. For example, I once had a Twitter poll or a survey on my newsletter just like what products do you pay the most for of all your SaaS products? And Intercom's by far the most. I know people constantly complain about just how unclear it was and how high it was, and now you guys are at the forefront of how to price AI products. So, we're going to get to that, but just talk about the lessons and what happened there with pricing back in the day.

**中文翻译:**
在我们讨论你如何成功实现转型之前，还有一段历史：你们过去的定价策略一直不受欢迎。例如，我曾在 Twitter 或时事通讯上做过调查：“在所有 SaaS 产品中，你为哪个产品付的钱最多？”Intercom 遥遥领先。我知道人们一直在抱怨定价不透明且过高，而现在你们却走在了 AI 产品定价的前沿。我们待会儿会谈到这个，但先请谈谈过去定价方面的教训和发生了什么。

---

### [00:16:53] Eoghan McCabe

**English:**
Yeah, so I want to just validate your survey data. Yes, people abhorred our pricing. It was a meme. There were actual funny popular viral memes on Twitter that were making fun of our pricing. Part of the problem, if not all of the problem, well, there's two problems. One was our strategy, super unfocused. As you said, we're trying to do all the things for all the people, and when you're trying to do all the things for all the people, your efforts to capture all that different types of value are going to necessitate pretty complex pricing. If you're like customer service and you're selling seats and you're doing outbound messaging and you need to charge for messages and you're doing like SD or Messenger on a website and you need to charge for leads, already that's just metrics in every direction.

**中文翻译:**
是的，我想证实你的调查数据。没错，人们非常讨厌我们的定价。它甚至成了一个梗，Twitter 上有很多嘲讽我们定价的病毒式表情包。问题的部分原因（如果不是全部的话）有两个。第一是我们的战略极其不聚焦。正如你所说，我们试图为所有人做所有事，当你这样做时，为了捕捉各种不同的价值，必然会导致极其复杂的定价。如果你既做客服卖席位，又做外发消息按条收费，还做网站上的 Messenger 按线索（leads）收费，那计费指标就已经乱成一团了。

---

### [00:17:49] Eoghan McCabe (Continued)

**English:**
And then if you're trying to sell to many different sizes of customers, you need tiers and gates and it just became a behemoth. So, part of the problem was the unfocused strategy, and then the other part of the problem was an unwillingness to frankly make bold decisions, say no, pick a lane and actually take pain in the short term for the long term. We rolled out this new pricing, and this is even before the Fin pricing you're talking about. When I came back and I said, "Yes, we're going to lose a lot of revenue here." I can't remember how much we wrote down, but we actually have already given away something like $50 million in ARR.

**中文翻译:**
如果你还想卖给不同规模的客户，就需要分层和门槛，最后定价就变成了一个庞然大物。所以，战略不聚焦是原因之一，另一个原因是由于不愿做出大胆的决定，不愿说“不”，不愿选定一条赛道，也不愿为了长期利益而在短期内承受痛苦。我们推出了新的定价，这甚至是在你提到的 Fin 定价之前。当我回来时，我说：“是的，我们会在收入上损失惨重。”我不记得具体减记了多少，但我们实际上已经放弃了大约 5000 万美元的 ARR。

---

### [00:18:32] Eoghan McCabe (Continued)

**English:**
We've reduced the prices for a lot of customers just to give them way simpler pricing because surprise, surprise, when people feel like they have far simpler, more predictable, fairer pricing, they'll stick around longer and it creates so much more ease in the company and promotes a healthier relationship with the customer too. When our people saw that we were screwing customers effectively in every direction, it starts to erode the idea that we care about our customers and then they make other customer-unfriendly decisions. And so one of the values I promoted when I came back was that we would be customer-obsessed, and so we had to kill our old pricing and give away a lot of revenue. So, that was the spirit behind the changes. But we can talk about the Fin pricing if you want to also.

**中文翻译:**
我们降低了很多客户的价格，只是为了给他们更简单的定价。因为不出所料，当人们觉得定价更简单、更可预测、更公平时，他们会留存得更久，这让公司内部更轻松，也促进了更健康的客户关系。当我们的员工看到我们在各个方面都在“坑”客户时，他们就会开始怀疑我们是否真的关心客户，进而做出其他对客户不友好的决定。所以我回来后推崇的价值观之一就是“痴迷客户”，因此我们必须废除旧定价，放弃大量收入。这就是变革背后的精神。如果你想聊聊 Fin 的定价，我们也可以谈谈。

---

### [00:19:22] Lenny Rachitsky

**English:**
Let's save that because that's a really important topic that I think people need to hear. Let's talk about the shift and how you made this actually happen. You make it sound like, oh, not fully, but it's oh, we have to do, it wasn't working anyway. There's no risk to go all in on this AI thing. You're making $150 million a year ARR, you're worth at least a billion dollars at that point as a business. Yeah.

**中文翻译:**
我们先把那个留着，因为那是一个非常重要的话题。让我们谈谈转型以及你是如何实现的。你听起来好像觉得“反正旧的也不行了，全押 AI 也没什么风险”。但当时你们每年的 ARR 有 1.5 亿，公司估值至少也有 10 亿。

---

### [00:19:45] Eoghan McCabe

**English:**
I mean multiple billions.

**中文翻译:**
我是说几十亿。

---

### [00:19:46] Lenny Rachitsky

**English:**
Multiple billions.

**中文翻译:**
几十亿。

---

### [00:19:47] Eoghan McCabe

**English:**
We were making more money than that, so we were like multiple hundreds of millions.

**中文翻译:**
我们赚的比那还多，当时已经是数亿美元的规模了。

---

### [00:19:50] Lenny Rachitsky

**English:**
Yeah, okay. Very difficult to actually do even if things don't feel like they're growing anymore. So, first of all, just what was the moment, if there was one, of just like, okay, the six-week experiment of someone building a Fin internally, was that being like, this is it, or was there another moment of like, let's go all in on this?

**中文翻译:**
是的，好吧。即使业务不再增长，要做出这种决定也非常困难。所以，首先，有没有一个特定的时刻，比如那个六周的 Fin 内部实验，让你觉得“就是它了”，还是有另一个时刻让你决定全线押注？

---

### [00:20:07] Eoghan McCabe

**English:**
It was the combination of the company being older, us all, me and the founders being impatient like, are we going to make something out of this? We went through a time when the company was worth a lot. We're private so we don't have a daily mark to market, but all the other public software companies dropped 80%, 85, 90%. We saw our revenue growth crater. We were used to nice double digits. We were in low single digits. And so part of it was, let's do something here. Another part of it was my own anger and dissatisfaction with how the company was being run and the mistakes that I made myself. I made a lot of compromises as a lot of founders and founding CEOs do to placate employees or do it out fear to bring investors along, following advice in the industry and best practices.

**中文翻译:**
那是多种因素的结合：公司变老了，我和创始人们都变得不耐烦，心想“我们还能搞出名堂吗？”我们经历过公司估值极高的时期。我们是私有公司，所以没有每日市值评估，但当时所有上市软件公司都跌了 80% 到 90%。我们看到收入增长暴跌，从习惯的两位数变成了低个位数。所以一部分原因是“咱们得干点什么”。另一部分原因是我对自己经营公司的方式以及我犯下的错误感到愤怒和不满。像许多创始人和创始 CEO 一样，我为了安抚员工或出于对投资者的恐惧而做出了很多妥协，盲目遵循行业建议和所谓的“最佳实践”。

---

### [00:21:12] Eoghan McCabe (Continued)

**English:**
You betray your intuition in little bits and pieces over the years when the bright spark of your original idea turns into this big, unstoppable, scary corporate beast and a little bit of you dies every single time you go and betray yourself in that way. If you could pick in your mind three or four tech darlings from 10 years ago when you meet the CEO and talk to them privately, very few of them feel outstanding about the state of their culture and the decisions that they make and the way in which they have to work. All of them have betrayed themselves in little ways, and I had left the business, I was super sick, I was burned out frankly from the revenue even having started to slow down before I left.

**中文翻译:**
多年来，当最初的创意火花变成一个庞大、不可阻挡且可怕的企业怪兽时，你会一点点背叛自己的直觉。每次你背叛自己，内心的一部分就会随之死去。如果你回想十年前的三四个科技宠儿，当你私下见到他们的 CEO 时，很少有人会对自己的公司文化、决策或工作方式感到满意。他们都在某些小方面背叛了自己。我当时离开了公司，病得很重，坦白说，在离开前我就因为收入增长放缓而精疲力竭了。

---

### [00:22:05] Eoghan McCabe (Continued)

**English:**
I had been attacked unfairly in the press, just all of me was just fed up and I decided to take a very authoritarian, top-down, aggressive founder-first approach to all the things, and I found that deeply cathartic and that was the thing that led to me in part. The other was just good old-fashioned logic and the other was desperation saying, we're doing the AI thing, the AI thing, exciting and sexy. We need some new energy thing here. The new AI thing makes sense. And also just my intuition says, go for it. And so when people tell these stories, they rewrite history in their minds for the stories to be elegant and also so that they support their own self-aggrandized narratives about their brilliance. Actually, it's a big messy cocktail of things. And anyway, that's my attempt at explaining the cocktail.

**中文翻译:**
我曾在媒体上遭受不公平的攻击，整个人都受够了。于是我决定采取一种非常独裁、自上而下、激进的“创始人优先”的方式来处理所有事情，我发现这让我深感宣泄。这在一定程度上引导了我。另一部分原因是纯粹的逻辑，还有一部分是绝望中的呐喊：“我们要搞 AI，AI 既令人兴奋又性感。我们需要新的活力。”新的 AI 方向是合理的。而且我的直觉告诉我，去做吧。当人们讲述这些故事时，他们往往会在脑海中重写历史，让故事显得优雅，并支持他们关于自己多么英明的叙事。实际上，这是一场混乱的“大杂烩”。总之，这就是我对那段复杂经历的解释。

---

### [00:23:10] Lenny Rachitsky

**English:**
I saw a stat that when you first launched, when you first had this kind of prototype, you were losing money on every transaction that you're charging like a dollar, it cost you $120, something like that.

**中文翻译:**
我看到一个数据，当你最初推出原型时，每一笔交易你都在亏钱。你收 1 美元，但成本却要 1.2 美元，大概是这样。

---

### [00:23:21] Eoghan McCabe

**English:**
That's right. 120 cents. Yeah, yeah.

**中文翻译:**
没错，120 美分。是的。

---

### [00:23:24] Lenny Rachitsky

**English:**
120 cents. Okay. So, there's a lot of vision here if this is going to get to a place where this actually will be great and affordable.

**中文翻译:**
120 美分。好吧。所以这需要极大的远见，才能相信它最终会变得既出色又实惠。

---

### [00:23:33] Eoghan McCabe

**English:**
It's really funny. We charge 99 cents to resolve tickets, customer problems, and we have a higher resolution rate than anyone else, and we are proud of that and we obsess over that. It is the metric by which these agents are assessed, and we wanted our revenue to be 100% aligned with the value that they attained because we had all this scar tissue from pricing prior that felt unfair to customers. So, we said, what's the most fair that we can possibly find? Now, when we did all our research, we found that many SaaS businesses were spending between 20 and $30 per ticket resolved. We were spending 22. Now, consumer businesses, maybe they go down to $5. We were thinking, can we charge $10? That seems fair. It's half price. Can we charge $5? Can we even charge two and a half dollars? But early on we started to sense that people just wouldn't value the digital work as much as the human work, even though the digital work is better, more consistent, always available, makes the customer far happier.

**中文翻译:**
这很有趣。我们每解决一个工单（客户问题）收费 99 美分，我们的解决率比任何人都高，我们为此感到自豪并痴迷于此。这是评估这些智能体的核心指标。我们希望收入与创造的价值 100% 挂钩，因为之前的定价给客户留下了不公平的阴影。所以我们问：最公平的方式是什么？我们的研究发现，许多 SaaS 企业解决一个工单的成本在 20 到 30 美元之间。我们当时是 22 美元。消费类业务可能会降到 5 美元。我们曾想：收 10 美元行吗？这看起来很公平，只有一半价格。收 5 美元？甚至 2.5 美元？但很快我们意识到，人们对“数字劳动力”的价值评估不会像对“人类劳动力”那么高，尽管数字劳动力更好、更稳定、随时在线且让客户更满意。

---

### [00:24:49] Eoghan McCabe (Continued)

**English:**
And so we actually started to lean into a price that we thought would be was the nexus between us earning the most and it being the most palatable. We basically said that if someone is not prepared to pay 99 cent for us to rapidly and elegantly perfectly and excellently solve their customer's problem, we need to wrap this up. We don't have a business here. So, that was where the 99 cent came from. I always believe that that pricing should come from value and not from costs. The cost is our problem. We just had this sense and intuition early on that this thing will get cheaper and it got a lot cheaper. The margin moves around, but we make a margin that makes this more than worth our while, and we know our customers get an excellent deal and are able to deliver to their customers a level of service that they never could before.

**中文翻译:**
所以我们最终选定了一个价格，我们认为那是“我们收益最大化”与“客户最能接受”之间的平衡点。我们基本上认为，如果有人连 99 美分都不愿意付，让我们快速、优雅、完美地解决他们客户的问题，那我们就该收摊了，这生意没法做。这就是 99 美分的由来。我始终相信定价应该基于价值而非成本。成本是我们的问题。我们早期就有直觉，觉得这东西会变便宜，事实也确实如此。利润率会有波动，但目前的利润足以让我们觉得这非常值得，而且我们知道客户得到了极好的交易，能为他们的用户提供前所未有的服务水平。

---

### [00:25:50] Lenny Rachitsky

**English:**
It's a very clear pitch. We just had Madhavan the podcast and the pricing expert, and he has this phrase, beautifully simple pricing is where you want to get to. Also, he's a huge fan of outcome-based pricing, which is what you're describing here, where you pay for an outcome. So, you guys are in the magic quadrant of his pricing advice.

**中文翻译:**
这是一个非常清晰的卖点。我们刚邀请过定价专家 Madhavan，他有一句话：“极简定价（beautifully simple pricing）是你的终极目标。”此外，他非常推崇“基于结果的定价”（outcome-based pricing），这正是你所描述的——为结果付费。所以，你们正处于他定价建议的“魔力象限”中。

---

### [00:26:07] Eoghan McCabe

**English:**
Yes, thank God our pricing wars are over.

**中文翻译:**
是的，谢天谢地，我们的定价战争终于结束了。

---

### [00:26:10] Lenny Rachitsky

**English:**
Finally.

**中文翻译:**
终于。

---

### [00:26:11] Eoghan McCabe

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:26:12] Lenny Rachitsky

**English:**
Okay, so going back to how you actually did this thing. So, basically you described what many people think of now as founder mode, just top down, as you said, the third area, and just here's what we're doing. We're not going to sit around waiting for you to give me ideas. What did you do? What did that look like internally?

**中文翻译:**
好，回到你具体是怎么做的。基本上你描述了现在人们所说的“创始人模式”：自上而下，正如你所说，非常果断。就是“这就是我们要做的，我不会坐等你们给我出主意”。你具体做了什么？公司内部是什么样子的？

---

### [00:26:31] Eoghan McCabe

**English:**
There was a couple of things. One was we were burning a lot of money, so I cut a lot of costs aggressively. Canned a bunch of different projects. We had this big glorious office we were about to fit out and I'm like, we're about to hit negative growth territory, stop it. And a lot of companies were really stuck in the prior world where they just were used to being super successful, rich and wealthy and spent like drunken sailors. So, I stopped all of that, got really frugal in ways I never thought I would. I still haven't touched the interior design of this office. I'm in here, even though I call it the hotel Marriott, I'm sick of it. Anyway, that was one. Another was picked a lane. Strategically we were all over the place and I said, "We're doing service." Zendesk had been acquired a couple years prior.

**中文翻译:**
有几件事。第一，当时我们在大量烧钱，所以我激进地削减了成本，砍掉了一堆项目。我们当时正准备装修一个豪华的大办公室，我说：“我们快要负增长了，停下来。”很多公司还沉浸在过去那种大肆挥霍的日子里。我制止了这一切，变得前所未有的节俭。我至今没动过这间办公室的内饰，虽然我管它叫“万豪酒店风格”且已经看腻了。这是其一。其二是选定赛道。战略上我们当时太分散了，我说：“我们就做服务（Service）。”Zendesk 几年前被收购了。

---

### [00:27:20] Eoghan McCabe (Continued)

**English:**
They were strategically, energetically, culturally dead. They were upsetting customers in the market. There's an opportunity there. We're doing service, forget all the other stuff, even though there was a lot of people in the company saying, well, shit, we still have $80 million of ARR that we're getting from the other thing and we're really good at that, and there's a big opportunity. There's other companies in this space worth billions. It was the type of decision that where I had to practice the professional CEO approach, which is, "Hey folks, what do you all think? Let's take everyone's input. Let's put it all down on a spreadsheet." Everyone had color beside all of the different options that we may take. Let's make a group decision. I said, "Sorry, this is what we're doing." So, I was very dictatorial in that respect. We had no one making decisions, so somebody needed to, even if I had some qualms about the decisions myself, I couldn't predict the future, but someone had to make a call.

**中文翻译:**
他们在战略、活力和文化上都死气沉沉，让市场上的客户很不满。这就是机会。我们只做服务，忘掉其他所有东西。尽管公司里有很多人说：“该死，我们还有 8000 万美元的 ARR 来自其他业务，我们很擅长那个，而且机会很大，其他做这个的公司估值几十亿。”如果按照“职业 CEO”的做法，我会说：“嘿大家，你们怎么看？让我们听取每个人的意见，列个表格。”每个人都会对不同选项发表看法，然后集体决策。但我说：“抱歉，这就是我们要做的。”在那方面我非常独裁。当时没人做决定，所以必须有人站出来，即使我自己对决定也有疑虑，我也无法预知未来，但必须有人拍板。

---

### [00:28:16] Eoghan McCabe (Continued)

**English:**
Obviously as soon as AI came around, I jumped hard on AI and announced that we were going to spend nearly $100 million of our own cash on that. We allocated a lot of capital, but I also restarted the culture. We had just a very comfortable culture as a lot of companies did. There was a lot of focus on social issues and a lot of complaining and dissatisfaction, and I rewrote the values designed to be a sharp knife to cut out the parts of the company that I just knew wouldn't be effective. So, I said that people must be resilient, that we had very high standards, that we'd work incredibly hard, that shareholder value was the most important thing that we'd optimize for. A lot of things that were controversial for this prior crowd. And then I designed these quarterly performance processes where not only would you get a mark or a grade for your performance against your goals that quarter, but you'd also get a score for your behavior against the values.

**中文翻译:**
显然，AI 一出现，我就全力投入，并宣布我们将投入近 1 亿美元的自有资金。我们分配了大量资本，但我也重启了文化。像很多公司一样，我们当时的文化太“舒服”了，过多关注社会议题，充斥着抱怨和不满。我重写了价值观，将其设计成一把快刀。我说：员工必须有韧性，必须有极高的标准，必须极其努力地工作，股东价值是我们优化的最重要目标。这些对当时的那群人来说非常有争议。接着我设计了季度绩效流程，你不仅会根据目标达成情况获得评分，还会根据你的行为是否符合价值观获得评分。

---

### [00:29:10] Eoghan McCabe (Continued)

**English:**
And I hard coded a formula myself, and so I took it out of the manager's hands to say, if people got below a certain mark, respectfully and lovingly, we would say, thank you for your service. We're going to go forward without you. And so you do that just a small number of quarters and you can start to shape an organization that's design and the image of the values you want to create. And obviously there was a lot of pain, a lot of satisfaction. There was attempts at soft coup, there was letters sent to the board, people really unhappy, but on the other side of it, the people left were the most incredible entrepreneurial, brave, inspiring, happy individuals you could possibly imagine. And then you hire in their image. We ran an anonymous employee survey, I think 15 or 16 months after I started aggressively working through the org and rebuilding the org and rebuilding the culture, and we had a 98 to 99% approval of management, leadership and new strategy.

**中文翻译:**
我自己写死了一个公式，把权力从经理手中拿走：如果有人得分低于某个标准，我们会礼貌且充满关怀地说：“感谢你的贡献，我们要分道扬镳了。”只需坚持几个季度，你就能开始按照你想要的价值观重塑组织。显然，这伴随着巨大的痛苦和不满。有人试图发动“软政变”，有人给董事会写信，大家非常不开心。但挺过来之后，留下的人都是你所能想象的最具创业精神、勇敢、令人振奋且快乐的人。然后你再按照他们的样子去招聘。在我开始大刀阔斧重组组织和文化约 15、16 个月后，我们进行了一次匿名员工调查，对管理层、领导力和新战略的支持率达到了 98% 到 99%。

---

### [00:30:19] Eoghan McCabe (Continued)

**English:**
And this is coming from me having the lowest Glassdoor rating for a CEO I had ever seen when I came back. So, I just want to explain that being that deliberate about your culture and upsetting a lot of people is the path through which you can create a culture where people are super happy, super engaged, super aligned, and now we have just this highly performant organization. Yes, we're messy in many ways. So, that was a big part of it too. So, it was kind of strategically picking a lane. Remaking how we go to market, the pricing was a really, really big piece that had a big effect. Betting on AI and then culture. And I kind of buried the AI thing because frankly none of this would matter if we didn't bet on AI. So, the story could all be summed up by saying, when you ask what did I do, it was that we built Fin and that changed everything.

**中文翻译:**
要知道，我刚回来时，我的 Glassdoor CEO 评分是我见过的最低的。所以我想说明，这种对文化的刻意重塑虽然会得罪很多人，但它是创造一个让员工极度快乐、投入且步调一致的文化的必经之路。现在我们拥有一个高效的组织，虽然在很多方面依然很乱。所以，这包括了战略选定赛道、重塑进入市场（GTM）的方式、定价策略（这非常关键）、押注 AI 以及重塑文化。我把 AI 放在最后说，是因为坦白讲，如果我们不押注 AI，其他一切都不重要。所以，如果你问我做了什么，总结起来就是：我们构建了 Fin，它改变了一切。

---

### [00:31:19] Lenny Rachitsky

**English:**
You said that this was very unpopular. I imagine many people were not happy with all the change and how top-down this was, you said there was a soft coup. Is there more you could share about that? I never heard that story.

**中文翻译:**
你说这非常不受欢迎。我能想象很多人对这些改变和自上而下的方式感到不满。你提到有一场“软政变”，能多分享一点吗？我从没听过这个故事。

---

### [00:31:30] Eoghan McCabe

**English:**
When you make that degree of change and you tell people that they're in control like we did in the previous generation of late-stage businesses, there's going to be some friction when you change the rules. And it's my strong belief that great employees and great companies want and are constructed out of a very clear and strong hierarchy where it is the responsibility of the CEO to make brave and hard decisions unilaterally, yes, using their experts as inputs and be responsible for the outcome. If I make decisions that propel the company in the way that thankfully my decisions have, I get rewards and kudos and I get to go back to the board and say, I want a bigger grant. If I don't, I get fired and I should get fired. If my big, brave, unilateral decisions put us in the toilet, then I have to take responsibility for that also.

**中文翻译:**
当你做出如此巨大的改变，而你之前又像那些传统成熟企业一样告诉员工“你们说了算”时，改变规则必然会产生摩擦。我坚信，优秀的员工和伟大的公司需要并构建于清晰且强大的层级制度之上。CEO 的职责就是单方面做出勇敢且艰难的决定（当然要参考专家的意见），并对结果负责。如果我的决定推动了公司发展（幸好我的决定做到了），我会得到奖励和赞誉，可以去找董事会要更多的期权。如果没做到，我就该被解雇。如果我那些大胆的单方面决定把公司搞砸了，我也必须承担责任。

---

### [00:32:30] Eoghan McCabe (Continued)

**English:**
So, that's how in my humble opinion, it should work. And I, for one, don't know of a great company that doesn't work that way. You'll see from time to time, I did this a couple of years ago, people will construct these indexes of the performance of companies that are founder led, and of course this is a self-serving statement, but it's also true. And surprise, surprise, the founder led companies perform substantially better because they have the moral authority and the willingness to take the risks that the professional CEOs don't have the remit for. The professional CEOs are typically told, don't mess things up, and the founders are bored if they're not taking the risk of messing things up from time to time. And so that's in my opinion, what creates greatness and great innovation. But like I said, there will be friction changing a company that's configured for democracy and committee decisions and soft and gentle interactions and communication to be properly founder led and top down.

**中文翻译:**
在我看来，这就是公司运作应有的方式。我不知道有哪家伟大的公司不是这样运作的。你会发现，几年前有人做过研究，对比创始人领导的公司与职业经理人领导的公司的表现。当然，我这么说有点自卖自夸，但事实确实如此：创始人领导的公司表现要好得多，因为他们拥有“道德权威”和承担风险的意愿，而职业 CEO 往往没有这种权限。职业 CEO 通常被告知“别把事情搞砸”，而创始人如果不在某些时候冒着搞砸的风险去尝试，他们会觉得无聊。这就是创造伟大和创新的源泉。但正如我所说，将一个习惯了民主、委员会决策和温和沟通的公司转变为真正的“创始人领导”和“自上而下”模式，必然会有摩擦。

---

### [00:33:32] Lenny Rachitsky

**English:**
So, a big lesson here is if you're trying to make the shift and it's just not moving, there's a lot of resistance. You may need to go hardcore founder mode and make some significant change. What percentage of the employees kind of turned over during this period?

**中文翻译:**
所以这里的一个重要教训是：如果你尝试转型却推不动，阻力很大，你可能需要进入硬核的“创始人模式”并做出重大改变。在那段时期，员工流失率大约是多少？

---

### [00:33:46] Eoghan McCabe

**English:**
Could be something ultimately like 40%. So, it was a big, big turnover over some couple number of years. Often the culture is set by a very small number of people, so it only took a quarter to really start to change the tenor of the conversations that were happening, but to bring in the people that were that new level of ambition and wanted to work as hard as the rest of us and work in a mature and engaged in excited way, that took a little longer time. There's such a thing as product market fit. There's a thing as founder market fit, there's a thing as founder, product market fit. That's how you're doing it right, but there's also such a thing as employee, founder, product market fit. You have to have the right employees for the type of business you're creating, and there are companies that want the need to be more stable and they're going to want the need to hire more stable individuals.

**中文翻译:**
最终大约是 40%。所以那是几年间一次非常大的换血。通常文化是由极少数人决定的，所以只花了一个季度，公司内部谈话的基调就开始改变了。但要招募到那些拥有更高抱负、愿意和我们一样努力工作、且能以成熟、投入和兴奋的状态工作的人，则花了更长的时间。我们常说“产品市场契合度”（PMF），还有“创始人市场契合度”，甚至“创始人-产品-市场契合度”。但还有一种东西叫“员工-创始人-产品-市场契合度”。你必须为你的业务类型找到合适的员工。有些公司需要稳定，他们会雇佣追求稳定的人。

---

### [00:34:48] Eoghan McCabe (Continued)

**English:**
There's going to be companies that want to do the highly collaborative, more democratic thing. I wouldn't invest in them, but there's companies that want to do it. If you're an employee that enjoys that, there are a lot of positions out there. There are big companies like Google that do that. There are startups that hire the crazy, young, wild, messy, early startup people, and that's great for them and the company too. So, it's really all about having the right individuals and when you create that, not only do you create great success, but you just create a lot more happiness and balance and harmony. Ultimately, the employees who wanted a more gentle democratic environment, they're not going to be happy in a company like Intercom or Coinbase or any of these strong organizations. They'll be more happy somewhere else. So, even if it requires a little bit of a loving push out the door, I know that you're actually doing them a favor in the medium to long run.

**中文翻译:**
有些公司喜欢高度协作、更民主的方式。我不会投资这类公司，但确实有公司想这么做。如果你是喜欢这种环境的员工，外面有很多职位。像 Google 这样的大公司就是如此。也有初创公司会雇佣那些疯狂、年轻、野性、混乱的早期创业型人才，这对他们和公司都好。所以关键在于找到合适的人。当你做到这一点时，不仅能获得成功，还能创造更多的快乐、平衡和和谐。最终，那些想要温和民主环境的员工，在 Intercom、Coinbase 或任何强势组织中都不会开心。他们在别处会更快乐。所以，即使需要给他们一点“充满爱意的推动”让他们离职，我知道从长远来看，你其实是在帮他们。

---

### [00:35:49] Lenny Rachitsky

**English:**
I was going to say that a lot of these people will be happier working in a different company.

**中文翻译:**
我正想说，这些人去别的公司工作会更开心。

---

### [00:35:52] Eoghan McCabe

**English:**
Absolutely. Who wants to go to war every day with your organization and in Slack? That's just not fun. That's not good for the nervous system or the soul.

**中文翻译:**
绝对如此。谁想每天在公司里、在 Slack 上跟自己的组织开战？那一点都不好玩，对神经系统和灵魂都有害。

---

### [00:36:02] Lenny Rachitsky

**English:**
Yeah, so this whole period sounds very stressful for you. Did you ever regret coming back and just like, what the hell did I get myself into? What am I doing to myself?

**中文翻译:**
是的，所以那段时期对你来说一定压力巨大。你有没有后悔过回来？有没有想过“我到底把自己卷进了什么麻烦里？我这是在对自己做什么？”

---

### [00:36:12] Eoghan McCabe

**English:**
I never regretted coming back, but I have many moments where I don't enjoy the job. I didn't regret coming back because it was deeply cathartic for me. When a founder runs away from their business, it is the ultimate betrayal of their heart and the dream that they have. Now, it's okay to wrap things up and quit, but when you kind of run away, like I kind of had to because I was sick and burned out and kind of disenchanted, I don't know, it didn't feel good. So, especially when I had done that, having betrayed in a million or a thousand small ways, my intuition, there was something I needed to exercise. So, it has been deeply meaningful in that respect. And then of course, I'm fortunate that it worked out. I get to be on the second most popular podcast in tech. I get to pat myself on the back in front of all these people. Who wouldn't want that?

**中文翻译:**
我从未后悔回来，但我确实有很多时刻并不享受这份工作。我不后悔是因为这对我来说是一种深刻的宣泄。当一个创始人逃离自己的事业时，那是对自己内心和梦想的终极背叛。当然，结束业务并退出是可以的，但如果你是像我那样因为生病、倦怠和幻灭而“逃跑”，那种感觉并不好。尤其是当我意识到自己在无数个小细节上背叛了自己的直觉时，我需要通过某种方式来救赎。所以从这个角度看，回来非常有意义。当然，我很幸运，结果很好。我能参加这个科技界排名第二的播客，在大家面前自我肯定，谁不想这样呢？

---

### [00:37:13] Eoghan McCabe (Continued)

**English:**
That said, the reality is that for particularly people like me who like the adventure and the high agency being unilateral, day-to-day movement where you're trying to make big, wild, bold decisions, the reality is that if you're successful, most of your days will not be that. It'll be reviewing the bonus policy for next year and reviewing the comp proposal for your execs for the next year. It will be showing up for accountability meetings and stepping through the status of different work streams. It'll be rushing from meeting to meeting, having 8, 9, 10 meetings a day. I don't happen to believe that that's a great way to live your life. It'll be trying to get to all the emails you need to get to such that all those people aren't offended and hurt and trying to communicate in the ways with your staff and your team that is empathetic and thoughtful and keeps in mind that they may be having as shit a day as you are.

**中文翻译:**
话虽如此，现实是，对于像我这样喜欢冒险、喜欢高度自主、喜欢做出大胆决策的人来说，如果你成功了，你大部分的日常工作其实并不是这些。大部分时间是在审查明年的奖金政策，审查高管的薪酬方案，参加问责会议，跟进各个工作流的进度。你会从一个会赶往另一个会，一天开 8、9、10 个会。我不认为这是一种很好的生活方式。你还要处理没完没了的邮件，以免得罪人，还要以同理心和体贴的方式与员工沟通，时刻记住他们可能和你一样正经历糟糕的一天。

---

### [00:38:33] Eoghan McCabe (Continued)

**English:**
You're giving me an opportunity to paint story of this maverick led adventure that you might imagine in a comic. I'm for some reason picturing TinTin sail the seas, this swashbuckling adventure. It's not. It's corporate life kind of sucks particularly for people like me. So, I have many of those days, and so the only reason I'm still around is that I have a broader mission that makes it worthwhile for now, but that's why you see so many of our best founders get to a point where they're like, okay, I've had enough corporate fun. So, that's the most authentic answer I could give you. No regrets coming back, but plenty of pain on a day-to-day basis.

**中文翻译:**
你给了我一个机会，让我把这段经历描绘成漫画里那种特立独行的冒险故事。不知为何，我脑海中浮现出丁丁航海探险的画面。但事实并非如此。企业生活其实挺糟糕的，尤其是对我这样的人。我有很多那样的日子，我之所以还留在这里，是因为我有一个更宏大的使命，让目前的付出显得值得。但这就是为什么你会看到很多优秀的创始人在某个时刻会说：“好了，我受够了这种企业游戏的‘乐趣’。”这就是我能给出的最真实的回答：不后悔回来，但日常工作中确实有很多痛苦。

---

### [00:39:22] Lenny Rachitsky (Sponsorship)

**English:**
Today's episode is brought to you by DX, the developer intelligence platform designed by leading researchers. To thrive in the AI era organizations need to adapt quickly, but many organization leaders struggle to answer pressing questions like which tools are working, how are they being used, what's actually driving value? DX provides the data and insights that leaders need to navigate this shift. With DX, companies like Dropbox, Booking.com, Adyen and Intercom get a deep understanding of how AI is providing value to their developers and what impact AI is having on engineering productivity. To learn more, visit DX's website at getdx.com/lenny, that's getdx.com/lenny.

**中文翻译:**
本集节目由 DX 赞助，这是一个由顶尖研究员设计的开发者情报平台。为了在 AI 时代蓬勃发展，组织需要快速适应，但许多领导者难以回答紧迫的问题，如：哪些工具奏效？它们是如何被使用的？什么在真正驱动价值？DX 为领导者提供导航转型所需的数据和见解。通过 DX，Dropbox、Booking.com、Adyen 和 Intercom 等公司能深入了解 AI 如何为开发者提供价值，以及 AI 对工程生产力的影响。欲了解更多信息，请访问 DX 网站 getdx.com/lenny。

---

### [00:40:06] Lenny Rachitsky

**English:**
One of the interesting things about this space of agents, there's all this talk, agents are taking over. It's the future of software. SaaS is going to be replaced with agents. CX is a classic. It just feels like, I imagine looking forward, it was not obvious. Now looking back, it's like obviously this is an amazing place for agents to take over work, but there's always this talk of agents will do everything and all the SaaS software is going to be replaced by agents. Do you have a sense of just how far this disruption will go outside of CX because it's already happening in your businesses?

**中文翻译:**
关于智能体（agents）领域，现在有很多讨论，说智能体正在接管一切，它们是软件的未来，SaaS 将被智能体取代。客户体验（CX）是一个经典案例。回过头看，这显然是智能体接管工作的绝佳领域，但当时可能并不明显。现在总有人说智能体将无所不能，所有 SaaS 软件都会被取代。除了 CX 之外，你觉得这种颠覆会延伸到多远？因为在你的业务中，这已经在发生了。

---

### [00:40:35] Eoghan McCabe

**English:**
The first thing I'll say is that CX is deceptively large given it's hidden behind just two words, two letters. Customer experience really is service success, sales and marketing, in my opinion. It's all engagement with all customers. It's the biggest part by headcount of any business. Any consumer business and any B2B business the biggest organizations are sales, service, success. So, I'll talk about things other than CX in a moment, but I want to emphasize that CX is the majority of business operations. Of course, it'll go beyond CX. Any function that requires a lot repetitive operational mechanical work will be automated, whether it's chasing or collecting or issuing invoices, it could be onboarding or offboarding employees.

**中文翻译:**
首先我想说，CX 这个词虽然只有两个字母，但它涵盖的范围大得惊人。在我看来，客户体验实际上包含了服务、客户成功、销售和营销。它是与所有客户的所有互动。在任何企业中，按人数计算，这都是最大的部分。无论是消费类还是 B2B 业务，最大的部门通常都是销售、服务和客户成功。所以我待会儿会谈谈 CX 之外的事情，但我必须强调，CX 占据了业务运营的绝大部分。当然，它会超越 CX。任何需要大量重复性、操作性、机械性工作的职能都会被自动化，无论是催收、开具发票，还是员工的入职和离职流程。

---

### [00:41:47] Eoghan McCabe (Continued)

**English:**
There are so many repetitive jobs in an organization that it'll start to replace. One of the interesting questions is how much will be generic operations bots, how much will be expert agents? There are expert agents for law and contract review. There will probably be expert agents for accounting, but you'll need the glue in between all of these agents too. But future organizations will be agents everywhere. I've spent quite a bit of time thinking about what does it all look like in the future, and I imagine it as a medley of humans and agents, and I don't think it's obviously going to be humans on the top and the agents all in the IC roles. I think that'll be more of a complex mix where you're going to have people that are like managers and leaders, but they'll be in IC roles, working with agents to configure them for success and monitor and manage their progress, kind of add that oversight and cover for edge cases. And so I think we're going to be surprised in which the way that these organizations go, they'll definitely be smaller, they'll be flatter because of that.

**中文翻译:**
组织中有太多重复性的工作将被取代。一个有趣的问题是：通用运营机器人和专家级智能体各占多少比例？现在已经有了用于法律和合同审查的专家智能体，未来可能还会有会计专家智能体，但你还需要连接这些智能体的“粘合剂”。未来的组织将到处都是智能体。我花了很多时间思考未来会是什么样子，我把它想象成人类和智能体的交响乐。我不认为一定是人类在上层，智能体全在基层（IC 角色）。我认为那会是一种更复杂的混合：有些人虽然是经理或领导者，但他们会处于 IC 角色，与智能体合作，配置它们以取得成功，监控进度，并处理边缘情况（edge cases）。我认为未来组织的演变会让我们大吃一惊，它们肯定会变得更小、更扁平。

---

### [00:43:17] Eoghan McCabe (Continued)

**English:**
I won't be surprised if there are agents at the highest level too. I mean, I've been thinking about how, and we do have a great human chief of staff here, but imagine a future human chief of staff that understands your priorities and actually talks to you and does a check in each day and reaches out to different people and ask for updates and helps organize your priorities and helps you remember who you need to keep accountable. Clearly there's an opportunity for that. And so you can imagine agents in specific roles like customer service in operational roles being glue and in being kind of like co-pilot or assistant roles like that, which I mentioned. But what I think that all brings is just epic levels of efficiency. It's going to be super deflationary. There'll be a lot more competition. AI itself is insanely competitive right now.

**中文翻译:**
如果最高层也出现智能体，我一点也不会感到惊讶。我一直在想，虽然我们现在有一位出色的人类幕僚长（Chief of Staff），但想象一下未来的智能体幕僚长，它了解你的优先级，每天和你沟通，找不同的人要进度更新，帮你梳理优先级，提醒你该对谁进行问责。显然这里有巨大的机会。你可以想象智能体在特定角色（如客服）、运营角色（作为粘合剂）以及我提到的副驾驶或助手角色中发挥作用。我认为这一切将带来史诗级的效率提升。这将是极具通缩效应的。竞争会变得更加激烈，AI 领域本身现在的竞争就已经疯狂到了极点。

---

### [00:44:18] Eoghan McCabe (Continued)

**English:**
It's so intense in a way that was never before that's going to come to all industries when so much of their inner workings becomes automated. And ultimately I think it's going to be great for the consumer. They'll have more options, cheaper options, and I can't but see that be great for the economy, a lot of economic lubricant as it were, and a lot of new movement and activity. And if we were to really go off the reservation, but I'll stop here, that means that we need more humans too. We need population growth to show up for this big growth economically. And yeah, I just see the future as just a beautiful collaboration between humans and agents in every direction.

**中文翻译:**
当各行各业的内部运作都变得自动化时，那种前所未有的激烈竞争将席卷所有行业。最终，我认为这对消费者是有利的，他们将拥有更多、更便宜的选择。我也认为这对经济大有裨益，它就像一种经济润滑剂，能带来大量新的活力。如果我们再想远一点（虽然我先打住），这意味着我们也需要更多的人类，需要人口增长来支撑这种巨大的经济增长。总之，我眼中的未来是人类与智能体在各个方向上的美好协作。

---

### [00:45:02] Lenny Rachitsky

**English:**
I love the optimism. Someone described this once as a society ... What is it? Agentic society where it's us and agents living together.

**中文翻译:**
我喜欢这种乐观态度。有人曾将其描述为……叫什么来着？“智能体社会”（Agentic society），也就是我们和智能体共同生活。

---

### [00:45:11] Eoghan McCabe

**English:**
Right.

**中文翻译:**
没错。

---

### [00:45:12] Lenny Rachitsky

**English:**
This begs the question around just jobs. We had Marc Benioff on the podcast. He's all agent force, agent force, agent force, and asked him just like, what jobs do you think are going away? He's just like, "CX, going away, gone. Sales not going away. We need sales people." Just what's your sense? I know it's like touchy subject. No one ever wants to say jobs are going away, but just what's your sense of where jobs might be disappearing more, most?

**中文翻译:**
这就引出了关于工作的问题。我们曾邀请 Marc Benioff 上节目，他满脑子都是 Agentforce（Salesforce 的智能体平台）。我问他哪些工作会消失，他说：“CX 会消失，彻底消失。但销售不会，我们需要销售人员。”你的感觉呢？我知道这是一个敏感话题，没人愿意说工作会消失，但你觉得哪些领域的工作消失得最快、最多？

---

### [00:45:34] Eoghan McCabe

**English:**
Yeah. Well, I don't find it to be particularly touchy because jobs have always gone away and technology has done a really good job at stealing jobs that we're repetitive, demeaning, dangerous. We have less people losing limbs and dangerous factories or dying and suffocating down mines because of the technology that we now have available to us. People breaking their backs on farms or just doing things that's highly demeaning to the great, beautiful creative potential of each human individual life. So, I won't apologize for competing with or competing for shit work because all the while technology has done that in the past, population has increased. GDP has increased, longevity, crime rates have diminished in the western world, the world that has enjoyed the most technology. So, we have no good reason to not believe that that won't continue. Even while there is difficulty and there has been in the past, no doubt, people who were gainfully employed in dangerous work in mines had to find new work.

**中文翻译:**
我不觉得这特别敏感，因为工作一直在消失。技术在取代那些重复、卑微、危险的工作方面做得非常好。多亏了技术，现在很少有人在危险的工厂里失去肢体，或者在矿井下窒息而死。人们不再需要在农场里累断腰，或者做那些贬低人类创造潜力的工作。所以，我不会为“竞争掉那些烂工作”而道歉。过去技术一直在这么做，而人口、GDP、寿命都在增加，犯罪率在技术最发达的西方世界反而下降了。所以我们没有理由相信这种趋势不会持续。尽管过去确实存在困难，那些在矿井工作的人不得不寻找新工作。

---

### [00:46:47] Eoghan McCabe (Continued)

**English:**
And so I don't take that for granted, but I think that this is part of the long arc of humanity flourishing and getting healthier and happier. What are the types of work that will go away? It's all the demeaning, crappy stuff, and that exists in digital businesses. You ask a human to sit at a keyboard answering the same question day in, day out, and you get to a point where you don't even ask them to answer the question manually. You ask them to click the button that brings up the macro. Like what a horrible use of a human life. I've met thousands of people that have worked at Intercom, a broad range of talents. People who they might not describe themselves as particularly high IQ. Maybe they were suited at that point in their life for this highly repetitive work. You talk to them for two or three minutes, you'll see the bright spark of a beautiful human that if they got to do the right thing, they would light up and bring so much happiness and joy to the world.

**中文翻译:**
我并不认为这是理所当然的，但我认为这是人类繁荣、变得更健康快乐的长河中的一部分。哪些工作会消失？就是那些卑微、糟糕的工作，这在数字业务中也存在。你让一个人坐在键盘前，日复一日地回答同样的问题，甚至最后你都不让他们手动回答，而是让他们点个按钮运行宏命令。这简直是对生命的巨大浪费。我见过成千上万在 Intercom 工作过的人，才华各异。有些人可能觉得自己智商不高，或者在人生的那个阶段适合做重复性工作。但只要你和他们聊上两三分钟，你就能看到一个美丽人类的闪光点。如果他们能做正确的事，他们会发光发热，为世界带来快乐。

---

### [00:48:00] Eoghan McCabe (Continued)

**English:**
And so that's the mission we're all on. I'm not pollyannaish here, like I said, and I'm suggesting that there won't be friction, but for the most part, we're doing good. And to get specific, they will be CX roles and a lot of basic repetitive roles. There is a lot of repetitive stuff in sales, and so you'll do more sales with less people. There are SD or roles qualifying basic questions. You're not going to need as many people in sales organizations. So, I'm a little misaligned with Marc in that respect. But what he's getting at is that what sales people bring to the table is human connection and trust, and that is not about to go away anytime soon. And thank God for that.

**中文翻译:**
这就是我们共同的使命。我并不是盲目乐观，我也承认会有摩擦，但总的来说，我们在做正确的事。具体来说，CX 岗位和大量基础重复性岗位会消失。销售中也有很多重复性工作，所以未来可以用更少的人完成更多的销售。比如处理基础咨询的销售开发（SDR）角色。销售组织将不再需要那么多人。所以在这一点上，我和 Marc 的看法略有分歧。但他想表达的是，销售人员带来的是人类的连接和信任，而这在短期内不会消失。谢天谢地。

---

### [00:48:46] Lenny Rachitsky

**English:**
I had Ben Mann, the co-founder of Anthropic on the podcast recently, and he said that he's like, "Even my job is probably going to go at some point." He was like, "Lenny, your job is going to be replaced by AI at some point." That was pretty compelling. Did not expect him to say that.

**中文翻译:**
我最近采访了 Anthropic 的联合创始人 Ben Mann，他说：“甚至我的工作最终也可能消失。”他还说：“Lenny，你的工作迟早也会被 AI 取代。”这挺有说服力的，我没料到他会这么说。

---

### [00:49:02] Eoghan McCabe

**English:**
Yeah, I don't know. It will in many ways. We're going to have agents in AI to aggregate content and create content, but humans, as much as when it comes to productivity, value, efficiency, efficiency is not the number one thing that we value. If efficiency was the number one thing we value, I'd always buy the cheapest clothes, furniture, computers, even paper for my printer. But I think humans value things like beauty and human stories and human heart and connection. And not only will they still want those and they'll still want a Lenny that has his own story and his own take and opinions and is a little imperfect, but they'll pay more for it. The abundance of AI is going to make automated things worth zero. Just like the value of cheap content on YouTube. Why do people subscribe to some channels and pay more? Why do people pay to rent movies? Because some things have more quality, more beauty, more craft, more art, more humanity. So, I think there'll always be a place for that.

**中文翻译:**
是的，我不知道。在很多方面确实如此。我们将拥有 AI 智能体来聚合和创作内容。但尽管我们追求生产力、价值和效率，效率并不是我们衡量一切的唯一标准。如果效率是第一位的，我永远只会买最便宜的衣服、家具、电脑，甚至打印纸。但我认为人类看重美感、人类的故事、心灵和连接。人们不仅依然需要这些，依然需要一个有自己故事、见解和一点点不完美的 Lenny，而且他们愿意为此支付更高的价格。AI 带来的丰饶会让自动化的东西变得一文不值。就像 YouTube 上的廉价内容一样。为什么人们会订阅某些频道并支付更多费用？为什么人们愿意付费租电影？因为有些东西更有品质、更美、更有工艺感、更有艺术气息、更有人性。所以，我认为这类东西永远有一席之地。

---

### [00:50:33] Lenny Rachitsky

**English:**
Phew. All right. I've got a couple more years at least.

**中文翻译:**
呼，好吧。看来我至少还能再干几年。

---

### [00:50:36] Eoghan McCabe

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:50:38] Lenny Rachitsky

**English:**
Before I move on to a different topic. Just kind of reflecting back on this shift to Fin and the success that you've had, are there any other just lessons that we haven't touched on that you think might be helpful for folks that are trying to go through this journey?

**中文翻译:**
在转入下一个话题之前，回顾一下向 Fin 的转型以及你取得的成功，还有哪些我们没聊到、但你觉得对正在经历这一过程的人有帮助的教训吗？

---

### [00:50:52] Eoghan McCabe

**English:**
I think it's ultimately that you don't have a choice. My co-founder Des is writing a book at the moment, and that's core to the idea here. You don't have a choice. The story of the technology industry or digital technology is really short and it's punctuated by a small number of things, microprocessors, personal computers, the internet, maybe mobile. Now there's AI. I think AI is bigger than all these things. And all of these things disrupted essentially all categories. So, not only is this likely to disrupt all the categories, it's going to disrupt it in the most aggressive violent ways. And if you're not in it, you're about to get kicked out of all of it. And so my strongest advice is roll your sleeves up, figure out what's going to disrupt you, have fun with it. You need to bring in actual talent. We and I will be nothing if we didn't have actual AI scientists and leaders.

**中文翻译:**
我认为归根结底是你别无选择。我的联合创始人 Des 正在写一本书，核心观点就是：你别无选择。科技行业或数字技术的历史很短，由少数几个关键节点组成：微处理器、个人电脑、互联网、移动互联网，现在是 AI。我认为 AI 比之前所有的都大。这些技术颠覆了几乎所有类别。所以，AI 不仅会颠覆所有类别，还会以最激进、最粗暴的方式进行。如果你不参与，你就会被踢出局。所以我最中肯的建议是：卷起袖子，搞清楚什么会颠覆你，并乐在其中。你需要引进真正的天才。如果没有真正的 AI 科学家和领导者，我和公司将一事无成。

---

### [00:51:59] Eoghan McCabe (Continued)

**English:**
It's the only way we can be successful here. We have an incredible person who by the time this is out will have received a promotion to chief AI officer. I keep announcing all these things and that's great confidence to you. Fergal Reid, and he's just one of the very best in AI applications, and we happened to be working with him for many years. So, part of it is finding the talent and part of it is bringing in the young talent too. AI is kind of a young man's game, and I'm young, but I'm not as young as a lot of the kids building AI. And so learning to empower and enable them and learn from them too is a really big deal. And unfortunately, part of what you learn from them is the only way you're going to win right now is if you work your ass off, because all these little AI companies run by kids in their twenties are literally working 12 hours a day, literally 365 days a year.

**中文翻译:**
这是成功的唯一途径。我们有一位了不起的人才，在这个节目播出时，他应该已经升任首席 AI 官（Chief AI Officer）了。我一直在宣布这些消息，这显示了极大的信心。他叫 Fergal Reid，是 AI 应用领域最顶尖的人才之一，我们很幸运已经和他合作多年。所以，一部分是寻找天才，另一部分是引进年轻人才。AI 在某种程度上是年轻人的游戏。虽然我也年轻，但没那些正在构建 AI 的孩子年轻。学会授权、赋能并向他们学习至关重要。不幸的是，你从他们身上学到的一点是：现在获胜的唯一方法就是拼命工作。因为那些由二十多岁年轻人经营的小型 AI 公司，真的是每天工作 12 小时，全年 365 天无休。

---

### [00:53:01] Eoghan McCabe (Continued)

**English:**
No joke, all of them. And that's not a fun idea for many of us, especially those who've grown up. Some people in our generation have kids or a lot of them do. There's comfort and stability in your life. You don't want to work like that, but if you want in, that's part of the price and that's how so many of these young new AI are going to win because very few of the previous generation companies are willing to make all of those changes and go all the way in. And so my actual advice, which is not that helpful, is that if founders of previous generation companies are themselves not willing to roll up their sleeves and get into it and work as hard as the kids, hire a kid. You can be a chairperson like I was, have a lot of fun. You can mentor the kid, hire a kid because you're in the wrong job, buddy.

**中文翻译:**
没开玩笑，他们全是这样。这对我们很多人来说并不是个好主意，尤其是那些已经步入中年的人。我们这一代人很多都有了孩子，生活追求舒适和稳定，不想那样工作。但如果你想入局，这就是代价。这也是为什么这么多年轻的 AI 公司会赢，因为上一代公司很少有人愿意做出这些改变并全力以赴。所以我那不太中听的建议是：如果上一代公司的创始人自己不愿意卷起袖子、像那些孩子一样拼命，那就雇个孩子来干。你可以像我以前那样当董事长，享受生活，指导那个孩子。雇个孩子吧，因为你已经不适合这个岗位了，伙计。

---

### [00:53:58] Lenny Rachitsky

**English:**
I love how pragmatic this advice is and what's interesting as you talk about 12 hours a day every day, it's like we're trying to get close to what agents are doing, which is half, that's basically 50% of agents.

**中文翻译:**
我喜欢这种务实的建议。有趣的是，当你谈到每天工作 12 小时，我们其实是在试图接近智能体的工作强度——那大约是智能体工作量的一半。

---

### [00:54:08] Eoghan McCabe

**English:**
But that's not just a poetic cute thing to say, that comes from something very real, which is these younger companies know how to use AI in ways that the older companies don't. The younger companies are vibe coding and using AI for their creative work and for their job descriptions. I guarantee you go to companies of our generation and even we have had to push people, you go to companies of our generation, most people in most organizations, particularly non-technical organizations, they're not using any AI. Maybe they're starting to use ChatGPT to write a job description, but they're not doing it by default. And so that's more than a joke. You're competing with young companies that are in part AI.

**中文翻译:**
这不仅仅是一个诗意的说法，它源于非常现实的情况：这些年轻公司知道如何以老牌公司不懂的方式使用 AI。年轻公司在用“氛围编程”（vibe coding），用 AI 进行创作和写职位描述。我敢保证，你去我们这一代的公司看看（甚至我们都得推着员工走），大多数组织（尤其是非技术部门）的大多数人根本不用 AI。也许他们开始用 ChatGPT 写职位描述了，但那不是他们的默认工作方式。所以这不只是个玩笑，你是在与一部分由 AI 构成的年轻公司竞争。

---

### [00:55:02] Lenny Rachitsky

**English:**
This reminds me, I did an interview with the Perplexity founders. It was, I just checked, April 2024, so just over a year ago. And they were saying that the way they operated, and this sounded it's so crazy at the time, is anytime they had a question for anyone else on the team, they first asked ChatGPT about it, and then they go ask the person as like, that is insane. And now this is just obvious. That's what we all do now. Just like, hey, I'm just going to talk voice.

**中文翻译:**
这让我想起我采访 Perplexity 创始人的时候。我查了一下，是 2024 年 4 月，也就是一年前。他们说他们的运作方式（当时听起来很疯狂）是：每当对团队成员有疑问时，先问 ChatGPT，然后再去问那个人。当时觉得不可思议，现在看来理所当然。我们现在都这么干，直接语音对话。

---

### [00:55:28] Eoghan McCabe

**English:**
It's a prime example. They're doing many such things. When I say 365 days a year, they're the company I think of because they're doing exactly that. All these young companies are doing wild, weird and ridiculous things that people you are in my age kind of chuckle at, but it's business as usual for them. So, there's just a big mind shift, cultural shift, and there's a culture clash of the previous generation versus the new generation. And the sooner you kind of wrap your head around that, the sooner you can start to unstake yourself, I think.

**中文翻译:**
这是一个绝佳的例子。他们还在做很多类似的事。当我提到“全年 365 天”时，我脑子里想到的就是他们，因为他们确实如此。所有这些年轻公司都在做一些在我们这个年纪的人看来疯狂、古怪甚至荒谬的事，但对他们来说，这就是日常。所以这不仅是思维的转变，更是文化的转变。上一代与新一代之间存在文化冲突。我认为你越早理解这一点，就能越早摆脱束缚。

---

### [00:56:04] Lenny Rachitsky

**English:**
And just to build on that, the sounds crazy to work this hard, it sounds very stressful, not fun. Why would I do this? This sucks. But at the same time, this is, as you said, such an unusual rare opportunity. There's so much opportunity. There's so much wealth being created. There's so many businesses being created. This is the time, if you were to ever work really hard, this is a good time to do it.

**中文翻译:**
补充一点，拼命工作听起来很疯狂、压力很大、一点也不好玩。为什么要这么做？这太糟糕了。但正如你所说，这同时也是一个极其罕见的机会。有太多的机会，太多的财富正在被创造，太多的新业务正在诞生。如果你这辈子打算拼命工作一次，现在就是最好的时机。

---

### [00:56:26] Eoghan McCabe

**English:**
I think so. I don't actually generally promote working that hard. I try to not fetishize it. I actually think a life well-lived includes taking slow walks in nature where you're not thinking about ARR growth or hiring your chief revenue officer, not going to eight meetings a day. Maybe you should go to no meetings a day, certainly not working 12 hours a day. I don't actually promote that in general as a thing one should do with their life. I'm simply saying that if you want to compete and enjoy success in this age, which means you need to be doing AI, that is the price.

**中文翻译:**
我也这么认为。其实我通常不提倡那么拼命工作，我尽量不把它神圣化。我认为美好的生活应该包括在自然中漫步，不去想 ARR 增长或招聘首席营收官，不去开一天八个会。也许你应该一天一个会都不开，当然也不要每天工作 12 小时。我并不认为这是一个人应该对待生活的常态。我只是说，如果你想在这个时代竞争并获得成功（这意味着你必须做 AI），这就是代价。

---

### [00:57:16] Eoghan McCabe (Continued)

**English:**
So, you either decide to pay the price or get out. Don't half-ass it. You see all these companies saying, we do AI and they've just sprinkle a little bit of crappy AI and they've got the same cultures. It won't work. The one thing I will say, the one little asterisk to my first point is that all great people and great things have been achieved through hard work. And so I'm speaking out of both sides of my mouth here, to younger people to let them know that every way of living is valid, but people who have achieved things have always worked hard and they find a way to enjoy it too. And particularly in 2025 in AI.

**中文翻译:**
所以，你要么决定支付这个代价，要么就退出。别敷衍了事。你看到很多公司说“我们在做 AI”，其实只是撒了一点蹩脚的 AI 调料，文化却毫无变化。那是行不通的。不过，我刚才的话要加个注脚：所有伟大的人和伟大的成就都是通过艰苦努力实现的。所以我在这里可能有点自相矛盾：一方面告诉年轻人每种生活方式都有其价值，但另一方面，那些有所成就的人总是很努力，并且他们能找到享受其中的方法。尤其是在 2025 年的 AI 浪潮中。

---

### [00:58:01] Lenny Rachitsky

**English:**
I want to follow this thread. I was going to ask you this earlier, but I didn't, and I want to see if this takes us somewhere interesting, just watching you speak and talk. You're very self-reflective, very centered. You have these really good breaths you take when you think about something. I met you a long time ago, randomly at a party when you were just starting Intercom. I don't think you were like that. During this kind of two-year period was there kind a transformation that you went through to kind of become this?

**中文翻译:**
我想顺着这个话题聊聊。我刚才就想问，看你说话的样子，你非常善于自我反省，非常沉稳。你在思考时会有那种深沉的呼吸。很久以前，在 Intercom 刚起步时，我在一个派对上偶然见过你。我不觉得你当时是这样的。在那两年的离开期间，你是不是经历了一些转变才变成了现在的样子？

---

### [00:58:28] Eoghan McCabe

**English:**
Absolutely. Yeah. There's a couple things. First, I mean, there's three things that come to mind. Working in a startup for 14 years has a certain way of kicking you in the head many times a day that either kills you or makes you far stronger. So, that one piece. There's no elegance to that point, but I think we can all intuit that that level of experience teaches you something, you grow up very fast. Point two is I did a lot of therapy. I found this amazing guy 12 years ago. He started a couple of his own tech companies and talked in public. He only coached and was a therapist to CEOs. He's now kind of in a later stage of his career. But this amazing guy, his name is Yosi Amram, amazing guy. I just landed on my feet. I just didn't know who I was dealing with.

**中文翻译:**
绝对是的。我想到了三件事。第一，在初创公司工作 14 年，每天都会被现实“打脸”很多次，这要么会毁了你，要么会让你变得更强大。这一点并不优雅，但我想大家都能理解，这种经历会让你快速成长。第二点是我做了大量的心理治疗。12 年前我遇到了一位了不起的人，他自己创办过几家科技公司，也做过公开演讲。他只辅导 CEO 并担任他们的治疗师。他现在处于职业生涯后期，他叫 Yosi Amram，真是个奇人。我当时只是运气好碰到了他，甚至不知道自己在和谁打交道。

---

### [00:59:24] Eoghan McCabe (Continued)

**English:**
But one of the greatest minds and teachers of the last, I don't know, many decades, people don't even know him, but he's taught and worked with many CEOs and he just helped me get to know me and take time for myself. And people like to hate on therapy right now. I think a lot of therapy sucks and a lot of therapists are not good. And they fear that actually therapy will lobotomize them and turn them into thumb sucking, navel-gazing, soft, irrelevant losers that won't have that edge anymore. And the interesting thing about 12 years of weekly therapy and spiritual work is that it takes your edges off, but they're all edges that are super counterproductive. All the edges that made you an asshole, got you triggered, miscommunicated or fought back when you were insecure, they take all the edges away then help you see yourself and love yourself so much more for who you are.

**中文翻译:**
他是过去几十年里最伟大的思想家和导师之一，虽然很多人并不认识他。他辅导过很多 CEO，他帮我了解自己，为自己留出空间。现在很多人不喜欢心理治疗，我也认为很多治疗很烂，很多治疗师水平不行。人们担心治疗会让他们变得软弱、自恋、失去斗志。但 12 年每周一次的治疗和精神修行的奇妙之处在于：它磨掉了你的棱角，但那些都是负面的棱角——那些让你变得混蛋、易怒、沟通不畅或因缺乏安全感而反击的棱角。它磨掉这些，然后帮你更好地看清并接纳真实的自己。

---

### [01:00:42] Eoghan McCabe (Continued)

**English:**
Be completely unafraid to acknowledge the things you're not good at, but own the things you are. And in understanding yourself, you understand others better and can communicate in a substantially more connected and authentic way. Great, great therapy and it has to be great, is a recipe for brilliant leadership in my opinion. And then the third part is two years away where I ran away, where I was sick, revenue growth wasn't doing so hot. I unsuccessfully tried to defend myself from a bunch of fake bullshit in the newspapers. I mean I was beat up. And in a moment like that, your ego, any sense you have of your greatness is eviscerated. And that's painful. It can be so painful that many people don't come back from it, and I credit the 10 years at that point, or nine years of therapy I did at that point, plus the support of this therapist, the coach that I had, to surviving it.

**中文翻译:**
让你完全不害怕承认自己的短处，同时也自信地拥抱长处。在了解自己的过程中，你也会更了解他人，并能以更真实、更具连接感的方式进行沟通。在我看来，优秀的心理治疗是卓越领导力的秘诀。第三部分是那两年的离开。当时我病了，收入增长乏力，我还试图反击报纸上的一些虚假指控但失败了。我当时被打垮了。在那种时刻，你的自我（ego）、你对自己伟大的任何幻觉都会被彻底粉碎。这非常痛苦，痛苦到很多人可能再也站不起来。我之所以能挺过来，归功于当时已经坚持了九、十年的治疗，以及那位治疗师兼教练的支持。

---

### [01:01:48] Eoghan McCabe (Continued)

**English:**
But if you can survive it, what you end up with on the other side is all of those insecure, a lot of the insecurities and all that ego bullshit that made you super ineffective, jealous, or triggered for all sorts of different reasons, it's gone. And your image that you are this perfect, brilliant leader that all successful founders form when they are successful had to die. And the reason that's so good is that that's so limiting. When you have this ego identity of yourself about how fucking amazing you are, then any moment that challenges that is super scary. Anyone who questions it is offensive. And so I credit wherever I am today and I have decades of learning still to go to those three components. And I feel super fortunate to have had all of them, even though the last one sucked, I can finally say, wow, it really helped.

**中文翻译:**
但如果你能挺过来，你在另一端收获的是：那些让你变得低效、嫉妒或易怒的不安全感和自我膨胀的废话都消失了。所有成功创始人都会建立的那种“完美、英明领导者”的形象必须死掉。死掉是好事，因为那种形象太有局限性了。当你觉得自己“牛得不行”时，任何挑战这一点的时刻都会让你感到恐惧，任何质疑你的人都会让你觉得被冒犯。所以我将今天的成就归功于这三个因素，尽管我还有几十年的路要学。我觉得非常幸运能经历这一切，虽然最后那段经历很糟糕，但我终于可以说：哇，它真的很有帮助。

---

### [01:02:52] Lenny Rachitsky

**English:**
Thank you for sharing all that. I'm glad I went there. I want to show you something that I randomly have in my office, my wife just got me that I think you're going to love. It's a piece of art that I think will resonate with [inaudible 01:03:02].

**中文翻译:**
感谢你的分享，很高兴我问了这个问题。我想给你看一件我办公室里的艺术品，我妻子刚送给我的，我觉得你会喜欢。它应该会引起你的共鸣。

---

### [01:03:02] Eoghan McCabe

**English:**
Yeah. What am I looking at here? So, it's a hand?

**中文翻译:**
好啊。我看到的是什么？一只手？

---

### [01:03:04] Lenny Rachitsky

**English:**
It's a hand with a snap and then let me see if you can see what it says.

**中文翻译:**
是一只正在打响指的手，看看你能不能看清上面的字。

---

### [01:03:08] Eoghan McCabe

**English:**
I can't see what it says.

**中文翻译:**
看不清。

---

### [01:03:10] Lenny Rachitsky

**English:**
It says ego death now.

**中文翻译:**
上面写着：“现在就让自我消亡”（Ego death now）。

---

### [01:03:12] Eoghan McCabe

**English:**
Right. Look at this. Good. Exactly.

**中文翻译:**
没错，看这个，太棒了，正是如此。

---

### [01:03:15] Lenny Rachitsky

**English:**
There it is.

**中文翻译:**
就是这个。

---

### [01:03:16] Eoghan McCabe

**English:**
May all our egos peacefully become smaller and leave this mortal coil. The reality is none of our egos ever die. And even great ... Ram Dass is this great spiritual teacher who died a few years ago and someone asked him on his deathbed something like, "How did you get over your bullshit or your ego?" And he said, "I never did. Just the edges got smoothed away." And this is a guy who had 70 years of the deepest, wildest spiritual work, he acknowledged, no, still my same self. So, the ego is still there and we actually need to acknowledge it and love it. And when you acknowledge it, then it's not a surprise when you're like a little jealous and you're like, huh, I'm jealous. That's funny. Okay. And it's all good.

**中文翻译:**
愿我们所有的“自我”都能平静地变小，离开这个尘世。现实是，我们的“自我”永远不会真正消失。伟大的精神导师 Ram Dass 几年前去世前，有人问他：“你是如何克服你的那些废话或自我的？”他说：“我从未克服过，只是棱角被磨平了。”这是一个做了 70 年最深刻精神修行的人，他承认自己还是那个老样子。所以“自我”一直都在，我们需要承认并爱护它。当你承认它时，当你感到嫉妒时，你就不会惊讶，你会说：“呵，我嫉妒了，真有意思。”这都没关系。

---

### [01:04:09] Lenny Rachitsky

**English:**
Reminds me Daniel Kahneman who wrote all these books about biases that we have and here's all the ways we're flawed. If people ask him, "Have you learned to live more rationally?" He's like, "Not at all." Knowing all these things about how we're flawed in the way we think all these biases doesn't actually, I can't use it in life.

**中文翻译:**
这让我想起 Daniel Kahneman，他写了很多关于认知偏差和人类缺陷的书。当人们问他：“你学会了更理性地生活吗？”他说：“完全没有。”即便知道我们在思维方式和偏差上的所有缺陷，在现实生活中其实也用不上。

---

### [01:04:24] Eoghan McCabe

**English:**
We're human. We should let ourselves be human. I think it's beautiful. We're logic systems, but we're also heart systems and body systems and soul systems. So, all of it is good.

**中文翻译:**
我们是人类，应该允许自己有人性。我觉得这很美。我们是逻辑系统，但也是心灵、身体和灵魂系统。所以，这一切都很好。

---

### [01:04:35] Lenny Rachitsky

**English:**
Okay, I want to go in a completely different direction. The last thing I want to talk about, I needed to mention this. I don't know if you've seen this, but I've been doing research on which companies produce the best product leaders. And I've been doing this by looking at which alumni of companies go on to become CPOs at the highest rate, get promoted the most at their next job, become the first product manager at a future startup, start their own companies. Intercom is coming number one across this research next to Palantir and Stripe, Revolut. So, the question this begs is, what are you guys doing that produces such great product leaders? There's the hiring piece and then there's what they do at Intercom piece. So, what do you think is creating these sort of really big successes from your alumni group?

**中文翻译:**
好，我想换个完全不同的方向。最后我想聊聊这个，我必须提一下。不知道你有没有看到，我一直在研究哪些公司培养出了最优秀的产品领导者。我通过查看哪些公司的校友成为 CPO 的比例最高、在下一份工作中晋升最快、成为初创公司的首位 PM 或创办了自己的公司。Intercom 在这项研究中排名第一，与 Palantir、Stripe 和 Revolut 并列。所以问题来了：你们到底做了什么，培养出了这么多优秀的产品领导者？是招聘的原因，还是他们在 Intercom 的经历？你认为是什么造就了你们校友群体的巨大成功？

---

### [01:05:20] Eoghan McCabe

**English:**
Yeah, I don't have a really succinct answer unfortunately. I can say in the abstract, our culture is a very producty culture. So, myself and Des, there was four founders and me and Des Traynor drove a lot, like all the strategy. We're product guys. I was a software designer. I studied computer science, so I'm technical, but never did it professionally. So, the first part is that just product innovation, design just was just core to our culture and people always picked up on that. So, I think good people wanted to work here and we were good at finding good people. The other part was that because we had this sprawling strategy, we had all these products that we needed a complex structure for it and that included lots of PMs and PM groups that we gave a lot of autonomy to. And so the product of our big messy strategy was that we had PMs that got to act like mini CEOs.

**中文翻译:**
不幸的是，我没有一个非常简洁的答案。抽象地说，我们的文化是一种非常“产品化”的文化。我和 Des（四位创始人中的两位）主导了大部分战略。我们都是产品出身。我曾是软件设计师，学过计算机科学，虽然没做过职业程序员，但我懂技术。所以第一点是，产品创新和设计是我们文化的核心，大家都能感受到。我认为优秀的人才因此想来这里，而我们也擅长发现他们。另一部分原因是，由于我们战略庞杂，产品众多，我们需要复杂的组织结构，包括许多 PM 和 PM 小组，并给予他们极大的自主权。这种“混乱”战略的产物就是：我们的 PM 能够像“迷你 CEO”一样行事。

---

### [01:06:27] Eoghan McCabe (Continued)

**English:**
And so I think that they got to learn the broader skill sets beyond designing wireframes and interviewing some customers. They really own it like a mini CEO to some degree. I think there's one other thing which is part to our approach was this deeply first principles thinking methodology almost to a fault, although I don't think it's a fault. I and we would create frameworks for everything. It's like, okay, we want to do these events. Who are the events for? What is the ultimate goal of the event? What's the mechanism by which events work? What are other mechanisms that can achieve that same goal? How do we define success for an event like that? How does the user or the attendee define value? What other things do those people find valuable? We create these complex systems to try and approach everything, but the net effect was we'd have really joined up considered strategy and it's everywhere.

**中文翻译:**
因此，他们学到了超越画原型图和访谈客户的更广泛技能。在某种程度上，他们像迷你 CEO 一样真正拥有产品。还有一点是我们的方法论：一种深刻的“第一性原理”思维，甚至到了偏执的地步（虽然我不觉得那是缺点）。我们会为所有事情创建框架。比如办活动：活动是给谁办的？终极目标是什么？运作机制是什么？还有哪些机制能达成同样目标？如何定义成功？参与者如何定义价值？他们还觉得什么有价值？我们创建这些复杂的系统来处理一切，结果就是我们拥有了非常连贯、深思熟虑的战略，而且无处不在。

---

### [01:07:36] Eoghan McCabe (Continued)

**English:**
Like Paul Adams, our chief product officer, I didn't even plan to show this. He made this book recently, The AI Age and the Transformation of Customer Service and it's a bunch of frameworks for how to think about AI, et cetera. So, it's part of what we do. And so we would hire people who are good at that, but we teach that. That's teachable and not everyone does that. And so the conversations that Des and I would have, we still love being on whiteboards. Our very first office, our own office in Dublin, it was a tiny office. One wall was four, five computers, the other wall was just all whiteboards. We loved that we had a whiteboard wall. In our next office we had a room, square room and all walls were whiteboards.

**中文翻译:**
比如我们的 CPO Paul Adams，他最近写了本书《AI 时代与客户服务转型》，里面全是关于如何思考 AI 的框架。这就是我们做事的方式。我们会雇佣擅长此道的人，但我们也会教。这是可以传授的，而且并非人人都会。我和 Des 至今仍喜欢在白板上讨论。我们在都柏林的第一个办公室很小，一面墙放电脑，另一面墙全是白板。我们太爱白板墙了。在下一个办公室，我们甚至有一个四面墙全是白板的房间。

---

### [01:08:24] Eoghan McCabe (Continued)

**English:**
So, we just love to draw diagrams so you can teach all that stuff. So, yeah, it's just all that good energy product, product energy, first principles, the people we chose. And on the founders side, I was talking to Des about this morning, why have so many Intercom people gone on to be founders? I think it's because we hired founder types and my pitch to people was always come to Intercom, figure out how great companies are built and build it with us and then go on to start your own. I would say that often at all hands. But the irony is that the people we hired back then, the founder types were probably not great employees. They were better founders. I'm not a good employee. And so it'll be interesting to see if this current cohort, we'll get many founders out of this current cohort, but will they convert as well as they did before?

**中文翻译:**
我们喜欢画图表，这些东西都是可以教的。所以，这归功于良好的产品氛围、第一性原理以及我们选择的人才。关于创始人，我今天早上还和 Des 讨论：为什么这么多 Intercom 的人后来都去创业了？我认为是因为我们招的就是“创始人型”的人。我招人时的说辞总是：“来 Intercom 吧，看看伟大的公司是如何建成的，和我们一起建设它，然后去创办你自己的公司。”我经常在全员大会上这么说。但讽刺的是，当时招的那些创始人型人才可能并不是优秀的员工，他们更适合当创始人。我也不是个好员工。所以看看现在的这批员工很有趣，他们中也会出很多创始人吗？转化率会像以前一样高吗？

---

### [01:09:16] Eoghan McCabe (Continued)

**English:**
Because we're now hiring people who want to be part of something bigger. They're more mature and grown up, more stable and consistent. They're part of, they have a certain expertise and a certain lane they want to work in. And maybe they're not the crazy types that went on to start companies, but it's wild. I did see some of that research by you, particularly the one where you show the companies ranked by the number of founders that they have. And I'm like, what is happening? I was as surprised that we were that high as you were because there are many other great companies on that list. So, surprised and proud.

**中文翻译:**
因为我们现在招的人更想成为宏大事业的一部分。他们更成熟、更稳定、更专业，有自己专注的领域。也许他们不再是那种会去创业的“疯子”。但这真的很神奇，我确实看到了你的那项研究，尤其是按创始人数量排名的榜单。我当时想：“天哪，发生了什么？”看到我们排名那么高，我像你一样惊讶，因为榜单上还有很多其他伟大的公司。我感到既惊讶又自豪。

---

### [01:09:53] Lenny Rachitsky

**English:**
I love when people say, I don't really have a clear answer. And then you have exactly a clear answer and it resonates a lot with other companies on this list that I've had on of what the themes are, and I'll just reflect back a few of them. One is complexity. That comes up a lot. And interestingly, most of the other companies in the list, I'll read them real quick. Intercom, Palantir, Revolut, N26, Dropbox, Chime, Stripe, and then Coinbase and Notion is down there. So many are FinTech. Almost all are FinTech. And the complexity there is really high. So, there's a really interesting trend there. Just complexity. Ownership is another one that comes up a lot. Many CEOs, GMs kind of roles, first principles thinking and just going to the bare metal comes up a lot in these conversations.

**中文翻译:**
我喜欢人们说“我没有明确答案”然后又给出了非常明确答案的时刻。这与我采访过的榜单上其他公司的特质非常吻合。我总结几点：一是“复杂性”，这经常被提到。有趣的是，榜单上的公司——Intercom、Palantir、Revolut、N26、Dropbox、Chime、Stripe，还有 Coinbase 和 Notion——很多都是金融科技（FinTech）。那里的业务复杂性极高。这是一个有趣的趋势。二是“所有权”（Ownership），即 PM 扮演迷你 CEO 或总经理的角色。还有“第一性原理”思维，即深入底层逻辑。

---

### [01:10:38] Eoghan McCabe

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:10:39] Lenny Rachitsky

**English:**
And then hiring senior people, hiring founder types.

**中文翻译:**
还有就是雇佣资深人才和创始人型人才。

---

### [01:10:42] Eoghan McCabe

**English:**
Yes. Like Stripe did a lot of that. I think Stripe did a lot of first principle stuff and founder types.

**中文翻译:**
是的，Stripe 就做了很多这样的事。我认为 Stripe 也非常强调第一性原理和创始人型人才。

---

### [01:10:49] Lenny Rachitsky

**English:**
The other thing, we didn't even talk about this, but you guys invented RICE. You guys popularize jobs to be done. Like speaking of frameworks, you guys are a wealth of frameworks that we all use.

**中文翻译:**
还有一件事我们还没聊到：你们发明了 RICE 框架，推广了“待办任务”（Jobs to be Done）理论。说到框架，你们简直是框架的宝库，我们所有人都在用。

---

### [01:10:58] Eoghan McCabe

**English:**
Drowning and frameworks, yeah.

**中文翻译:**
沉浸在框架中，哈哈。

---

### [01:11:00] Lenny Rachitsky

**English:**
Drowning slash changing the way everyone builds product in a really positive way. Okay, is there anything else that you wanted to touch on or leave listeners with before we get to a very exciting lightning round?

**中文翻译:**
沉浸其中，并以非常积极的方式改变了大家构建产品的方式。好，在进入令人兴奋的闪电轮问答之前，你还有什么想补充或想留给听众的吗？

---

### [01:11:13] Eoghan McCabe

**English:**
When someone like me comes on a podcast like this, they always have an ulterior motive and that's healthy and good. It's part of the transaction. Some of it is to enjoy feeling like an expert. But my ulterior motive today is to make sure that people understand that Intercom is a fundamentally different type of late stage company. We are a large old startup. Every single way in which we work is as a startup and are competing with and crushing the actual startup competition in our agent categories. And the reason that that's important for people to know is just like I said earlier, that the handicap that good but late stage companies have is that their late stage and people don't mentally put them in the same box.

**中文翻译:**
当像我这样的人参加这种播客时，总会有一些“私心”，这很健康，也是交易的一部分。一部分是为了享受当专家的感觉，但我今天的私心是想让大家明白：Intercom 是一家本质上不同的成熟期公司。我们是一家“大型的老牌初创公司”。我们的每一种运作方式都像初创公司一样，并且在智能体类别中与真正的初创公司竞争并碾压他们。让大家知道这一点很重要，因为正如我之前所说，成熟期公司的劣势在于人们不再把它们和创新联系在一起。

---

### [01:12:10] Eoghan McCabe (Continued)

**English:**
They just don't imagine these older companies. If I told you that IBM had made the most wildly innovative coding assistant, you'd find it hard to believe, most people would. It's maybe so interesting such that it would stick in your mind, you need to go look at it. But by default people aren't going to look at IBM. And so I want people to take a new look at Intercom because it's a brand new company and our mission is to help every single type of business deliver impeccable, incredible, beautiful personal service to every single one of their users and people, many thousands of people are using Fin for that today. So, go check out Fin please, fin.ai.

**中文翻译:**
人们很难想象老牌公司能做出创新。如果我告诉你 IBM 做出了最疯狂、最具创新性的编程助手，大多数人会觉得难以置信。这也许很有趣，会让你记住，但你默认不会去看 IBM 的产品。所以我希望大家重新审视 Intercom，因为它是一家全新的公司。我们的使命是帮助每一种类型的企业为他们的每一位用户提供完美、不可思议、充满人情味的服务。现在已经有成千上万的人在使用 Fin。所以，请去看看 Fin，网址是 fin.ai。

---

### [01:12:58] Lenny Rachitsky

**English:**
And I don't know if you mentioned this at the beginning, but let's mention that you predict that you'll be the fastest growing company across if you were to look at all public software companies next year.

**中文翻译:**
我不知道你开头提过没，但我们要提一下：你预测明年你们将成为所有上市软件公司中增长最快的一家。

---

### [01:13:10] Eoghan McCabe

**English:**
So, two years ago we were in the low single digits growth rate. We doubled our growth rate and last year we were in the low double digits. This year we're in the 15th percentile of all public software companies. So, you take the 120 something public software companies, we're in the 15th percentile. So, we're getting up there fast and if we sustain this trajectory, and it's obviously dangerous to put these types of things out publicly, but I'll tell you, I look at the charts and it's hard not to imagine where this goes. I think we're going to find ourselves being the fastest growing out of all, relative to all public software companies. So, let's see. But that's the level of shock, surprise and transformation that has actually happened here all because of Fin. So, check in with me in a year and maybe I'll be embarrassed or maybe I'll be feeling like a genius.

**中文翻译:**
两年前，我们的增长率还是低个位数。后来我们翻了一番，去年达到了低两位数。今年，我们在所有上市软件公司中排在前 15%。如果你看那 120 多家公司，我们就在前 15% 之列。我们上升得很快，如果保持这个势头（公开说这些当然有风险），但我看着图表，很难不联想到未来的走向。我认为我们将成为所有上市软件公司中增长最快的。让我们拭目以待。这就是 Fin 带来的震撼、惊喜和转型。一年后再来找我，也许我会感到尴尬，也许我会觉得自己是个天才。

---

### [01:14:03] Lenny Rachitsky

**English:**
Or underselling it. This just reflects back on exactly how I started our conversation. You've done something extraordinary at Intercom. I'm really happy that we're here and we're sharing this story.

**中文翻译:**
或者你还说保守了。这正呼应了我开场时说的话：你在 Intercom 创造了非凡的成就。很高兴我们能在这里分享这个故事。

---

### [01:14:11] Eoghan McCabe

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:14:12] Lenny Rachitsky

**English:**
With that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
那么，我们进入了令人兴奋的闪电轮问答。我有五个问题，准备好了吗？

---

### [01:14:16] Eoghan McCabe

**English:**
Please. Ready.

**中文翻译:**
请讲，准备好了。

---

### [01:14:18] Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
你最常向别人推荐的两三本书是什么？

---

### [01:14:21] Eoghan McCabe

**English:**
So, I found I lost the habit of reading as I started to get more and more stressed with my startup. And so I would listen to audiobooks here and there, but the most recent book I read is a book called Nuclear War: A Scenario, and it's a very much a nonfiction and scared the shit out of me. So, if you like nightmares, it'll be beautiful bedtime reading.

**中文翻译:**
随着创业压力越来越大，我发现自己失去了阅读的习惯。我会偶尔听听有声书。我最近读的一本书叫《核战争：一种情景》（Nuclear War: A Scenario），这是一本非虚构作品，把我吓坏了。如果你喜欢做噩梦，它会是很棒的睡前读物。

---

### [01:14:46] Lenny Rachitsky

**English:**
Excellent.

**中文翻译:**
太棒了。

---

### [01:14:47] Eoghan McCabe

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:14:48] Lenny Rachitsky

**English:**
What's a recent movie or TV show you've really enjoyed?

**中文翻译:**
最近有什么你非常喜欢的电影或电视剧吗？

---

### [01:14:50] Eoghan McCabe

**English:**
I love movies. I want TV to be better, but I very rarely find TV to be great. The first and last TV show I loved was True Detective one that was just incredible. But the last movie I watched was 28 Years Later, and that's by Danny Boyle. I was born in the eighties, grew up as a kid in the nineties, and so grew up with Trainspotting. It was 28 Days Later. Then he made a movie called Sunshine. So, 28 Years Later is a type of movie that's just not made anymore. It's the most nineties movie made since the nineties. It's like very rock and roll and also deeply touching. So, I was really surprised by that. I bet I would love to know that younger generations that are watching this, what they may think, they may hate it, but I love 28 Years Later.

**中文翻译:**
我爱电影。我希望电视剧能做得更好，但我很少发现优秀的剧集。我唯一钟爱的是《真探》（True Detective）第一季，简直不可思议。我最近看的一部电影是丹尼·鲍伊（Danny Boyle）执导的《28 年后》（28 Years Later）。我出生在 80 年代，在 90 年代长大，是看着《猜火车》长大的。他拍过《28 天后》，还有《太阳浩劫》。《28 年后》是那种现在已经没人拍的电影类型了，它是自 90 年代以来最具 90 年代风格的电影，非常摇滚，也非常感人。我很惊讶。我很想知道看这个节目的年轻一代会怎么想，也许他们会讨厌它，但我很喜欢。

---

### [01:15:49] Lenny Rachitsky

**English:**
So, this is the same person that made 28 Days Later, then 29 years later [inaudible 01:15:51].

**中文翻译:**
所以这是拍了《28 天后》，然后 29 年后又拍了……

---

### [01:15:51] Eoghan McCabe

**English:**
Yeah, Danny Boyle.

**中文翻译:**
是的，丹尼·鲍伊。

---

### [01:15:53] Lenny Rachitsky

**English:**
Wow. Okay. Very cool. I didn't know about that. Do you have a favorite product you've recently discovered that you really love? Could be a gadget, could be an app, could be clothes.

**中文翻译:**
哇，好吧，太酷了，我之前不知道。你最近有没有发现什么特别喜欢的产品？可以是小工具、应用或衣服。

---

### [01:16:01] Eoghan McCabe

**English:**
I very rarely like products, I'm such a perfectionist that it has to be really simple with very little moving parts, like a bowl, to actually be like, good. I've started to get more into coffee. I've been buying products by Fellow. They're remarkably good for consumer products, different, it's on a different level. So, there's some sort of level of taste and craft happening there that I don't see in basically any other consumer hardware type products. And of all things, I'd bought a Porsche 911 recently and that is a beautiful product. The interiors are exquisite and there's still a bunch of shit that is going to annoy you. And so it's far from perfect. So, yeah, perfectionism is sometimes a gift if you're in the business of creating products, but also quite the curse. You're never happy, including with the Porsche 911.

**中文翻译:**
我很少喜欢什么产品。我是个完美主义者，产品必须非常简单、零件极少（像个碗一样）我才会觉得好。我最近开始迷上咖啡，买了一些 Fellow 的产品。作为消费品，它们做得出奇地好，完全是另一个水准。那里有一种在其他消费硬件中见不到的品味和工艺。另外，我最近买了一辆保时捷 911，那是一个精美的产品，内饰非常考究，但依然有很多让你心烦的破事。所以它远非完美。是的，如果你从事产品创造，完美主义有时是天赋，但也是诅咒。你永远不会满足，即使是对保时捷 911。

---

### [01:17:02] Lenny Rachitsky

**English:**
I think that's the third time someone recommended a car. Someone recommended, I think Boz at Facebook recommended a fancy Mercedes, and then someone once suggested a Rivian, so now we got Porsche on the list. I always thought maybe one day I'll give someone all the prizes, all the products people have ever mentioned in this. And those are getting, Porsche might be a little high. Okay, two more questions. Do you have a favorite life motto that you find yourself repeating, coming back to in work or life sharing with friends?

**中文翻译:**
我想这是第三次有人推荐车了。Facebook 的 Boz 推荐过奔驰，还有人推荐过 Rivian，现在榜单上有了保时捷。我曾想过有一天把大家推荐过的所有产品作为奖品送出去，但保时捷可能有点贵。好，最后两个问题。你有没有什么人生格言，是你经常在工作或生活中重复、或分享给朋友的？

---

### [01:17:30] Eoghan McCabe

**English:**
It's trite. It's not sophisticated and it's more of a concept than a phrase, but it's something around the idea that life is short. I'm just so aware that time ticks by and we all live on autopilot. So much of what we do is inspired by either our insecurities or things that other people we look up to or envy do. Very rarely making contact with what we really want and following our hearts and our heads. And we just kind of get stuck in these lanes and just live out our days. And certainly when you get 41 now, you get to 41 and thankfully still very young, anyone in their forties, congrats, should feel good about that.

**中文翻译:**
这很陈词滥调，并不高深，更多是一个概念而非一句话，那就是“人生苦短”。我深切地意识到时间在流逝，而我们大多在“自动驾驶”模式下生活。我们的很多行为要么源于不安全感，要么源于对他人的仰慕或嫉妒。很少有人能真正触及内心渴望，追随自己的心和脑。我们只是被困在既定的轨道上虚度光阴。当你到了 41 岁（虽然还很年轻，向所有 40 多岁的人表示祝贺），你会更有感触。

---

### [01:18:18] Eoghan McCabe (Continued)

**English:**
But I know if you're in your twenties or thirties, 40 feels old. But when you're in your forties, my experience is that the weeks and the months and then the years go by. It's not a big deal. I'm back at Intercom two and a half years now to any of these kids in AI in their twenties. If they don't get something done or achieved by next month, they'll be so disappointed themselves and so impatient. And in some ways, at least when it comes to productivity, they're better at getting more out of the time. But I'm now trying to get more life out of the time too. So, just, if there is a motto, it's like life is short or memento mori, we're all on the way out. So, make the use of what you've got.

**中文翻译:**
我知道如果你二十多岁或三十多岁，40 岁听起来很老。但在 40 多岁时，我的经验是周、月、年飞逝而过。我已经回到 Intercom 两年半了。对于那些二十多岁的 AI 少年来说，如果下个月还没做出成就，他们会对自己非常失望且不耐烦。在生产力方面，他们确实更擅长压榨时间。但我现在正尝试从时间中榨取更多的“生活”。所以，如果非要有格言，那就是“人生苦短”或“死亡终将降临”（memento mori），我们都在走向终点，所以好好利用你拥有的一切。

---

### [01:19:05] Lenny Rachitsky

**English:**
Fun fact, I built an app once called Savorable that helped you savor the moment, it was called Savorable and it sent you a text every few hours, I don't know, maybe once a day with a little reminder of way to savor the moment. And one of the texts was just like, remember, you will die.

**中文翻译:**
有趣的是，我曾经开发过一个叫 Savorable 的应用，帮助人们享受当下。它每隔几小时（或者一天一次）会给你发条短信，提醒你享受生活。其中一条短信就是：“记住，你终将死亡。”

---

### [01:19:21] Eoghan McCabe

**English:**
Yeah. And the problem is that even that idea, we forget it instantly. And if you start getting text every day, you'll ignore the text. Try to fault. We just don't want to acknowledge that reality on a day-to-day basis. Maybe that's important.

**中文翻译:**
是的。问题是，即使是这个念头，我们也会瞬间忘掉。如果你每天都收到这种短信，你就会忽略它。我们只是不想在日常生活中承认这个现实。也许这种逃避也很重要。

---

### [01:19:39] Lenny Rachitsky

**English:**
Yeah, maybe for the best.

**中文翻译:**
是的，也许这样最好。

---

### [01:19:40] Eoghan McCabe

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:19:42] Lenny Rachitsky

**English:**
Okay, Final question. Speaking of apps, I was doing research on you in preparation for this and I didn't realize you built Quitter back in the day. I love Quitter. I found it so fun. It basically told you anytime someone unfollowed you on Twitter. So, the question just what happened to that app?

**中文翻译:**
好，最后一个问题。说到应用，我在准备采访时发现你以前开发过 Quitter。我超爱 Quitter，觉得它很有趣。它会在有人在 Twitter 上取关你时提醒你。那个应用后来怎么样了？

---

### [01:19:58] Eoghan McCabe

**English:**
I think we eventually sold it for 14K.

**中文翻译:**
我想我们最终以 1.4 万美元的价格把它卖了。

---

### [01:20:03] Lenny Rachitsky

**English:**
Wow, that's cool.

**中文翻译:**
哇，那很酷。

---

### [01:20:06] Eoghan McCabe

**English:**
On one of these, I think there's a website called Flipper where you could sell websites. It really blew up. It was like a little experiment, kind of a social experiment. It was the first time that I had this feeling that there's no reason someone wouldn't want to use this. Obviously people are going to want to use this. And it was really instructive for me because it taught me that that feeling is possible. You meet so many founders, young founders particularly, and they don't have a sense within themselves about the value of the stuff they're building. Will this be good? Let's get customer feedback. And it is possible to build things that you deeply know makes sense. And that was what Quitter was like. Followers go up, followers go down. At that point in time, people had 100 followers or 200 followers, and you'd want to know who's not my friend anymore.

**中文翻译:**
是在一个叫 Flippa 的网站上卖掉的。它当时真的很火，像是一个小小的社会实验。那是我第一次感觉到：“没理由有人不想用这个，显然大家都会想用。”这对我很有启发，因为它教会我那种“确信感”是可能的。你遇到很多创始人（尤其是年轻创始人），他们对自己构建的东西的价值没有直觉。总在问：“这好吗？让我们听听客户反馈。”其实，你是可以构建出那种你深知其意义的东西的。Quitter 就是这样，粉丝涨涨跌跌，当时大家只有一两百个粉丝，你真的很想知道谁不再是你的朋友了。

---

### [01:21:04] Lenny Rachitsky

**English:**
Oh man, I love that that was your bar that led you to the success later if it's as good as Quitter in terms of product market fit.

**中文翻译:**
天哪，我喜欢这个标准。如果后来的产品在 PMF 方面能像 Quitter 一样好，那肯定会成功。

---

### [01:21:12] Eoghan McCabe

**English:**
I mean, it had the best fit ever. About everyone on Twitter tried to sign up for it and it broke.

**中文翻译:**
我是说，它的契合度简直无敌。当时 Twitter 上的每个人都想注册，结果把它搞瘫痪了。

---

### [01:21:21] Lenny Rachitsky

**English:**
Well, I loved it. Eoghan, thank you so much for doing this. I love just how real and open you are about everything and just how much insight you have to share. I also just love the vibe. I feel like I just am more centered just watching you speak.

**中文翻译:**
我很喜欢它。Eoghan，非常感谢你参加节目。我喜欢你对一切都如此真实和开放，分享了这么多见解。我也很喜欢这种氛围，看着你说话，我觉得自己都变得更沉稳了。

---

### [01:21:34] Eoghan McCabe

**English:**
Oh, thank you.

**中文翻译:**
噢，谢谢。

---

### [01:21:35] Lenny Rachitsky

**English:**
Two Final questions. Where can folks check out Fin, follow you if they want to follow up on anything? And then how can listeners be useful to you?

**中文翻译:**
最后两个问题。大家可以在哪里了解 Fin？如果想关注你，该去哪里？另外，听众可以如何帮到你？

---

### [01:21:42] Eoghan McCabe

**English:**
Check out Fin, fin.ai. If they want to follow me. I'm E-O-G-H-A-N on Twitter, so it's Irish spelling of Owen. But if they want to be helpful to me, I'd love them to try Fin. I'd love them to have their friends that run any kind of customer operations, try it too. This AI thing is noisy. There's so much hype, but it's also really real. And the weird thing about Fin, even relative to the coding apps, the coding apps are blowing up, and yet there's a lot of people experimenting and kicking tires. You can't kick tires with Fin. We only deliver value when you expose it to your customers and it closes tickets and makes them happy. And so AI is really, really happening. And so if you know anyone out there that has customers, they should be using Fin. It's the smartest, cheapest, easiest way to dramatically enhance their business. So, if they do that, they'll be helping me sincerely.

**中文翻译:**
去 fin.ai 看看 Fin。想关注我的话，我的 Twitter 账号是 E-O-G-H-A-N（Owen 的爱尔兰拼法）。如果想帮我，我希望你们能试用 Fin，也希望你们推荐给负责客户运营的朋友。AI 领域现在很嘈杂，有很多炒作，但它也是真实的。Fin 的奇妙之处在于，不像那些还在实验阶段的编程应用，Fin 必须直接面对客户、解决工单、让客户满意才能体现价值。AI 正在真实地发生。如果你认识任何有客户的企业，他们都应该使用 Fin。这是大幅提升业务的最聪明、最便宜、最简单的方法。如果你们这么做，就是对我最大的帮助。

---

### [01:22:46] Lenny Rachitsky

**English:**
I'm sold. Eoghan, thank you so much for being here.

**中文翻译:**
我被说服了。Eoghan，非常感谢你能来。

---

### [01:22:50] Eoghan McCabe

**English:**
Thank you, sir. Pretty fun.

**中文翻译:**
谢谢，很有趣。

---

### [01:22:51] Lenny Rachitsky

**English:**
This was amazing.

**中文翻译:**
太棒了。

---

### [01:22:51] Eoghan McCabe

**English:**
Yeah, thank you.

**中文翻译:**
是的，谢谢。

---

### [01:22:53] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得有价值，可以在 Apple Podcasts、Spotify 或你喜欢的应用中订阅。也请考虑给我们评分或留下评论，这能帮助更多听众发现我们。你可以在 lennyspodcast.com 找到往期节目或了解更多。下期见。