# EOY Review - 双语对照

## Lenny's Podcast: EOY Review - Bilingual Transcript
## Lenny's Podcast：年度回顾 - 中英双语对照剧本

---

### [00:00:03] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny and my goal here is to help you get better at the craft of building and growing products. Normally, I interview world class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful companies. But today is going to be a very different and unique episode. I launched this podcast about six months ago. We've done exactly 50 episodes at this point. We've also done over 2 million downloads since we launched. The podcast is a top 10 technology podcast across Apple and Spotify globally. And I believe there's about 40 to 50,000 subscribers or followers of the podcast across Apple and Spotify, which is all very exciting and kind of blows my mind.

**中文翻译:**
欢迎来到 Lenny's Podcast。我是 Lenny，我的目标是帮助你更好地掌握构建和增长产品的手艺。通常情况下，我会采访世界级的产品领导者和增长专家，从他们构建和发展当今最成功公司的宝贵经验中学习。但今天将是一个非常不同且独特的节目。我大约在六个月前启动了这个播客。到目前为止，我们正好制作了 50 集。自发布以来，我们的下载量已超过 200 万次。该播客在 Apple 和 Spotify 全球范围内均位列技术类播客前 10 名。我相信在 Apple 和 Spotify 上大约有 4 到 5 万名订阅者或关注者，这非常令人兴奋，简直让我感到不可思议。

---

### [00:00:47] Lenny

**English:**
So what I decided to do with this final episode of the year is to look back at the 10 most popular episodes that we've done so far. So what I'm going to do is count down from the 10th most popular episode to number one and play a clip or two from that episode that I found to be most interesting or that's been the most popular. I've never done this sort of episode before. We'll see how it goes. I think it's going to be really interesting. If it's not, we will never do it again. And if it is, awesome. Either way, enjoy. We're going to get right into it after a short word from our sponsors.

**中文翻译:**
因此，我决定在今年的最后一集节目中，回顾一下到目前为止最受欢迎的 10 集节目。我将从第 10 名开始倒数到第 1 名，并播放一两个我认为最有趣或最受欢迎的片段。我以前从未做过这种形式的节目。我们看看效果如何。我觉得这会非常有趣。如果效果不好，我们以后就不做了。如果效果好，那就太棒了。无论如何，请尽情欣赏。在听完赞助商的简短广告后，我们将直接进入正题。

---

### [00:01:19] Adam Grant

**English:**
Have you ever wondered what makes great minds tick? I'm Adam Grant and on my new podcast, Rethinking, I'm trying to find the answers. Every week I interview some of my favorite thinkers to learn how we can bring out the best in ourselves and others. I talk to defying rock climbers, Oscar-winning filmmakers, creators like Lin-Manuel Miranda, entrepreneurs like Mark Cuban and thought leaders like Brene Brown. Find Rethinking on Apple Podcasts, Spotify, Amazon Music, or wherever you listen.

**中文翻译:**
你是否曾好奇过那些伟大的头脑是如何运作的？我是 Adam Grant，在我的新播客《Rethinking》中，我正试图寻找答案。每周我都会采访一些我最喜欢的思想家，学习如何激发自己和他人的最佳潜能。我与无畏的攀岩者、奥斯卡获奖电影制作人、像 Lin-Manuel Miranda 这样的创作者、像 Mark Cuban 这样的企业家以及像 Brene Brown 这样的思想领袖交谈。你可以在 Apple Podcasts、Spotify、Amazon Music 或任何你收听播客的地方找到《Rethinking》。

---

### [00:01:51] Lenny

**English:**
This episode is brought to you by Notion. If you haven't heard of Notion, where have you been? I use Notion to coordinate this very podcast. Including my content calendar, my sponsors, and prepping guests for launch of each episode. Notion is an all-in-one team collaboration tool that combines note-taking, document sharing, wikis, project management, and much more into one space that's simple, powerful and beautifully designed. And not only does it allow you to be more efficient in your work life, but you can easily transition to using it in your personal life, which is another feature that truly sets Notion apart. The other day I started a home project and immediately opened up Notion to help me organize it all. Learn more and get started for free at Notion.com/Lennyspod. Take the first step towards an organized happy team today, again at notion.com/Lennyspod.

**中文翻译:**
本集节目由 Notion 赞助。如果你还没听说过 Notion，那你最近都去哪儿了？我用 Notion 来协调这个播客的所有工作，包括我的内容日历、赞助商管理，以及每集节目发布前的嘉宾准备工作。Notion 是一款全能的团队协作工具，它将笔记、文档共享、维基（Wikis）、项目管理等功能整合到一个简洁、强大且设计精美的空间中。它不仅能让你在工作中更高效，你还可以轻松地将其过渡到个人生活中使用，这是 Notion 真正脱颖而出的另一个特点。前几天我开始了一个家庭项目，立刻就打开 Notion 来帮我组织一切。访问 Notion.com/Lennyspod 了解更多信息并免费开始使用。今天就迈出通往有序、快乐团队的第一步，网址依然是 notion.com/Lennyspod。

---

### [00:02:47] Lenny

**English:**
Welcome back and let's kick off this countdown with the 10th most popular episode of the year, and that is with April Dunford. April is the author of Obviously Awesome. She, in my opinion, is the smartest person in the world on positioning and how to figure out positioning for your product. And here's April describing the five steps to figure out your product's positioning.

**中文翻译:**
欢迎回来，让我们从年度第 10 名最受欢迎的节目开始倒计时，那就是与 April Dunford 的对话。April 是《Obviously Awesome》一书的作者。在我看来，她是世界上在“定位”以及如何确定产品定位方面最聪明的人。下面是 April 描述确定产品定位的五个步骤。

---

### [00:03:06] Lenny

**English:**
Say that you're a PM or founder that's ready to start figuring out their positioning for their product. What's the first thing that you do?

**中文翻译:**
假设你是一名产品经理或创始人，准备开始确定产品的定位。你做的第一件事是什么？

---

### [00:03:15] April Dunford

**English:**
I actually think the first step in a good positioning exercise is to really understand what do we have to position against? So put another way, it's like saying, what do I have to beat in order to win a deal? So in positioning work we call this competitive alternatives. Now, how people mess up this first step is, I say competitive alternatives and they think competition. So things that look exactly like me. But in B2B we kind of have two sets of competitors. We have status quo, which is whatever the company is doing to attempt to solve the problem right now, even if it's crappy and not great. And then there's, if the company does decide they're going to buy something different, they usually make a short list. So, it's whoever else lands on the short list. I need to be able to put a stake in the ground and say, I got to beat all that in order to win a deal.

**中文翻译:**
实际上，我认为一个好的定位练习的第一步是真正理解：我们要针对什么进行定位？换句话说，就是：为了赢得交易，我必须击败什么？在定位工作中，我们称之为“竞争替代方案”（Competitive Alternatives）。人们在这一步常犯的错误是，当我提到竞争替代方案时，他们想到的是“竞争对手”，即那些看起来和我一模一样的东西。但在 B2B 领域，我们通常有两类竞争对手。一类是“现状”（Status Quo），即公司目前为解决问题所做的任何尝试，即使它很糟糕、不理想。另一类是，如果公司决定购买不同的东西，他们通常会列出一个短名单。所以，就是短名单上的其他任何人。我需要明确表态：为了赢得交易，我必须击败所有这些。

---

### [00:04:10] April Dunford

**English:**
Now most folks will discount the status quo, but they shouldn't because in B2B we lose about 40% of our deals to, "No decision," which actually means we lost to the spreadsheet, we lost to pen and paper, we lost to interns. And if we're not positioning well against that, we're never going to get the customer to come off of that. So I got to win against status quo, but I also have to win, most of the time, if it's B2B, you don't just buy the first thing you come across, you make a short list of alternatives and I got to win against those as well.

**中文翻译:**
现在大多数人会忽视“现状”，但他们不应该这样做，因为在 B2B 领域，我们大约有 40% 的交易是因为客户“未做决定”而丢掉的，这实际上意味着我们输给了电子表格，输给了纸笔，输给了实习生。如果我们没有针对这些现状做好定位，我们就永远无法让客户放弃它们。所以我必须战胜现状，而且大多数时候，如果是 B2B 业务，你不会只买你遇到的第一件东西，你会列出一个替代方案的短名单，我也必须战胜那些名单上的对手。

---

### [00:04:44] April Dunford

**English:**
So step number one, what am I positioning against? Once I have that stake in the ground, then I can start thinking about what makes us different. So the easiest way to do this is, okay, this is what I have to position against, what have I got capabilities wise that the alternatives don't have? So feature function or even capabilities of the company, which could be pricing or professional services around other things that you've got, but also capabilities of the product. What have I got that the alternatives don't have? And I can make a giant list of these things. And then I can translate that stuff into value by going down the list and saying, okay, we have this great feature, so what? Why does a customer care about it? What is the value that feature enables?

**中文翻译:**
所以第一步是：我要针对什么进行定位？一旦明确了这一点，我就可以开始思考：是什么让我们与众不同？最简单的方法是：好，这就是我要针对的对手，那么在能力方面，我有哪些是替代方案所没有的？这包括功能特性，甚至是公司的能力（比如定价优势或围绕其他产品的专业服务），当然还有产品的能力。我有什么是替代方案没有的？我可以列出一大堆。然后，我可以逐项将这些东西转化为“价值”：好，我们有这个很棒的功能，那又怎样？客户为什么要在意它？这个功能实现了什么价值？

---

### [00:05:31] April Dunford

**English:**
When I do that mapping over to value, what generally happens is I end up with two or three value buckets or value themes. And quite often those value buckets or value themes are different than what I would've gotten if I got all the smart people in my company together and said, hey, why does everybody love our stuff? When I do it this way I'm ensured that those value themes are differentiated and not just things that are generally valuable, but any alternative could get it done so why are we even talking about it? So in my mind, that's kind of how we do it.

**中文翻译:**
当我完成这种到价值的映射时，通常会得到两三个“价值桶”或“价值主题”。而且通常这些价值主题与我召集公司所有聪明人问“嘿，为什么大家喜欢我们的东西？”所得到的答案是不同的。通过这种方式，我能确保这些价值主题是具有“差异化”的，而不仅仅是那些普遍有价值、但任何替代方案都能做到的事情——如果是那样，我们根本没必要讨论它。在我看来，这就是我们的做法。

---

### [00:06:07] April Dunford

**English:**
Once I've got differentiated value, then I can start thinking about, well look, I could sell this product to any company that has this problem, but not everybody cares about this value the same way. And so what are the characteristics of a target account that make them really, really care a lot about that value? If I do some deep thinking about that, that's going to be my definition of a really best fit customer.

**中文翻译:**
一旦我确定了差异化价值，我就可以开始思考：看，我可以把这个产品卖给任何有这个问题的公司，但并不是每个人都以同样的方式在意这个价值。那么，目标客户的哪些特征会让他们非常、非常在意那个价值呢？如果我对这一点进行深入思考，那就会成为我对“最匹配客户”（Best Fit Customer）的定义。

---

### [00:06:31] April Dunford

**English:**
And then the last piece of positioning of course is market category. And so again, a lot of people will just start with market category and then try to back up, which I think is crazy 'cause then we don't have any way to judge the goodness of a market category. But if I've got, look, this is the value only I can deliver, these are the kind of people that really care a lot about that value. If I start thinking about positioning is like the context I position my product in, then the best market category is the context I position my product in such that this value is kind of obvious to these people. This is my long-winded way of doing it, but this is the only way I know how to get positioning done.

**中文翻译:**
定位的最后一部分当然是“市场类别”（Market Category）。同样，很多人会直接从市场类别开始，然后尝试倒推，我认为这很疯狂，因为那样我们就没法判断一个市场类别的好坏。但如果我已经明确了：看，这是只有我能提供的价值，这是非常在意这种价值的人群。如果我把定位看作是我放置产品的“语境”，那么最好的市场类别就是这样一个语境：在这个语境下，我的价值对这些人来说是显而易见的。这是我比较啰嗦的做法，但这是我所知道的完成定位的唯一方法。

---

### [00:07:17] Lenny

**English:**
Next up is Crystal Widjaja, who is a longtime chief product officer at Gojek. She's currently chief product officer at Kumu, and she's one of the smartest growth minds that you probably have not heard of. Here is Crystal talking about why most analytics efforts fail at companies.

**中文翻译:**
接下来是 Crystal Widjaja，她曾长期担任 Gojek 的首席产品官。她目前是 Kumu 的首席产品官，也是你可能从未听说过的最聪明的增长头脑之一。下面是 Crystal 谈论为什么大多数公司的分析工作会失败。

---

### [00:07:32] Lenny

**English:**
I want to shift a little bit to post that you wrote that maybe he's winning more popular posts, you wrote on the Reforge blog called, Why Most Analytics Efforts Fail. I'd love to hear your broad overview of why do most analytics efforts fail and then how do teams avoid this, maybe what are two to three things they can do?

**中文翻译:**
我想稍微转向你写过的一篇可能是最受欢迎的文章，你在 Reforge 博客上写的，题目叫《为什么大多数分析工作会失败》。我很想听听你对“为什么大多数分析工作会失败”的概括，以及团队如何避免这种情况，或许可以分享两三件他们可以做的事情？

---

### [00:07:51] Crystal Widjaja

**English:**
Yeah, I'm actually pretty surprised at how much noise that has generated because I guess it came from a place of frustration where I kept telling people like, you are doing this wrong, here's how you should probably be doing it. But I think it resonated a lot with Foltz because they recognize all of those symptoms but they weren't sure why it was happening. So to say, oh, this is the thing, instrumentation is what's wrong. I think it's a very actionable thing. It's probably one of the most solvable problems out there. It just takes some time and mental model shifts to do it well.

**中文翻译:**
是的，实际上我对这篇文章引起的巨大反响感到非常惊讶。我想这源于一种挫败感，因为我一直告诉人们：你们做错了，你们应该这样做。但我认为它引起了很多人的共鸣，因为他们识别出了所有这些症状，但不知道为什么会发生。所以，当我说“哦，就是这个，埋点（Instrumentation）出问题了”时，我认为这是一个非常具有可操作性的结论。这可能是目前最容易解决的问题之一，只需要一些时间和思维模型的转变就能做好。

---

### [00:08:27] Crystal Widjaja

**English:**
So a lot of people look at tracking data as how do I track my OKR? How do I know if I'm going up or down? But they don't use it to track or identify insights. So I will use the example of using Twitter for, "News" when in reality they're actually using Twitter for entertainment. Do not treat metric gathering as entertainment. It's not there for you to be like, oh, that's interesting, how novel, and then not act on it. So real news is information that changes what you do in the real world. And if you don't change what you're doing, what you are doing is just getting entertainment. So let's use that as a premise.

**中文翻译:**
很多人把数据追踪看作是“我如何追踪我的 OKR？”或者“我如何知道指标是在上升还是下降？”但他们并没有用它来追踪或识别洞察（Insights）。我会用 Twitter 的例子：人们说用 Twitter 是为了看“新闻”，但实际上他们是在用 Twitter 娱乐。不要把指标收集当成娱乐。它存在的目的不是让你感叹“哦，真有趣，真新奇”，然后却不采取任何行动。真正的“新闻”是能改变你在现实世界中行为的信息。如果你不改变你的行为，你所做的就只是在娱乐。让我们以此为前提。

---

### [00:09:13] Crystal Widjaja

**English:**
The next step in instrumentation is to look at the fact that measurements do not equate to insights. A measurement would be an observation, it's a data point in your database. So the example being power users do four times more bookings is an observed fact because your transactional database obviously says that that is the case. But it's not an insight because it doesn't have context, it doesn't give you information that lets you act on it and better understand the problem.

**中文翻译:**
埋点的下一步是认清一个事实：测量（Measurements）不等于洞察。测量是一种观察，它是数据库中的一个数据点。例如，“核心用户（Power Users）的预订量是非核心用户的四倍”，这是一个观察到的事实，因为你的交易数据库显然显示了这一点。但这并不是洞察，因为它没有语境，它没有提供能让你采取行动并更好地理解问题的信息。

---

### [00:09:45] Crystal Widjaja

**English:**
So another example would be if I see my girlfriend hanging out with a guy, I don't know. That is an observed fact that you see in the real world. You're a hypothesis could be that your girlfriend is cheating on you, but the insight, the actual fact might be that she's not cheating on you, it's her cousin. And now your insight is I am paranoid and I need to change my behavior to be less crazy. So, the insight will provide value when you have this why answered. Why is this person doing this thing? Here's why. And then you are going to act differently.

**中文翻译:**
另一个例子是，如果我看到我的女朋友和一个我不认识的男人在一起。这是你在现实世界中看到的一个观察事实。你的假设可能是你女朋友在劈腿，但洞察（即实际事实）可能是她没有劈腿，那是她的表哥。现在你的洞察是：我太偏执了，我需要改变我的行为，别那么疯狂。所以，只有当你回答了“为什么”时，洞察才会提供价值。为什么这个人要做这件事？原因在这。然后你就会采取不同的行动。

---

### [00:10:25] Crystal Widjaja

**English:**
So for our purposes, if we look at a Goodfood user will transact and is more likely to use a voucher. That's a fact, that's an observation. But it's not an insight. An insight would be something like Goodfood users who are power users are more likely to use a free shipping discount on a high GMV basket versus non-power users. And that actually tells you how to change your marketing approach. It tells you in what circumstances does someone do this When it's a high GMV basket, give power users the ability to get a free discount, but do not do this for non-powered users because they won't convert any better than they normally would. So that helps you change your marketing spend, it helps you understand the decision points of power users versus non-power users. The insight is instrumenting properties into an event so that you can segment who is doing what behavior and make some hypotheses on that observation, test that hypothesis and then you get some causal representation of whether or not that hypothesis was right.

**中文翻译:**
就我们的目的而言，如果我们看到“一个 Goodfood 用户会进行交易，并且更有可能使用代金券”，这是一个事实，一个观察结果。但它不是洞察。洞察应该是这样的：“Goodfood 的核心用户在面对高 GMV（商品交易总额）购物车时，比非核心用户更有可能使用免运费折扣”。这实际上告诉了你如何改变营销策略。它告诉你某人在什么情况下会这样做：当购物车金额很高时，给核心用户提供免费折扣，但不要给非核心用户提供，因为他们的转化率不会因此比平时更高。这能帮你调整营销支出，帮你理解核心用户与非核心用户的决策点。洞察就是将属性（Properties）埋入事件（Event）中，这样你就可以细分谁在做什么行为，并基于观察提出假设，测试该假设，最后得到关于该假设是否正确的因果关系呈现。

---

### [00:11:43] Lenny

**English:**
The eighth most popular episode of the year is our very first episode with Julie Zhou. Julie was a longtime design leader at Facebook. She's now the founder of a company called Sundial. She also wrote the bestseller, the Making of a Manager and her newsletter, The Looking Glass, was a huge inspiration to me that helped me start my newsletter. Here is Julie sharing her advice on getting over imposter syndrome.

**中文翻译:**
年度第 8 名最受欢迎的节目是我们与 Julie Zhou 合作的第一集。Julie 曾长期担任 Facebook 的设计负责人。她现在是一家名为 Sundial 的公司的创始人。她还撰写了畅销书《经理人的成长》（The Making of a Manager），她的新闻通讯《The Looking Glass》对我启发很大，帮助我创办了自己的新闻通讯。下面是 Julie 分享关于克服“冒充者综合征”（Imposter Syndrome）的建议。

---

### [00:12:06] Lenny

**English:**
Going back to your time at Facebook, you've made it sound like you just kind of like, ah, I joined as a designer, figured out design became a manager, and then somehow you became VP of design and it sounded too easy. That's an insane trajectory for someone to follow. Do you have any thoughts or advice on what contributed to your success rising through the ranks that quickly for folks that are just early in their career maybe?

**中文翻译:**
回想你在 Facebook 的时光，你听起来就像是：啊，我作为设计师加入，搞定了设计，成了经理，然后不知怎么就成了设计副总裁，听起来太容易了。对于任何人来说，这都是一个疯狂的职业轨迹。对于那些处于职业生涯早期的人，你对于是什么促使你如此迅速地晋升有什么想法或建议吗？

---

### [00:12:30] Julie Zhou

**English:**
Absolutely. And I want to make it really clear, I would say that the first seven or eight years that I was at Facebook every single week I felt like an imposter. I had no idea really what I was doing. The constant refrain in my head is like, well, do you really deserve to be here? Do you really know what's happening? You're not really prepared for this job. You've never done this before. What do you have to be put in this situation and get to do what you do? And that was really a constant refrain in my head.

**中文翻译:**
当然。我想明确一点，我在 Facebook 的前七八年里，几乎每周都觉得自己是个冒牌货。我真的不知道自己在做什么。脑子里不断回响着：你真的配待在这里吗？你真的知道发生了什么吗？你还没为这份工作做好准备。你以前从未做过这个。你凭什么被放在这个位置上做你正在做的事？这真的是我脑子里不断重复的声音。

---

### [00:13:02] Julie Zhou

**English:**
But looking back, I think it probably took me about seven or eight years until I became a little bit more comfortable with that. After seven or eight years I could look back, I could see all of the things that I got to work on, I could see all the ways that I had grown and learned in that experience. And something clicked for me where I realized it's kind of two sides of the same coin. Being in an uncomfortable situation, being in a position where you feel like, hey, do I really know how to do this, I'm not prepared for it, kind of coincides with the fastest and most intense periods of growth in one's career. I started to realize, well maybe it's not so much of a bad thing. Maybe if I constantly putting myself in this situation where I haven't seen this problem before, that's also what's going to push me to grow and learn.

**中文翻译:**
但回过头来看，我想我大概花了七八年的时间才对这种感觉感到稍微舒服一点。七八年后，我可以回首往事，看到我参与过的所有项目，看到我在那段经历中成长和学习的所有方式。我突然明白了一个道理：这就像是一枚硬币的两面。处于一个不舒服的环境中，处于一个让你觉得“嘿，我真的知道怎么做吗？我还没准备好”的位置，往往与一个人职业生涯中成长最快、最剧烈的时期相吻合。我开始意识到，也许这并不是一件坏事。也许，如果我不断把自己置于从未见过这种问题的境地，那也正是推动我成长和学习的动力。

---

### [00:14:30] Julie Zhou

**English:**
The second thing is embrace the fact that it's okay to be in a position where maybe you don't know what to do, you haven't been trained for. It does coincide with that intense learning. Maybe approach it with that sense of curiosity and that sense of, yes, it's hard, yes, I might be an imposter and I might feel that way for a while, but this is also what's going to help me get there. It's going to be what forces me to do the work and in that process learn and become better.

**中文翻译:**
第二点是，接受这样一个事实：处于一个你可能不知道该做什么、没有接受过相关培训的位置是没关系的。这确实与高强度的学习相伴而生。也许可以用好奇心去对待它，并意识到：是的，这很难；是的，我可能是一个冒牌货，我可能会有很长一段时间这种感觉，但这正是帮助我到达目标的动力。它会迫使我去完成工作，并在那个过程中学习并变得更好。

---

### [00:15:02] Lenny

**English:**
It's amazing to hear that you had imposter syndrome for such a long period of time and you basically ran design for the Facebook app, right?

**中文翻译:**
听到你在那么长的时间里都有冒充者综合征，而你当时基本上是在负责 Facebook 应用的设计工作，这真的很令人惊讶，对吧？

---

### [00:15:11] Julie Zhou

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:15:11] Lenny

**English:**
It's kind of an empowering, inspiring insight that someone that at your level went through that for so long and made it through that. Do you have any other advice or thoughts on just for folks that are going through that? Because I have that to you for a number of years, just like, what the hell am I doing here? People are going to see I don't really know what I'm doing and it's all going to crumble as soon as I make my next mistake. Do you have any other advice there for folks going through that themselves?

**中文翻译:**
这是一种非常有力量、有启发性的见解，像你这种级别的人竟然经历了那么久的这种感觉，并且挺过来了。对于那些正在经历这种痛苦的人，你还有什么其他的建议或想法吗？因为我也曾有过好几年的这种感觉，就像是：我到底在这里干什么？人们会发现我根本不知道自己在做什么，只要我犯下一个错误，一切都会崩塌。对于那些正在经历这些的人，你还有什么建议吗？

---

### [00:15:34] Julie Zhou

**English:**
I think that so much of just exactly what you said, Lenny, I think so much of it that helped me was realizing that everyone feels this way to some extent. And that's also why I always want to talk about that. Because I feel like sometimes you can see from the outside you're like, oh, this person has this title, they have this position, they have these responsibilities. Clearly they've made it, they know what they're doing. But that's never the case.

**中文翻译:**
我觉得正如你所说的，Lenny，对我帮助最大的一点是意识到：在某种程度上，每个人都有这种感觉。这也是为什么我总是想谈论这个话题。因为我觉得有时候你从外部看，会觉得：哦，这个人有这个头衔，有这个职位，有这些职责。显然他们成功了，他们知道自己在做什么。但事实并非如此。

---

### [00:15:58] Julie Zhou

**English:**
I mean, logically, let's think about it. If you're going to do anything new for the first time, how are you ever going to feel totally comfortable, totally prepared? Every time there's something new that you hadn't encountered before it's always going to be a little bit rough, you're never going to feel like perfectly at ease. It's only upon doing something multiple times that you start to see the patterns, you start to realize, okay, it's going to be all right. Even now, the people that I talk to, the people I really look up to, the people who I think are role models and mentors for me, I mean they regularly also share with me that it's the same. They still encounter things that are unprecedented. If we work in tech, I mean the rate of change, the rate of the industry and companies and these new experiences that we have, that never goes away. That's just par for the course. So I think that feeling always exists.

**中文翻译:**
我是说，从逻辑上思考一下。如果你是第一次做任何新事情，你怎么可能感到完全舒服、完全准备好了呢？每当出现你以前从未遇到过的新事物时，过程总是会有点艰难，你永远不会感到完全自在。只有在多次重复做某件事之后，你才会开始看到模式，开始意识到：好吧，会没事的。即使是现在，我交谈过的那些我真正仰慕的人，那些我认为是榜样和导师的人，他们也经常向我分享同样的感觉。他们仍然会遇到前所未有的事情。如果我们从事科技行业，我是说，行业和公司的变化速度，以及我们拥有的这些新体验，这种变化永远不会消失。这只是家常便饭。所以我认为那种感觉一直存在。

---

### [00:16:55] Julie Zhou

**English:**
What I have learned is that there are better tools in your toolkit for dealing with it. One of them is of course me just reminding myself that if I feel uncomfortable, okay, other people feel that way too. Everyone does. It's totally natural. But then to also find other pieces in that toolkit. One is I am much better at asking for help now than I was earlier in my career. I used to actually just try and hold it all in. I was like, hey, I better fake it till I make it. If everyone thinks that maybe I'm coming to the table like I know it then I can fool them.

**中文翻译:**
我学到的是，你的工具箱里有更好的工具来应对它。其中之一当然是提醒自己：如果我感到不舒服，没关系，其他人也有同样的感觉。每个人都会。这完全是自然的。但也要在工具箱里寻找其他工具。其一是，我现在比职业生涯早期更擅长寻求帮助。以前我总是试图憋在心里。我想：嘿，我最好“弄假直到成真”（fake it till I make it）。如果大家都觉得我胸有成竹地坐在谈判桌前，那我就可以瞒过他们。

---

### [00:17:30] Julie Zhou

**English:**
Now I realize I was preventing myself from being able to get that support and that empathy and that camaraderie and that advice that would've helped me actually grow faster and maybe with a little bit less pain in the process. So one of the things I've learned is it's okay to ask for help. It's okay to reach out to people who both may be going through the same things you're going or maybe are a step or two ahead of you in the journey, who have actually gone through that and have lived to tell the tale and can tell you it's going to be okay. Because often that's just what you need, you just need people to tell you it's going to be fine. You're fine. You're good. You've got this. That's so meaningful whenever we sometimes feel down about ourselves. So that's another, I would say tool in the toolkit, asking for help, finding groups of support.

**中文翻译:**
现在我意识到，我当时是在阻止自己获得支持、共情、同僚情谊和建议，而这些本可以帮助我成长得更快，或许过程中的痛苦也会少一些。所以我学到的一件事是：寻求帮助是可以的。向那些可能正在经历同样事情的人，或者在旅程中领先你一两步的人寻求帮助是可以的，他们实际上已经经历过这些并挺了过来，可以告诉你一切都会好起来的。因为通常这正是你所需要的，你只需要有人告诉你：会没事的。你没问题。你很棒。你能行。每当我们对自己感到沮丧时，这都是非常有意义的。所以，我会说这是工具箱里的另一个工具：寻求帮助，寻找支持团体。

---

### [00:18:19] Julie Zhou

**English:**
And then I think the third is it's also okay to just be vulnerable and just talk to people about. I found that some of the most meaningful conversations I had, whether with people at managers or whether with my own reports is when we can be much more open about what it is that we find hard, what are we struggling with? And in that way you actually form deeper connections and people are more able to help out. We can spread the load a little bit. We can put our heads together and brainstorm a better way to solve the problem. And I find that too, even as the head of a department or a founder, it's not going to solve everything myself. I'm never going to have all the answers. Sometimes by just sharing what the problem is by sharing the load, we're all going to collectively come up with a better solution.

**中文翻译:**
然后我认为第三点是，表现出脆弱并与人交谈也是可以的。我发现，我进行过的一些最有意义的对话，无论是与经理还是与我自己的下属，都是当我们能够更加坦诚地谈论我们觉得困难的事情、我们在挣扎的事情时。通过这种方式，你实际上建立了更深层次的联系，人们也更能提供帮助。我们可以分担一下压力。我们可以集思广益，寻找更好的解决问题的方法。我也发现，即使作为部门负责人或创始人，我也无法独自解决所有问题。我永远不会拥有所有的答案。有时，仅仅通过分享问题、分担压力，我们就能共同想出更好的解决方案。

---

### [00:19:14] Lenny

**English:**
Next up is Shishir Mehrotra, CEO of Coda, former VP of product and engineering at YouTube, PM at Microsoft. And here are two my favorite clips from Shishir. One where he shares his favorite interview question using a technique called Eigenquestions and his PHSE career growth framework.

**中文翻译:**
接下来是 Shishir Mehrotra，Coda 的首席执行官，曾任 YouTube 产品和工程副总裁，以及微软的产品经理。这里有两段我最喜欢的 Shishir 的片段。一段是他分享他最喜欢的面试问题，使用的是一种被称为“特征问题”（Eigenquestions）的技术；另一段是他的 PHSE 职业成长框架。

---

### [00:19:32] Shishir Mehrotra

**English:**
I have an interview question I ask, it's a very simple question and it's a coded Eigenquestions test. And the question is, a group of scientists have invented a teleportation device. They've hired you, Lenny, to be they're sort of business counterpart, bring this to market, product [inaudible 00:19:50] this question actually worked well for [inaudible 00:19:52]. But say, you could be the product manager for this thing, bring it to market. What do you do? That's the whole question. Usually people will start asking a bunch of questions and say, well, tell me more about this device. What does it do? How does it work? And is it big? Is it small? Is it fast? Does it disintegrate things or not? Does it need a receiver and a sender? Is it safe?

**中文翻译:**
我有一个经常问的面试题，这是一个非常简单的问题，也是一个隐蔽的“特征问题”测试。问题是：一群科学家发明了一个传送装置。他们雇了你，Lenny，作为他们的商业伙伴，负责将其推向市场。假设你是这个产品的产品经理，负责把它推向市场。你会怎么做？这就是全部问题。通常人们会开始问一堆问题，比如：告诉我更多关于这个装置的信息。它是做什么的？它是如何工作的？它是大是小？快还是慢？它会分解物体吗？它需要接收器和发送器吗？它安全吗？

---

### [00:20:17] Shishir Mehrotra

**English:**
I'll just let those questions come out and at some point I'll say, okay, nice job generating all the questions. Turns out these scientists, they kind of hate talking to people and they're kind of annoyed by all your questions. And so they've decided that they will answer only two of your questions and after that they expect a plan. What two questions do you ask? And interestingly, all of a sudden, like the sharp product managers, engineers, basically every role, they very quickly find what are the two, one or two eigenquestions on this topic.

**中文翻译:**
我会让他们问这些问题，然后在某个时刻我会说：好，问得不错。但事实证明，这些科学家不太喜欢与人交谈，他们被你所有的问题搞烦了。所以他们决定只回答你两个问题，之后他们希望看到一个计划。你会问哪两个问题？有趣的是，突然之间，那些敏锐的产品经理、工程师，基本上任何角色，都能很快找到关于这个话题的一两个“特征问题”。

---

### [00:20:48] Shishir Mehrotra

**English:**
There's no right answer, but I'll tell you one of my favorite ones is as a product manager said, okay, if I had to ask two questions, the two questions I would ask, one is it safe enough for humans or not? And that was a very crisp way to get to just safety. How reliable is it? Didn't ask how reliable it is, how many bits in the middle of this... He's like, just tell me it's safe enough for humans or not. And the second one is it more expensive CapEx or OpEx? Is it more expensive to buy them or to run them?

**中文翻译:**
这没有标准答案，但我告诉你一个我最喜欢的：一位产品经理说，好吧，如果我必须问两个问题，我会问：第一，它对人类是否足够安全？这是一个非常干脆的切入点，直接指向安全性。他没问可靠性如何，没问中间有多少比特流……他只是说：告诉我它对人类是否足够安全。第二个问题是：它是 CapEx（资本支出）更贵还是 OpEx（运营支出）更贵？是购买它更贵，还是运行它更贵？

---

### [00:21:15] Shishir Mehrotra

**English:**
And then he took those two questions and he said, get with those two questions, I can form these quadrants. And you can say, oh, it's safe enough for humans and they're very cheap to buy, but expensive to run. Then you probably run them like human fax machines. You put them everywhere you can and you say, hey look, it's expensive to use but you'll all have the ability to teleport anywhere you want and this is how we're going to run it. But the other hand, they're very expensive to buy, but cheap to run. You probably have to place them very strategically, in which case what you probably do is replace airports. Airports are pretty strategically placed in places where people are trying to get around places. If it's not safe enough for humans, then you've got a whole different class of use cases where you go value what goods are transported in very costly ways. And people come up with, do you do the most expensive things? Is hell supporting people's replacement hearts, is that a really demanding thing? But these two questions kind of get to the heart of it.

**中文翻译:**
然后他拿着这两个问题说：有了这两个问题，我就可以形成这些象限。你可以说，哦，它对人类足够安全，购买非常便宜，但运行昂贵。那么你可能会像“人类传真机”一样运行它们。你把它们放在任何能放的地方，然后说：嘿，看，虽然使用起来很贵，但你们都有能力传送到任何想去的地方，这就是我们的运营方式。但另一方面，如果它们购买非常昂贵，但运行便宜。你可能必须非常有策略地放置它们，在这种情况下，你可能会取代机场。机场通常被战略性地安置在人们试图往返的地方。如果它对人类不够安全，那么你就有一类完全不同的用例，你可以去评估哪些货物的运输成本非常高。人们会想到：你是否运送最昂贵的东西？比如运送人们急需的移植心脏，那是非常迫切的需求吗？但这两个问题确实触及了核心。

---

### [00:22:15] Shishir Mehrotra

**English:**
The question's totally made up, no teleportation device exists, at least not yet. I find that people's ability to learn the method is significantly higher if it's low stakes. That question by the way, if you ask a kid that question, hey, teleportation device, you get to ask two questions, almost every kid will quickly get to two pretty good eigenquestions. Kids are incredibly good at simplifying these things down, it's actually a skill we remove from ourself. I'll hear candidates tell me things, I guess I would ask them what size it is and why would you ask them what size? What decision is that going to allow you to make, to know what size? And sometimes they can explain it, sometimes not and don't get hired. But then actually the thing I'd say about it is there are eigenquestions everywhere. I mean you can take any product out there, I'll do it with my kids a lot, and they'll say, I was just riding with my younger daughter and she said, how come there's three gas stations in the same corner? Why do people do that? That's a really insightful observation. What's the eigenquestion? How do you place a gas station you can almost take anything and say, what is the question that really drives this answer.

**中文翻译:**
这个问题完全是虚构的，传送装置并不存在，至少现在还没有。我发现，如果风险较低，人们学习这种方法的能力会显著提高。顺便说一句，如果你问一个孩子这个问题：“嘿，传送装置，你可以问两个问题”，几乎每个孩子都能很快想到两个相当不错的特征问题。孩子们非常擅长简化这些事情，这实际上是我们从自己身上剥离的一种技能。我会听到应聘者告诉我：我想我会问它们是什么尺寸。那你为什么要问尺寸呢？知道尺寸能让你做出什么决定？有时他们能解释清楚，有时不能，那就不会被录用。但实际上我想说的是，特征问题无处不在。你可以拿任何产品来练习，我经常和我的孩子们这样做。有一次我和小女儿坐车，她说：“为什么同一个拐角有三个加油站？人们为什么要那样做？”这是一个非常有见地的观察。特征问题是什么？你如何选址加油站？你几乎可以拿任何事情来问：真正驱动这个答案的问题是什么？

---

### [00:23:27] Shishir Mehrotra

**English:**
It stands for problem, solution, how, execution, PSHE. So here's how it works. So if you're sort of a junior product manager, what happens? You get handed a problem, you get handed a solution, you get handed the how, go talk to this person, write this document, run this meeting, so on. And all you have to do is execute, run that playbook and that's all we expect out of you. You can become a little more senior, we hand you a problem, we hand you a rough solution, you figure out the how. You figure out the how we're going to organize this? What are the milestones? How we're going to get it to market? How we're going to the meetings? What are the rituals? All those things show up in the H.

**中文翻译:**
它代表问题（Problem）、方案（Solution）、方式（How）、执行（Execution），简称 PSHE。它是这样运作的：如果你是一个初级产品经理，会发生什么？你会得到一个问题，得到一个方案，得到执行方式——去和这个人谈谈，写这份文档，开这个会，等等。你所要做的就是执行，按照那个剧本跑，这就是我们对你的全部期望。当你变得资深一点，我们会给你一个问题，给你一个粗略的方案，由你来想出“方式”。你来想出我们如何组织这件事？里程碑是什么？我们如何将其推向市场？我们如何开会？仪式感是什么？所有这些都体现在 H（方式）中。

---

### [00:24:05] Shishir Mehrotra

**English:**
At some point you become a little more senior, we hand you a problem and you come back with the solutions and we judge you on the creativity and the effectiveness of the solutions. And at some point you're senior enough that you tell us the problems and you say, hey, I know you told me to go work on activation, but actually I think our issue is brand or I think our issue is quality or I think our issue is whatever it might be, and that's sort of the pinnacle of this way of thinking about it.

**中文翻译:**
到某个阶段，你变得更资深了，我们给你一个问题，你带着方案回来，我们根据方案的创造力和有效性来评价你。最后，当你足够资深时，你会告诉我们“问题”是什么，你会说：“嘿，我知道你让我去做用户激活，但实际上我认为我们的问题在于品牌，或者我认为我们的问题在于质量，或者我认为问题在于其他任何事情。”这就是这种思维方式的顶峰。

---

### [00:24:30] Shishir Mehrotra

**English:**
Now just back to this picture for a moment, one of the interesting things that happened was the teams went and they evaluated their teams on these two ax axis and they end up with this sort of curved line between them. It's not linear as you work your way through. And what happens is early in people's career, they mostly sit at that E point, you get handed a problem and handed a solution, handed a how, and you just execute and they gradually grow in skill. Later in people's careers, similarly, you're at that P level, just do bigger and bigger products. And it's like the job of being an entrepreneur or CEO or an owner or so on is just kind of do bigger and bigger projects.

**中文翻译:**
现在回到这张图，一件有趣的事情是，团队根据这两个轴评估他们的成员，结果在它们之间形成了一条曲线。它不是线性的。情况是这样的：在职业生涯早期，人们大多处于 E（执行）点，得到问题、方案和方式，然后直接执行，技能逐渐增长。在职业生涯后期，类似地，你处于 P（问题）级别，只是负责越来越大的产品。这就像是企业家、CEO 或所有者的工作，就是去做越来越大的项目。

---

### [00:25:06] Shishir Mehrotra

**English:**
But in the middle the slope changes and all of a sudden it's not really about scope, it's about PSHE. And there's a circle drawn here for what I like to call the trough of dissolution. What happens in that phase, I was talking to the calibration companies about this, the reason we call the trough of dissolution [inaudible 00:25:22] is for the employee, for the person, this is a confusing time. Everything about leading up to this moment from high school and college has been about scope. And at this point you're all of a sudden told, we're not judging you on scope anymore, we're judging you on this PSHE thing. That's very confusing.

**中文翻译:**
但在中间阶段，斜率发生了变化，突然之间，重点不再是“规模”（Scope），而是 PSHE。这里画了一个圆圈，我称之为“幻灭低谷”（Trough of Dissolution）。在那个阶段，我曾与一些做人才评估的公司讨论过，我们称之为幻灭低谷的原因是，对于员工个人来说，这是一个令人困惑的时期。从高中到大学，直到这一刻之前，所有事情都关乎规模。而现在，你突然被告知：我们不再根据规模来评判你，我们根据 PSHE 来评判你。这非常令人困惑。

---

### [00:25:39] Shishir Mehrotra

**English:**
To the calibrator, to the manager, it's also very confusing because all of a sudden the way I put it is the difference between a level three and a level seven may not be scoped. They may do the exact same job, it's how they do the job that matters and here's some language for how they do the job. So PSHE became a very sticky way of thinking about it. It turns out that this way of evaluating people is actually not that specific to product management. It's really easy to see why you do the exact same thing for engineers and designers and so on. But to pick one that may not be as obvious, I'll pick salespeople. A very common thing people do with salespeople is they evaluate them based on quota attainment. It's like the easiest thing to do is take the salespeople and rank them by who hit their quota and who didn't.

**中文翻译:**
对于评估者和经理来说，这也很令人困惑，因为突然之间，我所说的 3 级和 7 级之间的区别可能不在于规模。他们可能做着完全相同的工作，关键在于他们“如何”做这份工作，这里有一些描述他们如何工作的语言。所以 PSHE 变成了一种非常有粘性的思维方式。事实证明，这种评估人的方式实际上并不局限于产品管理。很容易理解为什么对工程师、设计师等也可以这样做。但选一个不那么明显的例子，我选销售人员。人们对销售人员最常见的做法是根据业绩指标（Quota）达成情况来评估。最简单的方法就是把销售人员按谁达标、谁没达标进行排名。

---

### [00:26:21] Shishir Mehrotra

**English:**
You go ask the sales team, who's the best salesperson and what you'll realize, and they'll say, quota statement is just a signal for how good you negotiate your quota and pick the right territory. And they say, really, you want to know who's a best salesperson. They say, well, so and so, I mean she can sell anything and she can be in the region that's growing or the region that's shrinking or the new product or the old product. If you think about that terminology, it's very similar to PSHE thinking. This is the person who can come into a new space, identify the right problems and solve them. That's what makes a really great salesperson. So it could become my framework for evaluating talent in sort of all sorts of ways. You might recognize a pattern of being a great P thinker, it's very correlated with being good with eigenquestions. Can you spot the right problems is very similar to can you spot the right questions? Can you decide what's important?

**中文翻译:**
但你去问销售团队，谁是最好的销售人员，你会发现他们会说：业绩达成只是一个信号，说明你有多擅长谈判你的指标以及选择正确的领地。他们会说，如果你真的想知道谁是最好的销售，那就是某某某，我是说，她能卖掉任何东西，无论是在增长的地区还是萎缩的地区，无论是新产品还是旧产品。如果你思考一下这些术语，它与 PSHE 思维非常相似。这就是那个能进入新领域、识别正确问题并解决它们的人。这才是真正伟大的销售人员。所以这成了我以各种方式评估人才的框架。你可能会发现，成为一个伟大的 P（问题）思考者，与擅长提出“特征问题”高度相关。你能否发现正确的问题，与你能否发现正确的问题（Questions）非常相似。你能决定什么是重要的吗？

---

### [00:27:10] Lenny

**English:**
Our sixth most popular episode is with Kristen Berman, founder of Irrational Labs on using behavioral science to improve your product. Here is Kristen describing the three Bs of behavioral change.

**中文翻译:**
我们排名第 6 的最受欢迎节目是与 Irrational Labs 创始人 Kristen Berman 的对话，主题是利用行为科学来改进产品。下面是 Kristen 描述行为改变的“3B 模型”。

---

### [00:27:22] Kristen Berman

**English:**
There are so many mistakes that humans make and we can call them biases, heuristics, our team uses psychologies. What are the psychologies that drive us? And so to tackle this, our team basically has created a model of behavior change we call the three Bs. And this summarizes the most important psychologies that drive user that are important to the product managers and the marketers. We've used this at Google, Microsoft, LinkedIn, so all the companies that we work with and they now use it.

**中文翻译:**
人类会犯很多错误，我们可以称之为偏见（Biases）、启发法（Heuristics），我们的团队称之为心理学。驱动我们的心理因素是什么？为了解决这个问题，我们的团队创建了一个行为改变模型，我们称之为“3B”。它总结了驱动用户的、对产品经理和营销人员最重要的心理因素。我们在谷歌、微软、领英以及所有合作过的公司中都使用了这个模型，现在他们也在使用它。

---

### [00:27:51] Kristen Berman

**English:**
So the first B of three Bs framework, first B is actually not a psychology, but it is the most important part of behavior change and it should kind of be obvious. If you think about behavior change, behavioral economics, it is behavior. In order to change behavior, you have to pick a behavior that you want to change. So companies are really good at outcomes, but just not as sharp at picking the behavior.

**中文翻译:**
3B 框架的第一个 B 实际上不是一种心理学，但它是行为改变中最重要的部分，而且这应该是显而易见的。如果你思考行为改变、行为经济学，核心就是“行为”（Behavior）。为了改变行为，你必须选择一个你想要改变的行为。公司通常很擅长设定“结果”（Outcomes），但在选择具体的“行为”方面却不够敏锐。

---

### [00:28:14] Kristen Berman

**English:**
And when I say behavior, I mean action. The thing that you want someone to do, by the way, the only wrong answer here is log in. So it's really, it's not about logging in, it's about what you do after you log in. And when we're consulting teams would be like, we need to get uncomfortably specific. We say just really specific in the behavior. So example, if I'm Peloton PM and I'm working on the app, I would say something like within 7 days of somebody starting the app they do 2, 10 minute workouts with two different instructors. Now obviously that is wildly specific and you'd probably be very happy if they did one workout with one instructor, but the reality is if you don't define that behavior, you're going to change, you can't actually define the psychologies that affects someone's decision making when doing that behavior. So that's a first B.

**中文翻译:**
我所说的行为，是指“动作”。你想让某人做的事情。顺便说一句，这里唯一的错误答案是“登录”。所以，重点不在于登录，而在于登录后你做了什么。当我们咨询团队时，我们会说：我们需要做到“令人不安的精确”。我们要对行为描述得非常具体。例如，如果我是 Peloton 的产品经理，负责 App，我会说：在某人启动 App 的 7 天内，他们与两个不同的教练完成了两次 10 分钟的锻炼。显然这非常具体，如果他们只跟一个教练做了一次锻炼，你可能也会很高兴，但现实是，如果你不定义那个你要改变的行为，你就无法真正定义在执行该行为时影响某人决策的心理因素。这就是第一个 B。

---

### [00:29:02] Kristen Berman

**English:**
Second B, again, is probably pretty obvious and is very critical, it's just barriers. So we need to reduce the barriers to doing the behavior. And there are two types of barriers we look at. One is logistical, so this is just the stuff in our way could be entering a credit card, could be any form field. And then the second is cognitive. So the cognitive barriers get in our way as well. These are things like uncertainty aversion, this is optimism bias, information aversion. Status quo, big one. It's just you do the same thing today that you did yesterday, your job-

**中文翻译:**
第二个 B 同样显而易见且非常关键，那就是“障碍”（Barriers）。我们需要减少执行该行为的障碍。我们关注两类障碍。一是物流/流程上的（Logistical），即挡在我们路上的东西，比如输入信用卡信息、任何表单字段。二是认知上的（Cognitive）。认知障碍也会阻碍我们。这些包括不确定性规避（Uncertainty Aversion）、乐观偏见（Optimism Bias）、信息规避（Information Aversion）。还有“现状”（Status Quo），这是一个大项。就是你今天做着和昨天一样的事情，你的工作——

---

### [00:29:38] Lenny

**English:**
Can you talk about those three you just threw out there, just briefly? I'm curious about the specific biases while were there.

**中文翻译:**
你能简要谈谈你刚才提到的那三个吗？我对那些具体的偏见很感兴趣。

---

### [00:29:43] Kristen Berman

**English:**
Yeah, so uncertainty aversion, when something is uncertain or we're not... So I'll give you an example. If you're Lift, there's logistical friction, which is wait time. But then there's also this uncertainty of is it going to come on time? When is it going to come? And with this uncertainty, you're probably going to look for other options. You're going to open up Uber and say like maybe it'll come faster. And so when there is uncertainty in our life, we either look for other options or we just don't make a decision at all. This is by the way, very big in healthcare where when you're very uncertain about something, you may not even go to the doctor or you may just make the wrong decision.

**中文翻译:**
好的。不确定性规避，是指当某件事不确定或者我们不……我给你举个例子。如果你是 Lyft，存在流程上的摩擦，即等待时间。但同时也存在这种不确定性：它会准时来吗？什么时候来？有了这种不确定性，你可能会寻找其他选择。你会打开 Uber 说：也许它会来得更快。所以当我们的生活中出现不确定性时，我们要么寻找其他选择，要么根本不做决定。顺便说一句，这在医疗保健领域非常普遍，当你对某件事非常不确定时，你甚至可能不去就医，或者可能做出错误的决定。

---

### [00:30:24] Kristen Berman

**English:**
Same with status quo effect. Where we kind of underlying status quo effect is this idea that we always take the path, not always but majority of... You don't really say always when you're talking about human behavior. Human behavior is very complex. But more often than not, we take the path of least resistant. So we do the thing that's easiest and typically the thing that's easiest, it's the thing that we've done yesterday and the day before. So when you're asking someone to do something different, which is what most product, especially startups, are trying to do, you actually have to increase their motivation or make it easier, reduce the barriers to get them to do that. And so status quo effect, it's a big, big one that folks are fighting.

**中文翻译:**
现状效应（Status Quo Effect）也是一样。现状效应的底层逻辑是：我们总是选择阻力最小的路径——不是总是，但绝大多数时候……谈论人类行为时不能说“总是”，人类行为非常复杂。但通常情况下，我们会选择阻力最小的路径。所以我们做最容易的事，而最容易的事通常就是我们昨天和前天做过的事。因此，当你要求某人做一些不同的事情时（这正是大多数产品，尤其是初创公司试图做的），你实际上必须增加他们的动力，或者让事情变得更容易，减少障碍来促使他们去做。所以现状效应是人们正在对抗的一个非常大的障碍。

---

### [00:31:03] Lenny

**English:**
Awesome, thanks for sharing this.

**中文翻译:**
太棒了，谢谢分享。

---

### [00:31:05] Kristen Berman

**English:**
The third B is benefits. So this is where you want to increase the not just benefits, but the immediate benefits of doing something. So we are all present bias, which means we prioritize our present self over our future self. There are plenty of reasons that somebody, your customer, your user should take an action, but you actually have to give them a reason to take an action today. So as an example, if you're Asana and you're trying to get someone to log a task, the right thing for them to do is log the task because it's going to get their project done on time. You're going to have a collaborative and communicative team that you're going to want to be on. But one of the real reasons we may log a task is because of completion bias, we want to see the checkbox. We may log it because of social desirability bias, where other people see that we're getting our work done, there's a notification that goes to my teammate when I complete something. So these are the immediate benefits that we have to build into products and features to drive use.

**中文翻译:**
第三个 B 是“收益”（Benefits）。在这里，你不仅要增加收益，还要增加做某事的“即时收益”。我们都有“现时偏好”（Present Bias），这意味着我们优先考虑现在的自己，而不是未来的自己。你的客户或用户有很多理由采取行动，但你实际上必须给他们一个“今天”就采取行动的理由。例如，如果你是 Asana，你想让某人记录一个任务，对他们来说正确的事情是记录任务，因为这能让项目准时完成，能让你所在的团队更具协作性和沟通性。但我们记录任务的真正原因之一可能是“完成偏好”（Completion Bias）——我们想看到那个复选框被打上勾。我们也可能因为“社会期望偏好”（Social Desirability Bias）而记录它——让别人看到我们在完成工作，当我完成某件事时，会给我的队友发送通知。所以，这些就是我们必须构建到产品和功能中以驱动使用的即时收益。

---

### [00:32:06] Lenny

**English:**
Awesome. I definitely have completion bias, I left checking those freaking check boxes.

**中文翻译:**
太棒了。我绝对有完成偏好，我太喜欢勾选那些该死的复选框了。

---

### [00:32:12] Lenny

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table.

**中文翻译:**
本集节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。如果你的企业在云端存储任何数据，那么你很可能已经被问到或将被问到关于 SOC 2 合规性的问题。SOC 2 是证明你的公司采取了适当安全措施来保护客户数据的一种方式，它能建立客户和合作伙伴的信任，尤其是那些有严格安全要求的客户。此外，如果你想向企业级客户销售产品，证明安全性至关重要。SOC 2 既可以为更大、更好的交易打开大门，也可以让你的业务陷入停滞。如果你没有 SOC 2，很有可能你连谈判桌都上不了。

---

### [00:32:51] Lenny

**English:**
Beginning a SOC 2 report can be a huge burden, especially for startups. It's time consuming, tedious and expensive. Enter Vanta. Over 3000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time Lenny's Podcast listeners, get $1,000 off Vanta. Just go to vanta.com/Lenny, that's V-A-N-T-A.com/Lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
开始一份 SOC 2 报告可能是一个巨大的负担，尤其是对于初创公司。它耗时、乏味且昂贵。Vanta 应运而生。超过 3000 家快速增长的公司使用 Vanta 来自动完成高达 90% 的 SOC 2 相关工作。Vanta 可以让你在几周内而不是几个月内为安全审计做好准备，耗时不到通常时间的三分之一。在限定时间内，Lenny's Podcast 的听众可以享受 Vanta 1000 美元的优惠。只需访问 vanta.com/Lenny（即 V-A-N-T-A.com/Lenny）即可了解更多信息并领取折扣。今天就开始吧。

---

### [00:33:29] Lenny

**English:**
The fifth most popular episode of the year is with the great Elena Verna on B2B growth. Elena is currently head of growth at Amplitude. Prior to that, she was CMO at Miro, she was senior vice president of growth at SurveyMonkey and she might be the smartest person in the world on B2B growth. Just putting that out there. Here are two clips from Elena. The first on why retention is so important to your product and why it's so important to get right. And the second on what to put into your freemium product versus your paid product.

**中文翻译:**
年度第 5 名最受欢迎的节目是与伟大的 Elena Verna 讨论 B2B 增长。Elena 目前是 Amplitude 的增长负责人。在此之前，她是 Miro 的首席营销官（CMO），曾任 SurveyMonkey 的增长高级副总裁。她可能是世界上在 B2B 增长方面最聪明的人。我就是这么认为的。这里有两段 Elena 的片段。第一段是关于为什么留存（Retention）对你的产品如此重要，以及为什么做对它至关重要。第二段是关于在你的免费增值（Freemium）产品和付费产品中分别应该放入什么。

---

### [00:34:00] Elena Verna

**English:**
I think every single company has to first focus on being product led and retention, period. The only way that you will ever have any chance of acquisition being product led is if you nail your product led retention. Let me break it down. Retention falls into two main KPIs, which is activation and then engagement. If your product is not able to activate and more importantly engage via habitual loops and be in the habit forming zone, then you'll have no chance to hooking an acquisition engine into your product. Because acquisition and product led means users and buy it or users refer or users create content that attracts other users.

**中文翻译:**
我认为每家公司都必须首先专注于“产品驱动”（Product Led）和“留存”，句号。你让获客（Acquisition）实现产品驱动的唯一机会，就是你彻底搞定了产品驱动的留存。让我详细说明一下。留存分为两个主要的 KPI：激活（Activation）和参与（Engagement）。如果你的产品无法激活用户，更重要的是，无法通过习惯回路（Habitual Loops）让用户参与并进入习惯养成区，那么你就没有机会将获客引擎挂载到你的产品上。因为产品驱动的获客意味着用户购买、用户推荐或用户创作内容来吸引其他用户。

---

### [00:34:41] Elena Verna

**English:**
Well, if your users are not habitually using your product, there's less and less opportunities for you to actually create any sort of product led acquisition. So never start with product led acquisition. You first always have to start with product led retention, activation, and engagement. Then you can choose, is your product has a relationship of one to many? If it has a collaboration at its core, say Slack or Miro or even the Amplitude. Or does it have more of a single mode relationship? So let's say Snowflake, there is not one to many relationships there between users. Well, if you have one to many relationships, product led is a fantastic way for you to prototype that model. If you don't have them, then it becomes increasingly hard. Most of the B2B products don't have that one to many relationship, so it's very difficult to stand up product led acquisition. So you rely on marketing led and sales led and that's fantastic, those are fantastic growth models as well.

**中文翻译:**
如果你的用户没有习惯性地使用你的产品，那么你创造任何形式的产品驱动获客的机会就会越来越少。所以，永远不要从产品驱动获客开始。你必须始终先从产品驱动的留存、激活和参与开始。然后你可以选择，你的产品是否具有“一对多”的关系？如果它的核心是协作，比如 Slack、Miro 甚至是 Amplitude。或者它更多的是一种单模式关系？比如 Snowflake，用户之间没有一对多的关系。如果你有一对多的关系，产品驱动是原型化该模型的绝佳方式。如果你没有，那就会变得越来越难。大多数 B2B 产品没有那种一对多的关系，所以很难建立产品驱动的获客。因此，你依赖营销驱动和销售驱动，这也很棒，它们也是极好的增长模型。

---

### [00:35:39] Elena Verna

**English:**
The only other question becomes in the self-serve monetization, that's product led. Otherwise you go in the sales led and you chase after those large contract values. And you can still be product led and monetization with sales team via product led sales or you can just be self-serve if you have a specific segment that is valuable for. But the question there is your use cases and your market matureness to handle self-serve or do you need that sales touch? Every industry and every sector is going through transformation at different velocities. So even if you don't have that product like sales or self-serve in your industry now, I guarantee you it will pop up in the next 10 years. And if you are not going to introduce it, you will get disrupted by it.

**中文翻译:**
剩下的唯一问题就是自助式变现（Self-serve Monetization），那是产品驱动的。否则，你就走销售驱动路线，追求那些大额合同。你仍然可以通过“产品驱动销售”（Product Led Sales）与销售团队合作实现产品驱动变现，或者如果你有一个特定的有价值的细分市场，你可以只做自助服务。但问题在于，你的用例和市场成熟度是否足以支撑自助服务，还是需要销售人员的介入？每个行业和每个部门都在以不同的速度经历转型。所以，即使你的行业现在还没有那种产品驱动销售或自助服务，我保证它在未来 10 年内会出现。如果你不引入它，你就会被它颠覆。

---

### [00:36:31] Lenny

**English:**
For a product leader or founder who's thinking about what they should make free in their freemium model, do you have kind of a mental model of how you think about here's what you should make free? Or, is that too big of a question for a quick answer?

**中文翻译:**
对于正在思考在免费增值模型中应该把什么设为免费的产品负责人或创始人，你是否有一个思维模型来思考“这里是你应该设为免费的东西”？或者，这个问题太大，无法快速回答？

---

### [00:36:44] Elena Verna

**English:**
So I mean you first have to align on what your strategic value of free is. I do have a general framework of saying freemium has to check one of these boxes. Does it help my indirect monetization? So some sort of virality or network effects. If it does, I'm probably going to make it free. Does it suffice for every single user regardless of their complexity? If it does, then it's probably commoditization of the feature anyways and I should make it free. Does it help my aha moment? If it does, then I definitely want to have a POC as part of my free and I'm going to put it in the free offering. Does it create habit loops for me? So let's say notifications or some sort of channel communication. If it does, then I'm probably going to put it for free. So anything that actually creates friction for my growth model, I'll probably gate it in the paid. Anything that promotes my growth model, I will put it into free. Now it is very heavily dependent on your actual monetization strategies. So it's a little bit of over encompassing statement, but at the end of the day, I'm thinking about it very much. How does free help me achieve my growth model outcomes without sacrificing monetization potential?

**中文翻译:**
我是说，你首先必须在“免费的战略价值”上达成一致。我确实有一个通用框架，即免费增值必须满足以下条件之一：它是否能帮助我的间接变现？比如某种病毒式传播或网络效应。如果是，我可能会把它设为免费。它是否适用于每一个用户，无论其复杂程度如何？如果是，那么这个功能可能已经商品化了，我应该把它设为免费。它是否有助于实现“啊哈时刻”（Aha Moment）？如果是，那么我肯定希望将 POC（概念验证）作为免费内容的一部分，并将其放入免费产品中。它是否为我创造了习惯回路？比如通知或某种渠道沟通。如果是，我可能会把它设为免费。所以，任何实际上会给我的增长模型带来摩擦的东西，我可能会把它放在付费墙后。任何能促进我增长模型的东西，我都会把它设为免费。当然，这在很大程度上取决于你实际的变现策略。所以这是一个比较笼统的说法，但归根结底，我思考的是：免费如何帮助我实现增长模型的结果，同时又不牺牲变现潜力？

---

### [00:37:57] Lenny

**English:**
Our fourth most popular episode of the year. Just to put this out there, the next three have came in really close to each other so you can kind of mix and match them in order. But at this point, the fourth most popular episode of the year is with Ethan Smith, CEO of Graphite, and just general SEO guru. Here are two clips from Ethan, one on how people often under invest in SEO. And two, signs that SEO might be right for your product.

**中文翻译:**
年度第 4 名最受欢迎的节目。顺便说一下，接下来的三名非常接近，所以你可以根据顺序随意组合。目前，年度第 4 名是与 Graphite 首席执行官、SEO 大师 Ethan Smith 的对话。这里有两段 Ethan 的片段，一段是关于人们通常如何对 SEO 投入不足，另一段是关于 SEO 可能适合你产品的迹象。

---

### [00:38:23] Ethan Smith

**English:**
I think people under resource SEO a lot of times and over resource ads. So if you're Zillow, you're going to spend tens of millions of dollars on ads, or if you're eBay, you're going to spend tens of millions of dollars on ads. Why would you not have a really great SEO team? Like the amount of traffic you get is probably equal to that. So if you're going to spend a hundred billion on ads, why would you spend $50,000 on SEO? That doesn't make sense.

**中文翻译:**
我认为人们很多时候对 SEO 投入的资源不足，而对广告投入过多。如果你是 Zillow，你会花数千万美元做广告；如果你是 eBay，你也会花数千万美元做广告。那你为什么不组建一支优秀的 SEO 团队呢？你获得的流量可能与广告相当。所以，如果你打算花 1000 亿做广告，为什么只花 5 万美元做 SEO？这不合逻辑。

---

### [00:38:46] Lenny

**English:**
What are just attributes of a product or a company that tell you that SEO could be a growth driver or a massive growth driver? Because I imagine SEO isn't useful for everybody. How do you think about that?

**中文翻译:**
一个产品或公司的哪些属性会告诉你 SEO 可能成为增长驱动力，甚至是巨大的增长驱动力？因为我想 SEO 并不对每个人都有用。你怎么看？

---

### [00:38:59] Ethan Smith

**English:**
There's two big things. The first thing is the addressable market large, SO'S the addressable market for SEO large? And for most categories it is. The second is, do you have authority, you have existing traction? If you start from zero and you have no traction. So we talk with seed stage companies and series A companies, typically they don't have a lot of authority and it's too soon. And Google doesn't want you to just be an SEO site and they want you to be a credible domain before they rank you. And if you're starting from zero, they don't have enough signals that you are.

**中文翻译:**
有两件大事。第一是可触达市场（Addressable Market）是否巨大，即 SEO 的可触达市场大吗？对于大多数类别来说，是的。第二是，你是否有权威性（Authority），是否有现有的牵引力（Traction）？如果你从零开始，没有任何牵引力——我们经常与种子轮和 A 轮公司交谈，通常他们没有太多的权威性，现在做 SEO 还太早。谷歌不希望你只是一个 SEO 网站，他们希望你在给你排名之前是一个可信的域名。如果你从零开始，他们没有足够的信号证明你是可信的。

---

### [00:39:33] Ethan Smith

**English:**
So the way that we assess that is, the first signal I'll look at is what's your traffic? What's your current traffic? And your non SEO traffic is actually an authority signal. So I'll go into SimilarWeb, I'll put the domain in, I'll look at the total traffic and I'll want to see at least I would say 1,000 visits a day roughly for non SEO at least, if you have five visits that that's very little. And then the second thing I'll look at is the number of referring domains. So I'll go into Ahrefs or Semrush and look up the total number of referring domains. I'll try to have at least 1,000 roughly referring domains. You could grow with less than that and less than 1,000 visits, but it's much harder. And the more you have, the easier it is to grow and the faster you can grow and the more you can grow.

**中文翻译:**
所以我们评估的方式是，我看到的第一个信号是：你的流量是多少？你目前的流量是多少？你的非 SEO 流量实际上是一个权威信号。我会进入 SimilarWeb，输入域名，查看总流量，我希望看到每天至少有大约 1000 次非 SEO 访问，如果你只有 5 次访问，那就太少了。第二件事我会看关联域名（Referring Domains）的数量。我会进入 Ahrefs 或 Semrush 查看关联域名的总数。我会尝试达到至少大约 1000 个关联域名。如果少于这个数或少于 1000 次访问，你也可以增长，但会难得多。你拥有的越多，增长就越容易，增长速度就越快，增长空间也就越大。

---

### [00:40:19] Ethan Smith

**English:**
And then in terms of the addressable market, that's a little bit more complicated, but most markets are pretty large actually in SEO, but we want it to be large. So With Power is actually an interesting example. So they're a clinical trial lead gen site. They want acquire people to take clinical trials. How many people are typing online, I want to take a clinical trial? Not very many. But the number of people that could be taking clinical trials is very large. And so if we target the persona, what's the key demographic of who might be a candidate for taking clinical trial? It's very, very large. So we can then create content that targets that, like gig economy or college students or people like that. So if you think about targeting the persona, most sites have a very large addressable market.

**中文翻译:**
至于可触达市场，这稍微复杂一点，但大多数市场在 SEO 方面实际上都相当大，而我们希望它大。With Power 是一个有趣的例子。他们是一个临床试验线索生成网站。他们想招募人们参加临床试验。有多少人在网上输入“我想参加临床试验”？并不多。但可能参加临床试验的人数非常多。所以如果我们针对“画像”（Persona），即可能成为临床试验候选人的关键人群统计数据是什么？那是巨大的。然后我们可以创建针对该人群的内容，比如零工经济从业者、大学生或类似的人。所以如果你考虑针对画像，大多数网站都有非常大的可触达市场。

---

### [00:41:08] Ethan Smith

**English:**
But the way that I would think about the addressable market is that which is what product am I offering? What are the use cases for that product? What is the persona? What's the size of that? And then I would assess that typically by looking at external benchmarks. So if I'm a shopping site and I haven't started yet, I can look at other shopping sites, I can see how much traffic they have. So again, I can go into SimilarWeb if I'm Wish.com and I want to see what my traffic potential is, I can put in Walmart and Wayfair, put it in SimilarWeb, look at their total traffic. SimilarWeb's free for all of this. And then I can get a sense of how big I can get.

**中文翻译:**
但我思考可触达市场的方式是：我提供什么产品？该产品的用例是什么？画像是什么？规模有多大？然后我通常会通过查看外部基准来评估。如果我是一个购物网站，还没开始做，我可以看其他购物网站，看他们有多少流量。同样，如果我是 Wish.com，想看我的流量潜力，我可以把沃尔玛和 Wayfair 输入 SimilarWeb，查看他们的总流量。SimilarWeb 对这些都是免费的。然后我就能感觉到我可以做多大。

---

### [00:41:47] Ethan Smith

**English:**
The one other thing I'll mention is that there are product competitors and audience competitors. So for something like, I'm at a WeWork right now. So for WeWork, I could look at the traffic for other rental office companies or I could look at companies that are ranking for the kinds of things that I would want to rank for. And they may not be direct product competitors. FinTech is interesting. So for Robinhood, Robinhood could look at other sites that allow you to sell stocks in crypto or they could look at Investopedia. Investopedia doesn't allow you to buy stocks, but they have a bunch of traffic. It's not a product competitor, but it's an audience competitor. And so these competitors basically can tell you what the size of that market is. So that's how I think about the addressable market. So ideally it's large, it typically is. And then the more authority I have, the more I can compete. If I'm starting from zero, it's probably too early. But once I have traction, SEO can then multiply that traction.

**中文翻译:**
我还想提的一点是，存在“产品竞争对手”和“受众竞争对手”。比如，我现在在 WeWork。对于 WeWork，我可以查看其他办公室租赁公司的流量，或者我可以查看那些在我想要排名的关键词下有排名的公司。它们可能不是直接的产品竞争对手。金融科技（FinTech）很有趣。对于 Robinhood，它可以看其他允许你买卖股票和加密货币的网站，或者也可以看 Investopedia。Investopedia 不允许你买股票，但他们有巨大的流量。它不是产品竞争对手，而是受众竞争对手。这些竞争对手基本上可以告诉你那个市场的规模。这就是我思考可触达市场的方式。理想情况下它很大，通常也确实很大。然后我拥有的权威性越多，我就越有竞争力。如果我从零开始，可能太早了。但一旦我有了牵引力，SEO 就可以成倍地放大这种牵引力。

---

### [00:42:41] Lenny

**English:**
We are now in the top three. Who could it be? Drum roll. The third most popular episode of the year at this point, Shreyas Doshi. Shreyas was a longtime PM at Stripe, before that he was a PM at Twitter at Google and is generally just an incredibly insightful and helpful human constantly sharing his wisdom on Twitter, and now he has his own course on Maven. Here is Shreyas describing the LNO framework, which people have brought up so many times after this episode and that I've personally found incredibly useful.

**中文翻译:**
我们现在进入前三名了。会是谁呢？鼓声响起。目前年度第 3 名最受欢迎的节目是 Shreyas Doshi。Shreyas 曾长期担任 Stripe 的产品经理，在此之前他是 Twitter 和谷歌的产品经理，他通常是一个非常有见地、乐于助人的人，经常在 Twitter 上分享他的智慧，现在他在 Maven 上有自己的课程。下面是 Shreyas 描述 LNO 框架，在这一集播出后，人们多次提到这个框架，我个人也觉得它非常有用。

---

### [00:43:14] Shreyas Doshi

**English:**
When I just joined Google as a relatively new PM, this is back in 2008, for the first three years I was overwhelmed and stressed. And that was because, one, I was a new PM in this really high performance environment. I was working on some important products and launches and I just had too much to do. And I look back at that time, and it was perhaps the most stressful time of my career. Where I would work long hours, et cetera, but even at the end of the day, I'd feel highly dissatisfied because my to-do list was endless and I wasn't able to make a dent on it. I was also a little bit of a perfectionist. So I was like, no, no, no, I need to do this well. And yeah, I was just constantly I would come home and talk to my wife and kind of basically just complain to her about how I'm not able to make progress or as much progress as I want. That was accompanied with not being able to sleep very well because I was concerned about how much output I was producing and whatnot. So again, very stressful time in my career.

**中文翻译:**
当我刚加入谷歌担任一名相对较新的产品经理时（那是 2008 年），前三年我感到不知所措且压力巨大。原因之一是，我是这个高绩效环境中的新产品经理。我负责一些重要的产品和发布，要做的事情太多了。回首那段时光，那可能是我职业生涯中最压力山大的时期。我会长时间工作，但即使在一天结束时，我仍感到极度不满，因为我的待办事项清单没完没了，我根本无法取得实质性进展。我还有点完美主义。所以我想：不，不，不，我需要把这件事做好。是的，我经常回家后和妻子聊天，基本上就是向她抱怨我无法取得进展，或者无法取得我想要的进展。伴随而来的是睡眠质量不佳，因为我担心自己的产出等等。所以，那是我职业生涯中非常压抑的时期。

---

### [00:44:28] Shreyas Doshi

**English:**
And then things changed when I discovered the ideas related to this LNO framework in a blog post. Unfortunately I can't even find that blog post somewhere, but it had some ideas that I took and then kind of created this LNO framework on myself, which is essentially that as a product manager or as anybody in a creative high impact, high leverage role, all your tasks are not created equal. There are actually three type of tasks that you end up doing in such a role.

**中文翻译:**
后来，当我在一篇博客文章中发现与这个 LNO 框架相关的想法时，情况发生了变化。不幸的是，我现在甚至找不到那篇博客了，但它包含了一些我采纳的想法，然后我自己创建了这个 LNO 框架。其核心本质是：作为一名产品经理，或者任何处于创造性、高影响力、高杠杆角色的人，你所有的任务并不是平等的。在这种角色中，你最终会做三类任务。

---

### [00:45:04] Shreyas Doshi

**English:**
So there are L tasks, which are leverage tasks. And the L tasks are such that when you put in a certain amount of effort, you get 10X or 100X in return in terms of impact. So those are L tasks, leverage tasks. Then there are neutral tasks, so that's N. And those are tasks where you basically get what you put in or just a little more than that. So you put in 1X and you get 1.1X. Those are neutral tasks. And then there are overhead tasks where you get back, again in terms of impact, you get back a lot less than you actually put in. And it turns out that many people, people who are ambitious or are perfectionists like myself, they by default treat each of these types of tasks the same way and therein lies the problem. So this was the epiphany for me back at Google when I kind of discovered some of these ideas.

**中文翻译:**
第一类是 L 任务，即杠杆任务（Leverage tasks）。L 任务的特点是，当你投入一定量的努力时，你会获得 10 倍或 100 倍的影响力回报。这就是 L 任务，高杠杆任务。第二类是中性任务，即 N（Neutral tasks）。这些任务基本上是你投入多少就得到多少，或者稍微多一点点。你投入 1 倍，得到 1.1 倍。这些是中性任务。第三类是日常开销任务，即 O（Overhead tasks），在影响力回报方面，你得到的远少于你实际投入的。事实证明，许多人，尤其是像我这样有野心或是完美主义者的人，默认情况下会以同样的方式对待每一类任务，问题就出在这里。这就是我在谷歌发现这些想法时的顿悟。

---

### [00:46:07] Shreyas Doshi

**English:**
What I realized that is that among the things in my to-do list, there are actually only very few L tasks. And so it made sense for me to focus a lot on those L tasks, to take on those L tasks when I was feeling most productive, most energetic during a certain time of the day. And, for the L tasks, let my inner perfectionist shine because I'm going to get so much more in return. It makes sense for me to spend that time on that PRD for instance, related to an important feature that will meaningfully impact our revenue. I'm going to spend more time on that than I ordinarily would. So now where does that more time come from? Because it cannot come from just working more hours. Well, it comes from spending less time on N tasks and O tasks. And so there are some tasks that you do, a classic example of an O task is say an expense report. It sounds silly, but I used to try to make my expense reports really good.

**中文翻译:**
我意识到，在我的待办事项清单中，实际上只有极少数的 L 任务。因此，对我来说，专注于这些 L 任务是有意义的，在一天中我感到最高效、精力最充沛的时候去处理这些 L 任务。而且，对于 L 任务，让我的内在完美主义尽情发挥，因为我会得到更多的回报。例如，花时间写一份与能显著影响收入的重要功能相关的 PRD（产品需求文档）是有意义的。我会在这上面花比平时更多的时间。那么，这些多出来的时间从哪里来呢？因为它不能仅仅来自延长工作时间。它来自减少在 N 任务和 O 任务上花费的时间。你做的一些任务中，O 任务的一个经典例子就是报销单。听起来很傻，但我以前曾试图把报销单做得非常完美。

---

### [00:47:16] Lenny

**English:**
Wow. That's funny.

**中文翻译:**
哇。那真有趣。

---

### [00:47:19] Shreyas Doshi

**English:**
Sometimes that made no sense. But I was like, no, no, no, I need to do that. And again, this is the silliest example, but there are many examples. And something I realized is that the same type of activity can actually be either an L task or an N task or an O task. So what's an example? So say like a classic PM activity of filing a bug report. And so many companies have these bug templates, et cetera, et cetera, like that you use to file a bug report. Well, it turns out that filing a bug report, depending on the situation, depending on what type of bug it is, can actually be an L task, high leverage task, and over there you want to file a very detailed explicit bug report. In other cases might actually be an O task, where you don't fill out the template that diligently and you don't add 15 screenshots with annotations, instead you just have one screenshot and you hit submit on the bug report. So that shift where usually for the same type of activity we provide the same type of engagement.

**中文翻译:**
有时那毫无意义。但我当时想：不，不，不，我必须那样做。再说一次，这是最傻的例子，但还有很多例子。我意识到的一点是，同一种类型的活动实际上既可以是 L 任务，也可以是 N 任务或 O 任务。举个例子？比如产品经理提交 Bug 报告的经典活动。很多公司都有 Bug 模板等等。事实证明，提交 Bug 报告根据情况和 Bug 的类型，实际上可以是一个 L 任务（高杠杆任务），在这种情况下，你希望提交一份非常详细、明确的 Bug 报告。但在其他情况下，它可能实际上是一个 O 任务，你不需要那么勤奋地填写模板，不需要添加 15 张带注释的截图，相反，你只需要一张截图，然后点击提交。这就是转变所在——通常对于同类型的活动，我们会投入同等程度的参与，但其实不应该。

---

### [00:48:30] Shreyas Doshi

**English:**
Last example I'll use to illustrate this is taking notes. It turns out even taking notes, taking notes, synthesizing them, and then sharing them can actually be an L task, an N task or an O task depending on what type of notes they are. After I understood this, previously I would just send all notes like I tried to make them really good, which took a lot of time. But then I realized, well, this is a meeting where, yes, I need to send notes, but it's just standard stuff. I just need to quickly list out, all people need to really know is the three action items that came out of the meetings, who owns them. That's it. And it is not about something highly strategic or controversial. Well, in that case, I'm just going to send the notes out the moment the meeting is over, I'm just going to hit send because I've already taken the action items. I'm not going to try to make my notes look great so that others can appreciate, oh Shreyas always sends great notes.

**中文翻译:**
我用来阐述这一点的最后一个例子是做笔记。事实证明，即使是做笔记、综合笔记然后分享，根据笔记的类型，也可以是 L 任务、N 任务或 O 任务。在我理解这一点之前，我会像以前一样发送所有笔记，并试图把它们做得非常好，这花费了很多时间。但后来我意识到，好吧，这是一个我需要发送笔记的会议，但它只是常规内容。我只需要快速列出大家真正需要知道的三个行动项，以及谁负责。就这样。它不涉及高度战略性或有争议的内容。在这种情况下，我会在会议结束的那一刻就把笔记发出去，直接点击发送，因为我已经记下了行动项。我不会试图让我的笔记看起来很棒，好让别人赞赏“哦，Shreyas 总是发送很棒的笔记”。

---

### [00:49:29] Shreyas Doshi

**English:**
On the other hand, if it was a product review with the CEO about a very contentious topic that you have gone back and forth multiple times and now you made a decision about something, you want to perfect those notes before you send them out. You want to get the language right, you want to be very clear on what the decision is so there's no room for misinterpretation so you don't backtrack afterwards. Or people say, well, but I thought we said this. So that's a case where it's an L task. And yeah, I would say just spend an hour or even two hours perfecting those notes because it's an L task. So hopefully that helps illustrate some of the ideas behind the LNO framework.

**中文翻译:**
另一方面，如果是与 CEO 进行的产品评审，涉及一个非常有争议的话题，你们已经来回讨论了多次，现在终于做出了决定，那么在发送笔记之前，你会想要完善它们。你希望措辞准确，希望非常清楚地说明决定是什么，这样就没有误解的空间，以后也不会反悔，或者有人说“好吧，但我以为我们是这么说的”。这就是 L 任务的情况。是的，我会说，花一个小时甚至两个小时来完善这些笔记，因为这是一个 L 任务。希望这有助于阐明 LNO 框架背后的一些想法。

---

### [00:50:13] Lenny

**English:**
Runner up for the most popular episode of the year is my conversation with Marty Cagan. Marty is the legend of legend of product managers. And I'm not surprised this episode was incredibly popular. Here are two my favorite clips for my chat with Marty. One talking about why big companies are just bad at product often. And two, the four steps to be a good product manager.

**中文翻译:**
年度最受欢迎节目的亚军是我与 Marty Cagan 的对话。Marty 是产品经理界传奇中的传奇。这一集非常受欢迎我一点也不意外。这里有两段我与 Marty 交谈中最喜欢的片段。一段是关于为什么大公司通常不擅长做产品，另一段是成为一名优秀产品经理的四个步骤。

---

### [00:50:36] Marty Cagan

**English:**
Steve Jobs shared his theory from 1995 for God's sake. His argument was, as a company gets bigger, product historically became less important. The people in a company that would be celebrated were marketing people, salespeople, finance people. Because if a company stops innovating, these are the engines for growth. Sales, marketing, or not growth with finance, but cutting cost. And his argument was this happens over time. Pretty soon, these are your leaders, they're the ones that have been promoted. So then what happens? Good product people don't want to work there anymore and they leave and they go to a company that values product. I think that's a better explanation than any other that I've heard. And it was so prescient because when he said this, this had yet to even happen to so many other companies, but it still happens all the time.

**中文翻译:**
看在上帝的份上，史蒂夫·乔布斯早在 1995 年就分享了他的理论。他的论点是，随着公司变大，从历史上看，产品变得不再那么重要。公司里受表彰的人变成了营销人员、销售人员和财务人员。因为如果一家公司停止创新，这些就是增长的引擎：销售、营销；或者财务带来的不是增长，而是削减成本。他的论点是，随着时间的推移，这种情况就会发生。很快，这些人就成了你的领导者，他们是获得晋升的人。然后会发生什么？优秀的产品人不想再在那里工作了，他们离开了，去了一家重视产品的公司。我认为这比我听过的任何其他解释都好。而且这非常有预见性，因为当他说这话时，许多其他公司还没发生这种情况，但现在这种情况仍然一直在发生。

---

### [00:51:47] Marty Cagan

**English:**
I hate the idea those companies that have separate product owners, because product owner is just an administrative role. Product owners almost never have the skills to be a product manager, and that's a problem. But let's just say there's a product manager and nobody's ever coached this poor person and so they really don't know much. So the first thing that product manager needs to do is get themselves prepared to contribute to their team the way they need to.

**中文翻译:**
我讨厌那些设立独立“产品负责人”（Product Owner）职位的公司，因为产品负责人只是一个行政角色。产品负责人几乎从不具备担任产品经理所需的技能，这就是问题所在。但假设有一名产品经理，从来没有人指导过这个可怜的人，所以他们真的不太懂。那么，产品经理需要做的第一件事就是让自己做好准备，以团队需要的方式为团队做出贡献。

---

### [00:52:14] Marty Cagan

**English:**
In general, that means four things. First of all, they have to really get to know the users and customers. The second thing is they have to be an expert in the data. How is your product used? How is that change over time? What's the sales analytics? What's the user analytics? The third thing is, and this is usually the hardest one and it's the one that your stakeholders will judge you on, is you have to learn the different parts of the business. You have to know how it's marketed, how it's sold, how it's paid for, how it monetizes. If there are any compliance, regulatory, privacy, security issues, you need to know what those are. So that you have to convince those stakeholders that you understand what the issues are and you understand what to look for and that you convince them that if there's ever any question you will bring them a prototype that they can see and make sure it's okay. So you need that trust with the different parts of the business. The fourth area is you have to know the competitive landscape, you have to know the industry, you have to know the trends.

**中文翻译:**
总的来说，这意味着四件事。首先，他们必须真正了解用户和客户。第二件事是，他们必须成为数据专家。你的产品是如何被使用的？随着时间的推移发生了什么变化？销售分析是什么？用户分析是什么？第三件事，通常也是最难的一件，也是你的利益相关者会评判你的一点，就是你必须学习业务的不同部分。你必须知道它是如何营销的、如何销售的、如何支付的、如何变现的。如果存在任何合规、监管、隐私、安全问题，你需要知道这些是什么。这样你才能说服那些利益相关者，让你理解问题所在，知道该寻找什么，并让他们相信，如果以后有任何疑问，你会给他们看一个原型，让他们确认没问题。所以你需要与业务的不同部门建立这种信任。第四个领域是，你必须了解竞争格局，必须了解行业，必须了解趋势。

---

### [00:53:20] Marty Cagan

**English:**
Those are the four things you bring to the team. Realize the designer doesn't have this info, the engineers don't have this info. If the team is going to be an empowered team and they're going to come up with solutions, they need somebody on the team that brings this knowledge, and that is you as product manager. That is the single biggest area empowered teams fall down, the product manager is ill-equipped, or a nice way of saying incompetence.

**中文翻译:**
这就是你带给团队的四样东西。要意识到设计师没有这些信息，工程师也没有这些信息。如果团队要成为一个赋能型团队（Empowered Team）并提出解决方案，他们需要团队中有人带来这些知识，而那个人就是作为产品经理的你。这是赋能型团队失败的最大原因：产品经理准备不足，或者委婉点说，不称职。

---

### [00:53:49] Lenny

**English:**
And finally our number one most downloaded, most popular episode of the year, which raced to number one as soon as they came out, is with the one and only Matt Mochary. Matt is a full-time CEO coach. He's worked with CEOs of companies like OpenAI, Coinbase, Notion, Rippling, Angellist, so many other amazing folks that I could just keep listing. In this episode. There are just so many nuggets of wisdom, and I could share 100 clips from just this one episode, but I'm going to choose just two. One, the power of small teams and how small teams often get more work done. And two, advice for having hard conversations with your employees and with people in general. Enjoy.

**中文翻译:**
最后，我们年度下载量最高、最受欢迎的第一名节目，一经发布就冲到了榜首，那就是与独一无二的 Matt Mochary 的对话。Matt 是一名全职的 CEO 教练。他曾与 OpenAI、Coinbase、Notion、Rippling、Angellist 等公司的 CEO 合作过，还有许多其他了不起的人，我可以一直列举下去。在这一集中，智慧的结晶实在太多了，仅仅这一集我就可以分享 100 个片段，但我只选两个。第一，小团队的力量，以及小团队通常如何完成更多工作。第二，关于如何与员工以及普通人进行艰难对话的建议。请欣赏。

---

### [00:54:31] Matt Mochary

**English:**
My companies have done a lot of layoffs, and here's why, the companies that I coached. Back in March of 2020, there was a chance that the world economy was imploding. Now, of course, by April and May we realized that wasn't the case, that the tech world kept going. In fact, it was even flourishing. But in March of 2020 we didn't know that. And so if you were being fiscally responsible, you needed to prepare for that eventuality, so you needed pare costs. 80% of costs in any tech company is payroll, is humans. So if you're going to pare costs, you actually have to let go of humans. So almost every one of my companies did, some on the low side of 5%, some on the high side of one company that was is a hotel company let go of 40% because that looks like their business was about to get obliterated. The results were crazy.

**中文翻译:**
我指导过的公司进行过很多次裁员，原因如下。回到 2020 年 3 月，当时世界经济有崩溃的可能。当然，到了 4 月和 5 月，我们意识到情况并非如此，科技界仍在继续运转，事实上甚至还在蓬勃发展。但在 2020 年 3 月，我们并不知道这一点。所以如果你要对财务负责，你需要为那种可能性做准备，所以你需要削减成本。任何科技公司 80% 的成本都是工资，也就是人。所以如果你要削减成本，你实际上必须裁员。所以我指导的几乎每一家公司都裁员了，有的裁了 5%，有的裁得很多，有一家酒店公司裁了 40%，因为看起来他们的业务快要被抹杀了。结果非常疯狂。

---

### [00:55:29] Matt Mochary

**English:**
Within 60 days of each layoff, the CEO reported back to me, it's insane, I don't know how this happened, but the company's now operating better. I'm not talking on a relative scale. I'm talking on an absolute scale. We're putting out more features, more code, our NPS is up. Whatever it is, what whatever department is performing better. And the only answer for it was we've got less people. So it's this coordination, issue is reduced with fewer people in the organization things work better. That's the big realization that most people never discover. So they hit product market fit, they get tons of money for investors, nudged higher, higher, higher, higher. But every additional human you have in your organization causes extra overhead and geometrically so, because now that you have to keep all those people informed, give them all context, make them all feel heard. Because unless they feel like they're contributing and you understand what they're saying, then they feel ignored and they feel passed over and they feel disrespected and grumpy.

**中文翻译:**
在每次裁员后的 60 天内，CEO 都会向我报告：这太疯狂了，我不知道是怎么发生的，但公司现在的运作更好了。我说的不是相对规模，而是绝对规模。我们发布了更多功能，写了更多代码，我们的 NPS（净推荐值）上升了。无论是什么，无论哪个部门的表现都更好了。唯一的答案就是：我们的人变少了。所以，随着组织中人数的减少，协调问题减少了，事情运作得更顺畅了。这是大多数人从未发现的重大感悟。他们实现了产品市场匹配（PMF），从投资者那里拿到了大量的钱，然后不断地招人、招人、招人。但你组织中每增加一个人，都会带来额外的开销，而且是几何级数的增加，因为现在你必须让所有这些人都知情，给他们所有的背景信息，让他们感到被倾听。因为除非他们觉得自己在做贡献，并且你理解他们在说什么，否则他们会感到被忽视、被冷落、不被尊重，从而变得脾气暴躁。

---

### [00:56:36] Matt Mochary

**English:**
So there's this morale problem that exists. So there's this friction of information flow and a morale problem that grows and grows and grows. And really the only answer is, I mean, that's why people bring me in because they're growing, growing, growing, and things are breaking. So I have a system that keeps things together. But it doesn't make it like perfect, it just makes it so that the company doesn't fall apart. But really the ideal is just to keep the team super small. And that's what WhatsApp did. That's what Instagram did. That's what Linear is doing right now. That's what Notion has been doing for a while. And those to me are the real success stories.

**中文翻译:**
所以存在这种士气问题。信息流动的摩擦和士气问题会不断增长。真正的答案是——我是说，这就是人们请我来的原因，因为他们一直在扩张，而事情正在崩溃。所以我有一套系统来维持局面。但它并不能让事情变得完美，它只是让公司不至于散架。但真正的理想状态是保持团队极小。这就是 WhatsApp 所做的，这就是 Instagram 所做的，这就是 Linear 正在做的，这也是 Notion 已经做了一段时间的事情。对我来说，这些才是真正的成功案例。

---

### [00:57:17] Matt Mochary

**English:**
Whenever I have a difficult conversation I start it off, hey, this is going to be a difficult conversation. I want you to take a few seconds and prepare yourself. You are not going to enjoy this. What I found is that the way the amygdala gets triggered is often because of surprise. So if you give someone just a few seconds to mentally prepare, then the amygdala often doesn't get triggered nearly as hard because if they're aware that they're going to go into fear, if they're going to go into anger, they're going to go into sadness, then they can see it coming and they go, oh, that's what it is. But if they don't see it coming, just surprise and all of a sudden, it grips their whole brain and now they're in it and they don't even know they're in it. So, that's the first thing I do. This is going to be a difficult conversation. Are you ready? Person says yes. Then I share the news. I'm letting you go. Here's why, da, da, da.

**中文翻译:**
每当我进行艰难的对话时，我都会这样开头：“嘿，这将是一次艰难的对话。我希望你花几秒钟时间准备一下。你不会喜欢接下来的内容的。”我发现，杏仁核（Amygdala）被触发通常是因为“意外”。所以，如果你给某人几秒钟的时间进行心理准备，那么杏仁核通常不会被触发得那么剧烈。因为如果他们意识到自己将进入恐惧、愤怒或悲伤的状态，他们就能预见到它的到来，并想：“哦，原来是这样。”但如果他们没有预见到，仅仅是意外，突然之间，情绪就会占据他们的整个大脑，他们深陷其中，甚至不知道自己已经陷进去了。所以，这是我做的第一件事：“这将是一次艰难的对话。你准备好了吗？”对方说准备好了。然后我分享消息：“我要解雇你。原因是……”等等。

---

### [00:58:14] Matt Mochary

**English:**
Then the second, I deliver the message. The third thing is now they're feeling emotions, strong ones. Even though I warned them, they're still feeling them. Now, you want them to be able to release those emotions. And so I say to them, my guess is you're feeling a lot of anger right now, fear, sadness. Is that true? And if so, would you be willing to share with me what you're feeling and what you're thinking? And sometimes they don't answer but many times they do and they share with me and they let it out, and that's important to allow them to let it out. And then I make them feel heard and I actively listen, and that makes them realize that I'm not trying to run away from the pain that they're feeling. I'm not trying to leave them alone with it. I sit with them as they have it, and then I try to help them get through it.

**中文翻译:**
第二步，我传达信息。第三件事是，现在他们正感受到强烈的情绪。尽管我警告过他们，他们仍然会有这种感觉。现在，你希望他们能够释放这些情绪。所以我对他们说：“我猜你现在感到非常愤怒、恐惧、悲伤。是这样吗？如果是的话，你愿意和我分享你的感受和想法吗？”有时他们不回答，但很多时候他们会回答，他们会向我倾诉并释放出来，让他们释放出来是很重要的。然后我让他们感到被倾听，我积极倾听，这让他们意识到我并没有试图逃避他们正在感受的痛苦。我没有试图让他们独自承受。当他们痛苦时，我陪着他们，然后我试着帮助他们度过难关。

---

### [00:59:06] Lenny

**English:**
And that's our top 10. It was actually really hard to make this list because all 50 episodes have something really fascinating and interesting to share. For example, if you need help with pricing strategy, don't miss the Modavon episode. If you want to get better at communication, don't miss the episode of West Cow. If you're building a marketplace, there's the Hockenmaier episode. If you're trying to figure out your marketing and how to build your marketing function, don't miss the episodes with Emily Kramer and Ariel Jackson. I could keep going, but I'm just going to stop here. I encourage you to check out the full list of episodes in case you're currently facing a problem that one of the episodes can solve.

**中文翻译:**
这就是我们的前 10 名。制作这个名单实际上非常困难，因为所有 50 集都有非常迷人和有趣的内容可以分享。例如，如果你在定价策略方面需要帮助，不要错过 Madhavan 的那一集。如果你想提高沟通能力，不要错过 Wes Kao 的那一集。如果你正在构建一个双边市场，有 Hockenmaier 的那一集。如果你正试图弄清楚你的营销以及如何构建营销职能，不要错过与 Emily Kramer 和 Ariel Jackson 的对话。我可以一直说下去，但我还是停在这里吧。我鼓励你查看完整的剧集列表，以防你目前正面临某个剧集可以解决的问题。

---

### [00:59:40] Lenny

**English:**
To close, this podcasting journey has been so much more fulfilling and exciting and interesting than I ever expected, and I'm so thankful for you for listening and for supporting this podcast, telling your friends about it. I'm also really thankful to our wonderful sponsors for supporting this work. In terms of what's ahead, basically more the same. More amazing guests, more topics that maybe you haven't thought about, that you need help with, maybe more amazing topics that you know need help with that I want to help you solve. I'm still learning how to interview, how to do this podcast, how to make it more amazing, and so my goal is just to continue to refine and iterate and continue making this podcast better and better.

**中文翻译:**
最后，这段播客之旅比我预想的要充实、兴奋和有趣得多。我非常感谢你们的收听和支持，感谢你们把这个播客推荐给朋友。我也非常感谢我们优秀的赞助商对这项工作的支持。至于未来，基本上还是老样子：更多了不起的嘉宾，更多你可能没想过但需要帮助的话题，或者更多你知道需要帮助而我想帮你解决的话题。我仍在学习如何采访，如何做这个播客，如何让它更出色。所以我的目标就是继续改进和迭代，让这个播客变得越来越好。

---

### [01:00:22] Lenny

**English:**
With that, I'd love to hear from you. What do you love about this podcast? What do you hate about the podcast? What annoys you? What do you find most interesting? I'd love to hear your feedback. You can either email me at podcast@lennyrichards.com. You can also go to this episode on my newsletter, if you go to lennysnewsletter.com and find this episode, you can leave a comment at the bottom of that episode. You can also DM me on Twitter if you just want to reach out directly. Seriously, I'd love to hear from you. This is how I'm going to make this podcast better. Until then, happy holidays. Happy New Year. From the bottom of my heart, thank you for listening and for supporting this podcast. I'll see you next year.

**中文翻译:**
说到这里，我很想听听你们的想法。你喜欢这个播客的什么？你讨厌这个播客的什么？什么让你感到烦恼？你觉得什么最有趣？我很想听听你的反馈。你可以发邮件给我：podcast@lennyrichards.com。你也可以在我的新闻通讯中找到这一集，访问 lennysnewsletter.com 找到这一集，在底部留言。如果你想直接联系我，也可以在 Twitter 上私信我。说真的，我很想听听你的意见。这就是我让这个播客变得更好的方式。在那之前，祝大家节日快乐，新年快乐。由衷地感谢你们的收听和支持。我们明年见。