# Eric Ries - 双语对照

This bilingual document captures the key insights from Lenny’s Podcast featuring Eric Ries, the pioneer of the Lean Startup movement.

---

## Podcast: Lenny's Podcast
## Guest: Eric Ries (Founder of the Lean Startup Movement)

---

### [00:00:00] Eric Ries

**English:**
People act like having a startup fail is the worst thing that can happen to you. And man, that's not even in the top 10. It's bad, I've done it, it's awful. It's really bad, but far worse is to be in a company that won't die, a zombie, undead company that you hate, but you can't leave. Oof, have I met people like that, and we're having a mental health crisis among founders that's not talked about enough. People have started to talk about the downside mental health risk, obviously the stress of being a founder is hard, but look what's happening to the people that are so-called successes? When you build a company and you sell it out and it becomes something that you find abhorrent, man, maybe you get rich, but it's not good. And so building a company you hate, that becomes a maligned force in the world, that you have to go pretend you weren't involved with or like you feel complicit in... That's way, way worse, and I wish more founders would take that more seriously early on.

**中文翻译:**
人们总觉得创业失败是天大的事，但伙计，那甚至排不进“最惨遭遇”的前十名。失败确实很糟，我也经历过，那种感觉很痛苦。但真正糟糕得多的是待在一家“死不掉”的公司里——那种你讨厌却又无法离开的“僵尸企业”。我见过太多这样的人了。现在创始人圈子里存在着一种被低估的心理健康危机。大家开始讨论创业失败带来的心理风险，显然当创始人的压力很大，但看看那些所谓的“成功人士”呢？当你创办了一家公司，最后把它卖掉，结果它变成了一个让你感到厌恶的东西，伙计，也许你变富有了，但这感觉并不好。亲手建立一家你讨厌的公司，看着它变成世界上的一种负面力量，而你不得不假装自己从未参与其中，或者感到自己助纣为虐……那才真的要糟糕得多。我希望更多的创始人在创业初期能更严肃地对待这个问题。

---

### [00:00:58] Lenny

**English:**
Today, my guest is Eric Ries. If you're not familiar with his work, I would be shocked. He is most famous for creating the Lean Startup methodology and movement and also his incredibly influential book, The Lean Startup. He also coined more terms and concepts that are part of the tech culture than anyone I could think of. He currently spends his time advising founders and startups. He was a former founder and CTO, and currently is the founder and executive chairman of the Long-Term Stock Exchange.

**中文翻译:**
今天的嘉宾是埃里克·莱斯（Eric Ries）。如果你不熟悉他的作品，我会感到非常惊讶。他最著名的成就是开创了“精益创业”（Lean Startup）方法论和运动，并撰写了极具影响力的著作《精益创业》。他创造的术语和概念比我能想到的任何人都多，这些词汇早已成为科技文化的一部分。他目前致力于为创始人和初创企业提供咨询。他曾是一位创始人和首席技术官（CTO），目前是长期证券交易所（LTSE）的创始人兼执行主席。

---

### [00:05:10] Eric Ries

**English:**
If you can believe it, The Lean Startup came out in 2011, so it's been a little while now and it's been such a crazy ride. And basically every year since it came out, I keep thinking, "All right, that's the end. Surely that's enough." And just each year it gets crazier and crazier, and new things come my way. So, I'm building the Long-Term Stock Exchange, LTSE, I'm sure we'll talk about, and I spend a lot of time still with founders and with big company execs trying to answer their questions about how to build companies in the right way. Obviously, been sucked into a lot of AI stuff of late, as everybody is, and one of the interesting things that actually surprised me is I spent a lot of time the last 10 years working on the issues of governance and corporate governance and how companies should be structured, not really with an eye towards technology in particular, but just with long-termism and humanism really at its core, and it turns out that those questions have just become really acute for AI companies.

**中文翻译:**
信不信由你，《精益创业》是2011年出版的，到现在已经有一段时间了，这段旅程非常疯狂。基本上自出版以来的每一年，我都在想：“好了，到此为止吧，这已经足够了。”但每一年情况都变得越来越疯狂，总有新事物找上门来。目前我正在筹建长期证券交易所（LTSE），稍后我们肯定会聊到。我仍然花大量时间与创始人和大公司高管交流，回答关于如何以正确方式建立公司的问题。显然，最近我也像大家一样卷入了AI浪潮。让我感到惊讶的一点是，过去10年我花了很多时间研究治理和公司治理（Corporate Governance）以及公司架构问题，初衷并非针对技术，而是核心关注长期主义和人本主义。结果证明，这些问题现在对AI公司来说变得异常迫切。

---

### [00:07:13] Lenny

**English:**
Something I wanted to mention is I feel like people don't give you enough credit for how many core concepts of startups and product building you've either invented or popularized. So what I know, obviously Lean methodology, then there's the term MVP, then there's the term pivot, and then also I think A/B testing, customer development, continuous deployment, vanity metrics as a term, I'm guessing there's many more, and then the Long-Term Stock Exchange. And I think the theme I get from this is there's a lot of first principles thinking that you've done...

**中文翻译:**
我想提的一点是，我觉得人们并没有给予你足够的赞誉，因为你发明或推广了太多创业和产品构建的核心概念。据我所知，显然有精益方法论，然后是 MVP（最小可行性产品）这个词，还有 Pivot（转型/转向），此外还有 A/B 测试、客户开发（Customer Development）、持续部署（Continuous Deployment）、虚荣指标（Vanity Metrics）等等，我猜还有更多，再加上长期证券交易所。我认为这背后的主题是你做了大量的“第一性原理思维”（First Principles Thinking）……

---

### [00:10:44] Eric Ries

**English:**
I realized looking back, I didn't have this understanding at the time, but looking back, I feel like first principles thinking, it really has two components that people pretend are one thing, and it's more one than the other. A lot of my work is just descriptive. It's not actually telling people what to do, it's simply giving a name and a concept to a thing that already happens. That's the funniest part. In the early wave of criticism against Lean Startup, people were very angry at the idea that I was saying that a startup is an experiment... It's like, "well, I'm not telling you that you should pivot. I'm just saying that is what it's called when you change the strategy, but try to have fidelity to the vision." It needs a name because we do it all the time and even when we don't do it, we talk about doing it.

**中文翻译:**
回过头来看，我当时并没有意识到这一点，但现在我觉得“第一性原理思维”其实包含两个部分，人们常把它们混为一谈。我的很多工作其实只是“描述性”的（Descriptive）。我并不是在教人们该做什么，而只是给已经发生的事情起个名字、定个概念。这是最有趣的地方。在早期批评《精益创业》的浪潮中，人们对我把创业比作“实验”感到非常愤怒……就像“转型”（Pivot）这个词，我并不是在告诉你“你应该转型”，我只是说，当你改变策略但仍试图忠于愿景时，这种行为就叫“转型”。它需要一个名字，因为我们一直在做这件事，即使不做，我们也在讨论它。

---

### [00:14:21] Eric Ries

**English:**
We used to do a Lean Startup conference every year... I remember the first conferences we did, the first events we did had the feeling of a religious revival. People were like, "We've got the new thing. We are going to stick it to the man." And I really thought, "My job is going to be to lead these hordes into battle." ... We charge onto the field and no other army ever came to charge us back, just we won by default because the people who were doing it the old way didn't really like it or want... It was very few defenders of the old way. There were very few people who came out and said, "Actually, no, Stage-Gate is actually still the correct product idea. You've got it wrong." It never happened, and in fact, the fancy startup people went from dismissing it as totally pointless to complaining that it was overhyped and over before ever passing through the intervening stage of finding out what it was.

**中文翻译:**
我们以前每年都举办精益创业大会……我记得最初的几次活动感觉就像宗教复兴一样狂热。人们会说：“我们掌握了新武器，我们要反抗旧体制。”我当时真以为我的工作是带领这群人冲锋陷阵。结果我们冲上战场，却发现根本没有敌军反击。我们是不战而胜，因为那些用老一套方法做事的人其实也不喜欢旧方法。几乎没有人站出来捍卫旧秩序，没人说：“不，阶段门径管理法（Stage-Gate）才是正确的产品理念，你错了。”这种情况从未发生。事实上，那些时髦的创业者们直接从“不屑一顾”跳到了“抱怨它被过度炒作”，甚至都没经历过中间那个“搞清楚它到底是什么”的阶段。

---

### [00:24:39] Eric Ries

**English:**
Oh man, I would change everything about it [the book]. It's actually why I won't let myself do it... The one that is the most glaring to me... I'm a little embarrassed, there's a chapter towards the end of the book where I talk about the scaling of Lean Startup... It makes it sound so easy and so simple. And of course, I've subsequently written a whole book longer than Lean Startup just to illuminate those principles... And the other funny bit is... I feel like that is the meme of our time for the tech industry. Every company was about changing the world and we forgot to ask, "for the better?" ... Right in the introduction of Lean Startup, one of the... It's like a throwaway line, "This is the technique that will give the entrepreneurs of tomorrow the tools they need to change the world." And I'm like, "No, I should have said for the better. I didn't know I had to say it. I thought it was obvious."

**中文翻译:**
噢伙计，关于这本书，我想改动的地方太多了。这也是为什么我不让自己去改的原因。对我来说最明显的一点是……我有点尴尬，书末尾有一章讲的是精益创业的规模化（Scaling）。我把它写得听起来太容易、太简单了。当然，后来我专门写了一本比《精益创业》还长的书来阐述这些原则。另一个有趣的点是……我觉得这是我们这个时代科技行业的梗：每家公司都说要“改变世界”，但我们忘了问：“是向好的方向改变吗？”在《精益创业》的序言里，有一句随口写的话：“这种技术将为未来的企业家提供改变世界所需的工具。”我现在想：“不，我应该加上‘向善’（for the better）。我当时不知道必须强调这一点，我以为这是显而易见的。”

---

### [00:28:22] Eric Ries

**English:**
I love that question because first of all, I get it a lot... MVP is simply for whatever the hypothesis is that we're trying to test, what is the most efficient way to get the validation we need about whether a hypothesis is true or not? ... So, let's grant the premise of the question that expectations are high, and if we launch an app and it doesn't meet people's expectations, they won't like it. First of all, what really are the consequences of that? ... You can launch the product to customers without telling anybody that you did that. It's okay. No one's going to find out... But the other thing that I think people don't appreciate is that MVP is very flexible. So, if you tell me... "the bar is here and the thing just has to be that good." I'm like, "Excellent, and it can't have very many features, I guess, can it?" ... "So, you just told me the bar is way up there, so we better do just the one critical feature at that level of quality."

**中文翻译:**
我很喜欢这个问题，因为我经常被问到。MVP（最小可行性产品）的核心仅仅是：针对我们想要测试的任何假设，什么是获取验证（验证假设是否成立）最有效的方式？让我们假设前提成立：用户预期很高，如果我们发布一个达不到预期的 App，用户就不会喜欢。但首先，这会有什么严重的后果吗？你可以向客户发布产品，而不必大张旗鼓地告诉所有人。没关系的，没人会发现。另一点人们没意识到的是，MVP 是非常灵活的。如果你告诉我：“门槛就在这，产品必须达到这个水准。”我会说：“太棒了，那它肯定不能有太多功能，对吧？”既然你说明门槛很高，那我们就只做一个核心功能，并把它做到那个高质量水准。