# Ethan Smith - 双语对照

# Lenny's Podcast: Ethan Smith - AEO & The Future of SEO
## 播客：Lenny's Podcast | 嘉宾：Ethan Smith

---

### (00:00:00) Lenny Rachitsky

**English:**
There's this term everyone's hearing about, AEO.

**中文翻译:**
现在大家都在听一个词，叫 AEO（回答引擎优化）。

---

### (00:00:02) Ethan Smith

**English:**
Answer Engine Optimization is how do I show up in LLMs as an answer?

**中文翻译:**
回答引擎优化（Answer Engine Optimization）研究的是：我该如何作为答案出现在大语言模型（LLMs）中？

---

### (00:00:06) Lenny Rachitsky

**English:**
It feels like such a big deal to win at AEO.

**中文翻译:**
感觉在 AEO 领域胜出是一件非常有影响力的大事。

---

### (00:00:09) Ethan Smith

**English:**
In order to win something like what's the best website builder? At Google, they would win if their blue link showed up first. (00:00:15): But that's not the case in the LLM, because the LLM is summarizing many citations, and so you need to get mentioned as many times as possible.

**中文翻译:**
为了在像“最好的网站搭建工具是什么？”这样的问题中胜出，在 Google 时代，如果你的蓝色链接排在第一，你就赢了。(00:00:15): 但在大语言模型中情况并非如此，因为模型是在总结多个引用来源（citations），所以你需要被尽可能多地提及。

---

### (00:00:21) Lenny Rachitsky

**English:**
ChatGPT is driving more traffic to my newsletter than Twitter.

**中文翻译:**
ChatGPT 给我的时事通讯（Newsletter）带来的流量已经超过了 Twitter。

---

### (00:00:25) Ethan Smith

**English:**
You can get mentioned by a citation tomorrow and start showing up immediately. You can have a Reddit thread, you can have a YouTube video. (00:00:31): You can be mentioned on a blog. So early-stage companies can win, they can win quickly.

**中文翻译:**
你可能明天被某个引用源提到，然后立刻就开始出现在答案里。你可以通过一个 Reddit 帖子，或者一段 YouTube 视频实现。(00:00:31): 你也可以在博客上被提及。所以初创公司也能赢，而且能赢得很迅速。

---

### (00:00:36) Lenny Rachitsky

**English:**
Are the leads that these answer engines are driving to companies actually valuable?

**中文翻译:**
这些回答引擎为公司带来的潜在客户（Leads）真的有价值吗？

---

### (00:00:41) Ethan Smith

**English:**
Significantly more valuable. Webflow saw a 6X conversion rate difference between LLM traffic and Google Search traffic.

**中文翻译:**
价值要高得多。Webflow 发现，大语言模型带来的流量转化率是 Google 搜索流量的 6 倍。

---

### (00:00:48) Lenny Rachitsky

**English:**
A lot of people are seeing this as everything is different. Nothing we've done before is going to work. We have to rethink everything.

**中文翻译:**
很多人觉得现在一切都变了，以前做的那套都没用了，我们必须重新思考所有事情。

---

### (00:00:53) Ethan Smith

**English:**
There's significant misinformation on AEO. There's news articles about how Google Search is going to die because there's a new thing. (00:01:00): Google's slice of the pie stays the same. The pie gets bigger.

**中文翻译:**
关于 AEO 存在大量的误导信息。有很多新闻文章说 Google 搜索要完蛋了，因为出现了新事物。(00:01:00): 实际上，Google 分到的蛋糕份额没变，只是整个蛋糕变大了。

---

### (00:01:05) Lenny Rachitsky

**English:**
Today my guest is Ethan Smith. Ethan is the CEO of Graphite and my go-to expert for all things SEO. SEO is going through a major transition right now. Everyone used to go to Google anytime they had a question, or were looking for a product or doing research. These days, a lot of people are moving to ChatGPT and Claude, and Gemini and Perplexity to get answers to their questions, and this will only be accelerating over time. (00:01:29): And even Google is changing the search experience in a pretty radical way with AI Overviews at the top, and their newly introduced AI Mode, which is basically their own version of ChatGPT. This means that the world of SEO is going through a big change, including the rise of AEO, which stands for Answer Engine Optimization. Basically, SEO for ChatGPT, getting your product to show up in the answers that people get. (00:01:51): Ethan has been at the forefront of this new skill and channel. And in this conversation, he shares everything that he's learned about how to get your product to show up more often inside of the answers that people get. The advice that Ethan shares in this conversation is incredibly tactical and worth a lot of money. So please slurp it up and use it for your own products. (00:02:10): If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube, it helps tremendously. And if you become an annual subscriber of my newsletter, you get a year free of 15 incredible products, including Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD and Mobbin. (00:02:29): Check it out at lennysnewsletter.com and click product pass. With that, I bring you Ethan Smith. This episode is brought to you by Orkes, the company behind Open Source Conductor. The orchestration platform powering modern enterprise apps and agentic workflows. Legacy automation tools can't keep pace. (00:02:47): Siloed, low-code platforms, outdated process management and disconnected API tooling falls short in today's event-driven, AI-powered agentic landscape, Orkes changes this. With Orkes Conductor, you gain an agentic orchestration layer that seamlessly connects humans, AI agents, APIs, microservices, and data pipelines in real time at enterprise scale. (00:03:07): Visual and code-first development, built-in compliance, observability and rock-solid reliability ensure workflows evolve dynamically with your needs. It's not just about automating tasks, it's orchestrating autonomous agents in complex workflows to deliver smarter outcomes faster. Whether modernizing legacy systems or scaling next-gen, AI-driven apps, Orkes accelerates your journey from idea to production. (00:03:31): Learn more and start building at Orkes.io/Lenny. That's O-R-K-E-S.I-O/Lenny. My podcast guest and I love talking about craft and taste, and agency and product market fit. You know what we don't love talking about? SOC 2. That's where Vanta comes in. Vanta helps companies of all sizes get compliant fast and stay that way, with industry-leading AI, automation and continuous monitoring. (00:03:56): Whether you're a startup tackling your first SOC 2 or ISO 27001, or an enterprise managing vendor risk, Vanta's trust management platform makes it quicker, easier, and more scalable. Vanta also helps you complete security questionnaires up to five times faster so that you can win bigger deals sooner. The result? (00:04:14): According to a recent IDC study, Vanta customers slashed over $500,000 a year and are three times more productive. Establishing trust isn't optional, Vanta makes it automatic. Get $1,000 off at Vanta.com/Lenny. Ethan, thank you so much for being here and welcome to the podcast. Welcome back to the podcast.

**中文翻译:**
今天的嘉宾是 Ethan Smith。Ethan 是 Graphite 的 CEO，也是我在 SEO 领域首选的专家。SEO 正在经历一场重大转型。以前，大家有问题、找产品或做研究都会去 Google。而现在，越来越多的人转向 ChatGPT、Claude、Gemini 和 Perplexity 来获取答案，而且这种趋势只会随时间加速。(00:01:29): 甚至 Google 也在以激进的方式改变搜索体验，在顶部推出了 AI 概览（AI Overviews），以及新推出的 AI 模式（基本上就是他们版的 ChatGPT）。这意味着 SEO 世界正在发生巨变，包括 AEO 的兴起，即“回答引擎优化”。简单来说，就是针对 ChatGPT 的 SEO，让你的产品出现在人们得到的答案中。(00:01:51): Ethan 一直处于这一新技能和新渠道的最前沿。在这次对话中，他分享了关于如何让你的产品更多地出现在 AI 答案中的所有心得。Ethan 分享的建议极具实操性，价值不菲。所以请仔细吸收并应用到你自己的产品中。(00:02:10): 如果你喜欢这个播客，别忘了在应用或 YouTube 上订阅关注，这对我们帮助很大。如果你成为我 Newsletter 的年度订阅者，你可以免费获得 15 款出色产品的一年使用权，包括 Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD 和 Mobbin。(00:02:29): 请访问 lennysnewsletter.com 并点击 product pass 查看。现在，让我们欢迎 Ethan Smith。本集由 Orkes 赞助，它是开源项目 Conductor 背后的公司。Orkes 是驱动现代企业应用和智能体（agentic）工作流的编排平台。传统的自动化工具已经跟不上节奏了。(00:02:47): 孤立的低代码平台、过时的流程管理和脱节的 API 工具在当今事件驱动、AI 驱动的智能体格局中显得力不从心，Orkes 改变了这一点。通过 Orkes Conductor，你将获得一个智能体编排层，在企业规模下实时无缝连接人类、AI 智能体、API、微服务和数据管道。(00:03:07): 视觉化和代码优先的开发模式、内置的合规性、可观测性和极高的可靠性，确保工作流随你的需求动态演进。这不仅仅是自动化任务，而是编排复杂工作流中的自主智能体，以更快地交付更智能的结果。无论是现代化遗留系统还是扩展下一代 AI 驱动的应用，Orkes 都能加速你从想法到生产的过程。(00:03:31): 访问 Orkes.io/Lenny 了解更多并开始构建。我和我的播客嘉宾都喜欢聊工艺、品味、自主性和产品市场契合度（PMF）。你知道我们不喜欢聊什么吗？SOC 2 合规。这就是 Vanta 大显身手的地方。Vanta 通过行业领先的 AI、自动化和持续监控，帮助各种规模的公司快速获得并保持合规。(00:03:56): 无论你是正在处理第一个 SOC 2 或 ISO 27001 的初创公司，还是管理供应商风险的企业，Vanta 的信任管理平台都能让过程更快捷、更简单、更具扩展性。Vanta 还能帮你完成安全问卷的速度提升高达 5 倍，助你更快达成大单。结果如何？(00:04:14): 根据 IDC 最近的一项研究，Vanta 客户每年节省超过 50 万美元，生产力提高到三倍。建立信任不是可选项，Vanta 让它自动化。在 Vanta.com/Lenny 获取 1000 美元折扣。Ethan，非常感谢你能来，欢迎回到播客。

---

### (00:04:41) Ethan Smith

**English:**
Excited to be back.

**中文翻译:**
很高兴能回来。

---

### (00:04:42) Lenny Rachitsky

**English:**
We did a podcast episode just over two and a half years ago. I think of it as the definitive guide on how to win at SEO. People have been referencing it ever since. I'm really proud of what we did there, but things have changed. (00:04:54): Things are changing in the world of SEO. And so I'm excited to talk to you again about how to be successful in this new-emerging world where AI is changing how SEO works, the rise of AEO and GEO. (00:05:08): Let me start with just this question. How long have you been working on SEO at this point? And has anything come close to being this significant in changing the skill of SEO?

**中文翻译:**
我们在两年半前做过一集播客。我把它看作是关于如何在 SEO 中获胜的权威指南。从那以后人们一直引用它。我为那集内容感到自豪，但情况已经变了。(00:04:54): SEO 的世界正在发生变化。所以我很高兴能再次和你探讨，在这个 AI 改变 SEO 运作方式、AEO 和 GEO（生成式引擎优化）兴起的新兴世界里，如何取得成功。(00:05:08): 让我先问这个问题：到目前为止你从事 SEO 工作多久了？有没有什么事情在改变 SEO 技能的重要性方面能与现在的变化相提并论？

---

### (00:05:19) Ethan Smith

**English:**
Yes. So I got started in SEO in 2007, so it's been 18 years. Actually, the largest change when I got started in SEO, I got started in programmatic SEO and commerce SEO, like NexTag and Shopping.com and PriceGrabber. And that was when you could do mass, auto-generated landing pages. (00:05:41): And that was probably the biggest shift, which is Google introduced a bunch of algorithms, Panda and similar things, to prevent you from doing spam. So essentially, you went from the SEO being spam to not spam. That was probably the biggest change, and then this is probably the second-biggest change. (00:05:56): I think that the main thing here is it is related to search, but it's a summarization of search and there's new inputs. So it's probably the second-biggest change.

**中文翻译:**
是的。我是 2007 年开始做 SEO 的，所以已经 18 年了。实际上，我刚入行时最大的变化是程序化 SEO（programmatic SEO）和电商 SEO，比如 NexTag、Shopping.com 和 PriceGrabber。那时候你可以大规模自动生成落地页。(00:05:41): 那可能是最大的转变，当时 Google 引入了一系列算法，比如 Panda（熊猫算法）之类的，来防止垃圾信息。所以本质上，SEO 从“制造垃圾”变成了“非垃圾”。那可能是最大的变化，而现在的变化大概是第二大的。(00:05:56): 我认为核心在于，它虽然与搜索相关，但它是搜索的总结，并且有了新的输入方式。所以这大概是第二大变革。

---

### (00:06:03) Lenny Rachitsky

**English:**
Okay, that is really interesting, because I think a lot of people are seeing this as everything is different. Nothing we've done before is going to work. (00:06:10): We have to rethink everything. You're saying this is actually the second-biggest change, and just like Google's update back in the day was actually even more significant?

**中文翻译:**
好，这很有意思。因为我觉得很多人认为现在一切都不同了，以前做的都没用了。(00:06:10): 我们必须重构一切。而你却说这其实只是第二大变化，当年的 Google 更新其实影响更深远？

---

### (00:06:17) Ethan Smith

**English:**
Yep.

**中文翻译:**
是的。

---

### (00:06:18) Lenny Rachitsky

**English:**
Very cool. Okay, let's set a little context for folks. Let's define some terms. There's this term everyone's hearing about. (00:06:25): There's actually two, AEO and GEO. What do they stand for? Are they different? What are they referring to specifically?

**中文翻译:**
很酷。好，让我们为听众设定一下背景，定义一些术语。大家经常听到两个词。(00:06:25): AEO 和 GEO。它们代表什么？有区别吗？具体指什么？

---

### (00:06:33) Ethan Smith

**English:**
They, I think, are the same. Ultimately, the definition of a word is whatever a group of people agree is the definition of a word. So I think we'll see what people decide is the definition of the word. I'll put forward my definition. So AEO and GEO are essentially trying to describe the same thing, which is how do I show up in LLMs as an answer? (00:06:52): And I personally prefer Answer Engine Optimization versus Generative Engine Optimization, because generative, you can generate images and videos and things other than an answer. Whereas answer is more narrowly defined, so my personal preference is we're talking about optimizing LLMs. (00:07:09): So an answer is more narrow of a definition than generative, but ultimately, it's whatever we decide is the name and the definition is what it will be.

**中文翻译:**
我觉得它们是一回事。归根结底，一个词的定义取决于大家公认的含义。我们可以看看最后大家会怎么定义。我先给出我的定义：AEO 和 GEO 本质上描述的是同一件事，即“我如何作为答案出现在大语言模型中？”(00:06:52): 我个人更倾向于 AEO（回答引擎优化）而不是 GEO（生成式引擎优化），因为“生成式”可以生成图像、视频等答案以外的东西。而“回答”的定义更精准。所以我的偏好是，既然我们在讨论优化大语言模型，(00:07:09): “回答”比“生成”定义更窄。但最终，名字和定义取决于大家的共识。

---

### (00:07:19) Lenny Rachitsky

**English:**
Okay. Yeah, yeah. Answer Engine Optimization sounds a lot cleaner to me if you had to pick one. So it's good to know they're the same thing. Some people just prefer the latter one for some reason. (00:07:28): It's interesting because recently, I don't know if I told you this, but I was looking at my referral traffic. And I found that ChatGPT is driving more traffic to my newsletter than Twitter, which I did not see coming. (00:07:40): So somehow it's already happening. I'm excited to learn just how to lean into that potentially and optimize it further.

**中文翻译:**
明白。如果要选一个，AEO 听起来确实更清爽。很高兴知道它们是一回事，只是有些人出于某种原因更喜欢后者。(00:07:28): 有趣的是，最近我查看引荐流量（referral traffic）时发现，ChatGPT 给我的 Newsletter 带来的流量已经超过了 Twitter，这完全出乎我的意料。(00:07:40): 所以某种程度上，这已经在发生了。我很想学习如何利用这一点并进一步优化。

---

### (00:07:47) Ethan Smith

**English:**
And when did you see the spike? Did you see when it started growing dramatically?

**中文翻译:**
你是什么时候看到增长峰值的？你注意到它是什么时候开始剧烈增长的吗？

---

### (00:07:50) Lenny Rachitsky

**English:**
Unfortunately, the dashboard I have doesn't give me great peripheral traffic optimization. When do you think I probably saw it?

**中文翻译:**
遗憾的是，我的仪表盘没有提供很好的周边流量优化数据。你觉得我大概是什么时候看到的？

---

### (00:07:57) Ethan Smith

**English:**
Companies that we work with started in January and it started, one, because of more adoption, but two is because the answers became a bit more clickable. (00:08:05): You have maps, you have shopping carousels, you have clickable cards. So I think the clickability of the answer is increased, and then the adoption increased and that was around January.

**中文翻译:**
我们合作的公司是从 1 月份开始看到的。原因有二：一是采用率提高了；二是答案变得更具“可点击性”了。(00:08:05): 现在有了地图、购物轮播图、可点击的卡片。所以我认为答案的可点击性增强了，加上用户量的增加，转折点大约在 1 月。

---

### (00:08:14) Lenny Rachitsky

**English:**
Okay. I want to come back to this question of, "Is this good that ChatGPT is sucking all my content and giving people answers, and then sending me some percentage of that?" But let's not get into that yet. I want to talk about just what kind of impact you can have on having your stuff show up in ChatGPT. (00:08:32): So I had the head of ChatGPT, Nick Turley, on the podcast recently. I asked him, "What do you think of all this stuff, AEO, GEO?" He's like, "Don't worry about any of that. Just write awesome stuff, great quality content. It'll figure it out. It'll find the best stuff." I imagine you very much disagree. (00:08:47): I imagine you have seen real impact getting your stuff proactively into these answer engines. Talk about just the kind of impact you've seen and just your reaction to that?

**中文翻译:**
好。我想稍后再讨论“ChatGPT 吸走我的所有内容给用户答案，然后只分给我一小部分流量，这到底好不好”的问题。现在先不谈那个。我想聊聊，在让内容出现在 ChatGPT 方面，我们到底能产生多大的影响。(00:08:32): 我最近请到了 ChatGPT 的负责人 Nick Turley。我问他怎么看 AEO、GEO 这些东西。他说：“别担心那些，只要写出超棒的、高质量的内容就行。系统会搞定的，它会找到最好的东西。”我猜你肯定非常不认同。(00:08:47): 我想你一定见过主动将内容推入这些回答引擎所产生的真实影响。能谈谈你见过的这种影响以及你对 Nick 观点的反应吗？

---

### (00:08:56) Ethan Smith

**English:**
Yeah. I agree and disagree, but the way that I think about it is anything can be optimized. You just need to understand the underlying systems and the rules of the game, and if you do that, then you can optimize anything. You can optimize algorithms, you can optimize people, anything could be optimized. (00:09:11): What I think he probably meant by that, he probably meant two things. One is, "Please don't spam my product." And two is, "If you do, I will see it and I will stop you from doing that." So it's not a long-term, robust strategy to create spam, just like it wasn't a long-term, robust strategy to create spam on Google. (00:09:29): Eventually, Google was going to say, "Huge shopping comparison sites are making 100 million auto-generated search pages and I don't like it, and I'm going to get rid of the whole category." Same thing with ChatGPT, anything can be optimized, but if you're spamming it, they'll see that. (00:09:43): And they'll have a whole team looking at that and then they'll change your algorithm to prevent you from doing that.

**中文翻译:**
是的，我既同意也不完全同意。我的想法是：任何东西都可以被优化。你只需要理解底层系统和游戏规则，只要做到这一点，你就能优化任何东西。你可以优化算法，可以优化人，万物皆可优化。(00:09:11): 我觉得他那么说可能有两个意思：一是“请不要在我的产品里刷垃圾信息”；二是“如果你刷了，我会发现并阻止你”。所以，制造垃圾信息不是一个长期稳健的策略，就像在 Google 上刷垃圾信息也不是长久之计一样。(00:09:29): 最终 Google 会说：“那些大型购物对比网站自动生成了 1 亿个搜索页面，我不喜欢这样，我要把整个类别都干掉。”ChatGPT 也是一样，任何东西都能优化，但如果你在刷屏，他们会发现的。(00:09:43): 他们会有专门的团队盯着，然后修改算法来阻止这种行为。

---

### (00:09:48) Lenny Rachitsky

**English:**
What kind of impact have you seen? You've done work with a lot of companies, we'll talk through a few examples. (00:09:53): Maybe share one to give us context just like how much can you impact this sort of thing where you show up in, say, ChatGPT more often?

**中文翻译:**
你见过什么样的影响？你和很多公司合作过，我们会聊几个例子。(00:09:53): 也许可以分享一个，让我们了解一下，在提高 ChatGPT 出现频率这件事上，人为干预的影响力到底有多大？

---

### (00:10:01) Ethan Smith

**English:**
You can affect it a lot. So a specific example with Webflow is we are working with Webflow on their SEO. We're working on their content, and we're seeing a lot of wins on the Answer Engine Optimization side. (00:10:16): So the specific things that we've done there, one is just traditional SEO. So make landing pages for high-search volume keywords, like best no-code website designer. (00:10:28): And then for free, you'll get Answer Engine Optimization impact from that. So that's just traditional SEO, which works very well for AEO.

**中文翻译:**
影响非常大。以 Webflow 为例，我们正在帮他们做 SEO 和内容，我们在 AEO 方面取得了很大进展。(00:10:16): 我们做的具体事情中，第一项就是传统 SEO。比如针对高搜索量的关键词制作落地页，像“最好的无代码网站设计工具”。(00:10:28): 然后你就能顺带免费获得 AEO 的效果。所以传统 SEO 对 AEO 非常有效。

---

### (00:10:35) Lenny Rachitsky

**English:**
I was just going to say, that sounds exactly the same as regular SEO.

**中文翻译:**
我正想说，这听起来和普通 SEO 一模一样。

---

### (00:10:38) Ethan Smith

**English:**
Yeah. So I would say everything that works in SEO works in AEO, but there are additional things beyond SEO that also work in AEO. So second thing, and the way that I think about AEO versus SEO is that the head and the tail are different. So the head is different in that in order to win something like what's the best website builder? (00:10:59): Even if Webflow's URL shows up number one on the citations, they're not going to win the answer because their URL showed up number one, but at Google they would win. If their blue link showed up first they would win, but that's not the case in the LLM. Because the LLM is summarizing many citations and so you need to get mentioned as many times as possible. (00:11:18): So usually when you ask something like, "What's the best tool for X?" The first answer will be mentioned the most in the citations, because that's very different from Google. And so for Webflow, we work with them on YouTube videos, Vimeo videos, getting mentioned in Reddit, getting mentioned in other blogs, affiliates, stuff like that. (00:11:39): So tried a bunch of stuff. Stuff that worked especially well was just straight SEO, number one. Number two is YouTube videos, and then the third is Reddit optimization.

**中文翻译:**
没错。我会说，在 SEO 中有效的一切在 AEO 中也有效，但 AEO 还有一些 SEO 之外的额外招数。第二点，我区分 AEO 和 SEO 的方式是看“头部”和“长尾”的不同。头部不同在于，为了在“最好的网站搭建工具是什么？”这类问题中胜出，(00:10:59): 即使 Webflow 的 URL 在引用来源中排第一，他们也不一定能赢得这个答案。在 Google，如果蓝色链接排第一你就赢了，但在大语言模型里不是。因为模型在总结多个来源，所以你需要被尽可能多地提及。(00:11:18): 通常当你问“X 的最佳工具是什么？”时，排名第一的答案往往是在引用来源中被提到次数最多的，这和 Google 非常不同。所以对于 Webflow，我们帮他们做 YouTube 视频、Vimeo 视频、在 Reddit 上刷存在感、在其他博客和联盟营销（affiliates）中被提及等等。(00:11:39): 我们尝试了很多。效果特别好的是：第一，直接的 SEO；第二，YouTube 视频；第三，Reddit 优化。

---

### (00:11:47) Lenny Rachitsky

**English:**
Okay, wow. So you're saying if you can get to number one, when you ask ChatGPT, "What's the best website builder?" (00:11:54): And Webflow's at the top, that doesn't actually drive them as much traffic as simply being mentioned most often across the summary?

**中文翻译:**
哇，明白了。所以你是说，当问 ChatGPT“最好的网站搭建工具”时，(00:11:54): 即使 Webflow 排在第一位，其带来的流量可能还不如在整个总结中被提及次数最多带来的多？

---

### (00:12:01) Ethan Smith

**English:**
Yes. And part of why that's interesting is because when startups come to me and ask me for SEO help, my first response is, "Don't do it at all. Spend your time on something else because you're not going to be able to grow SEO early on in search." Because you don't have enough domain authority and it takes a while to get domain authority, and only once you have domain authority can you rank. (00:12:23): And so for Google, it's usually something that you do Series A, Series B or later. You don't do it as soon as you start because can't win early on. That's not the case for Answer Engine Optimization, because you can get mentioned by a citation tomorrow and start showing up immediately. You can have a Reddit thread, you can have a YouTube video. (00:12:42): You can be mentioned on a blog, like a brand-new YC company launches, everyone's talking about them. They could show up in an answer tomorrow as a result of that. So early-stage companies can win, they can win quickly. And they can win quickly and anyone can win quickly, by getting mentioned as many times as possible by the citations. So that's what's different about the head. (00:13:04): What's different about the tail is that the tail is larger in chat than in search. So the average number of words, I think, Perplexity said this to somebody else, said that it was around 25 words, where versus Google words it's around six words. So the tail is just much, much larger. People are asking lots of follow-up questions.

**中文翻译:**
是的。这很有趣，因为当有初创公司找我做 SEO 咨询时，我的第一反应通常是：“别做，把时间花在别处。因为在搜索领域，你早期根本做不起来 SEO。”因为你没有足够的域名权重（domain authority），积累权重需要时间，有了权重才能排名。(00:12:23): 所以在 Google 时代，SEO 通常是 A 轮、B 轮或更晚才做的事。你不会一创业就做，因为赢不了。但 AEO 不同，因为你明天就可能被某个引用源提到，然后立刻出现。你可以发个 Reddit 贴，拍个 YouTube 视频。(00:12:42): 或者在博客上被提到，比如一家刚成立的 YC 公司发布了，大家都在谈论它，它明天就可能出现在 AI 的答案里。所以初创公司能赢，而且能赢很快。任何人只要在引用源中被多次提及，都能快速获胜。这就是“头部”的不同。(00:13:04): 而“长尾”的不同在于，对话中的长尾比搜索中的更长。Perplexity 曾提到，对话的平均长度约为 25 个单词，而 Google 搜索大约只有 6 个单词。所以长尾要大得多，人们会问很多后续问题。

---

### (00:13:19) Lenny Rachitsky

**English:**
The tail, the prompt essentially, the question you're asking?

**中文翻译:**
你说的“长尾”，本质上是指 Prompt（提示词），也就是用户问的问题？

---

### (00:13:23) Ethan Smith

**English:**
Yes. Meaning that if you map out all of the questions that people ask, kind of like an SEO, long-tail keywords, if you do long-tail questions, the size of the tail is larger. Meaning the amount of questions that are very specific is larger, the share and the volume. (00:13:42): And there's probably questions that have never been asked before and questions that have never been searched before, because search can't support lots of really specific, super-specific stuff. Whereas chat is specifically made to ask a bunch of follow-up questions and have a conversation. (00:13:58): And so there's all these questions that have never been asked or searched for before that are now being asked, and then you can win that. And when I got started in SEO, it was long-tail SEO where you have a page for every single keyword, which doesn't work anymore, but now the long tail is back in chat. (00:14:13): And if you know all those really specific questions that people are asking, you can also win that, and you can probably also win that early. And I've seen examples of early-stage companies who just launched some really specific AI-enabled payment processing API thing, and they will show up. And they'll show up because they're answering questions that's never been answered before.

**中文翻译:**
是的。这意味着如果你把人们问的所有问题画出来，就像 SEO 里的长尾关键词一样，如果你做“长尾问题”，这个尾部的规模会更大。也就是说，非常具体的问题数量更多，占比和总量都更大。(00:13:42): 可能会有很多以前从未被问过或搜索过的问题，因为传统搜索无法支持大量极其具体、超细节的内容。而对话（Chat）天生就是为了追问和交流设计的。(00:13:58): 所以现在有很多以前从未出现过的问题被提出来，你可以从中获胜。我刚入行时流行“长尾 SEO”，即为每个关键词做一个页面，现在这招不灵了，但长尾在对话中复活了。(00:14:13): 如果你知道人们在问哪些非常具体的问题，你就能赢，而且可能很早就赢。我见过一些初创公司刚发布了一个非常具体的 AI 支付处理 API，他们就出现在答案里了。他们能出现是因为他们回答了以前从未被回答过的问题。

---

### (00:14:35) Lenny Rachitsky

**English:**
Are the leads that these answer engines are driving to companies actually valuable? Are these good-quality leads for B2B SaaS especially?

**中文翻译:**
这些回答引擎带给公司的潜在客户真的有价值吗？尤其是对 B2B SaaS 来说，这些是高质量的客户吗？

---

### (00:14:44) Ethan Smith

**English:**
They are significantly more valuable. So Webflow, we saw a 6X conversion rate difference between LLM traffic and Google Search traffic.

**中文翻译:**
它们的价值要高得多。在 Webflow，我们看到大语言模型流量的转化率是 Google 搜索流量的 6 倍。

---

### (00:14:55) Lenny Rachitsky

**English:**
Six times?

**中文翻译:**
六倍？

---

### (00:14:56) Ethan Smith

**English:**
Six times so significantly more qualified. I think that's probably for a couple of reasons. Probably it's because you're so primed because you're having a conversation with multiple follow-ups, and so there's so much intent that you've built. (00:15:08): And you've probably really narrowed in on what you want, so when you're going somewhere, it's probably highly qualified. And so we're seeing that it's just a much higher conversion rate.

**中文翻译:**
六倍，所以意向度明显更高。我觉得原因有几点：可能是因为你在进行多次追问的对话中已经被充分引导了，你建立起了非常明确的意图。(00:15:08): 你可能已经非常精准地锁定了自己想要的东西，所以当你点击跳转时，你就是一个高质量的潜在客户。因此我们看到转化率要高得多。

---

### (00:15:18) Lenny Rachitsky

**English:**
Wow, this is so interesting, and it makes sense. People trust ChatGPT to tell them the answer, and if you are the answer, you have so much advantage. Like that is what people want to know, and then, "Okay. Cool, thank you. I'm going to go check this out." (00:15:35): This all just makes sense. Going back to the three levers you shared, essentially it's the things that you see work in driving you showing up more in these answer engines, landing pages, YouTube videos and Reddit. Is that right?

**中文翻译:**
哇，这太有意思了，而且合情合理。人们信任 ChatGPT 给出的答案，如果你就是那个答案，你就占尽先机。这就是人们想知道的，然后他们会说：“好，谢谢，我去看看。”(00:15:35): 这一切都说得通。回到你分享的三个杠杆，本质上就是你发现的能让你更多出现在回答引擎中的手段：落地页、YouTube 视频和 Reddit。对吗？

---

### (00:15:49) Ethan Smith

**English:**
Those are some of them.

**中文翻译:**
这些是其中的一部分。

---

### (00:15:49) Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好的。

---

### (00:15:51) Ethan Smith

**English:**
The other things, so I would break it up into stuff on your site, onsite and offsite. So onsite would be traditional SEO. The difference would be this long tail. I would also say that the difference is lots of follow-up questions about does your product do this thing? What are the use cases, features, integrations, languages? (00:16:07): Tell me about your product and really specific details about that and that's on your site. And then the second group would be offsite, which is show up in all the citations. Citations are comprised of video, UGC like Reddit and Quora, affiliates. (00:16:23): Dotdash Meredith is showing up all over the place, Glamour, Good Housekeeping, it's like getting mentioned there, blogs, so it's those two groups.

**中文翻译:**
其他方面，我会把它分为“站内（onsite）”和“站外（offsite）”。站内就是传统 SEO，区别在于刚才说的长尾。我还要补充一点，区别还在于大量的追问，比如：你的产品能做这个吗？有哪些用例、功能、集成、支持的语言？(00:16:07): 也就是关于你产品的非常具体的细节，这些都在你的网站上。第二组是站外，即出现在所有的引用源中。引用源包括视频、UGC（用户生成内容，如 Reddit 和 Quora）、联盟营销站点。(00:16:23): 像 Dotdash Meredith 旗下的 Glamour、Good Housekeeping 到处都是，在这些地方被提及，还有博客。所以就是这两大类。

---

### (00:16:33) Lenny Rachitsky

**English:**
And that all sounds very similar to SEO showing up on other people's pages. Showing links from, say, Reddit is always great. (00:16:41): It's interesting that Reddit is such a big deal. What's going on there do you think?

**中文翻译:**
这听起来和 SEO 很像，就是出现在别人的页面上。比如从 Reddit 获得链接总是好事。(00:16:41): 有趣的是 Reddit 竟然如此重要。你觉得这是为什么？

---

### (00:16:45) Ethan Smith

**English:**
Okay, Reddit is one of the most interesting things. It's hugely cited in LLMs. And it's probably the number one thing people are asking, customers are asking me is, "How do we optimize for Reddit?" And this goes back to the head of ChatGPT's question about, "Please don't spam my product." (00:17:06): And so Reddit is a community where it's real opinions from people, authentic, and it's heavily managed by the community and the community is very good at managing it. And so the obvious strategy for a growth person is, "Let's make a bunch of automated spam and spam Reddit all over the place and get my product to show up everywhere." (00:17:27): That's the growth mindset, which makes sense, the hustle mindset. So what are people looking at? They're looking at creating hundreds of fake Reddit accounts pretending to be someone that you're not. I have a single person, I'm going to make 100 Reddit accounts. I'm going to autopost comments and then like my own comments. (00:17:46): And then build a trust score, and then shout, say everywhere that my product is the best product. Fortunately, that doesn't work very well, but that's the obvious strategy. And so we're seeing people trying to do that and then we're also seeing those accounts get banned, those comments get deleted. And so we're seeing people trying to spam and being unsuccessful, so that's one strategy. (00:18:05): The other strategy is the whole purpose of Reddit is to post useful, high-quality, authentic comments from real people. So at Webflow, we have a couple of people at Webflow going to comments and saying, "This is my name, this is where I work, and here's a useful piece of information." So the strategy is find a thread that is a part of a citation that you want to show up in. (00:18:30): Say who you are, say where you work, and then give a useful piece of information, and that works really well. And that sounds simple if you're not in the growth mindset of, "I need to scale this to hundreds of comments." But you don't actually need 10,000 comments, even five could be great and that scales perfectly well. (00:18:47): So the Reddit strategy is the obvious strategy, which is just to be an actual user of Reddit. Make an account, say who you are, say where you work, and give a useful answer.

**中文翻译:**
Reddit 是最有趣的事情之一。它在大语言模型中被引用的频率极高。客户问我最多的问题就是：“我们该如何针对 Reddit 进行优化？”这又回到了 ChatGPT 负责人说的“请不要刷垃圾信息”。(00:17:06): Reddit 是一个充满真实、地道观点的社区，而且社区管理非常严格，社区成员也很擅长自我管理。对于增长人员来说，显而易见的策略是：“让我们搞一堆自动化垃圾信息，在 Reddit 到处刷，让我的产品无处不在。”(00:17:27): 这就是典型的增长思维，或者说“搞钱”思维。所以人们在看什么？他们在看如何创建几百个虚假账号，假装成别人。一个人操作 100 个账号，自动发帖，然后给自己点赞。(00:17:46): 建立信任分，然后到处喊我的产品是最好的。幸运的是，这招不太灵，但这是最容易想到的策略。我们看到有人尝试这样做，但也看到这些账号被封，评论被删。所以刷屏策略行不通。(00:18:05): 另一种策略是回归 Reddit 的本质：发布来自真人的有用、高质量、真实的评论。在 Webflow，我们有几个人会去评论区说：“我是谁，我在哪工作，这里有一条有用的信息。”策略就是：找到一个你想要出现在其中的引用源帖子。(00:18:30): 表明身份，说明职位，然后提供有价值的信息，这非常有效。如果你没有那种“我必须规模化到几百条评论”的增长执念，这听起来很简单。但你其实不需要 1 万条评论，哪怕 5 条高质量的也很有用，而且这种方式扩展性很好。(00:18:47): 所以 Reddit 策略其实就是最朴素的那种：做一个真实的 Reddit 用户。注册账号，表明身份，给出有用的回答。

---

### (00:18:56) Lenny Rachitsky

**English:**
We had the early-growth leader from Deel, D-E-E-L, on the podcast a while ago. And this is how they grew initially, before AI even came around, just going big on Reddit and answering people's questions. (00:19:07): And like, "Hey, happens to be Deel. Can I help you with this problem?" So that's interesting. It's so interesting that Reddit is what is keeping ChatGPT from being spammed with stuff. It's not that ChatGPT is stopping the spam, its Reddit is just really good at that.

**中文翻译:**
我们不久前请过 Deel 的早期增长负责人。在 AI 出现之前，他们最初就是这么增长的：在 Reddit 上大展身手，回答人们的问题。(00:19:07): 比如：“嘿，正好 Deel 可以解决这个问题，我能帮你吗？”这很有趣。Reddit 竟然成了防止 ChatGPT 被垃圾信息淹没的屏障。不是 ChatGPT 阻止了垃圾信息，而是 Reddit 本身非常擅长处理这个。

---

### (00:19:23) Ethan Smith

**English:**
I think that in a sense, ChatGPT is policing because ChatGPT is running a search, it's finding citations. There's a search algorithm that's trying to select which citations are useful. There are people at ChatGPT who are tuning their search algorithm to select which sources they trust. (00:19:40): I'm sure that there's a search evaluation team saying, "Do I like these citations, yes, no? Is Reddit showing up? I want it to show up." So I think that there are actual people at ChatGPT who are intentionally configuring their algorithm to use Reddit because it's trusted. And if it wasn't trusted, they wouldn't use it. (00:19:57): Same with Google. Google has specifically configured their search algorithm to rank Reddit and Twitter and Quora, because they want user-generated content. And if it wasn't good content, then they would change the algorithm and they wouldn't rank it. So I think that they are policing it in a sense.

**中文翻译:**
我认为从某种意义上说，ChatGPT 也在监管。因为 ChatGPT 在运行搜索，寻找引用源。有一个搜索算法在尝试筛选哪些引用是有用的。ChatGPT 的工作人员也在调整算法，选择他们信任的来源。(00:19:40): 我确信有一个搜索评估团队在问：“我喜欢这些引用吗？Reddit 出现了吗？我希望它出现。”所以我觉得 ChatGPT 内部确实有人在刻意配置算法去使用 Reddit，因为它值得信赖。如果不值得信赖，他们就不会用。(00:19:57): Google 也是如此。Google 专门配置了算法来提升 Reddit、Twitter 和 Quora 的排名，因为他们想要用户生成的内容。如果内容不好，他们就会修改算法不再给它排名。所以我觉得他们在某种程度上是在监管的。

---

### (00:20:13) Lenny Rachitsky

**English:**
Got it. And all of this is post-training, search-oriented features of these models. It's not data they are trained on, is that right?

**中文翻译:**
明白了。所有这些都是这些模型的“训练后（post-training）”、面向搜索的功能。这不是它们训练时用的静态数据，对吗？

---

### (00:20:24) Ethan Smith

**English:**
I would assume that so there's the core model and then there's RAG. So the core model is I'm looking at common crawl on billions of web pages, and then I'm retraining the model. And if you ask something like, "What's the capital of California?" It predicts the next word, which is Sacramento. And that's based on the core algorithm, which is next-word prediction. (00:20:44): Then there's RAG and RAG basically means search, retrieval-augmented generation. So I'm going to do a search and then I'm going to summarize the search. There are these two different things. And so most of what I'm describing is about the RAG piece, not the core model piece. To influence the core model is probably extremely hard and maybe you'll see the impact a year later. (00:21:03): And it's probably something, some sort of obscure thing that nobody would want to do, like make a million pages that say, "Best product for X is brand." Which I don't think most people want to spend their time on. So I'm mostly focused on the RAG side, because that's the main thing that's controllable. (00:21:18): And I think also the LLM is probably not going to say your product if it didn't show up anywhere on the RAG. So I think that's where most of the interesting stuff is from an optimization perspective.

**中文翻译:**
可以这么理解。有核心模型，还有 RAG（检索增强生成）。核心模型是基于对数十亿网页的抓取进行训练的。如果你问“加州的首府在哪？”，它会预测下一个词是“萨克拉门托”，这是基于核心算法的下文预测。(00:20:44): 然后是 RAG，本质上就是搜索。它先进行搜索，然后总结搜索结果。这是两回事。我所描述的大部分内容都是关于 RAG 部分，而不是核心模型。影响核心模型极其困难，而且你可能一年后才能看到效果。(00:21:03): 那可能需要做一些没人愿意做的晦涩事情，比如做一百万个页面写着“X 的最佳产品是某品牌”。我觉得大多数人不想把时间花在这上面。所以我主要关注 RAG 这一侧，因为这是主要的可控因素。(00:21:18): 而且我认为，如果你的产品没有出现在 RAG 的搜索结果中，大语言模型大概率也不会提到它。所以从优化角度来看，最有趣的东西都在这里。

---

### (00:21:27) Lenny Rachitsky

**English:**
Cool. Yeah. I didn't even think about this side of it when we started talking about this, but I think that's an important thing to note, is just this has nothing to do with the training data. (00:21:34): This is post-training, once the model's live, what it can do to find recent information using RAG, web search, things like that. Okay. Before we get into how to actually do this step-by-step, how to win at AEO. (00:21:48): What are two or three things that you think are important for people to understand to be successful in this world just broadly?

**中文翻译:**
酷。开始聊的时候我还没想到这一层，但我觉得这一点很重要：这与训练数据无关。(00:21:34): 这是训练后的、模型上线后的行为，即它如何利用 RAG、网页搜索等手段寻找最新信息。好，在我们进入“如何一步步在 AEO 中获胜”的实操之前，(00:21:48): 你认为人们想要在这个领域取得成功，需要理解哪两三件重要的事？

---

### (00:21:54) Ethan Smith

**English:**
First thing is just recognizing that this is related to search. So it's LLM plus RAG, it's summarizing a set of search results usually. So LLM plus RAG, number one. Number two is topics. So in search, a landing page is targeting hundreds of keywords, which we talked about on the last podcast. (00:22:12): So I'm not targeting one keyword like I was in 2007, I'm targeting 1,000 keywords, and each landing page needs to target that set of 1,000 keywords, and that's a topic. Same thing is true for Answer Engine Optimization. Each page is targeting hundreds, thousands, maybe tens of thousands of questions. (00:22:28): And so I want to group all those questions, which then brings us into content, so how would I rank? How would I get my URL to rank? Or how are other URLs being decided whether or not they rank? Then answer all the questions. The more of the questions that I answer, the better. (00:22:42): So in Google Search, if I have a landing page about website builders, the more that my page answers all of the subtopic, follow-up questions, the more likely I am to show up in Google Search. Same with chat, the more you answer all the questions, the better. If you don't answer a question, then you're probably not going to show up. (00:22:57): And if you answer a follow-up question and subtopic somebody else is not answering, you're going to be more likely to show up. So topics, number two. The third is question research, so how do I know which questions people are asking? And that's actually pretty hard, because in search, Google just tells you what their ads API. (00:23:15): They say, "This is the search volume for this keyword." There's a truth set from Google and ChatGPT is not giving us that, at least not yet. Maybe when they do ads, they'll give us more access to search volume, but there's no truth set. So how do we know the questions that people are asking? (00:23:31): One way would just be to take all my search terms and change them into questions. So website builder, you can assume that what's the best website builder is probably a question that's probably asked proportional to the search volume for that keyword, so that's one. (00:23:44): But then I mentioned that the tail is larger, and there's parts of the tail that don't exist in search. So how do we know what the tail looks like? And one strategy that you can use, is what are all the questions people are asking you on your sales calls, customer support on Reddit? (00:24:02): Mine all those questions that exist somewhere else. Probably those same questions are being asked in chat, so that's another way to find questions. The last is citation optimization or offsite. So again, the LLM is summarizing RAG. So how do we show up with as many citations as possible? (00:24:21): And you can break up the citations into different groups, my site, video, YouTube, Vimeo, UGC, Quora, Reddit. Tier-one affiliates like Dotdash, tier-two affiliates, blogs. So it's breaking up all those different citations and having specific strategies for each group.

**中文翻译:**
第一，要意识到这与搜索密切相关。它是“大语言模型 + RAG”，通常是在总结一组搜索结果。这是第一点。第二是“主题（Topics）”。在搜索中，一个落地页会针对数百个关键词，我们在上一集聊过。(00:22:12): 我不再像 2007 年那样只针对一个关键词，而是针对 1000 个关键词，每个落地页都要覆盖这 1000 个词的集合，这就是一个主题。AEO 也是如此。每个页面都要针对成百上千、甚至上万个问题。(00:22:28): 所以我要把这些问题分组，这就涉及到了内容：我该如何排名？如何让我的 URL 排上去？或者其他 URL 是如何被决定排名的？答案是：回答所有问题。回答得越多越好。(00:22:42): 在 Google 搜索中，如果我有一个关于网站搭建工具的落地页，我的页面回答的子话题和追问越多，我就越有可能出现在搜索结果中。对话也是一样，回答得越全面越好。如果你没回答某个问题，你就不会出现。(00:22:57): 如果你回答了一个别人没回答的追问或子话题，你就更有可能出现。所以“主题”是第二点。第三是“问题研究（Question Research）”：我怎么知道人们在问什么？这其实挺难的，因为在搜索领域，Google 会通过广告 API 告诉你。(00:23:15): 他们会说“这个词的搜索量是多少”。Google 有一套标准数据集，但 ChatGPT 还没给我们提供，至少现在没有。也许等他们做广告业务时会开放搜索量数据，但现在没有标准答案。那我们怎么知道人们在问什么？(00:23:31): 一种方法是把所有的搜索词转换成问题。比如“网站搭建工具”，你可以假设“最好的网站搭建工具是什么”这个问题的提问频率与该关键词的搜索量成正比。这是其一。(00:23:44): 但我提到过长尾更长，有些长尾在搜索中是不存在的。那我们怎么知道长尾长什么样？一个策略是：看看人们在销售电话、客户支持、Reddit 上都在问什么？(00:24:02): 挖掘那些存在于其他地方的问题。这些问题很可能也会在对话中被问到。最后是“引用源优化（Citation Optimization）”或站外优化。模型在总结 RAG 结果，所以我们如何出现在尽可能多的引用源中？(00:24:21): 你可以将引用源分为不同组：自己的网站、视频（YouTube, Vimeo）、UGC（Quora, Reddit）、一级联盟站点（如 Dotdash）、二级联盟站点、博客。针对每一组制定具体的策略。

---

### (00:24:40) Lenny Rachitsky

**English:**
What is Dotdash exactly?

**中文翻译:**
Dotdash 具体是什么？

---

### (00:24:42) Ethan Smith

**English:**
Dotdash Meredith is a large media conglomerate with Good Housekeeping, Allrecipes, Investopedia. It's probably the most successful SEO company of all time. (00:24:53): And it's also one of the most cited, probably the most cited in LLMs as well.

**中文翻译:**
Dotdash Meredith 是一个大型媒体集团，旗下拥有 Good Housekeeping、Allrecipes、Investopedia 等。它可能是史上最成功的 SEO 公司。(00:24:53): 它也是被引用最多的来源之一，在大语言模型中可能也是被引用最多的。

---

### (00:24:59) Lenny Rachitsky

**English:**
Wow, did not know this. As you talk, I think about if you go to Google, no offense, Mr. SEO, but if you go to Google these days, it's just like a bunch of unuseful stuff, just like this hyper SEO'ed content. (00:25:12): Do you think ChatGPT will be able to avoid that fate where it's just a bunch of hyper SEO'ed content that is not what you actually want?

**中文翻译:**
哇，以前真不知道。听你这么说，我想起现在的 Google——无意冒犯，SEO 专家先生——但现在的 Google 搜索结果里充斥着大量无用的、过度 SEO 的内容。(00:25:12): 你觉得 ChatGPT 能避免这种命运吗？就是避免变成一堆过度 SEO、却不是用户真正想要的内容？

---

### (00:25:19) Ethan Smith

**English:**
Probably. And what you're saying with SEO is that everyone's rewriting each other's content, nonexperts rewriting each other's content. So I get a content-scoring tool, which then looks at all the results in Google and it says, "These are all the things that the other articles are saying. And then this is what you haven't said yet, so here are recommendations for how to be more typical." (00:25:40): And then everyone rewrites each other's article. And then one other interesting thing is that the majority of landing pages drive no impact. So we did an analysis where one out of 20 landing pages drive roughly 85% of all your traffic. So 19 out of 20 landing pages drive little to no traffic, which means if I want to get ROI, I need to spend a small amount of money on a large number of pages. (00:26:06): And so then you get a nonexpert to say, "Rewrite this other person's article," because that's cheaper than hiring someone from The New York Times to write your article about what's the best payroll management software? But if you knew the few things that would work, the few landing pages that would work, and you wrote them really well, then you could push all that money to that one page, which is what we try to do. (00:26:28): But right now it's people rewriting each other's content, so Google has not solved that yet. That's probably a very hard problem to solve. Will they ever solve that? Probably. Will ChatGPT ever solve that? Probably. How I would solve that would be, one concept would be information gain. So did you say something that somebody else didn't say? Two is how typical are you? (00:26:50): Are you so typical that I think that you're a rewritten version of somebody else's content? Potentially, Google has EEAT, expertise, authority, trustworthiness, which actually I don't see having an effect unfortunately, but it could. And I could say, "Well, this person's an expert, this person's a certified financial advisor, rank them higher." (00:27:08): And I'm actually not seeing that, but they could increase the weight of that. So these are all potential solutions, but I'm sure that the reason why it has not been solved yet and why everyone's rewriting each other's articles. It's probably just hard to build an algorithm to solve that, but will they ever solve that? Probably.

**中文翻译:**
很有可能。你提到的 SEO 现状是大家都在互相洗稿，非专业人士在重写别人的内容。我用一个内容评分工具，它扫描 Google 结果后说：“别的文章都提到了这些点，你还没提，所以建议你加上这些，让自己显得更‘标准’。”(00:25:40): 结果就是大家都在互相重写。另一个有趣的事实是，绝大多数落地页其实没贡献。我们做过分析，20 个落地页里只有 1 个能贡献约 85% 的流量。剩下的 19 个几乎没流量。这意味着为了 ROI，我得花少量的钱做大量的页面。(00:26:06): 于是你就找个外行说“重写一下别人的文章”，因为这比请《纽约时报》的记者写一篇“最好的薪资管理软件”要便宜得多。但如果你知道哪几个页面会起作用，并把它们写得极好，你就能把钱都砸在那一个页面上，这也是我们努力的方向。(00:26:28): 但目前大家还是在互相洗稿，Google 还没解决这个问题。这可能是一个极难解决的问题。他们能解决吗？也许。ChatGPT 能解决吗？也许。如果让我来解决，我会看两个概念：一是“信息增益（information gain）”，你有没有说出别人没说过的话？二是“典型性”，(00:26:50): 你是不是太典型了，以至于我觉得你就是洗稿出来的？Google 有 EEAT（专业性、权威性、可信度）标准，遗憾的是我目前没看到它发挥太大作用，但它本可以。我可以设定“这个人是专家，是认证理财师，所以排名更高”。(00:27:08): 虽然现在还没看到明显效果，但他们可以增加这方面的权重。这些都是潜在方案，但我确信目前还没解决、大家还在互相洗稿的原因，纯粹是因为写出能解决这个问题的算法太难了。但未来能解决吗？大概率会。

---

### (00:27:23) Lenny Rachitsky

**English:**
This algorithm or heuristic you just shared is so interesting, because it's helpful for just what is good content, say, with a newsletter or a podcast? Info gain, and is it typical? (00:27:34): Are you adding something new to the conversation and is this unique? I think it's a really good strategy for just producing great newsletters and podcasts and all the content in the world.

**中文翻译:**
你分享的这个算法逻辑或启发式方法太有意思了，因为它不仅适用于 SEO，也适用于判断什么是好的 Newsletter 或播客内容。信息增益，以及是否过于平庸？(00:27:34): 你是否为对话增添了新东西？是否独特？我觉得这是制作优秀内容的一个非常棒的通用策略。

---

### (00:27:45) Ethan Smith

**English:**
Yes. Ideally, did you do original research and do you have some domain expertise? And did you mention that in the content?

**中文翻译:**
是的。理想情况下，你是否做了原创研究？是否具备领域专业知识？你是否在内容中体现了这些？

---

### (00:27:51) Lenny Rachitsky

**English:**
This is a great heuristic for just content in general, which is exactly what you want these algorithms to be looking for, so the alignment is there. (00:27:59): This episode is brought to you by Great Question, the all-in-one UX research platform loved by teams at Brex, Canva, Intuit and more. One of the most common things I hear from PMs and founders that I talk to is, "I know I should be speaking to customers more, but I just don't have the time or the tools." That's exactly the gap Great Question fills. (00:28:18): Great Question makes it easy for anyone on your team, not just researchers, to recruit participants, run interviews, send surveys, test prototypes, and then share it all with powerful video clips. It's everything you need to put your customers at the center of your product decisions. With a prompt as simple as, "Why did users choose us over competitors?" (00:28:35): Great Question not only reveals what your customers have already shared, but it also makes it incredibly easy to ask them in the moment for fresh insights from the right segment. Picture this, your roadmap's clear, your team's aligned, you're shipping with confidence, and you're building exactly what your customers need. Head to greatquestion.com/Lenny to get started. (00:28:56): Let's give people an actual, actionable plan to start executing on this and winning essentially at AEO. If it's helpful to use my newsletter as an example, how would I show up more often on ChatGPT or Gemini or whatever? Or if it's a B2B SaaS company, whatever's easiest, let's just talk about how to actually do this.

**中文翻译:**
这是一个非常棒的内容通用准则，也正是你希望算法去寻找的东西，所以目标是一致的。(00:27:59): 本集由 Great Question 赞助，这是一个深受 Brex、Canva、Intuit 等团队喜爱的全能型 UX 研究平台。我从 PM 和创始人那里听到最多的就是：“我知道该多和客户聊聊，但我没时间也没工具。”这正是 Great Question 填补的空白。(00:28:18): Great Question 让团队中的任何人（不只是研究员）都能轻松招募参与者、进行访谈、发送调查、测试原型，并分享强大的视频剪辑。它能帮你把客户置于产品决策的核心。只需输入一个简单的 Prompt，比如“用户为什么选择我们而不是竞争对手？”(00:28:35): Great Question 不仅能揭示客户已经分享的内容，还能让你非常容易地实时向特定细分群体获取新鲜洞察。想象一下：路线图清晰，团队步调一致，充满信心地发布产品，并精准构建客户所需。访问 greatquestion.com/Lenny 开始使用。(00:28:56): 让我们给听众一个实际可操作的计划，开始执行并在 AEO 中获胜。如果拿我的 Newsletter 做例子有帮助的话，我该如何更多地出现在 ChatGPT 或 Gemini 中？或者以 B2B SaaS 公司为例，怎么方便怎么来，聊聊具体怎么做。

---

### (00:29:12) Ethan Smith

**English:**
First, I would figure out which questions I want to rank for. How I would figure out which questions I want to rank for, I would take my search data. I would maybe take my paid search data, like, "What are my money terms? What are my competitors' money terms?" So if I'm rippling, what is deal.com bidding all their paid search on? (00:29:30): Then I would transform those into questions. And actually you can just give those keywords to ChatGPT and say, "Make these into questions," and it does a pretty good job. So take your competitors' paid search data or mine or your own, put it in ChatGPT, get the questions. That's step one. Step two is then track them, so put them in an AEO tracker, in an answer tracker. (00:29:51): Third thing would be who is showing up as citations? And then have a strategy for each of those different groups of citations. The third would be make your own landing pages. So what are the kinds of landing pages that are appearing? Is it a listicle? Is it a category page? Is it an article, tool page? Figure out what page type that seem to be showing up the most, and then you make your own page for that. (00:30:14): How do you have your page rank? Answer all the follow-up questions. So what are all the follow-up questions that someone might ask? You could go back to your search data and look for groups and themes of your keywords that are in your SEO topic. Same thing for AEO topic. Then on the offsite, so different strategies for each of those groups. (00:30:37): And I would say that depending on the company, paying an affiliate to mention you, that's pretty easy if you have the money. So if you want to be the best credit card, you pay Forbes and then you're the best credit card. So that's strategy one, expensive, easy, controllable. The YouTube, Vimeo strategy is also actually pretty easy because there's no community saying, "I don't like your YouTube video." (00:30:59): You make a YouTube video, you do whatever you want. Maybe people view it, maybe they don't, but you can make a YouTube video or a Vimeo video. And the interesting thing with this, especially for B2B, is that YouTube, Vimeo, other video sites, the kinds of things people make videos for are food, traveling, fun, beauty. (00:31:18): There's not that many videos about AI-powered payment processing APIs, as interesting as that is, but it's a great money turn. So if you make a video for these really specific, high-LTV, maybe nonglamorous keywords, questions, topics, that's actually a big opportunity. Then Reddit, so I mentioned with Webflow what we did, which is just make a Reddit account, say who you are, say where you work and give a useful answer. (00:31:48): That one is a little bit trickier because the community might say, "I don't like your answer." So you can't guarantee that your comment is there, but it is easy, so I would do that group. Oh, and then experiment design, experiment design and seeing what works. So SEO and AEO are both interesting in that the majority of the information and best practices are not correct. (00:32:13): And the reason why is because people don't do analysis. Somebody will say something and then it will get repeated, and then it becomes best practice and no one ever did an analysis. So you did all the stuff that I just mentioned. Do an experiment and see if it worked. Maybe half the stuff I said works, maybe half it doesn't. Do your own experiment. (00:32:32): Most best practices, most blog posts are not correct. So how do you set up an experiment? You get your questions, you turn tracking on, give it a couple of weeks. Make your changes, have a test group, have a control group. Intervene on the test group, make your changes, see if the chart went up, see if the control group did not, and now you know your particular strategy worked. (00:32:55): So I would definitely do experiments and I would not assume that stuff you read online is correct. And then you need a team, so who's your team? Probably your team is your SEO team, or your SEO agency or your SEO consultant. Probably, hopefully they can do this stuff, and then however, what I think is hard to hire for is the offsite stuff. (00:33:16): So most SEO people are not going to be amazing at creating YouTube videos and Reddit strategy, so you might need a different person for that. That might be a community generalist marketing person. So it would basically be your SEO team, "Please now do Answer Engine Optimization." And then marketing community team, "Please help me show up in more citations."

**中文翻译:**
第一，确定你想排名的“问题”。我会查看搜索数据，尤其是付费搜索数据，比如：“我的赚钱词（money terms）是什么？竞争对手的赚钱词是什么？”比如我是 Rippling，那 Deel.com 在哪些词上投广告？(00:29:30): 然后把这些词转化成问题。你可以直接把关键词丢给 ChatGPT 说“把这些变成问题”，它做得很好。所以，拿对手或你自己的付费搜索数据，用 ChatGPT 生成问题。这是第一步。第二步，追踪它们。把它们放进 AEO 追踪器或回答追踪器里。(00:29:51): 第三，看谁出现在引用源里，针对不同类别的引用源制定策略。第四，制作你自己的落地页。看看目前出现的是哪种页面？是列表文（listicle）？分类页？文章？还是工具页？找出出现频率最高的页面类型，然后针对性地做一个。 (00:30:14): 怎么让页面排上去？回答所有的追问。人们可能会问哪些后续问题？你可以回到搜索数据，寻找 SEO 主题中的关键词分组。AEO 主题也是同理。然后是站外部分，针对不同组别采取不同策略。(00:30:37): 我会说，取决于公司情况，花钱让联盟站点提到你，如果你有钱这很容易。比如你想成为“最好的信用卡”，你付钱给《福布斯》，你就是最好的。这是策略一：贵、简单、可控。YouTube 和 Vimeo 策略其实也很简单，因为没有社区会跳出来说“我不喜欢你的视频”。(00:30:59): 你拍个视频，想发什么发什么。也许有人看，也许没人看，但你可以拍。有趣的是，尤其在 B2B 领域，YouTube 上大多是美食、旅游、娱乐、美妆。 (00:31:18): 很少有人拍关于“AI 驱动的支付处理 API”的视频，虽然这听起来枯燥，但它是极好的赚钱词。如果你针对这些非常具体、高 LTV（客户终身价值）、可能不那么光鲜的关键词/问题拍视频，其实是大机会。然后是 Reddit，我提过 Webflow 的做法：注册账号，表明身份，给出有用回答。(00:31:48): 这招稍微难点，因为社区可能不喜欢你的回答。你没法保证评论一直都在，但它门槛低，值得一试。最后，实验设计。看看什么有效。SEO 和 AEO 的共同点是：大部分网上的信息和“最佳实践”都是错的。(00:32:13): 因为人们不做分析。某人说了一句话，被反复转发，就成了最佳实践，但从没人做过分析。所以，做了我刚才说的那些事后，要做实验。可能我说的有一半管用，一半不管用。你自己试。(00:32:32): 大多数博客文章都是错的。怎么做实验？拿到问题，开启追踪，观察两周。做改动，设测试组和对照组。在测试组施加干预，看图表是否上升，看对照组是否没变。这样你就知道你的策略是否奏效了。(00:32:55): 所以一定要做实验，不要迷信网上的东西。最后你需要一个团队。谁来做？可能是你的 SEO 团队、代理商或顾问。希望他们能胜任。但我觉得最难招的是做“站外”的人。(00:33:16): 大多数 SEO 人员并不擅长拍 YouTube 视频或搞 Reddit 策略，所以你可能需要一个不同的人，比如社区营销通才。基本上就是让 SEO 团队开始做 AEO，让市场/社区团队帮你在引用源中露脸。

---

### (00:33:35) Lenny Rachitsky

**English:**
Wow, okay. That is incredibly valuable. Thank you for sharing all that. I imagine some of this is you're just giving away a lot of amazing advice for free here. Thank you. First of all, I imagine there's a layer, there's only so far you can go on your own. (00:33:49): And so eventually it's like, "Okay, we really need help." And that's where a team like yours comes in. Let me ask a few questions here to follow up. One is this tracker concept. So what is this tracker, it can track how often you show up? Say Lenny's Newsletter shows up and answers for the questions that I'm targeting?

**中文翻译:**
哇，太有价值了。谢谢你分享这么多，你这简直是在免费赠送顶级咨询建议。首先，我觉得个人能做的有限，(00:33:49): 最终还是会觉得“我们需要专业帮助”，这时候像你们这样的团队就派上用场了。我想追问几个问题。一个是“追踪器（tracker）”的概念。这个追踪器是什么？它能追踪你出现的频率吗？比如追踪 Lenny's Newsletter 在我针对的问题答案中出现了多少次？

---

### (00:34:03) Ethan Smith

**English:**
Yeah, so there's answer tracking, which is like keyword tracking. So keyword tracking would be best growth podcast, and you put that in a keyword tracking tool. There's 100 of them, they're all the same, and you see whether or not what you rank. Maybe you rank, hopefully you rank number one. Now in answers it's very different, but it's related. (00:34:25): So if you ask the same question, you will have different answers each time. If you ask a question, there's different answers per run. And so ChatGPT is basically calculating a distribution of all the potential answers it would give. And depending on when you ask it, it's basically like a weighted, random sample, and so you're going to get different answers. (00:34:46): You also have question variants, so you can ask different versions of the same question, and you might show up in one and you might not show up in another. Then there's different surfaces, there's Perplexity, there's Gemini, there's ChatGPT, there's Meta AI, and so these surfaces have different answers. (00:35:00): And so you essentially need to create a share of voice across all these different things like a distribution. So how often am I showing up? What's my average rank? And that's answer tracking. So then where do you get answer tracking? And answer tracking is essentially an evolution of keyword tracking. So we have a page with 60 different answer tracking tools. (00:35:22): But it's ultimately just like keyword tracking, it's all the same thing roughly. And so pick one of the 60, we have answer tracking, we're building answer tracking. There's 59 other options, probably all pretty good, probably all pretty similar, but pick one. My general suggestion is pick the cheapest one that does what you need. (00:35:41): Just like keyword tracking, you can only, there's not a premium version of keyword tracking. You rank number three or you don't. So pick the keyword tracker that is the cheapest that does what you want. Same with the answer tracking. And so then when I'm doing the experiment, put your answers in, track them, see a chart over time, see your average rank. (00:35:58): How often are you showing up and what's your average rank? And then you make a change, and then hopefully you go up.

**中文翻译:**
是的，有“回答追踪”，就像关键词追踪一样。关键词追踪是比如搜“最好的增长播客”，你把它放进工具里，市面上有上百个这种工具，大同小异，看你排第几，希望是第一。但在回答引擎里，情况不同但相关。(00:34:25): 如果你问同一个问题，每次得到的答案可能都不一样。每次运行都有不同的答案。ChatGPT 基本上是在计算所有潜在答案的分布。根据你提问的时间，它就像是一个加权随机抽样，所以你会得到不同的答案。(00:34:46): 还有问题的变体，你可以问同一个问题的不同版本，可能在一个版本里出现了，在另一个里没出现。此外还有不同的平台（surfaces）：Perplexity, Gemini, ChatGPT, Meta AI，每个平台的答案都不同。(00:35:00): 所以你本质上需要建立一个跨平台的“声量份额（share of voice）”分布。我出现的频率是多少？我的平均排名是多少？这就是回答追踪。去哪找这种工具？它本质上是关键词追踪的进化版。我们有一个页面列出了 60 种不同的回答追踪工具。(00:35:22): 但归根结底它和关键词追踪差不多。从那 60 个里挑一个就行，我们也在开发自己的。其他 59 个可能也挺好，大差不差。我的建议是：选能满足需求的最便宜的那个。(00:35:41): 就像关键词追踪一样，没有什么“高级版”排名，排第三就是第三。所以选个最便宜好用的就行。做实验时，把问题放进去，追踪一段时间，看趋势图和平均排名。(00:35:58): 记录出现频率和平均排名，然后做改动，希望排名能升上去。

---

### (00:36:03) Lenny Rachitsky

**English:**
Amazing. I love this term voice share. I never heard that before, it makes sense. Like percentage of time you're showing up in LLMs, is there an LLM, is it just like ChatGPT? (00:36:13): Is Google equivalent now to ChatGPT? How do you recommend people think about, say, Gemini or Claude, or Perplexity and others?

**中文翻译:**
太棒了。我喜欢“声量份额（voice share）”这个词，以前没听过，但很有道理。就是你在大语言模型中出现的百分比。现在是只看 ChatGPT 吗？(00:36:13): Google 现在和 ChatGPT 等同吗？你建议大家如何看待 Gemini、Claude 或 Perplexity 这些平台？

---

### (00:36:21) Ethan Smith

**English:**
So interestingly, there are similar, foundational algorithms across all of these. They're all using search, they're all using search, and they're all using LLMs, which foundational algorithms are all the same. The results are actually pretty different. So we're doing a study, we're seeing that Google and Bing are not that similar search engines. (00:36:41): We're seeing that ChatGPT citations and Google Search results are actually not that similar. Perplexity is interestingly more similar to Google than ChatGPT. We did a study looking at thousands of questions and saw the citation overlap with Google Search results was around 35% for ChatGPT and Google, so not that much. (00:37:02): Perplexity was around 70%, but essentially they're all similar algorithms, but with very different citations and results. So then look at which surfaces have the most traffic and then track those. You probably don't need to track all of them, but look across all those. (00:37:17): But you do need to look at your share of voice or the percent of time you show up across all these surfaces. You need to ask the question multiple times, and you need to ask the variance of the question to truly know how frequently you're showing up.

**中文翻译:**
有趣的是，所有这些平台的底层算法都很相似。它们都在使用搜索，都在使用大语言模型，基础逻辑是一样的。但结果其实差别很大。我们做过研究，发现 Google 和 Bing 并不是那么相似的搜索引擎。(00:36:41): 我们发现 ChatGPT 的引用源和 Google 的搜索结果其实重合度不高。有趣的是，Perplexity 比 ChatGPT 更像 Google。我们研究了数千个问题，发现 ChatGPT 的引用源与 Google 搜索结果的重合度只有 35% 左右，并不高。(00:37:02): Perplexity 的重合度大约是 70%。本质上算法相似，但引用的内容和结果大相径庭。所以，看看哪些平台流量最大，就追踪哪些。你不需要追踪所有平台，但要覆盖主流的。(00:37:17): 你确实需要关注你在这些平台上的声量份额或出现频率。你需要多次询问同一个问题，并询问问题的变体，才能真正了解你出现的频率。

---

### (00:37:28) Lenny Rachitsky

**English:**
Considering that ChatGPT, they're going to hit something like a billion weekly active users in the near future, do you need to worry about Claude and Gemini and Perplexity? (00:37:39): Is the traffic there meaningful? I know it is a lot of people, but how important is it to focus on those other LLMs?

**中文翻译:**
考虑到 ChatGPT 的周活用户很快就要达到 10 亿了，还需要担心 Claude、Gemini 和 Perplexity 吗？(00:37:39): 那些平台的流量有意义吗？我知道用户不少，但把精力放在其他模型上有多重要？

---

### (00:37:45) Ethan Smith

**English:**
Well, the way that I would answer that is I believe AOL was one of the largest search engines early on and Google was not. And so we could ask in 1999 or whatever, "Should we just focus on AOL search and Yahoo search? Do we really need to worry about Google?" And the answer is we don't actually know. (00:38:04): It's very early, we don't know who's going to win. I do think that ChatGPT for sure is going to be large. Will Perplexity or Claude or these others compete with them? Probably. Just like search, I think that there will probably be multiple winners and probably you'll need to optimize for several. (00:38:18): I don't think that you'll need to optimize for 10, but there'll probably be around three or so that will win that you want to optimize for.

**中文翻译:**
我是这么看的：早年间 AOL 是最大的搜索引擎之一，而 Google 还不是。在 1999 年左右，我们可能会问：“我们是不是只关注 AOL 和 Yahoo 就行了？真的需要担心 Google 吗？”答案是：我们现在其实不知道。(00:38:04): 现在还处于非常早期，不知道谁会笑到最后。我确信 ChatGPT 规模会很大，但 Perplexity 或 Claude 会和它竞争吗？很有可能。就像搜索领域一样，我认为会有多个赢家，你可能需要针对其中几个进行优化。(00:38:18): 我不觉得你需要优化 10 个平台，但大概会有 3 个左右的赢家是值得你投入精力的。

---

### (00:38:26) Lenny Rachitsky

**English:**
Okay. By the way, I want to make it clear, I love Claude. I use Claude and ChatGPT equally, roughly. I didn't want to make it sound like ChatGPT is the only product people use. (00:38:34): Okay. How does this strategy change depending on the kind of company you are? Say you're a B2B SaaS company or a consumer product, does anything in these seven steps change significantly?

**中文翻译:**
好。顺便澄清一下，我很喜欢 Claude，我用 Claude 和 ChatGPT 的频率差不多。我不想让人觉得好像只有 ChatGPT 有人用。(00:38:34): 好，根据公司类型的不同，这个策略会有什么变化吗？比如 B2B SaaS 公司和消费级产品，这七个步骤会有重大调整吗？

---

### (00:38:44) Ethan Smith

**English:**
Let's take B2B, for example. The first thing is that the citations that are being mentioned are going to be quite different. So citation optimization will vary quite a bit.

**中文翻译:**
以 B2B 为例。首先，被提及的引用源会非常不同。所以引用源优化会有很大差异。

---

### (00:38:53) Lenny Rachitsky

**English:**
Just to clarify what you just said, what do you mean when you say citation strategy is different?

**中文翻译:**
澄清一下，你说的“引用策略不同”是什么意思？

---

### (00:38:57) Ethan Smith

**English:**
Meaning the citations that show up for B2B versus marketplaces are different kinds of citations. So for B2B, it might be like TechRadar shows up a ton when I ask questions. I've never read TechRadar, but for some reason it shows up all the time. I'm sure it's great. But TechRadar is showing up a ton for B2B for whatever reason. (00:39:19): In commerce, it's not going to be that, it's going to be Glamour and Cosmopolitan. For marketplaces, it'll be Eater and Yelp, TripAdvisor, places like that, so the kinds of citations that show up are different. Most of the stuff that I've been talking about is specific to B2B stuff that's different for commerce. (00:39:38): So for most B2B questions, the answers are not clickable. There's nothing to click on. And so if you actually want to measure the impact, you cannot just look at last-touch referral traffic. You have to see whether or not you showed up in the answer with tracking. And then you also need to ask the user, "How did you hear about us post-conversion to actually know the impact?" (00:40:00): So it's harder to track for B2B. Also for B2B, you're probably deciding which payroll management software to use after 50 touchpoints. With a brand, it's not going to be you just search for something, you suddenly spent $100,000 on payroll management software. So that's B2B. Commerce is different, so Commerce actually now has more clickable cards like you would in a Google. (00:40:21): So if you ask, "What's the best TV for apartments?" There are actual shoppable cards. Those shoppable cards are showing multiple sellers. Those sellers have rich snippets. Schema is important, the number of reviews are important, so it's actually quite different. You can look at last-touch referral traffic to get a good sense about the number of conversions that you're getting. (00:40:44): For commerce, similar with restaurants and hotels and local marketplaces, similar there. And then I would say early stage is also different. So I mentioned earlier, early stage my recommendation is don't do SEO at all. For Answer Engine Optimization, definitely do AEO, and only do citation optimization and long tail. Don't do any of the mid-SEO stuff, just get cited and answer really specific questions.

**中文翻译:**
意思是 B2B 和平台型（marketplaces）业务出现的引用源类型不同。在 B2B 领域，当我提问时，TechRadar 出现的频率极高。我从没读过 TechRadar，但不知为何它总是出现，肯定很厉害。总之 TechRadar 在 B2B 领域权重很高。(00:39:19): 在电商领域，出现的会是 Glamour 或 Cosmopolitan。对于平台型业务，会是 Eater、Yelp、TripAdvisor 之类的。所以引用源的类型不同。我刚才讲的大部分是针对 B2B 的，电商则不同。(00:39:38): 大多数 B2B 问题的答案是不可点击的，没有跳转链接。所以如果你想衡量影响，不能只看“末次点击引荐流量”。你必须通过追踪来看你是否出现在答案中。你还需要在转化后询问用户“你是怎么知道我们的”，才能真正了解影响。(00:40:00): 所以 B2B 的追踪更难。而且在 B2B 领域，你可能要经过 50 个触点才会决定用哪款薪资管理软件。你不会搜一下就突然花 10 万美元买个软件。这是 B2B。电商则不同，电商现在有很多像 Google 那样的可点击卡片。(00:40:21): 如果你问“适合公寓的最好电视是什么？”，会出现实际的购物卡片。这些卡片显示多个卖家，卖家有富摘要（rich snippets）。Schema 标记很重要，评论数也很重要，所以非常不同。你可以通过末次点击流量很好地感知转化量。(00:40:44): 餐厅、酒店和本地平台也是类似情况。最后，初创阶段也不同。我之前说过，初创期我建议完全不做 SEO。但对于 AEO，一定要做，而且只做引用源优化和长尾。不要做任何中期的 SEO 工作，只要设法被引用并回答非常具体的问题即可。

---

### (00:41:12) Lenny Rachitsky

**English:**
It's so interesting that so much of this is just showing up as the little tag/pill in the answer, because it's obvious now that I think about it. (00:41:21): That's the only way someone will get to your site from an LLM is just clicking that, "Okay, let me go read this article."

**中文翻译:**
很有趣，很多时候这种优化就是为了出现在答案里那个小标签或“药丸”图标里。仔细想想确实显而易见。(00:41:21): 因为那是用户从大语言模型跳转到你网站的唯一途径，点击它说：“好吧，让我去读读这篇文章。”

---

### (00:41:27) Ethan Smith

**English:**
Yes. But what they will do is they will open a new tab, and they will type in the brand name and they'll go to Google. (00:41:33): And then they'll click on your domain, and you will think that it was a branded Google Search when it wasn't. (00:41:38): Or they'll open up a new tab and they will type in your domain, and they'll go directly to your domain and you'll falsely think that it was direct traffic.

**中文翻译:**
是的。但用户也会这么做：他们会开个新标签页，在 Google 里搜你的品牌名。(00:41:33): 然后点击你的域名，你会误以为那是“品牌词搜索流量”，其实不是。(00:41:38): 或者他们直接输入你的域名访问，你会错误地认为那是“直接流量（direct traffic）”。

---

### (00:41:46) Lenny Rachitsky

**English:**
Coming back to a question you raised at the beginning. So for my newsletter, the fact that they're sucking up all this content, I don't even know how much, and sending me some percent of traffic. (00:41:55): Do you have any, I don't know, just sense of is this good? If you were running my newsletter, would you encourage all these outlets to suck up my stuff? And then be like, "Oh yeah, you could check it out in Lenny's Newsletter if you want"?

**中文翻译:**
回到你开头提到的那个问题。对于我的 Newsletter，AI 正在吸走我的内容（我都不知道吸了多少），然后只分给我一小部分流量。(00:41:55): 你觉得这算好事吗？如果你在经营我的 Newsletter，你会鼓励这些平台吸走我的内容，然后指望它们说“哦对了，想看更多去 Lenny's Newsletter”吗？

---

### (00:42:08) Ethan Smith

**English:**
Yes. And I would give the same answer that Brian Balfour gave on your previous episode on this, which is that it's not your choice whether to play the game. You are playing the game whether you want to or not, so you might as well try to show up. If you just say, "Don't look at any of my data," then you cannot show up and your competitors will. (00:42:27): Now, what you can do is you can say, "I don't want you to train on my data, so you can index my site, but please don't train on my data." And they have different user agents for that and different bots, so you can just say, "And we're building a Webflow app to block training but not indexation." (00:42:43): Or you can just put it in your robots.txt, "This training bot not allowed. Index bot, you are allowed." So if you're concerned about that, I would suggest that, and I think probably a lot of people will do that. But saying, "You can't index my site at all," that doesn't make sense to me.

**中文翻译:**
是的。我会给出和 Brian Balfour 在你上一集节目中同样的答案：是否玩这个游戏不是你能选择的。无论你愿不愿意，你都在局中，所以你最好设法出现在答案里。如果你说“别看我的任何数据”，那你就不可能出现，而你的竞争对手会出现。(00:42:27): 你能做的是：你可以说“我不希望你用我的数据进行训练，你可以索引我的网站，但请不要拿去训练模型”。他们有不同的 User Agent（用户代理）和爬虫。你可以说：“我们正在做一个 Webflow 应用来阻止训练但允许索引。”(00:42:43): 或者你可以在 robots.txt 里写：“禁止训练爬虫，允许索引爬虫。”如果你担心这个，我建议这么做，我觉得很多人都会这么做。但如果说“完全不准索引我的网站”，我觉得那没道理。

---

### (00:42:57) Lenny Rachitsky

**English:**
Such a good point, because I don't know if I have competitors in this exact space, but basically they would show up instead and then I lose all that traffic.

**中文翻译:**
很有道理。虽然我不知道在这个特定领域我有没有直接竞争对手，但基本上如果我不出现，别人就会出现，然后我就彻底失去了那部分流量。

---

### (00:43:05) Ethan Smith

**English:**
Yes.

**中文翻译:**
没错。

---

### (00:43:06) Lenny Rachitsky

**English:**
Such a good point. Okay. Let me come back to the steps you shared just to see if there's something here that's worth diving into a little further. So this is essentially how to be more successful showing up in LLM responses. One is figure out what questions you want to rank for. (00:43:19): And you could do this by looking at what your competitors are advertising and their paid ads and things like that. Just look at the terms, ask almost ChatGPT or Claude, "Turn these into questions people would ask to find these terms." Then set up a tracker to see just how you're doing today. How often are you showing up? (00:43:36): There's a million trackers, you have a link willing to check these out. Then you look at who is showing up today? Where are they being taken today? Use that to inform landing pages that you create to answer those questions better. And you make it very clear that it's very important not to just answer that main question, but also follow-up questions. Then there's offsite stuff. (00:43:57): Get into affiliates like Dotdash, YouTube, Reddit, Quora sounds like are the core, and then run an experiment. So you look at this tracker, and let me actually ask this, and the next step is just set up a team. But just to come back to this step, how do you set up an experiment that isn't just like a before, after? How do you do a control group situation?

**中文翻译:**
非常有道理。好，让我回到你分享的步骤，看看有没有值得深入探讨的。这本质上是如何更成功地出现在大语言模型回复中的指南：第一，确定你想排名的“问题”。(00:43:19): 你可以通过观察竞争对手的广告和付费词来实现。看看那些词，让 ChatGPT 或 Claude 把它们变成人们会问的问题。然后设置追踪器看现状，看你出现的频率。(00:43:36): 追踪器有很多，你有链接可以查。然后看现在是谁在排名？流量去了哪？据此制作落地页来更好地回答问题。你强调了不仅要回答主问题，还要回答追问。然后是站外部分。(00:43:57): 进入像 Dotdash 这样的联盟站点，还有 YouTube、Reddit、Quora 看起来是核心。最后运行实验。看着追踪器——我想问的是，下一步是组建团队，但回到实验这一步，你如何设置一个不只是“前后对比”的实验？如何设置对照组？

---

### (00:44:19) Ethan Smith

**English:**
Yeah. So what I would do is I would take 100 different questions, half of them I will intervene, half of them I won't. Or let's say, let's take 200 questions. So 100 of the questions, I'm not going to do anything, so that's my control group. And we are seeing a fair amount of variance and answers just without doing anything at all, so you definitely want a control group. (00:44:40): And also we're seeing people are using LLMs more and LLM traffic is going up. So you definitely need a control group, especially in Answer Engine Optimization. So control group is, "Don't touch it at all, leave it as it is." That's the control group. Test group would be, "I'm going to now comment on Reddit threads, so let's test that." (00:44:57): Or I'm now going to make a YouTube, Vimeo video, or I'm now going to pay Forbes advisor to say that I'm the best credit card. Maybe break those up into a few different buckets, track them. Have a couple of weeks before, a couple of weeks after, compare against the control group. (00:45:11): And then the stuff that went up when the control group did not worked, and the stuff that didn't did not, and then reproduce it. So reproducibility is very important. And my background's in academic research, and it's common to do a study that cannot be reproduced. And so for something to truly be accepted with an academian, it needs to be reproducible. (00:45:34): Meaning multiple people have done this study and reproduced that thing over and over again. And especially in SEO, it's common for something to change. And you think that it was this thing that caused it and it's actually not, and you just assume forever that that works. So reproducibility is very important. (00:45:49): Try to do that study multiple times, try to get studies from other people, and if it works 10 times, then it probably works. And this comes back to the waste problem, most work is wasted in SEO. Most work is wasted in AEO, so how do you know what's not wasted? You do an experiment, you don't assume that what you read online is true. (00:46:07): You do your own experiment, and then you reproduce it multiple times, and keep doing the stuff that works and don't do the stuff that doesn't.

**中文翻译:**
好。我会选 100 个不同的问题，一半进行干预，一半不干预。或者选 200 个问题，100 个什么都不做，作为对照组。我们发现即使什么都不做，答案也会有很大波动，所以对照组必不可少。(00:44:40): 而且现在大语言模型的使用量在增加，整体流量在涨，所以你更需要对照组来排除大盘增长的影响。对照组就是“完全不动，保持原样”。测试组可以是：“我现在要去 Reddit 评论区留言，测试一下效果。”(00:44:57): 或者“我现在去拍 YouTube 视频”，或者“我付钱给《福布斯》说我是最好的信用卡”。把这些分成几个桶（buckets）进行追踪。观察前两周和后两周，与对照组对比。(00:45:11): 如果测试组涨了而对照组没涨，那说明有效；反之则无效。然后要“可重复（reproduce）”。可重复性非常重要。我的背景是学术研究，学术界经常有无法重复的研究。要让学术界真正接受一个结论，它必须是可重复的。(00:45:34): 意味着多个人做这个实验都能得到同样的结果。尤其在 SEO 领域，经常发生一些变化，你以为是 A 导致的，其实不是，但你却从此迷信 A 有效。所以可重复性至关重要。(00:45:49): 尝试多次实验，看看别人的研究。如果 10 次都有效，那大概率是真的有效。这又回到了“浪费”的问题：SEO 中大部分工作是无用功，AEO 也是。你怎么知道哪些不是无用功？做实验，别迷信网上的话。(00:46:07): 自己做实验，多次重复，坚持做有效的，放弃无效的。

---

### (00:46:15) Lenny Rachitsky

**English:**
It feels like such a big deal to win at AEO. Just coming back to this idea that people are coming to ChatGPT, Claude, Gemini looking for an answer. (00:46:25): If you're that answer, I feel like that could just make or break your company. It feels like even more important than SEO, just getting this right.

**中文翻译:**
感觉在 AEO 中获胜意义重大。回到这个想法：人们去 ChatGPT、Claude、Gemini 是为了寻找答案。(00:46:25): 如果你就是那个答案，我觉得这甚至能决定一家公司的成败。感觉把这件事做对，甚至比 SEO 还要重要。

---

### (00:46:33) Ethan Smith

**English:**
I would say that where I want to get the most conversions possible, how big is the channel? The channel is not as big as search. The search is definitely larger, but it is a substantial channel now. And Webflow, they get 8% of those signups from LLMs. (00:46:50): It's now one of your top channels so it's large. It's not the largest channel, it's not the number one channel. Paid is probably the number one channel, but it's definitely a substantially large channel and one worth optimizing for.

**中文翻译:**
我会说，从获取转化的角度看，这个渠道有多大？它目前还没搜索（Search）那么大。搜索肯定更大，但 AEO 已经是一个不容忽视的渠道了。在 Webflow，他们有 8% 的注册来自大语言模型。(00:46:50): 它已经是核心渠道之一了，规模很大。虽然不是最大的，也不是第一大渠道（第一可能是付费广告），但它绝对是一个相当大的、值得优化的渠道。

---

### (00:47:02) Lenny Rachitsky

**English:**
And as you said, probably growing over time.

**中文翻译:**
而且正如你所说，它可能会随时间不断增长。

---

### (00:47:04) Ethan Smith

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:47:05) Lenny Rachitsky

**English:**
Okay. Let me zoom out a little bit, and let me just ask you this. (00:47:08): What do you think are maybe the most surprising or underdiscussed topics when it comes to AI and SEO and AEO that we haven't already talked about?

**中文翻译:**
好。让我把视角放大一点。我想问：(00:47:08): 在 AI、SEO 和 AEO 领域，你认为有哪些最令人惊讶、或者讨论得还不够深入的话题是我们还没聊到的？

---

### (00:47:18) Ethan Smith

**English:**
The first thing is that there's significant misinformation on AI and on AEO, and it's pretty extreme. It's unusually the percent of misinformation to correct information is pretty substantial. So one example is every two years there's news articles about how Google Search is going to die or it is dying because there's a new thing. (00:47:42): So that's happening right now with AI Overviews and with AEO, Google's going down, which is not true. Before that it was TikTok search, so everyone is using TikTok now. Gen Z is using TikTok, they're never going to use SEO. SEO's going to be dead, and so you really need to focus on TikTok search, which is not false. It's not untrue, but it's not taking share away from Google, it's just a new surface. (00:48:05): And then before that it was Instagram, and then before that it was Facebook and it was YouTube. And people do search and discover on Instagram, TikTok, YouTube, but it doesn't take away from Google Search. It adds on top of it. These are all new channels, so Google's slice of the pie stays the same, the pie gets bigger. (00:48:23): And so misinformation about Google going down, Google is not going down. Google published something recently, their VP of search explicitly said, "I looked at the traffic that we're sending to publishers, and it is not down, it's up slightly." So it is not true that Google Search is going down. (00:48:37): And most of the news information about that is saying that it's going down, so that's the first surprising thing. The second surprising thing is tooling. And I've never seen a channel where these extremely expensive tools that essentially do commodity tasks. So imagine if I said, "I'm going to charge you $50,000 for keyword tracking." (00:48:59): You would say, "Well, of course, that's absurd. It's keyword tracking, I could write this in a day." No one would do that. But for answer engines, it's mysterious and people don't really know how it's working. Also, the slope of the growth curve is so significant, that I'm seeing people spend huge amounts of money on what are essentially keyword tracking commodities. (00:49:19): So that's the second thing. The third thing is the growth curve of the channel. And we did a Reforge AEO webinar a year ago, and there was excitement and then it died and there was very little excitement about it. This was in June, and then people didn't really care. They were intrigued intellectually by it, but they didn't care because they didn't see the impact from that. (00:49:40): So there was essentially very little interest between July and January, and then suddenly in January it's just skyrocketing. So it's ChatGPT launches, people are very interested, and then it's not that interesting for growth people. And then there's this little spike in June, and then it's like this, which is usually not what you see with a new channel. (00:50:01): So the slope of the curve is unusually steep, and the shape of the curve is also very unusual. The last is that a lot of people do think that SEO and AEO are different and they're not different. I think probably part of that is because it sounds great to say that there's this new channel, it's completely different. (00:50:23): And I'm an expert and I have a tool to sell you, and it's totally unique and all these other tools are not relevant. In reality, it's actually there's quite a bit of overlap. There is the difference of the citation optimization. The head is different and the tail is different, but the core technology is pretty similar. So those are probably the most surprising things.

**中文翻译:**
第一点是，关于 AI 和 AEO 存在大量的误导信息，而且非常极端。误导信息与正确信息的比例高得离谱。一个例子是：每隔两年就会有新闻说 Google 搜索要完蛋了，因为出现了新东西。(00:47:42): 现在 AI Overviews 和 AEO 出现了，大家又在说 Google 要垮了，这不是真的。之前是 TikTok 搜索，说 Gen Z 都在用 TikTok，再也不用 SEO 了，SEO 已死，你得关注 TikTok 搜索。这不完全是假话，但 TikTok 并没有抢走 Google 的份额，它只是一个新平台。(00:48:05): 再之前是 Instagram，再之前是 Facebook 和 YouTube。人们在这些平台上搜索和发现，但它不影响 Google 搜索，而是在其之上增加了需求。这些都是新渠道，Google 的蛋糕份额没变，只是蛋糕变大了。(00:48:23): 所以关于 Google 衰落的说法是误导。Google 最近发布的数据显示，其搜索副总裁明确表示：“我查看了我们发送给出版商的流量，不仅没降，还略有上升。”所以 Google 搜索并没有衰落。(00:48:37): 但大多数新闻都在唱衰，这是第一个惊讶点。第二是工具。我从未见过哪个渠道会有如此昂贵的工具去处理本质上是“大宗商品级（commodity）”的任务。想象一下如果我说：“追踪一个关键词我要收你 5 万美元。”(00:48:59): 你会觉得荒谬，因为关键词追踪我一天就能写出来。没人会付钱。但对于回答引擎，因为它很神秘，大家不知道怎么运作，加上增长曲线太陡峭，我看到人们在本质上是关键词追踪的工具上挥金如土。(00:49:19): 这是第二点。第三是渠道的增长曲线。一年前我们做过一个 Reforge AEO 网络研讨会，当时大家很兴奋，然后热度就退了。那是 6 月份，之后大家就不怎么关心了。大家在智力上感兴趣，但因为没看到实际影响，所以不在乎。(00:49:40): 所以从 7 月到 1 月几乎没人感兴趣，然后 1 月突然就爆发了。ChatGPT 发布时大家很感兴趣，然后增长人员觉得没意思，6 月有个小高峰，然后就是现在的暴涨。这种曲线在传统新渠道中很少见。(00:50:01): 它的斜率异常陡峭，形状也非常奇特。最后一点是，很多人认为 SEO 和 AEO 是完全不同的，其实不然。我觉得部分原因是，如果说“这是一个全新的渠道，完全不同”，听起来很酷。(00:50:23): 这样“专家”就能卖给你一个“完全独特”的工具，说别的工具都没用了。实际上，两者有大量重叠。虽然引用源优化、头部和长尾有所不同，但核心技术非常相似。这些就是最令我惊讶的事。

---

### (00:50:43) Lenny Rachitsky

**English:**
This piece about January being the inflection point, you mentioned that it was because references started showing it more prominently. Is that the big change?

**中文翻译:**
关于 1 月份是拐点这一点，你提到是因为引用源开始显示得更显著了。这是最主要的变化吗？

---

### (00:50:51) Ethan Smith

**English:**
I think it's increase of adoption of LLMs by people, so it's just actually growing more and then the clickability. And I am seeing, you are seeing now this large increase of actual clicks. (00:51:02): Probably before you got no clicks, even if you showed up an answer, so the clickability of the answer has increased. (00:51:08): Especially for things like commerce and local and hotels, because they have these rich modules where you can click on stuff and go somewhere, which was not true before. That and I think people are just using LLMs more.

**中文翻译:**
我认为是大语言模型在人群中的采用率提高了，用户量在增长，再加上“可点击性”。我现在看到，你也看到了，实际点击量大幅增加。(00:51:02): 以前即使你出现在答案里，可能也没人点。现在答案的可点击性增强了。(00:51:08): 尤其是电商、本地服务和酒店类，因为它们有了丰富的模块，你可以点击并跳转，这在以前是没有的。此外就是人们用得更多了。

---

### (00:51:20) Lenny Rachitsky

**English:**
Ethan, let me just say, I'm learning so much from this conversation, what a fun thing. I could see, it's just clear how much you love this stuff, and just how nerdy and deep you get into it. And it's just fun to talk to someone that's so deep and knowledgeable about all these things, so thank you for sharing all this with us. (00:51:36): I'm going to go in a slightly different direction. There's this whole world of AI content, people generating content with AI, generating landing pages. Just like, "Oh my God, SEO is never going to just generate all this stuff. AI is going to make all this stuff easier." (00:51:48): You guys did a really big study on how that works, whether it's a good idea to generate content with AI. Can you just talk about what you learned from that, and how people should think about AI in generating content?

**中文翻译:**
Ethan，我得说，这次对话让我学到了太多，太有意思了。我能感觉到你有多热爱这些东西，钻研得有多深、多“极客”。和如此博学的人聊天真是种享受，谢谢你分享这些。(00:51:36): 我想换个方向。现在到处都是 AI 生成的内容，人们用 AI 写文章、做落地页。大家都在感叹：“天呐，SEO 以后全是自动生成的了，AI 让这一切变得太简单了。”(00:51:48): 你们针对“用 AI 生成内容是否是个好主意”做了一项大规模研究。能聊聊你们的发现吗？人们应该如何看待 AI 生成内容？

---

### (00:51:59) Ethan Smith

**English:**
Yes. So I remember when ChatGPT launched and Brian Balfour posted on LinkedIn, "What do you people think that is going to happen from ChatGPT and AI?" And my immediate response is spam, so just lots and lots of spam, especially SEO spam. And then there was a whole industry around AI-generated content, and I knew immediately that it wouldn't work. (00:52:20): And the reason why I knew it wouldn't work, and when I say AI-generated content, I mean automated content with no human-in-the-loop. So I think that the future of content is clearly AI-assisted. Clearly, you and I will be using AI to help us write, so it's not no AI at all, but it's not 100% generated with AI. I immediately knew that it wouldn't work. (00:52:38): Why did I know that? I knew that because I created spam in 2007, and I knew what Google did about it and how, and I knew the exact same thing was going to happen. So what I did in 2007 is I and all the other shopping comparison people scraped all each other's content, reviews, chopped it up, scraped content, 100 million search pages, snippets, and it worked really well. (00:53:02): And then it stopped working, and then all those companies disappeared. I knew that was exactly what's going to happen with AI-generated content. And so from the beginning, I've not focused on AI-generated content. Many people have, but I don't know, so maybe it does work. There's lots of case studies about it working. (00:53:20): So let's do the study, let's do an analysis. So we took, we looked at both Google and at ChatGPT where we took thousands of searches and thousands of questions, and we put those searches into Google Search. We put those questions into chat and the ChatGPT, and then we looked at the citations or the Google Search results. Then we looked at an AI detector. (00:53:43): So we used Surfer SEO's AI detector. Now, when I tell people this, they say, "Well, you can't detect AI." So then we evaluated the efficacy and the accuracy of the AI detector. So we did that by generating thousands of AI-generated articles and it was very predictive. And then we looked at real articles, we did that two different ways. (00:54:05): One way is we write real articles, and the other is we took a random sample of 100,000 URLs from Common Crawl over the last five years. And then we looked at the AI detector before ChatGPT was launched, so it necessarily was content not created by a human. And then the false positive rate was around 8%, so basically the AI detector is very accurate. (00:54:29): So we took that, then we ran it on the content. So then what we saw was around 10% to 12% of content in Google Search, and then ChatGPT or AI-generated, 90% are not. And we ran a correlation analysis showing the exact same thing. So we essentially did a very rigorous study showing that AI content does not work. AI-assisted content edited is great. (00:54:52): We do that sometimes, other people do that, that is clearly the future of content. So that does work and should work and that's good, but purely 100% AI-generated does not work. So then the second thing that we did was we found that, this was unexpected, but we found that there's more AI-generated content on the internet than human-generated content. (00:55:13): So back to the Common Crawl study, we looked at 100,000 different URLs over the past five years. And then you can see this curve where AI-generated is now higher than human-created. So there's more AI-generated content on the internet than human-generated content, which is disturbing. So then let's say that AI-generated content did work. (00:55:32): If AI-generated content worked, then everyone would do it. Just like in 2007, shopping comparison sites, if I can scrape my content, why would I pay anyone to write it? I'll just scrape it from you and I'll chop it up. So then everyone will do that, and then it will go from most content is AI-generated to almost all of the content is AI-generated. (00:55:51): Then what will happen if that works, is that Google now becomes a search engine for ChatGPT responses. So if Google's a search engine for ChatGPT responses, there's no reason for Google to exist. Just go to ChatGPT, which is the exact same thing that happened in 2007. (00:56:04): Google said, "I see all these shopping comparison search engines showing up in my search results. So I'm essentially a search engine for search engines." I should be showing the TV in my results. I shouldn't be showing other vertical search engines, so I'm going to get rid of them and I'm just going to go straight to the product. (00:56:23): The same thing will be true for ChatGPT. Now for ChatGPT, let's say that ChatGPT ranks its own derivatives in its citations, so then you have this infinite loop of derivatives. So I go to ChatGPT, I say, "Generate 10 articles." I put those articles into the citations and then I say, "Summarize these citations that were derivative." (00:56:41): And then I keep on doing derivatives of derivatives, and then you have an infinite loop of derivatives, and now AI is summarizing itself. There's a paper about this called Model Collapse. So again, there's the core algorithm and then there's the RAG piece. So the core algorithm, a group did a study showing model collapse, which was what if you feed in AI derivatives into the model and train the core model on the derivatives? (00:57:06): And then what happened was you had all these problems, hallucinations, things break very quickly. Okay. So then we did a study on what if you feed derivatives into the RAG piece? So generate 10 derivatives, put that into RAG, summarize that. And then generate 10 more, and then summarize my summarizations, infinite loop of derivatives. What happens? (00:57:25): And so what happens is there's a wisdom of the crowd. The LLM is summarizing the opinion of many people. So if you ask a question like, "What's the best flavor of ice cream?" There's not one answer, there's thousands of opinions. So the LLM is summarizing these many, many opinions in this wisdom of the crowd. (00:57:40): And the wisdom of the crowd basically says that, "If you take the average of a large group of people, their average response will be better than the best single individual in the group." And so it's better to have more diversity of opinions, wisdom of the crowd. So what happens to the infinite loop of derivatives? You essentially converge on one opinion. (00:58:00): So if you ask, "What's the best flavor of ice cream?" It will eventually say, "It's vanilla and it's only vanilla, and there's no other flavor of ice cream." And so that's a simple example, but if you feed in derivatives of derivatives into the model, you'll basically take the wisdom of the crowd. (00:58:15): And that will shrink and you'll have a single opinion on everything, which is really bad. So that's what happens if AI content, 100% unassisted AI content works.

**中文翻译:**
是的。我记得 ChatGPT 刚发布时，Brian Balfour 在 LinkedIn 上问：“大家觉得 ChatGPT 和 AI 会带来什么？”我当时的直觉反应就是：垃圾信息。铺天盖地的垃圾信息，尤其是 SEO 垃圾。随后出现了一个 AI 生成内容的产业，但我立刻就知道它行不通。(00:52:20): 我之所以知道它行不通——我指的是那种完全没有人工参与的自动化内容。我认为内容的未来显然是“AI 辅助”的。你我会用 AI 帮我们写，但不是 100% 由 AI 生成。我当时就知道纯 AI 生成行不通。(00:52:38): 为什么？因为我在 2007 年制造过垃圾信息，我知道 Google 是怎么处理的，也知道历史会重演。2007 年，我和其他做购物对比的人互相抓取内容、评论，切碎重组，搞了 1 亿个搜索页面，效果一度很好。(00:53:02): 但随后它就失效了，那些公司也倒闭了。我知道 AI 生成内容也会面临同样的命运。所以从一开始我就没关注纯 AI 生成内容。虽然很多人在做，也有案例说有效，但我不信。(00:53:20): 于是我们做了研究。我们对比了 Google 和 ChatGPT，输入数千个搜索词和问题，查看引用源和搜索结果。然后我们用 AI 检测器进行检测。(00:53:43): 我们用了 Surfer SEO 的 AI 检测器。有人会说“AI 无法被检测”。于是我们评估了检测器的准确性。我们生成了数千篇 AI 文章，检测器非常精准。然后我们看真实文章，用了两种方法：(00:54:05): 一是我们自己写的真人文章；二是从过去五年的 Common Crawl 数据中随机抽取 10 万个 URL。因为那是 ChatGPT 发布前的数据，必然是真人写的。结果误报率只有 8% 左右，说明检测器非常准确。(00:54:29): 接着我们检测了现在的搜索结果。发现 Google 搜索和 ChatGPT 引用源中，只有 10% 到 12% 是 AI 生成的，90% 依然是真人内容。相关性分析也证明了这一点。所以我们通过严谨的研究证明：纯 AI 内容行不通。而 AI 辅助、人工编辑的内容很棒。(00:54:52): 我们在做，别人也在做，这显然是内容的未来。这有效且应该被提倡。但 100% 纯 AI 生成不行。第二点发现很意外：互联网上 AI 生成的内容已经比真人生成的多了。(00:55:13): 回到 Common Crawl 的研究，看过去五年的 URL，你会发现 AI 生成内容的曲线已经超过了真人内容。这很令人不安。那么，假设 AI 生成内容真的有效会怎样？(00:55:32): 如果有效，所有人都会去做。就像 2007 年，如果抓取内容就能排第一，我为什么要付钱请人写？我会抓取你的内容切碎再发。于是所有人都会这么干，互联网内容会从“大部分是 AI 生成”变成“几乎全是 AI 生成”。(00:55:51): 如果那样，Google 就会变成一个“ChatGPT 回复的搜索引擎”。如果 Google 搜出来的全是 ChatGPT 的东西，那 Google 就没存在的必要了，直接去用 ChatGPT 就好了。这和 2007 年一模一样。(00:56:04): 当时 Google 说：“我发现搜索结果里全是购物对比搜索引擎，我成了‘搜索引擎的搜索引擎’。”我应该直接在结果里显示电视机，而不是显示别的垂直搜索引擎。于是 Google 把它们都干掉了，直接链接到产品。(00:56:23): ChatGPT 也是一样。如果 ChatGPT 的引用源里全是它自己的衍生品（derivatives），就会陷入“无限衍生循环”。我去 ChatGPT 说“生成 10 篇文章”，把文章发出去变成引用源，然后 ChatGPT 又去总结这些衍生出来的引用源。(00:56:41): 这种“衍生的衍生”会导致 AI 在总结它自己。有一篇论文管这叫“模型坍塌（Model Collapse）”。核心模型如果用 AI 衍生数据训练，(00:57:06): 就会出现幻觉、系统崩溃等问题。好，那如果是在 RAG 环节喂给它衍生内容呢？生成 10 个衍生品，喂给 RAG，总结，再生成，再总结，无限循环。会发生什么？(00:57:25): 答案是“群体智慧”消失了。大语言模型本质上是在总结众人的观点。如果你问“最好吃的冰淇淋口味是什么？”，没有标准答案，只有成千上万的观点。模型在总结这种群体智慧。(00:57:40): 群体智慧理论认为，大群体的平均响应通常优于群体中最优秀的个体。所以观点越多样越好。而无限衍生循环会导致观点“收敛”。(00:58:00): 最终它会告诉你：“最好吃的只有香草味，没有别的口味。”这是一个简单的例子，但如果模型只吃自己的衍生数据，群体智慧就会萎缩，最终对所有事情都只有一种单一观点，这非常糟糕。这就是如果纯 AI 内容奏效会带来的后果。

---

### (00:58:25) Lenny Rachitsky

**English:**
I'm afraid of this world where everything is trained on AI, and AI is trained on AI and generating AI, and just like nothing is trusted. And I love how it's interesting just how much of these incentives are driving this. (00:58:36): If ChatGPT was finding this valuable, this is what people do and then just goes off the rails. So there's just some team there that is keeping this from happening. How do you think this evolves? (00:58:46): If you were them, what would you do over the next few years to keep things high quality and not drive these perverse incentives?

**中文翻译:**
我也害怕那个世界：万物皆由 AI 训练，AI 训练 AI，AI 生成 AI，最终什么都不可信。有趣的是，利益动机在驱动这一切。(00:58:36): 如果 ChatGPT 觉得这些内容有价值，人们就会疯狂制造，然后系统就会失控。所以肯定有团队在阻止这一切。你觉得未来会如何演变？(00:58:46): 如果你是他们，未来几年你会怎么做来保持高质量，并避免这些扭曲的激励机制？

---

### (00:58:55) Ethan Smith

**English:**
So I would identify what the perverse incentives might be, and AI-generated content is one of them. The second thing is I think that LLMs and search are going to converge. And so you're seeing that with Google Search where they're having LLM, AI Overviews. You're seeing that with LLMs where they're incorporating maps and shopping carousels, and it's converging on search. (00:59:14): I think it'll converge on a single experience, so that's the first thing. Figure out what 2007 Ethan would do not to create spam and make sure that he doesn't do that, like AI-generated content or it's great content. That'd the second thing. And the third thing is there's all these other interesting features, use cases that LLMs can be great for. (00:59:33): So LLMs could be great for remembering everything that you've ever asked. It could be good for personalizing stuff specifically to Lenny. One interesting use case that I think will eventually come would be, I say, "Plan a trip to San Francisco," and decisions are made for you without any intervention. I have this wonderful EA named Jen. (00:59:51): And I say, "Jen, I'm going to Miami. Please, just do everything for me," and she does everything for me. She knows me, she knows my preferences, she knows that I want a ocean view and I want a restaurant with music. She does all of that and I don't have to intervene. AI can essentially do that eventually, and that would do that because it would deeply understand you. (01:00:09): It would remember everything about you. It would have context, it would have a reasoning, and then it would be able to make all these decisions without your intervention, which would be autonomous agents. So I think that that's also another very interesting place for someone like me to optimize for as well.

**中文翻译:**
我会先识别出那些扭曲的激励机制，AI 生成内容就是其中之一。第二，我认为大语言模型和搜索将会融合。你看到 Google 搜索引入了 AI Overviews，也看到大语言模型引入了地图和购物轮播，它们都在向搜索靠拢。(00:59:14): 我认为它们最终会融合成一种单一的体验。所以第一步是防范像 2007 年的我那样的人制造垃圾，确保系统只奖励好内容。第三，大语言模型还有很多有趣的用例。(00:59:33): 比如它可以记住你问过的所有问题，为 Lenny 量身定制内容。一个我认为终将实现的有趣用例是：我说“帮我规划去旧金山的旅行”，系统会在没有任何人工干预的情况下替我做决定。我有一个很棒的助理叫 Jen。(00:59:51): 我说：“Jen，我要去迈阿密，请帮我搞定一切。”她就会搞定一切。她了解我，知道我的喜好，知道我想要海景房和有音乐的餐厅。她做了所有事，我无需介入。AI 最终也能做到这一点，因为它会深度理解你。(01:00:09): 它会记住关于你的一切，拥有上下文和推理能力，然后无需你干预就能做出决定，这就是“自主智能体（autonomous agents）”。我认为这也是像我这样的人未来要去优化的一个非常有趣的领域。

---

### (01:00:25) Lenny Rachitsky

**English:**
Yeah. I was just going to say, just imagine not even being told this is what you're choosing. Like, "Oh, and go check out, subscribe to the best newsletter out there." And if you're out there, the good things will happen. (01:00:36): Wow, what a wild world. Is there anything else that we haven't covered that you think would be helpful to folks that are trying to get better at this stuff? Try to take the first steps down this road of AEO?

**中文翻译:**
是的。想象一下，系统甚至不用告诉你选项，直接说：“哦，顺便帮你订阅了市面上最好的 Newsletter。”如果你就在那个推荐位上，好事就会发生。(01:00:36): 哇，真是个疯狂的世界。关于 AEO 的起步，还有什么我们没聊到、但对想入门的人有帮助的吗？

---

### (01:00:53) Ethan Smith

**English:**
Yes, the most exciting topic, which is help center optimization and support.

**中文翻译:**
有，一个最令人兴奋的话题：帮助中心（Help Center）优化和支持。

---

### (01:00:54) Lenny Rachitsky

**English:**
Sweet.

**中文翻译:**
太棒了。

---

### (01:00:54) Ethan Smith

**English:**
So I mentioned that people in chat are asking follow-up questions. They're looking for tools. Do you have this feature, this use case, this integration? And that frequently can be answered in help centers. Usually, you would not have an SEO team and say, "We really want you guys to focus on the help center." (01:01:14): But in chat, since there's all these questions about can you do this thing, can you fulfill my use case? A help center is actually a great place to do that, and so I think how can you optimize the help center? So number one is it's frequently on a subdomain. For whatever reason, subdomains don't work as well as subdirectories, so move it to a subdirectory, number one. (01:01:33): Number two is make sure that you're cross-linking well. So usually you do not have optimized internal links, so link from help center page to help center page, make sure there's lots of cross-linking. The third is you probably have help center content about the head, but the tail you probably don't have any help center content for. (01:01:51): So an example of this is I was looking for, I wanted to track our sales calls and look to see who was in the meeting and what the sentiment was. And I wanted to put that into Looker, so I said, "Which meeting transcription tool integrates with Looker?" And the answer is none of them, but you could use Otter because Otter has a Zapier integration. (01:02:15): You could send a Zap of the meeting, put it into BigQuery, and then do Looker on top of that. But there wasn't a help center article about that because it's a very obscure use case, but it's not a zero use case. And so the tail, there's going to be a bunch of questions in the tail that you may not have help center articles for. (01:02:31): So again, what are the questions in sales calls? What are the questions that you're seeing in customer support? Having pages for that, I might even open up to the community. Anyone can ask anything because the community will then fill on the tail and then answer those. (01:02:46): And again, in many cases there might be nobody talking about this at all. So you could be the only citation for this, and then win that tail of questions.

**中文翻译:**
我提到过，对话中的用户会问很多追问。他们在找工具，问：你有这个功能吗？支持这个用例吗？有这个集成吗？这些问题通常能在“帮助中心”找到答案。通常你不会让 SEO 团队去盯着帮助中心，(01:01:14): 但在对话时代，既然有这么多关于“你能做这个吗”的问题，帮助中心就成了绝佳的阵地。那么如何优化帮助中心？第一，它通常在二级域名（subdomain）上。由于某种原因，二级域名的效果不如子目录（subdirectory），所以第一步是把它迁到子目录。(01:01:33): 第二，确保做好内链（cross-linking）。通常帮助中心的内链做得很烂。要让页面之间互相链接。第三，你可能只有关于核心功能的帮助文档，但缺乏长尾内容的文档。(01:01:51): 举个例子：我想追踪销售电话，看谁参会了以及情绪如何，并把数据导入 Looker。我问：“哪款会议转录工具能集成 Looker？”答案是“没有”，但你可以用 Otter，因为它有 Zapier 集成。(01:02:15): 你可以通过 Zapier 把会议发到 BigQuery，再用 Looker 分析。但当时没有关于这个的帮助文档，因为这是个很冷门的用例，但它确实存在。所以长尾中有很多问题是你还没写文档的。(01:02:31): 再次强调：去销售电话和客户支持里找问题。为这些问题做页面，甚至可以开放社区，让任何人提问，让社区来填充这些长尾答案。(01:02:46): 很多时候，可能全网都没人在聊某个点，如果你写了，你就是唯一的引用源，从而赢下那个长尾问题。

---

### (01:02:55) Lenny Rachitsky

**English:**
Are there any help desk, I don't know, system software that are just making this easier yet? Or do you think that's an opportunity for, say, Zendesk or Intercom?

**中文翻译:**
有没有什么客服系统软件已经让这件事变得更简单了？或者你觉得这对 Zendesk 或 Intercom 来说是个机会？

---

### (01:03:02) Ethan Smith

**English:**
I think probably all of them should work perfectly well. I think that the only thing you need to do is cross-linking and subdirectory rather than subdomain, which probably most of them do. So I think that they should all work for free. (01:03:12): That the main thing you would want to do would be, again, open it up to the community and make sure that you fill in the tail. But probably all those tools should be good for this.

**中文翻译:**
我觉得它们应该都能胜任。你唯一需要做的就是搞好内链，并使用子目录而不是二级域名，大多数工具应该都支持。所以这几乎是免费的红利。(01:03:12): 核心还是那句话：向社区开放，确保覆盖长尾。现有的工具应该都够用了。

---

### (01:03:19) Lenny Rachitsky

**English:**
Well, with that, we've reached our very exciting lightning round. I've got five questions for you, Ethan. Are you ready?

**中文翻译:**
好，现在进入激动人心的闪电问答环节。我有五个问题，Ethan，准备好了吗？

---

### (01:03:24) Ethan Smith

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### (01:03:25) Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
你最常向别人推荐的两三本书是什么？

---

### (01:03:30) Ethan Smith

**English:**
Number one is Emotional Intelligence, and people talk about the concept of emotional intelligence, but there's actual research and psychology around that. I believe it was published in the '80s, but there's a really good book that summarizes the foundational research around emotional intelligence. And it's very useful when building relationships and communicating with people to understand their emotions. So that's the first one. And doing growth because growth is getting people to use your stuff. And so if you have frameworks to inform how people will use your things, then you can be a more effective growth person. Which brings me to my second book, which is Cialdini's Persuasion book. Robert Cialdini does a bunch of books around persuasion, but again, there's frameworks for how to persuade somebody to sign up, buy something. And so he breaks down his framework for that, and again, it's based on psychology. And I think especially in growth, there's all kinds of psychology research and behavioral economics research to inform tests. (01:04:25): And if you just read Thinking, Fast and Slow, Persuasion, Emotional Intelligence, you can basically take those frameworks and apply it to growth in all kinds of different ways. And then the last is How to Measure Anything. So How to Measure Anything is about measuring things that are not immediately obvious to measure. (01:04:42): They give this example of they wanted to measure how good an orchestra conductor was and they could survey or they could see the number of standing ovations for each orchestra conductor. And the more standing ovations probably means it's this better one and that you don't need to survey people. (01:04:58): But much of growth and business is things that are not immediately obvious for how to measure, but anything could be measured, and so that's my third record.

**中文翻译:**
第一本是《情商》（Emotional Intelligence）。大家都在谈情商，但这本书里有真正的心理学研究。它大概是 80 年代出版的，很好地总结了情商的基础研究。在建立关系和沟通时，理解他人的情绪非常有用。这是第一本。做增长本质上是让人们使用你的产品，如果你有框架来理解人们的行为，你会更高效。这就引出了第二本：西奥迪尼的《影响力》（Persuasion）。罗伯特·西奥迪尼写了很多关于说服的书，提供了如何说服别人注册或购买的框架，这同样基于心理学。在增长领域，心理学和行为经济学研究对测试非常有启发。(01:04:25): 如果你读过《思考，快与慢》、《影响力》和《情商》，你就能把这些框架应用到增长的方方面面。最后一本是《如何衡量万事万物》（How to Measure Anything）。它讲的是如何衡量那些看起来无法衡量的东西。(01:04:42): 书里举了个例子：想衡量一个管弦乐指挥有多棒，你可以做问卷，也可以看起立鼓掌的次数。起立鼓掌越多，可能指挥得越好，你甚至不需要问卷调查。(01:04:58): 增长和业务中的很多东西都不直观，但万事万物皆可衡量。这是我的第三本推荐。

---

### (01:05:06) Lenny Rachitsky

**English:**
Is there a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
最近有没有什么你非常喜欢的电影或电视剧？

---

### (01:05:09) Ethan Smith

**English:**
I don't really watch TV, but I watch two different groups of things. I watch really aggressive sports, so I really like Michael Jordan documentary, Last Dance. I like Lance Armstrong documentaries about how aggressive and confrontational he is, and I love watching UFC. I like extreme aggression and intensity. The other group of stuff that I like to watch are climbing documentaries. (01:05:34): So anything that Alex Honnold, Jimmy Chan do, I watch all that, which is the exact opposite of aggressive sports. So it's zen, being present, slow-and-steady craftsmanship. But this is how I approach my work, which is extreme intensity and aggressiveness, and then the zen craftsmanship, being present.

**中文翻译:**
我不怎么看电视，但我看两类东西。一类是极具侵略性的体育运动，比如迈克尔·乔丹的纪录片《最后一舞》，还有关于阿姆斯特朗那种极具对抗性的纪录片，我也爱看 UFC。我喜欢那种极端的侵略性和强度。另一类是攀岩纪录片。(01:05:34): 比如 Alex Honnold 或 Jimmy Chin 的作品，这和竞技体育完全相反。它是禅意的、专注当下、慢而稳的匠心。这也是我对待工作的方式：极高的强度和进取心，辅以禅宗般的匠心和专注。

---

### (01:05:57) Lenny Rachitsky

**English:**
I love how this explains why people love working with you and why you're good at this, is like this competitiveness and also just the super nerdiness to get really knowledgeable about how this stuff works. (01:06:09): And then I didn't think about the zen element of it, just lik staying calm throughout it all.

**中文翻译:**
我喜欢这个解释，这说明了为什么人们喜欢和你合作，以及为什么你擅长此道：那种竞争心，加上对事物运作原理钻研到底的极客精神。(01:06:09): 我之前没考虑到“禅”的元素，也就是在整个过程中保持冷静。

---

### (01:06:13) Ethan Smith

**English:**
Flow, flow state.

**中文翻译:**
心流，一种心流状态。

---

### (01:06:15) Lenny Rachitsky

**English:**
Flow, what a funny microcosm of why you're so good at this.

**中文翻译:**
心流，这真是你为何如此优秀的一个有趣缩影。

---

### (01:06:19) Ethan Smith

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### (01:06:19) Lenny Rachitsky

**English:**
Okay, I'm going to keep going. Do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
好，继续。你最近有没有发现什么特别喜欢的爱用物？

---

### (01:06:24) Ethan Smith

**English:**
This camera and this microphone. So I got a Sony mirrorless SLR, I forget which one. But, sorry, getting a mirrorless SLR with a wide-angle lens really transforms your video calls. And then I have this Shure microphone and I think it's like $180. (01:06:46): This dramatically improves the quality of my video call. And I like to design things and you can design your video calls and you can make them amazing. You can have flowers in the background, over here, some sunflowers.

**中文翻译:**
我的相机和麦克风。我买了一个索尼微单，忘了具体型号了。但是，配上广角镜头的微单真的能彻底改变你的视频通话质量。还有这个舒尔（Shure）麦克风，大概 180 美元。(01:06:46): 这极大地提升了通话质量。我喜欢设计东西，你可以设计你的视频通话背景，让它看起来很棒。比如在背景里放点花，我这儿有些向日葵。

---

### (01:07:00) Lenny Rachitsky

**English:**
Beautiful.

**中文翻译:**
很漂亮。

---

### (01:07:00) Ethan Smith

**English:**
So my favorite products are my SLR camera that I use for video calls and my microphone.

**中文翻译:**
所以我最喜欢的单品就是我用来视频通话的微单相机和麦克风。

---

### (01:07:07) Lenny Rachitsky

**English:**
Your background is quite exquisite and I didn't mention that, but it looks beautiful. Okay, two more questions. (01:07:13): Do you have a life motto that you find really useful in work or in life?

**中文翻译:**
你的背景确实很精致，我刚才没提，但真的很美。好，最后两个问题。(01:07:13): 你有没有什么在工作或生活中觉得非常有用的座右铭？

---

### (01:07:19) Ethan Smith

**English:**
There's the Outliers book about 10,000 hours. And the themes there are you don't have to be the smartest, you have to be sufficiently smart, number one. Number two is focused practice, so it's not just trying hard, it's doing it in an intentional, focused way. And the third thing is lots of practice, so no one can master anything because they're a genius. (01:07:44): They master it because they spent a significant amount of time practicing and they practice in an intentional way. And so my motto is essentially a combination of those things, which is that I'm not going to necessarily win because my brain is the largest brain or that I tried the hardest. (01:08:00): It's because I'm going to be the most intentional about my practice, and I'm going to be as intense as I possibly can be about that practice.

**中文翻译:**
《异类》（Outliers）那本书里提到过“一万小时定律”。核心观点是：第一，你不需要是最聪明的，只要足够聪明就行；第二，刻意练习，不只是努力，而是有意识、专注地练习；第三，大量的练习。没人能仅靠天才就精通某事。(01:07:44): 他们精通是因为花了大量时间进行刻意练习。所以我的座右铭是这些点的结合：我不一定是因为脑子最灵光或最努力而获胜，(01:08:00): 而是因为我在练习时最有目的性，并且在练习过程中保持最高的强度。

---

### (01:08:08) Lenny Rachitsky

**English:**
Okay, final question. I'm curious if there's just like an SEO or even an AEO win, you're just most proud of? (01:08:15): That you always think about, "Wow, I can't believe I pulled that off. I can't believe the impact we had there"?

**中文翻译:**
好，最后一个问题。有没有哪个 SEO 甚至 AEO 的案例是你最引以为豪的？(01:08:15): 让你每每想到都会觉得：“哇，真不敢相信我做到了，不敢相信我们产生了那么大的影响”？

---

### (01:08:19) Ethan Smith

**English:**
I always liked the example of butter lettuce with MasterClass. Because MasterClass, when I was first working with them, they did not have nearly as much authority as Allrecipes and Martha Stewart. And I actually didn't know if I should take the project because I thought it might be too hard. (01:08:37): But I did the project and it was hard, but we were able to rank really competitively and way better than I expected. And I think it's probably because of all these specific, little execution details. But butter lettuce was my favorite one, and I like butter lettuce, so I can search for butter lettuce and I can get a recipe on MasterClass.

**中文翻译:**
我一直很喜欢 MasterClass 的“奶油生菜（butter lettuce）”案例。因为我刚开始和 MasterClass 合作时，他们的权重远不如 Allrecipes 或 Martha Stewart。我当时甚至犹豫要不要接这个项目，因为觉得太难了。(01:08:37): 但我接了，虽然过程艰辛，但我们最终获得了极具竞争力的排名，效果远超预期。我觉得这归功于所有那些具体的执行细节。奶油生菜是我最喜欢的案例，我也爱吃奶油生菜，现在搜这个词，你能看到 MasterClass 的食谱。

---

### (01:08:55) Lenny Rachitsky

**English:**
That's amazing. I don't know if butter lettuce has been mentioned on this podcast before. Ethan, this was incredible. This was everything I was hoping it'd be. (01:09:03): I feel like we've just leveled up everyone's knowledge on what the hell is happening with SEO and AEO? Forget about GEO. (01:09:09): Two final questions, where can folks find you if they want to potentially work with you guys? And how can listeners be useful to you?

**中文翻译:**
太棒了。我不确定这个播客以前有没有提过奶油生菜。Ethan，这集太精彩了，完全达到了我的预期。(01:09:03): 我觉得我们帮大家理清了 SEO 和 AEO 到底发生了什么。至于 GEO，先别管它了。(01:09:09): 最后两个问题：如果有人想和你们合作，去哪找你？以及，听众能为你做点什么？

---

### (01:09:15) Ethan Smith

**English:**
So where you can find me, number one, is on LinkedIn. I spend lots of time on LinkedIn and I publish original, so we do original research. We have a whole research team hypothesizing and evaluating those hypotheses. So we publish, all the studies that I mentioned, we publish on our site and I publish them on LinkedIn. (01:09:33): So follow me on LinkedIn, add me on LinkedIn, send me a message. LinkedIn, number one, and then number two is we have a blog which we call The 5%. So /5%, which stands for 5% of work, 5% of landing pages drive almost all the impact, so that's the theme. This is only useful stuff. So our blog at 5%, you could subscribe to our email and to our studies. And then how can people be useful to me? (01:09:58): So I spent time thinking about this and there's two ways people can help me. The first way is that there's not that much research around what works in AEO, and I would love to know what people are testing and what the results are and what works. So people doing studies and publishing that are sending it to me, I would love as much analysis and research as possible, number one. (01:10:20): Then the second one is to help me on LinkedIn by commenting on my posts and on my comments. So you posted most recently the Brian Balfour episode, for which I wrote a long, thoughtful comment, and then I got about 25 likes and then I got responses to that. And so I've been commenting on other people's LinkedIn posts and I've been writing these long LinkedIn posts. (01:10:43): And when people comment, it boosts the engagement within LinkedIn and then I get mass distribution. So the more people and thoughtful comments, so not this is great, but a long, thoughtful comment that stimulates conversation. So if people comment on my posts, then I'm just going to blow up on LinkedIn and I might be as big as you someday.

**中文翻译:**
找我的话，第一是 LinkedIn。我花很多时间在 LinkedIn 上发布原创研究。我们有专门的研究团队进行假设和验证。我提到的所有研究都会发在官网和 LinkedIn 上。(01:09:33): 所以在 LinkedIn 上关注我、加我好友或发私信。第二是我们的博客，叫“The 5%”。网址后缀是 /5%，寓意是 5% 的工作或落地页驱动了几乎所有的影响。那里只发干货。你可以订阅邮件。至于大家能帮我什么：(01:09:58): 我想了两点。第一，目前关于 AEO 有效性的研究还很少，我很想知道大家都在测试什么，结果如何。如果你做了研究并发布，请发给我，我渴望看到更多的分析。 (01:10:20): 第二，在 LinkedIn 上帮我评论。比如你最近发了 Brian Balfour 那集，我写了一条很长、很深刻的评论，得到了 25 个赞和很多回复。我一直在给别人留言，也写长篇贴文。(01:10:43): 当人们评论时，会增加 LinkedIn 的互动权重，从而获得大规模分发。所以，请留下有见地的评论，不只是说“太棒了”，而是能引发讨论的长评论。如果大家都去评论，我就能在 LinkedIn 上火起来，说不定哪天能像你一样出名。

---

### (01:11:01) Lenny Rachitsky

**English:**
I love how tactical his ask is. It's something Bryan Johnson I noticed is really good at on Twitter, the longevity guy. (01:11:08): He just replies to tweets in a really funny way and feels like that's a big growth channel for him. So I love that you have this in common with Bryan Johnson.

**中文翻译:**
我喜欢他这么具体的请求。我注意到那个搞长寿研究的 Bryan Johnson 在 Twitter 上也很擅长这招。(01:11:08): 他总是以有趣的方式回复推文，这成了他的一个重要增长渠道。很高兴看到你和 Bryan Johnson 有这个共同点。

---

### (01:11:16) Ethan Smith

**English:**
Yes.

**中文翻译:**
是的。

---

### (01:11:17) Lenny Rachitsky

**English:**
Also, just to point people to your domain, graphite.io, is that the right domain?

**中文翻译:**
顺便告诉大家你的网站：graphite.io，对吗？

---

### (01:11:21) Ethan Smith

**English:**
Yep.

**中文翻译:**
没错。

---

### (01:11:21) Lenny Rachitsky

**English:**
Amazing. Ethan, thank you so much for sharing so much with us and for being here.

**中文翻译:**
太棒了。Ethan，非常感谢你分享这么多，也感谢你的到来。

---

### (01:11:27) Ethan Smith

**English:**
Absolutely. It's good to be here.

**中文翻译:**
不客气，很高兴能来。

---

### (01:11:29) Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. (01:11:38): Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。感谢收听。如果你觉得内容有价值，请在 Apple Podcasts、Spotify 或你喜欢的应用中订阅。 (01:11:38): 另外，请考虑给我们评分或留言，这能帮更多听众发现我们。你可以在 lennyspodcast.com 找到往期节目或了解更多。下期见。