# Evan LaPointe - 双语对照

# Lenny's Podcast: Evan LaPointe - Understanding the Brain to Work Better
# 莱尼播客：Evan LaPointe —— 深度解析大脑，助力高效协作

---

### [00:00:00] Evan LaPointe

**English:**
The brain is like a college campus that has different departments in it. Most people rely on their history department way too much. If you instead send things to the more experimental, open-minded science department, the more creative art department, you get dramatically better answers.

**中文翻译:**
大脑就像一个拥有不同系别的大学校园。大多数人过度依赖他们的“历史系”。如果你转而将问题交给更具实验精神、更开放的“科学系”，或者更具创造力的“艺术系”，你得到的答案会好得多。

---

### [00:00:16] Evan LaPointe

**English:**
It's almost like you're playing Elden Ring or some video game. The starting point is to choose your character. Hey, I'm the devil's advocate approach, or I'm the break it and see if it still stands after I hit it really hard with a sledgehammer kind of guy, your personality kind of has a natural fit.

**中文翻译:**
这有点像在玩《艾尔登法环》或其他电子游戏。起点是选择你的角色。比如，“我是那种喜欢唱反调（Devil's advocate）的人”，或者“我是那种喜欢用大锤猛击，看看东西碎了之后还能不能立得住的人”。你的性格通常会有一种天然的契合点。

---

### [00:00:33] Evan LaPointe

**English:**
It's critical to ask what kind of experience am I? Not how good am I at my job, how much do I know, how critical am I to this process, but am I a miserable experience? If the answer is yes, don't worry too much about the other pieces yet. You got to fix that first.

**中文翻译:**
至关重要的一点是问问自己：“我带给别人的是什么样的体验？”不是问“我的工作做得多好”、“我知道多少”或者“我在这个流程中有多重要”，而是问“我是否让别人感到痛苦？”如果答案是肯定的，那么先别担心其他事情，你得先解决这个问题。

---

### [00:00:58] Lenny Rachitsky

**English:**
Today, my guest is Evan LaPointe. Evan is the founder of CORE Sciences, which teaches companies and individuals how our brains actually work, and through that lens, how to more effectively work with other people on teams, how to build better products, how to grow your business, and how to make smarter and faster decisions. [...] This conversation is a beautiful mix of science, theory, and also, a ton of very actionable and concrete things you can do to be more effective in your work.

**中文翻译:**
今天的嘉宾是 Evan LaPointe。Evan 是 CORE Sciences 的创始人，该公司致力于教导企业和个人大脑运作的真实机制，并以此视角出发，探讨如何更有效地进行团队协作、打造更优质的产品、推动业务增长，以及如何做出更明智、更快速的决策。[...] 这场对话完美融合了科学、理论，以及大量非常具有操作性的具体建议，能帮助你在工作中变得更高效。

---

### [00:02:53] Evan LaPointe

**English:**
The brain is like a big galaxy. [...] It's our job to translate the complexity of the brain into really simple, straightforward systems that you can remember. The three or four main systems to stack on top of each other like layers, start with the fact that the brain has systems. I think of it like the brain is like a college campus that has different departments in it, and your brain has a science department responsible for open-minded experimentation. It has an art department in it responsible for creative boundless thinking. It has a history department designed for looking stuff up that you already know.

**中文翻译:**
大脑就像一个巨大的星系。[...] 我们的工作就是将大脑的复杂性转化为简单、直观且易于记忆的系统。我们可以像堆叠图层一样，将三到四个主要系统叠在一起。首先要认识到大脑是有系统的。我把它比作一个大学校园，里面有不同的系别：你的大脑里有一个“科学系”，负责开放式的实验；有一个“艺术系”，负责创造性的发散思维；还有一个“历史系”，专门负责查找你已经知道的信息。

---

### [00:04:10] Evan LaPointe

**English:**
Where we're stuck largely is most people rely on their history department way too much. That's because the brain is actually built to conserve energy, and that's the lowest energy form of generating an answer to a question that the brain can pull off. If you instead send things to the more experimental, open-minded science department, the more creative art department, the humanities department of your compassion, et cetera, you get totally different answers.

**中文翻译:**
我们之所以陷入困境，很大程度上是因为大多数人过度依赖“历史系”。这是因为大脑的天性是节省能量，而从记忆中提取答案是大脑能实现的能耗最低的方式。如果你转而将问题交给更具实验精神、更开放的“科学系”，或者更具创造力的“艺术系”，甚至是代表同理心的“人文系”，你得到的答案将截然不同。

---

### [00:07:25] Evan LaPointe

**English:**
The simplest way to keep track of the systems is there's three really big ones: your safety system, your reward system, and your purpose system. [...] The safety system is pretty obvious to most people. When we're scared, afraid, uncertain, we have doubt, we're resentful, angry, apathetic, etc. This system of our brain is trying to restore our standing in the universe, like I need to get out of this stress, out of this danger. [...] If you're in a meeting and you're exposed to a statement that makes you feel unsafe, your objective now actually isn't to contribute to the meeting productively anymore. Your brain's objective is to get back to safety.

**中文翻译:**
追踪这些系统最简单的方法是关注三个核心系统：安全系统（Safety）、奖励系统（Reward）和目标/意义系统（Purpose）。[...] 安全系统对大多数人来说很直观。当我们感到恐惧、害怕、不确定、怀疑、愤恨、愤怒或冷漠时，大脑的这个系统就会试图恢复我们在环境中的地位，比如“我需要摆脱这种压力或危险”。[...] 如果你在开会时听到某句话让你感到不安（不安全），你现在的目标其实已经不再是为会议做出建设性贡献了，你大脑的目标是重新回到安全状态。

---

### [00:12:02] Evan LaPointe

**English:**
Maybe one of the worst pieces of propaganda that people walk around with in their minds is the phrase "we're more similar than we are different." [...] We should probably be building the muscle that we have the capacity to get along with people that are extremely different than we are. [...] We often use the metaphor of culinary school—that we're more culinary school for human performance instead of cooking class. [...] One of the things that's really important for a chef is to actually understand what are my preferences? What do I like to eat? Because if I don't know what I like, then I assume everybody else likes what I like.

**中文翻译:**
人们脑子里根深蒂固的最糟糕的误导（Propaganda）之一，可能就是“我们的相似之处多于不同之处”这句话。[...] 我们其实应该锻炼一种能力，即与那些和我们截然不同的人和谐相处。[...] 我们经常用“烹饪学校”来打比方——我们更像是提升人类表现的烹饪学校，而不是简单的烹饪课。[...] 对于一名厨师来说，真正重要的一点是了解：“我的偏好是什么？我喜欢吃什么？”因为如果我不了解自己的喜好，我就会假设其他所有人都喜欢我喜欢的东西。

---

### [00:17:28] Evan LaPointe

**English:**
The business world isn't just hand-to-hand combat between a bunch of individuals on the blank matrix loading screen. You're actually in a habitat as a company and your team is like a habitat. I think of companies and teams, almost like little terrariums that we're inside of, and is this terrarium set up with sand and a heat lamp and we're a bunch of frogs, like we're going to turn into frog bacon, simply because we're in this habitat?

**中文翻译:**
商业世界不仅仅是一群人在空白矩阵加载页面上的肉搏战。作为一家公司，你实际上处在一个“栖息地”中，你的团队也是一个栖息地。我把公司和团队看作是我们身处其中的“微型生态缸（Terrariums）”。如果这个生态缸里只有沙子和加热灯，而我们是一群青蛙，那我们岂不是要变成“培根青蛙”了？仅仅是因为我们处在这样的栖息地里。

---

### [00:19:17] Evan LaPointe

**English:**
There's a great quote, I think Dan Pink has summarized the problem better than anybody when he said, "There's a mismatch between what science knows and what business does." In that gap, it says, "Well, what is it that business is doing that science knows better?" You can almost look at this as an equation of: Science Knows - What Your Business Does = Dysfunction.

**中文翻译:**
有一句名言，我认为 Dan Pink 比任何人都总结得好，他说：“科学所知与商业所为之间存在脱节。”在这个差距中，我们要问：“商业中正在做的哪些事，其实科学已经有了更好的方案？”你几乎可以把它看作一个等式：科学所知 - 商业所为 = 功能紊乱（Dysfunction）。

---

### [00:21:14] Evan LaPointe

**English:**
Imagination is a hypothesis generation engine. [...] When we talk about imagination's purpose, if you have a great imagination, you always have a lot of choices in life. [...] It's not just the ability to generate choices and hypotheses, but it's also the ability to load them into your Oculus headset and walk around a world in which that choice already has been executed. That's akin to vision in a sense—do you have a really good ability to load that one branch of this imaginative tree into a simulation and then explore what the world looks like with this in place?

**中文翻译:**
想象力是一个“假设生成引擎”。[...] 当我们谈论想象力的目的时，如果你拥有丰富的想象力，你在生活中总会有很多选择。[...] 这不仅是生成选择和假设的能力，更是将其加载到你的“VR头显”中，并在一个该选择已经实现的世界里行走观察的能力。从某种意义上说，这类似于“愿景（Vision）”——你是否有能力将想象之树的一个分支加载到模拟器中，然后探索如果这一切成真，世界会是什么样子？