# Failure - 双语对照

This is the complete bilingual transcript for Lenny's Podcast compilation episode on "Failure."

---

### [00:00:02] Lenny

**English:**
Today we've got another very special compilation episode. Something I've been pulling on more and more with the podcast and the newsletter, in case you've noticed, is failure. Normally I spend a lot of time researching how the best companies and the best product leaders operate, but you can learn a lot and often a lot more from failure. And so what we've done with this episode is we've looked at all of the past episodes we've done and pulled out all the most interesting and insightful stories of failure and turned it into this very focused episode on failure. I hope that you find this useful and interesting. Let us know what you think in the comments on YouTube or on lennysnewsletter.com, or just let me know on Twitter. If you like this, we'll keep doing this. If not, we'll, probably not. Either way, I hope you enjoy. Before we dive in, here is a short word from our wonderful sponsors.

**中文翻译:**
今天我们准备了另一集非常特别的合集。如果你有留意的话，我在播客和时事通讯中越来越多地探讨一个主题，那就是“失败”。通常我会花很多时间研究最优秀的公司和最优秀的产品领导者是如何运作的，但你可以从失败中学到很多东西，而且往往比从成功中学到的更多。因此，在这一集中，我们回顾了过去所有的节目，挖掘出了最有趣、最有见地的失败故事，并将它们汇编成这个专注于失败的专题。我希望你们觉得这很有用且有趣。请在 YouTube 评论区、lennysnewsletter.com 或 Twitter 上告诉我们你的想法。如果你喜欢这种形式，我们会继续做下去；如果不喜欢，我们可能就不做了。无论如何，希望你喜欢。在开始之前，先听听我们优秀的赞助商的简短介绍。

---

### [00:00:52] Lenny

**English:**
Let me tell you about a product called Sendbird. The all-in-one communications API platform designed for both web and mobile apps. In a world saturated with multi-channel communication, product teams are discovering the effectiveness of in-app communication with Sendbird, businesses can elevate their in-app experience with decluttered and branded communication featuring AI-powered chatbots, one-way messages, chat, video calls and livestream capabilities, all tailored for commerce, marketing and top-tier support. Forward-thinking companies such as Hinge, Patreon, Yahoo, Accolade, and more use Sendbird to build in-app communication experiences that drive engagement, conversion, and retention. In-app communication has the highest conversion, highest engagement, and highest satisfaction of any communication channel. And when it comes to investing in this channel, trust Sendbird to take your in-app communication experience to the next level. Start today with Sendbird's free plan and as a listener of Lenny's Podcast, you'll get an additional two months of unlimited usage and access to all premium features, including creating your very own generative AI chatbot. Visit sendbird.com/Lenny to begin your free journey. That's sendbird.com/Lenny.

**中文翻译:**
让我向你介绍一款名为 Sendbird 的产品。这是一个专为 Web 和移动应用设计的一站式通信 API 平台。在多渠道沟通泛滥的世界里，产品团队正发现应用内沟通的有效性。通过 Sendbird，企业可以提升应用内体验，提供整洁且具有品牌特色的沟通方式，功能包括 AI 驱动的聊天机器人、单向消息、聊天、视频通话和直播功能，全部为商业、营销和顶级支持量身定制。Hinge、Patreon、Yahoo、Accolade 等具有前瞻性的公司都在使用 Sendbird 构建应用内沟通体验，以推动参与度、转化率和留存率。在所有沟通渠道中，应用内沟通的转化率、参与度和满意度都是最高的。当你考虑投资这个渠道时，请相信 Sendbird 能将你的应用内沟通体验提升到新高度。今天就开始使用 Sendbird 的免费计划吧，作为 Lenny's Podcast 的听众，你将额外获得两个月的无限使用权，并可以使用所有高级功能，包括创建你自己的生成式 AI 聊天机器人。访问 sendbird.com/Lenny 开始你的免费之旅。

---

### [00:02:08] Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next-generation, A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams. Companies like Twitch, Miro, ClickUp and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and for understanding the performance of new features. And Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does. When I was at Airbnb, one of the things that I loved most was our experimentation platform where I could set up experiments, easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more with advanced statistical methods that can help you shave weeks off experiment time, an accessible UI for diving deeper into performance, and out-of-the-box reporting that helps you avoid annoying prolonged analytic cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the A/B testing flywheel. Eppo powers experimentation across every use case, including product, growth, machine learning, monetization, and email marketing. Check out Eppo at geteppo.com/lenny and 10 X your experiment velocity. That's geteppo.com/lenny.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依靠 Eppo 来驱动他们的实验。实验对于推动增长和了解新功能的表现越来越重要。Eppo 能够帮助你提高实验速度，同时解锁其他商业工具无法提供的严谨深度分析。当我在 Airbnb 时，我最喜欢的事情之一就是我们的实验平台，在那里我可以独立设置实验、轻松排除故障并分析表现。Eppo 不仅能做到这些，还拥有先进的统计方法，可以帮你缩短数周的实验时间，拥有易用的 UI 进行深度性能分析，以及开箱即用的报告，帮你避免烦人的漫长分析周期。Eppo 还让你能轻松与团队分享实验见解，为 A/B 测试飞轮激发新灵感。Eppo 支持各种场景的实验，包括产品、增长、机器学习、变现和邮件营销。访问 geteppo.com/lenny 查看 Eppo，让你的实验速度提升 10 倍。

---

### [00:03:26] Lenny

**English:**
All right. First up, we've got Katie Dill, who is head of design at Stripe and former head of design at Airbnb and Lyft sharing this amazing story of how the entire design team at Airbnb basically rebelled against her soon after she joined and what she learned from that experience.

**中文翻译:**
好的。首先，我们请到了 Katie Dill，她是 Stripe 的设计负责人，曾任 Airbnb 和 Lyft 的设计负责人。她将分享一个惊人的故事：在她加入 Airbnb 后不久，整个设计团队基本上都对她发起了“反抗”，以及她从那次经历中学到了什么。

---

### [00:03:42] Katie Dill

**English:**
I'm happy to talk about it because frankly, it was the biggest learning experience of my leadership career, or at least that happened in one moment, and it happened in my early days at Airbnb. So I was hired to take on the experience design organization, that's basically the product design team, which was 10 people at the time. And so they had been reporting directly to one of the founders and they were going to start reporting to me. And during my interview process, I learned a lot about what was working and what wasn't working and some of the trials and tribulations with the design organization and its collaboration with others. So it seemed like there was room for improvement in how engineering and product management and design all work together. And there was also really low engagement scores in the design team. And so I came in ready to go and excited to try to help make some change based on all the things that I had learned from various leaders and people across the company. And I came in swinging ready to go, and then about a month into my time there, I got a meeting on my calendar. Thursday 8:30 AM, was an hour and a half with half of the design team, so that was five people, and our HR partner.

**中文翻译:**
我很乐意谈谈这件事，因为坦白说，这是我领导生涯中最大的学习经历，或者说至少是瞬间爆发的学习经历，它发生在我加入 Airbnb 的早期。当时我被聘请去负责体验设计部门，基本上就是产品设计团队，当时只有 10 个人。他们之前是直接向其中一位创始人汇报的，现在开始向我汇报。在面试过程中，我了解了很多关于哪些行得通、哪些行不通的情况，以及设计部门在与其他部门协作中的一些磨难。所以，工程、产品管理和设计如何协同工作似乎还有改进空间。而且当时设计团队的敬业度评分（engagement scores）也非常低。于是我带着满腔热情加入，兴奋地想根据我从公司各级领导和员工那里学到的东西来推动一些变革。我一进来就大刀阔斧地准备干一场，结果在我入职大约一个月后，我的日程表上出现了一个会议。周四早上 8:30，一个半小时，参会人员是设计团队的一半成员（也就是 5 个人）以及我们的 HR 合作伙伴。

---

### [00:05:00] Lenny

**English:**
Oh, no. That's never a good sign.

**中文翻译:**
噢，不。这通常不是什么好兆头。

---

### [00:05:01] Katie Dill

**English:**
Usually it's [inaudible 00:05:01]. Yeah. And I remember this so vividly. I remember walking into the office and all the rooms in Airbnb's office are very unique spaces that look like Airbnbs, but of course this was the one room with all white walls and just a gray flat rectangle table. And I walked into the room and there were five of them seated around the table and they had a pack of papers in front of them, and they went on taking turns quietly reading from the papers all the things that they saw that I was doing wrong and all the things that they didn't like about me. And it was a really hard moment there. I went through all the usual stages of grief when one hears feedback, which is just immediate want to respond to be like, "Oh, well there was a good reason for that." And, "That's not how it actually was," and, "This is why I did that." But luckily I had, thank goodness, I had the sense to just listen and not respond in that way. Clearly, what they were telling me is that that was one of the things that was missing. And so I heard them out and took it all in. And regardless of each individual thing, what was very clear was that the missing piece, the theme that was across all of that is that I hadn't earned their trust. So whether how right or how wrong what I was doing was is the key piece is that I wasn't bringing the team along with me. They had no idea that they could trust in what I was trying to build and what I was trying to shape and that I cared about them and that I had their best interest and shared goals at heart. And that was absolutely my fault.

**中文翻译:**
通常确实不是。是的，我记得非常清楚。我记得走进办公室，Airbnb 办公室的所有房间都是非常独特的空间，看起来就像真实的 Airbnb 房源，但当然，那个房间偏偏是四壁全白，只有一张灰色长方形平桌。我走进房间，他们五个人围坐在桌子旁，面前放着一叠纸。他们轮流安静地读着纸上的内容，列举了所有他们认为我做错的事情，以及所有他们不喜欢我的地方。那真是一个非常艰难的时刻。我经历了听到反馈时通常会有的所有“悲伤阶段”，第一反应就是想反驳：“噢，那是有一个很好的理由的”，“事实并非如此”，“这就是我为什么要那样做”。但幸运的是，谢天谢地，我有理智让自己只是倾听，而不是那样回应。显然，他们告诉我的正是缺失的东西之一。所以我听完了他们的发言，全盘接受。抛开每一件具体的事情不谈，非常明确的一点是，缺失的部分、贯穿始终的主题是我还没有赢得他们的信任。所以，无论我做的事情是对是错，关键在于我没有带着团队一起前进。他们不知道是否可以信任我试图建立和塑造的东西，不知道我是否关心他们，也不知道我是否把他们的最佳利益和共同目标放在心上。这绝对是我的错。

---

### [00:06:45] Katie Dill

**English:**
And in retrospect, as hard as that was, I'm very grateful and very amazed that they could come together and share that with me. It can be hard to bring feedback forward like that. And so it was an extremely valuable learning experience and I took from that to then immediately shift how I was operating. And really a key part in building trust was to listen, to hear out what the individuals on the team were setting out to do, what they cared about, what motivated them. And so I started to make pretty fast change and still moving in the direction that was necessary for the org to make the really large impact in how we were operating, but bringing folks along with me. You can inflict change on people, but if you want to do it with them, really trust is the key element there. And then a couple of months later, we had the best engagement scores in the company. So it actually, it did objectively improve the situation and since then taken that on into next steps in other companies that I've joined and just think about instead of coming in swinging, come in listening, so that you can really set out to make change that actually has true positive impact on the folks around you and you bring along with you.

**中文翻译:**
回想起来，尽管当时很艰难，但我非常感激也很惊讶他们能团结起来向我分享这些。提出这样的反馈是很困难的。所以这是一次极其宝贵的学习经历，我从中吸取教训，立即转变了我的运作方式。建立信任的关键部分在于倾听，听取团队中每个人的目标、他们关心的事以及他们的动力。于是我开始做出相当快速的改变，虽然仍然朝着组织运作产生重大影响所需的必要方向前进，但我开始带着大家一起走。你可以强加变革给别人，但如果你想和他们一起完成变革，信任就是其中的关键要素。几个月后，我们的敬业度评分成了全公司最高的。所以这在客观上确实改善了局面。从那以后，我在加入其他公司时都会带着这个教训：不要一进来就大刀阔斧（swinging），要先倾听（listening），这样你才能真正发起对周围人产生积极影响的变革，并带着他们一起前进。

---

### [00:08:04] Lenny

**English:**
Next up, Paul Adams, chief product Officer at Intercom, sharing the nightmare experience of freezing on stage in front of thousands of people, having to walk off stage, and then people hearing him curse because the mic was still on, and then how he recovered. Plus a few stories of building some of Google's most infamous product failures.

**中文翻译:**
接下来是 Intercom 的首席产品官 Paul Adams。他将分享一次噩梦般的经历：在数千人面前在舞台上突然忘词（freezing），不得不走下台，结果因为麦克风没关，大家都听到了他在咒骂，以及他后来是如何恢复过来的。此外，他还会分享一些关于打造 Google 历史上最臭名昭著的失败产品的往事。

---

### [00:08:24] Paul Adams

**English:**
Some things have happened in work, are very memorable at the time and they don't really scar you. This goes in the book that have scarred for life. Yeah, let's go long story short, I was at Facebook just over a decade ago, loved it at the time. I think it was a great place to be at the time. And basically San Francisco, I did a lot of talks for Facebook internally and externally. Facebook had a keynote slot, always have a keynote slot at Cannes, the world's biggest advertising festival. And the year prior, Zuck had been interviewed. He was the speaker, he'd been interviewed, gotten a hard time on privacy. It didn't go well, as well as they'd hoped. So the next year they asked me to do it, maybe it was the Irish accent that made the offer come my way. And yeah, I got out into front the stage of the world's biggest advertising stage, and I'd say I was like three or four minutes into the talk, a talk I'd given, a very similar talk that I'd given lots of times. And I just froze. I couldn't remember what I was supposed to say. It was the first ever time in my life I'd rehearsed a talk word for word. Usually, I have talking points and I'd ad lib and things get mixed around and it's kind of informal. This was media trained, do not say the wrong thing kind of talk. And I just could not remember what to say. I had some version of a panic attack, walked off stage, I was still mic'd up, cursed. I was laughing. I was like, "Geez, are they laughing at me. Oh my God, this is..." But I can manage to turn it around, I walked back out, I'd kind of been disarmed internally in my head, and the rest of it went well. And I was famous that night out in Cannes afterwards on whatever the seafront, it's just like rosé everywhere. I was famous and infamous for my performance.

**中文翻译:**
工作中发生的一些事情在当时非常难忘，但并不会真的留下伤疤。而这件事属于“终身留下阴影”的那一类。长话短说，十多年前我在 Facebook 工作，当时我很喜欢那里，那是一个很棒的地方。在旧金山，我为 Facebook 做了很多对内和对外的演讲。Facebook 在戛纳（Cannes）——全球最大的广告节——一直有一个主题演讲席位。前一年，扎克伯格接受了采访，他是演讲嘉宾，但在隐私问题上遇到了麻烦，进展得不如预期顺利。所以第二年他们让我去，也许是因为我的爱尔兰口音让我得到了这个机会。于是，我走上了全球最大的广告舞台，演讲开始大约三四分钟后——这是一个我讲过很多次、非常类似的演讲——我突然卡壳了。我完全记不起该说什么。那是我人生中第一次逐字逐句地背诵演讲稿。通常我只有谈点，然后即兴发挥，内容会有些变动，比较非正式。但这次是经过媒体培训的、“绝对不能说错话”的那种演讲。我就是想不起来该说什么。我当时有点惊恐发作，走下了舞台，身上还挂着麦克风，我咒骂了一句。我当时在苦笑，心想：“天哪，他们在笑我吗？我的天，这……”但我设法扭转了局面，我重新走了出去，脑子里的武装已经卸下了，剩下的部分进行得很顺利。那天晚上我在戛纳出名了，在海滨大道上到处都是桃红葡萄酒，我因为那场表现而名声大噪，也臭名昭著。

---

### [00:10:13] Lenny

**English:**
I feel like you lived the worst nightmare that everybody has when they're thinking about giving a talk. And I think what's interesting is you survived, and I think that's a really interesting lesson is you could freeze in front of thousands of people, walk off stage, and then it works out okay.

**中文翻译:**
我觉得你经历了每个人在考虑做演讲时都会有的最可怕的噩梦。有趣的是你挺过来了，这是一个非常有意义的教训：你可能会在数千人面前卡壳，走下台，但最后结果还是可以接受的。

---

### [00:10:30] Paul Adams

**English:**
And it all happened organically, I guess, or very naturally. But yeah, ever since then, every time I walk out onto a conference talk stage, still today, I ask myself, I have this tiny doubt in the back of my head. It's never happened since. But yeah, I think you have to go with it with these things. When life kind of throws you these whatever curve balls you have got to kind of adapt, and it's not that big a deal. None of these things are that big a deal. At the end of the day you kind of move on, live and learn. Yeah, but I still hope it doesn't happen again.

**中文翻译:**
我想这一切都是自然而然发生的。但确实，从那以后，直到今天，每当我走上会议演讲台，我都会问自己，脑子里总有那么一点小小的疑虑。虽然之后再也没发生过。但我认为你必须接受这些事情。当生活向你投来这些“曲线球”时，你必须去适应，这没什么大不了的。这些事到头来都没什么大不了。最终你会继续前进，在生活中学习。是的，但我还是希望它不要再发生。

---

### [00:11:02] Lenny

**English:**
I also hate public speaking and I always fear this is exactly what's going to happen to me. And so I think this is nice to hear that even when the worst possible thing basically happens, things can survive.

**中文翻译:**
我也讨厌公开演讲，总担心这种事会发生在我身上。所以听到即使发生了最糟糕的情况，事情依然能有转机，这感觉很好。

---

### [00:11:13] Paul Adams

**English:**
You can turn it around. Yeah.

**中文翻译:**
你可以扭转局面的。是的。

---

### [00:11:15] Lenny

**English:**
A second area I wanted to hear from is your time at Google and there's a couple products you worked on at Google. Both of them were not what you'd call big successes, and then there's kind of a transition to Facebook, which was also kind messy. Can you just share a couple stories from that time?

**中文翻译:**
我想听的第二个领域是你在 Google 的时光。你在 Google 参与过几个产品，它们都算不上巨大的成功，然后你跳槽到了 Facebook，那个过程也挺混乱的。你能分享几个那个时期的故事吗？

---

### [00:11:31] Paul Adams

**English:**
Yeah. Similar to the walking off stage thing, you live and learn, and I was at Google for four years. I was at Facebook for two and a half years or so. At Google I worked on a lot of failed social projects like you mentioned, Google Buzz, Google, and later Google+. I think a lot of the motivation for those projects came from a place of fear. It didn't come from a place of let's make a great product for people,.let's really understand the things people struggle with when communicating with family and friends. That's really, really try and create something wonderful. It came from a place of fear. And so during those times I learned I think how not to lead in places. And by the way, I should say at the time in Google, there was other things happening that were amazing, like Google building Google Maps. Incredible product, one of my favorite products. I think one of the best products ever made. They were building Android. I was in the mobile team, in the mobile apps team at the time that Android came out. So incredibly good product. So I just happened to be in the social side, which wasn't as good.

**中文翻译:**
是的。就像走下舞台那件事一样，边做边学。我在 Google 待了四年，在 Facebook 待了大约两年半。在 Google，我参与了许多失败的社交项目，就像你提到的 Google Buzz，以及后来的 Google+。我认为这些项目的很多动力源于“恐惧”。它不是源于“让我们为人们做一个伟大的产品”、“让我们真正理解人们在与家人朋友沟通时的困扰”，不是真正尝试创造美好的东西。它源于恐惧。所以在那段时间里，我学到了在某些地方“不应该”如何领导。顺便说一下，我得说当时在 Google 还有其他很棒的事情在发生，比如 Google Maps。那是不可思议的产品，我最喜欢的产品之一，我认为是有史以来最好的产品之一。他们当时还在开发 Android。Android 发布时我在移动团队、移动应用团队。那是非常优秀的产品。我只是碰巧在社交部门，而那个部门没那么好。

---

### [00:12:37] Paul Adams

**English:**
And yeah, Google Buzz was kind of a privacy disaster, and Google+ similar. And so kind of halfway through I kind of published research about groups, and I've done a ton of research. An interesting kind of side note there is at the time I asked, I was working in the research, in the US team as a researcher, I was being asked to do a lot of tactical research, like usability study type stuff, like can people use these products? And I ended up doing a lot of formative research as well in the same session. So I'd kind of say to the team like, "Hey, I'll do the research, I'll answer your questions, but also I'm going to do this other thing, and I'm going to take 20 minutes doing that." And so what we used to do is, what I used to do with people was map out their social network, all the people in it, their family, their friends, how they communicate. We'd map on all the channels, we'd talk about what worked well, what didn't. And we did this with dozens and dozens of people over the course of maybe 18 months. And the same pattern emerged every single time, which was people need way better ways to communicate with small groups of family and friends. And I kind of look back now and go like WhatsApp, or it maybe iMessage if everyone's on Apple, but really obvious in hindsight, but at the time, not obvious. And so we kind of tried to build a product around that called Google+, but again, it was kind of came from the wrong place. And so halfway through the research that I've done, all this research had been made public through a conference talk and Zuck and Facebook noticed, got in touch, one thing led to another and I left and joined Facebook, which was an amazing thing for me, personally. Facebook was amazing, an amazing place at the time and exciting. And they were trying to do things for the other reasons, the kind of good reasons, like, "Hey, let's build an amazing product for people."

**中文翻译:**
是的，Google Buzz 简直是一场隐私灾难，Google+ 也差不多。在研究进行到一半时，我发表了关于“群组”的研究，我做了大量的研究。这里有一个有趣的插曲：当时我在美国团队担任研究员，被要求做很多战术性研究，比如可用性测试之类，看看人们是否会使用这些产品。结果我在同一个环节中也做了很多探索性研究（formative research）。我会对团队说：“嘿，我会做研究，回答你们的问题，但我还要做另一件事，我会花 20 分钟做那个。”我当时做的是帮人们梳理他们的社交网络：里面有哪些人、家人、朋友，他们如何沟通。我们会画出所有渠道，讨论哪些好用，哪些不好用。在 18 个月里，我们对几十个人做了这样的研究。每次都会出现同样的模式：人们需要更好的方式与家人和朋友的小群体进行沟通。现在回想起来，那就是 WhatsApp，或者如果大家都在用苹果，那就是 iMessage。事后看来显而易见，但当时并非如此。于是我们尝试围绕这一点构建一个名为 Google+ 的产品，但再次强调，它的出发点不对。在我研究进行到一半时，所有这些研究通过一次会议演讲公开了，扎克伯格和 Facebook 注意到了，联系了我，顺理成章地，我离开并加入了 Facebook。对我个人来说，那是一件很棒的事情。当时的 Facebook 非常棒，是一个令人兴奋的地方。他们做事的出发点是正确的，比如“嘿，让我们为人们打造一个惊人的产品”。

---

### [00:14:22] Lenny

**English:**
And this was during Google+ being built? You basically shifted.

**中文翻译:**
这是在 Google+ 还在开发期间吗？你基本上是中途跳槽了。

---

### [00:14:26] Paul Adams

**English:**
Yeah, midway, I'm stressed to even telling you about it. The project hadn't been launched. It was still under wraps. It was highly confidential. Google had done a lot of things at the time that were the first for them. I don't know if they've done them since, but things like everyone worked in Google+ was sent to a different building. That building had a different key card. If you didn't work on Google+, you could not get in. All sorts of counter-cultural things at the time. And as a result, there was a lot of antagonism internally for Google+. And so when I left in the middle of the project, leaving with all of the plans in my head to the enemy, some people saw me as a traitor, understandably. Other people thought I was enlightened. It depends on who you talked to, but it was the right thing for me to do. But at the time it was a hard thing to do.

**中文翻译:**
是的，中途。跟你说这些我都觉得有压力。当时项目还没发布，还在保密阶段，高度机密。Google 当时做了很多他们以前从未做过的事。我不知道他们后来还做没做过，比如所有参与 Google+ 的人都被派到了另一栋楼。那栋楼有不同的门禁卡，如果你不参与 Google+，你就进不去。当时有很多反企业文化的事情。结果，Google 内部对 Google+ 有很多抵触情绪。所以当我中途离开，带着脑子里所有的计划投奔“敌人”时，有些人把我当成叛徒，这可以理解。另一些人觉得我是觉醒了。这取决于你跟谁聊，但对我来说那是正确的事。只是在当时，那是一个艰难的决定。

---

### [00:15:17] Lenny

**English:**
I know there's also a lot of scrutiny in what you took with you and the process.

**中文翻译:**
我知道当时对于你带走了什么以及整个过程也有很多审查。

---

### [00:15:23] Paul Adams

**English:**
When I left, Google kind of assumed that I was one of the spies. I was quarantined when I told them I was leaving. They forensically analyzed my laptop, all sorts of stuff like that. So it was pretty intense. Looking back, I can understand why that happened, but the root cause for me is that the project has been run from a place of fear, competitive fear, which I don't think leads to good things.

**中文翻译:**
当我离开时，Google 基本上假设我是间谍。当我告诉他们我要走时，我被隔离了。他们对我的笔记本电脑进行了取证分析，诸如此类。所以当时气氛非常紧张。回想起来，我可以理解为什么会发生那种事，但对我来说，根本原因在于那个项目是基于恐惧——竞争性恐惧——运作的，我认为这不会带来好结果。

---

### [00:15:53] Lenny

**English:**
So one of the themes through the stories you just shared is, let's say failure is... I don't want to make it that harsh, but just things not working out. And I'm curious as a product leader, how important you think that is for people to go through if you think that's something that is almost a good thing. And I guess just is there anything there that you find helpful as a coach, as a mentor, as someone, to people that are trying to become basically you?

**中文翻译:**
你刚才分享的故事中有一个主题，就是失败……我不想说得那么严酷，但就是事情进展不顺利。我很好奇，作为一名产品领导者，你认为经历这些对人们来说有多重要？你是否认为这几乎是一件好事？作为一名教练或导师，对于那些想要成为像你这样的人，你有什么觉得有帮助的建议吗？

---

### [00:16:19] Paul Adams

**English:**
It very, very... It still is. It still is. I've personally failed so many times. There are two stories and the Google one is long deep tentacles. There are two stories. I've failed a ton of times like at Intercom. I remember when I was at Facebook, I was very happy and I knew I wanted to [inaudible 00:16:39] the co-founders of Intercom and they're trying to persuade me to join Intercom. It was like 10 person company at the time. But Owen said something to me at that time, which has stuck with me ever since. He said, "At Facebook you can design the product, but at Intercom you can design the company." And that was extremely appealing to me, a great pitch. He's like, "Just design the company with us that you want to work in." And so part of that was a company that embraces failure that says it's okay to try things. I'm a big believer in big bets, higher risk, higher reward. I don't get as excited about incremental things. Now I haven't said that, there's of course a place for that too, especially as companies get bigger. But I get excited about big bets and if you make big bets, you're going to get a lot of it wrong. So a lot of the principles that we built here at Intercom, on building software, we have a principle called ship to learn, and we've actually changed it since, still on the wall here. Ship fast, ship early, ship often is what it says now. Used to say ship to learn. Ship fast, ship early, ship often. It's like in that idea is the idea of failure. It's not going to go right, and it's going to go wrong more often than not. But if you ship early and fast and learn fast, you can change fast, and you can improve fast. And that's the kind of culture that we as much as possible try to embrace and teach people. But it's much easier said than done.

**中文翻译:**
非常重要，现在依然如此。我个人失败过很多次。刚才那两个故事，Google 的那个影响深远。我在 Intercom 也失败过无数次。我记得在 Facebook 时我很开心，当时 Intercom 的联合创始人试图说服我加入，那时公司只有 10 个人。Owen 当时对我说了一句话，一直印在我的脑海里。他说：“在 Facebook，你可以设计产品；但在 Intercom，你可以设计公司。”这对我极具吸引力，是一个很棒的推销。他说：“和我们一起设计一家你想在其中工作的公司吧。”所以，其中的一部分就是建立一个拥抱失败、允许尝试的公司。我非常相信“大赌注”（big bets），高风险高回报。我对渐进式的改进没那么兴奋。当然，渐进式改进也有其地位，尤其是当公司变大时。但我对大赌注感到兴奋，而如果你下大赌注，你就会犯很多错误。所以我们在 Intercom 建立了很多关于软件开发的原则，我们有一个原则叫“以发布促学习”（ship to learn），后来我们改了，现在墙上写的是：“快速发布、尽早发布、频繁发布”。以前叫“以发布促学习”。这种理念的核心就是接受失败。事情不会总是一帆风顺，而且往往会出错。但如果你发布得早、发布得快、学习得快，你就能改变得快，进步得快。这就是我们尽可能去拥抱并教给别人的文化。但知易行难。

---

### [00:18:05] Lenny

**English:**
Especially when you're in the moment. Like Go damn, it, everything's going to fall apart. I really messed this one up.

**中文翻译:**
尤其是当你身处其中的时候。你会想：“该死，一切都要崩盘了，我真的搞砸了。”

---

### [00:18:09] Paul Adams

**English:**
Yeah. And there's a trade-off with quality that people really struggle with. We've high standards of ourselves. A lot of Intercom comes from a design founder background. We value the craft a lot. We never want to be embarrassed by what we ship. So there's a real tension there, a real trade-off where people have these high standards, which we encourage and we encourage them to ship fast and learn and make mistakes. It's a constant kind of tension that we're navigating.

**中文翻译:**
是的。而且这里还有一个人们非常纠结的关于质量的权衡。我们对自己有很高的标准。Intercom 的很多基因源于设计师出身的创始人。我们非常看重手艺（craft）。我们永远不想为自己发布的东西感到尴尬。所以这里存在一种真实的张力，一种权衡：人们有这些高标准（我们鼓励这一点），同时我们也鼓励他们快速发布、学习并犯错。这是我们一直在处理的一种持续的张力。

---

### [00:18:38] Lenny

**English:**
Next up, we have Tom Conrad, who is chief product officer at Quibi and engineering leader at Pets.com. Two of the most memorable failures in product history, sharing his lessons from those wild experiences. Tom is currently CEO of Zero Longevity Science, which is a killer business and an app in case you haven't come across it. I'd definitely check it out. Here's Tom. You brought up this phrase of notable disasters and I want to talk about that. You've worked at two of the most famous notable disasters of product companies, Pets.com and Quibi. I think it's really rare someone sees the inside of so much hype and then such a fall at a company. And so I just want to spend some time in these two areas, and maybe the way to set it up is just what's a lesson you took away from each of these two experiences that you've taken with you to future work, and maybe advice you share with people?

**中文翻译:**
接下来是 Tom Conrad，他是 Quibi 的首席产品官，也是 Pets.com 的工程负责人。这是产品历史上最令人难忘的两次失败。他将分享从这些疯狂经历中获得的教训。Tom 目前是 Zero Longevity Science 的 CEO，这是一家非常棒的公司，如果你还没见过他们的 App，一定要去看看。下面是 Tom 的分享。你提到了“著名的灾难”这个词，我想聊聊这个。你曾在两家最著名的失败产品公司工作过：Pets.com 和 Quibi。我觉得很少有人能亲历如此巨大的炒作，然后又目睹公司如此惨烈的垮台。所以我想花点时间聊聊这两个领域，也许可以这样开始：你从这两次经历中分别学到了什么可以带到未来工作中的教训？你会给别人什么建议？

---

### [00:19:30] Tom Conrad

**English:**
Probably the biggest lesson, it's not really about the specifics of the business. The biggest lesson really is these things make you better. In some instances, actually I think in both instances, they became kind of dominoes that opened doors for me in my own ambition and my own sort of professional life that maybe just wouldn't have opened at all if I hadn't gone to those companies and learned those things and had those experiences. And frankly, even in the case of Pets.com, like even the high profile nature of it, I could have worked at one of a thousand e-commerce websites in 1999. And when I went on to some subsequent job interview or something and talked about my experience, I had never heard of the thing that you worked on, but everybody certainly heard about Pets.com.

**中文翻译:**
可能最大的教训并不是关于业务细节。最大的教训其实是：这些经历会让你变得更好。在某些情况下，实际上我认为在这两个案例中，它们都成了多米诺骨牌，为我的抱负和职业生涯打开了大门。如果我没去那些公司、没学到那些东西、没经历过那些事，这些门可能根本不会打开。坦白说，即使是 Pets.com，尽管它名声狼藉，但在 1999 年，我本可以去一千家电子商务网站中的任何一家工作。但如果我去参加随后的工作面试，谈论我的经历，如果我是在那些无名公司工作，没人听说过；但每个人肯定都听说过 Pets.com。

---

### [00:20:17] Tom Conrad

**English:**
It's a pretty funny example too of how some struggles are timeless. That was 23, 24 years ago now. And while as a leadership team, we made, I'm sure, all kinds of mistakes. One of the things that happened was that there were three kind of over-funded pet e-commerce sites, and we all raised in excess of $50 million, which is a tremendous amount of money now. It was a tremendous amount of money then, and we all thought it was a zero-sum game and that we as one player started to spend on promotion or to spend irrationally on national broadcast television advertising. We all did, and it became this kind of unwinnable arms race. So there is, I think a fundamental lesson about having an excess of investment can be its own albatross or lead you to make decisions that maybe would be unwise.

**中文翻译:**
这也是一个很有趣的例子，说明有些挣扎是永恒的。那是 23、24 年前的事了。虽然作为领导团队，我确信我们犯了各种错误，但当时发生的一件事是：有三家融资过度的宠物电商网站，我们都筹集了超过 5000 万美元。这在现在是一笔巨款，在当时更是天文数字。我们都认为这是一场零和游戏，只要其中一家开始在促销上砸钱，或者在全国广播电视广告上进行非理性的投入，我们其他人也都会跟进。这变成了一场无法获胜的军备竞赛。所以，我认为一个根本的教训是：过度的投资可能会成为一种负担（albatross），或者导致你做出不明智的决定。

---

### [00:21:28] Tom Conrad

**English:**
And then of course, it's just like timing is really important. Chewy is a online pet store. It's worth $9 billion today. They were a private company and bought by PetSmart and then spun back out. But when they were bought by PetSmart, they were acquired for 3 billion, biggest e-commerce acquisition of all time. And while I think it's probably unfair to compare, Chewy who executed exceptionally well over a decade, grew their business brick by brick, and turned it into something really remarkable. To Pets.com, which was in a very, very different moment in time and tried to go to market in a really different way. The critique that is often leveled at Pets.com or at least at the time, was like, this is just a stupid business. They're shipping dog food around. You could never make that work, and that's just wrong. You absolutely can make it work. Probably can't make it work when 80% of the country on the internet is still on dial up. It's really, really early.

**中文翻译:**
当然，时机也非常重要。Chewy 是一家在线宠物商店，今天价值 90 亿美元。他们曾是一家私有公司，被 PetSmart 收购后又独立出来。当他们被 PetSmart 收购时，价格是 30 亿，是当时史上最大的电商收购案。虽然我认为将 Chewy 与 Pets.com 比较可能不公平——Chewy 在十年间执行得非常好，一砖一瓦地建立业务，并将其变成了非凡的事业。而 Pets.com 处于一个完全不同的时代背景，尝试以完全不同的方式进入市场。当时对 Pets.com 的批评通常是：“这业务太蠢了，他们在到处运送狗粮，这永远行不通。”这种说法是错误的。你绝对可以让它行得通。只是当全国 80% 的上网人口还在用拨号上网时，你可能无法让它行得通。那是真的太早了。

---

### [00:22:25] Lenny

**English:**
I saw a stat I think you shared somewhere that you took Pets.com from nothing, to a public company, to completely out of business in 19 months.

**中文翻译:**
我看到一个数据，好像是你分享过的：你带着 Pets.com 从零开始，到上市，再到彻底倒闭，一共只用了 19 个月。

---

### [00:22:33] Tom Conrad

**English:**
Yeah, yeah, I think that's about right. The other thing that's forgotten in the tale is that we actually didn't go bankrupt. We shut the company down and returned the remaining balance to the investors, which no public company had ever done before. And the leadership team just reached the conclusion that given the way market conditions had evolved, there was just no way we were going to be able to get more capital into the company. And it was a company that required additional investment to get to profitability. And so it was better to wind down early, take the money that we had in the bank and get it back to investors than to just spend every last penny on what was sort of a fruitless attempt to salvage it.

**中文翻译:**
是的，我想差不多是这样。这个故事中另一个被遗忘的细节是，我们实际上并没有破产。我们关闭了公司，并将剩余资金退还给了投资者，这在以前的上市公司中从未发生过。领导团队得出的结论是，鉴于市场环境的变化，我们根本无法再为公司筹集更多资金。而这是一家需要额外投资才能实现盈利的公司。因此，与其把最后一分钱都花在徒劳的挽救尝试上，不如尽早清算，把银行里的钱还给投资者。

---

### [00:23:22] Lenny

**English:**
Did not know that. Let's talk about Quibi. What went wrong there? Do you think there was a path to Quibi having worked out? Any big lessons that you took away from that experience that you bring with you?

**中文翻译:**
我还真不知道这一点。那我们聊聊 Quibi 吧。那里出了什么问题？你认为 Quibi 曾经有成功的可能吗？你从那次经历中带走了什么重要的教训？

---

### [00:23:33] Tom Conrad

**English:**
The kind of miraculous thing about Quibi for me was it relit my enthusiasm for the industry for doing this work. I had left in, I think it was December of 2018, and I thought that maybe I was just done making software. I had done it for a really long time, I had done it for twenty-five years or something. And I had changed a lot. The industry had changed a lot, and I thought maybe I just didn't have the same passion for it that I had a decade before. And it also seemed like maybe it'd be fun to have another chapter of my life that was just completely different. And I had a whole list of things that I thought I might want to do. They were really, they were kind of ridiculous. Maybe I want to be a pastry chef. Maybe I want to be a landscape photographer. Maybe I want to learn to make bad music to put up on SoundCloud or something. Really the only thing they had in common were they were all things that I knew nothing about. People would be like, "Oh, you think you might want to be a pastry chef? Do you like to bake?" And I'd be like, "No, I don't know anything about baking." "Oh, you might landscape photography. Do you take photos?" "No, I don't make photos."

**中文翻译:**
对我来说，Quibi 最神奇的地方在于它重新点燃了我对这个行业、对这份工作的热情。我在 2018 年 12 月离开了（Snapchat），当时我觉得自己可能已经做够软件了。我已经做了很长时间，大概 25 年。我变了很多，行业也变了很多，我觉得自己可能不再拥有十年前的那种激情了。而且我觉得开启一段完全不同的生活篇章可能会很有趣。我列了一长串我想做的事情，现在看来挺荒谬的。也许我想当个面点师，也许我想当个风景摄影师，也许我想学着做点烂音乐发到 SoundCloud 上。这些事情唯一的共同点就是我对此一窍不通。人们会问：“噢，你想当面点师？你喜欢烘焙吗？”我会说：“不，我对烘焙一无所知。”“噢，你想搞风景摄影？你拍照片吗？”“不，我不拍照片。”

---

### [00:24:41] Tom Conrad

**English:**
But I was kind of committed to the bit, actually to the point where when TechCrunch interviewed me about my departure from Snapchat, I was like, "I'm out. I'm going to do something else entirely." So that story is very much out there. But a few months after my last day at Snap, I got a call from Meg Whitman and Jeffrey Katzenberg who were starting up, it was called New TV at the time. And the pitch was, "We're going to try to take the best of mobile and Silicon Valley and Consumer Tech and sort of weld it to the best of Hollywood-style content production to build something completely bespoke and purpose-made for consumption on the phone." They were looking for both technology leadership and product leadership and wanted to know if I was interested in one or both. And I took the meeting, even though I wasn't really taking these kinds of calls from anybody. It just seemed like who's going to pass up the opportunity to have lunch with the two of them? So I listened to the pitch and politely declined and told them that I was going to be a pastry chef or something. And we kept doing that every couple of months for seven months. We'd go to lunch, they would give me an update on the progress they were making, and I would decline the invitation to get involved somehow.

**中文翻译:**
但我当时挺认真的，甚至当 TechCrunch 采访我离开 Snapchat 的事时，我说：“我不干了，我要去做完全不同的事情。”所以那个故事传得很广。但在我离开 Snap 几个月后，我接到了 Meg Whitman 和 Jeffrey Katzenberg 的电话，他们当时正在创办一家叫 New TV 的公司（Quibi 的前身）。他们的说辞是：“我们要尝试将移动互联网、硅谷和消费科技的精华，与好莱坞式的顶级内容制作结合起来，打造一种完全定制的、专门为手机消费而设计的产品。”他们正在寻找技术负责人和产品负责人，想知道我是否对其中之一或两者都感兴趣。我参加了会面，尽管当时我基本上不接任何人的这种电话。但谁会放弃和他们两位共进午餐的机会呢？于是我听了他们的介绍，礼貌地拒绝了，并告诉他们我要去当面点师之类的。接下来的七个月里，我们每隔几个月就这样聚一次。我们会一起吃午饭，他们向我介绍进展，而我则拒绝参与其中的邀请。

---

### [00:26:05] Tom Conrad

**English:**
And then late in that year, I went to lunch one more time and Meg explained that they brought on someone to lead technology and they brought another person to lead product, and both of them really truly for reasons that are completely disconnected from Quibi itself, both of them had left after about six weeks. And Meg's like, "We've raised all this money, and we've told the world that we're shipping this product in about a year. We got an awful lot to do, and I really could use some help, and I would consider it a personal favor if you would come and spend just a couple of days a week helping." She's like, "I'll continue to look for someone who actually wants the job, but it'd be great if you could help me get this off the ground." And my wife is a freelance writer, marketing strategist and loves her life as a freelance contributor. And she's like, "You should do this. Why not? It's two days a week, it's just a few months. What's the worst thing that could happen? Maybe you'll like it." And I'm like, "No, no. Here's the thing that will happen. I won't do it two days a week. It will immediately be three days, then four days, then five days, then six days. I just know myself." And she's like, "No." She's like, "Just on Wednesday night at six o'clock, close your Quibi laptop and be like, all they're paying me for is for Tuesday and Wednesday and then open it back up on Tuesday morning. That's all you've got to do."

**中文翻译:**
那年晚些时候，我又去吃了一次午饭。Meg 解释说，他们招了一个技术负责人和另一个产品负责人，但由于与 Quibi 本身完全无关的原因，这两个人都在大约六周后离开了。Meg 说：“我们筹了这么多钱，已经告诉全世界我们大约一年后发布产品。我们有很多工作要做，我真的很需要帮助。如果你能每周来帮几天忙，我会把它看作是个人的人情。”她说：“我会继续寻找真正想要这份工作的人，但如果你能帮我把这件事启动起来就太好了。”我妻子是一名自由撰稿人和营销策略师，她很喜欢自由职业的生活。她说：“你应该去做。为什么不呢？每周两天，就几个月。最坏的情况能是什么？也许你会喜欢它。”我说：“不，不。会发生的情况是：我不会只做两天。它会立刻变成三天、四天、五天、六天。我了解我自己。”她说：“不会的。只要在周三晚上六点关上 Quibi 的电脑，心想‘他们只付了我周二和周三的钱’，然后到下周二早上再打开。你只需要这样做。”

---

### [00:27:35] Tom Conrad

**English:**
Well, she's right about most things and she's wrong about this. I fell deeply into it right away, and it was just so fun to get to build a team from scratch and to design and build a product from scratch and to take advantage of all of the sort of modern software architecture stuff that had come into being over the course of the 15 years since we had started Pandora. And I'm embarrassed about some of the what happened with Quibi for sure, but I'm super grateful for the experience, because I just really fell in love with the industry again and was reminded of just how rewarding it can be to build something and to try to put it out there even if you stumble pretty mightily along the way.

**中文翻译:**
好吧，她在大多数事情上都是对的，但在这一件上她错了。我立刻就深陷其中。从零开始组建团队、从零开始设计和构建产品，并利用自我们创办 Pandora 以来 15 年间出现的所有现代软件架构，这真的太有趣了。对于 Quibi 发生的一些事情，我确实感到尴尬，但我非常感激这段经历，因为它让我重新爱上了这个行业，并提醒我，即使一路上摔得很惨，亲手打造并发布一个东西是多么有成就感。

---

### [00:28:28] Lenny

**English:**
Is there something that you took away from that experience that taught you what to try to avoid, to try to pull towards?

**中文翻译:**
那次经历有没有教给你什么，让你知道该避免什么，或者该追求什么？

---

### [00:28:36] Tom Conrad

**English:**
I think I sort of misunderstood or misjudged companies sometimes by thinking about them really focused on the product execution. If you find an interesting problem that people care about and you solve that problem in a really beautiful, elegant, delightful way, that's 10 times better than anything else that they can get in that same space, they'll tell their friends and all the rest will take care of itself. And so that was always my ambition. Find a thing that I cared about building, do a great job building it in a delightful way, go really deep on listening to people and their feedback and iterate your way to success and breaking through that membrane that we all strive to get across, the really great word of mouth. But I think the thing I've come to better appreciate is that companies are also, they're kind of a math problem that describes how you take investment and pour them into the equation, and out the other side comes returns on some time horizon. And yes, there are variables in that equation that are influenced by the product that you build and all of the little details and decisions that you make about making that product great. But if the equation is fundamentally broken or a big swing in and of itself, no amount of iteration and execution can get you out of the failed outputs of the broken equation.

**中文翻译:**
我想我有时会误解或误判公司，因为我过于关注产品执行。如果你发现一个人们关心的有趣问题，并以一种非常美观、优雅、令人愉悦的方式解决它，比同领域的其他任何东西都好 10 倍，人们就会告诉他们的朋友，剩下的事情就会顺理成章。这一直是我的抱负：找到我想打造的东西，以令人愉悦的方式把它做好，深入倾听人们的反馈，通过迭代走向成功，并突破我们都渴望跨越的那层膜——极佳的口碑。但我现在更深刻地意识到，公司也是一个“数学题”，它描述了你如何将投资投入等式，并在一定时间范围内从另一端获得回报。是的，等式中有些变量受你构建的产品以及你为使产品变好而做的细节和决策的影响。但如果等式本身从根本上就是错的，或者本身就是一个巨大的豪赌，那么再多的迭代和执行也无法挽救错误等式带来的失败结果。

---

### [00:30:14] Tom Conrad

**English:**
And I think Quibi made a bet that you could build an entirely bespoke content library that was sufficiently scaled to get people to subscribe and retain for a couple billion dollars. It was a huge amount of money, but we made 70 shows in 18 months, which is more content than all of the major broadcast networks combined made in a single year. So it was a pretty major accomplishment. And we made a bet that we would augment those sort of episodic and serialized or Hollywood style shows with a bunch of daily content that we produce at the level of network television, nightly news, and so forth that would be an alternative to some of the sort of daily content that you might otherwise get on YouTube. And that was going to be about a third of the content spend. One super interesting thing that no one talks about is that all of that content was designed to be made day of or day before it aired. So there was no back catalog of it, and it was all designed to be shot in these professional studios that we built out, and it was really expensive. Like I said, it was a third of the investment we were going to make in content, almost half the investment we were going to be making content. And we launched two weeks into Covid, and we couldn't make any of that content except literally in the garages of the host's homes. And so we had this thing that was supposed to seem really set apart from YouTube that literally now was being made exactly YouTube content, which is sort of like self-produced at home with very little sort of the support infrastructure of Hollywood.

**中文翻译:**
我认为 Quibi 下了一个赌注：你可以花几十亿美元建立一个完全定制的内容库，其规模足以吸引人们订阅并留存。那是一大笔钱，但我们在 18 个月内制作了 70 部剧集，这比所有主要广播网络一年制作的内容总和还要多。所以这是一个相当大的成就。我们还赌了一把：我们会用大量每日更新的内容来补充那些剧集或好莱坞风格的节目，这些内容的制作水平相当于电视网的晚间新闻等，作为 YouTube 上日常内容的替代品。这部分占了内容支出的三分之一。一个没人谈论的超级有趣的细节是：所有这些内容都设计成在播出当天或前一天制作。所以没有库存，而且全部设计在我们要建造的专业演播室里拍摄，非常昂贵。正如我所说，这占了我们内容投资的三分之一，甚至接近一半。结果我们在新冠疫情爆发两周后发布，除了在主持人的车库里，我们根本无法制作任何内容。所以我们这个原本应该与 YouTube 截然不同的东西，现在做出来的东西简直和 YouTube 内容一模一样——在家自制，几乎没有好莱坞的支持基础设施。

---

### [00:32:10] Tom Conrad

**English:**
Now you can argue, I think the content on YouTube is really, really exceptional in this category, and maybe we were never going to do better than that. But I think what was really fundamentally broken with Quibi was that the actual foundational equation of can you make enough premium content that's totally bespoke and made for the service and takes advantage of the nature of the phone, is that enough content to get people to sign up and retain, and can you do that for a couple billion dollars? And I think the answer is no. The library has to be much, much bigger and you have to have, like any company, you have to have sufficient time and energy to iterate on the content format itself. Our roadmap really wanted to innovate on the content format. And so I think part of what happened is pretty quickly it became clear that the math was just wrong. It wasn't going to take 2 billion, it was going to take six or eight or 10 billion. And the risk reward profile of betting 10 billion on the format was just more than anyone can stomach.

**中文翻译:**
你可以争辩说，YouTube 在这个类别的内容其实非常出色，也许我们永远做不到更好。但我认为 Quibi 真正根本性的问题在于那个基础等式：你是否能制作足够的、完全定制的、专为该服务打造且利用手机特性的优质内容？这些内容是否足以让人们注册并留存？你能用几十亿美元做到这一点吗？我认为答案是否定的。内容库必须大得多，而且像任何公司一样，你必须有足够的时间和精力去迭代内容形式本身。我们的路线图非常想在内容形式上创新。所以我觉得部分原因是，很快大家就发现这笔账算不回来。它不需要 20 亿，而是需要 60 亿、80 亿甚至 100 亿。而在这种形式上赌 100 亿的风险回报比，超出了任何人的承受能力。

---

### [00:33:20] Lenny

**English:**
Next up, we've got Sri Batchu, former head of growth at Ramp who shares something that I've thought about ever since we had this conversation, which is this idea that when you fail, make sure you fail conclusively to make this failure an actual learning that you can build off of versus just a waste of time. Here's Sri.

**中文翻译:**
接下来是 Sri Batchu，他是 Ramp 的前增长负责人。他分享了一些自我们交谈以来我一直在思考的东西，那就是：当你失败时，确保你“彻底地失败”（fail conclusively），这样失败才能成为你可以借鉴的真实教训，而不是纯粹浪费时间。下面是 Sri 的分享。

---

### [00:33:38] Sri Batchu

**English:**
Growth experiments in my history are typically like 30%-ish success rate. So the vast majority of things that you try don't work. And so you want to create a culture where people aren't afraid to take risks and aren't afraid to fail. And for me, failure is not that you didn't drive revenue, failure is not learning. So it's really important that you learn when you fail. And so we celebrate failure as long as you're learning, and you can only learn if you've designed the right test and you failed conclusively, because otherwise I think many of us have been in situations where there's intuition that something might work and it doesn't work, and then you end up doing it over and over for years because every time a new executive or somebody else has the same idea, you try it again. And it's because you haven't been able to design the test to fail conclusively.

**中文翻译:**
在我的经历中，增长实验的成功率通常在 30% 左右。所以你尝试的大多数事情都是行不通的。因此，你需要建立一种文化，让人们不害怕承担风险，也不害怕失败。对我来说，失败不是你没有带来收入，失败是“没有学到东西”。所以，失败时学到东西非常重要。只要你在学习，我们就庆祝失败。而只有当你设计了正确的测试并“彻底地失败”时，你才能学到东西。否则，我想我们很多人都遇到过这种情况：直觉告诉我们某件事可能行得通，结果没行通，然后接下来的几年里你反反复复地做这件事，因为每当一个新高管或其他人有了同样的想法，你就会再试一次。这是因为你没能设计出一个能让你“彻底失败”的测试。

---

### [00:34:31] Sri Batchu

**English:**
It's hard to do. But at the end of the day, there's only two ways to make an experiment successful. Either you have a very large N or you have a very significant treatment, which is what you're doing in the experiment itself. And in B2B, you don't usually have the luxury of large N, which you [inaudible 00:34:54] consumer. Facebook can get [inaudible 00:34:56] in two hours. A B2B company could take two years to get to the same number of touch points. And so to counteract that, I recommend people just trying to maximize the treatment effect, which is like if you have a hypothesis that you're testing, just throw all of the possible tactics and resources that you think would move that needle because you can always cost rationalize later if it works. And so just maximize the treatment effect. And if with all of that it didn't work, then you can say, "Hey, we're not going to try this again because we literally did try everything that we could to test this hypothesis. And if it doesn't work in the best version, and it's expensive as it is, this is not worth spending more time on." But if it does work, great. Then you do another version of the test with half the tactics or whichever tactics you think work better or worse and you optimize over time.

**中文翻译:**
这很难做到。但归根结底，让实验成功的途径只有两条：要么你有非常大的样本量（N），要么你有非常显著的实验干预（treatment），也就是你在实验中所做的动作。在 B2B 领域，你通常没有 C 端产品那样的大样本量优势。Facebook 可能在两小时内就能获得足够的样本，而 B2B 公司可能需要两年才能达到同样的触达点数量。为了抵消这一点，我建议人们尝试“最大化干预效果”（maximize the treatment effect）。也就是说，如果你正在测试一个假设，就把所有你认为能推动指标的策略和资源都投进去，因为如果行得通，你以后总可以进行成本合理化。所以，先最大化干预效果。如果做了这一切还是没用，你就可以说：“嘿，我们不会再试这个了，因为我们确实尝试了所有能测试这个假设的方法。如果它在最好的版本下、在投入这么多成本的情况下都行不通，那就不值得再花时间了。”但如果行得通，太好了。然后你可以再做一个版本的测试，减去一半的策略，或者保留你认为效果更好的策略，随着时间的推移进行优化。

---

### [00:35:49] Lenny

**English:**
Is there an example you could share when you did that?

**中文翻译:**
你能分享一个你这样做的例子吗？

---

### [00:35:53] Sri Batchu

**English:**
Account-based marketing is something that is very common in enterprise software where you've selected certain customers that you think are high priority and you're saying, "I want to touch them in as many nuanced ways possible to see if that drives conversion." And this is something I've seen tried many times where people do it, but they kind of do it halfway where they're like, okay, tried these three things. Conversion of the control group wasn't higher, and so we think it is not going to work. And then a new go-to-market executive comes and they have to do it again. They have to do it again. They have to do it again. It's like a very common one wherever this happens. And so when we did it at Ramp, we did exactly what I just described, which is like, let's really be thoughtful about the experiment design, both in terms of maximizing the number of people as well as maximizing the number of ways and types of ways that we're effectively touching these target customers to show the value one way or the other.

**中文翻译:**
ABM（目标客户营销）在企业软件中非常常见。你选择了一些你认为高优先级的特定客户，然后说：“我想通过尽可能多的细致方式触达他们，看看是否能推动转化。”我见过很多人尝试这个，但他们往往只做了一半，比如试了三种方法，发现转化率没比对照组高，就觉得行不通。然后新来的市场高管又要求再做一遍，再做一遍。这种情况非常普遍。所以当我们在 Ramp 做这件事时，我们采取了刚才描述的方法：非常周密地设计实验，既要最大化覆盖人数，也要最大化触达这些目标客户的方式和类型，从而明确地证明其价值。

---

### [00:37:03] Lenny

**English:**
So what it sounds like is the hypothesis isn't like this email will have a big impact on conversion. It's like this strategy of coming after customers is what we're testing.

**中文翻译:**
所以听起来，假设并不是“这封邮件会对转化产生重大影响”，而是“这种获取客户的策略”才是我们要测试的。

---

### [00:37:15] Sri Batchu

**English:**
That's the example there. And I think for example, if you had the... This kind of framework is more important for cross-functional, larger scale, bigger tests rather than an email modification. But we can even use it on a micro example like an email modification where you are like, "Okay, I think this particular email is underperforming because it's not talking to this part of the customer's pain point or journey or what have you." And you could just, the simplest test would be, okay, let me make some tweaks to the text and edit that, and that could be the end of that test. And if that doesn't work, you're like, "Oh, maybe those weren't the right text edits. Let me do a different text edits or whatever." And that's fine, that's low cost. It's not the end of the world and it's for you to be wrong there. But an alternative that you could do is like, "Oh, what are all of the things that I could change about this email in the same test?" Is it the trigger of the email? Is it the text content of the email? Is it additional personalization? Is it the design of the email? Trying to think of what are all of the various levers that you think could be wrong and put them all together to test your hypothesis of this touch point is wrong, and how do I improve that?

**中文翻译:**
就是这个意思。我认为这种框架对于跨职能、大规模的测试比对一封邮件的修改更重要。但我们甚至可以把它用在微观例子上，比如修改邮件。你可能会想：“我觉得这封邮件表现不好，因为它没触及客户的这个痛点或旅程阶段。”最简单的测试就是改改文案，测试结束。如果没用，你会想：“哦，也许文案改得不对，我再换个写法。”这没问题，成本很低，错了也不是世界末日。但另一种做法是：“关于这封邮件，我能在同一次测试中改变的所有因素是什么？”是触发机制吗？是正文内容吗？是额外的个性化吗？是设计吗？把所有你认为可能出问题的杠杆都放在一起，去测试你的假设——即“这个触达点有问题”，以及“我该如何改进它”。

---

### [00:38:34] Lenny

**English:**
Well, obviously the downside of that is you, if it doesn't work, you don't know if it's like, oh, maybe it was this thing could have worked in the subject.

**中文翻译:**
显然，这种做法的缺点是，如果它没起作用，你不知道是不是因为某个特定的点（比如标题）本来是可以起作用的。

---

### [00:38:40] Sri Batchu

**English:**
Yeah, so there's always trade-offs on this, but what you're hoping is you've done a complete refresh where you did all the things that you thought were intuitive that should work. And if it doesn't work, then you're like, okay, maybe my hypothesis wrong. But you're right. There's always going to be a challenge if maybe the execution is wrong. And I did too many things potentially in that case.

**中文翻译:**
是的，这总是有权衡的。但你希望的是你已经做了一次彻底的更新，把所有你直觉认为应该起作用的事情都做了。如果还是不行，那你就可以说，也许我的假设本身就是错的。但你是对的，如果执行有问题，或者我一次改了太多东西，确实会带来挑战。

---

### [00:39:01] Lenny

**English:**
Our next story is from JZ, who is a colleague of mine at Airbnb, head of product at Webflow when we recorded this episode, and this is her sharing the story of one of the biggest product misses at Airbnb. You've seen a lot of new PMs, and you've seen these PMs succeed, you've seen some fail. What are the most common mistakes that you find new PMs make in this experience of helping new PMs get into the field?

**中文翻译:**
我们的下一个故事来自 JZ（Jiaona Zhang）。她曾是我的 Airbnb 同事，录制本集时她是 Webflow 的产品负责人。她将分享 Airbnb 最大的产品失误之一。你见过很多新入行的产品经理（PM），见过他们成功，也见过他们失败。在帮助新 PM 入行的过程中，你发现他们最常犯的错误是什么？

---

### [00:39:27] Jiaona Zhang (JZ)

**English:**
I think something that is really hard to untrain, but I think every human does it, is you jump to solutions. And so one of the biggest things I see, not just in my course, but also just as a PM and some of the mistakes that you make as a PM is the idea of you get really attached to a solution, a way of implementing something, something that you can see in your head that you want to build. And so that's the first thing I really want to like unteach in our course. And so a lot of people will literally come in, they'll be like, "I want to build X startup," or, "I want to do this thing," or, "I am in blank school, and I've been doing a lot of research on this particular area." And so untraining that and being like, "Hey, we're going to go out there. We are not going to think at all about the thing that you want to build, but instead we're going to be focused on users and people in the real world and their problems. And the first step is to understand their problems and then understand if there's an opportunity here as opposed to, hey, you want to build X thing for Y person." So that's the biggest mistake that you really have to unteach and retrain thinking around.

**中文翻译:**
我认为有一件事很难纠正，但每个人都会这么做，那就是“直接跳到解决方案”。我看到的最大的问题之一——不仅是在我的课程中，也包括作为 PM 自身犯的错误——就是你对某个解决方案、某种实现方式、或者你脑子里想造的某个东西产生了过度的依恋。这是我在课程中首先想让大家“忘掉”的东西。很多人一进来就会说：“我想做一个 X 创业公司”，或者“我想做这件事”，或者“我在某某学校，我对这个特定领域做了很多研究”。我们要纠正这种思维，告诉他们：“嘿，我们要走出去。我们完全不去想你想造的那个东西，相反，我们要关注真实世界中的用户和人，以及他们的问题。第一步是理解他们的问题，然后看这里是否有机会，而不是‘你想为某人造个某物’。”这是必须纠正并重新训练思维的最大错误。

---

### [00:40:25] Lenny

**English:**
So let's go to the other side of this question. We talked about what mistakes new PMs make. I'm curious, what's the biggest product mistake that you've made?

**中文翻译:**
那我们来看看问题的另一面。我们谈到了新 PM 会犯什么错。我很好奇，你犯过的最大的产品错误是什么？

---

### [00:40:34] Jiaona Zhang (JZ)

**English:**
Wow, that's a good one. It's so interesting. I feel like as product people we're always making mistakes and we're always learning. Maybe I'll give an example from Airbnb since you and I were both there. And this one does stand out to me. So we're working on this concept called Airbnb Plus. If you took a step back, what we're really trying to do is to be like, "Hey, not everyone trusts Airbnb in terms of it's a platform. It's not like it's managed inventory, it's not a hotel. How do you go in and really make sure that we're all the Airbnbs are meeting the quality bar?" But I do think we were very solution first, and I think we're also competitor afraid at the time. So it was during a time where there were managed marketplaces, there were the Saunders out there, and I think that as a company we're very much like, "Oh, look at this. What are we going to do in the world of managed marketplaces?"

**中文翻译:**
哇，问得好。很有趣。我觉得作为产品人，我们总是在犯错，总是在学习。既然你我都在 Airbnb 待过，我就举个 Airbnb 的例子吧。这个例子对我来说非常深刻。当时我们正在做一个叫 Airbnb Plus 的项目。退一步看，我们真正想做的是：“嘿，并不是每个人都信任 Airbnb，因为它是一个平台，不是受控的库存，也不是酒店。我们如何确保所有的 Airbnb 房源都达到质量标准？”但我认为我们当时非常“解决方案优先”，而且当时我们也害怕竞争对手。那是“托管型市场”（managed marketplaces）兴起的时期，像 Sonder 这样的公司出现了。作为一家公司，我们当时非常焦虑：“看啊，在托管型市场的世界里，我们要怎么办？”

---

### [00:41:19] Jiaona Zhang (JZ)

**English:**
And so we went really hard down the solution space. We essentially were like, "Let's go inspect our inventory. Let's actually try to manage our inventory more." And really what we should have done is taken a step back and be like, "What's the real problem?" The real problem is people want to know what they're getting themselves into. We need to represent the homes a lot better. And I think the other piece here that's really important is what, as a company, is there strategic strength? And what's in your wheelhouse? So for example, Airbnb, we weren't that strong in operations. We again, we're this platform with this marketplace. And so if you don't have that muscle and then you're asking the company, the teams to essentially build it from the ground up, that's really, really difficult. Not to mention the unit economics. Are the unit economics actually going to work, even as you scale?

**中文翻译:**
于是我们在解决方案上走得很极端。我们基本上在想：“让我们去检查我们的房源，让我们尝试更多地管理我们的房源。”而实际上我们应该做的是退一步问：“真正的问题是什么？”真正的问题是人们想知道他们入住的是什么样的环境，我们需要更好地展示这些房屋。我认为另一个非常重要的部分是：作为一家公司，你的战略优势是什么？你的擅长领域（wheelhouse）是什么？例如，Airbnb 在运营方面并不强。我们是一个平台，一个市场。如果你没有那种基因（muscle），却要求公司和团队从头开始构建它，那是极其困难的。更不用说单位经济效益（unit economics）了。即使在你规模化之后，单位经济模型真的能跑通吗？

---

### [00:42:03] Lenny

**English:**
Yeah, I feel like Airbnb Plus is an untold story that somebody should tell, and that could be its own podcast, I guess.

**中文翻译:**
是的，我觉得 Airbnb Plus 是一个还没被揭开的故事，应该有人来讲讲，这本身就能做成一期播客。

---

### [00:42:09] Jiaona Zhang (JZ)

**English:**
You and I can tell it.

**中文翻译:**
你和我就可以讲。

---

### [00:42:10] Lenny

**English:**
We could tell it. This could be Airbnb Plus the hidden, the story. As you said, the problem it was trying to solve was people don't really trust, they don't want to even consider Airbnb. Like, "No, I don't want to stay in someone's home. I don't know what it'll be. It's unpredictable." And so as an outsider, it felt like a really clever approach. We're going to get them, we're going to make sure they're awesome. There's a minimum bar. And I guess this is the question is do you think it was just like this is never possible because we'll never make money as a business doing this, because we don't make that much booking and investing time, resources, sending people pillows, all that stuff is ever going to be economical. Or do you think there was a path, and it was just not executed well?

**中文翻译:**
我们可以讲。这可以叫《Airbnb Plus：隐藏的故事》。正如你所说，它试图解决的问题是人们不信任、甚至不考虑 Airbnb。比如：“不，我不想住在别人家里，我不知道会是什么样，太不可预测了。”所以作为一个局外人，这看起来是一个非常聪明的办法：我们要筛选房源，确保它们很棒，设定一个最低标准。我的问题是：你认为这从根本上就是不可能的吗？因为作为一家企业，这样做永远赚不到钱——因为我们的订房佣金没那么多，而投入时间、资源、给房东寄枕头之类的，永远不会经济。还是说你认为其实是有可能的，只是执行得不好？

---

### [00:42:51] Jiaona Zhang (JZ)

**English:**
I think there wasn't really a clear path. I think there was [inaudible 00:42:55]. Exactly. And it was more just like if you understood, again, this is my point around unit economics, there are things where I think you have magical thinking around unit economics. You're like, "Well, when we get to the scale of X, it's all going to work out. We can make these things happen." I think you actually need to really make sure the unit economics work right at the beginning. So that is definitely one lesson. And I think the other thing is, and going back to the spirit of what are you trying to achieve. If you're trying to achieve this idea of really knowing the quality of the place, and for a platform like Airbnb, the right way to go about doing is through our reviews, through our guest reviews, which are essentially free as opposed to literally sending out inspectors.

**中文翻译:**
我认为并没有一条清晰的路径。没错。更多的是，如果你理解了——再次回到我关于单位经济效益的观点——在某些事情上，人们会对单位经济模型产生“幻觉”。你会想：“好吧，当我们达到 X 规模时，一切都会好起来的，我们可以实现这些。”我认为你实际上需要确保单位经济模型在最开始就是成立的。所以这绝对是一个教训。另一件事是，回到你想要实现的目标。如果你想真正了解房屋的质量，对于像 Airbnb 这样的平台，正确的方法是通过我们的评价，通过房客的评价，这基本上是免费的，而不是真的派检查员过去。

---

### [00:43:32] Jiaona Zhang (JZ)

**English:**
And I think that the other things are if you can get signal on what are the things around quality that people care about? Is it cleaning? Is it the, "Hey, I'm locked out." And I think that there are other solutions besides inspection that then get at that. So for example, it is actually cheaper to go send everyone a lockbox than to deploy an inspector and go look at your property, right? It is actually cheaper to maybe do a partnership with a bunch of cleaners in different local areas, and then get that as part of the feat as opposed to doing inspection. So again, it's really about what are you really trying to achieve? What is the user problem in each of these areas, and can you target that problem with the particular listing that you're looking at? And so yeah, I personally don't believe the unit economics ever would've really worked out. I think we should have known that, or we should have dug into that more at the very beginning, and then to get very tailored instead of one blunt instrument to solve it all. Hey, we're going to go inspect. It's like, what is the problem for this listing, and what's the best solution to fix that problem?

**中文翻译:**
我认为还有其他方法，比如你是否能获得关于人们关心的质量问题的信号？是清洁吗？还是“嘿，我被锁在门外了”？除了实地检查，还有其他解决方案可以解决这些问题。例如，给每个人寄一个密码钥匙盒（lockbox）实际上比派检查员去查看房产要便宜，对吧？与不同地区的清洁工建立合作伙伴关系，并将其作为功能的一部分，可能也比实地检查更便宜。所以，这还是回到了：你到底想实现什么？在每个领域用户的问题是什么？你能针对特定房源解决那个问题吗？所以，我个人不相信单位经济模型能跑通。我认为我们本该知道这一点，或者在最开始就深入研究，然后采取非常定制化的方案，而不是用一个笨重的工具（实地检查）来解决所有问题。应该问：这个房源的问题是什么，解决这个问题的最佳方案是什么？

---

### [00:44:33] Lenny

**English:**
Our second to last story is from Gina Gotthilf, who was an early growth leader at Duolingo. She's currently COO of Latitud, and this is her sharing a wide-ranging and important point about how everyone has both an A side and a B side to their career, and people often only share their A side. So this is Gina sharing her B side.

**中文翻译:**
我们的倒数第二个故事来自 Gina Gotthilf，她是 Duolingo 的早期增长负责人。她目前是 Latitud 的首席运营官。她分享了一个广泛且重要的观点：每个人的职业生涯都有 A 面和 B 面，而人们通常只分享 A 面。所以这是 Gina 在分享她的 B 面。

---

### [00:44:53] Gina Gotthilf

**English:**
We are very encouraged in our lives, especially professionally, to talk about our A side all the time because that's what impresses people. That's what opens doors, that's what allows us to keep growing, and it's so important. So it means that a lot of what you hear in podcasts and on stage ends up being the Instagramable version of someone or a company or a country's trajectory. It's just the highlights. And when I talk about my A side, it's very impressive. I did things like, we'll talk about, I met President Obama, I worked on the Mike Bloomberg presidential campaign. I helped Duolingo scale from three to 200 million users. I worked with Tumblr, helping them scale Latin America, Andreesen Horowitz invested in my company, etc. But between all of those highlights, there were so many B moments that get shoved under the rug because it's just easier for me and it's more impressive for others. But I really like to highlight those because I think that most of us have a lot of B moments every day, every week, every month, and every period of our lives. And it's easy to think that things aren't just not going to work out for us because we're in one of those B moments if we don't recognize them as moments.

**中文翻译:**
在生活中，尤其是在职业生涯中，我们被鼓励一直谈论自己的 A 面，因为那是让人印象深刻的东西。那是敲门砖，是让我们不断成长的动力，这非常重要。这意味着你在播客和舞台上听到的很多内容，最终都成了某个人、某家公司或某个国家发展轨迹的“精修版”（Instagramable version）。那只是高光时刻。当我谈论我的 A 面时，它非常令人印象深刻：我见过奥巴马总统，我参与过迈克尔·布隆伯格的总统竞选活动，我帮助 Duolingo 的用户从 300 万增长到 2 亿，我曾在 Tumblr 工作并帮助他们扩展拉美市场，Andreessen Horowitz 投资了我的公司，等等。但在所有这些高光时刻之间，有太多的 B 面时刻被掩盖了，因为对我来说这样更容易，对别人来说也更令人印象深刻。但我真的很想强调这些 B 面，因为我认为我们大多数人在每一天、每一周、每一个月以及生命的每一个阶段都有很多 B 面时刻。如果我们不把它们仅仅看作是一个“时刻”，就很容易认为自己彻底没戏了。

---

### [00:45:59] Lenny

**English:**
I love this concept. We're going to talk as you expected about a lot of your A side stuff. Is there any example of a B side story of your life that would be interesting to share?

**中文翻译:**
我喜欢这个概念。正如你预料的，我们会谈论很多关于你 A 面的事情。但在你的生活中，有没有什么有趣的 B 面故事可以分享？

---

### [00:46:09] Gina Gotthilf

**English:**
Look, I think those are the most interesting because they're funny or ridiculous. I had a lot of B sides, and I still do. For example, I had no idea what I wanted to do. I actually wanted to be. I thought I wanted to be an actress. I either wanted to be that person in Sea World, who goes like this with a dolphin. This is before Sea World was canceled. Or I wanted to be an actress. I applied to schools. I didn't get into any Ivy League. I didn't get into any of the top schools I wanted to go to. When I got to college, I actually ended up dropping out because I got so depressed, incredibly depressed, couldn't get out of bed depressed. Ironically, I dropped out of Reed College, which is the same college that Steve Jobs dropped out of. So I was just destined for greatness. I knew it at that moment.

**中文翻译:**
听着，我觉得那些才是最有趣的，因为它们要么好笑，要么荒谬。我曾有很多 B 面，现在也还有。例如，我以前完全不知道自己想做什么。我其实想当一名演员。我要么想成为海洋世界里那个和海豚互动的人（那是海洋世界被抵制之前的事），要么想当演员。我申请了学校，但没考上任何常春藤盟校，也没考上任何我想去的顶尖学校。上大学后，我最终退学了，因为我变得非常抑郁，极度抑郁，甚至到了无法起床的地步。讽刺的是，我从里德学院（Reed College）退学了，那正是史蒂夫·乔布斯退学的学校。所以在那一刻我就知道，我注定要成就一番伟业（开玩笑）。

---

### [00:46:53] Lenny

**English:**
It all makes sense looking backwards, as he said.

**中文翻译:**
正如他所说，回过头来看，一切都说得通了。

---

### [00:46:55] Gina Gotthilf

**English:**
Totally. I was dropping out, being like, "Yes, this is exactly the path." No, I was miserable. I thought there was no path forward. And I finally went back and graduated. The college counselor looked at my curriculum and said, "What have you even done with your life? There's nothing to show for." And it was shocking because I was always the overachiever who wants to do the maximum curriculum and ace all of my classes and do whatever. I did three diplomas in high school, the international, the American, the Brazilian.

**中文翻译:**
完全正确。我当时退学的时候心想：“没错，这就是我要走的路。”不，其实我当时痛苦极了。我觉得前途渺茫。最终我还是回学校毕业了。大学辅导员看着我的履历说：“你这辈子到底干了什么？什么成果都没有。”这让我很震惊，因为我一直是个“卷王”（overachiever），总是想修最多的课，拿全 A。我在高中拿了三个文凭：国际文凭、美国文凭和巴西文凭。

---

### [00:47:22] Gina Gotthilf

**English:**
And so that for me, I think my one learning there that has stuck with me, and I think it can work for other people too, is that it's not just about doing things that actually matter and learning. It's about being able to tell the story, and it's about understanding what other people perceive as valuable. I applied to a hundred companies. I didn't hear back from most of them. I finally got an internship at kind a tier B/C digital marketing agency in New York City because I wanted to live in New York so badly. And they forgot to apply for my visa on time. So I lost my visa and had to go back to Brazil, and then I ended up leaving that organization to go work for another one. And I won't even go into the details of the shadiness of that company that I worked for, but then they ended up laying me off. So I lost my visa again, had to go back home, found another opportunity, got fired that time. So there was just a lot of rockiness in my start that I don't think you would imagine when you see someone up on stage leading a conference for 5,000 people. That I think is important.

**中文翻译:**
所以对我来说，我学到的一个一直伴随着我的教训是（我认为这对其他人也适用）：这不仅仅关乎做真正重要的事情和学习，还关乎你如何讲述这个故事，以及理解别人认为什么是“有价值的”。我申请了一百家公司，大多数都没有回复。最后我在纽约一家二三流的数字营销机构找到了实习机会，因为我太想住在纽约了。结果他们忘了按时帮我申请签证。所以我失去了签证，不得不回巴西。后来我离开那家机构去了另一家。我都不想细说那家公司有多阴暗，但最后他们把我裁了。所以我又失去了签证，不得不回家。后来又找了一个机会，结果那次被开除了。所以我的起步非常坎坷，当你看到一个人在台上主持 5000 人的会议时，你可能想象不到这些。我认为这很重要。

---

### [00:48:26] Gina Gotthilf

**English:**
And even when I started working for Tumblr, I was like, "This is it. I made it. This is a really interesting company. This is going to work out." That was super rocky because it was an early stage startup. So for example, they couldn't figure out how to wire money to Brazil. So I was not paid for six months. And at one point, me and my colleagues were trying to get money out of the teller to pay contractors because we had no money to pay them, and we borrowed money from people. And finally they also laid me off because they decided to sell to Yahoo. And then I had to figure out what am I going to do? No one's going to hire me. I've been fired and laid off so many times. So this is all before I started an agency to help US-based tech companies and startups grow in Latin America because I figured I was in this really great place to make that happen. And it eventually worked for, well-known companies such as Duolingo. At the time they weren't well-known. They were a tiny little startup. They didn't have an Android app. And that's how I started working with Duolingo because their head of marketing connected with someone they had worked with at Flickr and said, "I noticed Tumblr grew a lot in Brazil last year. Can you recommend a company or an agency to help?" And they said, "This girl." And I was twenty-six. And so that's how they connected me with Duolingo. And I started helping them grow in Brazil as a consultant. They were like, "This is great. Can you help us grow in Chile, Argentina?" And I was like, "Yes." They were like, "How about Mexico?" And I was like, "Yes." Did I know anything about these places, Lenny? Did I know people there? No, but you can figure it out.

**中文翻译:**
甚至当我开始为 Tumblr 工作时，我想：“就是它了，我成功了。这是一家非常有趣的公司，一定会成功的。”但那段经历也非常坎坷，因为它是一家早期创业公司。例如，他们搞不清楚怎么把钱汇到巴西，所以我六个月没领到工资。有一次，我和同事们试图从柜员机取钱付给承包商，因为我们没钱付，还向别人借了钱。最后，因为他们决定卖给雅虎，他们也把我裁了。然后我不得不思考：我该怎么办？没人会雇我了，我被开除和裁员了这么多次。这一切都发生在我创办一家帮助美国科技公司和初创企业在拉美增长的代理机构之前。我当时觉得我处于一个非常好的位置来实现这件事。最终，它为 Duolingo 等知名公司提供了帮助。当时他们还不出名，只是一家微型初创公司，甚至没有 Android 应用。这就是我开始与 Duolingo 合作的契机：他们的营销负责人联系了曾在 Flickr 工作过的人，说：“我注意到 Tumblr 去年在巴西增长很快，你能推荐一家公司或代理机构来帮忙吗？”对方说：“找这个女孩。”当时我 26 岁。于是他们把我引荐给了 Duolingo。我开始作为顾问帮助他们在巴西增长。他们说：“太棒了，你能帮我们在智利、阿根廷增长吗？”我说：“没问题。”他们问：“墨西哥呢？”我说：“没问题。”Lenny，我对这些地方了解吗？我在那里有人脉吗？没有，但你可以边做边学。

---

### [00:49:51] Gina Gotthilf

**English:**
And then they ended up asking me to come on full time, do that across the world, Japan, China, Korea, Turkey, Spain, France, et cetera. And then to own growth, which ended up meaning communications, social media, government partnerships, anything to grow. And then eventually became an A/B testing growth engine with engineers and PMs and designers of which I knew nothing about. And even after that, I left Duolingo five years later, didn't know what to do with my life. You'd think, "Oh wow, you have it figured out now. You left Duolingo, you have the world in front of you." And I'm like, "Maybe I can finally go work for nonprofits," which is what I actually wanted to do in the first place. Tried a hand at that. Had a couple of experiences before going to work for the Mike Bloomberg campaign. Working for the Mike Bloomberg campaign is impressive. But you know what? Mike Bloomberg didn't win. He's not the president. So that was not a successful campaign if you really look at it. And yeah, Latitud seems like it's a really promising path, but there's A days and B days. So it's just a lot of that. And just staying resilient and believing in yourself and getting back on the horse when you fall on your face.

**中文翻译:**
后来他们请我全职加入，负责全球市场：日本、中国、韩国、土耳其、西班牙、法国等等。然后负责整个增长部门，这意味着要管沟通、社交媒体、政府合作，只要能增长的事都管。最后，它变成了一个由工程师、PM 和设计师组成的 A/B 测试增长引擎，而我最初对这些一窍不通。五年后我离开 Duolingo，依然不知道这辈子该干什么。你可能会想：“哇，你现在肯定想通了，你离开了 Duolingo，世界就在你脚下。”而我想的是：“也许我终于可以去非营利组织工作了”，那其实是我最初想做的事。我尝试了一下，在加入迈克尔·布隆伯格的竞选团队之前有几段经历。为布隆伯格工作听起来很牛，但你知道吗？他没赢，他不是总统。所以从结果看，那并不是一次成功的竞选。现在，Latitud 看起来是一条很有前途的道路，但也有 A 面日子和 B 面日子。就是这样，保持韧性，相信自己，摔倒了就重新爬起来。

---

### [00:51:00] Lenny

**English:**
Amazing. That's such an important message. I think one of the threads from what you're describing, something that I think about a lot is people kind of underestimate how long their career is. There's just so much time to do stuff and for things to start to work. This going to sound really fancy, but I think Marcus Aurelius has this quote about how our life is actually very long. We just use it really badly and we just waste a lot of our time.

**中文翻译:**
太棒了。这是一个非常重要的信息。从你的描述中，我思考很多的一点是：人们往往低估了自己的职业生涯有多长。你有足够的时间去做事，让事情开始起色。这听起来可能有点玄乎，但我记得马可·奥勒留有一句话，大意是我们的生命其实很长，只是我们用得很糟糕，浪费了太多时间。

---

### [00:51:21] Gina Gotthilf

**English:**
I think you're so right, Lenny, and I love that because people are going around being like, "Life is short, life is short." But that's so true. We waste so much time. But also I think we don't recognize how much opportunity we have in front of us. And as a 26-year-old, I definitely thought my career was over. I was like, "I blew it." And looking back, it's funny.

**中文翻译:**
我觉得你说得很对，Lenny。我喜欢这个观点，因为人们总是在说“人生苦短，人生苦短”。但事实确实如此，我们浪费了太多时间。而且我认为我们没有意识到面前有多少机会。26 岁的时候，我真的觉得我的职业生涯完蛋了，我想“我搞砸了”。现在回想起来，挺逗的。

---

### [00:51:40] Lenny

**English:**
Yeah, I know exactly what you mean. I spent nine years at my first job at a random company in San Diego in a startup. I was like, "What am I doing here so long?" And it turned out that was really useful for the thing I did next. And then eventually, wow, things started to really take off. So I think that's a really good lesson for people. It's just a long time. This is my fourth career. I've switched careers many times. I was an engineer then. I was a founder. Then I was a product manager, and whatever this is. Whatever you call this thing.

**中文翻译:**
是的，我完全明白你的意思。我的第一份工作在圣地亚哥的一家普通创业公司干了九年。我当时想：“我为什么在这儿待这么久？”结果证明，那段经历对我接下来的事情非常有用。最终，哇，事情真的开始起飞了。所以我觉得这对大家是一个很好的教训：时间还长着呢。这是我的第四份职业。我换过很多次职业：我当过工程师，当过创始人，当过产品经理，还有现在的这个……不管你怎么称呼我现在做的这件事。

---

### [00:52:06] Gina Gotthilf

**English:**
I guess me, too. I was an operator. I was a consultant. Well, I was an employee. I was a consultant. Then I was an operator, which is a fancy way to say employee at a startup. And then now I'm a founder and a VC and an angel and whatever this is..

**中文翻译:**
我想我也是。我当过执行者（operator），当过顾问。嗯，我当过雇员，当过顾问，然后当过执行者（这是“创业公司员工”的高级说法）。现在我是创始人、VC、天使投资人，以及现在的这个……

---

### [00:52:22] Lenny

**English:**
Awesome. Awesome. So I think that's a really important takeaways. Just there's a lot of time to do stuff and don't stress if things aren't moving as fast as you want. I'm curious, what's a mess-up or a big mistake maybe that you made or your teammate that was like, "Oh wow, that was a big waste of time."

**中文翻译:**
太棒了。我认为这是一个非常重要的启示：有足够的时间去做事，如果事情进展不如你预期的那样快，不要压力太大。我很好奇，你或你的队友有没有犯过什么大错，让你觉得“哇，那真是浪费时间”？

---

### [00:52:38] Gina Gotthilf

**English:**
Yeah, look, a lot of things didn't work out. More than 50% of our A/B tests didn't work out. We made bets that didn't make sense. I will say though, that in the spirit of A and B sides, I, and I think in general, we are really good at forgetting the B stuff. I talk so much about all the stuff that worked that it's hard to remember all of those moments that didn't actually work. And the thing that I tend to talk about, which is this mistake that we made as the growth team is almost like one of those, when you get asked in an interview, what's your biggest weakness, and you're like, "I'm a perfectionist." It's like one of those things that actually makes you sound good because it's the story about how my team really wanted to implement badges.

**中文翻译:**
是的，听着，很多事情都没成功。我们超过 50% 的 A/B 测试都失败了。我们下过一些毫无意义的赌注。不过我要说的是，本着 A 面和 B 面的精神，我（以及我认为的大多数人）非常擅长忘记 B 面的事情。我谈论了太多成功的事，以至于很难想起那些失败的时刻。我倾向于谈论的那个增长团队犯的错误，有点像面试时被问到“你最大的缺点是什么”时回答“我是个完美主义者”——这种错误其实让你听起来还不错。那是关于我的团队非常想实现“勋章”（badges）功能的故事。

---

### [00:53:35] Gina Gotthilf

**English:**
And badges was just pervasive in all of the top games. And so it seemed like a no-brainer, but since we ranked all of our experiments in terms of ROI and return being like how many users we think we're going to get from this DAUs, and time investments, it never made sense to focus on this because we thought that the time sink would be too high. So I actually ended up not letting the team run this experiment for six months so that we focused on lower hanging fruit. So that's a mistake on my end. Then we decided to run this experiment in the most lean way possible. We're like, "You know what? There's MVEs. There's minimum viable experiments. We don't have to run a whole badges thing. We can just do something more simple and actually see if that leads to growth in an interesting way, and then we'll know."

**中文翻译:**
勋章功能在当时所有的顶级游戏中都无处不在，所以这看起来是不言而喻的。但由于我们根据投资回报率（ROI）对所有实验进行排名——回报是指我们认为能带来多少 DAU（日活用户），投入是指时间成本——我们觉得专注于这个功能没有意义，因为我们认为时间成本太高了。所以我实际上有六个月没让团队做这个实验，而是去关注那些“唾手可得的成果”（lower hanging fruit）。这是我的错误。后来我们决定以最精简的方式运行这个实验。我们想：“你知道吗？有 MVE（最小可行性实验）。我们不需要做一个完整的勋章系统，我们可以做点简单的，看看它是否能以有趣的方式带来增长，然后我们就知道了。”

---

### [00:54:20] Gina Gotthilf

**English:**
And we ran this very simple experiment that was like, you signed up and then you get a badge. And it was like this girl with a balloon. I don't know, she was happy or whatever. And of course in retrospect, it led to no results, because no one is proud of signing up. It's not an exciting moment, and you don't even have badges to collect. You can't show it to other people. None of the things that make badges compelling were there, but we were like, "Okay, well, we tested it didn't work." And then we moved on. So we moved on for another, I don't know, eight months and we didn't look back. And then when we did look back, first of all at that point we discovered that we hadn't been dogfooding, which also was embarrassing. Looking back, we hadn't been dogfooding in the growth team. We just come up with hypotheses. We were super careful about prioritizing them and making sure that we were doing the best possible write ups and all these things. But the dogfooding piece, I didn't come from a product background. I was a marketer and I didn't really understand the term dogfooding, but when we thought, we had a conversation, we were like, "You know what? If we had just tested that, we would've all known that this was a super lame badge." And I was like, "Why are we not testing our experiments?" And so that became part of our practice.

**中文翻译:**
我们运行了一个非常简单的实验：你注册了，然后得到一个勋章。勋章上是一个拿着气球的女孩，我不知道，反正她看起来很开心。当然，回过头来看，这没有任何结果，因为没人会为“注册”感到自豪。那不是一个令人兴奋的时刻，你甚至没有勋章可以收集，也不能展示给别人看。让勋章具有吸引力的因素一个都没有。但我们当时想：“好吧，我们测试过了，没用。”然后我们就继续做别的了。我们又过了大概八个月没再回头看。当我们再次回头看时，首先发现我们一直没有进行“内部试用”（dogfooding），这也很尴尬。回想起来，增长团队当时没有内部试用。我们只是提出假设，非常仔细地进行优先级排序，确保写出最好的文档。但我不是产品背景出身，我是做营销的，当时并不真正理解“吃自家狗粮”（dogfooding）这个词。但当我们交流时，我们意识到：“你知道吗？如果我们自己测试过，我们都会知道那个勋章超级烂。”我当时想：“为什么我们不测试我们的实验呢？”于是这成了我们实践的一部分。

---

### [00:55:26] Gina Gotthilf

**English:**
It's still relevant. I just had a conversation yesterday with engineers at Latitud. I haven't explained what we built yet, where we're building it. Maybe we'll get there, but I was talking yesterday, [inaudible 00:55:35] at Latitud, and they're awesome. In terms of product team, we have the number eight employee at NewBank. You might've heard of NewBank, but it's this massive banking fintech in Latin America. And we have people from other fintechs. And then we have this guy who was a lead PM at Twilio, and I was explaining to them why we should be dogfooding. And they were all like, "Oh yeah, we should dogfood." It's just easy to forget stuff like that. So that was a mistake that we could have probably gotten to the growth that we got to with badges much earlier on. And not only did we get to growth with badges, but it became this amazing treasure trove of opportunity because once you have badges and people want them, you can now ask people to do anything. Go find friends, go buy things, whatever it is. And so we impacted almost all metrics across the company positively, including some we hadn't expected, but it's easy to talk about a mistake that ended up being a win. So that's why I compared it to the interview thing in the beginning. But we tried making Duolingo a social app really early on and failed. It was called Dual Duels. Dual Duels. You could duel.

**中文翻译:**
这在今天依然适用。昨天我还和 Latitud 的工程师们聊过。我还没解释我们造了什么，在哪里造。也许以后会聊到，但昨天我在 Latitud 聊天，他们很棒。在产品团队方面，我们有 Nubank 的第 8 号员工（你可能听说过 Nubank，它是拉美巨大的金融科技银行），还有来自其他金融科技公司的人，还有一个曾是 Twilio 的首席 PM。我向他们解释为什么我们要内部试用，他们都说：“噢对，我们应该内部试用。”这种事很容易被遗忘。所以，勋章功能带来的增长，我们本可以更早实现。勋章不仅带来了增长，还成了一个惊人的机会宝库：一旦你有了勋章且人们想要它们，你就可以要求用户做任何事——去找朋友、去买东西，无论什么。我们几乎正面影响了公司所有的指标，包括一些我们没预料到的。但谈论一个最终变成胜利的错误很容易，所以我一开始把它比作面试。其实我们很早就尝试把 Duolingo 做成社交应用，但失败了。它叫“Dual Duels”（双重对决），你可以进行对决。

---

### [00:56:42] Lenny

**English:**
Very clever.

**中文翻译:**
很有创意。

---

### [00:56:43] Gina Gotthilf

**English:**
Yeah, I know we were clever, but people didn't use it and we didn't figure out why. We tried making a Duolingo for schools platform. We couldn't get it to pick up. I went and watched dueling go in China and it got downloaded by a million people in the first day, and then the app got blocked because of the government, and then we couldn't figure out what to do. And then everyone rated the app like one star because it didn't work. And so then we had a lot of trouble actually recovering from that. We launched Duolingo in India and didn't realize because we couldn't have unless we went there, which we finally did, that most people set their phone UI in India to English, because typing in Hindi is hard. And of course there's a lot of languages throughout India, and we were making it so that when you downloaded Duolingo, whatever UI you open your app, your phone was set to, we offered not that language for you to learn. That was your base language. So we were telling people learn French, Spanish, German from English, and they were all trying to learn English, so they didn't find what they were looking for and they left. There were so many mistakes and luckily I think we were able to bounce back from most of them in terms of how Duolingo was doing today.

**中文翻译:**
是的，我知道我们很聪明，但人们就是不用，我们也没搞清楚为什么。我们还尝试做 Duolingo 校园版，但没做起来。我曾观察 Duolingo 在中国的表现，第一天就有 100 万人下载，然后应用因为政府原因被封了，我们不知道该怎么办。接着每个人都给应用打一星，因为它用不了。我们花了很多精力才从中恢复过来。我们在印度发布 Duolingo 时没意识到（除非我们亲自去那里，后来我们确实去了）：印度大多数人把手机界面设为英语，因为输入印地语很麻烦。印度有很多种语言，我们当时的设置是：当你下载 Duolingo 时，根据你手机系统的语言，我们提供“非该语言”的学习课程。所以我们是在告诉那些把手机设为英语的人“用英语学法语、西班牙语、德语”，而他们其实是想“学英语”。所以他们没找到想要的东西就离开了。我们犯了这么多错误，幸运的是，从 Duolingo 今天的表现来看，我们从大多数错误中恢复过来了。

---

### [00:57:53] Lenny

**English:**
And our final story is from Maggie Crowley VP of product at Toast, and one of the most beloved episodes of the podcast. This is Maggie sharing something a little bit different, her favorite interview question about failure and what it tells you about the person you're interviewing. Plus a story of her own product failure. Here's Maggie.

**中文翻译:**
我们的最后一个故事来自 Toast 的产品副总裁 Maggie Crowley，那是本播客最受喜爱的集数之一。Maggie 分享了一些略有不同的东西：她最喜欢的关于失败的面试问题，以及这个问题能告诉你关于应聘者的什么信息。此外，她还会分享一个她自己的产品失败故事。下面是 Maggie。

---

### [00:58:12] Maggie Crowley

**English:**
A question I ask in every product interview is, what's the worst product you've ever shipped? And that's because I don't think you're a good PM if you haven't shipped something that's really shitty. You just haven't had enough reps, you haven't done it enough times. And it's not only that you've done it, but that you can admit it and which one it is. That's so important. I remember... It was so dumb. I'm still so mad about this that we did this. I won't name which team, which company, I'm not going to call that out, but we decided we needed to do a rewrite red flag number one of existing product, and engineer who I'd worked with many times, we had a really good relationship and this person was like, "Yeah, yeah, it's going to take six months. No problem." Core part of the product, been around for forever. One of those things that the code is still the code written by the founders kind of thing.

**中文翻译:**
我在每一次产品面试中都会问的一个问题是：“你发布过的最烂的产品是什么？”这是因为我认为，如果你没发布过真正烂的东西，你就不是一个好的 PM。这意味着你的练习次数不够，做得不够多。而且不仅是你做过烂产品，更重要的是你能承认它，并指出是哪一个。这非常重要。我记得……那真的很蠢，我现在想起来还很生气。我不说是哪个团队、哪家公司了，但我们决定对现有产品进行“重写”（rewrite）——这是头号危险信号。一个和我合作过很多次、关系很好的工程师说：“没问题，六个月就能搞定。”那是产品的核心部分，已经存在很久了，代码还是创始人写的那种。

---

### [00:59:07] Maggie Crowley

**English:**
It didn't take six months. It took two and a half years. It still wasn't done. It almost never... It went on for so much longer than it should have. It took us forever to get to feature parody. It was the worst project. So many people rotated in and out of it. Everyone thought it was dumb. Sunk cost fallacy, just the worst. And it's because, A, we got arrogant and we thought we could do it. B, we skipped discovery. We didn't really write a one pager. We just went for it. We didn't do enough technical and design research into what the requirements would actually have to be. And there you have it.

**中文翻译:**
结果没用六个月，而是花了两年半，而且还没做完。它拖的时间比预想的长得多。我们花了无数时间才达到“功能对等”（feature parity）。那是史上最烂的项目。无数人进进出出，每个人都觉得它很蠢。沉没成本谬误，简直糟透了。原因在于：第一，我们太傲慢了，以为自己能行；第二，我们跳过了探索阶段（discovery），没写产品简述（one pager），就直接开干了。我们没有对实际需求进行足够的技术和设计研究。结果就是这样。

---

### [00:59:46] Lenny

**English:**
And did not work out, or was it a huge success in the end and it changed the trajectory of the business?

**中文翻译:**
那最后是没成，还是说最终大获成功并改变了业务轨迹？

---

### [00:59:50] Maggie Crowley

**English:**
Absolutely not. But you know what? I didn't get fired, so it's fine.

**中文翻译:**
绝对没有。但你知道吗？我没被开除，所以还好。

---

### [00:59:54] Lenny

**English:**
I feel like I've gone through those experiences and then three, four years later, it's like another... Maybe this rewrite and redesign may work. We haven't updated this thing in a long time.

**中文翻译:**
我觉得我也经历过这些。然后三四年后，又会有人说：“也许这次重写和重新设计能行，我们很久没更新这玩意了。”

---

### [01:00:04] Maggie Crowley

**English:**
Just don't do it. Don't rewrite. If anyone ever tells you to do a rewrite, don't do it. A side-by-side rewrite, nope.

**中文翻译:**
千万别做。别重写。如果有人叫你重写，别答应。那种“并排重写”（side-by-side rewrite），绝对不行。

---

### [01:00:11] Lenny

**English:**
Yeah, I've never had... What I run into is once you get too far down a redesign slash rewrite, everyone's building in that new world, and then you launch, and experiment's negative, and then it's just like, "Oh, we just got to launch it. We're going to call it back. We're going to figure out how to get back to neutral someday."

**中文翻译:**
是的，我从未见过……我遇到的是，一旦你在重新设计或重写的路上走得太远，每个人都在那个“新世界”里构建东西，然后你发布了，实验结果是负面的，然后大家就说：“噢，我们只能硬着头皮发布了，以后再想办法把它调回正轨吧。”

---

### [01:00:26] Maggie Crowley

**English:**
Yeah yeah. Don't do that.

**中文翻译:**
没错，千万别那样。

---

### [01:00:28] Lenny

**English:**
Good times. And that is a wrap. I hope you enjoy these stories of failure. I want to give a huge special thank you to all of our amazing guests for being vulnerable and sharing these stories of failure in their career. I hope you leave this episode with a new perspective on how setbacks and challenges and failure can often be exactly what you need to get to the next step of your career or your life. If you've got a great story to tell about failure, I'd love to hear it. Leave a comment either on YouTube or on Lennysnewsletter.com or just DM me on Twitter. Or you could reach out at LennyRachitzky.com and click the big contact button. Thank you for listening. Bye, everyone.

**中文翻译:**
美好的时光。到此结束。我希望你们喜欢这些关于失败的故事。我要特别感谢所有优秀的嘉宾，感谢他们展现出脆弱的一面，分享了职业生涯中的失败故事。我希望你在听完这一集后，能对挫折、挑战和失败有一个全新的视角——它们往往正是你通往职业生涯或生活下一个阶段所需要的东西。如果你有一个关于失败的好故事，我很想听听。请在 YouTube 或 Lennysnewsletter.com 上留言，或者在 Twitter 上私信我。你也可以访问 LennyRachitzky.com 并点击联系按钮。感谢收听。大家再见。