# Fareed Mosavat - 双语对照

# Lenny's Podcast: Fareed Mosavat Bilingual Transcript

---

### [00:00:00] Fareed Mosavat

**English:**
You can't do homework. You can't do exercises. You can't do fake stuff. You have to work on real products at real companies with real customers, with real data to get better at product management. So any kind of training, mentorship, reading, et cetera that you do is just a layer on top of that. The real acceleration happens from doing it and getting more reps. There are ways that I think great PMs use to go faster on this loop, but you still have to do the work. At the core is you have to actually execute and deliver great products, and you have to do it over, and over, and over again.

**中文翻译:**
你不能只做作业，不能只做练习，不能搞那些虚的东西。要提高产品管理能力，你必须在真实的公司里，面对真实的客户和真实的数据，去打磨真实的产品。所以，你所做的任何培训、导师指导、阅读等等，都只是锦上添花。真正的加速来自于实践和不断的“刷经验”（Reps）。我认为优秀的产品经理（PM）有办法在这个循环中跑得更快，但你仍然必须亲自动手。核心在于你必须真正去执行并交付优秀的产品，而且要一遍又一遍地重复这个过程。

---

### [00:00:40] Lenny

**English:**
Fareed Mosavat is the Chief Development Officer at Reforge where he's been for over two and a half years. Before that, he spent three and a half years at Slack leading a lot of their growth efforts, about a year at Instacart leading a number of their key growth analytics and product efforts. He's a GM at Zynga, he's VP of Product at Runkeeper, and something that I only learned during our chat is that he spent six years at Pixar doing character simulation, rigging, and building 3D animation tools. In our conversation, we focus on the journey of becoming a great PM, including crossing the canyon from IC to manager, the importance of expanding your scope, and how to create opportunities where you get more responsibility as a PM. Fareed is such an A-plus human full of so much insight, and I'm really excited for you to learn from him. With that, I bring you Fareed Mosavat.

**中文翻译:**
Fareed Mosavat 是 Reforge 的首席发展官（Chief Development Officer），他在那里工作了两年半多。在此之前，他在 Slack 工作了三年半，领导了大量的增长工作；在 Instacart 工作了大约一年，领导了多项关键的增长分析和产品工作。他曾是 Zynga 的总经理，Runkeeper 的产品副总裁。而且在我们的聊天中我才得知，他曾在皮克斯（Pixar）工作了六年，从事角色模拟、骨骼绑定（Rigging）以及构建 3D 动画工具。在今天的对话中，我们将重点讨论成为一名优秀 PM 的历程，包括如何跨越从个人贡献者（IC）到管理者的“大峡谷”、扩大工作范围的重要性，以及如何创造机会在 PM 职业生涯中承担更多责任。Fareed 是一位非常优秀、极具洞察力的人，我非常期待你们能从他身上学到东西。下面，让我们欢迎 Fareed Mosavat。

---

### [00:01:32] Lenny

**English:**
This episode is brought to you by Coda. Coda is an all-in-one doc that combines the best of documents, spreadsheets, and apps in one place. I actually use Coda every single day. It's my home base for organizing my newsletter writing. It's where I plan my content calendar, capture my research, and write the first drafts of each and every post. It's also where I curate my private knowledge repository for paid newsletter subscribers, and it's also how I manage the workflow for this very podcast.

**中文翻译:**
本期节目由 Coda 赞助。Coda 是一款多合一文档工具，它将文档、电子表格和应用程序的优点集于一身。实际上，我每天都在使用 Coda。它是我撰写时事通讯（Newsletter）的大本营。我在那里规划内容日历、记录研究资料，并撰写每一篇文章的初稿。它也是我为付费订阅者整理私人知识库的地方，我甚至用它来管理这个播客的工作流。

---

### [00:01:59] Lenny

**English:**
Over the years, I've seen Coda evolve from being a tool that makes teams more productive to one that also helps bring the best practices across the tech industry to life with an incredibly rich collection of templates and guides in the Coda Doc Gallery, including resources from many guests on this podcast, including Shreyas, Gokul, and Shishir, the CEO of Coda. Some of the best teams out there, like Pinterest, Spotify, Square, and Uber, use Coda to run effectively and have published their templates for anyone to use. If you're ping-ponging between lots of documents and spreadsheets, make your life better, and start using Coda. You can take advantage of a special limited-time offer just for startups. Head over to coda.io/lenny to sign up and get $1,000 credit on your first statement. That's C-O-D-A.io/lenny to sign up and get $1,000 in credit on your account.

**中文翻译:**
这些年来，我看到 Coda 从一个提高团队生产力的工具，进化成了一个通过 Coda Doc Gallery 提供极其丰富的模板和指南，将科技行业最佳实践变为现实的平台。这些资源包括本播客许多嘉宾的分享，如 Shreyas、Gokul 以及 Coda 的 CEO Shishir。Pinterest、Spotify、Square 和 Uber 等顶尖团队都在使用 Coda 高效运作，并发布了供所有人使用的模板。如果你还在大量的文档和表格之间来回切换，让你的生活轻松一点，开始使用 Coda 吧。现在针对初创公司有特别的限时优惠。前往 coda.io/lenny 注册，即可在首张账单中获得 1000 美元的抵扣额度。即 C-O-D-A.io/lenny，注册并获取 1000 美元账户额度。

---

### [00:02:59] Lenny

**English:**
I'm excited to chat with my friend, John Cutler, from podcast sponsor Amplitude. Hey, John.

**中文翻译:**
很高兴能与来自播客赞助商 Amplitude 的朋友 John Cutler 聊天。嘿，John。

---

### [00:03:03] John Cutler

**English:**
Hey, Lenny. Excited to be here.

**中文翻译:**
嘿，Lenny。很高兴来到这里。

---

### [00:03:05] Lenny

**English:**
John, give us a behind-the-scenes at Amplitude. When most people think of Amplitude, they think of product analytics, but now you're getting into experimentation and even just launched a CDP. What's the thought process there?

**中文翻译:**
John，给我们讲讲 Amplitude 的幕后故事吧。大多数人想到 Amplitude 时，首先想到的是产品分析，但现在你们开始涉足实验（Experimentation），甚至刚刚推出了 CDP（客户数据平台）。这背后的思考过程是怎样的？

---

### [00:03:16] John Cutler

**English:**
Well, we've always thought of Amplitude as being about supporting the full product loop. Think collect data, inform, vet, ship experiments, and learn. That's the heart of growth to us. So the big aha was seeing how many customers were using Amplitude to analyze experiments, use segments for outreach, and send data to other destinations. Experiment and CDP came out of listening to and observing our customers.

**中文翻译:**
嗯，我们一直认为 Amplitude 的核心是支持完整的产品循环。想想看：收集数据、提供信息、验证、发布实验并学习。对我们来说，这就是增长的核心。所以，当我们看到这么多客户使用 Amplitude 来分析实验、使用分群进行触达，并将数据发送到其他目的地时，我们有了重大的发现。实验功能和 CDP 的诞生正是源于对客户的倾听和观察。

---

### [00:03:37] Lenny

**English:**
Supporting growth and learning has always been Amplitude's core focus, right?

**中文翻译:**
支持增长和学习一直是 Amplitude 的核心关注点，对吧？

---

### [00:03:41] John Cutler

**English:**
Yeah. So Amplitude tries to meet customers where they are. We just launched starter templates and have a great scholarship program for startups. There's never been a more important time for growth.

**中文翻译:**
是的。Amplitude 努力满足客户当下的需求。我们刚刚推出了入门模板，并为初创公司提供了一项很棒的奖学金计划。对于增长来说，现在是前所未有的重要时刻。

---

### [00:03:50] Lenny

**English:**
Absolutely agree. Thanks for joining us, John, and head to amplitude.com to get started.

**中文翻译:**
完全同意。谢谢你的加入，John。听众朋友们可以前往 amplitude.com 开始使用。

---

### [00:03:58] Lenny

**English:**
Fareed, welcome to the podcast.

**中文翻译:**
Fareed，欢迎来到播客。

---

### [00:04:01] Fareed Mosavat

**English:**
Thanks for having me, Lenny. I'm super excited to be here.

**中文翻译:**
谢谢你的邀请，Lenny。我非常高兴能来到这里。

---

### [00:04:03] Lenny

**English:**
So to set a little context for listeners that aren't super familiar with you, can you give us just a 45-second overview of your career and all the wonderful things that you've done?

**中文翻译:**
为了给那些不太熟悉你的听众提供一些背景，你能用 45 秒的时间概括一下你的职业生涯和你所做的那些精彩的事情吗？

---

### [00:04:14] Fareed Mosavat

**English:**
Great. Hi. I'm Fareed Mosavat. I live in Berkeley, California with my wonderful wife and two children, but I've been a product leader across a variety of different companies over the course of my career. Today, I am the chief development officer at Reforge where I help run all of our content teams, parts of our operations, and our partnerships with wonderful experts like yourself.

**中文翻译:**
好的。大家好，我是 Fareed Mosavat。我和我优秀的妻子以及两个孩子住在加州伯克利。在我的职业生涯中，我曾在多家不同的公司担任产品负责人。目前，我是 Reforge 的首席发展官，负责管理我们所有的内容团队、部分运营工作，以及与像你这样优秀的专家建立合作伙伴关系。

---

### [00:04:33] Lenny

**English:**
Awesome. What about all the other things you've done?

**中文翻译:**
太棒了。那关于你做过的其他事情呢？

---

### [00:04:35] Fareed Mosavat

**English:**
So, previous to this, I spent almost four years as the director of product for a team called Lifecycle at Slack that is effectively a growth team. We're responsible for the self-service business at Slack all the way from first sign up, first team creation through to the first invites, activation, expansion, modernization, and even connecting the dots with our SMB sales team to help nurture some of those small self-service teams into larger commitments through our sales team.

**中文翻译:**
在此之前，我在 Slack 担任了近四年的产品总监，负责一个名为 Lifecycle 的团队，这实际上是一个增长团队。我们负责 Slack 的自助服务业务，涵盖了从首次注册、首次创建团队到首次邀请、激活、扩张、商业化（Modernization）的全过程。我们甚至还与中小企业（SMB）销售团队对接，帮助将一些小型自助服务团队转化为通过销售团队签约的大客户。

---

### [00:05:02] Fareed Mosavat

**English:**
I came to that through a variety of different growth and product leadership roles at a bunch of different startups on larger companies. I built one of the first growth teams at Instacart for about a year and a half in the middle of their acceleration. I was VP of Product at a company called Runkeeper before that in Boston, health and fitness tracking company. I was a general manager at Zynga. I got there through a startup that I was an engineer at, basically started as an engineer, ended as a head of product over the course of a couple of years, and then got acquired into Zynga, and actually started my career with almost seven years at Pixar Animation Studios working on visual effects, software tools, and other creative tech to try and solve problems for a bunch of wonderful films you've probably seen or your kids have seen.

**中文翻译:**
我是通过在多家初创公司和大型公司担任各种增长和产品领导职务走到这一步的。在 Instacart 业务加速发展的阶段，我花了大约一年半的时间建立了他们最早的增长团队之一。在那之前，我是波士顿一家名为 Runkeeper 的健康健身追踪公司的产品副总裁。我还曾是 Zynga 的总经理。我是通过一家我担任工程师的初创公司进入 Zynga 的——我在那家公司从工程师做起，几年后成为了产品负责人，随后公司被 Zynga 收购。而我的职业生涯实际上始于皮克斯动画工作室（Pixar），在那里的近七年时间里，我从事视觉特效、软件工具和其他创意技术工作，为许多你或你的孩子可能看过的精彩电影解决问题。

---

### [00:05:45] Lenny

**English:**
Please tell us the films that you worked at. I had no idea that you worked at Pixar.

**中文翻译:**
请告诉我们你参与过哪些电影。我完全不知道你曾在皮克斯工作过。

---

### [00:05:48] Fareed Mosavat

**English:**
I am credited on Finding Nemo, Cars, Wally, and Up.

**中文翻译:**
我的名字出现在《海底总动员》（Finding Nemo）、《赛车总动员》（Cars）、《机器人总动员》（Wall-E）和《飞屋环游记》（Up）的演职员名单中。

---

### [00:05:55] Lenny

**English:**
What? I did not know any of this.

**中文翻译:**
什么？我对此一无所知。

---

### [00:05:57] Fareed Mosavat

**English:**
Yeah. Yeah. Basically, I started there right out of college. I was super interested in computer graphics. I'd actually been an intern there, was very lucky to be interested in that in the moment where they were really accelerating the growth of the company going from like the whole company is working on one film to like, "Okay. We're trying to release a film every 18 months." So they really scaled up, and I had been studying computer graphics, and then I was an engineer focused on computer graphics and a little bit of research on that in college, was an intern there, and joined, and just got to see a fun growth period at that company, and really, I think in a lot of ways is the root of why I love doing product management because everything I worked on was at the intersections of interesting creative problems, interesting technical problems, and interesting storytelling problems.

**中文翻译:**
是的。基本上，我大学毕业后就去了那里。我对计算机图形学非常感兴趣。我曾在那里实习，非常幸运的是，当时公司正处于加速增长期，从全公司只做一部电影转变为“每 18 个月发布一部电影”。所以他们大规模扩张了。我大学时学习计算机图形学，是一名专注于此并做过一些相关研究的工程师。作为实习生加入后，我见证了那家公司有趣的成长期。我认为，在很多方面，这正是我热爱产品管理的根源，因为我所做的一切都处于有趣的创意问题、技术问题和叙事问题的交汇点。

---

### [00:06:45] Fareed Mosavat

**English:**
So, in a lot of ways, it was like... I think if I connect the dots backwards to the Steve Jobsism is the beginning of how I got interested in solving high-level strategic problems across a bunch of different people doing different kinds of work and maybe how I got relatively good at it. It was because even as an engineer, I was sitting in the middle of those pieces, but I got bored, which sounds crazy, and decided to jump into a startup that nobody had ever heard of that had eight employees in 2006, and the rest is history from there.

**中文翻译:**
所以，在很多方面，这就像……如果我用乔布斯的“串联生命中的点滴”（Connecting the dots）来回顾，那就是我开始对解决跨职能的高层战略问题产生兴趣的起点，也可能是我变得相对擅长此道的原因。因为即使作为一名工程师，我也处于这些环节的中心。但我后来觉得无聊了——这听起来很疯狂——于是决定在 2006 年跳槽到一家只有 8 名员工、没人听说过的初创公司，之后的事情大家都知道了。

---

### [00:07:17] Lenny

**English:**
Yeah. I wasn't planning to talk about Pixar, but I am so curious. One more question there. What's something that you learned from Pixar that has informed the way that you build products or think about product or your career?

**中文翻译:**
是的，我本来没打算聊皮克斯，但我太好奇了。再问一个问题：你在皮克斯学到了什么，影响了你构建产品的方式、对产品的思考或你的职业生涯？

---

### [00:07:28] Fareed Mosavat

**English:**
At the foundation of it is when I first got there, I thought what was important was modeling how things work in the real world. They're making things look right, so to speak. What I learned there is that actually, you're trying to deliver an end experience, and product, and story to your viewers, to your audience. It doesn't actually matter what's real. It matters what you see on the screen. It matters the emotion that it creates, the story that it creates, how it reinforces all of the other pieces. So the technical pieces were just a means to that end. So, of course, we used real physics and real math behind the scenes to do stuff, but if you had to box the numbers to make it look right, that's the right thing to do.

**中文翻译:**
最根本的一点是，当我刚到那里时，我认为重要的是模拟现实世界的运作方式，也就是让事物看起来“正确”。但我学到的是，实际上你是在向观众交付一种最终体验、产品和故事。现实中什么是真实的并不重要，重要的是你在屏幕上看到了什么。重要的是它创造的情感、它讲述的故事，以及它如何强化所有其他部分。所以技术部分只是实现目标的手段。当然，我们在幕后使用了真实的物理和数学，但如果你必须调整参数（Box the numbers）来让画面看起来“对味”，那才是正确的事。

---

### [00:08:15] Fareed Mosavat

**English:**
So I remember as I was working on early effects, bubbles, sand, so this kind of stuff, I was trying to do things the way it would really work, and then the camel would look at it, and almost the first lesson I learned there was like, "No. What matters is the end result, the end product, the end feeling." I feel like I go back to that a lot as I think about product development not just from an engineering and technical standpoint, but from what's in your strategy doc isn't that important. It's actually just an input into the end experience that you're trying to deliver for customers. When we're thinking about content development in our programs, it's not important that all of the principles fit perfectly together into this MEC framework. It matters that you help people solve actual problems. What's the end goal that you're looking for? I feel like that's the lesson that I just keep going back to for my time there.

**中文翻译:**
我记得当我处理早期的特效，比如气泡、沙子这类东西时，我试图按照现实运作的方式去做。然后导演（此处原文为 camel，疑似口误，应指导演或主管）看了看，我学到的第一课就是：“不，重要的是最终结果、最终产品和最终感受。”在思考产品开发时，我经常回想起这一点。不仅是从工程和技术角度，甚至战略文档里的内容也没那么重要。它实际上只是你试图为客户提供的最终体验的一个输入。当我们思考课程中的内容开发时，所有原则是否完美符合某个框架并不重要，重要的是你帮助人们解决了实际问题。你追求的最终目标是什么？我觉得这就是我在皮克斯学到的、并且一直受用的教训。

---

### [00:09:06] Lenny

**English:**
It's a great segue to Reforge, which I want to spend a little bit of time on. Folks that listen to this podcast know that I'm a huge fan, and we have a lot of Reforge alumni on this podcast.

**中文翻译:**
这很好地过渡到了 Reforge，我想花点时间聊聊它。听这个播客的人都知道我是 Reforge 的超级粉丝，而且我们播客请过很多 Reforge 的校友。

---

### [00:09:15] Fareed Mosavat

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:09:16] Lenny

**English:**
So a couple questions there. One, you said you're a chief development officer. Is that your title?

**中文翻译:**
我有几个问题。第一，你说你是首席发展官。这是你的正式头衔吗？

---

### [00:09:20] Fareed Mosavat

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:09:21] Lenny

**English:**
What is it that you do as a chief development officer?

**中文翻译:**
首席发展官具体是做什么的？

---

### [00:09:23] Fareed Mosavat

**English:**
It's funny because in a lot of ways, it's not a made-up title, but trying to figure out how a role that I ended up sliding into as I grew my engagement with the company, how do we describe what it is? So I think what's unique about Reforge versus a traditional software startup, or a SaaS company, or all the other things you see is that we're not just a software company. Of course, we have a website. Go to it. You see things, you deliberate, but we also build a lot of stuff and experiences that fit into that. We build content. We build programs today. We're going to build all kinds of other content. We have live cohort experiences that are designed and thoughtful, and we build and try to make, solve certain customer problems.

**中文翻译:**
这很有趣，因为在很多方面，这并不是一个凭空捏造的头衔，但随着我对公司参与度的加深，我逐渐进入了这个角色，我们需要描述它到底是什么。我认为 Reforge 与传统的软件初创公司或 SaaS 公司不同之处在于，我们不仅仅是一家软件公司。当然，我们有网站，你可以访问、查看内容、进行思考，但我们也构建了很多与之配套的内容和体验。我们构建内容，构建课程。未来我们还会构建各种其他内容。我们有精心设计的直播训练营（Live cohort）体验，我们通过构建这些东西来解决特定的客户问题。

---

### [00:10:38] Fareed Mosavat

**English:**
We have a member slack that we try to design to solve certain problems. We have the people like yourself and a lot of the guests that you've had on the podcast like Elena, or Adam Fishman, or Casey who plugged into our system to help us build all of those things because at the end of the day, our job is to help unlock the expertise that's locked in the heads of the greatest operators in the world. So who do we work with? How do we develop that content? How do we make their ideas shine? How do we solve real member problems? How do we help people do work?

**中文翻译:**
我们有一个会员 Slack 社区，旨在解决特定问题。我们有像你这样的人，以及你播客上的许多嘉宾，比如 Elena、Adam Fishman 或 Casey，他们加入我们的系统，帮助我们构建所有这些东西。因为归根结底，我们的工作是帮助释放锁在世界上最优秀的运营者脑海中的专业知识。我们与谁合作？如何开发内容？如何让他们的想法发光发亮？如何解决会员的实际问题？如何帮助人们开展工作？

---

### [00:10:38] Fareed Mosavat

**English:**
A lot of that is a product experience that in some ways, like a Pixar movie, there's the technical aspects and the UX aspects, but there's also all of the content, and the partners that we work with, and those pieces. I own all of that piece, like the production, content, the new product experiences, and all of the pieces that fit in there. So we have a team of really talented, amazing people that work on these things, and I lead those teams.

**中文翻译:**
这在很大程度上是一种产品体验，在某些方面就像皮克斯电影：既有技术层面和用户体验（UX）层面，也有所有的内容、合作伙伴以及这些环节的整合。我负责所有这些部分，比如制作、内容、新产品体验以及所有相关的环节。我们有一支由非常有才华、了不起的人组成的团队在做这些事，我负责领导这些团队。

---

### [00:11:02] Lenny

**English:**
It's interesting how that comes back to your Pixar experience of the combination of intersection of art and technology.

**中文翻译:**
很有趣，这又绕回了你在皮克斯关于艺术与技术交汇的经验。

---

### [00:11:09] Fareed Mosavat

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:11:09] Lenny

**English:**
That's so interesting. Okay. Never thought about it that way. Yeah.

**中文翻译:**
太有意思了。好吧，我从没往这方面想过。

---

### [00:11:12] Fareed Mosavat

**English:**
Like we said, it's easier to connect the dots in reverse than moving forward. I have always been not that precious about titles, career roles, et cetera. I've really found myself drawn to, "Is this an interesting problem that I believe I can bring something valuable to the table? Can I help solve this in some meaningful way, and will I learn something great and new from this role?" At every step, I made those decisions. I've gone up and down the title stack from VP down to ICPM, from engineer to product, from product to this new thing and content. In every single one, I think it's a lot about, "What are you bringing to the table to help solve that problem? What are you taking away from the job and learning from it, and how do you turn that into the next step?"

**中文翻译:**
正如我们所说，向后连接点滴比向前看要容易。我一直不太看重头衔、职业角色之类的。我发现自己真正被吸引的是：“这是一个有趣的问题吗？我相信我能为此贡献价值吗？我能以某种有意义的方式帮助解决它吗？我能从这个角色中学到伟大的新东西吗？”在每一步，我都做出了这样的决定。我的头衔在职级体系中上下浮动，从副总裁到个人贡献者 PM，从工程师到产品，从产品到这个内容领域的新角色。在每一个角色中，我认为关键在于：“你带来了什么来帮助解决问题？你从这份工作中带走了什么、学到了什么，以及你如何将其转化为下一步？”

---

### [00:11:57] Lenny

**English:**
Awesome, and we're going to chat about a lot of those learnings from your experience going through these career journeys, but one last question on Reforge. Just like how big is Reforge at this point? How many cohorts? How many students? How many people work there? What's the operation scale at this point?

**中文翻译:**
太棒了，我们将聊聊你从这些职业旅程中学到的很多东西。关于 Reforge 最后一个问题：Reforge 现在规模有多大？有多少期课程？多少学生？有多少员工？目前的运营规模是怎样的？

---

### [00:12:11] Fareed Mosavat

**English:**
It's hard to count how many employees because it's growing so fast. I believe we are at just around 150 total employees across the whole company right now.

**中文翻译:**
很难计算有多少员工，因为增长太快了。我相信目前全公司大约有 150 名员工。

---

### [00:12:19] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:12:20] Fareed Mosavat

**English:**
That doesn't include our executives and residents, subject matter experts, and the partners we work with. That's full-time employees working on the business. Of course, we have a large product development, product design, engineering, and data teams, but also the teams that I run. We call them strategy leads, content producers, content strategists, content designers, building all of that content as well as our partners team and operations team. So it's a relatively large company at this point. When I first started working with it, it was a scrappy operation of just a handful of folks, but we've grown quite a bit of over the last year.

**中文翻译:**
这还不包括我们的驻校高管（EIR）、领域专家和合作伙伴。这只是负责业务的专职员工。当然，我们有庞大的产品开发、产品设计、工程和数据团队，还有我领导的团队。我们称他们为战略负责人、内容制作人、内容战略家、内容设计师，他们负责构建所有内容，此外还有合作伙伴团队和运营团队。所以目前这是一家规模相对较大的公司。当我刚开始参与时，它还是一个只有几个人的草根作坊，但过去一年我们增长了很多。

---

### [00:12:51] Fareed Mosavat

**English:**
With that, we support, I believe, now 19 total cohort-based programs across product, engineering, marketing, and growth-related topics as well as a bunch of new experiences that we're working on for the coming future here in the next year. We have well over 10,000 active members on the platform, about a dozen executives and residents that work to help us deliver those programs, and hundreds of partners. We call them experts and operators in the space who contribute to our programs in different ways either as guests or as mentors, or helping us develop content behind the scenes.

**中文翻译:**
目前，我们支持总共 19 个基于社群的课程，涵盖产品、工程、营销和增长相关主题，以及我们正在为明年开发的一系列新体验。平台上拥有超过 10,000 名活跃会员，大约有十几位驻校高管协助交付这些课程，还有数百名合作伙伴。我们称他们为该领域的专家和运营者，他们以嘉宾、导师或幕后内容开发者的身份，以不同方式为我们的课程做出贡献。

---

### [00:13:25] Lenny

**English:**
Awesome, and I taught a couple guest lectures this past cohort. I think my second ever lesson was with you. You were the teacher?

**中文翻译:**
太棒了，我在上一期也讲了几次客座课。我想我人生中第二次讲课就是和你一起。你是当时的老师？

---

### [00:13:32] Fareed Mosavat

**English:**
Yes. Yeah. We talked about instant buy, I think they're called, but I can't remember the name.

**中文翻译:**
是的。我们聊了“即时购买”（Instant buy），我想是这么叫的，但我记不清名字了。

---

### [00:13:37] Lenny

**English:**
Instant book. Close, close.

**中文翻译:**
是“即时预订”（Instant book）。很接近了。

---

### [00:13:38] Fareed Mosavat

**English:**
Instant book, sorry.

**中文翻译:**
即时预订，抱歉。

---

### [00:13:38] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:13:38] Fareed Mosavat

**English:**
On the Reforge platform for experimentation and testing program, which was, yeah, actually, also my first program that I helped lead at Reforge, and I think you were my first guest.

**中文翻译:**
那是 Reforge 平台上的实验与测试课程。实际上，那也是我在 Reforge 领导的第一个课程，我想你是我请的第一位嘉宾。

---

### [00:13:47] Lenny

**English:**
Oh my god.

**中文翻译:**
天哪。

---

### [00:13:47] Fareed Mosavat

**English:**
So, thanks. Thanks for not making me look bad.

**中文翻译:**
所以，谢谢你。谢谢你没让我出丑。

---

### [00:13:51] Lenny

**English:**
Thank you. So what's cool about your background working at Reforge and all the companies you worked at is that you've seen a lot of PM careers go well and PM careers go not so well. So what I want to spend our time on is talking through just the career development journey for product managers and in particular, the challenges that PMs face trying to become better PMs and just why it's innately tricky to become better as a product manager. It's such a weird job to get better at. So my first question is actually, why is it so hard to become better as a PM? Why is it innately a tricky thing to develop as a PM?

**中文翻译:**
谢谢。你在 Reforge 以及之前那么多公司工作的背景很酷的一点是，你见过很多 PM 职业生涯一帆风顺，也见过很多 PM 举步维艰。所以我想花点时间聊聊产品经理的职业发展历程，特别是 PM 在努力变得更优秀时面临的挑战，以及为什么提高产品管理能力本质上是一件很棘手的事情。这真的是一份很难提升的“奇怪”工作。所以我的第一个问题是：为什么 PM 变得更优秀这么难？为什么作为 PM 的成长天生就这么复杂？

---

### [00:14:28] Fareed Mosavat

**English:**
One of the trickiest bits about it is that there's no clear, obvious pre-training you can do that gives you a baseline set of understanding that you can use to be a product manager. People come from MBAs, people come from certain kinds of majors in college, et cetera, but it's not engineering where like, "Okay. With a couple of weeks of bootcamp or a couple of years of a computer science education, I have some foundational knowledge that helps me go from zero to one in my first job." Not only does it help me break in because I have a credential that helps me land that job, and we can talk about why landing your first PM job is so hard, but also, there's not a lot of stuff that one-to-one directly correlates to the work you're going do on a day-to-day basis.

**中文翻译:**
最棘手的一点是，没有一种清晰、明显的“预训练”能给你一套基础理解，让你直接上手做 PM。人们来自 MBA，来自大学的各种专业等等，但它不像工程领域——在工程领域，通过几周的训练营或几年的计算机科学教育，你就拥有了一些基础知识，能帮你完成第一份工作的从 0 到 1。这不仅能帮你入行（因为你有证书帮你拿到工作，我们可以再聊聊为什么拿到第一份 PM 工作这么难），而且现实中也没有太多东西能与你的日常工作一一对应。

---

### [00:15:11] Fareed Mosavat

**English:**
I think there's an idea that Naval Ravikant talked about on Twitter and in blog posts a long time ago, this concept of specific knowledge that can only be gathered by actually doing the work. A lot of product management, really, is like that. You get better by doing it, and so you start in the same place, if that makes sense. Of course, there are different skills and intellectual capacities, et cetera that help different people be more successful at it, but at the end of the day, you don't know if a PM is going to be great until they start doing that work. So I think that's one of the pieces that's very hard.

**中文翻译:**
Naval Ravikant 很久以前在 Twitter 和博客中谈到一个观点，即“特定知识”（Specific knowledge）的概念，这种知识只能通过实际操作来获得。产品管理的很大一部分确实就是这样。你通过实践变得更好，所以大家起步时都在同一个地方。当然，不同的技能和智力水平等会帮助不同的人取得成功，但归根结底，在 PM 开始实际工作之前，你无法判断他是否会变得优秀。我认为这是非常困难的一点。

---

### [00:15:41] Fareed Mosavat

**English:**
The second is the thing I just alluded to, which is breaking in and getting your first role. It's just a very difficult situation for a lot of companies, and there are a couple of different paths to it, but none of them are straightforward. There's no clear linear path, except for maybe being a Stanford or Harvard grad, top-tier school grad, NCS with an internship, goes to Google to do an APM program. There are a couple of these things that are surefire, but I don't think they guarantee success, and they are actually very limited in terms of the number of people that they let into the business.

**中文翻译:**
第二点是我刚才提到的，即入行并获得第一个角色。对很多公司来说，这都是一个非常困难的情况。虽然有几种不同的路径，但没有一种是直截了当的。没有清晰的线性路径，除非你是斯坦福或哈佛等顶尖名校毕业，计算机专业，有过实习经历，然后去 Google 参加 APM（助理产品经理）项目。虽然有几种“稳操胜券”的路径，但我认为它们并不保证成功，而且这些路径招收的人数其实非常有限。

---

### [00:16:13] Fareed Mosavat

**English:**
So I think this is what makes it so hard is that there's not any upfront training you can really do to prepare yourself or even knock down the door to break in. But then, also, it's not clear there's a lot of training within a company that would help you be successful generally on the job of product management. You can learn how to be a good PM at Google, you can learn to be a good PM at Facebook, but it is up to each individual PM to figure out how to generalize what they're doing to move from different kinds of product across different kinds of product work as they get more senior to solve bigger problems, et cetera.

**中文翻译:**
所以我觉得这就是难点所在：没有真正的前置培训能让你做好准备，甚至连敲开入行大门的培训都没有。而且，公司内部也不一定有大量的培训能帮你成为一名通用的、成功的 PM。你可以在 Google 学会做一个好的 PM，在 Facebook 学会做一个好的 PM，但随着职级的提升，每个 PM 都必须学会如何将自己的所作所为“通用化”（Generalize），以便在不同类型的产品和工作中切换，从而解决更大的问题。

---

### [00:16:51] Fareed Mosavat

**English:**
So what we tried to do at Reforge is we are focused on helping people accelerate that learning loop. It's not, "Hey, if you take this class, now you're qualified to be a PM." It's not really like that. I don't know if that's possible. I hope it will be someday, but it is very difficult. I think it's more, "Hey, we want to help you when you encounter certain kinds of problems, not have to solve them from first principles, but following the footsteps of the people who have done great work in the past, generalize those lessons." But at the end of the day, you still have to get down and do the work.

**中文翻译:**
所以我们在 Reforge 尝试做的是，专注于帮助人们加速那个学习循环。这并不是说“嘿，如果你上了这门课，你就有资格当 PM 了”。事实并非如此。我不知道这是否可能，我希望有一天可以，但这非常困难。我认为更多的是：“嘿，我们想在你遇到某些问题时提供帮助，让你不必从第一性原理开始摸索，而是跟随过去做出卓越工作的人的脚步，总结那些经验教训。”但归根结底，你仍然必须亲自下场去做。

---

### [00:17:25] Fareed Mosavat

**English:**
You can't do homework, you can't do exercises, you can't do fake stuff. You have to work on real products at real companies with real customers, with real data to get better at product management. So any kind of training, mentorship, reading, et cetera that you do is just a layer on top of that. The real acceleration happens from doing it and getting more reps. There are ways that I think great PMs use to go faster on this loop, but you still have to do the work. At the core is you have to actually execute and deliver great products, and you have to do it over, and over, and over again.

**中文翻译:**
你不能只做作业，不能只做练习，不能搞虚假的东西。要提高产品管理能力，你必须在真实的公司里，面对真实的客户和真实的数据，去打磨真实的产品。所以，你所做的任何培训、导师指导、阅读等，都只是在此基础上的点缀。真正的加速来自于实践和不断的重复。我认为优秀 PM 有办法在这个循环中跑得更快，但你仍然必须亲自动手。核心在于你必须真正去执行并交付优秀的产品，而且要一遍又一遍地重复。

---

### [00:18:03] Lenny

**English:**
Yes. Let's absolutely dig into that. Let me put out a couple mental models that I'm thinking as you're talking. One is just if you think about a pie chart of a great PM's career and/or investments they make along their career journey, how do you break up that pie chart? Like some percentage is doing the work, some percentage is courses, maybe some percentage is books. So just putting that out there in case that's useful to think about, and then the other is thinking about the trajectory of a PM on a line chart, and what are these inflection points that you've seen most impact the career trajectory of a PM?

**中文翻译:**
是的。让我们深入探讨一下。当你说话时，我脑子里浮现了几个思维模型。一个是，如果你把一个优秀 PM 的职业生涯或他们在职业旅程中的投入看作一个饼图，你会如何划分这个饼图？比如百分之多少是实际工作，百分之多少是课程，百分之多少是书籍。我抛出这个想法，看是否对思考有帮助。另一个是把 PM 的轨迹看作折线图，你认为哪些转折点（Inflection points）对 PM 的职业轨迹影响最大？

---

### [00:18:34] Fareed Mosavat

**English:**
So let's start at the first one, the pie chart idea. What percent is spent on different things? Unsurprisingly because Reforge is all about growth loops, I think of this in terms of a loop actually, which is like, "What is that learning or career acceleration, or ability acceleration loop? At the core, again, at the top of the loop is execution. You have to have a real problem. You're working on with real customers that you want to solve in some way. So, you're executing. You're delivering. You're learning at the beginning. It's all about execution. So we'll start with the pie chart at the beginning. It's almost all execution.

**中文翻译:**
让我们从第一个饼图的想法开始。不同事情的占比是多少？不出所料，因为 Reforge 的核心就是增长循环（Growth loops），我实际上是把这看作一个循环，即“学习、职业加速或能力加速循环”。核心在于，循环的顶端是执行。你必须有一个真实的问题，面对真实的客户，并试图以某种方式解决它。所以，你在执行，在交付。在起步阶段，一切都关乎执行。所以饼图的开始，几乎全是执行。

---

### [00:19:06] Fareed Mosavat

**English:**
What are the problems you give a junior or brand new PM? Known problem, known solution. "Please work with engineering and design to deliver that thing on time, and then tell us what happened." So it's like a very tightly constrained problem. As you level up, then some of these things become more unknowns. So there's execution, but I think the next step that great product managers do is they think about how to generalize that execution a little bit. So it's not just, "Okay. Now, I know what the best settings page for Slack is." It's, "What generalizations did you make? What are the things that you can take that are applicable to other stuff?"

**中文翻译:**
你会给初级或新入行的 PM 什么样的问题？已知的问题，已知的解决方案。“请与工程和设计团队合作，按时交付那个东西，然后告诉我们结果。”这就像是一个受到严格限制的问题。随着你职级的提升，其中一些事情会变得更加未知。所以除了执行，我认为优秀 PM 的下一步是思考如何将这种执行稍微“通用化”。所以这不仅仅是“好吧，现在我知道 Slack 最好的设置页面是什么样的了”，而是“你总结出了什么通用的规律？有哪些东西是可以应用到其他地方的？”

---

### [00:19:49] Fareed Mosavat

**English:**
Some of that is execution-oriented, how to best work with engineers, how to iterate on designs, what customers do and don't do, rules of thumb, those kinds of things. I think that's where reading courses, et cetera can help because sometimes by bringing other... or one-on-one conversations with experts, et cetera. There are a whole bunch of different ways, but is that the generalization step? "Hey, I did this thing. Oh, other people have done something similar. How do I connect the dots on that? How do I make this experience bigger than what I've just done and lead me to help solve other problems?"

**中文翻译:**
其中一些是面向执行的：如何最好地与工程师合作，如何迭代设计，客户会做什么、不会做什么，经验法则等等。我认为这就是阅读、课程等可以提供帮助的地方，因为有时通过引入其他人的经验……或者与专家进行一对一对话。有很多不同的方式，但这就是“通用化”的一步吗？“嘿，我做了这件事。哦，其他人也做过类似的事。我该如何把这些点连接起来？我该如何让这次经验超越我刚刚完成的工作，并引导我解决其他问题？”

---

### [00:20:23] Lenny

**English:**
These are things you're doing in your head, basically. You're just developing frameworks, mental models, things that you're just taking with you to the next project in your mind.

**中文翻译:**
这些基本上是你脑子里在做的事情。你只是在构建框架、思维模型，这些是你带到下一个项目中的东西。

---

### [00:20:31] Fareed Mosavat

**English:**
Exactly. To use an example, there was a time at Instacart where we were working on onboarding, brand new onboarding and activation flow for customers. We tried a lot of different stuff. We tried the slimmest, fastest, lowest friction, least number of steps path in, and then we had this hypothesis about helping people get set up. So we took the opposite approach, which was a really long onboarding with a bunch of different steps and wanted to see, "Was that more effective or less effective?"

**中文翻译:**
没错。举个例子，在 Instacart 时，我们曾负责新客户的入职（Onboarding）和激活流程。我们尝试了很多不同的方案。我们尝试了最精简、最快、摩擦力最低、步骤最少的路径。然后我们有一个关于“帮助人们完成设置”的假设。于是我们采取了相反的方法，即一个包含许多不同步骤的超长入职流程，想看看它是更有效还是更无效。

---

### [00:20:59] Fareed Mosavat

**English:**
The generalization is, "Oh, for products that had a high bar to activation, sometimes more set up and higher friction, good friction could actually help those customers be successful. There are other kinds of products that are high-intent where they know what they need to do to have simple actions where lowering friction might be the right thing." So, that's a generalization. It's a generalization of, "Oh, I learned a thing." It's a hypothesis about how that might generalize other kinds of products or other kinds of problems that you approach. I think some of that can come from seeing it from the outside, listening to a podcast, hearing you say it, taking a course, et cetera. But at the end of the day, you have to experience it to see how it applies to the world.

**中文翻译:**
总结出来的通用规律是：“哦，对于激活门槛较高的产品，有时更多的设置和更高的摩擦力（好的摩擦力）实际上可以帮助客户获得成功。而对于其他高意向、用户知道自己需要做什么、操作简单的产品，降低摩擦力可能是正确的选择。”这就是一种通用化。这是一种“哦，我学到了一点东西”的总结。这是一个关于如何将其推广到其他类型产品或问题的假设。我认为其中一些可以来自外部观察、听播客、听你讲解、上课等等。但归根结底，你必须亲自经历，才能看到它如何应用于现实世界。

---

### [00:21:42] Fareed Mosavat

**English:**
Then, the next bit is communication, and I think this is a bit that a lot of product managers, obviously, and any job miss, but you can't just do the work. You have to actually communicate the work. You have to talk about what you're doing, what you've generalized, what you've learned so that you can hit the next step, which is scale your opportunities. Go from smaller known problem, known solution to maybe known problem, unknown solution type of work, which is the next step.

**中文翻译:**
接下来的部分是沟通。我认为这是很多 PM（显然也包括其他职位）会忽略的一点：你不能只埋头苦干。你必须实际地沟通你的工作。你必须谈论你在做什么、你总结了什么、你学到了什么，这样你才能进入下一步，即“扩大你的机会规模”。从较小的“已知问题、已知方案”转向“已知问题、未知方案”类型的工作，这是下一步。

---

### [00:22:08] Fareed Mosavat

**English:**
Then, eventually, to where you want to be as a senior, great, high-level individual contributor PM to the not quite known problem, maybe a goal with a set of problems and unknown solutions, unknown problems, unknown solutions, where you're actually identifying customer problems and moving towards on that. So scaling up your opportunity, and then executing again. I think of this as a loop of learning, and so of course, the percentages change over time as you move more senior in your career, but also, depending on where you're at in the step that the percentages change.

**中文翻译:**
最终，达到你作为一名资深、优秀、高阶个人贡献者 PM 的目标：面对不太明确的问题，可能是一个目标伴随着一系列问题和未知的解决方案，甚至是未知的问题和未知的解决方案，你需要实际去识别客户问题并推进解决。这就是扩大你的机会规模，然后再次执行。我把这看作一个学习循环，当然，随着你职业生涯的晋升，各部分的比例会发生变化，而且取决于你处于循环的哪一步，比例也会有所不同。

---

### [00:22:40] Lenny

**English:**
Got it. So, just to recap, execute, just do the work, just ship. Generalize learnings from shipping to build up your gut feeling of what will work and not work. Learn to communicate things you're doing, and then scale the things that you're executing based on this gut feeling you're building, and communicate that out, and just continue. Do you think scaling take on more scope or have more impact? Is that how you think about scaling, that last piece?

**中文翻译:**
明白了。简单总结一下：执行，就是干活，就是上线。从上线中总结经验，建立起对“什么行得通、什么行不通”的直觉。学会沟通你正在做的事情，然后基于你建立的直觉去扩大你执行的事情的规模，并将其沟通出去，如此循环。你认为“规模化”是指承担更多的职责范围（Scope）还是产生更大的影响力（Impact）？这就是你对最后一步“规模化”的理解吗？

---

### [00:23:06] Fareed Mosavat

**English:**
Yeah. I think it's one moving from knowns to unknowns. So like you're being given a hairier, harder to untangle types of problems with more unknowns and more autonomy. I think the second is, yeah, of course, with... although I think for the beginning of your career, you tend to go deeper. So it's like, "Okay. I'm going to work on growth, let's say, or core product, or zero-to-one products, or technical scaling, whatever it is. I'm going to go deeper on that," and then over time, that turns into width, but this is why the generalization step is important.

**中文翻译:**
是的。我认为首先是从已知转向未知。也就是说，你被赋予了更棘手、更难理清的问题，其中包含更多的未知因素和更大的自主权。其次，当然是……虽然我认为在职业生涯初期，你倾向于往深处走。比如，“好吧，我要专注于增长，或者核心产品，或者从 0 到 1 的产品，或者技术扩容，不管是什么，我要钻研得更深。”随着时间的推移，这会转化为广度，但这就是为什么“通用化”这一步很重要的原因。

---

### [00:23:39] Fareed Mosavat

**English:**
If you want to be a product leader, you cannot be seen solely as a specialist in that certain kind of product work, and so the generalization step is really important. If you want to move from growth to core product, you need to show that you're not just running experiments and driving numbers up. You need to show and communicate that you're learning deeper lessons about how customer psychology works, and what products people resonate with, and how to think about the business more holistically, and then communication. No one knows what you're thinking if you don't tell them. So if you don't communicate, you don't have control over those scaled opportunities. Usually, your manager, or the organization, or the company does. Maybe by switching jobs, you have some control, but you need to earn that right. You need to communicate. That's why I think there's pieces of the loop you can control and pieces that are externalized.

**中文翻译:**
如果你想成为一名产品领导者，你不能仅仅被看作是某种特定产品工作的专家，所以通用化步骤非常重要。如果你想从增长转向核心产品，你需要证明你不仅仅是在做实验和拉升数据。你需要展示并沟通你正在学习关于客户心理运作方式、什么样的产品能引起人们共鸣、以及如何更全面地思考业务的更深层教训。然后是沟通。如果你不告诉别人，没人知道你在想什么。所以如果你不沟通，你就无法掌控那些扩大规模的机会。通常，你的经理、组织或公司掌握着这些机会。也许通过跳槽你可以获得一些控制权，但你需要赢得那个权利。你需要沟通。这就是为什么我认为这个循环中有些部分是你可以控制的，有些部分是外部化的。

---

### [00:24:25] Lenny

**English:**
I'm curious, in your own career, what the biggest inflections of growth have been either in terms of learning, or impact, or just opportunity?

**中文翻译:**
我很好奇，在你自己的职业生涯中，无论是在学习、影响力还是机会方面，最大的增长转折点是什么？

---

### [00:24:33] Fareed Mosavat

**English:**
The first big one was when I switched from being an engineer to being a product... I didn't even know it was product management, but a product leader of some kind. I think there are two things that happen. One is you got to be doing this stuff, but often, somebody needs to see it. The scale opportunity piece of the step often requires someone from outside to notice that you're doing something really well and trust you with a bigger opportunity. I think of this as sponsorship, not mentorship. I don't necessarily find that in my career. I've had a lot of managers where I'm like, "Wow, their day-to-day help was super awesome at helping me be a better leader."

**中文翻译:**
第一个重大转折点是我从工程师转变为产品……当时我甚至不知道那是产品管理，但就是某种产品负责人。我认为发生了两件事。第一，你必须在做这些事，但通常需要有人看到。扩大机会这一步通常需要外部的人注意到你做得非常好，并信任你，给你更大的机会。我把这看作是“提拔”（Sponsorship），而不是“指导”（Mentorship）。在我的职业生涯中，我不一定总能遇到这种。我有很多经理，我觉得“哇，他们的日常帮助对让我成为更好的领导者非常有帮助”。

---

### [00:25:10] Fareed Mosavat

**English:**
I hope that I've been that for some people, but I don't have a ton of examples of that in my career. But what I do have is a couple examples of people who deeply trusted me to solve big problems, and I don't know. I'm lucky to have had that or otherwise, but one was a CEO of that startup who's now a venture capitalist. His name is Nabeel Hyatt. I was like, "Hey, you seem to understand the data better than anybody here. You're solving these problems. Help us figure out what we're going to do next," which now we call product management.

**中文翻译:**
我希望我也曾为某些人提供过这样的帮助，但在我的职业生涯中，这样的例子并不多。但我确实有几个例子，是那些深切信任我、让我去解决大问题的人。我不知道，我很幸运能拥有这些。其中一位是那家初创公司的 CEO，他现在是一名风险投资家，叫 Nabeel Hyatt。他当时对我说：“嘿，你似乎比这里的任何人都更了解数据。你在解决这些问题。帮我们弄清楚下一步该做什么。”这也就是我们现在所说的产品管理。

---

### [00:25:36] Lenny

**English:**
But he was at, by the way?

**中文翻译:**
顺便问一下，他当时在哪家公司？

---

### [00:25:38] Fareed Mosavat

**English:**
it was called Conduit Labs.

**中文翻译:**
那家公司叫 Conduit Labs。

---

### [00:25:39] Lenny

**English:**
Okay. Yeah.

**中文翻译:**
好的。

---

### [00:25:39] Fareed Mosavat

**English:**
It's a game company. Then, eventually, I was the director of product for our Boston studio. The next was at Slack. I was an ICPM working on activation and growth on a team of three or four other PMs, and there were a couple of moments where by communicating my work and talking through how I was solving problems, people noticed that I knew what I was doing and gave me bigger and bigger opportunities. One of those was Merci Grace, who I think has been on your pod and was a wonderful sponsor for me. Then, again, when Merci left, April Underwood, who's the CPO, said, "It seems like you have a handle on this. I'd like you to take on a bigger range of problems across all of this growth and not just the modernization piece that I've been working on before." So I think in each of those steps it's about creating trust and knowing that you have a sponsor there, someone who's going to go to bat for you.

**中文翻译:**
那是一家游戏公司。后来，我成为了我们波士顿工作室的产品总监。下一个转折点是在 Slack。当时我是一名个人贡献者 PM，在一个由三四名 PM 组成的团队中负责激活和增长。有几次，通过沟通我的工作并详细讲解我是如何解决问题的，人们注意到我确实很专业，并给了我越来越大的机会。其中一位是 Merci Grace，我想她上过你的播客，她是我的一位非常棒的提拔者。后来，当 Merci 离开时，CPO April Underwood 说：“看来你对这块很在行。我希望你能承担起整个增长领域更广泛的问题，而不仅仅是我之前负责的商业化部分。”所以我觉得在每一步中，关键都在于建立信任，并知道你有一个提拔者，一个愿意为你撑腰的人。

---

### [00:26:25] Lenny

**English:**
I really love this point of sponsorship. We haven't talked a lot about this on the podcast. There's a lot of talk of finding a coach or having a manager that teaches you how to do the job, but this idea of just getting to a place where someone gives you an opportunity to shine, and that's been really big in my career just like certain managers just, "Here, Lenny. You take this, and let's see what you can do."

**中文翻译:**
我非常喜欢“提拔”（Sponsorship）这一点。我们在播客中没怎么聊过这个。大家都在谈论找教练或找一个教你如何工作的经理，但这种“到达一个有人给你机会让你发光发亮的位置”的想法，在我的职业生涯中也非常重要。就像某些经理会说：“给，Lenny。你来负责这个，让我们看看你能做出什么。”

---

### [00:26:44] Fareed Mosavat

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:26:45] Lenny

**English:**
Is there anything else you can recommend to folks to create opportunities for sponsorship? You talked about communication, executing well. Is that just the core of it, like doing a great job and communicating the great job you're doing?

**中文翻译:**
关于如何为自己创造被提拔的机会，你还有什么建议吗？你提到了沟通和良好的执行。这就是核心吗？比如把工作做好，并沟通你做得很好？

---

### [00:26:57] Fareed Mosavat

**English:**
This idea that it's what you do and that's multiplied by your ability to show that work and communicate it, and that's the impact that you can have, but you have to have not just impact on the customers, but also on the organization. I think it is impact on the organization, changing the way people think about problems, helping generalize what works and what doesn't work, bringing learnings to the table.

**中文翻译:**
这个想法是：你的实际作为乘以你展示和沟通工作的能力，就是你能产生的影响力。但你不仅要对客户产生影响，还要对组织产生影响。我认为对组织的影响包括改变人们思考问题的方式、帮助总结行之有效和行不通的经验、将学到的知识分享出来。

---

### [00:27:18] Fareed Mosavat

**English:**
For me, I've worked a lot on growth, and I've treated a huge part of my job as not just moving the numbers, but also teaching the organization how our growth model works, how the pieces fit together, what our customers care about, what's working, what's not working, and that creates a lot of, A, leverage in other parts of the organization because they can do better work by having more information, but also, B, trust. Trust from leadership, trust from your peers, and otherwise.

**中文翻译:**
对我来说，我做了很多增长工作，我把工作的很大一部分看作不仅是拉升数据，还要教导组织我们的增长模型是如何运作的、各个环节是如何衔接的、我们的客户关心什么、什么是有效的、什么是无效的。这创造了：A，在组织其他部分的杠杆作用，因为他们拥有更多信息可以做得更好；B，信任。来自领导层的信任、来自同事的信任等等。

---

### [00:27:44] Fareed Mosavat

**English:**
So, now, how do you get to that? Some of it is just luck. Someone has got to believe in you. You can create your luck by being good at communicating and solving hard problems. I think the other piece is knowing when you go into an organization, "Is this a role that's important to the company? Is it on the list?" I think it is easier to find sponsors, communicate, and create leverage if the thing you're working on is in the top four or five most important things the company is working on. I find myself drawn to those kinds of problems, and I think that's one way because then, all of a sudden, CEOs notice what you're working on, heads of product notice what you're working on, and your peers notice what you're working on.

**中文翻译:**
那么，如何实现这一点呢？一部分纯粹是运气，必须有人相信你。你可以通过擅长沟通和解决难题来创造运气。我认为另一部分是当你进入一个组织时，要弄清楚：“这个角色对公司重要吗？它在优先名单上吗？”如果你所做的事情是公司最重要的四五件事之一，那么寻找提拔者、进行沟通和创造杠杆就会容易得多。我发现自己会被这类问题吸引，我认为这是一种方式，因为突然之间，CEO 会注意到你在做什么，产品负责人会注意到你在做什么，你的同事也会注意到你在做什么。

---

### [00:28:22] Fareed Mosavat

**English:**
The other bit is curiosity. I think to be in the seat where people want to sponsor you, I think you have to show a handle on not just what you're doing, but how that relates to all of the things around you. So I call this going two stack levels up, two stack levels down in terms of your curiosity and what you understand, and also, knowing what's to the left and what's to the right. So let's use the example of if I'm working on activation on growth, let's say, or monetization. It doesn't matter. One of those two pieces. When I say two stack levels down, I like to understand how we build customers, how it works in Stripe, what are our dunning policies, what are the technical things that work and don't work in the pieces maybe down to the database. Right?

**中文翻译:**
另一部分是好奇心。我认为要处于一个别人愿意提拔你的位置，你必须表现出你不仅掌控着自己的工作，还了解它与周围所有事物的关系。我称之为在好奇心和理解力上“向上两层，向下两层”，同时还要知道左边和右边在发生什么。举个例子，假设我负责增长中的激活或商业化，哪一个并不重要。当我提到“向下两层”时，我喜欢了解我们如何向客户收费、Stripe 是如何运作的、我们的催款政策是什么、技术上哪些行得通、哪些行不通，甚至深入到数据库层面。对吧？

---

### [00:29:08] Fareed Mosavat

**English:**
It's like technical curiosity, those kinds of things, but also mental models for what's above you. How do we grow? How does modernization fit into that? What are the trade-offs versus free growth versus paid growth? How important is this to the company? How does it fit into our long-term strategy? Those kinds of things. So it's like the strategic things above you. I like two stack levels because it's like you should understand your boss's priorities and your boss's boss's priorities. Eventually, that means you have to know what the board is thinking, right? Then, left and right is, "What are the core product teams working on that I could help advise on in terms of modernization or they could advise me on what they're thinking and what might be coming next? How do we fit together with the enterprise part of the business even though I'm working on self-serve? How do I think about sales? Do they have input, like interesting customer conversations or input?

**中文翻译:**
这就像是技术好奇心之类的。但同时也要有对你“上方”事物的思维模型。我们如何增长？商业化如何融入其中？免费增长与付费增长之间的权衡是什么？这对公司有多重要？它如何符合我们的长期战略？这些就是你上方的战略性事物。我喜欢“向上两层”，因为你应该了解你老板的优先级，以及你老板的老板的优先级。最终，这意味着你得知道董事会在想什么，对吧？然后，“左边和右边”是：“核心产品团队在做什么，我可以在商业化方面给他们什么建议，或者他们可以就他们的想法和下一步计划给我什么建议？尽管我负责自助服务，但我们如何与企业级业务（Enterprise）结合？我如何看待销售？他们是否有反馈，比如有趣的客户对话或建议？”

---

### [00:29:58] Fareed Mosavat

**English:**
It's this curiosity like walking around, getting to know what people are doing, and being seen as an expert. Are you the desk people go to when they have questions? Are you a person that people ask the opinion when you're trying to figure out how the dots connect? I have found for me, maybe this is just because this is a strength of mine, that connecting the dots of how the whole company works and how all the pieces fit together has been one of the ways that I've driven that sponsorship. I think for each individual, you have to figure out what your superpower is and where you can be actually top 10%, and then lean into opportunities and also problems that help you show that and shine it that way.

**中文翻译:**
就是这种好奇心，比如四处走动，了解大家在做什么，并被视为专家。你是那个大家有问题时会去找的人吗？你是那个当人们试图理清各环节联系时会去征求意见的人吗？我发现对我来说（也许这只是我的强项），理清整个公司的运作方式以及各部分如何衔接，是我获得提拔的方式之一。我认为对于每个人来说，你必须弄清楚你的“超能力”是什么，你在哪方面能进入前 10%，然后投入到那些能让你展示并发挥这一优势的机会和问题中。

---

### [00:30:34] Lenny

**English:**
That is such cool advice. I think what's cool about that is I imagine you just go to your manager and even just ask, "Hey, I'd love to understand just what are your highest priorities, and then what are your manager's?" Just ask these questions. Just that alone I think communicates a lot about how much you care and your interest there, and that creates trust, even if you don't do a ton with it, and knowing what your manager cares about is just going to help in so many other ways just like, "Okay. This matters to them. I'm going to make sure to do a good job there."

**中文翻译:**
这建议太酷了。我觉得很棒的一点是，我可以想象你直接去找你的经理问：“嘿，我很想了解你最优先考虑的事情是什么，以及你老板最优先考虑的是什么？”仅仅问这些问题，我认为就能传达出你非常在乎并对此感兴趣，这会建立信任，即使你并没有针对这些信息做太多事情。而且知道你经理在乎什么，会在很多其他方面提供帮助，比如：“好吧，这对他们很重要，我一定要在那方面表现出色。”

---

### [00:31:00] Fareed Mosavat

**English:**
Absolutely.

**中文翻译:**
绝对是这样。

---

### [00:31:01] Lenny

**English:**
So that is a really cool framework.

**中文翻译:**
所以这是一个非常酷的框架。

---

### [00:31:02] Fareed Mosavat

**English:**
Not only do a good job there, but I'm going to figure out how to communicate what I'm doing to be only the parts that are important and matter to them. I'm going to know that when I hit a certain decision that needs to be made, whether I need their input or not. There are all these different pieces like understanding when to be heads-down, when to be heads-up, when to communicate, when not to, but I think understanding how all the pieces fit together, you really just try, and I always think of it as trying to build a mental model of how the company works, and what's important to it, and what's the equation, so to speak, or what are all the boxes, and then figure out like, "How is my work creating leverage in that?" I find that when you are thinking at that level, people tend to trust you.

**中文翻译:**
不仅要在那方面表现出色，我还要弄清楚如何沟通我的工作，只展示对他们重要且相关的部分。我会知道当我遇到某个需要做的决定时，是否需要他们的投入。这里有很多细节，比如理解什么时候该埋头苦干，什么时候该抬头看路，什么时候该沟通，什么时候不该。但我认为理解所有环节如何衔接，你实际上是在尝试建立一个关于公司如何运作、什么对公司重要、所谓的“公式”是什么、或者所有的“方框”是什么的思维模型，然后弄清楚：“我的工作如何在这个模型中创造杠杆？”我发现当你在这个层面思考时，人们往往会信任你。

---

### [00:31:44] Lenny

**English:**
The core of trust is people. Your manager and their leaders need to feel like you will do a good job and a bigger responsibility, and what gives them trust? Oh, they do a good job, or they're curious, and excited, and understand all these things that they need to understand. So it all makes sense, and I'm always weary of asking PMs to do more work. It's such a busy, long hours job already, and what's cool about these things you're talking about is it's not necessarily a lot more work. It's just a little bit of research and a little bit of digging and thinking.

**中文翻译:**
信任的核心是人。你的经理和他们的领导需要感觉到你能胜任更大的责任，什么能给他们信任？哦，他工作做得好，或者他充满好奇心、充满激情，并且理解了所有他需要理解的事情。所以这一切都说得通。我总是很谨慎地要求 PM 做更多工作，因为这已经是一份非常忙碌、工时很长的工作了。而你谈到的这些事情很酷的一点是，它们不一定需要大量的额外工作，只需要一点点调研、一点点挖掘和思考。

---

### [00:32:12] Fareed Mosavat

**English:**
Yeah. I think the hard part of this is I have not figured out how to do this well in a remote environment without throwing a lot of one-on-ones on people's calendars because sometimes you figured this out just by hearing conversations, hang out at lunch, and asking questions, and those kinds of things, but it's certainly not impossible. You just have to work out a little more,

**中文翻译:**
是的。我认为困难的部分在于，我还没想出如何在远程办公的环境下，不往别人的日历里塞满一对一会议就能做好这件事。因为以前你有时只需通过旁听对话、午餐闲聊和提问就能弄清楚这些。但这当然不是不可能的，你只是需要多花点心思。

---

### [00:32:31] Lenny

**English:**
Just more Zooms.

**中文翻译:**
就是更多的 Zoom 会议。

---

### [00:32:32] Fareed Mosavat

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:32:33] Lenny

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell it to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table, but getting a SOC 2 report can be a huge burden, especially for startups. It's time-consuming, tedious, and expensive.

**中文翻译:**
本期节目由 Vanta 赞助，帮助你简化安全合规流程，加速增长。如果你的企业在云端存储任何数据，那么你很可能已经被问到或即将被问到 SOC 2 合规性问题。SOC 2 是证明你的公司采取了适当安全措施来保护客户数据的一种方式，它能建立客户和合作伙伴的信任，特别是那些有严格安全要求的客户。此外，如果你想向企业级客户销售产品，证明安全性至关重要。SOC 2 既可以为你打开通往更大、更好交易的大门，也可能让你的业务停滞不前。如果你没有 SOC 2，很有可能你连谈判桌都上不去。但获取 SOC 2 报告可能是一个巨大的负担，尤其是对初创公司而言。它耗时、乏味且昂贵。

---

### [00:33:20] Lenny

**English:**
Enter, Vanta. Over 3,000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny. That's V-A-N-T-A.com/lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
Vanta 应运而生。超过 3000 家快速增长的公司使用 Vanta 来自动化处理高达 90% 的 SOC 2 相关工作。Vanta 可以让你在几周内而不是几个月内做好安全审计准备，时间不到通常所需的三分之一。在有限的时间内，Lenny's Podcast 的听众可以享受 Vanta 1000 美元的优惠。只需访问 vanta.com/lenny。即 V-A-N-T-A.com/lenny，了解更多信息并领取折扣。今天就开始吧。

---

### [00:33:50] Lenny

**English:**
So I know something you spend a lot of time thinking about is the transition from an ICPM to a manager, and you have this really epic post that I think you call the Product Leader Canyon that you think of this as a canyon that a lot of PMs don't cross. So I want to spend a little bit of time here. Can you maybe just talk about what this canyon is, and why it exists?

**中文翻译:**
我知道你花了很多时间思考从个人贡献者 PM（ICPM）到管理者的转变。你写过一篇非常精彩的文章，我记得叫《产品领导者大峡谷》（Product Leader Canyon），你认为这是一个很多 PM 无法跨越的峡谷。所以我想在这里花点时间。你能聊聊这个峡谷是什么，以及它为什么存在吗？

---

### [00:34:08] Fareed Mosavat

**English:**
Yeah. We talked a little bit about the first of very hard part in product management career development, which is like, "How do I land my first job?" Not a pro at that. We can talk about that more, but then this path from IC to more senior IC working on bigger problems that have more business impact, et cetera, it's a relatively straightforward path. We just talked about some of the ways that you do that. You get a deeper understanding across a wider range of business problems. You solve more unknowns versus being handed problems to solve, et cetera, and you do that by being good at your job. You do that by being good at your job basically as a solo product manager on an island.

**中文翻译:**
是的。我们刚才聊到了产品管理职业发展中第一个非常困难的部分，即“如何获得第一份工作”。我不是这方面的专家，我们可以再聊。但从 IC 到更资深的 IC，负责具有更大业务影响力的更重要问题的路径，相对来说是比较直接的。我们刚才讨论了实现这一目标的一些方法：对更广泛的业务问题有更深入的理解，解决更多的未知问题，而不是被动接受任务等等。你通过做好本职工作来实现这一点。基本上，你作为一个“孤岛”上的独立产品经理，通过表现出色来晋升。

---

### [00:34:48] Fareed Mosavat

**English:**
We talked about communication and those kinds of things, but at the end of the day, like we described, most of the work is execution. Most of the work is partnering with your engineering manager, partnering with your designer and your team to build stuff and deliver stuff. You've gotten there by being really good at that. Right? You've gotten there by getting in the weeds, getting in the details, sweating what matters, working hard at it. So someone says, "We'd love for you to lead this team." Great. It's really easy to look at that and say, "Okay. Now, instead of owning free to paid conversion, I own growth overall."

**中文翻译:**
我们谈到了沟通之类的事情，但归根结底，正如我们所描述的，大部分工作是执行。大部分工作是与你的工程经理合作，与你的设计师和团队合作来构建和交付东西。你是因为非常擅长这些才走到这一步的，对吧？你是因为深入细节、关注重点、努力工作才获得晋升的。所以有人说：“我们希望你来领导这个团队。”太好了。你很容易会想：“好吧，现在我不再只负责‘免费转付费’的转化，我负责整个增长了。”

---

### [00:35:28] Fareed Mosavat

**English:**
The first thing you do is start to figure out, "What are the most interesting and valuable projects that I can work on? As an IC, I can only have one person on my team to go dive in and work on those things to make a lot of leverage." This can create a little bit of a spiral of failure because it's the hard job. The IC part of the job is really hard. So, now, I gave you more work across more things, and you're already working 56 hours a week. Now, you got to keep track of more projects across more teams and more people, and maybe you kept the two or three most critical ones to yourself.

**中文翻译:**
你做的第一件事就是开始琢磨：“我可以做的最有趣、最有价值的项目是什么？作为 IC，我的团队里只有一个人（即你自己）能深入研究这些事情并创造巨大的杠杆。”这可能会导致一种“失败螺旋”，因为这是一份艰巨的工作。IC 的工作部分已经非常难了。现在，我给了你更多跨领域的工作，而你每周已经工作 56 小时了。现在，你必须跟踪更多团队、更多人的更多项目，而你可能还把两三个最关键的项目留给了自己。

---

### [00:36:04] Fareed Mosavat

**English:**
So that is one angle is learning about, yes, it's probably the right thing in the near term for you to focus, and work on this, and be really directive about what to do, and get in every single detail, and make sure you deliver the best product. But long run, you've taken a learning opportunity away from someone else, and you've taken the opportunity for you to be a leveraged person that is more valuable than just their time away as well. So I think that's one piece that drives a lot of failures, just this like, "Okay. Now, I have more problems to work on. I'm going to go deeper on it," and handing the people on your team the least interesting, least leveraged, least fun stuff to do, thinking that's how you get to like, "Oh, now, I get to work on the fun projects, and the interesting and high-leverage ones, and I'll leave all the other ones to other people."

**中文翻译:**
所以这是一个角度：短期内，你专注于此、给出明确指令、深入每个细节并确保交付最好的产品，这可能是正确的。但从长远来看，你剥夺了别人的学习机会，也剥夺了你自己成为一个比单纯投入时间更有价值的“杠杆型人才”的机会。我认为这是导致许多失败的原因之一，就是这种想法：“好吧，现在我有更多问题要处理，我要钻研得更深”，然后把团队中最无趣、最没杠杆、最不好玩的事情分给别人，心想：“哦，现在我可以做那些好玩的、有趣的、高杠杆的项目，把剩下的留给别人。”

---

### [00:36:51] Lenny

**English:**
I think you call this the manager death spiral. Is that the same?

**中文翻译:**
我想你把这称为“管理者死亡螺旋”。是同一个概念吗？

---

### [00:36:55] Fareed Mosavat

**English:**
Yeah. Yeah, manager death spiral.

**中文翻译:**
是的，管理者死亡螺旋。

---

### [00:36:56] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:36:56] Fareed Mosavat

**English:**
This is not unique to product management. This happens in almost every leadership role. You're in a position. You have broader responsibility. You got there by being the best IC on the team probably, so your instincts are to, "I see a bunch of important stuff," and do management stuff too. Right?

**中文翻译:**
这并非产品管理所特有。几乎在每个领导岗位上都会发生这种情况。你处于一个位置，拥有更广泛的责任。你之所以能到这个位置，很可能是因为你是团队中最优秀的 IC，所以你的本能是：“我看到了很多重要的事情”，然后顺便做点管理工作。对吧？

---

### [00:37:15] Lenny

**English:**
People may be like, "Oh, shit. How do I avoid this death spiral?" Do you have any advice? Maybe you'll get there, but just how do you avoid this death spiral of keeping all the good stuff and just not scaling yourself?

**中文翻译:**
人们可能会想：“噢，该死。我该如何避免这个死亡螺旋？”你有什么建议吗？也许你稍后会讲到，但具体该如何避免这种“揽下所有好活却不提升自己规模”的死亡螺旋？

---

### [00:37:24] Fareed Mosavat

**English:**
I think the first is, honestly, just you have to start trusting other people, which is not common to where you've been till today, but you have to start trusting. You have to shift from doer to editor is the way I think about it. You have to shift from, "My job is to do the work," to, "My job is to make the work better. My job is to plus the work, to review the work, to help other people solve problem." Sometimes that's by being directive. Right?

**中文翻译:**
我认为第一点，坦白说，就是你必须开始信任他人。这与你之前的经历大不相同，但你必须开始信任。我把它看作是从“执行者”到“编辑者”的转变。你必须从“我的工作是干活”转变为“我的工作是让工作变得更好。我的工作是为工作加分、审查工作、帮助他人解决问题”。有时这需要给出明确指令，对吧？

---

### [00:37:51] Fareed Mosavat

**English:**
Sometimes that's by letting them run because you're like, "Lenny, you're great. Please go solve this problem. Call me when you have a problem." If you have people that are in that upper quadrant of like they understand the problem, they have the level of experience to solve it, it's maybe not 100% important. Maybe it is. That kind of thing. Then, there's the coach in the middle, which is like, "How do I help make that work better?" They have to start figuring out like, "Where is each person on your team in their expertise, and what level of input is the highest leverage for me?"

**中文翻译:**
有时这需要放手让他们去跑，因为你会觉得：“Lenny，你很棒。请去解决这个问题，有困难再找我。”如果你手下的人处于那个“高象限”——他们理解问题，有经验解决它，而且这件事可能不是百分之百命悬一线（也许是）。然后中间还有“教练”的角色，即：“我如何帮助把这项工作做得更好？”管理者必须开始弄清楚：“团队中每个人的专业水平在哪里？我提供什么程度的投入能产生最高的杠杆效应？”

---

### [00:38:24] Fareed Mosavat

**English:**
I actually think of it as start thinking in terms of being lazy, "What's the least amount of work I could do to make this thing as good as possible?" versus, "How do I do as much work as possible to make sure it's great?" So it's like looking in terms of ROI. The other is just hiring, bringing on great people you trust, making sure you're staffed appropriately, and there's just a second bit. I think one of the bigger mistakes that new ICs make on teams, that they still treat problems the same way they did as ICs, which normally, when you run a pod, basically, your job is, "How do I deliver the most value with the resources I have?"

**中文翻译:**
我实际上认为这是一种“变懒”的思考方式：“我能做的最少工作量是多少，同时能让这件事尽可能完美？”而不是“我如何做尽可能多的工作来确保它很棒？”这就像是在看投资回报率（ROI）。另一点就是招聘，招募你信任的优秀人才，确保人员配置合理。还有第二点：我认为新晋管理者常犯的一个大错误是，他们仍然像做 IC 时那样对待问题。通常当你领导一个小组（Pod）时，你的工作是：“我如何利用现有的资源交付最大的价值？”

---

### [00:38:57] Fareed Mosavat

**English:**
When you're a leader, it's now your job to propose, "What are the resources we need to have the most impact on this problem?" I think I personally have messed this up a bunch of times where at the end of the core, I'll be like, "Yeah, but we only had four engineers, and this is what we could do." I'm like, "That wasn't what we asked you to do. We asked you to solve this problem. So adding four more people was what you needed or you needed the marketing team to do X, Y, and Z." You need to go out and do that work now. It is not just your job to get what you can get done with the resources in front of you. It's your job to marshal resources both inside your org and across your organization. I think that's another big area that's related to the trust bit because, again, it's this habit of, "Oh, I got here by doing everything myself." You have to start realizing that your job is to convince other people to do work too.

**中文翻译:**
当你成为领导者时，你的工作变成了提议：“我们需要什么样的资源才能在这个问题上产生最大的影响？”我个人曾多次搞砸过这一点。在季度末，我会说：“是的，但我们只有四个工程师，这就是我们能做的极限了。”而领导会说：“那不是我们要求你做的。我们要求你解决这个问题。所以你需要的是再加四个人，或者需要营销团队配合做 X、Y、Z。”你现在需要去争取这些。你的工作不再仅仅是利用眼前的资源尽力而为，而是去调动组织内部和跨组织的资源。我认为这是与信任相关的另一个大领域，因为这又回到了那个习惯：“哦，我是靠自己搞定一切才走到这里的。”你必须开始意识到，你的工作也包括说服别人去干活。

---

### [00:39:49] Lenny

**English:**
Awesome. So, going back to the canyon. So the first piece was essentially over-focusing on just being too good at the thing you're already doing versus going broader, is that right?

**中文翻译:**
太棒了。回到“峡谷”的话题。所以第一部分本质上是过度专注于把你已经在做的事情做得太好，而不是去拓展广度，对吗？

---

### [00:39:59] Fareed Mosavat

**English:**
Mm-hmm. Yeah. So it's like, "Hey, how do I maximize my output? I can do this myself faster than I can explain it to someone else, so I'll just do it," and then finding that you're blocking your team because you're in the middle of every single decision, finding that you're totally overworked, and finding that people aren't learning or growing because those opportunities have been taken from them. So what do you do to break that? You have to just slowly start to give up, trust, do that. So I think that's the one bit is that death spiral of what's getting stuff done.

**中文翻译:**
嗯，是的。就像是：“嘿，我该如何最大化我的产出？我自己做比跟别人解释要快，所以我干脆自己做了。”然后你发现你成了团队的瓶颈，因为你介入了每一个决定；你发现自己完全超负荷工作；你发现大家没有学习或成长，因为那些机会被你夺走了。那么你该如何打破这种局面？你必须开始慢慢放手、信任。所以我认为这就是“为了把事情做完而陷入死亡螺旋”的那一部分。

---

### [00:40:31] Lenny

**English:**
No, no. You can curse all you want. That's all good.

**中文翻译:**
没关系，你可以随便说脏话（指咒骂死亡螺旋），没事的。

---

### [00:40:33] Fareed Mosavat

**English:**
Okay. Great. Oh, you've just... Well, be careful with "all you want."

**中文翻译:**
好的，太棒了。哦，你刚才……好吧，说“随便”的时候要小心点。

---

### [00:40:36] Lenny

**English:**
Nobody has cursed yet on this podcast, and it's all allowed.

**中文翻译:**
这个播客还没人说过脏话，不过都是允许的。

---

### [00:40:40] Fareed Mosavat

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:40:41] Lenny

**English:**
It's the internet. I don't know.

**中文翻译:**
这是互联网，谁知道呢。

---

### [00:40:41] Fareed Mosavat

**English:**
We'll solve that.

**中文翻译:**
我们会解决这个问题的（指打破死亡螺旋）。

---

### [00:40:42] Lenny

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:40:43] Fareed Mosavat

**English:**
Don't worry. I think the other is what I call the four types of product work, and I think this is not always right at the manager stage. But for every great product leader, you go from being an expert in some type of product work, and I'll describe what those are, to now owning a portfolio of work across a bunch of different dimensions. So the way I think about product work, and Casey Winters and I worked on this framework together, a lot of it comes from him. So I don't want to oversay it, but it's all part of our product strategy program at Reforge is first, feature work, adding new features, product experiences, et cetera into a product in order to drive engagement with your existing customer base and solve a wider range of problems.

**中文翻译:**
别担心。我认为另一个关键是我所说的“四种产品工作类型”。我认为这在经理阶段并不总是完全适用，但对于每一位伟大的产品领导者来说，你都会从某种产品工作的专家，转变为管理跨多个维度的“工作组合”。我和 Casey Winters 共同开发了这个框架，其中很多内容源自他。我不夸大其词，但这都是 Reforge 产品战略课程的一部分。第一种是“功能性工作”（Feature work）：向产品中添加新功能、产品体验等，以提高现有客户群的参与度并解决更广泛的问题。

---

### [00:41:24] Fareed Mosavat

**English:**
The second is growth work. "How do I help my customers or a broader range of customers connect with the experiences we already have, and drive acceleration and either top-line growth, or modernization, or whatever the most important metrics are. I think you've had many guests on to talk about growth type work. The third is related to growth, but I think is slightly different, which is what we call product market fit expansion. So it's not exactly feature work, which is like, "Hey, now that I use your product more, I have this thing I need in order to keep using it because I'm a power seller," those kinds of things. But instead, we want to attract a whole new sub-segments of markets to the product by adding something.

**中文翻译:**
第二种是“增长性工作”（Growth work）：“我如何帮助现有客户或更广泛的客户群接触到我们已有的体验，并推动加速，无论是顶线增长、商业化，还是任何最重要的指标。”我想你已经请过很多嘉宾来谈论增长类工作了。第三种与增长相关，但我认为略有不同，我们称之为“产品市场契合度扩张”（PMF Expansion）。它不完全是功能性工作（比如“嘿，既然我用你的产品更多了，我需要这个功能才能继续用下去，因为我是超级卖家”之类的）。相反，我们希望通过添加某些东西来吸引全新的细分市场。

---

### [00:42:05] Fareed Mosavat

**English:**
There are two forms of product market fit expansion. There's either taking the same product and finding a new audience. Things like internationalization or vertical like, "I'm going to sell the same product to a different vertical because we're a verticalized product." The other is selling a different product to the same audience. This is what bundling strategies basically look like. Right? So adding new marketing tools to a marketing suite, et cetera that attract a different kind of customer and that either drive upsell or drive new audiences to come to that.

**中文翻译:**
PMF 扩张有两种形式。一种是拿同样的产品去寻找新受众，比如国际化，或者垂直化（比如“我要把同样的产品卖给不同的垂直行业，因为我们是垂直化产品”）。另一种是向同样的受众销售不同的产品。这基本上就是“捆绑销售”策略。比如在营销套件中添加新的营销工具，从而吸引不同类型的客户，要么推动增购（Upsell），要么吸引新受众。

---

### [00:42:34] Fareed Mosavat

**English:**
So that's the third kind of product work, and then there's the fourth that is always forgotten by a lot of PMs which is scaling work. So what is the stuff we're doing that is because we are growing, there's new product work we need to do? Most people think of this as technical scaling, but I actually put things like trust, and safety, and other kinds of what we call user scaling problems in this as well. There are a lot of problems that come up at Airbnb just because instead of having 10 hosts, you have 10,000 hosts. Right? There are a lot of problems at Twitter and Facebook that are well puzzle-sized that are a result of their scale, and I think that a chunk of work that I put in the same category as technical scaling, which is like, "How do we make sure the product continues to work for the people who are using it?"

**中文翻译:**
这就是第三种产品工作。第四种经常被很多 PM 遗忘，那就是“规模化工作”（Scaling work）。也就是因为我们在增长，所以我们需要做哪些新的产品工作？大多数人认为这是技术扩容，但我实际上把信任、安全以及其他我们所谓的“用户规模化问题”也归入此类。Airbnb 出现的很多问题仅仅是因为房东从 10 个变成了 10,000 个，对吧？Twitter 和 Facebook 也有很多由于规模巨大而产生的复杂问题。我认为这部分工作与技术扩容属于同一范畴，即：“我们如何确保产品能持续为正在使用它的人服务？”

---

### [00:43:15] Fareed Mosavat

**English:**
So the challenge of the four kinds of product work. "Okay. Great. We have a framework. How is that useful, Fareed?" It's not that useful. It is to know what kind you're doing, but I think as you go up the stack of product leadership, you are going from being probably an expert in one of these, so for me, growth, to needing to think about all these other ones, and you've probably never done them before. Right? Maybe you've done two, but how do you lead across a bunch of different things, and how do you make sure not to be over-focused on the one that you care the most about?

**中文翻译:**
所以这四种产品工作的挑战在于：“好吧，太棒了，我们有一个框架。但这有什么用呢，Fareed？”它本身没那么有用。它的作用是让你知道你正在做哪一类工作。但我认为随着你进入产品领导层，你会从某一个领域的专家（对我来说是增长），转变为需要思考所有其他领域，而你可能以前从未做过这些，对吧？也许你做过其中两个，但你如何领导一系列不同的事务，并确保不会过度专注于你最关心的那一个？

---

### [00:43:46] Fareed Mosavat

**English:**
We've all seen this. Right? It's like growth leader takes over, and everything is a growth problem. Everything is an experiment. Everything should be measured. That's not necessarily true for some of these other kinds of work, and so how do you start to lead, and grow, and build a portfolio across those? I think that's where some of the stuff we talked about before, deep curiosity, looking across, asking a lot of questions, getting to a foundational understanding of what's important there, et cetera is really important.

**中文翻译:**
我们都见过这种情况，对吧？比如一个增长负责人接管了全局，然后所有问题都变成了增长问题。所有事情都要做实验，所有事情都要衡量。对于其他类型的工作来说，这并不一定正确。那么你如何开始领导、发展并建立跨这些领域的工作组合呢？我认为这就是我们之前谈到的：深厚的好奇心、横向观察、多提问、对各领域的核心要点建立基础理解等等，这些都非常重要。

---

### [00:44:14] Lenny

**English:**
Got it. So part of this is learning new types of product work. So we're talking about trying to move from IC to manager and the things that get in the way, and so is the advice there just start to learn and understand... Maybe, say, you're doing feature work. You're just building a dashboard for your users. Is your advice there like start thinking about how growth works and understand the growth strategy of the company so that people give you this opportunity of, "Okay. Let's put Fareed on maybe a couple other things here because he already understands a little bit more about growth?"

**中文翻译:**
明白了。所以其中一部分是学习新类型的产品工作。我们正在讨论从 IC 到经理的转变以及其中的障碍。那么你的建议是开始学习和理解……比如，你正在做功能性工作，只是为用户构建一个仪表盘。你的建议是开始思考增长是如何运作的，理解公司的增长战略，这样别人才会给你机会：“好吧，让 Fareed 负责其他几件事吧，因为他已经对增长有了一定的了解”？

---

### [00:44:45] Fareed Mosavat

**English:**
Yeah. I think there's a framework thing, and then there's like, "What practical advice?" So from a framework perspective, I think it's important to ask the question, "For each of the things that I am responsible for, what category does this fall into? What's important about it? What are the right ways to think about building that, given that it is different than what I've built before?" So, some of this, you can do within an org. If you're working on core product stuff, you probably have an adoption problem on one of your products, and there's growth work associated with driving usage of that thing.

**中文翻译:**
是的。我认为这既有框架层面的，也有实际建议层面的。从框架角度看，重要的是问这样一个问题：“对于我负责的每一件事，它属于哪个类别？它的重点是什么？考虑到它与我之前构建的东西不同，思考构建它的正确方式是什么？”其中一些你可以在组织内部完成。如果你在做核心产品，你可能在某个产品上遇到了采用率（Adoption）问题，那么就会有与推动该产品使用相关的增长工作。

---

### [00:45:18] Fareed Mosavat

**English:**
So I think there's a piece at which even within a certain sub-segment that this can be valuable. You could be working on enterprise, which looks a lot like a lot of scaling work, right, and a lot of feature work, "Get me the right administrative dashboards and these kinds of things," but also, maybe you have a problem that's a growth problem. "How do I drive adoption? How do I actually drive usage? How do I make sure that our new enterprise customers are activated and retained?"

**中文翻译:**
所以我认为即使在某个细分领域内，这也有价值。你可能在做企业级业务（Enterprise），这看起来很像规模化工作，对吧？还有很多功能性工作，比如“给我做个合适的管理后台之类的”。但同时，你可能也面临一个增长问题：“我如何推动采用？我如何实际推动使用？我如何确保我们的新企业客户被激活并留存？”

---

### [00:45:43] Fareed Mosavat

**English:**
So I think at scale, any product leadership work has some pieces of these different kinds, and I think building a mental model for, "What are the other things we need to do? What's the right portfolio allocation across these different types of product work, and do I have enough of a baseline understanding of the different ways to evaluate and think about those and what the goals are in order to drive leadership across work I might not be able to do myself very well?" I am not a good technical PM despite having an engineering background. It's been too long, but I hope that I can lead technical scaling, technical debt restructure on my team or at least understand whether it's important to do or not.

**中文翻译:**
所以我认为在一定规模下，任何产品领导工作都包含这些不同类型的碎片。我认为建立一个思维模型很重要：“我们还需要做哪些其他事情？在这些不同类型的产品工作中，正确的组合分配（Portfolio allocation）是什么？我是否对评估和思考这些工作的不同方式以及目标有足够的基础了解，以便领导那些我可能无法亲自做得很好的工作？”尽管我有工程背景，但我并不是一个好的技术型 PM。时间太久了，但我希望我能领导团队进行技术扩容、技术债重组，或者至少能判断做这些事是否重要。

---

### [00:46:20] Lenny

**English:**
So if you think about this concept of getting through this canyon broadly, it boils down to more scope. Maybe that's the way to think about it. It's like more scope of product work that you work on, being better at different types of work, scaling yourself so that other people can do work on your behalf or within your umbrella, and the point you made about not being satisfied with the resources you have and in helping people understand, "Here's what we could do if we had this many resources," and making the case for that feels like that's the overview. Is that how you think about it?

**中文翻译:**
所以如果从广义上思考跨越这个峡谷的概念，它归结为“更大的范围”（More scope）。也许可以这样理解：负责更广泛的产品工作，擅长不同类型的工作，提升自己的规模以便他人能代表你或在你的羽翼下工作。还有你提到的那一点：不满足于现有资源，并帮助人们理解“如果我们有这么多资源，我们能做到什么”，并为此据理力争。这感觉就是全貌，你是这样想的吗？

---

### [00:46:49] Fareed Mosavat

**English:**
Yeah. I think that's exactly right, and the last one is really important because now, you have moved to owning the impact. As a leader, you now own the business outcome, the impact, the delivery, not some sub-problem or known answer. You have to define the solutions. You have to talk about how many people you need to do them, and you need to figure out what do you need from the rest of the organization to do that. So, yeah. I think those are the three big buckets of things that I see trip people up.

**中文翻译:**
是的。我认为完全正确。最后一点非常重要，因为现在你已经转变为“对影响力负责”。作为领导者，你现在对业务结果、影响力、交付负责，而不是某个子问题或已知答案。你必须定义解决方案，必须讨论你需要多少人来完成，并且需要弄清楚你需要组织其他部门提供什么支持。所以，是的，我认为这就是我看到的让人们栽跟头的三个大坑。

---

### [00:47:14] Lenny

**English:**
I love that. When did you realize this was something you should be doing?

**中文翻译:**
太棒了。你是什么时候意识到这是你应该做的事情的？

---

### [00:47:38] Fareed Mosavat

**English:**
Yeah, and that goes from a "would be nice" and makes you a better... more junior or even senior PM makes you a more effective one. It's extra credit. At the leadership level, it's baseline. The baseline is, "Okay. I believe this is the outcome we need to get to by this time, and this is what it's going to take. Here are the trade-offs. Here's what I need. Here's what I can get you if I can't do that." The reason I drum this one home is I feel like this is the mistake I have made now multiple times in my career, and I can't... At this point, I'm embarrassed to have seen it happen over and over again because you just get caught up in like, "Okay. Here's the team I have. I've got to build a roadmap. I've got to make sure everybody's got work to do," and you say focused on feeding that beast, and you forget to ask, "Is this even the right group to solve this?" Maybe you need a smaller team even, maybe you need a bigger team, or maybe you need different people. I think often, you find yourself victim of the circumstances instead of owning the situation.

**中文翻译:**
是的。这从“如果能做就太好了”变成了让你成为一个更有效率的初级甚至高级 PM 的加分项。但在领导层，这是基准线。基准线是：“好吧，我相信我们需要在某个时间点达到这个结果，这需要付出这些代价。这是权衡。这是我需要的。如果我得不到这些，我能交付的是这些。”我之所以反复强调这一点，是因为我觉得这是我在职业生涯中多次犯过的错误。到目前为止，看到它一遍又一遍发生，我都觉得不好意思了。因为你很容易陷入这种状态：“好吧，这是我现有的团队，我要制定路线图，我要确保每个人都有活干。”你专注于“喂饱这头怪兽”（指让团队有活干），却忘了问：“这真的是解决这个问题的正确团队吗？”也许你需要一个更小的团队，或者更大的团队，或者不同的人。我认为通常情况下，你会发现自己成了环境的受害者，而不是局面的掌控者。

---

### [00:48:39] Lenny

**English:**
I love that. When did you realize this was something you should be doing?

**中文翻译:**
我喜欢这个观点。你是什么时候意识到这是你应该做的事情的？

---

### [00:48:42] Fareed Mosavat

**English:**
I've learned different versions of this lesson now multiple times. I learned it at Instacart. I had a very small team, and we've got a lot done. But honestly, I think I failed to make the case that we should grow it faster and only... It was only when someone was like, "We should add more people." I was like, "Great. Yeah. Let's do that." I don't think I was hurt by that, but I think it was a, "Oh, you have permission. You should have asked," kind of thing. I think at Slack, the lesson I learned was about cross-functional. I think we did a good job of making the case for why we needed new teams or add more things to drive more impact, but I still took a very product approach to solving activation and monetization expansion type problems.

**中文翻译:**
我已经多次学到过这个教训的不同版本了。我在 Instacart 学到了它。当时我有一个非常小的团队，我们做了很多工作。但坦白说，我认为我没能据理力争去更快地扩大团队规模，直到有人主动提议：“我们应该增加人手。”我才说：“太好了，是的，就这么办。”我不觉得这伤害了我，但我觉得这是一种“哦，你有权限，你本该主动要求的”那种感觉。在 Slack，我学到的教训是关于跨职能的。我认为我们在争取新团队或增加资源以产生更大影响力方面做得很好，但我仍然采取了非常“产品化”的方法来解决激活和商业化扩张类的问题。

---

### [00:49:25] Fareed Mosavat

**English:**
What I think is I look at what could have moved the needle more and what it could have made me a more successful leader at that company. It would've been partnering more closely with marketing, for instance, to figure out how we could be working on things together, helping drive their roadmap, and vice versa. Same with sales. Same with the data org. Same with finance. Those kinds of things where I don't think I was driving enough of the high-level outcome I owned, which is driving growth in the self-service business across the other parts of the company that needed to do that. I was a product leader, so I did product work, and I... Lesson learned.

**中文翻译:**
回想起来，我在思考什么能更有效地推动业务，以及什么能让我成为那家公司更成功的领导者。例如，那应该是与营销部门更紧密地合作，弄清楚我们如何协同工作，帮助推动他们的路线图，反之亦然。销售、数据部门、财务部门也是如此。在这些方面，我认为我没有足够地推动我所负责的高层结果，即在需要配合的其他部门中推动自助服务业务的增长。我当时是一个产品领导者，所以我只做了产品工作，然后……教训深刻。

---

### [00:50:05] Lenny

**English:**
Yeah. Thanks for sharing that. So we've been talking a lot about the regular path, and getting better and accelerating your path as a product leader, and staying on this track. There's also this alternative track that I know you're passionate about, and Reforge just become a beacon, it feels like, of folks that are moving away from working at one company to working at many companies and scaling their impact. I'm curious to hear your thoughts on what you've seen there. There's this large trend of just senior people becoming advisors, writing things, newsletters, for example. I'm curious what you think is happening there and how you think about that.

**中文翻译:**
是的。谢谢你的分享。我们一直在讨论常规路径，以及如何作为产品领导者变得更好、加速晋升并保持在这个轨道上。但还有一条替代路径，我知道你对此充满热情。Reforge 似乎已经成为了一个灯塔，吸引着那些不再只为一家公司工作，而是为多家公司工作并扩大影响力的精英。我很想听听你对这一现象的看法。现在有一个大趋势，资深人士开始担任顾问、写作、办时事通讯（Newsletter）等等。我很想知道你认为这背后发生了什么，以及你是如何看待的。

---

### [00:50:41] Fareed Mosavat

**English:**
It's interesting. The whys are hard to pin down, but it's definitely happening. I think some of it is maybe COVID-induced, some of it is remote work driving these trends, and some of it is just like there are a lot more leaders who are a lot more in demand. So, just to recap, a trend that I think we are seeing and that has been really interesting is a trend of senior leaders, people with meaningful operating experience, first, diversifying their impact maybe while they're still at a full-time role. Someone like yourself, Lenny, maybe was full-time at Airbnb or a similar company and said, "Hey, I'd like to do some advising, some angel investing, some speaking. Maybe I'll start writing a newsletter on the side," and then moving to this new category that I don't feel like really existed. Maybe it did in certain pockets of executive leadership around tech and startups, but really seeing it in product management of a shift towards, "The best use of my time and my career is to work across a portfolio of problems that a variety of different companies."

**中文翻译:**
这很有趣。原因很难确定，但它确实在发生。我认为部分原因是新冠疫情引发的，部分是远程办公推动了这些趋势，还有部分是因为现在对优秀领导者的需求大增。简而言之，我们看到的一个非常有趣的趋势是，拥有丰富运营经验的高级领导者，首先在全职工作期间就开始使自己的影响力多样化。比如像你这样的人，Lenny，可能在 Airbnb 或类似公司全职工作时说：“嘿，我想做一些顾问工作、天使投资、演讲。也许我还会顺便写个时事通讯。”然后转向这个我感觉以前并不真正存在的“新类别”。也许它在科技和初创公司的高管圈子里一直存在，但在产品管理领域，我们确实看到了向“我职业生涯和时间的最佳利用方式是解决多家不同公司的组合问题”的转变。

---

### [00:51:47] Fareed Mosavat

**English:**
So we are seeing a larger percentage of our executive network. It's still small, but working on things like newsletters, podcasts, those and the like at the edge of the content creator side, but also, full-time advisors, fractional heads of growth, fractional heads of product one day a week, et cetera. Long-term advisory relationships, running workshops. These kinds of things that are more like a la carte. I think they love it because of the flexibility that it creates for them. They love it because of the high upside and non-linearity of possibility of results now instead of having equity in one company for four years of 100% of my time. It's a portfolio approach to not just the time and energy, but also the upside and opportunities that are there as well as the fact that they're just so in demand.

**中文翻译:**
所以我们看到我们的高管网络中，有更大比例的人（虽然绝对数量仍然较小）在从事时事通讯、播客等内容创作边缘的工作，同时还有全职顾问、兼职（Fractional）增长负责人、每周工作一天的兼职产品负责人等等。还有长期的咨询关系、举办工作坊。这些事情更像是“点菜式”的服务。我认为他们喜欢这种方式是因为它带来的灵活性。他们喜欢它是因为现在有很高的上限和结果的非线性可能性，而不是把 100% 的时间花在一家公司拿四年的期权。这是一种对时间、精力、收益和机会的“组合管理”方式，而且事实上，他们的需求量真的很大。

---

### [00:52:41] Fareed Mosavat

**English:**
For senior leaders who have been in meaningful seats at well-known companies, you're getting hit up by recruiters all day long, and the decision, "What do I want to spend the next four or five, six years of my life on if it's just one thing?" is a very difficult one. So what we're finding is people seeing, "Hey, you don't need me full-time. What you need is me here a day a week to help your up and coming leaders be awesome." We're just seeing more and more of that in the industry, and it's been a really interesting trend to observe. Of our executives and residents, I would say most now are exploring this kind of advisory, fractional, or otherwise portfolio-based approach to their futures. Whereas most of them came from full-time roles beforehand.

**中文翻译:**
对于那些在知名公司担任过重要职位的资深领导者来说，猎头整天都在找你。而决定“如果只做一件事，我未来四五六年想把生命花在什么上面？”是一个非常困难的决定。所以我们发现人们意识到：“嘿，你不需要我全职。你需要的是我每周来一天，帮助你那些崭露头角的领导者变得更出色。”我们在行业中看到了越来越多这样的情况，这是一个非常有趣的趋势。在我们的驻校高管中，我想说大多数人现在都在探索这种顾问、兼职或其他基于组合的方式来规划未来，而他们之前大多来自全职岗位。

---

### [00:53:24] Lenny

**English:**
Yeah. A program at Reforge is designed for that. The idea there is, "You don't know what you're going to do next? Come teach a class at Reforge to help some folks out, and then use that as the time to explore what you're going to do next." Right?

**中文翻译:**
是的。Reforge 的一个项目就是为此设计的。其核心理念是：“你不知道下一步要做什么？来 Reforge 教课吧，既能帮助别人，也能利用这段时间探索你的下一步。”对吧？

---

### [00:53:35] Fareed Mosavat

**English:**
Yeah. Yeah, it is, and the hypothesis... I was one of the first EIR, so I started as an EIR at the company, and then ended up joining full-time as an executive. The hypothesis was, "Hey, let's give people six months to a year so that they don't just hop from one really high-stress, really difficult job into the next one. We also want great operators teaching and meeting our programs. How do we build a win-win situation?" So what we did was we created the Executive in Residence program as a way to help top operators have a transition point, but I think the hypothesis was that most of them would take on the next VP product role, or CPO role, or CMO type role, and what we're finding is that more and more of them are using that space and time.

**中文翻译:**
是的，没错。这个假设……我是最早的 EIR 之一，我以 EIR 的身份加入公司，最后全职加入了高管团队。当时的假设是：“嘿，让我们给这些人六个月到一年的时间，让他们不要直接从一个高压、困难的工作跳到下一个。我们也希望有优秀的运营者来教学和参与我们的项目。我们如何建立双赢局面？”所以我们创建了驻校高管（EIR）项目，作为帮助顶级运营者平稳过渡的方式。但我认为当时的假设是大多数人之后会去担任下一个产品副总裁、CPO 或 CMO 之类的角色。而我们现在发现，越来越多的人正在利用这段空间和时间（去走顾问/兼职路径）。

---

### [00:54:17] Fareed Mosavat

**English:**
They are building up their understanding of where they're experts and what their real TEDx value is, and then finding ways to do that across a variety of different companies and organizations versus just the single one, one, because they want to try before they buy, so to speak, in terms of of like even if you do end up somewhere full-time, it's nice to be able to really work with them and get to know them because at the executive level in particular, it's a really high level of commitment, and you have a lot of opportunities, so you want to be really careful about it. But also, two, because it may not be the best use of your energy. When you have a lot of frameworks and you have a lot of broad understanding, you have a lot of examples, your value to the ecosystem is often by helping lots of companies be successful, not just one. I suspect that's how you feel about what you're doing as well.

**中文翻译:**
他们正在建立对自己专业领域和真正核心价值的理解，然后寻找在多家不同公司和组织中实现价值的方法，而不是只在一家公司。一方面是因为他们想“先试后买”，即使你最终决定全职加入某处，能先实际合作并了解他们也是很好的，因为在高管层面，这需要极高的投入，而且你有很多机会，所以你会非常谨慎。另一方面，因为全职可能不是你精力的最佳利用方式。当你拥有大量框架、广泛的理解和丰富的案例时，你对生态系统的价值往往在于帮助许多公司获得成功，而不仅仅是一家。我猜你对自己现在所做的事情也是这种感觉。

---

### [00:55:07] Lenny

**English:**
Yeah. When I started down this path of experimenting with a newsletter back in the day, I called it Project Avoid Getting a Real Job, and what I was trying to do is figure out, "Can I make a living doing this thing even though I don't know if there's any way to make money writing a thing?" My wife is always like, "There's no money in writing. What are you doing? I thought you wanted to start a company, that you wanted to do some advising."

**中文翻译:**
是的。当我早些时候开始尝试写时事通讯时，我把它叫做“逃避正经工作计划”。我当时想弄清楚的是：“即使我不知道写东西能不能赚钱，我能靠这个谋生吗？”我妻子总是说：“写东西没钱赚的。你在干嘛？我以为你想开公司，或者想做点顾问工作。”

---

### [00:55:28] Fareed Mosavat

**English:**
Yeah. Well, let me talk about why I think the generalization there's no money in writing is true, but I think it's true because it's... In general, maybe not, but what's happening, I think, is people are figuring out, "What is my specific knowledge," just to tie the knots back to the thing we started at the beginning, "that because I've taken so many reps at this is actually not easily replaceable in a focused area?" So modernization or building zero-to-one paid channels as a marketer, or whatever it is. Just narrow enough that I know I'm one of the five best in the world at or I can make the case that I'm one of the five best in the world at it. You as a company probably can't hire that person because you're too early, don't have enough money, don't have enough clout, et cetera, and that I have generalized enough in my mind that I can actually be really effective in a small amount of time.

**中文翻译:**
是的。关于“写东西没钱赚”这个普遍看法，我想说它在一般情况下可能是对的，但现在发生的情况是，人们正在弄清楚“我的特定知识是什么”。回到我们开头谈到的：因为我已经在这个领域磨练了太多次，所以在某个特定领域我是不可替代的。比如商业化，或者作为营销人员构建从 0 到 1 的付费渠道，不管是什么。只要足够细分，我知道我是世界上最顶尖的五个人之一，或者我可以证明这一点。作为一家公司，你可能雇不起这样的人，因为你还太早、钱不够、名气不够等等。而我已经把这些知识通用化了，所以我可以在很短的时间内产生巨大的效果。

---

### [00:56:25] Fareed Mosavat

**English:**
So what works for you, I don't know a lot about the mechanics of your newsletter, but it's not just writing. You're writing about a very specific set of topics that you have unique experience in that has harnessed a very focused community, and I think we're seeing this across a bunch of different things that there's a lot of sub-expertise. No one can be an expert at company. Some people claim to be, but when you get down to it, I feel like an expert on bottoms-up SaaS activation strategy is like, "I can speak pretty confidently about that. Somebody has a problem in that space, I can usually at an hour accelerate their learning pretty dramatically." I think as we're finding what these things are and people are getting smarter about what they're looking for, I think it opened up this space where you can be the best in the world at a relatively narrow topic and make a real meaningful living out of it.

**中文翻译:**
所以对你有效的原因（虽然我不了解你时事通讯的运作机制）在于，这不仅仅是写作。你是在写一套非常特定的主题，你在这些主题上有独特的经验，并且吸引了一个非常专注的社群。我认为我们在很多不同的领域都看到了这种“子专业知识”（Sub-expertise）。没人能成为“公司运营”的全才。有些人自称是，但深入研究后，我觉得一个“自下而上（Bottoms-up）SaaS 激活策略”的专家会说：“我可以非常自信地谈论这个。如果有人在这个领域有问题，我通常能在一小时内极大地加速他们的学习过程。”随着我们发现这些细分领域，且人们越来越清楚自己需要什么，这开启了一个空间：你可以在一个相对狭窄的主题上做到世界顶尖，并以此过上非常有意义的生活。

---

### [00:57:19] Lenny

**English:**
There's two thoughts I want to go into here, and then I think we should probably wrap up, but one is I do worry there's like... everyone that gets to a certain point, it just exits the career track, and who's left to build things? I worry that just everyone is trying to become an influencer/creator person. So what I wanted to chat about briefly is just downsides of this path in life.

**中文翻译:**
我想深入探讨两个想法，然后我们就差不多该结束了。一个是，我担心如果每个达到一定水平的人都退出职业轨道，那谁来真正构建产品呢？我担心每个人都想成为网红或创作者。所以我想简要聊聊这种生活路径的弊端。

---

### [00:57:41] Fareed Mosavat

**English:**
Sure.

**中文翻译:**
当然。

---

### [00:57:41] Lenny

**English:**
The other pieces is for folks listening that want to pursue this direction, what could they do to set themselves up? So the first piece is just like, what are the downsides? I'll share a few already. So in this life that I lead now, I get no health insurance benefits. I get no time off. I get no 401(k) matching. None of that. I have to basically pay an absurd amount of money for health insurance and find ways to take time off, invent PTO policies for myself, and all these sorts of things. I've gotten used to it, but it is weird. My wife is also an independent self-employed person, so we both don't have... If we have a child, we have no mat leave, pat leave. We just have to figure that out. I don't know how I would do that. So that comes to mind for me. What else have you seen as the downside of this path?

**中文翻译:**
另一个是对于那些想往这个方向发展的听众，他们可以做些什么准备？首先，弊端是什么？我已经可以分享几个了。在我现在的生活中，没有医疗保险福利，没有带薪休假，没有 401(k) 匹配，什么都没有。我必须支付巨额的医疗保险费用，想方设法给自己放假，为自己发明带薪休假政策等等。我已经习惯了，但这确实很奇怪。我妻子也是独立经营者，所以我们都没有……如果我们有孩子，没有产假或陪产假。我们必须自己解决。我不知道该怎么办。这是我能想到的。你还看到这条路径有哪些弊端？

---

### [00:58:25] Fareed Mosavat

**English:**
Yeah, the second is it's unclear what the longevity is. How far can you be removed from your full-time experience and still be valuable? This is why I actually think this is a better path than what used to happen, which is all the great operators turned into VCs, venture capitalists. Right? In there, you're pretty disconnected from the ops. I think this advisory type path, I'll leave the creator piece alone because I'm not as familiar with it. But in the advisor path, you are still maybe spending a day a week with these companies. You are still doing. You are helping grow the next generation. I don't like to say generation, but next crop of up and coming leaders. So the question mark for me is longevity. Is it possible to build more and more amazing companies if more and more amazing operators are leaving the full-time workforce?

**中文翻译:**
是的。第二点是职业寿命不明确。你能脱离全职实战经验多久还能保持价值？这就是为什么我认为这实际上比过去的情况要好——过去所有伟大的运营者最后都变成了风险投资家（VC）。在 VC 圈，你与实际运营是相当脱节的。我认为这种顾问路径（我先不谈创作者，因为我不那么熟悉），在顾问路径中，你可能每周仍花一天时间在这些公司里。你仍在实操，你在帮助培养下一代（我不喜欢说“代”，应该说下一批）崭露头角的领导者。所以对我来说，疑问在于持久性。如果越来越多优秀的运营者离开全职工作岗位，是否还能建立越来越多令人惊叹的公司？

---

### [00:59:20] Fareed Mosavat

**English:**
I don't know, but I hope that it's better than what it's been because actually, they're building and doing, et cetera. So I think that's the other question mark and downside, and I think we think about this as part of our ecosystem. I think as long as people are doing, and generalizing, and executing, as I talked about it at the beginning, I think they can still be valuable in a meaningful way and maybe provide access to that kind of knowledge for a broader range of companies. The other is just like if everybody does it, then maybe it's not so unique anymore. So I think there's a question there as well.

**中文翻译:**
我不知道，但我希望这比以前的情况要好，因为实际上他们仍在构建和实践。所以我认为这是另一个问号和弊端。我们把这看作生态系统的一部分。我认为只要人们还在实践、通用化和执行（正如我开头所说的），他们就仍能以有意义的方式产生价值，并可能为更广泛的公司提供获取这类知识的途径。另一个问题是，如果每个人都这么做，那么这可能就不再那么独特了。所以我觉得这也是一个问题。

---

### [00:59:55] Lenny

**English:**
The other piece is like you're constantly having to do sales and BD as an advisor like, "Who's the next company?" You're always wondering if there will be more, if they stopped. It's a real part of it.

**中文翻译:**
还有一点是，作为顾问，你必须不断地做销售和业务拓展（BD），比如：“下一家公司是谁？”你总是在担心是否还会有业务，或者业务是否会停止。这是现实的一部分。

---

### [01:00:03] Fareed Mosavat

**English:**
That's why it has not been attractive to me personally, I will say. I like being focused on a singular problem for some amount of time. I do a lot of portfolio-type stuff outside. I advise casually. I do some coaching. Not coaching exactly, but mentorship for a couple of different up and coming product leaders. I do some angel investing, those kinds of things. I like to see what's happening around me, but I do like having an anchor. That's like my main thing, and I don't like selling. It turns out I don't, and so you have to like that, I think, to do some of this stuff. But I think there are things our platform at Reforge will be able to do for these kinds of offers. There's a long period of time to make that easier and easier. No promises, but stay tuned.

**中文翻译:**
这就是为什么这对我个人没有吸引力的原因。我喜欢在一段时间内专注于一个单一的问题。我在外面做很多组合式的事情：偶尔做顾问，做一些辅导（不完全是教练，而是对几位新晋产品领导者的指导），做一些天使投资之类的。我喜欢观察周围发生的事情，但我确实喜欢有一个“锚点”，那是我的主业。而且我不喜欢推销。事实证明我不喜欢，所以我认为要做这些事，你必须喜欢推销。但我认为 Reforge 平台将来能为这类需求做些事情，让它变得越来越容易。不作保证，但请保持关注。

---

### [01:00:46] Lenny

**English:**
Okay, okay. So then, going back maybe as a final question. For folks that are just like, "That sounds great. Maybe in the future, I want to become a full-time advisor, EIR person, writer person," what advice do you have for folks to set their career up for a place where they can get to a place where they can become full-time advisors, let's say?

**中文翻译:**
好的。那么回到最后一个问题。对于那些觉得“这听起来很棒，也许未来我想成为全职顾问、EIR 或创作者”的人，你有什么建议能让他们在职业生涯中做好准备，最终达到那个位置？

---

### [01:01:04] Fareed Mosavat

**English:**
This is this generalized step I talked about in the learn loop. It becomes even more important if what you want to do is not just do your current job well, but be able to communicate why that expertise is valuable to other people, other companies across a wide range of things. So I would say choose your opportunities carefully to be building the right balance of depth and breadth across different things. You need to connect dots, so you do need different data points from different types of product work and different types of organizations because you don't want to be so narrow that only DDC eCommerce company that sell once-a-year purchases or whatever is the only thing you can work on. That's just an example. I could have come up with a bunch of others.

**中文翻译:**
这就是我在学习循环中提到的“通用化”步骤。如果你不仅想做好当前的工作，还想沟通为什么你的专业知识对其他人、其他公司在广泛领域都有价值，这一点就变得更加重要。所以我会说，要谨慎选择机会，在不同事物之间建立深度和广度的平衡。你需要连接点滴，所以你确实需要来自不同类型产品工作和不同类型组织的数据点。因为你不想变得太狭隘，以至于只能为“每年只卖一次东西的 D2C 电商公司”服务。这只是个例子，我还能举出很多。

---

### [01:01:51] Fareed Mosavat

**English:**
You need to have some breadth, right, but it's like same problem, different industry. It's one way to think about depth that's focused. Different problem, same industry is another way to think about it, but you have to come up with a unique intersection that is clearly you are in the top tier of the people who know how to do that. That's a little bit nuanced. There's an art to it I think in some respects, but I think that's an important piece of the puzzle.

**中文翻译:**
你需要有一定的广度，对吧？但它也可以是“同样的问题，不同的行业”，这是思考专注深度的一种方式。或者是“不同的问题，同样的行业”，这是另一种方式。但你必须找到一个独特的交汇点，让你明显处于掌握该技能的顶尖人群之列。这有点微妙，在某些方面是一门艺术，但我认为这是拼图中重要的一块。

---

### [01:02:14] Fareed Mosavat

**English:**
Second, work at great places. I think this is good advice for almost all product managers in particular, but really, anybody working in tech, for better or for worse, where you worked matters to people for two reasons. One, it's easier to do great work at a place that is fundamentally working. When the tide is rising, there are tons of opportunities to make meaningful, deep, awesome impact. The second is what you talked about. You're going to be in the sales business eventually, and it's a lot easier to sell experience at places people have heard of than places nobody has heard of. Unfortunately, that's I think a big piece of this puzzle as well. I don't have to spend a lot of time talking about what Slack is. You probably don't have to spend a lot of time talking about what Airbnb is. I think that helps, and it is a meaningful piece of the puzzle.

**中文翻译:**
第二，在优秀的地方工作。我认为这对几乎所有 PM 来说都是好建议，实际上对任何在科技行业工作的人也是如此。无论好坏，你在哪里工作对别人来说都很重要，原因有二：第一，在一个基本面良好的地方更容易做出伟大的工作。当大潮上涨时，有无数机会产生有意义、深远且了不起的影响。第二就是你提到的，你最终会进入“销售”行业，推销在知名公司的工作经验比推销没人听过的公司要容易得多。不幸的是，我认为这也是拼图中非常重要的一部分。我不必花太多时间解释 Slack 是什么，你可能也不必花太多时间解释 Airbnb 是什么。我认为这很有帮助，是拼图中很有意义的一块。

---

### [01:03:04] Lenny

**English:**
Absolutely. Fareed, I feel like anybody that listen to this episode is going to be a better product manager. I'm very confident of that, and I'm really appreciative.

**中文翻译:**
绝对是。Fareed，我觉得任何听了这一集的人都会成为更好的产品经理。我对此非常有信心，也非常感激。

---

### [01:03:13] Fareed Mosavat

**English:**
I hope so.

**中文翻译:**
希望如此。

---

### [01:03:14] Lenny

**English:**
I'm sure of it. So, just to close, where can folks find you online if they want to reach out, learn more, and how can listeners be useful to you?

**中文翻译:**
我确定。最后，如果大家想联系你或了解更多信息，可以在哪里找到你？听众能为你提供什么帮助吗？

---

### [01:03:21] Fareed Mosavat

**English:**
You can find me on Twitter almost most days, F-A-R-3-3-D. That's been my handle since I was a young man.

**中文翻译:**
你几乎每天都能在 Twitter 上找到我，账号是 F-A-R-3-3-D。这是我年轻时就一直用的账号。

---

### [01:03:29] Lenny

**English:**
So complicated.

**中文翻译:**
真复杂。

---

### [01:03:30] Fareed Mosavat

**English:**
So check me out there. It's just threes instead at Es, right? That's probably my social network of choice and best place to communicate or hear what I'm thinking about or what I'm doing. Obviously, I do a ton of work at Reforge. On our events, I toast a bunch of different things, do a lot of stuff. If you're interested in these kinds of topics, please, I don't want to make this a sales pitch, but we have a lot of programs that are dedicated to deep dives into the problems that we've talked about here. I'm dedicating this next chapter of my career to helping a wider range of product leaders be great at their jobs, and that's what we do for a living. I hope that we can help folks there.

**中文翻译:**
去那里找我吧。就是把字母 E 换成数字 3。那是我首选的社交网络，也是交流或了解我在想什么、在做什么的最佳场所。显然，我在 Reforge 做了大量工作。在我们的活动中，我主持各种环节，做很多事情。如果你对这类话题感兴趣，我不想把它变成推销，但我们有很多课程专门深入探讨我们今天聊到的这些问题。我职业生涯的下一个阶段将致力于帮助更广泛的产品领导者在工作中表现出色，这就是我们的事业。我希望我们能在那方面帮到大家。

---

### [01:04:06] Fareed Mosavat

**English:**
As to what people can help me with, I don't know. I'm always looking for people working on interesting stuff or with interesting, unique problems. If you're a founder working on something interesting and you're looking for an advisor, practical advisor, not for me, but we have a wide range of network experts that I'd be happy to connect folks with. If you're a product manager on a team that's looking to figure out how to break through on certain problems, reach out. Maybe we can help with Reforge or maybe I can help individually.

**中文翻译:**
至于大家能帮我什么，我不知道。我总是在寻找那些在做有趣事情或面临有趣、独特问题的人。如果你是一个正在做有趣项目的创始人，并且在寻找顾问（实战型顾问，不一定是我，我们有广泛的专家网络），我很乐意帮忙引荐。如果你是一个团队中的 PM，正试图弄清楚如何突破某些问题，请联系我。也许 Reforge 能帮上忙，或者我也能提供个人建议。

---

### [01:04:35] Lenny

**English:**
Thanks for being here, Fareed.

**中文翻译:**
谢谢你能来，Fareed。

---

### [01:04:36] Fareed Mosavat

**English:**
Yeah. Cheers. Thanks for having me, Lenny. I think what you're doing is wonderful and making a big difference for PMs everywhere, so thank you.

**中文翻译:**
好的，干杯。谢谢你的邀请，Lenny。我认为你所做的事情非常棒，为各地的 PM 带来了巨大的改变，所以谢谢你。

---

### [01:04:44] Lenny

**English:**
Same. Thanks, man.

**中文翻译:**
彼此彼此。谢谢，伙计。

---

### [01:04:45] Fareed Mosavat

**English:**
Cheers.

**中文翻译:**
干杯。

---

### [01:04:47] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期节目再见。