# Garrett Lord - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Garrett Lord, CEO of Handshake.

---

### [00:00:00] Garrett Lord

**English:**
There will never be a time like this. I've never seen anything like it. I doubt I'll ever feel anything like this in business again where there's unlimited demand. How do you make sure that three months from now, six months, you have no regrets? Get on the plane to go talk to a customer, make the late night push, check the data six times over again.

**中文翻译:**
再也不会有这样的时代了。我从未见过类似的情况。我怀疑在我的商业生涯中，是否还能再次感受到这种需求无限的状态。你如何确保三个月后、六个月后，你不会感到后悔？那就去赶飞机和客户面谈，熬夜冲刺，把数据反复检查六遍。

---

### [00:00:15] Lenny Rachitsky

**English:**
Your company creates new data to continue advancing the intelligence of models. This is a business that you built on top of a business you've already had.

**中文翻译:**
你的公司通过创造新数据来持续提升模型的智能水平。这是你在原有业务基础上建立起来的新业务。

---

### [00:00:24] Garrett Lord

**English:**
We're the largest expert network in the world. We have this massive strategic advantage, which is like no customer acquisition costs. The only moat in human data is access to an audience.

**中文翻译:**
我们是全球最大的专家网络。我们拥有巨大的战略优势，那就是几乎没有获客成本。在人类数据领域，唯一的护城河就是触达受众的能力。

---

### [00:00:33] Lenny Rachitsky

**English:**
You guys come in after the model's trained to tweak the weights based on additional data that you you've created.

**中文翻译:**
你们在模型训练完成后介入，根据你们创造的额外数据来微调权重。

---

### [00:00:38] Garrett Lord

**English:**
The models have gotten so good that the generalists are no longer needed. What they really need is experts.

**中文翻译:**
模型已经变得如此强大，以至于不再需要通才了。它们真正需要的是专家。

---

### [00:00:44] Lenny Rachitsky

**English:**
There's this tension between all these students training models to become smarter, and then there's that they will have harder time potentially finding jobs.

**中文翻译:**
现在存在一种张力：一方面学生们在训练模型变得更聪明，另一方面，这可能会让他们以后找工作变得更困难。

---

### [00:00:52] Garrett Lord

**English:**
That's not what we're hearing from our employers, this is just enabling human beings to be even more productive. You used to put a Google Search on a skill on your resume because you grew up with Google. Being AI native, young people are at a huge advantage.

**中文翻译:**
这并不是我们从雇主那里听到的反馈，这只是在赋能人类变得更高效。以前你会把“谷歌搜索”作为一项技能写在简历上，因为你是伴随谷歌长大的。作为“AI 原住民”，年轻人拥有巨大的优势。

---

### [00:01:05] Lenny Rachitsky

**English:**
Today my guest is Garrett Lord. Garrett is the co-founder and CEO of Handshake, which is one of the most interesting and incredible AI success stories that you probably haven't heard of. Handshake has been around for over 10 years, they're essentially LinkedIn for college students, it's a place for students to connect with companies to find a job. They are the platform of choice for every single Fortune 500 company. Over 1,500 colleges, over 20 million students and alumni, and over 1 million companies use them to hire graduates. At the start of this year, Garrett and his team realized that their huge proprietary network of students, including tens of thousands of PhDs and master's students, is extremely valuable to AI labs to help them create and label high quality training data. So, they launched a new business from zero to one in January. Four months later, they hit 50 million ARR. They're now on pace to blow past 100 million ARR within just 12 months. They'll exceed the revenue that they're making with their decade old business in under two years.

**中文翻译:**
今天的嘉宾是 Garrett Lord。Garrett 是 Handshake 的联合创始人兼 CEO，这可能是你从未听说过的最有趣、最不可思议的 AI 成功案例之一。Handshake 已经成立 10 多年了，它本质上是面向大学生的 LinkedIn，是学生与公司建立联系并找工作的地方。它是每一家财富 500 强公司的首选平台。超过 1500 所大学、2000 多万名学生和校友，以及 100 多万家公司都在使用它来招聘毕业生。今年年初，Garrett 和他的团队意识到，他们庞大的专有学生网络（包括数万名博士生和硕士生）对 AI 实验室极具价值，可以帮助他们创建和标注高质量的训练数据。于是，他们在 1 月份启动了一项从 0 到 1 的新业务。四个月后，他们的年度经常性收入（ARR）达到了 5000 万美元。现在，他们有望在短短 12 个月内突破 1 亿 ARR。在不到两年的时间里，这项新业务的收入就将超过他们经营了十年的老业务。

---

### [00:02:04] Lenny Rachitsky

**English:**
This is a truly incredible and rare story, and one that I think a lot of teams can learn from because AI is creating a lot of opportunity but also a lot of potential disruption, and this is an amazing story where the company basically disrupted themselves. This episode is packed with insights, including a primer on what the heck are people actually doing when they're labeling and creating data to train models? A huge thank you to Garrett for making time for this, his wife just had a baby this week. He's also in the middle of scaling this insane new business. So thank you, Garrett. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube.

**中文翻译:**
这是一个真正令人难以置信且罕见的故事，我认为很多团队都可以从中学习，因为 AI 在创造大量机会的同时，也带来了巨大的潜在颠覆。这是一个公司基本上“自我颠覆”的精彩案例。本期节目充满了洞见，包括对“人们在标注和创建模型训练数据时到底在做什么”的基础介绍。非常感谢 Garrett 抽时间参加，他的妻子这周刚生了宝宝。他目前也正忙于扩展这项疯狂的新业务。谢谢你，Garrett。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。

---

### [00:02:39] Lenny Rachitsky

**English:**
Also, if you become an annual subscriber of my newsletter, you get a year free of a bunch of incredible products, including Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD, and Mobbin. Check it out at lennysnewsletter.com and click bundle. With that, I bring you Garrett Lord.

**中文翻译:**
此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你将获得一堆优秀产品的一年免费使用权，包括 Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD 和 Mobbin。请访问 lennysnewsletter.com 并点击“bundle”查看。下面，让我们欢迎 Garrett Lord。

---

### [00:03:01] Lenny Rachitsky (Sponsor: CodeRabbit)

**English:**
This episode is brought to you by CodeRabbit, the AI code review platform transforming how engineering teams ship faster with AI without sacrificing code quality. Code reviews are critical, but time-consuming. CodeRabbit acts as your AI co-pilot, providing instant code review comments and potential impacts of every pull request. Beyond just flagging issues, CodeRabbit provides one click fix suggestions and lets you define custom code quality rules using AST GREP patterns, catching subtle issues that traditional static analysis tools might miss. CodeRabbit also provides free AI code reviews directly in the IDE. It's available in VS Code, Cursor and Windsurf. CodeRabbit has so far reviewed more than 10 million PRs installed on 1 million repositories, and is used by over 70,000 open source projects. Get CodeRabbit for free for an entire year at coderabbit.ai using code Lenny. That's coderabbit.ai.

**中文翻译:**
本期节目由 CodeRabbit 赞助。CodeRabbit 是一个 AI 代码审查平台，它正在改变工程团队在不牺牲代码质量的情况下利用 AI 加快交付速度的方式。代码审查至关重要，但非常耗时。CodeRabbit 充当你的 AI 副驾驶，为每个拉取请求（PR）提供即时的审查评论和潜在影响分析。除了标记问题，CodeRabbit 还提供一键修复建议，并允许你使用 AST GREP 模式定义自定义代码质量规则，捕捉传统静态分析工具可能遗漏的细微问题。CodeRabbit 还直接在 IDE 中提供免费的 AI 代码审查，支持 VS Code、Cursor 和 Windsurf。到目前为止，CodeRabbit 已经审查了超过 1000 万个 PR，安装在 100 万个仓库中，并被超过 7 万个开源项目使用。使用代码“Lenny”，在 coderabbit.ai 免费获取一整年的 CodeRabbit。

---

### [00:03:58] Lenny Rachitsky (Sponsor: Orkes)

**English:**
This episode is brought to you by Orkes, the company behind Open Source Conductor, the orchestration platform powering modern enterprise apps and agentic workflows. Legacy automation tools can't keep pace, siloed low-code platforms, outdated process management and disconnected API tooling fall short in today's event-driven AI-powered agentic landscape. Orkes changes this. With Orkes Conductor, you gain an agentic orchestration layer that seamlessly connects humans, AI agents, APIs, microservices, and data pipelines in real time at enterprise scale. Visual and code-first development, built-in compliance, observability and rock solid reliability ensure workflows evolve dynamically with your needs. It's not just about automating tasks, it's orchestrating autonomous agents and complex workflows to deliver smarter outcomes faster. Whether modernizing legacy systems or scaling next-gen AI-driven apps, Orkes accelerates your journey from idea to production. Learn more and start building at orkes.io/Lenny. That's O-R-K-E-S.io/Lenny.

**中文翻译:**
本期节目由 Orkes 赞助。Orkes 是开源项目 Conductor 背后的公司，Conductor 是为现代企业应用和智能体（agentic）工作流提供动力的编排平台。传统的自动化工具已无法跟上步伐，孤立的低代码平台、过时的流程管理和脱节的 API 工具在当今事件驱动、AI 驱动的智能体环境中显得力不从心。Orkes 改变了这一点。通过 Orkes Conductor，你可以获得一个智能体编排层，在企业规模下实时无缝连接人类、AI 智能体、API、微服务和数据管道。可视化和代码优先的开发模式、内置的合规性、可观测性和极高的可靠性，确保工作流能根据你的需求动态演进。这不仅仅是任务自动化，更是编排自主智能体和复杂工作流，以更快地交付更智能的结果。无论是改造旧系统还是扩展下一代 AI 驱动的应用，Orkes 都能加速你从创意到投产的进程。访问 orkes.io/Lenny 了解更多并开始构建。

---

### [00:05:04] Lenny Rachitsky

**English:**
Garrett, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Garrett，非常感谢你能来。欢迎来到播客。

---

### [00:05:07] Garrett Lord

**English:**
Yeah, thanks for having me. A long-time subscriber.

**中文翻译:**
好的，谢谢邀请。我是你的长期订阅者。

---

### [00:05:09] Lenny Rachitsky

**English:**
I appreciate that. Okay, so before we get into the insane trajectory that your data labeling business is on, which is just an amazing story that I think a lot of founders and product teams that are trying to navigate this AI disruption that's happening will have a lot to learn from. I want to first help people understand what the hell data labeling actually is. Just like, what are people actually doing? Why is this so valuable? Some of the most, I don't know, fastest-growing companies in the world today, including you guys are just, this is what you do. Clearly there's something really important here. I sort of understand it, probably not really. I think a lot of listeners feel the same way. So let me just ask you this, what is data labeling actually? What are people actually doing? And then, just why is this so valuable to frontier AI labs?

**中文翻译:**
非常感谢。在聊你们数据标注业务那疯狂的发展轨迹之前（这真的是个精彩的故事，我觉得很多正在应对 AI 变革的创始人和产品团队都能学到很多），我想先帮大家搞清楚，到底什么是“数据标注”？人们具体在做什么？为什么它这么值钱？现在世界上一些增长最快的公司，包括你们，都在做这个。显然这里面大有文章。我大概懂一点，但可能不深。我觉得很多听众也有同感。所以我想问，数据标注到底是什么？人们在干什么？为什么它对前沿 AI 实验室如此重要？

---

### [00:05:55] Garrett Lord

**English:**
Yeah. So, I think it's helpful to take a step back of what does training a model look like? So, there's really two primary functions. There's a pre-training and a post-training process in training a model, and for a long time these AI providers, or LLMs, or Frontier Labs we're focused on basically sucking up more and more information on the pre-training side of the house. And that's basically the entire corpus of written human knowledge. So, that's not just written, but every YouTube video, every book, basically the pursuit of sucking up everything that was on the internet, and that was the pre-training side. And there was a lot of gains from pre-training, like models continue to get better. And about 18 months ago, 24 months ago, we started to really see an asymptoting of gains coming from, because they had essentially sucked up all of the knowledge on the internet. And so, labs really shifted towards most of the gains now coming from the post-training side of the house.

**中文翻译:**
好的。我觉得退一步先看看“训练模型”是什么样子的会很有帮助。训练模型主要有两个功能：预训练（pre-training）和后训练（post-training）。长期以来，这些 AI 提供商、大语言模型（LLM）或前沿实验室都专注于在预训练阶段吸收越来越多的信息。这基本上涵盖了人类书面知识的整个语料库。不仅是文字，还有每个 YouTube 视频、每本书，基本上就是要把互联网上的所有东西都吸纳进来，这就是预训练。预训练带来了很多收益，模型持续变强。但大约在 18 到 24 个月前，我们开始看到预训练带来的收益趋于平缓（asymptoting），因为他们基本上已经吸干了互联网上所有的知识。因此，实验室的重点转向了后训练阶段，现在大部分的提升都来自这里。

---

### [00:06:50] Garrett Lord (Continued)

**English:**
And what post-training is, is it's augmenting and improving the data they have across every discipline or capability area that they care about. So take coding, or mathematics, or law or finance, they are focused on collecting high quality data that really improves the state of our capabilities, their models, and you can see a lot of these popular benchmarks on what are called model parts. When Llama IV is released, you'll see the benchmarks across various domains, and each one of the research teams inside of the labs have different use cases. Basically they're running experiments, almost think like the scientific process. They have a hypothesis around how to improve the model. They're trying to collect small pieces of data to see if that hypothesis works out. If that hypothesis is proving true, then they expand the overall collection of the data in that advert. And it could look like reinforcement learning environments, it could look like trajectories, it could be audio and multimodal, it can be text-based like prompt-response pairs.

**中文翻译:**
所谓的后训练，就是在他们关心的每个学科或能力领域增强和改进现有的数据。以编程、数学、法律或金融为例，他们专注于收集高质量的数据，以真正提升模型的能力。你可以看到很多关于“模型部件”的热门基准测试。当 Llama 4 发布时，你会看到各个领域的基准测试，实验室内部的每个研究团队都有不同的用例。基本上他们是在做实验，就像科学研究过程一样。他们有一个关于如何改进模型的假设，然后尝试收集少量数据来看看这个假设是否成立。如果假设被证明是正确的，他们就会扩大该方向的数据收集规模。这可能表现为强化学习环境、操作轨迹（trajectories）、音频和多模态数据，也可以是基于文本的“提示-响应”对（prompt-response pairs）。

---

### [00:07:58] Garrett Lord (Continued)

**English:**
It can also be reinforcement learning with human feedback, which is like preference ranking data. And so, that's the state of the art of models. And most of the gains that are happening from models right now are coming from the post-training side of the house. And there's just an incredible amount of demand to stay at the absolute frontier of where models are going.

**中文翻译:**
它也可以是基于人类反馈的强化学习（RLHF），比如偏好排序数据。这就是目前模型的最前沿状态。目前模型取得的大部分进步都来自后训练端。为了保持在模型发展的绝对前沿，市场对这类数据的需求量大得惊人。

---

### [00:08:20] Lenny Rachitsky

**English:**
So training, pre-training is feeding it, say the entire internet. Here's like all the data that the humans have ever created, figure out knowledge and facts, and how to reason and all these things. Post-training, is it correct to say there's essentially two buckets of things to do? There's reinforcement learning, human feedback RLHF, and then there's kind of this bucket of fine-tuning?

**中文翻译:**
所以预训练就是喂给它整个互联网的数据，比如人类创造的所有数据，让它学习知识、事实、推理等等。而后训练，是不是可以理解为主要有两大类工作：一类是基于人类反馈的强化学习（RLHF），另一类是某种形式的微调（fine-tuning）？

---

### [00:08:41] Garrett Lord

**English:**
I mean, yes and no because take for example trajectories, or you want to be able to do, people use flight search or an accounting end-to-end process, or you want to be able to conduct biological experiments, you need actual trajectory data. There's still very much, a lot of the labs are still, they have points of view on what data collect. It's evolving very quickly. But I think reinforcement learning is really preference ranking, like which question do you like more, question A or question B? SFT data is a prompt and a response, and obviously the labs are very focused on these thinking or reasoning models. So, in order to improve a reasoning model you need to actually have the step-by-step instructions, of which when you interact with a lot of these frontier models they struggle in very advanced domains. And so, I think there's a variety of data that they're working with to improve capabilities in their models.

**中文翻译:**
可以这么说，但也不完全是。因为以“轨迹数据”为例，如果你想让模型学会使用航班搜索、处理会计端到端流程，或者进行生物实验，你需要实际的操作轨迹数据。很多实验室对于收集什么数据都有自己的见解，而且进化得非常快。我认为强化学习主要是偏好排序，比如你更喜欢 A 还是 B？而 SFT（有监督微调）数据是“提示”和“响应”的配对。显然，实验室现在非常关注这些思考或推理模型。为了改进推理模型，你需要提供具体的步骤说明。当你与许多前沿模型互动时，你会发现它们在非常高级的领域表现挣扎。因此，他们正在使用各种各样的数据来提升模型的能力。

---

### [00:09:39] Lenny Rachitsky

**English:**
What I'm hearing is there's other ways to post-train. Which of these are you guys focused on? Where do you help models most of these three-ish buckets?

**中文翻译:**
我听明白了，后训练还有其他方式。你们主要关注哪一种？在这三类工作中，你们对模型的帮助最大的是哪一块？

---

### [00:09:48] Garrett Lord

**English:**
Our real unique proposition as a business is the fact that we have an engaged audience. We have 18 million professionals across, we have 500,000 PhDs, we have 3 million master students, we're a global platform. And so, depending on what you're looking for across any area, academic knowledge, what is the definition of a PhD? How do you get your PhD? You defend your thesis. Defending your thesis means, generally speaking, you have proven that you have extended the world's knowledge in a particular domain. And so, the ability to hyper-target this audience into chemistry, math, physics, biology, coding and really touch parts of human knowledge that have never before made it to the internet is really where we excel. And I would say that when you talk about the labeling market, something to make it more abstract is like it used to be generalists' work.

**中文翻译:**
我们业务真正的独特主张在于我们拥有一个高参与度的受众群体。我们拥有 1800 万专业人士，其中包括 50 万名博士和 300 万名硕士，我们是一个全球性平台。无论你需要哪个领域的学术知识——博士的定义是什么？如何获得博士学位？你需要通过论文答辩。答辩意味着，通常来说，你已经证明自己在特定领域扩展了人类的知识边界。因此，我们能够精准定位这些受众，涵盖化学、数学、物理、生物、编程等领域，触及那些从未出现在互联网上的人类知识，这正是我们的擅长之处。我想说，谈到标注市场，以前更多是“通才”的工作。

---

### [00:10:52] Garrett Lord (Continued)

**English:**
A lot of the market before the model started to get better was leveraging talented international lower cost labor to do basic generalist tasks. But really what's happened is the models have gotten so good that the generalists are no longer needed. What they really need is experts, experts across every area that the models are focused on. And really, you could think about these model builders as they're focused on the most economically valuable capability areas in the economy. And so that, generally speaking, right now is focused on advanced STEM domains, advanced science and math domains, and then the derivative functions of accounting, law, medicine, finance, where they want to make the models more capable. And then the work that we're doing, I think to come full circle to your question, we're doing work across so many domains. I mean, we have millions of bachelor students that are being used for work in audio, work in customizing a model depending on the voice and tone, where you are geographically in the country, what do women versus men prefer? All the way to the most advanced PhD STEM domains out there.

**中文翻译:**
在模型变得更强大之前，大部分市场都在利用廉价的国际劳动力来完成基础的通才任务。但现在的情况是，模型已经变得非常出色，不再需要通才了。它们真正需要的是专家，是模型所关注的每一个领域的专家。你可以认为这些模型构建者正专注于经济中最具价值的能力领域。目前，这通常集中在高级 STEM（科学、技术、工程、数学）领域、高级科学和数学领域，以及会计、法律、医学、金融等衍生功能领域，他们希望提升模型在这些方面的能力。回到你的问题，我们正在开展跨领域的各种工作。我们有数百万名本科生参与音频工作、根据语音语调定制模型、根据地理位置或性别偏好进行调整，一直延伸到最尖端的博士级 STEM 领域。

---

### [00:12:08] Lenny Rachitsky

**English:**
Okay. So, is it fair to say essentially all the data that is available has been trained on, and your company creates new data, new knowledge to continue advancing the intelligence of models?

**中文翻译:**
明白了。所以可以这么说吗：基本上所有现成的可用数据都已经被训练过了，而你们公司正在创造新的数据和新的知识，以继续推进模型的智能？

---

### [00:12:22] Garrett Lord

**English:**
Yep. And I also say we help point out where the models are weak. So, in order to break a model, it's pretty tough for the average person to break a model and get an incorrect response. But if you are a PhD in physics, you can go in multiple subdomains of physics and prove where the model's actually breaking, either breaking in its reasoning steps or it's where it's broken in its ground truth right answer, or we start throwing tools in there or needing to follow some step-by-step process. And I wouldn't say it's easy for them, but the average person cannot break the models and that's where we really come in.

**中文翻译:**
是的。而且我还想说，我们帮助指出模型的弱点。普通人很难“玩坏”模型并让它给出错误的回答。但如果你是物理学博士，你可以深入物理学的多个子领域，证明模型在哪些地方出错了——可能是推理步骤错了，也可能是最终答案错了，或者是当我们需要它使用工具或遵循特定步骤时它乱了套。我不会说这对专家来说很容易，但普通人确实无法突破模型的极限，而这正是我们的用武之地。

---

### [00:13:03] Lenny Rachitsky

**English:**
So, essentially it's just catching mistakes that the model has made. Okay. So, what are these people actually doing? I know there's all kinds of different types, you described all the ways that data's generated, what kind of data is useful? So, maybe just the most common examples. Let's say a PhD person is sitting there doing stuff, what are they actually doing?

**中文翻译:**
所以，本质上就是捕捉模型犯的错误。好的。那么这些人具体在做什么呢？我知道有很多不同类型，你描述了各种数据生成方式，什么样的数据是有用的？能不能举几个最常见的例子，比如一个博士坐在那里，他具体在干什么？

---

### [00:13:22] Garrett Lord

**English:**
A great example is a public paper called GPQA. So, for the engineers out there that want to read about it, essentially the crux of the paper is you break the model, you provide a ground truth, the right answer to the question, you provide the step-by-step a reasoning steps. So, you might imagine because models are non-deterministic, the model can get the answer right once, but it might not get the answer right three out of five times. So, you actually prove where the model's failing. You actually break down into where is it failing? Maybe it can get, it knows the question, it can get the right answer, but the actual steps to get there are wrong and they really focus on the steps to get there. Say there's 10 steps in a math problem, step 6 through 10 is wrong. So, how do you fix the actual steps?

**中文翻译:**
一个很好的例子是名为 GPQA 的公开论文。对于想了解它的工程师来说，这篇论文的核心是：你突破模型的极限，提供一个“标准答案”（ground truth），并提供详细的推理步骤。你可以想象，因为模型是非确定性的，它可能某一次答对了，但五次里可能有三次答错。所以，你要证明模型在什么地方失败了。具体分解开来：它是在哪一步失败的？也许它理解问题，也能给出正确答案，但中间的步骤是错的，而实验室非常关注这些步骤。假设一个数学题有 10 个步骤，第 6 到第 10 步错了，那么你该如何修正这些步骤？

---

### [00:14:11] Garrett Lord (Continued)

**English:**
And what are they doing? So they're going in, we're really focused on calling this branding the experience and treating people like experts. PhD students expect to be treated different than a lower cost international labor with a different work expectation. And so, these PhDs come into a community, we have a instructional design team and an assessments team that's going through and basically iteratively helping them understand how to use the tools that we built, and how to interact with the latest models. Then they go in and start actually creating data. And that process is, on our side the model builders, they want to know that the data we're producing is high quality. Som we have our own research team, our own post-training team. I hired a gentleman from Meta that went along on the post-training over there, and I-

**中文翻译:**
他们在做什么？他们进入我们的系统，我们非常注重这种体验的品牌化，把他们当作专家对待。博士生期望得到的待遇与廉价国际劳动力完全不同。这些博士加入一个社区，我们有教学设计团队和评估团队，迭代地帮助他们理解如何使用我们开发的工具，以及如何与最新的模型互动。然后他们开始实际创建数据。在我们的模型构建者看来，他们需要确保我们产出的数据是高质量的。所以我们有自己的研究团队和后训练团队。我从 Meta 挖来了一位负责过那边后训练工作的专家，我——

---

### [00:14:57] Lenny Rachitsky

**English:**
Hope you paid him well.

**中文翻译:**
希望你给他的薪水很高。

---

### [00:14:59] Garrett Lord

**English:**
Yeah. So, war for AI talent is very expensive, but super, super privileged and proud to be working with him. And so, each unit of data, we have to build it an environment for them to actually create the data. Then we have to understand in a unit level we're trying to approximate the actual gain from that piece of data and whether it can improve in a particular capability area. And then, we're also focused on evolving the use cases to also follow what the model builders want, which is they want more more real world tool use and trajectory based data as well.

**中文翻译:**
是的。AI 人才争夺战非常昂贵，但能和他一起工作我感到非常荣幸和自豪。对于每一个数据单元，我们必须为他们构建一个实际创建数据的环境。然后我们需要在单元层面理解，这块数据能带来多少实际收益，以及它是否能提升特定的能力领域。此外，我们还专注于演进用例，以符合模型构建者的需求，即他们想要更多真实世界的工具使用数据和基于轨迹的数据。

---

### [00:15:33] Lenny Rachitsky

**English:**
Okay. There's so much here, and we could go infinitely down here but I think that this is really interesting because just like people hear so much about all of this and they barely understand what the hell it actually is. So, this is for me really interesting. I think it's going to help a lot of people. So essentially a PhD, say a biologist, biology PhD is just their job is find flaws in what, say ChatGPT is producing, and then come up with here's the correct answer. And that is used to fine tune the mode, here's something you are doing incorrectly, here's the correct answer and that improves the model.

**中文翻译:**
好的。这里面的信息量太大了，我们可以无限深入聊下去，但我认为这非常有趣，因为人们听过很多相关传闻，却很少有人真正理解它到底是什么。所以对我来说这很有意思，我觉得这会帮到很多人。所以本质上，一个博士，比如生物学博士，他的工作就是找出 ChatGPT 产出内容中的缺陷，然后给出正确答案。这被用来微调模型：告诉模型“这里你做错了，这是正确答案”，从而改进模型。

---

### [00:16:03] Garrett Lord

**English:**
Yeah. I mean, a great example, let's take a non-verifiable domain like education. So there's a PhD student, Rachel on the network, she got her PhD from the University of Miami, spent two decades as a teacher teaching students in the eighth grade. And she was an adjunct professor at a local community college in the field of education. And so, she is interacting with the state-of-the-art models in educational design. So, actually trying to understand what is the best way to teach people, and how do you spot incorrect issues in a model in the way that they're training people, and help the models understand the forefront of educational design with the hands-on experience of being an eighth grade teacher for 10 plus years and having a PhD in education? So, that's an example of you can have that all the way down to a verifiable engineering problem that you're seeing the latest models fail on.

**中文翻译:**
是的。举个例子，让我们看一个像教育这样“不可验证”的领域。我们网络中有一位博士生叫 Rachel，她在迈阿密大学获得博士学位，当了 20 年的八年级教师，还是当地社区大学教育领域的兼职教授。她正在与最先进的教育设计模型互动。她尝试理解什么是最好的教学方式，如何发现模型在培训人员时的错误，并利用她 10 多年八年级教师的实战经验和教育学博士背景，帮助模型理解教育设计的前沿。这是一个例子，你可以把这种模式一直应用到最新的模型都会出错的、可验证的工程问题上。

---

### [00:17:12] Garrett Lord (Continued)

**English:**
Yeah, I think that gives you the gamut. You also have, we talk about professional domains like these reinforcement learning environments, there's a bunch of papers out there that basically speak to people narrating over their step-by-step tool use. So, as they go to solve a problem from start to finish, interact with multiple different service areas, interact with multiple different tools, they're like, there's papers that talk about this, talking over what they're doing, actually following and screen recording where their mouse is going, how they're problem solving. When they run into a roadblock, what do they do? So, they really want to understand how humans think.

**中文翻译:**
是的，这涵盖了整个范围。我们还谈到了专业领域，比如这些强化学习环境。有很多论文提到让人们在逐步使用工具时进行旁白。当他们从头到尾解决一个问题，与多个不同的服务领域和工具互动时，他们会边做边说，系统会进行屏幕录制，记录鼠标的移动轨迹以及他们如何解决问题。当他们遇到障碍时，他们会怎么做？实验室真的想理解人类是如何思考的。

---

### [00:17:50] Lenny Rachitsky

**English:**
You mentioned this term trajectory. Can you just explain what that actually means? Because it feels like you've mentioned that a few times and that feels important to all this.

**中文翻译:**
你提到了“轨迹”（trajectory）这个词。你能解释一下它具体是什么意思吗？因为你提了好几次，感觉这对整个事情很重要。

---

### [00:17:56] Garrett Lord

**English:**
Yeah. A trajectory is basically just like the entire environment that is collecting what you're doing. So it's your screen, it's your mouse-

**中文翻译:**
是的。轨迹基本上就是记录你操作过程的整个环境。包括你的屏幕、你的鼠标——

---

### [00:18:04] Lenny Rachitsky

**English:**
Oh, I see. Oh, wow.

**中文翻译:**
噢，明白了。哇。

---

### [00:18:05] Garrett Lord

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:18:06] Lenny Rachitsky

**English:**
Including this voiceover, okay. And then, this might be too technical, but what is the output of all this work? This, say teacher, is it just like a JSON file, an XML file, like a text file?

**中文翻译:**
还包括旁白，明白了。这可能有点太技术化了，但这些工作的输出结果是什么？比如那位老师的工作，最后是一个 JSON 文件、XML 文件还是文本文件？

---

### [00:18:15] Garrett Lord

**English:**
Yeah, it can be managed JSON data.

**中文翻译:**
是的，可以是经过管理的 JSON 数据。

---

### [00:18:17] Lenny Rachitsky

**English:**
JSON data? Okay.

**中文翻译:**
JSON 数据？好的。

---

### [00:18:18] Garrett Lord

**English:**
And then, we also have multimodal work like audio, like classifying music and understanding ... We're engaging thousands, or not thousands, probably hundreds of top music students at the music schools in the country who are improving models of understanding of music. And you also have the thing called, which we haven't talked about here, a rubrics, and rubric models are, you can put a model in as a judge. What is a good educational design, or what's a good MRI result? In some of these domains, you actually don't have a guaranteed correct right answer. And so, models can sit in the middle as a judge and actually understand what is ... Think back on your school days. How do you get A on your 5,000 word paper? Well, there's a great introductory statement and there's scientific proof. So, you can build a rubric that allows a model to sit in the middle and actually auto-evaluate responses. We're seeing a lot of rubrics work as well.

**中文翻译:**
此外，我们还有多模态工作，比如音频，像音乐分类和理解……我们聘请了全国音乐学院的数百名顶尖音乐学生，他们正在改进模型对音乐的理解。还有一种我们还没聊到的东西叫“评分标准”（rubrics）。评分标准模型可以作为裁判。什么是好的教育设计？什么是好的 MRI 结果？在某些领域，其实并没有一个绝对正确的标准答案。因此，模型可以作为裁判坐在中间，理解什么是……回想一下你的学生时代，5000 字的论文怎么拿 A？要有精彩的开篇，要有科学论证。所以你可以建立一个评分标准，让模型自动评估回答。我们也看到了很多关于评分标准的工作。

---

### [00:19:28] Lenny Rachitsky

**English:**
And you would think, why would you trust this one teacher's opinion that this is the right way to do it? But what's cool is the market speaks for itself. If these models are being used more and more, and people love them and value them, I imagine steps in between to verify this is good and other people think this is a good idea. It feels like the market dynamics will tell you if the data you're providing is correct at what people want. Is there something more there?

**中文翻译:**
人们可能会想，为什么要相信这一个老师关于“正确方法”的观点？但酷的地方在于市场会说话。如果这些模型被越来越多的人使用，且大家都很喜欢并认可它们的价值，我猜中间肯定有验证步骤来确保这是好的。感觉市场动态会告诉你，你提供的数据是否正是人们想要的。还有其他的吗？

---

### [00:19:52] Garrett Lord

**English:**
I didn't get a PhD in AI, or math, or physics, and I haven't trained myself, we have frontier models, but there is a lot to each unit of data whether it's improving. There's a ton of science and research out right now around how do you make sure that the data that you're producing is improving the model? And it's very hard for model builders to understand. They really care about, to zoom out, they care about three things. They care about quality first and foremost. You have to have high quality data. And if you imagine you're training a model, like teaching a student and you're giving it the wrong data, it's extremely challenging to overcome that. So, quality is first and foremost. And then, the other huge problems you have is volume. How do you generate thousands of pieces of data in the most advanced domains of chemistry, and mathematics, and physics, and how do you ensure that it's high quality?

**中文翻译:**
我没有 AI、数学或物理的博士学位，我也没亲自训练过模型，虽然我们有前沿模型。但每一个数据单元是否真的带来了改进，这其中大有学问。现在有大量的科学研究是关于“如何确保你产生的数据能改进模型”的。这对模型构建者来说很难理解。总的来说，他们关心三件事。首先也是最重要的，是质量。你必须拥有高质量的数据。想象一下你在训练一个模型，就像教学生一样，如果你教错了，以后很难纠正。所以质量是第一位的。其次是规模（volume）。你如何在化学、数学、物理等最先进的领域生成成千上万条数据，并确保它们都是高质量的？

---

### [00:20:48] Garrett Lord (Continued)

**English:**
Well for us, say in physics, we just reach out to students at Stanford, and Berkeley, and MIT, and they're at the top GPA at the best physics schools in the country. And so, our ability to get to scale or volumes of data, to produce very high quality data, is something they care deeply about. And then, the other thing I would say model builders care about is speed, because they have all these hypotheses and they're constantly testing different pipelines. And so, you might have three or four bets going at once, and then as soon as one is actually showing a gain, imagine you're a researcher or you're assigned to the processes, once you're running a gain then you're trying to grow that pipeline and grow that piece of data that's actually improving it, and you're maybe ditching two or three other projects you had that weren't showing improvement.

**中文翻译:**
对我们来说，比如物理领域，我们直接联系斯坦福、伯克利和麻省理工的学生，他们是全国顶尖物理学院里 GPA 最高的。因此，我们大规模产出极高质量数据的能力，是他们非常看重的。第三点是速度。模型构建者有很多假设，他们不断测试不同的流程。你可能同时在三四个方向上下注，一旦某个方向显示出收益——想象一下你是个研究员——你就会努力扩大那个流程和那类数据的规模，同时放弃另外两三个没有进展的项目。

---

### [00:21:31] Garrett Lord (Continued)

**English:**
So, your ability to quickly turn around for them in a period of days, and then get to high volumes of data that are high quality is the number one thing they care about. And so, there's quite a bit of technology we built on our side to assess each unit of data. We have our own post-training teams, we're renting our own GPUs, and we're trying to make sure that we can sit directly with these researchers and help share what we're seeing with the data that we're creating and how it could improve their model, how they could best train with it. So, hopefully that helps.

**中文翻译:**
所以，你能在几天内快速周转，并提供大规模高质量数据的能力，是他们最关心的。我们在自己这边也开发了不少技术来评估每个数据单元。我们有自己的后训练团队，租用自己的 GPU，并努力确保能直接与这些研究人员坐在一起，分享我们在创造数据过程中的发现，以及这些数据如何改进他们的模型、如何最好地利用这些数据进行训练。希望这能有所帮助。

---

### [00:22:03] Lenny Rachitsky

**English:**
Going back to the types of post-training, just because I think this might be helpful, at least for me the mental model of there's pre-training, there's post-training, within post-training there's reinforcement learning, human feedback, there's this concept of fine-tuning. There's also evals and stuff like-

**中文翻译:**
回到后训练的类型，我觉得这很有帮助，至少对我来说，心智模型是：有预训练，有后训练；后训练里有基于人类反馈的强化学习，有微调的概念，还有评估（evals）之类的——

---

### [00:22:03] Garrett Lord

**English:**
There's SFT, yeah.

**中文翻译:**
还有 SFT（有监督微调），是的。

---

### [00:22:19] Lenny Rachitsky

**English:**
SFT, which is supervised fine-tuning? Is that-

**中文翻译:**
SFT，就是有监督微调（supervised fine-tuning）？是吗？

---

### [00:22:22] Garrett Lord

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:22:22] Lenny Rachitsky

**English:**
Yeah. So, the stuff you've been describing, would you mostly describe that as supervised fine-tuning?

**中文翻译:**
好的。那你刚才描述的那些工作，大部分可以归类为有监督微调吗？

---

### [00:22:29] Garrett Lord

**English:**
Yes, and we're doing all of the above. We don't do the auto eval, we produce rubrics which are used auto evals. But yeah.

**中文翻译:**
是的，而且我们上述所有工作都在做。我们不直接做自动评估，但我们制定用于自动评估的评分标准。

---

### [00:22:39] Lenny Rachitsky

**English:**
Okay, awesome. So essentially there's a model, it's trained on all this amazing data. You guys come in after the model's trained to tweak the weights based on additional data that you create. What's interesting is that this is a scalable system. I want to talk about just the supply of amazing people that you have producing this, but it's amazing that humans can do this. You would think it needs to be this infinitely scalable thing, but humans sitting there creating data is working and improving the intelligence of models significantly.

**中文翻译:**
太棒了。所以本质上，有一个模型，它已经用海量数据训练过了。你们在模型训练后介入，根据你们创造的额外数据来微调权重。有趣的是，这是一个可扩展的系统。我想聊聊你们那些产出数据的优秀人才供应，但令人惊叹的是人类竟然能做到这一点。你可能会觉得这必须是一个无限可扩展的过程，但人类坐在那里创造数据确实有效，并且显著提升了模型的智能。

---

### [00:23:13] Garrett Lord

**English:**
Oh, yeah. I mean, I think maybe a funny joke is all the MBAs think this is all just going to go away. And I think for as long as models are improving, humans will be needed in this process. And when you talk to the lead scientists and researchers at these labs, it's like the data types will evolve and what they're trying to capture and collect, but there will be humans needed in the space for the next decade until we reach full ASI. So yeah, I mean, you think about in a lot of them will struggle to do basic trajectories right now. So, right now people are very focused on academic domains, and I think they'll continue to be focused on academic domains, but there will also be far, far more demand for professional domains as well across basically every trajectory or step-by-step problem that a knowledge worker solves in the workplace, it's the pursuit of these labs to make sure that they're trying to collect the data to help add as much value in that process for humans as possible.

**中文翻译:**
噢，是的。我觉得有个笑话是，所有的 MBA 都认为这一切最终会消失。但我认为，只要模型还在进步，这个过程中就需要人类。当你与这些实验室的首席科学家和研究员交谈时，你会发现虽然数据类型和他们试图捕捉的信息会演变，但在我们达到完全的通用人工智能（ASI）之前，未来十年这个领域都需要人类。现在很多模型连基础的操作轨迹都处理不好。目前大家非常关注学术领域，我认为这种关注会持续，但对专业领域的需求也会大幅增加。基本上知识工作者在职场中解决的每一个轨迹或步骤问题，实验室都想收集相关数据，以便在这些过程中为人类创造尽可能多的价值。

---

### [00:24:17] Lenny Rachitsky

**English:**
So, let me ask you about this. There's this tension, I imagine, people might feel between all these students training models to become smarter, and smarter, and smarter, and then there's that they will have harder time potentially finding jobs if models are so smart that people at entry level aren't being hired as much. How do you think about just that tension? Do you think this is a real problem or not, or do you think this goes-

**中文翻译:**
那我想问问这个。我能想象人们会感到一种张力：一方面学生们在训练模型变得越来越聪明，另一方面，如果模型变得如此聪明，以至于初级岗位不再需要那么多人，他们找工作可能会变得更难。你如何看待这种张力？你认为这是一个真实存在的问题吗？

---

### [00:24:42] Garrett Lord

**English:**
I'm probably in the camp of like GDP growth over universal basic income. I very much believe that this is going to improve and accelerate every human's ability to create an impact in the economy in the world, and that we're hearing from, there's like a million companies that use Handshake. 100% of the Fortune 500 uses Handshake, so we basically power the vast majority of how young people find jobs, and a lot of people are hyperbolic at saying that all young people won't have jobs, and that's not what we're hearing from our employers. What we're hearing is pick social media marketing, before you needed somebody that could do Photoshop, and take pictures, and create the videos. Then you needed somebody that understood marketing analytics platforms to track your posting on different social media forms. It's like now one person, one young, talented, AI native, Iron Man suit enabled young person can get on and they can build their own videos, produce their own creative assets, post across multiple social media platforms, run all of their own analytics. They don't need a data science degree to be able to do that.

**中文翻译:**
我可能属于支持“GDP 增长”而非“全民基本收入”的那一派。我坚信 AI 将提升并加速每个人在经济和世界中创造影响力的能力。我们从使用 Handshake 的一百万家公司那里听到了反馈。100% 的财富 500 强都在用 Handshake，所以我们基本上驱动了绝大多数年轻人找工作的过程。很多人夸大其词说年轻人会失业，但这并不是我们从雇主那里听到的。以社交媒体营销为例，以前你需要有人会 Photoshop、会拍照、会剪视频，还需要有人懂营销分析平台。而现在，一个年轻、有才华、AI 原生、穿着“钢铁侠战衣”的年轻人，一个人就能制作视频、产出创意资产、发布到多个平台并运行所有分析。他们甚至不需要数据科学学位就能做到这些。

---

### [00:25:47] Garrett Lord (Continued)

**English:**
Or take an intern in our company, he had his first PR up I think the afternoon he started. You were a PM, you realize how challenging that would've been historically to get your dev environment set up and figure out where to add value. You just took a bug and squashed it. And so, I'm really a believer this is just enabling human beings to be even more productive and create more impact. And yeah, of course, hundreds of millions of jobs, the jobs will evolve. People will become displaced, they'll have to upscale and rescale, and I think Handshake has a huge role to play in helping knowledge workers evolve.

**中文翻译:**
再拿我们公司的一个实习生为例，他在入职当天的下午就提交了第一个 PR（拉取请求）。你当过产品经理（PM），你应该知道以前配置开发环境并找到贡献点有多难。而他直接找了个 Bug 把它解决了。所以我真的相信这只是在让人们变得更高产、更有影响力。当然，数以亿计的工作岗位会演变。人们会被取代，他们必须提升技能或重新学习技能，我认为 Handshake 在帮助知识工作者进化方面可以发挥巨大作用。

---

### [00:26:24] Lenny Rachitsky

**English:**
This has come up a couple of times this point that I think is really good, that younger people coming out of school are actually going to be much more likely to be successful because they're growing up with these tools, and are much more native to all these advanced tools and so they just come in as beasts just doing so much more.

**中文翻译:**
这个观点已经出现好几次了，我觉得非常好：刚毕业的年轻人实际上更有可能成功，因为他们是伴随着这些工具长大的，对这些先进工具更具原生感，所以他们一入职就像“猛兽”一样，能做更多的事情。

---

### [00:26:42] Garrett Lord

**English:**
Well, do you remember when, this a little bit predates me, but you used to put Google search on as a skill on your resume. You were person, you were good at Googling, because you grew up with Google. It's like I think being AI native and having your Iron Man suit on, and understanding how to leverage these tools is like young people are at a huge advantage.

**中文翻译:**
你还记得吗（虽然这比我早一点），以前人们会在简历上把“谷歌搜索”写成一项技能。你是一个擅长谷歌搜索的人，因为你是伴随谷歌长大的。我觉得作为 AI 原住民，穿着你的“钢铁侠战衣”，懂得如何利用这些工具，会让年轻人处于巨大的优势地位。

---

### [00:27:03] Lenny Rachitsky

**English:**
Yeah. And especially if they're involved in training these models, I imagine there's some other cool advantage there.

**中文翻译:**
是的。特别是如果他们还参与了这些模型的训练，我猜那还会有其他很酷的优势。

---

### [00:27:08] Garrett Lord

**English:**
Yeah. Well I mean, just to hit on that, what we're hearing from our thousands of fellows is they're in the classroom, they're actually producing research. We're talking about PhDs at the top institutions in the country. They can make 100, 150, $200 an hour in their area, in their field of expertise. It's pretty sweet. You can make 25 bucks an hour being a teacher's assistant, or you can actually make $150 an hour breaking the latest models, and what we're hearing from our fellows is they're bringing a lot of those insights into the classroom to help them be more effective at teaching. More importantly, they're starting to learn how to leverage these tools to actually advance their area of research. So, they believe that these tools can help them advance their area of research by helping them be more effective with their time. And so, it is quite cool to get paid to learn a skill.

**中文翻译:**
是的。关于这一点，我们从成千上万名参与者那里听到的是，他们还在教室里，还在做研究。我们说的是国内顶尖机构的博士。他们在自己的专业领域每小时能赚 100、150 甚至 200 美元。这很棒。你可以当助教每小时赚 25 美元，也可以通过挑战最新模型每小时赚 150 美元。我们听到的反馈是，他们把这些见解带回课堂，帮助自己更有效地教学。更重要的是，他们开始学习如何利用这些工具来推进自己的研究领域。他们相信这些工具能通过提高时间效率来帮助他们。所以，一边学习技能一边拿高薪，真的很酷。

---

### [00:27:58] Lenny Rachitsky

**English:**
Before I get to the story of how this all emerged, because that is an incredible story, is there anything else about this whole field of labeling, of reinforcement learning that you think people just don't fully understand or you think that is really important? There's just so much happening. Like I said, some of the fastest growing companies in the world are in the space, Scale was just acquired for 30, sort of acquired for $30 billion. Just what else is there, if there's anything, that you think people need to understand?

**中文翻译:**
在聊这项业务是如何诞生之前（那是个精彩的故事），关于标注、强化学习这个领域，还有什么是你觉得大家还没完全理解，或者你觉得非常重要的吗？这个领域发生了太多事情。就像我说的，世界上一些增长最快的公司都在这个领域，Scale AI 刚以 300 亿美元的估值融资（或者说某种程度上的估值）。还有什么你觉得大家需要了解的吗？

---

### [00:28:26] Garrett Lord

**English:**
Generally speaking, anytime that you're interacting with a model and you're asking it to do really advanced things, and it's not performing your expectations, like somewhere there's probably an expert that is the top mind in that domain working directly for the best researchers in the world at the Frontier Labs trying to understand and go through the scientific iteration process of how to make that better. And that the assumption there is that they already have the entirety of human knowledge that's written and recorded. And so, for as long as there are problems in solving any problem with AI, any human problem, there will need to be humans in the loop helping advance that. And models don't generalize. I mean, obviously the field will advance a lot and the type of data they'll collect will evolve a lot, but it's pretty exciting at the frontier.

**中文翻译:**
总的来说，每当你与模型互动，要求它做一些非常高级的事情，而它没有达到你的预期时，很可能在某个地方，正有一位该领域的顶尖专家直接为前沿实验室的世界级研究人员工作，试图通过科学迭代过程来改进它。这里的假设是，他们已经拥有了所有已记录的人类知识。因此，只要 AI 在解决人类问题时还存在障碍，就需要人类参与其中（humans in the loop）来帮助推进。模型目前还不能完全泛化。显然，这个领域会进步很多，收集的数据类型也会演变，但身处前沿确实令人兴奋。

---

### [00:29:20] Lenny Rachitsky

**English:**
Kevin Wheel was on the podcast, the CBO at OpenAI, and he made this point that really stuck with me that the model of today is the worst model you will ever use.

**中文翻译:**
OpenAI 的 CBO Kevin Weil 曾上过这个播客，他的一句话让我印象深刻：你今天使用的模型，将是你这辈子用过的最差的模型。

---

### [00:29:29] Garrett Lord

**English:**
I love that line.

**中文翻译:**
我喜欢这句话。

---

### [00:29:30] Lenny Rachitsky

**English:**
Will only get better, just boggles the mind, and now we know why things are getting better because all the work you guys are doing. Just one quick question on this whole scale thing, I guess they were, I don't know, the main company doing this, now they're swallowed up and Alex is running superintelligence in Meta. Are they still a big player in this labeling space or are they out of it and that's a big opportunity?

**中文翻译:**
模型只会变得更好，这简直令人难以置信。现在我们知道为什么它在变好了，因为有你们在做这些工作。关于 Scale AI 我有个小问题，他们曾是这个领域的主导者，现在 Alex Wang 似乎在 Meta 负责超级智能。他们在这个标注领域还是大玩家吗？还是说他们已经退出了，而这成了一个巨大的机会？

---

### [00:29:50] Garrett Lord

**English:**
Yeah. I mean, kudos to the whole Scale team, a lot of respect for what they built, just many great companies operating the space. I think to the core of your question, I think if you viewed your research team and your model building team, and the experiments they're running to be really the cornerstone of how you're improving, you probably wouldn't want the latest research of what you're trying to work on being invested in by a peer. I mean, that's just generally what we hear in this space. And so, we have seen an incredible search and demand, and are I think extraordinarily well positioned. We like to say the only moat in human data is access to an audience. Basically, there are many, many small players in this space, some midsize players in the space, and they're basically running TikTok ads, running Instagram ads, paying money for Google Search display ads, YouTube ads, and they will be like, "Can you get me 200 physics PhDs?"

**中文翻译:**
是的。向整个 Scale 团队致敬，非常尊重他们所建立的一切，这个领域有很多优秀的公司。回到你问题的核心，如果你认为你的研究团队、模型构建团队以及他们正在进行的实验是你进步的基石，你可能不希望你正在研究的最新成果被竞争对手掌握。这是我们在这个领域普遍听到的声音。因此，我们看到了惊人的需求增长，而且我认为我们的定位非常好。我们常说，人类数据唯一的护城河就是触达受众的能力。基本上，这个领域有很多小玩家和中型玩家，他们主要靠投放 TikTok 广告、Instagram 广告、谷歌搜索广告和 YouTube 广告，然后问：“你能帮我找 200 个物理学博士吗？”

---

### [00:30:58] Garrett Lord (Continued)

**English:**
What do they do? They only can do one thing. They have 100 recruiters on staff, they all get on LinkedIn, they all send messages, they spend a couple million bucks on performance advertising campaigns. Somebody's scrolling their Instagram feed that's a physics PhD of which you can't target them that well and they like see, "Come train a model." It's like, "I've never heard of this brand before." The huge advantage that we've had and why we've resonated so fast in the marketplace is we built a decade of trust with 18 million people, and they trust us, and we built a ton of brand affinity, and they use Handshake, and they have an active profile, and we have a ton of information around their academic performance and what they've done in school. And so, we're able to really target people really effectively, and get to scale and volume of high quality data faster than anyone else. And I think that competitive advantage of access to an audience is really resonating in the marketplace.

**中文翻译:**
他们怎么做？他们只能做一件事：雇 100 个招聘人员，全部上 LinkedIn 发私信，花几百万美元做效果广告。某个物理学博士正在刷 Instagram（你其实很难精准定位到他们），然后看到“来训练模型吧”。他会想：“我从没听说过这个品牌。”而我们的巨大优势，以及我们能如此迅速在市场产生共鸣的原因是，我们与 1800 万人建立了一整年的信任。他们信任我们，我们有极强的品牌亲和力，他们使用 Handshake，有活跃的个人资料，我们掌握大量关于他们学业表现和校内经历的信息。因此，我们能非常有效地定位人才，并比任何人都更快地实现高质量数据的规模化。我认为这种“触达受众”的竞争优势在市场上引起了强烈反响。

---

### [00:31:49] Lenny Rachitsky (Sponsor: Anthropic/Claude)

**English:**
Today's episode is brought to you by Anthropic, the team behind Claude. I use Claude at least 10 times a day. I use it for researching my podcast guests, for brainstorming title ideas for both my podcast and my newsletter, for getting feedback on my writing and all kinds of stuff. Just last week I was preparing for an interview with a very fancy guest, and I had Claude tell me what are all the questions that other podcast hosts have asked this guest so that I don't ask them these questions? How much time do you spend every week trying to synthesize all of your user research insights, support tickets, sales calls, experiment results and competitive intel? Claude can handle incredibly complex multistep work. You can throw a 100-page strategy document at it and ask it for insights, or you can dump all your user research and ask it to find patterns. With Claude 4 and the new integrations including Claude 4 Opus, the world's best coding model, you get voice conversations, advanced research capabilities, direct Google Workspace integration, and now MCP connections to your custom tools and data sources. Claude just becomes part of your workflow. If you want to try it out, get started at Claude.ai/Lenny, and using this link you get an incredible 50% off your first three months of the pro plan. That's Claude.ai/Lenny.

**中文翻译:**
本期节目由 Anthropic 赞助，他们是 Claude 的开发团队。我每天至少用 10 次 Claude。我用它来研究播客嘉宾，为播客和时事通讯构思标题，获取写作反馈等等。就在上周，我准备采访一位重量级嘉宾，我让 Claude 告诉我其他播客主持人都问过这位嘉宾哪些问题，这样我就能避开重复。你每周花多少时间汇总用户研究见解、支持工单、销售电话、实验结果和竞争情报？Claude 可以处理极其复杂的、多步骤的工作。你可以扔给它一份 100 页的战略文档并让它提取见解，或者倒入所有用户研究数据让它寻找模式。随着 Claude 4 及其新集成（包括全球最强编程模型 Claude 4 Opus），你将获得语音对话、高级研究能力、直接的 Google Workspace 集成，以及现在连接到自定义工具和数据源的 MCP 连接。Claude 正在成为你工作流的一部分。如果你想尝试，请访问 Claude.ai/Lenny，通过此链接，你可以在前三个月的专业版计划中享受 50% 的惊人折扣。

---

### [00:33:06] Lenny Rachitsky

**English:**
Okay, this is an awesome segue to where I wanted to go, which is just how this business emerged. This is a business that you built on top of a business you've already had. From what I understand, you were at like $150 million in revenue, you've been at this for a long time. You found this opportunity, and now that looking back it's like obviously this is an amazing idea, labs need data, you guys have the supply of incredible experts. What an opportunity. Talk about just how you first realized this was something that you could be doing, and should be doing, and then how you started to execute down this path.

**中文翻译:**
好的，这正好引出了我想聊的话题：这项业务是如何诞生的。这是你在原有业务基础上建立的。据我所知，你们当时的收入大约是 1.5 亿美元，已经经营很久了。你发现了这个机会，现在回过头看，这显然是个绝妙的主意——实验室需要数据，而你们拥有顶尖专家的供应。多么棒的机会。聊聊你是如何第一次意识到这是你可以做、而且应该做的事情，以及你是如何开始执行的。

---

### [00:33:40] Garrett Lord

**English:**
Yeah, I think it's been a pretty natural extension from helping people jumpstart, restart or start their career. Monetizing your skills and this new employment ecosystem is going to look very different in the future, and to zoom into how we discovered it, it's like because we have such a large access to this audience, and as the world shifted from generalists to experts, we're the largest expert network in the world. We have more PhDs, 500,000 of them use Handshake than any other platform. We have three million master students who are in school or alumni. And so, we started to see all what I would call middleman companies reaching out to us saying, "Can we recruit your PhDs and master's students?" And like any great marketplace we started sending them to these different platforms, and started to really realize that from hearing from our users that the experience was really frustrating.

**中文翻译:**
是的，我认为这是从“帮助人们开启、重启或开始职业生涯”这一使命的自然延伸。在未来的就业生态中，技能变现的方式将大不相同。深入聊聊我们是如何发现它的：因为我们拥有如此庞大的受众群体，而且随着世界从需要通才转向需要专家，我们成了全球最大的专家网络。Handshake 上的博士数量（50 万）比任何其他平台都多。我们还有 300 万在读或已毕业的硕士。于是，我们开始看到很多我称之为“中间商”的公司联系我们，问：“我们能招聘你们的博士和硕士吗？”像任何优秀的平台一样，我们开始把他们引向这些不同的平台，但随后我们从用户那里听到，那里的体验非常令人沮丧。

---

### [00:34:38] Garrett Lord (Continued)

**English:**
Training was very transactional, it was very amorphous how you could get paid. There was immense amount of drop-off in the process to actual project like completion on these other platforms. So, we started to think the company was making tens of millions of dollars from helping these other platforms, and we started to realize what really kicked it off was hearing also from the Frontier Labs, they started to reach out to us and started to go direct and trying to almost cut out the middleman. And we started to realize, well, we could really serve our fellows, our PhDs, our experts, we could treat them. We just believe there will need to be a platform, an experts first platform in the pursuit of ASI and advancing AI, and there will need to be a place that everyone in the world could go to, to monetize their skills and their knowledge as these labs are focused on improving in all these multidisciplinary. And yeah, we entered the business in, really I started doing it over Christmas and New Year's. That's when I started flying around.

**中文翻译:**
培训非常事务性，报酬发放也不透明。在那些平台上，从开始到实际完成项目的流失率极高。我们意识到，公司通过帮助这些平台赚了几千万美元，但真正触发我们行动的是，前沿实验室也开始直接联系我们，试图跳过中间商。我们意识到，我们可以更好地服务我们的参与者、博士和专家。我们相信，在追求通用人工智能（ASI）和推进 AI 的过程中，需要一个“专家优先”的平台，一个让全世界的人都能在实验室专注于多学科改进时，将自己的技能和知识变现的地方。于是，我们在去年圣诞节和新年期间正式进入了这个领域。那也是我开始四处奔波的时候。

---

### [00:35:48] Garrett Lord (Continued)

**English:**
My family thought it was a little wild that I was on planes trying to chase different leaders, but we built an incredible team of people that came from the human data world, and really started building out our platform in January, and then started really monetizing the relationships about five months ago. Fast-forward to today, we're working with seven of the Frontier Labs, basically every lab that's doing work and building the best large language models, and the team has exploded and revenue's exploded, and it's been really a incredible ride running back new company inside of a company for the second time over again.

**中文翻译:**
我的家人觉得我疯了，节日期间还在飞机上追着各路大佬跑。但我们组建了一支来自人类数据领域的优秀团队，1 月份开始构建平台，大约 5 个月前开始真正实现商业化。快进到今天，我们正在与 7 家前沿实验室合作，基本上涵盖了所有正在开发顶级大语言模型的实验室。团队规模和收入都爆炸式增长。在公司内部再次创办一家新公司，这真是一段不可思议的旅程。

---

### [00:36:28] Lenny Rachitsky

**English:**
And just to share some numbers, tell me if this is correct or if you're sharing these, but I heard that you hit 50 million in revenue just four months into this? Today we're at eight months in and you're on track to hit $100 million in revenue in the first year.

**中文翻译:**
分享一些数据，如果不方便或者不准确请纠正我：我听说你们在启动仅四个月后，收入就达到了 5000 万美元？现在是第八个月，你们有望在第一年就达到 1 亿美元的收入。

---

### [00:36:43] Garrett Lord

**English:**
I think we'll blow through that number, but yeah.

**中文翻译:**
我想我们会远超那个数字，但没错。

---

### [00:36:44] Lenny Rachitsky

**English:**
Okay. Incredible. And I didn't even know there were seven Frontier Labs, that's-

**中文翻译:**
太不可思议了。我甚至都不知道有 7 家前沿实验室，这——

---

### [00:36:49] Garrett Lord

**English:**
Zero to 50 is pretty good in four months, I think.

**中文翻译:**
四个月从 0 到 5000 万，我觉得还不错。

---

### [00:36:51] Lenny Rachitsky

**English:**
Think zero to 50 million in four months, that's something. It's like the bar has been shifting constantly. A year ago that'd be legendary. Now it's like, all right, well another one of these. 50 million in four months, no big deal. It's truly insane. Just to zoom out one second, for people that don't know a ton about Handshake, the original business, what was that? What was actually this network that you had, that you sat on top of?

**中文翻译:**
四个月从 0 到 5000 万，这太惊人了。感觉现在的标准一直在变。一年前这绝对是传奇，现在大家会觉得：“好吧，又是一个这样的例子。四个月 5000 万，没什么大不了的。”这真的很疯狂。让我们跳出来看一下，对于那些不太了解 Handshake 原有业务的人来说，那是什么？你所依托的这个网络到底是什么样的？

---

### [00:37:18] Garrett Lord

**English:**
Yeah, that network does about 200 million. This will do about [inaudible 00:37:21]

**中文翻译:**
是的，那个网络现在的收入大约是 2 亿。而这项新业务将达到……（听不清）

---

### [00:37:18] Lenny Rachitsky

**English:**
200 million.

**中文翻译:**
2 亿。

---

### [00:37:18] Garrett Lord

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:37:18] Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:37:20] Garrett Lord

**English:**
So, we have 600-ish super passionate teammates that work on the core business, which I would separate those. These aren't two businesses, I think it's one business, but what is that business? If you're a young person in America that's graduated in the last five, six, seven, eight years, you probably have Handshake on your phone. You definitely know what Handshake is. It's a verb with young people in America, it's a verb with people that are in college in their PhD or master's program, and it is, I call it an unconnected graph, meaning you don't need to ... LinkedIn is very focused on who you know and what your experience is. The first question on LinkedIn is what's your job? And a lot of young people start off, they've never had a job before. They don't have 500 connections to add to their graph.

**中文翻译:**
我们有大约 600 名充满热情的同事在负责核心业务。虽然我把它们分开说，但我认为它们是一家公司。那项业务是什么？如果你是过去五到八年内毕业的美国年轻人，你的手机里可能有 Handshake。你肯定知道 Handshake 是什么。在美国年轻人中，它已经成了一个动词。我称它为“非连接图谱”，意思是……LinkedIn 非常关注你认识谁以及你的经验。LinkedIn 的第一个问题是“你的工作是什么？”，而很多年轻人刚开始时从未有过工作，也没有 500 个联系人可以添加到图谱中。

---

### [00:38:13] Garrett Lord (Continued)

**English:**
Whereas on Handshake, you start off trying to discover, and explore, and figure out how to navigate through school and figure out, "Oh, I'm an engineer. Maybe I want to be a PM, maybe I want to work at a startup, maybe I want to go to a larger company." What are the pros and cons you want to learn from your peers and young alumni? And so, Handshake's this I call a very social platform with groups, and messaging, and profiles, and short-form video and feed, all focused on your interests and helping really build your confidence in your early career to find your first job, your second job, and to manage 18 to 30, I would say.

**中文翻译:**
而在 Handshake 上，你从发现和探索开始，弄清楚如何度过校园生活，弄清楚：“哦，我是个工程师，也许我想当 PM，也许我想去初创公司，或者大公司。”你想从同龄人和年轻校友那里了解各行各业的优缺点。所以 Handshake 是一个非常社交化的平台，有小组、消息、个人资料、短视频和信息流，全部围绕你的兴趣，帮助你在职业生涯早期建立信心，找到第一份、第二份工作，管理 18 到 30 岁这段时期。

---

### [00:38:49] Lenny Rachitsky

**English:**
And how long has that business been around?

**中文翻译:**
那项业务存在多久了？

---

### [00:38:51] Garrett Lord

**English:**
It's been around 10 years.

**中文翻译:**
已经 10 年了。

---

### [00:38:51] Lenny Rachitsky

**English:**
10 years, okay. So it's just again, it just feels like such a holy shit, you guys are in the right place in the right time with the right network that is extremely valuable now. What an interesting story. I feel like it's just another interesting example of you've been doing something for a long time and then all of a sudden AI is just, opens up a whole new way of leveraging something that you have been doing for a long time. It makes me think a little better about Bolt, and StackBlitz, which was building for seven years this browser based OS where you could run an OS in the browser. And they're like, "I don't know, no one needs this. What are we doing?" And then, all of a sudden AI and they're like, "Oh, what if we build AI apps in the browser and just generate products for you with AI?" And now it's, I don't know, one of the fastest growing companies in the world.

**中文翻译:**
10 年，好的。这再次让我感叹，你们真的是在正确的时间、正确的地点，拥有了现在极具价值的正确网络。多么有趣的故事。我觉得这又是一个有趣的例子：你长期坚持做某件事，然后突然间 AI 出现，为你长期积累的东西开辟了一种全新的利用方式。这让我想到了 Bolt 和 StackBlitz，他们花了七年时间开发基于浏览器的操作系统。当时他们可能在想：“没人需要这个，我们在干嘛？”然后 AI 来了，他们意识到：“如果我们在浏览器里构建 AI 应用，直接用 AI 为你生成产品呢？”现在，他们成了世界上增长最快的公司之一。

---

### [00:39:36] Garrett Lord

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:39:37] Lenny Rachitsky

**English:**
So interesting. And so, I think this is just an interesting time for our people to think about what have we done that may give us a new opportunity to build something huge based on this unfair advantage that we have?

**中文翻译:**
太有意思了。所以我认为现在是一个有趣的时刻，让大家思考：我们已经做了什么，能让我们利用现有的“不公平优势”去构建一些伟大的东西？

---

### [00:39:49] Garrett Lord

**English:**
I think also as your company grows in size and headcount, and maturity, it's also hard to incubate something new inside of a business. It's hard in so many ways. The way that you build zero to one, and find product market fit, and scale a team very quickly and is very different than the way that you run a more mature business that has been around for 10 years with hundreds, and hundreds, and hundreds of people. So, I've really had a ton of fun and found a ton of passion in running it back again for the second time inside the business. And then yeah, we have this massive strategic advantage, which is no cost or acquisition costs, and we have much higher conversion rates and retention than any of the other platforms by a large margin because we have such consumer affinity.

**中文翻译:**
我也认为，随着公司规模、人数和成熟度的增加，在内部孵化新业务是很困难的。在很多方面都很困难。从 0 到 1、寻找产品市场契合点（PMF）以及快速扩展团队的方式，与运营一家拥有数百年员工、成立 10 年的成熟公司完全不同。所以，在公司内部再次开启这段旅程，我感到非常有意思，也充满了激情。而且，我们拥有巨大的战略优势，即零获客成本，并且由于我们拥有极强的用户亲和力，我们的转化率和留存率远高于其他任何平台。

---

### [00:40:43] Lenny Rachitsky

**English:**
There's actually two threads here I want to follow, I'm going to follow the second one first, this idea of where this data labeling work can come from. This isn't a really clear, simple, understandable one, which is just experts sitting there creating data. Another one that I know a lot of other companies in this space use Scale, I know especially with just like low-cost labor internationally. Are there other methods for doing this that isn't one of those two? How are other companies doing this?

**中文翻译:**
这里有两个思路我想探讨，先说第二个：关于这些数据标注工作的来源。一种是很清晰、易懂的，就是专家坐在那里创造数据。另一种是我知道很多公司（如 Scale AI）在用的，特别是利用国际廉价劳动力。除了这两者，还有其他方法吗？其他公司是怎么做的？

---

### [00:41:10] Garrett Lord

**English:**
I think if you care about building a really high quality business, and having good gross margin and high quality growth, the ecosystem here is, one of the leading players, they have 200 recruiters. It's unsustainable. There are like 200 people on LinkedIn sending individual messages to acquire these people, because there's no brand, there's no trust. They're spending tens of millions of dollars a month on performance advertising, Google Ads-

**中文翻译:**
我认为如果你关心建立一个高质量的业务、拥有良好的毛利率和高质量的增长，目前的生态是：某家领先的玩家拥有 200 名招聘人员。这是不可持续的。有 200 人在 LinkedIn 上发送私信来获取人才，因为没有品牌，没有信任。他们每月在效果广告、谷歌广告上花费数千万美元——

---

### [00:41:39] Lenny Rachitsky

**English:**
To find experts and to find folks.

**中文翻译:**
为了寻找专家和人才。

---

### [00:41:41] Garrett Lord

**English:**
Find experts.

**中文翻译:**
寻找专家。

---

### [00:41:42] Lenny Rachitsky

**English:**
And it's experts mostly at this point.

**中文翻译:**
而且目前主要是专家。

---

### [00:41:43] Garrett Lord

**English:**
Yeah. And then they put them onto an experience that is treating them like they're drawing boundary boxes around stop signs in the Philippines. The frontier tax accountants don't want to be treated like low cost international labor, and I don't think anyone enjoys that process. And so, the ability to build a experience that's rooted in community, that's rooted in high quality training. If you're getting your PhD at MIT, chances are you're just not being taught well enough on how to use the tools.

**中文翻译:**
是的。然后他们让这些专家去体验那种就像在菲律宾给停车标志画框框一样的工作。前沿的税务会计师不想被当作廉价国际劳动力对待，我觉得没人喜欢那个过程。因此，建立一种植根于社区、植根于高质量培训的体验至关重要。如果你在麻省理工读博，很可能没人教过你如何使用这些工具。

---

### [00:42:15] Garrett Lord (Continued)

**English:**
It's not you can't break the models, it's just like the other platforms, they're spending thousands of hours to acquire an individual user and they're put right into a project with no training. So, we just started from day one at building this expert ... We believe there'd be a deep network effect here that's very connected to our core business of starting, jumpstarting or restarting your career. And you come in, you build a profile, you see the community, there's groups and a feed of here's how people are learning. You come into actual individual cohort with peers that look like you and have your similar background. You're being taught on how to interact, and there's a trial and error, and we have an instructional design piece so you can't do it. Then you're put on the projects where building ... There's certain swim lanes where we're actually pre-building data and selling that data to all the labs.

**中文翻译:**
并不是说你无法突破模型，而是其他平台花费数千小时获取一个用户，然后直接把他们扔进项目，没有任何培训。所以我们从第一天起就致力于建立这个专家……我们相信这里存在深层的网络效应，这与我们“开启或重启职业生涯”的核心业务紧密相连。你进来，建立个人资料，看到社区、小组和学习动态。你进入一个由背景相似的同龄人组成的实际小组。你学习如何互动，有试错过程，我们还有教学设计环节。然后你被分配到项目中。在某些领域，我们实际上是在预建数据，然后将这些数据卖给所有的实验室。

---

### [00:43:03] Garrett Lord (Continued)

**English:**
So, we can do this thing where we produce one unit of data ourselves. We pay for it, almost like a movie production. We pay for a unit of data, and then we make sure it's very high quality. We run our own post-training on it, and then we produce a bunch of specifications of the data, and we actually sell that individual package of data to many different labs. And so, you get put on a project like that. Once you're doing a really, really good job on our projects, oftentimes then we'll put you on customer projects where they only want the best of the best people in machine learning. And then they go from our projects to their projects. And so, there's a huge customer acquisition. You love going deep on your podcast, so just to talk about it, it's like you really have a couple of things that matter.

**中文翻译:**
所以，我们可以自己生产一个数据单元。我们为此付费，就像电影制作一样。我们支付数据单元的费用，确保其高质量，对其进行后训练，然后生成一系列数据规范，最后将这套数据包卖给多家实验室。你会参与这样的项目。一旦你在我们的项目中表现出色，我们通常会把你推荐到客户的项目中，那些项目只需要机器学习领域最顶尖的人才。这样他们就从我们的项目过渡到了客户的项目。这里涉及巨大的获客逻辑。你喜欢在播客里深入探讨，所以聊聊这个：这里有几件事非常重要。

---

### [00:43:46] Garrett Lord (Continued)

**English:**
You have a cost to customer acquisition, your CAC, and then you have your LTV, like the lifetime value of a user. And an LTV is calculated pretty simply in this business. It is based on the retention of a person, and how many projects they can participate in. So, if you treat people really well, you train them really well, well, A, we have no customer acquisition costs because we partner with 1,600 universities, power 92% of the top 500 schools in the country. We power almost every institution and community college in the country. We have no customer acquisition cost to acquire the people. We have a ton of brand and trust with them built up, so they convert at really, really high rates. And then, if you treat them really well, because what they expect from us, they know Handshake, their school buys Handshake, we care about treating these people well but the universities would not tolerate our partnership with these fellows unless we treated them well.

**中文翻译:**
你有获客成本（CAC），还有用户终身价值（LTV）。在这个业务中，LTV 的计算很简单：基于用户的留存以及他们能参与的项目数量。如果你对人很好，培训得很好，那么：首先，我们没有获客成本，因为我们与 1600 所大学合作，覆盖了全国前 500 强名校的 92%，几乎覆盖了所有的机构和社区大学。我们获取人才的成本为零。我们与他们建立了深厚的品牌信任，所以转化率极高。其次，如果你对他们很好——因为他们了解 Handshake，他们的学校购买了 Handshake 服务，如果我们不对这些人好，大学是不会容忍这种合作关系的。

---

### [00:44:41] Garrett Lord (Continued)

**English:**
So, you put them into this process where our LTVs and repeat engagement rate and retention rate on different projects is really high. And so, these structural advantages are quite significant when you contrast a leading provider that has 200 individual contributing recruiters, and are spending tens of millions of dollars a month on performance marketing. So, that's I think why we've seen so much success.

**中文翻译:**
所以，你把他们带入这个流程，我们在不同项目上的 LTV、重复参与率和留存率都非常高。当你把这些结构性优势与那些拥有 200 名招聘人员、每月花费数千万美元做营销的领先供应商对比时，差距是非常显著的。我认为这就是我们取得如此大成功的原因。

---

### [00:45:07] Lenny Rachitsky

**English:**
That's extremely interesting. And it feels like, as you said, there used to be a big focus on generalists, which is people anywhere in the world for low-cost can do the work, like draw bounding boxes around things. And essentially the market has shifted from low-cost generalists to experts. And a lot of these companies like Scale, we're optimizing for general work model training data, and you guys are set up to be extremely good at expert based data. And so, you're in the right place at the right time, at the right supply. What a business.

**中文翻译:**
这非常有意思。正如你所说，以前大家关注的是通才，即世界上任何地方的廉价劳动力都能做的工作，比如画框。而现在市场已经从廉价通才转向了专家。像 Scale 这样的公司很多是在为通用的模型训练数据做优化，而你们的架构非常适合产出基于专家的数据。所以，你们是在正确的时间、正确的地点，拥有了正确的供应。真是一门好生意。

---

### [00:45:43] Garrett Lord

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:45:43] Lenny Rachitsky

**English:**
Nice work.

**中文翻译:**
干得漂亮。

---

### [00:45:44] Garrett Lord

**English:**
I would say it's not been easy building business two inside of business one, but-

**中文翻译:**
我想说，在第一项业务内部构建第二项业务并不容易，但是——

---

### [00:45:48] Lenny Rachitsky

**English:**
Yeah. So, let me follow that thread. That's where I wanted to go. What was just that like? So, you started noticing that model companies were coming to your people, that people were having hard times with some of these other companies in this space and you're like, "Oh, maybe we should be doing this sort of thing"? How did that just initial inception start, and how did you start to explore that idea and to see if it was a real thing?

**中文翻译:**
是的，让我们顺着这个话题聊。这正是我感兴趣的。那是什么感觉？你开始注意到模型公司在找你们的人，而人们在其他公司那里体验不好，然后你心想：“哦，也许我们也该做这个？”最初的构思是怎么开始的？你是如何探索这个想法并确认它是否可行的？

---

### [00:46:09] Garrett Lord

**English:**
Tactically we were working with many of the middleman companies doing work. We started to see the demand, as I talked about earlier. We started to see direct outreach from the Frontier Labs reaching out to us, trying to cut out the middleman in their pursuit of getting higher-quality data. When we started to put together the dots on we could build a way better experience for our fellows, we could serve them directly to the labs and build a direct customer relationship with the labs, and basically cut out the middleman. And provide a better experience to the labs, provide a better experience to our fellows and provide a better experience to our million companies in the network.

**中文翻译:**
从战术上讲，我们当时正与许多中间商公司合作。正如我之前提到的，我们开始看到需求。我们开始看到前沿实验室直接联系我们，试图跳过中间商以获取更高质量的数据。当我们把这些点连成线，意识到我们可以为参与者建立更好的体验，可以直接为实验室服务并建立直接的客户关系，基本上就是干掉中间商。同时为实验室、参与者以及我们网络中的百万家公司提供更好的体验。

---

### [00:46:48] Garrett Lord (Continued)

**English:**
And you might think about just upskilling and reskilling, what's going to happen there. So, we walked into this space. We started in really December, exploring and learning more about it, like on expert calls and hammering down. I hired three expert firms, AlphaSights and GLG, and started doing a bunch of calls with the latest researchers, because we had resources. One of the cool things about being a larger company is our core business is $200 million ARR, so it's like we had resources to be able to accelerate the learning curve here. And then, we started working with arguably the number one lab about five months ago.

**中文翻译:**
你也可以想想技能提升和重塑会发生什么。于是我们进入了这个领域。我们从 12 月开始探索和学习，通过专家电话深入了解。我聘请了三家专家咨询公司（AlphaSights 和 GLG），开始与最新的研究人员进行大量通话，因为我们有资源。作为一家大公司，酷的地方在于我们的核心业务有 2 亿 ARR，所以我们有资源来加速学习曲线。大约五个月前，我们开始与可以说是排名第一的实验室合作。

---

### [00:47:34] Lenny Rachitsky

**English:**
I wonder who that is.

**中文翻译:**
我在想那是哪一家。

---

### [00:47:35] Garrett Lord

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:47:35] Lenny Rachitsky

**English:**
Yeah, wonder who it is.

**中文翻译:**
是啊，想知道是谁。

---

### [00:47:39] Garrett Lord

**English:**
[inaudible 00:47:39] different answers working with the number one lab, and have just now we're working with Devin on the Frontier Labs and the number one thing we're trying to do is just focus on scaling up. And we've gone from four or five people working on this to 75 plus people working on it. I think we had 12 people start last Monday. It's like we are so bottlenecked on just meeting this opportunity, because in this market there's essentially unlimited demand. If you can produce high quality volumes of data, you most likely will be able to sell whatever you produce. And so on our side, it's like we're really focused on making sure that we pick the right longer term strategy, making sure that we don't grow too fast as to erode the trust that we've built up with these Frontier labs. Yeah, but it's been fun.

**中文翻译:**
（听不清）与第一名的实验室合作有不同的答案，现在我们正与前沿实验室合作，我们目前的首要任务就是专注于规模化。我们已经从四五个人增加到了 75 多人。上周一就有 12 个人入职。我们在抓住这个机会上遇到了严重的瓶颈，因为在这个市场，需求基本上是无限的。如果你能生产大规模的高质量数据，你生产多少就能卖掉多少。所以对我们来说，我们正专注于确保选择正确的长期战略，确保不会因为增长过快而损害我们与这些前沿实验室建立的信任。是的，但这过程很有趣。

---

### [00:48:38] Lenny Rachitsky

**English:**
You said it's also been really hard to start those business within an existing business. What's been hard? What's been hardest? You touched on a couple of these elements already, but what else?

**中文翻译:**
你说在现有业务内部启动新业务非常困难。难在哪里？最难的是什么？你已经提到了一些因素，还有其他的吗？

---

### [00:48:50] Garrett Lord

**English:**
I think I just followed a lot more of my intuition around this, doing this. The story of Handshake was we had to sign up 1,600 universities, so I had to learn how to be the best ... We are the fastest growing higher education company in history. So, we signed up six 1,600 schools. Then we had to build an employer business, where we had to figure out how to sell the 100% ... All these Fortune 500 companies use it and 70% of it pay for it, so I had to learn about upmarket sales to Goldman Sachs, and General Motors, and Google and the biggest companies in the world, which is totally different than selling universities. And then we had to learn how to build an incredible student social network. What does the best feed look like? What does group messaging look like? So, I felt a little bit of familiarity in those zero to ones.

**中文翻译:**
在做这件事时，我更多地遵循了自己的直觉。Handshake 的故事是我们要签下 1600 所大学，所以我必须学习如何成为最好的……我们是历史上增长最快的高等教育公司。我们签下了 1600 所学校。然后我们要建立雇主业务，弄清楚如何向 100% 的财富 500 强销售（其中 70% 是付费客户），所以我必须学习如何向高盛、通用汽车、谷歌等全球最大的公司进行高端销售，这与向大学销售完全不同。接着我们还要学习如何建立一个优秀的大学生社交网络：最好的信息流是什么样的？群组消息是什么样的？所以，我对这些“从 0 到 1”的过程感到有些熟悉。

---

### [00:49:39] Garrett Lord (Continued)

**English:**
Oftentimes marketplaces are like many zero to ones. Sometimes I dream that we just, I actually don't dream, but I make a joke that I just wish we were a cybersecurity company and we had one buyer and just one product, and it was just like we had to ... In a marketplace, you have to serve three different sides, you know from your time at Airbnb. And so, one of my learnings in spinning up these three different businesses in starting Handshake was I was pretty hands-on. So, everyone reported directly to me. I really said in a lot of meetings, "I'm not trying to be the boss, I'm just trying to get another smart guy in the room." We've hired an incredible team of people that have spent a lot of time in the space and have been big leaders at a lot of the human data companies in the space.

**中文翻译:**
通常平台型业务（marketplaces）就像是许多个“从 0 到 1”。有时我开玩笑说，我真希望我们是一家网络安全公司，只有一个买家和一个产品。在平台业务中，你必须服务三个不同的方面，你在 Airbnb 的经历肯定让你深有体会。在创办 Handshake 的过程中，我学到的一点是必须亲力亲为。所以，每个人都直接向我汇报。我在很多会议上都说：“我不是想当老板，我只是想让房间里多一个聪明人。”我们聘请了一支优秀的团队，他们在该领域深耕多年，曾是许多人类数据公司的领导者。

---

### [00:50:27] Garrett Lord (Continued)

**English:**
And so, everyone saw very clearly the structural advantages that we had, and a lot of the focus was on making sure that we could deliver high-quality data to one customer before we expand to anyone else. You had to say no to a lot of things. And then, you also had a lot of people in the core part of the business that, rightfully so, there's just checks and balances that there's a lot of people that try to get involved. Everyone wants to say, not everyone, this is a stretch, but it's easy to say no. It's easy to be like, "I can't prioritize that this week or this month. I have an existing set of priorities." So essentially, with the exception of a few things, everyone just came straight into this new org that I built, everyone did not have any responsibilities in the existing part of the business. It was extremely clear who was the directly responsible individual across each area of the new co. And now we've got deeper coupling and integration points across the rest of the business, but we sat in a separate part of the office.

**中文翻译:**
每个人都清楚地看到了我们的结构性优势，我们的重点是确保在扩展到其他客户之前，能为第一个客户提供高质量的数据。你必须拒绝很多事情。在核心业务部门，也有很多人想参与进来，这很正常，但也存在制衡。拒绝很容易，比如：“我这周或这个月没法优先处理那个，我有现有的优先级。”所以基本上，除了少数几件事，每个人都直接进入了我建立的新组织，他们在原有业务中不再承担任何职责。新公司每个领域的直接负责人（DRI）都非常明确。现在我们与公司其他部分有了更深的耦合和集成，但当时我们坐在办公室的一个独立区域。

---

### [00:51:35] Garrett Lord (Continued)

**English:**
Everyone's in the office five days a week, a lot of weekends. There's a totally different expectation in hiring talent too, where it's like, "Hey, this is a 24/7 job. This is an early-stage company." The compensation was also different too, and based on hurdles in this new business so people felt owners creating the new co. And yeah, it's still extremely nimble, very, very flat. Just because you run one function doesn't mean you're the directly responsible individual on a project. We pick the best person who's most capable of driving an initiative forward, regardless of the function to be the DRI. We're a lot more metrics-oriented. When I built Handshake, we resisted this operating cadence for a long time, this weekly, monthly, quarterly operating cadence. With Handshake AI, we've been way more focused on operating with data, and metrics, and rigor from an early stage. There's a gentleman named Sahil on our team who's been doing an incredible job with that. Shout out Sahil, shout out young, shout out Paco. Yeah.

**中文翻译:**
每个人每周在办公室工作五天，还有很多周末。招聘人才的预期也完全不同，我们会说：“嘿，这是个 24/7 的工作，这是一家早期公司。”薪酬体系也不同，基于新业务的里程碑，让大家觉得自己是新公司的所有者。是的，它仍然非常灵活、非常扁平。仅仅因为你负责某个职能，并不意味着你就是某个项目的直接负责人。我们选择最能推动倡议前进的人担任 DRI，而不考虑职能。我们更加注重指标。在建立 Handshake 时，我们曾长期抵制这种周、月、季度的运营节奏。但在 Handshake AI，我们从早期就更专注于用数据、指标和严谨性来运营。我们团队的 Sahil 在这方面做得非常棒。向 Sahil、Young 和 Paco 致敬。

---

### [00:52:42] Lenny Rachitsky

**English:**
Okay, this is incredible. So, a few elements of what allowed this to succeed within a decade-old company. And by the way, so you're at 200 million a year in revenue with the traditional business. You're going to, as you said, blow past 100 million in the first year of this new business. So, it's wild that in the first couple years, if things continue to go this way, you'll exceed the run rate of a business that took you 10 years to build. Incredible. To make this successful, a few of the things I noted as you were talking, one is clearly you were just in founder mode. You're the lead of this new business. You weren't delegating it to someone, "Hey, go start this thing." You dedicated people, "Here, we're going to pick people. You have nothing else going on, this is your new job. You're going to work on this stuff."

**中文翻译:**
好的，这太不可思议了。总结一下让这项业务在十年老公司内部成功的几个要素：顺便说一下，你们传统业务的年收入是 2 亿，而新业务第一年就要突破 1 亿。如果按这个趋势发展，在头几年内，新业务的运行速度就会超过你花了 10 年建立的老业务。太惊人了。为了让它成功，我注意到你提到的几点：第一，你显然处于“创始人模式”。你是这项新业务的领导者，而不是委派给别人说“嘿，去启动这个”。你专门指定了人：“我们要选一些人，你们不再负责其他事，这就是你们的新工作，专门负责这个。”

---

### [00:53:28] Lenny Rachitsky (Continued)

**English:**
You worked in different part of the office. There's a metrics-based cadence. It's just like, let's stay really diligent about here's how it's going, here's where we're going, here's our track, here's our KPIs, things like that. Anything else there that you felt really important to making this work? Because a lot of companies are going to try to do this, I imagine, and so I'm curious what else you found important to make this work.

**中文翻译:**
你们在办公室的不同区域工作。有基于指标的节奏。保持勤勉，关注进展、方向、轨迹和 KPI 等等。还有什么你觉得对成功至关重要的吗？因为我猜很多公司都会尝试这样做，所以我很好奇你还发现了什么重要的东西。

---

### [00:53:50] Garrett Lord

**English:**
Yeah. I mean, I just really believe in separate and everything. Separate engineering team, separate design team, separate accounts and operations team, separate finance team. Early on, everything was separate. People only had one job and one job only, and that was making Handshake AI successful. We had a couple integration points more, and I had an incredible executive team and a core part of business, and now there's becoming more and more involvement. But our executives that have built Handshake for a long time ran the core business, and I focused 80 plus percent of my time and attention on just this. And we hired an incredible engineering leader like Avery, who ... We have a lot of entrepreneurs, people that have started companies inside the company. Or pardon me, people that started companies before. That was huge. A lot of familiarity with hiring talent that have only worked at early stage companies so [inaudible 00:54:44] that feels super comfortable with ambiguity.

**中文翻译:**
是的。我坚信“一切都要独立”。独立的工程团队、设计团队、客户与运营团队、财务团队。早期，一切都是独立的。每个人只有一项工作，那就是让 Handshake AI 成功。虽然我们有一些集成点，我也有优秀的高管团队负责核心业务，但现在参与度越来越高。长期建立 Handshake 的高管们负责核心业务，而我将 80% 以上的时间和精力集中在这件事上。我们聘请了像 Avery 这样优秀的工程领导者……我们公司内部有很多创业者，或者说以前创过业的人。这非常关键。我们非常熟悉如何招聘那些只在早期公司工作过、对模糊性感到非常适应的人才。

---

### [00:54:46] Garrett Lord (Continued)

**English:**
We were also way more upfront around this is going to be chaotic. Just owning that narrative in front of all hands at the core company, owning it directly with the team. We have a separate all hands, we have separate onboarding, we have a separate recruiting team. I had some connection points, but mostly separate. And I think that was absolutely critical. We took some of the top people, I mean, we have great people in the core business, we took some great people from the core businesses and basically said, "Sorry, I know you love your old team. I know you love what you're doing. Will you join us in Handshake AI?" And they completely forego their historical responsibilities and came over. That became really critical with engineering when things started to scale and topple, and we're growing so quickly we took some of our top senior engineers, who were very entrepreneurial, and principal engineers, staff of engineers, parachute them in. It's been awesome to ask some of the most talented people in the core business like, "Hey, do you want to come over here and do this?"

**中文翻译:**
我们也更加坦率地承认：这将会很混乱。在核心公司的全体会议上明确这一点，并直接与团队沟通。我们有独立的全体会议、独立的入职流程、独立的招聘团队。虽然有一些连接点，但大部分是独立的。我认为这绝对至关重要。我们从核心业务中抽调了一些顶尖人才，对他们说：“抱歉，我知道你喜欢原来的团队和工作，但你愿意加入 Handshake AI 吗？”他们完全放弃了过去的职责过来了。当工程规模开始扩大、遇到瓶颈时，这变得非常关键。由于增长太快，我们抽调了一些极具创业精神的资深工程师、首席工程师和幕僚工程师，把他们空降过来。能邀请核心业务中最有才华的人说“嘿，你想过来做这个吗？”，这种感觉很棒。

---

### [00:55:49] Garrett Lord (Continued)

**English:**
And sometimes they say no. They're like, "I don't want to work most of the weekends." The number of 2:00 AM, 3:00 AM nights we done in this business, I mean, it's quite regular. People sometimes don't want to commit to that, but we've been up front, like here are the expectations for this team. It's an insane pace. If you want to be a part of one of the fastest growing businesses in Silicon Valley, you can join it. The ownership too has also been huge, like owning this outcome, and we have this motto to leave nothing to chance. For a while there we drew the number of days in the year on the whiteboard and it was like, there will never be a time like this. I've never seen anything like it, I doubt I'll ever feel anything like this in business again where there's unlimited demand and it's just our ability to execute against it.

**中文翻译:**
有时他们会拒绝，说：“我不想大部分周末都加班。”在这项业务中，凌晨两三点还在工作是常态。有些人不想做出这种承诺，但我们会提前说明团队的预期。这是一种疯狂的节奏。如果你想成为硅谷增长最快的业务之一的一员，你可以加入。所有权意识（ownership）也非常关键，就像对这个结果负责。我们有一个座右铭：不留任何遗憾（leave nothing to chance）。有一段时间，我们在白板上画出了一年中的天数，心想：再也不会有这样的时代了。我从未见过这样的情况，我怀疑在商业生涯中是否还能再次感受到这种需求无限、全看执行力的情况。

---

### [00:56:39] Garrett Lord (Continued)

**English:**
And so, we had this motto like leave nothing to chance. How do you make sure that three months are not six months? You have no regrets. Get on the plane to go talk to a customer, make the late night push, check the data six times over again, ship the extra feature that helps. And really, a huge celebratory culture too. It's very flat so there really isn't this principle of ... There's so many people putting up points, directly calling out the people that are putting up points and creating a really fun environment around impact I think has been awesome.

**中文翻译:**
所以我们有了这个座右铭：不留遗憾。你如何确保三个月能完成的事不拖到六个月？确保你没有遗憾。去赶飞机和客户面谈，熬夜冲刺，把数据检查六遍，发布那个有用的额外功能。此外，还有浓厚的庆祝文化。团队非常扁平，所以没有那种……有很多人在立功，直接表扬那些立功的人，围绕“影响力”创造一个非常有趣的环境，我觉得这很棒。

---

### [00:57:14] Lenny Rachitsky

**English:**
The leave nothing to chance piece I imagine speaks partly to the value of trust in what you're doing. You win if they can trust that your data's awesome, and great, and consistent, and I could see why that ends up being such an important part of what you're building. And just listening to you describe this, I understand it's obviously a massive opportunity, obviously a massive advantage you guys have, and just the stress that comes with that burden also imagine is very high of just like we can't screw this up.

**中文翻译:**
“不留遗憾”这一点，我想部分反映了信任在你们工作中的价值。如果客户能信任你们的数据是优秀的、一致的，你们就赢了。我能理解为什么这成了你们构建业务的重要组成部分。听你描述这些，我明白这显然是一个巨大的机会，你们拥有巨大的优势，但随之而来的压力肯定也很大——那种“我们绝对不能搞砸”的压力。

---

### [00:57:44] Garrett Lord

**English:**
No. Yes, Handshake should be a ... Business does billions dollars revenue as a public company, we should be able to continue to ... I mean, and it also helps our core business. The longer term opportunity that we see is it's connecting, it's building the best job mashing marketplace on the internet. It's probably one of the largest problems in the world like labor supply mashing. It's where people spend most of their time and energy, just hours of their life they spend it at work. The process of searching for a job, applying to a job is going to be completely reinvented with AI. We've been leading the charge there. An AI interviewer that's collecting skills and actually asking about your experiences, doing work simulation experiences that help employers find the best candidates. I mean, I don't know the last time you've done this, but the hiring manager process, reviewing 200 resumes, are you kidding me?

**中文翻译:**
是的，Handshake 应该成为一家年收入数十亿美元的上市公司，我们应该能够继续……而且这也有助于我们的核心业务。我们看到的长期机会是连接，是建立互联网上最好的职位匹配市场。劳动力供需匹配可能是世界上最重大的问题之一。这是人们花费最多时间和精力的地方，他们把生命中的无数小时花在工作上。找工作、申请工作的过程将被 AI 彻底重塑。我们一直处于领先地位。AI 面试官可以收集技能并询问你的经历，进行工作模拟体验，帮助雇主找到最佳候选人。我是说，我不知道你上次做招聘是什么时候，但作为招聘经理去筛选 200 份简历？开什么玩笑。

---

### [00:58:49] Garrett Lord (Continued)

**English:**
I'm going to sit there and review 200 resumes? Not a chance five years from now. Students manually making cover ... Not a chance. So, there will need to be a marketplace that wins in connecting supply and demand, and talent with opportunity, and we think and get psyched about the opportunity for impact here. That's my story, I went to community college, I paid my way through school. I went to a no name school in Upper Peninsula of Michigan. I worked at Palantir as an intern, it totally changed my life, and I started Handshake because I wanted to make it easier for anyone regardless of who you knew, what your parents did, what school you went to, to find a great opportunity. And I think AI, totally step function improvement in matching. And I think that our human data business is really serving as the foundation for improving matching.

**中文翻译:**
五年后，我绝对不会再坐在那里筛选 200 份简历。学生手动写求职信？也不可能了。因此，需要一个能在连接供需、人才与机会方面胜出的市场，我们对在这里创造影响力的机会感到非常兴奋。这就是我的故事：我上过社区大学，自己打工交学费。我去了密歇根州上岛的一所无名学校。我在 Palantir 当过实习生，那彻底改变了我的生活。我创办 Handshake 是因为我想让任何人，无论你认识谁、你父母是做什么的、你上的是哪所学校，都能更容易地找到好机会。我认为 AI 将在匹配效率上带来阶跃式的提升。而我们的人类数据业务，正是在为改进这种匹配奠定基础。

---

### [00:59:44] Garrett Lord (Continued)

**English:**
A lot of things that we're doing in the human data business are being integrated to our core business. I think that's going to improve outcomes for employers, save them in the aggregate like billions of dollars over time. And I think it makes the experience way better for students. So, it's just like we have to meet the moment. We still have the stamina, and the excitement, and the passion internally in our core and in the new business to go charge after this. And that's a lot of the message we've been sharing internally is it's time to amp it up. This is a once in a lifetime opportunity to be positioned as well, and we are going to make the moment as a team.

**中文翻译:**
我们在人类数据业务中做的很多事情正在被整合到核心业务中。我认为这将改善雇主的招聘结果，随着时间的推移，总共能为他们节省数十亿美元。同时，我也认为这会让学生的体验变得更好。所以，我们必须抓住这个时机。我们的核心业务和新业务内部依然拥有足够的耐力、兴奋感和激情去冲刺。这也是我们一直在内部传达的信息：是时候加大马力了。这是一个千载难逢的机会，我们作为一个团队将共同创造这一时刻。

---

### [01:00:19] Lenny Rachitsky

**English:**
It really is. This very much feels like a once in a lifetime opportunity. Let me ask a few other questions along these lines that are something I've been thinking about, something that a lot of people think about, just while I have you, there's always this question of will we run out of data? Will model stop advancing? Are we going to hit some plateau and there's not actually going to be some AGI moment, SGI moment? So first of all, do you think we'll run out of data? There's a point at which we just can't produce more knowledge and data to feed these models? And along those lines, what do you think is the biggest bottleneck to advancing models faster and further?

**中文翻译:**
确实如此。这感觉就像是千载难逢的机会。趁你还在，我想问几个我一直在思考、也是很多人在思考的问题：我们会用完数据吗？模型会停止进步吗？我们会遇到瓶颈，导致 AGI（通用人工智能）时刻永远不会到来吗？首先，你认为我们会用完数据吗？是否存在一个点，我们无法再生产更多的知识和数据来喂养这些模型？顺着这个思路，你认为进一步加速模型发展的最大瓶颈是什么？

---

### [01:00:50] Garrett Lord

**English:**
Yeah, I mean, it's just the type of data we're going to need is going to evolve. It's going to be CAD files, it's going to be scientific tool use data as they try to automate scientific discoveries and drug discovery. It's going to be esoteric operating systems that exist on scientific tools. So, I love this trajectory and stitching together step-by-step instruction following. The type of data we're going to need is going to evolve a lot. And we haven't even talked about multimodal, and video, and text and audio. There's a huge demand for audio data right now. So, the type of data's going to evolve.

**中文翻译:**
是的，我认为我们需要的数据类型会演变。它将变成 CAD 文件，变成科学工具的使用数据（因为他们试图自动化科学发现和药物研发），变成科学工具上存在的深奥操作系统数据。所以我非常看好这种“轨迹”和“逐步指令遵循”的结合。我们需要的数据类型会发生巨大变化。我们还没聊到多模态、视频、文本和音频。现在对音频数据的需求就非常巨大。所以，数据类型会不断演进。

---

### [01:01:38] Lenny Rachitsky

**English:**
Yeah, I use voice mode all the time. That's on my default ChatGPT experience, just talking to-

**中文翻译:**
是的，我经常使用语音模式。那是我的默认 ChatGPT 体验，就是直接对话——

---

### [01:01:42] Garrett Lord

**English:**
It's amazing. It's amazing. I just had a baby on, or my wife had a baby on Sunday, and voice mode's been incredible. I mean, every night, every two hours it's like I have more questions. Voice mode's been huge. So, shot out voice mode. Yeah, so the type of data is going to collect a lot, or change a lot. I think synthetic data has a role to play and in verifiable domains, but what we consistently hear from companies it's like synthetic data is not going to dominate. There's billions, and billions, and billions of dollars of value to extract as a company over the next decade and following the frontier of AI development.

**中文翻译:**
太神奇了。我刚当了爸爸，我妻子周日刚生了宝宝，语音模式简直太棒了。每天晚上，每隔两个小时我就会有更多问题。语音模式非常有用，向语音模式致敬。所以，数据的类型会改变很多。我认为合成数据（synthetic data）在可验证领域有其作用，但我们从公司那里听到的一致反馈是，合成数据不会占据主导地位。在接下来的十年里，随着 AI 发展的推进，作为一家公司，还有数以十亿计的价值等待挖掘。

---

### [01:02:24] Lenny Rachitsky

**English:**
Let me first say just huge kudos to you for just having a kid, your wife just having a kid a few days ago, and building this business that is growing bananas and doing this podcast conversation. I really appreciate you.

**中文翻译:**
首先我要向你致敬，你妻子几天前刚生了孩子，你还在经营这个增长疯狂的业务，同时还来参加播客访谈。我真的很感激。

---

### [01:02:35] Garrett Lord

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:02:36] Lenny Rachitsky

**English:**
Of course. Is there anything else that we haven't covered that you think might be helpful for folks to hear, or a part of your story that you think might be helpful for folks to learn from, or something you may want to just double down on that we've talked about before we get to a very exciting lightning round?

**中文翻译:**
不客气。在进入令人兴奋的闪电轮提问之前，还有什么我们没涵盖、但你觉得对大家有帮助的内容吗？或者是你故事中值得大家学习的部分，或者你想再次强调的内容？

---

### [01:02:52] Garrett Lord

**English:**
I mean, the thing I always love talking, I'm really passionate about people starting companies and helping them do so. I just think in this moment right now with AI, for young entrepreneurs that listen, that read this podcast, because I've been a reader since 2020. We looked.

**中文翻译:**
我一直很喜欢聊这个，我非常热衷于鼓励人们创业并帮助他们。我认为在当前的 AI 浪潮中，对于听这个播客、读这个播客的年轻创业者来说（顺便说一下，我从 2020 年起就是你的读者了，我们查过了）。

---

### [01:03:07] Lenny Rachitsky

**English:**
Yeah, we did check. That's incredible.

**中文翻译:**
是的，我们查过了。太棒了。

---

### [01:03:08] Garrett Lord

**English:**
Yeah, been a long-term reader. I'm just so curious and love sucking up-

**中文翻译:**
是的，我是长期读者。我非常有好奇心，喜欢吸收——

---

### [01:03:08] Lenny Rachitsky

**English:**
Appreciate it.

**中文翻译:**
非常感谢。

---

### [01:03:11] Garrett Lord

**English:**
... your interviews. But it's like you just focus on doing something of meaning that really helps people. And I think with AI, there's going to be so many opportunities to improve the way people learn. I'm just really passionate about trying to make Handshake a platform that is not only an incredible business, but is also something that really helps solve a societal problem that matters. And yeah, that's be my one shout out here. If anyone wants advice on how to do that or wants to reach out, I'm happy to chat.

**中文翻译:**
……你的访谈。但关键在于，你要专注于做一些真正能帮助他人的有意义的事情。我认为有了 AI，将会有很多机会来改进人们的学习方式。我非常热衷于将 Handshake 打造为一个不仅是出色业务，而且能真正帮助解决重大社会问题的平台。这就是我想说的。如果有人想在这些方面获得建议或想联系我，我很乐意交流。

---

### [01:03:43] Lenny Rachitsky

**English:**
Okay, so this is an offer to share advice on starting companies within AI. Is that the offer here? Just so folks-

**中文翻译:**
好的，所以这是一个关于在 AI 领域创业提供建议的邀请？是吗？为了让大家——

---

### [01:03:50] Garrett Lord

**English:**
Yeah, that'd be great.

**中文翻译:**
是的，那太好了。

---

### [01:03:50] Lenny Rachitsky

**English:**
Okay. I don't know how much time you'll have for the hundreds of thousands of people coming your way, but I appreciate the offer. That's very cool. Anything else before we get to a very exciting lightning round?

**中文翻译:**
好的。我不知道你有没有时间应付成千上万找你的人，但我很感谢这个提议。这很酷。在进入闪电轮之前还有别的吗？

---

### [01:04:00] Garrett Lord

**English:**
No.

**中文翻译:**
没有了。

---

### [01:04:02] Lenny Rachitsky

**English:**
Well, with that Garrett, we reached our very exciting lightning round. We've got five questions for you. Are you ready?

**中文翻译:**
那么 Garrett，我们进入了令人兴奋的闪电轮。我有五个问题要问你。准备好了吗？

---

### [01:04:06] Garrett Lord

**English:**
Ready.

**中文翻译:**
准备好了。

---

### [01:04:07] Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
你最常向别人推荐的两三本书是什么？

---

### [01:04:11] Garrett Lord

**English:**
I'm a sucker for Peter Thiel's Zero to One. I read it when I started the company, and watched Peter Thiel's startup school class at Stanford he taught back in the days where there wasn't everything written on the internet about how to start companies, and just think he was the coolest. Love Shoe Dog. I think it's the epitome of starting a company. Hard Things About Hard Things obviously, but these are all quite common books.

**中文翻译:**
我非常喜欢彼得·蒂尔的《从 0 到 1》。我在创办公司时读了它，还看了他在斯坦福教的创业课，那时候网上还没这么多关于创业的资料，我觉得他酷毙了。我也喜欢《鞋狗》（Shoe Dog），我认为它是创业精神的缩影。当然还有《创业维艰》（Hard Things About Hard Things），不过这些都是很常见的书。

---

### [01:04:38] Lenny Rachitsky

**English:**
But also classics. Ben Horowitz is coming on the podcast, talk about Hard Things About Hard Things.

**中文翻译:**
但也是经典。本·霍罗维茨也要来这个播客聊聊《创业维艰》。

---

### [01:04:42] Garrett Lord

**English:**
Super cool.

**中文翻译:**
太酷了。

---

### [01:04:43] Lenny Rachitsky

**English:**
The Hard Thing About Hard Things. Yeah. Okay, have you seen a recent movie or TV show you really enjoy it? I imagine you don't have much time for this, but-

**中文翻译:**
是的，《创业维艰》。好的，你最近看过什么非常喜欢的电影或电视剧吗？我猜你没多少时间看，但是——

---

### [01:04:49] Garrett Lord

**English:**
I'm going to get blasted for this, but I did start Game of Thrones with my wife, and I cannot-

**中文翻译:**
我可能会因此被吐槽，但我确实刚开始和妻子一起看《权力的游戏》，我简直——

---

### [01:04:55] Lenny Rachitsky

**English:**
For the first time.

**中文翻译:**
第一次看？

---

### [01:04:56] Garrett Lord

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:04:56] Lenny Rachitsky

**English:**
Okay, cool.

**中文翻译:**
好的，酷。

---

### [01:04:57] Garrett Lord

**English:**
So, I got a lot of catching up to do.

**中文翻译:**
所以我还有很多进度要赶。

---

### [01:04:59] Lenny Rachitsky

**English:**
Why would you get ... No, this is great. It's like people that have watched it-

**中文翻译:**
为什么要吐槽……不，这很好。就像那些看过的人——

---

### [01:04:59] Garrett Lord

**English:**
I've loved it so far.

**中文翻译:**
到目前为止我很喜欢。

---

### [01:05:02] Lenny Rachitsky

**English:**
You've loved it so far? Okay. It's quite gruesome, that's the only downside of that show. Don't watch it before you go to bed, I don't know how many gruesome scenes you've seen already. Do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
目前很喜欢？好的。那部剧挺血腥的，那是唯一的缺点。别在睡觉前看，我不知道你已经看过多少血腥场面了。你最近有没有发现什么非常喜欢的个人产品？

---

### [01:05:14] Garrett Lord

**English:**
The SNOO. The baby automated SNOO has really helped us a lot. So love the, shout-out SNOO team.

**中文翻译:**
SNOO。那个婴儿自动摇篮真的帮了我们大忙。非常喜欢，向 SNOO 团队致敬。

---

### [01:05:24] Lenny Rachitsky

**English:**
Amazing. I had a SNOO as well. We never actually turned it on, we just ended up using it as a basinet the whole time.

**中文翻译:**
太棒了。我也买过 SNOO，但我们其实从来没打开过电源，最后一直把它当普通摇篮用。

---

### [01:05:28] Garrett Lord

**English:**
Yeah, most of the time it's not turned on, but a couple of cries it's been turned on, it's been very helpful.

**中文翻译:**
是的，大部分时间没开，但孩子哭了几次后打开它，确实很有帮助。

---

### [01:05:33] Lenny Rachitsky

**English:**
Do you have favorite life motto that you find yourself coming back to, sharing with other people?

**中文翻译:**
你有没有什么最喜欢的人生格言，是你经常想起并分享给他人的？

---

### [01:05:37] Garrett Lord

**English:**
I love that leave nothing to chance, leave it all out on the field. Grew up in a really hardworking family, and dad worked really hard to provide, make it happen for us and it's like just give it your all. Leave nothing a chance.

**中文翻译:**
我喜欢“不留遗憾，全力以赴”。我在一个非常勤劳的家庭长大，我父亲为了养家糊口非常努力。所以就是：付出你的全部，不留任何遗憾。

---

### [01:05:51] Lenny Rachitsky

**English:**
Okay. So the last question, I was researching you in prep for this podcast and there's a story that I love about your hustle early on is when you were going from campus to campus pitching schools to join Handshake, and there's a story where you had to shower in the Princeton's pool to save money because you just didn't have a place to stay. Is there something there? Is there a story there you could share?

**中文翻译:**
好的。最后一个问题，我在为这期播客做调研时，看到一个关于你早期拼搏的故事：当你奔波于各个校园游说学校加入 Handshake 时，为了省钱，你曾在普林斯顿大学的游泳池洗澡，因为你没地方住。有这回事吗？能分享一下这个故事吗？

---

### [01:06:13] Garrett Lord

**English:**
Yeah, so it was a tough one. I mean, I almost got arrested at Princeton, because I mean, I guess for entrepreneurs that are traveling around all the time, we were sleeping out of our car. We had this Ford focus, we would put 20, 30,000 miles on it, sleep in the back of like McDonald's parking lots because they're well lit and had good wifi back in the day. And instead of staying in a hotel, a way to freshen up ahead of your meeting is every university has a pool and the pool's almost always, it is always open. We never had a situation where it's always open for people to swim in the morning, like fitness. Faculty, students. And every pool, what do they have? They have a shower.

**中文翻译:**
是的，那段日子挺难的。我差点在普林斯顿被捕。对于那些经常出差的创业者来说，我们当时睡在车里。我们有一辆福特福克斯，开了两三万英里，睡在麦当劳的停车场，因为那里灯火通明，而且当时有很好的 Wi-Fi。为了在开会前梳洗一番，我们发现每所大学都有游泳池，而且早上通常都对教职员工和学生开放健身。而每个游泳池都有什么？都有淋浴间。

---

### [01:06:49] Garrett Lord (Continued)

**English:**
So, you could go to any pool at any university in the country, and you can get a free shower and freshen up. So, the Princeton campus security did not appreciate me showering as a non-student, but I think it meaningfully helped us because the Princeton campus security called the career service center director we were selling to, being like, "Who's Garrett Lord? Is he really here to pitch you software for your career center?" And it made the start of the meeting with the career center really stimulating and exciting, because they were like, "You showered in our pool, you drove here?" "Yeah, we drove here from Michigan." And so, I think that showed a level of commitment that was exciting for them.

**中文翻译:**
所以，你可以去全国任何一所大学的游泳池免费洗个澡。普林斯顿的校园安保对我这个非学生在那洗澡并不太高兴，但我认为这反而帮了我们。因为安保人员打电话给我们正要游说的职业服务中心主任，问：“Garrett Lord 是谁？他真的是来给你们推销软件的吗？”这让会议的开场变得非常有趣和令人兴奋，因为他们问：“你在我们的游泳池洗澡？你是开车来的？”“是的，我们从密歇根州开车过来的。”我认为这展现了一种让他们感到兴奋的投入程度。

---

### [01:07:29] Lenny Rachitsky

**English:**
Fast-forward to all these founders now starting to use this growth lever of getting in trouble with the campus police to get better meetings with the school leaders. Incredible. Garrett, this is such an insane, amazing, inspiring story, just like what you're building and the opportunity here, and just how it's fast, it's going, and all the advantages you have. If I was an investor in Handshake, I'd be like, "All right, 10 years, it's going great." And now it's like, "Whoa, holy shit. Where did this come from?" Incredible. And it's just also really meaningful. So, I'm really happy that you made time for this in spite of the madness you are in right now. Two final questions, where can folks find you if they want to maybe reach out or maybe if you're hiring, let us know. And then, how can listeners be useful to you?

**中文翻译:**
快进到现在，所有的创始人都开始利用“被校园警察找麻烦”这个增长杠杆来获得与学校领导更好的面谈机会了。太不可思议了。Garrett，这是一个疯狂、精彩且鼓舞人心的故事，无论是你们正在构建的东西、眼前的机会，还是它的发展速度和你们拥有的优势。如果我是 Handshake 的投资者，我会觉得：“好吧，十年了，表现不错。”但现在我会惊呼：“哇，天哪，这是从哪冒出来的？”这太棒了，而且非常有意义。我很开心你能抽时间参加，尽管你现在忙得不可开交。最后两个问题：如果大家想联系你，或者你们正在招聘，在哪里可以找到你？以及，听众可以如何帮到你？

---

### [01:08:12] Garrett Lord

**English:**
I mean, sign up for Handshake. If you want to message me on there, it's the easiest way to reach me. Just find me at garrettlord@Handshake, and you find me on Twitter. Love X, huge X guy. You can email me at garrett@joinhandshake.com and double R, double T. And how can you be helpful? We are trying to hire so many people. We have offices in New York and in San Francisco, and London and Berlin. If you have friends that are maybe passionate about this, you let them know, or you're interested in the learning more, please reach out. We'd love to talk to you. Hiring is like the number one problem we have right now to meet the demand. So, if you're talented and interested in learning more about Handshake, if you want to work on our consumer product, if you want to work on our employer products, cool PLG issues or the state-of-the-art consumer social experience, like reach out, or you want to work on the AI business we'd love to talk to you.

**中文翻译:**
注册 Handshake 吧。如果你想在那上面给我发消息，那是联系我最简单的方式。直接搜 garrettlord@Handshake。你也可以在 Twitter 上找到我，我是 X 的重度用户。你可以发邮件到 garrett@joinhandshake.com（Garrett 是两个 R，两个 T）。至于如何帮到我：我们正在大规模招聘。我们在纽约、旧金山、伦敦和柏林都有办公室。如果你有朋友对此感兴趣，请告诉他们，或者你想了解更多，请联系我们。我们很乐意与你交谈。招聘是我们目前为了满足需求而面临的首要问题。所以，如果你有才华并对 Handshake 感兴趣，无论你想做 C 端产品、B 端产品、酷炫的 PLG（产品驱动增长）项目，还是最前沿的社交体验，或者你想加入 AI 业务，请联系我们。

---

### [01:09:06] Lenny Rachitsky

**English:**
To make it even more clear for folks, what roles are you most hiring for? Is it every role? Is it engineering?

**中文翻译:**
为了让大家更明确，你们最急缺什么职位？是所有职位吗？还是工程师？

---

### [01:09:11] Garrett Lord

**English:**
Engineers.

**中文翻译:**
工程师。

---

### [01:09:12] Lenny Rachitsky

**English:**
Engineering, all right. If you're an engineer and want to join one of the fastest growing AI companies in the world right now, here we go. We'll link to your careers page in the show notes.

**中文翻译:**
工程师，好的。如果你是一名工程师，想加入目前世界上增长最快的 AI 公司之一，机会来了。我们会在节目介绍中附上你们的招聘页面链接。

---

### [01:09:18] Garrett Lord

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:09:19] Lenny Rachitsky

**English:**
Yeah, of course. Garrett, thank you so much for being here. This was incredible.

**中文翻译:**
不客气。Garrett，非常感谢你能来。这太精彩了。

---

### [01:09:22] Garrett Lord

**English:**
Of course.

**中文翻译:**
我的荣幸。

---

### [01:09:24] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 Lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。