# Gaurav Misra - 双语对照

# Lenny's Podcast: Gaurav Misra (CEO of Captions) - Bilingual Transcript
## 嘉宾：Gaurav Misra (Captions 首席执行官) - 中英双语对照转录

---

### [00:00:00] Gaurav Misra

**English:**
There's rarely a time like this where so much is possible. Even like five, seven years ago, it's so hard to start a company. Everything feels like it's done, someone else is working on it. Suddenly, it's a time, right now, which I've never even experienced, where everything you try just works.

**中文翻译:**
很少有像现在这样的时刻，有这么多可能性。即便是在五、七年前，创业还非常困难。感觉所有事情都已经有人做了，或者别人正在做。突然间，到了现在这个我从未经历过的时代，你尝试的每一件事似乎都能奏效。

---

### [00:00:14] Lenny Rachitsky

**English:**
With people constantly hearing about all the things happening. Is there any tools or processes or approaches you've figured out to help stay focused?

**中文翻译:**
人们不断听到各种新鲜事发生。你有没有总结出什么工具、流程或方法来帮助自己保持专注？

---

### [00:00:21] Gaurav Misra

**English:**
Our engineering goal is every engineer should ship a marketable product every week.

**中文翻译:**
我们的工程目标是：每位工程师每周都应该发布一个具备市场推广价值（marketable）的产品。

---

### [00:00:27] Lenny Rachitsky

**English:**
I love just how wild that sounds. How do you maintain quality and make it all cohesive?

**中文翻译:**
我喜欢这个听起来很疯狂的想法。你如何维持质量并确保所有东西都是连贯统一的呢？

---

### [00:00:31] Gaurav Misra

**English:**
I actually think as a startup your job is to take on technical debt because that is how you operate faster than a bigger company. Bigger companies don't take contact technical debt, they pay it usually right away, or they're paying back technical debt from the days when they were a startup.

**中文翻译:**
我其实认为，作为一家初创公司，你的职责就是承担技术债（technical debt），因为这是你比大公司运作更快的秘诀。大公司通常不承担技术债，他们要么立即偿还，要么就是在偿还他们初创时期的欠下的债。

---

### [00:00:45] Lenny Rachitsky

**English:**
Is there anything else that in how you operate and the way you build product that you think is really unique and interesting?

**中文翻译:**
在你们的运作方式和产品构建方式中，还有什么你认为非常独特且有趣的地方吗？

---

### [00:00:50] Gaurav Misra

**English:**
We have what we think of as the public roadmap. This is basically what people have asked us for. There's all these surface areas where we receive user feedback, but these are all features that every competitor knows about. If a user is asking us for it, they're asking everybody for it.
(00:01:04):
It's not going to be a game changer in terms of winning against your competition. So we have a second roadmap which we think of as a secret roadmap.

**中文翻译:**
我们有一个所谓的“公开路线图”。这基本上是用户要求我们做的东西。我们在各个层面接收用户反馈，但这些功能每个竞争对手也都知道。如果用户向我们提要求，他们也会向所有人提。
(00:01:04):
在战胜竞争对手方面，这些功能不会成为游戏规则的改变者。所以我们有第二个路线图，我们称之为“秘密路线图”。

---

### [00:01:15] Lenny Rachitsky

**English:**
Today my guest is Gaurav Misra. Gaurav was an early employee at Snap where he led the design engineering team, which he explains in the conversation. He's also an engineer at Microsoft and a couple other companies. Most recently, he's the co-founder and CEO of Captions, one of the most successful and cutting-edge consumer AI products, which lets you generate and edit talking videos with AI. They have over 10 million users and have raised over a hundred million dollars.
(00:01:39):
In our conversation, we essentially do an archeology of how a modern AI oriented startup operates, including how every single engineer at their company ships a marketable product or feature every single week. Why they have a secret roadmap, in addition to a regular roadmap. We also get in-depth about how Snap as a product team operated. What he's learned about what it takes to build a successful consumer and social app, why they had no PMs and how designers ran the show, which may or may not have been a great idea. And also what happens in a world where AI video is so good that you have no idea if it's real or not. This episode is for anyone that is building a product on top of AI. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app. And also, I just launched an insane deal for subscribers of my newsletter. Every yearly subscriber now gets a year free of Notion, Perplexity, Superhuman, Linear and Granola. Learn more at lennysnewsletter.com. With that, I bring you Gaurav Misra.

**中文翻译:**
今天的嘉宾是 Gaurav Misra。Gaurav 曾是 Snap 的早期员工，领导过设计工程团队（他会在对话中解释这一点）。他还曾在微软和其他几家公司担任工程师。最近，他是 Captions 的联合创始人兼 CEO。Captions 是目前最成功、最前沿的消费级 AI 产品之一，它能让你利用 AI 生成和编辑真人出镜的视频。他们拥有超过 1000 万用户，融资超过 1 亿美元。
(00:01:39):
在我们的对话中，我们基本上是对一家现代 AI 导向型初创公司的运作方式进行了一次“考古研究”，包括他们公司的每一位工程师如何每周发布一个可营销的产品或功能；为什么除了常规路线图外，他们还有一个秘密路线图。我们还深入探讨了 Snap 产品团队的运作方式。他学到了构建成功的消费级和社交应用需要什么，为什么他们当时没有产品经理（PM）以及设计师如何主导全局（这可能是一个好主意，也可能不是）。此外，我们还讨论了如果 AI 视频好到让你分不清真假，世界会发生什么。这一集适合任何正在基于 AI 构建产品的人。如果你喜欢这个播客，别忘了在订阅并关注。另外，我刚刚为我的通讯（Newsletter）订阅者推出了一个疯狂的优惠：现在每位年度订阅者都可以免费获得一年的 Notion、Perplexity、Superhuman、Linear 和 Granola。更多信息请访问 lennysnewsletter.com。下面，让我们欢迎 Gaurav Misra。

---

### [00:02:39] Lenny Rachitsky (Sponsorship)

**English:**
This episode is brought to you by Brex, the financial stack used by one in every three US venture-backed startups. Brex knows the nearly 40% of startups fail because they run out of cash, so they built a banking experience that focuses on helping founders get more from every dollar. It's a stark difference from traditional banking options that leave a startup's cash sitting idle while chipping away at it with fees. To help founders protect cash and extend runway, Brex combined the best things about checking treasury and FDIC insurance in one powerhouse account. You can send and receive money worldwide at lightning speed. You can get 20x the standard FDIC protection through program banks and you can earn industry-leading yield from your first dollar while still being able to access your funds anytime. To learn more, check out Brex at brex.com/banking-solutions. That's brex.com/banking-solutions.

**中文翻译:**
本集节目由 Brex 赞助。Brex 是美国每三家风投支持的初创公司中就有一家在使用的金融工具栈。Brex 深知近 40% 的初创公司倒闭是因为现金耗尽，因此他们构建了一种银行体验，专注于帮助创始人从每一美元中获得更多价值。这与传统的银行选择截然不同，传统银行会让初创公司的现金闲置，同时通过各种费用蚕食它。为了帮助创始人保护现金并延长跑道（runway），Brex 将支票账户、国库券和 FDIC 保险的优点结合在一个强大的账户中。你可以以闪电般的速度在全球范围内收付款。你可以通过合作银行获得 20 倍于标准 FDIC 的保护，并且从第一美元起就能赚取行业领先的收益，同时仍能随时提取资金。欲了解更多信息，请访问 brex.com/banking-solutions。

---

### [00:03:36] Lenny Rachitsky (Sponsorship)

**English:**
This episode is brought to you by Paragon. The integration infrastructure for B2B SaaS companies is AI on your 2025 product roadmap. Whether you need to enable RAG with your user's external data like Google Drive files, Gong transcripts, or Jira tickets, or build AI agents that can automate work across your user's other tools, integrations are the foundation. But building all these integrations in-house will cost you years of engineering, time you don't have given the fast pace of AI. That's where Paragon's all-in-one integration platform comes in. Build scalable workflows to ingest all of your user's external data into your RAG pipelines. And leverage, ActionKit, their latest product to instantly give your AI agents access to over 100 integrations and thousands of third-party actions with a single API call.
(00:04:24):
Leading AI companies like AI21, you.com, 11X, and Copy.ai are already shipping new integrations seven times faster with Paragon keeping their engineers focused on core product development. Ready to accelerate your AI roadmap this year, visit useparagon.com/lenny to get a free MVP of your next product integration.

**中文翻译:**
本集节目由 Paragon 赞助。B2B SaaS 公司的集成基础设施是否已列入你 2025 年的产品路线图？无论你是需要利用用户的外部数据（如 Google Drive 文件、Gong 转录本或 Jira 工单）启用 RAG（检索增强生成），还是构建能够跨用户其他工具自动执行任务的 AI 智能体，集成都是基础。但在内部构建所有这些集成将耗费数年的工程时间，考虑到 AI 的快速发展，你没有那么多时间。这就是 Paragon 全方位集成平台的用武之地。构建可扩展的工作流，将用户的所有外部数据摄取到你的 RAG 管道中。并利用他们最新的产品 ActionKit，通过单个 API 调用立即让你的 AI 智能体访问 100 多个集成和数千个第三方操作。
(00:04:24):
AI21、you.com、11X 和 Copy.ai 等领先的 AI 公司已经通过 Paragon 将新集成的发布速度提高了七倍，让他们的工程师专注于核心产品开发。准备好加速你今年的 AI 路线图了吗？访问 useparagon.com/lenny 获取你下一个产品集成的免费 MVP。

---

### [00:04:50] Lenny Rachitsky

**English:**
Gaurav, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Gaurav，非常感谢你能来，欢迎来到播客。

---

### [00:04:53] Gaurav Misra

**English:**
Thank you. Thanks for having me. Excited.

**中文翻译:**
谢谢。感谢邀请我。我很兴奋。

---

### [00:04:55] Lenny Rachitsky

**English:**
I very rarely have early stage founders on the podcast, but I wanted to chat with you because you're at the center of so much of what is top of mind for a lot of builders these days, AI and video, and just consumer and social apps.
(00:05:11):
Also going viral and finding new marketing channels. So I think there's a lot that people can learn from the way you approach product, the way you've built product and the way you just think about where things are going. So again, thank you for being here.

**中文翻译:**
我很少邀请早期阶段的创始人来播客，但我很想和你聊聊，因为你正处于当今许多开发者最关注的领域中心：AI 与视频、消费级与社交应用。
(00:05:11):
还有如何走红以及寻找新的营销渠道。所以我认为人们可以从你对待产品的方式、构建产品的方式以及你对未来走向的思考中学到很多。再次感谢你的到来。

---

### [00:05:26] Gaurav Misra

**English:**
Appreciate it. Honestly, it's an exciting time. I got to say like there's rarely a time like this where so much is possible. In normal times, if you think about even five, seven years ago, it's so hard to start a company. It's so hard to come up with an idea. It's just like everything feels like it's done, someone else is working on it. Or it's like, oh it's been tried three times and failed three times. And suddenly, it's a time, right now, which I've never even experienced honestly in my career, where everything you try just works.
(00:05:56):
There's so many possibilities. There's not enough people in the world to work on them. Honestly. There's more things that can be done than there's people available to do them. It is just such a rare thing. And honestly, it's not going to last forever. We are going to catch up to this, but just feels lucky to be part of that movement. It's awesome.

**中文翻译:**
非常感谢。坦白说，这是一个令人兴奋的时代。我必须说，很少有像现在这样充满可能性的时刻。在平常时期，比如五、七年前，创业非常难。想出一个点子很难。感觉一切都已经被做过了，或者别人正在做。或者就是，“哦，这已经尝试过三次了，失败了三次”。而突然间，就在现在，我职业生涯中从未经历过这样的时刻——你尝试的每一件事似乎都能奏效。
(00:05:56):
有太多的可能性了。世界上没有足够的人手去完成这些工作。说实话，能做的事情比能做这些事的人还要多。这真是太罕见了。而且坦白说，这不会永远持续下去。我们最终会赶上这波浪潮（指竞争会加剧），但现在能成为这场运动的一部分感到很幸运。这太棒了。

---

### [00:06:17] Lenny Rachitsky

**English:**
When you said everything is working, I think what's an important distinction there is the building of the tool works. The tech is now there to build all these things that have not been possible before. The thing that is increasingly, difficult, and I want to get your take on this, is getting anyone to pay attention and stick with your thing because it's so easy to build stuff and everything is just awesome and interesting. It's harder to get people to pay attention and stick with your product.
(00:06:42):
So I guess is there anything there, you've learned that you've built a number of successful products. We'll talk about Snap and what you're doing now, about just, I don't know, what you need to think about these days to get anyone to pay attention and then stick around.

**中文翻译:**
当你提到“一切都能奏效”时，我认为一个重要的区别是：构建工具这件事奏效了。现在的技术已经足以构建以前不可能实现的东西。但越来越难的事情是——我想听听你的看法——如何让人们关注并留下来使用你的产品。因为现在构建东西太容易了，每样东西看起来都很棒、很有趣。让人们关注并产生粘性反而变难了。
(00:06:42):
所以我想问，你已经构建了许多成功的产品，你学到了什么？我们会聊到 Snap 和你现在做的事情。在当今环境下，为了让人们关注并留下来，需要考虑些什么？

---

### [00:06:54] Gaurav Misra

**English:**
Yeah, I mean honestly it's a great point and I think there is a lot of hype obviously, and part of it, that's what's driving a lot of this growth for a lot of companies. And I think from a user acquisition/marketing perspective, in a world five or seven years ago, if you were making something novel and you went to users and it was like, "Oh, we got something better." People are going to be like, "Well, whatever. Everybody says they got something better. I don't care." But today, and this is not probably the way you should do it, but you can go and just say, "We've rethought this thing with AI." And a bunch of people will just be like, "Well, how?" Or "Maybe I should check this out."
(00:07:33):
They'll just try it. Obviously, you have to deliver on the promises. If you don't deliver, people will come in, they'll play around a bunch and then just leave. But if you can truly deliver on the promises, there's great opportunities to require users at scale. So I think that's slightly different. And I don't know how long that lasts, but it is definitely a different time from that perspective. I do think also at the core of building products is solving problems. I think a lot of people sort of get caught up in this, well, it's cool and people will come for the cool right now. People will come in and be like, "Well, let me check it out. It's cool."
(00:08:11):
But at the end of the day, if you're just building a playground and people play around in the playground and then they leave after playing around, it's not a business. So I think that is still key. You have to be solving real problems.

**中文翻译:**
是的，这确实是个很好的观点。显然现在有很多炒作，这在一定程度上推动了许多公司的增长。从用户获取和营销的角度来看，在五、七年前，如果你做了一些新奇的东西去找用户说：“嘿，我们有更好的东西。”人们会说：“哦，随便吧，每个人都说自己有更好的，我不在乎。”但今天——虽然这可能不是最推荐的做法——你可以直接说：“我们用 AI 重新构思了这件事。”然后一群人就会好奇：“哦？怎么做的？”或者“也许我该去看看。”
(00:07:33):
他们会愿意尝试。当然，你必须兑现承诺。如果你不兑现，人们进来玩一圈就走了。但如果你能真正兑现承诺，就有巨大的机会大规模获取用户。所以我认为这方面略有不同。我不知道这能持续多久，但从这个角度看，这确实是一个不同的时代。我也认为构建产品的核心是解决问题。我觉得很多人现在沉迷于“这很酷”，人们现在确实会为了“酷”而来。
(00:08:11):
但归根结底，如果你只是建了一个游乐场，人们在里面玩一玩就走，那这就不是一桩生意。所以核心依然没变：你必须解决真实的问题。

---

### [00:08:25] Lenny Rachitsky

**English:**
As we were talking, I'm thinking about every day there's something that would maybe a few years ago be news for a year. Holy shit, this is now possible. Now it's like every day something like that happens and then we're like, all right, so what I think about is like, we'll have AGI one of these days or super intelligence and everyone's going to be, "Oh, amazing." And then, "Okay, what's for dinner?"

**中文翻译:**
当我们聊天时，我在想，现在每天发生的事情，在几年前可能是一整年的大新闻。比如“天哪，这居然实现了”。现在感觉每天都有类似的事情发生，然后我们的反应是：“好吧，那接下来呢？”我在想，也许哪天我们实现了 AGI（通用人工智能）或超级智能，大家的反应会是：“噢，太棒了。”然后紧接着问：“行吧，晚饭吃什么？”

---

### [00:08:46] Gaurav Misra

**English:**
Isn't that already happening? Think about, in a way, I self-reflect on this sometimes if like, you've seen Iron Man and stuff, they have the J.A.R.V.I.S thing and you've seen Interstellar and they have the TARS machine. They're talking back and forth with these things like bouncing ideas. That is science fiction. That's literally science fiction. Okay, it's not perfect, but it exists in a way that nobody could have imagined. That's science fiction has become reality and I feel like nobody cares.
(00:09:18):
In a way, you would've expected the world to be turned upside down, but it feels like almost in a way so slow and people are like, yes, adoption is happening, but I feel like it's almost a shocking development in a way.

**中文翻译:**
这难道不是已经在发生了吗？想想看，我有时会反思：你看过《钢铁侠》，他们有 J.A.R.V.I.S；你看过《星际穿越》，他们有 TARS 机器人。他们和这些东西来回对话、碰撞想法。那是科幻小说，货真价实的科幻小说。好吧，现在的 AI 还不完美，但它以一种没人能想象的方式存在着。科幻已经变成了现实，但我感觉好像没人真正在意。
(00:09:18):
在某种程度上，你本以为世界会被彻底颠覆，但感觉过程却很缓慢，人们觉得“是的，大家都在用了”，但我认为这在某种程度上其实是一个令人震惊的发展。

---

### [00:09:31] Lenny Rachitsky

**English:**
It feels like you guys have done a good job staying top of mind and continuing to get people excited because to your point, there's so much happening. How do you get people to continue to be like, "Oh, okay, wow, what their building is actually is interesting and continues to be interesting."
(00:09:45):
Anything you've learned about just what it takes to stay top of mind and continue to pull people back and get people re-excited over and over?

**中文翻译:**
感觉你们在保持关注度和持续让人们兴奋方面做得很好，因为正如你所说，现在发生的事情太多了。你如何让人们持续觉得：“噢，好吧，哇，他们做的东西确实很有趣，而且一直很有趣。”
(00:09:45):
关于如何保持关注度、持续吸引用户回归并让他们一次又一次地感到兴奋，你学到了什么？

---

### [00:09:51] Gaurav Misra

**English:**
Hundred percent. I mean, I think honestly it just comes down to not just AI for the sake of AI or AI for the sake of excitement or hype or novelty or whatever that is, it's actually effective AI like AI that solves real problems, practical problems. And the fundamentals haven't changed. In a way, there's three steps to building products. You identify a user problem, you apply some technology to solve that problem, but then finally you have some mechanism to find people who have that problem. If you can do all three of those things, then in any environment you can create great products. But I think right now what's different is so much is changing on the technology side that you can create products that could not have been created before and solve problems that could not have been solved before. And that's creating the opportunity.
(00:10:45):
And for us, especially in the video space, it's truly endless. We've just begun, our goal specifically for video is not to build professional tools. We're not building for professionals at all. We're building for the person who could not have created video before. They didn't have the tools, the skills, the means to be able to create video and now they can because they're able to jump over that skill gap or that time gap. Maybe they're business owners, they don't have time, they want results, and honestly a lot to solve there just tons.

**中文翻译:**
百分之百同意。我认为归根结底，不能为了 AI 而 AI，或者为了兴奋感、炒作、新奇感而做 AI。它必须是有效的 AI，即能解决实际问题的 AI。基本原理没有改变。某种程度上，构建产品有三个步骤：识别用户问题，应用某种技术解决该问题，最后拥有一种机制来找到有该问题的人。如果你能做到这三点，那么在任何环境下你都能创造出伟大的产品。但我认为现在的不同之处在于，技术端的变化如此之快，以至于你可以创造出以前无法创造的产品，解决以前无法解决的问题。这就是机会所在。
(00:10:45):
对我们来说，特别是在视频领域，这真的是无穷无尽的。我们才刚刚开始。我们视频业务的具体目标不是构建专业工具。我们根本不是为专业人士构建的。我们是为那些以前无法制作视频的人构建的。他们以前没有工具、技能或手段来制作视频，而现在他们可以了，因为他们能够跨越技能鸿沟或时间鸿沟。也许他们是企业主，没有时间，但想要结果。坦白说，那里有太多的问题需要解决。

---

### [00:11:20] Lenny Rachitsky

**English:**
Solve people's problems. Easier said than done, but it's a good reminder. In the end that's all that matters. Something that I always think about with people in your shoes is just how do you not get overwhelmed and how do you know what to pay attention to? How do you stay focused?
(00:11:36):
Any tips there for folks that are just reading every day, a new announcement, and then just like I just, how do I? What do I do? There's too much.

**中文翻译:**
解决人们的问题。说起来容易做起来难，但这是一个很好的提醒。归根结底，这才是最重要的。对于处于你这种位置的人，我一直在想：你如何不被海量信息淹没？你如何知道该关注什么？你如何保持专注？
(00:11:36):
对于那些每天读到新公告就感到迷茫的人，你有什么建议吗？“我该怎么办？我该做什么？信息太多了。”

---

### [00:11:44] Gaurav Misra

**English:**
It is the new problem of product development in a way. There's too many possible paths you can go down. There's too many ideas, there's too many things you could do. And I mean obviously, prioritization is always an important skill set and has always been, but it's become an even more important skill set right now because you have to figure out what not to pay attention to. Our general framework for it is to look for user demand, and actually the easiest way to check for user demand is to just see what has virality.
(00:12:10):
Usually, what has virality and what people want to share and talk about, there's something at the core of it that actually is interesting. Now, it may not always be interesting in a way that's like maybe it's a one-time use case. Maybe it's not something that people would do repeatedly. Maybe it's not something you could build like a subscription business off of, but oftentimes there's some things, some core element of it that has resonated with people. And if you can identify that core and then mold it into fitting into your business, it's actually a great way to identify what actually works. And we have these tools right now. We don't have to build anything. You can just kind talk about it and people will share it, share the idea.
(00:12:49):
And you can measure how well the product might be received even before you built anything. So it's a great tool we use for prioritization. We spend a lot of time on social media. Obviously, our app is often used for social media, so a lot of our employees will spend a lot of time on social media. We look at what the trends are, what's happening, and based on that we can get a pretty good read of what might resonate well with people.

**中文翻译:**
这在某种程度上是产品开发面临的新问题。你可以走的路径太多了，点子太多了，能做的事情也太多了。显然，确定优先级（prioritization）一直是一项重要的技能，但现在它变得更加重要，因为你必须弄清楚哪些东西不该去关注。我们的通用框架是寻找用户需求，而检查用户需求最简单的方法就是看什么东西具有病毒式传播力（virality）。
(00:12:10):
通常，具有病毒式传播力、人们愿意分享和讨论的东西，其核心一定有某些真正有趣的东西。当然，它可能并不总是那种长久有趣的——也许它只是个一次性的用例，也许人们不会重复使用，也许你无法基于此建立订阅业务。但通常，它的某些核心元素引起了人们的共鸣。如果你能识别出那个核心，然后将其塑造成适合你业务的形式，这实际上是识别什么真正奏效的好方法。我们现在就有这些工具，甚至不需要构建任何东西，你只需要谈论它，人们就会分享这个想法。
(00:12:49):
你甚至可以在构建任何东西之前，就衡量产品的受欢迎程度。所以这是我们用于确定优先级的一个很好的工具。我们花很多时间在社交媒体上。显然，我们的应用经常被用于社交媒体，所以我们的很多员工会花大量时间在上面。我们观察趋势，观察正在发生的事情，并据此很好地判断什么可能会引起人们的共鸣。

---

### [00:13:15] Lenny Rachitsky

**English:**
So as a leader of a company with people constantly hearing about all the things happening, is there any tools or processes or approaches you've figured out to help people continue, stay focused, not get excited about every shiny new object and actually ship things?

**中文翻译:**
作为一名公司领导者，面对员工不断听到各种新动态的情况，你有没有总结出什么工具、流程或方法来帮助大家保持专注，不被每一个“闪亮的新事物”诱惑，并真正把东西发布出来？

---

### [00:13:30] Gaurav Misra

**English:**
I mean honestly, it's all about incrementality in a way. I think we do aim to ship every week. Our engineering goal is every engineer should ship a marketable product every week. And so what's a marketable product is a product that you can show to users and the user might subscribe or pay for the app just for that or come to the app essentially just for that. And that's why table stakes features, let's say we're talking about word processor or something. If you had auto format or just table stakes stuff like justify alignment or something, no one's going to come to your word processor for justify alignment. You can market that because it's obvious, of course it exists, but if you did something unique that nobody else has done, you can go and show that to people and people will come to your app just for that.
(00:14:22):
And even if your app doesn't have a lot of the obvious stuff, maybe it doesn't have justify alignment, people will jump over that just to use these new tools and new abilities that you might be building and marketing. So we try to do every engineer one marketable feature per week, and a lot of that stuff may not work, but a lot of it does work and we can figure out obviously, where to put in more effort, things that start to work, we double down on those things, build more. People often complain because think about it, in one week where we're shipping, it's not complete, it's MVP, truly.
(00:14:57):
And we slice the hell out of it. We take the design and we cut, cut, cut until we can really say that it's going to be useless if we cut anymore. We get that out and people come in. And if things are going well, people will use it despite all the problems that it might have, and now people will complain and we'll have a list of problems and we know what to do next. That's a starting point essentially. As long as we're shipping one a week, we get a ton of volume of features and products and directions we're releasing, cut a lot of that. What remains expand from there. So it works really well, and it keeps people focused.

**中文翻译:**
坦白说，这在某种程度上全在于增量（incrementality）。我们的目标是每周发布。我们的工程目标是：每位工程师每周都应该发布一个具备市场推广价值的产品。所谓“具备市场推广价值的产品”，是指你可以向用户展示，用户可能会仅仅为了这个功能而订阅或付费，或者本质上就是为了这个功能才来到你的应用。这就是为什么那些“入场券”式的功能（table stakes features）——比如文字处理器里的自动格式化或对齐方式——没人会为了对齐功能来用你的文字处理器。你可以宣传它，因为它理应存在，但如果你做了一些别人都没做过的独特功能，你展示给人们看，他们就会为此而来。
(00:14:22):
即使你的应用缺少很多显而易见的功能，比如没有对齐功能，人们也会忽略这一点，只为了使用你正在构建和营销的这些新工具和新能力。所以我们尝试让每位工程师每周做一个可营销的功能。其中很多可能行不通，但很多确实行得通。我们可以弄清楚在哪里投入更多精力，对开始奏效的东西加倍投入，构建更多。人们经常抱怨，因为想想看，一周内发布的东西肯定不完整，那是真正的 MVP（最小可行性产品）。
(00:14:57):
我们会疯狂地精简它。我们拿到设计，然后砍、砍、砍，直到我们能说“如果再砍就没用了”为止。我们把它发布出去，用户进来了。如果情况良好，尽管有很多问题，人们还是会用它。然后人们会抱怨，我们就有了一份问题清单，也就知道了下一步该做什么。这本质上是一个起点。只要我们每周发布一个，我们就会有大量的发布量、产品和方向。砍掉大部分，剩下的继续扩展。这效果非常好，而且能让大家保持专注。

---

### [00:15:37] Lenny Rachitsky

**English:**
I love the simplicity of that. I love just how wild that sounds for a lot of companies I imagine. Every engineer ships a marketable feature or product every week.

**中文翻译:**
我喜欢这种简单直接。我能想象这在很多公司听起来有多疯狂。每位工程师每周发布一个可营销的功能或产品。

---

### [00:15:46] Gaurav Misra

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:15:48] Lenny Rachitsky

**English:**
There's some people listening to this and are just completely stressed out by this idea and there's some people listening who are like, this is exactly how I want to work. This is how every company should build.

**中文翻译:**
听这段话的人里，有些人可能会被这个想法搞得压力巨大，而另一些人则会觉得：“这正是我想要的工作方式。每家公司都应该这样构建产品。”

---

### [00:15:56] Gaurav Misra

**English:**
Yep.

**中文翻译:**
没错。

---

### [00:15:58] Lenny Rachitsky

**English:**
How do you maintain quality and make it all cohesive? I imagine that's the big trade-off. Just, any tricks there for folks that want to maybe start operating this way.

**中文翻译:**
你如何维持质量并确保整体的连贯性？我猜这是最大的权衡。对于那些想尝试这种运作方式的人，有什么诀窍吗？

---

### [00:16:06] Gaurav Misra

**English:**
Quality is not something you compromise on most of the time. I think yes, there's strategic compromises in quality, but most of the time what you want to do is have a bar for quality where people should come in and if they're using the feature, it should work, right? Of course. And the way to cut down on time, and I think this is a mistake people make a lot of the time, is when time is being pressured downward, a lot of times engineers, PMS, designers, they will cut on quality rather than cutting on scope. And actually you can cut on scope. It's actually, the method that we use is we look at every element that's going to take any time to build and we just say, what if we remove this? Is the product still useful?
(00:16:48):
And we keep repeating that until we remove whatever's left and we say it's going to be useless at this point. And that becomes the one-week project, right? It actually really works. It narrows down to the core of what you're really trying to ask. So for example, let's say we wanted to build something to add an image on your video or something like that, and this is a really basic idea. I just made it up right now. And you might imagine a design in which you import your image from your camera roll, but before it lands in your video you might want to remove the background. You might want to change the hue and saturation or something like that. And you might expect a designer to design all of those features and you let it design, but you really quickly realize that you can cut all of that stuff.
(00:17:38):
You can cut the background or you can cut the hue saturation. All you really need is pick. And then there might be a picker. We need a picker with a library, with a lot of different type. What if you want to pull from the cloud? What if you want to pull from the drive or something like that? Cut all of that, right? And essentially come down to the core, which is just native picker from the camera, lens, straight in the video, no UI. And that is already, that should be useful. If that's not useful, then anything else built on top of that is also useless. So that's how we might go about it.

**中文翻译:**
大多数时候，质量是不容妥协的。虽然会有战略性的质量妥协，但通常你需要设定一个质量门槛：如果用户使用这个功能，它必须能正常工作，对吧？当然。缩短时间的方法——我认为这是人们常犯的错误——当时间紧迫时，工程师、PM 和设计师往往会牺牲质量而不是削减范围（scope）。实际上，你应该削减范围。我们使用的方法是：审视每一个需要时间构建的元素，然后问：“如果我们去掉这个呢？产品还有用吗？”
(00:16:48):
我们不断重复这个过程，直到剩下的东西如果再去掉就彻底没用了。这就是那个“一周项目”。这非常有效，它能让你专注于你真正想验证的核心。例如，假设我们想做一个在视频上添加图片的功能。你可能会设想一个设计：从相册导入图片，但在放入视频前，你可能想去背景、调整色调或饱和度。你可能让设计师设计所有这些功能，但你很快会意识到这些都可以砍掉。
(00:17:38):
你可以砍掉去背景，砍掉色调饱和度。你真正需要的只是“选取”。然后可能还需要一个带库的选取器。如果要从云端或网盘选取呢？全部砍掉。最终回到核心：直接调用系统原生的相册选取器，直接放入视频，没有额外 UI。这本身就应该是有用的。如果这都没用，那么在上面构建的任何其他东西也都是没用的。这就是我们的做法。

---

### [00:18:12] Lenny Rachitsky

**English:**
That last sentence is so key to this. It's the core idea of ship small iterative features before you invest a lot in something to figure out is there anything there, is this worth spending weeks on?

**中文翻译:**
最后那句话太关键了。这就是核心理念：在投入大量精力之前，先发布小的迭代功能，看看这个方向是否可行，是否值得花几周时间去做。

---

### [00:18:24] Gaurav Misra

**English:**
Totally. And I think the coolest part of this method is the first thing that the users will come in, they'll use the thing, they'll import images and the first thing they'll complain about is what bothers them the most? Is it human saturation? Is it background removal? Is it picking from the cloud? You'll just get the most complaints about that thing.
(00:18:43):
People will be like, and people will be honest about it or they'll be like, "This sucks. It doesn't even have background removal. What kind of image thing is this?" And you have to take that feedback and just next week you can ship in a single week all the things that the user's complaining about.

**中文翻译:**
完全正确。我认为这种方法最酷的地方在于，用户进来使用功能后，他们首先抱怨的一定是让他们最困扰的地方。是色调饱和度？是去背景？还是云端选取？你会收到关于那个点最多的投诉。
(00:18:43):
人们会很诚实，他们会说：“这太烂了，连去背景都没有，这算哪门子图片功能？”你接受这些反馈，然后在下周，你就可以用一周时间发布用户抱怨的所有功能。

---

### [00:18:59] Lenny Rachitsky

**English:**
And then they're like, wow, this team is shipping like crazy.

**中文翻译:**
然后他们就会觉得：“哇，这个团队发布新功能的速度简直疯狂。”

---

### [00:18:59] Gaurav Misra

**English:**
Yes. Exactly.

**中文翻译:**
是的，没错。

---

### [00:19:01] Lenny Rachitsky

**English:**
Solve all my problems. So responsive. This connects a common sign of product market fit, which is when people are complaining about the thing that means they actually care enough to complain and that's a really good sign if they're complaining about something.

**中文翻译:**
“解决了我的所有问题，响应太快了。”这联系到了产品市场匹配（PMF）的一个常见迹象：当人们抱怨某个东西时，意味着他们足够在乎才会去抱怨。如果他们在抱怨，那其实是个好兆头。

---

### [00:19:13] Gaurav Misra

**English:**
It's very true, very true. If nobody complains, it's almost red flag.

**中文翻译:**
非常正确。如果没有人抱怨，那反而是个危险信号。

---

### [00:19:18] Lenny Rachitsky

**English:**
A lot of this is turning into an archeology of a modern product team and startup. So I want to keep digging. This is not where I was planning to go, but this is awesome. I love that this approach of every engineer shipping something every week that's marketable connects directly to where I started this conversation, which is how do you stay above the noise?
(00:19:36):
And part of the answer is just ship stuff constantly, and just continue to impress people. Like, "Here's a new amazing video feature." "Look at this thing."

**中文翻译:**
这番对话快变成对现代产品团队和初创公司的“考古”了。我想继续深挖。这虽然不是我原本计划的方向，但太棒了。我喜欢这种“每位工程师每周发布可营销功能”的方法，它直接回应了我开始时的提问：如何从噪音中脱颖而出？
(00:19:36):
答案的一部分就是：不断发布东西，持续给人们留下深刻印象。比如：“看，这是一个惊人的新视频功能。”“看看这个。”

---

### [00:19:43] Gaurav Misra

**English:**
Exactly. Yep. I think it's definitely key, right? And there's enough area and enough scope for that to happen. I think truly in normal times it may not be possible to create that much roadmap that quickly, but I think because there's so much innovation underlying all this, there is that scope available. The roadmap almost seems unlimited, just truly.

**中文翻译:**
没错。我认为这绝对是关键。而且现在有足够的领域和范围让这种事发生。在平常时期，可能无法这么快地制定出这么多路线图，但因为现在底层有这么多创新，这种空间是存在的。路线图看起来几乎是无限的，真的。

---

### [00:20:07] Lenny Rachitsky

**English:**
Okay. The other question I imagine people would be wondering is how do you work on longer-term projects that take many weeks? There's also infrastructure, I guess, back-end stuff. So maybe answer those questions.
(00:20:17):
How do you think about long-term stuff and then how do you deal with back-end stuff that isn't a feature that anyone would care for?

**中文翻译:**
好。我想人们还会好奇：你们如何处理那些需要好几周的长线项目？还有基础设施、后端之类的东西。你能回答一下吗？
(00:20:17):
你如何考虑长线事务，以及如何处理那些用户可能并不在意的后端工作？

---

### [00:20:22] Gaurav Misra

**English:**
Yep. Usually, we'll dedicate time to that separately. For example, usually Q4 for us is infrastructure quarter. We just go and build all the infrastructure. Q4 is generally, we've already delivered a ton of products and stuff. We're feeling pretty good about the rest of the year. Things are winding down. Obviously, holidays and stuff coming up. And so we spend all that time paying the technical debt.
(00:20:48):
I actually think there's a unique thing to think here about technical debt in general. And as a startup, your job is to take on technical debt because that is how you operate faster than a bigger company. Bigger companies don't take on technical debt, they pay it usually right away. Or they're paying back technical debt from the days when they were a startup, and they took on a lot of it. I mean Snaps, I used to work at Snap and there was a lot of examples of that over there, and I'm sure it happens at every other company.
(00:21:19):
And we think about it as like, well, is this a problem we need to solve today or is this a problem that the 50th engineer or the hundredth engineer or the 500th engineer can solve? And if it is a problem that a future engineer can solve, we should use that future engineer now. Essentially, that's what we're doing. And we're saying we're going to push this to somebody in the future. And by the way, if the company fails, that engineer will never be hired and all this won't matter anyways. So it's like financial debt in many ways. Financial debt is taken on to create leverage. It can be a good thing like if you're buying a house, you take on debt and you can buy something probably more than you can afford without taking on debt.
(00:22:04):
And it's the same thing. You can create products that you wouldn't be able to build with a small team that you have by taking on strategic technical debt. It's very positive actually.

**中文翻译:**
是的。通常我们会专门分配时间。例如，第四季度通常是我们的“基础设施季”。我们就去构建所有的基础设施。第四季度通常我们已经交付了大量产品，对全年的表现感觉不错。事情开始收尾，假期也快到了。所以我们花那段时间来偿还技术债。
(00:20:48):
关于技术债，我有一个独特的看法。作为一家初创公司，你的职责就是承担技术债，因为这是你比大公司跑得快的办法。大公司不承担技术债，他们通常立即偿还；或者他们正在偿还初创时期的巨额技术债。我以前在 Snap 工作，那里有很多这样的例子，我相信其他公司也一样。
(00:21:19):
我们的思考方式是：这是一个我们今天必须解决的问题，还是一个第 50 名、第 100 名或第 500 名工程师可以解决的问题？如果是一个未来的工程师可以解决的问题，我们现在就应该“借用”那个未来的工程师。本质上，我们是在把问题推给未来的某个人。顺便说一句，如果公司倒闭了，那个工程师根本不会被录用，这些也就不重要了。所以这很像财务债务。财务债务是为了创造杠杆。它可以是好事，比如买房时贷款，你可以买到比不贷款时更好的房子。
(00:22:04):
技术债也一样。通过承担战略性的技术债，你可以用现有的小团队创造出原本无法构建的产品。这实际上是非常积极的。

---

### [00:22:13] Lenny Rachitsky

**English:**
Wow, this is such a cool idea. And where my mind goes is that future engineer may be an AI agent engineer.

**中文翻译:**
哇，这个想法太酷了。我想到的是，那个未来的工程师可能是一个 AI 智能体工程师。

---

### [00:22:19] Gaurav Misra

**English:**
Exactly, yeah.

**中文翻译:**
没错，是的。

---

### [00:22:21] Lenny Rachitsky

**English:**
Just solving problems, just on technical debt in you.

**中文翻译:**
专门帮你解决技术债问题。

---

### [00:22:24] Gaurav Misra

**English:**
Exactly. Some engineer in the future Five-hundred engineer many years from now will get a promotion because they solve this big problem that those really bad early engineers created.

**中文翻译:**
没错。多年后的第 500 名工程师会因为解决了“那些糟糕的早期工程师”留下的重大问题而获得晋升。

---

### [00:22:36] Lenny Rachitsky

**English:**
So obviously, there's a line to this. There's only so much debt you can take on before you become a big problem.
(00:22:43):
Is there any thoughts on just that balance of just how much is too much and how if it's enough for a net feature engineer or just-

**中文翻译:**
显然，这有一条底线。在变成大麻烦之前，你只能承担有限的债务。
(00:22:43):
关于这种平衡，你有什么想法吗？多少算太多？如何判断这是否足以留给未来的工程师？

---

### [00:22:50] Gaurav Misra

**English:**
Yeah, I mean I think generally the rule of thumb is every piece of debt that you take on you have to pay interest on. So if there is debt that you've taken on, there's 1% or 2% of your time that is going to be taken away every day in maintaining bugs and issues and restarts and crashes and things that are happening with that. Because you did it the fast way, something's going to go wrong with it. Every day. 1% of your time will be taken away. If you take on enough debt, you'll be paying 80 or 90% interest and you'll not have any time to do anything new. You'll just be paying interest. That's all.
(00:23:23):
And that's when you get into the mode of like, oh, we're just keeping the lights on. We don't have any engineers to do anything. We're just keeping the lights on. That's the failure case for a startup. So in a way, you have a technical debt runway. Once you run out, once you've taken on too much debt. And if you haven't delivered value in that time, enough value to hire the engineers to pay the interest or just pay off the debt, you'll get in trouble.

**中文翻译:**
是的，我认为通用的经验法则是：你承担的每一笔债都要付利息。如果你欠了债，每天会有 1% 或 2% 的时间被消耗在维护 bug、处理问题、重启、崩溃等事情上。因为你选了快路，总会出点问题。每天 1% 的时间就没了。如果你欠债太多，你可能要付 80% 或 90% 的利息，你就没时间做任何新东西了。你整天都在付利息。
(00:23:23):
那时你就进入了“维持现状”模式。没有工程师能做新事，只是在维持运转。这是初创公司的失败案例。所以某种程度上，你有一个“技术债跑道”。一旦你欠债过多，跑道就到头了。如果你在那段时间内没有创造足够的价值来雇佣工程师偿还利息或清偿债务，你就会陷入麻烦。

---

### [00:23:46] Lenny Rachitsky

**English:**
I love that. That's such a nice heuristic of how to think about when to invest in something. I don't want to go down this too far, but just a thought I have is ... because sometimes there's big technical decisions you got to make that impact the way everything builds or is built in the future. I imagine those you spend more time on and take really seriously.

**中文翻译:**
我喜欢这个比喻。这是一个非常好的启发式方法，用来思考何时投资。我不想在这个话题上扯太远，但我想到的是……因为有时你必须做出重大的技术决策，这会影响未来所有的构建方式。我猜你会花更多时间在这些决策上，并非常认真地对待它们。

---

### [00:24:02] Gaurav Misra

**English:**
Definitely. Yeah, I mean I think as long as it's possible for wherever it's like a two-way door, you can do whatever you want. I mean this is a classic methodology. If it's A one-way door, it's worth thinking about and sort of doing correctly at least as much as the one-way door would matter to you in the future.

**中文翻译:**
肯定。只要是那种“双向门”（two-way door，指可逆的决策），你可以随心所欲。这是经典的决策方法论。如果是“单向门”（不可逆决策），那就值得深思熟虑，并尽可能正确地执行，因为这在未来会产生重大影响。

---

### [00:24:22] Lenny Rachitsky

**English:**
How much do your engineers use Cursor and tools like that to build? How much is AI helping your team move?

**中文翻译:**
你们的工程师在多大程度上使用 Cursor 之类的工具来构建？AI 在多大程度上帮助你们团队推进工作？

---

### [00:24:28] Gaurav Misra

**English:**
A hundred percent, yeah. I mean everybody's using it. It's super helpful. I mean even I'm using it honestly. Yeah, it's a huge multiplier for the team, no doubt.

**中文翻译:**
百分之百。每个人都在用。超级好用。坦白说，连我也在用。毫无疑问，它是团队巨大的效率倍增器。

---

### [00:24:40] Lenny Rachitsky

**English:**
And is a Cursor specifically. Is there anything else that you guys found useful?

**中文翻译:**
具体是 Cursor 吗？还有其他你们觉得好用的工具吗？

---

### [00:24:43] Gaurav Misra

**English:**
Yeah, we are using Cursor. Yep. We've tried all the different tools. We were using Devin as well, which is another, you know? That's more advanced, I guess. It's solving bugs for you.

**中文翻译:**
是的，我们在用 Cursor。我们尝试过各种工具。我们也用过 Devin，那是更高级的东西，它能帮你解决 bug。

---

### [00:24:52] Lenny Rachitsky

**English:**
Yeah, Devin's basically, I think it's 500 bucks a month and it's like an AI engineer that you just chat within Slack.

**中文翻译:**
是的，Devin 基本上是每月 500 美元，就像一个你可以在 Slack 里直接对话的 AI 工程师。

---

### [00:24:58] Gaurav Misra

**English:**
Exactly, yeah. In a way, these are the types of things that us as a startup can do that bigger companies can't just, you know, they can't just pull in Devin. They have to get 30 lawyers in the room first before that happens.

**中文翻译:**
没错。在某种程度上，这就是我们作为初创公司能做而大公司做不到的事。他们不能直接引入 Devin，他们得先让 30 个律师开会讨论。

---

### [00:25:11] Lenny Rachitsky

**English:**
And they're all called Devin, these are like agents. Everyone's going to have hundreds of Devins working at their company.

**中文翻译:**
而且他们都叫 Devin，这些就像智能体。以后每个人的公司里都会有几百个 Devin 在工作。

---

### [00:25:15] Gaurav Misra

**English:**
Exactly. You can have multiple Devins. I actually heard you can have a manager of Devins who's managing Devins.

**中文翻译:**
没错。你可以有多个 Devin。我甚至听说你可以有一个“Devin 经理”来管理这些 Devin。

---

### [00:25:21] Lenny Rachitsky

**English:**
I love that managers are all getting layered, like unlayered and then they're going to have AI managers. That's the ultimate bait and switch.

**中文翻译:**
我喜欢这个点，管理层正在被精简，然后他们会有 AI 经理。这真是终极的“偷梁换柱”。

---

### [00:25:30] Gaurav Misra

**English:**
Yep.

**中文翻译:**
是的。

---

### [00:25:32] Lenny Rachitsky

**English:**
Okay. Is there anything else that in how you operate and build the way you build product or set up the way you build product that you think is really unique and interesting that other people might be able to learn from?

**中文翻译:**
好。在你们的运作方式、构建产品的方式或组织架构中，还有什么你认为非常独特且有趣、值得他人学习的地方吗？

---

### [00:25:42] Gaurav Misra

**English:**
Our process is a bit interesting in that way. We have a design team, we have a PM team. We're very early on those teams right now. And obviously, we have engineering. And we have all the different surface areas. So iOS, Android, web. There's backend team, machine learning team, research team. So generally, when we're developing products, we may start off with a PM first approach where we're finding some sort of overall issue that we want to take on some new area or pillar we want to take on and then creating sort of product specs from there.
(00:26:17):
But a lot of times we'll also start the opposite way. We'll first design something without even having any idea of what or why we're doing it, but we'll design a bunch of different things and then we'll sit down with the PMs and look at the designs and just go over one and the next and the next until we find interesting things and ideas that pop out of that.
(00:26:36):
And a lot of times that leads to us discovering things that we wouldn't have discovered if we were just too focused on the metrics and the numbers and things like that. So it's almost reversing the process a little bit and starting with design first, but it can often result in finding unique ideas basically. I also think that we have a unique setup in how we create our roadmap. So normally you have a single roadmap and we actually divide a roadmap into two different roadmaps. So we have what we think of as the public roadmap. This is basically what people have asked us for. So there's all these surface areas where we receive user feedback and we look at all that feedback and people will ask for features. They'll ask for, I want background removal, I want to undo and redo, I want to upload longer videos, whatever it is, a bunch of different features.
(00:27:26):
And we'll just make a list of that. And just like anything else, we'll prioritize it and we'll look at how many people it affects and what the possible markets are and just get it done basically one at a time.
(00:27:37):
But these are all features that every competitor knows about. These are public. If a user's asking us for it, they're asking everybody for it. And every team has essentially more or less the same list and everybody's prioritizing it. And yeah, sure you can win a little by extra nicely prioritizing it or winning a little in prioritization or execution or something, but it's not going to be a game changer in terms of winning against your competition. So we have a second roadmap which we think of as a secret roadmap. So this is a roadmap that nobody asked for anything on this like literally, nobody has ever asked for it.
(00:28:13):
And if a user were shown something on it, they might be like, "I don't need this. I don't know what this is." But given our unique vantage point, our unique understanding of the problem set, the user space and the technology, we've come up with some special ideas that we think will completely revolutionize how something is used where we can truly change the behavior of the user. I think that's what at is at the core of. It's like people are doing things one way if we're able to show them another way. And once they try it, they never go back. That's what a product is, that's success. And those are the types of ideas that we put on the secret roadmap. These are things we never talk about publicly, never tell anybody about, and we announce them and just give them to users and see the effects.
(00:29:00):
A lot of this we come up with through brainstorming. So we do actually do quarterly brainstorming, company-wide, everybody's included like everybody from. It's not just a product team thing, it's like engineering, recruiting, everybody's included in. And we all come up with marketing, obviously, everybody comes up with ideas, we vote on the ideas, rank the ideas, and then the product team takes over from there and thinks about like feasibility and technology and what the different things could be. So this is a way where we can take all that noise that people are getting, everybody's browsing social media, seeing all these different things that are blowing up, these models and advancements and we can get all that information together and provide a unique internal roadmap where how are we going to approach and create value out of all of these different advances that are happening.
(00:29:49):
So that's our general methodology. And a lot of times the biggest wins will come from the secret roadmap. That's the game-changing stuff. It's not going to be the user requests usually that are going to do that.

**中文翻译:**
我们的流程在这方面挺有趣的。我们有设计团队、PM 团队（目前这些团队还处于早期阶段），当然还有工程团队。我们涵盖了所有不同的领域：iOS、Android、Web、后端、机器学习、研究团队。通常开发产品时，我们可能会先采用“PM 优先”的方法，即发现某个整体问题，确定我们要攻克的新领域或支柱，然后据此创建产品规格。
(00:26:17):
但很多时候我们也会反其道而行之。我们会先设计一些东西，甚至不知道为什么要这么做，只是设计一堆不同的东西，然后和 PM 坐下来看设计，一个接一个地过，直到发现其中蹦出的有趣点子。
(00:26:36):
很多时候，这能让我们发现那些如果只盯着指标和数字就无法发现的东西。这有点像把流程反过来，从设计开始，但这往往能找到独特的创意。此外，我们在制定路线图方面也有独特的设置。通常公司只有一个路线图，而我们将其分为两个。一个是“公开路线图”，基本上是用户要求我们做的东西。我们在各个渠道收集反馈，用户会要求去背景、撤销重做、上传更长视频等等。
(00:27:26):
我们会列出清单，像其他公司一样确定优先级，看受众规模和市场潜力，然后一个一个完成。
(00:27:37):
但这些功能每个竞争对手也都知道。它们是公开的。如果用户向我们提要求，他们也会向所有人提。每个团队的清单大同小异，大家都在排优先级。当然，你可以通过更好的优先级排序或执行力赢一点点，但在战胜竞争对手方面，这不会是游戏规则的改变者。所以我们有第二个路线图，即“秘密路线图”。这个路线图上的东西没有任何用户要求过，字面意义上的零要求。
(00:28:13):
如果展示给用户看，他们可能会说：“我不需要这个，我不知道这是啥。”但基于我们独特的视角、对问题集、用户空间和技术的独特理解，我们想出了一些特别的点子，我们认为这些点子将彻底改变某种东西的使用方式，从而真正改变用户的行为。我认为这就是核心：人们习惯一种方式，如果我们能展示另一种方式，一旦他们尝试了就再也回不去了。这就是产品，这就是成功。这些就是我们放在秘密路线图上的点子。我们从不公开讨论，不告诉任何人，直到发布并交给用户看效果。
(00:29:00):
这些点子很多来自头脑风暴。我们每季度进行全公司范围的头脑风暴，每个人都参加，不只是产品团队，还有工程、招聘、营销等等。每个人都出主意，我们投票、排名，然后产品团队接手，考虑可行性、技术等。通过这种方式，我们可以把大家在社交媒体上看到的各种噪音、爆发的新模型和进展整合起来，提供一个独特的内部路线图，决定我们如何从这些进展中创造价值。
(00:29:49):
这就是我们的通用方法论。很多时候，最大的胜利都来自秘密路线图。那是改变游戏规则的东西，通常不会是用户请求带来的。

---

### [00:30:02] Lenny Rachitsky

**English:**
I love just how calling it the secret roadmap makes it extra interesting.

**中文翻译:**
我喜欢“秘密路线图”这个叫法，让它听起来格外有趣。

---

### [00:30:06] Gaurav Misra

**English:**
Exactly, yeah. It's a secret.

**中文翻译:**
没错，这是个秘密。

---

### [00:30:09] Lenny Rachitsky

**English:**
It's a secret. I'm not even going to ask you what's on that secret roadmap. You can't tell me.
(00:30:15):
What's an example of feature that came out of that secret roadmap that's been a big deal for you guys?

**中文翻译:**
既然是秘密，我甚至不打算问你上面有什么，反正你也不会告诉我。
(00:30:15):
能不能举个例子，哪个出自秘密路线图的功能对你们来说意义重大？

---

### [00:30:18] Gaurav Misra

**English:**
Tons. I mean, I'll give you an example from a long time ago. One of the first AI features we added after the app initially took off was this feature called eye contact. So this was a feature where if you're recording something, oftentimes people who are new to recording a video might read from a script or a teleprompter or something like that and they might have that off-screen. So it looks like you're reading and it's not great from the perspective of the video itself or the viewer of the video. So we had this feature where it basically shifts your eyes to look at the camera.
(00:30:52):
And we were actually the first company to build this. We worked with Nvidia on this. It's actually really interesting because when we originally reached out to Nvidia about this. They were not sure why we needed this. And they actually gave it to us pretty openly and were excited about some sort of partnership of how can we get this technology into something that could be useful.
(00:31:19):
But we saw this creator use case which was unique, and it was one of the ideas that came out of the brainstorm and we threw it on there, we launched it. It was a huge success. I mean, I'll be honest, the video, the ad that we made, a social media post that demonstrates this was so viral, it was made in basically every language around the world. It still till today gets millions of views. We find reposts and reposts of that thing that other people have created that get millions and millions and millions of views because people are like, "Wow, this is a great idea."
(00:31:59):
And now it's been copied the hell out of, I think it's available basically on every app you can imagine. For good reason of course. But that's one of the ideas that came out of it.

**中文翻译:**
太多了。我给你举个很久以前的例子。在应用最初走红后，我们添加的首批 AI 功能之一叫做“眼神交流”（eye contact）。这个功能是这样的：当你录制视频时，新手往往会读脚本或提词器，视线会偏离镜头。从视频本身或观众的角度看，这显得你在读稿，效果不好。所以我们做了这个功能，它能自动调整你的眼神，让你看起来一直在盯着摄像头。
(00:30:52):
我们实际上是第一家做这个的公司。我们和 Nvidia 合作完成了这个功能。很有趣的是，当我们最初联系 Nvidia 时，他们不确定我们为什么需要这个。但他们还是很开放地提供了技术，并对这种能让技术变得有用的合作感到兴奋。
(00:31:19):
但我们看到了这个独特的创作者用例，这是头脑风暴中产生的一个想法。我们把它做出来并发布了。结果大获成功。坦白说，我们制作的演示视频和社交媒体帖子在全球范围内疯传，几乎被翻译成了每种语言。直到今天，它仍有数百万的播放量。我们发现别人转发的视频也有数千万的播放量，因为人们觉得：“哇，这主意太棒了。”
(00:31:59):
现在这个功能已经被抄烂了，几乎在你想象得到的每个应用里都有。当然，这是有原因的（因为它确实有用）。但这就是出自秘密路线图的想法之一。

---

### [00:32:10] Lenny Rachitsky

**English:**
You talked about how you come up with these secret roadmap ideas. I'm just intrigued by this. I'm going to spend a little more time here.
(00:32:14):
Does your team ever work with an AI LLM to help brainstorm? I imagine that's where things will go, where you're actually jamming. The AI agent is brainstorming along with you.

**中文翻译:**
你谈到了如何构思这些秘密路线图的点子。我对这很感兴趣，想多聊聊。
(00:32:14):
你们团队会使用 AI 大模型（LLM）来辅助头脑风暴吗？我猜未来会发展成那样，你和 AI 智能体一起即兴碰撞想法。

---

### [00:32:25] Gaurav Misra

**English:**
Honestly, I would like for it to go there. It hasn't gone there yet. We haven't done that exactly, because the problem is context. And I think just the context of understanding the user, the use case, it's so abstract. Even right now, I feel like I understand our users obviously, but I can't exactly verbalize why that is or how that is, a little bit abstract. And I spend a lot of time with RPMs and designers imparting anything that I understand and I've learned over the many years I've been working on this, how do I impart this to them? But then it's a challenge because I can't even verbalize it myself. And so it's an extra hard challenge to figure out how do I put this context? How do I make it available to an LLM when I can't even put it into words exactly. And honestly, this is probably my own feeling but, and I need to work on this, but there is something to it.
(00:33:26):
I do remember at Snap for example, I think one of the most unique things about Snap and the CEO Evan Spiegel was that he had an unmatched understanding of the user. I think years and years and years of the company's existence past, almost a decade. And nobody understood the user like he did. He would come up with ideas that everybody would disagree with and we would launch them and there would be hits, just hits after hits. And nobody would understand why. Everyone would line up and be like, "Great." Round of applause for everyone, but no one knew why.
(00:34:07):
A great example of that is a lot of this was figured out in retrospect too. I think there was a point at which Snap declared that they're a camera company and a lot of people laugh at them and said, "Camera. What are we making digital cameras or something?" Or, "Why is it a camera company?"
(00:34:22):
But I think at the core of it was this idea that Snapchat opens to the camera and that was actually the differentiator. That actually that small decision was holding the entire company against all competition because when the moment passes where your friend is doing something funny and you need to capture it, you're not going to open Instagram or anything else because it doesn't open to the camera. You're going to open Snapchat because you can capture it right away. And Instagram can never copy that because all their metrics are going to go down as soon as they do that. So that is a fundamental understanding. And I figured this out much later, actually, but it's such a powerful idea.

**中文翻译:**
坦白说，我也希望如此，但目前还没到那一步。我们还没真正那样做，因为问题在于“上下文”（context）。理解用户、理解用例的上下文是非常抽象的。即使是现在，我显然觉得自己了解用户，但我无法准确地用言语表达为什么或怎么了解的，这有点抽象。我花很多时间与 PM 和设计师交流，传授我多年来学到的东西，但挑战在于我自己都无法完全言传。所以，要把这种上下文提供给 LLM 就更难了，因为我甚至无法准确地将其转化为文字。这可能是我个人的感觉，我需要改进，但这其中确实有些门道。
(00:33:26):
我记得在 Snap 时，CEO Evan Spiegel 最独特的一点就是他对用户有着无与伦比的理解。公司成立快十年了，没人像他那样了解用户。他会提出一些大家都反对的想法，但发布后却一个接一个地大火。没人明白为什么。大家会排队鼓掌，但没人知道原因。
(00:34:07):
一个很好的例子是，很多事情都是事后才想通的。Snap 曾宣布自己是一家“相机公司”，很多人嘲笑他们：“相机？我们要造数码相机吗？”或者“为什么要叫相机公司？”
(00:34:22):
但我认为核心在于：Snapchat 一打开就是相机，这才是差异化所在。这个小小的决定让整个公司在竞争中立于不败之地。因为当你的朋友在做滑稽动作的瞬间，你不会去打开 Instagram 或其他应用，因为它们打开不是相机。你会打开 Snapchat，因为你可以立即捕捉那一刻。Instagram 永远无法抄袭这一点，因为一旦他们这么做，他们的所有指标都会下降。这是一种深刻的洞察。我其实也是很久以后才明白这一点的，但这是一个非常强大的想法。

---

### [00:35:08] Lenny Rachitsky

**English:**
I'm glad you talked about Snap. That's where I definitely wanted to go. This is where I was going to start. So I glad we circled back to your experience at Snap. So the reason I am interested in this is if you think about social networks like Snap is basically the last social network to have launched and stuck around other than TikTok, which I don't think is a social network. I think it's just this content platform. I don't think you're really interacting with people really. And that was 2011 when it launched. So it's been like 15 years since the last social network launch that has worked.
(00:35:40):
And I think it's interesting also because there's rarely been a lot of insight into just how Snap operates. You were there really early. You're a big deal at Snap. You built a lot of really important features. So I wanted to spend a little time here, and it feels like a lot of things you learn from Snap you're bringing to your company now. So let me just ask, I think you may have answered this, but I'm curious if there's something else here just broadly maybe other than Ev's brain, what do you think was core to Snap being a successful consumer social product?

**中文翻译:**
很高兴你提到了 Snap。这正是我非常想聊的话题。我本来打算从这里开始的。我之所以感兴趣，是因为如果你想想社交网络，Snap 基本上是除了 TikTok 之外，最后一个发布并存活下来的社交网络。而我不认为 TikTok 是社交网络，我觉得它只是个内容平台，你并不是真的在和人互动。Snap 是 2011 年发布的，也就是说，距离上一个成功的社交网络发布已经过去快 15 年了。
(00:35:40):
而且很有趣的是，外界很少能深入了解 Snap 的运作方式。你是早期员工，在 Snap 举足轻重，构建了许多重要功能。所以我想在这里多花点时间。感觉你从 Snap 学到的很多东西都带到了现在的公司。我想问，除了 Evan 的大脑，你认为 Snap 成为成功的消费级社交产品的核心要素还有什么？

---

### [00:36:12] Gaurav Misra

**English:**
There were a couple of different things that went well. I do think for a company like Snapchat or Social Network, the core product market fit can be extremely strong. Essentially, the reason that people are downloading it, the way that it's spreading, the way that it's inviting friends or sending Snaps or whatever it is, that product market fit can be so strong sometimes that it can be hard to actually build something because you actually can't tell if what you're building is what's responsible for growing the thing or if it's actually hurting it and it's growing despite what you're doing basically.
(00:36:53):
And I think because of that, it actually sometimes teaches people the wrong things. It teaches people that the contrarian thing that they were doing was right when it was actually just wrong and the company just grew despite it. And I think some of the things that Snap did well and it needed to do really was to continue innovating, right?
(00:37:17):
Because for a company like Snap, it has a ton of competition. Social networks are monopolies by nature and there's a lot of reasons for Facebook or any other social network to stop the growth of Snapchat. And they tried, they tried really, really hard. And the way that Snap was avoiding that was by innovating. I think the core of it was the setup that they had, which was very unique. I've never seen anything like it. I've worked at a bunch of different companies, but obviously there's a CEO and the CEO was very product-led, his designer himself, but he surrounded himself with the design team. That was sort of the central team in the company. And the design team was like 10, 12 people. Basically, pretty small, even at 5, 6,000 employees it was that small still.

**中文翻译:**
有几件事做得很好。我认为对于像 Snapchat 这样的公司或社交网络来说，核心的产品市场匹配（PMF）可能极其强大。本质上，人们下载它的原因、它传播的方式、邀请好友或发送 Snap 的方式，这种 PMF 有时强到让你很难真正去构建新东西，因为你无法判断增长是因为你做对了什么，还是因为它在尽管你做错了的情况下依然在增长。
(00:36:53):
我认为正因如此，它有时会教给人们错误的经验。它让人们以为自己做的那些反直觉的事情是对的，而实际上可能是错的，公司只是在“带病增长”。我认为 Snap 做得好的一点是它必须持续创新。
(00:37:17):
因为像 Snap 这样的公司面临巨大的竞争。社交网络本质上是垄断性的，Facebook 或其他社交网络有无数理由去阻止 Snapchat 的增长。他们确实尝试了，而且非常努力。Snap 避开这些竞争的方法就是创新。我认为核心在于他们的组织架构，非常独特。我从未见过类似的。我曾在很多公司工作过，但 Snap 的 CEO 是非常产品导向的，他本身就是设计师，他让自己被设计团队包围。那是公司的核心团队。即便公司有五六千名员工时，设计团队也只有 10 到 12 人，非常精简。

---

### [00:38:02] Lenny Rachitsky

**English:**
Oh wow. At 6 or 6,000 employees. The design team was, you said how many, five or six people?

**中文翻译:**
哇，在 6000 名员工规模时，设计团队你说是多少人？五六个？

---

### [00:38:07] Gaurav Misra

**English:**
10, 12 people.

**中文翻译:**
10 到 12 人。

---

### [00:38:08] Lenny Rachitsky

**English:**
10, 12. And to add to that, there's no PMs really for a long time. That was before.

**中文翻译:**
10 到 12 人。而且补充一点，很长一段时间里其实没有 PM（产品经理）。

---

### [00:38:12] Gaurav Misra

**English:**
For a long time, yeah.

**中文翻译:**
是的，很长一段时间都没有。

---

### [00:38:14] Lenny Rachitsky

**English:**
Big difference.

**中文翻译:**
这区别太大了。

---

### [00:38:14] Gaurav Misra

**English:**
Initially, there were no PMs at all. PMs were introduced with monetization. Once monetization was a big sort of element, that's where PMs came in. Today, I think there's a ton of, or there's an adequate number of PMs across the company, but there was a long period of time, especially when the innovation was happening, when there were a much, much smaller number of PMs and it was very designer led. But at the same time, I think that's slightly misleading in the way that these weren't your sort of average designers.
(00:38:43):
These were designers who were actually PMs as well. That's what the secret sauce was. They were able to not just design but also do the PM part which is a big responsibility. It's a lot of work, especially for that many employees, but it gave the CEO a way to have granular control over what exactly was being launched in which part of the app at all times.
(00:39:05):
Because he could meet with a set of 10 or 12 people and know every change that was happening that was user impacting. A lot of changes were being worked on that were infrastructure and types of things that keep going on in the back end where you're improving ranking and whatever that might be, performance and things like that. And those were not usually his concern. He was concerned with what UI are we adding where? And if you needed to add UI to the app, you needed it designed. And if there's no designers in the company, except for a handful who talk directly to the CEO, you create a very granular control over what's being launched in the company. So everything needed to be approved by Evan. If you hadn't approved it, it's not going out. So the design team actually held a lot of power in that.

**中文翻译:**
最初完全没有 PM。PM 是随着商业化（变现）引入的。一旦商业化成为重要元素，PM 就进场了。今天公司里肯定有足够数量的 PM，但在创新的鼎盛时期，PM 数量极少，完全由设计师主导。但同时，我觉得这有点误导性，因为这些设计师不是普通的设计师。
(00:38:43):
这些设计师实际上也兼任 PM。这就是秘诀所在。他们不仅能设计，还能承担 PM 的职责，这是一份巨大的责任。对于那么多员工的公司来说，这工作量极大，但它让 CEO 能够随时对应用各部分发布的内容进行颗粒度极细的控制。
(00:39:05):
因为他只需要和这 10 到 12 个人开会，就能知道每一个影响用户的改动。后端有很多基础设施、排名优化、性能提升等工作在进行，那些通常不是他关心的。他关心的是：我们在哪里添加了什么 UI？如果你要在应用里加 UI，你就需要设计。如果公司里除了那几个直接向 CEO 汇报的人之外没有其他设计师，你就实现了一种对公司发布内容的极细控制。所以每件事都需要 Evan 批准，不批准就发不出去。设计团队因此掌握了很大的权力。

---

### [00:39:50] Lenny Rachitsky

**English:**
This is awesome. So what I'm hearing partly is, I don't know if this is true, but it feels true that to make a consumer app that is successful and breaks through, you almost need a singular mind that continues to stay in the weeds on everything. And the way Evan did that is very close to the design team who basically ran product.

**中文翻译:**
太棒了。我听到的部分信息是——我不知道这是否正确，但听起来很合理——要做出一个成功的、有突破性的消费级应用，你几乎需要一个能持续深入细节的单一头脑。Evan 做到这一点的方法就是紧贴设计团队，而设计团队基本上管理着产品。

---

### [00:40:10] Gaurav Misra

**English:**
That's very true. Yeah, it's very true. And he was able to keep the context of the entire app in his head at the same time. He knew the interdependencies and what we're doing and why we're doing it. And so that gave him just very granular control over the company's product roadmap.

**中文翻译:**
非常正确。他能同时在脑子里保留整个应用的上下文。他知道各项功能间的相互依赖关系，知道我们在做什么以及为什么要这么做。这让他对公司的产品路线图拥有了极细的控制力。

---

### [00:40:26] Lenny Rachitsky

**English:**
It makes me think about Brian Chesky and Airbnb is a consumer product, it's not a social network, but I wonder if that's just an interesting insight just for consumer products. They will generally do better if there's one person with a really ... the right sort of combination of experiences, insights, and just they continue to run and own every detail.

**中文翻译:**
这让我想到了 Brian Chesky 和 Airbnb。Airbnb 是消费级产品，虽然不是社交网络，但我好奇这是否是消费级产品的一个有趣洞察：如果有一个具备正确经验、洞察力组合的人，持续管理并掌控每一个细节，产品通常会表现得更好。

---

### [00:40:46] Gaurav Misra

**English:**
Definitely. And also the ability to bring about change, the ability to truly energize an entire organization to do something that's not just incremental but fundamental.
(00:40:58):
<< Founder mode >>

**中文翻译:**
肯定。还有带来变革的能力，真正激励整个组织去做一些不仅是增量式、而是根本性改变的事情的能力。
(00:40:58):
这就是“创始人模式”（Founder Mode）。

---

### [00:41:00] Lenny Rachitsky

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:41:01] Gaurav Misra

**English:**
Founder mode. That's what we're getting to, basically.

**中文翻译:**
创始人模式。我们基本上就是在讨论这个。

---

### [00:41:04] Lenny Rachitsky

**English:**
Yeah, ever heard of it. Okay. And then you said that these designers, so I know it's famous that Snap had no PMs for a long time. Designers were PMs. This point you made about the designers where PME is really important. I think a lot of people look at this, they're like, "Amazing. We're just going to hire just designers. We don't need all these PMs. Slow everything down. Just tell us what not to build." Can you just talk about the level of these designers? What allowed them to be as successful as they were without any PMs?

**中文翻译:**
是的，听说过。好，你提到这些设计师——我知道 Snap 长期没有 PM 是很出名的，设计师就是 PM。你提到的“设计师兼任 PM”这一点非常重要。我想很多人看到这会想：“太棒了，我们也只招设计师，不需要 PM，PM 只会拖慢速度。只要告诉我们不该建什么就行。”你能聊聊这些设计师的水平吗？是什么让他们在没有 PM 的情况下如此成功？

---

### [00:41:32] Gaurav Misra

**English:**
Yeah, I mean I think what was expected from the designers now was not just the ability to design, the skill set of designing, which all of them were IC designers by the way. And there were no reports, so they weren't allowed to have reports actually. And so they were designing everything themselves, but they also had to have the leadership skills to go figure out the roadmap, write all the documents, work with the different teams, figure out shipping schedules and just know everything, not just the technical and the engineering part, but the UX and the UI and the product needs and why are we doing this.
(00:42:15):
The roadmap, there's just a ton to keep in mind. And that means that it was a job that was just highly ... it was very high workload. No doubt, very high workload. These people work really hard and they were paid highly too. For what it's worth, they were paid way higher than you would expect designers or PMs or engineers to be paid with quarterly bonuses and all kinds of things.

**中文翻译:**
是的。当时对这些设计师的期望不仅是设计能力。顺便说一下，他们全都是 IC（独立贡献者）设计师，没有下属，公司也不允许他们带人。所以他们必须亲自动手设计一切，但同时他们还必须具备领导力，去制定路线图、撰写所有文档、与不同团队协作、确定发布时间表，并且要了解一切——不仅是技术和工程部分，还有 UX、UI、产品需求以及“我们为什么要这么做”。
(00:42:15):
路线图上有太多的东西需要记在脑子里。这意味着这份工作的负荷极高。毫无疑问，工作量巨大。这些人工作非常努力，薪水也极高。说实话，他们的薪水远高于你对普通设计师、PM 或工程师的预期，还有季度奖金等各种福利。

---

### [00:43:03] Lenny Rachitsky

**English:**
That's interesting. And it reminds, people always say, "Why do you need PMs?" There's like someone has to do the work that a PM does. They're not sitting around doing nothing. And it's important to note the person that will take on the PME work, they have to be good at it and enjoy it. And a lot of designers don't want to be doing writing docs and organizing stakeholders and getting alignment and ...

**中文翻译:**
这很有趣。这让我想起人们常问：“为什么需要 PM？”其实总得有人去做 PM 的工作，PM 又不是整天坐着无所事事。重要的是，承担 PM 工作的人必须擅长并享受其中。而很多设计师并不想写文档、协调利益相关者、达成共识等等。

---

### [00:43:03] Gaurav Misra

**English:**
100%, 100%. That's why it's so hard to find those people who were able to do two things. I actually think there's an insight in there is innovation between when you're merging craft right between two different functions. And I do think there's something special about one person doing two different functions or at least being able to do. And I think a lot of unique insight and innovation can come from that.
(00:43:31):
I actually think on my personal side, I eventually joined the design team. I started at Snap on the engineering team. I eventually joined the design team over the last two years that I was at Snap. And a big part of what I did there was create this function called design engineering. And that was actually a different combination. It wasn't the designer PM. It was the designer engineer. The person who can think of the UX design it and also build it and launch it, all of those things.
(00:44:03):
And we saw both the ability to take designers and teach them engineering and take engineers and teach them design as part of that. Obviously, the reason that we created that function was very different. It was actually to continue innovating as the company got bigger. One of the problems that we identified was that as the company got bigger and bigger and there's like 500 engineers, 1,000 engineers, 2,000 engineers, 3,000, suddenly it just becomes very difficult to do everything.
(00:44:32):
Everything is a six-month project or a one-year project. Every product is a massive investment of 500 engineers and a lot of time. And so you really have to pick your bets. If you get it wrong, if you are innovating and trying to create new products and you spend 500 engineers for a year and it doesn't work, it's a big problem. You're going to be in trouble, especially if we're coming like Snap where everybody was copying what they're doing so they had to constantly innovate, create new stuff and push the bounds.
(00:44:59):
I think Evan's philosophy was always he didn't fight the things that were getting copied, right? Stories got copied pretty much straight up. A lot of things that Snap created got copied, but he was more of the mindset of like, "Let's expand the pie, do something new and push the boundaries." We'll keep innovating basically. And so to do that with that scale of a company becomes really hard. And so we had this idea of let's create a small team where we can go and pretest a lot of these ideas because we had a lot of ideas and we can't go and build all of these things. So the idea was create a small team of these design engineers, people who are able to do the entire product design engineering process in their head and can put together early versions of the product, which we would actually bake into the Snapchat app itself.
(00:45:46):
And we were able to even test, for example, run a test in Australia, see how it's performing. Run a test in a couple of high schools, just a couple of high schools, see how people behave. And that way we already have data on how this might perform in a real world environment, but we haven't built it to production level. It's a prototype, essentially. It's how a startup might build something.
(00:46:08):
The same idea of what we're doing at our company now, build fast, get it out there, get feedback, understand whether it works or not, and then work with the engineering team to build it at a scale. Once we understand the product and the dynamics, then it makes sense to put on 500 engineers for six months to build it.
(00:46:25):
So that was a big part of it. I think the nice thing that came out of it that was completely unexpected but actually transformational for me in a way was obviously in big organizations, alignment is a big issue. How do you get everybody on the same page? And a big part of a PM's job is actually to create alignment and it can be a lot of work because you go talk to all these stakeholders and get them on the same page.
(00:46:48):
But one of the insights that we had, which was unique was as the company gets bigger, you can actually create alignment by causing internal virality. If there's enough people in the company, it actually starts acting like a consumer base might. If you share something interesting with someone, they will share it with somebody else because they think it's interesting and you can actually create virality inside a company.
(00:47:16):
So one thing that we would do is we would create these prototype products. We would just go into an area, redo a bunch of stuff, create these prototype products that didn't exist in Snapchat normally, and then we would just share the build and it would explode. It would just go viral inside the company. Day after day we would hear from engineers, then managers, then VPs, then eventually from Evan being like, "Oh my God, everyone's talking about this. Why am I the last one to hear about it?"
(00:47:47):
So it would create instant alignment across the company of this is exciting, this is something that we want to get behind. And everyone would be asking, "When are we doing this? When is this happening? I see someone's already working on it." So it was a great way to do that. And once we really understood that the product actually had good dynamics and we had tested it, it was a great way to get it out in front of everybody and create this idea of, "Hey, we're all working on this. This is the future."

**中文翻译:**
百分之百正确。这就是为什么很难找到能同时做这两件事的人。我其实认为，当你把两种不同职能的“手艺”融合在一起时，创新就会发生。一个人承担两种职能，或者至少有能力做到，这其中确实有特殊之处。很多独特的洞察和创新都源于此。
(00:43:31):
就我个人而言，我最初在 Snap 的工程团队，最后两年加入了设计团队。我在那里做的一件大事就是创建了一个叫“设计工程”（design engineering）的职能。那是另一种组合：不是设计师兼 PM，而是设计师兼工程师。这个人既能构思 UX 设计，又能亲手构建并发布它。
(00:44:03):
我们尝试让设计师学习工程，也让工程师学习设计。我们创建这个职能的原因是为了在公司变大时保持创新。我们发现，当公司规模达到 500、1000 甚至 3000 名工程师时，做任何事都变得极其困难。
(00:44:32):
每个项目都要半年或一年。每个产品都需要投入 500 名工程师和大量时间。所以你必须谨慎下注。如果你押错了，投入 500 人做了一年却没效果，那是大麻烦。尤其是在 Snap 这种大家都在抄袭你的环境下，你必须不断创新、突破边界。
(00:44:59):
Evan 的哲学一直是：他不纠结于被抄袭的东西。Stories 被抄了，很多功能都被抄了，但他的心态是：“让我们把饼做大，做点新东西，突破边界。”我们基本上就是持续创新。但在大公司规模下做到这一点很难。所以我们想：建立一个小团队，去预测试这些想法。我们有很多点子，但不能全部正式构建。于是我们建立了一个由“设计工程师”组成的小团队，他们能在脑子里完成整个产品设计工程流程，做出产品的早期版本，并直接植入到 Snapchat 应用中。
(00:45:46):
我们甚至可以进行测试，比如在澳大利亚跑个测试看表现，或者在几所高中测试看用户行为。这样我们就有了真实环境下的数据，而不需要把它做到生产级别。这本质上是原型（prototype），是初创公司的做法。
(00:46:08):
这和我们现在公司做的如出一辙：快速构建，发布出去，获取反馈，了解它是否奏效，然后再与工程团队合作大规模构建。一旦我们理解了产品和动态，再投入 500 名工程师花半年时间去构建它才有意义。
(00:46:25):
这是很大一部分原因。还有一个意想不到但对我影响深远的收获是：在大组织中，“对齐”（alignment）是个大问题。如何让所有人达成共识？PM 的很大一部分工作就是达成共识，这很累，因为你要和所有利益相关者沟通。
(00:46:48):
但我们发现了一个独特的洞察：当公司变大时，你可以通过制造“内部病毒式传播”来达成共识。如果公司人够多，它其实就像一个消费群体。如果你分享了一些有趣的东西，别人觉得有趣就会继续分享，你可以在公司内部制造病毒效应。
(00:47:16):
所以我们会做这些原型产品，重做一些功能，然后分享安装包，它就会在公司内部引爆。一天接一天，我们会听到工程师、经理、VP 甚至最后 Evan 都在说：“天哪，大家都在聊这个，为什么我是最后一个知道的？”
(00:47:47):
这会在全公司范围内瞬间达成共识：“这太令人兴奋了，我们要支持这个项目。”大家会问：“我们什么时候正式做？什么时候上线？我看到已经有人在弄了。”这是一种极好的对齐方式。一旦我们确认产品动态良好且经过测试，这就是把它推到所有人面前并建立“这就是未来，我们都在为此努力”共识的绝佳方法。

---

### [00:48:17] Lenny Rachitsky (Sponsorship)

**English:**
Today's episode is brought to you by Coda. I personally use Coda every single day to manage my podcast and also to manage my community. It's where I put the questions that I plan to ask every guest that's coming on the podcast. It's where I put my community resources. It's how I manage my workflows. Here's how Coda can help you.
(00:48:35):
Imagine starting a project at work and your vision is clear. You know exactly who's doing what and where to find the data that you need to do your part. In fact, you don't have to waste time searching for anything because everything your team needs from project trackers and OKRs to documents and spreadsheets lives in one tab all in Coda. With Coda's collaborative all in one workspace, you get the flexibility of docs, the structure of spreadsheets, the power of applications, and the intelligence of AI all in one easy to organize tab.
(00:49:04):
Like I mentioned earlier, I use Coda every single day. And more than 50,000 teams trust Coda to keep them more aligned and focused. If you're a startup team looking to increase alignment and agility, Coda can help you move from planning to execution in record time. To try it for yourself, go to coda.io/lenny today and get six months free of the team plan for startups. That's coda.io/lenny to get started for free and get six months of the team plan. coda.io/lenny.

**中文翻译:**
本集节目由 Coda 赞助。我个人每天都使用 Coda 来管理我的播客和社区。我会把计划问每位嘉宾的问题放在那里，还有我的社区资源和工作流管理。以下是 Coda 如何帮助你的：
(00:48:35):
想象一下开始一个工作项目，你的愿景很清晰。你确切地知道谁在做什么，以及在哪里可以找到你需要的数据。事实上，你不需要浪费时间寻找任何东西，因为你的团队需要的一切——从项目跟踪器和 OKR 到文档和电子表格——都存在于 Coda 的一个标签页中。通过 Coda 的协作式全方位工作空间，你可以在一个易于组织的标签页中获得文档的灵活性、电子表格的结构、应用程序的功能以及 AI 的智能。
(00:49:04):
正如我之前提到的，我每天都使用 Coda。超过 50,000 个团队信任 Coda，让他们保持更加对齐和专注。如果你是一个希望提高对齐度和敏捷性的初创团队，Coda 可以帮助你在创纪录的时间内从计划转向执行。想要亲自尝试，请立即访问 coda.io/lenny，获取初创公司团队计划的六个月免费试用。

---

### [00:49:34] Lenny Rachitsky

**English:**
Another thread I want to follow up on is prototyping. It feels like that is where a lot of PM work is going is getting straight to a prototype versus design or versus PRDs. And it feels like that's something that you did and worked super well. Basically, it's a team to prototype ideas that in theory now you can just build really quickly with AI. So I think that's really interesting, seeing where the feature's going, just ...

**中文翻译:**
我想跟进的另一个话题是原型设计。感觉现在的 PM 工作正趋向于直接做原型，而不是写设计稿或 PRD（产品需求文档）。这似乎是你做过且效果极好的事情。基本上，就是建立一个团队来把想法原型化，理论上现在用 AI 可以构建得非常快。看到这个趋势真的很有趣。

---

### [00:50:00] Gaurav Misra

**English:**
100%. Getting things in people's hands, trying it out. Oftentimes, unless you truly try it out, in design, it can, in theory, look good with all the perfect conditions, but when you actually use it, you realize it's actually not that useful, for example. Or when you give it to users. And some of this is intuition, honestly, just like anything else, but there's nothing like getting something in the hands of users at the end of the day.

**中文翻译:**
百分之百。把东西交到人们手里去尝试。很多时候，除非你真正试用了，否则在设计稿上，理论上在完美条件下看起来很好，但当你实际使用时，你会发现它其实没那么有用。或者当你把它交给用户时。坦白说，这其中一部分是直觉，但归根结底，没有什么比让用户亲手使用更有效的了。

---

### [00:50:23] Lenny Rachitsky

**English:**
I love how many of these things you brought over to your current company, and I'm trying to think about, one is this idea of just constantly innovating feels like that's informed and tell me what I'm missing, but that feels like that's informed. The ship market will feature every single week. This idea of getting design, starting almost with design versus PM a lot of times. I'm curious why you don't even go straight to prototype in those cases. Is it just the tools aren't there yet or?

**中文翻译:**
我喜欢你把这么多经验带到了现在的公司。我在想，一是这种持续创新的理念，这似乎影响了你们“每周发布可营销功能”的做法。还有这种从设计开始，而不是从 PM 开始的想法。我很好奇，为什么在这些情况下你们不直接做原型？是工具还不成熟吗？

---

### [00:50:47] Gaurav Misra

**English:**
I mean, I think our shipping process is fast enough that within a week we can get it out anyways. So that way we just get user feedback, which is even better.

**中文翻译:**
我认为我们的发布流程已经足够快了，一周之内无论如何都能发出去。这样我们就能直接获得用户反馈，效果更好。

---

### [00:50:55] Lenny Rachitsky

**English:**
And then the other really interesting thing, I'm trying to visualize that triangle of a product team, the triad of PM, engineer, design. Feels like you guys at Snap took the corners, not the corners, the line of that triangle. And you have design engineers. You have design PMs. I imagine engineers were PME already. They're very product oriented PMs. Did you have a function called design PMs? Probably not.

**中文翻译:**
另一件有趣的事，我在脑海中构思产品团队的“铁三角”：PM、工程师、设计。感觉你们在 Snap 时不是占据了三个角，而是占据了连接它们的线。你们有设计工程师，有设计 PM。我猜工程师本身也兼任 PM 职责，是非常产品导向的。你们当时有专门叫“设计 PM”的职能吗？可能没有。

---

### [00:51:20] Gaurav Misra

**English:**
I mean honestly, it's interesting.

**中文翻译:**
坦白说，这很有趣。

---

### [00:51:21] Lenny Rachitsky

**English:**
Sorry, engineer PMs.

**中文翻译:**
抱歉，是工程师 PM。

---

### [00:51:23] Gaurav Misra

**English:**
Yeah, engineer PMs should be a thing, I feel like, or every engineer should strive to understand the product, right?

**中文翻译:**
是的，我觉得“工程师 PM”应该成为一种常态，或者说每位工程师都应该努力去理解产品，对吧？

---

### [00:51:29] Lenny Rachitsky

**English:**
Yeah. A lot of companies operate that way. Like Stripe, I think they had hundreds of engineers before they hired the first PM because I think the engineers were doing what they did at Snap to do the PM work. So it feels like at your company you don't operate that way. It feels like you have PMs, engineers, designers. Talk about why you decided not to approach things that way.

**中文翻译:**
是的，很多公司都是这样运作的。比如 Stripe，我想他们在雇佣第一个 PM 之前已经有几百名工程师了，因为工程师承担了 PM 的工作。但感觉在你的公司，你们并没有完全采用这种方式，你们还是有 PM、工程师和设计师。聊聊为什么你决定不采用那种方式？

---

### [00:51:48] Gaurav Misra

**English:**
I do think PM is a very valuable function. I think it may be actually, and maybe I'll get roasted for this, but I think at the end of the day, not hiring PMs at Snap might've been one of those decisions where it actually succeeded despite that and because someone needs to do that work. If you don't have enough people to do it, then nobody truly owns it and then it doesn't really happen. Or if it doesn't happen, no one's responsible, which is not the right structure you want in an organization. So I think though, that being said, there was something unique to be said about what if a designer had the PM mindset.
(00:52:29):
It's actually the same idea as what if an engineer had the PM mindset and then you get even crazier. What if the PM had a design and engineering mindset? I think all we're talking about is everybody truly understanding all the functions that they're working with. Having a fundamental, broad understanding of the functions they're working with.
(00:52:48):
At Captions, we're actually going even one step further than that. Why shouldn't the PM understand marketing? I think that's actually the biggest opportunity for PMs to understand is how do we actually find the users who have this problem? I think that's a big part of solving the problem. I have a unique take on this in terms of I actually think PMs should own all the way to marketing in a way. And the reason is that if you think about marketing, it's expanding the surface area of the product, right? It's like search marketing is just placing a button to your product in Google.
(00:53:28):
Facebook ads is just placing a button to your app in Facebook. It's almost like you work at Facebook. You work at Facebook, you have a button in the app somewhere, you make a specific thing and people show up. The funnel begins there and you have all the metrics all the way from the beginning, all the way from when the user tapped on the button in Facebook and then they went down all the steps and then they landed on some onboarding screen and they did the thing, they used the application.
(00:53:56):
That's where the journey begins. And all of that is, in a way, it's a product. It's the same skillset. Understanding users from that point on is I think that's fundamental. How do we not do that today? We should be. So that's how we think about stuff. But I think the core idea is that every function should understand every other function deeply as much as possible and maybe even to the level where they can operate in that function. And that just increases the likelihood that all decisions being made in the company at the micro level will be optimized for all possible parts of the funnel that different people are essentially looking after. That's something we think about quite a bit.

**中文翻译:**
我确实认为 PM 是一个非常有价值的职能。虽然我可能会因此被吐槽，但我认为归根结底，Snap 当时不雇佣 PM 的决定，可能是一个“尽管如此依然成功”的决定，因为总得有人去做那些工作。如果你没有足够的人去做，就没人真正负责，事情就不会发生。或者如果没发生，也没人承担责任，这不是一个组织该有的健康结构。不过，话虽如此，如果设计师拥有 PM 思维，确实会有一些独特的东西。
(00:52:29):
这和“如果工程师有 PM 思维”是一样的道理，甚至更进一步：如果 PM 有设计和工程思维呢？我认为我们讨论的核心是：每个人都应该真正理解他们所协作的所有职能，对相关职能有基础且广泛的理解。
(00:52:48):
在 Captions，我们甚至更进一步。为什么 PM 不应该理解营销（marketing）？我认为 PM 最大的机会在于理解：我们如何真正找到有这个问题的用户？我认为这是解决问题的重要组成部分。我对此有一个独特的看法：我认为 PM 在某种程度上应该一直负责到营销环节。原因在于，如果你思考营销，它其实是在扩展产品的表面积，对吧？比如搜索营销，就是在 Google 里放一个指向你产品的按钮。
(00:53:28):
Facebook 广告就是在 Facebook 里放一个指向你应用的按钮。这就像你在 Facebook 工作，你在应用里某个地方放了个按钮，做了一个特定的东西，然后人们就来了。漏斗从那里开始，你拥有从头到尾的所有指标——从用户点击 Facebook 上的按钮，到走完所有步骤，降落在引导页面，然后开始使用应用。
(00:53:56):
旅程从那里开始。从某种意义上说，这一切都是“产品”。它们需要相同的技能组合。从那个点开始理解用户是至关重要的。为什么我们现在不这么做？我们应该这么做。这就是我们的思考方式。核心理念是：每个职能都应尽可能深入地理解其他职能，甚至达到可以跨职能操作的水平。这增加了公司在微观层面做出的所有决策都能针对漏斗各个环节进行优化的可能性。这是我们经常思考的问题。

---

### [00:54:44] Lenny Rachitsky

**English:**
I completely agree with that take. It's interesting that at Airbnb, Brian was famous for changing the titles of all product managers to product marketing manager for exactly this point because he's like-

**中文翻译:**
我完全同意这个看法。有趣的是，在 Airbnb，Brian Chesky 曾把所有产品经理的头衔改为“产品营销经理”（PMM），正是基于这一点，因为他觉得——

---

### [00:54:56] Gaurav Misra

**English:**
Makes sense.

**中文翻译:**
有道理。

---

### [00:54:57] Lenny Rachitsky

**English:**
... you should be doing the marketing, you shouldn't just be building the thing. And to me, I've always assumed as a PM, your job is for this thing to grow and to get adopted and be loved.

**中文翻译:**
……你应该去做营销，而不仅仅是构建东西。对我来说，我一直认为作为 PM，你的工作就是让这个东西增长、被采用并被喜爱。

---

### [00:55:07] Gaurav Misra

**English:**
Of course.

**中文翻译:**
当然。

---

### [00:55:07] Lenny Rachitsky

**English:**
So it's interesting people don't already think of it that way.

**中文翻译:**
所以很奇怪，竟然有人不这么想。

---

### [00:55:10] Gaurav Misra

**English:**
I agree.

**中文翻译:**
我同意。

---

### [00:55:11] Lenny Rachitsky

**English:**
But obviously, it's hard to learn the skills of being awesome and paid growth and SEO and product marketing, messaging, positioning, but I completely agree. That's such an important element of building a product. You're not just building a thing, hope it works. Goodbye. So I love that that's how you think about it. And so I guess when you hire PMs, it sounds like you look for marketing instinct and some experiences.

**中文翻译:**
但显然，要掌握付费增长、SEO、产品营销、文案策划、定位等技能是很困难的。但我完全同意，这是构建产品中如此重要的元素。你不仅仅是造个东西，然后祈祷它奏效，然后就撒手不管了。所以我喜欢你的这种思考方式。我猜当你招聘 PM 时，你会寻找营销直觉和相关经验。

---

### [00:55:31] Gaurav Misra

**English:**
100%. And at least the ability and instinct to be able to learn it.

**中文翻译:**
百分之百。至少要有学习它的能力和直觉。

---

### [00:55:38] Lenny Rachitsky

**English:**
Yeah. Okay, so I'm going to share one other thing that I thought as you were talking that I think is really interesting and it comes up a bunch on this podcast and this connects back to Ev and what we can learn from his success. So Patrick Olson once tweeted this tweet that has really stuck with me, which is it was around user research and the way he described it is user research isn't go to user research that informs what you build and then you build that. It's instead you do user research, it informs the mental model you have as a leader, a product builder of what your customers need and what pains they have, and you adjust that model in your head and then that's how you decide what to build. And it feels like Ev is very much that. His head was learning what people need, teens in particular, and it just worked.

**中文翻译:**
好。当你说话时，我想到了另一件非常有趣的事，这在播客中经常被提到，也与 Evan 以及我们能从他的成功中学到什么有关。Patrick Collison（Stripe 创始人）曾发过一条让我印象深刻的推文，是关于用户研究的。他的描述是：用户研究不是说你去做了调研，调研告诉你建什么，你就建什么。相反，你做用户研究是为了完善你作为领导者或产品构建者的“心理模型”，让你了解客户的需求和痛点，你在脑子里调整这个模型，然后据此决定构建什么。感觉 Evan 就是这样，他的大脑一直在学习人们（尤其是青少年）的需求，然后就奏效了。

---

### [00:56:28] Gaurav Misra

**English:**
Yeah, I think it's very spot on. I would say though Snap didn't like user research as a function for the longest time. I think there was one user researcher in the company until, again, 5,000 employees, the post IPO basically. But I think the people that were making a lot of the product decisions and the CEO himself, of course, were very steeped in how the user behaves and how they operate. They understood that.
(00:56:56):
I do think Snap also had a unique way of thinking about how to determine if a product is within scope or out of scope of what their mission was. And I think a lot of companies use the cyber framework and we try to as well, but essentially, the idea at the core was that they want to enable private sharing in a safe way. So I think that makes it clear that certain things just are out of scope for Snap.
(00:57:28):
It's actually one of the reasons why Snap wasn't the company to discover "short form video," TikTok style stuff because it was just against the nature of the company to even try something. It was against the mission of the company. Public sharing means possibly bullying and bad behaviors, which is exactly what Snap was trying to avoid. We don't want those behaviors to develop on the app. So for example, on Instagram stories, you can share somebody else's stories to your followers. I can take your story and share it to my followers. You can't do that on Snap.
(00:58:02):
And there was a discussion about should we do this? No, because it can enable bullying. Essentially, you're not consenting to your thing being shared to my followers and that's essentially bad. So a lot of it was done based on this type of pillar-based thinking of this is our mission, this is what we're trying to do, does it fit within or is it outside? If it's outside, we don't do it no matter what the cost of it is, no matter how exciting it is.
(00:58:30):
And even on Spotlight, the big challenge was like how do you take something like that and put that inside the Snap mission? So that was something we worked on quite a bit. Yeah, I mean I think there's tons of stories about earlier versions. I mean Snap almost had essentially what is TikTok earlier than TikTok existed and it died out because it didn't align with the mission essentially, but happy to get into it.

**中文翻译:**
是的，我觉得说得很准。不过我想说，Snap 在很长一段时间里并不喜欢“用户研究”这个职能。直到公司有 5000 人、上市之后，公司里好像才只有一个用户研究员。但那些做产品决策的人，当然还有 CEO 本人，都非常沉浸于用户的行为和操作方式。他们理解这一点。
(00:56:56):
我认为 Snap 在判断一个产品是否符合其使命方面也有一种独特的方式。很多公司使用各种框架，我们也尝试过，但 Snap 的核心理念是：他们希望以安全的方式实现“私密分享”。这让某些事情显然超出了 Snap 的范围。
(00:57:28):
这也是为什么 Snap 不是那家发现“短视频”（TikTok 风格）的公司，因为尝试那种东西违背了公司的本性，违背了公司的使命。公共分享意味着可能出现霸凌和不良行为，而这正是 Snap 试图避免的。我们不希望这些行为在应用上滋生。例如，在 Instagram Stories 上，你可以把别人的 Story 分享给你的粉丝。但在 Snap 上你不能这么做。
(00:58:02):
当时有过讨论：我们要不要做这个功能？答案是：不，因为这会导致霸凌。本质上，你并没有同意你的内容被分享给我的粉丝，这本质上是不好的。所以很多决策是基于这种“支柱式思维”：这是我们的使命，这是我们要做的，它符合吗？如果不符合，无论代价是什么，无论它看起来多诱人，我们都不做。
(00:58:30):
甚至在做 Spotlight（Snap 的短视频功能）时，最大的挑战也是：如何把这种东西放进 Snap 的使命里？我们为此做了很多工作。关于早期版本有很多故事，Snap 几乎在 TikTok 出现之前就拥有了类似 TikTok 的东西，但因为它不符合使命而夭折了。我很乐意聊聊这个。

---

### [00:58:56] Lenny Rachitsky

**English:**
Yeah, that actually would be really interesting, because interesting that these things are important. It's important to have these clear values in the mission of the company and to not focus on things that are outside that. And then you hear these stories of they had TikTok potentially. So yeah, whatever you can share there, that'd be awesome.

**中文翻译:**
是的，那肯定很有趣。拥有清晰的价值观和公司使命，并且不关注之外的事情，这非常重要。然后你又听到他们本来可能做出 TikTok 的故事。所以，无论你能分享什么，那都太棒了。

---

### [00:59:12] Gaurav Misra

**English:**
Yeah, I mean, I don't know if you remember this, but there was this product called Our Stories, and essentially it was MyStory, but it was a public story. And it started off with this idea of campus stories where you can post to your campus and other people can see it. And that actually started creating a lot of virality because essentially people would post. There was viral moments truly where people would post stuff like, "Oh, I think two people fell in love on it or something like that." Those types of things really went viral and it had really good engagement.
(00:59:47):
But at the end of the day, the problem was that we were against algorithmic essentially ranking of those types of things. So there was a curation team that was looking through every single one so that there's no negative behaviors happening essentially on the app. That was just not scalable. Even though it had really high engagement and was doing well, it just wasn't feasible to have a person looking at every single thing posted to determine whether it's appropriate or not.
(01:00:15):
It ended up dying out, but it looked like what was an early version of TikTok before it had launched. So I think in a way though it was a good thing because I think Snap does have a mission and I think it is solving a problem. I do think there is a bifurcation of social media at this point. There is what you traditionally think of as social networking where you share things with your friends. And by the way, remember the days where that used to be the way that apps would go viral. You would share things with your friends and then they would share with their friends and everybody was worried about friend sharing and how do you send to a friend and can I text message my friend or whatever.
(01:00:59):
That time is over. Virality now happens through a completely different mechanism. It happens through essentially algorithms that are deciding whether your piece of content is worth showing to an arbitrary number of people, and this is the new age of social media. It's TikTok, it's YouTube Shorts and Instagram Reels and so on. And I think actually it's changing the fundamental nature of how people interact, fundamental nature of how things go viral. And I actually think from a regulatory perspective, we should be thinking these as differently.
(01:01:37):
On one side, you have something where you're deciding who sees something and then on the other side, you have something where the company is deciding which means that it's semi curated, right? It's actually the company's voice. So yeah, I don't know, should Section 230 apply to that? I have no idea. Or maybe not. Maybe we're thinking about this the wrong way, so it should be interesting.

**中文翻译:**
是的。我不确定你是否记得，当时有一个叫“我们的故事”（Our Stories）的产品。本质上它就是“我的故事”（MyStory），但是公开的。它始于“校园故事”的想法，你可以发布到你的校园，其他人都能看到。这开始产生大量的病毒式传播，因为人们会发布一些东西，真的有那种病毒式时刻，比如“哦，我觉得有两个人在这里相爱了”之类的。这些东西非常火，参与度极高。
(00:59:47):
但归根结底，问题在于我们反对对这类内容进行算法排名。所以当时有一个人工审核团队在看每一条内容，以确保应用上没有负面行为。这根本无法扩展。尽管参与度很高，表现很好，但让一个人去看每一条发布的内容来判断是否合适，这在可行性上是行不通的。
(01:00:15):
它最终夭折了，但它看起来确实像 TikTok 发布前的早期版本。但我认为从某种意义上说这是件好事，因为 Snap 有自己的使命，它在解决一个问题。我认为目前的社交媒体已经出现了分化。一种是传统的社交网络，你和朋友分享东西。顺便说一下，还记得以前应用走红的方式吗？你分享给朋友，朋友再分享给他们的朋友，大家都在担心“好友分享”、如何发送给朋友、能不能给朋友发短信等等。
(01:00:59):
那个时代已经结束了。现在的病毒式传播通过完全不同的机制发生。它本质上是通过算法决定你的内容是否值得展示给任意数量的人。这是社交媒体的新时代：TikTok、YouTube Shorts、Instagram Reels 等等。我认为这正在改变人们互动的本质，改变事物走红的本质。从监管的角度来看，我们应该区别对待这两者。
(01:01:37):
一边是你决定谁看你的东西，另一边是公司决定谁看，这意味着它是半人工干预的，对吧？它实际上代表了公司的声音。所以，Section 230（美国《通信规范法》第 230 条，免除平台对用户内容的责任）是否应该适用于此？我不知道。也许不应该。也许我们思考的方式不对。这会很有趣。

---

### [01:02:03] Lenny Rachitsky

**English:**
Wow. All right. Well, I'm out of my depth on the legality decision, so I'm going to not follow that thread, but I imagine there's something really interesting there actually. So you've been talking about just how much things are changing and I just wanted to follow that thread and specifically, you guys are at the cutting edge of what is possible with AI video.

**中文翻译:**
哇。好吧，关于法律决策我不在行，所以我不打算深究那个话题，但我能想象那里面确实有些很有趣的东西。你一直在谈论事物变化有多快，我想顺着这个话题聊聊，特别是你们正处于 AI 视频可能性的最前沿。

---

### [01:02:25] Gaurav Misra

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:02:25] Lenny Rachitsky

**English:**
It feels like we're approaching and maybe we're there. This world where you have no idea if it's real or AI. I'm curious, first of all, just how far you think we are from that and second of all, the implications on the world where you can just generate any video you want.

**中文翻译:**
感觉我们正在接近，甚至已经到达了这样一个世界：你完全不知道一段视频是真的还是 AI 生成的。我很好奇，首先，你认为我们离那个阶段还有多远？其次，在一个可以随意生成任何视频的世界里，会有什么影响？

---

### [01:02:40] Gaurav Misra

**English:**
It's fundamental. At the end of the day, a time where video images, audio can't be trusted actually hasn't existed for a while. If you think about ... I mean there was a world in the 1800s where there was no video or audio or images and everything was proven by he said, she said for the most part. And it's possible that if everything can be generated and anything can be created and it looks just as real as if it were real and there's no way to tell, then we might actually return to that world where there's no way to prove anything besides physical evidence or he said, she said.
(01:03:20):
And I think that's scary, but also possibly opens a bunch of new opportunity for someone to figure out how to solve this problem. I think it's going to be a big problem. I do think today, we are almost there in terms of creating absolutely photorealistic video. I mean the very recent models, a very cutting edge is just about ... It feels like a few centimeters away from achieving it, but I do think to fully get there to the point where it cannot be differentiated at all, it's still a couple of years away.
(01:03:52):
I also think that it is use case driven in a way. I think thinking about Captions for a second, we take a unique view on what type of video we want to focus on. Video generation and text to video generation. If you look at it today, it's all silent video. There's no audio and it's often what you think of as stop video or B-roll, right? You can actually make a movie with B-roll. And a lot of a movie or a TV show or a social media post or an ad actually is dialogue or monologue. That's actually what it is is people talking to each other, to the camera, interacting. That's actually what makes true story.
(01:04:35):
B-roll is supportive elements that are showing up to set the scene or something like maybe before the scene opens, you see a few shots of New York City or LA or something, and then you jump into the room and now two people are talking. So our goal is to solve the talking video problem. How do we create video where people are delivering dialogue or monologue or things like that? And that's what we focus on purely. And there actually isn't a lot of work happening in that area today and it's not a solved problem. We're getting there, we're getting closer and closer, but today's models actually bifurcate a little bit.
(01:05:15):
So there's a set of companies today that are able to create these types of what we're talking about is avatar videos. They're using this technology called neural rendering. It's actually not a technology that's affected by the transformer and diffusion model revolution or the large model revolution, essentially. This is a technology that existed separately and it doesn't have anything to do with the AI growth happening right now. It just happens to produce semi-realistic outputs, but it actually stops at some point because it's not clear how it becomes generalizable in every situation.
(01:05:55):
It has to be trained on people individually. So you might ingest a little bit of video of you and then you can generate you. And so it's a different technology and a different outcome, essentially. And a bunch of companies using this type of model, a bunch of companies are doing general text to video with no audio today. These are large generative models and they have the capability to do more, but that frontier just hasn't been reached yet. I think there's no doubt in anybody's mind on the research side that it is 100% solvable. It's just like somebody has to go do it and we haven't gotten there yet. Nobody has had the time to go and do that yet. So that where we're at, essentially.
(01:06:35):
We're working purely on large generative models for talking videos. So that's our core focus. I do think though, from a safety perspective, we have a unique framework or how we think about it. So generally videos divide into two categories. So for us, we think on one side of what is documentation, so this is the type of video that it could be a personal video where you're taking a video with your friends and you're hanging out, you're at a restaurant. It's documenting what happened. You had fun, whatever it was, it's for your memories. And there's a non-personal version of this which is like, oh, it's like a reporter documenting a crime or something that happened or whatever it is and who was involved, where was it? Maybe it was a natural disaster or something, and this is for history. We want to see what happened.
(01:07:27):
And there's actually no benefit to AI-generated video in any of this. Actually, all of this, it's just negative. It's all negative. If we are generating fake versions of reality to fool people, there's just nothing good about that. And we want to stay away from that, essentially. We want to design products and build products that make it difficult to use for that particular use case, for anything that falls within that. And on the other side, you have what we think of as storytelling.
(01:07:56):
Now this could be ads, it could be social media posts, it could be TV, movies. All of these things are storytelling. They're designed for entertainment, they're designed for fun. And nobody believes if you watch a Geico commercial, you're not thinking that the gecko is real selling insurance somewhere out there. You know that this is fabricated and it's for entertainment. And same with reality TV even, right? It's called reality TV. It's definitely not reality and social media, ads, all this stuff falls in the category.
(01:08:28):
And if we can enable more people to tell stories and entertain other people and get their message out there, that is pure positive. This is where we want to focus. And a lot of our effort in the product and design process goes into how do we design products and build products that specifically make it really hard to use on one side and really easy to use on the other side. And that's the real challenge.

**中文翻译:**
这是根本性的改变。归根结底，视频、图像、音频不可信的时代其实已经很久没有出现了。如果你想想……在 19 世纪，没有视频、音频或图像，一切大多靠“口说无凭”来证明。如果一切都可以生成，任何东西都可以被创造出来，而且看起来和真的一模一样，无法分辨，那么我们可能真的会回到那个除了实物证据或口头证词之外无法证明任何事情的世界。
(01:03:20):
我认为这很可怕，但也可能为那些想出如何解决这个问题的人开启大量新机会。我认为这将是一个大问题。我确实认为，今天我们在创造绝对写实的视频方面已经快成功了。我是说最近的一些模型，非常前沿的，感觉离实现目标只有几厘米的距离。但我认为要完全达到无法区分的程度，还需要几年的时间。
(01:03:52):
我也认为这在某种程度上是由用例驱动的。想想 Captions，我们对关注哪种类型的视频有独特的看法。视频生成和文本转视频生成，如果你看现在的技术，大多是无声视频，没有音频，通常是你认为的素材视频或 B-roll（空镜头）。你确实可以用 B-roll 拍电影，但电影、电视节目、社交媒体帖子或广告的很大一部分实际上是对话或独白。本质上是人与人交谈、对着镜头说话、互动。这才是真正构成故事的东西。
(01:04:35):
B-roll 是辅助元素，用来交代场景，比如在场景开始前，你看到几张纽约或洛杉矶的照片，然后镜头切入房间，两个人在交谈。所以我们的目标是解决“说话视频”（talking video）的问题。我们如何创建人们在进行对话或独白之类的视频？这就是我们纯粹关注的点。目前在这个领域还没有太多的工作在进行，它还不是一个已解决的问题。我们正在接近，越来越近，但今天的模型实际上出现了一些分化。
(01:05:15):
现在有一批公司能够创建我们所说的“数字人”（avatar）视频。他们使用的是一种叫做神经渲染（neural rendering）的技术。本质上，这并不是受 Transformer 和扩散模型革命或大模型革命影响的技术。这是一种独立存在的技术，与现在的 AI 爆发没有直接关系。它恰好能产生半写实的输出，但它在某些点上会停滞，因为它不清楚如何使其在每种情况下都通用。
(01:05:55):
它必须针对个人进行训练。你可能需要摄入一段你自己的视频，然后它就能生成你。所以这是不同的技术，产生不同的结果。还有一堆公司在做通用的无声文本转视频。这些是大规模生成模型，它们有能力做得更多，但那个前沿领域尚未被攻克。在研究界，没人怀疑它是 100% 可解决的。只是需要有人去做，而我们还没到那一步。还没人有时间去做那件事。这就是我们目前的处境。
(01:06:35):
我们纯粹在研究用于“说话视频”的大规模生成模型。这是我们的核心焦点。不过，从安全角度来看，我们有一个独特的框架。通常视频分为两类：一类我们认为是“记录”（documentation），比如你和朋友在餐厅聚会的私人视频，它记录了发生的事情，是为了留住回忆。还有非私人版本，比如记者记录犯罪现场或自然灾害，这是为了历史，我们想看发生了什么。
(01:07:27):
在这些场景中，AI 生成视频没有任何好处。实际上，这些全是负面的。如果我们生成虚假的现实来愚弄人们，那没有任何好处。我们希望避开这些。我们希望设计和构建产品，让这些特定的用例变得难以实现。而另一类我们认为是“讲故事”（storytelling）。
(01:07:56):
这可以是广告、社交媒体帖子、电视、电影。所有这些都是讲故事。它们是为娱乐和趣味而设计的。没人看 Geico 广告时会觉得那只壁虎是真的在外面卖保险。你知道那是虚构的，是为了娱乐。真人秀也一样，虽然叫真人秀，但绝对不是现实。社交媒体、广告，所有这些都属于这一类。
(01:08:28):
如果我们能让更多人讲故事、娱乐他人并传达他们的信息，那纯粹是积极的。这就是我们想要关注的地方。我们在产品和设计过程中的很多精力都花在：如何设计和构建产品，让它在“记录”那一侧极难使用，而在“讲故事”这一侧极易使用。这才是真正的挑战。

---

### [01:08:53] Lenny Rachitsky

**English:**
That's really helpful. Something that I'm really curious about as you're chatting is ByteDance just released a really amazing model. I was actually just looking at it where you put a photo in, I think, and it just creates a video of this person talking in all these different ways. Where does that fall amongst the buckets you just described?

**中文翻译:**
这很有帮助。我很好奇的是，字节跳动刚刚发布了一个非常惊人的模型。我刚才还在看，你放一张照片进去，它就能生成一段这个人以各种方式说话的视频。这属于你刚才描述的哪一类？

---

### [01:09:09] Gaurav Misra

**English:**
I think that falls exactly in the area that we're in, which is talking people and that's what they're going after as well there. So that's actually one of the first examples of a large model that a larger company has released where it's able to do these dialogue or monologue videos. And I mean you yourself, you've seen it, so I'm not going to describe it too much, but as you know, it's highly expressive. It doesn't look like an avatar video. It looks like ...

**中文翻译:**
我认为那正属于我们所在的领域，即“说话的人”，那也是他们正在追求的目标。这实际上是大公司发布的首批能够进行对话或独白视频的大模型示例之一。你自己也看过了，我就不多描述了，但如你所知，它非常有表现力。它看起来不像普通的数字人视频，它看起来像……

---

### [01:09:37] Lenny Rachitsky

**English:**
Yeah, it's wild.

**中文翻译:**
是的，太疯狂了。

---

### [01:09:38] Gaurav Misra

**English:**
And that's because of the technology that's used is fundamentally different. It's just like this is using a true large diffusion model is what they use. Whereas most companies that are working on avatar technology are actually using something pretty basic in comparison.

**中文翻译:**
那是由于所使用的技术从根本上就不同。他们使用的是真正的超大规模扩散模型。而大多数研究数字人技术的公司相比之下使用的技术还比较基础。

---

### [01:09:53] Lenny Rachitsky

**English:**
How long has it been since that Will Smith spaghetti video? Just to give us a reference of how fast things are moving?

**中文翻译:**
距离那个威尔·史密斯吃意大利面的视频过去多久了？只是想参考一下现在的发展速度有多快。

---

### [01:09:58] Gaurav Misra

**English:**
Oh my god, it's been so fast, right?

**中文翻译:**
天哪，太快了，对吧？

---

### [01:09:59] Lenny Rachitsky

**English:**
I think it's a year.

**中文翻译:**
我想是一年。

---

### [01:09:59] Gaurav Misra

**English:**
Amazing.

**中文翻译:**
太神奇了。

---

### [01:09:59] Lenny Rachitsky

**English:**
Or is it like two years?

**中文翻译:**
或者是两年？

---

### [01:10:03] Gaurav Misra

**English:**
I think it's probably about a year and a half, two years. Right?

**中文翻译:**
我想大概是一年半到两年吧？

---

### [01:10:04] Lenny Rachitsky

**English:**
Wow. We'll link to that video and then you could tell basically that video is the state of the art of AI video one to two years ago. And then we'll link to this other Omni something. I forget what it's called. I'm just showing what it's like today.
(01:10:18):
Geez, Louise. Okay, final question and this is around something that I know you have a really interesting insight on, which is that you see marketing using AI video basically as the final frontier of how people will experience AI is marketing, is seeing it in marketing channels. Talk about why you think that's the case and just what that looks like.

**中文翻译:**
哇。我们会放上那个视频的链接，你可以看到那基本上就是一两年前 AI 视频的最高水平。然后我们会链接到这个 Omni 什么的模型（指字节跳动的 OmniHuman）。我只是想展示一下现在的水平。
(01:10:18):
天哪。好，最后一个问题，我知道你有一个非常有趣的见解：你认为营销中使用 AI 视频基本上是人们体验 AI 的“最后疆域”，即在营销渠道中看到它。聊聊你为什么这么想，以及那会是什么样子。

---

### [01:10:42] Gaurav Misra

**English:**
It comes back to what we were talking about before where the reality is that no matter how interesting, advanced and amazing a technology is, science fiction has become reality. We were talking about this. What was literally science fiction on TV is real now and most people still don't even know about it, to be honest.
(01:11:01):
My parents live in India and they are the only ones in the neighborhood that know about ChatGPT and they write these amazing notes to the community just with all these words. And people are just like, "How did you get so good at writing?" And they're not telling anybody, but there's still a ton of people who don't even know that these advancements have happened. And so adaption is actually much slower, even for the most exciting things. Of course, in tech circles, everybody's talking about it, but the reality is it takes a while to get out there.
(01:11:33):
And I think for companies that are going to succeed, they're going to have to figure out how to market these products so that they can be the ones to reach all these people that have the problems that they're now able to solve. And we think about that every day. So on that note, as a consumer product, we spend a bunch of time and money on marketing our products, and we often use performance channels and all kinds of things, but about a year ago, we would run AI video in ads and things like that, and we would get all these comments of people being like, "Oh My God, this is so fake. Don't show me this."
(01:12:08):
And around that time, the technology got just about good enough that suddenly, those comments stopped happening and suddenly, you could get performance that was even better than actually recording with a person because you could just try more things. You could just generate 30, 40 possibilities and one of them would win and it would win more than the one creative you can get from a person. And more interestingly, when you think about localization, you're going to go do that in every language. Once you discover winning creative, now you have to go localize that in every market and rebuild it from scratch.
(01:12:51):
It's just a ton. And oftentimes it doesn't perform as well because it's been rethought essentially. But we found that just translating it with AI was able to get performance almost as good as the original, in the original language. So this is going to fly to the entire market. I think wherever there's dollars to be made, saved, it is inevitable. It will be consumed and it will very quickly be a lot of social media.
(01:13:21):
I mean, you could imagine a social network of the future where, and this is dystopian by the way, so watch out. You could imagine a social network of the future where all content is generated. None of the people are real. I mean, the algorithm isn't tailoring whose content to show you, but it's purely generating content that is completely catered to you, with people and everything completely catered to you. I don't think it's out of the question. It almost seems inevitable in a way, but that's not too far away, I think. That's actually very possibly real in five years or something like that.

**中文翻译:**
这回到了我们之前讨论的话题：现实是，无论一项技术多么有趣、先进和惊人，科幻已经变成了现实。我们聊过这个，电视上的科幻情节现在成真了，但老实说，大多数人甚至还不知道。
(01:11:01):
我的父母住在印度，他们是社区里唯一知道 ChatGPT 的人，他们用它给社区写那些文采斐然的通知。邻居们都惊叹：“你们怎么写得这么好？”他们没告诉任何人。但仍有大量的人根本不知道这些进步已经发生。所以，即使是最令人兴奋的事物，其普及速度实际上也慢得多。当然，在科技圈大家都在谈论，但现实是它需要一段时间才能走向大众。
(01:11:33):
我认为，那些能够成功的公司必须弄清楚如何营销这些产品，以便能够触达那些拥有他们现在能够解决的问题的人。我们每天都在思考这个问题。作为一个消费级产品，我们投入了大量时间和金钱进行营销，使用效果广告渠道等。大约一年前，我们在广告里放 AI 视频，会收到很多评论说：“天哪，这太假了，别给我看这个。”
(01:12:08):
而就在那段时间，技术刚好达到了一个临界点，突然间，那些评论消失了。突然间，AI 视频的效果甚至比真人拍摄还要好，因为你可以尝试更多东西。你可以生成 30、40 种可能性，其中一种会胜出，而且效果比你从真人那里得到的唯一创意要好得多。更有趣的是，考虑到本地化，你需要用每种语言去做。一旦你发现了一个成功的创意，你必须在每个市场进行本地化，从头开始重建。
(01:12:51):
工作量巨大，而且往往效果不如原版，因为本质上被重新构思了。但我们发现，直接用 AI 翻译，其效果几乎能达到原版语言的水平。所以这将席卷整个市场。我认为，只要有钱可赚、有成本可省，这就是必然的。它将被广泛消费，并很快充斥社交媒体。
(01:13:21):
我的意思是，你可以想象未来的社交网络——顺便说一句，这有点反乌托邦，所以要小心——你可以想象未来的社交网络，所有的内容都是生成的。没有一个是真人。算法不是在挑选展示谁的内容给你，而是纯粹在生成完全迎合你的内容，里面的人和一切都是为你定制的。我认为这并非不可能。在某种程度上，这似乎是不可避免的。我觉得这并不遥远，可能在五年左右就会成真。

---

### [01:14:00] Lenny Rachitsky

**English:**
What I'm imagining, because it's hard to imagine a social network where it's people because usually we want to know who these people are. I don't care random sharing status updates, but I can see a TikTok that is all AI.

**中文翻译:**
我在想象，因为很难想象一个全是假人的社交网络，因为通常我们想知道这些人是谁。我不在乎随机分享的状态更新，但我能预见到一个全是 AI 生成内容的 TikTok。

---

### [01:14:11] Gaurav Misra

**English:**
Exactly, exactly.

**中文翻译:**
没错，正是如此。

---

### [01:14:13] Lenny Rachitsky

**English:**
Wow, just content tuned to your loves and interests.

**中文翻译:**
哇，全是根据你的爱好和兴趣定制的内容。

---

### [01:14:17] Gaurav Misra

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:14:17] Lenny Rachitsky

**English:**
And just random videos. Wow.

**中文翻译:**
还有各种随机视频。哇。

---

### [01:14:21] Gaurav Misra

**English:**
Yep. Because do you know, you see a TikTok feed, you don't even know who's real or not today, right? It's not like we-

**中文翻译:**
是的。因为你知道，你现在刷 TikTok，你甚至都不知道谁是真的谁是假的，对吧？

---

### [01:14:27] Lenny Rachitsky

**English:**
Right. That's how I would approach it. I would just join TikTok and start uploading videos that are AI generated.

**中文翻译:**
对。如果是我，我就会这么干。我会加入 TikTok，然后开始上传 AI 生成的视频。

---

### [01:14:32] Gaurav Misra

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:14:33] Lenny Rachitsky

**English:**
And then build a whole network of that. Oh my god, the future is wild.
(01:14:37):
Let's go to failure corner. Something that I try to do with this podcast is share moments where things didn't go well. There's all these stories of everything's going great all the time. All this foundries killing it, building a billion-dollar company. Oh, so awesome. But they don't know all the things that go wrong. So let me ask you, is there a story you can share of when things didn't work out? When you failed?

**中文翻译:**
然后围绕它建立一个完整的网络。天哪，未来太疯狂了。
(01:14:37):
让我们进入“失败角落”。我在这个播客中尝试做的一件事就是分享那些进展不顺的时刻。到处都是“一切永远美好”的故事，创始人如何大杀四方，建立十亿美元的公司。哦，太棒了。但人们不知道那些出错的事情。所以我想问你，你能分享一个事情进展不顺、你失败了的故事吗？

---

### [01:14:59] Gaurav Misra

**English:**
At the beginning of the company, we actually had a bunch of time where we spent figuring out what we wanted to do, and I think it's an unconventional story almost in a way because we started off the company, the first thing we did was build the Captions app. We launched the app. That was the first thing we did. Took two days to build it. We put it out there and it immediately took off. It was absolutely shocking because I built it on a weekend. We put it out there, I called my co-founder on Monday. I'm like, "It's at the top of the app store. We're getting like 600 videos a day."

**中文翻译:**
在公司成立之初，我们实际上花了很长时间来弄清楚我们想做什么。我认为这几乎是一个不寻常的故事，因为我们创立公司后做的第一件事就是构建 Captions 应用。我们发布了它，那是我们做的第一件事。花了两个月时间构建。我们把它发布出去，它立即就火了。这绝对令人震惊，因为我是利用一个周末做出来的。周一我打电话给我的联合创始人说：“它冲到了应用商店榜首，我们每天有大约 600 个视频生成。”

---

### [01:15:31] Lenny Rachitsky

**English:**
Top of the app store, holy shit.

**中文翻译:**
应用商店榜首，天哪。

---

### [01:15:33] Gaurav Misra

**English:**
And we didn't do anything to enable that. It just happened on its own. It was almost anti-climactic in a way because we thought it would be a lot more time spent figuring out the product before that would happen. And so it felt like, "Wait, this can't be it, right? It can't be this fast. How did this happen?" So we got distracted because of that, because we were like, "Oh, okay. Well, maybe ... This is cool. It'll work. That's great, but we got to figure out what the product is."
(01:16:07):
And so we spent at least a year, year and a half thinking about building social networks and all kinds of things when we should have been working on Captions because there was product market fit there. And how we figured that out is Captions was sitting on my personal account, so I wasn't checking that a lot. About a year and a half into the company, as we were working on other projects and stuff, I went back to my personal account, just opened it, and I saw that there was $500,000 in there.
(01:16:38):
I looked at a chart and it was just growing. The revenue was just growing completely on its own. No employees, no releases, no bug fixes, no customer support. There was like 2,000 open support tickets that were unanswered for a year and a half, and great reviews. It's just going completely on its own. And so that was a clear sign to me. It was like, "Oh my God, you should have been working on that. That product works."
(01:17:05):
And so we immediately had a meeting. I mean, it was tough to figure out what the right path was at that point because we'd invested so much time in other things as well, but reset, and we got back on the track with Captions, and literally as soon as we started releasing the first features into it, it blew up. What looked like a vertical line at that time became a horizontal line, and the new vertical line was so vertical that the old vertical line became a horizontal line, essentially. And it's continued since then, which is crazy. So we basically wasted about a year and a half.

**中文翻译:**
我们没做任何推广，它就自然发生了。这在某种程度上甚至有点让人扫兴，因为我们本以为在发生这种事之前，需要花更多时间去打磨产品。所以感觉就像：“等等，这不可能是终点吧？不可能这么快。这是怎么发生的？”于是我们因此分心了，因为我们觉得：“哦，好吧，也许……这很酷，它能行，太棒了，但我们得弄清楚真正的‘产品’是什么。”
(01:16:07):
于是我们花了至少一年、一年半的时间思考构建社交网络之类的各种东西，而当时我们本该专注于 Captions，因为那里已经有了产品市场匹配。我们是怎么发现的呢？Captions 当时挂在我的个人账户下，所以我没怎么查看。在公司成立大约一年半后，当我们正在做其他项目时，我回到我的个人账户，打开一看，发现里面竟然有 50 万美元。
(01:16:38):
我看了下图表，它一直在增长。收入完全是自发增长的。没有员工维护，没有新版本发布，没有 bug 修复，没有客户支持。有大约 2000 个未处理的客服工单，晾了一年半，但评价依然很好。它完全在自行运转。对我来说，这是一个明确的信号：“天哪，你本该一直做这个的。这个产品行得通。”
(01:17:05):
于是我们立即开了个会。当时要决定正确的路径很难，因为我们在其他事情上也投入了大量时间，但我们重启了，回到了 Captions 的轨道上。字面意义上，一旦我们开始发布第一批功能，它就爆发了。当时看起来像垂直增长的线变成了水平线，因为新的垂直增长线是如此之陡，以至于旧的垂直线相比之下变成了水平线。从那以后这种势头一直持续着，这太疯狂了。所以我们基本上浪费了大约一年半的时间。

---

### [01:17:42] Lenny Rachitsky

**English:**
I love that new way of thinking about a hockey stick moment where not only is it going vertical, but the rest of the chart is now just flat along the bottom of the axis.

**中文翻译:**
我喜欢这种对“曲棍球棒增长时刻”的新思考方式：不仅是它在垂直增长，而且图表的其余部分现在看起来就像沿着轴底部的平线。

---

### [01:17:49] Gaurav Misra

**English:**
Exactly. Yeah.

**中文翻译:**
没错。

---

### [01:17:51] Lenny Rachitsky

**English:**
For people that may not know what Captions is, I try to describe it at the beginning and we'll link to it and stuff, but basically, the reason you thought it was nothing is it just adds captions to a video that you record.

**中文翻译:**
对于那些可能不知道 Captions 是什么的人，我在开头尝试描述过，我们也会放链接。但基本上，你当时觉得它没什么大不了的原因是，它只是给你录制的视频添加字幕。

---

### [01:18:01] Gaurav Misra

**English:**
It does.

**中文翻译:**
确实如此。

---

### [01:18:01] Lenny Rachitsky

**English:**
Added captions.

**中文翻译:**
添加字幕。

---

### [01:18:02] Gaurav Misra

**English:**
Exactly, yep. So I think we wanted ... Our thought was we're going to build a social network, but first we got to build a creation tool for the social network. And we knew that we wanted to use AI to create video, and it seemed obvious that, "Oh, speech to text, a solved problem, we should start with that." So that's why we decided to start with Captions because it was a solved problem at the time. What was funny is that once GPT and stuff started coming out, a lot of the things that were unsolved became solved very quickly. So timing was almost perfect.

**中文翻译:**
没错。我们当时的想法是：我们要建立一个社交网络，但首先得为这个社交网络建立一个创作工具。我们知道我们想用 AI 来创作视频，而当时看起来显而易见的是：“哦，语音转文字是一个已解决的问题，我们应该从这里开始。”这就是为什么我们决定从 Captions 开始，因为在当时那是一个已解决的问题。有趣的是，一旦 GPT 之类的东西开始出现，很多未解决的问题很快就迎刃而解了。所以时机几乎是完美的。

---

### [01:18:37] Lenny Rachitsky

**English:**
And that aligns to something you shared earlier. Just so many of these problems that were not yet solved are now possible, and the companies that are in the right place at the right time benefit greatly who've been just waiting for this part.
(01:18:50):
The other thing that I think is interesting about that story is you try to build a social network. I think it was around high schools and things like that. As we've seen, it's very difficult to build a new social network. So let me just get your sense. Do you think it's possible for somebody to come around and build a new, the next Facebook, the next Snap, the next whatever?

**中文翻译:**
这与你之前分享的观点一致。这么多尚未解决的问题现在都变得可能了，那些在正确的时间出现在正确地点的公司获益匪浅，他们一直在等待这一刻。
(01:18:50):
那个故事中另一件有趣的事是，你尝试建立一个社交网络，我记得是围绕高中之类的。正如我们所见，建立一个新的社交网络非常困难。所以我想听听你的感觉：你认为现在还有可能有人出来建立一个新的、下一个 Facebook、下一个 Snap 或下一个什么吗？

---

### [01:19:09] Gaurav Misra

**English:**
I think it's definitely possible. I do think ... Let me tell you something crazy, actually. The social network that we had at the time, we actually remove it from the app store, so it's not available anymore. But til today, there are people, there are thousands of people that are using it, posting on it, and all the different things, which actually speaks to the power of the social network in a way. It is hard to create and hard to kill. I mean, I think X is actually a great example of that too. A lot of movement happened there and it continues to work, I guess somehow. So testament to that.

**中文翻译:**
我认为绝对有可能。实际上，让我告诉你一件疯狂的事。我们当时做的那个社交网络，其实已经从应用商店下架了，所以现在已经搜不到了。但直到今天，仍有成千上万的人在使用它、在上面发布内容等等。这在某种程度上说明了社交网络的力量：它很难建立，也很难被杀死。我认为 X（原 Twitter）也是一个很好的例子。那里发生了那么多变动，但它似乎以某种方式继续运转着。这就是证明。

---

### [01:19:49] Lenny Rachitsky

**English:**
The power of network effects, especially someone once described this so well, they're like Twitter/X. They changed the brand, they changed the team building it. They changed the URL. Like everything changed about it except the network effect of the people in it.

**中文翻译:**
这就是网络效应的力量。有人曾描述得非常好：像 Twitter/X，他们改了品牌，换了团队，改了 URL。关于它的一切都变了，除了身处其中的人的网络效应。

---

### [01:20:07] Gaurav Misra

**English:**
It's true. It's true.

**中文翻译:**
没错，是真的。

---

### [01:20:09] Lenny Rachitsky

**English:**
I just saw a story that they're making billions of dollars. He's actually turned it around. It's actually becoming a really profitable company.

**中文翻译:**
我刚看到报道说他们赚了几十亿美元。他（马斯克）实际上扭转了局面，它正在变成一家非常盈利的公司。

---

### [01:20:16] Gaurav Misra

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:20:17] Lenny Rachitsky

**English:**
Yeah. It just came out the other day. So Elon did it. Well, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
是的，前几天刚出的消息。埃隆做到了。好，说到这，我们进入了非常令人兴奋的闪电轮环节。准备好了吗？

---

### [01:20:25] Gaurav Misra

**English:**
I'm ready. Let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [01:20:27] Lenny Rachitsky

**English:**
What are two or three books that you have recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:20:32] Gaurav Misra

**English:**
I have to say here that I actually don't read books. It's actually something that I decided on purpose where I decided I don't want to build my skill in reading, and I want to build it in listening and watching instead, because I think that's the future.

**中文翻译:**
我必须在这里说，我其实不看书。这是我特意做出的决定：我不想培养阅读技能，我想培养听和看的技能，因为我认为那才是未来。

---

### [01:20:49] Lenny Rachitsky

**English:**
I love how intentional that is, and I love how it's a really cool way of saying, I don't read books. The future isn't reading, but I love that you have books behind you, so.

**中文翻译:**
我喜欢这种刻意为之，这是一种说“我不看书”的非常酷的方式。未来不是阅读，但我喜欢你身后竟然摆着书。

---

### [01:20:58] Gaurav Misra

**English:**
I do. Yeah.

**中文翻译:**
是的。

---

### [01:20:59] Lenny Rachitsky

**English:**
[inaudible 01:20:59]

**中文翻译:**
（笑）

---

### [01:21:00] Gaurav Misra

**English:**
[inaudible 01:21:00] didn't read, they're back there.

**中文翻译:**
那些没读过的书就在后面。

---

### [01:21:03] Lenny Rachitsky

**English:**
That's funny. Okay, cool. I want to ask more questions, but I'm going to keep going. Lightning around. Speaking of watching and listening, do you have a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
太逗了。好，我想多问几个问题，但我得继续闪电轮。说到看和听，你最近有什么非常喜欢的电影或电视节目吗？

---

### [01:21:12] Gaurav Misra

**English:**
I like Silo and Severance. I mean, obviously, I think everyone's watching these. There's a book around Silo too.

**中文翻译:**
我喜欢《羊毛战记》（Silo）和《人生切割术》（Severance）。显然大家都在看。顺便说一下，《羊毛战记》也有原著书。

---

### [01:21:18] Lenny Rachitsky

**English:**
I read that. I read all of them. There's three of them.

**中文翻译:**
我读过，三本全读了。

---

### [01:21:20] Gaurav Misra

**English:**
There are.

**中文翻译:**
是的。

---

### [01:21:20] Lenny Rachitsky

**English:**
It sucks to watch the show because you know all the tricks that are about to happen, and I'm just like, "Why am I watching this? I know where this will go.

**中文翻译:**
看剧的时候很痛苦，因为你知道所有即将发生的转折，我会想：“我为什么要看这个？我知道结局。”

---

### [01:21:27] Gaurav Misra

**English:**
Yeah. I mean, for what it's worth, it does seem like the show is going on a slightly different path.

**中文翻译:**
是的。不过，这部剧似乎走了一条略有不同的路线。

---

### [01:21:31] Lenny Rachitsky

**English:**
It is. That was also what annoyed me. Just like, "What the heck? This is made up. All is made up shit." I don't like that when I watch the show. So two reasons I'm not watching it but.

**中文翻译:**
确实。那也是让我恼火的地方。就像：“搞什么？这是编的，全是瞎编。”我不喜欢看剧时有这种感觉。所以我有两个理由不看它。

---

### [01:21:39] Gaurav Misra

**English:**
Don't worry about it. I didn't actually read the book. My wife read the book and then she told me the story.

**中文翻译:**
别担心。我其实没看书，是我妻子看了书然后把故事讲给我听的。

---

### [01:21:44] Lenny Rachitsky

**English:**
Okay, okay. I was worried. I was worried. Okay, cool, and Severance. Okay, great. I love Severance.
(01:21:51):
Next question. Do you have a favorite product you've recently discovered that you really like?

**中文翻译:**
好吧，我刚才还担心呢。好，《人生切割术》也很棒。下一个问题：你最近有没有发现什么非常喜欢的、心头好的产品？

---

### [01:21:55] Gaurav Misra

**English:**
My favorite product, honestly, is Linear. I'm not going to lie, just because it's so well-designed and it's so easy to use. I also like Superhuman. I mean, these are obvious answers, but I do use these things every day and it's hard to create products that you use every day and don't hate. So props for them.

**中文翻译:**
我最喜欢的产品坦白说是 Linear。我不撒谎，因为它设计得太好了，太好用了。我也喜欢 Superhuman。这些答案可能很普通，但我确实每天都在用。要做出让人每天使用且不讨厌的产品很难，向他们致敬。

---

### [01:22:13] Lenny Rachitsky

**English:**
Cool. I haven't announced this on the podcast yet, but this is a good time, whoever's listening right now, is I just launched a bundle where if you become a paid subscriber to my newsletter, you get, listen to this, a year free of Linear and Superhuman and Notion and Granola, which is incredible AI app for note-taking and Perplexity, Perplexity Pro.

**中文翻译:**
酷。我还没在播客上宣布，但现在是个好时机：我刚刚推出了一个捆绑优惠，如果你成为我 Newsletter 的付费订阅者，你可以免费获得一年的 Linear、Superhuman、Notion、Granola（一款很棒的 AI 笔记应用）以及 Perplexity Pro。

---

### [01:22:35] Gaurav Misra

**English:**
Ooh. Nice.

**中文翻译:**
噢，太棒了。

---

### [01:22:36] Lenny Rachitsky

**English:**
$2,000 in value for the price of my newsletter, 200 bucks, going to that.

**中文翻译:**
200 美元的订阅费换取价值 2000 美元的权益。

---

### [01:22:40] Gaurav Misra

**English:**
Damn, that's real value.

**中文翻译:**
哇，那是真金白银的价值。

---

### [01:22:43] Lenny Rachitsky

**English:**
It's an unbelievable deal, and it's a no-brainer at this point to buy a subscription, but this isn't an ad for my newsletter. I'll keep going.
(01:22:50):
Next question. Do you have a favorite life motto that you often find yourself coming back to, sharing with friends and family in work or in life?

**中文翻译:**
这是一个令人难以置信的优惠，现在订阅简直是不假思索的选择。但这不只是我 Newsletter 的广告，我们继续。下一个问题：你有没有什么人生格言，是你经常回味、并与亲友在工作或生活中分享的？

---

### [01:22:57] Gaurav Misra

**English:**
I actually learned this because someone else told me that I keep repeating this thing, but I have this framework of how I want to operate at work, basically. Right? I think I love to compete and to win at the end of the day. And I think that to win, you have to be the best. But I also think the easiest way to be the best is to be the first, and that actually is key.

**中文翻译:**
我其实是听别人说我一直在重复这句话才意识到的。我有一个关于如何在工作中运作的框架：我热爱竞争，并渴望最终获胜。我认为要赢，你就必须成为最好的。但我也认为，成为最好的最简单方法就是成为“第一”（第一个做某事的人），这实际上是关键。

---

### [01:23:25] Lenny Rachitsky

**English:**
And so is the motto the easiest way? Is that the-

**中文翻译:**
所以格言就是“最简单的方法”？那是——

---

### [01:23:27] Gaurav Misra

**English:**
That's it. The easiest way to be the best is to be first.

**中文翻译:**
就是这句：成为最好的最简单方法就是成为第一。

---

### [01:23:31] Lenny Rachitsky

**English:**
Be the first. Interesting. Okay. I have to resist following threads here because I want to make this lightning round.
(01:23:37):
Okay. Final question, just for fun. What's the coolest, most wild AI video you've seen recently? Is there one that comes to mind of like, "Wow, that was something"?

**中文翻译:**
成为第一。很有趣。好，我得克制住继续深挖的冲动，因为这是闪电轮。最后一个问题，纯属好玩：你最近看过的最酷、最疯狂的 AI 视频是什么？有没有哪一个让你觉得“哇，那真了不起”？

---

### [01:23:47] Gaurav Misra

**English:**
I mean, honestly, I got to say the OmniHuman stuff was pretty cool.

**中文翻译:**
坦白说，我得说 OmniHuman（字节跳动模型）的东西非常酷。

---

### [01:23:52] Lenny Rachitsky

**English:**
The ByteDance video that we talked about.

**中文翻译:**
就是我们刚才聊到的那个字节跳动的视频。

---

### [01:23:52] Gaurav Misra

**English:**
Yeah, exactly. I mean, the broccoli talking. I don't know if you saw that one. There was a little broccoli delivering a little speech.

**中文翻译:**
是的，没错。我是说那个会说话的西兰花。不知道你有没有看过，有一颗小西兰花在发表简短演讲。

---

### [01:24:01] Lenny Rachitsky

**English:**
Interesting.

**中文翻译:**
有趣。

---

### [01:24:03] Gaurav Misra

**English:**
Yeah, it looked like it was animated by an animator.

**中文翻译:**
是的，它看起来就像是由动画师亲手制作的动画。

---

### [01:24:08] Lenny Rachitsky

**English:**
Just imagine being a kid these days and just seeing stuff like that.

**中文翻译:**
想象一下现在的孩子，每天都能看到这样的东西。

---

### [01:24:11] Gaurav Misra

**English:**
I think you're probably just used to it, right? You're just like, this is just normal.

**中文翻译:**
我想他们可能已经习惯了，对吧？他们会觉得这很正常。

---

### [01:24:13] Lenny Rachitsky

**English:**
Mm-hmm. It's just like we were saying, AGI is just going to come around.

**中文翻译:**
嗯，就像我们说的，AGI 迟早会到来。

---

### [01:24:17] Gaurav Misra

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:24:17] Lenny Rachitsky

**English:**
All right. Cool. What's for dinner? Cool. That's great.

**中文翻译:**
好。酷。晚饭吃什么？太棒了。

---

### [01:24:20] Gaurav Misra

**English:**
Yep.

**中文翻译:**
是的。

---

### [01:24:20] Lenny Rachitsky

**English:**
Amazing. Gaurav, this was incredible. It was so insightful on so many levels. Two final questions. Where can folks find you and what you're building if they want to learn more? And then how can listeners be useful to you?

**中文翻译:**
太棒了。Gaurav，这番谈话太精彩了，在很多层面上都非常有见地。最后两个问题：如果大家想了解更多，可以在哪里找到你和你正在构建的产品？以及，听众可以为你提供什么帮助？

---

### [01:24:30] Gaurav Misra

**English:**
Awesome. Yeah, I mean, definitely find me on LinkedIn. That's where I live most of the time. My DMs are open, et cetera, et cetera. So feel free to send me a message. And I think what'll be useful, I mean, we're building out our early product and design team, so if AI video is interesting, if consumer apps are interesting, now's the time to join. We're really small, early, we work together across the team, so there's going to be no better time to join, basically.

**中文翻译:**
太好了。大家可以在 LinkedIn 上找到我，我大部分时间都在那里。我的私信是开放的，欢迎给我发消息。至于有用的帮助，我们正在组建早期的产品和设计团队。所以，如果你对 AI 视频感兴趣，对消费级应用感兴趣，现在正是加入的好时机。我们规模很小，处于早期阶段，全团队紧密协作。基本上，没有比现在更好的加入时机了。

---

### [01:25:01] Lenny Rachitsky

**English:**
And you get to ship a marketable feature every week.

**中文翻译:**
而且你每周都能发布一个可营销的功能。

---

### [01:25:03] Gaurav Misra

**English:**
Exactly. I mean, that's the PM's dream. Think about it. Right?

**中文翻译:**
没错。我是说，那是 PM 的梦想，想想看，对吧？

---

### [01:25:06] Lenny Rachitsky

**English:**
The PM's dream. Yeah, I like that that's a filter. The people that get excited about that, great fit. The people that are stressed out by that, not the place to be.

**中文翻译:**
PM 的梦想。是的，我喜欢这个过滤器。对此感到兴奋的人是绝佳人选；对此感到压力巨大的人则不适合这里。

---

### [01:25:15] Gaurav Misra

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:25:17] Lenny Rachitsky

**English:**
So awesome. All right. Gaurav, thank you so much for being here.

**中文翻译:**
太棒了。好，Gaurav，非常感谢你的到来。

---

### [01:25:20] Gaurav Misra

**English:**
No, thank you. Appreciate it.

**中文翻译:**
不，谢谢你。非常感谢。

---

### [01:25:22] Lenny Rachitsky

**English:**
Bye everyone.
(01:25:25):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。
(01:25:25):
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。