# Geoffrey Moore - 双语对照

# Lenny's Podcast: Geoffrey Moore - Crossing the Chasm and Go-to-Market Playbooks
## 嘉宾：Geoffrey Moore（《跨越鸿沟》作者）

---

### [00:00:00] Geoffrey Moore

**English:**
The tendency when you're in the chasm is, "I just need more customers. I should take any customer I could find," because we need revenue. It's like taking a match and running it back and forth under a log. It's not going to light the log. So how do you start a fire? Well, you start it by putting a little kindling, little crumpled up paper, and you hold the match in one place until the fire starts. That's why adjacency is so important. If you light the fire, the piece of kindling is here, but the log is in the other room. That doesn't work.

**中文翻译:**
当你处于“鸿沟”阶段时，往往会有一种倾向，觉得“我只需要更多客户，我应该抓住任何能找到的客户”，因为我们需要收入。但这就像拿着一根火柴在一根大木头下面来回晃动，它是点不燃木头的。那么你该如何生火呢？你应该先放一些引火物，比如揉皱的小纸片，然后把火柴固定在一个地方，直到火烧起来。这就是为什么“相邻性”（adjacency）如此重要。如果你点燃了火，引火物在这儿，但木头却在另一个房间，那是行不通的。

---

### [00:00:32] Lenny

**English:**
Today, my guest is Geoffrey Moore. Geoffrey is the author of maybe the most influential and important book on go-to-market ever written, Crossing the Chasm. Even though it's sold over a million copies, it still feels like people continue to reinvent many of the lessons that Geoffrey uncovered and shared in a seminal book. In our conversation, we discuss why it's so important to get very narrow with your initial audience, how the bowling pin strategy helps you get past early adopters, what the specific go-to-market playbook is for every stage of the adoption lifecycle, why using the wrong playbook during the wrong phase will slow you down. Also, the seven deadly sins of trying to cross the chasm incorrectly. Also, how to sell your product at different personas, why you don't need to focus on the problem and the pain when you're selling to early adopters, plus some real good life advice that I didn't expect.

**中文翻译:**
今天的嘉宾是 Geoffrey Moore。Geoffrey 可能是史上最有影响力和最重要的市场进入（Go-to-market）书籍——《跨越鸿沟》（Crossing the Chasm）的作者。尽管这本书已经卖出了超过一百万册，但感觉人们仍在不断地重新发明 Geoffrey 在这本开创性著作中揭示并分享的许多教训。在我们的对话中，我们讨论了为什么锁定极窄的初始受众如此重要、保龄球瓶策略如何帮助你超越早期采用者、技术采用生命周期每个阶段的具体市场进入手册，以及为什么在错误的阶段使用错误的手册会拖慢你的进度。此外，我们还讨论了错误尝试跨越鸿沟的“七宗罪”、如何针对不同的人群画像销售产品、为什么在向早期采用者销售时不需要关注问题和痛苦，以及一些我没预料到的非常棒的人生建议。

---

### [00:01:22] Lenny

**English:**
Geoffrey has so much wisdom to share if you're building a B2B company, and I'm really excited to bring you this episode. With that, I bring you Geoffrey Moore after a short word from our sponsors.

**中文翻译:**
如果你正在创办一家 B2B 公司，Geoffrey 有太多的智慧可以分享，我非常激动能为大家带来这一集。在听完赞助商的简短介绍后，让我们欢迎 Geoffrey Moore。

---

### [00:01:34] Lenny (Sponsor: CommandBar)

**English:**
Let me tell you about CommandBar. If you're like me and most users I've built product for, you probably find those little in-product pop-ups really annoying. Want to take a tour? Check out this new feature, and these pop-ups are becoming less and less effective since most users don't read what they say. They just want to close them as soon as possible, but every product builder knows that users need help to learn the ins and outs of your product. We use so many products every day, and we can't possibly know the ins and outs of everyone. CommandBar is an AI-powered toolkit for product, growth, marketing, and customer teams to help users get the most out of your product without annoying them.

**中文翻译:**
让我向你介绍一下 CommandBar。如果你像我以及我曾为其开发产品的多数用户一样，你可能会觉得产品内部的那些小弹窗非常烦人。“想参观一下吗？”“看看这个新功能”，这些弹窗正变得越来越无效，因为大多数用户根本不看内容，只想尽快关掉它们。但每个产品开发者都知道，用户需要帮助来了解产品的细节。我们每天使用这么多产品，不可能了解每一个产品的方方面面。CommandBar 是一个由 AI 驱动的工具包，适用于产品、增长、营销和客户团队，旨在帮助用户充分利用你的产品，同时不让他们感到厌烦。

---

### [00:02:08] Lenny (Sponsor: CommandBar)

**English:**
They use AI to get closer to user intent, so they have search and chat products that let users describe what they're trying to do in their own words, and then see personalized results like customer walkthroughs or actions. They do popups too, but their nudges are based on in-product behaviors like confusion or intent classification, which makes them much less annoying and much more impactful. This works for web apps, mobile apps, and websites, and they work with industry leading companies like Gusto, Freshworks, HashiCorp, and LaunchDarkly. Over 15 million end users have interacted with CommandBar. To try out CommandBar, you can sign up at commandbar.com/lenny, and you can unlock an extra 1,000 AI responses per month for any plan. That's commandbar.com/lenny.

**中文翻译:**
他们利用 AI 来更贴近用户意图，因此他们拥有搜索和聊天产品，让用户可以用自己的语言描述他们想做的事情，然后看到个性化的结果，如客户引导或操作建议。他们也做弹窗，但他们的“微调提示”（nudges）是基于产品内行为的，比如用户表现出的困惑或意图分类，这使得它们不那么烦人且更具影响力。这适用于 Web 应用、移动应用和网站，他们与 Gusto、Freshworks、HashiCorp 和 LaunchDarkly 等行业领先公司合作。超过 1500 万终端用户曾与 CommandBar 互动。要试用 CommandBar，你可以访问 commandbar.com/lenny 注册，任何方案都可以每月额外解锁 1000 条 AI 回复。网址是 commandbar.com/lenny。

---

### [00:02:56] Lenny (Sponsor: WorkOS)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point, your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features, and hundreds of other companies are already powered by WorkOS, including ones you probably know, like Vercel, Webflow, and Loom. WorkOS also recently launched AuthKit, a complete authentication and user management service. It's essentially a modern alternative to Auth0, but with better pricing and more flexible APIs.

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建一个 SaaS 应用，在某个阶段，你的客户会开始要求企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让你快速、无痛地为应用添加企业级功能。他们的 API 易于理解，让你可以快速交付并重新投入到其他功能的开发中。数百家公司已经由 WorkOS 提供支持，包括你可能熟悉的 Vercel、Webflow 和 Loom。WorkOS 最近还推出了 AuthKit，这是一个完整的身份验证和用户管理服务。它本质上是 Auth0 的现代替代方案，但价格更优，API 更灵活。

---

### [00:03:38] Lenny (Sponsor: WorkOS)

**English:**
AuthKit's design is stunning out of the box, and you can also fully customize it to fit your app's brand. It's an effortless experience from your first user all the way to your largest enterprise customer. Best of all, AuthKit is free for any developer up to 1 million users. Check it out at workos.com to learn more. That's workos.com.

**中文翻译:**
AuthKit 的设计开箱即用，非常精美，你也可以完全自定义它以符合你的应用品牌。从你的第一个用户到最大的企业客户，它都能提供轻松的体验。最棒的是，AuthKit 对任何开发者都是免费的，支持多达 100 万用户。访问 workos.com 了解更多信息。

---

### [00:04:03] Lenny

**English:**
Geoffrey Moore, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
Geoffrey Moore，非常感谢你能来到这里，欢迎来到本播客。

---

### [00:04:07] Geoffrey Moore

**English:**
Well, it's nice to be here, Lenny, and thank you for having me.

**中文翻译:**
很高兴来到这里，Lenny，谢谢你的邀请。

---

### [00:04:09] Lenny

**English:**
It's incredibly cool to have you on. You've been at the top of my wishlist of guests to have on this podcast ever since I launched it, so it's surreal to be chatting with you. It almost feels like maybe this podcast has crossed the chasm now that you're on.

**中文翻译:**
能请到你真是太酷了。自从我创办这个播客以来，你一直是我最想邀请的嘉宾名单之首，所以能和你聊天感觉很不真实。感觉既然你来了，这个播客也许已经“跨越鸿沟”了。

---

### [00:04:22] Geoffrey Moore

**English:**
If you'd called me earlier, I probably would've been on it with you. But anyway, we're together now.

**中文翻译:**
如果你早点打电话给我，我可能早就来了。不过没关系，我们现在聚在一起了。

---

### [00:04:27] Lenny

**English:**
I thought it'd be fun to start with this question of just what frustrates you most about what people still don't get about the things that you teach, particularly Crossing the Chasm. You wrote that, I think, 33 years ago at this point. You have a lot of follow-up books around the topic. What do you think people still don't really understand or often get wrong?

**中文翻译:**
我想先问一个有趣的问题：对于人们至今仍不理解你所教授的内容（尤其是《跨越鸿沟》），最让你感到沮丧的是什么？那本书是你大约 33 年前写的，之后你还围绕这个主题写了很多后续书籍。你认为人们至今仍不真正理解或经常搞错的是什么？

---

### [00:04:45] Geoffrey Moore

**English:**
All the books I write are about frameworks. They're conceptual models about what patterns should you be looking for as something evolves? Because in disruptive innovation, there's no history. You're always projecting a possible history, and then seeing if you can make it come true. So that implies there's a lot of freedom to exercise the framework however you choose to. People sometimes do that in ways that are just... They actually end up being very misleading about what's possible. I can remember one person early on saying, "Yeah, we're Crossing the Chasm. Our beachhead segments the Fortune 500," and you went, "Well, I don't think maybe you're as clear on this as you could be."

**中文翻译:**
我写的书都是关于框架的。它们是关于事物演变过程中你应该寻找什么模式的概念模型。因为在颠覆性创新中，没有历史可循。你总是在预测一种可能的历史，然后看你是否能让它成真。这意味着你可以根据自己的选择自由地运用这些框架。但人们有时运用的方式……最终会对“什么是可能的”产生极大的误导。我记得早期有人说：“是的，我们正在跨越鸿沟。我们的滩头阵地（beachhead）是财富 500 强。” 我当时就想：“嗯，我觉得你对这个概念的理解可能还不够清晰。”

---

### [00:05:32] Geoffrey Moore

**English:**
To be fair, that's what the function of any third party advisor is, is to say, "Look, time out. You might be looking at this through an inside-out lens. Maybe you should be looking at it from an outside-in lens." That's probably number one. Gosh, after that, I'm just empathetic with the fact that their world's more important than my world, so I try to work with their world.

**中文翻译:**
公平地说，任何第三方顾问的功能就是说：“嘿，暂停一下。你可能是在用‘由内而外’的视角看问题，也许你应该尝试‘由外而内’的视角。” 这可能是第一点。天哪，除此之外，我只是很同情这样一个事实：他们的世界比我的世界更重要，所以我尽量配合他们的世界。

---

### [00:05:59] Lenny

**English:**
That's exactly where I actually wanted to go next is this idea of starting very focused with your initial target audience. I think people conceptually know this. They're like, "Yeah, we should be really focused with our initial target market. We should stay very small, and expand this beachhead idea." But I think they still don't quite actually do this because it's like, "Why not go wider?" So could you just talk about why that is so important, and how to actually think about how to do that correctly?

**中文翻译:**
这正是我接下来想探讨的：关于在初始目标受众上保持高度专注的想法。我认为人们在概念上是知道这一点的，他们会说：“是的，我们应该非常专注于初始目标市场，应该保持很小的规模，并扩大这个滩头阵地的概念。” 但我认为他们实际上并没有做到，因为他们会想：“为什么不做得更宽泛一点呢？” 所以，你能谈谈为什么专注如此重要，以及如何正确地思考和执行吗？

---

### [00:06:23] Geoffrey Moore

**English:**
If you're essentially in a business where the category is emerging, then the most important thing for you to do is to be able to create enough power around your company that you can navigate your future on your own power. Where does power come from in an early adopting technology world? First of all, it'll come from can you get a lighthouse customer? So one of the things we try to do even before you try to cross the chasm is can you get one or more customers who put you on the map? And they go, "Whoa, did you know that the CIA used AWS?" Like, "Holy smoke." Okay, that's great. It doesn't make a company, but it makes a story, and it lets people know, "Oh, here are the guys that did the CIA project," that kind of thing.

**中文翻译:**
如果你处于一个新兴品类的行业中，那么对你来说最重要的事情就是围绕你的公司创造足够的能量，以便你能依靠自己的力量掌控未来。在早期技术采用的世界里，能量从何而来？首先，它来自于你是否能获得一个“灯塔客户”（lighthouse customer）。所以，在我们尝试跨越鸿沟之前，我们要做的就是：你能不能获得一个或多个能让你声名鹊起的客户？人们会惊叹：“哇，你知道 CIA 也在用 AWS 吗？” 就像，“天哪！” 好吧，这虽然不能成就一家公司，但它成就了一个故事，让人们知道：“哦，就是这帮人做了 CIA 的项目。”

---

### [00:07:09] Geoffrey Moore

**English:**
The Crossing the Chasm model is, "Can you create a viable repeatable business?" And in order to do that, you need to have an ecosystem of partners work with you in order to consolidate your position. Well, why would an ecosystem work with some startup that nobody's ever heard of? The answer would be if you had consolidated a market segment where you were number one. So one of the things we've learned about company power is that basically it's the company power plus the ecosystem together. So ecosystems form around market leaders, and they do not form around the rest of us. If you're a category leader, if you're like Oracle and Databases, you're 40 years in. You're still the leader, because the ecosystem organized around you.

**中文翻译:**
《跨越鸿沟》模型的核心是：“你能否创造一个可行且可复制的业务？” 为了做到这一点，你需要有一个合作伙伴生态系统与你合作，以巩固你的地位。那么，为什么一个生态系统会愿意与一家闻所未闻的初创公司合作呢？答案是：如果你已经巩固了一个细分市场，并在那里做到了第一。关于公司能量，我们学到的一点是，它基本上是公司能量加上生态系统的总和。生态系统是围绕市场领导者形成的，而不是围绕我们这些普通公司。如果你是品类领导者，比如 Oracle 在数据库领域，即便 40 年过去了，你依然是领导者，因为生态系统是围绕你组织的。

---

### [00:07:51] Geoffrey Moore

**English:**
But when you're little, the only way you can get an ecosystem to organize around you is to go after a segment where you're a big fish in that pond. We talk a lot about fish to pond ratio. You want to be... Your first pond, your target segment should be something that in the next two years, if you hit your really high growth rates, you could be 30, 40, 50% of the market share in that segment. That would cause partners to go, "Whoa, if we're going to serve that segment, we got to work with these guys." So that's the key. The concept there is, "Well, why wouldn't you also do two or three or four segments at the same time?" It's sort of the same reason, "Why wouldn't you run in three or four primaries at the same time if you want the presidential nomination?" Although why you would want that nomination, I have no idea.

**中文翻译:**
但当你还很弱小时，让生态系统围绕你组织的唯一方法，就是去攻占一个你能成为“池塘里的大鱼”的细分市场。我们经常谈论“鱼塘比例”（fish to pond ratio）。你的第一个池塘，即你的目标细分市场，应该是这样一个地方：在接下来的两年里，如果你达到了极高的增长率，你就能占据该细分市场 30%、40% 甚至 50% 的份额。这会让合作伙伴觉得：“哇，如果我们想服务这个细分市场，我们就必须和这帮人合作。” 这就是关键。这里的概念是：“为什么不同时做两三个或四个细分市场呢？” 这有点像：“如果你想获得总统提名，为什么不同时参加三四个州的初选？” 尽管我不知道你为什么会想要那个提名。

---

### [00:08:39] Geoffrey Moore

**English:**
But if you did, you realize if you're running in New Hampshire, votes in Vermont do not count. It's the same thing with Crossing the Chasm. You need to get three or four or five or six reputable companies in a segment to all pick you, for then the rest of the segment to go, "Well, it's pretty obvious who the standard is." I'll just close with one last comment. And the reason, the mechanism behind all that logic, is that pragmatic people buy what they see their peers are buying. So if peer one is buying product A, and peer two is B and C and D, there's no market leader, and the category goes sideways. But if A, B and C, if three out of four people are using the iPhone, it's like, "Oh, I guess I'm supposed to get an iPhone," that kind of thing.

**中文翻译:**
但如果你真的这么做了，你会意识到如果你在纽罕布什尔州竞选，佛蒙特州的选票是不算数的。跨越鸿沟也是一样。你需要让一个细分市场中的三四五六家知名公司都选择你，这样该细分市场的其他人就会觉得：“显然，谁才是标准已经很清楚了。” 我最后再补充一点，所有这些逻辑背后的机制是：实用主义者会购买他们看到同伴正在购买的东西。如果同伴 A 买产品 A，同伴 B、C、D 买的是 B、C、D，那么就没有市场领导者，这个品类就会停滞不前。但如果 A、B、C 三个人里有三个都在用 iPhone，你就会觉得：“哦，我想我也该买部 iPhone 了。”

---

### [00:09:29] Lenny

**English:**
Awesome. I'm glad you went there, because that's essentially the root of this Crossing the Chasm idea that people after the chasm, the pragmatists, wait for references and social proof, and they're waiting for someone to tell them, "This is worth using," versus visionaries right before the chasm. They're like, "I just want to use the future. I need to be there before anyone else."

**中文翻译:**
太棒了。我很高兴你谈到了这一点，因为这本质上就是《跨越鸿沟》理念的根源：鸿沟之后的人，即实用主义者，会等待推荐和社交证明，他们等着别人告诉他们“这值得使用”；而鸿沟之前的远见者（visionaries）则不同，他们会觉得：“我只想使用未来的东西，我必须比任何人都先到那里。”

---

### [00:09:49] Geoffrey Moore

**English:**
You're right. One of the ways we try to capture that in a thought bubble is before the chasm, the customers you work with are people who say, "We believe what you believe." So in other words, they're on the same side. After the chasm, they say, "I'm not sure about that, but we need what you have." So transitioning from, "We believe what you believe," which is how you sell to visionaries to, "We need what you have," which is how you sell to pragmatists. That's the shift.

**中文翻译:**
没错。我们试图用一句话来概括：在鸿沟之前，你合作的客户是那些说“我们相信你所相信的”的人。换句话说，他们和你站在同一边。而在鸿沟之后，他们会说：“我不确定那个（愿景），但我们需要你拥有的东西。” 所以，从“我们相信你所相信的”（向远见者销售的方式）转变为“我们需要你拥有的东西”（向实用主义者销售的方式），这就是转变。

---

### [00:10:17] Lenny

**English:**
Let's actually spend some more time there on what it is that each of these segments needs, and how you convince them to use it, because this is really useful. So in these pragmatists group, you're saying the pitch there is you have a pain. I will solve this pain, and it's important pain. I think people always assume that's the pitch. But interestingly, your point is earlier in the two segments and maybe share what those two are, they use your product for a different reason.

**中文翻译:**
让我们多花点时间讨论一下这些细分市场各自的需求，以及你如何说服他们使用你的产品，因为这非常有用。在实用主义者群体中，你说销售话术是“你有痛苦，我会解决这个痛苦，而且这是一个重要的痛苦”。我想人们总以为这就是通用的销售话术。但有趣的是，你的观点是，在更早的两个细分市场中（也许你可以分享一下是哪两个），他们使用你的产品是出于不同的原因。

---

### [00:10:41] Geoffrey Moore

**English:**
In fact, if there's a total in the model of the technology adoption lifecycle that we organize this all around, there's actually four, I call them, inflection points. The first one we call the early market. That's the one we were talking... That's the visionaries and the technology enthusiasts. They are as excited about you as you are. I mean, they want the demo. They want to see the vision. They're exciting. And the key to that market is to have an executive sponsor who has enough clout to essentially fund this thing, because there's no budget for you. So they've got to create the funding, and then drive the organization to go all the way to bright.

**中文翻译:**
事实上，在我们围绕其组织的整个技术采用生命周期模型中，实际上有四个我称之为“拐点”的阶段。第一个我们称之为“早期市场”。这就是我们刚才谈到的……远见者和技术爱好者。他们和你一样对你的产品感到兴奋。我是说，他们想看演示，想看愿景，他们很令人兴奋。这个市场的关键是找到一个拥有足够影响力、能为这件事提供资金的高管赞助人，因为当时还没有针对你的预算。所以他们必须创造资金，然后推动组织全力以赴。

---

### [00:11:21] Geoffrey Moore

**English:**
They're not that many visionary customers, but there's always one or two. The reason why it's so important to work with a marquee customer then is you... Look, nobody's ever heard of you, and if they've never heard of your customer, I don't care how amazing the win is. Nobody's going to hear about it. So it's really important you did it with Apple, or you did it with Verizon, or you did it with Mercedes, somebody that people have heard. So that's number one, and that's a project model. Even if what you sell is a product, those early mark... Every one of them is kind of a snowflake. It needs a ton of special services. There's no ecosystem of partners to support you, so you throw a bunch of extra labor at it. You do whatever, because you got to make them successful. So you'll do whatever it takes.

**中文翻译:**
远见型客户并不多，但总会有一两个。那时与明星客户合作之所以如此重要，是因为……听着，没人听说过你，如果他们也没听说过你的客户，那么无论你的胜利多么惊人，都没人会知道。所以，如果你是和苹果、Verizon 或梅赛德斯这样家喻户晓的公司合作，那就非常重要。这是第一点，这是一种“项目模式”。即使你卖的是产品，那些早期市场……每一个客户都像雪花一样独特。它需要大量的特殊服务。没有合作伙伴生态系统来支持你，所以你得投入大量额外的人力。你得不惜一切代价，因为你必须让他们成功。

---

### [00:12:13] Geoffrey Moore

**English:**
Okay, very cool. Got my marquee client, not scalable business, I mean, obviously. So then the second one is the Crossing the Chasm playbook. That's the one that organizes around the problem. The good news is those customers are open to hearing from someone new, because they've already talked to everybody they already know, and the problem is still... It's not that it's unsolved. It's being solved in a crummy way and, by the way, in a deteriorating crummy way. So it's getting actually worse. So there's pressure for them to act. This is where you go from the project model to the solution model, and as a vendor, you over commit to their problem.

**中文翻译:**
好，非常酷。有了明星客户，但业务不可扩展，显然如此。接着第二个阶段就是“跨越鸿沟”手册。这一阶段是围绕“问题”组织的。好消息是，这些客户愿意听取新人的意见，因为他们已经和所有认识的人谈过了，但问题依然……不是说没解决，而是解决方式很糟糕，而且还在持续恶化。所以他们有采取行动的压力。这就是你从“项目模式”转向“解决方案模式”的地方，作为供应商，你要对他们的问题做出过度承诺。

---

### [00:12:54] Geoffrey Moore

**English:**
From the very beginning, you talk to them. They don't want to talk to you about you. They want to talk to you about them, and you need to ask them probing questions about them. Just like going to a doctor, you don't want the doctor to come and say, "Hey, can I show you a movie of the operation I just did? I want to give you a demo. You mind if I give you a demo?" It's like, "No. What I would like to do is talk to you about this pain I have in my side." And then when the doctor asks you good questions about it, you go, "Ah, this is a good doctor. I'm going to trust this." So that's the whole point about that. Again, that scales a lot more than a project business, but it only scales up to the limit of the target segment.

**中文翻译:**
从一开始，你就和他们交谈。他们不想听你谈论你自己，他们想让你谈论他们，你需要向他们提出关于他们的探索性问题。就像去看医生，你不想医生一上来就说：“嘿，我能给你看一段我刚做的手术视频吗？我想给你做个演示，你介意吗？” 你会说：“不，我想和你谈谈我侧腹的疼痛。” 当医生针对疼痛提出好的问题时，你会觉得：“啊，这是一个好医生，我可以信任他。” 这就是关键所在。同样，这比项目业务更具扩展性，但它也仅限于目标细分市场的范围。

---

### [00:13:31] Geoffrey Moore

**English:**
So we had this bowling alley model of extending. You could go to a second segment, a third segment if it was adjacent. Adjacent means either it's the same customer with a different use case, or it's the same use case in a different customer base, because the one case, you use your customer references. The other case, you use your partners, because the partners who built the one use case will say, "Well, we got another segment that we work with. Let's bring you into that segment too." So that can take a company from, I don't know, tens of millions of dollars to hundreds of millions of dollars in the bowling alley. And in specialized industries like computer-rated design or things like that, you can actually go to a billion dollars or higher.

**中文翻译:**
所以我们有了这个“保龄球道”扩展模型。如果细分市场是相邻的，你可以进入第二个、第三个细分市场。“相邻”意味着要么是同一个客户有不同的用例，要么是同一个用例在不同的客户群中。因为在前一种情况下，你可以利用客户推荐；在后一种情况下，你可以利用合作伙伴，因为建立了一个用例的合作伙伴会说：“嘿，我们还有另一个合作的细分市场，让我们也把你带进那个市场吧。” 这样，在保龄球道阶段，公司可以从几千万美元增长到几亿美元。在计算机辅助设计等专业行业，甚至可以达到十亿美元或更高。

---

### [00:14:13] Geoffrey Moore

**English:**
But with most other categories, at some point, you have this third inflection point, which is it's when people go, "Well, wait a minute, wifi isn't just for financial analysts, or isn't just for... Wifi is for everybody." So instead of saying, "We believe what you believe," which we're not there anymore. And these people aren't even really saying, "We need what you have." What they're saying is, "We want what they have. This is really cool. I want what they have," and that creates what we call the tornado. That's when people... This is when you do want sales coverage, and you do want to go broad, and you do want to have a standard product. Basically, you want to capture as much market share as you can. There's a whole playbook around doing that, which was in a book called Inside the Tornado.

**中文翻译:**
但对于大多数其他品类，在某个时刻，你会遇到第三个拐点，那就是人们开始意识到：“等等，WiFi 不仅仅是给金融分析师用的，WiFi 是给每个人用的。” 这时，你不再说“我们相信你所相信的”，那些人甚至也不再说“我们需要你拥有的东西”。他们说的是：“我们想要他们拥有的东西。这太酷了，我也要。” 这就创造了我们所说的“龙卷风”（tornado）。这时你确实需要销售覆盖，需要走得更宽，需要有标准化的产品。基本上，你想尽可能多地占领市场份额。关于如何做到这一点，有一整套手册，就在一本叫《龙卷风暴》（Inside the Tornado）的书里。

---

### [00:15:02] Geoffrey Moore

**English:**
And then the last one, which is actually becoming much more important in this century is called Main Street, but Main Street where products have become commoditized, services become the new place of innovation. We've had taxis for 100 years, but Uber is an incredibly valuable thing. You convert the product to the service, and how do you revolutionize services? That's a situation where now people are saying, "Look, I don't want to own the product. I don't want to own it." Well, kids, "I don't want to own a car. I just want to call Uber. It's convenient." So anyway, those are the four models, and Crossing the Chasm was about that second one.

**中文翻译:**
最后一个阶段，在本世纪变得越来越重要，被称为“主街”（Main Street）。在主街阶段，产品已经商品化，服务成为创新的新阵地。出租车已经存在 100 年了，但 Uber 是一个极具价值的东西。你将产品转化为服务，你如何彻底改变服务？在这种情况下，人们会说：“听着，我不想拥有这个产品。” 就像现在的孩子会说：“我不想拥有一辆车，我只想叫 Uber，这很方便。” 总之，这就是那四个模型，而《跨越鸿沟》讲的是第二个。

---

### [00:15:45] Lenny

**English:**
Amazing. You touched on so many things that I want to talk about. I definitely want to dive into the bowling alley metaphor and strategy there. But to close the loop on this target audience to start with initially. First of all, you have this awesome bonfire analogy that I think might be useful to share. Then along that, is there any example or an example or two you could share of just someone that did that really well of picking a really good initial target?

**中文翻译:**
太棒了。你提到了很多我想聊的话题。我肯定想深入探讨保龄球道的比喻和策略。但在那之前，先完成关于初始目标受众的讨论。首先，你有一个很棒的“篝火”类比，我觉得分享一下会很有用。此外，你能不能分享一两个例子，说明谁在选择初始目标方面做得非常好？

---

### [00:16:08] Geoffrey Moore

**English:**
Sure. Well, the bonfire analogy is just the tendency when you're in the chasm is, "I just need more customers. I should take any customer I could find." Because we need revenue, but the analogy I have is it's like taking a match, and running it back and forth under a log. It's not going to light the log. So how do you start a fire? Well, you start it by putting a little kindling, a little crumpled up paper, and you hold the match one place until the fire starts. Then you want to build... The bowling alley metaphor is a little bit about, first of all, how could you win your first segment, but then increasingly, how would you go forward to win it? That's why adjacency is so important. If you like the fire and the piece of kindling is here, but the log is in the other room, that doesn't work. So I think those are the key ideas.

**中文翻译:**
当然。篝火类比是指当你处于鸿沟中时，往往会有这种倾向：“我只需要更多客户，我应该抓住任何能找到的客户。” 因为我们需要收入。但我的类比是，这就像拿着一根火柴在一根大木头下面来回晃动，它是点不燃木头的。那么你该如何生火呢？你应该先放一些引火物，比如揉皱的小纸片，然后把火柴固定在一个地方，直到火烧起来。然后你想建立……保龄球道比喻首先是关于如何赢得你的第一个细分市场，然后是如何逐步推进去赢得它。这就是为什么“相邻性”如此重要。如果你点燃了火，引火物在这儿，但木头却在另一个房间，那是行不通的。我认为这些是核心思想。

---

### [00:16:59] Geoffrey Moore

**English:**
There's a lot of people that have made Crossing the Chasm successful. The one that we wrote about first was this company called Documentum, and it's a good example. So it was a document management database back in the day that was not... that nobody had any, "Why would you need this?" It started with the pharmaceutical industry, because pharma said, "Well, new drug approvals are 500,000 page documents, and they really, really, really are hard to manage, and we're screwing it up. And every day we screw it up, we lose a day of patent life of our drug, and the day of patent life's worth about a million or $2 million a day. This is a bad situation. We need to do something."

**中文翻译:**
有很多成功跨越鸿沟的案例。我们最早写到的是一家叫 Documentum 的公司，这是一个很好的例子。当时它是一个文档管理数据库，没人觉得“为什么需要这个？” 它从制药行业开始，因为制药公司说：“新药审批文件有 50 万页，管理起来真的非常非常困难，我们搞得一团糟。我们每耽误一天，新药的专利期就减少一天，而一天的专利期价值大约 100 万或 200 万美元。情况很糟糕，我们必须做点什么。”

---

### [00:17:37] Geoffrey Moore

**English:**
So "Okay, pharma, you got pharma." Great. Well, then what happened was the guys in petrochemicals said, "Well, we're in the chemical industry. We're not in the pharmaceutical industry, but we have these standard operating manuals, and we have all these regulatory demands on us too. Not quite like the FDA, but this looks like this could be pretty useful to us too." And then after the petrochemicals guys got... Well, the chemical guys got it, then the petrochemical guys got it. Of course, they're oil and gas, and they say, "Well, in addition, we have all these leases. The lease holds them. It's brilliant. This property is critical to our future plan, so we need a document database for the leases."

**中文翻译:**
所以，“好吧，制药行业，你拿下了制药行业。” 太棒了。接着发生的是，石化行业的人说：“我们是在化工行业，不是制药行业，但我们也有这些标准操作手册，我们也面临各种监管要求。虽然不像 FDA 那么严格，但这看起来对我们也很有用。” 在化工行业的人采用后，石化行业的人也采用了。当然，他们是石油和天然气行业，他们说：“此外，我们还有所有这些租赁合同。租赁合同对我们至关重要，这处房产对我们的未来计划很关键，所以我们需要一个租赁合同的文档数据库。”

---

### [00:18:20] Geoffrey Moore

**English:**
So the guys on Wall Street who are financing these guys are going, "Well, wait a minute. Hell, I mean, we're paper from wall to wall here. Why don't we..." So what happens is you have this thing of this expansion, but in each case, it was into a new segment, but the use cases were close enough.

**中文翻译:**
然后，为这些人提供融资的华尔街人士会想：“等等，天哪，我们这儿到处都是纸质文件。为什么我们不……” 于是，这种扩张就发生了。在每种情况下，都是进入一个新的细分市场，但用例足够接近。

---

### [00:18:36] Lenny

**English:**
So if a startup founder is listening and trying to decide is their initial target audience, their ICP too wide, do you have any advice for how to know if this is still too wide, and you should try to get more and more narrow? I know you talk about a single use case. What else should people be thinking about there?

**中文翻译:**
如果一位初创公司创始人正在听，并试图判断他们的初始目标受众（ICP）是否太宽泛，你有什么建议来判断是否仍然太宽泛，以及是否应该尝试变得越来越窄？我知道你谈到了单一用例，人们还应该考虑什么？

---

### [00:18:53] Geoffrey Moore

**English:**
Well, so first of all, before you try to cross the chasm, do you have a marquee? Have you won a marquee customer that puts you on the map? Because if you're not... You need to make yourself visible before you can make the Crossing the Chasm play. Let's assume you've done that. So then when we first saw, "Well, why don't I just use that industry?" Turns out that the visionary person you work with... First of all, they did some very weird things because they're visionaries and second of all, they don't want to help their industry. The whole point of this was they wanted to get ahead of their competitors. They didn't want to help. So normally you can't use the visionary project as your beachhead. You'd love to from a point of view of reusing the work. You just can't. So then the question becomes, "Okay, where am I going to go?"

**中文翻译:**
首先，在你尝试跨越鸿沟之前，你有没有一个明星客户？你有没有赢得一个能让你声名鹊起的明星客户？因为如果你不……在进行跨越鸿沟的行动之前，你需要让自己变得可见。假设你已经做到了。那么当我们最初想“为什么不直接用那个行业呢？”时，结果发现你合作的那个远见者……首先，他们做了一些非常奇怪的事情，因为他们是远见者；其次，他们并不想帮助他们的行业。这件事的全部意义在于他们想领先于竞争对手，而不是想提供帮助。所以通常你不能把远见者项目作为你的滩头阵地。从复用工作的角度来看，你很想这么做，但你就是做不到。所以问题变成了：“好吧，我该去哪儿？”

---

### [00:19:41] Geoffrey Moore

**English:**
So the key formula, and this is the formula... If there's one sort of takeaway from founders listening at this point, you want to have a target segment that is big enough to matter, small enough to lead and a good fit with your crown jewels. That's the formula. So big enough to matter means do I have enough room to double or... Often venture capitalists talk about a triple double followed by a double triple. So if you said, "Okay, let's just, I'm going to make you a million dollars." Put that visionary, but just to give you a number. Okay, so a double triple would be I went from one to four and from four to 12, and then I did a triple double. So that would be 12 to 24, 24 to 48, 48 to 90. Okay, so how would you get from one to a hundred million dollars?

**中文翻译:**
关键公式是——如果此时听众中的创始人只能带走一个东西，那就是：你想要一个“大到足以产生影响、小到足以取得领先，且与你的核心优势（crown jewels）高度契合”的目标细分市场。这就是公式。“大到足以产生影响”意味着我有足够的空间翻倍，或者……风险投资家经常谈论“三倍、三倍、两倍、两倍、两倍”（triple double followed by a double triple，指收入增长路径）。假设你现在有 100 万美元收入。一个“双三倍”意味着你从 100 万到 400 万，再到 1200 万，然后是“三双倍”，即 1200 万到 2400 万，2400 万到 4800 万，4800 万到 9000 万。好吧，你如何从 100 万增长到 1 亿美元？

---

### [00:20:31] Geoffrey Moore

**English:**
So you want to have a segment that says that I could get to a hundred million dollars in a five year... That was a five-year window. So you say, "Okay, but what it can't be is a billion dollar segment." Because if it's a billion dollar segment, you might be able to get there, but you would not be a big fish. So that's a fish to pond ratio thing. So you want to think about, particularly as you're starting out... This is a B2B model predominantly. If I could take the top 20 customers in this segment, meaning... What do I mean by a segment? It's in the same geography. People in Japan don't talk to people in America. People in America don't talk to people in Germany, they even speak different languages. I don't know why everybody doesn't speak English, but apparently they don't. So they have to be same geography, same industry, because dentists do not talk to software designers, who don't talk to advertising people and in the same profession.

**中文翻译:**
所以你想要一个能让你在五年窗口期内达到 1 亿美元收入的细分市场。但它不能是一个价值 10 亿美元的细分市场。因为如果是一个 10 亿美元的市场，你也许能达到那个收入，但你不会成为一条“大鱼”。这就是鱼塘比例的问题。所以你要考虑，特别是当你刚开始时……这主要是一个 B2B 模型。如果我能拿下这个细分市场的前 20 名客户，这意味着……我所说的细分市场是什么意思？它是指在同一个地理区域。日本的人不和美国的人交流，美国的人不和德国的人交流，他们甚至说不同的语言。我不知道为什么大家不都说英语，但显然他们不。所以必须是同一地理区域、同一行业，因为牙医不和软件设计师交流，软件设计师不和广告人交流，而且要在同一职业领域。

---

### [00:21:23] Geoffrey Moore

**English:**
So salespeople don't talk to finance people and finance people don't talk to the guys in the warehouse. So same industry, same geography, same profession. And then the compelling use case, which is the thing... That's the thing that starts the fire. There's segments everywhere and by the way, they all have that... They all do... Every segment works the same way. If I have to make a high risk buying decision, I'm going to talk to my peers about it. And I don't want to be first. I want to be able to do whatever the herd's doing. But what a compelling reason to buy does is it goes well, but I have to act faster than I want to. And that's what you need as an entrepreneur. You need the customer to be coming toward you even though you're new and you're unproven, and frankly you scare the crap out of them, but they're even more afraid of the problem that they're saddled with. So that's why you can build a relationship with them.

**中文翻译:**
销售人员不和财务人员交流，财务人员不和仓库里的人交流。所以要同一行业、同一地理区域、同一职业。然后是“迫切的用例”（compelling use case），这就是点火的东西。到处都有细分市场，顺便说一下，每个细分市场的运作方式都一样：如果我必须做一个高风险的购买决定，我会和我的同行商量。我不想做第一个，我想跟着羊群走。但一个“迫切的购买理由”所做的是，它让你觉得：“好吧，但我必须比我想象的更快采取行动。” 这就是你作为企业家所需要的。你需要客户主动向你走来，尽管你是新来的、未经证实的，坦率地说你让他们感到害怕，但他们更害怕自己背负的问题。这就是为什么你可以与他们建立关系。

---

### [00:22:19] Lenny

**English:**
Amazing. And this phase comes... You kind of imply it comes after, say you're at a million dollars AR, you don't do this sort of work of trying to cross the chasm at that point, until you reach something like that?

**中文翻译:**
太棒了。你似乎暗示这个阶段是在……比如当你达到 100 万美元 ARR（年度经常性收入）之后？在那之前你不会做这种尝试跨越鸿沟的工作，直到你达到那个水平？

---

### [00:22:31] Geoffrey Moore

**English:**
I'm not sure AR is going to be the right reference. Here's what you need. You need a major account who's gone all in with you on the new technology and who is willing in some way to talk about it. The good news about visionaries is they tend to have fairly big egos and they tend to like to talk, unlike pragmatists who will not want to talk. Pragmatists, they'll have to go to legal and get permission and blah, blah, blah. But once you've got that, whatever your revenue is at that point, you should be starting to think about, "Well, what is my beachhead segment?" And the good news about Crossing the Chasm, it's not expensive.

**中文翻译:**
我不确定 ARR 是否是正确的参考指标。你需要的是：一个愿意在这一新技术上与你全力以赴的大客户，并且愿意以某种方式谈论它。关于远见者的好消息是，他们通常有相当大的自我意识，而且喜欢表达，不像实用主义者那样不愿多谈。实用主义者必须去法务部获得许可等等。但一旦你拥有了那个（远见者客户），无论你当时的收入是多少，你都应该开始思考：“好吧，我的滩头阵地细分市场是什么？” 关于跨越鸿沟的好消息是，它并不昂贵。

---

### [00:23:12] Geoffrey Moore

**English:**
Think about it, once you've said, I'm going to stay in one geography, in one industry, one profession, think about your marketing budget. You're not buying Super Bowl ads here. There's no sock puppets. That's not what we're doing. We want to get to maybe 200 people with a message. And then do you have the domain expertise to really understand the problem? And if it's a really compelling problem, they'll take the meeting and getting that meeting is... Because if you're an entrepreneurial founder, you're probably fairly charismatic. First of all, you've convinced your spouse that you're willing to work for no money with no benefits, and maybe you pitched a venture capitalist and you fooled them, so why can't you fool these guys? Anyway, that would be the way I would go.

**中文翻译:**
想想看，一旦你决定留在同一个地理区域、同一个行业、同一个职业，想想你的营销预算。你不需要买超级碗广告，不需要搞那些花哨的噱头。我们只想把信息传达给大约 200 个人。然后，你是否有领域专业知识来真正理解这个问题？如果这是一个非常迫切的问题，他们会愿意和你见面，而获得那个见面的机会……因为如果你是一个创业创始人，你可能相当有魅力。首先，你已经说服了你的配偶，让你在没有薪水、没有福利的情况下工作；也许你还向风险投资家做了演示并“忽悠”了他们，那为什么不能“忽悠”这些客户呢？总之，这就是我会走的路。

---

### [00:24:02] Lenny

**English:**
Essentially, the advice here is if you're a new early stage startup, one of the biggest milestones you want to aim for is a big marquee customer. When I think about this and look at a startup deck, if I see something like Figma is using this product or notion or Salesforce. Clearly, I'll be like, "Wow, okay, these really sophisticated people decided this was useful to them." And so I will innately trust that. There's also often advice of don't work with big companies because they'll push you around, they'll take a long time, they'll force you to build a thing just for them and it won't apply to other people. What's your advice to avoid that downside?

**中文翻译:**
本质上，这里的建议是：如果你是一家新的早期初创公司，你想要瞄准的最大里程碑之一就是一个大的明星客户。当我看到一份初创公司的融资计划书，如果我看到像 Figma、Notion 或 Salesforce 正在使用这个产品，显然我会觉得：“哇，好吧，这些非常精明的人认为这对他们有用。” 所以我会本能地信任它。但通常也有建议说不要和大型公司合作，因为他们会欺负你，会耗费很长时间，会强迫你为他们量身定制一些东西，而这些东西对其他人并不适用。你有什么建议来避免这种负面影响吗？

---

### [00:24:37] Geoffrey Moore

**English:**
It has to do with the persona of the executive sponsor. Nine out of 10 executive sponsors are going to be the negative because they're going to be a company person working with company processes. They're going send you to purchasing, nobody's going to be happy. You're looking for the 10th one. The 10th one is one who says, "I'm so tired of the status quo. I'm looking for people that are visionary like me. I like talking to you better than I like talking to my peers because you're different and I want to be different. I want to leapfrog the world, and these people just want to stay on the escalator. So they're staying on the escalator. God bless them, but I want to jump over the top." So it's a persona based choice is the key thing there.

**中文翻译:**
这与高管赞助人的人格画像（persona）有关。十个高管赞助人里有九个会是负面的，因为他们是按公司流程办事的“公司人”。他们会把你推给采购部，没人会开心。你在找的是第十个。第十个人会说：“我厌倦了现状。我在寻找像我一样有远见的人。我更喜欢和你聊天，而不是和我的同行聊天，因为你很特别，我也想变得特别。我想实现跨越式发展，而那些人只想待在自动扶梯上。那就让他们待在扶梯上吧，上帝保佑他们，但我想要跳到顶端。” 所以，基于人格画像的选择是关键。

---

### [00:25:20] Lenny

**English:**
That is really interesting. And then say that you are an early stage startup again, how soon do you think it makes sense to invest in finding that big marquee customer versus finding some smaller... I imagine you start with some startups to see how people... You don't go straight there.

**中文翻译:**
这很有趣。再次假设你是一家早期初创公司，你认为什么时候开始投入精力寻找那个大的明星客户是合理的，而不是找一些小的……我猜你会先从一些初创公司开始，看看人们如何……你不会直接去找大客户。

---

### [00:25:36] Geoffrey Moore

**English:**
Yes, and so initially, I think... And of course you and I are both playing, let's be clear, we're playing a software game. For example, I was trying to apply this framework to Intel, and Intel said to me, "Geoffrey, you do understand that a prototype product in our industry costs about $500 million." Okay, okay, okay, okay. Maybe that's not the same model. I think in our world right now with digital transformation, most entrepreneurs are doing some software led play, which means you can work with a small team. So I think what I would advise is I would do projects. Even though I have a product vision, I would start with trying to make as much projects, which would be very customer led. And frankly, initially, even if I have a roadmap, the customer's probably going to take me off my roadmap a bit.

**中文翻译:**
是的，所以最初，我认为……当然，你和我都在玩——我们要明确——我们都在玩软件游戏。例如，我曾尝试将这个框架应用于英特尔，英特尔对我说：“Geoffrey，你应该明白，我们行业的一个原型产品成本大约是 5 亿美元。” 好吧，好吧，那可能不是同一个模型。我认为在当今数字化转型的世界里，大多数企业家都在做软件驱动的项目，这意味着你可以和一个小团队合作。所以我建议做“项目”。尽管我有产品愿景，但我会从尽可能多地做项目开始，这些项目将是非常以客户为导向的。坦率地说，最初即使我有路线图，客户也可能会让我稍微偏离路线图。

---

### [00:26:31] Geoffrey Moore

**English:**
I'd have to be willing to say, "I'm going to open the aperture enough." Because I just need to get enough experience with the technology. I need to put in people's hands. If it's a freemium play, you can do it for free. But that tends to be more of a consumer play. There are exceptions. There are B2B companies like Atlassian and things that did start as a freemium play, but that's not as normal. I would think more of the consultative play to do that. But what I would try to do, so I would try to get to cashflow break even on my own money with no venture capital. The only reason you need venture capital is if... Well, two things. Either A, the technology is too expensive and you cannot self-fund it, GPUs a bunch of that, training large language modules, those kinds of things. Or this thing is going to catch fire too soon and I don't have time to dither around for two or three years. So those are two reasons to go to venture capital, but just because you want to do a startup doesn't mean you need venture capital.

**中文翻译:**
我必须愿意说：“我要把光圈开得足够大。” 因为我只需要获得足够的技术经验。我需要把产品交到人们手中。如果是免费增值（freemium）模式，你可以免费提供。但这往往更像是消费者端的玩法。也有例外，像 Atlassian 这样的 B2B 公司确实是以免费增值模式起家的，但这并不常见。我会更多地考虑通过咨询式玩法来做到这一点。但我会尝试做的是，在没有风险投资的情况下，靠自己的钱实现现金流平衡。你需要风险投资的唯一原因是：要么 A，技术太贵，你无法自筹资金，比如 GPU、训练大语言模型之类的；要么 B，这件事很快就会火起来，我没有时间磨蹭两三年。这是寻求风险投资的两个原因，但仅仅因为你想创业并不意味着你一定需要风险投资。

---

### [00:27:35] Lenny

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point, your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features, and hundreds of other companies are already powered by WorkOS, including ones you probably know, like Vercel, Webflow, and Loom. WorkOS also recently launched AuthKit, a complete authentication and user management service. It's essentially a modern alternative to Auth0, but with better pricing and more flexible APIs.

**中文翻译:**
我们最近采访了 Basecamp 的 CEO Jason Fried，他也从多个角度提出了这一点。不融资的好处，以及大多数由风投支持的公司最终都失败了，即使成功了，你赚到的钱往往也不如你尝试自力更生（bootstrap）时赚得多。所以这引起了很多共鸣。你有一句名言，基本上就是你刚才说的：通过一轮融资，你应该能够在 18 到 24 个月内跨越鸿沟，并在单一市场中主导单一用例。

---

### [00:28:03] Geoffrey Moore

**English:**
Yeah. This is like an English major doing math, so be careful because I am an English major. But in general, because again, I said it's not expensive, and by the way, you're not discounting. In other words, you're actually using value pricing because the problem you're solving is severe enough, the customer doesn't want a discount, the customer wants you to... It is like if you have to have heart surgery, you don't want a coupon that says, "Heart surgery 9.99 this Saturday only." You want to go to the Mayo Clinic or you want to go to wherever, so you don't have to discount.

**中文翻译:**
是的。这就像一个英语专业的学生在做数学题，所以要小心，因为我确实是英语专业的。但总的来说，正如我所说，这并不昂贵，而且顺便说一下，你不需要打折。换句话说，你实际上是在使用“价值定价”，因为你解决的问题足够严重，客户不想要折扣，客户想要你……这就像如果你要做心脏手术，你不会想要一张写着“本周六心脏手术仅需 9.99 美元”的优惠券。你想去梅奥诊所或任何顶尖的地方，所以你不需要打折。

---

### [00:28:44] Geoffrey Moore

**English:**
What you do have to do is you have to make almost like a guaranteed commitment to the problem to solve. We're going to take this problem off the table and we're not leaving until you're satisfied. That's the key to the game. That's a little bit weird because if you've invented ChatGPT, and now you're saying, "But I am going to solve the third grade math problem," which is a real problem. But ChatGPT can do anything. I know, but we're going to solve the third grade math problem. That's hard for a lot of entrepreneurs to get their head around.

**中文翻译:**
你必须做的是，你必须对要解决的问题做出近乎保证的承诺。我们要彻底解决这个问题，在你满意之前我们不会离开。这就是游戏的关键。这有点奇怪，因为如果你发明了 ChatGPT，现在你说：“但我要去解决小学三年级的数学问题”，这是一个真实存在的问题。但 ChatGPT 什么都能做啊！我知道，但我们要解决的是三年级数学问题。这对很多企业家来说很难理解。

---

### [00:29:23] Lenny

**English:**
It reminds me of the way Figma started, even though it took them a long time to find product market fit and started scaling, they ended up working very closely with Coda. I don't know if you know the story where they just wanted to make sure the Coda team, and it was called Krypton back then was very happy with Figma. So they went to the office, they set them all up, they started using Figma. And then on the drive home they called him like, "It doesn't work anymore. Something's broken." And they were already home. And Dylan basically, and this team drove all the way back, I think it was an hour or two, and got there and turned out the Wi-Fi was down and there was some internet issue and fixed it and just was obsessed with making sure they were using it. And they're also just fixing the most ridiculous bugs that were not important because they just wanted to make sure they were really happy with it.

**中文翻译:**
这让我想起了 Figma 的起步方式。尽管他们花了很长时间才找到产品市场契合点（PMF）并开始规模化，但他们最终与 Coda 合作得非常紧密。我不知道你是否听过这个故事：他们当时只想确保 Coda 团队（当时叫 Krypton）对 Figma 非常满意。于是他们去了 Coda 的办公室，帮他们安装好一切，让他们开始使用 Figma。结果在回家的路上，Coda 打电话给他们说：“它不能用了，出故障了。” 当时他们已经到家了。Dylan 和他的团队基本上又一路开了回去，大概一两个小时的车程，到了那儿发现原来是 Wi-Fi 断了，是网络问题。他们修好了它，并且痴迷于确保对方在使用。他们甚至还修复了一些根本不重要的荒谬 Bug，只是为了确保对方真的开心。

---

### [00:30:11] Geoffrey Moore

**English:**
[inaudible 00:30:11] a larger company would say, "Look, we'll put you in our queue and you'll be on our... We'll get to you." I think this is... And by the way, this is part of the fun, frankly, of being in a startup because you're so close to the action, because there's nothing between you and the action. So why wouldn't you do that?

**中文翻译:**
一家大公司会说：“听着，我们会把你放进排队序列，我们会处理的。” 我认为这就是……顺便说一下，坦率地说，这就是在初创公司的乐趣所在，因为你离一线非常近，你和行动之间没有任何隔阂。所以为什么不那样做呢？

---

### [00:30:29] Lenny

**English:**
Yeah, and I think one of the takeaways I've had for my own research into this is that you need to find one company that just loves you. It's not like "[inaudible 00:30:37], this is cool." It's like, "I love this product. I would never want to give it up."

**中文翻译:**
是的，我认为我从自己的研究中得到的一个启示是：你需要找到一家真正爱你的公司。不是那种“这挺酷的”，而是“我爱这个产品，我永远不想放弃它”。

---

### [00:30:40] Geoffrey Moore

**English:**
That's kind of what I meant by that marquee ref... We sometimes we call it a radiating reference. It's just somebody really, we talk about you when you're not even in the room. Yeah, very cool.

**中文翻译:**
这就是我所说的明星推荐……我们有时称之为“辐射式推荐”（radiating reference）。就是那种即使你不在场，他们也会谈论你的人。是的，非常酷。

---

### [00:30:52] Lenny

**English:**
We've talked about this idea of the chasm and Crossing the Chasm, but it might be helpful just to explain what is the idea, what is this chasm? What is it that people fall into and why is this important?

**中文翻译:**
我们谈到了鸿沟和跨越鸿沟的概念，但解释一下这个想法到底是什么可能会有帮助。什么是鸿沟？人们会掉进什么坑里？为什么这很重要？

---

### [00:31:01] Geoffrey Moore

**English:**
And this was funny, because I was working at Regis McKenna, which was this marketing agency that was sort of the premier high-tech marketing agency in the eighties. And we had all these really successful launches, and then covers of front page articles on Fortune magazine and Wall Street Journal. And then a couple of years later it's like, "Well, what happened to these guys?" So that's where the chasm was like... That's what caused the investigation. What we learned was visionaries make their own buying decisions, and they do not consult their peers. In fact, if their peers are doing it, they're probably not going to do it because they want to be different. So basically these companies were having success capturing the imagination of the visionary, and they thought, "Well, I'll use the visionaries as a reference to get the pragmatist."

**中文翻译:**
这很有趣，因为我当时在 Regis McKenna 工作，那是 80 年代顶尖的高科技营销机构。我们有很多非常成功的发布会，甚至登上了《财富》杂志和《华尔街日报》的封面。但几年后，人们会问：“这些人后来怎么了？” 这就是鸿沟所在……也是引发调查的原因。我们了解到，远见者会自己做购买决定，他们不咨询同行。事实上，如果他们的同行都在做，他们可能反而不做了，因为他们想与众不同。所以基本上，这些公司成功吸引了远见者的想象力，他们想：“好吧，我会利用远见者作为推荐来吸引实用主义者。”

---

### [00:31:53] Geoffrey Moore

**English:**
The pragmatist looks at the visionary and goes, "That's not my guy. First of all, he thinks I'm dumb. He thinks he's smarter than I am. Second of all, he does stuff that I would never do, and he makes decisions in a way that I would never make them. So that's not... No. So but I am interested in talking to my peers, but the problem now is, well, which of the peers are going to go first?" And it was kind of like the junior high dance problem. How do you get the party started? So that was the chasm. That was what created the chasm. The pragmatists need references and they will not accept a visionary as a reference, and they don't have any peers that have tried it yet. So that was what was happening.

**中文翻译:**
实用主义者看着远见者会想：“那不是我这类人。首先，他觉得我笨，他觉得自己比我聪明。其次，他做的事我永远不会做，他做决定的方式我永远不会采用。所以那不是……不。但我确实有兴趣和我的同行聊聊，但现在的问题是，哪个同行会先尝试呢？” 这有点像初中舞会的问题：如何让派对开始？这就是鸿沟。这就是造成鸿沟的原因。实用主义者需要推荐，但他们不接受远见者作为推荐，而他们又还没有任何同行尝试过。这就是当时发生的情况。

---

### [00:32:35] Lenny

**English:**
I think that's such an important point that I think people don't quite always get that that reference, marques customer needs to be a pragmatist. It can't be one of these early adopters that are just trying stuff. And these other pragmatists need to feel that this is my person, this is just like me. And they love it.

**中文翻译:**
我认为这是一个非常重要的点，人们并不总是明白：那个推荐人、那个明星客户必须是一个实用主义者。不能是那些只是在尝试新鲜事物的早期采用者。其他的实用主义者需要感觉到“这是我这类人，这人就像我一样”，而且他们很喜欢这个产品。

---

### [00:32:53] Geoffrey Moore

**English:**
By the way, one of the reasons that pragmatists have a certain... It's not contempt for visionaries, but it's definitely wariness, it's because often they have to clean up the messes that these guys leave behind because when you're a visionary, you leave a lot of messes in your wake. And then the pragmatist has to come in and clean it up. So they're going, "Oh, that's another mark against these people."

**中文翻译:**
顺便说一下，实用主义者对远见者有一种……不是蔑视，但绝对是警惕，原因之一是他们经常要收拾这些家伙留下的烂摊子。因为当你是一个远见者时，你会留下很多烂摊子，然后实用主义者必须进来清理。所以他们会想：“噢，这又是这些人的一大污点。”

---

### [00:33:14] Lenny

**English:**
I saw a deck of yours where you actually represent each of these stages of the lifecycle and the visionary Steve Jobs is the way you represented it, and the pragmatists are just like business people in suits sitting at a conference table.

**中文翻译:**
我见过你的一份幻灯片，你用不同的形象代表生命周期的每个阶段：远见者是用史蒂夫·乔布斯代表的，而实用主义者就像是穿着西装坐在会议桌旁的商务人士。

---

### [00:33:24] Geoffrey Moore

**English:**
Exactly. And there's six of them. And the key idea behind that is none of us... By the way, I don't think any of these people are a guru and they don't think I'm a guru. We're using the antelope strategy, it's a herd strategy. But at some point... And by the way, we do this all the time, every one of... Airbnb, I want to get an Airbnb in Portland. Have you ever stayed [inaudible 00:33:53]? Is this a good hotel? Is this a good restaurant? Is this a good dentist? Is this a good lawyer? That's how we do it.

**中文翻译:**
没错。而且有六个人。背后的核心思想是，我们中没有人……顺便说一下，我不认为这些人中任何一个是大师，他们也不认为我是大师。我们使用的是“羚羊策略”，这是一种羊群策略。但在某个时刻……顺便说一下，我们一直都在这样做，每一个人……比如 Airbnb，我想在波特兰订个房。你住过那儿吗？那家酒店好吗？那家餐厅好吗？那个牙医好吗？那个律师好吗？我们就是这样做的。

---

### [00:33:58] Lenny

**English:**
I think Uber and Airbnb is the best example of this in action where I would not ride in a random car, especially I think women were most like, "I will never get into a car, into an Uber." This is insane until all of their friends are doing it. And then, "Okay, let's give it a shot."

**中文翻译:**
我认为 Uber 和 Airbnb 是这方面的最佳案例。我不会随便坐进一辆陌生的车里，尤其是女性，她们最初会觉得：“我永远不会进一辆 Uber 车。” 这太疯狂了，直到她们所有的朋友都在这么做。然后她们才会觉得：“好吧，让我们试试看。”

---

### [00:34:13] Geoffrey Moore

**English:**
I guess it's okay, yeah.

**中文翻译:**
我想应该是没问题的，是的。

---

### [00:34:15] Lenny

**English:**
Yeah. So essentially most people were pragmatists and I guess that makes sense. And pragmatists make up the biggest chunk for it.

**中文翻译:**
是的。所以本质上大多数人都是实用主义者，我想这很合理。实用主义者占据了最大的份额。

---

### [00:34:21] Geoffrey Moore

**English:**
And by the way, you can be a visionary with some things, a pragmatist with other things, and a conservative with other things. So the way to really think about them is, what is my persona in relation to this decision?

**中文翻译:**
顺便说一下，你可以在某些事情上是远见者，在另一些事情上是实用主义者，在其他事情上又是保守派。所以真正思考他们的方式是：相对于这个决定，我的人格画像是什么？

---

### [00:34:34] Lenny

**English:**
I love this example of the junior high dance problem where nobody wants to go ask the person. It's like, "I'm going to wait for them to come to me. I want to see how this plays out." It's such a good metaphor. In terms of how much of your product needs to be built at each of these stages. What advice do you share? How much do you need for these visionaries versus the next?

**中文翻译:**
我喜欢这个初中舞会的例子，没有人想先去邀请对方。就像是：“我要等他们来找我，我想看看情况如何发展。” 这是一个非常好的比喻。关于在每个阶段需要构建多少产品，你有什么建议？对于远见者和下一个阶段，你需要准备多少？

---

### [00:34:52] Geoffrey Moore

**English:**
So with a visionary, you have to have the magic ingredient working. You don't have the whole product. And in fact, your product may be buggy, but it does something... Andy Grove used to call it the 10 x effect. You need to do something that is an order of magnitude better than anything because that's why the visionary is talking to you. They're going, "Oh my gosh, you have this fusion." "Fusion, really?" "Yeah, we got fusion energy." So that's number one. Then what would still cause you to not cross the chasm yet? If there's not enough product there, pragmatists cannot put up with a product that doesn't work. So you may need to do some additional work to say, "Look, we get some more customers. I'm still living hand to mouth. It's mostly project work, but until the product has got enough stability and can be productized, I really can't afford to cross the chasm." So once you have a product that works, then you've got to say, "Okay, now I've got to find a market where it can be the dominant solution." That's the time to cross the chasm.

**中文翻译:**
对于远见者，你必须让“神奇成分”发挥作用。你不需要完整的产品。事实上，你的产品可能有 Bug，但它能做到一些……安迪·格鲁夫（Andy Grove）曾称之为“10 倍效应”的事情。你需要做一些比任何东西都好一个数量级的事情，因为这就是远见者和你交谈的原因。他们会惊叹：“噢我的天，你有核聚变。” “核聚变，真的吗？” “是的，我们有聚变能源。” 这是第一点。那么，还有什么会导致你还不能跨越鸿沟呢？如果产品还不够完善，实用主义者是无法忍受一个不能正常工作的产品。所以你可能需要做一些额外的工作，说：“看，我们有了更多客户。我还在勉强维持，大部分是项目工作，但在产品足够稳定并能产品化之前，我真的无法跨越鸿沟。” 一旦你有了可以运行的产品，你就得说：“好吧，现在我得找一个市场，让它成为主导解决方案。” 那就是跨越鸿沟的时机。

---

### [00:36:05] Lenny

**English:**
And a big part of that is obviously they have bosses, they have checklists, they have compliance people, they have IT people, they have people that need to buy into this or this meeting room with six people. They all have to be like, "All right, this is the best choice."

**中文翻译:**
显然，其中很大一部分原因是他们有老板、有清单、有合规人员、有 IT 人员，他们有需要认同这件事的人，或者那个坐着六个人的会议室。他们都必须觉得：“好吧，这是最好的选择。”

---

### [00:36:18] Geoffrey Moore

**English:**
And by the way, normally those people are designed to keep you out, and that decision process will take forever and you'll be in the welfare lines before they make their choice. So that's why it's so important to have what we call the compelling reason to buy. You need to have a group of people in a room where the leader, the guy who's going to actually sponsor make this decision is saying, "Look, I already gave this problem to everybody in the room, and our answer sucks." He wouldn't say it that way, but that's the truth. And therefore, we're kind of at the... I mean, I'm getting the message. First of all, my boss's boss's boss knows my name. That's a very bad thing. Secondly, I'm getting the message, you're either going to fix this problem, Geoffrey, or we're going to find somebody who can. So that's what gives them the energy to go against the inertial momentum of the decision-making process in their company.

**中文翻译:**
顺便说一下，通常那些人的职责就是把你拒之门外，那个决策过程会持续到天荒地老，在他们做出选择之前你可能就已经破产了。这就是为什么拥有我们所说的“迫切的购买理由”如此重要。你需要在一个房间里有一群人，其中的领导者，也就是那个真正会赞助并做出决定的人，会说：“听着，我已经把这个问题交给了房间里的每一个人，而我们的答案烂透了。” 他不会那样说，但那是事实。因此，我们正处于……我是说，我收到了信号。首先，我老板的老板的老板知道我的名字了，这是一件非常糟糕的事情。其次，我收到的信号是，Geoffrey，你要么解决这个问题，要么我们就找能解决的人。这就是给他们能量去对抗公司决策过程惯性的原因。

---

### [00:37:15] Lenny (Sponsor: Arcade)

**English:**
Let me tell you about a product called arcade. Arcade is an interactive demo platform that enables teams to create polished on-brand demos in minutes, telling the story of your product is hard, and customers want you to show them your product, not just talk about it or gate it. That's why product four teams such as Atlassian, Carta, and Retool use Arcade to tell better stories within their homepages, product change logs, emails, and documentation. But don't just take my word for it. Quantum Metric, the leading digital analytics platform created an interactive product tour our library to drive more prospects. With Arcade, they achieved a two x higher conversion rate for demos and saw five times more engagement than videos.

**中文翻译:**
让我向你介绍一款名为 Arcade 的产品。Arcade 是一个交互式演示平台，能让团队在几分钟内创建精美的、符合品牌形象的演示。讲述产品故事很难，而客户希望你展示产品，而不仅仅是空谈或设置门槛。这就是为什么 Atlassian、Carta 和 Retool 等团队使用 Arcade 在主页、产品变更日志、电子邮件和文档中讲述更好的故事。不要只听我的一面之词，领先的数字分析平台 Quantum Metric 创建了一个交互式产品巡览库来吸引更多潜在客户。通过 Arcade，他们的演示转化率提高了两倍，互动率是视频的五倍。

---

### [00:37:57] Lenny (Sponsor: Arcade)

**English:**
On top of that, they built the demo 10 times faster than before. Creating a product demo has never been easier. With browser-based recording Arcade is the no-code solution for building personalized demos at scale. Arcade offers product customization options, designer approved editing tools and rich insights about how your viewers engage every step of the way. Ready to tell more engaging product stories that drive results? Head to arcade.software/lenny and get 50% off your first three months. That's arcade.software/lenny.

**中文翻译:**
最重要的是，他们制作演示的速度比以前快了 10 倍。创建产品演示从未如此简单。通过基于浏览器的录制，Arcade 是大规模构建个性化演示的无代码解决方案。Arcade 提供产品自定义选项、设计师认可的编辑工具，以及关于观众在每一步如何互动的丰富洞察。准备好讲述更具吸引力并能带来成果的产品故事了吗？访问 arcade.software/lenny，前三个月可享受 5 折优惠。

---

### [00:38:30] Lenny

**English:**
So April Dunford was on this podcast and she has this book that she put out recently called Sales Pitch. And she make this point that buying software, SaaS software is harder than selling it these days because you can get fired for buying the wrong thing. It's so stressful. There's all these options. Your boss has to be happy with it. So often people end up just not going with anything. We're just going to keep what we have. It's fine, simpler, safer. Salesforce is fine. And it sounds like that's kind of what you're describing. It's so hard-

**中文翻译:**
April Dunford 曾上过这个播客，她最近出了一本书叫《销售话术》（Sales Pitch）。她提出了一个观点：如今购买软件、SaaS 软件比销售软件更难，因为买错了东西可能会被解雇。压力太大了，有这么多选择，你的老板必须满意。所以人们往往最终什么都不选。我们就用现有的吧，挺好的，更简单、更安全。Salesforce 挺好的。听起来这正是你所描述的情况。太难了——

---

### [00:38:58] Geoffrey Moore

**English:**
So if you're a pragmatist, the first thing is if it ain't broke, don't fix it. Which makes you totally different than a visionary. A visionary's like, "Yeah, no, come on, break it. Come on, let's move on." It ain't broke, don't fix it. If it is broke, who has fixed it? Is there fix in production? Does the fix work? I want that. In other words, basically to April's point, it is a risk reduction buying strategy. And by the way, you go as slowly as you can normally, but when you're under duress, you have to go faster. So the compelling reason to buy is putting you under duress.

**中文翻译:**
所以如果你是一个实用主义者，第一条准则就是“如果没坏，就别修它”。这让你与远见者完全不同。远见者会说：“耶，不，来吧，把它打破，让我们继续前进。” 实用主义者则是：没坏就别修。如果坏了，谁修好了它？生产环境中有修复方案吗？修复方案有效吗？我要那个。换句话说，基本上正如 April 所说，这是一种“降低风险”的购买策略。顺便说一下，通常你会尽可能慢地行动，但当你面临压力（duress）时，你必须加快速度。所以，“迫切的购买理由”就是让你处于压力之下。

---

### [00:39:41] Lenny

**English:**
Are there any examples of these compelling reasons to buy that come to mind that give people a sense of here's a really good compelling reason to buy? I don't know if it's a pitch.

**中文翻译:**
有没有什么“迫切的购买理由”的例子能让大家感受一下？我不知道这是否算是一种销售话术。

---

### [00:39:48] Geoffrey Moore

**English:**
Well, there's a ton. Well, how about ransomware? I mean, all of a sudden the cybersecurity thing is like holy smoke because it used to be, "Well, they wouldn't attack my company. Or if they did, I mean, I have no assets." Yeah, well, actually... Because it used to be what they did is they would only attack companies that had data that they could resell in the dark web. Then God bless cryptocurrency, people are saying, "Is it cross the chasm yet? Well, their first use case is criminals." It's not a very good use case, I'm sorry to say. But the point is, now ransomware with cryptocurrency can be a monetization, so that means everybody is vulnerable. So that's one kind of compelling reason to buy. But if you look around kids who are struggling with school, the parent has a compelling reason. Anything with healthcare, compelling reason to buy. Anything if you're in a legal problem, you have a compelling risk to buy.

**中文翻译:**
有很多。比如勒索软件（ransomware）？我是说，突然之间网络安全问题变得极其紧迫，因为以前人们觉得：“好吧，他们不会攻击我的公司。或者即使攻击了，我也没什么资产。” 实际上……因为以前他们只攻击那些拥有可以在暗网转售的数据的公司。后来，感谢加密货币，人们在问：“它跨越鸿沟了吗？好吧，它的第一个用例是犯罪分子。” 很遗憾，这不是一个好的用例。但重点是，现在有了加密货币，勒索软件可以变现了，这意味着每个人都是脆弱的。这是一种迫切的购买理由。如果你看看那些在学校挣扎的孩子，家长就有迫切的理由。任何与医疗保健相关的事情，都有迫切的购买理由。如果你陷入法律纠纷，你就有迫切的风险去购买。

---

### [00:40:48] Geoffrey Moore

**English:**
So I mean, there's always these situations where you say, "Okay, that's on a personal basis." On a company-wide basis, it may be things like, "Well, what am I supposed to do my office space? Can I get my company to come back to the office or do I have to dump the space? What am I supposed to do? And by the way, I know I'm going to have some kind of space, but do I want to design it the way we used? I'm getting into some space by the way, I got a great deal if it was a fire sale, right? Cool space, what do I put in it? Is it supposed to have offices? Do they have doors, do they not have doors do?" So in other words, there's a bunch of stuff where you get people going, "Okay, how can we help? How can we help?" "I need help. And I've gone to my standard solutions and no, I don't believe that, so I need help."

**中文翻译:**
所以我是说，总会有这些情况，个人层面是这样。在公司层面，可能是这样的事情：“好吧，我的办公空间该怎么办？我能让员工回办公室吗，还是我得把空间退掉？我该怎么办？顺便说一下，我知道我肯定需要某种空间，但我还想按以前那样设计吗？顺便说一下，我刚租了一些空间，如果是清仓大甩卖，我拿到了很好的价格，对吧？很酷的空间，我往里放什么？应该有办公室吗？有门还是没门？” 换句话说，有很多事情会让人们觉得：“好吧，我们能怎么帮忙？我们能怎么帮忙？” “我需要帮助。我已经试过标准解决方案了，但不，我不相信那些，所以我需要帮助。”

---

### [00:41:37] Lenny

**English:**
Okay, so it's interesting that I even misunderstood what you're saying and I think this is a really important point. The compelling reason to buy is not a compelling reason to sell, which people often think about as the pitch you're making. The buy is basically the pain point. They need a really big pain.

**中文翻译:**
好，有趣的是我甚至误解了你的意思，我认为这是一个非常重要的点。“迫切的购买理由”不是“迫切的销售理由”，人们通常认为后者是你做的销售话术。购买理由本质上是痛苦点，他们需要一个非常大的痛苦。

---

### [00:41:51] Geoffrey Moore

**English:**
Yeah, because that's what's going to... So therefore the key to the bowling alley that's different from the tornado, and it's also different from the early market. In the early market it's about you. You tell the story about you and the visionary wants to hear about you. In the tornado it's also about you, because we now have budget to buy this stuff, and you're a candidate. In the bowling alley, it's never about you. And that is so hard for a series of entrepreneurs because they want to give a demo, they want to tell the story, they want to share their vision. The answer is, "We don't care. We don't want to hear your story. We hate demos, and I don't know who you are and I don't care. I'm in trouble. We need to talk about me. We don't want to talk about you."

**中文翻译:**
是的，因为那是……因此，保龄球道的关键在于它不同于龙卷风，也不同于早期市场。在早期市场，重点是你。你讲述关于你的故事，远见者想听关于你的事。在龙卷风阶段，重点也是你，因为我们现在有预算买这些东西了，而你是一个候选者。但在保龄球道阶段，重点永远不是你。这对很多企业家来说非常困难，因为他们想做演示，想讲故事，想分享愿景。答案是：“我们不在乎。我们不想听你的故事。我们讨厌演示，我不认识你，我也不在乎。我有麻烦了，我们需要谈谈我的事，我们不想谈论你。”

---

### [00:42:35] Geoffrey Moore

**English:**
So we have this saying in the Crossing the Chasm playbook. First of all, "Shut the God damn laptop. Just don't open it and start with..." And the way you start the conversation is always the same. "We're here because we've been working with some people in your industry and we understand there's this really serious problem around document management or around Wi-Fi access or whatever it is, and we believe that your company might have it, is that true?" And what's interesting about it is you'll get one of two responses either, "Oh, are you kidding me? Okay, we have that." Or often they'll say, "Well, not exactly." And you go, "Oh," but then before you can say anything else they'll say, "What our real problem is..." So people will talk about their... They want therapy, they'll talk about their problems. So if you're willing to... But as an entrepreneur, you got to realize the gold at this point is problem domain knowledge. That's the thing you really want to collect.

**中文翻译:**
所以我们在《跨越鸿沟》手册里有这么一句话。首先，“合上你那该死的笔记本电脑。别打开它，然后开始……” 你开始对话的方式总是一样的：“我们来到这里是因为我们一直在与你们行业的一些人合作，我们了解到在文档管理或 WiFi 接入等方面存在一个非常严重的问题，我们认为贵公司可能也遇到了，是这样吗？” 有趣的是，你会得到两种回应之一：要么是“噢，你在开玩笑吗？好吧，我们确实有这个问题”；要么通常他们会说“嗯，不完全是”。你会说“噢”，但在你说别的之前，他们会说“我们真正的问题是……” 所以人们会谈论他们的……他们需要心理治疗，他们会谈论他们的问题。所以如果你愿意……但作为一名企业家，你必须意识到，此时的黄金是“问题领域的知识”。这才是你真正想要收集的东西。

---

### [00:43:45] Lenny

**English:**
Amazing. So you've sort of answered this question, but I want to make it even more complete. You have this amazing LinkedIn post of these four go-to-market playbooks based on the stage you're in. And you've touched on this already, but it might be helpful just to go through it one by one. And even more helpful would be like, what does it look like when you're in the early market? How do you know if you're in the early market versus in the bowling alley versus in the tornado?

**中文翻译:**
太棒了。你已经部分回答了这个问题，但我希望能更完整一些。你在 LinkedIn 上发过一个很棒的帖子，介绍了基于所处阶段的四种市场进入手册。你已经提到了一些，但如果能逐一梳理一遍会很有帮助。更有帮助的是：当你处于早期市场时，情况是怎样的？你如何知道自己是在早期市场，还是在保龄球道，还是在龙卷风阶段？

---

### [00:44:08] Geoffrey Moore

**English:**
Okay, so in the early market, you know you're there because first of all, the story is the technology, and it's specifically the disruptive technology. By the way, you could start a business with a non-disruptive thing, but then you don't need these playbooks, then you're on Main Street. So the assumption is you've got something that nobody's ever done before or seen before. So in that playbook, the first thing is just you hear the responsibilities. And a venture capitalist would say the same thing to you. "Do you have a technology expert who's a wizard? Because we're not going to fund just any two guys and a PowerPoint tech, even though we like your dog."

**中文翻译:**
好，在早期市场，你知道自己在那儿，是因为首先，故事的主角是技术，特别是颠覆性技术。顺便说一下，你可以用非颠覆性的东西创业，但那样你就不需要这些手册了，你直接就在“主街”上了。所以假设是你拥有一些前所未见的东西。在那套手册中，第一件事就是明确职责。风险投资家也会对你说同样的话：“你有没有一个技术专家，一个奇才？因为我们不会只给两个拿着 PPT 的家伙投钱，哪怕我们很喜欢你的狗。”

---

### [00:44:50] Geoffrey Moore

**English:**
So that's number one. Number two, "Can you demo the technology?" You have to be able to demo thing. And then three, "Can you create a vision which says what forces are going to release?" And the concept that we use in venture, I call it trapped value. And with the idea is where's the trap value that this innovation would release? Because when you release trapped value, the world will give you a portion of the gain, typically 10%. It's easy an number to do math with. As I said, I'm an English major. So if you want a billion-dollar company, you better find $10 billion worth of trapped value that your technology could- [inaudible 00:45:30]

**中文翻译:**
这是第一点。第二点，“你能演示这项技术吗？” 你必须能够演示。第三，“你能创造一个愿景，说明将释放出什么样的力量吗？” 我们在风投中使用的概念，我称之为“被困住的价值”（trapped value）。核心思想是：这项创新将释放出哪里被困住的价值？因为当你释放了被困住的价值时，世界会分给你一部分收益，通常是 10%。这是一个很容易计算的数字，正如我所说，我是英语专业的。所以如果你想要一家价值 10 亿美元的公司，你最好找到价值 100 亿美元的被困住的价值，让你的技术去释放。

---

### [00:45:30] Lenny

**English:**
Airbnb is an amazing example of that, right? Where they unlocked people's homes, basically 10%-

**中文翻译:**
Airbnb 就是一个绝佳的例子，对吧？他们解锁了人们的闲置房屋，基本上拿走了 10%——

---

### [00:45:36] Geoffrey Moore

**English:**
Yeah. Uber unlocked their backseat of the car. By the way, the free labor force, it was like, "Whoa." Okay, so really cool idea early market fund. For the bowling alley one then the playbook is, "No, where's the problem?" And then you got to take it down to in what geography, what industry, what profession, what use case. And that takes... That's not just... I mean, you want to spend some time in doing that. And then what you want to really do is just maintain intellectual curiosity about the problem as opposed to jumping to the solution. So why is this a hard problem to do? What is going on? Where is the trapped value? By the way, how expensive? What is the cost of not solving this problem?

**中文翻译:**
是的。Uber 解锁了汽车的后座。顺便说一下，还有闲置的劳动力，就像“哇”。好吧，早期市场非常酷。对于保龄球道，手册是：“不，问题在哪儿？” 然后你必须细化到哪个地理区域、哪个行业、哪个职业、哪个用例。这需要……这不仅仅是……我是说，你要花时间去做这件事。然后你真正想做的是对问题保持好奇心，而不是急于跳到解决方案。为什么这是一个难题？发生了什么？被困住的价值在哪儿？顺便说一下，不解决这个问题的代价有多大？

---

### [00:46:24] Geoffrey Moore

**English:**
Often it's a risk exposure, or it could be just a gating item on your growth or potentially a churn problem. By the way, if you wanted to pick a compelling reason to buy, how about if you help SaaS companies deal with churn? Do you think they would care about that? I think they might. So the point being... And you're going to say, "Okay, I'm going to learn more about churn and I'm going to really understand... And by the way, I'm going to understand your churn," which is different maybe from somebody else's churn. So it's the problem domain thing. And then you build your go-to market around... The lead gen is, "Hey, do you have any of these seven symptoms of fatal churn?" And the people that respond to that ad are pre-qualified. And then the BDR, if you're at Salesforce, a BDR would call you and say, "Just confirming you have these problems." "Oh yeah, RBI." "And your role at the company is... And are you responsible for doing this?" "Well, actually no, it's Harry, not Mary." "Maybe we should talk to Harry." "Yeah, you probably should talk to Harry."

**中文翻译:**
通常这是一种风险暴露，或者可能是增长的瓶颈，或者是流失（churn）问题。顺便说一下，如果你想选一个迫切的购买理由，如果你能帮助 SaaS 公司处理流失问题呢？你觉得他们会在意吗？我想他们会的。所以重点是……你会说：“好吧，我要更多地了解流失，我要真正理解……顺便说一下，我要理解‘你的’流失”，这可能和别人的流失不一样。这就是问题领域的事情。然后你围绕这个建立你的市场进入策略……潜在客户开发（lead gen）的话术是：“嘿，你有这七种致命流失的症状吗？” 响应那个广告的人就是经过预筛选的。然后 BDR（业务开发代表），如果你在 Salesforce，BDR 会打电话给你说：“确认一下你是否有这些问题。” “噢是的。” “你在公司的角色是……你负责这件事吗？” “嗯，其实不是，是 Harry 负责，不是 Mary。” “也许我们应该和 Harry 谈谈。” “是的，你确实应该和 Harry 谈谈。”

---

### [00:47:32] Geoffrey Moore

**English:**
Then you call Harry and you get the appointment with Harry because Harry's got the problem. And then the next thing is you do a diagnostic with them. "So we understand we're talking to your colleagues, here's the problem, here's what we think we're doing. But before we tell you about how great our solution is, let's make sure that we understand what your challenges are." And your goal in that call is to get them to talk as much as possible and for you to take notes. And by the way, this is a place where you probably still want to remember to use a pen because you actually want them to see you writing down their words, because that means, "Okay, he's listening. He's listening."

**中文翻译:**
然后你打电话给 Harry，约到 Harry，因为 Harry 才有那个问题。接下来的事就是和他们一起做诊断。“我们和你的同事聊过了，了解到问题在这儿，这是我们认为我们在做的事。但在我们告诉你我们的解决方案有多棒之前，让我们先确保我们理解了你的挑战。” 在那次通话中，你的目标是让他们尽可能多地说话，而你负责做笔记。顺便说一下，在这种场合，你可能还是想记得用笔记录，因为你实际上想让他们看到你在记录他们说的话，因为这意味着：“好吧，他在听，他在认真听。”

---

### [00:48:14] Lenny

**English:**
Oh, interesting. That's a good tip. Like on Zoom, would your advice there be just make sure the camera shows your hands?

**中文翻译:**
噢，有趣。这是一个很好的建议。比如在 Zoom 上，你的建议是确保摄像头能拍到你的手吗？

---

### [00:48:19] Geoffrey Moore

**English:**
Oh, yeah, yeah.

**中文翻译:**
噢，是的，没错。

---

### [00:48:22] Lenny

**English:**
Okay. Lean in. Yeah, yeah.

**中文翻译:**
好的。身体前倾。是的。

---

### [00:48:23] Geoffrey Moore

**English:**
Or sometimes... I mean, no, you couldn't do this. I was going to say we record it, but they don't want to record it because they're going to say some things during the call that they won't be necessarily complimentary to all their colleagues and they don't want you to record it.

**中文翻译:**
或者有时……我是说，不，你不能这样做。我本想说我们可以录音，但他们不想录音，因为他们在通话中会说一些对同事不那么客气的话，他们不想让你录下来。

---

### [00:48:38] Lenny

**English:**
Got it. So in this bowling alley phase, how do you know you... I know it's not like this binary switch, but that you're ready to move into that versus the early market playbook.

**中文翻译:**
明白了。所以在保龄球道阶段，你如何知道自己……我知道这不像一个二进制开关，但你如何知道自己准备好进入这个阶段，而不是继续用早期市场手册？

---

### [00:48:50] Geoffrey Moore

**English:**
Well, I think you get to a point where you realize, "I can't scale my business doing what I've been doing. I mean, I just can't." And if you've taken venture capital, the thing you want to do is, "I don't want to have to raise another..." Well, so understand how venture capital funding works for a second. This is important. A venture capitalist gives you money, and what they're buying from you with this money is, "I want you to use this money to change the state of your company such that when we raise the next round, the next investor will value your company two to three times higher than we're valuing it today."

**中文翻译:**
我认为你会达到一个点，意识到：“我无法通过一直以来的做法来扩展业务。我是说，我真的做不到。” 如果你拿了风险投资，你想做的是：“我不想再被迫融资……” 好吧，先理解一下风险投资是如何运作的。这很重要。风险投资家给你钱，他们用这些钱从你这里买到的是：“我希望你利用这些钱改变公司的状态，以便当我们进行下一轮融资时，下一个投资者对你公司的估值会比我们今天的估值高出两到三倍。”

---

### [00:49:30] Geoffrey Moore

**English:**
So basically the purpose of this money is to change the value state of your company. If you do anything else with that money, you could have done brilliant things, created amazing demos, hired great people, but if at the end of the day you haven't changed the value state of the company and we have to raise more money, we're going to raise it at the old valuation and I as an investor lose, or even worse, we have a down round and I lose even more.

**中文翻译:**
所以基本上，这笔钱的目的是改变你公司的“价值状态”。如果你用这笔钱做了其他任何事情——你可能做了很棒的事，制作了惊人的演示，雇佣了优秀的人才——但如果到头来你没有改变公司的价值状态，而我们不得不筹集更多资金，我们将以旧的估值筹集，我作为投资者就亏了；或者更糟，我们遇到了“流血融资”（down round），我亏得更多。

---

### [00:49:58] Geoffrey Moore

**English:**
So once you start thinking about that, so we're then Crossing the Chasm. The Crossing the Chasm play is I need to change the state of my company from a cool possibility to what accountants call a going concern. So what is a going concern? A going concern is a company that two years from now you would expect still to be in existence. Why would you do that? Because they have a customer base that's loyal and they have a ecosystem of partners that bring them into new deals and they have established their CAC and LTV, and they've kind of figured out their operating model. And it's not the biggest company in the world.

**中文翻译:**
所以一旦你开始考虑这一点，我们就进入了“跨越鸿沟”。跨越鸿沟的行动是：我需要将公司的状态从一个“很酷的可能性”转变为会计师所说的“持续经营企业”（going concern）。什么是持续经营企业？持续经营企业是指你预期两年后依然存在的公司。为什么会这样？因为他们拥有忠诚的客户群，拥有能带来新交易的合作伙伴生态系统，他们已经确定了获客成本（CAC）和终身价值（LTV），并且大致摸索出了运营模式。它不一定是世界上规模最大的公司。

---

### [00:50:38] Geoffrey Moore

**English:**
It's somewhere we're now probably in the 10, $20 million, but it's a real company. It's a real company. And that's who you're trying to create when you cross the chasm. And you know you've crossed the chasm when you say, "I don't have to raise any more venture capital. Now, I may want to because I have ambitions to be globally dominant." But you get to raise it on your nickel and on your timeline, not on, "Oh my God, I'm running out of money." So the sooner you can get off with the, "I'm running out..." And particularly last year was fatal to a huge number of companies because that was not how they were thinking about raising funds. They always thought, "Well, there'll be another round, another round, another round." And they were not thinking about changing their valuation state and they're not here.

**中文翻译:**
它现在的规模可能在 1000 万到 2000 万美元之间，但它是一家真正的公司。这就是你跨越鸿沟时试图创造的企业。当你能说“我不需要再筹集任何风险投资了”时，你就知道自己已经跨越了鸿沟。当然，你可能“想要”融资，因为你有全球霸主的雄心。但你是根据自己的资本和时间表来融资，而不是因为“噢天哪，我要没钱了”。所以你越早摆脱“我要没钱了”的状态越好……特别是去年对大量公司来说是致命的，因为那不是他们考虑融资的方式。他们总觉得“会有下一轮，再下一轮，再下一轮”，他们没有考虑改变自己的估值状态，所以他们现在已经不在了。

---

### [00:51:26] Lenny

**English:**
That's a really interesting insight. This idea that you know you've crossed the chasm if you can survive without more venture funding, how do you think about that, the profit element of that? Because it feels like that's the core to being able to survive without venture funding. Is it about making enough money that you can cut and make a profit, or is there some other reason?

**中文翻译:**
这是一个非常有趣的见解。如果你能在没有更多风投支持的情况下生存，就说明你已经跨越了鸿沟。你如何看待其中的利润因素？因为感觉那是无需风投也能生存的核心。是关于赚到足够的钱，以至于你可以削减开支并实现盈利，还是有其他原因？

---

### [00:51:47] Geoffrey Moore

**English:**
All you really care about is cashflow positive. I just want to be able to keep doing what I'm doing. So you don't care about the actual GAAP accounting at all.

**中文翻译:**
你真正关心的只是现金流转正。我只想能够继续做我正在做的事情。所以你根本不在乎实际的 GAAP 会计准则。

---

### [00:52:01] Lenny

**English:**
I see. So you could cut back and you can get to profitability if you need, but the idea is your cashflow positive?

**中文翻译:**
明白了。所以如果需要，你可以削减开支并实现盈利，但核心思想是现金流转正？

---

### [00:52:08] Geoffrey Moore

**English:**
And you'd like to grow and you might want to raise money. But the point is, if you do go out to raise money, you get to raise money at a different valuation. So the way in which venture capitalists categorize you is they say, "What risk is my money going to take off the table?" So an angel investor says, "Well, my money is going to take off the table, the risk of whether you can even create anything, I'm going to give you enough money to get into trouble." That's basically it. And then the Crossing the Chasm money says, "I'm going to take company existence viability off the table. I don't know if you're going to grow, I don't know if you're going to become a venture return, but I'm going to take you going out of business off the table."

**中文翻译:**
而且你希望增长，你可能想融资。但重点是，如果你真的去融资，你会以不同的估值融资。风险投资家对你分类的方式是看：“我的钱能消除什么风险？” 天使投资人会说：“我的钱要消除的是你是否能做出东西的风险，我给你足够的钱让你去闯闯。” 基本上就是这样。然后“跨越鸿沟”的资金会说：“我要消除公司生存可行性的风险。我不知道你是否会增长，不知道你是否会带来风投级的回报，但我会消除你倒闭的风险。”

---

### [00:52:48] Geoffrey Moore

**English:**
And then the bowling alley stuff is, "Okay, now I'm buying probably a journey from 10 million to a hundred million dollars," something like that. "And I'm expecting a growth rate," and this is probably where the rule of 40 starts to kick in. If you're playing the rule of 40, we want to raise more money later on, you're going to have a different valuation than we had before. And then the tornado thing by that point, now you say, "You're in Gen AI? You have a large language module? Whoa, okay. You're worth a lot more than we thought," because now the category's in the tornado and that's a different game.

**中文翻译:**
接着保龄球道阶段是：“好吧，现在我买的可能是从 1000 万到 1 亿美元的历程。” “我预期一个增长率”，这可能就是“40 原则”（Rule of 40）开始发挥作用的地方。如果你遵循 40 原则，我们以后想筹集更多资金，你的估值会和以前完全不同。到了龙卷风阶段，现在你说：“你在做生成式 AI？你有大语言模型？哇，好吧，你比我们想象的更值钱”，因为现在这个品类进入了龙卷风期，那是另一种游戏了。

---

### [00:53:29] Lenny

**English:**
Yeah. I was going to say AI is clearly an example of being in tornado. So maybe just talk a little bit about what that is, the tornado phase and then there's the Main Street playbook.

**中文翻译:**
是的。我想说 AI 显然是处于龙卷风阶段的一个例子。所以也许可以谈谈什么是龙卷风阶段，以及随后的“主街”手册。

---

### [00:53:39] Geoffrey Moore

**English:**
So how do you know the difference between the bowling alley and the tornado? Prior to the tornado, when your sales team calls on the customer, they do not have a budget for you. In the early market, there's no budget for anything. In the bowling alley there's budget, but it's budget for a solution that's not you. It's for the old way of trying to bandaid the problem. So we say in the early market, you have to create budget. In the bowling alley, you have to redirect budget, but that takes sales cycles. It takes time. And if it's a small market... This is why entrepreneurs can win these market segments, because if you're a big established company, this is just a pain in the ass. It's too small a market, it's too much work, it's too hard. Redirecting the... I want my salespeople to go where the budget's already established.

**中文翻译:**
你如何区分保龄球道和龙卷风？在龙卷风之前，当你的销售团队拜访客户时，他们没有针对你的预算。在早期市场，根本没有任何预算。在保龄球道阶段有预算，但那是给非你之外的解决方案的预算，是给那些修修补补的旧方法的。所以我们说，在早期市场，你必须“创造”预算；在保龄球道，你必须“重新定向”预算，但这需要销售周期，需要时间。如果是一个小市场……这就是为什么企业家能赢得这些细分市场的原因，因为如果你是一家成熟的大公司，这简直是自找麻烦。市场太小，工作量太大，太难了。我希望我的销售人员去那些预算已经确定的地方。

---

### [00:54:28] Geoffrey Moore

**English:**
Well, when does budget get established? When a category goes horizontal and people go, "Well, yeah, we all want Wi-Fi, we all want mobile apps, we all want cloud computing, we all want whatever it is." And now what happens is... And by the way the pragmatist heard is they went from, "You're not doing that, are you?" "No, me neither." "Okay, good." To, "You are, you are, you are. Oh, we're behind. We better do it." So these budgets come into the market and kind of all at the same time, which is what creates the tornado. Because if you give a department a budget, they will spend it and when they spend it, they're going to spend it with a vendor and whoever vendor they select they're probably going to stay with. So now the market share battle is now on, and whoever gets the most customers early on, the ecosystem starts to form around them.

**中文翻译:**
那么，预算什么时候会确定呢？当一个品类变得横向化，人们会说：“好吧，是的，我们都想要 WiFi，我们都想要移动应用，我们都想要云计算，我们都想要任何当红的东西。” 此时发生的是……顺便说一下，实用主义者群体从“你没在做那个吧？”“没，我也没有。”“好，那就好。”转变为“你在做，你也在做，你也在做。噢，我们落后了，我们最好也做。” 于是这些预算几乎同时涌入市场，这就形成了龙卷风。因为如果你给一个部门一笔预算，他们就会花掉它；当他们花钱时，他们会花在某个供应商身上，而且一旦选定，他们很可能会一直用下去。所以现在市场份额争夺战开始了，谁在早期获得最多的客户，生态系统就会开始围绕谁形成。

---

### [00:55:23] Geoffrey Moore

**English:**
So in the nineties, we saw a lot of tornado, gorilla play. Cisco, Intel, Oracle, obviously Microsoft. I mean these companies, [inaudible 00:55:36], they were all incredibly competitive companies. They were all tornado plays. Between client server and the internet, it just created this massive tornado effect. And that game plan is very competitive sales to grab market share. And then at some point, if you're not number one, then you have to kind of do a defensive maneuver and retreat into a niche and say, "Okay, if I can't be a gorilla, I at least need to be a chimp." And a chimp is like a local gorilla. "I'm not the gorilla, but..." "I'm not Cisco, I'm Juniper." But for telcos, Juniper was the Cisco of telcos at that time. So anyway, I don't know if you saw in the paper today, but at the other end of that lifecycle, HPE has bought Juniper.

**中文翻译:**
在 90 年代，我们看到了很多龙卷风阶段的“大猩猩”（gorilla，指行业霸主）游戏。思科、英特尔、甲骨文，显然还有微软。我是说这些公司，他们都是极具竞争力的公司。他们玩的都是龙卷风游戏。在客户机/服务器架构和互联网之间，它创造了巨大的龙卷风效应。那个阶段的策略是通过极具竞争力的销售来抢占市场份额。在某个点，如果你不是第一名，你就必须采取防御措施，退守到一个利基市场，说：“好吧，如果我不能成为大猩猩，我至少得成为一只黑猩猩（chimp）。” 黑猩猩就像是局部的霸主。“我不是大猩猩，但是……” “我不是思科，我是瞻博网络（Juniper）。” 但对于电信运营商来说，当时的瞻博网络就是电信界的思科。总之，不知道你今天看报纸没，在生命周期的另一端，HPE 已经收购了瞻博网络。

---

### [00:56:28] Lenny

**English:**
[inaudible 00:56:28] is happening. I like that. That's good news. So one of the most interesting lessons you teach is also that these playbooks don't work together well. Basically if you use one in the wrong phase, it's the opposite. It has the opposite effect. So before we get there, let me just summarize maybe quickly the playbook in each of these four. I have some notes here and then maybe just talk about why is it that they fail if you pick the wrong one. So in the early market, you're looking for a visionary customer that just wants to use something new and cool and stay ahead of the curve. In the bowling alley phase, you want to engage with a pragmatic business person who has a huge problem and they need a fix and you're there for them. In the tornado, there's just this land grab, something is just going crazy, AI and everyone's just spend, spend, I need AI in my product. And then Main Street is just, it's kind of the sustaining tech that everyone just needs to make sure continues working and doesn't deteriorate.

**中文翻译:**
正在发生。我喜欢这个，这是个好消息。你教过的最有趣的课程之一是：这些手册不能很好地混合使用。基本上，如果你在错误的阶段使用其中一个，效果会适得其反。在我们深入讨论之前，让我快速总结一下这四个阶段的手册。我这儿有一些笔记，然后也许你可以谈谈为什么选错了会失败。在早期市场，你在寻找一个只想使用新鲜酷炫事物并保持领先的远见型客户。在保龄球道阶段，你想接触一个有巨大问题并需要解决方案的务实商务人士，而你就在那儿为他们服务。在龙卷风阶段，就像是抢地盘，某些东西正变得疯狂，比如 AI，每个人都在砸钱，说“我的产品里需要 AI”。而主街阶段，则是一种维持性技术，每个人只需要确保它继续运行且不退化。

---

### [00:57:23] Geoffrey Moore

**English:**
By the way, the way I would [inaudible 00:57:25] the last two is think of tornado as kind of the land and Main Street as the expand. I mean, that's not a bad way to think about the two as well. Yeah, you got it. You got it.

**中文翻译:**
顺便说一下，我区分最后两个阶段的方式是：把龙卷风看作是“占领”（land），把主街看作是“扩张”（expand）。这也是一种不错的思考方式。是的，你理解得很对。

---

### [00:57:35] Lenny

**English:**
Okay, great. So why is it that these undercut each other if you're trying to use either the one in the wrong phase or use both?

**中文翻译:**
好，太棒了。那么，如果你在错误的阶段使用其中一个，或者同时使用两个，为什么它们会互相削弱呢？

---

### [00:57:42] Geoffrey Moore

**English:**
Well, so let's start with classic sales 101 from the nineties. Qualify the customer on budget before you make a sales call. That absolutely is critical on Main Street. I mean it's critical on the tornado, it's dumb on Main Street because obviously they have budget, they've got budgets that even has your name on it if you can go get it. But it's a big mistake in the early market or in the bowling alley because they don't have budget. So you're not going to get it. And the way you win in the early market is with a project model and the way you win in the bowling alley is with a solution model.

**中文翻译:**
好吧，让我们从 90 年代经典的销售入门课开始：在进行销售拜访之前，先确认客户是否有预算。这在主街阶段绝对至关重要。我是说，在龙卷风阶段也很关键，但在主街阶段这甚至有点多余，因为显然他们有预算，如果你能拿到，那预算上甚至写着你的名字。但在早期市场或保龄球道阶段，这就是一个巨大的错误，因为他们没有预算。所以你确认不出来。你在早期市场获胜的方式是“项目模式”，而在保龄球道获胜的方式是“解决方案模式”。

---

### [00:58:17] Geoffrey Moore

**English:**
And the problem is if you bring a project model to the bowling alley, the problem is you won't scale because it won't be repeatable. The ecosystem won't form around you. And if you bring a solution model to the early market, it's like you're over investing in one thing. The visionary's saying, "Well, yeah, but I have so many other things I want to do." So they're going to want to take you way off your solution roadmap. So each one of these things, the market dynamics call for a very clear response. It's not hard to see the response. What people struggle with is, I have been successful with this playbook, the market has moved to the next phase, but I'm really good at the old playbook, so I want to stay with the playbook I'm good at. So that's when they get in trouble.

**中文翻译:**
问题在于，如果你把项目模式带到保龄球道，你就无法规模化，因为它不可复制，生态系统也不会围绕你形成。而如果你把解决方案模式带到早期市场，就像是在某件事上过度投资。远见者会说：“嗯，是的，但我还有很多其他想做的事。” 所以他们会让你严重偏离你的解决方案路线图。所以，针对每一种市场动态，都需要一个非常明确的回应。看清回应并不难，人们纠结的是：我用这套手册成功过，市场已经进入了下一阶段，但我非常擅长旧的手册，所以我还想坚持我擅长的那套。这就是他们陷入麻烦的时候。

---

### [00:59:05] Lenny

**English:**
So I think that's extra reason to pay close attention to which phase you're in and that you're practicing the correct playbook. We've talked about AI a little bit, and I don't want to get too far down this road, but I guess is there any advice you would share for an AI startup in being in this tornado or a company looking to integrate AI? Is there anything that you've seen of just make sure you're doing this right?

**中文翻译:**
所以我认为这更有理由去密切关注你所处的阶段，并练习正确的手册。我们谈了一点 AI，我不想在这个话题上扯太远，但我猜，对于处于龙卷风中的 AI 初创公司，或者想要集成 AI 的公司，你有什么建议吗？你有没有观察到什么，能确保他们做得正确？

---

### [00:59:26] Geoffrey Moore

**English:**
Well, it's interesting about... And specifically right now, I mean the thing that's caught everybody's imagination is generative AI. So we should be thinking about things like open AI with Microsoft and Co-pilot and those kinds of things. Well, maybe not. It depends on what... So from a customer's point of view, there's AI in the early market, there's AI in the bowling alley, there's AI in the chasm, there's AI in the tornado, and there's AI on Main Street. So I mean, I would argue if you go to Microsoft Copilot, you're on Main Street, you're not taking any risk, you're experimenting with a new thing. It's kind of cool, makes you more productive. God bless. It's kind of like just an add-on to Teams or to your whole Office 365 suite. Stuff that's in the tornado right now, I don't know. I'm trying to think about what is the use case for Gen AI? I'm not sure there is one in the tornado, but the closest I would say is Salesforce is probably close enough.

**中文翻译:**
嗯，有趣的是……特别是现在，我是说吸引了所有人想象力的是生成式 AI。所以我们应该考虑像微软旗下的 OpenAI 和 Copilot 之类的东西。嗯，也许不完全是。这取决于……从客户的角度来看，早期市场有 AI，保龄球道有 AI，鸿沟中有 AI，龙卷风中有 AI，主街上也有 AI。我是说，我认为如果你使用微软 Copilot，你就是在主街上，你没有承担任何风险，你只是在尝试新事物。这挺酷的，让你更高效，上帝保佑。这有点像 Teams 或整个 Office 365 套件的一个插件。至于现在处于龙卷风中的东西，我不知道。我在想生成式 AI 的用例是什么？我不确定在龙卷风中是否已经有一个明确的用例，但我认为最接近的可能是 Salesforce。

---

### [01:00:23] Geoffrey Moore

**English:**
They have a sales co-pilot. They have a services copilot, right? I'm sure there marketing co-pilot. So you're going, but we're going to change our sales motion and we're going to use generative AI in line, in our performance on a very widespread, across our entire base. So all our salespeople are going to use this new tool. That would be okay. And that makes sense because the new tool... First of all, Salesforce has their own large language module. So it's not like you're going out to the open AI world and having all those issues. So you can do it and there's a very high productivity return at a modest risk, I think, and modest disruption. For the bowling alley you'd say, I don't know if this is bowling alley or early market, I'll say it's bowling alley.

**中文翻译:**
他们有销售 Copilot，有服务 Copilot，对吧？我确信还有营销 Copilot。所以你会说，我们要改变我们的销售动作，我们要在大范围内、在整个基数上使用生成式 AI。所以我们所有的销售人员都要使用这个新工具。这没问题。这很合理，因为这个新工具……首先，Salesforce 有他们自己的大语言模型，所以不像你去用 OpenAI 那样会面临各种问题。所以你可以这样做，我认为在适度的风险和适度的颠覆下，会有非常高的生产力回报。对于保龄球道，你会说——我不知道这是保龄球道还是早期市场，我暂且说是保龄球道。

---

### [01:01:18] Geoffrey Moore

**English:**
So if you're Sal Khan and you have the Khan Academy and you're saying, "Look, we want to provide educational resources for the world for young people." The problem with education right now is that particularly after the pandemic, you're a teacher you used to have... When you were a teacher in say K through 12, K through eight, you have a class of 30 kids and probably 10 to 15 of them are middle of the road and some number are actually significantly ahead and some number are behind. And your job as a teacher is to kind of work with that. Well, after the pandemic, you might have five different grade levels in the same classroom, not three or six even. That's an impossible problem. But if you said, "Look, we can use Gen AI tutoring and we can tune it to each one of those sixth grade levels."

**中文翻译:**
如果你是 Sal Khan，你有可汗学院（Khan Academy），你说：“看，我们想为全世界的年轻人提供教育资源。” 现在教育的问题是，特别是在疫情之后，如果你是一名老师，以前在 K-12 或 K-8 阶段，你有一个 30 人的班级，大概 10 到 15 人是中等水平，一些人领先，一些人落后。作为老师，你的工作就是协调这些。但在疫情之后，你可能在同一个教室里有五个不同年级水平的学生，甚至不是三个，而是六个。这是一个不可能解决的问题。但如果你说：“看，我们可以使用生成式 AI 辅导，我们可以针对这六个不同水平中的每一个进行调整。”

---

### [01:02:09] Geoffrey Moore

**English:**
Now that's a teacher co-pilot, but that's a really specialized idea. So you go, "Well, that's amazing." And then if you wanted to go to the other side, "You say all these ad agencies say they do this really cool advertising, but I think I can do it myself with Gen AI and I'm going to sell it to other people." I mean, you can imagine a whole businesses that say we write legal opinions and we always start with Gen AI. We don't ship Gen AI, there's a human in the loop. We're going to do amazing or more images, maybe. We're going to design visual images with all the really cool stuff you could do. We're going to invent a new agency or a new kind of agency we're going to charge to..." I don't know what it would be, but the point is Gen AI I think can be absorbed by the marketplace at multiple places.

**中文翻译:**
现在这是一个“教师 Copilot”，但这是一个非常专业化的想法。你会觉得：“哇，太神奇了。” 然后如果你想看另一面，“你说所有这些广告公司都说他们做非常酷的广告，但我认为我自己用生成式 AI 就能做，而且我要把它卖给别人。” 我是说，你可以想象一整套业务，比如我们写法律意见书，我们总是从生成式 AI 开始。我们不直接交付 AI 生成的东西，而是有人工参与。我们可能会做更棒的图像。我们将利用所有这些酷炫的功能来设计视觉图像。我们将发明一种新的代理机构或一种新型的代理机构，我们要收费……” 我不知道那会是什么，但重点是，我认为生成式 AI 可以在市场的多个地方被吸收。

---

### [01:03:02] Lenny

**English:**
As you were talking about that lawyer example, I was thinking part of the pitch would be... And it's also a lot cheaper, but that reminds me of this other post that you wrote, The Seven Deadly Sins of Crossing the Chasm. And I wanted to chat about some of these, and one of them is discounting before you cross the chasm. Can you talk about why that's something you want to avoid?

**中文翻译:**
当你谈到律师的例子时，我在想销售话术的一部分会是……而且它也便宜得多。但这让我想起了你写的另一篇帖子，《跨越鸿沟的七宗罪》。我想聊聊其中的几条，其中之一是在跨越鸿沟之前打折。你能谈谈为什么这是要避免的吗？

---

### [01:03:20] Geoffrey Moore

**English:**
Back to that issue about, "Heart surgery 9.99, this Saturday only bring a coupon." I mean, the discounting model makes sense when something's commoditized or the let's even do the freemium model. The freemium model makes sense if there is no risk in adopting the offer. But chasms are based on risk bearing decisions. Basically that's the problem that creates the chasm. I have to make a risk bearing buying decision. So discounting does not reduce risk. In fact, it might even increase risk because this vendor might say, "Well, yeah, I'll give you a better price, but now I'm not going to give you the extra support or we'll have a change of scope." We'll say, "Yes, but now, that wasn't in the contract. So you have to add more." And all of that is fair game on Main Street, but it's not for crossing the chasm.

**中文翻译:**
回到那个问题：“心脏手术 9.99 美元，仅限本周六，凭券入场。” 我是说，当某样东西已经商品化时，打折模式是有意义的，或者甚至是免费增值模式。如果采用该方案没有风险，免费增值模式就有意义。但“鸿沟”是基于承担风险的决策。基本上，这就是造成鸿沟的问题：我必须做一个承担风险的购买决定。所以打折并不能降低风险。事实上，它甚至可能增加风险，因为供应商可能会说：“好吧，我给你一个更好的价格，但我现在不提供额外支持了，或者我们要更改范围。” 我们会说：“是的，但现在，那不在合同里，所以你得加钱。” 所有这些在主街阶段都是合理的，但不适用于跨越鸿沟。

---

### [01:04:21] Lenny

**English:**
I'm going to pick on a couple of these other sims that you mentioned. One is you call the target customer mix up. Can you talk about that?

**中文翻译:**
我要再挑几个你提到的“罪状”。一个是由于你所说的“目标客户混淆”。你能谈谈这个吗？

---

### [01:04:29] Geoffrey Moore

**English:**
The key to this whole Crossing the Chasm playbook is start with the world. Don't start with... Well, the question we're trying to answer is where is a small pool of trapped value that we can become our pool? So that's why we have geography, profession, use case. We're just trying to get big enough to matter, but small enough to lead is one. And then once you find that pool, the question you have to say is, "Who controls access to that? Who's going to sponsor my deal in order for me to solve that, to release that trapped value for that company?" That's your target customer. And you may not know them. Typically, my experience is you probably have worked with at least one company in the industry at some point along the line. It's kind of odd if you just had never heard of the industry and you picked that one.

**中文翻译:**
整套《跨越鸿沟》手册的关键是从大局出发。不要从……我们要回答的问题是：哪里有一小池被困住的价值，可以成为我们的池塘？这就是为什么我们要划分地理、职业、用例。我们只是想做到“大到足以产生影响，但小到足以取得领先”。一旦你找到了那个池塘，你必须问的问题是：“谁控制着进入那里的权限？谁会赞助我的交易，以便让我解决问题，为那家公司释放被困住的价值？” 那就是你的目标客户。你可能不认识他们。通常，根据我的经验，你可能在某个时间点与该行业的至少一家公司合作过。如果你从未听说过某个行业却选中了它，那才奇怪。

---

### [01:05:24] Geoffrey Moore

**English:**
Usually that's why I said, "Well, maybe I should have added that to how do you know you're ready to cross the chasm?" You should at least have a hunch. You should at least, "We've done this work, and I think this is the one." Now, you still have to go validate it and make it happen. But basically the way you would validate it is rather than try to go to a research or do something, that won't work. You say, "Well, we're going to run a marketing campaign, a modest one. I'm going to see if I can't get two more of the same use case. I'm willing to bet the next three months of my company by saying in this three months, all we're going to do is try to get two more deals that have this pattern." And that would be kind of the way you might go after it.

**中文翻译:**
通常这就是为什么我说：“好吧，也许我应该把它加入到‘你如何知道自己准备好跨越鸿沟’的判断标准中。” 你至少应该有一种直觉。你至少应该觉得：“我们已经做了这些工作，我认为就是这个了。” 现在，你仍然需要去验证它并让它发生。但基本上，你验证它的方式不是去做调研或别的什么，那行不通。你会说：“好吧，我们要开展一次营销活动，规模适中。我要看看能不能再拿到两个相同用例的订单。我愿意赌上公司接下来的三个月，在这三个月里，我们唯一要做的就是尝试再拿到两个符合这种模式的订单。” 这就是你可能采取的方式。

---

### [01:06:10] Lenny

**English:**
So I think this is worth spending a little more time on this idea of how you know you're ready to cross the chasm. So one is you find one very excited marquee customer, then you're sharing, maybe find a couple more and see if it's actually starting to roll and tip.

**中文翻译:**
我认为值得多花点时间讨论一下“如何知道你准备好跨越鸿沟”这个想法。一个是找到一个非常兴奋的明星客户，然后你刚才分享的，也许再找几个，看看它是否真的开始滚动并达到临界点。

---

### [01:06:26] Geoffrey Moore

**English:**
No. Well, I said it wrong. So the marquee customer is probably not in your beachhead market. The marquee customer is a famous company that you have the visionary sponsor. That's the thing, because that's the company that the business press wanted to write about, or the tech press wanted to write about. People went, "Oh, you were the guys who..." You're like Hans Solo. You did whatever that run was in 15 parsecs. I can't even remember what it was. But that's your claim to fame. It's your claim to fame. But the Crossing the Chasm one is, "Oh..." And by the way the press is not interested in the crossing chasm, but the local, if there was a local press, they'd be all over it.

**中文翻译:**
不，嗯，我说错了。明星客户可能不在你的滩头阵地市场。明星客户是一家著名的公司，你拥有那里的远见型赞助人。重点在于，那是商业媒体或科技媒体想要报道的公司。人们会惊叹：“噢，你们就是那帮……” 你就像韩·索罗（Han Solo），你在 15 秒差距内完成了那次航行。我甚至不记得那是什么了。但那是你的成名作，是你的名片。但跨越鸿沟的那个是，“噢……” 顺便说一下，媒体对跨越鸿沟不感兴趣，但如果是地方媒体，他们会争相报道。

---

### [01:07:08] Lenny

**English:**
The Kessel Run.

**中文翻译:**
凯塞尔航程（The Kessel Run）。

---

### [01:07:11] Geoffrey Moore

**English:**
The Kessel Run. Thank you. The Kessel Run in 15 parsecs. Thank you.

**中文翻译:**
凯塞尔航程。谢谢。15 秒差距内的凯塞尔航程。谢谢。

---

### [01:07:13] Lenny

**English:**
That's right.

**中文翻译:**
没错。

---

### [01:07:14] Geoffrey Moore

**English:**
Exactly. That was his visionary thing.

**中文翻译:**
没错，那是他的远见之举。

---

### [01:07:16] Lenny

**English:**
So I think the important takeaway there is there's always this advice of talk to customers, make sure they're happy, build what... Not necessarily build what they want, but make sure you're understanding what they need. But I think when your most important insights here is make sure you're talking to the right people. Which are essentially people in the next stage, essentially of the adoption life cycle. The more pragmatists.

**中文翻译:**
所以我认为这里重要的启示是：总有建议说要与客户交谈，确保他们开心，构建……不一定是构建他们想要的，但要确保你理解他们的需求。但我认为你这里最重要的见解之一是：确保你在与“正确的人”交谈。这些人本质上是处于采用生命周期下一个阶段的人，也就是更多的实用主义者。

---

### [01:07:35] Geoffrey Moore

**English:**
Yes. And they have to be the... I think you need to talk to the economic buyer as opposed to the end user, because the end user will be saying, "Oh, yeah, you're right. Oh, it's just terrible and we're oppressed." But if their boss doesn't want to sponsor it, it doesn't work.

**中文翻译:**
是的。而且他们必须是……我认为你需要与“经济决策者”（economic buyer）交谈，而不是最终用户。因为最终用户会说：“噢，是的，你说得对。噢，这太糟糕了，我们受够了。” 但如果他们的老板不想赞助这件事，那就行不通。

---

### [01:07:51] Lenny

**English:**
Which is hard, hard often when you're building B2B software, you just don't make it great. And then it's like, "Oh, these people don't actually care what they're buying it. They just have all these check boxes." And then another deadly sin, which you've touched on, but I think it might be worth sharing again, is just this idea, you call it the compelling reason, confusion, where instead of thinking about your compelling reason to sell, you think about what is the pain point you're solving, compelling reason to buy.

**中文翻译:**
这很难，当你开发 B2B 软件时，你很难把它做得非常出色。然后就像是：“噢，这些人其实并不在乎他们买的是什么，他们只是有一堆要勾选的选项。” 还有另一个“致命罪状”，你已经提到了，但我认为值得再次分享，就是你所说的“迫切理由混淆”：你不再考虑你迫切的销售理由，而是考虑你正在解决的痛苦点，即迫切的购买理由。

---

### [01:08:16] Geoffrey Moore

**English:**
Obviously as an entrepreneur, you have a compelling reason to sell. But what they tend to do is in trying to cross the chasm, if they're not using this approach, they think, "Well, I haven't made my product attractive enough." So then they'd say, "Well, I'm going to make a sexier demo, or I'm going to change my deck. I'm going to write a new..." And the sales guy comes back, says, "I had a great presentation. This is the deck that we ought to be using." And that's all about compelling ways to sell, not compelling reasons to buy. And the pragmatist, by the way... And by the way, the practice will take the meeting. One of the problems with the chasm is they don't say no. They just never say yes. And they actually encourage you... "You should come back again with this too. This is really interesting." Yeah, it is really interesting.

**中文翻译:**
显然，作为一名企业家，你有一个迫切的销售理由。但他们在尝试跨越鸿沟时，如果不采用这种方法，往往会想：“嗯，我还没让我的产品足够有吸引力。” 于是他们会说：“好吧，我要做一个更性感的演示，或者我要改改我的 PPT，我要写一个新的……” 销售人员回来后说：“我做了一次很棒的演讲，这就是我们应该用的 PPT。” 而这些都是关于迫切的“销售方式”，而不是迫切的“购买理由”。顺便说一下，实用主义者会愿意和你见面。鸿沟的问题之一是他们不拒绝，但他们也永远不说“好”。他们甚至会鼓励你：“你应该再带着这个来找我们，这真的很有趣。” 是的，确实很有趣。

---

### [01:09:09] Lenny

**English:**
Kind of along those lines, positioning, how important is that, and any advice on figuring out your positioning when you're doing this? I know you talk a lot about making sure you focus on their pain point, but at some point you're like, "Here's what we're doing for you."

**中文翻译:**
顺着这个思路，定位（positioning）有多重要？在做这件事时，关于确定定位你有什么建议吗？我知道你谈了很多关于确保关注他们的痛苦点，但在某个时刻你会说：“这就是我们为你做的。”

---

### [01:09:22] Geoffrey Moore

**English:**
One of the nice things about Crossing the Chasm is the positioning formula is absolutely the same every time. It's really cool. So basically when you're thinking about positioning, you're saying, "Look, I'm going with this use case in this particular segment." So they have an incumbent vendor. The advantage of the incumbent vendor is they understand the business, but they don't have the new technology. Conversely, you have technology competitors who have as good technology, maybe a better technology than you have, but they're not committed to this domain expertise of this thing.

**中文翻译:**
《跨越鸿沟》的一大优点是，定位公式每次都是完全一样的。这真的很酷。基本上，当你思考定位时，你会说：“看，我要在这个特定的细分市场中推广这个用例。” 他们有一个现有的供应商。现有供应商的优势是他们了解业务，但他们没有新技术。相反，你有技术竞争对手，他们的技术和你一样好，甚至比你更好，但他们没有致力于这个领域的专业知识。

---

### [01:09:56] Geoffrey Moore

**English:**
So your positioning is, "We are the technology leaders who have specialized and committed to solve this problem. And by the way, we have huge respect for your incumbent vendor. We're not asking you to kick them out. They just can't solve this problem. We also have respect for our peers, but frankly, they wouldn't know your problem if they wouldn't recognize it in a lineup. We are here, and by the way, if anybody comes into our quadrant, we're going to kick their ass. We are going to be beyond compare. Nobody is going to handle this problem with this kind of technology the way we will, and that's our claim of fame. That's what we're going to do, and that's our positioning."

**中文翻译:**
所以你的定位是：“我们是技术领导者，我们专门致力于解决这个问题。顺便说一下，我们非常尊重你们现有的供应商，我们不是要求你们把他们踢走，他们只是无法解决这个问题。我们也尊重我们的同行，但坦率地说，他们根本不了解你们的问题。我们就在这里，顺便说一下，如果有人进入我们的领地，我们会把他们打得落花流水。我们将是无与伦比的。没有人能像我们这样用这种技术处理这个问题，这就是我们的成名之作。这就是我们要做的，这就是我们的定位。”

---

### [01:10:36] Lenny

**English:**
I love that. Say you're building a product led growth company, a bottom up oriented B2B SaaS company. Is there anything that changes in your advice?

**中文翻译:**
我喜欢这个。假设你正在建立一家产品驱动增长（PLG）公司，一家自下而上的 B2B SaaS 公司。你的建议会有什么变化吗？

---

### [01:10:46] Geoffrey Moore

**English:**
Yeah, if you're going to use a volume ups approach like Atlassian or anything grows up from the bottom up, you're playing a different game. First of all, you're playing... Because you attract the end user before you attract the economic buyer. So you have some version of a freemium strategy, that's what you're going to do. And Yammer did this, right? And eventually got bought by Microsoft. So the way you play that game is, first of all, you probably do need some funding, not necessarily, maybe you can do this all on AWS and a credit card. But the game that is going to be, how do I create that moment of criticality? What you would do is you'd say... First of all, you need telemetry. So you need to figure out what are the people really doing with our product? And then you need to find a way to communicate with them to see if you can ferret out, is there a compelling reason to buy thing in their environment? So it'd be a different way of doing early market.

**中文翻译:**
是的，如果你要使用像 Atlassian 那样自下而上的规模化方法，你玩的是另一种游戏。首先，因为你在吸引经济决策者之前先吸引了最终用户。所以你会采用某种版本的免费增值策略。Yammer 就是这么做的，对吧？最终被微软收购了。所以你玩那个游戏的方式是：首先，你可能确实需要一些资金，但不一定，也许你可以在 AWS 上刷信用卡就能搞定。但游戏的重点在于：我如何创造那个“关键时刻”？你会做的是……首先，你需要遥测数据（telemetry），你需要弄清楚人们到底在用你的产品做什么。然后你需要找到一种与他们沟通的方式，看看你是否能挖掘出在他们的环境中是否存在一个迫切的购买理由。所以这是一种不同的早期市场玩法。

---

### [01:11:52] Geoffrey Moore

**English:**
You would not have a marquee client, but to cross the chasm... You cannot cross the chasm of product-led growth, you can't because it is like saying, "Well, yeah, I'm going to cure Covid by just putting vaccines out in public places." It's like, "No, people need to learn more. No." So you'd have to do that. Where product-led growth plays really interestingly, is in the land and expand phases of the market. If you can land with a hot product, but more importantly, product-led growth, which is really good at is expand because it prompts the user to get more involved. And that's classically a Main Street play. But there's got to be no risk. That product-led growth works when basically the extended the next purchase has very low risk, and therefore you're not really dealing with chasms.

**中文翻译:**
你不会有一个明星客户，但要跨越鸿沟……你无法通过产品驱动增长来跨越鸿沟，你做不到。因为这就像说：“好吧，我要通过在公共场所放置疫苗来治愈新冠。” 并不是这样，人们需要了解更多。所以你必须那样做。产品驱动增长发挥作用的地方非常有趣，是在市场的“占领与扩张”（land and expand）阶段。如果你能用一个热门产品占领市场，但更重要的是，产品驱动增长真正擅长的是“扩张”，因为它会促使用户更多地参与进来。这在典型意义上是主街阶段的玩法。但前提是必须没有风险。产品驱动增长之所以有效，是因为下一次购买的风险非常低，因此你实际上并不是在处理“鸿沟”问题。

---

### [01:12:53] Lenny

**English:**
That is incredibly interesting. Interestingly, every product led growth company ends up building a sales team, 100% of them, including Atlassian, which had product led growth for a long time. And I don't know if anyone's heard this perspective on it, that if you really want to cross the gap... I imagine it happens in some form of-

**中文翻译:**
这非常有趣。有趣的是，每一家产品驱动增长的公司最终都会建立销售团队，100% 都是如此，包括长期坚持 PLG 的 Atlassian。我不知道是否有人听过这种观点：如果你真的想跨越鸿沟……我猜它会以某种形式发生——

---

### [01:13:12] Geoffrey Moore

**English:**
Well, and here's the thing. The reason they build a sales team eventually is they need to get enterprise deals. And obviously you need a sales team to get enterprise deals. And one of the mistakes you could make is hiring an enterprise salesperson when you're trying to cross the chasm. Enterprise salespeople are not good chasm crossers because they're used to doing horizontal coverage model. This is like no, domain expert narrow model. You want somebody that looks more like a sales engineer than a salesperson. You want somebody very diagnostic, very committed to the integrity of the problem solution framework. So it's just different.

**中文翻译:**
嗯，情况是这样的。他们最终建立销售团队的原因是他们需要拿下企业级订单。显然，你需要销售团队来获得企业订单。而在尝试跨越鸿沟时，你可能犯的一个错误就是雇佣一名“企业级销售人员”。企业级销售人员并不是好的“鸿沟跨越者”，因为他们习惯于做横向覆盖模型。而跨越鸿沟需要的是领域专家、窄众模型。你需要一个看起来更像“销售工程师”而不是销售员的人。你需要一个非常有诊断能力、非常致力于问题-解决方案框架完整性的人。所以这完全不同。

---

### [01:13:54] Lenny

**English:**
Okay. Just a couple more questions. You had this very public exchange with Martin Casado, he's a partner at Andreessen Horowitz. And just to summarize briefly, essentially he was arguing that I think some people believe once you've crossed the chasm, life's good. It's all downhill. People are going to start pulling your product out of you. It's going to be so easy. And his argument is he doesn't see that, it's endless pain and suffering and hardships. And I know you went back and forth trying to correct this, but what's a way to think about what happens?

**中文翻译:**
好。最后还有几个问题。你曾与 Andreessen Horowitz 的合伙人 Martin Casado 进行过一次非常公开的交流。简要总结一下，他本质上的论点是：他认为有些人相信一旦跨越了鸿沟，生活就会变得美好，一切都会顺风顺水，人们会开始抢购你的产品，一切都会变得非常容易。而他的观点是，他没看到这种情况，反而是无尽的痛苦、折磨和艰辛。我知道你们来回讨论试图纠正这一点，但关于跨越鸿沟后会发生什么，有什么思考方式吗？

---

### [01:14:25] Geoffrey Moore

**English:**
So actually, Martin and I had a couple of this... By the way, his biggest point... I'll come back to your point in a second, but his biggest point is, "Jeff..." The venture community at least, and certainly Andreessen Horowitz doesn't deal with the level of granularity of Crossing the Chasm anymore. There's too much money that wants to be put to work. By the way, there's so much software already out there that the notion that your software is going to be that disruptive is increasingly improbable because you're not standing on the shoulders of giants, you're standing on the shoulders of people standing on the shoulders of people standing on the shoulders of people standing on the shoulders of giants. So he was making a bunch of those points, which I thought were pretty interesting. But his other point about, does life ever become easy? No, life never becomes easy. The problems change.

**中文翻译:**
事实上，Martin 和我讨论过几次……顺便说一下，他最大的观点是——我等下再回到你的问题——他最大的观点是：“Jeff，风投界，至少是 Andreessen Horowitz，不再处理《跨越鸿沟》这种细粒度的问题了。” 有太多的资金想要投入使用。顺便说一下，现在已经有太多的软件了，你的软件能具有那种颠覆性的想法正变得越来越不可能，因为你不是站在巨人的肩膀上，你是站在“站在‘站在‘站在巨人肩膀上的人’肩膀上的人’肩膀上的人”的肩膀上。他提出了一系列这样的观点，我觉得挺有趣的。但关于生活是否会变得容易，他的另一点是：不，生活永远不会变得容易。只是问题变了。

---

### [01:15:17] Geoffrey Moore

**English:**
The challenge with software is... Well, there's a lot of challenges with it, but software that people use, the application software, we all have different minds. We all have different contexts. To make a product that would work, that would solve what I want and solve what you want and solve what the listener wants. I mean, the margin, no. We're going to have different expectations. So there's always... And then of course there's competition, and then there's funding, and then there's technological shifts, and just about the time it really works well, they say, "No, we got to put it... No, no, no. You put it in the data center. We got to put it in the cloud." "Oh, no, no, you got in the cloud, you got to put it in Kubernetes." "Oh, no, no, no. You don't understand. It's edge AI, it's not cloud." It just goes on and on and on. So I think if you're going to play this game, you got to be up for... Yeah, there's going to be a new headache every week.

**中文翻译:**
软件的挑战在于……嗯，有很多挑战，但人们使用的软件，即应用软件，我们都有不同的想法，都有不同的背景。要做出一个既能解决我的需求，又能解决你的需求，还能解决听众需求的产……我是说，利润空间，不。我们会有不同的期望。所以总会有……当然还有竞争，还有融资，还有技术变革。就在它运行得非常好的时候，他们会说：“不，我们得把它……不不不，你把它放在数据中心了，我们得把它放进云端。” “噢，不不，你放进云端了，你得把它放进 Kubernetes。” “噢，不不不，你不明白，现在是边缘 AI，不是云。” 这种循环没完没了。所以我想如果你要玩这个游戏，你必须准备好……是的，每周都会有新的头痛事。

---

### [01:16:17] Lenny

**English:**
That's exactly how I see it. I always tell founders, you shouldn't start a company unless you can't not start a company.

**中文翻译:**
这正是我所看到的。我总是告诉创始人，除非你到了“不得不创业”的地步，否则你不应该创业。

---

### [01:16:23] Geoffrey Moore

**English:**
Yes. By the way, why did I leave? [inaudible 01:16:28] County was a great place to be, but I had to do my own thing.

**中文翻译:**
是的。顺便说一下，我为什么要离开？Regis McKenna 是个很棒的地方，但我必须做我自己的事情。

---

### [01:16:32] Lenny

**English:**
And that's a real pull. Kind of along the lines of something you just shared, maybe a final question. Is there something you've changed your mind about or something you've evolved your thinking on recently? Either from the beginning of the book or just even more recent?

**中文翻译:**
这是一种真正的拉力。顺着你刚才分享的内容，最后一个问题。有没有什么事情是你最近改变了主意，或者你的想法有了新的演变？无论是从书出版之初到现在，还是最近的事情？

---

### [01:16:47] Geoffrey Moore

**English:**
I think what I realized over time increasingly was this is a model that's really optimized for B2B markets, because it implies federated decision making around high risk buying decisions. I would say for the 20th century, that was 95% of tech. But what was so interesting about the change in the century... Because remember right at the change of the century, B2B tech went in the tank, the tech bubble just... Because everybody was afraid of the Y2K problem. So they did a whole bunch of buying up of software, and then there was a year where they think, "Well, we ate more than we could at Thanksgiving dinner. We're not interested in eating another burger here. "So the market went in the tank. By the way at that point, venture started saying, "Well, maybe we should be investing in biotech, or maybe we should doing clean tech." Venture stepped back from the table too.

**中文翻译:**
我想随着时间的推移，我越来越意识到这是一个真正为 B2B 市场优化的模型，因为它暗示了围绕高风险购买决策的联邦式决策过程。我会说，在 20 世纪，95% 的科技都是这样的。但世纪之交发生的转变非常有趣……因为记得就在世纪之交，B2B 科技陷入了低谷，科技泡沫破裂了……因为每个人都害怕千年虫（Y2K）问题。所以他们大量采购软件，然后有一年他们觉得：“好吧，我们在感恩节晚餐上吃得太饱了，我们没兴趣再吃一个汉堡了。” 于是市场陷入了低谷。顺便说一下，在那时，风投开始说：“好吧，也许我们应该投资生物技术，或者也许我们应该做清洁能源。” 风投也从桌子旁退缩了。

---

### [01:17:46] Geoffrey Moore

**English:**
But out of this, consumer computing came out of nowhere. And for my generation, it was unimaginable. The first time I heard about Google and they said, "We're going to save every search argument." I thought, "That's the dumbest thing I've ever heard in my life. They're not going to be able to afford it." But their model was, "We are rethinking this thing from the ground up. Geoffrey, you have no idea what we're doing." And boy were they right. So the point was when that came in, then consumer computing and then the iPhone hits, and then we have mobile apps. You have a world now where the B2C play can actually be the core of innovation. It used to be B2C was an afterthought. Now it's like, "No, no, no, no, B2B might be the afterthought." So it's completely different... And the whole digital transformation of the universe, and we're still living through the digital transformation 20 years in, and I don't think Crossing the Chasm is designed for that problem. So that's a different problem.

**中文翻译:**
但就在这时，消费者计算凭空出现了。对于我这一代人来说，那是不可想象的。我第一次听说 Google 时，他们说：“我们要保存每一个搜索参数。” 我想：“这是我这辈子听过的最愚蠢的事情，他们根本负担不起。” 但他们的模式是：“我们正在从头开始重新思考这件事。Geoffrey，你根本不知道我们在做什么。” 噢，他们是对的。所以重点是，当那个时代到来，消费者计算兴起，然后 iPhone 问世，接着我们有了移动应用。你现在处于一个 B2C 玩法实际上可以成为创新核心的世界。以前 B2C 是事后才考虑的，现在变成了：“不不不，B2B 可能是事后才考虑的。” 所以这完全不同……整个宇宙的数字化转型，20 年后我们仍然生活在数字化转型中，而我认为《跨越鸿沟》并不是为那个问题设计的。所以那是另一个问题。

---

### [01:18:48] Lenny

**English:**
So basically, if you're building a consumer app, don't spend time studying Crossing the Chasm.

**中文翻译:**
所以基本上，如果你在开发一款消费者应用，就不要花时间研究《跨越鸿沟》了。

---

### [01:18:53] Geoffrey Moore

**English:**
Yeah, if you're doing B2B, this is the most reliable playbook. It's still on... People are still into this playbook 30 years in. So it's obviously... The playbook kind of works.

**中文翻译:**
是的，如果你在做 B2B，这是最可靠的手册。30 年后，人们依然热衷于这套手册。所以显然……这套手册是有效的。

---

### [01:19:05] Lenny

**English:**
I said this earlier, I feel like people are just reinventing many of the things you uncovered 30 years ago. Everyone's like, "Oh yeah, target audience, really important, or finding a marque customer." So I'm really happy that we spent this time digging into many of your theories.

**中文翻译:**
我之前说过，我觉得人们只是在重新发明你 30 年前发现的许多东西。每个人都在说：“噢是的，目标受众非常重要，或者寻找明星客户。” 所以我很高兴我们花了这段时间深入探讨你的许多理论。

---

### [01:19:22] Geoffrey Moore

**English:**
Well, Lenny, thank you for being... You've been a really great prompter and questioner, so thank you very, very much.

**中文翻译:**
Lenny，谢谢你……你是一个非常棒的引导者和提问者，非常非常感谢。

---

### [01:19:28] Lenny

**English:**
I really, really appreciate that. Is there anything you want to leave listeners with as a final thought or piece of advice or just anything?

**中文翻译:**
我非常非常感激。你有什么最后的想法或建议想留给听众吗？

---

### [01:19:35] Geoffrey Moore

**English:**
Look, I don't know if anybody's reading the paper recently, but the world's not exactly nailing it right now. There's a lot of stuff going on that we could do a lot better, and software enabled technology is almost certainly at the core of any solution that scales to any world problem that matters. I think it's more important to be an entrepreneur now than maybe ever. I wouldn't make becoming a billionaire my goal. Frankly, I don't even know what a billionaire would even do with their money. I don't even how to even imagine their money. That's a thousand million dollars. It doesn't make any sense, but what does make sense? But what does make sense is to... I'm happy to get two... Do I know what to do with 10 million? Yeah. Could I do 20? Probably. Could I use a hundred? Probably not. But at some point, I want people to make yourself a great living, make yourself... But after that, have an impact. If you're gifted enough to be able to start a software company and do something original, you're a scarce resource, so don't waste it.

**中文翻译:**
听着，我不知道最近有没有人看报纸，但现在的世界状况并不理想。有很多事情我们可以做得更好，而软件驱动的技术几乎肯定是任何能够扩展并解决重大世界问题的核心。我认为现在成为一名企业家比以往任何时候都更重要。我不会把成为亿万富翁作为目标。坦率地说，我甚至不知道亿万富翁会拿他们的钱做什么，我甚至无法想象那笔钱。那是十个亿。这没有任何意义。但什么是有意义的呢？有意义的是……我很乐意拿到两……我知道拿 1000 万做什么吗？是的。2000 万呢？可能也行。1 亿呢？可能就不行了。但在某个点上，我希望人们能让自己过上优渥的生活，让自己……但除此之外，要产生影响力。如果你有天赋去创办一家软件公司并做一些原创的事情，你就是一种稀缺资源，所以不要浪费它。

---

### [01:20:42] Lenny

**English:**
Amazing. I'm going to sneak it one more question along these same lines actually. Your last book is very unlike all your other books. It's called The Infinite Staircase, which is essentially a guide to living a good life and a meaningful life. Is there maybe one piece of advice you could share with folks of just how to live a better life, a more meaningful life, happier life?

**中文翻译:**
太棒了。实际上我想顺着这个思路再追问一个问题。你的最后一本书和你其他的书非常不同，叫《无限阶梯》（The Infinite Staircase），它本质上是一本关于如何过上美好且有意义生活的指南。你能不能分享一条建议，关于如何过上更好、更有意义、更快乐的生活？

---

### [01:21:00] Geoffrey Moore

**English:**
The purpose of that book was twofold. One was... So I was looking around... And this is an American sort of experience between social media and the politicians or whatever. Our ability to defend traditional values is becoming increasingly challenging. And historically, you say, "Well, religion was sort of the place where the foundation for solidifying traditional values." But in my lifetime, the counter explanation of how we got here, other than being created by a creator, this whole the Big Bang and the Darwinian model, it's becoming increasingly credible and I'm fascinated by it. So the question I had in the back of my mind is how could you take that model and still support traditional ethics?

**中文翻译:**
那本书的目的有两个。一个是……我环顾四周……这是一种美国的经历，在社交媒体和政治人物之间。我们捍卫传统价值的能力正变得越来越具有挑战性。从历史上看，你会说：“宗教曾是巩固传统价值的基础。” 但在我的一生中，关于我们如何来到这里的另一种解释——除了被造物主创造之外，整个大爆炸和达尔文模型——正变得越来越可信，我也为此着迷。所以我脑海中一直有一个问题：你如何既接受那个模型，又仍然支持传统的伦理道德？

---

### [01:21:53] Geoffrey Moore

**English:**
So the first part was, well, what's the model? It turns out to explain getting from the Big Bang to Lenny and Geoffrey talking on this podcast, there's a lot of steps you've got to go through. But there's a whole thing about complexity and how complexity emerges in layers and the staircase is a series of layers, and the first two thirds of the book takes 11 stairs. That gets you from physics to theory. And it's like, really? Yeah, yeah. From a cloud of atoms to us talking about Crossing the Chasm, 11 steps, we can get you there. It's kind of fun. It's assembling the last 25 years of my reading. It's fascinating stuff. All these different topics, and I was just trying to knit it together. No original research. I was just literally just trying to get the story together.

**中文翻译:**
所以第一部分是，那个模型是什么？事实证明，要解释从大爆炸到 Lenny 和 Geoffrey 在这个播客上聊天，你需要经历很多步骤。这里涉及复杂性以及复杂性如何分层出现，“阶梯”就是一系列的层级。书的前三分之二涵盖了 11 个台阶，带你从物理学走向理论。你会觉得，真的吗？是的，从一团原子到我们讨论《跨越鸿沟》，11 个步骤，我们就能带你到达那里。这挺有趣的，它汇集了我过去 25 年的阅读成果。这些都是非常迷人的东西，涵盖了所有这些不同的主题，我只是试图把它们编织在一起。没有原创研究，我只是字面意思上地试图把这个故事串联起来。

---

### [01:22:41] Geoffrey Moore

**English:**
But then the last third was, okay, that's a very reasonable narrative. It's maybe even more reasonable than religious narratives, but now how do you validate ethical action and where does it come from? So the last part was about, okay, how do you do that? How does it derive from that creation story? The secular creation stories were. So that was what was important. At the end of the day, I think the message of that book is just, you really do need to do good, but it's not because you're obeying... In this framework, it's not because you're a bang a divine creator. It's because we're mammals and mammals nurture their young, and we were gifted with unconditional love when we were born because otherwise, you and I could not be here. I mean, a 1-year-old cannot... If somebody doesn't love the hell out of a 1-year-old, they're not going to be two. So we know where we started. So come on, those values were built into us. They don't have to come from above. They can come from below, and therefore, how can you integrate them into your life? And that was where the book... Anyway.

**中文翻译:**
但最后三分之一是：好吧，这是一个非常合理的叙事，甚至可能比宗教叙事更合理。但现在你如何验证伦理行为，它又从何而来？所以最后一部分是关于：好吧，你该怎么做？它是如何从那个创世故事中衍生出来的？即世俗的创世故事。这就是重点。归根结底，我认为那本书传达的信息是：你确实需要行善，但这并不是因为你在服从……在这个框架中，不是因为你在服从一个神圣的造物主。而是因为我们是哺乳动物，哺乳动物会抚育后代。我们出生时就被赋予了无条件的爱，否则你和我都不可能站在这里。我是说，一个 1 岁的孩子……如果没有人拼命爱着一个 1 岁的孩子，他活不到 2 岁。所以我们知道我们的起点。所以，来吧，这些价值观是内置在我们体内的。它们不必来自上方，它们可以来自下方。因此，你如何将它们融入你的生活？这就是那本书的……总之。

---

### [01:23:53] Lenny

**English:**
That is a beautiful message to end on. I promised I'd get you out of here in one minute. Just to let people know, you do speaking, you do consulting, where can people find you online if they want to reach out and- [inaudible 01:24:05]

**中文翻译:**
这是一个非常美丽的结尾。我承诺过一分钟内让你结束。只是想让大家知道，你做演讲，也做咨询，如果人们想联系你，可以在哪里找到你？

---

### [01:24:05] Geoffrey Moore

**English:**
LinkedIn. Yeah, I'm on LinkedIn and I have a blog on LinkedIn. And if these topics are interesting to you, you'd probably be interested in the blog.

**中文翻译:**
LinkedIn。是的，我在 LinkedIn 上，我在那里有一个博客。如果你对这些话题感兴趣，你可能会对那个博客感兴趣。

---

### [01:24:13] Lenny

**English:**
And then message you on LinkedIn would be the idea?

**中文翻译:**
所以直接在 LinkedIn 上给你发消息就行？

---

### [01:24:15] Geoffrey Moore

**English:**
Exactly. Absolutely.

**中文翻译:**
没错，绝对可以。

---

### [01:24:16] Lenny

**English:**
Easy. Geoffrey, thank you so much for being here.

**中文翻译:**
太好了。Geoffrey，非常感谢你能来。

---

### [01:24:19] Geoffrey Moore

**English:**
Well, thank you, Lenny. It was a pleasure.

**中文翻译:**
谢谢你，Lenny。很愉快。

---

### [01:24:22] Lenny

**English:**
It was my pleasure. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
这是我的荣幸。大家再见。非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。