# Gergely - 双语对照

This is the complete bilingual transcript for **Lenny's Podcast** featuring **Gergely Orosz**.

---

### [00:00:00] Gergely Orosz

**English:**
In my best year at Uber, I made about 320 or $330,000 in total compensation. And when I quit my job, I was actually thinking, am I crazy? Because I am leaving... Especially in Europe, this is a lot of money [inaudible 00:00:14] this will be similar to something... Someone in a similar position would've made five or 600K in total in the U.S. But now I am making more in compensation that I made at Uber. And the difference is that now my compensation... Well, my earnings keep going up as long as the newsletter is growing, so there's no theoretical cap on this. Of course there's an actual cap, there's churn, growth is slowing over time. But it's very, very strange, because I felt that I was in a really privileged position, just honestly making tons of money, doing a job that I loved. And this was at Uber or as a software engineer. And I'm now doing stuff that I love, and in some strange way, I guess it even pays better.

**中文翻译:**
在我在 Uber 表现最好的一年里，我的总薪酬（Total Compensation）大约是 32 万或 33 万美元。当我辞职时，我其实在想，我是不是疯了？因为我正在离开……尤其是在欧洲，这是一大笔钱，这相当于在美国担任类似职位的人能拿到的 50 万或 60 万美元的总薪酬。但现在，我获得的报酬已经超过了我在 Uber 时的收入。不同之处在于，现在我的报酬……嗯，只要 Newsletter（时事通讯）在增长，我的收入就会持续上升，所以理论上没有上限。当然，实际上是有上限的，会有用户流失，增长也会随时间放缓。但这感觉非常、非常奇妙，因为我曾觉得自己处于一个非常优越的位置，坦白说，赚着大钱，做着自己喜欢的工作。那是在 Uber 担任软件工程师的时候。而现在我依然在做我热爱的事情，而且以某种奇妙的方式，报酬甚至更高了。

---

### [00:00:59] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny, and my goal here is to help you get better at the craft of building and growing products. I interview world class product leaders and growth experts to learn from their hard won experiences building and scaling today's most successful companies. Today my guest is Gergely Orosz. In a sense, Gergely is the me of engineering. He's got the top engineering newsletter on Substack, it's growing really fast, and like me, he does this full time. In this episode, we talk about the life of newslettering full time, like we both do. We get into Gergely's decision to leave his cushy tech job at Uber, to go into this life full-time, what the day-to-day life of a newsletter person is, the pros and cons of this life, what it takes to be successful, and a bunch of advice for how to get started if you're curious about going down this route. This is a pretty unique episode, and it was really fun to do. If you ever thought about writing or going down this creator route, you'll love this episode. With that, I bring you Gergely Orosz.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你更好地掌握构建和增长产品的技能。我采访世界级的产品领导者和增长专家，从他们构建和扩展当今最成功公司的宝贵经验中学习。今天的嘉宾是 Gergely Orosz。在某种意义上，Gergely 就是工程界的“我”。他在 Substack 上拥有排名第一的工程类 Newsletter，增长非常快，而且和我一样，他是全职在做这件事。在本期节目中，我们将探讨像我们两人这样全职从事 Newsletter 创作的生活。我们会深入探讨 Gergely 决定离开他在 Uber 优渥的科技工作、全职投入这种生活的初衷，Newsletter 创作者的日常生活是怎样的，这种生活的优缺点，成功的要素，以及如果你好奇并想走这条路，该如何开始的一系列建议。这是一集非常独特的节目，做起来非常有趣。如果你曾考虑过写作或走创作者这条路，你会喜欢这一集的。下面，让我们欢迎 Gergely Orosz。

---

### [00:02:06] Lenny

**English:**
This episode is brought to you by lemon.io. You've achieved product market fit. You're able to activate, engage, and retain your customers. But you don't have the engineers that you need to move as fast as you want to, because it's hard to find great engineers quickly, especially if you're trying to protect your burden rate. Meet lemon.io. Lemon.io will quickly match you with skilled senior developers who are all vetted, results oriented, and ready to help you grow. And all that at competitive rates. Startups choose lemon.io because they offer only hand-picked developers with three or more years of experience and strong proven portfolios. Only 1% of candidates who apply get in, so you can be sure that they offer you only high quality talent. And if something ever goes wrong, lemon.io offers you a swift replacement, so that you're kind of hiring with a warranty.

**中文翻译:**
本期节目由 lemon.io 赞助。你已经实现了产品市场匹配（PMF）。你能够激活、吸引并留住客户。但你没有足够的工程师来达到你想要的速度，因为很难快速找到优秀的工程师，尤其是当你试图控制人力成本（Burden Rate）时。试试 lemon.io 吧。Lemon.io 会为你快速匹配经过审核、以结果为导向、并准备好帮助你增长的资深开发人员。而且价格极具竞争力。初创公司选择 lemon.io 是因为他们只提供经过挑选、拥有三年以上经验且有强大作品集的开发人员。只有 1% 的申请者能入选，因此你可以确信他们提供的是高质量人才。如果出现任何问题，lemon.io 还会提供快速更换，让你在招聘时拥有一种“保修”服务。

---

### [00:02:55] Lenny

**English:**
To learn more, just go to lemon.io/lenny and find your perfect developer or tech team in 48 hours or less. And if you start the process now, you can claim a special discount exclusively for Lenny's Podcast listeners. 15% off your first four weeks of working with your new software developer. Grow faster with an extra pair of hands. Visit lemon.io/lenny.

**中文翻译:**
欲了解更多信息，请访问 lemon.io/lenny，在 48 小时或更短时间内找到理想的开发人员或技术团队。如果你现在开始流程，还可以领取 Lenny 播客听众专属的特别折扣：与新软件开发人员合作的前四周可享受 15% 的优惠。借助额外的帮手实现更快增长。请访问 lemon.io/lenny。

---

### [00:03:20] Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing platform built by Airbnb alums for modern growth teams. Companies like Netlify and Tenfold and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern growth team stack. This leads to wasted time building internal tools, or trying to run your experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved about our experimentation platform was being able to easily slice results by device, by country, and by [inaudible 00:03:56]. Eppo does all that and more, delivering results quickly, avoiding annoying prolonged analytics cycles, and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic clickthrough metrics, and instead use your North Star metrics like activation, retention, subscriptions, and payments. And Eppo supports tests on the front end, the back end, email marketing, and even machine learning clients. Check out Eppo at geteppo.com, get E-P-P-O.com, and 10x your experiment velocity.

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 A/B 测试平台。Netlify、Tenfold 和 Cameo 等公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能与现代增长团队的技术栈完美集成。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具运行实验。当我在 Airbnb 时，我最喜欢我们的实验平台的一点是，能够轻松地按设备、国家和 [听不清] 来切分结果。Eppo 不仅能做到这些，还能快速交付结果，避免烦人且漫长的分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基本的点击率指标，转而使用你的北极星指标（North Star metrics），如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。请访问 geteppo.com（G-E-T-E-P-P-O.com）查看 Eppo，让你的实验速度提升 10 倍。

---

### [00:04:28] Lenny

**English:**
Gergely, welcome to the podcast.

**中文翻译:**
Gergely，欢迎来到播客。

---

### [00:04:35] Gergely Orosz

**English:**
It's awesome. Great to be here, Lenny.

**中文翻译:**
太棒了。很高兴来到这里，Lenny。

---

### [00:04:36] Lenny

**English:**
So I think this is going to be a pretty special and unique podcast. Your newsletter is the number one technology newsletter on Substack, called the Pragmatic Engineer, by the way. My newsletter is the number one business newsletter on Substack, and so we're connected in this really special, weird way, and I thought it would be pretty fun to just explore this weird path that we're on doing this newsletter thing, and in that, help listeners understand the pros and cons of this life, how to go down this route, what it takes to be successful, all that stuff. But before we get into all that, I'd love for you to spend maybe a minute just giving us a little overview of your career, and how you got to where you are today doing this newsletter, and what you spend your time on now.

**中文翻译:**
所以我认为这将是一期非常特别且独特的播客。顺便说一下，你的 Newsletter 是 Substack 上排名第一的科技类通讯，叫作《The Pragmatic Engineer》（务实的工程师）。而我的 Newsletter 是 Substack 上排名第一的商业类通讯，所以我们以这种非常特别、奇妙的方式联系在了一起。我觉得探索一下我们正在走的这条奇特的 Newsletter 之路会很有趣，并借此帮助听众了解这种生活的优缺点、如何走这条路、成功的要素等等。但在深入探讨之前，我希望你能花一分钟左右的时间，简要介绍一下你的职业生涯，你是如何走到今天开始做这个 Newsletter 的，以及你现在的时间都花在什么地方。

---

### [00:05:19] Gergely Orosz

**English:**
My career started out as what you might consider a pretty typical software engineer career. I graduated from university, I did a computer science degree for a five year program, so I did bachelor's and master's. I worked on the side, I hacked around, built small websites here and there, and during university I worked at a small web agency. And then I worked my way up in the industry. So I started off at a consulting company, we were just building for other companies. I'm originally from Hungary, in Europe. I then moved to UK, which was a big step up for me in terms of just getting access to, I guess, more modern software development. I was at a consulting company there as well. And I moved up to London, which in Europe, I feel it's like the New York of Europe, or even the Silicon Valley, back in the day. Back before Brexit, it was the biggest tech hub.

**中文翻译:**
我的职业生涯始于你可能认为的非常典型的软件工程师之路。我大学毕业，读了五年的计算机科学专业，拿到了学士和硕士学位。我当时也做兼职，到处捣鼓，建一些小网站，大学期间我在一家小型网络代理公司工作。然后我在这个行业里一步步往上爬。我最初在一家咨询公司工作，只是为其他公司开发产品。我来自欧洲的匈牙利。后来我搬到了英国，这对我来说是一个巨大的进步，因为我接触到了更现代的软件开发。我在那里也在一家咨询公司工作。接着我搬到了伦敦，在欧洲，我觉得伦敦就像是欧洲的纽约，甚至是当年的硅谷。在英国脱欧之前，它是最大的科技中心。

---

### [00:06:11] Gergely Orosz

**English:**
I worked at an investment bank there, and then on the side I was always building mobile apps, and I got into Skype. I like to say Skype, but it was Microsoft. They just bought Skype at that point, and it was a lot more startup-y environment, a lot more fast moving. I then moved to another startup where I was a founding engineer of a acquisition. It's a startup called Skyscanner. And then I ended up at Uber at Amsterdam, where I joined as a senior software engineer, and I became a manager, and then a manager of managers, and it was just... I feel, looking back at that part of my career, I just felt really growing all the time, just taking each step one step at a time, which gave me a lot of appreciation for all these levels.

**中文翻译:**
我在那里的一家投资银行工作，业余时间我一直在开发移动应用，后来我进入了 Skype。我喜欢说是 Skype，但其实是微软，当时他们刚收购了 Skype，那里的环境更像初创公司，节奏非常快。后来我去了另一家初创公司，在那里我是一家被收购公司的创始工程师，那家公司叫 Skyscanner（天巡）。最后我去了 Uber 阿姆斯特丹分部，最初是作为高级软件工程师加入的，后来成了经理，再后来成了经理的经理（总监级别）。回首那段职业生涯，我觉得自己一直在成长，一步一个脚印，这让我对所有这些职级都有了深刻的理解。

---

### [00:06:51] Gergely Orosz

**English:**
And then, just as I was on this really good career path, I was on the path to being a senior engineering manager, or who knows, one day I might have had a shot of being their director of engineering as well, I decided to leave Uber. And we'll talk about it a little later in the podcast, but I didn't plan like this, but I started writing a newsletter. And now here I am writing a newsletter where a bunch of people are reading it, and it's a really unexpected turn and a really cool life as well.

**中文翻译:**
然后，就在我处于这条非常好的职业路径上——我正朝着高级工程经理的方向迈进，或者谁知道呢，也许有一天我有机会成为他们的工程总监——我决定离开 Uber。我们稍后会在播客中详细讨论，但我当时并没有计划成现在这样，我只是开始写 Newsletter。现在，我在这里写着一份有很多人阅读的 Newsletter，这是一个非常意外的转折，也是一种非常酷的生活。

---

### [00:07:19] Lenny

**English:**
Awesome. On the newsletter, just to give people a little bit of context of how big this has gotten, can you share just a couple stats about the growth of the newsletter, the size, and anything else you want to share there?

**中文翻译:**
太棒了。关于 Newsletter，为了让大家了解它现在规模有多大，你能分享几个关于增长、规模以及其他你想分享的数据吗？

---

### [00:07:30] Gergely Orosz

**English:**
Just today I checked and it said 189,000 subscribers. I think the past 90 days has been growing with 80,000 subscribers, so it's almost a thousand people per day, which is incredible. Because these numbers are huge. If you're listening, you're probably thinking, "Wow." And that's how I feel every day as well. But I've been writing a blog for many, many years, and these are numbers I never thought it would be. And the growth just seems to be accelerating. There was a tipping point in April where the newsletter was growing... In the first about nine months of the newsletter, it got to 50,000 subscribers, and then the next five months, or six or seven months, it went up by another a hundred and something thousand subscribers. This was when Substack introduced recommendations, which has been a massive growth engine, and I guess being one of the top publications, I benefited from it. But those numbers are again...

**中文翻译:**
就在今天我查了一下，订阅者已经达到了 18.9 万。我想过去 90 天里增长了 8 万订阅者，所以几乎是每天增加 1000 人，这太不可思议了。因为这些数字非常庞大。如果你正在听，你可能会想：“哇。”我每天也是这种感觉。但我写博客已经很多很多年了，这些数字是我从未想过的。而且增长似乎还在加速。四月份有一个转折点，当时 Newsletter 正在增长……在最初的大约九个月里，它达到了 5 万订阅者，然后在接下来的五个月，或者六七个月里，它又增加了 10 多万订阅者。这是在 Substack 推出“推荐”（Recommendations）功能的时候，这成了一个巨大的增长引擎，我想作为顶级刊物之一，我也从中受益了。但这些数字再次……

---

### [00:08:26] Gergely Orosz

**English:**
So this is a paid newsletter as well. So there's a free version and a paid version, and there's thousands of people paying for the newsletter. It's a single digit percentage, but it's a very, very healthy one. And again, it just beat all my expectations. And I guess we're in similar boats, because our newsletter setup, yours and mine, is somewhat similar. We have plenty of differences as well, but I make most of my revenue from subscriptions, and I don't do sponsorships or ads in the newsletter. So if people sign up for the free one, they get articles every now and then, and for the paid one, they get it a lot more and in more depth.

**中文翻译:**
这也是一份付费 Newsletter。它有免费版和付费版，有成千上万的人在为这份 Newsletter 付费。付费比例是个位数百分比，但非常健康。再次强调，这完全超出了我的预期。我想我们处境相似，因为你我的 Newsletter 设置有些雷同。虽然我们也有很多不同点，但我大部分收入来自订阅，我不在 Newsletter 里做赞助或广告。如果人们注册免费版，他们会偶尔收到文章；如果订阅付费版，他们收到的频率会高得多，内容也更深入。

---

### [00:08:59] Lenny

**English:**
Can you give listeners a sense of just the order of magnitude income you make from this, versus your cushy tech job at Uber? You don't have to share numbers or anything like that.

**中文翻译:**
你能让听众了解一下你现在的收入与你在 Uber 那份优渥的科技工作相比，大概是什么数量级吗？你不需要分享具体数字。

---

### [00:09:09] Gergely Orosz

**English:**
Yeah. I'll share a little numbers of my cushy tech job at Uber. I was in Europe, and European tech salaries, or I'll say total compensation, will be lower than for example the U.S., but it'll be higher than let's say regions like India or Indonesia. There's regional differences, and this is true for big tech as well. Uber was a good example on this. But in my best year at Uber, I made about 320 or $330,000 in total compensation. This was after Uber went public, so it includes the stock, the base salary, the bonus, which was very, very good in Europe. And when I quit my job, I was actually thinking, "Am I crazy? Because I'm leaving..." Especially in Europe, this is a lot of money [inaudible 00:09:53] this will be similar to something... Someone in a similar position would've made five or 600 K in total in the U.S.

**中文翻译:**
好的。我会分享一点我在 Uber 那份优渥工作的数字。我当时在欧洲，欧洲的科技行业薪水，或者说总薪酬，会比美国低，但会比印度或印尼等地区高。存在地域差异，大厂也是如此。Uber 就是一个很好的例子。但在我在 Uber 表现最好的一年里，我的总薪酬大约是 32 万或 33 万美元。这是在 Uber 上市之后，所以包括了股票、基本工资和奖金，这在欧洲是非常非常丰厚的。当我辞职时，我真的在想：“我是不是疯了？因为我正在离开……”尤其是在欧洲，这是一大笔钱，相当于在美国担任类似职位的人能拿到的 50 万或 60 万美元。

---

### [00:10:00] Gergely Orosz

**English:**
So I walked away from that, and I was pretty sure that I'll just [inaudible 00:10:04] a lot less, but I'll enjoy what I'm doing, or I'll have... I'll just give it a go. But now I am making more in compensation that I made at Uber. And the difference is that now my compensation, my earnings, keep going up as long as the newsletter is growing, so there's no theoretical cap on this. Of course there is an actual cap, there's churn, growth is slowing over time, but it's very, very strange, because I felt that I was in a really privileged position, just honestly making tons of money, doing a job that I loved. And this was at Uber or as a software engineer. And I'm now doing stuff that I love, and in some strange way, I guess it even pays better. Part of it is just luck, part of this is situational. I think we're going to talk a bit more about this. But this was very, very surprising and very unexpected for me.

**中文翻译:**
所以我放弃了那一切，我当时很确定我的收入会大幅减少，但我会享受我所做的事情，或者说……我只是想尝试一下。但现在，我获得的报酬比我在 Uber 时还要多。不同之处在于，现在我的报酬、我的收入，只要 Newsletter 在增长就会持续上升，所以理论上没有上限。当然，实际上是有上限的，会有用户流失，增长也会随时间放缓，但这感觉非常、非常奇妙，因为我曾觉得自己处于一个非常优越的位置，赚着大钱，做着自己喜欢的工作。那是在 Uber 担任软件工程师的时候。而现在我依然在做我热爱的事情，而且以某种奇妙的方式，报酬甚至更高了。一部分是运气，一部分是时机。我想我们稍后会多聊聊这个。但这对我来说非常令人惊讶，也完全出乎意料。

---

### [00:10:55] Lenny

**English:**
Awesome. That's a great segue to the first thing I want to talk about, but just to frame what I want to spend our time on today, there's these four areas I want to explore. One is your decision to leave and start this life of writing, which is a very non-traditional life. Two is what the life of a paid newsletter person is like. What do you do all day? How do you find time to do this? How do you produce so much content? Three, what it takes to be successful at this. A lot of people... I always say it's easy to start a newsletter, hard to keep it going, and I'm curious what you find is important to be successful. And then four, how do you get started if you want to start your own newsletter?

**中文翻译:**
太棒了。这很好地引出了我想聊的第一件事。为了明确我们今天的时间安排，我想探讨四个领域。第一，你决定离开并开始这种写作生活的初衷，这是一种非常非传统的生活。第二，付费 Newsletter 创作者的生活是怎样的？你整天都在做什么？你如何找时间做这件事？你如何产出这么多内容？第三，成功的要素是什么？很多人……我常说开始一份 Newsletter 很容易，但坚持下去很难，我很好奇你认为成功的关键是什么。第四，如果你想开始自己的 Newsletter，该如何起步？

---

### [00:11:30] Lenny

**English:**
But before I get into that, I just wanted to add a thought that I had. The way I think about this life in terms of comparing to the old job is, one, it feels instead of one boss, I have thousands of micro bosses, and one of them can fire me and many do every day, but it feels safer than at a tech job where one person can decide. And then the other piece is, assuming it keeps growing, you're getting a raise almost every day, every week, depending on the growth rate, and that's cool.

**中文翻译:**
但在深入探讨之前，我想补充一个我的想法。我对比这种生活与旧工作的方式是：第一，感觉我不再只有一个老板，而是有成千上万个“微型老板”，其中任何一个都可以解雇我，而且每天都有很多人这么做（退订），但这比在科技公司工作感觉更安全，因为在那里一个人就能决定你的命运。第二点是，假设它持续增长，你几乎每天、每周都在涨工资，这取决于增长率，这真的很酷。

---

### [00:11:57] Gergely Orosz

**English:**
That is really cool. I had a spreadsheet that I maintained for the first year of the publication, where I listed, for every article, how much did my annual revenue go up a week later. So tracking what was the impact. And the crazy thing was that, when I wrote a really good article that resonated with people, sometimes it was an article that I thought was mediocre and people still loved it [inaudible 00:12:20] it was a really good article that I put tons of work in, I saw myself getting a raise. And this is just something you just don't get in corporate. I mean, it's by design, and there's a lot of good stuff about it, but I feel that this life, and we'll touch more on this, but there's a lot of surprising things, both good and bad, but this is a really good one. So for doing something awesome, you can just give yourself a raise, especially because this is just like you, mine is also a one person business right now.

**中文翻译:**
那确实很酷。在创办的第一年，我维护了一个电子表格，记录了每一篇文章发布一周后，我的年收入增加了多少。也就是追踪每篇文章的影响力。疯狂的是，当我写出一篇引起人们共鸣的好文章时——有时是我觉得平平无奇但大家却很喜欢的文章，有时是我投入了大量心血的好文章——我能看到自己“涨工资”了。这在公司里是绝对体验不到的。我的意思是，公司的机制就是那样设计的，虽然也有很多好处，但我感觉这种生活——我们稍后会详谈，有很多令人惊讶的事情，有好有坏——但这一点真的很棒。因为做了一件了不起的事，你就可以给自己涨工资，尤其是因为我的业务现在和你一样，也是一个人的公司。

---

### [00:12:49] Lenny

**English:**
Yeah. Okay. So you're at Uber, you're making hundreds of thousands of dollars writing code, it's pretty sweet. Uber's growing. You probably got all these RSUs that are going to keep accumulating. It's pretty good. And you decide, "I'm going to try to make money on the internet writing," which is an obvious way to make a lot of money. Not. And so I'm curious, what got you to leave that job and explore writing and get to this writing path?

**中文翻译:**
是的。好，你在 Uber，写代码就能赚几十万美元，这很滋润。Uber 在增长，你可能还有很多持续累积的 RSU（受限股票单位）。这非常不错。然后你决定，“我要尝试在网上靠写作赚钱”，这显然不是一个能赚大钱的显而易见的方法。所以我很好奇，是什么让你离开那份工作去探索写作，并走上这条写作之路的？

---

### [00:13:20] Gergely Orosz

**English:**
The short of it is, it was a promise to myself, and COVID, and Uber doing layoffs. And the longer version is that, when I joined Uber, before Uber I was... Now we're talking numbers on my old job, but I was working in London as a principal engineer at Skyscanner. Skyscanner was a unicorn, one of the few unicorns in the UK, UK headquartered and all that, and I was making like 90-something thousand pounds in base salary, which is maybe a 120, 130, or $140,000, depends on how the pound is doing, or sometimes these days it's almost just the same. But back then that was a really good... And this was most of it. I got some stock as well. And I thought I was close to the top of the market in London. I knew people, and it seemed this was a really good compensation package.

**中文翻译:**
简而言之，这是对我自己的一个承诺，加上新冠疫情，以及 Uber 的裁员。详细版本是，当我加入 Uber 之前，我在伦敦担任 Skyscanner 的首席工程师。Skyscanner 是一家独角兽公司，是英国为数不多的几家独角兽之一，总部设在英国。当时我的基本工资是 9 万多英镑，大约是 12、13 或 14 万美元，取决于当时的汇率。在当时，那是非常丰厚的报酬，而且那是收入的大头，我还有一些股票。我当时觉得我已经接近伦敦市场的顶峰了。我认识一些人，这看起来确实是一个非常好的薪酬方案。

---

### [00:14:05] Gergely Orosz

**English:**
And then Uber called me up saying, "Do you want to interview?" I interviewed with them, they gave me an offer, and I negotiated, and they basically doubled my compensation. I was like, wow, this is [inaudible 00:14:16] I knew about Silicon Valley compensation, but I assumed that [inaudible 00:14:20] you're not going to get this, but Uber was getting something closer to that. So I told myself, all right, so I'm getting a really good deal, and most of it is stock, which is... Uber [inaudible 00:14:32] 2016, no-one knew if Uber will go public, although I suspected, because they contacted me to build a payments team so do a SOX compliant payment system. And you need a SOX compliant payment system if you want to go IPO.

**中文翻译:**
然后 Uber 打电话给我说：“你想面试吗？”我参加了面试，他们给了我一个录取通知，我进行了谈判，他们基本上把我的薪酬翻了一番。我当时想，哇，这太……我知道硅谷的薪酬水平，但我以为在欧洲拿不到那么多，但 Uber 给出的价格已经很接近了。所以我告诉自己，好吧，我得到了一个非常好的机会，其中大部分是股票。那是 2016 年，没人知道 Uber 是否会上市，尽管我有所怀疑，因为他们联系我是为了建立一个支付团队，开发一套符合 SOX（萨班斯-奥克斯利法案）标准的支付系统。如果你想 IPO，你就需要一套符合 SOX 标准的支付系统。

---

### [00:14:44] Lenny

**English:**
That's funny. It reminds me at Airbnb, there's all these people trying to figure out, when are we going to go public? And then there's the team working on SOX stuff and Sarbanes-Oxley, this is good.

**中文翻译:**
这很有趣。这让我想起在 Airbnb 时，所有人都在试图弄清楚我们什么时候上市。然后就看到有个团队在处理 SOX 和萨班斯-奥克斯利法案的事情，这确实是个信号。

---

### [00:14:55] Gergely Orosz

**English:**
Yeah. So anyway, I said, all right, this is a massive lottery ticket. If it goes in, every year I make two years of salary, pretty much. That's how I was thinking. But if not, again, don't forget I'm in Europe where we're used to not seeing any returns on stock. So European software engineers will not value stock as much, because they just haven't seen success stories. So I told myself, if four years later Uber exits and I make a bunch of money, I owe it to myself to take a risk, because then I'll have four years of savings in my bank, which... Back then I had maybe six months of savings or something. So this was the promise to myself.

**中文翻译:**
是的。所以无论如何，我说，好吧，这是一张巨大的彩票。如果中了，我每年的收入基本上相当于两年的工资。我当时就是这么想的。但如果没有中，别忘了我在欧洲，我们习惯了股票没有任何回报。所以欧洲的软件工程师不会那么看重股票，因为他们还没见过成功的案例。所以我告诉自己，如果四年后 Uber 上市，我赚了一大笔钱，我就欠自己一个冒险的机会，因为到那时我的银行里会有四年的积蓄，而当时我大概只有六个月的积蓄。这就是我对自己的承诺。

---

### [00:15:32] Gergely Orosz

**English:**
And then I probably would've forgotten about this, but four years later, almost on the dot, COVID starts, and it really hit super hard. We're laying off people, we had to lay off 20% of the engineers. I was already managing a group of about 30 people, I had managers under me, and 20% of the people or 15% had to be let go. And I was thinking to myself, what am I doing here? I looked ahead, Uber was going to have a really bad year, I'm going to have to manage morale. Up to then, I'd helped put together this team, and we had a really good charter, and we had to throw that charter out the window, because it made no sense with the economic reality. So I thought back, and I told myself, if I'll be here, I'll take a risk, and I'll try to do something else. So I was like, all right, let me pull this trigger.

**中文翻译:**
后来我可能都忘了这件事，但四年后，几乎就在那个时间点，新冠疫情爆发了，打击非常沉重。我们开始裁员，不得不裁掉 20% 的工程师。当时我管理着一个大约 30 人的团队，手下还有经理，其中 20% 或 15% 的人不得不离开。我当时在想，我在这里做什么？我展望未来，Uber 将度过非常糟糕的一年，我不得不去管理员工士气。在那之前，我帮助组建了这个团队，我们有一个非常好的章程，但由于经济现实，我们不得不把那个章程扔出窗外。于是我回想起了那个承诺，我告诉自己，如果我留在这里，我就去冒险，尝试做点别的事情。所以我决定，好吧，行动吧。

---

### [00:16:18] Gergely Orosz

**English:**
My plan was very simple. Leave Uber and start a startup, raise venture capital, because I haven't done that before but it kind of runs in the family. My brother's on his second startup, and he sold his first one to Skyscanner, and now he's building this startup called Craft Docs. It's a really slick document editing system, they just raised their series B. So through him I know [inaudible 00:16:42] startup life is, and I felt I never did that, I always worked at big companies.

**中文翻译:**
我的计划非常简单：离开 Uber，创办一家初创公司，筹集风险投资。因为我以前没做过，但这似乎是家族传统。我哥哥正在做他的第二家初创公司，他把第一家卖给了 Skyscanner，现在他正在做一个叫 Craft Docs 的初创项目。那是一个非常流畅的文档编辑系统，他们刚完成了 B 轮融资。通过他，我知道初创公司的生活是怎样的，我觉得我从未尝试过，我一直都在大公司工作。

---

### [00:16:45] Gergely Orosz

**English:**
So my plan was [inaudible 00:16:47] leave Uber, raise money, and do something on platform engineering. A classic way that Uber alumni start businesses is, Uber has invested silly amounts of money to build everything custom internally. Everything that you can think of. Our [inaudible 00:17:02] system was custom, our experimentation system, our container, the way we automatically set that up, a lot of the engineering stuff. So a lot of Uber alumni just leave, and whatever they saw there, they just build it for the world to use, because no other company really does what Uber does, because it makes no sense, but a lot of them will pay for.

**中文翻译:**
所以我的计划是离开 Uber，筹钱，做一些关于平台工程（Platform Engineering）的事情。Uber 校友创业的一个经典方式是：Uber 投入了惊人的资金在内部构建了一切定制化的东西。你能想到的所有东西。我们的 [听不清] 系统是定制的，我们的实验系统、我们的容器、自动设置的方式，很多工程方面的东西都是。所以很多 Uber 校友离开后，就把他们在那里看到的东西构建出来供全世界使用，因为没有其他公司会像 Uber 那样自己造轮子（因为那不划算），但很多公司愿意为此付费。

---

### [00:17:20] Gergely Orosz

**English:**
That was the plan. But before [inaudible 00:17:22] I wanted to finish a book. I'd been writing this book for, it was coming up to a year, called the Software Engineer's Guidebook, which is just my advice for people to grow professionally in the field. And I figured, all right, let me leave the company, in six months I'll write the book, I'll just use my savings to take a break, and then I'll raise the venture capital. And what happened was, I started to write this book, but I got sidetracked, I started to have fun online in terms of... I was writing on Twitter, on my blog. I accidentally published a book called Building Mobile Apps at Scale. I just did it for a few months.

**中文翻译:**
那是当时的计划。但在那之前，我想完成一本书。我已经写了快一年了，书名叫《软件工程师指南》（The Software Engineer's Guidebook），主要是我对人们在这一领域职业成长的建议。我想，好吧，让我离开公司，花六个月写完这本书，用我的积蓄休息一下，然后再去筹集风险投资。结果是，我开始写这本书，但我分心了，我开始在网上找乐子……我在 Twitter 和博客上写作。我不小心出版了一本叫《大规模构建移动应用》（Building Mobile Apps at Scale）的书，我只花了几个月时间。

---

### [00:17:58] Gergely Orosz

**English:**
And the weird thing was that my plan was that I'm going to just not make any money, and this book, Building Mobile Apps at Scale, and another book that I published about tech resumes, I just wrote these in a few months, they started making money. They made about $100,000 in the first year. And I was like, "That's interesting. People are buying my books." And I self-published it through Gumroad or places where I get to keep I think 90% of the revenue, but still, this was really interesting. And I got to the point where, all right, I should now start a startup. I should do fundraising and do all that. And then I asked myself, why do I really want to do that?

**中文翻译:**
奇怪的是，我原本计划是不赚任何钱的，但《大规模构建移动应用》这本书，以及我出版的另一本关于技术简历的书，我只用了几个月写完，它们就开始赚钱了。第一年赚了大约 10 万美元。我想：“这很有趣，人们在买我的书。”我是通过 Gumroad 之类的平台自出版的，我可以保留大约 90% 的收入，但这依然非常有趣。然后我到了一个节点，觉得好吧，我现在应该开始创业了，应该去融资等等。但我问自己，我为什么真的想做那个？

---

### [00:18:34] Gergely Orosz

**English:**
And the answer was two reasons. One is, I love working in small teams at Uber. I'll be honest, I didn't really enjoy being a manager of managers. It felt a bit too abstract. I didn't like being in the meetings, not doing the work. What I really liked is when we had a small team, and we had this really big vision, and it was us against the world. We were like ten of us, and we were just getting stuff done, we were putting out fires, it was so much fun. So that was one of the reasons I wanted to do startup. I was hoping to recreate this feeling.

**中文翻译:**
答案有两个原因。第一，我喜欢在 Uber 的小团队工作。坦白说，我并不太喜欢当“经理的经理”。那感觉太抽象了。我不喜欢整天开会而不干实事。我真正喜欢的是当我们有一个小团队，有一个宏大的愿景，就像是我们与整个世界对抗。我们大概十个人，只是把事情搞定，到处救火，那非常有意思。所以这是我想创业的原因之一，我希望能重现那种感觉。

---

### [00:19:05] Gergely Orosz

**English:**
And the other thing, honestly, was money. This was in 2021 before the market crashed. Just doing the maths, if you found a company, and I'll be a CEO and the founder, maybe I'll have a co-founder, this becomes a unicorn, by that time we will have raised five rounds of funding or six, I'll be diluted as hell, but I'll still have let's say 5%. 5% of the billion is still $50 million, after you pay taxes [inaudible 00:19:30] I can buy a bunch of stuff that I don't need. And I was asking myself, all right, and then what? And I was like, after I've bought everything that I don't need, I probably want to share what I know with people, do YouTube videos and write books.

**中文翻译:**
另一个原因，坦白说，是钱。那是 2021 年市场崩盘之前。算一下账，如果你创办一家公司，我是 CEO 和创始人，也许有个合伙人，公司成了独角兽，到那时我们可能已经融了五六轮资，我的股份会被稀释得很厉害，但假设我还有 5%。10 亿美金的 5% 依然是 5000 万美元，交完税后，我可以买一大堆我不需要的东西。然后我问自己，好吧，那之后呢？我想，等我买完所有不需要的东西后，我可能想和人们分享我的知识，拍 YouTube 视频，写书。

---

### [00:19:43] Gergely Orosz

**English:**
And I was thinking to myself, so hold on. I would go off and do this for like ten years, because that's how much you need to plan to do it. I need to stop doing what I'm doing right now, because I would owe it to my investors and my team to not spend all day on the internet writing about stuff. And then I want to do it again. So it's reminding me of the story of this fisherman. There's one that goes [inaudible 00:20:08] there's the same thing of, you work really hard to do what you're doing right now. So I decided, let me just try giving this a go. [inaudible 00:20:14]

**中文翻译:**
我心想，等等。我要去折腾大约十年，因为那是创业需要的时间规划。我得停止我现在正在做的事情，因为我对投资人和团队负有责任，不能整天在网上写东西。然后十年后，我再回过头来做我现在想做的事。这让我想起了那个渔夫的故事。道理是一样的：你拼命工作，就是为了能做你现在已经在做的事情。所以我决定，让我直接尝试一下这条路。

---

### [00:20:14] Lenny

**English:**
Wait, what's the story of the fisherman? I think I know what you're talking about, but... [inaudible 00:20:18]

**中文翻译:**
等等，渔夫的故事是什么？我觉得我知道你在说什么，但是……

---

### [00:20:17] Gergely Orosz

**English:**
The story of the fisherman is that, in Mexico, an American businessman sees a fisherman who's just chilling, fishing. And he asks him, "What are you doing all day?" He's like, "I fish for three hours, I hang out with my family, I [inaudible 00:20:32] chill and I sleep in every Saturday and Sunday." He says, "All right, here's what you should be doing. You should fish not three hours, but you should fish five days a week, eight hours a day, sell that fish, turn over a profit, hire more people to do it, then start to be head of all those people, then sell your fishing company." He's like, "Okay. And then what?" "And then you can actually buy an island, and you can just fish for three hours, you can sleep in on Saturdays and sleep on Sundays."

**中文翻译:**
渔夫的故事是这样的：在墨西哥，一个美国商人看到一个渔夫正在悠闲地钓鱼。他问渔夫：“你整天都在做什么？”渔夫说：“我每天钓三小时鱼，陪陪家人，休息一下，每个周六周日都睡懒觉。”商人说：“好吧，你应该这样做：你不应该只钓三小时，你应该每周钓五天，每天八小时，把鱼卖掉，赚取利润，雇更多人来做，然后成为这些人的头儿，最后卖掉你的渔业公司。”渔夫问：“好，那之后呢？”商人说：“然后你就可以买个海岛，每天只钓三小时鱼，周六周日睡懒觉。”

---

### [00:21:00] Gergely Orosz

**English:**
So I was thinking, look, I have savings. I don't have huge, but I have it for... I can still take a risk. So let me take a risk on writing. And I was thinking originally of just spending more time to finish my book. But what I didn't like about books, even though I was making money, is they're really... It's hard to predict if you're going to be making a living, or there's some people who actually like this excitement, but I didn't like it. I didn't know if today I'm going to be making like 50 bucks or 10 bucks or 300 bucks. So I was like, interesting. There's these paid newsletters which I've been thinking about, and you were one of the few people who shared some of your early numbers, and I figured this could be interesting, because it's recurring revenue.

**中文翻译:**
所以我当时想，看，我有积蓄。虽然不是巨款，但足够我……我依然可以承担风险。所以让我把赌注压在写作上吧。我最初想的是花更多时间完成我的书。但我不喜欢写书的一点是，尽管我在赚钱，但很难预测你是否能以此为生。有些人可能喜欢这种刺激感，但我不喜欢。我不知道今天会赚 50 块、10 块还是 300 块。所以我发现，付费 Newsletter 很有趣，我一直在考虑这件事，而你是少数分享早期数据的人之一，我觉得这可能很有意思，因为它是经常性收入（Recurring Revenue）。

---

### [00:21:41] Gergely Orosz

**English:**
And the only reason I was really hesitant to start a paid newsletter, I was thinking about doing so for at least 6 to 12 months, is I was worried about writing every single week something really, really worthwhile reading, and it's a lot of work. But then I looked back and I saw that I wrote three books. [inaudible 00:21:58] I told you I wrote two books, but there was a third one that I also published in a year, and I was like, I'm pretty sure I can write. So for two weeks I collected ideas of what I would write about, and I had this super long list. So I was like, okay, ideas also check.

**中文翻译:**
我之所以对开始付费 Newsletter 犹豫不决（我考虑了至少 6 到 12 个月），唯一的理由是我担心每周都要写出非常值得阅读的东西，那工作量很大。但后来我回头看，发现我一年写了三本书。我刚才说写了两本，但其实一年内我还出版了第三本。我想，我很确定我能写。于是我花了两个星期收集写作灵感，列了一个超级长的清单。我想，好吧，点子也有了。

---

### [00:22:10] Gergely Orosz

**English:**
And then I just said, screw it, I'm going to take a risk. It's a bit of a more professional risk, and maybe a financial one as well. I'll announce that I'm going to start a paid newsletter. Every week, I'm going to write something really in depth about software engineering. It's going to start next week. And I told myself that I'll... I told my wife as well that I'll do this for six months, and I'll see what happens. If there's traction, it's great. I might have found myself a new job, basically. If not, I'll just refund people. Everyone who bought an annual subscription... I didn't tell this to people, obviously, but for six months I'm going to give it my all. It's basically like a startup. So I told her and my family that it's going to be a lot of work and I might not be around as much, and they supported me, and I took a plunge. I took a big breath and started off. And that's how it went from leaving Uber to starting a venture funded startup to starting to write full time.

**中文翻译:**
然后我就说，管它呢，我要冒这个险。这既是职业风险，也可能是财务风险。我宣布我要开始一份付费 Newsletter。每周，我都会写一些关于软件工程的深度内容。下周开始。我告诉自己，也告诉我妻子，我会尝试六个月，看看会发生什么。如果有起色，那就太棒了，我基本上就给自己找了一份新工作。如果没有，我就给人们退款。所有买了年度订阅的人……我显然没告诉大家这一点，但在这六个月里我会全力以赴。这基本上就像一个初创公司。所以我告诉她和我的家人，这会很辛苦，我可能没那么多时间陪他们，他们支持了我，于是我纵身一跃。我深吸一口气，开始了。这就是我如何从离开 Uber，到打算做风投支持的初创公司，最后变成全职写作的过程。

---

### [00:23:05] Lenny

**English:**
Awesome. And we're going to talk about what advice you have for folks that are thinking about starting something like this at the end. What was the period between leaving Uber and starting the newsletter?

**中文翻译:**
太棒了。最后我们会讨论你对那些想开始这类事业的人有什么建议。从离开 Uber 到开始 Newsletter 之间隔了多久？

---

### [00:23:14] Gergely Orosz

**English:**
It was pretty much a year, a little bit less than a year. Might have been like ten months or so, but it was a year from when I decided to leave Uber. So Uber did layoffs in April, and it was really stressful. It was the first time I... I didn't lay anyone off, but people on my team were laid off. I wasn't told who's going to be laid off. It was just really stressful. It's weird, in the sense that the people who were let go, obviously worse for them, but I still felt terrible, and I just didn't feel very good about it. I think this was the breaking point. This was the point where I realized that it's not a family, which is weird because it never was, but it kind of felt family-like, but it's just a corporate, and I'm just a number, and this could happen to me, I guess. So I think I lost my sense of the trust in the system, that it'll take care of me, because I saw some of my colleagues who were really good professionals, I'd argue they were better software engineers and managers than me, they got let go because they were in the wrong team.

**中文翻译:**
大约是一年，比一年稍微短一点。可能是十个月左右，但距离我决定离开 Uber 刚好一年。Uber 在四月份进行了裁员，压力非常大。那是我第一次……我没有亲手裁掉任何人，但我团队里的人被裁了。我没被告知谁会被裁。那真的压力巨大。奇怪的是，虽然被裁的人显然更惨，但我依然感觉糟糕透顶，心里很不舒服。我想那是我的转折点。在那一刻我意识到，公司不是一个家，这很奇怪，因为它从来都不是，但它曾经给人一种家的感觉。它只是一个企业，我只是一个数字，我想这种事也可能发生在我身上。所以我失去了对这个系统的信任，不再相信它会照顾我，因为我看到一些非常优秀的同事，我认为他们是比我更好的软件工程师和经理，却因为在错误的团队而被裁掉了。

---

### [00:24:08] Gergely Orosz

**English:**
So this was April, and in July I went to a holiday, and two weeks in, I just realized I need to leave. And I really had the urge to do somewhere where I'm in charge. And if you're a manager listening to this, you might relate to this. If you're an engineer listening to this, maybe just shut your ears or you'll figure it out eventually. But when I was promoted into management... It wasn't promoting into it, because it was a side step, I didn't get [inaudible 00:24:34] or anything, but it still feels a promotion. They only promote the people who are... Only let people transition who are considered pretty good. I felt this would be a big deal. I'm now a manager. What no one told me is, yes I was a manager, but I was a middle manager. I didn't have too much authority. I didn't even have budget for my team. Someone was underpaid and I couldn't do anything except complain for HR for six months and hope that they'd do something.

**中文翻译:**
那是四月份，七月份我去度假了，两周后，我意识到我必须离开。我真的有一种强烈的冲动，想去一个由我说了算的地方。如果你是听这期节目的经理，你可能会有共鸣。如果你是工程师，也许可以捂住耳朵，或者你最终也会明白。当我被提拔到管理层时……其实不是提拔，因为是平调，我没涨薪什么的，但感觉还是像提拔。他们只让那些被认为很优秀的人转岗。我觉得这是件大事，我现在是经理了。但没人告诉我的是，虽然我是经理，但我只是个中层经理。我没有太大的权力，甚至没有团队预算。如果有人薪水过低，我除了向 HR 抱怨六个月并祈祷他们能做点什么之外，什么也做不了。

---

### [00:24:58] Gergely Orosz

**English:**
So it was pretty frustrating, because I didn't feel in charge in the sense that I didn't have decision making [inaudible 00:25:02]. And the reason I wanted to do a startup is, I decided I liked being a manager, but I did not how I was not in charge and I couldn't take corporate [inaudible 00:25:12] telling us to do stuff, and then we were telling them no [inaudible 00:25:16] I don't want to do that with my people. So I decided for next job, I could be doing this, but instead I'd like to be in charge. So I'd like to be a founder or someone who's high up, so that I can actually take full responsibility for the things that I want to do or I don't want to do. The short of it is, I decided to leave in July. We have longer notice periods in Europe, so I served a longer notice period, and then left. But it was a year after the decision.

**中文翻译:**
所以这非常令人沮丧，因为我感觉自己并没有真正掌权，没有决策权。我想创业的原因是，我发现我喜欢当经理，但我讨厌自己说了不算，讨厌公司高层告诉我们该做什么，然后我们还得去拒绝他们……我不想对我的员工那样。所以我决定，下一份工作我可以继续做这些，但我希望能说了算。我想成为创始人或高管，这样我就可以对我想要或不想要做的事情负全责。简而言之，我在七月决定离开。欧洲的离职通知期较长，所以我履行了较长的通知期，然后离开了。但这距离做决定已经过去一年了。

---

### [00:25:41] Lenny

**English:**
Let's talk about what your life is like these days, writing a newsletter full time. People might be listening and be like, "Man, $300,000 for writing an email a couple times a week, that's pretty sweet." So I want to talk about the good and the bad of this life. So maybe to start, how many posts are you putting out a week?

**中文翻译:**
让我们聊聊你现在的全职 Newsletter 写作生活。人们听了可能会想：“天哪，每周写几次邮件就能赚 30 万美元，太爽了。”所以我想聊聊这种生活的优缺点。首先，你每周发多少篇文章？

---

### [00:25:59] Gergely Orosz

**English:**
I started the newsletter saying I'm going to post once a week. You'll have one pinned up post. And I started to do that, but interesting enough, eventually I upped it to two, so I now promise people two posts a week. There's more in depth and more timeless posts about some software engineering topic on Tuesdays, and there's something that's called the scoop, something a bit more timely, where I reflect or analyze what's going on in the market, interesting stuff I'm hearing. And every now and then there's a bonus post. So I'll say two on average, but the second one came a lot later. But initially in the first few months I was like, I have this one post per week, and it needs to be good.

**中文翻译:**
我刚开始做 Newsletter 时说我每周发一篇。你会有一篇置顶文章。我开始确实是这么做的，但有趣的是，最终我增加到了两篇，所以我现在承诺每周发两篇。周二会发一些关于软件工程主题的更深入、更经典的文章；还有一种叫作“独家内幕”（The Scoop）的内容，时效性更强，我会反思或分析市场上正在发生的事情，以及我听到的趣闻。偶尔还会有额外篇目。所以平均每周两篇，但第二篇是后来才加上的。最初的几个月里，我想的是，我每周只有这一篇文章，它必须足够好。

---

### [00:26:37] Gergely Orosz

**English:**
And it was interesting, because you would think writing a post a week is not a big deal. It's easy. As you said, let's say you're making 300K just writing one post a week. But it actually was pretty stressful in the beginning, because it turns out to write that post, it takes at least a few days or sometimes even longer. Sometimes it takes a week or two for me to research in terms of talking with people. I chose topics that are not covered, because why would people pay for something that is out there already or well known? Then I need to write [inaudible 00:27:10] a first draft. I get some feedback from people who I trust often, not always, but I often do. And then there's an editing phase where I work with an editor who helps make sure that it's just correct. And all these things add up. Even if I only spend a day researching the stuff, it's a day researching, then I have a draft on day two. Day three I get feedback, on day four it's editing, it's almost a whole week.

**中文翻译:**
这很有趣，因为你可能会觉得每周写一篇文章没什么大不了的，很简单。就像你说的，每周写一篇文章就能赚 30 万。但刚开始时压力其实很大，因为事实证明，写那一篇文章至少需要几天，有时甚至更长。有时我需要一两周的时间去调研，和人们交流。我选择那些没人写过的主题，因为如果内容随处可见或众所周知，人们为什么要付费呢？然后我需要写初稿。我经常（虽然不是每次）会从我信任的人那里获取反馈。接着是编辑阶段，我会和一位编辑合作，确保内容准确无误。所有这些加起来，即使我只花一天调研，第二天写草稿，第三天拿反馈，第四天编辑，也几乎占满了一整周。

---

### [00:27:32] Gergely Orosz

**English:**
So I was working on parallel things at the same time, and I was often running against the deadline, I was barely finishing it, which is not what I was expecting initially. The first few months I feel was a bit more stressed, but again, the good thing is I cleared my calendar, so I said I'm not talking with anyone, I'm just doing this. So in that sense it was good. But the one thing I realized, if you look at any journalists who's doing stuff full time, and they're writing, not these clickbait articles, but actually in depth. You look at the Washington Post or New York Times, search for their name, and look up the articles that they write, and they're going to be longer articles. They have like one a month. Seriously. You look at the investigative journalist, they might even have less. And they have a bit of a different level, they have to check with legal and all those things, but my editor is a journalist, so he was actually telling me, even back then, "You actually write a lot of original stuff," because a lot of my emails are about five, 6,000 words, which is considered very long.

**中文翻译:**
所以我当时同时处理好几件事，经常在截止日期前赶工，勉强完成，这和我最初的预期完全不同。最初几个月我觉得压力有点大，但好在我的日历是空的，我说我不和任何人交谈，我只做这件事。从这个意义上说，这很好。但我意识到一件事，如果你观察任何全职工作的记者，他们写的不是那种标题党文章，而是深度报道。你看《华盛顿邮报》或《纽约时报》，搜一下他们的名字，看看他们写的文章，通常都是长篇大论。他们可能一个月才出一篇。真的。你看那些调查记者，产出可能更少。当然他们的级别不同，还要经过法务审核之类的，但我的编辑就是一名记者，他当时就告诉我：“你其实写了很多原创内容，”因为我的很多邮件都在五六千字左右，这被认为是非常长的。

---

### [00:28:32] Lenny

**English:**
Yeah. When you said that people listening might be like, one post a week is easy, I think most people are the opposite. They're just like, I can't write anything. I don't have time for any writing. How can you ever write one good thing a week? So I think there's both sides to it. And it's cool that you shared the process. Do you have a specific cadence per post? It's like Monday draft, Tuesday review, Wednesday editor. Is that how you work?

**中文翻译:**
是的。当你提到听众可能会觉得每周一篇很容易时，我觉得大多数人其实恰恰相反。他们会觉得，我什么都写不出来，我根本没时间写作。你怎么可能每周写出一篇好文章？所以我觉得两方面都有。你分享这个过程很酷。你每篇文章有特定的节奏吗？比如周一草稿，周二评审，周三编辑？你是这样工作的吗？

---

### [00:28:58] Gergely Orosz

**English:**
I write every post over multiple weeks, most of them. Some of them I might be able to write faster, but what I now have is, nowadays I actually write two articles. So I have the Thursday that is the scoop, which actually is a lot easier for me to write, interestingly enough. And my cadence is, on Monday I finish up the last of the post that goes out on Tuesday. It's just small edits, but it's already done pretty much, so it's just a few small tweaks, and maybe I have some feedback coming in. On Tuesday, I publish this post, and I do some free writing. I write about some other ideas that I have that's going to be future posts. On Wednesday, it's my free day in between, where I... It's interesting, because what I feel is, when I don't have pressure, I tend to not do much stuff, which might just... My mind's saying, "You just need to chill." Maybe that's it.

**中文翻译:**
大多数文章我都要写好几周。有些可能写得快一点，但我现在实际上每周写两篇。周四是“独家内幕”，有趣的是，这对我来说写起来容易得多。我的节奏是：周一完成周二要发的文章的收尾工作。只是一些小修改，基本上已经完成了，可能还有一些刚收到的反馈要处理。周二，我发布这篇文章，然后进行一些自由写作。我会写下一些未来文章的灵感。周三是中间的空档期，我……很有趣，因为我感觉当我没有压力时，我倾向于什么都不做，这可能只是我的大脑在说：“你需要放松一下。”也许就是这样。

---

### [00:29:49] Gergely Orosz

**English:**
But one thing I miss from the corporate world... And if you're listening and you're in a job and you're thinking, "Gergely's job is so amazing," one thing that I liked and I really miss about working at Uber is, I actually had a schedule. This is weird, I hated it back then, but I needed to do these things, and whenever you have a pressure, you do it. And this works with my newsletter. I put in the second newsletter I think to have a bit more pressure. Because the second part of Wednesday, I'm already starting to write my Thursday newsletter. On Thursday, I write that Thursday newsletter, and on Friday I'm now writing the next newsletter for Tuesday. So almost every day except for Wednesday, I have a strong pressure to write. Which when people ask, "Gergely, how do you write so much?" Because I did the maths, and I wrote four or five books' worth of content just last year. It's because I have these deadlines, and as you said, I also know that thousands of people are paying me, they have expectations of me.

**中文翻译:**
但我怀念职场的一点是……如果你正在听，而且你有一份工作，觉得“Gergely 的工作太棒了”，那么我喜欢并怀念在 Uber 工作的一点是：我当时真的有时间表。这很奇怪，我当时很讨厌它，但我必须做那些事，只要有压力，你就会去做。这在我的 Newsletter 上也适用。我想我增加第二篇 Newsletter 就是为了给自己多一点压力。因为周三下午，我已经开始写周四的 Newsletter 了。周四写完周四的那篇，周五我就开始写下周二的那篇。所以除了周三，几乎每天我都有强烈的写作压力。当人们问：“Gergely，你怎么能写这么多？”因为我算了一下，仅去年一年我就写了相当于四五本书的内容。这是因为我有这些截止日期，而且正如你所说，我知道有成千上万的人付了钱，他们对我有所期待。

---

### [00:30:46] Gergely Orosz

**English:**
And so this is how it's done. If you want to write a book, the easiest way is go to a publisher and sign a contract, not because of the money. In software engineering, you're not going to get much [inaudible 00:30:57] $5,000 or something like that. That's what I was offered initially. But it's the pressure. You absolutely should go to a publisher or have some external... Someone to hold you accountable, and then you'll get it done. And I'll let you in on another secret, or not so secret.

**中文翻译:**
所以事情就是这样。如果你想写书，最简单的方法是找一家出版社签合同，不是为了钱。在软件工程领域，你拿不到多少预付款，大概 5000 美元左右，那是我最初拿到的报价。关键在于压力。你绝对应该找个出版社或外部的人来监督你，这样你才能完成。我再告诉你另一个秘密，或者说也不算秘密。

---

### [00:31:16] Gergely Orosz

**English:**
In my mind, when I started newsletter a year ago in this crossroads, I want to write this book, which I think will be a great book, the Software Engineer's Guidebook, I feel it'll be my summary of my last ten years of what I have to share as advice, but I was worried that it's just a big project that's just going to take months, and I'll lose motivation midway.

**中文翻译:**
在我心里，一年前当我站在十字路口开始做 Newsletter 时，我想写那本书——《软件工程师指南》，我觉得那将是我过去十年经验的总结，但我担心那是一个耗时数月的大项目，我会在中途失去动力。

---

### [00:31:37] Gergely Orosz

**English:**
And partially, I went down the newsletter route because I liked how every week I would have to write something, and I had this sneaky idea of, what if I wrote this book where I write some posts that will be part of the book, and then the book will just come together partially. And I've kind of been doing that. I haven't been telling people, but some of the posts are going to be... Not exactly, but the idea is that I have this chapter, and I have this list, have I written about this topic in the newsletter? And you know where I got this idea from? There's the book The Three Musketeers, from Alexander Dumas [inaudible 00:32:12]. And do you know how it was written?

**中文翻译:**
在某种程度上，我选择 Newsletter 这条路是因为我喜欢每周必须写点什么的感觉。我有一个“狡猾”的想法：如果我写这本书的时候，把其中的一些章节作为 Newsletter 发布，那么这本书的一部分就会自然而然地成型。我一直在这么做。我没告诉别人，但有些文章将会……不完全一样，但思路是：我有一个章节清单，我会看我是否在 Newsletter 里写过这个主题。你知道我这个主意是从哪儿来的吗？大仲马的《三个火枪手》。你知道它是怎么写出来的吗？

---

### [00:32:15] Lenny

**English:**
I don't.

**中文翻译:**
不知道。

---

### [00:32:16] Gergely Orosz

**English:**
So he wrote the book for a magazine. He was apparently just low on money, and he started to write for this magazine who told them, "All right, we need you to write something that our readers will want, so that they will buy the magazine." I think he was getting a cut of some sales or something. So he needs to write in a way that was interesting, and then cut it off in a way that people would come back and buy the next one. And he wrote a whole book, and that book, when I read it, it's really long, and I was like, hold on, if he could do this, then this is a good strategy. He was writing it because he just needed the money. That's all. And then he wrote a really good book on the way.

**中文翻译:**
他是为一家杂志写的这本书。显然他当时缺钱，于是开始为这家杂志写作，杂志社告诉他：“好吧，我们需要你写一些读者想要的东西，这样他们才会买杂志。”我想他当时能拿到销售分成之类的。所以他必须写得很有趣，然后在关键时刻掐断，让人们回来买下一期。他写了一整本书，当我读那本书时，它非常长，我想，等等，如果他能做到，那这就是个好策略。他写书只是因为需要钱，仅此而已。结果他在这个过程中写出了一本伟大的著作。

---

### [00:32:52] Gergely Orosz

**English:**
So one big learning for me from newsletters then... I would argue that you can use this not just for newsletters, but any business that you do. If you're going to go out and start a new business, you'll probably have some ideas. And it's not just going to be a newsletter, it's going to be a bunch of other things. If you put in ways that you have to do certain things, put in constraints for the things that you need to do, and then you're going to do that.

**中文翻译:**
所以我从 Newsletter 中学到的一个重要经验是……我认为这不仅适用于 Newsletter，也适用于你做的任何业务。如果你打算创业，你可能会有一些想法。它不一定非得是 Newsletter，可以是很多其他东西。如果你设定了一些必须完成某事的机制，为你的任务设定约束条件，你就会去完成它。

---

### [00:33:16] Gergely Orosz

**English:**
Without that, when you're on your own, when you're entrepreneur, I was a great... I think I was a really diligent employee. I always tried to get my work done, show up on time, I tried to meet all expectations. But what I noticed is, when I started to work for myself, it just went out the window. Almost 15 years of being this star employee who really wants to do well, I found myself upset at myself for not... Just wasting my day. But I fixed it by telling people, "You're going to get this every week," and now I have to do it. I just have no choice.

**中文翻译:**
如果没有这些，当你独自一人、成为创业者时，我曾经是一个非常……我认为我是一个非常勤奋的员工。我总是努力完成工作，准时上班，努力满足所有预期。但我注意到，当我开始为自己工作时，这一切都消失了。做了近 15 年渴望表现出色的明星员工，我发现自己会因为虚度光阴而对自己感到恼火。但我通过告诉大家“你们每周都会收到内容”来解决了这个问题，现在我必须去做，我别无选择。

---

### [00:33:51] Lenny

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data, and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals, or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table. Beginning a SOC 2 report can be a huge burden, especially for startups. It's time consuming, tedious, and expensive.

**中文翻译:**
本期节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。如果你的企业在云端存储任何数据，那么你很可能已经被问到或即将被问到 SOC 2 合规性问题。SOC 2 是证明你的公司采取了适当安全措施来保护客户数据的一种方式，它能建立客户和合作伙伴的信任，尤其是那些有严格安全要求的客户。此外，如果你想向企业级客户销售产品，证明安全性至关重要。SOC 2 既能为你开启更大、更好的交易大门，也可能让你的业务停滞不前。如果你没有 SOC 2，你很可能连谈判桌都上不了。获得 SOC 2 报告可能是一个巨大的负担，尤其是对初创公司而言。它耗时、乏味且昂贵。

---

### [00:34:37] Lenny

**English:**
Enter Vanta. Over 3,000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny, that's V-A-N-T-A.com/lenny, to learn more and to claim your discount. Get started today.

**中文翻译:**
Vanta 应运而生。超过 3000 家快速增长的公司使用 Vanta 将 SOC 2 涉及的 90% 的工作自动化。Vanta 可以在几周内而不是几个月内让你做好安全审计准备，时间不到通常所需的三分之一。在限定时间内，Lenny 播客的听众可以享受 Vanta 1000 美元的优惠。只需访问 vanta.com/lenny（V-A-N-T-A.com/lenny）了解更多信息并领取折扣。今天就开始吧。

---

### [00:35:08] Lenny

**English:**
I definitely wanted to dig into that a little bit deeper, this issue that folks in our line of work run into, which is unstructured time and having to create your own structure. I had the same exact problem when I started this thing, before I even started the newsletter. How do I use my time well? How do I create some kind of deadline for myself? So I'm curious what other tricks you found to help you stay productive and focus, because there's Twitter, there's Instagram, TikTok, there's all these things that pull my attention. And I've learned a couple things I'll share that have been helpful, but I'm curious, what have you found to help you focus and get things out the door? Two posts a week, which is a lot of work.

**中文翻译:**
我确实想深入探讨一下这个问题，即我们这类工作的人会遇到的问题：非结构化的时间以及必须建立自己的结构。在我开始做这件事之前，甚至在开始 Newsletter 之前，我也遇到了完全相同的问题。我该如何利用好时间？我该如何为自己设定某种截止日期？所以我很好奇你还发现了哪些技巧来帮助你保持高效和专注，因为有 Twitter、Instagram、TikTok，所有这些东西都在分散我的注意力。我也学到了一些有用的东西待会儿分享，但我很好奇，你发现了什么能帮你专注并按时完成任务？每周两篇，工作量真的很大。

---

### [00:35:49] Gergely Orosz

**English:**
So a problem that I have, and this might be unique to newsletters, I'm not sure. I use Twitter for a lot of research. And unfortunately what that means is when I start to write something, it can really pull my attention, because I have Twitter open and then I get a message from someone. It's a little bit like Slack, but I'd argue it can be worse, because also Twitter for me is also something that is very useful in generating people [inaudible 00:36:16] raising awareness. So whenever I tweet, it helps my business. So that's a good thing. But it also justifies for me spending more time on, for example, Twitter than I would want to. So I find that I come up with a method, and it works for a few months, and then I need to change it because my brain just learns to work around it. So I'll tell you a few things that I did, and I'll tell you where I'm at right now, but I use for example apps. I use this app Centered, but I know you're also there.

**中文翻译:**
我有一个问题，这可能对 Newsletter 创作者来说比较独特，我不确定。我用 Twitter 做大量的调研。不幸的是，这意味着当我开始写作时，它会极大地分散我的注意力，因为我开着 Twitter，然后会收到别人的私信。这有点像 Slack，但我认为它可能更糟，因为 Twitter 对我来说也是一个非常有用的工具，可以吸引关注、提高知名度。所以每当我发推，它都在帮助我的业务。这是好事。但这也成了我花更多时间在 Twitter 上的借口。我发现我想到一个方法，它能奏效几个月，然后我就得换一个，因为我的大脑学会了绕过它。我会告诉你我做过的几件事，以及我现在的状态。比如我会用一些 App，我用一个叫 Centered 的 App，我知道你也在用。

---

### [00:36:45] Lenny

**English:**
Yeah. I love that app. Also an investor [inaudible 00:36:49] disclaimer, but I love it.

**中文翻译:**
是的，我喜欢那个 App。顺便声明一下，我也是它的投资者，但我真的很喜欢它。

---

### [00:36:51] Gergely Orosz

**English:**
Yeah. And I found that helpful, the idea of focused time and [inaudible 00:36:56] turned on, but it might just be me, but after a while I get used to these things, and I find it not as efficient. I found the Pomodoro method for a few months useful, when you have the 25 minute intervals. And the one thing that has never failed me, but I just find it hard to do, is I find it hard to start. I have this benefit that I have all this time... Sorry, there's two things that always work. One is, it's almost time for me to go home, and then I'm super focused. So when I have this external thing, and I know that there's no way [inaudible 00:37:30] I need to focus on basically the deadline. So if you have deadlines, that works.

**中文翻译:**
是的。我发现它很有帮助，那种专注时间的概念。但也可能只是我的问题，过一段时间我就会习惯这些东西，发现它没那么高效了。我发现番茄钟法（Pomodoro method）在几个月内很有用，就是那种 25 分钟的间隔。有一件事对我来说从未失效，但我发现很难做到，那就是“开始”。我有大把时间的优势……抱歉，有两件事总是有效：一是快到我该回家的时间了，那时我会超级专注。所以当我有一个外部约束，我知道没退路了，我必须专注于截止日期。所以如果你有截止日期，那是管用的。

---

### [00:37:36] Gergely Orosz

**English:**
The other thing is, if I start to spend three or four minutes doing something focused, and I get the flow of it. So a trick I sometimes do when I'm just, I just don't feel doing anything, is I set a timer of 20 minutes, and then I say, "All right, no distractions." I have a script where I just kill... I use a [inaudible 00:37:57] host file, I just kill all LinkedIn, Twitter, Facebook, whatever sites. So I just cannot reach it. It's just a very simple Python script that I wrote for myself. And then in the first few minutes I'm grumbling, I'm like, "I wish I could do this, I wish I could just look at Twitter to research," but about five minutes in, there's a switch, and I'm now actually heads down and doing it. And this has been the thing that has consistently worked.

**中文翻译:**
另一件事是，如果我开始花三四分钟专注做某事，我就会进入状态（Flow）。所以我有时在完全不想动弹时会用一个小技巧：设定一个 20 分钟的计时器，然后说：“好了，不许分心。”我有一个脚本，可以……我修改 host 文件，屏蔽掉 LinkedIn、Twitter、Facebook 等所有网站。所以我根本无法访问它们。那是我为自己写的一个非常简单的 Python 脚本。在最初的几分钟里，我会嘟囔着：“真希望我能干点别的，真想上 Twitter 查查资料，”但大约五分钟后，大脑里就像有个开关被拨动了，我开始埋头苦干。这一招一直都很灵。

---

### [00:38:21] Gergely Orosz

**English:**
The interesting thing is that I feel guilty a lot of times that I'm not working as hard as I could. And I do wonder if it's guilt, or if it's my mind or body telling me that it just wants a break or it wants to do something else. I still haven't figured it out, but I'm on the way there.

**中文翻译:**
有趣的是，很多时候我会因为没有尽全力工作而感到内疚。我也在想，这到底是内疚，还是我的大脑或身体在告诉我它需要休息，或者想做点别的事。我还没完全搞清楚，但我正在摸索中。

---

### [00:38:39] Lenny

**English:**
Awesome. That's a really cool trick, the host file trick. So that's [inaudible 00:38:43] something that you have to be technical to do. I imagine there's some chrome extensions that could do that to some extent for folks. But the whole idea there is, force your brain not to have any way to look at something that'll be distracting, by blocking your computer from even being able to go to the site. That's awesome.

**中文翻译:**
太棒了。那个 host 文件的小技巧真的很酷。虽然这需要一点技术背景，但我猜有一些 Chrome 扩展程序也能在一定程度上实现。但核心理念是：通过阻止电脑访问这些网站，强迫你的大脑没有任何途径去看那些会让你分心的东西。这太棒了。

---

### [00:38:59] Gergely Orosz

**English:**
Yeah. So there is definitely going to be extensions that you can use, and on this podcast we'll have a variety of people. If you're a software engineer, it's pretty simple, and even if you're not, you can look it up [inaudible 00:39:10] when you override your host file, you can actually block [inaudible 00:39:13] what you do. And I did this because I wrote a script where I need to run the script, and I need to run the script again to unblock it. And it's kind of cool, because I put it together for myself. So I usually find that the tools that other people use, maybe this is just me or maybe this is software engineers, I don't like them because I feel they're either too opinionated or they're not opinionated enough. So I don't know if this is just the fact that I used to like to build my own tools and my own scripts, because I can, so I found that my scripts worked the best for me.

**中文翻译:**
是的。肯定有你可以使用的扩展程序，听这个播客的人各行各业都有。如果你是软件工程师，这很简单；即使不是，你也可以查一下如何修改 host 文件来屏蔽网站。我之所以这么做，是因为我写了一个脚本，我需要运行它来屏蔽，再运行一次来解除屏蔽。这挺酷的，因为是我为自己量身定做的。我通常发现别人用的工具——也许只是我的问题，或者是软件工程师的通病——我不喜欢它们，因为我觉得它们要么太武断，要么不够有主见。所以我不知道这是否仅仅是因为我喜欢自己造工具和脚本（因为我有这个能力），所以我发现自己的脚本对我最有效。

---

### [00:39:44] Gergely Orosz

**English:**
But as you said, there's a bunch of really good tools. So my advice to people would be, look up all [inaudible 00:39:50] let's try them out. You won't know until you try them. And again, I had stuff that worked really well for a certain amount of time. I don't know why, maybe I just get bored easily or something, that I just need to rotate. But for example, when I went back to Centered... I have no affiliation by the way, so I'm just telling this. But I really liked how they keep evolving as well to do cooler things. They have a community element where you're competing with people on uninterrupted time and closing stuff. So that to me is a... I'll do one last [inaudible 00:40:23] Centered again. I have no affiliation. What I really liked about Centered is, it allows you to turn on your video camera, and I felt really forced to do work, because I knew that people on the other side of the world might be watching me, even if it was not true.

**中文翻译:**
但正如你所说，有很多非常好的工具。所以我对大家的建议是，去搜搜看，尝试一下。不试你是不会知道的。再次强调，我有些方法在一段时间内非常有效。我不知道为什么，也许我只是容易厌倦，需要轮换。但比如当我重新开始用 Centered 时……顺便说一下，我跟他们没关系，只是随口一说。但我真的很喜欢他们不断进化出更酷的功能。他们有社区元素，你可以和别人比赛不被打断的时间。对我来说……我最后再夸一下 Centered，我真的没拿钱。我最喜欢它的一点是，它允许你开启摄像头，这让我感到一种被迫工作的压力，因为我知道世界的另一端可能有人在看着我，即使那不是真的。

---

### [00:40:37] Lenny

**English:**
Yeah. I love that feature. It's centered.app, by the way, if folks want to check it out. So to summarize some of your tips, which I love, Centered, deadlines, totally work for me too. Blocking sites so that you can't get distracted by Twitter and LinkedIn and TikTok and all the things. And I guess that's the three that work best for you.

**中文翻译:**
是的，我也喜欢那个功能。顺便说一下，网址是 centered.app，如果大家想试试的话。总结一下你的一些技巧（我很喜欢）：Centered、截止日期（对我来说也完全有效）、屏蔽网站以防被 Twitter、LinkedIn、TikTok 等分心。我想这就是对你最有效的三个方法。

---

### [00:40:55] Gergely Orosz

**English:**
Yeah. And the simple thing, start a 20 minute timer, and you say, "For 20 minutes, I need to focus on this thing," on your iPhone or somewhere else. It's just 20 minutes, but during that time you cannot do anything else. And just try it. It works for me, like a charm, once I decide to actually do it.

**中文翻译:**
是的。还有最简单的：设定一个 20 分钟的计时器，告诉自己：“在这 20 分钟里，我必须专注于这件事。”就在你的 iPhone 或其他地方设。只有 20 分钟，但期间不能做任何别的事。试试看。只要我决定去做，它对我来说非常灵验。

---

### [00:41:13] Lenny

**English:**
It's cool Centered does that for you, and it has music and all the things. So I that a lot. Awesome. What do you love most about this life that you lead now, versus what you used to do? And then I'm going to ask you the opposite, but let's start there.

**中文翻译:**
Centered 能帮你做到这些，还有音乐之类的，很酷。我很喜欢。太棒了。比起以前的工作，你现在最喜欢这种生活的哪一点？待会儿我会问你相反的问题，但我们先从好的开始。

---

### [00:41:27] Gergely Orosz

**English:**
I really like that it forces me to have my calendar empty, because for so many years my calendar was this giant mess of meetings on top of meetings, and I would barely have any time to actually have focus time. Now I actually have the opposite. I usually have a lot of focus time, and I have very, very few meetings or things. And even now I get a little bit cagey [inaudible 00:41:51] I have this one meeting in the whole day. So I like how it's [inaudible 00:41:55] manage your time [inaudible 00:41:58] so that's the best part.

**中文翻译:**
我真的很喜欢它强迫我保持日历空白，因为这么多年来，我的日历一直是一团糟，会议叠着会议，我几乎没有任何真正的专注时间。现在恰恰相反。我通常有大量的专注时间，会议或杂事非常少。甚至现在，如果我一整天有一个会，我都会觉得有点被打扰了。所以我喜欢这种掌控时间的感觉，这是最棒的部分。

---

### [00:41:59] Gergely Orosz

**English:**
And I also like how much in charge I am. Initially it freaked me out, in the sense of how much creative freedom I have. I can write about whatever. I can change a format, I can do this, I can do that. It can be a little bit overwhelming, because I also know that people are going to be reading this, and what are they going to think about it? But I do like that it's very entrepreneurial, so I get to experiment a lot as well, which reminds me a little bit of my old job, because at Uber we also experimented a lot, and obviously more in a corporate setting. But I guess that's just gotten extended. So these are the two favorite things, is the open calendar or very few meetings, and experimenting, trying out stuff and being able to decide what I want to try out.

**中文翻译:**
我也喜欢这种“说了算”的感觉。最初这让我有点害怕，因为创作自由度太大了。我可以写任何东西，可以改变格式，可以做这做那。这有时会让人不知所措，因为我也知道人们会读到这些，他们会怎么想？但我确实喜欢这种极具创业精神的感觉，我可以进行大量的实验，这让我想起了一点旧工作，因为在 Uber 我们也经常做实验，当然是在公司环境下。我想这只是那种感觉的延伸。所以这两点是我最喜欢的：空白的日历（极少的会议），以及能够实验、尝试并决定我想尝试什么。

---

### [00:42:46] Lenny

**English:**
Plus one on both those. I have a rule of no meetings before 3:00 PM, and it generally works 99% of the time. And the reason I do that is, to your point, if there's a meeting at 11:00, I just can't do anything really deep until that point, and then afterwards I have to get back on track. And having that deep focus time is so important for this work, even though half the time I'm on Twitter and distracted, as long as I get enough time to focus, good things happen. Okay. Opposite. What are some of the most surprising downsides and sucky parts of this path that you've taken?

**中文翻译:**
这两点我完全赞同。我有一个原则：下午 3 点前不安排会议，99% 的时间都行得通。原因正如你所说，如果上午 11 点有个会，在那之前我就没法做任何深度工作，会后我还得重新找回状态。拥有深度专注时间对这项工作至关重要，尽管我有一半时间在 Twitter 上分心，但只要我有足够的专注时间，好事就会发生。好，反过来。你走这条路以来，最让你惊讶的缺点或糟糕的部分是什么？

---

### [00:43:24] Gergely Orosz

**English:**
One is obviously it's lonely. I do miss... I had a really good team at Uber, and it wasn't just a team, it was the people. I liked... Everyone has different views on remote work. I actually didn't enjoy remote work as much, because I just liked hanging out with people. I guess I'm that more outgoing type, and I really like walking up to the coffee station and having a chat with people, or at lunch sitting next to someone and talking about it. And obviously in some sense it was annoying, because I wanted to get work done, but for the most part I miss it more than I have. And so I miss not having that. I compensate for that by working in a shared workspace, a shared office, which is a techy workspace. So everyone needs to work in tech. So I actually get to say hi to people and have a little small talk.

**中文翻译:**
首先显然是孤独。我确实很怀念……我在 Uber 有一个非常棒的团队，不仅仅是团队，而是那些人。我喜欢……每个人对远程办公都有不同的看法。我其实没那么享受远程办公，因为我喜欢和人待在一起。我想我是那种比较外向的人，我真的很喜欢走到咖啡站和人聊天，或者午餐时坐在某人旁边聊聊。显然从某种意义上说这很烦人，因为我想完成工作，但大部分时间我怀念它胜过讨厌它。所以我怀念那种氛围。我通过在共享办公空间工作来弥补这一点，那是一个科技氛围浓厚的办公室，每个人都从事科技行业。所以我可以和人打个招呼，闲聊几句。

---

### [00:44:08] Gergely Orosz

**English:**
The structure is weird, because I felt really guilty for the first few months, because I felt that at Uber I was more productive, because I had to be. I was doing so many things. In a day, I would start my day let's say at 9:00 or at 8:30, and I'd finish it up at, I don't know, 6:00 or 5:30, it depends. I would probably have, on an average day, I would have a good eight meetings, I would finish two or three documents, I would send over this, send over that. I actually have... Looking at my output, now I write a lot, but I wrote a lot. I think I wrote almost as much in terms of emails, chat messages, et cetera. So the downside is, I felt very guilty and a little bit frustrated for myself, for feeling that I'm slacking off. That's one.

**中文翻译:**
结构感也很奇怪。最初几个月我感到非常内疚，因为我觉得在 Uber 时我更高效，因为我不得不高效。我当时做那么多事。一天中，我可能 8:30 或 9:00 开始，5:30 或 6:00 结束。平均每天我会有 8 个会，完成两三份文档，发送各种东西。其实看看产出，我现在写得很多，但以前也写得很多。我觉得以前写的邮件、聊天信息等总量也差不多。所以缺点是，我会感到非常内疚，对自己感到沮丧，觉得自己在偷懒。这是其一。

---

### [00:44:55] Gergely Orosz

**English:**
And the other thing, it is surprisingly stressful. So when you start off, it's kind of lonely. Not many people do this, what we do. That's also one of the reasons that we connected, because it's a very small community. And even within the community, I feel, in the newsletter community, it's different. You're all running your own business, and there is some level of competition. So you might not... Because it's a little bit of attention economy as well. People are not going to subscribe or pay for ten newsletters on the same topic, so that makes it a little bit more... It's not the same as when you work in tech, and you just share exactly everything that you do, because you can only win.

**中文翻译:**
另一件事是，压力大得惊人。刚开始时很孤独，没多少人做我们这种事。这也是我们建立联系的原因之一，因为这是一个非常小的圈子。即使在 Newsletter 圈子里，我觉得也不同。大家都在经营自己的业务，存在一定程度的竞争。因为这在某种程度上也是注意力经济。人们不会订阅或付费买十份关于同一个主题的 Newsletter，所以这让情况变得有点复杂……这不像在科技公司工作，你可以分享你做的每一件事，因为那样只会共赢。

---

### [00:45:35] Gergely Orosz

**English:**
So there's that part, but there's a lot of external validation, so whenever looking at your subscriber numbers, which brings a bunch of stress that I didn't expect. And I'm a successful newsletter [inaudible 00:45:47] I think my success is quite rare. There will be one or two or a handful of people who have similar success, but I'm an outlier. So that's another thing that I think is just good [inaudible 00:45:58] putting out there. And the downside is, you don't really know how well you're doing. External goals are kind of meaningless. Internal goals, either you smash them or you don't reach them. So there's this constant sense of, where am I? How am I, and how do I judge myself? Did I make a mistake for leaving my job? I actually asked myself for several months actually, after I started. Or did I make a good one? And I think for a lot of these questions and doubts, having past professional experience working at a company is really useful to set yourself grounded.

**中文翻译:**
还有就是外部认可。每当看到订阅人数时，会带来意想不到的压力。我是一个成功的 Newsletter 创作者，但我认为我的成功是相当罕见的。可能只有一两个或极少数人有类似的成功，我是一个离群值（Outlier）。所以这是另一件我觉得值得说出来的事。缺点是你真的不知道自己做得有多好。外部目标往往毫无意义，内部目标要么被彻底击碎，要么根本达不到。所以总有一种感觉：我处于什么位置？我做得怎么样？我该如何评价自己？辞职是不是个错误？实际上在开始后的好几个月里，我都在问自己这个问题。还是说我做了一个正确的决定？我觉得对于很多这类问题和疑虑，过去在公司工作的专业经验对于让自己脚踏实地非常有用。

---

### [00:46:33] Lenny

**English:**
I actually want to ask you about that, but I'll add a couple things that I also find are major downsides of this life, because it's not all rainbows and butterflies. One is, with a paid newsletter especially, but even with a sponsored newsletter, you basically have to get something awesome out every week, in theory for the rest of your life. People are buying an annual plan every day, so that means at least a year you have to write something awesome, if you want to stop. But it's hard to stop, because as you pointed out, the income is very meaningful, and that's a hard thing to give up. And so I'm not sure exactly the exit path that exists for us, where we might have to keep writing something awesome for the rest of our life, but I imagine something will emerge and we'll think of something else that we could do.

**中文翻译:**
我其实想问你关于那点的事，但我先补充几件我也认为是这种生活主要缺点的事，因为这里并不全是彩虹和蝴蝶。第一，尤其是付费 Newsletter，甚至是赞助类 Newsletter，你基本上每周都要产出很棒的内容，理论上要写一辈子。每天都有人购买年度计划，这意味着如果你想停止，你至少还得再写一年很棒的内容。但很难停止，因为正如你指出的，收入非常可观，很难放弃。所以我不太确定我们这种人有什么“退出路径”（Exit path），也许我们余生都得不停地写出精彩的东西，但我猜总会有新东西出现，或者我们会想到别的出路。

---

### [00:47:19] Gergely Orosz

**English:**
Yeah. And it's a really good example, because for a lot of companies, and I assume a lot of listeners are working in tech, typical thing is you work hard, you build equity at a company or you build the value of the company, and then you can sell that company, and then you can have an exit and you can do whatever. For what we're doing, it's really tied to us. So however much or little my newsletter will make, it'll have a value let's say four or five times the annual revenue as a business, but you cannot really sell it like that and you cannot really walk away.

**中文翻译:**
是的。这是一个很好的例子。对于很多公司——我假设很多听众都在科技行业工作——典型的情况是你努力工作，建立公司股权或提升公司价值，然后你可以卖掉公司，实现退出，然后想干嘛干嘛。而我们所做的事情，是和我们个人深度绑定的。所以无论我的 Newsletter 赚多赚少，作为一个业务，它的价值可能是年收入的四五倍，但你没法那样把它卖掉，也没法真正抽身离开。

---

### [00:47:49] Gergely Orosz

**English:**
So that makes it unique, it makes it harder to compete with, which is cool, but it does not create that much of an exit path unless you start to build a company around it, build an organization that can run without you, for example. This is what a lot of book publishing companies... So basically you build a publishing company where you start to hire people, who start to write some of the articles initially, and then later more of them, but it's not a one-person newsletter any more. Or you keep doing this, until you either stop and then the revenue stops, or you might be able to sell it, but at really under value.

**中文翻译:**
这让它变得很独特，更难被竞争，这很酷，但它确实没留下多少退出路径，除非你围绕它建立一家公司，建立一个没有你也能运行的组织。很多图书出版公司就是这么做的……基本上你建立一个出版公司，开始雇人，最初让他们写一部分文章，后来写更多，但那就不是一个人的 Newsletter 了。或者你就一直做下去，直到你停下来，收入也随之停止；或者你可能卖掉它，但价格会大打折扣。

---

### [00:48:24] Lenny

**English:**
I really don't want to manage people. I don't want to have employees. And so building a media company with writers, that doesn't sound too fun, but maybe that's where this goes. That is one route, for sure. The other downside I'll just add is the fact that you have to write something awesome every week, it's hard to take meaningful time off, because if you stop producing great stuff, people leave. And I invented this PTO policy for myself where I take four weeks a year off, where I don't do a newsletter, but that means I can't take more than a week off usually [inaudible 00:48:58] weeks in a row, I don't know, people probably won't care, but it feels like things start to not go great if I just don't keep producing great stuff. So that's another downside, just [inaudible 00:49:08] topic.

**中文翻译:**
我真的不想管理别人，不想有员工。所以建立一个带作家的媒体公司听起来并不好玩，但也许这就是终点。这确实是一条路。我想补充的另一个缺点是，因为你每周都得写出精彩的东西，很难真正休个长假。因为如果你停止产出好内容，人们就会离开。我为自己发明了一个带薪休假（PTO）政策，每年休息四周不发 Newsletter，但这通常意味着我不能连续休息超过一周。我不知道，也许人们并不在乎，但感觉如果我不持续产出好东西，情况就会开始变糟。所以这是另一个缺点。

---

### [00:49:09] Gergely Orosz

**English:**
Yeah. But a lot [inaudible 00:49:11] very early. So I think the whole concept of paying users is new, so I think we're going to do a lot of experimentation. And also a lot of it, I think you need to figure out what your needs are. So in the first year, I did not take a holiday in terms of... Or even when I [inaudible 00:49:25] I was writing, and it caused a bit of friction with my family. And now I'm solving it in a different way, so I am planning to take more time off now, and I'm doing it by working ahead with some of the less time sensitive things. But it is tough.

**中文翻译:**
是的。但很多事情还处于早期。我觉得付费用户的整个概念还很新，所以我们会进行很多实验。而且很大程度上，你需要弄清楚你的需求是什么。在第一年里，我没有休过假……或者即使我休假时，我也在写作，这跟我家人产生了一些摩擦。现在我正用不同的方式解决这个问题，我计划多休点假，通过提前完成一些时效性不强的内容来实现。但这确实很难。

---

### [00:49:43] Gergely Orosz

**English:**
So a downside we haven't mentioned, but I'm just going to call it out, is holiday. The great thing at... I never felt... Well, I felt a little guilty sometimes taking holiday, but when I want a holiday, I took it off. When I had my son born, at Uber, they gave me a four month paid holiday. I took the whole four months, I just logged off. It was great. It wasn't my company. I was still getting stock. The stock price was independent of mostly what I was doing, just being honest. And that was really, really good. So this might be true, by the way, if you start any business, especially while it's just yourself, it's hard to turn off. And I think most people don't mind, I don't mind, but it gets to you. We should be conscious about burnout as a whole. So you need to solve for that, and I'm starting to solve for that as well.

**中文翻译:**
我们还没提到的一个缺点——我要指出来——就是假期。在大公司工作的好处是……我从没觉得……好吧，有时休假会有一点点内疚，但当我想休假时，我就休了。当我儿子出生时，Uber 给了我四个月的带薪假。我休满了四个月，完全下线。那感觉太棒了。那不是我的公司，我照样拿股票，股价跟我做的事基本没关系，说实话。那真的非常好。顺便说一下，如果你开始任何业务，尤其是只有你一个人的时候，很难彻底关机。我想大多数人并不介意，我也不介意，但它会慢慢消耗你。我们应该意识到职业倦怠（Burnout）的问题。所以你需要解决这个问题，我也正在开始解决它。

---

### [00:50:30] Lenny

**English:**
Yeah. Okay. Enough about the downsides. Overall, it's pretty amazing making hundreds of thousands of dollars writing an email once a week/twice a week. So just to wrap up on that, I'm curious, where do you think this goes long term for you? And then I want to talk about just what it takes to be successful, but before there, do you think this goes long term?

**中文翻译:**
好，缺点聊得够多了。总的来说，每周写一两封邮件就能赚几十万美元，这已经很神奇了。关于这一点，我很好奇，你觉得你的长期发展方向是什么？然后我想聊聊成功的要素，但在那之前，你对长期有什么打算吗？

---

### [00:50:50] Gergely Orosz

**English:**
I stopped making long term plans, because three years ago you would've asked me what I wanted to do, and I was like, "I want to be, I don't know, a manager of managers." And then I became one. And then [inaudible 00:51:01] what is my dream? I would've been like, "It's a stretch, but maybe I want to be a site lead." And I didn't become one per se, but I never thought of writing a newsletter, or now writing a successful newsletter. So I'm going with the flow. I'm seeing this less, by the way, as a newsletter or creator, or creator economy as people like to see it. I see this as a business, and I'm trying to put on that business hat. I'm building a one-person business. I want to make it sustainable, I want to make it successful, and I find that this thinking really helps me detach as well. I can actually enjoy my weekends as opposed to thinking, "I need to write this, or I need to write that." So I also want to make it work for me.

**中文翻译:**
我不再做长期计划了。因为三年前如果你问我想做什么，我会说：“我想成为，我不知道，经理的经理。”然后我做到了。如果你问我的梦想是什么，我会说：“虽然有点难，但也许我想成为一个站点的负责人（Site Lead）。”我并没有真正成为那样的人，但我从未想过会写 Newsletter，更没想过会写出一份成功的 Newsletter。所以我顺其自然。顺便说一下，我并不太把这看作一份 Newsletter 或创作者、创作者经济（人们喜欢这么叫）。我把它看作一门生意，我正努力戴上商人的帽子。我正在建立一个人的公司。我想让它可持续，想让它成功，我发现这种思维方式真的能帮我抽离出来。我可以真正享受周末，而不是总想着“我得写这个，或者我得写那个”。所以我也想让它为我服务。

---

### [00:51:40] Gergely Orosz

**English:**
And I'm not married to the idea of, it always needs to be a newsletter, et cetera. Right now it is, but where I see us going is, I'll keep building the business, I'll keep playing to my strength, which is I love talking with people, I love writing [inaudible 00:51:56] I love software engineering. So this is a great format, but over time it might shift. So I'm keeping my options open. And what I've learned from this journey is, you need to create time for that spark to come. So one of my goals for next few years is to not spend 50 hours a week on a newsletter, which I'm doing right now, but spend 20, and then maybe take a few weeks off and have that spark come. Because the reality is, this newsletter only came because I gave myself six months of unpaid... I'm not going for work, I didn't ask for any LinkedIn emails. And the idea came and the inspiration came and the motivation came.

**中文翻译:**
我并不执着于它必须永远是一份 Newsletter。目前它是，但我认为未来的方向是：我会继续建立这个业务，继续发挥我的长处——我喜欢与人交谈，喜欢写作，热爱软件工程。所以这是一个很好的形式，但随着时间的推移，它可能会发生转变。所以我保持开放的选择。我从这段旅程中学到的是，你需要创造时间让灵感迸发。所以我未来几年的目标之一是，不要每周花 50 小时在 Newsletter 上（我现在就是这么做的），而是花 20 小时，然后也许休息几周，让灵感出现。因为现实是，这份 Newsletter 之所以出现，是因为我给了自己六个月的不工作时间……我不去上班，不理会 LinkedIn 上的邮件。然后点子出现了，灵感出现了，动力也随之而来。

---

### [00:52:36] Lenny

**English:**
There's a lot of similarities with my approach. I don't think too far long term. I have no idea what's going to happen. I just take it to... I see where pull is coming from, and if it feels like an interesting opportunity and something that I'd be excited to work on, I explore it, like the podcast for example. And on that point, I will say, once you find that you can spend maybe 20 hours on a newsletter, I guarantee you'll find more work to fill that gap, because that's what I've been doing.

**中文翻译:**
我的方法有很多相似之处。我不考虑太长远的未来，我完全不知道会发生什么。我只是……我观察“拉力”来自哪里，如果它看起来是一个有趣的机遇，而且是我乐于投入的事情，我就会去探索，比如这个播客。关于那一点，我想说，一旦你发现你每周只需要花 20 小时在 Newsletter 上，我保证你会找更多的工作来填补那个空缺，因为我就是这么做的。

---

### [00:53:00] Gergely Orosz

**English:**
Yeah. And one last thing to touch on, you said something really important [inaudible 00:53:06] pull, and I want to double down on that. One of the biggest, best things about doing what we do when you're in charge of your time is, you can double down on pulls. So [inaudible 00:53:18] Uber, like I said, my plan was, I'll write this book for six months. Two months in, I just put a draft [inaudible 00:53:24] a really long blog post about mobile engineering, and I got a ton of messages, a lot. I usually used to get like three or four messages on Twitter per day. I got 20 in an hour, people saying, "Can I read the draft?" And I was like, that's interesting. I just felt this pull, of this huge interest of people caring about this. It was this really long blog post about mobile engineering at scale, and someone suggested on a private message, "You could probably turn this into a ebook." And I was like, that's a good idea, because it's a really long blog post. So I said, "It's going to be an ebook, and it'll be pay what you want." And then people started to buy it. And I was like, that's interesting.

**中文翻译:**
是的。最后补充一点，你提到了“拉力”（Pull），这非常重要，我想强调一下。当你掌控自己的时间时，做我们这类工作最大的好处之一就是你可以对“拉力”加倍下注。就像我说的，离开 Uber 后，我的计划是花六个月写那本书。两个月后，我发了一篇关于移动工程的超长博客文章草稿，结果收到了海量的私信。平时我 Twitter 每天也就三四条私信，那天一小时就收到了 20 条，人们都在问：“我能读读草稿吗？”我想，这很有趣。我感受到了这种拉力，人们对这个非常感兴趣。那是一篇关于大规模移动工程的长文，有人私信建议：“你或许可以把它变成一本电子书。”我想，好主意，因为它确实很长。于是我说：“这将是一本电子书，价格随缘（Pay what you want）。”然后人们就开始买了。我想，这太有意思了。

---

### [00:53:57] Gergely Orosz

**English:**
So I didn't have much else to do, so I was able to double down. I said, for the next two months, I'm going to write this book, because it seems there's an interest in it. And [inaudible 00:54:07] I turned it into a book that was free for two months, but I got sponsorship. The point was, I was able to double down on this pull. And same thing with the newsletter. So we're going to talk about how I got the first few thousand subscribers, but the point was, I was able to double down on something that I felt like, this is super interesting, I never expected that people would care about building a large mobile app, more than a few hundred people. Turns out they do. Thousands do.

**中文翻译:**
因为我当时没别的事做，所以我可以加倍投入。我说，接下来的两个月我要写这本书，因为看起来大家很感兴趣。后来我把它变成了一本前两个月免费的书，但我拿到了赞助。重点是，我能够顺着这种拉力走。Newsletter 也是一样。我们待会儿会聊我如何获得最初的几千个订阅者，但关键在于，我能够加倍投入到我觉得非常有趣的事情上。我从未预料到会有几百人以上关心如何构建大型移动应用，结果证明，成千上万的人都在关心。

---

### [00:54:30] Lenny

**English:**
Let's actually jump to that. Let's talk about just how to get started, for folks that are like, "This is cool. I want to do a newsletter." Let's talk about just how you got started briefly, and then what you think it takes to be successful in the life of a newsletter person. So how'd you actually get your first thousand subscribers?

**中文翻译:**
那我们直接聊聊这个吧。对于那些觉得“这很酷，我也想做 Newsletter”的人，聊聊该如何开始。简要说说你是如何起步的，以及你认为作为一个 Newsletter 创作者，成功的要素是什么。你是如何获得最初的一千个订阅者的？

---

### [00:54:51] Gergely Orosz

**English:**
I'll tell the story that is kind of true, and people will think it's amazing, and also the real deal behind it.

**中文翻译:**
我会讲一个听起来很神奇的“表面”故事，以及它背后真正的“真相”。

---

### [00:54:57] Lenny

**English:**
Okay, great.

**中文翻译:**
好的，太棒了。

---

### [00:54:58] Gergely Orosz

**English:**
I announced my newsletter, I told people, "I'm going to go full time on this." I had maybe 10,000 Twitter followers and, I don't know, maybe 1,000 on LinkedIn or something that. And people started signing up the next day. I had 100 subscribers in the first day before I published anything. And within six weeks, when I published my [inaudible 00:55:15] I had 1,000 paid subscribers. And this sounds like a fairytale. And if you do this, I guarantee you're not going to get the same results. In fact, you'll probably see way smaller numbers.

**中文翻译:**
我宣布了我的 Newsletter，告诉大家：“我要全职做这个了。”当时我大约有 1 万个 Twitter 粉丝，LinkedIn 上大概有 1000 个。第二天人们就开始注册了。在我发布任何内容之前，第一天就有 100 个订阅者。六周之内，当我发布 [听不清] 时，我已经有了 1000 个付费订阅者。这听起来像个童话。但如果你也这么做，我保证你不会得到同样的结果。事实上，你看到的数字可能会小得多。

---

### [00:55:25] Gergely Orosz

**English:**
What I didn't tell is that there was at least six years of accidental work behind this. I started a blog six years before... Actually, I've always been blogging since I graduated. I had this personal blog where I just published all sorts of random things about software engineering, but it was really... Sometimes it was about an app that I published, sometimes it was a problem that I came across. It was is all over the place. And I got fed up with this, the blog wasn't going anywhere, and I was just writing for myself, by the way, but I didn't how it was just all over the place.

**中文翻译:**
我没说的是，这背后至少有六年的“意外”积累。我在六年前就开始写博客了……实际上，我从毕业起就一直在写博客。我有一个个人博客，发布各种关于软件工程的杂七杂八的东西，但真的很乱……有时是关于我发布的一个 App，有时是我遇到的一个问题。内容非常分散。我后来厌倦了，博客也没什么起色，顺便说一下，我当时只是为自己而写，但我讨厌它那么杂乱无章。

---

### [00:55:56] Gergely Orosz

**English:**
And I said, "I'm going to start a blog, it'll be about software engineering and I'll call it The Pragmatic Engineer." I bought the domain, and I read this blog post from Jeff Atwood, who's the founder of Stack Overflow, and back in 2010, or I think in 2007 when I was still in college, he had the most popular blog on the internet for software engineers. It was called Coding Horror, and all the software engineers I knew read it and were drinking it. It was next level wisdom every single week, twice [inaudible 00:56:26] a week. You read it as well?

**中文翻译:**
于是我说：“我要开始一个新博客，专门讲软件工程，名字就叫《The Pragmatic Engineer》（务实的工程师）。”我买了域名，读了 Jeff Atwood 的一篇博文，他是 Stack Overflow 的创始人。在 2010 年，或者 2007 年我还在上大学的时候，他拥有互联网上最受软件工程师欢迎的博客，叫作《Coding Horror》。我认识的所有软件工程师都在读它，简直如获至宝。每周两次，那都是更高维度的智慧。你也读过吗？

---

### [00:56:29] Lenny

**English:**
[inaudible 00:56:29] Yeah. I used to be an engineer, and I was all up in that. And I think Coding Horror came from a... I forget the book, but there's a book with that graphic.

**中文翻译:**
是的，我以前也是工程师，我也经常读。我觉得《Coding Horror》这个名字来自……我忘了哪本书了，但有一本书用了那个插图。

---

### [00:56:36] Gergely Orosz

**English:**
There's a book, and there's a graphic. Yeah. And he wrote a post which really stuck with me for years. He said, how to be famous on the internet. He said, there's three simple steps. One, write a blog post. Two, do this three times a week. Three, do it for two years. And I guarantee, if you do this, you're going to be famous. And I always thought it's kind of ironic, but the more I read it, the more I thought he actually means something with it. And when I started this blog, The Pragmatic Engineer, I said, "I'm tired of my old blog being all over the place, and there's no focus, and no-one really cares about it. I'm going to do what Jeff Atwood said. I'm going to publish... Okay, it's not going to be twice a week, but every two weeks I'm going to publish an article, and I'll do it for a year." So I started to do this. I published six blog posts about software engineering, going into topics that I [inaudible 00:57:25] research and all that, and then I gave up.

**中文翻译:**
有一本书，也有那个插图。是的。他写过一篇博文，让我记了很多年。他说，如何在互联网上成名。他说有三个简单的步骤：第一，写一篇博文；第二，每周写三次；第三，坚持两年。我保证，如果你这样做，你就会成名。我一直觉得这有点讽刺，但读得越多，我越觉得他是认真的。当我开始《The Pragmatic Engineer》这个博客时，我说：“我厌倦了旧博客的杂乱无章，没有重点，也没人关心。我要按 Jeff Atwood 说的做。我要发布……好吧，不是每周两次，但每两周我要发一篇文章，坚持一年。”于是我开始做了。我发表了六篇关于软件工程的深度博文，然后我就放弃了。

---

### [00:57:27] Gergely Orosz

**English:**
And I'm saying this because I kind of gave up, and I left it for a few months, but then something interesting happened. I had a huge traffic spike, and it crashed my shared hosting at the time. And it came from a site called Hacker News that I [inaudible 00:57:41] heard about, and people were discussing my posts, and they were adding a lot of things. And I was like, that's interesting. People care about what I wrote six months ago.

**中文翻译:**
我之所以这么说，是因为我当时确实放弃了，丢在那儿好几个月没管。但后来发生了一件有趣的事。我的流量突然暴增，冲垮了当时用的虚拟主机。流量来自一个叫 Hacker News 的网站，我听说过它。人们在讨论我的文章，并补充了很多内容。我想，这很有趣，人们居然关心我六个月前写的东西。

---

### [00:57:49] Lenny

**English:**
What was that post, by the way?

**中文翻译:**
顺便问一下，那是哪篇文章？

---

### [00:57:50] Gergely Orosz

**English:**
It was called, "A comment is an invitation for refactoring." I wrote my view that if there's a comment in a code, that means that comment should be deleted and you should just refactor the whole thing. And it exploded on Hacker News. Some people called me an idiot, some people called me absolute wisdom, and it was these two crowds battling it out. And I was like, wow, I actually made software engineers in Silicon Valley argue about my stuff. I saw some of the [inaudible 00:58:17] people, some really high [inaudible 00:58:18] people were really going for [inaudible 00:58:21]. So that's when I thought [inaudible 00:58:23] my writings, some people might read it, it's not guaranteed.

**中文翻译:**
文章标题是《注释是重构的邀请》。我表达了我的观点：如果代码里有注释，那意味着注释应该被删掉，你应该直接重构整个代码。它在 Hacker News 上火了。有些人骂我是白痴，有些人说这是至理名言，两拨人在那儿激烈交锋。我想，哇，我居然让硅谷的软件工程师们为我的东西争论不休。我看到一些非常资深的大佬也在参与讨论。就在那时我觉得，我的文章可能真的有人读，虽然不保证每次都火。

---

### [00:58:26] Gergely Orosz

**English:**
And I started to write on that blog once every few months, depending on my mood, but I never stopped doing it. And I partially did it [inaudible 00:58:35] always hoped that it would get onto this site called Hacker News. But by the way, for a while, I didn't even know you could submit it, so I never submitted my own things. But the other thing was, I just kind of liked it, and I had this habit, and over years... I had this blog from 2015. For six years I was writing that blog, and in the last year... When I worked at Uber, on the side I wrote about my work, in terms of the things that I could write about, not about the details that we did, but some of the learnings [inaudible 00:59:02] for example, distributed systems. And more and more of these posts just started to just pop up on Hacker News. People would either submit it, or sometimes when I submitted it, it would just do well. And I was thinking, so people... I started to get this validation, people care about what I write.

**中文翻译:**
我开始每隔几个月在博客上写一篇，看心情，但我从未停止。部分原因是我一直希望它能登上 Hacker News。顺便说一下，有段时间我甚至不知道可以自己提交，所以我从不提交自己的东西。另一方面，我只是有点喜欢写作，并养成了这个习惯。多年来……我从 2015 年开始写这个博客。我写了六年，在最后一年……当我在 Uber 工作时，我业余时间会写写我的工作，当然是那些能写的东西，不是具体细节，而是一些心得，比如分布式系统。越来越多的文章开始出现在 Hacker News 上。要么是别人提交的，有时我自己提交，效果也很好。我想，原来人们……我开始得到这种认可，人们关心我写的东西。

---

### [00:59:16] Gergely Orosz

**English:**
And to question of the success of the newsletter, by the time I launched a newsletter, I had a lot of posts that a lot of software engineers read, and there was a very famous post about performance management, how to do performance reviews. I wrote one about the tri-modal nature of software engineering salaries, where I observed that there's three different tiers that are... There's big tech and there's local companies. And I think what happened is, when I announced that I'm going to write this newsletter, I also put it on the blog. A lot of people realize that they... "I've been reading this Pragmatic Engineer, I don't know who is behind it, but I like it. Let me sign up. I do want to get an email every week, instead of the things that were every now and then."

**中文翻译:**
关于 Newsletter 成功的问题，当我推出它时，我已经有很多被大量软件工程师读过的文章了。有一篇关于绩效管理、如何做绩效评估的文章非常出名。我还写了一篇关于软件工程薪资“三峰性”（Tri-modal nature）的文章，我观察到薪资分为三个不同的层级：大厂和本地公司。我想发生的事情是，当我宣布要写 Newsletter 并发在博客上时，很多人意识到：“我一直在读《The Pragmatic Engineer》，我不知道背后是谁，但我喜欢它。让我注册吧，我确实想每周收到一封邮件，而不是偶尔才看到更新。”

---

### [00:59:56] Gergely Orosz

**English:**
So there was years of work, and I wish I could tell you how to build a successful newsletter, but the best advice I have is still what Jeff Atwood does, except I have less conviction. But if you start writing, and you do it regularly, two things will happen. First of all, you're going to [inaudible 01:00:11] you write for yourself and you keep improving, you'll be a better writer. That's for sure. If you're lucky or if you're right about stuff, you might start to attract people who think similarly. So step one is get started. Step two is keep it up. And my suggestion is [inaudible 01:00:26] for yourself. The weird thing is, until I started my newsletter, I never thought I would turn this ever into a business, but it always felt rewarding. So I never... If you're starting out writing a newsletter to do what I'm doing one day, it might work out. But interesting enough, I never even thought that this was an opportunity.

**中文翻译:**
所以这是多年的积累。我希望我能告诉你如何建立一份成功的 Newsletter，但我最好的建议依然是 Jeff Atwood 的那一套，只是我的语气没那么肯定。但如果你开始写作并定期坚持，会发生两件事：首先，你会为自己而写并不断进步，你会成为一个更好的作家，这是肯定的。如果你运气好或者写对了东西，你可能会开始吸引志同道合的人。所以第一步是开始，第二步是坚持。我的建议是为自己而写。奇怪的是，直到我开始做 Newsletter 之前，我从未想过把它变成一门生意，但它总是让我感到很有成就感。所以……如果你开始写 Newsletter 是为了有一天能达到我现在的状态，那可能会成功。但有趣的是，我以前从未想过这是一个机会。

---

### [01:00:48] Lenny

**English:**
So people listening to this that are thinking about, should I explore this life? If you think about your story, you wrote a book, you blogged for a while before this, you worked at Uber for a number of years. In a sense, it comes across a little bit like, there's no way I can be successful if that's the background I need to have. I have to have written things and worked at an awesome tech company. What advice do you give folks that are coming to you being like, "Gergely, should I start a newsletter? Does it make sense for me?" Do you need the background that you have, do you think?

**中文翻译:**
所以听众里那些在考虑“我是否该探索这种生活”的人，如果看你的故事：你写过书，之前写了很久博客，在 Uber 工作了很多年。在某种意义上，这听起来像是：如果我必须有这样的背景才能成功，那我肯定没戏。我必须写过东西，还得在牛逼的科技公司工作过。对于那些来问你“Gergely，我该开始 Newsletter 吗？这对我合适吗？”的人，你有什么建议？你觉得必须有你这样的背景吗？

---

### [01:01:21] Gergely Orosz

**English:**
Don't forget that when I started my blog, I didn't have any of this.

**中文翻译:**
别忘了，当我开始写博客时，我什么都没有。

---

### [01:01:24] Lenny

**English:**
And this was while you were at Uber. This is before you started the newsletter.

**中文翻译:**
那是你在 Uber 的时候，是在你开始 Newsletter 之前。

---

### [01:01:28] Gergely Orosz

**English:**
It was before I was at Uber. So I was maybe at Skyscanner, or maybe at Skype, but I was even blogging before. I was talking to conferences before. So my advice really would be, if you're thinking of a newsletter or something similar, start teaching and sharing what you know and what you're observing. This could be a newsletter, this could be a YouTube video, this could be going to meetup. Actually, ten years ago I went to a lot of meetups where I presented all sorts [inaudible 01:01:54] I met a lot of cool people. I would say, share your knowledge one way or the other. And as you're doing it, you're going to learn a lot more.

**中文翻译:**
那是在我进 Uber 之前。我当时可能在 Skyscanner，或者 Skype，但我甚至在那之前就在写博客了。我以前也参加过会议演讲。所以我的建议是，如果你在考虑做 Newsletter 或类似的事情，开始教导和分享你所知道的和你观察到的东西。这可以是一份 Newsletter，可以是一个 YouTube 视频，也可以是参加线下聚会（Meetup）。事实上，十年前我参加了很多聚会，做了各种演讲，认识了很多酷的人。我会说，以某种方式分享你的知识。在你分享的过程中，你会学到更多。

---

### [01:02:01] Gergely Orosz

**English:**
So what I find... This is true, when I was a manager, we had to set goals, and I told people there's two types of goals you can set. One is [inaudible 01:02:12] people set this goal, I want to be promoted the next thing, or I want to lead this big project. And those are bad goals, because it's not in your control. So setting a goal that I want to have a successful newsletter with, I don't know, 20,000 subscribers, that's a goal where you're not in charge. A good goal is what you can do. So a good goal for example is, I want to learn this new language in the next year, which I'm going to spend time on, or I want to leave work at 5:00 PM on Fridays to be home with family. So set those goals that you can control.

**中文翻译:**
我发现……这是真的，当我当经理时，我们需要设定目标，我告诉大家目标有两种。一种是人们常设的目标，比如“我想晋升”或“我想领导这个大项目”。这些是坏目标，因为它们不在你的控制之下。所以设定一个“我想要一份拥有 2 万订阅者的成功 Newsletter”的目标，那是你无法掌控的。一个好目标是你自己能做到的事。比如，“我想在明年学会这门新语言，我会为此投入时间”，或者“我想在周五下午 5 点下班回家陪家人”。设定那些你能控制的目标。

---

### [01:02:41] Gergely Orosz

**English:**
And this is how actually my blog started initially. My goal was, I want to write once a month. And I did that for a while, and I was proud about that. Or whenever I learn something, I actually want to share it every now and then. So I would say set those goals, and the rest will come, probably. Again, don't get me wrong, I'm not trying to talk people out of doing it. But for me, a lot of this was luck. And the other thing that I would suggest is be curious, and look at your professional career as well. One thing that definitely helped me is getting pedigree. I come from a small country, from a really good university which no-one knows about, but I didn't grow up in let's say Silicon Valley, so I actually made a subconscious point to try to work my way up. And after I got to let's say JPMorgan in London, I was pretty picky of where I would go next. So that's why, when Skype came along [inaudible 01:03:36] this is great. Everyone knows Skype, I love Skype. And it was same thing with Uber.

**中文翻译:**
我的博客最初就是这样开始的。我的目标是：我想每月写一篇。我坚持了一段时间，并为此感到自豪。或者每当我学到新东西，我就想偶尔分享一下。所以我会说，设定那些目标，剩下的可能自然会来。再次强调，别误会，我不是在劝大家别做。但对我来说，很大程度上是运气。我建议的另一件事是保持好奇心，并审视你的职业生涯。有一件事确实帮到了我，那就是获得“名企背景”（Pedigree）。我来自一个小国家，毕业于一所没人知道的好大学，我不是在硅谷长大的，所以我下意识地努力向上爬。当我进入伦敦的摩根大通后，我对下一站非常挑剔。所以当 Skype 出现时，我觉得太棒了，每个人都知道 Skype，我喜欢 Skype。Uber 也是一样。

---

### [01:03:40] Gergely Orosz

**English:**
So especially these days, people would not pay nearly as much attention to me if I worked at Small Parts Limited. So there's that part as well. So you need to manage some of these things, figure out what you want to do. For a long time, I pretty much thought that I just want to climb the corporate ladder and prove that I'm good enough at all these companies. I was just doing all this stuff on the side. It's interesting how it's now flipped, and now doing these things, this is my main thing, which used to be my side project.

**中文翻译:**
所以，尤其是现在，如果我在一家叫“小零件有限公司”的地方工作，人们根本不会对我关注这么多。所以背景也很重要。你需要管理好这些事情，弄清楚你想做什么。在很长一段时间里，我基本上认为我只想爬公司阶梯，证明我在所有这些公司里都足够优秀。我只是在业余时间做这些事。有趣的是，现在情况反转了，做这些事成了我的主业，而以前这只是我的副业。

---

### [01:04:07] Gergely Orosz

**English:**
And I guess one last advice is, do some side projects. All of this starts as a side project. At work, no-one's really going to appreciate that you're doing a newsletter or this or that. Try stuff on the side, assuming that you have time. Or if you don't have time, try to make time. Because I feel a lot of what we're doing is pretty entrepreneurial, and the only way you're going to get these muscles, if you start some small things.

**中文翻译:**
我想最后的建议是：做一些副业项目。所有这一切都始于副业。在工作中，没人会真正欣赏你在做 Newsletter 之类的事。假设你有时间，尝试一些副业。如果你没时间，试着挤出时间。因为我觉得我们做的很多事情都很有创业精神，而获得这种能力的唯一方法就是从一些小事开始。

---

### [01:04:31] Lenny

**English:**
You talk about the pedigree being important. I think there's also an even deeper point, that you actually need real experience doing real things that scaled and worked and mattered and worked with amazing people, to actually build a foundation to write about, share wisdom from. And that's really important. There's a lot of people starting newsletters and tweeting who haven't done much and don't have a lot of real life experience to share. And I think that's the core of a lot of what we do, is it needs to be based on real things that worked and that you've learned, or that you have access to other people who have learned these things.

**中文翻译:**
你提到了名企背景很重要。我觉得还有一个更深层的点：你确实需要真正的经验，去做那些规模化的、行之有效的、重要的事情，并与优秀的人共事，这样才能建立起写作和分享智慧的基础。这非常重要。现在有很多开始写 Newsletter 或发推的人，他们其实没做过什么大事，没有太多的实战经验可以分享。我认为我们所做工作的核心是，它必须基于真正行之有效的东西，基于你学到的东西，或者基于你能接触到的那些学到这些东西的人。

---

### [01:05:06] Gergely Orosz

**English:**
I would say that, but one thing that I'll double down [inaudible 01:05:09] that's a really good observation is, if you're serious, like one day I will want to write a book or a newsletter, it's kind of the same thing, or teach people about stuff, look at the people that you look up to that you actually trust. Maybe it's me a bit or maybe it's you, but it's more likely people like Kent Beck, for example. He's the creator of TDD, and he's written a lot of books. He's one of my favorite people, I think he's coming up 50 or 60 [inaudible 01:05:36] if he listens to this, sorry if... I don't want [inaudible 01:05:38] seem old, but what I love about Kent Beck, is he's been in the middle of it. He has always worked in the industry, and that he wrote about it. But for example, I think he invented or he was a co-inventor of... Was it TDD or extreme program... Anyway, one of these methodologies.

**中文翻译:**
我会这么说，但我还要强调一点——这是一个非常好的观察：如果你是认真的，比如有一天我想写书或 Newsletter（其实差不多），或者教别人东西，看看那些你仰慕且信任的人。也许是我，也许是你，但更有可能是像 Kent Beck 这样的人。他是 TDD（测试驱动开发）的创始人，写了很多书。他是我最喜欢的人之一，我想他快 50 或 60 岁了，如果他听到这个，抱歉……我不想让他显得老，但我喜欢 Kent Beck 的一点是，他一直身处其中。他一直在行业内工作，并以此写作。比如，他发明或共同发明了……是 TDD 还是极限编程（Extreme Programming）？总之是这些方法论之一。

---

### [01:05:58] Gergely Orosz

**English:**
And then [inaudible 01:05:58] went to work at Facebook. He took a title cut to be a software engineer, and then he hosts the TDD workshop, the test driven development workshop, and no-one showed up at Facebook. And Facebook did no testing, which went against all commercial wisdom. And he took that risk joining this company where he could have been... People would've knelt down to him anywhere else, but he went to this company where he just wanted to learn. He's this lifelong learner. He's right now writing a book. But what I think [inaudible 01:06:26] if you want to be someone who people listen to, yes, do cool and interesting stuff, push yourself to get into places that do these interesting things.

**中文翻译:**
后来他去 Facebook 工作了。他降级去做了一名软件工程师，然后他举办了 TDD 工作坊，结果 Facebook 没人参加。当时 Facebook 根本不做测试，这违背了所有的商业常识。他冒着风险加入了这家公司，而在其他任何地方，人们都会对他顶礼膜拜，但他去那儿只是为了学习。他是一个终身学习者，现在正在写一本书。所以我觉得，如果你想成为一个让人们愿意倾听的人，是的，去做酷且有趣的事，逼自己进入那些正在做有趣事情的地方。

---

### [01:06:33] Gergely Orosz

**English:**
That's how, when I went to Uber in 2016, it was one of the highest regarded places back in 2016, and in 2017 it was the other way around. But back in 2016, people were turning down Facebook and Google offers to go at Uber, which we all thought would change the world. So you do need to get into those teams that are doing interesting stuff, prove that you can do that, and you'll have a lot more interesting stories to share, that's for sure.

**中文翻译:**
这就是为什么我在 2016 年去了 Uber，当时它是最受推崇的地方之一（虽然 2017 年情况就反转了）。但在 2016 年，人们会拒绝 Facebook 和 Google 的录取通知而去 Uber，因为我们都觉得它会改变世界。所以你确实需要进入那些正在做有趣事情的团队，证明你能胜任，这样你肯定会有更多有趣的故事可以分享。

---

### [01:06:59] Lenny

**English:**
If you had to boil down advice for how to be successful in this life of a newsletter, you had to boil it down to just one or two key pieces of advice, what would you say?

**中文翻译:**
如果你必须总结一下如何在 Newsletter 这种生活中获得成功的建议，只总结为一两条关键建议，你会说什么？

---

### [01:07:10] Gergely Orosz

**English:**
One is habit of depth in the field, whatever field you do. So this might mean that I think... I don't want to say that if you don't have experience, don't start one, but it's kind of true. So become an expert somewhere, somehow, before you start, because you'll be a lot more credible. I think there's no shortage of reporters and journalists who don't know about stuff, but they can interview people, but that doesn't give anything extra, and I think people feel that.

**中文翻译:**
第一是在该领域深耕的习惯，无论你从事哪个领域。这可能意味着……我不想说如果你没有经验就不要开始，但事实确实如此。所以在开始之前，以某种方式成为某个领域的专家，因为这样你会更有公信力。我认为现在不缺那些不懂行但会采访人的记者，但这并不能提供额外的价值，我觉得读者能感觉到这一点。

---

### [01:07:38] Gergely Orosz

**English:**
So I would say choose a field that you're going to be good at. And you can start on the side, doing this. Assuming you have something, you're someone with experience in the industry or you have insights, wisdom, observations to share, start doing so, in whatever format. I do newsletters. There's actually YouTube, a lot of people are becoming pretty successful on YouTube sharing their thing. Three, have a cadence and stick to it, to some extent, because you do need to keep repeating it. And then four, don't be afraid to try out new things. A good example of a person who did these is Steve Yegge. Steve Yegge is... Have you heard of Steve Yegge?

**中文翻译:**
所以我会说，选择一个你擅长的领域。你可以从副业开始做。假设你有一些东西——你是行业资深人士，或者你有见解、智慧、观察可以分享——那就开始做吧，无论什么形式。我做 Newsletter，其实还有 YouTube，很多人在 YouTube 上分享也获得了成功。第三，保持节奏并坚持下去，因为你需要不断重复。第四，不要害怕尝试新事物。一个很好的例子是 Steve Yegge。Steve Yegge……你听说过他吗？

---

### [01:08:17] Lenny

**English:**
Yeah. He wrote some epic long...

**中文翻译:**
听说过，他写过一些史诗级的长文……

---

### [01:08:19] Gergely Orosz

**English:**
He used to work at Amazon, and then at Google he wrote this internal email about platforms, about how Amazon is great at platforms and Google is terrible. And he was really well known at Google, because he wrote stuff inside Google. So he's experienced, knows a lot of stuff, and then he quit Google and he started to do a podcast that's on YouTube. You could check it out, it's called Stevey's Podcast. And what he did is, every week he recorded an episode and he talked about a bunch of his learnings, a lot of stuff, and he was pretty clear up front when he started the first one, he said, "What I'm doing is, I'm going to do this for six months and I'll see if it sticks, see if people care about it or people watch it."

**中文翻译:**
他以前在亚马逊工作，后来在谷歌写了一封关于平台的内部邮件，讲亚马逊如何擅长平台化而谷歌做得很烂。他在谷歌非常出名，因为他在内部写了很多东西。他很有经验，懂很多东西，后来他离开谷歌开始做 YouTube 播客。你可以去看看，叫《Stevey's Podcast》。他每周录一集，聊他的心得，聊很多东西。他刚开始时就很明确地说：“我要做六个月，看看能不能坚持下去，看看人们是否关心或观看。”

---

### [01:08:55] Gergely Orosz

**English:**
Now, this guy had a lot of experience, really fun [inaudible 01:08:59] I think it's really fun to listen to. And in the end, it was I think successful. It got a couple thousand or maybe even 10,000 subscribers, but it wasn't this rocket ship. And I think what he did, he just stopped after six months, and he actually started head of engineering at Sourcegraph, he actually went back [inaudible 01:09:15] industry. But what I love about this, it shows that you cannot guarantee having success, but you can do what he did, which is start something, do a cadence, see if it sticks. If not, either pivot or do something else. I feel the world is kind of about that as well.

**中文翻译:**
这家伙经验丰富，内容也很有趣，我觉得听起来很有意思。最后我认为它是成功的，获得了几千甚至一万个订阅者，但它并没有像火箭一样爆发。我想他后来做的就是六个月后停止了，然后去 Sourcegraph 担任工程主管，回到了行业内。但我喜欢这个故事的一点是，它表明你无法保证成功，但你可以像他那样：开始做某事，保持节奏，看看是否奏效。如果不奏效，要么转型，要么做别的。我觉得世界就是这样的。

---

### [01:09:30] Gergely Orosz

**English:**
If you think about... Take a step back of, what is a successful newsletter? What is a successful podcast? What is a successful YouTube channel? And it's stuff that's interesting. It's either entertaining or educational. But all of these things, you can't really put a finger on. If you watch YouTube, Mr. Beast is someone who you probably came across, I actually like watching his videos and [inaudible 01:09:56] how good he does it, but it's not something you can [inaudible 01:09:59] anyone would have written in a book. So there is a sense of trying to understand what people care about, and a good way to understand is either experiment or observe or just try out stuff.

**中文翻译:**
退一步想，什么是成功的 Newsletter？什么是成功的播客？什么是成功的 YouTube 频道？就是那些有趣的东西。它要么具有娱乐性，要么具有教育意义。但所有这些东西，你都无法给出一个确切的公式。如果你看 YouTube，你可能见过 Mr. Beast，我其实很喜欢看他的视频，看他做得多好，但那不是任何书本能教出来的。所以你需要尝试理解人们关心什么，而理解的最好方法就是实验、观察或直接去尝试。

---

### [01:10:12] Lenny

**English:**
This is great. I feel like I can boil this down even further from everything you just said, which is, build depth in an area, then write a blog post twice a week for two years, and good things will happen.

**中文翻译:**
太棒了。我觉得我可以把你刚才说的进一步总结为：在某个领域建立深度，然后每周写两篇博文，坚持两年，好事自然会发生。

---

### [01:10:25] Gergely Orosz

**English:**
I'm pretty sure. And here's an interesting thought as well, just for closure. I was talking with someone on why my newsletter is so successful. It's really successful, and I honestly don't know why. And this person told me something interesting. This is a person who had a really successful YouTube channel with about 200,000 subscribers, so more than my newsletter. And he said this. He's like, "What I noticed is, you started your blog in 2015, 2016, and I started my YouTube channel in 2019 or something like that. And on YouTube, there's so much quality, there's super high great productions, everyone is doing YouTube." And he said, "You know what I don't see? I don't see many blogs that are writing in depth stuff regularly. I feel everyone went over to YouTube or TikTok. So there is the other angle of the medium." And I'm saying this, not [inaudible 01:11:16] but it might be an advantage. These days, fewer people write, because I think a lot of people find it hard and more people will do videos. And you can take advantage of some of these shifts, which might be good or bad.

**中文翻译:**
我很确定。最后还有一个有趣的思考。我曾和人讨论为什么我的 Newsletter 这么成功。它确实很成功，但我坦白说不知道为什么。那个人告诉我一些有趣的事，他有一个非常成功的 YouTube 频道，大约有 20 万订阅者，比我的 Newsletter 还多。他说：“我注意到，你是在 2015、2016 年开始写博客的，而我是在 2019 年左右开始做 YouTube 的。在 YouTube 上，竞争非常激烈，制作精良，每个人都在做 YouTube。”他说：“你知道我没看到什么吗？我没看到有多少博客在定期写深度内容。我觉得大家都跑去 YouTube 或 TikTok 了。所以这是媒介的另一个角度。”我说这些并不是……但这可能是一个优势。如今，写东西的人变少了，因为很多人觉得这很难，更多人去拍视频。你可以利用这些媒介的转变，这可能既是好事也是坏事。

---

### [01:11:27] Gergely Orosz

**English:**
So if you're going to be a really well known person on YouTube, you might get more people watching you, but you'll have a lot more competition. And the last thing is that for me, writing, especially with software engineers, it's really efficient, because I can scan through it. I don't like YouTube videos, especially for learning about stuff, because I can't even scan through the whole thing. It's just really time consuming.

**中文翻译:**
所以如果你想在 YouTube 上成名，可能会有更多人看你，但竞争也大得多。最后一点，对我来说，写作（尤其是针对软件工程师）是非常高效的，因为我可以快速扫读。我不喜欢 YouTube 视频，尤其是学习东西时，因为我甚至没法快速扫视全貌，太耗时了。

---

### [01:11:47] Gergely Orosz

**English:**
So I think, decide if you want to do entertainment, which for these podcast listeners, I don't think that's in the question, you're competing with the likes of Spotify and Netflix. Education, which is a little bit more dry, but it's really useful. Or edutainment, which is entertaining education. And once you figure that out, either if it's education or edutainment, you can figure out what format might work both for the medium and for you. And at end of the day, you need to enjoy it. I personally have learned over time to love writing. I love being in the zone. So for me it's not really work, but it's fun. And once you find that thing, whatever that might be, it just makes it easier.

**中文翻译:**
所以我觉得，决定你是想做娱乐（对于这个播客的听众来说，我觉得这不是首选，因为你在和 Spotify 和 Netflix 竞争）、教育（虽然枯燥但非常有用），还是寓教于乐（Edutainment）。一旦你弄清楚了这一点，无论是教育还是寓教于乐，你就可以找出适合该媒介和你自己的形式。归根结底，你需要享受它。随着时间的推移，我个人学会了热爱写作。我喜欢那种进入状态的感觉。所以对我来说，这不完全是工作，而是乐趣。一旦你找到了那件事，无论它是什么，一切都会变得更容易。

---

### [01:12:27] Lenny

**English:**
Gergely, it's always so fun talking about newsletter stuff. I don't have many people to talk about this life with. I hope this was useful to people who are exploring this path, thinking about it, or even the different creator path. Just two final questions. Where can folks find you online if they want to reach out or learn more? And how can listeners be useful to you?

**中文翻译:**
Gergely，聊 Newsletter 的事总是很有趣。我没多少人可以聊这种生活。我希望这对那些正在探索这条路、思考这条路，甚至是不同创作者之路的人有所帮助。最后两个问题：如果大家想联系你或了解更多，可以在哪里找到你？听众能为你做些什么？

---

### [01:12:45] Gergely Orosz

**English:**
You can find me at pragmaticengineer.com. There is a bunch of stuff listed there from the Twitter, LinkedIn, my talent collective, some of the companies that I invest in, et cetera. Everything's there. And you can also sign up to my newsletter. Listeners being useful to me... If you work in tech, consider signing up to my newsletter. I always tell people we're a complimentary newsletter. If you work in product or have an interest in product [inaudible 01:13:11] newsletter is an awesome choice. With software engineering management, it goes the other way. And it's not just... People are telling me when they're data scientists or even product folks, sometimes they get some value out of it.

**中文翻译:**
你可以在 pragmaticengineer.com 找到我。那里列出了我的 Twitter、LinkedIn、人才库、我投资的一些公司等等。所有东西都在那儿。你也可以订阅我的 Newsletter。至于听众能帮我什么……如果你在科技行业工作，考虑订阅我的 Newsletter。我总是告诉大家，我们的 Newsletter 是互补的。如果你做产品或对产品感兴趣，Lenny 的 Newsletter 是极好的选择。而关于软件工程管理，我的 Newsletter 则更合适。而且不只是工程师，数据科学家甚至产品经理也告诉我，他们有时能从中获益。

---

### [01:13:23] Gergely Orosz

**English:**
I write this column called the scoop every Thursday. If you hear of any interesting scoop happening, especially relevant for techies, this might be some change in the workplace, like your company is just rolling out agile [inaudible 01:13:36] team at Twitter did, feel free to ping me, just a short search for sending scoop to the Pragmatic Engineer. I treat everything as anonymous, so you can tell me interesting stuff. I'm typically interested in the stuff that you might not read about in the traditional media, but us techies really care about.

**中文翻译:**
我每周四写一个叫“独家内幕”的专栏。如果你听到任何有趣的内幕，尤其是与技术人员相关的，比如职场变动、公司推行敏捷开发、或者像 Twitter 团队那样的事，欢迎联系我。只需搜一下如何向《The Pragmatic Engineer》发送内幕即可。我会对所有信息保密，所以你可以告诉我有趣的事。我通常对那些传统媒体读不到、但我们技术人员非常关心的内容感兴趣。

---

### [01:13:51] Gergely Orosz

**English:**
And finally, if you work at Google and you want anonymity to talk to me, just ping me, because one of my next articles will be Google's engineering culture. I wrote one about Facebook, one about Amazon, and I tried to talk with mostly software engineers to get a sense of how these companies work from a software engineer and engineer manager perspective.

**中文翻译:**
最后，如果你在谷歌工作并想匿名跟我聊聊，请联系我。因为我接下来的文章之一将是关于谷歌的工程文化。我写过 Facebook，写过亚马逊，我试图主要通过与软件工程师交谈，从工程师和工程经理的角度了解这些公司是如何运作的。

---

### [01:14:11] Lenny

**English:**
Awesome. I hope this comes out before that post comes out, but if not, then enjoy that post. Gergely, thank you so much for being here. This was awesome. And maybe we'll do a V2 as things continue to grow.

**中文翻译:**
太棒了。我希望这期播客在那篇文章发布前上线，如果没有，那就请大家享受那篇文章。Gergely，非常感谢你能来。这太棒了。也许随着业务的增长，我们还会做第二季。

---

### [01:14:23] Gergely Orosz

**English:**
Awesome. It was great being here, Lenny.

**中文翻译:**
太棒了。很高兴来到这里，Lenny。

---

### [01:14:27] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。