# Gia Laudi - 双语对照

以下是《Lenny's Podcast》访谈 Georgiana Laudi（Gia）的完整双语对照文档。

---

### [00:00:00] Georgiana Laudi

**English:**
The problem with funnels and pirate metrics and the favorites that I love to pick on are MQLs and SQLs is that nobody knows what those mean. It puts every customer in the same sort of buckets. It assumes that all customers and all products are the same. It puts businesses, or they, I should say, puts businesses at the center of the business versus putting customers at the center. Right? It's about the values of the business, not the value to the customer that's being measured. Also, it just kind of feels gross for people, this idea of pushing people through a funnel. And then probably a particularly relevant for SaaS companies is that recurring revenue businesses, you cannot think about marketing and growth and the business overall as ending an acquisition, otherwise you're not in business anymore. And the vast, vast majority of these models don't take post-acquisition, retention, expansion, all of that into account. So yeah, in a nutshell, funnels are bad.

**中文翻译:**
营销漏斗（Funnels）和海盗指标（Pirate Metrics）的问题——我最喜欢拿来开涮的是 MQL（营销合格线索）和 SQL（销售合格线索）——在于没人真正明白它们意味着什么。它把每个客户都放进同样的框框里，假设所有的客户和产品都是一样的。它把企业（或者说这些模型）置于业务的中心，而不是以客户为中心。对吧？它衡量的是企业的价值，而不是给客户带来的价值。而且，这种“把人推过漏斗”的想法让人感觉很不舒服。对于 SaaS 公司来说，这一点尤为重要：在经常性收入（Recurring Revenue）业务中，你不能认为营销、增长和整体业务在完成“获客”后就结束了，否则你的生意就难以为继。绝大多数此类模型都没有考虑到获客后的留存、扩张等环节。所以，简而言之，漏斗模型是有缺陷的。

---

### [00:01:04] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny, and my goal here is to help you get better at the craft of building and growing products. I interview world-class product leaders and growth experts to learn from their hard-won experiences building and scaling today's most successful companies. Today, my guest is Georgiana Laudi. Georgiana, aka Gia, runs a consultancy called Forget The Funnel, where she works hands on with SaaS companies to help them unlock and accelerate growth.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的能力。我采访世界级的产品领导者和增长专家，从他们构建和扩展当今最成功公司的宝贵经验中学习。今天，我的嘉宾是 Georgiana Laudi。Georgiana（又名 Gia）经营着一家名为“Forget The Funnel”（忘掉漏斗）的咨询公司，她亲手协助 SaaS 公司解锁并加速增长。

---

### [00:01:30] Lenny

**English:**
As you'll hear, she often finds huge unlocks and opportunities often doubling or tripling conversion in various points in their product flows. In our conversation, she shares the exact process that she goes through to help companies figure out where their biggest growth opportunities lie, and also how to execute on them. We chat about how to identify your most important customers, how to very practically map their journey through your flows and set goals, and then execute on your ideas. There's a lot of wisdom and some fun stories packed into this episode. So with that, I bring you Gia.

**中文翻译:**
正如你将听到的，她经常能发现巨大的突破口和机会，往往能让产品流程中各个环节的转化率翻倍甚至翻三倍。在我们的对话中，她分享了她帮助公司找出最大增长机会并付诸执行的具体流程。我们聊到了如何识别最重要的客户，如何非常务实地绘制他们在你流程中的旅程并设定目标，以及如何执行你的想法。这一集充满了智慧和有趣的故事。那么，让我们欢迎 Gia。

---

### [00:02:05] Lenny

**English:**
I'm excited to chat with my friend John Cutler from podcast sponsor Amplitude. Hey, John.

**中文翻译:**
很高兴能与来自播客赞助商 Amplitude 的朋友 John Cutler 聊天。嘿，John。

---

### [00:02:10] John Cutler

**English:**
Hey, Lenny. Excited to be here.

**中文翻译:**
嘿，Lenny。很高兴来到这里。

---

### [00:02:11] Lenny

**English:**
John, give us a behind the scenes at Amplitude. When most people think of Amplitude, they think of product analytics, but now you're getting into experimentation and even just launch a CDP. What's the thought process there?

**中文翻译:**
John，给我们讲讲 Amplitude 的幕后故事吧。大多数人想到 Amplitude 时，首先想到的是产品分析，但现在你们开始涉足实验（Experimentation），甚至刚刚推出了 CDP（客户数据平台）。这背后的思考过程是怎样的？

---

### [00:02:23] John Cutler

**English:**
What we've always thought of Amplitude is being about supporting the full product loop, think collect data, inform bets, ship experiments, and learn. That's the heart of growth to us. So the big aha was seen how many customers were using Amplitude to analyze experiments, use segments for outreach, and send data to other destinations. Experimenting CDP came out of listening to and observing our customers.

**中文翻译:**
我们一直认为 Amplitude 的核心是支持完整的产品闭环：收集数据、为决策提供依据、发布实验并学习。对我们来说，这就是增长的核心。所以，当我们看到这么多客户使用 Amplitude 来分析实验、利用分群进行触达，并将数据发送到其他目的地时，我们有了“顿悟”。实验功能和 CDP 的推出正是源于对客户的倾听和观察。

---

### [00:02:44] Lenny

**English:**
Supporting growth and learning has always been Amplitude's core focus, right?

**中文翻译:**
支持增长和学习一直是 Amplitude 的核心关注点，对吧？

---

### [00:02:48] John Cutler

**English:**
Yeah. So Amplitude tries to meet customers where they are. We just launched Starter Templates and have a great scholarship program for startups. There's never been a more important time for growth.

**中文翻译:**
是的。Amplitude 努力在客户所在的阶段满足他们的需求。我们刚刚推出了入门模板，并为初创公司提供了一项很棒的奖学金计划。现在是增长最重要的时刻。

---

### [00:02:57] Lenny

**English:**
Absolutely agree. Thanks for joining us, John. Head to amplitude.com to get started.

**中文翻译:**
完全同意。谢谢你的加入，John。请访问 amplitude.com 开始体验。

---

### [00:03:03] Lenny

**English:**
This episode is brought to you by Athletic Greens. I've been hearing about AG1 on basically every podcast that I listened to, like Tim Ferriss and Lex Fridman. So I finally gave it a shot earlier this year, and it has quickly become a core part of my morning routine, especially on days that I need to go deep on writing or record a podcast like this. Here's three things that I love about AG1: One, with a small scoop that dissolves in water, you are absorbing 75 vitamins, minerals, probiotics, and adaptogens. I kind of like to think of it as a safety net for my nutrition in case I've missed something in my diet. Two, they treat AG1 like a software product. Apparently, they're on their 52nd iteration and they're constantly evolving it based on the latest science, research studies, and internal testing that they do. And three, it's just one easy thing that I can do every single day to take care of myself.

**中文翻译:**
本集节目由 Athletic Greens 赞助。我几乎在听的每一个播客里都能听到 AG1，比如 Tim Ferriss 和 Lex Fridman 的节目。所以今年早些时候我终于尝试了一下，它很快就成了我早晨例行活动的核心部分，尤其是在我需要深度写作或录制像这样的播客的日子里。我喜欢 AG1 的三点：第一，只需一小勺溶解在水中，你就能吸收 75 种维生素、矿物质、益生菌和适应原。我把它看作是我营养的“安全网”，以防我在饮食中遗漏了什么。第二，他们像对待软件产品一样对待 AG1。显然，他们已经迭代到了第 52 个版本，并且不断根据最新的科学研究和内部测试进行演进。第三，这是我每天都能做的、照顾好自己的一件简单小事。

---

### [00:03:58] Lenny

**English:**
Right now it's time to reclaim your health and arm your immune system with convenient daily nutrition. It's just one scoop and a cup of water every day, and that's it. There's no need for a million different pills and supplements to look out for your health. To make it easy, Athletic Greens is going to give you a free one year supply of immune supporting vitamin D and five free travel packs with your first purchase. All you have to do is visit athleticgreens.com/lenny. Again, that's athleticgreens.com/lenny. Take ownership over your health and pick up the ultimate daily nutritional insurance.

**中文翻译:**
现在是时候重获健康，用便捷的每日营养武装你的免疫系统了。每天只需一勺加一杯水，就这么简单。不需要为了健康去吃无数种不同的药丸和补充剂。为了方便起见，Athletic Greens 将在你首次购买时免费赠送一年的免疫支持维生素 D 和五份免费旅行装。你只需访问 athleticgreens.com/lenny。重复一遍，是 athleticgreens.com/lenny。掌控你的健康，获取终极每日营养保障。

---

### [00:04:33] Lenny

**English:**
Gia, welcome to the podcast.

**中文翻译:**
Gia，欢迎来到播客。

---

### [00:04:36] Georgiana Laudi

**English:**
Thanks so much for having me, Lenny.

**中文翻译:**
非常感谢邀请我，Lenny。

---

### [00:04:38] Lenny

**English:**
It's my pleasure. So we actually met over a decade ago, I think, maybe just around a decade in Montreal. I was working on my startup. You were helping companies with their websites, optimize their websites. Then you went on to lead marketing at Unbounce and a bunch of other great stuff. So just to set a little bit of foundation for listeners, can you talk about what you've done in your career in 55 seconds? That's your time box.

**中文翻译:**
我的荣幸。我们实际上是在十多年前认识的，我想大概是十年前在蒙特利尔。当时我正在做我的初创公司，而你正在帮助公司优化他们的网站。后来你去了 Unbounce 担任营销负责人，还做了很多其他了不起的事情。为了给听众打个底，你能用 55 秒介绍一下你的职业生涯吗？这是你的时间限制。

---

### [00:05:03] Georgiana Laudi

**English:**
55 seconds. Okay. So marketing for probably about 20 or so years, which sounds completely ridiculous when I say it, but I started working for my father's retail business in the early 2000s, probably 2000 actually. Worked there for a number of years, and then eventually left and started freelancing, worked at an agency. Terrible. And then actually probably around the time I met you, I had this little catalyst moment where I joined Twitter in late 2008, and I discovered the tech scene and startups. And that was, again, probably around the time that you and I met, maybe 2010 ish. And that was-

**中文翻译:**
55 秒，好的。我从事营销大概有 20 年了，说出来感觉挺不可思议的。2000 年初，大概就是 2000 年，我开始在我父亲的零售生意里工作。在那儿干了几年后，我离开并开始做自由职业，还在一家代理机构工作过，那经历挺糟糕的。后来大概就在遇到你前后，我迎来了一个小小的契机：2008 年底我加入了 Twitter，发现了科技圈和初创公司。那大概也是我们相遇的时候，可能是 2010 年左右。那是——

---

### [00:05:43] Lenny

**English:**
2011.

**中文翻译:**
2011 年。

---

### [00:05:43] Georgiana Laudi

**English:**
And then I... What's that?

**中文翻译:**
然后我……你说什么？

---

### [00:05:45] Lenny

**English:**
2011.

**中文翻译:**
2011 年。

---

### [00:05:46] Georgiana Laudi

**English:**
2011. See, there you go.

**中文翻译:**
2011 年。看吧，就是那时候。

---

### [00:05:47] Lenny

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### [00:05:48] Georgiana Laudi

**English:**
So it was right around that time, and then late 2011, I decided supporting five, six companies at a time in their marketing and stuff like that. I was starting to get burnout, I was doing a lot, and I was like, "What would it feel like to sink my teeth into one brand?" So I decided to go in-house and I moved out west, and joined the team at Unbounce. I was there for five years. And then in late 2016, early 2017, I decided it was time to move on, and so I decided to go back independent and just started working with companies and supporting them through marketing and growth and product marketing. And that's what I've been doing ever since.

**中文翻译:**
就在那个时候，2011 年底，我决定不再同时为五六家公司提供营销支持。我开始感到职业倦怠，因为要做的事情太多了。我想：“全身心投入到一个品牌中会是什么感觉？”于是我决定加入公司内部，搬到了西部，加入了 Unbounce 团队。我在那里待了五年。然后在 2016 年底、2017 年初，我决定是时候离开了，于是我重新开始独立工作，为公司提供营销、增长和产品营销方面的支持。从那以后我一直就在做这个。

---

### [00:06:27] Georgiana Laudi

**English:**
But in mid 2017, I actually paired up with Claire Suellentrop who led marketing at Calendly, and her and I have been working together since about mid 2017. That's when we launched Forget The Funnel, and we started pairing up on working with companies and sort of married her customer research background in my strategy, marketing background. And we developed this framework that we now use when we work with predominantly B2B SaaS companies, is who we work with right now.

**中文翻译:**
但在 2017 年中期，我与曾领导 Calendly 营销工作的 Claire Suellentrop 合作，我们从那时起一直共事至今。那是我们推出“Forget The Funnel”的时候，我们开始合作服务公司，将她的客户研究背景与我的战略营销背景结合起来。我们开发了一套框架，现在主要用于服务 B2B SaaS 公司，这也是我们目前的主要客户群体。

---

### [00:06:57] Lenny

**English:**
Awesome. So we're going to spend a lot of time on what you've learned working with companies through Forget The Funnel. Why did you call it Forget The funnel?

**中文翻译:**
太棒了。我们将花很多时间讨论你在“Forget The Funnel”工作中积累的经验。为什么给公司起名叫“Forget The Funnel”（忘掉漏斗）？

---

### [00:07:04] Georgiana Laudi

**English:**
Because funnels are gross. I mean, it's a really antiquated idea. It's not just funnels that we sort of take issue with, it's buyers' journeys or even... I remember actually at Startup Fest 2012, I want to say, Dave McClure was talking about pirate metrics and I was like, "Huzzah, marketing has a role post acquisition. Everybody understands now." It was a real moment for me. But the problem with funnels and pirate metrics and the favorites that I love to pick on are MQLs and SQLs is that nobody knows what those mean. It puts every customer in the same sort of buckets. It assumes that all customers and all products are the same. It puts businesses, or they, I should say, puts businesses at the center of the business versus putting customers at the center. It's about the values of the business, not the value to the customer that's being measured.

**中文翻译:**
因为漏斗模型很糟糕。我的意思是，这是一个非常陈旧的想法。我们不只是对漏斗有意见，对所谓的“买家旅程”甚至……我记得在 2012 年的 Startup Fest 上，Dave McClure 在谈论海盗指标（AARRR），当时我觉得：“太好了，大家终于明白营销在获客后也有作用了。”那对我来说是个重要时刻。但漏斗和海盗指标的问题——以及我最爱吐槽的 MQL 和 SQL——在于没人知道它们到底代表什么。它把每个客户都归入同样的类别，假设所有客户和产品都一样。它把企业置于中心，而不是客户。衡量的是企业的价值，而不是客户获得的价值。

---

### [00:08:01] Georgiana Laudi

**English:**
Also, it just kind of feels gross for people, this idea of pushing people through a funnel. And then probably a particularly relevant for SaaS companies is that recurring revenue businesses, you cannot think about marketing and growth and the business overall as ending at acquisition. Otherwise, you're not in business anymore. The vast, vast majority of these models don't take post-acquisition retention, expansion, all of that into account. They also leave the problem stage out. So the world that customers are living in prior to discovering you, which is a really critical, that context is unbelievably valuable, especially for marketing. So to delete that out of the equation is a big problem. So yeah, in a nutshell, funnels are bad.

**中文翻译:**
此外，这种“把人推过漏斗”的想法让人感觉很不舒服。对于 SaaS 公司来说，经常性收入业务意味着你不能认为营销和增长在获客那一刻就结束了，否则你就出局了。绝大多数模型都不考虑获客后的留存和扩张。它们还忽略了“问题阶段”，即客户在发现你之前所处的世界。这个背景信息非常有价值，尤其是对营销而言。把这一环从等式中删掉是个大问题。所以，简而言之，漏斗模型很糟糕。

---

### [00:08:52] Lenny

**English:**
Okay. So I'm excited to dig into a lot of stuff you've learned, but I have a couple other things I just wanted to talk about to set the foundation.

**中文翻译:**
好的。我很期待深入探讨你学到的东西，但在那之前，我想先聊几件事来打好基础。

---

### [00:08:58] Georgiana Laudi

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### [00:08:58] Lenny

**English:**
One is, can you talk about some of the impact that you've seen working with companies through the process that you've come up with? What kind of impact have you seen? What kind of numbers have you seen?

**中文翻译:**
第一点，你能谈谈通过你总结的这套流程，你所服务的公司取得了哪些成效吗？你看到了什么样的影响？具体的数据如何？

---

### [00:09:07] Georgiana Laudi

**English:**
I would say, far in a way the biggest, most immediate impact of the type of work that we do is realigning with that ideal customer. Generally, the lowest hanging fruit outcome is realigning around better positioning and messaging. And identifying more resonant positioning and messaging that speaks to that context that I was talking about before, before people discover that you even exist, have that moment where they're like, "Oh my god, this has to change. This sucks," ties that in, ties in what they care about and what is valuable about your product and then also that desired outcome. I mean, for those in the know, jobs to be done is a big sort of influence here, but if you can identify that type of information about your customers and get to know them at that level, then you are in a way better position to be able to not only position your product but also use much more powerful messaging.

**中文翻译:**
我会说，我们这类工作带来的最大、最直接的影响是重新对齐“理想客户”。通常，最容易实现的成果是围绕更好的定位（Positioning）和话术（Messaging）进行对齐。我们会识别出更能引起共鸣的定位和话术，去触达我之前提到的那个背景——在人们发现你存在之前，在他们觉得“天哪，这必须改变，这太糟了”的那个时刻。我们将客户关心的东西、你产品的价值以及他们渴望的结果联系起来。对于了解的人来说，“待办任务”（Jobs to be Done, JTBD）理论在这里有很大影响。如果你能识别出客户的这类信息并深入了解他们，你就能更好地定位产品，并使用更具威力的营销话术。

---

### [00:10:06] Georgiana Laudi

**English:**
So typically, what we do is, we'll identify those gaps of almost, I mean I shouldn't even say nine times out of 10, 99 times out of a hundred, a company's website is not doing as much as it could do. It's not being as effective from a messaging and positioning standpoint as it could. So websites tend to get update. We will do a lot of overhauls on messaging on a website and improve performance there. One of my favorite examples of that is a social media tool that we worked with where we did really very simple research for them, honestly, identified two different jobs to be done, zeroed in on one of them, and then updated the messaging on the website.

**中文翻译:**
通常我们会识别出这些差距。我甚至不想说十有八九，应该是 99% 的公司网站都没有发挥出应有的作用。从话术和定位的角度来看，它们本可以更有效。所以网站往往需要更新。我们会对网站话术进行大量翻新，从而提升表现。我最喜欢的例子之一是一个社交媒体工具，我们为他们做了非常简单的研究，识别出两个不同的“待办任务”，锁定其中一个，然后更新了网站话术。

---

### [00:10:46] Georgiana Laudi

**English:**
We shortened the trial from 30 days to seven. The conversion on the website went up with this new messaging by 89%. But the thing that I love the most about that particular story is that we didn't even touch anything after the signup experience. We hadn't even gotten there and the trial-to-paid conversion rate increased 40%, and we didn't touch it. It was just because a more qualified, better fit customer was coming through the door. So there was more of them and there were better qualified. So that's a really specific example that is very typical of this type of work.

**中文翻译:**
我们将试用期从 30 天缩短到 7 天。凭借新的话术，网站转化率提高了 89%。但我最喜欢这个故事的一点是，我们甚至没有触碰注册后的任何环节。我们还没优化到那一步，从试用到付费的转化率就提高了 40%，而我们根本没动它。这仅仅是因为进门的客户更精准、更匹配了。所以客户数量更多了，质量也更高了。这是一个非常典型且具体的例子。

---

### [00:11:19] Georgiana Laudi

**English:**
There's other examples, though, of product adoption and using that messaging and positioning past the website, even in the product onboarding itself, email and app, whatever, and just making sure that they're getting to and have the calms to get to the parts of the product that they care about the most, which can increase trial-to-paid or product activation. With Autobooks, the product usage of the North Star product usage jumped by 300% or something within quite a short period of time after rolling out email onboarding to support that product experience. I know SparkToro as well, which I think we might end up talking about again when we talk about the process, they doubled their trial-to-paid conversion rate when we worked with them because of post acquisition optimization to their messaging.

**中文翻译:**
还有其他关于产品采用（Product Adoption）的例子，将这些话术和定位应用到网站之外，甚至应用到产品引导（Onboarding）、邮件和应用内。确保客户能够顺畅地接触到他们最关心的产品部分，这可以提高试用到付费的转化率或产品激活率。在 Autobooks 的案例中，在推出邮件引导以支持产品体验后，北极星指标（North Star）的产品使用量在很短时间内跳升了 300% 左右。还有 SparkToro，我想我们在讨论流程时还会提到它，由于我们对获客后的营销话术进行了优化，他们的试用到付费转化率翻了一番。

---

### [00:12:01] Lenny

**English:**
I imagine people are listening to this and they're like, "This is what I'm waiting for, some kind of huge win, some huge conversion, a success." I'm curious, how often do you find companies have something like this, like a latent opportunity to double, triple conversion? Everyone's hoping a conversion like this.

**中文翻译:**
我想听众听到这里肯定在想：“这就是我想要的，某种巨大的胜利，巨大的转化提升。”我很好奇，你发现公司拥有这种“让转化率翻倍、翻三倍”的潜在机会的频率有多高？每个人都渴望这样的转化提升。

---

### [00:12:18] Georgiana Laudi

**English:**
Oh, boy.

**中文翻译:**
噢，天哪。

---

### [00:12:19] Lenny

**English:**
Yeah. What's the general hit rate?

**中文翻译:**
是的，普遍的“命中率”是多少？

---

### [00:12:22] Georgiana Laudi

**English:**
So many. I mean I would say, pretty well every company we've ever worked with has... Not pretty well. Every company we've ever worked with has learned something new about their customers that they can apply at some juncture of their customer's experience, whether or not it is in campaigns to reach the right people out in the world, whether or not it's doing a better job with their messaging and positioning on their website, or their go-to market or acquisition strategy on their website using a sandbox account or getting a faux freemium account to let people kick the tires of their product prior to getting on a sales call. That's something that could potentially happen.

**中文翻译:**
非常多。我的意思是，几乎我们合作过的每一家公司都……不只是几乎，是每一家。每一家公司都学到了关于客户的新知识，并能将其应用到客户体验的某个环节。无论是在触达目标人群的营销活动中，还是在网站的话术和定位上，或者是通过沙盒账号、模拟免费版让用户在销售电话前先“试驾”产品的获客策略。这些都是潜在的机会。

---

### [00:13:06] Georgiana Laudi

**English:**
The post-acquisition experience I'm talking about, it is so often an afterthought somehow where that additional of layer... I think part of the reason why it's an afterthought is because product onboarding in particular, and you've probably heard this too, it tends to be kind of like no man's land. Who owns that? Is it marketing? If it's freemium, in my opinion it should be marketing because freemium is a marketing tool, but not everybody subscribes to that. Not every company would necessarily agree that that's the case. A lot of companies might say, "No, it's product." So we end up seeing a messy middle there because there's no natural handoff. So pretty well, every company that we've worked with has had an opportunity to improve, especially product onboarding and product activation.

**中文翻译:**
我提到的获客后体验，往往被当作一种“事后才想到的东西”。我认为部分原因是产品引导（Onboarding）往往处于“无人区”。谁该负责它？营销部门吗？如果是免费增值模式（Freemium），我认为应该是营销，因为免费增值是一种营销工具，但并非人人都这么想。很多公司会说：“不，这是产品部门的事。”于是我们看到了一个混乱的中间地带，因为没有自然的交接。所以，几乎我们合作过的每家公司都有改进的机会，特别是在产品引导和激活方面。

---

### [00:13:53] Lenny

**English:**
Absolutely benefit from what we're about to talk about.

**中文翻译:**
绝对能从我们接下来的谈话中获益。

---

### [00:13:56] Georgiana Laudi

**English:**
A hundred percent.

**中文翻译:**
百分之百。

---

### [00:13:56] Lenny

**English:**
Amazing. Great.

**中文翻译:**
太棒了。

---

### [00:13:56] Georgiana Laudi

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:14:00] Lenny

**English:**
All right. We've got wrap detention as a way to maybe transition into your process. So you're visiting a site once, and I invited you to the Airbnb office we were having a happy hour, and I gave you a tour. You told me later that something you saw while you're walking around the office transformed the way you think about growth and inform the way you think about approaching this problem. Can you talk about that?

**中文翻译:**
好的。我们可以通过一个故事过渡到你的流程。有一次你来访，我邀请你参加 Airbnb 办公室的欢乐时光，并带你参观了一下。你后来告诉我，你在办公室里看到的一些东西改变了你对增长的看法，并影响了你处理这个问题的方式。你能聊聊那个吗？

---

### [00:14:24] Georgiana Laudi

**English:**
Yes. This is one of my favorite... It was 2013, so you and I might have met in 2011, and then a couple years later I was in town for a conference and we toured the office, HQ and everything. Of course, it was all stars in my eyes because what a beautiful office too. So it was quite like, I would've remembered it regardless. But we went downstairs, very different from the very polished upstairs. We went downstairs to where your working area was, where the product team was, and there were sheets of paper taped to the wall, a bunch in a row. And it would've been easy to miss because it's kind of chaotic down there, but it was the customer journey of an Airbnb customer through two posts.

**中文翻译:**
是的。这是我最喜欢的……那是 2013 年，我们可能是在 2011 年认识的，几年后我因为参加会议来到城里，我们参观了总部办公室。当然，当时我满眼都是小星星，因为办公室太漂亮了。但我们去了楼下，那里和楼上精致的装修完全不同。我们去了你们的工作区，也就是产品团队所在地，墙上贴着一排排纸。那里有点乱，很容易错过，但那是 Airbnb 客户的旅程图。

---

### [00:15:12] Georgiana Laudi

**English:**
What struck me, I was like, "Oh that's interesting. I'm in the middle of building one out for us." Leading marketing at Unbounce at the time. And I was interestingly with the customer success, he was also with me. So Ryan Engley was there with me, and it was the perfect sort of that him and I saw it together. It was a customer journey that was focused on the customer. So versus that pirate metrics problem or that the typical buyer's journey problem that I was talking about earlier, it was the complete reverse of that. It was illustrated. The emotional journey was part of it. The role that Airbnb played as a direct touchpoint and also indirect, what was going on in the person's life that had nothing to do outside of Airbnb, which I thought was really interesting.

**中文翻译:**
让我震惊的是，我当时想：“噢，真有意思，我也正在为我们公司做一个。”当时我还在 Unbounce 领导营销工作。有趣的是，当时客户成功负责人 Ryan Engley 也在我身边，我们一起看到它简直太完美了。那是一个以客户为中心的客户旅程。与我之前提到的海盗指标或典型的买家旅程问题完全相反。它是图解式的，包含了情感旅程。Airbnb 作为直接触点和间接触点的角色，以及用户生活中与 Airbnb 无关的部分都被记录了下来，我觉得这非常有趣。

---

### [00:16:01] Georgiana Laudi

**English:**
It was like, the beautiful little milestones really encapsulated in a sort of snapshot way, such that anybody walking by it or anybody being reminded that it existed could understand in a glance what the goal was at each of those milestones. I was like, "Well, shit, this is completely through the lens of the customer versus the business and the grossness of the funnel." It's just so far removed from that experience that I was like, "Ryan, look at this. We need this." He was like, "Oh yeah, this is good." I took a picture. Can't find it for the life of me.

**中文翻译:**
那些精美的小里程碑以快照的方式呈现，任何走过的人或被提醒的人都能一眼看出每个里程碑的目标。我当时想：“天哪，这完全是从客户的角度出发，而不是从业务或糟糕的漏斗角度。”它与那种传统的体验完全不同，我对 Ryan 说：“快看这个，我们也需要这个。”他说：“噢是的，这太棒了。”我拍了张照片，但现在怎么也找不到了。

---

### [00:16:39] Georgiana Laudi

**English:**
But we returned back to the office the following week, and co-founder and head of product, head of CS, so Ryan, Carter Gilchrist, who's head of product and co-founder, Ryan, and I, head of marketing, the three of us locked ourselves in the room for two days and made our own. It was a circle. I mean looking back, it's hysterical, but it was sort of democratized to the rest of the team in a way because it had that buy-in. Everybody was like, "Oh yeah. Okay, this makes sense and I understand." It made everybody feel a lot better about what they were doing because it was about value, delivering value at each of the points.

**中文翻译:**
下周回到办公室后，联合创始人兼产品负责人 Carter Gilchrist、客户成功负责人 Ryan 和我（营销负责人），我们三个人把自己关在房间里两天，做出了我们自己的版本。那是一个圆圈。回想起来挺滑稽的，但它在某种程度上向团队其他成员普及了这种理念，因为大家都有参与感。每个人都觉得：“噢，是的，这很有道理，我明白了。”这让每个人对自己的工作感觉好多了，因为核心变成了价值——在每个点上交付价值。

---

### [00:17:13] Georgiana Laudi

**English:**
So that grossness sort of goes away and we're like, "Oh cool." I don't want to be too kumbaya about it, but it was a bit of a moment. And also, it made communicating with especially the product team and the engineering team a lot easier for me. So we were using a shared language. The rest of the company who aren't necessarily customer facing really understood, I think, at a different level what we were all doing together in KPIs, yada yada yada. So it was amazing. Honestly, I mean I can't credit only that obviously to our growth, but it was a pretty impressive couple years that followed that. I think the alignment that that brought us was huge. Yeah. Anyway, that's the story. Sorry, that wasn't super short, but it was big.

**中文翻译:**
那种（漏斗带来的）不适感消失了，我们觉得“这很酷”。我不想把它说得太煽情，但那确实是一个转折点。而且，这让我与产品团队和工程团队的沟通变得容易得多。我们开始使用共同的语言。公司里那些不直接面对客户的人，也能在不同层面上理解我们在 KPI 等方面共同努力的目标。这太棒了。老实说，我不能把增长完全归功于此，但随后的几年确实令人印象深刻。我认为这种“对齐”带来的作用是巨大的。总之，这就是那个故事。抱歉说得有点长，但它真的很重要。

---

### [00:18:02] Lenny

**English:**
That's great.

**中文翻译:**
太棒了。

---

### [00:18:03] Georgiana Laudi

**English:**
It was a big thing. Yeah.

**中文翻译:**
确实是件大事。

---

### [00:18:05] Lenny

**English:**
We're going to link pictures of this on the show notes. Internally, it was called Project Snow White because it was inspired by-

**中文翻译:**
我们会在节目笔记中附上这些照片的链接。在公司内部，这被称为“白雪公主项目”（Project Snow White），因为它的灵感来自——

---

### [00:18:13] Georgiana Laudi

**English:**
Oh yeah, that's right.

**中文翻译:**
噢对，没错。

---

### [00:18:13] Lenny

**English:**
Yeah. It was inspired by Brian reading the biography of Walt Disney, and they needed to create the storyboard basically to create Snow White because it was so complicated to make that movie. It might have been the first animated film with storyboards.

**中文翻译:**
是的。灵感来自 Brian 阅读华特·迪士尼的传记。当时他们需要制作脚本（Storyboard）来创作《白雪公主》，因为制作那部电影太复杂了。那可能是第一部使用脚本的动画电影。

---

### [00:18:24] Georgiana Laudi

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:18:25] Lenny

**English:**
So it was basically a storyboard of a trip on Airbnb of a host and a guest.

**中文翻译:**
所以这基本上是关于房东和房客在 Airbnb 上的一次旅行的脚本。

---

### [00:18:30] Georgiana Laudi

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:18:30] Lenny

**English:**
And in detail, I forget if I told you this, but Airbnb hired a full-time storyboard artist from Pixar to draw these key frames.

**中文翻译:**
而且细节上，我忘了有没有告诉你，Airbnb 专门从皮克斯（Pixar）聘请了一位全职脚本艺术家来绘制这些关键帧。

---

### [00:18:38] Georgiana Laudi

**English:**
I think I did know that. I was very grateful to have seen it. I didn't realize at the time, but it changed the way, like you said at the beginning, it changed the way that I thought about marketing because it really made it obvious to not only me, of course, and to everybody, that customer experience layer, that marketers are so good at, has such an incredibly important role in driving revenue. Not just in building awareness, but in playing a major role in helping customers get value and catching them when they fall off and all that kind of stuff. So it changed a lot for us.

**中文翻译:**
我想我知道这件事。我很庆幸能看到它。当时我没意识到，但正如你开头所说，它改变了我对营销的看法。因为它让包括我在内的所有人明白，营销人员擅长的“客户体验层”在驱动收入方面扮演着极其重要的角色。不仅是建立知名度，在帮助客户获得价值、在他们流失时挽留他们等方面也起着重大作用。所以它改变了我们很多。

---

### [00:19:19] Lenny

**English:**
And it informed the way that you approach your consultancy with Forget The funnel. So as a transition to talk about that, the way I'm thinking we approach this is, imagine a customer, what is the process you go through? What are the steps? How do you go about helping a company figure out where they should invest, what they're doing right and wrong? I should also mention you're writing a book about this that's going to explain this whole process, that's coming out later in the year.

**中文翻译:**
这也影响了你经营“Forget The Funnel”咨询公司的方式。为了过渡到这个话题，我想我们可以这样切入：想象一个客户，你会经历怎样的流程？有哪些步骤？你如何帮助一家公司弄清楚他们应该在哪里投资，哪些做得对，哪些做得错？我顺便提一下，你正在写一本关于这个流程的书，将在今年晚些时候出版。

---

### [00:19:40] Georgiana Laudi

**English:**
Right. Yeah.

**中文翻译:**
对，没错。

---

### [00:19:41] Lenny

**English:**
So we'll talk about that at the end as well. I'll turn over to you.

**中文翻译:**
我们最后也会聊聊那本书。现在交给你了。

---

### [00:19:46] Georgiana Laudi

**English:**
Cool. I mean if I go down a rabbit hole and you want to pull me out and have me unpack something, let me know. Well, the process is pretty straightforward. At the highest level, the idea is, understand your best customers, map their experience, like we were just talking about, map their experience through the lens of delivering value to them, make it measurable, and then evaluate what you're doing today that is out of alignment with that. Pretty straightforward. I mean that doesn't sound too hard of a job, of course. But research is an really important part of that. So the story that I was going to use to illustrate this is, there's a company that we work with from time to time. We worked with them at least twice, arguably three times.

**中文翻译:**
酷。如果我钻牛角尖了，你想拉我出来或者让我展开讲讲，随时告诉我。流程其实很直接。在最高层面上，核心理念是：了解你最好的客户，绘制他们的体验图（就像我们刚才聊的那样），从交付价值的角度去绘制，使其可衡量，然后评估你现在的做法中哪些与此不符。非常直接。当然，听起来不难，但研究是其中非常重要的一部分。我想用一个例子来说明：有一家公司我们不时合作，至少合作过两次，甚至可以说是三次。

---

### [00:20:34] Georgiana Laudi

**English:**
So Rand Fishkin who was the founder of Moz, he's got a new product. It's an audience research tool called SparkToro. And when they first launched, actually even pre-launched, Rand and Casey came to Claire and I to help with their positioning and messaging as they were going forward to launch. I mean Rand and Casey, they're both very, very thoughtful and they take their time with stuff. So they were just looking for that extra layer of like, "Is this good enough to launch kind of thing?" So we help them with their positioning and messaging. And off they went.

**中文翻译:**
Rand Fishkin（Moz 的创始人）有一个新产品，是一个叫 SparkToro 的受众研究工具。在他们最初发布甚至预发布阶段，Rand 和 Casey 就找到 Claire 和我，帮助他们在发布前进行定位和话术设计。Rand 和 Casey 都非常深思熟虑，做事很稳。他们当时只是想确认一下：“这东西够好到可以发布了吗？”于是我们帮他们搞定了定位和话术，然后他们就发布了。

---

### [00:21:08] Georgiana Laudi

**English:**
About a year later, they came back because though they were doing a decent job generating traffic and interest in SparkToro, I mean Rand is no small fish so he's got a good audience built in, which is fantastic, but those that were getting to the website... Those that were signing up for the product, those weren't issues. But the people that were signing up for their free product weren't converting to paid in the way that they believed they could. So we decided to work with them and basically go to the source and find out, from SparkToro's best customers, what can we learn from them that we can then reflect back in the product experience and the customer experience for them?

**中文翻译:**
大约一年后，他们回来了。虽然他们在为 SparkToro 引入流量和关注方面做得不错（Rand 名气很大，自带受众，这很棒），网站访问和产品注册也不是问题，但注册免费版的人并没有像他们预期的那样转化为付费用户。于是我们决定与他们合作，追根溯源，从 SparkToro 最好的客户那里了解情况：我们能从这些客户身上学到什么，并将其反馈到产品体验和客户体验中？

---

### [00:21:54] Georgiana Laudi

**English:**
I mentioned it before, but we are heavy believers in the jobs-to-be-done theory, which is basically this idea that people don't buy your product, they buy the better version of themselves, yada yada. I don't need to explain any of that. But we use that to guide our research. And with SparkToro, we were in a position, and the purists will hate me saying this, but we were in a position to be able to run surveys. So yes, interviews are ideal always, but we did think that we could learn a ton from surveys to then, if needed, double down with interviews. We didn't end up actually needing to run the interviews because the surface that we ran were pretty decisive and clear in terms of what we learned. So what we did was, we identified SparkToro's best customers. Now, what I mean by best customers is those that get a ton of value from your product as of exist today, pay obviously. They're happy. They're low maintenance. And very importantly, they signed up for your product recently enough that they remember what life was like before.

**中文翻译:**
我之前提到过，我们是“待办任务”（JTBD）理论的坚定信奉者。核心理念是：人们买的不是你的产品，而是更好的自己，等等。我不需要解释太多。我们用这个理论指导研究。在 SparkToro 的案例中，虽然原教旨主义者可能不爱听，但我们当时决定先做问卷调查。虽然访谈总是最理想的，但我们认为可以先从问卷中学到很多，如果需要再进行访谈。结果我们根本不需要访谈，因为问卷结果非常明确。我们识别出了 SparkToro 最好的客户。我所说的“最好客户”是指：目前能从产品中获得巨大价值、付费、满意、维护成本低，且非常重要的一点是，他们注册的时间足够近，还记得使用产品前的生活是什么样的。

---

### [00:22:57] Georgiana Laudi

**English:**
So generally, we say that's in the three to six-month range. Because if you go to somebody that's been your customer for two years, they're just going to fill answers with what they think might have been going on in their life. But if you ask customers who remember what life was like before, you're going to get a lot more interesting responses, a lot more accurate depiction of what was going on. So that's the criteria we went forward. Surveyed their customers. We're trying to uncover from them what was going on in their life when they were seeking out a solution, what happened, what was that trigger moment when they did start seeking a solution, what did they go to, who did they talk with, what were their influences? Which PS, that's what SparkToro does, it helps you identify those.

**中文翻译:**
通常我们说这个时间范围是三到六个月。因为如果你去问一个已经用了两年的老客户，他们只会凭想象填答案。但如果你问那些还记得以前生活的人，你会得到更有趣、更准确的描述。这就是我们的标准。我们调查了他们的客户，试图挖掘：当他们寻找解决方案时，生活中发生了什么？触发点是什么？他们去了哪里？和谁聊过？受谁影响？（顺便说一下，这正是 SparkToro 的功能：帮你识别这些影响因素）。

---

### [00:23:42] Georgiana Laudi

**English:**
But also, what were they looking for in a solution? What were the must-haves for them versus what were some of the anxieties that they had, some deal breakers, things like that? So basically unpacking what is it that was critical for them in their solution. And then of course, what is it they're able to do now that they weren't able to do before. So that desired outcome. So out of that, we identified a couple of different options, a couple of different jobs, customer jobs, and we have to prioritize one, of course, because if you start right off the bat with like, "Okay, we're going to solve for all of these different customers jobs," then you end up not being as resonant. You can't be as effective. So we focused in on one.

**中文翻译:**
还有，他们在解决方案中寻找什么？哪些是必须具备的？哪些是让他们感到焦虑的？哪些是“一票否决”的因素？基本上就是拆解对他们来说至关重要的东西。当然，还有他们现在能做到、而以前做不到的事情，也就是“渴望的结果”。基于此，我们识别出了几个不同的“客户任务”（Customer Jobs），我们必须优先考虑其中一个。因为如果你一开始就想解决所有不同的任务，你的话术就无法引起共鸣，效果也不会好。所以我们专注于其中一个。

---

### [00:24:23] Georgiana Laudi

**English:**
And the way that you make a decision on which one you focus on is similar to best customers. So high willingness to pay. There's no question whether or not they would pay for a product like yours. The handholding that they would need would be minor or less so. And I say that understanding full well the difference between product-led and sales-led. I'm not saying that sales-led is not good, but sometimes there's a decision to be made. If you're not set up today to support a sales-led or high touch, then you may want to opt for the more product-led approach. And the reverse is also true if you've got a robust sales team, well then, you might actually be better off leveraging sales more in that scenario and might want to attend towards that. But there's that criteria that you would think through.

**中文翻译:**
决定专注于哪一个的标准与选择“最好客户”类似。首先是高付费意愿，毫无疑问他们愿意为这类产品买单。其次是他们需要的“手把手指导”较少。我说这话时充分理解产品驱动（Product-led）和销售驱动（Sales-led）的区别。我不是说销售驱动不好，但有时需要做抉择。如果你目前没有能力支持高接触的销售模式，你可能更倾向于产品驱动。反之亦然，如果你有强大的销售团队，那么利用销售可能效果更好。这些都是需要考虑的标准。

---

### [00:25:10] Georgiana Laudi

**English:**
So willingness to pay, it's really obvious. Maybe the most important one is that they have an urgent problem. So the whole pain killer versus vitamin thing, you always want to be selling a pain killer. So who has an urgent problem that needs solving, not something that they might have a problem with six months down the line? Who has a high retention or even expansion potential is also really advantageous for very obvious reasons. So customers who would have a long-term need for this type of product and even potentially have that need expand or change over time and evolve in ways that you envision the product can help them.

**中文翻译:**
付费意愿很显而易见。但也许最重要的一点是：他们是否有紧迫的问题。这就是所谓的“止痛药 vs 维生素”理论，你永远想卖止痛药。谁有急需解决的问题，而不是六个月后才可能遇到的问题？此外，谁具有高留存甚至扩张潜力，这显然也非常有利。也就是那些对这类产品有长期需求，且需求可能随时间扩大或演变的客户。

---

### [00:25:47] Georgiana Laudi

**English:**
And then there's other criteria too. So sometimes you might want to prioritize one customer job over another, if those customers congregate in a way that make them really easy to market to. That's an advantage. Or another advantage, and this was the case for SparkToro, is you have an unfair advantage with this market in some way. So there were two different customer jobs that were coming out of SparkToro. One was more focused on service providers and marketing and the other one was more focused on data. And those data purists and those that really wanted verifiable data, well, SparkToro has an advantage on the marketer side more so than on the data analyst side. So that was another thing too. So with that, we made the call to focus on one of those customer jobs.

**中文翻译:**
还有其他标准。比如，如果某一类客户聚集在一起，非常容易进行营销，你可能会优先考虑他们。或者像 SparkToro 的情况，你在某个市场拥有某种“不公平竞争优势”。SparkToro 当时有两个不同的客户任务：一个侧重于服务提供商和营销人员，另一个侧重于数据。对于那些追求极致可验证数据的数据专家来说，SparkToro 在营销人员端的优势其实更明显。所以我们决定专注于其中一个客户任务。

---

### [00:26:35] Lenny

**English:**
Can I ask a question here?

**中文翻译:**
我能在这里问个问题吗？

---

### [00:26:37] Georgiana Laudi

**English:**
Yeah, go.

**中文翻译:**
当然，请讲。

---

### [00:26:37] Georgiana Laudi

**English:**
They're sort of one in the same. So because we learned from SparkToro's ideal customers, we already know that they're a fit for the product. They're happy, happily paying, prime them out of their golden hands customers. They're the customers that we want more of. So we've already validated that there's a demand from that customer base. Now, what I'm describing about choosing between two different customer jobs is really just, of those ideal customers, which customer job do you want to lean into? It's not that you wouldn't necessarily still be able to solve for that other customer job, it's just not the one that you would lead with. And I always cautious around this too because sometimes with founders, what'll happen is, there's a level set that just because we were prioritizing one customer job in the short term, doesn't mean you can't serve that other customer job down the line.

**中文翻译:**
这两者其实是一回事。因为我们是从 SparkToro 的理想客户那里学习的，我们已经知道他们适合这个产品。他们很满意，乐于付费，是那种我们想要的“黄金客户”。所以我们已经验证了这部分客户群的需求。我现在说的在两个不同的“客户任务”中做选择，其实是指：在这些理想客户中，你更想侧重于哪种任务？这并不意味着你不能解决另一种任务，只是它不会作为你的主打。我也总是提醒创始人：短期内优先考虑一个任务，并不代表以后不能服务另一个。

---

### [00:27:57] Georgiana Laudi

**English:**
A classic example of that is products that serve both brands and agencies for example. So the customer job for brands will be slightly different than agencies. And if you've got an advantage with one, you would just start with one and then you would go back after it. That's a bit of a level up after the fact. It's not part of the core processes, it's what you would do after. But it doesn't mean you can't solve for the other customer jobs, it just means put one foot in front of the other, do a really good job of one thing first, and then we'll add that on later. I don't know if that a hundred percent answered your question though.

**中文翻译:**
一个经典的例子是同时服务于“品牌方”和“代理商”的产品。品牌方的任务与代理商略有不同。如果你在其中一方更有优势，你就先从那一方开始，然后再回头做另一方。这属于后期的进阶操作，不是核心流程的一部分。但这并不意味着你不能解决其他任务，只是要一步一个脚印，先做好一件事，然后再添加其他内容。我不确定这是否完全回答了你的问题。

---

### [00:28:32] Lenny

**English:**
Yeah. Yeah.

**中文翻译:**
是的，回答了。

---

### [00:28:33] Georgiana Laudi

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:28:34] Lenny

**English:**
The reason that you start here is... Basically what you're trying to do is help SparkToro, in this example, grow faster.

**中文翻译:**
你从这里开始的原因是……基本上你是想在这个例子中帮助 SparkToro 更快地增长。

---

### [00:28:40] Georgiana Laudi

**English:**
I mean we're trying to help them figure out why they're free-to-paid conversion rate was lower than what they wanted. Right? That was the challenge they came to us with. Our traffic numbers are good. Even our signups on our website, our positioning and messaging on our website is clearly doing a good job. But once people get into the product, there's not enough of them getting to value quickly enough. I mean they still had healthy customer base, but they knew that that number could be increased. So we knew what we were solving for.

**中文翻译:**
我的意思是，我们是在帮他们弄清楚为什么“免费转付费”的转化率低于预期。对吧？这是他们找我们时的挑战。流量数据很好，网站注册量也不错，说明网站的定位和话术做得很好。但一旦人们进入产品，能快速获得价值的人不够多。虽然他们仍有健康的客户群，但他们知道这个数字还可以提高。所以我们知道我们要解决的问题是什么。

---

### [00:29:11] Lenny

**English:**
Got it. Okay. That helps.

**中文翻译:**
明白了，这很有帮助。

---

### [00:29:13] Georgiana Laudi

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:29:14] Lenny

**English:**
So step one here is figure out who do you want to focus on, not just... Because a lot of people would go at this problem like, "Okay, conversion is whatever, 10%, how do we increase? Let's look at this data. Let's look at it. They're bouncing. Let's look at why people are confused." And your approach is, "No, let's focus on the people we really want to get into this product and focus on making them convert, and not focus as much on the general case of conversion."

**中文翻译:**
所以第一步是弄清楚你想关注谁，而不仅仅是……因为很多人处理这个问题的方式是：“好吧，转化率是 10%，我们怎么提高？看数据，看跳出率，看人们为什么困惑。”而你的方法是：“不，让我们专注于那些我们真正想吸引进产品的人，专注于让他们转化，而不是过多关注普遍意义上的转化率。”

---

### [00:29:39] Georgiana Laudi

**English:**
Right. We would get to that though. That's a really important part of the process, but it comes after figuring out who you're even solving for. But it's definitely important to look at those numbers. I mean, I'm not saying don't look at the data. Obviously you have to. They wouldn't have identified a problem had they not been looking at the data. So the challenge that happened so, so often, and I mean this happens with a lot of teams, particularly marketers fall victim to this tactical way of approaching things and piecemealing things, piecemealing campaigns or programs to prove that we're doing something and we're driving up numbers, and they don't take big enough sort of swings. So this is like, zoom out for a second, figure out who is it that you even want coming through the front door. I mean, the social media platform tool that I mentioned, the trial-to-pay conversion rate bumped up 40% because a higher qualified person comes through the front door. So it matters.

**中文翻译:**
没错。我们最终会回到数据上，那是流程中非常重要的一部分，但它排在“弄清楚你在为谁解决问题”之后。看数据当然重要，我不是说不看数据，你必须看。如果不看数据，他们根本发现不了问题。但常见的问题是——很多团队，尤其是营销人员，容易陷入这种战术性的思维，零敲碎打地做活动或项目，只为了证明自己在做事、在拉升数据，而没有进行大局观的思考。所以这就像是先“拉远镜头”，弄清楚你到底想让谁进门。我提到的那个社交媒体工具，试用转付费率提升了 40%，仅仅是因为进门的人更精准了。所以这非常重要。

---

### [00:30:40] Georgiana Laudi

**English:**
So if you can zoom out and keep in your mind's eye that ideal customer job, that thing that you're solving for. We're not at personas. We don't care about personas at all. They're important when you start talking about advertising and targeting and that demographic data that you have to know when you're doing advertising and things like that. That is not what I'm describing here at all. I find that jobs be done too helps tie and bond marketing and product and customer success together a lot more because all three of those teams, or arguably four with sales, should all be focused on this theme customer that's not revolutionary. So this is just a sort of helpful way to do that.

**中文翻译:**
所以，如果你能拉远视角，心中时刻记着那个“理想客户任务”，也就是你要解决的问题。我们现在谈的不是“用户画像”（Personas），我们根本不在乎画像。画像在做广告投放、目标定位和人口统计数据分析时很重要，但我这里说的完全不是那一套。我发现“待办任务”（JTBD）能更好地将营销、产品和客户成功团队联系在一起，因为这三个团队（如果算上销售就是四个）都应该关注同一个客户主题。这并不算革命性的观点，但这确实是一种非常有效的方法。

---

### [00:31:24] Georgiana Laudi

**English:**
Product teams know and subscribe for the most part to the jobs-to-be-done theory. So marketers should follow suit, and there's a lot to be gained anyway on the marketing side. So anyway, the short of it basically is that because we knew we were focused on increasing that free-to-pay conversion rate, the next step after the job is the mapping. So it's identifying, okay, for this ideal customer, what are those key milestones in their relationship with our product? What are those big of leaps of faith is how I describe it. I mean I don't need to explain. The Airbnb customer journey tells that story. Where's a value moment in this relationship? Where are they reaching value?

**中文翻译:**
产品团队大多了解并认同 JTBD 理论。营销人员也应该跟进，营销端能从中获益良多。总之，简而言之，因为我们知道目标是提高免费转付费转化率，确定了“任务”后的下一步就是“绘图”（Mapping）。也就是识别出：对于这个理想客户，他们与产品关系的各个关键里程碑是什么？我称之为“信仰的飞跃”。我不需要多解释，Airbnb 的客户旅程已经说明了这一点。这段关系中的“价值时刻”在哪里？他们在哪里获得了价值？

---

### [00:32:06] Lenny

**English:**
Make some examples of that for folks that are trying to do this for themselves potentially. And then also, how many of these moments would you suggest people have?

**中文翻译:**
给那些想尝试自己动手的人举几个例子吧。另外，你建议人们设定多少个这样的时刻？

---

### [00:32:13] Georgiana Laudi

**English:**
Yeah. So it completely depends on the product and the customer for that matter. I shouldn't leave that part over it. Obviously that's important. In general though, what we would do is, we'd break it down into a struggle phase and evaluation phase and a growth phase. Struggle phase is, they're experiencing the problem, life sucks, they're using the old way, something's got to happen, they've got to solve this thing. In general, the struggle phase would break down between out in the world experiencing the problem for the first time. So we call that a problem. And generally there would be another one called interest, where it's like, "Okay, now they're starting to shop around. They're getting into solution seeking mode." They might be on your website. They might be on your competitor's websites. They're reading product reviews, things like that. That's interest stage.

**中文翻译:**
这完全取决于产品和客户。通常我们会将其分为：挣扎阶段（Struggle phase）、评估阶段（Evaluation phase）和增长阶段（Growth phase）。挣扎阶段是指：他们正在经历问题，生活很糟糕，还在用老办法，必须得做点什么来解决它。通常，挣扎阶段分为“发现问题”（在现实世界中第一次感到痛苦）和“产生兴趣”（开始货比三家，进入寻找解决方案模式）。他们可能会看你的网站、竞争对手的网站、读产品评论等等。这就是兴趣阶段。

---

### [00:33:00] Georgiana Laudi

**English:**
And then there's the evaluation phase, which generally breaks down, I will say two or three milestones within the evaluation phase. I say two or three because if you have a more complex product, more complex customer is the more likely scenario. There may be more leaps of faith or more milestones, heavier lift for you to take. So we have worked with companies where the evaluation phase has been three or four milestones, I would always default to as few as possible. So if I'm cutting it down to lowest common denominator, I would say a first value would be the first milestone within evaluation. So you want to get them to that product activation really, really quickly. And then value realization is the milestone where you're solving that customer job. So they reach a point with your product where they're like, "Hell yes, this is it." And for the first time, they reach this critical threshold of product engagement. Now, what that product engagement is with your unique product for that specific customer is up for debate, but there still needs to be that moment.

**中文翻译:**
然后是评估阶段，通常分为两到三个里程碑。我说两三个是因为如果产品或客户更复杂，可能需要更多的里程碑或“信仰飞跃”。我们合作过的一些公司有三四个里程碑，但我总是倾向于越少越好。如果精简到最低限度，我会说“初次价值”（First Value）是评估阶段的第一个里程碑。你想让他们非常快速地达到产品激活。然后是“价值实现”（Value Realization），即你解决了客户任务的那个时刻。他们会觉得：“太棒了，就是这个。”他们第一次达到了产品参与的关键阈值。具体的参与形式因产品而异，但那个时刻必须存在。

---

### [00:34:08] Georgiana Laudi

**English:**
And then there's the growth phase, which is about the continued value. So getting to frequency of usage and a healthy building of that habit, getting into a cadence that makes sense. What type of feature usage and end product usage should you want to see there and then on what frequency becomes really important. And then there's another milestone generally after that where you're like, "Okay cool, they're in. They're pro. Now, what else do they need?" What else do they need from a product? And also, how else can we amplify them or work with them to either start teaching our tool to other people? I mean there's all kinds of things that can happen about growth. That's where the promise that exponential growth assess sort of comes into play.

**中文翻译:**
接下来是增长阶段，关乎持续价值。也就是达到使用频率并建立健康的习惯，进入合理的节奏。你希望看到什么样的功能使用和最终产品使用，以及频率是多少，这变得非常重要。通常之后还有一个里程碑，你会觉得：“太好了，他们成了忠实用户，成了专家。现在他们还需要什么？”他们还需要产品的哪些功能？我们还能如何放大他们的影响力，或者让他们开始向别人传授我们的工具？增长阶段有很多可能性，这就是 SaaS 指数级增长承诺发挥作用的地方。

---

### [00:34:54] Lenny

**English:**
And as people listen to this, just to maybe help if it's not super obvious, what people shouldn't imagine is like a little key frame, a storyboard frame of like, "Here's something your customer is doing." Right?

**中文翻译:**
听众听到这里，为了防止误解，大家不应该只把它想象成一个简单的关键帧或脚本画面，比如“这是客户正在做的事”，对吧？

---

### [00:35:04] Georgiana Laudi

**English:**
Yeah. We often talk about it and describe it as the story of how I met and fell in love with your product. It's like this documentary of being out in the world, finding it, realizing that like, "Hell yeah, this might actually solve a problem for us. This might be it." Getting that enough value to convince them to keep going to full value realization, to continue value-to-value growth.

**中文翻译:**
是的。我们经常把它描述为“我如何遇见并爱上你的产品”的故事。它就像一部纪录片：在现实世界中发现它，意识到“太棒了，这真的能解决我们的问题，就是它了”，获得足够的价值以说服他们继续走向完全的价值实现，并持续实现价值增长。

---

### [00:35:28] Lenny

**English:**
This episode is brought to you by Maven. I've been an investor, an advisor, and a customer of Maven from day one. I even taught my product management course through Maven. Maven is a cohort-based learning platform where you learn alongside peers with a direct connection to your instructor. Maven got a ton of courses for product managers, founders, and executives to help them level up in all kinds of ways. Over 10,000 people from Airbnb to Coinbase to Google to Tesla have taken courses from real experts and operators that have spent decades honing their craft.

**中文翻译:**
本集节目由 Maven 赞助。从第一天起，我就是 Maven 的投资者、顾问和客户。我甚至通过 Maven 教授我的产品管理课程。Maven 是一个基于同伴（Cohort-based）的学习平台，你可以与同行一起学习，并与讲师直接交流。Maven 为产品经理、创始人和高管提供了大量课程，帮助他们在各个方面提升。从 Airbnb 到 Coinbase，从 Google 到 Tesla，已有超过 1 万人参加了由拥有数十年经验的专家和实干家讲授的课程。

---

### [00:36:01] Lenny

**English:**
As part of their fall season, which Maven just launched, there are over 100 new courses starting in the next few weeks. Many of the people I've had on this podcast are teaching courses like Jackie Bavaro on product strategy, Arielle Jackson on startup branding, Emily Kramer on B2B marketing, plus Annie Duke on decision making, Nir Eyal on behavioral design, and how to break into product management with Marily Nika. Check out all of my favorite courses and learn more at maven.com/lenny.

**中文翻译:**
作为 Maven 刚刚启动的秋季课程季的一部分，未来几周将有 100 多门新课程开课。我在这档播客中邀请过的许多嘉宾都在授课，比如 Jackie Bavaro 讲产品战略，Arielle Jackson 讲初创公司品牌建设，Emily Kramer 讲 B2B 营销，还有 Annie Duke 讲决策，Nir Eyal 讲行为设计，以及 Marily Nika 讲如何进入产品管理领域。欢迎访问 maven.com/lenny 查看我最喜欢的课程并了解更多信息。

---

### [00:36:31] Georgiana Laudi

**English:**
Now, again, I'm saying that as if it applies to all customers and products, and that's not actually the case. Sometimes it's more complicated than that, but in general, that is what we have found. So that's what we did for SparkToro customers based on the research that we did. The research that we do, we basically take all the responses, we identify the critical patterns, and that's how we identify the customer job. From those critical patterns, if we segment down just that customer job, we can look at responses and say, "Okay, here's what they're likely doing when they're out in the world experiencing this problem. This is how they described the pain of their current solution. And then here's what they say about how their search for a solution started. Here's what they told us about how they started to do that research or find a solution."

**中文翻译:**
再说一次，我刚才说的听起来好像适用于所有客户和产品，但事实并非如此。有时情况会更复杂，但总的来说，这就是我们的发现。这就是我们根据研究为 SparkToro 客户所做的工作。我们进行的研究基本上是收集所有回复，识别关键模式，从而确定“客户任务”。通过这些模式，如果我们细分出那个特定的客户任务，我们就可以查看回复并说：“好吧，当他们在现实世界中遇到这个问题时，他们可能会这样做。这是他们描述当前解决方案痛苦的方式。这是他们说的寻找解决方案的起点。这是他们告诉我们的他们如何开始研究或寻找方案的过程。”

---

### [00:37:17] Georgiana Laudi

**English:**
And then there's questions that are asked in the research like, "What was the moment that convinced you that our product was going to solve this problem for you?" And the answers to that question are going to tell you what your first value should look like, which of that first product activation experience, whatever language you like to use, what should that look like for them? What parts of the product do you need to push right up to the front of that experience so they can get to it really, really quickly after they sign up?

**中文翻译:**
研究中还会问一些问题，比如：“是哪一个时刻让你确信我们的产品能为你解决这个问题？”这个问题的答案会告诉你“初次价值”应该是什样的。无论你用什么术语，比如“初次产品激活体验”，对他们来说那应该是什么样子的？你需要把产品的哪些部分推到体验的最前端，以便他们在注册后能非常、非常快地接触到？

---

### [00:37:40] Georgiana Laudi

**English:**
And then value realization obviously would be close to, if not, the desired outcome of that customer job where you're solving that customer job. And then you've got all kinds of... Generally, what happens when I'm going through this process with teams is, all kinds of ideas start to come up about what more they could be doing, even post solving that customer job, especially the product team gets really exciting because they've got all kinds of ideas about where the product can go. So that really helps tie everybody together too.

**中文翻译:**
然后，“价值实现”显然会接近（如果不是完全等同于）该客户任务的渴望结果。当你和团队一起经历这个流程时，通常会涌现出各种想法，关于在解决客户任务之后还能做些什么。尤其是产品团队会变得非常兴奋，因为他们对产品的未来走向有了各种构思。这真的有助于把大家凝聚在一起。

---

### [00:38:10] Georgiana Laudi

**English:**
A critical part of that process obviously is identifying we have to measure success along the way. There should be a KPI for each of those stages in that customer journey. And for the most part, they won't be a big surprise on the struggle side of things. People out in the world experience the problem, how are we going to know we're doing a good job reaching them? We bring in new unique website visitors. In general, that would be the measure of success for the problem milestone. And then next piece of the puzzle is like, okay, once they discover that we exist, even if they are visiting, reading product reviews and visiting competitor sites or whatever, we'll know we've done a good job of convincing them that we can help solve their problem and deterring the people that we don't want.

**中文翻译:**
流程中一个关键部分显然是确定如何衡量沿途的成功。客户旅程的每个阶段都应该有一个 KPI。在“挣扎阶段”，指标通常不难想到。人们在现实中遇到问题，我们怎么知道触达工作做得好？看网站的新独立访客数。通常，这就是“发现问题”里程碑的衡量标准。接下来的环节是：一旦他们发现我们的存在，即使他们还在看评论、逛竞品网站，如果我们能说服他们我们能解决问题，并劝退那些不匹配的人，我们就做得很好。

---

### [00:38:53] Georgiana Laudi

**English:**
We know we've done a good job when the conversion rate on whatever our primary CTA is on our website, whether or not it's start a trial or request a demo, something like that. Generally, the struggle phase is very straightforward in terms of measurement. That's like marketers' bread and butter, that's where they live and breathe all day long. Where things start to change though generally when we're working with companies is helping them figure out how should they be measuring first value or product activation and how should they be measuring actual product engagement. Generally, what we do there is, we can associate basically what they told us brings them the most amount of value with the product attribute or parts of the product that deliver that value. We try to tie the KPI obviously to some sort of meaningful product usage of that key part of the product or product attribute.

**中文翻译:**
当我们网站上主要 CTA（行动号召，如“开始试用”或“预约演示”）的转化率达标时，我们就知道自己做得不错。通常，挣扎阶段的衡量非常直接，那是营销人员的拿手好戏。但在我们合作的过程中，情况通常在“如何衡量初次价值或产品激活”以及“如何衡量实际的产品参与度”时开始发生变化。通常，我们会将客户告诉我们的“最有价值的东西”与交付该价值的产品属性或功能联系起来。我们会尝试将 KPI 与该核心功能或属性的有意义的使用行为挂钩。

---

### [00:39:49] Lenny

**English:**
Can you share some examples of that? Because that's a really important piece.

**中文翻译:**
你能分享一些例子吗？因为这是非常重要的一环。

---

### [00:39:52] Georgiana Laudi

**English:**
Yeah. I'll use SparkToro as an example just because it's the one that we started with. So for SparkToro, I don't remember the exact customer job statement necessarily, but for them, what they said were, the parts of the product that gave them a ton of value was two specific features: lists. So being able to organize their findings in a way that made it not only easy for them to organize within their own files but also share because a lot of them were with clients or stakeholders that they want to be able to share with. So lists were a specific feature that honestly, it was in there, but they weren't front loading the product experience with that. I'm not going to say it was hidden, but it wasn't front and center enough. So that was one feature that we could associate with being able to organize the data, being able to continue to build on it and make it usable over time and also share.

**中文翻译:**
好的。我还以 SparkToro 为例。我不记得确切的客户任务陈述了，但对他们来说，客户认为最有价值的是两个特定功能：首先是“列表”（Lists）。能够整理他们的发现，不仅方便自己在内部整理，还方便分享，因为很多用户需要向客户或利益相关者展示。老实说，列表功能一直都在，但他们并没有把它放在产品体验的最前面。我不是说它被隐藏了，但它不够显眼。这是我们可以与“整理数据、持续积累、长期可用及分享”联系起来的一个功能。

---

### [00:40:55] Georgiana Laudi

**English:**
And then there was another feature as well, which was an exporting feature. Again, it's not that it was hidden, but it wasn't front and center enough. So we tied KPIs to them making use of those features, coupled with obviously the core feature, which is searchability. It was like pairing the search functionality with the list functionality, and then pairing the search functionality with the list functionality, with the export functionality. It's a bit abstract to me just saying the words. It's easier with a visual. But the story is basically, help them use the search functionality first. Right after that, make sure that they're using lists. And if they don't use lists, let's help them get back to using it so that they get to that important critical value moment. And then the same applies for the exporting features that we were talking about.

**中文翻译:**
另一个是“导出”（Exporting）功能。同样，它不是被隐藏了，只是不够突出。所以我们将 KPI 与这些功能的使用挂钩，当然还要结合核心功能——“搜索”。就像是将搜索功能与列表功能配对，然后再将搜索、列表与导出功能配对。光说可能有点抽象，看图更容易理解。但核心逻辑是：先帮他们使用搜索功能；紧接着，确保他们使用列表；如果他们没用列表，我们就引导他们回来使用，以便达到那个关键的价值时刻。导出功能也是同样的道理。

---

### [00:41:43] Lenny

**English:**
Got it. And to be clear, you basically said a metric for each of these moments.

**中文翻译:**
明白了。明确一下，你基本上是为每一个时刻都设定了一个指标。

---

### [00:41:48] Georgiana Laudi

**English:**
Yeah, milestones.

**中文翻译:**
是的，里程碑指标。

---

### [00:41:50] Lenny

**English:**
Milestones. Yeah.

**中文翻译:**
里程碑，明白。

---

### [00:41:50] Georgiana Laudi

**English:**
Or just whatever. I mean you have to. I mean it always surprises me when a team is like, "Oh yeah. Yeah, you're right, we don't do that." I'm like, "What? What do you mean?" So at a given milestone, unless they've reached that value moment, you can't keep them on the train to something else. If they haven't even discovered that really, to them, most valued part of their product, you would need to focus on getting them to that value. Otherwise, you can't just keep firing off emails and hoping they're going to jump back into the product as if they're going to care. So a lot of what we'd do is actually proactive customer experiences, whether or not in app or email or whatever tool, to help them get to that moment within the product.

**中文翻译:**
你必须这么做。当有的团队说“噢对，你说的没错，我们没做那个指标”时，我总是很惊讶。我想：“什么？什么意思？”在特定的里程碑，除非他们达到了那个价值时刻，否则你无法让他们继续前进。如果他们还没发现产品中对他们最有价值的部分，你就得专注于引导他们实现那个价值。否则，你不能只是不停地发邮件，指望他们会莫名其妙地回到产品里。所以我们做的很多工作其实是“主动的客户体验”，无论是在应用内、邮件还是其他工具，去帮助他们达到产品内的那个时刻。

---

### [00:42:32] Georgiana Laudi

**English:**
And if they don't get to that moment, which is measurable, again, that's why it's a KPI, then we can be reactive in helping them get back in. So identifying, "Okay," not that you would say this like, "it fell off the train," but just helping them nurture them back into, the product didn't really discover that feature if they missed it the first time around. So it's proactive and pushing them forward, but then also catching them if they fall. And the only way to catch them if they fall is if you're measuring something meaningful along the way.

**中文翻译:**
如果他们没有达到那个时刻（这是可衡量的，所以才叫 KPI），我们就可以采取响应措施帮他们回来。识别出他们“掉队”了，然后引导他们重新发现那个被错过的功能。所以这既是主动推他们前进，也是在他们跌落时接住他们。而接住他们的唯一前提是，你在沿途衡量了一些有意义的东西。

---

### [00:43:02] Georgiana Laudi

**English:**
We have that storyboard that we were talking about. We also have a map where it's the experience to get them to a certain value moment, but then that win back experience to get them back in should they fall out for any reason. I mean, people get hungry and get distracted, and there's a ton of reasons why. I mean there's a lot of stats on the percentage. I think it's like 70% of people log into an app, log into a product once and never come back. It's wild. So the fact that so many companies don't have some sort of win back or re-engagement always blows my mind.

**中文翻译:**
我们有刚才提到的脚本，还有一张地图，展示了引导他们达到特定价值时刻的体验，以及在他们掉队时挽回（Win back）他们的体验。人们会饿、会分心，原因有很多。有很多统计数据表明，大约 70% 的人登录应用或产品一次后就再也不回来了。这太疯狂了。所以这么多公司竟然没有任何挽回或重新激活（Re-engagement）机制，这总是让我大开眼界。

---

### [00:43:41] Lenny

**English:**
So just to recap and then we'll keep going with the process. Step one, understand what your customers are going through, figure out the most important customer and their biggest problem, then map out the journey that they go through, the struggle they go through before they discover your product, the steps they go through to evaluate, decide to use your product. And then once they use your product, then continuing to use your product and using it more and more. And then once you figured out these steps... And is a rough number like 10, 12 steps? What's a good number just to put-

**中文翻译:**
简单总结一下，然后我们继续流程。第一步，了解客户正在经历什么，找出最重要的客户及其最大的问题；然后绘制他们经历的旅程：发现产品前的挣扎、评估和决定使用产品的步骤；以及使用产品后，如何持续使用并越用越多。一旦你弄清楚了这些步骤……大概是多少步？10 到 12 步吗？一个合适的数字是多少？

---

### [00:44:13] Georgiana Laudi

**English:**
Oh no, I would hope it's more like six.

**中文翻译:**
噢不，我希望更接近 6 步。

---

### [00:44:16] Lenny

**English:**
Six, okay.

**中文翻译:**
6 步，好的。

---

### [00:44:17] Georgiana Laudi

**English:**
I'm always trying to bring it down lowest, only as long as it absolutely needs to be. I mean that goes for all pages, landing pages.

**中文翻译:**
我总是试图把它降到最低，只要能满足需求就行。这适用于所有页面，包括落地页。

---

### [00:44:25] Lenny

**English:**
Okay, all right.

**中文翻译:**
好的，明自。

---

### [00:44:25] Georgiana Laudi

**English:**
Same thing for customer journey mask.

**中文翻译:**
客户旅程图也是一样。

---

### [00:44:27] Lenny

**English:**
Okay. Airbnb had 12, I think. So you're involved in-

**中文翻译:**
好吧，我记得 Airbnb 有 12 步。所以你参与了——

---

### [00:44:29] Georgiana Laudi

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:44:29] Lenny

**English:**
I liked that. Okay. And then you've come up with a metric to tell you if that step is performing well.

**中文翻译:**
我喜欢那个。好的。然后你设定了一个指标来告诉你这一步的表现是否良好。

---

### [00:44:36] Georgiana Laudi

**English:**
If they'd gotten there, did they get to that value?

**中文翻译:**
看他们是否到达了那里，是否获得了那个价值。

---

### [00:44:37] Lenny

**English:**
If they've gotten there. Cool. One last question before we move on to the next step. Can you give two maybe examples of an actual movement, say in SparkToro's case, and then the metric that they use to measure, if they've gotten to that point?

**中文翻译:**
看他们是否到达。酷。在进入下一步之前最后一个问题：你能举两个具体的例子吗？比如在 SparkToro 的案例中，一个具体的动作以及用来衡量是否达到该点的指标。

---

### [00:44:52] Georgiana Laudi

**English:**
Yes. So the measure for success at that tip somebody over into evaluation is performing their first search. So when you're on their website, you perform a search, it's not signing up for a trial or signing up for free, although it does tip you into signing up for free when you perform your first search. So signing up for getting your first search and seeing your first search results is that first measure. And then following that for first value, it is using search again. I mean this is very product specific like I said, but generally, a first search is a kind of an experiment where you're sort of trying the tool on for the first time. Generally, searches start to get better when you do your second and third. So we try to encourage at least five plus.

**中文翻译:**
好的。在将用户推向“评估阶段”时，成功的衡量标准是“进行第一次搜索”。当你在他们网站上进行搜索时，这还不是注册试用或免费版，尽管第一次搜索会引导你注册。所以，完成第一次搜索并看到搜索结果是第一个衡量标准。接下来的“初次价值”则是“再次使用搜索”。这非常取决于产品，但通常第一次搜索只是一种尝试。搜索效果通常在第二次、第三次时会变好。所以我们尝试鼓励用户至少进行 5 次以上的搜索。

---

### [00:45:38] Georgiana Laudi

**English:**
So that first value KPI, I think it was five plus searches, plus at least one list. So it's the combination of those two things that have to happen before somebody's going to really see what this thing does. It's not that they won't get value if they don't use lists, but because we know that SparkToro's ideal customers really get a ton of value out of lists, people can hang out in that stage all day long if they want to. We're not going to worry about them. We're going to worry about the people that really want the actual functionality of the real fully featured tool. So that was the first value, that's how we would know that they got to product activation.

**中文翻译:**
所以那个“初次价值”KPI，我记得是 5 次以上搜索加上至少创建一个列表。只有这两个动作结合起来，用户才能真正领悟这个工具的作用。并不是说不用列表就没价值，但因为我们知道理想客户能从列表中获益巨大。如果用户只想随便看看，我们不担心；我们担心的是那些真正想要全功能工具的人。这就是初次价值，也是我们判断他们是否达到“产品激活”的标准。

---

### [00:46:21] Georgiana Laudi

**English:**
And then the next one, as I mentioned before, is a combination of actually three things. So it is conducting a minimum amount of searches within a span of time, creating at least a certain number of lists, I can't remember exactly what it is, and then discovering exporting at least once. And then that is, they've reached a meaningful enough threshold of product engagement. And then value growth was that they do all of that on a regular enough basis so that we know they're not a flight risk basically. So that we know that they're getting continued value from the product. And if they ever fall out of that ongoing engagement measured success, then we can trigger either one-on-one outreach, an email, whatever. I mean obviously it can't be an app because if they're not logging into the app, then you can't reach them. But to help them back in and to say, "Hey, what's up? Can we help? Is there anything that we can do?" And basically be proactive in getting them back in. And then value growth, I believe I think it was expansion or upgrade in their case. I can't remember exactly.

**中文翻译:**
接下来的一个指标，正如我之前提到的，实际上是三件事的结合：在一段时间内进行最低限度的搜索、创建至少一定数量的列表（具体数字我忘了），以及至少发现并使用一次导出功能。达到这些，就意味着他们达到了产品参与的有意义阈值。而“价值增长”则是他们定期重复这些动作，这样我们就知道他们基本没有流失风险，正在从产品中获得持续价值。如果他们脱离了这种持续参与，我们就可以触发一对一沟通、邮件等。显然不能用应用内通知，因为他们都不登录了。我们会问：“嘿，最近怎么样？有什么我们可以帮忙的吗？”主动引导他们回来。至于价值增长，在他们的案例中，我认为是增购（Expansion）或升级（Upgrade），具体记不清了。

---

### [00:47:27] Lenny

**English:**
Cool. So you end up with these say, six KPIs.

**中文翻译:**
酷。所以你最终得到了这 6 个左右的 KPI。

---

### [00:47:29] Georgiana Laudi

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:47:30] Lenny

**English:**
I imagine this becomes goals you track, and then you probably pick one of these to focus on say, per year, per quarter. Awesome.

**中文翻译:**
我猜这些成了你们追踪的目标，然后你们可能会选其中一个作为年度或季度重点。太棒了。

---

### [00:47:37] Georgiana Laudi

**English:**
Yeah, hopefully not per year.

**中文翻译:**
是的，希望不是按年。

---

### [00:47:38] Lenny

**English:**
Okay, per week.

**中文翻译:**
好吧，按周。

---

### [00:47:40] Georgiana Laudi

**English:**
Hopefully short, because I mean I will say that with some of the KPIs, it's very straightforward with new unique website visitors or the website conversion rate. I mean depending on who owns the website, that's not something that should take you a year. You should never be focused on only your website's conversion rate for a year hopefully. But these other KPIs and these other milestones, I mean I have no disillusions about if it impacts the product, obviously there's a lot of implications there. So yes, generally, once you tip over into that sort of in-app and more product experience, timelines vary widely, to say the least.

**中文翻译:**
希望能短一点。我的意思是，有些 KPI 非常直接，比如新独立访客或网站转化率。取决于谁负责网站，这不该花上一年的时间。你总不希望一年到头只盯着网站转化率吧。但对于涉及产品体验的其他 KPI 和里程碑，我没有幻想，因为这涉及产品改动，影响很大。所以，一旦进入应用内和产品体验层面，时间线确实会变得非常不确定。

---

### [00:48:18] Lenny

**English:**
Okay, cool. Let's move on to the next step.

**中文翻译:**
好的，酷。让我们进入下一步。

---

### [00:48:21] Georgiana Laudi

**English:**
So after that point, we had a rich voice of customer document that came out of that research. We had a messaging guide for them to use not only in their marketing materials but also through the entire product experience, and also identifying the parts of the product that were so meaningful. Actually, their VP of marketing, the new VP of marketing, Amanda Natividad, actually rolled out checklist. They built a checklist, a product onboarding checklist and also product onboarding emails. And their trial-to-paid doubled. We were like, "Okay, cool, let us know if you need any help or whatever." And they're like, "Oh, we're good. We got this." Checked in two months later and their trial-to-paid had doubled.

**中文翻译:**
在那之后，我们根据研究整理出了一份详尽的“客户原声”（Voice of Customer）文档。我们为他们提供了一份话术指南，不仅用于营销材料，还贯穿整个产品体验，并识别出了产品中那些极具意义的部分。实际上，他们的新任营销副总裁 Amanda Natividad 推出了清单——他们建立了一个产品引导清单和引导邮件。结果他们的试用转付费率翻了一番。我们当时说：“好的，酷，需要帮忙随时找我们。”他们说：“噢，不用，我们搞定了。”两个月后回访，他们的试用转付费率确实翻倍了。

---

### [00:49:03] Lenny

**English:**
I feel like you skipped the important staff of, "Hey, we got KPIs." And then you're like, "Oh, we gave them all this information." So I'd love to spend a little more time on there. You came up with messaging for them, positioning stuff. what happens there?

**中文翻译:**
我觉得你跳过了一个重要环节：在有了 KPI 之后，你说“我们给了他们所有这些信息”。我想多花点时间聊聊那部分。你为他们设计了话术、定位等内容，具体是怎么操作的？

---

### [00:49:16] Georgiana Laudi

**English:**
Well, this is the thing. They have a team in place. They've got very highly skilled, a huge team but highly skilled marketer there at the helm. I mean not the list of which is Rand Fishkin, their CEO. So basically, what we did was we gave them, it's like a framework. So it's like, "Here are the bones of this. So got a messaging and positioning guide for you." Generally, I mean when we do them, they're five to seven pages long. They hit on the value prop. They hit on the major competitive advantages. They hit on the major value themes that you want to focus on. Those value themes can be broken down by the emotional benefits and the functional benefits tied to the product attributes that drive that value. So that document, and there's more that goes into it, but that messaging guide basically can be used as the baseline for all kinds of marketing collateral and material, but also email onboarding.

**中文翻译:**
是这样的。他们已经有了一个团队，有一群技能高超的营销人员在掌舵，更不用说他们的 CEO Rand Fishkin 本身就是专家。所以基本上，我们给他们提供的是一个框架。就像是：“这是骨架，这是一份为你准备的话术和定位指南。”通常我们做的指南有 5 到 7 页长。它涵盖了价值主张、主要竞争优势以及你想关注的核心价值主题。这些价值主题可以进一步拆解为情感收益和功能收益，并与驱动这些价值的产品属性挂钩。这份文档（内容还有很多）基本上可以作为所有营销素材、资料以及邮件引导的基准。

---

### [00:50:16] Georgiana Laudi

**English:**
So when they're writing their email sequences for whatever it is they're trying to solve for, whatever milestone they're solving for, they can use that as their baseline like, "This is what we're going for. This is the goal here." And that messaging guide rules up to the job to be done. So the job to be done is sort of like the top line. And then we've got that messaging that serves that job to be done. And then we've got the sort of operationalized customer experience with those milestones and KPIs. And then you sort of zoom in on like, where is the experience most broken right now? We already knew that for SparkToro. We knew that we wanted to influence that first early product experience. So that's where we zoomed in and decided on what programs they should roll out. And email onboarding was a natural, as was the checklist.

**中文翻译:**
所以当他们为某个目标或里程碑编写邮件序列时，他们可以以此为基准：“这就是我们的方向，这就是目标。”这份话术指南是服务于“待办任务”（JTBD）的。JTBD 是最高纲领，话术服务于它，然后我们有了带有里程碑和 KPI 的可操作客户体验。接着你会聚焦于：目前体验中哪里最脱节？对于 SparkToro，我们已经知道了，我们想影响最初的产品体验。所以我们聚焦在那里，决定推出哪些项目。邮件引导和清单就是顺理成章的选择。

---

### [00:51:03] Lenny

**English:**
For folks that want to work on messaging, say kind of just like, "Hey, here's a bunch of messaging advice," any tips for how to message well, how to think about messaging once you have a sense of your journey, maybe some goals, any just pro tips here you could share?

**中文翻译:**
对于那些想要优化话术的人，比如“嘿，给我点话术建议”，在了解了旅程和目标后，关于如何写好话术、如何思考话术，你有什么专业建议可以分享吗？

---

### [00:51:21] Georgiana Laudi

**English:**
Oh, boy. I mean that research and the voice of customer, I mean I'm always going to go back to that. You can guess and you can do use your best judgment. You can use internal stakeholders and the internal team knowledge. And I'm not saying that that is not valuable and that you shouldn't use that at all. You can, but it should never come before learning from and listening to your best ideal customers and using the language that they use. You want to reflect them back to them. That is what is going to show them that you understand the problem that they have and that your product has exactly what it is that they need.

**中文翻译:**
噢，天哪。我还是要回到研究和“客户原声”上。你可以靠猜，也可以凭经验判断，或者利用内部利益相关者和团队的知识。我不是说这些没价值，你可以参考，但它们永远不应该排在“向理想客户学习并倾听他们”之前。要使用他们使用的语言，把他们的话反射回给他们。这才能向他们证明你理解他们的问题，并且你的产品正是他们所需要的。

---

### [00:52:06] Georgiana Laudi

**English:**
The hierarchy of messaging is really important as well. So I mean, there's the classic, sometimes it's hard to see the label from inside the jar, so it's really helpful to get out and be like, "Okay, how do customers see us?" Generally, you can identify the hierarchy of what is important to them, what is the thing that they say is most valuable about their product? What was that aha moment or what was that first value moment? Or what is the thing that makes you stand out over everybody else? And it can literally be a numbers game. If you take a hundred or so survey responses, you can break that down like, "Here's the thing they said they cared about most. Here's the thing they said they cared about second most and third most," not to be so paint by numbers about it, but there's art in the science. But in general, you want to reflect back what they said they care about, not what you think is the coolest thing about your product. That's obviously not the best way to go.

**中文翻译:**
话术的层级（Hierarchy）也非常重要。俗话说“当局者迷”（很难从瓶子里面看到外面的标签），所以跳出来看“客户如何看待我们”非常有帮助。通常你可以识别出对他们来说重要性的层级：他们认为产品最有价值的地方是什么？那个“顿悟时刻”（Aha moment）或“初次价值时刻”是什么？是什么让你脱颖而出？这甚至可以是一个数字游戏。如果你有 100 份问卷回复，你可以拆解出：“这是他们最关心的，这是第二关心的，这是第三关心的。”虽然科学中有艺术，但总的来说，你要反映他们关心的东西，而不是你认为产品最酷的地方。后者显然不是最佳路径。

---

### [00:53:05] Georgiana Laudi

**English:**
That's something that we all inherently know, but it becomes really hard when there's a lot going on and things are changing and the product is evolving and there's a lot of teens and people are coming and going. It's easy to lose sight of that, especially when you're just trying to get shit out the door. So that messaging guide is mentally like, "Okay, here we are. This is my baseline, these are my guardrails for everything that we produce." It's also really handy to hand off to copywriters when you bring in... I mean not just copywriters, lots of people, but particularly when you're producing copy, providing that messaging guide is solar platter for them.

**中文翻译:**
这是我们内心都知道的道理，但当事务繁忙、情况多变、产品演进、人员流动时，坚持这一点就很难。当你只想赶紧把活干完时，很容易忽视它。所以那份话术指南在心理上就像是：“好了，这就是基准，这是我们产出所有内容的护栏。”当你引入文案撰写人（Copywriters）或其他人员时，这份指南对他们来说简直是“银盘盛上的大餐”（极其有用）。

---

### [00:53:46] Lenny

**English:**
Is this available anywhere, the template that you end up sharing with a customer? Just like, here's a guide, the layout, messaging, recommendations.

**中文翻译:**
你分享给客户的这个模板在网上能找到吗？比如指南的格式、布局、话术建议等。

---

### [00:53:53] Georgiana Laudi

**English:**
Oh, we have so many.

**中文翻译:**
噢，我们有很多。

---

### [00:53:55] Lenny

**English:**
Maybe a little-

**中文翻译:**
也许可以分享一点——

---

### [00:53:55] Georgiana Laudi

**English:**
We have so many templates and stuff. Yeah, I'll include a couple links.

**中文翻译:**
我们有很多模板之类的。是的，我会提供几个链接。

---

### [00:54:01] Lenny

**English:**
Great. I'll put it in the show notes.

**中文翻译:**
太好了，我会放在节目笔记里。

---

### [00:54:02] Georgiana Laudi

**English:**
We got lots of stuff like that. Yeah.

**中文翻译:**
我们有很多这类资料。

---

### [00:54:04] Lenny

**English:**
Okay, great. A few final questions around jobs to be done.

**中文翻译:**
好的，太棒了。关于“待办任务”（JTBD）最后几个问题。

---

### [00:54:09] Georgiana Laudi

**English:**
Yeah.

**中文翻译:**
好的。

---

### [00:54:10] Lenny

**English:**
So you said that they doubled their conversion from free to paid.

**中文翻译:**
你说他们把免费转付费的转化率翻了一番。

---

### [00:54:13] Georgiana Laudi

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:54:13] Lenny

**English:**
Amazing. What was their job to be done in the end? And then I just have a few questions about the jobs to be-

**中文翻译:**
太神奇了。他们最终确定的“待办任务”是什么？然后我还有几个关于任务的问题——

---

### [00:54:19] Georgiana Laudi

**English:**
I think it was when they're struggling to identify opportunities that aren't as obvious. So generally, when you're doing marketing research, you'll end up signing the same things over and over again. And if you are a service provider or if you're in-house for that matter and you're tasked with always coming up with novel and new and more and more and more, you tap that pretty quickly. So what customers were coming to them for was like, "Give me more. I need to impress here. I need more to work with. I need to identify opportunities that I wouldn't otherwise be aware of." Actually that was exactly what it was. I helped me identify opportunities as I wouldn't otherwise be aware of. So the customer job statement is, "When I am in a certain situation, help me," which is filled in by what those things that they're looking, for those motivations, "so I can," which is the desired outcome.

**中文翻译:**
我认为是“当他们难以识别那些不明显的（营销）机会时”。通常，当你做营销研究时，你总会反复看到同样的东西。如果你是服务提供商或公司内部人员，任务是不断提出新颖、更多、更好的方案，你很快就会枯竭。所以客户找他们的原因是：“给我更多灵感，我需要在这里给人留下深刻印象，我需要更多素材，我需要识别那些我原本意识不到的机会。”实际上，任务陈述就是：“帮我识别那些我原本意识不到的机会。”JTBD 的标准陈述是：“当我处于某种情况时，请帮我（填入动机），以便我能（填入渴望的结果）。”

---

### [00:55:18] Georgiana Laudi

**English:**
The help me was about, I believe it was in a way that is organized and that is shareable and usable over time that I can build on and really rely on over time. And the desired outcome was about, I mean this isn't going to be surprising, but it was about getting stakeholder by hand and getting people on board with, and sharing and looking good, looking like a pro, and doing their job more effectively and driving better results for either their own team or for their clients.

**中文翻译:**
“帮我”的部分是：以一种有组织的、可分享的、长期可用的方式，让我可以持续积累并真正依赖。而“渴望的结果”是（这并不意外）：获得利益相关者的认可，让大家参与进来，分享成果，让自己看起来很专业，更有效地完成工作，并为团队或客户带来更好的业绩。

---

### [00:55:48] Lenny

**English:**
Awesome. We got there. We gloss a little bit over jobs to be done. I imagine many people listening have no idea what this is. So maybe as our final question, can you just explain what this framework is and how folks can learn to use it, or any resources you recommend that comes to mind?

**中文翻译:**
太棒了。我们刚才略过了 JTBD 的基础定义。我想很多听众可能还不知道这是什么。所以作为最后一个问题，你能解释一下这个框架是什么，大家如何学习使用它，或者有什么推荐的资源吗？

---

### [00:56:07] Georgiana Laudi

**English:**
Yeah. I mean a heavy influence for us definitely is Bob Moesta, who's one of the original architects of jobs to be done. There are lots of materials online for jobs. I am not the foremost authority in jobs at all. I think jtbd.info is a good website. There's a bunch. Also, Bob Moesta wrote a book called Demand-Side Sales that goes into it. There's also a lot of books written about jobs to be done. When Coffee and Kale is one that a lot of people love. I digress. Point being that what matters is identifying what it is that customers are trying to accomplish. So demographic data doesn't matter. The classic example is, if you look at... Oh, King Charles, now the example has changed. If you look at Ozzy Osbourne, and it was Prince Charles the original, but now it's King Charles, if you look at those two men, they're the exact same age and live in the same area. They both have a dog. They both love cars.

**中文翻译:**
好的。对我们影响很大的人绝对是 Bob Moesta，他是 JTBD 的原创设计者之一。网上有很多相关资料。我绝不是这方面的最高权威。我觉得 jtbd.info 是个不错的网站。Bob Moesta 写了一本叫《Demand-Side Sales》（需求侧销售）的书，讲得很深入。还有很多关于 JTBD 的书，比如《When Coffee and Kale Compete》很受欢迎。言归正传，重点是识别客户想要完成什么。人口统计数据并不重要。经典的例子是：如果你看奥兹·奥斯本（Ozzy Osbourne）和查尔斯国王（以前的例子是查尔斯王子），这两个人年龄相同，住在同一个地区，都养狗，都爱车。

---

### [00:57:04] Georgiana Laudi

**English:**
From a demographic standpoint, they are identical, but they obviously lead very different lives. What motivates them is very different. So that is where typically personas sort of fall down. So what jobs to be done, to us, is help you figure out what is that desired outcome, what does that better life that customers are seeking out. You were just the vehicle to get them there. That's all it is. I mean there's so many tired analogies so I don't even want to use them but-

**中文翻译:**
从人口统计学的角度看，他们是一模一样的，但显然他们的生活方式完全不同，动机也完全不同。这就是传统“用户画像”失效的地方。对我们来说，JTBD 是帮你弄清楚客户追求的“渴望结果”是什么，他们向往的“更好的生活”是什么。你只是帮他们到达那里的工具。这就是它的全部。有很多陈词滥调的比喻，我都不想用了，但是——

---

### [00:57:34] Lenny

**English:**
Milkshakes maybe.

**中文翻译:**
也许是奶昔的比喻。

---

### [00:57:36] Georgiana Laudi

**English:**
What's that?

**中文翻译:**
你说什么？

---

### [00:57:37] Lenny

**English:**
The milkshake analogy.

**中文翻译:**
奶昔的比喻（克里斯坦森著名的 JTBD 案例）。

---

### [00:57:38] Georgiana Laudi

**English:**
The milkshake one, it's not even the analogy. I think that was one of the original job stories that is the milkshake one.

**中文翻译:**
奶昔那个，甚至不只是个比喻。我认为那是 JTBD 最初的经典案例之一。

---

### [00:57:45] Lenny

**English:**
Any other things you want to share about the process that you go through with the companies, things you've learned, before we get to a very exciting lightning round?

**中文翻译:**
在进入令人兴奋的闪电轮问答之前，关于你与公司合作的流程或学到的经验，还有什么想分享的吗？

---

### [00:57:54] Georgiana Laudi

**English:**
Yeah. One of the objections that we often get to this type of work is that research takes a long time and that research can often lead to more questions and can slow everything down. You can end up in analysis paralysis, but it doesn't have to be that way. It can be very straightforward, honestly, in a survey scenario. With SparkToro, in just that scenario, I have lots of examples of companies where we ran surveys, it can be a couple of weeks. Two or three weeks, you can actually come out with something solid to move forward with, and you don't get stuck in the bickering or all those stakeholders, the too many cooks in the kitchen. You can come to something decisive. You can get value out of that.

**中文翻译:**
有的。我们经常听到的反对意见是：研究太花时间，而且研究往往会引出更多问题，拖慢进度，导致“分析瘫痪”。但事实并非如此。老实说，通过问卷调查可以非常直接。在 SparkToro 的案例中，以及我合作过的许多公司中，做问卷调查只需要两三周。两三周时间，你就能得到扎实的结果并继续推进，而不会陷入利益相关者的争吵或“厨师太多烧坏汤”的窘境。你可以得出果断的结论并从中获益。

---

### [00:58:47] Georgiana Laudi

**English:**
The other thing too, the other objection that we get a lot from founders in particular is because they build products to solve a problem that they had, which is cool and it definitely makes you one of the most knowledgeable people about your solution. But products change, markets change, customers change, teams change in a ball. Not everything can live inside of your head, and there's a ton of value in learning and getting inside the heads of your best customers that you may have been really close to the inception of the product. But if any span of time has changed, you'll always learn something new. I've never been in a scenario like this where a founder has not learned something new from their research and been able to leverage it in a way that makes their product experience better.

**中文翻译:**
另一件事，尤其是从创始人那里听到的反对意见是：他们构建产品是为了解决自己遇到的问题。这很酷，也让你成为最了解解决方案的人。但产品会变，市场会变，客户会变，团队也会变。不是所有东西都能装在你的脑袋里。学习并进入你最好客户的大脑具有巨大的价值，即使你在产品诞生之初与他们很亲近，但只要时间流逝，你总能学到新东西。我从未遇到过哪个创始人在研究中没有学到新东西，并能利用这些新知识来改善产品体验。

---

### [00:59:35] Lenny

**English:**
Awesome. We'll come back to how folks can reach out to you if they want to experience this process, could work with you, learn more. But before we get there, we've gotten into a very exciting lightning round. I've got five quick questions for you. We'll go through them quick, whatever comes to mind. That's what we're doing. Okay, sounds good?

**中文翻译:**
太棒了。稍后我们会回到大家如何联系你、如何体验这个流程或与你合作。但在那之前，我们进入非常刺激的闪电轮问答。我有五个简短的问题，请快速回答，想到什么说什么。准备好了吗？

---

### [00:59:50] Georgiana Laudi

**English:**
Okay.

**中文翻译:**
准备好了。

---

### [00:59:51] Lenny

**English:**
Okay. What are two or three books that you recommend most to people looking to get better at marketing?

**中文翻译:**
好的。你会向想要提升营销能力的人推荐哪两三本书？

---

### [00:59:58] Georgiana Laudi

**English:**
I very, very, very rarely read marketing books, but there's two that I think are pretty foundational and recent. So Obviously Awesome by April Dunford. I'm sure you've heard that one a ton. It's kind of required reading, I would say, especially for founders. I told April when she first wrote, I'm like, "I'm going to require every single founder I work with to read your book before we work with them," because it's foundational, you have to know that.

**中文翻译:**
我极少读营销类的书，但有两本我认为非常基础且是近期的。一本是 April Dunford 的《Obviously Awesome》（显然很棒）。我敢肯定你听过很多次了。我会说这是必读书目，尤其是对创始人。当 April 刚写完书时我就告诉她：“我会要求每一个跟我合作的创始人在开工前先读你的书”，因为它是基础，你必须懂。

---

### [01:00:23] Georgiana Laudi

**English:**
And then the other one that I really enjoyed flip side was Hooked by Nir Eyal. That one was great too. But like I said, I don't read many marketing books. The other one that I would be remiss not to mention is ours that we're writing about the process, which is really about the step by step how to do this thing. So as much as we love going through this process with companies, I sort of took a page from April here too, in that telling the process and having people be able to rule this out and do this internally themselves has been wildly gratifying. We do it with a training program and this is our next step in getting out into the world even more. So you absolutely can do this stuff yourself. So that process is later in that book. And then another book that I read recently, which has nothing to do with marketing at all, but was really nice was 4000 Weeks. I don't think-

**中文翻译:**
另一本我非常喜欢的是 Nir Eyal 的《Hooked》（上瘾）。那本也很棒。但就像我说的，我不怎么读营销书。如果不提到我们正在写的关于这个流程的书，那就是我的失职了，那本书讲的是如何一步步操作。虽然我们喜欢陪公司走这个流程，但我也借鉴了 April 的做法：公开流程，让人们能在内部自己动手，这非常有成就感。我们通过培训计划来做这件事，这是我们走向世界的下一步。你绝对可以自己动手。那个流程就在书里。最近读的另一本与营销无关但很棒的书是《4000 Weeks》（四千周）。

---

### [01:01:15] Lenny

**English:**
I'm reading that right now.

**中文翻译:**
我正在读那本。

---

### [01:01:15] Georgiana Laudi

**English:**
Oh yeah, I enjoyed it. It was a nice sort of coming back to base a bit. I don't know when I read it. I just finished it a couple of weeks ago. It was just the timing was perfect. I feel like what's going on in the world right now and how everybody's probably feeling right now, it's a good solid read for now.

**中文翻译:**
噢是的，我很喜欢。它让人有一种回归本原的感觉。我几周前刚读完，时机非常完美。考虑到现在世界上发生的一切以及大家的感受，这是一本非常扎实的好书。

---

### [01:01:38] Lenny

**English:**
I'm enjoying it. I just started. I'm glad to-

**中文翻译:**
我很喜欢，才刚开始读。

---

### [01:01:40] Georgiana Laudi

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:01:41] Lenny

**English:**
Well, you encouraged me to keep reading it.

**中文翻译:**
你鼓励了我继续读下去。

---

### [01:01:43] Georgiana Laudi

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:01:43] Lenny

**English:**
Okay. Favorite recent movie or TV show?

**中文翻译:**
好的。最近最喜欢的电影或电视节目？

---

### [01:01:46] Georgiana Laudi

**English:**
I have young kids. I just bought a second property. We're renovating three houses right now. I do not watch movies almost ever. The only thing that I'm currently binging is YouTubers that do DIY interior design and renos. Reason being my partner and I bought a property with four very, very old cottages lakefront, almost like tiny houses, little cottages. We are slowly renovating each of them. So my sort of fill is learning about interior design and DIY home rentals. Yeah.

**中文翻译:**
我有小孩，刚买了第二处房产，现在正在装修三栋房子。我几乎从不看电影。我目前唯一在追的是那些做 DIY 室内设计和翻修的 YouTuber。原因是我和伴侣买了一处湖边的房产，上面有四栋非常古老的小木屋，就像微型住宅。我们正在慢慢翻修每一栋。所以我现在的消遣就是学习室内设计和房屋翻修。

---

### [01:02:31] Lenny

**English:**
Who's had the most impact on you in your career?

**中文翻译:**
职业生涯中谁对你影响最大？

---

### [01:02:31] Georgiana Laudi

**English:**
This is the worst question. I hate saying this, but it's probably my dad. I have to say my dad because he's an entrepreneur through and through. And I remember very vividly, I worked for him for I think eight years early in my career. One of the things that he always said was like, "It was the joy of the business." He didn't care what, he's like, "It doesn't matter what you're selling." He could be selling anything, but it was the joy of entrepreneurship. And that really stuck with me. So even when I was in house, I always knew that I needed to do something on my own and be in charge of that journey. His joy in it has impacted me a lot. He was the reason why I knew I was always going to do this.

**中文翻译:**
这是最难回答的问题。虽然不想这么说，但可能是我父亲。我必须说是我父亲，因为他是一个彻头彻尾的企业家。我记得很清楚，职业生涯早期我为他工作了大约八年。他总是说：“这是经营的乐趣。”他不在乎卖什么，他说：“卖什么不重要。”他可以卖任何东西，但他享受创业的乐趣。这深深影响了我。所以即使我在公司内部工作时，我也知道我最终要自己创业，掌控自己的旅程。他在其中的快乐极大地影响了我，是他让我知道我终将走上这条路。

---

### [01:03:26] Georgiana Laudi

**English:**
Other than that, I would say I have an incredible network of women that I have been very lucky. We're part of a group that we call Shine Crew. I think I'm supposed to copyright that or something to somebody because I think the term Shine Theory is what it's based on basically. But I'm very, very lucky to be heavily influenced by April Dunford, Tara Robertson, Joanna Wiebe, Talia Wolf. And then obviously my business partner, Claire, obviously changed everything for me. Having that partnership in business, I don't think I would've lasted this long. So yeah, definitely a huge influence for sure.

**中文翻译:**
除此之外，我非常幸运拥有一群了不起的女性伙伴。我们是一个叫“Shine Crew”的小组。我想这个名字可能涉及版权，因为它基于“发光理论”（Shine Theory）。我很幸运受到 April Dunford、Tara Robertson、Joanna Wiebe、Talia Wolf 的深刻影响。当然，我的商业伙伴 Claire 显然改变了我的一切。如果没有这段合伙关系，我想我坚持不了这么久。所以，她们的影响确实巨大。

---

### [01:04:10] Lenny

**English:**
What's one thing that helps you stay focused and productive during the day?

**中文翻译:**
有什么方法能帮你保持一整天的专注和高效？

---

### [01:04:15] Georgiana Laudi

**English:**
Definitely carving up time, like time blocking. I do a lot of time blocking in advance with a little brain emoji of safeguarding my time. Because we're a small team and we use Slack obviously, something else that we do to protect each other's time is not time stamp, but we put a little code in all of our messages that's either like, "You don't have to listen to this before the end of the day," or, "It's timely," or, "It's no rush," so that we know when we need to mentally process messages in Slack, so we can drop in there just periodically. And then the only other thing that I would say that I do maybe once a month or once a quarter is, we're pretty buttoned up about our time tracking, so we go back and it sort of keeps us honest about how our time is actually spent. And then we can sort of adjust and time block accordingly to make up for the shortcomings of our previous quarter.

**中文翻译:**
绝对是划分时间，比如“时间块”（Time blocking）。我会提前做好时间块，并用一个小脑袋表情符号标记，以保护我的时间。因为我们团队很小，使用 Slack，为了保护彼此的时间，我们会在消息里加个小代码，比如“下班前看就行”、“有时效性”或“不急”。这样我们就知道什么时候需要处理 Slack 消息，只需定期查看即可。另外，我大概每月或每季度会做一次时间追踪审计，这让我们能诚实地面对时间的实际去向，然后根据上季度的不足来调整时间块。

---

### [01:05:10] Lenny

**English:**
That was really clever. I haven't heard of that trick. What's the emoji for "You can do this later"?

**中文翻译:**
这招真聪明，我还没听过。那“稍后处理”的表情符号是什么？

---

### [01:05:15] Georgiana Laudi

**English:**
We actually just use no rush or EOD for end of day, or timely. We do have the alarm emoji, is the "Now. This is going to be dealt with ASAP."

**中文翻译:**
我们其实直接用文字，比如“No rush”（不急）、“EOD”（下班前）或“Timely”（及时）。我们确实有个闹钟表情符号，代表“现在，需要尽快处理”。

---

### [01:05:29] Lenny

**English:**
Amazing. Gia, thank you for making time. For this final question, where can folks find you online? How do they pre-order your book? How can they learn more? And then also, just how can listeners be useful to you?

**中文翻译:**
太棒了。Gia，感谢你抽时间参加。最后一个问题：大家可以在哪里找到你？如何预订你的书？如何了解更多信息？以及，听众能为你做些什么？

---

### [01:05:39] Georgiana Laudi

**English:**
Thank you for asking. Twitter is probably the best way. My Twitter handle is atrocious, @ggiiaa is me on Twitter. I'm on LinkedIn every once in a while obviously. My email address is gia@forgetthefunnel.com. So if anybody has any questions, whatever, feel free to email me. If you want any templates or whatever that don't get included in the show notes, just ping me. I've no problem with that. And then forgetthefunnel.com, we've got a book page where there is a wait list for the... Well, we're going to do presale, and then the published physical book will be early in 2023. But we are going to do presale because... Get it in those hands. Why not?

**中文翻译:**
谢谢提问。Twitter 可能是最好的方式，我的账号是 @ggiiaa（虽然名字有点怪）。我偶尔也会上 LinkedIn。我的邮箱是 gia@forgetthefunnel.com。如果有人有任何问题，随时给我发邮件。如果你想要节目笔记里没提到的模板，直接找我，没问题。还有 forgetthefunnel.com，我们有一个图书页面，那里有候补名单。我们会先做预售，实体书将在 2023 年初出版。我们要搞预售，因为想让大家尽早拿到书。

---

### [01:06:18] Lenny

**English:**
Love it. Gia, thank you for being here.

**中文翻译:**
太棒了。Gia，感谢你的到来。

---

### [01:06:21] Georgiana Laudi

**English:**
Thank you so much for having me.

**中文翻译:**
非常感谢邀请我。

---

### [01:06:24] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目再见。