# Gokul Rajaram - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Gokul Rajaram.

---

### [00:00:00] Lenny

**English:**
I sometimes wonder how someone like Gokul Rajaram can exist. He has an intense full-time job at DoorDash where he leads a significant part of the product in business. He also served as a board member at the Trade Desk, Coinbase and Pinterest, all public companies. He's also a prolific investor and seemingly on the cap table of every successful startup that I come across and at the same time, he's one of the most humble and nicest people you'll ever meet. If you look him up, you'll notice he always just calls himself a startup helper and I know that he makes a lot of time to mentor and help a lot of founders. We cover a lot of ground in our conversation, including picking where to work, how to do product development startups, structuring your product teams, hiring and angel investing. I hope that you enjoy our chat.

**中文翻译:**
我有时会纳闷像 Gokul Rajaram 这样的人是怎么存在的。他在 DoorDash 有一份高强度的全职工作，领导着产品和业务的重要部分。他还是 The Trade Desk、Coinbase 和 Pinterest 这三家上市公司的董事会成员。他也是一位多产的投资者，似乎出现在我遇到的每一家成功初创公司的股权结构表（cap table）里。与此同时，他还是你所能见到的最谦逊、最友善的人之一。如果你去查他的资料，你会发现他总是自称为“初创公司帮手”，而且我知道他花了很多时间去指导和帮助许多创始人。在我们的对话中，我们涵盖了广泛的话题，包括如何选择工作地点、初创公司如何进行产品开发、如何构建产品团队、招聘以及天使投资。希望你们喜欢我们的聊天。

---

### [00:00:47] Lenny

**English:**
This episode is brought to you by Amplitude. The number one product analytics solution. Amplitude helps product teams, growth teams, marketing and data teams build winning products faster and turn products into revenue. Amplitude has everything you need, including an integrated CDP, self-service analytics, and even an experimentation platform to help you better understand your users, drive conversions and increase engagement, growth and revenue. Amplitude is built for teams that want to learn as fast as they ship and ship as fast as they learn. Get your vanity metrics, rest your data, work smarter and grow your business. With over 1,700 customers like Atlassian, Instacart, and HBO, amplitude is helping companies build better products. Try Amplitude for free. Visit amplitude.com to get started.

**中文翻译:**
本期节目由 Amplitude 赞助。Amplitude 是排名第一的产品分析解决方案。它能帮助产品团队、增长团队、营销和数据团队更快地打造制胜产品，并将产品转化为收入。Amplitude 拥有你所需的一切，包括集成的 CDP（客户数据平台）、自助式分析，甚至还有一个实验平台，帮助你更好地了解用户、提高转化率并增加参与度、增长和收入。Amplitude 是为那些希望“交付多快，学习就有多快；学习多快，交付就有多快”的团队而设计的。告别虚荣指标，让数据发挥作用，更聪明地工作并发展你的业务。Amplitude 拥有超过 1,700 家客户，包括 Atlassian、Instacart 和 HBO，正在帮助这些公司打造更好的产品。免费试用 Amplitude，请访问 amplitude.com 开始体验。

---

### [00:01:35] Lenny

**English:**
This episode is brought to you by Flat File. Think the last time to imported a spreadsheet. Did it work the first time? Chances are it did not. You probably got some weird error and had to try a bunch of things like removing the blank title rows above your column headers or Googling, "How to save with UTF eight and coding." What even is UTF? Who cares? You're just trying to get your file where it needs to go so you can do your actual job. Your customers are running to the same issues when it matters most, right after signing up for your product. Enter Flat File. Flat File is the data onboarding platform, built to take the acute pain out of importing customer data into your product so they can see the magic that you promised them. Flat File is SOC Type one and two certified, GDPR compliant and even HIPAA compliant. Ensuring your customers, no matter where in the world they're located, are sharing their data securely in compliance every step of the way. No more emailing files back and forth. No more help articles that just don't land. Just clean data on day one. When it matters most. Get started importing millions of rows of customer data in minutes, at flatfile.com, slash, Lenny.

**中文翻译:**
本期节目由 Flat File 赞助。回想一下你上次导入电子表格的情景。第一次成功了吗？很可能没有。你可能遇到了某些奇怪的错误，不得不尝试一堆方法，比如删除列标题上方的空白行，或者去谷歌搜索“如何以 UTF-8 编码保存”。UTF 到底是什么？谁在乎呢？你只是想把文件传到该去的地方，好让你能开始干正事。你的客户在最关键的时刻——也就是刚注册你的产品后——也会遇到同样的问题。这就是 Flat File 大显身手的地方。Flat File 是一个数据入驻（data onboarding）平台，旨在消除将客户数据导入产品的剧烈痛苦，让他们能立刻看到你承诺的“奇迹”。Flat File 已通过 SOC Type 1 和 Type 2 认证，符合 GDPR 甚至 HIPAA 标准。确保你的客户无论身在何处，都能在每一步都安全、合规地共享数据。不再需要来回发送邮件附件，不再需要那些不知所云的帮助文档。在最关键的第一天，就能获得干净的数据。只需几分钟即可开始导入数百万行客户数据，请访问 flatfile.com/lenny。

---

### [00:02:46] Lenny

**English:**
Gokul, thank you so much for doing this. I know that you're an intensely busy human and I really appreciate you being here.

**中文翻译:**
Gokul，非常感谢你能参加。我知道你是一个极其忙碌的人，非常感谢你能抽空过来。

---

### [00:02:53] Gokul Rajaram

**English:**
Thank you Lenny. It's awesome to be here. Thanks for having me.

**中文翻译:**
谢谢你，Lenny。很高兴能来到这里。感谢你的邀请。

---

### [00:02:54] Lenny

**English:**
It's absolutely my pleasure. You're on the boards of Coinbase and Pinterest, you're a really big deal at DoorDash. You're even bigger deal at Caviar. You worked at Square, at Facebook, at Google. Plus you're an incredibly prolific investor. I'd probably put you in the top 1% of investors based on what I've seen. And so I'm just curious kind of just to set context, how did you get into tech and product originally? And then just what was your journey like to becoming this luminary of tech?

**中文翻译:**
这是我的荣幸。你是 Coinbase 和 Pinterest 的董事会成员，你在 DoorDash 举足轻重，在 Caviar 更是核心人物。你曾在 Square、Facebook 和 Google 工作过。此外，你还是一位极其多产的投资者。根据我的观察，我会把你排在投资者中前 1% 的位置。所以我很好奇，为了交代一下背景，你最初是如何进入科技和产品领域的？你成为科技界泰斗的历程又是怎样的？

---

### [00:03:24] Gokul Rajaram

**English:**
First of all, let's not start use the word luminary. I think it's people like Elon and Mark who are luminaries, I think. I've just been lucky to work at good companies and observe the creation and growth of these companies. I'll give you an interesting story. Crazily enough, I joined Google as a PM after I applied to Cisco. This was in 2003, and I wanted to be a hardcore networking product manager in the layer three, layer two of networking. I was like, layer seven software is for wimps. I'm going to go hardcore. Cisco had a... In 2001, 2002 right after the bust, the first dot com bust. Then Cisco actually rescinded my offer. They made me an offer, they rescinded it, and then basically that's how I ended up at Google. Was my second choice after Cisco. So literally you can see some of these decisions. You're just saved from yourself by [inaudible 00:04:08], and otherwise I would have been in networking, probably. Maybe still at Cisco. But at Google I got put on something called syndication, which is taking Google searches results and ads and then syndicating it to other properties like AOL back in the day, Yahoo, et cetera.

**中文翻译:**
首先，咱们别用“泰斗”这个词。我觉得像埃隆（马斯克）和马克（扎克伯格）那样的人才是泰斗。我只是运气好，能在优秀的公司工作，并观察这些公司的创建和成长。我给你讲个有趣的故事。说来也巧，我是在申请思科（Cisco）之后才加入 Google 担任产品经理（PM）的。那是 2003 年，当时我想成为一名硬核的网络产品经理，专注于网络协议的第二层和第三层。我觉得第七层应用软件是给弱者做的，我要做硬核的东西。思科在 2001、2002 年，也就是第一次互联网泡沫破裂后，撤回了给我的录用通知（offer）。他们先给了我 offer，然后又撤回了，基本上这就是我最终去 Google 的原因。Google 当时是思科之后的第二选择。所以你可以看到，有些决定纯粹是阴差阳错救了你，否则我可能现在还在做网络，甚至还在思科。但在 Google，我被分配到了一个叫“辛迪加”（syndication）的项目，就是把 Google 的搜索结果和广告分发到当时的 AOL、雅虎等其他平台上。

---

### [00:04:21] Gokul Rajaram

**English:**
And I was working on that product and at about 6:00 PM... We had offices then, back then at Google, 2002, 2003, people would go home and some people would stay back. I'd just walk around and a few doors from me, I basically found a group of engineers in an office and they were working on something. I was like, "What are you working on? They said, "Well," Serge Brin, the co-founder had given them a project of essentially reversing what Google had done with search. You type in a phrase, set of keywords and then Google identifies the webpages that are most relevant to the set of keywords. So we have an index that matches keywords and webpages, so why don't we extract those keywords for any given webpage and basically see if we can target ads based on that? So that seemed interesting. Google's AdWords product, which was such, ads had just started scaling up and I was like, "Hey, do you have any PMs working with you?" They said, no. "Can I be your PM?" They said, "Aren't you working on syndication?" I said, "Yeah, but I can do this nights and weekends." So I basically became a part-time PM for them and help them talk to customers, even did presentations with them. And while my full-time job was this other thing. And essentially within three months this thing grew big enough and fast enough and became a product that my boss saw this and she moved me over to full-time work on this, and that became Google AdSense.

**中文翻译:**
我当时在做那个产品，大约下午 6 点左右……那时候在 Google 还有办公室，2002、2003 年，人们会回家，有些人会留下来。我就到处走走，在离我几个门远的地方，我发现一间办公室里有一群工程师正在忙活。我问：“你们在做什么？”他们说，联合创始人谢尔盖·布林（Sergey Brin）给了他们一个项目，本质上是把 Google 的搜索逻辑反过来。搜索是输入关键词，Google 找相关网页；那为什么不从任何给定的网页中提取关键词，然后看看能不能基于此投放广告呢？这听起来很有趣。当时 Google 的 AdWords 产品（搜索广告）刚开始规模化，我问：“嘿，你们有 PM 合作吗？”他们说没有。我说：“我能当你们的 PM 吗？”他们问：“你不是在做辛迪加吗？”我说：“是啊，但我可以利用晚上和周末做这个。”于是我成了他们的兼职 PM，帮他们接触客户，甚至一起做演示。而我的全职工作还是另一件事。基本上在三个月内，这个项目发展得又大又快，变成了一个真正的产品，我的老板看到了这一点，就把我调去全职做这个，那就是后来的 Google AdSense。

---

### [00:05:57] Gokul Rajaram

**English:**
So a lesson for me I realized is that it's very important to do a core job really well at any company, but it's equally important to have curiosity and be open to serendipity. I think Zoom makes it harder, but it's very important to understand what else is going on at the company, what else people are working on, and just keep talking to people and build relationship with the company, because those are what will lead to the next set of opportunities. I think many opportunities don't come linearly just working in your job and making sure you get promoted. That's not how I think great careers are built. I think great careers are built by knowing a lot of people doing great work so they know and want you on their teams, and just waiting for serendipity and then seizing it and jumping. Another example is I had advised a company which was acquired by Square, and the fundraiser in Google. And Jack, the CEO of Square, asked the founder who was one of the best product people he knows. My name was mentioned. So then they reached out to me and I would never have really... I mean, informal advising. I didn't have any equity of something in the company. I just helped them out because they reached out to me because it was a former colleague and I said, "Sure, I'll help you out."

**中文翻译:**
所以我意识到一个教训：在任何公司，把核心工作做好非常重要，但保持好奇心并对“机缘巧合”（serendipity）保持开放态度也同样重要。我觉得 Zoom 办公让这变得更难了，但了解公司里还在发生什么、别人在做什么、不断与人交流并建立公司内部的人际关系是非常重要的，因为这些才是通往下一组机会的途径。我认为很多机会并不是通过线性地工作、确保获得晋升而来的。伟大的职业生涯不是那样建立的。我认为伟大的职业生涯是通过结识很多做着出色工作的人，让他们了解你并希望你加入他们的团队，然后等待机缘巧合，抓住它并纵身一跃。另一个例子是，我曾给一家公司做过顾问，后来那家公司被 Square 收购了。Square 的 CEO 杰克（多西）问那位创始人，他认识的最优秀的产品人是谁。我的名字被提到了。于是他们联系了我。我本来没想过……那只是非正式的咨询，我甚至没有那家公司的股份。我只是因为那是前同事联系我，我就说：“没问题，我帮你们。”

---

### [00:06:58] Gokul Rajaram

**English:**
And then that resulted in him saying good things about me and that led to the inbound from Square. So I think you got to prioritize this stuff. I mean you got to be careful it doesn't take up your life, but I think it's very important to be curious and open to serendipity. I realize in today's world there are lots of crazy serendipity things that happen. If you take inbounds from smart people and you just chat with them and you help them out. Paying it forward is the other thing, paying it forward. Lenny, you're a great example to this, you pay it forward so much. Your articles, stuff you write, good things happen in ways that you don't even realize. You build up a reservoir of goodwill that comes back to help you in different ways.

**中文翻译:**
结果就是他在杰克面前说了我的好话，从而引来了 Square 的主动邀约。所以我认为你必须优先考虑这些事情。我的意思是，你要小心别让它占据你的全部生活，但保持好奇和开放非常重要。我意识到在当今世界，有很多疯狂的巧合会发生，只要你接受聪明人的邀约，和他们聊天并提供帮助。另一件事就是“回馈”（paying it forward）。Lenny，你就是这方面的一个绝佳榜样，你付出了这么多。你的文章、你写的东西，好事会以你甚至意识不到的方式发生。你建立了一个善意的蓄水池，它会以不同的方式回来帮助你。

---

### [00:07:12] Lenny

**English:**
I love this advice. I don't know if you know this already, but I actually did a TEDx talk once about serendipity. It's called Losing Your Serendipity. It's out there on the internet, in case people want to-

**中文翻译:**
我非常喜欢这个建议。我不知道你是否已经知道了，我其实曾经做过一次关于“机缘巧合”的 TEDx 演讲，题目叫《失去你的机缘巧合》（Losing Your Serendipity）。网上能搜到，如果大家想看的话——

---

### [00:07:21] Gokul Rajaram

**English:**
I'm going to check it out. Wow.

**中文翻译:**
我一定要去看看。哇。

---

### [00:07:22] Lenny

**English:**
Long time ago. But I love, love that concept and it's such a good story. Just kind of pulling that thread a little bit, I'm curious, when you're looking for opportunities, would you suggest people focus on things they're excited about and passion that's pulling them in? Or more, I just think there's a big opportunity and maybe I'm not so excited about doing the work, but I'm just going to follow it because it may lead somewhere. Or some, right in the middle? How do you think about that?

**中文翻译:**
那是很久以前的事了。但我非常非常喜欢这个概念，这故事讲得太好了。顺着这个话题，我很好奇，当你在寻找机会时，你会建议人们专注于让他们感到兴奋、有热情吸引他们的事情吗？还是更多地考虑“我觉得这里有个大机会，也许我对具体工作没那么兴奋，但我会跟着它走，因为它可能会通向某个地方”？或者是折中一下？你怎么看？

---

### [00:07:46] Gokul Rajaram

**English:**
I think you got to think about the day to day. In many cases I feel people don't realize whether they're passionate about something or not until they actually start doing the work. I could never ever imagine that I could be passionate about payments ever in a million years, but the environment of the company Square was so infectious and great and the culture was so good that we even made working on payments... And you're serving these small businesses. I always think of, not what you're working on but what problem you're solving. In many cases, I get more energy from the problem I'm solving and who I'm solving it for and I realize that I get much more energy from personally solving problems that affected a small business or basically people or small business that I can relate to. It is harder for me to get energy solving problems of big enterprise and companies.

**中文翻译:**
我认为你必须考虑日常工作。在很多情况下，我觉得人们直到真正开始工作，才意识到自己是否对某件事有热情。我做梦也想不到我会对“支付”产生热情，但在 Square 的工作环境非常具有感染力，文化也非常好，以至于我们甚至让支付工作变得有趣……而且你是在为这些小企业服务。我总是想，不是你在做什么，而是你在解决什么问题。在很多情况下，我从解决的问题以及为谁解决问题中获得更多能量。我意识到，亲自解决那些影响小企业或我能产生共鸣的人的问题，会让我更有动力。解决大型企业和公司的问题对我来说更难获得能量。

---

### [00:08:28] Gokul Rajaram

**English:**
So I've always somehow ended up working at companies like DoorDash or Square or even Facebook, building ad product for small businesses, Google AdSense for small publishers. And so consumers for small businesses is what I've seen. And so I think it's important to know what kind of problems you get energy from and really think about the problem versus the customer segment. Maybe even more than the problem because I've saw different kinds of problems, but I realize that it's those kinds of customers I enjoy because you can meet them in the day to day. You can see them on the street or you read their articles. A small blogger for example, I remember I used to go to a lot of blog conferences when I was a PM for AdSense. It was great to meet these bloggers. They would be hundreds of thousands of them back then.

**中文翻译:**
所以不知何故，我最终总是在像 DoorDash、Square 甚至 Facebook 这样的公司工作，为小企业开发广告产品，为小出版商开发 Google AdSense。我所见证的是为小企业服务的消费者端产品。因此，我认为重要的是了解哪种类型的问题能给你带来能量，并认真思考问题本身与客户群体的关系。甚至客户群体比问题更重要，因为我解决过各种问题，但我意识到我喜欢的是那类客户，因为你在日常生活中能遇到他们。你能在街上看到他们，或者读到他们的文章。比如一个小博主，我记得当我是 AdSense 的 PM 时，经常去参加博客大会。见到这些博主感觉太棒了，当时有成千上万的博主。

---

### [00:09:10] Gokul Rajaram

**English:**
It's probably different, Medium and so on, now, Substack, but back then it was blogger. I think the word doesn't even exist today, but it's amazing to meet them and they literally... Till today I have people emailing me, "Gokul, I know you right? We used to make a hundred thousand dollars a year based on purely AdSense, and that was our living and that's how we built this other company on that." So big companies, you don't ever get to hear something like that. So I got energy from things like that. The other one is founder. I think, Lenny, it's very important if you think... Talking about company, is to have a founder, when you talk to them, you don't get the sense that they're in it for the money. I think it's very important for founders to really live and breathe the mission themselves in an authentic way.

**中文翻译:**
现在可能是 Medium 或 Substack 之类的，但那时就是“博主”（blogger）。我觉得这个词在今天甚至都不怎么用了，但见到他们真的很神奇，他们真的……直到今天还有人给我发邮件说：“Gokul，我认识你，对吧？我们以前纯靠 AdSense 每年能赚 10 万美元，那是我们的生活来源，我们就是靠那个建立了另一家公司。”在服务大公司的过程中，你永远听不到这样的故事。所以我从这些事情中获得能量。另一个因素是创始人。Lenny，我觉得谈到公司时，非常重要的一点是，当你和创始人交谈时，你不会觉得他们是为了钱才做这件事。我认为创始人能够以一种真实的方式亲自践行使命是非常重要的。

---

### [00:09:48] Gokul Rajaram

**English:**
And if people are smart, and I think you've got to really honestly think if this person is constantly talking about revenue and trying to convince you that you're going to get wealthy or they're going to get... Whatever the case is, that's not the kind of founder that's going build a really large company. And so if you look at everyone, whether it's... You've worked with Brian Chesky, I'm sure he embodies that. Jack at Square, Tony at DoorDash, Larry at Google, all of these folks embody that mission. Mark at Facebook. That they care about winning. They will win and money will come, but it's a side product. It's not the main thing they're aiming for.

**中文翻译:**
如果人们足够聪明，我认为你必须诚实地思考：如果这个人一直在谈论收入，试图说服你你会变得富有，或者他们会变得……无论情况如何，那都不是那种能建立真正伟大公司的创始人。如果你看看那些人，无论是……你和 Brian Chesky（Airbnb 创始人）合作过，我确信他体现了这一点。Square 的杰克、DoorDash 的 Tony、Google 的拉里，所有这些人都在践行那个使命。Facebook 的马克也是。他们关心的是赢。他们会赢，钱自然会随之而来，但那是副产品，不是他们的主要目标。

---

### [00:10:18] Lenny

**English:**
That's a good segue. A question I wanted to talk about is when someone's looking for a company to join, knowing that you've worked at a lot of really successful companies, what else should people look for when they're trying to decide where to go? So what we've talked about so far is, a founder that really wants to win and is really driven, and then a problem that you want to solve? Is there anything else?

**中文翻译:**
这是一个很好的过渡。我想讨论的一个问题是，当有人在寻找要加入的公司时，考虑到你曾在许多非常成功的公司工作过，人们在决定去向时还应该看重什么？到目前为止我们谈到了：一个真正想赢且非常有动力的创始人，以及一个你想解决的问题。还有别的吗？

---

### [00:10:35] Gokul Rajaram

**English:**
I think those are the two things. One thing to look at, I would say, is that it is important to see if this company can become the number one player in its segment. I'll give you an example. I convinced someone who's going to take a very senior role, let's just say a tier two or tier three e-commerce company, to become a, not... So, basically take one step down at different company, which is at Coinbase, basically. I sat on the board of Coinbase, and I think that person still thanks me because I think they were focused too much on the title, that they were going to be the super senior person at this company on the management team, et cetera. But I said, "Ultimately you don't realize this, but the value of working at a leader in any space, the quality of talent you work with, the brand, the network effect, so many things accrue to you. I would much rather be the number two or number three person."

**中文翻译:**
我觉得主要是这两点。还有一点我想说的是，观察这家公司是否能成为其细分领域的头号玩家非常重要。我给你举个例子。我曾说服一个原本要去一家二三线电商公司担任非常高级职位的人，去另一家公司降一级录用，那家公司就是 Coinbase。我是 Coinbase 的董事，我想那个人至今还在感谢我，因为我觉得他们当时太关注头衔了，觉得自己在原来那家公司能进管理层，是超级资深人士等等。但我说：“最终你没意识到，在任何领域的领头羊公司工作的价值——你共事的优秀人才、品牌效应、网络效应，这么多东西都会累积到你身上。我宁愿在领头羊公司做二号或三号人物。”

---

### [00:11:25] Gokul Rajaram

**English:**
If you think of it that way, and the leader in a space, than the top person. Say Google versus Yahoo. I saw even if you're the VP of product at Yahoo or the head of product at Yahoo versus a ICPM at Google, you probably want to be the ICPM at Google. I bet you all day long, all day long. Yahoo is a great company, but Google is just a different caliber and different class. So I think it's very important to try to work at, obviously you don't know who the winner is, but if you think that's that something is a winner in a space, in large space, so many benefits that recruit from working at winners. You get unfair brand halo because you worked at a winner. People attribute a lot of the... "Oh yeah, you worked at a winner. Hence, you must be a winner." Probably not the case, but you can... I'll take it.

**中文翻译:**
如果你这样想，在某个领域的领头羊公司工作，比在普通公司当老大要好。比如 Google 对比雅虎。我看到过，即使你是雅虎的产品副总裁或产品负责人，对比 Google 的一名普通产品经理（ICPM），你可能还是想去 Google 当 PM。我敢打赌，绝对是这样。雅虎是一家伟大的公司，但 Google 是完全不同的量级和层次。所以我觉得非常重要的一点是，虽然你显然无法预知谁是最终赢家，但如果你认为某家公司在某个大领域有胜算，那么在赢家公司工作会带来很多好处。你会获得一种“不公平”的品牌光环，因为你在赢家公司待过。人们会把很多功劳归于你：“噢，你在那家成功的公司待过，那你一定也很厉害。”事实可能并非如此，但没关系，这种光环我收下了。

---

### [00:12:07] Lenny

**English:**
So along those lines and kind of touching on your investor experience, what should folks look for to think about, is this going to be a winner? Or should they maybe join when it's like a series B, series C when it's kind of clear that it's doing well? Do you have any thoughts? Maybe for either a new person joining the workforce, maybe PM, let's say, or even later?

**中文翻译:**
顺着这个思路，结合你的投资经验，人们应该看重什么来判断“这是否会成为赢家”？或者他们是否应该在 B 轮或 C 轮，也就是表现已经比较明朗的时候加入？你有什么建议吗？无论是对于刚进入职场的新人（比如 PM），还是对于资深人士？

---

### [00:12:25] Gokul Rajaram

**English:**
Personally, I feel like Hunter Walk wrote a very good post on it. He said that people who are joining the workforce new should generally join mid-stage companies because mid-stage companies you get some mentorship and it's not just basically whatever needs to be done and ultimately you don't build any deep skills. So mid-stage company I would define as something that is a multi hundred person company, but not maybe a thousand person company. Somewhere from 300 to 500 people that has not just reached product market fit, but product market, channel fit. And the first product ideally is, the current product is on the way to becoming almost bulletproof. It's going to be a very, very strong product. And then it's really a path to becoming a platform beyond a product, where the company's thinking about, "How do I become a platform?" They have multiple products that serve the same customer, different problems, and they all complement and interlock with each other.

**中文翻译:**
就我个人而言，我觉得 Hunter Walk 写过一篇非常好的文章。他说职场新人通常应该加入中等规模的公司，因为在中等规模的公司你能得到一些指导，而不仅仅是哪里需要补哪里，最终却没建立起任何深度技能。我将中等规模公司定义为几百人的公司，但可能还不到一千人。大约 300 到 500 人，不仅达到了产品市场契合点（Product-Market Fit），还达到了产品-市场-渠道契合点（Product-Market-Channel Fit）。理想情况下，它的第一个产品，也就是当前产品，正趋于完美。它会是一个非常强大的产品。然后，它正处于从单一产品向平台转型的路径上，公司正在思考“我如何成为一个平台？”他们有多个产品服务于同一客户的不同问题，并且这些产品相互补充、环环相扣。

---

### [00:13:12] Gokul Rajaram

**English:**
So because, looking back on a career, always without really thinking about it, as employee number six, seven or 800 at Google, employee number, few hundreds at Facebook, employee number seven, 800 at Square. DoorDash was slightly later because just through an acquisition. So it was like I think 1,500 or something like all around. But DoorDash also, I think, yeah, but I think that's basically, at least for me, has worked. And this is even when I was not a newbie, as I was in my career. So it's really a good spot I feel if you're joining a company. For many reasons.

**中文翻译:**
因为回首我的职业生涯，总是在不经意间，我成了 Google 的第 600、700 或 800 号员工，Facebook 的几百号员工，Square 的第 700、800 号员工。DoorDash 稍微晚一点，因为是通过收购加入的，当时大约有 1,500 人左右。但 DoorDash 也是……我觉得，至少对我来说，这个阶段非常有效。即使在我已经不是职场新人的时候也是如此。所以我觉得如果你要加入一家公司，那是一个非常好的切入点。原因有很多。

---

### [00:13:43] Lenny

**English:**
And this advice is for, you're saying new people but also maybe people further along in their career?

**中文翻译:**
你说的这个建议是针对新人的，但也适用于职业生涯后期的人吗？

---

### [00:13:48] Gokul Rajaram

**English:**
I think unless you know the founders very, very, very well, joining a very early stage company is, especially now for the next one or two years, it's going to be a brutal market out there. So you've got to be really careful. There's going to be the days of raising around, few weeks after raising your prior round, of couple of months without much movement, without much company progress have... Are probably gone for most companies. And we all have seen now companies that have raised round at crazy valuations, deflate or die quickly. And so that's happened very quickly. You might just join and your company could die a week from now. So I think the other one is to really look at the financials and really understand that better.

**中文翻译:**
我认为除非你非常非常了解创始人，否则加入一家处于极早期阶段的公司，尤其是在未来一两年，市场会非常残酷。所以你必须非常小心。那种刚融完一轮几周后又融一轮，或者几个月没进展也能融资的日子，对大多数公司来说可能已经结束了。我们都看到过那些以疯狂估值融资的公司迅速缩水或倒闭。这种情况发生得非常快。你可能刚加入，公司一周后就倒闭了。所以我觉得另一点是要认真查看财务状况，并更好地理解它。

---

### [00:14:29] Lenny

**English:**
Awesome. That's really helpful advice. You mentioned Brian Armstrong, Brian Chesky and some of the other folks that you have worked with and gotten to know. I'm curious, of the companies you've worked at, say now Coinbase, on the board, Google, Facebook, Square, DoorDash, what are some things that have kind of stuck with you? Things you've taken away about how to run a company, build a product? Or anything else that's just taught you a lesson about how to do what you're doing?

**中文翻译:**
太棒了，非常有用的建议。你提到了 Brian Armstrong、Brian Chesky 以及其他一些你共事过或结识的人。我很好奇，在你工作过的这些公司中——比如现在的 Coinbase（董事会）、Google、Facebook、Square、DoorDash——有哪些东西让你印象深刻？关于如何运营公司、打造产品，你学到了什么？或者还有什么其他事情教给你关于如何做好现在工作的教训？

---

### [00:14:54] Gokul Rajaram

**English:**
One of the most interesting things I've realized is there are multiple paths to greatness. What I mean by that is if I were to look at one word to describe each of the companies I have actually worked at. Google would be technical. It is very, very technical, technology focused, because Google believe, if you build great technology, they will come. Facebook was very growth focused. Very much, here's a goal, we want to hit 1 billion MAUs, let's work backwards from there. Square was very design focused. Let's build the cleanest minimalistic design, the most well designed product, then good things happen. DoorDash by nature is more operational, probably the right word to use where product and operational intertwined. Uber probably is the same word. So I think there are multiple paths to greatness, but I think the founder and market fit in terms of even the type of company that's needed is very strong.

**中文翻译:**
我意识到的最有趣的事情之一是，通往伟大的道路不止一条。我的意思是，如果我用一个词来描述我工作过的每家公司：Google 是“技术导向”（technical）。它非常非常注重技术，因为 Google 相信，如果你开发出伟大的技术，用户自然会来。Facebook 是“增长导向”（growth focused）。非常明确，比如目标是达到 10 亿月活（MAU），然后倒推工作。Square 是“设计导向”（design focused）。让我们打造最简洁、最极简的设计，最精良的产品，然后好事就会发生。DoorDash 本质上更偏向“运营导向”（operational），这可能是最准确的词，产品和运营交织在一起。Uber 可能也是如此。所以我认为通往伟大的路径有很多，但创始人与市场在“需要什么样的公司”这一层面的契合度非常强。

---

### [00:15:46] Gokul Rajaram

**English:**
In other words, I think founders have to be authentic to themselves. The other thing I saw is that each founder, whether it's Tony Shoe at DoorDash or Jack, they all had their distinctive styles but they didn't try to change their style. In some ways the company was built almost in their image in some ways and that was fine. I think if you try to build a company that's inauthentic to who you are as a founder, that's not going to work. So ultimately you want to... If Jack tried to build a company that sold enterprise software, I don't think that would've worked. That's not who he is. And so you want a founder and a company culture that are essentially synonymous and founders to be authentic. And I think finally the one other thing that I've seen is, the product itself ideally needs to have some remarkability.

**中文翻译:**
换句话说，我认为创始人必须对自己真实。我看到的另一件事是，每位创始人，无论是 DoorDash 的 Tony Xu 还是杰克，他们都有自己独特的风格，但他们并没有试图改变自己的风格。在某种程度上，公司几乎是按照他们的形象建立的，这没问题。我认为如果你试图建立一家与你作为创始人的本性不符的公司，那是行不通的。所以最终你希望……如果杰克试图建立一家销售企业软件的公司，我不认为那会成功，那不是他的风格。所以你需要创始人和公司文化在本质上是同义词，创始人要真实。最后，我看到的另一件事是，产品本身理想情况下需要具备某种“卓越性”（remarkability）。

---

### [00:16:33] Gokul Rajaram

**English:**
What I mean by that is, it needs to be better than anything else that solves that pain point along a few dimensions that really matter, even if it's worse along other dimensions. So I think every great product, it needs to have a lot of word of mouth. I think especially nowadays, I'm seeing a lot of consumer companies challenged because they relied on Facebook or paid media to drive customer acquisition, and bunch of young companies are coming to me saying, "What do we do now?" I'm like, "Look, the biggest thing you did wrong initially was you didn't pay enough attention to organic growth. Basically, was this product compelling enough that people talk about it and bring other people along? And you completely relied on paid and that's coming back to bite you." So a good metric is that 40 to 50% of your new customers should ideally come from organic channels and 50% from paid. If 90% come from paid, that means at some point that the music is going to stop.

**中文翻译:**
我的意思是，它需要在解决该痛点的几个关键维度上比其他任何东西都好，即使在其他维度上可能稍逊一筹。所以我认为每个伟大的产品都需要大量的口碑。特别是在今天，我看到很多消费类公司面临挑战，因为他们依赖 Facebook 或付费媒体来获取客户。一群年轻公司跑来问我：“我们现在该怎么办？”我说：“看，你们最初犯的最大错误就是没有给予有机增长（organic growth）足够的关注。本质上，这个产品是否足够吸引人，让人们愿意谈论它并带其他人来？你们完全依赖付费渠道，现在这开始反噬你们了。”一个好的指标是，理想情况下 40% 到 50% 的新客户应该来自有机渠道，50% 来自付费渠道。如果 90% 都来自付费，那意味着音乐总有停止的一天。

---

### [00:17:27] Lenny

**English:**
Unless you've got some magical insight or someone that's just killing it.

**中文翻译:**
除非你有什么神奇的洞察，或者有人在那方面做得特别出色。

---

### [00:17:31] Gokul Rajaram

**English:**
A growth pack, right? Everyone's looking at this growth tag, but there is no... There's nothing like the silver growth tag bullet.

**中文翻译:**
增长黑客（growth pack）对吧？每个人都在寻找增长标签，但其实没有什么所谓的“增长银弹”。

---

### [00:17:37] Lenny

**English:**
It's interesting, there are a couple companies I'm an investor in that are actually still working really well through paid. And so it's definitely possible but incredibly hard.

**中文翻译:**
很有趣，我投资的几家公司实际上在付费渠道上仍然表现得非常好。所以这绝对是可能的，但极其困难。

---

### [00:17:45] Gokul Rajaram

**English:**
Yeah, those are exceptions that prove the rule.

**中文翻译:**
是的，那些是证明规律的例外。

---

### [00:17:48] Lenny

**English:**
What I think of when you talk about this is that something Seth Godin shared a while ago that I always come back to you, this idea that your product has to be remarkable where people want to remark on it, for it to have a chance, especially in consumer, because that's how things start to grow. People just can't help but talk about it.

**中文翻译:**
当你谈到这个时，我想到了 Seth Godin 很久以前分享过的一些观点，我经常会想起：你的产品必须是“卓越的”（remarkable），以至于人们想要去“评论”（remark）它，这样它才有机会，尤其是在消费领域，因为这就是增长的开始。人们就是忍不住要谈论它。

---

### [00:18:04] Gokul Rajaram

**English:**
Exactly. Very well said.

**中文翻译:**
没错，说得太好了。

---

### [00:18:06] Lenny

**English:**
Easier said than done. Okay, so getting a little tactical. I'm curious to get your take on just the product development process at companies. How do you think about founders setting up a product development process? What do you recommend usually? And then maybe further down the line, when they get to like 25 people, maybe 50 people, how do you advise founders think about their product development process in the early stages and then as they evolve?

**中文翻译:**
说起来容易做起来难。好，我们来谈谈战术。我很想听听你对公司产品开发流程的看法。你认为创始人应该如何建立产品开发流程？你通常推荐什么？然后随着公司的发展，当他们达到 25 人，甚至 50 人时，你如何建议创始人在早期阶段以及随后的演变中思考他们的产品开发流程？

---

### [00:18:30] Gokul Rajaram

**English:**
I think first of all, the planning period is different at the very early stage. At the very early stage, it needs to be a weekly plan, where while as you grow the granularity, you still need weekly plans, but you also need quarterly plans that wrap around that. You start with quarterly goals. In fact, I was talking to a series A company and they were just starting the first several quarterly plan. They just did series A round, so they need to plan at a quarterly level and then it translates back into the weekly level. When you're very young, you're literally going week to week. And then once you become much bigger, you get to annual planning, which then leads to quarterly goals and so on. So the granularity is different. The second thing is the tools you actually use. I think initially you just have a very simple spreadsheet.

**中文翻译:**
我认为首先，极早期阶段的规划周期是不同的。在极早期，它需要是一个周计划。随着规模的扩大，虽然你仍然需要周计划，但你还需要围绕它的季度计划。你要从季度目标开始。事实上，我正在和一家 A 轮公司交谈，他们刚刚开始制定前几个季度计划。他们刚完成 A 轮融资，所以需要进行季度层面的规划，然后再转化为周层面的工作。当你非常年轻时，你真的是一周一周地过。一旦你变得大得多，你就会进入年度规划，然后产生季度目标，依此类推。所以粒度是不同的。第二件事是你实际使用的工具。我认为最初你只需要一个非常简单的电子表格。

---

### [00:19:13] Gokul Rajaram

**English:**
I am a big believer that you can have all these fancy project management tools. Whenever I've been a leader in a product team, I've never imposed a certain tool because I feel different PMs and teams find the right tool for them. It's about keeping it super simple. If you have too many complex tools, people don't know how to use them. Engineering teams typically use something like Jira, and as a product person you don't want another complex tool for them to use to figure out things. So a simple spreadsheet, and your founder that you update with things to do and people who are going to do it. And then that's basically it. I think as you grow, you start wanting to write a little bit more surviving, the first thing you start doing. And then as a very young company, you don't have a separate product strategy from a company strategy.

**中文翻译:**
我坚信你可以拥有所有这些花哨的项目管理工具。每当我担任产品团队的领导者时，我从不强加某种工具，因为我觉得不同的 PM 和团队会找到适合他们的工具。关键在于保持超级简单。如果你有太多复杂的工具，人们就不知道该怎么用。工程团队通常使用 Jira 之类的工具，作为产品人员，你不想再给他们增加一个复杂的工具来搞清楚事情。所以，一个简单的电子表格，以及你向创始人更新的待办事项和执行人，基本上就够了。我认为随着你的成长，你开始想要写更多的东西来维持运营，这是你开始做的第一件事。作为一个非常年轻的公司，你没有独立于公司战略的产品战略。

---

### [00:19:55] Gokul Rajaram

**English:**
The product and company strategy are the same. As you start growing, you have a go-to market strategy, product strategy, et cetera, et cetera. So you start more clearly separating out the company strategy from the product strategy. The first thing you start seeing is when a product manager joins... So I think of course what happens is that the 25 person status, you have a PM who sometimes joins the company. I think the right time for PMs to join the company is about eight to 10 engineers or so. Anywhere between five and 10. But 10 engineers is... Unless the founder themselves wants to be the PM, but that's when you start seeing a professional PM join and the PM typically wants to clearly articulate. Good PMs want to articulate what the product strategy is based on company strategy. So you start seeing the emergence of a separate product strategy doc that is written at the 20, 23 person stage, and the product strategy then makes choices. What customers are we serving? More clearly articulates what have been implicit hopefully earlier.

**中文翻译:**
产品战略和公司战略是一回事。随着你开始成长，你会有进入市场（GTM）战略、产品战略等等。于是你开始更清晰地将公司战略与产品战略分开。你首先会看到的是当一名产品经理加入时……我认为在 25 人的阶段，有时会有 PM 加入公司。我认为 PM 加入公司的合适时机是大约有 8 到 10 名工程师的时候。5 到 10 名之间都可以。但 10 名工程师是一个……除非创始人自己想当 PM，否则那时候你就开始看到专业的 PM 加入了。PM 通常希望清晰地表达。优秀的 PM 会根据公司战略来阐述产品战略。所以你会看到在 20 到 23 人的阶段出现一份独立的产品战略文档，产品战略随后会做出选择：我们要服务哪些客户？更清晰地表达出之前可能只是隐含的东西。

---

### [00:20:51] Gokul Rajaram

**English:**
And then that guides product development. And then I think when you get really large, you have essentially multiple interlocking products that there are multiple product strategy docs. And then you get into more cross functional strategy docs, into product strategy doc, et cetera. But I think at the very core of it, there are two things. One, the team still needs to meet on a daily basis. There is a standup cadence, and that atomic team of six, seven people, which is engineers, product person, designer, hopefully an analyst, they are the product development team. And they still review the tasks on a weekly basis, but where it emanates from when you're young, it doesn't have any roots. It's literally, they're just living and dying on a week by week basis, trying different things till they get product market fit.

**中文翻译:**
然后这会指导产品开发。我认为当你变得非常庞大时，你本质上拥有多个连锁产品，会有多份产品战略文档。然后你会进入更多的跨职能战略文档、产品战略文档等等。但我认为最核心的有两点：第一，团队仍然需要每天开会，有一个每日站会（standup）的节奏；那个由 6、7 个人组成的原子团队——包括工程师、产品人员、设计师，希望还有分析师——他们就是产品开发团队。他们仍然每周审查任务，但在你年轻的时候，这些任务是没有根基的。字面意思上，他们只是在一周又一周地挣扎求生，尝试不同的东西，直到找到产品市场契合点。

---

### [00:21:38] Gokul Rajaram

**English:**
As you go bigger and you have product market fit, you start building plans around that. And these iterations, these sprints then emanate working back from the goals that you set on a quarterly basis.

**中文翻译:**
随着你规模变大并找到了产品市场契合点，你开始围绕它制定计划。这些迭代、这些冲刺（sprints）随后会根据你设定的季度目标倒推出来。

---

### [00:21:49] Lenny

**English:**
Wow. So much good advice. There's a couple things I want to follow up on there. What are some common pitfalls you've seen in startups trying to set up product development processes or the way they build product? What do you find are some of the more common mistakes that founders make? That early teams make?

**中文翻译:**
哇，这么多好的建议。我想跟进几个问题。你看到初创公司在尝试建立产品开发流程或产品构建方式时，有哪些常见的陷阱？你发现创始人或早期团队最常犯的错误有哪些？

---

### [00:22:04] Gokul Rajaram

**English:**
The biggest one I think is, the founder becomes too tactical and disempowers their team. I think the founder thinks they know what customers want. I think they don't empower their teams enough and they basically just tell the engineers what to build. And I think that leads to teams that are basically tactically just shaping feature after feature without truly solving problems. And I think that then creeps into when you hire a PM, they see this is how the company's working and they then also start working the same way. I think the best founders early on trust their engineering teams and product development teams to solve problems and more clearly present a problem to them and help them. And this is true for PMs also. They help them brainstorm solutions and try to work with the team to understand why we chose a certain solution versus another solution. And then the team feels empowered to go build it versus it dictating them.

**中文翻译:**
我认为最大的一个是，创始人变得过于关注战术，从而剥夺了团队的权力。创始人认为他们知道客户想要什么，没有给团队足够的授权，基本上只是告诉工程师要造什么。我认为这会导致团队只是在战术上一个接一个地堆砌功能，而没有真正解决问题。当你雇佣 PM 时，这种风气会蔓延，他们看到公司是这样运作的，于是也开始以同样的方式工作。我认为最好的创始人早期会信任他们的工程团队和产品开发团队去解决问题，更清晰地向他们展示问题并提供帮助。对 PM 来说也是如此。他们帮助团队集思广益，并尝试与团队合作，理解为什么我们选择某个方案而不是另一个。这样团队会感到被授权去构建，而不是被动接受指令。

---

### [00:23:00] Gokul Rajaram

**English:**
Why should we build an iOS app, while the actual problem to solve is we want to increase the percentage of people using a service to five times a week versus two times a week. And building an iOS app is one tactic, but there are many other tactics. Which is improving our web experience, et cetera. So decision making and transparency of decisions around how products change customer behavior is probably the... And that leads to the culture of what is called a feature factory, where product teams basically are very proud of shaping feature after feature without truly knowing how much impact the feature has. If a feature is shipped, but it doesn't change customer behavior at all, is it really a feature or no? It's like a tree falling in the forest.

**中文翻译:**
为什么要开发 iOS 应用？而实际要解决的问题是，我们想把用户使用服务的频率从每周两次提高到五次。开发 iOS 应用只是一种战术，还有很多其他战术，比如改进我们的网页体验等等。因此，围绕产品如何改变客户行为的决策制定和决策透明度可能是……这会导致所谓的“功能工厂”（feature factory）文化，产品团队基本上以一个接一个地发布功能为荣，却并不真正了解该功能产生了多大影响。如果一个功能发布了，但根本没有改变客户行为，那它真的算是一个功能吗？这就像森林里倒下的一棵树（如果没有人听到，它发出了声音吗？）。

---

### [00:23:41] Lenny

**English:**
Oh my god, I love that. And I've definitely seen these teams that you're talking about and that only becomes worse once they hire a PM. I like your rule of thumb of hiring a PM when you've gotten eight to 10 engineers. What points to it's time to hire a PM, other than that? Is there other things you've seen of just like, "Oh my god, this team really needs a PM," or they should wait longer? What have you seen there?

**中文翻译:**
天哪，我太喜欢这个比喻了。我确实见过你说的这种团队，而且一旦他们雇了 PM，情况只会变得更糟。我喜欢你说的“当你有 8 到 10 名工程师时雇佣 PM”的经验法则。除此之外，还有什么迹象表明该雇 PM 了？你有没有见过那种“天哪，这团队真的需要个 PM”的情况，或者他们应该等更久？你都见过些什么？

---

### [00:24:04] Gokul Rajaram

**English:**
I always feel that you should hire to solve a problem you're facing. You should never hire... Or you feel you're going to face. But especially I think just over-hiring, especially... You want to be efficient and smaller teams are always good. Smaller companies are always good, part of the problem. So there are many teams. First of all, the question is if the founder is able to play the role, someone needs to play the role of a product manager. If the founder is able to and willing to play the role of product manager. The problem is with eight to 10 engineers, if the founder is doing other things besides playing the role of a product manager, then the eight to 10 person engineering team is not being cared for and fed.

**中文翻译:**
我总觉得你应该为了解决当前面临的问题而招聘。你永远不应该为了招聘而招聘……或者为了你觉得将来会面临的问题而招聘。但我认为过度招聘，尤其是……你希望保持高效，小团队总是好的。小公司总是好的，这是问题的一部分。所以有很多团队。首先，问题是创始人是否能够扮演这个角色，必须有人来扮演产品经理的角色。如果创始人能够且愿意扮演 PM。问题在于，当有 8 到 10 名工程师时，如果创始人除了扮演 PM 还在做其他事情，那么这 8 到 10 人的工程团队就没有得到应有的关注和支持。

---

### [00:24:39] Gokul Rajaram

**English:**
Engineers are by far the most expensive resources in the company. By far, right? I mean if you look at the composition of engineers versus... And PMs versus any other function, it's two to three, equity, cash, everything. And if you think of it that way, then if you're not caring and feeding and not leveraging this amazing most expensive resource, well, that's a crime. That's a crime. In some ways you got to think about yourself. Am I, as the founder, is this 10 person team or 8 person team being leveraged? Are they solving the right problems? Do they know how to brainstorm? Do they know how to solve problems? Do I have the bandwidth to sit with them and present the right problems, talk to customers, figure out the right sequencing, the right prioritization of problems to work on, et cetera?

**中文翻译:**
工程师到目前为止是公司里最昂贵的资源。绝对是，对吧？我是说如果你看看工程师与 PM 以及其他职能部门的构成比例，无论是股权、现金还是其他，都是两三倍。如果你这样想，如果你不关心、不支持、不利用好这一惊人的、最昂贵的资源，那就是一种犯罪。在某种程度上，你必须反思自己：作为创始人，这 10 人或 8 人的团队被充分利用了吗？他们在解决正确的问题吗？他们知道如何集思广益吗？他们知道如何解决问题吗？我有精力坐下来和他们一起讨论，提出正确的问题，与客户交谈，弄清楚正确的顺序，以及要解决的问题的优先级吗？

---

### [00:25:25] Gokul Rajaram

**English:**
And if you're not able to do that, you've got to have someone who can do that full time. And it might be someone from the team. I mean there are two... We can talk about how to hire your first PM and there are many, many-

**中文翻译:**
如果你做不到这些，你就必须找一个能全职做这些事的人。那个人可能是团队内部的。我是说有两种……我们可以谈谈如何雇佣你的第一个 PM，这里面有很多——

---

### [00:25:36] Lenny

**English:**
Yeah, let's do it. I definitely wanted to ask that. I know you wrote a great post about this, just how to actually hire your great PM and you have a strong opinion about that.

**中文翻译:**
好啊，咱们聊聊这个。我正想问呢。我知道你写过一篇关于这个的很棒的文章，关于如何真正雇到优秀的 PM，而且你对此有很强烈的观点。

---

### [00:25:43] Gokul Rajaram

**English:**
Yeah, I have a strong opinion and it might be just based on every single company I've been at. The first PM at every company has been someone who's either been an analyst or an engineer or a designer who's worked there already and they just move from their role to being a PM. Why? Because many cases, the role of the PM is actually to be the liaison between the founder, founders and the engineering team. And so it needs to be someone that the founders trust and the engineering team trusts and also they know how the founders and the engineering team work.

**中文翻译:**
是的，我确实有很强烈的观点，这可能是基于我待过的每一家公司。每家公司的第一个 PM 都是已经在那里工作的分析师、工程师或设计师，他们只是从原来的角色转岗成了 PM。为什么？因为在很多情况下，PM 的角色实际上是创始人与工程团队之间的联络人。所以它需要是一个创始人信任、工程团队也信任的人，而且他们了解创始人和工程团队是如何工作的。

---

### [00:26:16] Gokul Rajaram

**English:**
And many times if you bring a PM from the outside with a completely different process, many times the organ can be rejected by the body. And so they may not be the best PM you could get in terms of just functional skills, but they would be the best PM from a cultural assimilation. And getting the engineers just to understand the value of a PM and getting the founders to be comfortable, slowly being more hands off. Was it true of Airbnb, also? Was Joe not the first PM?

**中文翻译:**
很多时候，如果你从外部引入一个带着完全不同流程的 PM，往往会产生“排异反应”。所以从纯职能技能的角度来看，他们可能不是你能找到的最强 PM，但从文化融合的角度来看，他们是最好的 PM。这能让工程师理解 PM 的价值，也能让创始人感到安心，从而慢慢放手。Airbnb 是不是也是这样？Joe（Airbnb 联合创始人）不是第一个 PM 吗？

---

### [00:26:46] Lenny

**English:**
He was. And he was actually an engineer when he joined, so that's exactly how you describe. So say that you hire, or you transition someone from PM into their... Being the first PM. What are some signs that maybe they're not doing too well and things aren't going well and maybe you should go in a different direction?

**中文翻译:**
他是。他加入时其实是一名工程师，所以正如你所描述的那样。那么，假设你雇佣了或者把某人转岗成了第一个 PM。有哪些迹象表明他们可能做得不太好，事情进展不顺，也许你应该换个方向？

---

### [00:27:03] Gokul Rajaram

**English:**
I think the biggest one is I always feel with PMs it's actually two or three things you can look at. One is, you can actually just ask the engineers themselves. Engineers are fairly blunt. And when I manage PMs, I've seen that they always tell me... Engineering managers in particular, they're very, very quick to tell you, "Look, this person is not working, they're not being effective." What value are they adding? And I think just number one thing you have to do is you have to, just because you hire a PM doesn't... You can't abdicate that responsibility of understanding how the team is doing. It's not gone. You've got to talk to the engineers and designers constantly to see, is the product manager adding value? Second, if you see the PM, the newly anointed PM still get too much into the how to build the product, which is really the domain of the engineers and designers.

**中文翻译:**
我认为最重要的一点是，对于 PM，你实际上可以看两三件事。第一，你可以直接问工程师。工程师通常很直率。当我管理 PM 时，我发现他们总是会告诉我……尤其是工程经理，他们会非常快地告诉你：“看，这个人不行，他们没有效率。”他们增加了什么价值？我认为你必须做的第一件事是，不能因为雇了 PM 就放弃了解团队状况的责任。责任还在。你必须不断与工程师和设计师交流，看看产品经理是否增加了价值。第二，如果你看到这个新上任的 PM 仍然过多地干涉“如何构建产品”，而这实际上是工程师和设计师的领域。

---

### [00:27:53] Gokul Rajaram

**English:**
See? That's the other failure case where you've got to... And this is something through coaching comes. Obviously they just were an engineer or designer two weeks ago and now they are a PM. There's a immediate impulse to start going back into their comfort zone. And the key is to really push them to go more strongly biased towards customers and push them more towards talking to customers, understanding customer problems. And I think every PM, we all know this, all of us as PMs, there was no class to be a PM. So there are some people who joined APM programs directly out of school, but most of us are engineers, marketers, analysts, designers. And we became PMs after that. So we all come with inherent biases and ways of doing things and it's only a function of how long it takes us to shed... Or at least to not be that persona, but to actually take on a PM persona.

**中文翻译:**
看到了吗？那是另一种失败的情况，你必须……这需要通过指导来解决。显然，两周前他们还是工程师或设计师，现在成了 PM。他们会有一种立即回到舒适区的冲动。关键是要真正推动他们更强烈地向客户倾斜，推动他们去与客户交谈，理解客户的问题。我认为每个 PM——我们都知道这一点，作为 PM，没有专门的课程教你怎么当 PM。虽然有些人一毕业就加入了 APM（助理产品经理）项目，但我们大多数人以前是工程师、营销人员、分析师、设计师。之后我们才成了 PM。所以我们都带着固有的偏见和做事方式，这只是一个需要多长时间来摆脱……或者至少不再是那个角色，而是真正承担起 PM 角色的问题。

---

### [00:28:45] Gokul Rajaram

**English:**
And so I personally believe in the growth mindset a lot. The reason that hopefully this person was chosen to be the PM is the founder saw that this person has the characteristics, traits, which is curiosity, the customer centricity, communication skills, being able to facilitate discussion, all of those things that a PM should have. Problem solving skills. And so hopefully those are things they didn't just pick a random engineer out of the 10, but they picked the right engineer, the right designer. And I think if you do that and you surround them with some good mentors, I think in six months they'll make good PMs.

**中文翻译:**
所以我个人非常相信成长型思维。希望这个人被选为 PM 的原因是创始人看到他具备这些特质：好奇心、以客户为中心、沟通技巧、能够引导讨论，以及 PM 应该具备的所有这些素质。解决问题的能力。所以希望他们不是从 10 个人里随便挑了个工程师，而是挑中了正确的工程师或设计师。我认为如果你这样做，并给他们找一些好的导师，我想六个月内他们就能成为优秀的 PM。

---

### [00:29:21] Lenny

**English:**
I love that. Maybe just try randomly. You never know.

**中文翻译:**
我喜欢这个。也许随机试一个也行，谁知道呢。

---

### [00:29:21] Gokul Rajaram

**English:**
Good work.

**中文翻译:**
干得好。

---

### [00:29:25] Lenny

**English:**
Just to close the loop on the idea of when it's time to hire a PM, somebody may be listening to this and feeling like, "Oh, we got to get a PM in ASAP." What are some signs or reasons to wait a little bit longer before you hire your first PM?

**中文翻译:**
为了闭环关于“何时雇佣 PM”的话题，可能有人听了之后觉得：“噢，我们得尽快招个 PM。”那么，有哪些迹象或理由表明应该再等一段时间再雇第一个 PM？

---

### [00:29:39] Gokul Rajaram

**English:**
If everything is going well? In other words, if your product team is clicking, if they're empowered and if you feel that they can take problems that you're giving them, not just tactics, but they're able to take a problem. Hey, we need to improve new user acquisition and the product team, the whatever, your product development team, which is just engineers able to take that and essentially act on it and suggest three different ways to improve user acquisition. For example, choose the one that has the best ROI, how you measure it, and then execute on that and then run a test to say, "Look, it did improve user acquisition?" That's a well defined product team. So I think you need an empowered product team that takes ownership and can take a problem, figure out all the options to solve the problem and then prioritize them. And so if you feel that's happening, you don't need a PM. But I've seen that it's hard as engineering teams grow. To engineers, I think they do need that partner. They really that partner to help facilitate that for the most part.

**中文翻译:**
如果一切进展顺利？换句话说，如果你的产品团队配合默契，如果他们被充分授权，如果你觉得他们能处理你交给他们的问题——不仅仅是战术，而是能处理一个真正的问题。比如：“嘿，我们需要提高新用户获取率”，而产品团队（或者说你的产品开发团队，哪怕只有工程师）能够接手并付诸行动，提出三种不同的提高用户获取率的方法。例如，选择一个投资回报率（ROI）最高的方案，确定衡量标准，然后执行并运行测试，最后说：“看，它确实提高了用户获取率。”这就是一个定义良好的产品团队。所以我认为你需要一个有授权、有主人翁意识、能接手问题、找出所有解决方案并确定优先级的团队。如果你觉得这正在发生，你就不需要 PM。但我发现随着工程团队的扩大，这很难维持。对于工程师来说，我认为他们确实需要那个合作伙伴，在大多数情况下，他们真的需要那个伙伴来协助推动这些事情。

---

### [00:30:39] Gokul Rajaram

**English:**
I think infrastructure is a great example. I think Stripe for example, is famous for not hiring PMs because I think when your audience is developers, they know their audience really well. And so I think many dev ops and developer facing companies, they don't have that many PMs. The PM to engineering ratio is very small. Even in Stripe today I bet it's much smaller than other companies. So those are exceptions that engineers truly understand the domain better. So the machine learning companies, infrastructure companies generally I think need fewer PMs. And this is true for any consumer product company. I bet Airbnb's infrastructure team had zero PMs, or very few PMs because they are serving other engineers. So I think those products, I think you need much fewer PMs than consumer facing products.

**中文翻译:**
我认为基础设施类公司是一个很好的例子。比如 Stripe，它以不怎么雇 PM 而闻名，因为当你的受众是开发者时，工程师非常了解他们的受众。所以我认为很多 DevOps 和面向开发者的公司，PM 并不多。PM 与工程师的比例非常小。即使在今天的 Stripe，我敢打赌这个比例也比其他公司小得多。在这些例外情况中，工程师确实更了解该领域。所以机器学习公司、基础设施公司通常需要的 PM 较少。对于任何消费产品公司也是如此。我敢打赌 Airbnb 的基础设施团队以前没有 PM，或者 PM 极少，因为他们是在为其他工程师服务。所以我觉得这类产品比面向消费者的产品需要的 PM 要少得多。

---

### [00:31:27] Lenny

**English:**
This episode is brought to you by Productboard. Product leaders trust Productboard to help their teams build product that matter. From startups to industry titans, over 6,000 companies rely on Productboard to get the right products to market faster, including companies like Zoom, Volkswagen, UI Path and Vanguard. Productboard can help you create a scalable, transparent and standardized process so your PMs understand what their customers really need and then prioritize the right features to build next. Stakeholders feel the love too with an easy to view roadmap that automatically updates so everyone knows what you're building and why. Make data driven product decisions that result in higher revenue and user adoption and empower your product teams to create delightful customer experiences. Visit Productboard dot com to learn more.

**中文翻译:**
本期节目由 Productboard 赞助。产品领导者信任 Productboard，因为它能帮助团队打造真正重要的产品。从初创公司到行业巨头，超过 6,000 家公司依靠 Productboard 更快地将正确的产品推向市场，其中包括 Zoom、大众汽车、UI Path 和 Vanguard 等公司。Productboard 可以帮助你创建一个可扩展、透明且标准化的流程，让你的 PM 了解客户的真实需求，然后确定下一步要构建的正确功能的优先级。利益相关者也能感受到便利，通过易于查看且自动更新的路线图（roadmap），每个人都能了解你们在构建什么以及原因。做出数据驱动的产品决策，从而带来更高的收入和用户采用率，并授权你的产品团队创造令人愉悦的客户体验。访问 productboard.com 了解更多信息。

---

### [00:32:15] Lenny

**English:**
Yeah, I have a post where I have a whole table of how long companies waited before they got their first PM. I think Snapchat had like 200 people also, but I think it's because their designers basically played the role of a PM.

**中文翻译:**
是的，我有一篇文章，里面有一张完整的表格，记录了各家公司在招第一个 PM 之前等了多久。我想 Snapchat 当时也有大约 200 人了，但我认为那是由于他们的设计师基本上扮演了 PM 的角色。

---

### [00:32:27] Gokul Rajaram

**English:**
There we go, that's right. The designers played the role of the PM.

**中文翻译:**
没错，就是这样。设计师扮演了 PM 的角色。

---

### [00:32:30] Lenny

**English:**
Somebody's got to be doing the job, right? Hopefully they enjoy it, sometimes they don't.

**中文翻译:**
总得有人干这活儿，对吧？希望他们乐在其中，虽然有时并非如此。

---

### [00:32:35] Gokul Rajaram

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:32:36] Lenny

**English:**
Okay. So say you've hired your first PM, you're building a product team. Something I wanted to get your take on is, as PM teams grow, sometimes they end up changing who they're reporting to. Sometimes it ends up being a CPO, sometimes a GM, sometimes like even a CTO in some cases. Do you have any thoughts on when it makes sense for product teams to report to say a GM versus a chief product officer or something else? Do you have any advice there?

**中文翻译:**
好。假设你已经雇了第一个 PM，正在组建产品团队。我想听听你的看法：随着 PM 团队的壮大，有时他们的汇报对象会发生变化。有时是 CPO（首席产品官），有时是 GM（总经理），有时甚至在某些情况下是 CTO。你认为产品团队在什么时候适合向 GM 汇报，而不是向 CPO 或其他人汇报？你有什么建议吗？

---

### [00:33:03] Gokul Rajaram

**English:**
Yeah, I've worked at companies where it's both functional, products orgs are functional. Where all the PMs report into the head of product, reports to a CEO, as well as a GM structure where PMs report into a GM, as do an engineering leader and a design leader and even a sales leader, marketing leader, et cetera. So both can work, but ultimately you want, I do think once you have three to four PMs, you do want those three to four PMs to report to a functional product leader just because I feel they want a mentor, first of all. They want a coach. And you want to build a product culture and hopefully discipline across those four or five PMs because the leverage you get. Someone said this, I think a few years ago, I remember this, engineers are obviously very important to hire, but a bad PM... You can get incredible errors from a good PM, but a bad PM can really screw up, can screw up the work of 10 engineers.

**中文翻译:**
是的，我待过的公司里这两种情况都有。有的是职能型架构，产品组织是职能化的，所有 PM 都向产品负责人汇报，产品负责人向 CEO 汇报；也有 GM 架构，PM 向 GM 汇报，工程负责人、设计负责人甚至销售和营销负责人也向 GM 汇报。两种方式都行得通，但最终，我确实认为一旦你有三到四个 PM，你就会希望这三四个 PM 向一位职能产品领导者汇报。首先是因为我觉得他们需要一位导师，需要一位教练。你希望在这些 PM 之间建立一种产品文化，并希望能建立起纪律，因为这会带来杠杆效应。几年前有人说过一句话，我记得很清楚：雇佣工程师显然非常重要，但一个糟糕的 PM……一个优秀的 PM 能带来惊人的产出，但一个糟糕的 PM 真的能搞砸一切，能搞砸 10 个工程师的工作。

---

### [00:34:01] Gokul Rajaram

**English:**
So it's much more important to hire good PM than it is to hire a good engineer. Any good one. Because there's so few PMs for every engineer, that one good or bad PM can really screw up everything, compared to the impact of one good or bad engineer. So what that means for me is that if you have four or five PMs, and the one way to up level them is to actually make sure the four together are sharing best practices, learning, hopefully building a culture. And I think it's hard for a GM who's also managing other functions to do that. So I would say yes, maybe one or two PMs could report into a CEO or a GM or someone else, but once you get into a four or five PM team, they probably should report to a dedicated of product manager whose job is to be a mentor, be a coach, attract strong new folks to the team, hire, build a strong culture, et cetera, et cetera.

**中文翻译:**
所以雇佣一个好的 PM 比雇佣一个好的工程师要重要得多。因为每个工程师对应的 PM 很少，一个好或坏的 PM 真的能搞砸一切，这比一个好或坏的工程师的影响要大得多。所以对我来说，这意味着如果你有四五个 PM，提升他们的一个方法就是确保这四个人在一起分享最佳实践、相互学习，并希望能建立起一种文化。我认为一个同时管理其他职能部门的 GM 很难做到这一点。所以我认为，也许一两个 PM 可以向 CEO 或 GM 汇报，但一旦团队达到四五个人，他们可能应该向一位专门的产品经理（领导）汇报，这个人的工作就是当导师、当教练、吸引优秀的新人加入、招聘、建立强大的文化等等。

---

### [00:34:57] Gokul Rajaram

**English:**
That product manager, I think they could report to the CTO, they could report to the CEO, they could report to the GM. I don't think that matters. But the ICPMs is what I'm more worried about. Who do they report into? I think they should report into a dedicated manager once it gets a certain size.

**中文翻译:**
那位产品经理（领导），我认为他们可以向 CTO 汇报，也可以向 CEO 或 GM 汇报，这不重要。但我更担心的是那些普通产品经理（ICPM）。他们向谁汇报？我认为一旦达到一定规模，他们就应该向一位专门的经理汇报。

---

### [00:35:12] Lenny

**English:**
Awesome. I could not agree more. Another thing I've seen, as a lot of companies go one direction, they go GM models, then they go back to something else where it's completely business unit oriented and functional reporting and then they go back. So I found it, just try something. See if that works. You can always change it in the future. That's super common. I wanted to transition to hiring, talk about hiring. You recently had this incredible thread on Twitter about how to hire a leader and I think maybe just a product leader, maybe broadly, leader. And so for folks that haven't seen that or have time to go on Twitter, I'd love to just hear your advice on how to hire a leader for a company.

**中文翻译:**
太棒了，我完全同意。我还看到过另一种情况，很多公司先是朝一个方向走，采用 GM 模式，然后又回到完全以业务单元为导向和职能汇报的模式，接着又改回去。所以我发现，先尝试一种方式，看看是否奏效。以后总可以改的，这非常普遍。我想转到招聘话题，聊聊招聘。你最近在 Twitter 上发了一个非常精彩的推文串，关于如何雇佣领导者，我想可能是产品领导者，也可能是广义上的领导者。对于那些没看过或者没时间上 Twitter 的人，我很想听听你关于如何为公司雇佣领导者的建议。

---

### [00:35:49] Gokul Rajaram

**English:**
That post actually was triggered by, that morning, one of my company CEO messaged me that, "Wow, I hired someone from this company. How'd you know this person was available from this company?" I was like, "I didn't know about this person, I just knew this company was really good at sales. And so that's why I recommended the company." And he said, "This is the third time I hired based on advice you gave and these are all senior leaders here. How did you do that?" I'm like, "Actually, thinking about it, you're right." When companies ask me... Because the number one, if you ever ask a company, "What's the thing that's keeping you up at night?" They'll always say one of the things always that's keeping them at night, "I want to hire a leader for X, Y, Z function." And I never respond with, here's a person. I'll always say, "Well, you're in this space selling to this kind of customer or serving this kind of customer. Let's think about the best in class companies, who's also, who's very good at functionally the thing you're hiring for, serving the similar type of customer."

**中文翻译:**
那篇帖子其实是由那天早上发生的一件事触发的。我投资的一家公司的 CEO 给我发消息说：“哇，我从这家公司雇了个人。你怎么知道这家公司有这么个人可用？”我说：“我并不认识这个人，我只是知道那家公司的销售做得非常好，所以我推荐了那家公司。”他说：“这是我第三次根据你的建议招人了，而且这些人现在都是这里的高级领导。你是怎么做到的？”我想：“其实仔细想想，你说得对。”当公司问我时……因为如果你问一家公司“什么事让你夜不能寐？”，他们总是会说其中一件事是“我想为某某职能部门招一个领导”。我从不直接回答“这儿有个人”。我总是说：“既然你在这一领域向这类客户销售或服务，那我们想想那些同类中最优秀的公司，谁在你要招聘的这个职能上做得非常好，且服务于类似的客户群体。”

---

### [00:36:48] Gokul Rajaram

**English:**
And so basically that was the origin of the post. And really what it says is, in order to hire, if you want to have a playbook for hiring good leaders or strong leaders for any function, look at best of class companies or companies that are best of class at that function in the similar space. Not your competitors, but you've got to look beyond your competitors. You've got to look at folks who are serving SMBs or enterprises or whatever this... Or consumers. And then say, "Okay, I want to hire a head of marketing." Great. This is the hardest thing. Go to find the top three or four companies who are excellent at marketing to consumers. If that's what you're... Then you don't hire the person, the head of marketing at these companies.

**中文翻译:**
所以这基本上就是那篇帖子的由来。它真正的核心意思是，为了招聘，如果你想有一套招聘优秀领导者或强力职能领导者的剧本，那就去找那些在类似领域、该职能上做得最出色的公司。不是你的竞争对手，你必须把目光投向竞争对手之外。你得看看那些同样服务于中小企业（SMB）、大企业或消费者的公司。然后说：“好吧，我想招一个营销负责人。”太好了。这是最难的事。去找三四家在面向消费者营销方面表现卓越的公司。如果你是做这个的……那么你不要去挖这些公司的营销负责人。

---

### [00:37:31] Gokul Rajaram

**English:**
You hire the person who's reporting to them, the lieutenant. And actually, Adam Zamos, who was the head of people at Square chimed into say, "At Square, early days we used to go..." He used to run people, the people team at Square. "We used to go and hire the up and coming lieutenants of the lieutenants." And so I think you basically have to build almost an org chart and it's not that hard. You just have to spend time on LinkedIn, to say who are all the people in the org? Who reports to? And you can ask some of your friends who work at a company to better construct the org chart and you just literally go through that company and pick out the people. And I saw this in practice because once Square went public, we were the only public finTech in 2015, one of the very few public fintechs.

**中文翻译:**
你要雇佣向他们汇报的人，也就是他们的“副手”（lieutenant）。事实上，Square 前人力资源负责人 Adam Zamos 也插话说：“在 Square 早期，我们经常去……”他以前负责 Square 的人力团队。“我们经常去雇佣那些副手的副手，那些崭露头角的人。”所以我认为你基本上要构建一个组织架构图，这并不难。你只需要花时间在 LinkedIn 上，看看组织里都有谁？谁向谁汇报？你可以问问在那家公司工作的朋友，以便更好地构建组织架构图，然后你就直接研究那家公司并挑选人才。我在实践中见过这种情况，因为 Square 上市后，我们在 2015 年是唯一的上市金融科技公司，也是极少数上市金融科技公司之一。

---

### [00:38:16] Gokul Rajaram

**English:**
And so my goodness, our teams were raided. The next two years, I literally saw the full team, a huge chunk of a team in different parts of payments, compliance, risk, just being raided by other fintechs. And I saw that this was being followed. Because you say, "Okay, who's the company who's best in being in compliance? Square." And I'm sure there are other companies also, but Square was well known because it was public and it was large, they had done it at scale, et cetera. They didn't go after our head, they went after the lieutenant and the lieutenant of the lieutenant, et cetera.

**中文翻译:**
天哪，我们的团队被疯狂挖角。在接下来的两年里，我亲眼看到支付、合规、风控等不同部门的整个团队、一大块团队被其他金融科技公司挖走。我发现他们遵循的就是这套逻辑。因为你会说：“好吧，哪家公司的合规做得最好？Square。”当然肯定还有其他公司，但 Square 很有名，因为它上市了，规模很大，而且已经实现了规模化运作等等。他们不挖我们的负责人，他们挖副手，挖副手的副手，依此类推。

---

### [00:38:46] Lenny

**English:**
I see. So you saw this happening to you and then you've weaponized it in reverse. I love it. Great advice. I've never heard this advice before and it sounds incredibly good. And so thank you for sharing all that. Thank you. On the front of hiring, how much time do you think founders and leaders should spend on hiring? What percentage of their time have you seen the best founders and leaders spend?

**中文翻译:**
明白了。所以你亲身经历了这些，然后反向将其武器化了。我喜欢这个。很棒的建议。我以前从未听过这种建议，听起来非常有效。谢谢你的分享。在招聘方面，你认为创始人和领导者应该花多少时间在招聘上？根据你的观察，最优秀的创始人和领导者会花百分之多少的时间？

---

### [00:39:07] Gokul Rajaram

**English:**
Obviously you've got to always be hiring. Even today, I think Tony and DoorDash, if you have good strong people, you'll always say, "Please make the intro if you have some amazing people," because you never know what you learn from these people, even if you don't end up hiring them. So, always want to meet great people. But I think in general a founder of a young company should spend I think two hours a day hiring and you should do it during the time. I think the challenge in hiring is, you've got to build a process first of all, and that takes a lot of heavy metal work, the right process for you to make sure you do reach out. And again, there are two parts of hiring, there's a lot of reaching out to people and then there's actually talking to people. So I would suggest spending one hour a day doing the reach outs and there it should almost be busy work because you almost figure out the process.

**中文翻译:**
显然，你必须时刻处于招聘状态。即使是今天，我想 Tony 和 DoorDash 也是如此，如果你认识优秀的人才，总会说：“如果你认识厉害的人，请帮我引荐一下”，因为你永远不知道能从这些人身上学到什么，即使最终没有雇佣他们。所以，要始终渴望结识优秀的人。但我认为总的来说，一家年轻公司的创始人每天应该花两个小时在招聘上，而且你应该在特定时间做这件事。我认为招聘的挑战在于，首先你得建立一套流程，这需要大量的繁重工作——建立正确的流程以确保你确实在进行外联。招聘分为两部分：大量的外联工作，以及实际与人交谈。所以我建议每天花一个小时做外联，这几乎应该是“事务性工作”，因为你已经摸清了流程。

---

### [00:39:56] Gokul Rajaram

**English:**
So you should do it during the time of day where you don't have to put a lot of mental... Like, you don't need to be fresh because you need the fresh work for your actual company that you're running. But you need some time, fresh time to come up with the right process. How do you do LinkedIn reach out? Or whatever tools you use to reach out to. Who are the types of profiles, what roles you want to prioritize. So you need to find the right hour to do that in. The second hour should be devoted to actually meeting one or two people on a daily basis, and that's two half an hour conversations. So I think if you just do that, you'll actually, over even 30 days, think about it, you'll meet with 60 people. And you'll do 30 hours of LinkedIn's, just two hours out of say 10 hours a day. And let's say 20 hours, 20 days. So instead of 30. Because of weekday, that's still a lot of time. So I think two hours. Use Calendar. Calendar is your best friend there, use calendar. And I think that's more than enough to do really well on recruiting.

**中文翻译:**
所以你应该在一天中不需要太多脑力……比如不需要精力最充沛的时候做外联，因为你需要把充沛的精力留给实际运营的公司。但你需要一些时间，一些清醒的时间来制定正确的流程。你如何进行 LinkedIn 外联？或者你使用什么工具进行外联？什么样的个人资料、哪些角色需要优先考虑？所以你需要找一个合适的时间段来做这件事。第二个小时应该专门用于每天实际会见一两个候选人，也就是两次半小时的谈话。我想如果你坚持这样做，哪怕只过 30 天，想想看，你就能见到 60 个人。你做了 30 小时的 LinkedIn 外联，每天 10 小时工作时间里只占 2 小时。假设一个月 20 个工作日，那仍然是很多时间。所以我觉得两小时够了。用好日历，日历是你最好的朋友。我认为这足以在招聘上做得非常出色。

---

### [00:40:50] Lenny

**English:**
I'm guessing that you can see a pretty big difference between the founders that you work with that do this sort of process and put in the time, and don't?

**中文翻译:**
我猜你能看出那些建立了这种流程并投入时间的创始人，与那些没这么做的创始人之间有很大的区别？

---

### [00:40:57] Gokul Rajaram

**English:**
One hundred percent. I think putting in the process upfront is really important because you can flounder around, and then just spending a few, four, five hours upfront, talking to a few folks, coming with a good process can massively improve the because they say, right, it's all about once you aim the strategy or the direction you're going is much more important than the speed you go in. If you go in the wrong direction, it doesn't matter how fast you go, you're screwed. But if you go in the right direction, even if you go slightly slower, you're going to get there. So I think it's very important to set the direction of hiring, how exactly are you going to hire, what the process is, what your messaging is going to be, and really make sure you nail that before you do stuff.

**中文翻译:**
百分之百。我认为预先建立流程非常重要，因为否则你会像无头苍蝇一样乱撞。预先花上四五个小时，和几个人聊聊，制定出一套好的流程，可以极大地提高效率。因为正如人们所说，一旦你瞄准了方向，战略或前进的方向比速度重要得多。如果你走错了方向，跑得再快也没用，你还是完蛋了。但如果你方向对了，即使慢一点，你最终也能到达。所以我认为设定招聘方向非常重要：你到底打算怎么招人、流程是什么、你的沟通信息是什么，在动手之前一定要把这些定死。

---

### [00:41:38] Lenny

**English:**
Once you've hired someone, you give them a title. I know you have some strong opinions about titles and how to think about titles at startups and I'd love to hear your take on that.

**中文翻译:**
一旦你雇了人，你得给他们一个头衔。我知道你对头衔以及初创公司如何看待头衔有一些强烈的观点，我很想听听你的看法。

---

### [00:41:48] Gokul Rajaram

**English:**
Yeah, I think on titles, I personally feel that if you're young, you have a unique opportunity as a founder to set a culture in place where people care about scope and impact much more than they would titles. The titles I'm most opposed to, to be honest, I'm not opposed to titles. I think, tweeted about this and people interpret to think no one should have any titles. Titles, people... You want someone to be called a software engineer so you know what they're doing. But the titles I'm most against are director and VP titles. Director, senior director. Because those are the titles that lead to the most contention in the company, that lead to the most conflict, that lead to the most disgruntlement and heartache and managers having to constantly... And people basically staying on for the title, to put it bluntly, versus because their scope and impact.

**中文翻译:**
是的，关于头衔，我个人觉得如果你还年轻（指公司早期），作为创始人你有一个独特的机会来建立一种文化，让人们更关心工作范围（scope）和影响力（impact），而不是头衔。说实话，我最反对的头衔——我并不反对所有头衔，我发过推特，人们误以为我觉得谁都不该有头衔。头衔是需要的，你希望有人被称为“软件工程师”，这样你就知道他们在做什么。但我最反对的是“总监”（Director）和“副总裁”（VP）头衔。总监、高级总监。因为这些头衔最容易导致公司内部的争端，导致最多的冲突、不满和心碎，让经理们不得不不断处理……坦白说，人们会为了头衔而留下来，而不是因为他们的工作范围和影响力。

---

### [00:42:39] Gokul Rajaram

**English:**
But I'm also against giving titles too early in a company. For example, I think the general counsel is a good title. I think Wall Street cares about it. It's important to hear who general counsel is, but I was meeting with a 25 person company today and that CEO told me... I was like, I always talk about what keeps you up at night? And this company's in somewhat of a legal heavy space. He is like, "I need to hire a general counsel instantly." I said, "Listen, yes, I know you need to hire a lead lawyer, whatever you call them. Or head of legal, but do not give the general counsel title at a 25 person company because the person at a 250 person company, hopefully you're going to be that in two, three years. It's going to be very different than the GC now. And you might, you still want to retain this person most likely because they're good. You just don't want them to be the general counsel. She's over and over again. And so, there are certain times you only can give once and if you give it to early, you can't then... That's the reason to avoid title as long as possible. If you give the VP engineering title at 25 people, how the heck are you ever going to have upgrade that person, upgrade that role? You have to basically let them go because you can't then say, "This VP of engineering, now you're going to be made director of engineering or something," et cetera. It's very challenging.

**中文翻译:**
我也反对在公司太早期就给头衔。例如，我认为“总法律顾问”（General Counsel）是个好头衔，华尔街很看重它，知道谁是 GC 很重要。但我今天见了一家 25 人的公司，那位 CEO 告诉我……我问他什么事让你睡不着觉？这家公司处于法律监管较重的领域。他说：“我需要立即雇一个总法律顾问。”我说：“听着，我知道你需要雇一个首席律师，不管你怎么称呼他们，或者叫法律负责人，但千万不要在 25 人的公司给‘总法律顾问’这个头衔。因为当公司发展到 250 人时（希望两三年后能达到），那时候的 GC 和现在的会非常不同。你很可能还想留住这个人，因为他很优秀，但你只是不想让他当那个规模下的 GC。这种情况屡见不鲜。有些东西你只能给一次，如果你给得太早，你就没法……这就是为什么要尽可能长时间地避免给头衔。如果你在 25 人时就给了‘工程副总裁’的头衔，你以后怎么升级这个角色或这个人？你基本上只能让他们走人，因为你不能说‘这位工程副总裁，现在你要被降为工程总监了’，这太难处理了。”

---

### [00:43:50] Lenny

**English:**
When I look at your LinkedIn, it's always funny because I think you're just like, "Startup helper," or when you were running Caviar, I think it was like, "Someone at Caviar," or something very vague. Clearly you live that yourself.

**中文翻译:**
我看你的 LinkedIn 时总觉得很有趣，因为你只写着“初创公司帮手”，或者当你经营 Caviar 时，我记得写的是“Caviar 的某个人”之类非常模糊的词。显然你自己就在践行这一点。

---

### [00:44:01] Gokul Rajaram

**English:**
And I saw the impact of it. I saw at, Square I think was the company, and I think Jack came up with this because he saw that Twitter titles were weaponized in different ways. And so he started this at square and that's where I truly saw the impact and never had a single discussion at Square with my team about what the title should be. And that was amazing. At other companies, always, "I want to be promoted director. I want to be promoted to senior director." It's always, during promotion time. If you ask person what their goal is, even personal goals, sometimes they'll even write, I want to be promoted to director, but never had that. Had stuff of course around scope, impact, compensation, that's great. I want to have conversation about that, but title? No.

**中文翻译:**
我看到了它的影响力。我想是在 Square，杰克想出了这个主意，因为他看到 Twitter 的头衔被以各种方式武器化了。所以他在 Square 开始实行这一套，我真正看到了它的威力。在 Square，我从未和团队讨论过头衔应该是什么，这太棒了。在其他公司，总是听到“我想晋升为总监”、“我想晋升为高级总监”。总是在晋升季听到这些。如果你问一个人的目标是什么，甚至是个人目标，有时他们甚至会写“我想晋升为总监”，但在 Square 从没发生过。当然，会有关于工作范围、影响力和薪酬的讨论，这很好，我也愿意聊这些，但头衔？没门。

---

### [00:44:45] Lenny

**English:**
And just to summarize your advice there, what's kind of the role of thumb of titles if someone hasn't read that post?

**中文翻译:**
总结一下你的建议，如果有人没读过那篇帖子，关于头衔的经验法则是怎样的？

---

### [00:44:51] Gokul Rajaram

**English:**
Delay it as long as possible and try to avoid granting director and VP level titles as long as possible, in particular.

**中文翻译:**
尽可能推迟给头衔，特别是要尽可能长时间地避免授予总监和副总裁级别的头衔。

---

### [00:45:00] Lenny

**English:**
Easy. And then delay it, meaning have-

**中文翻译:**
明白。推迟的意思是——

---

### [00:45:02] Gokul Rajaram

**English:**
Very simple. [inaudible 00:45:05]

**中文翻译:**
非常简单。

---

### [00:45:04] Lenny

**English:**
And delaying titles, meaning like anything other than just software engineer, product management?

**中文翻译:**
推迟头衔，意思是除了“软件工程师”、“产品管理”之外不给别的？

---

### [00:45:08] Gokul Rajaram

**English:**
Software engineer, lead. The word lead, or head of are both good, because the head of very clearly describes what they do or lead also very clearly describes what they do. So my title was Caviar Lead and then the people who reported to me were Caviar product lead, Caviar engineering lead, Caviar strategy and operations lead, Caviar sales lead, et cetera. And so the more words that are in the title, the more focused their role is. In fact, you can look at Jack's new title, it's Block Head, so it's literally not senior anymore. It's head of block, a block leader I would say probably should be more appropriate. He's a leader block, and then so on, it premieres down.

**中文翻译:**
软件工程师、负责人（Lead）。“Lead”或“Head of”这两个词都很好，因为“Head of”非常清晰地描述了他们做什么，“Lead”也是。所以我当时的头衔是 Caviar Lead，向我汇报的人是 Caviar 产品负责人、Caviar 工程负责人、Caviar 战略与运营负责人、Caviar 销售负责人等等。头衔里的词越多，他们的角色就越聚焦。事实上，你可以看看杰克的新头衔，是“Block Head”（Block 负责人），字面上已经不再是“资深”之类的了。他是 Block 的负责人，或者叫 Block 领导者可能更合适。他是 Block 的领导者，然后依此类推，向下延伸。

---

### [00:45:48] Lenny

**English:**
Amazing. That's incredibly valuable advice and thank you for getting into the details there. I'd love to transition in to talk about investing a little bit before we get to our exciting lightning round. And so you spent a lot of your time angel investing, investing in a bunch of different ways. What's been your trajectory from just starting to angel invest early on to the scale you're at now?

**中文翻译:**
太棒了。这是非常有价值的建议，感谢你深入探讨这些细节。在进入精彩的闪电轮问答之前，我想转而聊聊投资。你花了很多时间做天使投资，以各种不同的方式投资。从早期刚开始做天使投资到现在的规模，你的历程是怎样的？

---

### [00:46:09] Gokul Rajaram

**English:**
I started angel investing in 2007, 15 years ago. And like many people, I started because my friends and colleagues were leaving to start companies. This is when I was at Google and they were leaving to start companies. So I literally, without going much, I just wanted to support them because I'd worked with them. And so I just put a small check into their companies and some failed, some did really well. But ultimately I realized that for me, investing is all about supporting people much more so than companies themselves. The company itself, it's about the entrepreneur and the person. So till today, I think I have enjoyed the most and I've really come to believe in myself that I am a founder centric. I believe in the founder much more than I do the market. I think there are market centric investors. [inaudible 00:46:56] is amazing and they are very much believe in a big market.

**中文翻译:**
我从 2007 年开始做天使投资，那是 15 年前。和很多人一样，我开始投资是因为我的朋友和同事离开公司去创业。当时我在 Google，他们离职创业。所以，没想太多，我只是想支持他们，因为我们共事过。于是我就给他们的公司投了一小笔钱，有的失败了，有的做得非常好。但最终我意识到，对我来说，投资更多是关于支持“人”，而不是公司本身。公司本身其实就是关于企业家和那个人的。所以直到今天，我想我最享受的，并且我真正坚信的是，我是一个“以创始人为中心”的投资者。比起市场，我更相信创始人。我知道有些投资者是以市场为中心的，他们很棒，非常看重大市场。

---

### [00:46:59] Gokul Rajaram

**English:**
I strongly believe that great founders, and Airbnb's a great example. They create new markets themselves, or they pivot. I mean, if they realize that a certain market is not good, they'll figure out a way to move. And I'm basically, with my check, the biggest mistakes I made early on were after a few checks I said, "Oh, I'm going to be much more selective. I'm not just going to write checks with all my friends. I'm going to look to see what the market they're in." So I basically just started making these assumptions, "Oh, well, I should not invest in this company." And turns out, almost all of them were sins of omission. I much more care about sins of omission because you can only lose one X your money. But for me, the relationship with the person, a person I know and respect and good friends with, and I'm not investing in them, I don't want to lose that.

**中文翻译:**
我坚信伟大的创始人——Airbnb 就是一个绝佳的例子——他们会自己创造新市场，或者转型。我的意思是，如果他们意识到某个市场不好，他们会想办法转移。早期我犯过的最大错误是，在投了几笔钱后我说：“噢，我要变得更挑剔一些。我不能只给朋友开支票，我要看看他们所处的市场。”于是我开始做各种假设：“噢，我不应该投这家公司。”结果证明，几乎所有的错误都是“遗漏之罪”（sins of omission）。我更在意遗漏之罪，因为投资失败你最多只损失 1 倍的本金。但对我来说，如果是我认识、尊重且关系很好的朋友，而我不投他们，我不想失去那种联系。

---

### [00:47:48] Gokul Rajaram

**English:**
And it's an optionality for me to invest in not just this company, but in every other company they start. Because one of the most interesting patterns I see is, folks who are unsuccessful the first time around, but then use those learnings to start a company in the same or similar space and then succeed. And I'm seeing this more and more happen and I want to have, if you don't invest in their first company, even though you thought they were great because the marketers are great, they won't probably come back to you for the second company either. So very, very founder centric style of investing, almost like YC, I would say. Closer to YC than anything else because YC invest in just founders at this point, they don't care about the idea. They just care that you're a builder and that you can pivot fast. And if you're a team of builders who can pivot fast, they will invest because they know within three weeks, if you don't have product market fit, they'll get you to pivot three times, and under that excitement, you'll find your product market fit four times. I see this again and again.

**中文翻译:**
对我来说，这是一种期权，不仅是投资这家公司，也是投资他们未来创办的每一家公司。因为我看到的一个最有趣的模式是：有些人第一次创业不成功，但他们利用学到的教训在相同或类似的领域创办了另一家公司，然后获得了成功。我看到这种情况越来越多，如果你因为觉得市场不好而没投他们的第一家公司（尽管你觉得人很棒），他们可能第二家公司也不会再找你了。所以这是一种非常非常以创始人为中心的投资风格，我想说几乎像 YC。比任何其他机构都更接近 YC，因为 YC 现在只投创始人，他们不在乎点子。他们只在乎你是不是一个构建者（builder），以及你是否能快速转型。如果你是一个能快速转型的构建者团队，他们就会投，因为他们知道如果三周内没找到产品市场契合点，他们会让你转型三次，在这种兴奋感下，你会找到四次契合点。我一次又一次地看到这种情况。

---

### [00:48:41] Lenny

**English:**
I love that advice and it's the way I think about it too. The only downside is if you have worked at an awesome company or two or three, it becomes a very expensive hobby because you end up knowing a lot of awesome people that are doing great things. So you have to be a little bit careful.

**中文翻译:**
我喜欢这个建议，我也是这么想的。唯一的缺点是，如果你曾在一两家甚至三家很棒的公司工作过，这会变成一个非常昂贵的爱好，因为你最终会认识很多正在做大事的牛人。所以你得稍微小心点。

---

### [00:48:55] Gokul Rajaram

**English:**
You've got to really make sure what the motivation. That's what I really want to understand. You don't want folks, there are awesome people, but I do want to make sure they're doing it for the right reason. In other words, they're doing it to solve a problem that they've experienced themselves, or seen. So I really try to get into why they're starting the company and I want to make sure the reason for starting the company is authentic, in that it's a problem that they have observed deeply. Versus, it's something they read about in Tech Crunch or it's a new US Web three or crypto thing or NFT thing. So I think that's how I suss out. So I don't invest in people, even if they're awesome, when I feel their idea for... The reason they're starting the company is mercenary and they're doing it, because they haven't immersed themselves in the space. Famously, I think the Collison Brothers bought a book, I think on payments, very old book or something I think... Or paper maybe, and read it to fully understand why you want people who really immerse themselves in an industry and live and breathe it before they tackle it.

**中文翻译:**
你真的得搞清楚他们的动机。这是我真正想了解的。虽然有些人很优秀，但我确实想确保他们是为了正确的理由而创业。换句话说，他们是为了解决自己经历过或亲眼见过的某个问题。所以我真的会深入探究他们为什么要创办这家公司，我想确保创业的原因是真实的，即那是他们深入观察到的一个问题。而不是因为他们在 TechCrunch 上读到了什么，或者是为了追逐 Web3、加密货币或 NFT 的热潮。这就是我筛选的方式。即使人很棒，如果我觉得他们创业的动机是投机性的（mercenary），而且他们并没有沉浸在这个领域，我也不会投。有个著名的故事，Collison 兄弟（Stripe 创始人）买了一本关于支付的非常古老的书或论文，并通读了它以完全理解这个行业。你需要的是那些在动手解决问题之前，真正沉浸在行业中、与之同呼吸共命运的人。

---

### [00:49:50] Lenny

**English:**
Are there other things like that, that you look for? That are just like, "Oh wow, I really need to invest in this."

**中文翻译:**
还有其他类似你寻找的东西吗？那种让你觉得“哇，我一定要投这个”的东西？

---

### [00:49:55] Gokul Rajaram

**English:**
The ability to hire talent before even you have... Or ability that, if you can show me that you have this set of amazing people lined up to join you or that you have commitments, or even your founders. I mean, the other thing I look for is definitely two person founding team. At least two is the ideal. I've seen solo founders I'm very nervous about because I think no one person has all the skills you need to start a company. And it's also a lot of things to do. So I do like to see a really good mix of basically a builder and a seller or a hustler and a hacker, whatever you call them. And I think that two person, I really feel comfortable, however good the one person is, I just feel it's... There are obviously one person founding teams that have worked well, but I think the two or three person founding teams, I feel much. Two is the ideal number. So I look for the two person founding team, complementary skills.

**中文翻译:**
甚至在你还没……之前就招揽人才的能力。或者如果你能向我展示你已经有一群牛人排队等着加入，或者你已经拿到了他们的承诺。还有就是创始人。我寻找的另一件事绝对是两人创始团队。至少两个是理想状态。我对个人创始人（solo founder）感到非常紧张，因为我认为没有一个人能具备创办公司所需的所有技能。而且要做的事情太多了。所以我喜欢看到一个很好的组合，基本上是一个“构建者”和一个“销售者”，或者叫“推销员”和“黑客”。我觉得两个人的组合让我很放心，无论那一个人有多优秀，我总觉得……虽然显然也有运作良好的个人创始团队，但我更看好两到三人的团队。二是理想数字。所以我寻找的是具备互补技能的两人创始团队。

---

### [00:50:43] Lenny

**English:**
These are really, really handy rules of thumb that everybody could use. How do you find time to do this? So you have a full time job, I imagine it's extremely demanding, and then you're also doing a lot of investing for folks that are thinking about doing this on the side. How do you time box this and keep it sustainable and not just to go crazy and burn yourself out?

**中文翻译:**
这些真的是非常实用的经验法则，每个人都能用。你是怎么抽出时间做这些的？你有一份全职工作，我想象那一定非常繁重，然后你还为那些想做副业投资的人做了这么多投资。你如何进行时间管理（time box），并保持其可持续性，而不至于发疯或精疲力竭？

---

### [00:51:00] Gokul Rajaram

**English:**
Time boxing. Exactly what you said, Lenny, it's time boxing. Most of the time ironically is spent on DoorDash and... Not ironically. Logically is spent on DoorDash even though it may not appear it. So I spend on DoorDash and what I do is a small percent of my time, I basically... I keep looking at my calendar to see, am I spending more than I've worked, say 10 hours a day? Am I spending more than two to three hours, maximum three, ideally two hours a day on things that are needed to do my work? And three hours actually is a lot. If you think about half an hour meetings with people, that's six meetings you can do a day, out of 10. And I also do two hours each on both Saturday and Sunday so that I can do four meetings each.

**中文翻译:**
时间管理。正如你所说，Lenny，就是时间管理。讽刺的是，大部分时间都花在了 DoorDash 上……不，不是讽刺，逻辑上就该花在 DoorDash 上，尽管看起来可能不像。所以我把时间花在 DoorDash 上，我所做的是拿出一小部分时间，我基本上……我会一直盯着我的日历看：假设我每天工作 10 小时，我是否花了超过两到三个小时（最多三小时，理想是两小时）在非核心工作的事情上？其实三小时已经很多了。如果你考虑半小时一场的会议，一天 10 小时里你可以开 6 场这样的会。我周六和周日也会各花两小时，这样每天可以开 4 场会。

---

### [00:51:25] Gokul Rajaram

**English:**
So if you think about it, six times five is 30, or four times five is 20, plus another four, plus 4... 28 meetings, that's a lot of meetings you can do with people, et cetera, et cetera. Yeah, so I think it's really time boxing and knowing... I think it is knowing what matters. Because if you find yourself doing the opposite, where 70% of time is investing, then you should actually become a full-time investor.

**中文翻译:**
所以你想想，6 乘以 5 是 30，或者 4 乘以 5 是 20，再加上周末的 8 场……一周 28 场会，这已经可以见很多人了。所以我觉得关键在于时间管理和分清主次。因为如果你发现情况反过来了，70% 的时间都在做投资，那你其实应该去当全职投资者。

---

### [00:51:59] Lenny

**English:**
That's amazing. I don't know how you keep your brain capacity focused on so many things. Meeting with that many founders, even outside the time, is a lot of mental load.

**中文翻译:**
太神奇了。我不知道你是如何让大脑容量专注于这么多事情的。即使在规定时间之外，会见这么多创始人也是很大的心理负担。

---

### [00:52:08] Gokul Rajaram

**English:**
I enjoy it. I think the thing is, I enjoy it because I have been a founder myself, not a very successful one. So one of the things I love hearing, I always start with, "Tell me your founding story." And every founder likes to tell the founding story. And that's where I listen closely for authenticity, to understand how they met each other, the two founders or multiple founders, how they knew each other, and how they came up with this idea that they're going after. Versus what problem they're tackling. I have a standard set of questions I ask so that way I can spend my time not thinking of questions to ask but just listening and just learning. And then I also have a good ability to forget instantly. I take notes and then I just forget and go into the next meeting. So compartmentalizing well.

**中文翻译:**
我很享受。关键在于，我享受这个过程是因为我自己也曾是个创始人，虽然不是特别成功。所以我最喜欢听的一句话，我总是以“讲讲你的创业故事”开始。每个创始人都喜欢讲创业故事。我会仔细倾听其中的真实性，了解两位或多位创始人是如何相识的，他们如何认识彼此，以及他们是如何想到现在正在做的这个点子的。而不是只听他们在解决什么问题。我有一套标准的问题，这样我就不用花心思去想该问什么，而是专注于倾听和学习。而且我还有一种“瞬间遗忘”的能力。我做完笔记，然后就忘掉，进入下一场会议。所以，要把事情划分得很好（compartmentalizing）。

---

### [00:52:52] Lenny

**English:**
Have you thought about publishing these questions that you ask? Or do you think that would hurt your chats?

**中文翻译:**
你有没有想过公布你问的这些问题？或者你觉得这会影响你的谈话效果？

---

### [00:52:56] Gokul Rajaram

**English:**
No, I think it seems... Yeah, it seems too formulaic then. I think there's questions that then change based on what the answer. So it's not exactly a set of questions, but it always starts with, "Tell me about your founding story of the company." I introduce myself and then asked them for their founding story. They're all nervous, pitching, et cetera when they pitch someone who could be an investor. We ask them to tell stories. It's the same for customer interviews, right? You never ask customers, "Tell me your top three problems." No one knows what they are. But, "Tell me the last time you used a food delivery service. Tell me the last time you used a payment service. How was it? Tell me the last time you took a payment, credit card payment. Tell me about your last customer." People love telling stories about themselves. Everyone likes talking about how they did something.

**中文翻译:**
不，我觉得那样就太公式化了。问题会根据回答而改变。所以并不完全是一套固定的问题，但开头总是“讲讲你公司的创业故事”。我先自我介绍，然后请他们讲创业故事。当他们向潜在投资者做简报（pitch）时，通常都很紧张。我们让他们讲故事。这和客户访谈是一样的，对吧？你永远不会问客户：“告诉我你最头疼的三个问题。”没人知道那是什么。但如果你问：“讲讲你上次使用外卖服务的情景。讲讲你上次使用支付服务的情况，感觉如何？讲讲你上次收钱、收信用卡支付的情况。讲讲你的上一个客户。”人们喜欢讲关于自己的故事，每个人都喜欢谈论他们是如何做成某件事的。

---

### [00:53:40] Lenny

**English:**
For somebody that's thinking about getting into angel investing, other than having capital and finding capital, what advice would you give folks?

**中文翻译:**
对于那些考虑进入天使投资领域的人，除了拥有资金和寻找资金之外，你还会给他们什么建议？

---

### [00:53:49] Gokul Rajaram

**English:**
See, the number one thing you need is, I think, besides... Number one thing is capital. Number zero thing. Number one thing is then you need to have deal flow, as they call it, or companies that you're meeting with and deciding. And then you need to know how to pick these companies. So you need to meet companies, you need to know how pick them. As an angel is generally easy. So I think you need to figure out how to get deal flow. And there are three ways to get deal flow to companies. One, you build your own brand. You can be like Lenny, who's built an incredible brand, or none of us can be like Lenny, but you can try to, we can all publish. The reality is, I used to tell every single person, "You can build your brand on the internet. You can build your brand, social media channels."

**中文翻译:**
看，我认为你需要的头等大事是——除了资金（那是第 0 件事）——第 1 件事就是所谓的“项目流”（deal flow），也就是你能见到并决定是否投资的公司。然后你需要知道如何挑选这些公司。所以你需要接触公司，并知道如何筛选。作为天使投资人，这通常比较容易。我认为你需要弄清楚如何获得项目流。获得项目流有三种方式：第一，建立你自己的品牌。你可以像 Lenny 一样建立一个令人惊叹的品牌，虽然我们没人能达到 Lenny 的高度，但我们可以尝试，我们都可以发表内容。现实是，我以前告诉每一个人：“你可以在互联网上建立你的品牌，利用社交媒体渠道。”

---

### [00:54:29] Gokul Rajaram

**English:**
There's so many channels. And you have the person here who can teach the masterclass in that. You can build your brand. And just by doing that, you'll get people coming to you. Second, you have a lot of... Anyone in technology has other people they know who are angel investors. So it's just tell them, "Hey, I'd love to help companies. If they're investing in a company, please let we know." And the more people you tell, the more likely it is, they'll remember you. And every time you meet them, reinforce that. And third, investors. If you do know venture capitals or investors, many of them are looking to bring on... There's typically a round when they lead companies around, there's typically an allocation for angels. But for all of those, the first and most important thing is you need to understand, how are you going to add value to these companies?

**中文翻译:**
渠道有很多。这里就有一个可以教你大师课的人（指 Lenny）。你可以建立自己的品牌，只要这样做，人们就会主动找你。第二，你有很多……任何在科技行业的人都会认识其他做天使投资的人。只要告诉他们：“嘿，我很乐意帮助初创公司。如果你们在投哪家公司，请告诉我。”你告诉的人越多，他们记住你的可能性就越大。每次见到他们时，都要强化这一点。第三，投资者。如果你认识风险投资人（VC）或投资者，他们中的许多人都在寻找……通常当他们领投某轮融资时，会给天使投资人留出一定的份额。但对于所有这些，最重要的一点是：你需要明白，你将如何为这些公司增加价值？

---

### [00:55:13] Gokul Rajaram

**English:**
What is your differentiation? What do you stand for? Why should a company take your money? The best companies have much more than... As Lenny and I both know, their rounds are over subscribed. It is hard enough to get even $1 into their round, let alone a hundred thousand dollars or $5,000. So why would they take your money? And so that's the thing, you have to really figure out. What is your unique differentiation? What do you bring to these companies that no one else can? And I know that's hard, that's painful to figure out, but that is the introspection each of us needs to do. The way you do that is by just sharing your non-obvious insights. And don't just like... Basically just write. That's why I think writing is so powerful because it shows the world. My rule of thumb is when they do a search for you on Google, if your LinkedIn profile is the first thing that comes up, you've probably done something wrong.

**中文翻译:**
你的差异化是什么？你代表什么？为什么一家公司要拿你的钱？最好的公司拥有的远不止……正如 Lenny 和我都知道的，他们的融资轮次通常是超额认购的。哪怕想往里投 1 块钱都很难，更不用说 10 万美元或 5,000 美元了。那么他们为什么要拿你的钱呢？这就是你需要真正弄清楚的事情。你的独特差异化是什么？你给这些公司带来了哪些别人无法提供的东西？我知道这很难，弄清楚这个过程很痛苦，但这是我们每个人都需要做的反思。实现这一点的方法就是分享你那些“非显而易见”的见解。不要只是……基本上就是去写。这就是为什么我认为写作如此强大，因为它向世界展示了你。我的经验法则是：当人们在 Google 上搜索你时，如果你的 LinkedIn 个人资料是第一个出现的，那你可能做错了什么。

---

### [00:56:02] Gokul Rajaram

**English:**
What should come up is an article you wrote. Is a tweet you published. Is someone mentioning you on something else, et cetera. Because that's when, clicking on it, they know what you stand for by that content about you, by you, et cetera. Yes, Mike Morritz can get away with LinkedIn because no one needs to know what he has done. But for the rest of us, we need to build our brand, what we stand for. And it'll change over time. I used to basically believe I should just think about product development, how to lead product teams, engineering teams. For over the last five years, since I've led broader teams, I now share stuff which is much broader than that. And so what I stand for and what value I add has changed and evolved and hopefully increased over time. The same will happen. But you've got to take ownership of your brand on the internet.

**中文翻译:**
应该出现的是你写的一篇文章，或者是你发布的一条推文，或者是别人在其他地方提到你等等。因为当人们点击这些内容时，他们能通过关于你的、由你创作的内容了解你的立场。是的，迈克·莫里茨（Mike Moritz，红杉资本合伙人）可以只靠 LinkedIn，因为没人需要去查他做过什么。但对于我们其他人来说，我们需要建立自己的品牌，明确自己的立场。而且这会随着时间而改变。我以前基本认为我只需要思考产品开发、如何领导产品和工程团队。在过去的五年里，由于我领导了更广泛的团队，我现在分享的东西也比以前广泛得多。所以我代表什么以及我增加的价值已经发生了变化和演变，并希望随着时间的推移而增加。你也会经历同样的过程。但你必须掌控自己在互联网上的品牌。

---

### [00:56:46] Gokul Rajaram

**English:**
No one else can. No one else can. It's not your company. You've got to transcend the companies you work for. If your identity is X, Y, Z, worker drone at A, B, C company, that's not enough. You've got to be X, Y, Z expert in A. Or whatever that A is, even if it's a niche thing, that's okay. Every company leads... So many companies come to me, "I want a payments expert." And then I'll find someone who's a payments expert for them because they're trying to build a fintech practice or something. So be an expert in payments, if that's what you know. Write about non obvious insights on payments. Doesn't need to be a functional discipline like, Lenny and I are doing product or something. Can be a domain. Risk, payments, crypto. Think about crypto, right? The people who got into crypto, and I just read a post by this guy, Richard Chen, he graduated from Stanford.

**中文翻译:**
没人能替你做这件事。这不是你公司的事。你必须超越你工作的公司。如果你的身份只是“某某公司的打工人”，那是不够的。你必须成为“某某领域的专家”。无论那个领域是什么，即使是很小众的领域也没关系。很多公司来找我：“我想要一个支付专家。”然后我会为他们找一个支付专家，因为他们正试图建立金融科技业务之类的。所以，如果你懂支付，就成为支付专家。写一些关于支付的非显而易见见解。不一定非得是像 Lenny 和我这样关于产品之类的职能学科，也可以是一个领域：风控、支付、加密货币。想想加密货币，对吧？那些进入加密货币领域的人，我刚读了 Richard Chen 的一篇文章，他毕业于斯坦福。

---

### [00:57:33] Gokul Rajaram

**English:**
I don't know him, but I read incredible post. He runs this firm fund called One Confirmation, which is a top fund. He graduated from undergrad four years ago. That's all he did. I mean, he was head of Stanford Blockchain. He wrote, he writes amazing stuff. He's built a brand for himself. Kudos to him. 25 years old, probably. Never met the guy, but I was like, this guy knows what he's doing. Watch his LinkedIn. Oh my God, he's never worked at a company. He's basically been out of school for four years, but he has incredible insights.

**中文翻译:**
我不认识他，但我读了一篇非常精彩的帖子。他经营着一家名为 One Confirmation 的基金，那是顶级基金。他四年前才本科毕业。这就是他所做的一切。我是说，他曾是斯坦福区块链协会的负责人。他写的东西非常棒。他为自己建立了品牌。向他致敬。大概也就 25 岁。我从未见过他，但我当时觉得，这家伙知道自己在做什么。看看他的 LinkedIn，天哪，他从未在公司工作过。他毕业才四年，但他有惊人的见解。

---

### [00:58:00] Lenny

**English:**
Wait till he hears this podcast. He's like, "Holy shit, they're talking about me."

**中文翻译:**
等他听到这期播客，他肯定会想：“天哪，他们在谈论我。”

---

### [00:58:04] Gokul Rajaram

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:58:06] Lenny

**English:**
Okay, we are now at the lightning round. And so what I'm going to do, I'm going to ask you a bunch of questions real quick. Whatever comes to mind, let me know. If nothing comes to mind, that's also cool. And then we will wrap up. Are you ready?

**中文翻译:**
好，我们现在进入闪电轮问答。我会快速问你一堆问题。想到什么就说什么。如果没想法也没关系。然后我们就结束。准备好了吗？

---

### [00:58:21] Gokul Rajaram

**English:**
Perfect. Ready.

**中文翻译:**
太好了。准备好了。

---

### [00:58:22] Lenny

**English:**
Okay. What's a book that you've recommended most to other product leaders?

**中文翻译:**
好。你向其他产品领导者推荐最多的一本书是什么？

---

### [00:58:27] Gokul Rajaram

**English:**
Playing to Win: How Strategy Really Works. It's a book called Playing to Win and the subtitle is How Strategy Really Works. Very good book.

**中文翻译:**
《玩转策略：战略如何真正发挥作用》（Playing to Win: How Strategy Really Works）。书名是 Playing to Win，副标题是 How Strategy Really Works。非常棒的一本书。

---

### [00:58:34] Lenny

**English:**
Amazing. I have not read that. I will check that out. What's a company that you recommend to people that are looking for new gigs? Maybe product managers, maybe any other function?

**中文翻译:**
太棒了，我还没读过，我会去看看。对于正在寻找新机会的人（可能是 PM，也可能是其他职能），你会推荐哪家公司？

---

### [00:58:44] Gokul Rajaram

**English:**
DoorDash. Incredible operational excellence. And what you learn here, I have myself learned a lot in the two years I've been here, about new ways of the attention to detail. Operational excellence, unparalleled.

**中文翻译:**
DoorDash。令人难以置信的卓越运营。在这里你能学到的东西——我在这里的两年里学到了很多关于关注细节的新方法。卓越运营，无与伦比。

---

### [00:58:56] Lenny

**English:**
I usually include, you can't mention the company you're working at now. Is there another company by any chance? And if not, you can have that.

**中文翻译:**
我通常会加个限制，不能提你现在工作的公司。还有别的公司吗？如果没有，这个也行。

---

### [00:59:02] Gokul Rajaram

**English:**
I would say Coinbase, if you're interested in crypto. I am technically a board member. I truly believe. I think if you are interested in crypto, Coinbase has such a diverse set of things that they work on that it is literally, you can work on almost any part of crypto, from NFTs to wallets to custody to infrastructure. They have a company they called Bison Trails, which does infrastructure. So you can truly, it's like Google, worked on everything. You could work in YouTube, you can work in search. Coinbase, I think the same thing. You can work in 10 different products and within two years or three years, learn the complete spectrum, crypto ecosystem.

**中文翻译:**
我会说 Coinbase，如果你对加密货币感兴趣的话。虽然我名义上是董事会成员，但我真心相信。如果你对加密货币感兴趣，Coinbase 涉及的业务非常多样化，字面上你可以参与加密货币的几乎任何部分，从 NFT 到钱包，到托管再到基础设施。他们有一家叫 Bison Trails 的公司专门做基础设施。所以你真的可以像在 Google 一样，什么都做。在 Google 你可以做 YouTube，也可以做搜索；在 Coinbase 我觉得也一样。你可以参与 10 个不同的产品，在两三年内了解整个加密生态系统。

---

### [00:59:37] Lenny

**English:**
Also an Airbnb alumni founder.

**中文翻译:**
也是一位 Airbnb 校友创始人。

---

### [00:59:39] Gokul Rajaram

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:59:40] Lenny

**English:**
What's your favorite app right now?

**中文翻译:**
你现在最喜欢的 App 是什么？

---

### [00:59:42] Gokul Rajaram

**English:**
Over the last few weeks it has been Coinbase wallet. I've been playing around. I just was a hoarder. I basically just had held Bitcoin Ether for many, many years, but then over the last couple of months I just said, got to just... In the Coinbase board meetings, you listen to all of these things. I'm like... Got to now diverse and beyond and actually got to start staking stuff, going on distributed exchanges, or decentralized exchanges and just basically playing around with Coinbase wallet because earlier I wasn't using wallet. I was just using Coinbase dot com where you can't do any of this stuff. And then DoorDash is the other one. I think I truly use it to order food every day. But Coinbase wallet is one I'm using a lot now.

**中文翻译:**
过去几周是 Coinbase Wallet。我一直在研究它。我以前只是个“囤币党”，持有很多年的比特币和以太坊，但过去几个月我想，得……在 Coinbase 董事会上听了这么多，我觉得得多元化一点，开始尝试质押（staking）、去中心化交易所（DEX），基本上就是玩转 Coinbase Wallet。因为以前我不怎么用钱包，只用 Coinbase.com，在那儿你没法做这些操作。另一个是 DoorDash，我真的每天都用它订餐。但 Coinbase Wallet 是我最近用得很多的。

---

### [01:00:24] Lenny

**English:**
Awesome. I got to check that out. I just got access to the Coinbase NFT stuff, and so yes, it'll pull me into the Coinbase ecosystem. Okay, a couple more questions. Who is a favorite person to follow on Twitter or Instagram? Especially these days?

**中文翻译:**
太棒了，我也得去看看。我刚拿到 Coinbase NFT 的访问权限，所以是的，它也会把我拉进 Coinbase 生态系统。好，还有几个问题。在 Twitter 或 Instagram 上，你最喜欢关注谁？尤其是最近？

---

### [01:00:38] Gokul Rajaram

**English:**
Exactly. [inaudible 01:00:40].

**中文翻译:**
Naval Ravikant（硅谷知名投资人）。

---

### [01:00:39] Lenny

**English:**
Easy choice. All right. Who's a favorite manager that you've had over the years?

**中文翻译:**
明智的选择。好。这些年来你最喜欢的经理是谁？

---

### [01:00:44] Gokul Rajaram

**English:**
All of them. I've learned different things through them. So no easy choice there.

**中文翻译:**
所有的经理。我从他们每个人身上都学到了不同的东西。所以这很难选。

---

### [01:00:49] Lenny

**English:**
No favorites. All right. Taking the easy way out. And then what's a favorite interview question that you like to ask in interviews? Not with founders, but with hiring.

**中文翻译:**
没有最喜欢的。好吧，你选了个省事的回答。那么，你在面试中（不是面试创始人，而是招聘面试）最喜欢问的问题是什么？

---

### [01:00:56] Gokul Rajaram

**English:**
What are you most proud of? The interview question is a good one. Tell me about something that you're most proud of. What is the accomplishment, career accomplishment you're most proud of? Because it tells you how they measure their impact. Tells you a lot about what they care about, how they measure their impact. If they say, "As a PM I launched X, Y, Z feature," they're talking about the impact and the kind they value it. Something about that. Or if they talk too much about them versus the team, et cetera. So you get a lot from that question. It's a loaded question.

**中文翻译:**
“你最引以为豪的是什么？”这是一个很好的面试问题。告诉我一件让你最自豪的事情。你最自豪的职业成就是什么？因为这能告诉你他们如何衡量自己的影响力，能告诉你很多关于他们在乎什么、如何衡量价值的信息。如果他们说：“作为 PM，我发布了某某功能”，他们是在谈论影响力以及他们看重的价值。或者如果他们过多地谈论自己而不是团队等等。你能从这个问题中获得很多信息，这是一个信息量很大的问题。

---

### [01:01:24] Lenny

**English:**
Amazing. I love that question. Okay. Where can folks find you online and how can people listening be helpful to you?

**中文翻译:**
太棒了，我喜欢这个问题。好。大家可以在哪里找到你？听众们可以如何帮助你？

---

### [01:01:31] Gokul Rajaram

**English:**
I am on Twitter, G-O-K-U-L-R at GokulR on Twitter. And I always say the best way to help me, just help the broader ecosystem. Pay it forward, and if you pay it forward, at some point, whoever you paid forward helps me at some point. But if all of us paid it forward, the world would be a better place. Pay it forward. And then, like I said at the very beginning, believe in the power of serendipity, and I need to listen to Lenny's TED talk on that.

**中文翻译:**
我的 Twitter 账号是 @GokulR。我总是说，帮助我最好的方式就是去帮助更广泛的生态系统。回馈社会（Pay it forward），如果你这样做，在未来的某个时刻，你帮助过的人也可能会在某个时刻帮助到我。如果我们每个人都回馈社会，世界会变得更美好。回馈社会吧。然后，就像我一开始说的，相信机缘巧合的力量，我也得去听听 Lenny 关于这个的 TED 演讲。

---

### [01:01:58] Lenny

**English:**
Oh boy.

**中文翻译:**
噢天哪。

---

### [01:01:59] Gokul Rajaram

**English:**
Serendipity, paying it forward.

**中文翻译:**
机缘巧合，回馈社会。

---

### [01:02:01] Lenny

**English:**
Great way to wrap it up. Thank you so much for being here. Gokul.

**中文翻译:**
非常完美的总结。非常感谢你能来，Gokul。

---

### [01:02:05] Gokul Rajaram

**English:**
Thank you, Lenny. Thanks for having me.

**中文翻译:**
谢谢你，Lenny。感谢邀请。

---

### [01:02:06] Lenny

**English:**
That was awesome. Thank you for listening. If you enjoyed the chat, don't forget to subscribe to the podcast. You could also learn more at Lenny's podcast dot com. I'll see you in the next episode.

**中文翻译:**
太棒了。感谢大家的收听。如果你喜欢这次聊天，别忘了订阅播客。你也可以在 lennyspodcast.com 了解更多信息。我们下期节目再见。