# Graham Weaver - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Graham Weaver.

---

### [00:00:00] [Lenny Rachitsky]

**English:**
You are ostensibly a professor at Stanford Graduate School of Business, and you shared that when people come ask you for advice, the most common question you get is, "What should I do with my life?"

**中文翻译:**
表面上，你是斯坦福大学商学院的一名教授。你曾分享过，当人们来向你寻求建议时，你收到的最常见的问题是：“我这辈子该做些什么？”

---

### [00:00:10] [Graham Weaver]

**English:**
Imagine that you're walking home from work, you see this bright, shiny object, and you realize it's a magic lamp. And you rub the lamp and this genie comes out and the genie says, "Hey, I can give you one wish. Whatever you throw yourself into with your whole life and your career, it's going to turn out great." If that were true and you had that genie, what would you wish for? At some point in this one life we get, you want to get yourself on that path of that journey.

**中文翻译:**
想象一下，你下班走路回家，看到一个闪闪发光的东西，你意识到那是一个神灯。你摩擦神灯，一个精灵跳了出来说：“嘿，我可以满足你一个愿望。无论你这一生投入到什么事业中，结果都会非常棒。”如果这是真的，而你拥有那个精灵，你会许什么愿？在我们仅有的一次生命中，在某个时刻，你应该让自己踏上那条旅程。

---

### [00:00:35] [Lenny Rachitsky]

**English:**
This whole exercise connects to something that you're a big advocate of, this idea of getting out of autopilot mode in your life.

**中文翻译:**
这整个练习和你一直倡导的一个观点有关，那就是：让生活脱离“自动驾驶模式”。

---

### [00:00:40] [Graham Weaver]

**English:**
You're unconscious, and you may not even realize why you're doing what you're doing or even realize what you're doing. So for example, I get up, work out, drive into work, fight traffic, commute, maybe I return some emails, fight traffic on the way home, rush through dinner, go to bed. It's not a day that is intentional. It's not a day where I've said, "Where do I want to be going with my life? What's important to me in this world?"

**中文翻译:**
你处于一种无意识的状态，你甚至可能没有意识到自己为什么要这么做，或者根本没意识到自己在做什么。例如，我起床、锻炼、开车上班、在拥堵的交通中挣扎、通勤，也许回几封邮件，回家路上再次堵车，匆忙吃完晚饭，然后睡觉。这不是有意识的一天。在这一天里，我没有问过自己：“我希望我的生活走向何方？在这个世界上，什么对我来说才是重要的？”

---

### [00:01:02] [Lenny Rachitsky]

**English:**
You another quote, which is, "Everything that you want is on the other side of worse first."

**中文翻译:**
你还有另一句名言：“你想要的一切，都在‘先变糟’的另一面。”

---

### [00:01:07] [Graham Weaver]

**English:**
Pick anything. You want a better body? Okay, you're going to need to go to the gym. When you go to the gym the first few times, it's going to not be that fun. The first move is negative. If I'm optimizing for tomorrow and I just want to have a great day tomorrow, I'm going to stay exactly where I am. So many people I see have this happen, where they hit a plateau and they never move past it, because they're not willing to have that hard day, month, week, year.

**中文翻译:**
随你挑。想要更好的身材？好，你需要去健身房。刚开始去的那几次，过程并不会很有趣。第一步往往是负面的体验。如果我只为了明天而优化，只想明天过得开心，那我就会待在原地不动。我看到很多人都是这样，他们遇到了瓶颈，却永远无法突破，因为他们不愿意经历那段艰难的日子、月份、星期甚至年份。

---

### [00:01:35] [Lenny Rachitsky]

**English:**
When should you quit something, because some things are just not worth it.

**中文翻译:**
什么时候应该放弃呢？因为有些事情确实不值得坚持。

---

### [00:01:37] [Graham Weaver]

**English:**
I think the time to quit is when you can no longer ...

**中文翻译:**
我认为放弃的时机是当你不再能……

---

### [00:01:44] [Lenny Rachitsky]

**English:**
Today, my guest is Graham Weaver. Graham teaches a top-rated course at Stanford's Graduate School of Business, a course which is technically called Managing Growing Enterprises. But as you'll hear in our conversation, he ends up mostly helping students figure out what to do with their lives and how to get out of the autopilot mode that most people are in. He recently won Stanford Graduate Business School's 2024 MBA Distinguished Teaching Award. And teaching is actually his side gig. His full-time job is founder and CEO of Alpine Investors, a private equity firm, which based on my research, is one of if not the top-performing private equity fund in the world. So the advice you're going to hear today is coming from someone who is actually doing the thing, not just teaching the thing.

**中文翻译:**
今天的嘉宾是 Graham Weaver。Graham 在斯坦福商学院教授一门评价极高的课程，课程名称是《管理成长型企业》。但正如你在我们的对话中听到的，他最终主要是在帮助学生弄清楚这辈子该做什么，以及如何摆脱大多数人所处的“自动驾驶模式”。他最近获得了斯坦福商学院 2024 年度 MBA 杰出教学奖。而教学其实只是他的副业。他的全职工作是 Alpine Investors 的创始人兼 CEO，这是一家私募股权公司。根据我的研究，它是世界上表现最好（如果不是第一的话）的私募股权基金之一。所以，你今天听到的建议来自一个真正实干的人，而不仅仅是一个教书的人。

---

### [00:02:28] [Lenny Rachitsky]

**English:**
In our conversation, we cover practical exercises that can help you figure out what you should do with your life, including something he calls the genie framework and the nine lives exercise. We talk about why life is suffering, and you may as well choose something worth suffering for, also, why most things in life that are worthwhile take more time than you expect, some practical advice for creating accountability in your life to help you achieve your goals, and so much more.

**中文翻译:**
在我们的对话中，我们涵盖了一些可以帮助你弄清楚人生方向的实践练习，包括他所谓的“精灵框架”和“九条命”练习。我们讨论了为什么生活就是受苦，既然如此，你不如选择一些值得为之受苦的事情；还讨论了为什么生活中大多数有价值的事情花费的时间都比你预期的要长；以及一些在生活中建立问责机制以帮助你实现目标的实用建议，等等。

---

### [00:02:53] [Lenny Rachitsky]

**English:**
If you listen to this episode and actually try some of the exercises that Graham shares, I promise you that your life and your future will be better off. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes, and it helps the podcast tremendously. With that, I bring you Graham Weaver.

**中文翻译:**
如果你听了这一集并真正尝试 Graham 分享的一些练习，我保证你的生活和未来会变得更好。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对本播客有巨大的帮助。下面，让我们欢迎 Graham Weaver。

---

### [00:03:16] [Lenny Rachitsky]

**English:**
This episode is brought to you by Merge. Product leaders, yes, like you, cringe when they hear the word integration. They're not fun for you to scope, build, launch, or maintain, and integrations probably aren't what led you to product work in the first place. Lucky for you, the folks at Merge are obsessed with integrations. Their single API helps SaaS companies launch over 200 product integrations in weeks, not quarters. Think of Merge like Plaid, but for everything B2B SaaS. Organizations like Ramp, Dorada and Electric use Merge to access their customers' accounting data to reconcile bill payments, file storage data to create searchable databases in their product, or HRAS data to auto-provision and deprovision access for their customers' employees. And yes, if you need AI-ready data for your SaaS product, then Merge is the fastest way to get it. So want to solve your organization's integration dilemma once and for all? Book and attend a meeting at merge.dev/lenny, and receive a $50 Amazon gift card. That's merge.dev/lenny.

**中文翻译:**
本集节目由 Merge 赞助。产品负责人，没错，就像你一样，听到“集成”这个词就会感到头大。确定范围、构建、发布或维护集成对你来说毫无乐趣，而且集成可能根本不是你最初从事产品工作的初衷。幸运的是，Merge 的团队对集成非常痴迷。他们的单一 API 可以帮助 SaaS 公司在几周内（而不是几个季度）发布超过 200 个产品集成。把 Merge 想象成 B2B SaaS 领域的 Plaid。像 Ramp、Dorada 和 Electric 这样的组织使用 Merge 来访问客户的会计数据以对账账单支付，访问文件存储数据以在产品中创建可搜索的数据库，或访问 HRIS 数据以为客户员工自动分配和取消访问权限。是的，如果你的 SaaS 产品需要 AI 就绪的数据，Merge 是获取数据的最快方式。想一劳永逸地解决组织的集成难题吗？在 merge.dev/lenny 预约并参加会议，即可获得 50 美元的亚马逊礼品卡。地址是 merge.dev/lenny。

---

### [00:04:23] [Lenny Rachitsky]

**English:**
This episode is brought to you by Persona, the adaptable identity platform that helps businesses fight fraud, meet compliance requirements, and build trust. While you're listening to this right now, how do you know that you're really listening to me, Lenny? These days, it's easier than ever for fraudsters to steal PII, faces and identities. That's where Persona comes in. Persona helps leading companies like LinkedIn, Etsy and Twilio securely verify individuals and businesses across the world. What sets Persona apart is its configurability. Every company has different needs depending on its industry, use cases, risk tolerance and user demographics. That's why Persona offers flexible building blocks that allow you to build tailored collection and verification flows that maximize conversion while minimizing risks. Plus, Persona's orchestration tools automate your identity process so that you can fight rapidly shifting fraud and meet new waves of regulation. Whether you're a startup or an enterprise business, Persona has a plan for you. Learn more at withpersona.com/lenny; again, that's withpersona.com/lenny.

**中文翻译:**
本集节目由 Persona 赞助，这是一个灵活的身份平台，可帮助企业打击欺诈、满足合规要求并建立信任。当你现在听这段话时，你怎么知道真的是我 Lenny 在说话？如今，诈骗者比以往任何时候都更容易窃取个人身份信息 (PII)、面部信息和身份。这就是 Persona 的用武之地。Persona 帮助 LinkedIn、Etsy 和 Twilio 等领先公司安全地验证全球范围内的个人和企业。Persona 的独特之处在于其可配置性。每家公司根据其行业、用例、风险承受能力和用户群体都有不同的需求。这就是为什么 Persona 提供灵活的构建模块，允许你构建量身定制的收集和验证流程，在最大限度提高转化率的同时最大限度降低风险。此外，Persona 的编排工具可以自动化你的身份流程，以便你应对快速变化的欺诈并满足新的监管浪潮。无论你是初创公司还是大型企业，Persona 都有适合你的方案。欲了解更多信息，请访问 withpersona.com/lenny；重复一遍，是 withpersona.com/lenny。

---

### [00:05:35] [Lenny Rachitsky]

**English:**
Graham, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Graham，非常感谢你能来。欢迎来到本播客。

---

### [00:05:38] [Graham Weaver]

**English:**
Thanks so much for having me, Lenny. I'm super excited to be here.

**中文翻译:**
非常感谢你的邀请，Lenny。我非常兴奋能来到这里。

---

### [00:05:40] [Lenny Rachitsky]

**English:**
Okay, so you are ostensibly a professor at Stanford Graduate School of Business, of a class called Managing Growing Enterprises. But I was reading an interview with you, and you shared that when people come ask you for advice, they're not asking, "How do I start a company? How do I manage my growing enterprise? How do I make my company grow faster?" Most of the questions, the most common question you get, which is surprising to me, is, "What should I do with my life?" First of all, is that accurate?

**中文翻译:**
好的，表面上你是斯坦福商学院一门名为《管理成长型企业》课程的教授。但我读过你的一个采访，你分享说，当人们来向你寻求建议时，他们问的不是“我该如何创办公司？”“我该如何管理我的成长型企业？”或者“我该如何让我的公司增长得更快？”大多数问题，或者说你收到的最常见的问题——这让我很惊讶——是：“我这辈子该做些什么？”首先，这准确吗？

---

### [00:06:10] [Graham Weaver]

**English:**
Yeah, that is accurate. About half of all the times I meet with students, that's the question they ask. It's really funny too, because sometimes they'll come with a PowerPoint presentation and a two-by-two matrix and an expected value and all that. But really they're asking the question of, "Hey, what should I do with my life," which is, by the way, a great question.

**中文翻译:**
是的，很准确。在我与学生见面的时间里，大约有一半时间他们问的就是这个问题。这很有趣，因为有时他们会带着 PPT 演示文稿、二乘二矩阵和期望值计算等等过来。但实际上他们问的是：“嘿，我这辈子该做什么？”顺便说一下，这是一个非常棒的问题。

---

### [00:06:29] [Lenny Rachitsky]

**English:**
Why do you think that's the case? That's not what I would imagine someone at an MBA school in a business class asking for advice on.

**中文翻译:**
你认为为什么会这样？这可不是我能想象到的 MBA 学生在商学课上会寻求建议的话题。

---

### [00:06:36] [Graham Weaver]

**English:**
My typical meeting with a student will say, the student will start to tell me about these two or three different career or job alternatives that they have, A, B and C. Let's just use two, A and B. And then they go through and they start talking about A, and they tell me all the pros and the cons of A, and they go through it. And then they go through B, and they start telling me all those things. And I start asking some questions. After about five or 10 minutes into that, I can tell that their heart and their soul and their energy is really for B. That's really what they want, but they're talking themselves out of B, and they're going to talk themselves into A. So what I try to do is, A, first, I try to let them realize that their real energy is for B, just let them feel that and understand that. And then secondly, I try to figure out, what are the limiting beliefs they have? What are the fears? What are the obstacles? What are the voices in their head? What are all the societal pressures that are keeping them from doing B? And then we try to deconstruct those and get them to go do B. So that's the process.

**中文翻译:**
我与学生的典型会面通常是这样的：学生开始告诉我他们面临的两三个不同的职业或工作选择，A、B 和 C。我们就以 A 和 B 为例。然后他们开始谈论 A，告诉我 A 的所有优缺点。接着谈论 B，也列举同样的内容。然后我开始问一些问题。大约五到十分钟后，我就能感觉到他们的心、灵魂和能量其实都在 B 上。那才是他们真正想要的，但他们正在试图说服自己放弃 B，转而接受 A。所以我尝试做的是：第一，让他们意识到自己真正的能量在 B 上，让他们感受到并理解这一点。第二，我尝试找出他们有哪些“限制性信念”？恐惧是什么？障碍是什么？他们脑海中的声音是什么？有哪些社会压力阻碍了他们选择 B？然后我们尝试解构这些因素，促使他们去选择 B。这就是整个过程。

---

### [00:07:41] [Lenny Rachitsky]

**English:**
Is there an example of a student going ... just this actual conversation you had with someone?

**中文翻译:**
有没有具体的例子……就是你和某人进行的这种真实对话？

---

### [00:07:45] [Graham Weaver]

**English:**
Absolutely. So there's a great example of a student of mine was from Brazil. And he came in and his prior job prior to business school was he worked in consulting. And that was more or less what he wanted to do. And then at some point I asked the students, "Okay, imagine you knew you were going to be successful and you were going to have a dream. And whatever you dreamed was going to come true, what would you dream for?" And he wanted to start a nonprofit in his home country of Brazil to help students have more access to education. That was what came up for him. And over the course of our class, we just chipped away at all the fears and limiting beliefs of why he shouldn't or couldn't do that. And by the end, that's what he did. And so that's a real life example. And there's all kinds of other examples, but that second one of going and starting a charity, it's not on the beaten path. It's not what probably your parents are thinking you should do. There's probably 100 reasons not to do it. You probably don't know exactly how to start, and so it's intimidating. But if you start with this idea, "Hey, five years out, 10 years out, I know I'm going to be successful," and work backwards from that, you're going to come up with a better answer.

**中文翻译:**
当然有。我有一个非常棒的学生例子，他来自巴西。他在读商学院之前的职业是咨询。那基本上也是他原本打算继续做的事情。在某个时刻，我问学生们：“好，想象一下，如果你知道自己一定会成功，如果你有一个梦想，而且无论你梦到什么都会成真，你会梦想什么？”他想在祖国巴西创办一家非营利组织，帮助学生获得更多受教育的机会。这就是他内心深处的想法。在我们的课程中，我们一点点消除了他认为自己不该做或不能做这件事的所有恐惧和限制性信念。到课程结束时，他真的去做了。这是一个真实的例子。还有各种各样的例子，但像创办慈善机构这种选择，并不是一条常规的道路。这可能不是你父母认为你应该做的事。可能有 100 个理由不去尝试。你可能不知道具体该如何开始，所以这很令人畏惧。但如果你从这个想法开始——“嘿，5 年后、10 年后，我知道我会成功”——并以此进行倒推，你会得到一个更好的答案。

---

### [00:09:07] [Lenny Rachitsky]

**English:**
This is a framework that you call the genie methodology or the genie framework, this question that you just asked that we should spend more time on, which is ... I guess, you tell the story of the genie and how to think about this [inaudible 00:09:20].

**中文翻译:**
这就是你所谓的“精灵方法论”或“精灵框架”，也就是你刚才问的那个问题。我觉得我们应该多花点时间讨论这个……我想，你可以讲讲那个关于精灵的故事，以及如何思考这个问题。

---

### [00:09:19] [Graham Weaver]

**English:**
Well, when I was 13 years old, I used to listen to these motivational tapes, mowing lawns. And I'm pretty sure it was Brian Tracy had this exercise. And I've adapted it, so I'll use my exercise now. So I say basically imagine that you're walking home from work and you see this bright, shiny object. You walk over and you realize it's a magic lamp. And you rub the lamp and this genie comes out and the genie says, "Hey, I haven't been in this bottle for 10,000 years yet, so I'm not fully formed. So I can't give you three wishes. But what I can do is I can give you one wish. And the wish I can give you is whatever you throw yourself into with your whole life and your career, it's going to turn out great. It's going to work out great. It's probably going to take longer than you think. It's going to be harder than you think, but you're going to be really happy you did and it's going to work out beyond your wildest imagination." If that were true and you had that genie blessing you with that wish, what would you wish for? And then the students come up with an answer that's really close to their heart. It's a thing they would do, absent the fear of failure. And then the second part of the exercise is basically that's what you should go do. You should be spending your life in pursuit of your genie goal. Maybe you can't start that tomorrow; you have financial obligations, maybe there's some experience you need. But at some point in this one life we get, you want to get yourself on that path of that journey. And that's the exercise that I go through with the students.

**中文翻译:**
嗯，我 13 岁的时候，常一边割草一边听励志磁带。我记得 Brian Tracy 有过这样一个练习。我把它改编了一下，现在我用我自己的版本。我基本上是说：想象你下班回家，看到一个闪闪发光的东西。你走过去，发现它是一个神灯。你摩擦神灯，精灵出来了，精灵说：“嘿，我还没在瓶子里待够一万年，所以我还没完全成形。我不能给你三个愿望。但我能做的是给你一个愿望。这个愿望就是：无论你这一生和职业生涯投入到什么事情中，结果都会非常棒。它会进展得很顺利。它花费的时间可能会比你想象的要长，过程会比你想象的要难，但你会非常庆幸自己做了这件事，而且结果会超出你最疯狂的想象。”如果这是真的，而且你有精灵的祝福，你会许什么愿？然后学生们会给出一个非常贴近内心的答案。那是他们在没有失败恐惧的情况下会去做的事。练习的第二部分基本上就是：那就是你应该去做的事。你应该用一生去追求你的“精灵目标”。也许你明天不能马上开始，你有财务负担，或者需要一些经验。但在我们仅有的一次生命中，在某个时刻，你要让自己踏上那段旅程。这就是我带学生做的练习。

---

### [00:10:56] [Lenny Rachitsky]

**English:**
It's such a simple idea, that I can totally see how it could be so powerful. And I love the way it's framed as not like it'll guarantee you'll be successful. It's instead, I'll guarantee you'll be happy.

**中文翻译:**
这是一个非常简单的想法，但我完全能看出它为何如此强大。我非常喜欢它的设定方式——它不是保证你一定会成功，而是保证你会感到幸福。

---

### [00:11:09] [Graham Weaver]

**English:**
You'll be happy that you took the path. And the reason I say that is that usually the genie goal is the not well-trodden path. So you don't even know exactly what the goal is. This charity to start education for underprivileged kids in Brazil, that takes its own form over the course of a decade. And it will almost certainly turn out differently than you think. So it's more that you'll be really happy you went and started that journey, and it will go great. It'll probably go differently and take longer than you think though.

**中文翻译:**
你会因为踏上了这条路而感到幸福。我之所以这么说，是因为“精灵目标”通常不是一条常人走的路。所以你甚至不知道目标具体长什么样。比如在巴西创办那个帮助贫困儿童教育的慈善机构，在十年的时间里，它会演变成它自己的样子。而且结果几乎肯定会和你想象的不同。所以更多的是，你会非常庆幸自己开启了那段旅程，而且结果会很棒。尽管它可能与你的预期不同，且花费更长的时间。

---

### [00:11:46] [Lenny Rachitsky]

**English:**
What are some other examples of genie goals folks have followed that are kind of non-traditional and they've ended up being happy about it?

**中文翻译:**
还有哪些人们追求的“精灵目标”的例子？那些非传统的，且最终让他们感到幸福的例子。

---

### [00:11:52] [Graham Weaver]

**English:**
Mine was buying companies in my dorm room at business school. I have a student who's starting an amusement park in Texas. That's a pretty crazy example. Many students who are leaving their job and doing startups. A lot of students who going in the nonprofit world. So really just lots of examples. It's as variant as the number of students I have. And that's the magic of it, because you have inside of you some really unique dream that you maybe haven't even shared. And the goal is that that's your uniqueness, and that's what you should be bringing into this world.

**中文翻译:**
我自己的目标是读商学院时在宿舍里收购公司。我有一个学生正在德克萨斯州创办一个游乐园，这是一个相当疯狂的例子。还有很多学生辞职去创业，或者投身非营利组织。例子真的很多，就像我的学生人数一样多样化。这就是它的魔力所在，因为你内心深处有一些非常独特的梦想，也许你从未分享过。而目标就是发掘你的独特性，并将其带到这个世界上。

---

### [00:12:37] [Lenny Rachitsky]

**English:**
This whole exercise connects to something that you're a big advocate of, this idea of getting out of autopilot mode in your life. And the way I think about it is people ... and I'm going to ask you to describe it, but just it's almost like you're driving and you've never turned off the cruise control in your car, and you don't realize it. Talk about this idea that most of us are in autopilot and why it's so important to realize that and get out of it.

**中文翻译:**
整个练习和你倡导的另一个观点有关，即摆脱生活中的“自动驾驶模式”。我的理解是……我想请你描述一下，但这就像你在开车，却从未关掉定速巡航，而你甚至没有意识到这一点。谈谈大多数人处于“自动驾驶”状态的这个想法，以及为什么意识到并摆脱它如此重要。

---

### [00:13:00] [Graham Weaver]

**English:**
You start off and you're unconscious, and you're kind of going through the motions. And you may not even realize why you're doing what you're doing or even realize what you're doing. So for example, a typical person gets up, they have whatever their morning routine ... I'll use myself. I get up out, work out, take a shower, drive into work, fight traffic, commute. I'm late. I get in, I'm late to a meeting, I'm kind of rushed meeting; meeting, meeting. Okay, quick break for lunch. Maybe I return some emails; a few more meetings, a couple of Zoom calls. Fight traffic on the way home, rush through dinner, get back on email. Go to bed. Okay, that's my day. And that's a busy day. I felt like I did a lot. I'm exhausted, but it's unconscious. It's not a day that is intentional. It's not a day where I've said, "Where do I want to be going with my life? What's important to me in this world? What are my values? What 10 years from now will I wish I was starting to embark on?" Adding that level of intentionality and then working backwards from that is really the magic of getting to that 10 years from now and looking back without regret and getting to a later point in your life and feeling like you're doing the thing you're put on the earth to do as opposed to just going through the motions.

**中文翻译:**
你一开始是无意识的，只是在机械地应付。你可能甚至没意识到自己为什么要这么做，或者根本没意识到自己在做什么。例如，一个典型的人起床，进行晨间例行公事……以我为例。我起床、锻炼、洗澡、开车上班、在车流中挣扎、通勤。我迟到了。我进公司，开会迟到，匆忙开会；一个接一个的会。好，午饭休息一下。也许回几封邮件；再开几个会，打几个 Zoom 电话。回家路上继续堵车，匆忙吃完晚饭，重新开始回邮件。睡觉。好，这就是我的一天。这是忙碌的一天。我觉得自己做了很多事。我很疲惫，但这是无意识的。这不是有意识的一天。在这一天里，我没有问过：“我希望我的生活走向何方？在这个世界上，什么对我来说是重要的？我的价值观是什么？十年后，我会希望自己现在开始着手做什么？”增加这种程度的“意图性”（intentionality），然后以此进行倒推，这才是真正的魔力所在。这样当你十年后回首往事时，才不会感到遗憾；当你步入人生后期时，会觉得自己在做来到这个世界上该做的事，而不是仅仅在机械地应付生活。

---

### [00:14:22] [Lenny Rachitsky]

**English:**
So the question then here is, how do you get out of that autopilot mode? Because first of all, no one really realizes this is the case. And I'll tell a quick story. We're going to different preschools and daycares for our son. He's a year and a half oldish. And we went to this Montessori school, and the teacher's like, "I'm going to be very clear: what we're doing here is informing your child's subconscious. That's what they're learning here. And that's a huge responsibility. We put a lot of love into that idea, but it's very important you understand that's what we do at the school." And I never thought of it that way.

**中文翻译:**
那么问题来了，如何摆脱这种“自动驾驶模式”？因为首先，没有人真正意识到自己处于这种状态。我讲个小故事。我们正在为儿子找幼儿园和托儿所，他大约一岁半。我们去了一家蒙特梭利学校，老师说：“我要明确一点：我们在这里做的是塑造你孩子的潜意识。这就是他们在这里学习的内容。这是一份巨大的责任。我们在这个理念中投入了很多爱，但非常重要的一点是，你要理解这就是我们在学校所做的。”我以前从未从这个角度思考过。

---

### [00:14:56] [Graham Weaver]

**English:**
That's amazing that they said that. So you just opened up another part of this, which is depending on what research you read, somewhere between 95% and 98% of our thoughts are subconscious. And those get programmed in somehow, some way. A big part of that, by the way, is media, our friends, our parents, our boss, our coworkers, what we think we're supposed to do, social media: "This is cool, buy this Ferrari," all these different things. And then you're just operating out of that. And so the idea of being intentional is create space, get out of that, get out of the fog of war, make some space. We'll probably get to this in a little bit, but I do it with an executive coach, and really ask deep questions, make space, ask questions, create the intention that you want in each of the areas of your life. And then start having your calendar reflect that intention.

**中文翻译:**
他们能这么说真是太棒了。你刚刚开启了话题的另一部分，即根据你所读的研究，我们大约 95% 到 98% 的想法都是潜意识的。这些想法通过某种方式被编程进大脑。顺便说一下，很大一部分来自媒体、朋友、父母、老板、同事，以及我们认为“应该”做的事，还有社交媒体：“这很酷，买这辆法拉利吧”，诸如此类。然后你就只是在这些设定的基础上运作。所以，“有意识”的理念就是创造空间，摆脱那种状态，走出“战争迷雾”，腾出一些空间。我们稍后可能会谈到这一点，但我会和高管教练一起做这件事，真正提出深度的问题，腾出空间，提问，在你生活的每个领域建立你想要的意图。然后开始让你的日程表反映出这些意图。

---

### [00:15:58] [Lenny Rachitsky]

**English:**
And so this genie exercise is one approach, is just ask yourself this question. Can you say it again just for folks so they don't miss it, what's the question you should ask yourself?

**中文翻译:**
所以这个“精灵练习”是一种方法，就是问自己那个问题。你能为听众再重复一遍吗，以免他们错过，那个应该问自己的问题是什么？

---

### [00:16:08] [Graham Weaver]

**English:**
I mean, the biggest question I think with respect to your career is, within reason, what would you do if you knew you wouldn't fail? That's the biggest question. I'll give you a few more if you want.

**中文翻译:**
我的意思是，关于职业生涯，我认为最大的问题是：在合理的范围内，如果你知道自己不会失败，你会做什么？这是最核心的问题。如果你愿意，我还可以再给你几个。

---

### [00:16:24] [Lenny Rachitsky]

**English:**
Yeah, please.

**中文翻译:**
好啊，请讲。

---

### [00:16:26] [Graham Weaver]

**English:**
Different questions trigger different things with people that could be helpful, trigger in a good way. So here's a few more. If you didn't have to make money, what would you do? And that'll answer what you enjoy. Naval Ravikant has a great question, which is, what's play for you that is work for other people? So for you, Lenny, that might be a podcast. That might be play for you; that's really fun. You're always going to do better at that. You're going to spend more time, you're going to enjoy it more. That's a good one. Another one is, what's the thing you really want to do? But you're just too embarrassed to say it? And my answer to this question was that I wanted to be a motivational speaker like Tony Robbins. And I was super embarrassed to say that, but that actually works into a lot of my life at this point. Another question, who are some people that you admire and want to be more like, and what do they do? Where do you find those people? What are some things you want to learn and how do you want to grow over the next five, 10 years? So I know a lot of your listeners are working in tech. So five, 10 years from now, you're amazing, you're best in the world at X. What's X? And how do you start to work toward becoming great at X? So there's just a few more other questions you could throw in to help you figure out some things you're excited about.

**中文翻译:**
不同的问题会触发人们不同的思考，这很有帮助，是一种积极的触发。这里还有几个：如果你不需要为了赚钱而工作，你会做什么？这会回答你真正享受什么。Naval Ravikant 有一个很棒的问题：什么是对你来说像玩耍，但对别人来说是工作的事情？比如对你来说，Lenny，可能就是做播客。这对你来说可能是玩耍，非常有趣。你在这方面总是会做得更好，你会花更多时间，也会更享受其中。这是一个好问题。另一个是：什么是你真正想做，但又太不好意思说出口的事？我对这个问题的答案是，我想成为像 Tony Robbins 那样的励志演说家。我当时超级不好意思说出来，但实际上这已经融入了我现在生活的很大一部分。还有一个问题：你钦佩哪些人，想变得更像他们？他们是做什么的？你在哪里能找到这些人？在接下来的 5 到 10 年里，你想学习什么，想如何成长？我知道你的很多听众都在科技行业工作。那么 5 到 10 年后，你在某项技能 X 上变得非常出色，甚至是世界顶尖。X 是什么？你如何开始努力成为 X 领域的佼佼者？这些都是你可以用来帮助自己弄清楚兴奋点的问题。

---

### [00:17:55] [Lenny Rachitsky]

**English:**
You mentioned this idea of limiting beliefs. And I think a lot of people listening to this are probably having these beliefs right now of, "Okay, but I have a family to support. Am I going to go start a charity in Brazil? That's absurd. It sounds easy, but I can't actually change my life this radically." Can you just share something to help people get past that in some way?

**中文翻译:**
你提到了“限制性信念”这个概念。我想很多听众现在可能就有这种信念：“好吧，但我有家庭要养。难道我要去巴西创办慈善机构吗？这太荒谬了。听起来容易，但我实际上无法如此彻底地改变我的生活。”你能分享一些东西，帮助人们在某种程度上克服这种想法吗？

---

### [00:18:14] [Graham Weaver]

**English:**
Sure. The first thing I would say about limiting beliefs is they're the most powerful and the most dangerous when you don't even know what they are. So when they're in the recesses of your subconscious mind, that is 95% of your thoughts, that's when the limiting beliefs are the most dangerous. So a simple example might just be like I have a limiting belief that I'm not funny. That's in my subconscious and I don't even realize I have it. So I avoid things where I'm trying to be funny or tell jokes. I mean, that's a silly example. But let's use your career now and come up with some maybe deeper ones. Let's use that charity example, the Brazilian charity, "I'm going to start a Brazilian charity." What are the limiting beliefs? Well, oh my gosh, there's a million. "I don't know how to start. I don't know how I would pay for myself. I have business school debt. I don't really know what I'm even talking about. I don't even have a plan for it. How would I get funding?" Those are all these things that are flooding your mind. So the first exercise is just write all that down. Just get it down on paper, and then two things will happen. One is when you get it down on paper, it will almost immediately strip that limiting belief of a lot of its power and a lot of its scariness. Because now it's just something like, for example, "How would I fund this?" So the second thing that is that a lot of that scariness becomes just a to-do item. In the recesses of your subconscious, that is a very scary, limiting belief that will actually keep you from doing the thing you love. Once it's on paper, now it's just a to-do item that you can actually deal with with your conscious mind, just like you do anything else. So, "How would I fund this," just becomes a plan, like, "I need to design a plan where I'd get funding for this charity." And then that just is a problem like any other problem. It's not this nebulous, scary fear. It's just literally a to-do item. So the first part of limiting beliefs, write them down, understand what they are, look at them in the cold day of light on paper, and then translate them into things that are just obstacles to be overcome. And by the way, if you're listening to this podcast, you've overcome millions of obstacles in your life, and these are no different once they're down on paper.

**中文翻译:**
当然可以。关于限制性信念，我想说的第一点是，当你甚至不知道它们是什么时，它们是最强大也最危险的。当它们潜伏在你潜意识的深处（占你思想的 95%）时，限制性信念的危害最大。举个简单的例子，我可能有一个限制性信念，觉得我不幽默。这在我的潜意识里，我甚至没意识到。所以我避开那些需要幽默或讲笑话的场合。这只是个傻例子。但让我们看看职业生涯，找一些更深层次的。以那个巴西慈善机构为例，“我要创办一个巴西慈善机构”。限制性信念是什么？天哪，有无数个。“我不知道如何开始。我不知道怎么养活自己。我有商学院的贷款。我甚至不知道自己在说什么。我根本没有计划。我该如何获得资金？”这些念头会涌入你的脑海。所以第一个练习就是：把这些全部写下来。写在纸上，然后会发生两件事。第一，当你把它写在纸上时，它几乎会立即剥夺那个限制性信念的大部分力量和恐惧感。因为它现在变成了一个具体的问题，比如“我该如何资助这个项目？”第二，很多恐惧感会转化为一个“待办事项”。在潜意识深处，它是一个非常可怕的限制性信念，会阻碍你去做热爱的事。一旦写在纸上，它就成了一个你可以用显意识去处理的待办事项，就像处理其他任何事情一样。所以，“我该如何资助这个项目”就变成了一个计划，比如“我需要设计一个方案来为这个慈善机构筹集资金”。然后这就成了一个普通的问题。它不再是那种模糊、可怕的恐惧，而是一个实实在在的待办事项。所以，处理限制性信念的第一步：写下来，理解它们是什么，在光天化日之下审视纸上的它们，然后把它们转化为需要克服的障碍。顺便说一句，如果你在听这个播客，你这辈子已经克服了无数障碍，一旦写在纸上，这些障碍也没什么不同。

---

### [00:20:34] [Lenny Rachitsky]

**English:**
Are you actually doing these exercises with your students? They're taking a class about growing their enterprise and then it's like, "Okay, let's analyze what you want to do with your life"? Is that how this class goes?

**中文翻译:**
你真的在和学生一起做这些练习吗？他们选了一门关于企业成长的课，然后你说：“好吧，让我们分析一下你这辈子想做什么”？这门课就是这么上的吗？

---

### [00:20:42] [Graham Weaver]

**English:**
That's a really good question. So I'll give you a little bit of background. So I was a case guest at Stanford Business School while I was buying companies in my dorm room. And it was talking about all the things that went wrong. And so it's kind of a really fun case. And I did that for 12 years. And I started to realize that was my most energetic day of the year. And so long story short, I started teaching a class full time. So I did that for four years. And I was teaching the Xs and Os of being a CEO, basically: hiring, firing, having hard conversations, managing a board, fundraising, selling, all the things you would imagine that a young CEO would need to know. After about four years, I started to realize that was great, except that no one went and did it. So the class is on entrepreneurship, and they learned how to be an entrepreneur. There was only one problem: they didn't actually become entrepreneurs. So then I said, "Well, wait a sec. I have to readjust my class a little bit, and I have to spend some time on the stuff we've just been talking about: finding out what your dream is, your limiting beliefs, starting to map out goals toward your actual entrepreneurship dream or whatever your genie goal is." So the way I say it is the university allows me to teach the class because I teach them entrepreneurial tricks, tactics, tools that will help them become a great CEO. But the real reason I teach is because I'm trying to help people really go find the thing that they're excited about and get into the life path of doing that thing. So I do both, but I do the second one kind of ... maybe that's not the headline of the course, although I think that's probably why people like the course so much.

**中文翻译:**
这是一个非常好的问题。我给你讲点背景。当我还在宿舍里收购公司时，我是斯坦福商学院的一个案例嘉宾。那个案例讲的是所有出错的事情，非常有趣。我做了 12 年案例嘉宾。我开始意识到，那是我一年中精力最充沛的一天。长话短说，我开始全职教课。我教了四年，教的是成为 CEO 的基本功（Xs and Os）：招聘、解雇、进行艰难的对话、管理董事会、融资、销售，所有你能想象到的年轻 CEO 需要知道的事情。大约四年后，我开始意识到，这虽然很好，但问题是没人真正去实践。这门课是关于创业的，他们学会了如何成为创业者，但只有一个问题：他们实际上并没有去创业。于是我说：“等等，我得稍微调整一下课程，我得花点时间在刚才讨论的那些事情上：寻找你的梦想、你的限制性信念，开始为你的创业梦想或‘精灵目标’制定目标。”所以我的说法是：大学允许我教这门课，是因为我教给他们创业技巧、策略和工具，帮助他们成为优秀的 CEO。但我教书的真正原因，是我想帮助人们真正找到让他们兴奋的事情，并踏上实现那件事的人生道路。所以我两者都做，但第二部分……也许不是课程的标题，尽管我认为这可能正是人们如此喜欢这门课的原因。

---

### [00:22:30] [Lenny Rachitsky]

**English:**
It's like a Trojan horse element.

**中文翻译:**
这就像是一个“特洛伊木马”策略。

---

### [00:22:32] [Graham Weaver]

**English:**
Exactly, yeah. Tony Robbins used to say that people hire him for success, and he has to give them that so that he feels like he earned his money, but what he really delivers them is fulfillment. And it's a little bit like that. People take my class to learn how to be a CEO, but what they really get is hopefully on the path of doing the thing they want to do.

**中文翻译:**
没错。Tony Robbins 曾说，人们雇他是为了获得成功，他必须给他们成功，这样他才觉得赚到了钱，但他真正带给他们的是成就感。这有点类似。人们选我的课是为了学习如何当 CEO，但他们真正得到的是——希望如此——走上做自己想做的事情的道路。

---

### [00:22:54] [Lenny Rachitsky]

**English:**
A lot of what you've been talking about, it's almost an assumption that you'll be more successful and happier if you follow your energy, your passion, versus the, "Here's how I'll make a bunch of money. Here's how I'll move up the ladder." Can you speak to that?

**中文翻译:**
你谈到的很多内容，几乎都有一个假设：如果你追随自己的能量和激情，你会比追求“如何赚大钱”或“如何升职加薪”更成功、更快乐。你能谈谈这一点吗？

---

### [00:23:09] [Graham Weaver]

**English:**
Yeah. Gosh, Lenny, it sounds so cliche when you say it like that, that I almost cringe a little bit. Let me try to give it a little bit different framework where it won't sound as ... because cliches are cliches because they're true. But let me try to give you a little bit different framework to think about it. I think about it as you have sort of your heart or your soul or your internal scorecard, and then you have your head and your mind and the world's external scorecard. And I'll speak from this from experience. So when I graduated from business school, I took the job I was supposed to take. And it was the safe job at the big private equity firm that paid well and looked great on my resume. And I took that job. That was the external scorecard. My head said that. I built an expected value calculation, all that stuff. The problem was it wasn't my internal scorecard. It had nothing to do with what I actually cared about and wanted to do with my life. And so the way that shows up is just this tension, friction, stress, anxiety, burnout, all those things. And you can will that, you can will yourself through for long periods of time. In fact, if you want, you can will yourself through that your whole life. But then once I got into the path of the thing that I was excited about, that's when I really felt my energy change dramatically. And I developed almost a superpower in that thing, because I had more energy. I was willing to work longer, I was willing to do it. I've been running my company now for 23 years. I was willing to do it for a longer period of time. I thought about it in the shower. I thought about it when I went on runs. I talked to people. They wanted to join because I was excited. And it was a whole different level of power and life force that I was able to bring to that. So I'm saying this from experience, that you're going to show up so much differently in the thing that you're excited about, that that alone is going to make your life a lot better. But the great irony is you're going to do so much better in that thing than you are the thing you are, quote, "supposed to do." And I certainly, certainly understand that people have real life constraints on their finances. And I 100% get that. And so a big part of what I do with students is work through those things and say, "Okay, great. Let's talk about this job you're going to take for X years and you're going to pay off your loans or whatever. But during that time, let's get you on the path of the thing you really want to do." So sometime soon in your life, you want to get on that path.

**中文翻译:**
是的。天哪，Lenny，当你那样说的时候，听起来太陈词滥调了，我甚至有点尴尬。让我尝试换一个框架来解释，这样听起来就不会那么……陈词滥调之所以成为陈词滥调，是因为它们是真理。但我试着给你一个不同的思考框架。我把它看作是：你拥有你的心、灵魂或“内部计分卡”，同时你也有你的头脑、思维和世界的“外部计分卡”。我以自己的经验来说。当我从商学院毕业时，我接受了一份“应该”接受的工作。那是一家大型私募股权公司的稳定工作，薪水很高，简历上看起来也很漂亮。我接受了那份工作。那是外部计分卡。我的头脑告诉我要这么做，我做了期望值计算，诸如此类。问题是，那不是我的内部计分卡。它与我真正关心的、真正想做的事情毫无关系。结果就表现为紧张、摩擦、压力、焦虑、倦怠等等。你可以靠意志力支撑，甚至可以支撑很长一段时间。事实上，如果你愿意，你可以靠意志力支撑一辈子。但一旦我踏上了让我兴奋的道路，我真的感觉到我的能量发生了巨大的变化。我在那件事上几乎开发出了一种“超能力”，因为我有更多的能量。我愿意工作更长时间，我愿意坚持下去。我的公司已经经营了 23 年。我愿意长期投入。洗澡时我在想它，跑步时也在想它。我和别人交谈，他们因为我的兴奋而想加入。我能为之投入完全不同层次的力量和生命力。我是以经验之谈：在让你兴奋的事情上，你的表现会截然不同，仅凭这一点就能让你的生活变得更好。但极大的讽刺是，你在那件事上的成就，会远高于你那些所谓“应该做”的事。我当然非常理解人们在财务上有现实的约束，我百分之百理解。所以我对学生做的很大一部分工作就是处理这些问题，说：“好，太棒了。让我们谈谈这份你打算做 X 年的工作，用来还清贷款之类的。但在那段时间里，让我们帮你踏上你真正想做的事情的道路。”在你生命中不久的将来，你要踏上那条路。

---

### [00:26:02] [Lenny Rachitsky]

**English:**
There's a bunch of directions I want to go here. One is I'll just share, what you're describing is exactly what happened to me, without knowing this advice. I just started writing things online because the poll was there and people seemed to enjoy it. So I just kept following that path. And the whole time, my wife's like, "You can't make money writing on the internet. That's not a thing. Why would you do this? You have all these skills, that you can make a lot more doing other things." But I just kept doing that, and that's what led me to this life now where I make much, much more than I made as a product manager at Airbnb. And also, it's a lot less stressful. And so, I'm a living example [inaudible 00:26:39].

**中文翻译:**
我想从几个方向深入探讨。首先我想分享的是，你描述的情况正是我身上发生的，尽管当时我并不知道这些建议。我开始在网上写东西，纯粹是因为有一种吸引力，而且人们似乎很喜欢。所以我一直沿着那条路走。整个过程中，我妻子一直说：“你在网上写东西赚不到钱的。那根本不是个正经事。你为什么要这么做？你有这么多技能，做别的事情能赚得多得多。”但我还是坚持做了下去，正是这带给我现在的生活——我现在赚的比在 Airbnb 当产品经理时多得多，而且压力也小得多。所以，我就是一个活生生的例子。

---

### [00:26:38] [Graham Weaver]

**English:**
Yeah. And if you go back to what I was saying before, you probably were answering the question, "What would I do if I didn't have to make money?" You just did that because you enjoyed it. What's play for you that's work for other people? What do you do in your free time? You were answering all those questions. And then I think a lot of people just say, "Oh, well, that's just a side hustle or a hobby." It is until it isn't, right? And you're a great example of that.

**中文翻译:**
是的。如果你回想我之前说的，你当时可能就是在回答那个问题：“如果不需要赚钱，我会做什么？”你做那件事纯粹是因为你喜欢。什么是对你来说像玩耍，但对别人来说是工作的事情？你在空闲时间做什么？你当时回答了所有这些问题。我想很多人会说：“哦，那只是个副业或爱好。”在它变成事业之前，它确实只是爱好，对吧？你就是一个极好的例子。

---

### [00:27:04] [Lenny Rachitsky]

**English:**
Just to set it some expectations with folks, you tell me, how often does this actually work out for someone where this ended up being the right path for them, that it ended up working well for them? Just because people can hear this and be like, "Yeah, okay, I'm sure it works for some people; probably not for most people." What's the success rate, however you define that, for your students?

**中文翻译:**
为了给听众设定一些合理的预期，你告诉我，这种情况发生的频率有多高？即这最终被证明是正确的道路，并且结果很好。因为人们听了可能会想：“好吧，我相信这对某些人有用，但对大多数人可能没用。”无论你怎么定义成功，你的学生的成功率大概是多少？

---

### [00:27:25] [Graham Weaver]

**English:**
Okay, so the short answer is I don't know, because I don't have full information about how my students do or what their path would have been had they not done it. So it's a kind of difficult question to answer. But what I would say is that the formula you're solving for is you, excited about something for a decade or more. So what has to happen? You excited about something. We just talked about what that is. The decade or more is going to come true more likely if you're excited about it. But also, you have to go in at the beginning with that mindset and the structural ability to stay at it for a long period of time. So the missing ingredient in most of the people that fail is time. And I'll use myself as an example. I started Alpine. We lost money on our first fund. We started doing well. We got hit by the recession, we started digging out, whatever. But long story short, I was 14 years into running my firm until I could say with confidence we were going to even stay in business, let alone be really successful. And probably 18 years until we were what I would say really successful by external standards. And now 23 years, we've had a great run. But if you take away the time period, then I would've gone down as one of the, quote, "failures," as opposed to, I would say, one of the success stories using this methodology. So time is the variable. And I think the biggest part of that is it's really, believe it or not, not typically the finance or the structural piece. It's the entrepreneur or the individual's willingness to actually stay with it. And then upstream of that, it's their belief about how long it's supposed to take. And I really hate this about the social media and just media in general, where they try to paint this picture that things are going to happen overnight. And we've invested in 600 businesses. Let's say 550 of those are founder-started businesses where we're the first money. I've never, in one of those examples, seen anyone who did something quickly. They've all been very, very long stories to get to that point.

**中文翻译:**
好吧，简短的回答是我不知道，因为我没有关于学生表现的完整信息，也不知道如果他们不这样做，他们的道路会是什么样。所以这是一个很难回答的问题。但我想说的是，你正在求解的公式是：你，对某件事兴奋，并坚持十年或更久。那么需要发生什么？你对某件事感到兴奋，我们刚才讨论过那是什么。如果你感到兴奋，坚持十年或更久的可能性就更大。但是，你在一开始就必须具备那种心态和能够长期坚持的结构性能力。大多数失败的人所缺失的要素是“时间”。我以自己为例。我创办了 Alpine。我们的第一只基金亏了钱。后来开始好转，又遇到了经济衰退，我们开始摆脱困境，等等。但长话短说，在我经营公司 14 年后，我才能自信地说我们能生存下去，更不用说取得真正的成功了。大概到了 18 年，我们才达到了外部标准所说的“真正成功”。现在 23 年了，我们发展得很好。但如果你把这段时间拿掉，我就会被归类为“失败者”之一，而不是使用这种方法论的成功案例。所以时间是变量。我认为其中最重要的部分，信不信由你，通常不是财务或结构问题，而是创业者或个人真正坚持下去的意愿。而更深层的原因是，他们对于“这应该花多长时间”的信念。我真的很讨厌社交媒体和大众媒体，它们试图描绘一种“一夜成名”的假象。我们投资了 600 家企业，假设其中 550 家是创始人创办、我们提供第一笔资金的企业。在这些例子中，我从未见过有人能快速成功。要达到那个高度，全都是非常、非常漫长的故事。

---

### [00:30:12] [Lenny Rachitsky]

**English:**
This reminds me of a quote I read. I don't know if you wrote this or you shared it, this idea that the life is suffering, so choose something worth suffering for.

**中文翻译:**
这让我想起我读过的一句话。我不知道是你写的还是你分享的，大意是：生活就是受苦，所以选择一些值得为之受苦的事情。

---

### [00:30:20] [Graham Weaver]

**English:**
I wrote that, yeah.

**中文翻译:**
是我写的，没错。

---

### [00:30:22] [Lenny Rachitsky]

**English:**
You wrote that. Talk about that, because it feels like it's exactly what you're describing. It's going to take a long time to figure something out.

**中文翻译:**
是你写的。谈谈这个吧，因为这感觉正是你所描述的情况。弄清楚一件事需要很长时间。

---

### [00:30:28] [Graham Weaver]

**English:**
Exactly. Yeah, exactly. I'm glad you brought that ... Yeah, I mean, think about it. Again, using myself as an example, the first job I had, I wasn't suffering any less. I was getting on planes, I was working late hours. My time was not my own. If I would've had kids, I'd be missing their little league games and all that stuff. So I'm doing that anyway. I'm just doing it for something I don't care about. And then I start my own company and I was, quote, "suffering," getting on planes, doing all that. It was just something that I cared about. So yeah, the quote, "Life is suffering. So figure out something worth suffering for," you're going to suffer either way. And that's another thing I think people don't realize, is there isn't really a path that is easy that I've ever found.

**中文翻译:**
没错。是的，完全正确。我很高兴你提到这个……我是说，想想看。再次以我为例，我的第一份工作，我受的苦一点也不少。我要赶飞机，加班到很晚。时间不属于我自己。如果当时我有孩子，我会错过他们的少棒联盟比赛等等。所以我无论如何都要受这些苦，只是当时是为了我不关心的事。后来我创办了自己的公司，我也在“受苦”，赶飞机，做所有那些事。但那是我关心的事。所以没错，“生活就是受苦。所以找一件值得为之受苦的事”，无论如何你都要受苦。这是我认为人们没有意识到的另一件事：我从未发现过真正容易的道路。

---

### [00:31:16] [Lenny Rachitsky]

**English:**
You have another quote along these lines, which is, "Everything you want is on the other side of worse first."

**中文翻译:**
你还有另一句类似的话：“你想要的一切，都在‘先变糟’的另一面。”

---

### [00:31:21] [Graham Weaver]

**English:**
Yeah, I mean, I know those are two non-super optimistic quotes perhaps, but I think they're true. The second one, everything you want is on the other side of worst first, and this is something where I almost can't think of many exceptions to this. Pick anything. You want a better body? Okay, you're going to need to go to the gym. When you go to the gym the first few times, it's going to not be that fun. You're going to set your alarm, you're going to get sore. It's not going to be great. You're going to have to probably make some changes to your diet. That's not going to be fun, at least initially. And so that's one example. You want to change careers, you're going to have to learn a new career. You're going to have to leave your career. You're going to have to maybe interview for new jobs, or whatever it is. In each case, the first move is negative. The first move is negative to getting in shape. The first move is negative to get out of a bad relationship, to get into a career you want to be in. The reason I think that's important to say is because if I'm optimizing for tomorrow and I just want to have a great day tomorrow, I'm going to stay exactly where I am, because my life will be better tomorrow if I don't make any changes. I don't have to break up with my girlfriend, have a hard conversation, have the tears, be alone, go on dating apps. I don't have to do that if I just stay in it one more day. So if you realize this and instead ask the question, the version of myself five years from now, what would they wish I was going to do right now? So I can guarantee your five-year version of yourself will say, "Get out of that toxic relationship, no matter how painful it is for the next two months." And if you can make decisions from that, and then on top of that, realize it's going to get worse first, then that's why I say everything you want is on the other side of worse first. But if you don't do that, you just end up plateauing. And so many people I see have this happen where they hit a plateau and they never move past it because they're not willing to have that hard day, month, week, year whatever it is.

**中文翻译:**
是的，我知道这两句话听起来可能不是超级乐观，但我认为它们是真理。第二句，“你想要的一切都在‘先变糟’的另一面”，我几乎想不出什么例外。随你挑。想要更好的身材？好，你需要去健身房。刚开始去的那几次，并不会很有趣。你要定闹钟，你会肌肉酸痛。感觉并不好。你可能还得改变饮食习惯，起初这也不好受。这是一个例子。你想换职业，你得学习新技能，得离开现有的职业，得去面试新工作，诸如此类。在每种情况下，第一步都是负面的。健身的第一步是负面的，摆脱一段糟糕的关系、进入理想的职业，第一步都是负面的。我认为说出这一点很重要，因为如果我只为了明天而优化，只想明天过得开心，我就会待在原地，因为如果不做任何改变，我明天的生活会更轻松。我不需要和女朋友分手，不需要进行艰难的谈话，不需要流泪，不需要忍受孤独，不需要刷约会软件。只要我再维持现状一天，我就不需要做这些。但如果你意识到这一点，转而问自己：“五年后的我会希望我现在做什么？”我保证，五年后的你会说：“离开那段有毒的关系，不管接下来的两个月有多痛苦。”如果你能据此做出决定，并且意识到事情会先变糟，你就能理解为什么我说“你想要的一切都在‘先变糟’的另一面”。但如果你不这样做，你最终只会停滞不前。我看到很多人都是这样，他们遇到了瓶颈，却永远无法突破，因为他们不愿意经历那段艰难的日子、月份、星期或年份。

---

### [00:33:45] [Lenny Rachitsky]

**English:**
I am imagining many people hearing this right now are like, "Yeah, I see what I need to do now." That was really powerful advice. It makes me think of parenting advice, some parenting advice I recently saw. Dr. Becky has this advice of your job as a parent isn't to make your kids happy, but it's to make them resilient.

**中文翻译:**
我能想象很多人听到这里会想：“是的，我知道我现在该做什么了。”这真的是非常有力的建议。这让我想起我最近看到的一些育儿建议。Becky 博士有一个观点：作为父母，你的工作不是让孩子快乐，而是让他们变得有韧性。

---

### [00:34:02] [Graham Weaver]

**English:**
I love that, yeah. By the way, watch how people parent. They parent exactly the opposite of that.

**中文翻译:**
我喜欢这个观点。顺便说一下，看看人们是怎么为人父母的，他们的做法恰恰相反。

---

### [00:34:07] [Lenny Rachitsky]

**English:**
Exactly [inaudible 00:34:09].

**中文翻译:**
没错。

---

### [00:34:09] [Graham Weaver]

**English:**
You and I both live in Marin. I don't know if you have kids or how old they are, but when you get kids in school in Marin, you see parents, they try to clear all obstacles away from their kids. It's the worst thing you could do.

**中文翻译:**
我们都住在马林县（Marin）。我不知道你有没有孩子，或者他们多大，但当你的孩子在马林县上学时，你会看到那些父母试图为孩子扫清所有障碍。那是你能做的最糟糕的事。

---

### [00:34:25] [Lenny Rachitsky]

**English:**
Today's episode is brought to you by Liveblocks, the platform that turns your product into a place that users want to be. With ready-made, collaborative features, you can supercharge your product with experiences that only top tier companies have been able to perfect until now. Think AI copilots like Notion, multiplayer like Figma, comments and notifications like Linear, and even collaborative editing like Google Docs, and all of that with minimal configuration or maintenance required. Companies from all kinds of industries and stages count on Liveblocks to drive engagement and growth in their products. Join them today and give your users an experience that turns them into daily active users. Sign up for a free account today at liveblocks.io/lenny.

**中文翻译:**
本集节目由 Liveblocks 赞助，这是一个能将你的产品变成用户向往之地的平台。通过现成的协作功能，你可以为你的产品注入顶级公司才能完美实现的体验。想想 Notion 的 AI 副驾驶、Figma 的多玩家模式、Linear 的评论和通知，甚至是 Google Docs 的协作编辑，所有这些都只需要极少的配置或维护。来自各行各业、处于不同阶段的公司都依靠 Liveblocks 来推动产品的参与度和增长。今天就加入他们，为你的用户提供一种能让他们成为每日活跃用户的体验。立即在 liveblocks.io/lenny 注册免费账户。

---

### [00:35:14] [Lenny Rachitsky]

**English:**
I want to talk about another exercise that you have, but before I do that, there's all this advice you're sharing that people might be hearing and be like, "Yeah, yeah. Okay, this is great." I'm going to share this in intro, and we're not going to talk a lot about your fund, but I did some research on it. And from what I understand, it's one of the top performing PE funds in the world, which is very hard, considering how many smart people run PE funds and how ruthless that industry is. Anything you can comment on there? Yeah, I think that's important for people to know.

**中文翻译:**
我想谈谈你的另一个练习，但在那之前，人们听到你分享的这些建议可能会想：“行吧，这听起来不错。”我会在开场白中提到这一点，我们不会过多讨论你的基金，但我对它做了一些研究。据我所知，它是世界上表现最好的私募股权（PE）基金之一。考虑到有多少聪明人在经营 PE 基金，以及这个行业的残酷程度，这非常难得。你对此有什么想说的吗？我觉得让大家知道这一点很重要。

---

### [00:35:48] [Graham Weaver]

**English:**
Well, I think one of the things I would say is that I never stand up in front of students or be on a podcast like this and say anything that I'm not doing myself or that I'm advising students or people who work at Alpine to do. And so I appreciate the kind words. And I think that the things that I'm talking about are rooted in real results. And this is not just happy talk podcast. The formula, I think, for greatness is to be intentional, get in the path of the thing that you're most excited about, and then give yourself several decades to do it. And that's based on investing in 600 companies and building my own business. So I appreciate the kind call out.

**中文翻译:**
嗯，我想说的一点是，我从未在学生面前或在这样的播客中说过任何我自己没在做的事，或者我没建议学生或 Alpine 员工去做的事。非常感谢你的美言。我认为我所谈论的内容是植根于真实结果的。这不仅仅是一个“空谈快乐”的播客。我认为成就伟大的公式是：有意识（intentional）、踏上让你最兴奋的道路，然后给自己几十年的时间去完成它。这是基于投资 600 家公司和建立我自己的事业得出的结论。所以，感谢你的称赞。

---

### [00:36:37] [Lenny Rachitsky]

**English:**
Yeah. For people that are listening and be like, "Okay, I'm motivated. I want to do this," other than taking your class, anything you can recommend to just do these sorts of exercises, ask yourself these questions that you've seen work?

**中文翻译:**
是的。对于那些听了之后觉得“好，我被激励了，我想做这件事”的人，除了上你的课，你还有什么建议可以让他们进行这类练习，问自己这些你认为有效的问题吗？

---

### [00:36:49] [Graham Weaver]

**English:**
I mean, the answer is accountability. How do you keep yourself accountable to living the life you want to live? And the analogy I would use is let's say that your number one goal in life is you've got to get in better shape. You just have to. Let's say you have even medically, you're going to have real health problems if you don't do that. I would say you hire yourself a personal trainer, pay what you need to pay. Okay, maybe you don't have a ton of money, but that's where I'd spend it. That person, A, they're going to hold you accountable to showing up at a certain time, and B, they're going to show you the exercises. They're going to call you if you're not there. You're just increasing the chances of success. Plus you spend some money, you want to get your money out of it. The equivalent of that in your life is an executive coach. And I figured this out in 2009 in the dark recesses of the recession. I hired my first executive coach. And I was like, "Wow, it's a personal trainer for me for two things." Number one, make space to ask yourself the big questions in life about your career, your relationships, your health, your spirituality, your children. Whatever the big things are in your life, ask the big questions, find out what your intention is. What are you looking for in those areas? And just have, in my case, several hours a week to get clear on those things. Okay, so that's part one. And then part two is that person can hold you accountable. I have one coach that I can't even have the call with the coach unless I fill out a piece of paper or an online form that says, "Here's what my one year goals are, outcomes I want to have this year are. Here's what I did last week, based on those. Here's what I'm going to do next week toward those. And here's the outcomes I want to have for the call we're about to have." And even if I never had the call, just having to fill that out every single week is incredibly powerful and allows me to hold myself accountable. So 100%, that's what I'd recommend. Let's back up and say, okay, let's say you can't afford a coach or you're worried about that. And this is the same thing as, let's say you couldn't afford a personal trainer. I would give you the same advice, which is find a very like-minded friend of yours and sit down and do it for each other. So if you're using the workout example, okay, you're going to go on a run Tuesdays, Wednesdays and Fridays with your friend, and they're going to meet you at 7:00 AM at this trail, or 6:00 AM at this trail. That's your accountability. And you're going to be more likely to do it. You don't want to let them down. They're going to beat you up if you don't get there. Same is true with this. This is how I started. I did this with my roommate in business school. And we would go on a walk for 30 minutes and talk about my dreams and hopes. Then we'd turn around and talk about his. And it was great, because we made room for each other to have those conversations, and we also developed a great friendship. So short of having an actual executive coach, find a really-minded person that could get into this with you, and that would be another thing. But accountability is huge. I'm going to just say one more thing. I'm sorry. I'm going on a little bit long on this.

**中文翻译:**
我的答案是“问责制”（accountability）。你如何让自己对想要的生活负责？我打个比方：假设你人生的头号目标是必须获得更好的体型，你必须做到。假设从医学角度看，如果你不这样做，就会出现严重的健康问题。我会建议你请一个私人教练，该付多少钱就付多少。好吧，也许你没那么多钱，但我会把钱花在这上面。那个人，第一，他会监督你准时出现；第二，他会教你动作。如果你没去，他会给你打电话。你只是在增加成功的几率。而且你花了钱，你会想让这笔钱花得值。在生活中，与之对应的是“高管教练”。我在 2009 年经济衰退最黑暗的时期意识到了这一点。我聘请了我的第一位高管教练。我当时想：“哇，这对我来说就像一个私人教练，起到了两个作用。”第一，腾出空间问自己人生的大问题：关于职业、关系、健康、精神追求、孩子。无论你生活中重要的事情是什么，问大问题，找出你的意图。你在这些领域追求什么？对我来说，每周花几个小时来理清这些事情。这是第一部分。第二部分是，那个人可以监督你。我有一位教练，除非我填好一张纸或在线表格，否则我甚至不能和他通话。表格上写着：“我的一年目标是什么，我今年想要的结果是什么。基于这些，我上周做了什么。下周我将为此做什么。以及我们即将进行的通话我想要达到的结果。”即使我从未进行过通话，仅仅是每周必须填写那份表格，其力量就极其强大，它让我能够对自己负责。所以我百分之百推荐这个。退一步说，如果你请不起教练，或者担心费用，这就像请不起私人教练一样。我会给你同样的建议：找一个志同道合的朋友，互相监督。如果你用健身做例子，好，你每周二、三、五和朋友一起跑步，他们早上 7 点或 6 点在小径等你。这就是你的问责机制。你更有可能坚持下去，因为你不想让他们失望，如果你没去，他们会责备你。这件事也是一样。我就是这样开始的。我和我商学院的室友一起做这件事。我们会散步 30 分钟，谈论我的梦想和希望，然后换过来谈论他的。这很棒，因为我们为彼此腾出了对话的空间，也建立了深厚的友谊。所以，如果没有真正的高管教练，找一个志同道合的人一起参与，这是另一种方法。但问责制至关重要。我还要再说一点，抱歉，我在这上面说得有点长。

---

### [00:40:20] [Lenny Rachitsky]

**English:**
[inaudible 00:40:20] please.

**中文翻译:**
请继续。

---

### [00:40:19] [Graham Weaver]

**English:**
There's another thing that happens that's kind of magical, which is you activate a different part of your brain when you talk. You actually activate more of your brain when you talk than when you think or write. So thinking activates the least amount of your brain. Writing is a little bit better, but talking activates a whole different region of your brain. So that's the other big benefit of not doing this just on your own, is being able to talk about it with someone.

**中文翻译:**
还有一件很神奇的事情：当你说话时，你会激活大脑的不同部分。事实上，说话时激活的大脑区域比思考或写作时更多。思考激活的大脑区域最少，写作好一点，但说话会激活一个完全不同的区域。所以，不独自进行这件事的另一个巨大好处是，能够与某人交流。

---

### [00:40:54] [Lenny Rachitsky]

**English:**
I love that there's a whole spectrum of ways to create accountability for yourself. I love the second coach you've shared, where just filling out that form was basically the biggest benefit.

**中文翻译:**
我喜欢这种建立自我问责制的多种方式。我特别喜欢你分享的第二位教练，仅仅是填写那份表格本身就是最大的收获。

---

### [00:41:07] [Graham Weaver]

**English:**
I learned this from these audio tapes. When I was in college, I had this green notebook. And I was trying to row crew, and I never row crew before. And I wrote down at the top of the page every single morning, I wrote down, "I am the number one rower in the country." I wasn't. I was a freshman novice, 135 pound Midwesterner, never had been in a boat. But I wrote that down. And then I wrote down three things I was going to do that day to move toward that goal. And I did that every single day that I was in college. And it's just incredible. We talked earlier about your subconscious mind. You're just locking your subconscious mind into your goals and where you want to go and who you want to be and how you want to show up. It's really powerful.

**中文翻译:**
我是从那些励志磁带里学到这一点的。上大学时，我有一个绿色笔记本。当时我想参加赛艇队，但我以前从未划过船。每天早上，我都会在页面顶端写下：“我是全国第一的赛艇运动员。”我当时并不是。我只是个大一新手，一个 135 磅重的、从未下过水的美国中西部小伙子。但我还是写下了那句话。然后我写下那天我要做的三件事，以朝着那个目标迈进。大学期间我每天都这么做。这简直不可思议。我们之前谈过潜意识，你就是在把你的潜意识锁定在你的目标、你想去的地方、你想成为的人以及你想展现出的样子上。这非常强大。

---

### [00:41:46] [Lenny Rachitsky]

**English:**
And that's advice anybody can implement. "I want to be the best [inaudible 00:41:51] founder"-

**中文翻译:**
这是任何人都可以执行的建议。“我想成为最好的创始人”——

---

### [00:41:50] [Graham Weaver]

**English:**
You could do that. You could do that [inaudible 00:41:50] exactly.

**中文翻译:**
你可以这样做，完全正确。

---

### [00:41:53] [Lenny Rachitsky]

**English:**
Yeah. It's such a simple thing. "I want to be the best product manager. Here's three things I'm doing today to help me along the lines."

**中文翻译:**
是的。这太简单了。“我想成为最好的产品经理。这是我今天为实现这一目标要做的三件事。”

---

### [00:41:59] [Graham Weaver]

**English:**
Absolutely. My students have to do this twice a week. It's one of their assignments, and they actually have to turn it in. And I have so many students that say five years later, "I still do this a couple times a week, and it's been unbelievable." I'd say this to all your listeners: you will get more done writing down your goal and three things you're going to do to move toward that goal, you'll get more things done in three months than you will in three years without that.

**中文翻译:**
绝对如此。我的学生每周必须做两次。这是他们的作业之一，他们必须上交。很多学生在五年后告诉我：“我每周仍然会做几次，效果简直不可思议。”我想对所有听众说：写下你的目标和今天要做的三件事，你在三个月内取得的成就，将超过你没有这样做时在三年内取得的成就。

---

### [00:42:28] [Lenny Rachitsky]

**English:**
That's an awesome thing to just try tomorrow at work. Write this down, see how it goes. The coach point, I just want to highlight that. What convinced me to get a coach back when I was working is I just realized, one, every athlete has a coach that tells them, "Here's how to become better," slash, everyone that you work with that is a leader and exec basically has a coach. And the people that have an exec coach will do better in their career and life than those who don't. So why would you not have someone there just helping you become better at this craft? It just makes so much sense if you can afford it. There are different price points for different coaches. Most people can probably afford it in some [inaudible 00:43:09].

**中文翻译:**
明天上班就可以尝试一下。写下来，看看效果。关于教练那一点，我想强调一下。当初说服我请教练的原因是我意识到：第一，每个运动员都有教练告诉他们“如何变得更好”；第二，你共事过的每一位领导者和高管基本上都有教练。那些有高管教练的人在职业生涯和生活中的表现会比没有的人更好。那么，为什么不找个人来帮助你提升这项技能呢？只要负担得起，这非常有意义。不同的教练有不同的价位，大多数人在某种程度上可能都负担得起。

---

### [00:43:08] [Graham Weaver]

**English:**
That's right. That's right.

**中文翻译:**
没错，确实如此。

---

### [00:43:11] [Lenny Rachitsky]

**English:**
Sweet. Okay. Let's talk about another framework that you have that you call nine lives. And this is essentially another way, it's like another way to hack your brain to come up with things you really should be doing, probably. Talk about this exercise.

**中文翻译:**
太棒了。好，让我们谈谈你的另一个框架，你称之为“九条命”。这本质上是另一种方式，就像是另一种“黑”进大脑的方法，用来找出你真正应该做的事情。谈谈这个练习吧。

---

### [00:43:23] [Graham Weaver]

**English:**
So this idea of what's my passion and what's my career goal, it can be really intimidating. And it is intimidating. And so this exercise is to make it less intimidating. And you basically come up with nine lives. So you say your first life, life one is the life you have now. So when I did this exercise ... let's pretend I did this exercise when I'm right out of school, taking that job. So life one is I'm working at this big firm, I live in the Bay Area, here's what I'm doing. That's life one. There's two rules. The first rule is all the lives have to start from today. So you can't go back in time. They all start from today. And the second rule is you have to be excited about all these lives. So I might say, "Hey, my second life is I want to start a private equity firm and be a founder and be a CEO." And that's life too. And life three is I want to be an author and I want to write whatever fiction or nonfiction. And then life four would be I want to be a professor and teach. And life five is maybe I want to make videos and be on social media. And life six, I want to be an actor. And you go through this whole list of these lives. And the idea is that ... A couple of things from this exercise. One is let's say that you're in a position where you need to be working in the job you're in. There might be one of these lives that gives you the most energy, and it's the thing if you knew you wouldn't fail, you would do this one. And it's good to recognize what that is and then pull that life a little bit into your current life. So let's say, Lenny, that you were a product manager, but you really loved doing podcasts, and that was one of your nine lives. Do a podcast every other week, and just pull it into your life, which it sounds like what you did. You started doing it as a side hustle. And then that'll have two amazing effects. One is you will just have more energy everywhere else in your life. Forget if you ever do this full time or not; just the act of pulling something into your life you're really excited about will give you a tremendous amount of energy. And then the second thing is you'll ideally find the path that is the thing that gives you the most energy. The other thing that I've learned in doing this exercise is you actually can have pretty much all nine lives. You can't have them at once, but if you're fortunate enough to live long enough, you can have all of these things. So I have had the corporate job, been the founder, been the professor, been a writer, had videos, taught people. I've been able to bring most of those lives into this current life.

**中文翻译:**
“我的激情是什么”和“我的职业目标是什么”这类想法可能会让人感到畏缩。确实如此。所以这个练习是为了让它不那么吓人。你基本上要构思出“九条命”。你说你的第一条命，即“生命 1”，就是你现在的生活。当我做这个练习时……假设我刚毕业参加工作时做这个练习。生命 1 是：我在大公司工作，住在湾区，这就是我正在做的事。这里有两个规则。第一，所有的生命都必须从今天开始。你不能回到过去，它们都从今天起步。第二，你必须对所有这些生命感到兴奋。所以我可能会说：“嘿，我的第二条命是我想创办一家私募股权公司，成为创始人兼 CEO。”那是生命 2。生命 3 是我想成为一名作家，写小说或非虚构作品。生命 4 是我想成为一名教授并教书。生命 5 可能是我想制作视频并在社交媒体上活跃。生命 6 是我想成为一名演员。你列出这一整张生命清单。这个练习有几个意义。第一，假设你现在必须做目前这份工作，但在这些生命中，可能有一个能给你最大的能量，如果你知道自己不会失败，你就会选这一个。意识到这一点很好，然后把那个生命的一小部分拉进你现在的生活。比如 Lenny，假设你当时是产品经理，但你真的很喜欢做播客，那是你的九条命之一。那就每隔一周做一个播客，把它拉进你的生活，听起来你就是这么做的，你把它当作副业开始。这会有两个惊人的效果：一，你在生活的其他方面也会更有能量。先不管你是否会全职做这件事，仅仅是将你真正兴奋的事情引入生活，就会带给你巨大的能量。二，理想情况下，你会找到那条能给你最大能量的道路。我在做这个练习中还学到了一点：你实际上可以拥有几乎全部九条命。你不能同时拥有它们，但如果你足够幸运活得够久，你可以经历所有这些。我做过公司职员，当过创始人，当过教授，当过作家，拍过视频，教过人。我已经能够将大部分这些生命带入我现在的这一生中。

---

### [00:46:25] [Lenny Rachitsky]

**English:**
There's a couple things there that come up as you talk about. One is, on that point, what I do now is my fourth career. First I was an engineer, then I became a founder, then I was a PM, and now I do whatever the heck this is. And I think people don't realize that's how life often goes. You think you're going to do one thing, and then you have many different careers that pivot into [inaudible 00:46:46].

**中文翻译:**
听你说话时我想到了几件事。第一，就那一点而言，我现在做的是我的第四份职业。起初我是工程师，然后成了创始人，接着是产品经理，现在我在做这件不知道该怎么称呼的事。我认为人们没有意识到生活通常就是这样发展的。你以为你会做一件事，结果你拥有许多不同的职业，并不断转型。

---

### [00:46:45] [Graham Weaver]

**English:**
Exactly. And I think that's the thing. It's just trying to make it a little less intimidating. You don't have to have this one life purpose, passion, thing that you do for the rest of your life. If you just follow the thing that gives you energy at each time, it'll probably be a good indication of where you want to be going.

**中文翻译:**
没错。我觉得关键就在这里，就是让它不那么吓人。你不需要有一个终生不变的唯一目标、激情或事业。如果你只是追随每个阶段带给你能量的事情，那通常能很好地指示你该往哪里走。

---

### [00:47:03] [Lenny Rachitsky]

**English:**
The other thread there is, I know one of your other really important pieces of advice is to avoid this not now idea, where everyone's like, "Here's the thing I should be doing, my genie goal, but not now." Thoughts on just how to think about that, of just like, "Okay, I know I have these lives I could live, but not now," on this or that?

**中文翻译:**
另一个话题是，我知道你另一个非常重要的建议是避免“现在不行”的想法。每个人都会说：“这是我该做的事，我的精灵目标，但现在不行。”关于如何思考这种“我知道我可以过这些生活，但现在不行”的心态，你有什么看法？

---

### [00:47:21] [Graham Weaver]

**English:**
Yeah, I mean, in 20 years of teaching, I've never had a student come to me and say, "Hey, Graham, my real dream is to do X, but I'm just going to give up on it. I'm not going to do it." No one's ever said that. Instead, they say, "Not now." And not now, if they're not careful, will turn into not ever, because not now is just really another way of saying, "I'm not going to do it." And then there's a million reasons why you can't do it now. And those reasons, some of them are legit and some of them are just fear in another form. In terms of how to overcome that, I think it's kind of hopeful to realize that it's never really the right time. When you're making a change or you're going to go do something different, it's never going to feel secure and safe. You're always going to have some fear. You're always going to feel like you're not ready. You're going to feel like it's too soon. You're going to feel like you don't know exactly what that path looks like. And so just understanding that's normal. That's called entrepreneurship. That's called life. And if you wait for the clouds to part and this ray of sun to come down and say, "Now is the time," you're going to wait your whole life. And so I think that realization can maybe be helpful. And then try to figure out, what are the things that need to be true for you to launch? And usually for my students, it's something financial that is the big bottleneck. And what I tell them is, "You know what? People have raised money to start a business before. That's happened, where you've had people who've started businesses without their own money that have been able to pay themselves. And that's not a reason to not do it. It's an obstacle. It's something you have to solve, but it's not not an insurmountable obstacle."

**中文翻译:**
是的，在 20 年的教学生涯中，从未有学生来对我说：“嘿，Graham，我真正的梦想是做 X，但我打算放弃了，我不做了。”没人这么说过。相反，他们会说：“现在不行。”而“现在不行”，如果不小心，就会变成“永远不行”，因为“现在不行”其实只是“我不打算做”的另一种说法。现在不能做的理由有成千上万个，其中一些是合理的，而另一些只是恐惧的另一种形式。至于如何克服这一点，我认为意识到“永远没有所谓的完美时机”是很有希望的。当你做出改变或尝试不同的事情时，永远不会感到绝对安全和稳妥。你总会有些恐惧，总会觉得没准备好，总会觉得太早了，总会觉得看不清前方的路。理解这是正常的，这就是创业，这就是生活。如果你在等待云开雾散、阳光洒下并对你说“现在就是时候了”，那你将等待一辈子。所以，我认为这种认知可能会有帮助。然后尝试弄清楚，你需要具备哪些条件才能启动？通常对我的学生来说，财务问题是最大的瓶颈。我会告诉他们：“你知道吗？以前也有人通过融资创办企业。这种情况发生过，有人在没有自有资金的情况下创业，并且能够给自己发工资。这不是不做的理由，这是一个障碍，是你需要解决的问题，但它并非不可逾越。”

---

### [00:49:30] [Lenny Rachitsky]

**English:**
This touches on a quote I definitely wanted to get to, something that you wrote not long ago. Here's the quote: "The most important thing I've learned in the first 50 years of my life is that the true game of life is an internal one, not an external one. And that journey starts with three powerful words: I am enough." Talk about that. Why is that so important?

**中文翻译:**
这触及了我非常想谈到的一句话，那是你不久前写的。引用如下：“在我人生的前 50 年里，学到的最重要的一点是，人生的真正博弈是内在的，而非外在的。而这段旅程始于三个有力的词：我已足够（I am enough）。”谈谈这个吧，为什么这如此重要？

---

### [00:49:51] [Graham Weaver]

**English:**
Well, I mean, that's a really a deep topic, but I'll talk about the internal and external journey. So life presents itself as a series of external obstacles and events. And it feels very much like an external journey. And it can feel that way your whole life. But I think what you'll realize, and I started realizing this when I really started meditating and spending time distancing myself from the subconscious thoughts, is a very, very large part of life is internal. I say a very large part because obviously you need some food, clothing, shelter, some basic needs that are external. But for most people that have the ability to even listen to this podcast, I would say the vast majority of your life is internal. So what do I mean by that? I mean that you're writing a story about what it is you think you need to be happy, or you're writing a story about things you think you need to be to be enough or to be respected or to feel worthy or to get admiration of other people. You're writing that story, and it's just a story. And if you really follow this logic, you'll realize that. You'll realize it is 100% just a story, or it's a story that you should even care. And then that opens up a lot more agency that you have over deciding what is important to you, what is your internal scorecard, what are the things that matter to you, not what the external world thinks or the story you've been writing for a long time. When you start to open this up, it's really kind of scary at first, because you'll start to realize most of the things you're operating from are really just stories that have been written at some point in your life. And so it's actually terrifying at first, and then it starts to become really liberating.

**中文翻译:**
嗯，这是一个非常深刻的话题，但我会谈谈内在和外在的旅程。生活表现为一系列外在的障碍和事件，感觉非常像一场外在的旅程，这种感觉可能伴随你一生。但我认为你会意识到——当我真正开始冥想并花时间让自己与潜意识想法保持距离时，我开始意识到——生活很大一部分是内在的。我说“很大一部分”，是因为显然你需要食物、衣服、住所，这些是外在的基本需求。但对于大多数有能力听这个播客的人来说，我会说你生活的绝大部分是内在的。我这是什么意思呢？我的意思是，你正在编写一个关于“你认为需要什么才能快乐”的故事，或者关于“你认为自己需要成为什么样的人才算足够、才受人尊敬、才感到有价值或获得他人钦佩”的故事。你正在编写那个故事，而它仅仅是一个故事。如果你真的遵循这个逻辑，你会意识到这一点。你会意识到这百分之百只是一个故事，或者是一个你是否应该在意它的故事。这会让你在决定什么对你重要、什么是你的内部计分卡、什么对你真正有意义方面拥有更多的自主权，而不是在意外部世界的看法或你长期以来编写的那个故事。当你开始揭开这一点时，起初会有点害怕，因为你会意识到你赖以生存的大多数准则其实只是在你生命中某个时刻编写的故事。所以起初确实很可怕，但随后它会变得非常令人解脱。

---

### [00:52:10] [Lenny Rachitsky]

**English:**
Was there an example of that in your life? Because externally, it feels like you're killing it: a killer PE fund, teaching at Stanford. The scorecard is looking good. So it's interesting you say that.

**中文翻译:**
在你的人生中有这样的例子吗？因为从外在看，你非常成功：经营着顶尖的 PE 基金，在斯坦福教书。你的外部计分卡看起来非常漂亮。所以你这么说很有意思。

---

### [00:52:21] [Graham Weaver]

**English:**
The first time I really realized this, it was in 2015. I mentioned to you it took me 14 years to be successful. So we had just sold the last company from our second fund, which is where we really got paid. I had a financial event that was ... it wasn't like I never have to work again in my life. It was just like I could exhale a little bit. I knew I was going to be able to pay my mortgage and put my kids through college. It was that kind of an event. And for a couple days I was euphoric, because I felt like I'd worked so hard for this. I'd been, again, at this for 15 years, but really longer than that, if you go back to getting into college. And the whole thing had been a long journey. And then it hit me that nothing changed. Nothing internally changed at all. I still had the same problems. I still felt the same way about myself. I still had a lot of negative thoughts about myself. This goal that I thought that I had for this whole long period of time, it didn't actually change anything. It changed externally, for sure. Like I said, I could exhale and pay my mortgage. And those are all really good things. But that was the first time when I realized, "Oh, wait a second. It's really up to me to find things that are going to give me joy. And the achievement of some kind of external event is not one of those things." And I know that sounds really, really weird, but there's so many people that I've heard that have had very, very similar stories. And so it was really disorienting for me. And actually it was the first time in my life where I experienced depression, because I just had this thought of, "I think I was working my whole life for that, and it wasn't what I thought it was going to be." And so now I was thinking, "Well, what is it then? What is the thing that's going to give me joy?" And that takes some introspection to ask those questions.

**中文翻译:**
我第一次真正意识到这一点是在 2015 年。我跟你提过，我花了 14 年才获得成功。当时我们刚刚卖掉了第二只基金的最后一家公司，那是我们真正赚到大钱的时候。我经历了一次财务上的飞跃……倒不是说我这辈子再也不用工作了，而是我可以稍微松一口气了。我知道我能付得起房贷，能供孩子上大学。就是那样的一个时刻。有那么几天我欣喜若狂，因为我觉得我为此付出了巨大的努力。我坚持了 15 年，如果从考大学算起，时间更长。整个过程是一段漫长的旅程。然后我突然意识到，什么都没有改变。内在的一切完全没有改变。我仍然面临同样的问题，我对自己的看法仍然没变，我仍然有很多关于自己的负面想法。我追求了这么久的这个目标，实际上并没有改变任何本质的东西。外在确实变了，就像我说的，我可以松口气付房贷了，这些都是好事。但那是第一次我意识到：“哦，等等。寻找能带给我快乐的事情，真的取决于我自己。而达成某种外部目标并不是其中之一。”我知道这听起来非常奇怪，但我听过很多人都有非常相似的故事。所以当时我感到非常迷茫。事实上，那是我人生中第一次经历抑郁，因为我当时想：“我觉得我一辈子都在为那个目标努力，但它并不是我想象中的样子。”于是我开始想：“那到底是什么呢？什么才是能带给我快乐的东西？”这需要一些内省来提出这些问题。

---

### [00:54:34] [Lenny Rachitsky]

**English:**
I was just having a conversation with a friend who's an angel investor, and he just had a bunch of exits. And he's like, "Cool, I got some money in my bank account now, but I don't feel anything. I thought I'd be like, 'Holy moly, this is exactly what I was hoping for. And nothing changed.'" Exactly how you're describing.

**中文翻译:**
我刚和一个做天使投资人的朋友聊过，他刚经历了几次退出。他说：“酷，我现在银行账户里有一大笔钱，但我没什么感觉。我原以为我会想：‘天哪，这正是我梦寐以求的。’结果什么都没变。”正如你描述的那样。

---

### [00:54:53] [Graham Weaver]

**English:**
I think you get a little bit of peace of mind when you have some financial security, which is valuable. But in terms of now my life changes, now I'm enough, now I am happy, now I feel good about myself, none of that changes, for really anybody that I know.

**中文翻译:**
我认为当你拥有财务安全感时，你会获得一点内心的平静，这很有价值。但就“现在我的生活改变了”、“现在我足够好了”、“现在我快乐了”、“现在我自我感觉良好了”而言，据我所知，对任何人来说，这些都不会因为钱而改变。

---

### [00:55:15] [Lenny Rachitsky]

**English:**
And the hardest part, as you said, is you think it will. You think, "Oh, I'll be so happy once I achieve this thing." And I think an example of this is there's a lot of miserable billionaires, from what I've read and see. And that should tell you a lot.

**中文翻译:**
正如你所说，最难的部分是你以为它会改变。你以为：“哦，一旦我实现了这个目标，我就会非常快乐。”我想一个例子是，据我所读所见，有很多痛苦的亿万富翁。这应该能说明很多问题。

---

### [00:55:26] [Graham Weaver]

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:55:27] [Lenny Rachitsky]

**English:**
Maybe a second-to-last question; I'm curious if there's anything recently you're focused on, have been thinking a lot about that maybe you changed your mind about, or has changed the way you think about the world?

**中文翻译:**
倒数第二个问题：我很好奇你最近在关注什么，或者一直在思考什么？有没有什么事情让你改变了主意，或者改变了你对世界的看法？

---

### [00:55:38] [Graham Weaver]

**English:**
The last two years, I had my two oldest boys go off to college, 2022 and then 2024. And that really hit hard. You would think that I would've been preparing for that for 18 years for each of them, but for some reason it just really hit me really, really hard. And I think it was a real wake up call of mortality, I guess, and to realize that nothing goes on forever. And these wonderful people that I had lived with, each for 18 years, were no longer going to really be a part of my daily life. And that really set me off on a journey of a lot of spiritual work, doing a lot of meditating and working with some gurus. And it's been really profound. And it's put me a lot closer in touch with the things that really matter to me. I've given myself more permission to spend time doing those things than the normal external world type things. So that was a pretty profound change for me. And the spiritual journey is arguably really the important journey. And this could be a longer conversation. And maybe you have the luxury of doing that journey as you get older or something, but it's been a really profound, profound journey.

**中文翻译:**
过去两年，我的两个大儿子分别在 2022 年和 2024 年去上大学了。这对我打击很大。你可能会觉得我为他们每个人都准备了 18 年，但出于某种原因，这真的让我深受触动。我想这对我来说是一个关于“生命有限”的警钟，让我意识到没有什么会永远持续下去。这些和我一起生活了 18 年的优秀的人，不再是我日常生活的一部分了。这开启了我的一段精神探索之旅，我做了很多冥想，并向一些大师请教。这非常深刻。它让我更紧密地接触到那些对我真正重要的事情。我给了自己更多的许可，把时间花在这些事情上，而不是通常的外部世界的事情。所以这对我来说是一个非常深刻的改变。精神层面的旅程可以说才是真正重要的旅程。这可以是一个更长的话题。也许随着年龄增长，你才有奢侈去进行这段旅程，但对我来说，这是一段非常、非常深刻的旅程。

---

### [00:57:17] [Lenny Rachitsky]

**English:**
I'm excited to see what insights come out of this part of your life. Final question before we get to our very exciting lightning round. We have this segment on the podcast called Failure Corner, where people come on this podcast, they share all these wins: "Oh, I have this amazing PE fund that's killing it. I teach at Stanford. I've launched all these things. All these students, they're so great. Life's amazing. Nothing ever goes wrong," when in reality, it does. And those stories often aren't told. So I'm curious if there's a story you could share of a time you failed in your career and, if you learned something from that experience, what you learned.

**中文翻译:**
我很期待看到你人生这一阶段会产生什么样的感悟。在进入非常精彩的闪电轮环节之前，最后一个问题。我们播客有一个叫“失败角落”的环节。人们来到这个播客，分享所有的成功：“哦，我有一个超棒的 PE 基金，表现无敌；我在斯坦福教书；我发布了所有这些东西；学生们都太棒了；生活很美好，万事顺意。”但现实中，总会有挫折，而这些故事往往不为人知。所以我很好奇，你是否能分享一个职业生涯中失败的故事，以及你从那次经历中学到了什么。

---

### [00:57:51] [Graham Weaver]

**English:**
Yeah, I'll tell a couple stories. So when I was in high school, I wrestled. And I cut a lot of weight to make the varsity team. And I was not in the best mental place because of cutting weight. But anyway, I lost a big match my junior year. And I quit and I never wrestled again. And that haunted me. So first of all, that was a failure, a big failure for me. And it really haunted me. And so I, after that, made a promise to myself that it wasn't going to have that happen again. When I went to college, I tried to row crew. I failed year after year trying to make the team, trying to make the boat. Eventually had some real success my senior year, but prior to that, just failure after failure. And then at Alpine, I mean, we lost money on our first fund. We had real trouble during the recession. I think five of my first eight investments I ever made in my life, I lost money. And in venture world, that's one thing, but in private equity, that's a whole different ratio, which is not a good ratio at all. When I first started teaching, I wasn't good at teaching, had a lot of insecurities. I was really young when I started, and I didn't feel like I had really anything to share with the students. And I think that showed up, and it took me a long time to kind of figure that out. So I guess almost my entire track record is one that starts with things not going well, and then just over a long period of time of chipping away, looks like a success on paper. But anytime early in the process would look like an abject failure. So I'm quite familiar with failure in the form of setbacks. I think the ultimate failure though was the wrestling one, where I just quit. That was really the only one I would characterize as a failure. The other ones, because I kept going and staying with it, turned out to work out well, with a lot of scars and bruises, but the failure would've been quitting.

**中文翻译:**
好，我讲几个故事。高中时我参加摔跤。为了进入校队，我大幅减重。因为减重，我的精神状态不太好。总之，高三那年我输掉了一场重要的比赛。然后我退出了，再也没摔过跤。这件事一直困扰着我。所以首先，那是一个失败，对我来说是一个巨大的失败，它一直缠绕着我。在那之后，我对自己许下诺言，绝不让这种事再次发生。上大学后，我尝试参加赛艇队。我年复一年地失败，没能入选校队，没能上船。最终在大四那年取得了一些真正的成功，但在那之前，全是接二连三的失败。在 Alpine，我们的第一只基金亏了钱。在经济衰退期间，我们遇到了真正的麻烦。我想我人生中前八次投资里有五次是亏钱的。在风投界这可能还行，但在私募股权界，这是一个完全不同的比例，而且是一个非常糟糕的比例。刚开始教书时，我教得并不好，有很多不安全感。我开始教书时非常年轻，我觉得自己没有什么真正的东西可以分享给学生。我想这种状态也表现出来了，我花了很长时间才弄明白。所以我猜，我几乎所有的履历都是以“进展不顺”开始的，然后经过长时间的磨练，在纸面上看起来才像是一个成功。但在过程中的任何早期阶段，看起来都像是彻头彻尾的失败。所以我对挫折形式的失败非常熟悉。但我认为真正的失败是摔跤那次，因为我放弃了。那是我唯一会定义为失败的事。其他的经历，因为我坚持了下来，最终结果都很好，虽然带着很多伤痕和淤青，但真正的失败本应是中途放弃。

---

### [01:00:15] [Lenny Rachitsky]

**English:**
I love that the circles back to your core advice of stick with it. Most things that are important take a long time and there's a lot of suffering [inaudible 01:00:24].

**中文翻译:**
我喜欢这个回答，它绕回了你的核心建议：坚持下去。大多数重要的事情都需要很长时间，并且伴随着很多痛苦。

---

### [01:00:24] [Graham Weaver]

**English:**
Yeah, they do. Yeah.

**中文翻译:**
是的，确实如此。

---

### [01:00:26] [Lenny Rachitsky]

**English:**
Something I wanted to ask, I can't help but ask at this point, because I think a lot of people are wondering this, just when do you quit? When should you quit something? Because some things are just not worth it. Is there any advice there you could share?

**中文翻译:**
有一件事我忍不住想问，因为我想很多人都在思考这个问题：什么时候该放弃？什么时候应该放弃某件事？因为有些事情确实不值得。关于这一点你有什么建议吗？

---

### [01:00:37] [Graham Weaver]

**English:**
Yes, for sure. I think the time to quit is when you can no longer see the vision and you can no longer really believe the vision. And then when that happens for a long period of time ... or maybe you're no longer even excited about the vision; somewhere in there, I think. The excited one, you have to be a little careful of, because in the dark days, exciting is not the word you're going to use. But at least in our company, for the first 10 years it was not going well. But each time, we'd make fewer mistakes, we'd start to see something working. We'd do one really good deal in this fund, we'd start to learn from that. We'd get one really good hire, we'd learn from that. We would little by little start to see these green shoots. And I have this unbelievable statement. I didn't write it. Dan and Chip Heath wrote it in their book, Switch, which is "Scale your bright spots. Find what's working and do more of that." And as you start to progress, for me, for example, at Alpine, almost all the time, we always had at least a small glimmer of a bright spot. And then we'd scale that and then we'd continue forward and we'd find some more and we'd scale those. And over time, all those bright spots became our business. That became what we did. That became our strategy. That became how we hired people. That became where we recruited from. All those bright spots just started to magnify until the entire business was pretty much a bright spot. But it took time, because we had to figure out where those were. And we had to do a lot of things wrong to figure out where the bright spots were.

**中文翻译:**
是的，当然。我认为放弃的时机是当你不再能看到愿景，不再能真正相信愿景的时候。当这种情况持续了很长一段时间……或者也许你甚至不再对愿景感到兴奋；我想大概就在那个节点。关于“兴奋”这一点要小心，因为在黑暗的日子里，“兴奋”不是你会用的词。但至少在我们的公司，前 10 年进展并不顺利。但每一次，我们犯的错误都会减少，我们开始看到一些奏效的东西。我们在基金里做成了一笔非常好的交易，我们从中学习；我们招到了一个非常优秀的人才，我们从中学习。我们一点一点地看到了这些“绿芽”。我有一句非常推崇的话，不是我写的，是 Dan 和 Chip Heath 在《瞬变》（Switch）一书里写的：“放大你的亮点（Scale your bright spots）。找到行之有效的方法，并多做那些事。”当你开始进步时，比如对我来说，在 Alpine，几乎所有时间里，我们总能看到至少一点微弱的亮点。然后我们放大它，继续前进，再找到更多亮点并放大。久而久之，所有这些亮点汇聚成了我们的业务。那成了我们的事业，成了我们的战略，成了我们招聘人才的方式，成了我们招人的来源。所有这些亮点开始放大，直到整个业务几乎全都是亮点。但这需要时间，因为我们必须弄清楚亮点在哪里。而且我们必须做错很多事情，才能发现亮点在哪里。

---

### [01:02:19] [Lenny Rachitsky]

**English:**
Graham, is there anything else that you wanted to share or you think is important to leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
Graham，在进入非常精彩的闪电轮环节之前，你还有什么想分享的，或者你认为对听众很重要的建议吗？

---

### [01:02:25] [Graham Weaver]

**English:**
I mean, I think what I would say is just in general, you got one life, you get one shot. And so take the time to really figure out and answer the question, what does a wonderful, amazing, incredible life look like? And just get as clear as you possibly can on that. No matter how crazy or aspirational it seems, write it down. Write down that thing is write down that thing that would make this life amazing. And write it down for your life, your career, your relationships, your friends, your body, your spirituality, your financial situation. And just the first magic is just knowing what you want. And I'd say 90% of people never even know what they want. So take the time to do that. And the more clear you are on that, the more invested you are in that, the more likely you are to make it come true.

**中文翻译:**
我想说的是，总的来说，你只有一次生命，只有一次机会。所以花点时间真正弄清楚并回答这个问题：一个精彩、奇妙、不可思议的人生是什么样的？尽可能清晰地描述它。无论它看起来多么疯狂或多么遥不可及，把它写下来。写下那些能让这一生变得精彩的事情。为你的生活、职业、关系、朋友、身体、精神追求和财务状况分别写下来。第一步魔力仅仅在于“知道你想要什么”。我想说 90% 的人甚至从未知道自己想要什么。所以花时间去做这件事。你越清晰，投入越多，就越有可能实现它。

---

### [01:03:18] [Lenny Rachitsky]

**English:**
What I love about that is you don't have to do this thing, just step one is understand what it could be if you could do that.

**中文翻译:**
我喜欢这一点：你不需要马上就去做，第一步只是理解如果你能做到，它会是什么样子。

---

### [01:03:18] [Graham Weaver]

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:03:27] [Lenny Rachitsky]

**English:**
And it's almost like understand where your Google directions could take you if you turned off autopilot. Oh, man. Okay. Well, with that, Graham, we reached our very exciting lightning round. Are you ready?

**中文翻译:**
这就像是理解如果你关掉自动驾驶，你的谷歌地图导航能带你去哪里。噢，天哪。好，Graham，我们进入了非常精彩的闪电轮环节。准备好了吗？

---

### [01:03:37] [Graham Weaver]

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### [01:03:39] [Lenny Rachitsky]

**English:**
First question, what are two or three books that you find yourself recommending most to other people?

**中文翻译:**
第一个问题，你最常向别人推荐的两三本书是什么？

---

### [01:03:44] [Graham Weaver]

**English:**
So in the realm of a lot of the topics we've been talking about, which is your internal and external game, I love the book Untethered Soul. And I love the book, Don't Believe Everything You Think. They have very similar themes, but they come at it differently. But I think both of those will really change your perspective if you read them. And then a very, very practical book that's probably the book I've read more than any other book, is How to Win Friends and Influence People, by Dale Carnegie, which was written in like 1930. There's no other book it. There's a reason that people are still recommending it 100 years after it's written. So it's definitely worth checking out.

**中文翻译:**
在关于我们讨论的很多话题（即内在和外在博弈）的领域，我喜欢《不被束缚的灵魂》（Untethered Soul）。我也喜欢《别相信你所想的一切》（Don't Believe Everything You Think）。它们的主题非常相似，但切入点不同。我认为读这两本书真的会改变你的视角。然后是一本非常非常实用的书，可能是我读过次数最多的书，那就是戴尔·卡耐基的《人性的弱点》（How to Win Friends and Influence People），写于 1930 年左右。没有其他书能与之相比。人们在它出版 100 年后仍在推荐它，这是有原因的。所以绝对值得一读。

---

### [01:04:31] [Lenny Rachitsky]

**English:**
Yeah, that book, I still think about it often, even though I read it 30 years ago at this point. I love that recommendation. And it's like a very old book to read, but you have to get past the fact that it was written a long time ago. Okay, next question. Do you have a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
是的，那本书，即使我已经读了 30 年了，现在仍然经常想起它。我喜欢这个推荐。虽然它是一本很老的书，但你必须克服它写于很久以前这个事实。好，下一个问题。你最近有没有特别喜欢的电影或电视剧？

---

### [01:04:48] [Graham Weaver]

**English:**
I, for the first time, watched the movie Where the Crawdads Sing. And I just loved it. It's kind of a romantic comedy, or not comedy, sorry, romantic love story meets murder mystery, meets coming of age. And it really, really touched me. Then I promptly read the book as well, so I love that.

**中文翻译:**
我第一次看了电影《沼泽深处的女孩》（Where the Crawdads Sing）。我非常喜欢。它有点像浪漫喜剧——哦不是喜剧，抱歉——是浪漫爱情故事结合了谋杀悬疑和成长题材。它真的深深打动了我。然后我立刻也读了原著，非常喜欢。

---

### [01:05:14] [Lenny Rachitsky]

**English:**
Do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
你最近有没有发现什么非常喜欢的电子产品或生活用品？

---

### [01:05:17] [Graham Weaver]

**English:**
I'm a really big fan of sleep. I think it makes a massive difference in your life. And that's a whole other topic we could go down another time. So I have a few things that have helped me on that. So if you saw me sleeping, I have earplugs, I have a noise machine. I have a sleep mask, and then I have a Chilipad that goes on my bed to keep the bed cool. And I sleep great. All those things really help. The earplugs and mask and noise machine allow you to not hear the ambient noise. And then there's a lot of research actually on the temperature at which you want to sleep. And your body goes up and down throughout the night. So this Chilipad that goes under your mattress, there's a whole bunch of versions of that. And that helps a lot.

**中文翻译:**
我是睡眠的忠实粉丝。我认为睡眠对生活有巨大的影响。这是另一个我们可以下次再聊的话题。我有几样东西在这方面帮了我大忙。如果你看到我睡觉的样子，我戴着耳塞，开着白噪音机，戴着眼罩，床上还有一个 Chilipad（水冷床垫）来保持床铺凉爽。我睡得非常好。所有这些都很有帮助。耳塞、眼罩和白噪音机让你听不到环境噪音。事实上，有很多关于睡眠理想温度的研究，你的体温在整晚都会起伏。这种垫在床垫下的 Chilipad 有很多版本，非常有帮助。

---

### [01:06:11] [Lenny Rachitsky]

**English:**
I also sleep with an eye mask. My wife and I rotate the earplugs, because someone has to pay attention to the baby, in case he wakes up.

**中文翻译:**
我也戴眼罩睡觉。我和妻子轮流戴耳塞，因为总得有人留意宝宝，万一他醒了。

---

### [01:06:18] [Graham Weaver]

**English:**
There you go. Yeah.

**中文翻译:**
原来如此。

---

### [01:06:20] [Lenny Rachitsky]

**English:**
And this Chilipad, is this the Eight Sleep, or is this in just a cold bag?

**中文翻译:**
这个 Chilipad，是 Eight Sleep 那种，还是只是个冰袋？

---

### [01:06:24] [Graham Weaver]

**English:**
Well, no. So I actually bought the Eight Sleep, and it was too much.

**中文翻译:**
哦不。我其实买过 Eight Sleep，但它功能太多了。

---

### [01:06:27] [Lenny Rachitsky]

**English:**
Yeah, it's a lot.

**中文翻译:**
是的，确实挺复杂的。

---

### [01:06:28] [Graham Weaver]

**English:**
It would turn on and off. And I would wake up. And then it would track my sleep, and then I'd start to freak out because it'd tell me I wasn't sleeping well. So I actually returned it and I got a really simple one called OOLER. And it just turns on and off. There's no timing. There's no any weird functionality. And it was a lot cheaper, and it works better for me. So everyone use their own thing, but that one worked better for me.

**中文翻译:**
它会自动开启和关闭，我会因此醒来。然后它会追踪我的睡眠，接着我会开始抓狂，因为它告诉我睡得不好。所以我把它退了，买了一个非常简单的叫 OOLER 的。它只有开关，没有定时，没有奇怪的功能。它便宜得多，而且对我来说效果更好。每个人都有自己的选择，但这个更适合我。

---

### [01:06:55] [Lenny Rachitsky]

**English:**
Okay, two more questions. Do you have a favorite life motto that you often think about that you find useful in work or in life?

**中文翻译:**
好，还有两个问题。你有没有一句经常想起的、在工作或生活中非常有用的座右铭？

---

### [01:07:02] [Graham Weaver]

**English:**
I love this quote that sums up a lot of what we talked about in the podcast. It's by Howard Thurman. And he says, "Don't ask what the world needs. Ask instead what makes you come alive, because what the world needs most is for you to come alive." And I think that just talks about it's really about you coming alive that's the most important thing. And that is going to have so much positive exhaust in the world. And things from that will come that you can't even imagine right now.

**中文翻译:**
我非常喜欢 Howard Thurman 的这句话，它总结了我们在播客中讨论的很多内容。他说：“不要问世界需要什么。而要问什么能让你充满活力，因为世界最需要的，就是你充满活力地活着。”我认为这说明了，你真正焕发生机才是最重要的。这会给世界带来巨大的积极影响。从中会产生你现在甚至无法想象的事情。

---

### [01:07:38] [Lenny Rachitsky]

**English:**
I was thinking of that quote as you were describing your philosophy. Final question. I feel like a lot of people might be listening to this being like, "I came here for one of the most legendary private equity investors of all time, and you don't talk about private equity at all." So let me just use this opportunity to ask you just a question here. What do you look for in a company that you want to buy that maybe other people don't? Is there some insight you could share?

**中文翻译:**
当你描述你的哲学时，我也想到了那句话。最后一个问题。我觉得很多人听这个播客可能会想：“我是冲着这位传奇私募股权投资人来的，结果你根本没谈私募股权。”所以让我借此机会问你一个问题：在你想收购的公司中，你会看重哪些别人可能不看重的东西？有什么见解可以分享吗？

---

### [01:08:04] [Graham Weaver]

**English:**
Yeah. Well, I'm happy to talk about private equity, by the way. It's just that we talked-

**中文翻译:**
好啊。顺便说一下，我很乐意谈论私募股权。只是我们刚才聊了——

---

### [01:08:10] [Lenny Rachitsky]

**English:**
We'll do another episode on that. This could be a whole podcast episode. I understand.

**中文翻译:**
我们会再做一集专门讨论那个。那可以单独做一集播客。我明白。

---

### [01:08:13] [Graham Weaver]

**English:**
Really happy to talk about that about. So I'll answer the question more like, what's a little bit of a different philosophy that we have? So when we were coming out of the recession and I hired this coach, we looked at all of our companies. And we were looking for where did we make our most money, and what was the most consistent trend? And we looked at valuation, growth rates, capital structure, geography, industry. We cut the data every way you could imagine. And we had these three companies that kept showing up on all these lists that were three of our top performers, but they didn't seem to really have anything in common. And then we're like, "Well, they have one thing in common, which is they started off really badly, so badly in fact that we put our own person from Alpine in to go run the company, and then they ended up becoming our best companies." So we said, "Wait a second. Maybe that's the highly correlated thing, is us putting our own team in place, and even upstream of that, maybe just having an incredible management team." So that was foundational. And now, we put our own leadership team in 100% of the time. And not only that, but we have spent an inordinate amount of time trying to build a program to help people who are in their late 20s, early 30s learn how to become CEOs. And that's been foundational. So the thing that we probably believe to be true that not that many people agree with us on is that the management team is really where we think all the alpha comes from. You can't get the industry wrong, because if you hire the best management team in the world to run a typewriter business, you're going to lose money. So you can't be wrong on the industry, but you also don't have to be perfect on the industry. You have to have a good enough industry and then a world-class management team. And we found that to be a really good formula for consistent returns. And it's way more fun because you're literally in a board meeting with someone that is on your side of the table, because you hired them and put them in. And so you're building the company together. And they're bringing a lot of similar values. And so it's been a real differentiator for us.

**中文翻译:**
非常乐意。我来回答一下我们有什么不同的理念。当我们走出经济衰退、我聘请了那位教练时，我们审视了所有的公司。我们寻找我们在哪里赚到了最多的钱，以及最一致的趋势是什么。我们查看了估值、增长率、资本结构、地理位置、行业。我们以你能想象到的各种方式切分数据。结果有三家公司一直出现在这些榜单上，它们是表现最好的三家，但它们看起来似乎没有任何共同点。然后我们发现：“好吧，它们确实有一个共同点，那就是它们起步非常糟糕，糟糕到我们不得不派 Alpine 自己的人去经营公司，结果它们最终成了我们最好的公司。”于是我们说：“等等。也许高度相关的因素是——我们派驻了自己的团队，或者更进一步说，仅仅是拥有一个极其优秀的管理团队。”这成了我们的基石。现在，我们百分之百会派驻自己的领导团队。不仅如此，我们还花了大量时间建立一个项目，帮助二十多岁到三十出头的人学习如何成为 CEO。这一直是我们的核心。所以，我们坚信的一点（虽然很多人不同意）是：管理团队才是所有“超额收益”（alpha）的来源。你不能选错行业，因为如果你雇佣世界上最好的管理团队去经营打字机业务，你还是会亏钱。所以行业不能选错，但也不必追求完美。你只需要一个足够好的行业，加上一个世界级的管理团队。我们发现这是获得持续回报的一个非常好的公式。而且这更有趣，因为在董事会会议上，坐在桌子对面的人是和你站在同一战线的，因为是你雇佣并派驻了他们。你们在一起共同建设公司，他们带来了相似的价值观。这对我们来说是一个真正的差异化优势。

---

### [01:10:32] [Lenny Rachitsky]

**English:**
I have so many questions, but I'm going to cut it off there. We could do another episode going deep on all this. Graham, this was amazing. I think we're going to be helping a lot of people with what they want to do with their lives, and if nothing else, give them a little opportunity to break out of autopilot, at least for a little bit. Two final questions. Where can folks find you online if they want to maybe follow up, ask maybe some other questions that they are thinking as they hear this? And then how can listeners be useful to you?

**中文翻译:**
我有太多问题想问了，但就此打住吧。我们可以再做一集深入探讨这些。Graham，这太棒了。我认为我们会帮助很多人弄清楚他们想如何度过一生，至少给了他们一个摆脱“自动驾驶模式”的机会。最后两个问题：如果听众想跟进或问一些听完后的问题，在哪里可以在线找到你？以及，听众可以为你做些什么？

---

### [01:10:56] [Graham Weaver]

**English:**
My website's grahamweaver.com, and I have a blog on there as well as a lot of videos and different things. And then on Instagram and TikTok, I'm grahamcweaver. And then on LinkedIn, I'm Graham Weaver. And on YouTube, I think I'm Graham C. Weaver. So Graham C. Weaver will pretty much get you on all those channels. How can listeners be helpful? I would say I'd love to hear from you. So my best way to reach me is grahamweaverblog.com. And tell me what's on your mind. I may not respond 100%, but I will read all the emails. And then if you're interested, subscribe to my blog. So go to my website, grahamweaver.com, and I have a blog where I talk about a lot of the topics that we're talking about today.

**中文翻译:**
我的网站是 grahamweaver.com，上面有我的博客，还有很多视频和其他内容。在 Instagram 和 TikTok 上，我的账号是 grahamcweaver。在 LinkedIn 上是 Graham Weaver。在 YouTube 上应该是 Graham C. Weaver。搜 Graham C. Weaver 基本上就能在所有渠道找到我。听众能帮上什么忙？我想说，我很想听听你们的想法。联系我的最好方式是访问 grahamweaverblog.com。告诉我你在想什么。我可能无法百分之百回复，但我会阅读所有的邮件。如果你感兴趣，可以订阅我的博客。去我的网站 grahamweaver.com，我在博客里讨论了很多我们今天谈到的话题。

---

### [01:11:44] [Lenny Rachitsky]

**English:**
Amazing. Graham, thank you so much for being here.

**中文翻译:**
太棒了。Graham，非常感谢你能来。

---

### [01:11:45] [Graham Weaver]

**English:**
Thank you, Lenny.

**中文翻译:**
谢谢你，Lenny。

---

### [01:11:46] [Lenny Rachitsky]

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at LennysPodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 LennysPodcast.com 找到所有往期节目或了解更多信息。下期节目见。