# Gustaf Alstromer - 双语对照

This is the complete bilingual (English-Chinese) transcript of Lenny's Podcast featuring Gustaf Alstromer.

---

### [00:00:00] Gustaf Alströmer

**English:**
If I drill down what makes companies fail, it's quite simple. It's just like they don't talk to users, which means they don't find product market fit. And if they don't find product market fit, nothing else really matters. What mistakes do people make is like it is all about that. It's all about talking to customers and learning that you're building something that's actually useful. YC Slack headline is make things people want, and it's still true and it's always going to be true.

**中文翻译:**
如果我深入剖析公司失败的原因，其实非常简单。那就是他们不与用户交流，这意味着他们找不到产品市场契合度（Product Market Fit）。如果找不到产品市场契合度，其他任何事情都无关紧要。人们会犯什么错误？核心就在于此。关键在于与客户交谈，并了解到你正在构建的东西确实是有用的。YC 的 Slack 标题是“创造人们想要的东西”（Make things people want），这在过去是真理，将来也永远是真理。

---

### [00:00:30] Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard-one experiences building and growing today's most successful products. Today my guest is Gustaf Alstromer. Gustaf is a group partner at Y Combinator where he's been for almost six years. Prior to that, Gustaf was at Airbnb for over four years where he started the original Airbnb growth team and where I was very lucky to get to work alongside him for a number of years. Gustaf is also at the heart of YC's increased focus on climate tech, and in my opinion is one of a handful of people who've had an incredible impact on the increasing amount of investment and people flowing into climate tech.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中辛勤换来的经验。今天的嘉宾是 Gustaf Alstromer。Gustaf 是 Y Combinator 的团体合伙人（Group Partner），他在那里已经工作了快六年。在此之前，Gustaf 在 Airbnb 工作了四年多，他创建了最初的 Airbnb 增长团队，我有幸在那里与他共事多年。Gustaf 也是 YC 加大对气候科技（Climate Tech）关注的核心人物。在我看来，他是少数几个对气候科技领域投资增加和人才涌入产生巨大影响的人之一。

---

### [00:01:10] Lenny

**English:**
We chat in depth about what's happening in climate tech, why things have shifted so much recently, what's new and exciting, and how to think about the space if you're hoping to make the jump. We also get deep into Gustaf's experience working with over 600 startups over his time at YC. We talk about what are the most common mistakes that early stage startups and founders make, what advice YC partners give founders most often, the most common attributes of successful founders, the importance of having a technical co-founder and why that's the case, so much more. I guarantee you will leave this episode smarter and more inspired and I can't wait for you to hear it. With that, I bring you Gustaf Alstromer after a short word from our wonderful sponsors.

**中文翻译:**
我们将深入探讨气候科技领域正在发生的事情、为什么最近情况发生了如此大的变化、有哪些新鲜且令人兴奋的进展，以及如果你希望投身这一领域该如何思考。我们还将深入探讨 Gustaf 在 YC 期间与 600 多家初创公司合作的经验。我们会讨论初创公司和创始人最常犯的错误、YC 合伙人最常给创始人的建议、成功创始人的共同特质、拥有技术联合创始人的重要性及其原因，等等。我保证听完这期节目你会变得更睿智、更有启发，我迫不及待想让你们听到它。在听完我们优秀赞助商的简短广告后，让我们欢迎 Gustaf Alstromer。

---

### [00:01:53] Lenny (Sponsor: Linear)

**English:**
This episode is brought to you by Linear. Let's be honest, the issue tracker that you're using today isn't very helpful. Why is it that always seems to be working against you instead of working for you? What does it feel like such a chore to use? Well, Linear is different. It's incredibly fast, beautifully designed, and it comes with powerful workflows that streamline your entire product development process from issue tracking all the way to managing product roadmaps. Linear is designed for the way modern software teams work. What users love about Linear are the powerful keyboard shortcuts, efficient GitHub integrations, cycles that actually create progress, and built-in project updates that keep everyone in sync. In short, it just works. Linear is the default tool of choice among startups and it powers a wide range of large established companies such as Vercel, Retool and Cash App. See for yourself why product teams describe using Linear as magical visit linear.app/lenny to try Linear for free with your team and get 25% off when you upgrade. That's linear.app/lenny.

**中文翻译:**
本期节目由 Linear 赞助。老实说，你现在使用的问题追踪工具（Issue Tracker）并不好用。为什么它总是感觉在和你作对，而不是在帮你？为什么用起来像是一种负担？Linear 则不同。它速度极快，设计精美，并配有强大的工作流，可以简化从问题追踪到管理产品路线图的整个产品开发过程。Linear 是为现代软件团队的工作方式而设计的。用户喜爱 Linear 的原因包括强大的键盘快捷键、高效的 GitHub 集成、能真正推动进度的“周期”（Cycles）功能，以及让所有人保持同步的内置项目更新。简而言之，它就是好用。Linear 是初创公司的首选工具，也为 Vercel、Retool 和 Cash App 等大型成熟公司提供动力。亲自去看看为什么产品团队形容使用 Linear 像魔法一样吧，访问 linear.app/lenny 免费试用，升级时可享受 25% 的折扣。网址是 linear.app/lenny。

---

### [00:03:02] Lenny (Sponsor: Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing platform built by Airbnb alums for modern growth teams. Companies like Netlify, Contentful, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to wasted time building internal tools while trying to run your experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved about our experimentation platform was being able to easily slice results by device, by country, and by user stage. Eppo does all that and more, delivering results quickly, avoiding annoying prolonged analytics cycles, and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic clickthrough metrics and instead you turn north star metrics like activation, retention, subscriptions, and payments. Eppo supports test on the front end, the back end, email marketing and even machine learning clients. Check out Eppo at getepo.com. Get, E-P-P-O.com, and 10X your experiment velocity.

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 A/B 测试平台。Netlify、Contentful 和 Cameo 等公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能与现代增长团队的技术栈完美集成。这导致人们在浪费时间构建内部工具，或者试图通过笨重的营销工具来运行实验。当我在 Airbnb 时，我最喜欢我们的实验平台的一点就是能够轻松地按设备、国家和用户阶段切分结果。Eppo 实现了这一切甚至更多，它能快速交付结果，避免烦人的漫长分析周期，并帮你轻松找到发现问题的根本原因。Eppo 让你超越基本的点击率指标，转而关注激活、留存、订阅和支付等北极星指标。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。请访问 getepo.com（G-E-T-E-P-P-O.com）查看 Eppo，让你的实验速度提升 10 倍。

---

### [00:04:15] Lenny

**English:**
Gustaf, welcome to the podcast.

**中文翻译:**
Gustaf，欢迎来到播客。

---

### [00:04:17] Gustaf Alströmer

**English:**
Thank you, Lenny. Honestly, it's so great to see you. I'm excited to be talking to you.

**中文翻译:**
谢谢你，Lenny。老实说，见到你太好了。很高兴能和你交流。

---

### [00:04:22] Lenny

**English:**
I've been looking forward to this conversation for a while ever since we booked this. We worked together at Airbnb for many years. I was really lucky to get to work with you before you moved on to bigger and better things at YC. Speaking of Airbnb, you once tweeted about how special an experience that was for you, and I think even more interestingly, how many of the people that have left Airbnb can't find another place that's as special that just like that bar has been set too high. And so my first question is just like, what do you think it was that made Airbnb so special? Why was it such an important experience for you and other people? And even more importantly, just what is it that you take from that experience that you bring to startups that you work with now?

**中文翻译:**
自从我们约好之后，我一直很期待这次对话。我们在 Airbnb 共事多年。在你去 YC 追求更伟大的事业之前，我有幸能和你一起工作。说到 Airbnb，你曾经发推说那段经历对你来说多么特别，而且更有趣的是，很多离开 Airbnb 的人都找不到另一个同样特别的地方，就像标杆被设得太高了。所以我的第一个问题是，你认为是什么让 Airbnb 如此特别？为什么它对你和其他人来说是如此重要的经历？更重要的是，你从那段经历中汲取了什么，并带到了你现在合作的初创公司中？

---

### [00:05:02] Gustaf Alströmer

**English:**
Yeah, it's funny. I think this year in a couple of months it'll be 10 years ago since you and me started Airbnb.

**中文翻译:**
是的，很有趣。我想再过几个月，就是你和我加入 Airbnb 的 10 周年了。

---

### [00:05:07] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:05:08] Gustaf Alströmer

**English:**
It was 2012. The reason I treated that was I asked everyone that I'd met after Airbnb, because I had this experience of like, this was the highlight of my career up until then, at least being in the team like that and I asked everyone, "Have you found anything better?" Besides maybe one or two people, I haven't heard anybody say that they found something better. And they all missed that dearly. I thought a lot about why that was the case, but I would say Airbnb did not feel like a normal job. It felt like more like a group of friends trying to just do something together and we were friends. At least in the beginning it did not feel like this was a job. It was sort of like an ongoing project and an assembly of amazing people. I think in the end we managed to build two things, like a really successful company, thanks to Joe and Nate and Brian just for starting this. Without them there would be nothing to build.

**中文翻译:**
那是 2012 年。我发那条推特的原因是，我问过每一个在离开 Airbnb 后遇到的人，因为我有这种感觉：至少在当时，在那样一个团队里是我职业生涯的高光时刻。我问每个人：“你找到更好的地方了吗？”除了可能一两个以外，我没听任何人说他们找到了更好的。他们都非常怀念那段时光。我思考了很多为什么会这样，我想说 Airbnb 感觉不像一份普通的工作。它更像是一群朋友试图一起做点什么，而我们确实是朋友。至少在开始的时候，感觉不像是在上班。它更像是一个持续进行的项目，一群了不起的人聚集在一起。我认为最终我们成功建立了两个东西：一个是非常成功的公司，这要感谢 Joe、Nate 和 Brian 创立了它，没有他们就无从谈起。

---

### [00:06:04] Gustaf Alströmer

**English:**
I think people don't like to use the word family, but I feel like that way because when I go and meet with Airbnb alumnis from that team. We have a very special bond that reminds me of close social connections more than anything else. It does not remind me of coworkers. I asked myself why this was the case. The best answer I have is probably we brought in a special type of people. We had very diverse backgrounds. A lot of us was former founders. Not many of us were career people from the technology industry of the early days, not many of us.

**中文翻译:**
我觉得人们不喜欢用“家庭”这个词，但我确实有那种感觉，因为当我见到那个团队的 Airbnb 校友时，我们之间有一种非常特殊的纽带，这让我想到的是亲密的社交关系，而不是同事关系。我问自己为什么会这样。我能给出的最好答案可能是我们招募了一群特殊的人。我们的背景非常多样化。我们中很多人以前都是创始人。在早期，我们中很少有人是那种纯粹在科技行业打拼的职业经理人。

---

### [00:06:37] Gustaf Alströmer

**English:**
I think that bar that we set, the first, I believe when I joined there was probably five or seven PMs and there was 30 engineers or something and you joined a little bit before me, those people set the bar or set the standard of what we were looking for afterwards. I think it took a long time to change that narrative. I mean, eventually you have to hire people that only had big corporation careers, but I don't remember we did that for a long time. When I actually read my goodbye note recently, my words there still means a lot to me and it means sort of like you're trying to reflect on exactly these things on like, building a great company that became successful and being part of this sort of family of really close friends.

**中文翻译:**
我认为我们设定的那个标准——我加入时大概只有 5 到 7 个 PM，30 个左右的工程师，你比我早一点加入——那些人设定了我们后来寻找人才的标准。我认为花了很长时间才改变这种叙事。我的意思是，最终你不得不雇佣那些只有大公司职业生涯的人，但我记得我们很长一段时间都没有那样做。当我最近读到我的离职信时，那里的文字对我来说仍然意义重大，它代表了对这些事情的反思：建立一家成功的伟大公司，并成为这个由亲密朋友组成的“家庭”的一员。

---

### [00:07:21] Lenny

**English:**
So it sounds like if you had to boil down what Airbnb did, it sounds like hiring was the main piece that impacted the way it turned out just like the founders being very specific about the type of people they were hiring.

**中文翻译:**
所以听起来，如果你必须总结 Airbnb 做了什么，招聘似乎是影响最终结果的最主要因素，就像创始人对他们招聘的人选类型非常挑剔一样。

---

### [00:07:32] Gustaf Alströmer

**English:**
Absolutely.

**中文翻译:**
绝对是这样。

---

### [00:07:32] Lenny

**English:**
Is there anything that's like, I don't know, a take away there of just what you recommend to founders, like hiring. People know, be very careful who you hire. The first, I don't know, 10 people will impact the culture long term. But I don't know. Is there anything just abstracting away there of just what to look for in that first batch of hires?

**中文翻译:**
有没有什么可以总结出来的建议给创始人？比如招聘。大家都知道要非常小心地选择雇佣谁，前 10 个人会长期影响文化。但除此之外，在第一批员工中应该寻找什么样的特质？

---

### [00:07:50] Gustaf Alströmer

**English:**
It's a tricky one because I would like to say that all the things that we did were the cost of the outcome of this, but that's not really how the world works. Some of the things we did work, some of the things that we did did not work. It's hard for us to actually disentangle what those things are, but I think we can talk about the things that we did. First of all, we made sure we hired people that were really excited to be there, right? They wanted to build Airbnb and they were really excited to work on Airbnb. That was the most important thing. Of course people had other offers, but I think you can figure out from those offers are you excited to be here or not. So that was probably the first thing.

**中文翻译:**
这是一个棘手的问题，因为我很想说我们所做的一切都是导致这个结果的原因，但世界并非如此运作。我们做的一些事情奏效了，一些则没有。我们很难真正理清哪些是关键因素，但我们可以谈谈我们做过的事。首先，我们确保雇佣的人是真的渴望加入的，对吧？他们想建设 Airbnb，对在 Airbnb 工作感到非常兴奋。这是最重要的。当然，人们会有其他的录用通知（Offer），但我认为你可以从这些 Offer 中判断出他们是否真的对这里感兴趣。这可能是第一点。

---

### [00:08:30] Gustaf Alströmer

**English:**
The second thing I think is trying to understand the true motivations of the people that were there, like lower, "Why are you here?" We did something we call culture interviews that I think the founders have written about or there's probably content online about this. We did a lot of culture interviews early on to try to figure out we got the people that were there that mapped our core values and were really excited to work on Airbnb. I think finally, I don't know how this happened, we did pick people from diverse backgrounds. Most startups don't have most of the PMs being former founders, but I believe that was the case for the first 10 or 12 or 15 PMs at Airbnb. A lot of us were former founders. I think that that made a big difference for how you make decisions and how you get started on things.

**中文翻译:**
第二点我认为是试图理解人们的真实动机，比如深挖“你为什么在这里？”我们做了一些被称为“文化面试”的事情，我想创始人写过相关文章，网上应该也有内容。我们在早期做了大量的文化面试，试图确保招到的人符合我们的核心价值观，并且对在 Airbnb 工作充满热情。最后，我不知道这是怎么发生的，我们确实挑选了背景多样的人。大多数初创公司的 PM 并不全是前创始人，但我相信 Airbnb 的前 10 到 15 个 PM 都是这种情况。我们中很多人以前都创过业。我认为这对于你如何做决定以及如何开始做事情产生了巨大的影响。

---

### [00:09:21] Gustaf Alströmer

**English:**
I think I actually see this a lot in the Airbnb founders. They really care about the time at YC and they tried to recreate YC inside Airbnb a couple of times with demo day and with so new products completely isolated from the rest, starting with doing things that don't scale and talking to customers. So I think that that experience had made a big impact on them, but it's hard to say just these two things go and apply these things. It's actually kind of hard to say, "Well that will work at it as Airbnb." I think that's a really tricky question to answer.

**中文翻译:**
我实际上在 Airbnb 创始人身上经常看到这一点。他们非常看重在 YC 的那段时光，并尝试在 Airbnb 内部多次重现 YC 的模式，比如举办演示日（Demo Day），让新产品完全独立于其他部门，从“做那些无法规模化的事情”（Doing things that don't scale）和与客户交谈开始。所以我认为那段经历对他们影响很大。但很难说只要应用这两点就行，也很难说“这在 Airbnb 行得通，在别处也行”。这是一个很难回答的问题。

---

### [00:09:51] Gustaf Alströmer

**English:**
The last thing I would say is Airbnb had an incredible business model, an incredible business from early on and it was hard to fail. What I mean by that is it's hard to fail with a company. You can fail with individual things inside the company, but a company was still going to succeed. I think we all felt that. A lot of companies don't have the ability to take risks like Airbnb did early on because they don't have something that's so obviously great.

**中文翻译:**
最后我想说的是，Airbnb 从早期就拥有令人难以置信的商业模式和业务，很难失败。我的意思是，公司整体很难失败。你可能会在公司内部的某些具体事情上失败，但公司依然会成功。我想我们当时都感受到了这一点。很多公司没有能力像早期的 Airbnb 那样冒险，因为他们没有那种显而易见的伟大产品。

---

### [00:10:18] Lenny

**English:**
That's a really interesting point on the last piece that you may have the most amazing culture and hire incredibly well, but if the company doesn't work out, it's not going to be looked back as like, "Wow, that was an amazing experience, but we failed."

**中文翻译:**
最后一点很有意思。你可能拥有最棒的文化，招聘也做得非常好，但如果公司没做成，人们回顾时就不会觉得“哇，那是一段奇妙的经历，虽然我们失败了”。

---

### [00:10:30] Lenny

**English:**
Yeah, that's interesting. So you mentioned YC and this kind of is a good segue to where I want to focus most of our time. You mentioned that you've worked with over 600 companies at this point, which is absurd. It feels like it's you get some statistical significance on takeaways at this point of what works and doesn't work. So I have just a bunch of questions about your experience working at YC and with all these companies. The first is I think about this quote that Elad Gill tweeted once and he wrote, I think, a post about it. Elad Gill is a legendary angel investor. He said that starting a company is an act of desperation. You're either desperate to change the trajectory of your career or you're desperate to make a bunch of money, you're desperate to achieve some kind of mission or build a specific product that you're just like, "I need this to exist." I'm curious if you agree with that sentiment and then I have a follow-up question around that.

**中文翻译:**
是的，很有趣。你提到了 YC，这正好可以过渡到我想重点讨论的话题。你提到目前为止你已经和 600 多家公司合作过，这太惊人了。感觉你现在对“什么行得通、什么行不通”的总结已经具有统计学意义了。所以我有很多关于你在 YC 工作以及与这些公司合作经验的问题。第一个问题是关于 Elad Gill 曾经发过的一条推特，他后来还写了一篇文章。Elad Gill 是一位传奇的天使投资人。他说创业是一种“绝望之举”（Act of desperation）。你要么是渴望改变职业轨迹，要么是渴望赚大钱，要么是渴望实现某种使命或构建某个你觉得“必须存在”的特定产品。我很好奇你是否同意这种观点，然后我还有一个后续问题。

---

### [00:11:20] Gustaf Alströmer

**English:**
Yeah, actually I haven't heard it before, but you know me, I'm an optimistic person. I think it probably reflects on my view of this question, but I would say desperation sounds like a negative place that you're starting at. I actually think that most people to start companies start from a positive place. But the motivations, I agree with what he said, can be very diverse for successful founders, right?

**中文翻译:**
是的，其实我以前没听过这个说法。但你知道我，我是一个乐观的人。这可能反映了我对这个问题的看法。我想说，“绝望”听起来像是一个负面的起点。我实际上认为大多数创业的人是从一个积极的起点开始的。但关于动机，我同意他所说的，成功创始人的动机可以非常多样化，对吧？

---

### [00:11:41] Gustaf Alströmer

**English:**
So we actually asked this in one of the early Group Office Hours sessions. We asked them, "Why are you doing this?" And we don't want to hear an answer like, "I found this niche of the market.' That's not the why. The why is like, "Why will you come in and work late after four years when you have no money left and everything's going to shit?", right? Then the niche market is not the answer. There's something deeper than that. We've learned that it varies a lot for people's motivations to start companies. Some of them just want to solve some technical problem that they feel are passionate about solving. Some of them want to prove themselves in front of others or prove themselves towards themselves. Some have grand really important motivations to change the world and they will say things like, "I want to give everyone water or I want to solve climate change or I want to democratize publishing." You can imagine any number of large ideas. Some people just want to start a big company and just want to be successful.

**中文翻译:**
我们在早期的“小组咨询时间”（Group Office Hours）中确实问过这个问题。我们问他们：“你为什么要这么做？”我们不想听到诸如“我发现了这个细分市场”之类的答案。那不是“为什么”。真正的“为什么”是：“为什么在四年后，当你没钱了，一切都变得一团糟时，你还会留下来加班？”那时候，细分市场就不是答案了。一定有比这更深层的东西。我们发现人们创业的动机差异很大。有些人只是想解决某个他们充满热情的技能问题。有些人想在别人面前证明自己，或者向自己证明。有些人有改变世界的宏大动机，他们会说：“我想让每个人都能喝上水”或者“我想解决气候变化”或者“我想让出版民主化”。你可以想象任何宏大的想法。有些人只是想创办一家大公司，只是想获得成功。

---

### [00:12:44] Gustaf Alströmer

**English:**
It doesn't matter, in my experience, what your motivation is. I don't think either of these motivations. It sounds like some of them will be better than others. In my experience, it's not the case. The motivation will change over time to just running this thing, right? Like once something becomes big, it's hard to think every day about exactly why you got started because the motivation is just like it can be fun and work on boring things because it's fun to build something big. Everything doesn't have to be shiny and big and grandiose because there are many ideas that are "boring," but just the idea of running the company becomes the motivation eventually.

**中文翻译:**
根据我的经验，你的动机是什么并不重要。我不认为这些动机中有高下之分。听起来好像有些动机比其他的更好，但在我看来并非如此。随着时间的推移，动机往往会转变为“经营这件事”本身。一旦事情做大了，你很难每天去想当初为什么要开始，因为动机变成了：即使是处理无聊的事情也很有趣，因为建立一个庞大的事业本身就很有趣。并非所有事情都必须是闪耀、宏大和华丽的，因为有很多想法看起来很“无聊”，但最终经营公司的过程本身就成了动力。

---

### [00:13:17] Lenny

**English:**
That is really interesting that one of the main things you look for, it sounds like when you're interviewing, is how strong and durable is that drive to build this company. Is that what you're saying?

**中文翻译:**
这很有趣。听起来你在面试时寻找的主要特质之一，就是这种建立公司的驱动力有多强、多持久。是这个意思吗？

---

### [00:13:26] Gustaf Alströmer

**English:**
It's actually kind of hard for screen for motivation, I would say, in interviews because the purpose of this kind of Office Hour question is to highlight why someone is there and highlight the diversity of reasons people are there and sometimes even highlight from one founder to another co-founder why they are doing this. They might have never talked about this. Actually, surprisingly, often founders have not talked about why they're doing this. And just knowing why someone is here really helps with conflict resolution for example, really helps with understanding why someone is there on a certain day or something like that. So it's not something we screen for as much as I think we try to help founders discover this among themself and really know this about themself. I've just accepted that the motivations to start companies is widely diverse.

**中文翻译:**
说实话，在面试中筛选动机其实挺难的。这种 Office Hour 问题的目的是为了揭示某人为什么在那儿，展示人们动机的多样性，有时甚至是让联合创始人之间互相了解对方为什么要这么做。他们可能从未谈论过这个。事实上，令人惊讶的是，创始人往往没有讨论过他们为什么要创业。了解某人为什么在这里，对于解决冲突非常有帮助，也有助于理解某人在某天的状态。所以，这与其说是我们筛选的东西，不如说是我们试图帮助创始人自我发现并真正了解自己的东西。我已经接受了创业动机是极其多样化的这一事实。

---

### [00:14:13] Lenny

**English:**
Do you ever discourage founders from starting a company when you see that maybe it won't be a durable kind of lasting motivation or whatever other reasons just knowing how hard starting a company ends up being?

**中文翻译:**
当你看到某个人的动力可能不持久，或者出于其他原因（考虑到创业有多难），你是否曾经劝阻过创始人不要创业？

---

### [00:14:23] Gustaf Alströmer

**English:**
It's a good question. I would say sometimes if someone doesn't have a motivation or don't know why they're doing this, they're doing this because they read that it would be a natural career step. So a good reason to not start a company is if you think of starting a company as a career step. Well, it is not. Because if it's successful, it'll be your entire career. It'll be 10 years most likely. And if it's not successful, then it's not something that people generally aspire to start. So non-successful startups. So I think people will start companies because this is sort of something they want to put on their resume. They have not understood what startups are or why you should do them.

**中文翻译:**
好问题。我想说，有时如果某人没有动力或者不知道为什么要这么做，他们只是因为读到这是一种“自然的职业步骤”才去做的。那么，不创业的一个好理由就是：如果你把创业仅仅看作一个职业步骤。事实上，它不是。因为如果成功了，它将是你整个职业生涯，很可能是 10 年。如果失败了，那也不是人们通常渴望开始的事情。所以我认为，如果人们创业只是为了在简历上添一笔，那他们还没理解什么是初创公司，或者为什么要创业。

---

### [00:14:58] Gustaf Alströmer

**English:**
Sometimes you can screen and kind of figure this out, but sometimes people don't even know why they're starting a company when they get started and it kind of gets figured out along the way. And that's okay. I don't want to discourage people who don't know exactly why they're starting this company just to start a company. They might figure out along the way and find the true motivation after doing this for a little bit or finding that it's really fun.

**中文翻译:**
有时你可以通过筛选发现这一点，但有时人们在开始时甚至不知道自己为什么要创业，而是在过程中逐渐弄明白的。这没关系。我不想仅仅因为某人不知道确切原因就劝阻他们。他们可能会在过程中找到答案，在做了一段时间后发现真正的动力，或者发现这真的很有趣。

---

### [00:15:21] Gustaf Alströmer

**English:**
I think I discourage people to start startups if they have so many other things that are important than their life that are more important than the startup. So if there are financial constraints or family constraints or relationship constraints and they are going to trump this, then yeah, you should think a second time perhaps because startups are hard. They're much harder than a normal job. Equally hard if they're successful or failure, right? There's no middle way, we're like, "Oh, my company is doing great so I can chill." That doesn't work that way either. So I don't really discourage or encourage people, I just want them to have all the information.

**中文翻译:**
我认为，如果一个人的生活中有很多其他事情比创业更重要，我会劝阻他们。如果有财务压力、家庭束缚或感情问题，而这些会压倒创业，那么你应该再三考虑，因为创业非常艰难。它比普通工作难得多。无论成功还是失败，过程都同样艰辛。没有中间地带，比如“哦，我的公司做得很好，所以我可以放松了”。事实并非如此。所以我并不真正劝阻或鼓励人们，我只是希望他们掌握所有的信息。

---

### [00:16:03] Lenny

**English:**
You mentioned YC Office Hours and I had a question around this. I'm working on this piece where I'm interviewing a bunch of B2B founders of companies that are doing super well and I asked them a few questions like, "How'd you come up with the idea? How'd you find your first few customers?" it's shocking how many of them bring up a conversation in YC Office Hours as the most pivotal point that set them on the trajectory that they're on now. I'm curious what happens in these Office Hours? What are the most common pieces of advice that you give or maybe most surprising pieces of advice that you give in these Office Hours so that people can get maybe a glimpse into these conversations you have?

**中文翻译:**
你提到了 YC Office Hours，我有一个相关的问题。我正在写一篇文章，采访了一群发展得非常好的 B2B 创始人。我问了他们一些问题，比如“你是怎么想到这个主意的？你是如何找到前几个客户的？”令人震惊的是，他们中有很多人提到 YC Office Hours 中的一次谈话是决定他们现在发展轨迹的最关键点。我很好奇在这些 Office Hours 里发生了什么？你最常给出的建议是什么，或者你给出的最令人惊讶的建议是什么？能不能让大家窥见一下这些对话的内容？

---

### [00:16:43] Gustaf Alströmer

**English:**
So at YC we have two type of Office Hours, two of the common ones. We have regular Office Hours, which is usually a one-on-one or basically the founders talking to me, or me plus another partner. They happen every week or every other week throughout the entire program. And they happen years after the program on the regular basis. Then we have Group Office Hours, which is you and six or seven other startups talking to us. They have [inaudible 00:17:07] a little bit different purpose. So the goal of the regular Office Hour, I always ask the question, "What's holding you back from moving faster? We don't want to hear updates, we don't want to hear strategy questions. We want to understand what's slowing you down or what's holding you back from moving even faster. You generally have a specific goal."

**中文翻译:**
在 YC，我们有两种常见的 Office Hours。一种是常规的 Office Hours，通常是一对一，或者是创始人跟我谈，或者是我加另一位合伙人。在整个项目期间，这些谈话每周或每两周进行一次。在项目结束后多年，这些谈话仍会定期进行。另一种是小组咨询（Group Office Hours），是你和另外六七家初创公司一起跟我们谈。它们的目的一点点不同。常规 Office Hour 的目标是，我总是问一个问题：“是什么阻碍了你跑得更快？我们不想听进展更新，不想听战略问题。我们想了解是什么让你慢了下来，或者是什么阻碍了你跑得更快。你通常都有一个特定的目标。”

---

### [00:17:27] Gustaf Alströmer

**English:**
And I think that question of what's slowing you down or were holding you back crystallizes the priorities. There are only so many things you can do as a startup and there are only so many things that matters at that stage. And by asking that question, we can start digging into, "Okay, what's the goal? What are the things that drives towards that goal? What are the things that's slowing you down towards that goal?" Usually, the founders don't know what's slowing it down, so the conversation and us probing questions actually leads to us or them discovering what it is just slowing them down.

**中文翻译:**
我认为“是什么让你慢下来”或“是什么阻碍了你”这个问题能让优先级变得清晰。作为一家初创公司，你能做的事情有限，而在那个阶段重要的事情也有限。通过问这个问题，我们可以开始挖掘：“好，目标是什么？哪些事情是朝着那个目标驱动的？哪些事情在阻碍你实现那个目标？”通常，创始人并不知道是什么在拖慢进度，所以通过我们的对话和追问，最终会让我们或他们发现到底是什么在拖后腿。

---

### [00:17:59] Gustaf Alströmer

**English:**
In the Group Office Hour, it's a little bit different. The Group Office Hour holds a couple of different purposes. One of them is if I think back on Paul and Jessica's motivation to start YC, this is a surprise to them, but starting a company is incredibly lonely. You can't really lean on your employees and say, "Hey, I'm feeling really shitty as a founder today. Everything is going to shit." Employees isn't going to take that well. So you lean on perhaps your investors, but they're not really available. But what you can lean on is other founders because they're all in the same situation. It's sort of like when you ask a founder the question, "How are things going?", it's so emotional for them to answer that question because it's never going well, right? It's never like, "Oh, everything is going fantastic." They might say that, but everybody knows all founders, when they look each other's eyes, then no, that's not the answer.

**中文翻译:**
在小组咨询（Group Office Hour）中，情况有点不同。它有几个不同的目的。其中之一是，回想 Paul 和 Jessica 创办 YC 的初衷，这让他们感到意外，但创业确实极其孤独。你不能真的依靠你的员工说：“嘿，作为创始人，我今天感觉糟透了，一切都完蛋了。”员工是受不了这个的。所以你可能会依靠你的投资者，但他们并不总是随叫随到。但你可以依靠其他创始人，因为他们都处于同样的境地。这有点像当你问一个创始人“最近怎么样？”时，他们回答这个问题会非常感性，因为情况永远不会是“一切都好”，对吧？永远不会是“哦，一切都太棒了”。他们可能会这么说，但所有创始人在对视时都知道，那不是真实的答案。

---

### [00:18:48] Gustaf Alströmer

**English:**
So founders have infinite number of problems that they're thinking about all the time, which is why they're allergic to the question, "How are things going?" But when YC started, we put all the founders in a group together in a room and they started learning that all founders, all companies are broken in some way, right? They're all having these massive problems and they're all feeling that anxiety when they hear the question, "How are things going?" And just hearing other founders explain their problems, perhaps solving their problems, is a really good way for yourself to both feel motivated to do it yourself and see how problems get solved when other companies are having similar problems. Nowadays because of the scale at YC, we group companies together that have the same problems or the same area that they're operating in.

**中文翻译:**
创始人有无数个问题在脑子里转，这就是为什么他们对“最近怎么样？”这个问题过敏。但当 YC 开始时，我们把所有的创始人都聚在一个房间里，他们开始了解到所有的创始人、所有的公司在某种程度上都是“破碎”的，对吧？他们都有巨大的问题，听到那个问题时都会感到焦虑。仅仅是听其他创始人解释他们的问题，或者看他们如何解决问题，对你自己来说都是一种很好的方式，既能激励你自己去做，也能看到当其他公司遇到类似问题时是如何解决的。现在由于 YC 的规模，我们会把有相同问题或在相同领域运营的公司分在一组。

---

### [00:19:30] Gustaf Alströmer

**English:**
The second thing that Group Office Hours do well is accountability, right? We ask you, "What were your goals? What were your goals for the last two weeks? Did you hit them?" And then that gives founders accountability because founders are competitive. They don't want to look bad. They don't want to come back after two weeks and say "Nothing worked," or at least like, "We didn't learn anything." They want to learn something and make progress whether it's positive or negative.

**中文翻译:**
小组咨询做得好的第二件事是问责（Accountability）。我们会问你：“你的目标是什么？过去两周的目标是什么？你实现了吗？”这给了创始人一种责任感，因为创始人都是好胜的。他们不想丢脸。他们不想在两周后回来时说“什么都没成”，或者至少说“我们什么都没学到”。他们想要学到东西并取得进展，无论是正向的还是负向的。

---

### [00:19:54] Gustaf Alströmer

**English:**
Group Office Hours to me is the most magical moment because it really creates this very intense three or four month period. Founders often come back to us afterwards and say, "Hey, we want to do that again. We don't have this really intense, really productive period. We don't have a program exactly. We have other programs, but we don't have anything exactly that mimics that experience." But we do encourage founders to continue with Group Office Hours after YC. Many of them do and many of them, ad hoc, continue to meet for years in this group setting where they ask the same kind of questions to each other, to hold themselves accountable, to learn from each other, and to just have someone else to lean on. I think this was unknown and somehow the world didn't know before that starting company is super lonely and you have all these anxiety. By just talking to other people who have the same problems, it's just one of the best thing you can do.

**中文翻译:**
对我来说，小组咨询是最神奇的时刻，因为它确实创造了一个非常紧张的三四个月时期。创始人之后经常回来跟我们说：“嘿，我们想再来一次。我们现在没有那种非常紧张、非常高效的时期了。”我们虽然有其他项目，但没有一个能完全模拟那种体验。但我们确实鼓励创始人在 YC 结束后继续进行小组咨询。很多人确实这么做了，很多人多年来一直以这种小组形式非正式地见面，互相问同样的问题，互相督促，互相学习，并找一个可以依靠的人。我认为这在以前是不为人知的，某种程度上，世界以前并不知道创业是超级孤独的，会有这么多焦虑。仅仅通过与有同样问题的人交谈，就是你能做的最好的事情之一。

---

### [00:20:45] Lenny

**English:**
There's so many things that come up when you talk about this. One is I had a startup at one point and we worked in the coworking space. We joined the coworking space because we're like, "Oh, we'll meet other founders. It'll be social, we won't be alone." But it turns out everyone's just heads down, headphones on, "I don't have time for anything. I just need to work." It's like a microcosm of that experience that even if you're surrounded by founders, no one has time to do anything. They're just working.

**中文翻译:**
当你谈到这些时，我想到了很多事情。第一，我曾经创过业，我们在联合办公空间工作。我们加入那里是因为觉得“哦，我们会遇到其他创始人，会有社交，我们不会孤单”。但结果发现每个人都埋头苦干，戴着耳机，“我没时间做任何事，我只需要工作”。这就像是那种经历的一个缩影：即使你身边全是创始人，也没人有时间做任何事，他们只是在工作。

---

### [00:21:09] Gustaf Alströmer

**English:**
You got to schedule it and force it and put the laptops on the floor and the phones on the floor and you just sit there with pen and paper. That's how you have to do it. We tried to mimic that as much as we could over Zoom. But honestly the best experience of this was in person, in a ring, in mountain view with no computers and everyone just paying attention to everyone. That was the best experience. Yeah, that's what I remember is one of the most meaningful parts of YC. I didn't have it myself when I did YC, but now everyone has it.

**中文翻译:**
你必须安排好时间并强迫执行，把笔记本电脑和手机都放在地板上，你就坐在那儿，拿着笔和纸。你必须这么做。我们尝试在 Zoom 上尽可能地模拟这种体验。但老实说，最好的体验是面对面的，在山景城围成一圈，没有电脑，每个人都关注着其他人。那是最好的体验。是的，那是我记忆中 YC 最有意义的部分之一。我自己参加 YC 时还没有这个，但现在每个人都有了。

---

### [00:21:36] Lenny

**English:**
The other thing that's made me think about is someone tweeted once, "Don't ever ask a founder how they're doing or how it's going. It just creates all this anxiety because nothing's ever going great."

**中文翻译:**
另一件事让我想起有人发过推特说：“永远不要问创始人他们过得怎么样或者进展如何。这只会制造焦虑，因为情况永远不会是‘太棒了’。”

---

### [00:21:44] Gustaf Alströmer

**English:**
Don't do it. Everybody looks at each other's eyes and they know that they're allergic to that question.

**中文翻译:**
千万别问。大家面面相觑，都知道彼此对那个问题过敏。

---

### [00:21:50] Lenny

**English:**
That's hilarious. So just to summarize the questions you said you asked, the one is in the individual Office Hours, is what's holding you back. And then in the group setting, what was the question again that you asked?

**中文翻译:**
太好笑了。总结一下你问的问题：在一对一 Office Hours 里，是“什么在阻碍你”；在小组咨询里，你问的问题再重复一遍？

---

### [00:22:01] Gustaf Alströmer

**English:**
What are your goals for next two weeks and what were your goals for the last two weeks and did you hit the goals? And if you didn't hit them, what came in the way of hitting the goals? It's very simple. That can uncover lots of problems that other founders are having exactly in the same way. Just by talking about the things that held you back or the things that allowed you to hit your goals, uncover something material for the other seven companies doing that in the ring.

**中文翻译:**
“你未来两周的目标是什么？你过去两周的目标是什么？你实现了吗？”如果没实现，“是什么阻碍了你实现目标？”非常简单。这可以揭示出其他创始人也同样面临的许多问题。仅仅通过谈论阻碍你的事情或让你实现目标的事情，就能为圈子里的其他七家公司揭示出一些实质性的东西。

---

### [00:22:26] Lenny

**English:**
If you kind of zoomed out a little bit and thought about the startups you've worked with, what would you say are the most common mistakes that early stage startups make broadly?

**中文翻译:**
如果你稍微宏观一点看，回想一下你合作过的初创公司，你会说初创公司在早期最常犯的错误是什么？

---

### [00:22:36] Gustaf Alströmer

**English:**
There's so many. I mean, this is how I initially learned about startups, by searching for that on Google and landing on Paul Graham's articles because he kept-

**中文翻译:**
太多了。我是说，我最初学习创业就是通过在 Google 上搜索，然后读到 Paul Graham 的文章，因为他一直在写——

---

### [00:22:45] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:22:45] Gustaf Alströmer

**English:**
I think I've written many articles about this topic because it is so common. So this topic can go on forever. But if I take the most recent experience I've had in YC, I would say startups fail, one, because they don't talk to customers. And if you don't talk to customers or users, you don't actually know what's important. If you don't know what's important, it doesn't matter what you build, it doesn't matter kind of what ideas you have in your head if you don't actually know what it is that you need to build and you don't validate with customers. That's where a lot of the failure stems from. A lot of early YC for us or early part of the program is us pushing and probing founders to be like, "Tell us about the conversations you've had with the customers. What did you learn? Can you show us the organizations?" Or like all these questions, like, "What are the software they're using? What are they paying for? What problems do they have? How are they describing the intensity of that problem?" So that's what we spent a lot of time early at YC.

**中文翻译:**
我想我也写过很多关于这个话题的文章，因为它太普遍了。所以这个话题可以一直聊下去。但如果以我在 YC 最近的经验来看，我会说初创公司失败的原因，第一是因为他们不与客户交谈。如果你不与客户或用户交谈，你其实不知道什么是重要的。如果你不知道什么是重要的，那么无论你构建什么，无论你脑子里有什么想法，如果你不知道到底需要构建什么，并且没有通过客户验证，那都没用。很多失败都源于此。在 YC 的早期或项目的早期，我们花了很多时间督促和追问创始人：“告诉我们你和客户的谈话内容。你学到了什么？能给我们看看那些组织吗？”或者诸如此类的问题：“他们在使用什么软件？他们在为什么付费？他们有什么问题？他们如何描述那个问题的严重程度？”这就是我们在 YC 早期花大量时间做的事情。

---

### [00:23:43] Gustaf Alströmer

**English:**
After that, I would say one of the commons mistakes in... I'm not talking about generally startups here, I'm talking inside YC. The second most common thing I see in YC is people are just afraid to talk to customers. They're just not trying hard enough to get in front of customers. I think this comes from, technical people tend to think that software is just sort of solution to everything. But really what you should need to do is to talk to someone over Zoom or over phone or in person, even better. People are just afraid of doing that and they're afraid of being rejected. These are common, people that want to build good products are just really afraid of people saying no.

**中文翻译:**
在那之后，我会说在 YC 内部（我不是在泛指所有初创公司）看到的第二大常见错误是：人们只是害怕与客户交谈。他们只是没有足够努力地走到客户面前。我认为这源于技术人员倾向于认为软件就是一切的解决方案。但实际上，你需要做的是通过 Zoom、电话或面对面（更好）与人交谈。人们只是害怕这样做，害怕被拒绝。这很常见，那些想做出好产品的人其实非常害怕别人说“不”。

---

### [00:24:25] Gustaf Alströmer

**English:**
The problem is, which anyone who hasn't done sales before that joined YC, they realize this, is that if you take the average customer group in the world, 90% are not early adopters. It doesn't matter if you have something new and cool, they're just not interested. They are not incentivized to take risks in their job to try something new. They're just incentivized to not take risks and just continue what they're doing. Those 10 percents are the early adopters. They're The ones that you actually want to reach. But that means you have to reach 10 to find one. And then you convince that one person to get on the phone or a video call with you. And that takes work and it takes a lot of work. I think people don't really think of this. This is common knowledge, basic stuff for salespeople, but founders should never done sales before just get surprised by the percentages and the sort of what it means to do this.

**中文翻译:**
问题在于（任何没做过销售的人加入 YC 后都会意识到这一点）：如果你看世界上普通的客户群体，90% 都不是早期采用者（Early Adopters）。不管你有什么新鲜酷炫的东西，他们就是不感兴趣。他们在工作中没有动力去冒险尝试新事物，他们的动力是不冒险，继续做他们正在做的事。剩下的 10% 才是早期采用者。他们才是你真正想接触的人。但这意味着你必须接触 10 个人才能找到 1 个。然后你还要说服那个人接你的电话或视频通话。这需要工作，而且是大量的工作。我认为人们并没有真正考虑到这一点。这对销售人员来说是常识和基础，但以前没做过销售的创始人会对这些比例以及做这件事的难度感到惊讶。

---

### [00:25:12] Gustaf Alströmer

**English:**
If I think of more generally outside of YC, so these are two kind of things I experience within YC, but I think generally outside of YC, I would say the two most common problems the same one is not talking to customers, the other one is not being technical and not knowing what it takes to build successful technology company. It means having technical founders and it means being able to build the first prototype. This is something we screen for when we interview people in YC and we aren't accepting a whole lot of team that don't know how to build or get their first prototype built themselves because we know it is a super common value pattern.

**中文翻译:**
如果我考虑 YC 之外更普遍的情况（刚才那两点是我在 YC 内部体验到的），我认为 YC 之外最常见的两个问题：一个是同样的“不与客户交谈”，另一个是不具备技术背景，不知道建立一家成功的科技公司需要什么。这意味着需要有技术创始人，意味着能够亲手构建第一个原型。这是我们在 YC 面试时会筛选的，我们不会接受太多不知道如何自己构建或搞定第一个原型的团队，因为我们知道这是一个超级常见的失败模式。

---

### [00:25:50] Gustaf Alströmer

**English:**
I can go on and on and on and on for this one, but honestly if I drill down what makes companies fail, it's quite simple. It's just like they don't talk to users, which means they don't find product market fit. And if they don't find product market fit, nothing else really matters. What mistakes do people make is it is all about that. It's all about talking to customers and learning that you're building something that's actually useful. YC Slack headline is make things people want, and it's still true and it's always going to be true.

**中文翻译:**
关于这一点我可以一直说下去，但老实说，如果我深入剖析公司失败的原因，其实很简单。就是他们不与用户交谈，这意味着他们找不到产品市场契合度。如果找不到产品市场契合度，其他任何事情都无关紧要。人们犯的错误全在于此。关键在于与客户交谈，并了解到你正在构建的东西确实是有用的。YC 的 Slack 标题是“创造人们想要的东西”，这现在是真理，将来也永远是真理。

---

### [00:26:23] Lenny

**English:**
This is really interesting and good advice. It's interesting that... Like, "Talk to customers," people hear that all the time. They're like, "Of course we're going to talk to customers. We're going to do that of course." And your experience is they know this but they just don't do it probably because they're afraid. Maybe also because they think they already know what they need to build and it's like, "Yeah, we're good."

**中文翻译:**
这非常有趣，也是很好的建议。有趣的是……像“与客户交谈”这种话，人们听得耳朵都起茧了。他们会说：“当然，我们会和客户谈的，这还用说吗。”而你的经验是，他们知道这一点，但就是不去执行，可能是因为害怕。也许还因为他们认为自己已经知道该构建什么了，觉得“没问题，我们懂”。

---

### [00:26:41] Gustaf Alströmer

**English:**
And you have all these validators, right? So the people are validating that even if you don't talk to customers, why has he accepted you? This investor invested in you. This investor said you were great, like blah blah blah. All these different validations that you confuse with product market fit, right? We have to remind everyone on the first day in YC, "None of you have product market fit because you probably don't," right? Almost nobody has. Because people confuse this external validation with the thing that matters the most, which is talking to customers and learning what matters. It's just like a thing that just keeps coming back. Some get really good at it. And that is the source of successful startups, is when you really get good at this.

**中文翻译:**
而且你还有这些“验证者”，对吧？即使你不和客户谈，人们也在验证你：YC 为什么录取你？这个投资人投了你。那个投资人说你很棒，等等。你把所有这些不同的验证误认为是产品市场契合度，对吧？我们必须在 YC 的第一天提醒每个人：“你们谁都没有产品市场契合度，因为你们大概率确实没有。”几乎没人有。因为人们把这种外部验证与最重要的事情混淆了，最重要的事情是与客户交谈并了解什么才是关键。这就像是一个不断循环的问题。有些人变得非常擅长此道。而这正是成功初创公司的源泉——当你真正擅长这一点时。

---

### [00:27:21] Lenny

**English:**
It reminds me coming back to Airbnb, one of the most important moments in Airbnb history was Paul Graham telling the founders of Airbnb, "Where are your customers?" And they're like, "Oh, they're in New York" and he's like, "Why are you talking to me and not in New York right now talking to them?" And they talk about that all the time.

**中文翻译:**
这让我想起回到 Airbnb 的例子，Airbnb 历史上最重要的时刻之一就是 Paul Graham 问创始人：“你们的客户在哪儿？”他们说：“哦，他们在纽约。”他说：“那你们为什么在跟我谈话，而不是现在就在纽约跟他们谈话？”他们经常提起这件事。

---

### [00:27:35] Gustaf Alströmer

**English:**
Yeah, it's absolutely true. I think he wrote the article Do Things That Don't Scale as a learning.... The learning there was the Airbnb founders doing the trips to New York and learning about how to build Airbnb, which is a very counterintuitive idea, which is when you have to spend the most amount of time with your customers. I think Airbnb is sort of one of the best stories inside YC of doing this well.

**中文翻译:**
是的，绝对是真的。我想他写《做那些无法规模化的事情》（Do Things That Don't Scale）这篇文章就是作为一种总结……其中的教训就是 Airbnb 创始人去纽约出差，学习如何建立 Airbnb。这是一个非常反直觉的想法，即你需要花大量时间与客户在一起。我认为 Airbnb 是 YC 内部把这件事做得最好的故事之一。

---

### [00:27:57] Lenny

**English:**
This also reminds me, I've been talking to a bunch of founders recently. I asked them, "How many customers have you talked to help figure out this idea?" So just the other day it was 150 financial CROs that they talked to before they actually started raising this round. Another company, actually two Airbnb guys that started, they actually ran ads I think on LinkedIn to find specific people to talk to and that specific role. And they talked to probably at least 100, maybe 200. So there's a strong correlation there.

**中文翻译:**
这也让我想起，我最近一直在和一群创始人聊天。我问他们：“为了弄清楚这个想法，你和多少客户谈过？”就在前几天，有人说他们在开始这一轮融资前和 150 位财务总监（CRO）谈过。另一家公司，实际上是两个 Airbnb 的员工创办的，他们甚至在 LinkedIn 上投放广告来寻找特定职位的人进行交谈。他们可能至少谈了 100 个，甚至 200 个。所以这之间有很强的相关性。

---

### [00:28:26] Gustaf Alströmer

**English:**
Yeah, I think that's the volumes that people don't expect. They think they might have to talk to five, but I think you have to talk to 25 to 50. That means you have to reach out to a lot more to be able to get to people that are potentially early adopters. Those ones you talk to are also the ones that become your customers. So you are already doing most of the sales by just doing this work anyway.

**中文翻译:**
是的，我认为这是人们预料不到的数量。他们觉得可能只需要谈 5 个，但我认为你得谈 25 到 50 个。这意味着你必须接触更多的人，才能找到那些潜在的早期采用者。而那些你交谈过的人，最终也会成为你的客户。所以通过做这些工作，你其实已经完成了大部分销售工作。

---

### [00:28:45] Lenny

**English:**
Do you have maybe one tactical tip you could share of just getting over your fear of talking to customers or just holding yourself accountable to actually doing it?

**中文翻译:**
你有没有什么战术上的小技巧可以分享，关于如何克服与客户交谈的恐惧，或者如何督促自己真正去执行？

---

### [00:28:55] Gustaf Alströmer

**English:**
Yeah, I tell this story, I actually told this story yesterday. So remember when you sign up first service that's a cool service and you hear about in TechCrunch or something like that and then you realize you already signed up a year ago, right? And then from the founder's perspective, you sign up to something you never used it. So the founders who build those services, their inclination to think is that "Everybody hates me because they sign up and they never use me." They never use the service. The fear of that is that basically the fear of rejection. So if I put my thing out there and most people won't use it and they will tell all their friends how shitty this thing is, you should never even sign up for it, that's the fear people have, but the truth is that people sign up for it and be like, "Oh, I'm busy. I got something else to do." And they actually don't remember or care.

**中文翻译:**
有的，我讲个故事，其实我昨天刚讲过。记得当你注册第一个酷炫的服务时，你是在 TechCrunch 之类的地方听说的，然后你发现你一年前就已经注册过了，对吧？从创始人的角度来看，你注册了某个东西却从未用过。所以构建这些服务的创始人倾向于认为：“每个人都讨厌我，因为他们注册了却从不用我。”他们从不使用这项服务。这种恐惧本质上是害怕被拒绝。所以如果我把我的东西放出来，大多数人不用，他们就会告诉所有的朋友这东西有多烂，千万别注册——这就是人们的恐惧。但事实是，人们注册了之后会想：“哦，我很忙，我有别的事要做。”他们其实根本不记得也不在乎。

---

### [00:29:43] Gustaf Alströmer

**English:**
So whenever you sign for something that you signed up a year ago, think of yourself that that is the common customer experience, which is that you just sign up for a lot of stuff you don't even remember you. You never have this, "I hate this thing' reaction. You always have this like, "I'm indifferent to this thing. I don't actually care to even complete the sign up flow or try it out," right? I think that's the thing that people need to remember, is that the worst thing that can happen to startup is not that people hate what you're doing, it's that they're completely indifferent to what you're doing. It's not the worst thing, but the most common thing that happens is people just is indifferent. But it doesn't give you a second chance. Let's say, it always gives you a second chance and you really need to internalize that people have busy lives and if people don't actually use what you're building, that's fine. You can reach out to them a year from now or six months from now or two weeks from now and they probably will if you make some improvements.

**中文翻译:**
所以，每当你发现自己注册了一个一年前就注册过的东西时，提醒自己这就是普遍的客户体验：你注册了很多东西，甚至都不记得了。你从来不会有“我讨厌这东西”的反应。你总是处于一种“我对这东西无感”的状态。你甚至不在乎是否完成了注册流程或尝试一下，对吧？我认为人们需要记住的是，初创公司可能遇到的最糟糕的事情不是人们讨厌你所做的事情，而是他们对你所做的事情完全无感。这虽然不是最糟的，但最常见的情况就是人们漠不关心。但这并不意味着你没有第二次机会。我想说，你总是有第二次机会的，你真的需要内化这一点：人们的生活很忙碌，如果人们没有真正使用你构建的东西，那没关系。你可以在一年后、六个月后或两周后再次联系他们，如果你做了一些改进，他们可能会尝试。

---

### [00:30:37] Gustaf Alströmer

**English:**
I think people just have this fear that, "If I get a lot of rejection, that means everything is bad." But the rejection should be put in context to the early adopter idea and that most people who don't care are not early adopters, who don't want to dig into new things. And that the more narrow of a solution you have to a specific problem, the fewer people actually want to dig in. But that's where you have to start because you cannot build the whole thing right up front and make everybody loves you. That doesn't really work that way.

**中文翻译:**
我认为人们只是有一种恐惧：“如果我遭到很多拒绝，那就意味着一切都很糟糕。”但拒绝应该放在“早期采用者”的背景下看，大多数不在乎的人并不是早期采用者，他们不想钻研新事物。而且你针对特定问题的解决方案越窄，真正想钻研的人就越少。但你必须从那里开始，因为你不可能一开始就构建出完整的东西并让每个人都爱上你。事情不是那样运作的。

---

### [00:31:07] Gustaf Alströmer

**English:**
Even Airbnb was like air mattresses or staying in someone's homes when they're home. That was not the complete solution of Airbnb. But there were early adopters who dug in and be like, "Yep, I like that. I like those two things. I want to have people stay in my living room in my mattress." But that's not what Airbnb is about today, and a lot of those things were unknown at the time. But I think people are just afraid of rejection and you just need to overcome that fear and just learn that there's nothing that's really that bad that can happen when people don't use the service or sign up and don't care. It's not really that bad.

**中文翻译:**
即使是 Airbnb，最初也只是充气床垫或在别人在家时住在他们家里。那并不是 Airbnb 的完整解决方案。但有一些早期采用者钻研了进去，觉得：“是的，我喜欢。我喜欢这两点。我想让人住在我的客厅床垫上。”但这并不是今天的 Airbnb，当时很多事情都是未知的。但我认为人们只是害怕拒绝，你需要克服这种恐惧，并了解到当人们不使用服务或注册后不在乎时，并没有什么真正糟糕的事情会发生。真的没那么糟。

---

### [00:31:42] Lenny

**English:**
It reminds me of a quote that I always love for Mark Andreessen, that everyone's time is already allocated. They don't have space for your product right now. They already have plans for their day.

**中文翻译:**
这让我想起我一直很喜欢的 Mark Andreessen 的一句话：每个人的时间都已经分配好了。他们现在没有空间留给你的产品。他们已经安排好了这一天。

---

### [00:31:42] Gustaf Alströmer

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:31:51] Lenny

**English:**
And it takes a lot to convince someone to pay attention to anything. I guess that just comes back to why it's so important that your product is solving a real pain and not just a nice little toy that is better than what's out there, but not so much better that you're like, "I need this right now." So maybe just along those lines, do you have any thoughts on just the importance of that pain and just how critical that is?

**中文翻译:**
要说服某人关注任何事情都需要付出很多努力。我想这又回到了为什么你的产品解决真实的痛点如此重要，而不仅仅是一个比现有产品好一点点的小玩具，好得还不足以让人觉得“我现在就需要它”。所以，沿着这个思路，你对这种“痛点”的重要性以及它的关键程度有什么看法？

---

### [00:32:15] Gustaf Alströmer

**English:**
I actually recorded... I'm happy of these videos, but I've recorded two videos on YouTube as part of YC Startup School last fall. You can go watch them on YouTube right now. One of them is how to talk to users and the other one is how you sell or how you use sales. The one about talking to users, I think there's a difference in asking someone, "Do you have a problem with X, Y, Z? Is this podcasting setup working for you?" And people say, "Yeah, it's kind of working." But if you are a podcasting setup experts and you watch people use some other thing that's really shitty, they might also think that it's pretty good. But you have to watch them do it. And the best way for you to figure out what is the intensity of the problem is not to ask them but to watch them or to watch them solve the thing that they do.

**中文翻译:**
我实际上录制了……我对这些视频很满意，去年秋天我作为 YC 创业学院（Startup School）的一部分在 YouTube 上录制了两个视频。你现在就可以去 YouTube 上看。一个是关于如何与用户交谈，另一个是关于如何销售。关于与用户交谈，我认为问某人“你在 XYZ 方面有问题吗？这个播客设置对你有用吗？”和实际观察是有区别的。人们会说：“是的，还行。”但如果你是播客设置专家，你看着人们使用一些非常烂的东西，他们可能还觉得挺好。但你必须观察他们操作。弄清楚问题严重程度的最好方法不是问他们，而是观察他们，观察他们如何解决他们正在做的事情。

---

### [00:33:06] Gustaf Alströmer

**English:**
You know how a lot of non-technical people don't know how to automate things? So they will do the same thing in Excel like a million times by just tapping because that's the only thing that they know and they're not technical enough to write some kind of script to do it, and you just have to watch those people to just feel the pain. You can't actually ask them how difficult is it to do X, y, z because they won't even know that it's that difficult to them. So the best thing I've learned about how to discover the pain is to watch people, have them screen share, have them walk you through their daily workflow about the area where you're doing some discovery. That is the best thing.

**中文翻译:**
你知道很多非技术人员不知道如何自动化吗？所以他们会在 Excel 中重复同样的操作一百万次，只是不停地点击，因为那是他们唯一知道的方法，他们没有足够的技术能力去写某种脚本。你必须观察这些人才能感受到那种痛苦。你不能直接问他们做 XYZ 有多难，因为他们甚至不知道这对他们来说有多难。所以我学到的发现痛点的最好方法就是观察人们，让他们共享屏幕，让他们带你走一遍他们在你正在探索的领域的日常工作流程。那是最好的方法。

---

### [00:33:43] Gustaf Alströmer

**English:**
I'll give you another example. So there's a bunch of waste companies that are doing EV charging for electric cars and they're like, "What are the problems in EV charging?" And I was like, "Just rent an EV and go and charge at all the non Tesla chargers and see what they say, see what you experience." And the truth is that it's just like garbage. A lot of EV charting systems are just so shitty and the apps are terrible. You just have to just use them yourself to know how bad it is.

**中文翻译:**
我再给你举个例子。有一群初创公司在做电动汽车（EV）充电业务，他们问：“电动汽车充电有什么问题？”我说：“去租一辆电动车，去所有的非特斯拉充电桩充电，看看他们怎么说，看看你的体验。”事实是，那简直像垃圾一样。很多电动车充电系统非常烂，App 也做得一塌糊涂。你必须亲自去用，才知道它有多糟糕。

---

### [00:34:13] Lenny

**English:**
It's cool how often it just comes back to, "Just go do the thing. Do things that don't scale." Classic YC advice. I want to come back to something you mentioned that I want to pull a thread on as the technical co-founder, being technical early on, just to cover that. So I know YC looks to... Having a technical founder is an important variable in you're deciding to accept a company. Say someone doesn't have a technical co-founder, do you have any advice for what they could do, like what often can work?

**中文翻译:**
很有意思，兜兜转转总是回到“去做那件事，做那些无法规模化的事情”。经典的 YC 建议。我想回到你提到的一个点，我想深入探讨一下关于技术联合创始人的问题，即早期具备技术能力的重要性。我知道 YC 在决定录取一家公司时，拥有技术创始人是一个重要的变量。假设某人没有技术联合创始人，你对他们有什么建议？通常什么样的方法行得通？

---

### [00:34:41] Gustaf Alströmer

**English:**
Yeah, I think the first thing is to understand the value of technical co-founder. So some people who are in this situation where they have an idea of something they want to build and they don't have anyone to help build them in building it, I had a friend Paul who gave this incredible quote, he said, "I have an idea for a song, I just need a musician to help me make it," right? That's kind of similar to how it is with engineering. If you view output of engineering as like, "I just have an idea for a song, I just need someone to actually make it for me" and then you're not valuing software engineering or mechanical engineering or any engineering skill set deep enough, right?

**中文翻译:**
是的，我认为第一件事是理解技术联合创始人的价值。有些人处于这种境地：他们有一个想构建的东西的想法，但没有人帮他们构建。我有一个朋友 Paul 说过一句很棒的话，他说：“我有一个关于歌曲的想法，我只需要一个音乐家帮我把它做出来。”这和工程领域的情况很像。如果你把工程产出看作“我只是有一个关于歌曲的想法，我只需要有人帮我把它做出来”，那么你对软件工程、机械工程或任何工程技能的价值理解得就不够深，对吧？

---

### [00:35:17] Gustaf Alströmer

**English:**
The truth is that the engineering part is the really hard part. The first thing I would say is you need to learn how to value the engineering piece. Let me give you an example of how you don't do that. You applied to YC and you have 90% for yourself and 10% for the engineer. You're basically saying that like, "Oh, the engineering part of this company is only worth 1/10th of me. I'm the non-technical person." So that to me is a signal that you're not really valuing engineering.

**中文翻译:**
事实是，工程部分才是真正困难的部分。我要说的第一点是，你需要学会如何重视工程部分。让我举个反面例子。你申请 YC，你自己占 90% 的股份，给工程师 10%。你基本上是在说：“哦，这家公司的工程部分只值我的十分之一，而我是那个非技术人员。”对我来说，这就是一个信号，说明你并没有真正重视工程。

---

### [00:35:44] Gustaf Alströmer

**English:**
Okay, so how do you go out about and find someone? Well, the truth is that there are a lot of technical co-founders. The technical people, they also want to find business co-founders. They don't want to do other part. They don't want to do sales and they actually don't really care that much about fundraising. They just want to solve the problem. And that's fine. We built something called co-founder matching where those funders can meet, but if you don't participate in that, you can just start by asking the best technical people that you know. "Are you interested in starting a company with me?" Same thing with rejection. Many of them will just say, "No, I have a great job, I'm really happy." But some of them will have thought about starting a company for a while and was hoping that someone would come and ask them to do that. So you have to remove your fears and go and ask the best people.

**中文翻译:**
好，那么你该如何去寻找这样的人呢？事实是，有很多潜在的技术联合创始人。技术人员也想找业务联合创始人。他们不想做另一部分工作，不想做销售，其实也不太在乎融资。他们只想解决问题。这没关系。我们建立了一个叫“联合创始人匹配”（Co-founder Matching）的平台，让这些创始人可以见面。但如果你不参与那个，你可以从询问你认识的最优秀的技术人员开始：“你有兴趣和我一起创业吗？”同样会面临拒绝。他们中的许多人会说：“不，我有一份很棒的工作，我很开心。”但其中一些人可能已经考虑创业很久了，正希望有人来邀请他们。所以你必须消除恐惧，去询问最优秀的人。

---

### [00:36:29] Gustaf Alströmer

**English:**
The reason you want to have a technical co-founder and not a hired engineer or not a hired contracting team is because so many of the decisions you're going to make are technical and so many of the iterations you're going to make relies on engineering. And if you don't understand that, you won't actually make the right decisions anyway. It's not like service. You have an idea for a product, you build a product and you're done. There's infinite number of iterations in that process.

**中文翻译:**
你需要技术联合创始人而不是雇佣的工程师或外包团队的原因是，你将要做的很多决定都是技术性的，你将要做的很多迭代都依赖于工程。如果你不理解这一点，你无论如何都无法做出正确的决定。这不像提供服务。你有一个产品的想法，你构建了产品，然后就结束了。在这个过程中有无数次的迭代。

---

### [00:36:54] Gustaf Alströmer

**English:**
And then finally, I would say a lot of people learn how to code themselves, right? So there are a lot of places online that you can learn the skillset that takes to build a prototype. You might not be the best engineers. So there are many successful startup founders who are not the best engineers because they stop coding when they hire three or four engineers, that's fine. But you need to be sufficiently good that you understand the value of engineering and that you understand that the best way to solve most of the problem is with software. There are a lot of founders who just, for whatever reason, study something else that doesn't have to be a conscious or very precise reason that you had when you were 18 or 19 and then you're 25, you're like, "Oh, I wish I know how to code" and then just learn to code and they learn how to code. It's not that more difficult than that.

**中文翻译:**
最后，我想说很多人是自学编程的，对吧？网上有很多地方可以学习构建原型所需的技能。你可能不会成为最顶尖的工程师。很多成功的初创公司创始人并不是最好的工程师，因为他们在雇佣了三四个工程师后就停止写代码了，这没关系。但你需要足够优秀，以便理解工程的价值，并理解解决大多数问题的最佳方式是软件。有很多创始人因为各种原因在 18 或 19 岁时学了别的专业，到了 25 岁时想：“哦，我真希望我会编程”，然后就去学了。并没有想象中那么难。

---

### [00:37:42] Lenny

**English:**
Have you ever seen a startup work out if they had a contracting firm, like engineering firm build a product? Does that ever work or were you just like, "No, do not ever do this"?

**中文翻译:**
你见过有初创公司通过外包公司（比如工程外包公司）构建产品并最终成功的吗？这行得通吗，还是你会说“不，永远不要这样做”？

---

### [00:37:53] Gustaf Alströmer

**English:**
Basically, I can't recall any specific ones where people have a contracting firm but I've recalled founders where let's say you had two non-technical founders, but they valued engineering and they had an ability to build a team of great people that were not co-founders and they gave them equity and they become successful. There are many examples of that I would say, but I don't remember any specific examples where you had a contracting team building the whole thing. I think the reason for that is it takes more than just sort of riding a spec to build a product. You can't actually spec yourself to a great product. You have to just be part of the iterations yourself. That's why I think someone being the engineer, having the idea of what iteration looks like and just doing it is how you do things.

**中文翻译:**
基本上，我不记得有哪家具体的公司是靠外包公司成功的。但我记得有些创始人，比如有两个非技术创始人，但他们非常重视工程，并且有能力建立一支由非联合创始人组成的优秀团队，给他们股权，最终获得了成功。这样的例子有很多。但我记不起有任何具体的例子是靠外包团队构建了整个产品的。我认为原因是，构建产品不仅仅是写一份规格说明书（Spec）。你不可能靠写 Spec 写出一个伟大的产品。你必须亲自参与迭代。这就是为什么我认为，有人担任工程师，对迭代有想法并亲手去实现，才是做事情的方式。

---

### [00:38:38] Gustaf Alströmer

**English:**
I think that the cases where I've seen non-technical founders make this work is that they have really good engineering teams who feel like they're founding team. It might not be co-founders per YC-7 definition of having 10%, but they feel like they're the bonding team.

**中文翻译:**
我认为我见过的非技术创始人成功的案例，是因为他们拥有非常优秀的工程团队，这些团队感觉自己就是创始团队。按照 YC 的定义，他们可能不是拥有 10% 股份的联合创始人，但他们感觉自己是核心团队。

---

### [00:38:52] Lenny

**English:**
This reminds me of a story of just the recent podcast interview I did with the CPO of Calendly. She talked about how when Calendly started, they actually had a Ukrainian dev team built the first product. Not only did they help them build the first product, they actually ended up driving all the growth initially because they saw Calendly and started using it within their firm.

**中文翻译:**
这让我想起我最近采访 Calendly CPO 的一个故事。她谈到 Calendly 刚开始时，实际上是让一个乌克兰开发团队构建了第一个产品。他们不仅帮着构建了第一个产品，实际上最初所有的增长都是由他们驱动的，因为他们看到了 Calendly 并开始在自己的公司内部使用它。

---

### [00:39:14] Gustaf Alströmer

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:39:14] Lenny

**English:**
And then everyone that they knew started using it and spread within Ukraine and they actually continue to work with that firm. They're still the [inaudible 00:39:20] team for Calendly or some part of it.

**中文翻译:**
然后他们认识的每个人都开始使用它，并在乌克兰传开了。实际上他们现在还在和那家公司合作。他们仍然是 Calendly 的核心团队或其中一部分。

---

### [00:39:22] Gustaf Alströmer

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:39:24] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:39:24] Gustaf Alströmer

**English:**
Wow, that's cool.

**中文翻译:**
哇，那太酷了。

---

### [00:39:24] Lenny

**English:**
There's a success story.

**中文翻译:**
这是一个成功案例。

---

### [00:39:26] Gustaf Alströmer

**English:**
I mean, I would say it's certainly the case that in some countries people have other jobs while they start the startups, so like the engineers. In Ukraine for example or in Eastern Europe, it's very common that if they start their own startup, they actually have a full-time job as a contractor while they're starting the startup because that's how you pay the bill because often you can't raise money. And that's fine too.

**中文翻译:**
我想说，在某些国家，人们在创业时确实会有其他工作，工程师也是如此。例如在乌克兰或东欧，非常普遍的情况是，如果他们创办自己的公司，在创业初期实际上还有一份全职的外包工作，因为那是付账单的方式，毕竟通常筹不到钱。这也没问题。

---

### [00:39:46] Lenny

**English:**
Amazing. That's some hustle.

**中文翻译:**
太棒了。真是够拼的。

---

### [00:39:49] Lenny (Sponsor: Pando)

**English:**
This episode is brought to you by Pando, the always on employee performance platform. How much do you love the performance review process? Yeah, it's time-consuming, subjective, biased, and there's rarely any transparency. With the rapid shift to distributed work, it's a struggle to create the structure and transparency that you want to help your employees have the highest impact and growth in their careers. Pando is disrupting the old paradigm of performance management, including a continuous employee-centric approach so employees stay engaged, see their progression in real time, and know exactly when and how they can level up. With Pando, managers can leverage competency-based frameworks to effectively coach and develop their teams and align on consistent growth standards resulting in higher quality feedback and higher performing teams. Visit pando.com/lenny for more info and get a special discount when you sign up and reference this podcast. That's pando.com/lenny.

**中文翻译:**
本期节目由 Pando 赞助，这是一个“始终在线”的员工绩效平台。你有多喜欢绩效评估流程？是的，它耗时、主观、有偏见，而且几乎没有透明度。随着向分布式工作的快速转变，建立你想要的结构和透明度以帮助员工在职业生涯中产生最高影响力和增长，成了一项挑战。Pando 正在颠覆旧的绩效管理范式，采用以员工为中心的持续方法，让员工保持参与感，实时看到自己的进步，并确切知道何时以及如何晋升。通过 Pando，经理可以利用基于能力的框架有效地指导和培养团队，并统一一致的增长标准，从而获得更高质量的反馈和更高绩效的团队。访问 pando.com/lenny 了解更多信息，并在注册时提及本播客以获得特别折扣。网址是 pando.com/lenny。

---

### [00:40:47] Lenny

**English:**
I want to zoom out a little bit and ask another big question and see what answer you have for this. If you just think about the most successful startups in YC or even just the companies you worked with, if you had to pick just one or two attributes of what's most common across successful companies, what would that be?

**中文翻译:**
我想稍微宏观一点，再问一个大问题，看看你有什么答案。如果你回想一下 YC 最成功的初创公司，或者仅仅是你合作过的公司，如果你必须挑选一两个成功公司最普遍的共同特质，那会是什么？

---

### [00:41:04] Gustaf Alströmer

**English:**
I would say the most common reason that I've seen founders succeed or companies succeed, it comes down to the founders and characteristics of those individuals. The most important characteristics of those individuals are they're really determined to win and they don't give up when things are hard and they have an internal motivation that's just really infectious to people around them, which is how they end up building really good teams around them. People are actually going to want to go and work for them. I have numerous examples of people like this where the CEO or one of the founders are just really inspirational people.

**中文翻译:**
我会说，我所见过的创始人或公司成功的最高频原因，归根结底在于创始人及其个人特质。这些人最重要的特质是：他们有极强的求胜欲，在困难面前绝不放弃，并且拥有一种能感染周围人的内在动力，这正是他们能够建立优秀团队的原因。人们真的会想去为他们工作。我有很多这样的例子，CEO 或其中一位创始人是非常有感染力的人。

---

### [00:41:42] Gustaf Alströmer

**English:**
The second thing I would say is they are technical. So that's kind of like they're technical enough. If I would grade companies on a scale of technical to less technical, more technical founders are more likely to succeed, I would say. And then I would say they figure out how to talk to users and move fast early on so they don't wait for permission from their investors or from YC or from someone else to make progress. They're like, every day or every week there's continuous progress. They're not doing this for someone else, they're doing this for the customers. They're not doing this for the investors, that's for sure. The investors are sort of in the way more or less. And they're just naturally focusing on the customers.

**中文翻译:**
第二点我会说是技术背景。也就是说他们足够懂技术。如果我按技术含量高低给公司分级，我会说技术背景更强的创始人更有可能成功。然后我会说，他们知道如何与用户交谈并在早期快速行动，所以他们不会等待投资者、YC 或其他任何人的许可才去取得进展。他们每天或每周都有持续的进展。他们不是为了别人在做这件事，而是为了客户。肯定不是为了投资者。投资者在某种程度上甚至是碍事的。他们只是自然而然地专注于客户。

---

### [00:42:29] Gustaf Alströmer

**English:**
Finally, what I would say is the skill that's really attributed to great founders is excellent communication skills. So the ability to communicate really complicated ideas clearly, to enjoy the communication part, right? Enjoying communication is often kind of correlated with enjoying doing fundraising, which is an important part of some companies' success. Not all of them, but for some of them. I would say communication or storytelling is part of the same arc, right? And those are part of the same thing that actually motivates people around you. If you can communicate why you're building, what you're building and why it's important to the world, tell a story about that, that can motivate people around you to just want to follow you. I think it's rare that I've seen founders succeed where the founder isn't in some way an inspirational person or someone that is a good communicator. Most of the time, you at least have respect or you somewhere know that they're going to succeed, right? And that is what inspires you to be around them or be on their team.

**中文翻译:**
最后，我认为伟大创始人真正具备的技能是卓越的沟通能力。即清晰地传达复杂想法的能力，并且享受沟通的过程。享受沟通通常与享受融资相关联，而融资是某些公司成功的重要组成部分。并非所有公司，但对某些公司来说是这样。我会说沟通或讲故事是同一环的一部分，对吧？这些都是激励周围人的因素。如果你能传达出你为什么要构建这个产品、你在构建什么以及为什么它对世界很重要，讲好这个故事，就能激励周围的人追随你。我很少见到不具备感染力或不擅长沟通的创始人能获得成功。大多数时候，你至少会尊重他们，或者在内心深处知道他们会成功，对吧？这就是激励你留在他们身边或加入他们团队的原因。

---

### [00:43:33] Lenny

**English:**
That is a really cool list. So just to summarize, one, they have the strong will to win, and with that they're inspirational. They kind of pull people along and get people really excited. Two is they're more likely to succeed if they're technical and can build a thing. Three, they figure out how to talk to customers, don't wait, just start doing it. And they're just obsessed with that versus what investors want them to do and they don't want to talk to the investors to make time for the customers. And then excellent communication skills, which comes back to the first. They're able to story tell and get people excited. Is that right?

**中文翻译:**
这是一份非常棒的清单。总结一下：第一，他们有强烈的求胜欲，并因此具有感染力，能带动并激励大家。第二，如果他们懂技术、能亲手做东西，就更有可能成功。第三，他们知道如何与客户交谈，不等待，直接开始做，并且对此非常痴迷，而不是纠结于投资者想要什么，他们甚至不想和投资者谈话，以便腾出时间给客户。最后是卓越的沟通能力，这又回到了第一点，他们能够讲好故事并让人们兴奋起来。对吗？

---

### [00:44:06] Gustaf Alströmer

**English:**
Yeah, I would say those are the attributes of successful things. To be a super successful company, there's something else that have to happen. Those things are not things you can put on a list because they are the outliers, right? If you look at startups on a typical YC batch, there'd be a couple billion companies. Those are the outliers. They'll almost certainly have all the things that we've talked about. Many other companies in the batch will have that too, but then what makes someone a true outlier is something that is unknown. That's why so many investors said no to Airbnb when they were not trying to raise money because that was an outlier idea. It was an idea that was not logical and did not make sense to most people. Those kind of ideas, the ones that end up succeeding often don't make sense to people. There's some reason that no one has done this before because they're just not natural next step of the world.

**中文翻译:**
是的，我会说这些是成功事物的特质。但要成为一家超级成功的公司，还需要发生一些别的事情。那些事情是你无法列在清单上的，因为它们是“离群值”（Outliers），对吧？如果你看一个典型的 YC 批次中的初创公司，会有几家价值数十亿的公司。那些就是离群值。他们几乎肯定具备我们讨论过的所有特质。批次中的许多其他公司也会具备，但让某人成为真正离群值的原因是未知的。这就是为什么当 Airbnb 试图筹款时，那么多投资者拒绝了他们，因为那是一个离群的想法。那是一个不合逻辑、对大多数人来说都说不通的想法。这类最终成功的想法通常在当时都让人觉得不可思议。之所以以前没人做过，是因为它们并不是世界发展的自然下一步。

---

### [00:44:57] Lenny

**English:**
That's a great segue to a question I've been meaning to ask, which is, how good are you at predicting in a batch which startups are going to be the monster hits? So maybe like you and then just generally YC, how good are you all at knowing what's going to work out, is going to be the next Airbnb or Dropbox?

**中文翻译:**
这很好地引出了我一直想问的一个问题：你在一个批次中预测哪些初创公司会成为“巨无霸”的能力如何？无论是你个人还是整个 YC，你们在预知谁会成为下一个 Airbnb 或 Dropbox 方面有多擅长？

---

### [00:45:14] Gustaf Alströmer

**English:**
I think the truth is that we're not very good at knowing what's going to succeed. Certainly we cannot figure out who's going to be the really successful company in the batch. That's not possible. What we're good at is knowing what failure looks like. What we sometimes like to tell founders at the beginning of the batch is like, "If you fail, please do it in some new exciting way. Not one that we've seen 100 times." Because we have seen people fail for a large number of reasons. The best way for us to sort of not predict, but the best way for us to make more companies succeed is to tell them how they might fail, right? Be very direct and honest with them and say, "You doing these three things, these things are likely going to lead that you won't succeed." And if we do our job well, most people get that feedback and they're on the track for succeeding.

**中文翻译:**
我认为事实是，我们并不擅长预知谁会成功。我们肯定无法找出一个批次中谁会成为那家真正成功的公司。那是不可能的。我们擅长的是识别“失败长什么样”。我们有时喜欢在批次开始时告诉创始人：“如果你失败了，请以一种新颖、令人兴奋的方式失败，而不是我们已经见过 100 次的那种。”因为我们见过人们因为各种各样的原因失败。对我们来说，与其说是预测，不如说是让更多公司成功的最好方法是告诉他们可能会如何失败，对吧？对他们非常直接和诚实，说：“你做的这三件事很可能会导致你无法成功。”如果我们工作做得好，大多数人得到反馈后就会走上成功的轨道。

---

### [00:46:06] Gustaf Alströmer

**English:**
Now, which of those companies end up becoming the best? There are so many things that are uncorrelated to being the best, and it's the things that people don't like. I'm in a hot industry, I was writing up on TechCrunch like, this investor started talking to me. You'd be surprised how many of the things I just mentioned are uncorrelated to outlier success, right? That's why it's so hard to actually do this. I think people really want these questions to be answered. People really want to believe that you can pick really great companies at the seed stage, but everything I've learned from the plus 600 companies that I've worked with is that it's just not that easy and it's maybe not even possible and certainly not possible when you talk about finding the outlier companies. I don't think it's that easy. And if it was easy, then we would accept a lot fewer companies. We just accept those ones, but it's just not that easy.

**中文翻译:**
那么，这些公司中哪一个最终会成为最好的？有很多事情与成为“最好”是不相关的，而这些往往是人们不喜欢的。比如“我在一个热门行业”、“我上了 TechCrunch”、“这个投资人开始跟我谈了”。你会惊讶地发现，我刚才提到的很多事情与离群的成功是不相关的，对吧？这就是为什么这件事做起来这么难。我认为人们真的很想得到这些问题的答案。人们真的很想相信你可以在种子轮阶段挑选出伟大的公司，但我从合作过的 600 多家公司中学到的是，这没那么简单，甚至可能是不可能的，尤其是在寻找离群公司时。我不认为这很容易。如果容易的话，我们录取的公司就会少得多，我们只录取那些就行了，但事实并非如此。

---

### [00:46:59] Lenny

**English:**
Do you have a sense of which ones are likely to work out better than others? Or is it just like, "We have 150 really unclear, but one of these, hopefully."

**中文翻译:**
你是否能感觉到哪些公司可能比其他的更有戏？还是说“我们有 150 个不太确定的，但希望其中一个能成”？

---

### [00:47:09] Gustaf Alströmer

**English:**
One good indicator is if each new Office Hour there is really exciting new stuff, right? We're not talking about the same thing we talked about two weeks ago or four weeks ago. They've already done that stuff, right? Like, "Oh, I was trying to sell to these three customers. Well, they already bought it. I'm not actually talking to seven others." And now we are talking about a different price and different product because they're like, they want more of what we're doing. If I'm experiencing that, and that's like a consistent trend, then when people draw this revenue graph of this 10% weekly growth rate kind of situation, those are the companies that we attribute that to. It's like if you're able to make that progress on that short amount of timescale, you are on track to do something well.

**中文翻译:**
一个很好的指标是，如果每次 Office Hour 都有令人兴奋的新进展，对吧？我们不是在谈论两周前或四周前谈过的同样的事情。他们已经把那些事做完了，对吧？比如：“哦，我之前想把东西卖给这三个客户。嗯，他们已经买了。我现在其实在和另外七个谈。”现在我们在谈论不同的价格和不同的产品，因为客户想要更多。如果我体验到这一点，并且这是一个持续的趋势，那么当人们画出那种周增长率 10% 的收入曲线时，就是这些公司。如果你能在这么短的时间跨度内取得那样的进展，你就走在成功的轨道上了。

---

### [00:47:51] Gustaf Alströmer

**English:**
Now, a lot of other things have to go well for you to ultimately be able to succeed, but progress on this weekly or biweekly timescale is a really good indicator of someone who'll succeed. To me, much better indicator than I am in this market or I'm talking to this investor or something like that. But those are much worse indicators of someone succeeding than I'm making progress and it's pretty fast clip.

**中文翻译:**
当然，最终要成功还需要很多其他因素，但这种以周或双周为单位的进度是衡量谁会成功的极佳指标。对我来说，这比“我在这个市场”或“我在和这个投资人谈”要好得多。后者的预测准确性远不如“我正在取得进展，而且速度很快”。

---

### [00:48:17] Lenny

**English:**
Interesting. And so what I'm hearing is at the beginning of a batch, we're just in a bet on a bunch of companies that have a lot of potential founders, technical maybe, they have the strong will to win and all these things. Through the batch, you're looking at the companies that are exceeding your expectations week to week in terms of progress that they're making.

**中文翻译:**
很有意思。所以我听到的是，在一个批次开始时，你们只是在赌一群有潜力的创始人——也许懂技术、有强烈的求胜欲等等。在整个批次过程中，你们在寻找那些在每周进度上超出你们预期的公司。

---

### [00:48:34] Gustaf Alströmer

**English:**
I mean, sometimes it could be different reasons that people are not making progress. But if you are making continuous progress, and I think Paul and Jessica said this, this was true early days in YC, if you are hitting your goals and you're making progress continuously, if that continues, that's a really strong correlation to some success. But again, going back to the question, can we predict who's going to be the best ones? No. And that's why we really focus on trying to meet people not to fail. Especially good teams can't fail. If you have a really talented team who's really technical in how to build a product but they make some other basic mistakes, like not talking to customers or something like that or trying to build everything all at once, I feel like it's our responsibility to make sure they don't make the basics mistakes that we've seen many times. We need to help them at least make some spectacular mistake that we haven't seen before. Then that's a high potential team. If someone's on a good track for a decent idea but they're still early, that's a really good potential.

**中文翻译:**
我的意思是，有时人们没有进展可能有不同的原因。但如果你在持续取得进展——我想 Paul 和 Jessica 在 YC 早期就说过——如果你在实现目标并持续取得进展，如果这种情况持续下去，这与某种成功有非常强的相关性。但回到那个问题：我们能预测谁会是最好的吗？不能。这就是为什么我们真正专注于帮助人们“不要失败”。尤其是优秀的团队不能失败。如果你有一个非常有才华、在构建产品方面非常有技术实力的团队，但他们犯了一些基础错误，比如不与客户交谈，或者试图一次性构建所有东西，我觉得我们的责任就是确保他们不犯那些我们见过无数次的低级错误。我们需要帮助他们，至少让他们犯一些我们以前没见过的“壮观”的错误。那才是一个高潜力的团队。如果某人有一个不错的想法，走在正确的轨道上，虽然还处于早期，那也是非常有潜力的。

---

### [00:49:30] Lenny

**English:**
I have kind of a fun question that I wanted to try, which is kind of connected to this idea around attributes of successful founders and companies. So I had this founder friend named Flow, and he was asking me recently, "If you had to think about the most successful founders, which attributes do they have?" And he kind of gave me this list and it's kind of like two ends of a spectrum. So I thought it'd be fun to just go through this list and see, in your experience, which end of the spectrum, if any, are associated and correlated with the most successful founders. Does that sound good?

**中文翻译:**
我有一个挺有趣的问题想试试，这与成功创始人和公司的特质有关。我有一个叫 Flow 的创始人朋友，他最近问我：“如果你回想一下最成功的创始人，他们具备哪些特质？”他给了我一份清单，有点像光谱的两端。所以我觉得过一遍这份清单会很有趣，看看根据你的经验，光谱的哪一端（如果有的话）与最成功的创始人更相关。听起来怎么样？

---

### [00:50:01] Gustaf Alströmer

**English:**
Sure. Sure. Let's do it.

**中文翻译:**
当然，没问题，开始吧。

---

### [00:50:03] Lenny

**English:**
Okay. So the first is speed versus quality. Is there end of the spectrum where you find that most successful founders are either speed-focused or quality-focused?

**中文翻译:**
好。第一个是“速度”对“质量”。你是否发现大多数成功的创始人要么更注重速度，要么更注重质量？

---

### [00:50:10] Gustaf Alströmer

**English:**
Sometimes founders ask us this question, "What should I focus on? Growth or retention?" And the answer is, they're asking us for permission to not do one or the other. The truth is, to succeed, you have to do both. I would argue that speed versus quality, there's different level of speed and different level of quality at different stage of the company. But the truth is that you always have to move fast and you have to understand what the meaning of quality is, right?

**中文翻译:**
有时创始人会问我们：“我应该专注于什么？增长还是留存？”答案是，他们其实是在请求我们允许他们不做其中之一。事实是，要成功，你必须两者兼顾。我认为速度与质量在公司的不同阶段有不同的水平。但事实是，你必须始终保持快速行动，并且你必须理解质量的含义，对吧？

---

### [00:50:35] Gustaf Alströmer

**English:**
So I think I actually don't see that as a spectrum, but I would say if you move fast with talking to customers, you'll build something that have potential having quality because you know a lot about the problem. I think when people think about quality, they often think about, "What is my personal definition of quality?" I have a bar of quality, but quality to me of a good product idea, a good startup idea, has more to do with the customer think is valuable. And if you move fast by talking to customers and having customer learnings and know the problems, then you will actually come up with something that's high quality. So they're not at a spectrum to me.

**中文翻译:**
所以我不认为这是一个光谱。我想说，如果你在与客户交谈方面行动迅速，你就会构建出具有高质量潜力的东西，因为你对问题了解很多。我认为当人们想到质量时，他们往往想到的是“我个人对质量的定义”。我有一个质量标准，但对我来说，一个好的产品想法、一个好的创业想法的质量，更多地取决于客户认为什么是有价值的。如果你通过与客户交谈、获取客户反馈并了解问题来快速行动，那么你最终会做出高质量的东西。所以对我来说，它们不在光谱的两端。

---

### [00:51:11] Lenny

**English:**
All right. Let's try another one. Confidence versus humility as a founder?

**中文翻译:**
好，再来一个。作为创始人，“自信”对“谦逊”？

---

### [00:51:16] Gustaf Alströmer

**English:**
I don't think that they're on a spectrum. I think that learning to predict confidence as a founder is critical going back to this communication piece of motivating people around you, right? I wouldn't want to join a company where the founder's completely not confident in their own idea, right? Because that is going to shine through. An investor isn't going to want to invest in someone who's completely not confident in that idea. So learning to first build your own confidence for what you're working on and then predicting that confidence to the people around you I think is critical. A lot of people will have doubt around you. And if you're not predicting that confidence, it's not clear that anybody else will if you're the founder. You're the one who's have to do it.

**中文翻译:**
我不认为它们在光谱两端。我认为学会展现自信作为创始人至关重要，这又回到了激励周围人的沟通部分，对吧？我不想加入一家创始人对自己想法完全没信心的公司，对吧？因为那是掩盖不住的。投资者也不会想投资一个对自己想法完全没信心的人。所以，学会首先建立对自己所做事情的信心，然后将这种信心传递给周围的人，我认为是至关重要的。周围会有很多人怀疑你。如果你不展现出那种信心，作为创始人，很难指望别人会展现出来。你必须是那个带头的人。

---

### [00:51:58] Gustaf Alströmer

**English:**
I think that you can predict that confidence while having a strong sense of humility towards the people around you. But I think when it comes to startups, learning to have that confidence is an important piece of the early days, right? And especially if you're building something that's very difficult, that takes a lot of work and a lot of money, protecting the confidence that you will succeed is critical for everybody that's doubting you. And those doubting you is a lot of people around you, right? And you just need to have an unnatural amount of confidence to prove them wrong. I think, again, this is not on the spectrum with humility. In fact, the most successful founders are often the most... You cannot inspire people around you if you don't have a strong sense of humility. People don't actually want to spend time with you, which means they don't want to work for you or invest in you. Again, you need both, but they serve different purposes when you get started.

**中文翻译:**
我认为你可以在展现信心的同时，对周围的人保持强烈的谦逊感。但在创业方面，学会拥有那种信心是早期阶段的重要组成部分，对吧？特别是如果你正在构建一些非常困难、需要大量工作和资金的东西，保持“你会成功”的信心对于每一个怀疑你的人来说都是至关重要的。而怀疑你的人往往就是你周围的人。你需要一种“超乎寻常”的信心来证明他们是错的。我认为这与谦逊并不冲突。事实上，最成功的创始人往往是最……如果你没有强烈的谦逊感，你就无法激励周围的人。人们其实不想和你待在一起，这意味着他们不想为你工作或投资你。同样，两者你都需要，但它们在创业初期服务于不同的目的。

---

### [00:52:48] Lenny

**English:**
Tough gig this founder life. You got to got to be everything. Let's see if there's a big difference in this next one. Execution and tactics versus focusing on strategy and kind of higher level stuff. How deep do founders go that you find that are most successful?

**中文翻译:**
创始人这行真不容易，你得面面俱到。看看下一个是否有很大区别：“执行与战术”对“专注于战略和高层事务”。你发现最成功的创始人会深入到什么程度？

---

### [00:53:02] Gustaf Alströmer

**English:**
So this one actually I have a strong opinion about. I think that the reason that we talk about strategy a lot is because it goes back to business school. The origin of business school was to teach people to join the corporate world. And in the corporate world, strategy matters, right? So when you join a big company, you're employee number 2,010 or something, then you probably might have a business school job where thinking about corporate strategy is an important thing. When you are a small startup, strategy does not matter because there's not that much a strategy as about. Maybe later on you might be fruitful to think about strategy, but strategy kind of assumes that you can do multiple things at the same time, which small startups cannot. They can just do one thing at the same time. So execution is the thing that matters for companies.

**中文翻译:**
关于这一点，我确实有很强的观点。我认为我们之所以经常谈论战略，是因为这可以追溯到商学院。商学院的起源是教人们如何加入企业界。在企业界，战略很重要，对吧？所以当你加入一家大公司，你是第 2010 号员工之类的，你可能会有一份商学院背景的工作，思考公司战略是一件重要的事情。但当你是一家小型初创公司时，战略并不重要，因为没有什么战略可言。也许以后思考战略会有所收获，但战略在某种程度上假设你可以同时做多件事，而小型初创公司做不到。他们一次只能做一件事。所以对公司来说，执行才是最重要的。

---

### [00:53:51] Gustaf Alströmer

**English:**
Whenever someone wants to have a strategy conversation, it assumes that they don't understand their priorities. The priorities is always a list from top to bottom where there's one thing that's more important than the others. You can't really have a strategy session about the other things because there's only one thing to work on. So to me, a clear answer here is the good founders are execution-oriented and they just continually have one priority of what they're trying to go for. And then they're just hitting that priority all the time and then new priorities will come up and you don't really have time to have a discussion about company strategy. Company strategy also assumes that you have product market fit because you already have something that's working. If you don't have that, then getting to people wanting your product, that is your strategy. You don't have any other strategy.

**中文翻译:**
每当有人想进行战略对话时，就意味着他们不了解自己的优先级。优先级始终是一个从上到下的列表，其中一件事比其他事更重要。你无法真正针对其他事情进行战略讨论，因为只有一件事需要处理。所以对我来说，答案很明确：优秀的创始人是执行导向的，他们始终只有一个正在努力实现的首要任务。他们一直在攻克那个任务，然后新的任务会出现，你根本没时间讨论公司战略。公司战略还假设你已经有了产品市场契合度，因为你已经有了一些行之有效的东西。如果你还没有那个，那么“让人们想要你的产品”就是你的战略。你没有别的战略。

---

### [00:54:36] Lenny

**English:**
Awesome. Okay. We found one that's quite different one on the spectrum or the other. How about autocratic and kind of like, I don't know, I think of Steve Jobs-like versus kind of consensus, collaborative driven, if this is a spectrum at all. And then where do you find founders might fit that are most successful?

**中文翻译:**
太棒了。好，我们找到了一个在光谱两端差异很大的。那么“独断专行”（比如史蒂夫·乔布斯那种）对“共识、协作驱动”呢？如果这算是一个光谱的话，你发现最成功的创始人通常属于哪一类？

---

### [00:54:53] Gustaf Alströmer

**English:**
I don't know if I have an answer to that question because I think when you work at early stage, you might look different than when you work at late stage. I don't spend a lot of time with founders that have thousands of employees and hearing how they are in the... When I talk to those founders, I talk to them one-one-one and I only hear from their perspective. So I don't actually know how they're peering in a large corporate setting. But when you're a small company, you're three people or five people or 10 people, you cannot be an autocratic decision maker. The founding team have a founding team decision making dynamic that could look different. Sometimes it's like everybody decides together on everything and sometimes you say, "I have my area of expertise and you have yours. We split it up, the decision making." Either of those things are fine. I think you just have to have a process so you don't rehash every decision after you made them a million times.

**中文翻译:**
我不知道这个问题我是否有答案，因为我认为你在早期阶段的工作方式可能与后期阶段完全不同。我没有花很多时间与拥有数千名员工的创始人在一起，听他们在那种环境下的表现。当我与那些创始人交谈时，是一对一的，我只听到他们的观点。所以我其实不知道他们在大型企业环境中的表现。但当你是一家小公司，只有三个人、五个人或十个人时，你不能做一个独断专行的决策者。创始团队有一种决策动态，可能看起来各不相同。有时是大家共同决定所有事情，有时是说“我有我的专业领域，你有你的，我们分工决策”。这两种方式都可以。我认为你只需要有一个流程，这样你就不会在做完决定后又反复讨论一百万次。

---

### [00:55:42] Gustaf Alströmer

**English:**
I would say the thing that matters the most at that point is to be willing to adhere to the process that you and your founding team have come up with. Your individual nature could be different in a different role in a different company. But for a startup to work out, you have to have a specific process on how you make decisions. Those are on a very short sprints, like weekly or biweekly. And everyone needs to feel good about decisions after the fact. At least they feel good about the process. I don't think that you can just decide... You can't also be fully collaborative, everyone gets decided about everything. So small startups agree on how they decide together. So after that, everyone just follow the process. That's usually how things work out.

**中文翻译:**
我会说，在那一点上最重要的是愿意遵守你和你的创始团队制定的流程。你的个人性格在不同的公司、不同的角色中可能会有所不同。但为了让初创公司成功，你必须有一个具体的决策流程。这些决策通常是在非常短的冲刺周期内做出的，比如每周或每两周。事后每个人都需要对决定感到满意，或者至少对流程感到满意。我不认为你可以只靠一个人决定，但你也不能完全协作，让每个人决定所有事情。所以小型初创公司会就如何共同决策达成一致。之后，大家只需遵循流程。通常事情就是这样解决的。

---

### [00:56:27] Lenny

**English:**
Okay, I got one more. Cares more about the product or cares more about the distribution and growth strategy?

**中文翻译:**
好，我还有一个。更关心“产品”还是更关心“分发和增长策略”？

---

### [00:56:33] Gustaf Alströmer

**English:**
Well, there's a lot of assumptions built into that, I would say, because caring about the product to me is caring about the customers. Sometimes if I would say something like, "Oh, great founders care about the product," a lot of founders misinterpret that as in my personal perception of the product or my ideas of what the product is. And that's wrong. The right perception there is the expectations or the use of the product from the customers. So if you are meaning focus on the product or cares about the product in that sense that your customers care about, then absolutely, I think that's a really, really critical, important thing to have early on, like talking to users, doing things you don't scale. Once you get big, if you don't figure out a scalable distribution strategy, you won't succeed. And those are different for different companies, but they're not doing anything that don't scale.

**中文翻译:**
嗯，我会说这里面有很多假设。因为对我来说，关心产品就是关心客户。有时如果我说“伟大的创始人关心产品”，很多创始人会误解为“我个人对产品的看法”或“我对产品是什么的想法”。那是错的。正确的理解应该是客户对产品的期望或使用情况。所以，如果你指的是在客户关心的意义上专注于产品或关心产品，那么绝对是这样，我认为这在早期是非常非常关键和重要的，比如与用户交谈、做那些无法规模化的事情。一旦你做大了，如果你没弄清楚可扩展的分发策略，你就不会成功。不同公司的分发策略各不相同，但它们不再是做那些无法规模化的事情。

---

### [00:57:27] Gustaf Alströmer

**English:**
Doing things that don't scale is not a scalable strategy. Eventually, something specific will be the things that work for you. If you're lucky, people will talk about your product and you'll have organic growth. But in many cases, that sales, that is some kind of consumer distribution strategy. You can't start with that. I've seen a lot, and this is when I had to reset my thinking coming from a growth team joining YC, is you can't start a startup ethic with a growth team mindset because that is just scalable things all the time. And really what you need to go back to is doing things that don't scale and unscale your way of thinking about customers. But it's really useful to have the growth mindset once something is working, right? Once you have thousands of people signing up everything every day, well how do you get to 2,000? Well, that's probably something that looks more like this thing that the growth team would do or distribution team would do.

**中文翻译:**
做那些无法规模化的事情并不是一个可扩展的策略。最终，会有一些具体的东西对你奏效。如果你幸运的话，人们会谈论你的产品，你会获得有机增长。但在很多情况下，那是销售，是某种消费者分发策略。你不能从那个开始。我见过很多——这也是我从增长团队加入 YC 时必须重置思维的地方——你不能带着增长团队的心态去开始创业，因为增长团队总是想着可扩展的事情。而你真正需要回归的是做那些无法规模化的事情，并“去规模化”你思考客户的方式。但一旦事情有了起色，拥有增长思维就非常有用，对吧？一旦你每天有成千上万的人注册，那么你如何达到两千？那可能看起来更像是增长团队或分发团队会做的事情。

---

### [00:58:21] Gustaf Alströmer

**English:**
I would say everyone has different experiences of this based on their prior experience, right? So if you work for a company that was infinitely successful, then you won't care so much about this. If you work for Google, you'll never even think about this because distribution is just the website. But if you work for a really small shitty product, then you think a lot about distribution because that's natural to you on how you succeed. So I think at the end of the day, talking to customers matters the most. That is what it means to care about a product to me. And then distribution is something that you will definitely invest a lot in once something is working.

**中文翻译:**
我会说每个人根据以往的经验对此都有不同的体验，对吧？如果你在一家极其成功的公司工作过，你可能不会那么在乎这个。如果你在 Google 工作，你甚至永远不会想到这个，因为分发就是网站本身。但如果你在一个非常小的、很烂的产品上工作，你就会非常考虑分发，因为那是你成功的自然方式。所以我觉得归根结底，与客户交谈最重要。对我来说，这就是关心产品的含义。而分发则是你一旦发现某些东西奏效后，肯定会投入大量精力的事情。

---

### [00:58:53] Lenny

**English:**
Awesome. All right. I have probably a hundred other questions I want to ask along these lines, but I want to make sure we get to another topic which I know is near and dear to your heart, which is climate tech. So my understanding is you're instrumental in pushing YC to focus on climate tech as a focus area. I believe you led the charge on their initial request for startups I think is the term where you all put out like, "Here's who we want to fund." I think you've mentioned you funded a couple dozen climate tech companies and the last few batches, is that all generally correct?

**中文翻译:**
太棒了。好，沿着这些思路我大概还有一百个问题想问，但我得确保我们能聊到另一个我知道你非常关心的主题，那就是气候科技（Climate Tech）。据我了解，你在推动 YC 将气候科技作为重点领域方面发挥了关键作用。我相信你主导了他们最初的“初创公司征集令”（Request for Startups），也就是你们发布“这是我们想资助的对象”的那种。我想你提到过在过去几个批次中资助了几十家气候科技公司，这些大致正确吗？

---

### [00:59:24] Gustaf Alströmer

**English:**
First, request for startup was actually Sam Altman and a few other folks that was kind of that one who drove that. The second one that we wrote into our actual request for startup, I wrote that one, was carbon removal specifically focused on. And then naturally the people that apply with climate tech ideas get in my reading queue of applications and I read them and I interview them. Not all of them, but many of them. I think today we funded over 130 plus companies that are focused on climate tech in some way or another.

**中文翻译:**
首先，最初的征集令实际上是 Sam Altman 和其他几个人推动的。我们在实际征集令中写的第二个，也就是我写的那一个，是专门针对“碳移除”（Carbon Removal）的。然后自然而然地，那些带着气候科技想法申请的人就会进入我的申请阅读队列，我会阅读并面试他们。不是全部，但有很多。我想今天我们已经资助了超过 130 家以某种方式专注于气候科技的公司。

---

### [00:59:53] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:59:54] Gustaf Alströmer

**English:**
The trend line is that really ambitious people who want to start companies in this area. Some of them want to start the companies because the climate tech is the number one problem, but they don't view this as a nonprofit. Now I want to really make this as a distinction. People somehow think that starting a climate tech company is doing good for the world, but it probably doesn't have a lot more than that. The truth is that the world have decided. Because climate is one of the biggest problems that we're facing, if not the biggest, we've decided that we are going to stop doing the things that we're doing and we're going to change our entire energy system and change all the things that we do that emits carbon. And we have just decided, governments have decided this. The question is how it's going to happen, but this decision has been made.

**中文翻译:**
趋势是，非常有野心的人想在这个领域创业。他们中有些人创业是因为气候科技是头号问题，但他们并不把它看作是非营利事业。现在我想做一个区分。人们总觉得创办气候科技公司只是在为世界做好事，除此之外可能没别的了。事实是，世界已经做出了决定。因为气候是我们面临的最大问题之一（如果不是最大的话），我们已经决定停止我们正在做的事情，我们将改变整个能源系统，改变所有排放碳的行为。我们已经决定了，各国政府也已经决定了。问题在于如何实现，但这个决定已经做出了。

---

### [01:00:42] Gustaf Alströmer

**English:**
In that transition, we're talking about trillions of dollars of money moving from things that cause climate change to things that don't. The scale of this transition is not something we've seen recently. Like software is not that big in comparison. It actually is much smaller than this transition. So I think if you look at something like Tesla, which now has, I don't know, $600, $700 billion market cap, that's just one company that currently provides a couple percent of all the cars in the United States, new cars sold. And that is already one of the biggest companies in the world and has now the biggest, richest person in the world. We've only seen the beginning of this. The economical motivation be behind the decisions that people are making are just as strong as I want to fix climate change because this is just a really good business. This change have attracted a large set of software founders that you and me know that listen to this podcast that said, "My skills is relevant here. There are a lot of things that I can do. And if not, I can learn those things."

**中文翻译:**
在这种转型中，我们谈论的是数万亿美元的资金从导致气候变化的事物转移到不导致气候变化的事物上。这种转型的规模是我们近期从未见过的。相比之下，软件行业都没那么大。实际上，软件行业比这种转型要小得多。所以我觉得如果你看像特斯拉这样的公司，它现在有六七千亿美元的市值，这仅仅是一家目前只占美国新车销量百分之几的公司。而它已经是世界上最大的公司之一，并诞生了世界上最富有的人。我们才刚刚看到这一切的开始。人们做决定背后的经济动机，与“我想解决气候变化”的动机一样强烈，因为这确实是一门非常好的生意。这种变化吸引了大量你我熟知的、听这个播客的软件创始人，他们说：“我的技能在这里是有用的。有很多事情我可以做。如果不行，我可以去学。”

---

### [01:01:43] Gustaf Alströmer

**English:**
But most importantly, the skills of working for startups is really, really critical to join this transition. A lot of them have started companies or joining companies. I still get an email every week from some accomplished software engineer who asked me "Which software companies should I work for to fix climate change?" And I've gotten those emails for two or three years now. This thing just attracts really, really ambitious people. It's not stopping. It's accelerating. I feel lucky to work with so many of these great founders because they are uniquely interesting people.

**中文翻译:**
但最重要的是，在初创公司工作的技能对于加入这种转型非常非常关键。他们中的许多人已经开始创业或加入相关公司。我每周仍会收到一些资深软件工程师的邮件，问我：“我应该去哪家软件公司工作来帮助解决气候变化？”这类邮件我已经收了两三年了。这件事吸引了非常非常有野心的人。它没有停止，反而正在加速。我觉得能与这么多优秀的创始人合作很幸运，因为他们都是非常独特且有趣的人。

---

### [01:02:16] Lenny

**English:**
I've noticed exactly the same thing of just how many smart, driven, amazing people are like, "I just want to move to a climate tech company. That's all I'm looking for now." Just to give you credit, I feel like you are ahead of the curve on the shift that's started to happen and pushed YC to focus on this really early. I always think like, "Man, I know Gustaf and I feel like Gustaf has made such a massive impact on the investment and focus in startups on climate." And so I just want to give you huge props for doing that and being so at the forefront of a lot of this.

**中文翻译:**
我也注意到了同样的事情，有那么多聪明、有动力、了不起的人说：“我只想去一家气候科技公司，这就是我现在的全部目标。”我要给你点赞，我觉得你在这种转变开始发生之前就走在了曲线的前面，并很早就推动 YC 关注这一领域。我总是在想：“天哪，我认识 Gustaf，我觉得 Gustaf 对气候领域初创公司的投资和关注产生了巨大的影响。”所以我只想为你所做的一切以及站在前沿表示由衷的敬意。

---

### [01:02:50] Gustaf Alströmer

**English:**
Thank you. I mean, sometimes I'd say that it matters to someone who has the credibility of YC to start accepting these companies. It does matter. I remember when I spoke to Diego from Pachama in 2018 when he was starting Pachama, we were whiteboarding in YC. He was a YC alumni starting a different company. The word climate tech did not exist. People were unsure if investors would fund companies like these. Pachama's raised $60 million to have, I don't know, lots of big customers, lots of employees and it's clearly doing really well. But I think at the time of 2018 it was kind of unknown. One of the reasons it was unknown is we had this previous bubble, clean tech bubble, in 2008, 2009, 2010 that didn't work out because of a number of specific reasons and investors were just afraid of funding things because they had some scar tissue or scars from this previous thing that happened.

**中文翻译:**
谢谢。我的意思是，有时我会说，像 YC 这样有公信力的机构开始接受这些公司是很重要的。这确实有影响。我记得 2018 年我和 Pachama 的 Diego 交谈时，他刚开始创办 Pachama，我们在 YC 画白板。他是一名 YC 校友，当时正在创办另一家公司。“气候科技”这个词当时还不存在。人们不确定投资者是否会资助这类公司。现在 Pachama 已经筹集了 6000 万美元，拥有很多大客户和员工，显然做得非常好。但在 2018 年，这还是未知的。其中一个原因是我们在 2008、2009、2010 年经历过之前的“清洁技术”（Clean Tech）泡沫，由于一些具体原因，那个泡沫破裂了，投资者因为之前的教训而害怕资助这类项目。

---

### [01:03:46] Gustaf Alströmer

**English:**
Now that turned out upside down. The number of new investors that are investing in climate tech is as big of a trend as any other trend we've seen in the last decade or two decades. There's just an enormous focus on the investing side. Most recently, me and another guy, David Rusenko, wrote this request for startup, a new updated, very detailed list of... I hope we can post it in the show notes, a very detailed list of ideas or areas where we think it might be worth looking If you want to start a company.

**中文翻译:**
现在情况完全反转了。投资气候科技的新投资者数量之多，是我们在过去一二十年里见过的最强劲的趋势之一。投资界对此有着巨大的关注。最近，我和另一个人 David Rusenko 写了一份新的征集令，一份非常详细的清单……我希望我们可以把它放在节目介绍里，这是一份关于如果你想创业，哪些想法或领域值得关注的详细清单。

---

### [01:04:18] Gustaf Alströmer

**English:**
Now, we don't know what good ideas look like. We don't know. But we can tell you where all the areas of opportunity exist. We should go and look for good ideas. We wrote this because in response to all these people that come to us and say, "I want to work on climate tech. I don't have a good idea because I don't have any specific experience in this stuff." And then we're just like, "Don't work on these three things but go and work on any of these 25 directions." It already has generate a good response. I think it'll generate more response. But I think it's important for YC to tell the world that we look and fund these things. And that's always been the reasons we had requests for startups, is to let people know that these are things that we actually want to fund.

**中文翻译:**
现在，我们并不知道好的想法长什么样。我们不知道。但我们可以告诉你所有的机会领域在哪里。你应该去寻找好的想法。我们写这个是为了回应那些来找我们并说“我想做气候科技，但我没有好主意，因为我在这方面没有具体的经验”的人。然后我们就说：“别做这三件事，但可以去尝试这 25 个方向中的任何一个。”这已经产生了很好的反响。我认为它会产生更多的反响。但我认为 YC 向世界表明我们关注并资助这些领域是很重要的。这一直是我们发布征集令的原因：让人们知道这些是我们真正想资助的东西。

---

### [01:04:58] Lenny

**English:**
I actually moderated a panel a couple weeks ago. This organization called the Climate Draft put together PMs that are in climate tech. A lot of the questions were just like, "What kind of background do I need to move into climate tech startup to start a climate tech company?" It's interesting, every single one again and again just said like, "Your actual regular PM skills is all we need." There's a lot of people already at the company that are experts in the science and that's okay if you have no experience. They just need the business experience, how to operate, how to execute, standard stuff that PMs learn. And so would you agree with that that you don't need to have this deep background in science and climate to move into the space?

**中文翻译:**
几周前我主持了一个小组讨论。一个叫 Climate Draft 的组织召集了一些在气候科技领域的 PM。很多问题都是关于“我需要什么样的背景才能进入气候科技初创公司或创办一家气候科技公司？”有趣的是，每个人都一次又一次地说：“我们只需要你原本的 PM 技能。”公司里已经有很多科学专家了，如果你没有经验也没关系。他们只需要业务经验、如何运营、如何执行，也就是 PM 学到的那些标准东西。你是否同意进入这个领域不需要深厚的科学和气候背景？

---

### [01:05:41] Gustaf Alströmer

**English:**
Yeah, I would say if you were working on a software company and even some of the hardware companies, that's probably generally true. Absolutely. It's much more valuable to have that background than to have this specific domain expertise background. Those are complimentary. But as a PM, having the solid PM background is the more valuable piece I would say. Being a competitive PM, coming from a really good culture of product management, knowing what good looks like, that's invaluable to some of these companies because in the past they weren't able to hire these people. So I agree with that 100%.

**中文翻译:**
是的，我想说如果你在软件公司工作过，甚至在一些硬件公司工作过，这通常是真的。绝对如此。拥有那种背景比拥有特定的领域专业知识背景更有价值。它们是互补的。但作为一名 PM，拥有扎实的 PM 背景是更有价值的部分。作为一名有竞争力的 PM，来自优秀的产品管理文化，知道什么是好的产品，这对其中一些公司来说是无价的，因为过去他们无法雇佣到这样的人。所以我 100% 同意。

---

### [01:06:14] Gustaf Alströmer

**English:**
In terms of founders, I've seen everything, right? I've seen people having some domain expertise starting a company and really succeeding. I've seen people who had no domain expertise and learned everything they need to know. Maybe they partnered up with someone who had a domain expertise and then succeeded. I've seen all of it and I actually think that you can succeed in either of these categories. You don't need the deep expertise. It depends really on all the area you're in. But someone like Pachama, Diego and Tomas did not have expertise in forests besides the personal experience. They just had a willingness to solve the problem and it really worked out for them.

**中文翻译:**
至于创始人，我见过各种情况。我见过有领域专业知识的人创业并获得成功。我也见过完全没有领域专业知识的人，他们学习了所有需要知道的东西。也许他们与有专业知识的人合作，然后获得了成功。我见过所有这些情况，我实际上认为你在任何一类中都能成功。你不需要深厚的专业知识。这实际上取决于你所在的领域。但像 Pachama 的 Diego 和 Tomas，除了个人经验外，并没有森林方面的专业知识。他们只是有解决问题的意愿，而这确实为他们带来了成功。

---

### [01:06:51] Lenny

**English:**
You mentioned you have this list of areas you're excited about. I know we'll share in the show notes, but is there any you want to highlight, just like here's areas you're most excited about and want to fund and/or are there companies you want to mention that are super interesting and super cool in the space that people should know about?

**中文翻译:**
你提到你有一份令你兴奋的领域清单。我知道我们会分享在节目介绍里，但你有没有想重点强调的？比如你最兴奋、最想资助的领域，或者有没有你想提到的在这个领域里非常有趣、非常酷、大家应该了解的公司？

---

### [01:07:04] Gustaf Alströmer

**English:**
We wrote the list and we are highlighting companies in each of the categories. I don't know if I want to highlight any specific categories, but I can talk about some of the things that we've funded in the past that has real legs. So here's how I generally think about climate tech. So we have to decarbonize all the things we do that emits emissions. That means we have to change a bunch of things in the world, change transportation, change energy, change homes, all of these things, or change how we heat homes for example.

**中文翻译:**
我们写了那份清单，并重点介绍了每个类别中的公司。我不知道是否想强调某个特定的类别，但我可以谈谈我们过去资助过的一些非常有前景的项目。这就是我通常对气候科技的看法：我们必须让我们所做的所有产生排放的事情脱碳。这意味着我们必须改变世界上的很多事情，改变交通、改变能源、改变住房，所有这些，或者例如改变我们为房屋供暖的方式。

---

### [01:07:35] Gustaf Alströmer

**English:**
And then there is carbon removal. Carbon removal is sort of like, well even if we do all of this stuff really well, it's probably not going to be enough. And because there's an opportunity and there's some evidence to suggests that we can actually remove carbon from atmosphere in some way or another, a lot of companies are also working on this at the same time. I would say we need to do both and they're not in conflict. We probably are going to need to do both. Well, we certainly need to do the first one.

**中文翻译:**
然后是碳移除。碳移除有点像：即使我们把所有这些事情都做得很好，可能还是不够。因为有机会，而且有一些证据表明我们可以以某种方式从大气中移除碳，所以很多公司也在同时致力于此。我会说我们需要两者兼顾，它们并不冲突。我们可能需要两者都做。当然，我们肯定需要做第一个。

---

### [01:08:02] Gustaf Alströmer

**English:**
On the decarbonization side, there's infinite number of categories of our society where we met a lot of carbon, right? So I'll give you an example. Shipping is a really big deal. A lot of carbon emissions come from freight ships around the world. That's not obvious solution how you would solve that because the kind of oil that they run on is really cheap and it's a very low margin business and they don't have a whole lot of incentives to change besides what is coming down regulatory. So it's not a national solution where someone to be a cool, someone will build a test off ships and it just work out. But the two companies to be funded in that area, one of them is Seabound who is building carbon capture and removal for ships.

**中文翻译:**
在脱碳方面，我们社会中有无数个产生大量碳排放的类别，对吧？我给你举个例子。航运是一个大问题。全球货轮产生了大量的碳排放。如何解决这个问题并没有显而易见的方案，因为它们使用的燃油非常便宜，而且这是一个利润率非常低的行业，除了监管要求外，他们没有太大的动力去改变。所以这不是一个靠某人造出一艘“特斯拉级”货轮就能解决的自然方案。但我们在那个领域资助了两家公司，其中一家是 Seabound，他们正在为船舶开发碳捕获和移除技术。

---

### [01:08:41] Gustaf Alströmer

**English:**
The other one is Fleetzero who build electrical ships. Electrification is on and again and again and again and whenever it's being applied, turn out to be a more efficient way of doing whatever thing that you were previous doing with the combustion industry. It is almost no maintenance. It's cheaper to build. The batteries are more expensive, it's cleaner and it fits the carbon coal you have. There's just a bunch of benefits there, but there has limitations. Usually the limitations on electrification has to do with batteries. It's like how far can you go? Now that category is what I call the... Which is a very important kind of critical one, which is the carbon accounting and sort of the recommendation systems that help big company account for the carbon that they have and they are giving some recommendations of what you do.

**中文翻译:**
另一家是 Fleetzero，他们建造电力驱动的船舶。电气化一次又一次地证明，只要应用它，它就会成为比之前的内燃机工业更高效的方式。它几乎不需要维护，建造更便宜。虽然电池更贵，但它更清洁，符合碳排放目标。它有很多好处，但也有局限性。通常电气化的局限性在于电池，比如你能跑多远。现在那个类别是我所说的……一个非常重要且关键的类别，即碳核算（Carbon Accounting）以及帮助大公司核算碳排放并提供建议的推荐系统。

---

### [01:09:25] Gustaf Alströmer

**English:**
So I'll give you three examples. We funded Unravel Carbon, which is carbon counting software in Singapore, focusing on Asia, probably the leading one there. There's company called Carbon Chain, which is focused specifically on supply chain and shipping and raw materials, stuff like that out of UK. And then there's ANAI here in the Bay area. Who knows how this market is going to play out, but this market has carbon accounting customer demand right now, right? So all the large companies of the world have other either promised the government, promised their shareholders or promised the public, or maybe even the employees, they go into decarbonize. They don't always have an idea how to do it. These software platforms is like the plug and play "This is how you do it."

**中文翻译:**
我给你举三个例子。我们资助了 Unravel Carbon，这是一家新加坡的碳核算软件公司，专注于亚洲，可能是那里的领导者。还有一家叫 Carbon Chain 的公司，总部在英国，专门专注于供应链、航运和原材料等领域。还有湾区的 ANAI。谁知道这个市场会如何发展，但这个市场现在确实有碳核算的客户需求，对吧？世界上所有的大公司要么向政府承诺，要么向股东承诺，要么向公众甚至员工承诺他们要脱碳。他们并不总是知道该怎么做。这些软件平台就像是即插即用的“这就是你的做法”。

---

### [01:10:07] Gustaf Alströmer

**English:**
And then I'll give you two examples of things you can go into if you don't have any specific domain expertise and just a good software engineer. There's a company called Enode. They are basically building Plaid for EV chargers and Plaid for home energy system. So if we imagine that the future of all homes or future of all charging of EVs is going to be a bunch of energy appliances that are run by small computers, they're all wifi connected, you can connect to them and do things, tell them to turn on, turn off, turn on when it's cheap, turn off when it's whatever, all these different things that are valuable for the energy grid. Then you need a software platform to connect with all of them. And that's what Enode has been building.

**中文翻译:**
然后我再给你举两个例子，如果你没有任何特定的领域专业知识，只是一个优秀的软件工程师，你可以进入这些领域。有一家公司叫 Enode。他们基本上是在为电动车充电桩和家庭能源系统构建“Plaid”（注：Plaid 是一个连接银行账户的 API 平台）。如果我们想象未来所有的家庭或所有的电动车充电都将是由小型计算机运行的一堆能源设备，它们都连接了 Wi-Fi，你可以连接它们并执行操作，告诉它们开启、关闭，在电价便宜时开启，在其他时候关闭，所有这些对电网有价值的事情。那么你就需要一个软件平台来连接所有这些设备。这就是 Enode 一直在构建的东西。

---

### [01:10:48] Gustaf Alströmer

**English:**
Another related company is called Static. Static is the Airbnb for EV charging in India. The reason that you need something like that is you don't have Tesla charging. You don't really have public charting in general. People don't have outlets in their garage and they don't have garages. So you need to build a new bottom up EV charging system or platform, and that's what Static has been doing. They're actually building out public charging infrastructure as well, but they have their own app. So if you use a Static app, they'll direct you to all the Static chargers. I believe that they're the biggest or the fastest growing EV charging network in India, which is the second-biggest country, if not the biggest country in the world right now.

**中文翻译:**
另一家相关的公司叫 Static。Static 是印度电动车充电领域的“Airbnb”。你需要这种服务的原因是印度没有特斯拉充电网络，通常也没有公共充电设施。人们的车库里没有插座，甚至根本没有车库。所以你需要建立一个新的自下而上的电动车充电系统或平台，这就是 Static 一直在做的。他们实际上也在建设公共充电基础设施，但他们有自己的 App。如果你使用 Static App，它会引导你到所有的 Static 充电桩。我相信他们是印度最大或增长最快的电动车充电网络，而印度现在是世界上第二大（如果不是第一大）国家。

---

### [01:11:25] Gustaf Alströmer

**English:**
So the potential of these ideas, even that they're doing well now is just infinite, such an enormous market. If you succeed in one of these things, I don't think we are going to have as many gas stations as we have today and different networks. We're not going to have the same in EV charging. It's going to be a lot more consolidated around the use experience of the end user and the app they open to do this stuff. So I'm pretty convinced that there's real big opportunities for software entrepreneurs to figure this out. There's some companies in the current batch that are focused on this too.

**中文翻译:**
所以这些想法的潜力，即使它们现在做得很好，也是无限的，这是一个巨大的市场。如果你在这些事情中取得成功，我不认为我们将来会有像今天这么多加油站和不同的网络。电动车充电也不会是那样。它将更多地围绕终端用户的体验以及他们用来操作的 App 进行整合。所以我非常确信，软件企业家在解决这些问题方面有巨大的机会。当前批次中也有一些公司专注于此。

---

### [01:11:59] Gustaf Alströmer

**English:**
The final one I would mention is Heart Aerospace. We have a Heart Aerospace and the Right Electric and a few others focused on aviation. Aviation is another big difficult to decarbonize. Heart and Right are focusing on battery electric planes. So they're basically making commercial airplanes that fly on batteries and flying electric motors and it's incredible to see.

**中文翻译:**
最后我要提到的是 Heart Aerospace。我们有 Heart Aerospace、Right Electric 以及其他几家专注于航空领域的公司。航空是另一个极难脱碳的领域。Heart 和 Right 专注于电池驱动的电力飞机。他们基本上是在制造依靠电池和电动机飞行的商业飞机，这看起来非常不可思议。

---

### [01:12:22] Lenny

**English:**
What a killer list. We're definitely going to include links to all these companies in the show notes. Something I was thinking about is, so one narrative violation you mentioned is that there's actually money to be made in climate tech. It's not impact-oriented market anymore. It might be worth chatting about why that happened, but the question I want to get to is also things are going well. A lot of progress is being made. People see climate change and it's like we're dead, it's game over. But it feels like battery prices are coming down, solar's coming down, wind powers ramping up, all these startups are investing. So it'd be fun to just hear what's going well and maybe what is there to be optimistic about, but then also, "Okay, yeah, things are going well, but there's still things that are not going so great and where we need to double down."

**中文翻译:**
真是一份超棒的清单。我们肯定会在节目介绍中包含所有这些公司的链接。我在想，你提到的一个“反直觉叙事”是气候科技实际上是可以赚钱的，它不再仅仅是一个以影响力为导向的市场。聊聊为什么会发生这种转变可能很有价值，但我更想问的是：现在情况进展顺利，取得了很大进展。人们看到气候变化，总觉得我们要完了，游戏结束了。但感觉电池价格在下降，太阳能成本在降低，风能正在兴起，所有这些初创公司都在投资。所以，听听哪些方面进展顺利、有哪些值得乐观的地方会很有趣，但同时也想听听：“好吧，虽然进展顺利，但仍有哪些方面做得不够好，我们需要加倍努力？”

---

### [01:13:10] Gustaf Alströmer

**English:**
Two specific things that went well in the last say 12 or 24 months. First one was politics. So in the United States we got the IRA, which is like it's called the Inflation Reduction Act. It makes sense because shift into greener energy is going to actually reduce inflation because it reduces energy costs. But it's really a climate bill, right? It really is a bill that is focusing on onshoring, a lot of supply chain for the green economy and incentivizing a lot of this change that we just talked about. Whether it's carbon removal or home energy or home heating, whatever it might be, this bill addresses all of it and is massive. So that's one really good news. Politics didn't have a lot of good news in the US for a long time on this. Maybe not ever actually.

**中文翻译:**
在过去的 12 到 24 个月里，有两件具体的事情进展顺利。第一是政治。在美国，我们有了 IRA，即《通胀削减法案》（Inflation Reduction Act）。这很有道理，因为转向绿色能源实际上会降低通胀，因为它降低了能源成本。但它本质上是一部气候法案，对吧？它真正专注于将绿色经济的大量供应链转移回国内，并激励我们刚才谈到的许多变化。无论是碳移除、家庭能源还是家庭供暖，无论是什么，这部法案都涵盖了，而且规模巨大。这是一个非常好的消息。在这一领域，美国政治很长一段时间都没有什么好消息，甚至可能从来没有过。

---

### [01:13:52] Gustaf Alströmer

**English:**
The second good news, and it's such a good news that Europe is now trying to conquer. They're not trying to counter the IRA with their bill because they're seeing some of the battery companies saying, "Well, I'll actually going to build the next factor in US, not Europe anymore. I changed my mind."

**中文翻译:**
第二个好消息——好到欧洲现在正试图迎头赶上。他们正试图通过自己的法案来应对 IRA，因为他们看到一些电池公司说：“好吧，我实际上要在美国建下一个工厂，不再在欧洲建了，我改变主意了。”

---

### [01:14:05] Lenny

**English:**
Oh, wow.

**中文翻译:**
噢，哇。

---

### [01:14:05] Gustaf Alströmer

**English:**
So Europe now has to counter with their incentives as well. The second good news is corporations are now customers. So maybe three or four years ago you went to a Fortune 100 company and you're like, "Hey, do you want to buy my XYZ decarbonation solution?" What it's like? The software platform or EVs or whatever it might be. They're like, "Well, talk to this person on this floor. Maybe they can help you." And this person was not really empowered to make decisions. That has changed. Now they're like, "Actually, we promised our shareholders to reduce emissions by 2% every year and we also promised the government and we promised whatever publicly to do that. So we got to do that." They're like, "Where do we start? What's the first 2% that we got to decarbonize? Maybe that starts with energy. Oh, we'll change our energy providers." But they are now showing up as customers, not just with LOIs but paying actual for contracts, right? Doing investments in these companies because they've all see the future and they don't want to be behind.

**中文翻译:**
所以欧洲现在也必须用他们的激励措施来应对。第二个好消息是，大公司现在成了客户。大概三四年前，你去一家财富 100 强公司说：“嘿，你想买我的 XYZ 脱碳解决方案吗？”无论是软件平台还是电动车。他们会说：“嗯，去跟那一层的某某谈谈吧，也许他们能帮你。”而那个人其实并没有决策权。现在情况变了。现在他们会说：“实际上，我们向股东承诺每年减少 2% 的排放，我们也向政府和公众承诺了。所以我们必须这么做。”他们会问：“我们从哪里开始？我们要脱碳的第一个 2% 是什么？也许从能源开始。噢，我们要更换能源供应商。”他们现在以客户的身份出现，不仅仅是签意向书（LOI），而是支付实际的合同费用，对吧？对这些公司进行投资，因为他们都看到了未来，不想落后。

---

### [01:15:02] Gustaf Alströmer

**English:**
There's financials motivations for this. They want to get access to capital that has some strings attached to some of these things, but they don't want to fall behind. And then they don't want to be the Toyota to Tesla, where Toyota said, "We are not going to do battery electric." It's just like they're still saying that sometimes and everybody else is like, "Tesla is the one we got to copy because that's the one that's winning." All these corporations are really afraid of being the Toyota. They're really afraid of being the last one who's not changing and then the world will move past them and then they're going to die. So I think the motivation here is intrinsically survival and it's really about sort of adopting this because this is where the world is going.

**中文翻译:**
这背后有财务动机。他们想获得一些带有附加条件的资金，但他们不想掉队。他们不想成为特斯拉面前的丰田——丰田曾说“我们不做纯电动”。他们有时还在这么说，而其他所有人都在想：“特斯拉才是我们要模仿的对象，因为它是赢家。”所有这些大公司都非常害怕成为“丰田”。他们非常害怕成为最后一个不改变的人，然后世界抛弃他们，他们就会倒闭。所以我认为这里的动机本质上是生存，这实际上是关于顺应潮流，因为这就是世界的走向。

---

### [01:15:39] Gustaf Alströmer

**English:**
I think these are the two best news. The thing that I think what... We also wrote about this in the request for startups. This is not a thing where you can convince everybody to just agree with you. And even if you did, people wouldn't know what to do. So you have to view this as an economical opportunity and say... We can't convince everybody that this is going to be the thing that's going to happen. It doesn't actually matter if you convince everybody. What matters is that sufficient amount of corporations are convinced that they change their habits. And then you can sell the things you're building to them.

**中文翻译:**
我认为这是两个最好的消息。我们在征集令中也写到了这一点。这不是一件你能说服所有人同意你的事情。即使你做到了，人们也不知道该怎么办。所以你必须把它看作一个经济机会，并说……我们无法说服所有人这一定会发生。实际上，说服所有人并不重要。重要的是有足够多的公司被说服并改变了他们的习惯。然后你就可以把你构建的东西卖给他们。

---

### [01:16:09] Gustaf Alströmer

**English:**
As sort of founder, just focus on your customers and focus on B2B. That's what most people I recommend to do here because that's where most of the change is going to happen. That's why I'm really optimistic about these startups and these founders. What they're doing is, in my opinion, more impactful than someone running a campaign trying to convince some other people that this is a big problem. Even when people know that climate change is problem, they don't know exactly what to do about it. But the startup founders, they know.

**中文翻译:**
作为创始人，只需专注于你的客户，专注于 B2B。这是我建议大多数人在这里做的事情，因为那是大部分变化将要发生的地方。这就是为什么我对这些初创公司和这些创始人非常乐观。在我看来，他们所做的事情比某人发起一场运动试图说服别人这是一个大问题更有影响力。即使人们知道气候变化是个问题，他们也不确切知道该怎么办。但初创公司创始人知道。

---

### [01:16:37] Lenny

**English:**
You touched on this, but it feels like one of the biggest shifts is capitalism is kicked in and is now leaning into climate tech startups and that's-

**中文翻译:**
你提到了这一点，感觉最大的转变之一就是资本主义开始发挥作用，现在正向气候科技初创公司倾斜，而这——

---

### [01:16:46] Gustaf Alströmer

**English:**
Yes. Absolutely. Absolutely.

**中文翻译:**
是的。绝对是，绝对是。

---

### [01:16:48] Lenny

**English:**
... making a big dent. Well, with that, we've reached the final part of our chat, which is the very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
……产生了巨大的影响。好了，说到这儿，我们已经到了对话的最后一部分，也就是非常令人兴奋的闪电轮问答。我有六个问题要问你。准备好了吗？

---

### [01:16:58] Gustaf Alströmer

**English:**
Yeah.

**中文翻译:**
准备好了。

---

### [01:16:59] Lenny

**English:**
What are two or three books that you recommend most to other people?

**中文翻译:**
你最推荐给别人的两三本书是什么？

---

### [01:17:04] Gustaf Alströmer

**English:**
The first one I recommend, I think I have it here. Yeah, this one. It's called The 100% Solution. It's written by Solomon Goldstein-Rose. It's for people who think climate change is a problem but don't know what to do about it, or they're just kind of in despair or think they're like, "Ah, everyone are going to die," right? There are some books written where the outcome of the book is like, "We're all going to die," but the truth is that we're not all going to die. This book is trying to cover the 100% of all the solutions in detail, kind of much more detailed version of the request of Sharp that we wrote. It gets you freely optimistic. And I give that to anybody who's cared about climate change because it really lays out this from a very optimistic way of looking at the world. And that's why I recommend that book more than almost anything else. That's probably my number one book.

**中文翻译:**
我推荐的第一本，我想我这儿就有。是的，这本。它叫《100% 解决方案》（The 100% Solution），作者是 Solomon Goldstein-Rose。它是写给那些认为气候变化是个问题但不知道该怎么办的人，或者是那些处于绝望中、觉得“啊，我们都要完了”的人。有些书写出来的结论就是“我们都要死了”，但事实并非如此。这本书试图详细涵盖 100% 的所有解决方案，有点像我们写的征集令的详尽版。它会让你变得非常乐观。我会把它送给任何关心气候变化的人，因为它真的从一个非常乐观的角度审视世界。这就是为什么我比推荐其他任何书都更推荐这本书。这大概是我的首选。

---

### [01:18:00] Lenny

**English:**
Amazing. I love that if just a one book, here's the book you got to read. I like that approach. What's a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
太棒了。我喜欢这种“如果只读一本，就读这一本”的方式。我很喜欢这种方法。最近你非常喜欢的电影或电视节目是什么？

---

### [01:18:10] Gustaf Alströmer

**English:**
Oh, I watched so much. I don't know. I love Emily in Paris on Netflix. I think I have TV serves different purpose for me these days. It's just like entertainment.

**中文翻译:**
噢，我看了很多。我不知道。我喜欢 Netflix 上的《艾米丽在巴黎》（Emily in Paris）。我觉得现在电视对我来说有不同的用途，纯粹就是娱乐。

---

### [01:18:22] Lenny

**English:**
Yeah, I get that.

**中文翻译:**
是的，我理解。

---

### [01:18:24] Gustaf Alströmer

**English:**
But what else movie do I watch? We watch the Everything All at Once. I thought that was a really good movie. That was-

**中文翻译:**
我还看了什么电影？我们看了《瞬息全宇宙》（Everything Everywhere All at Once）。我觉得那是一部非常好的电影。那是——

---

### [01:18:30] Lenny

**English:**
Yeah, it might win Best Picture.

**中文翻译:**
是的，它可能会赢得奥斯卡最佳影片。

---

### [01:18:32] Gustaf Alströmer

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:18:32] Lenny

**English:**
We have a drinking game here. People say White Lotus, we drink. And so you did not, that's probably for the best. Favorite interview question that you like to ask YC founders when you're interviewing them?

**中文翻译:**
我们这儿有个喝酒游戏：如果有人提到《白莲花度假村》，我们就喝酒。你没提，那可能最好。你在面试 YC 创始人时最喜欢的面试问题是什么？

---

### [01:18:43] Gustaf Alströmer

**English:**
What have you done since you applied to YC on your product? What are specific things that you've accomplished since you applied? Because that usually is a month or two month months ago.

**中文翻译:**
“自从你申请 YC 以来，你在产品上做了什么？自从申请以来，你具体完成了哪些事情？”因为那通常是一两个月前的事了。

---

### [01:18:51] Lenny

**English:**
That's awesome. It connects so much with what you said earlier.

**中文翻译:**
太棒了。这和你之前说的非常契合。

---

### [01:18:55] Gustaf Alströmer

**English:**
I hope the answer is like, "Here are all the things that we did."

**中文翻译:**
我希望答案是：“这是我们做的所有事情。”

---

### [01:18:59] Lenny

**English:**
Versus we just prepared for this interview.

**中文翻译:**
而不是“我们只是为这次面试做了准备”。

---

### [01:19:01] Gustaf Alströmer

**English:**
Exactly. Exactly.

**中文翻译:**
没错，没错。

---

### [01:19:02] Lenny

**English:**
Most out there wild startup you have funded?

**中文翻译:**
你资助过的最离奇、最疯狂的初创公司是哪家？

---

### [01:19:07] Gustaf Alströmer

**English:**
I think I would say when I stepped onto the hangar floor of Heart Aerospace. I can send you a photo. Literally, I am looking at an airplane that's being made and I'm like there's no SaaS company's office you can walk into and you just open your mouth and you're like, "What the hell is this?" There are a few of those companies that are space companies or airspace companies or something like that where it's just a different feeling that you fund them and you can touch it. I have a lot of appreciation for things like that now because they're much harder to do, but when you succeed, they're much more tangible and you can be like, "I have a tiny little piece in this space rocket or this airplane that we funded or this satellite above us." I really think that that's in some way a strong legacy compared to some other things that exist and just replace other softwares. And all these are better businesses, but there are strong legacies.

**中文翻译:**
我想我会说是当我踏进 Heart Aerospace 的机库地板时。我可以发给你一张照片。字面意义上，我正看着一架正在制造的飞机，我想，没有任何一家 SaaS 公司的办公室能让你走进去后惊讶得张大嘴巴说：“这到底是什么鬼？”有那么几家公司，比如太空公司或航空航天公司，资助它们并能亲手触摸到产品，那种感觉是完全不同的。我现在非常欣赏这类项目，因为它们更难做，但当你成功时，它们更真实可感，你可以说：“在这个太空火箭、这架飞机或我们头顶的这颗卫星里，有我的一小份功劳。”我真的认为，与那些仅仅是取代其他软件的东西相比，这在某种程度上是一种强大的传承。虽然那些软件可能是更好的生意，但这些是强大的传承。

---

### [01:20:06] Lenny

**English:**
What's a pro tip for applying to YC?

**中文翻译:**
申请 YC 有什么秘诀吗？

---

### [01:20:09] Gustaf Alströmer

**English:**
Pro tip. Number one thing is go to YouTube and type in like... I think there's a video that we've recorded which is about how you succeed with your application [inaudible 01:20:18]. It's an hour long video that gives you all the pro tips on how to do it. We told people in advance, "Once you've watched that video, then see if you know anybody who've done YC and then reach out to them and maybe ask them if YC is right for you, but also ask them what's important for you to, as you kind of approaching applying to YC, writing the application, during the interview, what were the things that matter?" Those are probably the two things I would do.

**中文翻译:**
秘诀。第一件事是去 YouTube 搜索……我想我们录过一个视频，是关于如何成功申请的。那是一个长达一小时的视频，提供了所有的专业技巧。我们提前告诉人们：“看完那个视频后，看看你是否认识参加过 YC 的人，然后联系他们，问问 YC 是否适合你，同时也问问他们在申请 YC、写申请书和面试过程中，哪些事情是真正重要的。”这大概是我会做的两件事。

---

### [01:20:46] Lenny

**English:**
Final question, what's one pro tip for visiting Sweden?

**中文翻译:**
最后一个问题，去瑞典旅游有什么秘诀吗？

---

### [01:20:49] Gustaf Alströmer

**English:**
First of all, you should visit in the summer. It's a really good time to be there. It's a very different country in the winter. Try to go outside the cities into the nature and then prepare yourself for Swedes not all being Americans. They're a little bit more colder and have a little bit more distance to you and they don't randomly talk to you like I've learned to do here in America. I think you just have to go along with a little bit different of a vibe than you have here in the US. Most people actually love it. Most people who have just been, they love it, but most of them go in the summer.

**中文翻译:**
首先，你应该在夏天去。那是去那里的好时机。冬天的瑞典完全是另一个国家。试着走出城市，走进大自然。然后做好心理准备，瑞典人不像美国人。他们稍微冷淡一点，会和你保持一定的距离，他们不会像我在美国学会的那样随机找你聊天。我想你只需要适应一种与美国完全不同的氛围。大多数去过的人其实都很喜欢那里，但他们大多是夏天去的。

---

### [01:21:23] Lenny

**English:**
This reminds me, I wanted to close it, but there's a tweet once about how in Sweden when you go to someone's house, they don't feed you. It's not expected that you will have food. You have to bring your own food. Is that true? And what's that about?

**中文翻译:**
这让我想起，我本想结束了，但曾经有一条推特说，在瑞典当你去别人家时，他们不给你吃的。人们不指望会有饭吃，你得自己带吃的。这是真的吗？那是怎么回事？

---

### [01:21:35] Gustaf Alströmer

**English:**
It's absolutely true. I actually gave an unconference talk about this topic. The unconference talk was all of the strange things to Swedish people do and why. If i would summarize it, yes, we do that. I actually experienced that. I went to a friend's house and they had dinner and I waited in my friend's room while they had dinner. That was just normal. And why did that happen? I think there's a strong sense of individual responsibility in Sweden, which kind of reaches over to unfriendliness, [inaudible 01:22:10] from an American or foreign lens because this is so crazy. But in Sweden it's just like, "Well, you take care of your kids. I'll take care of my kids." And it's not really a question.

**中文翻译:**
绝对是真的。我实际上还专门就这个话题做过一次“非会议”（Unconference）演讲。那次演讲讲的是瑞典人做的所有奇怪的事情以及原因。如果让我总结一下，是的，我们确实那样。我亲身经历过。我去一个朋友家，他们吃晚饭，我就在朋友的房间里等着，直到他们吃完。那很正常。为什么会这样？我认为瑞典有一种强烈的个人责任感，从美国人或外国人的角度来看，这近乎于不友好，因为这太疯狂了。但在瑞典，这就像是：“嗯，你照顾你的孩子，我照顾我的孩子。”这根本不是个问题。

---

### [01:22:18] Gustaf Alströmer

**English:**
I think that a lot of the motivations of why Swedes are strange, one of them is we don't want to be indebted to someone else. So we never want to feel like... Which is why you wouldn't... For example, if you go to a bar in Sweden, you don't buy a round, you buy your own beer because maybe you have to figure out the money at the end of the day, things like that. I think it's just actually quite individualistic society, but it's individualistic with heart I would say. There's a warmth to it, but it will definitely be appeared strange to people who don't really understand this. They think people are cold and they're just like they don't understand that there's actually a heart behind this stuff.

**中文翻译:**
我认为瑞典人之所以奇怪，很多动机之一是我们不想欠别人的情。所以我们从不想觉得……这就是为什么你不会……例如，如果你去瑞典的酒吧，你不会请大家喝一轮，你只买自己的啤酒，因为也许到头来你得算清账，诸如此类。我认为这实际上是一个相当个人主义的社会，但我想说这是一种“有温度”的个人主义。它有温暖的一面，但对于不真正理解这一点的人来说，它肯定显得很奇怪。他们认为人们很冷漠，他们只是不理解这些事情背后其实是有温度的。

---

### [01:23:00] Lenny

**English:**
That sounds really smart, to be honest, the system. I would be into it, but I can see how people are very confused. Gustaf, I can't thank you enough for doing this. This was incredible. I know that people listening to this are going to leave informed, inspired, motivated, hopefully motivated to move faster and make more progress. Two final questions. Where can folks find you online if they want to learn more or ask you may be follow up questions? And two, how can listeners be useful to you?

**中文翻译:**
老实说，这个系统听起来挺聪明的。我会喜欢的，但我能理解为什么人们会感到困惑。Gustaf，我非常感谢你参加这次节目。这太棒了。我知道听众们听完后会收获颇丰、深受启发、充满动力，希望能激励他们行动得更快，取得更多进展。最后两个问题：如果大家想了解更多或问你后续问题，可以在哪里找到你？第二，听众可以为你做些什么？

---

### [01:23:27] Gustaf Alströmer

**English:**
I tweet sometimes on twitter.com/gustaf. The most useful things that I put out is probably on the YC's YouTube channel. So I record a couple videos on growth, on sales, on how to talk to customers. I actually send them to people all day long because the Start School videos that we made are a lot of preparation went into it and it answers most of the questions that people have. So watch those first, I would say. But yeah, sometimes I tweet other stuff that people can follow. That's fine. How can people be useful to me? I love hearing feedback from founders, what they're working on. I want to hear kind of questions they have about their companies. But I want to also really emphasize that to apply to YC, you don't need to know any of us. You don't need to reach out to us. It doesn't make any specific difference.

**中文翻译:**
我有时会在 twitter.com/gustaf 上发推。我发布的最有用的东西可能是在 YC 的 YouTube 频道上。我录制了一些关于增长、销售、如何与客户交谈的视频。我整天把这些视频发给别人，因为我们制作的创业学院（Startup School）视频投入了大量准备工作，它回答了人们的大多数问题。所以我会说，先看那些视频。当然，有时我也会发一些其他的东西，大家可以关注。至于人们可以为我做些什么？我喜欢听创始人的反馈，听听他们在做什么。我想听听他们对公司有什么疑问。但我还想特别强调一点：申请 YC，你不需要认识我们中的任何人。你不需要联系我们。那不会产生任何具体的区别。

---

### [01:24:15] Gustaf Alströmer

**English:**
The principles in YC is that you should be able to become an insider in YC in Silicon Valley without knowing anybody. That's kind of what the application process is about. So feel free to reach out to us if you have questions, but don't feel like that's required to be a good YC applicant. It's actually the opposite in that we read and treat all the applications equally. Thank you so much for listening to this podcast. I mean, it made me happy you made all the way to the end.

**中文翻译:**
YC 的原则是，你应该能够在不认识任何人的情况下，成为硅谷 YC 的圈内人。这就是申请流程的意义所在。所以如果你有问题，欢迎联系我们，但不要觉得这是成为一名优秀 YC 申请者的必要条件。事实恰恰相反，我们会平等地阅读和对待所有的申请。非常感谢收听这个播客。我是说，你能听到最后让我很开心。

---

### [01:24:44] Lenny

**English:**
Yeah, extra credit for listening to the end. I also just want to say while you're saying that, it feels like YC is such a good force for the world. It just enables so much innovation and progress. And if technology is what drives the world forward, IC is so at the center of a lot of that. So just huge props to what YC is doing and what you're doing, Gustaf.

**中文翻译:**
是的，听到最后的人值得加分。我也想说，感觉 YC 是世界上的一股正能量。它促成了如此多的创新和进步。如果科技是推动世界前进的力量，那么 YC 就在很多事情的中心。所以，Gustaf，为你和 YC 所做的一切点赞。

---

### [01:25:02] Gustaf Alströmer

**English:**
We feel a lot of responsibility towards that. That's for sure.

**中文翻译:**
我们确实感到责任重大。这是肯定的。

---

### [01:25:05] Lenny

**English:**
All right, I'll let you go. Again, Gustaf, thank you for doing this.

**中文翻译:**
好了，我就不耽误你了。再次感谢你，Gustaf。

---

### [01:25:09] Gustaf Alströmer

**English:**
Thank you so much.

**中文翻译:**
非常感谢。

---

### [01:25:12] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。