# Gustav Söderström - 双语对照

This is the complete bilingual transcript for **Lenny's Podcast** featuring **Gustav Söderström**.

---

### [00:00:00] Gustav Söderström

**English:**
The internet started with curation, often user curation. So you took something, some good like people or books or music, and you digitize it and you put it online and then you ask users to curate it. And that was your Facebook, Spotify, and so forth. And then after a while, the world switched from curation to recommendation, where instead of people doing that work, you had algorithms. And that was a big change that required us and others to actually rethink the entire user experience and sometimes the business model as well. And I think what we're entering now is we're going from your curation to recommendation to generation. And I suspect it will be as big of a shift that you will eventually have to rethink your products. We have to rethink the user interface and the experience for recommendation first era. And so what does that mean in the generative era? No one really knows yet.

**中文翻译:**
互联网始于“策展”（Curation），通常是用户策展。你把一些好的东西，比如人、书或音乐数字化并传到网上，然后让用户去筛选和整理。这就是早期的 Facebook、Spotify 等等。一段时间后，世界从“策展”转向了“推荐”（Recommendation），不再由人工完成这些工作，而是交给了算法。这是一个巨大的转变，要求我们和其他公司重新思考整个用户体验，有时甚至包括商业模式。我认为我们现在正进入一个新的阶段：从策展到推荐，再到“生成”（Generation）。我怀疑这将是一个同样巨大的转变，最终你不得不重新思考你的产品。在“推荐优先”的时代，我们必须重塑用户界面和体验。那么，在“生成时代”这意味着什么？目前还没有人真正知道。

---

### [00:00:47] Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard one experiences building and growing today's most successful products. Today, my guest is Gustav Söderström. Gustav is a product legend and he's now the co-president, chief product and chief technology officer at Spotify, where he's responsible for Spotify's global product and technology strategy and oversees the product design data and engineering teams at the company. I've had Gustav on my wish list of dream guests to have on this podcast since the day I launched the podcast and I'm so happy we made it happen.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Gustav Söderström。Gustav 是产品界的传奇人物，他现在是 Spotify 的联席总裁、首席产品官兼首席技术官（CPO & CTO），负责 Spotify 的全球产品和技术战略，并监管公司的产品、设计、数据和工程团队。自从我创办这个播客的第一天起，Gustav 就在我的“梦幻嘉宾名单”上，我非常高兴我们终于邀请到了他。

---

### [00:01:19] Lenny

**English:**
In our conversation, we dig into what Gustav has learned about taking big bets and what to do when they don't work out, how Spotify moved away from squads and how they structure their teams now, how AI is already impacting their product, and also the future of music generated by AI. Also, why all great products need to pull some magic trick, how accurately succession represents Swedish business culture, and his hilarious analogy of peeing in your pants. Enjoy this episode with Gustav Söderström after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们将深入探讨 Gustav 在进行“豪赌”方面的经验，以及当这些尝试失败时该怎么办；Spotify 是如何告别“小队制”（Squads）并重新调整团队架构的；AI 如何已经在影响他们的产品，以及 AI 生成音乐的未来。此外，我们还会聊到为什么所有伟大的产品都需要玩一些“魔术技巧”，美剧《继承之战》（Succession）对瑞典商业文化的描述有多准确，以及他那个关于“往裤子里尿尿”的搞笑类比。在听完赞助商的简短介绍后，请尽情欣赏本期与 Gustav Söderström 的对话。

---

### [00:01:51] Lenny

**English:**
This episode is brought to you by Microsoft Clarity, a free easy to use tool that captures how real people are actually using your site. You can watch live session replays to discover where users are breezing through your flow and where they struggle. You can view instant heat maps to see what parts of your page users are engaging with and what content they're ignoring. You can also pinpoint what's bothering your users with really cool frustration metrics like rage clicks and dead clicks and much more. If you listen to this podcast, you know how often we talk about the importance of knowing your users, and by seeing how users truly experience your product, you can identify product opportunities, conversion wins, and find big gaps between how you imagine people using your product and how they actually use it.

**中文翻译:**
本期节目由 Microsoft Clarity 赞助。这是一款免费且易于使用的工具，可以捕捉真实用户使用你网站的情况。你可以观看实时会话回放，发现用户在哪些环节操作流畅，在哪些环节遇到困难。你可以查看即时热力图，了解用户在页面的哪些部分互动，忽略了哪些内容。你还可以通过“愤怒点击”（Rage Clicks）和“无效点击”（Dead Clicks）等非常酷的挫败感指标，精准定位困扰用户的问题。如果你听过这个播客，你就知道我们经常谈论了解用户的重要性。通过观察用户真实的体验，你可以发现产品机会、提升转化率，并找到“你想象的用户用法”与“实际用法”之间的巨大差距。

---

### [00:02:33] Lenny

**English:**
Microsoft Clarity makes it all possible with a simple yet incredibly powerful set of features. You'll be blown away by how easy Clarity is to use and it's completely free forever. You'll never run into traffic limits or be forced to upgrade to a paid version. It also works across both apps and websites. Stop guessing, get Clarity. Check out Clarity at clarity.microsoft.com.

**中文翻译:**
Microsoft Clarity 通过一套简单却功能极其强大的特性让这一切成为可能。你会惊讶于 Clarity 的易用性，而且它永远完全免费。你永远不会遇到流量限制，也不会被强制升级到付费版本。它同时支持 App 和网站。别再靠猜了，使用 Clarity 吧。请访问 clarity.microsoft.com 了解更多。

---

### [00:02:59] Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to waste of time building internal tools or trying to run your own experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform, where I was able to slice and dice data by device types, country, user stage. Eppo does all that and more delivering results quickly, avoiding knowing prolonged analytic cycles, and helping you easily get to the root cause of any issue you discover.

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 前员工为现代增长团队打造的下一代 AB 测试平台。像 DraftKings、Zapier、ClickUp、Twitch 和 Cameo 这样的公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能完美集成到现代增长团队的技术栈中。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具运行实验。我在 Airbnb 工作时，最喜欢的事情之一就是我们的实验平台，我可以在那里按设备类型、国家、用户阶段对数据进行切片分析。Eppo 实现了这一切甚至更多，它能快速交付结果，避免漫长的分析周期，并帮助你轻松找到发现的任何问题的根本原因。

---

### [00:03:44] Lenny

**English:**
Eppo lets you go beyond basic click-through metrics and instead use your north star metrics like activation, retention, subscription, and payments. Eppo supports test on front end, on the backend, email marketing, even machine learning claims. Check out Eppo at getE-P-P-O.com. That's geteppo.com. And 10X, your experiment velocity.

**中文翻译:**
Eppo 让你能够超越基础的点通率指标，转而使用你的北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习模型的测试。请访问 getE-P-P-O.com（即 geteppo.com）查看 Eppo，让你的实验速度提升 10 倍。

---

### [00:04:08] Lenny

**English:**
Gustav, welcome to the podcast.

**中文翻译:**
Gustav，欢迎来到播客。

---

### [00:04:11] Gustav Söderström

**English:**
Thanks for having me, Lenny. Pleasure to be here.

**中文翻译:**
谢谢邀请，Lenny。很高兴能来到这里。

---

### [00:04:13] Lenny

**English:**
It's my pleasure to have you on. So at this point, you've been at Spotify for over 14 years, which is a rare feat in the tech world, and you've held a lot of different roles while you've been at Spotify. Can you just start off by giving us a sense of what these various roles and what you've done over the years at Spotify and then just what are you up to these days? What are you responsible for now?

**中文翻译:**
能邀请到你是我的荣幸。到目前为止，你已经在 Spotify 工作了超过 14 年，这在科技界是非常罕见的成就，而且你担任过许多不同的角色。你能先给我们介绍一下这些年来你在 Spotify 担任过的各种角色和所做的工作吗？另外，你最近在忙些什么？现在负责什么？

---

### [00:04:33] Gustav Söderström

**English:**
So I came into Spotify in early 2009, late 2008. And my job then, I had been an entrepreneur, started some of my own companies in the, back then, very, very early feature phone, smartphone space. So I had a bunch of knowledge there. I had sold the company to Yahoo in the mobile space. I worked there for a while. I came back to Sweden and then I met through a mutual friend, Daniel Ek, the CEO and co-founder of Spotify. And they had built the desktop product already, the free streaming desktop product, and it was amazing and I could try it, but they needed someone to figure out what to do with mobile. And because I had been an entrepreneur in that space, I got that job.

**中文翻译:**
我是 2008 年底、2009 年初加入 Spotify 的。当时我的背景是一名创业者，在那个非常早期的功能机和智能手机领域创办过几家公司。所以我在这方面有很多知识。我曾把一家移动领域的公司卖给了雅虎，并在那里工作了一段时间。回到瑞典后，通过共同的朋友，我认识了 Spotify 的 CEO 兼联合创始人 Daniel Ek。当时他们已经开发出了桌面端产品，也就是那个免费流媒体桌面应用，体验非常棒，我也试用了。但他们需要有人来搞清楚移动端该怎么做。因为我曾是那个领域的创业者，所以我得到了那份工作。

---

### [00:05:20] Gustav Söderström

**English:**
So my job was to head up mobile for Spotify and figure out what the mobile offering would be, which was a challenge because, obviously, Spotify desktop was a free on-demand streaming application and back then, specifically with edge networks, you couldn't really stream at all in real time. The performance wasn't there and also you couldn't fund that with an ads model. So it was a product and business model innovation that was a lot of fun. So that's how I started. Then after a few years, I took on all of product development for Spotify. And then a few years later, I actually took on the technology responsibility, the CTO role for Spotify as well. And recently, my official title is co-president of Spotify together with Alex Nordstrom. So we run half of the company each. I run the product and technology side and he runs for the business and content side. So that's the super fast version.

**中文翻译:**
所以我的工作是负责 Spotify 的移动端业务，并确定移动端产品应该是什么样的。这在当时是个挑战，因为 Spotify 桌面端是一个免费的点播流媒体应用，而那时（尤其是使用 Edge 网络时）你根本无法实现实时流式传输，性能达不到要求，而且广告模式也支撑不起这种成本。所以那是一次非常有趣的产品和商业模式创新。这就是我的起步。几年后，我接管了 Spotify 所有的产品开发工作。又过了几年，我也承担了技术责任，担任了 Spotify 的 CTO。最近，我的正式头衔是 Spotify 的联席总裁，与 Alex Nordstrom 共同担任。我们每人管理公司的一半：我负责产品和技术端，他负责业务和内容端。这就是超简短的版本。

---

### [00:06:20] Gustav Söderström

**English:**
Aside from getting more responsibilities taking on the technology department, it has been the same job by title. I've always reported to Daniel, but because Spotify's grown so much every six to 12 months, it's been starting at a new company. First, it was sort of a Swedish Nordic challenge and then it was a European challenge and then it was getting into the US and then we became a public company. So it's as if I had jumped around between a lot of jobs actually, even though it was largely the same title and role.

**中文翻译:**
除了接管技术部门带来的更多职责外，从头衔上看工作内容差不多，我一直向 Daniel 汇报。但因为 Spotify 增长太快，每隔 6 到 12 个月，感觉就像是在一家新公司重新开始。起初是瑞典和北欧的挑战，然后是全欧洲的挑战，接着是进入美国市场，最后我们成了上市公司。所以，尽管头衔和角色基本没变，但感觉就像我在很多份工作之间跳来跳去一样。

---

### [00:06:55] Lenny

**English:**
Your story makes me think of the classic be careful what you're good at because you end up taking on more and more. And clearly, you've been given more and more responsibility over the years and so clearly things are going well and you're doing well.

**中文翻译:**
你的故事让我想起那句经典的话：“小心你擅长的事情，因为你最终会承担得越来越多。”显然，这些年来你被赋予了越来越多的责任，这说明一切进展顺利，你做得非常出色。

---

### [00:07:08] Lenny

**English:**
Shifting a little bit. So you're on my podcast currently. You actually have your own podcast, which was this limited series on the product story of Spotify, which I listened to and loved, and it's surreal to listen to your voice in real time because I've been listening to that recently in preparation for this conversation. Two questions, just what made you decide to launch your own podcast knowing you had a full-time job and a lot going on and the production value for your podcast was very high for what I could tell? And then two, just what did you learn from that experience in terms of the product you ended up a building and just empathizing with the podcast creator side of?

**中文翻译:**
换个话题。你现在正在参加我的播客，但实际上你也有自己的播客，就是那个关于 Spotify 产品故事的限量系列（*Spotify: A Product Story*）。我听了，非常喜欢。现在实时听到你的声音感觉有点超现实，因为为了准备这次谈话，我最近一直在听那个播客。我有两个问题：第一，在有一份全职工作且事务繁忙的情况下，是什么让你决定创办自己的播客的？而且据我观察，你那个播客的制作水平非常高。第二，从那次经历中，你在最终构建的产品以及与播客创作者产生共情方面学到了什么？

---

### [00:07:41] Gustav Söderström

**English:**
There were a bunch of different reasons why I did that. One is, and not a small one, I think, like you, I love writing and I have this secret creator dream in me. I used to write blog posts a long time ago and I write internally a lot. You can't write that much externally when you work at a company like this.

**中文翻译:**
我做这件事有很多原因。其中一个（而且是很重要的一个）是，我想和你一样，我热爱写作，内心深处有一个“创作者梦”。很久以前我写过博客，现在我也经常在公司内部写东西。但在像这样的公司工作，你没法在外部写太多东西。

---

### [00:08:01] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:08:02] Gustav Söderström

**English:**
But I love writing and talking and presenting. So there was certainly that. And then no small part was, from a product point of view, to empathize with one of our main constituents, the podcast creator. I'm, unfortunately, not a great musician. I try to play instruments and so forth, but I don't have any records. I don't sing very well. But I decided to make a podcast and that taught me a huge amount about what it's like to be a creator, creating different styles of podcast.

**中文翻译:**
但我喜欢写作、交谈和演讲，所以肯定有这方面的因素。另外很大一部分原因是从产品角度出发，去与我们的主要利益相关者之一——播客创作者——产生共情。不幸的是，我不是一个优秀的音乐家。我尝试过玩乐器之类的，但我没出过唱片，唱歌也不好听。但我决定做一个播客，这让我学到了很多关于成为一名创作者、创作不同风格播客的感受。

---

### [00:08:33] Gustav Söderström

**English:**
For example, we wanted to do a higher production cost podcast with music and then right away you run into a bunch of problems as Spotify is actually pretty well positioned to solve, but still, it's really hard to have music in a podcast from a rights perspective. So you understand all these problems that podcasters have and you can be better at solving them. But the biggest benefit and the real reason for doing the public podcast was that I have actually done an internal podcast through a hack where we could gate the podcast-only employees. And I tried to figure out internally how to build more culture around Spotify and help define for new employees and existing employees, who we are, the mistakes we did, the successes we had, and how we think about strategy specifically in product strategy because we were quite well known externally for technology and the squads and all of these things, not so much for product strategy.

**中文翻译:**
例如，我们想做一个制作成本更高、带有音乐的播客，然后立刻就会遇到一堆问题。虽然 Spotify 实际上很有优势去解决这些问题，但从版权角度来看，在播客中加入音乐依然非常困难。所以你会理解播客主面临的所有这些问题，从而能更好地解决它们。但做这个公开播客最大的收获和真正原因在于，我之前通过一种技术手段做过一个内部播客，只对员工开放。我试图在内部思考如何围绕 Spotify 建立更多文化，帮助新老员工定义“我们是谁”、我们犯过的错、取得的成功，以及我们如何思考战略，特别是产品战略。因为我们在外部以技术和“小队制”闻名，但在产品战略方面名气没那么大。

---

### [00:09:36] Gustav Söderström

**English:**
And because I love storytelling more than Google Docs, I decided to do an internal podcast and I went around and I interviewed actually Daniel's direct reports. So the CMO, the CHRO and CFO. And just ask them about a bunch of stuff. And the idea was to make them more approachable for employees because I felt listening to podcasts, even these people that have no idea who I am because I've never met them, I feel like I know them, I feel like I know how they think and I just like them much more. So the secret idea was, what if you could get to know your leaders much better than you do through occasional meetings or some town hall? So I did that internally, and because I'm a product person, we ended up talking a lot about product and product strategy. And people internally really like that.

**中文翻译:**
因为比起 Google 文档，我更喜欢讲故事，所以我决定做一个内部播客。我采访了 Daniel 的直接下属，比如 CMO、CHRO 和 CFO，问了他们很多事情。我的想法是让员工觉得这些领导更平易近人。因为我觉得听播客时，即使是那些根本不认识我、我也从未见过的人，我也会觉得了解他们，了解他们的思维方式，并且会更喜欢他们。所以这个秘密想法是：如果你能比通过偶尔的会议或全员大会更深入地了解你的领导，会怎么样？我在内部这么做了，因为我是个产品人，我们最后聊了很多关于产品和产品战略的内容，内部员工非常喜欢。

---

### [00:10:26] Gustav Söderström

**English:**
So next time, the question was, what if people that don't even work at Spotify yet could feel as if they knew people at Spotify? That'd be great because most leaders in most companies are very opaque and appear as some otherworldly creatures that aren't really real, I think, when you see them in business papers or something. So what if you have heard them talk for an hour or so? So that was general idea. So a combination of recruitment tool, sharing more about how we think about product strategy and just because I think it was a lot of fun. I got to interview a bunch of smart and interesting people both externally and internally.

**中文翻译:**
所以接下来的问题是：如果那些还没在 Spotify 工作的人也能感觉到他们了解 Spotify 的人，那会怎么样？那太棒了，因为大多数公司的领导都非常不透明，在商业报纸上看起来就像是不真实的“世外高人”。但如果你听过他们聊一个小时左右呢？这就是大致的想法。所以这是招聘工具、分享产品战略思考以及纯粹觉得好玩的结合。我得以在外部和内部采访了一群聪明有趣的人。

---

### [00:11:09] Lenny

**English:**
Did it have the effect that you were hoping after looking back?

**中文翻译:**
回过头来看，它达到你预期的效果了吗？

---

### [00:11:12] Gustav Söderström

**English:**
I think it did. The podcast did well and, no, we did not give it our own promotion. I had to compete as everyone else, which also gives you a lot of empathy for the problem of like, okay, now you have a product, what about user acquisition? How do you actually get people to listen to it? So it did achieve what I wanted in the sense that we have this thing called intradays where especially in the past few years when we've hired a lot, we actually fly people to Stockholm for an onboarding session to learn about Spotify. And the leadership is on stage, talking about what they do and the departments and strategy and so forth. And it's very common that people come and tell me that, "Oh, I listened to this podcast or this and the episode and it's at least one of the key reasons why I joined or sometimes the reason why I joined." So it's anecdotal, but it may be in the many tens of people, at least, who have said it. So that seems to work.

**中文翻译:**
我想是的。播客表现不错，而且我们没有给它任何内部推广。我必须像其他人一样去竞争，这也让你对“有了产品后，用户获取怎么办？如何让人们真正去听？”这类问题产生了极大的共情。它确实达到了我的目的，我们有一个叫“入职日”（intradays）的活动，特别是过去几年我们招聘了很多人的时候，我们会把大家飞到斯德哥尔摩参加培训，了解 Spotify。领导层会在台上讲解他们的工作、部门和战略。经常有人跑来跟我说：“噢，我听了那个播客的某一集，那是我加入公司的关键原因之一，甚至是唯一原因。”虽然这只是轶事传闻，但至少有几十个人这么说过。所以看起来是奏效了。

---

### [00:12:12] Lenny

**English:**
That's really interesting. Just again, and this comes up a few times on the podcast, is just the power of content in all these different ways for hiring for culture building. And it sounds like the original goal was just internally build this clinic culture and strategy.

**中文翻译:**
这很有趣。这再次印证了内容在招聘和文化建设方面的力量，这个话题在我的播客中出现过好几次。听起来最初的目标只是在内部建立这种清晰的文化和战略。

---

### [00:12:24] Gustav Söderström

**English:**
That was the original goal, make senior leadership more approachable and reduce the distance and then also share more of the thinking in an entertaining way rather than just through docs that people end up not reading.

**中文翻译:**
那是最初的目标：让高层领导更平易近人，缩短距离感，并以一种有趣的方式分享更多思考，而不是只通过那些大家最后都不会读的文档。

---

### [00:12:38] Lenny

**English:**
I love that. So I was listening to it, as I said, and what was really interesting is I think episode four was actually all about AI, and I think your first attempts at leveraging machine learning in AI within Spotify. And I think that's what led to Discover Weekly and a few other tools. And that was years ago. And it's interesting listening to it now where AI is, again, a huge deal. And so I'm curious very tactically on the product team what you advise product managers and product teams on how to think about AI in their product thinking and also just in their day-to-day work.

**中文翻译:**
我非常喜欢这个点。正如我所说，我一直在听你的播客，非常有趣的是，第四集其实全是关于 AI 的，讲的是你们在 Spotify 内部利用机器学习和 AI 的最初尝试。我想正是那些尝试催生了“每周发现”（Discover Weekly）和其他一些工具。那是好几年前的事了。现在听起来很有意思，因为 AI 再次成为了头等大事。所以我很好奇，从战术层面，你如何建议产品经理和产品团队在产品思维以及日常工作中思考 AI？

---

### [00:13:12] Gustav Söderström

**English:**
I can give a few examples there and I don't know that we're more sophisticated than anyone else, but we'll be doing at least the traditional machine learning for quite a long time. And I think in the podcast, I think I talked about the journey of the internet in stages. And one way to think about it is that the internet started with curation of the user curation. So you took something, some good, like people or books or music and you digitize it and you put it online, and then you ask users to curate it. And that was your Facebook, Spotify and so forth. And then after a while, the world switched from curation to recommendation, where instead of people doing that work, you had algorithms. And that was a big change that required us and others to actually rethink the entire user experience and sometimes the business model as well.

**中文翻译:**
我可以举几个例子。我不确定我们是否比别人更老练，但我们确实在传统机器学习领域深耕了很久。在播客里，我把互联网的历程分成了几个阶段。一种思考方式是：互联网始于“用户策展”。你把人、书或音乐等好东西数字化并放到网上，然后让用户去筛选整理。这就是 Facebook、Spotify 等。一段时间后，世界从“策展”转向了“推荐”，算法取代了人工。这是一个巨大的变化，要求我们重新思考整个用户体验，有时甚至是商业模式。

---

### [00:14:04] Gustav Söderström

**English:**
And I think what we're entering now is we're going from your curation to recommendation to generation. And I suspect it will be as big of a shift that you will eventually have to rethink your products. So that's one lens. So I tend to talk to my teams about, even though it's all machine learning, I ask them to think of this as something completely different. The recommendation error was one type of machine learning. The generation error is a different type, so don't think of it as just more of the same, think of it as something actually completely new instead. And what we learned in ... Well, a few things. So if you look at this new era of large language models and the fusion models and so forth, there are two types of applications. As I said for the recommendation error, we had to rethink the user interface and the experience for recommendation first error.

**中文翻译:**
我认为我们现在正从策展、推荐走向“生成”。我怀疑这将是一个同样巨大的转变，最终你必须重新思考你的产品。这是一个视角。所以我倾向于告诉我的团队，尽管这都是机器学习，但要把它看作完全不同的东西。“推荐时代”是一种机器学习，“生成时代”是另一种。不要把它看作是“换汤不换药”，而要看作是全新的东西。我们学到了……嗯，几件事。如果你看这个大语言模型（LLM）和扩散模型（Diffusion Models）的新时代，有两种应用类型。正如我所说，在推荐时代，我们必须为“推荐优先”重塑 UI 和体验。

---

### [00:14:57] Gustav Söderström

**English:**
And so what does that mean in the generative area? No one really knows yet. As usual, there are a bunch of iterative improvements. So we use these large language models to improve our recommendations. You can have bigger vectors that can have more cultural knowledge. You can use it for safety classification on podcasts that no one has listened to yet and so forth. So there's lots of obvious improvements and we're doing those. But so far, we've only really done one real generative product in the hard definition, which is a product that couldn't have existed without generative AI, and that is the AI DJ. So that's a concept that we've been thinking about for a very long time. And the AI DJ is you press a button, a digitized person, there's a real person named X, digitized X. So he's now an AI, comes on and talks to you about music that you like and suggests music, and you can listen to it. And if you don't like it, you can just call him back and he says, "Okay, now, let's listen to something maybe from a few summers ago," or "Here's some new stuff that were trending yesterday in The Last of Us episode or something like that."

**中文翻译:**
那么在生成时代这意味着什么？目前还没人知道。通常会有一堆迭代式的改进。比如我们使用大语言模型来改进推荐，你可以拥有包含更多文化知识的更大向量；你可以用它对还没人听过的播客进行安全分类等等。有很多显而易见的改进，我们正在做。但到目前为止，我们只做了一个符合严格定义的“真实生成式产品”——即如果没有生成式 AI 就不可能存在的产品，那就是 **AI DJ**。这是一个我们思考了很久的概念。AI DJ 的体验是：你按下一个按钮，一个数字化的人（现实中有一个叫 X 的人，我们把他数字化了，他现在是一个 AI）会出现，跟你聊聊你喜欢的音乐并推荐歌曲。如果你不喜欢，你可以把他叫回来，他会说：“好吧，那我们听听几个夏天前的东西吧，”或者“这是昨天在《最后生还者》剧集里流行的新歌”之类的。

---

### [00:16:10] Gustav Söderström

**English:**
So that product couldn't have existed without generative AI, both generating the voice and generating the content of what the voice says. So you can have individualized, personalized voice at the scale of half a billion people. And so we had the use case we have seen for many, many years. Sometimes people call it the radio use case. We called it the zero intent use case internally when you actually don't know what you want to listen to at all.

**中文翻译:**
如果没有生成式 AI，这个产品就不可能存在，无论是生成声音还是生成声音所说的内容。这样你就可以在 5 亿人的规模上实现个性化的语音服务。我们多年前就发现了一个用例，有时人们称之为“广播用例”，我们在内部称之为“零意图用例”（zero intent use case），即当你根本不知道自己想听什么的时候。

---

### [00:16:40] Gustav Söderström

**English:**
Spotify wasn't that good. Spotify was good when, at least roughly, you knew the use case of what you want to do, if it was a workout or dinner. We had lots of options for all of those. But if you really didn't know at all, it was hard to open Spotify and stare at it. And people used to say longingly that this was the one thing that radio was good at. Radio was quite bad, to be honest. I mean, it's not personalized to you at all. It's not on demand. You come in in the middle of things, it's actually terrible in many ways. But people still often say that there was something good about it. And I think that's something was the fact that you had a knob and you could just switch between contexts. It's like no, boring, boring, boring, boring, okay, this is good.

**中文翻译:**
Spotify 以前在这方面做得不够好。如果你大致知道自己想做什么，比如健身或晚餐，Spotify 表现很棒，我们有很多选项。但如果你完全不知道想听什么，打开 Spotify 盯着屏幕是很痛苦的。人们常怀念地说，这是广播唯一擅长的地方。老实说，广播其实挺糟糕的：它完全不个性化，不是点播，你听的时候可能正处于节目中间，很多方面都很差。但人们还是常说它有好的地方。我觉得那个“好的地方”在于你有一个旋钮，可以快速切换场景：这个不行，无聊，无聊，无聊……噢，这个不错。

---

### [00:17:23] Gustav Söderström

**English:**
And Spotify never had that mode of, I don't know what I want, but I want to cycle through things until I find something that I like. And I think with the AI DJ, that's actually the use case we managed to solve. So X comes on and says, "I'm going to suggest something to you that you can listen to." And if you like it, you can keep listening, but if you don't like it, you bring him back again and you change channel. And for one reason or another, we tried to solve that for many times for a long time, but just starting to play a random song without any context as to why you would hear this, it just never worked. So that was our first foray into a product that couldn't exist before. And I think to your question of principles around that, there are a few pretty distinct principles that we've learned.

**中文翻译:**
Spotify 以前从未有过这种模式：“我不知道我想要什么，但我想要不断刷，直到找到我喜欢的。”我认为通过 AI DJ，我们终于解决了这个用例。X 会出现说：“我要给你推荐一些你可以听的东西。”如果你喜欢，就继续听；如果不喜欢，你就把他叫回来，换个频道。出于各种原因，我们尝试解决这个问题很多次了，但如果只是随机播放一首歌，而没有任何关于“为什么要听这首歌”的上下文，效果从来都不好。所以这是我们第一次涉足以前不可能存在的产品。关于你提到的原则问题，我们学到了几个非常明确的原则。

---

### [00:18:09] Gustav Söderström

**English:**
One that I really like that is not my principle at all, I think it is straight from Chris Dixon, is the principle of fault-tolerant user interfaces. So I can't say how many times during the early machine learning era when we said we're moving from curation to recommendation. I saw a design sketch that was a single big play button because clearly that is the simplest user interface you can do, but if you don't understand the performance of your machine learning, you can't design for it. The quality of your machine learning, if you're going to have a single play button, needs to be literally 100% or zero prediction error, and that's never the case. So let's say that you have a one in five hits, four out of five things are done, then you need a UI that probably at least shows five things at the same time on screen. So you have a one in five of something being relevant on screen.

**中文翻译:**
我非常喜欢的一个原则（这不是我的原创，我想是直接来自 Chris Dixon）是“容错性用户界面”（fault-tolerant user interfaces）。在早期机器学习时代，当我们说要从策展转向推荐时，我记不清见过多少次那种只有一个巨大播放按钮的设计草图。显然那是你能做的最简单的 UI，但如果你不了解机器学习的性能，你就无法针对它进行设计。如果你只有一个播放按钮，你的机器学习质量必须达到 100% 准确或零预测误差，但这永远不可能。假设你的命中率是五分之一，那么你需要一个在屏幕上至少同时显示五个选项的 UI，这样屏幕上才可能有一个是相关的。

---

### [00:19:03] Gustav Söderström

**English:**
So you need to understand the performance of your machine learning to design for it. It needs to be fault tolerant and often you need an escape hatch for the user. So you make a prediction. But if you were wrong, it needs to be super easy for the user say, "No, you're wrong, I want to go to my library or to this or to that." So we have that principle of having fault-tolerant user interface and a user interface that corresponds to the current performance of your algorithms. And I think that is going to be true for generative machine learning as well. I think a very clear example actually is Mid Journey. If you think about the early Mid Journey user interface inside the Discord channel, actually generating an image was very, very slow.

**中文翻译:**
所以你需要了解机器学习的性能来辅助设计。它必须是容错的，而且通常需要给用户一个“逃生舱口”。你做了一个预测，但如果你错了，用户必须能超级容易地说：“不，你错了，我想去我的媒体库，或者去这儿、去那儿。”所以我们的原则是：拥有容错的 UI，且 UI 要与算法当前的性能相匹配。我认为这对于生成式机器学习同样适用。一个非常清晰的例子是 Midjourney。回想早期 Midjourney 在 Discord 频道里的 UI，生成一张图片其实非常非常慢。

---

### [00:19:48] Gustav Söderström

**English:**
It took a long time to generate high-quality image and they could have built the silver button thing where you put in a prompt, you wait for minutes, you get an image, and I think one out of four times, it's going to be bad. So you would've been disappointed three out of four times and it's a minute each, so like four minutes later, you'd be, "This is a shitty product." What they did was they generated four simultaneous low-res images very quickly and you could say, "So apparently, their performance was probably one in four, that's why they showed four and not six." And so one in four was usually pretty good. You click that one and either continue to iterate or scale it up. So that's also an example of, I think, people understanding where the performance of generative AI was when they built the UI. So that's something that I would be inspired by.

**中文翻译:**
生成高质量图片需要很长时间。他们本可以做一个“银色按钮”，你输入提示词，等几分钟，得到一张图。但我想四次里可能有一次效果不好，所以你会有四分之三的时间感到失望。每次一分钟，四分钟后你就会觉得“这产品真烂”。但他们做的是：同时快速生成四张低分辨率图片。你可以说，显然他们的性能大概是四分之一，所以他们显示四张而不是六张。四张里通常有一张挺好的，你点击那张，要么继续迭代，要么放大。我认为这就是人们在构建 UI 时理解生成式 AI 性能边界的一个例子。这是我深受启发的地方。

---

### [00:20:37] Gustav Söderström

**English:**
And for the AI DJ specifically, another principle is to try to avoid this urge of just wanting to show off the technology and then have this voice that talk and talk and talk and talk. You have to remember that people came there for the music. So the principle for the AI DJ coming from the team, by the way, this was a bottoms-up product actually, it required a lot of support. We actually acquired big companies and so forth to be able to build it. But the idea had been built by teams bottom up. So the principle there was literally to do as little as possible and get out of the way. And I think that was really helpful. It's not telling you what the weather is and what happened in the news and going on and on and on about this band. It is trying to get you to the music and I think that's why it's working because it is working very well for us.

**中文翻译:**
具体到 AI DJ，另一个原则是克制住“炫技”的冲动，不要让那个声音没完没了地在那儿说。你必须记住，用户是来听音乐的。顺便说一下，AI DJ 的原则来自团队内部，这是一个自下而上的产品，虽然它需要大量支持（我们甚至为此收购了大公司），但创意是团队自下而上提出的。所以那里的原则就是：尽可能少说话，别挡道。我认为这非常有帮助。它不会告诉你天气如何、新闻发生了什么，也不会对某个乐队喋喋不休。它只是试图把你引向音乐。我想这就是它奏效的原因，它对我们来说效果非常好。

---

### [00:21:24] Lenny

**English:**
I love this distinction between recommendation and generation. And this begs the question of, there's this trend that I imagine you're seeing of people autogenerating music using artists catalog. There's this Drake and The Weeknd thing that came out a week or two ago. Where do you think this ends up going and how do you think artists adjust to this world where music can just be autogenerated? This play button is all of it is generated versus just like the DJ in between the songs.

**中文翻译:**
我非常喜欢这种“推荐”与“生成”之间的区分。这引出了一个问题：我猜你也看到了这种趋势，人们利用艺人的作品库自动生成音乐。比如一两周前出现的那个 Drake 和 The Weeknd 的 AI 歌曲。你认为这最终会走向何方？在音乐可以自动生成的环境下，艺人们该如何适应？如果那个播放按钮点下去，出来的全是生成的音乐，而不仅仅是歌曲之间的 DJ 串场，会怎样？

---

### [00:21:53] Gustav Söderström

**English:**
First, big caveat, this is just super early. No one knows anything about how this is going to play out or the legal landscape and so forth, but I think it's going to have a lot of impact. And I think if we talk about two things, one is what it could do for music, the other is the right situation, and if rights-holders are getting compensated and so forth. So we talk about the first thing in isolation. I think an interesting example is right about when I grew up, Avicii came along. And it's interesting to think about because Avicii was not really considered by the existing music industry as a real artist because he couldn't really play an instrument and he couldn't sing, and he was just sitting with this computer in this DAW, digital audio workstation. And so it wasn't really considered real music. And I think now all of us consider it very real music and that he had tremendous real musical talent.

**中文翻译:**
首先，郑重声明，现在还处于极早期。没人知道这会如何演变，也没人知道法律前景如何，但我认为它会产生巨大影响。我们可以从两方面来谈：一是它对音乐本身的影响，二是版权情况，即权利人是否得到了补偿等等。如果我们单独谈第一点，一个有趣的例子是我成长过程中出现的 Avicii。回想起来很有意思，因为当时的音乐产业并不认为 Avicii 是真正的艺人，因为他不会玩乐器，也不会唱歌，只是坐在电脑前用 DAW（数字音频工作站）创作。所以当时那不被认为是“真正的音乐”。但我想现在我们所有人都认为那是真正的音乐，而且他拥有巨大的音乐天赋。

---

### [00:22:51] Gustav Söderström

**English:**
So I think right now, we're probably in the face where people say this isn't real music and it's somehow fake. I think the way to think about these diffusion models if and when they get good enough at generating music is probably the same like an instrument. It's just a much more powerful instrument and we'll probably see a new type of creator that wasn't proficient at any instrument and they couldn't assemble a full orchestra and do the thing that they had in their head and they can now generate very new things. I also think, by the way, that there is this distinction between AI music and real music that doesn't exist. For sure, very talented real musicians are using AI to get better and to help create new ideas. So that distinction doesn't really exist. It's all going to be AI. The question is what percentage, which makes the problem harder because you can't talk about if it should exist or not.

**中文翻译:**
所以我觉得现在我们可能正处于“人们说这不是真音乐，是假的”这个阶段。我认为，当这些扩散模型在生成音乐方面变得足够好时，应该把它们看作一种“乐器”。它只是一种更强大的乐器，我们可能会看到一种新型的创作者——他们不精通任何乐器，无法组建完整的管弦乐队来呈现脑海中的想法，但现在他们可以生成全新的东西。顺便说一下，我也认为“AI 音乐”和“真实音乐”之间的界限其实并不存在。毫无疑问，非常有才华的真实音乐家正在使用 AI 来提升水平并帮助产生新创意。所以这种区别并不真正存在，未来一切都会包含 AI。问题在于比例是多少，这让问题变得更复杂，因为你不能只讨论它“应不应该存在”。

---

### [00:23:50] Gustav Söderström

**English:**
You have to talk about what percentage should exist and who gets to use it or not. But I think the way to think about it is probably as an instrument and that could help create a huge amount of art. And I think this is not news to you who probably use these things a lot, but I think if you don't use these generative models, there is the perception that you tell it to create a hit and you will get that. That's not how it works. Actually, what these models do is because they've been listening to a lot of music, they are very good at doing something that sounds very similar to what already exists. Actually being original is very hard. And from one point of view, as it now gets easier to create more generic music, it will actually be more difficult than ever to be truly unique.

**中文翻译:**
你必须讨论应该存在多少比例，以及谁有权使用它。但我认为，把它看作一种乐器，它能帮助创造大量的艺术。我想这对经常使用这些工具的你来说不是新闻，但对于不使用这些生成模型的人来说，他们可能觉得只要告诉它“写一首热门歌曲”，它就能写出来。事实并非如此。实际上，这些模型因为听过大量音乐，非常擅长做出听起来与现有音乐非常相似的东西。真正的原创是非常难的。从某种角度看，随着创作平庸音乐变得越来越容易，保持真正的独特性反而会比以往任何时候都更难。

---

### [00:24:39] Gustav Söderström

**English:**
So I still think there would be tremendous skill in creating something truly unique. And my hope would be that what happened with the DAW and that technology jump was you got a whole new genre like EDM that you couldn't really produce it with an orchestra or live. And maybe we'll see completely new music styles with these technologies. I think that would be very exciting. So that's on the positive side, but then you have the rights issue, which I have a lot of empathy for. And Spotify specifically has seen this before. So we had a different technology shift like this, which was the technology shift to online downloads of music and piracy and peer to peer. So first, it was a big technology shift in peer to peer and it was exciting for consumers. More consumers started listening to more music than ever. And I think that's where we are now with generative AI.

**中文翻译:**
所以我仍然认为，创造真正独特的东西需要极高的技巧。我的希望是，就像 DAW 和那次技术飞跃带来了 EDM（电子舞曲）这种无法用管弦乐队或现场演奏产生的全新流派一样，也许我们会看到这些技术带来全新的音乐风格。我觉得那会非常令人兴奋。这是积极的一面，但随后你得面对版权问题，我对此深表同情。Spotify 以前就经历过类似的情况。我们经历过另一次技术转型，即向在线下载、盗版和 P2P（点对点）的转型。起初，P2P 是一次巨大的技术变革，对消费者来说很兴奋，更多的人开始听比以往更多的音乐。我认为这就是我们现在对待生成式 AI 的处境。

---

### [00:25:31] Gustav Söderström

**English:**
There's a new technology, but it also required a new business model before creators and industry could actually participate and benefit from this. And that's, obviously, self-serving to say because we were a big part of innovating that business model. But I still think that's what's necessary and I hope that that's what I and we could be part of. So I think we've seen the first part, the technology shift, and there will probably be a lot of discussion and chaos here which have a lot of empathy for, but I think we haven't seen the second part yet. What is a model where this could be a benefit? What actually happened after piracy is that the music industry got bigger than ever, not just as big but bigger than ever. And I think that could happen with this technology as well. But we're right in the beginning.

**中文翻译:**
新技术出现了，但在创作者和产业能够真正参与并从中获益之前，它还需要一种新的商业模式。说这话显然有点自卖自夸，因为我们是创新那种商业模式的重要参与者。但我仍然认为那是必要的，我希望我和我们公司能成为其中的一部分。所以，我认为我们已经看到了第一部分，即技术转型，这里会有很多讨论和混乱，我非常理解。但我认为我们还没看到第二部分：什么样的模式能让这成为一种益处？盗版时代之后真正发生的是，音乐产业变得比以往任何时候都庞大，不仅仅是恢复了，而是更大了。我认为这项技术也可能带来同样的结果。但我们现在才刚刚开始。

---

### [00:26:20] Lenny

**English:**
So along the same lines, something else you teach is this idea of all truly great products have to pull some magic trick. This comes up in your podcast a lot and I think you mentioned this other places, and thinking about all the stuff you're talking about here, it feels like, in a sense, everything's going to feel like magic because AI's baked into it.

**中文翻译:**
沿着这个思路，你教过的另一个观点是：所有真正伟大的产品都必须玩一些“魔术”。这在你的播客中经常出现，我想你在其他地方也提过。考虑到你在这里谈到的所有内容，感觉在某种意义上，一切都会变得像魔术一样，因为 AI 已经融入其中了。

---

### [00:26:38] Gustav Söderström

**English:**
I think when we did the AI DJ, we did a small version of that. When people first listened to it, we could see that reaction in use of testing when they've wondered ... So the magic trick there was that how could they record this person saying so many different things because it's talking about my music. So the magic trick was, obviously, didn't record a person saying, it's generated, and that magic trick wears off. You hear it all the time now and so forth, but it was one of those magic tricks. So I still think that concept is important and it seems to correlate with products going viral and taking off.

**中文翻译:**
我想当我们做 AI DJ 时，我们就做了一个小规模的尝试。当人们第一次听它时，我们在用户测试中看到了那种反应，他们会纳闷……那里的“魔术”在于：他们是怎么录制这个人说这么多不同的话的？因为它在聊“我的”音乐。显然，魔术的真相是：并没有录音，它是生成的。这种魔术感会逐渐消失，现在你到处都能听到，但在当时，它就是那样的魔术之一。所以我仍然认为这个概念很重要，它似乎与产品的病毒式传播和爆发式增长正相关。

---

### [00:27:15] Gustav Söderström

**English:**
And I think it was the same using something like Dall-E or Stable Diffusion or Mid Journey the first time. It completely seemed like a magic trick. And, obviously, there is no magic, it's just data and statistics. But I think getting to that point and iterating a product to the point where it feels like magic the first time is very helpful. And it's often a question of just getting the performance to a certain level, scoping down, removing things. There's a lot of fine-tuning, I think, that makes you cross that line from it's cool and impressive but not magic to it feels like magic. I don't understand how this could be done.

**中文翻译:**
我想第一次使用 Dall-E、Stable Diffusion 或 Midjourney 时也是一样的感觉。它完全看起来像个魔术。显然，并没有魔法，只是数据和统计。但我认为，将产品迭代到第一次使用时感觉像魔术的程度是非常有帮助的。这通常涉及将性能提升到一定水平、缩小范围、剔除杂质。我认为有很多微调工作能让你跨越那条线——从“很酷、令人印象深刻但不是魔术”到“感觉像魔术，我不明白这是怎么做到的”。

---

### [00:28:00] Lenny

**English:**
Yeah, it reminds me of the launch of GBT which ended up being the biggest, most fastest growing product in history, and it's like the epitome of a magic trick. It feels like actual magic.

**中文翻译:**
是的，这让我想起了 ChatGPT 的发布，它最终成为了历史上规模最大、增长最快的产品，它简直就是“魔术”的缩影。感觉就像真正的魔法。

---

### [00:28:09] Gustav Söderström

**English:**
Absolutely, absolutely. And to most people, it is still very ... Actually to a lot of ascent, even to researchers, it's a little bit magical. No one really understands fully. So I guess there's maybe some magic left in the world.

**中文翻译:**
绝对是。对大多数人来说，它仍然非常……事实上在很大程度上，甚至对研究人员来说，它也有点神奇。没人能完全理解。所以我猜这个世界上也许还留存着一些魔法。

---

### [00:28:23] Lenny

**English:**
Absolutely. And I think a lot of people are worried about not understanding what's going on there. Shifting to the way you all build product at Spotify. So Spotify is famous for popularizing this idea of squads and tribes. And correct me if I'm wrong, but you guys have moved away from that approach.

**中文翻译:**
确实。我想很多人也因为不理解其中的原理而感到担忧。现在聊聊你们在 Spotify 构建产品的方式。Spotify 因推广“小队”（Squads）和“部落”（Tribes）的概念而闻名。如果我没记错的话，你们已经不再采用那种方式了？

---

### [00:28:39] Gustav Söderström

**English:**
Yeah, that's right.

**中文翻译:**
是的，没错。

---

### [00:28:41] Lenny

**English:**
Okay. So I'd love to understand just why you shifted and what you learned from that approach to building product, and then just like how do you organize the teams now? What do you do now?

**中文翻译:**
好的。我很想知道你们为什么要转变，从那种构建产品的方式中学到了什么，以及你们现在是如何组织团队的？现在是怎么做的？

---

### [00:28:51] Gustav Söderström

**English:**
This was something that we focused a lot on early and it turned out to be smart of us to name these things into squads and chapters and so forth. It wasn't really ... Well, maybe it was deliberately branding, but it wasn't for purposes of branding that we made it up. We made it up because we thought it was a good structure to use and we needed names for things and this was the early internet eras you were allowed to make things up. And so it was very good for where we were at the time and it certainly helped us in recruiting. It's become a little bit of a cost to us because people still think that we organize that way and it's not a very efficient way of being organized at this scale or maybe even if you started over right now because we've learned more.

**中文翻译:**
这是我们早期非常关注的事情，事实证明，把这些东西命名为“小队”、“分部”（Chapters）等等是很聪明的做法。这倒不完全是……嗯，也许有刻意品牌化的成分，但我们发明这些词最初并不是为了品牌宣传。我们发明它们是因为觉得那是一个很好的结构，而且我们需要给事物起名字，在互联网早期，你是被允许发明新词的。这在当时非常适合我们的处境，也确实对招聘大有裨益。但现在它成了我们的一种“负担”，因为人们仍然认为我们是那样组织的，但在目前的规模下，那并不是一种非常高效的组织方式，甚至如果我们现在重新开始，也不会那样做了，因为我们学到了更多。

---

### [00:29:35] Gustav Söderström

**English:**
But I think the big difference is the idea with the squad specifically was twofold. They were supposed to be small and full stack. So squad should be about seven people and it should have front and backend, mobile, QA, agile coaches and so forth, and it should be very autonomous was the idea. And that's really what we shifted. So, first of all, as you grow the company, scaling in increments of seven engineers just creates a ton of overhead. So, obviously, our teams now tend to be much bigger, maybe two, three times that at least per manager to maybe have 14 or something instead of seven and just less overhead roles. So that's one. It looks more traditional as you learn more and is reasonable as you scale. The second big thing I think we struggle with was back then when I joined, the average age at Spotify was ... I mean, I was the oldest and this was 14 years ago. So I think the average age was probably under 30 or something and it wasn't most tech companies.

**中文翻译:**
我认为最大的区别在于，“小队”的核心理念有两个：小型化和全栈化。一个小队大约 7 个人，包含前端、后端、移动端、QA、敏捷教练等等，而且理念是它们应该非常自主。这就是我们转变的地方。首先，随着公司规模扩大，以 7 个工程师为增量进行扩张会产生巨大的管理开销。所以，显然我们现在的团队规模要大得多，每个经理带的人可能是以前的两三倍，比如 14 个人而不是 7 个，并且减少了辅助性角色。这是其一。随着经验积累和规模扩大，它看起来更传统、更合理了。第二大挑战是，我加入时 Spotify 的平均年龄……我是最老的，那是 14 年前的事了。我想当时的平均年龄可能不到 30 岁，这和大多数科技公司不一样。

---

### [00:30:46] Gustav Söderström

**English:**
And so we had coming from Sweden, which is a different culture than the US, and I love a lot of things about Swedish culture and I think we managed to keep the best parts, but Sweden is a very bottoms-up autonomous culture. There's this famous drawing on how you make decisions in Sweden. In the US, I think it's just a hierarchy. In Sweden, it's a circle. It's in a circle, no one is in the middle, there is no leader and so forth.

**中文翻译:**
我们来自瑞典，这是一种与美国不同的文化。我热爱瑞典文化的很多方面，我认为我们保留了其中最好的部分，但瑞典文化是非常“自下而上”且讲究自主的。有一张著名的图描述瑞典人如何做决策：在美国，我想那只是一个层级结构；在瑞典，它是一个圆圈。大家围成一圈，中间没有人，没有领导者，诸如此类。

---

### [00:31:13] Lenny

**English:**
Interesting.

**中文翻译:**
有趣。

---

### [00:31:14] Gustav Söderström

**English:**
So I think by culture, we're very inspired by this super autonomous thing. And I think the idea with autonomy is very reasonable and the right one, which is we work and we are hiring the smartest people we can find and we pay high salaries for that. So if you're hiring smart people, one way to think about it is you're renting brain power.

**中文翻译:**
所以我觉得在文化上，我们深受这种“超级自主”理念的启发。我认为自主的理念是非常合理且正确的：我们雇佣能找到的最聪明的人，并为此支付高薪。如果你雇佣聪明人，一种思考方式就是你在“租赁脑力”。

---

### [00:31:39] Gustav Söderström

**English:**
So if you're renting all of this expensive brain power and then you give them no room to think for themselves, that doesn't sound smart, then you should actually hire less smart people and keep your costs down or something. So I think you have to give a bunch of autonomy to actually maximize the value of the investment you're making. So that's very reasonable that you would give a lot of space for people to use as much of their talent and capacity as possible. But the problem with that is if you put autonomy very far towards the leaves of the organization, and also if you combine that with having a very junior organization, which we did back then, there's a fair chance that you're just going to produce heat. You're going to have a hundred squads with a hundred strategies running in a hundred directions. And Spotify has been there in that camp.

**中文翻译:**
如果你租用了所有这些昂贵的脑力，却不给他们独立思考的空间，那听起来并不聪明，那你还不如雇佣没那么聪明的人来降低成本。所以我认为你必须给予大量自主权，才能真正最大化你所做投资的价值。给人们足够的空间去发挥他们的才华和能力，这是非常合理的。但问题在于，如果你把自主权下放到组织的最末端（叶子节点），再加上当时我们的组织非常年轻化，那么很有可能你只是在“产生热量”而已。你会拥有 100 个小队，带着 100 种战略，朝 100 个方向奔跑。Spotify 曾经就处于那种状态。

---

### [00:32:29] Gustav Söderström

**English:**
I mean, we managed to get somewhere, for sure, in spite of this, but I'd struggle to say we were efficient in doing that. So we've done a few things. The team structure is more traditional, larger teams, less overhead. And we've been specifically working with where in the org do we put the autonomy because the extremes are at the leaves and we were there. The other extreme may be at the top, let's say maybe some Twitter, there's one person. Both have problems. If you have it at the leaves, you're going to produce a lot of heat. If you have it at the top, you need someone with a lot of capacity and Elon has a lot of capacity, but you are, by definition, going to bottleneck. All decisions have to go through there. And Daniel, it's not his personality that he even wants to make all the decisions.

**中文翻译:**
我的意思是，尽管如此，我们确实取得了一些成就，但我很难说我们那样做是高效的。所以我们做了几件事：团队结构更传统，团队更大，开销更少。我们专门研究了应该把自主权放在组织的哪个层级。两个极端分别是：放在最末端（我们以前在那儿），或者放在最顶端（比如现在的 Twitter，只有一个人）。两者都有问题。放在末端会产生大量内耗；放在顶端则需要一个能力极强的人（埃隆·马斯克能力很强），但从定义上讲，你会遇到瓶颈，所有决策都必须经过那里。而 Daniel 的性格并不是那种想要包揽所有决策的人。

---

### [00:33:19] Gustav Söderström

**English:**
He wants to maximize throughput rather than to bottleneck the throughput. So the question is, if it's not at the top and not at the very bottom, where do you put it? And what we've found, which I don't think is very contrarian at all, I think this is the case in most companies, is around the VP level. So if you have Daniel, then you have the C level, myself and others, then you have the VP level, that is a good mix of instead of having one person in the company think, so only Daniel then and the rest just do, you have on the VP level in the company this many tens to maybe hundreds of people that have a lot of autonomy to think. So you get a good amount of freedom of thought and people thinking in different directions, but it's not like 8,000 people. And these people on the VP level are both quite a lot of them, but they're also usually quite senior. They have a lot of pattern recognition.

**中文翻译:**
他想要最大化吞吐量，而不是阻塞吞吐量。所以问题是，如果不在最顶端也不在最底端，该放在哪儿？我们发现（我不觉得这有什么反直觉的，我想大多数公司都是这样）是在 **VP（副总裁）级别**。如果你有 Daniel，然后是 C 级高管（我和其他人），接着是 VP 级别。这是一个很好的平衡点：与其让公司里只有一个人在思考（只有 Daniel 思考，其他人执行），不如在 VP 级别让几十到上百人拥有高度的思考自主权。这样你既能获得足够的思想自由和多元方向，又不至于像 8000 人那样混乱。而且 VP 级别的人既有一定规模，通常又非常资深，拥有丰富的模式识别经验。

---

### [00:34:16] Gustav Söderström

**English:**
So I think that solves for, it's a good ... If you think of it as an optimization problem, it's a good optimization space. So the autonomy level in Spotify now tends to be quite high at the VP level and then lower around those levels.

**中文翻译:**
所以我认为这解决了一个……如果你把它看作一个优化问题，这是一个很好的优化空间。所以现在 Spotify 的自主权在 VP 级别往往非常高，而在其他级别则相对较低。

---

### [00:34:33] Lenny

**English:**
And when you say autonomy, what does that actually mean? Is it the VP of, say, the podcasting product has a lot of say over what happens and there's not a ton of ... I don't know how involved are people above? And I know Maya's the VP of product, I believe, for the podcast product.

**中文翻译:**
当你提到“自主权”时，具体意味着什么？是说比如播客产品的 VP 对发生的事情有很大的发言权，而上层不会过多干预吗？我不知道上层参与度有多高？我知道 Maya（Prohovnik）应该是播客产品的产品 VP。

---

### [00:34:48] Gustav Söderström

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:34:49] Lenny

**English:**
Who I think is going to come on the podcast someday. What does that mean in terms of Tommy for her, what practically?

**中文翻译:**
我想她以后也会来参加我的播客。对她来说，这种自主权在实际操作中意味着什么？

---

### [00:34:54] Gustav Söderström

**English:**
So it means that I would ask Maya to define a strategy for what we do in podcasting, how are we going to be different, why would a podcaster want to be here? Whereas another company, I will make that strategy or another company, Daniel would make that strategy. Same with ... The AI DJ, for example, came from our personalization team. And so that was a bet that they made. So they have autonomy to make those kinds of bets and define strategies. Same with the user interface, we have an experienced team, can talk about the org structure later, but I put a lot of autonomy on the VP of experience to define and suggest what it is that we want to do. And in other companies, I would define all of that myself, for example.

**中文翻译:**
这意味着我会要求 Maya 为我们的播客业务定义战略：我们要如何做到与众不同？为什么播客主会想留在我们这里？而在其他公司，可能是我来制定这个战略，或者 Daniel 来制定。AI DJ 也是一样，它来自我们的个性化团队，那是他们做的一次“押注”。所以他们有权进行这类押注并定义战略。用户界面也是如此，我们有一个体验团队（稍后可以聊聊组织架构），但我给了体验 VP 很大的自主权去定义和建议我们想做的事情。而在其他公司，这些可能全由我一个人定义。

---

### [00:35:45] Lenny

**English:**
Just going even a little bit further here, I know you have just strong opinions on the way to organize teams and how the organization helps you optimize for specific things. What are your just thoughts along those lines and what have you learned about how the impact of organization and what you're optimizing for?

**中文翻译:**
再深入一点，我知道你对团队组织方式以及组织如何帮助优化特定目标有很强的见解。你在这方面有什么想法？关于组织的影响以及你所优化的目标，你学到了什么？

---

### [00:36:03] Gustav Söderström

**English:**
Yeah. So I talk about an idealized spectrum or maybe not idealized but exaggerated spectrum. Nothing is really true, but you create extremes to make a point. So on one spectrum, you have something like Amazon, which is known for two-pizza teams, no dependencies. You try to minimize dependencies so you can run in parallel. Teams compete with each other even on the same project and so forth. But they have direct access to the user.

**中文翻译:**
是的。我常谈论一个理想化的光谱，或者说是一个夸张的光谱。现实中没有绝对，但建立极端有助于说明观点。在光谱的一端，你有像亚马逊这样的公司，以“两张披萨团队”和“无依赖”闻名。你试图最小化依赖，以便并行运作。团队之间甚至会在同一个项目上竞争。但他们可以直接接触用户。

---

### [00:36:37] Gustav Söderström

**English:**
And so the benefit here is if you have an idea, the time to get the user is very low and it has worked for them. It's produced Kindle, it produced Alexa, it's produced a lot of very novel things. There are a few interesting downsides here. One downside that I'm extremely impressed with Jeff Bezos' foreseeing is if you have teams that compete with each other, the incentives are to hide your results, hide your code. And that should make for an organization that gets no platform leverage because no one's corporating. And I think either he had that insight or because he saw this, he had to do this, but he's well known for pushing extremely hard on hard APIs. If you don't create hard APIs to your technology, you're out. And if you think about it, it has to be that way because otherwise no one would do it.

**中文翻译:**
这种方式的好处是，如果你有一个想法，触达用户的时间非常短，这对他们很奏效，催生了 Kindle、Alexa 等很多新颖的东西。但也有一些有趣的弊端。我非常佩服杰夫·贝佐斯的远见，他意识到如果团队之间相互竞争，激励机制会促使人们隐藏结果和代码。这会导致组织无法获得平台杠杆，因为没人合作。我想要么他有这种洞察力，要么是因为他看到了这种情况才不得不这么做，但他以极其强硬地推行“硬 API”（hard APIs）而闻名。如果你不为你的技术创建硬 API，你就出局。仔细想想，必须如此，否则没人会愿意合作。

---

### [00:37:32] Lenny

**English:**
And a hard API is essentially everyone knows how to use this API and connect to this team to interface with.

**中文翻译:**
“硬 API”本质上就是每个人都知道如何使用这个接口，并与该团队进行对接。

---

### [00:37:38] Gustav Söderström

**English:**
Exactly. You have to expose your technology to others. You have to maintain those APIs and they have to be very structured because otherwise the whole thing would collapse as everyone's supposed to compete because there are no incentives. You have to centrally force that. And interestingly, even though theoretically then they're the worst position to have a structured platform, I think, because they forced it so hard, they were the ones who did Amazon Web Services because they had such hard defined APIs because of this rule that it was easier for them to turn it inside out and expose it the rest of the world. Whereas if you look at someone like Google, I think they struggled more with externalizing their APIs maybe because it is so friendly and soft. So they didn't need as hard APIs on the inside because there was no competition. People could just go into each other's code.

**中文翻译:**
没错。你必须向他人开放你的技术，必须维护这些 API，而且它们必须非常结构化。否则，在每个人都应该竞争且没有合作动力的情况下，整个系统会崩溃。你必须从中央强制执行。有趣的是，尽管从理论上讲他们最不适合建立结构化平台，但正因为强制执行得如此彻底，他们才做出了 AWS（亚马逊云服务）。因为有了这条规则，他们拥有定义极其严密的 API，这使得他们更容易将内部能力反转并开放给全世界。相比之下，像谷歌这样的公司，在 API 外部化方面可能更吃力，也许是因为内部氛围太友好、太“软”了。因为内部没有竞争，大家可以直接看彼此的代码，所以不需要那么硬性的 API。

---

### [00:38:18] Gustav Söderström

**English:**
So it's interesting anecdote around it, but the main point is you're faster there, but it's going to be hard to corporate. And so you will see something like maybe exaggerating a bit. Sometimes you'll see multiple search boxes on the same page from different teams. And this has been true in Spotify, by the way, as well. You've seen multiple toasters on the Now Playing view coming up from different teams because they're working. When we were in the autonomous mode, everyone running. And then ... So you get the benefit of speed, but you get the drawback of shipping your org chart and shipping complexity to the end user. But clearly, that's been the right choice for Amazon because they're a trillion-dollar company. But then on the other spectrum, you have something like Apple who's also a trillion-dollar company. So clearly, both models work, where you would never see two search boxes from the same team popping up on an iPhone. That is centrally organized by something that is close to single individual.

**中文翻译:**
这是一个有趣的轶事，但核心点是：在那端你速度更快，但合作很难。所以你会看到（可能有点夸张）同一个页面上出现来自不同团队的多个搜索框。顺便说一下，Spotify 以前也是这样。你会在“正在播放”视图中看到来自不同团队的多个弹出提示（toasters），因为大家都在各干各的。当我们处于完全自主模式时，每个人都在奔跑。所以你获得了速度，但代价是把“组织架构图”和复杂性直接推给了最终用户。但显然，这对亚马逊来说是正确的选择，因为他们是万亿级公司。而在光谱的另一端，你有像苹果这样的公司，同样也是万亿级。显然两种模式都行得通。在 iPhone 上，你永远不会看到来自同一个团队的两个搜索框弹出。那是高度中央集权的，由接近单个个体的人来组织。

---

### [00:39:20] Gustav Söderström

**English:**
So they are instead in what is probably the world's biggest largest functional org, they're doing as much. If you think about what goes into the Apple, I mean, they certainly do everything we do. They have music service, podcast service, audiobooks, and they have a billion other services. So it's not like they have an easier problem. And yet they build something that feels more like it was built by a single developer for a single user. So they centralize and they have this bottlenecking function that everything has to go through and be decided how it fits with everything else. And so that has the benefit of the user experience being simpler and not shipping the org chart and increasing complexity. But it also has the drawback of speed without having facts on it. I've heard people working at Apple have said, "Yeah, it took seven years to get that thing to market," because you just had to wait in the pipeline.

**中文翻译:**
苹果可能是世界上规模最大的“职能型组织”（functional org），他们做的事情同样多。想想苹果涵盖的内容：音乐服务、播客、有声书，还有无数其他服务。所以他们面临的问题并不简单。然而，他们构建的东西感觉更像是“由一个开发者为一位用户打造的”。他们实行集权，拥有这种“瓶颈功能”，所有东西都必须经过那里，并决定它如何与整体契合。这样做的好处是用户体验更简洁，不会暴露组织架构，也不会增加复杂性。但缺点是速度慢（虽然我没有确凿证据）。我听在苹果工作的人说过：“是的，那个东西花了七年才上市，”因为你必须在流水线里排队等待。

---

### [00:40:17] Gustav Söderström

**English:**
So you have these extremes. And I think the most interesting example, I think, to think about is when you double click the power button on an iPhone, the Apple Pay comes up. That decision, how did that happen? You can imagine that all the services team would like to pop up when you double click that button. And so someone had to decide, should music come up, should payments come up, should something else come up? And so they have a different structure there. And on that spectrum of centralized versus decentralized, because of our strategy, which is we're a single application, trying to add or not trying to, we have added multiple types of content with actually very different business models on the backend, rev shares and royalties and book deals and so forth into single user experience. That is our strategy. We think the user experience in keeping that simple is the most important thing.

**中文翻译:**
所以你有这些极端。我认为最有趣的例子是：当你双击 iPhone 的电源键时，Apple Pay 会弹出。这个决策是怎么做出来的？你可以想象，所有的服务团队都希望在双击那个按钮时弹出自己的服务。所以必须有人决定：是弹出音乐、支付，还是别的什么？他们在那里有一套不同的结构。在集权与分权的光谱中，基于我们的战略——即我们是一个单一应用，试图（实际上已经）将多种内容类型（后端商业模式迥异，包括分成、版税、图书交易等）整合进单一的用户体验中。这就是我们的战略。我们认为保持用户体验的简洁是最重要的事情。

---

### [00:41:12] Gustav Söderström

**English:**
So we've chosen more of the centralized model, where these different vertical businesses, if you think about it, the music business, podcast, audiobooks business, they have it to go through a single recommendation organization because that's another problem. Which one do you recommend to which user? Should be a book or podcast or music? And how do you weigh them against each other? And also the user interface could easily get incredibly complicated if everyone built their own UI. The music team built their UI and then someone added features on top. So that's how we chose to optimize. But it is based on our strategy and I think both models work.

**中文翻译:**
所以我们选择了更偏向集权的模式。如果你仔细想想，音乐、播客、有声书这些不同的垂直业务，都必须经过一个统一的“推荐组织”，因为那是另一个问题：给哪个用户推荐哪种内容？是书、播客还是音乐？如何权衡它们？此外，如果每个团队都构建自己的 UI，用户界面会变得极其复杂。音乐团队做一套 UI，然后别人在上面叠功能。这就是我们选择的优化方式。它是基于我们的战略的，而且我认为两种模式都行得通。

---

### [00:41:50] Lenny

**English:**
This episode is brought to you by Eco. Last month, Eco users earned an average of $84 in cashback rewards. How? With Eco, the future of personal finance. Eco is the update to a misaligned financial system. Providing an app that works just like your bank but removes almost all of the middleman, helping even the best money optimizers optimize in less time automatically. What if you earn rewards for paying your rent or got rewarded for ordering food and shopping online or even earn rewards for saving each month? And then imagine if you got rewarded again just for getting rewarded. With Eco, you can spend at some of your favorite merchants and automatically get 5% cashback, plus Eco's APY rewards look more like $80, not 80 cents. And then there are Eco points, the world's first open reward system. You earn them whenever you do almost anything in the Eco app.

**中文翻译:**
本期节目由 Eco 赞助。上个月，Eco 用户平均获得了 84 美元的现金返还奖励。怎么做到的？通过 Eco，个人理财的未来。Eco 是对失调金融系统的更新。它提供一个用起来像银行一样的 App，但去除了几乎所有的中间商，帮助即使是最顶尖的理财达人也能在更短的时间内自动优化财务。如果你付房租能赚奖励，点外卖、网购能得奖励，甚至每月存钱也能得奖励，会怎样？想象一下，如果你因为获得奖励而再次获得奖励。使用 Eco，你在一些喜爱的商家消费可自动获得 5% 的返现，此外 Eco 的年化收益奖励更像是 80 美元，而不是 80 美分。还有 Eco 积分，全球首个开放式奖励系统，只要你在 Eco App 里做几乎任何事都能赚取积分。

---

### [00:42:40] Lenny

**English:**
Eco is working to make these points the most rewarding points ever. So it pays to be early. Sound too good to be true? Go to eco.com/lenny, sign up for an onboarding and find out why it isn't. Lenny's Podcast listeners who attend an Eco welcome session will get an exclusive 4% APY on deposits over $1,000. Learn more at eco.com/lenny, that's E-C-O.com/lenny.

**中文翻译:**
Eco 正致力于让这些积分成为史上最有价值的积分。所以，越早加入越划算。听起来太完美了？访问 eco.com/lenny，注册参加新用户引导，看看为什么它是真实的。参加 Eco 欢迎会的 Lenny 播客听众，存款超过 1000 美元即可获得独家 4% 的年化收益率。更多信息请访问 eco.com/lenny。

---

### [00:43:05] Lenny

**English:**
It's interesting these two examples you gave, Apple and Amazon, they're two of the biggest companies in the world and they're like at the extremes of these two into the spectrum. And it's interesting, most companies are somewhere in the middle. I wonder if there's just a benefit to being in an extreme and that ends up being really important.

**中文翻译:**
你举的这两个例子很有意思，苹果和亚马逊是全球最大的两家公司，却处于光谱的两个极端。有趣的是，大多数公司都处于中间位置。我在想，处于极端位置是否本身就是一种优势，并且最终变得非常重要。

---

### [00:43:21] Gustav Söderström

**English:**
I think so. In almost all industries, you have this smiling curve concept, where you want to be at the extremes on the smiling curve, and that's where big business opportunities are but not in the middle. So it's probably true in terms of organizational models as well.

**中文翻译:**
我想是的。在几乎所有行业中，都有“微笑曲线”的概念，你希望处于曲线的两端，那是巨大商业机会所在，而不是中间。在组织模式上可能也是如此。

---

### [00:43:34] Lenny

**English:**
Speaking of extremes, I want to talk a bit about taking big bets. So you guys had this big launch event recently where you basically redesigned the whole primary feed of Spotify to make it feel more like where apps are going, like TikTok reels feel of just stream, and you start hearing videos and music starts playing and some people loved it, some people did not. And I'm curious as a product leader, how you think about thinking long term and dealing with people that are just like, "What the hell's ... I hate change, stop changing things." How do you think about that? Who do you listen to? Who do you ignore? How do you know to stay the course? How do you approach that?

**中文翻译:**
说到极端，我想聊聊“豪赌”。你们最近举行了一次大型发布会，基本上重新设计了 Spotify 的整个主信息流，让它感觉更像现在的 App 趋势，比如 TikTok 或 Reels 那种流式体验，视频和音乐会自动播放。有些人很喜欢，有些人则不然。作为一名产品领导者，我很好奇你如何思考长期目标，以及如何应对那些大喊“搞什么鬼……我讨厌改变，别再改了”的人？你如何思考这个问题？你听谁的？忽略谁？你如何知道该坚持下去？你是如何处理的？

---

### [00:44:10] Gustav Söderström

**English:**
Yeah, you're being very kind. There was a lot of negative feedback on Twitter on some of that. So let me actually dig into some detail because I think for product people listening to this, this is an interesting lesson that I think few companies talk about because you want talk about everything that went exactly as you thought they would and you don't want to talk about the things that didn't go exactly as you thought they would.

**中文翻译:**
是的，你太客气了。Twitter 上确实有很多负面反馈。让我深入聊聊细节，因为我觉得对于听这个节目的产品人来说，这是一个有趣的教训。很少有公司会谈论这些，因为大家都想谈论那些完全按计划进行的事情，而不想谈论那些出乎意料的事情。

---

### [00:44:39] Gustav Söderström

**English:**
So I'll go through what we are trying to achieve and what we learned. So Spotify is mainly a background application, and for a long time, we've been considered very good at background music and podcast recommendation. When the phone is in your pocket and you're listening to an EDM playlist or pop playlist or something, we're really good at inserting another EDM track there or another pop track there or something like that in the background.

**中文翻译:**
我会讲讲我们试图实现的目标以及我们学到了什么。Spotify 主要是作为一个后台运行的应用，长期以来，我们被认为非常擅长后台音乐和播客推荐。当手机在你的口袋里，你正在听 EDM（电子舞曲）或流行乐列表时，我们非常擅长在后台插入另一首 EDM 或流行乐。

---

### [00:45:09] Gustav Söderström

**English:**
What we hear from users again and again, though, is that they say that they get trapped in a taste bubble. So I love my Spotify, I love this, but I'm a little bit bored with EDM now and Spotify's not suggesting something completely new. And if you think about that problem, it may sound similar to the recommendation problem, it's just another recommendation problem, but it's actually fundamentally different because when you're recommending another EDM track inside the EDM playlist, you have a lot of signal from that user that they like EDM. But if you're going to recommend a completely new genre, by definition, you have no idea. Because if you had an idea, it wasn't new to them. So you can't know anything. So back to hit rate, your hit rate is going to be incredibly low when you suggest something completely new to the user.

**中文翻译:**
然而，我们一次又一次听到用户反映，他们觉得自己被困在了“审美茧房”（taste bubble）里。他们会说：“我爱 Spotify，但我现在听腻了 EDM，而 Spotify 并没有推荐全新的东西。”如果你思考这个问题，它听起来可能像是一个普通的推荐问题，但实际上有本质区别。当你在 EDM 列表里推荐另一首 EDM 时，你有很强的信号表明用户喜欢 EDM。但如果你要推荐一个全新的流派，从定义上讲，你是一无所知的。因为如果你知道，那对他们来说就不是“全新”的了。所以你无法预知。回到命中率，当你向用户推荐全新事物时，命中率会低得惊人。

---

### [00:46:03] Gustav Söderström

**English:**
So this problem of helping people get out of the taste bubble isn't that easy as it sounds. And we can't really take some genre that maybe isn't typical. So I'm a big fan of Reggaeton, for example. It's not typically ... It's not that common in Sweden. And if you would look the rest of my profile, it's EDM heaviness, you probably wouldn't have guessed it. And Spotify wouldn't have guessed it. So if I'm listening to my favorite EDM playlist in the background or maybe my metal playlist, metal is very big in Sweden, it's really hard for us to just insert a Reggaeton track in the middle of that. Most people are going to think Spotify's broken.

**中文翻译:**
所以，帮助人们走出审美茧房并不像听起来那么容易。我们不能随便塞进一个非典型的流派。比如，我是 Reggaeton（雷鬼顿）的忠实粉丝，但这在瑞典并不常见。如果你看我其他的个人资料，全是 EDM，你可能猜不到我喜欢 Reggaeton，Spotify 也猜不到。如果我正在后台听我最喜欢的 EDM 列表或金属乐列表（金属乐在瑞典很流行），我们很难直接在中间插一首 Reggaeton。大多数人会觉得 Spotify 坏了。

---

### [00:46:41] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:46:41] Gustav Söderström

**English:**
What the hell are they thinking? So that doesn't really work. So in order to help people break out of their taste bubbles, you need something different. You need something where your hit ratio can be very low and you need people to expect it to be very low.

**中文翻译:**
“他们到底在想什么？”所以那行不通。为了帮助人们打破审美茧房，你需要一些不同的东西。你需要一种环境，在那里你的命中率可以很低，而且用户也预期它会很低。

---

### [00:47:00] Gustav Söderström

**English:**
So when we recommend things in the background, our hit ratio needs to be at least nine out of 10, maybe one dud is okay, but if you get five duds, you're going to think we broke your playlist and your session. We need something where one out of 10 is a success. If you find one gem out of 10 tries, you're very happy. So you need a completely different paradigm. And you also need to be able to go through many candidates quickly because the hit rate is so low. You can't take three minutes per item. It's like, "Okay, I didn't like this," and it's still like two minutes left before the next one comes on. You need to quickly say, "No, no, no." So the obvious candidates for this are these feed-type experience, where you can go through lots of content, you're expecting the hit ratio to be much lower. And if you don't like it, the cost is very low, you just swipe.

**中文翻译:**
当我们在后台推荐时，命中率至少要达到 10 分之 9。偶尔一个不喜欢的还可以，但如果有 5 个不喜欢的，你就会觉得我们毁了你的播放列表和体验。我们需要一种“10 分之 1 成功就算赢”的场景。如果你在 10 次尝试中发现了一颗明珠，你就会很开心。所以你需要一个完全不同的范式。而且因为命中率低，你必须能快速浏览大量候选内容。你不能在每项内容上花 3 分钟。不能是“好吧，我不喜欢这个”，然后还得等 2 分钟才出下一首。你需要能快速说“不，不，不”。所以最明显的选择就是这种“信息流”（feed）式的体验，你可以浏览大量内容，预期命中率较低，如果不喜欢，成本也很低，滑走就行。

---

### [00:47:50] Gustav Söderström

**English:**
And then this is the reason why people have been ... When they want to break out of their taste bubbles or when they come into Spotify and listen to something completely new, it is usually because they found it on one of these services, like a TikTok or YouTube or something, where they get exposed to lots of new content. So people were asking us for these tools and so that's what we wanted to solve for. And so we built a bunch of features, feed-like structures, where you can go through either a new genre with many tracks or a podcast channel with genre with many episodes or even full playlists. And we implemented those and we put them in something called subfeeds. So in the current experience, and this is roll out worldwide, if you click the podcast subfeed, you get a feed of podcast episodes. Click the music subfeeds, you get a feed of playlists where you can go through many playlists. And if you don't understand the name, you can quickly hear what they sound like and check out a few tracks and understand if this is for you. And if you go through the search and browse page, you can find completely new genres that you can quickly go through.

**中文翻译:**
这就是为什么当人们想要打破审美茧房，或者在 Spotify 听到全新内容时，通常是因为他们在 TikTok 或 YouTube 等服务上发现了它，在那里他们会接触到大量新内容。所以用户向我们要这些工具，这就是我们想要解决的问题。于是我们构建了一系列功能，即类信息流结构，你可以浏览包含多首曲目的新流派，或者包含多集节目的播客频道，甚至是完整的播放列表。我们实现了这些功能，并把它们放在所谓的“子信息流”（subfeeds）中。在目前的体验中（已全球推行），如果你点击播客子流，你会看到播客单集的信息流；点击音乐子流，你会看到播放列表的信息流。如果你不理解名字，可以快速试听，了解这是否适合你。在搜索和浏览页面，你可以找到全新的流派并快速浏览。

---

### [00:48:59] Gustav Söderström

**English:**
And so those are working as we intended. People go to them when they want to find new music. They browse through them and they save new songs. So they're working as we intended. The thing that didn't work as we intended was when users asked us for this again and again, we took the sum of these things and we put it on Home because people ask so much about discovery and we can see clearly how correlated discoveries with retention on Spotify and so forth. But what we misjudged or failed or rather learned about our own homepage is that the way it works right now, and this is what you can see in the Twitter comment, if you remove the angry voices and try to see what they're saying, they're saying the following, which is actually quite clear in the quantitative data as well, that if you look at what people do on Spotify's homepage, the current one, it is almost 90% what we call recall.

**中文翻译:**
这些功能正按我们的预期运作。当人们想找新音乐时，他们会去那里浏览并保存新歌。没按预期运作的是：当用户不断要求这些功能时，我们将这些东西整合并放在了“首页”（Home）上，因为人们非常渴望“发现”（discovery），而且我们清楚地看到发现与留存率高度相关。但我们误判了，或者说从中学到的是：我们现在的首页运作方式（如果你过滤掉 Twitter 上的愤怒情绪，看看他们到底在说什么），其实在定量数据中也非常清晰——如果你看用户在 Spotify 首页上的行为，将近 90% 是我们所谓的“召回”（recall）。

---

### [00:49:59] Gustav Söderström

**English:**
So it is either getting to a session that you're already in or a specific playlist that you know you want to get to or at least a specific use case. So you come in with a high intent, you actually knew what you wanted, and maybe only 10% of the time as a true discovery, like I don't know what I want. So if you think about, that is 90% recall and 10% discovery. When we tested the design ... So the subfeeds were working and not working, but when we tested some of them on Home, we switched it from 90/10 to 10/90. So 10% recall, 90% discovery. And while people want discovery, they probably don't want 90% discovery, instead of 90% recall. So if you then look at the comments on Twitter, what they're saying is like, "Hey, I can't find my playlists anymore. Where are these things?"

**中文翻译:**
也就是说，用户要么是想回到之前的收听状态，要么是想找某个特定的播放列表，或者至少是一个特定的用例。你带着明确的意图进来，你知道自己想要什么。可能只有 10% 的时间是真正的“发现”（即不知道想要什么）。所以，首页是 90% 的召回和 10% 的发现。当我们测试新设计时……子流本身是有效的，但当我们把它们放在首页测试时，我们把比例从 90/10 变成了 10/90。即 10% 的召回，90% 的发现。虽然人们想要发现，但他们可能不想要用 90% 的发现去取代 90% 的召回。所以你看 Twitter 上的评论，他们说的是：“嘿，我找不到我的播放列表了，这些东西都去哪儿了？”

---

### [00:50:47] Gustav Söderström

**English:**
They're not really complaining about the discovery, they're complaining about the things they don't get anymore. And we can see this in the quant data as well. And you can see traffic shifting from home into search and into library, which is a clear sign people are trying to find the things they can't find anymore. And you can even see people then trying to use these discovery tools which are optimized for quickly understanding new things to do the recall. Where's that workout playlist I know I want? And it's actually very bad UI for recall, it's like a slot machine, right? Very unpredictable if you ever get to that workout playlist. It was optimized for finding new things, not for recall of existing things. When you do recall, you want the dense UI with many items on screen because you know what it is you're looking for. So you don't need a lot of real estate when you're doing discovery of new things. You want a lot of pixels and you probably want sound because you don't know what it is.

**中文翻译:**
他们并不是在抱怨“发现”功能，而是在抱怨他们失去的东西。我们在定量数据中也看到了这一点：流量从首页转移到了搜索和媒体库，这清楚地表明人们在寻找那些找不到的东西。你甚至能看到人们试图用这些为“快速理解新事物”而优化的发现工具去做“召回”。“我想要的那份健身列表在哪儿？”对于召回来说，这其实是非常糟糕的 UI，就像老虎机一样，对吧？你很难预测什么时候能刷到那份健身列表。它是为寻找新事物优化的，而不是为召回旧事物优化的。当你做召回时，你想要高密度的 UI，屏幕上有很多项，因为你知道自己在找什么。而当你发现新事物时，你不需要那么多项，但你需要大量的像素空间，可能还需要声音，因为你不知道那是什么。

---

### [00:51:40] Gustav Söderström

**English:**
So what we learn about our UI, and I think there's maybe a little bit of product jealousy here, you always look at other experiences. And if you look around, it could be forgiven for thinking that most other products, if you look at something like YouTube, for example, their homepage is exactly that. It's a huge single-item discovery feed with only new items. And people don't seem to tweet angrily about how angry they are at you to say they love YouTube and it's a big product. And I think what we discovered was that we actually did something really well on our homepage, which was supporting you being inside a multiple sessions at the same time. So you could be in the middle of two podcasts and an audiobook and also them actually I just want to get to that workout playlist. I don't remember the name of it, but I know it's workout.

**中文翻译:**
所以我们对自己的 UI 有了新认识。我想这里可能有一点“产品嫉妒”，你总会看别人的体验。如果你环顾四周，你可能会觉得大多数其他产品（比如 YouTube）的首页就是那样的：一个巨大的单项发现流，全是新内容。人们似乎并不会愤怒地发推抱怨 YouTube，反而说他们爱 YouTube。我认为我们发现的是：我们其实在首页上做得非常好的一点是，支持你同时处于多个收听状态中。你可能正听到两档播客和一本有声书的中途，同时你还想找那份健身列表（你不记得名字，但知道是健身用的）。

---

### [00:52:31] Gustav Söderström

**English:**
We actually did that part really well. I would venture just say much better than the other experiences where you literally have to go to some tab and into library and start browsing to get back to where you were. And so maybe it's path dependent. Because we have done recall pretty well, people got, I think, reasonably upset when they couldn't do the recall anymore. And we didn't want lose that because it was one of the things we did well and underestimated. And my takeaway is actually we do it better than other experiences. So we certainly want to keep that. So what we did was now we're just updating their hypothesis to achieve the same goal, which is these things are working and when people want to discover, they use them and they seem to work, they can also get better.

**中文翻译:**
我们那部分其实做得非常好。我敢说比其他体验好得多，在其他 App 里你真的得去某个标签页，进媒体库，然后开始浏览才能回到之前的状态。所以这可能是路径依赖。因为我们把召回做得太好了，当人们无法再进行召回时，他们感到沮丧是很合理的。我们不想失去这一点，因为那是我们做得很好却被低估的地方。我的感悟是，我们在这方面其实比其他产品做得更好，所以我们肯定要保留它。所以我们现在做的是更新假设，以实现同样的目标：这些功能是有效的，当人们想发现时，他们会使用它们，而且效果不错，还可以变得更好。

---

### [00:53:20] Gustav Söderström

**English:**
You're on this hill-climbing journey from a machine learning point of view, but the question is, how do you make sure that whenever people feel that they are in that I'm trapped in my taste bubble, they understand that these things are there and they're easy to use? So now we have a version of Home that we are also testing, obviously, where these things are very available but voluntary and you can still do all of the recall. And so from my point of view, this is the reason we A/B test because you want to be scientific about it and you want to learn as much as possible about your own product and your users. And now I'm sharing a lot of the learnings. Maybe we should keep them to ourselves, but my hunch is that it's going to make it a much better product.

**中文翻译:**
从机器学习的角度看，这是一个“爬山”的过程。但问题是，如何确保当人们感到被困在审美茧房时，他们知道这些工具就在那里且易于使用？所以现在我们有一个正在测试的首页版本，这些功能非常容易触达，但是自愿使用的，你仍然可以进行所有的召回操作。在我看来，这就是我们做 AB 测试的原因，因为你想要科学地对待它，尽可能多地了解你的产品和用户。现在我分享了很多心得，也许我们应该保密，但我直觉这会让产品变得更好。

---

### [00:54:09] Gustav Söderström

**English:**
But what I told my teams when we went into this, because I've done this a few times, agree to signing, I think there are two fundamentally different types of product development. One is designing a new feature. It is hard, but it's voluntary for people to use. So you do the AI DJ. Some people love it, that's fine. If you don't like it, it didn't make it worse for you. But when you redesign, it is much more tricky because it's not voluntary to participate in the redesign. So there's a cost even for people who don't like it. Then you have a very tricky problem here, which is there are going to be two types of feedback. One is you did something and it was right, but people are upset because you changed stuff. The other is you did something and it wasn't right, and people are also upset but for good reasons.

**中文翻译:**
在开始这件事时我告诉团队（因为我经历过几次重设计），我认为有两种根本不同的产品开发类型。一种是设计新功能。这很难，但是用户自愿使用的。比如 AI DJ，有人爱它，那很好；如果你不爱，它也不会让你的体验变差。但当你做“重设计”（redesign）时，情况就棘手得多，因为参与重设计不是自愿的。即使是不喜欢它的人也要承担成本。于是你会遇到一个非常棘手的问题，反馈会分为两类：一类是你做对了，但人们因为你改变了他们的习惯而生气；另一类是你做错了，人们生气是有正当理由的。

---

### [00:55:08] Gustav Söderström

**English:**
And so how do you separate these two? Because I think I explained this to ... When we talk through this with my teams, I think the analogy to think about is you have your desktop, your physical desktop, you have your computer in one place, you have your pencil over here, you have your notebook over there, and I come in and I just rearrange all of it. And you have spent, in our case, maybe 12 years with that setup. It doesn't matter if I have a lot of quantitative data that my new setup is better, you're going to get upset because you are effective in this old setup. And it's hard to tell those apart. The most classic use case is the Facebook newsfeed, which people are very upset about when it became a single newsfeed. But it turned out to solve a lot of user problems that you didn't have to run around all of Facebook collecting events yourself.

**中文翻译:**
你如何区分这两者？我跟团队讨论时用过一个类比：想象你的物理桌面，电脑放在这儿，铅笔在那儿，笔记本在另一边。我走进来，把所有东西都重新排列了。而你已经用了这套布局 12 年了。不管我有多少定量数据证明新布局更好，你都会生气，因为你在旧布局里效率很高。很难区分这两种情绪。最经典的案例是 Facebook 的 News Feed，当它变成统一的信息流时，人们非常愤怒。但事实证明，它解决了大量用户问题，你不再需要跑遍整个 Facebook 去自己收集动态。

---

### [00:55:58] Gustav Söderström

**English:**
So there are some ways of understanding if you made it better, but people's habits are broken or if it's not better. And one thing is, for example, to look at new user cohorts that don't have that behavior versus all user cohorts and so forth. So we went through all of this with the teams. Before we did it, I said, "This is going to be painful." There's probably going to be a lot of tweets because chances that we get it exactly right are very low. So for that reason, it hasn't been very hard on the team. It is hard ... You want to respond to people, but the right way to do it is to listen, understand, try new hypothesis to really figure out what's going on. So I think I've done it maybe three or four times now. Three maybe. One unsuccessful, two successfully. So kind of knew what I was getting into.

**中文翻译:**
所以有一些方法可以了解你是真的做好了但打破了习惯，还是真的没做好。例如，观察没有旧习惯的新用户群组与老用户群组的对比。我们和团队一起梳理了这些。在开始之前，我说：“这会很痛苦。”可能会有很多负面推文，因为我们一次就做对的概率极低。正因如此，团队并没有感到太大的心理压力。虽然很难受，你想回应人们，但正确的方法是倾听、理解、尝试新假设，真正搞清楚发生了什么。我想我目前经历过三四次重设计了。大概三次吧，一次失败，两次成功。所以我知道自己面临的是什么。

---

### [00:56:45] Gustav Söderström

**English:**
So it's almost like you punish yourself, very painful, but also the most exciting things. And I think any product person knows that the easiest, the most straightforward thing to do is to iterate around where you are. There's no risk. You're not going to get fired, no user is going to get angry. But everyone also knows that eventually if you don't adapt new technologies, new paradigms, et cetera, you're going to get replaced. You have to find this balance of trying new things. And when you work in software, you have this tool of A/B testing and being scientific about it. When you build hardware, it's worse. If you're wrong, you're wrong. You can't update.

**中文翻译:**
这简直像是在惩罚自己，非常痛苦，但也是最令人兴奋的事情。我想任何产品人都知道，最简单、最稳妥的做法是在现有基础上迭代。没有风险，你不会被解雇，用户也不会生气。但每个人也都知道，如果你最终不适应新技术、新范式，你就会被取代。你必须在尝试新事物之间找到平衡。当你开发软件时，你有 AB 测试这个工具，可以科学地对待它。如果你是做硬件的，那就更惨了，错了就是错了，没法在线更新。

---

### [00:57:26] Lenny

**English:**
I love this story. I so appreciate you sharing it. I imagine also with a big launch like this, you can't actually A/B test it ahead of time because of the press season. They're like, "Oh my God, look what Spotify's doing." And so you're limited there. Imagine, right? You couldn't really test this ahead of time.

**中文翻译:**
我非常喜欢这个故事，感谢你的分享。我想像这样的大型发布，你其实无法提前进行大规模 AB 测试，因为有媒体宣传季。他们会惊呼：“天哪，看 Spotify 在做什么。”所以你在这方面受到了限制。我想你没法真正提前测试，对吧？

---

### [00:57:40] Gustav Söderström

**English:**
The hardest thing about this is if you're trying something completely new, the MVP needs to be very big so you can build a new IU, but if you didn't do algorithms for single item feed, you can't tell if it was the right idea but poor machine learning, right? UI poor machine learning. Or you have to build a lot and that gets quite expensive. That's actually ... The biggest why it's painful is not really the feedback from the outside. It is the cost you have to take on the inside. You incur a lot of costs as you're really hoping you're right.

**中文翻译:**
最难的一点是，如果你在尝试全新的东西，MVP（最小可行性产品）必须做得很大才能构建出新 UI。但如果你没有为单项流做好算法，你就无法判断是创意本身不对，还是机器学习做得太差，对吧？是 UI 的问题还是机器学习的问题？或者你必须投入大量资源去构建，这变得非常昂贵。实际上，最痛苦的不是外部的反馈，而是内部必须承担的成本。你投入了巨大成本，真心希望自己是对的。

---

### [00:58:15] Gustav Söderström

**English:**
And in our cases, the changes on the homepage aren't that hard for us to do. The important thing is that the underlying hypothesis of, can we help you break out of your taste bubble actually works and then you update the acquisition funnels into that experience. But I think the problem is that you need to get so many things in place to be able to say, "You might get a false negative," just because you didn't do it well or not. That's the biggest challenge, I think, with these big rewrites where everyone has to update everything before you can know if you're right or wrong.

**中文翻译:**
在我们的案例中，首页的改动对我们来说并不难。重要的是底层假设——“我们能否帮助你打破审美茧房”——是否真的成立，然后你再更新获取用户的漏斗。但我认为问题在于，你需要准备好太多的东西，否则你可能会得到一个“假阴性”结果，仅仅是因为你没做好而已。我认为这是大型重构中最大的挑战：在你知道自己是对是错之前，每个人都必须更新所有的东西。

---

### [00:58:52] Lenny

**English:**
What was that process like of helping you understand what is not working and what is working and what you wanted to change? I imagine there's a bunch of data you're looking at, some tweets, things like that. What was the tactical, "Oh, shoot, something's not going the way we expected, here's what we should do?"

**中文翻译:**
那个帮助你理解哪些行得通、哪些行不通以及你想改变什么的过程是怎样的？我猜你会看一堆数据、一些推文之类的。那种战术上的“噢，糟糕，事情没按预期发展，我们该怎么办”的时刻是怎样的？

---

### [00:59:08] Gustav Söderström

**English:**
Well, the feeds, we tested, but the home feed, we rolled out and tested afterwards. And we tested out on users, a few different variants of it. And then we got the data back and we looked more at the quantitative data. And we do a lot of user research where people sit and use the feeds to understand and build our own theorem mind of what is working and what is not working. And then, obviously, you look at user feedback, of course, and some users are very good at expressing what is of it that isn't working, others are not as good as expressing what isn't working. So it can be hard to parse that, but certainly, that's a factor as well.

**中文翻译:**
嗯，那些子流我们测试过，但首页流是发布后才测试的。我们在用户身上测试了几个不同的变体，然后拿回数据，更多地分析定量数据。我们做了大量的用户研究，让人们坐下来使用这些流，以建立我们自己的心智模型，了解什么是有效的，什么是无效的。当然，你也会看用户反馈，有些用户非常擅长表达哪里不好用，有些则不然。解析这些反馈可能很难，但它肯定也是一个因素。

---

### [00:59:49] Gustav Söderström

**English:**
And so then once you do that, then you have quantitative data to look at. And then you sit in recent through, what do you think is right and wrong? What are the different hypotheses? What is working, what is not working? And then just update and test again and again until you prove or disprove your hypothesis. Trying to be as scientific as possible about it. And also I think the biggest risk also when you've invested so much time in something is getting precious about things. You have to just be brutal. You have to believe in things 100% until the data says no and then you believe in something else 100%. That sounds easy. It's very hard to do, to the extent that people get upset when you do it because, for some reason, people don't like when people change their minds. It is what we should want from everyone. I would love a politician who said, "I'd looked at the data and I realized actually this is right and now I believe this." But we hate politicians that do that. They feel untrustworthy and we ridicule them.

**中文翻译:**
一旦你有了定量数据，你就会坐下来思考：你认为什么是对的，什么是错的？不同的假设是什么？什么是有效的，什么是无效的？然后不断更新和测试，直到证明或证伪你的假设。尽量保持科学的态度。而且我认为，当你投入了这么多时间后，最大的风险是变得“敝帚自珍”。你必须对自己狠一点。你必须 100% 相信某件事，直到数据说不，然后你再 100% 相信另一件事。这听起来容易，做起来极难，甚至会让人感到不快，因为出于某种原因，人们不喜欢别人改变主意。但这本该是我们对每个人的期望。我希望能有一个政治家说：“我看了数据，意识到这才是对的，现在我信这个了。”但我们讨厌那样的政治家，觉得他们不可靠并嘲笑他们。

---

### [01:00:56] Gustav Söderström

**English:**
So I think that's the biggest risk with anyone. You just have to be unemotional and just look at the proof and the data. And then if you do that, you just move on and then you get to where you want to be, and you solve the same problem but you adapt.

**中文翻译:**
所以我认为这是任何人的最大风险。你必须保持冷静，只看证据和数据。如果你能做到这一点，你就能继续前进，达到你想去的地方，解决同样的问题，但学会了适应。

---

### [01:01:14] Lenny

**English:**
I really like that philosophy. Essentially, it's the idea of strong opinions loosely held. Is that-

**中文翻译:**
我非常喜欢这个哲学。本质上就是“观点鲜明，但不固执己见”（strong opinions loosely held）。是这样吗？

---

### [01:01:19] Gustav Söderström

**English:**
Exactly. Exactly what it is. And it sounds so easy, but it's hard.

**中文翻译:**
没错，正是如此。听起来容易，做起来难。

---

### [01:01:23] Lenny

**English:**
Right? Because to your point, people don't respect someone changing their mind. They're like, "Oh, I see, they were wrong the whole time and they were so confident about being wrong."

**中文翻译:**
对吧？因为正如你所说，人们不尊重改变主意的人。他们会觉得：“噢，我明白了，他们一直都是错的，而且错得还那么自信。”

---

### [01:01:31] Gustav Söderström

**English:**
Yeah, exactly. And it's unclear why it is what we should want, but I think it has something to do with human psychology. We actually tend to love profits and people who hold very strong opinions with very little data. Those are the people we like. People will look at a lot of data and actually that, we don't like. Not sure why.

**中文翻译:**
是的，没错。虽然不清楚为什么这应该是我们追求的，但我认为这与人类心理有关。我们实际上倾向于崇拜那些在数据极少的情况下持有极强观点的人（先知）。那是我们喜欢的人。而那些看大量数据的人，我们反而不喜欢。不确定为什么。

---

### [01:01:57] Lenny

**English:**
We're flawed creatures.

**中文翻译:**
我们是有缺陷的生物。

---

### [01:01:59] Gustav Söderström

**English:**
For sure.

**中文翻译:**
确实。

---

### [01:02:00] Lenny

**English:**
Is there something that you've recently changed your mind about along these same lines that maybe comes to mind of like, "Oh, yeah?"

**中文翻译:**
沿着这个思路，最近有没有什么事情让你改变了主意，让你觉得“噢，原来是这样”？

---

### [01:02:06] Gustav Söderström

**English:**
No, I think these learnings about the science system and homepage does really well, maybe better than others, that we don't want to wash out with a bath water or whatever the [inaudible 01:02:20] expression is. I think that's the biggest current learning I'm actually very happy about.

**中文翻译:**
嗯，我觉得关于首页“召回系统”做得非常好（甚至比别人都好）的这些发现，就是我不想“连同洗澡水一起倒掉”的东西。我想这是我目前最开心的发现。

---

### [01:02:26] Lenny

**English:**
Yeah, I love learning that we're doing some really well that we didn't really realize necessarily and maybe we should lead into that more.

**中文翻译:**
是的，我喜欢这种发现：我们有些地方做得非常好，但之前并没意识到，也许我们应该进一步发扬光大。

---

### [01:02:34] Gustav Söderström

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:02:35] Lenny

**English:**
Going in a somewhat different direction. Shishir Mehrotra suggested to ask you something. He's on your board, I believe.

**中文翻译:**
换个方向。Shishir Mehrotra 建议我问你一件事。我相信他是你们的董事会成员。

---

### [01:02:41] Gustav Söderström

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:02:41] Lenny

**English:**
And he suggested to ask you about your 10% planning time. What is that about?

**中文翻译:**
他建议我问问关于你的“10% 规划时间”。那是怎么回事？

---

### [01:02:46] Gustav Söderström

**English:**
This is a concept that I think Shishir has used for a long time ever since he worked at YouTube. And the idea is that, roughly, you shouldn't be spending more than 10% of your time planning versus executing or building, which means that if you're working quarterly 10 weeks, you should spend one week planning as we work in six-month increment. So we try to spend two weeks planning and roughly successful. And this is ... Actually, when we talk about org models, give a shout-out to Brian Chesky at Airbnb, who is actually one of the first, I think, to have these more contrarian old models. He's much more applesque than most of Silicon Valley. He also works in six-month increments. He has a lot of experience in that as well. So that's what the 10% planning time is. And I think if you find yourself planning much more than that, you're either planning too much or your execution period is just too short for that amount of planning. It's a rule of thumb, but I find that it works.

**中文翻译:**
这是 Shishir 自从在 YouTube 工作以来就一直使用的一个概念。核心想法是：你用于规划的时间不应超过执行或构建时间的 10%。这意味着如果你按季度工作（10 周），你应该花一周时间规划。我们是按六个月为一个增量工作的，所以我们尝试花两周时间规划，大致上是成功的。说到组织模式，我要向 Airbnb 的 Brian Chesky 致敬，他是最早采用这种更具“反向思维”模式的人之一。他比大多数硅谷公司都更像苹果。他也按六个月为一个周期工作，在这方面很有经验。这就是“10% 规划时间”。如果你发现自己规划的时间远超于此，要么是你规划过度，要么是你的执行周期太短，支撑不起那么多的规划。这是一个经验法则，但我发现它很管用。

---

### [01:03:53] Lenny

**English:**
I asked a few PMs what I should ask you, PMs that work at Spotify actually, that I haven't told you. And someone pointed out that you always bring a lot of energy and clarity to a room. That's something they see you as really strong at. What have you learned about just the importance of that or just how to do that well as a leader?

**中文翻译:**
我问了几个在 Spotify 工作的 PM（我还没告诉你），问他们我该问你什么。有人指出，你总是能给房间带来巨大的能量和清晰度。他们认为这是你非常擅长的一点。关于这一点的重要性，或者作为领导者如何做好这一点，你学到了什么？

---

### [01:04:11] Gustav Söderström

**English:**
Well, that's great to hear. I didn't know that so I'm trying to figure out what to answer. I think that the energy, I don't know. I guess I'm just excited about what I do. I've always been excited about technology. I love seeing new things. My core drive is still this notion of you see something which I think you'll empathize with that doesn't exist yet. And you're like, "Wow, I wonder if that could exist. That would be so cool." And then in order to get people to do it, you try to share that excitement. So I don't think I can bring a lot of energy for something I'm not excited about. So I have to work on things I actually believe in and that I'm excited about. And so maybe then the energy comes more naturally. Unfortunately, for me, so far, Spotify has been in this phase where a lot of innovation is allowed and I'm even asked to try to do new cool things.

**中文翻译:**
嗯，很高兴听到这个。我之前并不知道，所以我在想该怎么回答。关于能量，我不知道，我想我只是对自己所做的事情感到兴奋。我一直对技术充满热情，喜欢看新事物。我的核心驱动力仍然是那种“看到一个尚未存在的东西”的感觉（我想你会有共鸣），然后想：“哇，我想知道这是否能实现，那一定太酷了。”为了让人们去做这件事，你会尝试分享那种兴奋感。所以我不觉得我能为我不感兴趣的事情带来能量。我必须做我真正相信并感到兴奋的事情，这样能量才会自然而然地产生。对我来说很幸运，到目前为止，Spotify 一直处于允许大量创新的阶段，我甚至被要求去尝试做一些酷的新东西。

---

### [01:05:09] Gustav Söderström

**English:**
Maybe I would have less energy for a pure optimization phase. On the clarity, I've always liked trying to explain things. It's a well-known fact that the best way to understand something is to try to explain to someone else. So I go around explaining things to people who didn't ask for it and not to sound smart, but to see if I actually understood it. And so maybe it's that practice. And on that note, I actually do ask my leaders that work for me and I ask them to ask their leaders to always explain themselves. And I think when ... We talked a little bit about autonomy and so forth, we don't promise everyone that they have to agree, but I think the promise we should make to all employees is that even if they don't agree, they should be entitled to understand why you're making the decision.

**中文翻译:**
如果处于纯粹的优化阶段，我可能就没那么多能量了。关于清晰度，我一直喜欢尝试解释事物。众所周知，理解某件事最好的方法就是尝试向别人解释。所以我经常到处向那些并没要求我解释的人解释事情，不是为了显摆，而是为了看看我是否真的理解了。所以也许是这种练习的结果。说到这儿，我确实要求我的下属领导，并要求他们也要求自己的下属，永远要“解释自己”。我们谈到了自主权，我们不承诺每个人都必须同意，但我认为我们应该向所有员工承诺：即使他们不同意，他们也有权理解你为什么要做出这个决定。

---

### [01:06:06] Gustav Söderström

**English:**
What I don't think is acceptable is to say, "No, we're going to do it this way because I'm more senior. I've seen this a bunch of times. You are not smart enough." All of those things. I think you have to explain yourself so you owe an explanation. And I find that valuable back to the only way to understand something is to explain it because it usually turns out that if you can't explain it yourself, you probably don't really even understand it yourself. Sometimes I think it's possible that you can have product instincts that are good but you can't express them. But most of them, when people say there's something there but they can't explain it, they actually don't understand it themselves. And many times, there actually isn't anything there. And also if you can explain it as a product person, that knowledge is now shared. So it just becomes much more effective for the organization. So sometimes I try to provoke people a little bit and say ... When people ask how much is art versus science, I say, "It's 0% art, 0% magic, and 100% science." And that's because I want to force people to try to explain it. I think we use the word art and magic. We have historically used the word art and magic for anything that we couldn't yet explain.

**中文翻译:**
我认为不可接受的是说：“不，我们要这么做，因为我更资深，我见过很多次了，你不够聪明。”这些都不行。我认为你必须解释自己，你欠大家一个解释。我发现这很有价值，回到那句话：理解某件事的唯一方法就是解释它。因为通常情况下，如果你无法解释，你可能自己也没真正理解。有时我认为可能存在好的产品直觉但无法表达，但大多数时候，当人们说“那里有东西”却解释不清时，他们其实自己也不懂。而且很多时候，那里其实什么都没有。此外，如果你作为产品人能解释清楚，这种知识就变成了共享的，组织效率会大大提高。所以有时我会故意挑衅一下，当人们问“艺术与科学的比例是多少”时，我会说：“0% 艺术，0% 魔术，100% 科学。”这是因为我想强迫人们去尝试解释。我认为我们使用“艺术”和“魔术”这些词，历史上是用来形容任何我们还无法解释的事物的。

---

### [01:07:33] Gustav Söderström

**English:**
Genetics was magic and art until it was science. And quantum physics was magic until it was science. And most recently, actually, intelligence and creativity was art and magic until it was statistics in an LLM. So I think I try to push people to say, "Are you sure you can explain this?" because that forces people to think through. So maybe I like it and I try to force it on people. So maybe that's why people think I sometimes bring clarity.

**中文翻译:**
遗传学在变成科学之前是魔术和艺术；量子物理在变成科学之前也是魔术。最近，智能和创造力在变成大语言模型里的统计学之前，也被认为是艺术和魔术。所以我尝试推动人们去思考：“你确定你能解释这个吗？”因为这会迫使人们深思熟虑。也许是因为我喜欢这样做并强加给别人，所以大家才觉得我有时能带来清晰度。

---

### [01:08:07] Lenny

**English:**
I love that. Question along those lines, is there a system or an approach to explaining that you recommend? Is it just write it out in a document? Is it explaining in a certain style or is it just however is natural to the person?

**中文翻译:**
我太喜欢这个观点了。顺着这个话题，你有没有推荐的解释系统或方法？是写进文档？还是按某种特定风格解释？还是随个人自然发挥？

---

### [01:08:20] Gustav Söderström

**English:**
I used to write everything and then write and rewrite and make it more and more condensed. So that worked for me. I don't write as much anymore. Now, I tend to walk and talk in my head myself. What I actually do is I ... And I found this different for different people and a lot of people want to bounce something with someone else, that's how they think. You repeat the same thing again and again and you get some feedback on it. And so I used to write a lot. I sometimes do when it's an idea I want to understand better. And at some point in my life, I would love to write something real like a book or something. But what I do increasingly now is I do my one-on-ones with peers or people who report to me or something, and I just put on AirPods and do a distributed walk and talk.

**中文翻译:**
我以前会把所有东西写下来，然后反复修改，让它越来越精炼。那对我很有用。现在我不怎么写了，我倾向于在脑子里自言自语。我发现每个人都不一样，很多人想找人交流想法，那是他们的思考方式：反复说同样的话并获得反馈。我以前写得很多，现在偶尔也会写，当我想深入理解某个想法时。在我人生的某个阶段，我很想写点真实的东西，比如一本书。但我现在越来越多做的是，在与同事或下属进行 1 对 1 沟通时，戴上 AirPods，进行“分布式边走边聊”（distributed walk and talk）。

---

### [01:09:12] Gustav Söderström

**English:**
Both people are walking but in different locations and you spend an hour discussing something. That has actually turned out to be very, very fruitful. So then you get the power of you're not alone so you get more brain power than your own. And I don't think there is strong evolutionary proof for this, but there's certainly indications that you're thinking better when you're walking, whether it's because you're oxygenating your brain or because it's evolutionary for some other reason, I'm not sure. But I found that walking, talking, and thinking actually even if you're not in person, just over AirPods, it's super effective. It was the pandemic that forced us. I thought we would get less creative and strategizing will suffer during the pandemic and I found the opposite. We had more of this than ever and I started thinking about why, and I think it's all of these walk and talks that we did.

**中文翻译:**
两个人在不同的地方走路，花一个小时讨论某件事。事实证明这非常富有成效。你不再是孤军奋战，能获得比自己更多的脑力。虽然没有很强的进化论证据，但确实有迹象表明走路时思考效果更好，也许是因为大脑供氧更足，或者其他进化原因，我不确定。但我发现，即使不是面对面，只是通过 AirPods 边走边聊边思考，也超级有效。是疫情迫使我们这么做的。我本以为疫情期间我们的创造力会下降，战略制定会受阻，结果我发现了相反的情况。我们的这种交流比以往任何时候都多，我开始思考原因，我觉得就是因为我们做了所有这些“边走边聊”。

---

### [01:10:07] Lenny

**English:**
You threw out there that you want to write a book someday. What do you think your book would be about?

**中文翻译:**
你提到想在某天写本书。你觉得你的书会关于什么？

---

### [01:10:11] Gustav Söderström

**English:**
I have no idea. I have no idea. Statistically, it's probably going to be about something that I did a lot, so it has to be about something with technology or product or something. But I would love to write something fictional. That'd be a lot of fun.

**中文翻译:**
我不知道，真的不知道。从统计学上讲，它可能会关于我做得最多的事情，所以应该是关于技术或产品之类的。但我很想写点虚构类作品，那会很有趣。

---

### [01:10:26] Lenny

**English:**
Oh, boy. I'll pre-order as soon as that's up. Another concept I wanted to touch on that another PM suggested, which is he called it the P in the pants analogy. Does that ring a bell? And is that interesting to talk about?

**中文翻译:**
噢，天哪。一旦出版我立刻预订。我想聊的另一个概念是另一位 PM 建议的，他称之为“往裤子里尿尿”的类比（P in the pants analogy）。你有印象吗？聊这个有意思吗？

---

### [01:10:40] Gustav Söderström

**English:**
I don't know exactly which occasion this person is referring to, but I know I've used that analogy a few times.

**中文翻译:**
我不确定那个人指的是哪次场合，但我确实用过几次这个类比。

---

### [01:10:49] Lenny

**English:**
Okay. Promising.

**中文翻译:**
好的，听起来有戏。

---

### [01:10:50] Gustav Söderström

**English:**
I don't know if it's like a Swedish analogy because I thought it was more widely known. But the idea is that you do something ... So the saying is that's like peeing in your pants in cold weather. It feels really warm and nice to begin with. And then after a while, you start to regret it. It's about being short term, basically. So now I just say that's like peeing in the pants inside because people know what I mean. It's a short-term thing.

**中文翻译:**
我不知道这是否是瑞典特有的类比，我以为它流传很广。这个说法是：那就像在寒冷的天气里往裤子里尿尿。刚开始感觉非常温暖舒服，但过一会儿，你就会开始后悔。这基本上是形容“短期主义”。所以现在我在公司内部只要说“那就像往裤子里尿尿”，大家就知道我的意思了——那是一个短视的行为。

---

### [01:11:21] Lenny

**English:**
That's a hilarious way of communicating that idea. Must be a Swedish thing.

**中文翻译:**
传达这个观点的方式太搞笑了。一定是瑞典特色。

---

### [01:11:21] Gustav Söderström

**English:**
Yes, I think Swedish people do it for some reason, apparently others don't.

**中文翻译:**
是的，我想瑞典人出于某种原因会这么做，显然其他人不这么干。

---

### [01:11:30] Lenny

**English:**
Maybe because it's cold a lot of times of the year.

**中文翻译:**
也许是因为一年中大部分时间都很冷。

---

### [01:11:33] Gustav Söderström

**English:**
Yes. That's probably it. This is a saying in cold climate. In the warm, it doesn't help. No one understands what you mean.

**中文翻译:**
是的，大概就是这样。这是寒冷气候下的谚语。在温暖的地方，这招不管用，没人明白你在说什么。

---

### [01:11:39] Lenny

**English:**
Speaking of Sweden, do you watch Succession?

**中文翻译:**
说到瑞典，你看《继承之战》（Succession）吗？

---

### [01:11:42] Gustav Söderström

**English:**
Yes, I do.

**中文翻译:**
是的，我看。

---

### [01:11:43] Lenny

**English:**
Okay. So Sweden's become a big part of the show, specifically the company trying to ... I guess I don't want to spoil, but there's a character that's really important. Yes, exactly. That is Swedish. And so I'm curious just what do you think of the way they portray the Swedish culture and Swedish business dealings?

**中文翻译:**
好的。瑞典成了这部剧的重要部分，特别是那家公司试图……我不想剧透，但有一个角色非常重要。没错，就是那个瑞典人。所以我很好奇，你觉得他们对瑞典文化和瑞典商业往来的刻画怎么样？

---

### [01:11:59] Gustav Söderström

**English:**
It's super fun to see this as a Sweden. And I guess, first and foremost, like anyone or any person or any country that gets represented by super tall, well-built, great looking Alexander Skarsgård should probably be pretty happy. So that's good. Then I think there's this episode where they are in Norway, without giving away too much.

**中文翻译:**
作为一个瑞典人，看这个超级有趣。我想首先，任何国家如果由高大魁梧、英俊潇洒的 Alexander Skarsgård 来代表，应该都会挺开心的。所以这很好。然后我记得有一集他们在挪威（不剧透太多）。

---

### [01:12:25] Lenny

**English:**
Yep.

**中文翻译:**
是的。

---

### [01:12:26] Gustav Söderström

**English:**
There are elements that are authentic. There's a lot of, I think, paid brand positioning from a Swedish brand named Fjällräven, which I think means arctic fox, which is actually a very popular outdoor brand in Sweden. So that's authentic. The sauna things and so forth are authentic. So it's real, but it's exaggerated. Actually, the thing that isn't very authentic is his negotiation style. Swedish people tend to be serious, cautious, and this guy's more of a player. So he's not the typical Swedish businessman from a negotiation tactic point of view, I think.

**中文翻译:**
有些元素很真实。我想里面有很多瑞典品牌 Fjällräven（北极狐）的植入，那是瑞典非常流行的户外品牌，这很真实。桑拿之类的也很真实。所以它是真实的，但经过了夸张。实际上，不太真实的是他的谈判风格。瑞典人倾向于严肃、谨慎，而这家伙更像个“玩家”。所以从谈判策略的角度来看，我觉得他不是典型的瑞典商人。

---

### [01:13:11] Lenny

**English:**
Yeah, it doesn't make me think of the way you described it where in Sweden, people sit in a circle and no one's in the center.

**中文翻译:**
是的，他确实不像你描述的那样——瑞典人围成一圈，中间没有人。

---

### [01:13:15] Gustav Söderström

**English:**
No, exactly. He's very much in the center.

**中文翻译:**
没错，他非常处于中心位置。

---

### [01:13:19] Lenny

**English:**
And then when people go saunas, there are just like a chant, sauna, sauna [inaudible 01:13:23].

**中文翻译:**
而且当人们去洗桑拿时，他们会像喊口号一样喊“桑拿，桑拿”。

---

### [01:13:23] Gustav Söderström

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:13:24] Lenny

**English:**
The last episode.

**中文翻译:**
最后一集。

---

### [01:13:25] Gustav Söderström

**English:**
It's a great show. I love it.

**中文翻译:**
这是一部伟大的剧，我很喜欢。

---

### [01:13:26] Lenny

**English:**
I love it. This season is insane. I'm so curious where it all goes. Maybe just the last question before very exciting lightning round. Spotify is, at this point, the biggest podcasting platform for me specifically and I think globally, and I love using it. It works great. I'm curious just what's next for Spotify and specifically Spotify podcasting.

**中文翻译:**
我也喜欢，这一季太疯狂了。我很想知道结局。在进入令人兴奋的闪电轮之前，最后一个问题。Spotify 目前对我个人来说是最大的播客平台，我想在全球也是如此。我喜欢用它，体验很好。我很好奇 Spotify 的下一步是什么，特别是 Spotify 播客业务。

---

### [01:13:48] Gustav Söderström

**English:**
There are two sides to it. It's for Spotify creators and for Spotify listeners. For Spotify creators, there are two things. One is, and this is what we talked about at Stream On, we talked about it also for music discovery, but it's the same problem and even harder for podcast. So we're still focused very heavily on helping podcast creators find more audience. This is ... Like I said, it's even a bigger problem to break out of your habits and your bubbles in podcasting. Such a big investment to find a new podcast. And so that is something, I think, we could and should do really well. So we keep investing a lot there. And as I said, you'll see more as we roll up more features now.

**中文翻译:**
这有两个方面：针对 Spotify 创作者和针对 Spotify 听众。对于创作者，有两件事。第一，正如我们在 Stream On 大会上提到的，我们也谈到了音乐发现，但播客面临同样的问题，甚至更难。所以我们仍然非常专注于帮助播客创作者寻找更多受众。正如我所说，在播客领域打破习惯和茧房是一个更大的挑战，寻找新播客需要投入很多精力。我认为这是我们能够且应该做好的事情。所以我们在这方面投入了大量资金。正如我所说，随着我们推出更多功能，你会看到更多成果。

---

### [01:14:37] Gustav Söderström

**English:**
The other big need for creators is monetization and you can monetize today in many ways with DEI and Spotify SEI and so forth. But we're working hard to expand that and make it better because the industry is starting to mature and I think this is one of the biggest needs and the biggest things we could do for creators to help them monetize better, actually both free and paid. We also have paid podcast. So that's on the creator side.

**中文翻译:**
创作者的另一个巨大需求是变现。现在你可以通过多种方式变现。但我们正在努力扩展并改进它，因为这个行业正趋于成熟。我认为这是最大的需求之一，也是我们能为创作者做的最重要的事——帮助他们更好地变现，无论是免费还是付费内容。我们也有付费播客。这是创作者端。

---

### [01:15:07] Gustav Söderström

**English:**
On the consumer side, I don't want to share too much. We've shown that we're investing a lot in discovery. I want to keep some secrets for when they roll out, but we are investing a lot in the user expense itself. I think it's far from optimal yet what it could be. One thing that I can share that we're investing a lot in is just the ubiquity and playback across different devices and in cars and all these things that we've done well for music. But I think the listening experience can get a lot more seamless. I think search can get better. The data about podcasts and ... Well, I don't want to say too much, but looking at AI and generative technology, there is a lot that can be done.

**中文翻译:**
在消费者端，我不想透露太多。我们已经展示了在“发现”方面的巨大投入。我想保留一些秘密，等它们发布时再说。但我们在用户体验本身投入了很多，我认为目前还远未达到理想状态。我可以分享的一点是，我们正在大力投入“无处不在”的体验，即在不同设备、汽车上的播放，这些我们在音乐方面做得很好。但我认为收听体验可以变得更加无缝。我认为搜索可以做得更好。关于播客的数据……嗯，我不想说太多，但看看 AI 和生成技术，还有很多事情可以做。

---

### [01:15:52] Lenny

**English:**
All right. Well, I'll take what I can get. With that, we've reached our very exciting lightning round. I've got six questions for you, Gustav. Are you ready?

**中文翻译:**
好吧，能听到这些也不错了。接下来进入我们非常令人兴奋的闪电轮。Gustav，我有六个问题问你。准备好了吗？

---

### [01:16:01] Gustav Söderström

**English:**
I think I am. Let's do it.

**中文翻译:**
我想我准备好了。开始吧。

---

### [01:16:03] Lenny

**English:**
Okay, we'll find out. What are two or three books that you've recommended most to other people?

**中文翻译:**
好，我们拭目以待。你向别人推荐最多的两三本书是什么？

---

### [01:16:08] Gustav Söderström

**English:**
Okay. This is why I try to squeeze in seven into two and three. So if we start on product, I think it's well known, but one that I would recommend product people to read is 7 Powers by Hamilton Helmer, and Netflix has used a lot. We use a lot. It's just if you're starting out, it's great to have a strategy framework. No strategy framework is right, but having one is better than none.

**中文翻译:**
好吧，这就是为什么我试图把 7 本书塞进“两三本”的名额里。如果从产品开始，我想这本书很有名，但我会推荐产品人读 Hamilton Helmer 的《策略的 7 个杠杆》（*7 Powers*）。Netflix 经常用，我们也经常用。如果你刚起步，拥有一个战略框架是非常棒的。没有哪个战略框架是绝对正确的，但有一个总比没有好。

---

### [01:16:31] Gustav Söderström

**English:**
Another in the space of mental models and frameworks, I think, is The Complete Investor by Charlie Munger. So, yes, it's about investment, but really it's a bunch of mental models that he uses. And I think the key takeaway is you have a problem, you should always apply three different models to it because what models do is they simplify and reduce dimensionality. The world has probably infinite dimensions and they reduces to maybe three or four. And the risk with that is you happen to get rid of a really important dimension, maybe pandemic diseases or something. But if you use three models that have different dimensions and was reduced in different ways, statistically, and it comes to the same conclusion, even the second model you apply vastly increases your chances that you're right. So that was a good book to read.

**中文翻译:**
另一本关于思维模型和框架的书是查理·芒格的《查理·芒格传》（或相关思维模型书籍，如 *The Complete Investor*）。虽然它是关于投资的，但本质上是他使用的一系列思维模型。核心收获是：当你遇到问题时，你应该总是尝试用三种不同的模型去分析。因为模型的作用是简化和降维。世界可能有无限的维度，模型将其简化为三四个。风险在于你可能会不小心删掉一个非常重要的维度（比如流行病之类的）。但如果你使用三个维度不同、简化方式不同的模型，如果它们得出了相同的结论，那么即使只增加第二个模型，你正确的概率也会大大增加。所以那是一本值得读的好书。

---

### [01:17:24] Gustav Söderström

**English:**
Then I think if we go outside of product, I'm very interested in just science and mathematics. So a few quick ones. The Mystery of the Aleph, an amazing book. Something Deeply Hidden by Sean Carroll on the interpretation of quantum mechanics. Helgoland by Carlo Rovelli on the relational interpretation of quantum mechanics. The Beginning of Infinity and The Fabric of Reality by David Deutch. The Case Against Reality by Donald Hoffman on the evolution versus truth and that evolution doesn't optimize for seeing the truth, just for fitness. Gödel's Proof, I think, is an amazing book on his incompleteness theorem, that in any axiomatic systems, there will be true statements that can never be proven, which is a weird thing to think about. And then maybe one of my favorites is The Demon in the Machine by Paul Davies that, I think, is lesser known on how information is really just entropy and this concept of information engines, that you can power something by just information and exhaust is also information. That was not a quick list.

**中文翻译:**
如果跳出产品领域，我对科学和数学非常感兴趣。快速列举几个：Amir Aczel 的《阿列夫：无限的奥秘》（*The Mystery of the Aleph*）；Sean Carroll 的《深藏之物》（*Something Deeply Hidden*），关于量子力学的解释；Carlo Rovelli 的《海格兰》（*Helgoland*），关于量子力学的关系解释；David Deutsch 的《无穷的开始》（*The Beginning of Infinity*）和《现实的织物》（*The Fabric of Reality*）；Donald Hoffman 的《反驳现实的案例》（*The Case Against Reality*），探讨进化与真理，以及进化并不优化真理的感知，只优化适应度；《哥德尔证明》（*Gödel's Proof*），关于他的不完备性定理，即在任何公理系统中，总有无法被证明的真命题，这很奇妙。最后是我最喜欢的之一，Paul Davies 的《机器中的恶魔》（*The Demon in the Machine*），它比较冷门，讲述了信息本质上就是熵，以及“信息引擎”的概念——你可以仅靠信息来驱动某物，而排出的废气也是信息。这单子列得一点也不快。

---

### [01:18:39] Lenny

**English:**
No, I was just going to say you've set the record for the most number of books, but it also shows how you've become so insightful and wise just reading books like these. And so I think if people are looking to get to a place that you're at now, I think there's the lesson.

**中文翻译:**
不，我正想说你打破了推荐书籍数量的记录，但这也展示了你是如何通过阅读这些书籍变得如此有见地和睿智的。我想如果人们想达到你现在的境界，这就是经验所在。

---

### [01:18:55] Gustav Söderström

**English:**
I'll keep the artist much shorter, I promise.

**中文翻译:**
我保证接下来的回答会短得多。

---

### [01:18:57] Lenny

**English:**
It's all good. We got time. Okay, next question. What's a favorite recent movie or TV show?

**中文翻译:**
没关系，我们有时间。好，下一个问题。最近最喜欢的电影或电视节目是什么？

---

### [01:19:03] Gustav Söderström

**English:**
So we talked about Succession and it is a recent favorite. So I'll just frivolously take something that isn't recent but is an absolute favorite, which is Halt and Catch Fire, which I think is on FX. Amazing show. If you ever worked in technology, kind of starts out in the Silicon Prairie in the '80s and follows up to present day. Amazing show.

**中文翻译:**
我们聊过《继承之战》，那是最近的最爱。那我就随便挑一个不那么新但绝对是心头好的：AMC 的《奔腾年代》（*Halt and Catch Fire*）。非常棒的剧。如果你在科技行业工作，它从 80 年代的“硅草原”开始，一直延续到现代。神作。

---

### [01:19:24] Lenny

**English:**
Halt and Catch Fire. Yeah, I watched some of it. I actually fell off of it, but it's a good reminder to go check it out.

**中文翻译:**
《奔腾年代》，我看过一点，后来没追下去，但这提醒了我该回去看看。

---

### [01:19:29] Gustav Söderström

**English:**
Got to go back.

**中文翻译:**
一定要回去看。

---

### [01:19:30] Lenny

**English:**
I'm going to go back. What's a favorite recent interview question you like to ask?

**中文翻译:**
我会的。最近你最喜欢问的面试问题是什么？

---

### [01:19:34] Gustav Söderström

**English:**
I don't ask it, but my favorite question is Lex Fridman's small ending question that is usually something like, so what's the meaning of it all? I like that. It's a tough question to get.

**中文翻译:**
我不问这个，但我最喜欢的问题是 Lex Fridman 那个简短的结尾问题，通常是：“那么，这一切的意义是什么？”我喜欢那个，这是一个很难回答的问题。

---

### [01:19:46] Lenny

**English:**
I'm so tempted to ask you, but-

**中文翻译:**
我很想问你，但是……

---

### [01:19:48] Gustav Söderström

**English:**
No, don't.

**中文翻译:**
别，千万别。

---

### [01:19:50] Lenny

**English:**
Okay. Let's move on. That'll be another ... That'll be our second take at this.

**中文翻译:**
好吧，我们继续。那留到下次……我们第二次录制时再说。

---

### [01:19:53] Gustav Söderström

**English:**
Yes.

**中文翻译:**
好的。

---

### [01:19:55] Lenny

**English:**
What are some favorite products you've recently discovered that you love?

**中文翻译:**
你最近发现了哪些让你爱不释手的产品？

---

### [01:19:58] Gustav Söderström

**English:**
The obvious one is ChatGPT GPT-4 and just playing around with that, trying to create bots for yourself that do different things for you and so forth. But I don't think that's probably true for everyone. The other really favorite is something you've written about and talked about, which is Duolingo, which I think is both very impressive from a product point of view, the execution and what they've done. It is also insanely used in my family. We have a family account and everyone is using it and competing every day. So I'm both impressed by the product and I also use the product quite a lot.

**中文翻译:**
显而易见的是 ChatGPT (GPT-4)，玩玩它，尝试为自己创建能做各种事情的机器人等等。但我猜这可能不是对每个人都适用。另一个非常喜欢的是你写过也聊过的 Duolingo（多邻国）。从产品角度看，它的执行力和所做的事情都令人印象深刻。而且我全家人都在疯狂使用它，我们有一个家庭账户，每个人每天都在用它竞争。所以我既对这个产品感到佩服，自己也经常使用。

---

### [01:20:35] Lenny

**English:**
What languages are folks learning within your family?

**中文翻译:**
你家里人都在学什么语言？

---

### [01:20:38] Gustav Söderström

**English:**
In my family, it's Spanish right now.

**中文翻译:**
我家里现在都在学西班牙语。

---

### [01:20:41] Lenny

**English:**
How's it going?

**中文翻译:**
学得怎么样？

---

### [01:20:41] Gustav Söderström

**English:**
Bien.

**中文翻译:**
Bien（很好）。

---

### [01:20:44] Lenny

**English:**
You get a gold star.

**中文翻译:**
给你一颗金星奖励。

---

### [01:20:47] Gustav Söderström

**English:**
I only have a few thousand XP. I'm not that good yet.

**中文翻译:**
我只有几千经验值（XP），还没那么厉害。

---

### [01:20:51] Lenny

**English:**
No, I don't know if that's good. That sounds pretty good. Next question, what's something relatively minor you've changed in your product development process that's had a tremendous impact on your team's ability to execute?

**中文翻译:**
不，我不知道那算不算好，听起来挺不错的。下一个问题：你在产品开发流程中做了哪些相对较小的改动，却对团队的执行能力产生了巨大影响？

---

### [01:21:01] Gustav Söderström

**English:**
I'm not sure I've done anything minor that had a tremendous impact. Usually, it takes something bigger to get a big impact. I think maybe one thing that I've tried to do back to clarity and so forth is this thing I mentioned about I'm trying to push a lot for what I call Socratic debate, where the idea is obviously that the best idea wins, not the most senior idea and so forth. And trying to push for this notion of having people explain themselves, not saying I think there's something there or have a feeling or something like that. And apparently, as you said, that has had some impact because people apparently say that about me. So that's probably the biggest thing.

**中文翻译:**
我不确定我是否做过什么“微小”却有巨大影响的事。通常需要大动作才能产生大影响。我想也许有一件事，回到清晰度那个话题，就是我一直在大力推行我所谓的“苏格拉底式辩论”。核心显然是让最好的想法胜出，而不是最资深的想法。我试图推动人们去“解释自己”，而不是说“我觉得那里有点东西”或“我有一种感觉”之类的话。显然，正如你所说，这产生了一些影响，因为大家显然是这么评价我的。所以这可能是最重要的一点。

---

### [01:21:53] Lenny

**English:**
Final question, what is one fun ritual of the Spotify product team, and is it saunas?

**中文翻译:**
最后一个问题：Spotify 产品团队有什么有趣的仪式吗？是洗桑拿吗？

---

### [01:21:59] Gustav Söderström

**English:**
So Spotify is so big now that it's quite local actually, different parts of Spotify, different product rituals. I accidentally created one ritual many years ago, maybe 12 years ago, when we talked about which phase a product is in. And it was ... We needed some definition. So I think off the cuff, I said, "Well, it's four phases." It's think it, build it, ship it, tweak it." And then the think it phase, it should be cheap, not a lot of money spent. In the build it phase, you're going to start spending a lot of money. So then you must have reduced the risk in the think it phase that you're right. And then you have the ship it phase and then you go over and tweak it. And it was something that wasn't that thought through, but it's funny because I still hear it sometimes even from other companies like, "Oh, we're in the think it phase," or "We're in the tweak it phase." So it stuck. I don't know if it's very good, but it's stuck.

**中文翻译:**
Spotify 现在太大了，所以仪式其实挺局部化的，不同部门有不同的产品仪式。我多年前（大概 12 年前）无意中创造了一个仪式，当时我们在讨论产品处于哪个阶段。我们需要一些定义，所以我随口说：“嗯，分为四个阶段：**想清楚（Think it）、做出来（Build it）、发出去（Ship it）、调优它（Tweak it）**。”在“想清楚”阶段，成本应该很低，不花什么钱；在“做出来”阶段，你开始投入大量资金，所以你必须在“想清楚”阶段降低了风险，确保你是对的；然后是“发出去”，接着是“调优”。当时并没深思熟虑，但很有趣，因为我现在有时甚至在其他公司也能听到：“噢，我们正处于‘想清楚’阶段，”或者“我们在‘调优’阶段。”所以它流传下来了。我不知道它好不好，但它确实深入人心。

---

### [01:22:57] Lenny

**English:**
It is catchy. I think anything getting stuck in people's head is a success. Gustav, thank you so much for being here. We are two for two for Swedish people. Gustaf, with an F, Alströmer was on the podcast.

**中文翻译:**
它朗朗上口。我认为任何能让人记住的东西都是成功的。Gustav，非常感谢你能来。我们已经连续采访了两位瑞典嘉宾了。之前 Gustaf Alströmer（名字带 F 的那个）也来过。

---

### [01:23:10] Gustav Söderström

**English:**
Who is also an amazing person.

**中文翻译:**
他也是个了不起的人。

---

### [01:23:12] Lenny

**English:**
Also an amazing person. I feel very jealous of people that get to work with you and for you. Thank you again for being here. Two final questions, where can folks find you online if they want to learn more, maybe reach out, ask some questions.

**中文翻译:**
确实。我很羡慕那些能和你一起工作或在你手下工作的人。再次感谢你的到来。最后两个问题：如果大家想了解更多，或者想联系你问问题，可以在哪里找到你？

---

### [01:23:23] Gustav Söderström

**English:**
[inaudible 01:23:23] @GustavS.

**中文翻译:**
（推特账号）@GustavS。

---

### [01:23:24] Lenny

**English:**
Okay. Say it again

**中文翻译:**
好的，请再说一遍。

---

### [01:23:28] Gustav Söderström

**English:**
@GustavS.

**中文翻译:**
@GustavS。

---

### [01:23:29] Lenny

**English:**
Awesome. And then final question is just how can listeners be useful to you?

**中文翻译:**
太棒了。最后一个问题：听众们能为你做些什么？

---

### [01:23:33] Gustav Söderström

**English:**
Just reach out. I do read feedback and I try to remove the angry comments and understand what they're actually thinking and why they're upset or what's not working.

**中文翻译:**
直接联系我就好。我会读反馈，并尝试过滤掉愤怒的言辞，去理解他们真实的思考、为什么不高兴，或者哪里出了问题。

---

### [01:23:44] Lenny

**English:**
And then the reaching out, would you recommend an angry tweet at you or more of a email to that email address you shared?

**中文翻译:**
关于联系方式，你推荐发一条愤怒的推文给你，还是发邮件到你分享的那个地址？

---

### [01:23:50] Gustav Söderström

**English:**
Well, the @GustavS is the Twitter handle, so just tweet at me.

**中文翻译:**
嗯，@GustavS 是我的 Twitter 账号，直接发推给我就行。

---

### [01:23:54] Lenny

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:23:56] Gustav Söderström

**English:**
You can be nice as well.

**中文翻译:**
当然，态度友好一点也行。

---

### [01:23:57] Lenny

**English:**
Okay.

**中文翻译:**
没问题。

---

### [01:23:57] Gustav Söderström

**English:**
It's okay.

**中文翻译:**
没关系的。

---

### [01:23:58] Lenny

**English:**
Amazing. Gustav, thank you so much for being here.

**中文翻译:**
太棒了。Gustav，非常感谢你能来。

---

### [01:24:01] Gustav Söderström

**English:**
Thank you for having me, Lenny. It's been a pleasure.

**中文翻译:**
谢谢邀请，Lenny。这是我的荣幸。

---

### [01:24:03] Lenny

**English:**
Bye, everyone.

**中文翻译:**
大家再见。

---

### [01:24:05] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcast、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期再见。