# Hamilton Helmer - 双语对照

# Lenny's Podcast: Hamilton Helmer (Bilingual Transcript)

---

### [00:00:00] Hamilton Helmer

**English:**
Warren Buffett famously said, in business.

**中文翻译:**
沃伦·巴菲特曾有一句名言，在商界中。

---

### [00:00:02] Audio

**English:**
I look for economic castles protected by unbreachable moats.

**中文翻译:**
我寻找的是那些由坚不可摧的护城河所保护的经济城堡。

---

### [00:00:04] Hamilton Helmer

**English:**
Power requires a benefit and a barrier, so he's taking care of the benefit part by saying a castle, you have to have a pretty good understanding of why it's a castle and not a shack.

**中文翻译:**
“力量”（Power）需要具备收益（Benefit）和壁垒（Barrier）。巴菲特提到“城堡”时，他实际上是在处理收益的部分。你必须非常清楚地理解，为什么它是一座城堡，而不是一间简陋的小木屋。

---

### [00:00:15] Lenny Rachitsky

**English:**
So in a lot of decks it's like, "Oh, we have the most amazing team. We move the fastest." You mention how rarely is that actually a power?

**中文翻译:**
在很多融资计划书中，人们常说：“哦，我们有最棒的团队，我们行动最快。”你提到过，这些东西其实很少能真正构成一种“力量”？

---

### [00:00:20] Hamilton Helmer

**English:**
You're on a treadmill and if you stop running on that treadmill, you get creamed, but it's not power. The things that drive operational excellence can be mimicked.

**中文翻译:**
你就像在跑步机上，如果你停止奔跑，你就会被甩出去，但这并不是“力量”。驱动运营卓越（Operational Excellence）的那些因素是可以被模仿的。

---

### [00:00:30] Lenny Rachitsky

**English:**
Let's actually talk about achieving these powers.

**中文翻译:**
那我们来聊聊如何获得这些“力量”。

---

### [00:00:32] Hamilton Helmer

**English:**
There's a thing called power progression. There are times when certain types of power are available. The path to power is where the rubber meets the road.

**中文翻译:**
有一种东西叫做“力量演进”（Power Progression）。在不同的阶段，某些特定类型的力量才是可获得的。通往力量之路才是真正见真章的地方。

---

### [00:00:44] Lenny Rachitsky

**English:**
Today my guest is Hamilton Helmer. Hamilton is a legend in the world of strategy. He's the author of 7 Powers, which outlines a framework for identifying and developing sustainable competitive advantage. It is widely considered to be the best book on strategy and people like Patrick Collison, Peter Thiel, Reed Hastings, Daniel Eck, and so many more leaders credit the book and Hamilton's teachings for helping them build durable lasting companies. In our conversation, Hamilton shares what sources of power startups can start developing early, which types of power companies often think they have but they don't, how power relates to strategy and moats, when to start thinking about power as a startup and also what individual product managers and non-leaders can do about these insights about power. Also, how Hamilton sees AI impacting various entry and the sources of power. He also gives a preview of his new book that he's working on currently and so much more.

**中文翻译:**
今天的嘉宾是汉密尔顿·赫尔默（Hamilton Helmer）。汉密尔顿是战略界的传奇人物。他是《7种力量》（7 Powers）一书的作者，该书概述了一个识别和开发可持续竞争优势的框架。它被广泛认为是关于战略的最佳著作，像帕特里克·科里森（Patrick Collison）、彼得·蒂尔（Peter Thiel）、里德·哈斯廷斯（Reed Hastings）、丹尼尔·埃克（Daniel Eck）等众多领导者都将建立持久公司的功劳归功于这本书和汉密尔顿的教导。在我们的对话中，汉密尔顿分享了初创公司可以早期开发的动力来源，哪些类型的力量是公司自以为拥有其实不然的，力量如何与战略和护城河相关联，初创公司何时该开始思考力量，以及个人产品经理和非领导者可以如何利用这些关于力量的见解。此外，汉密尔顿还谈到了他如何看待 AI 对准入门槛和力量来源的影响。他还预告了目前正在撰写的新书，以及更多精彩内容。

---

### [00:01:40] Lenny Rachitsky (Sponsor Segment)

**English:**
With that, I bring you Hamilton Helmer after a short word from our sponsors. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. This episode is brought to you by WorkOS. If you're building a SaaS app, at some point your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know like Vercel, Webflow and Loom. WorkOS also recently acquired Warrant, the fine-grained authorization service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube.

**中文翻译:**
在听完赞助商的简短介绍后，我将为您带来汉密尔顿·赫尔默的访谈。如果您喜欢本播客，请不要忘记在您最喜欢的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最佳方式，也对本播客有巨大帮助。本集节目由 WorkOS 为您呈现。如果您正在构建 SaaS 应用，迟早您的客户会开始要求企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让您快速且无痛地为应用添加企业功能。他们的 API 易于理解，让您可以快速交付并重新投入到其他功能的开发中。如今，数百家公司已由 WorkOS 提供支持，包括您可能熟悉的 Vercel、Webflow 和 Loom。WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于名为 Zanzibar 的开创性授权系统，该系统最初是为 Google 设计的，用于支持 Google Docs 和 YouTube。

---

### [00:02:42] Lenny Rachitsky (Sponsor Segment Continued)

**English:**
This enables fast authorization checks at enormous scale while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on, SCIM or user management, you should consider WorkOS. It's a drop-in replacement for Auth0 and supports up to 1 million monthly active users for free. Check it out at WorkOS.com to learn more. That's WorkOS.com.

**中文翻译:**
这使得在大规模环境下进行快速授权检查成为可能，同时保持了能够适应最复杂用例的灵活模型。如果您目前正寻求构建基于角色的访问控制或其他企业功能（如单点登录、SCIM 或用户管理），您应该考虑 WorkOS。它是 Auth0 的即插即用替代方案，并免费支持多达 100 万月活跃用户。访问 WorkOS.com 了解更多信息。

---

### [00:03:13] Lenny Rachitsky (Sponsor Segment Continued)

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast. Now you can assess risk, secure the trust of your customers and automate compliance for SOC 2, ISO 27001, HIPAA and more with a single platform Vanta. Vanta's market-leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risks. Plus you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to vanta.com/Lenny. That's Vanta.com/Lenny. Hamilton Helmer, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
本集节目由 Vanta 为您呈现。在确保公司拥有顶尖安全实践方面，事情很快就会变得复杂。现在，您可以通过 Vanta 这一个平台来评估风险、赢得客户信任，并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助您持续监控合规情况，同时报告和跟踪风险。此外，您还可以通过 Vanta AI 完成安全问卷，从而节省数小时的时间。加入全球数千家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的公司行列。访问 vanta.com/Lenny 即可享受 1,000 美元的折扣。汉密尔顿·赫尔默，非常感谢你能来到这里。欢迎来到本播客。

---

### [00:04:12] Hamilton Helmer

**English:**
Hi Lenny, a pleasure to be here.

**中文翻译:**
你好 Lenny，很高兴来到这里。

---

### [00:04:14] Lenny Rachitsky

**English:**
It's even more my pleasure. I want to start by talking about when power becomes important. When do you recommend founders start thinking about power in terms of pre-product market fit, post-product market fit? Is it worth spending time thinking about power early? Obviously it's good to think about a little bit, but how much and how seriously should founders be thinking about it before they found something that people actually want?

**中文翻译:**
这是我的荣幸。我想先从“力量”何时变得重要谈起。你建议创始人什么时候开始思考“力量”？是在产品与市场匹配（PMF）之前，还是之后？早期花时间思考“力量”值得吗？显然，思考一下是有好处的，但在找到人们真正想要的东西之前，创始人应该投入多少精力、多认真地去思考它？

---

### [00:04:38] Hamilton Helmer

**English:**
One of the things that has really surprised me in the last five years has been that my understanding of the answer to that question has changed. And before I thought it was you do product market fit and then you do strategy, and if you try and put strategy before product market fit, it is not much you can do with it. That's wrong. Actually, I mentioned before one of the great pleasures for me in my work is being able to talk to company founders and one of the things that has surprised me is that conversations with them, even at an early stage about strategic matters have a richness and relevance to me that was unexpected.

**中文翻译:**
在过去的五年里，有一件事让我非常惊讶，那就是我对这个问题的理解发生了变化。以前我认为，你应该先做产品与市场匹配（PMF），然后再做战略；如果你试图把战略放在 PMF 之前，那你也做不了什么。但那是错的。实际上，我之前提到过，我工作中最大的乐趣之一就是能与公司创始人交谈，让我惊讶的是，即使在早期阶段，与他们讨论战略问题对我来说也具有意想不到的丰富性和相关性。

---

### [00:05:41] Hamilton Helmer

**English:**
And founders are practical people. I mean it's very hard to do what they're doing and they have to be extremely focused and choose what's worthwhile spending time on. And so in observing their reactions and that dialogue, I could see that there was something going on that was meaningful to them. And this second book we're working on, we'll tease out why that's so more, but the answer to your question is when should you thinking about this? The answer is always. And that's an odd answer. And so even before you have product-market fit, it's worth thinking about strategy. Now it's not strategy in the sense of this fully articulated strategic planning, we're going to do this, these are going to be the competitors, this is how we're going to answer them. This is how we'll price. Not like that at all. At the earlier stage, you can imagine wildly more degrees of freedom and the questions are of the business propositions that you're thinking of in trying to get to product-market fit, what are the underlying characteristics that might tilt them towards the availability of power or not?

**中文翻译:**
创始人都是务实的人。我是说，做他们正在做的事情非常困难，他们必须极其专注，并选择值得花时间的事情。因此，通过观察他们的反应和对话，我能感觉到有些东西对他们来说是有意义的。我们正在写的第二本书会进一步探讨其中的原因。但回到你的问题：什么时候该考虑这个？答案是：永远。这是一个奇怪的答案。所以，甚至在获得 PMF 之前，战略就值得思考。当然，这指的不是那种完全成型的战略规划——比如我们要怎么做、竞争对手是谁、如何应对、如何定价。完全不是那样。在早期阶段，你可以想象拥有大得多的自由度，问题在于：在你为了达到 PMF 而构思的业务主张中，哪些潜在特征可能会让你倾向于获得“力量”，或者不能？

---

### [00:07:10] Hamilton Helmer

**English:**
And those actually are meaningful conversations and certainly by no means certain. You're tilting probabilities, you're not creating a determinative things. And then later on, once you've already have product-market fit, then you have to understand your source of power to understand what competitive position is because then you have to establish that. And then later on in a more stable phase when you're in a stability phase of business, you have to know what your source of power is if you have one, because you have to know how to defend it. And then also it is also the foundational knowledge that you need for if there's another step. Because another thing that's quite surprising about iconic businesses is they often have a second act or a third act or fourth act. I mean think of AWS or Intel going into CPUs or Apple going into iPhones, all not the origin of business. And that's actually common, not unusual, and that's starting the process all over again.

**中文翻译:**
这些对话实际上非常有意义，当然，结果绝非确定。你是在倾斜概率，而不是在创造确定的事物。随后，一旦你获得了 PMF，你就必须了解你的力量来源，以理解你的竞争地位，因为那时你必须确立这种地位。再往后，当业务进入更稳定的阶段时，如果你拥有力量来源，你必须知道它是什么，因为你必须知道如何捍卫它。此外，这也是如果你想迈出下一步所需的基石知识。因为标志性企业的一个令人惊讶的特点是，它们通常有“第二幕”、“第三幕”甚至“第四幕”。想想 AWS，或者英特尔进入 CPU 领域，或者苹果推出 iPhone，这些都不是业务的起点。这其实很常见，并不罕见，而那意味着整个过程又要重新开始。

---

### [00:08:24] Lenny Rachitsky

**English:**
Awesome. You mentioned this word strategy. I want to set a little foundation here. How does strategy relate to power when people are thinking about these two concepts? And then do you have just a nice definition of what strategy is? Everyone's always just like, "What the heck do you mean when you're talking about the strategy?"

**中文翻译:**
太棒了。你提到了“战略”这个词。我想在这里打个基础。当人们思考这两个概念时，战略与“力量”之间是什么关系？另外，你能不能给战略下一个简洁的定义？每个人总是在问：“当你谈论战略时，你到底在指什么？”

---

### [00:08:41] Hamilton Helmer

**English:**
As I said, I'm a concept person and so when you develop concepts, you have to be very highly constrained by their usefulness. I'm a great fan of the great mathematician, John von Neumann, and he had a view which really irritated a lot of mathematicians, which is that if mathematics wasn't guided by what was useful, it would become, I think the word he used was aesthetic to aesthetic. And so any concept developments like that, it needs to be guided by usefulness. And so in dealing with strategy, the question is what domain of things do you want to include in that conversation? Because the term is ubiquitous in business. I mean do a Google search sometime. I've done one recently on Google Scholar for the word strategy and you'll get a million, I'm not exaggerating, a million hits. And so strategy for some people might mean everything that gets to the pile, it gets to the top of a pile in terms of what you have to do that year.

**中文翻译:**
正如我所说，我是一个注重概念的人，所以当你开发概念时，你必须受到其“有用性”的高度约束。我是伟大数学家约翰·冯·诺依曼（John von Neumann）的忠实粉丝，他有一个观点让很多数学家感到恼火，那就是如果数学不以有用性为指导，它就会变得——我想他用的词是——“过于审美化”。因此，任何类似的概念开发都需要以有用性为导向。在处理战略时，问题在于：你想在对话中包含哪些领域的东西？因为这个词在商业中无处不在。你可以去谷歌搜索一下，我最近在 Google 学术搜索上搜了“战略”这个词，你会得到一百万个结果，我没夸张，是一百万个。所以对某些人来说，战略可能意味着那一年你必须做的所有重要事情。

---

### [00:09:58] Hamilton Helmer

**English:**
Everything is... And that's a perfectly legitimate definition, but what I have found is that there is a very important narrowing that makes it much more useful. So that's coming back to what I was saying [inaudible 00:10:17] makes it much more useful to the business. So my view is that you want to focus, it's very useful for a business to focus on the fundamental determinants of business value and that's an arbitrary choice. It could be something else, but I can tell you from decades of business experience that that narrowing is very useful. And then so once you make that... Once you reach that understanding, it tells you some important things. So if you understand what drives business value, I mean if you do the math of it right, it's NPV of cash flow, right? Expected cash flow. And what that tells you is that strategy is a long time concept. You're looking far out in the future.

**中文翻译:**
所有事情都是……这当然是一个完全合理的定义，但我发现，进行一种非常重要的“收窄”会使其变得更有用。这又回到了我刚才说的，这会让它对业务更有帮助。我的观点是，企业专注于“业务价值的根本决定因素”是非常有用的，虽然这是一个主观的选择，也可以是别的，但根据我几十年的商业经验，这种收窄非常有效。一旦你达成了这种理解，它就会告诉你一些重要的事情。如果你理解了驱动业务价值的因素——如果计算正确的话，就是现金流的净现值（NPV），对吧？预期的现金流。这告诉我们，战略是一个长期概念。你是在展望遥远的未来。

---

### [00:11:10] Hamilton Helmer

**English:**
So think of Pearl Harbor, Pearl Harbor for the Japanese was this enormous tactical success. They just destroyed the US ability, naval ability in the Pacific Ocean and the worst possible strategic move because it completely solved Franklin Delano Roosevelt's problem of how he could get the US citizens on board to attacking Hitler. The strategy of it was US's industrial might would eventually win the war and population. And the difference there is time constant, tactical short, strategy long. And so if you focus on value that narrows what you think about and allows you to get rather concise and offer up advice to founders about what they need to pay attention to.

**中文翻译:**
想想珍珠港事件。对日本人来说，珍珠港是一次巨大的战术成功。他们摧毁了美国在太平洋的海军能力，但这也是最糟糕的战略举措，因为它彻底解决了富兰克林·德拉诺·罗斯福如何让美国公民支持进攻希特勒的难题。从战略上看，美国的工业实力和人口最终将赢得战争。这里的区别在于时间常数：战术是短期的，战略是长期的。因此，如果你专注于价值，这会收窄你的思考范围，让你变得简洁，并能就创始人需要关注的事情提供建议。

---

### [00:12:09] Lenny Rachitsky

**English:**
So then how specifically is power informing strategies? Like the way you think about it, focus on your power and that will inform your strategy?

**中文翻译:**
那么，“力量”具体是如何影响战略的呢？按照你的思路，是专注于你的“力量”，然后这会反过来指导你的战略吗？

---

### [00:12:17] Hamilton Helmer

**English:**
Earlier I talked about these economic structures that provide durability of return in terms of refuge from withering arbitrage of everybody who wants to eat your lunch. And so that's what power is. So you have to understand what is an economics? You're asking me questions that get pretty deep into theory or I hope you don't, this is too conceptual. But you have to say, you have to understand how competition takes place and say what is it that creates some kind of refuge? And what it is is there's something in what you do that gives you either a cost or price advantage over others. So let's say you're lower cost and that's the benefit. And the barrier side is that there's something that is durable about that that makes it over time that you can't, the competitors can't take away from you. So benefit and a barrier, we call it the to be or not to be test. And if you have that, you can think of that immediately translating into a value because that will give you good margins out into the foreseeable future, which is what you're after.

**中文翻译:**
早些时候我谈到了这些经济结构，它们提供了回报的持久性，让你免受那些想抢你饭碗的人的“萎缩性套利”。这就是“力量”。所以你必须理解什么是经济学？你问的问题涉及很深的理论，我希望不会太抽象。但你必须理解竞争是如何发生的，并思考：是什么创造了某种“避风港”？答案是：在你所做的事情中，有一些东西让你比别人拥有成本或价格优势。假设你成本更低，这就是“收益”。而“壁垒”方面则是，这种优势具有持久性，随着时间的推移，竞争对手无法将其夺走。收益加壁垒，我们称之为“生存或毁灭测试”（to be or not to be test）。如果你拥有这些，你可以认为它会立即转化为价值，因为它会在可预见的未来为你提供良好的利润率，而这正是你所追求的。

---

### [00:13:44] Hamilton Helmer

**English:**
I don't know if that's... We're getting into the weeds here, but that's what it's about. And so power is those structures. Let me give you a quick example. So one I use in the book. So Netflix with scale economies, they have more subscribers. The cost of their content is a very large fixed cost, about 50% of their cost structure every year. They can take that fixed cost and spread it over more subscribers so their cost per subscriber is less versus somebody with fewer subscribers. So if they face the same prices for subscriptions as their competitors, they will be more profitable. And that's a scale economy and that's an example of a type of power and a common one I'd say. But these things are hard to achieve, right? Because there's the holy grail.

**中文翻译:**
我不知道这是否……我们有点深入细节了，但核心就是这些。所以“力量”就是那些结构。让我给你举个简单的例子，也是我在书里用过的。Netflix 拥有规模经济（Scale Economies），他们有更多的订阅用户。他们的内容成本是一项巨大的固定成本，每年约占其成本结构的 50%。他们可以将这项固定成本分摊到更多的订阅用户身上，因此他们每个用户的成本比用户较少的竞争对手要低。如果他们面临与竞争对手相同的订阅价格，他们就会更有利可图。这就是规模经济，是“力量”的一种类型，也是很常见的一种。但这些东西很难实现，对吧？因为那是终极目标。

---

### [00:14:47] Lenny Rachitsky

**English:**
So let's actually talk about achieving these powers. Essentially the argument here is your power informs everything you do because this is the thing that'll allow you to stay durable and competitive and last. There's seven powers. We're not going to talk about all of them. If you want to go understand each of them, go read the book.

**中文翻译:**
那我们来谈谈如何获得这些力量。本质上，这里的论点是：你的“力量”决定了你所做的一切，因为这是让你保持持久、竞争力和长盛不衰的关键。一共有七种力量。我们不会一一讨论。如果听众想了解每一种，可以去读那本书。

---

### [00:15:07] Hamilton Helmer

**English:**
Yeah. Let's not. That conversation always goes too long.

**中文翻译:**
是的，别全讲。那个话题总是会聊太久。

---

### [00:15:08] Lenny Rachitsky

**English:**
Yeah, exactly. So what I'm wondering is, okay, so say you're looking at this list of seven powers and you're a specific type of startup, do you have a heuristic that tells you here's most likely the power and set of subsets that will most likely be an option for you? Like B2B SaaS companies, is there a smaller subset? Probably one of these has to be one of your options versus B2C.

**中文翻译:**
没错。所以我想知道的是，假设你看着这七种力量的清单，而你是一家特定类型的初创公司，你有没有一种启发式的方法可以告诉创始人：这里最可能是你的力量来源，或者哪一组子集最可能成为你的选择？比如 B2B SaaS 公司，是否有一个更小的子集？其中一个很可能是你的必选项，而 B2C 则不同。

---

### [00:15:32] Hamilton Helmer

**English:**
That's a great question Lenny, because I think the path to power is where the rubber meets the road and it's very complicated and nuanced. But I'll give you a few thoughts along it and frankly our next book, the Second Invention, that's what it's about. It's about power, the entire book.

**中文翻译:**
这是一个非常棒的问题，Lenny。因为我认为通往力量的路径才是真正实战的地方，它非常复杂且微妙。但我可以给你一些思路。坦白说，我们的下一本书《第二次发明》（The Second Invention）讲的就是这个。整本书都在讨论如何获得力量。

---

### [00:15:56] Lenny Rachitsky

**English:**
[Inaudible 00:15:56] I'll try to read it.

**中文翻译:**
（听不清）我会去读的。

---

### [00:15:58] Hamilton Helmer

**English:**
So in a book there's a thing called power progression, which says there are... It tells over the cycle of a business, there are times when certain types of power are available and the converse of that is times when they're not available. And so there's some that only are really available in when you reach a stability phase of a business pretty far out there.

**中文翻译:**
在书中有一个概念叫“力量演进”，它说明在企业的生命周期中，某些类型的力量在特定时期是可获得的，反之，在某些时期则是不可获得的。因此，有些力量只有当你达到业务的稳定阶段（通常是很后期）时才真正可用。

---

### [00:16:25] Hamilton Helmer

**English:**
And so if you're starting a company, take those off the table. So those two are branding and process power. So often I find that there's a confusion about this because brand recognition for a startup may be incredibly important, but you can get brand recognition by buying an ad in the Super Bowl. That's not power, that you paid for it. So take branding and process power and process power is really operational excellence on steroids and usually is imitable, so it's usually not.

**中文翻译:**
所以，如果你正在创办一家公司，先把这些排除掉。这两者就是“品牌”（Branding）和“流程力量”（Process Power）。我经常发现人们对此感到困惑，因为对于初创公司来说，品牌知名度可能极其重要，但你可以通过在超级碗买广告来获得知名度。那不是“力量”，那是你花钱买来的。所以排除品牌和流程力量。流程力量实际上是加强版的运营卓越，通常是可以模仿的，所以它通常不构成力量。

---

### [00:17:05] Hamilton Helmer

**English:**
So take those off the table and then a resource type of power, which is you have something that is of value that if you transferred it to somebody else it would be of value to them, but you own the rights. So the barrier is law for example, or lack of knowledge from others. And there are classes of businesses that are like that. So prescription pharmaceuticals, if you are the first person to come up with Viagra, that's worth a lot of money. If you took that license and gave it to somebody else, it'd be worth a lot of money to them. But that's a different class and it's usually not the types of things that I'm dealing with and it's obvious to everybody. So the key challenge there is can you invent a pharmaceutical that's effective for a large market. So you can take those three off the table and that then leaves counter positioning, scale economies, switching costs and network economies.

**中文翻译:**
排除掉这些，然后还有一种“资源型力量”，即你拥有某种有价值的东西，如果你把它转让给别人，对他们也有价值，但你拥有所有权。这里的壁垒可能是法律（如专利），或者是他人的知识匮乏。有些行业就是这样的，比如处方药。如果你是第一个发明万艾可（Viagra）的人，那非常值钱。如果你把那个许可给别人，对他们也很有价值。但这属于不同的类别，通常不是我处理的那种类型，而且这对每个人来说都很显而易见。那里的关键挑战是：你能不能发明出一种对大市场有效的药物。所以你可以把这三种排除掉，剩下的就是：反向定位（Counter-positioning）、规模经济、切换成本和网络经济。

---

### [00:18:13] Hamilton Helmer

**English:**
And the important thing to keep in mind there is that they're sequenced. So almost every startup that you want to deal with starts with counter positioning because remember what product market fit is primarily is a substitution. You are coming up with a way to satisfy a more or less existing need in a novel way that creates more value. Now sometimes you tap into entirely new needs, but it's not so often. I mean Amazon was up against brick and mortar stores, Google was up against Yahoo and so on, and so you're usually substituting and that substitution, so your competition at that point is functional competition.

**中文翻译:**
这里需要记住的重要一点是，它们是有先后顺序的。几乎每一家初创公司都是从“反向定位”开始的。因为请记住，产品与市场匹配（PMF）本质上是一种“替代”。你正在用一种创造更多价值的新颖方式，去满足一个或多或少已经存在的需求。虽然有时你会挖掘出全新的需求，但并不常见。亚马逊挑战的是实体店，谷歌挑战的是雅虎等等。所以你通常是在做替代，而那个阶段的竞争是功能性竞争。

---

### [00:19:19] Hamilton Helmer

**English:**
And if you don't have counter positioning at that point you're pretty high risk from an incumbent who already has the capabilities necessary to do that. They just have to extend their product or do this or that, but counter positioning is the refuge from that. And then you go into the other three types of power scale economies, switching costs and network economies, and those depend on your scale relative to competitors. This is pretty cursory, but that's what I'd say. I'll focus on those four and I would recommend that you think pretty hard about whether you think you have counter positioning to start.

**中文翻译:**
如果你在那时没有“反向定位”，那么面对已经具备必要能力的现任巨头，你的风险会非常高。他们只需要扩展一下产品，或者做点这个做点那个就能打败你。而反向定位就是避开这种风险的避风港。接着，你会进入另外三种力量：规模经济、切换成本和网络经济，这些取决于你相对于竞争对手的规模。这说得比较简略，但我会建议关注这四种，并强烈建议你认真思考：在开始时，你是否拥有“反向定位”。

---

### [00:20:08] Lenny Rachitsky

**English:**
Awesome. I actually want to double down on that thread, but just to summarize, I have the list here. Basically you're saying if you're an early stage startup, the four to really that are actually potential powers for you at least early on, counter positioning, which your point is you could just start with that. That's essentially positioning and business model design, which happens at the beginning and then you can start to think about network economy, scale economy, switching costs as powers.

**中文翻译:**
太棒了。我想深入探讨一下。总结一下，我这里有一份清单。你基本上是说，如果你是一家早期初创公司，至少在早期，真正具有潜在力量的四种是：反向定位（你的观点是你可以直接从这个开始，这本质上是定位和商业模式设计，发生在初期），然后你可以开始考虑网络经济、规模经济和切换成本作为后续的力量。

---

### [00:20:33] Hamilton Helmer

**English:**
Right. And you've done the right thing by not having me go through and define each of those. But your listeners will need to go back to my book and see what those things are to get... We're going through the shorthand as we should, but all of what we've said won't be completely obvious to them.

**中文翻译:**
没错。你没让我逐一解释这些定义，这做得很对。但你的听众可能需要回头去读我的书，看看这些到底是什么……我们现在用的是简略表达，这对我们来说很自然，但对他们来说可能并不完全显而易见。

---

### [00:20:54] Lenny Rachitsky

**English:**
Yeah, I think a simple Google search I find just gives you a very simple definition of these.

**中文翻译:**
是的，我觉得简单的谷歌搜索就能给出一个非常简单的定义。

---

### [00:20:58] Hamilton Helmer

**English:**
Yeah, that's right. There's some people who have done some really good summaries of this.

**中文翻译:**
没错，有些人对这些做了非常好的总结。

---

### [00:21:02] Lenny Rachitsky

**English:**
Or ChatGPT, even better in a lot of cases.

**中文翻译:**
或者用 ChatGPT，在很多情况下甚至更好。

---

### [00:21:05] Hamilton Helmer

**English:**
ChatGPT if they get it right sometimes I find they hallucinate.

**中文翻译:**
如果 ChatGPT 说对了的话。有时我发现它们会产生幻觉。

---

### [00:21:12] Lenny Rachitsky

**English:**
Hallucinate an eighth power. You mentioned how some companies think they have a certain power or it's common to think you have a certain power. If you look at every startup deck, there's always like, "Here's our moat, here's the way we're going to have barriers to entry." I'm guessing in almost every case they're delusional about the power that they actually have and the power they think they'll have. Do you also find that to be true that often founders are wrong about how much barrier they've actually created and is there a power you often find most wrong and mistaken?

**中文翻译:**
幻觉出第八种力量（笑）。你提到有些公司自以为拥有某种力量，或者这种想法很普遍。如果你看每一份初创公司的计划书，总会有类似“这是我们的护城河，这是我们的准入门槛”的内容。我猜在几乎所有情况下，他们对于自己实际拥有的力量以及认为将拥有的力量都抱有幻想。你是否也发现，创始人经常误判了他们实际建立的壁垒？有没有哪种力量是你发现最容易被误解或误用的？

---

### [00:21:43] Hamilton Helmer

**English:**
Yeah, so I agree with your observation, but I don't want to be unkind. So I mean there are two things to keep in mind here in terms of making people feel better about that incorrect slide in the deck. One is that founders have to be optimistic. I think it's an important quality that they maybe understate the risk a little bit, but they're so committed to I'm going to do this thing that they go through that and that may give them an advantage over a large corporation trying to do the same thing. The other is that despite the name 7 Powers, which makes it sound like, oh, you can sort this out. Actually understanding whether or not there is a type of power in place is hard. I mean I did it with my colleagues here at Strategy Capital and we're looking at a well-known company, it might take us weeks to answer that question for a single company.

**中文翻译:**
是的，我同意你的观察，但我不想显得太刻薄。为了让那些在计划书里写错幻灯片的人心里好受点，有两点需要记住。第一，创始人必须乐观。我认为这是一种重要的品质，他们可能会稍微低估风险，但他们如此致力于“我要做成这件事”，以至于勇往直前，这可能让他们在面对试图做同样事情的大公司时拥有优势。第二，尽管书名叫《7种力量》，听起来好像你一眼就能看穿，但实际上要判断某种力量是否真正存在是非常困难的。我和 Strategy Capital 的同事们在研究一家知名公司时，可能需要几周时间才能回答关于这一家公司的力量问题。

---

### [00:22:47] Hamilton Helmer

**English:**
And it comes down to the hard part is industry economics is what really are the economic relationships and it's very hard. So with those caveats that... Give them some courtesy, I'll say some of the obvious ones are I mentioned before, people sometimes think they have branding power, but another one that I think I've heard you mention is people often think that they get scale economies through data. And I'd say that that's possible, but it's rare. And the reason it's rare is not because there aren't scale economies in data, but rather that the range of scale that the existing competitors have are often large enough to be able to put them in shouting distance of each so that the differences in their cost per unit is not that great.

**中文翻译:**
最难的部分在于行业经济学——即真正的经济关系是什么，这非常困难。在这些前提下，出于礼貌，我会说一些明显的误区。我之前提到过，人们有时觉得自己有品牌力量。另一个我听你提到过的误区是，人们经常认为他们可以通过数据获得规模经济。我想说，这确实有可能，但很罕见。罕见的原因不是因为数据没有规模经济，而是因为现有竞争对手的规模通常已经足够大，彼此之间的差距在伯仲之间，导致单位成本的差异并没有那么显著。

---

### [00:23:50] Hamilton Helmer

**English:**
The curve flattens in other words, which is typical of any, because the most common scale economy is you've got a big fixed cost and you prorate that. And as you get more and more scale, the percentage cost advantage of a fixed cost advantage like that goes down and that often. So that's a pretty frequent one that we see. We laugh whenever we hear somebody say they have a flywheel, which gives you the idea of network economies. There are often flywheels, the ones that really are material, are rare. The key thing here is materiality, not whether the flywheel exists, but whether the effect is strong enough to really tilt returns.

**中文翻译:**
换句话说，曲线变平缓了。这在任何规模经济中都很典型，因为最常见的规模经济是你有一笔巨大的固定成本并进行分摊。随着规模越来越大，这种固定成本优势带来的成本优势百分比就会下降。这是我们经常见到的情况。每当我们听到有人说他们有一个“飞轮”（Flywheel）时，我们都会笑，因为这通常暗示着网络经济。飞轮确实经常存在，但真正具有“实质性”（Material）的却很少。这里的关键在于实质性，不在于飞轮是否存在，而在于其效果是否强大到足以真正改变回报率。

---

### [00:24:39] Lenny Rachitsky

**English:**
I was actually going to ask about that one because in software and social consumer products, network effects is always the pitch. Once we get big enough, we create this huge barrier. You mentioned just now you often find that's not actually true. It's rarely something that'll become a barrier. Is there anything else you find with network? And I know your power is called network economies, not network effect. I guess just to be clear, are these the same thing in your mind with different words?

**中文翻译:**
我正想问这个，因为在软件和社交消费产品中，“网络效应”总是核心卖点。一旦我们规模够大，我们就能建立巨大的壁垒。你刚才提到，你经常发现这其实并不成立，它很少能真正成为壁垒。关于网络，你还有什么发现吗？我知道你的力量叫“网络经济”，而不是“网络效应”。我想明确一下，在你心中，这两个词是同一回事吗？

---

### [00:25:02] Hamilton Helmer

**English:**
Yeah, kind of. I mean I have called it a type of power. So for me it's only those things which clear the significance barrier, hurdle rather that they're a large material. And so there are lots of things that I would say have network effects but not network economies.

**中文翻译:**
是的，差不多。我把它称为一种“力量”。对我来说，只有那些跨过了“显著性门槛”的事物才算数，也就是说它们必须具有巨大的实质性影响。因此，有很多东西我会说它们具有网络效应，但并不具备网络经济。

---

### [00:25:26] Lenny Rachitsky

**English:**
Oh, interesting. Wait, can you speak to that? So there is a difference between these terms, network economies?

**中文翻译:**
哦，有趣。等等，你能详细说说吗？所以这两个术语之间是有区别的，网络经济？

---

### [00:25:30] Hamilton Helmer

**English:**
Yeah. So for me the difference is materiality is that whether the value benefit is large enough to engender a price delta significant enough to give you materially different margins into the future.

**中文翻译:**
是的。对我来说，区别在于“实质性”——即价值收益是否大到足以产生显著的价格差，从而在未来为你带来实质上不同的利润率。

---

### [00:25:50] Lenny Rachitsky

**English:**
Basically, does that network effect have an actual impact on your business and your ability to price?

**中文翻译:**
基本上就是，这种网络效应是否对你的业务和定价能力产生了实际影响？

---

### [00:25:55] Hamilton Helmer

**English:**
Yeah, it's not an impact, it's a material impact. So it could have... If it's a penny to your bottom line, that's one thing if it's a billion dollars or something else.

**中文翻译:**
是的，不是普通的影响，而是实质性的影响。如果它只给你的净利润增加了一分钱，那是一回事；如果是十亿美元，那就是另一回事了。

---

### [00:26:06] Lenny Rachitsky

**English:**
Wow, that's actually really interesting. Is there an example of a company that comes to mind, they had network effects but not network economies as a power?

**中文翻译:**
哇，这真的很有趣。你能想到哪个例子，某家公司拥有网络效应，但并没有将其转化为“网络经济”这种力量？

---

### [00:26:12] Hamilton Helmer

**English:**
I think you could turn almost anywhere and get some modest network effects and any platform business would probably likely have some modest network effects. You asked me earlier and you sent me about Uber and Lyft, I'd say that they probably have network effects involved but not network economies.

**中文翻译:**
我觉得你几乎随处都能看到一些微弱的网络效应，任何平台业务可能都有一些微弱的网络效应。你之前问过我关于 Uber 和 Lyft 的事，我会说它们可能涉及网络效应，但并不具备网络经济。

---

### [00:26:40] Lenny Rachitsky

**English:**
Wow, that's interesting. And the reason you're saying they don't have network economies is because they're still so competitive they still have to spend so much money to stay ahead and so the network is not-

**中文翻译:**
哇，这很有趣。你之所以说它们没有网络经济，是因为它们仍然竞争如此激烈，必须投入大量资金才能保持领先，所以网络并没有——

---

### [00:26:51] Hamilton Helmer

**English:**
Yeah. Right. The advantage that they get, it's not material. Right.

**中文翻译:**
是的，没错。它们获得的优势并不具有实质性。

---

### [00:26:59] Lenny Rachitsky

**English:**
Wow, that's so interesting. Along those lines, it's so interesting to see Uber and Lyft these days. In theory they both had some sort of strong network effect. I was just looking, so Lyft is 5% the market cap of Uber. Is there a lesson from just what it is that allowed Uber to just win and kind of run away with the market essentially?

**中文翻译:**
哇，太有意思了。说到这，看现在的 Uber 和 Lyft 很有趣。理论上它们都有某种强大的网络效应。我刚才看了一下，Lyft 的市值只有 Uber 的 5%。Uber 究竟凭什么赢了，并且基本上甩开了对手，这其中有什么教训吗？

---

### [00:27:25] Hamilton Helmer

**English:**
I'm not entirely sure, I'll take a guess, but take it as a unformed guess. I haven't really studied it carefully. I think that over time there, if I had to guess, I'd say they're probably modest scale economies in the business. And over time Uber has just very successfully played a war of attrition. And that's both been in how they run their... They made one initial misstep, which is they misdefined their business. They said it was international transportation and it's not. That business is extremely geographically specific.

**中文翻译:**
我不太确定，我猜一下，但这只是个不成熟的猜测，我还没仔细研究过。如果非要猜的话，我认为随着时间的推移，这个业务中可能存在微弱的规模经济。而 Uber 非常成功地打了一场持久的消耗战。这体现在他们的运营方式上……他们最初犯了一个错误，即错误地定义了业务。他们曾认为这是国际运输业务，但其实不是。这种业务具有极强的地理特殊性。

---

### [00:28:14] Hamilton Helmer

**English:**
If you have a great position in the Bay Area, it doesn't help you in London. And so their forays into China and everything really didn't make, but they pulled back on that, focused down on understanding their source of power, which was a geographically specific scale economy. And then they've done interesting things like Uber Eats where they've tried to utilize the platform that they have to get other opportunities for the one side of their platform, the drivers. And so if I had to guess, I'd say it was a well-played war of attrition with modest scale economies.

**中文翻译:**
如果你在湾区拥有绝佳地位，这对你在伦敦的业务毫无帮助。所以他们进军中国等地的尝试并没有成功，但他们及时收手，专注于理解他们的力量来源，即特定地理区域的规模经济。然后他们做了像 Uber Eats 这样有趣的事情，试图利用现有平台为平台的一侧（司机）创造其他机会。所以如果让我猜，我会说这是一场打得很漂亮的消耗战，并伴随着微弱的规模经济。

---

### [00:29:02] Lenny Rachitsky

**English:**
And is that attrition coming from a source of power or is that just like a broader, more strict?

**中文翻译:**
那种消耗战是源于某种力量，还是仅仅是一种更广泛、更严苛的策略？

---

### [00:29:06] Hamilton Helmer

**English:**
Yeah, it only works because there are modest scale economies. If there weren't any then if they did all this stuff, they'd still have a global and see.

**中文翻译:**
是的，它之所以奏效是因为存在微弱的规模经济。如果没有规模经济，即使他们做了所有这些努力，依然无法形成现在的局面。

---

### [00:29:16] Lenny Rachitsky

**English:**
Got it. Let me go in a slightly different direction. We've talked about power, we've talked about strategy. There's also, there's this word moat that comes up a lot. Everyone's always trying to build a moat. In your mind, is a moat equivalent to a power? Is there a difference when people talk about these two?

**中文翻译:**
明白了。让我们换个方向。我们谈到了力量，谈到了战略。还有一个词经常出现，那就是“护城河”（Moat）。每个人都在努力建立护城河。在你看来，护城河等同于力量吗？当人们谈论这两者时，有什么区别吗？

---

### [00:29:30] Hamilton Helmer

**English:**
Power requires a benefit and a barrier, you have to have something that you do that gives you a better outcome than your competitors, lower cost or higher price, and then something that makes it impossible for somebody else to mimic that. So moat is the second. So it's not synonymous with power because you can have a moat around a very undesirable piece of property and wouldn't get you far. But I think it is pretty synonymous with barrier. I think Warren Buffett, Charlie Munger, I admire enormously. I think I get credit for popularizing those concepts and I think the way they think about it is good. I'd say that 7 Powers is probably more systematic and comprehensive in saying that. I don't think. This is wonderful. I don't know if you've read any of the Microsoft antitrust literature that came out of their-

**中文翻译:**
力量需要收益和壁垒。你必须做一些事情，让你获得比竞争对手更好的结果（更低的成本或更高的价格），然后还要有一些东西让别人无法模仿。所以“护城河”指的是后者（壁垒）。它与力量不是同义词，因为你可以在一块毫无价值的土地周围挖护城河，那没什么用。但我认为它与“壁垒”基本是同义的。我非常钦佩沃伦·巴菲特和查理·芒格。我认为我在普及这些概念方面有一点功劳，我觉得他们的思考方式很好。我会说《7种力量》在论述上可能更系统、更全面。这很有意思，我不知道你有没有读过微软反垄断案的一些文献——

---

### [00:30:42] Lenny Rachitsky

**English:**
No.

**中文翻译:**
没有。

---

### [00:30:42] Hamilton Helmer

**English:**
...lawsuit, but there was a communication between Bill Gates and Warren Buffett where Warren Buffett was saying why he couldn't invest in Microsoft. He just didn't understand it. And so that meant the idea of network economies and what the moat was there he didn't understand. But I think the concept of a moat is a good one. The idea that you have something that gives you a refuge from competing forces.

**中文翻译:**
……在那场诉讼中，比尔·盖茨和沃伦·巴菲特之间有过交流，巴菲特解释了为什么他不能投资微软。他只是不理解它。这意味着他不理解网络经济的概念，也不理解那里的护城河是什么。但我认为护城河的概念很好，即你拥有某种东西，能让你在竞争力量面前获得庇护。

---

### [00:31:14] Lenny Rachitsky

**English:**
In terms of Warren Buffett, I found the quote about moats. Warren Buffett famously said, "In business, I look for economic castles protected by unreachable moats."

**中文翻译:**
关于沃伦·巴菲特，我找到了那句关于护城河的名言。巴菲特曾说：“在商业中，我寻找的是那些由坚不可摧的护城河所保护的经济城堡。”

---

### [00:31:22] Hamilton Helmer

**English:**
Right. And so he's taking care of the benefit part by saying a castle.

**中文翻译:**
没错。所以他通过“城堡”这个词涵盖了收益的部分。

---

### [00:31:27] Lenny Rachitsky

**English:**
Right. He's got it covered.

**中文翻译:**
对，他都想到了。

---

### [00:31:29] Hamilton Helmer

**English:**
But one of the tricks to understanding power is you have to have a pretty good understanding of why it's a castle and not a shack. So I'll give you a Netflix example. So a company I admire a lot, and I think if some of the things that they had to do to develop their business were so important for their business that don't guarantee a castle. So for example, UI development, it's been an enormous amount of resources on trying to get just the very best UI, I mean a zillion AB tests, all kinds of things. Their recommendation engine, everybody's knows the story about how that went, their interface with the content world and all this. So those things are important. They're things they have to spend a lot of time and resources on, but they can largely be mimicked.

**中文翻译:**
但理解力量的一个诀窍是，你必须非常清楚为什么它是一座城堡而不是一间破屋。我再举个 Netflix 的例子。这是一家我非常钦佩的公司，我认为他们为了发展业务所做的一些事情非常重要，但这些事情并不能保证拥有一座城堡。例如，UI 开发，他们投入了巨大资源来打造最好的 UI，做了无数次 AB 测试。还有他们的推荐引擎，大家都知道那个故事，以及他们与内容世界的接口等等。这些都很重要，是他们必须投入大量时间和资源的地方，但它们在很大程度上是可以被模仿的。

---

### [00:32:31] Hamilton Helmer

**English:**
So when Netflix in an earlier phase was fighting Blockbuster, when Blockbuster finally threw in the towel, said, "Well, we done. Well, better do a mail or a DVD business." If you look at the Blockbuster site, their UI site, you couldn't tell it different from Netflix. They just copied it. And so all that thoughtfulness about which things you put first and how you structure it and all that to make this suitable was mimicable. So that's an understanding of looking at the properties you have and trying to figure out if they're a castle or a shack.

**中文翻译:**
当 Netflix 在早期阶段与百视通（Blockbuster）竞争时，当百视通最终认输并说：“好吧，我们输了，我们也去做邮寄 DVD 业务吧。”如果你看百视通当时的网站 UI，你根本分不出它和 Netflix 有什么区别。他们直接照抄了。所以，关于哪些东西放在前面、如何构建结构等所有为了让用户满意的深思熟虑，都是可以模仿的。这就是通过观察你拥有的资产，来判断它们是城堡还是破屋。

---

### [00:33:06] Lenny Rachitsky (Sponsor Segment)

**English:**
This episode is brought to you by Paragon, the embedded integration platform for B2B SaaS product development teams. Are your users constantly requesting new integrations with other SaaS platforms that they use? Unfortunately, native product integrations take months of engineering to build and the maintenance never ends. Paragon enables your engineering team to ship integrations seven times faster than building in-house by removing the complexities around authentication, messy third-party APIs and debugging integration errors. Engineering teams at companies like CopyAI, Cinch, TLDB and over 100 other SaaS companies are using Paragon so they can focus their efforts on core product features, not integrations.

**中文翻译:**
本集节目由 Paragon 为您呈现，它是专为 B2B SaaS 产品开发团队打造的嵌入式集成平台。您的用户是否经常要求与他们使用的其他 SaaS 平台进行新集成？不幸的是，原生产品集成需要数月的工程开发，而且维护工作永无止境。Paragon 通过消除身份验证、杂乱的第三方 API 和调试集成错误等复杂性，使您的工程团队交付集成的速度比内部构建快七倍。CopyAI、Cinch、TLDB 等 100 多家 SaaS 公司的工程团队都在使用 Paragon，这样他们就可以专注于核心产品功能，而不是集成。

---

### [00:33:53] Lenny Rachitsky (Sponsor Segment Continued)

**English:**
The results, their shipping integrations on demand, which has led to higher product usage, better retention and more customer upsells. Visit useparagon.com/Lenny to see how Paragon can help you go to market faster with integrations today. That's use paragon.com/Lenny. So let's take this concept of 7 Powers. A lot of people listening to this are just like individual contributor product managers on teams building new products or iterating on products they already have. What do you suggest they do with this knowledge of there exists these ways to build benefits and barriers? I'm working on say a new product. What do you recommend they do? What's something they could do this week, next month to infuse these lessons into the products they're building?

**中文翻译:**
结果是，他们可以按需交付集成，从而提高了产品使用率、留存率和客户增购。访问 useparagon.com/Lenny，了解 Paragon 如何帮助您通过集成更快地进入市场。现在，让我们回到《7种力量》的概念。很多听众可能只是团队中的个人贡献者产品经理，正在构建新产品或迭代现有产品。对于这些关于建立收益和壁垒的方法，你建议他们如何利用这些知识？假设我正在开发一个新产品，你建议我怎么做？在这个星期或下个月，我能做些什么来将这些教训融入到我正在构建的产品中？

---

### [00:34:41] Hamilton Helmer

**English:**
I'd say they're a few and it's a little bit different. I'm not a great fan of the strategically driven organization because that idea, because it fuzzes over how this knowledge is useful at different stages in the business. And so for somebody in that position, say a product manager in an existing successful business. So it is important in terms of just understanding their business to know what their source of power is because they... And that can inform them about what it is that they're working for. And also they may see things since they're down in the weeds, they may see things that are important to that that they need to bring to other people's attention. Because they're the ones that really have the knowledge of what the heck's going on. There's another aspect I mentioned before, this idea of transforming, of starting up entirely new things. And usually... I wouldn't say, usually I say it's not uncommon for ideas about that to bubble up from down below.

**中文翻译:**
我想有几点，而且情况略有不同。我不太推崇“战略驱动型组织”这个概念，因为这个想法模糊了这些知识在业务不同阶段的用途。对于处于那个位置的人，比如一家成功的现有企业中的产品经理，了解业务的力量来源对于理解业务至关重要，因为这可以告诉他们工作的目标是什么。此外，由于他们深入一线，可能会发现一些对力量至关重要的事情，并需要引起他人的注意。因为他们才是真正了解到底发生了什么的人。还有我之前提到的另一个方面，即转型或启动全新事物的想法。通常——我不会说总是，但并不罕见——这类想法会从基层涌现出来。

---

### [00:36:03] Hamilton Helmer

**English:**
And so that's another source. So let's separate a business into three phases, origination, takeoff, and stability. So the answers I've given are more in the stability phase. In the takeoff phase, let's say you've launched a product, you've gotten customer traction, now you're in a phase where there's just very rapid growth, probably other entrants like you, what are you facing? What you're facing is remember that underneath all of this is a change in technology. That's what made the product market fit possible in the first place. But that doesn't just stop. That if you're in a technology wave, often there are all kinds of offshoots both for you and the compliments to your business and everything else going on at the same time.

**中文翻译:**
所以那是另一个来源。让我们把业务分为三个阶段：起源期、起飞期和稳定期。我刚才给出的答案更多针对稳定期。在起飞期，假设你已经发布了产品，获得了客户青睐，现在正处于高速增长阶段，可能还有其他像你一样的竞争者进入，你面临的是什么？你面临的是——请记住，这一切的底层是技术的变革。这正是最初实现产品与市场匹配的原因。但变革不会停止。如果你处于技术浪潮中，通常会产生各种分支，无论是对你、对你的业务互补品，还是同时发生的其他事情。

---

### [00:36:59] Hamilton Helmer

**English:**
And to win at that stability phase, which is really a market share win, you have to be aware of those and understand, okay, we have to incorporate this new feature. Or maybe now things have gotten to the point where this new market segment is, our product is attractive before it wasn't. This is meat and potato stuff for somebody at that level and it may well be the decisive element in terms of whether you win that market share battle with the other contenders. And so you have a very, very important role at that point. And so I'd say the first thing to do with your question is to make sure you think about the different phases of this and then ask what those responsibilities are.

**中文翻译:**
为了在那个阶段获胜（这本质上是市场份额之争），你必须意识到这些变化并理解：好吧，我们必须加入这个新功能。或者，也许现在情况已经发展到某个新细分市场，我们的产品以前没有吸引力，但现在有了。对于那个级别的员工来说，这些都是最基本、最核心的工作，而且这很可能成为你是否能在与其他竞争者的市场份额争夺战中获胜的决定性因素。因此，在那一点上，你扮演着非常非常重要的角色。所以，针对你的问题，我要说的第一件事是：确保你思考了业务的不同阶段，然后询问在这些阶段对应的职责是什么。

---

### [00:37:51] Lenny Rachitsky

**English:**
What about for people that are just trying to get better at being strategic, thinking strategically something every product leader is always encouraged to do, become a better strategic thinker, build as muscle of strategy, what do you often advise to people just get better at the stuff? Obviously read your book.

**中文翻译:**
那么对于那些只想提高战略能力、学会战略性思考的人呢？这是每个产品领导者都被鼓励去做的事——成为更好的战略思考者，锻炼战略肌肉。你通常会建议人们如何提高这方面的能力？显然，读你的书是其中之一。

---

### [00:38:09] Hamilton Helmer

**English:**
Read the book, and then have conversations with your colleagues about the topic because as you internalize what that means and how, have conversations with them about do we really have this kind of power? What's going on here? What's important? What isn't. Those conversations tend to allow you to get a better grip on things. I mean in the case of Netflix, Reed actually had me come in and train the top a hundred people in Netflix and strategy. We actually ran classes in the company, but that's unusual I'd say. And I didn't have the book yet. And so I think the book gets people pretty far down that path already.

**中文翻译:**
读那本书，然后与同事就这个话题进行交流。当你内化了它的含义和方法后，去和他们讨论：我们真的拥有这种力量吗？这里发生了什么？什么是重要的？什么不重要？这些对话往往能让你更好地掌控全局。以 Netflix 为例，里德（Reed Hastings）实际上邀请我去给 Netflix 的前 100 名高管培训战略。我们真的在公司里开了课，但我得说那很不寻常。当时我还没写那本书。所以我觉得现在有了这本书，已经能让人们在这条路上走得很远了。

---

### [00:38:55] Lenny Rachitsky

**English:**
And you don't do that anymore, I imagine if someone wanted to do that today, not an option.

**中文翻译:**
你现在不再做那种培训了吧？我想如果现在有人想请你，应该没机会了。

---

### [00:38:59] Hamilton Helmer

**English:**
I sadly don't have the time. I mean I do often do fireside chats at company meetings and that kind of thing, but not a full-blown course and I'm not teaching at Stanford anymore either. And so I don't. I enjoyed that immensely wonderful people to work with. But sadly I don't have the time.

**中文翻译:**
遗憾的是我没有时间。我是说，我经常在公司会议上做炉边谈话之类的，但不再开设完整的课程了，我也不在斯坦福教书了。所以我不再做了。我非常享受那段时光，合作的人都很棒。但可惜我确实没时间。

---

### [00:39:23] Lenny Rachitsky

**English:**
You're about to get a lot of requests for fireside chats. I hope you're ready. You mentioned AI at some point in our chat. I'm curious how you think AI is going to change your 7 Powers framework. Do you think defensibility goes down in general? Will certain forms of power become more important or harder to achieve? How do you think about AI?

**中文翻译:**
你可能很快就会收到一大堆炉边谈话的邀请，希望你准备好了。你在谈话中提到了 AI。我很好奇你认为 AI 将如何改变你的“7种力量”框架？你认为整体的防御性会下降吗？某些形式的力量会变得更重要还是更难获得？你怎么看 AI？

---

### [00:39:44] Hamilton Helmer

**English:**
Yeah, it's a great question. I mean we're all in this phase of wondering exactly how generative AI is going to play out. My own view, currently I don't see any change in seven powers from it in terms of an eighth power or something. But the issues that it brings up, like scale economies, I mean think of scale economies. If you have a fixed cost of trying to develop a model of a billion dollars or something or network effects, will AI models develop so that they learn in a way that for one user's interaction helps another user's interaction? That would be a powerful network economy. Or if it learns, if you think of if it learns about you and becomes a better psychiatrist or something, then that's a switching cost. So all these things are relevant to which business models will work and I find that useful.

**中文翻译:**
是的，这是一个好问题。我们现在都处于猜测生成式 AI 究竟会如何发展的阶段。我个人的观点是，目前我还没看到它会给“7种力量”带来什么改变，比如产生第八种力量之类的。但它引发的问题，比如规模经济——想想看，如果你开发一个模型需要 10 亿美元的固定成本；或者网络效应——AI 模型是否会发展到这种程度：一个用户的交互学习能帮助另一个用户的交互？那将是强大的网络经济。或者如果它了解你，变成了一个更好的心理医生，那就是切换成本。所以所有这些都与哪些商业模式能奏效相关，我觉得这很有用。

---

### [00:40:51] Hamilton Helmer

**English:**
But I think in general, the way I think about it is it's a standard form of potentially very powerful technology that is being introduced into the business world and just asking how that plays out. I currently tend to think of that there's three types of plays. There's the company that's the technology play itself. So if you think of microprocessors, it would be Intel. There's the companies that wouldn't exist without the technology. So for semiconductors it would be Microsoft. And then there are the companies that utilize the technology, but it had existed before and after. So for semiconductors it would be automobiles. They used a ton of chips, but there were still cars before, after.

**中文翻译:**
但总的来说，我的看法是，它是一种被引入商业世界的、潜在极其强大的标准技术形式，我们只是在观察它如何演变。目前我倾向于认为有三种参与方式。第一种是技术本身的公司，比如微处理器时代的英特尔。第二种是如果没有这项技术就不会存在的公司，比如半导体时代的微软。第三种是利用这项技术的公司，但这些公司在技术出现前后都存在，比如半导体时代的汽车行业。汽车使用了大量芯片，但芯片出现前后都有汽车。

---

### [00:41:48] Hamilton Helmer

**English:**
And so I'm of the view, I'm very much uncertain at this point that generative AI, its biggest impact will be that tertiary class. It will be used in a lot of things that existed before and exist after, but are made better by it like semiconductors and automobiles. And so it reminds me, if you think of really big technology shifts like this, it reminds me of electricity. When electricity came, you could completely reconfigure a factory floor. You no longer had to have... You could have the power source essentially at the operating unit of an operator. But that took a lot of redesign, incorporation, investment, learning, complements, all kinds of stuff. I tend to think this will be more like that. There will be some pure cases. People will want to have them write their term paper with ChatGPT or something. But if you think of businesses, it's hard for me to think of a single functional area in a business that with redesign couldn't benefit. So accounting, HR, R&D all have uses of this but requires incorporation, which is always troublesome.

**中文翻译:**
所以我认为——虽然目前还很不确定——生成式 AI 最大的影响将发生在第三类。它将被用于许多前后都存在、但因其而变得更好的事物中，就像半导体之于汽车。这让我想起了一些重大的技术变革，比如电力。当电力出现时，你可以彻底重新配置工厂车间。你不再需要……你基本上可以让动力源直接位于操作单元。但这需要大量的重新设计、整合、投资、学习、互补品等等。我倾向于认为 AI 也会是这样。当然会有一些纯粹的案例，比如人们想用 ChatGPT 写期末论文。但如果你考虑企业，我很难想到企业中有哪个职能部门在经过重新设计后不能从中受益。会计、人力资源、研发都有其用武之地，但需要整合，而整合总是很麻烦的。

---

### [00:43:30] Hamilton Helmer

**English:**
And so that's my view. But there certainly will be businesses that couldn't exist without it. And there's some that are coming up and some of those are in fact the businesses that empower the tertiary need, they're the ones that bring in. But if you go back, this will date me, but if you go back into business history, back in, I guess it was the 90s, there was this thing called business process re-engineering, the idea that you could take a computer sensibility into business processes, redesign them and get these monstrous cost savings. And it was a gigantic consulting opportunity for people. Whole companies got developed based on that and it feels more like that to me, but it's very interesting. I could be wrong, but it feels different than crypto. It feels like there's more of a real ultimate use case. I mean, if it really is true what they say that a 50% improvement in programming efficacy is not uncommon, just that proposition alone is worth an awful lot of money if you think how many programmers are in the world.

**中文翻译:**
这就是我的看法。当然，肯定会有一些没有它就无法生存的企业。现在也出现了一些，其中一些实际上是为第三类需求提供支持的企业。但如果你回顾商业史（这会暴露我的年龄），在 90 年代，有一种叫“业务流程重组”（BPR）的东西，其核心思想是将计算机思维引入业务流程，重新设计它们并获得巨大的成本节约。这对人们来说是一个巨大的咨询机会，整个公司都基于此发展起来。对我来说，AI 感觉更像那样，这非常有趣。我也可能错了，但它感觉和加密货币不同。它感觉有更多真实的、终极的用例。我是说，如果他们说的“编程效率提高 50% 并不罕见”是真的，光是这一个命题就价值连城，想想世界上有多少程序员。

---

### [00:44:56] Lenny Rachitsky

**English:**
No question. You mentioned eighth power. I just want to check, is there an emerging eighth power you wish you maybe would've included or maybe added in the future that's like, "Oh, maybe this is on the edge," or it's like, "Nope, we got these seven?"

**中文翻译:**
毫无疑问。你提到了第八种力量。我只想确认一下，有没有什么新兴的第八种力量是你觉得也许该包含进去，或者未来可能添加的？比如“哦，也许这个处于边缘”，还是说“不，就这七种了”？

---

### [00:45:15] Hamilton Helmer

**English:**
It's a great question. I'm always looking for it because if you find it it probably means it's so obscure there, it'll also be a great investment opportunity. We're looking all the time, but so far, no. So far I'm pretty satisfied that seven is an exhaustive set, but never say never. That's an empirical seven, not a theoretical seven.

**中文翻译:**
这是一个好问题。我一直在寻找，因为如果你找到了，那可能意味着它非常隐秘，也会是一个极好的投资机会。我们一直在找，但到目前为止，还没有。目前我相当满意这七种力量是一个完备的集合，但永远不要说永远。这是基于经验总结出的七种，而不是理论推导出的七种。

---

### [00:45:37] Lenny Rachitsky

**English:**
If we start seeing you making incredible returns, you've clearly found an eighth power [inaudible 00:45:41]-

**中文翻译:**
如果我们开始看到你获得惊人的回报，那显然是你找到了第八种力量（笑）。

---

### [00:45:41] Hamilton Helmer

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:45:43] Lenny Rachitsky

**English:**
I want to close one thread on a power that you mentioned that is often a pitfall, which is around process power and basically execution. A lot of people think so in a lot of decks it's like, oh, we have the most amazing team, we move the fastest, we're earliest. You mentioned how rarely is that actually a power actually being able to execute and create a process that is an actual barrier? Can you just talk a bit more about that to help people understand okay, it's probably not our power?

**中文翻译:**
我想结束关于你提到的一个经常成为陷阱的力量的话题，那就是“流程力量”，基本上就是执行力。很多人在计划书中会写：哦，我们有最棒的团队，我们行动最快，我们最早进入。你提到过，能够执行并创建一个真正的流程壁垒其实很少能成为一种“力量”。你能再多谈谈这一点吗，好让人们明白“好吧，这可能不是我们的力量来源”？

---

### [00:46:09] Hamilton Helmer

**English:**
One of the great thinkers in strategy was this Harvard professor Michael Porter, and he in probably 40 years ago, made the very controversial statement that operational excellence is not strategy. He got a lot of people of the Harvard Business School faculty really mad at him because that's what their careers were about and it sounded like he was dissing them. But the point he was making was when you get to this end state, if you already have power that things that drive operational excellence can be mimicked because you can hire a consulting firm who has best practices, knowledges that come in and get you up to snuff. You can hire people from your competitors who know how to do it better. And that's true, but it's also true in this takeoff phase in a business that we talked about before, when you're trying to attain competitive position, operational excellence is everything.

**中文翻译:**
战略领域的伟大思想家之一是哈佛大学教授迈克尔·波特（Michael Porter）。大约 40 年前，他发表了一个非常有争议的声明：运营卓越不是战略。这让哈佛商学院的很多教授对他非常生气，因为那是他们的职业生涯所在，听起来他像是在蔑视他们。但他想表达的观点是，当你达到最终状态时，如果你已经拥有了力量，那么驱动运营卓越的因素是可以被模仿的，因为你可以聘请一家拥有最佳实践知识的咨询公司来帮你达标。你可以从竞争对手那里挖走知道如何做得更好的人。这是事实，但在我们之前谈到的业务起飞阶段，当你试图获得竞争地位时，运营卓越就是一切。

---

### [00:47:14] Hamilton Helmer

**English:**
And so if you think of strategy, not statically endpoints like Professor Porter was, but if you look at dynamically how you get there, operational excellence is essential for a strategy. So think of those things I mentioned before about Netflix, about their UI and recommendation engine and so on, or international rollout, all those things. They were in a battle to get more subscribers than other people and those were critical for that. But in themselves, they're critical in attaining competitive position, but in themselves, they're not sources of power typically, unless there's some very tight considerations here or very demanding considerations for the... Unless if they have to be material, but they also have to be opaque or some way people can't easily imitate them. Either they don't understand what's going on or they might be opaque. So for example, think of TSMC. So when they put up the latest fab and get that operational, are there a lot of steps in doing that?

**中文翻译:**
所以，如果你不像波特教授那样静态地看终点，而是动态地看你如何到达那里，运营卓越对于战略来说是必不可少的。想想我之前提到的 Netflix 的 UI、推荐引擎，或者国际化推广等等。他们当时正在争夺比别人更多的订阅用户，而这些对于实现这一目标至关重要。但就其本身而言，它们对于获得竞争地位至关重要，但通常不是力量来源，除非有一些非常严苛的考量……除非它们不仅具有实质性，而且还必须是不透明的，或者人们无法轻易模仿。要么他们不理解发生了什么，要么过程本身是不透明的。例如，想想台积电（TSMC）。当他们建立最新的晶圆厂并投入运营时，其中是否有很多步骤？

---

### [00:48:43] Hamilton Helmer

**English:**
They know how to do with their staff is trained to do it, but it's not documented necessarily and you can't imitate it. Then maybe they have it. I don't know if they have process power or not, but it takes that level of complexity. In my book, I use the example of Toyota and a car manufacturing is complex enough that you can have this opacity in terms of material steps, but it's not common. So if you're in a stability phase of business, you're stuck with this funny thing, which is most of your day is on those issues and it should be because if you don't do it, a competitor can and they can end up better than you. And so you're on a treadmill and that's the way business is. That's fine. And if you stop running that treadmill, you get creamed. So you got to do it, it's most of your day, but it's not power. And there are those rare cases where it's so material and so inimitable that it can be power, but they're rare.

**中文翻译:**
他们知道怎么做，他们的员工经过培训知道怎么做，但这不一定被记录在案，你也无法模仿。那么也许他们拥有这种力量。我不知道他们是否有流程力量，但它需要那种程度的复杂性。在我的书中，我以丰田为例，汽车制造足够复杂，以至于在关键步骤上可以保持这种不透明性，但这并不常见。所以，如果你处于业务的稳定阶段，你会陷入一种滑稽的境地：你一天中的大部分时间都在处理这些问题，而且理应如此，因为如果你不做，竞争对手就会做，他们最终会比你做得更好。所以你就像在跑步机上，商业就是这样。这没问题。如果你停止跑动，你就会完蛋。所以你必须做，这是你工作的大部分，但它不是“力量”。只有在极少数情况下，它如此重要且如此难以模仿，才能成为力量，但那很罕见。

---

### [00:50:02] Lenny Rachitsky

**English:**
I like the heuristic that if you haven't written it down or you can't describe it, that might be a sign that maybe process power is a power of yours.

**中文翻译:**
我喜欢这个启发式方法：如果你还没把它写下来，或者你无法描述它，这可能是一个信号，表明流程力量也许是你的力量之一。

---

### [00:50:13] Hamilton Helmer

**English:**
Yeah. And there isn't a consulting firm that offers to bring you up to speed on that.

**中文翻译:**
是的。而且没有哪家咨询公司能提供让你在这方面迅速赶上的服务。

---

### [00:50:20] Lenny Rachitsky

**English:**
They'll make you more like Amazon as a service. Kind of along these same lines, you talk about how the only things that create value in a company are power, market size and operational excellence. And I think hearing that will blow a lot of people's minds because they think there's so many things that contribute to the value of a company and you whittle it down to these three things. What can you say about that insight?

**中文翻译:**
他们会提供“让你更像亚马逊”的服务。沿着同样的思路，你谈到在一家公司中，唯三创造价值的东西是：力量、市场规模和运营卓越。我想听到这个会让很多人大吃一惊，因为他们认为有很多因素在贡献公司的价值，而你把它缩减到了这三样。关于这个见解，你有什么想说的？

---

### [00:50:47] Hamilton Helmer

**English:**
So I'd say they're right and I'm right. They're right because there are this incredible... I mean business is really hard and there are just a multitude of things you have to pay attention for. I'm right because all those things fall into those three categories. So it's an exhaustive set and it simply comes out of the math. So we're both right I'd say.

**中文翻译:**
我会说他们是对的，我也是对的。他们是对的，因为商业确实非常困难，有无数的事情需要关注。我是对的，因为所有这些事情最终都归入这三个类别。所以这是一个完备的集合，这纯粹是从数学逻辑中得出的。所以我觉得我们都对。

---

### [00:51:16] Lenny Rachitsky

**English:**
Final question, the intent of a lot of your work is to empower founders. I'm curious if you've noticed any broad economic trends or shifts that you think will make life easier or harder for founders in the coming years?

**中文翻译:**
最后一个问题。你的很多工作的目的都是为了赋能创始人。我很好奇，你是否注意到任何广泛的经济趋势或转变，你认为这些趋势会让创始人在未来几年的生活变得更容易还是更困难？

---

### [00:51:32] Hamilton Helmer

**English:**
Personally, I am very, very concerned about the debt trajectory of the United States and of many countries around the world, but I'll pick on the United States, but it's a trend going on everywhere. We're on a trajectory for this extremely high indebtedness. And so if you think about the last 30 years, right? There's been a crisis about once every 10 years. So there's the dot-com bust, there's the financial crisis, there was COVID. Nothing makes me think that the frequency will be a lot less. I don't know what, who knows? These are all uncertain events. But imagine if we got to one of those and we had no dry powder and dry powder for us is the ability to heavily deficit spend take on debt.

**中文翻译:**
就个人而言，我非常、非常担心美国以及全球许多国家的债务轨迹。我以美国为例，但这是一个普遍趋势。我们正处于一个极高负债的轨道上。如果你回想过去 30 年，大约每 10 年就会发生一次危机：互联网泡沫破裂、金融危机、新冠疫情。没有任何理由让我觉得这种频率会降低。我不知道会发生什么，谁知道呢？这些都是不确定事件。但想象一下，如果我们遇到其中一个危机，而我们已经没有“弹药”了——对我们来说，弹药就是进行大规模赤字支出、承担债务的能力。

---

### [00:52:52] Hamilton Helmer

**English:**
And fortunately our government did that in both the financial crisis and in COVID. And because that people had jobs. My own view about the financial crisis is that if we hadn't done that, plus having Ben Bernanke as the head of the Fed, we would've gone into another great depression. It was that ugly. So this current debt trajectory, you don't know how long it will take exactly when, but eventually that will mean we will not have dry powder. People will not respect the credit worthiness of this country. So that worries me a lot. And it utterly will affect the idea of company founding because if you get into a crisis like that, the capital markets lock up and it gets very difficult to do anything.

**中文翻译:**
幸运的是，我们的政府在金融危机和新冠疫情期间都这么做了，因此人们保住了工作。我个人对金融危机的看法是，如果我们当时没有那样做，再加上本·伯南克担任美联储主席，我们就会陷入另一场大萧条。当时的情况就是那么糟糕。所以目前的债务轨迹，你不知道具体什么时候会出问题，但最终这意味着我们将失去“弹药”。人们将不再尊重这个国家的信用。这让我非常担心。这绝对会影响公司创办，因为如果你陷入那样的危机，资本市场就会冻结，做任何事情都会变得非常困难。

---

### [00:54:18] Hamilton Helmer

**English:**
And to really stretch my credibility here, I'll opine on just how hard a problem this is to solve. The reason this is so difficult for this country to solve and other countries is that it is right at the crux of the delicate dance between capitalism and democracy. So if you think about the problem, of course that's driving all this is entitlements. There's discretionary spending, certain recovery programs and stuff, but those can go away. The underlying trend that people just can't get their arms around is entitlements. And anybody who looks at the numbers can see that. Every economist knows that. But that's not an easy fix.

**中文翻译:**
在这里，我冒着透支信誉的风险，谈谈这个问题有多难解决。这个国家和其他国家之所以难以解决这个问题，是因为它正处于资本主义与民主之间微妙博弈的核心。如果你思考这个问题，驱动这一切的当然是“福利支出”（Entitlements）。虽然有自由裁量支出、某些复苏计划等，但那些是可以取消的。人们无法掌控的底层趋势是福利支出。任何看数据的人都能看出来，每个经济学家都知道这一点。但这并不是一个容易解决的问题。

---

### [00:55:30] Hamilton Helmer

**English:**
And the reason it's not an easy fix is there are two opposing views of what's going on, and there's no way to resolve those two views. One is that capitalism is rapacious and results in more and more inequality and the government has to do something about it. And the other is that the government is on a path that is creeping socialism that will undermine our freedom and economic sufficiency. And the poster child for the rapacious capitalism. One is, I don't know if you've seen the recent analysis of inequality in the United States just came out, much more robust analysis. And it said that basically inequality in the last 60 years of the United States is unchanged, but that's post-transfer, post-tax inequality, which basically says the amount of taxing and transferring going on was about right. So it says that the amount we're spending is about right from that perspective, that it compensates for the other inequities and we should be spending that much so we should tax more.

**中文翻译:**
之所以难以解决，是因为存在两种截然相反的观点，且无法调和。一种观点认为资本主义是贪婪的，导致了越来越多的不平等，政府必须采取行动。另一种观点认为政府正走在一条渐进的社会主义道路上，这将破坏我们的自由和经济自足。关于贪婪资本主义的典型案例——我不知道你是否看过最近关于美国不平等的分析，那是一个更稳健的分析。它指出，过去 60 年美国的不平等基本没有变化，但那是“转移支付后、纳税后”的不平等。这基本上说明目前的税收和转移支付规模是合适的。所以从那个角度看，我们的支出规模是合适的，它补偿了其他不公平，我们应该支出这么多，所以我们应该多征税。

---

### [00:56:30] Hamilton Helmer

**English:**
And the poster child for the other point of view of the dangers of government is the steadily increasing without interruption percentage of the economy that is government. And to levels that 75 years ago, people would've thought absolutely impossible. So there are these two views about what's going on. One is that we're compensating for the normal inequities of capitalism, and the other is that we're headed down a path to socialism and ruin. And that leads to a deadlock, which is you don't tax anymore and you don't cut spending and that leaves deficits. So anyway, a long, long rant, sorry but that trend is extremely politically difficult to deal with and extremely threatening and that concerns me immensely.

**中文翻译:**
而另一种关于政府危险性的典型观点是，政府在经济中所占的比例在不间断地稳步上升，达到了 75 年前人们认为绝对不可能的水平。所以关于现状有两种看法：一种是我们正在补偿资本主义正常的分配不公；另一种是我们正走向社会主义和毁灭。这导致了僵局：既不增加税收，也不削减开支，结果就是赤字。总之，抱歉我抱怨了这么久，但这一趋势在政治上极难处理，且极具威胁，这让我深感忧虑。

---

### [00:56:32] Lenny Rachitsky

**English:**
Not to leave listeners with a very sad state of affairs.

**中文翻译:**
我们可不想让听众带着这么悲观的情绪结束。

---

### [00:56:36] Hamilton Helmer

**English:**
Yeah, sorry.

**中文翻译:**
是的，抱歉。

---

### [00:56:37] Lenny Rachitsky

**English:**
No, no. I think this is important. I think it's important people think about this and know these things. Is there anything that gives you hope? Is there anything that gets you excited about either for founders or anyone in general, just to leave folks with maybe on a happy?

**中文翻译:**
不，不。我认为这很重要。人们思考并了解这些事情很重要。有没有什么让你感到希望的事情？有没有什么让你对创始人或普通大众感到兴奋的事情，能让我们以愉快的心情结束？

---

### [00:56:50] Hamilton Helmer

**English:**
Yeah, I mean, I am an optimist really in a way, and I do. There's a famous Austrian and eventually American economist named Joseph Schumpeter who wrote this wonderful book Theory of Economic Development way back when over a hundred years ago, where he took the unusual view of saying that the vitality of an economy depended on entrepreneurs. And I ascribe to that. I think that creativity and action are the ways society and people advance. And I think the US's and a free society has huge advantages in that. And I think that I feel very lucky to be in a place I'm in Silicon Valley, but to be in a place in a country where that is vital and active and I think that's ground zero for me. And so I think you see that alive and well, I think. And there are people that are very Enthusiastic about that as I am.

**中文翻译:**
有的，其实在某种程度上我是一个乐观主义者。有一位著名的奥地利裔美国经济学家约瑟夫·熊彼特（Joseph Schumpeter），他在一百多年前写了一本很棒的书《经济发展理论》，他在书中提出了一个不同寻常的观点：经济的活力取决于企业家。我非常认同这一点。我认为创造力和行动是社会和人类进步的方式。我认为美国和自由社会在这方面拥有巨大优势。我觉得自己非常幸运能身处硅谷，身处一个这种活力依然旺盛且活跃的国家，这对我来说就是一切的起点。我认为这种精神依然健在，而且有很多人像我一样对此充满热情。

---

### [01:00:12] Lenny Rachitsky

**English:**
Beautiful way to close out our chat. Is there anything else you want to share before we get to our very exciting lightning round? Is there anything you want to leave listeners with or any last tidbit of advice?

**中文翻译:**
这是结束我们谈话的美好方式。在我们进入非常精彩的闪电轮问答之前，你还有什么想分享的吗？有什么想留给听众的话或最后的建议吗？

---

### [00:58:22] Hamilton Helmer

**English:**
I alluded to it before, but just that remember, action is the first principle of business. You do stuff and my book is very oriented towards that. The idea was not to tell you what to do, but to give you guideposts while you're on that journey. People that are enthused about it, I encourage you to do stuff. That's where it all starts and I can think about it and maybe help a little bit, but it's mostly doing stuff.

**中文翻译:**
我之前提到过，但请记住：行动是商业的第一原则。你要去做事，我的书也是以此为导向的。我的初衷不是告诉你该做什么，而是在你前行的旅途中为你提供路标。对于那些对此充满热情的人，我鼓励你们去行动。那才是一切的开始。我可以思考并提供一点帮助，但核心还是在于行动。

---

### [00:58:59] Lenny Rachitsky

**English:**
I love that point so much. It was something I was going to touch on but I didn't get to is just there's so many people that just sit around and theorize about a strategy of their business, especially in their early stage. Here's our grand master plan, here's an amazing strategy or just read about startup ideas and don't actually try it. I love this final note of just try it. Just do it. Don't just sit there and-

**中文翻译:**
我非常喜欢这一点。我本来想提到但没机会说的是，有太多人只是坐在那里空谈业务战略，尤其是在早期阶段。比如“这是我们的宏伟蓝图”、“这是一个了不起的战略”，或者只是阅读创业点子而不去尝试。我喜欢这最后的叮嘱：去尝试，去做，不要只是坐在那里——

---

### [00:59:18] Hamilton Helmer

**English:**
Yeah, yeah, just do it. And life is full of surprises. You'll end up in a place you didn't expect.

**中文翻译:**
是的，去行动吧。生活充满了惊喜，你最终会到达一个意想不到的地方。

---

### [00:59:24] Lenny Rachitsky

**English:**
Amazing. Speaking of ending up in a place you didn't expect, it's time for our very exciting lightning round. Are you ready?

**中文翻译:**
太棒了。说到到达意想不到的地方，现在是进入我们非常精彩的闪电轮问答时间了。准备好了吗？

---

### [00:59:32] Hamilton Helmer

**English:**
Oh, sure. I'll do my best here. I'm not very good on lightning.

**中文翻译:**
噢，当然。我会尽力而为，我不太擅长快节奏。

---

### [00:59:37] Lenny Rachitsky

**English:**
First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
第一个问题，你向别人推荐最多的两三本书是什么？

---

### [00:59:42] Hamilton Helmer

**English:**
One book that is extremely wonky, and I can only take it in very small doses, but is magnificent, is one called The Road to Reality by Roger Penrose, who's this brilliant mathematician. And it will be very daunting for anybody unless you're a deep math person, but his brilliance in erudition just shines through in this thing. And it's an amazing book. I would say there's another book, boy, I wish I could remember the name. Maybe you can get the name of the author called Gene by this geneticist. And I think he's a Harvard Medical School professor that's about the history of genetics and he is an absolutely luminous writer. I mean, it puts me to shame. I'm embarrassed when I read it because I think how pedestrian my writing is and incredibly knowledgeable about the history of genetics and I think that's such an important topic. So those are two that I would recommend highly, fairly wonky, but I like them both.

**中文翻译:**
有一本书非常深奥，我每次只能读一点点，但它非常宏伟，叫《通往现实之路》（The Road to Reality），作者是天才数学家罗杰·彭罗斯（Roger Penrose）。除非你是资深数学爱好者，否则这本书会让人望而生畏，但他的才华和博学在书中展露无遗。这是一本了不起的书。另一本书，天哪，我希望我能记得名字。也许你能查到作者的名字，叫《基因》（The Gene），作者是一位遗传学家。我想他是哈佛医学院的教授，书是关于遗传学历史的，他是一位非常有才华的作家。读他的书让我感到羞愧，我觉得自己的文笔太普通了。他对遗传学历史的了解极其深刻，我认为这是一个非常重要的主题。这两本书我都高度推荐，虽然都很深奥，但我很喜欢。

---

### [01:00:56] Lenny Rachitsky

**English:**
I love them. The author, I just looked him up. Siddhartha Mukherjee.

**中文翻译:**
我喜欢这些推荐。我查了一下作者，是悉达多·穆克吉（Siddhartha Mukherjee）。

---

### [01:01:01] Hamilton Helmer

**English:**
Yes. Just amazing. You read it and you go, "How did he think of that phrasing?" I mean, it's just, he's amazing.

**中文翻译:**
是的，太了不起了。你读的时候会想：“他是怎么想到那种表达方式的？”他真的很棒。

---

### [01:01:10] Lenny Rachitsky

**English:**
Do you have a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
你最近有没有特别喜欢的电影或电视剧？

---

### [01:01:14] Hamilton Helmer

**English:**
I'm a huge movie fan and have been all my life, and I'm particularly keen on animated films. But the movie that I've recently seen that I liked particularly it was American Fiction. I thought that was... It didn't make any of the easy choices in a movie and as a result was just incredibly interesting and thoughtful I thought.

**中文翻译:**
我是一个超级影迷，这辈子都是。我特别喜欢动画电影。但我最近看的一部特别喜欢的电影是《美国小说》（American Fiction）。我觉得它……它没有在电影创作中选择任何容易的路径，结果就是非常有趣且引人深思。

---

### [01:01:39] Lenny Rachitsky

**English:**
Do you have a favorite product you recently discovered that you really love?

**中文翻译:**
你最近有没有发现什么非常喜爱的产品？

---

### [01:01:43] Hamilton Helmer

**English:**
In my office, just this last week, we actually put a Persian rug in our entry room, and this is what's called a Farahan Sarouk rug and it's 150 years old. And it had an effect in me that I didn't expect, which is it is a work of great beauty. And it was before, it was all hand-done before machines. You get all this wonderful variation of the actual icons in the rug and the different dye colors. And I find that every morning when I walk in, I go, "That's really beautiful," and it's uplifting and it shows you the importance of, or the value of the quality of art. I mean, just blows my mind actually. So that's probably not the usual product discussion that you get.

**中文翻译:**
就在上周，我们在办公室的入口处放了一块波斯地毯，这是一种叫 Farahan Sarouk 的地毯，已经有 150 年历史了。它带给我一种意想不到的影响，它是一件极其精美的艺术品。它是全手工制作的，在机器时代之前。你可以看到地毯图案中奇妙的变化和不同的染料颜色。我发现每天早上走进办公室，我都会感叹：“这真美。”它让人心情愉悦，展示了艺术品质的重要性或价值。这真的让我大开眼界。这可能不是你通常听到的那种产品讨论。

---

### [01:02:50] Lenny Rachitsky

**English:**
No, I love that answer. Recently we've had some really unique choices. One is a very nice Mercedes and a Rivian and a minivan recently. We've got a lot of very nice things.

**中文翻译:**
不，我喜欢这个答案。最近我们听到了一些非常独特的选择。有非常棒的梅赛德斯、Rivian，最近还有人选了迷你面包车。我们听到了很多好东西。

---

### [01:03:00] Hamilton Helmer

**English:**
Oh, that's great. I'm a car guy too, so I didn't answer on the car question.

**中文翻译:**
噢，那太好了。我也是个爱车的人，所以我没选汽车。

---

### [01:03:05] Lenny Rachitsky

**English:**
Oh man, I love that. We have Rory Sutherland coming on the podcast soon. He is one of the leaders of Ogilvy and he has a whole thing about how buying a home is the best value of art to buy art if you live in a home that makes you feel inspired and is beautiful.

**中文翻译:**
天哪，我喜欢这个。罗里·萨瑟兰（Rory Sutherland）很快就要来参加播客了。他是奥美的领导者之一，他有一套理论，认为买房是购买艺术品的最佳价值体现——如果你住在一个让你感到灵感迸发且美丽的家里。

---

### [01:03:20] Hamilton Helmer

**English:**
Yeah, I'm a big believer in that. I mean, I think that your place and how you connect to it has an important grounding effect. And then before I talked earlier about creativity and I think surrounding yourself in an environment that stimulates that is really important. And so I couldn't agree with him more.

**中文翻译:**
是的，我深信这一点。我认为你居住的地方以及你与它的连接具有重要的“落地”作用。我之前谈到了创造力，我认为让自己置身于一个能激发创造力的环境中非常重要。所以我完全同意他的观点。

---

### [01:03:51] Lenny Rachitsky

**English:**
Two more questions. Do you have a favorite life motto that you often think about, come back to share with friends or family?

**中文翻译:**
还有两个问题。你有没有什么人生格言是经常思考，或者会分享给朋友和家人的？

---

### [01:03:58] Hamilton Helmer

**English:**
One is what Clint Eastwood's advice to actors, which is don't just do something, stand there. And so there are a lot of things that are long-termish with low signal to noise. And you can often just do a lot of stuff that you think makes a difference, but it really doesn't. And so that's one. The other one which is somewhat more profound I think was one that I had a famous Sri Lankan journalist was a mentor of mine and very dear friend, and he had a favorite expression that I adhere to all the time, which is everything is always about something else.

**中文翻译:**
一个是克林特·伊斯特伍德（Clint Eastwood）给演员的建议：“不要只是做点什么，站在那里。”（Don't just do something, stand there.）有很多事情是长期的，且信噪比很低。你经常会做很多你认为会有所作为的事情，但实际上并没有。这是其一。另一个我认为更深刻的，是我的一位导师、也是亲爱的朋友——一位著名的斯里兰卡记者——他最喜欢的一句话，我一直信守着：万事皆关乎他物（Everything is always about something else）。

---

### [01:04:49] Lenny Rachitsky

**English:**
Wow. Deep.

**中文翻译:**
哇，很有深度。

---

### [01:04:53] Hamilton Helmer

**English:**
And that's so true if you're dealing with this power stuff when if you really dig down, everything is always about something else.

**中文翻译:**
当你处理这些关于“力量”的事情时，这非常正确。如果你真的深挖下去，万事皆关乎他物。

---

### [01:04:58] Lenny Rachitsky

**English:**
Speaking of power, final question. People that have a lot of power are leaders in the world. I'm curious, do you have a favorite historical leader?

**中文翻译:**
说到力量，最后一个问题。拥有巨大力量的人通常是世界的领导者。我很好奇，你有没有最喜欢的历史领导人？

---

### [01:05:07] Hamilton Helmer

**English:**
So yeah. I have some that I admire a great deal. I'm a tremendous fan of Winston Churchill's. Most really great people are quirky and he qualified. There are things you could say about him that you might not have liked that so much, but he was a genius and had great fortitude, human sense. He understood things long before other people. I've give him high marks. Some of the great artists I admire enormously. I'm reading a book right now on the last 20 years of Michelangelo, which wonderful book actually, and which is a very interesting period because in his first 70 years he finished up all that, he wasn't going to do sculpture anymore. He just finished The Last Judgment, which was the wall of the Sistine Chapel.

**中文翻译:**
是的，我有几位非常钦佩的人。我是温斯顿·丘吉尔的超级粉丝。大多数伟人都有点古怪，他也不例外。关于他，你可能会发现一些你不那么喜欢的地方，但他是个天才，拥有巨大的毅力和人文关怀。他比别人更早地洞察事物。我给他很高的评价。还有一些伟大的艺术家我也非常钦佩。我正在读一本关于米开朗基罗最后 20 年的书，那是一本很棒的书。那是一个非常有趣的时期，因为在他 70 岁之前，他已经完成了所有的成就，他本打算不再做雕塑了。他刚刚完成了西斯廷教堂墙壁上的《最后的审判》。

---

### [01:06:08] Hamilton Helmer

**English:**
And I think the last major fresco he did. And a lot of his friends at that time, he was exiled from Florence and living in Rome and he had this Roman community and a lot of his close friends that had recently died or had difficulties. So he's at this inflection point in his life at 70, which in those days was very old, and yet he went on to do some of the most remarkable architecture in the history of the world. And so you've got to admire that. I mean, just doing that, which is that rare second act. But I think for world leaders, Winston Churchill is very high. I'm a fan of Teddy Roosevelt, I must say too, in this country.

**中文翻译:**
我想那是他最后一件主要的壁画作品。当时他的很多朋友——他被佛罗伦萨放逐，住在罗马——他的很多亲密朋友最近都去世了或遭遇了困难。所以他在 70 岁时处于人生的转折点（在那个时代 70 岁已经非常老了），然而他却继续创造了世界历史上一些最卓越的建筑。你不得不钦佩这一点。我是说，能做到这一点，那是罕见的“第二幕”。但对于世界领导人，丘吉尔的地位很高。我也必须说，我是西奥多·罗斯福（Teddy Roosevelt）的粉丝。

---

### [01:07:00] Lenny Rachitsky

**English:**
I love that. Hamilton, you are wonderful. I feel like we have helped a lot of people up-level their ability to think about strategy and moats and power. Thank you so much for being here. Two final questions. Where can folks find more online if they want to dig in further, and how can listeners be useful to you?

**中文翻译:**
我喜欢这些分享。汉密尔顿，你太棒了。我觉得我们帮助很多人提升了思考战略、护城河和力量的能力。非常感谢你能来到这里。最后两个问题：如果大家想进一步深入研究，可以在哪里找到更多信息？以及听众可以如何帮助你？

---

### [01:07:15] Hamilton Helmer

**English:**
Yeah, so as I say, I'm an idea person and I'm about trying to empower company founders, and so only thing I can say is read the book, spread the ideas, start your own company. Those are the things that would make me happy.

**中文翻译:**
是的，正如我所说，我是一个注重想法的人，我致力于赋能公司创始人。所以我唯一能说的是：读那本书，传播这些想法，创办你自己的公司。这些就是能让我感到快乐的事情。

---

### [01:07:37] Lenny Rachitsky

**English:**
Amazing. Hamilton, Thank you so much for being here.

**中文翻译:**
太棒了。汉密尔顿，非常感谢你能来。

---

### [01:07:40] Hamilton Helmer

**English:**
Great. My pleasure, Lenny.

**中文翻译:**
太好了，这是我的荣幸，Lenny。

---

### [01:07:42] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lenny'sPodcasts.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢大家的收听。如果您觉得本节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众找到本播客。您可以在 Lenny'sPodcasts.com 找到所有往期节目或了解更多信息。下期节目见。