# Hari Srinivasan - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Hari Srinivasan, VP of Product at LinkedIn.

---

### [00:00:00] Hari Srinivasan

**English:**
It was March 2020 and we were just watching COVID hit. It was just this heartbreaking moment where in the feed you were seeing all these people, by no fault of their own, starting to post that they've lost their job. We started seeing in our data is you had some areas like maybe hospitality was really getting hit, but some areas like customer service that just couldn't hire enough. You'd think the marketplace would balance pretty quickly. You'd think, okay, maybe these people will start moving to other jobs, but it wasn't happening.

**中文翻译:**
那是2020年3月，我们正目睹着新冠疫情的爆发。那是一个令人心碎的时刻，在动态消息（Feed）里，你会看到很多人并非因为自己的过错，开始发帖说他们失去了工作。我们从数据中发现，像酒店餐饮这样的行业受到了沉重打击，但像客户服务这样的一些领域却怎么也招不到足够的人。你可能会认为市场会很快达到平衡，觉得这些人会开始转向其他工作，但事实并非如此。

---

### [00:00:24] Hari Srinivasan

**English:**
A large reason behind this, people are used to looking for certain particular titles, and they didn't start realizing other people could do this job. We made a pretty big push in something we call skills-first hiring. This was the idea that we could translate people's experiences into a set of skills, and by that we could help them really start balancing the marketplace with a much different system. I think that the job market is rebalancing, but it's being done, the pathways are being done in a very different way that seems to be maybe a change that holds through these ups and downs. That'll be very interesting to see.

**中文翻译:**
这背后的一个很大原因是，人们习惯于寻找特定的职位头衔，而雇主也没有意识到其他背景的人也能胜任这份工作。于是我们大力推行一种被称为“技能优先招聘”（skills-first hiring）的理念。其核心思想是将人们的经历转化为一套技能，通过这种方式，我们可以利用一套完全不同的系统来帮助市场重新实现平衡。我认为就业市场正在重新平衡，但这种平衡的方式和路径已经发生了巨大的变化，这种变化似乎能在经济的起伏中持续下去。这将是非常值得观察的。

---

### [00:00:57] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts, to learn from their hard-won experiences building and growing today's most successful products. Today, my guest is Hari Srinivasan. This episode has a hilarious story.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的跨国产品负责人和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Hari Srinivasan。这一集背后有一个非常有趣的故事。

---

### [00:01:11] Lenny

**English:**
On Twitter, an account called The Curious PM tagged me with a request to have someone from LinkedIn come on the podcast and talk about how they operate and what they've learned about building products that serve so many different types of customers. I replied asking for any suggestions for who he thought I should specifically talk to, and he suggested Hari Srinivasan, by doing some research on LinkedIn. I reached out to Hari, told him about this tweet and he agreed. Here's the episode.

**中文翻译:**
在 Twitter 上，一个名为“The Curious PM”的账号艾特了我，请求邀请 LinkedIn 的人来播客聊聊他们的运作方式，以及在构建服务于如此多不同类型客户的产品时学到了什么。我回复询问他是否有具体的人选建议，他在 LinkedIn 上做了一些调研后推荐了 Hari Srinivasan。我联系了 Hari，告诉了他这条推文的事，他答应了。于是就有了这一集。

---

### [00:01:39] Lenny

**English:**
Hari's been at LinkedIn for eight-and-a-half years and he leads the Talent Solutions Product Team as VP of product, which is also LinkedIn's biggest business, and includes all of the hiring and learning products, which you'll hear about in this episode. In our chat, Hari shares what he's seeing change in the hiring market, what you can do to improve your odds of finding a job through LinkedIn, what he's learned about building and maintaining really complex systems like LinkedIn, tips for getting into product management, and some lessons from his own course on product management. Plus, we also talk about how LinkedIn has been able to become a real source of valuable content and a lot less cringe over the past couple years, which I've definitely noticed and I share in our chat.

**中文翻译:**
Hari 在 LinkedIn 已经工作了八年半，目前担任产品副总裁，领导人才解决方案（Talent Solutions）产品团队。这是 LinkedIn 最大的业务板块，涵盖了所有的招聘和学习产品，你将在本集节目中听到相关内容。在我们的交谈中，Hari 分享了他观察到的招聘市场的变化、如何提高通过 LinkedIn 找工作的成功率、他在构建和维护像 LinkedIn 这样复杂系统方面的经验、进入产品管理领域的建议，以及他自己开设的产品管理课程中的心得。此外，我们还聊到了 LinkedIn 在过去几年里是如何成为有价值内容的真实来源，并且变得不再那么“令人尴尬”（cringe）的——这一点我深有体会，并在对话中分享了我的看法。

---

### [00:02:20] Lenny

**English:**
What a fun series of events that led to this episode. Big thank you to Jatin, hopefully, I'm pronouncing your name correctly, the guy behind the Curious PM account, for making this all happen. With that, I bring you Hari Srinivasan after a short word from our sponsors.

**中文翻译:**
这一系列促成这一集的事件真是太有趣了。非常感谢 Jatin（希望我没念错你的名字），也就是 Curious PM 账号背后的那位朋友，感谢你促成了这一切。在听完赞助商的简短介绍后，我们将请出 Hari Srinivasan。

---

### [00:02:35] Lenny (Sponsor: Miro)

**English:**
Today's episode is brought to you by Miro, an online collaborative whiteboard that's designed specifically for teams like yours. The best way to see what Miro is all about and how it can help your team collaborate better is not to listen to me talk about it, but to go check it out for yourself. Go to miro.com/lenny. With the help of the Miro team, I created a super cool Miro board with two of my own favorite templates, my one-pager template and my managing-up template, that you can plug and play and start using immediately with your team.

**中文翻译:**
本集节目由 Miro 赞助。Miro 是一款专为团队设计的在线协作白板。了解 Miro 及其如何帮助团队更好协作的最佳方式不是听我在这说，而是亲自去体验一下。请访问 miro.com/lenny。在 Miro 团队的帮助下，我创建了一个非常酷的 Miro 画板，里面包含了我最喜欢的两个模板：我的“一页纸计划书”模板和“向上管理”模板。你可以直接套用，立即开始与团队一起使用。

---

### [00:03:05] Lenny (Sponsor: Miro)

**English:**
I've also embedded a handful of my favorite templates that other people have published in the Miroverse. When you get to the board, you can also leave suggestions for the podcast, answer a question that I have for you, and generally just play around to get a sense of how it all works. Miro is a killer tool for brainstorming with your team, laying out your strategy, sharing user research findings, capturing ideas, giving feedback on wire frames, and generally just collaborating with your colleagues. I actually used Miro to collaborate with the Miro team on creating my own board, and it was super fun and super easy. Go check it out at miro.com/lenny. That's miro.com/lenny.

**中文翻译:**
我还嵌入了一些我最喜欢的、由其他人在 Miroverse 发布的模板。当你进入画板时，你还可以为播客留下建议，回答我提出的问题，或者只是随便玩玩，感受一下它的运作方式。Miro 是一个非常强大的工具，适用于团队头脑风暴、制定战略、分享用户研究结果、捕捉创意、对线框图提供反馈，以及与同事进行日常协作。实际上，我就是用 Miro 与 Miro 团队协作创建了我自己的画板，过程非常有趣且简单。快去 miro.com/lenny 看看吧。

---

### [00:03:45] Lenny (Sponsor: Brave Search)

**English:**
Today's episode is brought to you by Brave Search and their newest product, the Brave Search API, an independent global search index you can use to power your search or AI apps. If your work involves AI, then you know how important new data is to train your LLMs and to power your AI applications. You might be building an incredible AI product, but if you are using the same datasets as your competitors to train your models, you don't have much of an advantage.

**中文翻译:**
本集节目由 Brave Search 及其最新产品 Brave Search API 赞助。这是一个独立的全球搜索索引，你可以用它来驱动你的搜索或 AI 应用。如果你的工作涉及 AI，那么你一定知道新数据对于训练大语言模型（LLM）和驱动 AI 应用有多么重要。你可能正在构建一个了不起的 AI 产品，但如果你使用与竞争对手相同的数据集来训练模型，你就没有太大的优势。

---

### [00:04:11] Lenny (Sponsor: Brave Search)

**English:**
Brave Search is the fastest-growing search engine since Bing, and it's 100% independent from the big tech companies. Its index features billions of pages of high-quality data from real humans, and it's constantly updated thanks to being the default search engine in the Brave Browser. If you're building products with search capabilities, you're probably experiencing soaring API costs or lack of viable global alternatives to Bing or Google. It's only going to become harder to afford these challenges.

**中文翻译:**
Brave Search 是自 Bing 以来增长最快的搜索引擎，并且 100% 独立于大型科技公司。它的索引包含数十亿页来自真实人类的高质量数据，并且由于它是 Brave 浏览器的默认搜索引擎，因此数据会不断更新。如果你正在构建具有搜索功能的产品，你可能正面临 API 成本飙升或缺乏 Bing 或 Google 之外的全球替代方案的问题。应对这些挑战只会变得越来越难。

---

### [00:04:38] Lenny (Sponsor: Brave Search)

**English:**
The Brave Search API gives you access to its novel web-scale data with competitive features, intuitive structuring, and affordable costs. AI devs will particularly benefit from data containing thorough coverage of recent events. Lenny's Podcast listeners can get started testing the API for free at brave.com/lenny. That's brave.com/lenny.

**中文翻译:**
Brave Search API 让你能够以极具竞争力的功能、直观的结构和实惠的价格访问其新颖的网络规模数据。AI 开发者将特别受益于涵盖近期事件的详尽数据。Lenny 播客的听众可以在 brave.com/lenny 免费开始测试该 API。

---

### [00:05:04] Lenny

**English:**
How are you? Welcome to the podcast.

**中文翻译:**
你好吗？欢迎来到播客。

---

### [00:05:06] Hari Srinivasan

**English:**
Thanks for having me. Been a big fan for a long time.

**中文翻译:**
谢谢邀请。我是你的老粉丝了。

---

### [00:05:09] Lenny

**English:**
I really appreciate that. What a fun story behind this conversation. Let me just ask you, how did you feel when I cold-DMed on LinkedIn, asking you to be on this podcast because of a random tweet?

**中文翻译:**
非常感谢。这次对话背后的故事真有趣。我想问问，当我因为一条随机的推文在 LinkedIn 上给你发私信，邀请你参加这个播客时，你是什么感觉？

---

### [00:05:20] Hari Srinivasan

**English:**
I felt very honored. Again, I really have followed your work for a while. It's been really amazing to see what you've built, and I'm a huge fan of different builders. Also, it was a little bit of an honor that someone ... I know we're going to get into the story in a little bit. When you work on something, oftentimes jobs and learning, it's rare I think that it's in the influencer conversation. It's not necessarily something you or other people are properly experiencing on day-to-day. Sometimes, I don't know if we get to tell some of these stories, and I really appreciate you reaching out for that.

**中文翻译:**
我感到非常荣幸。再说一次，我关注你的工作已经有一段时间了。看到你所建立的一切真的很了不起，我是各种“构建者”（builders）的忠实粉丝。而且，这对我来说也是一种荣誉……我知道我们稍后会深入探讨。当你从事招聘和学习领域的工作时，这些话题很少会出现在网红或大 V 的讨论中。这不一定是大家每天都能切身体会到的东西。有时，我不知道我们是否有机会讲述这些故事，所以我非常感谢你为此联系我。

---

### [00:05:50] Lenny

**English:**
Yeah. Absolutely. I guess let me just give a big thank you to Jatin Rajvanshi, also known as The Curious PM, who tweeted about this concept and then is like, "Hey, talk to Hari about LinkedIn." Thank you, Jatin, for making this happen. It was all thanks to you. Usually, when this happens, someone tweets a recommendation of someone, they know each other. I'm like, "Eh, I don't know. This is some promotion of some other person." But you guys don't know each other, right?

**中文翻译:**
是的，没错。我想我要再次感谢 Jatin Rajvanshi，也就是 Curious PM，他发推提到了这个想法，然后说：“嘿，找 Hari 聊聊 LinkedIn 吧。”谢谢你，Jatin，促成了这一切。这全靠你。通常情况下，当有人在推特上推荐某人时，他们彼此是认识的。我通常会想：“呃，我不知道，这可能是在帮熟人做推广。”但你们两个并不认识，对吧？

---

### [00:06:15] Hari Srinivasan

**English:**
We don't, no. I'm looking forward to meeting you. Thank you, again, for putting in the word.

**中文翻译:**
不认识。我很期待见到他。再次感谢他帮我引荐。

---

### [00:06:20] Lenny

**English:**
Absolutely. Also, thank you to Jatin for recommending a bunch of questions that I'm going to ask you.

**中文翻译:**
当然。还要感谢 Jatin 推荐了一堆我要问你的问题。

---

### [00:06:26] Hari Srinivasan

**English:**
That I didn't know. Maybe I should've known. That I didn't know. Thanks, again, Jatin. It's very kind of you.

**中文翻译:**
这我倒不知道。也许我早该料到。我确实不知道。再次感谢 Jatin，你太客气了。

---

### [00:06:32] Lenny

**English:**
Yeah. Okay. Let's roll into some stuff. I actually want to start with LinkedIn as a platform broadly. I know you don't work on all parts of LinkedIn and don't necessarily know everything that's going on there, but something I've noticed that's pretty major is, it feels like LinkedIn's really made this move from being a very cringey place to post and spend time to, it's actually now interesting.

**中文翻译:**
好，那我们开始吧。我想先从 LinkedIn 作为一个整体平台聊起。我知道你并不负责 LinkedIn 的所有部门，也不一定了解那里发生的所有事情，但我注意到一个非常重大的变化：感觉 LinkedIn 真的已经从一个发帖和刷动态都让人觉得很“尴尬”的地方，变成了一个真正有趣的地方。

---

### [00:06:55] Lenny

**English:**
The feed that I see on LinkedIn is interesting. Oftentimes even more interesting than Twitter, which is crazy to say. Also, it's become the biggest source of traffic for my newsletter, more so than Twitter, which I never expected. My question is, as far as you know, what is it that y'all did right in the past couple years that has allowed for this shift to happen? Because this is very rare.

**中文翻译:**
我在 LinkedIn 上看到的动态很有趣。说起来可能有点疯狂，但有时甚至比 Twitter 还有趣。而且，它已经成为我时事通讯（newsletter）最大的流量来源，甚至超过了 Twitter，这是我从未预料到的。我的问题是，据你所知，你们在过去几年里做对了什么，才促成了这种转变？因为这种情况非常罕见。

---

### [00:07:18] Hari Srinivasan

**English:**
Well, first, I'm glad you're having a good experience with it. That's really, really kind to here. First of all, it's very interesting you hit on it. Everything at LinkedIn is a very connected ecosystem. One of the things that we always think about is how the whole system fits together. I'm sure we'll get into it more and more about how we build at LinkedIn, but how you make decisions based on the very complicated ecosystem is actually not very difficult because we're all here to help people connect to economic opportunity. Every time there's a discussion, something I'm really, really proud about working here is, everyone knows how that decision is going to be made. It's all about how we're connecting people to economic opportunity.

**中文翻译:**
首先，我很高兴你有这么好的体验。听到这个评价真的很开心。首先，你提到的这一点非常有趣。LinkedIn 的一切都是一个紧密相连的生态系统。我们一直在思考整个系统是如何协同工作的。我相信我们稍后会深入探讨 LinkedIn 的构建方式，但在如此复杂的生态系统中做决策其实并不难，因为我们的目标非常明确：帮助人们连接到经济机会。每当有讨论时，我在这里工作感到非常自豪的一点是，每个人都知道决策将如何制定——一切都围绕着如何将人们与经济机会联系起来。

---

### [00:07:55] Hari Srinivasan

**English:**
Now, it's funny. Just the other day, I was driving. I was in an Uber with the person who runs a feed. He's this guy, Kamesh, who's just phenomenal. We were just talking about this and one of the things he mentioned to me was, "If you think about what a feed is when it connects someone to opportunity, it's got to do a couple of things really, really well." We've done a ton of member surveys on this, a ton of thought behind it. The first is, as you make relationship connections across the way, that is a real way by which people get opportunity. They keep in touch with those people. They learn they might follow someone, and hopes in getting knowing them and getting that knowledge. We got to make sure that that content is getting to them.

**中文翻译:**
说来也巧，就在前几天，我正开着车，和负责动态消息（Feed）的主管 Kamesh 在一辆 Uber 里。他是个非常出色的人。我们正好聊到了这个话题，他对我提到：“如果你思考一个连接机会的动态流应该是什么样的，它必须在几件事上做得非常好。”我们为此做了大量的会员调查和深入思考。第一点是，当你建立人脉关系时，这是人们获得机会的真实途径。他们与这些人保持联系，学习知识，可能会关注某人，希望能了解他们并获取知识。我们必须确保这些内容能准确传达给他们。

---

### [00:08:29] Hari Srinivasan

**English:**
Then, when you think outside the network, we have to make sure that the things that people really want, which they keep saying are knowledge and advice and ability to get the real perspectives they need to get there, those are the things out of network they want. We've really, really been focused on driving those two systems. How does someone connect to opportunity both through the people and through the content that they actually want? As you know, when you do a feed, there's so many decisions that go into that complex system, so many decisions. But we've been really, really trying to make sure that we don't lose sight of that and start tuning all those knobs into that direction.

**中文翻译:**
然后，当你考虑到人脉网之外时，我们必须确保提供人们真正想要的东西——他们一直强调的是知识、建议以及获得实现目标所需的真实见解的能力。这些是他们希望从人脉网之外获得的东西。我们一直非常专注于驱动这两个系统：一个人如何通过“人”以及他们真正想要的“内容”来连接到机会？如你所知，做一个动态流涉及复杂系统中的无数决策。但我们一直在努力确保不偏离初衷，并将所有的调节旋钮都拨向那个方向。

---

### [00:09:04] Lenny

**English:**
If we're trying to get even more specific with what has changed, clearly there's been a focus internally. Is that true? There's just like, "Hey, let's make this feed a lot more interesting"? Or is this just a never ending and then it's actually started to work investment as far as?

**中文翻译:**
如果我们要更具体地探讨发生了什么变化，显然内部是有所侧重的。是这样吗？比如内部会说：“嘿，让我们把这个动态流做得更有趣一点”？还是说这只是一个永无止境的投入，而现在终于开始见效了？

---

### [00:09:19] Hari Srinivasan

**English:**
Well, there's always been a focus on connecting people to opportunity. There's always been a focus on that. I think what's happened over time is we've gotten more and more clear with what our members really want, which is this ability to feel close to those relationships and the ability to really get that knowledge that they need. As we've gotten better and clear in that understanding and we've been able to dial the knobs in the right way, I hope it's landing in the right place. I don't think it's any place near declaring victory in any part of this product.

**中文翻译:**
嗯，我们一直专注于将人们与机会联系起来。这一点从未改变。我认为随着时间的推移，我们越来越清楚会员真正想要的是什么，即那种与人脉关系保持亲近的能力，以及真正获取所需知识的能力。随着我们的理解变得更加透彻和清晰，并且能够以正确的方式调节各项参数，我希望它正朝着正确的方向发展。我不认为我们在该产品的任何部分已经接近宣布胜利。

---

### [00:09:46] Hari Srinivasan

**English:**
I think one of the beauty of working with that vision of connecting people to opportunity, there is always some piece of friction. There is always something we could be doing better. I'm always hesitant to say we've ever hit that bar, and I know there's probably people who listen to you who probably maybe have not had that experience. I always encourage you to reach out and let us know ways we can do better. But I'm glad you're having an experience with it. And then to your point, I always feel that as long as we stay focused on that and each of our decisions start moving in that direction, hopefully the product will continue to deliver.

**中文翻译:**
我认为，带着“连接机会”这一愿景工作的魅力之一在于，总会存在一些摩擦，总有一些我们可以做得更好的地方。我总是犹豫要不要说我们已经达到了那个标准，而且我知道听你节目的观众中可能有人并没有这种（好的）体验。我一直鼓励大家联系我们，告诉我们如何改进。但我很高兴你有了好的体验。回到你的观点，我始终觉得，只要我们保持专注，让每一个决策都朝那个方向迈进，产品有望继续发挥其价值。

---

### [00:10:14] Lenny

**English:**
Do you know if there's any product changes that have most contributed to that feed becoming much more interesting?

**中文翻译:**
你是否知道有哪些具体的产品改动对动态流变得更有趣贡献最大？

---

### [00:10:21] Hari Srinivasan

**English:**
Well, there a couple of things that I think are very special that we're working on and it's hard to say which is most, because a lot of these things obviously accumulate and compound over time. But certainly, there's a lot of machine learning and algorithms that go behind these systems. Many of them, as we start understanding that these are things that people get value by, it's about how do we make sure that we're giving people that interesting knowledge? As we've gotten crisper on what that means, I think we've been better able to build towards it.

**中文翻译:**
嗯，我们正在做的一些事情我认为非常特别，很难说哪一个贡献最大，因为很多事情显然是随着时间的推移而累积和叠加的。但可以肯定的是，这些系统背后有大量的机器学习和算法。当我们开始意识到哪些东西能让用户获得价值时，核心就在于：我们如何确保向人们提供那些有趣的知识？随着我们对这一点的定义越来越清晰，我认为我们已经能够更好地朝着这个方向构建产品。

---

### [00:10:50] Hari Srinivasan

**English:**
The other one, which is new, but I'm just particularly excited about, we're starting to do a lot of things which are gen AI-assisted. You basically can come in and get some prompts and people can bury their perspective on that. I think that combination, it's very early, but it's very exciting on how we might be able to help people unlock knowledge. There's almost a billion people now on the platform, knowledge of those billion people in a way that people can find and see.

**中文翻译:**
另一个是比较新的尝试，但我特别兴奋，那就是我们开始做很多生成式 AI（Gen AI）辅助的功能。你基本上可以进来获取一些提示词，然后人们可以基于此发表自己的见解。我认为这种结合虽然还处于早期阶段，但在如何帮助人们解锁知识方面非常令人兴奋。现在平台上拥有近 10 亿用户，我们要做的就是以一种可发现、可见的方式，挖掘这 10 亿人的知识。

---

### [00:11:12] Lenny

**English:**
Awesome. Again, I know this isn't the area you spend all your time on, but maybe one more question along these lines.

**中文翻译:**
太棒了。我知道这不是你投入全部精力的领域，但关于这一点我还有一个问题。

---

### [00:11:18] Hari Srinivasan

**English:**
Yeah, please.

**中文翻译:**
好的，请讲。

---

### [00:11:19] Lenny

**English:**
Yeah. Do you have any sense of the kind of content that works best on LinkedIn in terms of the algorithm you talk about? The algorithm is probably one of the bigger impact things that have changed.

**中文翻译:**
关于你提到的算法，你是否了解哪种类型的内容在 LinkedIn 上表现最好？算法可能是发生变化并产生重大影响的因素之一。

---

### [00:11:29] Hari Srinivasan

**English:**
If there's anything with knowledge or advice, I think that's what a lot of people are looking for. Every time we run these surveys, every time we talk to people on what they want, those are the things that really when you connect opportunity that people seek after in our system. You're a great example of that. You're able to give knowledge and advice in an area with a lot of depth. I think that maybe that's why you're having some of the success you're seeing on the platform, which is wonderful to see.

**中文翻译:**
如果是关于知识或建议的内容，我认为那是很多人正在寻找的。每当我们进行调查，每当我们询问用户想要什么时，这些都是人们在我们的系统中寻求机会时真正渴望的东西。你就是一个很好的例子。你能够在某个领域提供非常有深度的知识和建议。我想这可能就是你在平台上取得成功的原因，这真的很棒。

---

### [00:11:53] Lenny

**English:**
I think I'm actually not getting as much success as I could because I don't put in the time. I usually just post a simple thing with a link and I think I could be, if I really ... I just don't have time to do this of just like, post a lot more stuff within the actual post. I think that would do better.

**中文翻译:**
我觉得我其实还没有达到应有的成功程度，因为我投入的时间不够。我通常只是发一个简单的带链接的内容，我想如果我真的……我只是没时间去做，比如在帖子正文里发更多实质性的内容。我觉得那样效果会更好。

---

### [00:12:09] Hari Srinivasan

**English:**
That actually makes me happy. My guess is what you want to be doing is learning and creating and not spending a lot of time managing. Maybe that's actually a good thing. It's actually another wonderful thing to hear.

**中文翻译:**
这其实让我很高兴。我猜你真正想做的是学习和创作，而不是花大量时间去管理。也许这反而是件好事。这听起来也很棒。

---

### [00:12:20] Lenny

**English:**
Yeah, absolutely. Okay. Let's move to your sweet spot, which is the talent solution product? Is that what it's called?

**中文翻译:**
是的，没错。好，让我们转向你的擅长领域，也就是人才解决方案（Talent Solutions）产品？是这么叫的吗？

---

### [00:12:29] Hari Srinivasan

**English:**
Yeah. It's basically any product on LinkedIn that helps you get a job or learn a skill. We have products for recruiters and hires, jobs. We have products for job seekers. We have LinkedIn Learning and then certainly, we run a pretty large creator ecosystem for instructors who post content into LinkedIn Learning.

**中文翻译:**
是的。它基本上涵盖了 LinkedIn 上所有帮助你找工作或学习技能的产品。我们有面向招聘人员和雇主的招聘产品、职位发布产品；有面向求职者的产品；还有 LinkedIn Learning（领英学习），当然，我们还为在 LinkedIn Learning 上发布内容的讲师运营着一个相当大的创作者生态系统。

---

### [00:12:47] Lenny

**English:**
Is it true that this is the biggest business within LinkedIn?

**中文翻译:**
这是 LinkedIn 内部最大的业务板块，是真的吗？

---

### [00:12:50] Hari Srinivasan

**English:**
It is a very big business between LinkedIn. It's certainly hopefully something that, again, if you go back to that vision of connecting people to opportunity, it's certainly something that I like to think is very, very core to that, how people get jobs and learn skills.

**中文翻译:**
这确实是 LinkedIn 内部非常大的一块业务。当然，如果回到“将人们与机会联系起来”的愿景，我倾向于认为它是非常核心的部分——即人们如何获得工作和学习技能。

---

### [00:13:04] Lenny

**English:**
The feed gets all the glory and you guys are making all the money?

**中文翻译:**
所以动态流赢得了所有的名声，而你们赚走了所有的钱？

---

### [00:13:07] Hari Srinivasan

**English:**
I would not say that, but again, we joke about those things. It's so hard at LinkedIn to separate one product from the other. It's really the way we run. It's the way we think about the product. It's really the way we build. Let me just give you a super concrete example of that. Certainly, if you have someone coming in and looking at the feed, one thing we might do is suggest a job recommendation based on what they're looking for in that feed. Part of what we have to do is think about how someone who's looking at something in their interest might be driving their job-seeking experience as well.

**中文翻译:**
我可没这么说，不过我们确实经常开这种玩笑。在 LinkedIn，很难将一个产品与另一个产品完全分开。这就是我们的运作方式、思考产品的方式，也是我们的构建方式。让我给你举个非常具体的例子。当然，如果有人在刷动态流，我们可能会根据他们在流中查看的内容向其推荐职位。我们必须考虑，一个人在关注其兴趣内容时，如何同时驱动他们的求职体验。

---

### [00:13:38] Hari Srinivasan

**English:**
And then when they're looking for a job, it's very important that they know how they can actually get connected in that job. The relationship, the network you build are very much part of that flywheel that go into it. And then even as we start looking at this, you might be looking at a subject and then you want to go deeper on, and there's a course that comes into it as well. All of this to me is a very, very connected ecosystem on how those items work together in order to give people opportunity. We might think of it from the outset as very different things, but inside, even the way we operate and the way we think about it, it's a very, very connected ecosystem.

**中文翻译:**
当他们在找工作时，让他们知道如何真正建立与该职位的联系至关重要。你建立的关系和人脉网是这个飞轮的重要组成部分。甚至当我们深入观察时，你可能正在研究某个主题并想深入了解，这时就会涉及到相关的课程。对我来说，所有这些都是一个紧密相连的生态系统，这些元素共同作用，为人们提供机会。从外部看，我们可能认为它们是截然不同的东西，但在内部，无论是运作方式还是思考方式，它都是一个高度关联的生态系统。

---

### [00:14:15] Lenny

**English:**
What are the components again of this part of the org?

**中文翻译:**
这部分组织架构的具体组成部分有哪些？

---

### [00:14:18] Hari Srinivasan

**English:**
We think about it as two different marketplaces. There's a hiring marketplace, which is, how do we connect job seekers and recruiters and hiring managers? And then there's a learning marketplace, which is, how do you connect learners to instructors?

**中文翻译:**
我们将其视为两个不同的市场。一个是招聘市场，即我们如何连接求职者、招聘人员和招聘经理；另一个是学习市场，即如何连接学习者和讲师。

---

### [00:14:29] Lenny

**English:**
Got it. And then within hiring, are there subcomponents?

**中文翻译:**
明白了。那么在招聘业务中，还有子模块吗？

---

### [00:14:33] Hari Srinivasan

**English:**
Yeah. Again, we really think about it as a marketplace. We're generally organized around seekers and hires. There's a team that's working on a Recruiter, which is probably one of the more flagship products that LinkedIn has always been around, a team working on jobs, which is, if you ever post a job on LinkedIn, and then a team working to always help job seekers make sure they connect. And then on the other side for learners, instructors, the team working on LinkedIn Learning, which is one of the bigger enterprise learning products in the world. And then a team working to help instructors.

**中文翻译:**
有的。同样，我们真的把它看作一个市场。我们通常围绕“求职者”和“雇主”来组织。有一个团队负责 Recruiter（招聘人员版），这可能是 LinkedIn 一直以来最核心的旗舰产品之一；一个团队负责 Jobs（职位），也就是你在 LinkedIn 上发布职位的功能；还有一个团队致力于帮助求职者确保他们能建立联系。在另一边，针对学习者和讲师，有团队负责 LinkedIn Learning，这是全球最大的企业学习产品之一；还有一个团队专门负责帮助讲师。

---

### [00:15:02] Hari Srinivasan

**English:**
Many people don't know this. We actually have two large film studios. We bring in instructors. We film a lot of content. One's in Europe and one's in Santa Barbara. It was all started with the Lynda acquisition. We have a large team of content creators and teams, everyone from makeup artists to script writers, that we get to use over there.

**中文翻译:**
很多人不知道这一点。我们实际上有两个大型电影制片厂。我们会邀请讲师过来，拍摄大量内容。一个在欧洲，一个在圣巴巴拉。这一切都始于对 Lynda 的收购。我们拥有一支庞大的内容创作团队，从化妆师到剧本作家应有尽有。

---

### [00:15:22] Lenny

**English:**
Wow. It's just marketplaces all the way down as you talk about this. Hiring marketplace, learning marketplace, the feed itself. Probably more I'm not thinking about.

**中文翻译:**
哇。听你这么说，到处都是市场。招聘市场、学习市场、动态流本身。可能还有更多我没想到的。

---

### [00:15:31] Hari Srinivasan

**English:**
Yeah. It's very much the one model that we sometimes use internally as well is, how do we operate as marketplaces inside an ecosystem? I think it speaks to the complexity again of the product and hopefully somehow of how we might operate it.

**中文翻译:**
是的。我们内部有时也会使用这种模型：我们如何在生态系统内部作为多个市场来运作？我认为这再次说明了产品的复杂性，也体现了我们的运作方式。

---

### [00:15:46] Lenny

**English:**
I think with your vantage point at being at the center of hiring, a lot is changing within the hiring marketplace in the past, I don't know, year at this point, where it used to be very candidate-oriented, where they had all the power and they salaries were crazy. Everyone's bidding and trying to get people to join their company. Now, it's completely opposite. So many people looking, companies have all the power. I'm curious what you've seen, if that's roughly it, or what you're seeing basically in the hiring market these days.

**中文翻译:**
我想以你身处招聘核心的视角来看，招聘市场在过去一年左右发生了很大变化。以前是非常以候选人为中心的，他们掌握着主动权，薪水高得离谱。每个人都在竞价，试图吸引人才加入。现在完全相反了。求职者众多，公司掌握了主动权。我很想知道你观察到了什么，情况大致是这样吗？或者说你现在在招聘市场主要看到了什么？

---

### [00:16:15] Hari Srinivasan

**English:**
Yeah. Well, first of all, the balance that you're talking about, it is shifting in the sense that there are more seekers in the marketplace now and there are fewer open jobs in the marketplace. Of course, that changes how many applications you get for the job and how you have to look through. I think there's a model where people think it's drifting dramatically to exactly the way it was. I actually think some of the changes that occurred during the last couple of years are actually sticking around. Let me give you a couple examples of where things I think are really changing.

**中文翻译:**
是的。首先，你提到的这种平衡确实在发生转移，现在的求职者更多，而开放的职位更少。当然，这改变了每个职位收到的申请数量以及筛选方式。我认为有一种观点觉得市场正在剧烈地回到过去的状态。但我实际上认为，过去几年发生的一些变化其实保留了下来。让我给你举几个我认为正在发生真实变化的例子。

---

### [00:16:44] Hari Srinivasan

**English:**
The first thing that happened was, and maybe in my opinion, one of the big changes to the world that no one's really talking about it to my degree is the impact of it, but there's been a real move to skills-based hiring. For the longest time, and I'll give you actually a really concrete example, it was March 2020 and we were just watching COVID hit. It was just this heartbreaking moment where in the feed you were seeing all these people, by no fault of their own, starting to post that they've lost their job.

**中文翻译:**
发生的第一件事是——在我看来，这是世界上发生的一项重大变化，虽然没人像我这样强调它的影响——那就是向“基于技能的招聘”的真实转变。在很长一段时间里……我给你举个非常具体的例子。那是 2020 年 3 月，我们正目睹疫情爆发。那是一个令人心碎的时刻，在动态流中，你看到所有这些人，并非因为自己的过错，开始发帖说他们失业了。

---

### [00:17:09] Hari Srinivasan

**English:**
We started seeing in our data is you had some areas like maybe hospitality was really getting hit, but some areas like customer service that just couldn't hire enough. You'd think the marketplace would balance pretty quickly. You'd think, okay, maybe these people will start moving to other jobs, but it wasn't happening. A large reason behind this, people are used to looking for certain particular titles, and they didn't start realizing other people could do this job.

**中文翻译:**
我们从数据中看到，像酒店业这样的领域受到了沉重打击，但像客户服务这样的一些领域却招不到足够的人。你会认为市场会很快平衡。你会想，好吧，也许这些人会开始转向其他工作，但事实并非如此。这背后的一个重要原因是，人们习惯于寻找特定的职位头衔，而没有意识到其他背景的人也能胜任这些工作。

---

### [00:17:31] Hari Srinivasan

**English:**
We made a pretty big push in something we call skills-first hiring. This was the idea that we could translate people's experiences into a set of skills, and by that we could help them really start balancing the marketplace with a much different system. But instead of saying, "I need to have this talent," you can say, "I need someone who can do negotiation, and I need someone who can really help me understand how to deescalate a customer situation."

**中文翻译:**
我们大力推行了所谓的“技能优先招聘”。其核心理念是我们可以将人们的经历转化为一套技能，借此我们可以通过一套截然不同的系统来帮助市场实现平衡。不再是说“我需要这种人才”，而是说“我需要一个会谈判的人，我需要一个能真正帮我理解如何缓解客户冲突的人”。

---

### [00:17:54] Hari Srinivasan

**English:**
You find a lot of people in hospitality have about 70% of the skills you need for customer service and of course, you could train off the rest. We started seeing the skills-first hiring really start taking off. At this point, roughly 47% of our recruiters will come in, explicitly use skills when they start looking for candidates. That's a pretty big change that we're actually seeing hold. I know it's early in some of these changes, but it's a change where I think people are still continuing to start looking at skills.

**中文翻译:**
你会发现很多酒店业从业者拥有客户服务所需技能的 70% 左右，剩下的当然可以通过培训获得。我们开始看到技能优先招聘真正开始流行。目前，大约 47% 的招聘人员在寻找候选人时会明确使用技能作为筛选标准。这是一个相当大的变化，而且我们看到它正在持续。我知道其中一些变化还处于早期阶段，但我认为人们仍在继续转向关注技能。

---

### [00:18:20] Hari Srinivasan

**English:**
Another one was this concept of, there's a lot more people who are starting to look for jobs by values. They were saying, "Look, most job sites work by you come in and you look for a job and a title, and that's how you navigate the world." We started realizing a lot of people wanted to come in and instead of look at it like that, they may say, "Look, I really want a job. This aligned with my purpose." Or even by an interest, I may want something in AI. We started launching collections in the way to filter in these things. We're still seeing some of that usage today.

**中文翻译:**
另一个变化是，越来越多的人开始根据“价值观”来找工作。他们会说：“看，大多数招聘网站的运作方式是你进来找一个职位和头衔，这就是你探索世界的方式。”我们开始意识到很多人想换种方式，他们可能会说：“看，我真的很想要一份工作，但它得符合我的目标。”或者甚至根据兴趣，比如我想要一份关于 AI 的工作。我们开始推出“合集”（collections）功能来过滤这些内容。直到今天，我们仍然能看到这些功能的使用。

---

### [00:18:47] Hari Srinivasan

**English:**
I think that the job market is rebalancing, but it's being done, the pathways are being done in a very different way that seems to be maybe a change that holds through these ups and downs. That'll be very interesting to see.

**中文翻译:**
我认为就业市场正在重新平衡，但这种平衡正在以一种非常不同的方式进行，这种路径的变化似乎是一种能够经受住经济波动考验的持久改变。这将是非常有趣的观察点。

---

### [00:18:58] Lenny

**English:**
What's interesting is it's not like this would change on its own. You're the biggest jobs marketplace in the world, right?

**中文翻译:**
有趣的是，这种变化并不是自发产生的。你们是全球最大的就业市场，对吧？

---

### [00:19:08] Hari Srinivasan

**English:**
We have a lot of professional jobs on our platform and a lot of professional seekers.

**中文翻译:**
我们的平台上有很多专业职位，也有很多专业求职者。

---

### [00:19:11] Lenny

**English:**
Hopefully, mysterious. I imagine it is. I don't know. I guess Indeed might be a competitor, but okay, let's say it's one of the bigger job markets. You influenced the way jobs are sought and posted and how people find jobs; so in a sense, designing. Sounds like basically, there was an internal decision. Let's focus on the skills approach. What's cool about that is that changes the way hiring happens in the world.

**中文翻译:**
我猜确实如此。我不知道，Indeed 可能是竞争对手，但好吧，就算它是最大的就业市场之一。你们影响了职位的搜索、发布以及人们找工作的方式；所以从某种意义上说，你们在进行“设计”。听起来基本上是内部做了一个决定：让我们专注于技能导向的方法。酷的地方在于，这改变了全世界招聘发生的方式。

---

### [00:19:33] Hari Srinivasan

**English:**
It's one of the things that I think is so interesting about building products today is, it has to clearly be something people want. If we had just said we're going to go like this, and every hire was like, "I don't want to do this," or every job seeker said, "I don't care about it," I don't think anything would click. We also have to be receptive enough to amplify that signal and allow it to work through a system so that it could actually be easy to use.

**中文翻译:**
我认为当今构建产品最有趣的一点是：它必须是人们真正想要的东西。如果我们只是单方面宣布要这么做，而每个雇主都说“我不想这么做”，或者每个求职者都说“我不在乎”，那什么都不会发生。我们还必须足够敏锐，去放大那些信号，并让它们在系统中运作，从而使其真正变得易于使用。

---

### [00:19:56] Hari Srinivasan

**English:**
I don't think we said that, "Hey, we got to go and do this value-based thing." I think we started feeling it and hearing it from members and then as we adapted, these things start amplifying as they come through. I do think that's hopefully something that I think about a lot is, let's just make sure that we keep a pulse on what people want and we make sure that we can get that through a system at a pretty fast pace. Because then, we will hopefully continue to be a place where people want to go look for jobs and make hires.

**中文翻译:**
我不认为我们是直接说：“嘿，我们必须去做这个基于价值观的东西。”我认为我们是开始从会员那里感受到并听到这种需求，然后随着我们的调整，这些东西在通过系统时开始被放大。我确实经常思考这一点：让我们确保时刻把握人们的需求脉搏，并确保我们能以相当快的速度通过系统实现它。因为只有这样，我们才能继续成为人们想要寻找工作和进行招聘的地方。

---

### [00:20:25] Lenny

**English:**
What I was thinking about as you were just chatting is this open to work feature that LinkedIn has. I remember days before that existed and people used to just like jury-rig, "Hey, I'm hiring," or, "I'm looking for a job." There's always this sense that if you're open to work, you're not as good. Because why would you be amazing and open to work and not hired? I'm curious if you were even part of this experience. Just, what was it like to come up with that approach to how to communicate that you're open to work?

**中文翻译:**
刚才你聊天时我在想 LinkedIn 的“开启求职状态”（Open to Work）功能。我记得在这个功能出现之前，人们总是用各种土办法，比如写着“嘿，我在招人”或者“我在找工作”。以前总有一种感觉，如果你公开表示自己在找工作，就说明你不够优秀。因为如果你真的很出色，怎么会处于待业状态呢？我很好奇你是否参与了这个过程。想出这种沟通“求职意向”的方式是什么样的体验？

---

### [00:20:51] Hari Srinivasan

**English:**
It's been through phases and I think those phases really reflect on the perception of how it's changed. In the beginning it was, you could say you're open to work, but it was a secret signal to recruiters if you will. That certainly still exists, but now we said you could more publicly say it and maybe it'd be a feed post. And then we started launching it. Actually it was around COVID when a lot of the stigmas of unemployment changed dramatically, because everyone started understanding you're in this different situation. We started putting it the frame and that's the more iconic way I think people associate with now.

**中文翻译:**
它经历过几个阶段，我认为这些阶段真实反映了人们观念的变化。最开始，你可以说自己正在找工作，但那只是给招聘人员的一个“秘密信号”。这当然现在还存在，但后来我们说你可以更公开地表达，也许是发一条动态。然后我们开始正式推出它。实际上是在疫情期间，失业的污名化发生了巨大改变，因为每个人都开始理解大家处于这种特殊的境地。我们开始加上那个头像框，我想这就是现在人们最熟悉的标志性方式。

---

### [00:21:22] Hari Srinivasan

**English:**
It's funny. Just this week, we tried something new and I feel like it's almost the same journey. There are many customers as you can imagine, that have LinkedIn Learning and LinkedIn Learning is typically an enterprise product. It works across your employee base. We're trying to do Open to Internal Work where you can say, "I'm actually at the point where I may want the next play internally in my role," and an internal recruiter can see you. As you can imagine, I would actually even maybe argue more stigma about being concerned about upsetting your manager. Certainly, there's different cultures and companies about this.

**中文翻译:**
很有趣，就在本周，我们尝试了一些新东西，我觉得这几乎是同样的历程。如你所知，有很多客户购买了 LinkedIn Learning，这通常是一个企业级产品，面向全体员工。我们正在尝试“开启内部求职意向”（Open to Internal Work），你可以说：“我目前可能想在公司内部寻找下一个机会”，这样内部招聘人员就能看到你。你可以想象，我甚至认为这比外部求职更有“污名感”，因为人们会担心惹恼自己的经理。当然，不同的公司文化对此有不同的看法。

---

### [00:21:52] Hari Srinivasan

**English:**
I have a feeling in sometimes we like to think five, 10 years out, I think it's going to go on the same journey. That's one hunch I have, that there'll also be an employment-driven way internally for people to find their next play. It'll be interesting to see how it plays out, but already you can feel a little bit of that tension right when we launched it and knowing. Let's see how this goes.

**中文翻译:**
我有一种感觉，有时我们喜欢展望 5 到 10 年后的情况，我认为它会经历同样的历程。这是我的一个直觉：未来也会有一种由内部就业驱动的方式，让人们寻找下一个岗位。看看它会如何发展将非常有趣，但在我们刚推出它时，你已经能感受到那种紧张感了。让我们拭目以待。

---

### [00:22:13] Lenny

**English:**
You were talking about how hiring is changing. I'm curious how PM hiring specifically is changing. A lot of people listening to this podcast are product managers. Is there anything unique you're noticing there?

**中文翻译:**
你刚才谈到了招聘的变化。我很好奇产品经理（PM）的招聘具体发生了什么变化。听这个播客的很多人都是产品经理。你有没有注意到什么独特的地方？

---

### [00:22:22] Hari Srinivasan

**English:**
Maybe a couple stats that could be very helpful. If you're having a hard time finding a PM role, let's start with this, you're probably not alone. We publish it. You can go to Economic Graph data. This is all public. We publish this. But if you look at tech, it's down about 50% year-over-year. We look at hires over total population on LinkedIn. You can go to Economic Graphs and you can see how it compares trends industry. We don't look at the functional data as much, but the PM data seems to be trending just slightly even maybe below software engineers and data as well, which is maybe a comp for this. I know not everything is perfect industry to function cuts.

**中文翻译:**
也许有几个数据会很有帮助。首先，如果你现在很难找到 PM 职位，你并不孤单。我们发布了相关数据，你可以去查看“经济图谱”（Economic Graph）数据，这些都是公开的。如果你看科技行业，招聘量同比下降了约 50%。我们观察 LinkedIn 总人口中的招聘比例，你可以去经济图谱看它与行业趋势的对比。我们不怎么看具体的职能数据，但 PM 数据的趋势似乎略低于软件工程师和数据岗位。我知道行业和职能的划分并不总是完美的。

---

### [00:22:56] Hari Srinivasan

**English:**
It is a difficult place, but I'll give you a couple tips because I imagine that may be helpful for a couple of the listeners. It's certainly one of the larger inbounds of things I get. The first is, in those markets, you do want to make sure that the more you can do to form relationships and say that this is what you can do, which is always helpful. Now, I know that not everyone has relationships, but you can always try to develop those at different places and across LinkedIn as well. But that's one thing I would really, really start to look for.

**中文翻译:**
现在的处境确实很难，但我会给你几个建议，因为我想这对听众会有帮助。这也是我收到的最多的咨询之一。第一，在这样的市场中，你要确保尽力建立人脉关系，并展示你的能力，这总是有帮助的。我知道不是每个人都有现成的人脉，但你总是可以尝试在不同场合以及通过 LinkedIn 来建立人脉。这是我非常建议开始做的一件事。

---

### [00:23:24] Hari Srinivasan

**English:**
The second thing I would really do is we have launched the way now to come in and signal obviously that you are interested in a role. We have those open to work capabilities, but then each job has a set of skills that they're looking for under it, like we talked about in skills-first hiring. Against each skill, you can actually add different kinds of credentials. I would really encourage people to add work products if that's something that they're actually building. You can add different kinds of recommendations or other things they can associate with that skill. Those credentials against it I think are becoming much more interesting for people to say, "Oh, this is someone I'm actually looking for."

**中文翻译:**
第二件事是，我们现在推出了一种方式，可以让你明确表达对某个职位的兴趣。除了“开启求职状态”功能外，每个职位下方都有一组所需的技能，就像我们讨论过的“技能优先招聘”一样。针对每项技能，你实际上可以添加不同类型的凭证。我非常鼓励大家添加“工作产出”（work products），如果你真的构建了什么东西的话。你可以添加不同类型的推荐信或其他与该技能相关的东西。我认为这些针对技能的凭证正变得越来越吸引人，让招聘者觉得：“哦，这就是我要找的人。”

---

### [00:23:55] Hari Srinivasan

**English:**
And then the third thing I would really encourage PMs to start looking through is, this is probably more personal than anything in data, but every PM job is different. If you have experience in that industry and you're able to show that you have experience in that industry or some kind of understanding of it, I think that's a way to separate. I'd really start zoning in on roles where you might see if you don't have the functional experience, the industry experience. I think that would go a long way as how to help you differentiate from yes, what's probably more candidates, or more applications going into each role.

**中文翻译:**
第三点，我非常鼓励 PM 们去思考的是——这可能更多是我个人的看法而非数据结论——每个 PM 岗位都是不同的。如果你在某个行业有经验，并且能够展示出这种行业经验或理解，我认为这是一种脱颖而出的方式。如果你缺乏特定的职能经验，我建议你专注于那些你拥有行业背景的职位。我认为这能极大地帮助你从众多的候选人或申请中区分开来。

---

### [00:24:30] Lenny

**English:**
When you say industry experience, what's an example of that?

**中文翻译:**
当你提到行业经验时，能举个例子吗？

---

### [00:24:32] Hari Srinivasan

**English:**
Imagine that you are applying for a PM role, but that particular software is in, I don't know, automotive tech. If you happen to have worked in automotive before, have a knowledge about cars, that's a very helpful way to get in. I think if you're able to show that you can show an industry knowledge and an understanding of it, I think it's a real nice way to think about how to position yourself against some of the other candidates.

**中文翻译:**
想象一下你正在申请一个 PM 职位，但那个软件是关于汽车科技的。如果你以前在汽车行业工作过，对汽车有了解，那将是非常有帮助的敲门砖。我认为如果你能展示出行业知识和理解，这在与其他候选人竞争时是一个非常好的自我定位方式。

---

### [00:24:55] Lenny

**English:**
What else can that person looking for a job do to improve their chances of a recruiter basically finding them? I feel like that's probably the best tactical thing they can do because a lot of LinkedIn is recruiters reaching out and finding you.

**中文翻译:**
求职者还能做些什么来提高被招聘人员发现的机会？我觉得这可能是他们能做的最好的战术动作，因为 LinkedIn 的很大一部分功能就是招聘人员主动联系并找到你。

---

### [00:25:08] Hari Srinivasan

**English:**
There's two things that anyone who's hiring is always going to look for. They're going to look for your skills and capabilities and they're going to look for your intent and interest in the role. A lot of our products and the pathways we try to do are making those things simpler. Maybe we'll just start with interest and we'll move back to skills in a minute. A couple of things we've launched recently, and I think they are symbolic of other ways you can connect. If you go to a company page and you're looking at the company, and I think they have to opt into this in some degree, look, you can say you're interested in that company even though they don't have roles. When the next role comes up, they'll have a signal that this person is actually very interested in this role.

**中文翻译:**
任何招聘的人都会寻找两样东西：你的技能与能力，以及你对该职位的意向与兴趣。我们的很多产品和路径都在努力简化这些事情。我们先从“兴趣”开始，稍后再回到“技能”。我们最近推出了一些功能，我认为它们代表了建立联系的其他方式。如果你去一个公司主页，即使他们目前没有职位空缺，你也可以表示你对该公司感兴趣（这需要公司端开启此功能）。当下一个职位出现时，他们就会收到信号，知道这个人对该职位非常感兴趣。

---

### [00:25:42] Hari Srinivasan

**English:**
That's an easy way to signify from an early stage that you have interest in them. That way, when they open up a role, as you can imagine, they start looking through, they'll have a spotlight on recruiter and they can click out on it and come through. Certainly, you can go into open work and say that this is something that I'm open to work right now, and you can signify to the whole population that this is an area that you want to go for as well. I would encourage both of those in some ways. If you're looking for a role, be open about it and tell the companies that you're looking for it. Those are really high signals of intent.

**中文翻译:**
这是一种在早期阶段表达兴趣的简便方法。这样，当他们发布职位并开始筛选时，招聘人员版（Recruiter）中就会有一个高亮提示，他们可以点击查看。当然，你也可以开启“求职状态”，向所有人表明你目前正在寻找机会。在某种程度上，我鼓励这两者并行。如果你在找工作，就表现得坦诚些，告诉公司你在找。这些都是非常强烈的意向信号。

---

### [00:26:09] Hari Srinivasan

**English:**
The other thing you can do on LinkedIn is you can actually go through when you say open to work and you can specify particular kinds of jobs and things you're looking for. I think that more detailed intent helps make sure you're showing it to the right place. On the skill side, we talked about it a little bit, but I do think there's a big change. When you were just looking at title, I think you only had one way to really prove that you had the skills. You had to have that title, which is very hard to break in. In a world where you're looking at skills, you can go through and say, "Look, I can do these things and you could put evidence behind it."

**中文翻译:**
在 LinkedIn 上你还可以做的另一件事是，当你开启求职状态时，你可以指定你正在寻找的具体工作类型。我认为更详细的意向有助于确保你被展示在正确的地方。在技能方面，我们刚才聊了一点，但我认为这里有一个巨大的变化。当你只看头衔时，你证明自己拥有技能的唯一方式就是拥有那个头衔，这很难突破。但在一个看重技能的世界里，你可以说：“看，我能做这些事”，并且你可以为此提供证据。

---

### [00:26:56] Hari Srinivasan

**English:**
I'd really encourage people to do that. If you just go to any job post, you can see the skills, you can say add and you can see all the evidence and how you can add it. I would really encourage people to do that because when people are in recruiter and they're looking for skills, profiles pop up and you can scroll over a skill and you can actually see all those evidences. Basically, a recruiter could say, "Oh, this is why I'd recommend you to this hiring manager." I think you will find that that's hopefully a very useful way of doing it.

**中文翻译:**
我非常鼓励大家这样做。如果你去任何一个职位发布页面，你可以看到所需技能，点击“添加”，你就能看到所有的证据以及如何添加它们。我非常鼓励大家这样做，因为当招聘人员在 Recruiter 中搜索技能时，个人资料会弹出，他们可以悬停在某项技能上，看到所有的证据。基本上，招聘人员可以说：“哦，这就是为什么我要向招聘经理推荐你。”我想你会发现这是一种非常有用的方式。

---

### [00:27:05] Lenny

**English:**
I'm going to lob this question like a fishing line, to see if it catches anything. And if not, we'll move on. Are there any stats that you've seen of just like if you do X, Y, Z, your chances of getting hired or getting people reaching out just go significantly higher?

**中文翻译:**
我要抛出一个问题，像钓鱼一样看看能不能钓到什么。如果没有，我们就继续。你有没有看到过类似“如果你做了 X、Y、Z，你被录用或被联系的机会就会显著提高”的数据？

---

### [00:27:20] Hari Srinivasan

**English:**
Open to work certainly has a high signal to noise. As you can imagine, when someone's looking to fill a role, that's one they want. We are early in company commitments, but we are seeing some signal there that we got to move through it. Skills has a pretty high signal as well, when you're able to come through and show and demonstrate your skills. We're seeing some correlation to basically people getting a role.

**中文翻译:**
“开启求职状态”肯定具有很高的信噪比。你可以想象，当有人想填补空缺时，这就是他们想要的信号。我们在“公司承诺”方面还处于早期阶段，但我们已经看到了一些信号。当你能够展示并证明你的技能时，“技能”也具有相当高的信号价值。我们看到这与人们最终获得职位之间存在一定的相关性。

---

### [00:27:41] Hari Srinivasan

**English:**
And then the final one that is harder for us to look through, but it's certainly important. I do think we show the hiring manager on a lot of the roles. We show these people through. It's harder for us to trace that because of the way the outcomes work, but I would really encourage people to look through that and see if you can get in front of those people.

**中文翻译:**
最后一点对我们来说比较难追踪，但它肯定很重要。我认为我们在很多职位上都会显示招聘经理是谁。由于结果反馈机制的原因，我们很难追踪这一点，但我真的鼓励大家去看看，看看你是否能直接接触到那些人。

---

### [00:27:58] Lenny

**English:**
Is there a max seniority that you find works effectively on LinkedIn to find a job? I imagine CPOs aren't finding jobs on LinkedIn. If I'm looking for a job, do you have a rule of thumb of, if you're at this level, maybe you're not going to have a lot of luck? If you're below the-

**中文翻译:**
你是否发现 LinkedIn 找工作存在一个“职级上限”？我猜首席产品官（CPO）可能不会在 LinkedIn 上找工作。如果我在找工作，你有没有一个经验法则，比如到了某个级别，可能运气就不会那么好了？如果你低于……

---

### [00:28:15] Hari Srinivasan

**English:**
We certainly have CPO jobs that are posted, but the difference often is job posts versus recruiting. More and more senior roles are often recruited. We find that people will use LinkedIn in order to connect to a CPO and many people who are senior will say, "Oh, I got a message on LinkedIn and that led to this," or they made a long-term recruiting contact. But it may not happen through you finding a job and hitting the application button.

**中文翻译:**
我们确实有 CPO 的职位发布，但区别通常在于“职位发布”与“主动猎聘”。越高级的职位通常越依赖猎聘。我们发现人们会使用 LinkedIn 来联系 CPO，许多高管会说：“哦，我在 LinkedIn 上收到一条消息，然后就促成了这件事”，或者他们建立了一个长期的招聘联系。但这可能不是通过你主动搜索职位并点击“申请”按钮来实现的。

---

### [00:28:38] Lenny

**English:**
Let's talk about LinkedIn as a company to work in, the culture maybe for a bit. You told me that you have a story about your first product review when you joined LinkedIn and how that was wild. Can you just tell that story? I haven't heard this yet.

**中文翻译:**
让我们聊聊 LinkedIn 这家公司，聊聊它的文化。你告诉我，你有一个关于刚加入 LinkedIn 时第一次产品评审的故事，而且非常疯狂。你能讲讲吗？我还没听过。

---

### [00:28:51] Hari Srinivasan

**English:**
Yeah. I came through a small acquisition that they made of our company, and I thought it was such a telling moment in this first product review. I went in and as you can imagine when you join a company, there's a lot of advice on how you should make that product work. I didn't know anything. I'd never been a PM. I remember taking a lot of that advice and putting together a presentation and just getting destroyed during that review. I think Jeff was the head of product and CEO at that point. In a very kind way, it was basically like, "Wait, this doesn't make any sense."

**中文翻译:**
是的。我是通过公司被收购加入 LinkedIn 的，我认为第一次产品评审是一个非常有代表性的时刻。我进去了，你可以想象，当你加入一家公司时，会有很多人建议你该如何做产品。我当时什么都不懂，以前从未当过 PM。我记得我采纳了很多建议，做了一个演示文稿，结果在评审中被批得体无完肤。我想当时 Jeff（Weiner）是产品负责人兼 CEO。他以一种非常委婉的方式表达，基本上就是说：“等等，这根本说不通。”

---

### [00:29:23] Hari Srinivasan

**English:**
I just remember driving home and calling my wife and like, "I think I might be fired." I'm not sure if I was fired, but he was very kind about it. He's like, "Just come back and exit." I think five, four weeks. I remembered at that point I was like, if you're going to go in and you know you only have one shot, just do something you believe in and make sure it works. We started from that point and we worked backwards from there in this concept of, "Hey, I do believe that the most important thing is connecting to opportunity and we should really understand how to do that. Let's just start from there." It went very well.

**中文翻译:**
我只记得开车回家时给妻子打电话说：“我觉得我可能要被开除了。”我不确定我是否真的会被开除，但他表现得很友善。他说：“回去再准备一下。”大概过了四五周。我记得当时我想，如果你只有一次机会，那就做你真正相信的事情，并确保它行得通。我们从那时开始，从“我相信最重要的事情是连接机会，我们应该真正理解如何做到这一点”这个理念出发，倒推工作。结果非常顺利。

---

### [00:29:50] Hari Srinivasan

**English:**
To me, it was another way of you're in these large systems, you're in these large companies, you're in these large ... I think LinkedIn is very special because no matter what it is, it's got a very good North Star. It was a moment for me to really hammer that home, that as long as you get that North Star ahead of you, you're going to be just fine. I never worked at a place like that before, and I think a lot of times people wonder. You can imagine. The way we're talking about, we certainly have an engagement ecosystem. We have the hiring business and we have a marketing solutions business. We have a big premium business.

**中文翻译:**
对我来说，这是在大型系统、大型公司中工作的另一种方式……我认为 LinkedIn 非常特别，因为无论发生什么，它都有一个非常明确的“北极星指标”。那个时刻让我深刻意识到，只要你心中有那个北极星，你就不会有问题。我以前从未在这样的地方工作过。你可以想象，我们有用户参与生态系统，有招聘业务，有营销解决方案业务，还有庞大的高级会员业务。

---

### [00:30:24] Hari Srinivasan

**English:**
You can imagine when you're trying to make decisions across that, it could get very, very complicated. I think when people ask me to describe LinkedIn, I often start with that story because I feel like it helps cut through how decisions are made and what is seen as success here.

**中文翻译:**
你可以想象，当你要跨越这些业务做决策时，情况会变得非常复杂。当人们让我描述 LinkedIn 时，我经常以这个故事开头，因为我觉得它有助于解释决策是如何做出的，以及在这里什么被视为成功。

---

### [00:30:39] Lenny

**English:**
Just to clarify, so that North star is that phrase that you used of just connecting people to economic opportunity?

**中文翻译:**
澄清一下，那个“北极星”就是你刚才用的那个短语——“将人们与经济机会联系起来”？

---

### [00:30:45] Hari Srinivasan

**English:**
That's it. That's it. I know it sounds bigger than it seems, but I can probably ... Time example again. You can understand when someone's driving on it. Having been here for a little bit now, you can understand when someone knows that and when someone doesn't. It's a hard thing to lose track of.

**中文翻译:**
没错。就是它。我知道这听起来比实际意义更宏大，但我可以……再举个例子。你能看出谁是在朝着这个目标努力。在这里工作了一段时间后，你能分辨出谁理解这一点，谁不理解。这是一个很难被忽视的目标。

---

### [00:31:00] Lenny

**English:**
Yeah. It does sound vague and a nice, fuzzy, warm thing that people can say. What you're saying is that it's actually brought up in meetings constantly and product reviews. You're saying in this product review, everything changed when you came at it from that one perspective?

**中文翻译:**
是的。它听起来确实有点模糊，像是那种人们随口说说的好听话。但你的意思是，它实际上在会议和产品评审中被不断提及。你是说在那次产品评审中，当你从那个视角出发时，一切都改变了？

---

### [00:31:16] Hari Srinivasan

**English:**
Yeah. My first product here was the profile. You can make a profile that does a lot of different things, as you can imagine. You could think about how identity could be used in many different phases and what you should prioritize and not. But if you can explain why this is the thing that you should do that would help someone really do what they want to do, maybe it's have an incredible podcast and send that out there, maybe it's helping someone connect to a job. But if you can understand intent and how this is unblocked and why you want to prioritize that item, all of a sudden the world gets a lot simpler.

**中文翻译:**
是的。我在这里负责的第一个产品是“个人资料”（Profile）。你可以想象，个人资料可以做很多不同的事情。你可以思考身份如何在不同阶段被使用，以及应该优先考虑什么。但如果你能解释为什么做这件事能帮助某人实现他们的目标——也许是做一个了不起的播客并传播出去，也许是帮助某人找到工作——如果你能理解意图、如何打通路径以及为什么要优先考虑该项，突然之间，世界就变得简单多了。

---

### [00:31:51] Hari Srinivasan

**English:**
How does that actually get operationalized at a company? Is it just the leaders remind people of that? It's painted on the walls? How is that a thing that people come back to over and over?

**中文翻译:**
这在公司里是如何具体运作的？只是领导不断提醒大家吗？还是刷在墙上？人们是如何一遍又一遍地回到这个原点的？

---

### [00:32:01] Hari Srinivasan

**English:**
I do think it's a lot of repeat, repeat, repeat. I do think that's it. I do think the culture has a pretty high immune system now in the sense that when you aren't operating by that, people can see it and they operate against it. I think when Jeff was CEO, and Ryan, they are just exceptional at continuously repeating that. It's been so consistent for so long that I think it's just the DNA now. I do think it's exceptional. I think it's exceptional leadership, and I've learned so much from watching it and how it gets operated.

**中文翻译:**
我认为是大量的重复、重复、再重复。就是这样。我认为现在的公司文化已经有了一套很强的“免疫系统”，当你没有按照这个原则运作时，人们能看出来并抵制它。我认为当 Jeff 担任 CEO 时，以及现在的 Ryan，他们都非常擅长不断重复这一点。这种一致性保持了这么久，以至于它已经成为了 DNA。我认为这非常了不起，是卓越的领导力，我从观察它的运作中学到了很多。

---

### [00:32:34] Lenny

**English:**
Is there a metric associated with that when people use it in a way of like, no, that's not actually what we mean? Is there some way of making it even more concrete in goals, metrics, ways to understand if people are actually achieving that?

**中文翻译:**
有没有与之相关的指标？当人们偏离轨道时，有没有什么方法可以把它变得更具体，比如目标、指标，或者衡量人们是否真正实现了它的方法？

---

### [00:32:46] Hari Srinivasan

**English:**
Yeah. Totally. I think at the next level of operation, what we think about is, when we run these marketplaces throughout this ecosystem that connect people to opportunity, what are the outputs that they measure? I'll just give you mine for example. We think a lot about number of hires, converting hires. How many people did we match? Which is a real tangible way of looking at opportunity.

**中文翻译:**
有的，完全有。我认为在操作层面，我们思考的是：当我们在整个生态系统中运行这些连接机会的市场时，衡量的产出是什么？以我的团队为例，我们非常关注“招聘人数”和“转化招聘数”。我们匹配了多少人？这是一种衡量机会的非常直观的方式。

---

### [00:33:04] Hari Srinivasan

**English:**
And then number of people who learned a skill, which is usually in this world measured more by time than anything if you learn. Spend time for X amount of minutes. We do that skill because oftentimes skills don't have a direct outcome as you can measure to go through. We basically look at those things more than any other to say how successful that we are operating that marketplace.

**中文翻译:**
然后是“学习了一项技能的人数”，在学习领域，这通常更多地通过时间来衡量。比如学习了多少分钟。我们关注技能，是因为技能往往没有一个可以直接衡量的结果。我们主要通过这些指标来判断我们在运营该市场方面有多成功。

---

### [00:33:22] Lenny

**English:**
Got it. Those make total sense to me.

**中文翻译:**
明白了。这对我来说非常有意义。

---

### [00:33:24] Hari Srinivasan

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:33:24] Lenny

**English:**
Are there other core values of LinkedIn that are public that you can share?

**中文翻译:**
LinkedIn 还有其他公开的核心价值观可以分享吗？

---

### [00:33:28] Hari Srinivasan

**English:**
You can Google them too and so they're very, very public, but probably the one that I think is most important to talk about in this world is, there's this concept of members first. I think anytime you run an ecosystem as complex as we do and you think about it, even if you're trying to connect people to opportunity, there's two people, how are you going to decide right now who needs it?

**中文翻译:**
你也可以去 Google，它们是非常公开的。但在目前这个语境下，我认为最重要的一点是“会员第一”（Members First）。我认为当你运行一个像我们这样复杂的生态系统时，即使你试图连接机会，通常也涉及两方，你如何决定现在谁更需要它？

---

### [00:34:05] Lenny

**English:**
Yeah, I see it on the page here. We put members first.

**中文翻译:**
是的，我在这里的页面上看到了。我们把会员放在第一位。

---

### [00:34:10] Hari Srinivasan

**English:**
Story checks out is what you're telling me.

**中文翻译:**
看来我没编故事。

---

### [00:34:11] Lenny

**English:**
Checks out. Checks out. What's interesting is the connecting people to opportunity, economic opportunity is not one of these values. It seems like it's even broader. They should at the company basically.

**中文翻译:**
确实如此。有趣的是，“将人们与机会、经济机会联系起来”并不在这些价值观里。它似乎更宏大，是公司的使命。

---

### [00:34:21] Hari Srinivasan

**English:**
The company, yeah.

**中文翻译:**
是公司的使命，没错。

---

### [00:34:23] Lenny

**English:**
Got it. I love that. This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern growth team stack. This leads to waste of time building internal tools or trying to run your own experiments through a clunky marketing tool.

**中文翻译:**
明白了。太棒了。本集节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 AB 测试平台。DraftKings、Zapier、ClickUp、Twitch 和 Cameo 等公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能与现代增长团队的技术栈完美集成。这导致人们要么浪费时间构建内部工具，要么试图通过笨重的营销工具运行实验。

---

### [00:34:52] Lenny (Sponsor: Eppo)

**English:**
When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform, where I was able to slice and dice data by device types, country, user stage. Eppo does all that and more, delivering results quickly, avoiding knowing prolonged analytics cycles, and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic clickthrough metrics and instead, use your North Star metrics, like activation, retention, subscription, and payments. Eppo supports test on the front end, on the back end, email marketing, even machine learning claims. Check out Eppo geteppo.com. That's geteppo.com and 10X your experiment velocity.

**中文翻译:**
当我在 Airbnb 时，我最喜欢的工作内容之一就是我们的实验平台，我可以在那里按设备类型、国家、用户阶段对数据进行切片分析。Eppo 实现了这一切甚至更多，它能快速交付结果，避免漫长的分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基本的点击率指标，转而使用你的北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习方案的测试。访问 geteppo.com 了解 Eppo，让你的实验速度提升 10 倍。

---

### [00:35:32] Lenny

**English:**
You've touched on this idea of a complex system and I want to spend a little bit more time there. LinkedIn is, as you said, very, very complicated. There's all these marketplaces within marketplaces. There's so many customers you got to make happy. They all have to work together. I'm just curious what you've learned about building and maintaining a complex ecosystem like that.

**中文翻译:**
你提到了复杂系统这个概念，我想多花点时间聊聊。正如你所说，LinkedIn 非常非常复杂。市场之中还有市场。有这么多客户需要满足。他们必须协同工作。我很想知道你在构建和维护这样一个复杂生态系统方面学到了什么。

---

### [00:35:55] Hari Srinivasan

**English:**
It's a fantastic question. I just openly think first of all, just career-wise, I've always been drawn to that. We talk about product as a whole. We always talk about it as a whole, but there's many different things you can build, many different types of things. And then we go, maybe there's hardware and software consumer goods. I actually try to think about products by their complexity curve a lot.

**中文翻译:**
这是一个极好的问题。坦白说，首先从职业生涯的角度来看，我一直被这种复杂性所吸引。我们谈论产品时总是把它看作一个整体，但你可以构建很多不同的东西，很多不同的类型。比如硬件、软件、消费品。我实际上经常根据产品的“复杂性曲线”来思考它们。

---

### [00:36:17] Hari Srinivasan

**English:**
I think that the skills you need to manage a complicated ecosystem versus maybe the skills you need to design something that's less interconnected are quite different. I will get to the details maybe of what I mean in a minute, but I do think LinkedIn's a particularly complicated place. And I do think that the skillsets that you think through and you try to manage in a complicated ecosystem are quite different. Maybe some tactics that can help if it's something along those lines.

**中文翻译:**
我认为管理一个复杂的生态系统所需的技能，与设计一个互联性较低的产品所需的技能是截然不同的。我稍后会详细解释我的意思，但我确实认为 LinkedIn 是一个特别复杂的地方。我认为在复杂生态系统中思考和尝试管理的技能组合是非常不同的。如果涉及这方面，也许有一些策略可以提供帮助。

---

### [00:36:42] Lenny

**English:**
Yeah, let's do it.

**中文翻译:**
好啊，我们聊聊。

---

### [00:36:43] Hari Srinivasan

**English:**
One of the things that I often think about is this concept of cause and effect. If you have non-interconnected things, it's actually quite easy not to have to think about that. You made something people love. I wrote a children's book not too long ago and it was fun. It was awesome to write. Once it was done, it was done, and it was out there and it was able to go. That's a little bit different than here. If you make a change, like open to work, all of a sudden you're thinking through the perception of someone on the other side. What is that going to do? Are they going to use the platform less or more? You're thinking about customers. What are they going to do with that data? Are they going to, to your point, perceive someone in a different way or not?

**中文翻译:**
我经常思考的一件事是“因果关系”的概念。如果你处理的是互不关联的事物，其实很容易不去想这些。你做了一些人们喜欢的东西。不久前我写了一本童书，很有趣，写的过程很棒。一旦写完，它就完成了，发布出去就行了。这和这里有点不同。如果你做了一个改动，比如“开启求职状态”，你突然就要考虑另一方的人会怎么看。这会产生什么影响？他们会减少还是增加平台的使用？你还要考虑客户，他们会如何处理这些数据？他们是否会像你提到的那样，以不同的方式看待某人？

---

### [00:37:21] Hari Srinivasan

**English:**
You have to think through second and third and maybe even fourth effects and manage that as you go through. I think that is something we really pride ourselves on is, how do we start thinking through these different things, and how do we start measuring them as we go? That is one.

**中文翻译:**
你必须思考二阶、三阶甚至四阶效应，并在过程中进行管理。我认为这是我们引以为豪的一点：我们如何开始思考这些不同的事情，以及我们如何在过程中衡量它们？这是第一点。

---

### [00:37:35] Hari Srinivasan

**English:**
The second thing I actually think is it does lead to your point a lot. You need a different kind of decision-making mechanism because there's a lot more ties in the ecosystem, a lot of people who just need a way to break it. We've put in things like we have something called RAPID, which is a really easy way to know who the decision-maker is. Just, you line up who's a recommender, who has to agree, who's a decision-maker. We have something called a five-day escalation rule, which makes sure that those items are in. I think you lead a lot more of those fuse, I don't know what they're called, fuse limits, or just systems in place in order to manage that complexity so that things get done. I think that those processes are actually really, really important to make sure that the ecosystem can run.

**中文翻译:**
第二点，我认为这确实在很大程度上呼应了你的观点。你需要一种不同的决策机制，因为生态系统中有更多的关联，很多人需要一种打破僵局的方法。我们引入了一些机制，比如 RAPID（一种决策框架），它可以非常简单地让你知道谁是决策者。你只需列出谁是推荐者、谁必须同意、谁是决策者。我们还有一个“五天升级规则”，以确保事情能推进。我认为你需要更多这类“保险丝”或系统来管理复杂性，从而确保事情能办成。我认为这些流程对于确保生态系统运行至关重要。

---

### [00:38:10] Lenny

**English:**
Let's talk about these two processes. RAPID, and what was the other one? Five-day-

**中文翻译:**
让我们聊聊这两个流程。RAPID，还有另一个是什么？五天……

---

### [00:38:14] Hari Srinivasan

**English:**
Yeah, five-day alignment. They've both been around LinkedIn for a little bit, but they're great. The RAPID is just a question of oftentimes to your point, if you're running two, three marketplaces, several different business model here, there's a question of who has the decision? Who can make the decision in this situation? Making sure that you have a single person's name with the decision and that person is ... That is really, really important because it gets the clarity real fast.

**中文翻译:**
是的，五天对齐规则。这两个在 LinkedIn 都存在一段时间了，非常棒。RAPID 解决的是——正如你所说，如果你运行两三个市场，有几种不同的商业模式——谁拥有决策权的问题？在这种情况下谁能做决定？确保决策权归属于一个具体的人，这非常重要，因为它能迅速带来清晰度。

---

### [00:38:36] Hari Srinivasan

**English:**
It's more of a personal rule, but one thing I love to say is, if you had three back and forths in an email, you got to pick up the phone. And if you've been on the phone for 20 minutes, it's time to just write that decision-maker and go. That way, you can make sure the concept of an hour, you should be able to get a decision. It doesn't always operate like that. I'm sure there's many PMs on LinkedIn who are operating here maybe, who may have some feedback from me on that, but that's the intent behind it.

**中文翻译:**
这更多是我个人的准则，但我喜欢说：如果一封邮件来回了三次，你就得拿起电话。如果电话打了 20 分钟还没结果，那就该直接写信给决策者了。这样，你可以确保在一小时内得到决策。虽然并不总是这样运作，我敢肯定 LinkedIn 的很多 PM 可能会对此有不同意见，但这就是其背后的初衷。

---

### [00:38:58] Hari Srinivasan

**English:**
And then a five-day alignment is, you should hold your managers accountable. That in five days if someone has something that they haven't been able to escalate and solve, that's probably then on the next level of person. But as you run that ecosystem and there's so much complexity around it, I think you need some of those processes in place in order to start answering some of those tiebreakers, if you will.

**中文翻译:**
然后，“五天对齐”是指你应该让你的经理负责。如果一件事在五天内还没能升级并解决，那可能就该由更高一级的人来处理了。当你运行这样一个复杂的生态系统时，你需要这些流程来充当“僵局打破者”。

---

### [00:39:17] Lenny

**English:**
Ooh, I like that five-day rule. Basically puts the clock on a manager to get to unblock, basically?

**中文翻译:**
噢，我喜欢这个五天规则。基本上是给经理设定了一个时限来解除阻塞，对吧？

---

### [00:39:23] Hari Srinivasan

**English:**
Yeah. Yeah.

**中文翻译:**
是的，没错。

---

### [00:39:25] Lenny

**English:**
With RAPID, I don't know if I totally understand. Is that an acronym for something? Or is it just-

**中文翻译:**
关于 RAPID，我不确定我是否完全理解。它是一个缩写吗？还是只是……

---

### [00:39:29] Hari Srinivasan

**English:**
It is.

**中文翻译:**
是的。

---

### [00:39:29] Lenny

**English:**
... make decisions rapidly?

**中文翻译:**
……快速做出决策的意思？

---

### [00:39:31] Hari Srinivasan

**English:**
No, that's a great question. The D stands for decisions, but the R is for who's recommending it. The A, who has to agree. The I is for other people who may be able to be putting in an input. It's basically a list of people who need to be in the decision chain.

**中文翻译:**
不，问得好。D 代表决策（Decisions），R 代表推荐者（Recommend），A 代表必须同意的人（Agree），I 代表可能提供输入的人（Input）。它基本上是决策链中需要参与的人员列表。

---

### [00:39:44] Lenny

**English:**
Got it.

**中文翻译:**
明白了。

---

### [00:39:45] Hari Srinivasan

**English:**
I would argue the most important thing is to have a single name on that decision line, because that usually makes sure that you can get a decision very quickly.

**中文翻译:**
我认为最重要的一点是在决策线上只有一个名字，因为这通常能确保你非常迅速地得到决策。

---

### [00:39:51] Lenny

**English:**
Are there any other really common frameworks or processes along these lines at LinkedIn that you find really helpful?

**中文翻译:**
在 LinkedIn，还有其他类似的常用框架或流程是你觉得非常有帮助的吗？

---

### [00:39:56] Hari Srinivasan

**English:**
The third thing is just in how we think about talent, especially in the product organization. I often really do try to suss out during interviews or in how we promote people, just their ability to see systems. Because again, I do think it's a different skillset and a different capability of how we map those things out on a complexity curve. Oftentimes, I think those talent systems will ... those who are able to see the whole, make decisions at the whole, that's rare actually.

**中文翻译:**
第三点是关于我们如何看待人才，特别是在产品组织中。在面试或晋升评估中，我经常试图考察一个人“看系统”的能力。因为我再次强调，如何将事物映射到复杂性曲线上是一项不同的技能和能力。通常情况下，那些能够看到全局并基于全局做决策的人其实非常罕见。

---

### [00:40:24] Hari Srinivasan

**English:**
I think most talent systems are, "Hey, how did your division grow or your product grow, your era grow?" We've tried our best to understand that it's not just about that. You want accountability in the ecosystem of course, but how well does this person work across? I think as we've created telemetry around that or organizational understanding of that, how we've understood ourselves, just, "Hey, this is the skillset that's really important here," I think that's quite rare in driving that kind of complexity system as well.

**中文翻译:**
我认为大多数人才系统关注的是：“嘿，你的部门增长了多少？你的产品增长了多少？”我们尽力去理解，这不仅仅关乎这些。你当然希望在生态系统中落实责任制，但这个人跨部门协作的能力如何？随着我们围绕这一点建立了衡量机制或组织层面的理解，我们意识到：“嘿，这才是这里真正重要的技能。”我认为在驱动这种复杂系统时，这种能力也是非常稀缺的。

---

### [00:40:52] Lenny

**English:**
One more question along these lines.

**中文翻译:**
关于这方面我还有一个问题。

---

### [00:40:53] Hari Srinivasan

**English:**
Yeah.

**中文翻译:**
请讲。

---

### [00:40:54] Lenny

**English:**
You've been at LinkedIn for a long time. It feels like historically, LinkedIn as a product team, the external impression was it's very optimizey-oriented and everyone there is just micro-optimizing all the little features of LinkedIn. Everyone I've worked with from LinkedIn, they're just really good at just optimizing things.

**中文翻译:**
你在 LinkedIn 工作了很长时间。感觉从历史上看，外界对 LinkedIn 产品团队的印象是“极度趋向优化”，那里的每个人都在对 LinkedIn 的各种小功能进行微调优化。我合作过的每个来自 LinkedIn 的人，都非常擅长优化。

---

### [00:41:16] Lenny

**English:**
It feels like a lot of new stuff is happening with LinkedIn these days and I'm curious if that's been a real intentional shift of let's not focus so much on making emails work better and all the click-through rates of everything and more just, let's innovate more, let's do some bigger bets.

**中文翻译:**
但感觉最近 LinkedIn 出现了很多新东西，我很好奇这是否是一种刻意的转型——即不再那么关注如何让邮件效果更好、提高各种点击率，而是更多地关注创新，去做一些更大的赌注？

---

### [00:41:34] Hari Srinivasan

**English:**
I do think there's two things to acknowledge. First, there's an incredible growth team, and I think a lot of people that go on from LinkedIn in incredible roles are growth. I think there's an influencer change that a lot of people you meet might be growth-oriented. The second thing is, especially when LinkedIn started, and like you said, I've been here a little bit of time, but growing the network is probably a very, very important thing to get the scale out. I think a lot of things people interacted with at first were maybe more growth mechanisms than other systems.

**中文翻译:**
我认为有两点需要承认。首先，我们有一支非常出色的增长团队，很多从 LinkedIn 离职并担任要职的人都是做增长出身的。我想这可能导致你遇到的人大多是增长导向的。第二点是，特别是在 LinkedIn 创立初期（正如你所说，我在这里也有一段时间了），扩大网络规模是非常非常重要的事情。我想人们最初接触到的很多东西可能更多是增长机制，而不是其他系统。

---

### [00:42:02] Hari Srinivasan

**English:**
I do think there's always been, at least for the last several years, an underlining line that value is what's going to carry this ecosystem, and value is ultimately what makes the day. To your point, I like to think that they may not be the most, I don't know, the glittery items, but I'm really proud of what we've done with skills. I think that's one of those invisible systems that no one really knows. Like, oh my gosh, that's a huge disruption if people can now get ... That's a huge language that people have created. That's a huge way that people have changed.

**中文翻译:**
但我确实认为，至少在过去几年里，一直有一条底线：价值才是承载这个生态系统的核心，价值最终决定成败。就你所言，我倾向于认为，虽然有些东西可能不是最“光鲜亮丽”的，但我对我们在“技能”方面所做的工作感到非常自豪。我认为那是没人真正了解的“隐形系统”之一。比如，如果人们现在可以获得……那将是一个巨大的颠覆。那是人们创造的一种宏大的语言，是人们改变的一种宏大方式。

---

### [00:42:32] Hari Srinivasan

**English:**
We're really proud of what we've done with values. Even open to work and commitments, these are major social systems that we've wired through. I'm really proud of what we've done with LinkedIn Learning. I would argue it's one of the bigger creator systems in the world. It's these incredible instructors and the ability to take someone who teaches, maybe is not great on camera, and move them to the studio and give them that capability and take their voice out there.

**中文翻译:**
我们对在“价值观”方面所做的工作感到非常自豪。甚至包括“开启求职状态”和“承诺”，这些都是我们构建的主要社会系统。我也对我们在 LinkedIn Learning 方面取得的成就感到自豪。我认为它是世界上最大的创作者系统之一。那些了不起的讲师，我们有能力把一个擅长教学但可能不擅长面对镜头的人请进工作室，赋予他们这种能力，并把他们的声音传播出去。

---

### [00:42:55] Hari Srinivasan

**English:**
I think there's a lot of different things we've done that maybe because they're more invisible, if you will, or they're hidden in a marketplace that necessarily maybe a lot of the influencer voices may not actually need an access every day, I don't know if they get as much visibility. But I like to think that's been part of the DNA for a while and we've been really thinking through it.

**中文翻译:**
我想我们做了很多不同的事情，也许是因为它们更“隐形”，或者隐藏在某个市场中，而很多大 V 可能并不需要每天访问，所以我不知道它们是否得到了足够的关注。但我认为这已经成为我们 DNA 的一部分很久了，我们一直在深入思考这些问题。

---

### [00:43:17] Lenny

**English:**
Let's actually talk about LinkedIn Learning. I know this is a big passion of yours. You have your own course within this that I want to talk about. But broadly, just what is LinkedIn Learning, just so people understand? Because I don't know if a lot of people know this exists within LinkedIn.

**中文翻译:**
让我们聊聊 LinkedIn Learning。我知道你对此充满热情。你在里面有一门自己的课程，我想聊聊。但概括来说，LinkedIn Learning 到底是什么？好让大家理解，因为我不知道是不是很多人知道 LinkedIn 内部还有这个。

---

### [00:43:29] Hari Srinivasan

**English:**
Great question. LinkedIn Learning is basically a way to learn professional skills. We entered the business in 2015 and the thesis was, we think about it as a marketplace again. You have seekers and job and oftentimes, seekers may not have all the skills in order to get the job. We're moving now towards the skills model, but without question, this other second-order impact. I don't think any of us wanted to, if you will, uberize the world. I don't think any of us wanted to make everyone there. We wanted to make sure everyone had the skills in order to learn the skills, in order to get there. Getting the learning business was really, really important for the vision and the mission. Basically, the idea was that we'd have ways to teach people skills that was very much tailored to professionals.

**中文翻译:**
问得好。LinkedIn Learning 基本上是一个学习专业技能的平台。我们在 2015 年进入这个领域，核心逻辑还是把它看作一个市场。你有求职者和职位，而求职者往往并不具备获得该职位所需的全部技能。我们现在正转向技能模型，但这无疑会产生二阶影响。我不认为我们中有人想把世界“Uber 化”。我们想确保每个人都有能力去学习技能，从而实现目标。进入学习业务对于我们的愿景和使命至关重要。基本上，我们的想法是提供一种非常适合专业人士的技能教学方式。

---

### [00:44:12] Hari Srinivasan

**English:**
Now, that was the vision. The way the mechanism works is, we go and get the best instructors in the world. We will bring them into a film studio. We will do it at home or in a way that makes the content extremely ... We help write the scripts, we obviously have incredible graphic, in a way that makes a teacher and someone who's an expert who may not always have the capability or the time to go and make their own online course and get them in the studio and go from there. And then the vast majority of people will probably have access to it through their company. The vast majority of the usage and the business runs through enterprise and is a large enterprise learning product.

**中文翻译:**
那是愿景。具体的运作机制是：我们去寻找世界上最好的讲师。我们会把他们请进电影制片厂。我们会协助编写剧本，提供精美的图形设计，让那些专家（他们可能没有能力或时间自己制作在线课程）能在工作室里完成创作。然后，绝大多数人可能会通过他们所在的公司获得访问权限。该产品的大部分使用和业务都通过企业端运行，是一个大型的企业学习产品。

---

### [00:44:47] Lenny

**English:**
Awesome. Yeah. I'm just as a, I don't know, armchair quarterback strategy person, I could see where this came from of we're trying to help people connect to economic opportunity, find jobs. How do we help them? Oh, they don't have the skill? Let's help them build the skills. Makes a lot of sense. Okay. Within this, you have your own course on product management.

**中文翻译:**
太棒了。作为一个“纸上谈兵”的战略分析师，我能理解这背后的逻辑：我们试图帮助人们连接经济机会、找工作。怎么帮？哦，他们没技能？那我们就帮他们建立技能。非常有道理。好，在这个平台上，你有一门关于产品管理的课程。

---

### [00:45:05] Hari Srinivasan

**English:**
Well, it's funny. I'd been thinking about a course for a while, but largely it was this concept of, I wanted to make sure I tried our own product and I understood the instructor pain point. But it's a very scary experience. It's like first, I don't know if I had anything to teach. My own concerns about that. But about four or five years ago, one of the things we started at PM internally was product university. We had our own internal university, which was basically we got some survey, we sent it out. I think everyone told us, well, it's literally the most negative one was people said, "I don't have the skills to do my job."

**中文翻译:**
很有趣。我想做一门课已经有一段时间了，主要是想确保我亲自尝试过我们的产品，并理解讲师的痛点。但这是一个非常令人生畏的经历。首先，我不知道我有没有什么可教的，这是我自己的顾虑。但大约四五年前，我们在内部为 PM 启动了一个项目，叫“产品大学”。我们有自己的内部大学，起因是我们发了一份调查问卷，结果最负面的反馈是人们说：“我不具备胜任这份工作的技能。”

---

### [00:45:40] Hari Srinivasan

**English:**
I remember looking around and I'm like, "Well, it's pretty obvious. We hired a bunch of people, there's no PM degree, and we've done nothing." What we started doing is internally creating a product university. It was a bootcamp coming in. We tried to get from different models and one of the things we really learned was, you can't teach this just through frameworks. You needed to have a series of case studies. You need to have a real series examples. But luckily, we had a bunch of things we'd done at LinkedIn, so we started putting a curriculum against that. And then just recently, a few of us got together and we filmed the actual course for it. It's basically taking our product university bootcamp and opening it up to the world.

**中文翻译:**
我记得当时环顾四周，心想：“好吧，这很明显。我们招了一群人，但并没有产品经理学位，而我们什么也没做。”于是我们开始在内部创建产品大学。这是一个入职训练营。我们尝试了不同的模型，真正学到的一点是：你不能只通过框架来教这个。你需要一系列的案例研究，需要真实的例子。幸运的是，我们在 LinkedIn 做了很多事情，所以我们开始围绕这些内容制定课程。就在最近，我们几个人聚在一起，拍摄了这门课程。它基本上是把我们内部的产品大学训练营开放给了全世界。

---

### [00:46:14] Lenny

**English:**
You opened up some of your internal use cases as a part of this course?

**中文翻译:**
你在课程中公开了一些内部案例？

---

### [00:46:17] Hari Srinivasan

**English:**
We do. Yeah.

**中文翻译:**
是的。

---

### [00:46:18] Lenny

**English:**
That's awesome. I always say that one of the things you don't realize you have as an advantage working at a bigger company is access to tons of strategy documents and vision documents and stories of this. Because once you're out, no one's going to be able to share those with you because they're so private. I don't have access to any of these anymore. That's a really cool perk if you're working at a company like LinkedIn.

**中文翻译:**
太棒了。我常说，在大型公司工作的一个你可能没意识到的优势是，你可以接触到大量的战略文档、愿景文档和背后的故事。因为一旦你离开了，就没人能和你分享这些了，因为它们太私密了。我现在已经接触不到这些了。如果你在 LinkedIn 这样的公司工作，这真的是一个很酷的福利。

---

### [00:46:39] Hari Srinivasan

**English:**
Thanks. Yeah.

**中文翻译:**
谢谢，是的。

---

### [00:46:40] Lenny

**English:**
Question about your course. What are some of your biggest lessons that you teach? Can you just give a preview of some of the tidbits that you might learn in this course of yours?

**中文翻译:**
关于你的课程，你教的最重要的课程有哪些？你能预告一下在你的课程中能学到的一些小知识吗？

---

### [00:46:48] Hari Srinivasan

**English:**
Well, again, a lot of it is case studies and use cases in the same way we teach it here, but a couple of things that we do talk through. When we started doing our own product university, we realized a couple big pain points that people hit. The first was, it's actually really hard to know how to validate and what the bar is for a new idea in any organization. I think it's really hard to say that. We provide a lot of framework. Simple things from, "Hey, you got to prove to the world why there's duct tape in here." There's someone actually physically going out and trying to do it.

**中文翻译:**
同样，课程中有很多案例研究和使用场景，就像我们在内部教的一样。我们讨论了几件事。当我们开始做产品大学时，我们意识到了人们遇到的几个大痛点。第一，在任何组织中，其实很难知道如何验证一个新想法，以及标准是什么。我认为这很难界定。我们提供了很多框架。比如一些简单的东西：“嘿，你得向世界证明为什么这里需要‘胶带’（指临时解决方案）。”也就是真的有人去实地尝试。

---

### [00:47:19] Hari Srinivasan

**English:**
How you can prioritize a list of ideas against a pain point, like how to make a simple expression, and how to look through what's an acute pain point and what's a wide range of people use, how we'd expect data in order to be used in order to validate this. Tools you could use to say if this is a good idea or a bad idea. More importantly tools to make sure you've went through the process and how you can communicate it. That's one framework set that we talked through.

**中文翻译:**
如何针对痛点对想法列表进行优先级排序，比如如何做一个简单的表达，如何区分什么是“急性痛点”以及什么是“广泛用户需求”，我们期望如何使用数据来验证这些。你可以使用哪些工具来判断这是一个好主意还是坏主意。更重要的是，确保你走完了流程并知道如何沟通。这是我们讨论的一套框架。

---

### [00:47:42] Hari Srinivasan

**English:**
The other is a lot about Damian, who leads our growth team. He comes in and he starts talking a lot about thinking in loops. How do you make sure that when you're building something you can have the fuel in order to cascade and grow? I think just the framework of doing that, how you measure that, how you monitor that, is also something that at least when I was starting and doing my startup, it was quite something I wish I had had access to. Those are maybe two good examples of frameworks and tools that we come through.

**中文翻译:**
另一个是关于 Damian 的，他领导我们的增长团队。他会进来大谈特谈“循环思维”（thinking in loops）。你如何确保在构建某些东西时，拥有能够级联和增长的动力？我认为这种操作框架、如何衡量、如何监控，也是我刚开始创业时非常渴望接触到的东西。这些可能是我们涉及的框架和工具中的两个好例子。

---

### [00:48:09] Hari Srinivasan

**English:**
And then of course, trying to overlay that with real cases. Not always successful ones, of course, too. We talk about a lot of the failures we've had and where we probably went wrong if we had to diagnose them in postmortem.

**中文翻译:**
当然，还要把这些与真实案例结合起来。当然，也不全是成功的案例。我们讨论了很多我们经历过的失败，以及如果我们要进行事后分析，我们可能在哪里出了错。

---

### [00:48:19] Lenny

**English:**
A lot of the people listening to this are people that want to get into product management and aren't PMs yet. I imagine you get asked this a lot, how do I get into product management? What is your advice that you often give?

**中文翻译:**
听这个节目的很多人是想进入产品管理领域但还不是 PM 的人。我猜你经常被问到：我该如何进入产品管理领域？你经常给出的建议是什么？

---

### [00:48:29] Hari Srinivasan

**English:**
Yeah. Well, let's start with how we look at the world, which is this idea of skills. We have a diagram that I think about, which is skills are on a triangle. You might have heard this one before. I don't know if you have. Skills are on a triangle, and I think you need three different skills to be a great PM. You need to be a Steven Spielberg type creator. Something around data science and the ability to really look at data and see patterns and then see the future. And then especially get more senior. I think it's a lot of general management. You have to basically be able to shine and innovate across the team, understand the budget, understand how companies differently work.

**中文翻译:**
好。让我们从我们看待世界的方式开始，也就是“技能”这个概念。我脑子里有一个图表，即技能三角形。你可能以前听过。我认为要成为一名优秀的 PM，你需要三种不同的技能。你需要成为史蒂文·斯皮尔伯格那样的“创作者”；需要具备数据科学能力，能够观察数据、发现模式并预见未来；最后，特别是当你变得更资深时，需要大量的“通用管理”能力。你必须能够在团队中脱颖而出并进行创新，理解预算，理解不同公司的运作方式。

---

### [00:49:01] Hari Srinivasan

**English:**
I've actually never seen a great PM who's in the center of it. I find the great PMs live on the edges. There's always someone who's this exceptional data scientist and the ability to maybe be a great GM and lead and inspire, or maybe someone who's so creative, who can lead a team in a different way. I think that one thing I would really, really encourage people to do is understand where they fit on that graph and gravitate towards those kinds of roles. Because a lot of times, I think what people do is they think they have to make up for the other pieces of that graph, and it leads them to a path where maybe they're not playing to their strengths. That's one thing I always encourage people.

**中文翻译:**
实际上，我从未见过一个完美的、处于三角形中心的优秀 PM。我发现优秀的 PM 都生活在边缘。总有人是卓越的数据科学家，同时具备成为优秀总经理、领导和激励他人的能力；或者有人极具创意，能以不同的方式领导团队。我非常鼓励大家去了解自己在这个图表中的位置，并向这类角色靠拢。因为很多时候，人们认为自己必须弥补图表中缺失的部分，这会导致他们走上一条无法发挥所长的道路。这是我一直鼓励大家的一点。

---

### [00:49:38] Hari Srinivasan

**English:**
The other thing I would say, and I know it's a little bit of luck in how this works, but I think about my journey, one thing I've really found was really helpful is, I was on the first team that did a hybrid SUV in the US. At the time, it was the Hybrid Escape at Ford. I came from the Midwest and it was one of those products where people would really drive out for hundreds of miles and see, and really a community gravitated around because it was a very special product. Being able to work on something that people loved, really loved early on, and see what that felt like and look like and that success was, it created a bar for what I would hope my products could do. It would.

**中文翻译:**
我想说的另一件事是（我知道这其中有一定的运气成分），回顾我的历程，我发现非常有帮助的一点是：我曾在美国第一个开发混合动力 SUV 的团队中工作。当时是福特的 Hybrid Escape。我来自中西部，那是那种人们真的会驱车数百英里来看的产品，一个社区围绕着它建立，因为它非常特别。能够在职业生涯早期从事一个人们真正、发自内心喜爱的产品，感受那种氛围，看到成功的样子，这为我后来对产品的期望设定了一个标准。

---

### [00:50:17] Hari Srinivasan

**English:**
If you're able to get into something that people really love and feel that and experience that, and really understand what that looks like and what it takes to get there, I think that's actually been a really valuable lesson throughout my career because you can understand the whole path on the way up. I look back at that as really something that I would hope other people if they can do it. I know you're making world decisions on many different criteria, but try to find something people love and really experience what that feels like.

**中文翻译:**
如果你能参与到一些人们真正喜爱的事物中，去感受、去体验，并真正理解它的样子以及如何实现它，我认为这在我的职业生涯中是一个非常宝贵的教训，因为你可以理解上升过程中的整个路径。回首往事，我希望其他人如果可以的话也能这样做。我知道你在根据许多不同的标准做决定，但试着找一些人们喜爱的东西，去真实体验那种感觉。

---

### [00:50:40] Lenny

**English:**
To build on that, with PMs that work for you and work with you, when they're looking to get better and build their skills, other than go take some courses on LinkedIn Learning, what do you often recommend they do to help become stronger and better at their job?

**中文翻译:**
在此基础上，对于为你工作或与你合作的 PM，当他们想要提升技能时，除了去 LinkedIn Learning 上课，你通常会建议他们做些什么来变得更强、更出色？

---

### [00:50:56] Hari Srinivasan

**English:**
First, it is that feeling of, you got to own your product and you got to speak up and say this is where I want to drive it. Because a lot of times I think people are scared to do that, or worried about doing that, or don't feel that's their actual role. One, it's extreme clarity on hey this is your role. It's to own this and take this to the next level. When you start molding the clay, people want to come and help. When you start building something cool, people are like, "Oh." They're gravitated to it. But until you can start doing that, that's really tough. One, it's letting people know that's what's expected of them.

**中文翻译:**
首先，是那种“主人翁意识”：你必须掌控你的产品，必须大声说出你想把它带向何方。因为很多时候，人们害怕这样做，或者担心这样做，或者觉得这不是他们真正的职责。第一，要极其明确：嘿，这就是你的职责。去掌控它，把它提升到新的水平。当你开始“捏泥巴”时，人们会想来帮忙。当你开始构建一些酷的东西时，人们会惊叹并被吸引。但在你开始行动之前，这很难。所以，首先要让人们知道这是对他们的期望。

---

### [00:51:26] Hari Srinivasan

**English:**
And then two, I would tell people to just build. As crazy as it sounds, I spend a lot of my time on the side, just trying to build different things. Try different clay, think through different ideas. I think that is a really important skill to have, to just being able to say, "Okay, I'm going to start with a blank sheet and make some art," or whatever it is you want to do. I encourage people to do that because it's a muscle, like anything else. It can atrophy. I really do think no matter what the heart of PM, in is that ability to be a builder, and you do got to make sure you can keep doing it.

**中文翻译:**
第二，我会告诉人们：去动手构建。听起来可能有点疯狂，但我花了很多业余时间尝试构建不同的东西。尝试不同的“粘土”，思考不同的想法。我认为这是一项非常重要的技能，即能够说：“好吧，我要从一张白纸开始，创作一些艺术品”，或者任何你想做的事。我鼓励大家这样做，因为这就像肌肉一样，不练就会萎缩。我真的认为，无论如何，PM 的核心在于“构建者”的能力，你必须确保自己能坚持做下去。

---

### [00:51:57] Lenny

**English:**
Yeah. That's actually a great segue to where I was going to go next, which is, you say you build and you like to build stuff, but you're legitimately building a lot of stuff. You have the site, mindofhari.com, where you share all these side projects. Can you just talk about what's going on there and some of the stuff that you've built?

**中文翻译:**
是的。这实际上是一个很好的过渡，引出了我接下来的话题。你说你喜欢构建东西，而且你确实构建了很多东西。你有一个网站 mindofhari.com，在那里分享你所有的副业项目。你能聊聊那个网站是怎么回事，以及你构建的一些东西吗？

---

### [00:52:12] Hari Srinivasan

**English:**
Arguably, the only thing I've ever been good at in my life is just building things and creating things. I get a lot of energy from it. Yeah, I have a site. It's called Mind of Hari because it is really whatever's top of mind. I try to do my best to completely separate it from business. I know there's always a draw as a good PM to say, is there a business here? But I try to keep it as art. It's completely art and it's what I want to build. I take on new subjects. I have two little kids and it's fun to ... One of them was a book me and my oldest wrote, and it was a set of bedtime stories we did. And then one day I was like, "Hey, we should just make this a notebook." And we did it. I think it's got about half-a-million readers now. It's been fun to see it take some life and go through.

**中文翻译:**
可以说，我这辈子唯一擅长的事情就是构建和创造。我从中获得很多能量。是的，我有一个网站，叫 Mind of Hari，因为里面真的就是我脑子里想的任何东西。我尽力让它与业务完全脱钩。我知道作为一个优秀的 PM，总会想：“这有商业价值吗？”但我努力把它当作艺术。它完全是艺术，是我想要构建的东西。我尝试新的主题。我有两个小孩，很有趣……其中一个是我的大孩子和我一起写的一本书，是我们做的一套睡前故事。有一天我想：“嘿，我们应该把它做成笔记本。”我们就这么做了。我想现在大概有 50 万读者了。看到它焕发生机并流传开来很有趣。

---

### [00:52:57] Hari Srinivasan

**English:**
We made a board game recently that I know Stanford Design School or some professors there have been using, and it was called Parallel Universe. It's, how do you have a card and then be able to see maybe the card says there's no windows in this world anymore, and then what would happen in that world? You got to list 10 different things that would happen. That ability to think ahead, the fun sci-fi stuff. I make healthy gummy bears. I just try to take something completely new and have that. I don't know, it's probably one of the more fun moments in this world where you can sit there and just create something and have some new clay. Yeah, that is what that website is about.

**中文翻译:**
我们最近做了一个桌游，我知道斯坦福设计学院的一些教授一直在用，叫《平行宇宙》（Parallel Universe）。玩法是：你有一张卡片，上面可能写着“这个世界不再有窗户了”，然后那个世界会发生什么？你得列出 10 件会发生的事。那是超前思考的能力，有趣的科幻内容。我还做健康的软糖。我只是尝试一些全新的东西。我不知道，这可能是这个世界上最有趣的时刻之一，你可以坐在那里，创造一些东西，玩玩新的“粘土”。是的，这就是那个网站的初衷。

---

### [00:53:34] Lenny

**English:**
Wait, so you made actual gummy bears?

**中文翻译:**
等等，你真的做了软糖？

---

### [00:53:36] Hari Srinivasan

**English:**
Yeah, we are doing something with gummy bears. Lenny, I know you're expecting a new addition. Congratulations, again. But one of the things I found when I had kids is, no matter what I was trying to do, there was candy and sugar everywhere like any Halloween, any birthday party, et cetera. You can't get rid of it because it was just hard to do. So we were like, hey, we're going to sit down and make our own gummy bear. What I found is, this is just a fun tidbit for your readers, if you open a Twizzler or one of those, about 80% of what's in there is sugar because they're optimizing for shelf life. They're optimizing for what's in the store.

**中文翻译:**
是的，我们正在做软糖。Lenny，我知道你家要添新成员了，再次恭喜。但我发现，有了孩子后，无论我怎么努力，到处都是糖果和糖分，比如万圣节、生日派对等等。你没法摆脱它，因为太难了。所以我们想，嘿，我们要坐下来做我们自己的软糖。我发现（这对你的读者来说是个有趣的小知识），如果你打开一包 Twizzler 或类似的糖果，里面大约 80% 都是糖，因为他们在优化保质期，优化在商店里的存放时间。

---

### [00:54:07] Hari Srinivasan

**English:**
What we were able to do is basically create a gummy bear. About 40% of it is sugar. It's just got five ingredients. Honey is the sweetener because I don't want to give my kids some alternative sweeteners. But we have a small commercial kitchen and we produce some gummy bears. If you ever want to try them, to any of your followers, I'm happy to send some gummy bears and hopefully you can check them out.

**中文翻译:**
我们所做的是创造了一种软糖，其中只有约 40% 是糖。它只有五种成分。蜂蜜是甜味剂，因为我不想给我的孩子吃人造甜味剂。我们有一个小型商业厨房，生产一些软糖。如果你想尝尝，或者你的任何粉丝想尝尝，我很乐意寄一些，希望你们能喜欢。

---

### [00:54:27] Lenny

**English:**
Wait, is there a way to buy them somewhere?

**中文翻译:**
等等，有地方可以买到吗？

---

### [00:54:29] Hari Srinivasan

**English:**
Well, you can go to Mind of Hari. We stock them seasonally. One of the things that we found out is there is different laws on how they can be shipped, and obviously we're not optimizing for long storage. But they'll be on Mind of Hari. You can always reach out to me and I'll find you and tell you which farmer's market we're at or whatever and you can come swing by.

**中文翻译:**
你可以去 Mind of Hari 网站。我们是季节性供货。我们发现关于运输有不同的法律规定，而且显然我们没有为了长期储存而优化。但它们会出现在 Mind of Hari 上。你也可以随时联系我，我会告诉你我们在哪个农夫市场，你可以过来看看。

---

### [00:54:48] Lenny

**English:**
Well, I don't see it on Mind of Hari, so maybe by the time this comes out, put it on here. Or if you're trying to-

**中文翻译:**
嗯，我在 Mind of Hari 上没看到，所以也许等这集播出时，把它放上去。或者如果你想……

---

### [00:54:53] Hari Srinivasan

**English:**
Put it on there?

**中文翻译:**
放上去？

---

### [00:54:54] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:54:54] Hari Srinivasan

**English:**
Yeah, it's on the homepage. And then when they're stock, we put them in the shop.

**中文翻译:**
是的，它在主页上。有货的时候，我们会把它放进商店。

---

### [00:54:57] Lenny

**English:**
Okay. That means they're out of stock? All right, we're going to sell you out. Let's get all your gummy bears. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
好。那意味着现在缺货？没关系，我们会帮你卖光的。让我们买光你所有的软糖。说到这，我们进入了非常令人兴奋的闪电轮环节。准备好了吗？

---

### [00:55:06] Hari Srinivasan

**English:**
Yeah, let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [00:55:07] Lenny

**English:**
What are two or three books you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [00:55:11] Hari Srinivasan

**English:**
The first one is called Thinking in Systems. It's the one I give the team every now and then. It's just a really good book about how I think sometimes people see systems. Can we talk about it? It could be abstract. I think it goes into real detail on how people can intervene at various parts and how to take actions at different systems. I really enjoy that book.

**中文翻译:**
第一本叫《系统之美》（Thinking in Systems）。这是我偶尔会送给团队的书。这是一本关于人们如何看待系统的非常棒的书。它可能有点抽象，但我认为它详细介绍了人们如何在不同部分进行干预，以及如何在不同系统中采取行动。我非常喜欢这本书。

---

### [00:55:31] Hari Srinivasan

**English:**
Not directly maybe a book I recommend, but a book that I just read that I thought was phenomenal, just to give it to readers if they want something good, it's called Tomorrow, and Tomorrow, and Tomorrow. It was recommending by a friend. Have you read it? You read it?

**中文翻译:**
不一定是我经常推荐的，但我刚读完的一本我认为非常出色的书，推荐给想要读好书的读者，叫《明日，明日，又明日》（Tomorrow, and Tomorrow, and Tomorrow）。是一个朋友推荐的。你读过吗？

---

### [00:55:41] Lenny

**English:**
Yeah. I honestly didn't love it, but I liked it a lot.

**中文翻译:**
读过。老实说，我谈不上热爱，但我非常喜欢。

---

### [00:55:45] Hari Srinivasan

**English:**
For some reason, I've been-

**中文翻译:**
出于某种原因，我一直……

---

### [00:55:47] Lenny

**English:**
It was sweet.

**中文翻译:**
它很温馨。

---

### [00:55:47] Hari Srinivasan

**English:**
I thought it was very well done and there's a couple chapters I reflected on. I just finished it. I thought it was well done. That's one that I'll throw out there.

**中文翻译:**
我觉得写得非常好，有几个章节让我深思。我刚读完，觉得很棒。这是我想推荐的一本。

---

### [00:55:54] Lenny

**English:**
Yeah, it was very sweet. I feel like it got hyped too much for me. I'm like, okay.

**中文翻译:**
是的，很温馨。我觉得对我来说它被炒作得太过了。我觉得还行。

---

### [00:55:54] Hari Srinivasan

**English:**
Oh, I didn't actually know it got-

**中文翻译:**
噢，我其实不知道它被……

---

### [00:55:54] Lenny

**English:**
I think that's the key.

**中文翻译:**
我想这就是关键所在。

---

### [00:56:01] Hari Srinivasan

**English:**
... much publicity. Okay, that's it. The third one that I just downloaded because I finished it, I'm actually going to open up my audiobook and tell you because I'm about, I don't know, an hour into and I'm really enjoying it, it is An Immense World. I don't know if you've read that one yet. It is about animals and how animals have different senses out there. It goes through a set of different animals and how they see the world.

**中文翻译:**
……这么多宣传。好，就这样。第三本是我刚下载的，因为我刚听完上一本。我打开有声书看看，我刚听了一个小时，非常喜欢，叫《无尽的世界》（An Immense World）。不知道你读过没。它是关于动物以及动物如何拥有不同感官的。它介绍了一系列不同的动物以及它们如何看待世界。

---

### [00:56:24] Hari Srinivasan

**English:**
Just one of those reminders that we're so limited sometimes in our own perception and how dogs, for instance, they can breathe in and take in sense even when they're breathing out. It's like vision almost, and it's just phenomenal to me just to think about all the things they're probably sensing as my dog and I are going on our walk.

**中文翻译:**
这提醒了我们，有时我们的感知是多么有限。例如狗，它们甚至在呼气时也能吸入并感知气味。这几乎就像视觉一样。想到我的狗和我散步时它可能感知到的一切，我就觉得太神奇了。

---

### [00:56:42] Lenny

**English:**
I've learned dogs shoot air out of their nose first before they smell, to clear things out.

**中文翻译:**
我听说狗在闻气味之前会先从鼻子里喷气，为了清理障碍。

---

### [00:56:48] Hari Srinivasan

**English:**
Isn't that wild? They can probably see so much more of what happened in the history of a little walk than we're able to just because of that.

**中文翻译:**
这不是很疯狂吗？正因为如此，它们在一次小小的散步中能看到的“历史”可能比我们多得多。

---

### [00:56:57] Lenny

**English:**
Incredible. Next question. What is a favorite recent movie or TV show?

**中文翻译:**
太不可思议了。下一个问题。最近最喜欢的电影或电视剧是什么？

---

### [00:57:03] Hari Srinivasan

**English:**
One thing we try to do is watch TV as a family. It brings us together a little bit. We are doing Star Wars with the kids, which is for the first time, which has been a really enjoyable experience, just being able to witness it through them. And then we've been going a little bit back in time. We watched ET. It's fun. It jogs your memory. These are phenomenal movies that we go through. I think your question is on recent TV shows that probably came out more recently.

**中文翻译:**
我们尝试做的一件事是全家人一起看电视，这能让我们聚在一起。我们正带着孩子们看《星球大战》，这是他们第一次看，通过他们的视角重新审视这部作品是非常愉快的体验。然后我们还看了一些老片子，比如《E.T.》。很有趣，能唤起记忆。这些都是非常了不起的电影。我想你的问题是关于最近出的电视剧。

---

### [00:57:27] Lenny

**English:**
Those work just as well.

**中文翻译:**
这些也一样好。

---

### [00:57:28] Hari Srinivasan

**English:**
Yeah. The other one I did like, it's not a TV show but I ... God, what was it called? It was that podcast that came out. Case 63 I think it was called? Anyways, I hope that's the right name of it. But it was a sci-fi podcast. It was like 10-minute shorts. The premise of it is someone comes from the future and there's a little bit of speculative fiction and is at a psychologist. It's just a phenomenal piece. I'll have to get you the real name. Maybe I can get it for you after for the show notes or whatever.

**中文翻译:**
是的。另一个我喜欢的不是电视剧，而是……天哪，叫什么来着？是一个播客。我想是叫《63 号案件》（Case 63）？希望名字没记错。那是一个科幻播客，每集大约 10 分钟。前提是有人从未来回来，带点推测小说的色彩，他在看心理医生。那真是一部杰作。我得去查查确切的名字，稍后发给你放在节目介绍里。

---

### [00:57:56] Lenny

**English:**
Yeah, we'll edit your words and add that-

**中文翻译:**
好的，我们会编辑一下并加上……

---

### [00:57:59] Hari Srinivasan

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:57:59] Lenny

**English:**
... whatever's in the show notes, that's the one you meant. What is a favorite interview question you like to ask?

**中文翻译:**
……节目介绍里写的那个就是你想说的。你最喜欢的面试问题是什么？

---

### [00:58:06] Hari Srinivasan

**English:**
I do like to ask people what the most complex thing they ever built was. I just love to understand mostly, what do they gravitate to? Is there something you gravitate to? And two, are they able to simplify it? I think those are two really important skills.

**中文翻译:**
我喜欢问别人：“你构建过的最复杂的东西是什么？”我主要是想了解：他们被什么所吸引？有没有什么让你着迷的东西？第二，他们能否将其简化？我认为这是两项非常重要的技能。

---

### [00:58:19] Lenny

**English:**
What is it that you look for in their answer that tells you it was a good answer?

**中文翻译:**
你在他们的回答中寻找什么，来判断这是一个好的回答？

---

### [00:58:23] Hari Srinivasan

**English:**
Both of those things. First, did they take on something that was super complex, really, really hard? Because I think there's only a particular group of people who gravitate to those kinds of problems. I do think more and more openly. I think that's a lot of, in my opinion, the ways the world is going to get better by the things that are really, really hard to solve. Intimacy doesn't scale. When you think about how people are going to feel more connected, it's going to be a lot more difficult to solve. When you think about healthcare, it's going to be very, very difficult to solve. Education is a very difficult interconnected space. I think people who gravitate to that, know those problems are hard, have a very special gift. It's hard to replicate that passion. So one, did you do that?

**中文翻译:**
两点都有。第一，他们是否承担了一些超级复杂、非常非常困难的事情？因为我认为只有特定的一群人会被这类问题所吸引。我越来越坦率地认为，世界将通过解决那些真正困难的问题而变得更好。亲密关系无法规模化。当你思考如何让人们感到更紧密的联系时，这将非常难解决。当你思考医疗保健时，也会非常难解决。教育是一个非常困难的互联空间。我认为那些被这些问题吸引、知道这些问题很难的人，拥有一种非常特别的天赋。这种热情很难复制。所以第一，你做了吗？

---

### [00:59:06] Hari Srinivasan

**English:**
And then two, I think people who really understand systems are able to, somehow this is truly, especially people probably way smarter than me, they're able to simplify it. They're able to explain it and say, "This is how I looked at it, but here's how I modeled it. Here's the lovers and how I went after it." Even if it's nonlinear, they're able to say, "This is how the cause and effects works." I'm really looking for once you did it, did you really understand and were you able to crack it? Or at least, did you understand why you weren't able to crack it? I usually find this to be also the most rewarding conversations.

**中文翻译:**
第二，我认为真正理解系统的人能够——不知何故，这真的很神奇，尤其是那些可能比我聪明得多的人——他们能够将其简化。他们能够解释并说：“我是这样看的，我是这样建模的。这是杠杆点，我是这样攻克的。”即使是非线性的，他们也能说出“因果关系是如何运作的”。我寻找的是：一旦你做了，你是否真的理解并能够破解它？或者至少，你是否理解为什么你没能破解它？我通常发现这也是最有收获的对话。

---

### [00:59:35] Hari Srinivasan

**English:**
Awesome. Thanks for sharing all that.

**中文翻译:**
太棒了。谢谢分享。

---

### [00:59:36] Hari Srinivasan

**English:**
Yeah.

**中文翻译:**
不客气。

---

### [00:59:37] Lenny

**English:**
Next question. What is a favorite recent product that you've discovered that you love?

**中文翻译:**
下一个问题。最近发现并喜爱的产品是什么？

---

### [00:59:42] Hari Srinivasan

**English:**
I'll give you one more dad one. My youngest just hates brushing his teeth. Just was like, it was always a thing. I should actually find the name of the toothbrush, but you can just Google or Amazon this and you'll figure it out. Basically, it's like it was this Baby Shark toothbrush, but it's a game. You play that game for two minutes and you can try to pick up different prizes, you brush your teeth.

**中文翻译:**
我再给你分享一个关于爸爸的例子。我的小儿子非常讨厌刷牙。这总是一个难题。我应该去找找那个牙刷的名字，但你可以在 Google 或 Amazon 上搜到。基本上，它是一个“鲨鱼宝宝”（Baby Shark）牙刷，但它是一个游戏。你玩两分钟游戏，尝试获得不同的奖品，同时刷牙。

---

### [01:00:02] Hari Srinivasan

**English:**
What I loved about it, because I think it's what all great products do, it turns a moment of annoyance to a moment of joy. It went not even just like you solved a pain point. It was an unreasonable experience of like now he loves it. It was just so well done. It's like 10 bucks, and it was 10 bucks extremely well spent. So much delight. Whoever made that toothbrush, thank you.

**中文翻译:**
我之所以喜欢它，是因为我认为这就是所有伟大产品所做的：它将烦恼的时刻转变为快乐的时刻。它不仅仅是解决了一个痛点，它创造了一种不可思议的体验，现在他爱上刷牙了。它做得太棒了。只要 10 美元，这 10 美元花得太值了。带来了这么多快乐。感谢制作那个牙刷的人。

---

### [01:00:23] Lenny

**English:**
Damn. Is it playing Baby Shark? I hope not.

**中文翻译:**
天哪。它会放《鲨鱼宝宝》那首歌吗？希望不会。

---

### [01:00:26] Hari Srinivasan

**English:**
Well, it can. It has that feature. It has that capability, but it is a small price to pay for me to get out to enjoy.

**中文翻译:**
嗯，它可以。它有那个功能。但为了让我能享受清静，这点代价微不足道。

---

### [01:00:35] Lenny

**English:**
Good times. What's something relatively minor that you've changed in your product development process that has had a big impact on your team's ability to execute?

**中文翻译:**
有趣。在你的产品开发流程中，有没有什么相对较小的改动，却对团队的执行能力产生了重大影响？

---

### [01:00:44] Hari Srinivasan

**English:**
I do like to change things relatively. Every quarter or six months, sit down and say, what can we get better at? The two areas I find myself innovating, if you will, innovating or tweaking the most, one is around planning. I think every company struggles with this. You get bigger, it probably becomes a more different ... especially when we talked about the complexity of the ecosystem. We started this thing where just basically we call it orange and red priorities. Which is, then a lot of times what people do is, teams will plan bottom-up.

**中文翻译:**
我确实喜欢做一些相对的改变。每季度或每半年坐下来问：我们哪里可以做得更好？我发现自己创新（或者说微调）最多的两个领域，一个是关于“规划”。我认为每家公司都在为此挣扎。随着公司变大，情况会变得不同……尤其是当我们谈到生态系统的复杂性时。我们开始实行一种被称为“橙色和红色优先级”的机制。很多时候，团队会进行自下而上的规划。

---

### [01:01:12] Hari Srinivasan

**English:**
They'll come into a manager or a leader and then the leader may shift things around or say, this is what ... I think we've really started shifting it in a different way. We said, these are the big rocks we got to get done. We're going to get those things done first. We're going to be upfront and honest with you, and these are the things and these are price. And then you can plan from there. I think it's relieved a lot of the progress. I think there's an honesty that comes within and that's been a big change.

**中文翻译:**
他们会去找经理或领导，然后领导可能会调整内容或说……我认为我们已经开始以不同的方式转变。我们说：“这些是必须完成的大石头（核心任务）。我们要先完成这些。我们会对你们坦诚相待，这些就是任务，这些就是代价。”然后你们再以此为基础进行规划。我认为这缓解了很多压力。这种内在的坦诚是一个巨大的变化。

---

### [01:01:34] Hari Srinivasan

**English:**
The others just are the way we review products. That's always been a thing. My read is, when we keep our product review process live too long, it gets a little institutionalized and people start making long documents and stuff. You always have to change that every quarter. Basically, I think it always comes down to the same thing, which is, how do you get their problem statement quickly? And then how do you design from there? But the lever that we basically put in place for that was to really shorten the time.

**中文翻译:**
另一个是关于我们评审产品的方式。这一直是个问题。我的看法是，如果我们让产品评审流程保持太久不变，它就会变得有点制度化，人们开始写长篇大论的文档之类的。你必须每季度改变一下。基本上，我认为归根结底都是同一件事：你如何快速获得他们的问题陈述？然后如何从那里开始设计？我们为此采取的手段是大幅缩短时间。

---

### [01:02:00] Hari Srinivasan

**English:**
I'm trying this thing, I don't know if it's going to work. But could we get to 15-minute reviews basically instead of an hour and see if that alleviates some of this? I'll let you know how it goes when we chat up next, but I'm very curious to see if this is going to be a different kind of system where we might be able to get to clarity quicker, or realize we're not at clarity and then break and come back.

**中文翻译:**
我正在尝试一件事，不知道行不行得通。我们能不能把评审时间从一小时缩短到 15 分钟，看看这是否能缓解一些问题？下次聊天时我会告诉你结果，但我很好奇这是否会成为一种不同的系统，让我们能更快地达成清晰共识，或者意识到我们还没达成共识，然后休息一下再回来。

---

### [01:02:21] Lenny

**English:**
Reminds me of a tweet I think I just saw. Maybe it was an Instagram post of teams that do stand-ups while doing a plank, to keep the meeting really short.

**中文翻译:**
这让我想起我刚看到的一条推文，也可能是 Instagram 帖子，说有的团队一边做平板支撑一边开站会，为了让会议保持简短。

---

### [01:02:29] Hari Srinivasan

**English:**
That's interesting.

**中文翻译:**
那很有趣。

---

### [01:02:30] Lenny

**English:**
Could be the next one.

**中文翻译:**
可能是下一个尝试的方向。

---

### [01:02:30] Hari Srinivasan

**English:**
I haven't tried that one yet, but it might be something we try next.

**中文翻译:**
我还没试过那个，但也许是我们下一步要尝试的。

---

### [01:02:34] Lenny

**English:**
Last question. You've been at LinkedIn for a long time. I imagine you use LinkedIn a lot. Is there just a pro tip that you can share of how to be more successful with LinkedIn, find more value in LinkedIn, enjoy it more?

**中文翻译:**
最后一个问题。你在 LinkedIn 工作了很久，我猜你经常使用它。你能不能分享一个“专业技巧”，告诉大家如何更成功地使用 LinkedIn，发现更多价值，或者更享受它？

---

### [01:02:47] Hari Srinivasan

**English:**
The first is, I do think certainly there's ways, and the majority of ways that skills work is we infer skills. But I think that there is a skills section on the profile. I think a lot of people ignore it because they don't realize that there's value in it. That's changing, but I'm not sure if it's changing for everybody. I would pay more attention to skills as we get more into the skills-first stuff.

**中文翻译:**
第一，我认为虽然我们有很多推断技能的方法，但个人资料上有一个专门的“技能”板块。我想很多人忽略了它，因为他们没意识到它的价值。这种情况正在改变，但我不确定是否每个人都意识到了。随着我们更多地推行“技能优先”，我会建议大家多关注技能板块。

---

### [01:03:05] Hari Srinivasan

**English:**
The second thing I would probably do, I don't know if it's that hidden, but I would check out LinkedIn Learning. I do think LinkedIn Learning is a gem. I think because it's sold largely through enterprises, a lot of people miss it. I would hope you check it out. But more importantly, tell me areas that we could get better on there as well. I hope that people will find value there.

**中文翻译:**
第二件事，我不知道这算不算隐秘，但我建议去看看 LinkedIn Learning。我认为 LinkedIn Learning 是一个宝藏。我想因为它主要是卖给企业的，所以很多人错过了它。我希望你能去看看。但更重要的是，告诉我哪些地方我们可以做得更好。我希望人们能在那里发现价值。

---

### [01:03:22] Lenny

**English:**
What's the best way to find out about LinkedIn Learning? They just Google LinkedIn Learning and they'll find the-

**中文翻译:**
了解 LinkedIn Learning 的最佳方式是什么？直接 Google 吗？

---

### [01:03:26] Hari Srinivasan

**English:**
Yeah. Or go to LinkedIn/learning. Yeah.

**中文翻译:**
是的，或者直接访问 linkedin.com/learning。

---

### [01:03:30] Lenny

**English:**
Linkedin.com/learning? Okay. Great. Hari, I feel like we've opened the Mind of Hari up on this podcast. I appreciate you being here. Two final questions. Where can folks find you online if they want to reach out, and how can listeners be useful to you?

**中文翻译:**
Linkedin.com/learning？好的，太棒了。Hari，我觉得我们在这次播客中打开了“Hari 的大脑”。感谢你的到来。最后两个问题：如果大家想联系你，可以在哪里找到你？以及听众可以如何帮到你？

---

### [01:03:42] Hari Srinivasan

**English:**
Well, you can find me on LinkedIn. That's an easy one. I do really, really, really appreciate product feedback. I promise you I take it well, for those listening. And two, going back to the heart of this conversation around complexity, it is really hard to know sometimes what everyone's experience is because you're living in a very abstracted ecosystem. The more you could just say, hey, this is working or not, and the intentions are coming from a good place, and if you have a moment and you're not having a great experience, or you are having a great experience, you could write it. I really would appreciate to hear your perspective.

**中文翻译:**
嗯，你可以在 LinkedIn 上找到我，这很简单。我非常、非常、非常看重产品反馈。我向听众保证，我会虚心接受。第二，回到我们关于复杂性的核心对话，有时很难知道每个人的真实体验，因为你生活在一个非常抽象的生态系统中。如果你能告诉我们，嘿，这个好用或不好用，只要出发点是好的，无论你的体验是好是坏，都可以写下来。我真的很想听听你的看法。

---

### [01:04:15] Lenny

**English:**
Amazing. Hari, thank you so much for being here.

**中文翻译:**
太棒了。Hari，非常感谢你参加节目。

---

### [01:04:18] Hari Srinivasan

**English:**
Thanks, Lenny. It's great meeting you.

**中文翻译:**
谢谢，Lenny。很高兴见到你。

---

### [01:04:20] Lenny

**English:**
You, too. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
我也是。大家再见。非常感谢大家的收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到过去所有的节目或了解更多信息。下期节目再见。