# Heidi Helfand - 双语对照

这是一份关于 Lenny's Podcast 采访 Heidi Helfand 的完整双语对照文档。

---

### [00:00:00] Heidi Helfand

**English:**
Reteaming is hard. Reorgs are hard. You can't lump them all into one thing with oh, it's all great all the time. No, it's not. If we could just build the software, deliver to the customer, get the product market fit, hey, have we delighted them or not? If only it could be that easy. No, we have the people layer, so let's focus there too.

**中文翻译:**
团队重组（Reteaming）很难。组织架构调整（Reorgs）也很难。你不能把它们一概而论，觉得“哦，一切总是那么美好”。不，事实并非如此。如果我们只需要开发软件、交付给客户、实现产品市场契合（Product Market Fit），然后看看我们是否让他们满意了，如果事情真有那么简单就好了。但现实是，我们还有“人员层”（People Layer），所以我们也得关注这一层。

---

### [00:00:25] Lenny

**English:**
Today my guest is Heidi Helfand. After two decades in the tech industry, Heidi became fascinated with how teams are organized, how org structures change and how to set teams up for success through that change. She now teaches workshops and runs courses and consults on how to effectively reorganize your teams. And in her book *Dynamic Reteaming*, Heidi delves deep into why change is actually good for your teams, why you're better off not having super stable teams, how to effectively execute reorgs, and through that, how to reduce attrition, stagnation, and knowledge silos. In our conversation, Heidi shares the five types of reteaming, anti-patterns to avoid when making org changes, what sort of team structure is most conducive to creating totally new products, why being transparent about your reorg plans is definitely worth considering. Also, how Heidi became such a great listener with a lot of really interesting insights and advice there and so much more. Huge thank you to John Cutler for introducing me to Heidi. With that, I bring you Heidi Helfand after a short word from our sponsors.

**中文翻译:**
今天的嘉宾是 Heidi Helfand。在科技行业深耕二十年后，Heidi 对团队如何组织、组织架构如何变化以及如何在这种变化中助力团队成功产生了浓厚兴趣。她现在举办工作坊、开设课程，并就如何有效地重组团队提供咨询。在她的著作《动态团队重组》（*Dynamic Reteaming*）中，Heidi 深入探讨了为什么变化实际上对团队有益，为什么不拥有超稳定的团队反而更好，如何有效执行组织架构调整，并以此减少员工流失、停滞不前和知识孤岛。在我们的对话中，Heidi 分享了五种团队重组类型、进行组织变革时应避免的反模式、哪种团队结构最有利于创造全新产品，以及为什么透明化你的重组计划绝对值得考虑。此外，Heidi 还分享了她如何成为一名优秀的倾听者，其中包含许多有趣的见解和建议。非常感谢 John Cutler 把 Heidi 介绍给我。在听完赞助商的简短介绍后，我们将为您带来 Heidi Helfand 的精彩内容。

---

### [00:01:29] Lenny (Sponsorships)

**English:**
This episode is brought to you by productroadmap.ai and Ignition. Productroadmap.ai is the first AI roadmapping suite. It helps ensure roadmaps drive revenue by instantly aligning product with your sales and marketing teams to capture upsell opportunities. Built by early leaders from Rippling and Craft, it automatically identifies feature gaps from your CRM data and your customer conversations, adds them to shareable roadmaps easily prioritized by revenue impact, and then seamlessly closes the loop with sales reps via targeted notifications when feature gaps are closed. As part of Ignition's broader go-to-market operating system, productroadmap.ai can also help create better handoffs and collaboration with product marketing teams by giving both teams the tools to research, plan, orchestrate and measure the process of building products and going to market. Packed with integrations, AI automation and communication tools, it's truly a one-stop shop for product and marketing to bring things from concept to launch. To sign up, go to productroadmap.ai and use promo code Lenny to get 75% off your first year.

**中文翻译:**
本期节目由 productroadmap.ai 和 Ignition 赞助。Productroadmap.ai 是首个 AI 路线图套件。它通过即时对齐产品与销售及营销团队来捕捉增销机会，确保路线图能够驱动收入。它由来自 Rippling 和 Craft 的早期领导者打造，能自动从您的 CRM 数据和客户对话中识别功能差距，并将其添加到可共享的路线图中，根据收入影响轻松排列优先级，然后在功能差距填补后通过定向通知与销售代表无缝闭环。作为 Ignition 更广泛的进入市场（GTM）操作系统的一部分，productroadmap.ai 还可以通过为产品和营销团队提供调研、计划、编排和衡量产品构建及上市过程的工具，帮助双方实现更好的交接与协作。它集成了多种功能、AI 自动化和沟通工具，是产品和营销团队从概念到发布的一站式平台。注册请访问 productroadmap.ai，并使用优惠码 Lenny 享受首年 2.5 折优惠。

---

### [00:02:36] Lenny (Sponsorships)

**English:**
This episode is brought to you by Hex. If you're a data person, you probably have to jump between different tools to run queries, build visualizations, write Python, and send around a lot of screenshots and CSV files. Hex brings everything together. Its powerful notebook UI lets you analyze data in SQL, Python, or no-code in any combination and work together with live multiplayer and version control. And now Hex's AI tools can generate queries and code, create visualizations, and even kickstart a whole analysis for you all from natural language prompts. It's like having an analytics copilot built right into where you're already doing your work. Then when you're ready to share, you can use Hex's drag and drop app builder to configure beautiful reports or dashboards that anyone can use. Join the hundreds of data teams like Notion, AllTrails, Loom, Mixpanel and Algolia using Hex every day to make their work more impactful. Sign up today at hex.tech/lenny to get a 60-day free trial of the Hex team plan. That's hex.tech/lenny.

**中文翻译:**
本期节目由 Hex 赞助。如果你是一名数据从业者，你可能需要在不同工具之间切换来运行查询、构建可视化、编写 Python，并发送大量的截图和 CSV 文件。Hex 将一切整合在一起。其强大的笔记本界面允许你以 SQL、Python 或无代码的任何组合分析数据，并通过实时多人协作和版本控制共同工作。现在，Hex 的 AI 工具可以根据自然语言提示生成查询和代码、创建可视化，甚至为你启动整个分析过程。这就像在你的工作流程中内置了一个分析副驾驶（Copilot）。当你准备好分享时，可以使用 Hex 的拖拽式应用构建器配置精美的报告或仪表盘。加入 Notion、AllTrails、Loom、Mixpanel 和 Algolia 等数百个数据团队，每天使用 Hex 让工作更具影响力。立即访问 hex.tech/lenny 注册，即可获得 Hex 团队计划的 60 天免费试用。

---

### [00:03:41] Lenny

**English:**
Heidi, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Heidi，非常感谢你能来，欢迎来到本播客。

---

### [00:03:45] Heidi Helfand

**English:**
Thanks, Lenny. Great to be here.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。

---

### [00:03:47] Lenny

**English:**
It's great to have you here. So I had this colleague at Airbnb, her name was Jana, and she always had this joke that she shared that if it's been six months and she hasn't switched teams or hasn't moved desks, she knew there was this reorg coming, there's something happening, something was coming to change everything. And you wrote a whole book about this general idea of teams changing, reorgs, you call reteaming. I have the book right here. It's called *Dynamic Reteaming: The Art and Wisdom of Changing Teams*. I feel like just people underestimate the opportunities and benefits of change, and I think that we see it as a scary thing. So I'm really excited to spend time with you and chat about this topic. Before we get into the meat of it, I'm just curious why you decided to spend so much of your time researching this area of team change, reorgs, reteaming.

**中文翻译:**
很高兴你能来。我在 Airbnb 有个同事叫 Jana，她总爱开一个玩笑：如果过了六个月她还没换团队或者没搬工位，她就知道肯定要搞组织架构调整（Reorg）了，肯定有什么大事要发生，要改变现状了。你写了一整本书来讨论团队变化、重组这个大概念，你称之为“团队重组”（Reteaming）。书就在我手里，书名是《动态团队重组：改变团队的艺术与智慧》。我觉得人们往往低估了变化的机遇和益处，我们总是把它看作一件可怕的事。所以我非常期待能和你聊聊这个话题。在深入探讨核心内容之前，我很好奇你为什么决定花这么多时间研究团队变革、重组和团队重组这个领域？

---

### [00:04:35] Heidi Helfand

**English:**
Yeah, that's a good question. It wasn't necessarily planned. I had been working in a variety of different fast-growing startups for most of my career in 20 years in software-as-a-service companies in particular. And I read a lot of books to try to get better at my work and what we're doing in our teams. I have a lot right over there as you can see, and a lot of the books I would read on teams and the advice that I would get from people would be, you really want to keep your teams the same. You want to go for that forming, storming, norming, performing kind of thing. And I had thought about that and I was like, wait, well it wasn't really possible for us when I was at a startup and I was the 10th employee and we grew to 900 people and now thousands of people, our team's kind of morphed and changed.
(00:05:28):
So I feel like if you're in a fast-growing company or a shrinking company, look there, don't look at trying to fight the natural evolution. I was just trying to prove a point and to illustrate that teams change. And I was also curious to see, well, was that just my experience and the experience of my colleagues in Southern California? What is it like for other people? So I was just curious.

**中文翻译:**
是的，这是个好问题。这并不完全是计划好的。在我 20 年的职业生涯中，大部分时间都在各种快速增长的初创公司工作，特别是软件即服务（SaaS）公司。为了提升工作表现和团队效率，我读了很多书。如你所见，我那儿就有很多书。但我读到的很多关于团队的书籍以及人们给我的建议通常是：你真的应该保持团队稳定，追求那种“组建期、激荡期、规范期、执行期”（forming, storming, norming, performing）的模式。我思考了一下，心想：等等，这在初创公司根本不可能。我是第 10 号员工，后来公司增长到 900 人，现在甚至几千人，我们的团队一直在演变和改变。
(00:05:28):
所以我觉得，如果你身处一家快速增长或正在缩减规模的公司，你应该顺应这种变化，而不是试图对抗这种自然演变。我当时只是想证明一个观点，说明团队是会改变的。我也很好奇，这仅仅是我和南加州同事们的经历吗？其他人的情况又是怎样的？所以我纯粹是出于好奇。

---

### [00:05:56] Lenny

**English:**
You have this code in your book where you say something like, sure, we deliver software on time, we make products people love and want to buy, but there's this people layer that happens that people may not be thinking enough about. Is there anything more you can say to that?

**中文翻译:**
你在书里写过一段话，大意是：当然，我们按时交付软件，我们制造人们喜爱并想购买的产品，但其中还存在一个“人员层”（People Layer），而人们对此思考得可能还不够。关于这一点你还能多说两句吗？

---

### [00:06:11] Heidi Helfand

**English:**
Yeah, I think a lot of the things that I would read about teams just are naturally focused on, well, you want to build things that customers love. You want it to be an enjoyable experience, you want to deliver on time. There's a reason we're there as a business, but there's also a lot of company building that happens in building the people structures and just when you go from one to many to a multitude, there's a lot of work that goes into it. This is enablement type work and it's where I focused a lot of my time and my career helping make teams and organizations successful. So there is this people layer, however, I've thought about this a lot over the years and I think it would be highly convenient if we could just focus on building products that people love and getting product market fit, talking to customers.
(00:07:06):
It would be great if it could only be that, but the reality is we're humans together and there's a lot of opportunity to build companies that delight people where they're excited to be included in decision-making about how the organization grows and changes or shrinks. So yeah, there's this whole kind of other area of work that I think just doesn't get enough attention and I guess that's where I live and breathe.

**中文翻译:**
是的，我认为我读到的很多关于团队的内容都自然而然地聚焦于：你要打造客户喜爱的产品，你要提供愉悦的体验，你要按时交付。作为一家企业，这些是我们的立身之本。但在构建人员结构的过程中，也涉及大量的“公司建设”工作。当你从一个人发展到几个人，再到一大群人时，需要投入大量精力。这属于“赋能型”工作，也是我职业生涯中投入大量时间的地方，即帮助团队和组织取得成功。虽然存在这个人员层，但我这些年一直在思考，如果我们能只关注打造人们喜爱的产品、实现产品市场契合、与客户交谈，那确实会非常方便。
(00:07:06):
如果事情真的只关乎这些就好了，但现实是我们是聚在一起的人类。我们有很多机会去建立让员工感到愉悦的公司，让他们在参与关于组织增长、变革或缩减的决策时感到兴奋。所以，确实存在这么一个完整的、我认为尚未得到足够重视的工作领域，而这正是我事业的核心所在。

---

### [00:07:38] Lenny

**English:**
Awesome. Okay, so I definitely want to get into the five types of reteaming as you described, but before we get there, what I find with reorgs and change is that it often leads to the biggest career opportunities because there's new roles to be filled. If things aren't changing, there's not going to be all of a sudden, "Hey, we have this new role that we want for you." I don't know. A lot of the leaders that move up quickly are the ones that seem to take advantage of change and think ahead and get involved and position themselves in a way where like, "Okay, cool, there's a new position. Oh, clearly it's going to be Heidi." Is there anything you can share there? Any advice for people that maybe see reorgs coming and what they can do to help themselves in that pending change?

**中文翻译:**
太棒了。好的，我肯定想深入探讨你提到的那五种团队重组类型，但在那之前，我发现组织架构调整和变革往往会带来巨大的职业机会，因为会有新的职位空缺。如果一切都一成不变，就不会突然出现“嘿，我们有个新职位想让你尝试”的情况。我发现很多晋升很快的领导者，似乎都是那些能够利用变革、提前思考、积极参与并为自己定位的人，以至于当新职位出现时，大家会觉得“哦，显然这个位置非 Heidi 莫属”。关于这一点你有什么可以分享的吗？对于那些预见到重组即将到来的人，你有什么建议能帮助他们在即将到来的变革中获益？

---

### [00:08:21] Heidi Helfand

**English:**
I really like it when there's transparency in reorgs. There's a story in my book from Christian Lima at Spotify about how they reorged a large infrastructure team. They visualized it on whiteboards and brought people over to the whiteboards to see the future team structure that the leaders wanted and they got input into the design. We did this at Procore as well inspired by Christian and his story and we had... I think there were 80 people involved in this platform organization that was splitting from two large clusters of teams into three. And I remember when we rolled out the whiteboards from a back office where we were talking about this change for a few weeks and it was scary to roll these whiteboards out because it impacts people's day to day. It's like when somebody is suggesting that maybe you do something different or that something different happens, sometimes it can be kind of triggering. You want to know what's going on. So anyway, but we had courage together.
(00:09:31):
So we rolled these whiteboards out and it had the team structure with everyone's names on it. It had the name of the team, the mission of the team, how many open slots for hiring across all of these different teams, and then people's names in their existing team positions. And people were invited to look, give feedback. They identified mistakes that we had in the design, "Oh, this team might be better over here and here's why." And people had the opportunity to see opportunities within their own company that they might say, "Hey, I'm interested in this, might I be considered for this?" And then they could have their discussion. So I really liked that the opportunities were shared and presented, so it wasn't some sort of thing that happened in some kind of back room for the whole time. We unearthed the beginning of a plan.
(00:10:31):
I think sometimes when you convene people for a meeting to talk about anything, it's good to have a starting point. So we had this starting point, we had a variety of different things and I call it whiteboard reteaming in my book and I write about that. And there's even structures that are more open than that. Redgate Software in Cambridge UK. Chris Smith is a colleague of mine and they do regular open self-selection reteaming activities when they're changing their strategic priorities. He talks about this globally very interesting space and it's even more open than putting the names on the whiteboards. They have teams give pitches and this is what they're looking for and they have a whole method for enabling people to say, "Hey, I'm interested in this." I think that really helps because sometimes you might think, "Oh, no one's going to want to work on this." But people can be delighted by working on things that another person doesn't think are particularly interesting.
(00:11:38):
So giving choice is important. And again, there are different grades of transparency. We weren't up for doing this kind of open reteaming self-selection event, but we were open to the whiteboard variant.

**中文翻译:**
我非常推崇组织架构调整中的透明度。我书里讲了一个 Spotify 的 Christian Lima 的故事，关于他们如何重组一个大型基础架构团队。他们把方案在白板上可视化，并把员工带到白板前，让他们看领导层构想的未来团队结构，并听取他们对设计的意见。受 Christian 故事的启发，我们在 Procore 也这样做过。当时我们的平台部门大约有 80 人，正准备从两个大的团队集群拆分为三个。我记得当我们把在办公室里讨论了几周的白板推出来时，心里挺忐忑的，因为这会影响到每个人的日常生活。当有人建议你做些不同的事情，或者有变动发生时，有时会引发人们的抵触情绪。大家都想知道到底发生了什么。但无论如何，我们共同拿出了勇气。
(00:09:31):
于是我们推出了这些白板，上面写着团队结构和每个人的名字。它标明了团队名称、团队使命、各个团队的招聘空缺，以及员工目前所在的职位。我们邀请大家来看并提供反馈。他们指出了我们设计中的错误，比如“哦，这个团队放在这里可能更好，原因如下”。员工也有机会看到公司内部的机会，他们可能会说：“嘿，我对这个感兴趣，我能被考虑吗？”然后他们就可以进行讨论。所以我非常喜欢这种机会共享和展示的方式，而不是一直躲在密室里搞。我们展示了一个计划的雏形。
(00:10:31):
我认为，当你召集大家开会讨论任何事情时，有一个起点是很好的。所以我们有了这个起点，有了各种不同的尝试，我在书中称之为“白板团队重组”（whiteboard reteaming）。甚至还有比这更开放的结构。英国剑桥的 Redgate Software，我的同事 Chris Smith，他们会在调整战略优先级时定期举行开放的“自主选择式团队重组”活动。他在全球范围内分享这个非常有趣的领域，这比在白板上写名字更开放。他们让团队进行宣讲（pitch），说明他们在寻找什么样的人，并有一整套方法让员工表达“嘿，我对这个感兴趣”。我认为这很有帮助，因为有时你可能觉得“哦，没人会想做这个”，但实际上，有些人会因为能做别人觉得无趣的事情而感到高兴。
(00:11:38):
所以，提供选择非常重要。当然，透明度有不同的等级。我们当时还没准备好做那种完全开放的自主选择活动，但我们对“白板变体”持开放态度。

---

### [00:11:56] Lenny

**English:**
I imagine individual employees hearing this of just being involved in the reorg strategy sounds amazing. Executives and leaders hearing this are probably really afraid and feel like there's no way this can work well. And so what I want to understand is how do you actually set this up for success? What I'm imagining when you do this is many people disagree. There's teams people want to join, there's teams people don't want to join. It seems like there's a consensus challenge where do you wait for everyone to agree? Does someone end up making a decision? Does it distract everyone from the work they're doing when you're kind of involving everyone in the reorg? Versus what typically happens, it secretly is planned amongst executives. No one knows it's coming. And I think the reason they do that is because they don't want to distract anyone and they don't want anyone to start freaking out until it's like, "Here's the final plan. Here's what we're doing." So what other advice do you have for people that want to practice this way of reteaming and reorging where they involve the actual team in the plan?

**中文翻译:**
我能想象普通员工听到能参与重组战略会觉得太棒了。但高管和领导者听到这些可能会非常害怕，觉得这根本行不通。所以我想了解的是，你到底如何确保这种方式取得成功？我能想象当你这样做时，会有很多人反对。有些团队大家都想进，有些团队没人想去。这似乎存在共识挑战——你是等所有人达成一致吗？最后是由某个人拍板吗？当你让所有人参与重组时，会不会分散大家的工作精力？相比之下，通常的做法是高管们秘密计划，没人知道变动要来。我觉得他们这么做的原因是怕分散大家注意力，不想让大家在看到“这是最终计划，我们就这么干”之前就开始恐慌。那么，对于那些想尝试这种让团队成员参与计划的重组方式的人，你还有什么建议？

---

### [00:12:58] Heidi Helfand

**English:**
There's a book by William Bridges called *Transitions: Managing Life's Changes*. I have it right here. *Making Sense of Life's Changes*. He talks about endings, neutral zone, and new beginning. Ending: you're going through a change, your team is changing. Neutral zone: the period of kind of liminality where you're like, "Gosh, I don't know how this is going to go." You're not quite comfortable. You're not quite in that new reality yet. You're still thinking about what it was like before. And once you're in that new reality and leaders can paint the vision and picture about the benefits of the new reality and the purpose and why we're here and anchor to that to try to raise positivity. But once I learned about that transition framework, going through any subsequent changes myself became a lot easier to grasp and it really kind of makes changes in any part of your life. I mean, his book is not written about software development or product development.
(00:14:00):
Sometimes we're going to have a say, we're going to be able to participate, sometimes we're not. And being clear on who the decision maker is in a change is really important.
(00:14:11):
There's another framework that I really like. I don't think it's in my book, but I've written about it in my new book, but it's called RIDE. And we had a chief people officer at Procore and she's now at UKG, Pat Wadors. She taught us the RIDE framework for decision making clarity and it's who's requesting the change, who can give input to the change, who's the decider on the change, and who's going to execute on the change? So it's like R-I-D-E. And I googled this for a while; I couldn't find anything on it. I encouraged her to write about it and I credit her to that, Pat Wadors. She's awesome.
(00:14:53):
So a lot of the times it's like, what's the problem you're going to solve? You have a current state and a future state and that future state might be up to discussion, but maybe it's not depending on what it is. You're getting acquired, you're probably not going to have a standup meeting and talk about should we get acquired or not? No, you're not part of that decision. And then how's the change going to get rolled out or how are we going to do it?
(00:15:22):
In other cases at the team level, maybe you have a retrospective and you determine, "Hey, I think we'd be a bit more effective and we'd be able to deliver at a better cadence if we were two teams instead of one team." And if teams have the ability to talk about that and impact and have some agency into how their part of the org evolves and change, I think that could be really cool. I think that could be really empowering. I think that could help us feel more ownership in that company that we're in. It doesn't always have to be like decision making equals hierarchy or the person at the top. It doesn't have to be like that.
(00:16:01):
But again, reteaming is hard. Reorgs are hard. You can't lump them all into one thing with, oh, it's all great all the time. No, it's not. It's not. But anyway, we need to focus there. We got to focus on this people layer because reteaming is inevitable. We might as well get better at it because we're going to have to deal with it. If we could just build the software, deliver to the customer, get the product market fit, hey, have we delighted them or not? If only it could be that easy. No, we have the people layer. So let's focus there too.

**中文翻译:**
William Bridges 写过一本书叫《过渡期：应对人生的转变》（*Transitions: Managing Life's Changes*）。就在我手里，《理解人生的转变》。他谈到了结束（Endings）、迷茫期（Neutral zone）和新开始（New beginning）。结束：你正在经历变革，你的团队正在改变。迷茫期：一种处于中间状态的时期，你会觉得“天哪，我不知道这会变成什么样”。你不太舒服，还没完全进入新的现实，还在想着以前的样子。一旦你进入了新现实，领导者就可以描绘愿景，展示新现实的好处、目的以及我们为什么在这里，并以此为支点来提升积极性。一旦我了解了这个“过渡框架”，我自己经历随后的任何变革都变得容易理解得多，它实际上适用于你生活中的任何变化。我是说，他的书并不是专门写软件开发或产品开发的。
(00:14:00):
有时我们有发言权，能够参与；有时则不能。在变革中明确谁是决策者（Decision maker）非常重要。
(00:14:11):
还有一个我非常喜欢的框架，虽然没在我的书里，但我写在了新书里，叫 RIDE。我们在 Procore 时有一位首席人力资源官 Pat Wadors（她现在在 UKG），她教会了我们 RIDE 框架来明确决策：谁是发起者（Requesting）、谁提供建议（Input）、谁是决策者（Decider）、谁负责执行（Execute）？即 R-I-D-E。我搜了很久都没搜到相关内容，所以我鼓励她写出来，这归功于她，Pat Wadors，她很棒。
(00:14:53):
所以很多时候，关键在于：你要解决什么问题？你有现状和未来状态，未来状态可能可以讨论，但也可能不行，这取决于具体情况。比如公司被收购，你可能不会开个站会讨论“我们该不该被收购”，不，你不是那个决策的一部分。然后是变革如何推行，或者我们要怎么做。
(00:15:22):
在其他情况下，在团队层面，也许你们开个回顾会，然后确定：“嘿，我觉得如果我们拆成两个团队而不是一个，我们会更有效率，交付节奏会更好。”如果团队有能力讨论这些，并对他们所在部门的演变和变革产生影响和自主权，我觉得那会非常酷。我觉得那会非常有赋能感，能帮助我们在公司中感受到更多的归属感。决策并不总是等同于层级制度或最高层的那个人，不一定非得那样。
(00:16:01):
但话说回来，团队重组很难，架构调整很难。你不能把它们简单化，觉得“哦，一切总是很美好”。不，事实并非如此。但无论如何，我们需要关注这一点。我们必须关注这个“人员层”，因为团队重组是不可避免的。我们不妨学着做得更好，因为我们迟早要面对它。如果我们能只管写代码、交产品、搞定 PMF，看看客户开不开心，如果真有那么简单就好了。但不行，我们有人员层，所以我们也得关注那里。

---

### [00:16:37] Lenny

**English:**
On this transparent collaborative reteaming, final question here is just would you recommend time boxing this so that it doesn't suck up everyone's brain power for weeks and weeks and weeks? Or is it very dependent?

**中文翻译:**
关于这种透明协作式的团队重组，最后一个问题是：你会建议设定时间限制（Time boxing）吗？以免它连续几周耗尽所有人的精力。还是说这取决于具体情况？

---

### [00:16:48] Heidi Helfand

**English:**
Yeah, you got to time box it.

**中文翻译:**
是的，你必须设定时间限制。

---

### [00:16:52] Lenny

**English:**
Okay. Is there advice you have on how long?

**中文翻译:**
好的。关于时长你有什么建议吗？

---

### [00:16:53] Heidi Helfand

**English:**
Make a schedule biased towards shorter as opposed to longer. You don't want to deliberate on this forever, because especially as you include more people, it can be distracting. So you want to proceed as expediently as you can.

**中文翻译:**
制定一个倾向于“短”而非“长”的时间表。你不想永远讨论下去，因为尤其是当参与人数增多时，它会让人分心。所以你要尽可能迅速地推进。

---

### [00:17:10] Lenny

**English:**
Okay, let's talk about the types of reteaming. This is kind of the core of your book and we haven't even gotten there yet. So you've identified there's five ways teams change. Can you just walk through them, help people understand what they are. And then also, we use this term reorg a lot in this conversation. I think that's the way most people think about change. After we go through this list, what does reorg refer to when it's maybe from the perspective of these five ways of teams changing?

**中文翻译:**
好的，让我们来聊聊团队重组的类型。这是你书中的核心内容，我们还没聊到呢。你确定了团队变化的五种方式。你能带大家过一遍，帮大家理解它们是什么吗？另外，我们在对话中经常用到“Reorg”（组织架构调整）这个词，我觉得这是大多数人对变化的理解。在我们过完这个列表后，从这五种团队变化方式的角度来看，“Reorg”到底指的是什么？

---

### [00:17:32] Heidi Helfand

**English:**
Sure. Okay, so the five patterns of reteaming. One by one, someone joins your company or someone leaves your company, grow and split. It's a growth pattern. Teams grow bigger and then they split into two or more teams. Opposite of grow and split is merging. Sometimes two or more teams merge together. It's more of a shrinking pattern. We might be seeing more of this these days as companies downsize. Things merge together and consolidate. Isolation is, or innovation by isolation. Start a new team off to the side, a beneficial silo, give that team process freedom, great for catalyzing new product lines within your existing company. Also great for emergencies and they just happen anyway if we have incidents and people have to come together, solve an incident and then go back to their teams. And switching. So switching is moving from one team to another team. You can do this at a variety of cadences, short term, long term.
(00:18:36):
And then difference between a reteaming and a reorg. I think reorg is a word that has very traditional baggage and connotations. And when I was writing *Dynamic Reteaming*, it just didn't feel like an appropriate word to use for, well, Sue is looking to learn a little bit about how our web operations work, she's going to move to that team. It didn't feel appropriate to call that a reorg because Sue's moving and switching from one team to the next. I think reorg again... Reorganization is a traditional word. It implies on the large, it implies top-down changes that you have say no. It's something different than what I consider reteaming, which is these five patterns that happen at different levels.

**中文翻译:**
好的，团队重组的五种模式：
1. **逐一增减（One by one）**：有人加入公司或有人离开公司。
2. **增长与拆分（Grow and split）**：这是一种增长模式。团队规模变大，然后拆分成两个或更多团队。
3. **合并（Merging）**：与增长拆分相反。有时两个或更多团队合并在一起。这更多是一种收缩模式，现在随着公司裁员，我们可能会看到更多这种情况，事物合并并整合。
4. **隔离（Isolation）**，或者说“通过隔离进行创新”：在旁边建立一个新团队，一个“有益的孤岛”，赋予该团队流程自由，非常适合在现有公司内催生新产品线。也适用于紧急情况，比如发生事故时，人们必须聚在一起解决问题，然后回到各自的团队。
5. **切换（Switching）**：即从一个团队移动到另一个团队。你可以以各种节奏进行，短期的或长期的。
(00:18:36):
至于“团队重组”（Reteaming）和“架构调整”（Reorg）的区别：我认为 Reorg 是一个带有非常传统包袱和内涵的词。当我写《动态团队重组》时，我觉得用这个词来描述“Sue 想了解一下我们的 Web 运营是如何工作的，所以她要搬到那个团队”并不合适。把 Sue 的团队切换称为 Reorg 感觉不对。Reorg（Reorganization）是一个传统词汇，它暗示着大规模、自上而下的变革，你往往没有发言权。这与我所认为的“团队重组”不同，后者是发生在不同层级的这五种模式。

---

### [00:19:30] Lenny

**English:**
Awesome. So let me just repeat back these five. So one by one, basically people joining your team, leaving your team, something very natural. People do all the time.

**中文翻译:**
太棒了。让我重复一下这五种。首先是“逐一增减”，基本上就是有人加入或离开你的团队，这很自然，大家一直在经历。

---

### [00:19:37] Heidi Helfand

**English:**
Your company.

**中文翻译:**
是你的公司。

---

### [00:19:39] Lenny

**English:**
Or your company, yeah. Growing, splitting a team gets really large and then it's like, okay, let's just split this into two, focus them on specific things instead of this one team trying to cover too much. Merging teams, the opposite of that. Isolation. I want to chat about that one a little more where you just have a team off to the side and they're just dedicated to something that you find really important. So with isolation, you have this awesome story of your time at a company called Expertcity, which turned into something people know most likely and ended up being a great outcome because of this reteaming into an isolation team. Could you talk about that?

**中文翻译:**
或者是你的公司，没错。然后是“增长与拆分”，团队变得非常庞大，然后决定拆成两个，分别专注于特定事务，而不是一个团队承担太多。接着是“合并团队”，即前者的反面。最后是“隔离”，我想多聊聊这个，就是你在旁边设立一个团队，专门负责你认为非常重要的事情。关于隔离，你在 Expertcity 公司有一段精彩的往事，那家公司后来变成了大家耳熟能详的名字，并且因为这种“隔离团队”的重组方式取得了巨大的成功。你能聊聊那个吗？

---

### [00:20:14] Heidi Helfand

**English:**
Yeah, so I've been at different startups that have grown bigger and one of them, I was the 15th employee. I started as a web editor and became an interaction designer. And we were going to change the world and it was very exciting. We were in Santa Barbara, California. So the company's called Expertcity. And we were working on our first product, which was a marketplace for tech support. So imagine you have a problem on your computer, you can go to our website and then you can select an expert to see and control your screen to help you solve your tech support challenge. And so we had the screen sharing technology that we were inventing in the company. We had the web-based software to manage the interaction between the customer and the expert. We had the experts. We had in-house experts and then the vision was global worldwide experts. You were going to be like this marketplace, this eBay of services is what we talked about in the early days. I was really into this.
(00:21:17):
This was my first job in tech and I became an interaction designer working on kind of front-end UI flows with engineers. It's actually before the word interaction designer, my title was navigation designer. We made this up. So I was very into... It was before the words like UX and other things. People were talking about information architecture and other sub-genres of design. And we had individual offices. I had all the interaction flows on my walls. I was really into the words and one day I was in there and we were working on a new flow. We had all these hopes and dreams for this product and the CEO came into my office and he said, "Heidi, stop working on the marketplace. We're not going to do that product anymore. We're killing it because nobody's buying it and made six bucks or something last month." And he said, "Go to the beach." We were by Santa Barbara. I'm like, "What do you mean go to the beach?" He's like, "Well, I don't want you to start any work that you're going to have to maintain later as we figure out our next step." And I was like, "Okay."
(00:22:29):
I remember that day and I'm looking around my office and all these flows on the walls. So really these were domains like domain-driven design. It was all these web domains and which user interactions were going to happen and all these hopes and dreams and it was the first time in my career where we were told not to work on something. It wasn't paused. Some people say, "Oh, we're going to pause this," and then they never get back to it. This thing was like [inaudible 00:22:59]. And I didn't get it. I just didn't get it. I cried, I acted out, I sent this email like, "How can we kill the marketplace? It must live." It was quite an experience.
(00:23:14):
But then, and I don't know what the timing was, I was invited to be on this team off to the side and there was market validation going on. Our founders and product and others became students of market validation, *Four Steps to the Epiphany*. So we had built this thing, we spent all this time on this marketplace, but nobody would buy it. And so it was like do or die. We had to shift. This was before lean startup. So *Four Steps to the Epiphany* was the book, it was the manual, it was guiding the way. And so there were people that had a ton of conversations with potential customers about this new thing that we were going to build.
(00:23:58):
And so I was invited to be at this team off to the side and there was a small team and we didn't have to do waterfall software development. We were freed from that. We were liberated from that. We got to work in other ways. And I remember working with an engineer and we were figuring out how to create a forgot password flow because none of these patterns existed back then and we got to do this stuff. We got to deploy more frequently and the product was called GoToMyPC where you could see and operate someone's computer from a distance. And that was essentially the pivot that I feel like saved the company. Later we went on, we got folded back into the teams and we built GoToMeeting and GoToWebinar as a technical project manager at that time. So taking a team off to the side, giving that team process freedom. They didn't want us distracted from the drag.
(00:24:58):
When you're working on an existing product line, you get this cadence and it can become a mature cadence. Maybe people work in two weeks or one week now, but when you're working on something new, you need faster iteration loops. And our founders knew that need. So it was a privilege and I was delighted to be part of this other team and it was really, really exciting. So then looking back over the years, I was like, yeah, isolated teams, beneficial silos. Again, it's going against green of what some of these books say, oh, you want to desilo everything? No, sometimes there's a reason why you have a problem. You want to solve the problem. This was like, I mean, was this company going to go under? I didn't think of those kind of things at the time because I was just super into the work and very passionate and motivated about what we were building. But yeah, isolation pattern came up and we used it at another startup as well ever since.
(00:25:59):
So yeah, that's the story of Expertcity and from my perspective. Ask different people at different vantage points, but that... If we would've stayed within our teams and we would've had to develop with pixel-perfect mockups done in Photoshop like, "Here you go," I don't think we would've been fast enough. That was not good for the innovation that we needed. So it's also like innovation by isolation. It's good for emergencies. I was at another startup, we had performance issues with our first product. People left teams, brought a consultant in, went into a conference room for a couple of weeks, figured out some major changes that needed to happen, solve them, went back to the teams. This is not a new concept. The Chicken McNugget was saved by an isolated team, SWAT team.
(00:26:57):
There's a book called *Teamwork*. It's an old book from, I think the '70s, I have in my bookshelf here, and there's a story of the Chicken McNugget that you can read about where they brought in a consultant and had a very small team who worked in a different... They didn't work in their same plant where they were developing the product. They worked in a different plant. They reported straight up to one of the executives at McDonald's. And yeah, the Chicken McNugget lived on because it was like having challenges in the test marketplace in Indianapolis. So we didn't make this up. It's just like some of these things are kind of like, "Oh, it's like a noticing," and then you're like, "Oh, that's pattern." So it's collection.

**中文翻译:**
是的，我待过几家不断壮大的初创公司，其中一家我是第 15 号员工。我最初是网页编辑，后来成了交互设计师。我们当时想改变世界，那非常令人兴奋。公司在加州圣巴巴拉，叫 Expertcity。我们当时在做第一个产品，是一个技术支持市场。想象一下，你的电脑出了问题，你可以上我们的网站，选择一个专家，让他查看并控制你的屏幕，帮你解决技术难题。所以我们公司发明了屏幕共享技术，开发了管理客户与专家互动的 Web 软件。我们有专家，最初是内部专家，愿景是全球专家。我们想做成这种市场，就像早年间我们讨论的“服务领域的 eBay”。我当时非常投入。
(00:21:17):
这是我在科技行业的第一份工作，我成了交互设计师，和工程师一起负责前端 UI 流程。其实在“交互设计师”这个词流行之前，我的头衔是“导航设计师”，那是我们自创的。我当时非常痴迷……那是在 UX 等词汇出现之前，人们在谈论信息架构和其他设计子领域。我们有独立的办公室，墙上贴满了交互流程图。我非常在意那些细节。有一天，我正在办公室里设计一个新流程，我们对这个产品充满了希望和梦想，CEO 走进我的办公室说：“Heidi，别做那个市场产品了。我们不做了，我们要砍掉它，因为没人买，上个月才赚了 6 块钱左右。”他说：“去沙滩玩吧。”我们就在圣巴巴拉海边。我问：“去沙滩是什么意思？”他说：“我不希望你开始任何以后我们需要维护的工作，我们要先想清楚下一步。”我当时心想：“好吧。”
(00:22:29):
我记得那天，我环顾办公室，墙上全是流程图。这些其实就是领域，就像领域驱动设计（DDD）。全是这些 Web 域名、用户交互、希望和梦想，那是我职业生涯中第一次被告知不要做某件事。不是暂停，有些人说“我们要暂停这个”，然后就再也没下文了。这个是直接砍掉。我当时不理解，完全不理解。我哭了，我闹情绪，我发邮件说：“我们怎么能砍掉这个市场？它必须存在！”那真是一段难忘的经历。
(00:23:14):
但后来，我不记得具体是什么时候了，我被邀请加入一个“旁支团队”，当时正在进行市场验证。我们的创始人、产品人员和其他人都成了市场验证的学徒，学习《顿悟的四个步骤》（*Four Steps to the Epiphany*）。我们花了这么多时间建立这个市场，却没人买。所以那是生死存亡的时刻，我们必须转型。那是在“精益创业”流行之前，《顿悟的四个步骤》就是我们的手册，指引着方向。当时有人与潜在客户进行了大量对话，讨论我们要构建的新东西。
(00:23:58):
于是我被邀请加入这个旁支团队，那是一个小团队，我们不需要遵循瀑布式软件开发。我们从中解放了出来，获得了自由。我们以其他方式工作。我记得和一个工程师一起研究如何创建“忘记密码”流程，因为那时还没有这些模式，我们得自己摸索。我们可以更频繁地部署。那个产品叫 GoToMyPC，你可以远程查看和操作别人的电脑。这基本上就是我认为拯救了公司的转型。后来，我们被合并回大团队，我当时担任技术项目经理，开发了 GoToMeeting 和 GoToWebinar。所以，把一个团队拉到一边，给他们流程自由。他们不想让我们被现有的负担分散注意力。
(00:24:58):
当你负责现有的产品线时，你会有固定的节奏，那可能是一个成熟的节奏。也许现在人们是以两周或一周为一个冲刺周期，但当你开发新东西时，你需要更快的迭代循环。我们的创始人知道这种需求。所以那是一种特权，我很荣幸能成为那个团队的一员，那真的非常令人兴奋。所以多年后回过头看，我觉得：是的，隔离团队，有益的孤岛。这再次违背了一些书里说的“哦，你要消除所有孤岛”。不，有时孤岛的存在是有原因的，因为你有问题要解决。当时公司面临倒闭吗？我那时没想那么多，因为我完全沉浸在工作中，对我们正在构建的东西充满激情。但没错，“隔离模式”出现了，从那以后我们在另一家初创公司也用过它。
(00:25:59):
这就是 Expertcity 的故事，至少是从我的视角来看。问不同位置的人可能会有不同看法，但……如果我们留在原团队，必须用 Photoshop 做像素级完美的视觉稿，然后说“给你”，我觉得我们根本快不起来。那不利于我们需要的创新。所以这也是“通过隔离进行创新”。它也适用于紧急情况。我在另一家初创公司时，第一个产品出现了性能问题。大家离开原团队，请来顾问，在会议室里待了几周，找出了需要进行的重大变更，解决了问题，然后回到原团队。这并不是什么新概念。麦乐鸡（Chicken McNugget）就是被一个隔离的团队、一个“特种小组”（SWAT team）拯救的。
(00:26:57):
有一本书叫《团队合作》（*Teamwork*），是一本 70 年代的老书，就在我的书架上。里面讲了麦乐鸡的故事，你可以去读读。他们请来顾问，组建了一个非常小的团队，在不同的……他们不在生产产品的同一个工厂工作，而是在另一个工厂。他们直接向麦当劳的一位高管汇报。麦乐鸡得以存续，是因为它在印第安纳波利斯的测试市场遇到了挑战。所以这不是我们发明的，只是有些事情就像是“一种观察”，然后你会发现“哦，那是一个模式”。这就是一种收集。

---

### [00:27:39] Lenny

**English:**
There's this idea of a startup within a big company. Everyone's like, "Oh, it's just like the startup within a big company. We have all the resources that we need. There's no less risk, but we can innovate and try new things." Rarely does it feel like it work out. You're sharing stories where it does. Is there anything you found or any advice for how to actually be successful in this idea of having a team off to the side doing something innovative and different?

**中文翻译:**
有一种说法叫“大公司内部的创业公司”。大家总说：“哦，这就像大公司里的创业公司，我们有所有需要的资源，风险更小，但我们可以创新并尝试新事物。”但这种模式很少能成功。你分享了一些成功的案例。关于如何成功运作这种“旁支创新团队”，你有什么发现或建议吗？

---

### [00:28:00] Heidi Helfand

**English:**
At AppFolio we did this. So there's a company called SecureDocs; it branched off into its own company and it was just acquired, I believe in 2022. When SecureDocs was happening, I was not on that team. I was on the other teams and I was watching, and again, same pattern. A team was created off to the side and they were given process freedom. They worked in more of a daily sprint style as opposed to the two-week sprint style that our other teams were doing at the time at early AppFolio. And so, one, isolate the team or put them in a different area. We could still see them. We were in this big open room, but it was their team area. I mean we had these impermanent walls between some of the teams. It was their region and they claimed it and they named themselves.
(00:28:58):
And so, one, separate location. There's another story in the book about a team that incubated a product idea within Citrix and they were in a garage of all places, so they were really isolated. But just put the team in a different region, make it that area. That's number one.
(00:29:17):
Number two, tell other people not to disturb this team. That's key. And hearing it from a leader is really, really important. No, you're not going to pull them into something else. They're working on this other thing. So people need to shed their skin of the other things that they're working on. If you take a bigger picture, kind of forest through the trees picture, you want people pairing and switching pairs so they're not single owners of the system. So when they have an opportunity to do something that could be really important to the company beyond one of these isolated teams, they can fade out and not be the only owner that has to transfer knowledge and then field questions for two years on how that system works. You want to build this redundancy in your teams. So that's like if you really want to plan ahead, do that first. Have that as part of how you operate, building this team redundancy and switching, because then it frees people to not be the only owner of a system and chained to a system.
(00:30:15):
And so isolate them. Tell people not to bother them. Do pairing and have shared ownership so it's easier for somebody to switch into something like this. Process freedom. Again, they can do things differently. Ideally they report up to someone that really has decision-making authority and decisions won't get reversed. Or they have to go through some complex web of like, "Is it okay if we do this?" No, you need a clear decision-making structure. They saw that at the McDonald's case study as well, which is not in my book, but it's in [inaudible 00:30:52] book called *Teamwork*.
(00:30:53):
And then that group, having that senior leader that they report into, getting the clear lines of communication there is also really important. So not having this heavyweight bureaucracy of, I don't know, quarterly business updates where everybody's making a slide deck for two years before they go to that meeting, trying to relieve the team of things like that and make it lighter.
(00:31:25):
And some of these teams, like SecureDocs became another product at AppFolio that was very, very successful. At one point, I think it was before we went public, it branched off into its own separate entity. I think maybe they shared a board member or something. I don't know how that worked, but it became its own entity. SecureDocs became separate and then it grew from there. And then it became this wonderful successful product that was recently acquired. People come and go at companies and companies grow and change and morph, and that was one case of departures that it's like bitter, sweet. You're happy for your friends and colleagues say, "Oh, he's going to be a CTO. He's going to be the CTO."
(00:32:14):
There's this entity. I remember visiting their office in Santa Barbara. It's great to see your friends succeed and thrive. And we developed other companies in that way.

**中文翻译:**
我们在 AppFolio 就这样做过。有一家叫 SecureDocs 的公司，它最初是分拆出来的，我记得在 2022 年刚被收购。SecureDocs 成立时，我不在那个团队，我在其他团队观察。模式是一样的：在旁边建立一个团队，给他们流程自由。他们采用的是每日冲刺（Daily Sprint）模式，而不是当时 AppFolio 其他团队采用的两周冲刺模式。所以，第一，隔离团队或把他们放在不同的区域。我们还能看到他们，大家都在一个大的开放空间里，但那是他们的专属区域。我们在团队之间有一些临时隔断，那是他们的领地，他们自己命名。
(00:28:58):
所以，第一是物理位置的分隔。书里还有一个故事，讲的是 Citrix 内部孵化一个产品创意，团队居然是在车库里工作的，所以他们非常隔离。总之，把团队放在不同的区域，划定专属领地，这是第一点。
(00:29:17):
第二，告诉其他人不要打扰这个团队。这很关键。而且这话由领导者说出来非常重要：“不，你不能把他们拉去干别的，他们在做另一件事。”所以人们需要摆脱手头其他工作的束缚。如果你从大局出发，也就是“见林也见树”，你会希望大家进行结对编程（Pairing）并轮换搭档，这样就不会出现系统的单一所有者。这样当他们有机会去做一些对公司非常重要的事情时（比如加入隔离团队），他们可以淡出原岗位，而不会因为是唯一的知识拥有者而必须花两年时间交接和回答问题。你要在团队中建立这种冗余。如果你想提前规划，先做这一步。将其作为运营的一部分，建立团队冗余和轮换机制，因为这能让员工不被某个系统锁死。
(00:30:15):
所以：隔离他们；告诉别人别烦他们；进行结对和共享所有权，方便人员切换；给他们流程自由，让他们可以用不同的方式做事。理想情况下，他们直接向真正拥有决策权的人汇报，这样决策就不会被推翻，也不需要经过复杂的审批流程问“我们能这么做吗？”你需要清晰的决策结构。麦当劳的案例中也体现了这一点，虽然没在我的书里，但在那本叫《团队合作》的书里有。
(00:30:53):
此外，让该小组向一位高级领导汇报，建立清晰的沟通渠道也非常重要。不要有那种沉重的官僚主义，比如每季度的业务更新，大家在开会前要花两年时间做 PPT。要尽量减轻团队的这种负担，让流程更轻量化。
(00:31:25):
其中一些团队，比如 SecureDocs，后来成了 AppFolio 旗下非常成功的产品。我记得在公司上市前，它分拆成了独立的实体。也许他们共享董事会成员什么的，我不清楚具体运作，但它成了独立实体。SecureDocs 独立后开始壮大，最终成了一个非常成功的、最近刚被收购的产品。公司里人员进进出出，公司也在成长、改变和演变。那次分拆就像是苦乐参半的离别，你为朋友和同事感到高兴，说：“哦，他要去做 CTO 了。”
(00:32:14):
那个实体就在那儿。我记得去过他们在圣巴巴拉的办公室。看到朋友们成功并茁壮成长真的很棒。我们也以这种方式培养了其他公司。

---

### [00:33:27] Lenny (Sponsorships)

**English:**
This episode is brought to you by Ahrefs. Many of you already know Ahrefs as one of the top tools for search engine optimization. It's used by thousands of SEOs and companies like IBM, Adidas and eBay. What you may not know is that there's a free version that was made with small website owners in mind. It's called Ahrefs Webmaster Tools. It's free and it can help you bring more traffic to your website. Ahrefs Webmaster Tools will show you keywords that you rank for and back links that you can get. It also performs automated site audits to find what issues prevent your website from ranking higher on Google. Every detected issue comes with a detailed explanation and advice on how to fix it. Visit ahrefs.com/awt, set up a free account, connect your website and start improving it. That's A-H-R-E-F-S.com/awt.

**中文翻译:**
本期节目由 Ahrefs 赞助。你们中的许多人已经知道 Ahrefs 是顶级的搜索引擎优化（SEO）工具之一。成千上万的 SEO 专家以及 IBM、阿迪达斯和 eBay 等公司都在使用它。你可能不知道的是，它还有一个专门为小型网站所有者设计的免费版本，叫做 Ahrefs Webmaster Tools。它是免费的，可以帮助你为网站带来更多流量。Ahrefs Webmaster Tools 会显示你排名的关键词以及你可以获得的后向链接。它还会执行自动化的网站审计，找出阻碍你网站在 Google 上获得更高排名的因素。每个检测到的问题都附有详细的解释和修复建议。访问 ahrefs.com/awt，注册免费账户，连接你的网站并开始优化。

---

### [00:33:43] Lenny

**English:**
I feel like to me one of the most important ones you've talked to. And this is having an executive essentially sponsoring this team and supporting and protecting it versus some managers just like, now we're going to go do this off to the side, because otherwise no one's going to really take that seriously.

**中文翻译:**
我觉得你提到的最重要的一点是：必须有一位高管实质性地赞助这个团队，支持并保护它。而不是几个经理随口说“我们要去旁边搞这个”，因为如果没有高管支持，没人会当真。

---

### [00:33:43] Heidi Helfand

**English:**
Yeah, I think that's really, really important. I'll also say that things don't always succeed a hundred percent. I've seen isolated teams within companies where someone has the opportunity to sell something, they talk to their friends who are the engineers who build the feature for them, but then it leaves something for other people to maintain later and they weren't involved in the decisions. And it can be a big mess for all of these patterns there. It's like kind of like balconies and basements. You can screw it up too. It's not all stuff is hard. That's why I like to lean into it and I've written about it. Things take effort. The tree is going to drop the leaves and you got to sweep them up. Everything takes work and effort.

**中文翻译:**
是的，我认为这非常非常重要。我也要说，事情并不总是百分之百成功。我见过公司内部的隔离团队，有人有机会卖掉一些东西，他们找工程师朋友帮他们开发功能，但随后留下的烂摊子却要让那些从未参与决策的人来维护。这些模式处理不好都会变成大麻烦。这就像“阳台与地下室”的关系，你也有可能搞砸。并不是所有事情都很难，但确实需要投入。这就是为什么我喜欢深入研究并写出来。凡事都需要努力，树会落叶，你就得清扫。一切都需要付出劳动。

---

### [00:34:33] Lenny

**English:**
We've talked about the isolation pattern. I thought it'd be good to talk through the rest of the patterns real quick and share maybe one or two tips for how to be successful or make it work well or better.

**中文翻译:**
我们已经聊过了“隔离模式”。我觉得把剩下的几种模式也快速过一遍，并分享一两个成功秘诀或改进建议会很有帮助。

---

### [00:34:45] Heidi Helfand

**English:**
Sure.

**中文翻译:**
没问题。

---

### [00:34:46] Lenny

**English:**
Before you start, actually, I think I missed a nuance and you corrected me, but I think I missed it, which is for the one-on-one pattern, it's actually describing joining the company specifically not joining a team. Is that right?

**中文翻译:**
在你开始之前，其实我刚才漏掉了一个细节，你纠正了我，但我可能还没完全理解：关于“逐一增减”模式，它实际上是指加入“公司”而不是加入某个“团队”，对吗？

---

### [00:34:56] Heidi Helfand

**English:**
Yeah. And in the book it might be a little blurred because this is like some of the... Switching and one by one sound very similar, and they do have some Venn diagram overlaps, but I'll distinguish them as I talk about them.

**中文翻译:**
是的。在书里可能有点模糊，因为“切换”和“逐一增减”听起来很像，它们确实有一些交集，但我会在讲解时把它们区分开。

---

### [00:35:11] Lenny

**English:**
Cool.

**中文翻译:**
好的。

---

### [00:35:12] Heidi Helfand

**English:**
So one by one, someone joins your company or they leave your company. So the tip with one by one is when someone joins, help them feel a sense of belonging, and you can do that through not having their first day be them sitting over there alone. You could have someone have a first pair. There's a chapter in my book about onboarding. This is in the space of onboarding. Also with one by one, when people join, you also need to pay attention to the people who are already there and it's good for them to know when someone is joining the company; that it shouldn't be a surprise. So visualizing the hiring and the opportunities is something that I think is a really good idea. It could be challenging for someone if somebody joins and they become their manager, but what if that person wanted to be the manager and then they brought in someone from the outside to become the manager?
(00:36:08):
So you need to pay attention to the new hires that are joining, help them feel a sense of belonging, get them to talk about themselves, which is said to increase their sense of connection and retention. There's some research in the book *The Culture Code* by Daniel Coyle, which talks about that. But then it's also important to coach the people through change that are already at the company, especially if they weren't involved in the particular decision, bringing on this new leader that comes in and brings in all their people. So you got to pay attention to different people.
(00:36:45):
Grow and split is a natural thing that happens when you're like startup scale up and growing bigger and bigger. The first team probably grows bigger and then splits into two or three. So when the team gets bigger, facilitation and communication tends to break down. So some signals that teams might bring up when they feel like a change might be helpful is the meetings are taking longer. You're in that case where it's harder to make decisions. It was easier when there were like five of us, but now they're 13. The work becomes divergent. They're working on this one thing, they're working on something else. No one's paying attention in the standup so much anymore because this work has diverged. And those are a few of the signals. And then someone typically brings it up. If you normalize the idea that it's okay for teams to have input into their future structures, maybe they'll bring it up and decide that, "Hey, it might be better if we split."
(00:37:52):
Sometimes splitting though can create dependencies that weren't there when you were together as one team. So you inherit other problems or you might inherit challenges like, all right, the team decides it's far effective if they split into two or three, but we just have one product manager, we just have one designer. We just have one person who helps us anticipate quality challenges. So it's a lot of problem trading when you do a lot of this stuff. Like anything, you have a challenge, how might we solve it? Well, there's option A, option B and option C. So that's grow and split and it's very common I think when your company is growing and changing, kind of like that.
(00:38:37):
Merging is the opposite of grow and split. Two or more teams combine together. Or at a higher level, a company acquires another company and then there's a merging that happens. So merging I think is related to when companies downsize or shrink, things consolidate, come together, or again, when at the company level companies combine, one acquires another, gets acquired. How that goes down varies, but there's this concept called panarchy that I write about in my book that a lot of these changes is changes at the individual level, the team level, the team of teams level, department level, the company level. So yeah, merging. So there's a business decision that the companies merge together and then changes might ensue.
(00:39:28):
So maybe the company wants to get ahead on building and having another vertical in their SaaS company. We acquired a company at AppFolio to bring us faster into workflow software for law firms. So we acquired a company based in San Diego, and that got us a couple of years ahead. I remember one of the leaders saying that. So again, we weren't involved... I wasn't involved in this decision as an IC at the time. So it could be a business decision for merging at that level. It could be that people leave, there are departures and teams and responsibilities consolidate together. That's merging. So it could be that kind of shrinking that we're seeing. It could be that the company is having one leader instead of three and there's a consolidation and the teams kind of merge together. So it's the opposite of grow and split.
(00:40:23):
One activity I do like to do with teams that merge is called story of our team. That's in chapter 13 of the second edition. So with story of our team, each team makes a timeline of... They stand in order of when they joined their team and they make a timeline with milestones of when they joined their team, when people left, and significant events and things they created that they're excited about and that they're proud of. And that they branch together with their newly merged team, and then it's good to get a shared sense of history. So you have these teams or companies that come together, they make shared timelines, they share their milestones and things that they built that they're proud of. They tell each other about it and then they have a sense of like, "Wow, we didn't know that. Oh, I didn't know that you had built a system like that. We did too." Or, "We've never built anything like that. That is so cool. What did you learn from that?" We get to learn about each other and then we're together. We're like, "All right, we're this merged entity now. What's next?" Looking out to the future so we have the same shared vision. So I love doing that. There's different tactics you can do before, during, and after each of these patterns. Yeah, that's merging.
(00:41:46):
Isolation we talked about before. Put the team up to the side, give them process freedom, have them report up to a decision maker, tell the other teams not to bother them. Let them work at the cadence that they want to work at. That makes it easier. If you are doing a short-term thing, you got to work it out with the larger entity so you don't create something in isolation that other people have to maintain. There's ways that this can be messed up.
(00:42:15):
And then switching. Switching pattern is really tied to learning and development and fulfillment. It could be that you want to work with other people. Like forming, storming, norming, performing, Tuckman's model, he forgot the phase called stagnating. Sometimes it feels like we're in a team for too long. We're tired of working with these people. We want a little variety. We want to work with that person over there. Or maybe we want to work on a new system. We don't have the opportunity to do that in our current team, but what if we could work on that system over there with those people? It could totally refresh us. It could be like having a new job within our same company. It could extend the lifespan of the amazing employee in your company. So switching is tied to that kind of fulfillment, which is one of the reasons why I made it separate from one by one and tied that to the company.
(00:43:11):
The other thing with switching is that you could create safety nets in your company through switching. I just wrote a newsletter post about this yesterday because maybe we're going to have some more changes this year. Maybe companies are going to be hiring less. I don't like the thought of companies downsizing or having layoffs or anything like that, but I think to myself, well, have multiple owners of a system. So not only one person is that tower of knowledge that owns that one system. There's some stories in my book where I interviewed Richard Sheridan, who is the chief storyteller and co-founder of a wonderful company called Menlo Innovations in Ann Arbor, Michigan. They built their company Menlo to have people work in pairs. Not just the software engineers; team members work in pairs and they switch pairs at a regular cadence. And you know that when you're joining the company because you're involved in some kind of pairing. So there's parity from when you're interviewing to when you're at the company.
(00:44:14):
But switching also helps build that knowledge redundancy in your company. A little more about tolerance. So if someone leaves, they don't leave with all the information in their head. We had that. At that first startup Expertcity, we had some single owners of systems and when they left, it just becomes a challenge and a setback. And at AppFolio we shared a founder between the first startup and the second startup. Many of their early engineers from that first startup went to the second startup.
(00:44:50):
I was 10th at AppFolio. I was 15th at Expertcity. So we wanted to work together. So it was that global idea of switching one by one or similar. But anyway, at the second startup we had the chance to do things differently. So we had pairing and switching pairs and test-driven development. We had help to do that, but this kind of redundancy built safety into our systems, especially when AppFolio is processing a lot of rent payments. There's a lot of money. There's ACH going through. Those are critical systems and it's very important that things are safe and secure. You don't want to haphazardly switch people around. You can screw this up, again, that balconies and basements concept. You don't want somebody over here, they will switch every two weeks and have no say in their team. There's ways to screw all of this up, but there's other ways to do it well.
(00:45:48):
I remember when we were at our first team at AppFolio and we did a grow and split. It grew and it split into two or three teams. I remember there was a loss for some of the engineers who wanted to pair program with some of the other engineers, and they started a regular rotation themselves from one team to the next, and that brought fulfillment. It brought joy. I mean they would see each other in the workspace every day, but they wanted to work together. It brought them learning joy and fulfillment, and I love that. For those who are like keep the team stable and the same forever, I'm like, "Well, what about that?" It brings me satisfaction and joy when I see my colleagues. It's like autonomy, mastery, purpose, like Dan Pink's book *Drive*, when people are really given some agency and the opportunity to work a little bit differently than maybe that traditional boxed version you might see on my bookshelf. You can really create not only products that people love, but companies that people love and want to be at.

**中文翻译:**
1. **逐一增减（One by one）**：有人加入或离开你的公司。建议是：当有人加入时，帮助他们建立归属感。不要让他们第一天上班就孤零零地坐着，可以安排一个“结对伙伴”。我书里有一章专门讲入职（Onboarding）。此外，当有人加入时，你也要关注老员工，让他们提前知道有人要来，而不是感到意外。将招聘和机会可视化是个好主意。如果新来的人成了某人的经理，而那个人原本想当经理，这可能会产生挑战。
(00:36:08):
所以你要关注新员工，让他们谈谈自己，这能增加他们的连接感和留存率。丹尼尔·科伊尔的《文化密码》中提到了相关研究。同时，辅导老员工度过变革也很重要，尤其是当他们没有参与决策（比如空降一个带了自己团队的领导）时。
2. **增长与拆分（Grow and split）**：这是初创公司规模扩大时的自然现象。第一个团队变大，然后拆成两三个。当团队变大时，协调和沟通往往会出问题。信号包括：会议时间变长；决策变难（5 个人时很容易，13 个人就很累）；工作内容开始发散（大家各忙各的，站会没人听）。如果团队能参与架构设计，他们可能会主动提出拆分。
(00:37:52):
但拆分会产生以前没有的依赖关系。你可能会面临“问题交换”：团队拆开了，但我们只有一个产品经理、一个设计师。这就像任何挑战一样，你有方案 A、B、C，需要权衡。
3. **合并（Merging）**：与增长拆分相反。两个或多个团队合并，或者公司层面的并购。这通常与公司缩减规模、整合有关。这涉及一个叫“泛层级”（Panarchy）的概念，变革发生在个人、团队、部门、公司等不同层面。
(00:39:28):
合并可能是业务决策，比如为了快速进入某个垂直领域。在 AppFolio，我们收购了一家圣地亚哥的公司，让我们在律师事务所工作流软件方面领先了几年。当时我作为一名基层员工（IC）没有参与决策。合并也可能是因为人员离职，职责需要整合。
(00:40:23):
我喜欢在团队合并时做的一个活动叫“我们的团队故事”。每个团队按入职顺序排队，画出包含里程碑的时间轴：什么时候加入、谁离开了、创造了什么引以为傲的东西。然后两个团队的时间轴交汇，分享历史。这能让大家发现：“哇，原来你们也建过那样的系统！”或者“太酷了，你们学到了什么？”这能建立共同愿景。
4. **隔离（Isolation）**：之前聊过。把团队拉到一边，给他们流程自由，向决策者汇报，让其他团队别烦他们。让他们按自己的节奏工作。如果是短期项目，要和母体协调好，避免留下难以维护的烂摊子。
5. **切换（Switching）**：这与学习、发展和成就感密切相关。塔克曼模型（组建、激荡、规范、执行）漏掉了一个阶段叫“停滞”（Stagnating）。有时在一个团队待太久会累，想换个环境，和不同的人合作，或者研究新系统。这就像在同一家公司换了份新工作，能延长优秀员工的职业寿命。
(00:43:11):
切换还能建立“安全网”。我昨天刚写了一篇关于这个的简报。如果公司招聘减少，你更需要系统有多个所有者，而不是让某个人成为唯一的知识塔。我采访过 Menlo Innovations 的 Richard Sheridan，他们公司推行全员结对，并定期更换搭档。这在面试时就会告知。
(00:44:14):
切换能建立知识冗余。如果有人离开，他们不会带走所有信息。在 Expertcity 时，我们有些系统只有一个人懂，他一走我们就很被动。在 AppFolio，我们通过结对和切换建立了安全性，尤其是在处理大量租金支付和 ACH（电子转账）等关键系统时。当然，你不能胡乱切换，比如每两周强行换一次且不听员工意见，那会搞砸。
(00:45:48):
我记得 AppFolio 的第一个团队拆分时，有些工程师很失落，因为不能再和某些同事结对了。于是他们自发组织了跨团队轮换，这带来了快乐和成就感。对于那些坚持“团队必须永远稳定”的人，我想说：看到同事、拥有自主权、精进和目标（如丹·平克的《驱动力》所言）能让员工更爱公司。

---

### [00:47:03] Lenny

**English:**
All these stories of team changes and reorg, it made me think about a quote that one of my managers always used to say about reorging and changing teams is that there's no perfect org structure. There's only the best idea you have at the time for what the org could be. And then there's the issues with that org that you identify as you're putting in place and then set up processes and systems around to try to catch that dependencies, as you said, or overlap of ownership. Is there anything along those lines that comes up of just things you found of just like, there's never going to be the perfect way to do it. This is just our best idea at the time and here's how we deal with the downsides of this approach?

**中文翻译:**
听了这些故事，我想起我的一位经理常说的话：没有完美的组织架构，只有你当时能想到的最佳方案。当你实施它时，你会发现其中的问题，然后建立流程和系统来解决依赖关系或所有权重叠。关于“永远没有完美方案，只有权衡利弊”这一点，你有什么发现吗？

---

### [00:47:41] Heidi Helfand

**English:**
Yeah, I think there's a lot of wisdom to what your manager said and your colleague there because yeah, I mean as time goes on, conditions change. We evolve and change. We're subject to different influences. COVID happens. We weren't dealing with that 10 years ago. We grow and adapt and morph. We try to get together and make the best decisions that we can when we're faced with challenges, and a lot of it is problem trading. We have this challenge today. We decide, oh, there's a few ways we could handle this. Pros and cons of each solution. It's like the Toyota Kata, like grasp the current condition. You'll experience you have challenges. What's the next evolution or the next target condition? How might you get there? And then you're there and you're like, okay, grasp the current target condition. What's it like? What are you experiencing? Oh, we might try this. We're always transforming from the current state to the future state.
(00:48:54):
So to that, I would ask people, well, how do you want that to be? And how do you want to show up and be as a leader? You want to just be like, "All right, I've got to get this done. The reorg is done by an email and we're just sending it out, or this small team change. And here it is; it's done. Goodbye." Or is it a little bit where you get people's input? And that in itself, you got to weigh what you're dealing with, again. But I like to think about that. What kind of leader do you want to be? Leaders need patience. It's hard to be a leader. It's challenging, but what kind of an environment or vibe do you want to cultivate in your teams and what do you want the people to be like?
(00:49:42):
I have a degree in teaching English and applied linguistics, and I remember studying Paulo Freire and other educational problem-posing methods of education. We have these teams that solve these complex problems and challenges and build these really cool things for customers. Let's involve them in some of the org decisions that are going to be part of their daily life. Really, you like that idea. Again, it's not perfect. You can't involve people on everything, especially if they're wide-scale changes that you just can't.

**中文翻译:**
是的，你经理的话很有智慧。随着时间推移，情况会变，我们也在进化。我们会受到各种影响，比如 10 年前没有 COVID。我们成长、适应、演变。面对挑战时，我们尽力做出最佳决策，而这很大程度上是“问题交换”。今天有这个挑战，我们有几种方案，各有优缺点。这就像“丰田套路”（Toyota Kata）：把握现状，发现挑战，确定下一个目标状态，思考如何到达。到达后，再次把握现状。我们总是在从现状向未来状态转化。
(00:48:54):
所以，我会问大家：你希望这个过程是怎样的？你想成为什么样的领导者？是那种“行了，我得把这事办了，发封邮件宣布重组就完事了，再见”的人，还是愿意听取员工意见的人？这需要你权衡。领导者需要耐心。当领导很难，很有挑战性，但你想在团队中培养什么样的氛围？你想让员工成为什么样的人？
(00:49:42):
我有英语教学和应用语言学的学位，我记得研究过保罗·弗莱雷（Paulo Freire）和其他教育中的“问题提出法”。我们的团队能解决复杂问题，为客户做出酷炫的东西，那为什么不让他们参与到会影响他们日常生活的组织决策中呢？当然，这并不完美，你不能让所有人参与所有事，尤其是那些无法公开的大规模变革。

---

### [00:50:19] Lenny

**English:**
Along these lines of doing things badly sometimes, you have this whole section on anti-patterns of reteaming. I think there's about five of them. I don't know if you have these all top of mind, but if you do, I'd love to hear some anti-patterns.

**中文翻译:**
说到把事情搞砸，你书里有一整节讲“团队重组的反模式”。我记得大约有五个。如果你还记得的话，我很想听听有哪些反模式。

---

### [00:50:34] Heidi Helfand

**English:**
Yeah. Well, one of them is people always think that reteaming is, you have a pool of people and you're assigning them to a bunch of different projects like, "Okay, you'll work 10% on this one, 5% on this one, 20% on this one. We are going to allocate the resources from our component-based teams into these different projects." We did that in Waterfall like many years ago, but that doesn't really work. A lot of the times the percentages don't add up. It's very hard for people to multitask and be involved in multiple efforts at once. It's hard for the brain with all the context switching that needs to happen in that case. So I call that the percentage anti-pattern.
(00:51:15):
There's also, I probably wrote about it like, poof, they're gone or suddenly they're here. Reteaming or having people suddenly show up and you weren't expecting them or suddenly they're gone and there's no communication around it whatsoever, that's another anti-pattern.

**中文翻译:**
好的。其中一个是：人们总认为重组就是把一堆人分配到不同的项目里，比如“你花 10% 的精力做这个，5% 做那个，20% 做另一个”。这种资源分配模式在多年前的瀑布流开发中很常见，但现在行不通。很多时候百分比根本对不上，而且人很难同时处理多项任务，频繁的上下文切换（Context switching）会让大脑疲惫不堪。我称之为“百分比反模式”。
(00:51:15):
还有一个我写过的模式叫“凭空消失或突然出现”。重组时，如果有人突然出现而你毫无心理准备，或者有人突然消失且没有任何沟通，这也是一种反模式。

---

### [00:51:32] Lenny

**English:**
One of the ones I love is this idea of spreading high performers. This idea of we're going to spread the high performers across other teams.

**中文翻译:**
我最喜欢的一个是“分散高绩效者”，即把高绩效员工拆散分到各个团队里。

---

### [00:51:38] Heidi Helfand

**English:**
That's an AppFolio story. Jon Walker was telling me back in the day that... I mean, he did this experiment. He had this thought that many of... There's one team that was like, I guess they were delivering at this cadence that they loved and they were building this stuff and there's this energy and you can almost feel it. Like let's just spread the people from that team across the other ones and then we'll have that. And it didn't work. He didn't have that. It didn't happen. And that was a visceral learning for him that it doesn't essentially work. And people are like, what does it take to be a high performing team? What does it take to have that magical team experience where there's that chemistry and the people are together? And there's stories in the book. Damon Valenzona was telling me one about how it's like's a band and we're with off each other. We're creating this music together. So John felt like he essentially destroyed that when he split up that team. So that's the story that inspired that anti-pattern.

**中文翻译:**
那是 AppFolio 的一个故事。Jon Walker 以前告诉我，他做过这个实验。他当时想，有一个团队表现极佳，交付节奏完美，充满活力，你能感受到那种能量。于是他想：“把这个团队的人分散到其他团队，这样每个团队都能拥有这种能量。”结果失败了，那种能量并没有随之迁移。这对他来说是一个深刻的教训：这种方法行不通。人们常问：怎样才能成为高绩效团队？怎样才能拥有那种充满化学反应的奇妙团队体验？书里有相关故事。Damon Valenzona 曾告诉我，这就像一个乐队，大家彼此呼应，共同创作音乐。Jon 觉得他拆散那个团队时，本质上是毁掉了那种音乐。这就是这个反模式的灵感来源。

---

### [00:52:49] Lenny

**English:**
The reason people are worried about reteams and reorgs is this... A lot of times it's exact reason that you just shared, which is our team is amazing. I don't want it to change. I don't want to split. I don't want to add anyone. I don't want to remove anyone. I guess is there anything else along those lines to help people feel better about, no, this is actually going to be okay and/or it's inevitable. It's not going to last.

**中文翻译:**
人们担心重组的原因往往正是你刚才分享的：我们的团队太棒了，我不想改变，不想拆分，不想加人也不想减人。关于如何让大家释怀，告诉他们“这会没事的”或者“这是不可避免的，现状不会永远持续”，你还有什么建议吗？

---

### [00:53:13] Heidi Helfand

**English:**
I think sometimes you have that awesome team situation. It's an enjoyable experience. People are learning. You're looking forward to it every day. You're delivering the stuff that people love. You're telling people what's going on. You have that matched expectation where people aren't breathing down your neck because it's late or something. Sometimes you want to keep that team together. You don't want to destroy that dynamic. But the thing is, maybe that's a small startup that grows and you need to grow because you have a bigger vision and it needs to be more than these 10 people. And so there is sometimes this feeling of loss, like, "This is our company. This is my experience at this company of 10 people, but suddenly we're 20 people. It doesn't feel the same like it did anymore and it feels different."
(00:54:05):
And people, they always ask the question, "How do we maintain our culture? It feels different than it was before." The thing is, it is different, and our companies go through stages. The company of today is not the company it was a year ago. The people turn over and change, what we work on turns over and change. The whole world and industry and global events change and put different pressures on us, and we got to live in this global context. So nothing lasts. Sometimes I have a picture of myself holding an ice cream cone that's melting. Not to be a total downer, but appreciate it when you're on a team and you love it and it's amazing because these are our lives and we have to have gratitude and appreciate what we have because naturally things evolve and change. It's just inevitable. So we appreciate what we have.
(00:55:07):
A lot of us can look back on our careers and remember those times when we were, in my case, skipping through the halls because I was so happy. And I was like I couldn't even tell you. Well, why was I skipping through the halls at that moment? What was it? Well, it was the people and the conditions and what we were doing and the time, the era almost because yeah, it does change.
(00:55:30):
There's a book by Ichak Adizes called *Managing Corporate Lifecycles*. It's one that many of us read for years at AppFolio, maybe the previous company as well. The Adizes Institute influenced some of our leaders and they influenced us with this. And it talks about the different stages of companies from birth. There's go-go stage, maturity, death of companies. These are like lifecycles. The company grows and changes and morphs and changes. The people in the teams do that as well. I have an ecocycle in my book where I talk about that kind of aging and changing. Then there's a disruption and you have a new beginning. We're part of these stories that are in progress. This is not an unchanging, unmoving entity that we work in. So just be kind to each other, enjoy your experiences and learn as much as you can.

**中文翻译:**
有时你确实处于一个完美的团队中：体验愉悦，大家都在进步，每天都充满期待，交付的产品备受喜爱，沟通顺畅，没有催命鬼。你确实想保持这种现状，不想破坏这种动态。但问题是，如果这是一家正在成长的初创公司，为了实现更大的愿景，你必须扩张，不能永远只有这 10 个人。所以有时会有失落感，觉得“这是我们的公司，这是我在这家 10 人公司的体验，但突然变成了 20 人，感觉不一样了”。
(00:54:05):
人们总问：“我们如何保持文化？感觉和以前不一样了。”事实是，它确实不一样了。公司会经历不同阶段，今天的公司不再是一年前的公司。人员在流动，业务在变化，整个世界和行业都在变，给我们施加不同的压力。没有什么能永恒。我有时会看一张自己拿着正在融化的冰淇淋的照片。不是要泼冷水，但当你身处一个热爱的、了不起的团队时，请珍惜它，因为这是我们的生活。我们要心存感激，因为事物自然会演变和改变，这是不可避免的。
(00:55:07):
我们很多人回首职业生涯，都会记得那些在走廊里高兴得蹦蹦跳跳的时刻。我甚至无法具体描述为什么那一刻那么开心。是因为人、环境、工作内容，还是那个时代？是的，一切都在变。
(00:55:30):
伊查克·爱迪思（Ichak Adizes）写过一本书叫《企业生命周期》（*Managing Corporate Lifecycles*）。我们在 AppFolio 读了很多年。它讲述了公司从出生、创业期、成熟期到衰亡的不同阶段。公司在成长、演变，团队中的人也是如此。我在书里提到了“生态循环”（ecocycle），探讨这种老化和变化。然后会有颠覆，会有新的开始。我们都是正在进行的故事的一部分。我们工作的组织不是一个静止不动的实体。所以，请善待彼此，享受经历，尽可能多地学习。

---

### [00:56:30] Lenny

**English:**
It reminds me of advice Sheryl Sandberg shared when she came to the Airbnb offices. Someone asked her: "What advice do you have to deal with all this constant change?" Like the quote I shared at the top of the episode of every six months, there's a massive reorg. Our culture's changing. Teams keep changing. It's constant flux. What is your advice to deal with that? And her advice was: That is good. The fact that you're growing so fast and having to change is the best case scenario because the alternative is you are not growing and it's much harder and much more painful because the changes are much harder. People get let go. Your business may go away. So her advice is just, this is good. Change means things are... And growth leads to change, especially hypergrowth, and that you should appreciate this time versus be afraid of it and think that it's a negative.

**中文翻译:**
这让我想起谢丽尔·桑德伯格（Sheryl Sandberg）来 Airbnb 办公室时分享的建议。有人问她：“你对应对这种不断的变革有什么建议？”就像我开头说的，每六个月就有一次大重组，文化在变，团队在变，一切都在流动。她的建议是：这是好事。你们增长如此之快以至于必须改变，这是最好的情况。因为另一种情况是你们不增长了，那会更艰难、更痛苦，因为那样的变革意味着裁员，甚至业务倒闭。所以她的建议是，这很好，变化意味着……增长导致变化，尤其是高速增长。你应该珍惜这段时光，而不是害怕它或把它看作负面影响。

---

### [00:57:23] Heidi Helfand

**English:**
And it seems like she had such a wide vantage point and could see the forest through the trees of the fact that, well, this company's doing well and this is why we're growing and changing. And I remember one of my leaders, CTO Jon Walker, AppFolio, he told me that once too. He was like... I'd be having a problem or something and I'd come to him and he'd always say to me, "It's always great to be at a successful company, Heidi." And it's like, well, yeah, sometimes you don't think about the finances when you're in your day to day and you have a problem with another person or they come to you and they have a problem with this other person. But in the grand scheme of it, how is the company doing? It's really a critical vantage point that we need to remind ourselves of. But yeah, I wouldn't say all change is always good. Your mileage may vary there, but the general idea that the company is doing well, you're growing and changing, you're trying to make things happen, I think is definitely the space I'd rather be in than the opposite.

**中文翻译:**
看来她的视野非常开阔，能从大局出发看到公司表现良好正是增长和变革的原因。我记得 AppFolio 的 CTO Jon Walker 也跟我说过类似的话。当我遇到问题去找他时，他总会对我说：“Heidi，待在一家成功的公司总是件好事。”确实，当你陷入日常琐事，或者和某人闹矛盾时，你可能不会想到公司的财务状况。但在宏观层面上，公司经营得如何？这是一个我们需要不断提醒自己的关键视角。当然，我不是说所有变化都是好的，情况因人而异，但总体而言，公司表现良好、在增长、在变革、在努力成事，我肯定更愿意待在这样的环境里。

---

### [00:58:31] Lenny

**English:**
And I think it's especially true for people that haven't worked at a company that didn't work out where they think this sucks when really this is pretty good compared to all the things that could be happening.

**中文翻译:**
我觉得对于那些没经历过公司倒闭的人来说尤其如此，他们可能会觉得现状很糟糕，但实际上，与可能发生的其他糟糕情况相比，这已经非常好了。

---

### [00:58:42] Heidi Helfand

**English:**
Yeah, yeah, definitely. So we coach and help each other as we go along.

**中文翻译:**
没错，所以我们要一路上互相指导和帮助。

---

### [00:58:48] Lenny

**English:**
Final question before we get to a very exciting lightning round. Used to work with John Cutler, who was a previous guest on this podcast, and he had a question that he wanted me to ask you. He said that, "Heidi is one of the best listeners I've ever worked with." And so the question is, what's your secret to being a good listener?

**中文翻译:**
在进入激动人心的闪电轮环节之前，最后一个问题。我以前和 John Cutler 共事过（他也是本播客之前的嘉宾），他让我问你一个问题。他说：“Heidi 是我合作过的最好的倾听者之一。”所以问题是，你成为优秀倾听者的秘诀是什么？

---

### [00:59:07] Heidi Helfand

**English:**
Well, listening is a muscle to build and to always work on. You got to put your attention out. Focus on the other person. Sometimes if I'm looking down, maybe I reconnect and look at them. You got to read body language and other things. I'm trained as a co-active coach, which involves different levels of listening. So you have level one, which is internal listening. Like if you and I are talking, but I'm thinking about what am I going to have for lunch? I'm in level one. I've got to redirect it out to you and focus on you. So when I focus on you is I'm in level two listening. I'm putting my attention out and I'm really anchoring towards you. It's a coaching skill.
(00:59:47):
And then level three is global listening, environmental listening. If a marching band suddenly walked behind you, I'm going to point that out because it's in my field. I'm not going to ignore that. I'm going to bring that up. So we pay attention to the vibe and the feel in the room and where we're at. But then also if you're talking about something and suddenly you go like this or you have this kind of sudden pain in your neck when you're talking about this one thing, I might notice that you're doing this and touching your neck because that's information. That's a kind of listening, and so I might ask you about that. Or if the face turns red or you look down or away, it's another kind of listening. So Co-Active Training Institute, coactive.com is my co-active coaching training, so I learned it from them, Henry Kimsey-House and-

**中文翻译:**
倾听是一块需要不断锻炼的肌肉。你必须把注意力放在外面，专注于对方。有时如果我低头看了，我会重新调整并注视对方。你得观察肢体语言。我接受过“共创教练”（Co-active coach）的培训，这涉及不同层级的倾听：
- **第一级：内在倾听（Internal listening）**。比如你我在交谈，但我脑子里在想午饭吃什么。这时我需要把注意力重新引向你。
- **第二级：聚焦倾听（Focused listening）**。当我完全专注于你，把注意力全部投射在你身上时，这就是第二级。这是一种教练技能。
(00:59:47):
- **第三级：全局倾听（Global listening）**，也叫环境倾听。如果突然有一支行进乐队从你身后走过，我会指出来，因为它在我的感知范围内，我不会忽略它。我们会关注房间里的氛围、感觉以及我们所处的状态。
此外，如果你在谈论某件事时突然摸了摸脖子，或者表现出某种不适，我会注意到这个动作，因为这也是信息。这也是一种倾听，我可能会问你关于那个动作的事。或者如果你脸红了、低头了、看向别处了，这都是倾听的内容。我是在共创培训学院（coactive.com）跟 Henry Kimsey-House 他们学的。

---

### [01:00:48] Lenny

**English:**
Wow, that is an awesome answer. There's a lot of depth there. So coactive.com, I'm going to check that out. So you actually got trained in this skill. Okay, that's great. That'll make people feel better. They're like, okay, amazing. I'm going to check this out. I'm going to try to be a better listener through the rest of this podcast episode from these tips.

**中文翻译:**
哇，这个回答太棒了，很有深度。我会去看看 coactive.com。原来你专门受过这项技能的培训。这会让大家感觉好些，原来是可以练出来的。我会尝试在接下来的节目中运用这些技巧，做一个更好的倾听者。

---

### [01:01:08] Heidi Helfand

**English:**
I will say that sometimes I'm not a good listener though.

**中文翻译:**
不过我也得承认，有时我也不是个好的倾听者。

---

### [01:01:13] Lenny

**English:**
Yeah, so it goes. Heidi, is there anything else you wanted to touch on or share before we get to our very exciting lightning round?

**中文翻译:**
很正常。Heidi，在进入闪电轮之前，还有什么想补充或分享的吗？

---

### [01:01:22] Heidi Helfand

**English:**
I don't think so. I really appreciate your questions and talking with you.

**中文翻译:**
没有了。非常感谢你的提问和交流。

---

### [01:01:28] Lenny

**English:**
Well, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
好的，我们进入了激动人心的闪电轮环节。准备好了吗？

---

### [01:01:33] Heidi Helfand

**English:**
Yeah.

**中文翻译:**
准备好了。

---

### [01:01:34] Lenny

**English:**
All right. First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
好的。第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:01:39] Heidi Helfand

**English:**
*Leading Intelligent Teams* is one, *Liberating Structures* is another one, and of course, *Transitions* by William Bridges. I also like the *Leader's Guide to Participatory Decision-Making*.

**中文翻译:**
《领导智能团队》（*Leading Intelligent Teams*）、《解放结构》（*Liberating Structures*），当然还有 William Bridges 的《过渡期》（*Transitions*）。我还喜欢《参与式决策领导者指南》（*Leader's Guide to Participatory Decision-Making*）。

---

### [01:01:53] Lenny

**English:**
Is there a favorite recent movie or TV show that you really enjoyed?

**中文翻译:**
最近有什么非常喜欢的电影或电视剧吗？

---

### [01:01:57] Heidi Helfand

**English:**
I did like *The Bear*, the cooking-related show, the restaurant-related show, and gets into the hospitality industry. I really like that. Movies, there isn't really one that stands out. I always look forward to being on an airplane to see what movies are playing, but no movie for you.

**中文翻译:**
我很喜欢《大熊餐厅》（*The Bear*），那部关于烹饪和餐厅的剧，深入探讨了餐饮服务业。电影方面倒没有特别突出的。我总是期待在飞机上看有什么新片，但现在没啥推荐的。

---

### [01:02:21] Lenny

**English:**
What is a favorite interview question that you like to ask people that you are interviewing?

**中文翻译:**
你面试别人时最喜欢问的问题是什么？

---

### [01:02:27] Heidi Helfand

**English:**
I always like to ask people, "Well, why do you want to join our company? What is it about working with us that would be exciting for you? Why our company as opposed to another one?"

**中文翻译:**
我总喜欢问：“你为什么要加入我们公司？和我们一起工作最让你兴奋的是什么？为什么选择我们公司而不是其他公司？”

---

### [01:02:39] Lenny

**English:**
What do you look for in their answer that is a good sign?

**中文翻译:**
你会在他们的回答中寻找什么样的积极信号？

---

### [01:02:43] Heidi Helfand

**English:**
They have some knowledge about what we do, what we build. Maybe they bring up that they've noticed something on one of the websites or a product launch that we just announced, just that maybe it's part of their story in their career. They're going in this direction, and they heard about us and they thought, "Wow, I would love to work on that."

**中文翻译:**
看他们是否了解我们的业务和产品。也许他们提到了在网站上注意到的细节，或者我们刚发布的产品。这说明加入我们是他们职业生涯故事的一部分，他们正朝着这个方向努力，听到我们的消息后觉得“哇，我很想参与其中”。

---

### [01:03:08] Lenny

**English:**
Is there a favorite product you've recently discovered that you really love?

**中文翻译:**
最近有没有发现什么特别喜欢的产品？

---

### [01:03:11] Heidi Helfand

**English:**
I'm very into vintage clothing and specifically real wool cashmere, not synthetic blends. I also like vintage blazers. A lot of the times where I'm giving a talk, I'm wearing a vintage blazer. I really like the clothing and design, and I kind of really, really love unusual vintage pieces that I could find, but they do need to... A lot of the fast fashion that's out there today is a lot of these blends with these materials that you've never heard of, but there's something special about vintage cashmere, for example.

**中文翻译:**
我非常迷恋复古服装，特别是纯羊毛和羊绒，而不是合成混纺。我也喜欢复古西装外套。我演讲时经常穿复古西装。我非常喜欢那些设计，喜欢寻找独特的复古单品。现在的快时尚大多是些闻所未闻的混纺材料，而复古羊绒有一种特别的质感。

---

### [01:03:56] Lenny

**English:**
Do you have a source for some good stuff? Is it like eBay? Is it stores locally? Is there a site? Is there somewhere you're finding some good stuff?

**中文翻译:**
你有什么淘货渠道吗？是 eBay，还是当地商店？有什么网站推荐吗？

---

### [01:04:03] Heidi Helfand

**English:**
I travel around the world and I give talks on reteaming. I do workshops. And usually I go to vintage and antique stores. I was just in Berlin. I was doing that. I was doing it in London. And yeah, I love thrifting, Salvation Army, Goodwill, any of these places that we have in many of the US cities, the Humana line of stores that I've been to in Europe and other places. I try to find the small, unusual antique places as well. My aunt's an antique dealer in Michigan, and she doesn't specialize in vintage clothing, but I just love that idea of discovering unique and unusual things that maybe they remind you of times in the past. Maybe you find that, "Oh my gosh, we had that mug back in the '80s or whatever, or in the '90s." Things can kind of remind people of other times. So I like that. I think there's information stored in unique items.

**中文翻译:**
我经常去世界各地做关于团队重组的演讲和工作坊。我通常会逛逛当地的复古店和古董店。我刚去过柏林和伦敦淘货。我喜欢逛二手店，比如 Salvation Army、Goodwill，还有欧洲的 Humana 连锁店。我也会找一些独特的小古董店。我姨妈在密歇根做古董生意，虽然她不专攻服装，但我喜欢发现那些能让人想起过去时光的独特物件。比如你可能会发现：“天哪，我们 80 年代或 90 年代用过这种杯子！”这些东西能唤起回忆。我觉得独特的物品中蕴含着信息。

---

### [01:05:12] Lenny

**English:**
Beautiful. I bet Berlin has some really cool vintage stuff, really wacky stuff.

**中文翻译:**
太棒了。我敢打赌柏林肯定有很多酷炫又古怪的复古玩意。

---

### [01:05:16] Heidi Helfand

**English:**
Yeah, there's a lot of really interesting places to explore, and I think it's just so much more interesting than some of the brand new kind of stuff.

**中文翻译:**
是的，有很多有趣的地方可以探索，我觉得这比买全新的东西有意思得多。

---

### [01:05:30] Lenny

**English:**
Agreed. Two more questions. Do you have a favorite life motto that you often find yourself coming back to or sharing with friends or family, either in work or in life?

**中文翻译:**
同意。最后两个问题。你有没有什么人生格言，是你在工作或生活中经常想起或分享给亲友的？

---

### [01:05:41] Heidi Helfand

**English:**
I like asking people how can you be kind to yourself?

**中文翻译:**
我喜欢问别人：你如何才能善待自己？

---

### [01:05:47] Lenny

**English:**
Say more.

**中文翻译:**
展开说说。

---

### [01:05:48] Heidi Helfand

**English:**
I ask myself that too. I used to run a lot in Santa Barbara at Ellwood, which is a beautiful trail that you can go down to the ocean, you come back up. It's like More Mesa in Santa Barbara, and I would run and then I'd be like, "God, this is so hard." And then I would walk for a little while and I'd think to myself, "Well, how can I be kind to myself? I mean, what am I doing here? Does it have to be fast? No. I am here to decompress and enjoy, so how can I be kind to myself?" I think sometimes I get hard on myself or have very high expectations kind of achiever mentality, and I've learned through the years that it's okay to slow down. It's okay to not go, go, go the whole time. So I would ask other people that as well, especially if they're going through a challenge or burning midnight oil or whatever. It's like, "What about self-care? How can you be kind to yourself?"

**中文翻译:**
我也经常问自己。我以前常在圣巴巴拉的 Ellwood 跑步，那是一条通往大海的美丽小径。我会跑着跑着觉得“天哪，太累了”，然后我会走一会儿，心想：“我该如何善待自己？我在这里做什么？非得跑那么快吗？不，我是来放松和享受的，所以我该如何善待自己？”我觉得有时我会对自己太苛刻，或者有那种极高的“成就者心态”。这些年来我学会了：慢下来没关系，不需要一直冲冲冲。我也会这样问别人，尤其是当他们面临挑战或熬夜加班时：“自我关怀做得怎么样？你如何才能善待自己？”

---

### [01:06:56] Lenny

**English:**
Beautiful. Final question. I was scouring your LinkedIn and I saw a quote from the CTO of AppFolio in his endorsement of you. Said that you were the unofficial director of fun at AppFolio. Is there a story that comes to mind of something that you did at AppFolio that created a lot of joy and fun for the team?

**中文翻译:**
说得真好。最后一个问题。我翻看你的 LinkedIn 时，看到 AppFolio 的 CTO 对你的评价，说你是 AppFolio 的“非官方快乐总监”。你有没有想起什么在 AppFolio 做的、为团队带来很多快乐的故事？

---

### [01:07:15] Heidi Helfand

**English:**
We had these hack days, and I think they do that to this day. So twice a year we'd bring people together and we copied and learned from Atlassian. I remember we had calls with some coaches from Atlassian for how did they do their ShipIt Day, or they originally called it FedEx Day, changed it to ShipIt Day. We followed their model and we'd had this two o'clock on Thursday at two o'clock on Friday where we'd build whatever we wanted and we'd have a theme, and then we'd have goofy prizes at the end that were like traveling trophies. One of them was like a clickety-clack keyboard that we spray-painted gold by the railroad tracks, but people could work on anything. There were teams that formed... We did it with a self-selection marketplace. People formed their topics and teams, and one team hid geocaches throughout Santa Barbara. They're there to this day because we registered them with the Geocaching website. Another team built a vintage video game machine, and it was in the dev room. Another one they catapulted. They built this... Is it a trebuchet?
(01:07:16):
Yeah.
(01:08:27):
That catapult this fruit in the parking lot. I don't know how we got away with that, but we were in the early days. We did a lot of fun stuff like that, and you could work with different people, build these larger relationships, which later makes it easier for reteaming, because then later if you reteam, you're not strangers with people, so you want to cultivate the community. So we had this department of fun. We would plan the fun in a variety of other ways as well.

**中文翻译:**
我们有“黑客日”（Hack days），我想他们现在还在办。一年两次，大家聚在一起。我们向 Atlassian 学习，还专门请教了他们的教练如何举办“ShipIt Day”（最初叫 FedEx Day）。我们效仿他们的模式，从周四下午两点到周五下午两点，大家可以随心所欲地构建任何东西。我们会设定主题，最后颁发一些搞怪的奖项，比如流动的奖杯。其中一个奖杯是我们用金漆喷涂的机械键盘。大家可以做任何事：有人在圣巴巴拉各处藏了地理宝藏（Geocaches），现在还在那儿；有人做了一台复古游戏机放在开发室；还有人造了一台投石机（Trebuchet），在停车场投掷水果。我不知道当时是怎么被允许的，但早期我们确实做了很多这种好玩的事。这让你能和不同的人合作，建立更广泛的关系，这让以后的“团队重组”变得更容易，因为大家不再是陌生人。所以我们要培养社区感。我们当时有个“快乐部门”，会策划各种有趣的活动。

---

### [01:08:56] Lenny

**English:**
So fun. Heidi, you're awesome. I think we've helped a lot of people feel better about the endless change that they're probably going through right now. Two final questions. Where can folks find your book, find you online if they want to reach out, and how can listeners be useful to you?

**中文翻译:**
太有趣了。Heidi，你太棒了。我想我们帮助很多人缓解了对当前不断变革的焦虑。最后两个问题：大家在哪里可以买到你的书或在网上找到你？听众可以为你做些什么？

---

### [01:09:10] Heidi Helfand

**English:**
You can go to heidihelfand.com or Google my name and I come up. Heidi@dynamicreteaming.com, heidi.helfand@gmail.com you can find me. I'm out there. And yeah, I love to work with companies and teams going through change, and I do that in a variety of ways. Teach workshops, do talks. So if any of this is interesting, reach out.

**中文翻译:**
你可以访问 heidihelfand.com 或者直接搜我的名字。也可以通过邮件 Heidi@dynamicreteaming.com 或 heidi.helfand@gmail.com 联系我。我非常喜欢与正在经历变革的公司和团队合作，形式包括举办工作坊、演讲等。如果感兴趣，欢迎联系。

---

### [01:09:33] Lenny

**English:**
And then do you also consult and work with individual companies or not?

**中文翻译:**
那么你也会为个别公司提供咨询和合作吗？

---

### [01:09:37] Heidi Helfand

**English:**
I do. Yeah. I do that now. I like to work on a retainer basis or I'll even join a team, so looking for the next one.

**中文翻译:**
是的，我现在就在做。我喜欢以顾问（Retainer）的形式工作，甚至会加入某个团队，所以我也在寻找下一个机会。

---

### [01:09:47] Lenny

**English:**
Amazing. And we'll link to all this stuff in the show notes. Heidi, thank you again so much for being here.

**中文翻译:**
太好了。我们会把这些链接放在节目介绍里。Heidi，再次感谢你的到来。

---

### [01:09:53] Heidi Helfand

**English:**
Thanks so much, Lenny.

**中文翻译:**
非常感谢，Lenny。

---

### [01:09:54] Lenny

**English:**
Bye everyone.
(01:09:57):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。
(01:09:57):
感谢收听。如果你觉得本期节目有价值，欢迎在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。同时，请考虑给我们评分或留下评论，这能帮助更多听众发现我们。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目见。