# Hila Qu - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Hila Qu.

---

### [00:00:01] Hila Qu

**English:**
... [inaudible 00:00:01]. Always say is actually fundamentally DLG, data led growth. So when you give away your free product, what you want to get in exchange are two things. One is a broader reach because free product spread itself is lower barrier to entry. Two, you want to understand you usage behavior of those free users, which features do they use and which features kind of correlates with a higher conversion rate, retention rate, all of that. If you don't have a foundation of data and understanding of how to analyze those data, you are giving a way of free product for nothing.

**中文翻译:**
……（前段音频模糊）。我经常说，PLG（产品驱动增长）本质上其实是 DLG，即数据驱动增长（Data Led Growth）。所以当你提供免费产品时，你希望换取的东西有两点：一是更广的覆盖范围，因为免费产品的传播门槛更低；二是你想了解这些免费用户的使用行为——他们使用了哪些功能，哪些功能与更高的转化率、留存率等指标相关。如果你没有数据基础，也不懂得如何分析这些数据，那你就是在白白送出免费产品，毫无收获。

---

### [00:00:44] Lenny

**English:**
Welcome to Lenny's podcast where I interview world-class product leaders and growth experts to learn from their hard one experiences building and growing today's most successful products. Today my guest is Hila Qu. I've heard some listeners have been doing listening parties with this podcast where their team listens to an episode all at the same time over Zoom and shares their insights and lessons in a shared chat. And I would say that this episode is a great candidate for that. It's incredibly packed with advice on how to start and optimize your product led growth motion. We talk through common pitfalls that you probably run into or to get started, feel us favorite tools, what you recommends for an initial PLG oriented team, how to audit your existing funnel, plus tangents on how to improve your activation and retention and some foundational overviews of product like growth and some of the core concepts associated with it.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Hila Qu。我听说有些听众在搞“播客听友会”，团队成员通过 Zoom 同时收听一期节目，并在聊天框里分享见解和心得。我想说，这一集非常适合这种形式。它充满了关于如何启动和优化产品驱动增长（PLG）模式的建议。我们会讨论你可能遇到的常见陷阱、如何起步、Hila 最喜欢的工具、她对初始 PLG 团队的建议、如何审计现有漏斗，还会延伸到如何提高激活率和留存率，以及 PLG 的一些基础概览和核心概念。

---

### [00:01:34] Lenny

**English:**
Like I say at the end of the episode, this episode delivers tens of thousands of dollars in value. Something you won't find for free anywhere else. I am really excited to bring it to you. With that, I bring you Hila Qu after a short word from our sponsors.

**中文翻译:**
正如我在本集结尾所说的，这期节目提供了价值数万美元的干货，你在其他任何地方都找不到这么高质量的免费内容。我非常激动能把它呈现给大家。在听完赞助商的简短介绍后，让我们欢迎 Hila Qu。

---

### [00:01:49] Lenny (Sponsorship)

**English:**
This episode is brought to you by Amplitude. If you're setting up your analytics stack but not using Amplitude, what are you doing? Anyone can sell you analytics while Amplitude unlocks the power of your product and guide you every step of the way. Get the right data, ask the right questions, get the right answers, and make growth happen. To get started with Amplitude for free, visit amplitude.com. Amplitude, power to your products.

**中文翻译:**
本集由 Amplitude 赞助。如果你正在搭建分析栈却没用 Amplitude，你在想什么呢？谁都能卖给你分析工具，但 Amplitude 能释放你产品的力量，并指引你每一步。获取正确的数据，提出正确的问题，得到正确的答案，让增长发生。免费开始使用 Amplitude，请访问 amplitude.com。Amplitude，为你的产品赋能。

---

### [00:02:16] Lenny (Sponsorship)

**English:**
Today's episode is brought to you by Miro and online collaborative whiteboard that's designed specifically for teens like yours. I have a quick request, head on over to my Miro board at miro.com/Lenny and let me know which guests you'd want me to have on this year. I've already gotten a bunch of great suggestions, which you'll see when you go there, so just keep it coming. And while you're on the Miro board, I encourage you to play around with the tool. It's a great shared space to capture ideas, get feedback, and collaborate with your colleagues on anything that you're working on.

**中文翻译:**
今天的节目由 Miro 赞助，这是一款专门为你们这样的团队设计的在线协作白板。我有个小请求，请访问我的 Miro 看板 miro.com/Lenny，告诉我你今年想在节目里看到哪些嘉宾。我已经收到了很多很棒的建议，你去了就能看到，所以请继续提建议。当你使用 Miro 看板时，我鼓励你试用一下这个工具。它是一个极佳的共享空间，可以捕捉创意、获取反馈，并与同事协作处理任何工作。

---

### [00:02:48] Lenny (Sponsorship)

**English:**
For example, with Miro, you can plan out next quarter's entire product strategy. You can start by brainstorming, using sticky notes, live reactions, a voting tool, even an estimation app to scope out your team's sprints. Then your whole distributed team can come together around wire frames, dry ideas with a pen tool, and then put full mocks right into the Miro board and with one of Miro's ready-made templates, you can go from discovery and research to product roadmaps to customer journey flows to final mocks, all the aim Miro. Head on over to miro.com/Lenny to leave your suggestions. That's M-I-R-O.com/Lenny.

**中文翻译:**
例如，利用 Miro，你可以规划下个季度的整个产品策略。你可以从头脑风暴开始，使用便签、实时反应、投票工具，甚至是用估算应用来确定团队冲刺的范围。然后，你整个分布式团队可以围绕原型图聚在一起，用画笔工具勾勒创意，再把完整的视觉稿直接放入 Miro 看板。借助 Miro 的现成模板，你可以完成从发现研究、产品路线图、客户旅程图到最终视觉稿的所有工作。请访问 miro.com/Lenny 留下你的建议。

---

### [00:03:26] Lenny

**English:**
Hila, welcome to the podcast.

**中文翻译:**
Hila，欢迎来到播客。

---

### [00:03:29] Hila Qu

**English:**
Thank you Lenny for having me. I'm so excited.

**中文翻译:**
谢谢 Lenny 邀请我，我非常激动。

---

### [00:03:32] Lenny

**English:**
I'm excited as well. I don't know if you know this, but you have the very unique distinction of having two posts in my top 25 most read post of all time in my newsletter, which are the two parts of your series on how to add a product led growth motion. And so I'm really excited to dig into product led growth and help more people be successful product led growth.

**中文翻译:**
我也很激动。不知道你是否知道，你有一项非常独特的荣誉：在我通讯（Newsletter）历史阅读量前 25 名的文章中，你占了两篇，也就是你关于“如何增加产品驱动增长模式”系列文章的两部分。所以我非常期待深入探讨 PLG，帮助更多人在 PLG 领域取得成功。

---

### [00:03:52] Hila Qu

**English:**
Awesome. I should have made it three posts, three part.

**中文翻译:**
太棒了。我当时应该写成三篇，分三个部分。

---

### [00:03:57] Lenny

**English:**
I like that ambition. There's always more. Yeah. Well I think the next milestone is get into the top 10, get two into the top 10.

**中文翻译:**
我喜欢这种雄心。总有更多内容可以写。我想下一个里程碑是冲进前十，让两篇都进前十。

---

### [00:04:06] Hila Qu

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:04:06] Lenny

**English:**
Okay. Maybe this podcast will... Oh, okay. This podcast will be in the feed of the newsletter, so maybe we'll get there. No pressure. No pressure. One question I wanted to ask you is anything come out of writing those guest posts? Has anything good happened as a result?

**中文翻译:**
好，也许这期播客会……哦，这期播客会发在通讯里，所以也许我们能实现目标。没压力，没压力。我想问你一个问题：写完那些客座文章后有什么收获吗？有没有发生什么好事？

---

### [00:04:21] Hila Qu

**English:**
I always take a very long-term view for writing. I enjoy writing myself. Spend actually four months on that one. After it's published, I see a lot of shares kind of and people writing very long summary of it. That's always very encouraging and also many people I didn't expect reading it reach out to me, let me know, "Hey, I read that." For example. I think Ravi, he is also on your podcast. I didn't know him personally, one day he's like, "Hila, I read that. That's awesome." And a bunch of friends in VC and they kind of read that. They told me it's great. I even have a advisory client kind of landed because of that as well. So it's awesome.

**中文翻译:**
我对待写作一直持有长期主义的观点。我自己很享受写作。那篇文章我实际上花了四个月。发布后，我看到很多人转发，还有人写了很长的总结。这总是非常令人鼓舞的。而且很多我没预料到会读它的人也联系了我，告诉我：“嘿，我读了那篇。”比如 Ravi，他也上过你的播客，我以前不认识他，有一天他跟我说：“Hila，我读了那篇，太棒了。”还有一群风投圈的朋友也读了，说写得很好。我甚至因为那篇文章接到了一个咨询客户。所以感觉很棒。

---

### [00:05:10] Lenny

**English:**
Amazing. It makes me really happy to hear all that. I was also curious, has anything, and we're going to get into the details of all the stuff you wrote about and even beyond what you wrote about, but is there anything you're thinking has shifted on having after having written that series in terms of PLG?

**中文翻译:**
太好了，听到这些我很高兴。我也很好奇，虽然我们待会会深入探讨你写的那些细节，甚至超出文章的内容，但在写完那个系列后，你对 PLG 的看法有没有发生什么转变？

---

### [00:05:25] Hila Qu

**English:**
I wouldn't say it's shifted completely because I always believe you don't need to be a PLG purist. Meaning there are kind of people who are like, "PLG is the future. It's only thing, you don't need sales." Right? I was never like that, but recently by working with a few of my clients, I witnessed in reality many startups actually are having both. They have a PLG motion, they have a sales team as well. PLG motion is perfect for lowering the barrier for more people to try, broader the reach. It's a kind of volume kind of game. And then the sales motion, you can have very targeted list of big customers you go after, you close them and it's a big order. Usually revenue, a very strong foundation for a company. And I've seen actually a lot of my clients that are doing, they have both. They're doing that. They try to get the benefit of both from their early stage and it's super cool.

**中文翻译:**
我不会说完全转变了，因为我一直认为不需要做一个“PLG 纯粹主义者”。也就是说，有些人觉得“PLG 才是未来，它是唯一的出路，你不需要销售”。我从来不是那种想法。但最近通过与几位客户合作，我亲眼看到现实中许多初创公司实际上两者兼备。他们既有 PLG 模式，也有销售团队。PLG 模式非常适合降低门槛让更多人尝试，扩大覆盖面，这是一种“走量”的游戏。而销售模式则可以让你针对大客户名单进行攻坚，签下大订单。这通常是公司收入的坚实基础。我看到很多客户从早期就开始尝试兼得两者的好处，这非常酷。

---

### [00:06:40] Lenny

**English:**
Is the simple way to think about this trend that eventually every one will need to do both. It's not one or the other, it's just both. And it's just a matter of when you add the other.

**中文翻译:**
简单理解这种趋势，是不是最终每个人都需要两者兼顾？不是二选一，而是两者都要，只是什么时候引入另一种模式的问题。

---

### [00:06:40] Hila Qu

**English:**
I would think so because let's say if you are in the sales motion dominated kind of traditional B2B software industry, your competitors will be adding PLG, as soon as they add it they will have a benefit of attracting more end users and end users become case to the employer, to the clients. And you lose that. And if you are only in PLG somewhere else may go after the big customers. It takes time for PLG to go to the big customer and close them. So you lose a little bit of time there as well. I think eventually you need both.

**中文翻译:**
我是这么认为的。因为假设你处于销售模式主导的传统 B2B 软件行业，你的竞争对手会增加 PLG 模式。一旦他们增加了，他们就能吸引更多的终端用户，而这些终端用户会反过来向雇主或客户推荐。如果你不跟进，你就会失去这个优势。反之，如果你只有 PLG，别人可能会直接抢走大客户。PLG 渗透到大客户并成交是需要时间的，所以你也会损失时间。我认为最终你需要两者结合。

---

### [00:07:19] Lenny

**English:**
Cool. That's kind of the way I've been seeing it. I did a few series on traditional product led growth companies, [inaudible 00:07:28]. All those guys, and they all add sales teams eventually last famous for being product led only. And so everyone ends up adding sales team. I think more recent trend is sales led enterprise E products are all just realizing they need a product led growth component. So that's kind of what I've been seeing too.

**中文翻译:**
酷。这也是我观察到的。我做过几个关于传统 PLG 公司的系列报道，比如 [模糊]。所有这些公司最终都增加了销售团队，哪怕是那些以“纯产品驱动”闻名的公司。所以大家最后都会加销售。我认为最近的趋势是，那些销售驱动的企业级产品也意识到他们需要 PLG 组件。这也是我所看到的。

---

### [00:07:43] Hila Qu

**English:**
Yeah, exactly. But I would say it is easier if you have PLG from early on. If you are pure sales led, you try to add PLG, that's the harder thing to change basically.

**中文翻译:**
没错。但我想说，如果从早期就有 PLG 会更容易。如果你是纯销售驱动，再想增加 PLG，那才是最难改变的。

---

### [00:08:15] Lenny

**English:**
Interesting to set a little foundation. Before we get into a lot of this stuff, it'd actually be helpful just to explain what is product like growth, just simply, because people hear this term a lot and it'd be helpful just to understand it broadly. And then also just like why is it so popular? Why does everyone want a product growth component to their business?

**中文翻译:**
很有意思。在深入探讨之前，先打个基础。简单解释一下什么是产品驱动增长（PLG）会很有帮助，因为人们经常听到这个词，广义地理解它很有必要。另外，为什么它这么流行？为什么每个人都想在业务中加入产品增长组件？

---

### [00:08:15] Hila Qu

**English:**
Just use a simple example in B2C product. When you think about Facebook, when you think about a lot of the products you use every day as an end consumer, it's always by default product led growth because there's no sales team [inaudible 00:08:32]. The LTV of the product doesn't support that. I think PLG the term become popular because traditionally in B2B, word sales is the main motion. You need a sales team to close the deal After the contract is signed, the end users can now finally use it.

**中文翻译:**
拿 B2C 产品举个简单的例子。当你想到 Facebook，或者你作为普通消费者每天使用的很多产品时，它们默认就是产品驱动增长的，因为没有销售团队去推销。产品的 LTV（生命周期价值）支撑不起销售成本。我认为 PLG 这个词之所以流行，是因为传统上在 B2B 领域，销售是主要模式。你需要销售团队去谈成交易，合同签了，终端用户才能开始使用。

---

### [00:08:51] Hila Qu

**English:**
But nowadays, it's not necessarily a case. You can have your B2B SaaS product developed in a way to allow end users to try before you buy. So that's the reason I think this has become being more popular. And the fundamental driver behind this is the user of B2B softwares are also human. It's the same human using B2C softwares and we're already trained to use product, try, and before we make any decision. And we demand that in B2B as well. So it needs to happen. And more and more companies are capturing that trend basically, and they're trying to utilizing that as a entry point to either disrupt existing B2B players or build something really awesome for end users. So that's why it's becoming more and more popular.

**中文翻译:**
但现在情况不一定如此了。你可以开发 B2B SaaS 产品，让终端用户在购买前先试用。这就是我认为它变得流行的原因。其背后的根本驱动力是：B2B 软件的用户也是人。使用 B2C 软件和 B2B 软件的是同一群人，我们已经被训练成在做决定前先试用产品。我们在 B2B 领域也有同样的需求。所以这必然会发生。越来越多的公司正在捕捉这一趋势，并试图利用它作为切入点，要么颠覆现有的 B2B 玩家，要么为终端用户打造真正棒的产品。这就是它越来越受欢迎的原因。

---

### [00:09:42] Lenny

**English:**
To pull on that thread a little bit more even to help people visualize a product led growth product, what makes it product led? There's a self-serve component, what are attributes or just kind of common elements of something that's product led versus sales led? Let's say.

**中文翻译:**
再深入探讨一下，为了让大家对 PLG 产品有直观的认识，是什么让它成为“产品驱动”的？除了自助服务组件，PLG 与销售驱动（Sales-led）相比，有哪些属性或常见元素？

---

### [00:09:59] Hila Qu

**English:**
Yeah, definitely. I think maybe we can use a product as a example, right? Think about Zoom how me or you, maybe everyday users, how we get to know Zoom is not necessary through a sales team call me code or email me code and introducing me this, showing a demo of Zoom, and I get to know Zoom, right? It's because maybe Lenny, you hosted a webinar I joined and I get to just use this software already without even knowing it's Zoom. And then afterwards I may one day think about I want to do this myself and I just do that in a sign-up and I already create a host a webinar and I can pay if I need a paid plan or I can use a lot of more advanced features when I, let's say hit the 40 minutes limit, I can already click that and pay and become a paid customer already.

**中文翻译:**
当然。我们可以拿一个产品举例。想想 Zoom，像你我这样的日常用户是如何认识 Zoom 的？不一定是销售团队给我打冷电话或发邮件介绍，给我演示 Demo。可能是因为 Lenny 你主持了一个网络研讨会，我参加了，我甚至在不知道它是 Zoom 的情况下就已经在使用这个软件了。之后某天我想自己办研讨会，我就注册了，创建并主持了会议。如果我需要付费方案，或者当我达到 40 分钟限制时，我可以点击支付，直接成为付费客户。

---

### [00:10:53] Hila Qu

**English:**
So I think the key properties also of PLG products, think about it should have a very low barrier to entry. Usually it has a free version, free trial. You don't need get approval from your boss to use it. You can use it today and then it has some sort of a self-service checkout flow. If you need a better version, you can buy yourself as well. And this product, basically the free product will spread on its own in some way or another.

**中文翻译:**
所以我觉得 PLG 产品的关键属性是：进入门槛非常低。通常它有免费版或免费试用。你不需要老板批准就能用，今天就能上手。然后它有某种自助结账流程。如果你需要更好的版本，你可以自己购买。而且这个产品，基本上这个免费产品会以某种方式自行传播。

---

### [00:11:24] Lenny

**English:**
Okay, perfect. I think that was really helpful. I think we dive into some of the meat of the discussion that we have planned and where I thought it'd be fun to start is the common pitfalls that people fall into when they're trying to add a product led growth motion. And so what are the most common ways people fail when they're trying to figure out product led growth?

**中文翻译:**
太好了，这非常有帮助。接下来我们进入正题。我想从人们在尝试增加 PLG 模式时常掉进去的陷阱开始。人们在探索 PLG 时最常见的失败方式有哪些？

---

### [00:11:45] Hila Qu

**English:**
The first of all, as I mentioned, you need to have some sort of vehicle. A lot of the companies, if you go to their website, especially B2B companies, you'll see the biggest CTA is called book demo. They don't have anything else. The first step for you to do is submit a form and kind of basically explain yourself to this company, I'm from who and who company and I want to use the tool, can you come back to me and allow me to see a demo of your product? That means the entry point to PLG is cut off. Instead, the first step is you need to either have a free product, free trial, some sort of a low barrier entry for anyone who stumble upon this product to give it a try. A lot of companies don't have that. That's the first I would say hurdle or peaceful.

**中文翻译:**
首先，正如我提到的，你需要某种“载体”。很多公司，尤其是 B2B 公司，如果你去他们的网站，你会发现最大的行动号召（CTA）是“预约演示”（Book Demo）。他们没有别的选项。你第一步必须提交表单，向公司解释你是谁，来自哪家公司，想用这个工具，请联系我并让我看演示。这意味着 PLG 的入口被切断了。相反，第一步应该是提供免费产品、免费试用，或者某种低门槛的入口，让任何偶然发现这个产品的人都能试一试。很多公司没有这个，这是第一个障碍或陷阱。

---

### [00:12:38] Hila Qu

**English:**
And especially if you are a sales lead and you already have all those things figured out, you try to go to add PLG, it's not as easy as just say, add a kind of free trial CTA on your website. You need to build this free experience. You also need to convince your sales team, your existing product team, your marketing team, "Hey, let's try this out." Because before this process is super clean. Everyone only get only selected future leads and sales work on those. But now you need to allow more people in and there need to be more understanding of their behavior data, the process need to change. So it's actually a whole process. So I would say that's first one. And along with that is some companies didn't think it thoroughly and they are just kind of saying, "Oh, PLG is cool, let's do PLG."

**中文翻译:**
特别是如果你是销售驱动型公司，已经有一套成熟的流程，想增加 PLG，这可不像在网站上加个“免费试用”按钮那么简单。你需要构建这种免费体验。你还需要说服你的销售团队、现有的产品团队和营销团队：“嘿，让我们试试这个。”因为以前的流程非常清晰：每个人只获取筛选后的潜在客户，销售只跟进这些。但现在你需要允许更多人进来，需要更多地了解他们的行为数据，流程需要改变。所以这实际上是一个完整的系统工程。这是第一个。随之而来的是，有些公司没有考虑周全，只是觉得“哦，PLG 很酷，我们也做 PLG 吧”。

---

### [00:13:34] Hila Qu

**English:**
And then they maybe spend three months build kind of some sort of a very basic free trial and then they think that's it. They think the leads will come, conversion will come, self-service revenue will come. It's not that easy. It's not that simple. It is definitely a entire motion. So I would say you need to commit to it. Maybe you can do some thinking, collecting some data, build your conviction, but to a certain point you need to commit to at least a year or even two years kind of roadmap to build this entire thing out and change the process internally sometimes as well to support that. The last one, I would say a lot of times the company's committed, they want to do this, but they don't know the right way or they don't have the foundation, they don't have the expertise of PLG.

**中文翻译:**
然后他们可能花三个月做一个非常基础的免费试用，就觉得完事了。他们以为线索会来，转化会来，自助服务收入也会来。没那么容易，没那么简单。这绝对是一个完整的模式。所以我想说，你需要投入其中。也许你可以先思考、收集数据、建立信心，但在某个时间点，你需要承诺至少一年甚至两年的路线图来构建整个体系，有时还要改变内部流程来支持它。最后一个陷阱是，很多时候公司确实投入了，想做这件事，但他们不知道正确的方法，或者没有基础，缺乏 PLG 的专业知识。

---

### [00:14:27] Hila Qu

**English:**
Their internal team, they're really good at sales or maybe really good at as the traditional motion, but they don't have this part of expertise and foundation. A common thing I see is that company want to do PLG and they have no usage data at all and they're like, "I will just doing PLG. But PLG I always say is actually fundamentally DLG, data led growth. So when you give away your free product, what you want to get in exchange are two things. One is the broader reach because free product spread itself is lower barrier to entry. Two, you want to understand the usage behavior of those free users, which features do they use and which features kind of correlates with a higher conversion rate, retention rate, all of that.

**中文翻译:**
他们的内部团队可能非常擅长销售或传统模式，但缺乏这方面的专业知识和基础。我常见的一种情况是，公司想做 PLG，却完全没有使用数据，他们说：“我就要做 PLG。”但我常说，PLG 本质上其实是 DLG，即数据驱动增长。当你提供免费产品时，你换取的是两样东西：一是更广的覆盖面，因为免费产品传播门槛低；二是了解免费用户的使用行为——他们用哪些功能，哪些功能与高转化率、高留存率相关。

---

### [00:15:20] Hila Qu

**English:**
If you don't have a foundation of data and understanding of how to analyze those data, you are giving a way of free product for nothing. Like you are really not being able to utilize all of that to build your PLG motion. So I think data foundation and expertise in terms of how do I design that user journey, that journey is very different from the sales user journey. Those are sometimes missing in company when they just begin to doing this. And in those cases I think it's super helpful to maybe either find someone who have done this as an advisor or hire someone like you need to have that expertise or through advisor to support your PLG motion.

**中文翻译:**
如果你没有数据基础，也不懂如何分析，你就是在白送产品。你无法利用这些数据来构建 PLG 模式。所以我认为数据基础和关于如何设计用户旅程的专业知识非常重要，这种旅程与销售驱动的用户旅程非常不同。公司刚开始做这件事时往往缺乏这些。在这种情况下，找一个有经验的顾问或者雇佣专业人才会非常有帮助，你需要这种专业知识来支持你的 PLG 模式。

---

### [00:16:06] Lenny

**English:**
This is great. We're going to talk about the data piece more in depth later, but on the commitment piece, I thought that was really interesting. I imagine many times founders or leaders think they have commitment and then they realize maybe not so much. Are there any kind of flags that tell you that, "Oh, you're not actually committed to working on this for a year or two years, whatever it takes."

**中文翻译:**
太棒了。我们稍后会深入讨论数据部分，但关于“投入”这一点，我觉得很有意思。我猜很多时候创始人或领导者以为自己投入了，后来才发现并不是那么回事。有没有什么信号（Flags）能告诉你：“哦，你其实并没有打算花一两年时间去死磕这件事”？

---

### [00:16:27] Hila Qu

**English:**
The red flags I've seen basically sometimes, first of all, they think about PLG equals launch of free version or launch of free trial. They made this assumption in their head, "Oh, I already have a product. I already have a software that's working, customers are using. Now if I add a free version, if I open a free trial, that's it." Like that's basically PLG, and I will have conversions. I will have people becoming a product qualified leads just because I have it. "Hey, I open this for you, just come and use it and [inaudible 00:17:07]." And I think that's one red flag. Basically they are not thinking about the entire thing through understanding the implication, not only the free product, it's really just a start. You need to think about how to activate, how to design the upgrade path, how those teams, those new growth teams work with other sales and marketing teams, all of that.

**中文翻译:**
我见过的一些红旗信号（Red Flags）包括：首先，他们认为 PLG 就等于发布免费版或免费试用。他们在脑子里假设：“哦，我已经有产品了，软件运行良好，客户也在用。现在我只要加个免费版或开放试用，就大功告成了。”他们觉得这就是 PLG，然后就会有转化，人们就会自动变成产品合格线索（PQL）。“嘿，我为你开放了，快来用吧。”我觉得这就是一个红旗信号。他们没有通盘考虑，不明白免费产品只是开始。你需要思考如何激活、如何设计升级路径、新的增长团队如何与销售和营销团队协作等等。

---

### [00:17:29] Hila Qu

**English:**
So that's one. The other one is they don't have a dedicated team. They just basically assign one person to the thing. They are imagine, "Hey, you already have this. It's not that big of deal. You can just figure this out by borrowing resources from everywhere and try to coordinate all the stakeholders from sales, marketing, product." That person need to be a magician in order to be successful in that basically. And I think the third thing is basically they are really doing this because it's trendy. They didn't think about the deeper strategic reason why this is a good fit for their business. Do you have a product that's relatively low complexity, doesn't require a lot of customization for the customer to see value.

**中文翻译:**
这是其一。另一个是他们没有专门的团队。他们基本上只是指派一个人负责。他们心想：“嘿，你已经有这些了，没什么大不了的。你可以从各处借调资源，协调销售、营销、产品的所有利益相关者。”那个人得是个魔术师才能成功。第三点是，他们做这个纯粹是因为流行。他们没有思考为什么这适合他们业务的深层战略原因。你的产品是否复杂度相对较低，不需要大量定制就能让客户看到价值？

---

### [00:18:19] Hila Qu

**English:**
Time to value need to be relatively short or you can figure out a way to make it short. And then do you have a lot of potentially end user S&B business? They are interested in the solution. They want to try that out. If you do not have both, if you for example, develop a software for the [inaudible 00:18:42]. Companies like [inaudible 00:18:44]. Or defense companies, only three target customer exist in the entire world, you don't probably want to do PLG, right? So think deeper about the fit and then commit. And I would say those are the red flags.

**中文翻译:**
价值实现时间（Time to Value）是否相对较短，或者你能否找到缩短它的方法？你是否有大量的潜在终端用户或中小企业（SMB）客户？他们对解决方案感兴趣并想尝试。如果你不具备这些，比如你开发的是针对 [模糊] 的软件，或者是像 [模糊] 那样的公司，或者是国防承包商，全世界只有三个目标客户，那你可能并不想做 PLG，对吧？所以要深入思考契合度，然后再投入。我认为这些就是红旗信号。

---

### [00:18:59] Lenny

**English:**
Okay. So on that last point, I thought that was a really interesting, we talked about how every company probably should add a product led growth piece, but I think what you're also saying is actually not every company, there are some companies like defense contractors that are probably going to be sale led.

**中文翻译:**
好。关于最后一点，我觉得很有意思。我们讨论过可能每家公司都应该增加 PLG 部分，但你刚才也说了，其实并非每家公司都适合，比如国防承包商之类的公司可能还是得走销售驱动路线。

---

### [00:19:15] Hila Qu

**English:**
I think it a spectrum. I would say the defense company, defense software company is a pretty extreme example. And of course in those case, I don't think it makes sense, but I think majority of B2B software, I've seen, you've seen, we've used even some more complicated ones. Like Salesforce used to be this example of sales motion. They're the pioneer of SaaS and they do this so well, but they begin to add look into sales service portal and all of that. And even a lot of the bigger players are looking into that. So I think majority of the B2B software, probably they are in the middle of the spectrum rather than the defense company.

**中文翻译:**
我认为这是一个光谱。国防软件公司是一个非常极端的例子，在这种情况下，我认为 PLG 确实没意义。但我认为大多数 B2B 软件——我见过的、你见过的、我们用过的，甚至是一些复杂的软件——都适合。比如 Salesforce 曾是销售模式的典范，他们是 SaaS 的先驱且做得很好，但他们也开始研究自助服务门户之类的东西。甚至很多大玩家都在关注这个。所以我认为大多数 B2B 软件可能处于光谱的中间，而不是像国防公司那样极端。

---

### [00:20:18] Lenny

**English:**
You kind of shared some of the attributes of what allows you to be product led, like quick time to value. If you have this in your head, what are some of those bullet points of what you need to figure out for it to be successful potentially as product led?

**中文翻译:**
你分享了一些让你能够实现产品驱动的属性，比如快速的价值实现时间。如果你脑子里有这些想法，那么要让 PLG 取得成功，需要解决的关键点有哪些？

---

### [00:20:18] Hila Qu

**English:**
The first thing is that have a... And you mentioned you are able to have a vehicle, have a free version, have a free trial. Sometimes it's a open source product. A lot of developer products start as a open source product. It has its constraints, but it is also a great kind of vehicle for PLG or if none of those are option, you can build a really realistic kind of experience. For example, I remember Amplitude, they are pursuing PLG now, but they used to have a lot of barrier. As an end user, it's hard for me to put that code into my product and see my data, but they build a really realistic interactive demo that's getting closer to PLG. So it's not PLG, but it's getting closer and you can already see the value and play with it yourself. So that's the first step. Have a vehicle.

**中文翻译:**
第一件事是……正如你提到的，要有一个“载体”，比如免费版、免费试用。有时是开源产品，很多开发者产品都是从开源开始的。虽然有局限性，但它是 PLG 的极佳载体。如果这些都不行，你可以构建一个非常真实的体验。例如，我记得 Amplitude 现在在推 PLG，但以前门槛很高。作为终端用户，我很难把代码放进我的产品里看数据，但他们构建了一个非常真实的交互式 Demo，这更接近 PLG。虽然它本身不是 PLG，但它更接近了，你可以直接看到价值并亲自动手操作。所以第一步是：拥有一个载体。

---

### [00:21:18] Hila Qu

**English:**
The second step step is time to value. Basically, just because you have this vehicle doesn't mean people will come and use it and see the value. So you need to figure out how do you give your users a warm start and help them get started. I was talking with a kind of company today, they just realized we have this tool and when people come in into the free trial, they are asked to do some action, but nobody know how to do that. They may not have everything ready to take that action. So we're like, "What about we gave them some sample video or sample action they can try." Right? It's not the same as they do it themselves, but it's better. It's getting closer. And after that you can ask them to try the thing on their own and they need to do more work.

**中文翻译:**
第二步是价值实现时间。基本上，仅仅有了载体并不意味着人们就会来使用并看到价值。所以你需要弄清楚如何给用户一个“热启动”（Warm Start），帮助他们上手。我今天和一家公司聊天，他们意识到虽然有工具，但当人们进入免费试用时，被要求执行某些操作，却没人知道怎么做。他们可能还没准备好执行那个操作。所以我们想：“不如给他们一些示例视频或可以尝试的示例操作？”虽然这和他们亲自动手不一样，但更好，更接近了。之后你可以再要求他们自己尝试，那时他们才需要做更多工作。

---

### [00:22:07] Hila Qu

**English:**
So kind of think about all the ways you can reduce time to value. It doesn't need to be this big aha moment in the first five minutes, but at least give them some mini aha moments, right? So that's the second thing, third thing is think about from there. If they get aha moment, if they want to buy, you need to have this self-checkout flow ready, self-service flow. It's the foundation, if you have it, it doesn't mean they won't buy immediately, but at least it gave them this option to do that themselves. And the fourth thing I would say, between this kind of activation usage, aha moment to this conversion moment, actually there's a big gap. And what is the gap? How you can understand the gap, how you can guide people around that journey is basically you need to have a very good grasp of data.

**中文翻译:**
所以要思考所有能缩短价值实现时间的方法。不一定要在头五分钟就出现巨大的“顿悟时刻”（Aha Moment），但至少给他们一些微小的顿悟时刻。这是第二点。第三点是后续考虑：如果他们有了顿悟时刻并想购买，你需要准备好自助结账流程。这是基础，有了它不代表他们会立刻买，但至少给了他们自己购买的选择。第四点是，在激活使用、顿悟时刻到转化时刻之间，其实存在巨大的鸿沟。这个鸿沟是什么？你如何理解它？如何引导用户完成这段旅程？基本上，你需要对数据有非常好的掌握。

---

### [00:23:03] Hila Qu

**English:**
You need to have the foundation to understand their usage, their behavior, and then you can design a user journey in the product, in email, in all those tools to guide user to the next step. So have a very strong data foundation there. I would say. I think those are the main thing. And there are other things like your pricing need to be relatively simple. If your pricing is super complicated, they need to... Whenever they pick, for example, they try the product, they love it, they have a self-checkout flow, but in order to decide how much they need to pay, they need to send your sales some information, you need to do a quote, then that's broken, right? Or they're already confused about this process. So that is another kind of important thing as well.

**中文翻译:**
你需要有基础去了解他们的使用情况和行为，然后你才能在产品中、邮件中以及所有工具中设计用户旅程，引导用户进入下一步。所以要有一个非常强大的数据基础。我认为这些是主要内容。还有其他一些事情，比如你的定价需要相对简单。如果定价极其复杂，比如他们试用了产品并爱上了它，也有自助结账流程，但为了决定付多少钱，他们还得给销售发信息要报价，那流程就断了，对吧？或者他们已经对这个过程感到困惑了。所以定价简单也是另一件重要的事。

---

### [00:23:54] Lenny

**English:**
Cool. So just to summarize, I took notes on this kind of the things that you got to get. If you want to add a product led growth component, there needs to be something free and kind of self-serve that you can just start using on your own. There needs to be a quick time to value, there needs to be a self-serve checkout experience. You need a data foundation. I really love the way you phrased it where one of the benefits of product growth is the data component that'll help you understand what to build on, how to monetize these folks. And then the last piece is pricing that's simple, that people understand.

**中文翻译:**
酷。总结一下我记的笔记：如果你想增加 PLG 组件，需要有免费且自助的东西让用户能直接开始使用；需要快速实现价值；需要自助结账体验；需要数据基础。我很喜欢你的说法，PLG 的好处之一就是数据组件，它能帮你理解该构建什么以及如何变现。最后一点是简单易懂的定价。

---

### [00:24:23] Hila Qu

**English:**
Yeah, yeah, yeah. Just imagine you are building, selling something on e-commerce side. You need all of this, right. Just in order for the B2B buyer to buy your software in PLG motion, you need to make all those available to him. It doesn't mean if you view this, it'll happen, again, right. That's the data experimentation. A lot of that need to be there to support a lot of iteration and make this work.

**中文翻译:**
没错。想象一下你在做电商。你需要所有这些环节。为了让 B2B 买家在 PLG 模式下购买你的软件，你需要把这些都提供给他们。当然，并不是说你做了这些就一定会成功，这还需要数据实验。需要大量的迭代来支撑，才能让这套模式运转起来。

---

### [00:24:52] Lenny

**English:**
Awesome. Okay, so we've been going in a lot of directions. We started with pitfalls and things you probably will... You'll run into that may set you off track. But let's zoom out again and let's get into, just say you're convinced we need to invest in adding a product-led growth motion to our product. What's the first step that you recommend for people to go down?

**中文翻译:**
太棒了。我们谈了很多方向，从陷阱开始，聊到了可能让你偏离轨道的因素。现在让我们再次放大视角：假设你已经被说服，决定投资为产品增加 PLG 模式。你建议人们迈出的第一步是什么？

---

### [00:25:12] Hila Qu

**English:**
I think the first step actually, I would recommend founders and leaders to just understand what's PLG funnel, what's sales-led funnel with SLG funnel. Because I remember when I begin to work on PLG at GitLab, it was not that clear to me. There's a lot of things you can read, but they're not all super clear. What is PLG? How is that different? And through working on that myself, I begin to develop this conviction and kind of this clear picture. The biggest difference from SLG and PLG is that the sales funnel traditionally work like something... You have marketing team working on the top of funnel, bring visitor and then they need to have a process to turn the visitors into lead. And leads is something, it is basically very popular and vitally used in the B2B business. And you go through some qualification process and leads need to be from your target kind of customer, target industry.

**中文翻译:**
我认为第一步实际上是建议创始人合领导者去理解什么是 PLG 漏斗，什么是销售驱动（SLG）漏斗。因为我记得当我开始在 GitLab 负责 PLG 时，我自己也不是很清楚。虽然有很多资料可以读，但并不都那么清晰。什么是 PLG？它有什么不同？通过亲身实践，我开始建立起信心并有了清晰的认识。SLG 和 PLG 最大的区别在于：传统销售漏斗是营销团队负责漏斗顶部，吸引访问者，然后通过流程将访问者转化为线索（Lead）。线索在 B2B 业务中非常流行且被广泛使用。你会进行一些资格审查，线索必须来自你的目标客户和目标行业。

---

### [00:26:23] Hila Qu

**English:**
The company need to meet certain size, but they also need to show interest. And how marketing team historically gauge interest is how much they interact with your marketing campaigns. Do they open an email? Do they read three white papers? Do they go to this webinar? That's how they gauge interest. And for each positive action you did as a buyer, they add some points to you. And once you reach certain points, you become this marketing qualified leads. Basically those are the better ones we featured through that process and we gave that to the sales team. And sales team has more process, but then they choose some of them, work on them, and they close some of them. So that's kind of traditionally B2B sales-led motion works. And then product-led funnel is different. It's much more similar to B2C. Basically you can still have people visit your website and they sign up for free version or free account or free trial.

**中文翻译:**
公司需要达到一定规模，但他们也需要表现出兴趣。历史上营销团队衡量兴趣的方式是看他们与营销活动的互动程度：他们开邮件了吗？读了三本白皮书吗？参加了这个研讨会吗？这就是他们衡量兴趣的方式。作为买家，你每做一个积极的动作，他们就给你加分。一旦达到一定分数，你就成了营销合格线索（MQL）。基本上这些是经过筛选的优质线索，我们会把它们交给销售团队。销售团队有更多的流程，他们从中挑选一些进行跟进并最终成交。这就是传统 B2B 销售驱动模式的运作方式。而产品驱动漏斗则不同，它更像 B2C。基本上人们仍然访问你的网站，然后注册免费版、免费账户或免费试用。

---

### [00:27:21] Hila Qu

**English:**
The most important thing, the biggest difference, is now you want them to use the product. You can still send all the marketing emails, all of that, but those are supplemental. Those are kind of trying to get them to the product to use, to try, and the usage, product usage, is almost like the leading indicator for success for PLG, versus in the sales funnel, it's almost like how many do you get and do they interact with the marketing campaigns, which in the old days it's what you have because nobody can access your product unless the contract is signed. But nowadays that's almost like an artificial barrier. It's not there. You can totally build a product in a free version to allow people to use. So usage becomes so important. And that's the biggest difference from the usage that you have two potential conversion paths.

**中文翻译:**
最重要、也是最大的区别在于：现在你希望他们使用产品。你仍然可以发送营销邮件，但那些都是辅助性的。它们是为了引导用户去使用、去尝试产品。产品使用情况几乎是 PLG 成功的领先指标。而在销售漏斗中，指标几乎是你获得了多少线索以及他们是否与营销活动互动。在过去，这是你唯一能做的，因为除非签了合同，否则没人能接触到你的产品。但现在这几乎成了一种人为障碍。它本不该存在。你完全可以做一个免费版让人们使用。所以使用情况变得如此重要。这是最大的区别，基于使用情况，你有两条潜在的转化路径。

---

### [00:28:18] Hila Qu

**English:**
One is that if this product is not that expensive, the price point fits in most companies' budget. Some companies may just use their credit card and they buy online. That's also, you then don't even need sales team to be involved. And it's very similar to the B2C product, e-commerce product, buying process. And it's awesome because it's automated, you don't need to have more sales team involved. It's low cost, it's efficient, it can happen on its own every day. It will just add up to your revenue. And then the other potential conversion pass is where the product usage is high, but also this customer, this potential prospect, fits into your ideal customer profile. It's from a Fortune 500 company or it's from a target industry that you know they need your solution. Then this customer worth more of your time and you should actually not, even if they may want to buy on their own, you may want to still have your sales team or have your customer success team to reach out to them to understand a little bit more of the situation and give them some white glove service. Hopefully you can even close a bigger deal than if they would have buy on their own. So that's another pass. I call that PQL, PQA, like sales pass.

**中文翻译:**
第一条是，如果产品不贵，价格符合大多数公司的预算，有些公司可能直接刷信用卡在线购买。这样你甚至不需要销售团队介入。这非常类似于 B2C 产品或电商产品的购买过程。这太棒了，因为它是自动化的，不需要销售团队，成本低、效率高，每天都在自动发生，直接增加你的收入。另一条潜在转化路径是：产品使用率很高，而且这个潜在客户符合你的理想客户画像（ICP）。他们来自财富 500 强公司，或者来自你深知需要你解决方案的目标行业。那么这个客户就值得你投入更多时间。即使他们想自己买，你可能仍希望销售团队或客户成功团队主动联系他们，深入了解情况并提供“白手套”级别的服务。希望能谈成比他们自助购买更大的单子。这就是另一条路径，我称之为 PQL（产品合格线索）或 PQA（产品合格账户），也就是销售路径。

---

### [00:29:47] Lenny

**English:**
And that stands for product qualified lead, right?

**中文翻译:**
那代表产品合格线索（Product Qualified Lead），对吧？

---

### [00:29:48] Hila Qu

**English:**
Product qualified leads, product qualified account. So the first step is for you to understand those two funnels and then think about if you want to add PLG, right? What is this journey? What are the steps along that funnel you need to establish for your product in order for your user to be able to convert in that funnel?

**中文翻译:**
产品合格线索，产品合格账户。所以第一步是让你理解这两个漏斗，然后思考如果你想增加 PLG，这段旅程是什么样的？为了让用户能在该漏斗中转化，你需要为你的产品建立哪些步骤？

---

### [00:30:12] Lenny

**English:**
So you talked about these two funnels. One question is, are they basically the same for almost every product or should you try to figure out what's really unique about my funnel? And then second, is there an example of product that you think about like, here's the sales led funnel for them and then here's the product-led version of that, just to make it a little more real even?

**中文翻译:**
你谈到了这两个漏斗。一个问题是：它们对几乎所有产品来说都基本相同吗？还是说你应该试着找出自己漏斗的独特之处？第二，有没有什么产品的例子，比如“这是他们的销售驱动漏斗，这是他们的产品驱动版本”，让这个概念更具体一点？

---

### [00:30:30] Hila Qu

**English:**
Maybe I can give an example first and then we can talk about the other question. So I can use GitLab as an example since that's where I'm most familiar. GitLab actually have a enterprise sales team, very strong sales team, from the very beginning. But the company also we started from open source product.

**中文翻译:**
也许我可以先举个例子，然后再讨论另一个问题。我可以用 GitLab 为例，因为那是我最熟悉的。GitLab 从一开始就有一支非常强大的企业销售团队。但公司也是从开源产品起家的。

---

### [00:30:50] Lenny

**English:**
Maybe describe what GitLab is for folks that aren't super familiar with it.

**中文翻译:**
也许可以为不太熟悉的人描述一下 GitLab 是做什么的。

---

### [00:30:53] Hila Qu

**English:**
Yeah, so GitLab, we are a developer platform, DevOps platform, basically engineer teams, developer teams. They use this product to manage their entire DevOps process, from storing their code, kind of managing the version control, releasing CSAD, like security scan, all of that. It's an all in one platform for that team. So for the sales-led motion, like I mentioned, the teams, our marketing team, were working bringing a lot of visitors to our website and they sign up for free trial, for free accounts. And then we have this lead nurturing and lead scoring process to surface which are the good ones for our sales team. In our sales team, we have SNB, we have the mid-market, we have enterprise, and they each kind of took their buckets of leads and work on them and close them. They become revenue.

**中文翻译:**
好的。GitLab 是一个开发者平台，或者说 DevOps 平台。基本上工程师团队、开发团队使用这个产品来管理他们的整个 DevOps 流程，从存储代码、管理版本控制、发布 CI/CD、安全扫描等等。它是团队的一站式平台。对于销售驱动模式，正如我提到的，我们的营销团队负责吸引大量访问者到网站，让他们注册免费试用或免费账户。然后我们有线索培育和线索评分流程，为销售团队筛选出优质线索。我们的销售团队分为中小企业（SMB）、中端市场和企业级，他们各自负责自己的线索池，进行跟进并成交，转化为收入。

---

### [00:31:52] Hila Qu

**English:**
And then how the product led funnel work for us is someone, maybe as a developer, I heard about GitLab, I go to website, I see, "Oh, I can actually sign up for a free account." I may use it for my personal project. My company may be using another solution, but I have some side project I'm doing as a developer. I want to use GitLab to host that. And I did that. And so you begin to see this, individual users having some usage but nothing to do with his company. And then one day maybe this person's employer, "We want to look into some other solutions. We have way too many point solutions for each step of DevOps. Now we want to potentially consolidate them. So what are the options?" And this engineer raise his hand, "Hey, I have been using GitLab for a very long time and I really like it. I think we should check them out." And then this team, maybe this engineer manager or CTO depending on the size of company, they're like, "Okay."

**中文翻译:**
而 PLG 漏斗对我们来说是这样的：某人，可能是一名开发者，听说了 GitLab，去网站一看，“哦，我可以注册个免费账户。”我可能会把它用于个人项目。我的公司可能在用别的方案，但我作为开发者有一些业余项目，我想用 GitLab 来托管。于是我这么做了。你会看到这些个人用户有一些使用行为，但与他的公司无关。直到有一天，这个人的雇主说：“我们想看看其他的方案。我们在 DevOps 的每一步都有太多的单点解决方案，现在想整合一下。有什么选择？”这时这名工程师举手说：“嘿，我用 GitLab 很久了，非常喜欢。我觉得我们可以考察一下他们。”然后团队，可能是工程经理或 CTO（取决于公司规模），会说：“好啊。”

---

### [00:32:55] Hila Qu

**English:**
He went to their website and he kind of signed up for a free trial because that allow him to test some more advanced features. It's 30 days, but he already has... This person knows how to use it. This person already set up the foundation with the free version and they started the free trial. They use their 30 day to do a proof of concept, the entire company already using it for part of their process. And they're like, "Oh, awesome. I tried this feature, that feature, that feature. It's a great tool. It can support our workflow and I'm pretty sure we should be able to get ROI from this product." And then in this case they are like, "I only need five seats. It's cheap. I will just go to the pricing page and check out the pricing and buy from there." Or in some cases, this is a big company and we see this big company is using our product, our sales team get that data signal, they may send an email and reach out and say, "Hey, I saw you were checking it out. How can I help?" And that may start a sales conversation, eventually become a contract from there.

**中文翻译:**
他去了网站，注册了免费试用，因为这可以让他测试更多高级功能。试用期是 30 天，但他已经……这个人知道怎么用。他已经通过免费版打好了基础，然后开始试用。他们利用这 30 天做概念验证（POC），整个公司已经在部分流程中使用了它。他们觉得：“哦，太棒了。我试了这个功能、那个功能，它是个很棒的工具，能支持我们的工作流，我确信我们能从这个产品中获得投资回报（ROI）。”在这种情况下，他们可能会想：“我只需要五个席位，很便宜，我直接去定价页面买就行了。”或者在某些情况下，这是一家大公司，我们看到这家大公司正在使用我们的产品，我们的销售团队收到了这个数据信号，他们可能会发邮件联系说：“嘿，我看到你们正在试用，有什么我能帮忙的吗？”这可能会开启一段销售对话，最终签下一份合同。

---

### [00:34:07] Lenny

**English:**
Great. Thank you for sharing that example. Maybe a last question on this first step of mapping out the funnel. Do you recommend people just get in front of a whiteboard and just sit together and like, "Here's what it would be potentially if we added a product-led growth motion?"

**中文翻译:**
太棒了，谢谢你分享这个例子。关于“绘制漏斗图”这第一步，最后一个问题：你是否建议大家直接聚在白板前坐在一起讨论，“如果我们增加 PLG 模式，潜在的流程会是怎样的”？

---

### [00:34:20] Hila Qu

**English:**
Yes. Yes. And I think it's not that... The devil is in the details. Just mapping out the big steps is not that hard. You think about, " I have a marketing site already. I can build a free version." And then they use the free version and I build a checkout flow and that's it. That's the story. But that's the first step. If you don't even have those components, mapping out the funnel will allow you to see a missing checkout flow, a missing free version, you already identified that. But the devil is in the detail one layer down. How do you design an experience for each of the step? What do you say on your marketing side to drive free signup? In the free signup, how do you guide them to use the three most important features? And in the checkout flow, which payment option do you offer so that customers from everywhere can buy very smoothly? So that's the next layers kind of detail that actually has so many opportunities for optimization, maximization and all of that.

**中文翻译:**
是的，没错。但我认为……细节决定成败。仅仅画出大步骤并不难。你会想：“我已经有营销网站了，我可以做一个免费版。”然后他们用免费版，我再做一个结账流程，搞定。这就是故事梗概。但这只是第一步。如果你连这些组件都没有，画出漏斗能让你发现缺失了结账流程或免费版，你已经识别出了问题。但真正的难点在于下一层的细节。你如何为每一步设计体验？你在营销端说什么来驱动免费注册？在免费注册后，你如何引导他们使用最重要的三个功能？在结账流程中，你提供哪些支付选项让全球客户都能顺畅购买？这就是下一层的细节，实际上蕴含着无数优化和最大化价值的机会。

---

### [00:35:29] Lenny

**English:**
That's actually a really good segue to the next question, which is just, okay, you've mapped out the funnel, what do you do next?

**中文翻译:**
这正好引出了下一个问题：好了，漏斗图画好了，下一步该做什么？

---

### [00:35:35] Hila Qu

**English:**
If you don't have the foundational components, you need to build all of that. But if you have something, if you already have this funnel exist, right, it's just not working perfectly at least, but it's working, it's there. I think the next step is you need to pick a starting point. Where do you want to focus first to drive the maximum impact? Personally, I'm a big fan of finding leverage. I think doing growth is always about finding leverage. If you can always find the area that with relatively small investment can give you the biggest results, that can be such a kind of momentum, can empower you through future experiments and more work. And just finding leverage is a beautiful thing in my mind. So I always want to do that. So when I think about pick a starting point, one thing I actually do with a lot of my advisory clients as a first step is, we do a full funnel audit, full PLG funnel audit.

**中文翻译:**
如果你还没有基础组件，你需要把它们都建起来。但如果你已经有了一些东西，如果这个漏斗已经存在了，虽然运行得不完美，但它在那儿。我认为下一步是：你需要选择一个切入点。你想先专注于哪里以产生最大的影响？就我个人而言，我是“寻找杠杆”的忠实粉丝。我认为做增长的核心就是寻找杠杆。如果你总能找到那个投入相对较小却能带来最大回报的领域，那将产生巨大的动力，支撑你进行未来的实验和更多工作。在我心中，寻找杠杆是一件美妙的事情。所以我总是想这么做。当我思考选择切入点时，我实际上对很多咨询客户做的第一步就是：进行全漏斗审计，全 PLG 漏斗审计。

---

### [00:36:38] Hila Qu

**English:**
Think about, we go through me as a kind of end user, go through the entire journey, pretend I am interested, semi interested, and I want to buy from the website. Does that kind of attract me? Is it super clear the value proposition? And then from there, going through the sign up of the free account or free trial, is that smooth? And when I begin to use the product, do I get to my aha moment fast or I am very confused and frustrated, abandoned at that moment? And from there, if I'm like, think this is good, right, I hit my aha moment, I want to buy. Can I even buy? You will never believe, like when I do this audit,, there are so many low hanging fruits usually in this process. For example, one client, when I go to the checkout flow, the kind of checkout form is so confusing.

**中文翻译:**
想象一下，我作为一个终端用户，走完整个旅程。假装我很感兴趣或半感兴趣，想从网站购买。网站吸引我吗？价值主张（Value Proposition）清晰吗？然后，注册免费账户或试用的过程顺畅吗？当我开始使用产品时，我能快速达到“顿悟时刻”吗？还是说我很困惑、很沮丧，在那一刻就放弃了？如果我觉得产品不错，达到了顿悟时刻，想买，我能买得到吗？你绝对不敢相信，当我做这种审计时，通常会发现这个过程中有非常多“唾手可得的果实”（Low-hanging fruits）。例如，有一个客户，当我进入结账流程时，那个结账表单简直让人摸不着头脑。

---

### [00:37:38] Hila Qu

**English:**
They ask a bunch of questions that only let's say UK customer need. Every other places they don't need to answer, but they ask the question anyway. And I as a US based person is very confused and I drop off at that point. And then there are other things, for example, the aha moments like I talk about. I don't know what to do when I land inside a product for the first time, I'm super excited and ready, but I don't know what to do. I'm so lost and confused. That's usually a pretty big focus area and opportunity area. Just getting your users to aha moments. They are already over so many hurdles here, but don't just turn down them and they leave because it's so confusing.

**中文翻译:**
他们问了一堆只有英国客户才需要回答的问题。其他地方的人根本不需要回答，但他们照问不误。我作为一个在美国的人感到非常困惑，就在那一刻退出了。还有其他事情，比如我提到的顿悟时刻。当我第一次进入产品时，我非常兴奋并准备好了，但我不知道该做什么。我感到迷茫和困惑。这通常是一个非常大的重点领域和机会领域。就是让你的用户达到顿悟时刻。他们已经跨过了这么多障碍来到这里，不要因为流程太混乱就把他们拒之门外，让他们离开。

---

### [00:38:25] Lenny

**English:**
It might be helpful just to explain an aha moment. I know people hear this term a lot. What's a simple way to think about what is an aha moment?

**中文翻译:**
解释一下什么是“顿悟时刻”（Aha Moment）可能会有帮助。我知道人们经常听到这个词。有没有什么简单的方法来理解它？

---

### [00:38:32] Hila Qu

**English:**
I think it as a moment, as a first time a user experienced value of your product. So it gets popular because Facebook has this example from the early growth days. I think you added 10 friends in seven days, you hit your aha moment. But there are many layers under that. The reason why Facebook used that to define its aha moment is because in early days, if you add these friends, you begin to form some connection. You can see an interesting feed, you can interact with your friends, and that social interaction, it's the core value of Facebook, and Facebook leaves by looking at a lot of data. If you meet that data metric criteria it's kind of very likely you will hit that aha moment. But I think for a lot of, especially we're talking about many SaaS product, B2B software, the value of such product is usually either you see a workflow can be supported by this, it can save your time, it can save your money, it can help you make more money, or it just solve this pain point that you never get to solve on your own without a software product.

**中文翻译:**
我认为它是一个时刻，即用户第一次体验到你产品价值的时刻。它之所以流行是因为 Facebook 早期增长的一个例子：如果你在 7 天内添加了 10 个好友，你就达到了顿悟时刻。但这下面有很多层含义。Facebook 之所以用这个来定义顿悟时刻，是因为在早期，如果你加了这些朋友，你就开始建立联系，能看到有趣的动态，能和朋友互动。这种社交互动是 Facebook 的核心价值。Facebook 通过观察大量数据发现，如果你满足了这个数据指标标准，你极有可能体验到那个顿悟时刻。但对于很多 SaaS 产品或 B2B 软件，价值通常在于：你看到一个工作流可以被支持，它能帮你省时、省钱、帮你赚更多钱，或者它解决了你没有软件产品就无法自行解决的痛点。

---

### [00:39:57] Hila Qu

**English:**
So at GitLab we actually did a bunch of analysis. We're trying to understand what is the aha moment for our new users. We ended up have something along the line of two users, two features used in the first 14 days. So it's very similar to Facebook's kind of format. But deep down, because we are a platform, we are a team product, two users is talking about the team components. Whatever the first user is trying and using that is so valuable, he or she is confident to invite another coworker to come in. That itself is very, very valuable action and indicates this first user is seeing value. And if together they use two or more features, that means we are seeing the collaboration, the platform components of the product. And within the first 14 days, because it has to be reasonably quick but not unrealistic, because we are a complicated product, we're not Facebook, we're not Zynga or a game app, it's hard for you to figure it out in the first day. So yeah, I think it's a very important concept for any PLG company to figure out because that's often the biggest opportunity area I see.

**中文翻译:**
在 GitLab，我们实际上做了大量分析，试图理解新用户的顿悟时刻是什么。我们最终得出的结论类似于：在头 14 天内有 2 个用户使用了 2 个功能。这和 Facebook 的格式很像。但深入来看，因为我们是一个平台，是一个团队产品，“2 个用户”体现了团队组件。无论第一个用户尝试和使用了什么，只要他觉得有价值，他就有信心邀请另一名同事加入。这本身就是一个非常非常有价值的动作，表明第一个用户看到了价值。如果他们一起使用了两个或更多功能，这意味着我们看到了协作和产品的平台属性。设定在 14 天内，是因为它必须足够快，但也要现实，因为我们是一个复杂的产品，不是 Facebook 或 Zynga 那样的游戏应用，你很难在第一天就搞明白。所以，我认为对于任何 PLG 公司来说，弄清楚这个概念都非常重要，因为这通常是我看到的最大的机会领域。

---

### [00:41:24] Lenny

**English:**
Aha moment and activation is often interchangeable, right?

**中文翻译:**
顿悟时刻和激活（Activation）通常是可以互换的，对吧？

---

### [00:41:27] Hila Qu

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:41:27] Lenny

**English:**
So those are kind of two things you'll hear. And just to reframe, re-say what you say, so GitLab's activation slash aha moment milestone was two users using two features in 14 days.

**中文翻译:**
所以你会听到这两个词。重申一下你说的：GitLab 的激活/顿悟时刻里程碑是 14 天内 2 个用户使用 2 个功能。

---

### [00:41:38] Hila Qu

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### [00:41:40] Lenny

**English:**
And I imagine the way you got to that was you looked at what point does retention improve if they got to a certain milestone, right? Is that roughly how you [inaudible 00:41:48]?

**中文翻译:**
我猜你得出这个结论的方法是观察：如果用户达到了某个里程碑，留存率在什么时候会提高，对吧？大概是这么做的吗？

---

### [00:41:47] Hila Qu

**English:**
Yeah, exactly. So there are how you can get to that, right? First of all, the internal team, our growth team, actually we did some brainstorming. We think about what are the potential action or behavior that indicate they're getting value. We ideally want to do something like they maybe successfully merge their first PR or they successfully run their first pipeline. All of that. There are some potential high value actions we can think of. We just list all of them. And then the next step is, we did a correlation analysis to understand, hey, those are the 10 high value actions we believe we want to look at. If a new user did this action, what's the maybe 30 day conversion rate and... Not 30 day, 90 day conversion rate. What's the 30 day retention rate? Because we look at both. Sometimes you only look at retention or you only look at conversion, it doesn't give you the full picture.

**中文翻译:**
没错。具体做法是这样的：首先，我们的增长团队进行了头脑风暴。我们思考哪些潜在的动作或行为表明用户获得了价值。理想情况下，我们希望是像“成功合并第一个 PR”或“成功运行第一个流水线”之类的动作。我们可以想到一些潜在的高价值动作，并把它们列出来。下一步是做相关性分析，去了解：嘿，这是我们认为值得关注的 10 个高价值动作。如果一个新用户做了这个动作，他 90 天的转化率是多少？30 天的留存率是多少？因为我们两者都看。有时你只看留存或只看转化，无法得到全貌。

---

### [00:42:52] Hila Qu

**English:**
So we look at if you did this action, let's say if, Lenny, you are trying our product, you are able to successfully merge the PR in your first 30 days. Does that improve your likelihood to convert? Does that improve your likelihood to retain? And we compare across those 10 high value actions, compare with the average. And we begin to see, oh, some actions actually if you do that, it lift your conversion, lift your retention much bigger. And those are the candidates for potential aha moments. And from there, the reason why we ended up not picking one single action... For some products, actually you can pick a single action. If one action really stands out, I don't know, for Airbnb [inaudible 00:43:39] is probably, you book a hotel, you go to there, you are so happy, you leave a high star review. That's the key action for this platform.

**中文翻译:**
所以我们会看，如果你做了这个动作——假设 Lenny 你在试用我们的产品，你在头 30 天内成功合并了一个 PR。这是否提高了你转化的可能性？是否提高了你留存的可能性？我们将这 10 个高价值动作与平均水平进行对比。我们开始发现，哦，有些动作如果你做了，对转化和留存的提升要大得多。这些就是潜在顿悟时刻的候选动作。至于为什么我们最终没有选择单一动作……对于某些产品，你确实可以选单一动作。如果某个动作非常突出，比如 Airbnb，可能是你订了酒店，去了那里，很开心，留下了高分评价。那是该平台的关键动作。

---

### [00:43:49] Hila Qu

**English:**
For GitLab, we have so many different workflow components. Teams are here for different reasons. Some are here for security, some are here for like CSAD. So that's why we ended up combining like two action. It can be any of the two high value features. The next step is actually you need to launch some experiments to try to get more people to do those high value action. And you then see, do I see higher conversion? Do I see higher retention? Because in data you are only isolating correlation. You are not proving causation. You just saw people who are doing this are more likely to convert. But it doesn't mean if you get people to do that, they will convert. So experimentation is the step. You will finally kind of validate that.

**中文翻译:**
对于 GitLab，我们有太多不同的工作流组件。团队来这里的目的各不相同：有些是为了安全，有些是为了 CI/CD。所以我们最终结合了两个动作，可以是任何两个高价值功能。下一步实际上是开展一些实验，尝试让更多人执行这些高价值动作。然后观察：我是否看到了更高的转化率？是否看到了更高的留存率？因为在数据中，你只能分离出相关性，而不能证明因果关系。你只是看到做这些事的人更有可能转化，但不代表你强迫人们去做这些事，他们就一定会转化。所以实验是关键步骤，它能最终验证这一点。

---

### [00:44:37] Lenny

**English:**
Hila, this is amazing. This is like a mini podcast on activation. We should do another one just on this. And then in the show notes, I'll link to a couple posts that I've written with a bunch of advice on setting activation milestones and improving them. I forget if you've contributed to that post or not, but if not, we should add some of these stories. But let's get back to our core. We have enough to talk about on just product led growth. So just to summarize the audit that you do, I wrote some notes as you were talking, and maybe we can keep going from that point. What you look for when you're auditing a product to see where they may pick a starting point, what I wrote down is, one, are you just excited to try it? Is the landing page pulling you in? Two, can you actually use it on your own and just try it? Three, do you get to the aha moment where you're like, okay, I get it, [inaudible 00:45:25] it, and then can I actually buy this on my own? Is that roughly the audit? Is there anything more to that?

**中文翻译:**
Hila，这太棒了。这简直是一段关于激活的小型播客。我们应该专门为此再录一集。在节目笔记里，我会链接到我写的几篇关于设定和改进激活里程碑的文章。我忘了你有没有为那篇文章贡献内容，如果没有，我们应该把这些故事加进去。但让我们回到核心话题，光是 PLG 就有够多聊的了。总结一下你做的审计，我边听边记了些笔记，我们可以从这里继续：当你审计一个产品以寻找切入点时，你关注的是：1. 你是否兴奋地想尝试？着陆页吸引你吗？2. 你能自己动手试用吗？3. 你能达到顿悟时刻并心想“哦，我懂了”吗？4. 我能自己购买吗？审计大致是这样吗？还有别的吗？

---

### [00:45:30] Hila Qu

**English:**
Exactly. I also look at their initial first few emails they send to me, because sometimes the email magically can help a lot. If I'm frustrated the first time... The other day I'm trying a product, I'm frustrated, I'm like, I will give up. And then in the night I saw an email, I'm like, oh, maybe I just click the CTA and give it one more try. And that time actually I figured out I get to the aha moment. So I also look at the email, the first initial emails, and then when I map this out, I ask the company to give me the data at very high level for each of the step. How many people are on your website? How many people go through signup? How many people hit this aha moment? We need to define that. We need to... Usually a lot of discussion, like how many people get to the aha moment, how many people started self-checkout and being successful. And then like that between my experience from a user perspective and the data, we usually immediately begin to see, oh, this is the biggest opportunity. Usually activation and conversion are two of the common starting places.

**中文翻译:**
没错。我还会看他们发给我的最初几封邮件，因为有时邮件能起到神奇的作用。如果我第一次尝试时感到沮丧……前几天我试用一个产品，很沮丧，心想我要放弃了。结果晚上我看到一封邮件，我想：“哦，也许我该点一下这个按钮再试一次。”结果那次我真的达到了顿悟时刻。所以我也会看最初的邮件。当我画出流程图后，我会要求公司提供每一步的高层级数据：网站有多少访客？多少人完成了注册？多少人达到了顿悟时刻？我们需要定义这个。通常会有很多讨论，比如多少人达到了顿悟时刻，多少人开始了自助结账并成功。结合我的用户体验和这些数据，我们通常能立刻发现：哦，这就是最大的机会。通常激活和转化是两个最常见的起点。

---

### [00:46:42] Lenny (Sponsorship)

**English:**
This episode is brought to you by Ahrefs. You probably know Ahrefs as one of the leading all-in-one SEO tools, used by companies like Facebook, Uber, Shopify, LinkedIn, Pinterest, and thousands more. But Ahrefs is not just for big companies. With their new Ahrefs webmaster tools, you can optimize your personal website like a professional for free. You can scan your website for over a hundred common SEO issues that might be hurting your performance in search engines, plus get advice on how to fix those errors. You can have it automatically browse your website's internal and external links, and get actionable insights from your backlink profiles, and you can learn what keywords your website ranks for and see how you stack up against your competitors. Visit ahrefs.com/awt and start improving your website's visibility. That's ahrefs. com/awt.

**中文翻译:**
本集由 Ahrefs 赞助。你可能知道 Ahrefs 是领先的一站式 SEO 工具，被 Facebook、Uber、Shopify、LinkedIn、Pinterest 等数千家公司使用。但 Ahrefs 不仅仅服务于大公司。通过他们全新的 Ahrefs 站长工具，你可以像专业人士一样免费优化你的个人网站。你可以扫描网站中 100 多种可能损害搜索引擎表现的常见 SEO 问题，并获得修复建议。它可以自动浏览网站的内外链接，从反向链接配置文件中获取可操作的见解，你还可以了解网站的关键词排名，并查看你与竞争对手的差距。访问 ahrefs.com/awt 开始提升你网站的可见性。

---

### [00:47:42] Lenny

**English:**
Okay, so let's get into that then. So you've done this audit, what other advice do you have for folks to figure out where they should start and invest in that part of the product to help launch product-led growth?

**中文翻译:**
好，那我们深入探讨一下。你做完了审计，对于人们如何确定该从哪里开始投资产品以启动 PLG，你还有什么建议？

---

### [00:48:00] Hila Qu

**English:**
You can do a audit like this yourself, right. Just imagine if you are a B2C user trying to buy a product, you want it to be easy. Ideally, PLG for B2B can be that easy as well. So go through that process and identify, where is confusing, where do you get stuck? If you find that you have a problem with activation, meaning if you enter into the product you are like what do I do, I don't know what should I do, and maybe I just left. And then, if that's the biggest opportunity, activation, then you need to think about find the right aha moment metric as the first step, as we just talked about, because that's the success, that's the goalpost. And then, design a product experience to help more people together. And I usually think about do is better than show is better than tell, meaning you want to remove all the frictions and somehow give them a warm start, give them some sample template, give them some sample thing they can play with initially in that very moment already, and you can supplement that with your email to bring them to the product if they don't do that. So that's activation.

**中文翻译:**
你可以自己做这样的审计。想象一下你是一个想买产品的 B2C 用户，你希望过程简单。理想情况下，B2B 的 PLG 也可以这么简单。所以走一遍流程，识别哪里令人困惑，哪里让你卡住了。如果你发现激活有问题，也就是说进入产品后你心想“我该做什么？我不知道该干嘛”，然后就离开了。如果激活是最大的机会，那么第一步就是找到正确的顿悟时刻指标，正如我们刚才讨论的，因为那是成功的终点线。然后，设计产品体验来帮助更多人达到那里。我通常认为“做优于看，看优于说”，这意味着你要消除所有摩擦，给他们一个热启动，给他们一些示例模板，给他们一些可以立即上手玩的东西。如果他们没做，你可以通过邮件补充，把他们带回产品。这就是激活。

---

### [00:50:08] Hila Qu

**English:**
If activation is okay, but your conversion, your self-check checkout flow, usually there are also room for improvement. Many company I work with, when I try to buy, I cannot even find where to buy. It's very hard to find where do I click to start this checkout process, or they may have some frictions in the checkout flow where it's not localized. One company, when I look at their data, they find that India has very low success rate, which is expected, but we begin to say it's because the payment solution they choose actually doesn't support that market well. And they added another payment solution, immediately they are seeing much better success rate. And if they're already in the checkout, you don't want to lose any of them, right? Just do a hundred experiments to get to as much higher kind of commercial possible, because you don't want to lose any of them. So activation, conversion, usually are two great place to start.

**中文翻译:**
如果激活没问题，但转化和自助结账流程通常也有改进空间。我合作过的很多公司，当我想买的时候，甚至找不到在哪里买。很难找到点击哪里开始结账，或者结账流程中有摩擦，比如没有本地化。有一家公司，我看他们的数据发现印度的成功率非常低，这在预料之中，但我们发现是因为他们选择的支付方案在当地支持不好。他们增加了另一种支付方案后，成功率立刻大幅提升。如果用户已经在结账了，你肯定不想失去任何一个，对吧？那就做一百个实验，尽可能提高转化率，因为你不想流失任何一个用户。所以激活和转化通常是两个很好的起点。

---

### [00:50:53] Hila Qu

**English:**
And then from there, I would say think about your PQL/PQA, motion, which is the other conversion pass, which is if you also want to have sales blended into this, right, product-led sales motion, how do you set up the structure, the foundation so that you can know what are some data signal to tell you those are better leads? And what are some customer criteria, in terms of size segment, you should set up, how do you get those data, and then how do you hand this to your sales team, how they can close using those data, use this knowledge? That's another very big opportunity area. That's a bigger effort, compared to those two low-hanging fruits. And the last thing I would say, product-led acquisition is a great place to start. If your product is a collaboration software, think about Airtable and it's Figma, right? As part of my workflow, I invite my team to join, I spread this out. If you have that use case, you can build that into a product that's awesome, that's very powerful.

**中文翻译:**
然后，我会说考虑你的 PQL/PQA 模式，也就是另一条转化路径。如果你想把销售融入其中，即“产品驱动销售”（Product-led Sales）模式，你如何建立结构和基础，以便知道哪些数据信号表明这些是更优质的线索？你应该设定哪些客户标准（如规模、细分市场）？你如何获取这些数据？然后你如何把这些交给销售团队，让他们利用这些数据和知识来成交？这是另一个巨大的机会领域，但相比前两个“唾手可得的果实”，这需要投入更多精力。最后我想说，产品驱动获客（Product-led Acquisition）也是一个很好的起点。如果你的产品是协作软件，想想 Airtable 或 Figma，对吧？作为工作流的一部分，我邀请团队加入，我就把产品传播出去了。如果你有这种用例，你可以把它构建进产品中，那将非常强大。

---

### [00:51:18] Lenny

**English:**
So there's a lot there. So let me try to summarize what you just shared and how it connects. So you have a self-serve product, you've gotten to a point where you can sign up and try something for free?

**中文翻译:**
内容很多。让我试着总结一下你刚才分享的内容以及它们是如何关联的。所以你有一个自助服务产品，已经到了用户可以注册并免费试用的阶段？

---

### [00:51:28] Hila Qu

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### [00:51:29] Lenny

**English:**
And then you do this audit of where along this journey do we think the biggest opportunities lie and the most leverage lives? And you have these, I think, four buckets of opportunity? Acquisition, which is top of funnel, do you want to double down and invest there first, or activation, which is help people see the value more quickly? Bucket three would be, you called it conversion, which essentially help them buy it more efficiently? And then there's a bucket of retention, of just keeping them around longer, which I don't know if you mentioned this, but I know that's probably not where you want to start, so it's even not worth chatting about too much.

**中文翻译:**
然后你进行审计，看看在这段旅程中，最大的机会和最大的杠杆在哪里？你有四个机会桶：1. 获客（Acquisition），即漏斗顶部，你想先在那里加倍投入吗？2. 激活（Activation），即帮助人们更快看到价值。3. 转化（Conversion），本质上是帮助他们更高效地购买。4. 留存（Retention），即让他们留得更久。我不知道你刚才提没提留存，但我知道那可能不是起步的地方，所以甚至不值得聊太多。

---

### [00:52:04] Hila Qu

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:52:05] Lenny

**English:**
Cool. And so the question, basically, a founder or product team has to decide is which of these three buckets do they go in on when they're trying to add product growth, acquisition, activation or conversion?

**中文翻译:**
酷。所以基本上创始人或产品团队需要决定的是，在尝试增加产品增长时，应该投入这三个桶中的哪一个：获客、激活还是转化？

---

### [00:52:16] Hila Qu

**English:**
Mm-hmm. Mm-hmm.

**中文翻译:**
嗯，嗯。

---

### [00:52:17] Lenny

**English:**
It'd be cool, maybe just one example of each of these three buckets, like what's a product that did a good job here? And then you also talked about how to know which one to start with. Maybe just again, just a quick summary of you should probably start activation if this, if you have something like that?

**中文翻译:**
如果能给这三个桶各举一个例子就太酷了，比如哪个产品在这方面做得好？你也谈到了如何决定从哪一个开始。也许可以再快速总结一下：如果遇到什么情况，你应该从激活开始？

---

### [00:52:32] Hila Qu

**English:**
You should probably start with activation. Activation is actually a common good starting place for most B2B software. Because usually B2B softwares are not designed to really get you to use quickly, historically. A good example, there are, I think, all the best PLG companies, they do a awesome job. That's almost like my criteria to say whether this is a great PLG product or not. Think about Miro, as an example. If you go through their activation experience and sign up to usage, they ask very limited questions, very targeted. They drop you, kind of, they ask you about your use case, what are you here for? Are here to do a brainstorm session? Are you here to develop a roadmap? And they quickly gave you templates to get started. Just like in maybe five minutes, you finish the entire journey from go to the website and sign up, answer a few questions, and you are already using the template they provided to do the thing you want to do. That's time to value. That's a success. I think that's a really great standard for all the PLG, like a B2B product, try to follow. So that's activation is usually a good place. If you don't know where to start, do that.

**中文翻译:**
你可能应该从激活开始。对于大多数 B2B 软件来说，激活通常是一个很好的起点。因为从历史上看，B2B 软件的设计初衷并不是为了让你快速上手。举个例子，我认为所有顶尖的 PLG 公司都做得非常出色。这几乎是我判断一个 PLG 产品是否伟大的标准。以 Miro 为例，如果你体验他们的激活过程，从注册到使用，他们问的问题非常有限且有针对性。他们会问你的用例：你是来做头脑风暴的吗？你是来制定路线图的吗？然后他们会迅速提供模板让你开始。可能只需五分钟，你就完成了从访问网站、注册、回答几个问题到使用模板开始工作的全过程。这就是价值实现时间，这就是成功。我认为这是所有 B2B 的 PLG 产品应该效仿的极佳标准。所以激活通常是个好地方，如果你不知道从哪开始，就选激活。

---

### [00:53:54] Hila Qu

**English:**
And then conversion, I would say, is a place, again, worth investing, but there are two layers. One is the self-check-hub flow, just do some experiments there. You can actually go to any E-commerce website, like, I don't know, go to Lululemon, go to Amazon, make your conversion process as easy as theirs. That should be your goal. The consumers shouldn't be confused about complicated pricing, where to find all of that, so that's a place always worth investing, testing more, because that's revenue so close to be added into your book. And then the PQL/PQA part, the other more-complicated path, I would say that's something you want to figure out activation and self-checkout a little bit, and you want to have some reasonable user number and then invest there, otherwise it can be a little bit jumping too fast and jumping too ahead. And the acquisition, a product-led acquisition is a great place to invest, if you have a collaboration workflow, you have some inherent, internal viral components in your products. Think about Figma, think about Calendarly even, right? It can spread. This product is so easy. You can build something to allow it to spread on its own.

**中文翻译:**
然后是转化，我认为也值得投资，但它有两个层面。一是自助结账流程，在那里做些实验。你其实可以去任何电商网站，比如 Lululemon 或亚马逊，让你的转化过程像他们一样简单。这应该是你的目标。消费者不应该被复杂的定价或找不到购买入口所困扰。所以这是一个永远值得投资和测试的地方，因为那是离入账最近的收入。至于 PQL/PQA 部分，也就是那条更复杂的路径，我会说你应该先搞定激活和自助结账，并拥有一定数量的用户后再去投资，否则可能会操之过急。最后是获客，如果你的产品有协作工作流，或者有内在的、原生的病毒式组件，那么产品驱动获客是一个很好的投资方向。想想 Figma，甚至 Calendly，对吧？它可以传播。产品非常简单，你可以构建一些机制让它自行传播。

---

### [00:55:24] Lenny

**English:**
I'm hoping that was really helpful, because I think a lot of people are like where do I start, what do I do to help start moving down this road of product growth? And what I'm hearing generally is just activation is probably where you want to focus, which is essentially getting people to your value quicker. And what's cool about that, and we had a podcast with Lauryn Isford from formerly Airtable, now at Notion, talking about all the ways to do that. And interestingly, one of the biggest levers for retention, and moving retention, is often onboarding and improving activation, so win-win.

**中文翻译:**
我希望这非常有帮助，因为很多人都在想“我该从哪里开始？我该做什么来启动 PLG 进程？”我听到的核心观点是：激活可能是你应该关注的重点，本质上就是让人们更快地体验到价值。酷的是，我们之前和 Lauryn Isford（曾任职于 Airtable，现任职于 Notion）录过一期播客，讨论了实现这一目标的所有方法。有趣的是，提升留存率最大的杠杆之一通常就是入职引导（Onboarding）和改进激活，所以这是双赢。

---

### [00:56:00] Hila Qu

**English:**
Yeah, definitely. And I could talk a little bit about retention expansion, if you think that's helpful as well?

**中文翻译:**
是的，绝对是。如果你觉得有帮助，我也可以聊聊留存和扩张（Expansion）。

---

### [00:56:00] Lenny

**English:**
Sure, let's do that here.

**中文翻译:**
当然，就在这儿聊吧。

---

### [00:56:08] Hila Qu

**English:**
Yeah, I know that I didn't talk about that in the post, and there are people asking, hey, do you plan to write another post on this specific topic? So the reason why I didn't cover too much retention expansion is, as you mentioned, it's not usually a first place to start. I call retention the messy middle. It's actually a messy part of the entire funnel. A quick activation, conversion, those are fast. Those are almost sometimes shorter time span, right? You have a lot of never, and you can test very quickly, and that acquisition is a very big leverage. You need to get more users, always.

**中文翻译:**
我知道我在文章里没怎么提这个，有人问我：“嘿，你打算专门写一篇关于这个话题的文章吗？”我之所以没过多涉及留存和扩张，是因为正如你所说，它通常不是起步的地方。我把留存称为“混乱的中间层”。它实际上是整个漏斗中最混乱的部分。快速激活、转化，这些都很快，时间跨度短，你可以快速测试。而获客是一个巨大的杠杆，你永远需要更多用户。

---

### [00:56:48] Hila Qu

**English:**
Retention is super important, but it's a little bit messy. It's over a very long period of time, and your customers can be, at any given moment, they can be retained or not, like if they just cancel or they just decided not to use anymore, you already lost them, so it's a very messy part. But how I think about retention, there are two steps. One is how to build a habit in their usage pattern, so that they are using this maybe every week, every day. The key to do that is, first of all, your product need to have a high enough frequency. If you are using this once per month, it's not likely you can build this into a habit.

**中文翻译:**
留存超级重要，但有点混乱。它跨越很长一段时间，你的客户在任何时刻都可能留存或不留存。比如他们取消了订阅，或者决定不再使用了，你就失去他们了。所以这部分很棘手。但我对留存的思考分为两步：第一步是如何在他们的使用模式中建立习惯，让他们每周甚至每天都使用。关键在于，首先你的产品需要有足够高的使用频率。如果你一个月才用一次，不太可能养成习惯。

---

### [00:57:39] Hila Qu

**English:**
Before GitLab, I worked at Acorns. We started as an investment app, and the whole thing is passive investment, passive investing. You bought some ETFs, and then you basically don't even need to check, and you just keep adding money and it will grow, and after 10 years is awesome. It's actually the right investment philosophy, but when I worked as a head of growth, it made a big challenge for me, because think about set and forget it. They don't even need to go back to a product to be successful. And that make it very hard, as a head of growth, to drive engagement, drive retention. I don't even know whether they're retained or not, if they are not coming back, right? I can only gauge from other indicators. So I think one thing I would say about building habit is think about how to build those habit feature or collaboration feature into your workflow already, into the product already. That is the reason they can retain, fundamentally, if it's high frequency, if it involves collaboration with other people, if it's part of their workflow. So that's the first step. You can obviously use a lot of the looks to reinforce that. You can send them an email if they take certain action, and get them back, and to repeat that action, but fundamentally you need to build that into your product.

**中文翻译:**
在加入 GitLab 之前，我在 Acorns 工作。我们最初是一个投资应用，核心是“被动投资”。你买了一些 ETF，然后基本上都不用看，只要持续投钱它就会增长，10 年后就很可观。这确实是正确的投资理念，但当我担任增长负责人时，这给我带来了巨大挑战。想想看，“设置好就不用管了”，他们甚至不需要回到产品中就能获得成功。这让作为增长负责人的我很难驱动参与度和留存。如果他们不回来，我甚至不知道他们是否还留存，对吧？我只能通过其他指标来衡量。所以关于建立习惯，我想说的是：思考如何将这些习惯性功能或协作功能融入到工作流和产品中。如果产品频率高、涉及与他人协作、是工作流的一部分，这才是他们留存的根本原因。这是第一步。你显然可以利用很多手段来强化这一点，比如在他们执行某些操作后发邮件引导他们回来重复该操作，但从根本上说，你需要将其构建到产品中。

---

### [00:59:09] Hila Qu

**English:**
And then the next part around retention is I actually think extension is part of retention. Basically you already have a steady usage flow. You are using this habitually every week, every day. What are the right moment to prompt you to think about maybe buying more? And there are three buckets of product-led extension. The first one is up upgrade to a higher tier. The second one is buying more seeds, buying more license. The third one is if you have some sort of a consumption add-on component, just consuming more, right? Like for GitLab, you can go from bronze tier to a silver tier, you can go to a higher tier, and then you can buy more seeds, and you can also buy more CSCD minutes to consume. Those are all the different moments. How you can do that is really understand data, understand usage, and trigger a lot of the right conversation at the right moment to the right person.

**中文翻译:**
留存的下一步，我实际上认为扩张（Extension）是留存的一部分。基本上你已经有了稳定的使用流，你每周、每天都在习惯性地使用。那么，什么时候是提示你考虑购买更多的正确时机？产品驱动扩张有三个桶：1. 升级到更高层级的方案。2. 购买更多席位或许可证。3. 如果你有某种消耗型插件，就是消耗更多。比如在 GitLab，你可以从铜牌升级到银牌，可以买更多席位，也可以买更多 CI/CD 分钟数。这些都是不同的时刻。实现这一点的关键是真正理解数据、理解使用情况，并在正确的时刻对正确的人触发正确的对话。

---

### [01:00:17] Hila Qu

**English:**
And you can, again, a lot of similar tactics you use in activation conversion actually can be beautifully applied in expansion, because it's almost a combination of getting people to the aha of that feature, use that feature, try that feature, getting them to convert.

**中文翻译:**
而且，你在激活和转化中使用的很多类似策略，其实可以完美地应用在扩张上。因为这几乎就是让人们达到该功能的顿悟时刻、使用该功能、尝试该功能，并最终促使他们转化的结合体。

---

### [01:00:34] Lenny

**English:**
You're leaving all these gold bricks that I have to resist not following and getting off track with, because there's so much, and like retention is its own conversation. We could have maybe just one question along those lines. What's something that you've launched that had a tremendous impact on retention? Is there an example of just like, wow, that really had a big impact, you talk about frequency maybe, but what comes to mind?

**中文翻译:**
你抛出了这么多“金砖”，我得克制住自己不去追随它们以免跑题，因为内容实在太多了。留存本身就是一个独立的话题。关于这一点我只问一个问题：你曾经发布过什么对留存产生巨大影响的东西吗？有没有那种“哇，影响真的很大”的例子？你提到了频率，还有什么想到的吗？

---

### [01:00:56] Hila Qu

**English:**
I can share some of my example at a course my-

**中文翻译:**
我可以分享一些我在 Acorns 的例子……

---

### [01:00:59] Lenny

**English:**
Yeah.

**中文翻译:**
好。

---

### [01:01:00] Hila Qu

**English:**
I think there are two things. One thing is actually very similar to what you just said. When I was asked to work on retention, I did a bunch of analysis. The biggest leverage for me is actually activation. So I ended up doing tons of experiments in activation. I identified what are the features for users to take experience value quickly so that they are more likely to retain. For us, it's a feature called recurring investment, which makes sense in hindsight, but at that time nobody's caring about that. We have some other very cool investment features called roundup investment, so nobody is really paying a lot of a attention on this, but when I look at data, I saw recurring investment has a high correlation with retention. So I did a lot of work trying to get more people to set this up, and which has been a great success, actually, in a very short period of time.

**中文翻译:**
我认为有两点。第一点其实和你刚才说的非常相似。当我被要求负责留存时，我做了一堆分析。我发现对我来说最大的杠杆其实是激活。所以我最终在激活方面做了大量的实验。我识别出了哪些功能能让用户快速体验到价值，从而更有可能留存。对我们来说，那个功能叫“定期投资”（Recurring Investment）。事后看来这理所当然，但当时没人关心这个。我们还有其他很酷的投资功能，比如“零钱投资”（Roundup Investment），所以大家没怎么关注定期投资。但当我观察数据时，我发现定期投资与留存有极高的相关性。于是我做了大量工作引导更多人设置这个功能，事实证明在很短时间内就取得了巨大成功。

---

### [01:01:58] Hila Qu

**English:**
And then from there, I would say we begin to add more use cases that has a higher frequency, like I mentioned, right? If you only come here once per month to check our investment, it's very hard to retain you. We don't have any lever to engagement with you as well, if you are not in the product. So we ended up adding IRA account, retirement account. We ended up adding spending account, like a debit card, like more high-frequency use cases. Those use cases come with higher frequency and better retention by nature, so now you change the problem from how do I improve retention to how do I drive adoption of higher-frequency use cases? So I did, again, a bunch of experiments how to drive more adoption of retirement account. Once you have a retirement account, an IRA, there's tax consequences, all of that. There it's very hard for you to leave. So you flip the question into, again, adoption/activation problem in that case as well.

**中文翻译:**
从那以后，我们开始增加更高频率的用例。正如我提到的，如果你一个月才来查一次投资，很难留住你。如果你不在产品里，我们也无法与你互动。所以我们增加了 IRA 账户（个人退休账户）。我们还增加了消费账户，比如借记卡，这些都是高频用例。这些用例天生具有更高的频率和更好的留存。所以现在你把问题从“我如何提高留存”变成了“我如何推动高频用例的采用”。于是我又做了一堆实验，研究如何推动退休账户的采用。一旦你有了退休账户，涉及税务后果等因素，你就很难离开了。所以在那这种情况下，你再次把问题转化为了采用/激活问题。

---

### [01:03:04] Lenny

**English:**
Amazing. Thank you for sharing those. Oh man, there's so many other things we could talk about retention, but we have enough to talk about on product-led growth. So there's two other areas that I want to touch on. One is data and infrastructure, and what people should know about how to set that up for success, and the other is hiring your team, and how to build out your product-led growth team. So starting with the data piece, maybe just as a big picture, just like what are the buckets of data and infrastructure people should be thinking about that they're going to have to invest in or should start thinking about early?

**中文翻译:**
太棒了，谢谢分享。关于留存还有太多可以聊的，但我们关于 PLG 的话题还没聊完。还有两个领域我想触及：一个是数据和基础设施，以及人们为了成功应该如何搭建它们；另一个是团队招聘，以及如何组建 PLG 团队。先从数据开始，从大局来看，人们应该考虑投资或早期思考哪些数据和基础设施桶？

---

### [01:03:36] Hila Qu

**English:**
I think there are two big buckets. The first bucket is product usage data. As I mentioned, a lot of B2B software, they're really lacking in that, because when you sell via sales team, you don't need to know so many details, so granular usage data, all of that. The second bucket is I call this customer 360 database, because product usage data is one component, is the most essential. In order for your product-led gross motion to be successful, you also need to connect that with your marketing teams, marketing campaigns, your CRM, your sales force, who are the customers, prospects, what their stage. So those ideally need to be connected so that you have a 360 picture of your customer. If I have an Airbnb as a potential, like a target account, do I know there are users from Airbnb that are using my product, which features are they using, and do I send any marketing campaigns to each of them, do they respond, all of that. All of those ideally need to be connected, but in reality is all over the place. It's all in its own tools in most of the B2B companies.

**中文翻译:**
我认为有两个大桶。第一个是产品使用数据。正如我提到的，很多 B2B 软件非常缺乏这个，因为当你通过销售团队销售时，你不需要知道那么多细节和颗粒度极细的使用数据。第二个桶我称之为“客户 360 数据库”。产品使用数据只是其中一个组件，虽然是最核心的。为了让 PLG 模式成功，你还需要将其与营销团队、营销活动、CRM、Salesforce 连接起来，了解谁是客户、谁是潜在客户、他们处于什么阶段。理想情况下，这些需要连接起来，让你对客户有一个 360 度的全景认识。如果我把 Airbnb 作为潜在目标账户，我是否知道 Airbnb 有哪些用户在使用我的产品？他们用哪些功能？我是否给他们每个人发了营销邮件？他们回应了吗？理想情况下这些都该连通，但现实中它们往往散落在各处，在大多数 B2B 公司里，它们都存在于各自独立的工具中。

---

### [01:04:57] Lenny

**English:**
What are just some tools that you think people should check out, start with maybe? What's Hila's recommendations on an initial stack or areas to explore, in terms of tooling?

**中文翻译:**
你认为人们应该关注或从哪些工具开始？关于初始工具栈或值得探索的领域，Hila 有什么建议？

---

### [01:05:08] Hila Qu

**English:**
I say there are two piece. One is infra, the other piece are some tools that are kind of secondary. So from infrastructure perspective, on data tool, my first tool usually, one is some sort of data hub segment, right? This next one is some sort of a product analytics tool. Think about Amplitude. I know PostHog is actually a pretty popular one. It's an open-source product analytics tool. There are Mixpanel, Pandle, all of that. So have some sort of data hub, data collection tool, and have some sort of product analytics tool. That's the data infrastructure.

**中文翻译:**
我说有两部分。一部分是基础设施（Infra），另一部分是次要工具。从基础设施的角度看，在数据工具方面，我的首选通常是像 Segment 这样的数据枢纽（Data Hub）。接下来是某种产品分析工具，比如 Amplitude。我知道 PostHog 现在也很流行，它是一个开源的产品分析工具。还有 Mixpanel、Pendo 等等。所以要有一个数据枢纽、数据采集工具，以及一个产品分析工具。这就是数据基础设施。

---

### [01:05:49] Hila Qu

**English:**
And then you need to have an experimentation tool because, like I said, you cannot just imagine you build everything and everything works perfectly. So you need either like Optimizely, I know Amplitude has some experimentation components. Eppo is a new and upcoming one. You need some tool to allow you to do experimentation. The third piece I think that's pretty essential, I counted in the infra, is some sort of a lifecycle marketing tool. I know many B2B companies, they use HubSpot or they use something for their email marketing, but those are usually least nurturing. And it's very different from lifecycle marketing tool, meaning you need to connect with Segment, Amplitude. You know what customers are doing your product, your design, your email, your in-app, your push notification, based on their behavior, at the right moment, to the right person. And you measure success by do they take the right action in a product, versus the lead nurture email marketing tool is do I get them to read the article, open the email, I add 10 points to their lead score, and they are a next step further in their list funnel? So, data tool, experimentation tool, lifecycle marketing tool, those are the infra.

**中文翻译:**
然后你需要一个实验工具，因为正如我所说，你不能指望建好一切就能完美运行。所以你需要像 Optimizely 这样的工具，我知道 Amplitude 也有实验组件，Eppo 是一个新兴的工具。你需要工具来支持你做实验。第三部分我认为非常重要，我也把它归入基础设施，就是某种生命周期营销工具。我知道很多 B2B 公司使用 HubSpot 或类似的工具做邮件营销，但那些通常是“线索培育”（Lead Nurturing）。这与生命周期营销工具非常不同，后者意味着你需要与 Segment、Amplitude 连接。你了解客户在产品里的行为，并基于此在正确的时刻、对正确的人设计邮件、应用内通知、推送通知。你衡量成功的标准是他们是否在产品中执行了正确的动作，而线索培育工具衡量的是：我是否让他们读了文章、开了邮件？如果是，我就给他们的线索分加 10 分，让他们在销售漏斗中更进一步。所以，数据工具、实验工具、生命周期营销工具，这些是基础设施。

---

### [01:07:10] Hila Qu

**English:**
And then from there, there are a lot of PLD tools you can add on top to make your day-to-day much easier. Just to start, as so like that are most essential for acquisition, you need to have some sort of a like a data enrichment tool. Think about ZoomInfo, Clearbit, because the biggest difference between B2B and B2C is that you still need to know about their company. You want to know this person, but you also want to know this person's company, right? That's a very important thing, and you can get a lot out of those data enrichment tool, and then you can design your journey differently based on that.

**中文翻译:**
在此基础上，你还可以添加很多 PLG 工具来简化日常工作。首先，对于获客最核心的工具是某种数据增强（Data Enrichment）工具，比如 ZoomInfo、Clearbit。因为 B2B 和 B2C 最大的区别在于你仍然需要了解他们的公司。你想了解这个人，但也想了解这个人的公司，对吧？这是非常重要的一点，你可以从这些数据增强工具中获得很多信息，然后据此设计不同的用户旅程。

---

### [01:07:52] Hila Qu

**English:**
For activation, a lot of my clients are finding a lot of value in those tools like Appcues, User-Led, basically the tools that allow you to build onboarding flow quickly in a product without engineer kind of resource. So you need to do some initial integration, but as soon as you did that a marketing manager, a PM or someone, can just build some customized onboarding step-by-step flows himself. I think that's quite neat, because you need to test the tongue in that area. And in terms of conversion, I would say there are many product-led growth, product-led sales tools. I think those are great. If you want to build out your PQL/PQA conversion pass, think about Endgame, Pocus, Tableau and Pace. There are a couple of them.

**中文翻译:**
对于激活，我的很多客户发现 Appcues、User-Led 等工具非常有价值。基本上这些工具允许你在没有工程师资源的情况下，在产品中快速构建入职引导流程。你只需要做一些初始集成，之后营销经理、产品经理或任何人都可以自己构建定制化的分步引导流程。我觉得这很棒，因为你在那个领域需要做大量的测试。至于转化，我会说有很多 PLG 或产品驱动销售工具。如果你想构建 PQL/PQA 转化路径，可以考虑 Endgame、Pocus、Tableau 和 Pace。这类工具有不少。

---

### [01:08:47] Lenny

**English:**
Wow. Amazing. That was an awesome list and really well-structured. Is there anything else along the data or infrastructure piece that you want to touch on before we move on to hiring and the team?

**中文翻译:**
哇，太棒了。这个清单非常出色，结构也很清晰。在进入招聘和团队话题之前，关于数据或基础设施，还有什么想补充的吗？

---

### [01:08:59] Hila Qu

**English:**
I just want to go back to the point, as I mentioned, product-led growth is data-led growth deep down. So in most of the situation when I see a company want to get started, where they are really missing or they need to invest more, is data. So if you identify you have a gap in this area, don't feel bad as well. A lot of pretty big companies are in the same shoes, and if you can't invest the time, money, the team, the tool, to figure this out, the benefit of this, right, the data collection, understanding usage data, can not only power your PLG motion, it can really power your entire product team, even your customer success team. Now you gave them the ingredients they need to develop the next feature, based on not only what your top customer asked for, but also what everybody's using, right?

**中文翻译:**
我只想回到我提到的那一点：PLG 骨子里其实是数据驱动增长。所以在大多数情况下，当我看到一家公司想要起步时，他们真正缺失或需要加大投入的地方就是数据。所以如果你发现自己在这方面有差距，也不要难过。很多大公司也面临同样的问题。如果你能投入时间、金钱、团队和工具来解决这个问题，其好处——即数据采集和对使用数据的理解——不仅能驱动你的 PLG 模式，还能驱动你的整个产品团队，甚至客户成功团队。现在你给了他们开发下一个功能所需的“原料”，这些原料不仅基于大客户的要求，还基于所有人的实际使用情况，对吧？

---

### [01:09:59] Hila Qu

**English:**
Your customer success team can take a much deeper view in understanding what the clients are using, rather than just talk with the executives from the client and get a rough gauge of the situation. So I think it is a area worth investing, and every B2B company should be investing in.

**中文翻译:**
你的客户成功团队可以更深入地了解客户在使用什么，而不是仅仅通过与客户的高管交谈来粗略评估情况。所以我认为这是一个值得投资的领域，每家 B2B 公司都应该投资。

---

### [01:10:21] Lenny

**English:**
I'm trying to channel what listeners might be thinking right now, and I imagine some people might be like what if I pick the wrong tool? I'm kind of stressed, I have to do all this research. I'm kind of worried about starting, because it'll set me up for failure later. Which of these buckets do you think is most important to get right, right from the beginning, and any advice on how to just avoid messing that up?

**中文翻译:**
我试着站在听众的角度想一下，我猜有些人可能会想：“如果我选错了工具怎么办？”我很焦虑，得做这么多调研。我很担心起步，怕以后会失败。你认为这些“桶”中哪一个是最需要从一开始就做对的？有没有什么建议可以避免搞砸？

---

### [01:10:41] Hila Qu

**English:**
To get started, I would say probably a product analytics tool is the first step, and maybe the data hub, such as Segment. So if you have Segment and particle tools like that, it allows you to plug into so many different tools. You can basically try all the different tools, and if it doesn't work, you just flip a switch, you can try another tool. So there is a benefit there, but it is expensive, so I know companies may just go right into the product analytics tool. I would say it's hard to get it wrong completely, right?

**中文翻译:**
起步的话，我会说产品分析工具可能是第一步，也许还有像 Segment 这样的数据枢纽。如果你有了 Segment 这种工具，它可以让你接入很多不同的工具。你基本上可以尝试所有不同的工具，如果不行，关掉开关换一个就行。这是它的好处，但它很贵，所以我知道有些公司会直接买产品分析工具。我想说，很难完全搞错，对吧？

---

### [01:11:19] Hila Qu

**English:**
In order for a product analytics tool to be meaningful, the first step is you need to collect the data, you need to do some instrumentation, you need to have the foundation. And then, because it's garbage in, garbage out, if you send a bunch of garbage data into your product analytics tool, your analyst will be just even more confusing, right? It's like he doesn't know whether to trust the data, what to use. So a lot of company I work with, the first step is maybe not looking into tool, but do an audit of your data instrumentation situation, to understand how many of the key actions are intact, is the format correct, is the data, what are the gaps? And you may need to do some re-instrumenta ...

**中文翻译:**
为了让产品分析工具有意义，第一步是你需要采集数据，需要做埋点（Instrumentation），需要有基础。因为“垃圾进，垃圾出”，如果你把一堆垃圾数据发给产品分析工具，你的分析师只会更困惑。他不知道该不该相信数据，该用什么。所以我合作的很多公司，第一步可能不是看工具，而是审计数据埋点情况，了解有多少关键动作被记录了，格式对不对，数据怎么样，缺口在哪里？你可能需要重新埋点……

---

### [01:12:00] Hila Qu

**English:**
Right, what are the gaps? And you may need to do some reinstrumentation, reformatting and things like that before you even plug into a product analytics to make it useful.

**中文翻译:**
没错，缺口在哪里？在接入产品分析工具使其发挥作用之前，你可能需要重新埋点、重新格式化等等。

---

### [01:12:10] Lenny

**English:**
For someone that may want to do that audit, is there a thing you would point them to, or, I don't know, a blog, a course, something to help them understand if they're doing it right? Or is it like, "Bring Hila on," and you need someone like you to kind of help them through it?

**中文翻译:**
对于想做这种审计的人，你有什么推荐的资源吗？比如博客、课程，或者能帮他们判断自己做得对不对的东西？还是说必须得“请 Hila 出山”，需要像你这样的人来帮忙？

---

### [01:12:24] Hila Qu

**English:**
No, you can bring me, but you don't have to bring me. I think there are, if you search on Google just the data dictionary, or data product usage, data audit, a lot of companies published template and spreadsheet you can use. I can even send you a few afterwards.

**中文翻译:**
不，你可以请我，但不必非得请我。我想如果你在 Google 上搜索“数据字典”（Data Dictionary）或“数据产品使用审计”，很多公司都发布了可以使用的模板和表格。我事后甚至可以发给你几个。

---

### [01:12:43] Lenny

**English:**
That'd be amazing.

**中文翻译:**
那太好了。

---

### [01:12:44] Hila Qu

**English:**
And then you can just scroll through. Basically the key idea is go through your product experience, identify the key actions, and go through your data instrumentation and see, "Do they match?" And the success of this is you identify the gaps and eventually you want to establish something called the data dictionary. I basically do that for a lot of my clients. And the data dictionary will include, here are all the key actions, what's the event name for each of those, and what are the property and things like that.

**中文翻译:**
然后你就可以浏览一下。核心思路是：走一遍你的产品体验，识别关键动作，然后查看你的数据埋点，看它们是否匹配。成功的标志是你识别出了缺口，并最终建立起所谓的“数据字典”。我经常为客户做这个。数据字典会包含：所有关键动作是什么，每个动作对应的事件名称是什么，属性是什么等等。

---

### [01:13:17] Hila Qu

**English:**
But you now know, "Hey, I have this action track, this is the name. If I have a new product manager or analyst, we can all refer to this." And everyone know the same definition rather than people are interpreting differently. So that's a very important part to success even before the tooling.

**中文翻译:**
这样你就知道了：“嘿，我有这个动作追踪，名字叫这个。如果我有新的产品经理或分析师，我们都可以参考这个。”每个人都知道同一个定义，而不是各说各的。所以这是在工具之前，通往成功的非常重要的一步。

---

### [01:13:39] Lenny

**English:**
It also reminds me a previous guest, Crystal Widjaja, has a awesome post on why most analytics efforts fail. And she talks a lot about this, of how to set your events up for success. So we'll link to that as well.

**中文翻译:**
这也让我想起之前的嘉宾 Crystal Widjaja 写过一篇很棒的文章，关于为什么大多数分析工作都会失败。她详细讨论了如何成功设置事件。我们也会把那个链接放上去。

---

### [01:13:50] Hila Qu

**English:**
Mm-hm.

**中文翻译:**
嗯。

---

### [01:13:51] Lenny

**English:**
Maybe one last thing here, I'm trying to think about what would screw people up most, and it's probably not having a data warehouse and ETL sorts of tooling in place, because that feeds a lot of this.

**中文翻译:**
关于这一点最后再说一件事，我在想什么最容易搞砸，可能就是没有建立数据仓库和 ETL 之类的工具，因为这些是很多分析的基础。

---

### [01:13:51] Hila Qu

**English:**
Yep.

**中文翻译:**
是的。

---

### [01:14:01] Lenny

**English:**
Is there anything you want to add there about just the importance of a data warehouse and how to set that up?

**中文翻译:**
关于数据仓库的重要性以及如何搭建，你还有什么想补充的吗？

---

### [01:14:06] Hila Qu

**English:**
Some of the early stage companies I work with, when they just get started in the very beginning, they don't have data warehouse. They just basically have their product and they have some sort of a Google Analytics or Amplitude, and that's it. It's pretty wild, but it's working and they can get to someplace from there. But as soon as you begin to have data user, it's time to get serious to establish a data warehouse, have some ETL solution. I think there are the most common best practice ones, like AWS and things like that. There are also some startups that are doing this and you can utilize as well. But again, as soon as you become a serious business, you should invest in that. Otherwise, it's pretty wild and it's pretty fragile as well.

**中文翻译:**
我合作过的一些早期公司，刚起步时并没有数据仓库。他们基本上只有产品，加上 Google Analytics 或 Amplitude，仅此而已。这听起来很狂野，但确实有效，他们也能据此取得一些进展。但一旦你开始有了数据用户，就该认真考虑建立数据仓库和 ETL 方案了。我认为最常见的最佳实践是 AWS 之类的。也有一些初创公司在做这个，你也可以利用。但重申一遍，一旦你成为一家正经公司，就应该投资这个。否则，数据管理会非常混乱且脆弱。

---

### [01:14:59] Lenny

**English:**
And when you say AWS, you mean at Redshift, I imagine?

**中文翻译:**
你说的 AWS，我猜是指 Redshift？

---

### [01:15:01] Hila Qu

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:15:02] Lenny

**English:**
Cool. Awesome. Okay, final area that we have time for, which is awesome, which is around building your team. So maybe just two questions here. What is your advice for starting the initial team investing in PLG? How does that usually look and what do you think people should do? And then later, how does that evolve over time?

**中文翻译:**
酷，太棒了。好了，我们还有时间聊最后一个领域，就是团队建设。这里有两个问题：你对投资 PLG 的初始团队组建有什么建议？通常是什么样的？你认为人们该怎么做？以及之后它如何随时间演变？

---

### [01:15:21] Hila Qu

**English:**
How I see most companies started is the founder or the leadership team realize that they need to do PLG. And they build a conviction. Maybe initially there isn't even a dedicated team, but they did something here and there, they decided to invest in this. And the common place to start is to hire a head of growth, or it can be a lead growth PM, but someone who has a little bit of experience in this area. And then they begin to build this core growth squad as the first growth team. And I think that's a very common place to start.

**中文翻译:**
我看到的大多数公司起步的方式是：创始人或领导团队意识到他们需要做 PLG，并建立了信心。最初可能甚至没有专门的团队，但他们东做一点西做一点，决定投资。通常的起点是雇佣一名增长负责人（Head of Growth），或者是一名资深增长产品经理（Lead Growth PM），总之是该领域有一定经验的人。然后他们开始组建核心增长小组（Growth Squad）作为第一支增长团队。我认为这是一个非常普遍的起点。

---

### [01:16:01] Hila Qu

**English:**
The other place to start that's less common, but I also think it happening in reality, is maybe they will start a cross-functional, almost like a tiger team. Because if the initial focus area is, let's say, they want to do a product qualified lead, or basically add that funnel. That involves not only product team, that will involve data team because you want to know what are the usage pattern that indicate these is better leads. You also need to bring sales team in because they need to work on those leads to close them.

**中文翻译:**
另一种不太常见但在现实中确实存在的起点是：组建一个跨职能的、类似于“攻坚小组”（Tiger Team）的团队。因为如果初始重点领域是，比方说，做产品合格线索（PQL）或者增加那个漏斗，这不仅涉及产品团队，还涉及数据团队（因为你想知道哪些使用模式预示着更优质的线索），你还需要把销售团队拉进来，因为他们需要跟进这些线索并成交。

---

### [01:16:39] Hila Qu

**English:**
So if that's the initial starting area, a cross-functional tiger team is also possible option. But the most common way is hire a head of growth, usually a growth PM, and then start a team with engineering, design, data to support that core growth squad.

**中文翻译:**
所以如果那是初始切入点，跨职能攻坚小组也是一个可选方案。但最常见的方式还是雇佣增长负责人（通常是增长 PM），然后组建一个包含工程、设计、数据的团队来支持那个核心增长小组。

---

### [01:17:00] Lenny

**English:**
And the main difference between these two. One is dedicated, "We are going to dedicate full-time people to helping us grow." Like I say we talked about earlier, let's say they're going to focus on activation and that's their whole job. Versus tiger team is basically they're borrowing resources from other teams and this is kind of a side project for them.

**中文翻译:**
这两者的主要区别在于：一个是专门的，“我们要投入全职人员来帮助增长”。就像我们之前聊的，假设他们专注于激活，那是他们的全部工作。而攻坚小组基本上是从其他团队借调资源，对他们来说这更像是一个侧面项目。

---

### [01:17:18] Hila Qu

**English:**
Yeah. A little bit, for a period of time. So it's temporary. It's kind of they almost to want to get into... I would say usually the cross-functional team, the tiger team, is a little bit prior to a full commitment. They're pretty much committed, but they still want to try this out and get a final conviction, and then they begin to dedicate resources. And you ask about how do they evolve from there.

**中文翻译:**
是的，在一段时间内是这样，所以它是临时性的。他们有点像是想进入……我会说通常跨职能攻坚小组出现在全面投入之前。他们基本决定要做了，但还想试一试以获得最终信心，然后再开始投入专门资源。你刚才问到之后如何演变。

---

### [01:17:46] Lenny

**English:**
Before we actually get there, maybe one more quick question. Which would you recommend? I imagine you'd recommend a dedicated team, if you can do that. When would it make sense to go the tiger team route? In what cases?

**中文翻译:**
在聊演变之前，再快问一个问题：你推荐哪种？我猜如果你能做到，你会推荐专门的团队。那么在什么情况下走攻坚小组路线是有意义的？

---

### [01:17:59] Hila Qu

**English:**
One situation I would recommend is that if the initial focus area is, like I said, product qualified leads, the sales conversion path. Because if you think about you have a head of growth or a core growth PM, that person usually has a growth PM background and is in the product organization. And they're awesome if the initial focus areas are activation, conversion, those kind of involve a lot of experimentation. But activation and conversion are relatively confined, it's something the growth PM and engineer design data, they can work on.

**中文翻译:**
我推荐的一种情况是，如果初始重点领域正如我所说，是产品合格线索（PQL），即销售转化路径。因为如果你有一个增长负责人或核心增长 PM，那个人通常有增长 PM 背景，隶属于产品组织。如果初始重点是激活、转化，他们会非常出色，因为这些涉及大量实验。而且激活和转化相对独立，是增长 PM、工程师、设计师和数据人员可以搞定的。

---

### [01:18:39] Hila Qu

**English:**
If your initial focus area you felt like, "My biggest bit is actually do this PQL thing," it is a little bit harder for the growth PM to socialize all those cross-functional resources, because he need to get pretty deep into data. He need to have a counterpart in sales, even in marketing. So in that case, I think it's possible that maybe you start a tiger team. You can combine both. You can have a growth PM dedicated, but have some tiger team to be working with him or her on this PQL project as well.

**中文翻译:**
但如果你觉得初始重点是“我最大的赌注其实是做 PQL”，那么增长 PM 协调所有这些跨职能资源就会难一些，因为他需要深入研究数据，他需要在销售甚至营销部门有对接人。在这种情况下，我认为启动一个攻坚小组是可行的。你也可以两者结合：有一个专门的增长 PM，但同时有一个攻坚小组配合他/她完成这个 PQL 项目。

---

### [01:19:14] Lenny

**English:**
Got it. And I like this term tiger team, by the way. I haven't heard that before. It sounds like a lot of fun. Very dynamic. Okay, cool. And then yeah, what happens next after you have this initial team?

**中文翻译:**
明白了。顺便说一下，我很喜欢“攻坚小组”（Tiger Team）这个词，以前没听过，听起来很有趣，很有活力。好，酷。那么在有了初始团队之后，接下来会发生什么？

---

### [01:19:24] Hila Qu

**English:**
Once you have this initial team, it's important to give them the resources they need, and give them an initial focus area, give them support and a little bit time, allow them to try things out and get some early wins. And early win is the biggest thing I would say for, and whenever you start a new growth team, try to look for some opportunity, try to get some early wins in whichever focus area you choose.

**中文翻译:**
一旦有了初始团队，重要的是给他们所需的资源，给他们一个初始重点领域，给他们支持和一点时间，允许他们尝试并获得一些“早期胜利”。我想说，无论何时组建新的增长团队，早期胜利都是最重要的。要在你选择的任何重点领域寻找机会，争取获得早期胜利。

---

### [01:19:53] Hila Qu

**English:**
From there, if you get some of the wins, the team has some momentum, there are more confidence from the organization in PLG, right? It's time to potentially extend and formalize. Fundamentally I think you should not only think about the PLG team, you should think about the PLG org. Because PLG is a motion, it's cross-functional by nature, it's not just a product team or growth team.

**中文翻译:**
从那以后，如果你获得了一些胜利，团队就有了动力，组织对 PLG 也会更有信心，对吧？这时就可以考虑扩张和正式化了。从根本上说，我认为你不应该只考虑 PLG 团队，而应该考虑 PLG 组织。因为 PLG 是一种模式，它天生是跨职能的，不仅仅是一个产品团队或增长团队。

---

### [01:20:24] Hila Qu

**English:**
Eventually you need to get to the place basically there is a head of growth product, that's the center of the PLG org. But there's also need to be a head of growth marketing, that's his or her counterpart in marketing organization. And then a head of product led sales, that's the counterpart in the sales organization. Exactly where they sit, how they sit, it's different company by company. The most common one is head of growth product report to product org, head of growth marketing report to marketing, head of product led sales report to sales. But they have some sort of a very strong collaboration, because they are working in the same motion and same funnel. But I think that's next step, think about this org.

**中文翻译:**
最终你需要达到这样一个状态：有一个增长产品负责人，他是 PLG 组织的核心。但同时也需要一个增长营销负责人，作为他在营销组织的对接人。然后还需要一个产品驱动销售负责人，作为他在销售组织的对接人。他们具体坐在哪、怎么汇报，每家公司都不一样。最常见的是增长产品负责人向产品部门汇报，增长营销负责人向营销部门汇报，产品驱动销售负责人向销售部门汇报。但他们之间有非常紧密的协作，因为他们在同一个模式和同一个漏斗中工作。我认为下一步就是思考这个组织架构。

---

### [01:21:11] Hila Qu

**English:**
Once you have those counterparts in product, in sales, in marketing, the next step is think about what are the metrics they own to make sure you can manage this funnel, this motion, in the data-driven way. Because the PLG metrics are very different from SLG. The top of funnel is more about high quality signups. You don't want a lot of traffic, you want free signup, free trials. But it need to meet certain quality bar, it's not just anyone.

**中文翻译:**
一旦你在产品、销售和营销部门有了这些对接人，下一步就是思考他们各自负责的指标，以确保你能以数据驱动的方式管理这个漏斗和模式。因为 PLG 指标与 SLG 非常不同。漏斗顶部更多关注高质量的注册。你不需要海量流量，你需要的是免费注册和免费试用，而且必须满足一定的质量标准，不能随便什么人都行。

---

### [01:21:46] Hila Qu

**English:**
And then the head of growth product, he or her top KPI is about usage, activation. Activated teams is a very common metric. And then maybe number of PQLs, that's another. You want to get those teams to certain usage threshold basically. And then the head of product led sales, he will be focused on converting those PQLs into revenue. So he will focus a lot on conversion rate, efficiency and maybe revenue, things like that.

**中文翻译:**
然后增长产品负责人，他/她的核心 KPI 是关于使用和激活。“激活团队数”是一个非常常见的指标。然后可能是 PQL 的数量。基本上你想让这些团队达到一定的活跃阈值。而产品驱动销售负责人则专注于将这些 PQL 转化为收入。所以他会非常关注转化率、效率以及收入等指标。

---

### [01:22:23] Lenny

**English:**
Got it. And you're sharing a lot of org design verbally in the post, which we'll share obviously in the show notes. You can actually see a diagram of what these look like, to help kind of make it super clear. I have maybe just one more question. Going back to the initial team, what are the functions you recommend they have on this like MVP PLG team?

**中文翻译:**
明白了。你在文章里分享了很多关于组织设计的细节，我们显然会在节目笔记里分享。大家可以看到这些架构的图表，非常清晰。我可能还有一个问题：回到初始团队，你建议这个“最小可行性”（MVP）PLG 团队应该具备哪些职能？

---

### [01:22:45] Hila Qu

**English:**
The most important one is have a growth PM to be the lead, right? Head of growth, director of growth, lead growth PM. And then the growth PM, as you know probably very well, growth PM, he is a PM but has a much stronger skill set in analytics, experimentation, very data-driven. Think about metrics. The growth PM's way of working is similar to other product manager, but his KPIs is actually more similar to the sales and marketing work. He's very focused on the conversion rate, the journey, the funnel versus the feature specifically itself.

**中文翻译:**
最重要的是有一个增长 PM 来领头，对吧？增长负责人、增长总监或资深增长 PM。正如你可能非常清楚的，增长 PM 虽然是 PM，但在分析、实验方面有更强的技能，非常数据驱动，关注指标。增长 PM 的工作方式与其他产品经理相似，但他的 KPI 实际上更接近销售和营销工作。他非常关注转化率、用户旅程和漏斗，而不是具体功能本身。

---

### [01:23:23] Hila Qu

**English:**
And then the other functions you need to have for sure, I would often say actually a data analyst needs to be the very first hire. Sometimes even try to find a growth PM who can do analysis if you're really small, you can find that type of unicorn person. Or even before hiring growth PM, hiring analyst, I would actually go as far as that. Because without insight, without a lot of foundation, your experimentation, your effort is really directionless in a sense. So growth PM, analyst. And from there definitely you need some dedicated engineer, you need a designer. Designer can be somewhat not dedicated in early days, but engineer needs to be. Some sort of user research support as well, it doesn't need to be dedicated. But those are the core growth squad.

**中文翻译:**
然后你肯定还需要其他职能。我经常说，数据分析师实际上应该是第一个雇佣的人。如果你规模很小，甚至可以试着找一个能做分析的增长 PM，找那种“独角兽”型人才。我甚至会说，在雇佣增长 PM 之前先雇佣分析师。因为没有洞察，没有基础，你的实验和努力在某种意义上是盲目的。所以：增长 PM、分析师。此外，你肯定需要专门的工程师，还需要设计师。设计师在早期可以不是专门的，但工程师必须是。还需要某种用户研究支持，也不必是专门的。这些就是核心增长小组。

---

### [01:24:18] Lenny

**English:**
Okay. Real actual last question here for the growth PM. In your experience, are they most often coming from within the company already and they kind of shift to this role? Or do you recommend they find someone externally?

**中文翻译:**
好。关于增长 PM 的最后一个真正的问题：根据你的经验，他们通常是来自公司内部转岗，还是你建议从外部招聘？

---

### [01:24:30] Hila Qu

**English:**
That's an excellent question. I have seen both. I actually recommend if you can find someone internally, maybe he's a PM, he want to do growth. Or he is an analyst who want to become more like a product role. I even have a one client, the head of growth I work with used to be a investor relationship, like head of investor relationship. And he reports to the CEO and founder. He's very analytical. He hasn't been a PM before, but he can socialize the resource within the company to launch experiments in product, in marketing, in all of that. And I, as an advisor, will come in, guide him in the area he's not familiar with. And we actually drive pretty good results together.

**中文翻译:**
这是一个非常好的问题。我两种情况都见过。我其实建议如果你能在内部找到人，比如他是个想做增长的 PM，或者是个想转产品岗的分析师。我甚至有一个客户，和我合作的增长负责人以前是做投资者关系（IR）的。他向 CEO 和创始人汇报，非常有分析头脑。他以前没做过 PM，但他能调动公司内部资源，在产品、营销等各个环节开展实验。我作为顾问介入，在他不熟悉的领域指导他。我们实际上共同取得了非常好的成果。

---

### [01:25:20] Hila Qu

**English:**
So I think prefer hiring internally if possible. If not, if you really don't have anyone internally with that knowledge or with that interest, you can look outside. I would say map the initial growth PM hire to your starting point. If we already decided activation is the biggest focus area, try to find some growth PM with that experience. And if the conversion is a focus area, acquisition is the focus area, try to find someone with that experience.

**中文翻译:**
所以我觉得如果可能的话，优先内部招聘。如果不行，如果你内部确实没有人具备相关知识或兴趣，再看外部。我想说，要把初始增长 PM 的招聘与你的切入点匹配起来。如果我们已经决定激活是最大的重点领域，就试着找一个有这方面经验的增长 PM。如果重点是转化或获客，就找有相应经验的人。

---

### [01:25:54] Lenny

**English:**
I love that advice. We've reached our very exciting lightning round. I've got actually seven questions for you, the most ever we've had for a lightning round. Are you ready?

**中文翻译:**
我喜欢这个建议。我们进入了非常令人兴奋的闪电问答环节。我实际上为你准备了七个问题，这是我们闪电问答历史上最多的一次。准备好了吗？

---

### [01:26:04] Hila Qu

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [01:26:06] Lenny

**English:**
Okay. What are two or three books that you've recommended most to other people?

**中文翻译:**
好。你向别人推荐最多的两三本书是什么？

---

### [01:26:10] Hila Qu

**English:**
This first one is called The Almanack Of Naval. Yeah, I don't know whether we read that one. I really love that one. That's kind of a life-changing book for me. I have it-

**中文翻译:**
第一本叫《纳瓦尔宝典》（The Almanack of Naval Ravikant）。不知道你读过没，我非常喜欢。对我来说，这是一本改变人生的书。

---

### [01:26:22] Lenny

**English:**
Do you have a favorite Naval-ism that comes to mind?

**中文翻译:**
你脑子里有没有最喜欢的“纳瓦尔语录”？

---

### [01:26:26] Hila Qu

**English:**
I learned finding leverage from him. He talked about there are four type of leverage. It can be your writing, it can be code, it can be capital, it can be team. So the reason why I invest a lot in writing is I felt like that's my leverage. And I love that. The second book is called How Women Rise. I really love this one. I gifted this to a lot of my female team member and I really learned a lot from them. And the third one is my book, it's called [Chinese 01:27:01]. It's only in Chinese, if you don't read Chinese you cannot read it. But I heard, my friends told me, if you are launching an email campaign, if you're doing experiments, have this book by the side, it will help with conversion rate just by its appearance.

**中文翻译:**
我从他那里学到了寻找杠杆。他谈到有四种杠杆：写作、代码、资本和团队。我之所以在写作上投入很多，是因为我觉得那是我的杠杆。我非常喜欢这一点。第二本书叫《女性如何崛起》（How Women Rise）。我非常喜欢这本，我把它送给了很多女性团队成员，我也从她们身上学到了很多。第三本是我自己的书，叫《硅谷增长黑客实战笔记》。只有中文版，如果你不识中文就读不了。但我听朋友说，如果你正在开展邮件营销或做实验，把这本书放在手边，光靠它的“颜值”就能帮提高转化率。

---

### [01:27:18] Lenny

**English:**
That's amazing. Is there an English translation or is it only in Chinese right now?

**中文翻译:**
太神奇了。有英文译本吗，还是目前只有中文？

---

### [01:27:22] Hila Qu

**English:**
It's only in Chinese, so you have to learn.

**中文翻译:**
只有中文，所以你得学中文。

---

### [01:27:25] Lenny

**English:**
All right, I see. All right. There's an advantage there, if you can speak Chinese your email conversion will go up.

**中文翻译:**
好吧，我明白了。这倒是个优势，如果你会说中文，邮件转化率就会提高。

---

### [01:27:29] Hila Qu

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:27:30] Lenny

**English:**
And then just to the first book, it was called The Almanack Of Naval, right?

**中文翻译:**
刚才第一本书叫《纳瓦尔宝典》，对吧？

---

### [01:27:34] Hila Qu

**English:**
Okay.

**中文翻译:**
对。

---

### [01:27:35] Lenny

**English:**
Is that right?

**中文翻译:**
没错吧？

---

### [01:27:35] Hila Qu

**English:**
Yes, yes.

**中文翻译:**
是的，是的。

---

### [01:27:36] Lenny

**English:**
Okay, cool. Sweet. And we'll link to all these. Okay, favorite recent movie or TV show?

**中文翻译:**
好，酷。我们会链接到所有这些。好，最近最喜欢的电影或电视剧？

---

### [01:27:41] Hila Qu

**English:**
I watched a movie, it's a sci-fi movie from China, it's called The Wandering Earth 2. It's by the famous author, Cixin Liu. He's the author of Three Bodies. I don't know whether you heard of it?

**中文翻译:**
我看了一部电影，是中国的科幻电影，叫《流浪地球 2》。它是著名作家刘慈欣的作品，他也是《三体》的作者。不知道你听过没？

---

### [01:27:53] Lenny

**English:**
Mm-hm. Oh my God, love that.

**中文翻译:**
嗯，天呐，我超爱那个。

---

### [01:27:54] Hila Qu

**English:**
That movie is awesome. It's kind of really cool. I really highly recommend it.

**中文翻译:**
那部电影太棒了，非常酷。我强烈推荐。

---

### [01:28:00] Lenny

**English:**
I have to go check that out. Oh my God. I heard they're bringing Three Body Problem to Apple TV or Netflix. There's like a show coming.

**中文翻译:**
我一定要去看看。天呐，我听说他们要把《三体》搬上 Apple TV 或 Netflix，好像要出剧集了。

---

### [01:28:06] Hila Qu

**English:**
Yes, yes. I look forward to that as well. I watched many versions already kind of film, none of them are good. So-

**中文翻译:**
是的，我也很期待。我已经看过好几个影视版本了，没一个好的。所以……

---

### [01:28:17] Lenny

**English:**
That's the problem it's so hard to do well. Oh man, I'm not optimistic, but I'm excited anyway.

**中文翻译:**
这就是问题所在，太难拍好了。天呐，我不乐观，但还是很兴奋。

---

### [01:28:21] Hila Qu

**English:**
Yeah, yeah.

**中文翻译:**
是啊。

---

### [01:28:22] Lenny

**English:**
Favorite interview question that you like to ask.

**中文翻译:**
你最喜欢问的面试问题。

---

### [01:28:24] Hila Qu

**English:**
When I interview a growth PM or analyst, I will always ask, "What is a experiment you launched that has a very unexpected result? And what did you do after that?"

**中文翻译:**
当我面试增长 PM 或分析师时，我总是会问：“你曾经开展过哪个实验，其结果非常出乎意料？之后你做了什么？”

---

### [01:28:37] Lenny

**English:**
What do you look for in an answer there that makes you feel like they are strong?

**中文翻译:**
你希望从回答中看到什么，从而觉得他们很强？

---

### [01:28:41] Hila Qu

**English:**
So first of all, they have to be launching a lot of experiments to get very unexpected answer. So if you are only... Many people remember their success for the interview, they prepare that very well. I don't want to ask, "What's your successful experiment?" Secondly, I want to know just why it's unexpected. That reveals the deep, deep level of their thinking, how deep they are thinking. If they should expect that based on what they described, then they are not thinking deep enough, they are not understanding customer enough. And what they do afterwards is also awesome. Like, "How do you face a failure or unexpected result? What are the clues you can pursue? What are the actions you can take? How do you learn something out of it?"

**中文翻译:**
首先，他们必须开展过大量实验，才可能遇到非常出乎意料的结果。很多人面试时只记得自己的成功案例，准备得很充分。我不想问“你最成功的实验是什么”。其次，我想知道为什么它出乎意料。这能揭示他们思考的深度。如果根据他们的描述，那个结果本该在预料之中，那说明他们思考得不够深，不够了解客户。最后，他们之后的做法也很重要。比如：“你如何面对失败或意外结果？你可以追踪哪些线索？你可以采取哪些行动？你从中学习到了什么？”

---

### [01:29:28] Lenny

**English:**
I love it. What's a favorite recent product you've recently discovered that you love?

**中文翻译:**
太棒了。你最近发现并喜爱的产品是什么？

---

### [01:29:33] Hila Qu

**English:**
I would say, similar to everyone, ChatGPT. But also Lululemon yoga pants.

**中文翻译:**
我想说，和大家一样，是 ChatGPT。还有 Lululemon 的瑜伽裤。

---

### [01:29:43] Lenny

**English:**
Amazing. Great. What's something relatively minor you've changed in your product development process that has had a tremendous impact on a team's ability to execute?

**中文翻译:**
太棒了。在产品开发流程中，你做过什么相对较小的改动，却对团队的执行能力产生了巨大影响？

---

### [01:29:51] Hila Qu

**English:**
Yeah. At first I added basically a section in the dock, in the ticket stack. Ask the PMs to write the success metric ahead of time. As well as adding which of the growth lever this is helping. Is this contributing to acquisition, activation, retention, monetization? And it forced them to sometimes think through deeply, "Why are we even doing this?" Sometimes they ended up not doing that by just writing it down.

**中文翻译:**
是的。首先，我在文档（Ticket Stack）中增加了一个部分。要求 PM 提前写下成功指标，并注明这有助于哪种增长杠杆：是获客、激活、留存还是变现？这迫使他们有时去深入思考：“我们为什么要这么做？”有时仅仅通过写下来，他们最终决定不做了。

---

### [01:30:23] Lenny

**English:**
I love that. Next question. I know you're big on children's books, do you have a favorite children's book?

**中文翻译:**
我喜欢这个。下一个问题。我知道你很喜欢童书，你有最喜欢的童书吗？

---

### [01:30:29] Hila Qu

**English:**
My favorite children's book is called Someday, and I recommend everyone to check it out. And basically it's talking about how our children used to be our baby, become our kids, and when they are taller and more stronger than us and they will remember us.

**中文翻译:**
我最喜欢的童书叫《有一天》（Someday），我推荐每个人都去看看。它基本上讲述了我们的孩子如何从婴儿变成小孩，当他们长得比我们更高、更强壮时，他们会记得我们。

---

### [01:30:51] Lenny

**English:**
I'm going to need to check that out now. And final question. I know you're big on growth concepts, you have all these frameworks and concepts. And so what is your favorite growth concept?

**中文翻译:**
我现在就得去看看。最后一个问题。我知道你对增长概念很有研究，有很多框架和概念。那么你最喜欢的增长概念是什么？

---

### [01:31:02] Hila Qu

**English:**
I would say north star metric, because I find it's not only valuable to growth, it's valuable to just everything. When I think about what do I want to do with my career, does that fit my own personal north star metric? When I think about how I want to raise my kids, I think about what's the north star metric for successful education for my kid? Because it forced me to think long term. It forced me to think about what's valuable to me, to them, not only by the society standards, ARR revenue, like salary. And also what's my vision for myself and for my kids.

**中文翻译:**
我会说是“北极星指标”（North Star Metric），因为我发现它不仅对增长有价值，对万事万物都有价值。当我思考职业生涯想做什么时，我会想这是否符合我个人的北极星指标？当我思考如何抚养孩子时，我会想孩子成功教育的北极星指标是什么？因为它迫使我进行长期思考，迫使我思考对我、对他们真正有价值的东西，而不仅仅是社会标准、ARR 收入或薪水。还有我对自我的愿景以及对孩子的愿景。

---

### [01:31:43] Lenny

**English:**
I love that. It reminds me a recent guest where she always asks, "What are you optimizing for?" Whether she's talking with her kids or her husband or her team, and it's a similar concept. Hila, this was incredible. I think we've shared tens of thousands of dollars of value, and it will probably lead to millions of dollars of revenue for a lot of companies. And it's everything I hoped it would be. Thank you so much for being here and for sharing so much wisdom. Two final questions. Where can folks find you online if they want to reach out and learn more? And how can listeners be useful to you?

**中文翻译:**
我喜欢这个。这让我想起最近的一位嘉宾，她总是问：“你在优化什么？”无论她是和孩子、丈夫还是团队交谈，这都是类似的概念。Hila，这太不可思议了。我认为我们分享了价值数万美元的内容，这可能会为很多公司带来数百万美元的收入。这完全符合我的预期。非常感谢你来到这里并分享这么多智慧。最后两个问题：如果大家想联系你并了解更多，可以在哪里找到你？听众能为你做些什么？

---

### [01:32:15] Hila Qu

**English:**
Yeah, they can find me on LinkedIn. Just search Hila Qu, H-I-L-A Q-U. You can find me. I have a personal website that's under development, but I contracted it to my kid, to my 12-year-old. So he need to wait until summer and hopefully this summer he can finish it. Yeah, if you are a founder, you are looking for a growth advisor, feel free to hit me up. I'm always happy to just have a call with founders and leaders, get to know more people. And I'm a growth nerd, so I always want to nerd about growth anyway.

**中文翻译:**
好的，大家可以在 LinkedIn 上找到我，搜索 Hila Qu 即可。我有一个正在开发中的个人网站，但我把它“承包”给了我 12 岁的孩子。所以得等到夏天，希望这个夏天他能完成。另外，如果你是创始人，正在寻找增长顾问，欢迎联系我。我总是很乐意与创始人和领导者通个电话，结识更多人。我是一个增长迷，所以无论如何我都想聊聊增长。

---

### [01:32:51] Lenny

**English:**
Amazing. Hila, again, thank you so much for being here.

**中文翻译:**
太棒了。Hila，再次感谢你的到来。

---

### [01:32:54] Hila Qu

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:32:55] Lenny

**English:**
Bye, everyone.

**中文翻译:**
大家再见。

---

### [01:32:56] Hila Qu

**English:**
Bye.

**中文翻译:**
再见。

---

### [01:32:59] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得内容有价值，可以在 Apple Podcast、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。