# Howie Liu - 双语对照

# Lenny's Podcast: Howie Liu (Airtable CEO) - Bilingual Transcript
# Lenny's Podcast：Airtable 首席执行官 Howie Liu - 中英双语全文转录

---

### [00:00:00] Howie Liu

**English:**
If you were literally founding a new company from scratch with the same mission, how would you execute on that mission using a fully AI native approach? If you can't, then you should find a buyer and then if you really care about this mission, go and start the next carnation of it.

**中文翻译:**
如果你真的要从零开始创办一家使命相同的新公司，你会如何利用完全“AI原生”（AI native）的方法来执行这一使命？如果你做不到这一点，那么你就应该找个买家把公司卖了，然后如果你真的在乎这个使命，就去开启它的下一个化身。

---

### [00:00:12] Lenny Rachitsky

**English:**
Or people that work for you, how have you adjusted what you expect of them to help them be successful?

**中文翻译:**
对于为你工作的人，你调整了对他们的哪些期望，以帮助他们获得成功？

---

### [00:00:18] Howie Liu

**English:**
If you want to cancel all your meetings for like a day or for an entire week and just go play around with every AI product you think could be relevant to Airtable, go do it.

**中文翻译:**
如果你想取消一整天甚至一整周的所有会议，只是为了去摆弄每一个你认为可能与 Airtable 相关的 AI 产品，那就去做吧。

---

### [00:00:27] Lenny Rachitsky

**English:**
Of the different functions on our product team PM, engineering design, who has had the most success being more productive with these tools?

**中文翻译:**
在产品团队的不同职能中——产品经理（PM）、工程（Engineering）、设计（Design）——谁在使用这些工具提高生产力方面取得了最大的成功？

---

### [00:00:33] Howie Liu

**English:**
It really does become more about individual attitude. There's a strong advantage to any of those three roles who can kind of cross over into the other two. As a PM, you need to start looking more like a hybrid PM prototyper, who has some good design sensibilities?

**中文翻译:**
这实际上更多地取决于个人的态度。在这三个角色中，任何能够跨界到另外两个领域的人都有很强的优势。作为一名 PM，你需要开始变得更像是一个混合型的“PM 原型设计者”，并且具备良好的设计审美。

---

### [00:00:49] Lenny Rachitsky

**English:**
Do you see one of these roles being more in trouble than others? Today, my guest is Howie Liu. Howie is the co-founder and CEO of Airtable. I'm having a bunch of conversations on this podcast with founders who are reinventing their decade plus old business in this AI era, to help you navigate this existential transition that every company and product is going through right now. Howie and Airtable's journey is an incredible example of this, and there's so much to learn from what Howie shares in this conversation.

(00:01:20): We talk about a very interesting trend that I've noticed that Howie is very much an example of, of CEOs almost becoming individual contributors again, getting into the code, building things, leading initiatives themselves. That's something that we call the IC CEO. We also talk about the very specific skills that he believes product managers and product leaders, also engineers and designers need to build to do well in this new world that we're in. Also, how he restructured his company into two groups, a fast thinking group, and a slow thinking group, which allowed their AI investments to significantly accelerate.

(00:01:52): If you're struggling to figure out how to be successful in this new AI era, this episode is for you. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a year free of 15 incredible products, including Lovable, Replit, Bolt and Adyen, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD and Mobit. Check it out at lennysnewsletter.com and click product pass. With that, I bring you Howie Liu.

**中文翻译:**
你是否认为其中某个角色比其他角色面临更大的困境？今天，我的嘉宾是 Howie Liu。Howie 是 Airtable 的联合创始人兼首席执行官。在这个 AI 时代，我正在本播客中与许多创始人进行对话，他们正在重塑自己经营了十多年的业务，以帮助大家应对每个公司和产品目前都在经历的这场生存转型。Howie 和 Airtable 的历程就是一个极好的例子，从 Howie 在这次对话中的分享中可以学到很多东西。

(00:01:20): 我们讨论了我注意到的一项非常有趣的趋势，Howie 就是其中的典型代表：CEO 们几乎再次变成了“个人贡献者”（Individual Contributor），亲自参与代码编写、构建产品、领导项目。这就是我们所说的“IC 型 CEO”。我们还讨论了他认为产品经理、产品领导者以及工程师和设计师需要培养哪些特定技能，才能在这个新世界中表现出色。此外，他还分享了如何将公司重组为两个小组：一个“快思考”小组和一个“慢思考”小组，这使得他们的 AI 投资显著加速。

(01:52): 如果你正在苦苦思索如何在这个新的 AI 时代取得成功，那么这一集就是为你准备的。如果你喜欢这个播客，请不要忘记在您最喜欢的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯的年度订阅者，你将免费获得 15 款不可思议的产品的一年使用权，包括 Lovable、Replit、Bolt 和 Adyen、Linear、Superhuman、Descript、Wispr Flow、Gamma、Perplexity、Warp、Granola、Magic Patterns、Raycast、ChatPRD 和 Mobit。请访问 lennysnewsletter.com 并点击“product pass”查看。下面，让我们欢迎 Howie Liu。

---

### [00:02:23] Ad Segment (Lucidlink & DX)

*(Skipping full translation of ads as per standard practice for content-focused transcripts, but keeping the English for completeness)*

**English:**
This episode is brought to you by Lucidlink, the storage collaboration platform... [Ad content] ...Today's episode is brought to you by DX, the developer intelligence platform... [Ad content] ...Howie, thank you so much for being here and welcome to the podcast.

**中文翻译:**
本集节目由存储协作平台 Lucidlink 赞助……[广告内容]……本集节目由开发者情报平台 DX 赞助……[广告内容]……Howie，非常感谢你能来到这里，欢迎来到本播客。

---

### [00:04:14] Howie Liu

**English:**
I'm so excited. Thank you, Lenny. I've been a listener from afar for a while now.

**中文翻译:**
我非常激动。谢谢你，Lenny。我关注并收听你的节目已经有一段时间了。

---

### [00:04:19] Lenny Rachitsky

**English:**
I'm really flattered to hear that. I'm also very excited. You've been on quite a journey over the last, is it 13 years, is it longer?

**中文翻译:**
听到你这么说我真的很荣幸。我也很兴奋。在过去的 13 年里，或者更久？你经历了一段不平凡的旅程。

---

### [00:04:27] Howie Liu

**English:**
Yeah, right about 13.

**中文翻译:**
是的，大约 13 年。

---

### [00:04:28] Lenny Rachitsky

**English:**
13 years. I imagine there've been a lot of ups and a lot of downs. I want to talk about all those things. I want to talk about a lot of the lessons that you've learned along the way. I want to start with what I imagine was a very surprising down moment in the history of Airtable. This is something that, unfortunately, something I think about when I think of Airtable. I feel other people may feel this way, is there's this tweet that went super viral, maybe a couple of years ago at this point where someone just shared all this data and they're like, Airtable is dead. (00:04:57): They've raised way more money than they're worth. They're not making enough to get from underwater. Yeah, Airtable RIP. What happened there? How much of that was true? How did that go?

**中文翻译:**
13 年。我想这期间一定有很多起起落落。我想聊聊这些事情，以及你一路上学到的教训。我想从 Airtable 历史上一个非常令人惊讶的低谷时刻开始。不幸的是，每当我想到 Airtable 时，我就会想到这件事。我觉得其他人可能也有同感，那就是大约两年前，有一条推特疯传，有人分享了一堆数据，然后说“Airtable 已经死了”。(00:04:57): 他们融资的钱远超其价值。他们的收入不足以摆脱困境。是的，“Airtable 安息吧”。当时发生了什么？其中有多少是真的？情况到底如何？

---

### [00:05:06] Howie Liu

**English:**
Yeah, so basically none of it was true. I mean, the surprising thing to me was how viral this tweet went when ... Frankly, I actually look back at this person's other tweets. I think they worked at CB Insights, and the irony is the whole point of that business is to have good data, good data quality around private company data. And they just literally had incorrect numbers by a strong multiple on what our revenue scale was, what our growth rate was. And if it gave me some consolation, I look back and this person had also tweeted about other companies, like Flexport was the last take-down tweet. (00:05:45): They have like, "Oh, Flexport's dead" and their evaluation is too high, and blah, blah, blah. And so, I think that the more surprising thing was just like this person has been tweeting a bunch of spicy takes that are not substantiated by real data or correct data, and yet this particular tweet went super viral and that was the perplexing part to me. And then, actually, I think what really gave it legs was on the All In podcast, which is obviously super popular. And I listened to it. They covered it. They were like, "Oh, latest on this week's news, this tweet about Airtable. What do we think about this?" (00:06:22): And it almost, I think became a way to talk about a broader theme of what happens to this last generation of highly valued companies, maybe decacorn companies in this new ... And at that point, it was the recent moment for both public and private markets. They did also issue a correction though. All In, did a follow-up episode, a few, I think weeks later saying, "Hey, we got the numbers wrong. We are revising our case and a view on Airtable."

**中文翻译:**
是的，基本上没一点是真的。我的意思是，让我惊讶的是这条推特竟然传得那么广……坦白说，我后来回头看了看那个人的其他推特。我想他在 CB Insights 工作，讽刺的是，那家公司的核心业务就是提供关于私营公司的优质数据。而他给出的关于我们收入规模和增长率的数据，竟然比实际情况差了好几倍。如果说有什么能让我感到安慰的话，那就是我发现这个人也发过关于其他公司的推特，比如 Flexport 是他上一个“抨击”的对象。(00:05:45): 他发过类似“Flexport 死了”、“估值太高”之类的言论。所以，我觉得更令人惊讶的是，这个人一直在发布一堆没有真实数据或正确数据支持的激进观点，但偏偏这条推特疯传了，这让我很困惑。后来，真正让这件事发酵的是在《All In》播客上，那个播客显然非常受欢迎。我也听了，他们讨论了这件事。他们说：“哦，本周最新消息，关于 Airtable 的这条推特。我们怎么看？”(00:06:22): 我觉得这几乎成了一个切入点，用来讨论一个更广泛的话题：在当时那种公开和私募市场环境下，上一代高估值公司（也许是超级独角兽公司）会发生什么。不过，他们后来确实发布了更正。《All In》在几周后做了一集后续节目，说：“嘿，我们弄错了数字。我们正在修正对 Airtable 的看法和观点。”

---

### [00:06:53] Lenny Rachitsky

**English:**
What's that line about how a lie gets around the world some number of times before truth has even this time to get out of bed?

**中文翻译:**
那句话是怎么说的来着？“真相还在穿鞋的时候，谎言已经跑遍了半个世界。”

---

### [00:07:02] Howie Liu

**English:**
Yeah. Well, I think I learned about memes and morality very quickly in that experience. Not a very good social media person, but I think I learned a little more.

**中文翻译:**
是的。我想在那次经历中，我很快就领教了“模因”（memes）和道德的威力。我不是一个很擅长社交媒体的人，但我确实学到了一些。

---

### [00:07:10] Lenny Rachitsky

**English:**
Yeah, it's tough. Twitter is such ... The incentives are so misaligned. It's just I tweet something people want to share, not truth.

**中文翻译:**
是的，这很难。Twitter 这种平台……激励机制是错位的。人们只是发一些别人想分享的东西，而不是真相。

---

### [00:07:17] Howie Liu

**English:**
Well, especially ... I mean, there's a lot to like ... I would say, I like the post Elon Twitter more than the pre Elon Twitter because it is just bolder, and I guess I really admire bold product execution where you're not just stuck to the current laurels and they've made so many changes, but I do feel like I get injected into my feed very sensational content all the time, and I mean, it works on me. I can't help but to click on it and engage with it, but it does ... I think it does result in this kind of content, really spreading.

**中文翻译:**
尤其是……我的意思是，有很多值得喜欢的地方……我会说，我更喜欢马斯克接手后的 Twitter，而不是之前的，因为它更具胆识。我非常钦佩那种大胆的产品执行力，不固步自封，他们做了很多改变。但我确实觉得我的信息流里经常被塞进非常耸人听闻的内容，而且说实话，对我挺管用的。我忍不住会去点击和互动，但这确实……我认为这导致了这类内容的疯狂传播。

---

### [00:07:52] Lenny Rachitsky

**English:**
Yeah. Now, Nikita running the show, I don't know if you saw this, there's a new ... We don't need to keep talking about Twitter, but there's a new feature where you take a screenshot of a tweet and it has a huge X.com logo watermark on the top, right? Yeah, just to ... People are sharing these tweets all the time. Yeah.

**中文翻译:**
是的。现在 Nikita 在负责，不知道你看到没，有一个新功能……我们不需要一直聊 Twitter，但有一个新功能是当你截屏推文时，右上角会有一个巨大的 X.com 标志水印，对吧？是的，就是为了……因为人们一直在分享这些推文。

---

### [00:08:08] Lenny Rachitsky

**English:**
Okay. I want to go in a completely different direction, something that I'm really excited to talk to you about, which is this very emerging trend that I've noticed that I feel like you're at the forefront of CEOs becoming ICs again. It's kind of this move of, IC CEOs. CEOs getting their hands dirty again, building again, getting in the weeds, coating again. I feel like you're again at the forefront of this. Talk about just why you've done this, why you think this is important, and just what that looks like day to day to you versus what your life was like a few years ago.

**中文翻译:**
好，我想换个完全不同的方向，这是我非常兴奋想和你聊的话题，就是我注意到的一种新兴趋势，我觉得你走在了前列：CEO 们再次变成了“个人贡献者”（IC）。这有点像“IC 型 CEO”的运动。CEO 们再次亲力亲为，重新开始构建产品，深入细节，甚至重新写代码。我觉得你又是这一趋势的先锋。谈谈你为什么要这么做，为什么你认为这很重要，以及你现在的日常生活与几年前相比是什么样子的。

---

### [00:08:39] Howie Liu

**English:**
The underlying reason for this shift, at least for me, is that, as we started the company, I was very much in this mode. I was literally writing code both on the backend, thinking about the real time data architecture of our platform, also the front end, the UX. And I would argue that in that founding moment, the initial product market fit finding, and especially for a product that is pure software, we weren't building an operationally heavy business like a dog walking marketplace where the tech is only an afterthought. (00:09:11): The tech was the product, right? And in a very Meta sense, Airtable is the platform for other people to build their own apps. So it's all about the attack, like the very intimate design decisions, again, both architecturally and on the front end and the product UX choices. That is the product's value prop. You can't separate those two. You can't say, "Okay, I researched the jobs to be done. Here's the workflow, here's the process, and then, okay, some engineer can just build it as an afterthought." (00:09:40): It's those little decisions and really be able to be at the bleeding edge of what's possible both in the browser and with the real-time data architecture. That made the product what it was. I think the same is true for Figma, which actually had a very parallel timeline to us. We both were founded around the same time, both spent two and a half years building the product, hands-on that early team before launching. And when I think now to both the era in between that founding moment and then now as well as now the new gen AI moment, I think there was a maturing era of both SaaS overall and Airtable specifically. (00:10:19): Where, as you scale up and you learn how to build teams and organizations and you have to scale up stuff that's not actually those intimate details, but process and people and so on, you kind of get by default further and further away from those details, right? And maybe for some businesses that's fine because no longer is it about finding the details that make for a magical new product market fit. And it is really just about scaling up an existing thing that works and using what I would call more blunt instruments to scale it up, like a more blunt roadmap, a more blunt go-to market execution strategy. (00:10:56): Regardless, I think that now, we're entering this moment where ... Certainly every software product in my opinion, has to be refounded because AI is such a paradigm shift, it's not even just like the shift from desktop to mobile or on-prem to cloud where that was more like a very one time and somewhat predictable change in form factor. I think AI is so rapidly evolving that with every evolution, every new model release and every new type of capability that's released, it actually implies novel form factors and novel UX patterns to be invented to fully capitalize on those capabilities. (00:11:36): And so to be continuously relevant and to refine product market fit in this era, I think you have to be of the details. There is no looking at it from 10,000 foot view and saying, "Oh, we're just going to throw a bunch of people at this problem." It's actually understanding what is the right product experience and the right business model that backs it up and the right ... everything else to support that engine to take advantage of the capabilities in our product domain.

**中文翻译:**
这种转变的根本原因，至少对我来说，是因为在公司创立之初，我就是这种模式。我当时真的在写代码，既包括后端（思考我们平台的实时数据架构），也包括前端和 UX（用户体验）。我认为在那个初创阶段，在寻找最初的“产品市场契合点”（PMF）时，特别是对于一个纯软件产品，我们不是在建立一个像遛狗市场那样重运营的业务（在那里技术只是次要的）。(00:09:11): 技术本身就是产品，对吧？从某种“元”（Meta）的角度来看，Airtable 是一个让别人构建自己应用的平台。所以，一切都关乎技术，比如那些非常细微的设计决策，无论是架构上的还是前端的，以及产品 UX 的选择。那就是产品的价值主张。你无法将两者分开。你不能说：“好吧，我研究了‘待办任务’（jobs to be done），这是工作流，这是流程，然后，随便找个工程师把它做出来就行了。”(00:09:40): 正是那些微小的决定，以及能够站在浏览器技术和实时数据架构的最前沿，才成就了这款产品。我认为 Figma 也是如此，它的时间线与我们非常平行。我们几乎在同一时间成立，都在发布前花了两年半的时间由早期团队亲手打造产品。当我回过头看从创立到现在的这段时间，以及现在的生成式 AI 时刻，我认为 SaaS 行业整体以及 Airtable 自身都经历了一个成熟期。(00:10:19): 在那个阶段，随着规模的扩大，你学习如何建立团队和组织，你必须去处理那些并非细节的事情，比如流程、人员等等，默认情况下你会离细节越来越远，对吧？对于某些业务来说，这可能没问题，因为不再需要寻找那些能产生神奇 PMF 的细节了。它只是关于扩展一个已经奏效的现有事物，并使用我称之为更“钝”的工具来扩展它，比如更粗线条的路线图、更粗线条的市场执行策略。(00:10:56): 无论如何，我认为现在我们正进入这样一个时刻……在我看来，每一款软件产品都必须“重新创立”，因为 AI 是一场如此巨大的范式转移。它甚至不像从桌面到移动端，或者从本地部署到云端的转变，那些更像是一次性的、某种程度上可预测的形态变化。我认为 AI 进化得如此之快，每一次进化、每一个新模型的发布、每一种新能力的释放，实际上都意味着需要发明新的形态和新的 UX 模式，才能充分利用这些能力。(00:11:36): 因此，为了在这个时代保持持续的相关性并不断完善产品市场契合点，我认为你必须深入细节。不能只从一万英尺的高空俯瞰，然后说：“哦，我们只要往这个问题上投入一堆人就行了。”实际上，你需要理解什么是正确的产品体验，什么是支撑它的正确商业模式，以及什么是支撑这个引擎去利用我们产品领域能力的正确配套设施。

---

### [00:12:07] Lenny Rachitsky

**English:**
You have this phrase somewhere where you talk about being the chief taste maker.

**中文翻译:**
你在某个地方用过一个词，说你是“首席品味官”（Chief Taste Maker）。

---

### [00:12:11] Howie Liu

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:12:11] Lenny Rachitsky

**English:**
And to do that, you have to do exactly what you're describing.

**中文翻译:**
而要做到这一点，你必须做你刚才描述的那些事。

---

### [00:12:14] Howie Liu

**English:**
That's right. I mean, I think that, and I would also say it's actually now also hard to taste the soup without participating in at least some part of creating the soup. Meaning With AI, you can kind of look at the final product and say, "Okay, this feels right or not, or it feels like we're being bold enough and we're properly productizing these new capabilities." But I think to really understand the solution space of what's possible, you have to be in the details. (00:12:46): I mean, literally, you can't just look at screenshots or a pre-recorded video of a new product feature. AI is something you have to play with, and ideally you're playing with both the packaged up app or solution that you've built with it, but you're also playing around directly with the underlying primitives who are using the models either via API or via a chat interface. You're really pushing them to the boundaries. Because that's the only way that you really understand what these new ingredients. It's like as a chef, you just gained access to amazing new ingredients, but you have to actually get comfortable with them to put them into a new dish.

**中文翻译:**
没错。我的意思是，我认为现在如果不参与到“做汤”的过程中，也很难“品尝”出汤的味道。这意味着对于 AI，你可以看看最终产品然后说：“好吧，这感觉对还是不对，或者感觉我们是否足够大胆，是否妥善地将这些新能力产品化了。”但要真正理解“可能性的解决方案空间”，你必须深入细节。(00:12:46): 我的意思是，你不能只看截图或新功能的预录视频。AI 是你必须亲自去“玩”的东西。理想情况下，你既要玩你用它构建的封装好的应用或解决方案，也要直接玩底层的原语（primitives），通过 API 或聊天界面直接使用模型。你得把它们推向极限。因为那是你真正理解这些“新食材”的唯一方法。就像厨师一样，你刚刚获得了神奇的新食材，但你必须先熟悉它们，才能把它们做成一道新菜。

---

### [00:13:23] Lenny Rachitsky

**English:**
And we had Dan Shipper on the podcast, he runs this newsletter and podcast to product a company called Every. And they work with companies to help them become more AI successful and adopt AI and all that stuff. And I asked him, what's the signal that a company will have success adopting AI and seeing huge productivity gains? And he said, does the CEO use ChatGPT or Claude daily?

**中文翻译:**
我们在播客上请过 Dan Shipper，他经营着一份时事通讯和播客，还有一家叫 Every 的公司。他们与公司合作，帮助他们更成功地应用 AI、采用 AI 等等。我问他，一家公司成功采用 AI 并看到巨大生产力提升的信号是什么？他说，看 CEO 是否每天都使用 ChatGPT 或 Claude。

---

### [00:13:48] Howie Liu

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:13:49] Lenny Rachitsky

**English:**
And I feel like you're describing exactly, hourly,

**中文翻译:**
我觉得你描述的正是这样，甚至是每小时都在用。

---

### [00:13:51] Howie Liu

**English:**
Literally hourly, or you could even have a measure of inference costs, right? Like the equivalent underlying inference compute cycles, right?

**中文翻译:**
确实是每小时都在用，你甚至可以用“推理成本”（inference costs）来衡量，对吧？比如等效的底层推理计算周期。

---

### [00:14:02] Lenny Rachitsky

**English:**
How many tokens you use?

**中文翻译:**
你用了多少 token？

---

### [00:14:03] Howie Liu

**English:**
Yeah, I mean, I'm proud to say I am pretty sure I'm still the ... I just checked this recently, but I take pride in being the number one most expensive in inference cost user of Airtable AI, not just within our own company, but I think for a long time I was globally across all our customers vault. I mean, I'm extremely intentionally wasteful. Wasteful in the sense of I'll do something that costs maybe hundreds of dollars of actual inference costs. For instance, doing a lot of LLM calls against long transcripts of let's say, sales calls to extract different types of insights like here's the product apps, identify or here's summaries, et cetera. (00:14:49): And we also have now a capability that's basically like an LLM map reduce. So effectively, even if you can't fit the entire corpus of content into one LLM call, because the context window limitations, we'll map through all of this content and break it up into chunks and then perform an LLM call on each one and then perform an aggregation LLM call on those chunks. Very expensive, because you're basically running a highly expensive model against a lot of data and then running it again on the aggregates of that. But for me, hundreds of dollars spent on this exercise is trivial compared to the potential strategic value of having better insights. (00:15:29): It's as if a really, really smart chief of staff has gone through and read every single sales call transcript that we've had in the past year and giving me very astute product insights, marketing insights, kind of positioning insights and segmentation insights. That's invaluable. You could pay a consulting firm literally millions of dollars to get that quality of work. So to me, I still think the value versus the actual cost of AI when applied greedily but smartly, it's a crazy ratio. And more people should be aggressively throwing compute cycles at these very high value problems.

**中文翻译:**
是的，我很自豪地说，我敢肯定我仍然是……我最近刚查过，我很自豪自己是 Airtable AI 推理成本最高的头号用户，不仅是在我们公司内部，而且我认为在很长一段时间内，在我们的全球所有客户中也是如此。我的意思是，我是极其“刻意地浪费”。这种浪费是指我会做一些可能花费数百美元实际推理成本的事情。例如，针对销售电话的长篇转录稿进行大量的 LLM 调用，以提取不同类型的洞察，比如识别产品差距、生成摘要等等。(00:14:49): 我们现在还有一种功能，基本上就像 LLM 的“映射规约”（MapReduce）。因此，即使由于上下文窗口（context window）的限制，你无法将整个内容语料库放入一次 LLM 调用中，我们也会映射所有这些内容并将其分解成块，然后对每个块执行 LLM 调用，最后再对这些块执行聚合 LLM 调用。这非常昂贵，因为你基本上是在针对大量数据运行一个极其昂贵的模型，然后又在聚合结果上再次运行。但对我来说，与获得更好洞察的潜在战略价值相比，花在这项练习上的几百美元微不足道。(00:15:29): 这就像是一个非常非常聪明的幕僚长，翻阅并阅读了我们过去一年的每一次销售电话转录，并给了我非常敏锐的产品洞察、营销洞察、定位洞察和细分市场洞察。那是无价的。你可能要付给咨询公司数百万美元才能得到这种质量的工作。所以对我来说，我仍然认为，当贪婪但聪明地应用 AI 时，其价值与实际成本之比是一个疯狂的比例。更多的人应该积极地将计算周期投入到这些极高价值的问题上。

---

### [00:16:11] Lenny Rachitsky

**English:**
Until somebody tweets how you're costing the company so much on AI compute and you guys are going to be underwater.

**中文翻译:**
直到有人发推特说你在 AI 计算上花了公司这么多钱，你们快要破产了。

---

### [00:16:19] Howie Liu

**English:**
I'm just kidding. It's like how we have personally taken down the cashflow profile of the business.

**中文翻译:**
我开玩笑的。就像是我个人拉低了公司的现金流状况一样。

---

### [00:16:27] Lenny Rachitsky

**English:**
So CEO's, founders hearing this, they're probably like, okay, I should probably start doing this. What does this actually look like? I imagine you still have a lot of other stuff you got going on once, you got all these ... How do you change your day to day to do this?

**中文翻译:**
听到这些的 CEO 和创始人可能会想，好吧，我也该开始这么做了。但这具体是什么样子的？我猜你肯定还有很多其他事情要忙，你是如何改变你的日常生活来做到这一点的？

---

### [00:16:41] Howie Liu

**English:**
Yeah, so I actually cut my one-on-one roster by default, and the idea is not that I don't want to spend time one-on-one with people, but rather that I found that the ... Just having more standing one-on-ones actually precludes me from engaging in more timely topics. I like to think of the best types of meetings as very urgency driven. And there's some timely topic, you've discovered some insight. Maybe I talked to some new startup and I learned something from their product or their approach. (00:17:20): And I want to bring that into how we're thinking about a new feature at Airtable or even just plant the seed with some different EPD people within Airtable, I want to make most meetings very timely and very informed by real alpha. There's got to be some kind of value and insight to seed that with. Now, in addition to that, I'll supplement with, when I'm in person with someone, I want to carve out time for a proper catch up and less structured, less timely, and just more of building a relationship with a human. (00:17:53): But I actually find that having that common .. It's almost a barbell approach where it's like if you're going to spend time with somebody in a freeform way, actually do it in a high quality, not forced weekly ritual way. Go for a longer lunch or coffee walk or whatever in person when you can. Maybe that's a once every month or two kind of thing. And then the in-betweens are either topical, so we do have standing meetings for ... Now, we have a weekly basically sprint check-in on all of our AI execution stuff, which now is half the company or half the EPD org is working on AI capabilities. (00:18:29): We're trying to ship very quickly, like I basically want to always ask the question, how would an AI native company, like a cursor or windsurf, et cetera, how would they execute? And are we executing as fast as them and taking advantage of all the new stuff as well as them? So bringing that level of intensity and urgency to how I spend my time within, that's been the biggest shift for me.

**中文翻译:**
是的，所以我实际上默认削减了我的 1 对 1 会议名单。这并不是说我不想花时间与人单独交流，而是我发现……仅仅拥有更多的固定 1 对 1 会议实际上阻碍了我参与更具时效性的话题。我认为最好的会议类型应该是紧迫性驱动的。比如出现了一个及时的课题，或者你发现了一些洞察。也许我与某家新初创公司聊了聊，从他们的产品或方法中学到了一些东西。(00:17:20): 我想把这些带入我们对 Airtable 新功能的思考中，或者只是在 Airtable 内部的不同 EPD（工程、产品、设计）人员中播下种子。我希望大多数会议都非常及时，并且由真正的“超额价值”（alpha）驱动。必须有某种价值和洞察力作为基础。除此之外，我还会补充一点：当我与某人面对面时，我想留出时间进行正式的叙旧，这种交流结构性较弱，时效性要求较低，更多是为了建立人与人之间的关系。(00:17:53): 我发现这有点像“杠铃策略”：如果你要以自由形式与某人共度时光，那就以高质量的方式进行，而不是强迫性的每周例行公事。尽可能面对面地吃顿长午餐，或者喝杯咖啡散散步。也许每一两个月一次。而中间的时间要么是主题性的——我们确实有固定会议，比如现在我们每周会对所有 AI 执行工作进行冲刺检查（Sprint Check-in），现在公司一半的人或 EPD 组织的一半都在开发 AI 功能。(00:18:29): 我们试图非常快速地交付，我基本上总是想问一个问题：一个 AI 原生公司，比如 Cursor 或 Windsurf 等等，他们会如何执行？我们的执行速度是否和他们一样快？我们利用新事物的能力是否和他们一样强？所以，将这种强度和紧迫感带入我的时间分配中，这是我最大的转变。

---

### [00:18:55] Lenny Rachitsky

**English:**
What's a change you've made to help the company move faster and match that sort of pace?

**中文翻译:**
为了帮助公司加快速度并匹配这种节奏，你做了哪些改变？

---

### [00:19:01] Howie Liu

**English:**
Yeah. I mean, we did do a reorg of the EPD org. So before we had ... we've gone through a few different reorgs over the past, call it, four years. The original state as we just proliferated, I think by default or incrementally, was that we had a bunch of groups that were each responsible for a feature or a surface area. So there was a group responsible for search within our table, and there was a group responsible for mobile experience and so on and so forth. And that has its benefits. Obviously, that team can go and get really ramped up on that part of the code base, that part of the product. (00:19:36): But it has the disadvantage of yeah, you tend to think incrementally when everyone's remit is actually a feature that they incrementally improve by definition as opposed to thinking about a mission or a outcome goal that might need to coordinate dramatic changes across a wider set of surface areas instead of just each one incrementally improving. And so, we reorged initially to basically different business units effectively. So I know Airbnb has done the functional to GM back, et cetera. This was more like saying, "Look, we have an enterprise business" and them MO there is more about scalability. (00:20:19): Can we support the larger scale data sets and use cases? Do you have the core capabilities needed to be able to push out an app to maybe 10,000 seats or 20,000 seats for product operations? A lot of architecture, a lot of scale, that kind of work. We would have, what we call the teams filler, which is more about self-serve, kind of the product UX, how easy it is to adopt the product on board, share, do all the kind of basic functionality. An AI pillar, solutions pillar, and basically infra. And what we found though with that approach is that there was still ... there was more kind of holistic bets being made. (00:20:58): So the team's pillar could think not just about one feature, but the overall onboarding experience where really about Nuxt in a way that touched multiple parts of the product, but it still felt like it wasn't ... Especially as we started to execute more on AI stuff, it wasn't allowing us to aggressively and quickly move as a AI native company would. I mean, when you look at the cursors of the world, they're shipping major new stuff every week. And it's not like, "Oh, well we have this separate roadmap for enterprise, we have this roadmap for this group." (00:21:33): And it just feels like one cohesive product that's shipping at a breakneck pace. So we did this recent reorg where now we have what I call the fast thinking group, which officially is called AI platform, but it really means we want to just ship a bunch of new capabilities on a near weekly basis. And each of them should be truly awesome value. You should drop your jaw, how awesome it is to use this new capability in Airtable. And then separately, we have the slow thinking group, and that's not meant to be better or worse. It's literally like you need fast and slow thinking in the common sense to operate as a human.

**中文翻译:**
是的。我的意思是，我们确实对 EPD 组织进行了重组。在过去的四年里，我们经历了几次不同的重组。最初的状态是，随着我们的扩张，默认或增量地，我们有很多小组，每个小组负责一个功能或一个领域。比如有一个小组负责 Airtable 内部的搜索，一个小组负责移动端体验，等等。这有它的好处，显然，那个团队可以非常熟悉那部分代码库和那部分产品。(00:19:36): 但它的缺点是，当每个人的职责实际上只是一个功能时，你往往会倾向于进行增量思考，根据定义他们只是在进行增量改进，而不是思考一个可能需要跨更广泛领域协调剧烈变化的使命或结果目标。因此，我们最初重组为不同的业务单元。我知道 Airbnb 经历过从职能制到总经理制再转回来的过程。我们当时更像是说：“看，我们有企业业务”，那里的模式更多是关于可扩展性。(00:20:19): 我们能否支持更大规模的数据集和用例？你是否具备将应用推送到 10,000 或 20,000 个席位进行产品运营所需的核心能力？大量的架构工作，大量的规模化工作。我们还有所谓的“团队支柱”，更多是关于自助服务、产品 UX、入职门槛、分享以及所有基础功能。还有一个 AI 支柱、解决方案支柱，以及基础架构。但我们发现，这种方法虽然开始有一些整体性的押注……(00:20:58): 比如团队支柱不仅考虑一个功能，而是考虑整体的入职体验，以一种触及产品多个部分的方式。但感觉还是不够……特别是当我们开始执行更多 AI 相关工作时，它无法让我们像 AI 原生公司那样激进且快速地移动。当你观察像 Cursor 这样的公司时，他们每周都在发布重大新功能。这不像“哦，我们有一个单独的企业路线图，我们有这个小组的路线图”。(00:21:33): 它感觉就像一个以极快速度交付的凝聚力极强的产品。所以我们最近进行了重组，现在我们有了我称之为“快思考”的小组，官方名称是 AI 平台，但它真正的意思是我们要几乎每周发布一堆新能力。每一个都应该是真正令人惊叹的价值。你应该在 Airtable 中使用这些新功能时感到惊讶。然后，我们分别设立了“慢思考”小组，这并不是说谁好谁坏。这就像人类运作需要常识中的快思考和慢思考一样。

---

### [00:22:12] Lenny Rachitsky

**English:**
I have that book behind me.

**中文翻译:**
我身后就有那本书（指《思考，快与慢》）。

---

### [00:22:14] Howie Liu

**English:**
Yeah, I love that book. But slow thinking it's like, it's just a different mode of planning and executing, right? It's like more deliberate that require more premeditation. We can't just ship a new piece of infrastructure that has a lot of data complexity like our data store HyperDB that now can handle multi-hundred million record data sets. That's not something you ship in a week in a hacky prototype. So we now have these two separate parts of the company, and I actually think what's really cool is they actually compliment each other very well, right? (00:22:46): Because the fast execution, the AI stuff, that creates the top of funnel excitement that also inspires new use cases and new users to come to Airtable, including in large enterprise, right? Enterprises can use this stuff too. It's not just like a SMB thing, but the slow thinking basically allows those initial seeds of adoption to Sprout and grow into much larger deployments. Whereas I think a lot of the challenge for many of the AI native companies I've seen is that they could have a very wide top of funnel, like get all of this AI, tourist traffic. (00:23:19): A lot of interest, a lot of early usage, but then sometimes the challenge is how do you turn that into more durable growth and get each of those adoption seeds to retain and expand over time.

**中文翻译:**
是的，我喜欢那本书。但慢思考就像是一种不同的规划和执行模式，对吧？它更深思熟虑，需要更多的预谋。我们不能随随便便就发布一个新的具有高度数据复杂性的基础设施，比如我们的数据存储 HyperDB，它现在可以处理数亿条记录的数据集。这不是你在一周内用一个简陋的原型就能发布的东西。所以我们现在把公司分成了这两个部分，我真的觉得很酷的一点是它们互补得非常好，对吧？(00:22:46): 因为快速执行的 AI 业务创造了漏斗顶端的兴奋感，也激发了新的用例，吸引了新用户来到 Airtable，包括大型企业。企业也可以使用这些东西，这不仅仅是中小企业（SMB）的事。而慢思考基本上允许这些最初的采用种子发芽并成长为更大规模的部署。相比之下，我看到的许多 AI 原生公司面临的挑战是，他们可能有一个非常宽的漏斗顶端，吸引了大量的“AI 游客”流量。(00:23:19): 有很多兴趣，有很多早期使用，但有时挑战在于如何将其转化为更持久的增长，并让每一个采用种子随着时间的推移得以留存和扩展。

---

### [00:23:33] Lenny Rachitsky

**English:**
That is super cool. I've never heard of this way of structuring teams, the fast thinking, thinking fast, thinking slow, the Kahneman. It's so interesting for the fast thinking team, do you find there's specific archetypes of people that are successful there? Is it a lot of bringing in new people that are not just used to the way of working at our table? What do you find?

**中文翻译:**
这太酷了。我从未听说过这种组建团队的方式，快思考、慢思考，卡尼曼式的。对于快思考团队，你是否发现那里有特定类型的成功人士？是引入了很多不习惯 Airtable 原有工作方式的新人吗？你发现了什么？

---

### [00:23:52] Howie Liu

**English:**
We have a mix. So we brought in ... I mean, we're always hiring, right? There was never a point in the company's life where we stopped hiring. And candidly, even when we had to do two rifts, that's significantly reduced our head count. We had just way too quickly grown and overscaled the business at a certain point. But even when we did our rifts, we were still actively recruiting and hiring in ... I mean every major department, but especially in EPD, because it's always been my belief that it would be arrogant to say that we have all the people we ever need already in the roster today, right? (00:24:29): We're always going to need to find new, fresh perspectives, new skillsets, et cetera. And so, we've continued to hire ... I think we've learned as we've gone along of what is the ideal type of hire, and we've done some actual hires and learned from that as well. But I think the fast thinking part, it really just requires a lot of ... Somebody who's able to operate with a lot of autonomy, who's entrepreneurial in nature. Now, it doesn't mean they have to literally be a former founder. I know some companies are, like Rippling for instance, does a lot of actual acquisitions and gets actual founders into the company. (00:25:04): We found that that's great and we've done some of that as well. But also there are some really, really capable people who we didn't literally have to acquire in, and yet, they're just able to think full stack about the problem and the user experience. Problem, not just meaning the technical layers of the problem, but also, what is the wow factor we're trying to create. So tangibly we're doing this new thing that's about to ship, where not only can you describe the app you want to build and then iterate on it with our conversational agent Omni. (00:25:41): And it builds it with the existing air table platform capabilities, but we're also giving it the ability to actually do code gen, to extend those apps with really final mile very bespoke functionality or visuals. So you could say, "Hey, generate me a very, very specific type of map view with this kind of heat mapping and this kind of icons and ..." (00:26:00): It's kind of like heat mapping and this kind of icons. And when you click it, do this. And that's a capability that there's so much ambiguity in some of the design decisions around it. And you have to blend that design thinking with some of the technical constraints of what can the AI models actually one shot effectively? (00:26:21): And if not, how do you add in the right human workflow for approval and review, and the reprompting and so on? So just so many different design decisions, and you need somebody who can really think full-stack about that kind of product and is not overwhelmed by that kind of open-endedness, but relishes in it.

**中文翻译:**
我们是混合型的。我们引入了……我的意思是，我们一直在招聘，对吧？在公司的生命周期中，从未停止过招聘。坦率地说，即使在我们不得不进行两次裁员（RIF）时，那显著减少了我们的员工人数。在某个阶段，我们的业务增长和规模扩张得太快了。但即使在裁员期间，我们仍在积极招募和聘用……我的意思是每个主要部门，尤其是 EPD，因为我始终认为，如果说我们今天已经拥有了所有需要的人才，那是傲慢的。(00:24:29): 我们总是需要寻找新的、新鲜的视角、新的技能组合等等。所以，我们一直在招聘……我想我们在过程中学到了什么是理想的招聘类型，我们也进行了一些实际的招聘并从中吸取了教训。但我认为快思考部分，它确实需要很多……能够高度自主运作、本质上具有创业精神的人。现在，这并不意味着他们必须真的是前创始人。我知道有些公司是这样，比如 Rippling，他们进行了大量的实际收购，并将真正的创始人引入公司。(00:25:04): 我们发现这很好，我们也做了一些。但也有一些非常非常有能力的人，我们不需要通过收购引入，但他们能够对问题和用户体验进行全栈思考。问题不仅指问题的技术层面，还包括我们试图创造的“惊艳因素”。具体来说，我们即将发布一个新功能，你不仅可以描述你想构建的应用，然后通过我们的对话代理 Omni 进行迭代。(00:25:41): 它利用现有的 Airtable 平台能力进行构建，但我们还赋予了它实际进行代码生成（code gen）的能力，用真正的“最后一英里”非常定制化的功能或视觉效果来扩展这些应用。所以你可以说：“嘿，给我生成一个非常非常特定类型的地图视图，带有这种热力图和这种图标……”(00:26:00): 比如热力图和这种图标，当你点击它时，执行这个操作。这种能力在设计决策上存在很多模糊性。你必须将这种设计思维与技术限制结合起来：AI 模型到底能有效地“一次性生成”（one shot）什么？(00:26:21): 如果不行，你如何加入正确的人工审批和审查工作流，以及重新提示（reprompting）等等？所以有这么多不同的设计决策，你需要一个能够真正对这类产品进行全栈思考的人，他不会被这种开放性所压倒，反而乐在其中。

---

### [00:26:38] Lenny Rachitsky

**English:**
I was actually playing with it before we started chatting. I made a really cute startup CRM.

**中文翻译:**
其实在我们开始聊天之前我一直在玩它。我做了一个非常可爱的初创公司 CRM。

---

### [00:26:43] Howie Liu

**English:**
Oh, that's awesome.

**中文翻译:**
噢，那太棒了。

---

### [00:26:43] Lenny Rachitsky

**English:**
Yeah, started talking Omni over here. It's like the colors are beautiful-

**中文翻译:**
是的，开始在这里和 Omni 对话。它的颜色很漂亮——

---

### [00:26:47] Howie Liu

**English:**
[inaudible 00:26:47].

**中文翻译:**
（听不清）

---

### [00:26:47] Lenny Rachitsky

**English:**
... so that's what's standing out to me right now.

**中文翻译:**
……所以这是目前最吸引我的地方。

---

### [00:26:49] Howie Liu

**English:**
[inaudible 00:26:49] there is...

**中文翻译:**
（听不清）那里有……

---

### [00:26:50] Howie Liu

**English:**
I will say just as a note, I consider myself at my core a product UX person. That's my passion. And everything else I've had to learn to run this company is almost like what was a necessary part of the journey. But my real passion is thinking about product UX. And I think of UX in a deeper sense than just the cosmetic design. What you could put into a framer kind of prototype. I think of it as literally what should this product do and how should it represent that and behave for the user? That is the product, in my opinion, right. And of course, then you have to figure out technically what's possible and how to implement it. (00:27:36): But I think to me what's under executed today in the world of AI products is there's so many awesome capabilities of AI, and most of them are really under merchandise, and there's very poor, actually, visual or otherwise metaphors or affordances given to users to help represent or understand what those underlying capabilities are. I mean, ChatGPT obviously extremely successful product, so not knocking it at all, but you come in and you just get this completely blank chat box by default, and now they have suggestions underneath and so on. (00:28:13): But the product UX part of me is just craving more visual metaphors or colors or some kind of use the canvas of a web interface and all the richness interaction you create there to better represent or show all the different things that you can do with the underlying model, right. And so that's something we've tried to do with Airtable, is show all of the different states and use colors even to play those up.

**中文翻译:**
我想说明一点，我核心上认为自己是一个产品 UX 人员。那是我的热情所在。为了经营这家公司我不得不学习的其他一切，几乎都只是这段旅程中必要的一部分。但我真正的热情在于思考产品 UX。我所理解的 UX 比单纯的外观设计更深。不仅仅是你能在 Framer 原型里放进去的东西。我把它看作是：这个产品到底应该做什么，它应该如何呈现，以及它对用户表现出什么样的行为？在我看来，那就是产品本身。当然，然后你必须从技术上弄清楚什么是可能的，以及如何实现它。(00:27:36): 但我认为，在当今的 AI 产品世界中，执行不足的地方在于：AI 有这么多令人惊叹的能力，但其中大多数都没有被很好地“推销”出去。实际上，给用户的视觉或其他隐喻（metaphors）或示能（affordances）非常贫乏，无法帮助他们表现或理解那些底层能力是什么。我的意思是，ChatGPT 显然是一款极其成功的产品，完全没有贬低它的意思，但你进去后，默认情况下看到的只是一个完全空白的对话框，现在下面有了一些建议等等。(00:28:13): 但我作为产品 UX 的那部分灵魂，渴望更多的视觉隐喻、颜色，或者利用 Web 界面的画布以及你在那里创造的所有丰富交互，来更好地表现或展示你可以利用底层模型做的所有不同事情。所以这就是我们在 Airtable 中尝试做的，展示所有不同的状态，甚至使用颜色来强化这些状态。

---

### [00:28:44] Lenny Rachitsky

**English:**
It's interesting how much of this connects with I just had Nick Turley on the podcast. He's head of ChatGPT at OpenAI, and he had these two really interesting insights that resonate directly with what you're describing. One is he has this concept of whenever something is being worked on, he's always asking, " Is this maximally accelerated? How do we move faster? If this is important, what would allow us to move faster?" (00:29:06): And I love that that's one of the themes that's coming up as you talk, is just this creating this very clear sense of speed. And you even call it the fast-thinking team, like, "You are going to move fast." And then the other one is just this insight that with AI, you often don't know what it can do and what people want to do with it until it's out. So there's this need to get it out, and that'll tell you what it should be.

**中文翻译:**
有趣的是，这其中有很多内容与我刚请到播客上的 Nick Turley 所说的相契合。他是 OpenAI 的 ChatGPT 负责人，他有两个非常有趣的见解，直接与你描述的内容产生共鸣。一个是他的理念：每当在做某件事时，他总会问：“这是否实现了最大程度的加速？我们如何移动得更快？如果这很重要，什么能让我们移动得更快？”(00:29:06): 我很喜欢这也是你谈话中出现的主题之一，就是创造这种非常明确的速度感。你甚至把它叫做“快思考团队”，就像在说“你们要快起来”。另一个见解是，对于 AI，在它发布之前，你通常不知道它能做什么，也不知道人们想用它做什么。所以需要把它发布出去，那会告诉你它应该是什么样子。

---

### [00:29:29] Howie Liu

**English:**
I couldn't agree more with both of those, and particularly on the second point, I think it's interesting. Clearly, there have been companies that have both been successful in PLG and more sales-led distribution for AI products. The most notable ones I can think of are Palantir with their AIP deployments. That's obviously very sales-led. You're not PLG into a Palantir deployment. But even companies like Harvey and so on, they're doing very well. And it's primarily, from what I understand, sales-led. (00:29:59): You're not self- serving into a Harvey instance at a law firm. And yet, to me, the best way to get AI value out there is experientially, right. And so you can kind of get that in a sales motion. You can show a demo. Maybe you can do a POC, but it's so much more powerful when you just open up the doors and say, "Anyone who wants to come and sign up and trial this product can." And I think to me, it's a real proof point that ChatGPT is arguably the most successful kind of PLG product of all time, just in terms of sheer scale of users. Like they announced 700 million... Is it MAUs or week... I think it's actually-

**中文翻译:**
我完全同意这两点，特别是第二点，我觉得很有趣。显然，有些公司在 AI 产品的 PLG（产品驱动增长）和销售驱动分发方面都取得了成功。我能想到的最著名的是 Palantir 的 AIP 部署。那显然是非常销售驱动的，你不会通过 PLG 进入 Palantir 的部署。但即使像 Harvey 这样的公司，他们也做得很好。据我所知，他们主要是销售驱动的。(00:29:59): 你不会在律师事务所里自助注册一个 Harvey 实例。然而，对我来说，让 AI 价值落地的最佳方式是体验式的。你可以在销售过程中获得这种体验，展示演示，或者做 POC（概念验证），但当你敞开大门说“任何想来注册并试用这款产品的人都可以”时，它的力量要强大得多。我认为对我来说，这是一个真正的证明，即 ChatGPT 堪称有史以来最成功的 PLG 产品，仅仅从用户规模来看就是如此。比如他们宣布有 7 亿……是月活（MAU）还是周活？我想实际上是——

---

### [00:30:41] Lenny Rachitsky

**English:**
Weekly active users.

**中文翻译:**
周活跃用户。

---

### [00:30:41] Howie Liu

**English:**
Weekly.

**中文翻译:**
周活。

---

### [00:30:42] Lenny Rachitsky

**English:**
10% of humans on earth use it-

**中文翻译:**
地球上 10% 的人类在使用它——

---

### [00:30:43] Howie Liu

**English:**
That's insane.

**中文翻译:**
那太疯狂了。

---

### [00:30:44] Lenny Rachitsky

**English:**
... weekly.

**中文翻译:**
……每周。

---

### [00:30:45] Howie Liu

**English:**
That's insane. In how many years? A few years.

**中文翻译:**
太疯狂了。才用了几年？几年时间。

---

### [00:30:48] Lenny Rachitsky

**English:**
Three years. Under three years.

**中文翻译:**
三年。不到三年。

---

### [00:30:49] Howie Liu

**English:**
Yeah. So I mean, literally, that is just the most insane ramp curve. And I don't think they would've gotten there if you couldn't just come in and literally try the product out. And as a little bit of a rebuttal of the point I made earlier where I think ChatGPT doesn't do a ton right now, and even earlier they did even less to expose all the different ways you could use it, but they just made it so frictionless to just try it for yourself that you as a user could come in and just literally ask it anything and see how it did. And of course, people in the early days tried to stump it and showed, "Oh look, see, it's not that smart. It doesn't answer this hard question really well." (00:31:26): But clearly, the magical nature of it still appealed to you enough. Everybody used it. And so I think I do have a view. We've gone through that whole arc of we started PLG. I'd like to think Airtable was one of the PLG darlings of our era. And anyway, I started moving up market and doing more sales execution, although that was still always on top of usually PLG within an enterprise, but we started doing more and more sales execution. We still have that. That's still really important for our business. But I also think, me personally, one of my goals is to shift my attention back into that kind of builder-led adoption and literally showing in the product experientially, not telling in a deck, the value that you can get from AI and Airtable. (00:32:20): I think that's so key, and it's [inaudible 00:32:23], but it's also more than that. It's not just literally how do you onboard somebody into the product. It's literally thinking about the entire product experience itself, right. And in our case, we just made the entire product experience AI-centric. It used to be that we had kind of this secondary thing that you could ask questions to the assistant sidebar. We now made our agent the default way of doing everything in Airtable, and it's now the Airtable app, as you know, it is almost like an artifact that's manipulated by and can be tool used by the agent.

**中文翻译:**
是的。我的意思是，这简直是最疯狂的增长曲线。而且我认为，如果不能直接进来试用产品，他们是不可能达到这个高度的。作为对我之前观点的一点反驳——虽然我认为 ChatGPT 现在做得还不够多，早期在展示各种使用方式方面做得更少——但他们让“亲自尝试”变得如此毫无摩擦，以至于你作为一个用户可以进来问它任何事情，看看它表现如何。当然，早期人们试图难倒它，并展示：“哦看，它没那么聪明，它回答不好这个难题。”(00:31:26): 但显然，它的神奇本质仍然足够吸引你。每个人都在用它。所以我确实有一个观点。我们经历过整个周期：我们从 PLG 开始，我想 Airtable 曾是我们那个时代的 PLG 宠儿之一。后来，我开始向高端市场移动，进行更多的销售执行，尽管那通常仍然建立在企业内部的 PLG 基础之上，但我们开始做越来越多的销售执行。我们现在仍然有这部分业务，这对我们的业务仍然非常重要。但我也认为，就我个人而言，我的目标之一是将注意力转回到那种“构建者驱动的采用”（builder-led adoption）上，在产品中通过体验来展示，而不是在 PPT 里讲述你在 AI 和 Airtable 中能获得的价值。(00:32:20): 我认为这非常关键，这不仅仅是如何让某人开始使用产品，而是思考整个产品体验本身。在我们的案例中，我们将整个产品体验变得以 AI 为中心。以前我们有一个辅助性的侧边栏助手可以提问。现在我们将我们的代理（Agent）作为在 Airtable 中做任何事情的默认方式，现在的 Airtable 应用，如你所知，几乎就像是一个被代理操纵并可以被代理作为工具使用的“制品”（artifact）。

---

### [00:33:15] Lenny Rachitsky

**English:**
Let me follow that thread. So if you go to Airtable.com today, it looks like basically all the other AI app building sites. Now it's just tell me what you want to build. Thoughts on that, as just a thing everyone's starting to do is there... what do you think comes next? Is this... Is it working well?

**中文翻译:**
让我顺着这个话题往下聊。如果你今天访问 Airtable.com，它看起来基本上和所有其他 AI 应用构建网站一样。现在就是“告诉我你想构建什么”。对于这种每个人都在做的事情，你有什么看法？你认为接下来会发生什么？这行得通吗？

---

### [00:33:15] Howie Liu

**English:**
There's clearly an incredible magic to vibe coding and app building with AI. And this is actually a prime illustration in my view of that concept we talked about a second ago, which is as capabilities of these underlying models evolve, the form factor in the product UX also needs to evolve with it. And so the earliest models, like the kind of original ChatGPT, like GPT-3.5 kind of era models were not nearly as smart as the current models. And so you couldn't really ask it to one shot a more complicated chunk of code, or certainly not like a full stack app, and expect it to work. (00:33:56): And so the right form factor for leveraging those models in a software creation context was GitHub Copilot, right. It's like auto-complete a few lines of code at a time. But you couldn't chat to it and tell it, "Build me this entire app from scratch." And I think that as the models got better and better, you saw that the new form factors emerge. I think Cursor did a great job of being an early pioneer of this more age agentic way of leveraging the models to do more complex things and generate more larger chunks of code. (00:34:27): And now with Composer, you can literally just go into Cursor and build an app from scratch, build me a 3D shooter game from scratch, and just watch it go and create all the files and fill out each file, and then the thing actually runs some of the time. And so to me, this is where the world is going. The models are clearly getting smarter. And if you think about the original vision of Airtable, it was always about democratizing software creation. We just strongly believed that the number of people who use apps far outweighs the number of people who can actually build their own or manipulate apps and harness custom software to their advantage.

**中文翻译:**
显然，利用 AI 进行“氛围编程”（vibe coding）和应用构建具有不可思议的魔力。在我看来，这正是我们刚才讨论的那个概念的最佳例证：随着底层模型能力的进化，产品 UX 的形态也需要随之进化。最早的模型，比如最初的 ChatGPT、GPT-3.5 时代的模型，远没有现在的模型聪明。所以你不能真的要求它“一次性生成”一段复杂的代码，更不用说一个全栈应用并指望它能运行了。(00:33:56): 因此，在软件创作背景下利用这些模型的正确形态是 GitHub Copilot，对吧？它就像是一次自动补全几行代码。但你不能和它聊天并告诉它：“从头开始给我构建整个应用。”我认为随着模型变得越来越好，你会看到新的形态出现。我认为 Cursor 在作为这种更具“代理性”（agentic）的模型利用方式的早期先锋方面做得非常好，可以处理更复杂的事情并生成更大的代码块。(00:34:27): 现在有了 Composer，你真的可以直接进入 Cursor 从头开始构建一个应用，“从头给我构建一个 3D 射击游戏”，然后看着它去创建所有文件并填充每个文件，而且这东西有时真的能运行。所以对我来说，这就是世界的走向。模型显然变得越来越聪明。如果你回想 Airtable 的最初愿景，它始终是关于“软件创作民主化”。我们坚信，使用应用的人数远超能够实际构建自己应用、操纵应用并利用定制软件为自己创造优势的人数。

---

### [00:35:08] Lenny Rachitsky

**English:**
That sounds very familiar, very familiar these days.

**中文翻译:**
这听起来很耳熟，这些日子非常耳熟。

---

### [00:35:10] Howie Liu

**English:**
Yeah, exactly. And so I think this is, it's a different means to the same end. And so it's almost like we have to lean into this because if we started Airtable today, this is what we would be all in on. Now I think that the advantage that we have, and I do think you have to be realistic to yourself, especially as a company that predates GenAI and now has to find your new footing in the AI landscape. You can't fool yourself and just say like, "Okay, I'm going to throw in some AI stuff on the landing... on the marketing site, put in a couple AI features, and call it a day." (00:35:43): I think you actually have to take a clean slate approach to saying, "How would our mission best be expressed? If you were literally founding a new company from scratch with the same mission, how would you execute on that mission using a fully AI native approach?" And then, by the way, do you have useful building blocks that you can leverage from your existing product and your existing business, or are you literally worse off having this legacy asset versus starting something from scratch? And I don't think the answer is always yes or no. I think it just depends on the product. (00:36:19): And if you can't really introspect and say, "Look, I think I'm better off doing this with the pieces that I have for my existing business and product," then I think you should sell. You should find a buyer for that company and then go. And if you really care about this mission, go and start the next carnation of it. In my case, I really thought about this and really feel strongly that the building blocks that we have, these no code components, actually do allow us to execute better on this vision than if I had to start from scratch. (00:36:50): Meaning the problem with vibe coding, especially if we're building business apps... So I should clarify that we want to democratize software creation, but specifically, we are focused on business apps. We're not trying to be the platform where you create a cool viral consumer game. This is for like your CRM, right. Or if you want to build an inventory management system as a small restaurant or a lawyer trying to build a case management system, that's what we've always been focused on. And I think in this AI-native world, clearly, you should be able to generate those apps agentically. (00:37:24): And yet if you have an agent that has to generate every single bit of that app from scratch, from code, it's going to be very unreliable. There's going to be bugs. There's going to be data and security issues. And then you're also going to have a context collapse, as it just cannot manage all of the code that it's written, basically, as the app gets more and more complex. And what we actually have are basically these primitives that the agent can manipulate and use without having to literally write the code from scratch to represent, "Here's a beautiful crud interface on top of the data layer. (00:37:57): Ours is real-time and collaborative, and really rich, and has collaboration on it. And by the way, here's all these other view types and a layout engine for a custom interface, a layout, or automations and business logic." And so it's almost like in programming terms, the Airtable pieces in our Lego kit today can be used by this agent as almost like a more expressive DSL, like a domain-specific language to build business apps instead of literally having to write everything down to the SQL and HTML and JavaScript to build every part of that app from scratch. (00:38:31): And so if we can combine the best of both worlds, we have these very reliable, high-quality Lego pieces. Now, an agent can go and assemble them for you instead of you just using the GUI to do that. And by the way, if you do want to fall back to the GUI, there's a really great kind of way for the non-technical user to still understand and participate in what's going on. Whereas if you're not technical, you can't inspect the code underneath a v0 or Lovable or Revolut app, right. (00:38:58): It's just kind of opaque to you. And if you can't re- prop it to get what you want, you're kind of stuck. This is much more akin to a developer using Cursor can generate lots of code, but then can still drop back to the IDE to edit and manipulate it to the final production-ready state. So that's kind of the play that we're making. And if I didn't fully and truly believe we have a better shot at doing it with our existing product, I wouldn't be running this company in its form today.

**中文翻译:**
是的，没错。所以我认为这是殊途同归。我们几乎必须全身心投入其中，因为如果我们今天创办 Airtable，这就是我们会全力以赴的方向。现在我认为我们的优势在于——而且我认为你必须对自己保持现实，特别是作为一家早于生成式 AI 出现的公司，现在必须在 AI 版图中找到新的立足点。你不能自欺欺人地说：“好吧，我要在落地页……在营销网站上放点 AI 的东西，加几个 AI 功能，然后就完事了。”(00:35:43): 我认为你实际上必须采取“白纸一张”的方法来思考：“我们的使命如何才能得到最好的表达？如果你真的从零开始创办一家使命相同的新公司，你会如何利用完全 AI 原生的方法来执行这一使命？”顺便说一句，你是否有可以从现有产品和现有业务中利用的有用的构建块？还是说拥有这些遗产资产反而比从头开始更糟糕？我不认为答案总是肯定的或否定的。我认为这取决于产品。(00:36:19): 如果你不能真正反思并说：“看，我认为利用我现有业务和产品的这些组件，我能做得更好”，那么我认为你应该卖掉公司。你应该为那家公司找个买家，然后离开。如果你真的在乎这个使命，就去开启它的下一个化身。就我而言，我认真思考过这个问题，并强烈感觉到我们拥有的这些构建块——这些无代码组件——实际上确实让我们比从头开始能更好地执行这一愿景。(00:36:50): 意思是，“氛围编程”的问题在于，特别是如果我们是在构建商业应用……我应该澄清一下，我们想要实现软件创作的民主化，但具体来说，我们专注于商业应用。我们不想成为让你创建一个酷炫的病毒式消费级游戏的平台。这是为了你的 CRM，对吧？或者如果你是一家小餐馆想建立库存管理系统，或者一名律师想建立案件管理系统，这才是我们一直关注的。我认为在这个 AI 原生世界中，显然你应该能够以代理的方式生成这些应用。(00:37:24): 然而，如果你有一个代理必须从头开始、从代码生成该应用的每一个部分，那将是非常不可靠的。会有 Bug，会有数据和安全问题。然后你还会遇到“上下文崩溃”，因为随着应用变得越来越复杂，它基本上无法管理它编写的所有代码。而我们实际拥有的是这些原语，代理可以操纵和使用它们，而无需从头编写代码来表示：“这是数据层之上的一个漂亮的 CRUD 界面。(00:37:57): 我们的界面是实时的、协作的、非常丰富的。顺便说一句，这里还有所有这些其他的视图类型，以及用于自定义界面、布局或自动化和业务逻辑的布局引擎。”所以这有点像在编程术语中，我们今天乐高积木盒里的 Airtable 组件可以被这个代理用作一种更具表现力的 DSL（领域特定语言）来构建商业应用，而不是必须从头编写 SQL、HTML 和 JavaScript 来构建应用的每个部分。(00:38:31): 所以如果我们能结合两者的优点，我们就拥有了这些非常可靠、高质量的乐高积木。现在，代理可以去为你组装它们，而不是你仅仅使用 GUI（图形用户界面）来做。顺便说一句，如果你确实想退回到 GUI，非技术用户仍然有一种非常棒的方式来理解和参与其中。而如果你不是技术人员，你无法检查 v0、Lovable 或 Replit 应用底层的代码，对吧？(00:38:58): 对你来说它是透明度不高的。如果你无法通过重新提示来获得你想要的东西，你就被困住了。这更类似于开发者使用 Cursor 可以生成大量代码，但仍然可以退回到 IDE 进行编辑和操纵，直到达到最终的生产就绪状态。这就是我们正在进行的博弈。如果我不是完全真实地相信利用现有产品我们有更好的机会做到这一点，我就不会以现在的形式经营这家公司。

---

### [00:39:25] Lenny Rachitsky

**English:**
I'm talking to a lot of founders that are going through the journey are going on, which is, "We've had a business for a decade, AI emerged, and wow, we got to figure out something that works... that could work even better." And so I'm trying to pull out the threads that are consistently working across these journeys because I think a lot of companies are trying to figure this out. So one that you just touched on is just if you were to start today, what will you do? (00:39:48): What would that business be? Plus, how can... do we have an unfair advantage with the thing we've done in the past? That feels like an important ingredient. And then the other... circling back to stuff you've shared already, there's just creating a sense of urgency and pace and getting people to understand this is how things move in AI, and we need to create this fast-thinking team. I love that metaphor in framing. (00:40:11): And then there's the point you made about just talking to AI regularly as the founder feels like an important element, just like to truly be this ICCO talking to AI, working with AI regularly. Just on that note a little bit more, just to give people a sense of what this looks like day to day. So you're talking to Omni all day trying to and undertook... flex the power of what you can do and iterate on it. Is there anything else you're doing day to day that helps you figure out what to do for the business?

**中文翻译:**
我正在和很多经历着和你类似旅程的创始人交谈，即：“我们已经经营了十年的业务，AI 出现了，哇，我们必须想出一些行得通的……甚至能运行得更好的东西。”所以我试图找出在这些旅程中始终奏效的线索，因为我认为很多公司都在试图弄清楚这一点。你刚才提到的一个就是：如果你今天开始，你会做什么？(00:39:48): 那会是什么样的业务？此外，我们过去所做的事情是否给了我们某种“不公平优势”？这感觉是一个重要的成分。另一个……回到你已经分享过的内容，就是创造一种紧迫感和节奏感，让人们理解 AI 的发展就是这样的，我们需要创建这个“快思考团队”。我很喜欢这个隐喻和框架。(00:40:11): 还有你提到的关于创始人定期与 AI 对话的观点，这感觉是一个重要的元素，就像真正成为这个与 AI 对话、定期与 AI 协作的 IC 型 CEO。关于这一点再多说一点，让大家感受一下这在日常生活中是什么样子的。所以你整天都在和 Omni 聊天，试图展示你能做什么并进行迭代。你每天还在做其他什么事情来帮助你决定业务该怎么做吗？

---

### [00:40:38] Howie Liu

**English:**
One, I try to use as many different AI products, including not Airtable, as I can, and both literally for the novelty factor and just some new cool demo comes out. Like Runway release their immersive world engine, and so I'm going to go try it out. When Sesame AI put out their cool interactive voice chat demo, I tried that out because even though we don't have a direct and near-term need for really realistic and interruptible voice mode where it's not as core to our capabilities, I just want to understand and get a feel for everything that's out there. (00:41:23): And I try to invent little, almost like side projects of my own, to have a real reason to use these products. Like, "Oh, cool. What if I were to take... What if I were to try to create a funny little short... a funny video short using a combination of HeyGen avatars with a script, like a comical script generated by AI? And maybe it'll be on an interesting topic. So I'll do deep research on the topic with ChatGPT and pull together the results, have it compose kind of a little dialogue.

**中文翻译:**
第一，我尽可能多地尝试使用不同的 AI 产品，包括非 Airtable 的产品，这既是为了新鲜感，也是因为总会有一些酷炫的新演示出现。比如 Runway 发布了他们的沉浸式世界引擎，我就会去尝试。当 Sesame AI 发布他们酷炫的交互式语音聊天演示时，我也尝试了，因为尽管我们目前没有对非常真实且可中断的语音模式的直接和近期需求（这不是我们的核心能力），但我只是想了解并感受一下市面上都有什么。(00:41:23): 我还尝试发明一些属于自己的小副业项目，以便有一个真正的理由去使用这些产品。比如：“噢，酷。如果我尝试用 HeyGen 的数字人结合 AI 生成的滑稽脚本来制作一段有趣的短视频会怎样？也许会是一个有趣的话题。所以我会用 ChatGPT 对该话题进行深度研究，汇总结果，让它编写一段小对话。”

---

### [00:41:58] Lenny Rachitsky

**English:**
Did you actually do this? Is there something you made?

**中文翻译:**
你真的这么做了吗？有什么你做出来的东西吗？

---

### [00:42:00] Howie Liu

**English:**
Yeah. That's literally an example of something, just a fun weekend project. And to be honest, these things only take you an hour if you become kind of pretty proficient with using the products. They're all so easy to use. You can literally do the deep research thing, kick off query, make a coffee, come back in 20 minutes. Okay, let me prompt it to generate me some dialogue. It's a little bit like what NotebookLM does for you out of the box, but sometimes I like to just do it myself. And then, okay, let me take the script and cut it up and turn it into a HeyGen avatar and then download the video and play it. (00:42:32): And just for fun. I'm not trying to make that into an actual YouTube video business. But I think coming up with these different fun weekend projects is a really useful construct to force myself to actually try these products in a more than just a Twitch click way. And what it gives me is, A, it's not just understanding the models, which is also very, very important, right. GPT-5 came out yesterday, and playing around with it a bunch just on a variety of different personal use cases, but there's a difference between just understanding the model but then also understanding the product form factors in which they can be placed, right. (00:43:15): Meaning when you apply the model in a more structured way, when you apply the model with different tool calling than maybe what ChatGPT has in its out-of-the-box form, when you apply it with a more agentic workflow, again, that might be different from what ChatGPT gives you out-of-the-box, that's when you kind of learn you really get to inspire yourself on what are the product's form factors that these new models can take. And plus, by the way, I find it to be really fun. There is to me a delight and entertainment value to just using AI, period, because A, it's not perfectly predictable. (00:43:57): So I think the element of you're not quite sure what you're going to get. It's like a box of chocolates. And B, it always blows my mind just to think about, "Wow, five years ago we didn't have any of this stuff." AI was like, okay, it's like we can do predictive analytics. There's some basically very advanced kind of regressions that we could run with AI, but it looked nothing like this in its current form, and it's just actually super fun, in my opinion, to get to play around with all the different types of products that come out. (00:44:33): I think that is a big part of it because on the point about the pace of the world moving so much faster in AI than any other landscape in SaaS, in the mature SaaS era, it was important to study your competition. If you were building a SaaS company, you'd be crazy not to follow Salesforce every year and see what the major releases they're putting out are, or ServiceNow, or so on. (00:45:03): This is the equivalent of that, but there's major new releases and products and so on every week, not every year. And so I just think you have to say abreast of all... of it all and combining this with our point earlier of a lot of this has to be experienced, not just read. You can't just read the write-up on TechCrunch or even a tweet about a new capability. You kind of have to try it to really get a sense of what it is.

**中文翻译:**
是的。这确实是一个例子，只是一个有趣的周末项目。老实说，如果你对这些产品的使用变得相当熟练，这些事情只需要一个小时。它们都非常易于使用。你真的可以做深度研究，启动查询，去冲杯咖啡，20 分钟后回来。好，让我提示它给我生成一些对话。这有点像 NotebookLM 开箱即用的功能，但有时我喜欢自己动手。然后，好，让我把脚本剪开，把它变成 HeyGen 数字人，然后下载视频并播放。(00:42:32): 纯粹是为了好玩。我没打算把它做成真正的 YouTube 视频业务。但我认为构思这些不同的有趣周末项目是一个非常有用的框架，可以强迫我以不仅仅是“随手一点”的方式去实际尝试这些产品。它带给我的是：第一，不仅仅是理解模型（这也非常非常重要，对吧？GPT-5 昨天发布了，我在各种不同的个人用例中玩了很多次），而且理解模型与理解它们可以被放入的产品形态之间是有区别的。(00:43:15): 意思是，当你以更结构化的方式应用模型时，当你使用与 ChatGPT 开箱即用形式不同的工具调用（tool calling）时，当你使用更具代理性的工作流时（这可能也与 ChatGPT 提供的不同），那时你才会真正学到东西，真正启发自己这些新模型可以采取什么样的产品形态。此外，顺便说一句，我觉得这非常有趣。对我来说，仅仅使用 AI 就有一种愉悦感和娱乐价值，因为：第一，它不是完全可预测的。(00:43:57): 所以我觉得那种“你不太确定会得到什么”的元素，就像一盒巧克力。第二，想到“哇，五年前我们还没有这些东西”，总是让我大吃一惊。当时的 AI 就像是，好吧，我们可以做预测分析，我们可以用 AI 运行一些基本上非常高级的回归分析，但它现在的形式完全不是那样。在我看来，能玩到所有这些层出不穷的产品真的超级有趣。(00:44:33): 我认为这是很大一部分原因，因为关于 AI 世界的发展速度远快于 SaaS 领域的任何其他景观——在成熟的 SaaS 时代，研究竞争对手很重要。如果你在建立一家 SaaS 公司，如果你不每年关注 Salesforce 发布了什么重大版本，或者 ServiceNow 等等，那你就是疯了。(00:45:03): 现在的情况与此相当，但重大新版本和产品是每周都有，而不是每年。所以我认为你必须紧跟这一切，并结合我们之前提到的观点：很多东西必须去体验，而不仅仅是阅读。你不能只读 TechCrunch 上的报道，甚至不能只看关于新能力的推特。你必须亲自尝试才能真正感受到它是什么。

---

### [00:45:33] Ad Segment (Anthropic/Claude)

*(Skipping full translation of ads)*

**English:**
Today's episode is brought to you by Anthropic, the team behind Claude... [Ad content] ...If you want to try it out, get started at Claude.ai/Lenny.

**中文翻译:**
今天的节目由 Anthropic 赞助，他们是 Claude 背后的团队……[广告内容]……如果你想尝试，请访问 Claude.ai/Lenny。

---

### [00:46:34] Lenny Rachitsky

**English:**
For people that work for you across Airtable, say the product team, PMs, maybe engineers, designers, how have you adjusted what you expect of them to help them be successful in this new world?

**中文翻译:**
对于在 Airtable 为你工作的员工，比如产品团队、PM、工程师、设计师，你调整了对他们的哪些期望，以帮助他们在这个新世界中取得成功？

---

### [00:47:02] Howie Liu

**English:**
One is really, really, really stressing this idea of go play with this stuff. And I mean, when I say play, I really mean play in the psychological sense of there's a difference when you go in and you're kind of just trying to check the box and get a job done. There's a difference when you come in with a curiosity and you're kind of exploring, right. And it's both more fun and energizing, but also, I think you learn more through that. And so I've really tried to stress the value of play with these AI products. (00:47:36): And I kind of try to lead by example, by literally going and sharing out links or screenshots of the things that I'm doing in these various products. So, as an example, I will go into one of the prototyping tools and show, "Hey, I built a marketing landing page for this new capability we're launching." I created a landing page for it in Replit, let's say, and now I'm sharing that link. Instead of what typically we would've done in the past is like, okay, we're going to write a doc about it and then share the doc, I'm just going to show you an actual landing page with visuals and everything in there. (00:48:20): Or I'll share the actual link to my deep research reports. Or instead of me writing a perfect memo on a topic, I'll actually just prompt my way into getting a chat thread or a chat output that basically covers all the content that I care about and maybe even ask it to, "Okay, summarize this all into a final memo output," and then intentionally share that rather than expose the fact that I'm using AI in this way and here's literally how I'm prompting it so you can follow along as well. (00:48:49): But really trying to encourage everyone to go and just play with these products. And I've even said, "Look, if anyone wants to just literally block out a day or frankly even a week and have the ultimate excuse, you could use... you could say that I told you to do it, right. If you want to cancel all your meetings for a day or for an entire week and just go play around with every product, AI product that you can find that you think could be relevant to Airtable, go do it. Period. So I think that's the most important thing is this play, this experimentation. (00:49:25): I think there's also a lot of other kind of shifts in how we execute prototypes over decks. I want to see actual interactive demos because, again, it's hard to... In a deck or in a PRD, you could say, "Okay. Well, we're going to make Omni really good at handling this kind of app building." Okay, those are just words. The real proof is in the pudding of like, "Okay, let me try it out on a few realistic prompts that I can imagine." (00:49:49): And in a demo, in a real prototype, you can instantly try it out on unrealistic rather than golden pathy scenarios and see how it feels too. Does it feel too slow? Do we need to expose more of the reasoning or steps that are happening behind the scenes? Create a progress bar or something like that. But it's really hard to get that feel of the product with anything but a functional prototype that really does, in an open-end way, use the AI to do whatever you put in. (00:50:24): So I think it's more like a experimentation playground it feels like how we need to execute, versus I think, in the past, it sometimes felt like a more deterministic resourcing and kind of timelines view of execution. We're going to put this many people on this problem, and this is the eight-week timeline to this milestone, and then we're going to ship in a quarter from now. And I think now the whole thing is just a lot more experimentation and iteration-driven.

**中文翻译:**
第一，是反复强调“去玩这些东西”这个想法。我的意思是，当我提到“玩”时，我指的是心理学意义上的玩——当你进去只是为了完成任务、打个勾，和你带着好奇心去探索时，是有区别的。这不仅更有趣、更有活力，而且我认为你能学到更多。所以我一直在强调玩这些 AI 产品的价值。(00:47:36): 我也尝试以身作则，直接去分享我在这些不同产品中做的东西的链接或截图。例如，我会进入一个原型设计工具并展示：“嘿，我为我们要发布的新功能建立了一个营销落地页。”比如我在 Replit 中创建了一个落地页，现在我分享那个链接。而在过去，我们通常的做法是写一份文档，然后分享文档。现在我直接给你展示一个带有视觉效果和所有内容的真实落地页。(00:48:20): 或者我会分享我的深度研究报告的实际链接。或者，我不再就某个话题写一份完美的备忘录，而是直接通过提示词获得一个聊天线程或输出，基本上涵盖了我关心的所有内容，甚至可能要求它：“好，把这些全部总结成一份最终的备忘录输出”，然后刻意分享出来，展示我正在以这种方式使用 AI，以及我具体是如何提示它的，这样你也可以跟着学。(00:48:49): 真的在努力鼓励每个人去玩这些产品。我甚至说过：“看，如果有人想直接空出一整天，坦白说甚至是一整周，并且需要一个终极借口，你可以说是我让你这么做的。如果你想取消一整天或一整周的所有会议，只是为了去摆弄你能找到的每一个你认为可能与 Airtable 相关的 AI 产品，那就去做吧。句号。”所以我认为最重要的事情就是这种“玩”，这种实验。(00:49:25): 我认为在执行方式上也有很多其他转变，比如“原型重于 PPT”。我想看到实际的交互式演示，因为在 PPT 或 PRD（产品需求文档）中，你可能会说：“好吧，我们要让 Omni 非常擅长处理这类应用构建。”好吧，那只是文字。真正的证明在于：“好，让我用几个我能想象到的现实提示词来试试看。”(00:49:49): 在演示中，在真正的原型中，你可以立即在非现实而非“黄金路径”的场景中进行测试，看看感觉如何。感觉太慢了吗？我们需要展示更多幕后发生的推理或步骤吗？创建一个进度条之类的。但除了一个真正以开放方式使用 AI 来执行你输入的任何内容的实用原型之外，很难获得那种产品感觉。(00:50:24): 所以我觉得我们的执行方式更像是一个“实验游乐场”，而在过去，有时感觉更像是一种确定性的资源配置和时间线视图。我们要在这个问题上投入多少人，这是到这个里程碑的八周时间线，然后我们将在一个季度后发布。我认为现在整个过程更多是由实验和迭代驱动的。

---

### [00:51:07] Lenny Rachitsky

**English:**
Of the different functions on a product team, PM, engineering design, who has had the most success being more productive with these tools, and how do you think this will impact each of these three functions over time?

**中文翻译:**
在产品团队的不同职能中——PM、工程、设计——谁在使用这些工具提高生产力方面取得了最大的成功？你认为随着时间的推移，这将如何影响这三个职能？

---

### [00:51:07] Howie Liu

**English:**
What I found is that it really does become more about individual attitude and maybe some polymathism. There's a strong advantage to any of those three roles who can kind of cross over into the other two, like the hybrid unicorn types. (00:51:26): So if you're a designer who can be just technical enough to kind of be dangerous and understand a little bit of how these models work and how does tool calling work and all of this stuff, then you can actually design a concept or even prototype a concept, including in these prototyping tools that's much more interesting and maybe realistic than if you're just stuck in the flat like let me put something in a static design concept because I think designs have to be more interactive. The whole... The value of the product and the [inaudible 00:52:04]- (00:52:01): ... the value of the product and the product functionality is in the interaction of it, right? Think about the design of ChatGPT. Again, it's the most basic design you could possibly imagine. The real design actually is happening underneath the hood in how it responds to different queries and what happens after you fire off a prompt, right? So I think I found that there are people within each of these functions, there are engineers who are very good at thinking about product and experience and can go and prototype out the whole thing. They're designers who can do the same. Even if they can't literally code, they can prototype something out literally using a prototyping tool. (00:52:42): I think that's where AI tooling is also giving more advantage to people who can think in this way by equipping them with an alternative to actually having to go through the long hoops of learning CS, right? Then PMs as well. I think there are some PMs who are really getting into the technical details and studying up on how does this stuff work and actually getting hands-on, rather than seeing the role as writing documents, writing PRDs.

**中文翻译:**
我发现这实际上更多地取决于个人的态度，也许还有一些“博学”（polymathism）。这三个角色中，任何能够跨界到另外两个领域的人都有很强的优势，就像那种混合型的“独角兽”人才。(00:51:26): 所以，如果你是一个设计师，只要技术水平达到“略懂皮毛但足以搞出点名堂”的程度，了解这些模型是如何工作的，工具调用是如何工作的，以及所有这些东西，那么你就可以设计一个概念，甚至制作一个概念原型（包括在这些原型工具中），这比你仅仅停留在平面设计上（比如“让我做一个静态设计概念”）要有趣得多，也可能更现实。因为我认为设计必须更具交互性。产品的全部价值和……(00:52:01): ……产品的价值和功能在于它的交互，对吧？想想 ChatGPT 的设计。再说一次，那是你能想象到的最基础的设计。真正的设计实际上发生在“引擎盖”下面，在于它如何响应不同的查询，以及在你发出提示词后会发生什么。所以我发现每个职能部门都有这样的人：有些工程师非常擅长思考产品和体验，可以去把整个东西原型化；有些设计师也能做到同样的事，即使他们不会写代码，他们也可以利用原型工具把东西做出来。(00:52:42): 我认为这就是 AI 工具为这类思考者提供更多优势的地方，它为他们提供了一种替代方案，让他们不必经历学习计算机科学（CS）的漫长过程。PM 也是如此。我认为有些 PM 正在深入技术细节，研究这些东西是如何工作的，并实际动手操作，而不是把自己的角色看作是写文档、写 PRD。

---

### [00:53:08] Lenny Rachitsky

**English:**
Do you see one of these roles, I don't know, being more in trouble than others, just like you need fewer of these people in the future potentially?

**中文翻译:**
你是否认为其中某个角色面临更大的困境？比如未来可能需要更少这类人？

---

### [00:53:16] Howie Liu

**English:**
I think overall you can get more done with fewer people, and that's not to say we want to go and make the team smaller, but rather ... the really cool thing for us and I think a lot of other companies is it's not like you have a finite set of things you need to do and execute on from a product standpoint, and okay, now I can do that with a 10th of people. I mean, you could do that in a lot of cases, but for us, maybe it's also because we're a very meta product, right? We are the app platform with which you can build now any AI app with AI, right? The apps themselves leverage AI capabilities at runtime, whether it's to generate imagery for a creative production workflow or leveraging deep research, or AI-based crawling of the web to search for companies that match a certain criteria for your Dealflow app or something like that. (00:54:10): We can effectively leverage all of these other AI capabilities in this app platform, because by definition we're enabling our customers to build apps that have this wide range of AI capabilities. But because of that, it's like we have a almost infinite set of possible AI capabilities that we could execute on, right? I'm always telling the team like, "Look, the great news is it's like we have all these fruit trees and there's so many crazy low-hanging fruit, and you've got literally massive watermelons literally sitting on the ground and all you have to do is walk over 20 feet and pick it up instead of having to climb the really tall coconut tree to grab a hard coconut from 50 feet up. So there's so many watermelons on the ground, just go out and start finding the biggest ones and attacking those, right?" (00:55:03): What that means is that if we can build this culture, and I do think it's a learnable way of operating, I really like to believe in the growth potential of any human and any individual. I think if you really have a growth mindset, and that's why one of our most important core values is growth mindset, right? If you really have that growth mindset, I think especially if you're willing to put in the nights and weekends hours, or in my case I'm literally telling people like, take a full day off, take a full week off and learn this stuff, you can become more fluent in this way. I think then what we get is a team that can just go and work on more things in a much more leveraged and fast way, right? (00:55:48): So, I like to think people who are willing to jump on the train are just going to become more and more effective. It's not like, oh, as a PM my role is becoming entirely irrelevant, right? No, it means that as a PM you need to start looking more like a hybrid PM prototyper who has some good design sensibilities. By the way, I think some of the best eng PM and design cultures respectively over the past even few decades have always been multidisciplinary in nature, right? The original PM spec at Google required the PMs to actually be somewhat technical so they could understand the engineering limitations of the product designs they wanted to make, and they had to be kind of designy, right? (00:56:33): I remember my co-founder, Andrew, when he was in the APM program was always reading books about design, even down to visual design and color theory and that kind of thing, right? So I think it's just a reminder that designers as well, some of the best designers through designer to Apple, including hardware designer, you have to understand some of the technical capabilities of how this stuff works, right? If you're an engineer, I think some of the best engineers and maybe Stripe always had a very good engineering culture of engineers who could think about the product and business requirements. In fact, on any given product group, at Stripe my understanding is that the DRI isn't always the PM as is traditionally the case in that triangle. Sometimes it's actually the engineer who's taking the product lead and saying, this is what we need to build.

**中文翻译:**
我认为总的来说，你可以用更少的人做更多的事。这并不是说我们要缩小团队规模，而是……对我们以及许多其他公司来说，真正酷的一点是，从产品角度来看，你并不是只有有限的一组事情需要去做，然后现在可以用十分之一的人力来完成。我的意思是，在很多情况下你可以这样做，但对我们来说，也许是因为我们是一个非常“元”的产品。我们是一个应用平台，你现在可以用 AI 构建任何 AI 应用，对吧？应用本身在运行时利用 AI 能力，无论是为创意制作工作流生成图像，还是利用深度研究，或者基于 AI 的网页抓取来为你的 Dealflow 应用搜索符合特定标准的公。 (00:54:10): 我们可以在这个应用平台中有效地利用所有这些其他的 AI 能力，因为根据定义，我们正在使我们的客户能够构建具有广泛 AI 能力的应用。但正因为如此，我们几乎拥有无限的可能执行的 AI 能力。我总是告诉团队：“看，好消息是，这就像我们拥有所有这些果树，有这么多唾手可得的果实（low-hanging fruit），地上到处都是巨大的西瓜，你只需要走 20 英尺就能捡起来，而不需要爬上极高的椰子树去摘 50 英尺高的硬椰子。地上有这么多西瓜，去找出最大的那些并开始进攻，对吧？”(00:55:03): 这意味着如果我们能建立这种文化——而且我确实认为这是一种可以学习的运作方式，我非常愿意相信任何人和任何个体的增长潜力。我认为如果你真的拥有成长型思维（这是我们最重要的核心价值观之一），特别是如果你愿意投入夜晚和周末的时间，或者像我这样直接告诉员工“休息一整天，休息一整周去学习这些东西”，你就能在这方面变得更加流利。我认为到那时，我们得到的是一支能够以更具杠杆作用、更快速的方式处理更多事务的团队。(00:55:48): 所以，我倾向于认为那些愿意上车的人只会变得越来越高效。这并不是说，哦，作为一名 PM，我的角色正变得完全无关紧要。不，这意味着作为一名 PM，你需要开始变得更像是一个具有良好设计审美的混合型 PM 原型设计者。顺便说一句，我认为在过去的几十年里，一些最好的工程、产品和设计文化本质上一直是多学科的。Google 最初的 PM 规范要求 PM 实际上要懂一些技术，这样他们才能理解他们想要做的产品设计的工程限制，而且他们还得有点设计感。(00:56:33): 我记得我的联合创始人 Andrew 在参加 APM（助理产品经理）项目时，总是在读关于设计的书，甚至包括视觉设计和色彩理论之类的。所以我觉得这只是一个提醒：设计师也是如此，Apple 的一些顶尖设计师（包括硬件设计师）必须了解这些东西是如何运作的一些技术能力。如果你是一名工程师，我认为一些最优秀的工程师（也许 Stripe 一直有很好的工程文化）是那些能够思考产品和业务需求的工程师。事实上，在 Stripe 的任何产品小组中，我的理解是 DRI（直接负责人）并不总是传统“铁三角”中的 PM。有时实际上是工程师在担任产品负责人，并决定我们需要构建什么。

---

### [00:57:24] Lenny Rachitsky

**English:**
So, what I'm hearing is essentially the trend across product engineering design is each of those functions needs to get good at one of the other functions at least.

**中文翻译:**
所以我听到的本质上是，产品、工程、设计领域的趋势是，每个职能至少需要擅长另外一个职能。

---

### [00:57:35] Howie Liu

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:57:35] Lenny Rachitsky

**English:**
Ideally you can do them all, but if you can just do one additional, so a PM becomes better at design, an engineer becomes better at product management.

**中文翻译:**
理想情况下你可以全能，但如果你能多做一项，比如 PM 变得更擅长设计，工程师变得更擅长产品管理。

---

### [00:57:43] Howie Liu

**English:**
Well, I would actually go further and say I think you need to get decently good at all three. There's just a minimum baseline of if you're any one of those roles, you need to be minimally good at the other two, and then you can go deeper into your own specialty, right? You could be a designer who's really good at thinking about UX and interaction design, and then just good enough to be dangerous on thinking about what's technically possible and what is the product story around this feature.

**中文翻译:**
其实我会更进一步说，我认为你需要在这三方面都做得相当不错。如果你处于其中任何一个角色，都有一个最低基准：你必须至少对另外两个领域有所了解，然后你才能深入研究自己的专业。你可以是一个非常擅长思考 UX 和交互设计的设计者，同时在思考技术可行性以及围绕该功能的产品故事方面也“略懂皮毛但足以搞出点名堂”。

---

### [00:58:17] Lenny Rachitsky

**English:**
I love that. To do that, one piece of advice that comes up again and again in what you've been describing is use the tools constantly to see what's possible, and that will teach you a lot of these things.

**中文翻译:**
我喜欢这个观点。为了做到这一点，在你描述的内容中反复出现的一条建议是：不断使用这些工具，看看什么是可能的，那会教会你很多东西。

---

### [00:58:28] Howie Liu

**English:**
I think, well, use the tools gives you exposure to what's possible, right? It's kind of like if you wanted to be a great industrial designer, and let's say, I mean, the chair is the ultimate hello world of industrial design, it's the canonical design object, you wouldn't just sit there in a vacuum with no familiarity with the materials that you can use, plywood, steel, whatever, or existing form factors of chairs trying to invent the world's best chair in a vacuum, right? You should go and first do a study of all of the best chairs out there today. Go look at an Eames chair, sit in it and try to examine it to reverse engineer how it was made, and just look at the prior art for that type of product. That's how I see the go out and play with these products, and also, I think actually going and designing or implementing or executing is the best practice. (00:59:21): So you can't just only go and look at other people's chairs, eventually you have to go and actually try building your own and then try building another one and another one and another one. So, I think that's where ... when I think about how I hone my own product UX sensibilities, I never ... and at that time that I was in school and then learning about this stuff, there wasn't really any good curriculum for UX, right? It's not like there were great college classes to learn product UX. I mean, even CS was very academic in nature at that time, it wasn't applied software engineering, like build an app or whatever. Maybe now at some of the schools like Stanford, MIT, they have actually UXy type courses, but it's still a rarity for most people to have access to that. (01:00:03): So, the way I learned all of my product sensibilities was just trial and error and also using and studying other products, and then going and trying to build my own weekend project ideas, right? Oh, I want to build a Yelp style app with a map view and then also a list view, and I want it so that when you pan around in the map for it to automatically update the list view. Maybe there's some UX improvements I can make on top of that, but I can also test my technical skills to figure out which parts of this are hard to implement and how do you make it work, and what are some of the design changes or affordances that you can use to map to the technical possibilities.

**中文翻译:**
我想，使用工具能让你接触到可能性，对吧？这有点像如果你想成为一名伟大的工业设计师，比方说，椅子是工业设计的终极“Hello World”，是经典的设计对象。你不会坐在真空里，在不熟悉胶合板、钢材等可用材料，也不熟悉现有椅子形态的情况下，试图凭空发明世界上最好的椅子，对吧？你应该先去研究当今世界上所有最好的椅子。去看看伊姆斯椅（Eames chair），坐在上面，尝试检查它，逆向工程它是如何制造的，看看这类产品的现有技术。这就是我所说的“去玩这些产品”，而且我认为实际去设计、实现或执行是最好的实践。(00:59:21): 所以你不能只看别人的椅子，最终你必须亲自尝试建造自己的椅子，然后再建一把，再建一把。所以，这就是……当我思考如何磨练我自己的产品 UX 敏感度时，我从未……在那个我还在上学并学习这些东西的时代，并没有真正好的 UX 课程，对吧？并没有很棒的大学课程来学习产品 UX。我的意思是，即使是当时的 CS（计算机科学）本质上也非常学术化，不是应用软件工程，比如教你构建一个应用之类的。也许现在在斯坦福、麻省理工等学校，他们确实有 UX 类型的课程，但对大多数人来说，接触到这些仍然是罕见的。(01:00:03): 所以，我学习所有产品敏感度的方法就是不断试错，以及使用和研究其他产品，然后去尝试构建我自己的周末项目想法。比如：“噢，我想构建一个类似 Yelp 的应用，带有一个地图视图和一个列表视图，我希望当你在地图中平移时，它能自动更新列表视图。”也许我可以在此基础上做一些 UX 改进，但我也可以测试我的技术技能，弄清楚这其中哪些部分难以实现，如何让它运行，以及你可以使用哪些设计更改或示能来匹配技术可能性。

---

### [01:00:43] Lenny Rachitsky

**English:**
To do that, I loved your piece of advice, which I forgot to double down on, which I also find really powerful. The best tip there is find something to actually build that is useful to you and fun. Pick a problem you're solving that forces you to actually do this thing.

**中文翻译:**
为了做到这一点，我很喜欢你的一条建议，我刚才忘了强调，我也觉得它非常有力。最好的秘诀是：找一个对你有用且有趣的、真正需要构建的东西。选择一个你正在解决的问题，强迫你实际去完成这件事。

---

### [01:01:00] Howie Liu

**English:**
For sure. Look, I think that can be night and weekend projects, it can also be the daytime job projects, right? I mean, I am basically telling our teams on the AI platform group especially, "Look, in that low hanging fruit metaphor, it's like I'm not being prescriptive with you on which watermelons you should pick, but you should go ..." We do have different pods within that group, but one of them for instance is what we call the field agents team and they're responsible for the agents that work within your app. So this is not the agent that builds your app, but these agents that run on a customer's behalf to do web research on your customers, or they can go and analyze a document and in the future maybe do things like actually generate a prototype of a feature from a PRD or from a feature idea. (01:01:52): I'm telling them, "Look, there's a almost infinite number of superpowers you can give these field agents. I'm not going to tell you which specifically to do. Now you can ask me to weigh in for sure, but you should go and just experiment and prototype a few different directions we could go." What if you prototype what it would look like to have a deep research implementation in field agents, so that for any given row of data, let's say in your case it's podcast guests, you can just click a button or click a button en masse across every speaker you have lined up to do deep research powered by ChatGPT's own deep research on each of the speakers and have them all laid out side by side in this table, right? Go prototype that and see how it feels and looks like. So I think some of this stuff can also be in your daytime job, especially if that daytime job is literally to go and build AI functionality.

**中文翻译:**
当然。听着，我认为这可以是夜晚和周末的项目，也可以是白天的日常工作项目，对吧？我的意思是，我基本上是在告诉我们的团队，特别是 AI 平台组：“看，在那个‘唾手可得的果实’的比喻中，我不会规定你们应该捡哪一个西瓜，但你们应该去……”我们在那个组里有不同的分队，比如其中一个我们称之为“现场代理”（field agents）团队，他们负责在你的应用中运行的代理。所以这不是构建你应用的代理，而是代表客户运行的代理，比如对你的客户进行网络研究，或者去分析一份文档，未来也许还能做一些事情，比如根据 PRD 或功能想法实际生成一个功能原型。(01:01:52): 我告诉他们：“看，你可以给这些现场代理赋予几乎无限种超能力。我不会具体告诉你们该做哪一个。当然，你们可以请我参与决策，但你们应该去实验并为我们可以走的几个不同方向制作原型。”如果你们原型化了在现场代理中加入深度研究功能会是什么样子，这样对于任何给定的数据行（比如在你的案例中是播客嘉宾），你只需点击一个按钮，或者批量点击你排好队的每一位演讲者，利用 ChatGPT 自己的深度研究对每位演讲者进行研究，并将结果并排展示在这个表格中，对吧？去制作那个原型，看看感觉和外观如何。所以我认为这些事情也可以在你的日常工作中完成，特别是如果你的日常工作本身就是去构建 AI 功能。

---

### [01:02:46] Lenny Rachitsky

**English:**
I actually tried to do exactly that. The problem I ran into, I wonder if it's changed, is there's no API for ChatGPT deep research yet as far as I know.

**中文翻译:**
我其实真的尝试过这么做。但我遇到的问题是（不知道现在变了没），据我所知 ChatGPT 的深度研究（Deep Research）还没有 API。

---

### [01:02:55] Howie Liu

**English:**
There is now, there is now.

**中文翻译:**
现在有了，现在有了。

---

### [01:02:56] Lenny Rachitsky

**English:**
There is, there we go.

**中文翻译:**
有了，太好了。

---

### [01:02:58] Howie Liu

**English:**
Sometimes it ends up being ... and I think they only recently exposed it. It ends up being something on the order of a dollar plus per research call, which-

**中文翻译:**
有时它最终会变成……我想他们最近才开放。每次研究调用的成本大约在 1 美元以上，这——

---

### [01:03:05] Lenny Rachitsky

**English:**
What a deal.

**中文翻译:**
真划算。

---

### [01:03:05] Howie Liu

**English:**
... I mean, again, exactly. I mean, some people would say, oh my god, that's so expensive, and you rack up 50 of those, you've cost $50 a month. I think it's like, well, it just saved you hours of research by a human.

**中文翻译:**
……我的意思是，没错。有些人会说，天哪，太贵了，如果你累积做 50 次，一个月就要花 50 美元。我觉得这就像是，好吧，它刚刚为你节省了人类数小时的研究时间。

---

### [01:03:16] Lenny Rachitsky

**English:**
Not only that, I actually have a researcher that I pay to give me background on guests that was four or 500 bucks and the dollar sounds great. I've been doing this-

**中文翻译:**
不仅如此，我实际上雇了一个研究员，付他四五百美金来帮我做嘉宾背景调查，所以 1 美元听起来太棒了。我一直在做这个——

---

### [01:03:28] Howie Liu

**English:**
[inaudible 01:03:28]

**中文翻译:**
（听不清）

---

### [01:03:28] Lenny Rachitsky

**English:**
... I've been doing this manually.

**中文翻译:**
……我之前一直是手动做的。

---

### [01:03:29] Howie Liu

**English:**
If he was being smart he would be using deep research and they just collected [inaudible 01:03:33]

**中文翻译:**
如果他够聪明，他也会用深度研究，然后他们就收集了（听不清）

---

### [01:03:33] Lenny Rachitsky

**English:**
They might be. They might just be. Oh, man. Okay, there's one more skill I wanted to talk about real quick. This comes up a lot in these conversations is evals.

**中文翻译:**
他们可能真的在用。噢，天。好，还有一个技能我想快速聊聊。在这些对话中经常出现，那就是“评估系统”（evals）。

---

### [01:03:43] Howie Liu

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:03:43] Lenny Rachitsky

**English:**
The power of getting good at evals, I know that's something you value highly. Talk about just why you think this is something people need to get good at.

**中文翻译:**
擅长构建评估系统的力量，我知道这是你非常看重的东西。谈谈为什么你认为这是人们需要擅长的技能。

---

### [01:03:50] Howie Liu

**English:**
Yeah, and I listened to your episodes with [inaudible 01:03:54] and Mike who talked about this. I think it's interesting that both heads of OpenAI and Anthropic have converged on this point. I mean, look, I think I would add a slightly different or additive take though, which is I think for a completely novel product experience or form factor, you should actually not start with evals and you should start with vibes, right? Meaning you need to go and just test in a much more open-ended way, like, does this even work in kind of a broad sense? (01:04:28): So as an example, for our custom code generation capability, instead of defining evals that get repeatably tested as you vary the prompt or the model or the agentic workflow used to generate these outputs, and you have to define what does good look like by definition for the eval, I would first start with a much more open-ended and ad hoc style of just throw stuff against the wall, try different prompts and see how well it does. (01:05:01): To me, evals are more useful, A, once you've converged on the basic scaffold of the form factor and you kind of know what are the use cases you want it to work well for and what you want to test against it. Whereas in the early days, especially if your product market fit finding either for an entirely new company or for a pretty dramatically new or bold new capability that doesn't really have ... it's not an incremental improvement on something that exists in Airtable today, I think you have to just be a little bit more creative initially and throwing stuff at it, seeing what works to understand, okay, let's use an example, we're implementing this new capability that can use basically a long-running AI crawler agent that goes and researches the web for a specific type of object or entity, right? (01:05:55): So it's similar to deep research, but what it actually does is instead of outputting a report, it's actually going and compiling a list of things. The things could be companies or people or anything else, right? Find me every Marvel movie ever made, find me every DC Comics spin-off series, literally anything. You have to go in and first just try out a bunch of random ... use your own brain to think of what's the range of use cases I can test this against, right? Then you get back some results and you're like, okay, well, it's clear that where it does really well are these types of searches, people and companies with this kind of parameter. (01:06:42): I think to me, evals are useful once you have a sense of what is that cluster of useful use cases, you can start then more programmatically measuring the changes that you're making to improve the output for that, right? But by that point, you've probably already scoped the product and maybe the way we would merchandise it in Airtable is not a completely open-ended capability, but hey, here's a specific capability that can research one of these X number of entity types including people and companies, and here's even the filter conditions or criteria that are more explicit that you can define to give it the prompting to search for that thing, right? (01:07:25): But I kind of think it's more useful as a way to iterate your way to improvement, and you can start really testing stuff empirically, right? You can A/B test, especially if you have the scale of a really large product like Anthropic or OpenAI, you can just test everything and see like, oh, this model actually performs better than this one, this prompt performs better than this one, but I think early on you don't have that luxury and you're in a much more open-ended discovery process.

**中文翻译:**
是的，我听了你和 Mike 讨论这个话题的那几集。我觉得有趣的是，OpenAI 和 Anthropic 的负责人都汇聚到了这一点上。我的意思是，看，我想增加一个略有不同或补充的观点：我认为对于一个完全新颖的产品体验或形态，你实际上不应该从“评估系统”（evals）开始，而应该从“感觉”（vibes）开始，对吧？这意味着你需要以一种更开放的方式去测试，比如，从广义上讲这行得通吗？(01:04:28): 举个例子，对于我们的自定义代码生成能力，与其定义评估系统（当你改变提示词、模型或用于生成这些输出的代理工作流时进行重复测试，并且你必须根据定义为评估系统定义什么是“好”），我首先会从一种更开放、更随机的方式开始，就是“把东西扔到墙上看看能不能粘住”，尝试不同的提示词，看看它表现如何。(01:05:01): 对我来说，评估系统在以下情况下更有用：第一，一旦你确定了产品形态的基本框架，并且大致知道你希望它在哪些用例中表现良好，以及你想针对它测试什么。而在早期，特别是如果你正在为一家全新的公司寻找产品市场契合点，或者为一个非常戏剧性的、大胆的新功能寻找契合点（它不是对 Airtable 现有功能的增量改进），我认为你最初必须更有创意一点，向它投掷各种东西，看看什么有效，从而理解……好吧，举个例子，我们正在实现这个新功能，它基本上可以使用一个长期运行的 AI 爬虫代理，去网上研究特定类型的对象或实体，对吧？(01:05:55): 它类似于深度研究，但它实际做的不是输出报告，而是去编译一个列表。这些东西可以是公司、人或任何其他东西，对吧？“帮我找到每一部漫威电影”、“帮我找到每一部 DC 漫画衍生剧”，字面意思上的任何东西。你必须先尝试一堆随机的东西……用你自己的大脑去思考我可以测试哪些用例，对吧？然后你得到一些结果，你会发现：“好吧，很明显它在这些类型的搜索中表现得非常好，比如带有这种参数的人物和公司。”(01:06:42): 我认为对我来说，一旦你对那一组有用的用例有了感觉，评估系统就变得有用了，然后你可以开始更程序化地衡量你为了改进输出而做出的改变，对吧？但到那时，你可能已经确定了产品的范围，也许我们在 Airtable 中推销它的方式不是一个完全开放的能力，而是：“嘿，这是一个特定的能力，可以研究 X 种实体类型中的一种，包括人物和公司，这里甚至有更明确的过滤条件或标准，你可以定义它们来给它提示以搜索那个东西”，对吧？(01:07:25): 但我倾向于认为它更多是作为一种迭代改进的方式，你可以开始真正地进行实证测试，对吧？你可以进行 A/B 测试，特别是如果你拥有像 Anthropic 或 OpenAI 那样大规模的产品，你可以测试一切，看看：“哦，这个模型实际上比那个表现更好，这个提示词比那个表现更好。”但我认为在早期，你没有那种奢侈，你处于一个更开放的探索过程中。

---

### [01:07:51] Lenny Rachitsky

**English:**
That is very wise, evals could constrain you too early. I think about just the Double Diamond, I don't know, IDO framework of be divergent first, and then converge and then maybe-

**中文翻译:**
这非常明智，评估系统可能会过早地束缚你。我想到了“双钻石”模型，或者 IDEO 的框架：先发散，再收敛，然后也许——

---

### [01:08:01] Howie Liu

**English:**
Yeah. Yeah, exactly. I hadn't heard that before, but that completely resonates.

**中文翻译:**
是的。是的，没错。我以前没听过那个说法，但完全产生了共鸣。

---

### [01:08:06] Lenny Rachitsky

**English:**
Okay, let me try to reflect back some of the advice I've been hearing about how to shift a company to be successful in this new world, and let me see if I'm missing anything that you think is really important. So, one is there's this sense of just reset the expectations on pace and urgency and help people understand in AI things move incredibly fast, this is how we need to operate. Then there's also a piece of get stuff out so that you can learn how people use it and what it's capable of versus polishing it endlessly. Forcing people almost ... I don't know if forcing's the right word, but encouraging people to play with the latest stuff and giving them a chance to take days off or block out calendars, cancel meetings, just stay on top of this stuff to play as you talked about it. Then sharing things they've learned, get the vibes of what's possible. (01:08:54): There's also this idea of just rethink, okay, if we were just start today in this world, what would we do to achieve the same mission we are trying to achieve? Ideally it leverages this unfair advantage we have with things we've been working on for a long time. Then there's just talk to AI constantly every hour as you described.

**中文翻译:**
好，让我试着总结一下我听到的关于如何转变公司以在这个新世界取得成功的建议，看看我是否遗漏了你认为非常重要的内容。第一，是重新设定对节奏和紧迫感的期望，帮助人们理解在 AI 领域，事情发展得极快，这就是我们需要运作的方式。第二，是把东西发布出去，这样你就能了解人们如何使用它以及它的能力，而不是无休止地打磨。几乎是强迫人们……我不知道“强迫”这个词是否合适，但鼓励人们去玩最新的东西，给他们机会请假或封锁日历、取消会议，只是为了像你说的去“玩”以保持领先。然后分享他们学到的东西，感受可能性的“氛围”。(01:08:54): 还有这个想法：重新思考，如果我们今天在这个世界上开始，我们会做什么来实现我们正在努力实现的相同使命？理想情况下，它利用了我们长期以来一直在做的事情所带来的“不公平优势”。最后就是像你描述的那样，每小时不断地与 AI 对话。

---

### [01:09:16] Howie Liu

**English:**
For sure. Yeah, multiple times an hour, if possible.

**中文翻译:**
当然。是的，如果可能的话，一小时多次。

---

### [01:09:16] Lenny Rachitsky

**English:**
Multiple times an hour, it keeps going up. Is there anything else that I missed there that you're like, you need to do this too to have a chance?

**中文翻译:**
一小时多次，频率还在增加。还有什么我漏掉的，是你觉得“你也必须这样做才有机会”的吗？

---

### [01:09:25] Howie Liu

**English:**
I think just to really, really try to break down role silos, and I think that's true certainly for EPND in the typical EPD triangle, but I also think it's probably true even for non-product roles, right? I think it's true in marketing, right? Something I'm really pushing for in marketing and I think our marketing team is really leaning into actually is if you can just do all of the thing yourself ... traditionally how a marketing team might operate is like, okay, you have one person who's responsible for executing the performance marketing part of a campaign. They literally go into the Google AdWords interface and they're tweaking the parameters of targeting and budget and conversion tracking, et cetera, and then somebody else is actually responsible for coming up with the specific ad copy, and somebody else yet was responsible for coming up with the seed content or positioning guide written by a PMM that feeds into the ad creative, and so on and so forth, right? Maybe they're promoting some new demo asset that somebody else yet created. (01:10:35): I just think that in the same way that you can collapse the roles in EPD, and the ideal person, maybe they're very specialized and deep in one dimension like engineering, but they're well-rounded enough to be dangerous on the other two, I think that's kind of true in almost every other function, right? Sales as well, I think you should start to be able to play more of an SE role. Traditionally salespeople didn't necessarily know the product that well and relied on the SE to come in and be the product experts. I think it's really hard to sell any kind of AI product now without actually being fluent in the product and be able to demo the product, so AEs need to be SE fluent as well. (01:11:21): So I just think that that concept of collapsing roles, everybody needs to become more full stack to do the ... being more outcome-oriented, right? Your outcome as an AE is to convince customers of the value of your product and close deals, right? Okay, well, in order to do that, you used to have dependencies on having assets created by marketing and an SE to help you demo. Can you collapse more of those dependencies so that if you had to, you could do it all yourself, right? I just think it's a new operating mentality overall for every AI native company or company that wants to compete in this new arena.

**中文翻译:**
我认为就是要非常、非常努力地打破职能孤岛。这对于典型的 EPD（工程、产品、设计）铁三角来说当然是真的，但我认为对于非产品角色可能也是真的，对吧？我认为在营销中也是如此。我在营销部门极力推动的一件事（我认为我们的营销团队实际上也正在投入其中）是：如果你能自己完成所有事情……传统上营销团队的运作方式可能是：一个人负责执行活动的绩效营销部分，他们直接进入 Google AdWords 界面，调整定位、预算和转化跟踪等参数；然后另一个人负责构思具体的广告文案；还有一个人负责构思由 PMM（产品营销经理）编写的种子内容或定位指南，并将其输入到广告创意中，等等。也许他们还在推广由另一个人创建的新演示资产。(01:10:35): 我认为，就像你可以压缩 EPD 中的角色一样——理想的人选可能在工程等一个维度上非常专业和深入，但他们足够全面，在另外两个维度上也“略懂皮毛但足以搞出点名堂”——我认为这在几乎所有其他职能中都是成立的。销售也是如此，我认为你应该开始能够扮演更多的 SE（销售工程师）角色。传统上，销售人员不一定那么了解产品，而是依靠 SE 进来充当产品专家。我认为现在如果不真正熟悉产品并能够演示产品，就很难销售任何类型的 AI 产品，所以 AE（客户经理）也需要熟悉 SE 的工作。(01:11:21): 所以我只是认为这种“压缩角色”的概念，每个人都需要变得更加“全栈”以实现……更加以结果为导向，对吧？作为 AE，你的结果是说服客户相信你产品的价值并达成交易，对吧？好，为了做到这一点，你过去依赖于营销部门创建的资产和 SE 帮助你演示。你能不能压缩更多这些依赖关系，以便在必要时你可以自己完成所有工作？我只是认为，对于每一家 AI 原生公司或想要在这个新领域竞争的公司来说，这是一种全新的整体运营心态。

---

### [01:12:06] Lenny Rachitsky

**English:**
That is a great addition. It almost feels like you go back to startup times when everyone's doing a bunch of stuff. There's no here's the head of product, here's the head of engineering, we're just doing stuff- (01:12:06): Totally. (01:12:16): ... that needs to be done.

**中文翻译:**
这是一个很好的补充。感觉就像回到了初创时期，每个人都在做一堆事情。没有所谓的“这是产品负责人”、“这是工程负责人”，我们只是在做——(01:12:06): 完全正确。(01:12:16): ……那些需要被完成的事情。

---

### [01:12:17] Howie Liu

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [01:12:18] Lenny Rachitsky

**English:**
Yeah, I'm kind of seeing it as this upside down T where there's the thing you're really strong at and then as you described, the minimum of being good at engineering design or ... and SE, by the way, sales engineering imagine is what that stands for. Adjacent roles, you need to start having a baseline. The baseline is increasing of how much you need to understand that, everyone's Venn diagrams are kind of converging.

**中文翻译:**
是的，我把它看作是一个倒 T 型：有你非常擅长的东西，然后正如你所描述的，在工程、设计或……顺便说一句，SE 应该是销售工程（Sales Engineering）的缩写。对于相邻的角色，你需要开始有一个基准。你对这些领域的理解基准正在提高，每个人的韦恩图都在趋于融合。

---

### [01:12:40] Howie Liu

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:12:42] Lenny Rachitsky

**English:**
Amazing. Okay, let me take a step back and zoom out and think about the broader journey you've been on over the past decade plus. Let me just ask you this, what's the most counterintuitive lesson you've learned about Airtable building and company building teams that maybe goes against common startup wisdom?

**中文翻译:**
太棒了。好，让我退后一步，放大视野，思考一下你在过去十多年里经历的更广泛的旅程。我想问你：关于构建 Airtable 和组建公司团队，你学到的最反直觉的教训是什么？也许是违背了常见的初创公司智慧的。

---

### [01:13:02] Howie Liu

**English:**
I heard your interview with Brian Chesky and then later you talked about founder mode in that YC retreat, and the points there really, really resonated with me. I feel like maybe less eloquently I deduced some of the same principles just in my own experience, which is I think when you're scaling up, and this relates also to what we talked about before around the early days of building a company, you're in the details, you're finding product market fit, you kind of have to be pretty versatile, right? All these decisions from a technical standpoint to design, to even commercial, and what's the freemium model going to be like? And how are we going to market this product? What does the website look like? They're all very intertwined, right? You can't compartmentalize and then almost factory produce each of these things separately. They're all intertwined and you have a very small tight-knit team that's thinking full stack about all of this combined. (01:14:04): Obviously that's the only way, in my opinion, to create that magical product market fit in the first place. Then I think as you scale up, the default guidance that you often get from operational experts and larger scale company investors is like, okay, you got to industrialize the process of all of this stuff, right? It's kind of like going from a bespoke artisanal, one person made an entire item of clothing to we got to factory produce this thing, right? (01:14:38): What that means in an organizational context is you then create these different fiefdoms, you hire all these execs and each exec just manages their own swim lane, and there's relatively looser coupling between all of those different groups, right? So then you've got sales executing on its own thing, marketing's executing on its own thing, product's executing on its own thing. Even within product there's different product groups and surface areas that are each executing on their own thing. (01:15:05): Using the factory metaphor of there's an argument that that's actually kind of an efficient way to scale up production for each of these different swim lanes, right? Each one can operate in a more autonomous and purely scale up focus, wait, how do we produce more of this thing? If the thing happens to be within one product group improving search, that's our main focus. We're just going to go and ship, ship, ship more stuff to improve search. So it's not completely crazy why people give this advice, but I think what you lose is the magical integrative value of holistic thinking and making the bigger picture bets, right? (01:15:48): I think Brian talked a lot about this on his episode with you, which is like, look, in a company that is really serious about product, first of all, I really liked his point about the CEO has to play a CPO role, you have to care about the product. Ultimately the product is the thing and you can't just coast on scaling up go-to-market around the product forever, you got to keep innovating on the product. By the way, the best way to innovate on the product is not incrementally split over all these different little surface areas, but actually to have a bigger, more step function vision of how this product needs to make a leap, or what's the next big either act of the product or new capability of the product or reinvention of the product, right? (01:16:35): So I think if you really care about doing that from a product execution standpoint and almost refinding new product market fit on a regular basis, I think it necessitates a completely different operating and leadership model throughout the organization. All of the stuff we just talked about in terms of how to operate in the AI native era I think is actually exactly the same as how you need to operate in this constant product market refinding of fit state. (01:17:02): So I could not agree more with that concept of you got to think ambitiously and move the organization holistically towards these bigger outcomes, but also ship and learn and experiment a lot more in this era. Then maybe the meta learning I had from all of the above is that the specific advice obviously was like, okay, go scale up in this way or go hire these types of people, experienced operators, et cetera. Now, obviously there's some truth to that, right? The people giving this advice are not incompetent. They had some reason for giving it and in certain contexts that is the right thing to do, but I think my meta learning is it's not enough to just trust the recommendation, like, here's the action you should take from a lot of people, 'cause everybody has different priors and it's almost like we're all our own LLMs, and we all have different training from a different corpus of data informed by our own experiences. Maybe you're trained on the service- (01:18:00): ... experiences, and maybe you're trained on like the kind of ServiceNow or the Oracle training corpus, and this person's trained on the Facebook corpus, and I'm trained on the Airtable one. I think what I've tried to do more and more is not to just ignore advice from smart people. Obviously, that's not the right answer, but to kind of take their... It's almost like in an LLM you can now with a reasoning model actually inspect the chain of thought and see how it's thinking. Why did it come up with this answer? To me, that chain of thought like "Why did you recommend this?", is actually more informative than the actual, "Just do this recommendation." (01:18:44): The answer might be like, "Hey, at So-and-So company, this is how we eliminated the PM role entirely." For Brian at Airbnb, it made sense. We're no longer having PMs in their traditional form. Now, we have program managers and product marketers, but more than the actual decision because I don't think it's a one-size-fits-all, everybody should do the same, why did you do that? The why actually was very informative, and then be able to take that and say like, "Okay, how would I apply that?" Maybe it yields a different outcome, but the reasoning actually is very informative.

**中文翻译:**
我听了你对 Brian Chesky 的采访，后来你在 YC 闭门会上谈到了“创始人模式”（founder mode），那里的观点真的、真的让我产生了共鸣。我觉得我可能没那么雄辩，但我根据自己的经验推导出了同样的原则。那就是，我认为当你扩大规模时（这也与我们之前谈到的公司成立初期有关），你深入细节，你在寻找产品市场契合点，你必须非常全能，对吧？从技术角度到设计，甚至到商业决策，所有的决定——免费增值模式会是什么样？我们如何营销这款产品？网站长什么样？它们都是交织在一起的，对吧？你不能把它们隔离开来，然后像工厂生产一样分别处理。它们是交织在一起的，你有一个非常小且紧密的团队，在全栈式地思考所有这些事情的结合。(01:14:04): 在我看来，这显然是最初创造神奇的产品市场契合点的唯一方法。然后我认为随着规模的扩大，你经常从运营专家和大型公司投资者那里得到的默认指导是：好吧，你必须把所有这些事情的流程工业化，对吧？这有点像从一件由一个人手工制作的定制艺术品，转变为我们必须工厂化生产这件东西，对吧？(01:14:38): 在组织背景下，这意味着你随后创建了这些不同的“领地”，你雇佣了所有这些高管，每个高管只管理自己的“泳道”，这些不同小组之间的耦合相对较松，对吧？所以销售在执行自己的事情，营销在执行自己的事情，产品在执行自己的事情。甚至在产品内部，也有不同的产品组和领域，每个组都在执行自己的事情。(01:15:05): 使用工厂的比喻，有一种观点认为这实际上是扩大每个不同泳道生产效率的一种有效方式，对吧？每个泳道都可以以更自主、纯粹关注规模化的方式运作：“等等，我们如何生产更多这种东西？”如果这件事恰好是在一个产品组内改进搜索，那就是我们的主要焦点。我们就去不断发布、发布、发布更多东西来改进搜索。所以人们给出这种建议并非完全疯狂，但我认为你失去的是整体思考和进行大局押注的神奇整合价值，对吧？(01:15:48): 我认为 Brian 在你那一集里谈了很多关于这一点，即：看，在一家真正重视产品的公司里，首先，我很喜欢他的观点，即 CEO 必须扮演 CPO（首席产品官）的角色，你必须关心产品。最终产品才是核心，你不能永远只靠围绕产品扩大市场规模来维持，你必须不断创新产品。顺便说一句，创新产品的最佳方式不是增量地分散在所有这些不同的小领域，而是实际上要有一个更大的、更具阶跃性的愿景，即这个产品需要如何实现飞跃，或者产品的下一个重大行动、新能力或重新发明是什么，对吧？(01:16:35): 所以我认为，如果你真的关心从产品执行的角度出发，并几乎定期重新寻找新的产品市场契合点，我认为这需要在整个组织中建立一个完全不同的运营和领导模式。我们刚才谈到的关于如何在 AI 原生时代运作的所有内容，我认为实际上与你在这种“不断重新寻找产品市场契合点”的状态下需要运作的方式完全一样。(01:17:02): 所以我非常同意那个概念，即你必须雄心勃勃地思考，并让组织整体朝着这些更大的结果迈进，但在这个时代也要进行更多的发布、学习和实验。然后，我从上述所有内容中得到的“元学习”是：具体的建议显然是，好吧，以这种方式扩大规模，或者去雇佣这些类型的人、经验丰富的运营者等等。显然，这其中有一定的道理，对吧？给出这些建议的人并非无能。他们给出建议是有原因的，在某些背景下那是正确的做法。但我的元学习是，仅仅信任推荐是不够的，比如很多人给出的“你应该采取这个行动”，因为每个人都有不同的先验知识（priors），这几乎就像我们都是自己的 LLM，我们都接受过来自不同数据语料库的训练，并受到我们自己经验的影响。也许你是在服务型——(01:18:00): ……经验上受训的，也许你是在类似 ServiceNow 或 Oracle 的训练语料库中受训的，而这个人是在 Facebook 的语料库中受训的，我是在 Airtable 的语料库中受训的。我认为我尝试做得越来越多的是，不要仅仅忽视聪明人的建议。显然，那不是正确的答案，而是去获取他们的……这有点像在 LLM 中，你现在可以通过推理模型实际检查思维链（chain of thought），看看它是如何思考的。它为什么会得出这个答案？对我来说，那个思维链（比如“你为什么要推荐这个？”）实际上比实际的“就做这个推荐”更有信息量。(01:18:44): 答案可能是：“嘿，在某某公司，我们就是这样完全取消了 PM 角色的。”对于 Airbnb 的 Brian 来说，这行得通。我们不再拥有传统形式的 PM，现在我们有项目经理和产品营销人员。但比起实际的决定（因为我不认为这是一刀切的，每个人都应该做同样的事），更重要的是“你为什么要那样做？”那个“为什么”实际上非常有启发性，然后能够接受它并说：“好吧，我该如何应用它？”也许它会产生不同的结果，但推理过程实际上非常有启发性。

---

### [01:19:19] Lenny Rachitsky

**English:**
It's interesting how this idea founder mode is not so different from this ICCO trend that you're following and it's- (01:19:26): For sure. (01:19:26): ... yeah, yeah, it's like being in the weeds, being in the details, trying things yourself, not delegating to execs.

**中文翻译:**
有趣的是，“创始人模式”这个想法与你正在遵循的“IC 型 CEO”趋势并没有那么大的不同，而且它——(01:19:26): 确实如此。(01:19:26): ……是的，是的，就像深入基层，深入细节，亲自尝试，而不是仅仅授权给高管。

---

### [01:19:32] Howie Liu

**English:**
Yeah, and I think anything taken to an extreme can be problematic. There is a world where you are so in the details and in every detail that you're basically just micromanaging and you're kind of creating like a euphemism for that. That's not really what founder mode is about. That's not like the Brian conception of founder mode is to like micromanage everything and not trust anyone, but I think it's more about finding that right balance of being unabashed about caring about the details that do matter and where the tying together of details across different groups or departments actually is the only way to yield a non-incremental outcome. Otherwise, each person is just optimizing within their own domain, but you'll never get to the global maxima or the global breakthrough. (01:20:23): I think the really cool thing about CEOs as I seize it, frankly any leader playing more of an IC-like role and being in the details is I think for the right type of person, it's actually more fun that way. I mean, to be honest, for me, the times where I felt most disintermediated from what I felt was the substance of this company was when I thought that I was almost like forcing myself to step away from the details. I thought that's what a at-scale CEO was supposed to do. I mean, there's some famous CEOs who have talked about, "The less decision I could make the better. The less details I'm exposed to the better. I just want to inspect at the topmost layer how this business is running, and if everything underneath it is going smoothly, then I'm able to do that and everything looks good." (01:21:19): I just think that's maybe, again, it works in a certain type of very mature type of business. Even then, though, I can't imagine that at a CPG company like a Procter & Gamble. You wouldn't want to have a CEO who still actually goes and tastes the soup and tries the products and sees literally the details of what the new product innovation pipeline looks like, as well as like how it's being experienced on the shelves and so on. I don't know. I guess I'm just more and more skeptical that that hands-off pure delegation and process management role ever works as a CEO. Maybe you go through a long enough period of where the business is coasting that nobody notices, but I got to say, for me it's just much more invigorating to get to play that role. I think for the types of operators and leaders that I most admire, that's what makes the job interesting. They don't want to have a automated away kind of role as a leader.

**中文翻译:**
是的，我认为任何事情走向极端都会有问题。在某种情况下，如果你如此深入细节，以至于在每一个细节上都纠缠不清，那你基本上就是在进行微观管理，而你只是在为此创造一个委婉的说法。那并不是创始人模式的真谛。Brian 所构想的创始人模式并不是要微观管理一切且不信任任何人，我认为它更多是关于找到正确的平衡：理直气壮地关心那些真正重要的细节，并且意识到跨不同小组或部门将细节结合起来，实际上是产生非增量结果的唯一途径。否则，每个人都只是在自己的领域内进行优化，你永远无法达到全局最大值或全局突破。(01:20:23): 我认为，关于 CEO 转型为 IC（坦白说，任何领导者扮演更多类似 IC 的角色并深入细节）真正酷的一点是，对于合适类型的人来说，那样实际上更有趣。我的意思是，老实说，对我来说，我觉得自己与这家公司的实质内容脱节最严重的时期，是我认为自己几乎在强迫自己远离细节的时候。我当时认为那是规模化公司的 CEO 应该做的。我的意思是，有一些著名的 CEO 曾说过：“我做的决定越少越好。我接触的细节越少越好。我只想在最顶层检查业务运行情况，如果下面的一切都进展顺利，那么我就能做到这一点，一切看起来都很好。”(01:21:19): 我只是认为那也许……再次强调，它在某种类型的非常成熟的业务中有效。但即便如此，我也无法想象在像宝洁（P&G）这样的消费品公司，你会不希望有一个 CEO 仍然实际去“品尝汤的味道”，去尝试产品，去亲眼看看新产品创新流水线的细节，以及产品在货架上的体验等等。我不知道。我想我越来越怀疑那种“甩手掌柜”式的纯粹授权和流程管理角色是否真的能胜任 CEO。也许你经历了一段足够长的业务平稳期，以至于没人注意到，但我必须说，对我来说，扮演那个角色要更有活力得多。我认为对于我最钦佩的那类运营者和领导者来说，这正是工作的有趣之处。他们不希望作为一个领导者，自己的角色被自动化掉。

---

### [01:22:22] Lenny Rachitsky

**English:**
If you could go back in time and whisper something in a decade-ago Howie's ear that would have saved you a lot of pain and suffering over the last decade, what would that be?

**中文翻译:**
如果你能回到过去，在十年前的 Howie 耳边低声说一句话，从而让你在过去十年里少受很多痛苦和折磨，那会是什么？

---

### [01:22:33] Howie Liu

**English:**
Don't step away from the details that both you love. I mean, first of all, if your passion is building product and product design, even if it feels like at times the company needs to do all this other stuff like scale up, go to market, and operations and just have like a large people organization, that itself creates a lot of need to do things and manage. There becomes a new job invented just to manage a larger group of people, and obviously you're going to have to do some of that. You can't just completely eschew all your responsibility as an at-scale CEO, but don't lose the essence of the thing that you love doing and that really made this product happen and gives this company as many companies that were founded on a magical product market fit finding insight. Don't step too far away from that, and always make sure that is still your number one, even if other stuff has to also add to your plate.

**中文翻译:**
不要远离你所热爱的细节。我的意思是，首先，如果你的热情是构建产品和产品设计，即使有时感觉公司需要做所有这些其他事情（如扩大规模、进入市场、运营以及管理一个庞大的人员组织），那本身就会产生大量的事务和管理需求。会产生一种专门为了管理一大群人而发明的新工作，显然你必须承担其中一部分。作为一名规模化公司的 CEO，你不能完全回避所有的责任，但不要失去你热爱做的事情的本质，正是这些事情促成了这款产品，并赋予了这家公司（就像许多建立在神奇的产品市场契合点洞察之上的公司一样）生命力。不要离那太远，始终确保那仍然是你的头等大事，即使其他事情也必须加入到你的任务清单中。

---

### [01:23:45] Lenny Rachitsky

**English:**
I think people don't talk enough about this how if someone starts a company that's an idea they have they're excited about, it takes off and then you're stuck on that for a long time, and then even if things are pushed in a direction you're not as excited about. This point about just remembering what you actually love about it and coming back to that is so important because that's the only way to keep doing this for a long time.

**中文翻译:**
我认为人们对这一点的讨论还不够：如果有人创办了一家公司，那是他们兴奋的一个想法，公司起飞了，然后你就被困在其中很长时间，甚至事情被推向了一个你并不那么兴奋的方向。关于“记住你真正热爱它的地方并回归初心”这一点非常重要，因为那是长期坚持下去的唯一方法。

---

### [01:24:05] Howie Liu

**English:**
I think that's so true, and to me that's why there's always been a difference between entrepreneurs who love the act of building a product or the business, too, versus those who saw a just purely business or financial opportunity that they felt like they couldn't pass up exploiting or going after. Look, no knock on people who are more the latter, and there's entire industries where it's all just about alpha generation. You can go into the private equity business and so on, and it's just purely it's rationally about how do I find the alpha? I think that some of the best companies, product central companies, at least in my opinion, are run by those people who actually just love the product. I think you get a feel for that from some of the AI companies like Sam, I think genuinely just loves working on AI. (01:25:03): If he could spend a hundred percent of his time on just being close to the AI and the research, I mean, he would and he's even said as much. Ranging to like Brian's with Airbnb, it's pretty clear that people like this are not motivated like... Airbnb was not founded because like, "Oh my God, we want to make a lot of money off this arbitrage opportunity against hotels."

**中文翻译:**
我认为非常正确。对我来说，这就是为什么热爱构建产品或业务的创业者，与那些仅仅看到纯粹的商业或财务机会并觉得不能错过的人之间总是有区别的。听着，我并不是在贬低后者，有些行业完全就是关于创造“超额收益”（alpha）的。你可以进入私募股权行业等等，那纯粹是理性地思考“我如何找到超额收益？”但我认为，至少在我看来，一些最好的、以产品为中心的公司，是由那些真正热爱产品的人经营的。我认为你可以从一些 AI 公司感受到这一点，比如 Sam，我认为他纯粹就是热爱研究 AI。(01:25:03): 如果他能把 100% 的时间都花在接近 AI 和研究上，他会这么做的，他甚至也这么说过。再到像 Brian 的 Airbnb，很明显这类人的动力不是……Airbnb 的创立并不是因为“噢我的天，我们想通过这个针对酒店的套利机会赚大钱”。

---

### [01:25:24] Lenny Rachitsky

**English:**
They just needed to pay their rent.

**中文翻译:**
他们当时只是需要付房租。

---

### [01:25:26] Howie Liu

**English:**
Yeah. Well, that and I think they loved the product and I think they also loved the way in which they built the product, the design-centric nature of that product and company and culture. That's what gives you the continued joy of working on what could be the same company for a very long time.

**中文翻译:**
是的。嗯，除此之外，我认为他们热爱这款产品，我也认为他们热爱他们构建产品的方式，即该产品、公司和文化的以设计为中心的本质。这就是让你在同一家公司工作很长时间仍能获得持续快乐的原因。

---

### [01:25:45] Lenny Rachitsky

**English:**
Howie, is there anything else that you wanted to touch on or leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
Howie，在我们进入非常精彩的闪电轮环节之前，你还有什么想补充或留给听众的吗？

---

### [01:25:51] Howie Liu

**English:**
I just want to reiterate, especially for listeners here who are in an EP or D role and especially in the P role, I really do believe that this is not like you either have or you don't like in terms of the skill set needed to be relevant and AI needed, but I do think it's a call to action to go and bolster your skill sets where they may be less refined right now. I think even programming, I really believe everyone could learn how to be a software engineer if they wanted to. Now, obviously, some people just as with like great writers are never going to be a published author or the Hemingway, but everyone can gain a good enough proficiency of software engineering if they really wanted to. (01:26:39): You could take that boot camp. You could do like some coding exercises on the side, et cetera. The point there is that sometimes I think we treat these disciplines like hard, hard skills that if you're already halfway into your career and you're not already an engineer, if you're not already a designer, okay, well, you can never be one. I just think our brains are malleable and there's a lot of great curriculum out there to learn. Lot of it, like I said, just comes down to also like trial and error and building projects, maybe nights and weekends projects even to learn this stuff. Everyone can learn how to be a versatile kind of unicorn product engineer/designer hybrid in the AI-native era. The only thing stopping you is just going out and doing it.

**中文翻译:**
我只想重申，特别是对于这里从事 E、P 或 D 角色（尤其是 P 角色）的听众，我真的相信，在保持相关性和满足 AI 需求所需的技能组合方面，并不是“要么有，要么没有”，但我认为这是一个行动号召，去加强你目前可能还不够精炼的技能。我认为甚至是编程，我真的相信如果愿意，每个人都可以学习如何成为一名软件工程师。现在，显然，就像伟大的作家一样，有些人永远不会成为出版作家或海明威，但如果真的想学，每个人都可以获得足够熟练的软件工程能力。(01:26:39): 你可以参加训练营，你可以利用业余时间做一些编程练习等等。我想说的是，有时我们把这些学科看作是“硬核技能”，认为如果你已经职业生涯过半却还不是工程师或设计师，那么你就永远不可能成为其中之一。我只是认为我们的大脑是具有可塑性的，而且有很多很棒的课程可以学习。正如我所说，其中很大一部分归结为试错和构建项目，甚至是利用夜晚和周末的项目来学习这些东西。在 AI 原生时代，每个人都可以学习如何成为一名全能的“独角兽”型产品工程师/设计师混合体。唯一阻碍你的就是去付诸行动。

---

### [01:27:30] Lenny Rachitsky

**English:**
That is a really empowering way to end it, and just to double down on that, it's never been easier to learn these things. There are super intelligences that you can talk to that do a lot as they're building can help you learn.

**中文翻译:**
这是一个非常有力量的结尾。而且我想强调的是，学习这些东西从未像现在这样容易。你可以与“超级智能”对话，它们在构建过程中可以做很多事情来帮助你学习。

---

### [01:27:43] Howie Liu

**English:**
Yeah. I mean, literally, I go into ChatGPT sometimes and I ask it just like, "Hey, how would you build this app?" I'm just curious. I'm like, "How would you build Manus, the open-ended agent?" Literally, how would you build it? You can ask the questions and it's like having an amazing, brilliant software architect, software engineer, product manager, designer expert tutor that you can literally like there's no dumb question. They have infinite patience. They're literally on and awake 24/7. It is the most incredible time to learn this stuff, to your point. Then, of course, the interactive tools to go and actually build stuff. Anyone can download Cursor and just start asking Composer to generate some code for you, and then looking at the code and trying to figure out what it does. To your point, when I think back to the earliest era that I experienced of building apps, first I learned C++, then I learned PHP and JavaScript and even building kind of JavaScript single-page apps in the early days like '08 through 2010. It was a dark, dark art. I mean, there were some like... You just had to go and like learn some of these things. There wasn't great tutorials for it. You had to reverse engineer certain things. There were just weird things like if you wanted rounded corners in your UI, you literally took Photoshop, opened it up, created like a rounded corner in pixels, and then cut that pixel up into an image that you dropped onto the page at exactly the right position to be at the edge of a box. (01:29:15): It's like crazy stuff. I mean, everything was so much more arcane at the time, and now it feels so much more fluid and accessible, and the gap between the arcane tech that you have to wade through to build something has just been minimized so much. It's like the effort and abstraction between you and the magical, delightful actual building of the thing that you want has been so minimized. It's never been a more exciting time to be a builder.

**中文翻译:**
是的。我的意思是，字面意思上，我有时会进入 ChatGPT 问它：“嘿，你会如何构建这个应用？”我只是好奇。我会问：“你会如何构建 Manus 这个开放式代理？”字面意思上的“你会如何构建它？”你可以提问，这就像拥有一个令人惊叹的、才华横溢的软件架构师、软件工程师、产品经理、设计师专家导师，你真的可以……没有愚蠢的问题。他们有无限的耐心。他们字面意思上是 24/7 全天候在线且清醒的。正如你所说，这是学习这些东西最不可思议的时代。然后，当然，还有去实际构建东西的交互式工具。任何人都可以下载 Cursor，开始让 Composer 为你生成一些代码，然后查看代码并尝试弄清楚它的作用。就你所说的，当我回想起我经历过的最早的构建应用的时代，我先学了 C++，然后学了 PHP 和 JavaScript，甚至在 2008 到 2010 年的早期构建 JavaScript 单页应用。那是一门“黑暗艺术”。我的意思是，你必须去学习其中的一些东西，当时没有很好的教程。你必须逆向工程某些东西。还有一些奇怪的事情，比如如果你想在 UI 中实现圆角，你真的要打开 Photoshop，创建一个像素级的圆角，然后把那个像素切成一张图片，把它放在页面上精确的位置，作为盒子的边缘。(01:29:15): 简直是疯狂的事情。我的意思是，当时的一切都显得那么晦涩难懂，而现在感觉如此流畅和易于获取，你为了构建某样东西而必须跋涉的晦涩技术鸿沟已经被大大缩小了。你与想要构建的神奇、令人愉悦的事物之间的努力和抽象层已经被降到了最低。作为一个构建者，从未有过比现在更令人兴奋的时刻。

---

### [01:29:47] Lenny Rachitsky

**English:**
You remember spacer.gif?

**中文翻译:**
你还记得 spacer.gif 吗？

---

### [01:29:49] Howie Liu

**English:**
Oh yeah, yeah.

**中文翻译:**
噢是的，记得。

---

### [01:29:50] Lenny Rachitsky

**English:**
It's like to create. It's that line stuff you just kind of have-

**中文翻译:**
就像是为了创造间距。就是那种你不得不用的——

---

### [01:29:52] Howie Liu

**English:**
Yeah, I remember it. Yeah.

**中文翻译:**
是的，我记得。

---

### [01:29:54] Lenny Rachitsky

**English:**
... the invisible one-pixel thing that you just stick in places.

**中文翻译:**
……那个你随处乱塞的不可见的 1 像素的小东西。

---

### [01:29:57] Howie Liu

**English:**
Yeah. Yeah, yeah. No.

**中文翻译:**
是的，没错。

---

### [01:29:57] Lenny Rachitsky

**English:**
Oh my God, what a time to be alive. Howie, with that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
噢天哪，活在这个时代真好。Howie，说到这，我们进入了非常精彩的闪电轮环节。我有五个问题问你。准备好了吗？

---

### [01:30:05] Howie Liu

**English:**
Yes.

**中文翻译:**
准备好了。

---

### [01:30:05] Lenny Rachitsky

**English:**
Here we go. What are two or three books you find yourself recommending most to other people?

**中文翻译:**
开始。你最常向别人推荐的两三本书是什么？

---

### [01:30:09] Howie Liu

**English:**
You know, I've been trying to read fiction more, partly because I think it's just a really nice mental reset. I will say like Three-Body Problem for anyone who hasn't read it, it's a mind-expanding book. I like sci-fi and fiction that kind of opens your brain, so maybe this is my cheat card, but it's a three-book series. Those are three great books.

**中文翻译:**
你知道，我一直尝试多读一些小说，部分原因是我认为这是一种非常好的心理重置。我会向任何没读过的人推荐《三体》（Three-Body Problem），这是一本拓展思维的书。我喜欢那种能开启大脑的科幻小说和虚构作品，所以这可能是我的“作弊卡”，但这是一套三部曲。那是三本伟大的书。

---

### [01:30:30] Lenny Rachitsky

**English:**
I love that series, and my tip there is it gets good one and a half books in is my tip, so just keep reading. That's where it's like, "Okay, now I'm in."

**中文翻译:**
我喜欢那个系列，我的建议是：读到一本书半的时候才开始变得精彩，所以请坚持读下去。那是你会觉得“好，我入戏了”的地方。

---

### [01:30:40] Howie Liu

**English:**
I liked even the first one, but I felt like it was inception where every subsequent book was like you dropped into another, like you incepted into another layer, right?

**中文翻译:**
我甚至连第一本都很喜欢，但我觉得它就像《盗梦空间》，每一本后续的作品都像是你掉进了另一个层面，就像你进入了另一层梦境，对吧？

---

### [01:30:53] Lenny Rachitsky

**English:**
Awesome. Okay. What's a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
太棒了。好。最近你非常喜欢的电影或电视剧是什么？

---

### [01:30:57] Howie Liu

**English:**
TV show, I just started watching The Studio. It's like the Seth Rogen, Rogen.

**中文翻译:**
电视剧的话，我刚开始看《制片厂》（The Studio）。就是 Seth Rogen 演的那个。

---

### [01:31:05] Lenny Rachitsky

**English:**
Yeah, it's so stressful.

**中文翻译:**
是的，那部剧压力很大。

---

### [01:31:05] Howie Liu

**English:**
Yep. Yeah, it is pretty stressful, and I mean, Silicon Valley was too close to home when it came out, so I watched it, but it was just cringy. The Studio is kind of fund to watch because it's a little bit about like inside baseball of Hollywood, and yet I'm not in Hollywood, so it's entertaining to watch. It's I thought smart and a funny show because I split time between L.A. and S.F. I also feel like it's very real to me. I see a lot of the literal characters out there in the world that it's characterizing.

**中文翻译:**
是的，压力确实挺大。我的意思是，《硅谷》（Silicon Valley）刚出来时离我的生活太近了，所以我看了，但感觉很尴尬。《制片厂》看起来挺有意思，因为它有点像好莱坞的内部圈子，而我不在好莱坞，所以看起来很有娱乐性。我觉得这是一部聪明且有趣的剧，因为我往返于洛杉矶和旧金山之间。我也觉得它对我来说非常真实。我在现实世界中看到了很多它所刻画的那些典型人物。

---

### [01:31:43] Lenny Rachitsky

**English:**
Do you have a favorite product you recently discovered that you really love? Could be an app, could be gadget, could be clothing.

**中文翻译:**
你最近发现并非常喜欢的某个产品吗？可以是应用、小工具或衣服。

---

### [01:31:48] Howie Liu

**English:**
Okay, so I'll give two because I feel like I have to say some kind of software product. I mean, I'm a really big fan of Runway, the product and the company. I just think every new model they come out with, they just came out with a new one just I think like two days ago that gives even more controls and refinement on creating exactly the video scene that you want. I think just the photorealism in what you can generate now, and they also built this cool demo thing that's an immersive world generator I mentioned before. I think it's just cool to see. I also like the underdog story. I'm clearly like Google's gunning in the space, has VO3 and so on and has its OpenAI, but I love the underdog story of this sub-hundred-person company still punching above their weight and building really awesome video experiences. That's the software one. (01:32:45): Then, a very, very kind of nerdy real-world answer on product is I kind of just recently got into this whole cottage industry of artisanally produced basically clothing by small-scale Japanese manufacturers that use literally like hundred-year-old looms to make clothes the old-fashioned way or the old-fashioned industrial way. They have these loop wheeler machines and they spin the cloth in a very slow pace, so it's completely impractical from a production-scale standpoint, but I've gotten some of these t-shirts and I just love the... I guess in a world where it feels like everything is becoming so much faster moving and even tech from five years ago is obsolete, I love a little bit of the throwback to like old things sometimes can be even more cherishable in this new era. Maybe that makes me a hipster, but I love the vintage, the retro increasingly these days.

**中文翻译:**
好，我给两个，因为我觉得我必须说一种软件产品。我的意思是，我是 Runway（产品和公司）的忠实粉丝。我认为他们推出的每一个新模型——我想大约两天前刚出了一个新模型——在精确创建你想要的视频场景方面提供了更多的控制和精细化。我认为现在能生成的图像真实感非常惊人，他们还构建了我之前提到的那个酷炫的沉浸式世界生成器演示。我觉得看到这些很酷。我也喜欢“小人物逆袭”的故事。显然 Google 正在这个领域发力，有 VO3 等等，还有 OpenAI，但我喜欢这家不到一百人的公司仍然能超水平发挥，构建出非常棒的视频体验。这是软件方面的。(01:32:45): 然后，关于产品的一个非常“极客”的现实世界答案是：我最近迷上了由日本小型制造商手工生产的服装行业，他们真的使用百年历史的织机，以老式或老式工业方式制作衣服。他们有这些吊篮织机（loop wheeler machines），以非常慢的速度纺织布料，所以从生产规模的角度来看完全不切实际。但我买了一些这种 T 恤，我非常喜欢……我想在一个感觉一切都在飞速发展、甚至五年前的技术都已过时的世界里，我喜欢这种回归——在这一新时代，旧事物有时甚至更值得珍惜。也许这让我看起来像个文青（hipster），但我最近越来越喜欢复古和怀旧的东西。

---

### [01:33:56] Lenny Rachitsky

**English:**
I feel like anything that starts with artisanal small batch Japanese is going to be really good stuff. Is there a brand you want to share that is that? Or is this like you want to keep it- (01:33:56): Yeah. No, I mean- (01:34:06): ... under the radar.

**中文翻译:**
我觉得任何以“手工、小批量、日本”开头的东西都会是非常棒的东西。有什么你想分享的品牌吗？还是说你想保持——(01:33:56): 是的。不，我的意思是——(01:34:06): ……低调一点。

---

### [01:34:07] Howie Liu

**English:**
... actually, so Self Edge, which actually has a storefront, the main storefront is on Valencia Street in S.F. They carry a lot of these items. That's kind of their whole MO and they have like jeans and t-shirts. I've gotten a lot. I mean, they basically curate a really good selection of different actual makers. One of them is called Studio D'Artisan, another one's called... Actually, it's cool. There's this company called... I think the umbrella company is actually just Toyo, T-O-Y-O, Manufacturing, which sounds like it's a big kind of like large-scale conglomerate, but it's anything but. It's like a really small-scale Japanese vintage manufacturer of clothing, but they have a few sub-brands. (01:34:51): They actually bought the rights to this American post-war brand that was kind of like Hanes, one of the like big four or five menswear, kind of undershirts and athletic wear brands called Whitesville. I don't know where the name came from, but basically it's a bunch of like basic clothing, like t-shirts, et cetera, and this Japanese indie company, they bought the defunct basically name and now is reproducing clothes almost made to the exact shape and stack, and even with the exact recreation of the graphic packaging on these tees, but like today. I just think there's something really funny and ironic about they've taken an American post-war aesthetic and literal brand, but it's actually a indie small-scale Japanese manufacturing approach to making those clothes.

**中文翻译:**
……实际上，有一家叫 Self Edge 的店，主店在旧金山的 Valencia 街。他们经营很多这类商品。那是他们的经营模式，有牛仔裤和 T 恤。我买了很多。我的意思是，他们基本上挑选了不同实际制造商的精品。其中一个叫 Studio D'Artisan，另一个叫……实际上，这很酷，有一家公司叫……我想母公司其实叫东洋（Toyo）制造，听起来像是一个大型综合企业，但完全不是。它是一家规模非常小的日本复古服装制造商，但他们有几个子品牌。(01:34:51): 他们实际上买下了一个美国战后品牌的权利，那个品牌有点像 Hanes，是当时四大或五大男装内衣和运动服品牌之一，叫 Whitesville。我不知道这个名字是怎么来的，但基本上它生产一堆基础服装，比如 T 恤等等。这家日本独立公司买下了这个基本上已经倒闭的名字，现在正在重新生产几乎完全按照当年的形状和规格制作的衣服，甚至精确地再现了这些 T 恤上的图形包装，但却是在今天生产。我只是觉得这很有趣也很讽刺：他们采用了美国的战后审美和字面品牌，但实际上是用日本独立小规模制造的方式来制作这些衣服。

---

### [01:35:51] Lenny Rachitsky

**English:**
I feel like we just tapped into what could be a whole other podcast conversation about clothing and- (01:35:56): Yeah- (01:35:56): ... craftsmanship- (01:35:57): ... but I'm going to pull us out of that.

**中文翻译:**
我觉得我们刚刚开启了一个关于服装和——(01:35:56): 是的——(01:35:56): ……工艺的全新播客话题——(01:35:57): ……但我得把话题拉回来了。

---

### [01:35:59] Howie Liu

**English:**
The next podcast franchise.

**中文翻译:**
下一个播客系列。

---

### [01:36:02] Lenny Rachitsky

**English:**
Or just Howie and Lenny talking about clothing.

**中文翻译:**
或者干脆就是 Howie 和 Lenny 聊衣服。

---

### [01:36:04] Howie Liu

**English:**
That's great.

**中文翻译:**
那太棒了。

---

### [01:36:05] Lenny Rachitsky

**English:**
Okay, two more questions.

**中文翻译:**
好，最后两个问题。

---

### [01:36:06] Howie Liu

**English:**
Yeah.

**中文翻译:**
好的。

---

### [01:36:06] Lenny Rachitsky

**English:**
Do you have a life motto that you often find useful in working or you like to share with friends or family?

**中文翻译:**
你有没有什么人生格言，是你觉得在工作中很有用，或者喜欢与亲友分享的？

---

### [01:36:12] Howie Liu

**English:**
I stumbled on this guy Paul Conti, who I think he's an MD, but also a psychologist, and he has a book, but also he did this long-form podcast with Andrew Huberman, and he actually ends up talking a lot about just how to think about your life outlook and kind of your framework for thinking about life, but grounded in a kind of like scientific and neurological and cognitive science basis. I found one particular point really, really powerful it took with me, which is if you live your life in a way that's foundationally built around humility and gratitude. Look, everybody has different circumstances. (01:37:06): I think I fully own that even though I didn't come from money, my family was very, very financially modest growing up. I still had incredible resources and opportunities afforded to me even just by virtue of growing up in the U.S., being born in and growing up in the U.S., but also having access to a computer and the internet and even all the free resources I could then access and learn about from there. I still feel like whatever you have or don't have to start with, if you kind of approach the world and kind of the future with a spirit of humility and gratitude rather than, I guess, the opposite of that, I think I've felt like it kind of becomes a self-fulfilling prophecy. You're open-minded, you're kind of grateful, and then more opportunities actually come your way, and maybe it's because the energy you're putting out into the world and other people. (01:38:07): You're kind of attracting good opportunities and good people and good things, but I think there's a lot of other parts of his framework, but the one that is easiest to remember is like, how do I approach each day? Even if I'm going through a tough moment and I had to fire somebody today, or maybe I get disappointed because we lost a customer deal or something broke or whatever, but to still try to look at the entire situation from overall a feeling of humility and gratitude I think just really does shift your like... It spills over into everything else for that day and maybe even for the whole lifetime.

**中文翻译:**
我偶然发现了 Paul Conti 这个人，我想他是一名医学博士，也是一名心理学家。他写过一本书，还和 Andrew Huberman 做过一期长篇播客。他最后谈到了很多关于如何思考你的人生观以及思考人生的框架，但这些都是建立在科学、神经学和认知科学基础上的。我发现其中一个特别的观点非常有力，我一直铭记在心，那就是：如果你以谦逊（humility）和感恩（gratitude）为基础来生活。听着，每个人的境遇都不同。(01:37:06): 我完全承认，尽管我并非出身富裕家庭，我成长过程中的家庭经济状况非常拮据，但我仍然拥有令人难以置信的资源和机会，仅仅凭借在美国出生和长大，以及能够接触到电脑、互联网，甚至我能从中获取和学习的所有免费资源。我仍然觉得，无论你起步时拥有什么或没有什么，如果你以谦逊和感恩的精神去面对世界和未来，而不是相反，我觉得这会变成一种“自我实现的预言”。你心态开放，心存感激，然后更多的机会实际上会向你走来，也许是因为你向世界和他人释放出的能量。(01:38:07): 你在吸引好的机会、好的人和好的事物。他的框架中还有很多其他部分，但最容易记住的一个是：我如何面对每一天？即使我正在经历艰难时刻，比如我今天不得不解雇某人，或者也许因为我们丢了一个客户订单或什么东西坏了而感到失望，但仍然尝试从整体上以谦逊和感恩的心态来看待整个局势，我认为这真的会改变你的……它会溢出到那一天的其他所有事情中，甚至可能影响一生。

---

### [01:38:52] Lenny Rachitsky

**English:**
That super resonates. That is really powerful advice that's hard to internalize, but important.

**中文翻译:**
这引起了极大的共鸣。这是非常有力且难以内化但却很重要的建议。

---

### [01:38:57] Howie Liu

**English:**
Yeah, it's easily said, hard to practice.

**中文翻译:**
是的，说起来容易，做起来难。

---

### [01:38:59] Lenny Rachitsky

**English:**
Yeah. Where can folks find you? What should they know about Airtable and how can listeners be useful to you?

**中文翻译:**
好的。大家可以在哪里找到你？关于 Airtable 他们应该了解什么？听众可以为你提供什么帮助？

---

### [01:39:05] Howie Liu

**English:**
Okay, so I am on Twitter, howietl. I don't post that much, but I'm a lurker, so I listen and watch, and you can always DM me there. You can also email me directly, howie@airtable.com, anytime you have ideas, feedback, et cetera. On Airtable, just go try it. The whole point is we want to make this an experiential product. That's why we're really leaning into the PLG roots. We talked about the homepage literally says like, "Just start building right now. What do you want to build? Go." (01:39:36): It starts building, and so use the product, give me feedback, and if you have ideas of your own and you want to rip on them, I love because my passion is thinking about product and product UX, especially in the AI era if you're working on or thinking about something interesting in that space. Even if it's just purely to riff on a concept, that's something I enjoy doing, and maybe I get to learn and sharpen my own skill set from. Feel free to reach out and, yeah, I mean, tell your friends and family to try Airtable as well. That's the main thing.

**中文翻译:**
好，我的 Twitter 账号是 howietl。我不怎么发帖，但我是一个“潜水员”，我会听和看，你随时可以在那里私信我。你也可以直接给我发邮件：howie@airtable.com，只要你有想法、反馈等等。关于 Airtable，去尝试一下吧。核心点在于我们想把它做成一个体验式产品。这就是为什么我们真的在回归 PLG 的根源。我们谈到主页上字面意思写着：“现在就开始构建。你想构建什么？开始吧。”(01:39:36): 它就开始构建了。所以，请使用产品，给我反馈。如果你有自己的想法并想深入探讨，我很乐意，因为我的热情在于思考产品和产品 UX，特别是在 AI 时代，如果你正在研究或思考该领域有趣的事情。即使纯粹是为了探讨一个概念，那也是我喜欢做的事情，也许我能从中学习并磨练自己的技能。请随时联系我。是的，我的意思是，也告诉你的亲朋好友去尝试 Airtable。这就是最主要的事。

---

### [01:40:08] Lenny Rachitsky

**English:**
Sounds like you're looking for people to nerd snipe you and- (01:40:10): Yes. Yeah. (01:40:12): ... Howie, thank you so much for being here.

**中文翻译:**
听起来你是在寻找那些能用极客话题吸引你注意力的人——(01:40:10): 是的。没错。(01:40:12): ……Howie，非常感谢你能来到这里。

---

### [01:40:14] Howie Liu

**English:**
Awesome. Thank you, Lenny.

**中文翻译:**
太棒了。谢谢你，Lenny。

---

### [01:40:15] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。