# Ian McAllister - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Ian McAllister.

---

### [00:00:00] Ian McAllister

**English:**
If you forget about everything else, forget about politics, forget about promotion, or having a bigger org or whatever, if you simply wake up every day trying to have the biggest impact you can, or if you're a leader trying to use your team to have the biggest impact you can in the company, how you do every part of your day, that's a really good guiding light.

**中文翻译:**
如果你忘掉其他一切，忘掉办公室政治，忘掉晋升，或者拥有更大的团队规模之类的东西；如果你只是单纯地每天醒来都努力创造你能达到的最大影响力，或者如果你是一名领导者，努力带领你的团队为公司创造最大的影响力，那么这种心态将成为你度过每一天、处理每一项工作的绝佳指路明灯。

---

### [00:00:22] Lenny

**English:**
Welcome to Lenny's podcast. I'm Lenny and my goal here is to help you get better at the craft of building and growing products. Today my guest is Ian McAllister. Ian is the author of one of the most classic posts on product management, What Separates a Top 1% PM from a Top 10% PM, amongst many other pieces of writing that he shared online. Ian has managed over 100 product managers in his career. He spent 12 years at Amazon where he built Amazon Smile and led the team responsible for growing Alexa internationally. He also worked at Airbnb with me and now he's at Uber leading global product for the vehicles platform, which includes making Uber's fleet increasingly electric and autonomous. In our conversation, we focus primarily on two topics. What separates a top 1% PM from everyone else, specifically for new PMs and also for senior PMs. And we also dig deep into the working backwards process. We get into how you can implement the process on your team and how you might be doing it wrong. There's also a bunch of links to templates and guides in the show notes, so if you want to follow along, definitely check those out. With that, I bring you Ian McAllister.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的能力。今天的嘉宾是 Ian McAllister。Ian 是产品管理领域最经典的文章之一——《是什么让前 1% 的产品经理脱颖而出》（What Separates a Top 1% PM from a Top 10% PM）的作者，此外他还在网上分享过许多其他精彩文章。Ian 在职业生涯中管理过 100 多名产品经理。他在亚马逊工作了 12 年，期间创建了 Amazon Smile，并领导团队负责 Alexa 的国际化增长。他曾和我在 Airbnb 共事，现在他在 Uber 担任车辆平台的全球产品负责人，工作内容包括推动 Uber 车队的电动化和自动驾驶化。在我们的对话中，我们主要关注两个话题：是什么让前 1% 的 PM 与众不同（特别是针对初级 PM 和资深 PM）；以及深入探讨“逆向工作法”（Working Backwards）。我们会讨论如何在团队中实施这一流程，以及你可能在哪些地方做得不对。节目介绍中还有许多模板和指南的链接，如果你想跟着学习，一定要去看看。下面，让我们欢迎 Ian McAllister。

---

### [00:01:32] Lenny (Ad: Mixpanel)

**English:**
This episode is brought to you by Mixpanel. Offering powerful self-serve product analytics. If you listen to this podcast, you know that it's really hard to build great product without making compromises. And when it comes to using data, a lot of teams think that they only have two choices. Make quick decisions based on gut feelings or make data driven decisions at a snail's pace. But that's a false choice. You shouldn't have to compromise on speed to get product answers that you can trust. With Mixpanel, there are no trade offs. Get deep insights at the speed of thought at a fair price that scales as you grow. Mixpanel builds powerful and intuitive product analytics that everyone can trust, use, and afford. Explore plans for teams of every size and see what Mixpanel can do for you at mixpanel.com. And while you're at it, they're hiring. Check out mixpanel.com to learn more.

**中文翻译:**
本集节目由 Mixpanel 赞助。Mixpanel 提供强大的自助式产品分析服务。如果你听过这个播客，你就会知道，在不妥协的情况下打造伟大的产品是非常困难的。而在使用数据方面，许多团队认为他们只有两个选择：要么凭直觉快速决策，要么以蜗牛般的速度进行数据驱动决策。但这其实是一个伪命题。你不应该为了获得值得信赖的产品答案而在速度上妥协。有了 Mixpanel，你无需权衡。以思维的速度获取深度洞察，价格公平且随你的增长而扩展。Mixpanel 构建了强大且直观的产品分析工具，让每个人都能信任、使用并负担得起。请访问 mixpanel.com 探索适合各种规模团队的方案，看看 Mixpanel 能为你做些什么。顺便说一下，他们正在招聘，访问 mixpanel.com 了解更多信息。

---

### [00:02:24] Lenny (Ad: Athletic Greens)

**English:**
This episode is brought to you by Athletic Greens. I've been hearing about AG1 on basically every podcast that I listened to, like Tim Ferris and Lex Friedman, and so I finally gave it a shot earlier this year and it has quickly become a core part of my morning routine, especially on days that I need to go deep on writing or record a podcast like this. Here's three things that I love about AG1. One, with a small scoop that dissolves in water you are absorbing 75 vitamins, minerals, probiotics, and adaptogens. I kind of like to think of it as a little safety net for my nutrition in case I've missed something in my diet. Two, they treat AG1 like a software product. Apparently they're on their 52nd iteration and they're constantly evolving it based on the latest science, research studies and internal testing that they do.

**中文翻译:**
本集节目由 Athletic Greens 赞助。我几乎在我听的每一个播客里都听过 AG1，比如 Tim Ferris 和 Lex Friedman 的节目，所以我终于在今年早些时候尝试了一下。它迅速成为了我早晨例行公事的核心部分，尤其是在我需要深度写作或录制像这样的播客的日子里。关于 AG1，我有三点非常喜欢：第一，只需一小勺溶解在水中，你就能吸收 75 种维生素、矿物质、益生菌和适应原。我喜欢把它看作是我营养摄入的一个小小安全网，以防我在饮食中遗漏了什么。第二，他们像对待软件产品一样对待 AG1。显然，他们已经进行了第 52 次迭代，并且不断根据最新的科学研究和内部测试进行演进。

---

### [00:03:13] Lenny (Ad: Athletic Greens Continued)

**English:**
And three, it's just one easy thing that I can do every single day to take care of myself. Right now it's time to reclaim your health and arm your immune system with convenient daily nutrition. It's just one scoop and a cup of water every day and that's it. There's no need for a million different pills and supplements to look out for your health. To make it easy, Athletic Greens is going to give you a free one year supply of immune supporting vitamin D and five free travel packs with your first purchase. All you have to do is visit athleticgreens.com/lenny. Again, that's athleticgreens.com/lenny. To take ownership over your health and pick up the ultimate daily nutritional insurance.

**中文翻译:**
第三，这是我每天都能轻松做到的一件照顾自己的小事。现在是时候重获健康，用便捷的每日营养武装你的免疫系统了。每天只需一勺粉末和一杯水，就这么简单。不需要为了健康去吃无数种不同的药丸和补充剂。为了方便起见，Athletic Greens 将在你首次购买时免费赠送一年的免疫支持维生素 D 和五个旅行装。你只需访问 athleticgreens.com/lenny 即可。再次强调，网址是 athleticgreens.com/lenny。掌控你的健康，领取这份终极每日营养保险。

---

### [00:03:55] Lenny

**English:**
Ian, welcome to the podcast.

**中文翻译:**
Ian，欢迎来到我们的播客。

---

### [00:03:57] Ian McAllister

**English:**
Thanks for having me, Lenny. I've been looking forward to this.

**中文翻译:**
谢谢邀请，Lenny。我一直很期待这次对话。

---

### [00:03:59] Lenny

**English:**
Me too. I'm sure you hear this a lot, but when I was a new product manager, a very new PM, the post that you wrote on what makes a top 1% product manager was really influential and really helped me figure out what to focus on and what skills are really important. And I find that it continues to live on as this very legendary post for product managers who are trying to figure out what to do. And I just reread it in prep for this post and I was just like, wow, this is ... Now that I'm on the other side, I'm like, this is so right. And so I'm really excited to dig into a lot of these things in person, virtually in person, and with you. So thank you again for doing this.

**中文翻译:**
我也是。我相信你经常听到这种话，但当我还是一个职场新人、一个非常初级的产品经理时，你写的那篇关于“是什么造就了前 1% 的产品经理”的文章对我影响极大，它真的帮我理清了应该关注什么，以及哪些技能才是真正重要的。我发现这篇文章至今仍被产品经理们视为“传奇之作”，尤其是那些正在摸索职业道路的人。为了准备这次访谈，我特意重读了一遍，感觉就是：哇，这写得……现在我站在了职业生涯的另一端，我发现你说的太对了。所以我非常兴奋能和你一起深入探讨这些内容。再次感谢你的参与。

---

### [00:04:42] Ian McAllister

**English:**
Yeah. Man, it's awesome. I'm excited just to spend some time talking with you about product and we'll see what happens. Did you expect the impact that this post had when you were writing it, when you were just putting this together, the impact that the post had in your career or just the PM industry? Definitely not. I used to lurk on Quora at the time and then I was just having fun reading things and answering some questions and I used to look for questions in the Goldilocks zone. They weren't too high level of abstract like how do you be a good problem, but they weren't too super specific and this one was kind of right in the middle. And so I'd pluck off a couple of those and I think more as a way to structure my own thoughts, that was what was interesting and fun for me to do that. Not because I thought it'd have any kind of real reach. But obviously it's been cool to see that people reference it pretty often and that's been pretty fun.

**中文翻译:**
太棒了。我也很兴奋能花点时间和你聊聊产品。你在写这篇文章的时候，有没有预料到它会产生这么大的影响？无论是对你的职业生涯，还是对整个 PM 行业？绝对没有。当时我经常在 Quora 上潜水，只是觉得阅读和回答问题很有趣。我当时专门找那些处于“金发姑娘区”（Goldilocks zone，指恰到好处的区间）的问题：既不会太抽象（比如“如何成为一个好的解决者”），也不会太琐碎。这个问题刚好处于中间地带。我回答这些问题更多是为了整理自己的思路，这对我来说很有趣，并不是因为我觉得它会有多大的影响力。但显然，看到人们经常引用它真的很酷，也很有意思。

---

### [00:05:23] Lenny

**English:**
We'll link to this in the show notes. If folks that are listening don't know what we're talking about, we'll link to it and you can check it all out. And we're going to be talking about a lot of this stuff in the actual chat, but there's a couple things there that are worth maybe drilling in on a little bit. One is just the impact that writing on the internet can have on someone's career. This one post I imagine had a lot of impact on the trajectory of your career. Is there something you could share there? Is that true?

**中文翻译:**
我们会在节目介绍中附上链接。如果听众还不知道我们在聊哪篇文章，可以去看看。我们待会儿会深入聊聊其中的内容，但有几点值得现在先探讨一下。一是互联网写作对一个人职业生涯的影响。我猜这一篇文章就对你的职业轨迹产生了巨大影响。你能分享一下这方面的情况吗？事实是这样吗？

---

### [00:05:45] Ian McAllister

**English:**
Yeah, it did. And there's another post, I think it was before this one, someone just asked about Amazon's product development process and so I wrote about the working backwards process. Which isn't my process. I just used it and just described it and just kind of caught on a little bit there as well. I think those two, and then I started to write more about people management and product management. And I think the value for me was so awesome just to make connections with people in the industry and it felt like this is, I guess, the 2010 or something like this where a lot of Amazon people I of thought were just so 100% heads down. It was a little bit of a secretive culture, not maybe like Apple, but it was pretty private. But I was interested in the startup community and product in general and so I think I spent a little time trying to engage with folks and I just made so many great connections and relationships from this.

**中文翻译:**
是的，确实如此。还有另一篇帖子，我想是在这篇之前，有人问起亚马逊的产品开发流程，于是我写了关于“逆向工作法”（Working Backwards）的内容。那并不是我发明的流程，我只是在使用它并描述了它，结果那篇也火了。我觉得是这两篇，后来我又开始写更多关于人员管理和产品管理的内容。对我来说，最大的价值在于能与行业内的人建立联系。那是 2010 年左右，当时我觉得很多亚马逊的人都是 100% 埋头苦干。那是一种有点神秘的文化，虽然不像苹果那样，但也相当封闭。但我对创业社区和产品领域很感兴趣，所以我花了一些时间尝试与外界交流，并因此建立了许多极好的联系和关系。

---

### [00:06:39] Ian McAllister

**English:**
I remember interacting with you and getting to know Joebot and other folks at Airbnb early on even before I joined. But obviously I'd credit this work and those relationships for me ultimately going there and so many great relationships and people I've met because of it. And aside from just the little positive feedback, I mean people tweet at me periodically, be like, "Hey, by the way, just love this post," and whatever. And so it's super gratifying.

**中文翻译:**
我记得甚至在我加入 Airbnb 之前，就通过这些互动认识了你、Joebot 和其他同事。显然，我能最终去那里工作，要归功于这些写作和建立的关系。除此之外，还有很多我因此结识的优秀人才。除了那些正向反馈——比如人们会定期在 Twitter 上艾特我说：“嘿，顺便说一下，我太喜欢这篇帖子了”——这真的让人非常有成就感。

---

### [00:07:03] Lenny

**English:**
You mentioned a little bit about your background and we're about to get into that and I want you to share all the things you've done. But the other piece there that I think is interesting that comes up again and again in the power of writing is it often just starts with you trying to collect your thoughts and putting it out there and ends up, wow, so many people find that valuable and it spreads. And so that's just a really simple way of thinking about if you're starting to write online, just summarize something that you've been thinking about that you want to just crystallize in your own head. There's this quote that's probably falsely attributed to Mark Twain and Hemingway often of just like, I don't know what I've thought until I've written it down. And that's super true with these things and so that's a good example of this.

**中文翻译:**
你提到了你的背景，我们待会儿会详细聊聊你做过的那些了不起的事情。但关于写作的力量，我觉得很有趣的一点是：它往往始于你尝试整理自己的思绪并将其公之于众，结果却发现，哇，这么多人觉得它有价值，然后它就传开了。所以，如果你想开始在网上写作，一个非常简单的方法就是：总结一些你一直在思考、想要在脑海中具象化的东西。有一句经常被误传为马克·吐温或海明威名言的话：“直到我写下来，我才知道自己在想什么。”这在写作中非常真实，你就是一个很好的例子。

---

### [00:07:42] Ian McAllister

**English:**
And I think with any kind of writing, it was probably less structured initially, but I would, partially because I was trying to share something for an external audience, try to just organize it and make it compact and not too wordy or rambling. And I think business writing, I spent a lot of that time doing that at Amazon, is so valuable because you've got to be a clear thinker to be a clear communicator. And so there's two tests in writing well or communicating well. It's both those things. So I found it's pretty valuable in kind of sharpening your ax.

**中文翻译:**
我觉得任何形式的写作，最初可能都没什么结构，但因为我是想分享给外部读者，所以会努力去组织语言，使其简洁紧凑，不啰嗦。我在亚马逊花了大量时间进行商务写作，这非常有价值，因为你必须先成为一个清晰的思考者，才能成为一个清晰的沟通者。写得好或沟通得好有两个测试标准，而这两者是相辅相成的。所以我发现写作在“磨刀”方面非常有用。

---

### [00:08:15] Lenny

**English:**
So these are the two things we're going to focus our chat on is what makes a top 1% product manager and then the Amazon way of working and especially working backwards. So these are all good cues for where we're going. But before we get there, can you just spend just a minute giving us a sense of some of the wonderful things you've done in your career and what you're up to now?

**中文翻译:**
所以我们今天的聊天将集中在两个方面：是什么造就了前 1% 的产品经理，以及亚马逊的工作方式，特别是“逆向工作法”。这些都是很好的切入点。但在深入探讨之前，你能花一分钟时间让我们了解一下你职业生涯中做过的一些精彩事情，以及你现在在忙些什么吗？

---

### [00:08:31] Ian McAllister

**English:**
Well, I can tell you what I have done. I'll let others decide what's wonderful or not. So after doing finance and economics in school, I made the logical choice and I got a job doing marketing in the beer industry and then the next logical choice, I moved to Tokyo and I bootstrapped my way into software development without knowing Japanese or software development. Did that for a few years, came back to the states working as a developer at a startup and then kind of a midsize company and then moved to Microsoft as a program manager, pretty much a product manager. The same thing there in that role. Learned some good stuff and then made a connection with Amazon and moved there 2006. And that was really the start of when I think about building my product toolbox and leadership toolbox. So few different things I did over 12 years, a few years in retail and conversion.

**中文翻译:**
好吧，我可以告诉你我做过什么，至于精不精彩，留给别人去评判。在学校学完金融和经济后，我做出了一个“合乎逻辑”的选择：在啤酒行业找了一份市场营销的工作；接着是下一个“合乎逻辑”的选择：我搬到了东京，在既不懂日语也不懂软件开发的情况下，硬是闯进了软件开发领域。做了几年后，我回到美国，在一家初创公司和一家中型公司担任开发人员，然后加入微软担任项目经理（Program Manager），其实和产品经理差不多。在那儿学到了不少好东西，然后与亚马逊建立了联系，并于 2006 年入职。那才是我真正开始构建产品工具箱和领导力工具箱的起点。在亚马逊的 12 年里，我做了几件不同的事情，包括几年的零售和转化业务。

---

### [00:09:22] Ian McAllister

**English:**
I then moved in traffic and direct traffic loyalty when I created Amazon Smile. The role in Alexa. I led Alexa International, so scaling Alexa and Echo to six more countries. And the last role in delivery experience and operations. So I led a number of different programs there and then recently joined Uber where I'm a senior director of product and tech for vehicles. So that means everything, all the tools that help fleets and rental companies make their vehicles accessible to Uber drivers so they can earn. Sustainability tech and electrification, our vehicle platform, and then creating a path for autonomous vehicles to come onto the platform. And that's it.

**中文翻译:**
后来我转到了流量和直接流量忠诚度部门，在那期间我创建了 Amazon Smile。之后在 Alexa 部门，我领导了 Alexa 国际业务，将 Alexa 和 Echo 推广到了另外六个国家。我在亚马逊的最后一个职位是在交付体验和运营部门。我领导了那里的许多不同项目，最近我加入了 Uber，担任车辆产品与技术的资深总监。这意味着我要负责一切：帮助车队和租赁公司将车辆提供给 Uber 司机以赚取收入的所有工具；可持续技术和电动化；我们的车辆平台；以及为自动驾驶汽车进入平台铺平道路。这就是我的经历。

---

### [00:10:03] Lenny

**English:**
Amazing. I just realized this one thread through your career is autonomy and AI a little bit, right? With Alexa and then with Uber, with these autonomous cars stuff you're working on now. Is that something realized or is that an accident?

**中文翻译:**
太神奇了。我刚意识到你职业生涯中有一条主线是自动化和 AI，对吧？从 Alexa 到现在的 Uber 自动驾驶汽车项目。这是你有意为之，还是纯属巧合？

---

### [00:10:18] Ian McAllister

**English:**
Well, I mean I guess you could connect those things. Obviously both are machine learning, AI. The way I think about it is that I've done a whole bunch of different lifetimes, especially around eCommerce, and so it allows me to cover the gamut. Plus, I guess I forgot to mention the time at Airbnb working with Joebot and you and Vlad and Dan and Shirley and there was focused on building out the customer support technology platform. So that's another part of the eCommerce platform. Covers the gamut.

**中文翻译:**
嗯，我想你可以把这些联系起来。显然两者都涉及机器学习和 AI。但我自己的看法是，我经历了好几种不同的职业生涯，特别是在电子商务领域，这让我能够覆盖整个范围。另外，我想我忘了提到在 Airbnb 的那段时光，当时和 Joebot、你、Vlad、Dan 以及 Shirley 一起工作，重点是构建客户支持技术平台。那是电子商务平台的另一个组成部分。总之，覆盖面很广。

---

### [00:10:45] Lenny

**English:**
I forgot to bring that up too. I'm glad you touched on that.

**中文翻译:**
我也忘了提那件事了。很高兴你提到了。

---

### [00:10:48] Ian McAllister

**English:**
I don't know how I missed that. I guess I skipped past that with the Amazon stuff.

**中文翻译:**
我不知道怎么就漏掉了。大概是聊亚马逊聊得太投入，直接跳过去了。

---

### [00:10:50] Lenny

**English:**
The most transformative time getting to work together.

**中文翻译:**
那是我们一起工作的最具变革性的时光。

---

### [00:10:53] Ian McAllister

**English:**
That was awesome. That was awesome. I learned a lot from you too during that time.

**中文翻译:**
那段时光太棒了。真的太棒了。在那期间我也从你身上学到了很多。

---

### [00:10:56] Lenny

**English:**
What a time. This is a good time to chat about, speaking of Airbnb and all that, to chat about what makes a top 1% product manager. So I know your post was really titled what separates a 1% PM from a 10% PM, but it feels like it's even broader, just like how do you become a top 1% product manager. And I thought maybe a good way to start here is maybe just run through the attributes that you've found over the years or here's the things that a top 1% PM needs to get great at. Maybe just run through them and then we'll talk through them in a little more detail.

**中文翻译:**
那真是一段难忘的时光。说到 Airbnb 和那些往事，现在正是聊聊“是什么造就了前 1% 的产品经理”的好时机。我知道你的文章标题是《是什么让前 1% 的 PM 与前 10% 的 PM 区别开来》，但感觉它的内涵更广，就像是“如何成为前 1% 的产品经理”。我想也许一个好的开始方式是，先快速列举一下你多年来发现的那些特质，或者说前 1% 的 PM 需要擅长的事情。我们可以先过一遍，然后再详细讨论。

---

### [00:11:28] Ian McAllister

**English:**
Yeah, I was going to pull up my post here so I could actually refer to it. Do you want me to go through all of them or just pick out a couple to touch on?

**中文翻译:**
好，我正打算把我的文章调出来参考一下。你是想让我全部过一遍，还是挑几个重点讲讲？

---

### [00:11:33] Lenny

**English:**
Let's maybe just go through them quickly just to put them out there and then I'll have some follow up questions to dig into a few of them.

**中文翻译:**
我们先快速过一遍，把它们都列出来，然后我会针对其中几个进行深入提问。

---

### [00:11:40] Ian McAllister

**English:**
All right, sounds good. Well, the way I listed it at the time, think big. Always want to hunt for bigger impact. Communicate, I think we'll probably touch on that a little bit. It's super important for PMs as a test of their thinking and their communication. Simplify. How you can do more with less and have more impact. Simplifying is a great way to do that. Prioritize. That's I think the core skill after communication of a PM and there's so many different lenses to view that. Let's see here. Forecasting and measuring. I think that it's really important. What separates product managers from consultants sometimes is you forecast and then you execute and then you measure and validate and that helps you build your instincts. Just obviously the core execution of just shipping and doing what you said you do. Understanding technical trade offs is that you don't have to be a software engineer to be a great PM, but the more you learn about technical trade offs, not just product and customer trade offs, that will help you simplify and get more yield out of your resources.

**中文翻译:**
好的。按照我当时的写法：第一，**大局观（Think Big）**。永远追求更大的影响力。第二，**沟通（Communicate）**。我想我们待会儿会细聊，这对 PM 来说至关重要，是其思考和表达能力的试金石。第三，**简化（Simplify）**。如何以少胜多，创造更大影响，简化是绝佳途径。第四，**优先级排序（Prioritize）**。我认为这是 PM 继沟通之后的另一项核心技能，可以从很多维度来看待。让我看看……第五，**预测与衡量（Forecasting and measuring）**。这非常重要。PM 与顾问的区别有时就在于：你预测，然后执行，最后衡量并验证，这有助于培养你的直觉。第六，**核心执行力（Execution）**。就是把东西交付出去，言出必行。第七，**理解技术权衡（Understanding technical trade offs）**。你不需要成为软件工程师也能成为优秀的 PM，但你对技术权衡（而不仅仅是产品和客户权衡）了解得越多，就越能简化流程并提高资源产出。

---

### [00:12:40] Ian McAllister

**English:**
Understanding good design. If you're working on anything customer focused, that's always going to help you think in the mind of a customer or user. You don't need to design, but the more you understand helps. Writing effective copy. This goes a long way not to get close and not to sub out the copy to somebody else, but to get good at communicating with a couple words to your customers. That's a great skill. Those were the ones that I wrote at the time, I guess 10 years ago, and then I refreshed the post recently in my newsletter. And I added a couple new ones honestly, because as I reflected back, there was a few that I think a lot about these days that I missed the first time around. Earn trust with others. That's so important as a PM, but especially if you're going to grow as a product leader becomes even more important.

**中文翻译:**
第八，**理解优秀的设计（Understanding good design）**。如果你在做任何以客户为中心的工作，这能帮你站在客户或用户的角度思考。你不需要亲自设计，但理解得越深越好。第九，**撰写有效的文案（Writing effective copy）**。这非常有用，不要总是把文案外包给别人，要学会用寥寥数语与客户沟通。这是一项了不起的技能。这些是我大概 10 年前写的。最近我在时事通讯（Newsletter）里更新了这篇文章，诚实地说，我增加了一些新内容，因为回想起来，有些特质是我第一次写时漏掉的，但现在我觉得非常重要。比如：**赢得他人的信任（Earn trust with others）**。作为 PM 这很重要，但如果你想成长为产品领导者，这会变得更加关键。

---

### [00:13:29] Ian McAllister

**English:**
And I think trust is the currency of a product manager and a product leader, especially if you're going to grow in your career. Digging for data. It's out there and you got to develop the tools to go find it. Not to depend on your analyst or what's in the reports today. So that's a really important skill for anyone in product. And probably the more junior you are, the more important it is as you're really in the weeds there building product. Pushing back effectively. This is an art and a skill, but I think your ability to do this is pretty correlated with your ability to grow and succeed as a leader. Because if you say yes to everything, you're going to go nowhere. Adapting to change. How you react to change will obviously impact one, your mood and your morale, as well as how effectively you can rally yourself, your team. And then driven by impact, not promotion. Ultimately that's what you want to wake up every day thinking about how to have an impact for your business and that will be an indicator on your likelihood of promotion. So do that instead of just focusing on how to get promoted and having that guide your day.

**中文翻译:**
我认为信任是产品经理和产品领导者的“货币”，尤其是在职业晋升过程中。还有**挖掘数据（Digging for data）**。数据就在那里，你必须掌握寻找数据的工具，而不是依赖分析师或现成的报告。这对任何产品人来说都是极其重要的技能，而且你越是初级，就越重要，因为你正处于构建产品的最前线。还有**有效地回绝（Pushing back effectively）**。这是一门艺术，也是一种技能，我认为这种能力与你作为领导者的成长和成功高度相关。如果你对所有事情都说“好”，你将一事无成。还有**适应变化（Adapting to change）**。你对变化的反应不仅会影响你的情绪和士气，还会影响你动员自己和团队的效率。最后是**受影响力驱动，而非晋升驱动（Driven by impact, not promotion）**。归根结底，你希望每天醒来都在思考如何为业务创造影响力，而这才是你获得晋升可能性的指标。所以，专注于创造影响，而不是整天想着怎么升职。

---

### [00:14:33] Lenny

**English:**
Awesome. So it's a long list. There's a lot that a PM needs to be good at, which I think if you're a PM you already know. It's a wild, crazy, impossible job to have everything nailed down. And at the end of this post even mention you've never met a 1% PM that does all these things. And I think that's important. No one's going to be the best at all these things. And so just to drill down a little bit and get a little more focused. Say you're a new product manager. Of these, I forget how many there, maybe 10, 12, what are the top three that you think new PMs should get most good at and focus on?

**中文翻译:**
太棒了。这是一个很长的清单。PM 需要擅长的事情非常多，我想如果你是 PM，你已经深有体会了。要把所有事情都做得完美，简直是一项疯狂且不可能完成的任务。你在文章最后也提到，你从未见过能做到所有这些事情的前 1% PM。我觉得这一点很重要：没有人能在所有方面都做到最好。为了更聚焦一点，假设你是一名新入职的产品经理，在这些（大概 10 到 12 项）特质中，你认为新 PM 最应该掌握并关注的前三项是什么？

---

### [00:15:06] Ian McAllister

**English:**
Probably communicate, prioritize, and execute. I think those are just the core building blocks. Other ones will be more important as you grow and become more senior, but those ones, no matter where you are in your product career I think are super important. Being a better communicator is something I've been working on my entire product career and I'll be working on until the day I stop. And I remember years ago I was at Microsoft, my first effectively product manager role and my product unit manager, Thomas, came by the office and I think he asked me, "When is this going to ship?" And I was like, "Well, this thing is taking a little bit longer here and this other thing and yada yada." And I gave a bunch of background, but I didn't really answer the question. And I got a little feedback from him like, that's not really the ... Ultimately he's waiting for a date.

**中文翻译:**
大概是**沟通、优先级排序和执行**。我认为这些是核心基石。随着你的成长和职位的提升，其他特质会变得更重要，但无论你处于产品生涯的哪个阶段，这三项都至关重要。成为更好的沟通者是我整个职业生涯都在努力的事情，直到我退休那天我也不会停止。我记得多年前在微软，那是我的第一个产品经理职位，我的产品部门经理 Thomas 来到办公室问我：“这东西什么时候发布？”我回答说：“嗯，这个地方花的时间比预期长一点，还有那个事情，等等等等。”我给了一堆背景信息，但并没有真正回答他的问题。他给我的反馈大概是：这不是他想要的……归根结底，他只是在等一个日期。

---

### [00:15:53] Ian McAllister

**English:**
And I just reflected on that and that was, as I remember, my journey to try to be a better communicator over time and I'm still on it. When I went to Amazon, I worked for Kim Rackmiller who was our, I think at the time, SVP for Worldwide Discovery. And I think she was Amazon's first TPM. And she was tough but super smart. And so that was also an early experience to learn from her. And sometimes you get some feedback when you didn't really answer the question. And my first boss, Russell and I organized and started to gather this thing called the Book of Kim. And so we would gather these best practices that we learned from her elsewhere. Avoid weasel words, answer first and then explain, own your problems. And started building this.

**中文翻译:**
我对此进行了反思，那是我努力成为更好沟通者的旅程的开始，而我至今仍在路上。去亚马逊后，我为 Kim Rackmiller 工作，她当时是全球搜索发现业务的资深副总裁。我想她应该是亚马逊的第一位技术产品经理（TPM）。她很严厉，但极其聪明。那也是一段向她学习的早期经历。有时如果你没正面回答问题，就会收到反馈。我和我的第一任老板 Russell 整理并开始收集一个叫作《Kim 语录》（Book of Kim）的东西。我们会收集从她那里学到的最佳实践：避免使用含糊其辞的词汇（weasel words）、先给答案再解释、勇于承担自己的问题。我们就这样开始构建这个体系。

---

### [00:16:36] Ian McAllister

**English:**
And then I extended that over time and added a bunch more and wrote a post called the Operators Manual. I tried to gather all these things together. But it's such an important thing and the stakes get higher as you work with more and more senior people. But if you can get in the habit early of answering a when question with a date, knowing how to use numbers to answer questions and honestly just learning from feedback and grade yourself after you get feedback on a doc or after a meeting or after answering a question in an elevator. And if you try to say, "Gosh, how could I have done that better?," and then try to get better, you can. And you can go far if you just focus on that and all the other 150 skills of a product manager, but if you don't have that, it's unlikely that you're going to really go too far in your product career.

**中文翻译:**
随着时间的推移，我扩展了这些内容，增加了很多条目，并写了一篇名为《操作手册》（Operators Manual）的文章。我尝试把所有这些东西整合在一起。沟通太重要了，当你与越来越资深的人共事时，赌注也会越来越高。但如果你能尽早养成习惯：用具体的日期回答“什么时候”的问题，学会用数字回答问题，坦诚地从反馈中学习，并在文档评审、会议或电梯里的简短问答后给自己打分。如果你经常反思：“天哪，我怎样才能做得更好？”，然后努力改进，你就能做到。如果你能专注于此，即使不具备 PM 的其他 150 种技能，你也能走得很远；但如果你没有这项能力，你的产品生涯很难有大的突破。

---

### [00:17:24] Ian McAllister

**English:**
So that was communicate. I guess prioritize as the next one. And so I think this is the number one key tool of a product manager is prioritization. Because so many things come from being good at prioritizing. And it's not just what project do you do next or do you do this project or that project. There's so many different dimensions to prioritization. There's which themes are you going to prioritize in a roadmap and which projects within a theme and how are you going to sequence those projects, how much of a project you're going to build. And also just time management is also a prioritization function. Like what are you going to choose to spend your time on? Which things are you going to really go all out to make great and which things are you going to starve for attention or just not do? Given the same amount of skill intelligence and resources, a product manager with a great innate ability to prioritize is going to generate 5X the impact of someone without that skill.

**中文翻译:**
那是沟通。接下来是优先级排序。我认为这是产品经理的第一核心工具。因为擅长优先级排序会带来很多好处。这不仅仅是决定下一个做哪个项目，或者做 A 项目还是 B 项目。优先级排序有很多维度：在路线图中优先考虑哪些主题，主题内优先考虑哪些项目，如何安排这些项目的顺序，以及一个项目要做到什么程度。此外，时间管理本质上也是一种优先级排序功能。你选择把时间花在什么地方？哪些事情你会全力以赴做到极致，哪些事情你会减少关注甚至干脆不做？在技能、智力和资源相同的情况下，一个天生擅长优先级排序的 PM 所产生的影响力，将是不具备该技能的人的 5 倍。

---

### [00:18:18] Ian McAllister

**English:**
My early, if you could call it success at Amazon, I think was completely dependent. It wasn't because I worked smarter or I was smarter, I worked longer hours or I was more technical than other people. I think it was just because I was one, super hungry for impact. And if there was a number or a metric that measured success at the business I was running, I wanted that to go up and to the right. Not to hit a goal, but just to go as far and as fast up to the right as possible. And if anything, it was just working with a team to hone in on the projects that would do that with the greatest leverage and just marshaling all the team's resources. So that was a good start. That was a fit with Amazon in terms of working backwards from a fitness function or a metric.

**中文翻译:**
我在亚马逊早期的所谓成功，我认为完全取决于这一点。并不是因为我工作更聪明，或者我智商更高，或者我加班更久，或者我比别人更懂技术。我想仅仅是因为：第一，我极度渴望影响力。如果有一个数字或指标来衡量我所负责业务的成功，我希望那个曲线一直向右上方攀升。不是为了达成某个目标，而是为了尽可能远、尽可能快地向上增长。如果说有什么秘诀，那就是与团队合作，聚焦于那些杠杆率最高、最能推动指标增长的项目，并调动团队的所有资源。这是一个很好的开始，也符合亚马逊从“适应度函数”（fitness function）或指标出发进行逆向工作的理念。

---

### [00:19:23] Ian McAllister

**English:**
And so did that with the first team I was there and then again later managed the gifting business. And so it just was one skill that I think helped me as well as make up for maybe some deficiencies I'd had. I don't have the biggest brain in the world and I don't have the biggest working memory and I wasn't the most technical, but by trying to really get good at that prioritization, I think that's helped me and it still does.

**中文翻译:**
我在第一个团队是这么做的，后来管理礼品业务时也是如此。这项技能不仅帮助了我，还弥补了我可能存在的一些不足。我并不是世界上最聪明的人，也没有超强的记忆力，技术也不是最顶尖的，但通过努力精通优先级排序，我认为这对我帮助巨大，而且至今依然受用。

---

### [00:19:23] Ian McAllister (Continued)

**English:**
I think execute is the third one, which is no surprise that every PM has to execute. And I think assuming you prioritize well then execution means sort of molding what you want to build into a simple compact package that has the highest impact possible. And then also execution's a big function of the team you're working with. So it's your designers and your data science folks, and especially your engineers.

**中文翻译:**
我认为执行力是第三项，这并不奇怪，每个 PM 都必须具备执行力。我认为，在优先级排序得当的前提下，执行意味着将你想构建的东西塑造成一个简单、紧凑且具有最高影响力的方案。此外，执行力在很大程度上取决于你合作的团队，包括设计师、数据科学家，尤其是工程师。

---

### [00:19:47] Ian McAllister

**English:**
So anything to do with how well they're doing their jobs or how well they're resourced or whether they're getting better and better at every sprint, you have some amount of ownership in helping make that happen because that directly impacts your team's ability to execute and ultimately your reputation as well for being able to execute. The drive that goes into execution, product managers are the mode of power behind execution and impact. And if you stall out or you don't do your job, the project's probably going to stall out as well. And so you're the ones, especially with a TPM, if you're lucky enough to have one in the back of the ship, kind of beating the drum and driving everyone forward. But again, lots of people have written a lot of stuff about execution and there's a lot to it, but I think those are probably the three I'd focus on.

**中文翻译:**
因此，任何与他们工作表现、资源配置或每个冲刺（sprint）是否在进步相关的事情，你都有责任去推动，因为这直接影响到你团队的执行能力，并最终影响你作为 PM 的执行声誉。执行力背后的驱动力——产品经理是执行和影响力的动力源泉。如果你停滞不前或失职，项目很可能也会停滞。你就是那个在船尾敲鼓、驱动大家前进的人（如果你足够幸运能有一个 TPM 协助就更好了）。关于执行力，很多人写过很多东西，内容很深，但我认为这三项是初级 PM 最应关注的。

---

### [00:20:32] Lenny

**English:**
Awesome. And what's interesting about these three is if you look at the rest of the list, think big, understand technical trade offs, understand good design, I think what I would take away from this is those are the things you don't need to focus on that much when you're a new PM. Focus on, as you said, communication, prioritizing, executing. Focus less on these other things because later they'll become more and more important and obviously learn as much as you can, but it's almost bit easier to think about the things you don't need to stress about when you're starting out.

**中文翻译:**
太棒了。这三项有趣的地方在于，如果你看清单上的其他项——大局观、理解技术权衡、理解优秀设计——我想我从中得到的启发是：当你还是新 PM 时，不需要过度关注这些。正如你所说，专注于沟通、优先级排序和执行。少花点精力在其他事情上，因为以后它们会变得越来越重要。当然，要尽可能多地学习，但在起步阶段，知道哪些事情不需要太有压力，反而会让事情变得简单一些。

---

### [00:21:02] Ian McAllister

**English:**
Yeah, I think that makes sense. If there's a core or think about in year one as a PM, focusing on those things. And you can develop other skills over time. But yeah, I think you're spot on there.

**中文翻译:**
是的，我觉得有道理。如果说 PM 第一年有什么核心任务，那就是专注于这些事情。其他技能可以随着时间的推移慢慢培养。你总结得很到位。

---

### [00:21:14] Lenny

**English:**
If we were to go back through these three, just maybe as a last question, and you may not have an answer to this, but if you think about communicating, prioritizing, and executing, is there one tactical thing you could suggest that a PM listening to this can do to get better at one of these things? Is there a trick you've learned of, wow, this is one way you could level up communicating, executing, prioritizing or not?

**中文翻译:**
如果我们回顾这三项，作为最后一个问题（你可能没有现成的答案）：关于沟通、优先级排序和执行，你能不能给正在听播客的 PM 们提供一个具体的战术建议，让他们能在这方面有所提升？有没有什么你学到的“秘诀”，比如“哇，这就是提升沟通/执行/优先级排序水平的方法”？

---

### [00:21:37] Ian McAllister

**English:**
The closest thing to a checklist, the post I mentioned, the Operator's Manual, that was the closest thing to, if you do these things, these specific actions, I think it'll go a long way. Because a lot of them are guided around not doing the easy pitfalls and communication mistakes like rambling. If you're asked a question and you explain and then maybe you get to the answer, if you just think, answer and then explain or sometimes answer and then shut up, that actually is a tactical thing you can do to get better at communicating. And there's some other tips in there as well. So that was my attempt to try to encode, to take some of the ones that we gathered early at Amazon, add some more. The others are ... Yeah. There's no just simple trick unfortunately to prioritize other than ... I mean I think working backwards is a good technique to have impact to guide your prioritization. And that is something where it's not a simple tip, but there's a set of practices and behaviors that you can do that will ultimately lead you to prioritize better.

**中文翻译:**
最接近清单的东西就是我提到的那篇《操作手册》，如果你按照里面具体的行动去做，会有很大帮助。因为其中很多内容都是为了避免常见的陷阱和沟通错误，比如东拉西扯。如果你被问到一个问题，你先解释一通，最后才给出答案，那么你可以试着反过来：先给答案再解释，或者有时给完答案就闭嘴。这确实是一个可以提升沟通能力的战术动作。手册里还有其他技巧。那是我尝试将我们在亚马逊早期收集的一些经验进行编码并扩充的结果。至于其他的……不幸的是，优先级排序没有什么简单的秘诀，除了……我认为“逆向工作法”是一个很好的技术，可以用影响力来指导你的优先级排序。这不是一个简单的技巧，而是一套实践和行为准则，最终会引导你做出更好的优先级决策。

---

### [00:22:58] Lenny

**English:**
And then I think communication, the simple tip was just grade yourself after you communicate and try to just take a moment and after a while you'll just do it naturally to think about, "Gosh, how would I have answered that question better?" And so the next time you could try to answer that question better and it's just a continuous improvement process. Or maybe even ask your manager, "Hey, what could I have done better in terms of how I communicated in that last meeting or that last email?"

**中文翻译:**
关于沟通，那个简单的建议就是：在沟通之后给自己打分。花点时间反思一下，久而久之你就会自然而然地想：“天哪，我怎样才能更好地回答那个问题？”这样下次你就能做得更好，这是一个持续改进的过程。或者甚至可以问你的经理：“嘿，在刚才的会议或那封邮件中，我的沟通方式有哪些可以改进的地方？”

---

### [00:23:04] Ian McAllister

**English:**
Yeah, absolutely. Absolutely.

**中文翻译:**
是的，完全正确。

---

### [00:23:06] Lenny

**English:**
Okay, so then coming at it from the other direction, say you're a senior PM, what are three of these attributes that you would suggest folks focus on to get better and level up in their career?

**中文翻译:**
好，那我们从另一个角度来看。假设你是一名资深 PM，你会建议大家关注清单中的哪三项特质，以便在职业生涯中进一步提升？

---

### [00:23:17] Ian McAllister

**English:**
Gosh, it's still communicate, to be honest. I think that's the one at every level of product, just the stakes are higher. I think think big is one for sure. There was a phrase I think Warren Buffett in the Berkshire Hathaway letter used at some point. Was at our scale we got to hunt for bigger elephants. And so I think at any scale as a PM, whatever your idea is or whatever your solution or the problem you're solving, take a minute at the beginning to say, could this be bigger? Could this be a bigger thing and more impactful than the initial idea, even if the initial idea sounds big? So that's a tool and that's often where I'd start when my PMs were sharing an idea is I'd try to expand it to the degree it might be expanded, think about it from that perspective and then maybe you want to still start small, but with a bigger vision in mind.

**中文翻译:**
天哪，说实话，还是**沟通**。我认为在产品的任何级别，沟通都至关重要，只是职级越高，影响越大。第二项肯定是**大局观（Think Big）**。沃伦·巴菲特在伯克希尔·哈撒韦的致股东信中曾说过一句话：在我们的规模下，我们必须去猎捕更大的大象。我认为作为 PM，无论你的规模如何，无论你的想法、解决方案或要解决的问题是什么，在开始时花一分钟想一想：这能不能做得更大？它能不能比最初的想法更有影响力？即使最初的想法听起来已经很大了。这是一种工具。当我的 PM 们分享想法时，我通常会从这里开始：尝试将其扩展到可能的极限，从那个角度思考，然后也许你仍然选择从小处着手，但心中要有一个更宏大的愿景。

---

### [00:24:04] Ian McAllister

**English:**
Earn trust is a huge one and that's kind of why I added it more recently. And it becomes even more important as you get into senior roles because I think it's truly the currency of a product leader or probably any leader in any function. Because if you want to ask for more resources to do something bigger, if your leadership doesn't trust you to use those resources well or do what you said you're going to do, you're probably not going to get them. But if you've built trust that you're a good steward of resources and you make a lot of impact with a given team, that's directly going to correlate with your ability to gain more resources. Trust is just built by repeatedly setting and meeting expectations. And I think that's a good mantra to think about as a FM. Am I meeting the expectations that I set? And not just doing good things, but calling your shots, forecasting, setting a goal, and then hitting it.

**中文翻译:**
**赢得信任（Earn trust）**是非常关键的一项，这也是我最近把它加进去的原因。当你进入资深角色时，它变得更加重要，因为我认为它确实是产品领导者（或者任何职能部门的领导者）的“货币”。如果你想申请更多资源去做更大的事情，如果领导层不信任你能用好这些资源，或者不相信你能兑现承诺，你很可能拿不到资源。但如果你已经建立了信任，证明你是一个优秀的资源管理者，并且能带领团队创造巨大影响，这直接关系到你获取更多资源的能力。信任是通过反复设定并达成预期而建立的。我认为这是一个很好的 PM 准则：我是否达到了我设定的预期？不仅要做正确的事，还要明确目标、进行预测、设定目标并最终达成。

---

### [00:24:54] Ian McAllister (Continued)

**English:**
And if you do that repeatedly, you're going to be in pretty good shape. And there's so many practices as a product manager or product leader that build trust. You tell the truth without fail. And you launch when you say you'd launch and you launch what you said you'd launch and you own your mistakes. And then the other practices just lose trust. If you lie or if you're evasive, if you don't ship what you said you're going to do, if you ignore your mistakes or you repeat them. And so I think just simply having high standards for yourself and think of trust as that currency, that's going to correlate well as a PM, as a GPM or director of product in any level, that's the thing that you want to build.

**中文翻译:**
如果你能反复做到这一点，你的处境就会非常好。作为 PM 或产品领导者，有很多建立信任的实践：始终如一地讲真话；在承诺的时间发布承诺的产品；勇于承认错误。反之，有些行为会让你失去信任：撒谎或闪烁其词；没有交付承诺的东西；忽视错误或重蹈覆辙。因此，我认为只要对自己保持高标准，并将信任视为那种“货币”，无论你是 PM、高级 PM 还是产品总监，这都是你想要构建的核心资产。

---

### [00:25:34] Lenny

**English:**
So thinking big, building trust. Was there a third?

**中文翻译:**
大局观、建立信任。还有第三个吗？

---

### [00:25:37] Ian McAllister

**English:**
I think maybe the last one, which is certainly relevant for a PM but is really true as well, is driven by impact. And if you forget about everything else, forget about politics, forget about promotion or having a bigger org or whatever, if you simply wake up every day trying to have the biggest impact you can, or if you're a leader trying to use your team to have the biggest impact you can in the company, which will influence how you build your roadmap and how you do every part of your day, that's a really good guiding light. And I remember in my first 10 years at Amazon, just naturally not because I thought about it, I was just hungry to have an impact. Take my business, grow it as fast as possible. I wasn't maybe loosely thinking about promotion, but I wasn't thinking about it. I never talked to my manager about it and I wasn't bringing it up. I was just focused on taking my book of business and making it bigger. And then the net result was I was promoted several times and I did grow in my role, but that wasn't what drove me. It was just the impact.

**中文翻译:**
我想最后一个可能是**受影响力驱动（Driven by impact）**。这对 PM 来说非常相关，也极其真实。如果你忘掉其他一切，忘掉政治、晋升或扩大团队规模，如果你只是每天醒来都想着如何创造最大的影响力，或者作为领导者想着如何利用团队为公司创造最大价值，这会影响你如何制定路线图，以及你如何度过每一天。这真的是一个很好的指路明灯。我记得在亚马逊的前 10 年里，我并不是刻意去想这些，我只是渴望创造影响力。接手业务，尽可能快地增长。我可能隐约想过晋升，但那不是我的核心关注点。我从未和经理谈过晋升，也没提过。我只是专注于把我的业务版图做大。最终的结果是我被晋升了好几次，职位也得到了提升，但那并不是驱动我的动力，影响力才是。

---

### [00:26:38] Lenny

**English:**
Would you say that driving impact is more important for a new PM or senior PM? It feels like impact is the soup within which all PMs swim and that's constantly important, but it's interesting that you mostly put that into the latter part of a career. Do you feel like with new PMs on your team you're less expecting them to think about impact and focus on impact?

**中文翻译:**
你会说“驱动影响力”对新 PM 还是资深 PM 更重要？感觉影响力就像是所有 PM 赖以生存的“养料”，一直都很重要，但很有趣的是你主要把它放在了职业生涯的后期。你是否觉得对于团队里的新 PM，你对他们思考和关注影响力的期望较低？

---

### [00:27:01] Ian McAllister

**English:**
Well, I mean I think for junior PMs, if you're a brand new PM, then yeah, you want to have an impact, but you're really just ... You have a project or a feature to ship or something like that and you're often not necessarily given a lot of latitude to build your own roadmap. But you're asked to ship this. So you want to spec it, you want to execute and do it. But increasingly as you grow, there are opportunities to sense out and try to have a bigger impact maybe and then start to influence prioritization or roadmaps. It's just that the expectations, it goes from being a nice to have as a junior or first time PM to as you get a little more senior, hopefully if things work the way they should work, that's really how you're evaluated. Yes, you want to treat your team well and you want to do a whole bunch of other things, but take two people, one has a massive impact on the business and one who doesn't, then the right way to work should be that first person should be the one that grows and develops and is tasked and with bigger challenges just because if you're impactful at a bigger challenge, that's even more important for the business. So I think that's a good way to think about the flywheel of product leadership.

**中文翻译:**
嗯，我认为对于初级 PM，如果你是一个全新的 PM，你当然想创造影响，但你实际上只是……你有一个要发布的项目或功能，通常你没有太大的自由度去制定自己的路线图。你被要求交付这个东西，所以你要写规格说明书，去执行并完成它。但随着你的成长，会有越来越多的机会去感知并尝试创造更大的影响，然后开始影响优先级排序或路线图。这只是期望值的变化：对于初级或第一次做 PM 的人来说，这可能是“锦上添花”；但当你变得资深时，如果一切运作正常，这才是你被评估的核心标准。是的，你要善待团队，要做很多其他事情，但如果有两个人，一个对业务产生了巨大影响，另一个没有，那么正确的职场逻辑应该是：第一个人获得成长、发展并被赋予更大的挑战。因为如果你能在更大的挑战中产生影响，那对业务来说就更重要了。我认为这是思考产品领导力“飞轮”的一个好方法。

---

### [00:28:11] Lenny

**English:**
It feels like a lot of times you get lucky as a new PM. You work on a project that ends up having a lot of impact that you didn't necessarily drive. You just happen to work on something that, wow, this was a huge deal and that feels like an important thing to optimize for a little in your early career is work on something that's likely to have a lot of impact even if you're not responsible for setting the strategy and prioritizing.

**中文翻译:**
感觉很多时候新 PM 靠的是运气。你参与了一个最终产生巨大影响的项目，但这不一定是你驱动的。你只是碰巧在做一个“大项目”。这似乎是职业生涯早期值得优化的一点：去参与那些可能有巨大影响力的项目，即使你并不负责制定战略和优先级。

---

### [00:28:29] Ian McAllister

**English:**
Well, I think that's true if you have a choice in where you work in product. If you have a choice to work on something that's part of offense, something that drives the business. And it's true that executives wake up if something drives dollars or customers or offense things and it just maybe shouldn't be this way, but a little less interested in things that maybe less than a risk that just the risk never happens, it comes to pass or a cost center that operates a little more efficiently. So that it's one lens where that might relate to your success. I think also who you work for. And I think most of us don't get to choose that especially early in our career. It either works out in your favor and which is great and that was the case for me, especially at Amazon, some of the leaders I worked with. But sometimes it doesn't. But I think the more that you can suss out who you work for because then the better they are at these skills and prioritizing, one, they're just going to be a better teacher and a better role model to learn from. So I think that's an important thing to think about in any kind of job change.

**中文翻译:**
如果你在产品领域有选择权的话，确实如此。如果你能选择去做一些属于“进攻型”的事情，即驱动业务增长的事情。事实是，如果某件事能带来收入、客户或属于进攻性策略，高管们就会精神抖擞。虽然也许不该这样，但他们对那些降低从未发生过的风险的事情，或者让成本中心运作得更高效一点的事情，兴趣会稍微小一些。所以这是衡量成功的一个视角。我认为另一个因素是你为谁工作。我们大多数人，尤其是在职业生涯早期，无法选择老板。要么运气好（我就是这样，尤其是在亚马逊，遇到了一些很棒的领导），要么运气不好。但我认为，你越能看清你在为谁工作越好，因为如果他们擅长这些技能和优先级排序，他们就会是更好的老师和榜样。我认为这是在任何职业变动中都需要考虑的重要一点。

---

### [00:29:30] Lenny

**English:**
To close the loop on this piece for more senior PMs, the skills to focus on, you said, thinking big, building trust and driving impact. I'll put you on the spot. I'll give you two options, two directions to go with this. One is if you want to get better at each of these three things, do you have any one thing someone could do or what does great look like for thinking big or building trust or driving impact? Those are two options.

**中文翻译:**
为了总结资深 PM 需要关注的技能，你提到了：大局观、建立信任和驱动影响力。我想考考你，给你两个选择或方向：一是如果你想在这三方面都做得更好，有没有什么具体的事情可以做？二是对于大局观、建立信任或驱动影响力，“优秀”到底长什么样？

---

### [00:29:58] Ian McAllister

**English:**
That was six questions there Lenny. Let me see here what I'm answering. Well, I think the think big one is interesting and one way to think about thinking big, especially as you grow in your career is most people operate within a box. There's a box of there's product management and these are the things that product managers do. And you basically build a roadmap and you prioritize features and you work with eng. And so that might be the typical kind of product scope and tech. Most of my roles were ones where I was kind of a GM but a really product focused GM and so I naturally found myself taking a much wider view of what product is across disciplines. And I was lucky enough that I had engineering teams and marketers and analysts and other folks and so that helped me. But I think as a PM you can still do that, even if those functions don't report to you, is take that really wide view of what success for your product is and not have the blinders on its product or tech.

**中文翻译:**
Lenny，你这一下提了六个问题啊。让我想想该怎么回答。关于“大局观”，我觉得很有趣的一点是，随着职业生涯的发展，大多数人都在一个“框框”里工作。这个框框就是“产品管理”，里面是 PM 该做的事：制定路线图、排优先级、和工程团队合作。这可能是典型的产品和技术范畴。我的大多数角色更像是总经理（GM），但又是非常关注产品的 GM，所以我自然而然地会从跨学科的角度更广泛地看待产品。我很幸运，拥有工程团队、市场营销人员、分析师等，这对我很有帮助。但作为 PM，即使这些职能部门不向你汇报，你依然可以做到这一点：对产品的成功持有非常广阔的视野，不要只盯着产品或技术。

---

### [00:30:58] Ian McAllister

**English:**
It's anything. It's anything that influences the success and your customers' success or anything else. And it just means, you don't own marketing or you don't own this other function, but you own it until you find somebody else to own it. And so that's not necessarily thinking big in terms of scale or whatever, but in terms of how you think about your role as a PM and what your ownership responsibility is. And so I think just the more that you ... You don't want to get over your skis as a PM and then you're trying to change your CFO's mind about something necessarily. But the more you grow, that you have to increasingly do that and find the constraints or barriers to your success or your product success and knock them down no matter what they are.

**中文翻译:**
它是任何事情。任何影响成功、影响客户成功或其他任何事情的因素。这意味着，虽然你不负责市场营销或其他职能，但在你找到其他人负责之前，你就要负责。这不一定是指规模上的“大局观”，而是指你如何看待自己作为 PM 的角色以及你的所有权责任。我认为……作为 PM，你不想越权去改变 CFO 的想法，但随着你的成长，你必须越来越多地去寻找那些阻碍你或产品成功的约束或障碍，并无论它们是什么，都将其击碎。

---

### [00:31:43] Lenny

**English:**
Yeah. It makes me think about just the advice of think like an owner, think beyond just your one little bubble, think about the broader business outside of the one little product you might be working on. So that's great advice.

**中文翻译:**
是的。这让我想起了那句建议：像所有者一样思考（think like an owner），跳出你自己的小圈子，去思考你所负责的小产品之外的更广泛的业务。这是非常棒的建议。

---

### [00:31:55] Lenny (Ad: Assembly AI)

**English:**
This episode is brought to you by Assembly AI. If you're looking to build powerful AI powered features in your audio or video products, then you need to know about Assembly AI. Assembly AI is the API platform for state-of-the-art AI models that thousands of product led growth companies like Spotify, Loom and CallRail are using to infuse AI into their products. With simple APIs, developers and PMs can get access to powerful AI models for transcription, summarization and dozens of other tasks that are fast, secure and production ready. All of their models are researched and trained in house and continuously updated by their team of AI experts, which for a PM, makes it easy to build and ship new AI powered features. Product teams at startups and enterprises are using assembly AI to automatically transcribe and summarize phone calls and virtual meetings, detect topics and podcasts, pinpoint when sensitive content is spoken, redact PII from audio videos and way more. Visit assemblyai.com to try Assembly AI's API for free and start testing their models in their no code playground. That's assemblyai.com.

**中文翻译:**
本集节目由 Assembly AI 赞助。如果你想在音频或视频产品中构建强大的 AI 功能，那么你需要了解 Assembly AI。Assembly AI 是一个提供最先进 AI 模型的 API 平台，成千上万家以产品驱动增长的公司（如 Spotify、Loom 和 CallRail）都在使用它将 AI 注入产品。通过简单的 API，开发人员和 PM 可以访问强大的 AI 模型，用于转录、摘要以及数十项其他任务，这些模型快速、安全且已具备生产就绪能力。他们所有的模型都是内部研发和训练的，并由 AI 专家团队持续更新，这让 PM 能够轻松构建和发布新的 AI 驱动功能。初创公司和企业的团队正在使用 Assembly AI 自动转录和总结电话及虚拟会议、检测播客主题、识别敏感内容、脱敏音视频中的个人身份信息（PII）等等。访问 assemblyai.com 免费试用 Assembly AI 的 API，并在其无代码游乐场中测试模型。网址是 assemblyai.com。

---

### [00:33:08] Lenny

**English:**
Before we move on to the working backwards piece, which I'm excited to get into, is there anything else you want to share on this thread?

**中文翻译:**
在我们进入我非常期待的“逆向工作法”话题之前，关于这个话题你还有什么想分享的吗？

---

### [00:33:15] Ian McAllister

**English:**
I might just talk about earn trust because this is one that I didn't put in there initially and I honestly don't think that I recognized the importance of it early on in my career or even in the middle of my career and it's been in the last couple years that I really understood the importance of it. My wife Sarah is a product manager in AWS and so as I've mentored her a little bit in her career and I've seen how this is really a superpower for her, it really made me reflect like, what are the things I could have done better in different roles to earn trust more? And it's not just the basic things like to be honest and tell two different people the same thing versus different things. I think it's trying to really understand, work backwards from that person and what are their goals and what are their organization's goals and honestly spend the time and the energy to try to get to alignment in the same place.

**中文翻译:**
我可能想再聊聊“赢得信任”，因为这是我最初没放进去的一项。老实说，在职业生涯早期甚至中期，我都没有意识到它的重要性，直到最近几年我才真正理解。我的妻子 Sarah 是 AWS 的一名产品经理，在我指导她职业生涯的过程中，我看到这如何成为了她的“超能力”，这让我反思：在不同的角色中，我本可以做些什么来更好地赢得信任？这不仅仅是诚实、对不同的人说同样的话这些基本的事情。我认为是去真正理解对方，从对方的角度逆向思考：他们的目标是什么？他们组织的目标是什么？并诚实地投入时间和精力，尝试达成共识。

---

### [00:34:09] Ian McAllister

**English:**
And be willing, not just bullheaded, which I might have been earlier in my career, maybe still to many people, but charging forth what do I think's right but taking some more time to try to forge an alliance with someone because if you do that you're ultimately going to be more successful. So that was just one that I was probably slow to recognize the importance of and I'm trying to catch up now.

**中文翻译:**
要愿意去沟通，而不是固执己见。我职业生涯早期可能比较固执（也许现在对很多人来说依然如此），总是冲在前面做我认为正确的事，但其实应该多花点时间尝试与他人结成联盟，因为如果你这样做，最终会更成功。这是我意识到得比较晚的一点，现在我正在努力补课。

---

### [00:34:30] Lenny

**English:**
Is there a story that comes to mind where you look back and I should have earned trust there or I broke some trust here that you'd be willing to share?

**中文翻译:**
有没有什么故事让你回想起来觉得“我当时本该在那里赢得信任”或者“我在这里破坏了信任”？你愿意分享一下吗？

---

### [00:34:39] Ian McAllister

**English:**
When I was working with you and the team at Airbnb, I think this is one where Joebot brought me on to help build out the customer support technology platform maybe more how Amazon would do it. To maintain a high level of quality but to become more efficient as well and to reduce the cost so that Airbnb wouldn't have to scale customer support this to the same degree the business was scaling. And so trying to build a new team and develop and I was pretty heads down doing it the way I thought it should be done and working with the team there in terms of let's get a strong analytics framework. Let's measure all these things and really understand what's going on at the data level and then let's use the same prioritization muscles that had made me successful at Amazon to prioritize things that were best worked backwards.

**中文翻译:**
当我和你以及 Airbnb 的团队共事时，Joebot 招我过去是希望我能帮助构建客户支持技术平台，也许更倾向于亚马逊的方式：在保持高质量的同时提高效率并降低成本，这样 Airbnb 就不需要随着业务规模的扩大而同比例扩大客户支持团队。于是我尝试组建新团队，埋头苦干，按照我认为正确的方式去做：建立强大的分析框架，衡量所有指标，从数据层面深入了解现状，然后利用在亚马逊让我成功的优先级排序能力，去优先处理那些最适合“逆向工作”的事情。

---

### [00:35:26] Ian McAllister

**English:**
And I think that what I didn't do as much as I should have is obviously really partnering with the customer support leadership team as well. That was something where I think in some ways it felt like we were in alignment and getting on stage together and stuff, but it turned out I maybe hadn't spent as much time and effort on that as I thought to build that true support there such that that leader would rally the organization around it as well and we'd be marching in the same beat. And so that was something that I would reflect. Now, I think the team did amazing things and Shirley really carrying the torch there in the entire team and so accomplished a lot. But that was a learning about ... Going back, I probably would've spent more time and really tried to do even more on that.

**中文翻译:**
我认为我做得不够的地方是，显然没有与客户支持领导团队建立足够紧密的伙伴关系。在某些方面，感觉我们是达成一致的，比如一起上台演讲之类的，但事实证明，我可能没有投入足够的时间和精力去建立那种真正的支持，让那位领导者也能动员整个组织支持我们的工作，从而步调一致。这是我反思的地方。虽然我认为团队做出了了不起的成就，Shirley 和整个团队都表现出色，完成了很多目标。但这是一个教训……如果回到过去，我可能会花更多时间在那上面，尝试做得更多。

---

### [00:36:12] Lenny

**English:**
Thanks for sharing that. I never knew that story. And it sounds like the takeaway there is maybe don't take for granted the leadership team, the team that'll actually be using the product. Is that a roughly way to think about it?

**中文翻译:**
谢谢分享。我以前从没听过这个故事。听起来其中的教训是：不要想当然地认为领导团队（即真正使用产品的那组人）会理所当然地支持你。可以这么理解吗？

---

### [00:36:23] Ian McAllister

**English:**
Well I would say that if you have a certain approach you may be believe it's the right one and it may be the right one, but if you don't build the support and the relationships that they're going to help carry that out and execute on that strategy, it may not get executed as well as you think it should be. And so that is an important part of success. It's a risk that you have to mitigate. And trying to earn trust and to do it that way is a way to mitigate that risk that the right product and the right direction and the right strategy, it may not land if you don't have that support that you need. And so that I think was my learning.

**中文翻译:**
我想说的是，如果你有一种方法，你可能坚信它是正确的，它也确实可能是正确的，但如果你没有建立起能帮助你推行和执行该战略的支持和关系，它的执行效果可能就不会像你预想的那么好。这是成功的关键组成部分，是你必须减轻的一种风险。努力赢得信任并以此方式行事，是降低这种风险的一种手段：即使产品、方向和战略都是正确的，如果没有所需的支持，它也可能无法落地。这就是我的教训。

---

### [00:37:00] Lenny

**English:**
What better way to learn a lesson than get some wrong and then you never forget it again.

**中文翻译:**
学习教训最好的方式莫过于犯点错，然后你就永远不会忘记了。

---

### [00:37:06] Ian McAllister

**English:**
You could call it getting wrong. Just think of something I could have done better. And just that same continuous improvement mindset. It's to everything, every role, every experience, every project, every communication. And if you build that muscle to try to do it better the next time and also just the try to be a little self aware about what could have gone better, then I think it's a really good muscle to build.

**中文翻译:**
你可以称之为犯错，我则看作是“本可以做得更好”的事情。这就是那种持续改进的心态。它适用于一切：每个角色、每段经历、每个项目、每次沟通。如果你能建立起这种“下次做得更好”的肌肉记忆，并尝试对哪些地方可以改进保持自觉，那么我认为这是一种非常值得培养的能力。

---

### [00:37:27] Lenny

**English:**
This is a good segue to the second area of where our chat is going to go, which is Amazon and things you've learned about just the working backwards process. How many years did you say you worked at Amazon total?

**中文翻译:**
这正好引出了我们聊天的第二个领域：亚马逊，以及你从“逆向工作法”中学到的东西。你刚才说你在亚马逊总共工作了多少年？

---

### [00:37:38] Ian McAllister

**English:**
12 years.

**中文翻译:**
12 年。

---

### [00:37:39] Lenny

**English:**
12 years. It feels like everyone that worked at Amazon is 10 years or more. It's these large numbers. So they must be doing something right and I don't know. What do you think that is actually? Why do people stay there so long? It's amazing.

**中文翻译:**
12 年。感觉每个在亚马逊工作过的人都待了 10 年以上。都是这么大的数字。所以他们一定做对了一些事情。你觉得原因到底是什么？为什么人们在那儿待那么久？太神奇了。

---

### [00:37:52] Ian McAllister

**English:**
What's interesting about Amazon, and it's changed over time, is that I think pretty quickly whether you're a fit for it or not. And it can be kind of a crucible and a little spartan. And it just clicked with me though because I'm kind of a structured thinker and right brain. And so this idea that hey, I could have this business and then figure out one metric or fitness function that determines success and then my job is to make that number go up and to the right. That kind of fit with me. And then I rewired my brain probably over the first 10 years around this concept and I just felt like I was learning, I was not only working with smart people that were driven, which was true at Microsoft as well, but there was kind of this DNA in the organization and this wiring that I thought was really effective and it just kind of clicked with me.

**中文翻译:**
亚马逊有趣的地方在于（虽然它随时间在变化），你很快就能发现自己是否适合那里。它可能像一个“熔炉”，环境有点艰苦。但它很合我的胃口，因为我是一个结构化思考者，偏向右脑思维。这种理念——嘿，我可以负责这项业务，然后找出一个衡量成功的指标或“适应度函数”，我的工作就是让那个数字持续增长——非常适合我。在最初的 10 年里，我围绕这个概念重塑了我的大脑。我觉得自己一直在学习，不仅是与聪明且有动力的人共事（这在微软也是如此），而且组织中有一种 DNA 和运作方式，我认为非常有效，它和我产生了共鸣。

---

### [00:38:44] Ian McAllister

**English:**
And so I molded myself to the environment and at every step of the way I felt like I was learning and growing and one of the benefits for me is you get a chance to learn from so many other people in these different settings. You get the chance to read documents that make you learn more so than probably a slide deck. You get a chance to be in weekly business reviews with really smart people and learn from that. Not just learn from your own experience but from everyone else in that room. So I was just a sponge and so much learning happening that I think propelled my career. And so that was why, especially the first 10 years, that it was so fantastic of just growing and feeling yourself build these new muscles and develop these new tools and I loved it. So that was why I stayed so long and obviously Airbnb then, it was the time to try something new, which was a great experience and kind of a test. I was in Seattle and the company was in San Francisco and spending three days on a road each week was a good learning and ultimately a reason to come back and be Seattle based. But then I chose Amazon again because it was still a great place and I thought I could continue to learn.

**中文翻译:**
于是我让自己适应了那个环境，每一步我都觉得自己在学习和成长。对我来说，好处之一是你可以在不同的场景下向很多人学习。你有机会阅读那些比幻灯片更能让你学到东西的文档。你有机会参加每周业务回顾（WBR），与极其聪明的人交流并从中学习。不仅从自己的经验中学习，还从房间里的每个人身上学习。我当时就像一块海绵，大量的学习推动了我的职业生涯。这就是为什么前 10 年感觉如此美妙，看着自己建立起新的能力，开发出新的工具，我非常热爱。这就是我待那么久的原因。后来去 Airbnb 是为了尝试新事物，那是一段很棒的经历，也是一种考验。当时我住在西雅图，公司在旧金山，每周有三天在路上，这让我学到了很多，但也最终成了我回到西雅图的原因。后来我再次选择了亚马逊，因为它依然是一个伟大的地方，我觉得我可以继续学习。

---

### [00:39:52] Lenny

**English:**
Amazing. I was going to mention they drew you back in. So yeah, that's pretty rare. What did you learn from folks like Jeff Bezos and Jeff Wilke about building product leadership, company building? What's stuck with you working with folks like?

**中文翻译:**
太神奇了。我正想说他们又把你吸引回去了。这确实挺少见的。你从杰夫·贝佐斯（Jeff Bezos）和杰夫·威尔克（Jeff Wilke）这样的人身上学到了哪些关于构建产品领导力和公司建设的经验？和他们共事有哪些让你记忆深刻的点？

---

### [00:40:04] Ian McAllister

**English:**
I would say two very different people but complimented themselves so well. I didn't have hundreds of meetings with Jeff Bezos while I was there, but I did have a chance, especially in the development of Amazon Smile and then early when I started the social team to have some of those meetings where I wrote the doc and it was Jeff and 10 other people reviewing. The process of doing, even before hitting on Amazon Smile, it was really kind of a innovation process I guess you could call it, where we had a goal in mind to increase customers' loyalty to Amazon, their direct traffic loyalty, not in the way Prime did, which is a paid program, but to try to come up with another program or way in which customers might start their shopping on Amazon instead of elsewhere. And so I was running the gifting business. I moved over to the traffic org to try to come up with a new program with no team or anything.

**中文翻译:**
我会说他们是两个截然不同但又互补得非常好的人。我在那儿的时候并没有和贝佐斯开过几百次会，但我确实有机会（特别是在开发 Amazon Smile 期间，以及早期我组建社交团队时）参加了一些会议，由我撰写文档，杰夫和其他 10 个人进行评审。在确定 Amazon Smile 之前，那实际上是一个创新过程，我们的目标是提高客户对亚马逊的忠诚度，即直接流量忠诚度。不是像 Prime 那样的付费计划，而是尝试提出另一种计划或方式，让客户在购物时首先想到亚马逊而不是其他地方。当时我负责礼品业务，后来调到流量部门，在没有团队的情况下尝试构思一个新计划。

---

### [00:40:58] Ian McAllister

**English:**
And then I would meet with Jeff Bezos and Wilke and others every couple months and I would profile a couple different options and use the working backwards process and we'd review some facts. And so there was a bunch of learnings throughout that process. One, I found Jeff to be super encouraging. And each time we'd leave one of those meetings, we maybe didn't find the thing in that meeting. We'd talk about it and brainstorm a little bit, but he would always leave and be encouraging and with a quote. One time he was like, "Remember, this process doesn't have to be efficient because the prerequisite for efficiency is knowing where you're going." And then he'd leave the room and whatever. So I found the rhetoric around Jeff or blowing up or whatever, I didn't find any of that and I found him to be super encouraging and he found all these times to help train me in the working backwards process.

**中文翻译:**
然后我会每隔几个月与贝佐斯、威尔克等人见面，我会列出几个不同的选项，使用“逆向工作法”，我们会审查一些事实。在这个过程中我学到了很多。第一，我发现杰夫非常平易近人且给人以鼓励。每次会议结束时，即使我们没能在会上找到最终方案，我们会讨论并头脑风暴一下，他离开时总是会说些鼓励的话，或者引用一段名言。有一次他说：“记住，这个过程不一定要高效，因为高效的前提是知道你要去哪里。”然后他就离开了。所以我发现外界传闻的杰夫脾气暴躁之类的，我完全没遇到，反而觉得他非常鼓励人，他利用这些机会训练我掌握“逆向工作法”。

---

### [00:41:52] Ian McAllister

**English:**
There was a time when I came with a press release for a concept and it didn't have a problem paragraph. I'd skipped that. And he reviewed it and so forth and he was like, "You know what, maybe if you don't have a problem paragraph, there's not really a problem." And so it was kind of a little lesson to me like, "Yeah, maybe that is why I did it. I wasn't really working backwards, I kind of had the solution in mind and so I'd skipped over that part." So that was one just very specific learning about the process from Jeff. So Jeff Wilke, I probably learned more from Wilke just because I had more exposure over my time there. At one point he was my skip level. And I have such tremendous respect for Wilke or Jaw as he was called internally because he was sort of the consummate operator.

**中文翻译:**
有一次，我带着一个概念的新闻稿（Press Release）去开会，但里面没有写“问题段落”（problem paragraph），我跳过了那部分。他看完后说：“你知道吗，如果你没有写问题段落，可能说明根本就没有问题。”这对我来说是一个小小的教训：是的，也许这就是我漏掉它的原因。我当时并没有真正地逆向思考，我脑子里已经有了解决方案，所以跳过了问题部分。这是从杰夫那里学到的关于流程的一个非常具体的点。至于杰夫·威尔克，我从他身上学到的可能更多，因为我在那儿期间与他的接触更多。有一段时间他是我的隔级上司。我对威尔克（内部称他为 Jaw）怀有巨大的敬意，因为他是一个完美的运营者。

---

### [00:42:34] Ian McAllister

**English:**
This muscle that I think you learn working at Amazon about being an operator, whether you're ... You're not in operations, but any part of the business that I think came from him. And I think it was due to him that Amazon developed that muscle. And I think it's one way that separates some Amazon PMs from people who haven't worked there in that environment and that continuous improvement mindset. That's so important. And one of the forums that was a great learning was the WBR or Weekly Business Review. Or later called Consumer Business Review. So this was a forum where Jeff would lead the meeting. It would be a series of metrics for different parts of the business. Everywhere from fulfillment to customer support, to traffic to category teams to programs. And I would present on Amazon Smile there. And the way he would run that meeting and enable you to get through a metrics meeting for the entire North American retail business in one hour.

**中文翻译:**
我认为在亚马逊工作学到的那种“运营者”能力（无论你是否在运营部门，而是业务的任何部分），很大程度上都源自他。我认为正是因为他，亚马逊才培养出了这种能力。这也是区分亚马逊 PM 与其他未在那种环境下工作过的人的一个特征，即那种持续改进的心态。这太重要了。其中一个非常棒的学习场所是 WBR（每周业务回顾），后来改名为消费者业务回顾。杰夫会主持这个会议，涉及业务各个环节的一系列指标：从履约到客户支持，从流量到品类团队再到各个项目。我会在会上汇报 Amazon Smile 的情况。他主持会议的方式能让你在一小时内过完整个北美零售业务的所有指标。

---

### [00:43:27] Ian McAllister

**English:**
And the way he ran that meeting would lead all those leaders to build these muscles because you wanted to be prepared to speak to the variances or trends in your business in a key metric and know your business and know what you were doing based on that thing. And so just this hour a week of probing and asking questions and everyone ... There might be a hundred people in that room prepared to answer questions about your business. And it had this cascading effect that not only was I or the leaders there on the spot having to answer a question and being prepared, but then I would do the same thing with my team, et cetera. And so I was trying to build those muscles in my team such that they could bring their insights and understanding and actions on things in this cascading effect. So that was a mechanism, which is another really big thing at Amazon that led to all these amazing behaviors.

**中文翻译:**
他主持会议的方式引导所有领导者建立了这种能力，因为你必须准备好解释关键指标的波动或趋势，了解你的业务，并知道你根据这些数据在做什么。每周一小时的深入追问，房间里可能有 100 个人准备回答关于你业务的问题。这产生了一种级联效应：不仅是我或现场的领导者必须准备好回答问题，我也会对我的团队做同样的要求。我尝试在我的团队中建立这种能力，让他们能带着洞察、理解和行动方案来开会。这就是一种“机制”（mechanism），这是亚马逊另一件非常了不起的事情，它催生了所有这些惊人的行为。

---

### [00:44:17] Ian McAllister

**English:**
And I think a lot of those mechanisms came from Jeff Wilke or he created an environment where they would be developed throughout the organization and then propagated. And so that was one thing, just that operational mindset and rigor that being a product leader is not just about building new things, it's about how well you run what you've already built. And if you're really paying attention to the product that you operate, it will give you ideas for things you could do to double down on something that's happening well or to prevent something bad happening. And I think that's been a very key reason for Amazon's scale. Another thing I really respect about Jeff Wilke, and I think Doug Harrington has some of this as well, is the notion of a little bit of tough love. And I think that's important and that neither were assholes, but sometimes, and especially Wilke, you need to get that look kind of like your dad might look over his glasses at you and be like, "Hey."

**中文翻译:**
我认为很多机制都源自杰夫·威尔克，或者说他创造了一个环境，让这些机制在整个组织中得以开发并传播。所以，那种运营心态和严谨性——即作为产品领导者，不仅要构建新事物，还要看你把已有的东西运营得有多好。如果你真的关注你运营的产品，它会给你灵感，让你知道该在哪些表现良好的地方加倍投入，或者如何防止坏事发生。我认为这是亚马逊规模化扩张的关键原因。关于杰夫·威尔克，我非常尊重的另一件事（我想 Doug Harrington 也有这一点）是那种“严厉的爱”（tough love）。我认为这很重要。他们都不是混蛋，但有时（尤其是威尔克），你需要那种眼神——就像你父亲透过眼镜上方看着你，说：“嘿。”

---

### [00:45:15] Ian McAllister

**English:**
And so I think that was kind of the vibe that you would get. It was professional, it was respectful, but sometimes everyone needs a little kick in the ass and I think that was something, but it almost builds more respect from him and just incredible leaderly behavior, which I really respect and I try to model and I try to do the same because I respected it so much. And then I guess the last attribute of Wilke, which I really saw was teaching. And it wasn't just saying this is the right thing or this is what my decision is in a meeting, but teaching the why and the pattern, the mental model that informs him to think this is the right thing. And so I think he was just great at teaching, taking a moment. It might just take 10 seconds in a meeting to teach.

**中文翻译:**
那就是你会感受到的氛围。它是专业的、尊重的，但有时每个人都需要被“踢一下屁股”。这反而让我对他更加尊重，这是一种令人惊叹的领导者行为，我非常敬佩并尝试模仿。威尔克的最后一个特质是“教学”。他不仅仅是在会上说“这是正确的事”或“这是我的决定”，而是教你背后的“为什么”、模式以及引导他做出决定的思维模型。我认为他非常擅长教学，哪怕只是在会议中花 10 秒钟时间。

---

### [00:46:01] Ian McAllister

**English:**
And that's something that I've forgotten at different parts of my career, especially as you get more experienced and you know the right decision to do and you know what you want, whatever, that may be the right thing, but I think you'll have a lot more lasting effect if you could abstract it to a degree and teach the lesson. Because then that person will hopefully learn the lesson and can apply it to a bunch of future situations and also understand the why more. And it helps them sometimes disagree and commit more so than just being given prescriptive advice.

**中文翻译:**
这是我在职业生涯不同阶段有时会忘记的事情。尤其是当你经验越来越丰富，知道什么是正确的决定，知道自己想要什么时，直接下令可能是对的，但如果你能将其抽象化并传授经验，效果会持久得多。因为这样对方就能学到东西，并将其应用到未来的各种情况中，也能更好地理解原因。这有助于他们做到“保留意见并执行”（disagree and commit），而不是仅仅接受指令。

---

### [00:46:33] Lenny

**English:**
Sounds like it must have been an incredible experience learning from these two. Thanks for sharing all that. I want to get to the working backwards stuff. I feel like we've talked about this a lot. We've talked about this on other podcasts with other guests. I feel like people understand the general idea. Yeah, Amazon works backwards. They write a PR. Maybe there's a six pager thing they do. But I feel like there's not a lot of, here's how actually do this thing. And so just to spend a little time on this, when you see teams trying to work backwards and be like, "Let's work backwards. We're going to be like Amazon.", what do you find they do wrong when they're actually trying to implement this idea of working backwards? What's the most common mistake do you find?

**中文翻译:**
听起来向这两位学习一定是一段不可思议的经历。感谢分享。我想聊聊“逆向工作法”。我觉得我们已经聊过很多次了，在其他播客里也听其他嘉宾提过。大家似乎都明白大意：是的，亚马逊采用逆向工作法，他们写新闻稿（PR），可能还会写六页纸文档（six-pager）。但我觉得关于“具体怎么做”的内容并不多。所以，当看到有些团队尝试模仿亚马逊说“我们要逆向工作”时，你发现他们在实际执行中哪些地方做得不对？最常见的错误是什么？

---

### [00:47:11] Ian McAllister

**English:**
Well, working backwards is all about the problem and starting there and obsessing about the problem and being guided by it to then go into the solution. So when teams that do it wrong is they don't do that. They don't work backwards. They have something they want to build. These things look similar. These two technologies or whatever. We could combine them and then do this. And if you say we could and it's not grounded in a customer or customer's problem, you're not working backwards. And then you may use "the working backwards process", but you already have the solution. And so you're adding the problem after the solution. You're retrofitting the problem, retrofitting the customer. And so that I think is the number one thing is that they don't get the importance of truly starting with the problem that you're trying to solve and being faithful to that working backwards from the problem.

**中文翻译:**
嗯，“逆向工作法”的核心在于问题——从问题开始，痴迷于问题，并由问题引导你走向解决方案。做得不对的团队恰恰没做到这一点。他们没有逆向思考。他们脑子里已经有了想做的东西：这些东西看起来很像，这两项技术可以结合起来做这个。如果你说“我们可以做这个”，但它不是基于客户或客户的问题，那你就是在顺向思考。你可能使用了所谓的“逆向工作流程”，但你已经有了答案。你是在有了解决方案之后再去补一个问题，是在削足适履地适配问题和客户。我认为最核心的问题是，他们没有意识到真正从你要解决的问题出发并忠于该问题的重要性。

---

### [00:48:03] Ian McAllister

**English:**
When I first started at Amazon and community, we had this business of automated merchandising using community content, and that was the core thing we were doing is to grow that. But there was this Jeff idea that a team was super excited about. Because I think in some meeting he'd kind of sketched it out or whatever. And so that there was already all this momentum to build this thing that was actually a Jeff project, but I should have known at the time, in hindsight I do, because the name they had for this project was ASIN to ASIN linking. And ASIN was the identifier for a product on Amazon. And so it was kind of this not working backwards idea ultimately of if you could link to products by a subjected attributes and then you could build a feature around it that allowed customers to vote on these things and then it would be kind of ...

**中文翻译:**
当我刚加入亚马逊社区部门时，我们的核心业务是利用社区内容进行自动化营销。当时有一个杰夫提出的想法，团队非常兴奋，因为他在某次会议上勾勒出了蓝图。于是大家劲头十足地去构建这个“杰夫项目”。但我当时本该意识到（现在回想起来很清楚），这个项目的名字叫“ASIN 到 ASIN 链接”。ASIN 是亚马逊商品的唯一标识符。这本质上就不是一个逆向工作的想法：如果你可以通过主观属性链接产品，然后围绕它构建一个功能让客户投票，然后它就会变成……

---

### [00:48:50] Ian McAllister

**English:**
So in spirit, it really wasn't working backwards. But the team was all excited and so we eventually wrote the press release and we did it. And it turned out, it wasn't successful. We ended up shutting it down later. And so I learned a lot, this was the first year or two at Amazon, about using the working backwards process but not really working backwards. And so that's literally, if I'm reviewing a working backwards press release or fact, or even talking with someone about a new initiative, my brain is wired now to not be able to process any information until I focus on the problem and the customer. And then once we start talking about that, then I can engage and literally work backwards to say, okay, how do we solve that problem? And what's the most elegant way to solve it? Or if there's three problems, what's number one or two or three? So it's probably a gap in me that I can't process information without working backwards from the problem, but I find it to be helpful when people do that.

**中文翻译:**
所以从精神实质上讲，它并不是逆向工作。但团队很兴奋，我们最终写了新闻稿并实施了。结果证明，它并不成功，我们后来把它关掉了。在亚马逊的前一两年里，我学到了很多关于“使用了逆向工作流程但并未真正逆向思考”的教训。现在，如果我在评审一份逆向工作的新闻稿或事实文档，甚至只是和某人谈论一个新计划，我的大脑已经形成了一种定式：在关注问题和客户之前，我无法处理任何信息。一旦我们开始讨论这些，我才能介入并真正地逆向思考：好的，我们如何解决那个问题？最优雅的解决方法是什么？如果有三个问题，优先级是怎样的？这可能是我的一种思维局限，即不从问题出发就无法处理信息，但我发现当人们这样做时，确实非常有帮助。

---

### [00:49:47] Lenny

**English:**
There's two parts of it. One, there's the concept of working backwards from what you're trying to accomplish. And I still absolutely do that with my teams as well. What are we trying to accomplish for the business or accomplish for a customer and let's start there. And if they have a problem that is interfering with their ability to be profitable for their ability, if it's a business customer or it's a customer trying to accomplish a goal, starting with that problem. That's different from the working backwards mechanism, which is the press release and the FAQ, which was the mechanism that Amazon used to enforce working backwards, which I think is effective. And I've tried to teach that and write some posts about with templates and things like that because it's a great way to start of the press release has a paragraph about the problem. That's what you write.

**中文翻译:**
这包含两个部分。第一，是从你想要实现的目标出发进行逆向思考的**概念**。我依然在团队中坚持这样做：我们要为业务或客户实现什么目标？让我们从那里开始。如果他们遇到了阻碍盈利或达成目标的问题，就从那个问题开始。这与逆向工作的**机制**（即新闻稿 PR 和常见问题解答 FAQ）是不同的。PR/FAQ 是亚马逊用来强制执行逆向思考的机制，我认为非常有效。我也尝试教授这一方法，并写了一些带有模板的文章，因为这是一个很好的开始：新闻稿里必须有一段专门描述问题。这就是你要写的内容。

---

### [00:51:00] Ian McAllister

**English:**
And then you write the solution paragraph and then the customer quote. And then the fact which is is there a legitimate plan to succeed? So if you don't have that muscle to work backwards already and your team, it's a great thing to try, but that's not the only mechanism that can do it. And eventually if you do it enough and you build that muscle to work backwards, you can do it in any number of formats, whether it's something in a PRD or some other way. But the key is that you don't think what we could build, you think about the problem and then the solution that solves that problem.

**中文翻译:**
接着写解决方案段落，然后是客户引言。最后是事实部分（FAQ），即：是否有一个合理的成功计划？如果你的团队还没有建立起逆向思考的能力，这是一个很好的尝试工具，但它不是唯一的机制。最终，如果你做得足够多，建立起了这种能力，你可以用任何形式来表达，无论是产品需求文档（PRD）还是其他方式。关键在于：不要想“我们可以构建什么”，而要思考“问题是什么”，以及“解决该问题的方案是什么”。

---

### [00:51:35] Lenny

**English:**
Got it. Okay. So the press release is not core to it. It's like a trick to get you to think about the problem you're solving. It's not how you plant announce it.

**中文翻译:**
明白了。所以新闻稿并不是核心，它更像是一个让你思考所解决问题的“小技巧”，而不是你真正发布产品的方式。

---

### [00:51:42] Ian McAllister

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:51:43] Lenny

**English:**
Interesting. I never thought about it that way. So when you're doing this process at other places outside Amazon, say you're a product leader that's trying to ... I want to improve the way we think about product. What is it that you suggest they do specifically? Is it write out, here's the problem we're solving? Is there more to it? What would you suggest there?

**中文翻译:**
有趣，我从没这么想过。那么当你在亚马逊以外的地方执行这个流程时，假设你是一名产品领导者，想要改进团队思考产品的方式，你会建议他们具体怎么做？是写出“这就是我们要解决的问题”吗？还有更多细节吗？

---

### [00:52:02] Ian McAllister

**English:**
If it's a blank slate, truly, you could certainly use the working backwards process like Amazon does with the internal press release and then the fact and so forth. So that's fine. But a lot of companies have a different way they go about it. Some companies are very much, it's slide culture and presentations and so forth. And so as a product leader you could think about what you do with your team and what you do upwards or across. And so you may have the latitude to use any process with your team. And I've done that at some companies where using documents and if they're supportive of the team and they recognize the value of that, like, oh actually this is good and this is a great way to write things down on paper and to have better information content and richer discussion that oftentimes I think people will find that versus a slide with a couple bullets is not great. Then you can build that muscle.

**中文翻译:**
如果真的是从零开始，你完全可以像亚马逊那样使用内部新闻稿和 FAQ 等逆向工作流程。这没问题。但很多公司有不同的文化。有些公司非常推崇“幻灯片文化”和演示文稿。作为产品领导者，你可以考虑在团队内部怎么做，以及如何向上级或跨部门沟通。在团队内部，你可能有权使用任何流程。我在一些公司尝试过使用文档，如果团队支持并意识到其价值（比如发现把事情写在纸上能提供更好的信息内容和更深入的讨论），他们会发现这比只有几个要点的幻灯片好得多。这样你就能建立起这种能力。

---

### [00:52:54] Ian McAllister

**English:**
And I've found it's a great way to teach and use those to dive deeper into product. But depending on the organization you're at, that may not wash to train your senior leadership to use the process you want to use. And so then it might be a matter of finding the opportunities to try something and saying, "Are you open to doing something this way?" A review of a doc instead of a review of a whatever. So that's a little separate than just working backwards, but I think you just have to acknowledge the environment you're in. And also, unless the organization has a specific format to do this. If it does, you probably just need to use it. Different leaders process information, different ways. You may find one format's effective with your leader, but another one to educate a broader organization. But it's very company specific. So despite what I might want to do, I've just got to recognize that I have more leverage down with my team versus up or across.

**中文翻译:**
我发现这是教学和深入探讨产品的绝佳方式。但取决于你所在的组织，训练高层领导使用你想要的流程可能行不通。所以这可能需要寻找机会去尝试，比如问：“你们愿意尝试用这种方式吗？”用文档评审代替其他形式的评审。这与逆向工作法本身略有不同，但你必须承认所处的环境。除非组织有特定的格式要求，如果有，你可能只能遵守。不同的领导者处理信息的方式不同。你可能会发现某种格式对你的领导有效，而另一种格式更适合教育整个组织。这非常取决于公司。所以尽管我有自己的偏好，但我必须意识到，我对下属团队的影响力远大于对上级或跨部门同事的影响力。

---

### [00:53:51] Lenny

**English:**
Is there a template that you use consistently? Is that something that you've published of how to frame the problem, how to frame all these other elements?

**中文翻译:**
有没有你一直使用的模板？你有没有发布过关于如何界定问题、如何界定其他要素的模板？

---

### [00:54:00] Ian McAllister

**English:**
I have shared posts on, I know for sure LinkedIn and I probably should put it on the newsletter, on my newsletter, that's a working backwards template and some posts about how to do the process or tips on how Amazon does the process. And so I'll make sure to put those up on my newsletter as well. And the template's free. Obviously anyone could just copy it and grab it.

**中文翻译:**
我在 LinkedIn 上分享过，我也应该把它发在我的时事通讯（Newsletter）上。那是一个逆向工作法模板，还有一些关于如何执行该流程或亚马逊如何操作的技巧。我会确保把这些发到我的 Newsletter 上。模板是免费的，任何人都可以复制使用。

---

### [00:54:19] Lenny

**English:**
Awesome. We'll link to that in show notes. Definitely send that to me after we wrap this thing. And I was going to ask, does Amazon work backwards on every product they work on/do you suggest working backwards in every feature and product?

**中文翻译:**
太棒了。我们会把链接放在节目介绍里。录完后一定要发给我。我还想问，亚马逊是对每一个产品都采用逆向工作法吗？你建议对每一个功能和产品都这样做吗？

---

### [00:54:33] Ian McAllister

**English:**
I think there's some scale below which it doesn't probably make sense to do this process because there's a little bit of overhead to it. But I think if it's a new product, absolutely. And I'm sure there's some at Amazon that don't use the process, but in general that was the way and often enforced that you need a working backwards review. Ideally that would happen at the outset, but sometimes it would be added later. And yeah, I think it's a great thing whether you use the mechanism. Again, it's a great template to start with and use if you have the flexibility to, but I think it's also possible just to have the spirit and to try to be true to the spirit of working backwards from what you're trying to do for customers and what problem. That's the most important thing. The template is just a mechanism to help ensure that happens.

**中文翻译:**
我认为如果规模太小，做这个流程可能没意义，因为它有一定的管理开销。但如果是新产品，绝对应该做。我敢肯定亚马逊内部也有人不使用这个流程，但总的来说，这是主流方式，而且通常会强制要求进行“逆向工作评审”。理想情况下，这应该在项目开始时进行，但有时也会在后期补上。我认为无论你是否使用这个机制，它都是一件好事。如果你有灵活性，它是一个很好的起始模板；但即使不用模板，保持那种“从客户需求和问题出发”的精神也是可能的。精神实质才是最重要的，模板只是确保精神落地的机制。

---

### [00:55:18] Lenny

**English:**
Got it. You mentioned a review. What is that? Working backwards review?

**中文翻译:**
明白了。你提到了“评审”。那是什么？逆向工作评审吗？

---

### [00:55:22] Ian McAllister

**English:**
Well that would just be a meeting with leadership or other folks to review the concept, review the press release, review the FAQ and ask questions. In some cases that would be the gate to approving it. That was the case with me and Bezos before we went off and built the team and launched Amazon Smile is I would do these reviews about different concepts and that was the one that we green lit. I mean that's often the case. It's also just a great way to educate other people about what you're trying to accomplish. Ground them in the customer problem and solution. And the FAQ is a whole nother concept. It's about the legitimate plan to succeed. One other thing that I use, I got a chance to have lunch with Jeff Bezos. It was probably back in 2008 or something like this. And I asked him, "What's your criteria for investing in something new?"

**中文翻译:**
那其实就是与领导层或其他相关人员开会，评审概念、新闻稿和 FAQ 并提问。在某些情况下，这是获得批准的“关卡”。我和贝佐斯在组建团队并发布 Amazon Smile 之前就是这样：我会针对不同的概念进行评审，而那是我们最终批准的一个。这通常也是教育他人了解你目标的好机会，让他们扎根于客户问题和解决方案。FAQ 是另一个概念，它关乎“合理的成功计划”。我还有一招：大概在 2008 年，我有机会和贝佐斯共进午餐。我问他：“你投资新事物的标准是什么？”

---

### [00:56:09] Ian McAllister

**English:**
And he said, "Well it's three things. One, is it a big idea? And then second, is it something we should be doing?" So if maybe you have an idea, if you have this new way to extract oil from shale, is it a big idea? Yeah, probably could be a big idea. Is it something Amazon should be doing? Probably not. And the third test, is there a legitimate plan to succeed? And you got to have all three of those things. And I think the FAQ part of the working backwards process is that early stage legitimate test of whether this thing has a plan. Because you could have this internal press release or big idea or big idea for a solution, but the FAQ basically says, okay, I've thought through the internal components or the finances or the key technical hurdles or whatever. And so that's one that's not written about as much, how to do the FAQ, but I think it's another way to build trust that you've been thoughtful enough given the stage of the product to deserve the resources or deserve to move forward with it.

**中文翻译:**
他说：“有三点：第一，它是一个伟大的创意吗？第二，它是我们应该做的事情吗？”比如你有一个从页岩中提取石油的新方法，这创意大吗？很大。但这是亚马逊该做的事吗？可能不是。第三个测试：是否有一个合理的成功计划？你必须同时具备这三点。我认为逆向工作流程中的 FAQ 部分，就是对“是否有计划”的早期合理性测试。因为你可能有一个内部新闻稿或一个伟大的解决方案构想，但 FAQ 基本上是在说：好的，我已经考虑过了内部组件、财务状况或关键技术障碍等等。关于如何写 FAQ 的文章不多，但我认为这是另一种建立信任的方式，证明在产品的当前阶段你已经考虑得足够周全，值得获得资源或继续推进。

---

### [00:57:03] Lenny

**English:**
That's awesome. I feel like most PMs listening to this are going to be like, "I always start with a problem. I'm always problem focused so I'm working backwards. So I'm good." Other signs of just like, no, you're not. You think you are but you're probably not doing this well. Is there a symptom of you're not actually doing this correctly?

**中文翻译:**
太棒了。我觉得大多数听众 PM 可能会想：“我总是从问题开始，我总是关注问题，所以我就是在逆向工作，我没问题。”有没有什么迹象能说明“不，你并没有，你只是自以为在做，但其实做得不好”？有没有什么症状能表明其实没做对？

---

### [00:57:23] Ian McAllister

**English:**
The most common thing that I see that tips me off is when they talk about something, there's different pieces in the pantry and we have these ingredients, we could put them together, we could add these two things together and make a meal out of it. And so it might be a technology, it might be a service, it might be two different things or the building blocks are there and what's enabled if you add these two building blocks together is something. But that's not really working backwards. It may be true that there's some leverage or some benefit from the company having these technologies or assets, but that to me is often the first step that these two things look similar. We combine them and it's all goodness in this new thing.

**中文翻译:**
我看到的最常见的、能让我立刻警觉的迹象是：当他们谈论某件事时，就像在说“储藏室里有不同的食材，我们有这些原料，我们可以把它们组合在一起，做成一顿饭”。这可能是一项技术，也可能是一项服务，或者两个不同的东西，或者现成的构建块。如果把这两个构建块加在一起，就能实现某个功能。但这并不是真正的逆向工作。虽然公司拥有这些技术或资产确实可能带来某种杠杆作用或收益，但在我看来，如果第一步是“这两个东西看起来很像，我们把它们结合起来，新东西肯定很棒”，那通常就不是逆向工作。

---

### [00:58:09] Ian McAllister

**English:**
So if you start talking about those things or the technology, I think that's a likely case that you're not really working backwards as opposed to the opposite is if there's a customer problem that feels compelling even before the solution, yeah, that does feel compelling. And just like with every startup out there, probably a lot of the pitches are there's a big audience and a painful problem and it's the painkiller versus the vitamin thing. And then we have a novel way to solve that. That's kind of working backwards. But more often, especially in a big company, you'll have all these ideas because you have more ingredients in the pantry of ways you could combine them and try to feed it to someone but may not be working backwards.

**中文翻译:**
所以，如果你开始谈论这些现有的东西或技术，很可能你并没有在逆向工作。相反，如果有一个客户问题，甚至在方案出来之前就让人觉得非解决不可，那才是对的。就像所有的初创公司一样，很多商业计划书都会说：这里有庞大的受众和一个痛苦的问题（即“止痛药”而非“维生素”问题），然后我们有一个新颖的解决方法。这才是逆向工作。但在大公司里，你往往会有很多想法，因为你的“储藏室”里有更多食材，你可以把它们组合起来强行喂给别人，但这可能并不是逆向工作。

---

### [00:58:56] Lenny

**English:**
Awesome. We're reaching about an hour chatting and so I want to let you go. Before we get to our very exciting lightning round, is there anything else you want to share on anything we've chatted about?

**中文翻译:**
太棒了。我们已经聊了快一个小时了，准备结束。在我们进入非常精彩的“闪电问答”环节之前，关于我们聊过的任何内容，你还有什么想分享的吗？

---

### [00:59:06] Ian McAllister

**English:**
Let's see. No. I mean I think we covered a bunch of good ground. It's been fun, but nothing particular.

**中文翻译:**
让我想想。没有了。我觉得我们已经涵盖了很多不错的话题。聊得很开心，没什么特别要补充的了。

---

### [00:59:11] Lenny

**English:**
Okay, great. Well then we've reached our very exciting lightning round. We've got six questions here. They'll be pretty quick and easy. Whatever comes to mind, share and we'll go through them relatively quickly. Sound good?

**中文翻译:**
好的，太棒了。那我们进入精彩的闪电问答环节。这里有六个问题，非常简单快速。想到什么就说什么，我们会过得比较快。准备好了吗？

---

### [00:59:22] Ian McAllister

**English:**
All right. Let's do it.

**中文翻译:**
好的，开始吧。

---

### [00:59:23] Lenny

**English:**
Let's do it. What are two or three books that you've most recommended to other people?

**中文翻译:**
开始。你向别人推荐最多的两三本书是什么？

---

### [00:59:28] Ian McAllister

**English:**
I say Getting Real by 37 Signals and it's specifically the chapter on epicenter design. I've shared that many, many times. You can link to it. That's definitely the most thing I've shared. For fun, The Wool Trilogy by Hugh Howey, he's probably my favorite author and a great series. And then for learning, just a recent one that I thought would be super fascinating was Energy and Civilization by Vaclav Smil. So it might not be on the best seller list, but I thought it was interesting.

**中文翻译:**
我会推荐 37 Signals 写的《Getting Real》，特别是关于“震中设计”（epicenter design）的那一章。我分享过无数次，你可以放个链接。这绝对是我分享最多的。消遣的话，推荐 Hugh Howey 的《羊毛战记》（The Wool Trilogy），他可能是我最喜欢的作家，这系列非常棒。学习的话，最近看了一本我觉得超级迷人的书，是 Vaclav Smil 的《能源与文明》（Energy and Civilization）。它可能不在畅销书单上，但我认为很有趣。

---

### [00:59:55] Lenny

**English:**
What's another favorite podcast of yours other than this one possibly?

**中文翻译:**
除了本节目，你最喜欢的播客还有哪个？

---

### [00:59:59] Ian McAllister

**English:**
I think How I Built This is really interesting just to decompose how interesting businesses and products came about. And then just because of my work, EV News Daily is a daily digest of what's going on in the electric vehicle space. So that's a very good use of my time, five minutes a day to get up to speed.

**中文翻译:**
我觉得《How I Built This》非常有趣，它剖析了那些有趣的业务和产品是如何诞生的。另外因为工作关系，我会听《EV News Daily》，它是电动汽车领域的每日摘要。每天花五分钟了解最新动态，非常值得。

---

### [01:00:18] Lenny

**English:**
Very niche. I love it. What's a favorite movie or a TV show you've recently seen?

**中文翻译:**
非常垂直，我喜欢。你最近看过的最喜欢的电影或电视剧是什么？

---

### [01:00:24] Ian McAllister

**English:**
Yellowstone. That's definitely my favorite. Can't wait for the next season. Montana's my happy place, although I'm probably the kind of person that they rail about in the show, so it's kind of ironic. And I think the movie was Everything Everywhere All At Once. I love movies that are not predictable and I thought that was just very creative.

**中文翻译:**
《黄石》（Yellowstone）。绝对是我的最爱，等不及看下一季了。蒙大拿州是我的福地，虽然我可能正是剧里那些被痛骂的那类人，这挺讽刺的。电影的话，我觉得是《瞬息全宇宙》（Everything Everywhere All At Once）。我喜欢不可预测的电影，我觉得它非常有创意。

---

### [01:00:40] Lenny

**English:**
I'm shocked by how many people on Yellowstone die. That show is just murder left and right. I was not expecting that on a ranch oriented show.

**中文翻译:**
我对《黄石》里死了那么多人感到震惊。那部剧到处都是谋杀。我真没想到一部关于牧场的剧会是这样。

---

### [01:00:50] Ian McAllister

**English:**
It's a harsh environment.

**中文翻译:**
那是个残酷的环境。

---

### [01:00:51] Lenny

**English:**
Quite harsh, turns out. Especially if you mess with the Duttons. Next question. Favorite interview question that you like to ask.

**中文翻译:**
事实证明确实很残酷，尤其是当你招惹了达顿家族。下一个问题：你最喜欢问的面试问题是什么？

---

### [01:00:58] Ian McAllister

**English:**
When I'm coming out of left field, I ask people at this stage in your career, what have you learned about yourself? How are you different from other people? No one's prepared for that.

**中文翻译:**
当我想要出其不意时，我会问：“在你职业生涯的这个阶段，你对自己有了哪些了解？你与其他人有什么不同？”没人能预料到这个问题。

---

### [01:01:06] Lenny

**English:**
What do you look for in their answers?

**中文翻译:**
你希望从他们的回答中听到什么？

---

### [01:01:08] Ian McAllister

**English:**
I don't know. There's not one specific thing and there's no right answer, which maybe makes it unfair, but just maybe a little self-reflection and maybe they will have understanding their strengths and that might be a good bit of self-awareness about what makes them different, where they can harness that and that makes them a better PM or engineer or something. And so that's kind of what I'm looking for, but there's no set answer. It's more just to throw them off balance.

**中文翻译:**
我也不知道。没有特定的标准，也没有标准答案，这可能有点不公平。但我希望能看到一点自我反思，也许他们了解自己的优势，对自己的独特性有清醒的认识，知道如何利用这些特质让自己成为更好的 PM 或工程师。这就是我想要的，但没有固定答案，更多是为了打破他们的心理防线。

---

### [01:01:32] Lenny

**English:**
Interesting. Favorite app right now.

**中文翻译:**
有趣。现在最喜欢的 App 是什么？

---

### [01:01:35] Ian McAllister

**English:**
It's probably not too interesting, but to be honest, YouTube. It's like the eighth wander of the world and just every day I'm amazed if I want to learn about something new. A couple summers ago I had some time off and so I basically taught myself how to do woodworking and built a kitchen and other stuff. And so it's just like it continues to be this resource and this jewel that helps me grow and learn about anything.

**中文翻译:**
可能没什么新意，但老实说，是 YouTube。它就像世界第八大奇迹，每天我都为它能教我新东西而感到惊讶。几年前的夏天我有段空闲时间，我基本上是靠自学木工，亲手做了一套厨房家具和其他东西。它一直是一个宝库，帮助我成长并学习任何东西。

---

### [01:01:58] Lenny

**English:**
I imagine some people are watching this on YouTube right now.

**中文翻译:**
我想现在肯定有人正在 YouTube 上看这段视频。

---

### [01:02:01] Ian McAllister

**English:**
All right.

**中文翻译:**
没错。

---

### [01:02:02] Lenny

**English:**
I just read a story about an Olympic javelin thrower who learned how to do this watching YouTube. He was somewhere in, I think maybe Africa. He had no coaches around and he just watched this one other javelin guy that just shared lessons on how to do this and became incredibly good. It's insane.

**中文翻译:**
我刚读到一个故事，说一个奥运会标枪运动员是看 YouTube 学会的。他当时在非洲某地，身边没有教练，他就盯着另一个分享标枪教程的人看，最后变得极其出色。太疯狂了。

---

### [01:02:18] Ian McAllister

**English:**
And I mean, I'm old, so I didn't have this when I was growing up. I remember going to the library and sending away for a brochure in the back of a magazine and things. Learning was not so easy back then. The internet obviously was a huge resource and is, but then YouTube as well to see somebody do it. It's also interesting to see somebody live. So anyway, I'm a fan.

**中文翻译:**
我是说，我年纪大了，我成长的时候可没这些。我记得以前要去图书馆，或者寄信去索取杂志背面的小册子之类的。那时候学习可没这么容易。互联网显然是一个巨大的资源，而 YouTube 让你能亲眼看到别人是怎么做的，这非常有趣。总之，我是它的粉丝。

---

### [01:02:40] Lenny

**English:**
Final question. Who else in the industry do you most respect as a thought leader, someone you look up to?

**中文翻译:**
最后一个问题：在行业内，你最尊敬的、仰慕的思想领袖是谁？

---

### [01:02:46] Ian McAllister

**English:**
I say Gibson Biddle. I think that he is one, just tremendous amount of product experience that I think is valuable. I respect the fact that he takes the time to share it. He doesn't have to, but he does. And he's also a great communicator and he invests in being ... You can tell he measures [inaudible 01:03:02] of his talks and things like this. He's invested over his career to be a great communicator. So I think he's a good role model for me and I think for others out there.

**中文翻译:**
我会说是 Gibson Biddle。首先，他拥有极其丰富且宝贵的产品经验。我非常尊重他愿意花时间分享这一点，他本不必这样做。他也是一个伟大的沟通者，你可以看出他在演讲等方面投入了很多精力。他在整个职业生涯中都致力于成为一名优秀的沟通者。我认为他是我、也是其他人的好榜样。

---

### [01:03:11] Lenny

**English:**
That guy's a force. I'm happy that we've had him on this podcast. I'm hoping that everyone eventually, that people mention in this question we end up having on this podcast. So that's great to check. I also love Gibson. He's got a great newsletter. Askgibbs.substack.com I think. Ian, thank you so much for being here. This was amazing. I really appreciate you sharing all this wisdom with us. Two final questions. Where can folks find you online if they want to reach out, learn more, and how can listeners be useful to you?

**中文翻译:**
那个人很有影响力。很高兴我们请他上过这个播客。我希望最终每一个在这个问题中被提到的人都能来上节目。我也很喜欢 Gibson，他的 Newsletter 很棒，好像是 Askgibbs.substack.com。Ian，非常感谢你能来。这次对话太精彩了，非常感谢你与我们分享这些智慧。最后两个问题：如果大家想联系你或了解更多，可以在哪里找到你？听众们能为你做些什么？

---

### [01:03:38] Ian McAllister

**English:**
Yeah, I guess Twitter's a great place. So IanMcAll, I-A-N-M-C-A-L-L, is my handle. And then I've started a newsletter. I'm not that frequent to be honest. I have a lot of good intentions and a bunch of ideas. Ianmcallister.substack.com. And that's something to connect and feel free to subscribe and hit me up on Twitter if you have ideas for posts or questions. And if I can answer in a tweet, I will. If not, I might put it on the queue of things to write about. And yeah, thanks for having me on Lenny. We were talking earlier about writing or doing other things and the value of that is just making connections with people. And so that was what I was one, just to reconnect with you is awesome. And to whatever extent I get a chance to make new connections in the world, that's a good thing.

**中文翻译:**
我想 Twitter 是个好地方，我的账号是 @IanMcAll。另外我开了一个 Newsletter，老实说更新频率不高，但我有很多想法和计划，网址是 ianmcallister.substack.com。欢迎订阅，如果你有文章建议或问题，可以在 Twitter 上找我。如果能用推文回答，我就直接回；如果不行，我会把它列入写作计划。Lenny，谢谢你邀请我。我们之前聊到写作或其他事情的价值，其实就是与人建立联系。能和你重新联系上太棒了。无论在什么程度上，只要有机会在世界上建立新的联系，都是一件好事。

---

### [01:04:25] Lenny

**English:**
Amazing. And we originally connected over that piece that you wrote, so it all circles back 10 years later maybe. Thanks, Ian.

**中文翻译:**
太棒了。我们最初也是因为你写的那篇文章才建立联系的，所以 10 年后这一切又回到了原点。谢谢你，Ian。

---

### [01:04:32] Ian McAllister

**English:**
All right. Thanks Lenny.

**中文翻译:**
好的，谢谢 Lenny。

---

### [01:04:34] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期内容有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期再见。