# Ivan Zhao - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Ivan Zhao, the co-founder and CEO of Notion.

---

### (00:00:00) Lenny Rachitsky

**English:**
The way you described the early years of Notion, you described the first three to four years as the lost years.

**中文翻译:**
你描述 Notion 早期阶段的方式很有意思，你把最初的三到四年称为“迷失的岁月”。

---

### (00:00:05) Ivan Zhao

**English:**
We try many different versions. The first version, okay, everybody can make and create their software, so let's just build a developer tool that's so easy that more people can do that. We tried that a couple of years and learned that actually most people just don't care. Our realization is actually let's hide our vision, which is everybody can create their software in the form factor that people do care. So what kind of tool do people use every day? Productivity software. It took us two years to realize we need to build a productivity tool. We called it sugar-coated broccoli. People don't want to eat the broccoli but people like sugar, so it gave them the sugar then hide your broccoli inside of it.

**中文翻译:**
我们尝试过很多不同的版本。第一个版本是基于“每个人都能制作和创建自己的软件”这个想法，所以我们想做一个非常简单的开发者工具，让更多人能上手。我们尝试了几年，发现其实大多数人根本不在乎。我们的感悟是：要把我们的愿景——即“人人都能创造软件”——隐藏在人们真正关心的产品形态中。那么人们每天用什么工具呢？生产力软件。我们花了两年时间才意识到我们需要做一个生产力工具。我们称之为“糖衣西兰花”。人们不想吃西兰花（底层工具建设），但人们喜欢糖（生产力功能），所以先给他们糖，然后把西兰花藏在里面。

---

### (00:00:40) Lenny Rachitsky

**English:**
What other elements do you think are key to you finding something that actually ended up working?

**中文翻译:**
你认为还有哪些关键因素促使你最终找到了行之有效的方向？

---

### (00:00:44) Ivan Zhao

**English:**
What is the building a product or business. You want user. You want revenue. That's the product business. And building for something you want the world to have is building for your value. You have some taste. You have some aesthetic. There are different energy. You need to create a balance. Too much of yourself. Then there's no users. Then you're just doing our project. And too much for business, you're building a commodity.

**中文翻译:**
什么是打造产品或业务？你想要用户，想要收入，这就是产品业务。而为你希望世界拥有的东西而创作，则是为了你的价值观而创作。你有自己的品味，有自己的审美。这两者是不同的能量，你需要创造一种平衡。如果自我意识太强，就不会有用户，那你只是在做一个个人项目；如果太追求业务，你就是在做一个平庸的商品。

---

### (00:01:03) Lenny Rachitsky

**English:**
The way you think about Notion, it's almost like a philosophy of how to work and be versus just a productivity tool. And so I'm just curious how you think about the relationship between tools and human potential.

**中文翻译:**
你思考 Notion 的方式，几乎像是一种关于如何工作和生存的哲学，而不仅仅是一个生产力工具。所以我很好奇你是如何看待工具与人类潜能之间的关系的。

---

### (00:01:15) Ivan Zhao

**English:**
Tools are extensions of us. And once they extend us, once we shape them, once we bring them to world, they can come back to shape us.

**中文翻译:**
工具是我们的延伸。一旦它们延伸了我们，一旦我们塑造了它们并将其带入世界，它们反过来也会塑造我们。

---

### (00:01:28) Lenny Rachitsky

**English:**
Today, my guest is Ivan Zhao. Ivan is the co-founder and CEO of Notion. Ivan is a really unique and also a deeply philosophical founder who doesn't do a lot of podcasts, so I'm really excited to share a glimpse into how he built one of the most beloved and most popular products in the world.

**中文翻译:**
今天的嘉宾是 Ivan Zhao。Ivan 是 Notion 的联合创始人兼 CEO。Ivan 是一位非常独特且具有深度哲学思考的创始人，他很少参加播客，所以我非常激动能带大家一窥他是如何打造出这款全球最受喜爱、最受欢迎的产品之一的。

---

### (00:01:45) Lenny Rachitsky

**English:**
We talk about the first three to four years of Notion that he describes as the lost years, how he was able to get into a great school in China by winning a programming contest, the joy and suffering of building a successful horizontal product, plus his approach to staying lean and craft and making trade-offs and also leadership. Also, a wild story about how Notion almost died during COVID because the one database that everything lived in almost ran out of space.

**中文翻译:**
我们聊到了他口中 Notion 最初那三四年的“迷失岁月”；聊到了他当年如何通过赢得编程竞赛进入中国的一流学校；聊到了打造成功的横向产品（horizontal product）过程中的快乐与痛苦；还有他保持精简团队、追求工艺、进行权衡的方法论以及他的领导力。此外，还有一个惊险的故事：Notion 在疫情期间差点倒闭，因为承载所有数据的唯一数据库空间几乎耗尽。

---

### (00:02:10) Lenny Rachitsky

**English:**
If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become a paid annual subscriber of my newsletter, you now get a year free of Notion Pro and Perplexity Pro and Superhuman and Linear and Granola. Check it out at lennysnewsletter.com. With that, I bring you Ivan Zhao.

**中文翻译:**
如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。另外，如果你成为我 Newsletter 的年度付费订阅者，你现在可以免费获得一年的 Notion Pro、Perplexity Pro、Superhuman、Linear 和 Granola。详情请访问 lennysnewsletter.com。下面，让我们欢迎 Ivan Zhao。

---

### (00:02:32) Lenny Rachitsky (Ad Segment)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A-B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams... (Ad content continues)

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的前员工为现代增长团队打造的下一代 A/B 测试和功能管理平台……（广告内容略）

---

### (00:03:50) Lenny Rachitsky (Ad Segment)

**English:**
This episode is brought to you by Airtable ProductCentral, the unified system that brings your entire product org together in one place... (Ad content continues)

**中文翻译:**
本期节目由 Airtable ProductCentral 赞助，这是一个将整个产品组织整合在一起的统一系统……（广告内容略）

---

### (00:04:44) Lenny Rachitsky

**English:**
Ivan, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
Ivan，非常感谢你能来，欢迎来到我的播客。

---

### (00:04:47) Ivan Zhao

**English:**
Thank you for having me.

**中文翻译:**
谢谢你的邀请。

---

### (00:04:48) Lenny Rachitsky

**English:**
I know you don't do a lot of podcasts, and so I'm very honored that you're here. I want to start with the story of Ivan. Your background is quite unique for a founder of a $10 billion plus tech company, and I don't think a lot of people know it. For example, you grew up in a small town in China. And the way you got out of there, the way you got into tech is pretty interesting. Can you just walk us through that early years of Ivan and how you got out there?

**中文翻译:**
我知道你很少上播客，所以我很荣幸你能来。我想从 Ivan 的故事开始。作为一家估值超过 100 亿美元的科技公司的创始人，你的背景非常独特，我想很多人并不了解。例如，你在中国的一个“小城市”长大。你离开那里并进入科技行业的过程非常有趣。你能带我们回顾一下 Ivan 的早年生活以及你是如何走出来的吗？

---

### (00:05:16) Ivan Zhao

**English:**
Yeah. I think a small town in China, the definition, it's actually 4 million people. It is called Urumqi. It's in the northwest desert part of China. So I grew up there and then I moved into... My mom took me to Beijing, the capital of China. And that's actually how I got into programming, coding, because I'm from somewhere else and in order to go into good school in the capital, you need to win some kind of competition. And there's different paths. You can get at math or you can get at programming like Information Olympiad. I was really into computer games at the time so of course I picked the programming one so I can play computers all day long. And I win some competition and got me to a good school. So that's how I got into programming.

**中文翻译:**
是的。我想在中国，所谓的“小城市”其实也有 400 万人口。那个城市叫乌鲁木齐，位于中国西北的沙漠地带。我在那里长大，后来我妈妈带我去了北京。那其实就是我接触编程和写代码的契机，因为我是外地人，为了进入首都的好学校，你必须赢得某种竞赛。有很多不同的路径，你可以擅长数学，或者擅长像信息学奥林匹克（NOI）这样的编程竞赛。我当时非常迷恋电脑游戏，所以理所当然选了编程，这样我就可以整天玩电脑了。后来我赢得了一些比赛，这让我进入了一所好学校。这就是我进入编程领域的经过。

---

### (00:06:05) Ivan Zhao

**English:**
Later then, I moved to Canada. When I moved to Canada, got into college, did not study computer science since I already knew how to code, but a lot of video games. Did a lot of art actually, art and science. By the time I graduated college, I realized most of my friends are artists. They need to make their websites, get web portfolio made. And I'm the only nerd in my art friend circle so I made three or four websites and realized, "Oh, actually people don't know how to create with the software media, computing media." So that got me into want to create a product like Notion today which it allow more people to create tools, create software for their daily work and life.

**中文翻译:**
后来我移居到了加拿大。去加拿大上大学时，我没有学计算机科学，因为我已经会写代码了，而且当时玩了很多电子游戏。我其实学了很多艺术，艺术和科学。到大学毕业时，我发现我大多数朋友都是艺术家。他们需要制作自己的网站，展示作品集。我是艺术圈子里唯一的“技术宅”，所以我帮他们做了三四个网站，然后意识到：“噢，其实人们不知道如何利用软件媒介、计算媒介来进行创作。”这促使我想创造一个像今天的 Notion 这样的产品，让更多人能够为自己的日常工作和生活创造工具和软件。

---

### (00:06:49) Lenny Rachitsky

**English:**
Okay. So going back to get into a great school and to leave the small town, not so small, you had to enter a programming contest. And you placed first or second or how well did you actually do in this one?

**中文翻译:**
好，回到为了离开那个“不那么小”的小城市并进入名校的话题，你必须参加编程竞赛。你当时是拿了第一还是第二？表现到底有多好？

---

### (00:07:05) Ivan Zhao

**English:**
Second in Beijing.

**中文翻译:**
北京市第二名。

---

### (00:07:07) Lenny Rachitsky

**English:**
In Beijing, okay.

**中文翻译:**
在北京拿了第二，明白了。

---

### (00:07:08) Ivan Zhao

**English:**
Pretty big. Beijing is a big city.

**中文翻译:**
挺厉害的，北京可是个大城市。

---

### (00:07:11) Lenny Rachitsky

**English:**
Okay. Incredible. Another stat or a story I heard is that you learned English by watching SpongeBob SquarePants. Is that real?

**中文翻译:**
太不可思议了。我还听过另一个故事，说你是通过看《海绵宝宝》学英语的。这是真的吗？

---

### (00:07:18) Ivan Zhao

**English:**
Yeah, it's real. I moved to Canada pretty late, 16 years old, and what I learned is in China you can learn English but it's typically just grammar and doing exams. What you're missing is the context, the culture. So you have to watch SpongeBob or Simpsons to get a sense of humor essentially. You can understand jokes. Watching cartoons, it's probably the easiest way to do that.

**中文翻译:**
是的，是真的。我移居加拿大的时间比较晚，16 岁。我发现，在中国你可以学英语，但通常只是语法和应试。你缺失的是语境和文化。所以你必须看《海绵宝宝》或《辛普森一家》来培养幽默感。这样你才能听懂笑话。看动画片可能是最简单的方法。

---

### (00:07:45) Lenny Rachitsky

**English:**
That's amazing. And there's another seminal moment in your path. I don't know if it was this point or later, but the Douglas Engelbart paper ended up being a very meaningful moment for you.

**中文翻译:**
太棒了。在你的成长路径中还有另一个关键时刻。我不确定是当时还是后来，但道格拉斯·恩格尔巴特（Douglas Engelbart）的那篇论文对你来说意义非凡。

---

### (00:07:57) Ivan Zhao

**English:**
So while I was in Canada in last year of school working on trying to building website from our friends and building a creative tool for them, and then you just look into the history of a creative tool for software, for computing. Eventually arrived at 1960 and '70s. So you realize the first generation of computing pioneers, which is around San Francisco, Stanford areas, South Bay, they actually had the best ideas. For them, people like Douglas Engelbart, Alan Kay, Ted Nelson, those first generation pioneers, for them computing, there shouldn't be a separation between builders and users. It's the same medium. Engelbart's original paper called Augmenting Human Intellect, when I read that paper, it's like holy shit. If you are making software, if you know how to code or design, this is the highest leverage thing you can do for other people. So giving them the ability to use computing to augment their problem-solving ability or their intellect, that just got me obsessed with this problem and I want to start a company like Notion.

**中文翻译:**
当时我在加拿大读大四，正忙着帮朋友建网站，为他们开发创作工具。于是我开始研究软件和计算创作工具的历史。最终追溯到了 20 世纪 60 和 70 年代。你会发现，第一代计算先驱——主要分布在旧金山、斯坦福、南湾一带——他们其实拥有最棒的想法。对于像道格拉斯·恩格尔巴特、艾伦·凯（Alan Kay）、泰德·尼尔森（Ted Nelson）这些第一代先驱来说，计算不应该在“构建者”和“使用者”之间存在界限。它是同一种媒介。恩格尔巴特那篇著名的论文叫《增强人类智力》（Augmenting Human Intellect），当我读到那篇论文时，我心想：“天哪”。如果你在开发软件，如果你懂代码或设计，这是你能为他人做的杠杆率最高的事情。赋予他们利用计算来增强解决问题的能力或智力的能力，这让我彻底迷上了这个问题，也让我想要创办一家像 Notion 这样的公司。

---

### (00:09:05) Lenny Rachitsky

**English:**
It makes me think of Steve Jobs's famous line of how the computer is a bicycle for the mind.

**中文翻译:**
这让我想起了史蒂夫·乔布斯那句名言：计算机是人类灵魂的自行车。

---

### (00:09:10) Ivan Zhao

**English:**
You know what? Steve Jobs is actually at fault of this in some strange ways. So the story is... Actually, the fact. It's not a story. Xerox PARC has working on the first-generation personal computers called Xerox Alto. Alan Kay was one of the main persons behind it. Alto runs down the system called Smalltalk, which is there's no separation between users and users' app. There's no thing called application. Everything is malleable. You can change the tools. So when Steve Jobs, the famous story is when he went to Xerox PARC to in demo with Alto, he does not... It's the first time he see graphic user interface, one of the first time, and it's also they present them with this Alto system that everything could change. But he did not see the power of it. Even when people would demonstrate like, "Hey," Steve Jobs say, "I don't like this direction of scroll bar direction. When you scroll up and down, it shouldn't scroll the opposite reverse direction." Then people just instantly change the scroll bar direction for him.

**中文翻译:**
你知道吗？从某种奇怪的角度来看，史蒂夫·乔布斯其实要为此负责。故事是这样的……其实是事实，不是故事。施乐帕罗奥多研究中心（Xerox PARC）当时正在研发第一代个人电脑 Xerox Alto。艾伦·凯是背后的核心人物之一。Alto 运行的是一个叫 Smalltalk 的系统，在这个系统里，用户和用户的应用之间没有界限。没有所谓的“应用程序”概念，一切都是可塑的，你可以随时更改工具。那个著名的故事是，当乔布斯去 Xerox PARC 观看 Alto 演示时，他第一次看到了图形用户界面（GUI），但对方展示的 Alto 系统是万物皆可修改的，他却没看到这种力量。甚至当人们演示时，乔布斯说：“嘿，我不喜欢这个滚动条的方向，上下滚动时不应该是反向的。”然后演示人员当场就为他修改了滚动条的方向。

---

### (00:10:16) Ivan Zhao

**English:**
That's the power of the original Smalltalk Alto system. He only saw the graphic user interface. He did not see the underlying object or the environment power. As the generation of Steve Jobs and Bill Gates made PC, personal computing, popular and they stuck with this an application framework rather than the Smalltalk object framework. Then that has all the apps we have today and has the SaaS route we have today.

**中文翻译:**
这就是原始 Smalltalk Alto 系统的力量。但他只看到了图形用户界面，没看到底层的对象或环境的力量。随着乔布斯和比尔·盖茨那一代人让个人电脑（PC）普及，他们坚持使用了“应用程序框架”而不是 Smalltalk 的“对象框架”。于是就有了我们今天所有的 App，以及我们今天的 SaaS 路径。

---

### (00:10:43) Lenny Rachitsky

**English:**
That vision of how products should be sounds very familiar and we'll talk about that later of how you think about Notion, but let's assume to the beginning of Notion, when we were chatting earlier, the way you described the early years of Notion, you started Notion in 2013 and some over 10 years ago at this point, you described the first three to four years is the lost years of Notion. And I think this is actually a really big deal for founders to hear about because there's all these companies these days, you hear these stats, they had 100 million ARR in two years, in under two years now. And you don't hear a lot of stories of companies of your scale and success that took three to four years to find product market fit essentially. What went on during these lost years as you described them and just how did you stick with it? That's a long time to stick with something that isn't working.

**中文翻译:**
这种关于产品形态的愿景听起来非常熟悉，我们稍后会聊到你对 Notion 的思考。但让我们回到 Notion 的起点。我们之前聊天时，你提到 Notion 始于 2013 年，距今已超过 10 年，你把最初的三四年描述为 Notion 的“迷失岁月”。我认为这对创业者来说非常重要，因为现在到处都是那种“两年内 ARR 达到 1 亿美金”的公司。像你这样规模和成就的公司，花了三四年才真正找到产品市场契合点（PMF），这样的故事并不多见。在那些“迷失岁月”里发生了什么？你是如何坚持下来的？对于一个行不通的东西，坚持三四年是很漫长的。

---

### (00:11:32) Ivan Zhao

**English:**
Because the goal is always building a computing tool. It's like what product is this? It's really hard to shape the product. The vision is, the dream is there, but the product is very... There's so many paths. We'll try many different versions. The first version to take, okay, everybody can make and create their software. So let's just build a developer tool that's so easy that more people can do that. We tried that a couple of years and learned that actually most people just don't care. The majority of people, they wake up, they have report due, they need to get their job done, they don't care creating software to optimize whatever they're doing. They don't care. So we give to our friends, give to investors. It did not resonate with people.

**中文翻译:**
因为目标始终是打造一个计算工具。但具体是什么产品呢？塑造产品形态非常困难。愿景和梦想都在，但产品路径太多了。我们尝试了许多不同的版本。第一个版本是：既然每个人都能制作软件，那我们就做一个极其简单的开发者工具。我们尝试了几年，发现大多数人根本不在乎。绝大多数人起床后想的是报告要交了，得把工作做完，他们不在乎通过创造软件来优化自己的工作。他们没兴趣。我们把产品给朋友用，给投资者看，但没能引起共鸣。

---

### (00:12:22) Ivan Zhao

**English:**
But we really want to build that tool so we just keep going and our realization is actually, let's hide our vision, which is everybody can create their software, in the form factor that people do care. So what kind of tool do people use every day? Productivity software. So that's why it came to Notion today. If you use Notion, Notion are more understood as the productivity suite, but our intent, and if you use Notion, more you discover intent, which is that it has a no-code developer power into it and you can create almost any kind of productivity software using Notion itself. That took us two plus year to realize. So actually the world is not like you. The world are not developer, designer mind. That the world is they only care what's in front of them and they're so noisy.

**中文翻译:**
但我们真的很想做那个工具，所以我们继续坚持。我们的感悟是：把“人人都能创造软件”的愿景隐藏在人们真正关心的产品形态中。那么人们每天用什么工具？生产力软件。这就是今天 Notion 的由来。如果你用 Notion，它通常被理解为生产力套件，但我们的意图——随着你使用深入会发现——是它内置了无代码开发的能力，你可以用 Notion 本身创造几乎任何类型的生产力软件。我们花了两年多才意识到这一点。事实证明，世界并不像你想象的那样，世界并不都具备开发者或设计师思维。世界上的人只关心眼前的事，而且环境非常嘈杂。

---

### (00:13:16) Lenny Rachitsky

**English:**
There's a quote that this makes me think about where you said, "The first version of Notion was more about what I wanted than what people wanted."

**中文翻译:**
这让我想起你的一句话：“Notion 的第一个版本更多是关于我想要的，而不是人们想要的。”

---

### (00:13:23) Ivan Zhao

**English:**
It's very much so because sense of maturation is you don't see the world just from your perspective but from outside your perspective. At tech, we were young. Took us multiple years. It hit your head straight into the wall to realize that. People just don't care.

**中文翻译:**
确实如此。成熟的标志是你不再仅仅从自己的视角看世界，而是从外部视角看。在技术层面，我们当时很年轻。我们花了好几年，撞得头破血流才意识到：人们真的不在乎（你的理想）。

---

### (00:13:40) Lenny Rachitsky

**English:**
I love the way you phrased that, that you have to hide your vision behind something that people understand and know how to use and...

**中文翻译:**
我非常喜欢你那种说法：你必须把你的愿景隐藏在人们理解并知道如何使用的东西背后……

---

### (00:13:47) Ivan Zhao

**English:**
We call it sugar-coated broccoli. People don't want to eat the broccoli but people like sugar, so give them the sugar then hide the broccoli inside of it.

**中文翻译:**
我们称之为“糖衣西兰花”。人们不想吃西兰花，但人们喜欢糖，所以给他们糖，然后把西兰花藏在里面。

---

### (00:13:55) Lenny Rachitsky

**English:**
Wow. The other thing I've heard is that you threw away your code every time, so you rebuilt it many times. You threw away the code each time.

**中文翻译:**
哇。我还听说你们每次都会把代码扔掉，所以你们重写了很多次。每次都推倒重来。

---

### (00:14:03) Ivan Zhao

**English:**
That's true. Actually, it took us four year to get somewhere. First two year is that you build too much like developer product. Nobody cares. It took us two year to realize we need to build a productivity tool. Then it took another year to realize to build this out, but in the middle of that I realized we built on the wrong technical foundation. So eight, 10 years ago, there's computing before. Right now, all the web app runs on React. Before React wins, there's a competing technology called Web Component from Google. And it makes sense. Web Component feels like a Lego-like, the building block-like, and we're betting on that technology. And then we realize because it's so new, it's just so unstable. It don't know where the bug come from. It's from your source code or from the underlying libraries? Then we have to restart the company, rebuild the whole thing. Otherwise, we're going to run out of time. So we set a code base. We set a company so we can build on our own more orthodox technology foundation.

**中文翻译:**
是真的。实际上，我们花了四年才初见成效。前两年，你做的东西太像开发者产品了，没人关心。我们花了两年才意识到需要做生产力工具。然后又花了一年去构建它，但在过程中我发现我们的技术架构选错了。八、十年前，现在的 Web 应用都跑在 React 上。但在 React 胜出之前，谷歌有一种竞争技术叫 Web Component。它听起来很合理，Web Component 感觉像乐高，像积木，我们当时押注了这项技术。后来我们发现，因为它太新了，非常不稳定。你根本不知道 Bug 是哪来的，是你的源代码还是底层库？于是我们不得不重启公司，重写一切。否则，我们的时间就耗尽了。所以我们封存了旧代码库，重整公司，以便在更正统的技术基础上进行构建。

---

### (00:15:10) Lenny Rachitsky

**English:**
How did you actually stay solvent all this time? A lot of people want to keep working at an idea. Oftentimes they need to pay the bills. How practically were you able to keep working for three to four years? I know there's a story of your mom loaning you some money during that time.

**中文翻译:**
那段时间你是如何维持生计的？很多人想坚持自己的想法，但通常需要付账单。实际上，你是如何坚持工作三四年的？我听说过一个故事，说你妈妈在那段时间借了你一些钱。

---

### (00:15:25) Ivan Zhao

**English:**
Well, Chinese mom always can help, and I'm a single child. Yeah, actually my mom helped me kickstart the company because I'm Canadian. In order to move to US, you need to register a company. So my mom helped me with the initial and raised the money. I returned the money to her. Then we run out of the money so, "Hey mom, can I borrow that just to bridge us?" Which she did. I'm really grateful for that. How we bridged? How do you last here so long? Because the thing you want to create does not exist, which what is called Notions. It's a Lego for software. It doesn't quite exist. There's a Lego for Lego. You can see that in furniture exist, but Lego for software at the usable mass market adoption level doesn't quite exist. And you just want that thing to exist. And I grew up with Legos. It's the only toy I ever wanted, and I want the same feeling of creativity and playfulness to the toy that people can use every day. And my co-founder, Simon, feels the same way. Lego is the only thing he wanted for every Christmas.

**中文翻译:**
嗯，中国的妈妈总是能帮上忙，而且我是独生子。实际上，我妈妈帮我启动了公司，因为我是加拿大人，为了搬到美国，你需要注册一家公司。所以我妈妈帮我出了初始资金并筹了钱。后来我把钱还给了她。再后来我们钱花光了，我说：“嘿，妈，能不能再借我点钱帮我们渡过难关？”她答应了。我对此非常感激。我们是怎么熬过来的？为什么能坚持这么久？因为你想创造的东西还不存在，那就是 Notion——软件界的乐高。它并不真正存在。乐高有积木，家具界也有类似的模块化概念，但在大众市场可用的层面上，软件界的乐高并不存在。你就是想让它存在。我是玩乐高长大的，那是我唯一想要的玩具，我希望人们每天使用的工具也能拥有同样的创造力和趣味感。我的联合创始人 Simon 也有同感，乐高是他每年圣诞节唯一想要的礼物。

---

### (00:16:36) Lenny Rachitsky

**English:**
Have you guys seen Magna-Tiles though? I have a one-and-a-half-year-old and Magna-Tiles are quite delightful. I think it's like a pre-Lego. The children can play them.

**中文翻译:**
你们见过 Magna-Tiles（磁力片）吗？我有一个一岁半的孩子，Magna-Tiles 非常好玩。我觉得它像是乐高的前置版，小孩子也能玩。

---

### (00:16:45) Ivan Zhao

**English:**
Magna-Tile?

**中文翻译:**
磁力片？

---

### (00:16:46) Lenny Rachitsky

**English:**
Yeah. It's like they're little magnetic plastic planes and then you can build much bigger things really quickly. It's more for babies, but I'm having a blast.

**中文翻译:**
是的。它们是带磁性的小塑料片，你可以很快搭出很大的东西。虽然是给婴儿玩的，但我玩得很开心。

---

### (00:17:01) Ivan Zhao

**English:**
Oh, I see it. It's like... Uh-huh.

**中文翻译:**
噢，我看到了。就像……嗯哼。

---

### (00:17:02) Lenny Rachitsky

**English:**
It's a different version of Legos. I like that you're in real-time looking it up. You're like, "Okay, our new vision Magna-Tiles for software."

**中文翻译:**
它是乐高的另一种版本。我喜欢你现场搜索的样子，你就像在想：“好吧，我们的新愿景是做软件界的磁力片。”

---

### (00:17:08) Ivan Zhao

**English:**
Now, most people know, "Oh, Magna-Tile." Idea is the same. Modular, right?

**中文翻译:**
现在大多数人都知道磁力片了。理念是一样的：模块化，对吧？

---

### (00:17:13) Lenny Rachitsky

**English:**
Yeah, creativity. Okay, back to your story. So there's also a moment where you moved to Japan. Just what was that about? Is that just escape and disconnect?

**中文翻译:**
是的，创造力。好，回到你的故事。还有一个时刻，你搬到了日本。那是为了什么？只是为了逃避和断开连接吗？

---

### (00:17:20) Ivan Zhao

**English:**
Yeah, that was during one of the rebuild phases. During the... We know what the product should look like. It should be a productivity software with a Lego power hiding inside of it. We build on the wrong technical foundation. And if we continue to build on the wrong ones, we're going to run out of money. Company won't exist. So we decided to lay off everybody. At that time, the Notion was five people. The layout I brought back to me and Simon, two people. And morale obviously there was really low. You have to say goodbye to your teammates. And so we have the idea, "Let's just go somewhere that we've never been to change the scenery a little bit." And Japan is always top on our list.

**中文翻译:**
是的，那是其中一个重构阶段。当时我们已经知道产品应该是什么样子了——一个内置乐高力量的生产力软件。但我们的技术基础选错了。如果继续错下去，钱会花光，公司也会倒闭。所以我们决定裁掉所有人。当时 Notion 只有五个人，裁员后只剩下我和 Simon 两个人。当时的士气显然非常低落，你不得不和队友告别。于是我们想：“咱们去个从没去过的地方换换心情吧。”日本一直在我们的清单首位。

---

### (00:18:00) Ivan Zhao

**English:**
So the funny thing is if we... And we subleased our apartment and office. We're actually making money living in Japan and then San Francisco. So we did that for a while. We actually travel around the world for a while just to change it up, me and Sam just coding every day and design every day. That's some of the happiest moments. Birthday every day.

**中文翻译:**
有趣的是，我们转租了公寓和办公室。在日本生活其实比在旧金山还省钱，甚至能赚点差价。所以我们那样生活了一段时间。我们环游世界了一阵子来换换环境，我和 Simon 每天就是写代码、做设计。那是我们最快乐的时光之一，感觉每天都在过生日。

---

### (00:18:27) Lenny Rachitsky

**English:**
I saw a stat you're coding 18 hours a day. Here's the quote I heard, :We just code, code, code. Then hey, let's go for food. Then we go eat, go back to work, and do it again."

**中文翻译:**
我看到一个数据说你每天写 18 小时代码。我听过这样一段话：“我们就是写代码、写代码、写代码。然后说，嘿，去吃饭吧。吃完饭回来继续干，循环往复。”

---

### (00:18:35) Ivan Zhao

**English:**
Because me and him working so well now. Even back then, it's like you know what each other other people are thinking and you can just cross through the problem space really quickly. The technical product space, design space, and just non-stop of shaping stuff.

**中文翻译:**
因为我和他配合得太默契了。即便在当时，我们也知道对方在想什么，可以非常快速地穿梭于问题空间——技术产品空间、设计空间，不停地塑造东西。

---

### (00:18:55) Lenny Rachitsky

**English:**
So maybe just to close out this thread, for people, for founders that are either struggling and just can't find a thing that's working, "I've been working on something for a long time," I'm curious what advice you'd share for sticking with it. And I'll share things I've heard you say so far and I'm curious if there's something you'd add. One is you just believe this needs to exist in the world and you need to really feel this, "I need this to be a thing." I think there's an element of staying lean, like you've let everyone go and it's just you and Simon again. There's also this element of disconnecting almost and just going to a different location and just like, "Let's just reset." What other elements do you think are key to you finding something that actually ended up working?

**中文翻译:**
为了结束这个话题，对于那些正在挣扎、找不到出路、或者已经在一个项目上耗了很久的创业者，我很想知道你会分享什么坚持下去的建议。我会总结一下我目前听到的，看看你还有什么补充。第一，你坚信这个东西必须存在于世，你必须有这种“我一定要把它做出来”的强烈感觉。第二，保持精简，比如你裁掉了所有人，只剩下你和 Simon。第三，几乎是断开连接，去一个不同的地方，彻底重置。你认为还有哪些关键因素让你最终找到了行之有效的方向？

---

### (00:19:36) Ivan Zhao

**English:**
I'm lucky and Simon lucky that high is never too high, low is never too low for us, so somehow it wasn't feeling too down. Whenever I feel down, I just go to sleep and next day I'm just reset. So that's lucky for me. Definitely don't be afraid to reset. I think courage is quite important because oftentimes you're working on things don't matter, but momentum just took you there. Your first point of building something you want the world to have. What is the building a product or business? You want user. You want revenue. That's a product business. It's almost like a sports. The market is the arena. Then you'd want to optimize the scorecard where it's building for winning. And I grew up playing sports. I like to compete so I like that.

**中文翻译:**
我很幸运，Simon 也很幸运，我们的情绪波动没那么剧烈，高潮不狂喜，低谷不绝望，所以总能感觉还好。每当我感到沮丧，我就去睡觉，第二天就重置了。这对我来说很幸运。绝对不要害怕重置。我认为勇气非常重要，因为很多时候你只是在惯性的推动下做一些无关紧要的事。回到你说的第一点：创造你希望世界拥有的东西。什么是打造产品或业务？你想要用户，想要收入，这就是产品业务。这几乎像体育运动，市场就是竞技场，你想优化计分板，为了赢而建设。我从小参加体育运动，我喜欢竞争，所以我喜欢这一点。

---

### (00:20:34) Ivan Zhao

**English:**
And building for something you want the world to have is building for your value. You have some taste. You have some aesthetic. You have some values. You want the world to have more of that. They are different energy. I realize actually fairly recently, they're really different. Depends on which day I wake up, I might be in different mood for things, but building for value it's more lasting and more fulfilling. Looking in the thing we're building today and looking back, I find most proud of thing I create something authentic to myself and happen to be also useful for others, and that just keeps you going. And that feels like a more durable energy source for all those dark years, loss years during Notion, and still every day for me.

**中文翻译:**
而为你希望世界拥有的东西而创作，是为你的价值观而创作。你有自己的品味、审美和价值观，你希望世界拥有更多这样的东西。这是不同的能量。我最近才意识到，它们真的很不一样。取决于我哪天醒来，我可能会有不同的心情，但为价值观而创作更持久、更充实。看着我们今天正在做的事情并回首往事，我最自豪的是我创造了一些对自己来说很真实、同时又对他人有用的东西，这让你能一直走下去。对于 Notion 那些黑暗的、迷失的岁月，以及现在的每一天，这都是一种更持久的能量来源。

---

### (00:21:24) Lenny Rachitsky

**English:**
It's interesting you say that because also there's this aspect of it wasn't working initially because you're building it for yourself and not for people, but what I'm hearing is it's still important to build a thing that you are still excited about but also have you go back and forth. Here's what the business needs and here's the thing I'm excited about.

**中文翻译:**
你这么说很有趣，因为最初行不通的原因之一是你只为自己而建，而不是为大众。但我听到的是，建立一个让你兴奋的东西依然很重要，只是你需要在“业务需求”和“个人兴奋点”之间来回切换。

---

### (00:21:42) Ivan Zhao

**English:**
Yeah, really a cue. Almost like a therapist, right? It's true. You're building too much for your own self and value without realizing at the end of the day, if you're building a product and tool has to be used by others, you need to create a balance. Too much of yourself, then there's no users. Then you're just doing our project. You're just doing a research project. And too much for a business, you're building a commodity. So where's the spectrum? Yeah, it's never ending spectrum. It's interesting.

**中文翻译:**
是的，这确实是个关键点。感觉你像个心理医生，对吧？确实如此。如果你太为自己和自己的价值观而建，却没意识到产品最终是要给别人用的，你就需要创造一种平衡。自我意识太强，就没有用户，那你只是在做一个个人项目或研究项目；太追求业务，你就是在做一个平庸的商品。这个光谱的平衡点在哪？这是一个永无止境的探索，很有趣。

---

### (00:22:17) Lenny Rachitsky

**English:**
Yeah, okay. So I'll summarize some of those things you shared of just how to stick with it and stay with an idea and not give up. So I love that you said just get sleep, very Brian Johnson of you, just like, "Get some sleep when it's a real down day. There'll be another day tomorrow." Really simple but...

**中文翻译:**
好，我总结一下你分享的关于如何坚持、不放弃想法的建议。我喜欢你说的“去睡觉”，这很有布莱恩·约翰逊（Brian Johnson）的风格，“在糟糕的日子里睡一觉，明天又是新的一天。”虽然简单，但……

---

### (00:22:32) Ivan Zhao

**English:**
It's like a daily personal physical reset. You can reset your code base. You can reset your mental model.

**中文翻译:**
这就像是每日的个人身体重置。你可以重置代码库，也可以重置你的思维模型。

---

### (00:22:39) Lenny Rachitsky

**English:**
Okay. And then there's also, I love these points. Don't be afraid to reset, as you just said. Tobi Lutke was on the podcast. He said the same thing. "Just be comfortable with some cost. I have done all this already and I will throw it away and start again and that's okay."

**中文翻译:**
好。还有，我喜欢这些观点：不要害怕重置。Tobi Lutke（Shopify CEO）也来过这个播客，他说过同样的话：“要坦然面对沉没成本。我已经做了这么多，但我愿意扔掉它重新开始，这没关系。”

---

### (00:22:53) Ivan Zhao

**English:**
Yeah. I think it's not just a self-help way to say don't be afraid to reset. That's like, that's okay, that's fine. I think the more interesting point here, it's like you can create progress through better abstractions. And that thing compounds faster, can catch up to all the things you build much quicker than you ever thought. Or humans are not thinking, not good at thinking in terms of abstraction or exponentials. We're thinking in terms of linearly. If you just reset it and you find a better way to do it, you can get all the thing you have to some cost recovered really quickly.

**中文翻译:**
是的。我觉得“不要害怕重置”不仅仅是一句心灵鸡汤。更有趣的一点是：你可以通过更好的“抽象”（abstractions）来创造进步。这种进步的复利速度更快，能比你想象中更快地追上你之前建立的所有东西。人类不擅长抽象思维或指数级思维，我们习惯于线性思维。如果你重置并找到更好的方法，你可以非常迅速地收回所有沉没成本。

---

### (00:23:29) Ivan Zhao

**English:**
So actually going back to the computing pioneers part, small talk, one of the first system and a huge influence for Notion was really tiny code base and inspired by Lisp, which is another programming languages and probably a hundred lines of code or something. The kernel of things could be really small, but just like math. It can compound. It can have complex behavior that unlocks so much value and things for you. But if you just find those right, you can catch up to all the things you did. You are free to lose really quickly. So I think that's the kernel of why reset is so powerful.

**中文翻译:**
回到计算先驱的话题，Smalltalk 是最早的系统之一，对 Notion 影响巨大。它的代码库非常小，受 Lisp 语言启发，内核可能只有几百行代码。事物的内核可以非常小，但就像数学一样，它可以产生复利，产生复杂的行为，从而为你解锁巨大的价值。只要你找准了这些内核，你就能追回之前做的一切。你可以很快地从失败中解脱。我认为这就是为什么“重置”如此强大的核心原因。

---

### (00:24:10) Lenny Rachitsky

**English:**
And we're seeing exactly what you're describing in LLM advancements these days. All these companies have been working on this for so long and then they've cracked an abstraction of how to think about scaling these systems. And now just people launch them and are immediately where the companies that have been working this for decades are today because they are building off these abstractions as you described in these.

**中文翻译:**
我们现在在 LLM（大语言模型）的进展中也看到了你描述的这种现象。所有这些公司已经研究了很久，然后他们破解了一个关于如何扩展这些系统的“抽象”方法。现在人们一发布新模型，就能立刻达到那些研究了几十年的公司的水平，因为他们是站在你所描述的这些抽象基础之上构建的。

---

### (00:24:34) Ivan Zhao

**English:**
Trying to caught up the US really quickly.

**中文翻译:**
（比如中国公司）正试图迅速赶上美国。

---

### (00:24:36) Lenny Rachitsky

**English:**
With DeepSeek, yeah. The point you also made about momentum, be weary of momentum taking you in direction and moving in a different... not being stuck to that direction is exactly the way I think the chain of thought models network actually where generally LLMs are like, next word, next word, next word, next word. And if they ever make a wrong turn, they're stuck. They keep going from that path. And these chain of thought models are now good at just like, wait, let me rethink. Is this actually the right path or should I start again? So I feel like AI has almost figured out exactly what you're describing.

**中文翻译:**
比如 DeepSeek，没错。你提到的关于“惯性”的观点——警惕惯性带你走向某个方向，而不被困在那个方向——这正是我认为“思维链”（Chain of Thought）模型的工作方式。通常 LLM 是预测下一个词、下一个词。如果它们走错了路，就会被困住，沿着错路走下去。而现在的思维链模型擅长停下来想：“等等，让我重新思考一下，这真的是正确的路径吗？还是我应该重新开始？”我觉得 AI 几乎已经领悟了你所描述的这种逻辑。

---

### (00:25:06) Ivan Zhao

**English:**
Interesting.

**中文翻译:**
很有意思。

---

### (00:25:07) Lenny Rachitsky

**English:**
Oh, man. Okay, last question about the early years. Everyone's always wondering what does product market fit feel like? You worked on it for three to four years. What was the moment? What would it look like? What was different when you're like, "Okay, this is going to work"?

**中文翻译:**
好，关于早期阶段的最后一个问题。每个人都在好奇“产品市场契合点”（PMF）是什么感觉？你为此努力了三四年。那个瞬间是什么样的？当你觉得“行了，这东西能成”的时候，情况有什么不同？

---

### (00:25:20) Ivan Zhao

**English:**
I think going back to me and Simon, high is never that high, low is never that low, it never hit us as a binary state. Just like, "Oh, good. We have people who care about this thing we make now. Oh, good. People reach out to us who are paying us." And it's a very gradual ramp. Maybe that's why early days when it's really the lost eras, it doesn't feel too low because it just... Even for Notion today, it feels like it's so small in terms of where it could be. It just they keep going, right? It's a less of a milestone way to thinking about things. It's more just like, "Can we do the same that's in our head and better than we did last week?" way of thinking about things. So there's a such movement that product market, boom, milestone achieved. Didn't feel that way.

**中文翻译:**
我想回到我和 Simon 的性格，高潮不狂喜，低谷不绝望，所以 PMF 对我们来说从来不是一个非黑即白的瞬间。只是觉得：“噢，不错，现在有人关心我们做的东西了。噢，太好了，有人主动联系我们要付钱了。”这是一个非常缓慢的爬坡过程。也许这就是为什么早期那些“迷失岁月”感觉没那么低落的原因。甚至对于今天的 Notion 来说，相对于它未来的潜力，它依然显得很小。我们只是在继续前进。我们不太用“里程碑”的方式思考，更多是想：“我们能不能把脑子里的东西做出来，并且比上周做得更好？”所以并没有那种“砰的一声，达成里程碑”的时刻。

---

### (00:26:13) Lenny Rachitsky

**English:**
I've heard that from a lot of founders actually. Was there a moment in that point of just like, "Oh, this is different," or, "Maybe it's going to work this time"?

**中文翻译:**
我确实从很多创始人那里听过类似的说法。但在那个阶段，有没有哪个时刻让你觉得：“噢，这次不一样了”，或者“这次可能真的行了”？

---

### (00:26:23) Ivan Zhao

**English:**
I think for a while, okay, once we start revenue, product grows faster now. Investors start knocking on the door was like, I remember one day it's like there's a dog food, dog treats sent to our entire office. So first of all, office wasn't public, the address. And the dog treats, why do people want this so much? So that was a moment I paused a little bit and I guess there's enough attraction for investors.

**中文翻译:**
我想有一段时间，一旦我们开始有了收入，产品增长就变快了。投资者开始找上门来。我记得有一天，有人往我们办公室寄了狗粮和狗零食。首先，我们办公室的地址是不公开的。为什么要寄狗零食？为什么人们这么想要（投资）我们？那一刻我停下来想了想，意识到我们对投资者已经有足够的吸引力了。

---

### (00:26:55) Lenny Rachitsky

**English:**
And the dog treats were trying to... It was like a gift to be like, "Hey, you should talk to us. We're sending this fun gift."

**中文翻译:**
那些狗零食是想表达……就像一份礼物，说：“嘿，你应该跟我们聊聊，我们送你这个有趣的礼物。”

---

### (00:26:59) Ivan Zhao

**English:**
Yeah, because of the way how we just hire someone in the office as a dog. Then I think we post on Twitter or something. And I said, "Why did this show up to our office?" Someone really hustled into where we are in our office address and follow us on Twitter.

**中文翻译:**
是的，因为我们当时在办公室“雇”了一只狗。我想我们可能在 Twitter 上发过照片。我说：“这东西怎么寄到我们办公室来的？”有人真的费尽心思查到了我们的地址，并在 Twitter 上关注着我们的一举一动。

---

### (00:27:17) Lenny Rachitsky

**English:**
Did you end up taking their money?

**中文翻译:**
你最后拿他们的钱了吗？

---

### (00:27:19) Ivan Zhao

**English:**
Not the first time, yeah.

**中文翻译:**
第一次没拿。

---

### (00:27:20) Lenny Rachitsky

**English:**
Okay, later. Okay, it's long game.

**中文翻译:**
好吧，后来拿了。这是个长线游戏。

---

### (00:27:24) Ivan Zhao

**English:**
No.

**中文翻译:**
不（也没拿）。

---

### (00:27:25) Lenny Rachitsky

**English:**
Awesome. So I've never heard that before. Sign product market fit as VCs are starting to... You start getting a lot more messaging and cold outreach from VCs.

**中文翻译:**
太有意思了，我以前没听过这种说法。PMF 的标志是风投（VC）开始……你开始收到大量风投的信息和冷启动联系。

---

### (00:27:33) Ivan Zhao

**English:**
Actually, I had one of our investor, it's really helpful because all those years you just like there's no feedback loop. You just go for it. Then the feedback loop gradually show up. Then for a while it's, oh, VCs start knocking on doors. So I should talk to those people. The people like what we're doing. I did some meetings, quite a few of meetings. Maybe it doesn't... I realize and one of the members is saying, "Ivan, what are you doing? You clearly don't need money. You're just trying to feel good to do external validation about this." And I said, "Oh, that's so true." It doesn't help us make a better product and the truth is with what customer tell us. Then we just went back to building. I went back to hardcore building, no meeting modes. That's where the dog food story came about and realized, "Oh." It's interesting.

**中文翻译:**
实际上，我们的一位投资者给了我很大帮助。因为在那几年里，你完全没有反馈闭环，只能硬着头皮往前冲。后来反馈闭环逐渐出现了。有一段时间，风投开始敲门，我想我应该跟他们聊聊，人们喜欢我们做的事。我开了一些会，开了不少会。后来我意识到，其中一位成员对我说：“Ivan，你在干什么？你显然不需要钱，你只是想通过外部验证来获得成就感。”我说：“噢，太对了。”这并不能帮我们做出更好的产品，真相在于客户告诉我们的东西。于是我们回去继续开发，我回到了硬核开发、拒绝会议的模式。这就是那个狗粮故事的背景，我意识到：“噢，这很有趣。”

---

### (00:28:30) Lenny Rachitsky

**English:**
You mentioned this investor, they said it was really helpful. Is you want to give them some credit or do you want to keep-

**中文翻译:**
你提到这位投资者非常有帮助。你想提一下她的名字吗？还是想保持——

---

### (00:28:35) Ivan Zhao

**English:**
Oh, Shana Fisher. She's in New York.

**中文翻译:**
噢，是 Shana Fisher。她在纽约。

---

### (00:28:38) Lenny Rachitsky

**English:**
Okay, cool.

**中文翻译:**
好的，酷。

---

### (00:28:39) Ivan Zhao

**English:**
Yeah, she's like another therapist, right?

**中文翻译:**
是的，她就像另一个心理医生，对吧？

---

### (00:28:43) Lenny Rachitsky (Ad Segment)

**English:**
This episode is brought to you by Sinch, the customer communications cloud... (Ad content continues)

**中文翻译:**
本期节目由 Sinch 赞助，Sinch 是客户沟通云平台……（广告内容略）

---

### (00:29:57) Lenny Rachitsky

**English:**
I want to shift to talking about Notion today and the way you've approached it and a good segue is what you've been talking about right now is how lean and efficient you've been and how that's been a big priority for you. So a few stats I've seen. One is that you guys are profitable. You've been profitable for a couple of years now. I don't know if you've spent even the money you've raised. I think most of it is still in the...

**中文翻译:**
我想转而聊聊今天的 Notion 以及你的经营方式。一个很好的切入点是你刚才提到的：你们一直保持着精简和高效，这是你们的重中之重。我看到一些数据：你们已经盈利了，而且已经盈利好几年了。我甚至不知道你们有没有花过融资来的钱，我想大部分钱还在……

---

### (00:30:20) Ivan Zhao

**English:**
Yeah.

**中文翻译:**
是的（还在银行里）。

---

### (00:30:20) Lenny Rachitsky

**English:**
It's still in the bank. You're nodding, if you're on YouTube. You didn't have a salesperson until you hit over 10 million ARR. You hired your first PM at 50 people. You've always kept the team generally really small. Why is that been important to you? It's very cool now. Everyone's like, "Of course, that's how it should be." But for the past decade, that has not been the case. You've always been that way. Why has that been so important?

**中文翻译:**
还在银行里。如果你在看 YouTube，会看到他在点头。在 ARR 超过 1000 万美元之前，你们甚至没有销售人员。在公司达到 50 人时才雇了第一个产品经理（PM）。你们一直保持着极小的团队规模。为什么这对你如此重要？现在这种做法很酷，大家都说“理应如此”，但在过去十年里，这并不是主流做法。你一直坚持这样，为什么？

---

### (00:30:44) Ivan Zhao

**English:**
I think going back to the abstraction system way of problem solving, I think we're lucky that me and Simon and Akshay, we have the skillset you probably can run a whole company, which is a couple of us, I can design, I can do marketing, storytelling, close sales deals. So you realize you don't need a lot. But when you can do a lot at the same time or hire people who can do that, naturally keep the company small. And you all know you're doing product management. The overhead is actually more from internal communication. It's really hard to get people's mind to be aligned on things, to see the world in the same way. And the part that you do need people, maybe you can solve better through systems, through better tools.

**中文翻译:**
我想这要回到用“抽象系统”解决问题的方式。我觉得我们很幸运，我和 Simon、Akshay 拥有的技能组几乎可以运行整家公司——我们几个人里，我可以做设计、做营销、讲故事、谈销售。所以你会意识到你不需要很多人。当你能同时做很多事，或者雇佣能做到这一点的人时，公司自然会保持精简。而且大家都知道，做产品管理时，最大的开销其实来自内部沟通。让大家思想统一、以同样的方式看世界是非常难的。而那些确实需要人手的地方，也许可以通过系统和更好的工具来更好地解决。

---

### (00:31:39) Ivan Zhao

**English:**
Notion itself is a meta tool to build other tools. So we pretty much run everything on Notion. We use the same mindset to build our company. And accidentally, that keep our headcount low, keep our company profitable, which then puts you on a positive treadmill of you don't have to go for the next 18, 24 months to find money. You can just focus on building. And also because your team's small, we have this internal Notion called talent density. We don't try to track number of people but we try to track how talent-dense, revenue per employee we are. And people want to work with either more talented people. So it's a positive company group.

**中文翻译:**
Notion 本身就是一个用来构建其他工具的“元工具”（meta tool）。所以我们几乎所有业务都跑在 Notion 上。我们用同样的思维来建设公司。这无意中让我们的员工人数保持在低位，让公司保持盈利，从而让你进入一个良性循环：你不需要在接下来的 18 到 24 个月里忙着找钱，你可以专注于构建产品。此外，因为团队小，我们内部有一个概念叫“人才密度”。我们不追踪人数，而是追踪人才密度和人均创收。优秀的人也想和更优秀的人共事，所以这是一个良性的公司成长过程。

---

### (00:32:27) Lenny Rachitsky

**English:**
I wonder how much of this is actually from being around for so many years without success of, "We just have to stay very lean and save our cash because otherwise, we'll die." Do you think that was a formative experience to inform how you want to operate or is that always something?

**中文翻译:**
我在想，这其中有多少是因为经历了多年没有成功的磨练，让你们觉得“我们必须保持精简、节省现金，否则就会死”？你认为那是塑造你经营方式的决定性经历吗？还是你一直以来就是这样？

---

### (00:32:42) Ivan Zhao

**English:**
No, I wouldn't say we're, Notion, is a cost saving-first company. I like fancy chairs. I like furniture. But we're not wasting money. I think it's more just from a taste or approach to problem solving. I just believe better system is much better than brute force through people.

**中文翻译:**
不，我不会说 Notion 是一家“省钱至上”的公司。我喜欢名贵的椅子，喜欢家具。但我们不乱花钱。我觉得这更多是源于一种品味或解决问题的方法。我坚信，一个更好的系统远比靠堆人力的“蛮力”要好得多。

---

### (00:33:05) Lenny Rachitsky

**English:**
When people hear this idea of staying lean and staying small, it sounds great or we're going to be super efficient and lean and smart with our money and down dense. It's very hard to do and it's very hard not to hire more engineers, more designers. What advice do you have for folks that want to operate this way? What has allowed you to actually be successful while staying lean and not having as many engineers as competitors, many designers as competitors?

**中文翻译:**
当人们听到“保持精简、保持小规模”这个想法时，听起来很棒——我们要高效、精简、聪明地花钱、保持高人才密度。但实际操作很难，很难忍住不去雇更多的工程师和设计师。对于想以这种方式经营的人，你有什么建议？是什么让你在保持精简、工程师和设计师远少于竞争对手的情况下，依然取得了成功？

---

### (00:33:29) Ivan Zhao

**English:**
I think just understand abstraction or system is a better curve than pecan curve, right? Linear. We internally help other people and understand this. Internally we use the metaphor that Notion's a small bus. The bus, the smaller the bus, it's easier to turn corners, easier to accelerate, easier to maneuver. The bigger the bus it is, bigger the boat or bigger the bus, slow down. And as a leader in the company, you decide who sit around you on the bus seats. That dictates how fast our overall bus moves, dictate your work and life experience at this company because you pick your roommate, you pick your seat mates. That metaphor clicks with people inside a company and overall help us optimize to make the bus link.

**中文翻译:**
我认为关键在于理解“抽象”或“系统”带来的增长曲线优于线性增长。我们在内部帮助员工理解这一点。我们用一个比喻：Notion 是一辆“小巴士”。巴士越小，转弯越容易，加速越快，操控越灵活。巴士越大，或者像大船一样，速度就会慢下来。作为公司的领导者，你决定谁坐在你身边的巴士座位上。这决定了我们整辆巴士移动的速度，也决定了你在公司的办公和生活体验，因为是你挑选了自己的“室友”和“座友”。这个比喻在公司内部引起了共鸣，帮助我们优化并保持巴士的精简。

---

### (00:34:18) Lenny Rachitsky

**English:**
I've never heard of that metaphor before.

**中文翻译:**
我以前从未听过这个比喻。

---

### (00:34:22) Ivan Zhao

**English:**
It probably came up somewhere but... Or it does not.

**中文翻译:**
可能在别处出现过，也可能没有。

---

### (00:34:25) Lenny Rachitsky

**English:**
Small bus. So along these lines actually, so I visited the office recently and I noticed that it's just a very cozy vibe. And I learned that you had a rule of no shoes in the office for a long time until the last office, that you all ate around one table for a long time, that you try 30 different shades of warm white on the walls before you chose. Why is that important to you? Why is it so important to be so thoughtful about the office experience?

**中文翻译:**
小巴士。说到这里，我最近参观了你们的办公室，发现氛围非常温馨。我听说你们很长一段时间都有“办公室不准穿鞋”的规定，直到搬进上一个办公室为止；你们很长一段时间都在一张桌子上吃饭；你甚至在墙上尝试了 30 种不同的暖白色调才做决定。为什么这对你很重要？为什么对办公室体验如此考究？

---

### (00:34:53) Ivan Zhao

**English:**
Maybe there are two dimension part of it. One is the pragmatic part. You just want office to be a pleasant experience to be at. Therefore, most office, the top light feels like hospital. You're just like, "Oh, man." And the white is so pale and the floor is so dark. Why use some kind of cream, make floors more friendly colors? And don't use top light. Top light is evil. So just the office feels cozy so people spend more time. You feel more creative, more at ease in the office space.So the vision work we have is should feels like artist studio or should feel like your home. And that's why most our office furniture are home furnitures. It just feels cozy. That's more so people spend more time, feels more creative, juices flow better.

**中文翻译:**
可能有两个维度的原因。一个是务实层面：你希望办公室是一个让人愉悦的地方。大多数办公室的顶灯感觉像医院，让人很不舒服。墙壁惨白，地板阴暗。为什么不用奶油色，让地板颜色更亲切一点？而且不要用顶灯，顶灯是“邪恶”的。办公室感觉温馨，人们就愿意待得更久。在这样的空间里，你会感到更有创意、更自在。我们对办公空间的愿景是：它应该像艺术工作室，或者像你的家。所以我们大部分办公家具都是家用家具。这能让人们待得更久，更有创意，灵感流动得更顺畅。

---

### (00:35:42) Ivan Zhao

**English:**
The other world just like at least personally for me, it hurts the eyes if you just see ugly things. It's more from a value aesthetic front. It's like we talk about ergonomic chairs. Does it hurt your back when you sit on bad chairs? But you have more visual improve from, at least for me from the eyes. If the chair looks ugly, the wall looks ugly, it hurts. So it's better to not have thing that hurts.

**中文翻译:**
另一个层面纯粹是个人感受：看到丑陋的东西会伤眼睛。这更多是价值观和审美层面的。就像我们讨论人体工程学椅子，坐烂椅子会腰疼；但对我来说，视觉上的冲击更直接。如果椅子丑、墙壁丑，我会感到痛苦。所以最好不要有让人痛苦的东西。

---

### (00:36:05) Lenny Rachitsky

**English:**
You also have a really interesting naming convention for your conference rooms.

**中文翻译:**
你们会议室的命名方式也非常有趣。

---

### (00:36:08) Ivan Zhao

**English:**
Yeah, that's true. Yeah. We name our conference room after timeless tools in history. So there, I'll give you an example. iPhone's obvious one, original Macintosh, various different form of chairs, Lamy's 2000 pens, Toshiba rice cookers, and other ones because they're inspirations. They're just like at the end of the day, we're creating a tool. We're creating a meta tool. A lot of people to create tools, software tools. And Toshiba rice cooker changed how people eat rice in Asia for a hundred million, tens of a hundred million people. The Sony transistor radio is the first one to shrink something small and useful for people. And those things change people's life and last for decades. What it's like to create a software product like that? I want to inspire my team to think that way. Because software, and especially tech, it's every six months, every 12 months cycle. We don't think enough about creating something that lasts. I care creating something that at least the form factor lasts longer than 18 month.

**中文翻译:**
是的。我们用历史上“永恒的工具”来命名会议室。举几个例子：iPhone 是显而易见的，还有初代 Macintosh、各种形态的经典椅子、凌美（Lamy）2000 钢笔、东芝电饭煲等等。因为它们是灵感来源。归根结底，我们是在创造一个工具，一个让很多人能创造软件工具的“元工具”。东芝电饭煲改变了数亿亚洲人吃米饭的方式；索尼晶体管收音机第一次把实用的东西缩小到可以随身携带。这些东西改变了人们的生活，并延续了几十年。创造一个那样的软件产品会是什么样？我想激励我的团队这样思考。因为软件，尤其是科技行业，通常是 6 到 12 个月的周期。我们对“创造永恒之物”思考得不够。我希望能创造出一些至少在产品形态上能存在超过 18 个月的东西。

---

### (00:37:21) Lenny Rachitsky

**English:**
There's a quote that you tweeted once that I think of as you talk about this from Steve Jobs. "The problem is that there's just a tremendous amount of craftsmanship between a great idea and a great product." I don't know if you remember tweeting that, but just what do you think of when you hear that?

**中文翻译:**
你曾经发过一条推特，引用了乔布斯的一句话，我刚才听你说话时想到了它：“问题在于，在一个伟大的创意和一个伟大的产品之间，隔着海量的工艺（craftsmanship）。”我不确定你还记不记得发过这条，但当你听到这句话时，你会想到什么？

---

### (00:37:36) Ivan Zhao

**English:**
Yeah, I think the key word here is craft. Internally, our company philosophy called crafts and values. Craft is your skill set, your taste. Value is your personal value and how do you see the world. Craft is interesting word. It's like about apply your value to some technical know-how and to make more clever trade-offs to create something new and useful and just keep doing that.

**中文翻译:**
是的，我认为关键词是“工艺”（Craft）。在公司内部，我们的哲学叫“工艺与价值观”。工艺是你的技能组和品味；价值观是你的个人价值和你如何看待世界。工艺是个很有趣的词，它是关于如何将你的价值观应用到技术诀窍中，通过更聪明的权衡来创造新颖且有用的东西，并持之以恒。

---

### (00:38:09) Ivan Zhao

**English:**
My wife often refer me as a wood cabinet builder. That's how at least my mindset training towards building Notion is like, "Oh, can I make this wood cabinet more beautiful and more useful and feels nicer on your hand?" And that's like you have aesthetic direction towards it and you have your technical know-how to actually make things happen. Then you need to do permutation and trade-off in your head where on paper and to get there. That to me, that's craft. And building product, to me at least, to me feels that way. Building business feels that way. Building company feels that way.

**中文翻译:**
我妻子经常把我比作一个木柜匠。至少我在构建 Notion 时的心态是这样的：“噢，我能不能让这个木柜更美观、更实用、手感更好？”这意味着你既要有审美方向，又要有实现它的技术能力。然后你需要在脑子里或纸上进行各种排列组合和权衡，最终达成目标。对我来说，这就是工艺。打造产品、经营业务、建设公司，对我来说都是这种感觉。

---

### (00:38:44) Lenny Rachitsky

**English:**
It's interesting that so much of this conversation is this and the way you think about building this company is this balance between practical, useful things people need and business and practical stuff, and then the value of building something you're proud of and craft. And there's always this trade-off almost of speed and quality, and I know that's an important element for you. Just thinking about trade-offs between decisions, so talk about just trade-offs, just how you think about making a trade-off.

**中文翻译:**
很有趣，我们对话的很多内容，以及你建设公司的方式，都在于这种平衡：一方面是人们需要的实用工具和业务逻辑，另一方面是打造让你自豪的东西的价值和工艺。这几乎总是在速度和质量之间进行权衡，我知道这对你很重要。谈谈你如何思考决策中的权衡吧。

---

### (00:39:13) Ivan Zhao

**English:**
Yeah, I think this is quite relevant especially for product makers and business makers is there's no free lunch. You don't get something for free. You have to give up something. Then what do you give up? It's essentially you give up the right thing that market or your user wants at that given space and time. It's just the craft of building a business or building a product. And that the market is so dynamic, especially now with AI. The optimized function for the market changes so then you need to make new trade-off and new technology emerges. I always feels like AI language model feels like a new type of wood. It feels like aluminum. It's a new type of material.

**中文翻译:**
是的，我认为这对产品创造者和业务经营者非常重要：天下没有免费的午餐。你不可能平白无故得到什么，你必须放弃一些东西。那么放弃什么呢？本质上是在特定的时空下，放弃市场或用户想要的一些次要东西。这就是打造业务或产品的工艺。市场是动态的，尤其是现在有了 AI。市场的优化函数发生了变化，所以你需要做出新的权衡，新技术也在不断涌现。我总觉得 AI 语言模型就像一种“新木材”，或者像铝。它是一种新型材料。

---

### (00:40:35) Ivan Zhao

**English:**
So you can make... Mass air travel wasn't available until aluminum become cheap enough that people can make airplanes that support this at cost. And it's like computer wasn't there until semiconductor becomes... It's like require new technology to unlock new way to making trade-offs, and then you need to balance the technology trade-off with human behavior trade-off. As a human, ever since we got out of Africa, we're set, right? That's a constraint. It's invariable. And every generation pick up some new things but after you're 16 years old you don't want to learn new things. So those are there are the people trade-off, technology trade-off. There's some macro. There's a different dimension of things just cooking together that come together as a product more as a business than what is that? And I think a product maker, business maker's job is to find that sweet spot of all the multiple dimensions, then create something has a right to exist. At least it's more durable to exist.

**中文翻译:**
在大规模航空旅行普及之前，铝必须变得足够便宜，人们才能制造出成本可控的飞机。计算机也是如此，直到半导体变得……新技术解锁了新的权衡方式，然后你需要平衡技术权衡与人类行为权衡。作为人类，自从我们走出非洲以来，我们的基本属性就定型了，对吧？这是一个不变的约束。每一代人都会学点新东西，但 16 岁以后，你就不太想学新东西了。所以这里有人性的权衡、技术的权衡，还有宏观环境。各种维度的东西交织在一起，最终形成一个产品或业务。我认为产品和业务创造者的工作就是找到所有这些维度的“甜点位”（sweet spot），然后创造出一些有理由存在、且能更持久存在的东西。

---

### (00:41:16) Lenny Rachitsky

**English:**
And I'm hearing there's this thread of just like with new technologies, what is now possible. And I know you guys are doing some cool stuff with AI that I'm going to get to that is unlocking some cool new ideas. But before I get there, I want to talk about just you as a leader. At this point, you've been at this for 12 years, something like that.

**中文翻译:**
我听到了一条主线：随着新技术出现，什么是现在变得可能的。我知道你们在 AI 方面做了一些很酷的事情，稍后我会聊到。但在那之前，我想聊聊作为领导者的你。到目前为止，你已经做了大概 12 年了。

---

### (00:41:31) Ivan Zhao

**English:**
Like that, yeah.

**中文翻译:**
差不多，是的。

---

### (00:41:32) Lenny Rachitsky

**English:**
And if you don't mind me saying, you're a soft-spoken leader, which is you're not like the archetype of what people imagine is like the CEO of a 10 billion... And I'm sure you guys are valued much more now. I don't even know. That was probably an old valuation. I think it's great for people to see leaders like you that are not necessarily the classic archetype of CO, and I imagine there are things you've had to work on and build and lean into that aren't natural to you to step into this role of this increasingly growing, high-scale business. What are some of the areas you've had to most build and learn to do that didn't come naturally to you?

**中文翻译:**
如果你不介意我这么说的话，你是一位说话温和的领导者，不像人们想象中那种典型的百亿美金公司 CEO 的样子……我确信你们现在的估值更高了，我甚至不知道具体数字，那可能是旧数据。我觉得让大家看到像你这样不属于典型 CEO 范式的领导者是很棒的。我猜想，为了胜任这个不断增长、大规模业务的角色，你肯定不得不去磨练和强化一些对你来说并不自然的能力。哪些领域是你必须努力学习、且并非天生擅长的？

---

### (00:42:10) Ivan Zhao

**English:**
I guess you've never been in a business meeting or brainstorm session with me. You're not there.

**中文翻译:**
我猜你肯定没参加过我的业务会议或头脑风暴。你不在现场。

---

### (00:42:15) Lenny Rachitsky

**English:**
Haven't seen that side of Ivan Zhao.

**中文翻译:**
还没见过 Ivan Zhao 的那一面。

---

### (00:42:18) Ivan Zhao

**English:**
Yeah, I wouldn't say I'm the most soft interaction person at work. It's actually the reverse is true because I grew up in China. People way more direct. People just say what they want, say what they think. And you move to California, you move to US, you move to the West, you felt wow, everybody says everything's wonderful, everything's nice, but that's not true. I would say Notion's ethos probably more like a East Coast rather than West Coast, so somewhere in between. It's more direct.

**中文翻译:**
是的，我不会说我在工作中是一个沟通很温和的人。事实上恰恰相反，因为我在中国长大，那里的人说话直接得多。人们想要什么就说什么，想什么就说什么。当你搬到加州，搬到美国，搬到西方，你会觉得：“哇，每个人都说一切都很棒，一切都很好。”但事实并非如此。我会说 Notion 的文化更像美国东海岸而不是西海岸，介于两者之间，更加直接。

---

### (00:42:51) Ivan Zhao

**English:**
What do you want to learn? A bunch of things. I think the early days is we talk about that the world's not like you. The world don't care about you so you have to shave off the idealistic part of you to go something that's like the world actually cares, the sugar coat of broccoli. You have to hide the broccoli within something, the sugar pills. So that's one. That's more self. That's more myself.

**中文翻译:**
要学什么？很多东西。早期我们聊过，世界并不像你，世界不在乎你，所以你必须削减掉自己理想主义的那部分，去做一些世界真正关心的东西，也就是“糖衣西兰花”。你必须把西兰花藏在糖衣药片里。这是其一，更多是关于自我修养。

---

### (00:43:20) Ivan Zhao

**English:**
As company grows, you realize... I'm pretty good at storytelling. So that's a one-to-one influence. But as a company grows, you realize you need to be one-to-many storytellers. That's a skill. The one reason I try not to do podcasts and all those things, oh, it's actually it drains energy in a different ways. I prefer just building product and brainstorm sessions. Then you realize it's a necessary craft for me to pick up in order to change the shape of the company, the business I'm building. I treat it like a craft. There's some things skill that's in the video game. You need to pick up something to unlock something else and to make new demand, you trade off with yourself and the business. That's fun though. Every 12, 18 month, Notion's like a new company or at least they require different skill set coming from me. So I need to pick up new things. And it's an infinite game and infinite games are more fun.

**中文翻译:**
随着公司成长，你会意识到……我很擅长讲故事，但那是“一对一”的影响。随着公司规模扩大，你需要成为“一对多”的讲故事者。这是一种技能。我尽量不参加播客之类的活动，原因之一是它会以不同的方式消耗能量。我更喜欢开发产品和头脑风暴。但后来你意识到，为了改变公司和你正在建立的业务的形态，这是我必须掌握的“工艺”。我把它看作一种工艺。就像电子游戏里的技能树，你需要习得某些技能来解锁其他东西，为了满足新需求，你在自我和业务之间进行权衡。但这很有趣。每隔 12 到 18 个月，Notion 就像一家新公司，或者至少需要我具备不同的技能组。所以我需要不断学习新东西。这是一个无限游戏，而无限游戏更有趣。

---

### (00:44:19) Lenny Rachitsky

**English:**
I love this idea. I love that you keep coming back to this idea of there's the ideals and the values and the vision and what you're trying to do, and then you have to find the way to frame it and package it so that people actually understand and want it. And that's how you get in.

**中文翻译:**
我喜欢这个想法。我喜欢你不断回到这个观点：你有理想、价值观和愿景，但你必须找到一种框架和包装方式，让人们真正理解并想要它。这就是你切入市场的方式。

---

### (00:44:35) Ivan Zhao

**English:**
Yeah. It's like human minds are resistant to change, and how do you land in people's head? Through my best word marketing and positioning are for. So you need to find the sweet spot to get in. And you also be truthful. It's not just deceiving. So deceiving is not truthful. You can fool other people once or twice, then there's no future. It has to be actually tied back to something genuinely the value creating or the exchange with the other person. So yeah, it's a craft. Storytelling is the vast dimension of making trade-offs.

**中文翻译:**
是的。人类的大脑天生抗拒改变，你如何进入人们的头脑？这就是营销和定位的作用。你需要找到那个切入的“甜点位”。同时你必须保持真实，而不仅仅是欺骗。欺骗不是长久之计，你可以骗别人一两次，但那样没有未来。它必须真正与价值创造或与他人的交换联系在一起。所以，这是一种工艺。讲故事是进行权衡的一个宏大维度。

---

### (00:45:15) Lenny Rachitsky

**English:**
I love this word, trade-offs. Comes up again and again too. It's so interesting that there's these threads that have come up again and again in our chat. Along that journey of becoming this leader that you've become, what would you say has maybe the biggest surprise or most unexpected part of the journey of something you've had to learn to do or something that didn't turn out the way you expected? Just as a personal growth story.

**中文翻译:**
我喜欢“权衡”（trade-offs）这个词。它在我们的对话中反复出现。在成为今天这样的领导者的过程中，你觉得最大的惊喜或最出乎意料的部分是什么？无论是你必须学会做的事，还是结果与预期完全不同的事？作为一个个人成长的故事来聊聊。

---

### (00:45:36) Ivan Zhao

**English:**
If you use the product in the past three years, you realize Notion product, you realize, "Hey, we actually ship bunch of things not so great." Two years ago. Actually last year, 2024, is the year that I can say we ship good stuff at good velocity and good quality and align with our values. We get lost there for a year, a year and a half shipping something not according to our value, not according to my value. Notion, we call Notion is Lego for software. We ship non-Lego pieces into our product. We're still there. We're still cleaning up part of it. That's a realization.

**中文翻译:**
如果你在过去三年里使用过 Notion，你会发现：“嘿，你们其实发布了一些不太好的东西。”那是两年前的事。实际上，直到去年（2024 年），我才敢说我们以良好的速度和质量发布了符合我们价值观的好东西。我们曾迷失了一年到一年半的时间，发布了一些不符合我们价值观、也不符合我个人价值观的东西。我们说 Notion 是软件界的乐高，但我们却在产品里塞进了一些“非乐高”的零件。我们现在还在清理那部分东西。这是一个深刻的感悟。

---

### (00:46:42) Ivan Zhao

**English:**
It's like going back to the value part, it's like if you create this thing called a product or business, you attract people are value aligned to it. Then if you're trying to optimize too much on this competition revenue side of things, forced to introducing something anti-your-value, then the system, it's like there's organ rejection with your employees, with your customers. I'll give you a concrete example. For a while and still is, project management is one of the most important use cases for Notion. And you can get a better project management tool just by hard coding things like sprints, milestones, all those things into your product, or you can do it in the way the Notion are being, through Lego pieces.

**中文翻译:**
回到价值观的部分：如果你创造了一个产品或业务，你会吸引那些价值观一致的人。如果你过于优化竞争和收入，被迫引入一些违背价值观的东西，系统就会产生“器官排异反应”——无论是员工还是客户都会排斥。我给你举个具体的例子。长期以来，项目管理一直是 Notion 最重要的用例之一。你可以通过“硬编码”诸如 Sprint（冲刺）、里程碑之类的功能来做一个更好的项目管理工具，或者你可以用 Notion 的方式——通过乐高积木来实现。

---

### (00:47:43) Ivan Zhao

**English:**
What are the sprint? Sprints are clusters of a task that group together. So it's a new Lego. So introducing Lego is much harder, slower. You can instead we hard-code a sprint concept into the product. And this doesn't quite fit. And took me at least a year, a year and a half to realize that's not the way we should continue building Notion. We should go back the original Lego way of building the product. So we changed quite a bit internally. Now, it feels good now. Building according to your values is the meta point, at least for me.

**中文翻译:**
什么是 Sprint？Sprint 是一组聚合在一起的任务。所以它应该是一个新的“乐高积木”。引入积木要难得多、慢得多。相反，我们当时直接在产品里硬编码了一个 Sprint 的概念。但这并不契合。我花了至少一年到一年半才意识到，这不是我们构建 Notion 的正确方式。我们应该回到原始的“乐高方式”来构建产品。所以我们在内部做了很大调整。现在感觉好多了。对我来说，核心点在于：要按照你的价值观去构建。

---

### (00:47:58) Lenny Rachitsky

**English:**
Okay, I got to follow this thread. What is it that you changed that allowed you to come back to your first principles? Was it like you step... Is it founder mode was the answer? Is it people, personnel shift? What allowed you to change the way things were going?

**中文翻译:**
好，我得追问一下。你做了什么改变让你回到了初心？是你介入了……答案是“创始人模式”吗？还是人员变动？是什么让你扭转了局势？

---

### (00:48:15) Ivan Zhao

**English:**
I would say all of that above, but especially just release the sprint product through our community and customers. Then it's like what is this? It's like underpowered compared to other competitor products to doing product management and it doesn't work well with the rest of Notion like I said. And if you talk with engineers, they'll say, "Okay, there's this part of Notion you have to touch the code base. That's just weird. That's your hardcore too much into it. From all the dimension technical front, calling a customer. And when you use the thing it just doesn't feel right."

**中文翻译:**
我想说以上皆有。但最关键的是，当我们向社区和客户发布那个 Sprint 产品后，反馈是：“这是什么？”它在做项目管理时不如竞争对手强大，而且正如我所说，它与 Notion 的其他部分配合得不好。如果你去问工程师，他们会说：“在 Notion 的这部分代码里，你必须动到底层硬编码。这太奇怪了，你介入得太深了。”从技术维度到客户反馈，当你使用它时，感觉就是不对劲。

---

### (00:48:52) Ivan Zhao

**English:**
So there's another saying that if you build in a Lego way inside Notion in the code base or product, the system work for you. If you're building non-Lego way, the system work against you. So in some sense, we're creating a tool that has emergent behavior, inter-channeling that emergent behavior to unlock more values.

**中文翻译:**
所以有另一种说法：如果你在 Notion 的代码或产品中以“乐高方式”构建，系统会为你助力；如果你以“非乐高方式”构建，系统会阻碍你。从某种意义上说，我们正在创造一个具有“涌现行为”（emergent behavior）的工具，通过引导这种涌现行为来解锁更多价值。

---

### (00:49:04) Lenny Rachitsky

**English:**
So I'm hearing as you launched it, it just didn't go well. Everyone's just like, "What is this? This isn't feeling good." And there's a moment of realization of I see. Here's what we did wrong here and we should come back to this original abstraction vision of what we're trying to build.

**中文翻译:**
所以我听到的是，产品发布后效果不好。大家都觉得：“这是什么？感觉不对。”然后你意识到：我明白了，我们在这里做错了，我们应该回到最初那个关于“抽象”的愿景。

---

### (00:49:11) Ivan Zhao

**English:**
That took nine months, a year to realize sometime.

**中文翻译:**
有时候这需要九个月甚至一年才能意识到。

---

### (00:49:11) Lenny Rachitsky

**English:**
Along those lines actually, people come on this podcast and they share all these stories of things are going awesome all the time. And this was a great example of it didn't. I'm curious if there's another story of let's say a crisis that you all went through when things were looking pretty bleak for Notion along the journey of building Notion.

**中文翻译:**
说到这，很多人来这个播客分享的故事总是一帆风顺。而你刚才提供了一个很好的反例。我很好奇，在构建 Notion 的过程中，是否还有其他危机时刻，让 Notion 的前景看起来非常暗淡？

---

### (00:49:31) Ivan Zhao

**English:**
Yeah, one of the bleakest one, it's when we... During COVID, we just couldn't scale up our infrastructure. For the longest time, Simon's really good at don't do premature optimization, so for the longest time, we Notion runs on one instance of Postgres database. And then we find the beefiest machine. We keep scrolling, find a beefier future machine to scale our user base, but then we're running off even the largest instance there is for Postgres. So there's a doomsday clock that when we're going to truly run out of this space to store everything in Notion and Notion got a complete shutdown. So we stopped building any new features, all hands on deck, almost every engineer in the company trying to solve that problem. Eventually we did, but it was a close call.

**中文翻译:**
是的，最暗淡的时刻之一是在疫情期间，我们的基础设施无法扩展。长期以来，Simon 非常擅长“不要过早优化”，所以 Notion 长期运行在单个 Postgres 数据库实例上。我们找了最强大的机器，不断升级到更强大的机器来承载用户增长，但最后我们连 Postgres 能提供的最大实例都快用完了。当时有一个“末日时钟”，预示着我们什么时候会彻底耗尽存储空间，导致 Notion 完全瘫痪。于是我们停止了所有新功能的开发，全员待命，公司几乎每个工程师都在试图解决这个问题。最终我们解决了，但那真的是千钧一发。

---

### (00:50:21) Lenny Rachitsky

**English:**
How close are we talking about?

**中文翻译:**
当时有多紧迫？

---

### (00:50:23) Ivan Zhao

**English:**
If I recall correctly, probably in weeks running out of the time. And then as you approach the limit of what Postgres can do, behavior becomes sporadic. You really don't know which day going to hit you. But we just need to go as fast as you can to become sharding problem.

**中文翻译:**
如果我没记错，可能只剩下几周时间了。当你接近 Postgres 的极限时，系统的行为会变得不可预测。你真的不知道哪天会崩溃。我们只能拼命赶进度去解决“分片”（sharding）问题。

---

### (00:50:39) Lenny Rachitsky

**English:**
Yeah, I was going to ask, so the solution is sharding the database?

**中文翻译:**
是的，我正想问，解决方案是数据库分片吗？

---

### (00:50:39) Ivan Zhao

**English:**
Yeah, sharding.

**中文翻译:**
是的，分片。

---

### (00:50:40) Lenny Rachitsky

**English:**
Okay, cool.

**中文翻译:**
好的，酷。

---

### (00:50:43) Ivan Zhao

**English:**
Don't do as late. Yes. Don't do premature optimization but plan ahead a little bit. Don't go late.

**中文翻译:**
别拖到那么晚。是的，不要过早优化，但要提前一点规划，别太迟。

---

### (00:50:49) Lenny Rachitsky

**English:**
How long did you have from when you launched this doomsday clock to time running out? Was that a few months?

**中文翻译:**
从你们开启这个“末日时钟”到时间耗尽，你们有多少时间？几个月吗？

---

### (00:50:54) Ivan Zhao

**English:**
Maybe a bit longer. Yeah, in the month, less than six but more than three, something like that.

**中文翻译:**
可能长一点。按月算的话，不到六个月，但超过三个月，大概那样。

---

### (00:50:59) Lenny Rachitsky

**English:**
The bittersweetness of COVID just ramping up certain businesses.

**中文翻译:**
疫情对某些业务的推动真是苦乐参半。

---

### (00:51:03) Ivan Zhao

**English:**
People just run like they have to use online productivity software, collaboration tools.

**中文翻译:**
人们疯狂涌入，不得不使用在线生产力软件和协作工具。

---

### (00:51:08) Lenny Rachitsky

**English:**
Yeah, blessing and a curse. Speaking of a blessing and curse, this is a great segue to where I wanted to go in the final area I want to spend time on which is building horizontal software and building software that bundles together a bunch of different stuff. Notoriously hard to build a horizontal platform that does a lot of things when there are often point solutions that are very, very good at that one thing. And it's interesting. If you look at the timelines of companies that have built horizontal products, they all take a long time to build and finally find product market fits. It's actually a really common pattern. And when we were talking about what would be fun to talk about, the way you described it is the joy and pain of building horizontal products. So let me just ask broadly just what have you learned about what it takes to successfully build a horizontal platform type of product?

**中文翻译:**
是的，既是福也是祸。说到这，这是一个很好的过渡，我想聊聊最后一个领域：构建“横向软件”（horizontal software）以及将各种功能捆绑在一起的软件。众所周知，构建一个能做很多事情的横向平台非常难，因为市场上总有专门针对某一个功能做得极好的“点解决方案”（point solutions）。有趣的是，如果你观察那些构建横向产品的公司，它们通常都要花很长时间才能找到 PMF。这其实是一个很普遍的模式。我们之前讨论话题时，你把它描述为“构建横向产品的快乐与痛苦”。那么我想泛泛地问一下：关于如何成功构建横向平台型产品，你学到了什么？

---

### (00:51:56) Ivan Zhao

**English:**
First of all, no regret. And second, I wouldn't want to build anything else because going back to the value, Lego for software doesn't exist and Lego is a horizontal thing. So that's the thing we want to build. We always want to do that. So we did not start to optimize for business but we're optimized for that vision.

**中文翻译:**
首先，我不后悔。其次，我不想做别的任何东西，因为回到价值观：软件界的乐高还不存在，而乐高天生就是横向的。这就是我们想做的。我们一直想做这个。所以我们最初不是为了优化业务，而是为了优化那个愿景。

---

### (00:52:19) Ivan Zhao

**English:**
Learning-wise, I think segmentation is quite important because people can use a Lego for different things. Only hardcore Lego fans care about Lego bricks. Most people care about Lego boxes. And they actually want the Lego box to be ready-made. When you unpack the box, the set is there for you, right? That's what we're learning a lot, especially move up market. There's this term that took me a while to learn. It's called solutions. You need to be a solution for enterprise customer, you need to sit somewhere on a P&L to optimize for their business where due third risk. That's Lego box. It's not a Lego brick. Segmentation related to that. So you need to shift your mindset as you more towards B2B, more towards move out market. I wish we have done earlier. For the longest time, I've stalled too much in the Lego brick mindset, now in the solution Lego box mindset.

**中文翻译:**
在学习方面，我认为“细分”（segmentation）非常重要，因为人们可以用乐高做不同的事。只有核心乐高迷才关心“乐高积木”（Lego bricks），大多数人关心的是“乐高套装盒”（Lego boxes）。他们其实想要的是现成的套装，拆开盒子，整套模型就在那儿，对吧？这是我们学到的很多东西，尤其是向高端市场进军时。有一个词我花了好久才学会，叫“解决方案”（solutions）。你需要成为企业客户的解决方案，你需要出现在他们的损益表（P&L）里，为他们优化业务或降低风险。那是“乐高盒”，不是“乐高积木”。细分与此相关。所以当你转向 B2B、转向高端市场时，你需要转变思维。我希望我们能早点这么做。长期以来，我太沉溺于“积木思维”了，现在才转向“套装盒思维”。

---

### (00:53:29) Lenny Rachitsky

**English:**
That's such a good metaphor. I feel like even if you're not building Legos for business, just this idea of what is the box that you are selling to people, how's it being positioned? How do you picture it? What are the value? Props such a good metaphor.

**中文翻译:**
这个比喻太棒了。我觉得即使不是在为企业做“乐高”，这种“你卖给人们的盒子是什么”、“它是如何定位的”、“你如何构思它”、“它的价值主张是什么”的想法，也是一个极好的隐喻。

---

### (00:53:29) Ivan Zhao

**English:**
If you're building vertical software and naturally your vertical is the box, right? So you know you have 1 or 2% of your selling to. Pretty straightforward that your market constrains you and no judgment. People like you, you can go that way, but then you just hit the wall off the market. The advantage of building horizontal, there's no wall, at least for in our space. We, Notion, go after entire software market, but then you need to create a wall yourself. To make your go-to-market distribution, to create the spot in people's mind, your customer's mind more clearly for them and for your go-to-market teams. That's why where solutions is one of my favorite word internally to rally the sales team or the product team. You think that way, but then you need to hold in your head, make sure you're still building bricks behind the scene. Otherwise, you pigeonhole yourself into the best spot, like what we did with project management sprints features.

**中文翻译:**
如果你在做垂直软件，你的垂直领域自然就是那个“盒子”，对吧？你知道你卖给谁。很直接，市场约束了你，这没问题。如果你喜欢，可以走那条路，但你会撞上市场的天花板。构建横向产品的优势是没有天花板，至少在我们的领域是这样。Notion 追求的是整个软件市场。但这样一来，你需要自己“造墙”——为了你的进入市场（GTM）分发，为了在客户心中创造一个清晰的位置。这就是为什么“解决方案”是我在内部最喜欢用来激励销售或产品团队的词。你需要这样思考，但同时脑子里要清楚，你依然在幕后构建“积木”。否则，你会把自己困死在某个局部，就像我们之前在项目管理 Sprint 功能上犯的错一样。

---

### (00:54:25) Lenny Rachitsky

**English:**
So speaking of that, so I don't know if you know this. I ran a survey recently where I asked my readers what tools they use most, what tools they love most. And it went out to my entire subscriber base. We've got 6,500 people filling out the survey. And Notion more than any other company placed very highly in many categories. For example, I have the notes here, it was the second most popular project management tool after Jira. It was the fourth most popular docs. Which is interesting because you think Notion would... Notion is known for docs and it's interesting, that was the lowest one actually. And then it was third in CRM, just behind Salesforce and HubSpot.

**中文翻译:**
说到这，我不知道你知不知道，我最近做了一个调查，问我的读者他们最常用、最喜欢的工具是什么。调查发给了我所有的订阅者，有 6500 人参与。Notion 在多个类别中都名列前茅，超过了其他任何公司。例如，我这里的笔记显示：它是仅次于 Jira 的第二受欢迎的项目管理工具；它是第四受欢迎的文档工具（这很有趣，因为大家通常认为 Notion 以文档著称，结果文档反而是排名最低的一项）；它在 CRM 领域排名第三，仅次于 Salesforce 和 HubSpot。

---

### (00:55:02) Ivan Zhao

**English:**
Yeah, we did not intend to build CRM, but what is a CRM is relational database. That's why we give people that brick. That's a relational database and they can build CRM themselves. I think the good advantage is if a customer use Notion, they can address those three, four use cases in one place. Especially for our startup mid-market companies, their need for each of the vertical use case is not as complex so they can have all the information in one place, good for their teams, good for AI actually. That's a huge market change that's like we did not expect until recently. And save their costs, which is more and more people care about the bundling purchase nowadays. And our approach for that is, yes, we're number two in project management, number what? Number four in CRM, but we're interested in more bricks to make us number... Move up the categories in ranking. So it just takes time, but that's our approach.

**中文翻译:**
是的，我们并没打算做 CRM，但 CRM 的本质就是关系型数据库。这就是我们给人们提供的“积木”——关系型数据库，他们可以自己搭建 CRM。我认为巨大的优势在于，如果客户使用 Notion，他们可以在一个地方解决三四个用例。特别是对于初创公司和中型市场公司，他们对每个垂直领域的需求没那么复杂，所以把所有信息放在一个地方对团队有好处，对 AI 也有好处。这是一个巨大的市场变化，我们直到最近才预料到。而且这能节省成本，现在越来越多的人关心“捆绑购买”。我们的策略是：是的，我们在项目管理排第二，CRM 排第四，但我们有兴趣提供更多积木，让我们在这些类别中排名更靠前。这需要时间，但这就是我们的方法。

---

### (00:56:05) Lenny Rachitsky

**English:**
Yeah. Well, it's working whatever you're doing there. So say someone is trying to build a horizontal tool like yours. There's a lot of founders that are trying to build something that can do a lot of things really well. Do you have any advice for that first use case? Just figuring out something that initially works like you're talking about segmentation, is there something there of like, "Do this if you want to find any success with a horizontal tool"?

**中文翻译:**
是的，无论你们在做什么，它确实奏效了。假设有人想做一个像你们这样的横向工具——有很多创始人想做一个能把很多事都做好的东西。对于寻找“第一个用例”，你有什么建议吗？就像你说的细分，有没有什么“如果你想在横向工具上取得成功，就必须这样做”的建议？

---

### (00:56:28) Ivan Zhao

**English:**
First, I wouldn't recommend it.

**中文翻译:**
首先，我不推荐这样做。

---

### (00:56:30) Lenny Rachitsky

**English:**
But you wouldn't do it differently?

**中文翻译:**
但你不会换一种做法？

---

### (00:56:32) Ivan Zhao

**English:**
I wouldn't do it differently myself, but I wouldn't recommend it. It's a problem. The problem space too large to have best practice, but I can share something that's relevant for us. Notion, we always want to build a meta tool, a tool to build the lack of our software. We somehow stand up upon document notes as one use case. And that just gave us a large top of the funnel that there's a 1 billion plus people use this use case every day. So that fuels our growth. We call our internal strategy called B2C2B. All those consumers, personal user use Notion for the most simple way you can use a computer or your phone, which is note-taking or document-sharing. And then they realize, "Oh, Notion can do more of that." There's relational database power, you can do tasks, you can manage track other things. Then they bring Notion to work.

**中文翻译:**
我自己不会换一种做法，但我不会推荐别人这么做。这是一个难题，问题空间太大，很难有“最佳实践”。但我可以分享一些对我们有用的经验。Notion 始终想做一个元工具，一个弥补软件缺失的工具。我们无意中撞上了“文档笔记”这个用例。这为我们提供了一个巨大的漏斗顶端，每天有超过 10 亿人在使用这个功能。这推动了我们的增长。我们内部称这种策略为 B2C2B。所有这些个人用户使用 Notion 来完成最简单的电脑或手机操作——记笔记或分享文档。然后他们意识到：“噢，Notion 还能做更多。”它有关系型数据库的能力，可以做任务管理，可以追踪其他事情。然后他们就把 Notion 带到了工作中。

---

### (00:57:24) Ivan Zhao

**English:**
Half our B2B customers coming from prior personal users, and most of them are using Notion for notes and talk in the first place. So pick. Well, at least we stumble upon a use case, a horizontal use case to give us a large top of funnel that help us grow our more verticalized enterprise use cases, and that's the reason where we ship a calendar product last year because which other category of software has 1 billion plus users? There's document notes, there's calendar, there's email, right? That's why we're also working on the email product right now.

**中文翻译:**
我们一半的 B2B 客户来自之前的个人用户，而他们最初大多是用 Notion 来记笔记和写文档。所以，选一个吧。至少我们偶然发现了一个横向用例，它给了我们巨大的流量入口，帮助我们发展更垂直的企业级用例。这也是为什么我们去年发布了日历产品，因为还有哪些软件类别拥有超过 10 亿用户？文档笔记、日历、邮件，对吧？这就是为什么我们现在也在研发邮件产品。

---

### (00:58:01) Lenny Rachitsky

**English:**
Yeah, man. Watch out, everyone. And then you mentioned AI and it's such a good point that AI is best when it has data. And the fact that you have all of this stuff already in there gives you a lot of really interesting opportunities to leverage AI.

**中文翻译:**
天哪，大家都要小心了（Notion 要进军所有领域了）。你提到了 AI，这一点说得太好了：AI 在拥有数据时表现最好。而你们已经拥有了所有这些数据，这为你们利用 AI 提供了很多非常有趣的机会。

---

### (00:58:17) Ivan Zhao

**English:**
We definitely did not expect language model. It's such a gift for everybody building tools, right? Complete change the material you can work with. One realization, it's you have a surface area that people spend daily work with, especially during writing and managing your tasks and project. It's really easy to slice the language model writing AI capability into it. So that's the first part we built. That realization is AI is so good at reasoning and understanding and searching things, and we can do a much better job of finding and searching things if all the information are together. That's what we realized. AI is really good with bundled offerings. AI is really good with horizontal tools. So that's the second phase, we call it. The first product was our AI writer product. Second product is AI Q&A or connectors. Please look at all the information in Notion and give your answer.

**中文翻译:**
我们确实没预料到大语言模型的出现。对于所有构建工具的人来说，这简直是一份大礼，对吧？它彻底改变了你可以使用的“材料”。一个感悟是：你拥有一个人们日常工作的界面，特别是在写作、管理任务和项目时。将语言模型的写作 AI 能力切入其中非常容易。所以这是我们构建的第一部分。另一个感悟是：AI 非常擅长推理、理解和搜索，如果所有信息都在一起，我们可以做得更好。这就是我们意识到的：AI 非常适合“捆绑式”产品，AI 非常适合横向工具。所以这是第二阶段。第一个产品是我们的 AI 写作产品，第二个产品是 AI 问答或连接器——请查看 Notion 中的所有信息并给出答案。

---

### (00:59:18) Ivan Zhao

**English:**
And then we also need to work with the external connector because there's things that are living in Jira, living in Zendesk that other customers still rely on. So we need to build AI connectors. But more and more information coming back to the Notion core. I would say the third one, which is even more fascinating, it's for the longest time and it's still is one of the biggest weaknesses of building for Legos, it's hard to piece together. It's not everybody can put together a Lego set from scratch. There's always the builders and user with the Legos. But guess who is really good at piecing things together, assemble things? Especially things like since Sona 3.5. AI is so bad at writing code. Coding is just assembling things together. So now we're looking at holy shit, we spent the last five, six year building all those Lego blocks for knowledge work. If we're just putting AI coding agent on top of it, you can create any kind of knowledge, customer software, customer agent for whatever your vertical use cases you need. So that's the most fascinating approach for me, and we did not expect this at all.

**中文翻译:**
然后我们还需要处理外部连接器，因为有些信息存在于 Jira 或 Zendesk 中，客户依然依赖这些工具。所以我们需要构建 AI 连接器。但越来越多的信息正在回到 Notion 核心。我想说第三点，也是最迷人的一点：长期以来（现在依然是），“乐高式构建”最大的弱点之一就是难以拼装。不是每个人都能从零开始拼好一套乐高。乐高世界里总是有“构建者”和“使用者”。但猜猜谁最擅长拼装和组装东西？特别是自 Claude 3.5 以来（此处 Ivan 可能口误说成 Sona，应指 Claude 或类似模型），AI 极其擅长写代码。编程本质上就是把东西组装在一起。所以现在我们心想：“天哪，我们在过去五六年里为知识工作构建了所有这些乐高积木。如果我们把 AI 编程智能体放在上面，你就可以为任何垂直用例创建任何类型的知识软件或自定义智能体。”这对我来说是最迷人的路径，我们完全没预料到这一点。

---

### (01:00:33) Lenny Rachitsky

**English:**
Thank you, AI. Is there anything else along the lines of building horizontal products and bundling that you think is interesting to share or important? Otherwise, I have one last question I want to ask you.

**中文翻译:**
感谢 AI。关于构建横向产品和捆绑，你还有什么觉得有趣或重要的事情想分享吗？如果没有，我还有最后一个问题。

---

### (01:00:43) Ivan Zhao

**English:**
I think market is like waves. There's... Who said this? There's two-way to build business, bundling and bundling, right? There's too much of a zig and the zag. Actually, my favorite version of this is there's a classic Chinese literature called Romance of Three Kingdoms. It's great novel. It talked about the three kingdom era of China and the opening sentence of this novel, it's, "Empires long united must divide, long divided must unite." That has always been bundling, unbundling. It's one of my favorite book to read when I was a kid, but business works same way. When there's too much, you can see this.

**中文翻译:**
我认为市场就像波浪。有人说过，做生意只有两种方式：捆绑和解绑（bundling and unbundling），对吧？市场总是在这两者之间摇摆。实际上，我最喜欢的版本来自中国古典文学《三国演义》。这是一部伟大的小说，讲的是中国的三国时代。小说的开篇第一句是：“天下大势，合久必分，分久必合。”这其实就是捆绑与解绑。这是我小时候最喜欢读的书之一，而商业运作的方式也是如此。

---

### (01:01:29) Ivan Zhao

**English:**
It's like before computers, everything works on paper. Our knowledge work are done through papers is fully democratized medium. Then PC happens during the '80s. The first era is a piece there actually are so many applications. There's early database software, dBASE, it's quite famous. It started dBASE 2 because it gives them credibility. Oh, they have been stick around for some time. So that's the first unbundling phase of software computing. Then Microsoft bundled everything back into one suite in the '90s. Then the SaaS unbundled it. Now, we're at the tail end of SaaS. There's so many verticalized SaaS average company to use almost a hundred tools. It's madness. So there's more the market shifting towards more a bundling approach. And with AI and with the macro, so there's more value to be created through bundling, at least for now. The market could shift again. So understand this trend, I think, helpful to see should you build a vertical solution or should you build horizontal solution because it does different things.

**中文翻译:**
就像在计算机出现之前，一切都靠纸张。我们的知识工作是通过纸张完成的，那是一个完全民主化的媒介。然后 80 年代出现了 PC。第一个时代出现了非常多的应用程序。比如早期的数据库软件 dBASE，它很有名，它从 dBASE 2 开始命名，为了让人觉得它已经存在很久了。那是软件计算的第一个“解绑”阶段。然后微软在 90 年代把一切都捆绑进了一个套件。接着 SaaS 又把它解绑了。现在，我们处于 SaaS 的末尾。有太多的垂直化 SaaS，平均每家公司要用近百个工具，这简直是疯了。所以市场正在转向“捆绑”模式。结合 AI 和宏观环境，目前通过捆绑可以创造更多价值。市场以后可能还会再次转变。理解这个趋势有助于你决定是该构建垂直解决方案还是横向解决方案，因为它们的作用不同。

---

### (01:02:40) Lenny Rachitsky

**English:**
I love that story. Okay, so last question. Something that one of your early investors, Finn Barnes, suggested to ask you. I'm curious where this goes. There's this, and you've touched on this a number of times, just the way you think about Notion, it's almost like a philosophy of how to work and be versus just a productivity tool. And so I'm just curious how you think about the relationship between tools and human potential and humans and how we live in the world.

**中文翻译:**
我喜欢这个故事。好，最后一个问题。这是你的一位早期投资者 Finn Barnes 建议我问你的。我很想知道你会怎么回答。你已经多次提到过，你思考 Notion 的方式几乎像是一种关于如何工作和生存的哲学，而不仅仅是一个生产力工具。所以我很好奇你是如何看待工具与人类潜能、以及人类在世界上的生存方式之间的关系的。

---

### (01:03:08) Ivan Zhao

**English:**
The tools are extensions of us. That's why our office room named as timeless tools. They extend us a little bit. And once they extend us, once we shape them, once we bring them to world, they can come back to shape us. One of my favorite quotes like the Marshall MacLean quotes, "We shape our tools. Then after, our tools shape us." I think that's probably too philosophical for building product or business, but there is a sense thinking what are you bringing to the world that will come back to bite you or shape you? And are you extending the part, the so-called good part of human nature, or are you extending the part that might be more zero-sum, might be more negative, right?

**中文翻译:**
工具是我们的延伸。这就是为什么我们的办公室用“永恒的工具”命名。它们在某种程度上延伸了我们。一旦它们延伸了我们，一旦我们塑造了它们并将其带入世界，它们反过来也会塑造我们。我最喜欢的名言之一是马歇尔·麦克卢汉（Marshall McLuhan）说的：“我们塑造了工具，此后工具又塑造了我们。”我觉得这对于打造产品或业务来说可能太哲学了，但你确实需要思考：你带给世界的东西，最终会如何反作用于你或塑造你？你是在延伸人性中所谓“好”的部分，还是在延伸那些更趋向于零和博弈、更负面的部分？

---

### (01:04:05) Ivan Zhao

**English:**
For me, what is Legos? Lego is creativity. Lego is beauty. Software to me feels like lacking both. It's definitely lacking a lot of creativity. It's so rigid. So I believe both are human nature that worth amplifying. You can build another business that amplifies a different part of human nature. There was Sequoia famously invests in seven sins or seven human natures of human because they're so powerful if you just latch onto them, you can create a business, you can create a product. But at least I prefer to amplify creativity and beauty in the domain of software. To me, that's aligned with my values and I think can at least shape the market, shape our user of our product towards the better part of themself.

**中文翻译:**
对我来说，乐高是什么？乐高是创造力，乐高是美。在我看来，软件似乎两者都缺。它绝对缺乏创造力，它太僵化了。所以我相信创造力和美都是值得放大的天性。你可以建立另一种业务来放大人类天性的其他部分。红杉资本曾有名言说他们投资于“七宗罪”或人类的七种天性，因为如果你能抓住它们，它们非常强大，你可以借此创建业务或产品。但至少我更愿意在软件领域放大创造力和美。对我来说，这符合我的价值观，而且我认为这至少能引导市场、引导我们的产品用户走向他们更好的一面。

---

### (01:04:58) Lenny Rachitsky

**English:**
It must feel so good to have a product that is so aligned with the way you want to see the world and actually working and growing at this rate and scaling and becoming this, I don't know, part of the ether of the world.

**中文翻译:**
拥有一款与你世界观如此契合的产品，并且它还在以这种速度增长、扩张，并成为世界的一部分，这种感觉一定很棒。

---

### (01:05:11) Ivan Zhao

**English:**
It feels good. Yeah, it feels good that some of the most heartwarming thing is still it never gets old when you walk by coffee shop and see people using Notion. Oh, it feels good. And it feels good that we see people in our community can create a living selling Notion template, Notion apps, that they're not a software engineer. And going back to the original mission of when people create software, I think that's one of the most fulfilling thing, at least as a maker of tools can experience.

**中文翻译:**
感觉很好。是的，最暖心的事情之一是，当你走过咖啡馆看到人们在使用 Notion 时，那种感觉永远不会过时。噢，感觉太棒了。而且看到我们社区里的人，即使不是软件工程师，也能通过销售 Notion 模板、Notion 应用来维持生计，这感觉也很好。回到“让人人都能创造软件”的最初使命，我认为这是作为工具制造者所能体验到的最有成就感的事情之一。

---

### (01:05:39) Lenny Rachitsky

**English:**
That last point, I think people don't realize, so people are making millions of dollars selling Notion templates on the internet like at Etsy and other places.

**中文翻译:**
最后一点，我想很多人没意识到，有人在 Etsy 或其他地方卖 Notion 模板，赚了数百万美元。

---

### (01:05:48) Ivan Zhao

**English:**
Consulting templates, yeah, and they're not programmers. I think I would say that's the heart of that because their domain expertise, they're YouTubers or creators. They have lifestyle brand. They know certain things but they're not makers of software. Then they can use Notion, package their workflows and expertise into Notion and templates and make limit with it. It's awesome, all that.

**中文翻译:**
咨询模板，没错，而且他们不是程序员。我认为这是核心所在，因为他们有自己的领域专长，他们是 YouTuber 或创作者，有自己的生活方式品牌。他们懂某些专业知识，但不是软件制造者。然后他们可以使用 Notion，将他们的工作流和专业知识打包成 Notion 模板并以此谋生。这一切都太棒了。

---

### (01:06:13) Lenny Rachitsky

**English:**
Ivan, before we get to an abridged lightning round, I'm curious if there's anything else that you wanted to touch on think might be useful for folks to hear before we get to a very exciting lightning round.

**中文翻译:**
Ivan，在进入简短的闪电轮环节之前，你还有什么想补充的、觉得对大家有用的内容吗？

---

### (01:06:27) Ivan Zhao

**English:**
I think people in tech, I wish more people look beyond tech to steal good ideas. It's like Tech Hacker News Twitter are so focused on the now and what's in front of it, what happened six months ago, versus humanity. If you just read books in other industry, you can look sideways. If you go back to history, there's a massive amount of patterns and shapes and trade-offs you can steal from and you can make what's in front of you much more interesting. You could give you... People figure out clever patterns in whatever domain in the past. You can just take in front of you. And I wish more people do that. I think it would be a very interesting way for product makers, business maker to solve the problem in front of them by stealing outside of from the domain of tech and business. So at least it's very inspiring, very useful for me personally.

**中文翻译:**
我觉得在科技圈，我希望更多人能跳出科技领域去“偷”好主意。现在的 Tech Hacker News 或 Twitter 太关注当下、关注眼前、关注六个月前发生的事，而不是关注人性。如果你读读其他行业的书，你可以横向观察。如果你回到历史，那里有海量的模式、形态和权衡可以借鉴，这能让你眼前的工作变得更有趣。过去人们在各个领域都想出了聪明的模式，你可以直接拿来用。我希望更多人这样做。我认为对于产品创造者和业务经营者来说，通过从科技和商业领域之外“偷师”来解决眼前的问题，是一种非常有趣的方式。至少对我个人来说，这非常有启发且有用。

---

### (01:07:26) Lenny Rachitsky

**English:**
It makes me think of the quote, "Good artist copy. Great artists steal."

**中文翻译:**
这让我想起那句话：“平庸的艺术家模仿，伟大的艺术家偷取。”

---

### (01:07:30) Ivan Zhao

**English:**
Great artists steal, yeah. Well, Steve Jobs stole that from Picasso or something who stole from former artist probably.

**中文翻译:**
伟大的艺术家偷取，没错。乔布斯是从毕加索那儿偷的这句话，而毕加索大概也是从之前的艺术家那儿偷的。

---

### (01:07:37) Lenny Rachitsky

**English:**
Well, this is actually an amazing segue to our very abridged lightning round. And the first question is... And by the way, welcome to the lightning round.

**中文翻译:**
这真是一个完美的过渡，进入我们非常简短的闪电轮环节。第一个问题是……顺便说一下，欢迎来到闪电轮。

---

### (01:07:43) Ivan Zhao

**English:**
Oh, okay.

**中文翻译:**
噢，好的。

---

### (01:07:45) Lenny Rachitsky

**English:**
The first question is just what are a couple of books that you find yourself recommending most to other people? Could be along the lines of what you just described or could just be generally.

**中文翻译:**
第一个问题是，有哪些书是你最常向别人推荐的？可以是关于你刚才描述的那些，也可以是泛指。

---

### (01:07:53) Ivan Zhao

**English:**
I think the domain that are interesting the most is the complex system domain. You can look up the term. I think more and more people talk about this, but thinking a system, complex system when all the different things merge together, it creates emergent properties. Talking about ants, talk about beads, talk about life itself. It's just so fascinating how do with few primitives, few Lego bricks, you can create a thing called life. That thing just, it's sugar for me. So I love reading in that domain. And this is really helpful for create product, at least a horizontal product because you're trying to channel the energy, smaller parts to create something that the sum is much larger than its parts.

**中文翻译:**
我认为最有趣的领域是“复杂系统”（complex system）。你可以查一下这个词。我觉得越来越多的人在讨论这个。思考一个系统，当所有不同的事物融合在一起时，它会产生“涌现属性”。比如研究蚂蚁、研究珠子、研究生命本身。仅仅通过几个原语、几块乐高积木，就能创造出名为“生命”的东西，这太迷人了。这对我来说就像糖一样诱人。所以我喜欢读这个领域的书。这对于创造产品，尤其是横向产品非常有帮助，因为你是在试图引导能量，用小的部件创造出整体大于部分之和的东西。

---

### (01:08:43) Lenny Rachitsky

**English:**
Is there a specific book that comes to mind or is it just generally that's a cool area?

**中文翻译:**
有没有哪本具体的书？还是只是泛指这个领域？

---

### (01:08:48) Ivan Zhao

**English:**
That's a cool area to your attention to.

**中文翻译:**
这是一个值得关注的酷领域。

---

### (01:08:50) Lenny Rachitsky

**English:**
Next question. Do you have a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
下一个问题。你最近有没有特别喜欢的电影或电视剧？

---

### (01:08:55) Ivan Zhao

**English:**
I like to watch old documentaries. Maybe this is another area or category too. There's quite a few on YouTube. People make really good documentary in the '80s, in the '70s. That's like all the old BBC ones, they're just excellent and they have a strong opinion in them. It's no longer just general education thing. They have a direction. They have a taste. Go look it up. Oh, yeah. One is a really good one to get started called Connections. I think it's called but the gentleman's name is Burke. It's about how different things from different domains inspire other domains, and usually he used 30 minutes or 60 minutes to chain together a bunch of connection of stories. It's really good for technologists to watch. Highly recommend.

**中文翻译:**
我喜欢看老的纪录片。这可能是另一个值得关注的类别。YouTube 上有很多。人们在 70、80 年代拍了非常棒的纪录片，比如那些老的 BBC 纪录片，非常精彩，而且带有强烈的观点。它们不只是通识教育，它们有方向、有品味。你可以去查查。有一部非常适合入门的叫《关联》（Connections），主讲人叫詹姆斯·伯克（James Burke）。它讲述了不同领域的不同事物如何启发了其他领域，他通常用 30 或 60 分钟把一连串关联的故事串在一起。非常适合技术人员观看，强烈推荐。

---

### (01:09:49) Lenny Rachitsky

**English:**
I feel a very consistent pattern throughout all of these answers and your entire conversation of just emerging properties, connections, Legos, building abstractions.

**中文翻译:**
我发现你所有的回答和我们整个对话中都有一个非常一致的模式：涌现属性、关联、乐高、构建抽象。

---

### (01:10:00) Ivan Zhao

**English:**
Yeah, I think I did Enneagram. My Enneagram, it's 7 and 7. 7 is, it is actually perfect with what we just talking about. 7 is creative, finding connection, see the forest and tree. 8 is they call Challenger. It's like competitive AR optimizing. So true energy accessing me.

**中文翻译:**
是的，我测过九型人格（Enneagram）。我是 7 号和 8 号。7 号（活跃型/享乐型）非常符合我们刚才聊的内容：有创意、寻找关联、既见森林也见树木。8 号（领袖型/挑战者）则是好胜、优化、追求结果。这两种能量在我身上共存。

---

### (01:10:23) Lenny Rachitsky

**English:**
Oh, wow. It's all makes sense. I got to take this Enneagram. This comes up a bunch on this podcast.

**中文翻译:**
噢，哇。这下全对上了。我也得去测测这个九型人格，这个词在播客里出现好多次了。

---

### (01:10:27) Ivan Zhao

**English:**
Right, yeah.

**中文翻译:**
没错，是的。

---

### (01:10:29) Lenny Rachitsky

**English:**
Final question. Do you have a life motto that you often think back to, that you often repeat in your head of just like when times are hard or just to keep going with something you're working on that you find useful?

**中文翻译:**
最后一个问题。你有没有什么人生格言？在困难时期或需要坚持下去时，你会经常在脑海中重复的那种？

---

### (01:10:41) Ivan Zhao

**English:**
I like to think things as a craft. You just make it better. Make for yourself. If it's unique enough for yourself and useful for others, things will follow.

**中文翻译:**
我喜欢把事情看作一种“工艺”。你只是在把它做得更好。为你自己而做。如果它对你来说足够独特，且对他人有用，其他的东西自然会随之而来。

---

### (01:10:51) Lenny Rachitsky

**English:**
Ivan, thank you so much for being here. Two final questions, working folks find you online if they want to follow-up on anything, and then how can listeners be useful to you?

**中文翻译:**
Ivan，非常感谢你能来。最后两个问题：如果大家想关注你，在哪里可以找到你？以及，听众们能为你做些什么？

---

### (01:11:00) Ivan Zhao

**English:**
Probably find on me on Twitter, Ivan Z-H-A-O. It's helpful give us feedback about Notion, about our product. That's the best help.

**中文翻译:**
可以在 Twitter 上找我，账号是 Ivan Z-H-A-O。给我们提供关于 Notion 和产品的反馈就是对我们最大的帮助。

---

### (01:11:12) Lenny Rachitsky

**English:**
What's the best way to do that? Is it like DM, Ivan, or is it-

**中文翻译:**
最好的方式是什么？直接私信（DM）你吗？

---

### (01:11:14) Ivan Zhao

**English:**
Yeah, just DM me.

**中文翻译:**
是的，直接私信我就行。

---

### (01:11:15) Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好的。

---

### (01:11:15) Ivan Zhao

**English:**
DM me. Yeah, that's probably the best way.

**中文翻译:**
私信我，这可能是最好的方式。

---

### (01:11:19) Lenny Rachitsky

**English:**
Okay. Oh boy, here you go. And then you guys are hiring. Anything specific you're looking for? Anything people should know if they're like, "Oh shit, I want to go work here"?

**中文翻译:**
好的，大家听到了。另外你们正在招聘，有什么特定的人才需求吗？如果有人想去你们那儿工作，有什么需要知道的？

---

### (01:11:29) Ivan Zhao

**English:**
We're trying to hire misfits. So if you think you're a misfit, if you're exceptional at many things especially, you want to build Lego for software, you want to take interesting spin on AI with Lego for software, then DM me.

**中文翻译:**
我们想招募那些“不合群的奇才”（misfits）。如果你觉得自己是个不合群的人，如果你在很多方面都非常卓越，特别是如果你想构建软件界的乐高，想用乐高思维在 AI 领域玩出新花样，那就私信我。

---

### (01:11:45) Lenny Rachitsky

**English:**
Amazing. Ivan, thank you so much for being here.

**中文翻译:**
太棒了。Ivan，非常感谢你能来。

---

### (01:11:47) Ivan Zhao

**English:**
Thank you for having me.

**中文翻译:**
谢谢你的邀请。

---

### (01:11:49) Lenny Rachitsky

**English:**
Bye, everyone.

**中文翻译:**
再见，各位。

---

### (01:11:50) Ivan Zhao

**English:**
Bye.

**中文翻译:**
再见。

---

### (01:11:53) Lenny Rachitsky

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app... (Outro continues)

**中文翻译:**
非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅……（片尾语略）