# Jag Duggal - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Jag Duggal, Chief Product Officer at NuBank.

---

### (00:00:00) Lenny Rachitsky

**English:**
NuBank is bigger than Coinbase, Robinhood, Affirm, SoFi, and Lemonade combined. 80% to 90% of NuBank's growth is through word of mouth.

**中文翻译:**
NuBank 的规模比 Coinbase、Robinhood、Affirm、SoFi 和 Lemonade 加起来还要大。NuBank 80% 到 90% 的增长都是通过口碑传播实现的。

---

### (00:00:10) Jag Duggal

**English:**
We're not trying to be incrementally better, we are trying to be fundamentally different. We want our customers to love us fanatically.

**中文翻译:**
我们不只是想做得比别人好一点点，我们追求的是本质上的不同。我们希望客户能疯狂地爱上我们。

---

### (00:00:18) Lenny Rachitsky

**English:**
It feels like NuBank is one of the historically most successful companies that launching new business lines.

**中文翻译:**
感觉 NuBank 是历史上在推出新业务线方面最成功的公司之一。

---

### (00:00:22) Jag Duggal

**English:**
We built a lending product, we built an investment product, we built an insurance product, we built a series of small business products. We rarely scale a project until we know the Sean Ellis score hit a threshold that we find really compelling.

**中文翻译:**
我们构建了贷款产品、投资产品、保险产品，以及一系列针对小微企业的产品。在确定“肖恩·埃利斯得分”（Sean Ellis score，衡量产品市场契合度的指标）达到我们认为非常有说服力的阈值之前，我们很少会大规模推广一个项目。

---

### (00:00:35) Lenny Rachitsky

**English:**
I want to talk about strategy.

**中文翻译:**
我想聊聊战略。

---

### (00:00:36) Jag Duggal

**English:**
Kevin Systrom in the early days of Instagram, I heard him say it at a conference. We may not be right, but at least we are clear. Even if your strategy isn't right, you have a very clear idea of what was supposed to be happening.

**中文翻译:**
Instagram 早期的创始人凯文·斯特罗姆（Kevin Systrom），我曾在一次会议上听他说过：我们可能并不正确，但至少我们很清晰。即使你的战略不完全正确，你也会对应该发生的事情有一个非常清晰的认知。

---

### (00:00:49) Lenny Rachitsky

**English:**
Where do you think all this goes in the future?

**中文翻译:**
你认为这一切在未来会走向何方？

---

### (00:00:51) Jag Duggal

**English:**
Why not have the company that reinvents banking come out of Sao Paulo, Mexico City, Bogota?

**中文翻译:**
为什么重新定义银行业的公司不能诞生在圣保罗、墨西哥城或波哥大呢？

---

### (00:01:01) Lenny Rachitsky

**English:**
Today my guest is Jag Duggal. Jag is chief product Officer at NuBank, which is one of the most under-the-radar monster businesses that you'll ever come across with a fanatical user base, and a really unique approach to building product. Before NuBank Jag was director of product management at Facebook, leading monetization of video and third-party content, including news, gaming, and influencer content. Prior to Facebook, he was senior vice president of product and strategy at Quantcast, and group product manager and head of strategy for Display ads at Google, which was Google's second-largest business at the time.

**中文翻译:**
今天的嘉宾是 Jag Duggal。Jag 是 NuBank 的首席产品官。NuBank 是你所能见到的最被低估的“巨兽级”企业之一，它拥有狂热的用户群和非常独特的产品构建方法。在加入 NuBank 之前，Jag 曾担任 Facebook 的产品管理总监，负责视频和第三方内容（包括新闻、游戏和网红内容）的变现。在 Facebook 之前，他曾担任 Quantcast 的产品与战略高级副总裁，以及 Google 展示广告（当时是 Google 的第二大业务）的集团产品经理兼战略负责人。

---

### (00:01:35) Lenny Rachitsky

**English:**
In our conversation, we cover how to build products that people become fanatical about, how to develop a strategy, category design, product line expansion, the future of FinTech and tons more. With that, I bring you Jag Duggal after a short word from our sponsors. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes, and it helps the podcast tremendously.

**中文翻译:**
在我们的对话中，我们讨论了如何打造让人疯狂的产品、如何制定战略、品类设计、产品线扩张、金融科技的未来等等。在听完赞助商的简短介绍后，我将为你带来 Jag Duggal 的访谈。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对本节目有巨大的帮助。

---

### (00:02:03) Lenny Rachitsky

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know like Vercel, Webflow and Loom.

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，你的客户迟早会要求提供 SAML 身份验证和 SCIM 配置等企业级功能。这就是 WorkOS 的用武之地，它能让你快速、无痛地为应用添加企业功能。他们的 API 易于理解，让你能快速交付并重新投入到其他功能的开发中。如今，已有数百家公司由 WorkOS 提供支持，包括你可能熟悉的 Vercel、Webflow 和 Loom。

---

### (00:02:34) Lenny Rachitsky

**English:**
WorkOS also recently acquired Warrant the Fine-Grain Authorization Service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube. This enables fast authorization checks at enormous scale, while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on, SCIM or user management, you should consider WorkOS. It's a drop-in replacement for Auth0 and supports up to 1 million monthly active users for free. Check it out at workos.com to learn more. That's workos.com.

**中文翻译:**
WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于名为 Zanzibar 的开创性授权系统，该系统最初是为 Google 设计的，用于支持 Google Docs 和 YouTube。这使得在大规模场景下进行快速授权检查成为可能，同时保持了能够适应最复杂用例的灵活模型。如果你目前正寻求构建基于角色的访问控制（RBAC）或其他企业功能（如单点登录 SSO、SCIM 或用户管理），你应该考虑 WorkOS。它是 Auth0 的即插即用替代方案，并免费支持多达 100 万月活跃用户。访问 workos.com 了解更多信息。

---

### (00:03:07) Lenny Rachitsky

**English:**
This episode is brought to you by Mercury. Mercury knows your financial operations are complex. It doesn't have to be this way. I've been a super happy customer of Mercury for over a year now, and it's honestly hard to imagine a better online banking experience can exist. Most founders and finance teams have to couple together a patchwork of tools to reconcile transactions from different sources, work extra hard just to get a holistic view of cash flow and have maps to company priorities, and struggle to get answers from platforms that all speak different languages.

**中文翻译:**
本集节目由 Mercury 赞助。Mercury 深知你的财务运营非常复杂，但其实不必如此。我已经做了一年多 Mercury 的忠实客户，老实说，很难想象还会有更好的在线银行体验。大多数创始人和财务团队不得不拼凑各种工具来对账不同来源的交易，为了获得现金流的全景视图并对齐公司优先级而额外辛苦工作，还要在各种语言不通的平台间艰难寻找答案。

---

### (00:03:36) Lenny Rachitsky

**English:**
Mercury knows that there's an art to simplifying this complex patchwork with new bill pay and accounting capabilities, you can pay bills faster, stay in control of company spend, and speed up reconciliation. The end result is the precision control and focus that startups need to transform how they operate. Apply in minutes at Mercury.com, and join over 200,000 ambitious startups like mine that trust Mercury to get them to perform at their best. Mercury, the art of simplified finances. Mercury is a financial technology company, not a bank. Banking services provided by Choice Financial Group and Evolve Bank and trust, members of FDIC.

**中文翻译:**
Mercury 明白简化这种复杂拼凑是一门艺术。通过全新的账单支付和会计功能，你可以更快地支付账单，掌控公司支出，并加速对账。最终结果是初创公司转型运营方式所需的精准控制和专注。只需几分钟即可在 Mercury.com 申请，加入超过 20 万家像我一样信任 Mercury 的雄心勃勃的初创公司，让他们发挥最佳水平。Mercury，简化财务的艺术。Mercury 是一家金融科技公司，而非银行。银行服务由 Choice Financial Group 和 Evolve Bank and Trust 提供，均为 FDIC 成员。

---

### (00:04:04) Lenny Rachitsky

**English:**
Jag, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Jag，非常感谢你能来。欢迎来到本播客。

---

### (00:04:38) Jag Duggal

**English:**
Lenny, I'm honored to be here. I'm a big fan of the show, and look forward to the conversation, so thanks for having me.

**中文翻译:**
Lenny，我很荣幸能来到这里。我是这个节目的忠实粉丝，非常期待这次对话，谢谢你的邀请。

---

### (00:04:44) Lenny Rachitsky

**English:**
I'm even more honored. Thank you for being here. I want to start by sharing just some facts about NuBank that I think are going to blow people's minds. I think a lot of people in the US especially are sleeping on NuBank, and I think this is going to help people that are listening pay even more attention to the stuff we're going to talk about and the lessons we're going to share.

**中文翻译:**
我更感荣幸。谢谢你的到来。我想先分享一些关于 NuBank 的事实，我觉得这些会让大家大吃一惊。我认为很多人，尤其是美国人，都忽视了 NuBank。我觉得这能帮助听众更加关注我们要讨论的内容和分享的经验。

---

### (00:05:02) Lenny Rachitsky

**English:**
So one, NuBank is bigger than Coinbase, Robinhood, Affirm, SoFi, and Lemonade combined. 80% to 90% of new Bank's growth is through word of mouth. Three, NuBank has more customers than Bank of America, which is one of the four big banks in the US, while also only operating in three countries in Latin America.

**中文翻译:**
第一，NuBank 的规模比 Coinbase、Robinhood、Affirm、SoFi 和 Lemonade 加起来还要大。第二，NuBank 80% 到 90% 的增长来自口碑传播。第三，NuBank 的客户数量超过了美国四大行之一的美国银行（Bank of America），而 NuBank 目前仅在拉美的三个国家运营。

---

### (00:05:29) Jag Duggal

**English:**
That's right.

**中文翻译:**
没错。

---

### (00:05:30) Lenny Rachitsky

**English:**
And then also, you guys held the Guinness world record for the world's largest simultaneous unboxing for a credit card that you launched at some point. Although I think somebody beat that record, is that accurate?

**中文翻译:**
还有，你们曾保持过一项吉尼斯世界纪录，是关于你们推出的某款信用卡进行的全球最大规模同时开箱活动。虽然我听说有人打破了这个纪录，是这样吗？

---

### (00:05:42) Jag Duggal

**English:**
I believe that is correct. We've recently set a new world record for the first underwater credit card transaction, so we're always looking for some fun things to do there.

**中文翻译:**
我想是的。我们最近又创下了一项新的世界纪录：完成了全球首笔水下信用卡交易。所以我们总是在寻找一些有趣的事情来做。

---

### (00:05:54) Lenny Rachitsky

**English:**
I like that that's a record no one can break because it was the first one. That's a sneaky way to get a record. That's hilarious. So my sense is the reason that NuBank thrived and made it is, there's this obsession with building a product that customers are fanatical about. The stat that I shared of 80% to 90% of growth is word of mouth. And this idea of growing through word of mouth in this way is the dream of every company, whether you're consumer business, B2B, a bank especially, very unlikely that you grow at this rate through word of mouth.

**中文翻译:**
我喜欢这个纪录，因为它是“第一笔”，所以没人能打破。这真是个拿纪录的巧妙办法，太好笑了。所以我的感觉是，NuBank 能够蓬勃发展并取得成功的原因在于，你们对构建让客户疯狂的产品有一种执念。我刚才分享的数据显示，80% 到 90% 的增长来自口碑。这种通过口碑实现增长的方式是每家公司的梦想，无论你是做 C 端、B 端，尤其是一家银行，能以这种速度通过口碑增长是非常罕见的。

---

### (00:06:24) Lenny Rachitsky

**English:**
So I want to try to help people learn from what you guys have figured out about how to drive such massive word of mouth growth. And maybe just to start from the product perspective, how do you build a product team and a product development process that enables you to build a product that people get fanatical about. And just want to tell all their friends about?

**中文翻译:**
所以我想帮助大家学习你们在推动如此大规模口碑增长方面的经验。也许我们可以先从产品角度开始：你如何组建产品团队和产品开发流程，从而能够打造出让人疯狂、并想告诉所有朋友的产品？

---

### (00:06:44) Jag Duggal

**English:**
Yeah, I think there are a few things that are the fundamentals of making that happen. And to be clear, a lot of this predates my joining the company a little short of five years ago, but I think is an incredible story and is part of what inspired me to join. But first I would say, really think hard and tap into a very deep pain point. The large incumbent Brazilian banks were amongst the most profitable in the world, they were also amongst the most hated in the world.

**中文翻译:**
是的，我认为实现这一目标有几个基本要素。需要说明的是，其中很多东西在我不到五年前加入公司之前就已经存在了，但我觉得这是一个不可思议的故事，也是激励我加入的原因之一。首先我想说的是，要深入思考并切入一个非常深刻的痛点。巴西那些大型传统银行曾是世界上利润最高的银行之一，但它们也是世界上最让人讨厌的银行之一。

---

### (00:07:20) Jag Duggal

**English:**
And my personal experience with that is early in my career, 20 years earlier in the late '90s, I had done a consulting project in Sao Paulo. And I remember walking to lunch one day with the client, who's a friend of mine, and we were going to Classic Churrasque Korea in Sao Paulo. And we were walking by his bank branch, and we were at a stoplight, and he basically said, that's my bank and I hate them. It was 1997.

**中文翻译:**
我个人的经历是，在职业生涯早期，也就是 20 年前的 90 年代末，我在圣保罗做过一个咨询项目。我记得有一天和客户（也是我的一个朋友）去吃午饭，我们要去圣保罗一家经典的巴西烤肉店。路过他的银行网点时，我们在等红绿灯，他基本上是说：“那是我的银行，我恨死他们了。”那是 1997 年。

---

### (00:07:50) Jag Duggal

**English:**
And it always stuck in my head. It stuck in my head for 20 years later when David first reached out to me. So we were tapping into a deep pain point, we can go into exactly why. But that was one thing. The second thing that I would say, and this is very intentional from David, and Ed, and Chris, our founders, is we have a culture at NuBank, which is the most alive in our employees' minds that I've ever experienced. Having worked at Google, and Facebook, and other places like that, I would bet that probably 80% to 90% of our employees could recite the five values to you if you stop them in the hall.

**中文翻译:**
这件事一直印在我的脑海里。20 年后，当 David（NuBank 创始人）第一次联系我时，我依然记得。所以我们切入了一个深刻的痛点，我们可以深入探讨具体原因。这是第一点。第二点我想说的是，这是我们的创始人 David、Ed 和 Chris 非常刻意去做的，那就是 NuBank 的文化。这种文化在员工心中非常有生命力，是我经历过最深刻的。我在 Google、Facebook 等地方工作过，但我敢打赌，如果你在走廊里拦住我们的员工，大概 80% 到 90% 的人都能背出我们的五大价值观。

---

### (00:08:29) Jag Duggal

**English:**
It's not just on the wall somewhere. And the first of those values is a very peculiar phrase, set of words strung together. We want our customers to love us fanatically. And I remember when I interviewed at NuBank for the first time, and actually flew down to Sao Paulo, I remember seeing that phrase and thinking, "These are my guys. These guys are taking this seriously." And a lot of my interview process from my side was really vetting if that was real, or if that was a sign on the wall. So you start with the intent that you are going to make your customers love you.

**中文翻译:**
它不仅仅是挂在墙上的标语。第一条价值观是一句非常特别的话：我们希望客户疯狂地爱上我们（We want our customers to love us fanatically）。我记得第一次去 NuBank 面试，飞到圣保罗看到这句话时，我想：“这就是我要找的人，这些人是认真的。”在我那边的面试过程中，很大一部分其实是在考察这到底是玩真的，还是只是墙上的装饰。所以，你首先要有让客户爱上你的这种意图。

---

### (00:09:10) Jag Duggal

**English:**
And there are a million reasons, operational, convenience, short-term financial viability, which is a real thing when you're a venture-funded startup. Any number of reasons why you can compromise those things on the edges, and in a decision day to day, minute to minute, "We can cut the edges, cut the corner here on that." And look, I don't think we have been perfect on that, but we try very hard. And when there are hard decisions to be made, we bias in favor of the customer. The customer's love, will they want to tell their friends, and neighbors, and family about it? And so I think that's the heart of it.

**中文翻译:**
有无数个理由——运营、便利性、短期财务可行性（这对风投支持的初创公司来说很现实）——让你在细节上妥协。在日常决策中，你随时可能想：“这里我们可以省点事，那里可以走个捷径。”听着，我不认为我们做得完美无缺，但我们非常努力。当面临艰难决策时，我们会偏向客户。我们会考虑客户的喜爱，考虑他们是否愿意告诉朋友、邻居和家人。我认为这就是核心所在。

---

### (00:09:56) Jag Duggal

**English:**
Once you get those things right, the deep pain point, and a culture that is maniacal about making your customers fanatical, then you start to do the trade craft of product development. You make sure that you focus on customer discovery before you start building. You make sure that that discovery is focused not simply on asking the customer, but on innovating on their behalf. You make sure that you take techniques from all over the place, from Procter and Gamble, to Google, to you name it, of maybe you can't ask the customer to tell you what massive new innovation they would love. You've got to observe them, and find their pain points even when they aren't noticing it.

**中文翻译:**
一旦你搞定了这些——深刻的痛点和那种执着于让客户疯狂的文化——你就可以开始进行产品开发的专业操作了。你要确保在开始构建之前专注于客户探索（Customer Discovery）。你要确保这种探索不仅仅是询问客户，而是代表他们去创新。你要从各处汲取技术，从宝洁到 Google 等等。也许你不能直接问客户他们想要什么重大的新创新，你必须观察他们，甚至在他们自己都没意识到的时候发现他们的痛点。

---

### (00:10:49) Jag Duggal

**English:**
And then as you build, you commit to measuring whether they in fact love the product, not fooling yourself about that. And iterating like crazy over and over and over again until you get it just right. So those are some of the principles, but I think the trade craft follows the focus on finding a real deeply held, emotionally held pain point, and a culture that says, that's your North Star.

**中文翻译:**
然后在构建过程中，你要致力于衡量他们是否真的喜欢这个产品，不要自欺欺人。然后一遍又一遍地疯狂迭代，直到做到恰到好处。这些就是一些原则，但我认为专业操作是建立在寻找真实的、深层次的、情感上的痛点，以及一个视其为“北极星”的文化之上的。

---

### (00:11:23) Lenny Rachitsky

**English:**
Amazing. There's so many threads there I'm going to follow, first of all, I want to go back to the values. So you said there's five, you mentioned one. Can you just quickly share the rest?

**中文翻译:**
太棒了。这里有很多线索我想深入探讨。首先，我想回到价值观。你说有五个，你提到了一个，能快速分享一下其他的吗？

---

### (00:11:31) Jag Duggal

**English:**
The five, I'll mention them in the order that most resonate with me. First, we want our customers to love us fanatically. Second, we are hungry and we challenge the status quo. Third, we build strong and diverse teams. Fourth, we pursue smart efficiency. And one that is in many ways underlying all of it is, we think and act like owners, not renters. We do what is right even when no one is telling us to do it. And we have many instances of our employees taking that degree of extreme ownership as they build products and get them launched.

**中文翻译:**
这五个，我按最能引起我共鸣的顺序来说。第一，我们希望客户疯狂地爱上我们。第二，我们保持饥渴并挑战现状。第三，我们建立强大且多元化的团队。第四，我们追求聪明的效率。还有一个在很多方面是所有这些基础的：我们像所有者（Owners）一样思考和行动，而不是租客（Renters）。即使没人要求，我们也会做正确的事。在构建和发布产品时，我们的员工有很多展现这种极致主人翁意识的例子。

---

### (00:12:16) Lenny Rachitsky

**English:**
Okay. And then going back to this idea of building products people love fanatically, you talked about how there's this the number one principle, and it's going to be on everyone's minds when they're building is build product people love fanatically. Talked about, you index towards if you had to make a decision, we're going to do something people love. Is there anything more you could share about just how you operationalize this? For example, is there design reviews where just you come in, or your head of design comes in like, "Is this helping customers love us fanatically?" What's in the systems and processes of how you operate that allows you to build that other than just cool, everyone has to remember this, this is what we're trying to do.

**中文翻译:**
好的。回到“打造让人疯狂喜爱的产品”这个想法，你提到这是第一原则，每个人在构建产品时都会想到它。你说在做决策时，你们会倾向于做人们喜爱的事情。关于如何将其“流程化”，你还能分享更多吗？例如，是否有设计评审，你或设计负责人会问：“这是否能让客户疯狂爱上我们？”在系统和流程中，除了“大家都要记住这个目标”之外，还有什么能确保实现这一点？

---

### (00:12:52) Jag Duggal

**English:**
Yeah, we do a few things. And again, I don't want to also overstate that we've achieved some nirvana. We honor many of these things in the breach sometimes, but we have a series of techniques that we've begged, borrowed, stolen from other places, some of which we've invented on our own. But some examples, we love the Amazon mock press release technique. Explain to me before we've put a single engineer on the project, not explain to me actually, explain to the intended customer why they should care. Because if you can't tell me in two paragraphs why the customer you're building this for should care, then there's still work to do. So that's one technique.

**中文翻译:**
是的，我们做了一些事情。同样，我不想夸大说我们已经达到了某种涅槃境界，有时我们也会违背这些原则。但我们有一系列从别处借鉴、借用或“偷学”来的技术，有些则是我们自己发明的。举几个例子，我们非常喜欢亚马逊的“模拟新闻稿”（mock press release）技术。在投入任何一名工程师之前，先向我解释——其实不是向我，而是向目标客户解释——他们为什么要关心这个产品。如果你不能用两段话告诉我为什么客户应该在意，那么说明还有工作要做。这是其中一个技术。

---

### (00:13:41) Jag Duggal

**English:**
We do have product and design reviews several times a week where we're asking ourselves that question, why is this great for the customer? Why is this fundamentally different for the customer? How does this redefine the category that we are thinking about on the dimensions of quality, on the dimensions of complexity, on the dimensions of price, and usually on the dimensions of all three of those at the same time? And breaking some of the trade-off constraints that you often wrestle with, and seeing if that's possible, which isn't always possible, but we frequently reach for that and sometimes find it.

**中文翻译:**
我们每周会有几次产品和设计评审，我们会问自己：为什么这对客户来说很棒？为什么这对客户来说有本质的不同？它如何在质量、复杂性和价格这三个维度上重新定义我们正在考虑的品类？通常是同时在这三个维度上。我们会尝试打破那些常见的权衡约束，看看是否可能实现。虽然并不总是能成功，但我们经常尝试，有时确实能找到突破口。

---

### (00:14:26) Jag Duggal

**English:**
And then there other things you do after you've built and launched a product, whether it's alpha, beta, or a later stage. The measurement stuff. And some of your previous guests have talked about product market fit and how do you measure? Actually, it's strange. I was sitting here in Silicon Valley for well over a decade, I landed in Sao Paulo when I first joined Newbank. And the small product team at the time is telling me about this thing called Sean Ellis score. And we recently had Sean visit us in Sao Paulo and talk to all of the product managers and designers. But we are amongst the most fanatical followers of his methodology anywhere in the world. We rarely scale a project, a product we've launched, until we know the Sean Ellis score and we know that it's hit a threshold that we find really compelling.

**中文翻译:**
在产品构建并发布后（无论是 Alpha、Beta 还是后期阶段），还有其他事情要做，那就是衡量。你之前的一些嘉宾谈到过产品市场契合度（PMF）以及如何衡量。说来也怪，我在硅谷待了十多年，当我刚加入 NuBank 到达圣保罗时，当时的小产品团队告诉我一个叫“肖恩·埃利斯得分”的东西。最近我们还邀请了肖恩本人来圣保罗，与所有的产品经理和设计师交流。我们可能是世界上最狂热的肖恩·埃利斯方法论追随者之一。在知道肖恩·埃利斯得分并确认它达到了一个非常有说服力的阈值之前，我们很少会大规模推广一个已发布的产品。

---

### (00:15:22) Lenny Rachitsky

**English:**
Can you describe the actual score and the approach?

**中文翻译:**
你能描述一下具体的得分和方法吗？

---

### (00:15:24) Jag Duggal

**English:**
Yeah, the Sean Ellis score is a really simple methodology used by lots and lots of companies that a gentleman named Sean Ellis popularized well over a decade ago. Which basically asks your customers at each stage, and at each stage you have a small number of customers, then a larger group, and growing over time. But at each stage you ask them, how disappointed would you be if this product went away? And what Sean has said is that if at least 40% of your customers are not very disappointed, not just a little disappointed, but very disappointed, he has essentially a three point scale. Not disappointed, somewhat disappointed, very disappointed.

**中文翻译:**
是的，肖恩·埃利斯得分是一个非常简单的方法，由肖恩·埃利斯先生在十多年前推广，被很多公司使用。它基本上是在每个阶段询问你的客户（每个阶段客户数量会从少到多逐渐增长）：如果这个产品消失了，你会感到多么失望？肖恩说，如果至少有 40% 的客户感到“非常失望”（不仅仅是有一点失望，而是非常失望），那么你就达到了 PMF。他基本上用的是三级量表：不失望、有点失望、非常失望。

---

### (00:16:09) Jag Duggal

**English:**
If at least 40% are not very disappointed, you haven't reached product market fit. Now we've had to do some things in NewBank, Brazilians are a culturally happier group than the global average. So for us, our threshold isn't 40%, we've generally moved it up to 50%. I don't believe we have product market fit unless 50% of Brazilians are telling us they would be very disappointed, because Brazilians are inherently polite. And more polite and more optimistic than average, so we make our own little tweaks and adjustments.

**中文翻译:**
如果“非常失望”的比例没达到 40%，你就还没达到产品市场契合度。在 NuBank，我们做了一些调整，因为巴西人在文化上比全球平均水平更快乐。所以对我们来说，阈值不是 40%，我们通常将其提高到 50%。除非有 50% 的巴西人告诉我们他们会非常失望，否则我不认为我们达到了 PMF。因为巴西人天生礼貌，比平均水平更礼貌、更乐观，所以我们做了自己的微调。

---

### (00:16:41) Jag Duggal

**English:**
But we find that to be very helpful. As a company, this extends beyond product, we are addicted to our NPS score. And we reach for world beating net promoter scores as a company, and product vertical by product vertical as well. And we are maniacal about tracking how we do. And again, we compensate for some cultural biases, and we make sure that we hold ourselves to a high bar. But there have been, for example, in Mexico, we've recorded an NPS when we launched the first couple of years of 94-95.

**中文翻译:**
但我们发现这非常有用。作为一家公司，这不仅限于产品，我们对 NPS（净推荐值）非常痴迷。我们追求世界领先的 NPS，无论是公司整体还是各个产品垂直领域。我们对追踪自己的表现近乎疯狂。同样，我们会补偿一些文化偏差，并确保自己处于高标准。例如，在墨西哥，我们在运营的前几年记录到的 NPS 达到了 94-95。

---

### (00:17:22) Lenny Rachitsky

**English:**
That's absurd. I've never heard of that.

**中文翻译:**
这太离谱了，我从未听说过这么高的分数。

---

### (00:17:24) Jag Duggal

**English:**
Yeah. Which is way better than we got in Brazil, but our NPS scores skew in the 70s, 80s, and occasionally 90s. And when they dip down even one or two points, that's a reason for alarm. And we try to figure out why and we try to make sure that we make the iterations. So those are the things we build in. Those are the things we build in.

**中文翻译:**
是的，这比我们在巴西的分数还要高。但我们的 NPS 通常在 70、80 左右，偶尔能达到 90。当分数下降哪怕一两个点，我们就会拉响警报。我们会试图找出原因并确保进行迭代。这些就是我们内置在流程中的东西。

---

### (00:17:45) Lenny Rachitsky

**English:**
I'm glad you got into this, I was going to get into how you measure this stuff. So what it sounds like is the Sean Ellis survey is used as you iterate and launch towards launch. And then NPS is maybe post-launch to see how people like the product.

**中文翻译:**
很高兴你谈到了这个，我正想问如何衡量这些。听起来肖恩·埃利斯调查是在迭代和发布过程中使用的，而 NPS 可能是发布后用来查看人们对产品的喜爱程度。

---

### (00:18:01) Jag Duggal

**English:**
NPS is post-launch. We also look at metrics like churn to make sure that we're not building a leaky bucket, and that's part of this viral customer acquisition loop that we've built. We want to make sure we're building products that are great enough that our customers will tell their friends, and we don't have to invest as much in marketing to drive our growth. And that only works if the customers you get you retain. I have built earlier in my career products that have leaky buckets, and that's a very frustrating treadmill to be on. So I am personally maniacal about making sure that the bucket doesn't have a hole in the bottom.

**中文翻译:**
NPS 是发布后的。我们还会关注流失率等指标，以确保我们不是在建造一个“漏水桶”，这也是我们构建的病毒式获客循环的一部分。我们希望确保产品足够出色，让客户愿意告诉朋友，这样我们就不必投入太多营销费用来驱动增长。而这只有在你留住获取的客户时才有效。在职业生涯早期，我曾构建过“漏水”的产品，那种感觉就像在永无止境的跑步机上，非常令人沮丧。所以我个人非常执着于确保桶底没有洞。

---

### (00:18:42) Lenny Rachitsky

**English:**
So in this Sean Ellis piece, which is really interesting because I think it's something a lot of people can adopt if they're trying to build products people love, and also that succeed. Is this a goal for every project? And I don't know the strategy, or the one pager. Or is it just implied, "Okay, we're not going to move past this gate if 50%, less than 50% of people are not very disappointed." Is that how it's operationalized?

**中文翻译:**
关于肖恩·埃利斯得分这一点非常有趣，因为我认为如果人们想打造受人喜爱且成功的产品，这是可以借鉴的。这是每个项目的目标吗？它是否写在战略或单页文档（one-pager）里？还是说这只是默认的规则：“如果‘非常失望’的人数比例低于 50%，我们就不会通过这个关卡。”它是这样运作的吗？

---

### (00:19:04) Jag Duggal

**English:**
Yeah, we basically operationalize it. We don't have it as a hard and fast rule that is in black and white, but essentially that's the question people know they're going to get in any product review that's a post-launch, post data product review is what's the Sean Ellis score? How do you know that customers love it? Not just like it, but love it to the degree that they're going to tell their friends about it. That's pretty baked in culturally at this point.

**中文翻译:**
是的，我们基本上是这样操作的。虽然没有白纸黑字的硬性规定，但基本上每个人都知道，在任何发布后的产品评审中，他们都会被问到：肖恩·埃利斯得分是多少？你如何证明客户爱它？不仅仅是喜欢，而是爱到愿意告诉朋友。这一点在目前已经深深植根于我们的文化中了。

---

### (00:19:29) Lenny Rachitsky

**English:**
This is an incredible insight, and I think it explains a lot of the success you guys have had. Because that's a very high bar. Many people run the survey, and getting to past 20% is very hard. You have to be very disappointed if there's a new product they've never used goes away, that's a high bar. Most people are like, "Ah, whatever. I don't need this thing." And you're saying you look for 50% of people feeling very disappointed if this new thing they've never used before goes away.

**中文翻译:**
这是一个非常深刻的见解，我认为它解释了你们取得的很多成功。因为这是一个非常高的门槛。很多人做这个调查，能超过 20% 都很难。如果一个他们从未用过的新产品消失了，他们必须感到“非常失望”，这门槛太高了。大多数人会觉得：“啊，无所谓，我不需要这东西。”而你却说，你们追求的是 50% 的人对一个新事物的消失感到非常失望。

---

### (00:19:58) Jag Duggal

**English:**
Yeah, that's right. There are several on the newer side of products that we're launching now we're at borderline 50, and my push to the team is what are the three, four, five things you need to build to really get decisively beyond 50? And what are the segments or cohorts where it is above 50, and what is that telling us versus the cohorts where it is lower than that? So we put a lot of analytical effort, and a lot of depth of thinking. We were in a product review several years ago, and our lead designer, whose ex Google and ex-Facebook, we were in a review together and the team was saying, "We think this is good enough for launch."

**中文翻译:**
是的，没错。我们现在推出的一些新产品正处于 50% 的边缘，我会督促团队：你们需要构建哪三、四、五样东西，才能果断地突破 50%？哪些细分群体或客群的分数超过了 50%？这与分数较低的客群相比告诉了我们什么？所以我们投入了大量的分析精力和深度思考。几年前在一次产品评审中，我们的首席设计师（曾在 Google 和 Facebook 工作过）和我在一起，团队当时说：“我们认为这已经‘足够好’（good enough）可以发布了。”

---

### (00:20:44) Jag Duggal

**English:**
And he used the phrase, which both Chris and Kara, one of our co-founders and I have now adopted, which is, "Good enough, isn't good enough. Is it great enough?" Is it great enough? Because that's the bar, particularly for some of our ten-pole products, but we try to apply it largely across the board. A lot of companies, not just in Brazil or Latam, but everywhere, spend a ton of money on marketing. Their VC budgets, VC funding basically goes to Google and Facebook. And I've spent a lot of my career taking that money on board for Google and Facebook. But it is a much better scenario if that's a small portion of what you're doing, and the main portion of what you're doing is actually investing in making the product great that you don't have to do that.

**中文翻译:**
他用了一句话，现在 Chris、联合创始人 Kara 和我都采用了这句话，那就是：“足够好还不够好。它是否足够卓越（great enough）？”因为它是否足够卓越才是标准，尤其是对于我们的一些核心产品，但我们尝试将其推广到所有产品。很多公司，不仅是在巴西或拉美，而是到处都是，在营销上投入了巨额资金。他们的风投资金基本上都流向了 Google 和 Facebook。我职业生涯的大部分时间都在 Google 和 Facebook 帮他们收这些钱。但如果营销只是你工作的一小部分，而大部分精力都花在把产品做得足够卓越，从而不需要那么多营销，那才是更好的情况。

---

### (00:21:27) Lenny Rachitsky

**English:**
Is there an example of a project that comes to mind that was below that bar and then you pushed it above where you're like, "Here's the thing we were missing."?

**中文翻译:**
你脑海中是否有一个例子，某个项目最初低于那个标准，然后你们把它推到了标准之上，并发现“这就是我们缺失的东西”？

---

### (00:21:35) Jag Duggal

**English:**
Yeah, I'll give you one that we're wrestling with right now. We have a product called Assistente de Pagamentos, payments assistant. It's right now only launched in Brazil, we haven't yet launched it in Mexico and Colombia. Paying bills in Brazil is quite complex. There are four different ways, four different payment rails that different payments use. From the mobile payment system that has exploded in Brazil the last three years called PIX, that's become fairly world famous in the FinTech world, to more standard and some more archaic rails as well.

**中文翻译:**
有的，我给你举一个我们现在正在处理的例子。我们有一个叫 Assistente de Pagamentos 的产品，即“支付助手”。目前它只在巴西推出，还没有在墨西哥和哥伦比亚上线。在巴西付账单非常复杂，有四种不同的支付渠道。从过去三年在巴西爆发式增长、在金融科技界闻名遐迩的移动支付系统 PIX，到更标准甚至更古老的一些渠道。

---

### (00:22:16) Jag Duggal

**English:**
So if you're a customer, you've got to keep track of your bills like we all do. You've got to keep track of which rail, you got to collect your bills, you got to make sure that you pay them. And some of the rails actually aren't that reliable. So you've paid it, it doesn't go through. And the consequences for not paying a bill is getting reported to the credit bureau and becoming what is called negativado, having a negative mark on your credit report. And that can be a big deal for the average customer. And so this was a real deep pain point.

**中文翻译:**
所以如果你是客户，你必须像我们所有人一样追踪账单。你得记住用哪个渠道，收集账单，确保按时支付。而且有些渠道其实并不那么可靠，你付了款，但没成功。而不付账单的后果是被上报给征信机构，变成所谓的“negativado”，即信用报告上有负面记录。这对普通客户来说是件大事。所以这是一个非常深刻的痛点。

---

### (00:22:49) Jag Duggal

**English:**
And as we launched the product in a Reid Hoffman style, if you are not embarrassed by V1 you've waited too long. As we've done that last year, we found that a very interesting pattern. We had a decent Sean Ellis score, borderline 40%, I forget the exact number, but basically in that ballpark. But we found that there was a small cohort of a customer base who had more than four plus commitments registered. And even more so within that small cohort an even smaller bullseye cohort who had more than four commitments on at least two of the four rails. And their Sean Ellis score hit 70% and we're like, "Okay, the key is we need to across these rails, not have them one by one. And we need to make it easy for customers to onboard multiple bills across multiple rails." And then the automation takes over and people see the real, benefit because there are ways ...

**中文翻译:**
我们按照里德·霍夫曼（Reid Hoffman）的风格发布了产品——如果你不为 V1 版本感到尴尬，说明你发布得太晚了。去年发布后，我们发现了一个非常有趣的模式。我们的肖恩·埃利斯得分还不错，在 40% 左右，我忘了确切数字，但大概就在那个范围。但我们发现，有一小部分客户注册了四个以上的支付项目。而在这一小部分人中，还有一个更小的“靶心”群体，他们在四种渠道中的至少两种上都有四个以上的项目。他们的肖恩·埃利斯得分达到了 70%。我们意识到：“关键在于我们需要跨渠道整合，而不是一个一个来。我们需要让客户能够轻松地在多个渠道上导入多份账单。”然后自动化接管，人们就能看到真正的益处，因为……

---

### (00:24:00) Jag Duggal

**English:**
Automation takes over and people see the real benefit because there are ways. On the surface if you said to the average person anywhere, any sort of developed country, we're going to have a bill auto-pay, that's on the face of it not necessarily exciting, but if you build it right, it is actually a fundamentally different experience rather than incrementally better experience. And that's what we've done. We've systematically made dozens of iterations on the product to allow customers to in one go do multiple bills across multiple rails and make that tiny bullseye cohort that we had, segment that we had a larger and larger proportion of the customers who are trying, and by the way, that's a journey still underway. We have a whole road map for the next year of lots of small quality adjustments that we're going to make and we're seeing some great feedback. We're now over 10 million monthly actives on that product when we were struggling in the hundreds of thousands about 15 months ago.

**中文翻译:**
自动化接管后，人们看到了真正的益处。表面上看，如果你对任何发达国家的普通人说“我们要搞个账单自动支付”，这听起来不一定让人兴奋。但如果你做得对，它实际上是一种本质上不同的体验，而不仅仅是好了一点点。这就是我们所做的。我们对产品进行了数十次系统性的迭代，让客户能够一次性处理跨多个渠道的多份账单，并让那个小小的“靶心”群体在尝试该产品的客户中所占比例越来越大。顺便说一下，这个过程还在继续。我们明年的整个路线图里有很多小的质量调整，我们也收到了很好的反馈。现在该产品的月活跃用户已超过 1000 万，而 15 个月前我们还在几十万的水平上挣扎。

---

### (00:25:08) Lenny Rachitsky

**English:**
That is a really interesting insight there of just using the score and survey to narrow in on who actually loves this the most and see if there's something there. Is that something that you generally do or is that just like, oh wow that came up in this exam?

**中文翻译:**
这是一个非常有趣的见解：利用得分和调查来缩小范围，找出谁最爱这个产品，并看看其中是否有玄机。这是你们通常的做法，还是说只是在这个案例中偶然发现的？

---

### (00:25:20) Jag Duggal

**English:**
We do that fairly frequently. When we did our, we have a high income rewards credit card. It's called Ultravioleta. We went through a similar process where at launch there were many different customer segments, but there was one that really loved the product and it was not surprising. There were the ones where the customer spent enough each month that they got the fee waiver and then all of the other benefits that we had built in really resonated. Whereas if you're paying the monthly fee, those other benefits were not quite as exciting or didn't quite compensate. So we've done this several times and we've started recently combining it with trying to get very agile in getting that feedback from that bullseye segment. So we've told many of our product managers and designers over the last two years, don't worry about serving 1000 customers, taking three weeks, serving 1000 customers, getting a bunch of cross tabs. Even at the end of which it's very hard to read the real fine grain customer feedback.

**中文翻译:**
我们经常这样做。当我们推出高收入奖励信用卡 Ultravioleta 时，也经历了类似的过程。发布时有很多不同的客户细分，但有一个群体特别喜欢这个产品，这并不奇怪：就是那些每月消费额足够高、可以免除年费的客户，我们内置的其他福利对他们非常有吸引力。而如果你需要支付月费，那些福利可能就不那么令人兴奋，或者不足以抵消费用。所以我们这样做过好几次。最近我们开始尝试非常敏捷地从那个“靶心”群体获取反馈。在过去的两年里，我们告诉很多产品经理和设计师：不要担心去调研 1000 个客户，花三周时间，拿回一堆交叉分析表。即使做完了，也很难读出真正细致的客户反馈。

---

### (00:26:27) Jag Duggal

**English:**
So we just tell them, call 10 of them. Pick up the phone yourself. Don't ask a researcher to come up with a plan to go do the research to then summarize it, to then bring it to you, which has so many degrees of distance built in. You pick up the phone, call 10 of them and nine times out of 10, by the way, by the time you've made your fifth call, you could predict what's customer six, seven, eight, nine and 10 are going to tell you. And then you know what it is that is the gap or what it is that is truly resonating that you want to double down on. So we're constantly trying to iterate in small ways the ways to get really that voice of the customer straight lined in to the people who are building the product.

**中文翻译:**
所以我们直接告诉他们：给其中 10 个人打电话。你自己拿起电话。不要让研究员制定研究计划、去做调研、再总结、最后交给你，这中间隔了太多层。你自己打电话，打给 10 个人。顺便说一下，十有八九当你打到第五个电话时，你就能预测第六、七、八、九、十个客户会说什么了。然后你就知道差距在哪里，或者什么是真正引起共鸣、值得加倍投入的东西。所以我们一直在尝试通过各种小方式，让客户的声音能够直接传达给构建产品的人。

---

### (00:27:11) Lenny Rachitsky

**English:**
I love this advice. I imagine as a PM that is extremely scary to go call a customer. Most people don't do that. By the way, do you actually operationally, is it actually a call or do you recommend the email? What do you actually recommend they do because,-

**中文翻译:**
我喜欢这个建议。我能想象作为一名 PM，去给客户打电话是非常恐怖的，大多数人都不这么做。顺便问下，在实际操作中，真的是打电话吗？还是你推荐发邮件？你到底建议他们怎么做？

---

### (00:27:23) Jag Duggal

**English:**
We literally pick up the phone.

**中文翻译:**
我们真的就是拿起电话打过去。

---

### (00:27:26) Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好的。

---

### (00:27:26) Jag Duggal

**English:**
Pick up the phone.

**中文翻译:**
打电话。

---

### (00:27:27) Lenny Rachitsky

**English:**
Okay. Great.

**中文翻译:**
好的，太棒了。

---

### (00:27:28) Jag Duggal

**English:**
Because you can get tone of voice. Brazilians and Mexicans are incredibly expressive. There is a degree of real fine grain sense that the statistics never tell you.

**中文翻译:**
因为你可以听到语气。巴西人和墨西哥人非常有表现力。那种细微的感觉是统计数据永远无法告诉你的。

---

### (00:27:43) Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:27:44) Jag Duggal

**English:**
And it's very aligned with design thinking and there's a lot of literature around how this works well, and I wouldn't say we're doing it especially to the best practice scientific. We're just like, just make the call. Make it as simple, as unobtrusive with as little overhead as possible to make sure the voice of the customer is coming directly into the teams that are building.

**中文翻译:**
这非常符合设计思维（Design Thinking），有很多文献介绍这种方法的效果。我不会说我们做得多么科学或符合最佳实践，我们只是觉得：直接打电话吧。让它尽可能简单、不突兀、低成本，确保客户的声音能直接进入开发团队。

---

### (00:28:09) Lenny Rachitsky

**English:**
Jeff Bezos had this quote on his Lex Fridman podcast where if you have data and you have an anecdote, usually the anecdote is right.

**中文翻译:**
杰夫·贝佐斯（Jeff Bezos）在 Lex Fridman 的播客上说过一句话：如果你手头有数据，同时又有一个轶事（anecdote），通常那个轶事才是正确的。

---

### (00:28:17) Jag Duggal

**English:**
I love that. That sounds exactly right to me.

**中文翻译:**
我喜欢这句话，听起来非常正确。

---

### (00:28:20) Lenny Rachitsky

**English:**
To make it even more tactical for the surveys you run, is there any tool you find? How do you actually collect this data? Is there anything interesting that you could share of just how to operationalize collecting this data?

**中文翻译:**
为了让这个话题更具实操性，关于你们运行的调查，有没有什么你觉得好用的工具？你们到底是怎么收集这些数据的？在如何将数据收集流程化方面，有没有什么有趣的经验可以分享？

---

### (00:28:30) Jag Duggal

**English:**
We've used a series of tools, many of the main survey vendor tools, we still use many of them, but we don't standardize or find one that dramatically changes our life beyond the mindset of we are going to make sure that this product has product market fit before we scale it. One of the things I've seen throughout my career as a product manager and CPO, we live with it today at Nubank every month is the pressure on the line product manager to scale the product that the entire company, the entire executive team, the entire management chain has been counting on. We're launching this thing [foreign language 00:29:16]. We all wanted to scale. We all are very excited about it. We had the product review six months ago and we thought this is going to be amazing. And the pressure on that product manager to scale a product is immense and the job of the product manager in many instances is to say no.

**中文翻译:**
我们用过一系列工具，很多主流的调查供应商工具我们现在还在用。但我们并没有标准化，也没有发现哪个工具能产生翻天覆地的变化。真正起作用的是那种心态：在规模化之前，我们要确保产品具有 PMF。在我作为产品经理和 CPO 的职业生涯中，我经常看到（在 NuBank 每个月也会遇到）一线产品经理面临的压力：整个公司、整个高管团队、整个管理链条都指望这个产品规模化。我们要发布这个东西了，大家都想让它做大，大家都非常兴奋。六个月前我们做了产品评审，觉得这会很棒。产品经理面临的规模化压力是巨大的，但在很多情况下，产品经理的工作是说“不”。

---

### (00:29:35) Jag Duggal

**English:**
And one of the things I try to say frequently within the walls of Nubank is we are not going to take a small problem and scale it because if we do that, we end up with a big mess. Something isn't working at small scale, no problem, especially if we have a strong hypothesis and a lot of ways of getting good customer feedback. We iterate, we iterate, we get it right and then once we get it right, scaling if you do it right in many cases takes care of itself because the customer is now excitedly telling their friends.

**中文翻译:**
在 NuBank 内部，我经常说的一句话是：我们不能把一个小问题规模化，因为如果我们那样做，最后会演变成一个巨大的烂摊子。如果某样东西在小规模下运行不畅，没关系，特别是如果我们有一个强有力的假设和很多获取客户反馈的渠道。我们迭代、再迭代，直到把它做对。一旦做对了，如果你操作得当，规模化在很多情况下是水到渠成的，因为客户会兴奋地告诉他们的朋友。

---

### (00:30:08) Jag Duggal

**English:**
Whereas you can pour a lot of money and a lot of effort and when you have a big app like Nubank or places like Google and Facebook, you can make any product look great for months if not years because you have such a large customer base that you can always get them to try it with all sorts of basic techniques, but you're bouncing a dead cat. And then you've got a real big mess to untangle when the thing is much, much larger. So we try to be pretty disciplined about that. And that's a lot of what the Sean Ellis does is it bring science to some of that art of making that judgment call.

**中文翻译:**
反之，你可以投入大量的金钱和精力。当你拥有像 NuBank、Google 或 Facebook 这样的大型应用时，你可以通过各种基础手段让任何产品在几个月甚至几年内看起来都很棒，因为你有庞大的用户群，总能让他们去尝试。但你其实是在“让死猫跳”（bouncing a dead cat，指垂死挣扎）。当规模变得非常大时，你就会面临一个极难收拾的烂摊子。所以我们尝试保持自律。肖恩·埃利斯得分的作用很大程度上就是为这种判断的艺术引入了科学。

---

### (00:30:42) Lenny Rachitsky

**English:**
This point you made about it's the PMs job to push back and stop bad things from happening I think is such an important one. A lot of PMs are just told here, build this thing and they kind of know this is not going to work, this is a bad idea, but either they don't think they should be pushing back or they are not good at it. From the PMs you've worked with that are good at convincing and pushing back, like we should not do this yet, do you have any tactics or ways of communicating that you found effective for pushing back to, like you said, all this pressure that's coming down on them?

**中文翻译:**
你提到的“PM 的职责是推辞并阻止坏事发生”这一点非常重要。很多 PM 只是被告知“去把这个做出来”，他们内心可能知道这行不通，或者是个坏主意，但要么觉得不该推辞，要么不擅长推辞。在你合作过的那些擅长说服和推辞（比如“我们现在还不该做这个”）的 PM 中，你有没有发现什么有效的沟通策略或技巧，来应对你提到的那些来自上层的压力？

---

### (00:31:14) Jag Duggal

**English:**
One of the things I've learned relatively later in my career, I wish I'd learned it decade earlier, decades earlier even is how important culture is. And we talked about the five cultural tenets, but this idea of we are owners, not renters. You're an owner of that product as the product manager or the lead engineer or the lead designer or in fact anyone on the team. If you really don't think it's going to work, don't tell me what I want to hear. It's incumbent on you, it's expected of you as an owner to tell me the bad news and tell it to me early, even when it's convenient, even when there's a promotion at stake, these dynamics get very real very quickly then look, I don't think it's going to work and here's why, or it's not working and here's why, or we should kill it and here's why.

**中文翻译:**
这是我在职业生涯较晚时期学到的东西，我真希望早几十年就明白：文化是多么重要。我们谈到了五大文化准则，其中“我们是所有者，不是租客”这一条非常关键。作为产品经理、首席工程师或首席设计师，你是那个产品的所有者。如果你真的认为它行不通，不要只挑我想听的说。作为所有者，你有责任、也被期望告诉我坏消息，而且要尽早告诉我。即使在涉及晋升等利益相关的时刻，这些动态也会变得非常现实。你应该说：“听着，我认为这行不通，原因如下”，或者“它现在没起作用，原因如下”，或者“我们应该砍掉它，原因如下”。

---

### (00:32:05) Jag Duggal

**English:**
The second thing I would say is senior leaders at companies that have gone, especially startups that have scaled well, you usually have people who have been in that boat who have seen products that weren't working who have killed them or who have pivoted them pretty dramatically. And there's a lot of respect for someone who has a real clarity of thought and brings a high bar and is not simply going with the flow. So I think that's the main thing, is bringing that ownership mindset. And the second is bringing clarity and bringing data and understanding that most senior executives in whichever company are strong-willed and bring strong opinions. That's part of the job description. That's okay. It is your job whether product or design or engineering or whatever function as a leader to if you think you are practicing for one of those senior jobs, it's sort of let's say a mid-level, it doesn't come miraculously when you get a C-suite title, it's something that's going to be practiced. And it's something that is expected and I think that's not just a Nubank thing.

**中文翻译:**
第二点我想说的是，在那些规模化成功的初创公司里，高级领导层通常也经历过这些。他们见过失败的产品，砍掉过产品，或者经历过剧烈的转型。他们会非常尊重那些思维清晰、坚持高标准、而不是随波逐流的人。所以核心是带入那种主人翁心态。其次是带来清晰的思路和数据，并理解任何公司的高管通常都意志坚定且有强烈的见解。这是他们工作的一部分，这没关系。作为产品、设计或工程负责人，如果你觉得自己是在为未来的高级职位做练习（比如你现在是中层），这种能力不会在你获得 C-level 头衔时奇迹般出现，它是需要练习的。这是被期望的能力，我认为这不仅是 NuBank 的特色。

---

### (00:33:27) Jag Duggal

**English:**
Certain cultures promote it better than others, but I think it's pretty universally important. And so I would just encourage people to try it, understand the trade-offs, understand the challenge, articulate the other side, but if you genuinely believe it's not yet ready to scale your products, at the end of the day, the big mess is a thing you're still going to owe and we're all going to forget that we told you to scale the thing. We're all going to still blame you at the end of the day. So you might as well bite the bullet earlier, pivot it when it's easier to do and it'll work out better in the end.

**中文翻译:**
某些文化比其他文化更能促进这种沟通，但我认为它具有普遍的重要性。所以我鼓励大家去尝试，理解权衡，理解挑战，清晰表达对立观点。如果你真心认为产品还没准备好规模化，那么最终产生的烂摊子还是要你来负责，到那时大家都会忘记是他们要求你规模化的，最后挨骂的还是你。所以你不如早点承担责任，在还容易调整的时候进行转型，最终结果会更好。

---

### (00:34:10) Lenny Rachitsky

**English:**
I want to come back to one more thread and then I'm going to go in a different direction. You talked a bit about talking to customers, finding innovative ideas, not just listening to what they're telling you. There's this whole skill of user research and interviewing customers and finding the pain point, figuring out what to build. Do you have any just, I don't know, tips or tactics or lessons you've learned about just how to do this well, how to uncover the pain point and then figure out what to actually build when you're interviewing customers?

**中文翻译:**
我想再回到一个话题，然后再转向另一个方向。你谈到了与客户交流、寻找创新想法，而不仅仅是听他们说什么。用户研究、访谈客户、寻找痛点并决定构建什么，这是一整套技能。关于如何做好这些，你有没有什么建议、策略或教训？在访谈客户时，如何挖掘痛点并确定到底该做什么？

---

### (00:34:40) Jag Duggal

**English:**
I'll share a couple of thoughts, but I will tell you as a preface that it is arguably the area right now that I still wrestle with. I still think I, and we are not doing it as well. I've never seen it done quite as consistently great as it could be, and I think it's an area for where design thinking and a lot of the design function can help us, but it's very, very, it's one of the areas of greatest inconsistency that I see in product development. Having said that, a couple of things that I see that we sometimes do really well at Nubank and other times we miss on one dimension or the other. First off, per your Jeff Bezos anecdote, the anecdote usually trumps the data. And there are many times when I see teams that are doing very sophisticated analysis and they've sort of forgotten what the question is or what the conclusion they can draw from it truly is. So never lose sight of the value of the customer's words and the anecdote. That's one.

**中文翻译:**
我分享几点想法，但首先我要声明，这可能是我目前仍在苦苦钻研的领域。我仍然认为我和我们做得还不够好。我从未见过有人能持续地把这件事做得尽善尽美。我认为这是设计思维和设计职能可以提供帮助的领域，但它也是我在产品开发中见到的最缺乏一致性的领域之一。话虽如此，在 NuBank，我们有时做得很好，有时也会在某些维度上失手。首先，正如你提到的贝佐斯的轶事，轶事通常胜过数据。我经常看到团队在做非常复杂的分析，却忘记了核心问题是什么，或者他们真正能从中得出的结论是什么。所以，永远不要忽视客户的话语和轶事的价值。这是第一点。

---

### (00:35:56) Jag Duggal

**English:**
The second one that I believe very, very strongly in is I think teams often skip the step of clearly, very, very clearly working very hard to be super crisp in articulating their hypothesis. If you don't have a hypothesis, you're going to spend a lot of time researching, you're going to get a lot of data back, qualitative, anecdotal or quantitative and you're not going to know what to make of it because it's not either validating or invalidating your hypothesis because there isn't a hypothesis. So it just becomes an interesting conversation.

**中文翻译:**
第二点我深信不疑的是：团队经常跳过“清晰表达假设”这一步。他们没有努力去非常、非常清晰地阐述他们的假设（Hypothesis）。如果你没有假设，你就会花大量时间做研究，拿回一堆定性的、轶事性的或定量的数据，但你不知道该怎么处理，因为没有假设可以去验证或推翻。于是，研究就变成了一场“有趣的谈话”，仅此而已。

---

### (00:36:34) Jag Duggal

**English:**
The third one is, I've got a hypothesis, I've got it really crisp and now the pitfall is I've fallen in love with my hypothesis. I'm a lawyer for my hypothesis. I'm not a judge of whether the hypothesis is right or not right. So I think that's another common pitfall. I've fallen into that one too many times to count. And then the last thing I would highlight is even when you have a strong hypothesis and you're actually in the mode of doing the research, observe more than ask questions if you can, ask indirect questions more than direct questions. Would you love this product? Right. Excited product manager has been working for two months on a design. You're searching for the problem more than the solution. You're looking indirectly and asking from multiple directions the same question rather than trying to find a yes, they love the thing you've been thinking about and swaying on for a long time. And if you can, observing is better than asking, although that's a tricky skill. Those are the things that I look for.

**中文翻译:**
第三点是，我有了假设，而且很清晰，但陷阱出现了：我爱上了我的假设。我变成了我假设的辩护律师，而不是判断假设是否正确的法官。这是另一个常见的坑，我也掉进去过无数次。最后一点是，即使你有了强有力的假设并正在进行研究，如果可能的话，多观察，少提问。多问间接问题，少问直接问题。比如不要问“你会喜欢这个产品吗？”一个兴奋的产品经理可能已经为这个设计工作了两个月。你应该寻找的是问题，而不是解决方案。你要从多个方向间接提问，而不是试图诱导对方说“是的，我喜欢你构思已久的东西”。如果可以，观察胜过询问，尽管这是一种很难掌握的技能。这些就是我关注的点。

---

### (00:37:53) Lenny Rachitsky

**English:**
With the hypothesis point, just to make sure people understand, your suggestion there is before you start talking to customers, doing your easy researches as a PM or just anyone on the team, essentially have a perspective on what you think is going to be true. Is that how you think about it?

**中文翻译:**
关于假设这一点，为了确保大家理解，你的建议是：在开始与客户交谈、进行研究之前，作为 PM 或团队成员，本质上要对你认为什么是正确的有一个预判。你是这么想的吗？

---

### (00:38:07) Jag Duggal

**English:**
Exactly. Have a point of view on what you think the customer will say that will lead them to be really excited about your product. That way you will get very clearly eh or yes, bang the table excitement and you will know when you're getting that reaction.

**中文翻译:**
没错。对于你认为客户会说什么、什么会让他们对你的产品感到兴奋，要有一个观点。这样你就能非常清晰地分辨出对方是反应平平，还是兴奋得拍桌子，你会知道什么时候得到了那种反应。

---

### (00:38:26) Lenny Rachitsky

**English:**
Is there an example of that just to make it even more concrete? Because I imagine many PMs are kind of feeling like they have to be unbiased and just like, let's see. Let's see if this is something we should do and I don't want to bias anyone against it. Is there a quick example of a hypothesis?

**中文翻译:**
能不能举个例子让它更具体？因为我能想象很多 PM 觉得他们必须保持中立，心想“让我们看看吧，看看这是不是我们该做的，我不想带偏任何人”。能不能举个简单的假设例子？

---

### (00:38:42) Jag Duggal

**English:**
One of the famous examples that's somewhat hypothesis related and somewhat observation related is the invention of the Swiffer from Procter & Gamble. Right. The people hate mopping and they will do it and they won't even realize how painful an experience it is because they've just developed the work arounds and they just deal with the burden. But if you observe very granularly what the problems are, then you can see where the problems are. And so if you bring a strong hypothesis to, that this is a real problem, even if customers aren't telling you it's a problem because they've just sort of gotten used to it. So that's one.

**中文翻译:**
一个著名的例子（既与假设有关，也与观察有关）是宝洁公司发明 Swiffer（速洁拖把）。人们讨厌拖地，但他们会去做，甚至意识不到这个过程有多痛苦，因为他们已经习惯了各种凑合的方法，默默忍受负担。但如果你非常细致地观察，你就能发现问题所在。所以如果你带着一个强有力的假设——“这是一个真实存在的问题”，即使客户因为习惯了而没告诉你这是个问题，你也能发现它。这是一个例子。

---

### (00:39:23) Jag Duggal

**English:**
We have a hypothesis at Nubank. I'll give you one that's live. We have a hypothesis at Nubank that the joint bank account, I was doing some research on this just last week. The joint bank account was invented in the early, it's actually hard to say, but it was invented, depending on what source you believe, in the late 19th or early 20th century. And it was basically invented coincident with the social movement, sort of the women's liberation social movements before women in the US were legally allowed to vote, where women were not allowed to open a bank account without their husbands prior approval. That is the era from which the joint bank account that we still live with today came from. It's 120 to 150 years old.

**中文翻译:**
在 NuBank 我们也有一个假设，我给你举个正在进行的例子。我们有一个关于“联名银行账户”（joint bank account）的假设。我上周刚做了一些研究，联名账户发明于 19 世纪末或 20 世纪初。它基本上是伴随着妇女解放运动而诞生的，当时美国的女性在法律上还没有投票权，如果没有丈夫的预先批准，女性甚至不能开设银行账户。我们今天仍在使用的联名账户就源于那个时代，它已经有 120 到 150 年的历史了。

---

### (00:40:17) Jag Duggal

**English:**
I don't think it's surprising. Our hypothesis is it's not surprising that that artifact, that that product is not made for the modern customer, that it is easier for me to share a Spotify playlist with my wife or my daughter than it is for me to share a savings goal just mechanically. So we're going into a product development cycle that says there is a new social banking arrangement that is not about tweeting and it's not about social very broadly defined. It is about our financial lives are inherently social. And it is very hard to share with my spouse, with my kids, with my parents who might be helping me pay for my child's education as an example, use case. It's a very strong hypothesis.

**中文翻译:**
我认为这并不奇怪。我们的假设是：这个产品并不是为现代客户设计的。对我来说，给妻子或女儿分享一个 Spotify 播放列表，竟然比分享一个储蓄目标还要容易，这在机制上是不合理的。所以我们进入了一个产品开发周期，认为应该有一种新的“社交银行”安排。这指的不是发推特，也不是广义上的社交，而是指我们的财务生活本质上是社交性的。比如，我很难与配偶、孩子或可能帮我支付孩子教育费用的父母分享财务状况。这是一个非常强有力的假设。

---

### (00:41:18) Jag Duggal

**English:**
But when you go into the research with the customer, you don't try to sell them. You try to see if they're experiencing pain points. And it becomes very hard when you're in and they say even something a little bit in the direction of what you hope they would say to not be like, jump in with a lot of excitement and then get into more of a sell mode with them and almost try to sell against your idea, push back against your idea, make the customer sell you in the interaction. And you play the devil's advocate. So those are the kinds of things we search for as we build products.

**中文翻译:**
但在对客户进行研究时，你不要试图向他们推销。你要观察他们是否正在经历痛点。当你听到他们说出哪怕一点点符合你预期的话时，很难不兴奋地跳起来并进入推销模式。你应该反其道而行之，甚至尝试反驳你自己的想法，让客户在互动中反过来“说服”你。你要扮演“魔鬼代言人”。这就是我们在构建产品时所追求的东西。

---

### (00:42:01) Lenny Rachitsky

**English:**
That sounds like a great idea. I believe in this hypothesis. Today's episode is brought to you by OneSchema, the embeddable CSV importer for SaaS. Customers always seem to want to give you their data in the messiest possible CSV file. And building a spreadsheet importer becomes a never-ending sink for your engineering and support resources. You keep adding features to your spreadsheet importer, but customers keep running into issues. Six months later you're fixing yet another date conversion edge case bug. Most tools aren't built for handling messy data, but OneSchema is.

**中文翻译:**
听起来是个很棒的主意，我也相信这个假设。今天的节目由 OneSchema 赞助，它是面向 SaaS 的可嵌入式 CSV 导入器。客户似乎总是想把数据放在最乱的 CSV 文件里交给你。构建一个电子表格导入器会变成工程和支持资源的无底洞。你不断为导入器添加功能，但客户总会遇到问题。六个月后，你还在修复另一个日期转换的边缘案例 Bug。大多数工具都不是为了处理乱七八糟的数据而设计的，但 OneSchema 是。

---

### (00:42:45) Lenny Rachitsky

**English:**
Companies like Scale AI and Pave are using OneSchema to make it fast and easy to launch delightful spreadsheet import experiences from embeddable CSV import to importing CSVs from an SFTP folder on a recurring basis. Spreadsheet import is such an awful experience in so many products. Customers get frustrated by useless messages like error online 53 and never end up getting started with your product. OneSchema intelligently corrects messy data so that your customers don't have to spend hours in Excel just to get started with your product. For listeners of this podcast, OneSchema is offering a $1,000 discount. Learn more at oneschema.co/Lenny.

**中文翻译:**
像 Scale AI 和 Pave 这样的公司都在使用 OneSchema，从而快速轻松地推出令人愉悦的电子表格导入体验，包括可嵌入的 CSV 导入，以及从 SFTP 文件夹定期导入 CSV。在很多产品中，电子表格导入体验都非常糟糕。客户会被像“第 53 行错误”这样无用的信息搞得心烦意乱，最终放弃使用你的产品。OneSchema 能智能纠正混乱的数据，让你的客户不必为了开始使用你的产品而在 Excel 中耗费数小时。对于本播客的听众，OneSchema 提供 1000 美元的折扣。访问 oneschema.co/Lenny 了解更多。

---

### (00:43:13) Lenny Rachitsky

**English:**
I want to talk about strategy. I know that you have a very strong perspective on how to think about strategy and approach strategy. This is something that everyone always wants to get better at. Every PM is always told you want to build your strategic thinking muscles and this is really important to your career. I'd love to hear your take and how you approach developing strategy and your advice to folks.

**中文翻译:**
我想聊聊战略。我知道你对如何思考和制定战略有非常强烈的见解。这是每个人都想提高的能力。每个 PM 都会被告知要锻炼战略思维，这对职业生涯至关重要。我很想听听你的看法，你是如何制定战略的，以及你对大家的建议。

---

### (00:43:35) Jag Duggal

**English:**
I will readily admit, I bring a bias. I spent almost a decade at the beginning of my career right after college working in a strategy consulting firm. Right. So I bring a bias, which is to some degree, certainly for the length of time I did it, an unusual background for a product manager. When I first showed up at Google, it took me a couple of years to realize my job was not to produce a nice PowerPoint, it was to ship code. And I was doing a poor job of that for at least the first 12 to 18 months. But I think there is almost a countervailing dogma in Silicon Valley or in tech companies more generally, that strategy is easy and execution is everything.

**中文翻译:**
我坦白，我有偏见。大学毕业后的职业生涯初期，我在一家战略咨询公司工作了近十年。所以我有这种偏见，某种程度上说，考虑到我从事咨询的时间，这对产品经理来说是不寻常的背景。当我刚到 Google 时，我花了几年的时间才意识到我的工作不是做漂亮的 PPT，而是交付代码。在最初的 12 到 18 个月里，我在这方面做得并不好。但我认为在硅谷或更广泛的科技公司中，存在一种相反的教条，即“战略很简单，执行才是一切”。

---

### (00:44:46) Jag Duggal

**English:**
And I think that's probably because there are a small number of companies that get the strategy right, but the legendary companies that we all know about not only got the strategy right, but then executed it really crisply. What we don't hear about are the companies that got the strategy wrong, never got even into the conversation and all of their great execution was multiplied by zero. Great execution multiplied by a poor strategy is a waste of everyone's time. And because the strategy isn't clear, you can waste a lot of time executing years and years against something that was destined never to work.

**中文翻译:**
我认为这可能是因为只有少数公司能制定正确的战略，而我们熟知的那些传奇公司不仅战略正确，而且执行得非常利落。我们没听说过的是那些战略错误的公司，它们甚至从未进入过大众视野，它们所有伟大的执行力都被乘以了零。伟大的执行力乘以糟糕的战略是对所有人时间的浪费。正因为战略不清晰，你可能会浪费数年时间去执行一个注定不会成功的东西。

---

### (00:45:41) Jag Duggal

**English:**
One of my favorite quotes from the Valley, from Kevin Systrom in the early days of Instagram, I heard him say it at a conference, this is pre the Facebook acquisition. And he was like, I don't know how old. He had just left Google. He was probably, I don't know, 20 some years old. He said, "We may not be right, but at least we are clear." And what I love about that is even if your strategy isn't right, and it will never be exactly right because no plan ever is, you will have a clearer read on if you are going off course because you have a very clear idea of what was supposed to be happening.

**中文翻译:**
我最喜欢的硅谷名言之一来自 Instagram 早期的凯文·斯特罗姆。我在一次会议上听他说的，那是 Facebook 收购之前。他当时刚离开 Google，大概二十多岁。他说：“我们可能并不正确，但至少我们很清晰。”我喜欢这句话的原因是，即使你的战略不正确（它永远不会完全正确，因为没有完美的计划），你也会更清楚自己是否偏离了航向，因为你对“应该发生什么”有一个非常清晰的认知。

---

### (00:46:34) Jag Duggal

**English:**
And so I think being very clear in your strategy is really important. You've had some great guests on the podcast. Richard Rumelt is one of my absolute favorites. He's written a couple of books, one called Good Strategy Bad Strategy, another more recent one called The Crux, where he does a great service to the world by even more than describing what strategy is, focusing at the beginning about what strategy isn't. Strategy isn't an ambitious goal, it's not an aspiration, it's not a set of financial outcomes. It is a coherent plan for how you going to apply your strengths in a leveraged way against a core important problem. And that's a very, very rough paraphrase of the way he thinks about the world.

**中文翻译:**
所以我认为战略的清晰度非常重要。你的播客请过一些很棒的嘉宾。理查德·鲁梅尔特（Richard Rumelt）是我最喜欢的作者之一。他写了几本书，一本叫《好战略，坏战略》，另一本较新的是《关键点》（The Crux）。他为世界做出了巨大贡献，不仅描述了什么是战略，更在开头强调了战略“不是”什么。战略不是一个雄心勃勃的目标，不是一个愿望，也不是一系列财务结果。它是一个连贯的计划，关于你如何杠杆化地利用自己的优势去解决一个核心的重要问题。这是对他思想的一个非常粗略的转述。

---

### (00:46:55) Jag Duggal

**English:**
And I find that we often confuse strategy with a vision, a broad idea, a very, very broad, vague aspiration. Nubank strategy isn't we want to be the world's largest neo bank. We do, but that's not an interesting way to dimensionalize the problem. In 2014, we had millennial, middle-class, urban Brazilians who hated paying credit card fees and were not able to get credit in the first place because they were too young and without a credit history. And we could offer them not just a lower-priced credit card, but a no-fee credit card, which was an emotional thing. That fee got people angry and we could do that because we were branchless and digital.

**中文翻译:**
我发现我们经常把战略与愿景、宏大的想法或模糊的愿望混为一谈。NuBank 的战略不是“我们想成为全球最大的数字银行”。我们确实想，但那不是量化问题的有趣方式。2014 年，我们的目标是巴西城市里的中产阶级千禧一代，他们讨厌支付信用卡费，而且因为太年轻、没有信用记录而无法获得信用额度。我们可以为他们提供不仅价格更低，而且免年费的信用卡。免年费是一件带有情感色彩的事，因为那些费用让人愤怒。我们能做到这一点，是因为我们没有线下网点，是纯数字化的。

---

### (00:47:30) Jag Duggal

**English:**
Now that is a coherent description of a very specific problem for a very specific set of customers with a very specific solution based on a very specific advantage. By the way, all of this predated my, this has got nothing to do with me. I wasn't there. But that's what I mean. Strategy is very specific, it's very detailed, it's very locked in. And working backwards from that I think is really, really important. And if you get that strategy right, it informs the minimal set of activities you need to do to get traction and to win.

**中文翻译:**
这才是对一个特定问题的连贯描述：针对特定客户群，基于特定优势，提供特定的解决方案。顺便说一下，这些都发生在我加入之前，跟我没关系。但这就是我的意思：战略是非常具体、详细且确定的。我认为从那个目标倒推（working backwards）非常重要。如果你制定了正确的战略，它会告诉你为了获得动力并获胜，你需要做的最小活动集是什么。

---

### (00:48:00) Jag Duggal

**English:**
Whereas if you don't have that degree of coherence, you're trying to serve all the customers. Maybe we should go to Mexico prematurely. All sorts of things happen and your execution gets very diffuse, and you can't even tell why you're not getting traction across the company, whereas strategy allows focus and it allows a much more rapid read of whether your focused bets, your concentrated bets, are actually working.

**中文翻译:**
反之，如果你缺乏这种连贯性，你就会试图服务所有客户。比如可能会过早地进入墨西哥市场。各种事情都会发生，你的执行力会变得非常分散，你甚至说不清楚为什么公司整体没有进展。而战略能让你专注，让你能更快速地判断你的重点投注、你的集中投注是否真的奏效。

---

### (00:48:36) Jag Duggal

**English:**
You've had some investors on your podcast over the years, and they will tell you that concentration is what builds wealth, diversification is what preserves wealth. And you're a startup. You're not trying to preserve anything. You're trying to build something. It requires concentrated bets, not hedging. And because you're concentrating bets, those bets are high stakes. You need to be very, very clear on what bets you're making and why you think it's going to succeed.

**中文翻译:**
这些年来你的播客请过一些投资者，他们会告诉你：集中（concentration）创造财富，多元化（diversification）守护财富。而你是一家初创公司，你不是在守护什么，你是在创造。这需要集中的投注，而不是对冲。正因为你集中投注，这些投注的赌注很高。你需要非常清楚自己在投什么，以及为什么认为它会成功。

---

### (00:49:05) Lenny Rachitsky

**English:**
When you work with PMs on your team in the past that are trying to get better at this muscle and following this advice that you're sharing of strategy, what do you find most helps them build this muscle? Is it just doing it over and over and over and over? Is it reading good strategy, bad strategy, practicing it? What do you find is most helpful in helping you build this muscle?

**中文翻译:**
当你过去与团队中想要提高战略思维、遵循你这些建议的 PM 合作时，你发现什么最能帮助他们锻炼这种能力？是不断重复地去做？是阅读《好战略，坏战略》并练习？你觉得什么最有效？

---

### (00:49:25) Jag Duggal

**English:**
One is taking it seriously. It's a little bit like what we talked about with Nubank's culture. First, you got to want the customer to love you fanatically as something that you value. After that, I think frameworks really help, whether it's Good Strategy, Bad Strategy, whether it's Play to Win from a relatively recent guest of yours, Christopher Lochhead, who I really admire, whether it's Where to Play and How to Win from Roger Martin, which is a phenomenal book about-

**中文翻译:**
首先是认真对待它。这有点像我们谈到的 NuBank 文化：你首先得把“让客户疯狂爱上你”作为一种价值观。在那之后，我认为框架（frameworks）非常有帮助。无论是《好战略，坏战略》，还是你最近的嘉宾克里斯托弗·洛克海德（Christopher Lochhead，我非常钦佩他）的《Play to Win》，或者是罗杰·马丁（Roger Martin）的《Where to Play and How to Win》，那是一本关于……的杰作。

---

### (00:49:53) Lenny Rachitsky

**English:**
He's coming on the podcast in a few weeks.

**中文翻译:**
他几周后就会来上节目。

---

### (00:49:55) Jag Duggal

**English:**
Is he? He's fantastic. And having those frameworks, all of which in many ways, if you synthesize them, are getting at the same thing around focus, around a clear understanding of the customer, around not trying to be in the words that we literally have on Nubank coffee mugs, "We're not trying to be incrementally better. We are trying to be fundamentally different." These are all very similar ideas expressed in slightly different ways.

**中文翻译:**
是吗？他太棒了。拥有这些框架非常重要。如果你综合这些框架，它们在很多方面都在强调同样的事情：专注、清晰理解客户、不要试图变得“更好一点”。正如我们 NuBank 咖啡杯上印的那句话：“我们不追求更好一点，我们追求本质不同。”这些都是用略微不同的方式表达的相似理念。

---

### (00:50:26) Jag Duggal

**English:**
Once you understand the frameworks and you distill them, then it's about practicing them and practicing them is scary. Hedging is appealing. Hedging means you don't have to make choices. Hedging sounds smart. Concentrating all your bets is the thing that desperate people do, and startups are desperate entities because they're burning cash in almost every instance. But successful startups, the ones that become profitable... I'm very wary, given the places I've worked, of the successful company with one or two monster products, and Nubank is now in that fortunate position, that starts to get conservative, that starts to forget that focus, concentration, customer obsession are every bit as important, that even though the company won't go bankrupt if products three, four, five and six don't succeed because products one and two are monster cashflow drivers, that's a slow path to death.

**中文翻译:**
一旦你理解并提炼了这些框架，接下来就是练习，而练习是很可怕的。对冲（Hedging）很有诱惑力，因为对冲意味着你不需要做选择，听起来很聪明。而集中所有赌注是绝望的人才会做的事，初创公司本质上就是绝望的实体，因为它们几乎总是在烧钱。但成功的初创公司，那些实现盈利的公司……考虑到我工作过的地方，我非常警惕那些拥有一两个“怪兽级”产品后就开始变得保守的成功公司（NuBank 现在正处于这种幸运的地位）。它们开始忘记专注、集中和客户痴迷同样重要。即使产品 3、4、5、6 失败了公司也不会破产，因为产品 1 和 2 是巨大的现金流来源，但这其实是通往死亡的慢性道路。

---

### (00:51:37) Jag Duggal

**English:**
And so practicing that discipline and having, and I use this word very intentionally, having the courage to make those hard choices and to concentrate the bets, which goes against, by the way, a lot of what's taught in business school and a lot of MBAs is really important, and then it's a matter of you get better the more you do it and you get more practiced and more grooved and more principled in how you get to a methodology the more you do it.

**中文翻译:**
所以，练习这种自律，并且——我非常刻意地使用这个词——拥有做出艰难选择和集中投注的“勇气”非常重要。顺便说一下，这与商学院和很多 MBA 课程教的东西是相反的。然后，这就是一个熟能生巧的过程，你做得越多，就会变得越专业、越有条理、越有原则。

---

### (00:52:16) Lenny Rachitsky

**English:**
Did you say the mugs at Nubank say, "Be fundamentally different"?

**中文翻译:**
你是说 NuBank 的杯子上印着“本质不同”吗？

---

### (00:52:22) Jag Duggal

**English:**
The product team, a little over a year ago we put together some schwag, which was fundamentally ... I have a mantra within the company since roughly the time I joined, which is, "We're in the business of being fundamentally different, not incrementally better." Again, it goes back to only fundamentally different, gets customers to tell their friends. Incrementally better.

**中文翻译:**
产品团队在大约一年前做了一些周边。自从我加入公司以来，我一直有一个口号：“我们的业务是追求本质不同，而不是更好一点。”再次强调，只有本质的不同才能让客户告诉他们的朋友。

---

### (00:52:46) Jag Duggal

**English:**
And by the way, there are certain features ... I don't want to overstate the case ... There are certain features where you're in the incrementally better business. Not every single thing of the hundred things you launch in a year can be fundamentally different, but we're searching for those anchors that are going to be fundamentally different all the time around which you build some sustaining innovation as well, but we are in the fundamentally different business, not the incrementally better business.

**中文翻译:**
顺便说一下，我不想夸大其词，确实有些功能属于“更好一点”的范畴。你一年发布的 100 个东西里，不可能每一个都是本质不同的。但我们一直在寻找那些能够成为本质不同的“锚点”，围绕这些锚点你也可以进行一些持续性创新。但总体而言，我们从事的是本质不同的业务，而不是更好一点的业务。

---

### (00:53:10) Lenny Rachitsky

**English:**
I love that, and that's a great segue to where I wanted to go, which is I know you're a big fan of category design. You mentioned Christopher Lochhead, former guest. This is actually one of the more common debates on this podcast of do people believe in we should be creating our own category or should we not? Is that a terrible idea? Is it a good idea? It feels like you're in the camp of this is actually very good and important. I'd love to hear your perspective and also just how Nubank did this.

**中文翻译:**
我喜欢这个观点，这正好引出了我想聊的话题：我知道你是“品类设计”（Category Design）的忠实粉丝。你提到了之前的嘉宾克里斯托弗·洛克海德。这实际上是本播客中最常见的辩论之一：人们是否相信我们应该创建自己的品类？这是一个糟糕的主意还是个好主意？感觉你属于“这非常棒且重要”的那一派。我很想听听你的看法，以及 NuBank 是如何做到这一点的。

---

### (00:53:36) Jag Duggal

**English:**
You know Lenny, literally earlier in this week, I was listening to your podcast with I believe it was Todd Jackson, ex Gmail product leader and now venture capitalist, and you guys had a very interesting discussion about it, and I think he took largely the other side of the argument that you go in a category where customers are already spending money. And it's hard to argue with that fairly robust logic.

**中文翻译:**
Lenny，就在本周早些时候，我听了你和 Todd Jackson（前 Gmail 产品负责人，现为风险投资人）的那期播客。你们对此进行了非常有趣的讨论。我认为他基本上持相反观点，即你应该进入一个客户已经在花钱的品类。这种逻辑非常稳健，很难反驳。

---

### (00:54:03) Jag Duggal

**English:**
I will tell you how I think about it. It forced me to think about where are the nuances in how I believe. I think overall, particularly at a company level, successful companies are typically in the fundamentally different business. They're in the new category business. Google was in the new category business. Netflix, Airbnb, you can go down the long list, Salesforce, et cetera, et cetera. That's really important.

**中文翻译:**
我告诉你我是怎么想的。这迫使我思考我的信念中那些细微的差别。我认为总的来说，特别是在公司层面，成功的公司通常从事的是“本质不同”的业务。它们从事的是“新品类”业务。Google 曾是新品类业务，Netflix、Airbnb、Salesforce 等等也是如此。这非常重要。

---

### (00:54:31) Jag Duggal

**English:**
In Nubank's case, we were the first, and actually, it's not that important that we were the first, but we were very intentionally trying to build a branchless bank based on the rise of the smartphone in Brazil and Latin America at that time, the sort of rapid inflection, and a branchless bank that could bring, as David likes to say, put a bank branch in your pocket, where at the time access was the big problem, and that you could do that on a digital cost structure that allowed you to essentially disruptively price across the board was the thing that led to the massive wave of success, multiplied by, unlike almost everywhere else in the world, including in the US where the answer was, "We're going to do the bank account first." Nubank's answer was, "No, we're going to do credit first and credit is 10 times harder and 100 times more risky," because you get credit wrong as a young company that doesn't know how to do it yet, you've blown everything up. The money's never coming back. Those two, again, concentrated bets, defining a new category, were I think the key to our success.

**中文翻译:**
以 NuBank 为例，我们是第一家（其实是不是第一家并不那么重要），但我们非常刻意地尝试基于当时巴西和拉美智能手机的兴起构建一家无网点银行。正如 David 喜欢说的，把银行网点装进你的口袋。当时“获取服务”是大问题，而通过数字化的成本结构，你可以实现颠覆性的全线定价。这就是带来巨大成功的关键。再加上一点：与世界上几乎其他任何地方（包括美国）先做银行账户的做法不同，NuBank 的回答是：“不，我们要先做信用（Credit）。”信用业务的难度是 10 倍，风险是 100 倍。因为作为一家还没学会怎么做信用的年轻公司，一旦搞砸了，一切就全完了，钱永远回不来。这两个集中的投注——定义新品类，我认为是我们成功的关键。

---

### (00:55:56) Jag Duggal

**English:**
Now, there are times when you're trying to go into an adjacent market. We've recently gone into a market called Consignado in Brazil, which is secured lending for government employees. Very stable job, easier to underwrite against their salary at a much lower interest rate. That's a market that's existed for a couple of decades in Brazil, and our job was to go in there, and we believe we built something that is fundamentally different. It wasn't digital. It went through middlemen. We built it D to C, and we've been able to undercut the pricing pretty dramatically.

**中文翻译:**
当然，有时你也会尝试进入相邻市场。我们最近进入了巴西一个叫 Consignado 的市场，即针对政府雇员的担保贷款。他们的工作非常稳定，更容易根据工资进行承保，利率也低得多。这个市场在巴西已经存在了几十年。我们的工作是进入其中，并构建一些本质上不同的东西。以前它不是数字化的，要通过中间人。我们把它做成了 D2C（直接面向消费者），并且能够大幅降低价格。

---

### (00:56:38) Jag Duggal

**English:**
So even within an established category, we've tried to build a fundamentally different experience, but there are also times when, look, it's not quite me too, but the differentiation's a bit more incremental. But at the company level, I think it's absolutely imperative to be designing your own category so you can then dominate it and defining your own category. And even when you're entering a place where customers are spending money, I think going in with a mindset that says, "This is going to be a bit better," and I think Todd would probably agree with this, given the way he described it, you should try to be reinventing that category, even if you're not inventing that category.

**中文翻译:**
所以即使是在一个成熟的品类中，我们也尝试构建本质不同的体验。当然也有时候，虽然不是完全的模仿（me-too），但差异化确实更偏向渐进式。但在公司层面，我认为绝对有必要设计并定义自己的品类，从而实现统治。即使你进入的是一个客户已经在花钱的领域，与其抱着“我要做得好一点”的心态，不如尝试去“重新发明”那个品类，即使你不是那个品类的发明者。我想 Todd 也会同意这一点。

---

### (00:57:19) Lenny Rachitsky

**English:**
Amazing. I like this battle we're forming here of people on two sides of this debate, and I'm excited to see where it goes over time. It feels like the do not create a category side is winning so far in terms of volume, but there's a lot of passion from this other side.

**中文翻译:**
太棒了。我喜欢这里形成的辩论阵营，我很期待随着时间的推移它会如何演变。目前看来，从数量上看，“不要创建品类”那一派似乎占了上风，但另一派也充满了激情。

---

### (00:57:35) Jag Duggal

**English:**
I'm happy to be on the contrarian side.

**中文翻译:**
我很乐意站在少数派（contrarian）这一边。

---

### (00:57:37) Lenny Rachitsky

**English:**
Okay, there's a few more things I want to touch on before we wrap up. It feels like Nubank is one of the historically most successful companies launching new business lines. I think you guys are maybe like 10 years old, and how many products slash business lines are there at this point?

**中文翻译:**
好的，在结束前我还有几件事想聊。感觉 NuBank 是历史上推出新业务线最成功的公司之一。我想你们大概成立 10 年了，目前有多少个产品或业务线？

---

### (00:57:53) Jag Duggal

**English:**
It depends on how you categorize it, but I would say we have roughly a dozen to 20 core product lines.

**中文翻译:**
这取决于你如何分类，但我会说我们大约有 12 到 20 条核心产品线。

---

### (00:58:01) Lenny Rachitsky

**English:**
Okay, that's wild.

**中文翻译:**
好的，这太惊人了。

---

### (00:58:05) Jag Duggal

**English:**
Our story started as, we were a Brazilian credit card monoliner in an app and all the rest of it. Around the time, slightly before, but around the time I joined the phase two of the company, the mandate of what we were trying to do, which has really been the story of the last five years, was we were going to go from a Brazilian credit card company to a full solution Latin American bank, which meant we launched five new products. We launched a bank account, which allowed us to go from being a secondary banking relationship to increasingly a primary banking relationship. About half of our 90 plus million customers, we are the primary relationship. We built a lending product, we built an investments product, we built an insurance product, we built a series of small business products.

**中文翻译:**
我们的故事始于一家只做巴西信用卡的单一产品公司。在我加入前不久，也就是公司进入第二阶段时，我们过去五年的使命是从一家巴西信用卡公司转型为全方位的拉美银行。这意味着我们推出了五款新产品。我们推出了银行账户，这让我们从客户的次要银行关系逐渐变成了主要银行关系。在我们 9000 多万客户中，约有一半将我们视为主要银行。我们还构建了贷款产品、投资产品、保险产品以及一系列小微企业产品。

---

### (00:58:53) Jag Duggal

**English:**
While we were doing that, we were also making the leap to prove, despite a lot of skepticism, that our business model was exportable and not a unique Brazilian phenomenon. So we launched into Mexico and launched into Colombia and now we are starting to take the full suite of products and go beyond credit card in Mexico and Colombia as well.

**中文翻译:**
在做这些的同时，我们还实现了一个跨越：证明了尽管有很多质疑，我们的业务模式是可以出口的，而不仅仅是巴西特有的现象。所以我们进入了墨西哥和哥伦比亚，现在我们也开始在这些国家提供全套产品，而不仅仅是信用卡。

---

### (00:59:16) Jag Duggal

**English:**
So depending on how you look at that matrix, we are a dozen plus products and we're working on the phase three of our products, which is moving beyond financial services. We've launched an e-commerce marketplace within our app, which is perhaps a bit counterintuitive if you're coming from the US. And we're also envisioning a world where banking is, again, to use the phrase that we love at Nubank, fundamentally different than it has been in the last 100 years. And we believe that social technology, self-driving and AI technologies can build a just completely different experience, where we're not building a bank branch and putting it in your pocket. We're building a personal banker, which today, I don't know, 10 million people around the world have access to and you got to have a lot of money to do it.

**中文翻译:**
所以根据你如何看待这个矩阵，我们有十几个产品。我们正在开发第三阶段的产品，即超越金融服务。我们在应用内推出了电子商务市场，如果你来自美国，这可能有点反直觉。我们还在构想一个银行业务在未来 100 年里发生本质变化的世界。我们相信社交技术、自动驾驶（self-driving）和 AI 技术可以构建一种完全不同的体验。我们不是在构建一个装在口袋里的银行网点，而是在构建一个“私人银行家”。目前全球可能只有 1000 万人能享受到这种服务，而且你必须非常有钱才行。

---

### (01:00:13) Jag Duggal

**English:**
We believe that job can be democratized ultimately to all eight billion people on the planet, and we believe it can be done better for those eight billion even than the 10 million are getting today. But that's a lot of work, and that's, to use Christopher Lochhead and his co-author's language, that's the new category that we are trying to define over on a global basis.

**中文翻译:**
我们相信这项服务最终可以普及到全球 80 亿人，而且我们相信为这 80 亿人提供的服务甚至可以比今天那 1000 万人得到的更好。但这需要大量工作。用克里斯托弗·洛克海德的话说，这就是我们试图在全球范围内定义的新品类。

---

### (01:00:41) Lenny Rachitsky

**English:**
It's going to be a tiny little banker to fit in your pocket, tiny little person.

**中文翻译:**
那会是一个能装进兜里的小小银行家，一个小人儿。

---

### (01:00:45) Jag Duggal

**English:**
That's it.

**中文翻译:**
就是这样。

---

### (01:00:46) Lenny Rachitsky

**English:**
I want to follow on this thread, but before we get there, so in terms of adding new product lines and business units, watching how Nubank has done this, is there something you've learned about just how to do this well? I'm imagining there's a spreadsheet where, "Here's all the things we're going to do in the future. Here's how we're thinking about all the factors of all the new businesses we can launch." Is there anything there you've seen of just like, wow, that's a really smart way of thinking about the sequencing slash where to expand next that you think other folks can learn from?

**中文翻译:**
我想继续这个话题，但在那之前，关于增加新产品线和业务单元，观察 NuBank 的做法，你学到了什么关于如何做好这件事的经验吗？我能想象有一个电子表格，上面写着“这是我们未来要做的事，这是我们对所有新业务因素的思考”。你有没有发现什么特别聪明的思考顺序或扩张方向的方法，是值得别人学习的？

---

### (01:01:17) Jag Duggal

**English:**
I wish I could tell you that there was this predestined master plan that was so scientific. The reality is smart people around the table with a culture of robust debate and real candor about the pros and cons is how we went about it, and a constant re-examination of how things are going, what's going well, what's not going well, what's taking off, what's not yet taking off, what are the principles by which we're making these decisions has been important.

**中文翻译:**
我真希望我能告诉你有一个预先设定的、非常科学的宏伟蓝图。但现实是，一群聪明人围坐在一起，拥有激烈辩论的文化，对优缺点保持坦诚，这就是我们的做法。不断重新审视进展、什么是好的、什么是不好的、什么是爆发的、什么是还没起色的，以及我们做决策的原则，这些才是最重要的。

---

### (01:01:51) Jag Duggal

**English:**
Some of these things are obvious. If you're running a bank, a bank account is probably a good product at some stage, but a lot of it in terms of sequencing and when we invest where, some of it's obvious, what's the TAM and where's the customer paying, but a lot of it is art and a lot of that resolution of the art and the debate. It comes from a fairly robust debate, so I'm avoiding your question. I have no good answer.

**中文翻译:**
有些事情是显而易见的。如果你经营一家银行，银行账户在某个阶段肯定是个好产品。但在排序和投资时机方面，虽然有些显而易见（比如市场规模 TAM 是多少，客户在哪里付钱），但很大程度上是一种艺术，是辩论的结果。它源于相当激烈的辩论，所以我其实是在回避你的问题，我没有一个标准答案。

---

### (01:02:24) Lenny Rachitsky

**English:**
Just a lot of complicated decision making, but I think what's interesting is, coming back to your very early lesson, is using the gate of is this hitting this 50% of people be very disappointed before launching feels like a key.

**中文翻译:**
只是很多复杂的决策。但我觉得有趣的是，回到你早期的经验，在发布前使用“是否有 50% 的人会感到非常失望”这个关卡，似乎是关键。

---

### (01:02:36) Jag Duggal

**English:**
Yeah. That's the one thing is we try not to scale big problems, and so we try to solve our problems when things are small. Our ultra violetta are higher income, rewards-based credit card. We launched, it happened to be, I think it was July 4th, 2021 was the launch date, so it's easy for me to remember. We started scaling it two to two and a half years later.

**中文翻译:**
是的。有一点就是我们尽量不把大问题规模化，所以我们尝试在问题还小的时候解决它。我们的 Ultravioleta 高收入奖励信用卡，发布日期我记得很清楚，是 2021 年 7 月 4 日。我们是在两到两年半之后才开始大规模推广它的。

---

### (01:03:04) Jag Duggal

**English:**
In the meantime, we were in the lab figuring out where's the product market fit? Why is it not resonating? Oh, it's resonating with these guys. What do they particularly love it? Let's iterate there. And now we're at a point in the last six to nine months where we can start scaling aggressively, learning some of the credit dynamics that are different and reinventing some of those methodologies, and there's a second phase of scaling that will come. But yeah, one form of distraction we don't get into is fixing massive problems that we've overscaled before they were ready. That's a bit of an overstatement, but nothing's quite that clean, but generally true.

**中文翻译:**
在那期间，我们一直在实验室里研究：PMF 在哪里？为什么它没有引起共鸣？哦，它在这些人群中引起了共鸣，他们特别喜欢什么？让我们在那里迭代。直到过去的 6 到 9 个月，我们才开始激进地规模化，学习不同的信用动态并重新发明相关方法论。接下来还会有第二阶段的规模化。但没错，我们不会陷入的一种干扰就是去修复那些在准备好之前就被过度规模化的巨大问题。这可能有点夸张，现实没那么非黑即白，但大体上是正确的。

---

### (01:03:46) Lenny Rachitsky

**English:**
Coming back to your thoughts on the future of FinTech and in LATAM especially, you talked about how the vision is essentially a banker in everyone's pocket. Is there anything more there? Just where do you think all this goes in the future in terms of FinTech banking for people in LATAM and then globally?

**中文翻译:**
回到你对金融科技未来的看法，特别是在拉美，你提到愿景本质上是让每个人的口袋里都有一个银行家。还有什么补充吗？你认为拉美乃至全球的金融科技银行未来会走向何方？

---

### (01:04:05) Jag Duggal

**English:**
Yeah, there are a handful of principles, call them hypotheses, that we believe, and there are, I should be super clear, unproven hypotheses that will take years for us to prove out, and I'm sure there will be pivots along the way as we learn that things aren't quite the way we would've hoped at the beginning. But first off, the idea that banking should be holistic, that we need to provide a full solution across what we call the five or six financial seasons of someone's life, right? We spend, we save, we invest, we borrow, we protect, et cetera. And that's a lot of what we've been working on for the last handful of years.

**中文翻译:**
是的，我们相信一些原则，或者说假设。我必须非常明确，这些是尚未证实的假设，需要数年时间去验证，而且我确信在这个过程中会有转型，因为我们会发现事情并不完全像我们最初希望的那样。但首先，银行业务应该是整体性的（holistic），我们需要在人生的五个或六个“财务季节”提供完整的解决方案：消费、储蓄、投资、借贷、保障等等。这就是我们过去几年一直在努力的方向。

---

### (01:04:52) Jag Duggal

**English:**
So one is we want to be a full solution bank. Second, something we have started, we have had some real success in on the business side, we've made some mistakes on the technical side that we are iterating through is, we are trying to build, and some might argue I'm overstating a bit, but just to be clear, we are trying to build what we believe is the first global bank on a single code base.

**中文翻译:**
第一，我们想成为一家全能解决方案银行。第二，我们在业务端取得了一些成功，但在技术端也犯过一些错误并正在迭代，那就是：我们正尝试构建我们认为的全球第一家基于“单一代码库”的全球银行。

---

### (01:05:22) Jag Duggal

**English:**
I come from a world places like Google and Facebook, Google, my first product management experience. I was not allowed to launch unless my product was ready for 40 countries and 40 languages. I believe language number 40 was Finnish, so we were always making sure the thing worked in Finnish. And there are good reasons why ADVA, global online advertising, worked that way. It was a great principle by Google.

**中文翻译:**
我来自 Google 和 Facebook 这样的公司。在 Google，我的第一个产品管理经验是：除非我的产品准备好支持 40 个国家和 40 种语言，否则不允许发布。我记得第 40 种语言是芬兰语，所以我们总是要确保它在芬兰语下能运行。全球在线广告业务那样运作是有充分理由的，那是 Google 的一个伟大原则。

---

### (01:05:50) Jag Duggal

**English:**
When you get into FinTech and into banking where the regulations are very local, where the stakes are much higher, that you serve the right 300 by 250 ad, there is a lot of pushback on that kind of, "We're just going to scale this everywhere," sort of mindset. And so how do you marry those two things? There are global banks like Citi or Santander, a lot of them have been built up through acquisition. A lot of them are on distinct code bases and technology infrastructures. We believe there's a lot of leverage if you can build a global bank on a single code base. That's another principle that we are trying to make real.

**中文翻译:**
但当你进入金融科技和银行业，那里的监管非常本地化，风险比投放一个 300x250 的广告要高得多。对于那种“我们要把它推广到全球”的心态，会有很多阻力。那么你如何结合这两者呢？像花旗（Citi）或桑坦德（Santander）这样的全球性银行，很多是通过收购建立起来的，它们拥有不同的代码库和技术基础设施。我们相信，如果你能在单一代码库上构建全球银行，会有巨大的杠杆效应。这是我们试图实现的另一个原则。

---

### (01:06:34) Jag Duggal

**English:**
The third is that social mechanics around your financial life, not in general, not another WhatsApp, not another Twitter, and self-driving automation. Why do I have to remember to pay this bill every month? Why do I have to remember to save for my child's university education every month? Why can't I keep my life goals really well-organized? Which is almost impossible to do. My wife and I open up different bank accounts at different banks just to try to do that job, which is, talk about customer workarounds. How do we make the life life cycle of managing your financial life exponentially easier, leveraging these technologies and then using AI, which is an overhyped term right now, but AI to turbo-boost these tasks?

**中文翻译:**
第三是围绕财务生活的社交机制（不是泛泛而谈，不是再做一个 WhatsApp 或 Twitter）以及“自动驾驶”式的自动化。为什么我每个月都要记住付账单？为什么我每个月都要记住为孩子的大学教育存钱？为什么我不能让我的生活目标井井有条？这几乎是不可能做到的。我和妻子在不同的银行开了不同的账户，只是为了实现这个目标，这就是典型的“客户凑合方案”。我们如何利用这些技术，以及利用 AI（虽然现在这个词被过度炒作了）来加速这些任务，让管理财务生活的生命周期变得指数级简单？

---

### (01:07:40) Jag Duggal

**English:**
We have a phrase we've started using at Nubank, which I really like. David first introduced it. Customers everywhere around the world live harshly unoptimized financial lives. I think that's true regardless of income level, regardless of geography, regardless of sort of life stage of where people are at. If you have a young child, it is very hard to keep track of all the things you should be doing. You should be opening a savings account of a specific kind that stacks advantage in this way.

**中文翻译:**
我们在 NuBank 开始使用一句话，我非常喜欢，是 David 最先提出的：全世界的客户都过着“极度未优化”的财务生活。我认为无论收入水平、地理位置或人生阶段如何，这都是事实。如果你有个年幼的孩子，你很难追踪所有该做的事，比如你应该开一个特定类型的储蓄账户，以这种方式累积优势。

---

### (01:08:16) Jag Duggal

**English:**
These are problems that should be solved and should be solved soon and can be automated and where insights can be brought to bear for customers who are not super sophisticated in their level of financial education, which by the way is almost all of us. Some of the people who think they're the most sophisticated are the ones who burn the most money in casinos that they call the stock market.

**中文翻译:**
这些问题应该被解决，而且应该尽快解决。它们可以被自动化，并且可以为那些金融教育水平不高的客户提供洞察——顺便说一下，我们几乎所有人都是这样。有些自认为最精明的人，反而在他们称之为“股市”的赌场里亏钱最多。

---

### (01:08:42) Jag Duggal

**English:**
And so these are some of the principles around which we are the next phase. What if there were someone right next to you who could tell you what the smart move was to make today at this life stage? You've just had a child, you've just gotten married, you've just bought a house, you just want to remodel, whatever it might be. We think the technology is there or thereabouts to be able to do that. Why not have the company that reinvents banking come out of Sao Paulo, Mexico City, Bogota? Why does it have to come out of San Francisco, New York or London? We see no reason why it can't be us, so we're going to give it a whirl.

**中文翻译:**
所以这些就是我们下一阶段的一些原则。如果有一个人就在你身边，能告诉你在这个人生阶段今天最明智的举动是什么，那会怎样？你刚有了孩子，刚结婚，刚买房，或者想装修。我们认为技术已经接近实现这一目标了。为什么重新发明银行业务的公司不能来自圣保罗、墨西哥城或波哥大？为什么非得是旧金山、纽约或伦敦？我们看不出为什么不能是我们，所以我们要试一试。

---

### (01:09:23) Lenny Rachitsky

**English:**
Amazing. I love all of this. I can't wait for this to be real. You mentioned AI, so I just have a couple more questions. You mentioned AI. We have a recurring segment on this podcast called AI Corner, so let's walk over to AI Corner.

**中文翻译:**
太棒了，我喜欢这些，等不及看它实现了。你提到了 AI，我还有几个问题。我们播客有一个固定环节叫“AI 角落”，让我们移步到那里。

---

### (01:09:35) Jag Duggal

**English:**
All right.

**中文翻译:**
好的。

---

### (01:09:36) Lenny Rachitsky

**English:**
Usually I ask how you use AI in your day-to-day and your team, just like what are the tools and things you find useful to help your team operate with AI and tooling, but I'm also curious just how you're integrating AI into the product. You touched on this a little bit, but just how AI is going to supercharge the stuff that you're building.

**中文翻译:**
通常我会问你在日常工作和团队中如何使用 AI，比如哪些工具对团队运营有帮助。但我也很想知道你们是如何将 AI 整合到产品中的。你刚才提到了一点，但 AI 到底会如何增强你们正在构建的东西？

---

### (01:09:52) Jag Duggal

**English:**
We use some of the tools that everyone is using these days. Our ringfenced version of Chat GPT and some of the standard tools, we're using them in some of the obvious initial wave ways. How can we improve our customer experience? If you're fanatical about customers, you're fanatical about customer experience, and Nubank has always been that way. How can we make it even better while we're also making it more efficient? So we're doing all of those things as part of our coming up the learning curve in the last 18 or so months.

**中文翻译:**
我们使用一些大家都在用的工具，比如我们内部隔离版的 ChatGPT 和一些标准工具。我们正在以一些显而易见的第一波方式使用它们。比如如何改善客户体验？如果你对客户狂热，你就会对客户体验狂热，NuBank 一直如此。我们如何在提高效率的同时让体验更好？在过去的 18 个月里，作为学习曲线的一部分，我们一直在做这些事情。

---

### (01:10:35) Jag Duggal

**English:**
And then we're starting to think about what are the ways in which we can build AI native products. And I will not pretend to you that we've cracked that code, but a former boss of mine spoke a while ago, Fidji Simo, who's now the CEO of Instacart, but she was talking about the evolution when she was the product lead for Facebook Ads back when the big migration from the desktop to mobile was happening, and she talked about we needed to become mobile native.

**中文翻译:**
然后我们开始思考如何构建“AI 原生”（AI native）的产品。我不会假装我们已经破解了这个难题，但我以前的一位老板 Fidji Simo（现任 Instacart CEO）曾谈到过，当她担任 Facebook 广告产品负责人时，正值从桌面端向移动端大迁移的时期，她说我们需要变得“移动原生”。

---

### (01:11:12) Jag Duggal

**English:**
And by analogy, companies today need to figure out what does AI native mean, not how do we append AI at the corners of the product, but how do we build it at the heart? What would you design if these tools existed from the start? I mean, Facebook's migration to mobile is a phenomenal example of that pivot. And they like to joke, and I wasn't there at Facebook at the time, but they liked to joke at Facebook, even seven, eight years later when I joined, about the company had IPO'd and needed to find a business model and Fidji was responsible for making that happen. And the core of it was bringing this mobile native mindset. So we are trying to think through what is an AI native mindset? In financial services, what would that look like? And that requires ...

**中文翻译:**
类比一下，今天的公司需要弄清楚“AI 原生”意味着什么。不是如何在产品的角落里塞进 AI，而是如何将其构建在核心位置？如果这些工具从一开始就存在，你会如何设计？Facebook 向移动端的迁移是这种转型的绝佳例子。我加入 Facebook 时，大家还在开玩笑说公司上市后需要寻找商业模式，而 Fidji 负责实现了这一点。其核心就是引入了“移动原生”的心态。所以我们正在思考什么是“AI 原生”心态？在金融服务领域，那会是什么样子？这需要……

---

### (01:12:00) Jag Duggal

**English:**
... services. What would that look like? And that requires analysis as much as analogy, and we are very much in the middle of that process and we don't know all of the answers. The metaphor of a what if everyone in the world, regardless of their income or wealth, had a private banker sat next to them that they could turn to whenever they needed to is a good metaphor. And so we are using that metaphor and seeing where it takes us.

**中文翻译:**
……这既需要类比，也需要分析。我们正处于这个过程的中间阶段，还没有所有的答案。那个隐喻——如果世界上每个人，无论收入或财富如何，身边都坐着一位可以随时求助的私人银行家——是一个很好的隐喻。我们正在使用这个隐喻，看看它会带我们走向何方。

---

### (01:12:34) Lenny Rachitsky

**English:**
Let's now move on to a different corner, failure corner. This is another recurring segment on the podcast. Is there a story you could share of a time in your career where you failed, where something went wrong, ideally really wrong, and how that impacted and helped you in your career? Kind of a lesson you learned from that experience?

**中文翻译:**
现在让我们移步到另一个角落，“失败角落”。这是播客的另一个固定环节。你能不能分享一个职业生涯中失败的故事？当时出了什么问题（最好是非常严重的问题），它如何影响并帮助了你的职业生涯？你从那次经历中学到了什么教训？

---

### (01:12:55) Jag Duggal

**English:**
There's a pretty seminal story from my career that ultimately ended in failure and that I had to sort of rebuild from. I had done strategy consulting for just shy of 10 years. I decided I was going to go to grad school. I was going to pivot my career into public policy and politics. I was at the Kennedy School of Government at Harvard and a year into that a friend of mine had, the startup he was working at Get acquired by Google I this company was premised on the idea that you could bring AdWords/AdSense style advertising to the terrestrial radio market and one of Google's, perhaps the biggest diversification bet Google was working on at the time beyond search and display, which were up and running, was let's go disrupt TV, radio, and print. It was 2006.

**中文翻译:**
我职业生涯中有一个非常重要的故事，最终以失败告终，我不得不从中重建。我做了近 10 年的战略咨询，然后决定去读研，想把职业方向转向公共政策和政治。我在哈佛肯尼迪政府学院读了一年，当时我一个朋友工作的初创公司被 Google 收购了。这家公司的前提是：你可以把 AdWords/AdSense 风格的广告引入地面广播（radio）市场。这是当时 Google 除了已经成熟的搜索和展示广告之外，可能最大的多元化赌注——去颠覆电视、广播和印刷媒体。那是 2006 年。

---

### (01:13:59) Jag Duggal

**English:**
My friend convinced me to drop out of grad school, both the Kennedy school and business school. I had done a year of the Kennedy school. I was one credit short and in business school I had done a week of and move out here to California and join Google. First off, the premise of the hypothesis proved to be wrong or at least harder than we thought, and in the following way, terrestrial radio or for that matter, TV advertising, broadcast media advertising works very differently. It serves actually a different market. It serves brand advertising, top of funnel kinds of goals as opposed to the bottom funnel that Google really knew well.

**中文翻译:**
我朋友说服我从研究生院辍学（包括肯尼迪学院和商学院，当时肯尼迪学院我只差一个学分就毕业了，商学院才上了一周），搬到加州加入 Google。首先，那个假设的前提被证明是错误的，或者至少比我们想象的要难。地面广播或电视广告、广播媒体广告的运作方式非常不同。它服务于不同的市场，即品牌广告和漏斗顶端的目标，而不是 Google 擅长的漏斗底端（效果广告）。

---

### (01:14:52) Lenny Rachitsky

**English:**
Back then.

**中文翻译:**
在那个时候。

---

### (01:14:54) Jag Duggal

**English:**
So that was one piece. There were all sorts of technical methodologies like reach and frequency that are really important that we simply didn't know about. We were determined to run an auction. We have patents to our name to this day that were how do we bring auction methodologies to work in a broadcast medium? Some very interesting technology. At the end of the day, one of the things that you really needed was a surplus of inventory, ad inventory, which there actually isn't that much of relatively speaking compared to online. The other thing that is true is the people who control that inventory are not nearly as fragmented, so when you're negotiating with NBC or CBS or Clear Channel, they have much more leverage than in the online world of bloggers and small websites.

**中文翻译:**
那是其中一方面。还有各种技术方法论，比如“到达率”（reach）和“频次”（frequency），这些非常重要，但我们当时根本不懂。我们一心想搞竞价拍卖（auction）。直到今天我们名下还有专利，是关于如何将竞价机制引入广播媒体的。技术很有趣，但归根结底，你真正需要的是过剩的广告库存，而广播媒体的库存相对于互联网来说其实并没那么多。另一件事是，控制这些库存的人并不像互联网那样碎片化。当你与 NBC、CBS 或 Clear Channel 谈判时，他们的议价能力比互联网上的博主和小网站强得多。

---

### (01:16:14) Jag Duggal

**English:**
The fragmentation wasn't there, the methodology was different, it was going to be a tougher slog. And in the meantime, Google made actually a very smart bet and this was a pivot on Google's part based on a lot of learnings from the failure on the one side and some of the success happening on the side of YouTube. In the meantime, Google had acquired YouTube and somewhere along the way, and this was over multiple years, Susan Wojcicki and the leadership team of Google and Google Ads in particular came to the conclusion that rather than Google chasing TV, let's have TV come to Google, I.e YouTube.

**中文翻译:**
那里没有碎片化，方法论也不同，注定是一场苦战。与此同时，Google 实际上做了一个非常聪明的赌注，这是基于一方面从失败中吸取的教训，另一方面是 YouTube 取得的成功。Google 收购了 YouTube，在几年的时间里，苏珊·沃西基（Susan Wojcicki）以及 Google 广告的领导团队得出一个结论：与其让 Google 去追逐电视，不如让电视来到 Google，也就是 YouTube。

---

### (01:17:12) Jag Duggal

**English:**
And we've seen what's happened in the ensuing 15 years where cord cutting and all of the rest and now the online digital ad methodologies that Google is best in the world at can be applied in a much more straightforward way. But I was collateral. Me and some of the teams I was a part of, we were collateral damage in that evolution. There was a point where Google did a small layoff and it was largely concentrated in my group of this acquisition.

**中文翻译:**
在接下来的 15 年里，我们看到了发生的一切：剪线潮（cord cutting）等等，现在 Google 擅长的在线数字广告方法论可以更直接地应用。但我成了牺牲品。我和我所在的团队是那场演变中的“附带损害”。当时 Google 进行了一次小规模裁员，主要集中在我所在的那个被收购的部门。

---

### (01:17:45) Jag Duggal

**English:**
Along the way, Google acquired YouTube, Google also acquired Double Click and Double Click served all of the brand advertising online. And a couple of years later... Well firstly at the time I was within weeks of being laid off, having dropped out of two grad schools and moved 3000 miles west. That felt really crappy. There's a great song from around that time, which is a mashup from Coldplay and Jay-Z. Lost. You should listen to the lyrics. Just because I'm losing doesn't mean I've lost is literally the first line and I would have that on repeat at that time within a couple of years, within a year, probably year and a half maybe that was around the time I was married.

**中文翻译:**
在那期间，Google 收购了 YouTube，还收购了 DoubleClick，而 DoubleClick 服务于所有的在线品牌广告。几年后……首先，当时我离被裁员只有几周时间，我辍学了两次，搬到了 3000 英里外的西方。那种感觉糟透了。当时有一首很棒的歌，是 Coldplay 和 Jay-Z 的混音版《Lost》。你应该听听歌词，第一句就是：“仅仅因为我正在输，并不意味着我已经输了”（Just because I'm losing doesn't mean I've lost）。我当时一直循环播放。大约一年半后，那也是我结婚的时候。

---

### (01:18:30) Jag Duggal

**English:**
It turns out that within a year, sort of post the Double Click deal, Google decided look with YouTube as an anchor asset and some other things and the Double Click acquisition, there was a technology now pretty well established 15 years later called Real-Time Bidding, and we were going to bring the search auction methodology across the entire web for all of display advertising and we were going to use that core underlying infra to be able to build not just a spot market, direct response advertising, but a futures market which could apply to brand advertising and we are going to use that disruptive vector, something fundamentally different, not just incrementally better, to essentially dislodge Yahoo from owning brand advertising online. And I ended up getting that mandate because I had learned a lot about how brand advertising worked, 12/18 months earlier. So that was a fairly spectacular failure.

**中文翻译:**
事实证明，在 DoubleClick 交易后的一年内，Google 决定利用 YouTube 作为核心资产，结合 DoubleClick 的收购，利用一种现在已经非常成熟的技术——实时竞价（RTB），将搜索竞价机制引入整个互联网的展示广告。我们要利用底层基础设施，不仅建立现货市场（直接响应广告），还要建立适用于品牌广告的期货市场。我们要利用这种颠覆性的手段——本质上的不同，而不仅仅是更好一点——来把雅虎（Yahoo）从在线品牌广告的霸主地位上赶下来。我最终获得了这个任务，因为我在 12 到 18 个月前学到了很多关于品牌广告运作的知识。所以，那曾是一个相当惨烈的失败。

---

### (01:19:06) Jag Duggal

**English:**
The acquisition, by the way, ended up in arbitration, big lawsuits, depositions, and it was messy from all sorts of angles. We all worked our way through that and then in the end we ended up building what is even still today, I believe Google's second largest business, which is the display advertising business. But that transition was messy, excruciatingly difficult from a strategy perspective as we talked about earlier, but from a emotional as well and figuring out your way. Given I was new to product management, I was new to Silicon Valley, I was new to Google, I was new to advertising and I had no idea whether I was ever going to be good at it or not.

**中文翻译:**
顺便说一下，那次收购最终陷入了仲裁、诉讼和取证，各方面都很混乱。我们最终挺了过来，并建立了直到今天仍是 Google 第二大业务的展示广告业务。但那个转型过程非常混乱，从战略角度看极其困难，从情感和寻找出路的角度看也是如此。考虑到我当时是产品管理的新手，是硅谷的新手，是 Google 的新手，也是广告业的新手，我当时完全不知道自己是否能做好。

---

### (01:19:55) Lenny Rachitsky

**English:**
Do you think the lesson there is basically that song just because you're losing doesn't mean you've lost or that you're a loser and just keep going?

**中文翻译:**
你认为那次的教训基本上就是那首歌说的——仅仅因为你正在输，并不意味着你已经输了，或者你是个失败者，只要继续前进就行？

---

### (01:20:02) Jag Duggal

**English:**
Yeah, bloody-mindedness is a dramatically underrated quality as we over-intellectualize from strategy to execution and all the other things. Sometimes persistence is key and persistence while still being clear-eyed about what the odds of success are is also key.

**中文翻译:**
是的，“顽固的坚持”（bloody-mindedness）是一种被严重低估的品质。当我们过度理智地讨论战略、执行等一切事情时，有时坚持才是关键。而且，在保持清醒认识成功概率的同时坚持下去，也是关键。

---

### (01:20:24) Lenny Rachitsky

**English:**
Jag, we've covered everything I was hoping to cover and more. Before we get to your very exciting lightning round, is there anything that you'd love to leave listeners with or share as a last tidbit?

**中文翻译:**
Jag，我们已经涵盖了我希望涵盖的所有内容，甚至更多。在进入令人兴奋的闪电轮问答之前，你还有什么想留给听众或分享的小贴士吗？

---

### (01:20:36) Jag Duggal

**English:**
I would just summarize a couple of core points. I think the idea of perseverance and being very clear about what you're trying to achieve and how much it is worth to you and how much you're willing to fight for it, while also being very open and transparent to feedback that you're getting from people, from the market about whether what's working and what's not and knowing what parts to let go and what to hold onto really tightly is an important lesson.

**中文翻译:**
我想总结几个核心点。我认为坚持不懈、清晰地知道你想实现什么、它对你有多大价值、你愿意为此付出多少努力，同时对来自他人和市场的反馈保持开放和透明（了解什么是有效的，什么是无效的），并知道该放手什么、该紧紧抓住什么，这是一个重要的教训。

---

### (01:21:13) Jag Duggal

**English:**
I think the other thing that I would just emphasize again is, and this goes a little bit back to the debate you're trying to frame up on new category or existing category, I think within that debate there's really a synthesis that says, and I think most people would agree, if you're trying to break through as an insurgent, you cannot fight on the ground that the incumbents stand firm. You have got to find a disruptive vector and that means searching hard for what is fundamentally different so that it breaks through the noise and the volume of the noise has just gone up so much in the last 15 years that I think that's even growing in importance. Incrementally better doesn't get you there. It doesn't get you there unless you have that hook.

**中文翻译:**
我想再次强调的另一件事（这又回到了关于新品类还是既有品类的辩论）：我认为在那场辩论中其实有一种综合观点，大多数人都会同意——如果你想作为一名“挑战者”突围，你不能在现任者站稳脚跟的阵地上作战。你必须找到一个颠覆性的矢量，这意味着要努力寻找“本质上的不同”，从而冲破噪音。在过去的 15 年里，噪音的音量增加了太多，我认为这一点变得越来越重要。“更好一点”无法带你到达终点，除非你有那个独特的“钩子”。

---

### (01:22:11) Lenny Rachitsky

**English:**
I love that you summarized your key takeaways. It's something I've been wanting to do and I might ask every guest to try to summarize what they've shared because that is incredibly helpful. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
我喜欢你总结核心要点的方式。这一直是我想要做的，我可能会要求每位嘉宾都尝试总结一下，因为这非常有帮助。那么，我们进入非常精彩的闪电轮问答。准备好了吗？

---

### (01:22:26) Jag Duggal

**English:**
I am ready. Let's do it.

**中文翻译:**
准备好了，开始吧。

---

### (01:22:27) Lenny Rachitsky

**English:**
First question, what are two or three books that you recommend most to other people?

**中文翻译:**
第一个问题，你最推荐给别人的两三本书是什么？

---

### (01:22:31) Jag Duggal

**English:**
The business books, one is Play to Win. I think that is a great modern strategy book that takes a lot of what's happened in the digital world and summarizes it really well. Second one that I would highlight, which I think is a really good non-digital world summary and really distillation of the essence of strategy and as you mentioned earlier, he's coming on your podcast soon from Roger Martin is Where to Play and How to Win, which I think is a classic.

**中文翻译:**
商业书籍方面，一本是《Play to Win》。我认为这是一本很棒的现代战略书，它很好地总结了数字世界中发生的事情。第二本我想强调的是罗杰·马丁的《Where to Play and How to Win》，我认为它是非数字世界战略本质的极佳总结和提炼，是一部经典。

---

### (01:23:06) Jag Duggal

**English:**
And as I mentioned, I went to study public policy and politics back 15 years ago. One of the ultimate startups and one of the ultimate startup stories in my mind is the story of Singapore and there's a autobiography of the founding prime minister of Singapore from 1965 till he retired, he passed away a couple of years ago. Lee Kuan Yew. His book about the story of being kicked out. Singapore being kicked out of Malaysia as a tiny in business terms, sub-scale, little country with no natural resources is I think inspiring. His book is called From Third World to First, and I think it's a great story that in many ways is a parallel to what startups try to do, which is essentially go from third class to first and it's a very tricky ride and requires a ruthless honesty about where you stand and what it'll take to succeed.

**中文翻译:**
正如我提到的，15 年前我曾去研究公共政策和政治。在我心中，终极的初创故事之一就是新加坡的故事。新加坡建国总理李光耀有一本自传。他在书中讲述了新加坡被马来西亚“踢出”的故事。作为一个在商业术语中规模不足、没有自然资源的小国，这个故事非常鼓舞人心。他的书叫《从第三世界到第一世界》（From Third World to First）。我认为这是一个伟大的故事，在很多方面与初创公司的奋斗历程相似：本质上是从三流走向一流。这是一个非常艰难的过程，需要对自己所处的地位以及成功所需的代价保持冷酷的诚实。

---

### (01:24:38) Lenny Rachitsky

**English:**
I love that. I definitely want to read that now. Next question, do you have a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
我喜欢这个推荐，我现在肯定想读读那本书。下一个问题，你最近有没有特别喜欢的电影或电视剧？

---

### (01:24:46) Jag Duggal

**English:**
There's the great series that my wife and I watched fairly recently on HBO called the Gilded Age, which really shines a very interesting light on how technology, this is from the late 1800s, 19th century, how the technological changes disrupts both the economic world and the world of wealth, but also the social dynamics in a society. And it's fascinating because we're living through a new Gilded age right now and we're seeing a lot of those dynamics, but turbocharged on social media, so extra, extra exciting.

**中文翻译:**
我和妻子最近在 HBO 上看了一部很棒的剧叫《镀金时代》（The Gilded Age）。它非常有趣地展示了 19 世纪末的技术变革如何颠覆经济、财富世界以及社会动态。这很迷人，因为我们现在正处于一个新的“镀金时代”，我们看到了很多类似的动态，但在社交媒体的加持下变得更加剧烈，所以格外令人兴奋。

---

### (01:25:32) Lenny Rachitsky

**English:**
Good times. Do you have a favorite product that you have recently discovered that you really like? Either an app, some physical, anything that's bringing you joy?

**中文翻译:**
美好的时光。你最近有没有发现什么特别喜欢的产品？无论是应用、实物，还是任何带给你快乐的东西？

---

### (01:25:44) Jag Duggal

**English:**
I was listening to your podcast with Christopher Lockett and it was on the treadmill when I was doing it and in the middle of it he mentioned a product around the idea of category design. I think I forget what question you asked him and he mentioned the Lomi. Which is your kitchen countertop composter and my 13-year-old daughter who is very idealistic and has been on us to do composting for over a year now, and we bought a Lomi and we just did our fifth batch of soil last night and it works exactly as advertised and it is fantastic and I get a great amount of joy, as does the whole family actually in doing the right thing, in doing it in a modern way, in doing it in this accelerated timeframe overnight. And it's really a new category of product, of a kitchen appliance that I remember Christopher talking about that creating countertop space is a precious asset and we are happy we did it. That's a very recent last three-week story.

**中文翻译:**
我在跑步机上听你和克里斯托弗·洛克海德的那期播客时，他提到了一个关于品类设计的产品。我忘了你问他什么问题了，他提到了 Lomi。那是一个厨房台面上的堆肥机。我 13 岁的女儿非常理想主义，一年多来一直催促我们做堆肥。于是我们买了一个 Lomi，昨晚刚做了第五批土。它的效果完全如广告所说，非常棒。我和全家人都感到非常快乐，因为我们在做正确的事，而且是用一种现代的、一夜之间就能完成的加速方式。这真的是一种新品类的厨房电器。我记得克里斯托弗说过，占用厨房台面空间是一件很奢侈的事，但我们很高兴买了它。这是过去三周刚发生的事。

---

### (01:27:08) Lenny Rachitsky

**English:**
This makes me so happy. I also think, Chris, this is going to be his favorite episode of all my podcasts. A lot of love for him. That's incredible. I got to get me one of those. Two more questions. Do you have a favorite life motto that you often think about, come back to, share with friends or family that's been useful in work or in life?

**中文翻译:**
这让我很高兴。我也觉得 Chris 会最喜欢这一集。对他满满的爱。太不可思议了，我也得去弄一个。最后两个问题。你有没有什么人生格言，是你经常思考、分享给朋友或家人的，且在工作或生活中很有用？

---

### (01:27:28) Jag Duggal

**English:**
In work, in the very narrow confines of work, I've used it at probably at least a dozen times in this podcast, which is about par for me for an hour and a half at work. We're in the business of fundamentally different, not incrementally better. I think that's the core motto and I think it works in a slightly modified way for life as well. You live, you build the life you want to build and it's not going to be checking the boxes that everyone wants you to check.

**中文翻译:**
在工作中，在狭义的工作范围内，我在这期播客里可能已经用了不下十几次了，这对我一个半小时的工作量来说很正常：我们追求本质不同，而不是更好一点。我认为这是核心格言。我觉得它稍微修改一下也适用于生活：你去生活，去构建你想要的生活，而不是去勾选别人希望你勾选的选项。

---

### (01:28:29) Jag Duggal

**English:**
There was a time when I was at a consulting firm and I was a partner and I dropped out to go back to grad school and people thought I was crazy. Then there was a time when I dropped out to the horror of my parents, I dropped out of Harvard like what the hell was I thinking? To come out to Silicon Valley and that went, as we talked about pear-shaped within weeks. There was a time when I left Facebook to not that long ago, four years ago, to go join this crazy Sao Paulo-based bank. What did I know about banking? What the hell did I know about Brazil really? If you are not clear on what it is you are trying to do, A, and B, if you are not willing to tolerate failure, then you're just checking the boxes of someone else's expectations. And so fundamentally different is important now it's a luxury good. It's easy for some of us who live in the Bay Area and in Silicon Valley too. And so I'm very conscious of that, that it's a privilege and it's a luxury good, but I think everyone should strive for their version of it.

**中文翻译:**
曾几何时，我在咨询公司当合伙人，却辞职去读研，大家都觉得我疯了。后来我又从哈佛辍学，让我父母大为惊恐，我当时到底在想什么？来到硅谷，结果几周内就搞砸了。四年前，我离开 Facebook 加入这家疯狂的圣保罗银行。我懂银行吗？我对巴西到底了解多少？如果你不清楚自己想做什么，且不愿意容忍失败，那你只是在满足别人的期望。所以“本质不同”很重要，虽然现在它像是一种奢侈品，对于我们这些住在湾区和硅谷的人来说更容易实现。我意识到这是一种特权，但我认为每个人都应该争取属于自己的那份“本质不同”。

---

### (01:29:24) Lenny Rachitsky

**English:**
I love that you extend that idea not to just business but also your life. I didn't even think that it goes that far. Final question, I know you have to run really soon, but I can't not ask about this. Apparently you were convicted of smuggling mangoes at some point in your life. Can you share that story?

**中文翻译:**
我喜欢你把这个想法不仅延伸到商业，还延伸到生活。我甚至没想过它能走得那么远。最后一个问题，我知道你马上要走了，但我不能不问这个：听说你这辈子曾因“走私芒果”被定罪过，能分享一下那个故事吗？

---

### (01:29:44) Jag Duggal

**English:**
Yes. As I mentioned, I grew up in Trinidad in the Caribbean and outside my brother and my bedroom was a mango tree that was abundant and spectacular quality set of mangoes. And here in the US, and I can speak very definitively for California, the mangoes are subpar. Forget about incrementally better. They are simply subpar. And Americans, I don't think realize what a good mango actually is and what a joy it is to behold.

**中文翻译:**
是的。正如我提到的，我在加勒比海的特立尼达长大。我和我哥哥卧室窗外就有一棵芒果树，结出的芒果又多质量又好。而在美国，我可以非常肯定地说，加州的芒果简直是不入流。别提什么“更好一点”了，它们根本就不行。我觉得美国人根本不知道真正的极品芒果是什么样的，也不知道那是多么大的享受。

---

### (01:30:21) Jag Duggal

**English:**
Every time I would go home, I would try to bring mangoes back. And one time coming through Miami International Airport from the Caribbean, I had a dozen mangoes wrapped in newspaper, slipped in between my clothes. And I hadn't counted on the fact that this was several months before 9/11, but I hadn't counted on the fact that the US Department of Agriculture had got smart to the fact that if people are coming from the Caribbean, they are bringing in food. That is a given. And they're going to try to smuggle it by. So they ran the entire plane through agricultural inspection. The guy looked through the X-ray machine and said, "You've got 11 mangoes in your bag, sir." At which point I knew I was caught. And I said, "Well, you've missed that one." I could see the picture. I was like, "You missed that one. It's actually 12."

**中文翻译:**
每次回家，我都会尝试带芒果回来。有一次从加勒比海经过迈阿密国际机场，我带了一打芒果，用报纸包着塞在衣服中间。那是 911 事件前几个月，我没料到美国农业部已经变聪明了，他们知道只要有人从加勒比海回来，肯定会带吃的，而且会尝试偷运。于是他们对整架飞机的乘客进行了农业检查。那个人看着 X 光机说：“先生，你的包里有 11 个芒果。”那一刻我知道我被抓住了。我说：“好吧，你漏掉了一个。”我看着屏幕说：“其实是 12 个。”

---

### (01:31:16) Jag Duggal

**English:**
I ended up on a agricultural watch list, but then nine 11 happened and there were three or four years where as a management consultant, I was at an airport twice a week. You used to get on your ticket SSSS, which they said was random. Every flight for three years, I was flagged for a special screening because of my love of mangoes. It was worth it. Mangoes are a misunderstood, underappreciated fruit. So if you grow up in the Caribbean, you can't, it's hard to go without top quality mangoes. And so I still struggle here in Cali.

**中文翻译:**
我最终被列入了农业观察名单。后来 911 发生了，作为管理咨询顾问，我每周要去两次机场。我的机票上总是印着“SSSS”（二次安检标识），他们说是随机的，但整整三年，我每一趟航班都会因为我对芒果的热爱而被标记进行特殊筛查。但这值得。芒果是一种被误解、被低估的水果。如果你在加勒比海长大，你很难忍受没有顶级芒果的日子。所以我现在在加州依然很痛苦。

---

### (01:32:02) Lenny Rachitsky

**English:**
I hope you've been rehabilitated from your life of crime at this point.

**中文翻译:**
我希望你现在已经从这种“犯罪生涯”中改过自新了。

---

### (01:32:05) Jag Duggal

**English:**
I have been rehabilitated and one of the great things about working with the Brazilian companies, the quality of mangoes in Brazil are top-notch. So I get to partake fairly regularly these days.

**中文翻译:**
我已经改过自新了。在巴西公司工作的一大好处是，巴西的芒果质量也是顶级的。所以我现在可以经常享用了。

---

### (01:32:15) Lenny Rachitsky

**English:**
It's unfair. I am going to ask you for your some mango recommendations. Jag, I've kept you long enough. I feel like this podcast episode was definitely not incrementally better. It was certainly fundamentally different. Thank you so much for being here. Two final questions. Where can folks find you if they want to reach out and maybe follow up on stuff and how can listeners be useful to you?

**中文翻译:**
这不公平。我待会儿要问你推荐一些芒果。Jag，耽误你太久了。我觉得这期播客绝对不是“更好一点”，它确实是“本质不同”。非常感谢你的到来。最后两个问题：如果大家想联系你或跟进一些事情，可以在哪里找到你？听众可以如何帮到你？

---

### (01:32:34) Jag Duggal

**English:**
Thank you, Lenny. I really enjoyed it. I appreciate it. Very kind words. Best place to find me is probably on LinkedIn, Jag Duggal, a relatively unique name, fairly easy to spot and find there. And I am always looking for stories and for opportunities. I'm always looking for stories of fundamentally different. I would love to hear those, especially when they're done against the odds or when there's a more convenient or easy choice. And we are in the business of building the world's first social and self-driving AI-powered bank, which sounds like a lot of NBA gobbledygook I know, but Silicon Valley buzzwords, but we mean it. And so anyone who wants to join what we call the purple revolution, our brand color is purple, love to hear from you wherever you are in the world. We have people everywhere.

**中文翻译:**
谢谢你，Lenny。我非常享受这次对话。找我最好的地方可能是 LinkedIn，搜 Jag Duggal，这是一个相对独特的名字，很容易找到。我一直在寻找故事和机会，寻找那些“本质不同”的故事。我很想听听这些故事，尤其是那些在逆境中完成的，或者在有更简便选择时依然坚持初心的故事。我们正在构建全球第一家社交型、自动驾驶式的 AI 驱动银行。我知道这听起来像是一堆硅谷流行语，但我们是认真的。所以，任何想加入我们所谓的“紫色革命”（我们的品牌色是紫色）的人，无论你在世界何处，我都欢迎你的联系。我们的员工遍布各地。

---

### (01:33:42) Lenny Rachitsky

**English:**
And if they're interested, is it like newbank.com/careers?

**中文翻译:**
如果他们感兴趣，是去 nubank.com/careers 吗？

---

### (01:33:46) Jag Duggal

**English:**
I believe that's right. Yes.

**中文翻译:**
我想是的，没错。

---

### (01:33:47) Lenny Rachitsky

**English:**
Amazing. By the way, do you have a color, a name for your purple brand color?

**中文翻译:**
太棒了。顺便问下，你们的紫色品牌色有专门的名字吗？

---

### (01:33:52) Jag Duggal

**English:**
We call, not we, our customers call the little purple credit card, the [foreign language 00:22:00 Hoshinyo Hosho] in Portuguese means purple. [foreign language 00:22:03 Hoshinyo] basically means little purple card. And there was actually a moment, a point when there was a risk because of some regulatory issues that were happening in Brazil in 2016 where there was a chance that NewBank would have to shut down. And it turns out the Central Bank, our customers called the Central Bank and said, "You cannot let this happen." And from that day, one of the engineers said when it was just a hundred or so people, "The future is purple," and we have T-shirts all over NewBank saying the future is purple, so that's part of our origin story.

**中文翻译:**
我们称它为——其实是我们的客户称那张紫色小信用卡为“Roxinho”。在葡萄牙语中，“Roxo”意味着紫色，“Roxinho”基本上就是“紫色小卡片”的意思。2016 年巴西曾出现过一些监管问题，NuBank 当时面临倒闭的风险。结果我们的客户给中央银行打电话说：“你们不能让这种事发生。”从那天起，当时只有 100 多人的团队里有一位工程师说：“未来是紫色的。”现在 NuBank 到处都是印着“未来是紫色”的 T 恤，这就是我们起源故事的一部分。

---

### (01:34:42) Lenny Rachitsky

**English:**
I'll let you go. Jag, you're awesome. I feel like this is going to help a lot of people. Thank you so much for being here.

**中文翻译:**
我让你去忙吧。Jag，你太棒了。我觉得这会帮助很多人。非常感谢你能来。

---

### (01:34:49) Jag Duggal

**English:**
Lenny. Enjoyed it so much. Thanks a lot. Great to chat.

**中文翻译:**
Lenny，非常享受这次谈话。多谢，聊得很开心。

---

### (01:34:52) Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。你可以在 Lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。