# Jake Knapp + John Zeratsky 2.0 - 双语对照

# Lenny's Podcast: Jake Knapp + John Zeratsky 2.0
## Bilingual Transcript (English-Chinese) | 双语全文本 (中英对照)

---

### (00:00:00) Jake Knapp

**English:**
We would have a conversation with founders, you're saying like, "Gosh, I'm almost embarrassed to ask this question, but who exactly is your target customer?" And three co-founders have three different answers.

**中文翻译:**
我们会和创始人交谈，你会说：“天哪，我甚至有点不好意思问这个问题，但你们的目标客户到底是谁？” 结果三个联合创始人给出了三个截然不同的答案。

---

### (00:00:09) John Zeratsky

**English:**
After these hundreds of teams that we've worked with, we've seen that there's one failure mode, which is they don't know what that set of basics are. Then there's this other failure mode where they never test it.

**中文翻译:**
在与数百个团队合作之后，我们发现有一种失败模式，就是他们根本不知道那套“基础”是什么。然后还有另一种失败模式，就是他们从不进行测试。

---

### (00:00:19) Lenny Rachitsky

**English:**
Let's talk about the Foundation Sprint. Walk us through the process. How does it start? What are the steps?

**中文翻译:**
让我们聊聊“基础冲刺”（Foundation Sprint）。请带我们了解一下这个流程。它是如何开始的？具体步骤有哪些？

---

### (00:00:23) Jake Knapp

**English:**
The very beginning of your project, we recommend this kind of crazy idea that you clear your calendar. So the core team come together for 10 hours roughly and go through a sequence of activities so that we can make all of the key decisions together.

**中文翻译:**
在项目的最开始，我们建议一个听起来有点疯狂的想法：清空你的日程表。核心团队聚在一起，大约花10个小时，完成一系列活动，以便我们能共同做出所有关键决策。

---

### (00:00:38) Lenny Rachitsky

**English:**
I think a lot of people wonder as they're hearing this is why don't I just build something and launch it and learn?

**中文翻译:**
我想很多人听到这里会产生疑问：为什么我不直接构建一些东西，发布出去，然后在实践中学习呢？

---

### (00:00:42) John Zeratsky

**English:**
One phenomenon we've seen when teams are building things really quickly with AI is that the more AI-generated or assisted they are, the more generic they tend to turn out. Put yourself in a situation where you can slow down and do some hard thinking, some deep thinking about what's actually going to make your product unique. Going fast can actually slow you down in the long run.

**中文翻译:**
我们观察到一个现象，当团队利用 AI 快速构建产品时，AI 生成或辅助的成分越多，产品往往就越平庸（Generic）。你应该让自己慢下来，进行一些艰苦的、深度的思考，想想究竟是什么能让你的产品脱颖而出。从长远来看，盲目求快反而会拖慢你的进度。

---

### (00:01:01) Lenny Rachitsky

**English:**
Today my guests are Jake Knapp and John Zeratsky. The framework that Jake and John share in this conversation is basically the missing manual for founders and product teams trying to refine and test their startup or product idea. It's called the Foundation Sprint, and it emerged out of the famous Design Sprint, which Jake and JZ co-created, and also from working with over 300 teams, building both new product at startups and also with teams at larger companies like Google, Microsoft, YouTube, Slack, Uber, and many more.

**中文翻译:**
今天的嘉宾是 Jake Knapp 和 John Zeratsky。他们在这次对话中分享的框架，基本上是为那些试图完善和测试创业想法或产品构思的创始人和产品团队准备的“缺失的指南”。它被称为“基础冲刺”（Foundation Sprint），源自 Jake 和 JZ 共同创立的著名的“设计冲刺”（Design Sprint），也源于他们与 300 多个团队合作的经验，这些团队既包括初创公司的新产品团队，也包括 Google、微软、YouTube、Slack、Uber 等大公司的团队。

---

### (00:01:28) Lenny Rachitsky

**English:**
They published a book with this framework at the beginning of this year called Click, and the excerpt from that book that dives into this framework is one of my most popular posts of all time and is one of the rare non-AI posts amongst the top post rankings.

**中文翻译:**
他们在今年年初出版了一本介绍该框架的书，名为《Click》。我曾发布过该书深入探讨这一框架的摘录，那是我有史以来最受欢迎的文章之一，也是排名前列的文章中罕见的非 AI 主题文章。

---

### (00:01:40) Lenny Rachitsky

**English:**
In this conversation, make sure to get your pencils out because we go through exactly how to execute this two-day sprint, where at the end of it you have a very clear hypothesis that your entire team is aligned around that clarifies what you're building, who you're building for, how it differentiates from competitors, and how to quickly test it with real potential customers. The two days that you invest in a sprint might be the highest ROI days in the history of your product, and I highly encourage you to do this if you're in the process of baking an idea.

**中文翻译:**
在这次对话中，请务必准备好笔和纸，因为我们将详细讲解如何执行这个为期两天的冲刺。冲刺结束时，你将获得一个全团队达成共识的清晰假设，明确你要构建什么、为谁构建、如何与竞争对手区分开来，以及如何与真实的潜在客户进行快速测试。你在冲刺中投入的这两天，可能是你产品历史上投资回报率（ROI）最高的两天。如果你正在酝酿一个想法，我强烈建议你尝试一下。

---

### (00:02:07) Lenny Rachitsky

**English:**
If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a year free of a bunch of amazing products including Bolt, Linear, Superhuman, Notion, Perplexity, Granola, and more. Check it out at lennysnewsletter.com and click Bundle. With that, I bring you Jake Knapp and John Zeratsky.

**中文翻译:**
如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你可以免费获得一年的一系列优秀产品，包括 Bolt、Linear、Superhuman、Notion、Perplexity、Granola 等。请访问 lennysnewsletter.com 并点击 Bundle 查看详情。下面，让我们欢迎 Jake Knapp 和 John Zeratsky。

---

### (00:02:28) Lenny Rachitsky

**English:**
This episode is brought to you by Brex, the financial stack used by one in every three US venture-backed startups. Brex knows that nearly 40% of startups fail because they run out of cash, so they built a banking experience that focuses on helping founders get more from every dollar. It's a stark difference from traditional banking options that leave a startup's cash sitting idle while chipping away at it with fees. To help founders protect cash and extend runway, Brex combined the best things about checking, Treasury, and FDIC insurance in one powerhouse account. You can send and receive money worldwide at lightning speed, you can get 20x the standard FDIC protection through program banks, and you can earn industry-leading yield from your first dollar while still being able to access your funds anytime. To learn more, check out Brex at brex.com/banking-solutions. That's brex.com/banking-solutions.

**中文翻译:**
本集节目由 Brex 赞助。全美每三家获得风投支持的初创公司中就有一家在使用 Brex 的金融栈。Brex 深知近 40% 的初创公司倒闭是因为现金耗尽，因此他们构建了一种专注于帮助创始人提高每一美元利用率的银行体验。这与传统银行截然不同，传统银行会让初创公司的现金闲置，同时还不断收取各种费用。为了帮助创始人保护现金并延长生存期（Runway），Brex 将支票账户、国债投资和 FDIC 保险的优势整合到一个强大的账户中。你可以以极快的速度在全球范围内收付款，通过合作银行获得 20 倍于标准 FDIC 的保障，并从第一美元起赚取行业领先的收益，同时还能随时动用资金。欲了解更多信息，请访问 brex.com/banking-solutions。

---

### (00:03:25) Lenny Rachitsky

**English:**
Many of you're building AI products, which is why I am very excited to chat with Brandon Foo, founder and CEO of Paragon. Hey, Brandon.

**中文翻译:**
你们中的许多人正在构建 AI 产品，这就是为什么我非常高兴能与 Paragon 的创始人兼 CEO Brandon Foo 交流。嘿，Brandon。

---

### (00:03:33) Brandon Foo

**English:**
Hey, Lenny. Thanks for having me.

**中文翻译:**
嘿，Lenny。谢谢你邀请我。

---

### (00:03:35) Lenny Rachitsky

**English:**
So integrations have become a big deal for AI products. Why is that?

**中文翻译:**
集成（Integrations）对 AI 产品来说已经变得非常重要。这是为什么呢？

---

### (00:03:40) Brandon Foo

**English:**
Integrations are mission critical for AI for two reasons. First, AI products need contacts from their customers business data, such as Google Drive files, Slack messages, or CRM records. Second, for AI products to automate work on behalf of users, AI agents need to be able to take action across these different third-party tools.

**中文翻译:**
集成对 AI 来说至关重要，原因有二。首先，AI 产品需要来自客户业务数据的上下文，例如 Google Drive 文件、Slack 消息或 CRM 记录。其次，为了让 AI 产品代表用户自动完成工作，AI 智能体（Agents）需要能够在这些不同的第三方工具中执行操作。

---

### (00:03:59) Lenny Rachitsky

**English:**
So where does Paragon fit into all of this?

**中文翻译:**
那么 Paragon 在这其中扮演什么角色呢？

---

### (00:04:01) Brandon Foo

**English:**
Well, these integrations are a pain to build, and that's why Paragon provides an embedded platform that enables engineers to ship these product integrations in just days instead of months across every use case from RAG data ingestion to agentic actions.

**中文翻译:**
构建这些集成非常痛苦，这就是为什么 Paragon 提供了一个嵌入式平台，让工程师能够在几天内（而不是几个月）交付这些产品集成，涵盖从 RAG 数据摄取到智能体操作的各种用例。

---

### (00:04:15) Lenny Rachitsky

**English:**
And I know from firsthand experience that maintenance is even harder than just building it for the first time.

**中文翻译:**
我从亲身经历中知道，维护比第一次构建还要难。

---

### (00:04:20) Brandon Foo

**English:**
Exactly. We believe product teams should focus engineering efforts and competitive advantages, not integrations. That's why companies like You.com, AI21, and hundreds of others use Paragon to accelerate their integration strategy.

**中文翻译:**
没错。我们认为产品团队应该将工程精力集中在竞争优势上，而不是集成上。这就是为什么像 You.com、AI21 以及数百家其他公司使用 Paragon 来加速其集成战略的原因。

---

### (00:04:33) Lenny Rachitsky

**English:**
If you want to avoid wasting months of engineering on integrations that your customers need, check out Paragon at useparagon.com/lenny. (00:04:41): Jake and JZ, thank you so much for being here and welcome to the podcast.

**中文翻译:**
如果你想避免在客户需要的集成上浪费数月的工程时间，请访问 useparagon.com/lenny 查看 Paragon。Jake 和 JZ，非常感谢你们来到这里，欢迎来到播客。

---

### (00:04:49) John Zeratsky

**English:**
Hey, Lenny. Thanks for having us.

**中文翻译:**
嘿，Lenny。谢谢你邀请我们。

---

### (00:04:51) Jake Knapp

**English:**
Yeah, thanks so much for having us on again. This is always a treat.

**中文翻译:**
是的，非常感谢再次邀请我们。这总是一件乐事。

---

### (00:04:55) Lenny Rachitsky

**English:**
This is going to be a very tactical conversation. We're going to be going through how to actually execute a Foundation Sprint. And the reason that I'm excited to do this is you guys shared an excerpt from your book where you initially shared this whole concept. It's called Click. You shared this in my newsletter and I was just looking at it, and that excerpt, that post is amongst the top 10 most popular posts of all time in my newsletter, which is especially special because it's not an AI-oriented, it's one of the few non-AI posts that are near the top 10, which just tells me how valuable this is to people. And consistently it has sat there, it hasn't been usurped, it just continues to climb.

**中文翻译:**
这将是一场非常具有实操性的对话。我们将深入探讨如何实际执行“基础冲刺”。我之所以对此感到兴奋，是因为你们曾在我的时事通讯中分享过你们新书《Click》的摘录，首次介绍了这个概念。我刚才看了一下，那篇摘录是我时事通讯有史以来最受欢迎的前 10 篇文章之一。这非常特别，因为它不是 AI 导向的，是前 10 名中极少数非 AI 类文章之一，这足以说明它对人们有多么大的价值。而且它一直稳居前列，没有被取代，排名还在持续上升。

---

### (00:05:33) Lenny Rachitsky

**English:**
So I'm really excited to just have a conversation where we share actually how to do this. Let me just start with the beginning, just a little backstory on how the Foundation Sprint came to be. I know it emerged out of the now very famous Design Sprint, which you guys also developed. So just give us a very brief overview of just how this came to be, this idea of this Foundation Sprint.

**中文翻译:**
所以我非常期待通过这次对话分享具体的操作方法。让我们从头开始，讲讲“基础冲刺”诞生的背景。我知道它源于现在非常有名的“设计冲刺”，那也是你们开发的。请简要介绍一下“基础冲刺”这个想法是如何产生的。

---

### (00:05:54) Jake Knapp

**English:**
Well, maybe I'll start by talking about the Design Sprint part because it is essential to understanding the Foundation Sprint. And the Design Sprint first developed, I had been working at the beginning of my career at Microsoft for a few years. Went to Google, which is like 2007, 2008, 2009, and was working on the Gmail team, was working on some projects that were just executing well, delivering, shipping. But I had this other project, a side project that had been going on for three years with a couple of colleagues, was going nowhere, and it looked like their office was going to get shut down after the financial crisis. They were in Stockholm.

**中文翻译:**
好吧，也许我该先从“设计冲刺”说起，因为它是理解“基础冲刺”的关键。设计冲刺最初是在我职业生涯早期开发的。我在微软工作了几年，然后在 2007 到 2009 年左右去了 Google，当时在 Gmail 团队工作。我参与了一些执行良好、按时交付的项目。但我还有另一个和几位同事一起做了三年的副业项目，却毫无进展。金融危机后，他们在斯德哥尔摩的办公室眼看就要被关闭了。

---

### (00:06:33) Jake Knapp

**English:**
I went there for a week. We cleared our calendars for the week, and we created a prototype of this, this thing because we decided, look, we're never going to get anywhere. We've tried making the perfect pitch. We've tried to make the ideal PRD, we've tried to show the ideal design, and we can't. Perfection is not working. We're not able to align people, we're not able to get executive support for this thing. We couldn't convince Larry and Sergey and Eric that they should fund this thing.

**中文翻译:**
我去了那里一周。我们清空了那一周的所有日程，为这个项目制作了一个原型。因为我们意识到，如果我们继续原来的做法，永远不会有结果。我们尝试过完美的演讲稿，尝试过理想的 PRD（产品需求文档），尝试过展示理想的设计，但都不行。追求完美行不通。我们无法让大家达成一致，也无法获得高层的支持。我们没法说服 Larry、Sergey 和 Eric 给这个项目投钱。

---

### (00:07:03) Jake Knapp

**English:**
In that week in Stockholm, we created a prototype instead. We decided you know what? Forget it. We're just going to build something and put it in people's hands, put it in our fellow Googlers hands. And that prototype was what became Google Meet. It was this video conferencing tool that you could use in the web browser.

**中文翻译:**
在斯德哥尔摩的那一周，我们转而制作了一个原型。我们决定：管它呢，我们直接做点东西出来，把它交到人们手里，交到 Google 同事的手里。那个原型后来就变成了 Google Meet。它是一个可以在浏览器中使用的视频会议工具。

---

### (00:07:21) Lenny Rachitsky

**English:**
No big deal.

**中文翻译:**
（开玩笑）也没什么大不了的嘛。

---

### (00:07:22) Jake Knapp

**English:**
Yeah, it was really cool. I mean, the outcome of that, that's definitely probably the most productive week I've ever had. But the thing that struck me at the time and in hindsight was, wow, it was so different to clear the calendar for a week and have the entire focal point of every person on the team be how do we create a prototype that's so real, that works so well that people will think it's real, that they'll react like it's real, that they'll want it? And we were in survival mode. We were trying to keep that office from getting shut down. But the notion that maybe you could repeat that and recreate that is what led me to create the Design Sprint.

**中文翻译:**
是的，真的很酷。那绝对是我一生中最富有成效的一周。但当时以及事后让我感触最深的是：哇，清空一周的日程，让团队中每个人的焦点都集中在“如何创建一个如此真实、运行如此良好的原型，以至于人们会认为它是真的、会有真实的反应并想要它”，这种感觉太不一样了。当时我们处于生存模式，试图保住那个办公室。正是这种“也许可以重复并再现这种模式”的想法，促使我创立了“设计冲刺”。

---

### (00:07:59) Jake Knapp

**English:**
So for a couple of years at Google, I start running these one-week programs with teams trying to go at the beginning of a project from zero to a prototype at the end that we can sort of evaluate, test. And then I went to go work at Google Ventures. So separate, one of the Alphabet companies we're investing in startups. I meet John Zeratsky and we start running these design sprints with, well, it turned out to be over the course of five years, I don't know, couple hundred teams working in the early days with founders, in the early days of their establishing the product for the first time, trying to build it from zero to one or launching a new marketing campaign, a new ad campaign, some big high-risk endeavor. We'd get to work alongside them for a week.

**中文翻译:**
所以在 Google 的几年里，我开始带着团队运行这些为期一周的项目，尝试在项目初期从零开始，到周末拿出一个可以评估和测试的原型。后来我去了 Google Ventures（GV），那是 Alphabet 旗下专门投资初创公司的公司。在那里我遇到了 John Zeratsky，我们开始一起运行这些设计冲刺。在五年的时间里，我们合作了大约几百个团队，在创始人建立产品的早期阶段与他们并肩作战，尝试实现从 0 到 1，或者启动新的营销活动、广告活动等高风险任务。我们会和他们一起工作一周。

---

### (00:08:46) Jake Knapp

**English:**
And we ended up refining this process into a recipe. So across five days, it's map, sketch, decide, prototype, and test, one big focal point for each day. So at the end of the week, you've got a tested prototype and you learn are we on the right track or not? And that's the Design Sprint. That's kind of the prologue, the backstory to this thing. And then after a few years at Google Ventures, John and I left and eventually together with our co-founder, Eli Blee-Goldman, we started our own venture firm, Character Capital. And that's kind where the story of the Foundation Sprint comes in.

**中文翻译:**
我们最终将这个过程精炼成了一套“食谱”。在五天时间里，分别是：地图（Map）、草图（Sketch）、决定（Decide）、原型（Prototype）和测试（Test），每天都有一个核心重点。到周末，你就拥有了一个经过测试的原型，并能了解我们是否走在正确的轨道上。这就是“设计冲刺”，也是整个故事的前传。在 GV 工作几年后，我和 John 离开了，最终与我们的合伙人 Eli Blee-Goldman 一起创办了自己的风险投资公司 Character Capital。这就是“基础冲刺”故事开始的地方。

---

### (00:09:25) Lenny Rachitsky

**English:**
Okay, awesome. JZ, anything you wanted to add?

**中文翻译:**
太棒了。JZ，你有什么想补充的吗？

---

### (00:09:29) John Zeratsky

**English:**
One of our goals, probably our biggest goal for starting our own VC firm was that we wanted to be able to focus on just the kinds of companies and the stage of company-building that was the most fun to us, but also was where we thought we could have the biggest impact. And so for us, with our background as designers, that is the early days, the first couple of months or the first year or two years of building a new business. And at GV, sometimes we did that, but sometimes we were working with companies that were already well established.

**中文翻译:**
我们创办自己的风投公司的一个目标，可能也是最大的目标，就是希望能够专注于那些对我们来说最有趣、同时我们也认为能产生最大影响的公司类型和构建阶段。对于拥有设计师背景的我们来说，那就是早期阶段——构建新业务的前几个月或前一两年。在 GV 时，我们有时会这样做，但有时也会与已经成熟的公司合作。

---

### (00:10:15) John Zeratsky

**English:**
When we'd come into those companies, they kind of knew what they were doing. They knew what they stood for. They knew how they were different in the market and how they were positioned. And so we could help them answer these big questions and solve these problems and test their prototypes with customers. But when we started investing in truly pre-seed, sometimes inception stage, pre-product, pre-revenue, pre-everything companies, there was this piece missing at the beginning of that process. So we'd run design sprints and they would be helpful, but oftentimes it felt like there was a foundational element of that project that we didn't quite have our hands around. And it was things like, what is the problem you're solving and who's the ideal customer? How are you different than what's in the market today? Who are your actual competitors?

**中文翻译:**
当我们进入那些成熟公司时，他们通常知道自己在做什么，知道自己的立场，知道自己在市场上的差异化和定位。所以我们可以帮助他们回答大问题、解决具体问题并测试原型。但当我们开始投资真正的种子前轮（Pre-seed），甚至是初始阶段、无产品、无收入、什么都没有的公司时，我们发现流程的开头缺失了一块。我们运行设计冲刺，虽然有帮助，但往往感觉项目中有些基础性的元素我们还没摸透。比如：你到底在解决什么问题？谁是理想客户？你与现有市场产品有何不同？你真正的竞争对手是谁？

---

### (00:10:49) John Zeratsky

**English:**
And there were these questions that just kept coming up again and again that led us to say, "Hey, we need to create a new sprint method, something that is really targeted for the very beginning of these big new projects." And so that was what led us to create the Foundation Sprint at Character Capital in 2021, 2022.

**中文翻译:**
这些问题不断重复出现，促使我们意识到：“嘿，我们需要创造一种新的冲刺方法，一种专门针对这些重大新项目最开始阶段的方法。” 这就是我们在 2021 到 2022 年间在 Character Capital 创立“基础冲刺”的原因。

---

### (00:11:08) Lenny Rachitsky

**English:**
Okay. Yeah, I was wondering the timeline on this. What I love about stuff like this, episodes like this is you guys have done so much work and done this so many times with so many companies, so many founders, and have learned what works and doesn't work. You said hundreds of founders, hundreds of startups.

**中文翻译:**
明白了，我之前还在想这个时间线。我喜欢这类节目的原因在于，你们已经做了大量工作，在这么多公司和创始人身上实践了多次，学到了什么是有效的，什么是无效的。你刚才说有数百位创始人，数百家初创公司。

---

### (00:11:24) Lenny Rachitsky

**English:**
And you've just spent so many hours studying this, refining it, crafting it, and now you're just here to share all the answers, save us so much time. Just the ROI on this is incredible for us. So I appreciate you guys doing this. Let's get into it. Let's talk about the Foundation Sprint. Walk us through the process. How does it start? What are the steps?

**中文翻译:**
你们花了这么多时间研究、完善和打磨它，现在直接在这里分享答案，为我们节省了大量时间。这对我们来说投资回报率简直惊人。非常感谢你们。让我们进入正题吧，聊聊“基础冲刺”。请带我们走一遍流程。它是如何开始的？步骤是什么？

---

### (00:11:42) Jake Knapp

**English:**
So specifically what we talk about with the Foundation Sprint is it's at the very beginning of your project. We recommend this kind of crazy idea that you clear your schedule, you clear your calendar. So the core team, this is the co-founders if it's a startup, if it's a product team inside a larger organization, it's whoever's in charge of product, it's whoever's in charge of engineering, it's whoever's in charge of design, it whoever's in charge of marketing, the core leadership team, they're going to come together for, it's going to be 10 hours roughly, give or take.

**中文翻译:**
具体来说，“基础冲刺”发生在项目的最早期。我们建议一个有点疯狂的想法：清空你的日程。核心团队——如果是初创公司就是联合创始人；如果是大公司里的产品团队，就是产品负责人、工程负责人、设计负责人和营销负责人——这些核心领导层聚在一起，大约需要 10 个小时左右。

---

### (00:12:15) Jake Knapp

**English:**
And during those 10 hours, we're going to go through a sequence of activities, very highly scripted sequence of activities so that we can make all of the key decisions together and identify the basics of the project, what's going to differentiate us in the marketplace, and what's the best approach or implementation path. All of those together form a hypothesis.

**中文翻译:**
在这 10 个小时里，我们将完成一系列高度脚本化的活动，以便共同做出所有关键决策，并确定项目的“基础”、我们在市场上的“差异化”以及最佳的“实施路径”。所有这些加在一起，就构成了一个“假设”（Hypothesis）。

---

### (00:12:36) Jake Knapp

**English:**
And then we recommend, so you finish now, that's your Foundation Sprint, you've got your founding hypothesis. Once you've got that founding hypothesis, then you're going to go and do design sprints, and we recommend you clear the calendar for two to three weeks at least, so you have the chance to be wrong about your hypothesis. And we're going to run experiments. And again, the Design Sprint, highly scripted, calendar clear, emails off, Slack is off. We're just focused on running through these sequence of decisions, building prototypes, getting them in front of customers, learning about a scorecard that relates back to the founding hypothesis.

**中文翻译:**
完成基础冲刺后，你就得到了“创始假设”。接下来，我们建议进行“设计冲刺”，并建议至少清空两到三周的日程，这样你才有机会证明你的假设是错误的。我们将运行实验。同样，设计冲刺也是高度脚本化的，清空日程，关掉邮件和 Slack。我们只专注于执行这一系列决策、构建原型、展示给客户，并根据与创始假设相关的“计分卡”进行学习。

---

### (00:13:09) Jake Knapp

**English:**
So at the big picture, it's going to be anywhere from 10 hours to three to four weeks. You're going to run this detailed script of activities with your team with their calendars clear. And that's crazy, and most people won't do it. But if you do it, it confers upon you a huge advantage because now you've got information, you know whether or not your product clicks with customers. And we've seen that be just such a tremendous signal for is there going to be product market fit?

**中文翻译:**
所以从大局来看，整个过程需要 10 小时到三四周不等。你将带着团队在清空日程的情况下执行这套详细的活动脚本。这听起来很疯狂，大多数人不会去做。但如果你做了，它会赋予你巨大的优势，因为你获得了信息，你知道你的产品是否能与客户产生共鸣（Click）。我们发现，这是一个判断产品是否能达到“产品市场契合度”（PMF）的极佳信号。

---

### (00:13:38) Lenny Rachitsky

**English:**
Okay. That was really helpful. The 10 hours is that specifically, that's the Foundation Sprint time box?

**中文翻译:**
明白了，这很有帮助。那 10 小时是专门指“基础冲刺”的时间盒吗？

---

### (00:13:43) Jake Knapp

**English:**
That's the Foundation Sprint time box, yeah. And it's give or take, right? You might go fast and be done in eight. And you might have a lot of conversations and have a slightly larger team and might take you 12. So we like to spread it out over two days, do two four to six-hour blocks.

**中文翻译:**
是的，那是基础冲刺的时间盒。当然是大概的时间，对吧？你可能动作快，8 小时就完成了；也可能讨论很多，或者团队规模稍大，需要 12 小时。所以我们喜欢把它分摊到两天，每天进行 4 到 6 小时。

---

### (00:13:57) Lenny Rachitsky

**English:**
Okay. And then the three to four week-ish, that's including the Design Sprint?

**中文翻译:**
好的。那三四周左右的时间，是包含了设计冲刺吗？

---

### (00:14:00) Jake Knapp

**English:**
That's the design sprints, yeah.

**中文翻译:**
是的，那是设计冲刺的时间。

---

### (00:14:01) Lenny Rachitsky

**English:**
Okay, awesome.

**中文翻译:**
好的，太棒了。

---

### (00:14:02) Jake Knapp

**English:**
One week per sprint.

**中文翻译:**
每周进行一次冲刺。

---

### (00:14:03) Lenny Rachitsky

**English:**
Okay. This is incredible ROI on 10 hours of work. Basically over two days, you get to have a much stronger sense of whether your idea is any good. Yeah. Is that a simple way to describe it? You just supercharge validating an idea?

**中文翻译:**
10 小时工作的投资回报率简直不可思议。基本上通过两天时间，你就能更强烈地感觉到你的想法是否靠谱。可以这么简单地描述吗？就是“超级加速想法验证”？

---

### (00:14:19) Jake Knapp

**English:**
Exactly. Yeah, it's a chance to... In the 10 hours, it's a chance to get clarity about the core of your strategy, which is something that teams will often go months without really nailing down. And the three to four weeks, that's a chance to run experiments and get confidence you're actually building the right thing.

**中文翻译:**
没错。在那 10 小时里，你有机会理清战略核心，而很多团队往往花几个月都无法真正敲定这一点。而在那三四周里，你有机会运行实验，并获得“你确实在构建正确的东西”的信心。

---

### (00:14:41) Lenny Rachitsky

**English:**
Okay, let's talk about these two days. How do you lay it out? How do you approach it? What should someone do if they want to actually try this at home?

**中文翻译:**
好，让我们聊聊这两天。你如何安排？如何切入？如果有人想在自己的团队尝试，该怎么做？

---

### (00:14:48) Jake Knapp

**English:**
So there are three phases to the Foundation Sprint. First phase is the basics, second phase is differentiation, and the third phase is the approach to the project. So again, all three of those are going to come together to create the founding hypothesis.

**中文翻译:**
基础冲刺分为三个阶段。第一阶段是“基础”（Basics），第二阶段是“差异化”（Differentiation），第三阶段是“项目路径”（Approach）。同样，这三个部分将共同构成“创始假设”。

---

### (00:15:04) Jake Knapp

**English:**
So the first phase, the basics, as I mentioned, that's identifying who's your customer, what problem are you solving for the customer? What's the competition for solving that problem? How do they solve it today? And what are the alternatives? How else do people solve this? What are the workarounds? Those are really almost embarrassingly simple things to answer. But when we do this with a team and everybody's answering, proposing their answer to each question, we see everybody's got a different perspective. And then when we lock in, the decision-maker on the team says, "Okay, it's going to be this one, it's going to be this one, it's going to be this one." Now we have clarity and confidence that that's the right way to go.

**中文翻译:**
第一阶段“基础”，正如我提到的，是确定：谁是你的客户？你为客户解决什么问题？解决该问题的竞争对手是谁？他们现在是如何解决的？有哪些替代方案？人们还有什么其他解决方法？有哪些权宜之计（Workarounds）？这些问题简单到让人尴尬，但当我们和团队一起做这件事，每个人都针对每个问题给出答案时，你会发现每个人的视角都不同。当团队的决策者最终拍板说“好，就是这个，这个，还有这个”时，我们就获得了清晰的目标和前进的信心。

---

### (00:15:42) Jake Knapp

**English:**
So we'll move forward from the basics into differentiation and identify what are the things that can set us apart from those competitors? And we're going to use the advantages we have. We're going to use our insight, we're going to use our motivation, we're going to use our special capabilities. These are things, again, people are aware of these things, they're in tune to it, but we want to get super, super specific, and we'll go into an example in a second, and I think that'll make it more clear exactly what we mean.

**中文翻译:**
然后我们从“基础”进入“差异化”，确定哪些东西能让我们在竞争对手中脱颖而出。我们将利用现有的优势：我们的洞察力、我们的动力、我们的特殊能力。同样，人们通常意识到这些东西，但我们要变得极其具体。稍后我们会举个例子，我想那会让你更清楚我们的意思。

---

### (00:16:13) Jake Knapp

**English:**
But going then from differentiation to saying, "What are all of the different implementation paths we could take here? Let's identify what those are, put a little detail behind them." And then we have a structured path for people to take so they can weigh that decision, but move through really quickly. Commit to one, have a backup plan in case you end up feeling like you need to pivot once you start sprinting on it. And all of that together is going to form this kind of Mad Libs sentence.

**中文翻译:**
接着从“差异化”过渡到：“我们可以采取哪些不同的实施路径？让我们识别出这些路径，并补充一些细节。” 然后我们为团队提供一个结构化的路径，让他们权衡决策，但又能快速推进。承诺其中一条路径，同时准备一个备份计划，以防在开始冲刺后觉得需要转型（Pivot）。所有这些加在一起，将形成一个类似“填空游戏”（Mad Libs）的句子。

---

### (00:16:35) Jake Knapp

**English:**
If we solve this problem for this customer with this approach, we think they're going to choose it over the competitors because of differentiator one and differentiator two. And it's almost silly how simple this thing is, but really powerful for founders to have that clarity about, okay, here it all is in one sentence. Now let's go test and make sure this is true.

**中文翻译:**
“如果我们通过‘这种路径’为‘这类客户’解决‘这个问题’，我们认为他们会选择我们而不是竞争对手，因为‘差异化点1’和‘差异化点2’。” 这个东西简单得近乎可笑，但对创始人来说却非常强大，因为它能让你获得清晰感：好，一切都在这一句话里了。现在，让我们去测试并确保它是真的。

---

### (00:16:59) Lenny Rachitsky

**English:**
Amazing. Let's look at an example. That's a really good idea. I know you brought some examples. You're going to do some screen sharing. You're going to pull it up. If you're watching on YouTube, you'll be able to see it. Also, if you're watching on Spotify, you can see the video. If you're on Apple [inaudible 00:17:11]. But do your best to describe what we're going to be looking at.

**中文翻译:**
太棒了。让我们看个例子，这是个好主意。我知道你们带了一些例子。你们会进行屏幕共享，把它调出来。如果你在 YouTube 或 Spotify 上观看，就能看到视频。如果你在 Apple Podcast 上听，请尽量听他们的描述。

---

### (00:17:15) Jake Knapp

**English:**
Yeah, so we're going to talk about this company called Latchet first. This is the first company we'll talk about. And Latchet is a startup who was in our last group of Character Labs, and we can go into Character Labs later on. But essentially this is kind of an accelerator-like program that we run at Character Capital where we invest in a group of companies at the same time, and we run them through that process that we were just describing, where we start with a Foundation Sprint, and then it's going to be a sequence of three design sprints after that so that they're testing and refining that hypothesis.

**中文翻译:**
好的，我们先聊聊一家叫 Latchet 的公司。Latchet 是我们上一期 Character Labs 的一家初创公司。稍后我们可以详细聊聊 Character Labs，但基本上这是我们在 Character Capital 运行的一个类似加速器的项目。我们同时投资一组公司，并带他们走过刚才描述的流程：先从基础冲刺开始，然后是连续三次设计冲刺，以便他们测试和完善假设。

---

### (00:18:06) Jake Knapp

**English:**
And so it's a great time for them. These are founders who have just started their companies. They're kind of that pre-seed, very beginning, zero stage. And the progress you can see in those three and a half, four weeks, it's phenomenal. So let's talk about Latchet. So Latchet, a couple co-founders, Chris and James, who they had left Substack. They were engineers leading up the growth team at Substack. And they wanted to build a product for artisans.

**中文翻译:**
这对他们来说是一个很好的时机。这些创始人刚开始创业，处于种子前轮、最开始的“零阶段”。在三四周内你能看到的进步是惊人的。说说 Latchet 吧，它的两位联合创始人 Chris 和 James 刚离开 Substack。他们曾是 Substack 增长团队的工程负责人。他们想为手工艺者（Artisans）打造一款产品。

---

### (00:18:35) Jake Knapp

**English:**
So if you imagine you're a jewelry maker, you're a painter, you're a woodworker, and you want to sell your products outside of your immediate community, the physical place where you are, your physical location, well, you can build a site on Shopify, but you still have to market it. If you do that, you got to figure out how to reach those folks. You can put your products on Etsy, but Etsy has become quite commoditized. So you're going to be up against everybody everywhere, and it's going to be very hard for you to build an identity there, to build a sense of who I am, what I'm all about.

**中文翻译:**
想象一下，你是一个珠宝商、画家或木工，你想在本地社区之外销售产品。你可以用 Shopify 建站，但你仍然需要自己做营销，想办法触达客户。你也可以把产品放在 Etsy 上，但 Etsy 已经变得非常同质化（Commoditized），你是在和世界各地的所有人竞争，很难建立自己的品牌身份，很难传达“我是谁、我的理念是什么”。

---

### (00:19:05) Jake Knapp

**English:**
And so what Chris and James thought was maybe we could use some of the techniques and methods we used at Substack to help people find other newsletter writers through their community, through recommendations they make and help out artisans in that way. Wouldn't that be cool? So they were at that stage, they had a few different ideas about what form that might take, what that might look like when they joined Character Labs. And so that's kind of the backdrop to this little quick story I'll tell.

**中文翻译:**
所以 Chris 和 James 就在想：也许我们可以利用在 Substack 使用过的一些技术和方法——比如通过社区和推荐来帮助人们发现其他创作者——来帮助手工艺者。这难道不酷吗？当他们加入 Character Labs 时，正处于这个阶段，对于产品具体长什么样、以什么形式呈现，有几个不同的想法。这就是这个小故事的背景。

---

### (00:19:30) John Zeratsky

**English:**
And there's one really important thing to emphasize about Chris and James that Jake mentioned briefly, but I think is worth repeating, which is that they're engineers, they are builders. Their instinct is to write code, it's to build software. And they actually told us that they were excited but nervous to come into Character Labs where we would be encouraging them not to write code right away, to take this time to clarify the differentiation, the structure of what they're building, and to validate that with customers before they went all in on building a particular approach.

**中文翻译:**
关于 Chris 和 James，有一点非常重要，Jake 简要提到了，但我认为值得重复：他们是工程师，是构建者。他们的本能是写代码、做软件。他们告诉我们，加入 Character Labs 让他们既兴奋又紧张，因为我们会鼓励他们“不要立即写代码”，而是花时间理清差异化、理清构建的结构，并在全力投入某种路径之前先向客户验证。

---

### (00:20:20) Lenny Rachitsky

**English:**
That's actually really helpful context. And speaking of the Substack, Recommendations feature was one of the most game-changing features for me with my newsletter because it basically supercharged my growth. So I get why they'd be so excited about bringing this learning to other ideas and to their own startups. So thank you guys for doing that. And I'm even more excited to see what they're building.

**中文翻译:**
这确实是很有帮助的背景。说到 Substack，“推荐”（Recommendations）功能对我自己的时事通讯来说是改变游戏规则的功能，它极大地加速了我的增长。所以我理解为什么他们如此兴奋地想把这些经验应用到其他想法和自己的创业中。谢谢你们分享这些，我也很期待看到他们正在构建的东西。

---

### (00:20:41) Jake Knapp

**English:**
Well, let's take a look. So this board here that we're looking at, this is like their Miro board. So we've got a big template. And whether you're watching on YouTube or listening to this episode, we'll talk about at the end how you can get access to this template, which will kind of guide you through the process.

**中文翻译:**
好，让我们来看看。我们现在看到的这个板子是他们的 Miro 板。我们有一个大模板。无论你是在 YouTube 上看还是在听播客，最后我们都会告诉大家如何获取这个模板，它会引导你完成整个流程。

---

### (00:20:58) Jake Knapp

**English:**
But what happens in this first step in the Foundation Sprint, in the basics, as we said before, is that we're going through a sequence of questions. Who's the most important customer, for example, is the first question, the very first question that a team needs to answer. And as we do that, just as an important side note, we're using this tactic that we call work alone together. And specifically the note and vote is this method where everyone's in silence, in this case both Chris and James, but if you have a team of seven, it's all seven people be working in silence, writing down their own answers to this question.

**中文翻译:**
在基础冲刺的第一步，也就是“基础”部分，正如之前所说，我们要回答一系列问题。例如，“谁是最重要的客户？”是团队需要回答的第一个问题。在这里顺便提一个重要的战术，我们称之为“独自同步工作”（Work alone together）。具体来说就是“记录与投票”（Note and Vote）：每个人保持沉默（在这个例子中是 Chris 和 James，如果是 7 人团队就是 7 个人），静静地写下自己对这个问题的答案。

---

### (00:21:38) Jake Knapp

**English:**
And then once we've got those answers, the team's going to vote on those. And then one person who's designated as the decider, usually it's going to be the CEO of the startup, but it could be in some cases, maybe it's the chief product officer, whatever, however they decide to do it. But one person's going to say, "Okay, this is our decision for now, and now we're going to move on." And by doing this and using silence and using structure and then having a designated decision-making process, we can move through a lot of conversations very quickly and save some of that energy that it requires to make the decisions that matter most.

**中文翻译:**
写完答案后，团队进行投票。然后由指定的“决策者”（通常是 CEO，有时也可能是 CPO）拍板说：“好，这是我们目前的决定，现在继续下一步。” 通过这种方式——利用沉默、利用结构、并拥有明确的决策流程——我们可以非常快速地处理大量对话，并节省精力去处理那些最重要的决策。

---

### (00:22:21) Jake Knapp

**English:**
Anyway, we motor through customer problem, the capability, the insight, the motivation that the team has, those are all advantages, and who are the competition. And we get this sort of one-page sheet, the basics, and it's going to have the answers to all those questions. Who's our customer? In this case, artisans who want to sell online, but they sort of find tech and marketing to be hard. The problem is sales growth. If we jump down to the competition, their number one competitor is Shopify, but Etsy is another way people approach this, as we mentioned. But there's also in-person sales and art fairs or other ways that people try to get at this problem.

**中文翻译:**
总之，我们快速过完客户、问题、能力、洞察力、团队动力（这些都是优势）以及竞争对手。最后我们会得到一张单页纸，即“基础表”，上面有所有问题的答案。谁是客户？在这个例子中，是想在网上销售但觉得技术和营销很难的手工艺者。问题是销售增长。竞争对手方面，头号对手是 Shopify，Etsy 是另一种方式，此外还有线下销售、艺术展等其他解决方式。

---

### (00:23:05) Jake Knapp

**English:**
And realistically, if you're delivering a solution, you need to stand out from all of those. And then there are advantages. We talked about this key one, they built Substack's network growth features, so they know how to do this thing. So now we've established the basics. We're going to move on to differentiation.

**中文翻译:**
现实情况是，如果你要提供一个解决方案，你需要从所有这些选项中脱颖而出。然后是优势，我们提到了关键的一点：他们构建了 Substack 的网络增长功能，所以他们知道该怎么做。现在我们已经确立了基础，接下来进入“差异化”。

---

### (00:23:18) Lenny Rachitsky

**English:**
Before you do that actually, let me ask you a question here. Because I think people seeing this could think, "Oh, this is like... I know all this stuff, it's so obvious." It's like, "Okay, I get it. I have an idea, I don't need to do this." Where do you find people most are often surprised by something that emerges out of this? Is one of these buckets often, wow, this is often not what you expected, or is it generally a lot of surprises? What do you experience there?

**中文翻译:**
在进入下一步之前，我想问个问题。因为我觉得人们看到这些可能会想：“哦，这些我都知道，太显而易见了。我有想法，我不需要做这个。” 在你看来，人们通常在哪个环节会感到惊讶？这些模块中是否有一个经常会出现“哇，这完全出乎意料”的情况？还是说通常会有很多惊喜？

---

### (00:23:41) Jake Knapp

**English:**
I think the moment where you immediately start to see value is when everyone on the team is writing down their answers to these questions. And then people put their heads up and look at what everyone else has written and they realize, "Oh, that's not what I said," or "I didn't think of that one." Or, "Gosh." The actual concrete reality of going through with the team and being very transparent and clear about how we're making decisions too about each of these things, when that basic sheet comes together and you see the specifics, the specifics are surprising, but it's also familiar.

**中文翻译:**
我认为价值立竿见影的时刻是当团队每个人写下答案，然后抬头看别人的答案时。他们会意识到：“哦，我说的不是那个，”或者“我没考虑到那一点。” 这种与团队一起经历、对每个决策都保持透明和清晰的过程，当“基础表”最终汇总并展示出具体细节时，那些细节既让人惊讶，又让人觉得似曾相识。

---

### (00:24:02) Jake Knapp

**English:**
We look at it and you say, "Yeah, that all looks right, but I'm surprised by the specifics. They're not what I would have written if I had written it down. I might've gotten two of those things, two of the six items on there." And I think that's what's most surprising. And I think it's also kind of a sense of relief that, okay, well, that's very reassuring that we have clarity about that and we've made it concrete.

**中文翻译:**
你会看着它说：“是的，看起来都对，但我对这些细节感到惊讶。如果让我自己写，我写不出这些。我可能只能想到其中的两项。” 我认为这就是最令人惊讶的地方。同时，这也会带来一种解脱感：太好了，我们对此有了清晰的认识，并把它具体化了，这让人很安心。

---

### (00:24:44) John Zeratsky

**English:**
These activities that we do during the basics are impactful for different reasons. I think that problem can be really interesting because when teams sit down and think about it, it is often less clear than they thought what the actual problem is. Like, "Wait, what problem do our customers really have that we're solving for them?" I think competition can be sort of an aha moment when they start to think beyond just what are the other startups in this space?

**中文翻译:**
我们在“基础”阶段做的这些活动，其影响力各有不同。我认为“问题”环节非常有趣，因为当团队坐下来思考时，他们往往发现实际问题并不像他们想象的那么清晰。比如：“等等，我们到底在为客户解决什么问题？” 我认为“竞争”环节也会带来“啊哈”时刻，因为他们开始思考：除了这个领域的其他初创公司，还有谁是竞争对手？

---

### (00:25:06) John Zeratsky

**English:**
If this is an important problem, your customer's probably already solving it somehow. It may be a workaround, it may be an alternative, it may not be a direct competitor, but if it's worth solving, they probably have some way of dealing with it today. And what is that? And when you zoom out and you look at that set of competitors, it can be a little scary, but it is also an important moment for teams.

**中文翻译:**
如果这是一个重要的问题，你的客户可能已经在以某种方式解决它了。可能是一个权宜之计，可能是一个替代方案，可能不是直接竞争对手，但如果这个问题值得解决，他们现在肯定有应对方法。那是什么方法？当你退后一步看这一整套竞争对手时，可能会感到有点害怕，但这对团队来说也是一个重要的时刻。

---

### (00:25:37) John Zeratsky

**English:**
And then I think that advantage isn't necessarily immediately beneficial, but it becomes really valuable when the teams are looking at differentiation, because startups can't compete with big companies on scale or on having built-in distribution advantages or having partnerships in place. So they really have to dig deep and figure out what can we do that nobody else is capable of doing?

**中文翻译:**
然后我认为“优势”环节不一定能立即见效，但当团队研究“差异化”时，它会变得非常有价值。因为初创公司无法在大公司的规模、内置的分销优势或现有的合作伙伴关系上与之竞争。所以他们必须深入挖掘：我们能做哪些别人做不到的事情？

---

### (00:26:00) John Zeratsky

**English:**
And so by taking time to sit down and do this almost unnatural act of like, wait, why are we special? And when we're able to encourage teams to really think about that, it sets them up really nicely for the next step, which is differentiation. Ideally, based on those advantages.

**中文翻译:**
通过花时间坐下来做这种近乎“反直觉”的行为——等等，我们为什么特别？——当我们鼓励团队真正思考这一点时，就为下一步“差异化”打下了良好的基础。理想情况下，差异化应该是基于这些优势的。

---

### (00:26:20) Lenny Rachitsky

**English:**
What I'm hearing is a lot of the value here is also just everyone has the answers in their head in some way, but just seeing what everyone else is thinking and then aligning on one is a lot of this value.

**中文翻译:**
我听明白了大意，这里的很多价值在于：每个人脑子里其实都有答案，但看到其他人在想什么，然后达成共识，这才是核心价值所在。

---

### (00:26:33) John Zeratsky

**English:**
Yeah. It's like thinking deeply and quietly about it yourself and then seeing what everybody else comes up with when they are able to also think deeply and quietly about it. Then ideally, if they're working with us in character labs, having somebody who's a bit external to push them and say, try harder, dig deeper. What really makes you special here? How are you really going to beat OpenAI? How are you really going to beat Google at this.

**中文翻译:**
是的。这就像是你自己静静地深度思考，然后看看其他人在同样深度思考后得出了什么。理想情况下，如果他们在 Character Labs 与我们合作，还会有一个外部视角来推动他们：“再努力一点，挖深一点。到底是什么让你在这里变得特别？你打算怎么打败 OpenAI？你打算怎么在这个领域打败 Google？”

---

### (00:27:00) Lenny Rachitsky

**English:**
This whole idea of noting and voting and working in silence. Such a recurring theme on this podcast of not doing brainstorms in large groups with a lot of people. It feels like that's just dead in every way. I just had this naming expert on the podcast who names some of the biggest companies in the world, Pentium, Powerbook, Sonos, Purcell, and that's their approach is they used to do brainstorms. He's like, that doesn't work. And now they just have small teams sitting quietly in a room working together on ideas and then thinking on their own. So that's such an interesting trend and I feel like IDEO just created this whole, we need to brainstorm post-its, and then everyone's like, that's not actually working. Let's stop doing that.

**中文翻译:**
这种“记录与投票”以及“沉默工作”的想法，是这个播客中反复出现的主题——不要进行那种很多人参加的大型头脑风暴。感觉那种方式已经彻底过时了。我刚采访过一位命名专家，他曾为 Pentium、Powerbook、Sonos、Purcell 等大品牌命名，他们的做法也是如此。他说头脑风暴行不通，现在他们只是让小团队静静地坐在房间里，先独立思考，再一起讨论。这是一个非常有趣的趋势。感觉 IDEO 创造了那种“贴满便利贴的头脑风暴”文化，然后现在大家发现那其实没用，决定不再那样做了。

---

### (00:27:36) Lenny Rachitsky

**English:**
The other thing that I feel as you're talking through this, what I'm feeling this is for founders, there's not a manual for starting a company. It feels like this dark art of like, I guess I got to find product market fit. And this idea, it feels like this is almost a manual of everything you need to do to just get the basics of is this even worth doing?

**中文翻译:**
另一件我在听你们讲解时的感受是：对于创始人来说，创业并没有说明书。这感觉就像一种“黑魔法”，比如“我猜我得找到 PMF”。而这个方法，感觉就像是一本手册，告诉你为了确定“这件事是否值得做”，你需要完成的所有基础工作。

---

### (00:27:56) John Zeratsky

**English:**
Yeah. And that's why we created it because we still are investing in founders who are... They're incredibly talented and they're smart and they have a background that is going to give them an advantage in building some particular product. But you're right, there's no manual and we were just kind of solving our own problem and we believe in this so much and we see the ROI as being so great that this is the first thing we do when we make an investment.

**中文翻译:**
没错。这就是我们创建它的原因。我们投资的创始人非常有才华、聪明，并且拥有能让他们在构建特定产品时具备优势的背景。但你说得对，没有说明书。我们只是在解决自己的问题。我们非常相信这一点，并且看到了巨大的投资回报率，所以这是我们投资后做的第一件事。

---

### (00:28:24) John Zeratsky

**English:**
We invest in a company and then we run a foundation sprint with them right away. We run more foundation sprints with startups than we do design sprints at this point. And I don't think we can ever encapsulate every single thing that you need to know or that you need to do to start a company, but this is our best take at what you should do in the early days to set yourself up for success and maximize the chances that you're going to reach product market fit.

**中文翻译:**
我们投资一家公司，然后立即和他们一起运行基础冲刺。目前，我们与初创公司运行的基础冲刺比设计冲刺还要多。我不认为我们能囊括创业需要知道或做的每一件事，但这是我们对于“早期应该做什么以奠定成功基础并最大化实现 PMF 概率”的最佳方案。

---

### (00:28:52) Lenny Rachitsky

**English:**
Amazing. Okay, let's keep it going. So we've done the basics. What comes next?

**中文翻译:**
太棒了。好，继续。我们已经完成了“基础”，接下来是什么？

---

### (00:28:55) Jake Knapp

**English:**
Yeah, so we've done the basics and another important thing that we've accomplished while going through the sequence of activities and the basics is to boot up the right context into everyone's head so that we're ready for the main event of this first day, which is differentiation. And I still have very firmly in my mind, I grew up with a Mac plus computer and you'd put in the disk and the drive and you'd have to boot up the app that you wanted to run. That's kind of the way our brains work. We have limited working memory and we've got to have the right stuff in there when we're going to make a big decision, when we're going to think hard about a certain problem or question, it's important to have the right context fresh at hand. So the basics is really the context for thinking about differentiation.

**中文翻译:**
是的，完成了基础部分后，我们还完成了一件重要的事：在每个人的脑海中加载正确的“上下文”（Context），为第一天的重头戏——“差异化”做好准备。我脑子里一直有一个画面：我小时候用 Mac Plus 电脑，你得把磁盘插进驱动器，加载你想运行的程序。我们的大脑也是这样工作的。我们的工作记忆有限，当我们要做重大决策或深入思考某个问题时，手头必须有新鲜、正确的背景信息。所以，“基础”实际上是思考“差异化”的背景。

---

### (00:29:43) Jake Knapp

**English:**
And differentiation is the heart of what we're doing in the foundation sprint because it goes without saying perhaps, but we like to say it. When you are making a new product, people want to ignore it. People want to not pay attention to it, and if they do have to pay attention to it, if it gets in their face, they want to not try it because we just are all bombarded by so many things and that's never been more true than it is now.

**中文翻译:**
“差异化”是基础冲刺的核心。也许这不言而喻，但我们还是想强调：当你做一个新产品时，人们本能地想忽略它。他们不想关注它，如果非看不可，他们也不想尝试，因为我们都被太多的信息轰炸了，现在尤其如此。

---

### (00:30:10) Jake Knapp

**English:**
And so we have defenses up to save calories in our brain. We don't want to engage. It's crucial then that a product has a clear promise that it makes, and that promise is radically differentiated from the alternatives and that that promise is strong enough that you'll try it and then that the product delivers on that promise. And so when we talk about differentiation, we're saying, look, we want you to be really clear on your promise, not the promise you're making to investors about this technology and what's special about the technology or what's special about the market opportunity, but what the customer at the center. We've started the basics by talking about the customer and the problem they have and the way they see the world.

**中文翻译:**
为了节省大脑热量，我们建立了防御机制，不想参与其中。因此，产品必须有一个清晰的“承诺”（Promise），而且这个承诺必须与替代方案有根本性的区别，强大到足以让你愿意尝试，并且产品最终能兑现这个承诺。所以当我们谈论差异化时，我们是说：你要非常清楚你的承诺是什么。不是你对投资者说的关于技术或市场机会的承诺，而是以客户为中心的承诺。我们在“基础”阶段已经讨论了客户、他们的问题以及他们看世界的方式。

---

### (00:30:53) Jake Knapp

**English:**
And we want to talk about what you're going to offer to the customer and how it's going to separate from the alternatives. And so in the end of this next phase of the foundation sprint, we're going to have a two-by-two diagram that's going to look like a business school one-on-one diagram. And in fact, we often refer back to this Steve Jobs iPhone introduction slide where he talks about the iPhone and he makes a joke about it. This is a business school one-on-one diagram, but it's really helpful to start developing your product with this clarity about this is the promise we'll make to customers at the end, and we're going to deliver on that promise because we can test and prove that in design sprints. So anyway, we start off, we talk about differentiators and we talk about classic differentiators, fast to slow, smart to not so smart to borrow from the iPhone slide, easy to use to hard to use, and so on.

**中文翻译:**
我们要讨论你将为客户提供什么，以及它如何与替代方案区分开来。在基础冲刺的这个阶段结束时，我们会得到一个 2x2 矩阵图，看起来就像商学院入门课里的那种图。事实上，我们经常引用乔布斯发布 iPhone 时的那张幻灯片，他当时还开了个玩笑。虽然这是商学院的基础东西，但对于开发产品来说，明确“这是我们最终对客户的承诺”非常有帮助，因为我们可以在设计冲刺中测试并证明我们能兑现它。总之，我们先从“经典差异化维度”开始：快与慢、聪明与不那么聪明（借用 iPhone 的幻灯片）、易用与难用等等。

---

### (00:31:44) Jake Knapp

**English:**
And we just start off and have the team, okay, let's just score those up against the competition. Put a sticky note on those continuums showing where you think the product could be. And usually you'll do this and maybe you'll start to see there are a couple places where we can stand out on these classics. That's great. These classics are easily understandable by any customer. We're all sort of familiar with these kinds of things. So okay, that's great. Then we get into writing custom differentiators. So we're going to write a bunch of good things on one end, crummy opposite on the other end, and then we're going to score those. And so for the Latchet story, we'll pick up with Chris and James here. They've written, well, we could really differentiate on networked versus siloed. Our approach is networked. If you're using Shopify, you're siloed, or maybe we can differentiate on painless business growth versus labor-intensive business growth.

**中文翻译:**
我们让团队针对竞争对手在这些维度上打分。在这些连续的光谱上贴上便利贴，展示你认为产品所处的位置。通常你会发现，在这些经典维度上，有那么一两个点我们可以脱颖而出。这很好，因为经典维度对任何客户来说都易于理解。接着，我们进入“自定义差异化维度”。我们会写下一系列好的特质，另一端写下糟糕的对立面，然后打分。回到 Latchet 的故事，Chris 和 James 写道：我们可以在“网络化 vs. 孤岛化”上做差异化。我们的方法是网络化的，而 Shopify 是孤岛化的。或者在“无痛业务增长 vs. 劳动密集型业务增长”上做差异化。

---

### (00:32:37) Jake Knapp

**English:**
So that might be the specific way we describe the promise of our product. So after evaluating a bunch of these, writing a bunch of these, voting on them quietly, and then the decider's going to say, all right, I don't want to choose a couple of these and we're going to try them out. The teams are going to... If you're running a foundation sprint, you're going to try out a few differentiators. You're going to score against your competitors. You're going to create a scale and you're going to say, okay, let's be honest. Let's be tough. Where do we really think we could stack up against the competitors on this differentiator we've chosen in great detail plotting each company or product one at a time. Okay, so you do that for one differentiator, you do it for another, you do it until you feel like we've got two that are really strong, and then you make that business school one-on-one diagram. And so here's this one for says Lyric, they changed their name to Latchet, so I'm going to edit that real time.

**中文翻译:**
这可能就是我们描述产品承诺的具体方式。在评估、编写并静静投票后，决策者会说：“好，我想选这两个，我们来试试。” 如果你在运行基础冲刺，你会尝试几个差异化点，并针对竞争对手打分。你会建立一个刻度并说：“好，让我们诚实点，严苛点。在这个我们选定的差异化点上，我们到底能排在竞争对手的什么位置？” 逐个标注每家公司或产品。为一个维度做完，再为另一个做，直到找到两个非常强有力的维度，然后制作那个商学院式的 2x2 矩阵。这里有一个，上面写着 Lyric（他们后来改名叫 Latchet 了，我实时改一下）。

---

### (00:33:29) Lenny Rachitsky

**English:**
I love this. So just rebrand.

**中文翻译:**
我喜欢这个，现场改名。

---

### (00:33:32) Jake Knapp

**English:**
Yeah. So Latchet's up here in the top-right corner and we say, okay, look, this is a good differentiation chart because you've got this quadrant here, this quadrant here, this quadrant here, right? You've got the... So you're in the top-right and you've-

**中文翻译:**
是的。Latchet 在右上角。我们说，看，这是一个很好的差异化图表，因为你有这几个象限。你在右上角，而且你——

---

### (00:33:46) Lenny Rachitsky

**English:**
You've got to be in the top-right, you got to be in the top-right.

**中文翻译:**
必须在右上角，必须在右上角。

---

### (00:33:48) Jake Knapp

**English:**
You always have to be in the top-right. And if you see those other three quadrants, the top-left, bottom-left, bottom-right, those form an L shape and we call that Loserville. So we want to have a way of looking at the world that puts all of the competitors into Loserville. And then we want to say, okay, if you can deliver on that and if that promise is compelling to customers. So both those things have to be true. Can you deliver on it and do customers care and believe that that matters to them? If both of those things are true, you have a really compelling promise. You have the possibility of a very successful product. So now we've identified that and that becomes a core of our hypothesis. Is that differentiation true? So that's the differentiation step.

**中文翻译:**
你永远得在右上角。如果你看其他三个象限（左上、左下、右下），它们形成了一个 L 型，我们称之为“失败者之城”（Loserville）。我们要找到一种看待世界的方式，把所有竞争对手都扔进“失败者之城”。然后我们要问：你能兑现这个承诺吗？这个承诺对客户有吸引力吗？这两点必须同时成立：你能做到，且客户在意。如果都成立，你就拥有了一个极具吸引力的承诺，也就拥有了成功的可能。现在我们确定了这一点，它就成了我们假设的核心：这个差异化是真的吗？这就是差异化步骤。

---

### (00:34:39) Lenny Rachitsky

**English:**
Before you move on to the next step, is that where you were going next? Just so I could take a-

**中文翻译:**
在你进入下一步之前，那是你接下来要讲的吗？我想追问——

---

### (00:34:42) Jake Knapp

**English:**
Yeah, yeah.

**中文翻译:**
是的，没错。

---

### (00:34:43) Lenny Rachitsky

**English:**
Okay. Follow a couple of threads. This is so awesome. There's just so much value here. Also, just this slide at the end here, folks are watching YouTube. This is your deck slide where you show your competitors and how you're better than them all.

**中文翻译:**
好。我想追问几个点。这太棒了，信息量巨大。而且最后这张幻灯片，看 YouTube 的朋友们注意了，这就是你融资 PPT 里的那一页，展示你的竞争对手以及你如何全面超越他们。

---

### (00:34:57) Jake Knapp

**English:**
And actually I want to jump on that for a second because we've all seen two by two. Hey Graham, right? There's a ton of these. They're all over the place. And if you're anything like me, I just ignored these. I just thought these were pretty much BS up until, well, whenever we started putting these foundations friends three or four years ago. And I think the reason why usually these two by two diagrams feel like this is just consultant baloney. This is just like who... It's because maybe one person makes this chart and they do it quickly because they needed to slide for the slide deck and the audience they're considering, maybe it's investors. And so often these describe technology or they describe the market opportunity, they don't talk about the customer's perspective. And the other thing is that they're not proven. There's no evidence behind the fact that these are true.

**中文翻译:**
事实上我想补充一点，因为我们都见过这种 2x2 矩阵，到处都是。如果你像我一样，以前肯定会忽略它们，觉得那都是胡扯，直到三四年前我们开始做基础冲刺。我认为通常这些图表让人觉得是“咨询顾问的废话”，是因为往往只有一个人为了做 PPT 快速画出来的，受众可能是投资者。而且这些图表通常描述的是技术或市场机会，而不是客户的视角。另一件事是，它们未经证实，没有证据表明它们是真的。

---

### (00:35:50) Jake Knapp

**English:**
So if they did happen to be about customer perspective, it's unlikely that the whole team would've weighed in on what those differentiators are, and it's very unlikely that we would've tested and proven that matters and that we can deliver on it. And so if you do all of those things and you do it at the beginning of the project, we think this has the potential, when we've seen it becomes this, well, this guiding light, here's the North Star. We need to deliver on this. This is what we have to create. And that helps you make decisions all the way through your product development cycle.

**中文翻译:**
即使它们恰好是关于客户视角的，也很少有整个团队共同参与讨论这些差异化点的情况，更不用说去测试和证明这些点是否真的重要以及我们能否做到了。如果你在项目初期就完成了这些工作，它就有潜力成为指路明灯和北极星：我们需要兑现这个承诺，这就是我们要创造的东西。这会帮助你在整个产品开发周期中做出决策。

---

### (00:36:24) Lenny Rachitsky

**English:**
Just to point people to justification for why differentiation is so important, there's a couple of episodes that I did that I'll point to in the show notes that just give you more context of why you need to differentiate. So I spoke of David Plastic who is this naming expert that we just had on the podcast. His whole thing is when he's coming up with a name for Sonos or Purcell or Windsor, it has to differentiate. And he talks about this in depth. So we'll point to that episode and this is just like if you're not convinced, why are we spending so much time in differentiation? Also, April Dunford who's like, I don't know, the god of positioning. She has differentiation is such a core part of her approach to positioning. And so there's just so much evidence to tell you that differentiation is a really important step and element of successful companies.

**中文翻译:**
为了向大家证明差异化为何如此重要，我曾在几期节目中讨论过这个话题，我会把链接放在节目介绍里。我采访过命名专家 David Placek，他的核心观点是：当他为 Sonos 或 Purcell 命名时，名字必须具备差异化。他深入探讨了这一点。此外还有定位大神 April Dunford，差异化也是她定位方法的核心。有太多的证据表明，差异化是成功公司至关重要的步骤和元素。

---

### (00:37:13) Jake Knapp

**English:**
One of the things that I've noticed about these topics that the basics we talked about already, differentiation, this notion of you need a foundation for your project. It's a bit more under the radar for people. I think it's a bit harder for people to immediately see like, oh, we need this. We see the people who react the strongest to this and have the strongest immediate affinity to this idea actually being start-up founders, people who are really sophisticated in this challenge. Product managers who are at... We were invited in to speak at open AI and anthropic about this, and we see the product people, they're being like, oh my god, this is really powerful. This is the kind of stuff we need.

**中文翻译:**
我注意到，关于“基础”和“差异化”这些话题，也就是“项目需要基础”这个概念，往往容易被人们忽视。人们很难立即意识到“哦，我们需要这个”。我们发现，对此反应最强烈、最认同这个想法的人，实际上是那些深谙此道的初创公司创始人，或者是像 OpenAI、Anthropic 这种公司的产品经理。当我们受邀去那里演讲时，产品人员会感叹：“天哪，这太强大了，这正是我们需要的东西。”

---

### (00:37:52) Jake Knapp

**English:**
I think for a lot of folks though, it can sound like this is just elementary, differentiation. Of course we need to differentiate. The problem is that all of this stuff gets backgrounded. It's something we've thought about a bit. We assume we're on the same page, we assume we're going to deliver something, but then business as usual happens, we build a product, we get kind of more interested in the technology and delivering that, and we end up trying to sell it to customers at the end. We end up putting a coat of paint on it with a marketing page or sales deck. We haven't actually built from the beginning the thing that we know is going to matter to people.

**中文翻译:**
但对很多人来说，这听起来可能太基础了——差异化嘛，谁不知道要差异化？问题在于，这些东西往往被当成了背景板。我们只是稍微想了一下，就假设大家达成共识了，假设我们会交付一些东西。但随后日常工作接管了一切，我们开始构建产品，变得更关注技术实现，最后才尝试卖给客户。我们只是在最后用营销页面或销售 PPT 给它刷层漆，而没有从一开始就构建那个我们知道对人们真正重要的东西。

---

### (00:38:28) Lenny Rachitsky

**English:**
One of the most useful steps here that I haven't seen before is just a starting place for how to even start thinking about differentiation. Everyone's always probably thinking price and speed maybe. You guys have a really cool just starting list that you showed here. Anything more you can add here for helping people start to think about ways to differentiate beyond the obvious price and speed. And I don't know, a couple more.

**中文翻译:**
这里最实用的步骤之一，也是我以前没见过的，就是提供了一个思考差异化的起点。大家可能首先想到的都是价格和速度。你们展示了一个非常酷的初始清单。关于如何引导人们思考价格和速度之外的差异化方式，你们还有什么可以补充的吗？

---

### (00:38:50) Jake Knapp

**English:**
So I'm just going to jump into another startup here just so we can see what this sheet looks like with scores on it. So this is a startup called Mellow. Anyway, the standard classic differentiators where we start, they are fast to slow, smart to not so smart, easy to use to hard to use, free to expensive, focused to one size fits all, simple to complicated and integrated to siloed. And so you could probably argue there's these others that should be included or some of those should be taken off. But what we like about this is that it's a small set. They're easy to understand.

**中文翻译:**
我换另一家初创公司的例子，这样我们可以看到带分数的表格是什么样的。这是一家叫 Mellow 的公司。总之，我们开始时使用的标准经典差异化维度包括：快与慢、聪明与不那么聪明、易用与难用、免费与昂贵、聚焦与通用（One size fits all）、简单与复杂、集成与孤岛。你可能会争论应该增加或删除某些维度，但我们喜欢这套维度的原因是它们数量少且易于理解。

---

### (00:39:31) Jake Knapp

**English:**
We know customers can understand these and they create a great starting place for your team to think about differentiation because you can quickly look at this list and start scoring where you think your product could be on these scales and you know that if you can use one of these, people will understand it. But it also starts to make the team comfortable with this notion of differentiation. And again, we want to make differentiation something that all of the co-founders or core team can participate in. It's not just the job of the person writing the pitch deck. It's not just the job of the marketer or the salesperson, but we're getting everybody's perspective in on it and this is a great warm up activity before we start to write our own custom differentiators.

**中文翻译:**
我们知道客户能理解这些，它们为团队思考差异化提供了一个很好的起点。你可以快速浏览清单，在这些刻度上给你的产品打分。你知道如果你能利用其中一个，人们就能听懂。同时，这也能让团队开始适应“差异化”这个概念。我们希望差异化是所有联合创始人或核心团队都能参与的事情，而不仅仅是写融资 PPT 的人、营销人员或销售人员的工作。在开始编写自定义差异化维度之前，这是一个很好的热身活动。

---

### (00:40:17) Lenny Rachitsky

**English:**
Awesome. And then again, this is just inspiration for coming up with more ways to differentiate. Something that is a common question I think for founders is price as a differentiator. Is there any insight you guys have there? How often do you land on price being a good differentiator with the startups you work with?

**中文翻译:**
太棒了。这为寻找更多差异化方式提供了灵感。我觉得创始人常问的一个问题是：价格能作为差异化点吗？你们对此有什么见解？在你们合作的初创公司中，价格成为有效差异化点的情况多吗？

---

### (00:40:33) John Zeratsky

**English:**
I think price is rarely the most important differentiator. Part of what's interesting about going through these classic differentiators, these standard ones first and then jumping into the custom ones is that the classic ones are sort of universal, but it is going to be hard beat the competition on very many of these. It's going to be hard to build a product that's faster than what Google can build or what OpenAI can build. It's going to be harder to be cheaper than those competitors because they just have so many more resources. They can have lost leader products that are underpriced.

**中文翻译:**
我认为价格很少是最重要的差异化点。先过一遍经典维度再进入自定义维度的有趣之处在于：经典维度是通用的，但你很难在很多维度上击败竞争对手。你很难做出比 Google 或 OpenAI 更快的产品，也很难比他们更便宜，因为他们拥有更多的资源，甚至可以提供亏本引流的产品。

---

### (00:41:31) John Zeratsky

**English:**
Where I think pricing has become a really clear advantage for some companies is those that are leveraging AI to solve problems that were previously unsolvable with software. So we have a company that we invested in called BindWell and they use AI to design precision pesticides. And we ran a foundation sprint with them right after investing and five years ago you couldn't design pesticides with AI. It wasn't possible. Even if you had that idea, you wouldn't have been able to build it and now you can. And so for them, one of the big advantages is yeah, these pesticides, they can be a lot cheaper because it doesn't require this massive team of R&D chemists to tinker and experiment with things in the lab to try to create new pesticides. We can design them with AI. So it is more often true in AI companies like that, but it's very difficult to compete on price in general. And we think we find that it is not as durable of an advantage as some of these other things.

**中文翻译:**
我认为价格成为明显优势的情况，通常是那些利用 AI 解决了以前软件无法解决的问题的公司。我们投资了一家叫 BindWell 的公司，他们利用 AI 设计精准农药。五年前，用 AI 设计农药是不可能的，即使你有这个想法也做不出来，但现在可以了。对他们来说，一个巨大的优势是这些农药可以便宜得多，因为不再需要庞大的研发化学家团队在实验室里反复试验，我们可以用 AI 设计。所以这种情况在 AI 公司中更常见，但总的来说，靠价格竞争非常困难。我们发现，价格优势通常不如其他维度的优势持久。

---

### (00:42:18) Lenny Rachitsky

**English:**
That is such a good point because historically price has been don't compete on price for exactly what you said. It's hard to do long term. It's kind right to the bottom, especially if there's incumbents, they can price a lot lower. But with AI, that is a really often and strong differentiator. Now do this thing like cursor basically is competing on. You're saving engineering time and it's worth so much money to you.

**中文翻译:**
这说得太对了。历史上大家总说不要竞争价格，原因正如你所说：很难长期维持，而且容易陷入价格战，尤其是面对可以定更低价的现有巨头。但在 AI 时代，价格确实是一个常见且强力的差异化点。就像 Cursor 这样的工具，它实际上是在竞争“节省工程时间”，而这对你来说价值连城。

---

### (00:42:42) John Zeratsky

**English:**
At the same time, the output of the AI is probably not going to be quite as good as a human process. So it can be a little bit cheaper for now, but it has to be a lot cheaper. It has to be... I've heard people offer 10X cheaper than the legacy sort of manual approach to solving that problem as the rule of thumb.

**中文翻译:**
与此同时，AI 的输出目前可能还不如人工流程那么好。所以它现在可以便宜一点，但必须便宜“很多”。我听过一个经验法则：必须比传统的、手动解决该问题的方法便宜 10 倍才行。

---

### (00:43:02) Lenny Rachitsky

**English:**
That's awesome. I'll just quickly reference, there's an episode that will come out before this with Modobon about pricing strategy and there's a lot of discussion actually on this. Especially with how to design your price with customers as you're starting your company. Also, the episode with the founder of Superhuman Rahul, he actually spent, there's a lot of cool context on how he differentiated Superhuman and it was actually very much on speed. His speed actually. Yeah, speed was where he landed. And to your point, it was both... It was the Venn diagram of what you said, can we do this and do people value it? And that's where his research pointed to is people really value this and they were able to achieve it.

**中文翻译:**
太棒了。我顺便提一下，在这一集之前会有一集关于定价策略的节目，里面有很多相关的讨论，特别是关于创业初期如何与客户共同设计价格。还有采访 Superhuman 创始人 Rahul 的那一集，他分享了很多关于 Superhuman 如何做差异化的背景，结果发现核心就在于“速度”。正如你所说，那是“我们能否做到”和“人们是否看重”的交集。他的研究表明人们非常看重速度，而他们也确实做到了。

---

### (00:43:38) John Zeratsky

**English:**
One of the things that's really interesting about this example here that we're looking at Mellow is that you can see that they were not the best on all these scales. If teams are through and they're being really realistic about how they stack up against the competition, it's normal and natural to find that you're not going to be the best on all these differentiators. And that is really helpful for creating clarity in your positioning and in your marketing because you're not going to show a feature checklist chart that says you're better at everything than every competitor.

**中文翻译:**
我们看到的 Mellow 这个例子中，非常有趣的一点是：你可以看到他们在所有维度上并不是都是最好的。如果团队能诚实、现实地评估自己与竞争对手的差距，你会发现自己不可能在所有差异化维度上都拿第一，这很正常。这对于理清定位和营销非常有帮助，因为你不需要展示一个“功能对比表”来宣称你在每一项上都优于竞争对手。

---

### (00:44:22) John Zeratsky

**English:**
But if you can drive home one or two things that your customers really care about and that you can be radically better at, it's going to improve your chances of winning and finding product market fit. And we find that going through this process where you're not just thinking about one differentiator at a time or you're not trying to win on all of them, but you're looking across this scale of options and you're being just really honest about where you stack up can both point you in the right direction in terms of what you will win on, but also can give you the comfort to say, hey, it's okay if we're not better than every single company on every single one of these things.

**中文翻译:**
但如果你能抓住一两个客户真正关心的点，并且做到“彻底超越”，就能提高获胜和实现 PMF 的机会。我们发现，通过这个过程——不是一次只考虑一个维度，也不是试图在所有维度上获胜，而是审视所有选项并诚实评估自己的位置——既能指引你获胜的方向，也能让你释怀：嘿，我们在某些方面不如别人也没关系。

---

### (00:44:44) Lenny Rachitsky

**English:**
That's great context. That's going to make people feel a lot better I think. Today's episode is brought to you by Coda. I personally use Coda every single day to manage my podcast and also to manage my community. It's where I put the questions that I plan to ask every guest that's coming on the podcast. It's where I put my community resources. It's how I manage my workflows. Here's how Coda can help you. Imagine starting a project at work and your vision is clear exactly who's doing what and where to find the data that you need to do your part. In fact, you don't have to waste time searching for anything because everything your team needs from project trackers and OKRs to documents and spreadsheets lives in one tab all in Coda.

**中文翻译:**
这背景太棒了，我想这会让很多人感到宽慰。今天的节目由 Coda 赞助。我个人每天都在用 Coda 来管理我的播客和社区。我会把要问嘉宾的问题放在那里，管理社区资源和工作流。Coda 能如何帮助你？想象一下开始一个工作项目，愿景清晰，分工明确，数据触手可及。事实上，你不需要浪费时间寻找任何东西，因为团队需要的一切——从项目追踪器、OKR 到文档和表格——都存在于 Coda 的一个标签页中。

---

### (00:45:36) Lenny Rachitsky

**English:**
With Coda's collaborative all in one workspace, you get the flexibility of docs, the structure of spreadsheets, the power of applications, and the intelligence of AI all in one easy to organize tab. Like I mentioned earlier, I use Coda every single day. And more than 50,000 teams trust Coda to keep them more aligned and focused. If you're a startup team looking to increase alignment and agility, Coda can help you move from planning to execution in record time. To try it for yourself, go to Coda.io/Lenny today and get six months free of the team plan for startups. That's Coda.io/Lenny to get started for free and get six months of the team plan, Coda.io/Lenny. Anything else on differentiation before we move on to the third step of designing your approach?

**中文翻译:**
通过 Coda 的全能协作工作区，你可以在一个易于组织的标签页中获得文档的灵活性、表格的结构化、应用的功能以及 AI 的智能。正如我提到的，我每天都用 Coda。超过 50,000 个团队信任 Coda，用它来保持一致和专注。如果你是一个初创团队，想要提高一致性和敏捷性，Coda 可以帮助你以创纪录的速度从计划转向执行。请访问 Coda.io/Lenny 免费试用，初创公司可获得 6 个月的免费团队计划。关于差异化还有什么要补充的吗？我们要进入第三步“设计路径”了。

---

### (00:46:10) Jake Knapp

**English:**
I think it's worth taking a look at what it looks like when you have a bunch of these custom crafted differentiators, what that might look like. Because in the case of Mellow, we've got, I don't know, there must be 25 here. And so they've written purposeful, magical, clear, personal, provides direction, flexible, human creative, beautiful, and on and on. What they're trying to get at and what we want every team to think about here is what is a new version of reality, a new lens that you can offer to your customers on the world. Because a lot of times you're building a new product, you actually have to change the way people think about what's possible and what matters to them.

**中文翻译:**
我认为值得看看拥有一堆“自定义差异化维度”是什么样子的。在 Mellow 的例子中，这里大概有 25 个维度。他们写了：有目的的、神奇的、清晰的、个性化的、提供方向的、灵活的、人性化的、有创造力的、美丽的等等。他们试图表达的，也是我们希望每个团队思考的，是：你能为客户提供什么样的“现实新版本”或“看待世界的新视角”？因为很多时候你构建新产品，实际上是在改变人们对“什么是可能的”以及“什么对他们重要”的看法。

---

### (00:47:09) Jake Knapp

**English:**
Those classics are often already well-trodden ground where other people have differentiated, they've already thought about it, but these new particular things that are possible with your technology that you know is possible with the customer problem, the things that you believe might matter. It's really interesting to try some very fine-tuned list of sometimes just a slight variation. We slightly change this wording or the way we describe what's great about what we do. And that is the thing we think is really going to stand out. And again, you can see even on this list that they've custom written, when we see where they score it, they're not all the way to the good end of the scale on all of them. When they get honest and look through, they're like, well actually, maybe we can't deliver on this, but this one we really can. And this one we also suspect will matter to customers.

**中文翻译:**
那些经典维度往往已经被别人踩烂了，大家都想过了。但利用你的技术、针对客户问题所能实现的那些独特的新事物，才是你认为可能重要的。尝试一些非常精细的列表，有时只是措辞的微小变化，或者描述我们优势的方式稍作改变，这非常有趣。这就是我们认为真正能脱颖而出的东西。同样，即使在他们自定义的清单上，打分时也不是每一项都完美。当他们诚实审视时，会发现：“好吧，也许这项我们做不到，但这一项我们绝对能做到，而且我们怀疑客户会很在意这一项。”

---

### (00:47:43) Lenny Rachitsky

**English:**
Where did Mellow land on the differentiators they picked and where did Latchit Land?

**中文翻译:**
Mellow 最终选择了哪些差异化点？Latchet 呢？

---

### (00:47:47) Jake Knapp

**English:**
Yeah, let's take a look. For Mellow, they trade out a bunch before they decided here. So they actually scored with the competitors on these scales.

**中文翻译:**
好，来看看。Mellow 在最终决定前尝试了很多。他们在这些刻度上与竞争对手进行了对比。

---

### (00:47:57) John Zeratsky

**English:**
And just for context, Mellow is a tool that allows you to run very simple, very targeted, very useful AI agents for common everyday tasks like summarizing your email or cleaning up your calendar or drafting responses to messages. And one of their insights was that there's been so many AI products that have over-promised about being able to replace all humans and do anything and 10X year productivity, but so few of them have actually delivered on those promises. And so they have this insight that if they can be really focused and really human and really high quality and they can deliver on that promise of making your life better by offloading tedious tasks that that's going to really click with customers.

**中文翻译:**
补充一下背景：Mellow 是一个工具，让你能运行非常简单、精准且实用的 AI 智能体，处理日常任务，如总结邮件、清理日历或起草回复。他们的洞察之一是：市面上太多的 AI 产品过度承诺，宣称能取代所有人、无所不能、提高 10 倍生产力，但很少有能兑现的。所以他们的洞察是：如果能做到非常聚焦、非常人性化、高质量，并兑现“通过卸载繁琐任务让生活更美好”的承诺，就能真正赢得客户。

---

### (00:48:52) Jake Knapp

**English:**
So Mellow lands on mobile first and works out of the box if there are two differentiators and they're trying to differentiate from Gumloop and OpenAI is sort of a generalized tool and Latchit they're going to differentiate on...

**中文翻译:**
所以 Mellow 最终选定了“移动优先”和“开箱即用”这两个差异化点，试图与 Gumloop 以及像 OpenAI 这种通用工具区分开来。而 Latchet，他们选择的差异化点是……

---

### (00:49:10) Lenny Rachitsky

**English:**
We're pulling it up. If folks aren't watching, he's pulling up the mirror board to show us where they landed.

**中文翻译:**
我们正在调出画面。没在看视频的朋友们，他正在打开 Miro 板展示结果。

---

### (00:49:15) Jake Knapp

**English:**
Latchit, they're going to differentiate on helps you grow and cooperative. So when they compare against Etsy, when they compare against Shopify or setting up your table at an art fair, they're going to differentiate on helps you grow and cooperative. And they think none of the competitors does both of those things well.

**中文翻译:**
Latchet 选择了“助力增长”和“协作性”。当他们与 Etsy、Shopify 或艺术展摆摊相比时，他们强调这两点。他们认为没有竞争对手能同时把这两点做好。

---

### (00:49:32) Lenny Rachitsky

**English:**
That is cool. Thank you for sharing that. And to your point, this is where they think it will work. And then the next step is actually test this in the market, which is where we go from here. So let's move on to the next step in which is the final step of the foundation sprint.

**中文翻译:**
很酷，谢谢分享。正如你所说，这是他们“认为”会奏效的地方。下一步是去市场测试，也就是我们接下来的方向。让我们进入基础冲刺的最后一步。

---

### (00:49:45) Jake Knapp

**English:**
So closing off differentiation is a short step that is just to create some project principles that'll help you make decisions in line with that differentiation. And you were just talking about superhuman and differentiating on speed. And when John and I worked at Google back in the 2000s, there was this list called 10 Things We've Found To Be True. And one of the things on that list was fast is better than slow. And what was interesting is this is a mantra that you would actually hear people using in meetings to help dictate decisions.

**中文翻译:**
“差异化”环节的收尾是一个简短的步骤：制定一些“项目原则”，帮助你做出符合该差异化的决策。你刚才提到 Superhuman 以速度为差异化。当我和 John 在 2000 年代在 Google 工作时，有一份清单叫《我们发现的 10 条真理》，其中一条就是“快比慢好”。有趣的是，这成了一个口号，人们在会议中真的会用它来辅助决策。

---

### (00:50:15) Jake Knapp

**English:**
Well, we're considering this approach to this view or this approach, this approach renders 12 milliseconds faster. That's probably going to be the one we're going to take. It's going to be a really compelling reason for us to not go with just the one that renders faster or the one that gets the user to their benefit with one less click. And this notion that you can have a decision-making guide, we think we've seen it be so useful for us in those contexts. We think, hey, this is an easy moment. You've got your differentiators kind of loaded up in your mind. Let's take a second here and just think, what's a principle? How can we turn that into a principle?

**中文翻译:**
比如：“我们在考虑这两种方案，这个方案渲染快 12 毫秒，那我们就选这个。” 这是一个非常有说服力的理由。这种“决策指南”的概念在那种背景下非常有用。现在你的脑子里已经装满了差异化点，花点时间想想：什么是原则？我们如何把差异化转化为原则？

---

### (00:51:10) Jake Knapp

**English:**
So if we take a look at Latchit, they've got help sellers help each other. So if they're trying to make a decision between two approaches, well, which one of these helps sellers help each other or do the thing that makes sellers more money? If we're choosing between two things, let's do the one that helps make them more money. And so then we've kind of moved on. We've got a mini manifesto we call it, which is that differentiation chart and these principles. And the notion is this page, the basics page was just kind of the core simple stuff you need to know about this project. The mini manifesto in one page is your decision-making guide.

**中文翻译:**
看看 Latchet，他们的原则是“帮助卖家互相帮助”。如果要在两种方案中做选择，就问：“哪一个能帮助卖家互相帮助，或者哪一个能让卖家赚更多钱？” 如果二选一，就选能帮他们赚更多钱的那个。这样我们就完成了，我们称之为“迷你宣言”，包括差异化图表和这些原则。基础页是你需要了解的核心信息，而这一页迷你宣言就是你的决策指南。

---

### (00:51:39) Lenny Rachitsky

**English:**
This is so cool and this looks like it would take a lot of work, but again, this is just a day or two of sitting around working through this framework.

**中文翻译:**
这太酷了，看起来需要做很多工作，但实际上只是花一两天时间坐下来按照这个框架梳理。

---

### (00:51:48) Jake Knapp

**English:**
Yeah, you'll get to this in four-ish hours.

**中文翻译:**
是的，大约 4 小时就能做到这一步。

---

### (00:51:52) Lenny Rachitsky

**English:**
By the end of the first day, you'll have a mini manifesto that describes how you win essentially as a company and a startup.

**中文翻译:**
到第一天结束时，你就会拥有一份迷你宣言，描述你作为一家公司和初创企业本质上是如何获胜的。

---

### (00:51:59) Jake Knapp

**English:**
Or how you believe it's going to work. And of course, we're going to test it. Now, the next phase of the foundation is locking in on the approach we're going to start with. So we'll continue the story of Latch It here, it's easier to use an example than to describe this in the abstract.

**中文翻译:**
或者说你“认为”它会如何奏效。当然，我们要去测试。基础冲刺的下一个阶段是锁定我们要开始采取的“路径”（Approach）。我们继续讲 Latchet 的故事，用例子比抽象描述更容易理解。

---

### (00:52:14) Jake Knapp

**English:**
Coming into Character Labs, Latch It had sort of four approaches in mind, but they weren't sure which one to take. So they might build an app, that's one approach they could take. They might build a sort of newsletter platform. That's something obviously they knew how to do. They might build a Shopify plugin, that's a simple way to kind of piggyback on something people are already doing. Their number one competitor is Shopify. Or they might have to build the full stack. And I think a big question for them was, which of these and how much do we have to build before there's enough value for customers that they're actually going to adopt it and we're actually going to get some traction and get this thing going?

**中文翻译:**
加入 Character Labs 时，Latchet 脑子里大概有四种路径，但不确定选哪条。他们可以做一个 App；可以做一个类似时事通讯的平台（这是他们擅长的）；可以做一个 Shopify 插件（这是借力现有生态的简单方法，毕竟 Shopify 是头号对手）；或者他们可能得构建全栈方案。对他们来说，一个大问题是：选哪条路？在客户真正愿意采用并产生牵引力（Traction）之前，我们需要构建多少东西？

---

### (00:52:52) John Zeratsky

**English:**
And it's important to call out here that all four of these approaches solve the same problem for the same customer. And they're all likely to differentiate from the competition in the same ways based on the unique advantages that the founders Chris and James bring to this company. So these are not wildly different product ideas or company ideas. These are just different approaches. You have the same destination in mind, but you say, "Hey, which path could we take?" It's like pulling up directions on Google Maps. This one's a little faster, this one uses less fuel, this one avoids tolls. What's the right approach for us to take?

**中文翻译:**
这里需要强调的是，这四种路径都是为同一类客户解决同一个问题。基于创始人 Chris 和 James 的独特优势，它们都可能以同样的方式实现差异化。所以这些并不是截然不同的产品或公司构思，只是不同的路径。目的地是一样的，但你在想：“嘿，我们该走哪条路？” 就像在 Google 地图上查路线：这条快一点，那条省油，这条避开收费站。哪条路最适合我们？

---

### (00:53:27) Lenny Rachitsky

**English:**
And I love the work you did on that first day eliminates a lot of ideas you probably had that you would've probably spent time building and then realizing, "Okay, this doesn't make any sense. It's just like what everyone else has."

**中文翻译:**
我喜欢第一天的工作，因为它排除了你可能原本会花时间去构建、最后才发现“这根本没意义，和别人的东西一模一样”的那些想法。

---

### (00:53:38) Jake Knapp

**English:**
Totally, totally, yeah. And we usually see teams starting projects in one of two states. And one state is the state that Latch It finds themselves in where, gosh, there's a few different ways we could do this. How do we decide? We can discuss and discuss and discuss, but that could go on forever. So that's state one. We know there are some options. And state two is we're pretty locked in on one approach already. We think we've got this figured out.

**中文翻译:**
完全正确。我们通常看到团队在开始项目时处于两种状态之一。一种是像 Latchet 这样：天哪，有好几种方法可以做，怎么决定？我们可以一直讨论下去，但这没完没了。这是状态一：知道有选项。状态二是：已经锁定了一种路径，觉得已经想通了。

---

### (00:54:07) Jake Knapp

**English:**
In either of those cases, we think it's worth taking, again, about four hours-ish to be really careful to lay out the options. If you think there's only one option to sort of force yourself to think, well, what if this doesn't work? What's another alternative? Or is there another alternative that we have previously considered and dismissed that we should maybe reconsider just to make sure? And end with a situation where you've made a decision clearly about, okay, we've considered alternatives. This is our first choice. And you've also identified this is our backup plan. So that failure doesn't seem quite so scary when we start to run experiments. And we're really able to pivot fast should that happen.

**中文翻译:**
无论是哪种情况，我们都认为值得花大约 4 小时仔细列出所有选项。如果你觉得只有一种选择，那就强迫自己思考：如果这个行不通怎么办？还有什么替代方案？或者有没有以前考虑过但被否决的方案，现在需要重新审视以确保万无一失？最后要达到一种状态：你清晰地决定了“这是首选”，同时也明确了“这是备份计划”。这样当你开始实验时，失败就不那么可怕了，而且如果需要，你能快速转型。

---

### (00:54:52) Jake Knapp

**English:**
So what we're going to do on the second day of the foundation sprint through this sort of third phase, which is the approach. Is to identify those different paths, so for Latch It here, they've got a B, C and D options. We're going to color code those and then we're going to plot them on these charts. So we've got these different lenses. We call this activity magic lenses. And the notion is, if we had a discussion about it, and we could ... as investors, if we could imagine like waving a magic wand and putting the perfect team of advisors in place to counsel the founders on this decision, we would love for them to have a customer expert, somebody who's just brilliant vision for the product and the customer experience. And they're hammering their fist on the table saying, "The customer, the customer, the customer, make the decision that's best for the customer."

**中文翻译:**
在基础冲刺的第二天，也就是第三阶段“路径”中，我们要做的就是识别这些不同的路径。对于 Latchet，他们有 A、B、C、D 四个选项。我们给它们标上颜色，然后把它们标在图表上。我们有不同的视角，称之为“魔法透镜”（Magic Lenses）。这个想法是：作为投资者，如果我们能挥动魔杖，请来最完美的顾问团队来指导创始人做决策，我们希望有一位客户专家，他对产品和客户体验有卓越的远见，他会拍着桌子说：“客户！客户！客户！做对客户最好的决定。”

---

### (00:55:42) Jake Knapp

**English:**
And so we'll plot those options on these axes of easy to use versus hard to use and perfect solution to the customer problem versus this is just an okay solution to the customer problem. And then similarly, we want an advisor who's going to pound their fist on the table for building something cheap and fast, getting it out into the market, being pragmatic, get it out there as fast as possible. That's the pragmatic lens. We want somebody who's going to advocate for growth. What's the way to reach the most customers? Get it in people's hands as fast as possible, easy to adopt. We want somebody who's going to advocate for money, for the financial health of a business. So what's going to create long-term value for the customers? Where's the biggest audience of these folks? We want to look at differentiation. Which we spent the first half of the Foundation Sprint establishing. Well, we want consider these approaches through that lens, as well.

**中文翻译:**
所以我们会把选项标在“易用 vs. 难用”以及“完美解决客户问题 vs. 勉强解决”的轴线上。同样，我们也想要一位务实的顾问，他会拍桌子要求做得又快又便宜，尽快推向市场。这就是“务实透镜”。我们还想要一位倡导增长的顾问：如何触达最多客户？如何让人们最快上手？我们还需要一位关注财务健康的顾问：什么能创造长期价值？最大的受众在哪里？最后，我们要通过“差异化透镜”来审视这些路径，也就是我们在冲刺前半段确立的那个。

---

### (00:56:34) Jake Knapp

**English:**
And so what the teams will do is to plot these options on these lenses. They'll almost always create some lenses of their own, some custom lenses that matter to them. They might have one about their conviction. I think there's sort of a humorous one for Mellow where it's like, which founder is like, "F yeah, that's exactly what I want to build." And on the other end of the spectrum it's like, nah, just kind of the sort of heat of excitement that you feel. That might be a really important decision point.

**中文翻译:**
团队会将选项标在这些透镜上。他们几乎总是会创造一些属于自己的自定义透镜。比如关于“信念”的透镜。Mellow 有一个挺幽默的透镜：哪位创始人会说“太棒了，这就是我想做的”，而另一端则是“没啥感觉”。这种兴奋程度可能是一个非常重要的决策点。

---

### (00:57:05) Lenny Rachitsky

**English:**
That feels really important. That feels like that should be one of your ... you call these the magic lenses?

**中文翻译:**
这感觉非常重要。这应该成为你们……你叫它们“魔法透镜”？

---

### (00:57:08) Jake Knapp

**English:**
Yeah, yeah. It probably should be. It probably should be [inaudible 00:57:11]-

**中文翻译:**
是的，确实应该是。

---

### (00:57:11) John Zeratsky

**English:**
If we add it, we can call it the Lenny lens.

**中文翻译:**
如果我们加上它，可以叫它“Lenny 透镜”。

---

### (00:57:24) Jake Knapp

**English:**
The Lenny lens. Yeah. Oh, that's a good idea. (00:57:28): Yeah, so here it is. And you can see that Marie is more likely to swear than Ben apparently. But it's crucial, right? And many founders, they'll have different ... one of the challenges is that for each founder, I think, each set of founders, there's maybe a different way that they phrase what that means. What conviction means to them. And maybe it's as simple as this, I just feel it, I just know. And sometimes it's a little bit more like, well, it's conviction, but it's also, what's the data that we have behind it? And that's what forms my intuition about it.

**中文翻译:**
Lenny 透镜，好主意。看这里，显然 Marie 比 Ben 更容易爆粗口（指兴奋程度）。但这至关重要，对吧？很多创始人对“信念”的表达方式不同。有时很简单：“我就是感觉到了，我知道。” 有时则更复杂：“这是信念，但也基于我们掌握的数据，数据塑造了我的直觉。”

---

### (00:58:13) Jake Knapp

**English:**
So the cool thing about this lens's thing is at the end, you've done all that, you've plotted it all out. And if you're having a conversation like that, you just have to sort of maintain in memory, what did that person say? What did that other person say? What's that conversation I had a week ago? Whatever. Here it's all laid out and sometimes you zoom out and it's honestly as simple as like, "Oh, hey, look, the blue one is in the top right quadrant of almost every single lens. What is that one? What's going on? That might just be an easy decision."

**中文翻译:**
透镜最酷的地方在于，当你画完所有图后，如果你只是口头讨论，你得记住每个人说了什么，记住一周前的对话。但在这里，一切都一目了然。有时你退后一步看：“嘿，看，蓝色那个选项几乎在每个透镜的右上角。那是哪个？发生了什么？这可能就是一个显而易见的决定。”

---

### (00:58:49) Jake Knapp

**English:**
Sometimes you zoom out and you say, "Oh, clearly like nothing wins in every lens." And that's actually really reassuring because then you know there is no perfect decision. There's nothing that checks all of the boxes. And that's going to help us decide. Because now we decide which is the most important lens, which is the most important viewpoint to take. And you can actually move forward in either way, either situation you get in where there's sort of consistency across all the lenses or there's not. You either pick a lens or you just pick the consensus winner.

**中文翻译:**
有时你退后一步会发现：“哦，显然没有一个选项能在所有透镜中胜出。” 这其实也很让人安心，因为你知道没有完美的决定，没有能满足所有条件的方案。这会帮助我们做决定，因为现在我们要决定哪个透镜、哪个视角最重要。无论结果是所有透镜趋于一致，还是各不相同，你都可以推进：要么选定一个最重要的透镜，要么选出共识最高的赢家。

---

### (00:59:24) Lenny Rachitsky

**English:**
I love that this step answers a question that's been the back of my mind that I think a lot of people wonder is they're hearing this is just, why don't I just build something and launch it and learn? And why am I spending all this time sitting in a room? And this to me is a big part of the answer is just spending an hour or two thinking through, here's the ideas we have. How do they compare on ... how do they look on these magical lenses? Which makes so much sense. How do they just filter on what customers will love most, will help us grow the fastest, we'll drive the most money? Things like that. It's such a simple, quick exercise that will save you so much time building and launching and having to spend time learning. That is weeks, days, months of work versus a couple hours. It could save you so much over that time.

**中文翻译:**
我喜欢这一步，因为它回答了我脑子里一直存在的一个疑问，也是很多人会想的：为什么我不直接做点东西发布然后学习？为什么要花这么多时间坐在房间里？对我来说，这就是答案的核心：花一两个小时思考我们现有的想法，看看它们在这些“魔法透镜”下的表现。这非常有意义。它们在“客户最爱”、“增长最快”、“最赚钱”等维度下是如何被过滤的？这是一个简单、快速的练习，却能节省大量构建、发布和学习的时间。那是几周、几天甚至几个月的工作量，而现在只需要几个小时。

---

### (01:00:10) Jake Knapp

**English:**
And it's also the case that you start building something. It's exciting, you can move fast. It's easier and easier to see progress now with AI tools. And that act of building and starting to create something has a momentum of its own that can be hard to stop. And if you're headed in the wrong direction, you can spend a lot of time building and making progress. But it's just, if it's not progress in the right direction, it's actually hurting you.

**中文翻译:**
而且情况往往是，当你开始构建某样东西时，你会很兴奋，进展很快。现在有了 AI 工具，看到进度变得越来越容易。这种构建和创造的行为本身带有一种惯性，很难停下来。如果你方向错了，你可能花了大量时间在构建和取得“进展”上，但如果不是正确方向的进展，实际上是在伤害你自己。

---

### (01:00:41) Jake Knapp

**English:**
And that's why we want people to pause and take this. It's really, as you said earlier, the ROI is high. But it feels very unnatural to pause when you're so excited at the beginning and ready to go. To pause and say, "Okay, let's make sure we're taking the right path." But just imagine you're Gandalf, you're Frodo, you're starting off, you're trying to get to Mordor, it's a long trip. You don't want to take the wrong path. You want to take the ... think before you start marching through the swamps or whatever.

**中文翻译:**
这就是为什么我们希望人们停下来做这件事。正如你之前所说，投资回报率很高。但在刚开始非常兴奋、准备大干一场时，停下来是非常“反自然”的。停下来并说：“好，让我们确保走在正确的道路上。” 想象一下你是甘道夫或佛罗多，正准备前往魔多，旅途漫长。你不想走错路。在开始穿越沼泽之前，先思考一下。

---

### (01:01:14) John Zeratsky

**English:**
One phenomenon we've seen when teams are building things really quickly with AI is that the more AI-generated or assisted they are, the more generic they tend to turn out. Which makes sense if you think about how LLMs were developed, they're all basically pre-trained on the same data. And so in this excitement, in this rush to say, "Wow, look at how fast we can build it." You actually end up with something that is less differentiated than what already exists in the world. And then let's say you launch it, and that takes longer than building sort of a clickable prototype. But you launch it because you're moving so fast.

**中文翻译:**
我们看到的一个现象是，当团队利用 AI 快速构建产品时，AI 生成或辅助的成分越多，产品往往就越平庸。如果你思考一下大语言模型（LLM）是如何开发的，这就不难理解了——它们基本上都是在相同的数据上预训练的。所以在这种“哇，看我们做得多快”的兴奋和冲动中，你最终做出的东西可能比世界上已有的东西更缺乏差异化。然后假设你发布了它（这比做个可点击的原型要花更长时间），但因为你追求快，你还是发布了。

---

### (01:01:48) John Zeratsky

**English:**
And then you get data from the people who managed to find that thing about what they did with it. But you don't get any data about what they didn't do with it. And you certainly don't get any data about the people who never found it, who never tried it. Maybe they landed on your website and they're like, blah, another generic AI-generated thing, that's not worth my time. And so we think it's really helpful to basically put yourself in a situation where you can slow down a little bit and do some hard thinking, some deep thinking about what's actually going to make your product unique. And then you can switch into this mode of like, okay, great. Now let's go as fast as possible and get that out into customer's hands. But if you don't take this step first, it's actually kind of counterintuitive that going fast can actually slow you down in the long run.

**中文翻译:**
然后你从那些发现这个产品的人那里获得了关于“他们做了什么”的数据。但你没有获得关于“他们没做什么”的数据，更没有获得关于那些从未发现、从未尝试过它的人的数据。也许他们访问了你的网站，然后觉得：“切，又一个平庸的 AI 生成的东西，不值得我花时间。” 所以我们认为，让自己慢下来，进行一些艰苦的、深度的思考，想想究竟是什么能让你的产品独一无二，是非常有帮助的。在那之后，你再切换到“全速前进”模式，把产品交到客户手中。如果你不先走这一步，从长远来看，求快反而会拖慢你，这确实有点反直觉。

---

### (01:02:40) Lenny Rachitsky

**English:**
Yeah, to build on that, I had this guest recently, Bob Baxley. (01:02:43): Yeah, we know Bob. (01:02:45): Okay. So he has this really interesting insight. He calls it ... I think he calls it the Primal Mark. Essentially his feedback is, wait as long as possible to start any sort of sketch or prototype, because as soon as you start drawing what you're building, now everything you do will be a response to that. And so the more time you can spend before starting to concept out the solution, the more likely you are to land on something that works.

**中文翻译:**
是的，补充一点，我最近采访了 Bob Baxley。他有一个非常有趣的见解，他称之为“原始印记”（Primal Mark）。他的核心反馈是：尽可能晚地开始任何形式的草图或原型。因为一旦你开始画出你要构建的东西，你之后做的每一件事都会是对那个画面的回应。所以，在开始构思解决方案之前花的时间越多，你就越有可能找到真正有效的方案。

---

### (01:03:18) John Zeratsky

**English:**
That is super interesting and it is counterintuitive [inaudible 01:03:18]. And I find myself challenged to think about it in the context of the sprints that we run with founders. But I think one way to interpret that in the work that we do is that we used to just run design sprints with every team, that was our hammer and everything looked like a nail. And part of what we found so valuable about doing the Foundation Sprint is that it keeps you away from ideation for just a little bit longer. And it forces you to think about why you're unique and the market that you're going into before you get to that moment of creating something that looks realistic and then maybe being a little bit locked into that approach.

**中文翻译:**
这非常有趣，而且很反直觉。我试着在我们与创始人运行的冲刺背景下思考这个问题。我认为在我们所做的工作中，一种解释是：我们以前对每个团队都只运行设计冲刺，那是我们的锤子，看什么都像钉子。而我们发现基础冲刺之所以有价值，是因为它让你远离“构思解决方案”的时间又长了一点。它强迫你在创造出看起来很真实的东西并可能因此被锁定在某种路径之前，先思考你为什么独特以及你要进入的市场。

---

### (01:04:00) Lenny Rachitsky

**English:**
That's such a ... like I love that this emerged out of that. Like you guys were so design sprint oriented, and it's just like, cool, let's just make prototypes, let's design, let's make it real, let's show people. And that's, I think, where a lot of people's minds are at more and more. And maybe as a result, and this is almost like, okay, maybe that wasn't the right approach to start. Maybe it's actually better to think a little bit of what we want to design and build before. And so just the fact that you guys spent so much of your life and time on that. And then realize this is actually potentially even more important to do, it says a lot.

**中文翻译:**
我喜欢这个演变过程。你们以前那么倾向于设计冲刺——“酷，让我们做原型，让我们设计，让它变真实，展示给人们看”。我想现在越来越多的人也是这么想的。但结果发现，也许那不是开始的最佳方式。也许在设计和构建之前先思考一下更好。你们花了那么多时间和精力在设计冲刺上，最后意识到这一步可能更重要，这本身就很说明问题。

---

### (01:04:33) John Zeratsky

**English:**
And ideas always get distilled down to one thing that people grab onto and they focus on. And I think with the design sprint, it got distilled down to just build a prototype. Just quit messing around and build something. But the reality is when you run a design sprint, it's five days and you don't build the prototype until the fourth day. So you do a bunch of work to figure out how does our customer learn about this thing? What are the different ideas that we're bringing to what our solution could look like? Which of those are the most likely to work? And only then at the end of the week are you building a prototype.

**中文翻译:**
想法总是会被浓缩成人们能抓住并关注的一个点。我认为对于设计冲刺，它被浓缩成了“直接做原型”。别瞎折腾了，做点东西出来。但现实是，当你运行设计冲刺时，那是五天时间，你直到第四天才开始做原型。你做了大量工作来弄清楚：客户如何了解这个东西？我们的解决方案有哪些不同的构思？哪一个最有可能成功？只有在那之后，在周末，你才开始做原型。

---

### (01:05:14) John Zeratsky

**English:**
But I do think that as that method has become really widely known, people just think about let's build something. And then once you multiply that times the power of AI, it definitely creates this narrative that the only way to build something new is to just create the product as quickly as possible. And that doesn't really match our experience, that doesn't really fit the pattern of what we've seen working best across the few hundred companies that we've worked with.

**中文翻译:**
但我确实认为，随着这种方法变得广为人知，人们只记住了“让我们做点东西”。再加上 AI 的力量，这确实创造了一种叙事：构建新事物的唯一方法就是尽可能快地做出产品。但这并不符合我们的经验，也不符合我们在合作过的几百家公司中看到的最佳实践模式。

---

### (01:05:44) Lenny Rachitsky

**English:**
I think this validates in some ways the role of a product manager where the PM's job is to help the team figure out what should we be building and are we all aligned on what we're building before we start designing and building? This process is almost like the product requirements document of a company. Which I think a lot of product people listening to this will feel really good about.

**中文翻译:**
我认为这在某种程度上验证了产品经理（PM）的角色——PM 的工作就是帮助团队弄清楚“我们应该构建什么”，以及在开始设计和构建之前，大家是否达成了一致。这个过程几乎就像是一家公司的 PRD（产品需求文档）。我想很多听这个节目的产品人会感觉很好。

---

### (01:06:09) Jake Knapp

**English:**
Yeah, we see this as a great tool for product people. It's a way to give you a structure for leading your team through those decisions. And a way to give all the folks on a team, including the person who's the product leader. But the person who's the engineering leader, the person who's the marketing leader, sales leader, the design leaders, the exact right opportunity to contribute and participate in forming the strategy. The exact right opportunity as we get into design sprints, following the foundation sprints, to then make it real. And turn that idea, that hypothesis about what might work into hopefully evidence that it does work.

**中文翻译:**
是的，我们认为这是产品人的绝佳工具。它为你提供了一个引导团队做出决策的结构。它让团队中的所有人——包括产品负责人、工程负责人、营销负责人、销售负责人、设计负责人——都有恰当的机会参与并贡献于战略的形成。在基础冲刺之后进入设计冲刺时，这又是一个将想法付诸实践的绝佳机会，将关于“什么可能有效”的假设转化为“它确实有效”的证据。

---

### (01:06:54) Lenny Rachitsky

**English:**
I feel like it's actually more helpful to engineers, like non-product people, because I think a PM my brain would be like, I want to do this intuitively. Whether they do it right or not. I think it's other functions almost they're like, no, let's just jump straight to design, straight to prototyping.

**中文翻译:**
我觉得这其实对工程师等非产品人员更有帮助。因为作为 PM，我的大脑本能地想做这些事（无论做得对不对）。而其他职能部门往往会觉得：“不，让我们直接开始设计，直接开始做原型吧。”

---

### (01:07:11) Lenny Rachitsky

**English:**
Let me ask you ... while we're on this tangent, we're on this wild tangent out of this process, but want to ... this question has been in my mind. Because I recently had a founder on the podcast, Maor, who built this company called Base44. He built it, it sold in six months for $80 million. And this journey of that is he just had a problem he wanted to solve for himself, for his girlfriend, for a scouts program. He built it, people started using it, and he kind of evolved it from there. And obviously he didn't go through a process like this. Thoughts on just like, is it okay to just do that? When should someone think about, "Okay, I should actually set aside time to do a Foundation Sprint." Versus, I'm just motivated to solve a problem for my friends. I'm just going to build it, evolve it, iterate with them, and kind of go from there.

**中文翻译:**
趁着我们还在这个话题上（虽然有点跑题），我想问一个一直在我脑子里的问题。我最近采访了一位创始人 Maor，他创办了一家叫 Base44 的公司，六个月就以 8000 万美元的价格卖掉了。他的历程是：他只是想为自己、为女朋友、为一个童子军项目解决一个问题。他做了出来，人们开始使用，然后他不断演进。显然他没有经历过这样的流程。你们怎么看？直接那样做可以吗？什么时候一个人应该想“我应该留出时间做个基础冲刺”，而不是“我只是想为朋友解决问题，我就直接做、演进、迭代”？

---

### (01:07:58) Jake Knapp

**English:**
One of the observations from our hundreds of experiences working alongside founders in the early days of their projects and watching them make decisions and watching them try things and succeed or fail, is that there are so many founders who are incredibly bright, incredibly capable. They have great insights about the market, about an opportunity. And yet, their startup does not work out. And there's a problem with selection bias that we hear from the folks who they were brilliant, they checked all those boxes I just described. They saw a great opportunity, they were smart, they executed well, they had courage and conviction, and they did it and it worked out, and it was a tremendous success.

**中文翻译:**
在我们与数百位创始人并肩作战、观察他们决策、尝试并成功或失败的经历中，我们观察到：有很多创始人极其聪明、极其有能力，对市场和机会有深刻的洞察。然而，他们的创业公司还是没能成功。这里存在幸存者偏差（Selection bias）。我们听到的故事往往是：某人很聪明，满足了我刚才说的所有条件，看到了机会，执行力强，有勇气和信念，最后成功了。

---

### (01:08:51) Jake Knapp

**English:**
And I think that the danger in thinking like, "Well, they didn't follow a process, so I don't need to." And that may be true and maybe you don't need it. But what we believe is you have a better ... this just increases your odds. This is a chance to get more clear on, is this a good opportunity? To get more clear on, will the thing I build click with customers? And if you've already figured out that no, this thing's ... my product has taken off, my product is working. We've actually had founders in labs who they started off character labs and they said, "I started selling this thing and it's already taking off. I want to stop running experiments." And we're like, "Yeah, stop running experiments." You don't need to do this if you've got product market fit, if you've got evidence that this thing is clicking and you have conviction, run with it. But if you're not there, this is a great path to get you going. And if you're not sure if the thing you're going to build is going to turn into that $80 million exit in six months, we believe this is a good chance to improve your odds.

**中文翻译:**
我认为危险在于这种想法：“既然他们没遵循流程也成功了，那我也不需要。” 这可能是真的，也许你确实不需要。但我们相信，这能增加你的胜算。这是一个让你更清楚“这是否是个好机会”、“我构建的东西是否能赢得客户”的机会。如果你已经发现产品已经起飞了、行得通了——我们确实遇到过加入 Character Labs 的创始人说：“我已经开始卖这个东西了，它已经起飞了，我想停止实验。” 我们的回答是：“好啊，那就停止实验。” 如果你已经有了 PMF，有证据表明它行得通，并且你有信念，那就去做吧。但如果你还没到那一步，这是一个很好的起步路径。如果你不确定你做的东西是否能在六个月内卖出 8000 万美元，我们相信这是一个提高胜算的好机会。

---

### (01:09:59) Lenny Rachitsky

**English:**
People hearing this might feel like, I haven't heard of any company doing this that has become a trillion dollar IPO success. What would make me believe that this is the process I should follow versus just, I'm just going to do what I hear on YC, just build it, launch it, iterate, that kind of thing. What can you share to give people confidence this is the approach to take?

**中文翻译:**
听众可能会觉得：“我还没听说过哪家万亿市值的 IPO 公司是这么做的。为什么我要相信这是我应该遵循的流程，而不是像 YC 说的那样——直接构建、发布、迭代？” 你能分享些什么来给人们信心，让他们相信这是值得采取的方法？

---

### (01:10:20) John Zeratsky

**English:**
Well, the first thing I'd say is give us some time where we're pretty new to this. We started Character Labs about three years ago. We created the Foundation Sprint about three years ago. But more seriously, when we were creating this method, one of the things that we did was look back across all the projects we've been involved in and the ones that were really successful, and we looked for patterns. And while those teams didn't have the Foundation Sprint, they ended up having really clear differentiation and a really clear view of what made them unique that they were able to build on. And as we ran design sprints with them, we were able to test and validate against that differentiation. So we believe that this is sort of a key to success, even if those teams didn't have access to this exact same methodology.

**中文翻译:**
首先我想说，给我们一点时间，毕竟我们做这个才不久。我们大约三年前创办了 Character Labs，三年前创造了基础冲刺。但严肃地说，当我们创建这个方法时，我们回顾了所有参与过的项目，特别是那些非常成功的项目，并寻找其中的模式。虽然那些团队当时没有“基础冲刺”，但他们最终都拥有了非常清晰的差异化，以及对自己独特之处的清晰认识，并以此为基础进行构建。当我们与他们运行设计冲刺时，我们能够针对那种差异化进行测试和验证。所以我们相信这是成功的关键，即使那些团队当时没有使用这套完全相同的方法论。

---

### (01:11:07) Lenny Rachitsky

**English:**
So what I'm hearing is this is essentially like Alpha in starting a company. This is a new process that companies are just starting to use. You guys are working closely with founders, and it's rooted in the success of many, many, many companies that you guys were involved in early on and continue to be involved in.

**中文翻译:**
所以我听明白的是，这本质上就像是创业的“Alpha 版”。这是一个公司刚开始使用的新流程。你们与创始人密切合作，而它根植于你们早期参与并持续关注的许许多多成功公司的经验。

---

### (01:11:25) Jake Knapp

**English:**
Yeah, it's based off of this thing we've seen again and again in the most successful projects. When we're inside the room in the early days and we're seeing people make decisions, this is what drives those decisions. It's differentiation. And so if we look back across all of the sprints that we've been a part of over the years, and John and I have been inside lots of these rooms, lots of these conversations.

**中文翻译:**
是的，它基于我们在最成功的项目中反复看到的现象。当我们在早期阶段身处决策现场时，驱动这些决策的核心就是“差异化”。如果我们回顾这些年来参与过的所有冲刺——我和 John 进过很多这样的房间，参与过很多这样的对话。

---

### (01:11:51) Jake Knapp

**English:**
(Visual description: Jake showing a slide with many white circles representing companies). It spans across Google, Google Ventures, Character Capital, and if you're watching on YouTube, you'll see all these little white circles. And each one sort of represents a company that we've seen inside of during these design sprints. And there are a lot of really great success stories in there. We've had the chance to ... I mentioned the story of Google Meet and being there and figuring out what is it that's going to make this thing stand out? That was what made the project finally start to take off. And to this day is still sort of what animates it. Being inside of the early days of what became Google Photos or Google Trips and some of the early design sprints, and there are a lot of others on here.

**中文翻译:**
（视觉描述：Jake 展示了一张幻灯片，上面有很多代表公司的白色圆圈）。这涵盖了 Google、Google Ventures、Character Capital。如果你在 YouTube 上看，你会看到这些小圆圈，每一个都代表我们在设计冲刺期间深入了解过的公司。其中有很多伟大的成功案例。我们有机会参与了……我提到的 Google Meet 的故事，当时就在想：是什么能让这个东西脱颖而出？正是这一点让项目最终起飞，并延续至今。还有 Google Photos、Google Trips 的早期阶段，以及这里的许多其他公司。

---

### (01:12:35) Jake Knapp

**English:**
But honestly, of course, we've also seen inside a lot that it didn't work out. If we looked inside the greatest hits though, the real smash successes, we looked inside all of those. We realized there is a common element, and that common element in all of them is differentiation. That there was clarity around this is what we're trying to prove to customers, this is the promise we're making. And so we've been on those teams, or we've worked alongside those founders who have this clear idea of differentiation. And sometimes they're not right. They run the experiments and they change it. But the thing is, they're keyed into differentiation as being crucial. They're not just thinking about the product and trying to get the right shape of the product or trying to make it usable or whatever. They're really keyed in on differentiation and how do we find the right promise and deliver on that promise and express that promise to customers.

**中文翻译:**
但老实说，我们也见过很多没成功的。如果我们审视那些最成功的案例，会发现一个共同元素，那就是“差异化”。他们非常清楚自己想向客户证明什么，清楚自己做出的承诺是什么。我们曾身处这些团队，或与这些有清晰差异化想法的创始人并肩作战。有时他们并不完全正确，他们运行实验并进行调整。但关键是，他们敏锐地意识到差异化至关重要。他们不只是在想产品长什么样、好不好用，而是专注于差异化：我们如何找到正确的承诺，如何兑现它，以及如何向客户传达它。

---

### (01:13:28) Jake Knapp

**English:**
So to explain a little bit quickly of what I mean by differentiation and how this has manifested in products we've seen, if you go back to the early days of Gmail in the 2000s, if you had email, you were probably using Hotmail or Yahoo and it worked fine and you didn't have to think about it. And this new product comes along and you're like, "God, I'm not going to want to switch my email address. What a hassle. Who wants to do that? No one." Gmail's promise was, hey, massive storage, great search. And as we were building the product out and marketing and explaining it to people and making decisions inside the project, we had to continue to deliver on great search. Great search, great search, that was key to standing out.

**中文翻译:**
为了快速解释我所说的差异化以及它在产品中是如何体现的：回想 2000 年代 Gmail 的早期。如果你有邮箱，你可能在用 Hotmail 或 Yahoo，它们用得好好的。当一个新产品出现时，你会想：“天哪，我不想换邮箱地址，太麻烦了，没人想这么做。” Gmail 的承诺是：海量存储，强大的搜索。当我们构建产品、进行营销和内部决策时，我们必须不断兑现“强大的搜索”这一承诺。搜索、搜索、搜索，这就是脱颖而出的关键。

---

### (01:14:10) Jake Knapp

**English:**
You fast forward to 2014, and we're working with this tiny company who's now competing with Gmail, who's now sort of the market leader people are used to using in their teams. And here's this new messaging software called Slack, and they're trying to reach new customers. And gosh, switching to Slack is an even bigger hassle than switching to your email address because everybody on the team has to switch. Well, Slack says, "Hey, if you believe that having fun and boosting teamwork is important, it's going to be clear to you. This is a new way of looking at the world." And when they were making their decisions in their first big ad campaign, their first big marketing campaign, this was what they were trying to convey to customers. So we kind of see that from the inside.

**中文翻译:**
快进到 2014 年，我们与一家当时还很小的公司合作，它现在正与 Gmail 竞争，成为了团队沟通的市场领导者。这就是 Slack。当时他们试图触达新客户。天哪，换成 Slack 比换邮箱地址更麻烦，因为团队里的每个人都得换。Slack 说：“嘿，如果你相信‘有趣’和‘提升团队协作’很重要，你就会明白，这是一种看待世界的新方式。” 当他们在做第一个大型广告和营销活动决策时，这就是他们试图向客户传达的信息。我们从内部看到了这一点。

---

### (01:15:08) Jake Knapp

**English:**
Another one, we didn't see this one from the inside, but in one that we're all sort of familiar with is what happened with ChatGPT. It goes from this trusted, I don't have to think about it, I'm going to run a Google search. To, oh, wow. It's a new way of looking at the world. There's zero clicks, just tells you the answer. This thing's great. This is also something that we've seen in some of the early success stories from our own portfolio. So 2019, this company called Reclaim going after calendar management. And most of us manage our own calendars, most of us don't have administrators helping us out with that. And it's free, we're in control. Reclaim's argument was, hey, we can automatically, we can use AI to help you focus and to automatically prioritize your calendar. And that animated enough people to take the plunge and switch and try it out, that they were able to build up an audience of tens of thousands of users, and Dropbox acquired them last year.

**中文翻译:**
另一个例子（虽然我们没从内部参与，但大家都熟悉）是 ChatGPT。它让人们从习惯性的“去 Google 搜一下”变成了“哇，这是一种新方式，零点击，直接给答案”。这太棒了。在我们的投资组合中也有类似的早期成功案例。2019 年，一家叫 Reclaim 的公司致力于日历管理。我们大多数人都是自己管日历，没有助理。Reclaim 的论点是：我们可以利用 AI 自动帮你专注，自动排列日历优先级。这吸引了足够多的人尝试并切换，他们建立了几万人的用户群，去年被 Dropbox 收购了。

---

### (01:15:46) Lenny Rachitsky

**English:**
A great answer to my question, you guys well-prepared for those skeptics.

**中文翻译:**
对我那个问题的回答非常精彩，看来你们对怀疑论者早有准备。

---

### (01:15:52) John Zeratsky

**English:**
Part of our motivation, our selfish motivation with this Foundation Sprint is that now that we are investing our own money into companies and we're working with all these founders, we want them to have that same clarity on differentiation. We saw how important that was to Gmail and to Slack and to all these other companies. And we want to bring that, we want to give them that same advantage and help them avoid the pitfalls that all the other unsuccessful teams and companies that we've seen have fallen into. So that's kind what we're trying to do here, is bring the lessons from these really successful teams into any team that reads the book and runs this process.

**中文翻译:**
我们做基础冲刺的部分动力（甚至是私心）在于：既然我们现在把自己的钱投进公司，并与这些创始人合作，我们就希望他们对差异化有同样的清晰认识。我们看到了差异化对 Gmail、Slack 等公司的重要性。我们想把这种优势带给他们，帮助他们避开我们见过的那些失败团队和公司踩过的坑。这就是我们想做的：把这些成功团队的经验带给每一个阅读这本书并运行这个流程的团队。

---

### (01:16:33) Jake Knapp

**English:**
And the special sauce that John and I bring is that we're obsessed with the sequence of decisions that you make and how you work together with your team to make good decisions quickly. And that specificity about the method is something that we do have a lot of evidence behind it working well because of what's happened with the design sprint and with how many successful teams have run that at those companies who are trillion dollar or whatever kind of giant ... all kinds of teams run design sprints. This is that same methodology around how we work together at high velocity and high quality. And it's just brought to a different part of the process.

**中文翻译:**
我和 John 带来的“秘方”是我们对“决策序列”以及“如何与团队合作快速做出好决策”的痴迷。这种方法的具体性已经被大量证据证明是有效的，看看设计冲刺的普及程度就知道了——那么多万亿市值的巨头公司都在运行设计冲刺。这是关于“如何高速、高质量协作”的同一套方法论，只是被应用到了流程的不同阶段。

---

### (01:17:14) Lenny Rachitsky

**English:**
Excellent answer. Speaking of the method, we went on the world's most epic tangent. I want to bring us back. We haven't finished actually going through the process. I think we're towards the tail end of it. So let's just finish that. What else do you do? So you have this ... I guess, catch us up.

**中文翻译:**
精彩的回答。说到方法，我们刚才跑题跑得太远了，现在拉回来。我们还没讲完整个流程，我想应该快到尾声了。让我们把它讲完。接下来要做什么？

---

### (01:17:30) Jake Knapp

**English:**
Let's catch up with Latch It. So as a refresher for you who forgot. Latch It are building this tool for artisans, they want to help them sell with the community networking features like you might find on Substack. And they've identified their differentiation, they've identified their approach now using magic lenses. And all of this is going to come together to create a founding hypothesis. So if we help Artisans solve online sales growth with a social sales app, and then they've also got their backup plan.

**中文翻译:**
回到 Latchet 的例子。帮大家复习一下：Latchet 为手工艺者构建工具，想通过类似 Substack 的社区网络功能帮助他们销售。他们已经确定了差异化，并利用“魔法透镜”确定了路径。所有这些将汇聚成一个“创始假设”：如果我们通过一个“社交销售 App”帮助“手工艺者”解决“在线销售增长”问题……同时他们也有备份计划。

---

### (01:18:03) Jake Knapp

**English:**
...or we could build the full stack solution if that doesn't work. We believe they're going to choose it over Shopify and Etsy because our solution is cooperative and easy to use. In this single sentence, we've laid bare their strategy, and now they're going to try to find out does that work?

**中文翻译:**
……或者如果那个行不通，我们可以构建全栈解决方案。我们相信他们会选择我们而不是 Shopify 和 Etsy，因为我们的解决方案是“协作性的”且“易用的”。就在这一句话里，我们清晰地展示了他们的战略。现在，他们要去弄清楚这是否奏效。

---

### (01:18:21) Lenny Rachitsky

**English:**
That is so cool. The output of the sprint is the founding hypothesis. I love that the term hypothesis is a part of this because it's not telling you this will work. It's this is the thing you will now test.

**中文翻译:**
太酷了。冲刺的产出就是“创始假设”。我喜欢“假设”这个词，因为它不是在告诉你“这一定行”，而是告诉你“这是你现在要测试的东西”。

---

### (01:18:34) Jake Knapp

**English:**
Absolutely. Every project has at its core ... Every new product has at its core a hypothesis. There is a founding hypothesis. It's just usually not explicit. It's usually hidden, and different people on the team may have different ideas about what it is. Because it's not explicit, it's very hard to interrogate it and test it and find out if the different variables in it are the right variables.

**中文翻译:**
绝对正确。每个新产品的核心都有一个假设，一个创始假设。只是通常它不是显性的，而是隐藏起来的，团队里不同的人可能对它有不同的理解。正因为它不显性，所以很难去审视它、测试它，也很难发现其中的变量是否正确。

---

### (01:19:00) Lenny Rachitsky

**English:**
I'm curious what's in that photo to the right as you're showing the YouTube.

**中文翻译:**
我很好奇你在 YouTube 上展示的右边那张照片里是什么。

---

### (01:19:02) Jake Knapp

**English:**
Oh, yeah, if you're on YouTube. We did this spread together in person. On Lachit's board, you're going to see that here's where they wrote it out and took a photo of it and dropped it in, and then later filled it out on the Miro board.

**中文翻译:**
哦，如果你在看 YouTube。这是我们线下一起做的。在 Latchet 的板子上，你可以看到他们手写出来的草稿，拍了照放进去，后来才填到 Miro 板上。

---

### (01:19:18) Lenny Rachitsky

**English:**
Beautiful. It has their old name there.

**中文翻译:**
漂亮，上面还有他们的旧名字。

---

### (01:19:20) Jake Knapp

**English:**
That's right. Lyric, which it turns out is not the easiest for SEO. There's a lot of lot of Lyrics out there.

**中文翻译:**
没错，Lyric。后来发现这个名字对 SEO 不太友好，叫 Lyric 的东西太多了。

---

### (01:19:27) Lenny Rachitsky

**English:**
There is a lot of Lyrics. I know some Lyrics. Just so I understand, is the next step, the design sprint, and that's where you actually start testing?

**中文翻译:**
确实很多。据我所知，下一步就是设计冲刺，也就是真正开始测试的阶段？

---

### (01:19:34) Jake Knapp

**English:**
Exactly. If we zoom out now we see now they're going to head into a sequence of design sprints running one after another. Each of those design sprints starts with the founding hypothesis. Then, the team is going to say, "Okay, what are the biggest risks that ... That hypothesis not being true? What do we need to assess right now?"

**中文翻译:**
没错。如果我们退后一步看，他们现在要进入一系列连续的设计冲刺。每个设计冲刺都以创始假设为起点。然后团队会问：“好，如果这个假设不成立，最大的风险是什么？我们现在需要评估什么？”

---

### (01:19:52) Jake Knapp

**English:**
Going to make a map of how customers discover the product, what that core experience looks like, and then figure out using that map, where's the key moment for assessing that risk? For them, the biggest risk is do people even ... Will these artisans even want this thing? Are they actually going to want to have a community sharing sales platform? They decide the key moment for us to test that, it's actually on the landing page. They figure we can prototype landing pages that describe the product and learn a lot for our first experiment, just with landing pages.

**中文翻译:**
接着画一张地图，展示客户如何发现产品、核心体验是什么样的，然后利用地图找出评估该风险的关键时刻。对他们来说，最大的风险是：手工艺者真的想要这个东西吗？他们真的想要一个社区共享销售平台吗？他们决定测试的关键时刻其实是在“落地页”（Landing page）。他们认为可以通过原型化描述产品的落地页，在第一次实验中就学到很多东西。

---

### (01:20:23) Jake Knapp

**English:**
They're going to sketch solutions. This will be familiar to anyone who's heard about design sprints. Each person sketching their own proposal for how that key moment should work. Choose the strongest of those. In this case, they choose ... They're going to actually prototype three things. They test three things head-to-head against each other, fake brands for each one. They look like three different products.

**中文翻译:**
他们会画出解决方案的草图。听过设计冲刺的人对此应该很熟悉。每个人画出自己对于“关键时刻如何运作”的提案。选出最强的一个。在这个例子中，他们实际上原型化了三个东西。他们让这三个东西进行正面交锋测试，每个都用虚构的品牌，看起来像三个不同的产品。

---

### (01:20:46) Jake Knapp

**English:**
Then, this is a really key part. At the end of the design sprint, we've got a scorecard. This is actually a new innovation. This is not in the [original book]. (01:20:53): Oh, shit. Here we go. Hot off the presses, design sprint improvement. (01:20:59): This scorecard is going to break down the founding hypothesis. Hey, as we talk to each customer, was this the right person? Is the right kind of customer for us? Do they have the problem that we think they have? Was this the right approach for them? Did they choose it over the competition?

**中文翻译:**
然后，这是一个非常关键的部分。在设计冲刺结束时，我们有一个“计分卡”。这实际上是一个新创新，原版书里没有。（Lenny：哇，重磅消息，设计冲刺的改进版来了！）这个计分卡会分解创始假设。当我们与每个客户交谈时：这是对的人吗？是对的客户类型吗？他们有我们认为的那个问题吗？这对他们来说是正确的路径吗？他们会选择我们而不是竞争对手吗？

---

### (01:21:14) Jake Knapp

**English:**
They're going to test these prototypes head-to-head, and also show people like, okay, here's Etsy, here's Shopify. Now, out of all these five options, think about, out loud, about how do you compare these? Do we believe they'd actually choose it? Did the differentiation actually work? Are those differentiators valuable and motivating to them? Does it click? Our new book is called Click. The idea there is you can see when a product clicks with one person, and that's a helpful signal. Now, granted, these interviews are kind of a simulation. It's not like the real world, but they're a helpful signal that we're on track for product market fit. If we see, gosh, this product just seems to be clicking with customer after customer, that's a really strong signal. That's when people start to get the confidence that it's time to build.

**中文翻译:**
他们会进行原型的正面交锋测试，还会向人们展示：好，这是 Etsy，这是 Shopify。现在，在这五个选项中，请大声说出你如何比较它们。我们相信他们真的会选择它吗？差异化真的起作用了吗？这些差异化点对他们有价值、有吸引力吗？它产生共鸣（Click）了吗？我们的新书叫《Click》，核心理念就是：当你看到产品与一个人产生共鸣时，那就是一个有用的信号。诚然，这些访谈是一种模拟，不是真实世界，但它们是判断我们是否走在 PMF 正轨上的有用信号。如果我们看到这个产品接连不断地与客户产生共鸣，那就是一个非常强烈的信号。这时人们才会获得信心：是时候开始构建了。

---

### (01:22:03) Lenny Rachitsky

**English:**
That's a really good term, by the way. I feel that's such a good way to describe what it feels like. It doesn't just click with them.

**中文翻译:**
顺便说一下，这个词用得真好。我觉得这是描述那种感觉的极佳方式。它不仅仅是“点击”，而是“产生共鸣”。

---

### (01:22:08) Jake Knapp

**English:**
Just kind of clicks. Yeah. If you look across Latchet's first scorecard, there's a ton of red. It's a lot of things that didn't work. (01:22:18): The conclusion at the end ... In this last column, there's a conclusion, hey, we interviewed ... In this case, they interviewed four customers. Well, it looks like this is the right customer. It looks like they have this problem, but everything else kind of didn't work about the hypothesis. Approach wasn't working, differentiation wasn't working. There's some mini hypotheses about the prototype itself. Just lots of red on here, so they sprint again and-

**中文翻译:**
就是那种共鸣感。如果你看 Latchet 的第一张计分卡，上面有一大片红色，很多东西都没奏效。最后一列的结论是：我们访谈了四位客户，看起来客户是对的，问题也是对的，但假设的其他部分都不行。路径不对，差异化也不起作用。还有一些关于原型本身的微型假设也失败了。满屏都是红的，所以他们再次进行冲刺……

---

### (01:22:42) John Zeratsky

**English:**
Just zooming out for a second, this is a team who just started working on this new company. Sometimes it can feel slow. We talked about it feeling slow to go through all these steps, but they're only a week in. They've already built three prototypes, and they've tested those three prototypes with four real customers. They have this super detailed scorecard of here's what's working, here's what's not working. That's after a week. It's interesting how what can feel slow in the hour to hour actually can really speed you up in the weeks and months timescale.

**中文翻译:**
退后一步看，这是一个刚开始做新公司的团队。有时过程感觉很慢，我们讨论过走完这些步骤感觉很慢，但其实他们才做了一周。他们已经构建了三个原型，并向四个真实客户测试了这些原型。他们拥有一份极其详细的计分卡，明确了什么是有效的，什么是无效的。这仅仅是一周后的成果。有趣的是，那些在小时维度上感觉很慢的事情，实际上在周和月的维度上极大地加速了你的进程。

---

### (01:23:17) Lenny Rachitsky

**English:**
That was such good context, because I was feeling that. To your point, most founders do not do this much testing, iterating, learning in the first few weeks of their startup.

**中文翻译:**
这个背景太好了，我也有同感。正如你所说，大多数创始人在创业的前几周都不会做这么多的测试、迭代和学习。

---

### (01:23:26) John Zeratsky

**English:**
Yeah. They might spend a few weeks just talking to customers without showing a prototype, and then they might spend a few months building an MVP, and then they might ... Maybe they're going to spend some more time talking to customers while showing them the MVP. Maybe they'll do manual onboarding, something like that. Yeah, that plays out over months. It fits with what founders tell us. Of course it's a subjective measure, but founders who go through this process with us, they say that they're able to accelerate three to four months of work into the three or four weeks back-to-back sprints that we're doing together in Character Labs.

**中文翻译:**
是的。他们可能会花几周时间只找客户聊天而不展示原型，然后花几个月构建 MVP，然后再花时间展示 MVP 并找客户聊，也许还会做手动入驻（Manual onboarding）之类的。这通常要耗时数月。这与创始人们告诉我们的一致。虽然是主观衡量，但与我们一起走过这个流程的创始人都说，他们能把三四个月的工作量压缩到我们在 Character Labs 一起做的三四周连续冲刺中。

---

### (01:23:59) Lenny Rachitsky

**English:**
Excellent context. Thanks for throwing that in there.

**中文翻译:**
非常棒的背景补充，谢谢。

---

### (01:24:01) Jake Knapp

**English:**
These conversations with customers are so much more fruitful and pointed when you've got the context of I know exactly what my hypothesis is and you have prototypes to show them. We have a founder in our group of startups and Character Labs at the moment. I'm thinking of Maruthi John who comes from doing sales at Rippling, who had been talking to tons of customers while starting off the ... His company. He said, "I've had 50 conversations over the past month, but I learned so much more from even the first conversation when I had a hypothesis and I had a prototype, or a couple prototypes, to show them. It's like night and day."

**中文翻译:**
当你清楚地知道自己的假设是什么，并且有原型展示给客户看时，与客户的对话会变得更有成效、更有针对性。我们现在的 Character Labs 里有一位创始人，Maruthi John，他以前在 Rippling 做销售。在创业初期，他已经和大量客户聊过了。他说：“过去一个月我做了 50 次访谈，但当我带着假设和一两个原型去谈时，哪怕是第一次谈话学到的东西也比以前多得多。这简直是天壤之别。”

---

### (01:24:42) Lenny Rachitsky

**English:**
That is a great example. This all makes sense. As you guys describe it, you're actually testing something very concrete that your entire team is aligned behind and actual prototypes, and you've thought about different directions. You're testing something very specific versus just generally testing at your general concept.

**中文翻译:**
这是一个很好的例子。这完全说得通。正如你们所描述的，你们实际上是在测试全团队达成共识的非常具体的东西，使用真实的原型，并且考虑了不同的方向。你们在测试非常具体的东西，而不是泛泛地测试一个大概念。

---

### (01:25:03) Jake Knapp

**English:**
As we go into the second design sprint for Latchet, they're making some edits to their founding hypothesis. Now, they're revising a few things, making new sketches, new proposals for what this solution might look like. They've learned a lot in that first sprint, a new prototype. They've got a prototype that has more detail now. They are engineers. They're starting to actually write some code and put some more detail behind the product. It's more robust. Again, they're trying to fix that positioning.

**中文翻译:**
进入 Latchet 的第二次设计冲刺时，他们对创始假设进行了一些修改。他们修正了几件事，画了新的草图，对解决方案的样子提出了新提案。他们在第一次冲刺中学到了很多。新的原型细节更丰富了。他们是工程师，开始实际写一些代码，为产品增加更多细节，使其更稳健。同样，他们也在尝试修正定位。

---

### (01:25:36) Jake Knapp

**English:**
Here's their scorecard. If you're watching on YouTube, you'll be able to see it. Again, there's a lot of red here. At first blush, the scorecard is bleeding, but there are some promising signs. There's like maybe a few little sunbreaks, there's some spots where some of the red has started to flip to yellow. If we look at the conclusion on the far right, they're starting to believe their differentiation is dialed in, and they're starting to believe that this could be the right approach. They may be able to get people to choose it to the competition, even though they haven't done it yet. Those are starting to become yellow lights on the scorecard.

**中文翻译:**
这是他们的计分卡。看 YouTube 的朋友能看到，上面还是有很多红色。乍一看计分卡还在“流血”，但已经有了一些希望的迹象。就像云层中透出的阳光，有些红色开始变成黄色了。看最右边的结论：他们开始相信差异化已经找准了，也开始相信这可能是正确的路径。即使还没完全做到，他们也觉得有可能让人们选择他们而不是竞争对手。计分卡上开始出现黄灯了。

---

### (01:26:12) Jake Knapp

**English:**
Now they'll take what they've learned, and now we're into the third consecutive week of design sprints. Again, they're going to sort of review that founding hypothesis. They're going to sketch. They're recruiting a new slate of customers, as they do each week. A new prototype, again, more code in the prototype. It's becoming more and more robust, more realistic as they're also adjusting the marketing and the positioning at the same time. All of these things kind of go in concert. The product itself and the marketing are sort of one as they're moving along, and this is an extreme example of-

**中文翻译:**
现在他们带着所学进入连续第三周的设计冲刺。同样，他们审视创始假设，画草图，每周招募一批新客户。新原型里加入了更多代码，变得越来越稳健、真实，同时他们也在调整营销和定位。所有这些都是同步进行的。随着进程推进，产品本身和营销几乎合二为一。这是一个极端的例子——

---

### (01:26:46) Lenny Rachitsky

**English:**
What? Everything is green.

**中文翻译:**
什么？全绿了！

---

### (01:26:49) Jake Knapp

**English:**
Everything's green. If you can't see it, every single one is green. This is extreme, but it is a pattern that we've seen again and again. This is a real example.

**中文翻译:**
全绿了。看不见的朋友们，每一项都是绿色的。这虽然极端，但确实是我们反复看到的模式。这是一个真实的例子。

---

### (01:26:58) Lenny Rachitsky

**English:**
Wow. How do I invest to get us in this round? This is great. Nice job.

**中文翻译:**
哇。我怎么才能投进这一轮？太棒了，干得漂亮。

---

### (01:27:03) Jake Knapp

**English:**
Yes, this is pretty great. We see this again and again. I can share a couple of other boards of ones that are in progress. We're also constantly adjusting the template so you can get to see a little bit more how people will edit their founding hypothesis from sprint to sprint. Mellow, who we were talking about, here's their first prototype, and here's their first scorecard. Lots of yellow for them. Maybe they're a little bit more likely to use yellow than red.

**中文翻译:**
是的，这非常棒。我们反复看到这种情况。我可以分享其他几个正在进行的板子。我们也在不断调整模板，这样你可以看到人们如何在不同冲刺之间修改创始假设。刚才提到的 Mellow，这是他们的第一个原型和第一张计分卡。他们有很多黄色，也许他们更倾向于用黄色而不是红色。

---

### (01:27:31) Jake Knapp

**English:**
Then, here's the edits to their founding hypothesis after the first sprint. You can kind of see in red, they're slightly changing the definition of their target customer from the first week, slightly changing the problem that they're solving, slightly changing the approach, slightly changing the competition. They've dialed in, they've gotten more crisp on who are we up against. They've gotten a little bit more crisp, just a tiny tweak, on what ... How do we explain this to people to get them excited about it? What's the differentiation? They sprint again, they prototype again. If we just jump down, and just looking at hypotheses, they learn a bunch. Now there's another slight tweak to that founding hypothesis. Week after week you're learning, but you're also really able to track exactly what is it that we learned and how does that affect our strategy.

**中文翻译:**
这是他们在第一次冲刺后对创始假设的修改。你可以看到红字部分：他们稍微改变了目标客户的定义，稍微改变了要解决的问题，稍微改变了路径，稍微改变了竞争对手。他们找准了方向，对竞争对手的认识更清晰了。在“如何向人们解释并让他们兴奋”以及“差异化是什么”方面，也做了微调。他们再次冲刺，再次做原型。看这些假设，他们学到了很多。现在创始假设又有了微调。周复一周，你在学习，同时你也能准确追踪学到了什么，以及这如何影响你的战略。

---

### (01:28:20) Lenny Rachitsky

**English:**
Okay, guys, this was incredible. I think we've covered the entire process. I love that you also covered the design sprint pieces, which isn't part of this book, but is such a core. Clearly these things are very connected and meant to work together. You go from here's the thing we should be building to how to actually test it. Let me ask you before we wrap up, is there anything else that you think is really important for people to know before they start trying this process at home? Is there anything you can point them to actually try this at home?

**中文翻译:**
太棒了，伙计们，这太不可思议了。我想我们已经涵盖了整个流程。我很高兴你们也涵盖了设计冲刺的部分，虽然那不是这本书的内容，但它是核心。显然这些东西是紧密相连、相辅相成的。你从“我们应该构建什么”过渡到“如何实际测试它”。在结束前我想问，在人们开始在家尝试这个流程之前，还有什么你们认为非常重要的事吗？有什么可以指引他们实际操作的吗？

---

### (01:28:51) Jake Knapp

**English:**
One thing we didn't talk about, we used an example of a company who's not building an AI-first product. Latchet's building this network community sales platform for artisans. It'd probably be interesting to look at how people use this when they are building a very technical product, when they're vibe coding prototypes. That's a question we're getting all the time. What's the influence on this of the speed with which you can build something?

**中文翻译:**
有一件事我们没谈到。我们用的例子（Latchet）不是 AI 原生产品，它是为手工艺者做的网络社区销售平台。看看人们在构建高度技术化的产品、在“凭感觉编程”（Vibe coding）原型时如何使用这个流程，可能会很有趣。这是我们经常被问到的问题：构建速度的提升对这个流程有什么影响？

---

### (01:29:19) Lenny Rachitsky

**English:**
That's an awesome idea. Let's definitely do that.

**中文翻译:**
好主意，我们一定要聊聊这个。

---

### (01:29:20) Jake Knapp

**English:**
Yeah. Okay. Let's jump in here and take a look at a company again, in our current group of labs teams, Axion Orbital it's called. The founder, [inaudible 01:29:30], is actually running this whole process solo, which is pretty cool too. He's a remarkable guy. We have a couple of solo founders right now who are able to generate ... You can see, just to give a sneak peek, he's generating, when we talk about customers, all these sticky notes himself and making the decisions himself about which is the right one.

**中文翻译:**
好。让我们看看目前 Labs 团队里的另一家公司，叫 Axion Orbital。创始人正在独自运行整个流程，这也很酷。他是个了不起的人。我们现在有几位个人创始人，他们能产出……你看，剧透一下，在讨论客户时，他自己写了所有这些便利贴，并自己决定哪一个是正确的。

---

### (01:29:48) Jake Knapp

**English:**
To ground us in this story, his founding hypothesis is he wants to help geospatial devs solve these sort of complex workflows with a browser-based no-code development environment. We'll take a look just really quickly at what his prototypes look like. In the first week ... I can show you this prototype right here, and it's a marketing page. On this marketing page, there's a link to a video. If I click find out more, I'm going to see this video. This video is going to kind of hear [him] talking over it. It's going to kind of walk through a screen share of a very rudimentary version of what this product might look like.

**中文翻译:**
这个故事的背景是：他的创始假设是想帮助“地理空间开发者”通过“基于浏览器的无代码开发环境”解决“复杂的流程”问题。我们快速看一下他的原型长什么样。第一周……看这个原型，它是一个营销页面。页面上有一个视频链接。如果点击“了解更多”，就会看到这个视频。视频里有他的旁白，演示了一个非常初级的产品原型。

---

### (01:30:36) Jake Knapp

**English:**
Now, if you're watching on YouTube and you see this prototype, you might think, "Boy, that marketing page and the demo itself, pretty bare bones. Not the most polished-looking. This doesn't look super compelling." He was focusing in that first sprint on the messaging, on finding those people who actually have that role, testing it with them, and he learned a lot. If we sort of go back to his scorecard, we'll see, okay, that was a pretty good one. Actually, a lot of green on his first scorecard, but he also felt like what he tested was pretty incomplete.

**中文翻译:**
如果你在 YouTube 上看到这个原型，你可能会想：“天哪，那个营销页面和演示本身太简陋了，一点都不精致，看起来没什么吸引力。” 但他在第一次冲刺中专注于“信息传递”，专注于找到真正担任那个角色的人并进行测试。他学到了很多。看他的计分卡，其实第一张就有不少绿色，但他觉得测试的内容还很不完整。

---

### (01:31:10) Jake Knapp

**English:**
Now, one thing that's cool here, we saw the big leap with Latchet from one week to another in terms of their learnings and the scorecards. One of the things that's interesting here is to go from [his] first prototype here to his second prototype. It's obvious he's been able to just build a ton in the next week. He's using AI-based tools. He's doing a lot of work. He's also just a terrific engineer. Here we've got a much more real-looking marketing page, very detailed.

**中文翻译:**
这里很酷的一点是，我们之前看到 Latchet 在两周之间学习成果和计分卡有了巨大飞跃。而这里有趣的是从第一个原型到第二个原型的进化。显然他在接下来的一周里构建了大量东西。他使用了 AI 工具，做了大量工作，他本身也是个天才工程师。现在我们看到了一个真实得多的营销页面，非常详细。

---

### (01:31:38) Jake Knapp

**English:**
An important thing that he's done here with this is he's built out a lot and created a video of something so that the product, while not fully functional, you can see exactly how it works. If we sort of play this video, he's created this demonstration of what it looks like when you type in a query into the engine and exactly the kinds of results you get. By doing a combination of vibe coding, real coding, all of which is based off of pencil sketches, we can go back and see the sketches he's doing on paper to define this is what I think needs to be in there to make this compelling to deliver on my differentiation, and then he's using a product video so that the entire thing doesn't have to work fully freeform. That's what it can look like when a team is building something that's more AI-centric, when it's a more sophisticated tool, when people are going to be curious about sort of the ins and outs of it.

**中文翻译:**
他做的一件重要事情是：他构建了很多东西并制作了一个视频，这样虽然产品还没完全跑通，但你能看清它是如何工作的。播放这个视频，他演示了在引擎中输入查询后会得到什么样的结果。通过结合“凭感觉编程”和真实编程，而这一切都基于铅笔草图（我们可以看到他在纸上画的草图，定义了为了实现差异化需要包含哪些功能），然后他利用产品视频，这样就不需要整个产品完全自由运行。这就是当团队构建以 AI 为中心、更复杂的工具时，原型可能的样子。

---

### (01:32:33) Lenny Rachitsky

**English:**
Along those lines, where do you find people are leveraging AI most in helping them through these sprints, through either the foundation sprint or the design sprint? Is it mostly just vibe coding prototypes?

**中文翻译:**
顺着这个话题，你发现人们在这些冲刺（无论是基础冲刺还是设计冲刺）中，最常在哪些环节利用 AI？主要是“凭感觉编程”做原型吗？

---

### (01:32:45) John Zeratsky

**English:**
That's definitely the first and biggest use of AI in sprints so far is in making prototypes that look more realistic faster. It's kind like having an entire prototyping team on standby so that you don't have to just make it yourself and sort of piece things together, but you can have a ton of people ready to jump in, make something look really realistic. It's also really critical we found that while you're outsourcing that prototyping work, you don't outsource the thinking. You don't kind of skip over the part where you think about, "Well, what is the actual copy on the website? How do I actually describe what the product is, how it's differentiated?"

**中文翻译:**
到目前为止，AI 在冲刺中首要且最大的用途绝对是“更快地制作更真实的原型”。这就像有一整支原型团队随时待命，你不需要自己一点点拼凑，而是有一群人随时准备冲进来让东西看起来非常真实。但我们也发现至关重要的一点：当你把原型工作“外包”给 AI 时，千万不要把“思考”也外包了。你不能跳过思考环节，比如：“网站上的文案到底该怎么写？我该如何描述产品及其差异化？”

---

### (01:33:48) John Zeratsky

**English:**
It's one of the reasons why doing the foundation sprint first and then doing a design sprint can really help you, because it allows you to spend time working on that harder part of what it means to design and build a product. Then, once you have a clear view of that, then you can use AI tools to go really fast. In this example that Jake is showing of Axion Orbital, people get really clever about which parts of this need to be real, which parts of this can be vibe coded, which parts of this can just be a static Figma mockup. It's all about kind of creating a simulation, something that looks realistic, that you can put in front of real customers to help you answer the key questions.

**中文翻译:**
这就是为什么先做基础冲刺再做设计冲刺非常有帮助，因为它让你有时间去处理设计和构建产品中最难的部分。一旦你有了清晰的见解，就可以利用 AI 工具全速前进。在 Jake 展示的 Axion Orbital 例子中，创始人非常聪明地决定了哪些部分需要真实运行，哪些可以凭感觉编程，哪些只需静态的 Figma 模型。这一切都是为了创造一种“模拟”，一种看起来真实的东西，可以展示给真实客户，帮助你回答关键问题。

---

### (01:34:14) Lenny Rachitsky

**English:**
That's a really good point that you're making. Again, it's just a reminder, you'll move faster if you slow down a little bit at the beginning, that because prototyping is so easy now and just things that look ... It's so easy to make something that looks really nice and kind of it's doing what you want, but spending a little time making sure you understand what you're testing and what you want becomes more important.

**中文翻译:**
你说得太对了。这再次提醒我们：如果你在开始时稍微慢一点，最后反而会跑得更快。因为现在做原型太容易了，做一个看起来很漂亮、能按你想法运行的东西太容易了，所以花点时间确保你明白自己在测试什么、想要什么，反而变得更加重要。

---

### (01:34:33) John Zeratsky

**English:**
We had a couple of teams in this current group of Character Labs where they jumped to vibe coding prototypes right away at the very beginning. When you generate something using an LLM, using an AI tool, it looks pretty real. It looks believable. I think there's a temptation to say, "Okay, this is good to go. It looks close enough that I'm just going to show that to customers." Then what they found was, actually, it was super generic. It didn't really describe what the product was. It didn't really describe how it was different because it was generated by a model that is trained on existing products.

**中文翻译:**
在目前的 Character Labs 中，有几个团队一开始就直接跳到了凭感觉编程做原型。当你用大模型或 AI 工具生成东西时，它看起来很真实、很可信。人们很容易产生诱惑：“好，这可以了，看起来差不多，我就拿给客户看吧。” 结果他们发现，那东西非常平庸，没有真正描述出产品是什么，也没有描述出差异化，因为它是由一个在现有产品数据上训练出来的模型生成的。

---

### (01:35:15) John Zeratsky

**English:**
In that second sprint, that was when they really took a step back and said, "Okay, let's think through this and then shift into prototyping mode." It's definitely helping people speed up, but we also think there's an important lesson here that while you're outsourcing prototyping, don't outsource the thinking as well.

**中文翻译:**
在第二次冲刺中，他们才真正退后一步说：“好，让我们先想清楚，再进入原型模式。” AI 确实在帮人们加速，但这里有一个重要的教训：外包原型制作的同时，不要把思考也外包了。

---

### (01:35:33) Lenny Rachitsky

**English:**
I see you pulling something up, Jake, that might be ... I imagine you want to show.

**中文翻译:**
Jake，我看到你在调东西，我想你是想展示一下。

---

### (01:35:37) Jake Knapp

**English:**
Yeah, I think it's kind of interesting to see the sketches that went into [the] Axion Orbital prototype that we just looked at, because they are super detailed. This is ... Doing this level of thought where you're pausing, you're being really intentional about what does the customer need to know, what needs to happen for them to find a solution to their problem and within the product, that's a way of doing your prompt engineering.

**中文翻译:**
是的，我觉得看看 Axion Orbital 原型背后的草图挺有意思的，因为它们非常详细。这种程度的思考——停下来，非常有意识地思考客户需要知道什么、为了解决问题产品内部需要发生什么——这其实就是一种“提示词工程”（Prompt engineering）。

---

### (01:36:04) Jake Knapp

**English:**
If you end up vibe coding this prototype, but you start off with a very clear plan about this is what the thing needs to look like, rather than going immediately into a conversational mode where you're co-designing with the LLM and going back and forth via chat conversation, this is much likelier to yield an opinionated product that makes sense, that's very clearly defined around the problem that you're trying to solve, the tasks that need to happen to solve that problem, and the right messaging, the right wording. It's really crisply aligned with what you know about your customers, what you know about what they care about.

**中文翻译:**
如果你最终要凭感觉编程做原型，但你从一个非常清晰的计划开始，明确“东西应该长什么样”，而不是立即进入与大模型对话、来回拉扯的“共同设计”模式，那么你更有可能做出一个有主见、合乎逻辑的产品。这个产品会围绕你要解决的问题、解决问题所需的任务以及正确的文案进行清晰定义。它会与你对客户的了解以及他们的关注点保持高度一致。

---

### (01:36:40) Lenny Rachitsky

**English:**
That's such a good point. Again, just the concept of the primal mark is ringing in my head as you talk about this. Just as soon as you make that prototype, everything from that point is a response to that first idea, versus have I actually thought through what this should be. Guys, we did it. This is incredible. I think this is going to help a lot of people think through and actually save a lot of time. Is there anything else that you want to share, leave listeners with? Maybe a last nugget or something you want to, I don't know, just double down on to leave folks with before we wrap up.

**中文翻译:**
说得太好了。当你谈到这些时，“原始印记”的概念又在我脑海中回响。一旦你做出了原型，之后的一切都是对那个初始想法的回应，而不是基于“我是否真的想清楚了这应该是什么”。伙计们，我们讲完了。这太棒了，我想这会帮助很多人理清思路并节省大量时间。在结束前，还有什么想分享给听众的吗？也许是最后的一点建议，或者想再次强调的重点？

---

### (01:37:11) John Zeratsky

**English:**
Well, one quick thing is that we've shared a lot of examples in this conversation. We actually have a template, a Miro template, that folks can use if they want to run their own foundation sprint. It's the template that we use when we're working with founders, taking them through these sprints. We do our work in Miro. Even if we're in person with them, we're usually working in Miro, or maybe working on paper and then capturing it in Miro because it's just such a great canvas to work on. We'll make that template available so anybody who's listening or watching can grab that and use it to run their own foundation sprint.

**中文翻译:**
有一点，我们在这次对话中分享了很多例子。我们实际上有一个 Miro 模板，如果大家想运行自己的基础冲刺，可以使用它。这就是我们与创始人合作、带他们进行冲刺时使用的模板。我们在 Miro 中工作，即使是线下见面，我们也通常在 Miro 里操作，或者在纸上画完再拍进 Miro，因为它是一个非常棒的画布。我们会提供这个模板，任何听众或观众都可以获取并用它来运行自己的基础冲刺。

---

### (01:37:47) Lenny Rachitsky

**English:**
That's amazing. You answered the question I asked that I forgot to come back to. Can we give people a URL? Put it in the show notes, but is it at your ... Yeah, I guess where can folks find it?

**中文翻译:**
太棒了，你回答了我刚才问过但忘了追问的问题。能给个网址吗？我会放在节目介绍里。是在你们的……大家去哪找？

---

### (01:37:57) Jake Knapp

**English:**
You should find it at character.vc. You can go there and we'll have a page for you to ... Yeah.

**中文翻译:**
可以在 character.vc 找到。去那里，我们会有一个页面……是的。

---

### (01:38:04) Lenny Rachitsky

**English:**
Amazing. So easy. That is awesome. That's awesome that you guys are doing that. Obviously you could also read the book. That goes through a lot of this process, but I think the template is just like a plug and play. Let's just do this at home. Obviously, if they want to go deeper, they can work with you guys to have you ... It's such a win. They take money. You give them money and you help them figure out what the heck to build. What a deal. That's also character.vc if they want to explore that.

**中文翻译:**
太棒了，简单明了。你们能这么做真是太好了。显然大家也可以去读那本书，书里详细讲解了流程，但模板就像是“即插即用”，可以直接在家操作。当然，如果他们想深入合作，可以找你们……这简直是双赢：你们给他们钱（投资），还帮他们弄清楚到底该构建什么。多划算的交易。想了解的朋友也可以去 character.vc。

---

### (01:38:29) John Zeratsky

**English:**
Yeah. Yep.

**中文翻译:**
是的。

---

### (01:38:29) Lenny Rachitsky

**English:**
Amazing. Okay. Is there anything else, Jake, that you wanted to share before we close up?

**中文翻译:**
太棒了。Jake，在结束前你还有什么想分享的吗？

---

### (01:38:35) Jake Knapp

**English:**
No, just if you made it this far, hopefully your mind and heart is open to this idea, but we know it's a lot to ask, to clear the calendar and follow these steps. If John and I weren't so convinced that beginnings are essential to getting your best efforts in the hands of people and to achieving the things you want for your customers, we wouldn't be doing this. We wouldn't be going to all the trouble. There are simpler things we could be going after.

**中文翻译:**
没有了。如果你听到了这里，希望你对这个想法持开放态度。但我们知道，要求清空日程并遵循这些步骤是很高的要求。如果我和 John 不是如此坚信“开端对于将你的最佳努力交到人们手中、对于为客户实现目标至关重要”，我们也就不会做这件事了。我们不会费这么大劲，毕竟还有更简单的事情可以做。

---

### (01:39:08) Jake Knapp

**English:**
The kind of cool thing we've found about working in this way, though, we've focused a lot on finding product market fit and building your business, getting started, getting momentum, getting alignment, all these things that tactically are important, that business-wise are important, but another part of it that's a nice side benefit, that actually maybe is the most important thing of all, is how close it brings you to your customers, to the people who you're building for. Because you're interacting with them, you're focusing on them as you plan and you're interacting with them on a weekly basis when you work in this way, and how close it brings teammates together in a very authentic way.

**中文翻译:**
我们发现这种工作方式最酷的一点是：虽然我们谈了很多关于寻找 PMF、建立业务、起步、获得动力和达成一致这些在战术和业务上很重要的事，但它还有一个极好的副作用，甚至可能是最重要的：它让你与客户、与你为之构建产品的人们靠得非常近。因为你在计划时就专注于他们，在工作中每周都与他们互动。同时，它也以一种非常真实的方式让团队成员紧密团结在一起。

---

### (01:39:46) Jake Knapp

**English:**
We're working together on the most important things. We don't have to navigate the usual social dynamics of conversations where one person has an idea and they're pitching it. We don't have to navigate the constant context switches of the calendar that dominates our days. We're just working on the most important thing. The structure takes care of a lot of the difficulty of the process of what we should do. We just find people come out of it with renewed motivation, renewed energy, and renewed enthusiasm around the fact that they get to work on what actually matters to them.

**中文翻译:**
我们在一起处理最重要的事情。我们不需要去应付那种“某人有个想法并试图推销它”的常规社交博弈，也不需要应付那种支配我们日常生活的频繁日程切换。我们只专注于最重要的一件事。结构化的流程解决了“我们该做什么”的大部分难题。我们发现人们完成冲刺后，会带着全新的动力、能量和热情回归，因为他们终于能专注于对他们真正重要的事情。

---

### (01:40:21) Lenny Rachitsky

**English:**
Yeah. It just feels like really fun. Just this part of the process is so fun, and then not having to decide how to approach it, having someone just give you here's a framework to follow.

**中文翻译:**
是的，这感觉真的很有趣。流程的这一部分非常吸引人，而且不需要纠结如何切入，有人直接给了你一个可以遵循的框架。

---

### (01:40:29) Jake Knapp

**English:**
It's like a yoga class, right? It's like, I don't know how to do yoga, but ... (Lenny: Just tell me.) ... Explain to me step by step.

**中文翻译:**
就像瑜伽课，对吧？我不知道怎么练瑜伽，但……（Lenny：直接告诉我就行）……请一步步教我。

---

### (01:40:35) Lenny Rachitsky

**English:**
Yoga for startups. That'll be the title for this episode.

**中文翻译:**
“创业公司的瑜伽”，这就是本集节目的标题了。

---

### (01:40:39) Lenny Rachitsky

**English:**
Guys, this was awesome. I'm going to skip the lightning round just because we've gone long. I guess just where can folks find you online? How can listeners be useful to you?

**中文翻译:**
伙计们，这太棒了。因为时间关系，我就跳过闪电问答环节了。最后，大家可以在哪里找到你们？听众能为你们做些什么？

---

### (01:40:48) Jake Knapp

**English:**
You can find me on LinkedIn. John [will] find you on LinkedIn, too. We'd love for people to apply to Character Labs, or if a founder, apply to Character Labs. Get in touch with us, character.vc.

**中文翻译:**
你可以在 LinkedIn 上找到我，John 也在 LinkedIn 上。我们非常欢迎大家申请 Character Labs，如果是创始人，请申请加入。联系我们：character.vc。

---

### (01:41:00) Lenny Rachitsky

**English:**
There we go. All right, guys, thank you so much for being here and for sharing.

**中文翻译:**
太好了。好，伙计们，非常感谢你们来到这里并分享这些。

---

### (01:41:04) John Zeratsky

**English:**
Yeah, thanks, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### (01:41:05) Jake Knapp

**English:**
Thanks, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### (01:41:06) Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 Lennyspodcast.com 找到所有往期节目或了解更多信息。下期见。