# Jake Knapp + John Zeratsky - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Jake Knapp and John Zeratsky.

---

### [00:00:00] Jake Knapp

**English:**
It's not really about productivity, it's not about time management. It's really just about, look, at any given day, we're lucky if we can have one great moment where we have our peak attention and we use it well. And it's not going to happen every day, but if we have some intention around it, it can happen more often than not. The notion with the highlight is imagine it's the end of the day if someone asks you, "What was the highlight of your day," what would you say? That's the anchor of everything. That's the core, that's the foundation. Things can sometimes be a mess outside of that, and you still feel really good about your days. You still feel really good about the way you're spending your energy.

**中文翻译:**
这其实关乎的不是生产力，也不是时间管理。它真正的核心在于：看，在任何一天里，如果我们能拥有一个巅峰注意力的时刻并好好利用它，我们就已经很幸运了。这种情况不会每天发生，但如果我们对此有意识地去规划，它发生的频率会比随机发生要高得多。“每日高光”（Highlight）的概念是：想象到了这一天结束时，如果有人问你：“你今天最高光的时刻是什么？”你会怎么回答？这就是一切的锚点。它是核心，是基础。除此之外，其他事情有时可能一团糟，但你依然会对这一天感觉良好，对自己消耗精力的方式感到满意。

---

### [00:00:37] Lenny

**English:**
Today, I've got two guests, Jake Knapp and John Zeratsky. Jake and John are authors of two incredible books, Sprint and Make Time. With Sprint, they've helped more than 300 teams design new products and bring them to market, including teams at YouTube, Slack, Gusto and One Medical. Previously, John and Jake worked at Google Ventures, and before that, at Google, where John was a leader on Google Ads and YouTube. And Jake helped build Gmail and co-founded Google Meet. Today, they run a venture capital firm called Character, and they actually just opened up applications for their accelerator program called Character Labs, which you can learn more about at character.vc/labs.

**中文翻译:**
今天，我邀请到了两位嘉宾：Jake Knapp 和 John Zeratsky。Jake 和 John 是两本畅销书《设计冲刺》（Sprint）和《时间管理术》（Make Time）的作者。通过《设计冲刺》，他们帮助了 300 多个团队设计新产品并推向市场，其中包括 YouTube、Slack、Gusto 和 One Medical 的团队。此前，John 和 Jake 曾在 Google Ventures 工作，再之前是在 Google，John 曾是 Google Ads 和 YouTube 的负责人，而 Jake 参与打造了 Gmail 并联合创立了 Google Meet。如今，他们经营着一家名为 Character 的风险投资公司，并且刚刚开放了名为 Character Labs 的加速器项目申请，你可以访问 character.vc/labs 了解更多信息。

---

### [00:01:16] Lenny

**English:**
In our conversation, we focus on their more recent book, Make Time, which a guest of this podcast, Ben Williams, recommended in the lightning round, and I absolutely loved and wanted to make sure more people learned about it and the advice within it, especially product leaders and founders who are constantly looking for ways to be more productive. I want to get you right to the meat of the conversation. So, let me just say that we get into a ton of very practical pieces of advice for how you can be more productive in your day, and if you listen to this episode, I guarantee you'll find at least three things that you'll want to start doing differently starting tomorrow. With that, I bring you Jake Knapp and John Zeratsky after a short word from our sponsors.

**中文翻译:**
在今天的对话中，我们将重点讨论他们最近的一本书《时间管理术》（Make Time）。本播客的嘉宾 Ben Williams 曾在闪电轮环节推荐过这本书，我非常喜欢，并希望让更多人了解它及其中的建议，特别是那些不断寻找提高生产力方法的产研负责人和创始人。我想直接带大家进入对话的核心内容。我想说，我们探讨了大量关于如何提高日常效率的实用建议。如果你听完这一集，我保证你至少能找到三件想从明天开始改变的事情。下面，在听完赞助商的简短介绍后，让我们欢迎 Jake Knapp 和 John Zeratsky。

---

### [00:01:57] Lenny (Sponsor: Sidebar)

**English:**
Let me tell you about a product called Sidebar. The best way to level up your career is to surround yourself with extraordinary peers. This gives you more than a leg up. It gives you a leap forward. This worked really well for me in my career and this is the Sidebar ethos. When you have a trusted group of peers, you can discuss challenges you're having, get career advice, and just gut check how you're thinking about your work, your career, and your life. This was a big trajectory changer for me, but it's hard to build this trusted group of peers. Sidebar is a private, highly- vetted leadership program, where senior leaders are matched with peer groups to lean on for unbiased opinions, diverse perspectives and raw feedback.

**中文翻译:**
让我向大家介绍一款名为 Sidebar 的产品。提升职业生涯的最佳方式就是让自己置身于优秀的同行之中。这不仅能给你提供帮助，更能让你实现跨越式发展。这在我的职业生涯中非常奏效，而这正是 Sidebar 的核心理念。当你拥有一群值得信赖的同行时，你可以讨论面临的挑战，获取职业建议，并对工作、事业和生活的想法进行直觉校验。这对我来说是职业轨迹的重大转折点，但建立这样一个互信的同行群体很难。Sidebar 是一个私密的、经过严格审核的领导力项目，资深领导者会被匹配到同行小组中，从而获得公正的意见、多元的视角和坦诚的反馈。

---

### [00:02:38] Lenny (Sponsor: Sidebar)

**English:**
Guided by world-class programming and facilitation, Sidebar enables you to get focused, tactical feedback at every step of your career journey. If you're a listener of this podcast, you're already committed to growth. Sidebar is the missing piece to catalyze your career. 93% of members say Sidebar helped them achieve a significant positive change in their career. Why spend a decade finding your people when you can meet them at Sidebar today? Join thousands of top senior leaders who have taken the first step to career growth from companies like Microsoft, Amazon, and Meta by visiting sidebar.com/lenny. That's sidebar.com/lenny.

**中文翻译:**
在世界级课程和引导的帮助下，Sidebar 让你在职业生涯的每一步都能获得专注且具战术性的反馈。如果你是本播客的听众，说明你已经致力于成长。Sidebar 就是催化你职业发展的最后一块拼图。93% 的会员表示 Sidebar 帮助他们在职业生涯中实现了显著的积极变化。既然今天就能在 Sidebar 遇到志同道合的人，为什么要花十年时间去寻找呢？访问 sidebar.com/lenny，加入成千上万来自微软、亚马逊和 Meta 等公司的顶尖资深领导者，迈出职业成长的第一步。

---

### [00:03:20] Lenny (Sponsor: Whimsical)

**English:**
This episode is brought to you by Whimsical, the iterative product workspace. Whimsical helps product managers build clarity and shared understanding faster with tools designed for solving product challenges. With Whimsical, you can easily explore new concepts using drag and drop wireframe and diagram components, create rich product briefs that show and sell your thinking, and keep your team aligned with one source of truth for all of your build requirements. Whimsical also has a library of easy-to-use templates from product leaders, like myself, including a project proposal one-pager and a go-to-market worksheet. Give them a try and see how fast and easy it is to build clarity with Whimsical. Sign up at whimsical.com/lenny for 20% off a Whimsical Pro plan. That's whimsical.com/lenny.

**中文翻译:**
本集节目由迭代式产品工作空间 Whimsical 赞助。Whimsical 通过专为解决产品挑战而设计的工具，帮助产品经理更快地建立清晰度并达成共识。使用 Whimsical，你可以通过拖放线框图和流程图组件轻松探索新概念，创建丰富的产品简报来展示和推销你的想法，并确保团队在所有开发需求上保持一致（单一事实来源）。Whimsical 还拥有一个由像我这样的产品领导者提供的易用模板库，包括项目提案单页和进入市场（GTM）工作表。试用一下，看看用 Whimsical 建立清晰度是多么快速和简单。在 whimsical.com/lenny 注册，可享受 Whimsical Pro 计划 20% 的折扣。

---

### [00:04:13] Lenny

**English:**
Jake and John, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Jake 和 John，非常感谢你们来到这里，欢迎参加本播客。

---

### [00:04:17] Jake Knapp

**English:**
Thanks for having us. We're so stoked to be here.

**中文翻译:**
谢谢邀请。我们非常高兴能来到这里。

---

### [00:04:20] Lenny

**English:**
I was just re-listening to the audiobook of Make Time to prep for this conversation. And I feel like I kind of know you guys from listening to your voice for so long in the car, and it's a little surreal to be talking to you guys.

**中文翻译:**
为了准备这次对话，我刚刚重新听了《时间管理术》的音频书。在车里听了这么久你们的声音，感觉好像已经认识你们了，现在能和你们面对面交谈感觉有点超现实。

---

### [00:04:31] John Zeratsky

**English:**
That was really fun to record. And while we were doing it, we kept saying to each other, it was like we were recording the world's longest podcast.

**中文翻译:**
录制过程非常有趣。录的时候我们一直在跟对方说，这感觉就像是在录制世界上最长的播客。

---

### [00:04:39] Jake Knapp

**English:**
That's what it felt like.

**中文翻译:**
确实是那种感觉。

---

### [00:04:41] Lenny

**English:**
Actually, on that, how long does it take to record audiobook? I've always been curious. How much time does that-

**中文翻译:**
说到这个，录制一本音频书需要多长时间？我一直很好奇。这需要花多少……

---

### [00:04:45] Jake Knapp

**English:**
Well, it takes twice as long as it should have because my stomach kept growling and the microphone would pick it up. And so, John would do a perfect take and we're both sitting in the little room together and the engineer was in the other room and he'd be like, "You got to do it again. You got to do it again. The guy's stomach keeps growling."

**中文翻译:**
额，花的时间比预想的长了一倍，因为我的肚子一直在咕咕叫，麦克风全录进去了。John 刚完成一次完美的录制，我们俩坐在那个小房间里，工程师在另一个房间里喊道：“得重录，得重录，这家伙的肚子一直在叫。”

---

### [00:05:07] John Zeratsky

**English:**
I think it took two days, right?

**中文翻译:**
我记得花了整整两天，对吧？

---

### [00:05:09] Jake Knapp

**English:**
Yeah, I think it was two days. Yeah, and I think actually they thought it would take two days, so I don't think my stomach slowed us down too much.

**中文翻译:**
是的，我想是两天。其实他们本来也就预计要两天，所以我觉得我的肚子没耽误太多进度。

---

### [00:05:16] Lenny

**English:**
That is not as long as I thought. I thought it was a month of recording and such a painful experience. Sounds like not so bad.

**中文翻译:**
那比我想象的要短。我以为要录一个月，而且过程会很痛苦。听起来还不错。

---

### [00:05:21] John Zeratsky

**English:**
No, honestly, it was really fun. I mean it's weird, but it's just like, I don't know, you can get into this very intense zone where you're singularly focused, right? There's nothing else that you need to do or should do, so it's just like read, drink tea, read, break for lunch, read, drink tea. It's just like this really satisfying flow.

**中文翻译:**
不，老实说，真的很有趣。虽然有点奇怪，但就像……我不知道怎么形容，你可以进入一种非常专注的状态。除了录音，你不需要也不应该做任何其他事情，所以就是：朗读、喝茶、朗读、午休、朗读、喝茶。这是一种非常令人满足的“心流”状态。

---

### [00:05:45] Lenny

**English:**
That sounds like a great few days.

**中文翻译:**
听起来那几天过得很充实。

---

### [00:05:47] Jake Knapp

**English:**
Yeah, I think it was really fun doing it together too. I think it would've been harder to do... I mean obviously people do it and I think they like doing it on their own, but we've been working together for so long, it's always more enjoyable when we get to do something together. So, that made it cool.

**中文翻译:**
是的，我觉得两个人一起录也很有趣。如果一个人录可能会更难……当然，很多人是独自录制的，他们可能也喜欢那样，但我们合作了这么久，一起做事总是更愉快。所以这让整个过程变得很酷。

---

### [00:06:02] Lenny

**English:**
Amazing. I want to do an audiobook now. That sounds like a lot of fun. So, to start diving into our conversation, so you guys wrote this very seminal book called Sprint, which we're going to talk about. But you also wrote this other book that I have right here called Make Time, that to me was even more powerful and I think it might be even more powerful in people's lives than Sprint. And I think it's one of the most interesting and most fun productivity books out there. My wife actually grabbed the book from my desk the past week as I've been prepping for this, and just started highlighting it. You could see all these highlights in here. She just goes-

**中文翻译:**
太棒了。我现在也想录音频书了，听起来很有趣。言归正传，你们写了一本非常有影响力的书叫《设计冲刺》（Sprint），我们待会会聊到。但你们还写了另一本书，就在我手里，叫《时间管理术》（Make Time）。对我来说，这本书甚至更有力量，我觉得它对人们生活的影响可能比《设计冲刺》还要大。我认为它是市面上最有趣、最吸引人的生产力书籍之一。过去一周我在准备这次访谈时，我妻子从我桌上拿走了这本书，开始在上面划重点。你看，这里全是高亮。她就直接……

---

### [00:06:36] John Zeratsky

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:06:37] Jake Knapp

**English:**
Oh, that's so cool.

**中文翻译:**
噢，那太酷了。

---

### [00:06:38] Lenny

**English:**
[inaudible 00:06:38] I want to be more productive. Also, a guest on the podcast introduced me to the book. At the end of the podcast, I'll ask you this too, but I ask people, what book do they recommend most to other people? And he mentioned this book, and so that's how I uncovered it. So, it all comes full circle.

**中文翻译:**
（听不清）我也想变得更高效。另外，是本播客的一位嘉宾向我介绍了这本书。在播客结束时，我也会问你们这个问题：你们最推荐给别人的是哪本书？他当时提到了这本书，我就是这样发现它的。所以，这一切都形成了一个闭环。

---

### [00:06:49] Jake Knapp

**English:**
That's so cool.

**中文翻译:**
那太好了。

---

### [00:06:50] Lenny

**English:**
So, I thought we'd start with Make Time and then get to Sprint in the second half of the conversation. First question is just what do most people get wrong when they're trying to become more productive?

**中文翻译:**
所以，我想先从《时间管理术》开始，然后在对话的后半部分聊聊《设计冲刺》。第一个问题是：大多数人在试图提高生产力时，最容易犯的错误是什么？

---

### [00:07:01] Jake Knapp

**English:**
To set the answer up, I'll give you a super brief history of Make Time. And for over a decade, John and I have been, in quotes, designing time as part of our work with startups, helping them find or expand product market fit. So, we developed a design sprint at Google Ventures, which the Sprint book is about. And now, we run this venture fund of our own called Character. And we run these highly-structured sprints with companies. And when we're doing that, we get to control how everything happens. We get to change the defaults of the way the workday happens, of what happens sort of hour-to-hour, minute-to-minute, how people are using technology, how people are interacting with each other. All those things are sort of under our control because we're trying to achieve these big goals in a really short period of time. Everybody focused.

**中文翻译:**
为了回答这个问题，我先简要介绍一下《时间管理术》的背景。十多年来，我和 John 一直在（引号里的）“设计时间”，这是我们与初创公司合作的一部分，帮助他们寻找或扩大产品市场契合度（PMF）。我们在 Google Ventures 开发了“设计冲刺”，也就是《设计冲刺》那本书的内容。现在，我们经营着自己的风险投资基金 Character。我们会与公司一起进行这些高度结构化的冲刺。在那个过程中，我们可以控制一切发生的流程。我们可以改变工作日的默认模式，改变每小时、每一分钟发生的事情，改变人们使用技术的方式，以及人们互动的方式。所有这些都在我们的控制之下，因为我们试图在极短的时间内实现宏大目标。每个人都高度专注。

---

### [00:07:53] Jake Knapp

**English:**
So, as this stuff was going on, John and I started applying some of the lessons, the things that we found were working really well in those structured sprints. We started experimenting with applying those in our own day-to-day lives, and we found that some of those things were super effective and they were a bit counter to the way we'd sort of heard or learned about productivity. And there's all kinds of habit books and productivity hacks out there. And I think John and I have probably tried most of them, if not all of them. But it seems like 99% of the people who follow those things are still feeling overwhelmed, they're still stressed out all the time anyway.

**中文翻译:**
在这个过程中，我和 John 开始应用一些经验，即那些在结构化冲刺中非常奏效的方法。我们开始尝试将这些方法应用到我们自己的日常生活中，发现其中一些非常有效，而且它们与我们听过或学过的传统生产力方法有些背道而道。市面上有很多关于习惯养成和生产力技巧的书。我想我和 John 几乎尝试过所有的技巧。但似乎 99% 遵循这些方法的人仍然感到不堪重负，仍然时刻处于压力之中。

---

### [00:08:33] Jake Knapp

**English:**
So, even though we are not productivity gurus, this hasn't been like this thing we were doing forever, it's not our full-time job, but we thought we want to share this framework. So, Make Time, the book and the blog that proceeded it was just kind this side project to share what we learned. And yeah, it seems like it is resonated with a bunch of people. There's this kind of steady stream of interest in looking at these things a different way.

**中文翻译:**
所以，尽管我们不是什么生产力大师，这也不是我们一直以来从事的职业，更不是我们的全职工作，但我们觉得应该分享这个框架。因此，《时间管理术》这本书以及之前的博客，其实只是一个分享我们所学知识的副业项目。事实证明，它引起了很多人的共鸣。人们对于用不同的眼光看待这些问题有着持续不断的兴趣。

---

### [00:09:00] Lenny

**English:**
I love it. I love that it emerged out of the sprint concept. I know you talked about the book, but I forgot that and these are all very related. I also love that a lot of the best stuff comes from people actually doing the thing. This came from, "I just have discovered all these little things and I'm just going to share it." Not just like, "I need to write a productivity book."

**中文翻译:**
我太喜欢这个背景了。我喜欢它源于“冲刺”概念这一点。我知道你提过那本书，但我忘了它们之间联系如此紧密。我也很喜欢这种“实践出真知”的方式。这源于“我发现了一些小窍门，我想分享出来”，而不是“我需要写一本生产力书籍”。

---

### [00:09:16] John Zeratsky

**English:**
Yeah, I think, like Jake said, we both had always sort of been dissatisfied with the state of the productivity art, and we had big things we wanted to do. I mean, when you work in any kind of job, I mean we've both spent our early careers as designers and the job is really all about doing big projects. It's all about being able to focus, being able to spend time on the things that matter. And that's to say nothing of what we want outside of work, things that we want to learn how to do personally, people we want to spend time with. And it's interesting, we've found that when we talk to people about Make Time, they always know. They always know what they want to make time for. The problem is not like what should my goal be or how should I figure out what to do with my life? They usually know, but it's very hard to actually make time for those things.

**中文翻译:**
是的，正如 Jake 所说，我们俩一直对现有的生产力方法感到不满，而我们又有宏大的目标想要实现。无论你从事什么工作——我们职业生涯早期都是设计师——工作的核心就是完成大项目。关键在于能否专注，能否把时间花在重要的事情上。更不用说我们在工作之外的追求了：个人想学的东西，想陪伴的人。有趣的是，当我们和人们聊起《时间管理术》时，他们其实心里都清楚。他们知道自己想为哪些事腾出时间。问题不在于“我的目标是什么”或“我该如何规划人生”，他们通常知道答案，但难点在于如何真正为这些事腾出时间。

---

### [00:10:16] John Zeratsky

**English:**
And I think the problem is that most productivity advice focuses on getting better and faster about doing the things that are already in front of you. So, the messages that are in your inbox, the meetings that are on your calendar, a lot of focus on efficiency, like crank through that stuff. Our perspective is basically that those are the defaults. Just like our software that we use, apps that we use have defaults, those are the defaults of life, of the companies that we work in, the culture that we live in. And so, the solution is actually to change those defaults and to really flip this way of thinking on its head. So, it's not about how do I go faster? How do I get more efficient? It's about how do I put the thing that is the most important first in my day or in my life, and then build everything else around that and accept that you're going to need to do a bunch of those little things. You're going to need to answer those messages and go to those meetings, but really, start with the idea of what's most important to you? What do you actually want to make time for?

**中文翻译:**
我认为问题在于，大多数生产力建议都集中在如何更好、更快地处理眼前的事情。比如收件箱里的邮件、日历上的会议，过分强调效率，比如“快速搞定这些事”。我们的观点是，这些其实只是“默认设置”。就像我们使用的软件和 App 有默认设置一样，这些是生活、公司文化和我们所处环境的默认设置。因此，解决方案其实是改变这些默认设置，彻底扭转这种思维方式。所以，重点不是“我如何跑得更快？”或“我如何更高效？”，而是“我如何把最重要的事情放在一天或一生的首位，然后围绕它构建其他一切？”并接受你仍然需要处理那些琐事。你还是得回邮件、开会，但要从“什么对你最重要？你到底想为什腾出时间？”这个念头开始。

---

### [00:11:25] Lenny

**English:**
Along these same lines, we're going to talk about this kind of four-part strategy that you recommend, but a couple of things before we get into there. One is along the lines you just talked about is this insight that you had of just like willpower is never going to be enough to get you to make time for the things you want to do. And you had these two concepts of busy bandwagon and infinity pools, so maybe just talk about those two briefly.

**中文翻译:**
沿着这个思路，我们稍后会讨论你们推荐的四步策略。但在那之前，有两件事想先聊聊。一是你刚才提到的洞察：仅仅依靠意志力永远不足以让你为想做的事腾出时间。你们提出了两个概念：“忙碌从众效应”（Busy Bandwagon）和“无尽内容池”（Infinity Pools），能不能简要介绍一下这两个概念？

---

### [00:11:47] Jake Knapp

**English:**
The idea of the busy bandwagon is just this expectation that everybody's busy. And in the United States, there's kind of this thing that I think if you travel abroad and talk to people for a while, then you come back, you'll notice, which is like if you ask someone, "Hey, how's it going? What are you up to?" And they'll be like, "Oh man, I'm busy." It's kind of the default answer. "I'm busy. Things are busy." And it means, usually, it could mean a variety of things, but usually it's good. Like, "Oh, it's busy, so business is booming," or, "It's busy, I'm overwhelmed," or whatever. But busy, it's kind of the expectations that everybody's busy. And we are, I mean we are busy, but we call it the busy bandwagon because it feels like you should be busy. And it's this inner feeling caused by what we see or perceive other people are doing that drives a lot of the stress. And I don't mean to sound like I'm above it all and have figured it all out. It still drives my stress, this inner feeling that other people haven't figured out, other people are expecting fast reactions from me, all this. That's the busy bandwagon, this sort of feeling that I should be busy, that everyone else is busy. And what that does inside of us is really the core of what we have to change and figure out, this getting out of a reaction mode. The other thing that happens to us are the infinity pools. And John, do you want to describe what infinity pools are in our context?

**中文翻译:**
“忙碌从众效应”是指一种“每个人都很忙”的普遍预期。在美国，有一种现象，如果你去国外旅行一段时间再回来，你就会注意到：如果你问某人“嘿，最近怎么样？在忙什么？”，他们通常会回答“噢，伙计，我很忙”。这几乎成了默认回答。“我很忙，事情很多。”这通常意味着很多事，但大多是正向的，比如“生意兴隆”或者“忙得不可开交”。但“忙碌”成了一种预期。我们确实很忙，但我们称之为“忙碌从众效应”，是因为它让你觉得你“应该”很忙。这种内在的感觉是由我们看到或感知到的他人的行为引起的，它驱动了大部分压力。我并不是说我超脱了这一切，它依然会给我带来压力——那种觉得别人都搞定了、别人期待我快速反应的感觉。这就是“忙碌从众效应”，一种“我应该忙，别人也都在忙”的感觉。这种内在驱动力正是我们需要改变的核心：摆脱“反应模式”。另一件困扰我们的事是“无尽内容池”。John，你想描述一下我们语境下的“无尽内容池”吗？

---

### [00:13:14] John Zeratsky

**English:**
Yeah, we came up with this name because we were trying to think of endlessly replenishing fount of content. So, basically if you can pull to refresh or if it streams, it's an infinity pool. So, this is pure entertainment stuff. This is stuff that people say like, "Oh, I spend so much time on Instagram," but it's also stuff that's important and necessary and productive. Email is a huge infinity pool and it's probably the single hardest thing for the two of us to control and avoid getting sucked into. And anybody listening to this is going to, I think, understand how powerful those pools are and how effectively designed and engineered those products are to be really compelling and to be friction-free and to just make it easy for us to dive back into that pool.

**中文翻译:**
是的，我们起这个名字是因为我们在思考那些源源不断、自动补充的内容源。基本上，只要你能“下拉刷新”或者它是流式传输的，它就是一个“无尽内容池”。这包括纯娱乐内容，比如人们常说的“我在 Instagram 上花了太多时间”，但也包括那些重要、必要且看似有生产力的东西。电子邮件就是一个巨大的无尽内容池，它可能是我们两个最难控制、最容易深陷其中的东西。我想任何听众都能理解这些“池子”有多么强大，以及这些产品在设计和工程上是多么有效——它们极具吸引力、毫无阻力，让我们能轻而易举地再次跳入池中。

---

### [00:14:15] John Zeratsky

**English:**
And so, when you put these two things together, the busy bandwagon and the infinity pool, you kind of have this, it's like a flywheel, but bad. You feel like you really need to be busy, you really need to be on top of everything. And then, you've got this whole collection of apps and services and products there that are ready to pounce on that, they're ready to take advantage of that set of defaults, that cultural and internal set of defaults that you have about what you should be doing. And for a lot of people, it just sort of spins out of control. So, our view is if you can name those two things, if you can understand those two things, then you can start to deliberately change some of the defaults around them, so that you can put your most important projects, people, work first, like we talked about.

**中文翻译:**
所以，当你把这两者结合起来——“忙碌从众效应”和“无尽内容池”——你就得到了一种恶性循环。你觉得你必须很忙，必须掌控一切；而与此同时，你拥有一大堆 App、服务和产品，它们随时准备扑向这种心理，利用你关于“应该做什么”的文化和内在默认设置。对很多人来说，这会逐渐失控。所以我们的观点是，如果你能命名这两件事，理解这两件事，你就可以开始有意识地改变围绕它们的默认设置，从而像我们讨论的那样，把最重要的项目、人和工作放在首位。

---

### [00:15:04] Lenny

**English:**
I'm guilty of both these things. I feel like the reason I do some of these chats, this one in particular is it's like one-on-one coaching almost. This is going to help me stick to some of the things you teach. And I've already actually implemented a number of the things you recommend, but this is reinforcing it. And then, obviously, also helping all the listeners get better at these things. Before we get into it, one last question is just like real talk, how how's your guys' productivity? You wrote this book, it sounds amazing. There's 87 I think pieces of advice. How is it going for you guys? As we go through, I want to hear what you're actually using, but just broadly, how's your productivity?

**中文翻译:**
这两点我都有罪。我觉得我进行这些对话的原因，尤其是这一场，几乎就像是一对一的教练辅导。这能帮我坚持你们教的一些方法。实际上我已经实施了你们推荐的一些做法，但这能起到强化作用。当然，这也能帮助所有听众改进。在深入探讨之前，最后一个问题是：说实话，你们两位的生产力如何？你们写了这本书，听起来很棒，里面大概有 87 条建议。你们自己实践得怎么样？在接下来的对话中，我想听听你们实际在用哪些，但总体来说，你们的生产力如何？

---

### [00:15:40] Jake Knapp

**English:**
At the top of the interview, Lenny, you asked, "What do most people get wrong when they think about this productivity, time management, whatever?" And I'll frame my answer in those terms. So, most people, I think they try to get better and faster at doing what's right in front of them. We don't change the defaults in our environment, so we can focus and spend time on these different more important things. And if you think of that sort of what do I want to do? What's my goal? What do I want to spend time on that John referred to as project A, generally the things we want to do, these project A things, they're big, they're not easy to start, they're slow to create, dopamine hits, they're non-urgent. Like boss is not asking for them if you have a boss. And generally, the tasks and activities that stand in our way that keep us from doing project A, they're small, they're medium size, it's obvious how to start them, they create dopamine right away, they're supposedly urgent, email meetings, TikTok, Instagram, news, what's on your OKRs, all these things.

**中文翻译:**
在采访开始时，Lenny，你问“大多数人在思考生产力、时间管理时犯了什么错？”，我将以此来回答。大多数人试图更快、更好地完成眼前的事。我们没有改变环境中的默认设置，以便专注于更重要的事情。如果你想一想“我想做什么？我的目标是什么？我想把时间花在什么上面？”，也就是 John 所说的“项目 A”。通常，这些“项目 A”很大，不容易开始，产生多巴胺的速度很慢，而且不紧急。比如，如果你有老板，老板可能并没催你做这些。而通常阻碍我们做“项目 A”的任务和活动都很小或中等，很容易开始，能立即产生多巴胺，而且看起来很紧急：邮件、会议、TikTok、Instagram、新闻、你的 OKR 上的内容等等。

---

### [00:16:47] Jake Knapp

**English:**
And I know what's on your OKRs may not sound like it's a peer of those others, but in a way it really can be. So, these big things, they're at odds with these little things that get in the way that the busy bandwagon expects us to do, these things that have infinity pools built in. And so for me, right now, it's a constant battle between the Jake and the busy bandwagon and my inner feeling of how can I live up to people's expectations of me and respond in the way that I should and react in the way that I should? And then, how can I do the project A stuff, the big important stuff? A lot has changed in my life since we wrote the book.

**中文翻译:**
我知道 OKR 上的内容听起来可能不像其他那些琐事，但在某种程度上，它们确实是。所以，这些大事与那些阻碍我们的、忙碌从众效应期望我们做的、内置了无尽内容池的小事是冲突的。对我来说，现在就是“Jake”与“忙碌从众效应”之间的持久战。我内在的感觉是：我如何才能不辜负别人对我的期望，以应有的方式做出回应和反应？然后，我如何才能去做“项目 A”，那些重大且重要的事？自从写完那本书后，我的生活发生了很大变化。

---

### [00:17:28] Jake Knapp

**English:**
The summary is every few months I need a few new experiments. I have found in what has been some trying times that the tactics and the framework that we use... Because it's kind of simple and it sort of fits with these experiences that I've had for many years doing sprints, that it works. And that if I can go back to that, that if I can create space for it, if I can think about this as it's a series of experiments, if I can look at myself with curiosity and say, "Why are things not working out?" And then try to experiment my way out of it that I'm able to. But yeah, so at any given point in time, I probably give myself a B to B-, and sometimes it's a C and sometimes it's a D, and sometimes it's an A, and I'm really plugging away, but it's totally an ongoing challenge.

**中文翻译:**
总结来说，每隔几个月我就需要进行一些新的实验。我发现在一些艰难时期，我们使用的策略和框架——因为它很简单，而且符合我多年来做冲刺的经验——它是有效的。如果我能回归那个框架，如果我能为此腾出空间，如果我能把它看作一系列实验，如果我能带着好奇心审视自己并问“为什么事情进展不顺？”，然后尝试通过实验找到出路，我就能做到。但确实，在任何给定的时间点，我可能会给自己打 B 到 B-，有时是 C，有时是 D，有时是 A，我一直在努力，但这绝对是一个持续的挑战。

---

### [00:18:22] Jake Knapp

**English:**
So, I'm not going to sit here and say, yeah, just follow me with a drone for 48 hours and you'll think that's exactly how you should do things. But part of our philosophy, I think that part of the way I look at it is it can be a mess. And yet, if you can create the space for those project A moments, for your highlights, that can shape everything else, if you just have those moments. Things can sometimes be a mess outside of that and you still feel really good about your days, you still feel really good about the way you're spending your energy.

**中文翻译:**
所以我不会坐在这里说：“嘿，用无人机跟着我拍 48 小时，你就会觉得这就是你应该做事的方式。”但我们的部分哲学，或者说我看待它的方式是：生活可以是一团糟。然而，如果你能为那些“项目 A”的时刻、为你的“高光时刻”腾出空间，那些时刻就能塑造其他一切。只要拥有那些时刻，即使除此之外的事情有时一团糟，你依然会对这一天感觉良好，对自己消耗精力的方式感到满意。

---

### [00:18:56] John Zeratsky

**English:**
And having a framework for it gives you a path back. If you're just stuck and you're looking... You're sort of grasping for hacks. You're sort of like, "Oh, I read this blog post about this thing, I'll try it." That might have some short-term effect, but ultimately, you're probably not going to stick to it. You're probably going to fall back into that place of overwhelm and disappointment and burnout. But we find that if you have a system, that you can use the system and you can return to it and continue to build on and experiment, that you can make more sustainable progress on these things.

**中文翻译:**
拥有一个框架能给你提供一条回归之路。如果你只是陷入困境，到处寻找“黑科技”或小技巧，比如“噢，我读了篇关于这个的博客，我试试”，这可能会有短期效果，但最终你可能坚持不下去。你可能会重新陷入那种不堪重负、失望和职业倦怠的状态。但我们发现，如果你有一个系统，你可以使用它，回归它，并在此基础上继续构建和实验，这样你就能在这些事情上取得更可持续的进展。

---

### [00:19:33] Lenny

**English:**
I think a really important takeaway from these two stories you guys just shared is you don't have to do all of these things. You don't even have to do most of them. If you just do one or two, if you find one or two things that can make you a little bit more productive every day, that makes a huge dent. And so, I think it's okay to feel like, "Oh, I tried this stuff. It didn't work." I think as long as you take a couple of things away today that might be useful to you, and then just try them again in the future. If they end up not working out. Like you delete an app and then you reinstall it, I think that's okay. So, I think that's an important takeaway from this is don't feel like you're failing if you're not doing all of the things that we're talking about today.

**中文翻译:**
我觉得从你们刚才分享的两个故事中可以得到一个非常重要的启示：你不需要做所有这些事情，甚至不需要做其中的大部分。如果你只做一两件，如果你发现一两件能让你每天效率提高一点点的事情，那就会产生巨大的影响。所以，我觉得即使感觉“噢，我试过这些，没用”也没关系。只要你今天能带走几件对你有用的东西，然后在未来再次尝试。如果最后没成功，比如你删了一个 App 然后又装回来了，我觉得也没关系。所以，一个重要的启示是：如果你没有做到我们今天讨论的所有事情，不要觉得自己失败了。

---

### [00:20:10] Lenny

**English:**
But let's get into it. There's this kind of four-part strategy for how to help yourself be more productive. Basically, if you could just give an overview and then we'll just talk about each of these steps one by one. So, the four parts are create a highlight, laser, energize, and reflect. So, I'll turn it over to you guys just broadly, and then let's go through each of these one by one.

**中文翻译:**
那我们开始吧。你们有一套四步策略来帮助提高生产力。基本上，如果你们能先给一个概览，然后我们再一步步讨论。这四个部分是：创造高光（Highlight）、激光专注（Laser）、保持活力（Energize）和反思（Reflect）。现在交给你们先做个大致介绍，然后我们再逐一深入。

---

### [00:20:30] Jake Knapp

**English:**
It all starts with this notion of a highlight. And highlight is, I hate to say this, it's the most powerful best part, I think of the whole process. And I hate to say that because John came up with it. It wasn't even me. But I have to admit, it's really good. And I think as folks have read the book and shared it, that's the thing we hear back from people. If you could just do one thing from this book and try this out, it's a big deal.

**中文翻译:**
一切都始于“每日高光”（Highlight）这个概念。虽然我很不想承认，但我觉得它是整个流程中最强大、最精彩的部分。我不想承认是因为那是 John 想出来的，甚至不是我。但我不得不承认，它真的很棒。我想随着人们阅读和分享这本书，这是我们收到的最多的反馈。如果你只能从这本书里选一件事来尝试，那就是它，这意义重大。

---

### [00:20:54] Jake Knapp

**English:**
The notion what the highlight is, start your day out and you imagine it's the end of the day, you're looking back on the day. If someone asked you, "What was the highlight of your day," what would you say? What do you want to say at the end of today was the highlight of today? And you start there, just like, "Okay, what would I like to say the highlight of the day was?" And you might think about what's urgent. Sometimes the highlight is this thing that really has to happen today. Today is the day there's a big meeting, or there's this thing I absolutely have to get done for work for tomorrow. That could be your highlight and getting that done well, having good attention to that will be very satisfying.

**中文翻译:**
“每日高光”的概念是：在一天开始时，想象到了这一天结束，你回顾这一天。如果有人问你：“你今天最高光的时刻是什么？”，你会怎么说？你希望在今天结束时说什么是今天的高光？你就从那里开始，想一想：“好吧，我希望今天的高光是什么？”你可能会考虑紧急的事情。有时高光是今天必须发生的事。比如今天有个大项目会议，或者有件工作我明天之前必须完成。那就可以是你的高光，把它做好、全神贯注地完成它会让你非常有成就感。

---

### [00:21:37] Jake Knapp

**English:**
But a lot of times the highlight comes from joy or satisfaction, projects that wouldn't otherwise get attention. And it also doesn't have to just be something at work. It could be people in your life that you want to spend time with, a hobby that you want to spend time on. If you want to get better at Mario Kart, having a good session at Mario Kart, whatever might be the highlight of your day. The notion is just in the morning to think, "What is it and what is that highlight going to be?" And then, try to find a block that's 60 to 90 minutes. That's just usually the rough time we think it takes to really get in the zone on something, do a really excellent job, be totally focused on it. So, that highlight, that's the anchor of everything. That's the core, that's the foundation. And you start that way, you're now trying to shape your time around that highlight, and making sure that you have your peak energy, your peak attention when the time for that highlight comes around.

**中文翻译:**
但很多时候，高光来自于快乐或满足感，来自于那些如果不刻意安排就不会得到关注的项目。它也不一定非得是工作。可以是你想陪伴的人，或者是你想投入时间的爱好。如果你想提高马里奥赛车的水平，那么玩一局精彩的游戏也可以是你今天的高光。核心思想就是在早上想一想：“它是什么？今天的高光会是什么？”然后，尝试找一段 60 到 90 分钟的时间块。这通常是我们认为进入状态、出色完成某事并保持完全专注所需的大致时间。所以，这个高光就是一切的锚点。它是核心，是基础。你从这里开始，尝试围绕这个高光来规划时间，并确保在高光时刻到来时，你拥有巅峰的精力和注意力。

---

### [00:22:37] Jake Knapp

**English:**
So, laser is about the tactics you might need to actually focus on that thing. In highlight, we have a set of tactics for how to create and think about and frame that highlight. Laser, we have a set of tactics for how do you pay attention when that time comes? Then for energize, it's about having the right amount of energy to do the thing, to pay attention. My highlight for today is trying to be coherent in this podcast, so this morning I need to think about what's the best way for me to have peak energy when a podcast starts.

**中文翻译:**
接下来，“激光专注”（Laser）是关于你真正专注于那件事所需的策略。在“高光”部分，我们有一套关于如何创造、思考和界定高光的策略。在“激光专注”部分，我们有一套关于当那个时刻到来时如何保持注意力的策略。然后是“保持活力”（Energize），它是关于拥有足够的精力去做那件事、去保持专注。我今天的高光是努力在这个播客中表达清晰，所以今天早上我需要思考：在播客开始时，我如何才能处于精力的巅峰状态。

---

### [00:23:08] Lenny

**English:**
That's my highlight too, actually. I have [inaudible 00:23:10].

**中文翻译:**
那其实也是我的高光。我有（听不清）。

---

### [00:23:10] Jake Knapp

**English:**
Oh, good. Right on. Okay.

**中文翻译:**
噢，太好了。没错。

---

### [00:23:11] Lenny

**English:**
Record a great podcast episode.

**中文翻译:**
录制一集精彩的播客。

---

### [00:23:14] Jake Knapp

**English:**
Excellent, excellent. Okay. Yeah. And if you're not watching on video, Lenny had a sticky note and he wrote it down. So, that's actually literally the best way to do this is write it down on a sticky note, put it somewhere where you can see it. And so, you've got highlight, laser during the time of the highlight, energize, make sure you have the energy you need when the time comes. And these are just tactics around sleep and food and exercise, and just things that help with your mental energy, not crazy stuff. And then the final thing is reflect, and this is where we think about this as the scientific method. Did it work? Did what I tried today work out? And if not, just being curious about it, what didn't? And adjusting and trying to think, "Okay, maybe there's another tactic I can try."

**中文翻译:**
太棒了。如果你没看视频，Lenny 刚才拿出一张便签纸，把它写了下来。这其实就是最有效的方法：写在便签上，贴在你能看到的地方。所以，你有了高光，在高光时刻进行激光专注，保持活力以确保到时候有足够的精力。这些只是关于睡眠、饮食和运动的策略，以及一些帮助提升脑力的事情，并不复杂。最后一部分是“反思”（Reflect），我们将其视为一种科学方法。它奏效了吗？我今天尝试的方法成功了吗？如果没有，就保持好奇：哪里没做好？然后调整并思考：“好吧，也许我可以尝试另一种策略。”

---

### [00:23:54] Jake Knapp

**English:**
So, the book is like... What are there like 87 tactics in the book? There's a lot of different approaches, but the expectation is not you're going to use all of them. And the expectation is not that-

**中文翻译:**
所以，这本书就像……书里大概有 87 种策略？有很多不同的方法，但我们并不期望你使用所有的策略。我们也不期望……

---

### [00:24:00] Jake Knapp

**English:**
... expectation is not you're going to use all of them. And the expectation is not that all of them will work for each person. I use different tactics than John does, and some of his don't work for me, and vice versa. But that idea of centering on a thing, focusing on it, having tactics for that, having tactics for energy, and then having some tactics to reflect and reframe and be curious. That taken together, we find, just can reframe the way it feels. It's not really about productivity. It's not about time management. It's really just about, look, in any given day, we're lucky if we can have one great moment where we have our peak attention, and we use it well. And it's not going to happen every day, but if we have some intention around it, it can happen more often than not.

**中文翻译:**
……并不期望你使用所有策略，也不期望所有策略对每个人都有效。我用的策略和 John 的不一样，他的一些方法对我没用，反之亦然。但这种以一件事为中心、专注于它、为此制定策略、为精力制定策略，然后通过反思和重构保持好奇心的想法，结合在一起，我们发现它能改变你的感受。这真的不是关于生产力，也不是关于时间管理。它真正的核心在于：看，在任何一天里，如果我们能拥有一个巅峰注意力的时刻并好好利用它，我们就已经很幸运了。这种情况不会每天发生，但如果我们对此有意识地去规划，它发生的频率会比随机发生要高得多。

---

### [00:24:47] Lenny

**English:**
I think that last point is so important and why the highlight works so well for me is usually there's... You don't get anything amazingly done in a day, often. And usually, you're just distracted by all these things, and you're doing all the easy stuff. You talked about this idea of Project A, like here's the thing I really want to get done, but the dopamine hit us so far in the future, and it's so hard. And so, the reason I think the highlight is so powerful is, you get one thing done you're proud of, that is a great day. And it may sound crazy that that's true, but it's so true.

**中文翻译:**
我觉得最后一点非常重要，这也是为什么“高光”对我如此有效的原因。通常情况下，你一天下来可能并没有完成什么了不起的事情。你通常只是被各种琐事分心，做着最容易的事。你提到了“项目 A”的概念，比如“这是我真正想完成的事”，但它的多巴胺回报在遥远的未来，而且过程很艰难。所以，我认为“高光”之所以强大，是因为如果你完成了一件让你自豪的事，那这就是伟大的一天。这听起来可能有点疯狂，但事实确实如此。

---

### [00:25:14] Jake Knapp

**English:**
Yeah, totally.

**中文翻译:**
是的，完全正确。

---

### [00:25:17] Lenny

**English:**
So, I want to talk more in depth about each of these four things, and maybe spend the most time on the highlight and the laser because I think that's where most of the impact comes from. So, with the highlight, do you have any advice? You shared a couple examples of how to come up with like, "Here's the thing to pick for the day." There's a few questions that you recommend, and I think you shared a couple of them. And then, are there any examples of highlights from your guys', I don't know, past couple of weeks that would be good for people to hear an example? And then, also, there's this calendar component, which maybe fits into the laser, but I guess that feels like a really important element of this. So, if you just talk about that?

**中文翻译:**
所以，我想深入探讨这四个部分，可能会在“高光”和“激光专注”上花最多的时间，因为我觉得那是影响最大的地方。关于“高光”，你们有什么建议吗？你们分享了几个如何确定“今天选什么”的例子。你们推荐了几个问题，我想你刚才已经提到了几个。那么，在你们过去几周的生活中，有没有什么“高光”的例子可以分享给听众？另外，还有一个关于日历的部分，也许它属于“激光专注”，但我感觉它是其中非常重要的元素。能聊聊这个吗？

---

### [00:25:51] John Zeratsky

**English:**
For me, and again, this is where the framework is intentionally flexible, different people have different highlights. But for me, I am very project oriented. I'm very work oriented. And for me, most days, a really good day comes from having made progress on something that is really important to me. So, my highlights are usually focused work, creative work related. And this has become even more important since we started our own VC firm three years ago. And before that, I was sort of, I guess, more or less a writer, full-time writing, and speaking at events, and doing some consulting. And before that, I was a partner at Google Ventures, at GV, and before that I was a product designer. So, I've been through different modes and contexts in my career.

**中文翻译:**
对我来说——再次强调，这个框架是有意设计得很灵活的，不同的人有不同的高光。但对我而言，我是非常以项目为导向、以工作为导向的。大多数时候，对我来说，一个美好的一天来自于在某件对我非常重要的事情上取得了进展。所以，我的高光通常是深度工作、与创意工作相关的。自从三年前我们创办了自己的风投公司以来，这一点变得更加重要。在那之前，我或多或少算是个作家，全职写作、在活动中演讲并做一些咨询。再之前，我是 Google Ventures (GV) 的合伙人，更早之前我是产品设计师。所以，在我的职业生涯中，我经历过不同的模式和背景。

---

### [00:27:08] John Zeratsky

**English:**
And if you know any VCs, if you're listening to this and you know any VCs, they're probably the busiest, most frazzled people that you know who are constantly on email, constantly in Zoom calls and meetings, and on airplanes all the time. And so, the natural environment of that work is the busy bandwagon, and it's to have a lot of infinity pools that you need to care about. And so, in that context, in order for us to make progress on projects, in order for us to move the ball on a launch related to this program, Character Labs, that we run with pre-seed founders that's coming up, or we're writing a new book, and that's a big project, or working with one of our portfolio companies and running a sprint with them, or writing a newsletter that goes out to our LPs, those things are all really important, and I feel like they give us a unique edge as a VC firm.

**中文翻译:**
如果你认识任何风投人（VC），或者听众里有认识 VC 的，他们可能是你认识的最忙碌、最疲惫的人，整天回邮件、开 Zoom 会议、出差。所以，这种工作的自然环境就是“忙碌从众效应”，你必须关注大量的“无尽内容池”。在这种背景下，为了在项目上取得进展，为了推进我们即将与种子前创始人合作的 Character Labs 项目的启动，或者写一本新书（这是一个大项目），或者与我们投资的一家公司一起进行冲刺，或者给我们的有限合伙人（LP）写简报——这些事情都非常重要，我觉得它们作为一家风投公司赋予了我们独特的优势。

---

### [00:27:55] John Zeratsky

**English:**
If we accept the premise I said before, that most VCs are just sort of frantically running around, if we can take these bigger swings at things, then theoretically, they should really help us be successful. So, most of the time, it's all a very long way of saying that most of the time my highlights are like, "What do I want to accomplish at work? What is the thing that I want to get done today?" And so, what I do then is, I structure my calendar around making time for that. There's a tactic in the book called Design Your Day that is really about kind of drawing out your day, and using your calendar as a canvas where you can design how you want to spend your time rather than using your calendar as a thing that is done to you, a thing that tells you what you have to do. Reclaim control over that.

**中文翻译:**
如果我们接受我之前说的前提，即大多数 VC 只是在疯狂地奔波，那么如果我们能把精力集中在这些“大动作”上，理论上它们应该能帮助我们取得成功。所以，绕了这么大一圈，我想说的是，大多数时候我的高光是：“我在工作中想达成什么？我今天想完成哪件事？”然后，我会围绕这件事来规划我的日历。书里有一个策略叫“设计你的一天”（Design Your Day），它其实是把你的日历当作画布，让你设计自己想如何度过时间，而不是让日历成为一种强加在你身上的东西，告诉你必须做什么。重新夺回对时间的控制权。

---

### [00:29:06] Lenny

**English:**
We had a previous guest on, Neer Eyal, also talking about productivity, and he had actually the same advice of just using your calendar as your to-do list, basically, because that's where time's going to go, what your calendar's telling you to do. So, I think there's a pattern here that I think people need to pay attention to.

**中文翻译:**
我们之前的嘉宾 Neer Eyal 也谈到了生产力，他其实给出了同样的建议：基本上就是把日历当作你的待办事项清单，因为那是时间真正流向的地方，也是日历告诉你要做的事情。所以，我觉得这里有一个值得大家关注的模式。

---

### [00:29:22] John Zeratsky

**English:**
Yeah, definitely. Yeah, and I mean, we take it even further, and we have sort of a calendar template that we use as a team. So, we have certain times of the week. And it's not exactly the same for all of us on the team, but there are certain times of the week where it's like, yeah, this is when we do these kinds of things. This is when we have these kinds of meetings. And not to say that those are all standing meetings, although we have some of those as well, but these are kind of the content buckets in the template that we can fill with a specific type of activity, but then other parts of the template are sort of reserved for focus work, reserved for individual, solo time to work on things that we need to get done.

**中文翻译:**
是的，绝对如此。而且，我们做得更彻底，我们团队有一套通用的日历模板。虽然团队里每个人的情况不完全一样，但每周都有固定的时间段，比如“这段时间我们处理这类事情”，“这段时间我们开这类会议”。这并不是说这些都是固定例会（虽然也有一些），而是模板中的“内容桶”，我们可以用特定类型的活动来填充。而模板的其他部分则预留给深度工作，预留给个人独立处理任务的时间。

---

### [00:30:03] John Zeratsky

**English:**
So, yeah. I think the calendar is, at an individual level and especially at a team level, is this really powerful tool that most people just kind of... Not only do they not use it as a tool, they just sort of hate it. They're sort of like, "Ugh, my calendar, it's a mess. If I could live without a calendar, that would be the dream." But I think if you can use some of these tactics or use other approaches to reclaim it, and use it proactively as a tool for yourself, it can really help you structure your time around the things that you care about.

**中文翻译:**
所以，是的。我认为日历在个人层面，尤其是在团队层面，是一个非常强大的工具，但大多数人……他们不仅不把它当作工具，甚至还讨厌它。他们会觉得：“唉，我的日历一团糟。如果能不用日历生活，那简直是梦想。”但我认为，如果你能使用这些策略或其他方法重新夺回控制权，并主动将其作为自己的工具，它真的能帮你围绕你关心的事情来规划时间。

---

### [00:30:41] Lenny

**English:**
Yeah. The way I've been starting to use my calendar is this way, exactly, is I try to prepare for work on next week's newsletter post for like an hour and a half, then prep for the podcast coming up in a few weeks. So, it's very specific and broken up. Along those lines, I often don't do these things as I planned. And one of your principles, something around Groundhog Day, it's okay to repeat it if you didn't do it. If you highlight you didn't do, just repeat it again and again until you do it. Right?

**中文翻译:**
是的。我开始使用日历的方式正是如此：我会花一个半小时准备下周的简报，然后为几周后的播客做准备。所以它是非常具体且拆分好的。沿着这个思路，我经常无法按计划完成这些事。你们有一个原则，关于“土拨鼠之日”（Groundhog Day），大意是如果你没完成，重复它是没关系的。如果你没完成你的高光，就一遍又一遍地重复它，直到完成为止。对吧？

---

### [00:31:09] Jake Knapp

**English:**
I think that what's so cool about this notion of Groundhog Day. And if you've seen the movie... Well, if you haven't seen the movie, see the movie. What a great movie.

**中文翻译:**
我觉得“土拨鼠之日”这个概念最酷的地方在于……如果你看过那部电影……好吧，如果你没看过，一定要去看，那是一部伟大的电影。

---

### [00:31:09] Lenny

**English:**
It was a good movie.

**中文翻译:**
那确实是一部好电影。

---

### [00:31:15] Jake Knapp

**English:**
If you've seen the movie, you know it's like, not to give it away, but he gets better and better at doing the day, and that's kind of this core philosophy that we take on. I think a lot of the time, when in the past I have thought about, "How can I be effective with my time? How can I be productive?" It's beating myself up. It's not a good feeling to be in that head space of like, "I'm screwing up. What can I fix?"

**中文翻译:**
如果你看过那部电影，你就知道（不剧透），他过这一天过得越来越好，这就是我们秉持的核心哲学。我觉得很多时候，当我过去思考“我如何才能有效地利用时间？我如何才能提高效率？”时，我其实是在自我折磨。那种“我搞砸了，我该怎么补救？”的心态感觉并不好。

---

### [00:31:49] Jake Knapp

**English:**
And this notion that it's like, you're going to have another chance, you're going to have another chance. "It's okay, just try again, just be curious about what happened," is a big deal. And starting with the calendar, using the calendar as a framework for saying, "Hey, here's what actually happened. Here's what I think is going to happen." That's what you're saying when you do this Design your Day tactic.

**中文翻译:**
而这种“你还有机会，你还有下一次机会”的想法非常重要。“没关系，再试一次，对发生的事情保持好奇”，这很有意义。从日历开始，把日历当作一个框架来表达：“嘿，这是实际发生的情况。这是我认为将会发生的情况。”这就是你在使用“设计你的一天”这个策略时所表达的。

---

### [00:32:12] Jake Knapp

**English:**
And I did this exercise earlier this week. I was switching to a new calendar thing, and trying some new features with... We invest in this company called Reclaim, and they do this stuff-

**中文翻译:**
本周早些时候我做了这个练习。我当时正在切换到一个新的日历工具，尝试一些新功能……我们投资了一家叫 Reclaim 的公司，他们就是做这个的……

---

### [00:32:26] Lenny

**English:**
I'm an investor in Reclaim also.

**中文翻译:**
我也是 Reclaim 的投资者。

---

### [00:32:27] Jake Knapp

**English:**
Oh, well.

**中文翻译:**
噢，好吧。

---

### [00:32:28] Lenny

**English:**
How about that? Not planned, this promotion.

**中文翻译:**
真巧啊？这可不是预先安排好的推广。

---

### [00:32:33] Jake Knapp

**English:**
Yeah, little [inaudible 00:32:36] there.

**中文翻译:**
是的，真是（听不清）。

---

### [00:32:37] John Zeratsky

**English:**
It sounds like we knew that, but we actually didn't know that. I didn't know that you-

**中文翻译:**
听起来好像我们早就知道，但其实我们并不知道。我不知道你……

---

### [00:32:37] Jake Knapp

**English:**
We did not know that.

**中文翻译:**
我们确实不知道。

---

### [00:32:41] Lenny

**English:**
How about that?

**中文翻译:**
真有意思。

---

### [00:32:41] Jake Knapp

**English:**
That was just discovered. So anyway, I was just looking at my calendar, and I was like, you know what? I'm going to do what John does. When I wake up, I'm going to schedule when I exercise, when I eat breakfast. I'm going to schedule when I take a shower, everything, and block it all out. When I walk and feed the dogs, everything's going to be on there, so that then I can have this idea, and when the day starts, I know there's slots for all those things. And then I've found this week that what I thought happened, how long I thought those things take, was not how long they take.

**中文翻译:**
刚刚才发现。总之，我当时看着我的日历，心想：你知道吗？我要像 John 那样做。当我醒来时，我要安排好什么时候运动，什么时候吃早餐。我要安排好什么时候洗澡，把所有事情都列出来，全部占位。什么时候遛狗喂狗，所有事情都要在上面。这样当我开始这一天时，我知道所有事情都有对应的时段。然后我这周发现，我以为发生的事情，以及我以为这些事情花费的时间，实际上并不是那样的。

---

### [00:33:20] Jake Knapp

**English:**
And so, set that thing to repeat every day and look at it, and then I'm like, "Oh, okay, interesting. That's not what happened." Okay, so I can adjust it. I can adjust the template and be a bit more kind to myself about this part, be a bit more kind to myself about that part. Gosh, the morning time wasn't a good focus time for me. I'll see if I can... Is there a way I can make that block happen in the afternoon? It's just a helpful way to track stuff and see it. Especially, I think a lot of people are visual learners. We can benefit from seeing things. It's not everybody, but a lot of us are in that camp. And when you put it on the calendar, you can see it, and that helps a lot.

**中文翻译:**
所以，把这些设置为每天重复，然后观察它。我会想：“噢，好吧，有趣。实际情况并非如此。”好，那我可以调整它。我可以调整模板，在这一部分对自己宽容一点，在那一部分也宽容一点。天哪，早上的时间对我来说并不是一个好的专注时间。我看看能不能……有没有办法把那个时间块挪到下午？这只是一种追踪和观察事物的有效方式。特别是，我觉得很多人是视觉型学习者。我们能从直观看到事物中获益。虽然不是所有人，但我们中很多人属于这一类。当你把它放在日历上，你能看见它，这很有帮助。

---

### [00:33:54] Lenny

**English:**
And also keeps someone else from booking that time. Double win.

**中文翻译:**
而且还能防止别人占用那个时间。双赢。

---

### [00:33:58] Jake Knapp

**English:**
Not to be undervalued, keeps someone else from booking that time. Right. And they look, they see, oh, okay, Lenny's already got stuff going on. I figured out, okay, I better be cautious before I ask for something. And that default, to be helpful to other people, and say yes when they put something on a free spot on your calendar, defeats a lot of our inner purposes.

**中文翻译:**
不可低估的一点是，它确实能防止别人预订那个时间。没错。他们一看，哦，好吧，Lenny 已经有安排了。我明白了，在找他办事之前我最好谨慎点。而那种“乐于助人”的默认心态——当别人在你日历的空档处塞进事情时你就说“好”——往往会挫败我们内心的很多目标。

---

### [00:34:20] Jake Knapp

**English:**
One core idea I don't think we've mentioned yet is that we strongly believe in people's intuition about how they should spend their time if they have the chance. What really is important. And that is true. We're talking about running this VC fund, or writing books, which are obviously very like, well, we're in charge of those things. But this is also true, we've been employees in big organizations, I also believe it's true that if you have a boss, and a boss's boss's boss, that you have great insight about what, if you had a window of time, would be the highest leverage thing for you to do. And it might not show up on your OKRs, it might not be on your boss's radar, your boss's boss's boss's boss's radar. You have great intuition, and we want to create space for you to do that thing because you're going to feel better about it, you're going to be more satisfied, and also good things are going to happen.

**中文翻译:**
我想我们还没提到的一个核心观点是：我们坚信，如果给人们机会，他们对于如何分配时间有着敏锐的直觉。什么才是真正重要的。这是事实。我们谈论的是经营风投基金或写书，这些显然是我们自己掌控的事情。但即使是在大型机构里当员工——我们也曾是——我也相信，即使你上面有老板，老板上面还有老板，你对于“如果有一段空闲时间，什么才是杠杆率最高的事”依然有着深刻的见解。这件事可能没出现在你的 OKR 上，可能不在你老板或老板的老板的关注范围内。但你有极佳的直觉，我们想为你腾出空间去做那件事，因为你会因此感觉更好，更有成就感，而且好事也会随之而来。

---

### [00:35:10] Lenny

**English:**
We're spending a lot of time on this highlight, but I think it's because it's so powerful. It's such a simple idea, but so effective. So, just to kind of give people tactical advice for how to actually implement this, just a couple things that I'll summarize. One is, to pick the highlight, you had a couple of questions I have here, for how to help you pick one for the day. So, you either ask which highlight will bring you the most satisfaction? Or, when I reflect on today, what will bring me the most joy? Maybe that's the same question. But I-

**中文翻译:**
我们在“高光”上花了很多时间，但我认为这是因为它太强大了。这是一个非常简单但极其有效的想法。为了给听众提供一些实际操作的建议，我总结几点。第一，关于如何选择高光，我这里有你们提到的几个问题，可以帮助大家做决定。你可以问：哪个高光会带给你最大的满足感？或者，当我回顾今天时，什么会带给我最大的快乐？也许这两个是同一个问题，但我……

---

### [00:35:39] Jake Knapp

**English:**
Slightly different, slightly different.

**中文翻译:**
略有不同，略有不同。

---

### [00:35:41] Lenny

**English:**
Slightly different. That's true. Okay, good.

**中文翻译:**
略有不同。确实。好。

---

### [00:35:43] Jake Knapp

**English:**
Satisfaction could be like, "I know this thing has to get done, and I got it done."

**中文翻译:**
满足感可能是：“我知道这件事必须完成，而我完成了它。”

---

### [00:35:47] Lenny

**English:**
Good point.

**中文翻译:**
说得对。

---

### [00:35:47] Jake Knapp

**English:**
Joy could be like, "Man, that was great." And they're in the same family, but they're cousins.

**中文翻译:**
快乐可能是：“天哪，那太棒了。”它们属于同一个家族，但它们是堂兄弟关系。

---

### [00:35:55] Lenny

**English:**
Great point, great point.

**中文翻译:**
非常有道理。

---

### [00:35:56] John Zeratsky

**English:**
Yeah. And I mentioned, a lot of my highlights, personally, are very much in the urgency or satisfaction camp. They're these big chunky projects. I got it done. I finished that deck. I finished writing that thing. But I also try to stay attuned to when I need something else in my day, when I need... I need some joy. I need some fun, some play. I need to prioritize going for a run, or going for a walk, or cooking a big dinner. And so, I trust my gut on those things, and I say, "Okay, what's most important to me today is not to be productive, but to do something else."

**中文翻译:**
是的。我提到过，我个人的很多高光都属于“紧急”或“满足感”阵营。它们是那些大块的项目。我搞定了。我做完了那个 PPT。我写完了那篇文章。但我也试着保持敏锐，察觉我什么时候在一天中需要别的东西，什么时候需要……快乐。我需要一些乐趣，一些玩耍。我需要优先考虑去跑步、散步或做一顿丰盛的晚餐。所以，在这些事情上我信任我的直觉，我会说：“好吧，今天对我来说最重要的不是提高效率，而是做点别的。”

---

### [00:36:39] John Zeratsky

**English:**
And sometimes that's the best highlight for me. For other people, maybe that's their highlight every single day. Maybe they work as a... I don't know, I've talked to a lot of people who work in healthcare settings about this. They're a nurse or a doctor, and when they're at work, they're at work. They're not bouncing around between meetings and emails and Zooms. They're on their feet. There's no time to do anything else. So, their highlight is probably something they need to do at the end of the day to unwind, or take care of themselves.

**中文翻译:**
有时那对我来说就是最好的高光。对其他人来说，也许那是他们每一天的高光。也许他们的工作是……我不知道，我曾和很多在医疗行业工作的人聊过这个。他们是护士或医生，上班时就是全身心投入工作。他们不会在会议、邮件和 Zoom 之间跳来跳去。他们一直站着干活，没时间做别的。所以，他们的高光可能是下班后为了放松或照顾自己而做的一件事。

---

### [00:37:11] John Zeratsky

**English:**
So, you have these three different strategies that we talk about, urgency, satisfaction, and joy, as being three different places you can look for the right highlight for you each day. But ultimately, I think it comes down to just trusting your gut and sort of asking yourself, like you said, "What do I want to look back on and have said, yeah, I'm glad I made time for that"?

**中文翻译:**
所以，我们讨论了这三种不同的策略：紧急性、满足感和快乐。这是你每天寻找合适高光的三个不同切入点。但最终，我认为这归结为信任你的直觉，并像你说的，问问自己：“我希望回顾这一天时能说，‘是的，我很高兴我为那件事腾出了时间’？”

---

### [00:37:33] Lenny

**English:**
Awesome. So, you touched on the third. So, it's basically, what would give you the most satisfaction? So, in the morning, you essentially ask, or the night before. I think one of you, I forget, because when I was listening to the audiobook, I don't know who's talking. But one of you is like, "I like to do it the day before." Is that right?

**中文翻译:**
太棒了。你提到了第三点。所以基本上是：什么会给你带来最大的满足感？在早上，或者前一天晚上，你基本上会问这个问题。我忘了是你们中的哪一位——因为听音频书时我分不清谁在说话——但其中一位说：“我喜欢在前一天做这件事。”对吗？

---

### [00:37:48] John Zeratsky

**English:**
Yeah, that's me.

**中文翻译:**
是的，那是我。

---

### [00:37:50] Lenny

**English:**
Okay. Okay.

**中文翻译:**
好的。

---

### [00:37:51] Jake Knapp

**English:**
That's John talking.

**中文翻译:**
那是 John 在说话。

---

### [00:37:52] Lenny

**English:**
Okay. So, the questions you asked either the night before or in the morning are, "What would give me the most satisfaction today, or the next day? What would give me the most joy? Or what's the most pressing thing that I need to get done?" So, you do that, and then the advice is either write it on a Post-It... I actually bought these tiny little Post-Its by accident. I was trying to buy regular Post-Its, and they're actually really great for this specific use case, so it's perfect. Write your highlight, stick it on the monitor.

**中文翻译:**
好的。所以你在前一天晚上或当天早上问的问题是：“今天（或明天）什么会给我带来最大的满足感？什么会给我带来最大的快乐？或者，我需要完成的最紧迫的事情是什么？”你问完之后，建议是把它写在便签纸上……我其实不小心买了一些超小的便签纸，本来想买常规尺寸的，结果发现它们在这个场景下特别好用，简直完美。写下你的高光，贴在显示器上。

---

### [00:38:17] Lenny

**English:**
So, that's one way of doing it. The other is stick it in your calendar, where you have focus time. In theory, it's like every day, here's my focus time, where you have the most energy. Is that the general advice?

**中文翻译:**
这是一种方法。另一种是把它放进你的日历里，放在你的“专注时间”段。理论上，就像每天都有一个“这是我的专注时间”，也就是你精力最充沛的时候。这是普遍的建议吗？

---

### [00:38:28] John Zeratsky

**English:**
Generally, although I think that that's probably more important for a certain kind of highlight. I have focused time most mornings. To be really specific and nerdy about it, Monday, Wednesday and Thursday mornings I have focus time. Tuesday and Friday mornings I have meetings. But on a Thursday night, my highlight might actually be to have friends over and cook dinner. And that's not the same as focus time, but it's this pressure release valve where I'm like, "That's the thing that I want to make sure..." I want to make sure I wrap up email at 5 so that have time to get everything ready, but it's not necessarily that peak energy moment in the way that we might think about being productive or getting things done or getting into that flow state.

**中文翻译:**
通常是这样，但我认为这对于某种特定类型的高光可能更重要。我大多数早晨都有专注时间。具体且死板一点说，周一、周三和周四早晨是我的专注时间，周二和周五早晨我有会议。但在周四晚上，我的高光可能其实是请朋友来家里吃晚饭。这和专注时间不一样，但它是一个压力释放阀，我会想：“这是我想确保完成的事……”我想确保在 5 点结束邮件处理，这样就有时间准备一切。但这并不一定是传统意义上提高效率、完成任务或进入心流状态的那种“巅峰精力时刻”。

---

### [00:39:22] Jake Knapp

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:39:22] Lenny

**English:**
So, there's a lot of ways to do it. So, maybe you just take away, if you're listening to this, is just think about what could be your highlight for today or tomorrow?

**中文翻译:**
所以有很多实现方法。也许听众可以带走的一点就是：思考一下你今天或明天的高光可能是什么？

---

### [00:39:30] John Zeratsky

**English:**
Yeah. And I would say, go one step further and make sure to write it down. Don't just think about it, because there's something really special that happens when you write things down, even if it's on a sticky. Even if it's in your notebook, your journal, even if it's a note on your phone. Take that step as well.

**中文翻译:**
是的。我想补充一点：更进一步，一定要把它写下来。不要只是在脑子里想，因为当你把事情写下来时，会发生一些奇妙的变化，哪怕是写在便签纸上、笔记本里、日记本里，甚至是手机的备忘录里。也要迈出这一步。

---

### [00:39:50] Jake Knapp

**English:**
Even if you don't see it again, just writing it down is a big deal.

**中文翻译:**
即使你之后再也没看过它，仅仅是写下来这个动作本身就很有意义。

---

### [00:39:55] John Zeratsky

**English:**
Yeah, that's a really important point.

**中文翻译:**
是的，这一点非常重要。

---

### [00:39:56] Jake Knapp

**English:**
I can give you a concrete example of a highlight, and a failed highlight, from yesterday, actually. And so, most days these days, my highlight is around making progress on the book. John alluded to working on a book, and so obviously it's a huge project. I heard it said that if you are writing books, it's like having homework forever. You always feel like there's always more to do. And so, that's mostly been my highlight.

**中文翻译:**
我可以给你们举一个具体的例子，关于昨天的“高光”以及一个“失败的高光”。最近大多数时候，我的高光都是关于写书的进展。John 提到过我们在写一本新书，显然这是一个巨大的项目。我听人说过，写书就像有永远做不完的作业。你总觉得还有更多事情要做。所以，这通常是我的高光。

---

### [00:40:24] Jake Knapp

**English:**
But yesterday, I wanted to prepare for this podcast. I knew that was going to be satisfying, to feel like I was ready. We don't think about talking about Make Time all the time, like we said, it's sort of like a side project for us. So, I wanted to be ready and somewhat coherent. And I knew I'd be satisfied, but I also knew it was urgent. We're going to be doing the recording today. So, that was my highlight. Write that down. "Get ready for podcast."

**中文翻译:**
但昨天，我想为这次播客做准备。我知道如果觉得自己准备好了，会很有成就感。我们并不总是谈论《时间管理术》，就像我们说的，它对我们来说有点像副业。所以我希望能准备充分，表达清晰。我知道这会让我满足，我也知道这很紧急，因为我们今天就要录音。所以，那是我的高光。写下来：“为播客做准备”。

---

### [00:40:50] Jake Knapp

**English:**
And I had two focus blocks, one in the morning, one in the afternoon. It should be easy. Focus block number one, kind of just didn't do a good job. I was distracted, I was in my email, I was doing everything that I would say you shouldn't do, I was doing. Feeling down on myself. I've become a loser. I didn't get anything done.

**中文翻译:**
我安排了两个专注时段，一个在上午，一个在下午。这本该很容易。第一个专注时段，我做得并不好。我分心了，我在看邮件，我做了所有我认为不该做的事。我感到很沮丧。我觉得自己像个失败者，什么都没干成。

---

### [00:41:10] Jake Knapp

**English:**
Okay, second focus block. Man, now the pressure's on. I got to do it. And so, I finally get into the zone. And my wife thinks I have a pretty serious case of undiagnosed ADHD, so a lot of it is just, if I really do have a deadline, then I really will click in. So, now I have a deadline. I'm doing it, and I'm making notes, and getting there, but I feel like there's still a ways to go.

**中文翻译:**
好，第二个专注时段。天哪，压力来了，我必须得做了。于是，我终于进入了状态。我妻子觉得我有严重的未经诊断的 ADHD（多动症），所以很多时候，如果我真的有一个截止日期，我才会真正进入状态。现在截止日期就在眼前，我正在做，记笔记，渐入佳境，但我感觉还有很长一段路要走。

---

### [00:41:32] Jake Knapp

**English:**
And my 12-year-old son bursts into the room, and it was, "Oh gosh, you're invading me right when I'm at peak focus." And he is like, "Hey, I'm going to do one more trip outside to sled in the snow. Do you want to come?" And I'm like, first reaction, "No, absolutely not. I can get this thing done. It's my highlight. This is the one thing I need to do today. I can do it max level of quality if I can just stay in this precious zone of focus."

**中文翻译:**
这时，我 12 岁的儿子冲进房间，我心想：“噢天哪，你偏偏在我注意力最集中的时候闯进来。”他说：“嘿，我要再去外面滑一次雪橇，你想来吗？”我的第一反应是：“不，绝对不行。我得把这件事做完。这是我的高光。这是我今天唯一需要做的事。如果我能保持在这个宝贵的专注区，我就能以最高质量完成它。”

---

### [00:42:02] Jake Knapp

**English:**
But then I was like, "Wait a second, what's really going to be the highlight of my day? What's really going to be the highlight, the thing that I might actually remember in the future?" We rarely get snow here. I live on this island in Washington state. We maybe get significant snowfall once every two years. We've only lived here for a few years. He's 12. He loves snow more than anything in the world. He loves snow. But he grew up in California, so he hasn't had many days, and he's 12. He's on the cusp of being a teenager. There's not, maybe, any more days in his life that he's going to want me to get on the sled with him and wrap my arms around him and go down the hill.

**中文翻译:**
但接着我转念一想：“等等，今天真正的‘高光’会是什么？什么是未来我真正会记住的高光？”我们这里很少下雪。我住在华盛顿州的一个岛上，大概每两年才下一次大雪。我们才搬来几年。他 12 岁了，他比世界上任何东西都更爱雪。但他是在加州长大的，所以没见过多少雪天。他 12 岁了，正处于成为青少年的边缘。也许在他未来的生命中，再也没有哪一天他会想让我和他一起坐上雪橇，搂着他一起冲下山坡了。

---

### [00:42:38] Jake Knapp

**English:**
I was like, "I got to get out there." So, okay. Pause this, ran outside. We did it. And man, it was magical. And I didn't know we were going to get one more in, because the snow was supposed to be melting already. We went down the hill, we went down the hill, we went... It got dark, we had to stop. But it was so magic. And I remember the very last end of the sled run, and it's like the last one, and he's like, "Man," he's like, "That was a great last sled run. So glad we did it."

**中文翻译:**
我想：“我得出去。”所以，好，暂停工作，跑向室外。我们去滑雪了。天哪，那太神奇了。我不知道我们还能再滑一次，因为雪本来应该已经开始融化了。我们一次又一次冲下山坡……直到天黑不得不停止。但那太奇妙了。我记得最后一次滑行结束时，那是最后一次，他说：“伙计，那是一次伟大的最后滑行。真高兴我们做了这件事。”

---

### [00:43:10] Jake Knapp

**English:**
And I was like, "Yeah, so glad we did it. It's great." Come back inside, 15 minutes. I try to hustle and get this done. So, I was like, maybe it was like 80% or 75% to where I wanted to be on this. I couldn't check off that highlight as being the most important thing. But because of the framing of, it might be wrong, what am I going to remember, all this stuff, it just felt natural to me to switch modes and say, "Oh my god, that actually is a highlight. That's this thing that's going to be really, really precious. That's where the joy and the satisfaction are most for today."

**中文翻译:**
我说：“是的，真高兴我们做了。太棒了。”回到屋里，花了 15 分钟，我试着赶紧把工作做完。所以，我大概只完成了预定目标的 80% 或 75%。我没能把那个“高光”标记为已完成。但因为那种思维框架——“我可能会选错高光”、“我未来会记住什么”——对我来说，切换模式并说“天哪，这才是真正的高光，这才是真正珍贵的东西，这才是今天快乐和满足感的源泉”是非常自然的。

---

### [00:43:47] Jake Knapp

**English:**
And still, because I had written down the other thing, I still did it instead of churning on email the entire day. But I screwed up twice, but it still turned out pretty good. So, anyway, that's kind of what it can look like at its best. And a lot of times, it doesn't make that much sense, and a lot of times I miss the special moments, or I miss the key work moments, or the key time when I could have gotten the most done. But I just feel better about it, which is a lot of what this is about. I just feel better about it because I feel more intentional.

**中文翻译:**
而且，因为我写下了另一件事（准备播客），我还是去做了，而不是整天陷在邮件里。虽然我搞砸了两次，但结果依然很不错。总之，这就是它在理想状态下的样子。很多时候，它并没那么有条理，很多时候我会错过特别的时刻，或者错过关键的工作时刻，或者错过效率最高的时间段。但我感觉更好了，这正是这本书的核心意义所在。我感觉更好了，因为我觉得生活更有目的性了。

---

### [00:44:17] Lenny

**English:**
Well, thank you for sharing the real talk. I think you made the right choice. I feel bad for having you have to decide between your kid and this podcast.

**中文翻译:**
谢谢你分享这些真心话。我觉得你做了正确的选择。让你在孩子和这个播客之间做选择，我感到挺过意不去的。

---

### [00:44:24] Jake Knapp

**English:**
You didn't have anything to do with it. No, no, no. I just wanted to... It's selfish for me to want to be prepared. I just want to look good. I just want to sound like I know what I'm talking about.

**中文翻译:**
这跟你没关系。不不不，我只是想……我想准备充分其实是出于自私。我只是想表现得好一点，听起来像个内行。

---

### [00:44:32] Lenny

**English:**
Well, it's working out. It all worked out. That's a great story. It reminds me, in your book at some point, I forget who it was of you that had to... You're like, "Here's my priorities in my life right now." And it was like family, writing, Make Time, something else, and then you're like, "Okay, actually Make Time is more important right now than my family," because you just have to get this done, and I wonder if this is a counter.

**中文翻译:**
嗯，效果很好，一切都很顺利。这是一个很棒的故事。这让我想起在你们书里的某个地方，我忘了是你们中的哪位……你说：“这是我目前生活中的优先级。”顺序是家庭、写作、《时间管理术》等等，然后你说：“好吧，实际上现在《时间管理术》比我的家庭更重要”，因为你必须完成它。我在想这是否是一个反例。

---

### [00:44:51] Jake Knapp

**English:**
Well, yeah. I mean, I think that part of what people have found useful about Make Time is that John and I come at this from different perspectives. And I have kids. I have a twelve-year-old and a twenty-year-old, sons, and dealing with being a dad is a big part of how I try to figure out how to make sense of what to do. And John doesn't have kids, and so he has it easy. No, he doesn't, but that's just a different frame of mind. And I think sometimes I read something that people without kids wrote, and I think, "Well yeah, sure. I am sure that's wonderful for you, but what about X-Y-Z?"

**中文翻译:**
嗯，是的。我的意思是，我觉得人们发现《时间管理术》有用的部分原因在于我和 John 是从不同的视角出发的。我有孩子，我有 12 岁和 20 岁的儿子，作为一个父亲，如何平衡生活是我试图弄清楚该做什么的重要部分。而 John 没有孩子，所以他过得很轻松。不，他并不轻松，但那是完全不同的心态。有时我读到没孩子的人写的东西，我会想：“好吧，当然，我确定那对你来说很棒，但如果遇到 X、Y、Z 这种情况呢？”

---

### [00:45:34] Jake Knapp

**English:**
And although, I'm sure a lot of people who have more kids, or when they have young kids, it would... But that's a real part of it. And whether it's your family, your significant other, anything that's going on in your life that's not part of your work, there are times when you, on a day, or in a moment, you have to shift those priorities. And it can help to just be this idea of stack-ranking things, and being clear about it, can help you just come to terms with it. "I'm making that decision right now. It makes sense to make right now." Or at least, I can see that I did it, and if it seems like I screwed it up, I'd flip it back. I know where it happened. A lot of this is just like if you were designing a product or writing code or whatever, you can see that's where the bug happened. I'll just try to fix that line.

**中文翻译:**
虽然我确信很多有更多孩子或孩子还小的人会……但那是真实生活的一部分。无论是你的家庭、你的伴侣，还是生活中任何非工作的事情，总有些时候，在某一天或某一刻，你必须调整这些优先级。这种“堆栈排名”并保持清晰的想法可以帮助你接受现实。“我现在做出了那个决定，在当下是有意义的。”或者至少，我能看到我这么做了，如果看起来我搞砸了，我会把它调回来。我知道问题出在哪。这很像设计产品或写代码，你能看到 Bug 出在哪，然后试着修复那行代码。

---

### [00:46:14] Lenny

**English:**
Yeah. I love how real you're getting, and it also reminds me of... We just had a kid. He's seven months old, so I'm going through a lot.

**中文翻译:**
是的。我喜欢你这么坦诚，这也让我想起……我们刚有了个孩子，七个月大，所以我正经历很多。

---

### [00:46:30] Jake Knapp

**English:**
Oh, congratulations.

**中文翻译:**
噢，恭喜。

---

### [00:46:31] Lenny

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:46:31] Jake Knapp

**English:**
That's busy times. Seven months old is busy times.

**中文翻译:**
那可是段忙碌的时光。七个月大正是最忙的时候。

---

### [00:46:34] Lenny

**English:**
Yeah, that's great.

**中文翻译:**
是的，很棒。

---

### [00:46:34] Jake Knapp

**English:**
People always told me, told us, when we had kids when they were babies. They're always like, "Oh, just you wait." I just feel like this is a thing that people want to tell other parents. "Just you wait until this happens." And then one person said, "You know what? Generally speaking, it gets easier and easier and easier. Every month, every week, generally speaking, it gets easier." And I think that is true, so just keep that in mind if you're ever feeling like it's overwhelming.

**中文翻译:**
当我们有孩子、他们还是婴儿时，人们总是告诉我们：“噢，你等着瞧吧。”我觉得这是人们总想对其他父母说的话。“等这件事发生时你等着瞧吧。”然后有一个人说：“你知道吗？通常来说，事情会变得越来越容易。每个月、每一周，通常来说都会变得更容易。”我认为那是真的，所以如果你感到不堪重负，请记住这一点。

---

### [00:46:59] Lenny

**English:**
No, I think that is true. I've experienced that. It also gets more amazing. That's what I'm finding, too.

**中文翻译:**
不，我觉得那是真的。我已经体会到了。而且它也会变得越来越奇妙。这也是我的发现。

---

### [00:47:03] Jake Knapp

**English:**
Yeah, yeah.

**中文翻译:**
是的，没错。

---

### [00:47:05] Lenny (Sponsor: WorkOS)

**English:**
This episode is brought to you by Work OS. If you're building a SASS app, at some point your customers will start asking for enterprise features, like SAML authentication and skim provisioning. That's where Work OS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand, so that you can ship quickly and get back to building other features. And hundreds of other companies are already powered by Work OS, including ones you probably know, like Vercel, Webflow, and Loom.

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，你的客户迟早会开始要求企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让你快速且无痛地为应用添加企业级功能。他们的 API 易于理解，让你能快速交付并重新投入到其他功能的开发中。数百家公司已经由 WorkOS 提供支持，包括你可能熟悉的 Vercel、Webflow 和 Loom。

---

### [00:47:35] Lenny (Sponsor: WorkOS)

**English:**
Work OS also recently launched AuthKit, a complete authentication and user management service. It's essentially a modern alternative to OP Zero, but with better pricing and more flexible APIs. AuthKit's design is stunning out of the box, and you can also fully customize it to fit your app's brand. It's an effortless experience from your first user all the way to your largest enterprise customer. Best of all, AuthKit is free for any developer up to 1 million users. Check it out at work-

**中文翻译:**
WorkOS 最近还推出了 AuthKit，这是一项完整的身份验证和用户管理服务。它本质上是 Auth0 的现代替代方案，但价格更优，API 更灵活。AuthKit 的设计开箱即用，非常精美，你也可以完全自定义它以符合你的应用品牌。从第一个用户到最大的企业客户，它都能提供轻松的体验。最棒的是，AuthKit 对任何开发者免费，支持多达 100 万用户。访问 work-

---

### [00:48:00] Lenny

**English:**
... for any developer up to 1 million users. Check it out at workos.com to learn more. That's workos.com. I want to talk about the next bucket that, you call it laser, you could also think of it as just how to focus better, and this is where most of the very tactical tips for how to avoid getting distracted are. So what I think might be helpful here is let's just do a rapid fire through as your favorite tactical tips to help people stay focused, and the ones that you actually do and find most helpful, I think it's like six years later now since you published the book, the better. So let's go through some stuff here.

**中文翻译:**
……对任何开发者免费，支持多达 100 万用户。访问 workos.com 了解更多信息。我想聊聊下一个板块，你们称之为“激光专注”（Laser），也可以理解为如何更好地集中注意力。这里包含了大部分关于如何避免分心的实战技巧。我觉得这里比较有效的方式是：快速过一遍你们最喜欢的专注技巧，尤其是那些你们现在依然在用、觉得最有用的技巧——毕竟距离书出版已经过去六年了。让我们来看看这些内容。

---

### [00:48:37] John Zeratsky

**English:**
Yeah, the basic principle with laser is that willpower is never going to win, and there's great research on this, but for now just trust me, you're not going to white-knuckle your way through not looking at Twitter when you're trying to work. So it's all about making it hard, creating barriers to getting distracted. So a few things for me, I'm not on Instagram and I'm not on Facebook. I was on both of those things and I left both of them, I disabled my accounts. I am on Twitter and LinkedIn, but I don't have either of those apps installed on my phone. I stay logged out of those sites on my computer, except for when I want to use them for some specific purpose.

**中文翻译:**
是的，“激光专注”的基本原则是：意志力永远赢不了。关于这一点有很多伟大的研究，但现在请相信我，当你试图工作时，你不可能靠硬撑着不去刷 Twitter。所以，关键在于增加难度，为分心设置障碍。对我来说有几件事：我不用 Instagram，也不用 Facebook。我以前用，但后来注销了账号。我用 Twitter 和 LinkedIn，但我手机上没装这两个 App。在电脑上，我也保持退出登录状态，除非我为了特定目的需要使用它们。

---

### [00:49:22] John Zeratsky

**English:**
LinkedIn I need to use all the time, because I'm a VC and I have to look people up and stuff, so I found this Chrome plugin, or Chrome extension, I guess is the right word, that disables the feed in LinkedIn. So when I go to LinkedIn.com, it's the search bar at the top but there's no feed, which is amazing because I can use LinkedIn as the phone book and then not get distracted. So those are some of the very, very concrete specific things that I do, all, again, with the goal of putting a speed bump between me and that thing so that if I go, and I don't do this much anymore but I used to, literally my hands on the keyboard would just be like, T-W-I, like Twitter.com, and then you see that log in screen instead of my juicy feed and I'm like, oh yeah, right, okay, I did that on purpose, great, I broke that feedback loop a little bit.

**中文翻译:**
我需要经常用 LinkedIn，因为我是 VC，得查人名什么的。所以我发现了一个 Chrome 插件（或者叫扩展程序），它可以禁用 LinkedIn 的动态消息（Feed）。所以当我访问 LinkedIn.com 时，顶部只有搜索栏，没有动态消息。这太棒了，因为我可以把 LinkedIn 当作电话簿用，而不会分心。这些都是我做的非常具体的事情，目的只有一个：在我与诱惑之间设置一个“减速带”。这样如果我下意识地去访问——我现在不怎么这样了，但以前会——我的手在键盘上敲下 T-W-I（Twitter.com），然后看到的是登录界面而不是诱人的动态消息，我就会想：“噢对，我是故意这么做的，太好了。”这样我就打破了那个反馈回路。

---

### [00:50:18] Lenny

**English:**
I did a similar thing with Twitter/X, where I deleted the app and I just used the mobile website. I think this point of logging out is really powerful, I think people haven't heard that idea as much, because it's not like you can't log in really easily, you just click a couple things and you're back. But to your point, it reminds you, okay, I see, I really shouldn't have done this.

**中文翻译:**
我对 Twitter/X 也做了类似的事：删了 App，只用移动端网页版。我觉得“退出登录”这一点非常强大，我想人们可能没怎么听过这个主意。因为并不是说你不能轻松登录，点几下就回来了。但正如你所说，它提醒了你：“好吧，我明白了，我真的不该这么做。”

---

### [00:50:37] John Zeratsky

**English:**
Well, I also signed up for two-factor authentication for everything, not because I care about somebody hacking my account, but because it's another speed bump. Because that way, even if your browser remembers your password, or I use one password, so even if the browser extension is going to fill it in for me, there's still another step, so it's sort of reverse engineering my own distractibility.

**中文翻译:**
我还为所有账号开启了双重身份验证（2FA），不是因为我担心有人盗号，而是因为它是另一个“减速带”。这样即使浏览器记住了密码，或者我用 1Password 自动填充，也还有一个步骤。这算是在逆向工程我自己的易分心体质。

---

### [00:51:03] Lenny

**English:**
That feature that everyone's always talking about that Apple built of the code being automatically there in the keyboard, that's counter to this friction that you've created.

**中文翻译:**
大家一直在聊的 Apple 那个功能——验证码自动出现在键盘上方——正好抵消了你创造的这种阻力。

---

### [00:51:11] John Zeratsky

**English:**
Yeah, yeah, that's true.

**中文翻译:**
是的，没错。

---

### [00:51:12] Lenny

**English:**
Okay, so it's interesting is I had this, and then I just like, goddammit I really just want to be on Twitter. And so I just re-installed it again recently, and I need to fight that again.

**中文翻译:**
好，有趣的是我也试过这些，然后我就想：“该死，我真的好想刷 Twitter。”所以我最近又把它装回来了，我得再次和它作斗争。

---

### [00:51:22] John Zeratsky

**English:**
Well, I go through cycles like that too, and I go through that a lot with email. Jake, you still don't have email on your phone, is that right?

**中文翻译:**
我也经历过这种周期，尤其是电子邮件。Jake，你手机上还是没装邮件 App，对吧？

---

### [00:51:33] Jake Knapp

**English:**
No, I would be on the floor checking email right now on this call if I did, on the floor.

**中文翻译:**
没装。如果装了，我现在录播客的时候肯定已经趴在地上回邮件了，真的。

---

### [00:51:38] John Zeratsky

**English:**
I used to do that, Jake inspired me a long time ago to remove email from my phone, and so for years and years that's been my default. But more recently I've had more reasons to install it, mostly related to travel, if I'm on the go and I just want to stay on top of things. And something that Jake and I have talked about a lot is you go through these different cycles of, hey, I need this thing, or I want this thing, and then part of the reflect step, part of paying attention and reflecting on how it's going is to recognize, oh wow, I've actually been spending a lot of time on email on my phone, or a lot of time on Twitter, maybe I'll just uninstall it for a while. Maybe I'll just reset and do that for a while. And then there'll be some other thing that happens that causes you to reinstall it, and that's totally fine, because you're being deliberate about it and you're paying attention, rather than saying it has to always be this way forever and it's set in stone.

**中文翻译:**
我以前也那样。很久以前 Jake 启发我删掉了手机里的邮件，所以多年来这一直是我的默认状态。但最近我有更多理由安装它，主要是因为旅行，如果我在路上，我想掌握情况。我和 Jake 经常聊到的一点是，你会经历不同的周期：嘿，我需要这个，或者我想要这个。然后作为“反思”步骤的一部分，观察并反思进展如何，你会意识到：“噢哇，我最近在手机邮件上花了太多时间，或者在 Twitter 上花了太多时间，也许我该卸载一段时间。”也许我会重置一下，坚持一段时间。然后又会发生别的事让你重新安装，这完全没问题，因为你是经过深思熟虑的，你在关注自己的行为，而不是说“必须永远这样，一成不变”。

---

### [00:52:35] Lenny

**English:**
That's a great tip of just coming back to it, not feeling like you're defeated, it's like, all right, let's try this again.

**中文翻译:**
这是一个很好的建议：重新审视它，不要觉得被挫败了，而是想“好吧，让我们再试一次”。

---

### [00:52:40] Jake Knapp

**English:**
Yeah, I think a big part of it is if you can experience the feeling of not having it on your phone. Like I'm old enough to have lived in a world building products where there were no smartphones, and we got a lot done back then, things happened. I mean, for God's sake, they designed the first iPhone without being able to use iPhones while they did it, you can do a lot. So this idea that we have to have it or everything's going to fall apart, that's just not true for 99.99999% of everyone.

**中文翻译:**
是的，我觉得很大一部分在于你能否体验到手机里没有这些东西的感觉。我的年纪大到经历过那个没有智能手机但依然在打造产品的时代，那时候我们也完成了很多工作，事情照样运转。我的天，他们设计第一代 iPhone 的时候，自己还没法用 iPhone 呢，你能做成很多事。所以那种“必须拥有它否则一切都会崩溃”的想法，对 99.99999% 的人来说都不是真的。

---

### [00:53:16] Jake Knapp

**English:**
It's interesting to see what it feels like if you delete all of the infinity pools off of your phone, and this is something I did out of rage at myself in 2012. It was another situation where I was with my kids, who were much younger at the time, and I was spending time with them, we're playing wooden trains, and all of a sudden my son's like, "Dad, dad, dad, dad, dad," and I'm like, "God, what?" And I didn't even realize it but I was on my phone, and I don't even remember what I was doing, email or something, but I think I told him, he's like, "What's on your phone?" Because to him, he was like, we're doing something really fun, so if you're on your phone it must be something really cool, maybe it would be a cool thing to share, because this is great, so it must be another great thing. He wasn't trying to shame me or anything.

**中文翻译:**
如果你删掉手机里所有的“无尽内容池”，看看那是什么感觉，这很有趣。这是我在 2012 年因为对自己感到愤怒而做的一件事。当时我和孩子们在一起，他们还很小，我们在玩木头小火车。突然我儿子喊：“爸爸，爸爸，爸爸……”我说：“天哪，怎么了？”我甚至没意识到我当时正盯着手机，我不记得在干嘛，可能是邮件之类的。他问：“你手机里有什么？”因为对他来说，我们正在玩这么有趣的游戏，如果你在看手机，那里面一定有更酷的东西，也许可以分享一下。他并不是想让我难堪。

---

### [00:54:06] Jake Knapp

**English:**
And I was all defensive, I'm like, "Well, I need to do this for work," which was, I think, my internal monologue of why I was doing this thing that actually was just a really low-friction dopamine hit. And then I thought, God, this is not what I wanted, this is not why I worked so hard today so I would get done with my work so I could be home in time to do this before my kids go to bed. And I was like, screw this, so I just started deleting things on my phone, and I deleted email and I deleted Facebook and I deleted this, everything that had an infinity pool, everything that had an infinite amount of content. News is like this, anything streaming.

**中文翻译:**
我当时充满了防御性，我说：“额，我得处理工作。”我想那是我内心的独白，解释我为什么在做这件事，而实际上那只是一个极低门槛的多巴胺诱惑。然后我想，天哪，这不是我想要的，这不是我今天拼命工作的原因——我拼命工作是为了早点回家，在孩子睡觉前陪陪他们。于是我想，去他的，我开始删手机里的东西：删了邮件，删了 Facebook，删了一切有“无尽内容池”的东西，一切有无限内容的东西。新闻也是如此，任何流媒体也是。

---

### [00:54:44] Jake Knapp

**English:**
When we wrote this book, it came out in 2018, I think we said we thought it was going to get worse, and it has. But at that point in time there was really Netflix, and now there's all these streaming services. At that point in time there was Instagram and Facebook, but now there's TikTok, the best part of every video available instantly right here. This stuff, it only gets harder to resist. When you clear all that stuff off of your phone, it's painful, the idea of deleting all this stuff, and each time the phone's going to ask you, "This is going to delete all the data and settings, are you sure you want to do that?" It doesn't want you to. And when you do that though, what does that feel like? And it's usually a feeling of discomfort, but also relief that I don't have to check this, this thing, I don't have to check it, I don't have to.

**中文翻译:**
我们写这本书是在 2018 年出版的，当时我们说觉得情况会变得更糟，事实确实如此。那时只有 Netflix，现在到处是流媒体。那时只有 Instagram 和 Facebook，现在有了 TikTok，每个视频最精彩的部分都能立即呈现。这些东西只会越来越难抵挡。当你清空手机里的这些东西时，过程是痛苦的，删除所有这些东西的念头很折磨人，每次手机都会问你：“这将删除所有数据和设置，你确定吗？”它不想让你删。但当你真的这么做了，那是什么感觉？通常是一种不适感，但同时也有一种解脱感：我“不必”检查这个了，我“不必”检查它了。

---

### [00:55:34] Jake Knapp

**English:**
If you've ever felt like your phone was in the Lord of the Rings, how Bilbo, I guess, yeah, Lord of the Rings, they want to put their hand in their pocket and touch the ring, or put the ring on without even knowing it, Frodo's like, "I didn't even realize I did it." That's what this thing is like. And when you take those off, just that feeling of relief is, to me, so powerful, that having done this for a decade now, and yeah, there's exceptions, like I'm traveling, God, I have to check my email for X reason, and I install it and I check it. And then it automatically, because I'm aware of it, I'll just feel this static.

**中文翻译:**
如果你曾觉得你的手机就像《指环王》里的至尊魔戒——就像比尔博，或者弗罗多，他们会不自觉地把手伸进兜里摸戒指，或者在不知不觉中戴上它，弗罗多会说：“我甚至没意识到我做了。”手机就是这样的。当你把这些东西拿走，那种解脱感对我来说非常强大。我已经坚持了十年，当然也有例外，比如旅行时我必须为了某个原因查邮件，我会安装并查看。然后，因为我有了这种意识，我会立刻感觉到一种“静电干扰”。

---

### [00:56:11] Jake Knapp

**English:**
There's this notion of attention residue, and I think the researcher who coined this term is Sophie Leroy from the University of Washington. Anyway, you can look that up, I think I learned about that from Cal Newport. But this idea says, it makes a lot of sense, that you pay attention to some things and they just stick in your head and they create this static, those apps just create this static. The idea of email being on my phone and accessible at any time creates a discomfort, a disquiet that now that I've seen it and felt what it's like to not have it, I could not imagine experiencing it.

**中文翻译:**
有一个概念叫“注意力残留”（Attention Residue），我想提出这个词的研究员是华盛顿大学的 Sophie Leroy。总之，你可以查查，我是从 Cal Newport 那里学到的。这个观点很有道理：你关注了一些事情，它们就会留在你脑子里，产生这种“静电”。那些 App 就会产生这种静电。手机里有邮件且随时可以查看，这会产生一种不适和不安。既然我已经体验过没有它的感觉，我无法想象再去承受那种不安。

---

### [00:56:44] Jake Knapp

**English:**
You give some things up. You're not going to be as responsive. John and I don't have as many Twitter followers as we'd have if we used Twitter. There are these things that you look at other people, and I just saw a post on LinkedIn because I haven't used plug-in yet, but I looked on this post and it was a colleague that I used to have and she was saying, "Yeah, I posted a few tweets last year and a couple of them went viral and I gained 30,000 followers." And I was like, man, all I have is 30,000 followers, and that was from years and years ago, I thought I was a pretty big deal, oh jeez, maybe I should... And I was like, oh God, don't do it, because I know when I'm doing it, then I'll be thinking about it all the time and the attention residue will spoil my life.

**中文翻译:**
你确实会放弃一些东西。你的响应速度不会那么快。我和 John 的 Twitter 粉丝没有如果我们一直刷 Twitter 那么多。你会看着别人，我刚才在 LinkedIn 上看到一个帖子（因为我还没装那个插件），那是我以前的一位同事，她说：“是的，我去年发了几条推文，其中几条疯传，我涨了 3 万粉丝。”我想，天哪，我一共才 3 万粉丝，还是多年前攒下的，我以前还觉得自己挺牛的，哎呀，也许我该……然后我想，噢天哪，千万别做，因为我知道一旦我开始做，我就会一直想着它，那些“注意力残留”会毁了我的生活。

---

### [00:57:28] Jake Knapp

**English:**
So yeah, anyway, sorry, that's just a rant, but you should try it. The distraction-free phone thing is just worth trying, if you can take off everything, if not just try taking off the thing that's your kryptonite. What's the thing that is the hardest for you to resist, sucks your attention the most, makes you feel not good? Take it off for, try it for a day, or try it for two hours, just to feel that feeling. And then once you've felt the feeling you'll always know, I could release that, and I think that's powerful.

**中文翻译:**
所以，抱歉，这只是我的吐槽，但你真的应该试试。打造一部“无干扰手机”是值得尝试的。如果你不能删掉所有东西，那就试着删掉那个你的“氪金石”（致命弱点）。什么是你最难抗拒、最吸注意力、让你感觉不好的东西？把它删掉，试一天，或者试两小时，仅仅为了体验那种感觉。一旦你体验过那种感觉，你就会明白：“我可以摆脱它。”我认为这很有力量。

---

### [00:57:57] Lenny

**English:**
And I think when you delete it, it's important to know nothing's being deleted when you're deleting the app, you can reinstall it, you log in, it's all the same.

**中文翻译:**
我觉得有一点很重要：当你删除 App 时，并没有删除任何数据。你可以重新安装，登录后一切照旧。

---

### [00:58:04] Jake Knapp

**English:**
It's all the same, that's an important point. They make it sound like, oh my God, this is a big deal. It's not.

**中文翻译:**
一切照旧，这一点很重要。系统提示听起来好像天要塌下来一样，其实不然。

---

### [00:58:09] Lenny

**English:**
Yeah, just have to remember your password or Google auth, or whatever you're using. This metaphor of The Lord of the Rings and the ring is so good for how it feels to just say, I'm just going to check Twitter, what's the problem, I'm just going to check it again, I'll just check it, check it. That's so good. And then in Lord of the Rings, the way they resist the ring is they hide it, they put it somewhere else, they give it to Frodo to take it, right? That's the same solution, it's just like, I can't get access to it, it's over there.

**中文翻译:**
是的，你只需要记住密码或 Google 验证码之类的。那个《指环王》的隐喻太棒了，完美描述了那种“我就看一眼 Twitter，有什么大不了的，我再看一眼，看一眼，看一眼”的感觉。在《指环王》里，他们抵抗戒指的方法是把它藏起来，放在别处，交给弗罗多带走，对吧？这其实是同样的解决方案：我没法接触到它，它在别处。

---

### [00:58:36] Jake Knapp

**English:**
Right, right. Yeah, you got to be like Gandalf. Even if that ring would do great things for you, you got to give it to Frodo for a while, maybe show up at the end with an eagle.

**中文翻译:**
没错。你得像甘道夫一样。即使那枚戒指能为你做伟大的事，你也得把它交给弗罗多一段时间，也许最后骑着老鹰出现。

---

### [00:58:45] Lenny

**English:**
Just too eerie, yeah, yeah, the eagle.

**中文翻译:**
太神奇了，是的，老鹰。

---

### [00:58:46] Jake Knapp

**English:**
Scoop them up.

**中文翻译:**
把他们接走。

---

### [00:58:47] Lenny

**English:**
Yeah, oh man. So the key tips here are find the apps that are sucking your attention, could be Twitter, could be LinkedIn, could be your email, and delete them and/or log out of them. What else?

**中文翻译:**
天哪。所以这里的关键技巧是：找到那些吸走你注意力的 App，可能是 Twitter、LinkedIn 或邮件，删掉它们或者退出登录。还有别的吗？

---

### [00:59:00] John Zeratsky

**English:**
There's a few tactics that Jake and I both use that are related to TV, watching TV, and a really simple one, which is also kind of a luxury one, but I think there are ways to do it that are pretty universal, is just not having a TV in your main living space. Again, not having the default be like, I'm home, the TV is on, what are we watching? And so for me and my wife, that's always been the TV is just in a different room. And Jake, do you use a projector where if you want to watch something you have to get it out, set it up, and make a decision to watch something?

**中文翻译:**
我和 Jake 都在用一些关于看电视的策略。一个非常简单的方法（虽然有点奢侈，但我觉得有普适的方法）就是：不要在主生活空间放电视。同样，不要让默认状态变成“我回家了，电视开着，我们在看什么？”。对我妻子和我来说，电视一直放在另一个房间。Jake，你是不是用投影仪？如果你想看点什么，你得把它拿出来，架好，然后做一个“决定”去看。

---

### [00:59:40] Jake Knapp

**English:**
Yeah, so it's a bit of a project. And it doesn't take that long, but you definitely are not just click, and you don't see it when it's not set up. So we have a projection screen that's all folded up in the corner, and the projector's in a cabinet, so you got to get it out and get a chair and put it on there. If you're motivated enough you can do it, but it takes a few minutes.

**中文翻译:**
是的，这算是个小工程。虽然花不了太长时间，但你绝对没法随手一按就看，而且没架好时你也看不见它。我们有一个折叠在角落里的投影幕布，投影仪在柜子里，你得把它拿出来，找把椅子放好。如果你动力足够，你可以做到，但这需要几分钟时间。

---

### [01:00:06] Lenny

**English:**
You need an old-timey camera that you have to wind.

**中文翻译:**
你还需要一个得手摇上弦的老式摄像机。

---

### [01:00:06] Jake Knapp

**English:**
Yeah, right.

**中文翻译:**
哈哈，没错。

---

### [01:00:07] Lenny

**English:**
Someone has to sit there.

**中文翻译:**
还得有人坐在那儿。

---

### [01:00:11] John Zeratsky

**English:**
Here's another one that-

**中文翻译:**
还有一个方法……

---

### [01:00:13] Jake Knapp

**English:**
[inaudible 01:00:13] in the back.

**中文翻译:**
（听不清）在后面。

---

### [01:00:15] John Zeratsky

**English:**
Yeah, right. Another one that's really helpful for me that actually is sort of a bridge is the laser section and the energized section, because it relates to sleep, is I don't keep my phone in the bedroom. The phone doesn't come in the bedroom. And not only that, the place where it charges, the MagSafe little charging place for it, is downstairs. It's on a different floor, it's in the kitchen. So when I put that there at the end of the night and I go upstairs, I might still be awake for an hour, I might read, I might get ready for bed, all those things, but the phone is a way to make sure that the last thing I do each day is not on my phone. That's super helpful to me, and I think there's a bunch of ways, whether it's in a drawer or in a cabinet, there's a bunch of ways you can implement that tactic that I think could make a big difference.

**中文翻译:**
没错。另一个对我非常有帮助的方法，其实是连接“激光专注”和“保持活力”的桥梁，因为它与睡眠有关：我不把手机带进卧室。手机绝不进卧室。不仅如此，充电的地方（那个 MagSafe 充电座）在楼下。它在另一层楼，在厨房里。所以当我晚上把它放在那儿然后上楼时，我可能还会醒着一小时，我可能会看书，准备睡觉，但手机不在身边，这确保了我每天做的最后一件事不是刷手机。这对我有极大帮助。我觉得有很多方法可以实现这个策略，不管是放在抽屉里还是柜子里，都能产生巨大的影响。

---

### [01:01:07] Lenny

**English:**
My wife and I have been talking about that actually, but the issue is to watch our kid with the Nanit app we need our phone. I know that you can get other devices that aren't on the phone, but we just like the Nanit, and so we've stuck with that.

**中文翻译:**
我妻子和我其实一直在讨论这个，但问题是我们要用 Nanit App 监控孩子，这需要手机。我知道可以买非手机的监控设备，但我们就是喜欢 Nanit，所以一直坚持用它。

---

### [01:01:20] John Zeratsky

**English:**
Yeah, one tactic that's related to that that a lot of people have told us they've had success with, and not specifically with the Nanit app, but some people have said, "Oh, I can't uninstall those apps because," Twitter, LinkedIn, whatever, "because I do social media for my work. Literally my job is I do marketing at the company, I have to be on social media." So what some people will do is they'll have a separate device. So it's almost like the old days of your personal phone and your work phone, they'll just have a work device, like a work iPad, that those apps are only there, and when they're working they're on it, when they're not working they put it away. So you could have another device that's the Nanit device and that's all it does and it's in a nice little stand by the bed, that can create some separation as well.

**中文翻译:**
是的，有一个相关的策略，很多人告诉我们他们用得很成功。虽然不是专门针对 Nanit，但有些人说：“噢，我不能卸载那些 App，因为我的工作就是做社交媒体。我的工作是公司营销，我必须在社交媒体上。”所以有些人的做法是准备一个独立的设备。这有点像以前区分个人手机和工作手机，他们会有一个工作设备（比如工作 iPad），那些 App 只装在上面。工作时用它，不工作时就收起来。所以你可以准备另一个设备专门当 Nanit 监控器，它只干这一件事，放在床头的小架子上，这样也能创造出一种隔离感。

---

### [01:02:09] Lenny

**English:**
That's a great idea. I think there's a company, I think it was Arianna Huffington made a thing where it's a little bed for your phone, where you put it somewhere in the living room and you put it to bed and you charge it there and it's outside your room.

**中文翻译:**
好主意。我记得有一家公司，好像是 Arianna Huffington 创办的，做了一个给手机睡的小床。你把它放在客厅的某个地方，让它“上床睡觉”并在那儿充电，它就在你的房间外面。

---

### [01:02:21] John Zeratsky

**English:**
Yeah. There's a company, I can't think of the name right now, but I can look it up and send it to you, there's a company that makes a cool box that not only you put your phone in, it charges, but it has some sort of way of, it interacts with the phone, it puts it into Do Not Disturb, or there's some cool integration that it does. So yeah, those things are a little bit gimmicky, but if it helps you create that default, I think it's worth it.

**中文翻译:**
是的。有一家公司，我现在想不起名字了，但我可以查一下发给你。他们做了一个很酷的盒子，你把手机放进去不仅能充电，它还能以某种方式与手机交互，让它进入“请勿打扰”模式，或者有一些很酷的集成功能。虽然这些东西有点像噱头，但如果它能帮你建立那种默认习惯，我觉得就值得。

---

### [01:02:48] Lenny

**English:**
Here's the trick my wife wanted to share with you guys as she was reading the book, she's like, "Tell them about this thing that we've been doing," which is with TikTok. She doesn't install the app, and she basically relies on me to send her TikTok videos I like to her account, which she then checks on my phone.

**中文翻译:**
这是我妻子在读你们书时想分享给你们的一个窍门。她说：“告诉他们我们一直在做的这件事”，是关于 TikTok 的。她不装这个 App，她基本上依赖我把喜欢的 TikTok 视频发到她的账号，然后她在“我的”手机上查看。

---

### [01:03:04] Jake Knapp

**English:**
You're Frodo.

**中文翻译:**
你是弗罗多。

---

### [01:03:05] Lenny

**English:**
Yeah, yeah, I'm holding the TikTok, my precious. And so the trick there, there's two wins, one is she only sees the best stuff. She respects my taste of videos to watch. And then two is I'm always like, "Give me my phone back," and so there's limited time where she can watch them, and that keeps her from getting addicted to TikTok.

**中文翻译:**
是的，我拿着 TikTok，我的“宝贝”。这个窍门有两个好处：第一，她只看最精彩的内容，她尊重我的视频品味；第二，我总是会说“把手机还给我”，所以她看视频的时间有限，这防止了她沉迷 TikTok。

---

### [01:03:27] John Zeratsky

**English:**
Yeah. My wife and I have a similar dynamic, but in reverse and with news. I spend very little time reading the news, and I don't have any news apps on my phone, but my wife's pretty into the news. She has a healthcare background and she studied journalism in school, so she loves particularly those two topics in the intersection of those two. And so she gives me a news digest. When we're chatting at the end of the day, or when we're doing something together, she'll just, it's not structured, it's not some official thing, but she just shares what she was reading about that day. It's nice, it gives us something to talk about, I think it suits both of our styles and our preferences. It's good for her, it's good for me, so it's fun to think about how you can implement some of these ideas in a relationship as well.

**中文翻译:**
是的。我和我妻子也有类似的互动，但情况相反，是关于新闻的。我很少花时间看新闻，手机里也没装新闻 App，但我妻子很喜欢看新闻。她有医疗背景，在学校学过新闻学，所以她特别喜欢这两个领域的交叉内容。于是她会给我做一个“新闻摘要”。当我们一天结束聊天或一起做事时，她会分享她那天读到的内容。这很随意，不是什么正式的事。这很好，给了我们谈资，我觉得这符合我们两人的风格和偏好。对她好，对我也好。所以思考如何将这些想法应用到亲密关系中也很有趣。

---

### [01:04:23] Lenny

**English:**
How do I subscribe to this feed of your wife sharing the news every day? It sounds like a great podcast we all need.

**中文翻译:**
我怎么订阅你妻子每天分享新闻的这个频道？听起来像是一个我们大家都需要的伟大播客。

---

### [01:04:29] Jake Knapp

**English:**
Really, really good stuff, or really important stuff, will find us. I think there is, part of the busy bandwagon, or part of the infinity pools thing, is this feeling inside that I'm responsible for staying up to date with the most important news in the world, or the most important news in my inbox, or my company or my team, work, and I'm responsible also for getting the very best of entertainment that's out at this moment that's the most topical and the funniest, or the most interesting, whatever, at this moment.

**中文翻译:**
真正好的东西，或者真正重要的东西，会主动找到我们的。我认为，“忙碌从众效应”或“无尽内容池”的一部分原因在于内心的一种感觉：我觉得我有责任掌握世界上最重要的动态，或者收件箱里最重要的消息，或者公司、团队、工作中的动态；我还有责任获取当下最棒的娱乐内容，那些最热门、最搞笑或最有趣的。

---

### [01:05:04] Jake Knapp

**English:**
And it's okay to let go of that and, the good stuff, it'll come to you. People will share it with you or you'll hear about it. If it's a really big news story, you'll hear about it eventually. If it's going to affect you, actually, you'll hear about it. And with most news, and most entertainment, we don't play a role, it's hard to admit, but we don't actually play a role in what happens, and so the idea that we're responsible for being on it all the time, that's a job that we can quit, or at least take a sabbatical from.

**中文翻译:**
放下这些是可以的。好东西会找到你的。人们会分享给你，或者你会听说。如果是一个重大的新闻，你最终一定会知道。如果它真的会影响你，你肯定会听到。对于大多数新闻和娱乐，虽然很难承认，但我们实际上并没有参与其中。所以那种“我们有责任时刻关注”的想法，其实是一份我们可以辞掉的工作，或者至少可以休个长假。

---

### [01:05:38] Lenny

**English:**
So Tim Ferriss talked about this in The 4-Hour Workweek, is way back in the day is just like, I wait for people to tell me what I need to know, exactly what John just shared before this, and I find this with, so first of all you find that when you delete Twitter, LinkedIn, you go week without it, and nothing is any different. You still know everything you need to know, your job, everything's going great. You missed a bunch of stuff that had no impact on your life. And so I think doing that exercise helps you realize that and I don't need to be on Twitter all the time.

**中文翻译:**
Tim Ferriss 在《每周工作 4 小时》里也提到过这一点，很久以前他就说：我等着别人告诉我需要知道的事情。这正是 John 刚才分享的。我发现，首先，当你删掉 Twitter、LinkedIn，坚持一周不用，你会发现一切都没有改变。你依然知道所有该知道的事，你的工作、一切都进展顺利。你错过了一堆对你生活毫无影响的东西。所以我觉得做这个练习能帮你意识到：我不需要时刻泡在 Twitter 上。

---

### [01:06:08] Lenny

**English:**
And not to get political, but with news about Trump, there's always these headlines, "Trump, look what he did in this lawsuit today, it's over." I just feel like there's so many posts about all these things Trump is doing every day, and none of them, nothing happens. It's just the same thing, just keeps going. If something actually happened there I would hear it from a lot of people, the New York Times would send me a big push. So it's like, I don't need to know all these things he's doing every day.

**中文翻译:**
不谈政治，但关于特朗普的新闻，总是有这些标题：“特朗普，看他今天在诉讼中做了什么，他完了。”我觉得每天都有这么多关于特朗普所作所为的帖子，但其实什么都没发生。只是同样的事情在不断重复。如果真的发生了什么大事，我会从很多人那里听到，《纽约时报》会给我发大弹窗。所以，我不需要知道他每天做的所有这些事。

---

### [01:06:36] Jake Knapp

**English:**
Well, it doesn't matter what your political affiliation is, that is true. Trump is always going to be in the news, and it's always going to, that's the constant, that's the third constant, death, taxes, and Trump will be in the news.

**中文翻译:**
无论你的政治立场如何，这都是事实。特朗普总会出现在新闻里，这已经成了一个常数。人生的三大常数：死亡、税收，以及特朗普出现在新闻里。

---

### [01:06:51] John Zeratsky

**English:**
A related tactic that I've been doing for a long time is my main source of news is the Economist magazine, which is far too highbrow for what I need, but the main feature of it is that it's weekly, because at the end of the week, the zillion stories about Trump, or whatever, if there was something of consequence, it gets distilled into this really good summary. Really, really good. The Economist has some of the best journalists in the world, they're just absolutely fantastic, and so not only does it have this really nice cadence of once a week, if something matters it's going to get rolled up there, it's going to get summarized. And so that's one of my most durable habits related to these tactics, is reading the news once a week, reading the Economist. It fits my brain, it fits my life rhythm really well.

**中文翻译:**
我长期坚持的一个相关策略是：我的主要新闻来源是《经济学人》杂志。虽然它对我来说有点太高端了，但它的主要特点是它是周刊。在一周结束时，关于特朗普或其他事情的无数琐碎报道，如果真的有重要的，都会被浓缩成一份非常精彩的总结。真的非常棒。《经济学人》拥有世界上最顶尖的记者，他们非常出色。所以它不仅有一周一次的良好节奏，而且如果某件事真的很重要，它会被汇总并总结。这是我与这些策略相关的最持久的习惯之一：每周读一次新闻，读《经济学人》。它非常契合我的大脑和生活节奏。

---

### [01:07:54] Lenny

**English:**
Yeah, it's the opposite of Twitter, basically.

**中文翻译:**
是的，基本上就是 Twitter 的反面。

---

### [01:07:58] John Zeratsky

**English:**
Yeah.

**中文翻译:**
没错。

---

### [01:07:58] Lenny

**English:**
So yeah, let's hear a couple more tactics and then let's touch on the other two parts of this framework.

**中文翻译:**
好，让我们再听几个策略，然后聊聊这个框架的另外两个部分。

---

### [01:08:03] Jake Knapp

**English:**
Well, first a pairing, and then one more. The pairing is reset expectations and slow your inbox. So these are two tactics related mostly to the email and messaging. So resetting expectations is just about having maybe a conversation with people you work with, but it can be as simple as a signature in your email. And so one great example of this is a signature that says, I'm checking email two times a day as an experiment to improve my focus, or I'm checking email once or twice a day, you decide how spicy you want to get with this option, because I'm working on an important project. And just a simple line that people will see passively as you send emails that will reset their expectations of how quickly you'll respond.

**中文翻译:**
好，先来一组组合策略，然后再讲一个。这组组合是“重置预期”和“减慢收件箱”。这两个策略主要与邮件和即时通讯有关。“重置预期”可以是与同事进行一次谈话，也可以简单到只是在邮件签名里加一句话。一个很好的例子是签名写着：“作为提高专注力的实验，我每天只查两次邮件”，或者“我每天查一两次邮件，因为我正在处理一个重要项目”。你可以决定这句话的“辣度”。当你发送邮件时，人们会下意识地看到这行字，从而重置他们对你回复速度的预期。

---

### [01:09:11] Jake Knapp

**English:**
And if you like you can say, I'm checking email once a day because I'm working on a big project, you can text me if it's urgent. Feel free to text me, you can invite people to do so. But that very act of just putting it in there, you can also do it as an out of office autoresponder, so just like, hey, instead of I'm actually out of the office like, hey, I'm going to be slow to respond to email because I'm working on an important project. That because is really important, and we talk in the book about this, a funny study about the power of because and this case where people would make up bogus excuses, but they'd say, "Because to cut a line," it's an old study, they're making photocopies, but they would cut the line and say, "I need to cut the line because I need to make copies." And just saying because dramatically boosted the percentage of the time that a person would let them cut the line.

**中文翻译:**
如果你愿意，你可以说：“我每天查一次邮件，因为我正在做一个大项目，如果有急事可以给我发短信。”你可以邀请人们这么做。仅仅是把这句话放进去，或者把它设为自动回复（即使你并没休假），比如：“嘿，我回复邮件会比较慢，因为我正在处理一个重要项目。”那个“因为”（because）非常重要。我们在书里提到了一个关于“因为”的力量的有趣研究：人们编造一些蹩脚的理由去插队复印，他们说：“我需要插队，因为我需要复印。”仅仅加上“因为”这个词，就能显著提高别人允许他们插队的概率。

---

### [01:09:58] Jake Knapp

**English:**
We're suckers for explanations, all of us. So if you say because people will feel better, and you can feel better about saying it. But this idea that you're just going to put up a placard, basically, that says, hey, I'm slow to respond because I'm working on a project, and maybe give people an escalation path, or don't, that's a huge deal. And it seems like it would be a huge deal because it changes others expectations, and that is true. But the real power of it is in changing our own expectations about what we are going to do and what we are expected to do. Most of the stress comes internally, from our feeling that if we don't get back to people right away, we're not enough, we're not measuring up, we feel some kind of shame or guilt about not doing it and not being fast and not being responsive. And so doing this statement is just about renegotiating with ourselves.

**中文翻译:**
我们所有人都无法抗拒解释。所以如果你说了“因为”，别人会感觉好受些，你也会感觉好受些。这种做法基本上就是挂起一个告示牌，说：“嘿，我回复慢是因为我在忙项目”，你可以给人们一个紧急联系方式，也可以不给。这意义重大。它之所以重要，表面上是因为改变了别人的预期，这确实是真的。但它真正的力量在于改变了“我们自己”对自己的预期。大部分压力来自内部，来自我们觉得“如果不立即回复，我就不够好，我不达标”的感觉。我们会因为没能快速响应而感到羞愧或内疚。所以，发表这个声明其实是在与我们自己重新谈判。

---

### [01:10:46] Jake Knapp

**English:**
The other one is to slow down your inbox. This is a simple one, if you start to do that, if you start to just check your email once or twice a day, or even less frequently, or even if you check it a little bit more frequently but you aren't responding to emails, you don't hold yourself accountable to this idea of an empty inbox, then the whole loop slows down. If you respond to emails really fast, you respond to messages really fast, people respond back to you and then there's more to respond to. And if you slow down that little hamster wheel, it slows down. And so that's powerful too. So those two around email I think can be really helpful, they help me with this, my default feeling about email and messaging and everything is I should be as responsive as possible, and I have to constantly renegotiate that with myself, and those are ways I do it.

**中文翻译:**
另一个是“减慢收件箱”。这很简单：如果你开始每天只查一两次邮件，甚至更少，或者即使查得勤一点但不立刻回复，不再强求“收件箱清零”，那么整个循环就会慢下来。如果你回邮件飞快，回消息飞快，别人也会飞快回你，然后你就有更多要回的。如果你让这个“仓鼠轮”慢下来，它就真的慢下来了。这也很强大。所以关于邮件的这两个策略我认为非常有帮助，它们帮我克服了那种“我应该尽可能快地响应”的默认心态。我必须不断地与自己重新谈判，这就是我的方法。

---

### [01:11:36] Jake Knapp

**English:**
This other one that's pretty extreme, that I only just tried for the first time, it's in the book but I hadn't actually tried it, but this was a reader of our blog told us about this. Her name is Krissa, I think she allowed us to use her first name but not her last name. So Krissa, if you're listening, shout out to you, this turned out to be a great tactic, but it's to cancel the internet. And she had canceled the internet at home, which is wild. But what I did was I have an office, a very small office in this small town here where I live, and-

**中文翻译:**
另一个比较极端的策略，我最近才第一次尝试。它在书里，但我以前没试过，是一个博客读者告诉我们的。她叫 Krissa，我想她允许我们用她的名字。Krissa，如果你在听，向你致敬。这被证明是一个伟大的策略，那就是：断开网络。她在家里断了网，这太疯狂了。而我的做法是：我在我住的小镇上有一个非常小的办公室，然后……

---

### [01:12:00] Jake Knapp

**English:**
Small office in this small town here where I live and I canceled the internet there so that I could, when I went there, all I can do are tasks that you can't do with the internet, which is a lot. I mean, you can use a lot of apps in offline mode and it's a great place for me to write. It's a great place for me to do focus work, design something, presentation, but any kind of focused thinking, reading, writing can happen there and now the whole feeling of stepping into that room where I cannot access the internet is insane.

**中文翻译:**
我在住的小镇上有个小办公室，我取消了那里的网络。这样当我过去时，我只能做那些不需要联网的任务，其实有很多。我的意思是，你可以在离线模式下使用很多 App。那是我写作的绝佳场所，也是我进行深度工作、设计、做 PPT 的好地方。任何形式的深度思考、阅读、写作都可以在那里进行。现在，走进那个无法上网的房间的感觉简直太棒了。

---

### [01:12:32] Jake Knapp

**English:**
To create this kind of a thing at home, you can do things like put a timer on your internet. You can actually buy one of those vacation timers, plug it into the wall, plug your router into that, and it will actually switch your internet off at a certain hour or hours. There's also software that'll let you do this selectively, but the big notion of just having there be a time when you are off and it's a fairly significant pain to get back on again, it's more than just clicking wifi on, wifi off. I find for me that's not enough of a speed bump. It's pretty powerful.

**中文翻译:**
要在家里实现这一点，你可以给路由器装个定时器。你可以买那种度假用的定时插座，插在墙上，把路由器插在上面，它就会在特定时间自动断网。也有软件可以让你选择性地断网。核心理念是：设定一个你必须下线的时间，而且重新上线的代价要足够大，而不仅仅是点一下 Wi-Fi 开关。我发现对我来说，点开关这种“减速带”还不够。这个方法非常强大。

---

### [01:13:07] Lenny

**English:**
Just the way you're describing the feeling of walking into an office that has no internet, I totally feel that. Just imagine, just like, "I have no internet here. I could do so many things. I could read."

**中文翻译:**
你描述走进一个没网的办公室的那种感觉，我完全能体会。想象一下，“这里没网，我可以做这么多事，我可以看书。”

---

### [01:13:19] Jake Knapp

**English:**
It might be a coffee shop where you don't find out what the wifi password is and there's just this amazing, amazing feeling. Maybe it's just you go to a park where there's no wifi, just whatever it might be, finding a place where you can't, you just can't get that stuff. Leave your phone at home if you can't bear to delete all the apps. It's so great. It's so great. And then you're not fighting the battle.

**中文翻译:**
也可以是一家你不知道 Wi-Fi 密码的咖啡馆，那种感觉非常奇妙。或者去一个没 Wi-Fi 的公园。总之，找一个你无法获取那些信息的地方。如果你舍不得删 App，就把手机留在家里。这太棒了，真的太棒了。这样你就不用再进行意志力的博弈了。

---

### [01:13:46] Jake Knapp

**English:**
A lot of this stuff, there's a visualization I think of where I've got the highlight in front of me. It's right there. This thing I can see that I want to do, but it's like five feet away or 10 feet away, and right next to me just kind of vibrating are all of the... You can imagine all the app logos, they're just kind of vibrating right around my head. They're right there and touching any one of them, it's like they're little pieces of candy. It's all going to feel good. There's this really good meal, five to 10 feet away is this great sandwich, but these little pieces of candy are right in my face and it's going to be hard to resist just popping a little Sour Patch Kid or Laffy Taffy in my mouth, but if I could push them away, if I can just push them far enough away so that there is far away or farther away than the sandwich, I'm going to eat the sandwich.

**中文翻译:**
关于这些，我脑海中有一个画面：我的“高光”就在我面前，清晰可见，我想去做它。但它在 5 英尺或 10 英尺外。而就在我身边，各种东西都在“振动”……你可以想象所有的 App 图标都在我脑袋周围振动。它们就在那儿，触碰其中任何一个都像吃一颗小糖果，感觉会很好。在 5 到 10 英尺外有一顿丰盛的大餐，一个美味的三明治；但这些小糖果就在我脸跟前，很难忍住不去往嘴里塞一颗酸味小人糖或太妃糖。但如果我能把它们推开，推到比三明治更远的地方，我就会去吃那个三明治。

---

### [01:14:50] Lenny

**English:**
Such a good metaphor. You also have this metaphor of Odysseus sailing past the sirens. If folks know that story where there was a siren, I don't know, cliff thing where he's just sailing.

**中文翻译:**
太棒的隐喻了。你们还有一个关于奥德修斯航行经过塞壬女妖的隐喻。如果大家知道那个故事，塞壬女妖在悬崖上唱歌，而他正驾船经过。

---

### [01:15:01] Jake Knapp

**English:**
I know well, in eighth grade I played Odysseus in school play, so I can tell you all about it.

**中文翻译:**
我很清楚，八年级时我在学校话剧里演过奥德修斯，所以我可以给你讲个透。

---

### [01:15:06] Lenny

**English:**
Man, what a character to play. Yeah. And in that story, he wanted to experience these sirens who nobody could resist, but he forced his sailors to tie him to the ship and not allow him to do anything, even though he's like, "Let me go. I need to go there." Because everyone crashed into the sirens. Anyway, I'm doing a bad job explaining this story, but I think it just comes back to the same point again and again that you can't rely on your willpower to not go towards these vibrating candies all around you that you need to set up these systems.

**中文翻译:**
天哪，演那个角色一定很酷。是的。在那个故事里，他想体验没人能抗拒的塞壬歌声，但他强迫水手把他绑在船桅上，不准放开他，即使他大喊：“放开我，我要去那儿！”因为所有被歌声吸引的人都会触礁。总之，我讲得不太好，但我想表达的是：你不能指望意志力去抵抗周围那些“振动的糖果”，你需要建立这些系统。

---

### [01:15:41] Jake Knapp

**English:**
I think there's this notion that we will use willpower maybe comes from the fact that some people can, maybe some people are just using willpower or they're on Twitter, they're on Instagram, they're on TikTok, they're on Facebook, they're doing all these things, and they're also functioning just fine, or at least what we see from the outside is just fine. But maybe internally too, it's fine. It just seems that everybody I actually talk to and certainly my personal experiences, all that stuff makes me feel bad and actually undercuts my ability to do the things that are meaningful.

**中文翻译:**
我觉得“我们可以使用意志力”这种念头可能源于某些人确实可以。也许有些人只是靠意志力，或者他们刷 Twitter、Instagram、TikTok、Facebook，做所有这些事，但依然运转良好，至少从外表看是这样。也许他们内心也觉得没问题。但似乎我聊过的每一个人，当然也包括我个人的经验，所有这些东西都让我感觉很糟，实际上削弱了我去做有意义事情的能力。

---

### [01:16:42] Jake Knapp

**English:**
This thing, I think we basically are steered toward becoming reaction machines and this notion of, "I'm going to have an empty inbox. I'm going to do every task. I'm going to be a fast responder, I'm going to be in every meeting. I'm going to do that because I want to help other people, and that's the way it works." I think this desire to be helpful is a big driver of it. I think we want to alleviate our stress and other people's stress, and that seems like the right way to do it. It's candy. Some of the stuff is candy and easy.

**中文翻译:**
我觉得我们基本上被引导成了“反应机器”。那种“我要清空收件箱、我要完成每项任务、我要快速响应、我要参加每个会议”的想法，是因为我们想帮助别人，觉得这就是工作的方式。我认为“乐于助人”的愿望是很大的驱动力。我们想减轻自己和他人的压力，而这看起来是正确的方法。但这是糖果。有些事情就像糖果一样容易。

---

### [01:17:12] Jake Knapp

**English:**
We also see this modeled by people in power, so like CEOs and bosses, it works for them because they're applying their influence through being constantly reactive and being in meetings all the time. That's just how they do what they do. That's how they apply their influence. But even for them, I think it has limits as a way to apply influence. At the bare minimum for the rest of us. And for those of us who again, I think is the vast, vast majority for whom all of these things create problems and we're not able to easily willpower and self-esteem manage all this stuff, if we're a reaction machine, we're not doing meaningful work, no Project A's and we're not really alive as humans. We're just chat bots. So it's worth experimenting if you don't want to live your life out as a chatbot.

**中文翻译:**
我们也看到有权势的人在这样做，比如 CEO 和老板们。这对他们有效，因为他们通过不断的反应和开会来施加影响力。这就是他们的工作方式。但即使对他们来说，我认为这种施加影响力的方式也是有限度的。至少对我们其他人来说是这样。对于我们绝大多数人来说，这些事情都会制造问题，我们无法轻易靠意志力和自尊来管理这一切。如果我们是一台反应机器，我们就无法做有意义的工作，没有“项目 A”，我们也就不是真正活着的人。我们只是聊天机器人。所以，如果你不想像聊天机器人一样度过余生，那就值得去实验一下。

---

### [01:18:00] Lenny

**English:**
I think the point you made there around the feeling is just a really important point that even if you feel really productive enough and you're getting things done, is if you're feeling bad, it's still an important thing to focus on. This idea of, are you spending time on things you want to spend time on? You also reminded me of this app I'll mention briefly that I think you guys will love, I don't know if you've heard of this. It's called mailmanhq.com. It shuts off your Gmail for periods of time. So you could say, "Only allow my email through at these times of day." And so instead of email whatever, it's just like you can batch your release of email.

**中文翻译:**
我觉得你提到的关于“感受”的一点非常重要：即使你觉得自己足够高效、正在完成任务，但如果你感觉很糟，这依然是一个值得关注的重要问题。核心在于：你是否把时间花在了你想花时间的事情上？你还让我想起了一个 App，我想你们会喜欢的，不知道你们听过没。它叫 mailmanhq.com。它可以定时关闭你的 Gmail。你可以设置“每天只在这些时间段允许邮件进入”。这样你就不会随时被邮件打扰，而是可以批量接收邮件。

---

### [01:18:35] Jake Knapp

**English:**
That's beautiful. Mailman HQ?

**中文翻译:**
太棒了。Mailman HQ？

---

### [01:18:37] Lenny

**English:**
Mailman hq.com.

**中文翻译:**
Mailmanhq.com。

---

### [01:18:39] Jake Knapp

**English:**
Okay, I'm writing that down right now.

**中文翻译:**
好，我现在就记下来。

---

### [01:18:40] Lenny

**English:**
Yeah, I go on and off it because sometimes I just want on an email, but it makes a big difference. It's wild how just not even knowing your email makes a big difference.

**中文翻译:**
是的，我断断续续地用它，因为有时我就是想看邮件。但它确实能带来很大不同。仅仅是“不知道有新邮件”这件事就能产生巨大的影响，这很神奇。

---

### [01:18:49] Jake Knapp

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:18:50] Lenny

**English:**
Okay. Let's touch on the last two parts of this framework, energize and reflect, and then let's spend a little time on Sprint for people to get a sense of what this method is all about. For folks that haven't read the book.

**中文翻译:**
好。让我们聊聊这个框架的最后两个部分：“保持活力”（Energize）和“反思”（Reflect）。然后我们花点时间聊聊《设计冲刺》（Sprint），让没读过那本书的人了解一下那个方法是怎么回事。

---

### [01:19:03] John Zeratsky

**English:**
So to replay the system overall highlight is about the thing you want to make time for today. The most important thing today, laser is about creating barriers to distraction so that you have much your energy or as much of your attention as possible to focus on your highlight on that one thing. Energize is sort of like a booster to laser. It's sort of like the big idea is that our brains and bodies are connected and our ability to pay attention and to focus and to do those things that we care about only works when we are well and we have slept, we have eaten well, we have exercised, we have talked to other people the right amount, not too much, not too little and so we put this as part of the make time framework because we don't think you should go crazy, try a million biohacker type of things, but we do think it's worth applying this same philosophy of pay attention to what's working, what's not, have a system, try some new things, pay attention to those things, run these experiments. We think it's worth doing that for your health, for your energy as well, because it really does make a difference.

**中文翻译:**
所以回顾一下整个系统：“高光”是关于你今天想为之腾出时间的那件事，今天最重要的一件事；“激光专注”是关于设置分心障碍，以便你有尽可能多的精力和注意力去专注于你的高光。而“保持活力”就像是“激光专注”的助推器。核心理念是：我们的大脑和身体是相连的。我们保持注意力、专注以及做我们关心的事的能力，只有在我们状态良好时才有效——即我们睡得好、吃得好、有运动、与人有适度的交流。我们将此作为《时间管理术》框架的一部分，是因为我们不认为你应该走极端去尝试一百万种“生物黑客”式的方法，但我们确实认为值得应用同样的哲学：关注什么有效、什么无效，建立一个系统，尝试新事物，观察结果，进行实验。为了你的健康和精力，这样做是值得的，因为它确实能带来改变。

---

### [01:20:27] Lenny

**English:**
Maybe share one or two tips there real quick for people to energize to create a little more energy during their day?

**中文翻译:**
能不能快速分享一两个关于“保持活力”的技巧，让大家在一天中获得更多精力？

---

### [01:20:33] John Zeratsky

**English:**
In the year since we wrote the book and as my life has just continued to change and I've gotten a little bit older, I've realized that sleep is probably the single most important thing. I mentioned earlier, not having my phone in the bedroom, no TV in the bedroom, hopefully that goes without saying, but just being able to really construct an environment that allows me to sleep. I started wearing an eye mask recently.

**中文翻译:**
在写完书后的这些年里，随着生活不断变化，我也年长了一些，我意识到睡眠可能是最重要的一件事。我之前提到过，卧室里不放手机，不放电视（这应该是常识），但关键是真正构建一个能让我入睡的环境。我最近开始戴眼罩了。

---

### [01:21:01] Lenny

**English:**
I do that.

**中文翻译:**
我也戴。

---

### [01:21:02] John Zeratsky

**English:**
Yeah, really helps me fall asleep and stay asleep and then the other thing is exercise is a big source of energy for me, but I realized that I was making excuses about why I didn't need to or shouldn't exercise in any given day. So even though this is not what we recommended in the book specifically, I ended up signing on with a personal trainer so that I have accountability, I have a schedule, I have somebody who's thinking about what I need that's not just me and those two things have kind of been the pillars of how I build energy over the last few years.

**中文翻译:**
是的，眼罩真的帮我入睡并保持睡眠。另一件事是运动，它是我精力的重要来源。但我意识到我总是在找借口说为什么今天不需要或不该运动。所以，虽然这不一定是我们在书里专门推荐的，但我最终请了一个私人教练。这样我就有了问责制，有了时间表，有人在替我思考我需要什么，而不仅仅是我自己。这两件事成了我过去几年积累精力的支柱。

---

### [01:21:47] Lenny

**English:**
I use this app called Future, I'm a investor, quick disclaimer, but it's basically a personal trainer through an app that's like a real person that helps you design a workout for you, and then they give you the workout on the app and you just follow the instructions and that's the thing that got you working out three times a week.

**中文翻译:**
我用一个叫 Future 的 App（免责声明：我是投资者），它基本上是通过 App 提供真人私教，帮你设计锻炼计划，然后在 App 上发给你，你只需照做。这就是让我能坚持每周锻炼三次的原因。

---

### [01:22:03] John Zeratsky

**English:**
Nice. Yeah.

**中文翻译:**
不错。

---

### [01:22:04] Jake Knapp

**English:**
That's awesome.

**中文翻译:**
太棒了。

---

### [01:22:04] Lenny

**English:**
Killing it. Okay. And then within reflect, maybe just briefly talk about the importance there and then one thing people could do to reflect on how things are going.

**中文翻译:**
干得漂亮。好，关于“反思”，能不能简要谈谈它的重要性，以及人们可以做的一件反思现状的小事？

---

### [01:22:14] Jake Knapp

**English:**
Reflect is just simply the act of looking back on the day and treating the day. It wasn't marble gravestone of your successes or failures, it's just a experiment that you ran. What happened in the experiment? Taking note of it in that lens, what did it look like? There's a template in our book that has some questions you can answer, but really it's pretty simple. If you write down your highlight in the morning or the night before, if you're draw it and you stick it somewhere visible, then at the end of the day you just look at it and just like, "Okay, did that happen or did that not happen?" If you stick it somewhere visible, you won't even have to do anything. You'll just come across it and you'll know if did that happen or not? So that's the simplest part of it is writing it down, sticking it will create a reflection loop for you.

**中文翻译:**
“反思”其实就是回顾这一天。不要把这一天看作是你成功或失败的墓碑，它只是你进行的一个实验。实验中发生了什么？从这个视角去记录：它看起来像什么？我们书里有一个模板，里面有一些你可以回答的问题，但其实很简单。如果你在早上或前一天晚上写下你的高光，把它画出来并贴在显眼的地方，那么在一天结束时，你只需看着它想：“好吧，这件事发生了吗？”如果你把它贴在显眼处，你甚至不需要刻意去做什么，你只是路过看到它，就会知道它是否达成了。所以最简单的部分就是：写下来，贴上去，这就会为你创造一个反思闭环。

---

### [01:23:14] Jake Knapp

**English:**
Another thing that I think is quite powerful at the end of the day is to write down, keep a notebook by the side of the bed and write down one or two or three things that you are grateful for during the day, just like a simple gratitude journal. And you'll start, this keeps you in this frame of mind of what was cool today, what happened that was satisfying or joyful, what brought me joy and then if you start the day thinking about what you'd like to happen and then you look back and say, "What was great?" Your brain is just starting to look for those good things. Look for those big highlights, and that's a great way to live your life day to day saying, "This is what I hope will happen. This is what did happen. Now I'm more tuned into what it might happen tomorrow. Oh, now I'm more tuned into what happened today." And again, and it's just a really nice loop. So was there a connection between what you hoped would happen? Did you manage to do your highlight? If so, what helped you do it? What worked or didn't work? What made it hard? It might be an energy thing that suggests a tweak to when you drink coffee or if you take a walk or whatever. It might've been a focus thing. So maybe I'll try another barrier for this thing because that undercut me. Whatever it is, it's just basically, in summary, curiosity about your day instead of self-judgment about your day.

**中文翻译:**
另一件我认为在一天结束时非常有力量的事是：在床头放个笔记本，写下一两件或三件你当天感激的事，就像一个简单的感恩日记。这会让你保持一种心态：今天有什么酷的事？发生了什么令人满足或快乐的事？什么带给我快乐？如果你在开始这一天时想着你希望发生什么，结束时回顾“什么是伟大的？”，你的大脑就会开始主动寻找那些美好的事物，寻找那些重大的高光。这是一种很棒的生活方式：每天说“这是我希望发生的。这是实际发生的。现在我更敏锐地察觉到明天可能发生什么。噢，现在我更敏锐地察觉到今天发生了什么。”这又是一个非常好的闭环。所以，你希望发生的和实际发生的有联系吗？你完成高光了吗？如果完成了，是什么帮助了你？什么有效，什么无效？什么让它变得困难？这可能是一个精力问题，暗示你需要调整喝咖啡的时间或散步的时间；也可能是一个专注问题，所以也许下次我会为某个诱惑设置更多的障碍。总之，就是用“好奇心”代替“自我审判”来审视你的一天。

---

### [01:24:30] Lenny

**English:**
I think we've covered Make Time and tons of depth if people want to practice these things, highly recommend getting the book. It's called Make Time and it's really quick to read and it's basically just a long list of things you can do and we talked about a lot of them. There's a lot more. And I think part of the premise of the book is try stuff, see what works, see what doesn't. Keep reflecting, iterating, some of these things, even if you find two things that change how productive you're, that's a huge win.

**中文翻译:**
我觉得我们已经非常深入地探讨了《时间管理术》。如果大家想实践这些方法，我强烈建议买这本书。它叫《时间管理术》，读起来很快，基本上就是一张你可以做的长清单。我们讨论了其中的很多，但还有更多。我认为这本书的前提之一就是：尝试，看什么有效，看什么无效。不断反思、迭代。在这些事情中，哪怕你只找到两件能改变你效率的事，那也是巨大的胜利。

---

### [01:24:55] Jake Knapp

**English:**
I highly recommend people get the book. That's great. And it's our best attempt to put together a how-to guide for doing this stuff. For what it's worth, we're not really motivated to try to create a self-improvement empire. This is not our full-time job. We just hope it works for you and is useful. So if you don't want to buy the book, we get it. Go to maketime.blog and just check out some of the experiments and things that are available there or just try one or two of the things that we talked about today. Try the highlight. If you're going to do one thing, just try right now writing down what you want your highlight to be, either for today or if it's late in the day for tomorrow on a sticky note and put it somewhere that you'll see it tomorrow.

**中文翻译:**
我也强烈建议大家买书，那太好了。这是我们为这些方法编写操作指南的最佳尝试。说实话，我们并没有动力去建立一个什么“自我提升帝国”。这不是我们的全职工作。我们只是希望它对你有用。所以如果你不想买书，我们也理解。去 maketime.blog 看看那里提供的实验和内容，或者只是尝试一下我们今天谈到的一两件事。尝试一下“高光”。如果你只想做一件事，那就现在尝试在便签纸上写下你希望的高光是什么（不管是今天的，还是如果时间晚了就写明天的），然后把它贴在明天能看到的地方。

---

### [01:25:41] Jake Knapp

**English:**
Just that is a great step in the right direction. Try having a conversation with your colleagues or putting a signature or an autoresponder in your mail that says you're going to slow down or talking to them about slowing down at character. At our VC fund, we had a conversation and decided we're going to try to have our main communication happen in Notion so that if we're talking about something, it's in a form, it becomes a document, and the expectation of how you react and respond there is going to be different than in a tool that's designed to get you responding as fast as possible, like an email inbox or Slack.

**中文翻译:**
仅仅这一步就是朝着正确方向迈出的一大步。尝试与同事沟通，或者在邮件里加个签名或自动回复，说你会减慢响应速度。在我们的风投基金 Character，我们开会决定尝试将主要沟通放在 Notion 中。这样当我们讨论某事时，它是有形式的，会变成一份文档。在那里，人们对反应和回复速度的预期，会不同于那些旨在让你尽可能快地回复的工具（如邮件收件箱或 Slack）。

---

### [01:26:16] Lenny

**English:**
Amazing. So I've used up basically all our time talking about Make Time. I think we should have a follow-up episode just to talk about Sprint. What I think we do is let's cut off the lightning round and whatever stuff you guys would've shared there, we'll include in the show notes. I'll send you those questions asynchronously, but let's just talk about Sprint for a few minutes just to give people a sense of what is this framework, it's extremely popular, lets a lot of really successful products, and then we'll wrap up and point people in the direction that you recommend.

**中文翻译:**
太棒了。我基本上把所有时间都花在聊《时间管理术》上了。我觉得我们应该再录一集专门聊《设计冲刺》（Sprint）。我想我们可以取消闪电轮环节，你们想分享的内容我会放在节目介绍里。我会异步把那些问题发给你们。但现在让我们花几分钟聊聊《设计冲刺》，让大家了解一下这个框架。它非常受欢迎，催生了很多成功的产品。然后我们就结束，并引导大家去关注你们推荐的方向。

---

### [01:26:59] Jake Knapp

**English:**
Cool.

**中文翻译:**
好的。

---

### [01:27:00] Lenny

**English:**
What is this framework of Sprint? When do people use this idea, this framework, this approach? And what are some examples of what has come out of somebody applying Sprints?

**中文翻译:**
什么是“设计冲刺”框架？人们什么时候会用到这个想法、框架或方法？有没有一些应用“冲刺”后产生的成果例子？

---

### [01:27:10] Jake Knapp

**English:**
The big idea with a design Sprint is to go from a zero to a prototype and a test of that prototype in just five days. And it's a recipe, it's a scripted set of activities that we developed over a number of many years. First, started with some projects I was doing at Google and I run some experiments with the way I was working. I was a product designer on Gmail in the 2000's, and I also co-founded Google Meet. And in the sort of week where we really catalyzed what had been a project that was going nowhere, this 20% project of people who were familiar with Google, like a side project was going nowhere for a year and a half. It was really on the rocks.

**中文翻译:**
“设计冲刺”的核心理念是在短短五天内，从零开始完成原型设计并进行测试。它是一套“食谱”，是我们多年来开发的一套脚本化活动。最初始于我在 Google 做的一些项目，当时我对自己的工作方式进行了一些实验。2000 年代我是 Gmail 的产品设计师，我也联合创立了 Google Meet。在某一周里，我们真正催化了一个原本停滞不前的项目——那个“20% 时间项目”（熟悉 Google 的人都知道，就是个副业项目）已经一年半没进展了，几乎快要夭折。

---

### [01:27:59] Jake Knapp

**English:**
And in one focused week working together, we decided me and these two other folks we're going to clear everything off. I visited them in the Stockholm office where they were. We created a working prototype. Instead of trying to come up with the perfect plan, the perfect PRD, the perfect pitch to executives we're like, "Let's just build a prototype and put it in front of our colleagues and get them using it." And we did that and that was the thing that stuck. And so from there on, I was like, "I need to recreate these kinds of moments for teams because that's powerful." So we ran hundreds of these at Google Ventures with startups, tweaked and refined the process, wrote this book called Sprint.

**中文翻译:**
在那专注的一周里，我和另外两个同事决定清空所有其他事务。我去了他们所在的斯德哥尔摩办公室。我们制作了一个可运行的原型。我们没有试图制定完美的计划、完美的 PRD（产品需求文档）或向高管进行完美的汇报，而是想：“让我们直接做一个原型，放在同事面前让他们用用看。”我们做到了，那件事成功了。从那时起，我想：“我需要为团队重新创造这种时刻，因为这太强大了。”所以我们在 Google Ventures 与初创公司一起进行了数百次这样的冲刺，不断调整和完善流程，最后写了《设计冲刺》这本书。

---

### [01:28:28] Jake Knapp

**English:**
We run a venture fund today, John and I and our colleague Eli, called Character. We help teams find and expand product market fit with Sprint. It's a tool for doing that and it uses a lot of these principles we talked about with Make Time to change the defaults, but not just the defaults of the way an individual works, but the ways teams work, the way people make decisions, the way we evaluate what's a good idea, a good strategy and worth pursuing based not on just a hunch or a guest, but based on something we can actually see with customer reactions. So all of that kind of in a nutshell is what Sprint does.

**中文翻译:**
今天，我和 John 以及我们的同事 Eli 经营着一家名为 Character 的风投基金。我们通过“冲刺”帮助团队寻找并扩大产品市场契合度。它是一个实现目标的工具，应用了很多我们在《时间管理术》中谈到的改变默认设置的原则，但不仅是改变个人的工作方式，还改变了团队的工作方式、决策方式，以及我们评估什么是好主意、好战略的方式——不是基于直觉或猜测，而是基于我们能从客户反应中看到的实际结果。简而言之，这就是“冲刺”的作用。

---

### [01:29:07] John Zeratsky

**English:**
This idea of getting unstuck and turning maybe some abstract ideas or some concepts that you've been discussing, turning that into a concrete prototype, something that you can look at and you can click around and you can actually try. It works in a lot of different contexts, and we've heard amazing stories from people who read the book and have run Sprints at companies that have a hundred thousand people and governments and all sorts of different organizations, but the stories that are in Sprint are about working with startups.

**中文翻译:**
这种摆脱困境、将抽象想法或讨论中的概念转化为具体原型的想法——一个你可以看、可以点、可以实际尝试的东西——在很多不同背景下都有效。我们听过很多读过书的人在拥有十万人的大公司、政府和各种组织中运行“冲刺”的神奇故事。但《设计冲刺》书里的故事主要是关于与初创公司合作的。

---

### [01:29:45] John Zeratsky

**English:**
We think this is especially valuable for startups because typically you've raised a certain amount of money which buys you a certain amount of runway. You have a certain amount of time to prove that you have product market fit to prove that the thing that you're making is the right thing for some customers. And so the faster you can do that, the more quickly you can find out if you're on the right track, the more quickly you can learn and you can course correct and ultimately you can get to a better place faster than if you spent months working on that prototype or that first version of the product before releasing it.

**中文翻译:**
我们认为这对初创公司尤其有价值，因为通常你筹到了一笔钱，这为你买到了一定的“跑道”（生存时间）。你只有有限的时间来证明你拥有产品市场契合度，证明你正在做的东西对某些客户来说是正确的。所以你做得越快，就能越快发现自己是否走在正确的轨道上，越快学习并修正方向。最终，这比你花几个月时间打磨原型或第一个版本再发布，能让你更快地到达一个更好的境地。

---

### [01:30:22] Lenny

**English:**
I think what's awesome about it is as a product manager, the idea of containing a new idea experiment to five days versus this ongoing teams distracted on this idea just like, "Cool, we're going to spend a week, see where this goes. They're not going to spend months exploring. We're not going to talk about it. And just in theory, let's just try it." I think it's really powerful. And so for folks that may want to explore this until we do a follow-up episode, is it just by the book, is there anything else you could point them to think about this idea and implementing it?

**中文翻译:**
我觉得最棒的一点是，作为一名产品经理，将一个新想法的实验限制在五天内，而不是让团队一直在这个想法上分心。就像是：“酷，我们花一周时间，看看结果如何。我们不会花几个月去探索，也不会只停留在理论讨论上，让我们直接试一试。”我认为这非常强大。对于那些在下一集之前想探索这个方法的人，除了买书，还有什么可以引导他们思考和实施这个想法的资源吗？

---

### [01:30:49] Jake Knapp

**English:**
Yeah. Well, if you are thinking about, or in the very early stages of starting a company, a great thing to do is to get in touch with us at character.vc. And actually we're just opening up applications to our labs program. So character.VC/labs. Our labs program is an intensive program for startups, and we will run a sequence of Sprints including some new formats that are not in the book, but are excellent. This will be our third time running through this. We found that it's especially valuable for AI startups.

**中文翻译:**
有的。如果你正在考虑或处于创业的极早期阶段，最好的办法是访问 character.vc 与我们联系。实际上，我们刚刚开放了 Labs 项目的申请：character.vc/labs。我们的 Labs 项目是一个针对初创公司的强化项目，我们会进行一系列“冲刺”，包括一些书里没有但非常出色的新形式。这将是我们第三次运行这个项目。我们发现它对 AI 初创公司尤其有价值。

---

### [01:31:20] Jake Knapp

**English:**
So it just turns out that a lot of the complex issues you have to figure out with turning something that may not initially be trustworthy may require a big behavior shift to customers who aren't used to working in this way and sometimes artificial intelligence can produce things that feel kind of alien to people. And so making this stuff actually useful, more than just a chatbot with little stars that's in the corner that says, "Hey, would you like to ask the AI a question about this?" But something that's really meaningful, doing this kind of repeated and we'd run a sequence of Sprints doing it again and again, you work with directly with John and I, we find a really powerful way to get started.

**中文翻译:**
事实证明，很多复杂的问题都需要解决：如何将一些最初可能不被信任的东西转化为客户的习惯？这可能需要那些不习惯这种工作方式的客户发生巨大的行为转变。有时人工智能产生的东西会让人们感到陌生。因此，要让这些东西真正有用，而不仅仅是一个角落里带着小星星、写着“嘿，你想问 AI 一个问题吗？”的聊天机器人。要做出真正有意义的东西，通过反复进行一系列冲刺，你将直接与 John 和我合作。我们发现这是一种非常强大的启动方式。

---

### [01:32:04] Jake Knapp

**English:**
Anyway, that's a big advertisement for Character Labs. But yeah, in general, check out the book. Also, would say if you're not quite ready to dip your toe in the whole book, you can go to the sprintbook.com. And we have a ton of resources on there, including a new thing, which is a Miro board, a Miro template that I created that has step-by-step instructions for every single step as well as 30+ videos of me explaining each step and actually I think I'm wearing the same sweatshirt in those, so if you're watching this on YouTube, you can see more of me in this sweatshirt in that template. And that's free, that's free and there's a bunch of resources on the website that are free as well. So anybody, everybody should be able to access this stuff.

**中文翻译:**
总之，这是给 Character Labs 做的一个大广告。但总的来说，去看看那本书。另外，如果你还没准备好读整本书，可以访问 thesprintbook.com。我们在那里提供了大量资源，包括一个新东西：我创建的一个 Miro 模板，里面有每一步的详细说明，还有 30 多个我解释每一步的视频。我记得视频里我穿的还是这件卫衣，所以如果你在 YouTube 上看，你会在模板里看到更多穿这件卫衣的我。那是免费的，网站上还有很多其他免费资源。所以任何人、每个人都应该能获取这些内容。

---

### [01:32:51] Lenny

**English:**
Stuff. Amazing. And again, for folks that may want to check out the Labs cohort, is there anything other than AI-oriented that would be ideal? Just how early stage, any other markets that are ideal for the Sprint process and the way you're approaching it?

**中文翻译:**
太棒了。再次说明，对于想参加 Labs 项目的人，除了 AI 导向的公司，还有什么理想的类型吗？比如阶段要多早？还有哪些市场适合“冲刺”流程和你们的方法？

---

### [01:33:05] John Zeratsky

**English:**
Yeah, it's a four-week Sprint program for pre-seed software startups. So we only invest in software startups at Character, and this program is really ideal for companies who they know what they're doing. They're not just like, "Oh, I want to start a company." They have an idea of an opportunity that exists, a market that they're focused on, but they definitely haven't reached product market fit. They may not even have a product to test that hypothesis with. So it's very early stage, and we are pretty flexible on the sector, the industry that you're in.

**中文翻译:**
是的，这是一个为期四周的、针对种子前（pre-seed）软件初创公司的冲刺项目。在 Character，我们只投资软件初创公司。这个项目非常适合那些知道自己在做什么的公司。他们不是那种“噢，我想开家公司”的状态，而是已经发现了一个机会，有一个专注的市场，但肯定还没达到产品市场契合度。他们甚至可能还没有一个产品来测试假设。所以这是非常早期的阶段，我们对你所处的行业和领域非常灵活。

---

### [01:34:06] John Zeratsky

**English:**
But what we find is that the more there's kind of a big behavioral risk, the better this stuff works. So if you're just trying to make a slightly better version of something that already exists, and maybe it's going to be a little cheaper or a little faster, a little easier to use, you probably don't need this stuff. You can probably just do it and probably going to work. But if you are like one of our portfolio companies, they make AI that controls the industrial facilities. They came from Google DeepMind and they did this for Google data centers before, something like that where you have to convince plant operators who are wearing hard hats and dealing with huge equipment, you have to convince them to trust AI. That's a big behavior shift. That's a big behavioral risk. Or in healthcare, in education, places where it feels like the technology can really make a big difference for people, but it can be hard to get over that hurdle of trust and understanding. Those are the types of opportunities that we think we can really help with.

**中文翻译:**
但我们发现，行为风险越大，这套方法就越有效。如果你只是想做一个现有产品的略微改良版，比如更便宜、更快或更容易用一点，你可能不需要这些。你直接去做就行，大概率能成。但如果你像我们投资的一家公司那样——他们做控制工业设施的 AI。他们来自 Google DeepMind，以前为 Google 数据中心做这个。在这种情况下，你必须说服那些戴着安全帽、操作巨型设备的工厂操作员去信任 AI。这是一个巨大的行为转变，一个巨大的行为风险。或者在医疗、教育领域，在这些技术能真正造福人类但很难跨越信任和理解障碍的地方。这些就是我们认为能真正帮上忙的机会类型。

---

### [01:34:50] Lenny

**English:**
Playing on hard mode, these sounds extremely difficult. I love it.

**中文翻译:**
开启了“困难模式”，听起来极其困难。我喜欢。

---

### [01:34:53] John Zeratsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:34:54] Lenny

**English:**
So if you're thinking about starting a company or if you're in the process of starting a company, check out character.vc/ labs. John, Jake, thank you so much for being here and for making time for this podcast conversation.

**中文翻译:**
所以如果你正在考虑创业或正在创业过程中，请访问 character.vc/labs。John，Jake，非常感谢你们来到这里，并为这次播客对话腾出时间。

---

### [01:35:06] John Zeratsky

**English:**
Thank you for having us. This was great.

**中文翻译:**
谢谢邀请。这次谈话很棒。

---

### [01:35:08] Jake Knapp

**English:**
Yeah, thanks for having us.

**中文翻译:**
是的，谢谢邀请。

---

### [01:35:09] Lenny

**English:**
Absolutely. My pleasure.

**中文翻译:**
当然，这是我的荣幸。

---

### [01:35:10] Jake Knapp

**English:**
It was really a pleasure, Lenny.

**中文翻译:**
真的很愉快，Lenny。

---

### [01:35:10] Lenny

**English:**
The pleasure is mine. Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
荣幸之至。大家再见。非常感谢大家的收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。