# Janna Bastow - 双语对照

This is a comprehensive bilingual transcript of the key segments from **Lenny’s Podcast featuring Janna Bastow**, the inventor of the Now-Next-Later roadmap and co-founder of ProdPad.

---

### [00:00:00] [Lenny Rachitsky]

**English:**
Janna Bastow is the person who invented the Now-Next-Later roadmap. She’s also the co-founder of ProdPad and Mind the Product. In our conversation, we talk about why roadmaps with dates are essentially just lists of lies, how to move your team to an outcome-based roadmap, and how to use the Now-Next-Later framework to build better products.

**中文翻译:**
Janna Bastow 是“现阶段-后续-未来”（Now-Next-Later）产品路线图的发明者。她也是 ProdPad 和 Mind the Product 的联合创始人。在我们的对话中，我们讨论了为什么带有具体日期的路线图本质上只是一连串的谎言，如何将你的团队转向基于成果（outcome-based）的路线图，以及如何利用 Now-Next-Later 框架来打造更好的产品。

---

### [00:02:15] [Janna Bastow]

**English:**
The roadmap is a prototype for your strategy. It’s not a project plan. Most people mistake the two. A project plan is about output—it’s about when a specific feature is going to be delivered. A roadmap should be about outcomes—what problems are we solving and why does it matter to the business?

**中文翻译:**
路线图是你战略的原型，它不是项目计划。大多数人把这两者搞混了。项目计划关注的是产出（output）——即某个具体功能何时交付。而路线图应该关注成果（outcomes）——我们正在解决什么问题，以及为什么这对业务很重要？

---

### [00:05:40] [Lenny Rachitsky]

**English:**
You’ve famously said that roadmaps with dates are "lists of lies." That’s a pretty bold statement. Can you unpack why you feel so strongly about that?

**中文翻译:**
你有一句名言，说带有日期的路线图是“谎言清单”。这是一个非常大胆的说法。你能详细解释一下为什么你对此深有感触吗？

---

### [00:06:02] [Janna Bastow]

**English:**
The minute you put a date on a roadmap, you’re making a promise that you don’t know if you can keep. In product development, there’s so much uncertainty. You don’t know what you’re going to find when you start digging into the code or when you start testing with users. By putting a date on it, you’re prioritizing hitting a deadline over actually solving the problem. It forces teams to cut corners and deliver "crap" just to say they finished on time.

**中文翻译:**
一旦你在路线图上标注了日期，你就在许下一个你不知道能否兑现的承诺。在产品开发中，存在着巨大的不确定性。当你开始深入研究代码或开始用户测试时，你不知道会发现什么。通过标注日期，你实际上是在将“赶上截止日期”置于“真正解决问题”之上。这会迫使团队偷工减料，交付“垃圾”产品，仅仅为了能说他们按时完成了任务。

---

### [00:12:30] [Janna Bastow]

**English:**
This is where the Now-Next-Later framework comes in. It’s designed to communicate priority without the false precision of a timeline. "Now" are the things you are currently working on—the things you have the most clarity on. "Next" are the things coming up soon, where you have some definition but are still refining. "Later" is the stuff that’s further out, the big ideas that align with your vision but haven't been fully scoped yet.

**中文翻译:**
这就是“现阶段-后续-未来”（Now-Next-Later）框架发挥作用的地方。它的设计初衷是为了传达优先级，而不是使用时间线那种虚假的精确感。“现阶段”（Now）是你目前正在做的事情——也就是你最清晰明确的事情。“后续”（Next）是即将到来的事情，你已经有了一些定义，但仍在细化。“未来”（Later）是更远的事情，是符合你愿景的大想法，但尚未完全确定范围。

---

### [00:18:45] [Lenny Rachitsky]

**English:**
How do you handle stakeholders, like a CEO or a Sales team, who are demanding to know exactly when a feature will be ready? They usually want a date so they can tell a customer or plan a marketing launch.

**中文翻译:**
你如何处理那些要求明确知道功能何时就绪的利益相关者（stakeholders），比如 CEO 或销售团队？他们通常想要一个日期，以便告诉客户或计划营销发布。

---

### [00:19:15] [Janna Bastow]

**English:**
You have to change the conversation from "When will it be done?" to "What problem are we trying to solve?" If Sales says they need a feature by Q3 to close a deal, ask them what the customer is actually trying to achieve. Often, you can solve that customer's problem in a simpler way much sooner, or you might realize that the requested feature doesn't actually align with the broader product strategy. You have to trade the "illusion of certainty" for "clarity of intent."

**中文翻译:**
你必须将对话从“什么时候能做完？”转变为“我们试图解决什么问题？”如果销售部门说他们需要在第三季度完成某个功能以达成交易，请问他们客户到底想实现什么。通常，你可以更早地用更简单的方法解决客户的问题，或者你可能会意识到所要求的功能实际上与更广泛的产品战略不符。你必须用“确定性的幻觉”去换取“意图的清晰度”。

---

### [00:25:10] [Janna Bastow]

**English:**
An outcome-based roadmap is built around objectives. Instead of saying "We are building a Slack integration," you say "We want to increase user retention by improving our integration ecosystem." This gives the product team the freedom to experiment. If the Slack integration doesn't work, they aren't "failing" the roadmap; they are just looking for a different way to hit that retention objective.

**中文翻译:**
基于成果的路线图是围绕目标（objectives）构建的。与其说“我们正在构建 Slack 集成”，不如说“我们希望通过改善集成生态系统来提高用户留存率”。这给了产品团队实验的自由。如果 Slack 集成不起作用，他们并没有在路线图上“失败”；他们只是在寻找另一种实现留存目标的方法。

---

### [00:32:40] [Lenny Rachitsky]

**English:**
What are some common mistakes you see when teams try to adopt Now-Next-Later?

**中文翻译:**
当团队尝试采用 Now-Next-Later 框架时，你看到的常见错误有哪些？

---

### [00:33:05] [Janna Bastow]

**English:**
The biggest mistake is treating "Now, Next, Later" as just columns for "This month, Next month, Month after." If you do that, you’ve just built a Gantt chart in disguise. Another mistake is putting too much in the "Now" column. If everything is a priority, nothing is. "Now" should be limited to what the team can actually focus on and finish.

**中文翻译:**
最大的错误是将“现阶段、后续、未来”仅仅视为“本月、下月、再下月”的代名词。如果你这样做，你只是构建了一个伪装的甘特图（Gantt chart）。另一个错误是在“现阶段”列中放入太多内容。如果每件事都是优先级，那就没有优先级。“现阶段”应该仅限于团队真正能够集中精力并完成的工作。

---

### [00:45:20] [Lenny Rachitsky]

**English:**
For someone listening who is stuck in a heavy "feature factory" environment with strict deadlines, what’s the first step they can take to start moving toward this better way of working?

**中文翻译:**
对于那些听众中正困在严格截止日期的“功能工厂”（feature factory，指只管堆功能而不顾效果的环境）里的人，他们可以采取的第一步是什么，从而开始转向这种更好的工作方式？

---

### [00:45:45] [Janna Bastow]

**English:**
Start by adding a "Problem" or "Objective" column to your existing roadmap. Even if you have to keep the dates for now, start labeling *why* you are doing each item. Once people see the value in discussing the problems, the dates start to matter less. You’re essentially training your stakeholders to think about value rather than just delivery dates.

**中文翻译:**
首先在现有的路线图中添加一个“问题”或“目标”栏。即使你现在必须保留日期，也要开始标注你做每一项工作的*原因*。一旦人们看到了讨论问题的价值，日期就会变得不那么重要了。你本质上是在训练你的利益相关者去思考价值，而不仅仅是交付日期。

---

### [00:55:00] [Lenny Rachitsky]

**English:**
Janna, thank you so much for joining us. Where can people find you and learn more about ProdPad?

**中文翻译:**
Janna，非常感谢你加入我们。大家可以在哪里找到你并了解更多关于 ProdPad 的信息？

---

### [00:55:15] [Janna Bastow]

**English:**
You can find me on Twitter or LinkedIn, and you can check out ProdPad.com. We have a lot of resources there on how to build outcome-based roadmaps and move away from the timeline trap.

**中文翻译:**
你可以在 Twitter 或 LinkedIn 上找到我，也可以访问 ProdPad.com。我们在那里有很多关于如何构建基于成果的路线图以及如何摆脱时间线陷阱的资源。