# Jason Feifer - 双语对照

# Lenny's Podcast: Jason Feifer (Full Transcript Bilingual Document)

---

### (00:00:00) Jason Feifer

**English:**
The editor, the writer, I'll just say it as plainly as possible. They don't care about you. They don't care about you. They care about their reader or their listener or their viewer. That's who they care about. That's who they're serving, and if you can be of use to them in sharing the kinds of information that they are looking to serve their audience, then you can get what you want. But you can't treat them like a service provider because they're not. And so you have to approach them with an understanding of what they're trying to do for their audience and how you can fit into that because if you don't, they are not interested in you.

**中文翻译:**
编辑、作者，我会尽可能直白地说出来：他们并不关心你。他们真的不在乎你。他们在乎的是他们的读者、听众或观众。那才是他们关心的人，那是他们服务的对象。如果你能在分享信息时对他们有用，提供他们想要服务受众的那类信息，那么你就能得到你想要的。但你不能把他们当成服务提供商，因为他们不是。所以，你必须在接触他们时，理解他们想为受众做什么，以及你如何融入其中。如果你不这样做，他们对你一点兴趣都没有。

---

### (00:00:47) Lenny

**English:**
Today, my guest is Jason Feifer. Jason is editor in chief at Entrepreneur Magazine, previously an editor at Fast Company and a number of other magazines. He's also an author, podcast host, keynote speaker, and startup advisor. In our conversation, we get incredibly tactical about how to get press for your product. Jason shares how to pitch a journalist, how to find the right journalist to pitch, what publications to consider, why freelance writers are more likely to write about your story, why the mission of the publication is so important in how you pitch them, plus what channels to use to reach out to journalists, how to think about your goals and what success looks like from getting press, so much more.

**中文翻译:**
今天的嘉宾是 Jason Feifer。Jason 是《企业家》（Entrepreneur）杂志的总编辑，此前曾担任《快公司》（Fast Company）等多家杂志的编辑。他还是作家、播客主持人、主旨演讲者和初创企业顾问。在我们的对话中，我们将非常深入地探讨如何为你的产品获得媒体报道。Jason 分享了如何向记者投递（pitch）方案、如何找到合适的记者、应该考虑哪些出版物、为什么自由撰稿人更有可能报道你的故事、为什么出版物的使命对你的投递方式至关重要，以及联系记者的渠道、如何思考你的目标、媒体报道成功的定义等等。

---

### (00:01:25) Lenny

**English:**
I learned a ton from this conversation, and if you're looking to get press for your stuff, you'll find so much value here. With that, I bring you Jason Feifer after a short word from our sponsors. This episode is brought to you by Sidebar. Are you looking to land your next big career move or start your own thing? One of the most effective ways to create a big leap in your career, and something that worked really well for me a few years ago, is to create a personal board of directors, a trusted peer group where you can discuss challenges you're having, get career advice, and just kind of gut check how you're thinking about your work, your career, and your life. This has been a big trajectory changer for me, but it's hard to build this trusted group.

**中文翻译:**
我从这次对话中学到了很多，如果你正想为自己的产品争取媒体曝光，你会发现这里干货满满。在简短的赞助商广告后，我们将迎来 Jason Feifer。本集节目由 Sidebar 赞助。你是否正在寻求职业生涯的下一次重大飞跃，或者准备创业？实现职业跨越最有效的方法之一（也是几年前对我非常有用的方法），就是建立一个“个人董事会”——一个值得信赖的同行群体，你可以与他们讨论挑战、获取职业建议，并对你的工作、事业和生活想法进行直觉检查。这对我来说是职业轨迹的重大转折点，但建立这样一个信任群体并不容易。

---

### (00:02:05) Lenny

**English:**
With Sidebar, senior leaders are matched with highly vetted, private, supportive peer groups to lean on for unbiased opinions, diverse perspectives, and raw feedback. Everyone has their own zone of genius, so together, we're better prepared to navigate professional pitfalls, leading to more responsibility, faster promotions, and bigger impact. Guided by world-class programming and facilitation, Sidebar enables you to get focused tactical feedback at every step of your journey. If you're a listener of this podcast, you're likely already driven and committed to growth. A Sidebar personal board of directors is the missing piece to catalyze that journey. Why spend a decade finding your people when you can meet them at Sidebar today? Jump the growing wait list of thousands of leaders from top tech companies by visiting sidebar.com/lenny to learn more. That's sidebar.com/lenny.

**中文翻译:**
通过 Sidebar，资深领导者可以与经过严格筛选、私密且相互支持的同行群体匹配，从而获得公正的意见、多元的视角和原始的反馈。每个人都有自己的天才领域，因此聚在一起，我们能更好地应对职业陷阱，从而承担更多责任、获得更快晋升并产生更大影响。在世界级项目和引导的指导下，Sidebar 让你在旅程的每一步都能获得专注的战术反馈。如果你是本播客的听众，你可能已经充满动力并致力于成长。Sidebar 的个人董事会正是催化这一旅程所缺失的关键一环。为什么要花十年时间寻找志同道合的人，而现在就可以在 Sidebar 遇见他们？访问 sidebar.com/lenny 了解更多信息，跳过数千名来自顶尖科技公司领导者的等待名单。网址是 sidebar.com/lenny。

---

### (00:02:46) Lenny

**English:**
This episode is brought to you by Maui Nui Venison, a mission-based food company, bringing the healthiest red meat on the planet directly to your door. I actually joined Maui Nui Venison earlier this year after hearing their app on the Tim Ferriss Podcast, and I'm excited to be spreading the message further. Not only does this company provide the most nutrient-dense and protein-dense red meat available, their operation produces the only stress-free 100% wild harvested red meat on the market that is the only one of its kind in the world, actively managing Maui's invasive axis deer populations, helping to restore balanced, vulnerable ecosystems, food systems and communities in Hawaii.

**中文翻译:**
本集节目由 Maui Nui Venison 赞助，这是一家以使命为导向的食品公司，将地球上最健康的红肉直接送到你家门口。我是在听了 Tim Ferriss 播客后，于今年早些时候加入 Maui Nui Venison 的，很高兴能进一步传播这个消息。这家公司不仅提供营养最丰富、蛋白质含量最高的红肉，他们的运作还生产出市场上唯一的无压力、100% 野生捕获的红肉，这在世界上是独一无二的。他们通过积极管理茂宜岛（Maui）入侵的轴鹿种群，帮助恢复夏威夷平衡且脆弱的生态系统、食品系统和社区。

---

### (00:03:33) Lenny

**English:**
Also, it is seriously delicious. Not at all [inaudible 00:03:37] and easy to cook. My wife and I made stew and steaks and all kinds of grilled goodies with the meat. We also feel great about it as a protein from an ethical standpoint. I highly recommend trying their all-natural Venison jerky sticks for an optimal protein snack, as well as a wide variety of fresh cuts, all available in their online butcher shop. There are limited memberships available, but you can sign up and get 20% off your first order at mauinuivenison.com/lenny. That's mauinuivenison.com/lenny. Jason, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
而且，它真的非常好吃。一点也不膻，而且很容易烹饪。我和妻子用这种肉做了炖肉、牛排和各种烧烤美食。从伦理角度来看，作为一种蛋白质来源，我们也感觉非常好。我强烈推荐尝试他们的全天然鹿肉干条作为优质蛋白质零食，以及他们在线肉店提供的各种新鲜切块。会员名额有限，但你可以注册并在 mauinuivenison.com/lenny 享受首单八折优惠。网址是 mauinuivenison.com/lenny。Jason，非常感谢你能来，欢迎来到本播客。

---

### (00:04:13) Jason Feifer

**English:**
Lenny. Thanks for having me.

**中文翻译:**
Lenny，谢谢你邀请我。

---

### (00:04:14) Lenny

**English:**
It's absolutely my pleasure. We've actually collaborated on a couple of things recently, and as we were chatting about some stuff, I was asking for advice on how to help a startup I'm working with get press, and you shared a bunch of killer advice, and so I asked if you could just come on this podcast and share similar advice for how to help startups get press and here we are.

**中文翻译:**
这是我的荣幸。我们最近其实合作了几件事，在聊天时，我向你请教如何帮助我正在合作的一家初创公司获得媒体报道，你分享了一堆非常棒的建议。所以我问你是否愿意来播客分享类似的关于如何帮助初创公司获得报道的建议，于是我们就有了这次对话。

---

### (00:04:36) Jason Feifer

**English:**
Yeah, I'm really happy that you asked me to do that. This is something people ask me about a lot. I've been in media for decades. I've worked at a lot of different magazines. Obviously, I run Entrepreneur Magazine now, but I was a Fast Company. I was at Men's Health, so I've seen a lot of different sides of media, and it is a very misunderstood tool, particularly for people in business, and so I love demystifying it.

**中文翻译:**
是的，很高兴你邀请我。这是很多人经常问我的问题。我在媒体行业干了几十年，在很多不同的杂志工作过。显然，我现在经营《企业家》杂志，但我以前在《快公司》和《男士健康》（Men's Health）待过，所以我见过媒体的很多不同面。对于商业人士来说，媒体是一个被严重误解的工具，所以我很乐意揭开它的神秘面纱。

---

### (00:05:00) Lenny

**English:**
Amazing. I'm excited to learn all this too, and so thanks for doing this. First question is just, as someone in press, how much volume is there coming at you from startup founders and PR people trying to get you to write about them and also just reporters that you work with?

**中文翻译:**
太棒了。我也很期待学习这些，谢谢你。第一个问题是，作为媒体人，有多少初创公司创始人和公关人员（PR）试图让你报道他们？还有你合作的记者，这种信息量有多大？

---

### (00:05:15) Jason Feifer

**English:**
Yeah, it's tremendous. It's ridiculous. I would say that by the time we are done recording this podcast, I'll have, I don't know. I mean, it could be anywhere from 30 to 50 pitches in my inbox. It comes all day. Now, to be clear, most of that is garbage in the real garbagey sense, right. It's a lot of completely unrelevant press releases that were sent to me and a bazillion other people. But within, there are definitely some people who have spent the time to reach out very specifically to me, and everybody in media gets some kind of volume like that. To reach out to somebody in media is to be shouting over a lot of noise.

**中文翻译:**
非常巨大，简直荒谬。我想说，等我们录完这期播客，我的收件箱里可能已经多了 30 到 50 个投递方案。这种信息整天都在涌入。当然，说清楚点，其中大部分都是真正的垃圾，对吧。很多完全不相关的新闻稿被同时发给我和成千上万的人。但在这些信息中，确实有一些人花时间专门针对我进行联系。媒体行业的每个人都会收到这种体量的信息。联系媒体人就像是在巨大的噪音中呐喊。

---

### (00:06:01) Lenny

**English:**
Wow. I imagine we'll get to this later, but I'm curious just what percentage of those are PR people and press release versus a founder or someone that is doing it themselves?

**中文翻译:**
哇。我想我们稍后会谈到这个，但我很好奇，其中公关人员和新闻稿占多大比例？创始人或自己动手的人又占多少？

---

### (00:06:12) Jason Feifer

**English:**
The percentage of direct messages from founders that I'm getting is low. I would say probably 20, 25%. And then the 75% is PR in some capacity, either targeted PR where somebody's intentionally reaching out to me or mass blast press releases.

**中文翻译:**
我收到的创始人直接发来的消息比例很低。我猜大概只有 20% 到 25%。剩下的 75% 都是某种形式的公关，要么是有人刻意联系我的定向公关，要么是大规模群发的新闻稿。

---

### (00:06:30) Lenny

**English:**
You know what's crazy is I've been getting a lot of these now. People think I'm some kind of journalist, and they're just like embargoed announcement product launch.

**中文翻译:**
你知道疯狂的是什么吗？我现在也收到很多这种信息。人们以为我是某种记者，他们发来类似“禁止提前发布的公告”或“产品发布”之类的内容。

---

### (00:06:37) Jason Feifer

**English:**
It doesn't take much because you just end up on some list, and what's really interesting, and we'll talk about PR later, I know. But one of the great insights that you can get into the challenges of that industry is how completely automated a lot of it is where a lot of people in PR are not thinking specifically about how to tell the right story to the right potential media outlet. Instead, what they're doing is they're just playing a numbers game, and they're just blasting it out to everybody. And that means that you could end up... I write this newsletter, right. I have... Entrepreneur Magazine is the thing that people obviously would pitch, but then I have this newsletter where I don't interview anybody. There's no opportunity to be featured in my newsletter, and I still get pitches to the newsletter because somebody saw it and dropped it in some spreadsheet, and it just... now I get it. And I think that's a real disservice to entrepreneurs who are paying for people to do that, and I really hate that.

**中文翻译:**
这并不难，因为你只要出现在某个名单上就行了。非常有趣的一点是（我知道我们稍后会谈到公关），你可以洞察到这个行业挑战的一个关键点：很多工作完全是自动化的。很多公关人员并没有专门思考如何向合适的媒体讲述合适的故事。相反，他们只是在玩数字游戏，把信息群发给所有人。这意味着你可能会……比如我写这个时事通讯（newsletter），对吧。人们显然会向《企业家》杂志投递，但我这个时事通讯不采访任何人，根本没有被报道的机会，但我仍然会收到投递，因为有人看到它并把它放进了某个电子表格里，然后我就收到了。我认为这对那些付钱请人做这些事的企业家来说是一种极大的损害，我真的很讨厌这一点。

---

### (00:07:41) Lenny

**English:**
Yeah. Okay, so we're going to get into the meat of just how actually do this well, but a couple more questions just to set a little context. One is in terms of impact. What kind of impact have you seen from getting press for a startup in terms of growth for their product specifically?

**中文翻译:**
是的。好，我们接下来要进入如何做好这件事的核心内容，但在那之前再问几个问题来做个铺垫。一个是关于影响力。你见过初创公司获得媒体报道后，对其产品增长产生的具体影响是什么样的？

---

### (00:07:57) Jason Feifer

**English:**
So it's a really wide range. I have had entrepreneurs tell me that a single story in Entrepreneur Magazine, like the print magazine or just online, will drive more, whatever more app downloads, more sales that month than any of their paid marketing efforts. But then I have also heard entrepreneurs tell me that it didn't do anything for them or that it did one very specific thing for them, which is to say maybe some potential partner read it and reached out, and it started an interesting conversation. It's all over the gamut, and it's a really important thing for people to remember is that this is not something that I think that you should bank on as a strategy for growth. It's a great add-on. But if you think that press by itself is going to solve your problems, you're wrong because it might, but it's way too unpredictable.

**中文翻译:**
范围非常广。有企业家告诉我，《企业家》杂志的一篇报道（无论是纸刊还是在线版），那个月带来的应用下载量或销售额比他们任何付费营销活动都要多。但我也听过企业家说，报道对他们毫无作用，或者只起到了一点非常具体的作用，比如某个潜在合作伙伴读了报道后联系了他们，开启了一段有趣的对话。情况各异，大家必须记住：我不认为你应该把媒体报道当作核心增长策略。它是一个很好的补充，但如果你认为媒体报道本身就能解决你的问题，那你就错了。因为它可能有帮助，但太不可预测了。

---

### (00:08:48) Lenny

**English:**
Is there anything else along those lines of just when it's worth somebody investing time into getting press, either stage of startup, type of startup, any just general broad advice of you should not be spending time on trying to get press versus this is a really good opportunity for you.

**中文翻译:**
关于什么时候值得投入时间去争取媒体报道，还有什么建议吗？比如初创公司的阶段、类型，或者任何宽泛的建议，告诉大家什么时候不该花时间去争报道，什么时候又是一个绝佳的机会？

---

### (00:09:02) Jason Feifer

**English:**
Think about press the same way that you think about raising money, which is to say you do it when you know what the money is for, and you should do it when you know what the press is for. A lot of people reach out to me at such an early stage that if we wrote about them, it wouldn't get them anything. They're not at a stage where they could use that press in any meaningful way, and so there's really no purpose in chasing it now. You should step back and think really as a starting point, "What do I need press for?" And if you have a good tactical answer to that, that could be because I need to drive awareness to a new product. That could be because I'm going out to raise money, and I need articles to show that the marketplace takes me seriously.

**中文翻译:**
对待媒体报道要像对待融资一样：只有当你清楚这笔钱要用来做什么时，你才去融资；同理，只有当你清楚报道要用来做什么时，你才去争取报道。很多人在非常早期就联系我，以至于如果我们报道了他们，也不会给他们带来任何好处。他们还没到能以任何有意义的方式利用报道的阶段，所以现在追求报道毫无意义。你应该退一步，从起点开始思考：“我为什么需要媒体报道？”如果你有一个好的战术性答案，比如“我需要提高新产品的知名度”，或者“我要去融资，我需要文章来证明市场对我的认可”，这些都是好理由。

---

### (00:09:55) Jason Feifer

**English:**
These are good reasons, but I get a lot of emails. It's funny because people are... like entrepreneurs, in particular, they're just so vulnerable, and it's kind of a wonderful way sometimes. And sometimes people will just email me, and they'll just say, "You know, I've worked really hard, and I just feel like I deserve this." I respect that, and I relate to it in some ways with my own trying to get attention for my own work. But, "I deserve this" that's not a good tactical decision for your business that doesn't do anything for you. And so I would put that to the side and only think of press as you don't go out and raise money if you don't know what the money is for. You shouldn't go out and try to get press if you don't know what the press is for.

**中文翻译:**
这些都是正当理由，但我收到很多邮件，有趣的是，人们……尤其是企业家，有时表现得非常感性。有时人们发邮件给我说：“你看，我工作非常努力，我觉得我理应得到报道。”我尊重这种情感，在某种程度上，当我为自己的工作寻求关注时也能感同身受。但是，“我理应得到”并不是一个好的商业战术决策，它对你的业务没有任何帮助。所以我会把这种想法放在一边，只把媒体报道看作一种工具：如果你不知道钱怎么花，就不要去融资；如果你不知道报道有什么用，就不要去争取报道。

---

### (00:10:38) Lenny

**English:**
I'm curious to hear other examples when it's not, when it's a bad idea because, as like I said, an outside observer, I would always love to get more attention for my product and more people to be aware of it, more people to check it out. Is there an example or anything that comes to mind of there's no need for you to do that in this moment or for this product?

**中文翻译:**
我很想听听其他“不适合”的例子，或者什么时候是个坏主意。因为作为一个外部观察者，我总是希望我的产品能获得更多关注，让更多人知道并试用。有没有什么例子让你觉得“此时此刻”或“对于这个产品”完全没必要争取报道？

---

### (00:10:55) Jason Feifer

**English:**
Oftentimes, it's not even about the moment, but it's about the publication. So I'll give you an example. I spoke at an event once, and afterwards, this guy comes up to me, and he has a small hot dog food truck business in Washington, DC. So he said he's got a couple trucks, and he's doing good business selling hot dogs, and he wants coverage in Entrepreneur Magazine. He's like, "Oh, how can I get a feature?" And the problem with that instinct that he has is that he's really directing his energy in the wrong place because if he is selling hot dogs in Washington, DC, then I understand what press is for him. Press is to drive hotdog sales. That's what he wants to do. Entrepreneur is not going to do that for him. Full stop. Why? Because Entrepreneur reaches a national to international audience.

**中文翻译:**
通常这甚至与时机无关，而与出版物有关。我给你举个例子。有一次我在一个活动上演讲，结束后有个男人走过来，他在华盛顿特区经营一家小型热狗餐车生意。他说他有几辆车，生意不错，他想在《企业家》杂志上获得报道。他问：“我怎么才能获得专题报道？”他这种本能的问题在于，他把精力放错了地方。如果他在华盛顿卖热狗，我明白媒体报道对他意味着什么：报道是为了带动热狗销量。这就是他的目的。但《企业家》杂志帮不了他，绝对不行。为什么？因为《企业家》的受众是全国乃至国际性的。

---

### (00:11:52) Jason Feifer

**English:**
So that means that 99.5% of the people who would read a story about this guy have no ability to go get his hotdogs, which means that that was wasted effort. So fine. Was it that hard to come up and talk to me at the conference? No. But scale that out. How many emails is he sending that are like that? How much energy is he putting into chasing things that ultimately don't have good direct value to him? What he needs to do is think, "Okay, my goal, get more people to buy hot dogs. Where am I? I'm in Washington, DC. How can I reach people who are interested in food in my market?" So stop chasing Entrepreneur and start chasing the local eater or the food section of the Washingtonian or something like that. That small shift can give you a lot more payoff for your effort.

**中文翻译:**
这意味着 99.5% 读到他故事的人都没法去买他的热狗，也就是说他的努力白费了。在会议上找我聊聊倒没什么，但放大来看，他发了多少类似的邮件？他在追求那些最终对他没有直接价值的事情上投入了多少精力？他需要做的是思考：“好，我的目标是让更多人买热狗。我在哪？我在华盛顿特区。我该如何接触到我所在市场中对食物感兴趣的人？”所以，别再盯着《企业家》了，去联系当地的美食博主，或者《华盛顿人》（Washingtonian）杂志的美食版块。这个小小的转变能让你的努力获得大得多的回报。

---

### (00:12:38) Lenny

**English:**
This is a good segue to just let's just dive into how to actually go about getting press, and I know you kind of have this three-step structure for thinking about it. Maybe just start with what are the three steps, and then we'll dive into each one.

**中文翻译:**
这是一个很好的过渡，让我们深入探讨如何实际获得媒体报道。我知道你有一个三步走的结构。也许可以先从这三步是什么开始，然后我们再逐一深入。

---

### (00:12:50) Jason Feifer

**English:**
Yeah, sure. So I mean, look, it is pretty simple, right. Step one is prep. You want to be thinking about how to tell your story. You want to be thinking about the kinds of stuff I just talked about. What is press for for you? Everything that you need to do to orient yourself towards what is this opportunity, and why am I chasing it, and how to make the most of it. Step two is figuring out who to pitch. Not all press is created equal. There are not reasons to just go chasing everybody arbitrarily. The hotdog example is a good one.

**中文翻译:**
好的。其实很简单。第一步是准备（Prep）。你要思考如何讲述你的故事，思考我刚才提到的那些内容：媒体报道对你意味着什么？你需要做的一切都是为了明确：这个机会是什么，我为什么要追求它，以及如何充分利用它。第二步是确定投递对象（Who to pitch）。并非所有的媒体报道都是平等的，没有理由随意追求所有人。热狗的例子就是一个很好的证明。

---

### (00:13:19) Jason Feifer

**English:**
So finding the writers and editors who you're actually going to reach out to, who are going to most receptive to you. And also making sure that because you did the prep, you can figure out how to tell your story in a way that they're going to be interested in. We'll talk about that. And then step three is the actual pitch. What does it mean to reach out to these people, to engage the writers and editors? How do you find them? What do you send them? What are you telling them? That's it.

**中文翻译:**
所以要找到那些你真正要去联系、且最容易接受你的作者和编辑。同时确保因为你做了准备，你能以他们感兴趣的方式讲述你的故事。我们稍后会详细讨论。第三步是实际投递（The Pitch）。联系这些人、与作者和编辑互动意味着什么？你怎么找到他们？你发给他们什么？你告诉他们什么？就是这些。

---

### (00:13:42) Jason Feifer

**English:**
I mean, right. But what you need to understand is that you're entering a world that probably doesn't operate the way in which you think it does, and I see that all the time as the recipient of pitches. People don't understand who they're reaching out to and how I and my colleagues think. We should maybe even start with that because a really important thing to understand just again, to go to the metaphor of the investors, you don't reach out to an investor if you don't understand what that investor does, what they're interested in, or what kinds of companies they invest in. You can't do that with media, either.

**中文翻译:**
但是，你需要明白的是，你正在进入一个运作方式可能与你想象完全不同的世界。作为投递方案的接收者，我经常看到这种情况。人们不理解他们联系的对象，也不理解我和我的同事是如何思考的。我们也许应该从这里开始，因为有一点非常重要：再次借用投资人的比喻，如果你不了解一个投资人是做什么的、他们对什么感兴趣、或者他们投资什么样的公司，你就不会去联系他们。对待媒体也是一样。

---

### (00:14:08) Jason Feifer

**English:**
So I get pitches every single day along the lines of, "How do I get coverage in Entrepreneur Magazine? How do I get a feature in Entrepreneur Magazine?" And to me, it always feels like they're ordering a hamburger from me. Like, "How do I get a hamburger from Entrepreneur Hamburgers, right?" They're treating me like a service provider. That my job is to provide press. And I get it because, of course, if you're an entrepreneur, and you're looking for press, then the writers and editors out there seem to be in the business of writing about people, and therefore, there's some service that they seem to provide, and you're trying to figure out how to get it. But that's not how the media thinks of themselves, right.

**中文翻译:**
我每天都会收到类似的投递：“我怎么才能在《企业家》杂志上获得报道？我怎么才能获得专题报道？”对我来说，这感觉就像他们在向我订购汉堡。就像在问：“我怎么从‘企业家汉堡店’买个汉堡？”他们把我当成了服务提供商，认为我的工作就是提供报道。我理解这种想法，因为如果你是一个寻求报道的企业家，外面的作者和编辑似乎就是以写人为生的，因此他们似乎提供某种服务，而你正试图弄清楚如何获得它。但媒体人并不这么看自己。

---

### (00:15:18) Jason Feifer

**English:**
The editor, the writer, I'll just say it as plainly as possible, they don't care about you. They don't care about you. They care about their reader, or their listener, or their viewer. That's who they care about. That's who they're serving. And if you can be of use to them in sharing the kinds of information that they are looking to serve their audience, then you can get what you want, but you can't treat them like a service provider because they're not. And so you have to approach them with an understanding of what they're trying to do for their audience and how you can fit into that. Because if you don't, they are not interested in you.

**中文翻译:**
编辑、作者，我再说一遍：他们不在乎你。他们关心的是他们的读者、听众或观众。那是他们服务的对象。如果你能提供他们想要服务受众的那类信息，你就能得到你想要的。但你不能把他们当成服务提供商。你必须带着对他们受众目标的理解去接触他们，并思考你如何融入其中。如果你不这样做，他们对你没兴趣。

---

### (00:15:49) Lenny

**English:**
I love that. And more... even specifically, what is it they're trying to do for their audience? I imagine it's just have something interesting that they want to read. Something they can learn. Something they're like, "Wow, I'm really excited to read this."

**中文翻译:**
我喜欢这个观点。更具体地说，他们想为受众做什么？我猜就是提供一些读者想看的有趣内容，一些他们能学到东西的内容，一些让他们觉得“哇，我很想读这个”的内容。

---

### (00:16:00) Jason Feifer

**English:**
Yeah. But it's going to be more specific based on the mission of each publication. So, for example, I've worked at two separate business titles. I was a senior editor at Fast Company for a number of years, and now I'm the editor-in-chief of Entrepreneur Magazine. The decision that is made about whether or not a story belongs in a publication, it was totally different based on these two publications. So I can't speak to Fast Company now because they've gone through a couple of leadership changes. I don't know what their mission is, but back when I worked there under Bob Safian, he was the editor-in-chief, that was really a magazine about where businesses going, and the stories that were in the magazine were all supposed to be in some way representative of the evolution of business.

**中文翻译:**
是的，但根据每个出版物的使命，这会更具体。例如，我曾在两个不同的商业刊物工作。我在《快公司》做了几年的资深编辑，现在是《企业家》杂志的总编辑。关于一个故事是否属于某个出版物的决定，在这两家杂志上是完全不同的。我现在不能代表《快公司》说话，因为他们经历了几次领导层变动，我不知道他们现在的使命是什么。但在我当时的总编辑 Bob Safian 领导下，那是一本关于“商业走向何方”的杂志，杂志里的故事都应该在某种程度上代表商业的演变。

---

### (00:16:50) Jason Feifer

**English:**
And so when people would pitch what we'd really be looking for are, are there insights into... in what this person is doing that other people could read and say, "Aha, that helps me understand where this industry is going or that industry, or it helps me think about how I can shape my own company to match current trends," that kind of stuff. Entrepreneur, totally different mission. The way that I think of Entrepreneur is that it's not even a magazine about business. It's a magazine about thinking. Or what I want to do is make sure that everybody who comes to the magazine walks away with great insights into how to think through the challenges in their business.

**中文翻译:**
所以当人们投递时，我们真正寻找的是：这个人的所作所为是否能提供洞察，让其他人读后会说：“啊哈，这帮我理解了这个行业或那个行业的走向，或者帮我思考如何调整自己的公司以适应当前趋势。”而《企业家》的使命完全不同。我对《企业家》的看法是，它甚至不是一本关于商业的杂志，而是一本关于“思维”的杂志。我想做的是确保每个读这本杂志的人都能带着关于如何思考商业挑战的深刻见解离开。

---

### (00:17:29) Jason Feifer

**English:**
And so what I'm looking for when somebody reaches out is did they make some interesting counterintuitive decision that solved a problem in their business, and I'll emphasize in. Because, oftentimes, when people hear me talk about solving problems in business, they think, "Aha, but I solve a problem in business, right. I saw that there weren't the best razors in the world, and I made the best razors." That's not what I'm talking about. What I'm talking about is... There's this woman whose name is Joelle Mertzel. She has a company called Kitchen Concepts Unlimited, and she makes a butter dish, and it's a really smart butter dish because it is built on a hinge, right. So this is designed to solve a very specific problem, which Lenny, I don't know if you knew this, I did not, that you don't need to refrigerate butter. Did you know that?

**中文翻译:**
所以当有人联系我时，我寻找的是：他们是否做出了某些有趣的、反直觉的决定来解决他们业务“内部”的一个问题。我强调“内部”，因为通常当人们听到我谈论解决商业问题时，他们会想：“啊哈，我解决了商业问题啊，我发现世界上没有最好的剃须刀，所以我制造了最好的剃须刀。”那不是我所说的。我指的是……有一位叫 Joelle Mertzel 的女士，她有一家公司叫 Kitchen Concepts Unlimited，她做了一个黄油盒。这是一个非常聪明的黄油盒，因为它带铰链。这是为了解决一个非常具体的问题。Lenny，我不知道你是否知道，反正我以前不知道：黄油其实不需要冷藏。你知道吗？

---

### (00:18:18) Lenny

**English:**
I knew that intellectually, but I still refrigerate it. I know people don't.

**中文翻译:**
我理智上知道，但我还是会冷藏。我知道有些人不冷藏。

---

### (00:18:22) Jason Feifer

**English:**
Me too, even though I've had multiple conversations with this woman about this. You don't need to refrigerate butter, and if you leave it out, it cuts easier. It's more spreadable. Big problem, the butter dish. So most butter dishes you just lift up. And so if you have warm room temperature butter that's soft, and you lift the butter dish top up, you might bump into the butter, and it's going to make a big mess. So Joelle makes a butter dish on a hinge, right. Opens and closes exactly the same way every single time. No mess. Brilliant, solves a problem. She reaches out to me about this. This is not interesting to us, right. Maybe this is interesting for a cooking magazine, right. Maybe Bon Appétit is interested in this. Entrepreneur's not interested in this because that doesn't help other entrepreneurs to have thought through that problem.

**中文翻译:**
我也是，尽管我和这位女士聊过好几次。你不需要冷藏黄油，如果放在外面，它更容易切开，更容易涂抹。但黄油盒有个大问题：大多数黄油盒盖子是直接拿起来的。如果你有室温下变软的黄油，你拿起盖子时可能会碰到黄油，弄得一团糟。所以 Joelle 做了一个带铰链的黄油盒，每次开关方式都完全一样，不会弄脏。很棒，解决了一个问题。她因为这个联系我，但这对我来说并不有趣。也许烹饪杂志会感兴趣，比如《好胃口》（Bon Appétit），但《企业家》不感兴趣，因为这并不能帮助其他企业家思考他们的问题。

---

### (00:19:13) Jason Feifer

**English:**
But then she tells me something else. What she tells me is that she is, at the very beginning of this, trying to figure out how to answer some basic questions about her audience, like what colors do they want in this butter dish and what price point are they willing to pay? And she wants to do some market research. She goes to a market research company. She says, "How much would it cost to research consumers and answer these questions?" They say, $10,000. She doesn't have $10,000. And then, one day, she's sitting at the airport waiting to board a flight, and she looks around and she realizes that airports are full of people who have absolutely nothing better to do than answer questions about butter dishes, right. Nothing better to do, just sitting there. And you could start at gate one. By the time you get to gate eight, everyone in gate one is new. You could do it all over again, and you could have a 6:00 PM flight, and you could show up at 9:00 AM. Nobody's going to stop you. You can do this all day in the airport.

**中文翻译:**
但接着她告诉我了另一件事。她说在最开始，她想弄清楚关于受众的一些基本问题，比如他们想要什么颜色的黄油盒，愿意付多少钱。她想做市场调研，于是找了一家调研公司。她问：“调研消费者并回答这些问题需要多少钱？”对方说 1 万美元。她没有 1 万美元。然后有一天，她坐在机场等飞机，她环顾四周，意识到机场里到处都是除了回答关于黄油盒的问题外无事可做的人。他们就坐在那儿。你可以从 1 号登机口开始，等你走到 8 号登机口时， 1 号登机口的人已经换了一批。你可以重新开始。如果你是下午 6 点的飞机，你可以早上 9 点就到。没人会拦着你。你可以在机场干上一整天。

---

### (00:20:11) Jason Feifer

**English:**
And this is how she starts to do her own market research. She saves that $10,000, and she does it herself. I put that story in the magazine. It's tiny. It's this tiny random company and this random decision. But the reason I did it is because every time I repeat that story to entrepreneurs, they're all like, "Ugh, right, totally. There's always other ways to do things." They love the ingenuity of it. That's what I'm looking for. That's Entrepreneur's stories. So to go back to the point that you were making, it's not just about, "Well, it's a magazine called Entrepreneur. They must write about entrepreneurs, right. I'm an entrepreneur. I belong in Entrepreneur." People think that all the time. No. You have to step back and read what these publications are publishing and ask yourself, "What are they doing? What is the purpose here?"

**中文翻译:**
这就是她开始自己做市场调研的方式。她省下了那 1 万美元，亲力亲为。我把这个故事放进了杂志。它很小，是一个名不见经传的小公司和一个随意的决定。但我之所以这么做，是因为每次我向企业家重复这个故事时，他们都会说：“哇，没错，完全正确，总有别的方法可以解决问题。”他们喜欢这种独创性。这就是我寻找的东西。这就是《企业家》的故事。所以回到你刚才说的，这不仅仅是“既然杂志叫《企业家》，他们肯定会写企业家，对吧？我是企业家，所以我应该出现在《企业家》杂志上。”人们总是这么想。不。你必须退一步，阅读这些出版物发布的内容，问问自己：“他们在做什么？这里的目的是什么？”

---

### (00:21:13) Lenny

**English:**
That is such an interesting insight. I had no idea that that was something you should be thinking about. Is there an easy way to understand the mission of the publication? Is there an about page they often add this to or is it, like you said, you just read a bunch of stuff and try to suss it out?

**中文翻译:**
这真是一个有趣的见解。我完全没想到这是应该考虑的事情。有没有什么简单的方法来理解出版物的使命？他们通常会在“关于我们”页面写这些吗？还是像你说的，只能通过阅读大量内容来揣摩？

---

### (00:21:28) Jason Feifer

**English:**
Nobody publishes an about page in that way because the internal logic of the editorial team. But you can certainly make some starting assumptions based on who the publication is trying to reach. Everybody is trying to reach somebody. It gets more complicated the more general interest something becomes, right. What is the New York Times? What is the mission? That's a hard thing to answer. You sort of have to divide it up into sections, right. The mission of the National News Desk is different from the mission of the Business Desk, and even within there, the mission of the Sunday business section is different from the mission of the Monday to Saturday business section.

**中文翻译:**
没有人会以那种方式发布“关于我们”页面，因为那是编辑团队的内部逻辑。但你肯定可以根据出版物试图接触的对象做出一些初步假设。每个人都在试图接触某些人。内容越大众化，情况就越复杂。比如《纽约时报》是什么？它的使命是什么？这很难回答。你必须把它分成不同的版块。国内新闻部的使命与商业部的使命不同，甚至在商业部内部，周日商业版的使命也与周一至周六的商业版不同。

---

### (00:22:09) Lenny

**English:**
[inaudible 00:22:09].

**中文翻译:**
（听不清）。

---

### (00:22:09) Jason Feifer

**English:**
So you have to start to really parse it out. And this is the reason why people hire PR is because if they're good at their jobs, they understand a lot of this already. But I really do think that if you spent time with the content and your starting point is, "I understand that this publication is trying to reach X. They're trying to reach these people," then you can start to see the patterns of what it is that they're doing. How are they telling stories? What do these five stories all have in common? They have something in common. There's something that they're all doing, and you can certainly read the tea leaves and try to figure it out.

**中文翻译:**
所以你必须开始真正地去解析它。这就是人们雇佣公关的原因，因为如果他们擅长自己的工作，他们已经理解了其中的大部分。但我真的认为，如果你花时间研究内容，并且你的出发点是“我理解这个出版物试图接触 X 群体”，那么你就能开始看到他们运作的模式。他们是如何讲述故事的？这五个故事有什么共同点？它们肯定有共同点。他们在做同样的事情，你完全可以通过观察蛛丝马迹来弄清楚。

---

### (00:22:48) Lenny

**English:**
Awesome. Okay. It feels like we've already gone into step one around prep. What else is involved in preparing to get press?

**中文翻译:**
太棒了。感觉我们已经进入了第一步“准备”。准备获得媒体报道还涉及哪些内容？

---

### (00:22:57) Jason Feifer

**English:**
If we're talking about prep, the very first thing that you need to do is what I had said earlier, which is just ask yourself, what do I need press for? And you need a good answer to that question. And once you have that, the next thing you should do is you should start to think about, "Well, what's interesting about my business? And oftentimes, it's not necessarily what you think, and you can be guided in a way by what's happening in step two, where you start to think about who you're trying to reach out to. Because, for example, the story that somebody might tell me at Entrepreneur is going to be different than the story that somebody might tell Cosmo.

**中文翻译:**
说到准备，你首先要做的是我之前说的：问问自己，我为什么需要媒体报道？你需要一个好的答案。一旦有了答案，接下来你应该思考：“我的业务有什么有趣的地方？”通常，有趣的地方未必是你认为的那些。你可以参考第二步的内容，即你试图联系的对象。因为，例如，某人告诉《企业家》的故事，会与告诉《时尚》（Cosmo）的故事完全不同。

---

### (00:23:42) Jason Feifer

**English:**
There's a reason for a company to end up in, both Entrepreneur and Cosmo, right. Maybe the product is for young women. And so, Cosmo might be interested in some kind of product feature or including the product in a roundup of some kind of products. Whereas Entrepreneur would do the entrepreneur-focused story. What did this founder do? How they do they write? You can take your... You could think about your story and kind of break it up into a whole bunch of different little pieces and then figure out which piece goes to what media. But oftentimes, people make the mistake of trying to do that in reverse, which is to say that they kind of decide what narrative they would like to have out in the world, and then they just go around to different publications trying to sell them on that. I get that all the time.

**中文翻译:**
一家公司同时出现在《企业家》和《时尚》是有原因的。也许产品是面向年轻女性的，所以《时尚》可能对产品功能或将其列入产品合集感兴趣。而《企业家》则会做以企业家为中心的故事：这位创始人做了什么？他们是如何运作的？你可以把你的故事拆成很多不同的小块，然后弄清楚哪一块适合哪家媒体。但通常人们会犯反向操作的错误，也就是说，他们先决定自己想向世界展示什么样的叙事，然后跑遍不同的出版物试图推销这个叙事。我经常遇到这种情况。

---

### (00:24:34) Jason Feifer

**English:**
A lot of my pitches that I'll receive in my inbox are somebody who hasn't really thought at all about what Entrepreneur publishes but instead just has something that they would like to get out into the world. I mean, a good kind of dumb example is, yesterday, somebody sent me an email about a company that had just hired a new president. I don't care about that. That's not useful to my audience at all. I'm sure that there is a trade publication, right. Let's say that there was a company in the restaurant industry. I'm sure that a trade publication that follows the blow by blow by blow of a restaurant industry might be interested in your new president. But I'm not because you hiring that new president isn't useful to my audience. Stories in Entrepreneur are not really about the person that I'm writing about.

**中文翻译:**
我收件箱里收到的很多投递，对方根本没想过《企业家》发布什么内容，而只是想把自己的一些事宣扬出去。一个有点笨的例子是：昨天有人给我发邮件，说一家公司刚聘请了一位新总裁。我根本不在乎。这对我的受众一点用都没有。我确信会有行业刊物感兴趣，比如餐饮行业的刊物，他们追踪行业的每一个细节，可能会对你的新总裁感兴趣。但我没兴趣，因为你聘请新总裁对我的受众没用。《企业家》里的故事其实并不是关于我写的那个人的。

---

### (00:25:23) Jason Feifer

**English:**
They're really about the audience. They're really me serving the audience through the stories of the people I'm writing about. That's not useful. I wish that they had spent a moment and thought about that, but they didn't. So once you start to think about who it is that you're trying to reach, you can step back and say, "Well, what part of my journey is going to be most relevant to them? And I would push you to be really, really creative about it. Because if you go back to the Butterie example, the butter dish, that little funny story about the airport, I mean, who else is writing about that? It's not central to her story as a brand. It's not central to her sales pitch. It was just for us. We were probably the only publication in the world who cared about that, but I really cared about it.

**中文翻译:**
它们其实是关于受众的。我实际上是通过我所写的人的故事来服务受众。聘请总裁这种事没用。我希望他们能花点时间思考一下，但他们没有。所以一旦你开始思考你想接触谁，你就可以退一步说：“我的创业历程中哪一部分对他们最相关？”我会敦促你在这方面发挥极大的创造力。回到那个黄油盒的例子，那个关于机场的小趣闻，还有谁会写这个？这并不是她品牌故事的核心，也不是她销售话术的核心。它只是为了我们（《企业家》杂志）准备的。我们可能是世界上唯一关心那个故事的出版物，但我真的很在乎它。

---

### (00:26:11) Lenny

**English:**
Amazing. Okay, so just kind of summarizing what you shared, think about the goal. What are you trying to get out of press? Goals could be awareness of what we've done, something new, investor interest. What are some other common examples of goals that you see for trying to get press?

**中文翻译:**
太棒了。总结一下你分享的内容：思考目标。你想从媒体报道中得到什么？目标可以是提高知名度、发布新品、吸引投资者兴趣。你还见过哪些常见的争取媒体报道的目标？

---

### (00:26:27) Jason Feifer

**English:**
Yeah, awareness of something new. But also doesn't have to be awareness of something new, it could just be continued growth, trying to reach into a new marketplace. That's fine. Anything that's tied to growth or reaching a new customer base would make sense.

**中文翻译:**
是的，新品知名度。但不一定非得是新品，也可以是持续增长，或者试图进入一个新市场。这都没问题。任何与增长或接触新客户群相关的事情都有意义。

---

### (00:26:47) Jason Feifer

**English:**
But it could also be that you're looking to position yourself in your own marketplace a little differently. I see, for example, a lot of people, a lot of big companies, keep knocking on my door because we don't just hear from startups, we hear from major companies as well who are pitching stories. I know why they want to be an entrepreneur. They want to be an entrepreneur because they're trying to position their brand as also being relevant to small business owners. It's helpful to have that kind of context because coverage an entrepreneur can help them go out to the marketplace and say, "Look, we're also reaching X, Y, Z people."

**中文翻译:**
但也可能是你想在自己的市场中重新定位。例如，我看到很多大公司不断找上门来，因为我们不仅收到初创公司的投递，也会收到大公司的。我知道他们为什么想上《企业家》杂志。他们想上是因为他们试图将自己的品牌定位为与小企业主也相关的品牌。这种背景很有帮助，因为在《企业家》上的报道可以帮助他们走向市场并说：“看，我们也触达了 X、Y、Z 这些人群。”

---

### (00:27:25) Jason Feifer

**English:**
So sometimes it's not even about a conversion, but rather it's about a positioning and that's a good reason to also maybe put forward your executives. Sometimes it's just about establishing your CEO or your founder as an authority in a particular area because you want them to be more trustworthy, you want them to be invited to more conferences. Because all of that stuff draws more attention to the company, all sorts of reasons to do this stuff. And then trying to get in front of investors, trying to get in front of partners. Look, there's a million reasons why being visible can be useful, but you need to make sure you understand what you're actually trying to do.

**中文翻译:**
所以有时这甚至与转化无关，而是关于定位，这也是推举高管的一个好理由。有时只是为了将你的 CEO 或创始人塑造成特定领域的权威，因为你希望他们更值得信赖，希望他们被邀请参加更多会议。因为所有这些都能为公司吸引更多关注。做这些事有各种各样的理由。还有为了接触投资者、接触合作伙伴。总之，增加曝光度有无数个理由，但你必须确保自己清楚到底想达到什么目的。

---

### (00:28:07) Lenny

**English:**
Okay, awesome. That was really helpful. So think about what goal you have in mind for getting press, pick a publication and understand their mission and what their goals are. And then think about some interesting stories that you could pitch them. Not just like we have a new president, but something that you think they'd be excited to share that connects with their mission.

**中文翻译:**
好的，太棒了。这非常有帮助。所以：思考你争取媒体报道的目标，选择一家出版物并理解他们的使命和目标。然后思考一些你可以投递给他们的有趣故事。不只是“我们有了新总裁”，而是你认为他们会兴奋地分享、且符合他们使命的内容。

---

### (00:28:25) Jason Feifer

**English:**
That's right.

**中文翻译:**
没错。

---

### (00:28:26) Lenny

**English:**
Kind on this topic, I know we want to talk about who to contact and how to figure out who to actually talk to. A couple of questions that come to mind. This is all a lot of work. Founders are really busy. So begs the question, PR agencies, do you have a perspective on would you recommend working with PR agency? Is there a time when it makes to and doesn't make sense to?

**中文翻译:**
关于这个话题，我知道我们要讨论联系谁以及如何找到联系人。我想到几个问题。这些工作量很大，创始人非常忙。所以问题来了：关于公关公司（PR agencies），你有什么看法？你会推荐与公关公司合作吗？什么时候合适，什么时候不合适？

---

### (00:28:45) Jason Feifer

**English:**
Yeah, I mean it's a ton of work. Everything that I'm describing is a ton of work. And let me be clear, people succeed in getting press without doing any of the things that I'm describing because dumb luck happens in the world. You could very well just bang out an email to some random editor and they might like it. That is entirely possible. You could disregard everything that I've just said. What I'm really helping you do is try to optimize your approach. But yeah, hiring PR can cut out a lot of this. Now you're not doing this research yourself, you're not thinking through these challenges yourself. You're working with people who understand exactly how to identify the most interesting parts of your story and then turn them into good pitches. So why wouldn't everyone do that? The couple reasons. Number one, cost PR can be expensive, so you just have to factor that in. Number two, PR is and can be, I'll say can be, a very frustrating journey because a lot of PR people are very bad at their jobs. They're very bad.

**中文翻译:**
是的，这确实是海量的工作。我描述的一切都非常耗时。我要说明一点：即使不做我说的这些，人们也能成功获得报道，因为世上有“瞎猫碰到死耗子”这种事。你完全可能随手给某个编辑发封邮件，而他们正好喜欢。这完全可能。你可以无视我刚才说的一切。我真正帮你在做的是优化你的方法。但是，雇佣公关确实可以省去很多麻烦。你不需要自己做调研，不需要自己思考这些挑战。你是在与那些确切知道如何识别你故事中最有趣部分并将其转化为优秀投递方案的人合作。那为什么不是所有人都这么做呢？有几个原因。第一，成本。公关可能很贵，你必须考虑进去。第二，公关可能是一段非常令人沮丧的旅程，因为很多公关人员业务能力很差。真的很差。

---

### (00:29:52) Jason Feifer

**English:**
And this isn't just me bashing PR people. I have literally been hired to give keynotes at PR industry conferences. And I get on stage and I say most PR people are bad at their jobs and everybody nods. And they all know it. And of course, none of them think that they're one of the bad ones, but they all know it. PR is full of people who are bad at their jobs. Why are they bad at their jobs? They're bad at their jobs because they're lazy, because they're primarily relying upon email blasts, just sending things out, because they have a older idea of what it means to get the word out. For example, if you hire or talk to a PR agency and one of the things that they recommend doing that you should spend money on is a press release, like a traditional press release, run as fast as you can away from that. I don't know if you know this. Do you know this? The press release, there are some purposeful reasons to put out a press release, but the press release is really no longer the primary unit of press attraction.

**中文翻译:**
这不只是我在抨击公关。我真的被请去在公关行业会议上做主旨演讲。我上台说“大多数公关人员都不称职”，台下所有人都点头。他们心里都清楚。当然，没人觉得自己是差劲的那个，但他们都知道这个现状。公关行业到处是不称职的人。为什么？因为他们懒，因为他们主要依靠邮件群发，只是把东西发出去，因为他们对“传播”的理解还停留在旧时代。例如，如果你咨询一家公关公司，他们建议你花钱做传统的新闻稿（press release），赶紧跑，跑得越快越好。我不知道你知不知道：虽然发布新闻稿有一些特定目的，但新闻稿早已不再是吸引媒体报道的主要手段了。

---

### (00:31:07) Lenny

**English:**
Yeah, I get that sense.

**中文翻译:**
是的，我有这种感觉。

---

### (00:31:08) Jason Feifer

**English:**
Yeah. But here's what's fascinating. So a PR agency I wouldn't recommend might do this. They'll tell you, "We're going to put together a press release about this new thing, so you have to pay a little extra money for the production of this press release and then also the distribution of this press release because what we're going to do is we're going to put it out on the wire," because there are a whole bunch of press release distribution wires. So they'll do that, you'll pay the money, it'll go out on the wire. And then they'll send you a report about all the places that this press release ended up on. It ended up on Yahoo Finance, it ended up on Market Watch. And it technically did. The press release is there, it was posted. And zero people are going to see it in the whole world because Yahoo Finance has a section where they just publish every damn press release that gets published by all these different distributors. Nobody saw that.

**中文翻译:**
是的。但有趣的是：我不推荐的公关公司可能会这么做。他们会告诉你：“我们要为这个新产品写一份新闻稿，所以你需要额外支付制作费和发布费，因为我们要把它发到电讯稿分发渠道（wire）上。”他们会这么做，你付了钱，稿子发出去了。然后他们会给你一份报告，列出这份新闻稿出现在的所有地方：雅虎财经、Market Watch 等等。技术上讲，确实出现了，新闻稿就在那儿，被发布了。但全世界根本没人会看到它，因为雅虎财经有一个版块专门自动发布所有分发商发出的每一份该死的新闻稿。根本没人看。

---

### (00:32:08) Jason Feifer

**English:**
So don't confuse posting press releases even on very big websites with actual success. What you want in an actual PR person is someone who traffics in one thing, and that is relationships. The most important thing that a PR person can have is active relationships with people in media. Why? If a PR person is guaranteeing you press, that's another reason to run out the door as fast as possible because the PR people cannot control this. Writers and editors, they do what they want. It's a completely subjective industry and very frustrating. I completely understand. That was totally subjective. So the best that a PR person can do is shape your story, understand who to pitch, and then get that writer or editor to look at it, to pay attention to it. There are some PR people in this world who I think very highly of. I think they're incredibly smart, incredibly good at what they do, and they only pitch me when they have something that they think I will genuinely be interested in. Instead of a lot of PR people who just send me some random thing every week or every day.

**中文翻译:**
所以，不要把新闻稿出现在大网站上误认为是真正的成功。你真正需要的公关人员是那种经营“关系”的人。公关人员最重要的资产就是与媒体人的活跃关系。为什么？如果一个公关向你保证一定能上报道，那是另一个让你赶紧跑的理由，因为公关控制不了这个。作者和编辑想写什么就写什么。这是一个完全主观的行业，非常令人沮丧，我完全理解。所以公关能做的最好的事情就是塑造你的故事，弄清楚投递给谁，然后让那个作者或编辑去看它、关注它。世界上有一些我非常推崇的公关，他们非常聪明，业务精湛，他们只有在认为我真的会感兴趣时才会向我投递。而不是像很多公关那样，每周或每天给我发一些随机的东西。

---

### (00:33:21) Jason Feifer

**English:**
I don't pay attention to those people. But, I don't know, just shout out, when John Beer from Jack Taylor PR sends me ... John, I met him in a PR capacity a decade ago and we've since become friends. When he emails me, I pay attention. I don't write about it all the time. I'm not going to write about something just because I like John, but I will pay attention. And paying attention honestly is half the battle because people in media are getting so much email. So you want someone who's going to understand you, understand your industry, understand and know the people who they should be reaching out to, and who really respect you as an entrepreneur and are going to give you the hard feedback. Because there are a lot of people who will go and hire PR and they'll say, "I want you to email this and this and this and this and this publication."

**中文翻译:**
我不理会那些人。但我想点名表扬一下，比如 Jack Taylor PR 的 John Beer。十年前我因为公关业务认识了 John，后来我们成了朋友。当他给我发邮件时，我会关注。我不会每次都写，我不会仅仅因为喜欢 John 就写，但我会关注。说实话，获得关注就成功了一半，因为媒体人收到的邮件太多了。所以你需要一个了解你、了解你的行业、了解并认识该联系谁的人，而且他要真正尊重你这个企业家，并愿意给你严厉的反馈。因为很多人雇了公关后会说：“我要你给这家、这家、还有这家媒体发邮件。”

---

### (00:34:16) Jason Feifer

**English:**
And if the PR person just does that, all they're doing is annoying their contacts if they don't really feel like this was meaningful. You should like when a PR person pushes back on you and says, "You know what? I don't think that your story is right for that publication. Here's why." That's someone you should hire.

**中文翻译:**
如果公关人员只是照做，而他们自己并不觉得这有意义，那他们只是在骚扰他们的联系人。你应该喜欢那些会反驳你的公关，他们会说：“你知道吗？我觉得你的故事不适合那家媒体，原因如下。”那才是你应该雇佣的人。

---

### (00:34:34) Lenny

**English:**
Is there any other PR people you want to call out as ones that you think are awesome?

**中文翻译:**
还有其他你觉得很棒的公关人员想点名表扬吗？

---

### (00:34:38) Jason Feifer

**English:**
The challenge here is that I'm going to regret not including a whole bunch of people who don't pop to mind immediately, but-

**中文翻译:**
挑战在于，我肯定会后悔没提到一大堆现在没立刻想到的人，但是——

---

### (00:34:44) Lenny

**English:**
We can include them in the show notes, whoever else.

**中文翻译:**
我们可以把其他人放在节目介绍（show notes）里。

---

### (00:34:45) Jason Feifer

**English:**
Yeah, sure. Okay, so let's see. Off the top of my head, so John of Jack Taylor, he does a lot of wellness stuff. So PR agencies tend to specialize, and so you want to make sure that you're going with people who really understand you and the media ecosystem that you are reaching out to. So I think John's really smart. Let's see. Hannah Lee at Hannah Lee Communications is great on hospitality stuff. So restaurants, hotels, booze, they're really smart. Jen Sesquila, sorry Jen, if I mispronounced your name. Max Borges Agency, really good on sort of consumer focused products. Greg Delman, he's based in San Francisco, he has a boutique shop called G3 Media and he does a lot of tech startups stuff, just really knows that world. Greg, I'll find writers through Greg because he just knows everybody. I just texted him recently and I was like, "I need somebody who can write about this very specific AI thing." He happened to be at TechCrunch Disrupt and he found some freelancer and connected us. That's great. So those are four. I will have more that'll give you for the show notes.

**中文翻译:**
好。让我想想，目前能想到的：Jack Taylor 的 John，他做很多健康领域的内容。公关公司通常有擅长的领域，所以你要确保找的人真正了解你和你试图接触的媒体生态。我觉得 John 很聪明。还有 Hannah Lee Communications 的 Hannah Lee，她擅长款待业（hospitality），比如餐厅、酒店、酒类，他们非常专业。还有 Max Borges Agency 的 Jen Sesquila（抱歉 Jen，如果我读错名字了），他们非常擅长消费类产品。Greg Delman，他在旧金山，有一家精品公关公司叫 G3 Media，他做很多科技初创公司业务，非常了解那个圈子。我会通过 Greg 找作者，因为他认识所有人。我最近刚给他发短信说：“我需要一个能写这个非常具体的 AI 领域的人。”他当时正好在 TechCrunch Disrupt 大会上，帮我找了个自由撰稿人并牵了线。太棒了。这就是四个，我之后会提供更多名单放在节目介绍里。

---

### (00:35:55) Lenny

**English:**
Amazing. Okay. This is really useful. If any come to mind as we're chatting, feel free to shout them out again. Similar question, when people are thinking about publications to go after, say you're a startup founder. Is there a list you could just share of just like, here's probably the top five, 10 that you should be thinking about? The obvious ones, you talked about entrepreneur, [inaudible 00:36:15] Company, TechCrunch obviously comes to mind. Is there others that are just like, "Here's a good list to start with?"

**中文翻译:**
太棒了，这非常有用。如果聊天时又想到谁，随时补充。类似的问题，当人们考虑要争取的出版物时，假设你是一个初创公司创始人，有没有一个“前 5 到 10 名”的名单？显而易见的有你提到的《企业家》、《快公司》，还有 TechCrunch。还有其他适合作为起点的名单吗？

---

### (00:36:19) Jason Feifer

**English:**
Honestly, it really, so much depends upon what it is that you're looking to do. You could be a startup, founder and entrepreneur and Inc and Fast Company are for maybe some good reason not at the top of your list because you're a startup founder, but your goal right now is to reach consumers. And those publications don't reach consumers and they don't reach people who are in a buying mindset. They reach people who are in a creating mindset. So I would expect that if you have a startup and that startup is not B2B in some way, that it would be possibly very reasonable that business publications might not be your target right now. Maybe Men's Health is. Maybe, I don't know, anything could be. I think oftentimes people tend to think too close to them about where they belong. Lenny, here's a real kind of exchange that happens, which is if somebody will email me, I don't respond to every publicist.

**中文翻译:**
老实说，这很大程度上取决于你想做什么。你可能是一个初创公司创始人，但《企业家》、《Inc.》和《快公司》可能并不是你的首选，因为虽然你是创始人，但你现在的目标是接触消费者。而这些出版物并不接触普通消费者，也不接触处于“购买心态”的人，它们接触的是处于“创造心态”的人。所以，如果你的初创公司不是 B2B 类型的，那么商业刊物现在可能不是你的目标。也许《男士健康》才是，或者任何其他媒体。我认为人们往往在考虑自己属于哪里时想得太局限了。Lenny，这里有一个真实的互动场景：如果有人给我发邮件，我不会回复每一个公关。

---

### (00:37:23) Jason Feifer

**English:**
It's just literally not possible. I would not have enough time in the day. I do do my best to respond to every entrepreneur who reaches out because I feel like they deserve a response. And sometimes somebody will email me and they'll send me something and it's just not relevant. And I'll reply and I'll just say, "Hey, thanks. Congratulations on what you've built. But this isn't a fit for entrepreneur." And maybe once a month somebody responds really in a testy way, and they're like, "But don't you write about entrepreneurs? I'm a great entrepreneur success story." It's like, no, that's not what we do. Yes, entrepreneurs are featured in our stories, but no, we're not just a directory of entrepreneurs. Here's a good way of thinking about it. If you have a startup and you're trying to figure out what publications to be in, go look at where your competitors have been featured. That's a great place to start. What audiences are they reaching and how are they doing it? That should give you some direction about where you might want to go next.

**中文翻译:**
这根本不可能，我一天没那么多时间。但我会尽力回复每一位联系我的企业家，因为我觉得他们理应得到回复。有时有人发邮件给我，内容完全不相关。我会回复说：“嘿，谢谢。祝贺你所取得的成就，但这不适合《企业家》杂志。”大概每月会有一次，有人会气急败坏地回信说：“但你们不是写企业家的吗？我是一个伟大的企业家成功故事啊！”我的回答是：不，那不是我们做的。是的，我们的故事里有企业家，但我们不是企业家的名录。这里有一个好的思考方式：如果你有一家初创公司，想弄清楚该上哪些媒体，去看看你的竞争对手都在哪里被报道过。这是一个绝佳的起点。他们触达了哪些受众？他们是怎么做的？这会为你接下来的方向提供指引。

---

### (00:38:33) Lenny

**English:**
Awesome advice. On TechCrunch, do you have a perspective on is it worth investing in getting featured in TechCrunch?

**中文翻译:**
很棒的建议。关于 TechCrunch，你觉得值得投入精力去争取他们的报道吗？

---

### (00:38:40) Jason Feifer

**English:**
I'll tell you a sort of personal press journey moment, and then I think that it will translate into the answer for TechCrunch. Something we haven't talked about so far yet is, and this is sort of almost skipping all the steps that we've laid out to what happens after you get the press. But the point of the press is sometimes to reach the people who are reading it. You get covered in Entrepreneur and entrepreneurs are going to read it and maybe something good will come of it. But sometimes the point of it is not to reach the people who are reading it at all. Possibly a very small number of people are going to read it, which by the way is a real, real possibility. Because although all of these publications that I have mentioned, Entrepreneur, Forbes, Fortune Inc, Fast Company, whatever, these are reaching millions of people, their websites get many, many, many millions of unique visitors each month. That does not mean that your story is going to be read by millions of people.

**中文翻译:**
我给你讲一个我个人的媒体经历，我想这可以转化为对 TechCrunch 的回答。我们到目前为止还没谈到的一点是（这几乎跳过了我们之前列出的所有步骤，直接到了获得报道之后的情况）：媒体报道的目的有时是为了触达正在阅读它的人。你在《企业家》上获得报道，企业家们会读到它，也许会有好事发生。但有时，报道的目的根本不是为了触达读者。可能只有极少数人会读到它，顺便说一下，这极有可能发生。因为虽然我提到的所有出版物——《企业家》、福布斯、《财富》、《Inc.》、《快公司》等等——都触达数百万人，他们的网站每月有数千万独立访客，但这并不意味着你的故事会被数百万人阅读。

---

### (00:39:40) Jason Feifer

**English:**
In fact, the largest possibility here is that your story will reach five to 10,000 people, a small number of people because these publications are publishing tons of stuff. So you might get this story, it might look awesome, it might not reach that many people. That might also be okay. Because maybe the reason in your logic for why to get that kind of coverage is not to have reached that publication's audience at all anyway. Maybe what it really is is to tweet it and then put some money behind promoting that tweet because then you can target that you got coverage to the people who you want to notice you got coverage.

**中文翻译:**
事实上，最大的可能性是你的故事只能触达 5000 到 1 万人，这是一个很小的数字，因为这些出版物发布的内容太多了。所以你可能得到了报道，看起来很棒，但受众并不多。这也没关系。因为也许你争取这种报道的逻辑根本不是为了触达该媒体的受众。也许真正的目的是为了发推特，然后花钱推广那条推文，因为这样你就可以针对性地让你想让其注意到的人看到你获得了报道。

---

### (00:40:21) Jason Feifer

**English:**
And I see a lot of people do that. They'll take articles that we ran on Entrepreneur and they'll basically turn them into advertisements. And that's really smart because what they got out of Entrepreneur was the social cachet. It was the validation in the marketplace. And then they're going to do something with that themselves. That's really smart. You also see it sometimes the reason to get coverage, it's just so you can put it on your website. As seen in. As seen in is probably more valuable than anyone actually reading that story to begin with. They probably won't read the story. You might not even have to link it on the website. But you could just get to say as seen in. Because again, it gives you that validation.

**中文翻译:**
我看到很多人这么做。他们把我们在《企业家》上发布的文章拿走，基本上把它们变成了广告。这非常聪明，因为他们从《企业家》那里得到的是社交声望（social cachet），是市场的认可。然后他们自己利用这一点去做些什么。这非常高明。你有时也会看到，获得报道的唯一原因就是为了把它放在网站上，写上“曾被报道于”（As seen in）。“曾被报道于”可能比任何人实际阅读那个故事都要有价值。他们可能根本不读故事，你甚至不需要在网站上放链接，你只需要能说“曾被报道于”就行。因为这再次给了你那种认可。

---

### (00:40:56) Jason Feifer

**English:**
Me personally, I am building a small podcast company with my friend Nicole Lapin. Nicole Lapin is a bestselling business money expert. And we have a company, she's the founder and I'm an advisor. And it's called Money News Network. We have a podcast on it called Help Wanted that we co-host together. And we got coverage in Variety. And that was the result of pounding on a lot of doors and finally getting someone at Variety to take interest and they ran an article about us. Did we get anything from that story in Variety? The answer is no, like nothing. But you better believe that every email we send out to every potential advertiser, to every partner, includes the link. Variety has covered us. And I guarantee that when someone receives that email, it makes them pay more attention.

**中文翻译:**
就我个人而言，我正和朋友 Nicole Lapin 建立一家小型播客公司。Nicole Lapin 是一位畅销商业理财专家。我们有一家公司，她是创始人，我是顾问，叫 Money News Network。我们有一个共同主持的播客叫《Help Wanted》。我们在《综艺》（Variety）杂志上获得了报道。那是敲了很多门的结果，最终《综艺》的一位编辑产生了兴趣，写了一篇关于我们的文章。我们从那篇报道中直接得到了什么吗？答案是没有，几乎什么都没有。但你最好相信，我们发给每个潜在广告商、每个合作伙伴的每封邮件里都包含了那个链接：“《综艺》报道过我们”。我保证，当有人收到那封邮件时，会更加关注我们。

---

### (00:41:52) Jason Feifer

**English:**
And I have used it many times too when I reach out to people. It just gives you that validation. So sometimes what you're looking for is a prize to walk around with. And I would bet that the same is true for TechCrunch, which was your original question. Why get the funding announcement in TechCrunch? Probably not because anyone's going to care because they read it on TechCrunch, but now you can use that to your own means. And sometimes that's more valuable than the press itself.

**中文翻译:**
当我联系别人时，我也多次使用它。它就是能给你那种认可。所以有时你寻找的只是一个可以到处炫耀的“奖杯”。我敢打赌 TechCrunch 也是一样，回到你最初的问题：为什么要在 TechCrunch 上发布融资公告？可能并不是因为有人在 TechCrunch 上读了它而关心，而是因为现在你可以把它作为自己的筹码。有时这比报道本身更有价值。

---

### (00:42:16) Lenny

**English:**
That is an awesome insight. It also makes you realize you may not feel like it was a success after spending all this time getting in a story and entrepreneurs. Like, oh, nothing happened. But the benefits may come later, like weeks, months, years later when you start to share that.

**中文翻译:**
这是一个很棒的见解。这也让人意识到，在花了这么多时间上了《企业家》报道后，你可能觉得不成功，觉得“哦，什么也没发生”。但好处可能会在几周、几个月甚至几年后显现，当你开始分享那个报道时。

---

### (00:42:30) Jason Feifer

**English:**
Exactly right. A lot of this is what you make of it.

**中文翻译:**
完全正确。很大程度上取决于你如何利用它。

---

### (00:42:32) Lenny

**English:**
Amazing. Okay. That was extremely interesting. Okay, let's talk about step two. So initially you prepped, we talked about how to think about who to go after and the mission and goals. Then you get to step two, which just figure out who to reach out to at a publication.

**中文翻译:**
太棒了，这非常有趣。好，让我们谈谈第二步。最初你做了准备，我们讨论了如何思考目标受众、使命和目标。现在进入第二步：弄清楚该联系出版物的哪个人。

---

### (00:42:47) Jason Feifer

**English:**
Right. So a lot of people make the mistake of emailing me. If they want coverage in Entrepreneur, they email me. And I understand why they're emailing me. It's really for two reasons. One, I'm the most visible editorial person at Entrepreneur. And so it's easy to find me, it's easy to find my email address. And also they just assume, well, editor in chief, making all the decisions. But no. I mean, think about it. If you have a problem with a purchase that you made on Amazon, you don't email Bezos. He's too busy. And I am not comparing myself to Bezos. But I am the busiest editorial guy at Entrepreneur for whatever the hell that's worth. And I'm just not the guy to pitch because my job actually isn't really to select stories that go in the magazine. My job is to work with editors who develop their own ideas and then I get to say, "Oh, that's a good one," or, "Oh, let's refine that." I'm not sourcing as much. And so you really should start by looking at who's writing about your subject area.

**中文翻译:**
对。很多人犯的错误是直接给我发邮件。如果他们想在《企业家》上获得报道，他们就找我。我理解原因，主要有两个：第一，我是《企业家》杂志出镜率最高的编辑人员，很容易找到我，也很容易找到我的邮箱。第二，他们假设总编辑决定一切。但事实并非如此。想想看，如果你在亚马逊买东西出了问题，你不会给贝佐斯发邮件，他太忙了。我不是在把自己比作贝佐斯，但在《企业家》杂志，我是最忙的编辑人员。我并不是那个适合接收投递的人，因为我的工作其实并不是筛选进杂志的故事。我的工作是与那些自己构思故事的编辑合作，然后我说“哦，这个不错”或者“哦，让我们完善一下”。我不怎么亲自寻找素材。所以你真正应该开始做的，是看看谁在写你那个领域的内容。

---

### (00:43:57) Jason Feifer

**English:**
And you can do that by going to the website and surfing around. You can do that by Googling around. But you'll find the answer. Every publication is structured differently. Some people have specific beats. Some publications will be like, "This is the person on the transportation beat." And some publications don't. Entrepreneur doesn't really have a beat system necessarily. But if you look, you'll figure it out. "Oh, that editor is clearly interested in food. That writer is clearly interested in food. They seem to write all the food stories." And a good way, again, to do it is to start with the publication and then look at how they're covering your competitors. So a good example is I was once consulting with a guy who has a kind of fun peanut butter company. It's like imagine peanut butter meets Ben and Jerry's, so it's like peanut butter with lots of stuff and fun names. And so he's trying to figure out how to get press. And originally his thinking, the reason why he reached out to me was because he's like, "Well, I'm an entrepreneur. I run a business. I should be in Entrepreneur."

**中文翻译:**
你可以通过浏览网站或在谷歌上搜索来找到答案。每个出版物的结构都不同。有些人有专门的“条线”（beats）。有些出版物会说：“这是负责交通条线的人。”有些则没有。《企业家》杂志并不一定有严格的条线系统。但如果你观察，你会发现：“哦，那个编辑显然对食物感兴趣。那个作者显然对食物感兴趣，所有的美食故事似乎都是他们写的。”同样，一个好方法是先看出版物，然后看他们是如何报道你的竞争对手的。举个例子：我曾为一个经营有趣花生酱公司的家伙做咨询。想象一下花生酱遇到了 Ben & Jerry's 冰淇淋，就是那种加了很多料、名字很有趣的花生酱。他想弄清楚如何获得媒体报道。最初他的想法是（也是他联系我的原因）：“我是个企业家，我经营一家公司，我应该上《企业家》杂志。”

---

### (00:45:05) Jason Feifer

**English:**
I was like, "No, no, no, you shouldn't because none of our readers are going to buy your peanut butter. So who is your target audience? Who's buying your stuff?" And he says, "Millennial moms." I said, "Great. Okay, so Cosmo is a good place to reach them. So let's look at how Cosmo covers snacks." I don't know how they cover snacks. I don't read Cosmo, but let's find out. It's not hard. I went to cosmopolitan.com, searched for snacks. What I found immediately was a lot of stories that are all basically roundup-y and anchored to some time-sensitive things. So it's 10 snacks for Valentine's Day, it's our 10 favorite new fall snacks, whatever. It's all stuff like that. So now we know they are not going to run a thousand word feature on your peanut butter company. Instead, the best that you could hope to do is get into one of these seasonal-ish roundups.

**中文翻译:**
我说：“不不不，你不应该上，因为我们的读者没人会买你的花生酱。你的目标受众是谁？谁在买你的东西？”他说：“千禧一代的妈妈们。”我说：“太好了。那么《时尚》（Cosmo）是接触她们的好地方。让我们看看《时尚》是怎么报道零食的。”我不知道他们怎么报道零食，我不读《时尚》，但我们可以查。这不难。我去了 cosmopolitan.com，搜索“零食”。我立刻发现很多故事基本上都是“综述类”（roundup-y）的，并且与时间节点挂钩。比如“情人节的 10 款零食”、“我们最喜欢的 10 款秋季新零食”之类的。现在我们知道了：他们不会为你的花生酱公司写一篇千字专题。相反，你最好的希望是进入这些季节性的综述推荐中。

---

### (00:45:59) Jason Feifer

**English:**
So now next step, who's writing these things? Let's look. Let's open some of the articles. The byline is right there. You can click on the byline. You can see what this person does. And in many cases, maybe they're the food editor, maybe they're the lifestyle editor, whatever. You'll see what they cover. And you'll have a good understanding of now how to frame the thing that you're looking for. Now, let me introduce one other possible option. They don't work for the publication at all. They're a freelancer. Publications use a lot of freelancers. Freelancers are basically independent contractors. They're writers who are working sometimes. Sometimes they have longer term deals with publications. Sometimes it's just one-off. My wife is a freelancer. My wife is a freelancer who writes a lot for the New York Times and Washington Post and Guardian. And the interesting thing about my wife versus me is that my wife, whose name is Jen Miller, just so I don't keep saying my wife.

**中文翻译:**
那么下一步：谁在写这些东西？让我们看看。打开几篇文章，署名（byline）就在那儿。你可以点击署名，看看这个人是做什么的。在很多情况下，他们可能是美食编辑、生活方式编辑等等。你会看到他们报道的范围。这样你就知道该如何构思你想要的东西了。现在，让我介绍另一个可能的选项：他们根本不在那家媒体工作，他们是自由撰稿人（freelancer）。出版物使用大量的自由撰稿人。自由撰稿人基本上是独立承包商。他们是偶尔工作的作者，有时与出版物有长期协议，有时只是单次合作。我妻子就是一名自由撰稿人，她经常为《纽约时报》、《华盛顿邮报》和《卫报》撰稿。我妻子和我之间有趣的区别在于——她叫 Jen Miller，免得我一直说“我妻子”。

---

### (00:46:58) Jason Feifer

**English:**
So Jen, on a day-to-day basis as a freelancer is hungrier for stories than me because Jen has to hustle for her food. Jen has to find stories and pitch those stories to editors at publications, and that's when she gets paid. So she actually is more incentivized to be looking for stories than I am because I am a salaried employee of Entrepreneur Magazine. And my email address is very easily found and people just send me stuff all the time. And I should add here also, note that a good journalist, a good writer is not actually sitting around thinking that their job is to wait for people to pitch them so that they can just write about the best pitches. Their job as they see it, is to go and find the most useful things for their audience. And they like to do a lot of that themselves. So they're not sitting around just waiting for your pitches. And in fact, your pitches have to overcome their instinct to go find things themselves.

**中文翻译:**
Jen 作为一个自由撰稿人，日常对故事的“饥渴度”比我高，因为 Jen 必须为了生计而奔波。Jen 必须寻找故事，并将这些故事投递给出版物的编辑，只有那时她才能拿到报酬。所以她寻找故事的动力比我大，因为我是《企业家》杂志的领薪员工。我的邮箱很容易找到，人们总是在给我发东西。我还要补充一点：一个好的记者、好的作者其实并不会坐在那儿认为自己的工作就是等着别人投递，然后从中选最好的来写。在他们看来，他们的工作是去寻找对受众最有用的东西。他们喜欢自己动手。所以他们不会干坐着等你的投递。事实上，你的投递必须战胜他们“自己去寻找”的本能。

---

### (00:48:02) Jason Feifer

**English:**
So Jen is constantly hustling. Jen is constantly talking to people. Jen is curious about the world and will spend a lot of time hunting things down. But if somebody reads a story that she wrote and says, "Ah, I think I have an idea of what this person is interested in," and then tracks her email address down and then emails her, Jen is getting a lot fewer pitches than me, the chances of her reading it are close to a hundred percent. And the chances of her taking it seriously if it's relevant to any of the publications that she writes for is much higher than me. So sometimes going to the staff person is not actually your best move. Finding the freelancer who's doing the work is sometimes the better move.

**中文翻译:**
所以 Jen 总是很忙碌，不断地与人交谈。Jen 对世界充满好奇，会花很多时间搜寻素材。但如果有人读了她写的报道，心想：“啊，我觉得我知道这个人对什么感兴趣”，然后查到她的邮箱并给她发邮件，Jen 收到的投递比我少得多，她阅读邮件的概率接近 100%。如果内容与她撰稿的任何出版物相关，她认真对待的概率也比我高得多。所以，有时找正式员工并不是最好的选择，找到正在做这项工作的自由撰稿人有时是更好的策略。

---

### (00:48:43) Lenny

**English:**
So many interesting tactical insights that you're sharing. I love it. With this freelancer tip, how do you know they're freelancers? Is there something in the byline?

**中文翻译:**
你分享了这么多有趣的战术见解，我太喜欢了。关于自由撰稿人的建议，你怎么知道他们是自由撰稿人？署名里会有体现吗？

---

### (00:48:51) Jason Feifer

**English:**
If you find them on the publication's website so let's say that you go to Cosmo and you click on a author's bio. If they're staff, it'll say staff. If they're not staff, it'll probably say something else. It might say writer, it might say contributor. It might say Jen Miller is a writer in Brooklyn, New York. But also you can just go one extra step and just Google their name because any smart freelancer has a portfolio website where they should be very easily found.

**中文翻译:**
如果你在出版物的网站上找到他们，比如你去《时尚》点击作者简介。如果是正式员工，会写“Staff”。如果不是，可能会写别的，比如“Writer”或“Contributor”。或者写“Jen Miller 是一位居住在纽约布鲁克林的作家”。此外，你还可以多走一步，直接谷歌他们的名字，因为任何聪明的自由撰稿人都有自己的作品集网站，很容易就能找到。

---

### (00:49:22) Lenny

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### (00:49:23) Jason Feifer

**English:**
So sometimes just take their name, plug it into Google, you'll very quickly figure out who they are.

**中文翻译:**
所以有时只需把他们的名字放进谷歌，你很快就能弄清楚他们是谁。

---

### (00:49:28) Lenny

**English:**
Okay, so let me summarize things that you've taught us so far. One is think about publications that go to people that will buy your thing. So in your example, Cosmo is a good example of someone who would buy this peanut butter thing. Two is don't think of it broad thing. Think about the writer at the thing. So it's not like Cosmo would write about this. It's like, who specifically at Cosmo would write about this? And we find that as go to their site, search for, you talked about search for your competitors, but I think it's even broader, just things related to your area, right? [inaudible 00:50:01].

**中文翻译:**
好，让我总结一下你目前教给我们的内容。第一，考虑那些触达会买你东西的人的出版物。在你的例子中，《时尚》就是会买花生酱的人会看的媒体。第二，不要泛泛而谈，要考虑具体的作者。不是“《时尚》会报道这个”，而是“《时尚》里的哪个人会报道这个？”我们可以通过访问网站、搜索竞争对手来找到他们，甚至更广泛一点，搜索与你领域相关的任何内容。

---

### (00:50:01) Jason Feifer

**English:**
Yeahs, that;s good point. Search for your category.

**中文翻译:**
是的，好点子。搜索你的品类。

---

### (00:50:04) Lenny

**English:**
Even adjacent things probably are close enough. And then this tip about freelancers is really great, that they're hungrier and that they're more likely to respond to your pitch versus someone that's working there. And then also this point that they're like, their assumption is this is not a good pitch and they don't want your pitch. But freelancers have a higher chance of being interested and will pay attention.

**中文翻译:**
甚至相关领域也足够接近。关于自由撰稿人的建议非常棒，他们更“饥渴”，更有可能回复你的投递，而不是正式员工。还有一点是，正式员工往往假设投递都不好，他们不想要；但自由撰稿人更有可能感兴趣并关注。

---

### (00:50:25) Jason Feifer

**English:**
Yeah, freelancers got to eat.

**中文翻译:**
是的，自由撰稿人也得吃饭。

---

### (00:50:28) Lenny

**English:**
Amazing. Is there anything else along this step of finding somebody at a publication that you want to share?

**中文翻译:**
太棒了。在“寻找出版物联系人”这一步，还有什么想分享的吗？

---

### (00:50:36) Jason Feifer

**English:**
Well, the next step is going to be how to actually reach out to them and pitch. So at this stage, I think that we've fairly well covered it. And I love your summary. And just to double click on part of that, the reason why you're doing a lot of this is not just for the crazy busy work of it. But it's because you have to understand that the media ... Just sort of go back to translating the media. The media, which is a phrase that is used in all sorts of different ways, is a pretty bad way of actually understanding the media because the "media" makes it feel like it's a unified entity. In politics, the media will be criticized as a sort of multiple publications colluding together in some way. But the way that we're talking about it is just as organizations that you're trying to reach out to.

**中文翻译:**
下一步就是如何实际联系并投递。在这一阶段，我觉得我们已经讲得很透彻了。我很喜欢你的总结。我想再深入强调一点：你做这些不仅仅是为了那些繁琐的工作，而是因为你必须理解“媒体”……回到对媒体的解读。“媒体”这个词被以各种方式使用，但它其实是理解媒体的一个很糟糕的方式，因为“媒体”听起来像是一个统一的实体。在政治中，媒体常被批评为多家出版物以某种方式勾结在一起。但我们讨论的是你试图接触的各个组织。

---

### (00:51:25) Jason Feifer

**English:**
But really and truly, these are just publishing companies made up of individuals. And those individuals are all making fairly subjective decisions about what it is that they're going to write about. And there are layers of approval that they have to pass through. So nothing makes it into the print magazine, for example, without me saying yes. But I'm also trusting my editors to be passionate about the ideas that they're finding and convince me of yes. And so the thing that you are really looking to do is to find the way in to a publication. Because nothing gets covered until a single individual at a publication takes interest in you enough that they go to somebody else and say, "I think that this would be a good story," and that other person says yes.

**中文翻译:**
但说到底，这些只是由个人组成的出版公司。这些个人都在对要写什么做出相当主观的决定。而且他们必须通过层层审批。例如，如果没有我点头，任何东西都进不了纸质杂志。但我也信任我的编辑，相信他们会对发现的想法充满热情并说服我同意。所以你真正要做的是找到进入一家出版物的“切入点”。因为除非出版物中的某个人对你产生了足够的兴趣，去告诉另一个人“我觉得这是一个好故事”，而那个人也同意了，否则任何东西都不会被报道。

---

### (00:52:17) Jason Feifer

**English:**
So you have to find your way in. Because media is not a coordinated effort. It's a bunch of people showing up every day trying to figure out how to make the best thing for their audience.

**中文翻译:**
所以你必须找到切入点。因为媒体不是一个协同作战的整体，而是一群人每天上班，试图弄清楚如何为他们的受众做出最好的内容。

---

### (00:52:27) Lenny

**English:**
Amazing. Okay, so that's a great segue to final piece, which is actually, get someone excited and write about you.

**中文翻译:**
太棒了。这是一个很好的过渡，进入最后一部分：如何真正让某人感到兴奋并报道你。

---

### (00:52:33) Jason Feifer

**English:**
So how do we do that?

**中文翻译:**
那我们该怎么做呢？

---

### (00:52:33) Lenny

**English:**
How do we do that?

**中文翻译:**
怎么做？

---

### (00:52:36) Jason Feifer

**English:**
This is where the rubber hits the road, okay? So things not to do, don't call them, if you track down their phone number. Which is a real thing that happens. People call my personal cell phone number. It doesn't happen often, but it happens. And I don't even know where they get it from. But I don't like it. And media people are torn on whether or not DMs by social are an okay way to reach out. I find them kind of annoying. Because, number one, the format doesn't lend itself very well, right? If you write anything wrong in a DM, it just looks like this endless thing that I got.

**中文翻译:**
这是见真章的时候了。首先，不要做的事：如果你查到了他们的电话号码，千万别打电话。这真的会发生，有人打我的私人手机。虽然不常发生，但确实有。我甚至不知道他们从哪弄到的，但我很反感。媒体人对于通过社交媒体私信（DM）联系是否合适也存在分歧。我觉得私信挺烦人的。第一，格式不太合适，对吧？如果你在私信里写错任何东西，它看起来就像我收到的一长串没完没了的东西。

---

### (00:53:13) Jason Feifer

**English:**
But also, I don't know, my Instagram DMs, I just kind of don't think of as the place to be pitched. But other people don't care. So I don't know, you can roll the dice on that. Email is just the most traditional way. If you know somebody's going to be speaking at a conference, that's great, come up, you can talk to them. But the question of course is, what are you sending them? And here's what you're sending them. You're really sending them the product of the work that you have done in the previous two steps. Because you have now spent some time thinking about your story, and who you're pitching, and the publication, and how they're telling stories to their audience.

**中文翻译:**
而且，我不觉得我的 Instagram 私信是接收投递的地方。但有些人不在乎。所以你可以碰碰运气。邮件是最传统的方式。如果你知道某人要在会议上演讲，那太好了，走过去跟他们聊聊。但问题当然是：你发给他们什么？答案是：你发给他们的是你在前两步工作中得出的成果。因为你已经花时间思考了你的故事、你的投递对象、出版物以及他们如何向受众讲述故事。

---

### (00:53:51) Jason Feifer

**English:**
And then the individual person who you're reaching out to, who you now have some sense of how they write about this. And you're taking all of that, and you're trying to distill it down into a presentation that they're going to find appealing. Which again, to go back to the thing about how press is not that dissimilar to going out and raising money, that's kind of what you're doing when you go and meet an investor too. If you have meetings with 10 investors, the way in which you talk about yourself and the company should not be exactly the same with those 10 investors, because they're all going to have somewhat different approaches and different thesis.

**中文翻译:**
还有你联系的那个人，你现在对他们如何写作已经有了一些了解。你把所有这些结合起来，试图将其提炼成一个他们会觉得有吸引力的陈述。再次回到那个观点：争取媒体报道与融资非常相似，当你去见投资人时也是这么做的。如果你要见 10 个投资人，你谈论自己和公司的方式不应该完全一样，因为他们的投资方法和理念各不相同。

---

### (00:54:25) Jason Feifer

**English:**
And you're not trying to scam anybody, but you're just trying to be as customized as possible by building in your knowledge of what it is that they do, and what their firm does. And the same is true for media. So all of this is really going to take the form, in its most traditional sense, of a short email. A short email pitch. And what does that look like? I mean, look, there is literally no magic answer to that. I wish that there was, but there is not. There's no format. People always ask me, what should the subject line of the email be?

**中文翻译:**
你不是在骗人，你只是在利用你对他们业务和公司的了解，尽可能地做到定制化。媒体也是如此。所以，所有这些最终都会以最传统的形式呈现：一封简短的邮件。一个简短的邮件投递。它长什么样？听着，这真的没有标准答案。我希望有，但确实没有。没有固定格式。人们总问我：邮件主题应该写什么？

---

### (00:55:00) Jason Feifer

**English:**
That's is a good question. There's not one answer to that. The closest that I can give you to an answer is that, picture me. Picture me at my computer. I have a lot going on, and I'm glancing at my email, and 40 new emails are sitting there. And my instinct is to delete all of them as fast as possible, but I'm going to glance at each one. I'm not going to open each one, but I'm going to glance at it, which means that I see the subject line and I see the preview text, or just the first thing that somebody had written. What you want to do is write something that makes it pretty clear to me that this is targeted to me. That's step number one.

**中文翻译:**
这是一个好问题，但没有唯一答案。我能给出的最接近的答案是：想象一下我。想象我坐在电脑前，有很多事要忙，我扫了一眼邮箱，那里躺着 40 封新邮件。我的本能是尽可能快地删掉所有邮件，但我会扫视每一封。我不会打开每一封，但我会扫一眼，这意味着我会看到主题行和预览文本，或者某人写的第一句话。你要做的是写一些能让我清楚地感觉到“这是专门发给我的”内容。这是第一步。

---

### (00:55:40) Jason Feifer

**English:**
Because most of those emails that I got in my inbox are not targeted to me. They're mass blasts, and I'm delete, delete, delete, delete, delete. So which is the one that actually is reaching me? And sometimes you can do that by referencing something that I wrote in the past. I see people do that a lot. Don't fake it. People fake it all the time. People email me and they tell me they're fans of my work, they've never read my work. It's very obvious, right? Don't do that. But if you've read something, or if you're familiar with something, if you're familiar with the publication in some way, any signals of that are good.

**中文翻译:**
因为我收件箱里的大多数邮件都不是针对我的。它们是群发的，我一直在点删除、删除、删除。那么哪一封能真正触达我呢？有时你可以通过引用我过去写过的东西来实现。我经常看到人们这么做。但别装，人们总是在装。有人发邮件说他们是我的粉丝，其实根本没读过我的作品，这非常明显。别那样。但如果你真的读过，或者熟悉某些内容，或者熟悉出版物，任何这方面的信号都是好的。

---

### (00:56:15) Jason Feifer

**English:**
Because again, what you're trying to do is just separate yourself from noise to, this is customized to you. Because If you think about it, this is really an efficiency question. What I'm trying to do is, I'm trying to spend my time on the things that have the highest percentage chance of being relevant to me. And I'm filtering out the things that seem not relevant to me, who are wasting my time. So if I see something where somebody's writing me and they have a sense of the publication and they have a sense of me, there's a higher percentage chance that the next things that they're going to tell me are going to be relevant to me. Maybe even turn into a story.

**中文翻译:**
因为再次强调，你要做的是从噪音中脱颖而出，证明“这是为你定制的”。如果你仔细想想，这其实是一个效率问题。我试图把时间花在那些最有可能是与我相关的事情上。我在过滤掉那些看起来不相关、浪费我时间的东西。所以如果我看到有人写信给我，表现出对出版物和对我的了解，那么他们接下来要告诉我的内容很有可能与我相关，甚至可能变成一个故事。

---

### (00:56:53) Jason Feifer

**English:**
Which is great. I like when that happens. Because it saves me time, frankly, right? It's one less story I have to find myself. So I'm happy for it, but it's got to be right. So you want to structure ... And then the email that you're writing is don't go on forever, like three paragraphs max. And you are telling the version, you're not writing an article, but you're telling me the thing that you are pretty sure I'm going to be interested in. It's the difference between, going back to the butter dish example, woman sending me a three paragraph email about the butter dish itself, and opening up, telling me a little bit about the butter dish, and then immediately moving into this very clever story about the product market testing survey.

**中文翻译:**
这太棒了，我喜欢这种情况。坦白说，这节省了我的时间，对吧？这让我少找了一个故事。所以我很乐意，但内容必须是对的。所以你要构思……你写的邮件不要太长，最多三段。你是在讲述一个版本，不是在写文章，而是告诉我你确信我会感兴趣的事情。回到黄油盒的例子，区别在于：是发给我三段关于黄油盒本身的介绍，还是开篇简单提一下黄油盒，然后立即转入那个关于产品市场测试调查的聪明故事。

---

### (00:57:43) Jason Feifer

**English:**
That's the difference. She told me the story that was going to be relevant to my audience. She got there quickly, and it felt like, to me, this is a interesting human being with an interesting entrepreneurial story to tell, and that's why I'm going to engage.

**中文翻译:**
这就是区别。她告诉了我一个与我的受众相关的故事。她切入很快，对我来说，这感觉像是一个有趣的人带着一个有趣的创业故事，这就是我愿意参与的原因。

---

### (00:57:57) Lenny

**English:**
So that story actually came through a cold email?

**中文翻译:**
所以那个故事真的是通过一封冷启动邮件（cold email）发来的？

---

### (00:58:00) Jason Feifer

**English:**
That was a cold email. Yep. Just showed up one day.

**中文翻译:**
是的，是一封冷启动邮件。有一天它就突然出现了。

---

### (00:58:02) Lenny

**English:**
Amazing. This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential. But there are no commercial tools that integrate with a modern grow team stack. This leads to wasted time building internal tools, or trying to run your own experiments through a clunky marketing tool.

**中文翻译:**
太神奇了。本集节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 AB 测试平台。像 DraftKings、Zapier、ClickUp、Twitch 和 Cameo 这样的公司都依靠 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要。但目前还没有商用工具能与现代增长团队的技术栈无缝集成。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具运行实验。

---

### (00:58:30) Lenny

**English:**
When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform, where I was able to slice and dice data by device types, country, user stage. Eppo does all that and more, delivering results quickly, avoiding annoying prolonged analytic cycles, and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic click-through metrics, and instead use your north star metrics like activation, retention, subscription and payments. Eppo supports tests on the front end, on the backend, email marketing, even machine learning clients. Check out Eppo at geteppo.com. That's get Eppo.com, and 10X your experiment velocity.

**中文翻译:**
当我在 Airbnb 时，我最喜欢的一点就是我们的实验平台，我可以在那里按设备类型、国家、用户阶段对数据进行切片分析。Eppo 实现了这一切甚至更多，它能快速交付结果，避免令人烦恼的漫长分析周期，并帮你轻松找到发现问题的根本原因。Eppo 让你超越基本的点击率指标，转而使用你的北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。访问 geteppo.com 了解 Eppo。网址是 geteppo.com，让你的实验速度提升 10 倍。

---

### (00:59:11) Lenny

**English:**
Is there any other examples that come to mind, of someone doing this well? For people to have more kind of examples of here's...

**中文翻译:**
还有其他做得好的例子吗？为了让大家有更多参考……

---

### (00:59:17) Jason Feifer

**English:**
Oh sure. Well here, let's see. We'll have to do this in real time here. But I keep in my inbox a folder called Bad PR Pitches and a folder called Good PR Pitches. We can go through both.

**中文翻译:**
当然。让我想想，我们得现场找一下。我的收件箱里有两个文件夹，一个叫“糟糕的公关投递”，一个叫“优秀的公关投递”。我们可以都看看。

---

### (00:59:28) Lenny

**English:**
Let's do it.

**中文翻译:**
来吧。

---

### (00:59:29) Jason Feifer

**English:**
All right, I just pulled this up. This is, and I haven't read this in a long time. I'm kind of trying to read ahead as I'm talking just to see if this is appropriate to read. But I think so. I don't know, whatever. We're just going to read it and see what happens. All right, so the subject of this was, "Idea for entrepreneur and Problem Solvers, how the Border Closures grew my business." So this was sent to me in September of 2020.

**中文翻译:**
好，我刚打开。这封我很久没读了，我边说边往下看，看适不适合读出来。我觉得可以。管它呢，我们就读读看。好，这封邮件的主题是：“给《企业家》和《问题解决者》播客的一个想法：边境关闭如何让我的业务增长。”这是在 2020 年 9 月发给我的。

---

### (00:59:54) Lenny

**English:**
And this is a good or a bad?

**中文翻译:**
这是优秀的还是糟糕的？

---

### (00:59:56) Jason Feifer

**English:**
This is good, this is good. This turned into an episode of a podcast that I do for Entrepreneur, and I might've also then converted it into an article I can't remember. And so here's what she did. So her name, I shout her out. So this is Meg O'Hara. And Meg O'Hara is a painter, a Canadian landscape painter. Which again, a small business. And she writes, "Hi Jason, I have an idea for a story I think would be valuable and relevant to you, Entrepreneur Magazine and the Problem Solvers Podcast." That's the show I do for Entrepreneur.

**中文翻译:**
这是优秀的。这后来变成了我为《企业家》制作的一期播客节目，我也许还把它改写成了一篇文章，记不清了。她是这么做的：她叫 Meg O'Hara。Meg 是一位画家，一位加拿大风景画家。同样，也是一家小企业。她写道：“嗨 Jason，我有一个故事想法，我认为对你、《企业家》杂志和《问题解决者》（Problem Solvers）播客非常有价值且相关。”那是我为《企业家》主持的节目。

---

### (01:00:33) Jason Feifer

**English:**
And then she says, "Here's what's going on with my business. All entrepreneurs had to be flexible during Covid. This is a story about how one artist in Canada benefited from the border closure." This just sort of intrigues me. Oh, how? "When Covid hit in March, all ski resorts across North America shut down early. Skiers are a high earning demographic in Canada. They fall in the top 5% of income." Okay, well anyway. So she goes on. What she tells me, I remember this now, what she tells me is that her business used to be being hired by ski resorts to come and paint landscapes for their facilities.

**中文翻译:**
接着她说：“这是我业务的情况。在疫情期间，所有企业家都必须灵活变通。这是一个关于加拿大的一位艺术家如何从边境关闭中获益的故事。”这引起了我的好奇。哦，怎么获益的？“当 3 月疫情袭来时，北美所有的滑雪胜地都提前关闭了。滑雪者在加拿大是高收入群体，属于收入前 5% 的人群。”好，总之她继续写道。我记起来了，她告诉我，她以前的业务是受雇于滑雪场，为他们的设施画风景画。

---

### (01:01:15) Jason Feifer

**English:**
And when the border shut down and people weren't going to these resorts anymore, she had to come up with a completely different way of doing her business. And so she started to think, well, I can't work for these resorts anymore. They're not hiring me. But all these skiers who used to work at the resorts who have seen my work, or who used to ski at the resorts who were maybe familiar with my work, they're not skiing either. They probably are sitting around wishing that they were skiing. They'd love something to see of their favorite ski location, and they also have money sitting around because they're not spending it on the ski resorts.

**中文翻译:**
当边境关闭，人们不再去这些度假村时，她必须想出一种完全不同的经营方式。于是她开始想：我不能再为度假村工作了，他们不雇我了。但所有那些曾在度假村工作过、见过我作品的滑雪者，或者曾在度假村滑雪、熟悉我作品的人，他们现在也没法滑雪了。他们可能正坐着发愁，渴望能滑雪。他们一定很想看到自己最喜欢的滑雪胜地的景色，而且他们手里还有闲钱，因为没花在滑雪度假上。

---

### (01:01:39) Jason Feifer

**English:**
So then she lists off the problems and the solutions in bullet points. Which I love. Because she has listened to the show, the Problem Solvers Show, which is structured in exactly that way. Tell me the problem, tell me the solution that you came to. So she lists it off. Here are the problems: the skiers can't come, people are spending more time at home. The solution: I create artwork for their homes that depicts their favorite views from skiing as they were. She goes on and on and on.

**中文翻译:**
然后她用要点（bullet points）列出了问题和解决方案。我太喜欢这一点了。因为她听过我的节目《问题解决者》，那个节目的结构正是如此：告诉我问题，告诉我你得出的解决方案。于是她列了出来。问题是：滑雪者来不了，人们在家的时间变多了。解决方案：我为他们的家创作艺术品，描绘他们最喜欢的滑雪美景。她写了很多很多。

---

### (01:02:03) Jason Feifer

**English:**
I read this and I just think, there is something here about what this person did to reinvent their business at a time in which one marketplace shut down, but it created a new one that I think people would like to hear. Because at that time everyone was thinking about how to reinvent themselves and their business. And even though I reach people who have very complex and large businesses, sometimes it's really a beautiful thing to hear a single individual who does the simplest thing in the world, which is put paint to canvas, talk about how she did it for herself. Because you can extract these wonderful little lessons about how to reinvent yourself that I think are going to be relevant to a very broad audience.

**中文翻译:**
我读到这里就在想：这个人在一个市场关闭时如何重塑业务并创造新市场的故事，人们一定会想听。因为当时每个人都在思考如何重塑自己和业务。尽管我的受众中有很多经营复杂大企业的人，但有时听一个做着世界上最简单事情的人（把颜料涂在画布上）讲述她如何为自己转型，真的是一件很美妙的事。因为你可以从中提取出关于如何重塑自我的精彩小教训，我认为这会对非常广泛的受众产生共鸣。

---

### (01:02:44) Jason Feifer

**English:**
So Meg sent me that email, I replied and I said, "I like it." And we did it. So that's a good example of someone who spent time understanding my work, down to the structure of how I'm communicating, and then sent me a pitch that very quickly and clearly seemed customized to me, and told me her story in a way that I could imagine telling my audience. At that point, it's a pretty easy yes.

**中文翻译:**
所以 Meg 发了那封邮件，我回复说：“我喜欢这个点子。”然后我们就做了。这是一个很好的例子：有人花时间了解我的工作，甚至了解我沟通的结构，然后发给我一个看起来非常明显是为我定制的投递方案，并以一种我能想象向受众讲述的方式告诉我她的故事。到那一刻，答应她就变得非常容易。

---

### (01:03:14) Lenny

**English:**
That is an amazing example. I just took some notes on things that she did right based on things you've shared in the past. Even just from the subject line or the first sentence, it was clear that she knew you. She knew you had this podcast, she knew the magazine, and she even expressed this specifically, you're going to be interested in this. She mentioned how this, she has a story. She starts immediately with a story. There's not the value prop of the company, here's what we do and here's why we're awesome. And then the lessons, the mission of Entrepreneur you talked about, is insights and lessons that people achieve, and she just went straight to here's what we've learned.

**中文翻译:**
这真是一个绝佳的例子。根据你之前分享的内容，我记下了一些她做对的地方。甚至只看主题行或第一句话，就能清楚地知道她了解你。她知道你有这个播客，知道这本杂志，她甚至明确表达了“你会对这个感兴趣”。她提到她有一个故事，而且直接从故事开始。没有公司的价值主张，没有“我们是做什么的，为什么我们很棒”。然后是教训——你提到的《企业家》的使命是人们获得的洞察和教训，而她直接切入“这是我们学到的”。

---

### (01:03:49) Jason Feifer

**English:**
That's right.

**中文翻译:**
没错。

---

### (01:03:50) Lenny

**English:**
So I could see why that resonated.

**中文翻译:**
所以我能理解为什么这会引起共鸣。

---

### (01:03:51) Jason Feifer

**English:**
Yeah, it was great. And the next thing that made it a real success, by the way for her, was that once I got her on the phone, she was, and I find this, this is a make or break thing for me. Because I can talk to somebody and then kill the story, or not run the podcast. She was willing to be open about challenges. I mean, she had reached out because of challenges, but not everyone is. I will get a pitch from someone who is presenting like, oh, we had this challenge in the business. But then when I talk to them, they act as if there was no problem. Or the problem was really small and their ingenuity immediately made this a very successful business. And that's not interesting to me.

**中文翻译:**
是的，非常棒。顺便说一下，对她来说，接下来的成功关键在于：一旦我跟她通了电话，她表现得很坦诚。我发现这对我是决定性的。因为我可以跟某人聊完后毙掉这个故事，或者不播这期播客。她愿意公开谈论挑战。虽然她是因为挑战才联系我的，但并不是每个人都愿意深谈。我会收到一些人的投递，说“哦，我们在业务中遇到了这个挑战”，但当我跟他们聊时，他们表现得好像没问题一样，或者问题很小，而他们的聪明才智立刻让业务变得非常成功。那对我来说没意思。

---

### (01:04:42) Jason Feifer

**English:**
Because success stories are not interesting. They're not interesting to anybody. It's not useful for you to just hear that someone else succeeded. What's useful is for you to hear how someone else faced challenges that you faced. And got through them so that you can see. Aha, that's an interesting strategy to use for me. I hate success stories. I love problem solving stories. And that's why when I talk to an entrepreneur, I expect them to be really open about that stuff. And if they're not, I basically lose interest.

**中文翻译:**
因为成功故事并不有趣。对任何人来说都没趣。仅仅听到别人成功了对你没用。有用的是听到别人如何面对你也面临的挑战，并如何克服它们，这样你就能发现：“啊哈，这是一个我可以借鉴的有趣策略。”我讨厌成功故事，我热爱解决问题的故事。这就是为什么当我与企业家交谈时，我期望他们能对这些事情非常坦诚。如果他们不坦诚，我基本上就会失去兴趣。

---

### (01:05:13) Lenny

**English:**
The hero's journey. I'd love to hear another example. But before that, hearing this, obviously it takes a bunch of time to do this for a founder. I guess, two questions. Just, how many places should somebody probably try to reach out to give them a chance of being successful? And then do you have any thoughts on how much time they should put into something like this? I know it's a very broad question. But, any thoughts there?

**中文翻译:**
英雄之旅。我很想再听一个例子。但在那之前，听了这些，显然对创始人来说这很花时间。我有两个问题：一个人大概应该尝试联系多少个地方，才能有成功的机会？另外，你觉得他们应该在这样的事情上投入多少时间？我知道这是一个很宽泛的问题，但你有什么想法吗？

---

### (01:05:35) Jason Feifer

**English:**
Yeah, it's a really broad question. So again, this is in some way why, in a large way, why a lot of people hire PR. Because PR can just move this along. They can reach a lot of people very fast, whereas you as an individual cannot. One way to think about it is, you're going to be on the hunt. You're going to try to make this work, and you're going to take a couple bets and hope that some of them pay off. Another way of thinking about it is, this is a passive activity. And I'll spend some time when I'm reading media, thinking about this, kind of developing an idea. Another thing that you can do, follow a bunch of writers and editors on social media.

**中文翻译:**
是的，这确实很宽泛。所以，这在很大程度上也是为什么很多人雇佣公关的原因。因为公关可以推进这件事，他们可以很快接触到很多人，而你个人做不到。一种思考方式是：你正在“狩猎”，你试图让这件事成功，你会下几次注，希望其中一些能有回报。另一种思考方式是：这是一种被动活动。当我阅读媒体时，我会花点时间思考，构思一个想法。另一件你可以做的事是：在社交媒体上关注一大群作者和编辑。

---

### (01:06:20) Jason Feifer

**English:**
Meg, I can't remember the order of operations here, because I know that Meg follows me on Instagram now, because she's DMd me many times. And I respond to everybody. I can't remember if she followed me before, but she might've. And maybe she even DMd me a few times. Usually it's somebody's responding to an Instagram story or something. And I've seen a lot of people use this strategy with me, and I think that it's a really smart one. Which is basically, before you ever pitch, just get me to recognize your name. Just engage in social media in a very casual way, such that when you email me, I think, do I know who that person is? Meg O'Hara, I think I know who that person is. It just makes it more likely that I'll open the email.

**中文翻译:**
Meg 的例子，我不记得具体的先后顺序了，但我知道 Meg 现在在 Instagram 上关注了我，因为她给我发过很多次私信。我会回复所有人。我不记得她之前是否关注了我，但很有可能。也许她甚至给我发过几次私信。通常是有人回复我的 Instagram 动态之类的。我见过很多人对我使用这种策略，我觉得这非常聪明。基本上就是：在你投递之前，先让我记住你的名字。只是以一种非常随意的方式在社交媒体上互动，这样当你给我发邮件时，我会想：“我认识这个人吗？Meg O'Hara，我觉得我认识。”这会大大增加我打开邮件的可能性。

---

### (01:07:08) Jason Feifer

**English:**
And I see a lot of people do that. They'll spend a long time engaging with me on social media before ever pitching me. I know what they're doing, I understand that it's probably calculated. I still like it. It's smart. Because it means that by the time that they've reached out, I think you have a pretty good sense of my work. Which means that what you're bringing to me is probably in pretty good faith. And for that, I like it. It's a good filter.

**中文翻译:**
我看到很多人这么做。他们在向我投递之前，会花很长时间在社交媒体上与我互动。我知道他们在做什么，我知道这可能是经过计算的。但我仍然喜欢这种方式，这很聪明。因为这意味着当他们联系我时，我认为你对我的工作已经有了相当好的了解。这意味着你带给我的东西可能是出于诚意的。为此，我喜欢这种方式，这是一个很好的过滤器。

---

### (01:07:36) Jason Feifer

**English:**
So if you've been listening to this whole thing, and you're thinking, this is a tremendous amount of work, I have a new product launch, or I have a bunch of budget that I can spend on this, this individual kind of approach, it may not be for you. You might want to just spend a bunch of time instead interviewing different PR firms. And find the one that seems most aligned with and understands your story, and your vision, and knows people in your space shortcuts a lot of this. But even then, even then, I think that having heard this is really useful. Because at some point, if the PR person is successful, you are going to get on the phone with the writer or editor.

**中文翻译:**
所以，如果你听了这么多，觉得“这工作量太大了，我有一个新产品要发布，或者我有一笔预算可以花在这上面”，那么这种个人化的方法可能不适合你。你可能想花时间面试不同的公关公司，找到那家看起来最契合、最理解你的故事和愿景、并且认识你所在领域的人的公司，这能省去很多麻烦。但即便如此，我认为听听这些依然非常有用。因为在某个时刻，如果公关人员成功了，你还是要和作者或编辑通电话。

---

### (01:08:27) Jason Feifer

**English:**
And it's very useful to understand how they think. That they're not there to serve you. That this isn't a service that they're providing you. So you better understand what they're entering into this with, and what they have in mind. When they're asking you questions, they're asking questions, thinking, this is what my audience is going to be curious about. This is how I'm going to drive this person in this interview towards the kinds of insights that my audience are going to find gratifying. So the more that you understand who you're dealing with, the better.

**中文翻译:**
理解他们的思维方式非常有用：他们不是来为你服务的，这不是他们提供给你的服务。所以你最好理解他们带着什么样的目的进入对话，以及他们在想什么。当他们问你问题时，他们是在想：“我的受众会对什么感到好奇？我该如何引导这次采访，让这个人说出我的受众会觉得满意的见解？”所以，你越了解你的对话对象，效果就越好。

---

### (01:08:48) Lenny

**English:**
And also just having done it yourself, you'll better understand what to ask your folks, how they're going to work, find opportunities to improve the way they're operating. On that question of quantity, say you're doing this, say you're spending the time. I'm going to really invest in understanding Jason and whoever else. Is there a rule of thumb you'd recommend? Try to do this for three publications to get one, or is it five? I don't know. Is there anything there that you could recommend?

**中文翻译:**
而且，通过亲力亲为，你会更清楚该向你的公关团队提什么要求，他们将如何工作，并找到改进他们运作方式的机会。关于数量的问题，假设你在做这件事，你在投入时间，我真的在花精力去了解 Jason 和其他人。你有没有推荐的经验法则？比如尝试联系三家出版物能成一家，还是五家？我不知道，你有什么建议吗？

---

### (01:09:14) Jason Feifer

**English:**
So it's really dependent upon how easy you are to write about. I may just sort of note, if you are some kind of B2B service, especially in some kind of very niche or wonky space, it's going to be really hard for you to get [inaudible 01:09:40]. So hard that it might actually not even be worth trying. Because there are other things that you can do, or things that we haven't even talked about yet. You could say, you know what? Screw it. I'm not going to try to get coverage for my company. Why don't I just try to position myself as an expert? Right? It's a totally different kind of approach.

**中文翻译:**
这真的取决于你是否容易被报道。我得提醒一下，如果你是某种 B2B 服务，特别是在非常小众或古怪的领域，获得报道会非常难。难到可能根本不值得尝试。因为你还可以做其他事情，或者我们还没谈到的事情。你可以说：“管它呢，我不打算为我的公司争取报道了。我为什么不试着把自己定位成一个专家呢？”对吧？这是一种完全不同的方法。

---

### (01:10:07) Jason Feifer

**English:**
Where instead, what you're maybe trying to do is just hook onto the news, try to get a quote or a perspective to a reporter who might be writing about something. I get these all the time. Something breaks, some news breaks, and people start reaching out to me. And they'll say, "This just happened in the news. And my client," or sometimes just the individual, "I have this insight into this, and here's what I would say if you want to interview me." It's not going to be a feature about you, You're not going to be the subject, there's no photo of you. You might get a quote. You might get a quote in a story. Which again, is all you need to be able to say as featured in on your website.

**中文翻译:**
相反，你可能只是想蹭热点新闻，试着给正在写相关报道的记者提供一段引言或一个观点。我经常收到这种信息。某件事爆发了，某个新闻出来了，人们就开始联系我。他们会说：“新闻里刚发生了这件事。我的客户（或者个人）对此有深刻见解，如果你想采访我，我会这么说。”这不会是关于你的专题报道，你不是主角，也没有你的照片。但你可能会在故事中获得一段引言。再次强调，这足以让你在网站上写“曾被报道于”。

---

### (01:10:33) Jason Feifer

**English:**
So sometimes it's about that. Sometimes it's about you could just be a writer. You might try to just pitch authoritative articles by you to different publications. Get yourself out in that way. Sometimes, again, you're not going to be able to be easily written about. And sometimes you are. Sometimes you made some insane technology that everyone's going to be talking about, and it's going to be super easy for you to get press. At which point your hit rate is going to be much higher. That's why going into this with really realistic expectations, and if you're going to work with PR, having PR who can set and hold you to those realistic expectations, can just save you a lot of heartache.

**中文翻译:**
所以有时是关于这个。有时你可以直接当作者，尝试向不同的出版物投递你写的权威文章，以这种方式出名。有时，你确实不容易被报道；但有时你很容易，比如你发明了某种每个人都会谈论的疯狂技术，获得媒体报道会超级容易。在那时，你的成功率会高得多。这就是为什么带着现实的期望进入这件事，如果你要找公关，找一个能设定并让你保持现实期望的公关，可以省去很多烦恼。

---

### (01:11:12) Lenny

**English:**
Along the same lines, there's always this idea of exclusivity and people want to write first about a thing. Say you talked about an awesome technology. Do you have advice on, do you just pitch the same thing to all of them and hope they all write about it? Do you pitch them different stories? Do you offer one an exclusive, any advice there?

**中文翻译:**
沿着这个思路，总会有“独家报道”的概念，人们都想第一个报道某件事。假设你谈论的是一项很棒的技术。你有什么建议吗？是把同样的东西投递给所有人并希望他们都写？还是投递不同的故事？或者给其中一家提供独家？

---

### (01:11:29) Jason Feifer

**English:**
Everyone has a different approach to this. The number one rule here is just, don't do it in a way that the people in media feel like you're playing them. Because they won't have tolerance for it. I would rather walk away from something like this than do some funny dance with somebody. So my favorite version of this goes like this. Actually, there's a founder who recently, I met him years ago. So when he reached out, I recognized the name immediately. And he reached out and he's like, hey, we did this really interesting thing and we haven't told anybody about it yet. And I'd love to see if it's a fit for entrepreneurs.

**中文翻译:**
每个人都有不同的方法。第一条规则是：不要让媒体人觉得你在耍他们。因为他们对此零容忍。我宁愿放弃这种报道，也不愿跟某人玩这种花招。我最喜欢的版本是这样的：最近有一位创始人，我多年前见过他，所以当他联系我时，我立刻认出了名字。他联系我说：“嘿，我们做了一件非常有趣的事，还没告诉任何人，我想看看这是否适合《企业家》。”

---

### (01:12:10) Jason Feifer

**English:**
So I hop on the phone with him, and he tells me. And I'm not going to tell you what it's yet because we haven't run the story. But after 15, 20 minutes, I say, yeah, you know what? This is a really interesting story. And frankly, I know other media outlets are going to be interested in this too, particularly because a finance element to it. So I think the Wall Street Journal, and Bloomberg, and those kinds of places are going to be interested in this. He wants to go to Entrepreneur for whatever reasons he wants. I mean, I think probably two. Because number one, he wants to position himself towards that audience. And then number two, there's a trust factor. He knows me in a way that he doesn't know the editors over there. And so he feels like I'll probably treat the story more carefully.

**中文翻译:**
于是我跟他通了电话，他告诉了我。我现在还不能告诉你是什么，因为报道还没发。但聊了 15 到 20 分钟后，我说：“是的，这是一个非常有趣的故事。坦白说，我知道其他媒体也会对此感兴趣，特别是它带有金融元素。我觉得《华尔街日报》、彭博社之类的地方会感兴趣。”他想上《企业家》有他自己的理由，我想大概有两个：第一，他想针对我们的受众进行定位；第二，信任因素。他认识我，但不认识那边的编辑，所以他觉得我可能会更谨慎地对待这个故事。

---

### (01:12:49) Jason Feifer

**English:**
So we worked out a deal, which he proposed. And the deal is that we'll get the exclusive, and there's going to be a three-hour window after our story runs, and then they're going to start responding to everyone else. And then they're going to start talking to other people, or maybe they'll even line it up and reach out to some other media. And that's fine with me. I understand. And we're going to create a little embargo window. And we'll go first, and then they're going to talk to everybody else.

**中文翻译:**
所以我们达成了一个他提议的协议。协议是：我们获得独家报道权，在我们的报道发布后有三个小时的窗口期，然后他们才开始回复其他人。接着他们会开始与其他媒体交谈，或者甚至已经排好了队去联系其他媒体。这对我来说没问题，我理解。我们会设定一个简短的“禁止发布期”（embargo window），我们先发，然后他们再去跟其他人谈。

---

### (01:13:21) Jason Feifer

**English:**
Sometimes you can offer an exclusive to someone in that you are going to release the news to everybody, but only one media outlet is going to get the interview. Which works really well if you have a big personality. So for example, recently a company that Mark Cuban has invested in offered us that, right? They're like, we have this news. We're going to reach out, we're going to send the news everywhere, but we're going to give you the exclusive interview with Mark Cuban. He's going to do one interview and he'll do it with you. You can parse it out in any way. You just want everyone to feel like you're being upfront with them.

**中文翻译:**
有时你可以向某人提供这样的独家：你会向所有人发布新闻，但只有一家媒体能获得采访权。如果你有一个大牌人物，这招非常管用。例如，最近一家 Mark Cuban 投资的公司向我们提供了这种机会。他们说：“我们有这个新闻，我们会发给所有人，但我们会给你 Mark Cuban 的独家采访权。他只接受一次采访，而且是和你谈。”你可以以任何方式拆分，只要让每个人都觉得你对他们很坦诚就行。

---

### (01:13:57) Lenny

**English:**
And that they're getting something special, as much as possible. That makes sense. You touched on this relationship piece, and that's something I wanted to ask. It feels like in tech, a lot of reporters end up writing a negative story, because a lot of times that's what people want to read. Why is this destroying the world? I actually had a fast company do a thing on me, and I talked to the reporter, and I had no idea. Was he going to just completely tear me apart, or is he going to be really friendly and positive over what I'm doing? And I have no idea, and it just comes out. It's not like I look at it before it comes out. So do you have any just advice to give you a set, help if this is going to turn into something positive or negative? I know you have no idea.

**中文翻译:**
并且尽可能让他们觉得自己得到了特别的东西。这很有道理。你提到了“关系”这一点，这也是我想问的。感觉在科技界，很多记者最终会写负面报道，因为很多时候人们就想看这个：“为什么这东西在毁灭世界？”实际上《快公司》曾对我做过报道，我跟记者聊了，但我完全不知道他会把我批得体无完肤，还是会对我所做的事非常友好和正面。我完全不知道，报道就这么出来了。我不可能在发布前看到它。所以你有什么建议吗，能帮人预判这会变成正面还是负面的报道？我知道你也没法确定。

---

### (01:14:34) Jason Feifer

**English:**
What happened, by the way? Was it positive or negative?

**中文翻译:**
顺便问一下，结果呢？是正面还是负面的？

---

### (01:14:35) Lenny

**English:**
Super-positive.

**中文翻译:**
非常正面。

---

### (01:14:35) Jason Feifer

**English:**
Great.

**中文翻译:**
太好了。

---

### (01:14:37) Lenny

**English:**
I was very happy with it, yeah.

**中文翻译:**
我很满意，是的。

---

### (01:14:38) Jason Feifer

**English:**
Okay, good, good. I'm glad to hear that. So part of it is the publication itself, right? Entrepreneur, and I would say Fast Company, are just sort of not in the business of running negative stories. And the reason is, it doesn't serve our audience. My audience is coming to me to learn things for their business. Tearing somebody apart just doesn't help them in any way. So part of it is just what ecosystem are you dealing with? You can also look at the past work of the writer. And if you work with a PR person, it's funny because occasionally somebody has accidentally forwarded this to me, and I'll see the dossier that a PR agency will put together on me.

**中文翻译:**
好，很好，很高兴听到这个。部分原因在于出版物本身，对吧？《企业家》，还有《快公司》，基本上不做负面报道。原因在于，这不符合我们受众的需求。我的受众来找我是为了学习商业知识，把某人批倒批臭对他们没有任何帮助。所以，部分原因在于你面对的是什么样的生态系统。你也可以看看作者过去的作品。如果你和公关合作，有趣的是，偶尔会有人不小心把公关公司为我准备的“档案”转发给我。

---

### (01:15:17) Jason Feifer

**English:**
But a PR agency, if they set you up with an interview with someone, they'll usually do some digging. And they'll find, what does this person usually write about? What kind of stories do they do? What are they generally interested in? So you can have a sense, right? What kind kind of thing are they doing? And past that, there's also a question of, well, what are you doing in the world, right? I mean, if there is something somewhat controversial about you, and especially if you're engaging with an outlet that is interested in that kind of stuff, there's a halfway-decent chance they're at least going to explore it with you, and ask you about it. And if you're weird and cagey with them, they're going to think that there's more to it, and they're going to start digging more.

**中文翻译:**
公关公司如果为你安排了采访，通常会做一些挖掘。他们会发现：这个人通常写什么？他们做哪类故事？他们通常对什么感兴趣？这样你就能有个大概的了解，对吧？除此之外，还有一个问题：你在世界上做了什么？如果你身上确实有一些争议点，特别是当你接触一家对此类内容感兴趣的媒体时，他们很有可能会和你探讨并询问。如果你表现得古怪且遮遮掩掩，他们会觉得事有蹊跷，并开始深入挖掘。

---

### (01:16:03) Jason Feifer

**English:**
But the ultimate answer here is that every part of this, and this has come through, I'm sure, in our whole conversation, every part of this process is really out of your control. Does somebody pay attention to you? What do they write about you? When do they write about? All of it is outside of your control, Which again, is the reason why it's not smart to think about press as a primary strategy for driving growth. It's a good add-on, but these people are going to do what they're going to do. And the best you can do is read the tea leaves.

**中文翻译:**
但最终的答案是：这个过程的每一个环节（我相信在我们的整个谈话中已经体现出来了）其实都在你的控制之外。是否有人关注你？他们怎么写你？什么时候写？所有这些你都控制不了。这再次说明了为什么把媒体报道作为驱动增长的主要策略是不明智的。它是一个很好的补充，但这些人会按自己的想法行事。你所能做的最好的就是观察蛛丝马迹。

---

### (01:16:37) Lenny

**English:**
Yeah. It was a very weird ... I don't get press often, it's not like something I pursue. But it was just like, this is wild. I'm just going to talk to this guy, and then something will come out. I have no idea what it might be. He might have things wrong, because I didn't get a chance to review, and might skew things. But it's a strange experience to go through. But it all worked out great.

**中文翻译:**
是的。这是一种很奇怪的……我不常获得媒体报道，也不是我追求的东西。但当时感觉很疯狂：我就跟这家伙聊聊，然后就会有东西出来。我完全不知道会是什么。他可能会写错，因为我没机会审核，也可能会歪曲事实。经历这些确实很奇怪，但结果很棒。

---

### (01:16:55) Jason Feifer

**English:**
Yeah, it is. It's very strange. It is, it's strange. And I find that people often don't ... In business, people understand the structure of what's happening. They understand that we're a business magazine, we're going to write a story about a business. It's going to take a certain form. But I've done a lot of different writing, and I have had the experience many times over my career where I will spend a lot of time with people, and they will have really no understanding of what it is that I'm doing at all. They can't conceptualize it. And then the story will come out and then they'll always reach out to me and they'll be like, oh, now I finally understand what you were even trying to do. It's fascinating.

**中文翻译:**
是的，非常奇怪。我发现人们通常不……在商业界，人们理解正在发生的事情的结构。他们知道我们是一本商业杂志，我们要写一个关于商业的故事，它会有某种形式。但在我的职业生涯中，我做过很多不同的写作，我多次遇到这种情况：我花了很多时间与人相处，而他们完全不理解我在做什么，无法想象。然后故事出来了，他们总是联系我说：“哦，现在我终于明白你到底想做什么了。”这很有趣。

---

### (01:17:40) Jason Feifer

**English:**
It is a vulnerable experience, and you have to know that. And the more you try to control it, the more the reporter is going to be annoyed at you. And the more, in fact, the reporter might try to take a shot at you in the story as a result. Because they found you too controlling because they felt like you had something to hide. This is not a comfortable thing. You have to go into this being vulnerable and you have to know that there's a chance that it could blow up in your face. That's the price that you're paying for reaching their audience.

**中文翻译:**
这是一种让自己处于弱势的体验，你必须明白这一点。你越想控制它，记者就越会反感你。事实上，记者可能会因此在报道中攻击你，因为他们觉得你控制欲太强，觉得你有事瞒着。这并不舒服。你必须带着这种脆弱感进入，并且知道有可能会搞砸。这就是你为了触达他们的受众所付出的代价。

---

### (01:18:19) Lenny

**English:**
Great advice. How about we do just one more example of an awesome email pitch that you got and then we get to our very exciting lightning round.

**中文翻译:**
很棒的建议。我们再看一个你收到的优秀邮件投递案例，然后进入我们非常精彩的闪电轮环节。

---

### (01:18:26) Jason Feifer

**English:**
I'll tell you about a pitch. I don't know that I have it in my inbox still, do I? No, it's not there, sadly. I'll just tell you about it. It leads to something that is another way of thinking about getting press, which I think is really important for people to remember. So far, Lenny, we've spent the majority of our time talking about press in the form of some kind of feature on you, writing about you or including you in some kind of prominent way in a story that's basically highlighting the thing that you wanted to get out there, your product or something about your business, something.

**中文翻译:**
我给你讲一个投递。我不确定它还在不在我的收件箱里……不在了，可惜。我就直接讲吧。它引出了另一种争取媒体报道的思考方式，我认为这对大家非常重要。Lenny，到目前为止，我们大部分时间都在讨论以“专题报道”形式出现的媒体报道——写关于你的故事，或者在故事中以显著方式提到你，基本上是突出你想宣传的东西，比如你的产品或业务。

---

### (01:19:18) Jason Feifer

**English:**
Then we talked a little bit about another way of doing it, which is sort of putting you out as an expert in authority. There's another way of thinking about this, which is that you can either create or present context in which you just happen to be a part. Here's the story pitch that I got that leads into this. This is years and years and years ago. I had just started at Entrepreneur. I hear from a guy named Fred Ruckel. Fred Ruckel has got a cat toy and it's called the Ripple Rug. It's basically, imagine a rug and then another rug kind on top of it, but ill-suited. The rug is lumpy, there's a lot of lumps in and there are holes. This is for a cat to kind of crawl in and out these spaces and bat and do whatever cats do.

**中文翻译:**
然后我们稍微谈到了另一种方式，即把你塑造成权威专家。还有第三种思考方式：你可以创造或呈现一个背景，而你恰好是其中的一部分。这就是我收到的引出这个观点的故事投递。那是很多很多年前，我刚开始在《企业家》工作。我收到一个叫 Fred Ruckel 的人的消息。Fred 有一个猫玩具，叫 Ripple Rug。基本上，想象一块地毯，上面盖着另一块不太平整的地毯。地毯是隆起的，有很多鼓包和洞。这是为了让猫在这些空间里钻进钻出，拍打，做猫爱做的任何事。

---

### (01:20:16) Jason Feifer

**English:**
I don't know. I don't know a cat. He wanted to tell me about the sales of this Ripple Rug and about how the sales are skyrocketing and all the things that he thought made it special. It's made out of recycled bottles and whatever the stuff, made in the USA, all cool stuff, but not relevant to me because we're not cat toy monthly and we're not reaching a whole bunch of cat owners, not that I know of. I replied and I said, what I usually say, "Congratulations on what you've built, but it's just not a fit for coverage." Now Fred stumbled his way into this, but he did really a very smart thing because what he responded with was he said, "Totally understand. If you're ever interested in learning about a gigantic scam that's happening on Amazon and eBay that we've been caught up in, let me know."

**中文翻译:**
我不懂猫。他想告诉我 Ripple Rug 的销量，说销量如何飙升，以及他认为让它特别的所有东西：它是用回收瓶子做的，美国制造，这些都很酷，但与我无关，因为我们不是《猫玩具月刊》，我们也不接触大量的猫主人（据我所知）。我回复了通常会说的话：“祝贺你所取得的成就，但这不适合报道。”Fred 误打误撞地做了一件非常聪明的事，他回信说：“完全理解。如果你对亚马逊和 eBay 上正在发生的一个巨大的骗局感兴趣，而我们也卷入其中了，请告诉我。”

---

### (01:20:53) Jason Feifer

**English:**
I was like, "Oh, well, yeah, I guess I am interested in hearing about that." I said, "Tell me more." He sent me this long email. Fred loves long emails, and I got him on the phone and had him explain, and finally I understood it. This is, and maybe people are familiar with this, but this is sort of known as Amazon to eBay arbitrage. Basically the idea here is that Fred is selling his Ripple Rug on Amazon, or at least he was then, I don't know if he still is, but he's selling his Ripple Rug on Amazon. There are a lot of people who are copying the listing for his Ripple Rug and making their own postings for it on eBay. They sell it for a slightly higher price.

**中文翻译:**
我心想：“哦，好吧，我想我确实有兴趣听听。”我说：“多讲讲。”他给我发了一封长邮件。Fred 喜欢写长邮件。我跟他通了电话让他解释，最后我终于明白了。这（也许人们很熟悉）被称为“亚马逊到 eBay 的套利”（Amazon to eBay arbitrage）。基本思路是：Fred 在亚马逊上卖他的 Ripple Rug。有很多人复制他在亚马逊上的商品详情，并在 eBay 上发布自己的商品信息，价格稍微高一点。

---

### (01:21:47) Jason Feifer

**English:**
Let's say that, and again, I'm making these up, but let's say the Fred is selling his Ripple Rug for $30 on Amazon, so somebody will sell it for $40 on eBay. Then somebody buys it on eBay, they find it, they buy it on eBay, they pay $40, that person gets $40, takes $30 of it, goes to Amazon, buys the Ripple Rug, and then just has it shipped to the buyer. It's arbitrage. You might think, "Well, why would Fred care about this? He still gets the sale." The reason he caress about this is because the Ripple Rug shows up at the customer's house and it shows up in a Amazon box, even though they bought it on eBay. They think, "Why did that happen?" Then the next thing they do is they go to Amazon and they discover that it's cheaper on Amazon and now they feel ripped off.

**中文翻译:**
假设（我随便举个数字）Fred 在亚马逊上卖 30 美元，有人在 eBay 上卖 40 美元。有人在 eBay 上发现了它并支付了 40 美元，那个人拿到 40 美元后，拿出 30 美元去亚马逊买下 Ripple Rug，然后直接寄给买家。这就是套利。你可能会想：“Fred 为什么要在乎？他还是卖出去了啊。”他在乎的原因是：Ripple Rug 送到客户家时，装在亚马逊的盒子里，尽管他们是在 eBay 买的。他们会想：“为什么会这样？”接着他们去亚马逊一看，发现亚马逊更便宜，于是觉得自己被坑了。

---

### (01:22:21) Jason Feifer

**English:**
Who do they feel like they got ripped off by? Fred, because they don't know about the arbitrage. They don't know that they exist. This person who has at this point opened the cat toy and probably had their cat roll around in it, now shoves the whole thing back in a box and returns it and Fred gets dinged and that's why he doesn't like this. He has tried and tried and tried to get Amazon and eBay to stop this, but he said, "Nobody seems to care and all these small businesses are losing tons of money on returns because of this." I had never heard of this. I thought it was fascinating. It's like a problem small business owners are dealing with. I was like, "Fred, do you know other people who are dealing with this?" He's like, "Yeah, I talk to them on the line all the time." He sends me off.

**中文翻译:**
他们觉得是被谁坑了？Fred。因为他们不知道套利者的存在。这个已经打开猫玩具、可能猫已经滚过一圈的人，现在把东西塞回盒子退货了，Fred 因此受到了损失，这就是他不满的原因。他尝试了无数次让亚马逊和 eBay 停止这种行为，但他说：“似乎没人关心，所有这些小企业都因为退货损失了大量资金。”我从未听说过这种事，我觉得这太引人入胜了。这是一个小企业主面临的问题。我问：“Fred，你认识其他面临这个问题的人吗？”他说：“认识，我经常在网上和他们交流。”

---

### (01:23:15) Jason Feifer

**English:**
I reported this whole thing out. I wrote this three 4,000 word story on this thing, and Fred was the main character because he was the way to understand this problem. I did all the reporting and I contacted the platforms and I contacted the people who make the arbitrage software. I did a whole report, but Fred got his press because sometimes, and here's the lesson, sometimes you are not the story, but you can be part of the story. Sometimes that means if Fred stumbled into it, but I get plenty of people who've reach out and maybe they have a real estate startup and there's something really interesting happening in the real estate space and they reach out and they tell me about this really interesting thing that's happening in the real estate space and the role that they happen to play in it. Now I think, "Oh, well that's interesting. Maybe there's a story about that."

**中文翻译:**
我把整件事报道了出来。我写了一篇三四千字的故事，Fred 是主角，因为他是理解这个问题的切入点。我做了所有的采访，联系了平台，联系了制作套利软件的人。我做了一个完整的专题，Fred 获得了报道。教训是：有时你本身不是故事，但你可以成为故事的一部分。Fred 是误打误撞，但我收到过很多人的联系，比如他们有一家房地产初创公司，房地产领域发生了一些非常有趣的事，他们联系我并告诉我这件事，以及他们恰好在其中扮演的角色。我会想：“哦，那很有趣，也许可以写个故事。”

---

### (01:23:58) Jason Feifer

**English:**
My wife, the freelancer, Jen Miller, she's done this many times where she once did this story about there was a bunch of startups that were all related to helping people prepare for death in some way or another. She's not going to write about one of them, but when somebody reached out and said, "Hey, here's a trend happening and we are one of them." Well, great, that's an interesting story. She wrote that and the company that reached out to her got kind of prominent billing because they were the ones who reached out. You know Barbara Corcoran from Shark Tank?

**中文翻译:**
我妻子 Jen Miller 作为一个自由撰稿人也多次这样做。她曾写过一个关于一群初创公司的故事，这些公司都以某种方式帮助人们为死亡做准备。她不会单独写其中一家，但当有人联系她说：“嘿，这里有一个趋势，我们是其中之一。”太好了，这是一个有趣的故事。她写了那个故事，而联系她的那家公司获得了相当显著的版面，因为是他们主动联系的。你知道《创智赢家》（Shark Tank）里的 Barbara Corcoran 吗？

---

### (01:24:14) Lenny

**English:**
I think so. I think so.

**中文翻译:**
我想我知道。

---

### (01:24:15) Jason Feifer

**English:**
Yeah. She's been a regular Shark Tank since the very beginning. She made her fortune by building a real estate company called Corcoran, realtors, buy and sell property. The way in which she built this company is fascinating. Barbara, before she was Barbara Corcoran of Corcoran Realty, Barbara Corcoran was random New York City realtor Barbara from New Jersey. She was trying to figure out a way to distinguish herself from the masses. She came up with an idea which was to take her own sales data, the only window she has into the Manhattan real estate market at that time is what she is what her clients are buying and selling, which she's facilitating. She has that data, is going up or down relative to last year.

**中文翻译:**
是的，她从一开始就是《创智赢家》的常驻嘉宾。她通过建立一家名为 Corcoran 的房地产公司发家致富。她建立这家公司的方式非常迷人。在成为 Corcoran 地产的 Barbara Corcoran 之前，她只是一个来自新泽西、在纽约市工作的普通房产经纪人。她试图想办法让自己从大众中脱颖而出。她想出了一个主意：利用她自己的销售数据。当时她了解曼哈顿房地产市场的唯一窗口就是她客户的买卖情况。她拥有这些数据，知道相对于去年是涨了还是跌了。

---

### (01:25:18) Jason Feifer

**English:**
She puts all this data together in what she calls the Corcoran Report, and she starts sending the Corcoran Report out to the New York Times and the New York Post and whatever. Because nobody else at the time was putting together a report on the health of the Manhattan real estate market, everyone started reporting on the Corcoran Report as if it was an authoritative thing. It's produced by Barbara Corcoran, which immediately put her in the position of being an authority in this space. That was so smart, and I see it happen all the time.

**中文翻译:**
她把所有这些数据整合在一起，称之为《Corcoran 报告》，并开始把它发给《纽约时报》、《纽约邮报》等媒体。因为当时没有其他人针对曼哈顿房地产市场的健康状况发布报告，所有人开始像对待权威文件一样报道《Corcoran 报告》。它是由 Barbara Corcoran 制作的，这立刻让她成为了该领域的权威。这太聪明了，我经常看到这种情况发生。

---

### (01:25:37) Jason Feifer

**English:**
My inbox will also be filled with, for example, a company that specializes in remote work consulting. Especially remote work consulting, you can hire them, it's a B2B service. It's hard to get press for that, here's what they do. They pay a surveying firm to find all sorts of things. The top states for remote work, the top companies for remote work, the top whatever for remote work. They produce all these surveys and they send the surveys out. The surveys get covered because now they're creating a piece of news. They're creating some context in which they just happen to live in. Hard to write about them, this random company, but you write about the survey, that's interesting stuff. Oh, it turns out that Utah is the top, I don't know if that's true, is the top state for, that's something that people will write about. You're giving people things to write about. Then once they do that, you are a part of the story. I get those pitches all the time. I occasionally bite on them and Fred from Ripple Rug got himself a big feature as a result.

**中文翻译:**
我的收件箱里也经常塞满这类东西，比如一家专门做远程办公咨询的公司。远程办公咨询是一种 B2B 服务，很难获得媒体报道。他们是这么做的：他们付钱给调查公司去调查各种事情，比如“最适合远程办公的州”、“最适合远程办公的公司”等等。他们制作这些调查报告并发送出去。调查报告获得了报道，因为他们创造了一条新闻，创造了一个他们恰好身处其中的背景。很难写这家名不见经传的公司，但写调查报告很有趣。比如“犹他州是远程办公的首选州”，人们会写这个。你是在给人们提供写作素材。一旦他们写了，你就是故事的一部分。我经常收到这种投递，偶尔也会采纳，Ripple Rug 的 Fred 就因此获得了一个大专题。

---

### (01:26:38) Lenny

**English:**
That's an amazing other strategy. I imagine if I was a founder, I'd be like, "Hmm, what trends can I think about that I can tap into?"

**中文翻译:**
这真是另一个绝妙的策略。我想如果我是创始人，我会想：“嗯，我能想到哪些可以利用的趋势？”

---

### (01:26:44) Jason Feifer

**English:**
Yeah. Sometimes you have it in your own data. If you have a lot of data, you might, Zapier. Zapier is a great example. I get a pitch from Zapier every single year about the fastest growing business apps of the year based on Zapier data because they see what people are using and they just compile that together into a top 10 list and people run it. It's very smart.

**中文翻译:**
是的。有时数据就在你手里。如果你有大量数据，你就可以这么做。Zapier 就是一个很好的例子。我每年都会收到 Zapier 的投递，关于“基于 Zapier 数据的年度增长最快的商业应用”，因为他们能看到人们在用什么，他们只需将其整理成前 10 名名单，媒体就会发布。这非常聪明。

---

### (01:27:09) Lenny

**English:**
Amazing. We've gone through all three steps. Is there anything else that you wanted to touch on that we haven't touched on? Anything else that you think would be really valuable for founders or product leaders trying to get press that we haven't already shared?

**中文翻译:**
太棒了。我们已经讲完了所有三个步骤。还有什么我们没提到但你想补充的吗？还有什么你认为对寻求媒体报道的创始人或产品负责人非常有价值的内容吗？

---

### (01:27:23) Jason Feifer

**English:**
This has come up in different ways, but I'll just put a point on it as a maybe final way of thinking about this. Be human, be human. Press releases don't work because they're not human. I don't like interviewing people who are on talking points because that's not human. You're ultimately engaging in a human business. A subjective decision is being made about how to serve an audience of humans. There's no right or wrong. There's no way to know. Media is a sort of barely data-driven industry because every story is kind of different. It's like it's hard. It's hard to optimize the product because the product changes every minute. You're dealing with humans and the more that you can be human in every step of this process, when you pitch, write a human email, don't write a thing that looks like it came off of some marketing copy. Write a human email to another human and then when that person engages with you, be very human with them.

**中文翻译:**
这一点在不同场合都提到过，但我还是想把它作为最后一种思考方式来强调：要做一个真实的人（Be human）。新闻稿之所以不起作用，是因为它们没有人情味。我不喜欢采访那些只说“口径内的话”的人，因为那不像真人。你最终从事的是一个关于人的行业。一个主观的决定正在被做出，目的是为了服务于人类受众。没有对错，无法预知。媒体几乎不是一个数据驱动的行业，因为每个故事都不同。优化产品很难，因为产品每分钟都在变。你在和人打交道，在这个过程的每一步，你越像个真人越好。当你投递时，写一封有人情味的邮件，不要写得像营销文案。给另一个真人写一封真诚的邮件，当那个人与你互动时，表现得像个真实的人。

---

### (01:28:26) Jason Feifer

**English:**
I mean, Lenny, the reason why that fast company reporter liked you, I am very sure was because when they got on the phone with you, you were just like a normal nice guy. If you presented yourself differently because you just wanted to frame yourself in some way or you felt protective or something or whatever it was, the reporter would've thought, "This guy is a dick," and he would've written a totally different story. Be as human as you can and you will be dealing with a human who will receive that.

**中文翻译:**
Lenny，我敢肯定《快公司》的记者之所以喜欢你，是因为当他们和你通电话时，你表现得就像个正常的、友善的家伙。如果你因为想塑造某种形象，或者因为防御心理而表现得不同，记者可能会觉得“这家伙是个混蛋”，然后写出一个完全不同的故事。尽可能表现得真实，你面对的也是一个会接收到这种真实感的真人。

---

### (01:28:59) Lenny

**English:**
Amazing advice. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
很棒的建议。至此，我们进入了非常精彩的闪电轮环节。准备好了吗？

---

### (01:29:04) Jason Feifer

**English:**
Yeah.

**中文翻译:**
准备好了。

---

### (01:29:05) Lenny

**English:**
Let's do it. What are two or three books that you've recommended most to other people?

**中文翻译:**
开始吧。你向别人推荐最多的两三本书是什么？

---

### (01:29:12) Jason Feifer

**English:**
Andrew Chen's, The Cold Start Problem has come up over and over again for me because they're just really great lessons about network effects. I've been having a lot of conversations about anxiety and perfectionism with entrepreneurs lately, and a book by a psychotherapist named Katherine Morgan Schafler called The Perfectionist's Guide to Losing Control, is, I think, just a really great read.

**中文翻译:**
陈嘉兴（Andrew Chen）的《冷启动问题》（The Cold Start Problem），我反复提到它，因为里面关于网络效应的教训非常棒。最近我经常和企业家讨论焦虑和完美主义，心理治疗师 Katherine Morgan Schafler 的《完美主义者的失控指南》（The Perfectionist's Guide to Losing Control）我认为非常值得一读。

---

### (01:29:34) Lenny

**English:**
Super cool. What is a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
超酷。最近有什么你非常喜欢的电影或电视节目吗？

---

### (01:29:38) Jason Feifer

**English:**
Movie? I don't get to see a lot of movies these days. I have two little kids, but I took my eight-year old to see the new Teenage Mutant Ninja Turtles, which was great and a really nice way of, I loved them as a kid, and so it was cool to see the modern version. Then my wife and I just finished Better Call Saul like years late, but it was just perfect.

**中文翻译:**
电影？我最近没怎么看电影，我有两个小孩。但我带我八岁的孩子看了新的《忍者神龟》，非常棒。我小时候就很喜欢他们，所以看到现代版很酷。然后我和妻子刚看完《风骚律师》（Better Call Saul），虽然晚了好几年，但它简直完美。

---

### (01:29:56) Lenny

**English:**
I haven't watched that series yet. I loved Breaking Bad.

**中文翻译:**
我还没看那部剧。我很喜欢《绝命毒师》。

---

### (01:29:59) Jason Feifer

**English:**
Oh, it's worth it. You got to.

**中文翻译:**
哦，值得一看，你一定要看。

---

### (01:30:01) Lenny

**English:**
Okay. Another series I got to get started on. I usually ask this next question too, like product leaders and growth people, but I'm curious what the answer for you would be is. Do you have a favorite interview question you like to ask people you're interviewing? Usually it's about people you're hiring.

**中文翻译:**
好，又一部要开始追的剧。我通常也会问产品领导者和增长专家下一个问题，但我很好奇你的答案：你面试别人时最喜欢问的问题是什么？通常是指你招聘的人。

---

### (01:30:16) Jason Feifer

**English:**
Interviewing a job candidate?

**中文翻译:**
面试求职者吗？

---

### (01:30:16) Lenny

**English:**
Yeah, that's the ideal, but take it either way.

**中文翻译:**
是的，那是理想情况，但你怎么理解都行。

---

### (01:30:19) Jason Feifer

**English:**
I'll take it a little bit different because we've been talking about press. This is a really great strategy for interviewing people, and I'm going to tell it to you because I think that it's also good in any other context, and it might be a thing that somebody will do to you in an interview. My favorite strategy for interviewing people is to throw a theory at them, and I don't mean a theory of the world. I mean that maybe 10 minutes in after they have told me a couple different things and answer some different questions, I'll make a connection in my head and I'll say, "I want to run a theory by you. Do you think that the reason why you are really interested in this or you made that decision is actually because of this other thing that you told me a little bit about?"

**中文翻译:**
我会从稍微不同的角度来回答，因为我们一直在谈论媒体采访。这是一个非常棒的面试策略，我告诉你是因为它在任何其他语境下也适用，而且面试时别人也可能对你用这一招。我最喜欢的面试策略是向对方抛出一个“理论”，我不是指世界观理论。我的意思是，在对方说了几件事并回答了几个问题约 10 分钟后，我会在脑子里建立一个联系，然后说：“我想跟你探讨一个理论。你觉得你对这件事感兴趣，或者做出那个决定的原因，实际上是因为你刚才提到的另一件事吗？”

---

### (01:30:59) Jason Feifer

**English:**
You're listening. It's really active listening, and you're combining things together into some theory. The reason why the theory works so well is because it forces people to think in real time in front of you. I like that because I often interview people who have been interviewed a million times before. I interview Jimmy Fallon and The Rock and whatever. They've been interviewed a million times before, so how do you get them to think in front of you? The answer is to ask them the thing that they haven't been asked. What I love about the theory is that it shows them that you're really listening and you're trying to understand them. "It's so interesting that you did that. I wonder if it's because of," X, Y, Z thing. That gets them to react in a really earnest honest way.

**中文翻译:**
你在倾听，这是真正的积极倾听，你把各种信息组合成一个理论。这个策略之所以有效，是因为它迫使人们在你面前实时思考。我喜欢这一点，因为我经常采访那些已经被采访过无数次的人，比如 Jimmy Fallon 或“巨石”强森。他们被采访过一百万次了，你怎么让他们在你面前思考？答案是问他们没被问过的问题。我喜欢这种“理论”方式，因为它向对方展示了你真的在听，并且在努力理解他们。“你那样做很有趣，我在想是不是因为 X、Y、Z 呢？”这会让他们做出非常真诚、诚实的反应。

---

### (01:31:49) Jason Feifer

**English:**
I would say for what it's worth, as a job candidate tactic, it's not that bad either. My favorite job interview that I ever did as a candidate that I didn't even get the job was years and years ago, I interviewed for a job at New York Magazine. I interviewed with Adam Moss, who is not there anymore, but he was the legendary editor in chief. He made me, on the spot, drill down specifically into an idea. He was like, "What's your favorite section in Strategists," which is one of the sections of magazine. I was like, "I really like the real estate section." He's like, "All right, what would be a good neighborhood that we should feature in the real estate section?" I was like, "Oh, I don't know," I named a neighborhood. He's like, "What would be three good elements of that?" He just kept pushing me, drill down, drill down, drill down. There was no right or wrong answer. He just wanted to see how I thought. I found that to be incredibly powerful, and I do a version of that when I interview people.

**中文翻译:**
我想说，作为求职者的策略，这也不赖。我作为候选人参加过的最喜欢的面试（虽然我没拿到那份工作）是很多年前在《纽约杂志》（New York Magazine）的面试。面试官是 Adam Moss，他现在不在那儿了，但他是位传奇总编辑。他让我当场深入探讨一个想法。他问：“你最喜欢《策略家》（Strategists，杂志版块名）里的哪个版块？”我说：“我非常喜欢房地产版块。”他说：“好，我们应该在房地产版块介绍哪个社区？”我说：“哦，我不知道，”然后随口说了一个社区。他接着问：“那个社区的三个亮点是什么？”他一直逼我深入、深入、再深入。没有标准答案，他只是想看我如何思考。我觉得这非常强大，我在面试别人时也会用类似的方法。

---

### (01:32:48) Lenny

**English:**
Awesome. I love that. What is a favorite product you've recently discovered that you really like?

**中文翻译:**
太棒了，我喜欢这个。你最近发现并非常喜欢的某个产品是什么？

---

### (01:32:54) Jason Feifer

**English:**
I use BIGVU, I don't even know how to pronounce it, BIGVU, B-I-G-V-U, all the time. It's a teleprompter app. I spent like $150 buying an actual teleprompter because I make a lot of video and that teleprompter is, it's actually for people who are just listening to this, I'm pointing at another desk across my room where it's sitting there and I've never used it. The reason is because then I discovered BIGVU, which is just a app that runs a teleprompter very close to the camera, either in horizontal or vertical mode. I've tested it out in a million different ways, and it really works like you're reading it and it really looks like you're looking directly at the camera. I love it. It has saved me so much time.

**中文翻译:**
我一直在用 BIGVU（我甚至不知道怎么读，B-I-G-V-U）。它是一个提词器应用。我曾花 150 美元买了一个真正的提词器，因为我拍很多视频。那个提词器现在就在我房间另一张桌子上（对听众说明一下，我正指着它），但我从来没用过。原因是我发现了 BIGVU，它只是一个应用，可以让提词器非常靠近摄像头运行，无论是横屏还是竖屏。我测试了无数次，效果非常好，就像你在读稿子，但看起来你是在直视摄像头。我太喜欢它了，它帮我节省了大量时间。

---

### (01:33:33) Lenny

**English:**
That is cool. You basically put your phone on your screen next to the camera or wherever your camera is?

**中文翻译:**
那很酷。你基本上是把手机放在屏幕上摄像头旁边，或者摄像头所在的位置？

---

### (01:33:39) Jason Feifer

**English:**
No, no, no. This would be for if you're recording, if you're recording on the phone.

**中文翻译:**
不不不，这是用于当你用手机录制时。

---

### (01:33:44) Lenny

**English:**
Got it. You're staring at the phone and it's telling you what to say. I get it.

**中文翻译:**
明白了。你盯着手机，它告诉你该说什么。我懂了。

---

### (01:33:44) Jason Feifer

**English:**
Yeah. Yeah.

**中文翻译:**
是的。

---

### (01:33:44) Lenny

**English:**
That's awesome.

**中文翻译:**
太棒了。

---

### (01:33:47) Jason Feifer

**English:**
You write a script and then you just import the script and then you choose the speed and you can fuss with it, how many words per minute, and then it'll run the text very close to where the camera lens is.

**中文翻译:**
你写好脚本，导入进去，选择速度，你可以调整每分钟多少个单词，然后文字就会在非常靠近摄像头镜头的地方滚动。

---

### (01:34:01) Lenny

**English:**
Amazing. All right. I'm going to check that out. What is a favorite life motto that you'd like to repeat yourself, share with friends, something that comes up a lot,

**中文翻译:**
太神奇了。好，我会去看看。你最喜欢的人生格言是什么？你会对自己重复、与朋友分享、或者经常提到的话。

---

### (01:34:10) Jason Feifer

**English:**
Something that I've been repeating a lot to people is something that I heard, so I recommended Katherine's book, The Perfectionist Guide to Losing Control. I met Katherine because I, we've since become friends, but I interviewed her for the podcast when her book came out. We were talking about feeling overworked and being stretched too thin, and she gave me this question, which I think about almost daily, and I repeat to people all the time, and that is, "What's the point of building something if you can't maintain it?" I love that question because I, like probably everyone listening to this, pushes themselves really hard, and at some point you have to step back and think, "Am I building something where at some point there is sustainability for me here, or is this unsustainable and what's the point of building something if you can't maintain it?" It's a great reminder for why you're building something and how you have to build it.

**中文翻译:**
我最近经常对人重复的一句话是我听来的。我推荐了 Katherine 的书《完美主义者的失控指南》。我认识 Katherine 是因为我采访了她，后来我们成了朋友。我们当时在聊工作过度、精力分散的问题，她问了我一个问题，我现在几乎每天都会想到，也经常对别人说，那就是：“如果你无法维持它，那么建造它的意义何在？”我非常喜欢这个问题，因为我（可能还有正在听节目的每个人）总是把自己逼得很紧。在某个时刻，你必须退后一步思考：“我正在建造的东西在未来对我来说是可持续的吗？还是不可持续的？如果你无法维持它，建造它的意义何在？”这是一个关于你为什么要建造以及如何建造的绝佳提醒。

---

### (01:35:03) Lenny

**English:**
I have a very similar quote that my sister's partner once said that has stuck with me forever, which is, "Life is maintenance. Basically everything that you buy or bring into your life, you have to maintain." We got a new air conditioner. Now, we have a guy that comes every year to check it. You got a generator, someone's got to check that thing all the time. We got a toy, now I got to think about where does it go and do we throw it away? Do we keep it? Everything that you bring into your life, you have to maintain basically for the rest.

**中文翻译:**
我有一个非常类似的句子，是我姐姐的伴侣曾经说的，一直深深印在我的脑海里：“生活就是维护。基本上你买的或带入生活的每样东西，你都必须维护。”我们买了个新空调，现在每年都要请人来检查。你买了个发电机，得一直有人检查。我们买了个玩具，现在我得考虑它放哪，是扔掉还是留着？你带入生活的每样东西，基本上余生都要去维护。

---

### (01:35:17) Jason Feifer

**English:**
Yeah, it's really true.

**中文翻译:**
是的，确实如此。

---

### (01:35:33) Lenny

**English:**
Yeah, so it's really, I think specifically for work, it's like you start a new project, you're going to have to maintain it, like this podcast, right? It's like, do you want to start a podcast and do it forever? That's a part of it. Part starting something is you have to maintain it.

**中文翻译:**
是的，我认为特别是在工作中，就像你开始一个新项目，你就必须维护它，就像这个播客，对吧？你想开始一个播客并永远做下去吗？这是其中的一部分。开始某件事的一部分就是你必须维护它。

---

### (01:35:49) Jason Feifer

**English:**
I know we're in the lightning round and we've defied the logic of lightning rounds, but I'll just add one other thing to that, which is that I interviewed Michelle Pfeiffer for the cover of the magazine, and one of the things that I thought was most fascinating was that she started this fragrance company, and it's called Henry Rose. She said the major difference between making movies and building a company that she found, was that when you make a movie, all the work happens in the beginning. You make the movie and then the movie is out, and then you are done. You don't have to work on the movie ever again. She was not really mentally prepared for a company being the exact opposite, that the launch of the company is actually the start of the work and there's an endlessness to it. She said that it took her a solid year to adapt to that reality, and then it became fun. I think it's the thing people forget.

**中文翻译:**
我知道我们在闪电轮环节，而且我们已经违背了闪电轮的逻辑，但我还要补充一点：我曾为杂志封面采访过 Michelle Pfeiffer。我觉得最有趣的一点是，她创办了一家香水公司叫 Henry Rose。她说她发现拍电影和创办公司最大的区别在于：拍电影时，所有的工作都发生在前期。你拍完电影，电影上映，你就完事了，再也不用为那部电影工作了。她心理上没准备好创办公司恰恰相反——公司的发布实际上只是工作的开始，而且是永无止境的。她说她花了一整年时间才适应这个现实，然后才觉得有趣。我觉得这是人们容易忘记的一点。

---

### (01:36:42) Lenny

**English:**
Mm-hmm, Well, that story, it's cool that you got to interview Michelle Pfeiffer. Final question. I was reading your profile line and you said that the only reason you were able to achieve what you've achieved in life and got to where you're today is something that you called the opportunity set B. Can you just explain what that is and why that is so important to you?

**中文翻译:**
嗯，那个故事很棒，能采访 Michelle Pfeiffer 真的很酷。最后一个问题：我读了你的简介，你说你之所以能取得今天的成就，唯一的功劳在于你所谓的“机会集 B”（opportunity set B）。你能解释一下那是什么，以及为什么它对你如此重要吗？

---

### (01:37:02) Jason Feifer

**English:**
Oh, yeah, sure. In front of you right now, you, Lenny, you everyone listening, watching, there are two sets of opportunities. Opportunity set A and opportunity set B, opportunity set A is everything that's asks of you. If you have a job, it's what your boss expects of you. If you have your own company, it's what everybody expects of you. Doing good at those things is really important. That's a measurement of success. That's opportunity set A, everything that's asked of you. Then there's opportunity set B and opportunity set B is what's available to you, even though nobody's asking you to do it.

**中文翻译:**
噢，当然。现在摆在你面前（Lenny，还有每一位听众和观众）有两组机会：机会集 A 和机会集 B。机会集 A 是所有对你的要求。如果你有一份工作，那就是老板对你的期望；如果你有自己的公司，那就是所有人对你的期望。做好这些事非常重要，那是成功的衡量标准。这就是机会集 A，所有被要求做的事。然后是机会集 B，它是那些摆在你面前、即使没人要求你去做的事。

---

### (01:37:38) Jason Feifer

**English:**
That could be, again, if you have a job, that could be taking on new responsibilities or joining a new team or something. Personally, it could be pursuing a hobby. It could be starting a podcast because you like listening to podcasts, anything. What I have found throughout my own career is that opportunity set B is always more important, infinitely more important. The thing is that if you only focus on opportunity set A, then you are only qualified to do the things that you're already doing. Opportunity set B is where growth happens and where you push yourself in different directions.

**中文翻译:**
如果你有一份工作，那可能是承担新的责任或加入一个新团队。在个人层面，可能是追求一个爱好，或者因为喜欢听播客而开始做一个播客，任何事。在我的职业生涯中，我发现机会集 B 总是更重要，无限重要。问题在于，如果你只关注机会集 A，那么你只够格去做你已经在做的事。机会集 B 才是增长发生的地方，是你把自己推向不同方向的地方。

---

### (01:38:21) Jason Feifer

**English:**
I have always found, always, that engaging in these things of what is available to me, what's available to me right now around me, and nobody's asking me to do, leads to the next growth either because it turns into an actual opportunity or because it informs some future opportunity. I got to Entrepreneur Magazine, zero, zero people, when I became editor in chief, zero people said, "You should hit the speaking circuit. You should get really good at being interviewed on podcasts. You should write a book." Nobody said any of that. My job was to make a good magazine and direct the editorial of the brand, but all those things were available to me, and once I recognized that, I realized that I can pursue them and in doing so, also think differently about who I am.

**中文翻译:**
我总是发现，参与这些摆在我面前、就在我身边、且没人要求我做的事，会带来下一次增长，要么是因为它变成了一个真正的机会，要么是因为它为未来的某个机会提供了信息。我来到《企业家》杂志，当我成为总编辑时，没有任何人对我说：“你应该去巡回演讲，你应该练好接受播客采访，你应该写本书。”没人说过。我的工作是办好杂志，指导品牌的编辑方向。但所有那些机会都摆在我面前，一旦我意识到这一点，我就能去追求它们，并在此过程中重新思考我是谁。

---

### (01:39:27) Jason Feifer

**English:**
Am I a magazine editor? Not really anymore. That's one of the things that I do now. I think of myself as an entrepreneur, as a person who is now in the business of helping others. I'm an entrepreneur who helps entrepreneurs. That's what I think of myself as. I only got there because I was thinking, I am here and therefore I can get there. Nobody's ever going to ask me to do it. I have to do it myself. It's the thing that I always think about, and it's the thing that keeps me up at night. What am I doing now that is leading me to something else? I'm the only one who can figure it out.

**中文翻译:**
我还是个杂志编辑吗？现在不完全是了。那只是我现在做的事情之一。我把自己看作一个企业家，一个现在致力于帮助他人的人。我是一个帮助企业家的企业家。这就是我对自己的定位。我之所以能走到这一步，是因为我在想：“我在这里，所以我可以到达那里。”没人会要求我去做，我必须自己动手。这是我一直在思考的事，也是让我夜不能寐的事：我现在做的什么事正引导我走向别处？只有我自己能弄清楚。

---

### (01:39:59) Lenny

**English:**
Beautiful. It reminds me of a recent podcast guest's advice, which is the best way to track your progress in your career and in life too is just measuring how many, "Oh shit" moments you have because those are the moments where you're growing, you're doing something. I think maybe it's an example of an opportunity set B where it wasn't the default path that's like, "oh, I think I should do this, even though it's really hard."

**中文翻译:**
太美妙了。这让我想起最近一位播客嘉宾的建议：衡量职业生涯和生活进步的最好方法，就是看你经历了多少个“噢，糟糕”（Oh shit）的时刻，因为那些时刻正是你成长、在做实事的时刻。我想这也许就是机会集 B 的一个例子，它不是默认的路径，而是“哦，我觉得我应该做这个，尽管它很难”。

---

### (01:40:20) Jason Feifer

**English:**
Yeah.

**中文翻译:**
是的。

---

### (01:40:22) Lenny

**English:**
What a beautiful way to end it. Jason, not only do I want to start working on press, it feels like very achievable to get press now. That was really energizing, like, "Holy shit, I could do this. I could just find some people, pitch them. Here's how I do it." Not only that, I'm going to look for some opportunities set B routes for myself too. Thank you so much for being here. Two final questions. Where can folks find you online if they want to reach out, maybe pitch you on their story? How can listeners be useful to you?

**中文翻译:**
多么完美的结尾。Jason，我现在不仅想开始着手媒体报道，而且觉得获得报道是非常可行的。这真的很让人振奋，就像“天哪，我能做到。我只需要找些人，向他们投递。这就是方法。”不仅如此，我也要为自己寻找一些机会集 B 的路径。非常感谢你能来。最后两个问题：如果大家想联系你，或者向你投递他们的故事，可以在哪里找到你？听众能为你做些什么？

---

### (01:40:47) Jason Feifer

**English:**
Oh, so Lenny, thanks for all the work you do, which I just really love, and for creating the space for me to share all this insight. How can you find me? Well, I'll offer two things. An opportunity set B, like a good launching point for both of them, I wrote a book, it's called Build for Tomorrow. It is meant for anybody who's going through any kind of change in their lives or their work. There's an audiobook version that I read myself, but also hardcover and eBooks, just find it wherever you get books. Again, it's Build for Tomorrow. Opportunity set B, that whole thing, is actually a chapter in the book, so I go into a lot more detail there.

**中文翻译:**
噢，Lenny，谢谢你所做的一切，我真的很喜欢你的工作，也谢谢你为我提供分享见解的空间。怎么找到我？我提供两样东西。作为机会集 B 的一个很好的起点，我写了一本书，叫《为明天而建》（Build for Tomorrow）。它是为任何正在经历生活或工作变革的人准备的。有我自己朗读的音频书版本，也有精装书和电子书，在任何卖书的地方都能找到。书名是《为明天而建》。关于机会集 B 的全部内容实际上是书中的一个章节，我在那里讲得更详细。

---

### (01:41:20) Jason Feifer

**English:**
Then if you want to get in touch and also get those kinds of things, I have a newsletter, which is called One Thing Better each week. One way to improve your work and build a career or company that you love. Again, the kind of opportunities set B, that's the kind of thing that I put out. It's very much about the personal and emotional side of work. You can find that by going to the web address onethingbetter, that's one, O-N-E, onethingbetter.email. Just plug that in. Onethingbetter.email. I said that's a good way to reach out to me because if you get the newsletter and you reply to it, it goes to my inbox. I guarantee I will write back to you.

**中文翻译:**
如果你想联系我并获取这类信息，我有一个时事通讯，叫《每周进步一点点》（One Thing Better）。每周提供一个改进工作、建立你热爱的事业或公司的方法。同样，这也是机会集 B 的一种形式。它更多关于工作的个人和情感层面。你可以访问网址 onethingbetter.email（O-N-E-T-H-I-N-G-B-E-T-T-E-R.email）。这是一个联系我的好方法，因为如果你收到时事通讯并回复，它会直接进入我的收件箱。我保证会给你回信。

---

### (01:41:56) Lenny

**English:**
Inside track. Jason, thank you again so much for being here.

**中文翻译:**
内部渠道。Jason，再次感谢你能来。

---

### (01:42:01) Jason Feifer

**English:**
Oh, thanks Lenny. This was so fun.

**中文翻译:**
噢，谢谢 Lenny。这太有趣了。

---

### (01:42:03) Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。