# Jason Fried - 双语对照

This bilingual document captures the key insights from Lenny’s Podcast featuring Jason Fried, Co-founder and CEO of 37signals. The conversation explores the philosophy of bootstrapping, the power of constraints, and why staying small can be a competitive advantage.

---

### [00:00:00] Jason Fried

**English:**
The reason I think it's great for entrepreneurs to start bootstrapping is because they just have more practice making money, and they get better, and better, and better at the fundamental skill you need to have ultimately to run a successful business, which is to make money. Hopefully, I don't come off as encouraging everyone to be like me. I'm not saying that at all. What I'm saying is, this is a way to be. It's an alternative to what you're often hearing in our industry, which is, "Go big or go home. Raise a bunch of money and get huge, and unicorn status," and the whole thing. That's a way. Just know though that basically almost nobody makes it that way. Really, almost nobody really makes it that way, and there's a lot more room to make it, and to build a successful business, if you throw out that outlier and look at all the other places you can land as a business.

**中文翻译:**
我认为创业者选择“白手起家”（Bootstrapping，指不依赖外部融资）之所以很棒，是因为这能让他们在“赚钱”这件事上得到更多磨练。你会越来越擅长经营一家成功企业最终所需的最基本技能——那就是赚钱。希望我听起来不像是在鼓动每个人都变得跟我一样，我完全不是那个意思。我想说的是，这是一种生存方式。它是我们这个行业常听到的那种“要么做大，要么回家”、“融一大笔钱，追求规模和独角兽地位”等论调之外的另一种选择。那确实是一条路，但你要知道，基本上几乎没有人能通过那条路获得成功。真的，几乎没人能成。如果你抛开那种极少数的幸存者偏差，去看看企业可以立足的其他领域，你会发现其实有更大的空间去获得成功并建立一家出色的公司。

---

### [00:00:49] Lenny

**English:**
Today, my guest is Jason Fried. Jason is the Co-Founder and CEO of 37signals, which makes Basecamp and HEY... 37signals is a very different type of company. They have no investors, no board. They have no plans to go public. They never want to sell their business. They've made a profit for 24 years in a row. They have over 100,000 customers and make tens of millions of dollars in profit each year, which most VC-backed companies never make a dollar of. All of this profit filters down to the founders and employees because they have no investors. Most founders, by default, will go down the venture route raising money from VCs and Angels. For many types of companies, that is necessary. But it's also important to know that there is a different option available, and it can be much more fulfilling and fun, and even much more lucrative, by bootstrapping your idea.

**中文翻译:**
今天的嘉宾是 Jason Fried。Jason 是 37signals 的联合创始人兼 CEO，这家公司开发了 Basecamp 和 HEY……37signals 是一家非常独特的公司。他们没有投资者，没有董事会，没有上市计划，也从未想过卖掉公司。他们已经连续 24 年盈利。他们拥有超过 10 万名付费客户，每年创造数千万美元的利润，而大多数风投支持（VC-backed）的公司甚至从未赚过一分钱。由于没有外部投资者，所有这些利润都直接流向了创始人和平等员工。大多数创始人默认会走风险投资的道路，向风投和天使投资人融资。对于许多类型的公司来说，这确实是必要的。但同样重要的是，你要知道还有另一种选择，通过自筹资金实现你的想法，可能会让你更有成就感、更有趣，甚至更赚钱。

---

### [00:05:44] Jason Fried

**English:**
We don't talk about things that don't really matter so much, like revenues don't really matter 'cause you can go broke generating a lot of money. But, we talk about profits. Historically, let's say over the past 10 years or so, we've been profitable every year for 24 years. But let's say over the last 10 years, we've been doing double-digit million dollar profits on an annual basis, which is really nice. We have about a 100,000 plus paying customers... and we've about currently 75 or so employees. So, a relatively small business in terms of the number of people who work here, big customer base, big profits, and that's how we like to keep it... We just want to make more money than we spend, have good healthy margins which allow us to experiment, and play, and not be afraid to do things that may not work, and just enjoy ourselves.

**中文翻译:**
我们不谈论那些不太重要的事情，比如营收（Revenue）其实没那么重要，因为你可能在产生巨额营收的同时走向破产。但我们谈论利润。从历史上看，我们在过去的 24 年里每年都在盈利。在过去的 10 年左右，我们每年的利润都达到了数千万美元，这非常棒。我们拥有约 10 万以上的付费客户……目前大约有 75 名员工。所以，就员工人数而言，这是一家相对较小的公司，但拥有庞大的客户群和丰厚的利润，这就是我们喜欢的状态……我们只想赚的比花的多，保持健康的利润率，这让我们能够去实验、去玩，不害怕尝试可能失败的事情，并享受其中。

---

### [00:08:06] Jason Fried

**English:**
What's interesting is that Silicon Valley has found a way to make the most profitable style of business the least profitable. Software, there's no physical costs. The margin should be close to 80 or 90%. It turns out that they're barely even, most of them positive in the end, or they're just sliding by basically. I don't understand how that... Well, I do. They have too many people and they spend too much money on customer acquisition, and all that. But, it blows me away. Most businesses in the world would love to have Silicon Valley style economics, make something that doesn't cost much to make and then sell it for high prices.

**中文翻译:**
有趣的是，硅谷竟然有办法把这种本应最赚钱的商业模式变得最不赚钱。软件行业没有实物成本，利润率本应接近 80% 或 90%。结果呢，大多数公司最后勉强收支平衡，或者只是在盈亏线上挣扎。我不明白怎么会……好吧，其实我明白。他们雇了太多人，在获客成本（Customer Acquisition）上花了太多钱。但这依然让我感到震惊。世界上大多数企业都梦寐以求拥有硅谷式的经济模型：制造几乎没有成本的东西，然后以高价卖出。

---

### [00:10:31] Jason Fried

**English:**
We run a very different kind of business. We are focused on efficiency, we're not focused on growth. They're focused on growth. So typically, when you have a lot of people, you think you can do more things at once, and you probably can. You do more things at once, and have different offerings to different people, and different tiers, and salespeople, and all the things that build up an organization. We don't have any salespeople. We don't have 15 different versions of Basecamp. We're not after enterprise, so we don't have the enormous support costs and enormous support infrastructure required to service customers like that, and customize this and customize that to keep a whale happy who's paying you $300,000 a year.

**中文翻译:**
我们经营的是一种完全不同的业务。我们专注于效率，而不是增长。而那些公司专注于增长。通常情况下，当你人多的时候，你会觉得可以同时做更多的事情，事实也确实如此。你同时做更多事，为不同的人提供不同的产品方案，设置不同的等级，雇佣销售人员，以及所有构建庞大组织的东西。但我们没有销售人员。我们没有 15 个不同版本的 Basecamp。我们不追求企业级市场（Enterprise），所以我们没有巨大的支持成本和基础设施去服务那样的客户，也不需要为了让一个每年付你 30 万美元的“大客户”（Whale）开心而到处搞定制化。

---

### [00:12:49] Jason Fried

**English:**
So we think that constraints, simplicity, small teams actually are where it's at, and keep us honest, and allow us to do great work for our customer base that we know, small businesses, very tight companies like ours, and satisfy them versus trying to go after the big companies... Honestly, if you gave me 1,000 people, I wouldn't know what to do with them. We would fall apart. If you gave me 500 people, I wouldn't know what to do with them. We would fall apart. We would be a worse off company with 500 people. I'd be completely lost.

**中文翻译:**
所以我们认为，约束、简洁、小团队才是核心所在。这让我们保持诚实，让我们能为我们熟悉的客户群（即像我们这样的小型企业、精干的公司）提供出色的服务并满足他们，而不是去追逐大公司。老实说，如果你给我 1000 个人，我不知道该拿他们怎么办，公司会分崩离析。如果你给我 500 个人，我还是不知道该怎么办，公司依然会垮掉。如果有了 500 个人，我们的公司会变得更糟，而我会彻底迷失方向。

---

### [00:15:37] Jason Fried

**English:**
Now, on the business side of things, we have to be profitable. That doesn't mean that everything we do needs to be profitable... I don't even think you can actually draw lines back to everything and go, "That was worth it. That wasn't worth it." What is the value of saying thank you to somebody? Would you want to A/B test that and, if it turned out that it was worse to say thank you to somebody, would you not do that? No, you would do it because it's still the right thing to do. So a lot of our things are, what feels right? What seems like the decent thing to do? What things do we enjoy making? As long as we can, at the end of the year, look back and go, "Well, collectively, more worked then didn't work," then we're okay.

**中文翻译:**
在业务方面，我们必须盈利。但这并不意味着我们做的每一件事都必须盈利……我甚至认为你无法为每一件事都划清界限说：“这件事值得，那件事不值得。”对某人说声“谢谢”的价值是什么？你会想对此做 A/B 测试吗？如果测试结果显示说“谢谢”效果更差，你就不说了吗？不，你还是会说，因为这才是正确的事。所以我们的很多决策取决于：什么感觉是对的？什么看起来是体面的做法？我们喜欢做什么？只要在年底回顾时，我们能说：“总的来说，成功的多于失败的”，那我们就没问题。