# Jason Shah - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Jason Shah.

---

### [00:00:00] Jason Shah

**English:**
Pushback is, I couldn't imagine a word more viscerally that makes you feel like you're sort of physically going against what somebody else wants, and it gears people into a mindset of then, well, how should I push back. It starts from a place of I need to disagree, I need to say no. It's a very negative mindset, purely based on the word that has come to label a behavior that alternatively could be about how do I shift the direction on something, or how do I help the business actually succeed when I disagree with somebody about something, and that's a very different mindset. And so, the two things that I've seen be most successful would be, I think number one is actually understanding what a goal is or what somebody's kind of issue is with something, and then actually aligning those things in some way.

**中文翻译:**
“Pushback”（顶撞/反对）这个词，我无法想象还有哪个词能让人更真切地感受到你是在生理上违背他人的意愿。它会让人们陷入一种“我该如何反击”的思维定式。它始于一种“我必须不同意，我必须说不”的立场。这是一种非常负面的心态，纯粹是因为这个词被用来贴标签，而这种行为本可以被视为“我该如何调整某件事的方向”，或者“当我与某人意见不合时，我该如何帮助业务取得成功”。这是一种完全不同的心态。因此，我所见过的最成功的两种做法是：第一，真正理解目标是什么，或者某人对某事的顾虑到底在哪里，然后以某种方式将这些东西统一起来。

---

### [00:00:53] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny, and my goal here is to help you get better at the craft of building and growing products. I interview world-class product leaders and growth experts to learn from their hard-won experiences building and scaling today's most successful companies. Today my guest is Jason Shah. I was lucky to work with Jason while I was at Airbnb, and when I started working on this podcast, I knew that I wanted to have Jason on. He was actually my very first guest on this podcast when I was pre-recording some episodes, but as you'll hear in our chat, we decided to take another crack at it for reasons you'll soon understand.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的技能。我采访世界级的产品领导者和增长专家，从他们构建和扩展当今最成功公司的宝贵经验中学习。今天的嘉宾是 Jason Shah。我很幸运在 Airbnb 工作期间曾与 Jason 共事。当我开始筹备这个播客时，我就知道一定要邀请 Jason。实际上，他是我在预录制阶段的第一位嘉宾，但正如你在我们的对话中听到的那样，出于一些你很快就会明白的原因，我们决定重新录制一版。

---

### [00:01:28] Lenny

**English:**
In this episode, we cover what it's like to be a PM in Web3 and how that's changed as crypto winter has returned, how to lead a team through ups and downs, which leaders in Web3 know all too well, including how to keep morale up and people focused when so much is changing around you. We also get into a ton of killer advice on leadership, hiring, pushing back on your CEO, working backwards, career advancement, and a lot more juicy stuff. Jason is a gem and I am really excited to share this episode with you. With that, I bring you Jason Shah.

**中文翻译:**
在本期节目中，我们将探讨在 Web3 领域担任产品经理（PM）的感受，以及随着“加密货币寒冬”的回归，这一角色发生了怎样的变化；如何带领团队度过起伏（Web3 的领导者对此深有体会），包括在周围环境剧变时如何保持士气和专注。我们还会深入探讨关于领导力、招聘、如何向 CEO 提出不同意见、逆向工作法（Working Backwards）、职业晋升等大量干货建议。Jason 是一位不可多得的人才，我非常激动能与大家分享这一集。下面，让我们欢迎 Jason Shah。

---

### [00:02:05] Lenny

**English:**
This episode is brought to you by Coda. Coda's an all-in-one doc that combines the best documents, spreadsheets, and apps in one place. I actually use Coda every single day. It's my home base for organizing my newsletter writing. It's where I plan my content calendar, capture my research, and write the first drafts of each and every post. It's also where I curate my private knowledge repository for paid newsletter subscribers, and it's also how I manage the workflow for this very podcast. Over the years, I've seen Coda evolve from being a tool that makes teams more productive. It's one that also helps bring the best practices across the tech industry to life, with an incredibly rich collection of templates and guides in Coda Doc Gallery, including resources for many guests on this podcast, including Shreyas, Gokul, and Shishir, the CEO of Coda. Some of the best teams out there like Pinterest, Spotify, Square, and Uber use Coda to run effectively and have published their templates for anyone to use.

**中文翻译:**
本期节目由 Coda 赞助。Coda 是一款多合一文档工具，它将文档、表格和应用的优点集于一身。实际上，我每天都在使用 Coda。它是我撰写时事通讯的大本营，我在这里规划内容日历、记录研究资料，并撰写每一篇文章的初稿。它也是我为付费订阅者整理私人知识库的地方，我甚至用它来管理这个播客的工作流。多年来，我见证了 Coda 从一个提高团队生产力的工具，进化为一个将科技行业最佳实践变为现实的平台。Coda 文档库中有极其丰富的模板和指南，包括本播客许多嘉宾（如 Shreyas、Gokul 和 Coda CEO Shishir）提供的资源。像 Pinterest、Spotify、Square 和 Uber 这样的一流团队都在使用 Coda 高效运行，并发布了供任何人使用的模板。

---

### [00:03:03] Lenny

**English:**
If you're ping-ponging between lots of documents and spreadsheets, make your life better and start using Coda. You can take advantage of a special limited time offer just for startups. Head over to coda.io/lenny to sign up and get $1,000 credit on your first statement. That's C-O-D-A.io/lenny to sign up and get $1,000 in credit on your account. I'm excited to chat with my friend John Cutler from podcast sponsor, Amplitude. Hey, John.

**中文翻译:**
如果你总是在大量的文档和表格之间来回切换，那就让生活变得简单点，开始使用 Coda 吧。初创公司可以享受限时特别优惠。访问 coda.io/lenny 注册，即可在首张账单中获得 1000 美元的抵扣额度。地址是 C-O-D-A.io/lenny。现在，我很兴奋能与来自播客赞助商 Amplitude 的朋友 John Cutler 聊聊。嘿，John。

---

### [00:03:36] John Cutler

**English:**
Hey, Lenny. Excited to be here.

**中文翻译:**
嘿，Lenny。很高兴来到这里。

---

### [00:03:37] Lenny

**English:**
John, give us a behind the scenes at Amplitude. When most people think of Amplitude, they think of product analytics, but now you're getting into experimentation and even just launched a CDP. What's the thought process there?

**中文翻译:**
John，给我们介绍一下 Amplitude 的幕后故事吧。大多数人想到 Amplitude 时，首先想到的是产品分析，但现在你们开始涉足实验平台，甚至刚刚推出了 CDP（客户数据平台）。这背后的思考过程是怎样的？

---

### [00:03:49] John Cutler

**English:**
Well, we've always thought of Amplitude as being about supporting the full product loop. Think collect data, inform bets, ship experiments and learn. That's the heart of growth to us. So, the big aha was seeing how many customers were using Amplitude to analyze experiments, use segments for outreach, and send data to other destinations. Experiment in CDP came out of listening to and observing our customers.

**中文翻译:**
嗯，我们一直认为 Amplitude 的核心是支持完整的产品闭环。即：收集数据、辅助决策、发布实验并学习。对我们来说，这就是增长的核心。所以，最大的启发是看到有多少客户在使用 Amplitude 来分析实验、利用分群进行触达，并将数据发送到其他目的地。实验平台和 CDP 的诞生，正是源于对客户的倾听和观察。

---

### [00:04:09] Lenny

**English:**
And supporting growth and learning has always been Amplitude's core focus, right?

**中文翻译:**
支持增长和学习一直是 Amplitude 的核心关注点，对吧？

---

### [00:04:14] John Cutler

**English:**
Yeah. So, Amplitude tries to meet customers where they are. We just launched starter templates and have a great scholarship program for startups. There's never been a more important time for growth.

**中文翻译:**
是的。Amplitude 努力在客户所在的任何阶段满足他们的需求。我们刚刚推出了入门模板，并为初创公司提供了很棒的奖学金计划。现在是追求增长最重要的时刻。

---

### [00:04:22] Lenny

**English:**
Absolutely agree. Thanks for joining us, John, and head to amplitude.com to get started. Jason, welcome to the podcast.

**中文翻译:**
完全同意。感谢你的加入，John。大家可以访问 amplitude.com 开始使用。Jason，欢迎来到播客。

---

### [00:04:34] Jason Shah

**English:**
Thanks so much, Lenny. Really excited to chat with you today.

**中文翻译:**
非常感谢，Lenny。今天能和你聊天我非常兴奋。

---

### [00:04:36] Lenny

**English:**
Something listeners don't know that we know is that we actually recorded an episode between you and I back in April. It was actually my very first episode that I ever did for this podcast, and it was before I launched. It was kind of like a pre-launch launch episode, and interestingly enough, by the time the podcast launched and it was going to go out, well, let me also add that we chatted mostly about Web3, forgot that detail. So, most of our chat was about Web3 in the state of Web3 and PMing in Web3, and by the time the podcast's supposed to come out, Web3, things have changed in the world of Web3, and so, it kind of felt a little stale and out of touch, and so, we decided let's do it again. And so, how do you feel about that?

**中文翻译:**
听众们可能不知道，但我们知道，其实我们在四月份就录过一集。那实际上是我为这个播客录制的第一集，当时还没正式发布。那有点像是一个预发布版本。有趣的是，等到播客正式上线准备播出时——哦，我得补充一下，当时我们主要聊的是 Web3，忘了提这个细节了。所以，我们大部分对话都是关于 Web3 的现状和 Web3 的 PM 工作。但等到播客要播出时，Web3 的世界已经发生了翻天覆地的变化，所以那一集感觉有点过时且脱节了。于是我们决定重录。你对此感觉如何？

---

### [00:05:15] Jason Shah

**English:**
I appreciate that, Lenny. I'm honored that you would have me back. I'm going to count it as the personal record of two times on Lenny's Podcast, even if the world only knows it as one.

**中文翻译:**
我很感激，Lenny。我很荣幸你能再次邀请我。我会把它记作我个人在“Lenny 的播客”上出镜两次的纪录，哪怕全世界只知道这一次。

---

### [00:05:26] Lenny

**English:**
Wow. Good one. Okay, first ever guest and first two-time return guest. Amazing. Okay. To set a little context for folks on your background, your career, could you just give us a 60-second overview of your background and your career and how you got to what you're doing today?

**中文翻译:**
哇，说得好。好的，首位嘉宾，也是首位“两次”回归的嘉宾。太棒了。为了让大家了解你的背景和职业生涯，你能用 60 秒概括一下你的经历，以及你是如何走到今天这一步的吗？

---

### [00:05:45] Jason Shah

**English:**
Yeah, for sure. Thanks again for having me, Lenny. So, my career has all been about solving important problems in a unique way. I think the latter part is the youngest child in me who has to be special and do things different than other people, and the former is about making sure that my time is spent well since we're all limited there. So, I actually got started in a sense in tech when I was 15. I started my first company, much like a lot of teenagers, it was around test prep and getting people ready for college, and it was my first exposure to using technology at scale to help people, and I just found it addictive ever since.

**中文翻译:**
没问题。再次感谢邀请，Lenny。我的职业生涯一直致力于以独特的方式解决重要问题。我觉得“独特”这一点源于我作为家里最小的孩子，总想显得特别，做点与众不同的事；而“重要”则是为了确保我的时间花得值，毕竟人生苦短。我 15 岁时就开始接触科技行业了。像很多青少年一样，我创办了第一家公司，是关于考试培训和大学预备的。那是我第一次接触到利用技术大规模地帮助他人，从那以后我就对此着迷了。

---

### [00:06:20] Jason Shah

**English:**
And so, I ran that company for seven years through school, was lucky to do a small acquisition to a partner of ours that we had worked with throughout, and then I would just hooked, and I moved to San Francisco without a job. I was really arrogant. I said, "I'll never work for anybody else," and then lo and behold, Yammer comes along, I'm super excited about it, I had been working on a product actually in the same space. And so, that was actually my first formal product management role, and I stayed at Yammer, I stayed through the Microsoft acquisition back in 2012. Low and behold, I was at the world's largest productivity company at Microsoft, and most people there in my opinion were wildly unproductive and I wasn't shipping a lot. I got the itch again, so started another company called do.com and ran that for about four years, and then eventually, we found a better fit with Amazon. They were growing their AWS offering, SAS products. So, we partnered with them to kind of do a small acqui-hire and help build the team out and the product there for a little over a year.

**中文翻译:**
那家公司我经营了七年，贯穿了我的学生时代，后来很幸运地被我们一直合作的一个伙伴小规模收购了。之后我就彻底上瘾了，没找工作就搬到了旧金山。当时我非常傲慢，心想“我绝不给别人打工”。结果没过多久，Yammer 出现了，我非常兴奋，因为我当时正好在做一个同领域的产品。于是，那成了我第一个正式的产品经理职位。我留在 Yammer 经历了 2012 年微软的收购。结果呢，我身处全球最大的生产力公司微软，但在我看来，那里的大多数人生产力极低，我也没发布多少东西。于是我又心痒了，创办了另一家叫 do.com 的公司，经营了大约四年。最后，我们发现亚马逊更合适，当时他们正在扩大 AWS 的 SaaS 产品线。所以我们与他们合作，进行了一次小规模的人才收购（acqui-hire），我在那里帮忙组建团队和开发产品，待了一年多。

---

### [00:07:18] Jason Shah

**English:**
And then again, to be honest, I got bored and excited about what Airbnb was doing and the mission around belonging. That's why I was lucky to meet you and so many other really wonderful product leaders and just human beings in general at their core, and then to keep things brief for now, I got to work on a lot of really exciting products and businesses there, but eventually got the itch for Web3 after being a kind of observer from afar, investor, and I wanted to be a builder in Web3 specifically, and to me, it's a new vision of a better version of the internet. I'm really excited about that. So, I've been with Alchemy which is a blockchain infrastructure company for the last year, and really excited about all the opportunities. I've gotten to work on products that have been part of most people's everyday lives, and I'm hopeful that we'll get to do that with Web3 and Alchemy as well.

**中文翻译:**
说实话，后来我又觉得无聊了，并对 Airbnb 正在做的事情以及“归属感”的使命感到兴奋。这就是为什么我有幸遇到了你，以及那么多优秀的产品领导者和纯粹的人。简而言之，我在那里参与了许多令人兴奋的产品和业务。但作为一名长期的观察者和投资者，我最终还是对 Web3 产生了浓厚兴趣。我想成为 Web3 的建设者，对我来说，它是互联网更好版本的新愿景。我对此非常兴奋。所以，过去一年我一直在 Alchemy 工作，这是一家区块链基础设施公司，我对所有的机会都感到兴奋。我曾参与过影响大多数人日常生活的产品的开发，我希望在 Web3 和 Alchemy 也能实现这一点。

---

### [00:08:05] Lenny

**English:**
Amazing. I just realized as you're chatting there, do.com, I'm pretty sure I used that back in the day. I think I just realized that.

**中文翻译:**
太棒了。你刚才聊天时我才意识到，do.com，我敢肯定我当年用过。我刚刚才想起来。

---

### [00:08:12] Jason Shah

**English:**
I hope so. That would be a new, I'll add that to my second podcast achievement is if I got Lenny to use a product that I worked on, especially a startup.

**中文翻译:**
希望如此。那将是一个新成就，我会把它加到我的“第二次播客成就”里：让 Lenny 使用过我参与的产品，尤其还是个初创公司的产品。

---

### [00:08:20] Lenny

**English:**
Wow. Cool. Okay, so we're going to go a little bit backwards through your career and start with Web3. We're not going to spend most of the time on Web3, but just thought it'd be good to chat about some of these things, partly because you guest authored the sixth most popular post, online newsletter of all time, currently at number six, and it was about how to be a PM in Web3. Basically it's called The Product Manager's Guide to Web3. And so, a few questions there I wanted to touch on. One is just like, how would you describe the current state of Web3? We're recording this at the end of July, and so, we'll see when this comes out. But I'm just curious from someone working within it, kind of going through the boom and the busts, not the bust, the winter that we're kind of in a little bit right now. Yeah, how do you feel about it right now?

**中文翻译:**
哇，酷。好的，我们要倒叙一下你的职业生涯，先从 Web3 开始。我们不会把大部分时间花在 Web3 上，但我觉得聊聊这些挺好的，部分原因是你客座撰写了我时事通讯历史上排名第六的热门文章，目前排在第六位，主题是关于如何成为 Web3 的 PM。文章标题叫《产品经理 Web3 指南》。所以我想问几个问题。首先，你会如何描述 Web3 的现状？我们录制的时间是七月底，不知道播出时是什么情况。但我很好奇，作为一个身处其中的人，经历了繁荣和萧条——不是萧条，是目前这种“寒冬”——你现在感觉如何？

---

### [00:09:01] Jason Shah

**English:**
Yeah, for sure. So, as much as I'm a techno optimist, I'm also realist, and with that being said, I genuinely believe Web3 is in the strongest position that it's ever been in. I think it's important to remember that the term Web3 has barely existed in kind of popular lexicon for barely a year. We've definitely had crypto for more than a decade now as technology, arguably as a financial instrument of some sort, but specifically the number of companies that I'm seeing be formed, the number of products that are starting to actually achieve some form of early product market fit, some products that are starting to scale. There's definitely been obviously a huge drop in price. There's definitely been some huge scandals in terms of financial mismanagement and the contagion from that.

**中文翻译:**
是的。虽然我是一个技术乐观主义者，但我也是个现实主义者。即便如此，我真诚地相信 Web3 正处于有史以来最强大的地位。重要的是要记住，“Web3”这个词进入大众词典还不到一年。作为技术，加密货币确实已经存在了十多年，甚至可以被视为某种金融工具。但具体到我看到的初创公司数量、开始实现早期产品市场契合度（PMF）的产品数量，以及一些开始规模化的产品。当然，价格确实大幅下跌了，也确实出现了一些严重的财务管理不善丑闻及其引发的连锁反应。

---

### [00:09:46] Jason Shah

**English:**
But I think it's been my experience that a lot of new technologies don't move up in a straight line, and Web3 is especially challenging here because so many things have been financialized from the outset, whereas generally speaking, you'll see startups or new technologies mature over many years, whether it's the internet itself, artificial intelligence, QR codes, all sorts of things that kind of have gone through different periods of adoption, and so, I think we're seeing things kind of record Ethereum transactions happening, new Layer 2 technologies launching all the time that are going to help scale Layer 1 Blockchains, Solana has announced its phone that's going to be the first sort of Web3 native phone out there. So, there's so many new exciting product developments and users entering the space that as much as prices have come down, I'm really optimistic about the state of Web3.

**中文翻译:**
但我认为，根据我的经验，很多新技术的发展都不是直线向上的。Web3 在这方面尤其具有挑战性，因为很多东西从一开始就被金融化了。而通常情况下，你会看到初创公司或新技术在多年中逐渐成熟，无论是互联网本身、人工智能、二维码，还是各种经历过不同采用阶段的事物。所以，我认为我们正看到以太坊交易量创下纪录，新的 Layer 2 技术不断推出以帮助扩展 Layer 1 区块链，Solana 也宣布了其手机，这将是第一款 Web3 原生手机。因此，尽管价格下跌，但有这么多令人兴奋的新产品开发和用户进入这个领域，我对 Web3 的现状非常乐观。

---

### [00:10:32] Lenny

**English:**
I think about a little bit is going through this shift in excitement about Web3 as a PM within a company working in this space, I imagine it tests some of the core skills of a PM, like keeping people focused, prioritizing effectively, keeping morale up. If people are getting like, "Oh man, all my cryptos going down," I'm curious how you've been able to leverage those skills and what you've learned going through this experience, keeping people focused, morale up, prioritizing effectively, those sorts of things.

**中文翻译:**
我思考的是，作为一家 Web3 公司的 PM，经历这种热度的转变，我想这一定考验了 PM 的一些核心技能，比如让团队保持专注、有效的优先级排序、维持士气。如果大家都在想：“天哪，我的加密货币全在跌”，我很好奇你是如何运用这些技能的，以及你在这次经历中学到了什么——关于如何让大家保持专注、提振士气、有效排序等等。

---

### [00:11:00] Jason Shah

**English:**
Yeah, it's a great question. It's really important, right, because we've seen in this space that there are these cycles, and I think that morale and ability to keep building are the determinants of long-term success, and if everybody kind of takes the ball and goes home, that uncertain future won't necessarily materialize. So, in my opinion, I think that the only way to maintain moral is to make progress. I think that no speech, no sort of extrinsic motivators like we're going to give everybody some free crypto to keep motivated about it or something like that really works. I think people get really excited when they see progress.

**中文翻译:**
是的，这是一个非常棒的问题。这非常重要，因为我们在这个领域看到了这些周期。我认为士气和持续建设的能力是长期成功的决定因素。如果每个人都“收球回家”不玩了，那么那个不确定的未来就不一定会实现。所以，在我看来，维持士气的唯一方法就是取得进展。我认为任何演讲，或者任何外部激励（比如“我们要给每个人发点免费代币来保持动力”）都不是真正有效的。我认为当人们看到进展时，才会真正感到兴奋。

---

### [00:11:37] Jason Shah

**English:**
So, for example, at Alchemy, we see more developers than we've ever had on the platform today, and then we're shipping, we just launched Solana support and people are like, "This is real." We're actually doing things, building things. We just had our team out at EthCC which is a big conference in Paris for the Ethereum community, and it was wild the number of people that were there, products being built. Pretty much every crypto conference has a hackathon, and so, it keeps the spirit of building so alive.

**中文翻译:**
例如，在 Alchemy，我们平台上的开发者数量比以往任何时候都多。而且我们一直在发布产品，我们刚刚推出了对 Solana 的支持，大家会觉得：“这是玩真的。”我们确实在做事，在建设。我们的团队刚参加了 EthCC（巴黎的以太坊社区大会），现场的人数和正在开发的产品数量令人惊叹。几乎每个加密货币会议都有黑客松，这让建设精神保持得非常活跃。

---

### [00:12:03] Jason Shah

**English:**
And so, I think it at Alchemy and just in other situations that I've been in as a leader over time, I think it's all about a focus on progress and moving forward. We saw this at Airbnb when the business had a draw down in revenue, and I know you'd covered this with Sanchan recently, right? It was 85, 90% revenue and you didn't know when it was going to turn around, right? It's not just like, "Oh yeah, this will come back in six months and we can just keep plowing forward." But I think what worked was making progress and actually focusing on product and your customers, and ultimately if you hire the right people who are motivated for the right reasons, I think that recipe keeps people highly motivated and highly effective at building for when things do eventually turn around.

**中文翻译:**
所以，无论是在 Alchemy 还是在我过去担任领导者的其他情况下，我认为核心都在于关注进展和向前推进。我们在 Airbnb 业务收入大幅下滑时也看到了这一点，我知道你最近和 Sanchan 聊过这个，对吧？当时收入掉了 85% 到 90%，你不知道什么时候会好转。这不像“哦，六个月后就会回来，我们继续埋头干就行”。但我认为有效的方法是取得进展，并真正专注于产品和客户。最终，如果你雇佣了正确的人，他们因为正确的理由而被激励，我认为这个秘诀能让人们保持高度的动力和效率，为最终的好转做好准备。

---

### [00:12:44] Lenny

**English:**
One of the most interesting and maybe surprising points you made in the post that you wrote about being a PM in Web3 is that there's much less need for a PM, especially early stage Web3, and it feels like, the stuff you're talking about feels like a PM's really helpful along these lines. So, I'm curious, are things changing at all there? Have you changed your perspective on PMs and Web3, and then I don't know, where do you see the evolution of product management and Web3?

**中文翻译:**
你在那篇关于 Web3 PM 的文章中提到的最有趣、也最令人惊讶的一点是，Web3 早期对 PM 的需求要少得多。但感觉你现在说的这些事情，PM 在其中其实非常有帮助。所以我很好奇，情况有变化吗？你对 Web3 中 PM 的看法改变了吗？你如何看待 Web3 中产品管理的演变？

---

### [00:13:09] Jason Shah

**English:**
I actually am seeing things change a lot, and one thing in Web3, if one learns nothing is the ability to admit when they're wrong or when things change. And so, I think that that's exactly what I'm seeing. So, basically, I'm specifically noticing a lot of teams hiring product leaders, more product managers. Those product managers are actually now working kind of increasingly in sort of more traditional product management fashion, in addition to some of the differences that we discussed in the post around the community management and role in marketing and things like this, but specifically, Uniswap just made a big hire out of Meta. I saw that Gemini also did the same. We're seeing OpenSea hire a lot of talent along these lines too, even through the ups and downs that their business has seen, and at all levels. Whether it's kind of product manager, senior product manager, director, VP or CPO, you're seeing it across the board.

**中文翻译:**
我确实看到了很大的变化。在 Web3，如果说有什么是必须学会的，那就是承认自己错了或者承认情况发生了变化。这正是我所看到的。基本上，我注意到很多团队正在招聘产品领导者和更多的产品经理。除了我们在文章中讨论过的社区管理和营销角色等差异外，这些 PM 现在的工作方式越来越趋向于传统的产品管理模式。具体来说，Uniswap 刚从 Meta 挖走了一位高管。我看到 Gemini 也在做同样的事。OpenSea 也在招聘大量此类人才，尽管他们的业务经历了起伏。而且是全方位的，无论是产品经理、高级产品经理、总监、副总裁还是首席产品官（CPO），到处都能看到这种趋势。

---

### [00:14:03] Jason Shah

**English:**
And so, I think that's partially happening because you're seeing a maturation of products, right, and so, maybe you can start early with a few engineers, a community manager, get the ball rolling, but eventually the product is more mature, the complexity has grown, the role of the product manager is far more useful than they can differentiate. I also think the market is getting increasingly competitive. So, there's many NFT marketplaces. There's many Layer 1 and Layer 2 blockchains. As a result, I think product is always a competitive advantage, right? If it's working, it improves strategy, it improves execution, and improves team collaboration. And so, maybe that was less of a difference maker before where these teams didn't need that competitive advantage as much because maybe they launched a token and the token was mooning, and so a bunch of people were adopting the product, but that only lasts so long, and first principles still come come in to focus, whether it's one day or one month from now.

**中文翻译:**
我认为部分原因是产品正在趋于成熟。也许早期你可以只靠几个工程师和一个社区经理就开始运作，但最终产品会变得更成熟，复杂度会增加，产品经理的角色就会变得更有用，能体现出差异化。我也认为市场竞争正变得越来越激烈。现在有很多 NFT 市场，很多 Layer 1 和 Layer 2 区块链。因此，我认为产品始终是一种竞争优势。如果产品做得好，它能改进战略、提高执行力并改善团队协作。以前这可能没那么重要，因为这些团队不需要那么多竞争优势——也许他们发了个代币，代币价格暴涨，于是很多人就开始用这个产品。但这种情况不会持久，第一性原理迟早会重新成为焦点，无论是明天还是下个月。

---

### [00:15:00] Jason Shah

**English:**
So, I'm definitely seeing it shift. It's definitely making a huge, positive difference in the cases that I've observed, and my hunch is we're only going to continue to observe this because with more user adoption comes new challenges, and for all these players that are growing and getting some form of adoption, the product complexity is only going to grow, and having somebody to help lead teams, help prioritize between all the different products that they could build or strategies they could pursue is going to only increase in importance.

**中文翻译:**
所以我确实看到了这种转变。在我观察到的案例中，这确实带来了巨大的积极影响。我的直觉是，我们将继续观察到这种趋势，因为随着用户采用率的提高，新的挑战也会随之而来。对于所有这些正在增长并获得一定采用率的玩家来说，产品的复杂性只会增加。因此，拥有一个能帮助领导团队、在各种可能开发的产品或战略之间进行优先级排序的人，其重要性只会日益凸显。

---

### [00:15:27] Lenny

**English:**
I know we're like we're PM people talking about the value of PM, but something I find is that people that are kind of anti having a PM or don't see why they need a PM in my experience just haven't worked with a great product manager because my experience, you find a great PM, they just make everything better, and so, it's not surprising to hear what you're sharing which is people are kind of discovering that value of bringing on a product manager, even if it's mostly engineering work. And so, that's promising, and I wonder if that's just a natural evolution of a new space where people are like, "Eh, I don't need PMs in this one," and then like, "Oh, okay, well, I see. All these things aren't happening. We need someone to help. Who can do that for us? Maybe it's a PM."

**中文翻译:**
我知道我们是 PM，在聊 PM 的价值，但我发现，那些反对设立 PM 或不明白为什么需要 PM 的人，根据我的经验，通常只是因为他们没和优秀的产品经理合作过。因为在我的经验中，只要你找到一个优秀的 PM，他们就能让一切变得更好。所以，听到你分享大家开始发现引入产品经理的价值，我并不感到惊讶，即使工作内容主要是工程方面的。这很有希望，我在想这是否只是一个新领域的自然演变：一开始人们觉得“呃，这个领域不需要 PM”，然后发现“哦，好吧，我明白了，这些事情都没进展。我们需要人帮忙。谁能帮我们？也许是个 PM。”

---

### [00:16:06] Jason Shah

**English:**
Yeah, that's a great observation. I think that combination of having a direct need for something that emerges as well as if somebody's had either a bad experience or not even had any experience with somebody who can play this role which is quite common in Web3, especially because a lot of folks are relatively early in their career, given the kind of accessibility of the space, and I think frankly the more adept understanding of the space naturally that a lot of people have when they're early in their career and less set in their ways. And so, that's a great point, and as a result, the better PMs we see in Web3, hopefully the value will prove itself out over time.

**中文翻译:**
是的，这是一个很好的观察。我认为这是由于出现了直接需求，加上有些人可能经历过糟糕的 PM，或者根本没接触过能胜任这个角色的人。这在 Web3 很常见，尤其是因为考虑到这个领域的准入门槛，很多人职业生涯还处于早期。坦率地说，很多处于职业早期的人对这个领域有更敏锐的直觉，而且思维定式较少。所以这是一个很好的观点，结果就是，我们在 Web3 看到的优秀 PM 越多，其价值就越能在时间推移中得到证明。

---

### [00:16:41] Lenny

**English:**
And hopefully they do well so people don't keep getting burned out by bad PMs.

**中文翻译:**
希望他们表现出色，这样大家就不会继续被糟糕的 PM 搞得精疲力竭了。

---

### [00:16:45] Jason Shah

**English:**
We're rooting for all PMs, but definitely Web3 PMs too.

**中文翻译:**
我们支持所有的 PM，当然也包括 Web3 的 PM。

---

### [00:16:49] Lenny

**English:**
Yeah. What's surprised you most about working in Web3 as a PM?

**中文翻译:**
是的。作为 Web3 的 PM，最让你感到惊讶的是什么？

---

### [00:16:53] Jason Shah

**English:**
I mean, I think that the biggest surprise to me, despite what we were just talking about, was how big some products have gotten without kind of the traditional either product manager role or without the playbooks that we're so used to from the last 20 years of the internet. And so, for example, Uniswap has done more daily volume on certain days than Coinbase, and Uniswap is about a hundred people versus 5,000-plus at Coinbase, right? So, that's astounding to me.

**中文翻译:**
我的意思是，尽管我们刚才聊了那些，但最让我惊讶的是，有些产品在没有传统 PM 角色或没有过去 20 年互联网行业惯用“打法”的情况下，竟然能做得这么大。例如，Uniswap 在某些日子的交易量甚至超过了 Coinbase，而 Uniswap 只有大约 100 人，而 Coinbase 有 5000 多人。这对我来说太震撼了。

---

### [00:17:21] Jason Shah

**English:**
I think a lot of these NFT collections and communities that have grown. I met with a lot of these at NFT.NYC recently, and a lot of them, aside from the price speculation and things like this, have actually built, the Bored Ape Yacht Club is actually building a metaverse project that does look better than some of the digital games that I've used in the past of Second Life and things like this. Obviously, a lot of time has passed and so there's a greater foundation of technology to build off of and they're working with a partner on that product as well, but there's a ton of progress being made without some of the traditional product structure or individuals. And so, again, I think PMs play a really strong role, but it's been incredibly surprising to see how far products can get without the product playbooks and resources that somebody who's worked in the internet space from the last 10 or 20 years is so used to.

**中文翻译:**
还有很多不断壮大的 NFT 系列和社区。我最近在 NFT.NYC 见到了很多这样的团队。撇开价格投机不谈，很多团队确实在做东西。比如无聊猿（Bored Ape Yacht Club）正在开发一个元宇宙项目，看起来确实比我以前玩过的一些数字游戏（如《第二人生》之类的）要好。当然，时代不同了，现在有更好的技术基础，他们也在和合作伙伴共同开发。但在没有传统产品架构或人员的情况下，竟然取得了这么多进展。所以，我再次强调，虽然 PM 角色很重要，但看到产品在没有过去 10 到 20 年互联网老兵所习惯的那些“打法”和资源的情况下能走这么远，确实令人惊讶。

---

### [00:18:11] Lenny

**English:**
Amazing. Okay. We're going to move on from Web3 and chat a bit about some of your other career accomplishments and companies you've worked at. So, you worked at, you mentioned Yammer, Microsoft, Amazon, Airbnb. I'm curious which of those companies has most informed the way you approach product and build product and run teams because they're all so different in how they operate, and I'm always curious what company is the formative experience for you that's like, "Here's how I like to build product most." I know it's always a combination, but how do you think about that?

**中文翻译:**
太神奇了。好的，我们要跳过 Web3，聊聊你职业生涯中的其他成就和工作过的公司。你提到过 Yammer、微软、亚马逊、Airbnb。我很好奇，这些公司中哪一家对你处理产品、构建产品和管理团队的方式影响最大？因为它们的运作方式各不相同。我一直很好奇，哪家公司对你来说是那种“定型”的经历，让你觉得“这就是我最喜欢的产品构建方式”。我知道这通常是综合的结果，但你是怎么想的？

---

### [00:18:39] Jason Shah

**English:**
Yeah, it's definitely a combination, but I would say if I had to pick, Amazon, even though I was only there for about a year after the acquisition. I say that because of this blend between product and business thinking that is especially present there. And so, people say Google is an engineering culture. People said Facebook is a product culture, Airbnb or Pinterest, sometimes a design culture or things like this, and I think that Amazon was a place where you couldn't divorce business and product. You couldn't be a product manager without thinking about revenue growth, without thinking about go to market, and I really like that because as a startup founder doing product in a bigger company, it gave me the chance to exercise a lot of those skills.

**中文翻译:**
是的，这确实是综合的结果。但如果非要选一个，我会选亚马逊，尽管我在被收购后只在那里待了一年左右。我这么说是因为那里有一种产品思维和商业思维的融合，这种融合非常明显。人们常说谷歌是工程师文化，脸书是产品文化，Airbnb 或 Pinterest 有时被认为是设计文化。而我认为在亚马逊，你无法将商业和产品分开。你不可能在不考虑收入增长、不考虑进入市场（GTM）策略的情况下做一个产品经理。我非常喜欢这一点，因为作为一个在大公司做产品的初创公司创始人，这给了我锻炼这些技能的机会。

---

### [00:19:24] Jason Shah

**English:**
It's very similar actually to how I feel at Alchemy now where I remember my first month there I was like, people ask me how's it going, I'm like, "I feel like an athlete. I feel alive again." I can do M&A one day, I can be doing product another minute. I could be figuring out, oh, we need to hire our first lawyer to write onboarding plans for employees the next minute, and it wasn't as siloed as sometimes a product role can be. So, I think Amazon, I went there to learn and understand. That was my biggest goal was this is an incredible company that's gone into... The Whole Foods acquisition happened when I was there, and I was wondering how does the same company kind of within retail win with the AWS, go create studios, and I think the Amazon culture ultimately more than anything else around ownership, being vocally self-critical is right a lot as one of the leadership principles. All these things combined I think created a really unique culture.

**中文翻译:**
这其实和我现在在 Alchemy 的感觉非常相似。我记得在那里的第一个月，别人问我怎么样，我说：“我觉得自己像个运动员，我感觉又活过来了。”我可能这一天在处理并购（M&A），下一分钟在做产品，再下一分钟在琢磨我们需要雇佣第一位律师来编写员工入职计划。它不像某些产品职位那样被孤立。所以，我觉得去亚马逊是为了学习和理解。我最大的目标是了解这家不可思议的公司是如何运作的……我当时正好经历了全食超市（Whole Foods）的收购，我在想，同一家公司如何在零售业获胜的同时，还能拥有 AWS 并创建影视工作室。我认为亚马逊文化中最重要的部分是主人翁意识（Ownership）、敢于自我批评（Vocally Self-critical）以及“决策正确”（Are Right, A Lot）这些领导力原则。所有这些结合在一起，创造了一种非常独特的文化。

---

### [00:20:12] Jason Shah

**English:**
So, I would say Amazon's had the biggest impact on me, and there have been certain lessons that I've taken from, like you said, all these places, but Amazon was by far the place that I think left the biggest mark on my view on product and leadership.

**中文翻译:**
所以，我会说亚马逊对我影响最大。虽然正如你所说，我从所有这些地方都学到了一些东西，但到目前为止，亚马逊是对我的产品观和领导观烙印最深的地方。

---

### [00:20:26] Lenny

**English:**
That's quite amazing that you were there for a year and that's the one that's most informed and impacted you. Do you feel like people should try to go work at Amazon as a training ground as a PM? Is that something you encourage PM to try to do?

**中文翻译:**
你在那里只待了一年，它却是对你影响最深的地方，这太神奇了。你觉得人们应该尝试去亚马逊工作，把它当作 PM 的训练场吗？你会鼓励 PM 尝试这样做吗？

---

### [00:20:37] Jason Shah

**English:**
In general, I certainly had a positive experience, but I think that as you know and as I'm sure you've advised countless people, it's so context dependent. Are you learning the zero to one? Are you learning the one to scale? What's your aspiration? Is somebody trying to start a company eventually, or are they trying to work the ranks of the product leadership trajectory? And so, I definitely enjoyed it a lot, and I think to your point, there's often a non-linear sort of correlation between factors that we traditionally think are linked, right? So, my time there was one of the shortest, but my learnings were some of the greatest because I was really intentional and maybe because of the sort of moment in time and what I wanted to get out of it.

**中文翻译:**
总的来说，我的体验确实很积极。但正如你所知，我也相信你建议过无数人，这非常取决于具体情况。你是想学习从 0 到 1？还是学习从 1 到规模化？你的抱负是什么？是最终想创办公司，还是想在产品领导层的阶梯上晋升？所以我确实非常享受那段时光。而且我认为，正如你所指出的，我们传统认为相关的因素之间往往存在非线性关系。虽然我在那里的时间最短，但我的收获却是最大的，因为我非常有目的性，也许是因为那个特定的时机以及我明确知道自己想从中得到什么。

---

### [00:21:17] Jason Shah

**English:**
The same way for what it's worth, while we're talking about this disconnect, when I went to Yammer, I also interviewed with kind of... This was the era of TaskRabbit. I talked to Square and I remember people always say, "Well, what stage do you want to join seed, Series A, Series B?" And the crazy thing is that Yammer was, it was already passed a hundred people, it grew to 500 by the time of the acquisition, and it felt almost like the culture was so tightknit, it felt like a seed stage company at some points, even though eventually it kind of felt like... Well, once it was acquired from Microsoft, we'll just say it didn't feel like a seed stage company anymore, but it felt smaller than a lot of the actual smaller companies than I was at. So, I think that's something I've noticed a lot is that a lot of the proxies don't necessarily match the internal realities in certain cases.

**中文翻译:**
同样地，既然聊到了这种“脱节”，当年我去 Yammer 时，也面试过……那是 TaskRabbit 的时代。我也和 Square 聊过。我记得人们总问：“你想加入哪个阶段的公司？种子轮、A 轮还是 B 轮？”疯狂的是，Yammer 当时已经超过 100 人了，到收购时增长到了 500 人，但感觉它的文化非常紧密，在某些时刻感觉就像一家种子期公司。虽然最终……好吧，一旦被微软收购，它就不再像种子期公司了，但它感觉比我待过的一些规模更小的公司还要“小”。所以我注意到，很多外部指标在某些情况下并不一定能反映内部的真实情况。

---

### [00:22:01] Lenny

**English:**
You mentioned you picked up a bunch of tactics and kind of lessons from some of these companies. What's one concrete process or tactic that you took it away from either Amazon or one of these other companies that stuck with you that you like to kind of share with folks?

**中文翻译:**
你提到从这些公司学到了很多策略和教训。有没有哪个具体的流程或策略是你从亚马逊或其他公司学到，并且一直沿用至今，想和大家分享的？

---

### [00:22:14] Jason Shah

**English:**
Yeah, definitely. I mean, I think one that Amazon is well-known for is the working backwards process, and for those that don't know, the idea is try to define effectively an ideal end state which funnily enough is very similar to some of what we both experienced at Airbnb and took away, and usually the mechanism for doing this is what's called a PRFAQ, and that's a press release and frequently asked questions, and it forces a certain degree of clarity to have to actually write a press release about the product that you're going to eventually launch.

**中文翻译:**
当然。亚马逊最著名的就是“逆向工作法”（Working Backwards）。对于不了解的人来说，它的核心理念是尝试定义一个理想的最终状态。有趣的是，这与我们俩在 Airbnb 的经历和收获非常相似。通常实现这一目标的机制被称为 PRFAQ，即新闻稿（Press Release）和常见问题解答（Frequently Asked Questions）。它强迫你必须为最终要发布的产品写一份新闻稿，从而达到某种程度的清晰度。

---

### [00:23:22] Jason Shah

**English:**
Every employee goes through actually like a business writing class after they start at Amazon. They give you a little card with five tips that you're supposed to keep on your desk about concision and specificity in the words you use. For example, you should never write the word great in an Amazon press release. You should write user friendly in X, Y, Z way and will save customers time 20 minutes each day through this. It's intended to be very concrete in a way that avoids some of the fluffiness that frankly... It's funny, when people try to move from slides to docs, they really just import the same mindsets that they use in slides, but just with more words now.

**中文翻译:**
每个员工入职亚马逊后都会参加商务写作课。他们会给你一张小卡片，上面有五条关于用词简洁和具体的建议，让你放在桌子上。例如，在亚马逊的新闻稿中，你永远不应该使用“great”（伟大的/极好的）这个词。你应该写“通过 X、Y、Z 方式实现用户友好，并每天为客户节省 20 分钟时间”。它的目的是非常具体，避免那些空洞的辞藻。有趣的是，当人们尝试从幻灯片（PPT）转向文档时，他们往往只是把做 PPT 的思维带到了文档里，只是字数变多了而已。

---

### [00:23:55] Jason Shah

**English:**
And so, I think the working backwards process of establishing the long-term goal using a mechanism like a press release and the FAQs where every word matters, and even the FAQs, for what it's worth, there's a section for external FAQs that you would include for example as an appendix, but also internal FAQs that are meant to de-risk launch or raise the elephant in the room or dogs not barking as Amazon likes to call it often. So, that was a really helpful process that felt very true to me as a way I like to live my life as well, and then also very applicable.

**中文翻译:**
所以，我认为通过新闻稿和 FAQ 这种机制来确立长期目标，每一个字都至关重要。顺便说一下，FAQ 部分不仅包括作为附录的外部 FAQ，还包括内部 FAQ，旨在降低发布风险，或者提出那些“房间里的大象”或亚马逊常说的“不叫的狗”（意指被忽视的潜在问题）。这是一个非常有用的流程，对我个人的生活方式也很有启发，而且非常具有可操作性。

---

### [00:24:07] Lenny

**English:**
The tidbit about not using the word great is so interesting. Is there anything else there that you could share about just basically just like how to write effectively and communicate and launch. Is there any other tidbits along those lines?

**中文翻译:**
关于不使用“great”这个词的细节太有趣了。关于如何进行有效的写作、沟通和发布，你还有什么其他的经验或小贴士可以分享吗？

---

### [00:24:07] Jason Shah

**English:**
Yeah, that's a good question. In addition to not using the word great and words like it that are either subjective in what they mean or unclear in what they actually mean, definitely using numbers more than adjectives. Strict concision, I would go over these documents countless times, and there's a phrase, I can't remember, it's either Mark Twain or another famous writer who said kill your darlings, right? Cut, cut, cut, and just remove. And so, I think I found that really useful in emails I write or documents I write to this day is just going over, not because you're saving ink by cutting words, but because it forces clarity of thought. Fewer words means every word is 10 pounds in weight instead of one, and that means that the decisions you're making, the trade offs are far more intentional, and in the case of great, if you say something is great because we're going to deliver something in two hours versus Amazon's great because the selection is very wide, the implications on strategy are completely different. And so, that's one of the benefits of being very specific and very concrete in language.

**中文翻译:**
好问题。除了不用“great”以及类似的含义主观或模糊的词之外，一定要多用数字，少用形容词。严格保持简洁。我会无数次地修改这些文档。有一句话，我不记得是马克·吐温还是哪位名作家说的，“杀掉你的宝贝”（Kill your darlings），对吧？删减，删减，再删减。直到今天，我发现这在我写的邮件或文档中都非常有用。不断修改不是为了省墨水，而是为了强迫思维清晰。字数越少，意味着每个字的权重就从 1 磅变成了 10 磅。这意味着你所做的决定和权衡会更加深思熟虑。以“great”为例，如果你说某事很棒是因为我们能在两小时内送达，对比亚马逊很棒是因为选品非常丰富，这两者对战略的影响是完全不同的。这就是语言具体、具体的价值所在。

---

### [00:25:12] Lenny

**English:**
I didn't intend to go too deep into this topic, but no one's ever covered this working backwards process on this podcast, so it's kind of interesting to talk about it a little bit more maybe. How does that actually work? So, you sit there and you actually write out a press release that would go out when you launch this thing. Is there like a template used? Is there anything you could share for folks that want to try this out and/or point them to a resource that will help them down this road?

**中文翻译:**
我本没打算深入讨论这个话题，但这个播客还没人聊过“逆向工作法”，所以多聊聊挺有意思的。它具体是怎么运作的？你就坐在那，写一份产品发布时要发出的新闻稿吗？有模板吗？对于想尝试的人，你有什么可以分享的，或者能推荐什么资源吗？

---

### [00:25:36] Jason Shah

**English:**
Yeah, definitely. That's a great question. So, there definitely is a template, and so, it's a combination of an internal training where you have to write one of these documents. You review kind of good, bad, medium versions of this. It's generally used if there's let's say a proposal for a new product or even a proposal to buy a company. This helps really simulate what it's going to be like.

**中文翻译:**
当然。这是一个好问题。确实有模板。这通常结合了内部培训，你必须写一份这样的文档。你会审阅好的、坏的和中等水平的版本。它通常用于新产品提案，甚至是收购公司的提案。这有助于真实模拟未来的情况。

---

### [00:25:56] Jason Shah

**English:**
With respect to a template, what I recall is it was often sort of an introduction where you get kind of right to the point. You say what you're announcing. Then usually you would describe the problem in one paragraph and in very clear language. Again, all of the writing is this way. Then the solution, you briefly describe the product. After that, there's always a customer quote, and this is an example of this customer obsession that Amazon is so famous for that many companies like to say or emulate, but I think it really kind of may not be true if you evaluate the mechanisms that they use, for example, product specs that either don't have customer data or don't have quotes from customers, things like this. And so, there's a customer quote, and you have to literally put yourself into the shoes of... Let's say you were launching Prime. Put yourself in the shoes of Lenny from San Francisco. What exactly is he going to say when he has access to this, and how's it different than his life today, and what are the words that he's going to use?

**中文翻译:**
关于模板，我记得通常是先有一个开门见山的介绍。说明你要发布什么。然后通常用一段话，用非常清晰的语言描述问题。同样，所有的写作都要遵循这个原则。接着是解决方案，简要描述产品。之后，总会有一段客户证言（Customer Quote）。这就是亚马逊著名的“客户至上”的一个例子，很多公司口头上说要模仿，但如果你评估他们的机制，比如产品规格说明书里既没有客户数据也没有客户引言，那可能就不是真的。所以，必须有一段客户引言，你必须设身处地地想……假设你在发布 Prime。把自己想象成旧金山的 Lenny。当他能使用这个产品时，他具体会说什么？这与他现在的生活有什么不同？他会用哪些词？

---

### [00:26:52] Lenny

**English:**
You can't use great.

**中文翻译:**
你不能用“great”。

---

### [00:26:53] Jason Shah

**English:**
I mean, if great is one of your favorite words, maybe you could stretch it, but I think if you were in a room with your peers at Amazon, they might put some red pen through any greats that are used there. So, I found that really helpful, and it also helps force out of this box that product managers, product leaders tend to get into of thinking that they are always the customer and being a little sort of intellectually lazy, where I'm like, "Yeah, I would like Prime, so let me write the quote for what I would like," but maybe I'm only a small segment within our total customer addressable market.

**中文翻译:**
我的意思是，如果“great”是你最喜欢的词之一，也许你可以勉强用一下，但我觉得如果你在亚马逊和同事们开会，他们可能会用红笔把你所有的“great”都划掉。所以我发现这非常有用，它能强迫产品经理和产品领导者跳出“我就是客户”的思维定式。人们有时会有点思维惰性，觉得“既然我喜欢 Prime，那我就按我的想法写一段引言”，但也许我只是整个目标市场中很小的一部分。

---

### [00:27:26] Jason Shah

**English:**
So, anyhow, there's a customer quote, then there's one leadership quote similarly that this achieves a complimentary goal, like how does this fit into our strategy in a way that you would express to the public but is still true to what the internal sensitivities and mechanisms would be. And then a call to action towards the end, and not just download here, but this will be available to customers next month. They can go access these portals within these Whole Food stores at this state. It again forces clarity of thought with respect to not only the rollout plan, but taking a step back. When you read it, do you feel like you would actually want this product? Would you use it? So, I found that really helpful as a structure.

**中文翻译:**
总之，先是客户引言，然后是一段领导层引言，同样是为了达成互补的目标，比如：这如何符合我们的战略？你会如何向公众表达，同时又忠实于内部的敏感点和机制。最后是行动号召（Call to Action），不仅仅是“点击下载”，而是“下个月将面向客户开放。他们可以在这个州的这些全食超市里访问这些入口”。这再次强迫你理清思路，不仅是发布计划，还要退后一步想：当你读到它时，你真的想要这个产品吗？你会用它吗？所以我发现这个结构非常有用。

---

### [00:28:05] Lenny

**English:**
Can you just summarize those again real quick?

**中文翻译:**
你能再快速总结一下那几个部分吗？

---

### [00:28:07] Jason Shah

**English:**
For sure. So the structure of the PRFAQ docs was generally an introduction where you're announced the product, problem, solution, customer quote, leadership quote, and a call to action.

**中文翻译:**
没问题。PRFAQ 文档的结构通常是：介绍（宣布产品）、问题、解决方案、客户引言、领导层引言，以及行动号召。

---

### [00:28:17] Lenny

**English:**
So, interesting how similar that is to a one pager potentially. The other thought I had while you're chatting, so the Airbnb approach is work back from the ideal, Brian talks about it, the 11-star experience versus the Amazon approach which it doesn't need to be the ideal, it just needs to be an awesome launch. So, that's an interesting difference, both effective in different ways.

**中文翻译:**
很有意思，这和“一页纸提案”（One Pager）非常相似。你聊天时我产生的另一个想法是：Airbnb 的方法是从理想状态倒推，Brian 谈到过“11 星体验”；而亚马逊的方法不一定要是终极理想状态，它只需要是一个非常棒的发布。这是一个有趣的差异，两者在不同方面都很有效。

---

### [00:28:37] Jason Shah

**English:**
I think people tend to, when they see that both companies have some sort of working backwards process of thought, I would say working backwards on one hand and then 11-star experience on the other. Listening to how you describe it, I want to almost frame it as working backwards from sort of a moment in time or a launch like you said with Amazon versus working backwards from a quality standard in some sense of an 11-star experience.

**中文翻译:**
我认为当人们看到这两家公司都有某种“逆向思维”过程时，我会说一边是“逆向工作法”，另一边是“11 星体验”。听了你的描述，我几乎想把它定义为：亚马逊是从某个时间点或发布时刻倒推，而 Airbnb 在某种意义上是从“11 星体验”的质量标准倒推。

---

### [00:28:59] Lenny

**English:**
Going in a slightly different direction, one of the things I wanted to chat about is you worked at all these different companies and they have different types of leadership and different approaches to leadership. And so, I'm curious, what have you learned about effective leadership watching all these awesome operators work, and what kind of separates them in your experience from folks that maybe aren't as effective?

**中文翻译:**
换个话题，我想聊聊领导力。你在这么多不同的公司工作过，它们有不同类型的领导者和领导方式。我很好奇，通过观察这些优秀的运营者工作，你学到了哪些关于有效领导力的知识？根据你的经验，是什么将他们与那些可能没那么高效的人区分开来的？

---

### [00:29:18] Jason Shah

**English:**
Yeah, it's a great question, and to briefly recap, right, I've gotten to see somebody like David Sachs who've been the CEO of PayPal and then the founder of Yammer and gone to do many more things since then. I've gotten to see sort of Jeff Bezos at a distance. I was never that close to him obviously and never got to work with him, but got to observe his impact on the organization. Obviously, I've gotten to witness Brian Chesky and his leadership in sort of the pre-IPO days as well as through the ups and downs of COVID, and then also now at Alchemy, our co-founders, Joe and Nikil are leaders that have really had an impact on me as well, and I would count myself, but I've also see myself as a bad leader in the start of [inaudible 00:29:56] and learn from that.

**中文翻译:**
是的，这是一个好问题。简要回顾一下，我见过像 David Sacks 这样的人，他曾是 PayPal 的 CEO，后来创办了 Yammer，之后又做了很多事。我也曾远距离观察过杰夫·贝佐斯，显然我没那么接近他，也没和他共事过，但我观察到了他对组织的影响。显然，我也见证了 Brian Chesky 在 IPO 前夕以及 COVID 起伏期间的领导力。现在在 Alchemy，我们的联合创始人 Joe 和 Nikil 也是对我影响很大的领导者。我也反思过自己，在创业初期我也曾是一个糟糕的领导者，并从中吸取了教训。

---

### [00:29:57] Jason Shah

**English:**
I think it's a really important thing to reflect on, and I think for me there are three things that have stood out the most. I think number one, nothing is above them. I've seen whether it's Brian caring about the full bleed image on the homepage, whether it's Jeff Bezos who famously would receive customer emails, read many of them, forward them, and he's famous for question mark emails where for his time's sake he would just forward an email to a leader with a question mark and you would just have to figure it out and then report back in 24 hours with the resolution thereof. But nothing's above them, and a lot of founders or a lot of CEOs or even CPOs and leaders think you get to a certain point and then I'm above a product spec, I'm above looking at the data running a sequel query, and I think that that is a mistake in a lot of ways, especially from a standpoint of who people come to respect as well as efficacy at one's job.

**中文翻译:**
我认为反思这一点非常重要。对我来说，有三件事最令我印象深刻。第一，没有什么事是他们“不屑于做的”。我见过 Brian 亲自关注首页的全宽配图；我也见过杰夫·贝佐斯，他以接收客户邮件著称，他会阅读并转发这些邮件，他著名的“问号邮件”就是为了节省时间，直接把邮件转发给某个主管并加个问号，你就得自己搞清楚并在 24 小时内汇报解决方案。没有什么事是他们觉得低人一等的。很多创始人、CEO 甚至 CPO 认为，到了某个级别，我就不需要看产品规格书了，不需要亲自跑 SQL 查询看数据了。我认为这在很多方面都是错误的，尤其是从赢得尊重和工作效率的角度来看。

---

### [00:30:51] Jason Shah

**English:**
And then the other two things would be, I think they're in the details. So, it's less about being above something, but this is kind of Amazon's famous for auditing the details for example, and leaders are... For example, when we were going to launch Prime, order a bunch of Prime things and see what happens and really test things out, and write up a long feedback email on Saturday or something like that, and make sure that things are moving forward.

**中文翻译:**
另外两点是：我认为他们深耕细节。这不仅仅是不摆架子，亚马逊就以“审计细节”著称。领导者会……例如，当我们准备发布 Prime 时，他们会亲自订购一堆东西，看看会发生什么，真正去测试，然后在周六写一封长长的反馈邮件，确保事情在推进。

---

### [00:31:12] Jason Shah

**English:**
So, I think in my opinion, some of the best leaders, David Sachs would do this too. He actually ran the product reviews. It was the CEO of the company doing product reviews, not some kind of middle tier of a director of product who was just running them. They were force involved and there were things to delegate and activate around, but Sachs was in all of those details and ran those product reviews himself and would talk to the product managers directly, and I think that was really impactful, and it also, I think from an accountability and culture perspective, when you're PM and you talk to the CEO and you feel like you're presenting something at product review, it's totally different, and it creates a certain amount of responsibility and quality, frankly, that I think is really important, and it's a way to coach obviously as well for those leaders to really make a mark on the organization.

**中文翻译:**
所以在我看来，一些最优秀的领导者，比如 David Sacks 也会这样做。他亲自主持产品评审。是公司的 CEO 在做产品评审，而不是某个中层的产品总监。他们深度参与，虽然也有授权和调动，但 Sacks 沉浸在所有细节中，亲自主持评审并直接与产品经理对话。我认为这非常有影响力。从问责制和文化的角度来看，当你作为 PM 直接向 CEO 汇报并在产品评审中展示东西时，感觉完全不同。坦率地说，这创造了一种责任感和对质量的要求，我认为这非常重要。这也是领导者在组织中留下印记并进行指导的一种方式。

---

### [00:31:59] Jason Shah

**English:**
And lastly, I think they adapt, right? I think that are a lot of leaders who are like, "I've worked 20 years to become a leader in this way and I have a playbook," either based on past experience or based on some sort of philosophy that they've developed over time that they feel committed to in some way, and I think coming back to some of these examples of watching Brian lead through COVID or watching Joe and Nikil now through this particular crypto winter shift gears and figure out exactly like we're still building the core business, but how else can we lean into this and adapt to the unique opportunities that are in front of us. I think that's really powerful. So, what I've seen is nothing is above them, they're in the details, and they adapt to new information and new situations. That's what I've seen the most that I've appreciated in the best leaders that I've gotten to either observe or work closely with.

**中文翻译:**
最后，我认为他们懂得变通。很多领导者会觉得：“我奋斗了 20 年才成为这样的领导者，我有一套打法”，这套打法要么基于过去的经验，要么基于他们长期形成的某种哲学。但我认为，回到之前的例子，观察 Brian 如何带领公司度过 COVID，或者观察 Joe 和 Nikil 现在如何在这个特定的加密寒冬中调整方向，弄清楚我们虽然仍在构建核心业务，但还能如何利用现状并适应眼前的独特机会。我认为这非常强大。所以，我看到的是：不摆架子、深耕细节、适应新信息和新情况。这是我在那些我有幸观察或紧密合作的最优秀领导者身上看到的最令我欣赏的特质。

---

### [00:32:46] Lenny

**English:**
Awesome. That's super interesting. The first two are kind of connected which is really interesting, and it just reminds me of Brian and how detail-oriented he was about everything. He used to review every product launch and every screen of every new product. We had to show him here's what we're launching this week, and he just kind of went through and either blew it up or let it pass. And then I just remember the founders, when they were designing the office space, just looking at pictures of listings they wanted to... Because Airbnb, the office conference rooms were modeled after Airbnb listings, and Jim just looking through hundreds of listings that the team brought him and he'd just picked the ones that he wanted to turn into conference rooms. Also, obviously Steve Jobs. This is a really interesting through line of great leaders is just this huge attention to detail, and there's probably something about once they let go that thing start to kind of diminish. Is that what you find?

**中文翻译:**
太棒了，这非常有趣。前两点其实是相关的。这让我想起 Brian，他对一切细节都非常关注。他过去会审查每一次产品发布和新产品的每一个页面。我们必须向他展示本周要发布的内容，他会一一过目，要么推翻重来，要么批准通过。我还记得创始人们在设计办公空间时，会亲自查看房源照片……因为 Airbnb 的会议室是模仿真实的 Airbnb 房源设计的。Joe 会翻阅团队带给他的数百个房源，亲自挑选他想转化成会议室的那些。显然，史蒂夫·乔布斯也是如此。这是伟大领导者身上一条非常有趣的共性：对细节的极度关注。而且可能一旦他们放手，事情就会开始走下坡路。你也是这么认为的吗？

---

### [00:33:39] Jason Shah

**English:**
Yeah, that's such a great point. You mentioned the Jobs example and there's a great book that you've probably read or in your community seen, I believe it's called Creative Selection by Ken Kocienda about the early days of the iPhone, and I think it was Project Purple or something like that, and you're absolutely right. There wasn't no slides, none of this. They brought in the prototypes for each of those reviews and things like how to do typing on a tiny screen and those early keyboards and how to do auto complete, and Jobs was totally in those details from Ken's telling in this book.

**中文翻译:**
是的，这个观点太棒了。你提到了乔布斯的例子，有一本很棒的书你可能读过或在你的社区见过，叫《创意选拔》（Creative Selection），作者是 Ken Kocienda，讲的是 iPhone 早期开发的故事，好像是“紫色项目”（Project Purple）。你完全正确。当时没有幻灯片，什么都没有。他们在每次评审中都带上原型，讨论如何在小屏幕上打字、早期的键盘设计以及如何做自动补全。根据 Ken 在书中的描述，乔布斯完全沉浸在这些细节中。

---

### [00:34:10] Jason Shah

**English:**
So, I couldn't agree with you more, and it's something that people miss because most of their exposure to leaders is on a YouTube video or at all hands, and so, they don't really get to see that side of leaders I think, and it's also not what I think from an ego perspective is kind of what people want it to be about. They want to be about making big decisions or commanding a large group of people, and I think it's hard to do that without these pieces.

**中文翻译:**
所以我完全同意你的看法。这是人们容易忽视的一点，因为大多数人接触领导者是通过 YouTube 视频或全员大会，所以他们看不到领导者的这一面。而且从自尊心的角度来看，这也不是人们希望领导者做的事。人们希望领导者做重大决策或指挥千军万马，但我认为如果没有这些细节支撑，很难做到那些大事。

---

### [00:34:34] Jason Shah

**English:**
One other thing I just wanted to briefly touch on to your point on how they're connected, it's a really good point, and at the surface it almost seems like they could potentially be the same thing. One thing worth calling out though I think is the idea of something not being above somebody or a person not being above things. I think the biggest thing I take away from that is humility is that nothing is not my job, right? Anything, could be picking up paper off the floor and putting it in the trash, or it could be reviewing a product spec, whatever it is, and then begin the details in my opinion is about craft, right, and really understanding things at a low level such that you're able to reason about it and make good decisions, like Brian with the homepage or Bezos in some cases with customer processes that he got in the weeds on. I think the two together, humility and being excellent at craft, I think is a very potent combination, especially when you throw in the last thing of being able to adapt to any situation.

**中文翻译:**
关于你提到的这两点是如何关联的，我想补充一点。表面上看它们可能是一回事，但值得指出的是，“没有什么事是某人不屑于做的”这种理念。我认为从中得到的最大启示是谦逊——即“没有任何事不是我的工作”。任何事，无论是捡起地上的纸屑扔进垃圾桶，还是审查产品规格书。而“深耕细节”在我看来关乎“匠心”（Craft），即从底层真正理解事物，从而能够进行逻辑推演并做出正确决策，就像 Brian 关注首页，或者贝佐斯深入研究客户流程。我认为谦逊与卓越的匠心结合在一起，是一个非常强大的组合，尤其是再加上最后一点：能够适应任何情况。

---

### [00:35:29] Lenny

**English:**
That's really interesting. What it also makes me think about is the reason things are less good often if there isn't a person at the top that's being very detail-oriented, and I find this with the newsletter and this podcast and other stuff is no one's going to care as much about it. No one's going to be like, "Oh my god, I really need to get this right so much because I'm just like, I'm personally feeling responsible for the quality of this stuff and it's like it's on my shoulders to make this awesome." And so, I think that's probably why a lot of the best stuff is led by a singular leader or singular opinion or singular person. A lot of the best startups are just someone's vision is like, "Here, this is what we're going to do," and then the more it becomes a community-driven thing, the less often it ends up being successful.

**中文翻译:**
这很有趣。这也让我想到，如果顶层没有一个极度关注细节的人，事情往往会做得不够好。我在做时事通讯和这个播客时也有这种感觉：没有人会像我一样在意它。没有人会觉得“天哪，我必须把它做好”，因为我个人对这些东西的质量负有责任，把事情做好的重担就在我肩上。所以我认为，这可能就是为什么很多最优秀的作品都是由单一领导者、单一观点或单个人领导的原因。很多最优秀的初创公司最初只是某个人的愿景：“看，这就是我们要做的”。而当它变得越来越由社区驱动时，成功的概率往往会降低。

---

### [00:36:16] Lenny

**English:**
This episode is brought to you by Maven. I've been an investor, an advisor, and a customer of Maven from day one. I even taught my product management course through Maven. Maven is a cohort-based learning platform where you learn alongside peers with a direct connection to your instructor. Maven's got a ton of courses for product managers, founders, and executives to help them level up in all kinds of ways. Over 10,000 people from Airbnb to Coinbase to Google to Tesla have taken courses from real experts and operators that have spent decades honing their craft. As part of their fall season which Maven just launched, there are over 100 new courses starting in the next few weeks. Many of the people I've had on this podcast are teaching courses like Jackie Bavaro on product strategy, Arielle Jackson on startup branding, Emily Kramer on B2B marketing, plus Annie Duke on decision-making, Nir Eyal on behavioral design and how to break into product management with Marily Nika. Check out all of my favorite courses and learn more at maven.com/lenny.

**中文翻译:**
本期节目由 Maven 赞助。从第一天起，我就是 Maven 的投资者、顾问和客户。我甚至通过 Maven 教授我的产品管理课程。Maven 是一个基于社群的学习平台，你可以在这里与同行一起学习，并与讲师直接交流。Maven 为产品经理、创始人和高管提供了大量课程，帮助他们在各方面提升。从 Airbnb 到 Coinbase，从谷歌到特斯拉，已有超过 1 万人参加了由拥有数十年经验的专家和运营者讲授的课程。在 Maven 刚刚开启的秋季赛季中，未来几周将有 100 多门新课程开课。本播客的许多嘉宾也在授课，比如 Jackie Bavaro 讲产品战略，Arielle Jackson 讲初创公司品牌建设，Emily Kramer 讲 B2B 营销，还有 Annie Duke 讲决策，Nir Eyal 讲行为设计，以及 Marily Nika 讲如何进入产品管理领域。访问 maven.com/lenny 查看我最喜欢的课程并了解更多信息。

---

### [00:37:19] Jason Shah

**English:**
I feel like you're totally right, especially, I mean this is the natural progression, but it doesn't have to be that way right? And I think to your point, I think a lot of leaders focus on accountability in an organization once they get large, and so, you see things like performance reviews and things like this. It's a very top-down approach to trying to drive results, but is opposed to a sense of accountability if you drove a sense of responsibility. If people felt like this is my company too, this is my product, this is my office floor. I don't want trash on the floor. I'm going to pick it up and throw it there. Even if we have somebody whose job it supposedly is to clean that up, it's like I take pride of ownership in this and I'm connected to it, and I think that makes all the difference in terms of... At Airbnb, I think people who felt that way were willing to push back on certain things, or they're willing to propose new ideas because they felt invested in the company.

**中文翻译:**
我觉得你完全正确。虽然这是自然的发展过程，但并不一定非得如此，对吧？我认为，很多领导者在组织变大后会专注于“问责制”（Accountability），所以你会看到绩效评估之类的事情。这是一种非常自上而下的驱动结果的方式。但与问责感相对的是“责任感”（Responsibility）。如果人们觉得“这也是我的公司，这是我的产品，这是我的办公室地板。我不希望地上有垃圾，我会把它捡起来扔掉。即使我们有专门负责打扫的人，但我对此有主人翁的自豪感，我与它紧密相连”。我认为这会带来巨大的差异。在 Airbnb，我觉得有这种感觉的人更愿意对某些事情提出异议，或者愿意提出新想法，因为他们觉得自己对公司有投入。

---

### [00:38:12] Jason Shah

**English:**
I see it at Alchemy all the time. I see an engineer hop in and fix something at 3:00 AM because they feel committed to the code base, and it's not a thousand-person engineering organization where my only job is to make the iOS app 2% more effective at engaging users.

**中文翻译:**
我在 Alchemy 经常看到这种情况。我看到工程师在凌晨 3 点跳出来修复问题，因为他们对代码库有使命感。这不像在一个上千人的工程组织里，我的唯一工作就是让 iOS 应用的用户参与度提高 2%。

---

### [00:38:27] Lenny

**English:**
So, you touched on the skill of pushing back on a founder or CEO, and I know that's something you're really good at. I've seen you do this. I'm curious what you've learned about how to effectively do that as a PM at a company pushing back on a CEO or founder when you disagree.

**中文翻译:**
你提到了向创始人或 CEO 提出异议（Pushing back）的技巧，我知道你非常擅长这一点。我亲眼见过你这么做。我很想知道，作为公司的 PM，当你不同意 CEO 或创始人的意见时，你学到了哪些有效沟通的经验？

---

### [00:38:40] Jason Shah

**English:**
I mean, I think this is one of... I actually think it's one of the most misunderstood terms in a sense because I think language like we were talking about earlier is so important, and yet what you call something ends up defining I think 90% of what people understand about a concept, right? And so, pushback is, I couldn't imagine a word more viscerally that makes you feel like you're sort physically going against what somebody else wants, and it gears people into a mindset of then, well, how should I push back. It starts from a place of I need to disagree, I need to say no. It's a very negative mindset, purely based on the word that has come to label a behavior that alternatively could be about how do I shift the direction on something, or how do I help the business actually succeed when I disagree with somebody about something, and that's a very different mindset.

**中文翻译:**
我认为这是……实际上我认为这是最被误解的术语之一。正如我们之前讨论的，语言非常重要，你如何称呼某件事，往往决定了人们对这个概念 90% 的理解。而“Pushback”这个词，我无法想象还有哪个词能让人更直观地感受到你是在生理上对抗他人的意愿。它会让人们陷入“我该如何反击”的思维。它始于“我必须反对，我必须说不”。这是一种非常负面的心态，纯粹是因为这个词被用来定义一种行为，而这种行为本可以是“我该如何调整某件事的方向”，或者“当我与某人意见不合时，我该如何帮助业务取得成功”。这是一种完全不同的心态。

---

### [00:39:34] Jason Shah

**English:**
And so, the two things that I've seen be most successful would be, I think number one is actually understanding what a goal is or what somebody's kind of issue is with something, and then actually aligning those things in some way. So, in coming back to Airbnb, I remember Airbnb had bought a company, Luxury Retreats. There was a goal to integrate that business and that product into the full Airbnb suite, and there was a lot of potential with that, but I remember that there was part of the product experience that was oriented around chatting with somebody and the idea that the business had had a very large team of wonderful people who helped you as concierges basically for your trip, and so, this was a team that I was on that, to be honest, had fairly low morale. It's always difficult to integrate an acquisition with a company, especially when we were based in different places, et cetera.

**中文翻译:**
所以我见过的最成功的两点是：第一，真正理解目标是什么，或者某人对某事的顾虑到底在哪里，然后以某种方式将这些东西统一起来。回到 Airbnb 的例子，我记得 Airbnb 收购了一家叫 Luxury Retreats 的公司。当时的目标是将该业务和产品整合到 Airbnb 的全套产品中，这其中有很大的潜力。但我记得产品体验中有一部分是围绕聊天展开的，当时该业务有一支庞大的优秀团队，基本上是作为你旅行的“礼宾人员”（Concierges）来提供帮助。老实说，我所在的那个团队当时士气相当低落。整合收购的公司总是很困难，尤其是当我们分布在不同地方时。

---

### [00:40:26] Jason Shah

**English:**
I remember hearing from a leader who had been at Airbnb for a while who's very effective at persuading senior leadership, and they understood why this was a problem because this chat product was growing in complexity. You'd have to build all these features into it, and nobody could successfully shift the direction, and as a result, it was just this... It was a mess as a result, and there was very low morale because we were taking on too much scope, people weren't sure it was the right product, it was being built up as one giant launch as opposed to an iterative thing. And what was really interesting was that this leader was very effective at understanding that the goal wasn't about building a bunch of features. It was about, as often discussed at Airbnb, a magical experience.

**中文翻译:**
我记得听过一位在 Airbnb 待了很久的领导者的分享，他非常擅长说服高层领导。他们明白为什么这是一个问题，因为这个聊天产品的复杂度在不断增加。你必须往里塞各种功能，而且没人能成功调整方向。结果就是一团糟，士气非常低落，因为我们承担了太多的工作范围（Scope），大家不确定这是否是正确的产品，而且它是作为一个巨大的发布项目来做的，而不是迭代式的。非常有趣的是，这位领导者非常敏锐地意识到，目标不是构建一堆功能，而是 Airbnb 经常讨论的——“奇妙的体验”。

---

### [00:41:06] Jason Shah

**English:**
And so, when we took a step back, it was reimagined as trip designers, not concierges, and their goal was to design your trip, and part of that meant a very elegant, simple chat experience so that you could have a efficient, fast, positive experience with that trip designer and move on. And it shifted the pushback of like, "We can't build this thing, it's too many features, we don't have enough time, we don't have enough resources" to, "Oh, we all want a really elegant, really smooth, slick experience for our customers. How do we do that? What's a trip design or a new concept that is actually going to elevate things? We're not telling you we want a payback scope. We're not saying we want to settle for less. We're actually just not only going to call it something different, but also envision a simpler experience which is more elegant. It's more on brand with luxury."

**中文翻译:**
所以，当我们退后一步看，它被重新构想为“旅行设计师”（Trip Designers），而不是“礼宾人员”。他们的目标是设计你的旅行，这意味着需要一种非常优雅、简单的聊天体验，让你能与旅行设计师进行高效、快速、积极的沟通，然后继续你的行程。这把原本的对抗——“我们做不出这玩意，功能太多了，时间不够，资源不够”——转变为：“哦，我们都想要给客户提供一种非常优雅、流畅、丝滑的体验。我们该怎么做？什么样的‘旅行设计’新概念能提升体验？我们不是在要求缩减范围，不是在要求妥协。我们不仅要换个称呼，还要构思一个更简单、更优雅的体验。这更符合奢侈品牌的调性。”

---

### [00:41:51] Jason Shah

**English:**
Boom, all of a sudden, everybody gets what they want. It's a better customer experience, less scope, and it wasn't about saying no. It was about understanding what we're all actually sharing as a goal which was a great simple customer experience and then actually building that. So, I saw that to be really effective and I think that that's something I try to bring into my career. I have a couple other examples if it's useful, but that was a big one that I learned from Airbnb.

**中文翻译:**
砰的一声，突然间，每个人都得到了他们想要的。更好的客户体验，更少的工作范围，而且这并不是在说“不”。这是关于理解我们共同的目标——一个极佳且简单的客户体验——然后真正去实现它。我发现这非常有效，我也尝试在我的职业生涯中运用这一点。如果需要的话，我还有几个例子，但那是从 Airbnb 学到的最重要的一课。

---

### [00:42:16] Lenny

**English:**
Yeah, another example would be great. One thought there though is do you think it was mostly the name and the concept or was it that it was a bigger idea? What do you think it was about reframing it that way that got people, "Oh wow, okay, now I'm really excited about it again"?

**中文翻译:**
是的，再举个例子就太好了。不过我有个想法：你认为这主要是因为名字和概念变了，还是因为它变成了一个更宏大的想法？你认为这种重新定义（Reframing）的哪一点让人们觉得“哇，好吧，我现在又兴奋起来了”？

---

### [00:42:30] Jason Shah

**English:**
That's a great point. I think it was a big idea, right, with a good reframing, and I think it's like many things where there's the substance of something and then there's the communication of it. And so, this is true often, for example, if a company is changing strategy. Oftentimes people might walk away feeling like, "Yeah, I guess I kind of agree with the strategy, but the way was communicated was really poor," or vice versa, like, "Yeah, they told us in advance and they sat us down all hands, but I really disagree with this strategy and I'm going to be dug into my heels and not disagree and commit now."

**中文翻译:**
这是一个很好的观点。我认为这是一个宏大的想法，加上了巧妙的重新定义。就像很多事情一样，既有事物的本质，也有沟通的方式。这在公司改变战略时经常发生。通常人们离开会议时会觉得：“是的，我大概同意这个战略，但沟通方式太烂了”；或者反过来：“是的，他们提前告诉了我们，还开了全员大会，但我真的不同意这个战略，我会坚持己见，而不是‘保留意见并执行’（Disagree and commit）。”

---

### [00:42:58] Jason Shah

**English:**
So, in this case, I think you're totally right. If it was just window dressing of... Founders are too smart, especially at all these companies we've talked about, to be fooled with a simple renaming of something. But I think the combination of a bigger idea, more exciting idea that was at the heart of what we were all going after together, combined with a simple way of communicating it because I've also seen big ideas that are poorly communicated fall flat on their face and not achieve the intended outcome. Those two together, I think were a really potent combination.

**中文翻译:**
所以在这个案例中，我认为你完全正确。如果只是表面文章……创始人太聪明了，尤其是我们讨论过的这些公司的创始人，不可能被简单的改名所愚弄。但我认为，一个更宏大、更令人兴奋的想法（这是我们共同追求的核心），结合简单的沟通方式，才是关键。因为我也见过很多宏大的想法由于沟通不畅而惨遭失败，没能达到预期效果。这两者结合在一起，我认为是一个非常强大的组合。

---

### [00:43:28] Lenny

**English:**
Awesome. I'd love to hear another example.

**中文翻译:**
太棒了。我很想再听一个例子。

---

### [00:43:30] Jason Shah

**English:**
Yeah, for sure. So, a recent example at Alchemy actually, right? We're growing, we're hiring, but there are a lot of roles, especially being in Web3 that are not yet created. For example, there's traditionally growth, product growth marketing, we've created new area around growth operations which I'd be happy to talk about if we want to get into it. But it's a really interest interesting area, and we were going back and forth on should we hire for this role, it's not even a real thing. We've looked at some candidates, we're not so sure about them. And when I realize with our founders who are incredibly smart, very talented, have built the company over so many years now, they want to win. That's what they care about at the end of the day. They are so driven to win at the end of the day.

**中文翻译:**
没问题。举一个最近在 Alchemy 的例子。我们在增长，在招聘，但有很多职位，尤其是在 Web3 领域，还没有被定义出来。例如，传统上有增长、产品增长营销，我们围绕“增长运营”（Growth Operations）创建了一个新领域，如果想聊的话我很乐意展开。这是一个非常有趣的领域。我们当时在反复讨论是否应该招聘这个职位，因为它甚至还不是一个真实存在的标准职位。我们看了一些候选人，但不确定。后来我意识到，我们的创始人非常聪明、才华横溢，经营公司多年，他们最想要的就是“赢”。归根结底，这就是他们最在乎的事。他们非常有求胜欲。

---

### [00:44:10] Jason Shah

**English:**
And so, ultimately, it wasn't like, "Let me make some rational argument about the role of growth operations or let me defend some issues with this person's resume that maybe you're spotting when we make this hiring decision," but, "Oh, you want to win? Oh, we want to grow faster? Awesome. This is the way to do it, and that's how we're going to actually become the generational company we want to be." Again, a reframing in this case around, yeah, we might disagree or squabble about certain things at a detail level, but I understand what we all came here to do and let's focus on that and how this is a part of that versus just focusing on maybe the means to an end versus the end itself, and the end always brings a lot of clarity in my experience.

**中文翻译:**
所以，最终我没有说：“让我来理性论证一下增长运营的作用，或者为这个人的简历瑕疵辩护”，而是说：“哦，你们想赢？想增长得更快？太棒了。这就是实现目标的方法，这就是我们如何成为我们梦寐以求的划时代公司的方法。”这又是一个重新定义。在这种情况下，虽然我们可能在细节上存在分歧或争执，但我理解我们共同的目标。让我们专注于目标，以及这件事如何成为目标的一部分，而不是仅仅纠结于手段。根据我的经验，目标总是能带来极大的清晰度。

---

### [00:44:49] Lenny

**English:**
What's cool about both these examples, and another guest touched on this, when you're trying to influence the CEO or the founder, coming back to your working backwards concept, you almost want to work backwards from what are they excited about, how do they see the world, what's important to them, and then pitch it that way. So, in the first example, I imagine they were pitching to Brian and he's like, "Yeah, drip design, that sounds like something Brian would love." Then in the second example, "Yeah, we're going to win. Here's how we win." So, that's a really interesting takeaway there.

**中文翻译:**
这两个例子的酷点在于，另一位嘉宾也提到过：当你试图影响 CEO 或创始人时，回到你的“逆向工作法”概念，你几乎要从“他们对什么感到兴奋”、“他们如何看待世界”、“什么对他们最重要”开始倒推，然后以此进行提案。所以在第一个例子中，我能想象他们向 Brian 提案时，Brian 会觉得：“是的，旅行设计，这听起来就是 Brian 会喜欢的东西。”在第二个例子中则是：“是的，我们要赢。这就是赢的方法。”这是一个非常有趣的启示。

---

### [00:45:15] Jason Shah

**English:**
I mean, I think we all forget that we're all just humans, and at the end of the day, we all are busy, et cetera. It reminds me of a lot of sales, right? I was very unsuccessful when I was trying to do outbound sales in the early days of my last startup do.com because I didn't understand this. I'm a product person. I'm not a sales person. I didn't listen to what people cared about. I didn't kind of work backwards from what a CRO or head of people that we might have been selling to cared about. I was just about features and here's what we can do for you and this and that. But all they cared about were one or two things, right? Maybe the CRO's growing revenue. Maybe the head of peoples worried about culture or scaling their talent organization, and we were nowhere near that list.

**中文翻译:**
我的意思是，我们都忘了大家都是普通人，归根结底，大家都很忙。这让我想起了很多销售技巧。在我上一家初创公司 do.com 早期尝试做外呼销售时，我非常失败，因为我不明白这一点。我是个产品人，不是销售。我没有倾听人们真正在乎什么。我没有从首席营收官（CRO）或人力资源主管（他们是我们的销售对象）在乎的事情倒推。我只关注功能，说“我们能为你做这个做那个”。但他们只在乎一两件事，对吧？也许 CRO 只在乎增加收入，人力资源主管只在乎文化或扩展人才组织，而我们的功能根本不在他们的关注列表里。

---

### [00:45:56] Jason Shah

**English:**
And so, I think it's similar for CEOs, and there's a huge disconnect when say a PM walks into a meeting with the CEO and they're talking about something that CEO is 10 miles away from thinking about, and certainly even the mindset that they're bringing to the conversation is totally different. I think Casey made a lot of great points about this in the recent podcast as well.

**中文翻译:**
所以，我认为对 CEO 来说也是一样的。当一个 PM 走进 CEO 的办公室，谈论一些 CEO 根本没在考虑的事情时，就会产生巨大的脱节，而且他们带入对话的心态也完全不同。我认为 Casey 在最近的播客中也对此提出了很多精辟的见解。

---

### [00:46:16] Lenny

**English:**
Sweet. Casey Winters, podcast plug. Okay, so something else that you're really good at is you don't kind of focus career-wise on working your way up the ladder and being like the top PM, and you seem to be really good at kind of following with what's interesting to you and your interest and your curiosity. Is there something that you've learned there, something you could share for folks that are just like, "Oh my gosh, should I just keep in with this job and work my way up? Should I try something new?" What have you learned about that sort of thinking?

**中文翻译:**
太棒了。Casey Winters，播客植入。好的，你还擅长另一件事：在职业生涯中，你似乎并不专注于顺着阶梯往上爬，非要做什么“顶级 PM”。你似乎非常擅长追随自己的兴趣和好奇心。关于这一点你学到了什么？你能为那些纠结于“天哪，我是该守着这份工作往上爬，还是该尝试新事物”的人分享些什么吗？

---

### [00:46:46] Jason Shah

**English:**
There's the framework I like is ladder versus map, and I think that you can be either person that any point in your life. Sometimes there's a bit of a set mindset that somebody might have one way or another, but I like ladder versus map. Ladder is about moving up. It's more influence, more power, a higher title, things like this, whereas map is I just want to go wherever's interesting, right? I literally think of it, I think of my career very similar to travel. I want to go to Greece. I want to be hungry, walking around in India, sweating in a hundred degree weather. I want to go to Australia and kind of get locked out of my hotel and see what that's like.

**中文翻译:**
我喜欢的一个框架是“阶梯 vs. 地图”。我认为你在人生的任何阶段都可以选择成为其中一种人。有时人们会有某种固定的心态，但我喜欢这个对比。阶梯是关于向上移动：更多的影响力、更大的权力、更高的头衔等等。而地图是“我只想去任何有趣的地方”。我真的会把职业生涯想象成旅行。我想去希腊；我想在印度挨着饿走来走去，在 100 华氏度的高温下流汗；我想去澳大利亚，体验一下被锁在酒店门外的感觉。

---

### [00:47:23] Jason Shah

**English:**
I'm okay with discomfort because it's interesting. Sometimes, for better or worse, maybe this is a privilege, it's certainly a privileged thing to say, but I care more about living a really interesting life than let's say a good or comfortable life. I think that's where the growth comes from. That's where the stories come from. That's to me the things that I'll remember the most.

**中文翻译:**
我不介意不适感，因为那很有趣。有时，不管好坏，也许这是一种特权——说这话确实有点特权阶层的味道——但我更在乎过一种非常有趣的生活，而不是所谓“好”或“舒适”的生活。我认为这就是成长的来源，是故事的来源。对我来说，这些才是我最能记住的事情。

---

### [00:47:42] Jason Shah

**English:**
And so, when I think about product and I'm on my deathbed, I'm going to care about the products I built and how they affected people. Nobody's really going to be looking at my LinkedIn, hopefully for their sake and mine, at my funeral. Sorry, it's a very morbid analogy, but I think thinking of the future provides a lot of clarity about what am I going to care about a long time from now, and I think that applies to all facets of life. That's how I thought about my life partner. That's how I think about my career. That's how I think about where I want to live, San Francisco. San Francisco, a lot of people like to talk negatively about it, but I believe in the community. I believe in the place I'm interested in the long term, even if you know the short term it has some challenges to it.

**中文翻译:**
所以，当我想到产品，想到我临终之时，我会在乎我构建的产品以及它们如何影响了人们。在我的葬礼上，没人会去看我的 LinkedIn 个人资料，希望为了他们和我的面子，千万别看。抱歉，这个类比有点阴森，但我觉得思考未来能让你看清很久以后自己真正在乎什么。这适用于生活的方方面面。我选择伴侣、思考职业生涯、决定住在旧金山都是如此。很多人喜欢唱衰旧金山，但我相信这里的社区。我相信这个我长期感兴趣的地方，即使短期内它面临一些挑战。

---

### [00:49:03] Lenny

**English:**
Is there a story of or example of how you use this approach to make a decision at where you end up going, and/or or is there something that you maybe regret or are really happy with in terms of the kind of the fork in the road, looking back, using this way of thinking?

**中文翻译:**
有没有什么故事或例子，说明你是如何利用这种方法来决定去向的？或者，回顾过去，有没有什么在人生的十字路口做出的决定，让你感到后悔或非常庆幸的？

---

### [00:49:18] Jason Shah

**English:**
A few concrete examples, actually. I'll keep them brief though. One is when I first moved to San Francisco, and I had mentioned I did a small sale of that education company, and I could have done a lot of more productive things with my career in the short term. I had all my peers from college who had gone off to their great jobs at Google or whatever. I said, "I'm looking to move to San Francisco and work at my dining table, and I have a little bit of savings from this, so why not? Let's see. It's going to be super interesting." I mean, it was also very boring at times, and so, I didn't want a lot on the sort of micro level, but I built five or six products. I became much better at programming as a result.

**中文翻译:**
其实有几个具体的例子。我简短说一下。一个是当我刚搬到旧金山时。我提到过我卖掉了那家教育公司，短期内我本可以做很多对职业生涯更有利的事。我大学的同学都去了谷歌之类的大公司拿到了好工作。但我说：“我想搬到旧金山，坐在餐桌前工作。我有一点积蓄，为什么不试试呢？看看会发生什么，这一定会非常有趣。”我的意思是，有时确实很无聊，在微观层面我没得到太多，但我构建了五六个产品，也因此变得更擅长编程。

---

### [00:49:56] Jason Shah

**English:**
I remember one time, it's kind of a goofy story, but I was working at my dining table, and I saw Ron Conway on the street. I was disheveled because I was just working from my apartment and I wanted to go pitch Ron Conway on this terrible idea for a startup, and so went out there, and maybe it was fortunate to not shove me to the side, and he listened to me for a minute and then I emailed him after. These are random things that happen that over time I think make us who we are. Are you the sort of person who's going to hustle and do that? When I was building that education company, I went and put flyers in people's cars in various high schools, and I was trying to get things started, and coming back to leadership, that would be below most people. It's like, "Wait, you own a company and you're sticking flyers in people's windshields?" It was like, "What's wrong with you?"

**中文翻译:**
我记得有一次，这是一个有点傻的故事。我正在餐桌前工作，看到 Ron Conway（著名投资人）走在街上。当时我蓬头垢面，因为我一直在公寓里工作，但我冲出去想向他推销一个糟糕的创业想法。也许我很幸运，他没有把我推开，他听我讲了一分钟，之后我还给他发了邮件。这些都是随机发生的事情，随着时间的推移，我认为它们造就了我们。你是不是那种会努力去争取的人？当我创办那家教育公司时，我曾去各个高中往人们的车上塞传单，试图让业务运转起来。回到领导力的话题，大多数人会觉得这太掉价了。他们会说：“等等，你拥有一家公司，却在往别人的挡风玻璃上贴传单？”他们会觉得“你是不是有毛病？”

---

### [00:50:40] Jason Shah

**English:**
So, anyway, I think that was an example of time where it was like, "Okay, if I'm on the ladder," I'm like, "I got to get the best entry-level job or whatever." Even if I had been an entrepreneur before that, I would've thought about my structure in my career, and I was more like, "This is going to be interesting. I'll figure it out. I believe in myself enough that I'll figure it out." So, I did that. Yammer and leaving Yammer was similar where I could have stayed. My equity was finally worth something. I could have learned a lot even I'm sure from the Microsoft structure, but I was bored and I had been talking to a couple angel investors who were willing to put money into whatever the thing was going to be, and I felt like raising money's actually going to be really hard for me. This is going to make my life a lot easier and I can focus on product and so on and so forth.

**中文翻译:**
总之，我认为那是一个例子。如果我当时在“阶梯”上，我会想：“我得找个最好的入门级工作。”即使我之前创过业，我也会考虑职业结构的完整性。但我当时想的是：“这会很有趣，我会搞定的。我足够相信自己能搞定。”所以我那么做了。离开 Yammer 时也类似，我本可以留下。我的期权终于值钱了。我肯定也能从微软的架构中学到很多。但我感到无聊，而且我当时在和几个天使投资人聊天，他们愿意投资我未来想做的任何事情。我觉得融资对我来说其实很难，这会让我的生活轻松很多，让我能专注于产品等等。

---

### [00:51:25] Jason Shah

**English:**
That was a really hard four years. Things like an M&A offer falling through the day before your wedding, or chewing glass and submitting to the Apple iStore and being a featured app and then resubmitting because we wanted to fix a bug, and then actually now it crashes 90% of the time. It's Memorial Day weekend and you can't get in touch with the Apple business development manager who can help you out to reapprove something. It was a really stressful four years, but using the map analogy, that's like getting lost in Croatia and having to find your way out or getting lost to to your hotel in Australia or getting bitten by a dog in Thailand, which actually did happen to me. But these are interesting experiences that I think build characters.

**中文翻译:**
那是非常艰难的四年。比如在婚礼前一天并购邀约告吹；或者像“嚼玻璃”一样痛苦地向苹果商店提交应用，好不容易成了推荐应用，却因为想修个 Bug 重新提交，结果新版本 90% 的时间都在崩溃。当时正值阵亡将士纪念日周末，你联系不上任何能帮你重新审核的苹果业务经理。那是压力巨大的四年，但用“地图”来类比，这就像在克罗地亚迷路了必须自己找路出来，或者在澳大利亚找不到回酒店的路，或者在泰国被狗咬了（这事儿真发生在我身上）。但这些都是有趣的经历，我认为它们塑造了性格。

---

### [00:52:05] Jason Shah

**English:**
So, I'll pause there, but I think there are a lot of career decisions I've made. Do I have regrets? At times, for sure because you see what would've happened if you had joined a different company at that time and it would've been like, "Oh, I would've met so many great people. I would've worked on these products. I mean, my equity would've been worth more," whatever. But I think you only lived once, and I think that these rare experiences have been very true to me and taught me things that I wouldn't learn otherwise.

**中文翻译:**
我就说这么多，但我做过很多职业决定。我有遗憾吗？有时肯定有，因为你会看到如果你当时加入另一家公司会发生什么：“哦，我会遇到这么多优秀的人，我会参与这些产品的开发，我的期权会更值钱”等等。但我认为人只能活一次，这些罕见的经历对我来说非常真实，教会了我一些在其他地方学不到的东西。

---

### [00:52:28] Lenny

**English:**
What's really cool about that analogy, ladder versus map, is a lot of times you think you're climbing a ladder and you think it's innately going to be great, and sometimes that ladder falls over and the company doesn't go anywhere and/or the job sucks, your ladder's heading to some terrible place. And what I find in my experience is anytime I try something totally new and take a risk, especially following things that give me energy, and I'm just like, "Let's just take a leap on this thing," in my experience at least, it's always led to better opportunities and much more interesting work. And so, it's kind of this get off the ladder to get on a different ladder, and sometimes you think you're on a nice ladder and it's not going to get you anywhere anyway. So, explore other ladders. So, I'm kind of picturing a Chutes and Ladders.

**中文翻译:**
“阶梯 vs. 地图”这个类比最酷的地方在于：很多时候你以为自己在爬阶梯，以为它天生就很棒，但有时阶梯会倒塌，公司倒闭，或者工作很烂，你的阶梯通向了一个糟糕的地方。根据我的经验，每当我尝试全新的事物并承担风险，尤其是追随那些能给我能量的事物，心想“就放手一搏吧”，至少在我的经验中，这总是能带来更好的机会和更有趣的工作。所以这有点像“跳下这个阶梯去爬另一个阶梯”。有时你以为自己在一个不错的阶梯上，但它其实哪儿也带你去不了。所以，去探索其他的阶梯吧。我脑子里现在浮现出了“蛇与梯子”游戏的画面。

---

### [00:53:15] Jason Shah

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:53:15] Lenny

**English:**
There's many ladders and you want to explore the different ladders across the map. How about that?

**中文翻译:**
有很多阶梯，你想探索地图上不同的阶梯。这样说怎么样？

---

### [00:53:20] Jason Shah

**English:**
I mean, I think you're totally right, and the only brief thing I would add to the way that you put it which I think captures the essence here is I think we all have a lot of false precision about what we think a given career move is going to lead to or what it's going to be like, and we forget that a lot of career decisions are made out of maybe 10 hours cumulatively talking to a team and getting signals.

**中文翻译:**
我认为你完全正确。我想补充一点，你刚才的描述抓住了本质：我认为我们对某个职业变动会带来什么结果，或者它会是什么样子，往往有一种“虚假的精确感”。我们忘了，很多职业决定其实只是基于与团队累计交流了大约 10 小时所获得的信号做出的。

---

### [00:53:44] Jason Shah

**English:**
So, I think that that false precision sometimes gives us comfort in making certain decisions and folds us back from a bolder decision that might be better, but maybe the ladder is just hidden behind some fog if you really want that, and you can get both. Maybe you can go to the most interesting place in the world, and have the success in life and progress and so on and so forth. It's just that I think a lot of people think it's totally either/or. They think that they've already figured out the precise outcome that's going to happen, and to your point, the ladder often does fall over. If that's what all your hopes are pinned on, it's a very fragile career decision I think is really difficult to navigate.

**中文翻译:**
所以，我认为这种虚假的精确感有时让我们在做某些决定时感到安慰，却阻碍了我们做出可能更好的、更大胆的决定。也许如果你真的想要，那个阶梯只是隐藏在迷雾后面，而且你可以两者兼得。也许你可以去世界上最有趣的地方，同时在生活中取得成功和进步。只是我觉得很多人认为这完全是“非此即彼”。他们认为自己已经预见到了精确的结果，但正如你所说，阶梯经常会倒塌。如果你把所有的希望都寄托在上面，那将是一个非常脆弱的职业决定，很难应对。

---

### [00:54:19] Lenny

**English:**
The flip side, you also don't want to be bouncing around over and over and over. As much as I talked about how I shifted and tried new things, I'm a very serial monogamous in terms of work. My first job, I was there nine years, then a startup for a year and a half, and then Airbnb for seven years, and then what I'm doing now may be forever. And so, there's a lot of value to sticking around and kind of seeing things through. And so, I guess, I don't know if you'll have an answer to this, but do you have any wisdom on when to stick with it and keep exploring opportunities at a place you're at versus trying something new?

**中文翻译:**
另一方面，你也不想一直跳来跳去。虽然我谈到了我是如何转变和尝试新事物的，但在工作方面，我其实非常“长情”。我的第一份工作做了九年，然后是一家做了一年半的初创公司，接着在 Airbnb 待了七年，现在我做的事情可能会做一辈子。所以，坚持下去并把事情做成是有很大价值的。所以，我不知道你是否有答案，但关于什么时候该坚持并在当前的地方继续探索机会，什么时候该尝试新事物，你有什么建议吗？

---

### [00:54:54] Jason Shah

**English:**
My hope is that there's a balance here in the sense that the map shouldn't give the impression of 180 countries, let's do 180 tech companies and shorten the tenure from two years down to a month, and we've just created a generation of job hoppers which is even easier because we're all on Zoom. It's a good point and I really respect people like you who have stuck it out through the ups and the downs and somebody sees seven years on paper, but I mean, seven years, I don't know. How many chapters of Airbnb, how many crises moments?

**中文翻译:**
我希望这其中有一种平衡。也就是说，“地图”不应该给人一种“去过 180 个国家，所以也要去 180 家科技公司，把任期从两年缩短到一个月”的印象。那样我们就创造了一代“跳槽狂人”，而且因为大家都在 Zoom 上办公，跳槽变得更容易了。这是一个很好的观点，我非常尊重像你这样经历起伏并坚持下来的人。别人在纸上看到的是“七年”，但我的意思是，这七年里，Airbnb 经历了多少篇章，多少危机时刻？

---

### [00:55:26] Lenny

**English:**
Felt like 300.

**中文翻译:**
感觉像经历了 300 次。

---

### [00:55:27] Jason Shah

**English:**
There you go. So, I think there's a balance, right? For example, I want to be in Web3 for more than a decade. I want to stay at Alchemy for a very long time and help build the company. So, I guess when I think of map, maybe an important way to think about it is maybe when somebody is 50 or 60 or 70 and they might choose to stop working, a lot of people when they start their career actually have 30 years to play with or 40 years or 50 if they're lucky. That's a lot of chips you can play. You could do five, 10 year rounds, right? And so, I think that in terms of sticking it out, maybe I'm biased, I think that some of the absolute sort gems, if you will, in Silicon Valley and tech are the teammates that are willing to stay around for 4, 5, 6, 7 years, and they have institutional knowledge that nobody has. They have a positive impact on the culture that is impossible if there's constant employee turnover.

**中文翻译:**
没错。所以我觉得这需要平衡。例如，我想在 Web3 待上十年以上。我想在 Alchemy 待很长时间，帮助建立这家公司。所以，当我想到“地图”时，一个重要的思考方式是：当一个人 50、60 或 70 岁选择退休时，很多人在职业生涯开始时其实有 30 年、40 年甚至 50 年的时间可以挥洒。这是很多可以投入的筹码。你可以做五个为期 10 年的阶段，对吧？所以，关于坚持，也许我有偏见，但我认为硅谷和科技界真正的“瑰宝”是那些愿意留下来工作 4、5、6、7 年的队友。他们拥有别人没有的制度性知识（Institutional knowledge）。他们对文化有积极的影响，而如果员工频繁流动，这是不可能实现的。

---

### [00:56:19] Jason Shah

**English:**
So, to me, I think that you could simultaneously be somebody who's committed to companies, stays for a very meaningful amount of time, but zooms out and looks at their career. Actually, I think maybe this was even more, right? You're now a famous podcaster. You were a successful startup founder. You were a product leader. All these things form a map and I think a really interesting career and life, frankly, that's pretty full with a lot of really interesting milestones and learnings and networks and people that you get to interact with.

**中文翻译:**
所以对我来说，我认为你可以同时做一个对公司忠诚、待很长时间的人，同时又能放大视角审视自己的职业生涯。实际上，我觉得你就是个例子，对吧？你现在是著名的播客主持人，你曾是成功的初创公司创始人，你曾是产品领导者。所有这些构成了一张地图，坦率地说，这是一个非常有趣的职业生涯和人生，充满了有趣的里程碑、收获、人脉以及你所接触到的人。

---

### [00:56:47] Lenny

**English:**
Yeah. To your point about how long a career is, when I thought about it recently, this is my fourth career. First it was an engineer, then it was a founder, then a product manager when I got to Airbnb, and now this weird thing that I do, and there's so much time to explore and try new things. I will say though, I feel like the early things you do seem really important. Airbnb for me was not early, so maybe I'm wrong, but it feels like you want to work at a company where people look at that on your resume and are like, "Oh, okay, this person's probably good." So, I feel like there's that piece you got to get right at some point.

**中文翻译:**
是的。关于职业生涯有多长，我最近想了想，这是我的第四份职业。首先是工程师，然后是创始人，加入 Airbnb 后成了产品经理，现在是我做的这个“奇怪的事情”。有太多的时间去探索和尝试新事物。不过我要说的是，我觉得你早期做的事情似乎非常重要。对我来说，Airbnb 并不算早期，所以也许我错了，但感觉你总想在一家公司工作过，让别人看到你简历上的那段经历时会想：“哦，好吧，这个人可能很优秀。”我觉得你必须在某个时刻把这一块做对。

---

### [00:57:21] Jason Shah

**English:**
Yeah, I totally agree with that. For example, I think for let's say a new grad who's thinking about a product career, and let's say on the spectrum there is maybe Goldman Sachs because that's what a lot of people are doing. They're like, "Yeah, I want to do product, but I also feel like I need this gold star or whatever." And then in between is you could join a hypergrowth company of some sort where they definitely have good product people you can learn from, but definitely still room for you to do more than what a very junior person would be assigned to be doing. And then on the other end of the spectrum is I'm going to have no job, I'm just going to completely bounce around from my own projects or just work with a new startup every two months.

**中文翻译:**
是的，我完全同意。例如，对于一个考虑从事产品职业的应届生来说，假设光谱的一端是高盛，因为很多人都这么选。他们会想：“是的，我想做产品，但我同时也觉得我需要这个‘金字招牌’之类的东西。”光谱中间是加入某种高速增长的公司，那里肯定有优秀的产品人供你学习，但也肯定有空间让你做比普通初级员工更多的事情。光谱的另一端是完全不找工作，只是在自己的项目里跳来跳去，或者每两个月换一家初创公司合作。

---

### [00:57:58] Jason Shah

**English:**
Personally in that spectrum, I tend to be more towards the middle of that where build a track record, build a network. I mean, it's crazy. Even just this week, next week I'm seeing maybe five people that I know from my Yammer days, and to your point on formative nature, some of those people, that's how I learned how to do product. That's how I learned things like AB testing. It's how I had the first angel investors in my next company. That's how I hire. I still hire people, maybe much to their chagrin, they still get LinkedIn messages for me trying to push them for the next thing.

**中文翻译:**
就这个光谱而言，我个人倾向于中间位置：建立业绩记录，建立人脉。我的意思是，这很疯狂。就在这周和下周，我要见大约五个我在 Yammer 时代认识的人。回到你说的“定型”性质，正是从那些人身上，我学会了如何做产品，学会了 AB 测试之类的事情。我下一家公司的第一批天使投资人也是这么来的。这也是我招聘的方式。我仍然在招人，也许让他们苦恼的是，他们仍然会收到我的 LinkedIn 消息，试图拉他们去做下一件事。

---

### [00:58:27] Jason Shah

**English:**
So, I totally agree that those early days are really formative, and there's maybe a balance between nobody wants to be a job hopper, but at the same time maybe there's ways to also not just be a career person who spends kind of 30 years working up the ladder or is fixated on I need to be CPO but is willing to give up a director title to go be a hustler at some startup because they really believe in it and they want to take a bet or risk in their career.

**中文翻译:**
所以我完全同意早期阶段非常具有塑造性。这其中可能有一种平衡：没人想成为跳槽狂人，但同时，也许也有办法不只是做一个花 30 年顺着阶梯往上爬的“职场人”，或者不只是固执于“我必须当 CPO”，而是愿意放弃总监头衔去某家初创公司当个拼命三郎，因为他们真的相信那件事，并愿意在职业生涯中赌一把或承担风险。

---

### [00:58:50] Lenny

**English:**
You touched on hiring, and that's something I wanted to ask you. So, you're in my Talent Collective. You're a company that's hiring, Alchemy, and I was looking at the stats recently, and you're one of the most successful companies at getting candidates to talk to you, and generally I think you're just really good at hiring. So, I'm curious what you can share with folks about hiring.

**中文翻译:**
你提到了招聘，这也是我想问你的。你在我的“人才集体”（Talent Collective）里。你们公司 Alchemy 正在招人。我最近看了一下统计数据，你们是邀请候选人沟通成功率最高的公司之一。总的来说，我认为你非常擅长招聘。所以我很好奇，关于招聘，你能和大家分享些什么？

---

### [00:59:10] Jason Shah

**English:**
I appreciate that, and I get a lot of value out of meeting some really talented people from the Collective. I think hiring, it's funny, it reminds me of sort of push back in a sense of what you call it has such an impact on how people think about it. It's hiring, recruiting, but if people reframe it as the people you are going to work with every day or the people who make the company what it is, it shifts the mindset. It's like how is that not the most important thing to be thinking about as a leader or as a founder. A lot of people have benchmarks. I think maybe on the Google podcast I talk about 30%, 40% of a founder's time maybe spent on recruiting because I think deep down everybody understands that that's incredibly valuable.

**中文翻译:**
谢谢，我也从“人才集体”中结识优秀人才的过程中获益匪浅。关于招聘，很有趣，这让我想起了之前说的“Pushback”。你如何称呼它，对人们如何看待它有巨大影响。它是“雇佣”、“招聘”，但如果人们把它重新定义为“你每天要共事的人”或“成就公司的人”，心态就会转变。作为领导者或创始人，这怎么可能不是最重要的事情呢？很多人都有基准。我想也许在谷歌的播客中我提到过，创始人 30% 到 40% 的时间应该花在招聘上，因为我认为内心深处每个人都明白那是极具价值的。

---

### [00:59:53] Jason Shah

**English:**
I think that for me personally, I was reflecting ahead of the podcast on how I approach things now after different stages of hiring, and for context, for what it's worth, I've been at the zero person startup. It's just me and I'm trying to convince some Google engineer to come join us which is incredibly hard and has a low hit rate, to a place like Amazon or Airbnb where you have a large world-class recruiting organization that is effectively doing sourcing for you and setting up interviews and such things like this, and there's formal calibrations and interview panels, to a place like Alchemy where it's very sort of scrappy. We need to figure out who we even want to hire. The founders still meet with every candidate. It's a really different environment.

**中文翻译:**
对我个人而言，在录制播客前我反思了自己在不同招聘阶段的处理方式。为了提供背景，我待过“零人”初创公司（只有我一个人），我得试图说服某个谷歌工程师加入，这极其困难且成功率很低；我也待过像亚马逊或 Airbnb 这样拥有庞大世界级招聘组织的机构，他们会为你寻找人选、安排面试等等，还有正式的校准和面试小组；再到像 Alchemy 这样非常“草根”的地方，我们需要弄清楚到底想招什么样的人，创始人仍然会见每一位候选人。这是一个完全不同的环境。

---

### [01:00:34] Jason Shah

**English:**
So, this is kind of the spectrum that I've seen, and I was reflecting what do I think works the best, and I like to think of it in very similar motions to a business where I think there is a marketing aspect to it, there was a sales aspect, and there is a product aspect to it. What I mean by that is that on a marketing level, I think what has a person heard about your company. Do they know anybody who works there? Do they read your LinkedIn post about things and already know that you're a known quantity before they even step in the door to interview? Are they even willing to interview based on what they know about the company? And so, I think that the marketing aspect in it, and I mean it's sort of lower case marketing in this sense of course because I think a hard sell of any sort or anything that's not authentic is probably going to fail ultimately, but it's about developing a really positive kind of brand and reputation for a company but also as an individual.

**中文翻译:**
这就是我见过的光谱。我一直在反思什么最有效。我喜欢把它看作与经营业务非常相似的过程：它有营销（Marketing）层面、销售（Sales）层面和产品（Product）层面。我的意思是，在营销层面，一个人听说过你们公司什么？他们认识在那里工作的人吗？他们读过你关于某些事情的 LinkedIn 帖子，并在进门面试前就已经对你有所了解了吗？基于他们对公司的了解，他们甚至愿意来面试吗？我认为这就是其中的营销层面——当然我指的是广义的营销，因为我认为任何形式的强行推销或不真实的东西最终都会失败。它是关于为公司，也为你个人建立一种非常积极的品牌和声誉。

---

### [01:01:26] Jason Shah

**English:**
And then if you pass that threshold, I feel like there's a sort of a sales process, and we were talking about how bad of a salesperson I am, for example, because I didn't listen to people's pain points and understand the one or two things that were most important to them. I think similarly in this context, if they're an engineer, do they want to work in a world-class engineering organization? If they're a product person or they're just really excited about crypto and they want to find a way in, a place like Alchemy's the best place for them to learn that is how to think about it, and it's not about misdirecting on or matching whatever they say, but it's about really understanding who they are and what motivates them and what they're excited about because I'm as concerned about the kind of post-hiring step as I am the pre-hiring and want them to work out and be happy and be effective.

**中文翻译:**
如果你通过了那个门槛，接下来就像是一个销售过程。我们刚才聊到我以前是个多么糟糕的销售，因为我不听别人的痛点，不理解对他们最重要的那一两件事。在这个语境下也类似：如果他们是工程师，他们想在世界级的工程组织工作吗？如果他们是产品人，或者只是对加密货币非常兴奋并想找个切入点，那么像 Alchemy 这样的地方就是他们学习如何思考这个领域的最佳场所。这并不是要误导他们或迎合他们说的每一句话，而是要真正理解他们是谁，什么在激励他们，他们对什么感到兴奋。因为我不仅关心入职前，也同样关心入职后的阶段，我希望他们能胜任工作、感到快乐并发挥效力。

---

### [01:02:12] Jason Shah

**English:**
And then lastly, I think there's a product angle to it that not a lot of people think about or talk about a lot because I think the product, it's one of those rare cases where job descriptions are almost like product specs, right? They're here's what the responsibilities are, here's what we need you to do, here's the qualifications we're looking for. And what's really funny about that is that product is very iterative, but somehow we just write a job description, and then it's bait, it's done, it's posted, and nobody thinks about it again until the person's hired and then they take it down.

**中文翻译:**
最后，我认为还有一个产品角度，很多人没考虑到或没怎么谈论过。我认为在招聘中，职位描述（JD）几乎就像产品规格书（Product Specs），对吧？上面写着职责是什么、我们需要你做什么、我们寻找什么样的资历。有趣的是，产品是非常讲究迭代的，但不知为何，我们写完一份职位描述后，它就像鱼饵一样被扔在那，发布了，然后就没人再理它了，直到招到人把它撤下来。

---

### [01:02:41] Jason Shah

**English:**
I think taking a product mindset where I meet people all the time now where I don't really know exactly what role they're necessarily going to fill, I'm not really sure about exactly their seniority, maybe they don't have a lot of experience, but maybe they would just totally be a rockstar on our product team. And looking at a product that we can mold flexibly and think of the same way if at Airbnb, if we were going to build Airbnb Plus, if we just kind of came back to the Amazon working backwards and just wrote a document and it was over, that's one thing, but we didn't do that, right? We went and actually built rooms and homes that were supposed to be Airbnb Plus, and then we iterate on it and we changed the pillows and we changed the entrance and we changed the scent that you feel when you walk in. We coach host and learned about that.

**中文翻译:**
我认为应该带着产品思维。我现在经常遇到一些人，我并不确切知道他们会填补哪个职位，也不确定他们的资历，也许他们经验不多，但也许他们完全能成为我们产品团队的明星。我们要把职位看作一个可以灵活塑造的产品。就像在 Airbnb，如果我们要做 Airbnb Plus，如果我们只是像亚马逊逆向工作法那样写个文档就结束了，那是一回事；但我们没那么做，对吧？我们真的去建造了符合 Airbnb Plus 标准的房间和房屋，然后不断迭代，更换枕头、更换入口、更换你走进房间时的气味。我们指导房东并从中学习。

---

### [01:03:21] Jason Shah

**English:**
So, I think a product mindset on hiring and iterating on it based on the candidates you're meeting, the needs of the business. So this kind of marketing, sales, product combination has been what I've found to be really effective at getting people excited, understanding who they are and what they need, and then crafting a role that actually makes the person successful, rather than just checks a box in your recruiting software as some new headcount that was hired.

**中文翻译:**
所以，我认为在招聘中运用产品思维，并根据你遇到的候选人和业务需求进行迭代。这种营销、销售、产品的结合，是我发现的让人们感到兴奋、理解他们是谁以及他们需要什么，然后量身定制一个能让其成功的职位的最有效方法，而不仅仅是在招聘软件里勾选一个“已招到新员工”的选项。

---

### [01:03:45] Lenny

**English:**
One last question before we get to our lightning round. For PMs that are listening to this maybe early in their career, what skill have you found to be most important in helping you and helping PMs in general advance in their career?

**中文翻译:**
在进入闪电轮问答之前最后一个问题。对于那些可能处于职业生涯早期的 PM 听众，你认为哪种技能对帮助你以及帮助 PM 整体职业晋升最为重要？

---

### [01:03:59] Jason Shah

**English:**
Yeah, this is a really important question, like the others, but I think that understanding and defining what problem matters is the most important skill that I think I've taken away, and it applies to so many things. It can apply to a specific product we're building. It can apply to what a company's mission is. I think I've found it really effective because it affects pretty much everything. It affects what we're going to build. It affects is the team motivated by what we're doing. So, specifically for example, at a place like Alchemy where, yeah, we're a developer platform, but should we build an SDK so there's abstraction that is easier for developers to use? Should we build an NFT API because we think that's a really important stack to move into and an important use case to support?

**中文翻译:**
是的，这和之前的问题一样重要。我认为我学到的最重要的技能是“理解并定义什么问题才是重要的”。这适用于很多事情。它可以应用于我们正在构建的具体产品，也可以应用于公司的使命。我发现它非常有效，因为它几乎影响一切：影响我们要构建什么，影响团队是否被我们的工作所激励。具体来说，例如在 Alchemy，我们是一个开发者平台，但我们应该构建 SDK 来提供更易用的抽象层吗？我们应该构建 NFT API 吗，因为我们认为这是一个非常重要的技术栈和应用场景？

---

### [01:04:45] Jason Shah

**English:**
Well, the question is what problem are we solving? It's not this versus that just in a vacuum. It's is the problem developer experienced and we want to make things easier to develop. Is the problem that an NFT marketplace, a whole suite of them are trying to grow and need more support from us, and not understanding these problems clearly? And it goes back to my first company. It was an education company, and the problem was that low-income students didn't have access to the same resources to get into college as other students, and that guided everything. That guided the pricing model which was basically free for a long time, and then we monetize on sponsorships from colleges, right? The problem matter, whereas the problem solve was there's not a... A different problem was there's just no good college readiness program. Fine, then you focus manically on the pedagogy and the curriculum and so on and so forth, rather than say the business model and an initial product that you think can work.

**中文翻译:**
问题的核心是：我们要解决什么问题？这不只是在真空中做选择。问题是“开发者体验不够好，我们想让开发变得更容易”吗？还是“一整套 NFT 市场正在增长，需要我们提供更多支持”？如果不清晰地理解这些问题，就无法做出正确决策。这可以追溯到我的第一家公司。那是一家教育公司，问题是低收入学生无法像其他学生一样获得进入大学的资源。这个“问题”引导了一切。它引导了定价模型（很长一段时间内基本免费），然后我们通过大学的赞助来变现。问题的本质决定了方向。如果问题只是“没有好的大学预备课程”，那你会疯狂地专注于教学法和课程设置，而不是商业模式和初始产品。

---

### [01:05:34] Jason Shah

**English:**
So, that's what I've found to be the most useful, and I can give her other examples if it's useful, but understanding what problem we're actually trying to solve and really getting crystal clear about it, I think has been incredibly useful to me and energizing as well.

**中文翻译:**
所以，这就是我发现最实用的东西。如果需要我还可以举其他例子，但理解我们到底在尝试解决什么问题，并对此保持极度的清晰，我认为对我来说非常有用，也让我充满动力。

---

### [01:05:48] Lenny

**English:**
It's such a good reminder, even though it's such a cliche of product managers being, "Well, what problem are we trying to solve here?" People hate that, but Michael Paul, and I mentioned this on a different podcast too, he makes this point that when you do drugs sometimes, you have these epiphanies that you come out and you're like, "Love is all you need, man." It's like, okay, yep. But it feels so right. You really feel it. The reason that it's such a cliche is because people have found it to be so true for so long that it's annoying now, but it also tells you how true it is. And so, I think it's a really good reminder of yes, it's annoying to ask that question, and people make fun of PMs for that, but that's because it's so damn important.

**中文翻译:**
这是一个非常好的提醒，尽管“我们要解决什么问题？”已经成了产品经理的陈词滥调。人们讨厌听这个，但 Michael Pollan（我在另一个播客也提到过）曾指出，有时当你产生幻觉时，你会有一种顿悟，出来后说：“伙计，爱就是你所需要的一切。”大家会觉得“好吧，行吧”。但那种感觉是非常真实的，你真切地感受到了它。之所以成为陈词滥调，是因为人们长期以来发现它是如此正确，以至于现在听起来很烦人，但这也说明了它是多么真理。所以，我认为这是一个很好的提醒：是的，问这个问题很烦人，人们也因此嘲笑 PM，但那是因为它真的太重要了。

---

### [01:06:28] Jason Shah

**English:**
Just a brief kind of additional, what you share there, I mean, I completely agree. I think it's very true in life, right? It's like, well, what matters? And it's like, well, your health, your family, your sense of purpose. It's like nobody's unfamiliar with the answer, but like most things, it's about the application of it and about the nuance of it, and I think that's what product is ultimately sort of all about too.

**中文翻译:**
我想简单补充一下，我完全同意。我认为这在生活中也非常正确，对吧？就像问“什么最重要？”，答案无非是健康、家庭、使命感。没人不知道答案，但就像大多数事情一样，关键在于如何应用以及其中的细微差别。我认为这最终也是产品的核心所在。

---

### [01:06:48] Lenny

**English:**
Awesome. Are you ready for our lightning round where I'm just going to ask you five quick questions, tell me what comes to mind and we'll have some fun. Does that sound good?

**中文翻译:**
太棒了。准备好进入闪电轮问答了吗？我会快速问你五个问题，告诉我你脑子里闪现的第一个想法，我们找点乐子。听起来怎么样？

---

### [01:06:58] Jason Shah

**English:**
That sounds great. Ready.

**中文翻译:**
听起来不错。准备好了。

---

### [01:06:59] Lenny

**English:**
Okay, cool. I think I'm going to start adding music to these things. I got to figure that out. For now, no music. Okay. What book do you recommend most to other PMs?

**中文翻译:**
好的，酷。我想我该给这部分加点音乐，我得研究一下。现在先没音乐。好的，你最向其他 PM 推荐哪本书？

---

### [01:07:07] Jason Shah

**English:**
The Hard Thing About Hard things.

**中文翻译:**
《创业维艰》（The Hard Thing About Hard Things）。

---

### [01:07:10] Lenny

**English:**
Can you add why?

**中文翻译:**
能说说为什么吗？

---

### [01:07:11] Jason Shah

**English:**
I think it teaches product managers to chew glass and care about outcomes the way that a CEO has to, and I think that's a really useful mindset to have.

**中文翻译:**
我认为它教会了产品经理像 CEO 一样去“嚼玻璃”（喻指忍受极大的痛苦和困难）并关注结果。我认为这是一种非常有用的心态。

---

### [01:07:21] Lenny

**English:**
Man, this chew glass metaphor, I don't like the sound of that.

**中文翻译:**
天哪，“嚼玻璃”这个比喻，听起来可不太妙。

---

### [01:07:24] Jason Shah

**English:**
I saw you cringe. I was a little worried about that.

**中文翻译:**
我看到你皱眉了。我刚才还有点担心。

---

### [01:07:27] Lenny

**English:**
Oh my god. What a great job we have here, chewing glass. Okay. Other than Alchemy, what's a company you recommend most to PMs to go look for new gigs if they're looking around?

**中文翻译:**
我的天。我们这工作真棒，天天“嚼玻璃”。好的，除了 Alchemy，如果你要推荐 PM 去找新工作，你最推荐哪家公司？

---

### [01:07:37] Jason Shah

**English:**
I would suggest Polygon, Salon, or MoonPay. I know it's three, but I wanted to give some breath in the Web3 space that might be exciting to people.

**中文翻译:**
我会建议 Polygon、Solana 或 MoonPay。我知道这是三家，但我想在 Web3 领域给人们提供一些令人兴奋的选择。

---

### [01:07:45] Lenny

**English:**
Great, great choices. What's a favorite TV show or movie that you've recently watched?

**中文翻译:**
非常棒的选择。你最近看过的最喜欢的电视剧或电影是什么？

---

### [01:07:48] Jason Shah

**English:**
The Ken Burns Vietnam War series. I'm really into documentaries and history, and it's a really kind of compelling version of history that I've never seen before.

**中文翻译:**
Ken Burns 导演的《越南战争》纪录片系列。我非常喜欢纪录片和历史，这是一个我从未见过的、极具吸引力的历史版本。

---

### [01:07:58] Lenny

**English:**
Awesome. Love that. Okay. Favorite interview question that you like to ask.

**中文翻译:**
太棒了，我也喜欢。好的，你最喜欢问的面试问题是什么？

---

### [01:08:02] Jason Shah

**English:**
What is a risk you regret not taking, why, and what did you learn about yourself?

**中文翻译:**
“你后悔没有承担过的一个风险是什么？为什么？你从中对自己有了什么了解？”

---

### [01:08:08] Lenny

**English:**
What do you look for in an answer there?

**中文翻译:**
你希望在回答中听到什么？

---

### [01:08:10] Jason Shah

**English:**
I think the biggest thing I look for is a growth mindset, to be able to reflect on an experience like that and be vocally self-critical without unproductively being hard on one's self, and I think that the dimension of asking about risk gets at their psychology and how do they think about not only their career, but if they were to work with me, how would they approach problem solving and taking bets on the business.

**中文翻译:**
我认为我最看重的是“成长型思维”。能够反思那样的经历，并敢于自我批评，同时又不会产生无谓的自我否定。我认为询问风险这个维度能触及他们的心理，了解他们不仅是如何思考职业生涯的，还包括如果他们和我共事，他们会如何处理问题解决以及在业务上进行博弈。

---

### [01:08:33] Lenny

**English:**
Awesome. Okay, final question. What's your least favorite vegetable?

**中文翻译:**
太棒了。好的，最后一个问题。你最讨厌的蔬菜是什么？

---

### [01:08:36] Jason Shah

**English:**
Broccoli. I just removed some from a pizza last night that I really didn't want to eat.

**中文翻译:**
西兰花。我昨晚刚从披萨上挑出来一些，我真的不想吃它。

---

### [01:08:41] Lenny

**English:**
Wow. Oh wow, okay. Even like steamed, cook, all the things?

**中文翻译:**
哇。噢哇，好吧。哪怕是蒸的、煮的，所有做法都不行？

---

### [01:08:45] Jason Shah

**English:**
There are no circumstances under which I'm excited about broccoli.

**中文翻译:**
在任何情况下，我都不会对西兰花感到兴奋。

---

### [01:08:49] Lenny

**English:**
Oh man, you got to eat those veggies.

**中文翻译:**
天哪，你得吃蔬菜啊。

---

### [01:08:51] Jason Shah

**English:**
I know. I'm working on it.

**中文翻译:**
我知道，我在努力。

---

### [01:08:52] Lenny

**English:**
Okay, Jason, this was amazing. Lived up to what I was hoping our second episode would be. Definitely better than our first which we'll leave on the cutting room floor. Two last questions. Where can people find you online? I assume Alchemy's hiring, so maybe pointing people there. And then how can listeners be useful to you?

**中文翻译:**
好的，Jason，这太棒了。完全达到了我对我们第二集的预期。肯定比第一集好，那一集我们就留在剪辑室的地板上吧。最后两个问题：大家可以在哪里找到你？我猜 Alchemy 正在招人，所以也许可以指引大家去那里。还有，听众们能为你做些什么？

---

### [01:09:08] Jason Shah

**English:**
Yeah, definitely. So, if you're interested in Alchemy and Web3, go to alchemy.com and click through to our jobs page from there. I'm online @0xShah. That is my crypto pseudonymous handle and happy to engage with folks there. And in terms of being helpful to me, I would love any feedback on anything that came up. I would love any products that people are working on. I also invest, and we also partner with a lot of products and teams at Alchemy, and I would love to meet anybody that's listening on the podcast too because I know Lenny's all about community and has kind of given so much back over the years that I would love to meet folks that are out there and get a chance to spend time talking about the products that you're all building.

**中文翻译:**
当然。如果你对 Alchemy 和 Web3 感兴趣，请访问 alchemy.com 并点击进入我们的招聘页面。我的在线账号是 @0xShah，那是我的加密货币匿名 ID，我很乐意在那里与大家交流。至于如何帮到我，我非常欢迎对今天讨论内容的任何反馈。我也很想了解大家正在开发的产品。我也做投资，我们在 Alchemy 也与很多产品和团队合作。我也很想结识本播客的听众，因为我知道 Lenny 非常看重社区，多年来回馈了很多，我很想结识大家，并有机会聊聊你们正在构建的产品。

---

### [01:09:46] Lenny

**English:**
Awesome. Thanks, Jason.

**中文翻译:**
太棒了。谢谢，Jason。

---

### [01:09:48] Jason Shah

**English:**
Thanks, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### [01:09:50] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。