# Jeanne Grosser - 双语对照

# Lenny's Podcast: Jeanne Grosser (Vercel, Stripe) - Bilingual Transcript

---

### [00:00:00] Lenny Rachitsky

**English:**
I've been getting so many asks for go-to-market help.

**中文翻译:**
我最近收到了非常多关于“进入市场”（Go-to-market，简称 GTM）方面的求助。

---

### [00:00:03] Jeanne DeWitt Grosser

**English:**
With AI, it's just intensified because you have 10 players pursuing the same market opportunity and so your ability to actually bring the product to market to differentiate yourself from the competition has become more strategically important than it was previously.

**中文翻译:**
随着 AI 的出现，这种竞争变得更加激烈了，因为可能有 10 个玩家在追求同一个市场机会。因此，你将产品推向市场并从竞争中脱颖而出的能力，变得比以往任何时候都更具战略意义。

---

### [00:00:18] Lenny Rachitsky

**English:**
I had Jenna Abel on the podcast recently, one of her tips is you don't want to be focusing on here's the pain and problem we're solving and instead focus on here's how you will be better than your competitors.

**中文翻译:**
我最近邀请了 Jenna Abel 参加播客，她的建议之一是：你不要只关注“这是我们要解决的痛点和问题”，而应该专注于“你会如何比你的竞争对手做得更好”。

---

### [00:00:27] Jeanne DeWitt Grosser

**English:**
80% of customers buy to avoid pain or reduce risk as opposed to increased upside, which is a good thing for startup founders to understand. We all love to talk about the art of the possible, everything we're going to enable in the future, but that's often really a sale that's going to resonate with another founder. For everybody else, particularly enterprises. You're avoiding the risk of not making your revenue target next quarter.

**中文翻译:**
80% 的客户购买是为了规避痛苦或降低风险，而不是为了增加收益，这对初创公司创始人来说是非常值得理解的一点。我们都喜欢谈论“可能性的艺术”，谈论我们未来将实现的一切，但这种销售方式通常只能引起另一位创始人的共鸣。对于其他人，尤其是企业客户来说，他们更在乎的是如何规避下个季度无法完成营收目标的风险。

---

### [00:00:52] Lenny Rachitsky

**English:**
I've heard a lot about how you think about go-to-market as a product.

**中文翻译:**
我听过很多关于你如何将“进入市场”视为一种“产品”来思考的观点。

---

### [00:00:55] Jeanne DeWitt Grosser

**English:**
We buy a lot of things because of how we feel about them. The experience that you have of being sold to will increasingly actually differentiate a company and drive buying decisions if products are only different at the merchant. And so then you really want to create a customer buying journey that feels like very unique experiences.

**中文翻译:**
我们购买很多东西是因为我们对它们的感觉。如果产品之间的差异微乎其微，那么你被推销时的体验将越来越成为区分公司的关键，并驱动购买决策。因此，你真的需要创造一个感觉非常独特的客户购买旅程。

---

### [00:01:17] Lenny Rachitsky

**English:**
Something I've heard from so many people you've worked with is that your superpower is building a sales org that doesn't feel like a sales org to engineers.

**中文翻译:**
我从很多和你共事过的人那里听说，你的“超能力”是建立一个让工程师觉得不像销售部门的销售组织。

---

### [00:01:23] Jeanne DeWitt Grosser

**English:**
The litmus test I have always given my sales team is if you are an account executive in my org and I put you in front of 10 engineers at our company, it should take them 10 minutes to figure out you aren't a product manager.

**中文翻译:**
我一直给我的销售团队一个“试金石”测试：如果你是我组织里的客户经理（AE），我把你带到公司 10 个工程师面前，他们应该至少需要 10 分钟才能发现你居然不是产品经理。

---

### [00:01:38] Lenny Rachitsky

**English:**
Today my guest is Jeanne Grosser. Jeanne was chief product officer at Stripe where she built their very early sales team from the ground up. She's currently COO at Vercel where she oversees marketing, sales, customer success, revenue ops and field engineering. Jeanne has built world-class go-to-market teams at multiple unicorns and has advised dozens of companies on doing the same. In our conversation, we go deep on what a world-class go-to-market team looks like, including what the heck is go-to-market, the rise of the go-to-market engineer and how this role is already enabling her team to operate 10 times faster. A bunch of very specific tactics to level up your go-to-market skills, a primer on segmentation, how to think about your go-to-market process like a product, her favorite go-to-market tools, her hot takes on PLG and sales comp and sales hiring, and so much more. If you are looking to get smart on the latest and greatest in go-to-market thinking, this episode is for you.

**中文翻译:**
今天的嘉宾是 Jeanne Grosser。Jeanne 曾任 Stripe 的首席产品官（注：此处应为销售负责人，Stripe 早期职位描述较灵活），在那里她从零开始建立了早期的销售团队。她目前是 Vercel 的首席运营官（COO），负责市场、销售、客户成功、营收运营和现场工程。Jeanne 在多家独角兽公司建立了世界级的 GTM 团队，并为数十家公司提供过相关咨询。在我们的对话中，我们将深入探讨世界级的 GTM 团队是什么样的，包括到底什么是 GTM、“GTM 工程师”的崛起，以及这个角色如何让她的团队运作速度提升 10 倍。我们还会讨论提升 GTM 技能的具体战术、市场细分入门、如何像做产品一样思考 GTM 流程、她最喜欢的 GTM 工具、她对 PLG（产品驱动增长）、销售薪酬和招聘的独特见解等等。如果你想了解 GTM 领域最新、最前沿的思考，这一集就是为你准备的。

---

### [00:02:34] Lenny Rachitsky

**English:**
(Sponsorship segment for Datadog and Lovable...)

**中文翻译:**
（Datadog 和 Lovable 的广告段落，略过具体产品功能翻译，直接进入正文...）

---

### [00:05:29] Lenny Rachitsky

**English:**
Jeanne, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Jeanne，非常感谢你能来，欢迎来到本播客。

---

### [00:05:32] Jeanne DeWitt Grosser

**English:**
Thanks for having me, Lenny.

**中文翻译:**
谢谢邀请我，Lenny。

---

### [00:05:34] Lenny Rachitsky

**English:**
What I wanted to get out of this conversation by the end of this to basically have this conversation be the thing that we send people when they're like, "I want to get better go to market. I'm trying to figure out what to do and get to market." We send them this versus having to hire someone for a lot of money and usually they can't find amazing people, because they're all snatched up. So let me start with just the basics. When people hear at the term go to market, what does that mean? What does that encompass?

**中文翻译:**
我希望在这次对话结束时，它能成为一个标杆。当人们说“我想提升进入市场的能力，我正在摸索该怎么做”时，我们可以直接把这集发给他们，而不是让他们花大价钱去请顾问，而且通常他们也找不到顶尖人才，因为都被抢光了。所以，让我们从基础开始。当人们听到“进入市场”（Go-to-market）这个词时，它到底意味着什么？包含哪些内容？

---

### [00:05:57] Jeanne DeWitt Grosser

**English:**
I think there are two answers to this. Often what people think of is sort of the tip of the spear of what drives revenue, which is marketing and sales. For me, I think of it as any function that is going to touch a customer or make a dollar, and actually my remit at Vercel is that, so that includes marketing, sales, all of your technical sales roles like sales engineers or post-sales platform architects is what we call them at Vercel. It's customer success, it's support, it's partnerships. And the reason I say that is my experience throughout my career has been that those functions often have this Venn diagram strategy where marketing's pursuing one thing, it overlaps with what sales is pursuing, but not perfectly, which also overlaps with what support is pursuing but not perfectly. Examples of this would be slightly differing segmentation frameworks, et cetera.

**中文翻译:**
我认为有两个答案。通常人们想到的是驱动营收的“矛头”，即市场和销售。但对我来说，我认为它是任何会接触客户或赚到钱的职能。实际上，我在 Vercel 的管辖范围就是这些，包括市场、销售、所有的技术销售角色（如销售工程师，或者我们在 Vercel 称之为售后平台架构师的角色）、客户成功、支持以及合作伙伴关系。我之所以这么说，是因为在我的职业生涯中，我发现这些职能通常采用一种“韦恩图”式的策略：市场部追求一个目标，它与销售部的目标有重叠但不完全一致，而销售部又与支持部的目标有重叠但不完全一致。例如，他们使用的市场细分框架可能略有不同。

---

### [00:06:57] Jeanne DeWitt Grosser

**English:**
And so one of the things I think you're going to want to see more in this particular moment is that that become a really integrated lifecycle. In particular, I think we're going to see a lot of the functions of go-to-market get redefined, so we've gone through a period of hyper-specialization in go-to-market depending on how you count them. There are, I think somebody quoted 17 different roles within go-to-market these days and I hypothesize that a lot of those are going to start to collapse. And so if you think of go-to-market more holistically, I think you can kind of go back to what are the jobs to be done from making a customer prospect aware of your product all the way through to high LTV, five years on the platform, fully wall-to-wall, and you're going to want to map that out and orchestrate it the way you would think about that within your own product.

**中文翻译:**
因此，我认为在当前这个时刻，你会希望看到这些职能变成一个真正整合的生命周期。特别是，我认为很多 GTM 职能将被重新定义。我们经历了一个 GTM 极度专业化的时期，根据不同的计算方法，现在 GTM 内部可能有 17 种不同的角色。我假设其中很多角色将开始合并。如果你更全面地思考 GTM，你可以回归到“待完成的任务”（Jobs to be done）：从让潜在客户意识到你的产品，一直到实现高终身价值（LTV）、在平台上留存五年、全面普及。你需要像设计自己的产品一样，去规划和编排这个过程。

---

### [00:07:54] Lenny Rachitsky

**English:**
Awesome. We're going to go through that whole cycle of go-to-market, but so is it safe to say just for most companies that are especially starting out when they say go-to-market, that mostly is sales and then there's marketing as maybe a smaller fraction of that and then as you become more advanced and grow, customer success plays into it, tech sales, things like that?

**中文翻译:**
太棒了。我们会贯穿整个 GTM 周期。那么，对于大多数初创公司来说，当他们说 GTM 时，主要指的是销售，市场营销占较小比例，然后随着公司的成熟和成长，客户成功、技术销售等职能才加入进来，这样理解对吗？

---

### [00:08:12] Jeanne DeWitt Grosser

**English:**
Yeah, that's probably where most start is getting sales or frankly just because a lot of companies also start PLG, you might actually start with marketing and then you're layering in sales when it's time to do the sales assistant and ultimately sales led portions. So I think it can, depending on your product and your initial target market, it can either mean marketing or sales or a combination of those two.

**中文翻译:**
是的，大多数公司可能是从销售开始的。或者坦率地说，因为很多公司也从 PLG（产品驱动增长）开始，你实际上可能先从市场营销开始，然后在需要销售辅助或最终转向销售主导时再加入销售层。所以，这取决于你的产品和初始目标市场，它可能意味着市场营销、销售，或者是两者的结合。

---

### [00:08:33] Lenny Rachitsky

**English:**
Awesome. Essentially it's like the term go-to-market tells you what we're talking about. How do you take your product to market, get people aware of it, using it, sticking with it?

**中文翻译:**
明白了。本质上，“进入市场”这个词本身就说明了我们在谈论什么：你如何将产品推向市场，让人们知道它、使用它并留下来。

---

### [00:08:42] Jeanne DeWitt Grosser

**English:**
Yep, absolutely.

**中文翻译:**
没错，正是如此。

---

### [00:08:44] Lenny Rachitsky

**English:**
What has most changed in the world of go-to-market over the last few years? You've done this for a long time at Google, at Stripe, you built it for sales team, now you're doing that at Vercel. What's changed most in the skill and art of go-to-market?

**中文翻译:**
在过去的几年里，GTM 领域发生的最大变化是什么？你在 Google、Stripe 工作了很长时间，建立了销售团队，现在又在 Vercel 做同样的事。在 GTM 的技能和艺术方面，什么变化最大？

---

### [00:08:55] Jeanne DeWitt Grosser

**English:**
There are a number of things. So when consumption-based business models started, I think you saw go-to-market shift into being meaningfully more consultative because often that first land was the very beginning of the journey and represented a very small percent of what you were ultimately going to do with that customer. And so you had to go from being transactional to a lot more. You had to more deeply understand what that customer was trying to do so you could align that ultimately to your product. I think that has played out that much more with an AI because right now everyone knows they need to change, but they don't necessarily know exactly what they need to change to, whether that's their customer-facing product or their internal productivity and workflows. And so I think you're seeing a lot more of go-to-market orgs leaning into the art of the possible best practices, helping you actually think things through as if they were a consultant.

**中文翻译:**
有很多变化。当“基于用量”（consumption-based）的商业模式开始流行时，GTM 转向了更具咨询性质的方向。因为通常第一次“落地”（land）只是旅程的开始，仅代表了你最终能从该客户身上获得价值的一小部分。所以你必须从“交易型”转变为更多元化的角色。你必须更深入地了解客户想要做什么，以便最终将其与你的产品对齐。我认为在 AI 时代这一点更加明显，因为现在每个人都知道他们需要改变，但他们不一定确切知道要改成什么样——无论是面向客户的产品还是内部的生产力工作流。因此，你会看到越来越多的 GTM 组织倾向于提供“最佳实践”，像顾问一样帮助客户理清思路。

---

### [00:09:52] Jeanne DeWitt Grosser

**English:**
And so one of the things you see more of right now is forward-deployed engineering, which on some level is kind of a rebrand of professional services but kind of not. And a big part of that is, hey, how do I actually get into your environment, ride alongside you better understand what you're trying to do and then help you actually bring the technology to life and learn a lot along the way. Often you're not only making that customer successful, but you're then taking all of that back to your product and engineering organization to figure out, okay, what was generalizable that we ought to build into our offering versus what is something that ultimately is going to be more of a professional service in the fullness of time. So I think that has been a biggie, is actually just really getting embedded with your customer. And then unsurprisingly, I think bringing AI to bear on the sales process is another big one. And so you've seen the rise in probably the last 18 to 24 months of the go-to-market engineer, which different folks define slightly differently, but it's kind of bringing one technical prowess to bear on go-to-market in general so you can have a lot better tooling, data use, et cetera. And then two, increasingly bringing AI to bear as well to re-architect your workflows and also make it so that it's easier to have a personalized experience with customers but do so at scale.

**中文翻译:**
所以你现在看到更多的是“前线部署工程”（forward-deployed engineering），在某种程度上它是专业服务（professional services）的品牌重塑，但又不完全是。它的核心是：我如何进入你的环境，与你并肩作战，更好地理解你的目标，然后帮助你将技术落地，并在过程中学习。通常，你不仅让客户获得了成功，还将所有这些反馈带回你的产品和工程团队，以确定哪些是通用的、应该内置到产品中的，哪些随着时间的推移更适合作为专业服务。所以，真正深入嵌入到客户中是一个大变化。另外，意料之中的是，将 AI 应用于销售流程是另一个重大变化。在过去的 18 到 24 个月里，你看到了“GTM 工程师”的崛起。不同的人定义略有不同，但它基本上是：第一，将技术实力应用于整个 GTM 流程，从而获得更好的工具、数据利用等；第二，越来越多地利用 AI 来重构工作流，并实现大规模的个性化客户体验。

---

### [00:11:23] Lenny Rachitsky

**English:**
Amazing. Okay, let's follow the thread on this go-to-market engineer, so what was it like before and what are these engineers doing at companies?

**中文翻译:**
太棒了。让我们顺着“GTM 工程师”这条线聊聊。以前是什么样的？这些工程师现在在公司里具体做些什么？

---

### [00:11:33] Jeanne DeWitt Grosser

**English:**
So I think maybe an interesting story to tell. When I was at Stripe, we went to launch an outbound SDR function. So outbound prospecting and Stripe always ran lean. The company at that time had an operating principle which was efficiency is leverage. And so if you looked at the sales organization I was running, most companies out there probably would've had 30 SDRs and I was going to get four. So there's no way I was going to do the typical SDR approach and be successful. And so we thought to ourselves, okay, what can we do? We'll be super data-driven. And so we went and we started building project Rosland. Rosland is the scientist who originally mapped A-DNA. And what this was was effectively a company universe. So you can think of this as a massive database. Every row was a different company on the planet and every column was an attribute about that company that would help you sell to them in a more targeted fashion.

**中文翻译:**
我想这有一个有趣的故事。当我在 Stripe 时，我们准备启动主动获客（outbound）的 SDR 职能。Stripe 一直运行得非常精简，当时的经营原则是“效率即杠杆”。如果你看我当时管理的销售组织，大多数公司可能会配备 30 个 SDR，而我只被分配了 4 个。所以我不可能用传统的 SDR 方法并取得成功。于是我们想，我们能做些什么？我们要极度数据驱动。于是我们开始构建“Rosland 项目”。Rosland 是最初绘制 DNA 图谱的科学家。这个项目实际上是一个“公司宇宙”：你可以把它想象成一个巨大的数据库，每一行是地球上的一个不同公司，每一列是关于该公司的属性，能帮助你更有针对性地向他们销售。

---

### [00:12:39] Jeanne DeWitt Grosser

**English:**
So at Stripe an example would be knowing that their business model was a marketplace was super helpful, because that would mean you wanted to sell Stripe Connect versus vanilla payments. And so the goal was basically, hey, can we create a mad Libs where I will come up with sort of a predefined email template, but 80% of it will be fill in the blank based on the different attributes of that customer. So if they're this industry or this business model, then pull this customer, reference this value prop, send it to this persona, not that. And we were trying to do this in 2017 and it was very hard and didn't actually totally work our ability to the false positive rate and we worked deeply with DSI and it just never really got there. And now that we're literally redoing here at Vercel as we speak and it actually works and you can bring AI to bear on it.

**中文翻译:**
在 Stripe，一个例子是：知道他们的商业模式是“平台/市场”（marketplace）非常有帮助，因为这意味着你想卖给他们 Stripe Connect 而不是普通的支付接口。我们的目标基本上是创建一个“填字游戏”式的系统：我会设计一个预定义的邮件模板，但 80% 的内容会根据客户的不同属性自动填充。如果他们属于这个行业或这种商业模式，就引用这个客户案例，提到这个价值主张，发送给这个角色而不是那个。我们在 2017 年尝试做这件事，非常困难，而且由于误报率太高，并没有完全成功。我们与数据科学团队深入合作，但始终没能达到预期。而现在，我们在 Vercel 正在重新做这件事，它真的行得通，因为你可以利用 AI。

---

### [00:13:41] Jeanne DeWitt Grosser

**English:**
And so what's different is we now, I have a data scientist just like I did back in 2017, but I have a go-to-market engineer whereas before I just had someone in systems that was helping me configure outreach or sales off and my go-to-market engineer is helping me build an agent where we're coming up with, okay, well what's the human workflow that you would've done? And then how do you encode that using Vercel workflows as an example in actual code that's both deterministic and less so where an agent's going out and trying to replicate what a human might've done to produce that, fill in the blank, matlit.

**中文翻译:**
现在的不同之处在于，我依然像 2017 年那样拥有数据科学家，但我现在有了“GTM 工程师”。以前我只有系统管理员帮我配置 Outreach 或销售软件，而现在的 GTM 工程师在帮我构建 AI 代理（Agent）。我们会梳理：人类原本的工作流是什么？然后如何使用 Vercel 工作流将其编写成代码——既包含确定性的逻辑，也包含非确定性的逻辑，让 Agent 去尝试复制人类为了完成那个“填字模板”所做的操作。

---

### [00:14:21] Lenny Rachitsky

**English:**
I love the ambition of that project. What is this, like eight years ago?

**中文翻译:**
我喜欢这个项目的雄心。这是多久以前的事？大约八年前？

---

### [00:14:25] Jeanne DeWitt Grosser

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:14:26] Lenny Rachitsky

**English:**
I love the big thinking there. We're going to map the entire universe of companies and then here's how we sell to them. And then just I'm trying to picture doing that without AI. It's like crazy to imagine trying that without AI and that's so much simpler to even imagine.

**中文翻译:**
我喜欢这种宏大的思考方式：我们要绘制整个公司宇宙的图谱，然后确定如何向他们销售。我试着想象在没有 AI 的情况下做这件事，那简直太疯狂了，而有了 AI，这件事变得容易想象得多。

---

### [00:14:38] Jeanne DeWitt Grosser

**English:**
Well the thing that's amazing about that, just to geek out on a second, so I was working on that with a bunch of folks at Stripe on my team, obviously at a gentleman named Ben Salzman who went on to go to ZoomInfo and then actually recently just founded a go-to-market startup that is basically sort of productizing that concept of a company universe and then layering AI on it on top of it. And ultimately his view is actually AI will get to the point that you won't have to do outbound prospecting because it will just sort of company and product match. So it's fun to sort of see back in 2017 some of the folks doing that now work at OpenAI, they work at Anthropic, they also are doing GTM Eng. You've got him starting a totally AI native GTM company and then here I'm at Vercel trying to do the same.

**中文翻译:**
关于这一点最神奇的是（让我稍微极客一下），当时我在 Stripe 和团队里的一群人一起做这个，其中一位叫 Ben Salzman 的绅士后来去了 ZoomInfo，最近刚创办了一家 GTM 初创公司，基本上就是把“公司宇宙”的概念产品化，并在上面叠加 AI。他的最终观点是，AI 将发展到你根本不需要进行主动获客的程度，因为它会自动完成公司和产品的匹配。很有趣的是，2017 年参与那个项目的一些人现在在 OpenAI 或 Anthropic 工作，他们也在做 GTM 工程。Ben 创办了一家完全 AI 原生的 GTM 公司，而我在 Vercel 也在尝试做同样的事情。

---

### [00:15:29] Lenny Rachitsky

**English:**
Okay, so what's cool is this is an emerging role, an emerging skill that I don't think a lot of people have recognized as something that is happening. So one example I'm hearing of what this role does is they automate outbound emails essentially and outbound outreach. They figure out, they write workflows and agents that figure out here's the company to go after, here's how we message them. Does that end up being kind of like an email that's custom designed and written for this prospect?

**中文翻译:**
这很酷，这是一个新兴的角色和技能，我觉得很多人还没意识到它的存在。我听到的一个例子是，这个角色本质上是在自动化主动获客邮件和外联。他们编写工作流和 Agent 来确定该找哪家公司、如何给他们发信息。这最终会变成一封为该潜在客户定制编写的邮件吗？

---

### [00:15:54] Jeanne DeWitt Grosser

**English:**
That's one version. So it's broader than that really. Basically the full remit of GTM Eng will be to go through each of the different functions within go to market and break down all the different workflows that they do and then turn those into agents where AI is better placed than the human to do that task. So right now we started with actually inbound and are now moving to outbound because that workflow is most legible. And by legible I mean you can basically write it down. It's relatively replicable, mostly deterministic. So it's more likely that AI will do it well and we actually built the agent and then we keep a human in the loop. But from there we're starting to look at outbound and with an outbound we're starting more at the lower end of the market, where you tend to have slightly less customization because there's a single decision maker at the company.

**中文翻译:**
那只是其中一个版本。实际上它的范围更广。基本上，GTM 工程的全部职责是梳理 GTM 内部的每个不同职能，分解他们所做的所有不同工作流，然后将那些 AI 比人类更擅长的任务转化为 Agent。目前我们是从“被动咨询”（inbound）开始的，现在正转向“主动获客”（outbound），因为这个工作流最清晰。所谓清晰，是指你基本上可以把它写下来，它相对可复制，大部分是确定性的。所以 AI 更有可能做得好。我们构建了 Agent，并保持“人工在环”（human in the loop）。从那里开始，我们开始研究主动获客，并从市场低端开始，因为那里的定制化程度较低，公司通常只有一个决策者。

---

### [00:16:56] Jeanne DeWitt Grosser

**English:**
But I think it'll take a while before we're able to really do that in a very large enterprise. There we might use an agent for research but maybe not all the way to actually send a message and that's just within the prospecting function. So other places that we're looking at this would be for install-based sales. So again there it's a little bit more deterministic because you've got awesome internal data on what a customer is and isn't using, what's the next best action? What's the thing they should get most value from? So that's where we're starting to map, hey, what does that ideal workflow look like? But basically you want to get to a state where as long as I've been in sales, they release these annual reports that help us all benchmark ourselves relative to one another. And one of the stats is what percent of time do your sellers actually spend in front of customers?

**中文翻译:**
但我认为，要在大型企业中真正实现这一点还需要一段时间。在大型企业中，我们可能会使用 Agent 进行研究，但可能不会让它直接发送信息。这还仅仅是在获客职能内部。我们还在研究其他应用场景，比如针对现有客户的销售（install-base sales）。同样，这更具确定性，因为你有很棒的内部数据，知道客户在使用什么、没在使用什么，下一步最佳行动是什么，他们最能从什么中获益。所以我们开始规划理想的工作流。基本上，你希望达到这样一种状态：在我从事销售的这些年里，每年都会有报告帮我们做行业基准对比。其中一个统计数据是：你的销售人员实际花在客户面前的时间百分比是多少？

---

### [00:17:44] Jeanne DeWitt Grosser

**English:**
And for the 20 years I've been in sales, it's always been somewhere around 30% to 40%. So the minority of time is actually talking to other humans and I think we're getting to a point where with layering in agents, ideally we finally get salespeople to a point where they're actually spending 70% of their time interacting with humans and we can get the research, the follow-up, the things that are a little bit more rote and don't use the entirety of your human capacity done by an agent and then sort of unleash you to go deeper with your customers.

**中文翻译:**
在我从事销售的 20 年里，这个数字一直维持在 30% 到 40% 左右。也就是说，只有少数时间是在真正与人交谈。我认为我们正在进入一个新阶段：通过引入 Agent，理想情况下，我们终于能让销售人员将 70% 的时间花在与人互动上。我们可以让 Agent 完成研究、跟进等那些机械的、不需要发挥全部人类能力的事务，从而释放销售人员，让他们与客户进行更深层次的交流。

---

### [00:18:17] Lenny Rachitsky

**English:**
I love that this is such a great example of where AI is contributing in a very meaningful high ROI way, taking on all this work that people... like, you have to hire say 50 SDRs as you described to do and now you could do with a lot more. So it's a really cool example of leverage that AI gives you. One thing that I know a lot of people think about when they hear this is, okay, I'm going to get more of these really bad emails trying to pitch me on stuff and just like this isn't going to work. I can tell this is AI. What have you learned about how to do this where people actually receive emails that actually convert and do well?

**中文翻译:**
我喜欢这个例子，它展示了 AI 如何以非常有意义、高投资回报率（ROI）的方式做出贡献，承担了那些原本需要雇佣 50 个 SDR 才能完成的工作。这是 AI 赋予杠杆作用的一个很酷的例子。但我知道很多人听到这个会想：“天哪，我又要收到更多那种烂透了的推销邮件了，这行不通的，我一眼就能看出是 AI 写的。”关于如何让人们收到的邮件真正实现转化并取得好效果，你学到了什么？

---

### [00:18:51] Jeanne DeWitt Grosser

**English:**
Our processes all always have human in the loop. And so basically where we'll start is we take a go to market engineer and we have them shadow the highest performing individual in that function. And so you can go and you shadow an SDR and you can see, oh wow, they've got seven tabs open. They're looking up the person on LinkedIn, they're reading about the company, they're doing chatGPT on this, they're looking in this database to get these sets of attributes. And so that's how you sort of inform the initial workflow. And then what we do is we let the agent make a call. So in the specific example with inbound, you have to determine whether or not you think the lead is likely to be qualified and then you have to determine what to say to it. And so we'll let the agent make those two calls.

**中文翻译:**
我们的流程始终保持“人工在环”。基本上，我们的起点是让一名 GTM 工程师去“影子观察”（shadow）该职能中表现最出色的人。你可以去观察一个 SDR，你会发现：哇，他们开了 7 个标签页，在 LinkedIn 上查人，阅读公司资料，用 ChatGPT 辅助，在数据库里查找属性。这就是你构建初始工作流的方式。然后，我们让 Agent 做出判断。在被动咨询的例子中，你必须判断这个线索（Lead）是否合格，然后决定对他们说什么。我们会让 Agent 做出这两个判断。

---

### [00:19:44] Jeanne DeWitt Grosser

**English:**
It ultimately then does some deep research, pulls in a bunch of information from our databases and crafts a response, but we have a human review all of those and actually hit send. Now for us, we had 10 SDRs doing this inbound workflow and now we just have one that is effectively QA-ing the agent. The other nine we deployed on outbound, so we got to move them up the value chain. At some point I think we'll get to a place where we feel like, "Hey, the human reviewer is saying yes enough of the time that we feel confident that these will be on brand targeted, et cetera," but right now we're still trying to train the agent and it incorporates feedback on what we choose to reject, edit, et cetera.

**中文翻译:**
Agent 最终会进行深入研究，从我们的数据库中提取大量信息并撰写回复，但我们会让人类审核所有这些内容并点击发送。对我们来说，以前有 10 个 SDR 在做这个被动咨询工作流，现在我们只需要 1 个来负责 Agent 的质量保证（QA）。另外 9 个人被我们部署到了主动获客上，这样我们就把他们推向了价值链的上游。我认为在某个时刻，我们会达到这样一个阶段：人类审核员通过的比例足够高，让我们有信心这些内容符合品牌调性且精准。但目前我们仍在训练 Agent，它会吸收我们拒绝或修改的反馈。

---

### [00:20:31] Lenny Rachitsky

**English:**
And you shared that it's already having a lot of impact. Like you said, you had 10 SDRs and now one can do the job of 10.

**中文翻译:**
你提到这已经产生了巨大的影响。就像你说的，以前需要 10 个 SDR，现在 1 个人就能完成 10 个人的工作。

---

### [00:20:39] Jeanne DeWitt Grosser

**English:**
So before we did that move, I mean the other thing that's just incredible about this is the person who built the lead agent was a single GTM engineer. He spent maybe 25-30% of his time on this. It was six weeks before we felt confident going from 10 to one. So it wasn't like this was a multi-quarter process, it actually moved super quickly and then again now we just sort of keep that agent manager working with the agent to get it to a point where we say, "Hey, we're ready to roll." Actually throughout the process we also tracked all of the KPIs that you typically would hold an SDR accountable to. We were looking at our lead to opportunity conversion rate, we're looking at the number of touches it takes the time to convert, and basically what we were able to do is hold that lead to opportunity conversion rate flat. So the agent is as good as our humans were, but it's actually condensed the number of touches it takes to convert because it's so much quicker at responding relative to leads inevitably sitting in the queue or coming in at nighttime and no one can get to it, that type of deal. So that's sort of when we knew it was ready to pull nine people off and shift them into outbound.

**中文翻译:**
在我们做出这个调整之前，还有一件事非常不可思议：构建这个“线索 Agent”的只有一名 GTM 工程师，他大概只花了 25-30% 的时间。只用了六周，我们就有了从 10 个人减到 1 个人的信心。所以这并不是一个耗时数个季度的过程，它进展得非常快。现在我们让那名 Agent 经理继续与 Agent 磨合，直到我们可以说“准备好全面铺开了”。实际上，在整个过程中，我们也追踪了所有通常用来考核 SDR 的关键绩效指标（KPI）。我们观察了线索到机会（Lead to Opportunity）的转化率，以及转化所需的触达次数。基本上，我们能够保持转化率持平。也就是说，Agent 做得和人类一样好，但它实际上缩短了转化所需的触达次数，因为它响应速度极快，不像以前线索可能会在队列里积压，或者半夜进来没人处理。这就是我们确定可以抽调 9 个人去转做主动获客的时机。

---

### [00:21:56] Lenny Rachitsky

**English:**
That's incredible. Okay, that's interesting. So you shift them to outbound. What I love about this is this SDR that is now doing this is, as you said, doing the things they enjoy more, they're talking to customers more, they're not doing all this kind of top of funnel rote work. I don't want to get into whole jobs AI discussion, but there's always been this talk about AI SDRs basically replacing SDRs. It feels like that's one thing where everyone's like this is a hundred percent going to be AI in the future. What I'm hearing here is it gives one Aster a lot more leverage and obviously you still need people running the show. Thoughts there? Just like do you think AI will replace all this at some point? And then I don't know, you don't need salespeople?

**中文翻译:**
太不可思议了。你把他们转到了主动获客。我喜欢的一点是，正如你所说，这些 SDR 现在在做他们更喜欢的事情，更多地与客户交谈，而不是做漏斗顶端的机械工作。我不想陷入关于 AI 取代工作的讨论，但一直有人说 AI SDR 最终会完全取代人类 SDR。听起来你的做法是给了一个 SDR 巨大的杠杆，当然你仍然需要人来掌控大局。你觉得 AI 最终会完全取代这些吗？以后我们就不需要销售人员了吗？

---

### [00:22:32] Jeanne DeWitt Grosser

**English:**
I think on prospecting it can replace a fair amount because the average SDR wasn't doing overly sophisticated research in the first place. So where I, think the last part to go as I mentioned will be in deep enterprise prospecting where you can be at multiple layers in an org chart, you've got to pick between business lines, you've got to triangulate those. But I do think for the things that are more repetitive that often don't take that much time to learn and get ramped, AI will be good at that. And in my view, no one graduated from college and was like, "Yes, I just went to college for four years to become an SDR." It was more, "Okay, that's where you are forced to start." But I think the average SDR could have gone straight into outbound or straight into an SMB closing role. And so basically what we're just doing is shifting folks into something that uses more of their full capacity right out of the gates rather than sort of the forcing function of working your way up the totem pole.

**中文翻译:**
我认为在获客（prospecting）方面，它可以取代相当一部分工作，因为普通的 SDR 本来也就没做多么复杂的研究。正如我提到的，最后剩下的堡垒将是深度的企业级获客，你需要处理复杂的组织架构、在不同业务线之间选择并进行三角定位。但我确实认为，对于那些重复性的、不需要太多时间学习和上手的任务，AI 会非常擅长。在我看来，没有人大学毕业时的梦想是“耶，我读了四年大学就是为了当个 SDR”。那更像是一个“你被迫开始的地方”。但我认为普通的 SDR 其实可以直接去做主动获客或者中小企业（SMB）的成交角色。所以我们现在做的，只是让人们从一开始就发挥出更大的潜力，而不是被迫在职业阶梯的最底层磨洋工。

---

### [00:23:48] Lenny Rachitsky

**English:**
Awesome. Since a lot of people listening to this aren't salespeople don't have a lot of background in sales, we've used this term SDR, there's also the term AE. Can you just help people understand what is an SDR, what do they do, what's an AE, and then what's the role above?

**中文翻译:**
太棒了。因为很多听众不是销售出身，我们提到了 SDR，还有 AE。你能帮大家解释一下什么是 SDR，他们做什么？什么是 AE？以及更高级别的角色是什么？

---

### [00:24:01] Jeanne DeWitt Grosser

**English:**
Sure. So SDR is typically in charge of generating pipeline. They're meant to talk to prospective customers and get them to a point where it is worth investing time to run them through a sales process. You typically have two types of an SDR, have an inbound one. So this is where people come to your website, they fill out contact sales, they'll be the first call to make sure that it's actually worth a more expensive account executive to go and run a sales process or you then have outbound. So this is where when you want to grow faster than your inbound demand, they will go out and at this point you probably have a point of view on where you think you have product market fit. And so they will target that part of the market and try to drum up interest from folks who weren't otherwise raising their hand saying, I'd like to talk to you.

**中文翻译:**
当然。SDR（销售开发代表）通常负责生成“销售漏斗”（pipeline）。他们的任务是与潜在客户交谈，并将他们引导至值得投入时间进入正式销售流程的阶段。通常有两种 SDR：一种是“被动咨询型”（inbound），即人们来到你的网站填写“联系销售”表格，SDR 进行第一次通话，确认是否值得让更昂贵的客户经理（AE）介入；另一种是“主动获客型”（outbound），当你希望增长速度超过被动需求时，他们会主动出击。此时你可能已经对“产品市场匹配”（PMF）有了看法，他们会针对那部分市场，去激发那些原本没打算找你的人的兴趣。

---

### [00:24:54] Jeanne DeWitt Grosser

**English:**
So that's sales development basically. Pipeline generation account executives are closers. So it's their job to take somebody from, "Okay, hey, I'm interested in learning about your solution, I have a legitimate problem. I potentially could make a decision," to, "I now believe that your product is the best in the market for me and I'm willing to pay for it." And then account executives, depending on the segments that your company sells into E.G. small business, mid-market enterprise, et cetera, they may work their way up the food chain from selling to a smaller company like an SMB or a startup. Those tend to be a little bit more of a transactional sale. You often have a single decision maker to then going into a mid-market or a commercial role where now maybe you have an economic buyer like somebody in finance and a technical buyer like somebody in engineering to getting into enterprise where you have procurement and you have committees and 10 people have to weigh in and you've got to help them figure out how to de-risk the fact that they're probably migrating from something so much more complicated coordination effort to sell.

**中文翻译:**
所以 SDR 基本上就是做销售开发和漏斗生成。而 AE（客户经理）是“成交者”（closers）。他们的工作是把客户从“我对你的方案感兴趣，我有实际问题，我可能会做决定”带向“我相信你的产品是市场上最适合我的，我愿意为此付钱”。AE 会根据公司销售的市场细分（如中小企业、中型市场、大型企业等）在职业链条上晋升。向中小企业或初创公司销售通常是“交易型”的，往往只有一个决策者。然后进入中型市场，你可能需要面对财务部门的“经济买家”和工程部门的“技术买家”。最后进入大型企业，你会遇到采购部、委员会，需要 10 个人共同参与决策，你还得帮他们降低迁移风险，因为他们通常是从非常复杂的东西迁移过来的。这需要极强的协调能力。

---

### [00:26:05] Lenny Rachitsky

**English:**
That was extremely helpful. So SDR, pipeline generation, i.e., closer. Such a simple way of thinking about it. Okay, this is great. Going back to the GDM engineer, a few questions for people that may want to try this at their company, what scale do you think it makes sense to start hiring for this role? Having someone automate in the go-to-market process?

**中文翻译:**
非常有帮助。SDR 负责生成漏斗，AE 负责成交。非常简洁的理解方式。回到 GTM 工程师的话题，对于想在自己公司尝试的人来说，你认为在什么规模开始招聘这个角色比较合适？即找人来自动化 GTM 流程。

---

### [00:26:25] Jeanne DeWitt Grosser

**English:**
What's interesting about this is it will force companies to be more rigorous about their sales process early. So often startups when they go from founder led sales to say, I'm going to have my first sales person, whether that's an actual account executive who has sales experience or your general athlete, wicked smart, who's going to go figure it out. Often founders will just say, "Okay, sales is showing up and talking to people. Isn't that what I just did for the last couple of years?" But actually sales is more than that. It's a skill just like writing code as a skill or building a financial model as a skill, it's about discovery. So asking all the right questions that help you identify challenges in pain, willingness to pay, et cetera, and then going through a process to handle those objections and showcase where are you at enough value such that somebody ultimately wants to hand over some money.

**中文翻译:**
有趣的是，这将迫使公司尽早对销售流程保持严谨。初创公司从“创始人主导销售”转向雇佣第一个销售人员时（无论是有经验的 AE 还是一个绝顶聪明的全能型选手），创始人往往会觉得：“销售不就是露个面跟人聊天吗？我过去几年不就是这么干的吗？”但实际上销售远不止于此。它是一项技能，就像写代码或建立财务模型一样。它关乎“需求挖掘”（discovery）：通过提问来识别痛点、挑战、付费意愿等，然后通过处理异议的流程，展示你提供的价值，最终让对方愿意掏钱。

---

### [00:27:24] Jeanne DeWitt Grosser

**English:**
So often startups will get, particularly ones with strong product market fit to pretty significant scale without really having a replicable process. And you can't really apply go to market engineering unless you actually have a point of view on what best practice should look like. And so I think basically this is going to force folks to have more of a playbook out of the gates, what's working, what's not? Can I document it? Do I have content for the different parts of the sales process? And then once you do that, which maybe 10 people is a good size and scale for that, ostensibly a GTM engineer can come in and turn that into an agent. You could also argue that if you're a founder who wants to bring in a general athlete profile and that person is technically minded, that you could have a hybrid AE GTM engineer who figures out what their best practice is and then tries to turn that into an agent that's riding alongside them and making them more effective as well.

**中文翻译:**
很多初创公司，尤其是那些 PMF 很强的公司，在没有可复制流程的情况下也能达到相当大的规模。但除非你对“最佳实践”有明确的看法，否则你无法应用 GTM 工程。所以，这会迫使人们从一开始就建立“剧本”（playbook）：什么有效，什么无效？我能把它记录下来吗？销售流程的不同阶段是否有对应的内容？一旦你做到了这一点（大概团队规模到 10 个人左右），GTM 工程师就可以介入并将其转化为 Agent。你也可以认为，如果你是一个想招募全能型人才的创始人，且那个人很有技术头脑，你可以招一个“混合型 AE/GTM 工程师”，让他摸索出最佳实践，然后尝试将其转化为辅助自己的 Agent，从而提高效率。

---

### [00:28:26] Jeanne DeWitt Grosser

**English:**
So I don't know that I have a point of view yet on what's the optimal size and scale, but I forever have given founders the advice that you often want to bring in revenue operations, which is basically the analytical arm of sales earlier than you think because having data, having process is actually what gives you insights as a founder into what is and isn't working. And so I would argue just like it's a good idea to have that sooner than later, increasingly it'll probably be a good idea to have GTM engine and be looking to bring agents to bear on your process at the outset.

**中文翻译:**
所以我还不确定最佳规模是多少，但我一直给创始人的建议是：你应该比预想中更早地引入“营收运营”（Revenue Operations，简称 RevOps），它基本上是销售的分析部门。因为拥有数据和流程，才能让你作为创始人洞察到什么有效、什么无效。因此我认为，就像早点建立 RevOps 是个好主意一样，尽早拥有 GTM 工程并尝试将 Agent 应用于流程中，可能也会成为一种趋势。

---

### [00:29:05] Lenny Rachitsky

**English:**
While we're on this topic, just a quick tangent, the advice for hiring your first salesperson that I usually hear is wait until you're around a million in ARR. When you have a repeatable process, you can teach someone anything there. Does that seem right? What would you recommend?

**中文翻译:**
顺便问一下，我通常听到的关于雇佣第一个销售人员的建议是：等到年度经常性收入（ARR）达到 100 万美元左右。当你有了可重复的流程，你就可以教给别人。这听起来对吗？你的建议是什么？

---

### [00:29:18] Jeanne DeWitt Grosser

**English:**
Yeah, I think that seems about right. I do think as a founder you want to stay deeply connected to customers and get it to a scale and get it to a point where you use the word, there's some repeatability there. I think that's one of the things that not all founders get right is founders are incredible salespeople. They convinced a VC angel investors to fork over a bunch of money, so clearly they're going to inspire people to buy. But if you're getting to a million in ARR and the set of customers you have look nothing like one another, you still have very much like an evangelist sale, very much founder led sale versus if you can say, "Hey, I now have an ICP here, or ideal customer profile, e.g something you can write down. We are good. Our product fits with startups with less than a hundred employees who are typically building SaaS applications," something like that.

**中文翻译:**
是的，我觉得差不多。我认为作为创始人，你需要与客户保持深度联系，直到达到一定规模并具备“可重复性”。并非所有创始人都能处理好这一点：创始人通常是天才销售，他们能说服风投和天使投资人掏钱，显然也能激励客户购买。但如果你的 ARR 到了 100 万美元，而你的客户群彼此之间毫无共同点，那你做的仍然是“布道式销售”或“创始人主导销售”。反之，如果你能说：“嘿，我现在有了理想客户画像（ICP），比如我们的产品适合员工少于 100 人、正在构建 SaaS 应用的初创公司。”

---

### [00:30:14] Jeanne DeWitt Grosser

**English:**
Then you're probably ready to hand over the reins. And then what founders have to remember is to actually hand over the reins. So you've got to enable the person who comes in, what is it that you're doing effectively, what's your content, what are the discovery questions you are asking? How are you handling objections so you can transition that knowledge but also don't handle them over entirely. You want to stay connected to the customer because you still have a fair amount of R&D to do to figure out where is the product next going to resonate, where are you getting stock as you scale, etc.

**中文翻译:**
到那时，你可能就准备好交出接力棒了。创始人必须记住的是：要“真正”交出接力棒。你需要赋能新加入的人：你做了什么才见效？你的内容是什么？你问了哪些挖掘需求的问题？你如何处理异议？你需要转移这些知识，但也不要完全撒手不管。你仍需与客户保持联系，因为你还有大量的研发工作要做，去弄清楚产品下一步会在哪里产生共鸣，以及在规模化过程中哪里会遇到阻碍。

---

### [00:30:52] Lenny Rachitsky

**English:**
To close the loop on the go-to-market engineer, what's the profile of the ideal go-to-market engineer, may be your first.

**中文翻译:**
为了结束关于 GTM 工程师的话题，理想的第一个 GTM 工程师应该是什么样的背景？

---

### [00:30:57] Jeanne DeWitt Grosser

**English:**
What we have found works really well is somebody who does have go-to-market experience. So at Vercel, our first three go-to-market engineers we're actually sales engineers. So Vercel hires very technical sales engineers, all of them were front end developers before they decided they wanted to get into sales. And so we just said, "Hey, three of you, congrats." You're now founding members of our GTM Eng team. And the thing that works well there is you do understand aspects of what is good GTM, what does a process look like? It's been really interesting actually. So the gentleman who runs GTM Eng for me, we were going through this lead agent and QA-ing it. And so I'm going and I'm looking at some of the responses that we've ultimately had the lead agent send and realized, "Oh, I wouldn't have sent that and that's because I have 20 years of sales experience and we modeled the lead agent off our best person, but our best person who has two years of sales experience." So it actually is important to understand the art and the science of sales and how you bring best practice to bear. Either you've done it and so you know some best practice or you're going to geek out on sales, read a bunch of books, learn a thing or two, and try to incorporate some of those into your agent development.

**中文翻译:**
我们发现效果最好的是那些确实有 GTM 经验的人。在 Vercel，我们的前三个 GTM 工程师实际上是销售工程师（SE）。Vercel 雇佣的技术销售工程师非常专业，他们在转行销售之前都是前端开发人员。所以我们直接说：“嘿，恭喜你们三位，你们现在是 GTM 工程团队的创始成员了。”这种背景的好处是，你理解什么是好的 GTM，流程是什么样的。这其实非常有趣：负责 GTM 工程的那位同事和我一起审核线索 Agent 的回复时，我发现有些回复我绝对不会发。这是因为我有 20 年的销售经验，而我们的 Agent 是模仿我们最优秀的员工建模的，但那位最优秀的员工只有 2 年销售经验。所以，理解销售的艺术和科学，并引入最佳实践是非常重要的。要么你亲身经历过，要么你就得钻研销售，读大量的书，学一两招，并尝试将其融入到 Agent 的开发中。

---

### [00:32:28] Lenny Rachitsky

**English:**
That is really interesting. So come from the sales side, not from the engineering side. And I imagine this is such a cool opportunity for salespeople to do something completely different and move closer to engineering.

**中文翻译:**
这很有趣。所以是来自销售端，而不是纯工程端。我想这对销售人员来说是一个很酷的机会，可以做一些完全不同的事情，向工程端靠拢。

---

### [00:32:38] Jeanne DeWitt Grosser

**English:**
Yeah, I mean we're having a lot of fun with it. At Vercel in particular, we basically get to be customer zero. So everything that we're building with agents, we're building on Vercel's AI cloud. So these agents now have multiple steps that they go through. So we're using Vercel's workflow SDK and workflow offering. We use the AI gateway to call the different models that we use to do deep research or other enrichment that we do. So for us it's great because we basically sort of bang on everything the engineering team is building and get to go be a discerning customer before we actually get it out the door to real customers.

**中文翻译:**
是的，我们玩得很开心。特别是在 Vercel，我们基本上就是“零号客户”。我们构建的所有 Agent 都是基于 Vercel 的 AI 云。这些 Agent 有多个执行步骤，所以我们使用了 Vercel 的工作流 SDK。我们使用 AI 网关（AI Gateway）来调用不同的模型进行深度研究或数据增强。对我们来说这太棒了，因为我们可以在产品正式发布给真实客户之前，先作为挑剔的内部客户去“折腾”工程团队构建的一切。

---

### [00:33:22] Lenny Rachitsky

**English:**
What a fun time to be alive. I could tell the fun that you guys are having, just from the way you describe it. (Sponsorship segment for Stripe...) Zooming out a little bit in terms of you mentioned tools and tools that you use. I'm curious just what are kind of the state of the art tools within the go-to-market stack that you love that you'd recommend?

**中文翻译:**
真是个有趣的时代。从你的描述中我就能感受到你们有多开心。（Stripe 广告段落略过...）稍微放大一点视野，你提到了工具。我很想知道，在目前的 GTM 工具栈中，有哪些你喜欢并推荐的顶尖工具？

---

### [00:34:33] Jeanne DeWitt Grosser

**English:**
Well, so I'm going to have an interesting answer to this, so I'll give you one. And it's not state-of-the-art per se, although I don't mean that disparagingly, it's just that it's been around for a while now and a lot of folks use it, but I think Gong has gotten just meaningfully more interesting in the last year. And then second half of my question I will get into, I think the calculus on build versus buy is changing. So all right, Gong. Gong is incredible because you can run agents against it now. So we take all of our Gong transcripts and we dump them into an agent called the deal-bott, and that deal-bott then can do a bunch of things. So the first thing we had it do was lost opportunity review. So we had just finished Q2, we had a list of our top losses for the quarter sorted by deal size, and we ran it against that and it was incredibly interesting.

**中文翻译:**
我的答案可能比较有趣。我先说一个，它本身不算是“最新款”（我没有贬低的意思），它已经存在一段时间了，很多人都在用，但我认为 Gong 在过去一年里变得非常有意思。我答案的后半部分会涉及到“自建还是购买”的权衡正在发生变化。好，先说 Gong。Gong 非常棒，因为你现在可以在它上面运行 Agent。我们将所有的 Gong 通话转录文本导入一个叫“Deal-bot”的 Agent，它可以做很多事。我们让它做的第一件事是“丢单复盘”。我们刚结束第二季度，列出了按金额排序的丢单列表，让 Agent 去分析，结果非常有趣。

---

### [00:35:39] Jeanne DeWitt Grosser

**English:**
So the biggest loss that quarter according to the account executive was lost on price. And when you ran the agent over every Slack interaction, every email, every GONG call, it said actually you lost because you never really got in touch with an economic buyer. And when you talked to somebody about ROI and total cost of ownership, it was clear from their reaction that they didn't really buy your mass. And so really the reason we lost was an inability to demonstrate value, which upon reflection I've got work to do to build out how we quantify the value of Vercel, which actually is very easily quantifiable. It's one of the things I love about selling this product, but we got to codify that for the go-to-market team. So that was incredibly interesting and now we run it against all of our lost opportunities and actually do a much better job of categorizing why it was we really, really lost.

**中文翻译:**
根据客户经理（AE）的说法，那个季度最大的丢单是因为价格。但当 Agent 扫描了所有的 Slack 互动、邮件和 Gong 通话记录后，它说：实际上你丢单是因为你从未真正接触到“经济买家”（决策者）。当你和对方谈论投资回报率（ROI）和总拥有成本（TCO）时，从对方的反应来看，他们根本不买账。所以真正的丢单原因是无法证明价值。反思之后，我意识到我需要完善如何量化 Vercel 的价值——其实这很容易量化，这也是我喜欢销售这款产品的原因之一，但我们需要为 GTM 团队将其规范化。这非常有趣，现在我们对所有丢单都运行这个分析，从而能更准确地归类我们到底为什么丢单。

---

### [00:36:38] Jeanne DeWitt Grosser

**English:**
And then either feeding that back into the engineering team or back into marketing sales leadership on, hey, where are we falling short in the sales process? And so that was awesome, but then we're like, well, it's not very fun to lose, so why don't we pull that forward? And so we went from lost bot to deal-bott and now the deal-bott is running in real time and we basically feed insights into Slack. Vercel is incredibly heavy users of Slack, so we have a channel for every single customer, either opportunity or existing one. And so now we're feeding insights into that Slack channel which is, "Hey, you're this far into the sales process and you haven't talked to an economic buyer, you should think about that." Or, "Hey, you just got off that call with an economic buyer, didn't sound like it went that well. Here's some things to consider and how you might follow-up."

**中文翻译:**
然后我们会把这些反馈给工程团队，或者反馈给市场销售领导层：我们在销售流程的哪个环节做得不够？这太棒了。但后来我们想，输了再分析没意思，为什么不提前呢？于是我们从“丢单机器人”升级到了“成交机器人”（Deal-bot）。现在 Deal-bot 是实时运行的，它会将洞察直接推送到 Slack。Vercel 是 Slack 的重度用户，我们为每个客户（无论是潜在机会还是现有客户）都建了频道。现在我们会把洞察发到频道里，比如：“嘿，销售流程已经到这一步了，你还没跟经济买家聊过，你得考虑一下。”或者：“嘿，你刚跟经济买家通完话，听起来效果不太好，这里有一些建议供你参考，看看如何跟进。”

---

### [00:37:34] Jeanne DeWitt Grosser

**English:**
And last thing before I pause, the other thing that's really interesting and how we're using this too is we are in this moment where I have never seen an iteration velocity exists now in my career. My 20 plus year career has all been in tech. And so for go-to-market teams, that's really hard. If you are launching something every other day, the ability to be enabled on that is actually quite challenging. And so this bot agent is now also letting us, where we're starting to go with it is we'll release something, we'll do our best to enable the team, then we'll go run the agent across calls, interactions, and we'll diagnose where we did a bad job of objection handling, where we're getting stuck. And then at the end of the week we can have a huddle and say, okay, what are all the places that our agent would suggest we aren't selling effectively?

**中文翻译:**
在我停顿之前再说最后一点，另一个非常有趣的用法是：在我 20 多年的科技职业生涯中，我从未见过像现在这样快的迭代速度。对于 GTM 团队来说，这非常困难。如果你每隔一天就发布新东西，团队的赋能（enablement）挑战极大。所以这个机器人 Agent 现在也在帮我们：我们发布新功能，尽力培训团队，然后让 Agent 扫描通话和互动记录，诊断我们在处理异议时哪里做得不好，或者在哪里卡住了。周末我们可以开个简会说：根据 Agent 的建议，我们在哪些地方销售得不够有效？

---

### [00:38:34] Jeanne DeWitt Grosser

**English:**
And then almost like an engineering team, we'll now run sprints, which is like those are just bugs. They're bugs in your go-to-market process, so you should not have them. And by the next week we're going to add content to our objection handling to guide. We're going to add content to a discovery guide, we're going to figure out something we need to change about our demo, so on and so forth. So that's early. That a little bit of a preview, but that's where we're talking about taking things right now within our go-to-market orgs.

**中文翻译:**
然后就像工程团队一样，我们会进行“冲刺”（sprints）。这些销售中的失误就像是“Bug”——它们是 GTM 流程中的 Bug，不应该存在。到下周，我们会更新异议处理指南，更新需求挖掘指南，或者修改演示（demo）流程等等。这还处于早期阶段，算是一个预告，但这就是我们目前在 GTM 组织中推进的方向。

---

### [00:39:00] Lenny Rachitsky

**English:**
Jeanne, you're blowing my mind in so many ways, it just sounds so fun and just you guys are going to win is what I'm feeling when I hear all this. Incredible. What I love about this is this AI tool, this agent you built sees things that humans were not seeing. The fact that you were surprised of just like this is a completely different conclusion is such a big deal. This is the whole promise of ai, it's going to do things we aren't even thinking about or capable of.

**中文翻译:**
Jeanne，你真的让我大开眼界。听起来太有趣了，我觉得你们一定会赢。我最喜欢的一点是，你构建的这个 AI Agent 能看到人类看不到的东西。你对那个完全不同的结论感到惊讶，这非常有意义。这就是 AI 的承诺：它能做我们甚至没想过或没能力做的事情。

---

### [00:39:26] Jeanne DeWitt Grosser

**English:**
It is. We had a really interesting, one of the things we're doing at Vercel, we have an AI cloud, so people use that to put AI-native features into their customer-facing applications, but they're also using it to build internal applications to improve productivity or outcomes. And we are talking to a very large airline and that airline obviously gets tons and tons of support queries. Of course they would want to go apply AI to hey, how can we have AI answer these so that our cost to support goes down, sort of the obvious thing. But the more interesting conversation was actually with one of the C-level executives who said, we also actually transcribe every single one of those support calls. And so what I really want to know is why are they calling and how do I make it so that fewer people call the next week?

**中文翻译:**
确实如此。我们在 Vercel 做的一件事是提供 AI 云，人们用它在面向客户的应用中加入 AI 原生功能，但也用它构建内部应用来提高生产力。我们曾与一家大型航空公司交谈，他们显然有海量的客服咨询。他们当然想用 AI 来回答问题，从而降低支持成本，这是显而易见的。但更有趣的对话是与一位 C 级高管进行的，他说：“我们实际上转录了每一次客服通话。我真正想知道的是，他们‘为什么’打电话？我该如何做才能让下周打电话的人变少？”

---

### [00:40:39] Lenny Rachitsky

**English:**
I imagine many people hearing this are like, "I need one of these deal-botts and lost bots." These are all internal products that you all built?

**中文翻译:**
我想很多人听到这里都会想：“我也需要一个 Deal-bot 或丢单机器人。”这些都是你们自己开发的内部产品吗？

---

### [00:40:46] Jeanne DeWitt Grosser

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:40:47] Lenny Rachitsky

**English:**
Is there anything that you've learned about making them this good? Any tips you can share of here's how to make a really good bot for sales?

**中文翻译:**
关于如何把它们做得这么好，你有什么心得吗？有没有什么秘诀可以分享，教大家如何做一个真正好用的销售机器人？

---

### [00:40:54] Jeanne DeWitt Grosser

**English:**
Yes, so actually that's the second half of my answer that I forgot. Which is sort of like bill versus buy calculus. So I think one of our learnings is that it's not that hard to build these agents and they aren't that expensive either. So I mentioned the lead agent that was a six-week process with one human, a third of his time, that deal-bott, the lost bot version was two days basically we riffed on it, he had it 40 hours later. Now we're continuing to refine it for the other things I mentioned. And what's also interesting about them is they for better or for worse for Vercel, but that lead agent which runs full stack on Vercel, will cost us about a thousand dollars to run for the entire year.

**中文翻译:**
是的，这正是我刚才忘掉的后半部分答案，即“自建还是购买”的权衡。我们的心得之一是：构建这些 Agent 并不难，也不贵。我提到的线索 Agent 是一个人花三分之一的时间用了六周做出来的；而 Deal-bot 的丢单分析版本只用了两天——我们讨论了一下，40 小时后他就做出来了。现在我们正在针对我提到的其他功能进行完善。有趣的是（这对 Vercel 来说既是好事也是坏事），那个运行在 Vercel 全栈上的线索 Agent，全年的运行成本大约只需要 1000 美元。

---

### [00:41:57] Jeanne DeWitt Grosser

**English:**
If you remember I told you we had 10 people in the SDR function, so I'm paying well over a million dollars for that from a salary perspective. I got that down to one. And then behind that I have a lead agent that costs a thousand bucks. So that's like a 90%-plus reduction in total cost there. And there's lots of software for agents out there right now. And I think one of the things we're learning is because this whole space is so nascent, often your own esoteric context, your content, your workflow is really key to unlocking the power of the agent. And so I think there's real value in experimenting with your own internal agent development. We may ultimately end up on better integrated agent platforms in the fullness of time, or we may find that the CIO increasingly goes from a procurer of software to a builder of software and you'll have an AI internal platform with a thousand agents running across your org. I'm not really sure yet. But I certainly think there's value in trying it yourself because you may find that it's meaningfully easier than you think and you get returns pretty quickly.

**中文翻译:**
如果你还记得，我刚才说我们以前有 10 个 SDR，从薪水角度看，我每年要支付超过 100 万美元。现在我把人数减到了 1 个，背后是一个成本 1000 美元的线索 Agent。这相当于总成本降低了 90% 以上。现在市面上有很多 Agent 软件，但我们学到的一点是：因为这个领域还很新，你特有的业务背景、内容和工作流才是释放 Agent 力量的关键。因此，我认为尝试内部开发 Agent 很有价值。最终我们可能会转向更整合的 Agent 平台，或者我们会发现 CIO 逐渐从软件采购者转变为软件构建者，你的组织内部会有一个运行着上千个 Agent 的 AI 平台。我不确定未来会怎样，但我肯定尝试自建是有价值的，因为你会发现它比你想象的容易得多，而且回报非常快。

---

### [00:43:10] Lenny Rachitsky

**English:**
So what I'm hearing here is that you're finding that there are not tools out there to plug and play. The alpha is essentially in building your own stuff.

**中文翻译:**
所以你的意思是，目前还没有那种即插即用的工具。真正的优势（Alpha）在于构建自己的东西。

---

### [00:43:18] Jeanne DeWitt Grosser

**English:**
I think that's partially true, and I think because you also have all these tools proliferating right now, you get into the perennial problem where you wind up with 20 of them to do the 20 jobs to be done basically, rather than an integrated platform that's doing all of them. I'm hearing this a lot actually when I'm talking to customers right now where their biggest issue in deploying AI is actually just getting through procurement and it's because got an AI mandate, you kind of have a blank check. I recently heard the term of instead of ARR, it's ERR, which is experimental run rate revenue, which is to say everyone's out there sort of, Hey, we're going to give this thing a go for a year and then TBD on whether or not we keep it. But basically you're having to procure 20 different things. Most things are getting off the ground and so they're solving something relatively narrow and that'll change in the fullness of time. But I do think there's an opportunity to figure out, hey, where do I likely have a more specific workflow internally. For that it might be worth building your own agent and then maybe for the things that are a little bit more generalizable, you go get something off the shelf.

**中文翻译:**
部分正确。而且因为现在这类工具激增，你会陷入一个老问题：为了完成 20 个任务，你最后买了 20 个不同的工具，而不是一个整合平台。我现在和客户交谈时经常听到，他们部署 AI 的最大障碍其实是“采购流程”。因为公司有 AI 指令，预算充足，我最近听到了一个词叫 ERR（Experimental Run Rate Revenue，实验性经常性收入），意思是大家都在尝试：“嘿，我们先试一年，到时候再决定留不留。”但结果是你得采购 20 样东西。大多数产品才刚起步，解决的问题很窄。随着时间推移这会改变，但我认为现在是一个机会，去发现哪些内部工作流非常特殊，值得自建 Agent；而对于通用的东西，再去买现成的。

---

### [00:44:34] Lenny Rachitsky

**English:**
Are there any platforms or tools that you want to shout out that allow you to build these agents so quickly? I know they sit on Vercel, so shout out Vercel. But just anything that you point people to you to... These SDR, these GTM engineers, they're former salespeople. Are they learning to code? Are they byte coding these agents? How does that work?

**中文翻译:**
有没有什么平台或工具是你想要推荐的，能让人这么快构建 Agent？我知道它们运行在 Vercel 上，所以先给 Vercel 点个赞。但还有别的吗？这些 GTM 工程师以前是销售，他们是在学习写代码吗？他们是怎么编写这些 Agent 的？

---

### [00:44:52] Jeanne DeWitt Grosser

**English:**
So our sales engineers all have CS degrees. So they were engineers in a sales capacity, so they're writing code and actually these agents, they're building directly on Vercel. So you get the AI gateway that lets you call different models. You have a sandbox if you're running untrusted code, you've got workflows that let you build the process. You've got fluid compute, which lets you really efficiently use compute when you only need it. So we're just sort of building it from the ground up here. Again, it's not that hard. Now you do need to write code for that. Certainly there are a lot of vibe coding tools out there that also give you more workflow builders that are somewhere between fully WYSIWYG, almost like drag and drop and a little bit more code forward. So you've got a bunch out there along those lines. But I do think we've sort of found one of the reasons actually the GTM Eng team at Vercel can build these agents so easily is because the Vercel platform is making it that easy to use our framework to find infrastructure and get that agent onto into production very rapidly.

**中文翻译:**
我们的销售工程师都有计算机科学（CS）学位。他们是以销售身份工作的工程师，所以他们会写代码。这些 Agent 是直接在 Vercel 上构建的。你可以使用 AI 网关调用不同模型，有沙箱运行不受信任的代码，有工作流构建流程，还有流式计算（fluid compute）让你高效利用资源。所以我们是自下而上构建的。再说一次，这并不难。当然，你确实需要写代码。市面上也有很多“氛围编程”（vibe coding）工具，提供介于可视化拖拽和代码优先之间的工作流构建器。但我认为 Vercel 的 GTM 工程团队之所以能如此轻松地构建 Agent，是因为 Vercel 平台让定义基础设施、使用框架并将 Agent 快速投入生产变得非常简单。

---

### [00:46:11] Lenny Rachitsky

**English:**
What a neat, unfair advantage you all have to do this stuff.

**中文翻译:**
你们做这些事真是有着得天独厚的“不公平优势”。

---

### [00:46:13] Jeanne DeWitt Grosser

**English:**
Yes, it is fun to... I mean, I do think this company is better than any I've seen at eating its own dog food and just everyone is constantly, we say Vercel builds Vercel with Vercel. So you're just always looking for ways to, Hey, how can we use our product to go do what we need to do? And as a result, either understand then what a customer would want or what's missing from our product that we could go make better.

**中文翻译:**
是的，这很有趣。我的意思是，这家公司是我见过最擅长“吃自家狗粮”（eating its own dog food）的公司。我们常说“Vercel 用 Vercel 构建 Vercel”。所以大家总是在想：嘿，我们怎么用自己的产品来完成任务？结果就是，我们要么理解了客户想要什么，要么发现了产品缺失的功能并加以改进。

---

### [00:46:37] Lenny Rachitsky

**English:**
Along these lines, something that's already come across a lot in the way that you described this stuff is I've heard a lot about how you think about go-to-market as a product. A lot of people listening to this, as I've said, are product builders. So I think this is a really nice way of thinking about go-to-market. I'm guessing you've already talked about elements of this, but just what's a way to think about go-to-market as a product?

**中文翻译:**
顺着这个思路，我听过很多关于你如何将 GTM 视为一种产品的看法。正如我所说，很多听众都是产品构建者，所以这是一种非常好的思考 GTM 的方式。我猜你已经谈到了其中的一些要素，但具体来说，如何像做产品一样思考 GTM？

---

### [00:46:56] Jeanne DeWitt Grosser

**English:**
Yeah, I've always, so I had this realization probably a little over a decade ago in my career. So my first job out of college was working on Gmail in 2004. So Gmail launched on April 1st, I joined on June 1st. And as I'm sure you'll remember as well, Gmail was this incredible innovation, massive JavaScript application that didn't really exist at the time. And it had this gig of storage. It was a full year before Yahoo Mail caught up and even longer before Hotmail and others did. So that was the level of technical differentiation between Gmail and the next best. And a decade later, you had cloud computing enabling folks to do stuff that you never would've been able to do previously. And so I kind of felt like, huh, software's starting to commoditize a little bit. And so when that happens, when technical differentiation kind of narrows, what are other things that will differentiate you?

**中文翻译:**
是的，我在十多年前就有了这个感悟。我大学毕业后的第一份工作是 2004 年在 Gmail 团队。Gmail 是 4 月 1 日发布的，我是 6 月 1 日加入的。你应该记得，Gmail 当时是一项惊人的创新，是一个当时几乎不存在的大型 JavaScript 应用。它有 1GB 的存储空间，整整一年后雅虎邮箱才赶上，Hotmail 则用了更久。这就是当时 Gmail 与竞争对手之间的技术差异。十年后，云计算让人们能做以前做不到的事。我开始觉得，软件开始变得有点“商品化”了。当技术差异缩小，还有什么能让你脱颖而出？

---

### [00:48:01] Jeanne DeWitt Grosser

**English:**
And I was started thinking outside of tech, we buy a lot of things because of how we feel about them. And so I started to develop this thesis that actually the experience that you have of being sold to will increasingly actually differentiate a company and drive buying decisions if products are only different at the margin. And so if you believe that, then you really want to create a customer buying journey that feels like very unique experiences. And so we did a lot of this at Stripe and now we're looking to replicate this here. But an example of one of the things I think we did really nicely at Stripe was a lot of companies sales, the first call after you're qualified, we've decided you're worth engaging in sales process is discovery, which is basically let me ask you a lot of questions to try to under-uncover paint, figure out where buying power lies, et cetera.

**中文翻译:**
我开始跳出科技圈思考：我们买很多东西是因为对它们的感觉。于是我形成了一个论点：如果产品之间的差异很小，那么“被推销的体验”将越来越成为公司的核心竞争力并驱动购买决策。如果你相信这一点，你就会想要创造一个感觉非常独特的客户购买旅程。我们在 Stripe 做了很多尝试，现在在 Vercel 也在复制。一个例子是：很多公司的销售在确认线索合格后的第一次通话是“需求挖掘”（discovery），基本上就是问一堆问题来挖掘痛点、确认预算等。

---

### [00:49:03] Jeanne DeWitt Grosser

**English:**
And so that is kind of boring sometimes for a customer. You're basically being quizzed often on the phone. And so what we started to do at Stripe was that first session was a whiteboarding session, and we would actually get together and have you draw your architecture for payments and all the other things that were under the hood to enable you to take money and drive customer outcomes. And through that we would learn a ton about what was in your stack, what we were going to have to compete with, displace where value lied. But the customer also learned a lot themselves because in many cases they'd never drawn their architecture diagram. And so they left that meeting with an asset and a sense of like, "Wow, this is a really collaborative person who's deeply interested in helping me develop a mental model for how to think about this." And then we had other things that we would do.

**中文翻译:**
对客户来说，这有时很无聊，感觉像是在电话里接受盘问。所以我们在 Stripe 开始做的是：第一次会议是“白板会议”。我们会聚在一起，让你画出你的支付架构以及底层的所有环节。通过这个过程，我们能了解到你的技术栈、我们要竞争或替换的对象以及价值所在。但客户自己也学到了很多，因为很多情况下他们从未画过自己的架构图。他们带着一份产出离开会议，并觉得：“哇，这个人非常有协作精神，他真的对帮我建立思维模型感兴趣。”

---

### [00:50:00] Jeanne DeWitt Grosser

**English:**
So that's sort of how I think about building go-to-market-like a product is basically you need to go through from the first time you become aware that the company exists to again, that sort of five-year heavily retained wall-to-wall customer a set of experiences. And those experiences can feel transactional, flat, boring, or they can feel very human, personalized and unique. And so we try to go map those out and figure out how do you bring the product to bear, make it really human, and hopefully that creates a customer for life in the end.

**中文翻译:**
这就是我所谓的“像做产品一样构建 GTM”：你需要梳理从客户第一次意识到公司存在，到成为留存五年、全面普及的客户所经历的一系列体验。这些体验可以是交易式的、平淡乏味的，也可以是非常人性化、个性化且独特的。我们尝试规划这些体验，思考如何结合产品，使其充满人情味，最终希望能创造出终身客户。

---

### [00:50:37] Lenny Rachitsky

**English:**
I love that whiteboarding example. Are there any other examples of what you've done to make it actually work really well in this way?

**中文翻译:**
我喜欢白板会议那个例子。还有其他例子吗？你是如何让这种方式真正奏效的？

---

### [00:50:43] Jeanne DeWitt Grosser

**English:**
Yeah. Another principle, we really developed this at Stripe too and I brought it to Vercel, was just the idea of adding value at any touch point regardless of whether or not that customer bought. Because even if customers don't buy, you often find that if you miss them on that buying cycle, three or four years later when they're in another buying cycle, they do come back. I was at Stripe for nine years and so I saw the number of customers that we lost and then half a decade later, here they are and they bought. So that was sort of another one. So examples of this that were doing at Vercel is there's great data on the internet that helps people understand the performance of their website and how fast your website is actually impacts SEO. And SEO impacts AEO and everybody's thinking about AEO right now.

**中文翻译:**
是的。另一个原则（也是在 Stripe 发展并在 Vercel 应用的）是：无论客户最终是否购买，都要在每一个触点提供价值。因为即使客户这次没买，你常会发现三四年后当他们进入下一个采购周期时，他们会回来。我在 Stripe 待了九年，亲眼见过很多流失的客户在五年后回来购买。在 Vercel 的例子是：互联网上有很多数据能帮人们了解网站性能，而网站速度会影响 SEO（搜索引擎优化）。SEO 又会影响 AEO（回答引擎优化），而现在每个人都在思考 AEO。

---

### [00:51:40] Jeanne DeWitt Grosser

**English:**
And, so one of the things we try to do when we reach out is actually give folks insight immediately into how they're performing on an absolute basis, how they're performing relative to peers. So ideally that piques your interest and you want to learn more from us, but even if it doesn't, you still have insights that you may or may not have been aware of that maybe make you contemplate whether or not you've got the optimal setup.

**中文翻译:**
所以当我们联系客户时，我们会尝试立即提供关于他们网站性能的洞察——包括绝对表现以及相对于同行的表现。理想情况下，这会激起你的兴趣，让你想了解更多。但即使你没买，你也获得了一些之前可能没意识到的洞察，这可能会让你思考目前的配置是否最优。

---

### [00:52:30] Lenny Rachitsky

**English:**
Awesome. So what I'm hearing here is when you say, think of it like a product that's basically a product person thinks about the experience of their product, that every step of the journey, here's the flow, step 1, 2, 3, 4, 5, how do we make every step awesome, keep them going along that journey. And so what you think about is just from the prospect's perspective, how do we make every step of that journey awesome, continue them down that journey.

**中文翻译:**
太棒了。所以我的理解是，当你谈到“像做产品一样思考”时，本质上是像产品经理思考产品体验一样：梳理旅程的每一步（步骤 1, 2, 3, 4, 5），思考如何让每一步都棒极了，让用户持续走下去。你所做的就是从潜在客户的角度出发，让旅程的每一步都精彩，引导他们完成整个过程。

---

### [00:52:38] Jeanne DeWitt Grosser

**English:**
Yeah. How do you make it be an experience rather than a transaction.

**中文翻译:**
是的。如何让它成为一种“体验”，而不仅仅是一次“交易”。

---

### [00:52:35] Lenny Rachitsky

**English:**
Versus just feel like sales coming at you trying to sell you stuff?

**中文翻译:**
而不是感觉销售冲过来硬塞给你东西？

---

### [00:52:37] Jeanne DeWitt Grosser

**English:**
Yeah.

**中文翻译:**
没错。

---

### [00:52:38] Lenny Rachitsky

**English:**
Okay. Staying along this track of staying tactical, I want to go even further there. So what are just some go-to-market tactics that you find really effective these days for people trying to just to be more successful in getting people to pay attention to their stuff, to buy their stuff?

**中文翻译:**
好，让我们继续深入探讨战术层面。对于那些想要更成功地吸引注意力并让人们购买产品的人来说，你发现目前有哪些非常有效的 GTM 战术？

---

### [00:52:57] Jeanne DeWitt Grosser

**English:**
I mean, one I would sort of say dovetails with where I just ended, but is what are the unique insights that you can bring to bear about your product or how that customer may be in a suboptimal state? So I do think investing in data to tease that out is one thing. I think the other thing this is straightforward but often not done enough is a lot of good companies invest in docs, good thing to do, but they stop there. And particularly if you are selling into a slightly larger company doing things like, AWS calls it well-architected guides or blueprints, a lot of customers, particularly larger ones, really want to know the best practice for how exactly to implement your product with their particular setup.

**中文翻译:**
我想其中一个战术与我刚才说的相呼应：你能提供哪些关于你产品或客户当前“非最优状态”的独特洞察？我认为投资于数据来挖掘这些洞察是很重要的。另一件事虽然显而易见但做得不够：很多优秀的公司投资于文档（docs），这很好，但他们止步于此。特别是当你向大公司销售时，你需要提供类似 AWS 所谓的“架构完善指南”或“蓝图”。很多客户（尤其是大客户）非常想知道针对他们的特定配置，实施你产品的“最佳实践”到底是什么。

---

### [00:54:07] Jeanne DeWitt Grosser

**English:**
A great example of this, this is from Stripe, was Stripe was excellent at marketplaces. Most, Lyft, Instacart, DoorDash, they were all on Stripe. And so Stripe definitely knew the best way to set up payments for a marketplace because we'd seen them all. And so when you then would go and sell a marketplace and say, "Oh yeah, we've got docs, go check them out." They didn't like that, because they're like, "Hey, every marketplace runs on Stripe. I don't want to look at generic docs. I want you to tell me what's the best way to set up payments for a marketplace." And so I think that's another key thing to be doing, particularly as you move past that sort of solo developer startup founder as potentially a target audience.

**中文翻译:**
Stripe 有个很好的例子：Stripe 非常擅长处理平台/市场（marketplace）业务。Lyft、Instacart、DoorDash 都在用 Stripe。所以 Stripe 绝对知道建立平台支付的最佳方式，因为我们见过所有的案例。当你去向一家平台型公司销售时，如果你只是说“哦，我们有文档，去看看吧”，他们是不买账的。他们会说：“嘿，每个平台都在用 Stripe，我不想看通用文档，我想让你告诉我建立平台支付的最佳方式。”我认为这是另一件关键的事，尤其是当你的目标受众不再仅仅是个人开发者或初创公司创始人时。

---

### [00:54:39] Jeanne DeWitt Grosser

**English:**
And then, I don't know if this is a tactic per se, but I do think just a good reminder for founders in particular who are still in that maybe founder-led sales moment is just the value of really good discovery. I often find founders are so excited about talking about their product or you ask one question and now they've got a hook of like, oh, I can fix that for you. But excellent salespeople typically will talk well under half the time in a conversation because they're out asking questions, probing often helping a customer arrive at conclusions on their own. And so learning how to do five why's, go deep rather than immediately going into problem solving mode. If they ask a question, you respond often. If they ask a question, you should ask a question about the question and then respond. So learning to be great at that, I think differentiates people.

**中文翻译:**
还有，我不确定这算不算战术，但我认为对那些仍处于“创始人主导销售”阶段的创始人来说，一个很好的提醒是：深度需求挖掘（discovery）的价值。我经常发现创始人太急于谈论自己的产品，或者客户问了一个问题，他们就立刻接话：“哦，这个我能帮你解决。”但优秀的销售人员在对话中说话的时间通常不到一半，因为他们在提问、探寻，引导客户自己得出结论。要学会问“五个为什么”，深入挖掘，而不是立刻进入解决问题模式。如果客户问了一个问题，你不要直接回答，你应该针对那个问题再反问一个问题，然后再回答。学会这一点能让你与众不同。

---

### [00:55:43] Lenny Rachitsky

**English:**
So the last tip, I think there's something a lot of I bet everyone could learn is just listen more and talk less.

**中文翻译:**
所以最后一个建议是每个人都能学到的：多听少说。

---

### [00:55:48] Jeanne DeWitt Grosser

**English:**
Yep.

**中文翻译:**
没错。

---

### [00:55:49] Lenny Rachitsky

**English:**
On that first piece of advice, this kind of sharing unique insights and how your suboptimal, is there an example you could share of how you did that? Maybe a story of just how you convinced someone you're selling Striper or Vercel like care or something you're missing. Here's how this could help you become much better.

**中文翻译:**
关于第一个建议——分享独特洞察并指出对方的非最优状态，你能分享一个具体的例子吗？比如你在销售 Stripe 或 Vercel 时，如何说服对方：“嘿，你漏掉了一些重要的东西，这样做能让你变得更好。”

---

### [00:56:04] Jeanne DeWitt Grosser

**English:**
So with Vercel, sort of giving an example, but I'll make it more specific. So the performance point, you can go and look at core web Vitals, and so we can actually see the different things within their site that are fast or load correctly, et cetera, so anyone can go look that up. But what we can do is actually then help with benchmarking relative to peers. So that's been a big one that we've gone out and done. The other one that we've spent some good time on is just around helping customers understand MCP servers and when it would make sense to use one. So I think those are all the rage, but often people don't know how to contemplate them within their own product.

**中文翻译:**
以 Vercel 为例。关于性能，任何人都可以去查“核心网页指标”（Core Web Vitals），看到网站加载速度等数据。但我们可以做的是提供“同行基准对比”。这是我们一直在做的一件大事。另一件我们投入很多时间的事是帮助客户理解 MCP 服务器（Model Context Protocol），以及什么时候使用它才有意义。虽然这些现在很火，但人们往往不知道如何将其融入自己的产品。

---

### [00:57:09] Jeanne DeWitt Grosser

**English:**
The other one that we've gone pretty deep on and then related to, the first one is AEO Answer engine optimization is actually somewhat tangential to Vercel right. So we drive performance, performance drives SEO. SEO is an input into AEO, but we have spent a ton of time sharing insights on AEO because we ourselves focus deeply on it and think we understand it better than many. And so again, as part of just building a trusted relationship, folks may go from those AMAs or that content into, okay, great, you taught me a lot and therefore I want Vercel to help me with performance. But in many cases, they actually now are just like, "This is a company that seems insightful, it seems like one I can learn from, and now I'm going to pay a little bit more attention to them." And over the fullness of time, maybe they see something that triggers them to decide, "Now is the time I want to go investigate that aspect of Vercel."

**中文翻译:**
我们深入研究的另一个领域是 AEO（回答引擎优化）。这其实与 Vercel 的核心业务略有偏差：我们提升性能，性能提升 SEO，而 SEO 是 AEO 的输入。但我们花了很多时间分享 AEO 的洞察，因为我们自己对此研究很深，觉得自己比很多人都懂。作为建立信任关系的一部分，人们可能会通过我们的内容觉得：“太棒了，你教了我很多，所以我希望 Vercel 帮我提升性能。”但在很多情况下，他们只是觉得：“这家公司很有见地，值得学习，我要多关注他们。”随着时间推移，也许某件事会触发他们决定：“现在是时候研究一下 Vercel 的那个功能了。”

---

### [00:57:55] Lenny Rachitsky

**English:**
Awesome. So what I'm hearing here in many ways, and this resonates, I had Jenna Abel on the podcast recently and it was all about sales skills and how to sell. And one of her tips is you don't want to be focusing on here's the pain and problem we're solving and instead focus on here's how you will be better than your competitors. Here's the big gap and alpha that you can achieve. If you use Vercel, you were missing out on speed and you're going to get screwed in AEO and all these things. Here's how you can architect your entire payments system to be top tier. Does that resonate?

**中文翻译:**
太棒了。这让我想起了最近来播客的 Jenna Abel，她谈到了销售技巧。她的建议之一是：不要只关注“这是我们要解决的痛点”，而要关注“你会如何比竞争对手更强”。展示那个巨大的差距和你能获得的优势（Alpha）。如果你不用 Vercel，你就会失去速度，在 AEO 竞争中落败。如果你用 Stripe，你可以把支付系统打造得世界一流。这能引起你的共鸣吗？

---

### [00:58:27] Jeanne DeWitt Grosser

**English:**
Yeah, I was told this stat. It's round numbers, so I can't imagine it's entirely accurate, but basically that customers, 80% of customers buy to avoid pain or reduce risk as opposed to the other one out of five to increase upside, which is a good thing again for startup founders to understand. So we all love to talk about the art of the possible, everything we're going to enable in the future. It's very exciting. Everyone's visionaries, but that's often really a sale that's going to resonate with another founder. And for everybody else, particularly enterprises, you're avoiding the risk of not making your revenue target next quarter, the risk of being outdone by the competition, the risk of having brand damage, et cetera. And so it's really hard actually for many startups to make that pivot because it feels off brand, but it does actually drive more buying behavior, is setting up a little bit of that concern that either I might not be well positioned or again through good question asking. I know exactly where I'm not well positioned and you can help me.

**中文翻译:**
是的。我听过一个统计数据（大概的数字，不一定完全精确）：80% 的客户购买是为了规避痛苦或降低风险，只有 20% 是为了增加收益。初创公司创始人需要理解这一点。我们都喜欢谈论“未来的可能性”，这很令人兴奋，大家都是愿景家，但这通常只能打动另一个创始人。对于其他人，尤其是企业客户，他们想的是：规避下季度完不成业绩的风险、规避被竞争对手超越的风险、规避品牌受损的风险。对初创公司来说，这种转变很难，因为感觉不符合品牌调性。但实际上，通过提问让客户意识到自己处于不利地位，并展示你能如何提供帮助，确实能驱动更多的购买行为。

---

### [00:59:53] Lenny Rachitsky

**English:**
That is such an important stat you shared. This has come up actually before in this podcast that buying, people are buying in large part to reduce risks, to basically not hurt themselves in their career, not hurt the company. That's a bigger factor in the buying decision than, "I have this problem I need to solve. And okay, thank you, this is solving." And the way April Dunford came in the podcast and talked about this of just like it's such a massive career bet. We are going to bring in product X and it's going to become, like Stripe, let's say, let's not talk about Vercel. But let's say Stripe, we're going to adopt Stripe. That's a huge decision. If it doesn't go well, your career is hurt, your manager is going to be mad at you, it's going to set your company back. So a lot of the buying decision, as you've said is I just don't want to screw this up.

**中文翻译:**
你分享的这个数据太重要了。本播客之前也提到过：人们购买在很大程度上是为了降低风险，为了不损害自己的职业生涯，不损害公司。这比单纯的“我有问题要解决”更重要。正如 April Dunford 在播客里说的，这是一种巨大的职业赌注。我们要引入产品 X，比如 Stripe。这是一个重大决定，如果搞砸了，你的职业生涯会受损，老板会生气，公司会倒退。所以正如你所说，很多购买决定其实是：“我只是不想把事情搞砸。”

---

### [01:00:36] Jeanne DeWitt Grosser

**English:**
Right. Absolutely.

**中文翻译:**
没错，绝对是这样。

---

### [01:00:37] Lenny Rachitsky

**English:**
Okay. Along the line of tactics, something that I know you're a big fan of and help people think about is segmentation. This is something a lot of founders struggle with. They know, "Okay, I need to figure out my segmentation strategy and here where we're going after." Can you just give us a primer on segmentation, what people should know about why this is important and then how they might approach this.

**中文翻译:**
好。在战术方面，我知道你非常推崇并经常帮人思考的是“市场细分”（segmentation）。这是很多创始人头疼的问题。他们知道需要制定细分策略，确定目标。你能给我们讲讲市场细分的基础知识吗？为什么它很重要？以及该如何着手？

---

### [01:00:59] Jeanne DeWitt Grosser

**English:**
So segmentation is basically how do you carve up the world of companies that exist on the planet to reason about them where they buy differently? So I'll give examples from Stripe and Vercel to bring this home. So a very typical company segmentation is small, medium, large. That's a rational way to do things. Small, you often have a single decision maker, medium, a small team, and large, it's complex, it's a committee, et cetera. So the buying process does change across SMB, mid-market enterprise, but if you stop there, you are likely missing. But what are the things within your offering that also change the way something gets sold?

**中文翻译:**
市场细分基本上就是：你如何划分地球上的公司，以便分析他们不同的购买方式？我用 Stripe 和 Vercel 的例子来说明。最典型的细分是：小型、中型、大型。这很合理。小型公司通常只有一个决策者；中型公司是一个小团队；大型公司则很复杂，有委员会等等。所以 SMB（中小企业）、中型市场和大型企业的购买流程是不同的。但如果你止步于此，你可能会漏掉一些东西。你还需要考虑：你的产品中，有哪些因素会改变销售方式？

---

### [01:02:10] Jeanne DeWitt Grosser

**English:**
So at Stripe, there were two ways we further cut the business. Way one was, so think of segmentation as a graph. So X-Access was size, so small, medium, large, y-access was growth potential. And that was important for Stripe because it was a consumption-based business. So if you were going to grow at 200% year-on-year, you were more valuable to Stripe than if you were going to grow at 8% year-on-year. And so we wanted to spend more time, spend more money going after the 200% growers than the 8%. So that was one that informed your strategy on who you targeted. And then for Stripe, the other thing that we cut it was business model. So are you a B2B? Are you B2C? Are you B2B2B, E.G. a platform or B2B2C, E.G. a marketplace and why is that relevant?

**中文翻译:**
在 Stripe，我们有两个进一步划分的维度。第一，把细分看作一个图表：X 轴是规模（小、中、大），Y 轴是增长潜力。这对 Stripe 很重要，因为它是基于用量的业务。如果你每年增长 200%，你对 Stripe 的价值就远高于每年增长 8% 的公司。所以我们愿意花更多时间和金钱去争取那些 200% 增长的公司。第二是商业模式：你是 B2B、B2C，还是 B2B2B（如平台）或 B2B2C（如市场）？为什么这很重要？

---

### [01:03:00] Jeanne DeWitt Grosser

**English:**
Well, if you're B2B, you are going to need business payments. Credit card was useful for a PLG function or PLG sale, but you were going to need ACH wires, etc. And you probably had a recurring business, so you were going to want Stripe billing. If you were B2C, that's consumer. So you're going to want consumer payments. Apple Pay is super important. If you were in the platform or the marketplace, you were going to buy our connect product. So it helped us basically then craft a more targeted and replicable sales. Vercel, sort of similar deals. So small, medium, large buying complexity. We also do the same thing on growth potential because we are similarly a consumption based business, but for us, a couple other things on the X-axis, we layer in promote, which is one of the things that is observable is traffic, site traffic on the internet.

**中文翻译:**
如果你是 B2B，你需要企业支付。信用卡对 PLG 销售有用，但你还需要 ACH 转账等。你可能有订阅业务，所以你需要 Stripe Billing。如果你是 B2C，那是面向消费者的，你需要 Apple Pay 等支付方式。如果你是平台或市场，你会买我们的 Connect 产品。这帮我们制定了更有针对性、可复制的销售策略。Vercel 也类似：小、中、大代表购买复杂度。我们也看增长潜力。但在 X 轴上，我们还增加了“流量”维度，这是互联网上可观察到的数据。

---

### [01:03:48] Jeanne DeWitt Grosser

**English:**
So Google publishes a Crux score, which is basically they have a bunch of data in Chrome, and so they know that Lenny's site gets a million XC amount volume that Jeanne's site does. And so basically if you are a small company but you have super high traffic that's going to be more complex, Vercel is going to make more money and so we want to promote you. So great example of this would be OpenAI. OpenAI, I forget these days how many employees it has. Let's say it's 3,000, it's probably more than that at this point, but so that's going to put it in the mid-market at most companies, but they're a top 25 traffic site on the internet. So for us, that's going to push them in our enterprise because we need to go lean in with a much more in depth sales process. And then the other thing we layer on is a workload type.

**中文翻译:**
Google 会发布 Crux 评分，他们有 Chrome 的数据，所以知道 Lenny 的网站流量是 Jeanne 的一百万倍。如果你是一家小公司但流量极大，情况会变得复杂，Vercel 能赚更多钱，所以我们会把你“升级”。OpenAI 就是个好例子：我忘了它现在有多少员工，假设是 3000 人，在大多数公司这算“中型市场”，但它是全球流量前 25 的网站。所以对我们来说，它属于“大型企业”类别，我们需要投入更深入的销售流程。此外，我们还增加了“工作负载类型”维度。

---

### [01:05:06] Lenny Rachitsky

**English:**
Okay, this is awesome. So essentially what you do is you break up this universe coming back to your original story at Stripe to help you sort essentially which companies are most likely to buy your product. And what you're coming up with is these attributes that are correlated with they're likely to be great potential customers.

**中文翻译:**
太棒了。本质上，你划分这个“宇宙”是为了筛选出哪些公司最有可能购买你的产品。你找出了那些与“成为优质潜在客户”高度相关的属性。

---

### [01:05:22] Jeanne DeWitt Grosser

**English:**
Yep.

**中文翻译:**
没错。

---

### [01:05:22] Lenny Rachitsky

**English:**
Do you recommend using this XY axis as the approach versus something else? There's like a spreadsheet with five columns. I don't know, how do you start?

**中文翻译:**
你推荐使用这种 XY 轴的方法吗？还是别的？比如一个有五列的电子表格？该如何开始？

---

### [01:05:31] Jeanne DeWitt Grosser

**English:**
There's probably something to be said for X and Y. like do you think size is going to play into most buying decisions and then these days there is a fair amount of consumption happening? So there'll be aspects of this that I think are somewhat universal. But I think basically when I came to Vercel, because new product market product offering, for me it's a new market. I had a lot to learn, but this is one of the first things I did in the first 30 days. And so basically I sat down with the gentleman Abhi who leads data science here and said, okay, what drives revenue? So what are the things that you can look at X ante about a customer to know this person's likely to pay us a hundred thousand dollars versus a million? That's probably going to be part of a segmentation framework.

**中文翻译:**
XY 轴确实有它的道理。规模会影响大多数购买决策，而且现在有很多按需付费的模式。有些维度是通用的。当我来到 Vercel 时，面对新产品和新市场，我有很多要学的。这是我在前 30 天做的第一件事。我找到负责数据科学的 Abhi 说：“好，是什么在驱动营收？我们能提前观察客户的哪些特征，从而判断他可能付给我们 10 万美元还是 100 万美元？”这通常就是细分框架的一部分。

---

### [01:06:46] Jeanne DeWitt Grosser

**English:**
And then similarly, okay, what attributes would we look for to cluster where we seem to be winning repeatedly? And that was how we ultimately got at, okay, Crux rank is going to be super important because what you pay Vercel is correlated with your traffic. And then workload type was super important as well. And for Vercel, when we did that, it was really interesting because we saw, wow, we have a lot of penetration and e-comm not that surprising actually, given that we drive highly performant sites and e-comm having a superfast performance site really matters. But at the time, if you looked at as an example, an enterprise SaaS companies, we didn't have a lot of penetration, even though you would've thought, okay, front-end cloud, very developer oriented. Of course software companies would be on us, but in enterprise, most of those companies built that SaaS offering before Vercel existed.

**中文翻译:**
同样，我们要看哪些属性可以归纳出我们反复获胜的领域。最终我们发现 Crux 排名非常重要，因为你付给 Vercel 的钱与流量正相关。工作负载类型也很重要。在 Vercel，我们发现我们在电商领域的渗透率很高，这不奇怪，因为电商非常看重网站速度。但当时，我们在企业级 SaaS 公司的渗透率并不高。虽然你可能觉得前端云是面向开发者的，软件公司理应使用我们，但在大企业中，大多数 SaaS 产品是在 Vercel 出现之前就建好的。

---

### [01:07:55] Lenny Rachitsky

**English:**
So essentially you're doing this regression analysis on what's working and then here's the attributes that are most correlated with success. Something I always recommend when founders ask me for how do I figure out my CPE? How do I figure out where to focus, my heuristic is just think of three attributes that narrow them down. So it's like series A company that's angel-led, that's the marketplace, something like that. Does that feel like a good just rule of thumb just to start?

**中文翻译:**
所以本质上你是在对有效的方法进行回归分析，找出与成功最相关的属性。当创始人问我如何确定目标时，我的经验法则是：想出三个能缩小范围的属性。比如：天使轮领投的 A 轮公司、平台型业务。这算是一个好的入门法则吗？

---

### [01:08:18] Jeanne DeWitt Grosser

**English:**
Yeah, I think beyond three, that's getting pretty detailed and reasonably speaking, you're not going to cut. You have five sellers. So, what, you're going to put one seller in five different segments? So I do think three is something you can reason about. The other thing I'll say on this topic that I think is really important is a lot of times folks think segmentation is a go-to market thing. I really think it's a company thing. So when you Vercel, I actually deliver and every new hires first week, one of our company values is KYC, know your customer and I deliver the KYC section and talk through our segmentation framework how our customer base maps into those segments because it's really important as those new product managers leave the room that when they're building something, they think to themselves, okay, I'm building a new back end product. Who is this targeted at? Is it targeted at an enterprise or a startup?

**中文翻译:**
是的，超过三个就太细了。如果你只有五个销售，你难道要把一个销售分到五个不同的细分市场吗？所以三个是比较合理的。关于这个话题，我想说的另一件重要的事是：很多人认为市场细分只是 GTM 部门的事，但我认为它是全公司的事。在 Vercel，每个新员工入职的第一周，我都会亲自讲解我们的公司价值观之一——KYC（了解你的客户）。我会讲解我们的细分框架，以及客户是如何分布在这些细分市场中的。因为这很重要：当新产品经理离开会议室去构建新产品时，他们需要思考：“我正在做一个新的后端产品，它是针对大企业还是初创公司的？”

---

### [01:09:36] Lenny Rachitsky

**English:**
Okay, this is a great segue to, there's a couple other things I want to talk about. One is something I've heard from so many people you've worked with is that you are amazing at building a go-to-market org that works really well with product and engineering. So I'll read this quote from your former colleague, Kate Jensen. She said that your superpower is building a sales org that doesn't feel like a sales org to engineers. So the question she suggested asked just what does it take to do that? What are the ingredients to building a sales org that engineers and product teams really like working with?

**中文翻译:**
这是一个很好的过渡。我想聊聊另外几件事。其中之一是，我听很多和你共事过的人说，你非常擅长建立一个能与产品和工程团队紧密配合的 GTM 组织。我读一段你前同事 Kate Jensen 的评价，她说你的超能力是“建立一个让工程师觉得不像销售部门的销售组织”。她建议我问：做到这一点需要什么？建立一个让工程师和产品团队喜欢合作的销售组织，有哪些要素？

---

### [01:09:59] Jeanne DeWitt Grosser

**English:**
The litmus test I have always given my sales team is if you are an account executive in my org and I put you in front of 10 engineers at our company, it should take them 10 minutes to figure out you aren't a product manager. And what I'm trying to get across is you need to have incredible product depth. And the reason for that is twofold. One, it gives you credibility with the product and engineering org. And two, I also believe that the best go-to-market orgs on the planet are equal parts revenue driving and R&D and D. And the reason I emphasize the latter is if you think about a product management organization, you may have a UXR team out doing research, product managers certainly should be out talking to customers. Well, if I have a 20-person sales team, think of the number of customers that we talk to in a week. And so if we can do an excellent job of translating all of that feedback into signal and then feeding that into the road map, we can be actually an extension of the product management org.

**中文翻译:**
我给销售团队的“试金石”测试是：如果你是我这里的 AE，我把你带到 10 个工程师面前，他们应该需要 10 分钟才能发现你不是产品经理。我想表达的是，你必须对产品有极深的理解。原因有二：第一，这能让你在产品和工程团队面前拥有公信力；第二，我相信世界上最好的 GTM 组织既是营收驱动者，也是研发的一部分。我之所以强调后者，是因为如果你看产品管理组织，他们可能有用户研究团队，产品经理也会去跟客户聊。但如果我有一个 20 人的销售团队，想想我们一周会接触多少客户？如果我们能出色地将反馈转化为信号并反馈到路线图中，我们实际上就是产品管理组织的延伸。

---

### [01:11:27] Lenny Rachitsky

**English:**
I just love this as a product manager, maybe form a product manager. I don't know what the hell I am these days. I just love the idea of the salesperson. Like you not knowing the difference between a product manager and a salesperson. The most classic challenge is sales orgs ask for all these features and PMs are constantly having to push back and think about does this fit into everything. So it feels like that's a big part of this is to understand that deeply.

**中文翻译:**
作为一个产品经理（或者曾经是，我也不知道我现在算什么），我太喜欢这个想法了。销售人员和产品经理让人分不清楚。最经典的挑战就是销售部门不断要新功能，而 PM 不得不拒绝并思考这是否符合整体规划。所以，深入理解这一点是关键。

---

### [01:11:51] Jeanne DeWitt Grosser

**English:**
Yeah, you want a sales org that can think like a general manager, so that's not just trying to get deals done but is trying to help build a business. And so again, knows when to say no, knows when to do objection handle versus knows, Hey, I've actually heard this on the last three calls and I do think this would be a really big unlock that would make us more competitive, would be something that new that nobody's doing. So I think that takes looking for a profile that both has sales skills but also is going to think with that product mindset.

**中文翻译:**
是的，你需要一个能像“总经理”一样思考的销售组织。他们不只是为了成交，而是为了帮助建立业务。他们知道什么时候该说不，知道什么时候该处理异议，也知道什么时候该说：“嘿，我最近三个电话都听到了这个需求，我认为这会是一个巨大的突破，能让我们更有竞争力。”这需要寻找那种既有销售技巧，又有产品思维的人才。

---

### [01:12:31] Lenny Rachitsky

**English:**
I love that. Okay, so another quote from Claire Hughes Johnson, former podcast guest, amazing sales leader, worked with you at Stripe. She said something along these lines, but a little different. Jeanne is probably the best go-to-market person at connecting with product and engineering, deeply understanding the product and providing the most valuable input to her counterparts of any I've ever seen. It sounds like just another ingredient here is just sales feeling like a real partner to product engineering actually, not just being like, "Hey, do these things for me, but actually feeling like a partner."

**中文翻译:**
太棒了。再引用一段 Claire Hughes Johnson（曾来过本播客，Stripe 的优秀领导者）的话。她说：“Jeanne 也许是我见过的最擅长连接产品与工程、深度理解产品并为同事提供最有价值输入的 GTM 专家。”听起来另一个要素是：销售部门要真正成为产品和工程部门的伙伴，而不仅仅是说“嘿，帮我做这些事”。

---

### [01:13:01] Jeanne DeWitt Grosser

**English:**
Ultimately company strategy is basically product strategy meets go-to market strategy. And so I spend guess as a go-to market leader, I'm constantly trying to figure out how do I make more money more efficiently? And you typically do that by having a winning product in the market that is well commercialized. And so that means that I really lean into thinking about product strategy and thinking about pricing strategy because if those two things are optimal, you're going to win more often and there'll be less friction in it. And so that is sort of where got to put as a revenue leader, like a GM hat on and not just think, how do I sell? But actually how do I enable the insights I'm getting from talking to customers constantly to have the company strategy be more effective?

**中文翻译:**
归根结底，公司战略就是“产品战略”与“GTM 战略”的结合。作为 GTM 领导者，我一直在思考如何更高效地赚钱。通常，你需要一个在市场上获胜且商业化良好的产品。这意味着我会深入思考产品战略和定价策略，因为如果这两点是最优的，你获胜的概率就更高，阻力也更小。作为营收负责人，我必须戴上“总经理”的帽子，不只是想“怎么卖”，而是想“如何利用从客户那里获得的洞察，让公司战略更有效”。

---

### [01:14:00] Lenny Rachitsky

**English:**
Speaking of product, going in a slightly different direction, PLG product-led growth, it felt like it was very hot for a while where everyone's like, "You got to go PLG, that's the only way to win. It's impossible to do sales. The future is PLG." It feels like that's gone away. And in large part, obviously still companies grow through PLG and work through PLG. What's just kind of your thoughts on PLG and when does it make sense for a company these days to actually think this is how they'll grow for a while?

**中文翻译:**
说到产品，换个话题。PLG（产品驱动增长）曾一度非常火爆，大家都说“你必须做 PLG，这是唯一的出路，销售已经过时了”。现在这种热度似乎消退了一些。当然，很多公司仍然通过 PLG 增长。你对 PLG 有什么看法？在当今环境下，公司在什么时候应该考虑将 PLG 作为主要的增长方式？

---

### [01:14:28] Jeanne DeWitt Grosser

**English:**
PLG makes sense for a lot of companies at the outset, unless you are very explicitly building a product for enterprise. So Sierra as an example, right? They are very clearly going after Global 2000 or something close to that. PLG is not going to be overly useful to them because they are trying to win eight-figure deals from day one. But for a lot of products, folks are targeting a startup audience at the outset and then they're adding more functionality so that they can ultimately continue to scale up market. So I think PLG is still super relevant. It's a major driver of Vercels growth. It was a big driver of Stripe's growth. The thing that folks get wrong is it does typically have a ceiling. So people are generally not going to give you $1 million via self-serve flow.

**中文翻译:**
除非你明确是为大企业构建产品，否则 PLG 对很多公司在起步阶段都是有意义的。比如 Sierra，他们显然是针对全球 2000 强企业的，PLG 对他们没多大用，因为他们从第一天起就想签下八位数的订单。但对于很多产品，大家起步时针对的是初创公司，然后增加功能以向高端市场扩张。我认为 PLG 仍然非常重要，它是 Vercel 和 Stripe 增长的主要驱动力。人们常犯的错误是忽视了它通常有“天花板”：人们通常不会通过自助流程付给你 100 万美元。

---

### [01:15:30] Jeanne DeWitt Grosser

**English:**
So at some point if you want to sustain growth rates, you're going to have to have your deal sizes get bigger and bigger. And where I think folks get stuck is waiting too long on PLG because it does take a while to build a replicable sales process and a sales process, which often you're getting fed by inbound at the beginning and then you got to add outbound. It takes a while actually to turn outbound into a predictable engine. So I think where you see companies hit walls is just when they don't add the sales portion of it soon enough.

**中文翻译:**
所以如果你想维持增长率，你必须让订单金额越来越大。我认为人们容易卡在“在 PLG 上停留太久”。建立一个可复制的销售流程需要时间，最初你可能靠被动咨询，然后你得增加主动获客。将主动获客变成一个可预测的引擎需要很长时间。所以，当公司没有足够快地加入销售环节时，就会遇到瓶颈。

---

### [01:16:00] Lenny Rachitsky

**English:**
So essentially every company ends up having to build a sales org, some start product-led and then at sales, some just start sales and have it from the beginning.

**中文翻译:**
所以本质上每家公司最终都要建立销售组织。有的从产品驱动开始再加入销售，有的从一开始就只有销售。

---

### [01:16:09] Jeanne DeWitt Grosser

**English:**
Yeah, I would agree. There are probably some good examples of large vertical SaaS platforms that are SMB, but even they wind up with Velocity sales team. So yeah, I don't know that I can think of a 100 billion company that's PLG-only.

**中文翻译:**
是的，我同意。虽然有一些针对中小企业的垂直 SaaS 平台做得很成功，但他们最终也会建立快速成交的销售团队。我目前想不出哪家千亿美金市值的公司是纯 PLG 的。

---

### [01:16:30] Lenny Rachitsky

**English:**
Yeah, it just feels like you're leaving money on the table even if you are growing really fast. I know Atlassian was a long-time PLG company but eventually succumbed. I don't know if that's the right way to put it. Okay. You mentioned pricing. I know you have strong opinions on pricing and pricing strategy. What's just a couple of tips you might share with someone thinking about how to price their product?

**中文翻译:**
是的，即使增长很快，不加销售也感觉是把钱留在了桌子上。我知道 Atlassian 坚持了很久的 PLG，但最终也“屈服”了（不知道这么说对不对）。你提到了定价，我知道你对定价策略有很深的见解。对于正在思考如何给产品定价的人，你有什么建议？

---

### [01:16:52] Jeanne DeWitt Grosser

**English:**
Yeah, this is kind of on the theme, but I think the first thing is you got to think about pricing like a product. So it's another one where it actually really matters how you choose to price a product. Do you really understand where customers are going to drive value? Do you really understand where you incur costs? And are you doing a smart job of aligning those things? You've got lots of examples of companies grossly underpricing, you're sort of afraid to charge for the value that you actually provide. I think there are a lot of examples where people default to including a freemium strategy without that actually being a strategy.

**中文翻译:**
这又回到了那个主题：你必须像做产品一样思考定价。如何定价真的非常重要。你是否真正理解客户在哪里获得价值？你是否理解你的成本在哪里？你是否聪明地将两者对齐了？有很多公司严重低估了自己的价格，不敢为自己提供的价值收费。还有很多例子是人们默认采用“免费增值”（freemium）策略，但那根本算不上一种策略。

---

### [01:17:56] Jeanne DeWitt Grosser

**English:**
A great example at Stripe, we launched Stripe Billings years ago. It had a freemium strategy because that's what you do. And then we sort of looked at it and we're like, "actually integrating straight billing takes a little bit of work. So if you do that, you're probably going to stay." And so we killed that, killed the free trial to zero downside. So that's another one. At Vercel, we've been going through that transition where we're a consumption-based business model ultimately, but at the outset we basically kind of bundled that into what looked like a SaaS-like price and as we've added a lot more functionality that wasn't working anymore.

**中文翻译:**
Stripe 有个好例子：多年前我们推出 Stripe Billing 时采用了免费增值模式，因为大家都这么干。后来我们发现，集成 Stripe Billing 其实需要一点工作量，一旦你集成了，你很可能就会留下来。于是我们取消了免费试用，结果完全没有负面影响。在 Vercel，我们也经历过这种转变：我们本质上是按用量计费的，但起步时我们把它打包成了一个看起来像 SaaS 的固定价格。随着功能增加，这种模式就不再奏效了。

---

### [01:18:40] Jeanne DeWitt Grosser

**English:**
And so we did an unbundling and right now actually we did a pretty substantial pricing change in August where we have an enterprise at a pro-skew. And if you looked at the enterprise skew, it's called Enterprise for a reason, enter, it's meant to be sold to an enterprise. And actually about half of the folks on the enterprise skew were startups, which suggests that there's stuff in the enterprise skew that a startup really wants. So we kicked a lot of that stuff out of the enterprise skew and made it so you could buy it self-serve online and what do you know, people are. So now that's really driven a lot of growth in our PLG funnel, which is awesome for startups because it's super efficient. They can just buy things, they want that. It's awesome for us because you don't have to have a human intermediate that.

**中文翻译:**
所以我们进行了拆解。今年 8 月我们做了一个重大的定价调整：我们有“专业版”和“企业版”。企业版之所以叫企业版，是因为它是卖给大企业的。但我们发现企业版里有一半客户其实是初创公司，这说明企业版里有初创公司非常想要的东西。于是我们把这些功能从企业版里拿出来，让它们可以在线自助购买。结果你猜怎么着？大家真的买了。这极大地推动了我们 PLG 漏斗的增长。对初创公司来说这很棒，因为效率极高；对我们来说也很棒，因为不需要人工介入。

---

### [01:19:24] Lenny Rachitsky

**English:**
Maybe just one more question before we get to a very exciting lightning round. It's going to be a combo question. I hear you have a hot take on sales comp, how to comp salespeople that's different from other people and also who to hire when you're hiring folks in sales. Can you just talk about your takes there?

**中文翻译:**
在进入精彩的闪电轮提问之前，还有一个组合问题。我听说你对销售薪酬（sales comp）有独特的见解，而且在招聘销售人员时也有自己的标准。能聊聊你的看法吗？

---

### [01:19:41] Jeanne DeWitt Grosser

**English:**
I struggle with sales comp because it's all about pay for performance, which I'm obviously a fan of, but it makes your organization less flexible because you basically have to decide 12 months in advance, these are things I value and particularly in this moment that could be different. As a great example of this, when we wrote the sales plans for this year at Vercel, the AI cloud did not exist. We were selling our front-end cloud and we were selling VZero and introduced the AI cloud halfway through the year. Now we had all sorts of good ways to still incentivize that, but I think you want to be able to be innovative and pivot and when you have a well-designed sales plan or a very structured sales plan, that can be challenging.

**中文翻译:**
我对销售薪酬感到纠结，因为它强调“按绩效付酬”，我当然支持这一点，但它会让组织缺乏灵活性。因为你必须提前 12 个月决定你重视什么，但在当今环境下，情况变化很快。比如我们制定今年的销售计划时，AI 云还没出现。我们当时在卖前端云和 V0，年中才推出 AI 云。虽然我们有办法激励销售去卖新产品，但如果你有一个非常死板的销售计划，想要创新和转型就会很困难。

---

### [01:20:44] Jeanne DeWitt Grosser

**English:**
So that's a little bit of my hot take is just I'm trying to figure out how do you have the upside of sales of motivates people. It's a quantitative function, which is great, but also the flexibility to change your mind because I think a lot of companies right now are having a hard time doing annual planning. So that's one. On profiles, I have always valued just sort of a diversified portfolio. So I strongly believe that sales is a skill and so you want salespeople with actual sales experience in your organization, but I think there's value in pairing them with more nontraditional backgrounds, in particular consulting or banking background.

**中文翻译:**
所以我的独特见解是：我一直在思考如何既保留销售激励的优势（它是定量的，这很好），又保留改变主意的灵活性。我认为现在很多公司在做年度计划时都很痛苦。关于人才画像，我一直看重“多元化组合”。我坚信销售是一项技能，所以你需要有实战经验的销售。但我认为将他们与非传统背景的人（特别是咨询或银行背景）搭配起来非常有价值。

---

### [01:21:40] Jeanne DeWitt Grosser

**English:**
Those folks are really good at more quantitative and analytical aspects of sales. So getting into that consultative part, which I think we talked about at the outset. And so I find that when you mix these together, the sort of consultant banker profile realizes, "Oh wait a minute, sales is a skill and I didn't really have it." And so they go learn from your account executives with that background and then your AEs learn more about, okay, how do I think about a P&L? How can I talk to a CFO? How do I present a TCO analysis more effectively? And so just creates a much richer learning environment where people are bouncing ideas off each other.

**中文翻译:**
这些人非常擅长销售中定量和分析的部分，也就是我们开头提到的“咨询式销售”。我发现当把他们混合在一起时，咨询/银行背景的人会意识到：“噢，原来销售是一项我并不具备的技能。”于是他们向资深 AE 学习。而 AE 们则学会了如何看损益表（P&L）、如何与 CFO 交流、如何更有效地展示总拥有成本（TCO）分析。这创造了一个更丰富的学习环境，大家可以互相启发。

---

### [01:22:22] Lenny Rachitsky

**English:**
That is awesome. I love that strategy. Okay, final question. Just is there anything else you wanted to share? Anything else you want to leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
太棒了，我喜欢这个策略。好，最后一个问题：在进入闪电轮之前，还有什么想分享的吗？有什么想留给听众的建议？

---

### [01:22:31] Jeanne DeWitt Grosser

**English:**
Oh man. I feel like we've been very thorough.

**中文翻译:**
噢天哪，我觉得我们已经聊得非常透彻了。

---

### [01:22:34] Lenny Rachitsky

**English:**
All right, thanks So too.

**中文翻译:**
好的，我也这么觉得。

---

### [01:22:35] Jeanne DeWitt Grosser

**English:**
Yeah, you stumped me on that one.

**中文翻译:**
是啊，你这个问题把我难住了。

---

### [01:22:38] Lenny Rachitsky

**English:**
Okay. That's the goal. With that Jeanne, we've reached our very exciting lightning round. I'm going to make it very quick. I know you got to run. I'm going to ask you just two questions. One is I'm going to skip to your life motto. Do you have a favorite life motto that you often come back to find useful in worker and life?

**中文翻译:**
好，这就是我的目的。Jeanne，我们进入闪电轮提问。我会很快，我知道你得赶时间。我只问两个问题。第一，你的“人生格言”是什么？有没有哪句话是你经常想起，并在工作和生活中觉得非常有用的？

---

### [01:22:54] Jeanne DeWitt Grosser

**English:**
I do. I actually have found that I'm known for saying a handful of things that I didn't necessarily realize it, but when you leave an organization, people tend to tell you what stuck with them. But there is one that I think I am known for saying growing up, my mom always said to me, when the going gets tough, the tough get going. And in sales, you're always going to have a quarter when you're not on pace. And so that's one that I feel like I pull on, not infrequently because in my view, there's another version of this, my mom also always says was where there's a will, there's a way. So I think you can always choose to find a path forward even when that's not super clear.

**中文翻译:**
有的。我发现我经常说的一些话连我自己都没意识到，但当我离开一个组织时，人们会告诉我哪些话让他们印象深刻。有一句我经常说，是我妈妈从小教我的：“疾风知劲草”（When the going gets tough, the tough get going）。在销售中，你总会遇到业绩达不到预期的季度。这句话我经常拿出来自勉。我妈妈还常说另一句：“有志者事竟成”。我认为即使前路不明，你总能选择找到一条出路。

---

### [01:23:45] Lenny Rachitsky

**English:**
I love these. Okay, last question. I read that you were a very competitive diver in college early on. I'm just curious if there's something you learned from that experience that brought with you that helps you be as successful as you've become?

**中文翻译:**
我喜欢这些格言。好，最后一个问题。我读到你大学早期是一名非常有竞争力的跳水运动员。我很好奇，你从那段经历中学到了什么，对你后来的成功有所帮助？

---

### [01:23:59] Jeanne DeWitt Grosser

**English:**
Well, I mean, first of all, I should say I was generally coming in third place out of three on my team. I managed to do it in college, but that was the extent of that career. So diving is a precision sport and it is a repetitive sport. And it is also a sport where when you land flat on your back, and literally as you are swimming to the side of the pool, welts are forming on it, you always 100% of the time will be forced to immediately get back on the diving board and do that exact same dive again. And so I think that has a lot of stuff that's transferable to work and to sales.

**中文翻译:**
首先我得说，我通常是我们队三个人里的第三名。我大学时确实在练，但也仅此而已。跳水是一项追求精准且不断重复的运动。而且在这项运动中，如果你背部着水平拍下去，当你游向池边时，背上已经开始起红疹了，但你 100% 会被要求立刻回到跳板上，再次完成那个同样的动作。我认为这有很多可以迁移到工作和销售中的东西。

---

### [01:24:50] Jeanne DeWitt Grosser

**English:**
So for me, I just have an obsession with excellence and within sales. sales is about replicability. How do you drive predictable outcomes, how excellent are you at your ability to forecast? And so I think I bring that to bear within sales a lot. And then similarly, you get a lot of nos in sales. So another phrase that a sales guru said to me once or in a training was yeses are great, nos are great, maybes will kill you. And so how do you get really comfortable that no is a great thing and that just gave you data and now you can go do something with it.

**中文翻译:**
对我来说，我对追求卓越有一种执念。在销售中，关键在于“可复制性”：你如何驱动可预测的结果？你的预测能力有多出色？我把这种执念带到了销售中。同样，在销售中你会听到很多“不”。一位销售大师曾在培训中对我说：“‘好’很棒，‘不’也很棒，但‘也许’会害死你。”所以，你要学会坦然接受“不”是一个好结果，因为它给了你数据，让你知道下一步该做什么。

---

### [01:25:25] Lenny Rachitsky

**English:**
This is a really inspiring and empowering way to end the conversation. Jeanne, thank you so much for being here.

**中文翻译:**
这是一个非常鼓舞人心且充满力量的结尾。Jeanne，非常感谢你能来。

---

### [01:25:33] Jeanne DeWitt Grosser

**English:**
Thanks so much for having me, Lenny. It was a lot of fun.

**中文翻译:**
非常感谢邀请我，Lenny。聊得很开心。

---

### [01:25:35] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这集很有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能帮助更多听众发现我们。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期再见。