# Jeffrey Pfeffer - Lenny's Podcast

---

# Jeffrey Pfeffer - Lenny's Podcast 深度分析报告

---

## 🎙️ 主持人介绍

**Lenny Rachitsky**
- **身份**: 硅谷顶级产品专家，前 Airbnb 产品负责人。
- **背景**: 在 Airbnb 任职 7 年，曾主导供应端增长（Supply Growth），将房源规模从数万提升至数百万。
- **现状**: 运营全球排名第一的产品与增长类播客《Lenny's Podcast》，其 Newsletter 拥有超过 60 万订阅者。
- **社交媒体**:
  - Twitter/X: [@lennysan](https://twitter.com/lennysan)
  - LinkedIn: [Lenny Rachitsky](https://www.linkedin.com/in/lennyrachitsky/)
  - 官网: [lennysnewsletter.com](https://www.lennysnewsletter.com/)

---

## 🎤 嘉宾介绍

**Jeffrey Pfeffer (杰弗瑞·普费弗)**
- **身份**: 斯坦福大学商学院（Stanford GSB）组织行为学教授，权力研究领域的全球权威。
- **职业经历**:
  - **斯坦福大学**: 执教超过 40 年，其课程《权力之路》(Paths to Power) 是斯坦福最受欢迎、最难选到的课程之一。
  - **学术成就**: 发表过 150 多篇论文，被誉为“组织理论界的泰斗”。
  - **著作**: 出版了 16 本书，包括《权力》(Power)、《领导力迷思》(Leadership BS) 以及本次讨论的核心《权力的七条规则》(7 Rules of Power)。
- **核心专长**: 组织政治、权力获取、人力资源管理、循证管理。
- **社交媒体**:
  - LinkedIn: [Jeffrey Pfeffer](https://www.linkedin.com/in/jeffreypfeffer/)
  - 个人网站: [jeffreypfeffer.com](https://jeffreypfeffer.com/)

---

## 📝 内容概要

本期播客被形容为斯坦福商学院的“鱼肝油”——听起来让人不适，但对职业健康至关重要。Jeffrey Pfeffer 教授打破了关于“领导力”的温情幻想，直面职场权力的残酷真相。他详细拆解了获取权力的七条核心规则，解释了为什么“好人”必须掌握权力才能成事，并提供了如何通过改变行为、语言和社交策略来提升个人影响力的具体方法。这不仅是一场关于职业晋升的对话，更是一次关于社会运行逻辑的深度揭秘。

---

## 🏷️ 核心话题

`职场政治` `权力获取` `个人品牌` `人际网络` `斯坦福商学院` `心理学`

---

## 💡 核心论点

### 论点一：权力是工具，而非道德评判

**核心观点**: 权力本身是中性的（如锤子或手术刀），其好坏取决于使用者。

- **工具论**: 就像医生用刀救人、歹徒用刀行凶，工具本身无罪。如果你希望世界变得更好，那么“好人”必须掌握权力。
- **现实主义**: 职场成功（薪水、晋升、幸福感）与“政治技能”高度相关，而非仅仅取决于工作表现。

> "If you want power to be used for good, more good people need to have power." (如果你希望权力被用于善途，那么更多的善人必须拥有权力。)
> — Jeffrey Pfeffer

### 论点二：打破“自我设限”是获取权力的第一步

**核心观点**: 很多人因为觉得权力“肮脏”或患有“冒充者综合征”而主动放弃竞争。

- **克服不适感**: 规则一“别挡自己的路”要求人们停止过度道歉和自我怀疑。
- **停止寻求好感**: 教授引用 Gary Loveman 的话：“如果你想被人喜欢，去养条狗。”在职场中，尊重和能力比“讨人喜欢”更重要。

### 论点三：权力是可以习得的“表演艺术”

**核心观点**: 权力感并非天生，而是通过特定的行为模式（Body Language）和策略展现出来的。

- **视觉优先**: 人们对“看起来像领导者”的人反应最积极。这包括眼神交流、开放式姿势、甚至适度的愤怒表达。
- **打破规则**: 规则二强调通过打破常规（如大胆提问、挑战现状）来获得关注和差异化竞争优势。

---

## ✅ 数据验证结果

**验证项 1**: 播客中提到的 Gerald Ferris 的“政治技能量表”（Political Skill Scale）。
- 原文声称: 政治技能与薪水、晋升、职业幸福感和压力减轻呈正相关。
- 验证结果: ✅ 确认。
- 来源: Ferris 等人在 2005 年发表于《Journal of Management》的研究《Development and Validation of the Political Skill Inventory》证实了政治技能对职业成就的预测作用。
- 可信度: ⭐⭐⭐

**验证项 2**: Omid Kordestani 是 Google 第 11 号员工并因此获得巨额财富。
- 原文声称: Omid 曾任职于 Netscape，后成为 Google 第 11 号员工，身价数十亿美元。
- 验证结果: ✅ 确认。
- 来源: [Forbes](https://www.forbes.com/profile/omid-kordestani/) 记录显示其曾任 Google 首席业务官，后任 Twitter 执行主席，是硅谷最成功的商业领袖之一。
- 可信度: ⭐⭐⭐

**验证项 3**: Mark Granovetter 的“弱连接”理论。
- 原文声称: 弱连接（非亲密关系）在找工作和获取新信息时比强连接更有效。
- 验证结果: ✅ 确认。
- 来源: 斯坦福社会学家 Mark Granovetter 1973 年的经典论文《The Strength of Weak Ties》，这是社会科学领域引用率最高的论文之一。
- 可信度: ⭐⭐⭐

---

## 🎯 四维分类评估

### 🟢 高度正确（已验证/权威来源）

**观点 1**: **表现（Performance）并不等同于晋升。**
- 验证依据: Pfeffer 在其著作《Power》中引用了多项研究，证明工作绩效与职业成就之间的相关性极低（约 0.1 到 0.2）。

**观点 2**: **打破规则能增加记忆点。**
- 验证依据: 心理学中的“孤立效应”（Von Restorff effect）支持了这一观点，即不寻常的事物更容易被记住。

### 🔵 当下可执行（有明确步骤）

**建议 1**: **建立个人品牌声明。**
- 执行方法: 明确你希望别人如何描述你，并在所有公开场合（LinkedIn、会议、邮件）一致地呈现这一形象。

**建议 2**: **列出 10 人名单。**
- 执行方法: 找出对你职业目标关键的 10 个人，研究如何通过“利他”方式（如分享文章、介绍资源）与他们建立联系。

### 🟡 理智质疑（需验证）

**存疑点**: **“成功可以洗白一切”（规则七）。**
- 质疑原因: 在当前的取消文化（Cancel Culture）和 ESG 监管环境下，过去的行为污点可能比以往更容易被挖掘并导致毁灭性后果。

### 🔴 需警惕（可能有问题）

**风险点**: **过度模仿“愤怒”或“侵入空间”等权力行为。**
- 风险说明: 如果缺乏底层实力支撑，单纯模仿这些行为可能被视为“职场霸凌”或“缺乏情商”，导致人际关系破裂。

---

## 🔑 关键洞察

1. **权力的“鱼肝油”属性**: 承认权力的存在是痛苦的，但无视权力运行逻辑的人往往会沦为他人的工具。
2. **中间人（Broker）价值**: 权力的核心在于控制资源流向。通过连接两个互不相识但能互惠的群体，你就能自动获得权力。
3. **自主权与权力的权衡**: Pfeffer 教授指出，极高的权力往往意味着极低的自主权（日程被填满、隐私丧失）。这是获取权力前必须考虑的代价。
4. **反直觉的“弱连接”**: 你的核心圈子（强连接）信息是冗余的，真正的机会往往来自那些你不太熟悉的人。
5. **行为塑造心理**: 即使你感到自卑，通过模仿强有力的姿势（Fake it till you make it），你的生理指标（如皮质醇下降）和心理状态也会随之改变。

---

## 🛠️ 提到的工具/资源

**工具 1**: **Political Skill Inventory (PSI)**
- 说明: 用于评估个人职场政治能力的量表。
- 链接: [可在学术数据库搜索相关题目进行自测]

**推荐阅读**: **《权力的七条规则》(7 Rules of Power)**
- 说明: Jeffrey Pfeffer 的集大成之作，总结了 40 年的研究精华。
- 链接: [Amazon 购买链接](https://www.amazon.com/7-Rules-Power-Surprising-Successful/dp/1637740441)

**推荐阅读**: **《You're Invited》 by John Levy**
- 说明: 关于如何通过举办活动和晚宴进行高质量社交的指南。

---

## 📋 行动建议

### 🚀 立即可做（今天）
- [ ] **停止过度道歉**: 在邮件或对话中，删掉“抱歉打扰”、“我不确定这是否有用”等削弱权力的开场白。
- [ ] **调整姿态**: 在下一次视频会议中，保持背部挺直，占据更多的镜头空间，增加眼神交流。

### 📅 本周尝试
- [ ] **弱连接触达**: 给一位半年没联系但很优秀的同行发一封邮件，分享一篇对他有价值的文章，不求回报。
- [ ] **品牌自查**: 搜索自己的名字，看看搜索结果是否符合你想要建立的专业形象。

### 🔍 深入探索
- [ ] **研究“中间人”机会**: 思考你的公司内有哪些部门之间存在沟通断层，尝试成为那个传递信息和资源的桥梁。

---

## ⭐ 评分

**知识价值**: 10/10
- 提供了极其罕见的、非滤镜版的职场运行逻辑。

**可执行性**: 8/10
- 规则清晰，但部分行为（如打破规则）需要极高的判断力。

**商业潜力**: 9/10
- 掌握这些规则能显著提升个人在组织内的资源调动能力。

**投入产出比**: 9/10
- 改变行为模式的成本极低，但潜在收益（晋升、加薪）巨大。

**综合评分**: **9.2/10**

---

## 📚 参考来源

- [Lenny's Podcast 官方网站](https://www.lennyspodcast.com/how-to-grow-your-power-jeffrey-pfeffer-stanford-gsb/)
- [Jeffrey Pfeffer 斯坦福大学主页](https://www.gsb.stanford.edu/faculty-research/faculty/jeffrey-pfeffer)
- [Gerald Ferris 政治技能研究](https://journals.sagepub.com/doi/10.1177/0149206305279602)

---
*来源*: Lenny's Podcast
*嘉宾*: Jeffrey Pfeffer
*生成时间*: 2024-05-22