# Jeffrey Pfeffer - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Jeffrey Pfeffer.

---

### (00:00:00) Lenny Rachitsky

**English:**
We're going to be talking about how to grow your power.

**中文翻译:**
我们将要讨论如何提升你的权力。

---

### (00:00:02) Jeffrey Pfeffer

**English:**
The reason why you should pay attention to this is because it leads to a lot of good things, salary, getting promoted, being happy in your career, being less stressed.

**中文翻译:**
你之所以应该关注这一点，是因为它会带来很多好处：高薪、晋升、职业生涯的幸福感，以及更少的压力。

---

### (00:00:11) Lenny Rachitsky

**English:**
You're not describing how the world should work. This is just how it is.

**中文翻译:**
你描述的并不是世界“应该”如何运作，而仅仅是它的“现状”。

---

### (00:00:15) Jeffrey Pfeffer

**English:**
Not only is, but how it was and how it will be.

**中文翻译:**
不仅是现状，也是过去的样子，以及未来的样子。

---

### (00:00:20) Lenny Rachitsky

**English:**
The Seven Rules of Power, get out of your own way, break the rules, show up in a powerful fashion, create a powerful brand, network relentlessly, use your power, and understand that once you've acquired power, what you did to get there will be forgiven, forgotten, or both.

**中文翻译:**
权力的七条规则：走出自我妨碍（别给自己设限）、打破规则、以有权势的方式亮相、打造强大的个人品牌、坚持不懈地建立人脉、运用你的权力，并且要明白，一旦你获得了权力，你为之付出的一切手段都会被原谅、被遗忘，或者两者兼有。

---

### (00:00:32) Jeffrey Pfeffer

**English:**
This is not about personality. These are skills they can be mastered.

**中文翻译:**
这与性格无关。这些都是可以掌握的技能。

---

### (00:00:35) Lenny Rachitsky

**English:**
People might be hearing this and they're like, "I don't want to be this person."

**中文翻译:**
人们听到这些可能会想：“我不想成为这样的人。”

---

### (00:00:38) Jeffrey Pfeffer

**English:**
Well, you already have done a fabulous job of illustrating principle one. That is one way to get in our own way. If I think power is dirty, the first thing that's going to happen is I'm not going to do what I need to do to be successful in my career.

**中文翻译:**
好吧，你已经非常出色地诠释了第一条原则。这就是我们“自我妨碍”的一种方式。如果我认为权力是肮脏的，那么首先发生的事情就是我不会去做那些在职业生涯中取得成功所必须做的事情。

---

### (00:00:52) Lenny Rachitsky

**English:**
The opening quote to your book that I have here, if you want power to be used for good, more good people need to have power.

**中文翻译:**
我这里有你书中的开篇名言：如果你想让权力被用于善途，就需要更多的好人拥有权力。

---

### (00:00:58) Jeffrey Pfeffer

**English:**
That's exactly right.

**中文翻译:**
一点没错。

---

### (00:01:03) Lenny Rachitsky

**English:**
Today, my guest is Jeffrey Pfeffer. Jeffrey is a Professor of Organizational Behavior at Stanford's graduate School of Business, and teaches one of the two most popular and oversubscribed courses in all of the MBA program, called the Paths to Power. The other class, by the way, is Touchy-Feely, which we dove into last month. In his class and in his recent book, the Seven Rules of Power, Jeffrey teaches the things that you can do in your life and in your work to build your power, and through that get things done and advance in your career. As one student described the class, it's the cod liver oil of the Graduate School of Business. You know it's good for you, but you feel a little nervous about it. In our conversation, we dig into each of the seven powers, why it's important to build these skills even if you feel uncomfortable.

**中文翻译:**
今天，我的嘉宾是杰弗里·普费弗（Jeffrey Pfeffer）。杰弗里是斯坦福大学商学院的组织行为学教授，他教授 MBA 课程中最受欢迎、选课人数最多的两门课程之一，名为“权力之路”（Paths to Power）。顺便说一下，另一门课是“感性课程”（Touchy-Feely，正式名称为人际动力学），我们上个月深入探讨过。在他的课堂上以及他最近的新书《权力的七条规则》中，杰弗里教授了你在生活和工作中可以做的、用来建立权力的事情，并以此来达成目标和晋升。正如一位学生对这门课的描述：它是商学院的“鱼肝油”——你知道它对你有好处，但你会感到有点紧张。在我们的对话中，我们将深入探讨这七种权力规则中的每一种，以及为什么即使你感到不舒服，培养这些技能也至关重要。

---

### (00:01:48) Lenny Rachitsky

**English:**
We talk through a bunch of examples of the power in action and the impact it has had on people's lives, why it isn't as cringey or scary as you may think. I was actually nervous to have this conversation and I ended up being a huge fan of Jeffrey and the work that he does. We end the conversation with what you can start doing today to start building your own power. This podcast is basically for anyone that wants to advance in their career, whether you're an IC or a CEO, and I'm really excited to bring it to you. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes, and it helps the podcast tremendously. With that, I bring you Jeffrey Pfeffer. Jeffrey, thank you so much for being here and welcome to the podcast.

**中文翻译:**
我们讨论了许多权力在实际操作中的例子及其对人们生活的影响，以及为什么它并不像你想象的那样令人尴尬或可怕。实际上，在进行这次对话之前我也很紧张，但最后我成了杰弗里及其研究成果的超级粉丝。在对话的最后，我们会讨论你今天就可以开始做些什么来建立自己的权力。这个播客基本上是为任何想要在职业生涯中取得进步的人准备的，无论你是个人贡献者（IC）还是首席执行官（CEO），我非常高兴能把它呈现给你们。如果你喜欢这个播客，别忘了在你的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对播客有巨大的帮助。那么，现在有请杰弗里·普费弗。杰弗里，非常感谢你能来到这里，欢迎来到本播客。

---

### (00:02:36) Jeffrey Pfeffer

**English:**
Thank you, Lenny. I am honored that you invited me on.

**中文翻译:**
谢谢你，伦尼。我很荣幸受邀参加。

---

### (00:02:40) Lenny Rachitsky

**English:**
I'm even more honored that you decided to come on. We're going to be talking about something that makes a lot of people uncomfortable. I think it's going to make me uncomfortable. We're going to be talking about how to grow your power in life and in business. Let me just start by asking why does this stuff make people uncomfortable, and why is it still important for people to learn how to do this well?

**中文翻译:**
你能决定来参加，我感到更加荣幸。我们将要讨论一些让很多人感到不舒服的话题。我想这也会让我感到不舒服。我们将讨论如何在生活和商业中提升你的权力。首先我想问，为什么这些东西会让人们感到不舒服？为什么学习如何做好这些事情对人们来说依然如此重要？

---

### (00:03:02) Jeffrey Pfeffer

**English:**
Well, it's important because a guy named Gerald Ferris developed a scale of political skill. And he and a bunch of his colleagues over the years did a lot of empirical research that demonstrates that political skill is associated with a lot of positive outcomes, salary, getting promoted, being happy in your career, being happy in your job, being less stressed. So the reason why you should pay attention to this is because it leads to a lot of good things. The reason why it makes people uncomfortable. You said it made you uncomfortable. Maybe I should ask you the question, why does it make you uncomfortable?

**中文翻译:**
嗯，这很重要，因为一位名叫杰拉尔德·费里斯（Gerald Ferris）的人开发了一套“政治技能”量表。多年来，他和他的同事们进行了大量的实证研究，证明政治技能与许多积极的结果相关：薪水、晋升、职业幸福感、工作愉快以及压力减轻。所以，你之所以应该关注这一点，是因为它会带来很多好事。至于为什么它让人不舒服——你说它让你不舒服，也许我该反问你：为什么它让你感到不舒服？

---

### (00:03:44) Lenny Rachitsky

**English:**
There's a lot of things here that are probably not how people want to live their life necessarily, or want other people to act.

**中文翻译:**
这里有很多事情可能并不是人们想要的生活方式，或者他们不希望别人也这样做。

---

### (00:03:51) Jeffrey Pfeffer

**English:**
Yeah, so I think it makes people uncomfortable because the realities of what it takes to get power bear almost no resemblance to what you're taught in Sunday school or the mosque or wherever, how your parents raised you. They bear almost no resemblance to how we think the world ought to be. They bear a little resemblance to our aspirations. And I think we look around the world and we see people who have acquired enormous amounts of power and have used it for bad. But I tell people, I see people with hammers hitting other people on the head. That does not mean that a hammer is not a useful tool. You can take a screwdriver and stab it into somebody's belly. I have a very dear friend who we'll probably talk about later in the podcast. Laura Esserman is a breast cancer surgeon, and I tell people, Laura has a knife. She uses it to cure cancer. Muggers have knives. They use it to rob people. So I think we've confused the tool for how it has been used.

**中文翻译:**
是的，我认为它让人不舒服是因为：获取权力所需的现实手段，与你在主日学校、清真寺或父母教导你的东西几乎没有任何相似之处。它们与我们认为世界“应该”有的样子几乎毫不相干，与我们的愿景也只有一点点相似。而且我认为，当我们环顾世界，看到那些获得了巨大权力并将其用于恶途的人。但我告诉人们，我看到有人用锤子砸别人的头，但这并不意味着锤子不是一个有用的工具。你可以拿螺丝刀刺入别人的肚子。我有一位非常亲爱的朋友，我们稍后可能会在播客中谈到她，劳拉·埃瑟曼（Laura Esserman），她是一名乳腺癌外科医生。我告诉人们，劳拉手里有刀，她用它来治愈癌症；劫匪手里也有刀，他们用它来抢劫。所以，我认为我们混淆了工具本身与其使用方式。

---

### (00:04:56) Lenny Rachitsky

**English:**
You also have this quote that the people who need to understand power and build their power skills are people who come from backgrounds or characteristics who would normally put them at a disadvantage.

**中文翻译:**
你还说过一句话：那些最需要理解权力和建立权力技能的人，是那些背景或特征通常使他们处于劣势的人。

---

### (00:05:04) Jeffrey Pfeffer

**English:**
I think that's exactly right. I will go this Sunday to Nashville Tennessee to talk to a bunch of people of color in the NFL who are trying to rise up the ranks. Stanford runs a program because the NFL is serious, I think, about trying to make more opportunity for people, underrepresented minorities. But these are folks who will not succeed unless they learn power skills, because the world is stacked against them in lots of ways.

**中文翻译:**
我认为这完全正确。这周日我要去田纳西州的纳什维尔，去和 NFL（美国职业橄榄球大联盟）中一群试图晋升的有色人种交谈。斯坦福大学运行着一个项目，因为我认为 NFL 是认真地想为那些代表性不足的少数族裔创造更多机会。但这些人除非学会权力技能，否则无法成功，因为这个世界在很多方面都对他们不利。

---

### (00:05:41) Lenny Rachitsky [Ad Break - Uizard]

**English:**
This episode is brought to you by Uizard, empowering product leaders to ideate and iterate faster than ever before with the power of AI... [Ad content omitted for brevity in translation but kept in English as per instructions]

**中文翻译:**
本集节目由 Uizard 赞助。Uizard 利用 AI 的力量，助力产品领导者以前所未有的速度进行构思和迭代。作为产品经理，我经常花几个小时截图，然后为团队标注反馈。有了 Uizard，我只需上传截图，它的 AI 就能将其转化为完全可编辑的 UI 设计，我可以在几分钟内进行调整并分享给团队。当我想要发挥创意，探索改进产品体验的全新方式时，我可以使用 Uizard 的 AI 通过简单的文本提示生成新的设计概念，并毫不费力地将其转化为交互式原型。超过 260 万人信任 Uizard 来加速产品生命周期的每个阶段并缩短上市时间。开发人员甚至可以将 UI 组件导出到 React 和 CSS 以加快开发速度。Uizard 的拖放编辑器非常易于使用，你可以与整个团队实时协作。甚至你的 CEO 和客户服务团队也可以参与其中。访问 uizard.io/Lenny 并使用代码 Lenny，即可享受 Uizard Pro 年度计划 25% 的折扣。

---

### (00:07:05) Lenny Rachitsky [Ad Break - Webflow]

**English:**
This episode is brought to you by Webflow... [Ad content omitted for brevity in translation but kept in English as per instructions]

**中文翻译:**
本集节目由 Webflow 赞助。大家都是朋友，所以让我们说点实在的。我们都知道你的网站不应该是一个静态资产，它应该是你推动转化的战略中动态的一部分。这是商业入门常识。但这里有一个数据：54% 的领导者表示网站更新耗时太长。这就是正在收听节目的你们中的一半以上。这就是 Webflow 的用武之地。他们的视觉优先平台允许你快速构建、发布和优化网页。这意味着你可以设定雄心勃勃的业务目标，而你的网站能够应对挑战。了解像 Dropbox、IDEO 和 Orange Theory 这样的团队如何信任 Webflow 来实现他们最宏伟的目标，请访问 Webflow.com。

---

### (00:07:51) Lenny Rachitsky

**English:**
Another element of your course that you try to make clear in your syllabus is to teach people not to be as judgmental. You also have this whole huge bold phrase, "This class is not for everyone." Can you just talk a bit about maybe why it's not for everyone and then why being less judgmental is important?

**中文翻译:**
你在教学大纲中试图明确的另一个课程元素是，教导人们不要那么爱评判（judgmental）。你还有一句加粗的话：“这门课并不适合所有人。”你能谈谈为什么它不适合所有人，以及为什么减少评判是重要的吗？

---

### (00:08:07) Jeffrey Pfeffer

**English:**
The class is extremely popular. I have a long waiting list. It's kind of mythical. And because of the principle of social influence, we are influenced by what other people do. We're influenced in our choices of restaurants, we're influenced in our choices of music. I'm not sure I like Taylor Swift, but I certainly want to go see Taylor Swift because everybody else is. And many people sign up for the class. And one year in particular, there were some people who sat in about the third row up, directly in front of me, and they looked every day like they were having some terrible thing put up some horrible orifice or something. They looked literally in pain, and so I decided, and of course they learned nothing. If you come to the class and you're in that much psychological discomfort, you're not going to learn anything.

**中文翻译:**
这门课非常受欢迎。我有一个很长的候补名单，它甚至带点神秘色彩。由于社会影响原则，我们会受到他人行为的影响。我们选择餐厅、选择音乐都会受影响。我不确定我是否喜欢泰勒·斯威夫特，但我肯定想去看她的演唱会，因为其他人都在去。很多人报名参加这门课。有一年特别明显，有几个人坐在我正前方大约第三排，他们每天看起来就像是在遭受某种可怕的酷刑。他们看起来简直是在痛苦中挣扎，所以我决定——当然，他们什么也没学到。如果你来上课时处于如此巨大的心理不适中，你将学不到任何东西。

---

### (00:08:55) Jeffrey Pfeffer

**English:**
And so what I try to do is tell people that in order to benefit from this class, you have to be open to learning the material. And if you're not, and by the way, this would be true for any class. If you go to physics and you say, I don't like physics, I hate physics, I don't believe in physics, I don't believe in the theory of physics, whatever, you're not going to learn anything. And so I'm trying to get the class, given those huge waiting lists, I'm trying to get the class to have people in it who are in fact going to benefit from it rather than sit there and look like they're in pain. And the judgmental thing, if Matthew 7, "Judge not that ye be not judged." The Koran says, "Only Allah can judge people." The American poet, Walt Whitman said, "Be curious, not judgmental."

**中文翻译:**
所以我试图告诉人们，为了从这门课中获益，你必须对学习这些材料持开放态度。如果你不开放，顺便说一下，这对任何课程都适用。如果你去上物理课，然后说我不喜欢物理、我讨厌物理、我不相信物理理论，那你什么也学不到。所以，考虑到那巨大的候补名单，我试图让课堂里坐着的是那些确实能从中获益的人，而不是坐在那里看起来很痛苦的人。至于“评判”这件事，《马太福音》第 7 章说：“你们不要论断人，免得你们被论断。”《古兰经》说：“唯有真主能审判人。”美国诗人沃尔特·惠特曼说：“要好奇，不要评判。”

---

### (00:09:46) Jeffrey Pfeffer

**English:**
Mother Teresa said, "If you judge people, you have no time to love them." Judgment, if I need to build a positive relationship with Lenny because you are on my critical path in my job, and jobs necessarily entail a reasonable amount of interdependence, I get things done through and with other people. If I decide that Lenny is whatever set of bad adjectives you want to use, dumb, incompetent, immoral, whatever, my ability to build a positive relationship with you, and you remain on my critical path, becomes almost zero unless you're a better actor or I'm a better actor than I think most people are.

**中文翻译:**
特蕾莎修女说：“如果你评判他人，你就没有时间去爱他们。”关于评判：如果我需要和伦尼建立积极的关系，因为你在我工作的“关键路径”上——工作必然涉及相当程度的相互依赖，我需要通过他人并与他人合作来完成任务。如果我认定伦尼是（随便你用什么贬义词）愚蠢、无能、不道德等等，那么我与你建立积极关系的能力几乎就变成了零，除非你或我是比大多数人更出色的演员，而你依然在我的关键路径上。

---

### (00:10:32) Jeffrey Pfeffer

**English:**
So therefore, you should suspend judgment in the sense that if somebody is on your critical path, the only judgment you should make is they're on my critical path. If I want to get something done, I need their collaboration and cooperation, and the fact that I may not like them is in fact irrelevant. And as I have taught senior executives over the years, it is absolutely clear to me that one of the skills that they have mastered is they have a skill that you cannot tell what they think of you. And that's important because I need your collaboration, I need your cooperation. And if I leak out in ways that say I don't respect you or I don't like you, I don't admire you, whatever, my odds of getting you to work productively with me goes essentially to zero. So that's a judgmental story. Does that make sense?

**中文翻译:**
因此，你应该暂停评判。如果某人在你的关键路径上，你唯一的评判应该是“他在我的关键路径上”。如果我想把事情办成，我需要他们的协作和配合，至于我是否喜欢他们，实际上是无关紧要的。多年来我教过很多高管，我非常清楚他们掌握的一项技能就是：你无法从他们的表现中看出他们对你的真实看法。这很重要，因为我需要你的协作。如果我流露出我不尊重你、不喜欢你或不欣赏你，那么让你与我高效合作的可能性基本上就归零了。这就是关于“评判”的故事。这有道理吗？

---

### (00:11:21) Lenny Rachitsky

**English:**
Absolutely. And I have a quote from your syllabus along these lines, "Not everyone we encounter in Paths to Power is someone you're going to want to emulate. This is a class about how to get things done, how to build and wield influence, and there are multiple ways to accomplish these objectives." So I've had two friends actually go through the course. One I asked about the course of the impact it had on her. She's actually a founder now. And she told me that your class was her single most favorite class at all of Stanford Business School, because it was realistic and applicable to life as a founder. Because it didn't sugarcoat business, didn't sugarcoat life. It told her how the world really works and it is helping her succeed with her startup right now.

**中文翻译:**
绝对有道理。我从你的教学大纲中摘录了一段类似的话：“我们在‘权力之路’中遇到的每一个人，并不都是你想要效仿的对象。这是一门关于如何达成目标、如何建立和运用影响力的课程，实现这些目标有多种途径。”我有两个朋友实际上修过这门课。我问过其中一个这门课对她的影响，她现在是一名创始人。她告诉我，你的课是她在整个斯坦福商学院最喜欢的一门课，因为它非常现实，且适用于创始人的生活。因为它没有美化商业，也没有美化生活。它告诉了她世界真实运作的方式，这正在帮助她在现在的创业中取得成功。

---

### (00:12:00) Jeffrey Pfeffer

**English:**
Thank you. There's no higher praise than that. I actually don't read, I shouldn't probably say this on the public, but I don't actually read my course evaluations because the impact I want to have is not to have people like me, but to have that kind of impact. To make people more successful, more effective in their lives.

**中文翻译:**
谢谢。没有比这更高的赞誉了。实际上我不读——我可能不该在公开场合这么说——但我实际上不读我的课程评估，因为我想要产生的影响不是让人们喜欢我，而是产生那种实质性的影响：让人们在生活中更成功、更有效率。

---

### (00:12:22) Lenny Rachitsky

**English:**
That is a good segue to one of your rules of power. So let's just talk about your Seven Rules of Power. I actually have your book right here and if folks want to learn more, here it is, Seven Rules of Power. This is your fourth book about power, and this is your best book about power, because it basically summarizes everything you've learned in a really cohesive way. So let me first share the Seven Rules of Power and then I'm going to dive into a few of them. Does that sound good?

**中文翻译:**
这正好可以引出你的权力规则之一。那么让我们来谈谈你的“权力的七条规则”。我手里就有你的书，如果大家想了解更多，就是这本《权力的七条规则》。这是你关于权力的第四本书，也是你写得最好的一本，因为它基本上以一种非常连贯的方式总结了你所学到的一切。让我先分享一下这七条规则，然后我再深入探讨其中的几条。听起来可以吗？

---

### (00:12:44) Jeffrey Pfeffer

**English:**
That sounds perfect.

**中文翻译:**
太完美了。

---

### (00:12:45) Lenny Rachitsky

**English:**
Okay, so the seven rules, one, get out of your own way. Two, break the rules. Three, appear powerful. Four, build a powerful brand. Network relentlessly. Use your power, and success excuses almost...

**中文翻译:**
好的，这七条规则是：一、走出自我妨碍；二、打破规则；三、表现得有权势；四、打造强大的品牌；五、坚持不懈地建立人脉；六、运用你的权力；七、成功可以掩盖几乎……

---

### (00:13:01) Jeffrey Pfeffer

**English:**
Everything, correct.

**中文翻译:**
一切，没错。

---

### (00:13:02) Lenny Rachitsky

**English:**
Okay, success excuses everything almost. Got it. Okay. So let me start with power four, which is around personal brand. And the reason I want to start here is I have a friend that's actually in your class right now, Ralph, and I saw that he started a podcast. And he told me that he did it because it was part of the homework that you give students. You call it Doing Power. Is that the name of the homework assignments?

**中文翻译:**
好的，成功几乎可以掩盖一切。明白了。那么让我从第四条规则开始，即关于个人品牌。我之所以想从这里开始，是因为我有一个朋友拉尔夫（Ralph）现在就在上你的课，我看到他开始做播客了。他告诉我他这么做是因为这是你给学生的作业的一部分。你称之为“践行权力”（Doing Power），这是作业的名字吗？

---

### (00:13:25) Jeffrey Pfeffer

**English:**
Yeah, I have. So we give them a bunch of assignments throughout the class, which are self-reflective assignments, but their big thing for the class is they have to do power. They have to do something during the quarter to take the principles of the class, and what they're learning, and put them into practice. And that is because everything I do, I do for a reason. That is because if you don't use what you learn, the learning will disappear. So if you go to a French class and you learn French, and you never speak French, in about a relatively short period of time you'll forget everything you learn. And so I want the learning to stick with them, so I try to get them to do something with it.

**中文翻译:**
是的。在整个课程中，我们会给他们布置一系列自我反思的作业，但课程的核心任务是他们必须“践行权力”。他们必须在学期中做一些事情，将课堂上的原则和所学知识付诸实践。这是因为我做的每一件事都有其原因。如果你不使用所学的知识，知识就会消失。就像你去上法语课学了法语，但如果你从不说法语，在相对较短的时间内你就会忘光。所以我希望这些知识能留在他们脑子里，因此我试图让他们用这些知识做点什么。

---

### (00:14:06) Lenny Rachitsky

**English:**
While we're on this tangent, I wanted to talk about this whole, you have a book, the Doing Knowing Gap.

**中文翻译:**
既然聊到了这个话题，我想谈谈你的那本书，《知行差距》（The Knowing-Doing Gap）。

---

### (00:14:10) Jeffrey Pfeffer

**English:**
Knowing-Doing Gap.

**中文翻译:**
是《知行差距》。

---

### (00:14:11) Lenny Rachitsky

**English:**
The Knowing-Doing Gap. So let's just spend a little time there. I think that's really important. What are some examples of things that have come out of people doing these homework assignments, things that maybe led to something interesting?

**中文翻译:**
《知行差距》。让我们在那儿多花点时间。我觉得这非常重要。有没有一些例子，是人们在完成这些作业时产生的，或者导致了一些有趣结果的事情？

---

### (00:14:22) Jeffrey Pfeffer

**English:**
Let me take my most extreme example. My most extreme example is probably Derek Kan, K-A-N. And Derek Kan was a little bit older when he went through the MBA program. And in 2012, his Doing Power project was to get appointed to be Mitt Romney's, it was Mitt Romney was running for president, to be head of economic policy for the Romney campaign. Believe it or not, he was offered the job. Believe it or not, he turned it down for reasons which we could go into if you want, but aren't that interesting. He wound up relatively soon thereafter as number three in the transportation department, working for Elaine Chao. And I have a picture of him when he comes to the class, I introduce him. I tell students, I give them a trigger warning and I introduce him. He wound up, at the end of the Trump administration, as the deputy director of the Office of Management and Budget. And since typical of the Trump administration, by that time there was no director. He essentially ran the $6 trillion US budget. This is six years out of business school.

**中文翻译:**
让我举一个最极端的例子。最极端的例子大概是德里克·坎（Derek Kan）。德里克读 MBA 时年龄稍大一些。2012 年，他的“践行权力”项目是争取被任命为米特·罗姆尼（Mitt Romney，当时正在竞选总统）竞选团队的经济政策负责人。信不信由你，他真的得到了那份工作。信不信由你，他拒绝了，原因我们可以深入探讨，但没那么有趣。此后不久，他成为了交通部的三号人物，在赵小兰（Elaine Chao）手下工作。他来上课时我有一张他的照片，我会向学生介绍他。我会给学生一个“触发警告”然后介绍他。在特朗普政府末期，他最终担任了管理和预算办公室（OMB）的副主任。由于典型的特朗普政府风格，当时没有主任，他实际上管理着 6 万亿美元的美国预算。这距离他从商学院毕业仅六年。

---

### (00:15:35) Lenny Rachitsky

**English:**
I was thinking whether he got that during his class. Amazing. Okay, so this is a success story of Doing Power. Let's talk about this first power of building brand, and I think this is where people start to feel uncomfortable. They're going to be like, oh no, I don't want to be doing this. This doesn't feel good to me.

**中文翻译:**
我还在想他是不是在课上就拿到了那个职位。太神奇了。好，这是“践行权力”的一个成功案例。让我们谈谈建立品牌的规则，我想这就是人们开始感到不舒服的地方。他们会想：噢不，我不想做这个，这让我感觉不好。

---

### (00:15:51) Jeffrey Pfeffer

**English:**
Why?

**中文翻译:**
为什么？

---

### (00:15:52) Lenny Rachitsky

**English:**
So let's talk about it.

**中文翻译:**
那我们就来聊聊。

---

### (00:15:53) Jeffrey Pfeffer

**English:**
Okay.

**中文翻译:**
好的。

---

### (00:15:54) Lenny Rachitsky

**English:**
Let's see. So talk about this power of building a personal brand.

**中文翻译:**
让我们看看。谈谈建立个人品牌的这种权力。

---

### (00:15:58) Jeffrey Pfeffer

**English:**
There are by definition fewer positions at the top than at the bottom. The world, we might not like this, and I know people, the late Tony Hsieh, the Zappos tried to do holacracy or whatever, but the world is essentially hierarchical. The animal kingdom is hierarchical. It is better to be at the top than at the bottom for a number of reasons. Okay. If that is true, if there are fewer positions at the top and then at the bottom, then your job to advance your career is to figure out how to get promoted. There are many ways to get promoted, but I will guarantee you one thing, no one is going to promote Lenny if they don't know who the hell you are. So it is not sufficient for them to know who you are. They have to know that you're smart and personable and have whatever skills you've got, but they have to know you.

**中文翻译:**
从定义上讲，顶层的职位肯定比底层的少。这个世界——我们可能不喜欢这一点，我知道像已故的谢家华（Tony Hsieh）在 Zappos 尝试过“合议制”（holacracy）之类的，但世界本质上是等级森严的。动物王国也是等级森严的。出于多种原因，处于顶层比处于底层更好。好，如果这是真的，如果顶层职位少而底层职位多，那么你推进职业生涯的任务就是弄清楚如何获得晋升。晋升有很多种方式，但我向你保证一件事：如果别人根本不知道你是谁，没人会提拔伦尼。所以，仅仅让他们知道你是谁是不够的。他们必须知道你聪明、有魅力，并拥有你所具备的技能，但前提是他们必须先知道你。

---

### (00:16:52) Jeffrey Pfeffer

**English:**
If they don't know you, you cannot choose what is not in your head. You know that better than I do. So therefore you have to do something to differentiate yourself. You have to build a brand. So when I think of Lenny in your podcast, I think of something. Not just 25 billion podcasts. When I think of somebody in McKinsey or Bay or BCG, one of the consulting firms, a gazillion people start off as front-line consultants. What are you going to do so that somebody knows who you are? What are you going to do that creates value for the firm and for you? So my friend Keith Ferazzi, when he started at Deloitte Consulting, did not do the spreadsheet stuff that he was, by the way, not very good at and didn't like. He started the Lincoln Quality Award. He decided to try to take Deloitte's brand recognition from about one or 2% to 30%.

**中文翻译:**
如果他们不知道你，他们就无法选择一个脑子里不存在的选项。你比我更清楚这一点。因此，你必须做点什么让自己脱颖而出。你必须建立一个品牌。所以当我想到伦尼和你的播客时，我会想到某些特质，而不仅仅是那 250 亿个播客中的一个。当我想到麦肯锡、贝恩或波士顿咨询公司（BCG）的人时，无数人从一线顾问做起。你要做什么才能让别人知道你是谁？你要做什么才能为公司和你自己创造价值？我的朋友基思·法拉奇（Keith Ferazzi）刚开始在德勤咨询工作时，并没有去做那些他既不擅长也不喜欢的电子表格工作。他发起了“林肯质量奖”。他决定尝试将德勤的品牌知名度从 1% 或 2% 提升到 30%。

---

### (00:17:54) Jeffrey Pfeffer

**English:**
He was appointed, though he left before he actually took the job, to the position of partner and the first chief marketing officer at Deloitte. I have another friend, Tristan Walker, who wanted to get hired at Foursquare. He sent emails to the founder. The founder ignored him. So Tristan Walker did something I think very bold. Tristan Walker began signing up partnerships. So one day the founder says, holy God, he signed up Starbucks. Maybe I ought to hire this guy. So you have to do something that causes people to know who you are, and that is what building a brand is about.

**中文翻译:**
他被任命为德勤的合伙人和首任首席营销官，尽管他在正式入职前就离开了。我还有另一个朋友特里斯坦·沃克（Tristan Walker），他想去 Foursquare 工作。他给创始人发了邮件，创始人没理他。于是特里斯坦做了一件我认为非常大胆的事：他开始帮公司签合作伙伴。直到有一天创始人说：“天哪，他签下了星巴克，也许我该雇佣这家伙。”所以，你必须做一些让人们知道你是谁的事情，这就是建立品牌的意义所在。

---

### (00:18:36) Lenny Rachitsky

**English:**
It sounds very benign put that way. When people hear, I need to build a personal brand, it sounds like I need to post on LinkedIn, I need to post on Twitter, start a newsletter, start a podcast, which I know is kind of a part of it. But what are some examples you've seen of ways to build a personal brand that are effective?

**中文翻译:**
这么说听起来很温和。但当人们听到“我需要建立个人品牌”时，听起来就像是我需要在 LinkedIn 上发帖，在 Twitter 上发帖，创办时事通讯，开播客——我知道这确实是其中的一部分。但在你看来，有哪些建立个人品牌的有效例子？

---

### (00:18:50) Jeffrey Pfeffer

**English:**
So I have a friend who I bring to the class, a lovely tall Asian woman named Laura Chau, who made partner at a venture capital firm after four years, which is fast. Laura works for Canaan Partners, C-A-N-A-A-N. Laura said, I do not work for Andreessen Horowitz, I do not work for Sequoia, I don't work for Greylock, I don't work for any of these very visible large VC firms. So if I am going to get deals in the consumer space, that's her domain of expertise is consumer and consumer tech, somebody is going to have to know who Laura Chau is. Because again, you're not going to get the deal if nobody knows who you are. And so she basically did everything you talked about. She did writing. She started a podcast in which she invited influential people on. She contributed to a book. She helped people out.

**中文翻译:**
我有一个朋友，我也把她请到了课堂上，她叫劳拉·周（Laura Chau），是一位身材高挑、可爱的亚裔女性。她在一家风险投资公司工作四年就成了合伙人，这非常快。劳拉在 Canaan Partners 工作。劳拉说：“我不在安德森·霍洛维茨（a16z）工作，我不在红杉资本工作，也不在 Greylock 工作，我不在任何这些极具知名度的大型风投公司工作。所以，如果我想在消费领域拿到交易（那是她的专业领域：消费和消费科技），就必须有人知道劳拉·周是谁。”因为再说一遍，如果没人知道你是谁，你就拿不到交易。所以她基本上做了你提到的所有事情：她写作，她开了一个播客并邀请有影响力的人参加，她参与编写了一本书，她帮助别人。

---

### (00:19:55) Jeffrey Pfeffer

**English:**
She did networking dinners. She did everything she could so that people would recognize and know Laura Chau. And one of the things she did was she's tall. In general, Asian women are not tall. She decided to play up the fact that she was, in the words of some people, the tallest Asian woman they'd ever seen. She wears heels. In her heels she's six feet one inches tall. She also, when she comes to my class, many people come to my class with hoodies, God knows what. She has style and it's a unique style. So she thinks about very strategically, how am I going to dress? How am I going to look? How am I going to show up? How am I going to do what I need to do so that people know who I am? Obviously there's substance. If you have visibility without substance, people will know you're useless. But if you have substance without visibility, no one will know the substance that you got.

**中文翻译:**
她举办人脉晚宴。她竭尽所能让人们认出并了解劳拉·周。她做的一件事是利用自己的身高。通常亚裔女性并不高，她决定强化这一特点，用某些人的话来说，她是他们见过的最高的亚裔女性。她穿高跟鞋，穿上鞋后身高 1 米 85。而且，当她来我班上时——很多人穿着连帽衫或天知道什么衣服来——她非常有型，而且风格独特。所以她非常具有战略性地思考：我该如何着装？我该呈现什么样的形象？我该如何亮相？我该如何做我需要做的事，好让人们知道我是谁？显然，这需要有真才实学。如果你只有知名度而没有实力，人们会发现你没用；但如果你有实力却没有知名度，没人会知道你有多厉害。

---

### (00:20:56) Lenny Rachitsky

**English:**
You also talk about how you can reframe this idea of not being self-promotional, but it's amplifying the impact of the team that I work with, or it's me scaling myself by sharing things I know and pointing people to it.

**中文翻译:**
你也谈到了如何重构这个想法：不是在进行“自我推销”，而是在放大我所在团队的影响力，或者通过分享我所知道的东西并引导人们关注它，来实现自我的规模化。

---

### (00:21:11) Jeffrey Pfeffer

**English:**
Absolutely, absolutely.

**中文翻译:**
完全正确，绝对如此。

---

### (00:21:11) Lenny Rachitsky

**English:**
Awesome. Okay, let's move on to a different power. Let's talk about power one, which is getting out of your own way. Talk about what that means and how someone can work on that.

**中文翻译:**
太棒了。好，让我们转向另一条规则。谈谈第一条规则：走出自我妨碍。谈谈这意味着什么，以及人们该如何在这方面下功夫。

---

### (00:21:20) Jeffrey Pfeffer

**English:**
Well, you already have done a fabulous job of illustrating principle one by talking about how this is the topic that makes people uncomfortable. And when something makes people uncomfortable, in general, they're going to shy away from it. So if I think power is dirty, if I think power is evil, if I think power is something I want nothing to do with, the first thing that's going to happen is I'm not going to do what I need to do to be successful in my career. So that is one way in which we get in our own way. Another way in which we get in our own way, many people suffer from what is called in the psychology literature, imposter syndrome. They believe that they were the admissions mistake at Stanford. They were the hiring mistake in whatever company they're working for. That somehow they got to this job, but they don't really deserve to be there because they're surrounded by people who are smarter and better than them, and therefore they will do things.

**中文翻译:**
嗯，你已经通过谈论这个话题如何让人感到不舒服，非常出色地诠释了第一条原则。当某件事让人感到不舒服时，通常人们会回避它。所以，如果我认为权力是肮脏的、邪恶的，或者是我不想沾染的东西，那么首先发生的就是我不会去做那些在职业生涯中取得成功所必须做的事情。这就是我们自我妨碍的一种方式。另一种方式是，许多人患有心理学文献中所说的“冒充者综合征”（imposter syndrome）。他们认为自己是斯坦福大学录取的失误，或者是所在公司的招聘失误。他们觉得自己虽然得到了这份工作，但并不配待在那里，因为周围的人都比他们聪明、优秀，因此他们会做出一些行为。

---

### (00:22:18) Jeffrey Pfeffer

**English:**
I can't even believe that this goes on. So I will have students, not many, but a few. Now raise their hand, I'll call them, and the first things out of their mouth will be, I don't know if this comment is going to be useful. This is called pre-emptory apology. If the comment is not going to be useful, don't say it. That's number one, but number two, don't apologize. Pardon me for interrupting. Pardon me for taking up your time. Stop all this apologizing. If you got the job you're in, you probably are not only qualified, you're probably overqualified. So don't use descriptors of yourself that disempower you. Don't think of yourself as not deserving of the job that you hold, because that attitude will leak out and other people will say, if Lenny doesn't think he deserved the job, then maybe I shouldn't think he deserves the job either.

**中文翻译:**
我简直不敢相信这种事一直在发生。我会有一些学生——不多，但有几个——举手发言，我叫到他们时，他们开口第一句话就是：“我不知道这个评论是否有用。”这被称为“先发制人的道歉”。如果评论没用，那就别说，这是第一点；第二点，不要道歉。不要说“抱歉打断一下”、“抱歉占用了你的时间”。停止这些道歉。如果你得到了现在的工作，你可能不仅是合格的，甚至可能是资历过高的。所以，不要使用那些削弱你力量的词来描述自己。不要认为自己不配拥有现在的职位，因为这种态度会流露出来，别人会想：“如果伦尼觉得自己不配这份工作，那也许我也该觉得他不配。”

---

### (00:23:19) Lenny Rachitsky

**English:**
So basically the first power is you're shooting yourself in the foot by worrying too much about whether people like you. This friend of mine who's now the founder that I read some quotes from, she said her number one takeaway from your class is if you want to be liked, get a dog.

**中文翻译:**
所以基本上第一条规则是：你因为太担心别人是否喜欢你而搬起石头砸自己的脚。我那位现在是创始人的朋友，我刚才读过她的一些话，她说她从你课上学到的第一要义是：如果你想被人喜欢，养条狗吧。

---

### (00:23:32) Jeffrey Pfeffer

**English:**
That's correct. That is a quote from my dear friend Gary Loveman, who for many years ran Harrah's, which then became Caesars, the casino company.

**中文翻译:**
没错。那是我的好友加里·洛夫曼（Gary Loveman）的名言，他多年来经营哈拉斯娱乐（Harrah's），也就是后来的凯撒皇宫赌场公司。

---

### (00:23:43) Lenny Rachitsky

**English:**
You also talk about this. Yeah, there's this quote I have. "Acknowledge that others are often no better than you, because that makes you feel better about the story." So for people that actually want to be liked, I like being liked. I don't know if it's a flaw in my upbringing. Is the lesson you're capped on your power if you worry about if you want to be liked?

**中文翻译:**
你也谈过这个。是的，我这里有一句引用：“承认别人通常并不比你强，因为这会让你对现状感觉好一些。”那么对于那些确实想被人喜欢的人——我就喜欢被人喜欢，我不知道这是不是我成长过程中的一个缺陷。这个教训是说，如果你担心自己是否被人喜欢，你的权力就会受到限制吗？

---

### (00:24:05) Jeffrey Pfeffer

**English:**
At the end of the day, you don't want to be intentionally disliked. You don't want to violate my dear friend Bob Sutton's book The No Asshole Rule and gratuitously be an asshole. But you are hired to get a job done. It's interesting. I unfortunately am now too old. In the words of my chiropractor, I'm suffering from too many birthdays. So I have a lot of doctors who are doing a great job. Trust me, when I choose a doctor, I have a, unfortunately he retired, a neurosurgeon who did two surgeries on my spine. He's considered to be one of the top 20 in the country. If you go on Yelp, you read about his personality and his office furniture. As I said to somebody, he's doing microsurgery on my spine, I can wind up permanently paralyzed. I really don't care about his personality. I don't care about his office furniture.

**中文翻译:**
归根结底，你不想被故意讨厌。你不想违反我好友鲍勃·萨顿（Bob Sutton）在《拒绝混蛋规则》一书中所说的，无缘无故地做一个混蛋。但你被雇佣是为了完成工作的。这很有趣。不幸的是，我现在年纪太大了。用我的脊椎按摩师的话说，我患有“生日过剩症”。所以我有很多表现出色的医生。相信我，当我选择医生时——我有一位神经外科医生，不幸的是他退休了，他给我的脊椎做过两次手术。他被认为是全美排名前 20 的专家。如果你去 Yelp 上看，你会读到关于他的性格和办公室家具的评价。正如我对某人说的，他正在给我的脊椎做显微手术，我可能会永久瘫痪，我真的不在乎他的性格，也不在乎他的办公室家具。

---

### (00:25:01) Jeffrey Pfeffer

**English:**
That's an extreme example, but it makes the point. When you are put in a role, you are put in a role because presumably you are supposed to perform in that role. If you get appointed to be a head coach, if we make you a quarterback on an NFL team, or we make you center on a National Basketball Association team, you did not get that job because people thought you had a cute personality. You got that job because you have the skills to make your organization successful. And if you do not use those skills because you're worried about what everybody else is thinking, you are not only harming yourself, but you're harming them because you are not doing what you were hired to do.

**中文翻译:**
这是一个极端的例子，但它说明了问题。当你被安排在一个角色中，是因为你被期望在这个角色中有所表现。如果你被任命为主教练，或者我们让你担任 NFL 球队的四分卫，或者 NBA 球队的中锋，你得到那份工作不是因为人们觉得你性格可爱。你得到那份工作是因为你有能力让你的组织获得成功。如果你因为担心别人的想法而不敢使用这些技能，你不仅在伤害自己，也在伤害他们，因为你没有履行被雇佣的职责。

---

### (00:25:46) Lenny Rachitsky

**English:**
So a simple way of thinking about this, which makes me feel better about. As we talk through this, I'm becoming less uncomfortable with these, which is a good sign. It's don't actively try to be disliked. Don't prioritize being liked, prioritize competence and respect.

**中文翻译:**
所以一种简单的思考方式是——这让我感觉好多了。随着我们的交谈，我对这些内容的不适感正在减轻，这是一个好迹象。那就是：不要主动寻求被讨厌，但也不要优先考虑被喜欢，而要优先考虑能力和尊重。

---

### (00:25:59) Jeffrey Pfeffer

**English:**
Correct, absolutely.

**中文翻译:**
没错，绝对如此。

---

### (00:26:01) Lenny Rachitsky

**English:**
And doing the thing that needs to be done.

**中文翻译:**
并且去做那些必须做的事情。

---

### (00:26:03) Jeffrey Pfeffer

**English:**
Absolutely.

**中文翻译:**
绝对正确。

---

### (00:26:04) Lenny Rachitsky

**English:**
Okay, great. Let's talk about rule number two, which is break the rules. So basically again, these powers are ways to grow power, and you're saying that if you break the rules, you get more power. Talk about why that's the case, what that looks like.

**中文翻译:**
好的，太棒了。让我们谈谈第二条规则：打破规则。基本上，这些权力规则是增长权力的方法，而你说如果你打破规则，你会获得更多权力。谈谈为什么会这样，以及这看起来是什么样的。

---

### (00:26:18) Jeffrey Pfeffer

**English:**
Well, for many reasons, number one, when you break the rules, you stand out. You become memorable when you do something that's unexpected. And being memorable is of course important, as we've already discussed. That's number one. Number two, the rules were made mostly by the people who are favored by the rules in place. So if we were talking about business strategy, we would talk about a word that is probably now overused. We would talk about being a disruptor. That you would disrupt an industry. And how do you disrupt an industry? By doing something that is different from the other industry incumbents. In Southwest Airlines, you don't do hub and spoke. At Amazon, you provide an incredible level of customer service. Whole Foods, you don't optimize on the cost of the stuff in your store, but you optimize on fitting local taste, whatever. You would be a disruptor, you would do things that are different.

**中文翻译:**
嗯，原因有很多。第一，当你打破规则时，你会脱颖而出。当你做了一些出人意料的事情时，你会让人难忘。正如我们讨论过的，让人难忘当然很重要。这是第一点。第二，规则大多是由那些受惠于现行规则的人制定的。如果我们谈论商业战略，我们会用到一个现在可能被过度使用的词：颠覆者（disruptor）。你会颠覆一个行业。你如何颠覆一个行业？通过做一些与行业内其他现有企业不同的事情。在西南航空，你不搞“枢纽辐射制”；在亚马逊，你提供令人难以置信的客户服务水平；在 Whole Foods，你不在店内商品的成本上优化，而是在迎合当地口味等方面进行优化。你会成为一个颠覆者，你会做不同的事情。

---

### (00:27:14) Jeffrey Pfeffer

**English:**
The same principle holds for you, that if you are going to be successful, you have to do what number one, plays to your strengths, to use the title of a Gallup book. Number two, you have to do things again that cause you to stand out, and you have to do things that basically will make you more successful. One of the conventional wisdoms that people I think adhere to way too much, is don't ask. Don't ask, don't ask for help. You need to show self-sufficiency. So my colleague, Frances Flynn, Frank Flynn, wrote an article with Vanessa Lake entitled, If You Need Help, Just Ask. And it turns out people overestimate how many people they're going to have to ask to get help, and it turns out that asking for help makes people uncomfortable.

**中文翻译:**
同样的原则也适用于你。如果你想获得成功，首先你必须做那些能发挥你优势的事情（借用盖洛普一本书的标题）。第二，你必须再次做那些能让你脱颖而出的事情，做那些基本上能让你更成功的事情。我认为人们过度信奉的一种传统观念是“不要开口”。不要开口，不要寻求帮助，你需要表现出独立自主。我的同事弗兰克·弗林（Frank Flynn）和凡妮莎·莱克（Vanessa Lake）写过一篇名为《如果你需要帮助，尽管开口》的文章。结果发现，人们高估了为了获得帮助而必须请求的人数，而且寻求帮助确实会让人们感到不舒服。

---

### (00:28:03) Jeffrey Pfeffer

**English:**
I was married, if you read the acknowledgments in Seven Rules of Power. For more than 35 years I was married to Kathleen Francis Fowler, who I could send you a picture. She looked literally like a supermodel and I never have been any particularly better looking than I am now. So somebody said to me, how'd you get her to go out with you? And the answer of course is, I asked. I asked, I asked, I asked. No one, well, maybe not no one. But few people are going to go out with you if you don't ask them out. Few people are going to marry you if you don't ask them to marry. Few people are going to do anything if you don't ask. And what is the worst that could happen? If you ask and they say, no, you are no worse off than had you not asked in the first place. If you don't ask, you're not going to get it. If you ask and they say, no, you're not going to get it. Get over your ego, ask.

**中文翻译:**
如果你读过《权力的七条规则》的致谢辞，你会发现我结婚了。我与凯瑟琳·弗朗西斯·福勒（Kathleen Francis Fowler）结婚超过 35 年，我可以给你发张照片，她看起来简直像个超模，而我从来没比现在更好看过。有人问我：“你是怎么让她答应和你约会的？”答案当然是：我开口问了。我问了，我问了，我问了。没人——好吧，也许不是没人，但如果你不约别人，很少有人会主动和你约会。如果你不求婚，很少有人会嫁给你。如果你不开口，很少有人会为你做任何事。最坏的情况是什么？如果你问了，他们说不，你的处境并不比你当初没问时更糟。如果你不问，你得不到；如果你问了被拒绝，你也得不到。放下你的自尊，去开口问。

---

### (00:28:59) Lenny Rachitsky

**English:**
Is there another example that comes to mind of someone breaking the rules say in business, that ended up being really successful as a result, or just someone that is really good at this in business?

**中文翻译:**
你还能想到其他在商业中打破规则并最终取得巨大成功的例子吗？或者仅仅是某个在商业中非常擅长此道的人？

---

### (00:29:07) Jeffrey Pfeffer

**English:**
I can give you many examples. One of my favorite examples would be Jason Calacanis. I don't know if you know Jason.

**中文翻译:**
我可以给你举很多例子。我最喜欢的例子之一是杰森·卡拉卡尼斯（Jason Calacanis）。我不知道你是否认识杰森。

---

### (00:29:14) Lenny Rachitsky

**English:**
Oh yeah, I know you did a case study on him. I know him well. Yeah.

**中文翻译:**
噢是的，我知道你对他做过案例研究。我很了解他。

---

### (00:29:18) Jeffrey Pfeffer

**English:**
So I think Jason, I think consistently breaks all kinds of rules. First of all, when he comes to my class, nobody likes him, but that's okay. Almost nobody likes him. But...

**中文翻译:**
我认为杰森一直在打破各种规则。首先，当他来我班上时，没人喜欢他，但这没关系。几乎没人喜欢他。但是……

---

### (00:29:30) Lenny Rachitsky

**English:**
That's power number one. He's not worried about.

**中文翻译:**
那是第一条规则。他不担心这个。

---

### (00:29:33) Jeffrey Pfeffer

**English:**
Yeah, that's number one. But also I think there's a conventional wisdom in the venture capital industry which he defies almost completely. He makes a lot of little bets, not a few big bets. He runs a very lean operation. He doesn't have a lot of partners. He doesn't have actually any partners, so he can't be fired by his partners. He began his career in journalism, which is interesting. Being a journalist is a wonderful job because you get to ask people all kinds of questions. And if you ask smart people questions, and you have some reasonable level of intelligence yourself, at the end of that process, you're going to wind up incredibly smart and incredibly insightful. And he wound up incredibly smart and insightful around aspects of the internet industry.

**中文翻译:**
是的，那是第一条。而且我认为风险投资行业有一些传统观念，他几乎完全蔑视这些观念。他做很多小额投注，而不是少数几笔大额投注。他的运营非常精简。他没有很多合伙人，实际上他没有任何合伙人，所以他不会被合伙人解雇。他职业生涯始于新闻业，这很有趣。当记者是一份很棒的工作，因为你可以问人们各种各样的问题。如果你向聪明人提问，而你自己也有一定的智力水平，在这个过程结束时，你会变得极其聪明且极具洞察力。他在互联网行业的各个方面都变得极其聪明和敏锐。

---

### (00:30:23) Lenny Rachitsky

**English:**
And he definitely has a lot of power. I think I am going to link to the case study in our show notes where you basically walk through how he went from nothing to a very powerful person.

**中文翻译:**
他确实拥有巨大的权力。我想我会把那个案例研究链接到我们的节目笔记中，你在那里基本上详细描述了他如何从一无所有变成一个非常有权势的人。

---

### (00:30:31) Jeffrey Pfeffer

**English:**
And by the way, a very rich person as well.

**中文翻译:**
顺便说一下，他也是个非常富有的人。

---

### (00:30:34) Lenny Rachitsky

**English:**
Let's talk about another power, power five, networking relentlessly. What does that look like and how do you get better at this?

**中文翻译:**
让我们谈谈另一条规则，第五条：坚持不懈地建立人脉。这看起来是什么样的，以及如何在这方面做得更好？

---

### (00:30:42) Jeffrey Pfeffer

**English:**
Well, I think there's research that shows that many people find networking dirty, and that's because I think they think about it in the wrong way. My friend John Levy, who has written a fabulous book, You're Invited. Which is a book about how to put on events that people want to come to. Is a fabulous human being. Will tell you that the first principle of networking is in fact generosity. It's generosity. What can I do for you? How can I be helpful? Who can I introduce you to? Either a company or a product or a person who can be helpful to you in your career.

**中文翻译:**
嗯，我认为有研究表明，许多人觉得建立人脉很肮脏，我认为这是因为他们的思考方式不对。我的朋友约翰·利维（John Levy）写过一本很棒的书《受邀》（You're Invited），那是关于如何举办人们想参加的活动的。他是一个非常棒的人。他会告诉你，建立人脉的第一原则实际上是慷慨。是慷慨。我能为你做什么？我能提供什么帮助？我能把你介绍给谁？无论是介绍一家公司、一个产品，还是一个对你职业生涯有帮助的人。

---

### (00:31:20) Jeffrey Pfeffer

**English:**
But in order to be able to introduce you to someone who's going to be useful to you, I have to know people. If I don't know anybody, I can't introduce you to anybody. And the more people I know, the more likely it will be that if you say, I need to know somebody in X, I will know that person. So the broader your social network, the more people and the more things you will know. If knowledge is power, networking is a fabulous way to get knowledge about people and about ideas.

**中文翻译:**
但为了能把你介绍给对你有用的人，我必须先认识人。如果我不认识任何人，我就无法把你介绍给任何人。我认识的人越多，当你提出“我需要认识 X 领域的某人”时，我就越有可能认识那个人。所以，你的社交网络越广，你认识的人和知道的事情就越多。如果知识就是力量，那么建立人脉就是获取关于人和想法的知识的绝佳途径。

---

### (00:31:53) Lenny Rachitsky

**English:**
It's funny to hear this where it's like, yes, obviously this is right, but connecting it to if you want to become more powerful, more successful, you need to do this. I think that is a powerful point that we're all making here, is just like this actually is necessary if you want to acquire more power.

**中文翻译:**
听起来很有趣，就像是“是的，这显然是对的”，但把它与“如果你想变得更有权势、更成功，你就必须这样做”联系起来。我认为我们在这里达成了一个强有力的观点：如果你想获得更多权力，这实际上是必要的。

---

### (00:32:10) Jeffrey Pfeffer

**English:**
Of course. I have a funny story about networking. So we have a thing in Stanford called View From The Top, in which these fancy people come in and give a talk. And one of the people came in and give a talk and made my class instantly popular, because he's an extraordinarily wealthy person. His name is Omid Kordestani, and so I reached out to him and I said, "Omid, let's have breakfast." So I can understand because during the thing, when somebody asked them what class was the most important in his success, he said mine. So I said, "Tell me your story." He said, "Well, I graduated from Stanford. I'm Persian in background, immigrant background. An engineer, HP, all the things that would make you kind of a nerd or something." He said, "I went to work for a couple of startups that didn't do well. Then I found myself in the mid-nineties at Netscape." The browser company, big deal. Anyway, Marc Andreessen.

**中文翻译:**
当然。关于建立人脉，我有一个有趣的故事。斯坦福有一个叫“顶峰视野”（View From The Top）的活动，邀请一些大人物来演讲。其中一个人来演讲后，让我的课瞬间变得火爆，因为他是一个极其富有的人，他叫欧米德·柯德斯塔尼（Omid Kordestani）。于是我联系了他，说：“欧米德，我们一起吃个早餐吧。”我想了解一下，因为在演讲中，当有人问他哪门课对他的成功最重要时，他说是我的课。所以我说：“给我讲讲你的故事。”他说：“嗯，我从斯坦福毕业。我是波斯裔背景，移民背景。一名工程师，在惠普工作过，所有这些都会让你看起来像个书呆子之类的。”他说：“我去过几家表现不佳的初创公司。然后 90 年代中期，我去了网景（Netscape）。”那家浏览器公司，当时的大事件。总之，马克·安德森（Marc Andreessen）也在那儿。

---

### (00:33:07) Lenny Rachitsky

**English:**
Oh yeah.

**中文翻译:**
噢是的。

---

### (00:33:08) Jeffrey Pfeffer

**English:**
Okay. "So I found myself in Netscape in marketing and business development. I was not making any progress. One day I decided to take your class to an extreme. I decided to stop doing my job." So I said, "When people gave you projects to do or assignments or tasks and you didn't do them?" He said, "It turns out that I spent my time, not obviously at the bar, but in networking first with people inside of Netscape. And it turns out if you're well-connected to the senior leaders, they don't really care if you do your job or not. That's number one. Number two," he said, "oftentimes I can find other people to do the work I was doing. So instead of basically spending time doing my job, I networked first within Netscape." But Netscape was not that big of a company. So after a while he decided to go through, which is by the way, his job anyway, in marketing and business, he decided to basically drive through the Silicon Valley talking to people. And this is the rest of the browsers are just beginning.

**中文翻译:**
好。“我在网景负责市场和业务开发。我当时没取得任何进展。有一天，我决定把你的课发挥到极致：我决定停止做我的本职工作。”于是我问：“当人们给你项目、作业或任务时，你都不做吗？”他说：“结果是，我把时间花在了——显然不是在酒吧——而是首先与网景内部的人建立人脉。事实证明，如果你与高级领导层关系良好，他们并不真的在乎你是否做了本职工作。这是第一点。第二点，”他说，“通常我可以找到其他人来做我正在做的工作。所以，我没有把时间花在做本职工作上，而是首先在网景内部建立人脉。”但网景并不是一家那么大的公司。所以过了一段时间，他决定——顺便说一下，这本来也是他在市场和业务开发方面的工作——他决定开车穿过硅谷，去和人们交谈。当时其他浏览器才刚刚起步。

---

### (00:34:14) Jeffrey Pfeffer

**English:**
Nobody knows what a browser is, nobody knows what the internet is going to become. So he's having all these fabulous conversations. All right, so he now knows basically everybody. It's 1998 and a little tiny company decides 10 engineers, typical Silicon Valley company. 10 engineers, all engineers. I have a friend who went to work for a company, run a company that had 26 people. He didn't have one sales and marketing person. Anyway, the company now has 10 engineers. They decide they need to hire their first business person. Being an analytically oriented company, they say, we're going to do this very analytically. We are basically going to ask everybody we can think of, and a few people we can't. Give us a list of the best technically oriented business people that you know. And there is of course one name that appears on every list. It is Omid Kordestani who becomes employee number 11 at Google and makes two and a half billion dollars.

**中文翻译:**
当时没人知道浏览器是什么，没人知道互联网会变成什么样。所以他进行了所有这些精彩的谈话。好，现在他基本上认识了所有人。那是 1998 年，一家只有 10 名工程师的小公司——典型的硅谷公司，全是工程师。我有一个朋友去了一家有 26 个人的公司工作，那公司连一个销售或市场人员都没有。总之，这家公司现在有 10 名工程师，他们决定雇佣第一个商务人员。作为一家以分析为导向的公司，他们说：“我们要非常科学地做这件事。我们要询问所有我们能想到的人，以及一些我们想不到的人：给我们一份你认识的最优秀的、懂技术的商务人士名单。”当然，有一个名字出现在了每一份名单上。那就是欧米德·柯德斯塔尼，他成为了谷歌的第 11 号员工，并赚到了 25 亿美元。

---

### (00:35:13) Lenny Rachitsky

**English:**
Great success from networking. Well done. When people hear about networking, it just feels like you said, very cringe. I don't want to go to these networking events and try to pretend to talk and care about people. Do you have any advice for just how to make networking feel less cringy?

**中文翻译:**
建立人脉带来的巨大成功。干得漂亮。当人们听到“建立人脉”时，就像你说的，感觉非常尴尬（cringe）。我不想去参加那些人脉活动，假装在交谈并关心别人。你有什么建议能让建立人脉感觉不那么尴尬吗？

---

### (00:35:28) Jeffrey Pfeffer

**English:**
One of the exercises I give my students is I say, write a list of 10 people who, if you knew them and if they knew you, would be important for whatever you're trying to accomplish in your career. So maybe you're trying to get into biotech, you need to know 10 executives in biotech or whatever. Make a list of 10 people. Then for each person figure out how you are going to meet them. By the way, not necessarily in a network event. Maybe you want to do what John Levy does, which is hold dinners. In which by the way, the guests do the cooking, which is a very interesting idea. That of course taps into the IKEA effect. You always like something better if you participate in creating it. Maybe you want to hold dinners, maybe you want to try to reach out to them at lunch.

**中文翻译:**
我给学生的一个练习是：写下一份 10 人的名单，如果你认识他们，且他们也认识你，那么对于你想在职业生涯中实现的任何目标来说，他们都是至关重要的。比如你想进入生物技术领域，你就需要认识 10 位该领域的高管。列出这 10 个人。然后针对每一个人，想出你打算如何见到他们。顺便说一下，不一定要在人脉活动上。也许你想学约翰·利维那样举办晚宴，顺便说一下，他的晚宴是让客人自己动手做饭，这是一个非常有趣的主意。这当然利用了“宜家效应”（IKEA effect）：如果你参与了创造过程，你总是会更喜欢那个东西。也许你想举办晚宴，也许你想尝试在午餐时间联系他们。

---

### (00:36:21) Jeffrey Pfeffer

**English:**
Maybe you want to reach out to them and say, here's an article I think you'd be interested in. Here is somebody who I think you'd benefit from meeting. So recently, I'm not a particularly good networker, though I'm better I guess than some people. I recently met Esther Wojcicki, I'm sure I killed her name. She's considered the grandmother of Silicon Valley. She's Susan Wojcicki's mother. And she is interested in depression, particularly depression among teenagers. And I said, you should know Leanne Williams, who's in the Psychiatry and Behavioral Science Department, who has done probably 300 articles on depression and has invented something which is called Precision Psychiatry. So I connected them to each other. Just send an email. I think you ought to know each other. They got together. I get credit for knowing people and connecting them, but I also benefit them. Leanne needs to raise money. Esther's got money. Esther needs to understand the cutting edge research in depression and biomarkers of depression, which is what Leanne's specialty is, so they benefit. So this is not some icky thing. This is connecting people who benefit from being connected.

**中文翻译:**
也许你想联系他们并说：“这是一篇我认为你会感兴趣的文章。这是我认为你见一面会受益的人。”最近——我并不是一个特别擅长建立人脉的人，虽然我想我比某些人强点——我最近见到了埃丝特·沃西基（Esther Wojcicki），我肯定读错她的名字了。她被认为是“硅谷教母”，是苏珊·沃西基（Susan Wojcicki，前 YouTube CEO）的母亲。她对抑郁症感兴趣，特别是青少年的抑郁症。我说：“你应该认识一下利安·威廉姆斯（Leanne Williams），她在精神病学和行为科学系，发表过大概 300 篇关于抑郁症的文章，并发明了所谓的‘精准精神病学’。”于是我把她们联系在了一起。只需发一封邮件：“我认为你们应该互相认识一下。”她们见面了。我因为认识人并把他们联系起来而获得了信誉，但我也使她们受益。利安需要筹款，埃丝特有钱；埃丝特需要了解抑郁症和抑郁症生物标志物的前沿研究，而这正是利安的专长，所以她们都受益了。所以这并不是什么令人反感的事，这是在把那些能从联系中获益的人连接起来。

---

### (00:37:38) Lenny Rachitsky

**English:**
That touches on something you teach in the book is, in your networking you want to become a broker, you want to be central. That's kind of what you want to work on. Can you talk a bit about what that means?

**中文翻译:**
这涉及到了你在书中教导的内容：在建立人脉时，你想成为一个“经纪人”（broker），你想处于中心位置。这是你需要努力的方向。你能谈谈这意味着什么吗？

---

### (00:37:47) Jeffrey Pfeffer

**English:**
Well, that means you want to connect people. So many people with benefits, and many groups with benefits for being connected, and they're not connected. What does a venture capitalist do? Connects people with ideas to people with money, and takes a fee for doing it. What does an investment banker do? Connects people trying to sell businesses or raise capital with people trying to buy businesses or who have capital. What's a real estate agent do? Connects buyers and sellers of houses. There are all kinds of examples where the person's entire job is connecting people. But even for the people whose job it isn't, you benefit from knowing people. The more people you know, the more things you know. As I sometimes say in my class, if leadership management, call it what you will, is getting things done through other people, it seems like common sense that the more other people you know, the more you'll be able to get done.

**中文翻译:**
嗯，这意味着你想连接他人。有那么多能互惠互利的人和群体，如果他们建立联系就会受益，但他们现在还没联系上。风险投资家是做什么的？把有想法的人和有钱的人连接起来，并为此收取费用。投资银行家是做什么的？把想要出售业务或筹集资金的人，与想要购买业务或拥有资金的人连接起来。房地产经纪人是做什么的？连接房屋的买家和卖家。有各种各样的例子，其中一个人的全部工作就是连接他人。但即使对于那些工作不是连接他人的人来说，认识人也是有好处的。你认识的人越多，你知道的事情就越多。正如我有时在课上说的，如果领导力管理（随你怎么称呼它）是通过他人来完成任务，那么常识告诉我们，你认识的人越多，你能完成的事情就越多。

---

### (00:38:45) Lenny Rachitsky

**English:**
As someone that has become central to a lot of things in the product world, and has built a large network as a result of this podcast newsletter, I can tell you a thousand percent. This creates a lot of opportunity and power, you could say in quotes. So I've seen it happen.

**中文翻译:**
作为一个在产品领域很多事情中处于中心位置，并因为这个播客和时事通讯而建立了庞大人脉网的人，我可以百分之百地告诉你：这创造了大量的机会和（引号里的）“权力”。我亲眼见证了它的发生。

---

### (00:39:00) Jeffrey Pfeffer

**English:**
Of course.

**中文翻译:**
当然。

---

### (00:39:03) Lenny Rachitsky [Ad Break - Heap]

**English:**
This episode is brought to you by Heap... [Ad content omitted for brevity in translation but kept in English as per instructions]

**中文翻译:**
本集节目由 Heap 赞助。Heap 是一款产品分析解决方案，它可以向你展示用户在你的数字产品、网站、移动产品或其他数字服务上所做的一切。我们看到出色的数字体验时都能认出来：它是直观的，能预见你的需求，并让你轻松完成工作。如果你正试图为你的用户构建这种体验，你需要关于用户在你的产品中做什么以及为什么这么做的最新、可靠的信息。想知道你的用户在不同平台上的行为如何？是什么让他们不断回头？他们在做哪些你甚至都没有意识到的事情？Heap 会自动为你捕获所有这些用户活动，然后在几秒钟内（而不是几周）为你提供关于用户行为的所有问题的明确答案。访问 heap.io/Lenny 开始演示。

---

### (00:40:10) Lenny Rachitsky

**English:**
Another lesson I guess you teach is to pursue weak ties. Talk a bit about what that means. What do you mean by that?

**中文翻译:**
我想你教的另一课是追求“弱连接”（weak ties）。谈谈这意味着什么。你指的是什么？

---

### (00:40:14) Jeffrey Pfeffer

**English:**
Well, the people to whom you are strongly tied, your family, your spouse, significant other, your friends, the people who work with you at work will probably, because they are close to you, know the same things and the same people that you do. So to the extent that you build ties with people who are more different from you in every dimension, you are more likely to learn non-redundant information, and come in contact with people that you don't already know. This again seems common sense. There's a lot of research behind it. Mark Granovetter, a sociologist who still teaches at Stanford, wrote a book entitled The Strength of Weak Ties.

**中文翻译:**
嗯，那些与你有着“强连接”的人——你的家人、配偶、伴侣、朋友、同事——因为他们离你很近，可能知道的事情和你一样，认识的人也和你一样。所以，如果你在各个维度上与那些和你更不同的人建立联系，你就更有可能学到非冗余的信息，并接触到你还不认识的人。这听起来又是常识，但背后有大量的研究支持。马克·格拉诺维特（Mark Granovetter），一位仍在斯坦福任教的社会学家，写过一篇名为《弱连接的力量》的文章。

---

### (00:40:59) Jeffrey Pfeffer

**English:**
And basically, no, actually, pardon me. He wrote an article called The Strength of Weak Ties. His book was called Getting a Job. And he did a study, I guess it was at that time in Boston. He did a study of job seekers in Massachusetts, and he looked at people who got jobs through applying to ads, through more formal means. And then he looked at people who got jobs through referrals from their network. And it turns out, of course, the jobs that you get through your network referrals are much better jobs. And oftentimes the best jobs that people got were referred to them by people that were not particularly close to them. Because they had a view, that's the word I was looking for, a view into the ecosystem of the Boston labor market, that the other people didn't have because they weren't in the same place as the other people.

**中文翻译:**
基本上——不，抱歉，他写的是那篇文章，他的书叫《找工作》（Getting a Job）。他做了一项研究，我想当时是在波士顿。他研究了马萨诸塞州的求职者，观察了那些通过应聘广告等正式途径获得工作的人，以及那些通过人脉推荐获得工作的人。结果当然是：通过人脉推荐获得的工作要好得多。而且通常情况下，人们得到的最好的工作是由那些与他们并不是特别亲近的人推荐的。因为这些人拥有一个——这就是我要找的词——拥有一个观察波士顿劳动力市场生态系统的“视角”，而其他人没有这个视角，因为他们不处于相同的位置。

---

### (00:42:00) Lenny Rachitsky

**English:**
I love that lesson. Let's talk about another power, which is using your power. So when people think of using your power builds more power, that's not intuitive. You talk about how it creates this self-perpetuating growth of power the more you practice power. Can you talk a bit about that?

**中文翻译:**
我喜欢这一课。让我们谈谈另一种权力规则：运用你的权力。当人们想到“运用权力会建立更多权力”时，这并不直观。你谈到了随着你越多地练习权力，它如何创造这种自我循环的权力增长。你能谈谈这个吗？

---

### (00:42:16) Jeffrey Pfeffer

**English:**
Sure. So when you are given, it's interesting, my friend Deborah Gruenfeld, who wrote a book called Acting with Power, talks a lot about people's ambivalence to power. So sometimes people are put in a job. Herminia Ibarra who teaches now at London Business School, at one point taught in Seattle, at one point taught at Harvard, has an article in the Harvard Business Review in which she talks about a woman in a drug company who gets a promotion, and says to her colleagues, to whom she's now overseeing, that she's not sure why she got the job. She's not sure she deserves the job. Needless to say, she didn't do very well in this job because she got in her own way. But part of this is you are put in a position of power. You're put in a position of authority in order to make things happen. So to the extent you mobilize your resources and get things to happen, you'll get more resources.

**中文翻译:**
当然。当你被赋予权力时——这很有趣，我的朋友黛博拉·格伦菲尔德（Deborah Gruenfeld）写过一本《权力的演练》（Acting with Power），书中谈到了人们对权力的矛盾心理。有时人们被安排在一个职位上。目前在伦敦商学院任教的赫敏尼亚·伊巴拉（Herminia Ibarra）曾在哈佛任教，她在《哈佛商业评论》上发表过一篇文章，讲述了一家制药公司的一位女性获得了晋升，却对她现在监管的同事说，她不确定自己为什么得到了这份工作，也不确定自己是否配得上这份工作。不用说，她在那个职位上表现得并不好，因为她“自我妨碍”了。但其中的一部分是：你被置于权力和权威的位置是为了促成事情。所以，你在多大程度上调动资源并促成事情，你就会获得更多资源。

---

### (00:43:14) Jeffrey Pfeffer

**English:**
People want to be associated with success. To the extent that you become successful, more people will want to work with you. To the extent that you get more stuff done, you'll get more promotions, more opportunities. Nobody's going to give you a job to do if the last five jobs like that they gave you, you couldn't get done. So the more you are able to do, which oftentimes of course requires power and influence, the more you're able to do, the more you'll be asked to do. But better yet, the more resources you'll be given to help you get things done.

**中文翻译:**
人们想与成功联系在一起。你在多大程度上变得成功，就会有更多的人想和你一起工作。你在多大程度上完成了更多的事情，你就会获得更多的晋升和机会。如果之前交给你的五项类似工作你都没办成，没人会再交给你工作。所以，你越有能力做事（这通常当然需要权力和影响力），你被要求做的事情就越多。但更好的是，你会被赋予更多的资源来帮助你完成任务。

---

### (00:43:48) Lenny Rachitsky

**English:**
And I think there's interestingly you teach that just showing that you have power creates more power. People see that you have this power and they start to follow your lead more, right? That's a part of this.

**中文翻译:**
而且我认为有趣的是，你教导说仅仅“展示”你拥有权力就能创造更多权力。人们看到你拥有这种权力，他们就会更多地追随你的领导，对吧？这是其中的一部分。

---

### (00:43:57) Jeffrey Pfeffer

**English:**
Yep. I just saw over the weekend the movie, the latest movie in the franchise of the Planet of the Apes. When Jim Collins left Stanford, he gave me a book called Chimpanzee Politics, which is of course not based on the Planet of the Apes, but it's based upon the study of chimpanzees. We are the same. People are attracted to power, you know that. By the way, that will account for a lot of what is going to happen in the presidential election.

**中文翻译:**
是的。我周末刚看了《猩球崛起》系列的最新电影。当吉姆·柯林斯（Jim Collins）离开斯坦福时，他送给我一本名为《黑猩猩政治》（Chimpanzee Politics）的书，这当然不是基于《猩球崛起》，而是基于对黑猩猩的研究。我们是一样的。人们会被权力吸引，你知道的。顺便说一下，这可以解释总统选举中将要发生的很多事情。

---

### (00:44:26) Lenny Rachitsky

**English:**
Let's save that for the end, because I think that's an interesting piece of your book, of the connection to Trump. So let's save that for a bit. I think that'll be really interesting. Kind of along the same lines of the area we're just talking about. And another rule of power is to show up in a powerful fashion. So look powerful, talk about what that looks like.

**中文翻译:**
让我们把那个话题留到最后，因为我觉得你书中关于与特朗普联系的部分很有趣。所以我们先放一放。我想那会非常有趣。顺着我们刚才讨论的话题，权力的另一条规则是“以有权势的方式亮相”。也就是看起来很有权势，谈谈那是什么样子的。

---

### (00:44:43) Jeffrey Pfeffer

**English:**
So my colleague at Berkeley, Dana Carney, C-A-R-N-E-Y, is writing a book called Tell, which is about the importance of body language and how to master body language. There is some evidence that suggests we respond mostly to how people look, secondarily to how they sound, and by far the least important to the content of what they say. You can see this by turning on your TV and turning off the sound. Watch the presidential debates with the sound off. They'll be much better. I have another colleague in marketing by the name of Baba Shiv, who talks about people's freaky mind, or the idea that we are in fact descended from primates, and that we are controlled in lots of ways by our emotions. And so we respond affectively to other people. We respond to how they look. There's evidence in economics that suggests tall people earn more salaries, control, earn more money, controlling for lots of things, attractive people.

**中文翻译:**
我在伯克利的同事达娜·卡尼（Dana Carney）正在写一本名为《迹象》（Tell）的书，是关于肢体语言的重要性以及如何掌握肢体语言的。有一些证据表明，我们对他人的反应主要取决于他们的外表，其次是他们的声音，而最不重要的是他们说话的内容。你可以通过打开电视并关掉声音来验证这一点。关掉声音看总统辩论，效果会好得多。我还有另一位营销学同事巴巴·希夫（Baba Shiv），他谈到了人们的“怪异大脑”，或者说我们实际上是灵长类动物的后裔，我们在很多方面受情感控制。因此，我们对他人的反应是情感化的。我们对他们的外表做出反应。经济学证据表明，在控制了许多变量后，高个子的人薪水更高，赚的钱更多；有吸引力的人也是如此。

---

### (00:45:46) Jeffrey Pfeffer

**English:**
As long as you're not too attractive, you earn more money. Optimal level of attractiveness because people respond subconsciously to how people look, how they sound, how they show up, how they present themselves. In my class, I take the example of Tony Hayward of BP, the Macondo oil spill, and Lloyd Blankfein who was accused of shorting the securities that he was selling, which by the way, Goldman did. And before I let them hear Tony or Lloyd, we show about 60 seconds. And Lloyd's case 34 seconds with no sound. And even if you did not know who these people were and I asked you to make a bet, who's going to keep their job and who's going to lose it? You would know just from their physical appearance.

**中文翻译:**
只要你不是“太”有吸引力，你就会赚更多的钱。存在一个最佳的吸引力水平，因为人们会潜意识地对他人的长相、声音、亮相方式和自我呈现方式做出反应。在我的课上，我以英国石油公司（BP）的托尼·海沃德（Tony Hayward，马孔多油井泄漏事件期间的 CEO）和劳尔德·贝兰克梵（Lloyd Blankfein，高盛 CEO，当时被指控做空他正在销售的证券）为例。在让学生听托尼或劳尔德说话之前，我们会播放大约 60 秒（劳尔德的案例是 34 秒）没有声音的视频。即使你不知道这些人是谁，我让你打个赌：谁会保住工作，谁会丢掉工作？仅仅通过他们的外表，你就能知道答案。

---

### (00:46:37) Lenny Rachitsky

**English:**
I love that.

**中文翻译:**
我喜欢这个例子。

---

### (00:46:39) Jeffrey Pfeffer

**English:**
And by the way, what Dana Carney will tell you, and what common sense will tell you, is that these are skills that can be mastered. Robert de Niro was not born Robert de Niro, in the sense of acting skills are learned. How you show up, how you command the room. There's a guy named Regis McKenna who is older than God, who's famous for running a very, very, very fancy public relations firm in the Silicon Valley. And his biggest contribution to life, as well as by the way to his personal wealth, is that he made Steve Jobs Steve Jobs. When Steve Jobs began, Steve Jobs couldn't convince you to buy water if you were dying of thirst. He could not give a presentation to save his life. And Regis McKenna and his team took Steve Jobs under their wing and created Steve Jobs, a man who could sell anything to anybody. These are skills. This is not about personality. This is not about undergoing some kind of cosmetic surgery or whatever. These are skills, everything we've talked about, networking, showing up, all these things. These are skills that can be learned.

**中文翻译:**
顺便说一下，达娜·卡尼会告诉你，常识也会告诉你，这些都是可以掌握的技能。罗伯特·德尼罗并不是天生的罗伯特·德尼罗，演技是学出来的。你如何亮相，你如何掌控全场。有一个叫雷吉斯·麦肯纳（Regis McKenna）的人，他年纪非常大了，因在硅谷经营一家极其高端的公关公司而闻名。他对生活最大的贡献，顺便也是对他个人财富最大的贡献，就是他成就了史蒂夫·乔布斯。当乔布斯刚开始时，如果你快渴死了，他都没法说服你买水。他当时的演讲水平简直没救了。雷吉斯·麦肯纳和他的团队把乔布斯招致麾下，塑造了史蒂夫·乔布斯——一个能把任何东西卖给任何人的人。这些都是技能。这与性格无关，与做整形手术之类的无关。这些都是技能，我们谈到的一切：建立人脉、亮相等等，这些都是可以学习的技能。

---

### (00:48:26) Lenny Rachitsky

**English:**
I have a list of some of the stuff you actually recommend for looking and appearing powerful. So I'll read a few and I'm curious what else comes to mind. So do not read from notes. Make eye contact. Keep it brief. You say that anger can be a signal of power because it's outside the norm. It's kind of breaking the rules. Don't apologize. It's kind of the opposite. More gestures, which is interesting. Open body posture. Louder voice. Okay, I'm going to speak louder now. I like this. Okay, what else comes to mind as ways to appear powerful?

**中文翻译:**
我有一份你推荐的关于如何看起来有权势的清单。我读几个，我想知道你还能想到什么。不要读笔记；保持眼神交流；保持简短。你说愤怒可以作为权力的信号，因为它超出了常规，某种程度上是在打破规则；不要道歉；这有点反直觉——更多的手势，这很有趣；开放的身体姿势；更大的声音。好，我现在要大声说话了。我喜欢这个。好，还有什么表现得有权势的方法吗？

---

### (00:48:26) Jeffrey Pfeffer

**English:**
Invading people's personal space. So gentle touching, standing close to someone. We're not talking about sexual touching, we're talking touch on the arm or the shoulder, shaking people's hands. That's a way of I think being more powerful. But you've covered the main ones. Eye contact. One of the problems with Tony Hayward of BP is that he's been given a statement to read. You cannot read something in front of you and make eye contact at the same time. So he looks like he's scripted. He looks like he's insincere. Jack Valenti, who I had the privilege of knowing, who for 38 years was the head of the Motion Picture Association of America, and typically rated one of the number one or number two most effective lobbyists in Washington DC, said to my class when he came to my class, which he did, "I never appeared before Congress with notes. I wanted them to believe, which was by the way, true, that I was in complete control and complete mastery of the material, and that I did not need notes or a bunch of assistants around me to help me.

**中文翻译:**
侵入他人的个人空间。比如轻微的接触，站在离某人很近的地方。我们不是在说性接触，而是指拍拍手臂或肩膀，握手。我认为这是一种更有权势的方式。不过你已经涵盖了主要的几点。眼神交流。英国石油公司的托尼·海沃德的一个问题是，他被给了一份声明去读。你不可能在读面前的东西的同时保持眼神交流。所以他看起来像是在背剧本，看起来很不真诚。我有幸认识杰克·瓦伦蒂（Jack Valenti），他曾担任美国电影协会（MPAA）主席长达 38 年，通常被评为华盛顿特区最有效率的一两位游说者之一。他来我班上演讲时说：“我从未带着笔记出现在国会面前。我想让他们相信（顺便说一下，这也是事实），我完全掌控并精通这些材料，我不需要笔记或一堆助手在身边帮我。”

---

### (00:49:40) Jeffrey Pfeffer

**English:**
That I, as the head of the MPAA, understood the motion picture industry." And then he would give you a little aside about how it was the one industry that consistently had a budget surplus in trade. He would talk about how many jobs he created and he had all this stuff at his fingertips. But basically his command of the material made him more powerful. It's interesting, Jack Valenti was five foot two inches tall and he came, talked to my class, and the next class I said to people, "What are your reactions? What are your thoughts?" And a woman raised her hand and said, "He feels taller than he is." And I thought that was an assessment that was both true and insightful. When the five-foot-two Jack Valenti appeared, because of his presence, because of his body language, because of his Texas drawl, because of how he moved on the stage, he felt bigger. You would not say he did not feel five-foot-two.

**中文翻译:**
“作为 MPAA 的负责人，我了解电影行业。”然后他会顺便告诉你，这是唯一一个在贸易中持续保持预算盈余的行业。他会谈论他创造了多少就业机会，所有这些数据他都了如指掌。但基本上，他对材料的掌控力让他更有权势。有趣的是，杰克·瓦伦蒂身高只有 1 米 57，他来我班上演讲后，下一节课我问大家：“你们有什么反应？有什么想法？”一位女性举手说：“他感觉比实际身高要高。”我认为这个评价既真实又深刻。当 1 米 57 的杰克·瓦伦蒂出现时，由于他的气场、肢体语言、德州口音以及他在舞台上的移动方式，他让人感觉更高大。你不会觉得他只有 1 米 57。

---

### (00:50:54) Lenny Rachitsky

**English:**
Let me read a couple more because this is a good example of stuff he did. Other ways to appear more powerful is more speaking time, longer gazing time, more disinhibited laughs. Is that just you laughing and feeling like you're just...

**中文翻译:**
让我再读几个，因为这是他所做事情的一个很好的例子。其他表现得更有权势的方法包括：更多的发言时间、更长的注视时间、更无拘无束的笑声。那是说你大笑并感觉你只是……

---

### (00:51:08) Jeffrey Pfeffer

**English:**
Well, humor. Humor. The famous author, Salman Rushdie said, and I quote Salman Rushdie, it's a fabulous quote. "If you can get people to laugh, you can tell them anything."

**中文翻译:**
嗯，幽默。幽默。著名作家萨尔曼·拉什迪（Salman Rushdie）说过一句极好的话，我引用一下：“如果你能让人们发笑，你就可以告诉他们任何事情。”

---

### (00:51:20) Lenny Rachitsky

**English:**
Yeah, stand-up comedy is a great example that. So again, I think here people might be hearing this and they're like, I don't want to be this person. I don't want to be talking all the time. I don't want to be pretending like open posture. Is the advice here just you don't need to do all these things. Just know this makes people more powerful. Don't necessarily judge people, do some of these things maybe because it'll add to your power? How do you think about just people that are turned off by this sort of thing?

**中文翻译:**
是的，单口喜剧就是一个很好的例子。所以，我想人们听到这里可能会想：我不想成为这样的人。我不想一直说话，我不想假装摆出开放的姿势。这里的建议是说你不需要做所有这些事情，只需知道这些会让人们更有权势吗？不要刻意评判别人，也许做其中的一些事情，因为它会增加你的权力？你如何看待那些对这类事情感到反感的人？

---

### (00:51:45) Jeffrey Pfeffer

**English:**
That's a wonderful question. So I say to my class, on the very first day of class, that we will go through four stages. We'll go through the stage of denial. It doesn't work in my culture, it doesn't work in my organization, doesn't work for me, it doesn't work in my religion, whatever. Then we'll go through anger. When they get angry at me, how can you teach us this stuff? Then they'll go into sadness. I actually believe this and I'm depressed. And if we're successful, they will go through acceptance. And the process I have, again, I do not have the most popular class at Stanford Business School because I am good-looking, because I'm the smartest person at Stanford or anything else. I am strategic about thinking about if I have someone who's going to come into this class, I have to get them from denial to acceptance in 10 weeks.

**中文翻译:**
这是一个极好的问题。我在开学第一天就会告诉学生，我们将经历四个阶段。首先是“否认”阶段：这在我的文化中行不通，在我的组织中行不通，对我没用，在我的宗教中行不通，等等。然后我们会经历“愤怒”阶段：他们对我发火，你怎么能教我们这些东西？接着他们会进入“悲伤”阶段：我竟然相信了这些，我感到很沮丧。如果我们成功了，他们最终会进入“接受”阶段。我之所以拥有斯坦福商学院最受欢迎的课程，不是因为我长得帅，也不是因为我是斯坦福最聪明的人。我非常有策略地思考：如果有人来上这门课，我必须在 10 周内让他们从“否认”转变为“接受”。

---

### (00:52:38) Jeffrey Pfeffer

**English:**
And how are we going to do that? The easiest way to do that, if I said, Lenny, I want you to become a better tennis player, or a better roller blader, or a better ice skater, whatever, a better piano player in 10 weeks, what would we do? If we have practice and coaching. And that's what I do in the class, practice and coaching. I have executive coaches who work with the class and I give them assignments that ask them to practice what they're learning. And therefore, by the end of the class, most people have made this transition because it is true. If you've never... I had a dinner the other night, this Israeli woman who's like, I've done amazing stuff. Amazing. Which is fabulous. And she said at the dinner, she said, "I would've never done this before taking your class." And the way you get them to do this is I don't say, Lenny, you're going to swim the English Channel tomorrow.

**中文翻译:**
我们该怎么做呢？最简单的方法是，如果我说：“伦尼，我想让你在 10 周内成为更好的网球选手、轮滑选手、滑冰选手，或者更好的钢琴家”，我们会怎么做？我们会进行练习和辅导。这就是我在课上做的：练习和辅导。我有专门的高管教练配合课程，我会给学生布置作业，要求他们练习所学的内容。因此，到课程结束时，大多数人都完成了这种转变，因为这是事实。如果你从未……前几天我参加了一个晚宴，一位以色列女性说：“我做了一些了不起的事情，太神奇了。”这太棒了。她在晚宴上说：“在上你的课之前，我绝不会做这些事。”让你去做这些事的方法不是说：“伦尼，你明天要去横渡英吉利海峡。”

---

### (00:53:38) Jeffrey Pfeffer

**English:**
If I want you to swim the English Channel, we're going to start by swimming in pools and make every day a little bit more challenging. That's what we do. I don't start by saying, you're going to network like Keith Ferrazzi or John Levy, or you're not going to be as bold as Jason Calacanis, who trust me is extraordinarily bold. You're not going to necessarily do what I did. You're going to begin where you can begin, and push yourself out of your comfort zone. Because, and again, this is common sense. There's also a ton of research behind it. If you always stay in your comfort zone, you'll never do anything different or better than what you're currently doing. This is true. If I said to you, I want you to, at the end of 10 weeks, lift a hundred pounds, I can't do that by on the last day saying lift a hundred pounds. We have to work up to it. And that is, it's the same principle here. So don't do something that looks so off the wall or so out of character for you that you can't conceive doing it. Push yourself a little, push yourself a little.

**中文翻译:**
如果我想让你横渡英吉利海峡，我们会从在泳池里游泳开始，每天增加一点挑战。这就是我们所做的。我不会一开始就说你要像基思·法拉奇或约翰·利维那样建立人脉，或者像杰森·卡拉卡尼斯那样大胆（相信我，他极其大胆）。你不必非得做我做过的事。你要从你能开始的地方开始，把自己推出舒适区。因为——再说一遍，这是常识，背后也有大量研究支持——如果你总是待在舒适区，你永远不会做出任何与现状不同或比现状更好的事情。这是事实。如果我跟你说，我想让你在 10 周结束时举起 100 磅，我不能在最后一天才说“举起 100 磅”，我们必须循序渐进。这里的原理是一样的。所以，不要做一些看起来太离谱或太不符合你性格、以至于你无法想象的事情。稍微推自己一把，再推自己一把。

---

### (00:54:49) Lenny Rachitsky

**English:**
There's an interesting connection here too. What some say is kind of the opposite of your class at Stanford, which is Touchy-Feely. We had Carole Robin on the podcast and she has a framework, the 15% rule where you push yourself 15% beyond your comfort zone. Where it's just a little bit, but it's not too far, and it feels like you try to do a similar thing.

**中文翻译:**
这里也有一个有趣的联系。有些人说斯坦福有一门课和你这门课正好相反，就是“感性课程”（Touchy-Feely）。我们曾邀请卡罗尔·罗宾（Carole Robin）参加播客，她有一个框架，即“15% 规则”：把自己推向舒适区之外 15% 的地方。只是迈出一小步，但又不太远，感觉你也在尝试做类似的事情。

---

### (00:55:07) Jeffrey Pfeffer

**English:**
Yeah, absolutely. So you begin by doing what you don't think you can do.

**中文翻译:**
是的，没错。所以你从做那些你认为自己做不到的事情开始。

---

### (00:55:12) Lenny Rachitsky

**English:**
Let's spend a little more time here around the homework assignments, and this kind of Knowing-Doing Gap that you talked about. So you shared a couple of homework assignments you give already, find 10 people, think of 10 people you want to meet that'll help you with your career and then try to meet them. And then there's this, I guess my friend started a podcast, I don't know which homework it was. What other homework assignments do you give?

**中文翻译:**
让我们在这里多花点时间讨论一下作业，以及你提到的这种“知行差距”。你已经分享了几个作业：找 10 个人，想出 10 个你想见到的、对你职业生涯有帮助的人，然后尝试去见他们。还有那个——我想我朋友开始做播客也是作业，我不知道是哪一个。你还布置了哪些作业？

---

### (00:55:30) Jeffrey Pfeffer

**English:**
So we begin, there's a literature on goal setting that says if you set goals, you're more likely to achieve them. This is, again, not some huge insight, but there's an enormous scientific literature about this. And so I begin the very first homework assignment is, which is by the way, on the very first day of class, why are you here? Why are you here? It is now the end of this class. What would success look like to you? What would you like to accomplish in our 10 weeks together? Second assignment, I give them a reading from the Power book, which is the book before Seven Rules, which talks about the seven attributes of power. Go out and get people to rate you on these or rate yourself. Set for yourself a development plan, energy, focus, being willing to tolerate conflict, all these qualities. What are you strong on? What are you weak on? What do you want to build during our time together, and how are you going to do it?

**中文翻译:**
我们从目标设定开始。关于目标设定的文献表明，如果你设定了目标，你就更有可能实现它们。这同样不是什么惊人的见解，但有大量的科学文献支持。所以我布置的第一个作业——顺便说一下，是在开学第一天——就是：你为什么在这里？你为什么来上这门课？假设现在课程结束了，对你来说成功是什么样子的？在我们的 10 周时间里，你想达成什么目标？第二个作业，我给他们读《权力》（Power）一书中的内容（那是《权力的七条规则》之前的一本书），书中谈到了权力的七个属性。去让别人给你打分，或者给自己打分。为自己制定一个发展计划：精力、专注力、容忍冲突的意愿，所有这些品质。你的强项是什么？弱项是什么？在我们的课程期间你想建立什么，以及你打算如何建立？

---

### (00:56:35) Jeffrey Pfeffer

**English:**
So we begin with goal setting. One of the assignments I give them, which is the class that Jason comes to, what resources can you create? You're at Stanford Business School, elite, fancy Stanford. What can you do in your 10 weeks here? I have people who created awards. A woman who created an award gave it to Karlie Kloss, the model. Got in trouble with the school. It turns out it's easier to ask forgiveness than permission. So what can you do to create resources that will give you some leverage? That would be a third assignment. The networking is a fourth assignment. The acting with power. I show them the videos and I tell them in advance of the class, and I tell them they need to become Tony Hayward. They need to do a better job, which is, by the way, a low bar, representing BP. And give me a 60 to 90 second video and then share it with colleagues and get feedback on it. And then we're going to call on people in the class.

**中文翻译:**
所以我们从目标设定开始。我给他们的作业之一（也就是杰森来的那节课）：你能创造什么资源？你在斯坦福商学院，精英云集、华丽的斯坦福。在这 10 周里你能做什么？我见过有人设立了奖项。一个女生设立了一个奖并颁给了名模卡莉·克劳斯（Karlie Kloss）。她因此惹了麻烦，但事实证明，请求原谅比请求许可更容易。所以，你能做些什么来创造能给你带来杠杆作用的资源？这是第三个作业。建立人脉是第四个作业。还有“权力的演练”：我给他们看视频，并在课前告诉他们，他们需要扮演托尼·海沃德。他们需要代表英国石油公司做得更好（顺便说一下，这门槛很低）。给我一段 60 到 90 秒的视频，然后分享给同事并获取反馈。然后我们会在课堂上点名。

---

### (00:57:47) Jeffrey Pfeffer

**English:**
In other words, for every idea, I try to think of something. And this is all, by the way, this is all front-loaded. And by the end of the class we're not doing this so much. But I try to give them an exercise that causes them to actually take that idea and implement it. Find people, oh, for branding. Write a personal brand statement, get some feedback on it, then write it again. How do you want to be known? Which is by the way, useful to you because you're a second-year MBA, you're going to go in the job market. What do you want people to think about you? How do you want people to respond to you? How do you want to be known? So I basically take for every topic and have them do it. And then the coach, their person, their coach, who is responsible for 23 of these people, give them feedback on this.

**中文翻译:**
换句话说，对于每一个想法，我都试图想出一些实际操作。顺便说一下，这些都是前期密集进行的，到课程结束时我们就没做这么多了。但我试图给他们一个练习，让他们真正采纳那个想法并付诸实施。找人——噢，关于品牌：写一份个人品牌声明，获取反馈，然后重写。你想以什么样的形象闻名？顺便说一下，这对你很有用，因为你是 MBA 二年级学生，即将进入就业市场。你希望人们怎么看你？你希望人们对你做出什么样的反应？你想如何成名？所以我基本上针对每个主题都让他们去做。然后教练——负责这 23 个人的教练——会给他们反馈。

---

### (00:58:44) Lenny Rachitsky

**English:**
I could see how this makes a big impact on someone's life.

**中文翻译:**
我能看出这会对一个人的生活产生重大影响。

---

### (00:58:49) Jeffrey Pfeffer

**English:**
Yeah. And so at the end, I had a student a couple years ago said to me, "It is not that I got more feedback and more useful feedback from your class than I did in any other class. I got more useful feedback in your class than I did on every other class I took combined."

**中文翻译:**
是的。所以最后，几年前有一个学生对我说：“并不是说我从你的课上得到的反馈比其他任何课都多、更有用。我在你课上得到的有用反馈，比我上的所有其他课加起来还要多。”

---

### (00:59:09) Lenny Rachitsky

**English:**
I can see why. Let's talk about the last power. So we've talked through six already. We have only one more to go, which is maybe the one that probably upsets people most, which is that once you have power, people will forget what you did to get there. Talk about what that looks like and is that a power or is it more just like this is what you should know about.

**中文翻译:**
我明白为什么。让我们谈谈最后一条规则。我们已经讲了六条，只剩最后一条了，这可能是最让人不安的一条：一旦你拥有了权力，人们就会忘记你是如何得到它的。谈谈那是什么样子的，这算是一种权力，还是更像是一种你应该了解的现实？

---

### (00:59:28) Jeffrey Pfeffer

**English:**
And I put in rule seven for the following reason. In spite of everything that you and I have been talking about, many people in a stage of, I don't know, denial or something, say, I'm worried that if I do this, at the end... People believe that the world is homeostatic. It is not. That it's going to adjust, but whatever. At the end I will be brought low. They have the myth of Icarus in their head. You fly too close to the sun, your wings are going to melt, you're going to be brought down. And so I try to convince them, partly through a lecture and partly through rule seven. And some of the principles that I talk about in rule seven. That, in fact, life is not homeostatic at all. That life is actually self-fulfilling. If I believe you're powerful, you will become more powerful.

**中文翻译:**
我加入第七条规则的原因如下：尽管你我一直在讨论这些，但许多处于（我不知道该怎么说）“否认”阶段的人会说：“我担心如果我这么做了，最后……”人们相信世界是“稳态”的（homeostatic），其实不然。他们觉得世界会自动调整，最后我会跌落神坛。他们脑子里有伊卡洛斯的神话：你飞得离太阳太近，翅膀就会融化，你就会坠落。所以我试图说服他们——部分通过讲座，部分通过第七条规则以及我在其中谈到的一些原则——事实上，生活根本不是稳态的。生活实际上是自我实现的。如果我相信你有权势，你就会变得更有权势。

---

### (01:00:26) Jeffrey Pfeffer

**English:**
If I believe you have no power, you will wind up with almost no power, and that therefore it is all forgotten and forgiven. And I begin, I believe I begin. But if not, I could begin with the story of the South Carolina Senator who says nasty things about Trump, and then Lindsey Graham, and becomes Trump's biggest acolyte. And the New York Times, of course, is fascinated by this. How can you say all these horrible things about Trump and now be his, basically have your lips affixed to some part of his anatomy? And Lindsey's answer is, I want to be relevant. He's the President of the United States. This goes back to the judgment. I like him, this, that, the other thing. He's the president. If I want to get legislation passed, he, by the way, has taken over the Republican Party.

**中文翻译:**
如果我认为你没有权力，你最终就几乎没有权力。因此，一切都会被遗忘和原谅。我可以用南卡罗来纳州参议员林赛·格雷厄姆（Lindsey Graham）的故事开始：他曾对特朗普说了很多难听的话，后来却成了特朗普最忠实的追随者。《纽约时报》当然对此着迷：你怎么能说了特朗普那么多坏话，现在却成了他的——基本上是紧贴着他身体的某个部位？林赛的回答是：“我想保持影响力。”他是美国总统。这又回到了“评判”的问题。我喜不喜欢他，这啊那啊的，都不重要。他是总统。如果我想让法案通过，而他顺便已经接管了共和党。

---

### (01:01:22) Jeffrey Pfeffer

**English:**
If I want to get stuff done, I need to have him on my side. And like many narcissists and egomaniacs, it is not a good way to get them on your side by saying nasty things about them. So this is the pragmatics. People forget that Bill Gates stole the code on which Microsoft has built. People forget that Jeffrey Epstein, after being convicted of sex offenses, was still having dinners with members of the royal family and members of the New York media elite. People forget that Martha Stewart, who served time in jail, has a brand that's never been more valuable. People forget all this stuff.

**中文翻译:**
如果我想把事情办成，我就需要他在我这一边。而且像许多自恋者和自大狂一样，说他们的坏话并不是让他们站在你这一边的好方法。这就是务实主义。人们忘记了比尔·盖茨窃取了微软赖以生存的代码；人们忘记了杰弗里·爱泼斯坦（Jeffrey Epstein）在被判性犯罪后，依然与皇室成员和纽约媒体精英共进晚餐；人们忘记了坐过牢的玛莎·斯图尔特（Martha Stewart），她的品牌价值从未像现在这样高。人们会忘记所有这些事情。

---

### (01:02:19) Jeffrey Pfeffer

**English:**
I still remember sitting in the office of someone whose name I won't use, but I'll use enough that if somebody wanted to search it out, you could. So I am sitting in this guy's office and he's, by the way, a Jewish man. He's got pictures of him with the Pope, he's got pictures of him with Ronald Reagan. He's got pictures with him, with all these people. What is his secret? He, by the way, took a company into bankruptcy. People lost literally billions of dollars. He was fined. He lost money, but he walked away with about $700 million. It turns out, $700 million makes you a big deal. Lives at the biggest house in Los Angeles or one of the biggest houses in Los Angeles. I can't keep up with the construction of the big houses. People want to be close to money, power, and success, and they will overlook your flaws to be close to you.

**中文翻译:**
我还记得坐在某个人的办公室里，我不提他的名字，但我提供的线索足够让想搜的人搜到。我坐在那家伙的办公室里，顺便说一下，他是个犹太人。他墙上有他和教皇的合影，有他和罗纳德·里根的合影，有他和所有这些大人物的合影。他的秘密是什么？顺便说一下，他曾把一家公司搞破产，人们损失了数十亿美元。他被罚款了，他亏了钱，但他带着大约 7 亿美元全身而退。事实证明，7 亿美元让你成了大人物。他住在洛杉矶最大的房子里，或者是最大的房子之一——我跟不上那些豪宅的建设速度。人们想接近金钱、权力和成功，为了接近你，他们会忽视你的缺陷。

---

### (01:03:18) Lenny Rachitsky

**English:**
And again, you talk about this in the book. You're not describing how the world should work. This is just how it is, and this is how you can be successful in the world that we live in.

**中文翻译:**
再说一遍，你在书中谈到了这一点。你不是在描述世界“应该”如何运作，而只是描述它的“现状”，以及你如何在现实世界中获得成功。

---

### (01:03:28) Jeffrey Pfeffer

**English:**
And by the way, this is how the world not only is, but how it was and how it will be. Because these ideas are not something that I sat down one day and made up or something. These ideas, everything that I talk about, including this last one, has social science and logic behind it. So you can explain not only what is, but why it is.

**中文翻译:**
顺便说一下，这不仅是世界的现状，也是它的过去和未来。因为这些想法并不是我某天坐下来凭空捏造的。我谈到的一切，包括最后这一条，都有社会科学和逻辑支撑。所以你不仅可以解释现状是什么，还可以解释为什么会这样。

---

### (01:03:58) Lenny Rachitsky

**English:**
So, let's talk about Trump for a bit. At the beginning of your book, you say that basically you were going to write a book about why Trump is so successful and what he's done so well. And your realization is no one's going to pay attention if here's how to be like Trump. And essentially, if you think about all these rules, it's clear he is very good at all of these things.

**中文翻译:**
那么，让我们聊聊特朗普。在你书的开头，你说你原本打算写一本关于特朗普为什么如此成功以及他做得多么出色的书。但你意识到，如果书名是《如何像特朗普一样》，没人会理会。本质上，如果你思考所有这些规则，很明显他在所有这些方面都非常擅长。

---

### (01:04:16) Jeffrey Pfeffer

**English:**
That's correct. By the way, not because he read the book, but because he does it through trial and error or something.

**中文翻译:**
没错。顺便说一下，不是因为他读了我的书，而是因为他通过反复试验或其他方式做到了。

---

### (01:04:22) Lenny Rachitsky

**English:**
So when people hear that, they're like, I don't want to be Trump. I don't like how Trump is. I don't want to be seen that way. Do you have any thoughts on just how to make people feel comfortable following some of these powers and building power, knowing that, oh wow, maybe he's the epitome of some of this stuff?

**中文翻译:**
所以当人们听到这些时，他们会想：“我不想成为特朗普，我不喜欢特朗普的样子，我不想被那样看待。”你有什么想法能让人们在知道他可能是这些规则的缩影时，依然能坦然地遵循这些规则并建立权力？

---

### (01:04:38) Jeffrey Pfeffer

**English:**
I will tell you a story. In 1993, a woman named Laura Esserman, who's a doctor, took my class. She claims publicly that this is the only class at Stanford for which she did all the reading. By the way, while she was getting her MBA at Stanford, she was having her first child and practicing medicine full time. Laura Esserman said to me one day, "You have a case. You have cases on all these people doing evil things. Why don't you ever write a case about somebody doing good things?" And of course, I wrote a case about her. So she comes to the class. Case was published in probably 2003, 2004.

**中文翻译:**
我给你讲个故事。1993 年，一位名叫劳拉·埃瑟曼（Laura Esserman）的医生上了我的课。她公开宣称，这是她在斯坦福唯一一门读完了所有阅读材料的课。顺便说一下，她在斯坦福读 MBA 的同时，正怀着第一个孩子，并且还在全职行医。劳拉·埃瑟曼有一天对我说：“你有一个案例，你有很多关于坏人做坏事的案例。你为什么不写一个关于好人做好事的案例呢？”当然，我写了一个关于她的案例。于是她来到了课堂。案例大概是在 2003 或 2004 年发表的。

---

### (01:05:31) Jeffrey Pfeffer

**English:**
She comes to the class and the students are, what is the right word? Hard on her? That would be a modest thing. The students eviscerate her because she is incredibly smart, incredibly well-intentioned, but she will not network. She says, "I don't have time for schmoozing." She will not do almost any of the stuff that we talk about today. So she and her husband, Michael Endicott, two of my closest friends in the world, and I go out to lunch afterwards. And smoke is coming out of her ears and she is pissed off. And this is a very accomplished woman and a very smart woman. And she's pissed. I said to her, "Laura, you have boundless energy and boundless intelligence. You're a force of nature. Let me discuss something from the past subject of physics.

**中文翻译:**
她来到班上，学生们——用什么词合适呢？对她很苛刻？那都说轻了。学生们简直是在“生吞活剥”她，因为她极其聪明、极具善意，但她拒绝建立人脉。她说：“我没时间闲聊。”她几乎不做我们今天谈到的任何事情。于是她和她丈夫迈克尔·恩迪科特（Michael Endicott，我世界上最亲密的朋友之一）和我之后一起去吃午饭。她气得七窍生烟，非常愤怒。她是一个非常有成就、非常聪明的女性，但她气坏了。我对她说：“劳拉，你有无限的精力和无限的智慧，你就像一股自然之力。让我跟你讨论一下物理学里的东西。”

---

### (01:06:39) Jeffrey Pfeffer

**English:**
You are creating friction. With enough force you can overcome the friction. If you reduce the friction, just think how much more you could accomplish." And she looked at me and changed. And I will tell you, and I've said this publicly, because I get to introduce her for all the awards she's won, and she's now won a ton of them. Including Time Magazine 2016 list of a hundred most influential people in the world. And I say to people, and I say it with pride, that of all the things I've done in my life, the thing I'm most proud of and most proud of is creating Laura Esserman.

**中文翻译:**
“你正在制造摩擦。只要力量足够大，你可以克服摩擦。但如果你减少摩擦，想想看你能多成就多少事情。”她看着我，然后改变了。我会告诉你——我也公开说过，因为我有机会在她获得的所有奖项中介绍她，她现在已经获得了一大堆奖项，包括《时代》杂志 2016 年全球百大影响力人物。我对人们说，而且我带着自豪感说：在我一生所做的事情中，我最最自豪的就是“成就”了劳拉·埃瑟曼。

---

### (01:07:20) Lenny Rachitsky

**English:**
That is an awesome story and a really good way of thinking about this from a different angle.

**中文翻译:**
这是一个很棒的故事，也是一个从不同角度思考这个问题的绝佳方式。

---

### (01:07:24) Jeffrey Pfeffer

**English:**
Yeah, no, and I said to Laura, I said, "You want to make profound changes in the drug development process. You want to make profound changes in whether or not we learn from the treatments that are being given to people. You want to make profound changes in the connection between research and teaching, research and practice. You want to do all these things. If you are going to accomplish any of these things, you need to cross the bridge." And she hasn't crossed the bridge completely and she and I joke about it. But she crossed the bridge a lot and she has accomplished incredible things. She's won every cancer award that can be given. And by the way, she's won all these awards for the American Cancer Society, who she fought with. She's won these awards from the Susan Cohen Foundation, who she fought with.

**中文翻译:**
是的，我对劳拉说：“你想在药物开发过程中做出深刻改变，你想在人们是否能从治疗中学习方面做出深刻改变，你想在研究与教学、研究与实践的联系上做出深刻改变。你想做所有这些事。如果你想实现其中任何一件，你就必须‘跨过那座桥’。”她还没有完全跨过去，我和她还经常拿这个开玩笑。但她已经跨过去很多了，并且成就了非凡的事业。她赢得了所有能拿到的癌症奖项。顺便说一下，她从美国癌症协会那里拿了奖，而她曾和他们斗争过；她从苏珊·科恩基金会那里拿了奖，而她也曾和他们斗争过。

---

### (01:08:20) Lenny Rachitsky

**English:**
This is an incredible example of the opening quote to your book that I have here. "If you want power to be used for good, more good people need to have power."

**中文翻译:**
这是我这里摘录的你书开篇名言的一个绝佳例子：“如果你想让权力被用于善途，就需要更多的好人拥有权力。”

---

### (01:08:28) Jeffrey Pfeffer

**English:**
That's exactly right.

**中文翻译:**
一点没错。

---

### (01:08:30) Lenny Rachitsky

**English:**
And I like the, it's like a quote attributed to me, is how you...

**中文翻译:**
我喜欢那个，就像是一句归功于我的名言，你是如何……

---

### (01:08:34) Jeffrey Pfeffer

**English:**
Yeah. Well, I don't remember saying it, but somebody said, I said it. I'll take credit for it. I said to Laura, "You want to change medicine? Medicine is not going to change without the application of power and influence." If change was going to happen, it would've happened already. You have to take on entrenched interests. She has a whole thing, which we need not go into because it's pretty technical, on screening. She said, everybody's getting a mammogram every year beyond a certain age, which is stupid for a variety of reasons. You can read, she was on the PBS NewsHour about this. This is what got her in trouble with the radiologists. The radiologists, of course, are selling screening. She said, there's some people that need to be screened every month, and there's some people that need to be screened never because of their genetics. She wants custom tailored screening or precision screening. Anyway, she fights everybody.

**中文翻译:**
是的。我不记得我说过，但有人说我说过，那我就认领了。我对劳拉说：“你想改变医学？如果不运用权力和影响力，医学是不会改变的。”如果改变能自然发生，它早就发生了。你必须挑战既得利益集团。她有一整套关于筛查的理论（我们不必深入探讨，因为非常专业）。她说，超过一定年龄的每个人每年都做乳房 X 光检查，出于各种原因是愚蠢的。你可以去读读，她曾为此上过 PBS 新闻小时。这就是她与放射科医生发生冲突的原因——放射科医生当然是在推销筛查。她说，有些人因为基因原因需要每个月筛查，而有些人则永远不需要。她想要定制化的筛查或精准筛查。总之，她和所有人斗争。

---

### (01:09:29) Jeffrey Pfeffer

**English:**
Richard Blum, Dianne Feinstein's husband, both Dianne and Richard Blum are now deceased, was at a thing where she launched the Athena Project. The Athena Project, she's now, with her collaborators, collecting data on the diagnosis and treatment and outcome for 150,000 patients in the University of California Healthcare System. So I'm supposed to give some opening talk to provide entertainment. And Dick Blum is there. Dick Blum, of course is wealthy. He's Dianne Feinstein's husband. I said to him, "Dick, how did Laura get you here?" And I still remember, I think this is a quote in one of the books I wrote. He said to me, he said, "Look." He said, "I've learned that at the end of the day when Laura asks you to do something, you may say no, but at the end of the day, you're going to do it anyway. Save yourself the aggravation."

**中文翻译:**
理查德·布鲁姆（Richard Blum，黛安·范斯坦的丈夫，两人现已去世）曾参加过她启动“雅典娜项目”的活动。在雅典娜项目中，她正与合作者一起收集加州大学医疗系统中 15 万名患者的诊断、治疗和结果数据。当时我被要求做开场演讲来助兴。迪克·布鲁姆也在场。迪克当然很富有，他是黛安·范斯坦的丈夫。我问他：“迪克，劳拉是怎么把你请到这儿来的？”我还记得，我想这在我写的一本书里引用过。他对我说：“听着，我已经学会了，归根结底，当劳拉要求你做某事时，你可能会说不，但到头来你还是会去做的。省省那些烦恼吧。”

---

### (01:10:20) Lenny Rachitsky

**English:**
Oh man, I feel like you're just endlessly full of good stories that we could just keep going on and on. Let me try to summarize the rules of power real quick and see if anything else emerges. And then have just a couple more questions. So the Seven Rules of Power, get out of your own way, break the rules, show up in a powerful fashion, create a powerful brand, network relentlessly, use your power, and understand that once you've acquired power, that what you did to get there will be forgiven, forgotten, or both. Let me ask you a question, maybe half in jest. You teach people how to acquire power. Why aren't you the most powerful man in the world?

**中文翻译:**
天哪，我觉得你简直有讲不完的好故事，我们可以一直讲下去。让我快速总结一下权力的规则，看看还有没有什么新发现，然后我还有最后几个问题。权力的七条规则：走出自我妨碍、打破规则、以有权势的方式亮相、打造强大的品牌、坚持不懈地建立人脉、运用你的权力，并且要明白，一旦你获得了权力，你为之付出的一切手段都会被原谅、被遗忘，或者两者兼有。让我问你一个问题，半开玩笑地：你教别人如何获得权力，那你为什么不是世界上最有权势的人？

---

### (01:10:57) Jeffrey Pfeffer

**English:**
Ah, that's a very good question. To which I have a very good answer. I have a colleague who's unfortunately now deceased, by the name of James G. March, who was a very, very distinguished scholar. And James March said to me many, many years ago, something which is completely true. You can have power or you can have autonomy, but you cannot have both. And I have chosen to live a life of freedom, autonomy. I could tell you stories that would bring tears to your eyes. I'll tell you one. We had a dean of the Business School whose wife was dying of cancer, and she was projected to die in the fall. So the Business School goes to him and says, we'll give you the fall off to be with your wife. She lives until June. It's now winter.

**中文翻译:**
啊，这是一个非常好的问题，我有一个非常好的答案。我有一位不幸去世的同事，名叫詹姆斯·马奇（James G. March），他是一位非常杰出的学者。詹姆斯·马奇很多年前对我说过一句话，那是千真万确的：你可以拥有权力，或者拥有自主权，但你不能两者兼得。而我选择了过一种自由、自主的生活。我可以给你讲一些让你落泪的故事。我讲一个：我们商学院曾有一位院长，他的妻子患癌症快去世了，预计在秋天去世。于是商学院对他说，我们给你秋季假期让你陪妻子。结果她一直活到了六月。现在是冬天。

---

### (01:11:46) Jeffrey Pfeffer

**English:**
You have responsibilities as the Dean of the Business School. You have to meet with alumni. You have to go around and raise money. You have to show up at events, university events. I do not necessarily think that is how he wanted to spend the winter and spring quarters, but that's what you have to do. When I wanted Jack Valenti to come to my class, I did not call Jack Valenti. I called Judy Dickey. Judy Dickey was his assistant. Judy Dickey controlled his schedule. I meet Jack on such and such a day. He can't make it on that day. Fine. I can adjust the schedule. Can he make it on this day?

**中文翻译:**
作为商学院院长，你有责任。你必须会见校友，你必须到处筹款，你必须出席各种活动、大学活动。我不认为那是他想度过冬春学期的方式，但那是你必须做的。当我想请杰克·瓦伦蒂来我班上时，我没给杰克·瓦伦蒂打电话，我给朱迪·迪基打电话。朱迪·迪基是他的助手，她控制着他的日程。我想在某天见杰克，他那天没空。好吧，我可以调整日程。他这天有空吗？

---

### (01:12:24) Jeffrey Pfeffer

**English:**
When I wanted my friend Gary Loveman, who ran Harrah's and Caesars and then was the number two executive at Aetna, I want him to come to my class. I called Reggie Kirk. I didn't call Gary Loveman. And that's all you need to know. I do not have an assistant who controls my schedule. I control my schedule. You will not find my Outlook calendar on any website, on any computer. I want autonomy. If I said to you, "Lenny, I will give you $1 billion, or for that matter, $10 billion if you can buy-"

**中文翻译:**
当我想请我的朋友加里·洛夫曼（他曾经营哈拉斯和凯撒，后来是安泰保险的二号人物）来我班上时，我给雷吉·柯克打电话，我没给加里·洛夫曼打电话。这就是你需要知道的一切。我没有控制我日程的助手，我控制我自己的日程。你不会在任何网站、任何电脑上找到我的 Outlook 日历。我想要自主权。如果我对你说：“伦尼，如果你能买到——我会给你 10 亿甚至 100 亿美元——”

---

### (01:13:01) Lenny Rachitsky

**English:**
Yes.

**中文翻译:**
是的。

---

### (01:13:02) Jeffrey Pfeffer

**English:**
Wait, if you can have last week again. You can't. You can't. Time goes in only one direction. I want control of my time. It is much more important to me, being a Dean or an Associate Dean, a job that I was asked to do. I took one academic administrative job. I'm actually memorialized, believe it or not, in the Stanford Record, as having led, and this is according to my expenses, the Nobel Prize winner who was Dean at the time, that I led the biggest and most successful transformation in the history of higher education. I did it. I did it once. I didn't like it. Life is too short. I want to do what I like.

**中文翻译:**
等一下，如果你能重新拥有上周的时间。你做不到。时间只向一个方向流动。我想要掌控我的时间。这对我来说比当院长或副院长重要得多，虽然曾有人请我做这些工作。我只担任过一次学术行政职务。信不信由你，我在斯坦福的记录中被载入史册，据当时的院长（一位诺贝尔奖得主）说，我领导了高等教育史上最大、最成功的转型。我做到了，我做了一次，但我不喜欢。人生太短了，我想做我喜欢的事。

---

### (01:13:52) Lenny Rachitsky

**English:**
That's a really profound point that I think people don't think about, is there's always this drive to acquire power. And your point is that there's a big downside, which is a lack of autonomy. Yeah. You think about the, as I was trying to get Satya Nadella on the podcast, and I talked to his comms people, and they're like, every hour for the next three months is booked already. We know what he's doing. He's extremely booked. And you think about the president, obviously at Elon. I totally get what you're saying.

**中文翻译:**
这是一个非常深刻的观点，我想人们通常不会想到这一点：人们总是有一种获取权力的冲动。而你的观点是，权力有一个巨大的副作用，那就是缺乏自主权。是的。我想起当我试图邀请萨提亚·纳德拉（Satya Nadella）参加播客时，我和他的公关人员交谈，他们说未来三个月的每一小时都已经排满了。我们知道他在做什么，他极其忙碌。想想总统，显然还有埃隆。我完全明白你在说什么。

---

### (01:14:17) Jeffrey Pfeffer

**English:**
It is true, and I don't want to do that. And by the way, power also comes with enormous visibility. Donald Trump has done, for 40 years, what he's now being accused of doing, the tax stuff, all this stuff. He's been a grifter all his life. But when you become President, people are going to look at things that in the past they would not have looked at. You become president of a university, you're going to have scrutiny as the President of Harvard Law and the President of Stanford Law, when they both had to resign, in one case because of plagiarism, in another case because of research misconduct.

**中文翻译:**
确实如此，我不想那样。顺便说一下，权力也伴随着巨大的曝光度。唐纳德·特朗普 40 年来一直在做他现在被指控的事情——税务问题等等。他一辈子都是个骗子。但当你成为总统时，人们会开始审视那些过去不会看的事情。你成为大学校长，你就会受到审查，就像哈佛法学院院长和斯坦福法学院院长一样，他们都不得不辞职，一个是因为抄袭，另一个是因为研究不端。

---

### (01:14:55) Jeffrey Pfeffer

**English:**
Power comes. You're going to be put under a microscope. People are going to look at what car you drive. They're going to look at who you go out with. They're going to look at how you spend your time. They're going to look at how you associate with, you'll have no privacy. You'll have very little control over your life. Everybody will feel completely free to dissect you in public, in private, whatever. And you'll face the trust dilemma. When you are rich and powerful the question will be, are people praising you, are people associating with you because of you or because of the position you hold?

**中文翻译:**
权力随之而来。你会被置于显微镜下。人们会看你开什么车，看你和谁约会，看你如何打发时间，看你和谁交往。你将没有隐私，对生活的掌控力极小。每个人都会觉得可以随意在公开或私下场合剖析你。而且你会面临信任困境：当你富有且有权势时，问题在于，人们赞美你、与你交往是因为你本人，还是因为你所处的职位？

---

### (01:15:41) Lenny Rachitsky

**English:**
Yeah. Do you spend any time, just to follow this thread in your class, convincing people stop being so obsessed with power, stop being so obsessed with becoming the top of everything? Is that a part of the class?

**中文翻译:**
是的。顺着这个思路，你会在课上花时间说服人们不要对权力如此痴迷，不要如此痴迷于攀登到顶峰吗？这是课程的一部分吗？

---

### (01:15:52) Jeffrey Pfeffer

**English:**
No.

**中文翻译:**
不。

---

### (01:15:52) Lenny Rachitsky

**English:**
Or is it just...

**中文翻译:**
或者只是……

---

### (01:15:53) Jeffrey Pfeffer

**English:**
No. I teach them, they see we have a class on the price of power. I bring out Rudy Crew. Rudy Crew was the New York School's Chancellor under Rudy Giuliani. By the way, he tells many interesting stories about Rudy Giuliani, who did not just become the joke that he is overnight. He's worked hard to become that. But in any event, he tells. And one year, one year, because his daughter at that time was living in the Bay Area, when I asked him about the effect of the positions he held, Head of Miami Dade County Schools, Head of New York City schools.

**中文翻译:**
不。我教导他们，他们会看到我们有一节关于“权力的代价”的课。我请出了鲁迪·克鲁（Rudy Crew）。鲁迪·克鲁曾是鲁迪·朱利安尼手下的纽约学校总监。顺便说一下，他讲了很多关于朱利安尼的趣事，朱利安尼并不是一夜之间变成现在这个笑话的，他是努力才变成那样的。但无论如何，他讲了。有一年，因为他的女儿当时住在湾区，当我问他所担任的职位（迈阿密戴德县学校负责人、纽约市学校负责人）带来的影响时。

---

### (01:16:29) Jeffrey Pfeffer

**English:**
Had Hillary ever won, he would've been Secretary of Education. Literally. There's Lauren in the room. And he said to the class, Jeffrey asked me the question, "Why don't we let Lauren answer it?" By the time she was finished, there was not a dry eye in the room. What is it like to be the child? What is it like to be the significant other of these people? And you know the answer to that because you can see the suicides, the divorce rates. There is a price that not only you pay, but a price that your family pays.

**中文翻译:**
如果希拉里赢了，他本来会成为教育部长。真的。当时劳伦（他的女儿）就在房间里。他对全班同学说：“杰弗里问了我这个问题，不如让劳伦来回答吧。”当她说完时，房间里没有一个人的眼睛是干的。作为这些人的孩子是什么感觉？作为这些人的伴侣是什么感觉？你知道答案，因为你可以看到自杀率、离婚率。这不仅是你付出的代价，也是你的家人付出的代价。

---

### (01:17:09) Lenny Rachitsky

**English:**
I think that's a really good balance to the entire conversation. Maybe just as a last question, what if we give the audience a homework assignment to work on these power rules? What's something that you'd recommend someone try to do? I know it's probably dependent on what they're good at, not good at. What's something that they could do to start moving towards one of these rules?

**中文翻译:**
我认为这为整个对话提供了一个很好的平衡。也许作为最后一个问题，如果我们给听众布置一个关于这些权力规则的作业呢？你会推荐人们尝试做些什么？我知道这可能取决于他们擅长什么、不擅长什么。他们可以做些什么来开始迈向这些规则中的某一条？

---

### (01:17:28) Jeffrey Pfeffer

**English:**
So what I would say, and it comes from something that you talked about in our conversation at several times, which is this is uncomfortable. Okay. So if I want you to do something uncomfortable, I could say, "Lenny, go do this uncomfortable thing on your own." Or I can say, "Lenny, I want you to do this with help, with social support." And so the first thing I would say to someone is, if you think this is uncomfortable, or if you think you're not skilled at this, get coaching. Get a coach.

**中文翻译:**
我想说的是，这源于我们在对话中多次谈到的：这让人不舒服。好，如果我想让你做一些不舒服的事情，我可以说明：“伦尼，你自己去做这件不舒服的事吧。”或者我可以说明：“伦尼，我希望你在帮助和社交支持下做这件事。”所以我要对大家说的第一件事是：如果你觉得这让你不舒服，或者你觉得自己不擅长这个，那就去寻求辅导。找个教练。

---

### (01:18:03) Jeffrey Pfeffer

**English:**
I send out regularly the list of the coaches who work with my online and on-campus classes. Happy to do it. And they're happy to have the business. Get a coach. Get a personal board of directors like they talk about in the Wall Street Journal. In other words, get people who will give you advice, give you social support, and hold you accountable. That's the very first thing I would tell people to do. It's hard to do anything on your own. If I said to you, "Lenny, I want you to start an extraordinarily successful podcast and I want you to do it without any help." You would not be where you are today. So that simple principle, get help.

**中文翻译:**
我定期发送与我的在线和校内课程合作的教练名单。我很乐意这样做，他们也很乐意有生意。找个教练。建立一个像《华尔街日报》所说的“个人董事会”。换句话说，找一些能给你建议、给你社交支持并让你负责的人。这是我告诉人们要做的第一件事。靠自己很难做成任何事。如果我对你说：“伦尼，我想让你创办一个极其成功的播客，而且我希望你在没有任何帮助的情况下完成。”你不会有今天的成就。所以，那个简单的原则：寻求帮助。

---

### (01:18:48) Lenny Rachitsky

**English:**
It feels like a part of rule number one. Get out of your own way. Ask for help. Jeffrey, I was nervous for this podcast because I thought this was going to be super uncomfortable stuff. It turns out all of this makes so much sense, and there's a really nice way of framing all of these rules, and there's so much reason to actually invest in these skills. So I really appreciate you putting in the time being here, sharing all these stories and insights. Is there anything else you want to share as a kind of a final note or something to leave listeners with before we wrap up? We did it. We covered everything?

**中文翻译:**
这感觉像是第一条规则的一部分：走出自我妨碍，寻求帮助。杰弗里，我之前对这次播客很紧张，因为我觉得这会是非常令人不舒服的内容。结果发现这一切都非常有道理，而且这些规则的框架非常棒，确实有充分的理由去投资这些技能。所以我非常感谢你花时间来到这里，分享所有这些故事和见解。在结束之前，你还有什么想分享的吗？或者想留给听众的最后一段话？我们讲完了吗？涵盖了所有内容吗？

---

### (01:19:19) Jeffrey Pfeffer

**English:**
No, I'm happy. I'm happy you're a very good interviewer, which is why your podcast is so successful.

**中文翻译:**
不，我很满意。我很高兴你是一位非常优秀的采访者，这也是你的播客如此成功的原因。

---

### (01:19:24) Lenny Rachitsky

**English:**
I appreciate that.

**中文翻译:**
我很感激。

---

### (01:19:25) Jeffrey Pfeffer

**English:**
I'm happy to spend the time with you, and I hope whoever listens to this will, I hope, first of all, there'll be a lot of listeners, but I also hope that they will find it useful.

**中文翻译:**
我很乐意花时间和你在一起，我希望收听这个节目的所有人——首先我希望会有很多听众——我也希望他们会发现它很有用。

---

### (01:19:32) Lenny Rachitsky

**English:**
I know they will. Two final questions. Where can folks find you online if they, or find your book, I guess, if they want to learn more? And then how can listeners be useful to you?

**中文翻译:**
我知道他们会的。最后两个问题：如果大家想了解更多，可以在哪里找到你或你的书？以及，听众可以为你做些什么？

---

### (01:19:41) Jeffrey Pfeffer

**English:**
So you can find my book anywhere where books are sold. Don't look at a physical bookstore because nobody carries it, including actually Stanford bookstore, where they run out of it if people... And you can find it on Amazon. Seven Rules of Power. So that's how you can find the book. By the way, at the end of the book I talk about, I have a personal website, jeffreypfeffer.com. If you go to that website, you can find my course outline. So you can take the course on your own if you want, or get somebody or take it in a group of people.

**中文翻译:**
你可以在任何卖书的地方找到我的书。别去实体书店找，因为没人备货，甚至包括斯坦福书店，如果人们……你可以在亚马逊上找到它，《权力的七条规则》。这就是找书的方法。顺便说一下，在书的末尾我提到了我的个人网站 jeffreypfeffer.com。如果你访问那个网站，你可以找到我的课程大纲。所以如果你愿意，你可以自学这门课，或者找人一起学，或者小组学习。

---

### (01:20:13) Jeffrey Pfeffer

**English:**
You can find research, you can find articles, you can find columns. You can follow me on LinkedIn or I don't do Twitter anymore, but you can follow me on LinkedIn. So there are a lot of resources available for this. A company was once thinking of hiring me to give a talk in their organization, and the woman who wound up hiring me said, "When I was discussing you and arguing that we should hire you for this presentation, one of the people in the committee said, is he a good presenter?" And her answer, I love this. I remember this. Her answer was, "He's a fabulous educator." My job is to educate. That is why I have done what I have done for now more than 50 years.

**中文翻译:**
你可以找到研究报告、文章和专栏。你可以在 LinkedIn 上关注我，我不再用 Twitter 了。所以有很多相关资源。曾经有一家公司考虑聘请我去演讲，最终聘请我的那位女性说：“当我讨论你并主张聘请你做这次演讲时，委员会中的一个人问：‘他是一个好的演讲者吗？’”她的回答——我喜欢这个，我记得很清楚——她的回答是：“他是一位出色的教育家。”我的工作就是教育。这就是为什么我从事这项工作已经超过 50 年了。

---

### (01:21:03) Lenny Rachitsky

**English:**
Holy moly. I didn't even realize that.

**中文翻译:**
天哪，我甚至都没意识到这一点。

---

### (01:21:06) Jeffrey Pfeffer

**English:**
For more than 50 years, I have been in the business of education. Not just about power, but about many other things as well. But I'm in the education business, so I'm happy to provide people with the resources, with the readings. The Seven Rules of Power is well footnoted. It talks at the end about we could reach out for the coaches. You can go to the website and get the book. But I think consistent with what you and I have talked about, if all you do is read, you're not going to make very much progress. You have to do it. You cannot learn tennis by reading about tennis, or by watching a movie about Serena or Venus Williams. You have to actually get out on the court and do it.

**中文翻译:**
50 多年来，我一直从事教育事业。不仅是关于权力，还有很多其他事情。但我从事的是教育行业，所以我很乐意为人们提供资源和阅读材料。《权力的七条规则》有详尽的脚注。书末谈到了我们可以联系教练。你可以去网站买书。但我认为，正如你我所讨论的，如果你只是阅读，你不会取得太大进步。你必须去做。你不能通过阅读网球书籍或观看塞雷娜或维纳斯·威廉姆斯的电影来学会打网球。你必须真正走上球场去打。

---

### (01:21:51) Lenny Rachitsky

**English:**
Which is a good plug for your other book, the Knowing-Doing Gap, which actually helps you with the skill, which you can also find all your finer retailers. Jeffrey Pfeffer, thank you so much for being here.

**中文翻译:**
这正好为你另一本书《知行差距》做了个很好的宣传，那本书实际上能帮助你掌握这项技能，你也可以在各大零售商那里找到它。杰弗里·普费弗，非常感谢你能来到这里。

---

### (01:22:04) Jeffrey Pfeffer

**English:**
Thank you for having me on your show.

**中文翻译:**
谢谢你邀请我参加你的节目。

---

### (01:22:06) Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at LennysPodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到这个播客。你可以在 LennysPodcast.com 找到所有往期节目或了解更多信息。下期节目再见。