# Jen Abel 2.0 - 双语对照

这是一份关于《Lenny's Podcast》嘉宾 Jen Abel 访谈内容的完整双语对照文档。

---

### [00:00:00] Jen Abel

**English:**
You need to vision cast, you need to sell to a gap, don't sell to a problem. When you're selling to a leader, you need to be selling an opportunity. The market doesn't want to be sold to, they want to buy.

**中文翻译:**
你需要描绘愿景（vision cast），你需要针对“差距”进行销售，而不是针对“问题”。当你向领导者销售时，你卖的应该是一个机会。市场并不想被推销，他们想要的是主动购买。

---

### [00:00:12] Lenny Rachitsky

**English:**
Most founders would rather get 10, 10K deals than lose nine and get one 100K deal.

**中文翻译:**
大多数创始人宁愿拿到 10 个 1 万美元的小单，也不愿丢掉 9 个单子只为了拿下一个 10 万美元的大单。

---

### [00:00:17] Jen Abel

**English:**
In the very early days, people will discount till the cows come home because they think that's the way to get a deal done. The best clients are not going to do that to you. If they're sitting there nickel-and-diming you, they're not fully bought in on what you're selling them.

**中文翻译:**
在创业初期，人们会没完没了地打折，因为他们觉得那是达成交易的唯一途径。但最好的客户不会这样对你。如果他们在那儿斤斤计较，说明他们并没有完全认可你卖给他们的价值。

---

### [00:00:31] Lenny Rachitsky

**English:**
It might be giving you a false sense of success and product market fit.

**中文翻译:**
这可能会给你一种虚假的成功感，让你误以为已经达到了产品市场契合点（PMF）。

---

### [00:00:34] Jen Abel

**English:**
As soon as you become a comparison, as soon as you become one of three that they're testing out, you've already sort of lost. It's all about differentiation. Here's what you will be able to do tomorrow because of how we're going to serve you today.

**中文翻译:**
一旦你沦为被比较的对象，一旦你成为他们测试的三个备选方案之一，你就已经输了一半。销售的核心在于差异化。你应该告诉客户：因为我们今天的服务，你明天将能实现什么样的飞跃。

---

### [00:00:48] Lenny Rachitsky

**English:**
Something else that you talk about is that enterprise sales is very creative.

**中文翻译:**
你提到的另一件事是，大客户销售（Enterprise Sales）是非常具有创造性的。

---

### [00:00:52] Jen Abel

**English:**
It's more of an art. It's all about deal crafting. It is a relationship you're building with someone. If they know they can call on you, people will turn over rocks for you. I have a client at a Fortune 10 company where I was like, "It's so important we get the deal done this year. Is that possible?" And she's like, "It's a tall order, but if it's going to help you, let's do it." These are how enterprise deals gets done. It's relationships.

**中文翻译:**
这更像是一门艺术。核心在于交易的设计（deal crafting）。你是在与人建立关系。如果客户知道他们可以随时找你，他们会为你排除万难。我有一个财富 10 强公司的客户，我当时对她说：“今年达成这笔交易对我们非常重要，有可能吗？”她回答说：“这任务很艰巨，但如果这能帮到你，那我们就做吧。”大客户交易就是这样达成的，靠的是关系。

---

### [00:01:15] Lenny Rachitsky

**English:**
What's kind of like the state of the art on go-to-market outbound tooling?

**中文翻译:**
目前在市场开拓（GTM）的主动触达（Outbound）工具方面，最前沿的技术是什么样的？

---

### [00:01:18] Jen Abel

**English:**
I don't use a tool. The thing about AI tools is they're all pulling from the same databases. I want to email someone not in the database that's getting hit by a million folks. I want to take a back door in, not the front door where everyone else is trick or treating.

**中文翻译:**
我不使用工具。AI 工具的问题在于它们都在调用相同的数据库。我想给那些不在数据库里、没被成千上万人骚扰的人发邮件。我想走后门，而不是走那个所有人都在像万圣节讨糖一样挨家挨户敲门的前门。

---

### [00:01:33] Lenny Rachitsky

**English:**
Today, my guest is Jen Abel, co-founder of JJELLYFISH where she and her team help early stage founders learn how to sell and now GM of Enterprise at State Affairs. If you want to become better at selling your product, this episode is going to blow your mind and make you so much better in every way. This is the second time Jen's been on the podcast. Our first conversation was focused around getting from zero to 1 million ARR, essentially founder led sales.
(00:01:59):
This conversation is part two going from around one million in ARR to around 10 million. This is the most tactical and in the weeds discussion you will find anywhere for free on how to actually become more effective at selling to enterprises. I'm so excited for you to listen to this conversation. If you enjoy this podcast, don't forget to subscribe and followed in your favorite podcasting app or YouTube, it helps tremendously.
(00:02:22):
And if you become an annual subscriber of my newsletter, you get 17 incredible products for free for an entire year, including Devin, Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD and Mobbin. Head on over to lennysnewsletter.com and click Product Pass. With that, I bring you Jen Abel after a short word from our sponsors.

**中文翻译:**
今天的嘉宾是 Jen Abel，她是 JJELLYFISH 的联合创始人，在那里她和团队帮助早期创始人学习如何销售；她现在也是 State Affairs 的大客户部总经理。如果你想提高产品销售能力，这一集会让你大开眼界，让你在各方面都变得更强。这是 Jen 第二次来到播客。我们第一次对话集中在如何从 0 做到 100 万美元 ARR（年度经常性收入），本质上是创始人驱动的销售。
(00:01:59):
这次对话是第二部分，讨论如何从 100 万美元 ARR 增长到 1000 万美元。这是你在任何地方都能免费听到的、关于如何更有效地向企业销售的最具战术性、最深入细节的讨论。我非常期待你们收听这次对话。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注，这对我们帮助很大。
(00:02:22):
如果你成为我时事通讯的年度订阅者，你将免费获得 17 款不可思议的产品的一年使用权，包括 Devin, Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD 和 Mobbin。请访问 lennysnewsletter.com 并点击 Product Pass。在听完赞助商的简短介绍后，我们将请出 Jen Abel。

---

### [00:02:47] Lenny Rachitsky (Sponsor: WorkOS)

**English:**
Here's a puzzle for you. What do OpenAI, Cursor, Perplexity, Vercel, Platt, and hundreds of other winning companies have in common? The answer is they're all powered by today's sponsor, WorkOS. If you're building software for enterprises, you've probably felt the pain of integrating single sign-on, SKIM, RBAC, audit logs and other features required by big customers. WorkOS turns those deal blockers into drop-in APIs with a modern developer platform built specifically for B2B SaaS.
(00:03:16):
Whether you're a seed-stage startup trying to land your first enterprise customer or a unicorn expanding globally, WorkOS is the fastest path to becoming enterprise-ready and unlocking growth. They're essentially Stripe for enterprise features. Visit workos.com to get started or just hit up their Slack support where they have real engineers in there who answer your questions superfast. WorkOS allows you to build like the best with delightful APIs, comprehensive docs, and a smooth developer experience. Go to Workos.com to make your app enterprise ready today.

**中文翻译:**
给你出一个谜题。OpenAI、Cursor、Perplexity、Vercel、Platt 以及数百家其他成功的公司有什么共同点？答案是：它们都由今天的赞助商 WorkOS 提供支持。如果你正在为企业开发软件，你可能感受过集成单点登录（SSO）、SCIM、基于角色的访问控制（RBAC）、审计日志以及大客户要求的其他功能的痛苦。WorkOS 将这些交易阻碍变成了即插即用的 API，它是一个专门为 B2B SaaS 构建的现代开发平台。
(00:03:16):
无论你是试图拿下第一个企业客户的种子轮初创公司，还是正在全球扩张的独角兽，WorkOS 都是让你具备企业级能力并释放增长的最快路径。它们本质上是企业级功能的“Stripe”。访问 workos.com 开始使用，或者直接联系他们的 Slack 支持，那里有真正的工程师会飞速回答你的问题。WorkOS 让你能像顶尖公司一样，通过愉悦的 API、详尽的文档和流畅的开发体验进行构建。立即访问 Workos.com，让你的应用具备企业级能力。

---

### [00:03:48] Lenny Rachitsky (Sponsor: Lovable)

**English:**
This episode is brought to you by Lovable. Not only are they the fastest growing company in history, I use it regularly and I could not recommend it more highly. If you've ever had an idea for an app, but didn't know where to start, Lovable is for you. Lovable lets you build working apps and websites by simply chatting with AI. Then you can customize it at automations and deploy it to live domain. It's perfect for marketers, spinning up tools, product managers, prototyping new ideas and founders launching their next business.
(00:04:17):
Unlike no-code tools, Lovable isn't about static pages. It builds full apps with real functionality and it's fast. What used to take weeks, months, or years, you can now do over a weekend. So if you've been sitting on an idea, now is the time to bring it to life. Get started for free at lovable.dev, that's lovable.dev. Jen, thank you so much for being here, welcome to the podcast.

**中文翻译:**
本集由 Lovable 赞助。他们不仅是历史上增长最快的公司，我也经常使用它，强烈推荐。如果你曾有过开发应用的念头却不知从何下手，Lovable 就是为你准备的。Lovable 让你只需通过与 AI 聊天就能构建可运行的应用和网站。然后你可以进行自定义、添加自动化并部署到线上域名。它非常适合营销人员快速搭建工具、产品经理原型化新想法以及创始人启动下一个业务。
(00:04:17):
与无代码（no-code）工具不同，Lovable 不仅仅是制作静态页面。它构建的是具有真实功能的完整应用，而且速度极快。过去需要几周、几个月甚至几年的工作，现在一个周末就能完成。所以，如果你一直有一个想法，现在就是让它成真的时候。在 lovable.dev 免费开始，即 lovable.dev。Jen，非常感谢你能来，欢迎来到播客。

---

### [00:04:45] Jen Abel

**English:**
Lenny, it's starting to feel familiar and I like it.

**中文翻译:**
Lenny，这种感觉开始变得熟悉了，我喜欢这种感觉。

---

### [00:04:48] Lenny Rachitsky

**English:**
I should have said welcome back to the podcast. So I actually shared on Twitter that you're coming back and I had so many people ask so many questions. Clearly, there is a lot of confusion and a lot of need for learning how to get better at the stuff, we're going to talk about sales, enterprise sales to frame the discussion, our first chat, which we're going to point people to if they want to start there, we focused on founder-led sales, which is essentially the beginning phases of a startup, kind of going from zero to about 100 million ARR.
(00:05:17):
This discussion is on the next phase, which is going from about a million ARR to about 10 million ARR in enterprise sales, not like PLG or anything like that. You have a bunch of really strong and counter intuitive opinions and piece of advice on how to be successful at this. So I'm just going to go through a bunch of these things. We'll see where it goes. Before we get into the first one, is there anything broadly, I don't know, is there anything broadly you want to share? Anything you want to say before we dive in?

**中文翻译:**
我应该说欢迎回到播客。我其实在 Twitter 上分享了你要回来的消息，结果有很多人问了很多问题。显然，大家对于如何做好这些事情有很多困惑，也有很大的学习需求。我们将讨论销售，特别是企业销售。为了给讨论定个调，我们第一次聊天（如果大家想从头开始，我们会提供链接）重点是创始人驱动的销售，这基本上是初创公司的初始阶段，大约是从 0 到 100 万美元 ARR。
(00:05:17):
这次讨论的是下一个阶段，即在企业销售领域（不是 PLG 模式之类）从 100 万美元 ARR 增长到 1000 万美元左右。你对于如何在这个阶段取得成功有很多非常强烈且违背直觉的观点和建议。我会逐一探讨这些内容。在进入第一个话题之前，你有什么宏观的想法想分享吗？或者在深入探讨前有什么想说的？

---

### [00:05:41] Jen Abel

**English:**
No, let's dive right in.

**中文翻译:**
没有，我们直接开始吧。

---

### [00:05:42] Lenny Rachitsky

**English:**
Okay. Okay, so the first thing that I haven't heard anyone talk about before is this point that you often make that the mid-market does not exist. People often hear about enterprise companies. There's obviously SMBs and startups. There's also people just, "Oh, I'm going to go after the mid-market." Somewhere between. You don't think that's real? Talk about your experience there, what people should know.

**中文翻译:**
好的。第一件事是我以前从未听人提起过的，就是你经常说“中端市场（mid-market）并不存在”。人们经常听到企业级公司，显然还有中小企业（SMB）和初创公司。但也有些人会说：“哦，我要去攻克中端市场。”也就是介于两者之间。你不认为那是真实存在的？谈谈你在那方面的经验，以及人们应该了解什么。

---

### [00:06:03] Jen Abel

**English:**
It's fascinating because if you ask someone to describe the mid-market, actually, if you ask someone to describe the enterprise, every single person has a different answer. It's either based off of revenue, it's either based off of market cap, it's based off of employee size, and I think a lot of people can get lost because selling to a hundred person organization is a radically different game than selling to a thousand person organization and there's no hybrid approach.
(00:06:35):
So the best way to think about it is you have small business which typically can be really powered by marketing, and then you have enterprise, which is typically going to be sales led. If you bucket them into these two very specific silos, it makes it much, much easier to understand what game you're playing. Now, when we talk about mid-market, I usually will say, "Are we talking about the upper end of small business or are we talking about the lower end of enterprise?"
(00:07:04):
And most people are usually saying the lower end of enterprise. And I say, "Great, know you're playing the enterprise game. Know the type of people you need to hire, the type of ACV they need because it makes it a lot easier than trying to have this middle ground that catches everything that doesn't distinctly define SMB and enterprise." So I say the mid-market doesn't exist because what is a mid-market hire? It's either low end enterprise or upper end SMB, and if you bleed those two games you're going to lose. They're so distinctly different. So that's kind of my theory on it.

**中文翻译:**
这很有趣，因为如果你让某人描述中端市场，或者描述企业级市场，每个人的答案都不一样。要么基于收入，要么基于市值，要么基于员工规模。我认为很多人会迷失，因为向一家 100 人的组织销售与向一家 1000 人的组织销售是完全不同的玩法，不存在混合路径。
(00:06:35):
所以最好的思考方式是：你面对的是小企业（通常由营销驱动），或者是大企业（通常由销售驱动）。如果你把它们归入这两个非常具体的类别，就更容易理解你正在玩什么样的游戏。现在，当我们谈论中端市场时，我通常会问：“我们是在谈论小企业的高端，还是大企业的低端？”
(00:07:04):
大多数人通常指的是大企业的低端。我会说：“太好了，那你就知道你是在玩大企业销售的游戏。了解你需要雇佣什么样的人，他们需要的 ACV（平均合同价值）是多少，这比试图建立一个模糊的中端地带要容易得多。”所以我说中端市场不存在，因为什么是中端市场的雇员？要么是低端大企业销售，要么是高端小企业销售，如果你混淆了这两者，你就会输。它们截然不同。这就是我的理论。

---

### [00:07:36] Lenny Rachitsky

**English:**
You have this chart that you shared with me that will link people to where you kind of show the number of companies within each of these segments and there's basically nobody in this kind of middle segment, talk about that a bit.

**中文翻译:**
你跟我分享过一张图表（我们会提供链接），展示了每个细分市场中的公司数量，基本上那个中间地带没什么公司。谈谈这个。

---

### [00:07:46] Jen Abel

**English:**
That's right, and just like the power laws, if you look at the Fortune 1,000 and then the lower end enterprise from there, it trails off so fast. Power laws totally exist in these large corporations and we can't be treating everyone the same.

**中文翻译:**
没错，就像幂律（power laws）一样，如果你看财富 1000 强，然后看从那往下的低端企业市场，数量下降得非常快。在这些大公司中，幂律完全适用，我们不能对所有人都一视同仁。

---

### [00:08:08] Lenny Rachitsky

**English:**
This begs the question, where do you suggest companies start? There's obviously startups classically are just like innovators, move fast, can make quick decisions, enterprises have all the money. Usually the advice I hear is just don't go after the fancy companies to start because they take a long time. You don't want to screw it up. What's your advice on where to start for most companies?

**中文翻译:**
这就引出了一个问题：你建议公司从哪里开始？显然，初创公司通常是创新者，行动快，能迅速做决定；而大企业则拥有所有的资金。通常我听到的建议是，刚开始不要去碰那些大名鼎鼎的公司，因为周期太长，你不想搞砸。你对大多数公司从哪开始有什么建议？

---

### [00:08:30] Jen Abel

**English:**
The exact opposite. Early adopters are those logos because they have to continue to stay at the number one spot. So they'll take tons of swings to continue to stay in the ... Staying in the number one spot is the hardest part. So those number one logos are like if you can give me just a slight bit of alpha, just a tiny bit, that's where I get promoted, that's where I get the pat on the back because we are the world's leader in our industry and we cannot be disrupted there.
(00:09:05):
So there's this running joke where not a running joke, there's this running statement where a lot of VCs will say, "Don't go after tier one logos, go learn down market." Or, "o learn from logos that don't necessarily carry a lot of weight." The ones that carry all the weight are the ones that are willing to take a shot and want to help, right? Because they also want to be, they also want to be able to dictate the roadmap.
(00:09:30):
Now it's the founder's job to decide what can be done and what shouldn't be done, but their voice takes you a $100,000 deal into a million dollar deal in a very short period of time. It will literally guide you there. So when someone says, "Hey, go after startups, such as short sales cycle." Yeah, that makes sense. I totally get that. It's very easy to define the decision maker.
(00:09:54):
It's very easy, you don't have to go through procurement, but in the age of AI where it's all about sucking the oxygen out of the room and winning the deal and getting your foot in the door as quickly as humanly possible before someone else tries to take that, you want to get to the enterprise as fast as humanly possible.

**中文翻译:**
恰恰相反。那些大品牌才是真正的早期采用者，因为他们必须保持第一的位置。所以他们会进行大量的尝试来维持……保持第一是最难的部分。所以那些顶级品牌的心态是：如果你能给我哪怕一点点“超额收益”（alpha），哪怕只有一点点，那就是我获得晋升、获得赞赏的机会，因为我们是行业的全球领导者，我们不能在那里被颠覆。
(00:09:05):
所以有一个常有的说法（不是笑话），很多风投会说：“不要去碰一线大厂（tier one logos），先去低端市场学习。”或者“去那些没什么分量的品牌那里学习。”但真正有分量的品牌才是那些愿意尝试并想提供帮助的，对吧？因为他们也想能够主导产品路线图。
(00:09:30):
虽然决定什么该做、什么不该做是创始人的职责，但这些大客户的声音能在很短时间内把一个 10 万美元的单子变成 100 万美元的单子。他们会实实在在地引导你。所以当有人说：“嘿，去找初创公司吧，销售周期短。”是的，这有道理，我完全理解。定义决策者很容易。
(00:09:54):
这很容易，你不需要经过采购流程。但在 AI 时代，一切都在于抢占先机、赢得交易，并在别人尝试之前尽可能快地切入市场，你必须尽可能快地进入大企业市场。

---

### [00:10:12] Lenny Rachitsky

**English:**
Just so folks understand what we're talking about here, when you say tier one, what's a good way to think about what tier one is?

**中文翻译:**
为了让大家明白我们在说什么，当你提到“一线大厂”（tier one）时，该如何定义它？

---

### [00:10:16] Jen Abel

**English:**
Tier one is like your Walmarts, your McDonald's, your NVIDIAs, your Tesla, your ExxonMobil, your UnitedHealthcare, the logos that are the leader in their space, their job is to stay in the number one spot.

**中文翻译:**
一线大厂就是像沃尔玛、麦当劳、英伟达、特斯拉、埃克森美孚、联合健康保险这些公司。它们是各自领域的领导者，它们的任务就是稳坐头把交椅。

---

### [00:10:46] Lenny Rachitsky

**English:**
Wow. Your advice is because this is very counterintuitive. This is exactly what you're here not to do. Your advice is go after the Chevrons and the Mobils and the Walmarts as a startup.

**中文翻译:**
哇。你的建议非常违背直觉。这正是通常被告诫不要去做的事。你的建议是，作为一家初创公司，要去攻克雪佛龙、美孚和沃尔玛。

---

### [00:10:46] Jen Abel

**English:**
Because if you can get them, that's all the proof you need.

**中文翻译:**
因为如果你能拿下它们，那就是你所需的全部证明。

---

### [00:11:01] Jen Abel

**English:**
First of all, make sure the founder is involved, right? Everyone loves talking to a founder, so we'll start with let's get the founder involved as fast as human possible. The second is you need to vision cast, you need to sell to a gap, don't sell to a problem. There's a very big difference between problem selling and gap selling. Problem selling is highly specific, more technical than not, and it's the way that every salesperson is going to go about it, find the problem and anchor to it.
(00:11:33):
When you're selling to a leader, you need to be vision casting and you need to be selling an opportunity which is they are here, here's where we can take you. You know that image where it's like Mario or Mario, and then there's the mushroom and then there's Mario on blast, and everyone is like, "Don't sell the mushroom, sell Mario on blast." Well, that's exactly what it's saying.
(00:11:57):
It's about selling the opportunity. That's what gets the tier one logos excited and that is the best thing for a founder to sell, selling the vision versus the problem, and also it's what gets them to want to take a swing. Who wants to take a swing because you can do some small problem? They're not going to go to bath for that.

**中文翻译:**
首先，确保创始人参与其中，对吧？大家都喜欢和创始人交流，所以我们要尽可能快地让创始人介入。第二，你需要描绘愿景（vision cast），你需要针对“差距”销售，而不是针对“问题”。“问题销售”和“差距销售”有很大区别。问题销售非常具体，通常偏向技术，这是每个销售员都会做的事：找到问题并锚定它。
(00:11:33):
当你向领导者销售时，你需要描绘愿景，你需要销售一个机会，即：他们现在在这里，而我们可以带他们去那里。你知道那张图吗？马里奥，然后是蘑菇，然后是变身后的超级马里奥。大家都说：“不要卖蘑菇，要卖变身后的超级马里奥。”这正是我想表达的。
(00:11:57):
关键在于销售机会。这才是让一线大厂兴奋的地方，也是创始人最擅长卖的东西——卖愿景而不是卖问题。这也是让他们愿意尝试的原因。谁会为了解决一个小问题而大费周章呢？他们不会为此去冒险。

---

### [00:12:23] Jen Abel

**English:**
We have an ability to deliver alpha, meaning, we have information, we have data, we have a way of working that no one else can do or is going to unlock a new way of thinking for you or an ability to deliver to a customer or an ability to solve a problem. Right now, you have an ability to access this level of information. I have an opportunity through our resources or through this gated data, we have access to get you much further upstream so that you can get information faster sooner. It's kind of like the high-frequency trading that one second, that one second. They didn't do much. They didn't sell, "Oh, we're doing fiber cable connectivity. We're giving you one second of alpha before everyone else." It's more of that ability and that's not problem-selling, that's opportunity selling.

**中文翻译:**
我们有能力提供“超额收益”（alpha），这意味着我们拥有信息、数据和一种别人无法复制的工作方式，或者能为你开启一种全新的思维方式，或者一种交付给客户的能力，或者解决问题的能力。目前，你只能获取这个级别的信息。而我有一个机会，通过我们的资源或这些受限数据，我们可以让你进入更上游的环节，从而让你更早、更快地获得信息。这有点像高频交易，就差那一秒钟。他们卖的不是“哦，我们在做光纤连接”，而是“我们比别人多给你一秒钟的领先优势”。这更多是一种能力，这不是问题销售，而是机会销售。

---

### [00:13:22] Lenny Rachitsky

**English:**
I like this phrasing of just giving them alpha, that's such a simple way to imagine what this should feel like. We'll link to that image you're talking about with the Mario and-

**中文翻译:**
我喜欢“给他们 alpha”这个说法，这是一种非常简单的方式来想象这种感觉。我们会链接到你提到的那张马里奥的图片……

---

### [00:13:23] Jen Abel

**English:**
You know that image?

**中文翻译:**
你知道那张图？

---

### [00:13:23] Lenny Rachitsky

**English:**
Yeah, the person that made that image originally is Kathy Sierra, if you remember her, do you remember? So there's this person, Kathy Sierra, she's from back in the day. This was a big, I don't know, lesson she taught is you want to not sell your people on a feature or a product. You want to sell them on them becoming a superhero.

**中文翻译:**
是的，最初制作那张图的人是 Kathy Sierra，如果你还记得她的话。Kathy Sierra 是早期的名人。她教过一个很重要的道理：你不要向人们推销功能或产品，你要向他们推销“他们将成为超级英雄”这个愿景。

---

### [00:13:42] Jen Abel

**English:**
Yeah, that's right.

**中文翻译:**
是的，没错。

---

### [00:13:43] Lenny Rachitsky

**English:**
They are now a superhero because of the thing you've built for them. And so the vision here is here's how you become a superhero. Here's how this alpha will help you become more successful.

**中文翻译:**
因为你为他们构建的东西，他们现在成了超级英雄。所以这里的愿景是：这就是你如何成为超级英雄的过程，这就是这个 alpha 如何帮助你变得更成功。

---

### [00:13:50] Jen Abel

**English:**
And that's why founders are so good at selling because they naturally go to vision selling and vision casting versus a typical trained salesperson is find the problem, ask these questions and it just kills the vibe. It just feels like you're talking to a salesperson, right?
(00:14:08):
It's like, "What's your script? And it's like that's not vision selling, that's like playbook selling." And in the age of AI where a lot of it is Alpha, it's about speed, it's about getting access to information, it's about training data, and look at how the market is reacting to it. It's all opportunity and it's all about the alpha.

**中文翻译:**
这就是为什么创始人如此擅长销售，因为他们天生就会进行愿景销售和愿景描绘。相比之下，典型的受过培训的销售员则是寻找问题、问这些问题，这会让气氛变得索然无味。感觉就像在和推销员说话，对吧？
(00:14:08):
就像是“你的话术是什么？”这根本不是愿景销售，而是套路化销售。在 AI 时代，很多东西都关乎 alpha，关乎速度，关乎获取信息，关乎训练数据。看看市场对此的反应就知道了，全是机会，全是关于 alpha。

---

### [00:14:30] Lenny Rachitsky

**English:**
So just to make this more concrete for people, Sam, like sales person at Cursor, what would be an example of vision casting? The obvious idea there is your team will be more productive, you'll get more done faster than everybody else. Is that a big enough vision to cast?

**中文翻译:**
为了让大家更具体地理解，比如 Cursor 的销售人员，愿景描绘的例子会是什么？显而易见的想法是“你的团队会更高效，你会比别人做得更快”。这算是一个足够大的愿景吗？

---

### [00:14:47] Jen Abel

**English:**
I think it may be more of you'll be able to actually hire the 10X engineers that you don't necessarily have access to because they want to be able to use this type of tool. It's about letting them get differentiated talent or that's probably more of what I would anchor to of this is the 10X engineers use cursor. You don't, do you want access to 10X engineers?

**中文翻译:**
我认为可能更多是：你将能够真正招募到那些你原本接触不到的“十倍效能工程师”（10X engineers），因为他们想使用这种工具。这关乎让他们获得差异化的人才。我可能会锚定在这一点上：顶尖的十倍效能工程师都在用 Cursor，而你没用，你想接触到这些工程师吗？

---

### [00:15:16] Lenny Rachitsky

**English:**
They won't even join your company if you're not using Cursor.

**中文翻译:**
如果你不用 Cursor，他们甚至都不会加入你的公司。

---

### [00:15:18] Jen Abel

**English:**
Yeah, yeah. Think about it. So many people are so specific about what they're able to, I think especially technical folks, I'm not a technical person, but I would imagine that they're not going to go to, they don't like to go to these corporations because they're forced to use some incumbent tools.

**中文翻译:**
没错。想想看，很多人对他们能使用的工具非常挑剔，尤其是技术人员。我不是技术人员，但我能想象他们不想去某些大公司，因为在那里他们被迫使用一些陈旧的工具。

---

### [00:15:35] Lenny Rachitsky

**English:**
Going back to going after these larger companies, I asked your colleague, Justin, what he sees you do that most impacts the success that teams have with their sales process. And there's a bunch of I'm going to touch on, but one is most founders are insecure about asking for large ACVs for charging, or the way he put it is most founders would rather get 10 10K deals than lose nine and get one 100K deal. Talk about your advice there and what you see.

**中文翻译:**
回到攻克大公司的话题。我问过你的同事 Justin，他认为你做的哪件事对团队销售流程的成功影响最大。我之后会提到好几点，但其中一点是：大多数创始人在要求高额 ACV（年度合同价值）收费时感到不自信。或者用他的话说，大多数创始人宁愿拿到 10 个 1 万美元的单子，也不愿丢掉 9 个单子只为了拿下一个 10 万美元的单子。谈谈你在这方面的建议和你所看到的现象。

---

### [00:16:04] Jen Abel

**English:**
There are in the very early days is people will discount till the cows come home because they think that's the way to get a deal done. The best clients are not going to do that to you because that's like a qualification criteria, which is like if they're sitting there nickel-and-diming you being like, "No, I don't believe it's worth this. I don't believe it's worth that." They're not fully bought in on what you're selling them.
(00:16:32):
So when I say I'd rather get $100,000 deal than $10,000 deals, I'd rather have one rock star client that's going to help me figure out the next stage of where this is going than 10 or maybe five that are a good fit, five that are not, and I still have to serve those five that are not a good fit, and that's going to distract me. So this is why I love enterprise sales is they're not going to do the hard work of bringing you in if it's not critical or if it's not, when I say critical, it's going to impact them in a way that they're going to make it successful, that's what I love about enterprise sales.
(00:17:14):
They have the resources to ensure that it gets implemented because most in today's day and age, if people are not using the tool, you just get rid of the tool. So they're going to want to make sure whatever they bring in, what they go to bat for, remember, they go to bat once every two years, maybe once every three years. You've got to make it feel incredible. You've got to make it feel like they're going to be a superhero going back to it.
(00:17:42):
Otherwise, what's the point? Because the way enterprises are structured is it is designed today to make it hard to buy because they want to make sure whatever you're bringing in, you really, really want it gets rid of the mediocre. I think this would be good and it gets to this is going to change the way we work. It's going to impact our ability to capture some form of alpha, however you want to define that for them and it's sticky because of that.

**中文翻译:**
在创业初期，人们会没完没了地打折，因为他们觉得那是达成交易的唯一途径。但最好的客户不会这样对你，因为这本身就是一个筛选标准：如果他们坐在那儿斤斤计较，说“不，我不觉得值这个价”，那说明他们并没有完全认可你卖的东西。
(00:16:32):
所以当我说我宁愿要一个 10 万美元的单子而不是 10 个 1 万美元的单子时，我的意思是，我宁愿要一个能帮我摸清下一阶段发展方向的“明星客户”，也不想要 10 个客户，其中 5 个合适，5 个不合适，而我还得服务那 5 个不合适的客户，这会让我分心。这就是我喜欢大客户销售的原因：如果不是至关重要，或者不能产生重大影响，他们不会费劲把你引进来。
(00:17:14):
他们有资源确保产品得到实施。在当今时代，如果人们不用这个工具，你就会被踢出局。所以他们会确保他们支持引进的东西能够成功。记住，他们每两三年才会有一次大动作。你必须让这种感觉非常棒，让他们觉得自己成了超级英雄。
(00:17:42):
否则，意义何在？因为大企业的架构设计就是为了让购买变得困难，他们想确保你带进来的东西是他们真正想要的。这淘汰了平庸的想法。它从“我觉得这可能不错”变成了“这将改变我们的工作方式，将影响我们获取某种形式 alpha 的能力”。正因如此，这种关系才具有粘性。

---

### [00:18:16] Lenny Rachitsky

**English:**
So your advice here broadly is don't pay attention to the smaller 10K-ish kind of opportunities for a bunch of reasons. One is it might be giving you a false sense of success in product market fit. Two, those companies are maybe not as innovative and won't lead you in the right direction. Three are probably discounts just like your product than your pricing just gets thrown off.

**中文翻译:**
所以你这里的建议大致是：不要关注那些 1 万美元左右的小机会，原因有很多。第一，它可能给你一种关于 PMF 的虚假成功感。第二，这些公司可能没那么有创新精神，不会引导你走向正确的方向。第三，这可能会导致打折，从而打乱你的产品定价体系。

---

### [00:18:38] Jen Abel

**English:**
Yep, and also you don't really get taken seriously for 10K. You get way more taken seriously for a 100Ks, it's much harder to get a 100K deal done and an executive use needs to be involved. I'd much rather have an executive sign-off on something and spend two more months getting the deal done because you know that they are bought in, you can now ensure what kind of value do they want to unlock and maybe you have an opportunity to turn them into a user, which to me, in today's day and age, with our generation being the ones that are now the executives at these corporations, this is native to them.

**中文翻译:**
没错。而且 1 万美元的单子不会让你受到重视。10 万美元的单子会让你受重视得多，虽然达成 10 万美元的交易要难得多，且需要高管参与。我宁愿让高管签字，多花两个月时间达成交易，因为你知道他们已经认可了。现在你可以确保他们想要释放什么样的价值，甚至有机会让他们成为用户。在当今时代，我们这一代人已经成为了这些公司的高管，这对他们来说是与生俱来的。

---

### [00:19:15] Lenny Rachitsky

**English:**
Who is this true for? Is the advice here basically, if you're trying to build a successful B2B company, everybody should be aiming towards these a 100K sort of deals? Is there a world where you can be successful with 10Ks for a long time?

**中文翻译:**
这适用于谁？这里的建议基本上是说，如果你想建立一家成功的 B2B 公司，每个人都应该瞄准 10 万美元级别的交易吗？是否存在一种情况，你可以长期靠 1 万美元的单子取得成功？

---

### [00:19:30] Jen Abel

**English:**
If you have a super high win rate in a massive market, because all you have to do is reverse engineer the math. If you need to generate a hundred million dollars in revenue, how many 10K deals do you need? And the expansion on a 10K deal is in parallel to that. Where can you go? 10 to 15? That's a 50% growth, much easier to go to a 100K to 500K because they want more bodies or they want more value out of you.
(00:19:58):
For an enterprise, they'd love to get more out of an existing customer. You're already trusted. So it's also about the type of company you are. If you're venture-backed, you can't be selling $10,000 deals to the enterprise, you'll get killed, or you've already lost the game because you're playing a small business game in the wrong sector.

**中文翻译:**
除非你在一个巨大的市场中拥有极高的胜率，因为你只需要反推一下数学题。如果你需要产生 1 亿美元的收入，你需要多少个 1 万美元的单子？而且 1 万美元单子的扩张空间也是有限的。你能涨到多少？1.5 万？那是 50% 的增长。但从 10 万涨到 50 万要容易得多，因为他们需要更多的人员使用，或者想从你这里获得更多价值。
(00:19:58):
对于大企业来说，他们更愿意从现有客户那里获得更多价值，因为你已经获得了信任。所以这也取决于你的公司类型。如果你是风险投资支持的，你不能向大企业卖 1 万美元的单子，你会累死的，或者说你已经输了，因为你在错误的领域玩着小企业的游戏。

---

### [00:20:17] Lenny Rachitsky

**English:**
Have you seen startups you've worked with succeed in that 10K, 20K bucket or is it really, really rare?

**中文翻译:**
你合作过的初创公司里，有没有在 1 万到 2 万美元这个区间取得成功的，还是说这真的非常罕见？

---

### [00:20:23] Jen Abel

**English:**
If they're going after the enterprise?

**中文翻译:**
如果是针对大企业的话？

---

### [00:20:25] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:20:25] Jen Abel

**English:**
Yes, if it's the first three months and then after three months, it turns into a 50K and then a 100K and it ramps up quickly. Sure, that makes sense. You got your foot in the door and you can expand it exponentially in a healthy manner. I think that that's fine. $10,000 a year, then going to 12, then going to 15, the math will break.

**中文翻译:**
有，如果那是前三个月的情况，然后三个月后变成 5 万，再变成 10 万，并且迅速增长。当然，这说得通。你已经切入了市场，并且能以健康的方式指数级扩张。我认为那没问题。但如果是一年 1 万，然后变 1.2 万，再变 1.5 万，这账根本算不过来。

---

### [00:20:45] Lenny Rachitsky

**English:**
This is great. I feel like most founders to this are like, "No, no, we're kind of in that exception we'll be all right. 10K, we'll do 20K. That's crazy to consider 100K."

**中文翻译:**
太棒了。我觉得大多数创始人听到这儿会想：“不不不，我们属于例外，我们会没事的。1 万，我们会做到 2 万。考虑 10 万太疯狂了。”

---

### [00:20:52] Jen Abel

**English:**
Yeah, the math will break. And also, a really good salesperson, you're commissioned on a 10K deal, they're not going to get a great salesperson. They're going to want to be anchored to how can I sell a $250,000 deal? How can I sell a half a million dollar deal? That's the type of person you want.

**中文翻译:**
是的，账算不过来。而且，一个优秀的销售人员，如果你只给 1 万美元的单子提成，你招不到顶尖人才。他们想的是：“我怎么卖出一个 25 万美元的单子？我怎么卖出一个 50 万美元的单子？”这才是你想要的人才。

---

### [00:21:11] Lenny Rachitsky

**English:**
And a big part of this is this is a good lens to force you to build the product that you can sell for 100K, 500K.

**中文翻译:**
很大程度上，这是一个很好的视角，迫使你去构建那种能卖到 10 万、50 万美元的产品。

---

### [00:21:19] Jen Abel

**English:**
Yeah, absolutely. And again, this is about playing that enterprise game. If you're trying to sell, if you're a small business, if you're in the small business place and an enterprise company comes to you and is like, "I like this." Ensure that you structure it for an enterprise. Don't play the small business team with an enterprise company.

**中文翻译:**
是的，绝对如此。再说一次，这是关于玩大企业游戏。如果你在做小企业市场，而一家大企业找上门说“我喜欢这个”，一定要确保你按大企业的模式来构建交易。不要用小企业的玩法去应对大企业。

---

### [00:21:38] Lenny Rachitsky

**English:**
Talk more about that. What does that mean?

**中文翻译:**
再多谈谈。那是什么意思？

---

### [00:21:40] Jen Abel

**English:**
Let's say you're PLG, and a big company like Walmart comes to and is like, "Hey, can we get access for three of our users?" And they're like, "This is so exciting." And then they sell them the small business pricing for three users to Walmart. Very, very hard now to go from those three users that you just priced them at in a small business way, turn that into 100K because now it's documented what they're actually paying for this.
(00:22:08):
So you're stuck. You've kind of anchored yourself to this price. Not to mention how are you going to unlock the executive high level value so that you can get that senior executive to buy in and stamp this as well. Otherwise, it's just going to be throwing it on the credit card. But again, you've just ruined your enterprise game because you're anchoring to a small business price.
(00:22:34):
So this is why when you bleed these two games, it's very, very, very dangerous because these are really smart companies. They're going to say, "Well, wait a second, I just paid $9,000 last year and now you want to charge me $90,000. Well, what's the step change in value? What's the 10X value I'm now getting?" That's super hard to prove.

**中文翻译:**
假设你是 PLG（产品驱动增长）模式，像沃尔玛这样的大公司找上门说：“嘿，我们能给三个用户开通权限吗？”初创公司会觉得“太兴奋了”，然后按小企业的价格卖给沃尔玛三个用户的权限。现在，你想从这三个用户的小企业定价跳到 10 万美元的大单就非常难了，因为他们实际支付的价格已经有记录了。
(00:22:08):
所以你被困住了。你把自己锚定在了这个价格上。更不用说你该如何释放高管层面的价值，从而让高级主管也认可并签字。否则，这只是刷信用卡的小额支出。但再次强调，你已经毁掉了你的大企业游戏，因为你锚定了一个小企业的价格。
(00:22:34):
这就是为什么混淆这两种游戏非常危险，因为这些大公司非常聪明。他们会说：“等等，我去年才付了 9000 美元，现在你要收我 9 万美元？价值发生了什么阶梯式的变化？我现在得到的 10 倍价值体现在哪？”这超级难证明。

---

### [00:22:54] Lenny Rachitsky

**English:**
So the tip here is your initial price will really screw you if you get it wrong. And so obviously we're not going to give people the answer on their pricing strategy fully, but just is the advice just charged more or what would you recommend?

**中文翻译:**
所以这里的诀窍是：如果初始定价错了，真的会害死你。显然我们不会给出完整的定价策略答案，但你的建议是直接多收钱吗？还是你有什么推荐？

---

### [00:23:08] Jen Abel

**English:**
It is enterprise companies are very used to a land, when I say the first initial contract, somewhat between 75K and 150K, very used to that. In fact, that's probably where you want to start because you also want to understand where can you grow from this. Start contained, don't say 150K and sell the farm. Say, "It's 150K, here's who gets access, here's the value we're going to deliver and here's where we're going over time." You also want them to know, "Here's what we plan to do roughly in year two, year three."
(00:23:42):
I know it's hard to look that far out, but plant the seed with them in terms of where this is going. If you come in at $10,000, even if they want to bring you in and want to spend 100K with you, they have to be able to defend that and now they see a $10,000, it can get really messy, especially because a lot of them are using AI now to understand contracts. So they're going to quickly say, "Oh wait, you spent a thousand dollars with Lenny and now Lenny is asking you for a 100K. Great. Just help me understand why or defend it."

**中文翻译:**
大企业非常习惯于“切入”（land）合同，我是指首笔合同在 7.5 万到 15 万美元之间，他们很习惯这个价位。事实上，这可能是你应该开始的地方，因为你也想了解后续的增长空间。开始时要有所保留，不要收了 15 万就把所有东西都卖了。要说：“这是 15 万，这是谁能获得权限，这是我们将交付的价值，这是我们未来的发展方向。”你还要让他们知道：“这是我们计划在第二年、第三年大致要做的事情。”
(00:23:42):
我知道看那么远很难，但要给他们种下“未来走向”的种子。如果你以 1 万美元切入，即使他们想把你引进来并花 10 万美元，他们也必须能为此辩护。如果他们看到之前是 1 万美元，事情就会变得很麻烦，尤其是现在很多公司都在用 AI 来分析合同。AI 会迅速指出：“等等，你之前在 Lenny 那儿只花了 1000 美元，现在 Lenny 要收你 10 万？请解释原因或为此辩护。”

---

### [00:24:15] Lenny Rachitsky

**English:**
I could totally see ChatGPT being like, "This is interesting."

**中文翻译:**
我完全能想象 ChatGPT 说：“这很有趣。”

---

### [00:24:19] Jen Abel

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:24:19] Lenny Rachitsky

**English:**
It used to be 1K, now it's a 100K. What might be going on here?

**中文翻译:**
“以前是 1000，现在是 10 万。这中间发生了什么？”

---

### [00:24:22] Jen Abel

**English:**
Totally. The people don't realize how, again, know the game you're playing and don't be sloppy about it.

**中文翻译:**
完全正确。人们没有意识到，再次强调，要清楚你正在玩的游戏，不要马虎。

---

### [00:24:34] Lenny Rachitsky

**English:**
So your advice here is really interesting. There's the land to expand. Expand is very important, but the landing may screw your expanding because it sets the wrong reference point.

**中文翻译:**
所以你的建议非常有趣。大家都说“切入并扩张”（land to expand），扩张固然重要，但切入的方式可能会毁掉你的扩张，因为它设定了错误的参考点。

---

### [00:24:45] Jen Abel

**English:**
1,000%. That's exactly right. You said it better than I did.

**中文翻译:**
一千个百分点赞同。完全正确。你比我说得还好。

---

### [00:24:48] Lenny Rachitsky

**English:**
And so you may see in theory if you land a 10K go to 100K, that's an amazing NRR, everyone's going to be really impressed. But you're saying people won't buy into that. It's going to feel absurd and wrong.

**中文翻译:**
所以理论上，如果你以 1 万切入然后涨到 10 万，那是惊人的 NRR（净收入留存率），大家都会印象深刻。但你是说客户不会买账，这会让他们觉得荒谬且错误。

---

### [00:25:00] Jen Abel

**English:**
Unless it's defendable. All it needs to be is defendable. But who can really defend? That's very hard to defend a 10X. 10X jump, they're going to want to see 15X value.

**中文翻译:**
除非它是可辩护的。关键在于理由要站得住脚。但谁能真正辩护呢？10 倍的跳跃很难辩护。如果是 10 倍的价格跳跃，他们会希望看到 15 倍的价值。

---

### [00:25:11] Lenny Rachitsky

**English:**
Let's talk about design partners.

**中文翻译:**
我们来谈谈设计合作伙伴（design partners）。

---

### [00:25:12] Jen Abel

**English:**
Oh yeah.

**中文翻译:**
噢，好的。

---

### [00:25:13] Lenny Rachitsky

**English:**
This is something most founders try to do. They find a few folks to work with, to help them build the thing. What's your advice on when to start finding design partners? How to find design partners, what a good relationship looks like?

**中文翻译:**
这是大多数创始人都尝试去做的事。他们找几个人合作，帮他们构建产品。关于什么时候开始寻找设计合作伙伴，你有什么建议？如何找到他们？一段良好的关系应该是怎样的？

---

### [00:25:24] Jen Abel

**English:**
Design partners are incredible. They're the hardest logos to upsell, meaning go from design partner to full rollout customer. So don't expect these people to be your million dollar pipeline. Expect these people to be the guide, to help you understand, maybe design partners could be a technology company in the Fortune 1,000.
(00:25:50):
So they're used to experimenting. They're used to technology, they're used to, they were once a startup, so they get it. Those make really good design partners. Most of the design partners that I've closed are usually technology based. They get it and they also are excited about advancing the org and also giving the team an ability to have that startup feel.
(00:26:12):
So if you're a large massive corporation like Stripe. Stripe doesn't get that startup vibe as much like that 50 person startup vibe, but this can be a gift to give them that lens and give them that voice and give them that excitement that they don't get as a larger company. But those are great types of logos to be early design partners because one, they want to make sure they continue to stay on the cutting edge, but two is they are, to try and build something without that guidance is really, really, really hard because they're not using it.
(00:26:54):
So you need that user feedback and you also need to tie that to the executive value. It's actually a lot, it's very hard to do, but if you can come out of it and upsell a design partner to a full rollout customer, such a huge win for the market for you, for your team, and also for your investors because it's the hardest customer to actually truly convert.
(00:27:23):
They've been it when it was messy, they usually got a low price point. But if you again frame it, say, "Listen, I would love for you to be a design partner. I want a little skin in the game to get you to point it. Here's where we want to go and you'll get a discount because you were in the beginning, but I'm setting the framing. Here's where we want to go with pricing. Here's where we are today. You'll always have 30% concession in perpetuity because you are there with us on day one."
(00:27:49):
So again, it's not about asking for $10,000 and then not expecting that design partner to upsell and keep it flat because there's no growth there. It's a flat. It's about getting that early design partner, set the framing, own the framing and let them know where you're going. Again, a $100,000 to these large logos if they want it, it's very easy for them to get it in.

**中文翻译:**
设计合作伙伴非常棒。但他们也是最难追加销售（upsell）的品牌，即从设计合作伙伴转变为全面推广的客户。所以不要指望这些人能成为你百万美元的销售漏斗。要把他们看作向导，帮助你理解市场。设计合作伙伴可能是财富 1000 强中的科技公司。
(00:25:50):
他们习惯于实验，习惯于技术，他们曾经也是初创公司，所以他们懂。这些公司是很好的设计合作伙伴。我谈成的大多数设计合作伙伴通常都是以技术为基础的。他们理解，并且也乐于推动组织进步，给团队一种“初创公司”的感觉。
(00:26:12):
比如像 Stripe 这样的大型公司。Stripe 已经不太有那种 50 人初创公司的氛围了，但你可以把这种视角、这种声音和这种兴奋感作为礼物送给他们，这是他们在大型公司里得不到的。这些品牌是早期设计合作伙伴的绝佳选择，因为：第一，他们想保持领先地位；第二，如果没有这种指导，闭门造车是非常难的，因为你不知道他们是怎么用的。
(00:26:54):
所以你需要用户反馈，并且需要将其与高管价值挂钩。这其实很难做到，但如果你能成功将一个设计合作伙伴转化为全面推广的客户，那对市场、对你的团队以及对你的投资者来说都是巨大的胜利，因为这是最难转化的客户。
(00:27:23):
他们在产品还很简陋的时候就在用了，通常拿到的价格也很低。但如果你重新设定框架，说：“听着，我很希望你成为设计合作伙伴。我希望你投入一点资源（skin in the game）来引导它。这是我们的目标，因为你是早期参与者，你会得到折扣，但我现在要设定框架：这是我们未来的定价方向，这是我们现状。因为你从第一天起就和我们在一起，你将永远享有 30% 的永久优惠。”
(00:27:49):
所以，再次强调，不要只收 1 万美元，然后指望设计合作伙伴会自动升级，否则价格就定死了，没有增长空间。关键在于找早期合作伙伴，设定并掌控框架，让他们知道你的目标。再说一次，对于这些大品牌，如果他们想要，10 万美元对他们来说非常容易。

---

### [00:28:11] Lenny Rachitsky

**English:**
There's this really interesting underlying piece of advice of finding a company that pulls you in the direction that leads to success. A company that's kind of a visionary. There's the obvious companies that everyone is always trying to get these days, OpenAI and Anthropic and Stripe I think is one. And any advice for just picking the right early? What are signs that this is a company that will point you in the right direction?

**中文翻译:**
这里有一个非常有趣的潜在建议：找一家能把你引向成功方向的公司。一家具有远见的公司。现在大家都在追逐那些显而易见的公司，比如 OpenAI、Anthropic，我觉得 Stripe 也是其中之一。关于如何挑选正确的早期合作伙伴，你有什么建议？有哪些迹象表明这家公司会指引你走向正确的方向？

---

### [00:28:34] Jen Abel

**English:**
I think they have to be part of a logo that is deemed startup-friendly or in that world, and then I think it's the person, is this person excited to give feedback? Does this person buy in to where we're going? Do they see this world differently like us? Are they in lockstep with the founder vision?
(00:28:58):
Are they excited to use a tool that's janky? Because it is janky in the beginning, but they know that where this can go can be incredible. So I think it's really about the person and making sure that they're aligned for what they're getting into, and I think a lot of salespeople oversell it. I think that's a common thing that happens and that leads to churn, that leads to frustration, that leads to sometimes just canceling the contract.

**中文翻译:**
我认为他们必须属于那种被认为对初创公司友好或处于那个圈子的品牌。然后关键在于人：这个人是否乐于提供反馈？这个人是否认同我们的发展方向？他们是否像我们一样以不同的方式看待世界？他们是否与创始人的愿景步调一致？
(00:28:58):
他们是否愿意使用一个还不成熟（janky）的工具？因为初期产品确实不成熟，但他们知道它的潜力是惊人的。所以我觉得核心在于人，确保他们清楚自己参与的是什么。我认为很多销售人员会过度承诺（oversell），这是常有的事，这会导致客户流失、挫败感，有时甚至会导致合同取消。

---

### [00:29:31] Lenny Rachitsky

**English:**
They oversell the initial kind of design partners phase over the product.

**中文翻译:**
他们在产品还不成熟时，过度推销了初始的设计合作伙伴阶段。

---

### [00:29:33] Jen Abel

**English:**
They sell everything. Yeah, design partner, even full rollout, and it's so, so important to tell them, "Here's where we are today. Here's what we cannot do." Which is just as important. It builds trust. "Here's what we will allow you to do in the next six months. Do you want to be on this journey with us? And it's really ugly right now." Right? "Barely anything exists, but we would love your voice to be a part of it."

**中文翻译:**
他们什么都卖。是的，设计合作伙伴，甚至是全面推广。其实非常重要的一点是告诉他们：“这是我们今天的现状。这是我们目前做不到的。”这同样重要，因为它能建立信任。“这是我们在未来六个月能让你做到的。你愿意和我们一起开启这段旅程吗？虽然现在产品还很简陋。”对吧？“几乎什么都没有，但我们希望你的声音能参与其中。”

---

### [00:29:55] Lenny Rachitsky

**English:**
One of the biggest fears I think founders have is having a company pull, basically build just for their use case and then it ends up not being used by a lot of people. And so how far do you go fixing their specific problems? Any advice on just how far to go with one company?

**中文翻译:**
我认为创始人最大的恐惧之一就是被一家公司牵着鼻子走，基本上只为他们的特定用例构建产品，结果最后发现没多少人用。那么，你在解决他们的特定问题上应该走多远？关于对一家公司投入多少，你有什么建议？

---

### [00:30:10] Jen Abel

**English:**
That is the founder's job. The founder's job is to have a clear vision and do not let anything delineate from that. It's important to take feedback in terms of what is the market's reality, but it is the founder, and this is why being a founder is so hard. It is the founder's job to interpret that because a lot of feedback you get is this is the old way, they're responding this way because it's the old way of working.
(00:30:37):
They want you to build this because that's how they're traditionally expecting to do that. It is not, "Here's where we're going, this is why we're not doing that. I hear you, but here's why we're not going to do that because we're going to completely change the way you do this." That is the founder's job.
(00:30:53):
And I think we did a bunch of design partnerships late last year and there was a lot of feedback given, a lot of feedback given, but the founder had such clarity with where he wanted to go that he was like 80% noise, 20% had I not asked this question, I wouldn't have gotten that gold in terms of where they are today. And it's that 80/20 rule where 80% of what they're going to tell you is probably going to be not related to where you want to go or based off of the old way, but that 20% of, "Oh, I did not think about it that way." That drives everything.

**中文翻译:**
那是创始人的工作。创始人的职责是拥有清晰的愿景，不让任何事情偏离它。听取关于市场现实的反馈很重要，但创始人必须去解读它——这就是为什么当创始人这么难。你收到的很多反馈其实是“老一套”，他们之所以这样反应是因为那是旧的工作方式。
(00:30:37):
他们想让你构建某个功能，是因为他们传统上就是这么预期的。创始人应该说：“这不是我们的方向，这就是为什么我们不那样做。我听到了你的需求，但这就是为什么我们不打算那样做的原因，因为我们要彻底改变你做这件事的方式。”这就是创始人的职责。
(00:30:53):
去年年底我们做了很多设计合作伙伴项目，收到了大量的反馈。但那位创始人对自己的目标非常清晰，他觉得 80% 都是噪音，而剩下的 20% 则是：“如果我不问这个问题，我就不会发现关于他们现状的这些金子般的洞察。”这就是 80/20 法则：他们告诉你的 80% 可能与你的目标无关，或者是基于旧方式；但那 20% 的“哦，我以前没这么想过”才是驱动一切的关键。

---

### [00:31:35] Lenny Rachitsky

**English:**
Have you seen a design partner pull a company in the wrong direction? Just screw their path? Have you seen that or is that pretty rare?

**中文翻译:**
你见过设计合作伙伴把公司引向错误方向的情况吗？就是彻底搞砸了他们的路径？你见过这种情况吗，还是说这很罕见？

---

### [00:31:42] Jen Abel

**English:**
No, I don't think it's that rare. We hear people complain about it all the time, but I think it's more of an excuse.

**中文翻译:**
不，我不觉得罕见。我们总听到人们抱怨这件事，但我认为这更多是一个借口。

---

### [00:31:49] Lenny Rachitsky

**English:**
Coming back to this question of going after the enterprise versus SMBs. And again, early advice you gave is there's no, don't go in between. Either pick SMB small company, which I know you said there's a million ways to differentiate what this means, but I guess I think of employee numbers under some number over a thousand is maybe enterprise. Is that a good way to think about it just like-

**中文翻译:**
回到攻克大企业还是中小企业（SMB）的问题。再次强调，你之前的建议是不要走中间路线。要么选 SMB 小公司（我知道你说过有很多种定义方式，但我通常认为员工人数在某个数字以下是 SMB，1000 人以上可能是大企业）。这样想对吗？

---

### [00:32:13] Jen Abel

**English:**
Yeah, it depends. Are you selling per seats or are you selling based off of usage or are you selling off of, I think it also depends on the pricing model a little bit. I look at headcount too because it's just such an easy way to think about it because you can also gauge usage off that and a bunch of other things, but sometimes the small companies, I think we're going to see a lot more larger companies become smaller because of AI, not significantly smaller, but also high margins allow them to experiment more too.

**中文翻译:**
是的，这取决于情况。你是按席位销售，还是按用量销售？我认为这也取决于定价模式。我也看员工人数，因为这是一种很简单的思考方式，你可以据此衡量用量等指标。但有时小公司……我认为我们会看到很多大公司因为 AI 而变得规模更小，虽然不会小得离谱，但高利润也让他们能进行更多实验。

---

### [00:32:50] Lenny Rachitsky

**English:**
That's such an interesting point you're making there that the way we designate enterprise versus SMB like may shift because number of employees may go down with AI.

**中文翻译:**
你提到的这一点非常有趣：我们定义大企业和 SMB 的方式可能会发生变化，因为在 AI 的影响下，员工人数可能会下降。

---

### [00:32:57] Jen Abel

**English:**
Yeah. Oh yeah.

**中文翻译:**
是的，没错。

---

### [00:32:59] Lenny Rachitsky

**English:**
So interesting. So where I was going to go with this question is when people are deciding, I'm going to go enterprise versus I'm going to sell to startups, like YC companies are the typical example they sell to their own YC batches and you just broad advice of picking, "Okay, we go enterprise versus no, let's actually go startup."

**中文翻译:**
太有意思了。我刚才想问的是，当人们在决定“我要攻克大企业”还是“我要卖给初创公司”时（比如 YC 公司典型的例子就是卖给同期的 YC 创业者），你对于选择“大企业”还是“初创公司”有什么宽泛的建议？

---

### [00:33:18] Jen Abel

**English:**
I think it's about, and I read this somewhere and I wholeheartedly agree with it because I've seen it live. I think it's about what game does the founder best understand? Are they an incredible marketer and have some competitive edge for how they can win a massive audience?
(00:33:34):
I would say go SMB and marketing led or are they a bit more really understand how large corporations work and really excited to deliver on $100,000 plus type of opportunities or the value that they are building for is way more relatable to an enterprise versus a small business.

**中文翻译:**
我认为这取决于……我在某处读到过这个观点，并且我完全赞同，因为我亲眼见过。我认为这取决于创始人最擅长玩哪种游戏。他们是天才营销人员，在赢得大规模受众方面有竞争优势吗？
(00:33:34):
如果是，我会建议走 SMB 和营销驱动路线。或者，他们是否更了解大型企业的运作方式，并且对交付 10 万美元以上的机会感到兴奋？或者他们构建的价值对大企业来说比对小企业更有共鸣？

---

### [00:33:57] Lenny Rachitsky

**English:**
That is really interesting. I've never heard of it described that way. I think about linear, which started very startup-ey and my take is they did that because changing the way you work is really hard and their bet was like, "Let's start with companies and grow with them and over time that becomes the default." Any reaction to that?

**中文翻译:**
这真的很有趣。我从未听过有人这样描述。我想到了 Linear，它刚开始非常像初创公司的风格。我的看法是，他们之所以这样做是因为改变工作方式非常难，他们的赌注是：“让我们从初创公司开始，伴随他们成长，久而久之这就会成为默认选择。”你对此有什么看法？

---

### [00:34:16] Jen Abel

**English:**
I think that it sounds like that that's a great way to work because that's a technical tool, so that you need the right, also need to have the right infrastructure to sell. I think Slack, look, Slack and Microsoft Teams are still battling it out at the enterprise. I think it's also how you plug in and how you integrate and do they even have the right systems to support you? The thing with open AI is they didn't have to connect to anything.

**中文翻译:**
我觉得这听起来是一种很好的方式，因为那是一个技术工具，所以你需要正确的……也需要正确的销售基础设施。看看 Slack，Slack 和 Microsoft Teams 仍在企业级市场激战。我认为这也取决于你如何接入、如何集成，以及他们是否有合适的系统来支持你。OpenAI 的情况是，他们不需要连接任何东西。

---

### [00:34:45] Lenny Rachitsky

**English:**
Say more about that.

**中文翻译:**
再多说一点。

---

### [00:34:46] Jen Abel

**English:**
So the value, people were bringing their own use cases to it and it's not like they, well they can ingest and they built that, it's a brand new thing and they started I think, this is someone told me this, so this could be hearsay, but I believe that they were already speaking to CTOs even well before they released to help them explain where this is all going and get their buy-in.
(00:35:17):
And it's much easier to get into the enterprise when you're like, "We won't even touch your data, won't even touch your data. Just use it to solve problems and then we can build trust and then start to integrate and connect the pipes." But part of the challenges with selling in the enterprise, they're like, "All right, well let's connect all your data in the ..." "Whoa, that's extremely risky."
(00:35:41):
So you have to start small and low risk, which is like, "Hey, what is the subset of consumers that churned? Let's figure out how we could have made them happier, whatever it be." So that data is lower risk. So again, it's also understanding your market and understanding what their ability to experiment is.

**中文翻译:**
关于价值，人们是带着自己的用例去找它的。这不像……虽然它可以摄取数据，他们也构建了那个功能，但这是一个全新的事物。我听人说（这可能是传闻），我相信他们在发布之前就已经在和 CTO 们交流了，帮助他们解释未来的走向并获得他们的认可。
(00:35:17):
当你承诺“我们甚至不会碰你的数据，绝对不碰。只需用它来解决问题，然后我们建立信任，再开始集成和打通管道”时，进入大企业会容易得多。在大企业销售中，部分挑战在于他们会说：“好吧，让我们把你所有的数据都连上……”“哇，那风险太大了。”
(00:35:41):
所以你必须从小处着手，从低风险开始。比如：“嘿，流失的消费者子集是什么？让我们看看如何能让他们更开心，不管是什么。”这类数据的风险较低。所以，再次强调，关键在于了解你的市场，了解他们的实验能力。

---

### [00:36:03] Lenny Rachitsky

**English:**
It's interesting this distinction between OpenAI right now, and Anthropic, I don't know if you've been seeing their growth, it feels like OpenAI is very consumer first and Anthropic is more and more winning on B2B. I saw this chart recently where they're overtaking OpenAI now on B2B. I don't know, any reaction there of just these two different approaches?

**中文翻译:**
现在 OpenAI 和 Anthropic 之间的区别很有趣。我不知道你有没有关注他们的增长，感觉 OpenAI 非常注重消费者优先，而 Anthropic 在 B2B 领域赢得了越来越多的市场。我最近看到一张图表，显示他们在 B2B 领域正在超越 OpenAI。你对这两种不同的策略有什么看法？

---

### [00:36:23] Jen Abel

**English:**
I don't because most enterprises I'm talking to mentioned Gemini.

**中文翻译:**
我没什么看法，因为我接触的大多数企业提到的都是 Gemini。

---

### [00:36:27] Lenny Rachitsky

**English:**
Oh, interesting.

**中文翻译:**
噢，有趣。

---

### [00:36:30] Jen Abel

**English:**
Or Microsoft Copilot. So I don't hear much about Anthropic to be honest. So that might be more of a small business startup-ey, I don't know or it's a different part of the organization that's using it.

**中文翻译:**
或者是 Microsoft Copilot。说实话，我没怎么听说过 Anthropic。所以那可能更多是小企业或初创公司的选择，我也不确定，或者可能是组织中不同的部门在用。

---

### [00:36:45] Lenny Rachitsky

**English:**
Yeah, that's a whole discussion or bundling right there of Slack and teams and then just Gemini just kind of coming in automatically. People don't have to adopt anything new.

**中文翻译:**
是的，这涉及到了捆绑销售（bundling）的话题，比如 Slack 和 Teams，然后 Gemini 就这样自动进场了。人们不需要采用任何新东西。

---

### [00:36:54] Jen Abel

**English:**
Yeah, totally.

**中文翻译:**
是的，完全正确。

---

### [00:36:55] Lenny Rachitsky

**English:**
There's something else that you talk about that I love that I don't think people talk much about, which is that enterprise sales is very creative.

**中文翻译:**
你谈到的另一件事我很喜欢，我觉得大家谈得不多，那就是大客户销售是非常具有创造性的。

---

### [00:37:03] Jen Abel

**English:**
Oh yes.

**中文翻译:**
噢，是的。

---

### [00:37:04] Lenny Rachitsky

**English:**
Talk about that.

**中文翻译:**
谈谈这个。

---

### [00:37:06] Jen Abel

**English:**
So I personally believe that small business sales is really a, I used to think it was more science than art. It was more figuring out what didn't work, running experiments, testing and validating, which I do believe, that's to get to foundations, where do we play? What do we want to do? Like that early, early, early zero to one.
(00:37:33):
From one to 10, I think it's more of an art, which is how do I take my learning and how do I package it up where I own the framing, I can speak to very specific alpha, I can vision cast and where I better understand the problem over time better than the market does. And it's all about deal crafting.
(00:38:00):
They just need to feel like the value they're getting out of it is way more than the cost. And it's sometimes about giving away things that don't really cost much to you, but are super expensive for them. For example, "Hey, we're selling X tool. We can build out Y specifically for you over the next year and integrate it because I know that you would've spent X number of dollars on engineering resources or you wouldn't have gotten in engineering head internally to do this, but we're just leave it to you. You got to give us a year to build it out."
(00:38:37):
Again, you're not letting them sidetrack you too much, you're kind of containing it. "We'll do that for you at no additional cost." That's huge value. Right? Or, "Hey, we're going to run an event and we want you at the forefront of it. We want you to be a speaker." Huge value. So it's like all of these additional things that add value beyond just the product but are all part of the product and the vision. Everyone keeps thinking the product is just what goes into their hand.
(00:39:07):
The product is pricing. The product is the opportunity, the framing and not letting them compare you to something else. And I know we talked that on our first call, which is as soon as you become a comparison, as soon as you become one of three that they're testing out, you've already sort of lost. It's all about differentiation and it's all about here's what you will be able to do tomorrow because of how we're going to serve you today.

**中文翻译:**
我个人认为，小企业销售……我以前觉得它更多是科学而非艺术。它更多是找出行不通的地方、运行实验、测试和验证。我确实相信这一点，那是为了打基础：我们在哪里竞争？我们想做什么？就像早期的 0 到 1 阶段。
(00:37:33):
从 1 到 10，我认为它更多是一门艺术，即：我如何将我的所学进行包装，从而掌控话语权（own the framing），谈论非常具体的 alpha，描绘愿景，并且随着时间的推移，我比市场更了解这个问题。这一切都关乎交易的设计（deal crafting）。
(00:38:00):
他们只需要感觉到他们从中获得的价值远超成本。有时这关乎赠送一些对你来说成本不高、但对他们来说非常昂贵的东西。例如：“嘿，我们卖的是 X 工具。我们可以在明年专门为你开发 Y 功能并进行集成，因为我知道如果你自己做，会花费 X 美元的工程资源，或者你内部根本招不到工程主管来做这件事，但我们可以交给你。你得给我们一年时间来开发。”
(00:38:37):
再次强调，你不能让他们把你带偏太多，要有所控制。“我们会免费为你做这件事。”这就是巨大的价值，对吧？或者，“嘿，我们要举办一个活动，我们希望你站在最前沿，邀请你担任演讲嘉宾。”这也是巨大的价值。所以，这些都是在产品之外增加价值的额外事物，但它们都是产品和愿景的一部分。大家总觉得产品只是交到他们手里的那个东西。
(00:39:07):
产品还包括定价、机会、框架，以及不让他们把你与别的东西进行比较。我知道我们在第一次通话中谈过这一点：一旦你沦为被比较的对象，一旦你成为他们测试的三个备选方案之一，你就已经输了。核心在于差异化，在于告诉他们：因为我们今天的服务，你明天将能实现什么样的飞跃。

---

### [00:39:39] Lenny Rachitsky

**English:**
So along those lines, it reminds me in our first chat you actually made this point that I've never heard anyone else make, which is that services are a really good way to start getting into the companies that were most founders here. Like, "No, don't do manual stuff for the company. Build a product that you can scale." Your advice is the opposite. Actually start with self-services. Talk about that.

**中文翻译:**
说到这里，我想起我们在第一次聊天时，你提出了一个我从未听别人提过的观点：服务是进入大公司的一个非常好切入点。而大多数创始人听到的是：“不，不要为公司做手动的工作。要构建一个可以规模化的产品。”你的建议恰恰相反：实际上要从服务开始。谈谈这个。

---

### [00:39:59] Jen Abel

**English:**
Enterprise is the number one thing they buy services, they know how to do it's super easy, they do it all of the time. It's like the most consistent thing they do. It's their largest budget item, external resources, consultants, whatever.
(00:40:13):
If they have a very immature way of understanding the problem or they've never purchased technology to solve it to some extent, either one, you are doing something that's never been done before, which is rare in today's day and age, or they might just be laggards on the journey. So you have to decide is this someone you really want to be working with? And if so, selling them as service, even though the technology is powering it on the backend is the fastest way to get your foot in the door.
(00:40:50):
It's what they know how to buy. Now, the idea is to once you sell that surface, once you get that foot in the door, then it's to guide them towards the product. "Hey, you're spending so much here, why don't we get you to come in and leverage the tool that's been powering this the whole time and move this more into technology serving you versus the human."

**中文翻译:**
大企业购买最多的就是服务，他们知道怎么买，这超级简单，他们一直在买。这是他们做得最一致的事情。这是他们最大的预算项目——外部资源、顾问等等。
(00:40:13):
如果他们对问题的理解非常不成熟，或者在某种程度上从未购买过技术来解决它，那么要么是你正在做一件前所未有的事情（这在当今时代很少见），要么是他们只是这段旅程中的落后者（laggards）。所以你必须决定：这是你真正想合作的人吗？如果是，卖给他们服务（即使后端是由技术驱动的）是切入市场的最快方式。
(00:40:50):
这是他们懂得如何购买的东西。现在的思路是：一旦你卖出了服务，一旦你切入了市场，接下来就是引导他们转向产品。“嘿，你在这里花了这么多钱，为什么不直接使用一直以来支持这项服务的工具呢？让技术来为你服务，而不是靠人力。”

---

### [00:41:12] Lenny Rachitsky

**English:**
Wow. I think this will blow a lot of people's minds.

**中文翻译:**
哇。我觉得这会让很多人大吃一惊。

---

### [00:41:15] Jen Abel

**English:**
Palantir, this Forward Deployed Engineer, that's exactly what they're doing. There's a lot of companies out, I'm sure OpenAI, and this is what someone told me they were in and talking to CTOs and helping them better understand how AI and their organization can better work together. And it was them coaching them, educating them, whether they did it for free or not, I don't know, but they got their foot in the door, they started to build trust and then it gets adopted.

**中文翻译:**
Palantir 的“前线部署工程师”（Forward Deployed Engineer）正是这么做的。有很多公司，我相信 OpenAI 也是，有人告诉我他们一直在和 CTO 们交流，帮助他们更好地理解 AI 如何与他们的组织协作。他们是在辅导他们、教育他们，不管是不是免费的，我不知道，但他们切入了市场，开始建立信任，然后产品就被采用了。

---

### [00:41:40] Lenny Rachitsky

**English:**
This is the epitome of doing things that don't scale that advice we always hear this is like, "Okay, this is what that looks like. We will solve this problem for you. We are using software to do it." And then over time, "Oh, you could just do this yourself. It'll cost you less. You can scale this."

**中文翻译:**
这就是“做那些无法规模化的事”这一建议的缩影。我们总听到这个建议，现在看来它长这样：“好的，我们会为你解决这个问题。我们正在使用软件来做这件事。”然后随着时间的推移，“噢，其实你可以自己做。成本更低，而且你可以规模化。”

---

### [00:41:54] Jen Abel

**English:**
Yep, that's right. And they don't even need to know at first that software's doing it. That could be the magic part, which is like, "Guys, we literally, we are literally doing this with our technology."

**中文翻译:**
没错。起初他们甚至不需要知道是软件在做。这可能是最神奇的部分，就像是：“伙计们，我们真的是在用我们的技术做这件事。”

---

### [00:42:05] Lenny Rachitsky (Sponsor: Coda)

**English:**
Today's episode is brought to you by Coda. I personally use Coda every single day to manage my podcast and also to manage my community. It's where I put the questions that I plan to ask every guest that's coming on the podcast. It's where I put my community resources, it's how I manage my workflows.
(00:42:20):
Here's how Coda can help you. Imagine starting a project at work and your vision is clear, you know exactly who's doing what and where to find the data that you need to do your part. In fact, you don't have to waste time searching for anything because everything your team needs from project trackers and OKRs, the documents and spreadsheets lives in one tab all in Coda. With Coda's collaborative all in one workspace, you get the flexibility of docs, the structure of spreadsheets, the power of applications, and the intelligence of AI, all in one easy to organize tab.
(00:42:52):
Like I mentioned earlier, I use Coda every single day. And more than 50,000 teams trust Coda to keep them more aligned and focused. If you're a startup team looking to increase alignment and agility, Coda can help you move from planning to execution in record time. To try it for yourself, go to coda.io/lenny today and get six months free of the team plan for startups, that's C-O-D-A.io/lenny to get started for free and get six months of the team plan. Coda.io/lenny.

**中文翻译:**
今天的节目由 Coda 赞助。我个人每天都使用 Coda 来管理我的播客和社区。我会把计划问每位嘉宾的问题放在那里，还有我的社区资源，以及我的工作流管理。
(00:42:20):
以下是 Coda 如何帮助你的。想象一下在工作中启动一个项目，你的愿景很清晰，你确切知道谁在做什么，以及在哪里可以找到完成任务所需的数据。事实上，你不需要浪费时间寻找任何东西，因为你的团队所需的一切——从项目追踪器和 OKR，到文档和电子表格——都存在于 Coda 的一个标签页中。通过 Coda 的协作式全能工作空间，你可以在一个易于组织的标签页中获得文档的灵活性、电子表格的结构、应用程序的强大功能以及 AI 的智能。
(00:42:52):
正如我之前提到的，我每天都使用 Coda。超过 50,000 个团队信任 Coda，让他们保持一致和专注。如果你是一个寻求提高一致性和敏捷性的初创团队，Coda 可以帮助你在创纪录的时间内从计划转向执行。亲自尝试一下，今天访问 coda.io/lenny，即可获得初创公司团队计划的六个月免费试用。即 C-O-D-A.io/lenny 免费开始。

---

### [00:43:22] Lenny Rachitsky

**English:**
There's a lot of talk these days about this idea forward deployed something volunteer was really famous for, just essentially an engineer sitting in your office solving problems with you basically as an employee. And then through that, they learn what software to build. Is that something you're seeing too?

**中文翻译:**
最近有很多关于“前线部署”这种想法的讨论，Palantir 在这方面非常出名。本质上就是一个工程师坐在你的办公室里，像员工一样和你一起解决问题。然后通过这个过程，他们了解到该构建什么样的软件。你也有看到这种趋势吗？

---

### [00:43:38] Jen Abel

**English:**
Oh yeah, I think that a lot of companies, sorry, a lot of folks that serve the enterprise, they have a butt in a seat in their office. You look at these large consultancies like McKinsey, they're not in their headquarters, they're in their client's office all the time. And the other interesting thing and proof of this is how many people go to a Deloitte or Accenture and expect them to be a channel partner?
(00:44:02):
This is exactly what this is all about, which is they sell this service, they come in and then they introduce, "Hey, look at what this startup is doing over here. You might want to give them a shot. The problem with channel partnerships and why I don't believe in them is there are a hundred of you on this list and you're expecting them to sell it on your behalf."
(00:44:21):
Biggest no-no, they're not vision casters, they're not visionaries, they're consultants, but it goes all towards go. I remember startups saying, "Oh, I'm going to go win over Accenture and then have them disseminate me into their clients." And I'm like, as if that's a workable strategy.

**中文翻译:**
噢是的，我认为很多服务大企业的公司，或者说很多人，在客户办公室里都有一个“工位”。看看像麦肯锡这样的大型咨询公司，他们不在自己的总部，他们一直待在客户的办公室里。另一个有趣的证明是：有多少人去找德勤或埃森哲，指望他们成为渠道合作伙伴？
(00:44:02):
这正是核心所在：他们销售这项服务，进入客户内部，然后介绍说：“嘿，看看这家初创公司在做什么，你可能想试试。”渠道合作伙伴的问题在于（这也是我不相信它们的原因），名单上有 100 个像你这样的公司，而你却指望他们代表你去销售。
(00:44:21):
这是大忌。他们不是愿景描绘者，他们不是远见家，他们是顾问。但我记得有初创公司说：“噢，我要去拿下埃森哲，然后让他们把我推广给他们的客户。”我觉得这根本不是一个可行的策略。

---

### [00:44:41] Lenny Rachitsky

**English:**
Okay. You know what might be helpful is, let me try to summarize some of the best pieces of advice you've shared so far. And this is specifically for folks trying to go from about a million ARR to about 10 million ARR. And then I want to ask you just what's most different about these two stages, but let me share this first. So advice one is go for tier one logos earlier than you think you should because they're early adopters, they can move fast, they can pull you in the right direction.

**中文翻译:**
好的。我觉得这可能会有帮助：让我试着总结一下你目前分享的一些最佳建议。这特别是针对那些试图从 100 万美元 ARR 增长到 1000 万美元 ARR 的人。然后我想问你这两个阶段最大的区别是什么，但先让我分享这些总结。建议一：比你想象的更早去接触一线大厂（tier one logos），因为他们是早期采用者，他们行动快，能把你引向正确的方向。

---

### [00:45:09] Jen Abel

**English:**
And they excite investors too.

**中文翻译:**
而且他们也能让投资者感到兴奋。

---

### [00:45:11] Lenny Rachitsky

**English:**
Yeah, for sure. And other leads are.

**中文翻译:**
是的，当然。还有其他的潜在客户。

---

### [00:45:14] Jen Abel

**English:**
Yeah, and other talent, future employees. Yeah, exactly.

**中文翻译:**
是的，还有其他人才、未来的员工。没错。

---

### [00:45:20] Lenny Rachitsky

**English:**
So the counterintuitive insight here is you think they will move slow and be too busy, but they are actually the early adopters.

**中文翻译:**
所以这里违背直觉的洞察是：你以为他们行动迟缓且太忙，但实际上他们才是早期采用者。

---

### [00:45:27] Jen Abel

**English:**
That's right. They have to maintain that number one spot. And also, all of the people that are in the number two, number three, number four spot, all want to do what number one is doing. So it's also pure referenceability too.

**中文翻译:**
没错。他们必须维持第一的位置。而且，所有排在第二、第三、第四位的公司都想效仿第一名的做法。所以这在参考价值（referenceability）上也是极佳的。

---

### [00:45:40] Lenny Rachitsky

**English:**
And the point about them being the early adopters, the people that join the Stripes in OpenAIs and Anthropics are like they individually love technology and love the latest stuff. So as a human they're like, "Oh, this is cool."

**中文翻译:**
关于他们是早期采用者的一点是：加入 Stripe、OpenAI 和 Anthropic 的那些人，他们个人就热爱技术，热爱最新的东西。所以作为个人，他们会觉得：“噢，这太酷了。”

---

### [00:45:52] Jen Abel

**English:**
That's exactly right. I'm just agreeing with myself, that's kind of funny. But yeah,

**中文翻译:**
完全正确。我只是在赞同我自己，这挺逗的。但确实如此。

---

### [00:45:56] Lenny Rachitsky

**English:**
That's a good sign. So two is ideally try to price closer to about a 100K, like 75 to 150-ishK is what you said. Most enterprises are used to buying. So instead of starting or even sticking with 10K, 20K for too long, you need to make yourself go towards 75 to 150K.

**中文翻译:**
这是个好兆头。建议二：理想情况下，定价应接近 10 万美元，就像你说的 7.5 万到 15 万美元左右。大多数大企业习惯于这个价位。所以，不要长期停留在 1 万、2 万美元的水平，你需要让自己向 7.5 万到 15 万美元靠拢。

---

### [00:46:18] Jen Abel

**English:**
That's right, yep. And if you were to sell a service, I know we're talking about selling services first, throw weight that over time, so maybe it's 10K a month. So they start to get used to what that pricing looks like.

**中文翻译:**
没错。如果你要先卖服务（我知道我们刚才在谈先卖服务），可以随着时间的推移增加权重，比如一个月 1 万美元。这样他们就开始习惯这种定价模式。

---

### [00:46:28] Lenny Rachitsky

**English:**
So this is a way to make it feel, this is like how you get to 75 to 150K is there's a service attached to it. It's not just, here's my SaaS product, we will solve this problem for you, or a person will be sitting there doing this for you.

**中文翻译:**
所以这是一种让它感觉合理的方式，这就是你如何达到 7.5 万到 15 万美元的方法——附加一项服务。不仅仅是“这是我的 SaaS 产品”，而是“我们会为你解决这个问题”，或者“会有一个人坐在那里为你处理这件事”。

---

### [00:46:41] Jen Abel

**English:**
Or no, it's the technology too. You can add the services. I always, well let me take that back. Whether the services is bundled into it or not, some people will unbundle it, other people will say the services is a part of it. But yeah, it nets out to 75 to 150K. That's right.

**中文翻译:**
或者不，技术也是核心。你可以添加服务。我总是……好吧，我收回刚才的话。无论服务是否捆绑在内（有些人会拆分，有些人会说服务是其中的一部分），总之最终总额在 7.5 万到 15 万美元之间。没错。

---

### [00:46:57] Lenny Rachitsky

**English:**
Okay. And you said that it's okay to start lower on ACVs and deals, but you need to push fast towards a 100K over a few months.

**中文翻译:**
好的。你说过开始时 ACV 和交易额低一点没关系，但你需要在几个月内迅速推向 10 万美元。

---

### [00:47:05] Jen Abel

**English:**
Yep, that's right. If you can get into an enterprise for 10K in a month, which is not doable, but if you could, and you could go from 10 K to 50 K in four months through an expansion strategy all game, that makes sense, but it's really rare and very hard to do.

**中文翻译:**
是的，没错。如果你能在一个月内以 1 万美元进入一家大企业（虽然这不太可能），然后通过扩张策略在四个月内从 1 万涨到 5 万，那也行得通，但这非常罕见且难以实现。

---

### [00:47:22] Lenny Rachitsky

**English:**
And so there's two different paths there. One is land cheap and grow quickly. The other is move your ACV average up quickly. Seems like both, the latter is probably the more common strategy is just keep increasing prices.

**中文翻译:**
所以这里有两条不同的路径。一是低价切入并快速增长。二是迅速提高你的平均 ACV。看起来后者可能是更常见的策略，即不断提高价格。

---

### [00:47:35] Jen Abel

**English:**
Yeah, because the former you can get tripped up because they could say, "Okay, now give me an economical price for doing this for a hundred people." And then it all kind of evens out because now you're at the 100K deal anyway, but it's much, there's more room for error, which is why I say go in and try to land 100K.

**中文翻译:**
是的，因为前者可能会让你栽跟头，因为他们可能会说：“好吧，现在给我一个为 100 人提供这项服务的经济价格。”然后价格就拉平了，因为你最终还是回到了 10 万美元的单子，但出错的空间更大了。这就是为什么我说直接进去尝试拿下 10 万美元。

---

### [00:47:53] Lenny Rachitsky

**English:**
By the way, in our first chat, we talked a lot about the procurement process, which is what trips a lot of people up and is really painful. And I vividly remember that conversation still. So if people are having issues getting through the sales process and procurement, a lot of good advice there.

**中文翻译:**
顺便提一下，在我们的第一次聊天中，我们谈了很多关于采购流程（procurement process）的内容，这是让很多人栽跟头且非常痛苦的地方。我至今记忆犹新。所以如果大家在销售流程和采购方面遇到问题，那里有很多好的建议。

---

### [00:48:09] Jen Abel

**English:**
And getting stuck in procurement is usually because you're not speaking to a senior enough person and they don't know how to navigate it, which is why I'm like that executive needs to be involved because as soon as the executive picks up a phone and tries to get a hold of their buying group, things move.
(00:48:27):
When people say, "Oh, I'm stuck in procurement." I'm like, "Oh, that could just be a qualification error and you never get out of it because you sold to someone too junior." So that's why the 100K is such a safe zone because even for 10K, you might have to go through procurement. So this is the surest way to make sure that you don't ... Listen, I've seen 10K take nine months to close.

**中文翻译:**
卡在采购环节通常是因为你对接的人级别不够高，他们不知道如何引导流程。这就是为什么我说高管必须参与，因为一旦高管拿起电话联系他们的采购部门，事情就会有进展。
(00:48:27):
当人们说“噢，我卡在采购环节了”时，我会想：“噢，那可能只是一个筛选错误（qualification error），你永远也出不来，因为你卖给了一个级别太低的人。”这就是为什么 10 万美元是一个安全区，因为即使是 1 万美元，你也可能要走采购流程。所以这是确保你不会……听着，我见过 1 万美元的单子花了 9 个月才成交。

---

### [00:48:52] Lenny Rachitsky

**English:**
No bueno.

**中文翻译:**
那可不妙。

---

### [00:48:53] Jen Abel

**English:**
Yeah, so.

**中文翻译:**
是的，所以。

---

### [00:48:55] Lenny Rachitsky

**English:**
Okay. Next piece of advice is this idea of vision casting instead of problem solving. So the advice here is instead of here's your problem, here's how our product solves it is here's how you will achieve alpha in the market by adopting the software. We talked about the example of cursor where if you adopt cursor, you're going to draw the 10X engineers that are joining other companies right now. This will give you a big advantage.

**中文翻译:**
好的。下一条建议是“描绘愿景”而非“解决问题”。这里的建议是：不要说“这是你的问题，这是我们的产品如何解决它”，而要说“通过采用这款软件，你将如何在市场中获得 alpha”。我们谈到了 Cursor 的例子：如果你采用 Cursor，你将吸引那些目前正在加入其他公司的十倍效能工程师。这将给你带来巨大的优势。

---

### [00:49:16] Jen Abel

**English:**
That's right. And yeah, it's pain versus opportunity, especially in the age of AI, and I know that we're moving into the next dimension. It's all about solving for a gap. It's seldom about solving for a very, very specific problem because people are trying to figure out what's our AI strategy? Where are we going to go with this? What is the world going to look like? I want to be a part of that new world. So it's a great time to be doing that.

**中文翻译:**
没错。是的，这是“痛苦”与“机会”的博弈。特别是在 AI 时代，我知道我们正在进入下一个维度。核心在于解决“差距”。很少是关于解决一个非常非常具体的问题，因为人们都在试图弄清楚：我们的 AI 策略是什么？我们要往哪里走？世界会变成什么样？我想成为那个新世界的一部分。所以现在是做这件事的大好时机。

---

### [00:49:42] Lenny Rachitsky

**English:**
And then there's a bunch of advice you shared about design partners, of just how to select them. Your advice is definitely have design partners because they will help you build the right thing. But as a founder, you need to have a clear vision and sense of where you want to go and not just build everything they're asking you to build.

**中文翻译:**
然后是你分享的关于设计合作伙伴的一系列建议，关于如何选择他们。你的建议是：一定要有设计合作伙伴，因为他们会帮你构建正确的产品。但作为创始人，你需要有清晰的愿景和方向感，而不能仅仅构建他们要求你构建的一切。

---

### [00:50:00] Jen Abel

**English:**
That's right, because important to say no. And that's all part of the framing, which is like here's, we want a little skin in the game. You set the price, but here's what we're marching towards in the next six to 12 months. Are we aligned there? If we deliver on what we say we're going to deliver, are we aligned there and do that kind of handshake?

**中文翻译:**
没错，因为学会拒绝很重要。这都是框架设定的一部分，就像是：“我们希望你投入一点资源。你定价格，但这是我们在未来 6 到 12 个月要实现的目标。我们的目标一致吗？如果我们交付了我们承诺的东西，我们的目标一致吗？”然后达成那种口头协议。

---

### [00:50:24] Lenny Rachitsky

**English:**
Is there anything else that I missed that you think is really important for this stage?

**中文翻译:**
在这个阶段，还有什么我遗漏的、你认为非常重要的内容吗？

---

### [00:50:29] Jen Abel

**English:**
So one to 10 is no longer the founder. Maybe the founder comes in very strategic points, but you need a really good enterprise salespeople. Taking someone from small business and expecting them to do enterprise sales, big no-no, it's a different game, right? Vibe like a different game.
(00:50:47):
You need to understand how corporations buy. You need to understand how executives think. You need to better understand simply just what the enterprise business model is all about and their ability to take on risk. People will bring in super junior enterprise sales reps and I'm like, "You're looking to sell to an executive and you have this person that's five years out of school with no corporate experience doing it, again, unless they have some extremely deep experience in the industry or are just a unicorn in terms of, wow, this person can sell ice to an Eskimo kind of thing."
(00:51:27):
A junior person converting an executive, again, if the founder is involved, maybe that's doable, but usually the founder can't be involved in every deal and you need people that can, I always say you need people that can cosplay a founder, which is selling the vision, getting them excited, running through a wall to get the deal done and getting creative on ... None of my deals look exactly the same, every deal looks different and that's okay because every organization has slightly different opportunities of where they want to go, and you have to kind of build towards that and the framing may change.
(00:52:14):
So it's this ability to adapt from what you're hearing and let that compound over time, but I always say, can this person cosplay the founder? I think that that's the best type of salesperson because it doesn't feel like sales. It's more of the art.

**中文翻译:**
从 1 到 10 的阶段，销售不再仅仅靠创始人了。也许创始人会在非常关键的战略节点介入，但你需要非常优秀的大客户销售人员。把做小企业销售的人拉过来，指望他们做大客户销售，这是大忌。这是完全不同的游戏，对吧？氛围完全不同。
(00:50:47):
你需要了解大公司如何购买。你需要了解高管如何思考。你需要更深入地了解大企业的商业模式及其承担风险的能力。有些人会招一些非常资浅的大客户销售代表，我会说：“你想向高管销售，却让一个毕业五年、完全没有大公司经验的人去做？除非他们在行业内有极深的经验，或者是那种‘能把冰卖给爱斯基摩人’的销售天才。”
(00:51:27):
让一个资浅人员去转化高管，如果创始人参与其中，也许可行，但通常创始人无法参与每一笔交易。你需要那些我常说的“能扮演创始人（cosplay a founder）”的人——他们能销售愿景，让客户兴奋，排除万难达成交易，并且在交易设计上极具创意。我的交易没有两笔是完全一样的，每一笔看起来都不同，这没关系，因为每个组织想去的地方略有不同，你必须朝着那个方向构建，框架也可能会变。
(00:52:14):
所以这是一种根据所听到的信息进行调整的能力，并让这种能力随时间产生复利。我总会问：这个人能扮演创始人吗？我认为这是最理想的销售人员类型，因为这感觉不像是在推销，更像是一门艺术。

---

### [00:52:30] Lenny Rachitsky

**English:**
This amazing advice. What is a common profile that you've seen be successful? What level of seniority? What kind of personality and any traits to look for?

**中文翻译:**
这是极好的建议。你见过的成功人士通常是什么样的背景？资历如何？性格怎样？有哪些特质值得寻找？

---

### [00:52:38] Jen Abel

**English:**
Maybe a former founder if you can get that, because they're used to selling, they sold investors and they've sold employees. Two is someone with no sales experience, but has deep product experience or an engineer and can think about things in a unique way where the market is like, "Oh, this is so interesting."
(00:53:00):
Taking a typical salesperson then and putting them into a sales role almost always is where people get frustrated. The market, it feels salesy. The market doesn't want to be sold to, they want to buy. And I know that it's very hard to hire a really good enterprise salesperson. The number of people that I've interviewed, I can count on my hand the ones that I get really, really excited by.
(00:53:29):
It's almost like coming across a great founder. It's not as common as everyone expects, and I think that that's true for engineering. I think that that's true for sales and I think a lot of people, sales is like, "Oh, just throw a body into it. The product will do the work."

**中文翻译:**
如果你能招到，也许是前创始人，因为他们习惯了销售——他们向投资者销售，向员工销售。第二种是完全没有销售经验，但有深厚产品经验的人，或者是工程师，他们能以独特的方式思考问题，让市场觉得：“噢，这太有意思了。”
(00:53:00):
而招一个典型的销售人员并把他们放在销售岗位上，几乎总是会让大家感到挫败。市场会觉得“推销味儿太重”。市场不想被推销，他们想主动购买。我知道招到一个真正优秀的大客户销售人员非常难。我面试过的人里，能让我真正感到兴奋的屈指可数。
(00:53:29):
这几乎就像遇到一个伟大的创始人一样。这并不像大家预期的那么普遍。我认为工程领域如此，销售领域亦然。很多人觉得销售就是“随便塞个人进去，产品自己会说话”。

---

### [00:53:48] Lenny Rachitsky

**English:**
Advice I often hear is don't hire a senior VP of salesperson from a bigger company. Do you agree with that? What's like to senior?

**中文翻译:**
我经常听到的建议是：不要从大公司招资深的销售副总裁（VP of Sales）。你同意吗？什么样的算太资深？

---

### [00:53:55] Jen Abel

**English:**
Yeah, so the bigger company thing, the brand was doing all of the work. The brand built the trust. You need this person to be able to build the trust and they're usually, the product is still so new. The product is the founder in the zero to one stage. The product is just starting to get a case study.
(00:54:15):
You probably have maybe a few references, but it's still very, very early days. You need the market to believe the salesperson and you need that market to know that they're trustworthy. A VP of sales at a large company, I would say, they're best suited for a large company because one to 10, you're running through walls.
(00:54:33):
You have to figure out, you're doing a lot of convincing, you're doing a lot of educating, you're doing a lot of creative deal crafting. A lot of owning the frame. It's not necessarily selling a product, it's selling that future value, which a VP of sales at a large companies, it's very different. It's a different game. It's kind of like the SMB and enterprise.

**中文翻译:**
是的。大公司的情况是，品牌承担了所有的工作，品牌建立了信任。而你需要的是一个能亲手建立信任的人，因为产品通常还很新。在 0 到 1 阶段，产品就是创始人。产品才刚刚开始有案例研究。
(00:54:15):
你可能只有几个参考客户，现在还处于非常早期的阶段。你需要市场相信这个销售人员，需要市场知道他们是值得信赖的。大公司的销售副总裁，我会说，他们最适合大公司。因为在 1 到 10 的阶段，你需要排除万难。
(00:54:33):
你必须去摸索，你要做大量的说服工作、大量的教育工作、大量的创意交易设计。你要掌控话语权。这不一定是卖产品，而是卖未来的价值。大公司的销售副总裁做的事情非常不同。这是不同的游戏，就像 SMB 和大企业的区别一样。

---

### [00:54:53] Lenny Rachitsky

**English:**
It's interesting you said when you described the profile of a great hire here is you said they don't need to have done sales. If they have done sales, what's a number years or kind of what do you look for that tells you, "Okay, this is a good fit for the first hire."

**中文翻译:**
很有趣，你在描述理想人选时说他们不需要做过销售。如果他们做过销售，你认为需要多少年经验，或者你寻找什么样的特质来告诉你“好的，这是第一个销售员工的合适人选”？

---

### [00:55:06] Jen Abel

**English:**
I actually think it's less about experience and more about the person. Does this person make you feel good? Do you want to buy from this person? I think Jason, Jason Lemkin said that best. Would you want to buy from this person?

**中文翻译:**
我其实认为经验并不那么重要，关键在于人。这个人让你感觉好吗？你想从这个人手里买东西吗？我认为 Jason Lemkin 说得最好：你想从这个人手里买东西吗？

---

### [00:55:15] Lenny Rachitsky

**English:**
Can they sell you a pen?

**中文翻译:**
他们能把笔卖给你吗？

---

### [00:55:16] Jen Abel

**English:**
The classic. Yeah, exactly. Do they mimic or mirror the market they're selling to? It's much easier to buy from someone that looks and feels like you than it does from somebody that's in a totally different realm. And also, an executive wants to talk to another senior person.
(00:55:41):
They don't want to talk to someone that just graduated from college and is selling them the new way of working. What do they know? So I think it's tricky. I would say someone with no sales experience makes it feel different and special, that's what I like about it. Someone with sales experience knows how to navigate and probably be qualified better, but it's almost like the blend of those two things.
(00:56:05):
And that's why I go back to cosplaying the founder, which is like, could this person close a future employee? Do they get excited about the problems they're solving internally and the vision that they get to sell to?

**中文翻译:**
经典台词。是的，没错。他们是否能模仿或反映他们所销售的市场？从一个看起来和感觉起来都像你的人那里买东西，比从一个完全不同领域的人那里买要容易得多。而且，高管想和另一个资深人士交谈。
(00:55:41):
他们不想和一个刚大学毕业、向他们推销“新工作方式”的人聊天。那个人懂什么？所以我觉得这很微妙。我会说，没有销售经验的人会让感觉很不同、很特别，这就是我喜欢的地方。有销售经验的人知道如何引导流程，可能在筛选客户方面做得更好，但这几乎是这两者的结合。
(00:56:05):
这就是为什么我回到“扮演创始人”这一点：这个人能招到未来的员工吗？他们会对内部正在解决的问题以及他们要销售的愿景感到兴奋吗？

---

### [00:56:19] Lenny Rachitsky

**English:**
This actually was a reader question, listener question from Twitter. So Peter Dedenne asked, "How do you make this first salesperson as enthusiastic about the product as you? Is there something you could do? Is it more just they already are and you just leverage that?"

**中文翻译:**
这实际上是一个来自 Twitter 的读者/听众提问。Peter Dedenne 问：“你如何让第一个销售人员像你一样对产品充满热情？有什么你可以做的吗？还是说他们本身就很有热情，你只是利用了这一点？”

---

### [00:56:36] Jen Abel

**English:**
Incentives. Salespeople love to make money.

**中文翻译:**
激励机制。销售人员热爱赚钱。

---

### [00:56:40] Lenny Rachitsky

**English:**
Easy.

**中文翻译:**
简单明了。

---

### [00:56:42] Jen Abel

**English:**
So if they know it's possible, if they know it's possible, you'll be shocked what people can get done.

**中文翻译:**
如果他们知道这是可能的，如果他们知道目标可以达成，你会惊讶于人们能完成什么样的成就。

---

### [00:56:49] Lenny Rachitsky

**English:**
If they see how much they could make. Amazing. I imagine there still also has to be an innate excitement about the product and the opportunity.

**中文翻译:**
如果他们看到自己能赚多少钱。太棒了。我想肯定还是需要对产品和机会有一种内在的兴奋感。

---

### [00:56:58] Jen Abel

**English:**
They have to believe in it. They have to believe in the founder, but incentives usually make the world go round, but yeah, is this person, are they asking the right questions to the founder? The best thing to do is have the founder join the first five calls. You know after five calls if this person has what it takes, and don't be afraid to fire. One in every two salespeople usually are fired. Yeah, it's a very high failure rate.

**中文翻译:**
他们必须相信产品，必须相信创始人，但激励机制通常是驱动力。此外，这个人是否向创始人提出了正确的问题？最好的做法是让创始人参加前五次通话。五次通话后，你就知道这个人是否具备成功的潜质。不要害怕解雇。每两个销售人员中通常就有一个会被解雇。是的，失败率非常高。

---

### [00:57:33] Lenny Rachitsky

**English:**
Because you can tell pretty quickly how it's going.

**中文翻译:**
因为你很快就能看出进展如何。

---

### [00:57:35] Jen Abel

**English:**
You can tell, or the vision of the founders is just very wrong.

**中文翻译:**
你能看出来，或者说明创始人的愿景根本就是错的。

---

### [00:57:39] Lenny Rachitsky

**English:**
Speaking of incentives, do you have any quick advice on how to structure their comp? Just like how much they earn?

**中文翻译:**
说到激励，关于如何构建他们的薪酬结构（comp），你有什么简短的建议吗？比如他们能赚多少？

---

### [00:57:45] Jen Abel

**English:**
It's usually 50/50. So it's 50% OTE. So it's 50% base salary, 50% OTE.

**中文翻译:**
通常是 50/50。即 50% 是底薪，50% 是目标薪酬（OTE，即达成目标后的奖金）。

---

### [00:57:53] Lenny Rachitsky

**English:**
And then how much of the sale do they typically get? Say the first sales hire.

**中文翻译:**
那么他们通常能从销售额中拿多少提成？比如第一个销售员工。

---

### [00:57:57] Jen Abel

**English:**
It depends on the size of the deal, but in technology, it could be anywhere between eight and 12%. So rounds out around 10%.

**中文翻译:**
这取决于交易规模，但在科技行业，通常在 8% 到 12% 之间。所以平均在 10% 左右。

---

### [00:58:07] Lenny Rachitsky

**English:**
Okay. Awesome. When do you hire the first salesperson? Is it around the 1 million ARR mark usually?

**中文翻译:**
好的。太棒了。什么时候招第一个销售人员？通常是在 100 万美元 ARR 左右吗？

---

### [00:58:13] Jen Abel

**English:**
Yeah, it's around that 1 million ARR, mark and I, and it's usually when you have your first seven to 10 customers and there's some pattern recognition around it that you can share with somebody else, there's some consistencies. Otherwise, it's just like that would be very hard.

**中文翻译:**
是的，大约在 100 万美元 ARR 左右。通常是你有了前 7 到 10 个客户，并且已经有了一些可以分享给别人的模式识别（pattern recognition），即一些一致性的东西。否则，这会非常困难。

---

### [00:58:34] Lenny Rachitsky

**English:**
Basically as a founder, you have to figure out how to sell enough times so that you can show someone, "Here's what's working."

**中文翻译:**
基本上作为创始人，你必须亲自完成足够多次的销售，这样你才能向别人展示：“这就是行之有效的方法。”

---

### [00:58:40] Jen Abel

**English:**
And this is the common thing I hear, "Well, I'm a $10 million business. I'm in this small business space. You're $0 in enterprise." It's a zero to one right now in enterprise. It's a totally different game. It's a different value proposition, it's a different deal structuring, it's a different target market. It's a different risk tolerance. It's totally different. So don't be blindsided when-

**中文翻译:**
这是我常听到的说法：“嗯，我是一家 1000 万美元规模的公司，我在小企业领域。”但你在大企业领域是 0。在大企业领域，现在就是从 0 到 1。这是完全不同的游戏。价值主张不同，交易结构不同，目标市场不同，风险承受能力也不同。完全不同。所以当事情进展不顺时，不要感到意外……

---

### [00:59:08] Lenny Rachitsky

**English:**
It doesn't work.

**中文翻译:**
……如果它行不通的话。

---

### [00:59:08] Jen Abel

**English:**
... There's a lot of unlearning that needs to happen when you move into a new market.

**中文翻译:**
……当你进入一个新市场时，有很多旧经验需要被抛弃（unlearning）。

---

### [00:59:12] Lenny Rachitsky

**English:**
The advice here is make yourself sell up until around a million ARR, especially if you're trying to go enterprise selling to enterprises yourself as a founder, which is really hard. You have so much to do and you have to be selling this thing for a long time time.

**中文翻译:**
这里的建议是：让自己亲自销售直到 100 万美元 ARR 左右，特别是如果你想攻克大企业。作为创始人亲自向大企业销售是非常难的，你有那么多事要做，而且你必须长期亲自销售。

---

### [00:59:26] Jen Abel

**English:**
Yep. And then try and find someone that you get excited by. It's funny, if you ask the founder, are you excited by your salesperson? I'm curious what the real answer is. It's like, "Well, it's a button to see it in. It was hard to hire, so."

**中文翻译:**
是的。然后试着找一个让你感到兴奋的人。很有趣，如果你问创始人：“你对你的销售人员感到兴奋吗？”我很想知道真实的答案。通常是：“嗯，总得有人在那儿干活，招聘太难了，所以就他了。”

---

### [00:59:41] Lenny Rachitsky

**English:**
Interesting. I remember, I think it was Jason's advice was to hire two people immediately.

**中文翻译:**
有趣。我记得 Jason 的建议是立即招两个人。

---

### [00:59:41] Jen Abel

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:59:46] Lenny Rachitsky

**English:**
So you can compare them. Do you agree with that?

**中文翻译:**
这样你就可以比较他们。你同意吗？

---

### [00:59:48] Jen Abel

**English:**
100%. Yeah, because of the 50% failure rate. I think that's exactly right. So yeah, even a tall order, go find two people that are good. But yeah, I think that that's right because one in two will fail.

**中文翻译:**
100% 同意。是的，因为有 50% 的失败率。我认为这完全正确。所以，虽然任务艰巨，但要去找两个优秀的人。我认为这是对的，因为两个人里总有一个会失败。

---

### [01:00:02] Lenny Rachitsky

**English:**
Okay, let me ask you another reader question from Hang Huang. This is kind of in a different direction. So he says, "The biggest challenge is always cutting through the noise to get that initial meeting with the right decision maker. How do you even get their attention?"

**中文翻译:**
好的，让我问你另一个来自 Hang Huang 的读者提问。这是一个不同的方向。他说：“最大的挑战始终是如何穿透噪音，获得与正确决策者的初次会面。你到底该如何吸引他们的注意力？”

---

### [01:00:15] Jen Abel

**English:**
It's the vision. What is the opportunity that you're selling? That if they are excited by that, they will take a call. I see it all the time, and don't give away the farm. Keep it to three sentences. And I know I said this on our first call, but say something counterintuitive, they could feel different. Make it feel like they can learn from you by taking a 15-minute call. You see the standards of like, "Oh, I came across your LinkedIn." And, "Are you looking to grow your business by 15%?" It's like, "What kind of statement is that?"

**中文翻译:**
是愿景。你销售的机会是什么？如果他们对此感到兴奋，他们就会接电话。我经常见到这种情况。还有，不要一下子全盘托出，保持在三句话以内。我知道我在第一次通话中说过，要说一些违背直觉的话，让他们感觉不一样。让他们觉得通过 15 分钟的通话能从你这里学到东西。你经常看到那种标准的开场白：“噢，我看到了你的 LinkedIn。”以及“你想让业务增长 15% 吗？”这算哪门子开场白？

---

### [01:00:53] Lenny Rachitsky

**English:**
And this is in the cold email they get about this pitch.

**中文翻译:**
这就是他们在推销邮件（cold email）里收到的内容。

---

### [01:00:56] Jen Abel

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:00:56] Lenny Rachitsky

**English:**
Awesome. So this is a good segue to another reader question from Hugo Alves, Co-Founder of Synthetic users. He asked, "What's the best advice for going from healthy inbound to targeted outbound?"

**中文翻译:**
太棒了。这很好地引出了另一个来自 Synthetic users 联合创始人 Hugo Alves 的读者提问。他问：“从健康的被动咨询（Inbound）转向有针对性的主动触达（Outbound），最好的建议是什么？”

---

### [01:01:07] Jen Abel

**English:**
Healthy inbound usually is a marketing-led initiative. So that's a marketing game. It depends what deal value you're selling. Are you selling a $5,000 deal? It's got to be marketing-led to make the engine work. If you're selling $100,000 deal, you're doing outbound day one. So again, it breaks it into those. This is like that blending of the, I see a blending of that question. This is where you're doing small business marketing-led activities or are you a sales-led organization selling a $100,000 deal?

**中文翻译:**
健康的 Inbound 通常是营销驱动的举措。所以那是营销的游戏。这取决于你销售的交易价值。你卖的是 5000 美元的单子吗？那必须是营销驱动才能让引擎运转。如果你卖的是 10 万美元的单子，你从第一天起就在做 Outbound。所以，再次强调，要区分开来。我看到这个问题里有一种混淆：你是在做小企业的营销驱动活动，还是一个销售驱动的、卖 10 万美元单子的组织？

---

### [01:01:40] Lenny Rachitsky

**English:**
And the reason that's important, just in case it's not obvious, is you're not going to make money if you're selling. People are spending time closing deals that are making 10, 20K. Just the ROI on that won't work for your business model.

**中文翻译:**
这一点之所以重要（以防大家没看出来），是因为如果你让员工花时间去成交那些只有 1 万、2 万美元的单子，你是赚不到钱的。这种投入产出比（ROI）不符合你的商业模式。

---

### [01:01:51] Jen Abel

**English:**
That's right. Yep.

**中文翻译:**
没错。是的。

---

### [01:01:53] Lenny Rachitsky

**English:**
Awesome. By the way, let me just say, Jen, this is an incredible conversation already. We've gone-

**中文翻译:**
太棒了。顺便说一句，Jen，这次对话已经非常精彩了。我们已经……

---

### [01:01:57] Jen Abel

**English:**
Oh this awesome.

**中文翻译:**
噢，这太棒了。

---

### [01:01:58] Lenny Rachitsky

**English:**
... Through so much. This is exactly what I was hoping to get through and we've gone through so much advice that I think is going to be so helpful to so many people. There's a few things that your partner, Justin also suggested I ask you about that I want to touch on. One is you have this question you ask founders a lot that opens up their mind. You ask them, "If you give your product away for free, would people even use this?" And every founder is like, "Of course." And then you ask, "A customer this?" And they're like, "Nah, we wouldn't use this." And that just blows their mind. Talk about just the power of that and how you recommend people approach this.

**中文翻译:**
……探讨了这么多内容。这正是我希望涵盖的，我们讨论了这么多建议，我认为对很多人都会非常有帮助。你的合伙人 Justin 也建议我问你几件事。其中一个是：你经常问创始人一个能启发他们思考的问题。你问他们：“如果你免费提供产品，人们会用吗？”每个创始人都说：“当然。”然后你问客户这个问题，他们却说：“不，我们不会用。”这让他们大吃一惊。谈谈这个问题的力量，以及你建议人们如何应对。

---

### [01:02:33] Jen Abel

**English:**
I always say ask the questions you're afraid to because that truth is going to get you closer and closer to the answer. So I'll ask a client straight up on a call, I'll say, "Honestly, do we think we're going to get the deal done this year? Is it possible?" They'll give you the real answer and people are afraid to ask. But the other side is sort of if they're in it with you, they don't care about that question, right?
(01:03:01):
Can't ask that question on day one, but if you are, and we didn't talk about this, but maybe this is important. Every single enterprise deal I have done, the deal is done, the deal is closed and pretty much done through text. It's not on email anymore. It is a relationship you're building with someone where if my enterprise client called me, I'm picking up that phone immediately or I'm responding them to immediately because that builds so much trust.
(01:03:31):
If they know they can call on you, they're going to get you to pick up and they know that you're going to do everything humanly possible to make sure that this is successful. People will turn over rocks for you. I have a client at a Fortune 10 company where I was like, it's so important we get the deal done this year. Is that possible? And she's like, it's a tall order, but if it's going to help you, let's do it.
(01:04:00):
These are how enterprise deals gets done, it's relationships and it's this, and this is why I'm saying structuring the deal, make it feel like you went to bat for them and in often cases, you are going to bat for them and structure it in a way that makes sense for them. Everyone kind of just tries and pigeonhole. Pigeonholing and deal structuring consistency is important for a $10,000, sub-$10,000 deal. A $100,000 deal, it very commonly will look different every time.

**中文翻译:**
我总是说，要问那些你害怕问的问题，因为真相会让你越来越接近答案。所以我会直接在通话中问客户：“老实说，你觉得我们今年能达成交易吗？有可能吗？”他们会给你真实的答案，而人们往往不敢问。但另一方面，如果他们是真心想和你合作，他们不会介意这个问题，对吧？
(01:03:01):
你不能在第一天就问这个问题，但如果你已经深入其中……我们还没谈到这一点，但这可能很重要：我达成的每一笔大客户交易，最终都是通过短信（text）敲定和关闭的。不再是邮件了。这是一种你与某人建立的关系，如果我的大客户给我打电话，我会立即接听，或者立即回复，因为这能建立巨大的信任。
(01:03:31):
如果他们知道可以随时找你，你会接电话，并且知道你会竭尽全力确保成功，人们会为你排除万难。我有一个财富 10 强公司的客户，我当时说：“今年达成交易对我们非常重要，有可能吗？”她说：“任务很艰巨，但如果这能帮到你，那我们就做吧。”
(01:04:00):
这就是大客户交易达成的方式——靠关系。这就是为什么我说要设计交易结构，让客户觉得你在为他们争取利益（事实上你经常确实在为他们争取），并以对他们有意义的方式构建结构。大家总想把事情标准化。对于 1 万美元以下的单子，标准化和一致性很重要；但对于 10 万美元的单子，通常每次看起来都不一样。

---

### [01:04:32] Lenny Rachitsky

**English:**
April Dunford was on the podcast and she shared this really interesting insight that the reason people behave this way is the person at the company buying this thing, their ass is on the line Also, their reputation is on the line for this thing to work out. So they want it to go really well.

**中文翻译:**
April Dunford 曾来过播客，她分享了一个非常有趣的见解：人们之所以这样表现，是因为公司里负责购买的人，他们的前途（ass is on the line）和声誉也押在了这件事上。所以他们希望事情进展得非常顺利。

---

### [01:04:45] Jen Abel

**English:**
That's right. Again, they do this one in every three years, one in every two years, maybe one in every five years. Hell, I don't know. They don't do this every year. It's very rare. It's no one likes a new tool. No one. Not you, not me, unless it changes everything.

**中文翻译:**
没错。再说一次，他们每三五年才做一次这样的决定。我也不确定具体频率，但绝不是每年都做。这很罕见。没人喜欢新工具，没人。你我不喜欢，除非它能改变一切。

---

### [01:05:05] Lenny Rachitsky

**English:**
Yeah. Figma was a great example, that's Slack.

**中文翻译:**
是的。Figma 是个很好的例子，Slack 也是。

---

### [01:05:08] Jen Abel

**English:**
Everything you've touched

**中文翻译:**
你接触过的一切成功的案例。

---

### [01:05:10] Lenny Rachitsky

**English:**
Everything that worked out. You said that you asked these questions that people are afraid to ask. What are some other examples of questions you often ask that people are afraid to ask?

**中文翻译:**
所有成功的案例。你说你会问那些人们不敢问的问题。还有哪些你经常问、但别人不敢问的问题例子？

---

### [01:05:20] Jen Abel

**English:**
I will say, "Listen, this is $150,000 engagement. I will co-author it with you where we can make this a little bit bigger if you need something else. We can make it a little bit smaller in year one, but in year two it steps up. How do we get this done so when you go to bat, it's a win?" Sell them, do they take it to the wrong side and try and discount you? I've actually never seen that because at that point you have a relationship.
(01:05:51):
So co-authoring the pricing is so important because they need to know that they go to bat, they can say, "I got this out of them. If we get this deal done." So this is why when I say every deal looks the same, you're asking great questions because it's explaining why I meant by that, but this is another example of why every deal in the enterprise sort of looks somewhat different because a lot of it is co-authored. So again, if someone wants a slightly lower price, give it to them, but maybe them lock them in a little bit longer.

**中文翻译:**
我会说：“听着，这是一个 15 万美元的项目。我会和你共同设计（co-author）方案，如果你需要别的，我们可以把它做大一点；或者第一年做小一点，第二年再增加。我们该如何达成这个方案，好让你去向上级争取时能稳操胜券？”卖给他们方案。他们会反过来利用这一点来压价吗？我其实从未见过，因为到那个阶段你们已经建立了关系。
(01:05:51):
所以“共同设计定价”非常重要，因为他们需要知道，当他们去争取时，他们可以说：“如果达成这笔交易，我从他们那儿争取到了这些好处。”这就是为什么我说每笔交易看起来都不同。你问得很好，这解释了我的意思。这是大客户交易看起来各不相同的另一个例子，因为很多内容是共同设计的。所以，如果有人想要稍低的价格，给他们，但也许可以让他们签约时间更长一点。

---

### [01:06:25] Lenny Rachitsky

**English:**
There's another point that Justin makes that you've touched on a bit, but it's when your no, the way he phrased it is, Jen always talks about how no is the best answer to yes because no is data that you can use. Talk about that.

**中文翻译:**
Justin 还提到了另一点，你也稍微触及到了，就是关于“拒绝”。他的表述是：Jen 总说“不”是仅次于“是”的最佳答案，因为“不”是可以利用的数据。谈谈这个。

---

### [01:06:38] Jen Abel

**English:**
I am a qualification crazy person. I will not get in on another call with someone because on the first call it's either a yes or a no, there's no in between. Humans are, we're so different and we're so unpredictable, but we're also so predictable at the same time, right? It's very obvious if someone is excited and wants to do something, it is so obvious when someone is just trying to be nice.
(01:07:06):
So I will say to them on that call, "I'm sort of getting the vibe that this might not be a good fit or might not be good timing. Did I misinterpret that?" And they will usually say, "Yeah, you're right, it's probably not a good fit." And then immediately, "Great, I would love to stay in touch. You've just saved a relationship and you've just saved yourself a ton of time."

**中文翻译:**
我是一个疯狂迷恋“筛选”（qualification）的人。我不会和某人进行第二次通话，因为在第一次通话中，要么是“行”，要么是“不行”，没有中间地带。人类既千差万别、不可预测，同时又非常容易预测，对吧？如果某人很兴奋并想做某事，那是显而易见的；而如果某人只是在出于礼貌，那同样显而易见。
(01:07:06):
所以我会直接在通话中对他们说：“我感觉这可能不太合适，或者时机不对。我理解错了吗？”他们通常会说：“是的，你对了，可能确实不太合适。”然后我会立即说：“太好了，希望能保持联系。”你刚刚挽救了一段关系，也为自己节省了大量时间。

---

### [01:07:24] Lenny Rachitsky

**English:**
And the implication here is just to your point, you're limited on time. You don't want to be spending time going down or rival that won't you anywhere.

**中文翻译:**
这里的含义正如你所说，你的时间有限。你不想花时间去追逐那些不会有结果的线索。

---

### [01:07:24] Jen Abel

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [01:07:33] Lenny Rachitsky

**English:**
I'm going to take a quick tangent on tools. What's the state of the art on go-to-market outbound tooling?

**中文翻译:**
我想插播一个关于工具的话题。目前 GTM 主动触达工具的最前沿技术是什么？

---

### [01:07:39] Jen Abel

**English:**
I don't use a tool because I believe in the manual and I'll explain why. Every single note I send is slightly different because I see a picture of them and I'm like, "Oh, I don't know if that's going to land." Or I'm like, "Oh, they actually might appreciate this. It's weird." Visual cues are so helpful. A picture is a visual cue, looking at how long they've been in the role, looking how long they've been at the company.
(01:08:05):
I use all of these little things and I seldom customize a note in a way that people expect which is that first customized sentence because AI does that, and everyone's doing that. So I go the opposite extreme, which is like remove it and I customize it with how I frame it or the subject line. So it's like if I'm talking to someone like a peer, I might say quick question like QQ.
(01:08:36):
If I'm talking to someone that has a bit more experience, I might write a little bit of a tighter note, not all lowercase. So it just depends on who you're speaking to. And again, this is why it's okay to spend a little bit of time on this because it's a hundred thousand dollars. It's actually a million dollars at the end of the day because a $100,000 deal if you play your cards right turns into a million dollar deal over three to five years.

**中文翻译:**
我不使用工具，因为我相信手动操作，我来解释原因。我发送的每一条信息都略有不同，因为我看到他们的照片会想：“噢，我不确定这句话合不合适。”或者想：“噢，他们可能真的会欣赏这一点。这很奇妙。”视觉线索（visual cues）非常有帮助。照片是视觉线索，看他们在岗位上待了多久，在公司待了多久。
(01:08:05):
我会利用所有这些小细节。我很少按照人们预期的那样去定制信息（比如第一句定制的话），因为 AI 就在做那个，所有人都在做那个。所以我走向了另一个极端：去掉那些，通过我的表达框架或主题行来定制。比如，如果我是在和同龄人交谈，我可能会说“quick question”或“QQ”。
(01:08:36):
如果我是在和更有经验的人交谈，我可能会写得更严谨一点，而不是全小写。这取决于你在和谁说话。再次强调，这就是为什么值得花点时间在这上面，因为这是 10 万美元的生意。实际上最终是 100 万美元，因为如果你处理得当，一个 10 万美元的单子在三五年内会变成 100 万美元。

---

### [01:09:03] Lenny Rachitsky

**English:**
I love how much you enjoy this. It's so fun to, so essentially what are you doing? You're sitting on LinkedIn finding folks to ping and then you cold email them one individually, manually.

**中文翻译:**
我喜欢你对这件事的热爱。这太有趣了。所以本质上你在做什么？你坐在 LinkedIn 前寻找可以联系的人，然后手动给他们发邮件，一个一个来。

---

### [01:09:13] Jen Abel

**English:**
It's so weird, Lenny, I have no process. I kind of just go with the vibe. I'll read an article about Tesla and I'm like, "Huh, they could be interested in this." Not because that article had anything to do with the problem I'm solving, but because I'm like, "This feels like a good Tesla day." It's hard to describe. It's a very emotional thing for me, and not to toot my own horn, obviously, but I've been successful in sales and the most successful sales people can't explain why they're good at it.
(01:09:51):
It just comes to them naturally. It's just like an emotional thing. It's like the world's best founders. How do you be a good founder? It's very, very hard to define. How do you become a good engineer? Very, very hard to define. So I don't believe in playbooks. I believe that there's a feel to it. I emailed a chief legal officer at a hedge fund once and he responded to me because I wrote to him on Saturday. I knew it was going to be busy. I made it one sentence and it was tweaked for him.

**中文翻译:**
这很奇怪，Lenny，我没有固定的流程。我有点随性而为。我会读一篇关于特斯拉的文章，然后想：“嗯，他们可能对这个感兴趣。”不是因为那篇文章和我解决的问题有关，而是因为我觉得“今天感觉是个联系特斯拉的好日子”。很难描述，这对我来说是一种很感性的东西。当然，不是自夸，我在销售方面一直很成功，而最成功的销售人员往往解释不清自己为什么厉害。
(01:09:51):
这是一种天赋。就像一种情感上的直觉。就像世界上最伟大的创始人。如何成为一个好的创始人？很难定义。如何成为一个好的工程师？也很难定义。所以我不相信套路（playbooks）。我相信有一种“感觉”。我曾经给一家对冲基金的首席法务官发邮件，他回复了我，因为我是在周六写的。我知道他会很忙，所以我只写了一句话，而且是专门为他调整的。

---

### [01:10:29] Lenny Rachitsky

**English:**
Do you feel like this is going to be the way as AI SDRs just kind of take over and everyone's getting billions of emails that feel AI-ish?

**中文翻译:**
你觉得随着 AI SDR（销售开发代表）的普及，每个人都收到数十亿封带有 AI 味儿的邮件，这种手动方式会成为主流吗？

---

### [01:10:37] Jen Abel

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:10:40] Lenny Rachitsky

**English:**
So I guess maybe speak more there. Just like is the alpha essentially just become human? Don't automate? Should you think you should?

**中文翻译:**
我想请你多谈谈。所以“超额收益”（alpha）本质上就是回归人性？不要自动化？你觉得应该这样吗？

---

### [01:10:49] Jen Abel

**English:**
The thing about AI tools is they're all pulling from the same databases. So I'm like, "I want to email someone not in the database that's getting hit by a million folks. I want to take a back door in, not the front door where everyone else is trick-or-treating."

**中文翻译:**
AI 工具的问题在于它们都在调用相同的数据库。所以我想：“我要给那些不在数据库里、没被一百万人骚扰的人发邮件。我要走后门，而不是走那个所有人都在像万圣节讨糖一样敲门的前门。”

---

### [01:11:04] Lenny Rachitsky

**English:**
And this is effective for very large deal, which is what you need to be doing anyway because it takes a lot of time to do it this way.

**中文翻译:**
这对于大额交易非常有效，而这正是你无论如何都该做的，因为这种方式确实很耗时。

---

### [01:11:12] Jen Abel

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:11:12] Lenny Rachitsky

**English:**
Interesting. So you're not like sitting in Clay, you're not like Apollo, I don't have all those tools. You're just finding people yourself.

**中文翻译:**
有趣。所以你不用 Clay，不用 Apollo，没有那些工具。你只是自己找人。

---

### [01:11:19] Jen Abel

**English:**
Yep.

**中文翻译:**
没错。

---

### [01:11:20] Lenny Rachitsky

**English:**
Do you start with a target prospect list at least just like, "Here's the companies that are the perfect fit for this and let's work through them."

**中文翻译:**
你至少会有一个目标潜在客户名单吧？比如“这些公司是完美契合的，让我们逐一攻克”。

---

### [01:11:30] Jen Abel

**English:**
It's all in my brain. I've been doing this for so long, I have in my brain, I'm like, these are my early adopters. These who I'm going to go to after I close those logos, they get excited by those logos. So it's just experience of you land a Walmart, you're going to go to the rest of the industry and say, "Hey, we're working with Walmart." Versus you go to some lower end enterprise company and they're like, "Wait, what do you do?" I can't even comprehend.
(01:12:02):
Also, the most strategic people, some of the most strategic executives are at these tier one logos. That's why they're tier one because they've got super smart, really capable folks. They also extract the best talent, the best talent likes to experiment and continue to improve. So it's like this compounding thing.

**中文翻译:**
全在我的脑子里。我做这行太久了，我脑子里就有数：这些是我的早期采用者。拿下这些品牌后，我会去找谁，因为他们会被这些品牌吸引。这就是经验：你拿下了沃尔玛，你就可以去找同行业的其他公司说：“嘿，我们在和沃尔玛合作。”而如果你去找一些低端企业，他们会说：“等等，你是做什么的？”我甚至无法理解。
(01:12:02):
此外，最具有战略眼光的人、一些最顶尖的高管都在这些一线大厂里。这就是为什么它们是一线大厂，因为它们拥有超级聪明、极具能力的人才。它们也吸引着最优秀的人才，而最优秀的人才喜欢实验并不断进步。所以这是一种复利效应。

---

### [01:12:20] Lenny Rachitsky

**English:**
For someone that isn't Jen and has all this experience, say their founder, they're hit a million ARR. They're just like, "Okay, where do we find our customers?" Do you have any advice for just coming up with who we should go after? Should they be using these tools? Should they be hiring someone like a Jen? I know this is what you do for companies. So one crowd is go hire JJELLYFISH to help them through this.

**中文翻译:**
对于那些不是 Jen、没有这么多经验的人，假设他们是创始人，刚达到 100 万美元 ARR。他们会想：“好吧，我们去哪找客户？”关于如何确定该攻克谁，你有什么建议？他们应该使用这些工具吗？他们应该雇佣像 Jen 这样的人吗？我知道这就是你为公司所做的事情。所以一种选择是雇佣 JJELLYFISH 来帮助他们。

---

### [01:12:39] Jen Abel

**English:**
Founder, the founder. I would say the founder, this is sort of in tune with them in a way. They just have to find it. It's so weird to say it's all, and I hate saying it because it's like a commonplace thing to say, but it's like there's this thing about flow and it's like some of these brands are in flow with you right now, right? You found this insight from somewhere. Who else? What's the next adjacent ring of people that would buy into that?

**中文翻译:**
创始人，还是得靠创始人。我会说创始人，这在某种程度上与他们的直觉相通。他们必须去寻找。说这一切都靠直觉很奇怪，我也讨厌这么说，因为这听起来像陈词滥调，但确实有一种“心流”的东西。有些品牌现在正与你处于同一频率，对吧？你从某处得到了这个洞察。还有谁？下一个会认同这一点的相邻圈子是谁？

---

### [01:13:21] Lenny Rachitsky

**English:**
And what I'm hearing is just pay attention to what's happening, what companies are-

**中文翻译:**
我听到的是：关注正在发生的事情，关注哪些公司……

---

### [01:13:25] Jen Abel

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:13:25] Lenny Rachitsky

**English:**
The news, what companies are doing interesting things, who are the kind of early adopters in the market.

**中文翻译:**
新闻，哪些公司在做有趣的事情，谁是市场上的早期采用者。

---

### [01:13:29] Jen Abel

**English:**
If it was just a database list and it was just about figuring out the right messaging and then emailing folks, we would've known by that by now.

**中文翻译:**
如果仅仅是靠数据库名单、琢磨出正确的信息然后发邮件，我们早就知道该怎么做了。

---

### [01:13:40] Lenny Rachitsky

**English:**
That's so interesting. Okay, maybe one more question. This again is from Justin. He shares that when you hit resistance, you never argue, you reframe. If someone says, "We already have X solution, you'll agree and pivot and totally X is great for this thing, but here's what we can do."

**中文翻译:**
太有意思了。好，最后一个问题。这又是来自 Justin 的。他分享说，当你遇到阻力时，你从不争论，而是重构（reframe）。如果有人说“我们已经有 X 解决方案了”，你会表示赞同并转折：“完全正确，X 在那方面很棒，但这就是我们能做的。”

---

### [01:13:55] Jen Abel

**English:**
This is why it's sell to the alpha. Hey, I know. Listen, that problem you just described, you're right. You have a tool for that. We're taking you much further upstream with value. This is the opportunity I want you guys to have access to.

**中文翻译:**
这就是为什么要销售 alpha。嘿，我知道。听着，你刚才描述的那个问题，你说得对，你已经有工具解决了。而我们是在价值链的更上游为你提供价值。这就是我想让你们接触到的机会。

---

### [01:14:08] Lenny Rachitsky

**English:**
I love it, Jen. I've gone through everything I was hoping to get through. On the other hand, I feel like we could do another hour on all these things, I feel like we need to do.

**中文翻译:**
我太喜欢这个了，Jen。我已经涵盖了所有我希望能讨论的内容。另一方面，我觉得我们可以就这些话题再聊一个小时。

---

### [01:14:17] Jen Abel

**English:**
We have three.

**中文翻译:**
我们还有第三部分。

---

### [01:14:19] Lenny Rachitsky

**English:**
Yeah, we need round three on the next phase and all the things that people want to dig further into. Before we get to our very exciting lightning round, is there anything else that you wanted to touch on or share?

**中文翻译:**
是的，我们需要第三轮，讨论下一个阶段以及人们想深入挖掘的所有内容。在进入非常精彩的闪电问答环节之前，你还有什么想补充或分享的吗？

---

### [01:14:30] Jen Abel

**English:**
This stuff is really hard. It's very hard. Sales is also all about learning very, very quickly from the rejection. The rejection is good because it's a forced learning and you never want to go through that again, but you have to be, I don't like to use the word cringe. You can't be afraid to cringe is like bringing your AI recorder into a call, that's cringey, but sending 15 notes to people that you can deliver serious value to, don't be afraid, and don't be afraid to ask the hard questions. Be different.
(01:15:12):
The whole game is about, "Oh, this feels different. That's what people want access to." Yet everyone commoditizes themselves. They try and mimic what everyone, they try and mimic a forward deployed engineer. Just rename it. You don't have to use the same nomenclature. Everyone gets excited by the new because the new could be the next thing, the thing that changes it all. So that's why I'm always like, "Don't be better. Be different."

**中文翻译:**
这些事真的很难，非常难。销售的核心在于从拒绝中飞速学习。拒绝是好事，因为它是一种强制性的学习，你永远不想再经历一次。但你必须……我不想用“尴尬”（cringe）这个词。你不能害怕尴尬，比如把 AI 录音机带进通话，那可能挺尴尬的；但给 15 个你能提供重大价值的人发信息，不要害怕，也不要害怕问那些困难的问题。要与众不同。
(01:15:12):
整个游戏的真谛在于：“噢，这感觉不一样。”这才是人们想要接触的东西。然而，每个人都在把自己平庸化（commoditizes）。他们试图模仿别人，模仿“前线部署工程师”。其实换个名字就行，你不必使用相同的术语。每个人都对新事物感到兴奋，因为新事物可能是下一个大趋势，是改变一切的东西。所以我总是说：“不要追求更好，要追求不同。”

---

### [01:15:40] Lenny Rachitsky

**English:**
An amazing way to end it. With that, Jen, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
这是一个完美的结尾。Jen，现在进入我们非常精彩的闪电问答环节。我有五个问题要问你。准备好了吗？

---

### [01:15:48] Jen Abel

**English:**
Yeah.

**中文翻译:**
准备好了。

---

### [01:15:48] Lenny Rachitsky

**English:**
First question, what are two or three books that you find yourself recommending most to other people?

**中文翻译:**
第一个问题：你最常向别人推荐的两三本书是什么？

---

### [01:15:54] Jen Abel

**English:**
I do Twitter accounts.

**中文翻译:**
我推荐 Twitter 账号。

---

### [01:15:57] Lenny Rachitsky

**English:**
Oh, Twitter accounts to follow? Oh, amazing.

**中文翻译:**
噢，值得关注的 Twitter 账号？太棒了。

---

### [01:15:57] Jen Abel

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:15:58] Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:16:00] Jen Abel

**English:**
Lenny, the day I have time to read a book.

**中文翻译:**
Lenny，等哪天我有时间读完一本书再说吧。

---

### [01:16:03] Lenny Rachitsky

**English:**
Period.

**中文翻译:**
确实。

---

### [01:16:05] Jen Abel

**English:**
Period. I would love to be reading books.

**中文翻译:**
确实。我也很想读书。

---

### [01:16:10] Lenny Rachitsky

**English:**
Cool. Twitter accounts to follow. Tell me.

**中文翻译:**
酷。要关注的 Twitter 账号，告诉我。

---

### [01:16:11] Jen Abel

**English:**
Yeah. Look, obviously you, you produce some of the best content, truthfully,

**中文翻译:**
好的。首先显然是你，说实话，你产出了很多最棒的内容。

---

### [01:16:16] Lenny Rachitsky

**English:**
Appreciate it.

**中文翻译:**
过奖了。

---

### [01:16:18] Jen Abel

**English:**
You get into the minds of people that they're not even giving this insight on Twitter. Who else do I absolutely love? Jason Lemkin. So for sales, Jason Lemkin is awesome, awesome follow for sales, and also he had a great, great recording with you. So link to that because that was a great piece. I actually learned a ton from Matt. I love Gavin Baker. Super nuanced takes. Takes a lot of obvious statements, but shares a lot of the non-obvious insight. He's great. Jason Cohen, have you ever had Jason Cohen on the cast?

**中文翻译:**
你深入挖掘了那些在 Twitter 上都看不到的洞察。还有谁是我非常喜欢的？Jason Lemkin。关于销售，Jason Lemkin 是必关注的，他在销售方面的见解非常棒，而且他和你也录过一期很棒的节目。大家可以去听听，那一集非常精彩。我从他那里学到了很多。我还喜欢 Gavin Baker，他的观点非常细腻。他会拿很多显而易见的陈述，分享很多非显而易见的洞察。他很棒。Jason Cohen，你请过 Jason Cohen 吗？

---

### [01:16:57] Lenny Rachitsky

**English:**
Jason Cohen, a Smart Bear Jason Cohen?

**中文翻译:**
Jason Cohen？Smart Bear 的那个 Jason Cohen？

---

### [01:17:00] Jen Abel

**English:**
Yeah, yeah, yeah.

**中文翻译:**
是的，没错。

---

### [01:17:00] Lenny Rachitsky

**English:**
He's coming on the podcast at the end of the year or something.

**中文翻译:**
他会在年底左右来参加播客。

---

### [01:17:05] Jen Abel

**English:**
Oh, that's awesome. What a great plug for him right there.

**中文翻译:**
噢，太棒了。这真是个很好的预告。

---

### [01:17:05] Lenny Rachitsky

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:17:08] Jen Abel

**English:**
Yeah, those three would be great. I know they're all men, but.

**中文翻译:**
是的，这三个人很棒。我知道他们都是男性，但是……

---

### [01:17:11] Lenny Rachitsky

**English:**
Great tips.

**中文翻译:**
很好的建议。

---

### [01:17:11] Jen Abel

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:17:12] Lenny Rachitsky

**English:**
Next question, is there a favorite recent movie or TV show that you've really enjoyed? I know you said you have time to read.

**中文翻译:**
下一个问题：最近有没有你非常喜欢的电影或电视节目？我知道你说你没时间看书。

---

### [01:17:18] Jen Abel

**English:**
This is going to be embarrassing, Baywatch.

**中文翻译:**
这说起来有点尴尬，《海滩救护队》（Baywatch）。

---

### [01:17:22] Lenny Rachitsky

**English:**
Baywatch.

**中文翻译:**
《海滩救护队》。

---

### [01:17:22] Jen Abel

**English:**
Yeah. Baywatch channel. It's just so Numby, and it's like '90s classic. Baywatch.

**中文翻译:**
是的。Baywatch 频道。它能让人放松大脑，是 90 年代的经典。

---

### [01:17:30] Lenny Rachitsky

**English:**
Wow, I've never heard that one before. So this is original Baywatch with?

**中文翻译:**
哇，我还是第一次听到这个答案。所以是原版的《海滩救护队》，主演是……？

---

### [01:17:34] Jen Abel

**English:**
This is original Hasselhoff. David Hasselhoff.

**中文翻译:**
是原版的 Hasselhoff，David Hasselhoff。

---

### [01:17:37] Lenny Rachitsky

**English:**
Yeah, Pamela Anderson.

**中文翻译:**
是的，还有 Pamela Anderson。

---

### [01:17:39] Jen Abel

**English:**
Yasmine Bleeth. Pamela Anderson, the original cast.

**中文翻译:**
Yasmine Bleeth，Pamela Anderson，原班人马。

---

### [01:17:41] Lenny Rachitsky

**English:**
Amazing.

**中文翻译:**
太经典了。

---

### [01:17:41] Jen Abel

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:17:42] Lenny Rachitsky

**English:**
Okay. Deep cut. Is there a product you recently discovered that you really love?

**中文翻译:**
好的。一个冷门答案。最近有没有你发现并非常喜欢的产品？

---

### [01:17:47] Jen Abel

**English:**
So the number one thing for me right now is an app called Playground, which is the pictures of my toddler that they upload into the preschool so I can get the daily updates on what's going on in preschool when he's not home.

**中文翻译:**
对我来说，现在最重要的是一个叫 Playground 的应用。幼儿园会把我家小孩的照片上传到上面，这样当他不在家时，我也能了解他在幼儿园的日常动态。

---

### [01:18:03] Lenny Rachitsky

**English:**
Amazing. I need that. We get emails and Google Photos. I would really love that.

**中文翻译:**
太棒了。我也需要这个。我们现在只收到邮件和 Google Photos。我很想要这种应用。

---

### [01:18:09] Jen Abel

**English:**
Yeah, there was another one called ClassDojo. There's a few of them, but Playground is the one that this preschool's on.

**中文翻译:**
是的，还有一个叫 ClassDojo。这类应用有几个，但这家幼儿园用的是 Playground。

---

### [01:18:15] Lenny Rachitsky

**English:**
Love ClassDojo. I'm a small investor.

**中文翻译:**
我喜欢 ClassDojo。我是它的小股东。

---

### [01:18:17] Jen Abel

**English:**
Are you really?

**中文翻译:**
真的吗？

---

### [01:18:18] Lenny Rachitsky

**English:**
I am.

**中文翻译:**
是的。

---

### [01:18:18] Jen Abel

**English:**
Oh, that's awesome.

**中文翻译:**
噢，那太棒了。

---

### [01:18:19] Lenny Rachitsky

**English:**
How about that? Two more questions. Do you have a favorite life motto that you find yourself coming back to find useful in work or in life?

**中文翻译:**
巧了。最后两个问题。你有没有最喜欢的人生格言，觉得在工作或生活中非常受用？

---

### [01:18:26] Jen Abel

**English:**
Yeah, be direct. Cut the fluff. Give me the bullet, not the paragraph.

**中文翻译:**
有的：保持直接。废话少说。给我要点，不要长篇大论。

---

### [01:18:34] Lenny Rachitsky

**English:**
Final question. I was told that by Justin that you've never read a sales book. You've just learned to do this. If you were to read a sales book, if there was someone else out there that you look up to, learn from, is there anyone else out there in the world of sales that you most respect?

**中文翻译:**
最后一个问题。Justin 告诉我你从未读过销售书籍，你完全是自学成才。如果你要读一本销售书，或者如果你有仰慕和学习的对象，在销售领域你最尊敬谁？

---

### [01:18:51] Jen Abel

**English:**
I think Jason Lemkin has the strongest understanding of sales. His content is unbelievable. He speaks about it clearly and cleanly, I would say. And as I mentioned, unbelievable Twitter follow. I'm a big fan of his.

**中文翻译:**
我认为 Jason Lemkin 对销售的理解最深刻。他的内容简直不可思议。我会说，他讲得很透彻、很干练。正如我提到的，他是必关注的 Twitter 账号。我是他的超级粉丝。

---

### [01:18:51] Lenny Rachitsky

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [01:19:06] Jen Abel

**English:**
I've actually learned a lot from him too. The 50/50 thing or a higher two salespeople, he's spot on. Failure rate is actually probably higher than 50%.

**中文翻译:**
我实际上也从他那里学到了很多。关于 50/50 的薪酬结构，或者招两个销售人员，他的观点非常精准。失败率实际上可能高于 50%。

---

### [01:19:15] Lenny Rachitsky

**English:**
I love that guy. And he's so AI-forward these days. He's just building. He almost took down Replit with his complaints. It was a whole new cycle of how Replit-

**中文翻译:**
我喜欢那家伙。他现在非常推崇 AI。他一直在构建。他之前的投诉差点让 Replit 翻车，那引发了一场关于 Replit 的大讨论……

---

### [01:19:24] Jen Abel

**English:**
He should interact. Sometimes he says things that are harsh, but you're like, "He's not wrong."

**中文翻译:**
他应该多互动。有时他说的话很刻薄，但你会觉得：“他没说错。”

---

### [01:19:31] Lenny Rachitsky

**English:**
Love it. I got to get him back on the podcast.

**中文翻译:**
没错。我得再请他来播客。

---

### [01:19:33] Jen Abel

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:19:33] Lenny Rachitsky

**English:**
Jen, this was incredible. This was everything I wanted to be. I feel like we just leveled up all the founders that have listened to this in their ability to close. We're going to just create all the economic value and a lot of happy VCs from all the sales that will be closed as a result of the advice you shared. Two final questions. Where can folks find you if they want to either work with you or follow you online? And how can listeners be useful to you?

**中文翻译:**
Jen，这太精彩了。这正是我想要的效果。我觉得我们刚刚提升了所有听众创始人的成交能力。由于你分享的建议，我们将创造巨大的经济价值，并让很多风投感到开心。最后两个问题：如果人们想和你合作或在线关注你，去哪里找你？听众能为你做些什么？

---

### [01:19:54] Jen Abel

**English:**
Twitter. Every new learning or mishap, I put red on Twitter, so it's like my personal diary and super responsive on Twitter DM.

**中文翻译:**
Twitter。每一个新的心得或失误，我都会发在 Twitter 上，就像我的个人日记。我在 Twitter 私信上回复非常快。

---

### [01:20:06] Lenny Rachitsky

**English:**
What's your Twitter handle? Twitter handle.

**中文翻译:**
你的 Twitter 账号是什么？

---

### [01:20:08] Jen Abel

**English:**
It's double J, So J-J-E-N_A-B-E-L.

**中文翻译:**
是两个 J，即 J-J-E-N_A-B-E-L。

---

### [01:20:15] Lenny Rachitsky

**English:**
You did not make that easy for people to find you, but we-

**中文翻译:**
你这名字可不太好找，但我们会……

---

### [01:20:17] Jen Abel

**English:**
Yeah, I know, I know, I know I didn't.

**中文翻译:**
是的，我知道，我知道。

---

### [01:20:20] Lenny Rachitsky

**English:**
And the J is for JJELLYFISH, is that where the extra J is for?

**中文翻译:**
那个 J 是代表 JJELLYFISH 吗？多出来的那个 J 是这个意思吗？

---

### [01:20:23] Jen Abel

**English:**
Yeah, the double Js. Then also, well, someone else had the handle, so I was like, "I need my name."

**中文翻译:**
是的，双 J。而且，因为别人已经占用了那个账号，我想我得把名字加进去。

---

### [01:20:26] Lenny Rachitsky

**English:**
Got it. By the way, just tell people what JJELLYFISH is in case that might be helpful to them.

**中文翻译:**
明白了。顺便告诉大家 JJELLYFISH 是做什么的，也许对他们有帮助。

---

### [01:20:30] Jen Abel

**English:**
Yeah, so it's a consultancy that helps folks in the zero to one stage, and now I'm at general manager of enterprise at State Affairs, which is basically giving citizens and corporations an inside peek into what's actually going on inside the state capitol building. State policy is way more impact than on you, than federal policy. Federal policy is written more about.

**中文翻译:**
好的，它是一家帮助人们度过 0 到 1 阶段的咨询公司。现在我是 State Affairs 的大客户总经理，这基本上是让公民和企业能够深入了解州议会大厦内部的真实情况。州政策对你的影响远比联邦政策大，尽管联邦政策被报道得更多。

---

### [01:20:54] Lenny Rachitsky

**English:**
Incredible. I only recently learned that that's what you're doing these days, and that is super impactful and important, so thank you for your work there.

**中文翻译:**
太棒了。我最近才了解到你现在在做这个，这非常有影响力且重要，感谢你所做的工作。

---

### [01:21:02] Jen Abel

**English:**
Even democracy.

**中文翻译:**
甚至关乎民主。

---

### [01:21:04] Lenny Rachitsky

**English:**
No big deal. Jen, thank you so much for being here.

**中文翻译:**
这可不是小事。Jen，非常感谢你能来。

---

### [01:21:06] Jen Abel

**English:**
Thank you so much, Lenny. This was a blast.

**中文翻译:**
非常感谢，Lenny。聊得很开心。

---

### [01:21:08] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。