# Jen Abel - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Jen Abel.

---

### [00:00:00] Lenny Rachitsky

**English:**
I've always wanted to create a very tactical episode on how to do sales, especially with a focus on founder led sales.

**中文翻译:**
我一直想做一期实战性很强的节目，专门聊聊如何做销售，特别是聚焦于“创始人主导的销售”（founder led sales）。

---

### [00:00:06] Jen Abel

**English:**
A lot of early stage founders get tripped up as they're taking late stage sales advice. The founder is the product. You have studied. You have experienced something that most of the market hasn't even had a chance to maybe see or visualize yet.

**中文翻译:**
很多早期创始人会被误导，因为他们采纳的是后期阶段的销售建议。在早期，创始人本身就是产品。你深入研究过，你经历过一些市场上大多数人甚至还没机会看到或想象到的东西。

---

### [00:00:19] Lenny Rachitsky

**English:**
A billion SaaS tools emailing me constantly about their product. How do you get someone to even want to talk to you and be open to learning about what you're doing?

**中文翻译:**
有成千上万的 SaaS 工具不断给我发邮件推销他们的产品。你该如何让别人产生想和你聊聊的欲望，并愿意了解你正在做的事情呢？

---

### [00:00:25] Jen Abel

**English:**
So if you can focus the messaging in a way that speaks to something that is a bit of shock value or is counterintuitive, you'll get them to continue reading. When a problem is truly being felt by the market, people will get on a call, people will respond.

**中文翻译:**
所以，如果你能把信息聚焦在一些具有“冲击力”或“反直觉”的内容上，你就能吸引他们读下去。当一个问题真正被市场感知到时，人们会愿意接电话，也会做出回应。

---

### [00:00:39] Lenny Rachitsky

**English:**
The next step I imagine is you're on the phone with them trying to convince them to actually care. What do you do there? How do you get them to engage further?

**中文翻译:**
我猜下一步就是和他们通电话，试图说服他们真正关注这件事。在那一步你会怎么做？如何让他们进一步参与进来？

---

### [00:00:45] Jen Abel

**English:**
You need to be vulnerable. I would be very open and honest with where you are. Hey, I'm an early stage startup. We have a lot to learn. Can we kind of gain your insight into how this problem is manifesting on your side? Founder led sales is not about revenue on day one. It is about learning as fast as humanly possible to get to that pulse, so that you can earn the right to sell.

**中文翻译:**
你需要展现出真实、甚至有点“示弱”的一面。我会非常坦诚地说明现状：“嘿，我们是一家早期创业公司，还有很多东西要学。我们能不能听听您的见解，看看这个问题在您那边是如何表现的？”创始人主导的销售在第一天并不是为了收入，而是为了尽可能快地学习，摸准市场的脉搏，从而赢得销售的权利。

---

### [00:01:12] Lenny Rachitsky

**English:**
Today my guest is Jen Abel. Jen is the co-founder of Jellyfish, where her and her team help early stage founders learn how to sell, do early customer discovery, and set up a repeatable sales motion. Prior to Jellyfish, Jen was an enterprise sales director at the Muse and a general assembly, and she's obsessed with helping founders in the zero to one stage of their journey. In our conversation, we get extremely tactical and in the weeds on how to actually do sales as a founder. We talk through each step of the sales process, and Jen shares what you should be doing and saying at every step. We go through how to find your first set of leads, how to reach out to them, what to say in your message, how to structure your first sales call, how to get through procurement, and how to get that final signature.

**中文翻译:**
今天的嘉宾是 Jen Abel。Jen 是 Jellyfish 的联合创始人，她和她的团队帮助早期创始人学习如何销售、进行早期客户探索，并建立可复制的销售流程（sales motion）。在创立 Jellyfish 之前，Jen 曾在 The Muse 和 General Assembly 担任企业销售总监，她热衷于帮助处于“从0到1”阶段的创始人。在我们的对话中，我们将深入探讨创始人如何实际开展销售的战术细节。我们会梳理销售流程的每一步，Jen 会分享你在每一步应该做些什么、说些什么。我们会讨论如何找到第一批潜在客户、如何联系他们、信息里该写什么、如何组织第一次销售电话、如何通过采购流程，以及如何拿到最终签字。

---

### [00:01:55] Lenny Rachitsky

**English:**
She shares actual words you should be using, and phrases and structures, and pitfalls that most people run into at each of these steps. I've never heard a podcast episode with this much advice that you can put into practice tomorrow, and I am very excited to hear how it goes for you. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. With that, I bring you Jen Abel.

**中文翻译:**
她分享了你应该使用的具体措辞、短语和结构，以及大多数人在这些步骤中会遇到的坑。我从未听过哪期播客能提供这么多明天就能付诸实践的建议，我非常期待听到大家尝试后的反馈。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对我们帮助巨大。下面，让我们欢迎 Jen Abel。

---

### [00:02:24] Lenny Rachitsky

**English:**
Jen, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Jen，非常感谢你能来。欢迎来到本播客。

---

### [00:02:27] Jen Abel

**English:**
Thanks, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### [00:02:28] Lenny Rachitsky

**English:**
What I've always wanted to do is to create a very tactical episode on how to do sales, like how to actually have sales conversations, how to find leads, how to close deals. Especially with a focus on founder led sales, where founders are doing the early sales versus hiring salesperson. Which one, I know you're a huge advocate of and we'll talk about this. And two, you basically spent all your time working with founders and founding teams, helping them learn how to do sales, how to set up their go-to-market motions, how to scale teams, sales teams, how to hire sales people. So I'm very excited to have you here to create a very in the weeds, hands-on episode on how to do sales. How does that sound broadly?

**中文翻译:**
我一直想做一期实战性极强的节目，聊聊怎么做销售——比如如何进行销售对话、如何寻找潜在客户、如何达成交易。特别是侧重于“创始人主导的销售”，即由创始人亲自做早期销售，而不是雇佣销售人员。我知道你非常推崇这一点，我们待会会细聊。其次，你几乎把所有时间都花在与创始人和创始团队合作上，帮助他们学习销售、建立进入市场（GTM）的策略、扩大销售团队以及招聘销售人员。所以我非常激动能请你来，做一期深入细节、手把手教大家如何做销售的节目。听起来怎么样？

---

### [00:03:07] Jen Abel

**English:**
That sounds awesome, and thank you so much for having me, Lenny. I mean, it's a true pleasure to be here with you.

**中文翻译:**
听起来太棒了，非常感谢你邀请我，Lenny。能和你在一起交流真是我的荣幸。

---

### [00:03:12] Lenny Rachitsky

**English:**
It's my pleasure. Many people have recommended you come on this podcast. I'm excited we're doing this. Let me start with just this kind of question, our founder led sales. Maybe just briefly explain what that term means and then talk about why this is so important, why this is the way you recommend companies start doing sales?

**中文翻译:**
这是我的荣幸。很多人都推荐你来。我很兴奋我们能聊这个。让我先从这个问题开始：什么是“创始人主导的销售”？能不能简单解释一下这个词的含义，然后谈谈为什么它如此重要，为什么你推荐公司以这种方式开始销售？

---

### [00:03:29] Jen Abel

**English:**
Founder led sales is really that first milestone that a startup goes through on the commercial side, which is, how do I go out and get my first few customers? Some people might say zero to one, which is, how do I get my first million? Others might say, how do I go out and get my first 10 customers? It's all kind of in the same vein. And founder led sales is really, really, really important because in the very, very, very early days, when there is no brand equity, when there is no marketing engine running, when there is limited to no reference ability, the founder is the product, right? Because the product is still, could be abstract, could be an MVP or in it's really early formation. So the founder is the product. When people say, well, what does that even mean? It means that you are a subject matter expert on something highly specific.

**中文翻译:**
“创始人主导的销售”实际上是初创公司在商业化道路上经历的第一个里程碑，即：我该如何出去获得前几个客户？有人可能会说是“从0到1”，即如何赚到第一个100万；也有人会说，如何获得前10个客户。本质上都是一回事。创始人主导的销售非常、非常、非常重要，因为在极早期，没有品牌资产，没有市场引擎，几乎没有可参考的案例，创始人就是产品，对吧？因为产品可能还很抽象，可能只是个 MVP（最小可行性产品），或者处于非常早期的形态。所以创始人就是产品。当人们问“这到底是什么意思”时，它的意思是：你是某个非常具体领域的专家。

---

### [00:04:23] Jen Abel

**English:**
(00:04:23):
You have studied, you have experienced something that most of the market hasn't even had a chance to maybe see or visualize yet. So you have this novel insight that you are building a business around. And it's that novel insight and the way you see the world that gets the market excited, in absence of a product. And that's actually happens even before you even show the product. So founder led sales is how do you bring the founders vision into the world and have the market, and understand what part of the market accepts it, and then what part of that vision are they accepting? So it's aligning the founders vision with the market reality.

**中文翻译:**
你研究过、经历过一些市场上大多数人甚至还没机会看到或具象化的东西。所以你拥有这种新颖的洞察，并围绕它建立业务。正是这种新颖的洞察和你观察世界的方式，在没有产品的情况下让市场感到兴奋。这甚至发生在你展示产品之前。所以，创始人主导的销售就是如何将创始人的愿景带入世界，并让市场去理解，搞清楚市场的哪一部分接受它，以及他们接受的是愿景的哪一部分。所以，它是将创始人的愿景与市场现实对齐的过程。

---

### [00:05:01] Lenny Rachitsky

**English:**
This episode is brought to you by Brave Search... [Ad Content]

**中文翻译:**
本期节目由 Brave Search 赞助……（广告内容略）

---

### [00:05:58] Lenny Rachitsky

**English:**
This episode is brought to you by Vanta... [Ad Content]

**中文翻译:**
本期节目由 Vanta 赞助……（广告内容略）

---

### [00:06:50] Lenny Rachitsky

**English:**
And this is counter to what many founders hope is, I'm just going to hire a salesperson, they'll handle sales. I'll build the thing, I'll wait for them to find deals. And this is like a lot of people think this way. And founder led sales is the movement of just like, no, no, you should be doing the sales for a long time as a founder.

**中文翻译:**
这与许多创始人的期望背道而驰，他们想的是：“我就雇个销售，让他们去搞定。我负责做产品，等着他们找订单。”很多人都是这么想的。而“创始人主导的销售”这一运动的核心是：不，不，作为创始人，你应该在很长一段时间内亲自做销售。

---

### [00:07:06] Jen Abel

**English:**
Absolutely. I mean, it is the competitive advantage. I don't think people realize how much of a competitive advantage the founder led sales motion is, for three specific reasons. One is that the founder is the visionary. No one's going to be able to speak to it like they can. No salesperson, really no non-founder. The second is that they are the highest order in the hierarchy of the startup. It's the founder. So the market is excited to talk to a founder because they usually know something that the market doesn't know. And they want to learn and maybe they want to experience something differently. So being able to speak to the person that's running the vision, speak to the person that's crafted the vision.

**中文翻译:**
绝对是这样。我的意思是，这本身就是一种竞争优势。我认为人们没有意识到创始人主导的销售模式有多大的竞争优势，具体有三个原因。第一，创始人是愿景的制定者。没有人能像他们那样把愿景讲透，任何销售人员，甚至任何非创始人都做不到。第二，他们在初创公司的层级中处于最高位置。市场很兴奋能与创始人交谈，因为创始人通常知道一些市场不知道的东西。他们想学习，也许想体验一些不同的东西。所以，能够直接与运营愿景、亲手打造愿景的人对话是非常有吸引力的。

---

### [00:07:50] Jen Abel

**English:**
And then that third piece is that the founder can see something budding in a conversation that a salesperson won't be able to see. And it's those budding moments that's where all the gold lives. And I don't think a lot of founders realize that. Their day one market vision is never the same vision that takes them in a product market fit. And I say that all the time. It's these little budding moments where it's like I was able to get to that budding insight because I went deeper and deeper and deeper and deeper through these calls and these conversations, to fully refine how we want to go out and sell it. And only a founder is going to be able to see those things.

**中文翻译:**
第三点是，创始人能在对话中察觉到一些销售人员察觉不到的“萌芽”迹象。而这些萌芽时刻正是“金矿”所在。我觉得很多创始人没意识到这一点。他们第一天的市场愿景永远不会是最终带他们走向“产品市场契合”（PMF）的那个愿景。我经常这么说。正是通过这些电话和对话，不断深入、深入、再深入，才能捕捉到那些萌芽中的洞察，从而完全完善我们的销售方式。只有创始人才能敏锐地捕捉到这些东西。

---

### [00:08:26] Lenny Rachitsky

**English:**
I love this because this connects really well with an episode I just did with the CMO of Wiz. And the founders went through this exactly. They had 10 to 15 conversations a day for weeks, and then they're like realizing people keep telling us they like it, but no one's buying, no one's excited enough to want to actually move forward. And that was only happening because the founders were on these calls.

**中文翻译:**
我非常喜欢这一点，因为它和我最近采访 Wiz 的 CMO 那期节目联系得很好。那些创始人正是经历了这些。他们连续几周每天进行 10 到 15 场对话，然后意识到：人们一直在说他们喜欢这个产品，但没人买，没人兴奋到想真正推进。只有因为创始人亲自参与了这些通话，他们才能发现这一点。

---

### [00:08:49] Jen Abel

**English:**
Yeah, I mean, the other thing too is that it becomes a game of telephone. It's like, hey, this salesperson says that no cares about this. What do you think the first thing the founder's going to say is? It's the salesperson. So much easier to say that than, is it me? Is it my vision? So it also kind of brings the accountability closer to the pulse where decisions are made.

**中文翻译:**
没错。而且，如果不是亲自做，就会变成“传声筒游戏”。比如，销售员说没人关心这个。你觉得创始人第一反应会说什么？他会觉得是销售员的问题。承认销售员不行，比承认“是我不行吗？是我的愿景有问题吗？”要容易得多。所以，亲自销售也能让责任归属更接近决策的核心。

---

### [00:09:10] Lenny Rachitsky

**English:**
It's interesting how similar this is to product building, where there's this idea that a founder top down can tell the team what to build, and it's this very waterfall cycle. When in reality the idea of the product and feature is just like step one, and then there's actually building it, testing it, talking to customers about it, that actually turns that initial seed of an idea to the real thing that people will want.

**中文翻译:**
这和做产品非常相似，很有趣。有一种观念认为创始人可以自上而下地告诉团队要做什么，这是一种非常“瀑布式”的循环。但现实中，产品和功能的想法只是第一步，接下来的构建、测试、与客户交流，才真正将最初的想法种子转化为人们真正想要的东西。

---

### [00:09:34] Lenny Rachitsky

**English:**
Okay. So the catch 22, I don't know if that's the term here. The challenge is, okay, so great, founders should be doing sales. Most founders have never done sales. They just want to build product. They're mostly product people, design people. Sometimes there's founders that are salespeople. Rarely is that the case in my experience. So doing sales is very hard, not something that comes naturally to a lot of people. A lot of people are very afraid of it. So with that, let's get into how to actually get better at the sales process. I think a nice framework for how we can go through this is basically first let's talk about the sales cycle, the steps, the key steps of a sales cycle. And then we'll just go through each step and help people learn some tactics to get through each of those conversations.

**中文翻译:**
好。那么现在的困境是（我不确定这算不算“第22条军规”）：创始人应该做销售，但大多数创始人从未做过销售。他们只想做产品，大多是产品背景或设计背景。虽然也有销售背景的创始人，但在我的经验中很少见。所以做销售很难，对很多人来说不是天生的技能，甚至很多人对此感到恐惧。既然如此，让我们进入正题，看看如何提高销售流程。我想一个好的框架是：首先讨论销售周期（sales cycle）的关键步骤，然后我们逐一讲解每一步，帮助大家学习应对这些对话的战术。

---

### [00:10:22] Lenny Rachitsky

**English:**
Okay. Yeah. Cool. So what's the simplest way to think about the steps of a sales cycle?

**中文翻译:**
好的，太棒了。那么，理解销售周期步骤最简单的方式是什么？

---

### [00:10:26] Jen Abel

**English:**
The traditional sales stages that most CRMs are even set up as is you have your intro call. You have your second call, which sometimes could be the demo depending on the stage of market you're selling to. Then you have your third call, which is going to be more about walking through a proposal, a scope of work, maybe going deeper into the demo to contextualize it to everything you've learned. The fourth call is going to be getting their feedback and kind of co-authoring that scope of work even further. The fifth call is going to be around probably an introduction to procurement. And then selling into procurement in itself, it's its own little sales cycle, but we could talk about that in a sec. And then post-procurement, it's going to be obviously getting that signature and knowing who the actual signatory is. Sometimes it's not even the business unit, it's sometimes legal, CFO, procurement themselves. So just understanding who that is.

**中文翻译:**
大多数 CRM 系统设置的传统销售阶段是：首先是介绍性通话（intro call）。然后是第二次通话，根据你所销售的市场阶段，这通常是演示（demo）。第三次通话更多是关于过一遍提案（proposal）和工作范围（scope of work），可能会深入演示，根据你学到的信息进行情境化。第四次通话是获取反馈，并进一步“共同撰写”工作范围。第五次通话通常是引荐给采购部门（procurement）。向采购部门销售本身就是一个小的销售周期，我们待会可以聊聊。采购之后，显然就是获取签字，并搞清楚真正的签字人是谁。有时甚至不是业务部门，而是法务、CFO 或采购部门本身。所以要搞清楚那是谁。

---

### [00:11:39] Lenny Rachitsky

**English:**
Okay, great. So let's walk through each of these steps. So I love that each call has its traditional goal, demo, proposal, then co-authoring, and then procurement, and then post-procurement. I love how consistent everybody is.

**中文翻译:**
太好了。那我们来逐一过一遍。我喜欢这种设定，每次通话都有传统的目标：演示、提案、共同撰写、采购，然后是采购后的流程。大家的操作竟然如此一致。

---

### [00:11:39] Jen Abel

**English:**
Yeah, well, it's also, it's interesting because it's also predicated on their buying process as well. So if they're really used to buying, if they're very mature in their buying process, they actually might guide you to what the steps are. But most startups are turning non-consumers into consumers. So that's why this kind of fits well.

**中文翻译:**
是的，这很有趣，因为它也取决于对方的购买流程。如果他们非常习惯购买，购买流程非常成熟，他们甚至会引导你走这些步骤。但大多数初创公司是在把“非消费者”变成“消费者”，所以这种流程非常适用。

---

### [00:12:00] Lenny Rachitsky

**English:**
Got it. So there's this intra call step. So kind starting about where it begins. I think where a lot of people struggle most is getting anyone to even pay attention. You don't want to talk to them. A billion SaaS tools emailing me constantly about their product. So maybe we start there of just like how do you get someone to even want to talk to you and be open to learning about what you're doing?

**中文翻译:**
明白了。那么首先是介绍性通话这一步。让我们从源头开始。我觉得很多人最挣扎的地方在于如何让人注意到你。别人根本不想理你。有无数的 SaaS 工具不停地给我发邮件推销。所以我们从这里开始：你如何让别人产生想和你聊聊的欲望，并愿意了解你在做什么？

---

### [00:12:19] Jen Abel

**English:**
Yeah. And this is why that founder led sales piece is so important. One is when it's coming from the founder, it's an entirely different weight. You're like, oh, interesting. This founder is reaching out to me. Okay, I'm going to seek to go a layer deeper, knowing who is sending me this note. The second piece is this is why that novel insight, that technical insight, that business model insight that you've uncovered needs to lead here. People are inspired by a new way of thinking, usually something counterintuitive, something that's really different. I really try and stay away from better, because that's really hard to define, and better means something different to everyone. So if you can focus the messaging in a way that speaks to something that has a bit of shock value, or is counterintuitive, you'll get them to continue reading. So first and foremost, I usually like to open it with, which is why is this relevant for me in my role?

**中文翻译:**
是的。这就是为什么“创始人主导的销售”如此重要。第一，当信息来自创始人时，分量完全不同。你会觉得：“哦，有趣，这位创始人亲自联系我。”知道发件人的身份后，你会愿意多看一眼。第二，这就是为什么你发现的新颖洞察、技术洞察或商业模式洞察必须放在首位。人们会被新的思维方式所启发，通常是反直觉的、非常不同的东西。我尽量避免使用“更好”（better）这个词，因为“更好”很难定义，而且对每个人意义不同。所以，如果你能把信息聚焦在一些有冲击力或反直觉的内容上，他们就会继续读下去。首先，我通常喜欢以“为什么这与我的职位相关”作为开场。

---

### [00:13:20] Jen Abel

**English:**
Why are you reaching out to me? So first and foremost is relevancy. I think that matters even more so than personalization right now. I think it's so easy to personalize anything, and it can also come across as really stressed when you're like, hey, I noticed you were on such and such podcast, and that was when they were previously two roles behind. So I always say relevancy. If you can get to relevancy, that's the most important piece. The second most important piece is really getting to that level of differentiation or counterintuitive nature. So say something that would literally make them say what? Or that makes no sense. Maybe not that makes no sense, but what or how could that be? Or I've never thought about it that way. Or I actually don't fully understand what they're saying, but there's something there that's interesting. Get them to pause for a minute.

**中文翻译:**
你为什么要联系我？所以，首要的是“相关性”（relevancy）。我认为现在相关性比“个性化”更重要。现在个性化任何东西都太容易了，而且有时会显得很刻意，比如你说：“嘿，我注意到你参加了某某播客”，结果那是人家两个职位之前的事了。所以我总是强调相关性。如果你能做到相关，那是最重要的。第二重要的是体现出差异化或反直觉的特质。说一些能让他们惊呼“什么？”或者“这不合逻辑”的话。也许不是真的不合逻辑，而是“怎么会这样？”或者“我从未那样想过”，或者“我其实没太听懂他在说什么，但感觉很有趣”。要让他们停下来思考一分钟。

---

### [00:14:13] Jen Abel

**English:**
And the most important piece is getting this done where, if they get it on their mobile phone, which everyone is looking at their mobile phone and on email, they don't have to scroll. So usually three to four sentences max. That also, that's how a founder writes. That's how an executive writes if you're selling top down. But most importantly, leave them wanting more. Don't say everything, don't even talk about the solution. Talk about the problem that you want to solve, and why it needs to be solved or why it's not good enough today. So those are the four main components. Just to reiterate, relevancy, bring some level of counterintuitive or really different approach to the conversation, focusing in on a problem that's predicated to them, and really concise.

**中文翻译:**
最关键的一点是，要确保如果他们在手机上查看（大家现在都在手机上看邮件），不需要滚动屏幕。所以通常最多三到四句话。这也是创始人的写作风格，也是如果你自上而下销售时高管的写作风格。但最重要的是，要“吊胃口”。不要把所有事情都说完，甚至不要谈论解决方案。谈论你想解决的问题，以及为什么它需要被解决，或者为什么现状还不够好。这就是四个核心要素。重申一下：相关性、带来反直觉或截然不同的视角、聚焦于与他们相关的问题、以及非常简洁。

---

### [00:14:59] Lenny Rachitsky

**English:**
I love this. Is there an example you could share that helps make this even more real? Maybe an email you helped with. And by the way, this is email and LinkedIn, I imagine is where you're communicating mostly?

**中文翻译:**
太棒了。有没有什么例子可以让这更具体一点？也许是你帮别人改过的一封邮件。顺便问一下，你们主要是在邮件和 LinkedIn 上沟通吗？

---

### [00:15:11] Jen Abel

**English:**
LinkedIn, email, you would be shocked to hear this, but cold calling. I never used to do this. It is one of the most... The interest rates on cold calling are a lot higher than email in many cases.

**中文翻译:**
LinkedIn、邮件，你可能会感到惊讶，还有“冷启动电话”（cold calling）。我以前从不这么做，但它是最有效的手段之一。在很多情况下，冷启动电话的意向率比邮件高得多。

---

### [00:15:26] Lenny Rachitsky

**English:**
So it's calling, email, cold email and LinkedIn DMs, is that the three channels generally?

**中文翻译:**
所以通常是电话、冷邮件和 LinkedIn 私信，这三个渠道对吧？

---

### [00:15:31] Jen Abel

**English:**
Yep, those are the three, yeah, the main ones.

**中文翻译:**
是的，就是这三个主要的。

---

### [00:15:33] Lenny Rachitsky

**English:**
Cool. Yeah. Is there an example? It doesn't have to be word for word which you've done or people done, but just how do you... Yeah.

**中文翻译:**
好。有没有例子？不需要逐字逐句，只要大概意思就行。

---

### [00:15:38] Jen Abel

**English:**
Actually our first three years were built on cold email before we actually had clients, before we got word of mouth from the founders we worked with, I cold emailed the first 20 customers we had at Jellyfish. And the line I used in there was zero to one sales talent doesn't exist. That's why I want to have a conversation with you. So that was kind of that leading, wait, what? What does that even mean? And what I would do is tie that to them in some respects. If they recently raised the seed or series A, where they are in that journey. But I would lead with that and then tie it into like, hey, I noticed you're looking to target X, Y, and Z based off of what your website. I'd love to have a conversation with you.

**中文翻译:**
事实上，在我们真正拥有客户、获得口碑之前，Jellyfish 的前三年是建立在冷邮件基础上的。我通过冷邮件获得了前 20 个客户。我当时用的一句话是：“‘从0到1’的销售人才根本不存在。这就是我想和你聊聊的原因。”这句话起到了引导作用，让人觉得：“等等，什么？这到底是什么意思？”然后我会把这句话在某些方面与他们联系起来。如果他们最近刚融了种子轮或 A 轮，我会结合他们的阶段。我会以那句话开场，然后联系到：“嘿，我注意到根据你们的网站，你们正打算针对 X、Y、Z 市场。我很想和你们聊聊。”

---

### [00:16:25] Lenny Rachitsky

**English:**
And that first piece is the relevance. Here's why this is relevant to you.

**中文翻译:**
所以第一部分就是相关性。说明为什么这和你有关。

---

### [00:16:28] Jen Abel

**English:**
Yeah. And then I say, our belief at Jellyfish is zero to one sales talent doesn't exist. That's why we built this model.

**中文翻译:**
是的。然后我会说：“我们在 Jellyfish 的信念是，‘从0到1’的销售人才不存在。这就是我们建立这个模型的原因。”

---

### [00:16:34] Lenny Rachitsky

**English:**
Awesome. And you kept it really short. So it's relevance, counterintuitive, keep it really short. And then what was the fourth piece?

**中文翻译:**
太棒了。而且你保持得很短。所以是：相关性、反直觉、保持简短。那第四点是什么来着？

---

### [00:16:42] Jen Abel

**English:**
The fourth piece is just make sure it's concise so that you don't have to scroll on mobile phone.

**中文翻译:**
第四点就是确保简洁，这样在手机上就不用翻页。

---

### [00:16:47] Lenny Rachitsky

**English:**
While we're on this topic. What's a good conversion rate of these sorts of cold outreaches?

**中文翻译:**
顺便问一下，这类冷启动外展的理想转化率是多少？

---

### [00:16:51] Jen Abel

**English:**
Conversion rate is interesting. Because everyone's so focused on conversion rate. I get that in the beginning until you have some wins, you have to focus there. But I just want to reverse engineer it backwards a bit. Once you kind of have this, and I'll talk about it in a sec, which is win rate. Win rate is if I got Lenny on a phone call, and he went through the sales process, and I signed him up. And I spoke to 10 Lenny's and only Lenny R was the one that signed. That's one out of 10, that's a 10% win rate.

**中文翻译:**
转化率很有意思。因为每个人都盯着转化率。我理解在开始阶段，在你获得一些胜利之前，你必须关注它。但我稍微反向推导一下。一旦你有了这个——我待会会细说——就是“胜率”（win rate）。胜率是指，如果我让 Lenny 接了电话，他走完了销售流程，最后我签下了他。如果我跟 10 个像 Lenny 这样的人聊过，只有 Lenny R 签了约，那就是 10 分之 1，即 10% 的胜率。

---

### [00:17:23] Jen Abel

**English:**
So if you have a really high win rate, let's say 30 or 40%, you actually don't need as high of a conversion rate on the outbound, because you know if you get someone in the funnel, the throughput is very healthy. If your win rate is really low, you need that conversion rate to be much, much higher, because you need more and more and more at bats. So conversion rate is a funny thing. In the beginning I get it because you don't have a lot of customers going through the pipeline yet. But there's people focus on it in a little bit of a false sense because interest rate truly is also dictated by win rate. So I just want to specify that.

**中文翻译:**
所以，如果你有很高的胜率，比如 30% 或 40%，你其实不需要那么高的外展转化率，因为你知道只要有人进入漏斗，产出就会很稳。如果你的胜率很低，你就需要极高的转化率，因为你需要不断地获得“击球机会”。所以转化率是个微妙的东西。在初期我理解大家关注它，因为还没有很多客户进入管线。但有些人对它的关注有点片面，因为意向率（interest rate）实际上也受胜率的影响。我只是想说明这一点。

---

### [00:18:03] Lenny Rachitsky

**English:**
That's a really good point.

**中文翻译:**
非常有道理。

---

### [00:18:05] Jen Abel

**English:**
I would say if you're doing a win rate around 15 to 30% and you need to carry, oh I don't know, a million dollar quota. I would say a healthy conversion rate from outbound probably sits around, when it's mature, around five to 7%. Sometimes it could be two to 3%. Sometimes I've seen eight to 15% because it's coming from the founder, and they're solving a really heartfelt problem. So interest rate is also predicated on the problem that the founder has decided they want to solve for, and their insight on that problem.

**中文翻译:**
我会说，如果你的胜率在 15% 到 30% 左右，而你需要完成 100 万美元的业绩指标。那么成熟阶段的外展转化率大概在 5% 到 7% 左右比较健康。有时可能是 2% 到 3%。有时我也见过 8% 到 15% 的，因为信息来自创始人，而且他们正在解决一个非常痛点的问题。所以，意向率也取决于创始人决定解决的问题，以及他们对该问题的洞察。

---

### [00:18:51] Jen Abel

**English:**
And everyone wants to keep going back to, well, email rate is really low, email doesn't work anymore. LinkedIn, I'm not getting the connects I want. Yes, you can argue that the game has changed a little bit, but when a problem is truly being felt by the market, people will get on a call. People will respond. And if I can compare two engagements at a time that we're running, I see one where it's a 2% interested rate and then I'm seeing another one that's actually at 12% interested rate. And we're doing nothing different. The only thing that's different is the insight that the founder has on the market, which is a hard pill to swallow. And I know that's hard to hear too.

**中文翻译:**
大家总是抱怨：“邮件回复率太低了，邮件没用了。LinkedIn 没加到我想加的人。”是的，你可以辩称游戏规则变了，但当一个问题真正让市场感到痛苦时，人们会愿意接电话，会做出回应。如果我同时对比我们正在运行的两个项目，我看到一个意向率是 2%，另一个居然是 12%。我们的操作没有任何区别。唯一的区别就是创始人对市场的洞察力。这是一个很难让人接受的事实，我知道这听起来很扎心。

---

### [00:19:32] Lenny Rachitsky

**English:**
And those are two different companies selling different things?

**中文翻译:**
那是两家卖不同东西的不同公司吗？

---

### [00:19:34] Jen Abel

**English:**
Two different companies selling to two different markets, but they're not fundamentally drastically different markets.

**中文翻译:**
两家不同的公司，卖给两个不同的市场，但从根本上说，这两个市场并没有天差地别。

---

### [00:19:43] Lenny Rachitsky

**English:**
Got it. But one's basically got more product market fit essentially?

**中文翻译:**
明白了。本质上是其中一家更符合“产品市场契合度”？

---

### [00:19:46] Jen Abel

**English:**
That's exactly right. So everyone always comes back to we have the sales problem, we have the sales problem, we have an outbound problem. And yes, there could be some technical things going on that you need to look at. Maybe you leveraged clay and you blasted a thousand people and now your domain health has been impacted. But the vast majority of the time, maybe you're just not saying anything interesting at all. Maybe the problem you're looking to solve just isn't widely felt. Maybe the perspective you have needs another level of refinement because you're just not getting those bites.

**中文翻译:**
完全正确。所以大家总是回过头来说：“我们有销售问题，我们有外展问题。”是的，可能确实有一些技术问题需要检查。也许你用了 Clay（自动化工具）群发了一千人，结果你的域名信誉受损了。但绝大多数时候，可能只是因为你说的内容一点意思都没有。也许你想解决的问题并没有被广泛感知。也许你的观点需要进一步提炼，因为你根本没能吸引到对方。

---

### [00:20:21] Lenny Rachitsky

**English:**
I feel like this question you just touched on is something a lot of founders are always wondering, is this product not the thing people want? Is it my sales skills? I guess I imagine this is a very difficult question to answer, especially quickly. I guess is there anything there that's more likely because of this, it means your product isn't something anyone's want, versus you're not doing a good job selling it?

**中文翻译:**
我觉得你刚才提到的这个问题是很多创始人一直在纠结的：是产品不是人们想要的？还是我的销售技巧不行？我想这很难回答，尤其是要快速给出答案。有没有什么迹象能表明，这更有可能是因为产品没人要，而不是因为你没卖好？

---

### [00:20:41] Jen Abel

**English:**
Remember that amazing chart you drew where it talked about the length of time it took? I think you picked the top 25 startups. Product market fit. Yeah, that amazing image that I think has been reshared more times than anything I've ever seen. It's interesting because if you look at, I was looking at this closely the other day. If you look at the top section where the time to product market fit is consolidated, and you go all the way down to the air tables and the figmas, which a long time to get to product market fit. If you think about the earlier ones, which were, it was like GitHub that had product market fit pretty quickly. The SOC 2 compliant company. Vanta.

**中文翻译:**
记得你画过的那张很棒的图表吗？关于达到 PMF 所需的时间。我想你选了前 25 家初创公司。是的，那张图被转发的次数比我见过的任何东西都多。很有趣，因为我前几天仔细研究了一下。如果你看顶部那些 PMF 时间非常短的公司，再看底部像 Airtable 和 Figma 这种花了很长时间才达到 PMF 的公司。如果你想想早期那些，比如 GitHub 很快就达到了 PMF，还有做 SOC 2 合规的公司 Vanta。

---

### [00:21:46] Jen Abel

**English:**
There's this thing in my head and I haven't fully validated it but I'm going to share it with you, which is did they start with the market problem first and then build the product? Because they knew who their market was right off the bat. Versus an air table and a figma that I think started with a technical insight and then were trying to find their market.

**中文翻译:**
我脑子里有个想法，还没完全验证，但我可以分享给你：那些快公司是不是先从市场问题开始，然后再做产品？因为他们从一开始就知道市场是谁。而像 Airtable 和 Figma，我认为是从技术洞察开始，然后试图寻找市场。

---

### [00:21:46] Lenny Rachitsky

**English:**
I think that's absolutely right. Vanta, the way they approached it, Christina, she was searching for a pain. She was obsessed with talking to everybody about a pain that they needed solved, and then she just built it in spreadsheets. So she started with the market very much so.

**中文翻译:**
我认为完全正确。Vanta 的做法就是这样，Christina 当时一直在寻找痛点。她痴迷于和所有人聊他们需要解决的痛苦，然后她直接用 Excel 表格做出了产品。所以她确实是非常典型地从市场开始的。

---

### [00:22:00] Jen Abel

**English:**
And I think product market fit when you start with the market first, it's accelerated. But I will say this, I think that it's also capped on the upside. Because you're starting with the market versus the air table and the figma, which started with the technical insight and has uncapped upside. But one is certainly riskier than the other. Starting with a product is a hell of a lot riskier. And this is where I come back to so many people will say, how did you get funding and not know who your market is? And it's like, because if they do find it, that's a really, really, really big win. Versus I think if you start with the market first, you could potentially get a good win but is it more capped?

**中文翻译:**
我认为当你从市场开始时，PMF 的进程会加速。但我得说，我认为它的上限可能也是受限的。因为你是从现有市场开始的，而像 Airtable 和 Figma 是从技术洞察开始，拥有无限的上限。但前者肯定比后者风险小。从产品（技术洞察）开始风险要大得多。这就回到了很多人会问的问题：“你怎么拿到了融资却不知道市场在哪？”答案是：因为如果他们真的找到了市场，那将是一个巨大的胜利。而如果你从市场开始，你可能会获得不错的成功，但上限是否更低呢？

---

### [00:22:47] Lenny Rachitsky

**English:**
Interesting.

**中文翻译:**
有意思。

---

### [00:22:48] Jen Abel

**English:**
I don't know, it's just a thought. I was staring at your grid for so long, I was like, there's something here. And I kept coming back to those were more like I kept breaking it down to market versus product.

**中文翻译:**
我不知道，只是个想法。我盯着你那张图看了好久，觉得里面大有文章。我一直把它归结为“市场导向”还是“产品导向”。

---

### [00:23:01] Lenny Rachitsky

**English:**
Yeah, I love this. I think there's definitely something there. There's also horizontal versus a very specific problem you're solving.

**中文翻译:**
是的，我喜欢这个观点。肯定有某种联系。还有“通用型工具”与“解决特定问题”的区别。

---

### [00:23:06] Jen Abel

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:23:07] Lenny Rachitsky

**English:**
Okay, so you mentioned clay and you kind of nerd sniped me there of just what tools do you find useful? And it makes me think about finding leads, which is kind of going backwards through the sales process, but it might be okay, so maybe let's spend time there. Just like what do you recommend to founders to find the good leads? Glengarry Glen Ross good leads.

**中文翻译:**
好，你刚才提到了 Clay，这勾起了我的好奇心。你觉得哪些工具好用？这让我想到了寻找潜在客户（leads），虽然这有点在销售流程里往回跳，但没关系。你推荐创始人如何寻找优质的潜在客户？就像《拜金一族》（Glengarry Glen Ross）里那种“黄金客户”。

---

### [00:23:28] Jen Abel

**English:**
So I say before you buy any tool, don't even think about tools. I feel like people turn everything into this complicated mess with all of the tools that they start integrating. And then they're engineers, I get it. So now they start to engineer these sales tools together and then they blast their market, and now they have 5,000 notes out in one day and their domain takes a hit. So I think before you even overthink about the tools right now, can you manually find 30 people that you want to spend 15 to 20 minutes writing a rock solid note to? Are there 30 people that you are deeply excited to learn from, that you are willing to invest 15 to 20 minutes to write a really thoughtful note? Let's just start there. So some questions. One, are they even discoverable? How hard is it to find 30 people?

**中文翻译:**
我会说，在买任何工具之前，先别想工具的事。我觉得人们总是把事情搞得很复杂，集成一堆工具。他们是工程师，我理解。于是他们开始把这些销售工具“工程化”，然后群发市场，一天发出去 5000 封邮件，结果域名被封了。所以，在过度思考工具之前，你能不能手动找到 30 个人，并愿意花 15 到 20 分钟给每个人写一封高质量的信？有没有 30 个让你非常渴望向其学习的人，让你愿意投入时间写一封深思熟虑的信？让我们从这里开始。先问几个问题：第一，他们能被找到吗？找 30 个人有多难？

---

### [00:24:21] Jen Abel

**English:**
What have you noticed across those 30 people? Are there any interesting insights? Maybe it's the size of the team they work on, maybe it's the industry they're in, maybe it's the length of time they've been in their role, maybe it's their previous roles in their career. Are there some commonalities? There's always some level of a commonality usually in most cases. Okay, so now you're starting to collect some parameters. Just by doing this exercise, you're starting to collect some parameters around who you want to learn from and sell to. Now if you send out those 30 notes and you wrote them specifically, and you spend good quality of time on it. And you've hit them on email, you've hit them on LinkedIn, maybe even tried to call them, maybe you've sent them a Twitter DM, pulled out all the stops. How many people respond? 1, 5, 0?

**中文翻译:**
在这 30 个人身上你注意到了什么？有什么有趣的洞察吗？也许是他们团队的规模，也许是所在的行业，也许是任职时间，或者是他们之前的职业经历。有什么共同点吗？通常情况下总会有一些共同点。好，现在你开始收集一些参数了。仅仅通过这个练习，你就开始收集关于你想向谁学习、想卖给谁的参数。现在，如果你发出了这 30 封信，每一封都是精心撰写的，你投入了高质量的时间。你尝试了邮件、LinkedIn，甚至尝试了打电话或 Twitter 私信，使出了浑身解数。有多少人回应？1 个，5 个，还是 0 个？

---

### [00:25:15] Jen Abel

**English:**
If it's zero, it begs the question, do you now want to do another 30 in a very similar fashion? Do you want to change the messaging a little bit? Now it forces these natural experiments. Or do you want to maybe go after a different role? So it forces you to answer these questions in a very manual way before you even think about integrating and spending time on tools. And then you get to a point where it's like, okay, now I'm starting to get some learnings and now I've realized, okay, it's this group of people, I've spoken to maybe two or three, now I want to go out and actually build a campaign to now talk to the next 10 to 15 people in that group. Truncate this as much as you can because I think people focus so much on volume in the beginning.

**中文翻译:**
如果是 0，那就得问问：你还想以类似的方式再找 30 个吗？你想稍微改改信息内容吗？这会迫使你进行自然的实验。或者你想换个职位试试？这迫使你在考虑集成工具和花时间研究工具之前，先用手动的方式回答这些问题。然后你会达到一个点：“好，我现在开始学到东西了，我意识到就是这群人，我已经和其中两三个聊过了，现在我想发起一个活动，去联系这组人里的下 10 到 15 个人。”尽量把这个过程切细，因为我觉得人们在开始阶段太关注“量”了。

---

### [00:26:06] Jen Abel

**English:**
Even if you're selling down market, mid market, enterprise, volume comes once you've identified it and know the parameters. Parameters then allow you to do really strong enrichment with a clay. You now know the types of questions to give it. If you're not asking it the right questions, these enrichment tools, these sales tools will yield nothing. It all comes back to even before you start your sales call, you need to make sure you're asking the right questions with am I even engaging, or do the people that I want to learn from or sell to, am I even messaging them in the right way? Are they even the right person? And the only way you can do that is by actually truncating these little experiments.

**中文翻译:**
无论你是卖给低端市场、中端市场还是大企业，只有当你识别出目标并确定了参数后，才谈得上规模。有了参数，你才能用 Clay 这样的工具进行强大的数据增强（enrichment）。你现在知道该给工具提什么样的问题了。如果你不提正确的问题，这些增强工具、销售工具将一无所获。一切都要追溯到你开始销售电话之前：你必须确保自己在问正确的问题——我是否真的在与人互动？我想向其学习或销售的人，我的信息方式对吗？他们是正确的人选吗？唯一的办法就是通过这些切细的小实验。

---

### [00:26:49] Lenny Rachitsky

**English:**
I love how tactical that is. And what I love is even one of your nuances you mentioned is can you even find them? This gives you a signal of how are... You're going to have to have hundreds of these, thousands of these eventually. If 30 is hard or impossible, you're in trouble already.

**中文翻译:**
我喜欢这种战术性的建议。而且我特别喜欢你提到的一个细节：你到底能不能找到他们？这给了你一个信号。你最终需要成百上千个这样的客户。如果找 30 个都很难或不可能，那你已经有麻烦了。

---

### [00:27:06] Jen Abel

**English:**
Totally. And it was funny, I was talking to someone today that said they had a target segment of high net worth individuals that they wanted to go out and serve. I'm like, how do you find those people? I guess when you get to a certain level, your net worth may be public. I don't know. That stuff's very hard to have certain parameters that are undiscoverable. And then if they're undiscoverable and it requires you getting on a call to understand if they are a fit, that does impact conversion rates. Not necessarily in a bad way, but now you need to kind of bring that back into the math equation, which is like, okay, if I speak to 10 people, I know two out of these 10 will be qualified. But I don't know which of those two out of 10. Well, that means you probably need more of those numbers.

**中文翻译:**
完全正确。很有趣，我今天刚和一个人聊过，他说他们的目标客群是想服务的“高净值人士”。我问：“你怎么找到这些人？”我猜当你达到一定级别时，你的净值可能是公开的，但我不知道。如果某些参数是无法发现的，那事情就很难办。如果他们无法被发现，需要你通过通话才能确定是否匹配，这会影响转化率。不一定是坏事，但你需要把这带入数学公式：如果我跟 10 个人聊，我知道其中 2 个是符合条件的，但我不知道是哪 2 个。那意味着你可能需要更大的基数。

---

### [00:27:52] Lenny Rachitsky

**English:**
So to quickly recap a few of the key things that I've written down as we're talking. So if you're just trying to figure out who to reach out to, make a list of 30 potential prospects that you think are good fits, that would be excited about what you're building. Spend 15 to 30 minutes writing them each an email. Do these emails have to be really short the way you described previously?

**中文翻译:**
快速总结一下我刚才记下的几点。如果你正在摸索该联系谁，先列出 30 个你认为合适、且会对你的产品感兴趣的潜在客户。花 15 到 30 分钟给每个人写封邮件。这些邮件也必须像你之前说的那样非常短吗？

---

### [00:28:12] Jen Abel

**English:**
I would say the shorter the better, but would you respond to that? If you got this email, would you respond it?

**中文翻译:**
我会说越短越好，但关键是：你会回复吗？如果你收到这封邮件，你会回吗？

---

### [00:28:17] Lenny Rachitsky

**English:**
Got it.

**中文翻译:**
明白了。

---

### [00:28:17] Jen Abel

**English:**
One of a great little tactical test is on Gmail, you can highlight the message and then have it replay it back to you from an audio perspective. You'd be shocked how many notes I've changed when it replays it back and I'm like, oh, that sounds really passive-aggressive.

**中文翻译:**
一个很棒的战术测试是：在 Gmail 上，你可以选中信息，然后让它以音频形式播放给你听。你会惊讶地发现，当我听回放时，我改了多少内容，因为我会觉得：“噢，这听起来太阴阳怪气了。”

---

### [00:28:34] Lenny Rachitsky

**English:**
Interesting. And so you also shared the structure for how to reach out to folks. So let me just share that again. And that applies to this initial email too, but it sounds like as you automate, you want to make it more precise and focused and not... Basically they're not as customized as you start reaching out to more folks.

**中文翻译:**
有趣。你还分享了联系别人的结构。让我再重复一遍。这也适用于最初的邮件，但听起来当你开始自动化时，你会希望它更精准、更聚焦，而不是……基本上当你联系更多人时，定制化程度会降低。

---

### [00:28:53] Jen Abel

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:28:54] Lenny Rachitsky

**English:**
So start with something, here's why this is relevant to you. You're looking for salespeople in this market. Here's something that's unexpected or surprised, like zero to one salespeople don't exist. Keep it short and then I always forget the last one.

**中文翻译:**
所以，以“为什么这与你相关”开始。比如“你正在这个市场寻找销售人员”。然后抛出一些出人意料或令人惊讶的东西，比如“‘从0到1’的销售人才不存在”。保持简短，然后……我总是忘最后一点。

---

### [00:29:14] Jen Abel

**English:**
Focus on the problem.

**中文翻译:**
聚焦于问题。

---

### [00:29:16] Lenny Rachitsky

**English:**
Focus on the problem.

**中文翻译:**
聚焦于问题。

---

### [00:29:17] Jen Abel

**English:**
You don't even need to talk about the solution. That's the big takeaway, which is if you get any sales email, you get what's the primary focus of that email? It's usually like here's what we do. But I bet if someone reached out to you with a novel insight and said, I'm really passionate about solving this problem, if it's something you're focused on, you'd probably reply.

**中文翻译:**
你甚至不需要谈论解决方案。这是核心要点。如果你收到任何销售邮件，邮件的主旨通常是什么？通常是“这是我们做的东西”。但我敢打赌，如果有人带着新颖的洞察联系你，并说“我非常热衷于解决这个问题”，如果这恰好是你关注的问题，你很可能会回复。

---

### [00:29:39] Lenny Rachitsky

**English:**
If it's a big problem. If it's like, oh yeah, you're so right, I need this.

**中文翻译:**
如果那是个大问题的话。如果我觉得：“噢对，你太对了，我正需要这个。”

---

### [00:29:42] Jen Abel

**English:**
The beauty with the American market, and I say this because we do a little bit of work with international startups too, is if something doesn't feel right, people love to complain about it. And it's like use that to your advantage. Get that intel.

**中文翻译:**
美国市场的妙处在于——我说这个是因为我们也和一些国际初创公司合作——如果有什么事情感觉不对劲，人们非常喜欢抱怨。你可以利用这一点，获取情报。

---

### [00:29:54] Lenny Rachitsky

**English:**
A note that I just looked at, that I wrote down, that I think is very important is avoid using "this is better" as your pitch.

**中文翻译:**
我刚才看了一下笔记，我记下了一点，我认为非常重要：在推销时避免使用“这更好”（this is better）。

---

### [00:30:01] Jen Abel

**English:**
Yeah, yep.

**中文翻译:**
没错。

---

### [00:30:02] Lenny Rachitsky

**English:**
Different. Here's something shocking about what we're doing. Here's something that'll surprise you.

**中文翻译:**
要用“不同”。比如“关于我们正在做的事情，有一些令人震惊的地方”或者“这会让你感到惊讶”。

---

### [00:30:07] Jen Abel

**English:**
Yeah, or counterintuitive. Exactly.

**中文翻译:**
是的，或者“反直觉”。正是如此。

---

### [00:30:08] Lenny Rachitsky

**English:**
Counterintuitive.

**中文翻译:**
反直觉。

---

### [00:30:09] Jen Abel

**English:**
Yeah, it's interesting. I spoke to a good friend that leads procurement at a massive organization. And he said to me, he goes, "One of the worst things someone can say to me is we're better than X product. Then I ask them to define that. And then I ask them, okay, how do we measure that? And then I say, okay, should we give this company another year to give them this feedback before we make this huge transition and disrupt momentum?" Yeah, better is a dangerous place.

**中文翻译:**
是的，很有趣。我曾和一位在大型机构负责采购的好友聊过。他告诉我：“别人对我说的最糟糕的话之一就是‘我们比 X 产品更好’。然后我会让他们定义这个‘好’。接着我会问，好，我们怎么衡量这个‘好’？然后我会说，既然如此，我们是不是应该再给现在的供应商一年时间，把这些反馈给他们，而不是进行这种可能打乱节奏的巨大转型？”是的，“更好”是一个危险的境地。

---

### [00:30:40] Lenny Rachitsky

**English:**
I invest in a bunch of startups and I find it's impossible to get anyone to care if things are good enough with what they got today. I'm happy not using the best possible product if my life is okay. And I have so many other things I got to do, I'll just deal with this good enough solution for now.

**中文翻译:**
我投资了很多初创公司，我发现如果人们觉得现状“足够好”，就很难让他们去关注新东西。如果我的生活还过得去，我不介意不用最好的产品。我有那么多其他事情要做，现阶段我就凑合用这个“足够好”的方案吧。

---

### [00:30:57] Jen Abel

**English:**
Absolutely.

**中文翻译:**
绝对是这样。

---

### [00:30:59] Lenny Rachitsky

**English:**
Okay, amazing. So we talked about how to figure out who to go after, how to pitch them to get them to want to talk. The next step I imagine is you're on the phone with them trying to convince them to actually care. What do you do there? How do you get them to engage further?

**中文翻译:**
好，太棒了。我们聊了如何确定目标，以及如何推销让他们愿意开口。我猜下一步就是和他们通电话，试图说服他们真正关注。在那一步你会怎么做？如何让他们进一步参与？

---

### [00:31:15] Jen Abel

**English:**
One is you need to be vulnerable. You're an early stage startup, okay. The market, we're at a point now where the market is smart. I always assume that the buyer I'm speaking to is highly educated and knows way more than I do. So just have that perception because what I've learned is a lot of the market will play dumb, and you can get yourself caught pretty quickly. So when you speak to them, I would be very open and honest with where you are. Hey, I'm an early stage startup. We are deeply passionate about solving this specific problem. We have a lot to learn. Here's how we are thinking about it from a problem priority perspective. Can we gain your insight into how this problem is manifesting on your side? And then let them open up. Now you have them one, talking about the problem. Now you're getting the intel about their perception of the problem, and is it even a problem? When you say you're early stage and there's still a lot to be done, it is easier to be honest.

**中文翻译:**
第一，你需要展现出真实、甚至有点“示弱”的一面。你是一家早期初创公司，没关系。现在的市场非常聪明。我总是假设我面对的买家受过高等教育，而且比我懂得多得多。要有这种觉悟，因为我学到的是，很多买家会装傻，如果你不够真诚，很快就会穿帮。所以当你和他们交谈时，我会非常坦诚地说明现状：“嘿，我们是一家早期初创公司。我们非常热衷于解决这个特定问题。我们还有很多要学的。这是我们从问题优先级角度出发的思考方式。我们能不能听听您的见解，看看这个问题在您那边是如何表现的？”然后让他们开口。现在，你让他们开始谈论问题了。你正在获取关于他们对问题的看法的情报，甚至能判断这到底算不算个问题。当你承认自己处于早期、还有很多工作要做时，诚实反而变得更容易。

---

### [00:32:20] Jen Abel

**English:**
If you tell them you have a fully baked, ready to go product, they're not going to give you honest feedback. It's very hard to say to a founder and look them in the eyes and say, hey, we built this product, can I show you what it is? You're just going to get someone that's going to say, oh, this is great, this is wonderful. But when you're vulnerable and when you tell them it's not fully built yet, even if it is, you will get more raw and honest feedback. Because it is easier to tell someone, hey, before you make this mistake, I actually don't care about that. If you've already built it, they're not going to give you that feedback. So the further you suggest you are, you're actually going to hamstring a lot of the intel, hamstring yourself on gaining a lot of the intel. So that's one counterintuitive thing that I think a lot of founders don't realize.

**中文翻译:**
如果你告诉他们你有一个完全成熟、随时可用的产品，他们就不会给你真实的反馈。很难当着创始人的面，看着他们的眼睛说：“嘿，我们做了这个产品，我能展示给你看吗？”你只会得到一些客套话：“噢，这太棒了，太好了。”但当你表现出真实的一面，告诉他们产品还没完全做完（即使已经做完了），你会得到更原始、更诚实的反馈。因为人们更容易对你说：“嘿，在你犯错之前我得告诉你，我其实根本不在乎那个功能。”如果你已经做好了，他们就不会给你这种反馈。所以，你表现得越成熟、越后期，实际上越会阻碍你获取情报。这是很多创始人没有意识到的反直觉的一点。

---

### [00:33:07] Lenny Rachitsky

**English:**
This episode is brought to you by Paragon... [Ad Content]

**中文翻译:**
本期节目由 Paragon 赞助……（广告内容略）

---

### [00:34:14] Lenny Rachitsky

**English:**
So I had April Dunford on the podcast a while ago. I don't know if-

**中文翻译:**
我前阵子请 April Dunford 上过节目，不知道你……

---

### [00:34:17] Jen Abel

**English:**
She's awesome.

**中文翻译:**
她太棒了。

---

### [00:34:18] Lenny Rachitsky

**English:**
Amazing. And her last book, it actually has the opposite advice, but I think I know why, which is she focuses on later stage companies and her advice is the buyer. She has this really interesting insight that it's harder to buy software now than to sell it, because there's so much to consider and your job is on the line if you make a mistake. It's easier just to be like, forget it, I'm just going to go with what we have today. I don't want to put my ass on the line for buying this new thing that someone's trying. And so her advice is you actually have to educate the buyer on the market and here's what's happening. Here's where things are going, and here's why I think this is the future. But I think again, I think that's focusing on later stage stuff.

**中文翻译:**
确实。她的新书里其实给出了相反的建议，但我大概知道原因：她关注的是后期公司，她的建议是针对买家的。她有一个非常有趣的洞察：现在买软件比卖软件更难，因为要考虑的事情太多了，一旦选错，你的饭碗可能就不保了。所以买家更容易觉得：“算了，我就用现在的吧。我不想为了买个新玩意儿去冒险。”所以她的建议是，你实际上必须教育买家关于市场的情况，告诉他们正在发生什么，趋势是什么，以及为什么你认为这是未来。但我认为，这确实是针对后期阶段的。

---

### [00:34:55] Jen Abel

**English:**
A hundred percent. And you raised such a good point, Lenny, which is late stage sales and early stage sales are very, very different. And I think that's where a lot of early stage founders get tripped up as they're taking late stage sales advice, usually coming from an investor. Or they've maybe hired a salesperson that's focused on more mature sales. But I think she's spot on. Buying is just as hard, if not harder, than selling right now. Because who wants to make a mistake and also who wants to go through switching costs? Oh, it's so painful.

**中文翻译:**
百分之百同意。Lenny，你提到了非常好的一点：后期销售和早期销售是非常、非常不同的。我认为很多早期创始人之所以栽跟头，是因为他们采纳了后期销售的建议，这些建议通常来自投资者，或者他们雇佣了一个习惯于成熟期销售的销售员。但我认为她说得很对，现在买东西和卖东西一样难，甚至更难。因为谁也不想犯错，谁也不想承担切换成本（switching costs）。噢，那太痛苦了。

---

### [00:35:30] Lenny Rachitsky

**English:**
Yeah. I think the other really important point here that you're making is that part of this initial sales experience of founder led sales is not sell as much as you can. It's to learn what people want. And so I love that you're sharing here's how to get the best possible feedback, not necessarily close the most deals.

**中文翻译:**
是的。我觉得你提到的另一个非常重要的点是：创始人主导的早期销售体验，其目的不是卖得越多越好，而是学习人们想要什么。所以我很喜欢你分享的这些——如何获得最好的反馈，而不一定是达成最多的交易。

---

### [00:35:47] Jen Abel

**English:**
Totally. And founder led sales is not about revenue on day one. It is about learning as fast as humanly possible to get to that pulse, so that you can earn the right to sell. There's this concept that I talk about, which is you're going out to run sales to collect the research, which is what founder led sales is. And then you have sales for revenue, which is that post founder led sales stage.

**中文翻译:**
完全正确。创始人主导的销售在第一天不是为了收入。它是为了以人类可能的最快速度学习，摸准脉搏，从而赢得销售的权利。我常谈到一个概念：你出去做销售是为了收集研究数据，这就是创始人主导的销售；然后才是为了收入而销售，那是创始人主导销售之后的阶段。

---

### [00:36:13] Lenny Rachitsky

**English:**
And your milestone that you suggested of how far to take founder led sales, you said around a million ARR, right?

**中文翻译:**
你建议创始人主导销售应该坚持到什么时候？你说是 100 万美元 ARR（年度经常性收入）左右，对吧？

---

### [00:36:20] Jen Abel

**English:**
Yeah. I think it's about, some people say 500, some people say a million. I think if you get to 500K really, really fast, then I think absolutely you can move out of it. If you get to 500K really, really, really slow, you might not want to get out of it right away. You haven't reached that velocity point yet.

**中文翻译:**
是的。有些人说是 50 万，有些人说是 100 万。我认为如果你非常、非常快地达到了 50 万，那么你绝对可以放手了。但如果你达到 50 万的过程非常、非常缓慢，你可能不想马上退出，因为你还没达到那个爆发点。

---

### [00:36:41] Lenny Rachitsky

**English:**
Awesome. I have a post that we'll link to that has actually numbers and when all these big startups move from founder led sales. It's in that same series about product market fit. There's two stories this makes me think of I'll share real quick. One is Sprig. They shared a story of first round capital at their first round and their partner there is just like, we will not let you hire a salesperson until you hit a million ARR. We're going to help you. We're going to have salespeople helping you through it, but we're not going to let you hire someone. And he was really happy about that. The other is Zip, which just raised a $2.3 billion valuation, a procurement company that I was lucky to be an investor in. And their first founder led sales motion was they just reached out on LinkedIn to heads of procurement, and just leaned into what you're saving more, which is we just want your advice on this product that we're building. Just tell us what problems you have. It was very advice oriented versus we want to sell you this thing.

**中文翻译:**
太棒了。我有一篇博文会附上链接，里面有具体的数据，记录了那些大型初创公司何时从创始人主导销售转型的。这属于 PMF 系列。这让我想起两个故事，快速分享一下。一个是 Sprig，他们分享了在首轮融资时，First Round Capital 的合伙人说：“在达到 100 万 ARR 之前，我们不会让你雇佣销售。我们会帮你，我们会让销售人员协助你，但不会让你正式雇人。”创始人对此非常感激。另一个是 Zip，刚刚估值达到 23 亿美元的一家采购软件公司，我很幸运是他们的投资者。他们最初的创始人销售模式就是直接在 LinkedIn 上联系采购主管，用的正是你说的策略：“我们只是想听听您对我们正在开发的产品有什么建议。告诉我们您遇到了什么问题。”这非常倾向于寻求建议，而不是“我们要卖给你这个东西”。

---

### [00:37:33] Jen Abel

**English:**
Yeah, no, absolutely. I have this theory that maybe you shouldn't hire any salespeople until series A, right? Because seed is all about experimentation and proving out that experiment, and then obviously series A is about exploiting that learning. But I see so many people, I mean hiring for early stage sales is the odds are actually more against you than trying to get your next round of funding. Because it's truly, truly such a counterintuitive stage.

**中文翻译:**
是的，绝对没错。我有一个理论：也许在 A 轮之前都不应该雇佣任何销售，对吧？因为种子轮全是关于实验和验证实验，而 A 轮显然是为了利用这些学习成果进行扩张。但我看到太多人……我的意思是，为早期销售招聘人才，其失败的概率其实比你拿不到下一轮融资的概率还要大。因为这确实是一个非常反直觉的阶段。

---

### [00:38:08] Lenny Rachitsky

**English:**
Interesting. Okay, so I kind of took us on a whole tangent. You were sharing advice on how to get someone excited. So the first is when you're engaging, you're talking to the prospect and company ABC. Your advice is be very honest and vulnerable about your stage. Tell them you're early stage. You're building this thing. You're deeply passionate about this problem. Here's what we're trying to do, here's our priority problem perspective, and where we're focusing, and kind of get their feedback on your approach. Cool. You were going to go to the next tip and I took us off course.

**中文翻译:**
有趣。好，我刚才把你带偏了。你之前在分享如何让人感到兴奋。第一点是当你与潜在客户（比如 ABC 公司）互动时，你的建议是：对自己的阶段保持诚实和真实。告诉他们你是早期阶段，正在开发这个东西，对这个问题充满热情。告诉他们你们在尝试做什么，你们对问题优先级的看法，以及你们的关注点，然后听取他们对你们方法的反馈。太酷了。你正准备说下一个建议，结果被我打断了。

---

### [00:38:44] Jen Abel

**English:**
Testing the questions to ask. Where is that aha unlock for you? But more importantly, where's that aha moment unlocked for them? Because when they start getting their gears churning in their head about, and this is the beauty about not having a product and not showing them anything, they're visualizing in their head now. This is a really powerful thing, which is like, so tell me how this looks in your head? How are you seeing this? And they're like, I don't know if I can see it. And I'm like, great, we'll show you that. Great insight to know by the way. Or so I think this is how, I guess this is how it would work. Walk me through what's living in your head right now. You pick up on so much and then all of a sudden they're like, wait a second, we've tried solving for this and it's still not solved for. Or you know what? We hired someone last year to manage this. Great understanding. Is it being measured? Is it being managed and have they tried to solve for it? The leading indicators that you're onto something here.

**中文翻译:**
测试该问什么问题。哪里是你的“顿悟”（aha）时刻？但更重要的是，哪里是他们的“顿悟”时刻？因为当他们开始在脑子里思考时——这就是没有产品、不给他们看任何东西的妙处——他们现在是在脑子里进行具象化。这是一件非常强大的事情，你可以问：“告诉我，这在你脑子里是什么样子的？你是怎么看的？”如果他们说：“我不知道，我还没法想象。”我会说：“太好了，我们会展示给你看。”顺便说一下，这也是个很棒的洞察。或者他们会说：“我觉得应该是这样，我猜是这么运作的。”然后我会说：“带我梳理一下你现在的想法。”你能捕捉到很多信息，然后突然间他们会说：“等等，我们尝试过解决这个，但还没解决。”或者“你知道吗？我们去年雇了个人来管这个。”太好了，了解清楚：这是否被衡量了？是否被管理了？他们是否尝试过解决？这些都是表明你找对方向的领先指标。

---

### [00:39:44] Lenny Rachitsky

**English:**
I love this thread because this is what everyone's always like, how do I know if I product market fit? There's these signals that you're talking about of signs that there's something here. Like a big enough pain point where they're excited to basically they want to pay for it, they will pay to solve a problem. So maybe just again, say the things you notice that are signs like, okay, you have something here.

**中文翻译:**
我喜欢这个思路，因为每个人都在问：“我怎么知道我达到了 PMF？”你提到的这些信号就是“这里有戏”的迹象。比如一个足够大的痛点，让他们兴奋到基本上想为此付钱，他们愿意付钱来解决问题。所以，能不能再重复一下你注意到的那些迹象，比如“好，你找对感觉了”。

---

### [00:40:03] Jen Abel

**English:**
So I think the first is it has to be a growing and widening problem. No one's going to spend time fixing a pretty fixed problem, because it's not necessarily really a priority anymore. It's maybe a pain in the butt, but it's not a priority if it's not growing or widening. So gate check one is like, what is the implication? Are you measuring? Are you managing this problem today? Yes or no? If they don't know, great to know. If they said no, okay, move on to the next. That's pretty powerful. No, we're not measuring or managing this. Okay, there's probably not much there. If it is being measured or managed, then the next question you want to get into is how have you tried to solve for it? Is it through that head count that you just hired? Is it through another tool? Is it just still an open gap because nothing exists yet to solve it? Just understand their maturity around how they've tried to plug it. These are all that make the secret moments in intel to close that gap.

**中文翻译:**
我认为第一点是：它必须是一个正在增长和扩大的问题。没人会花时间去修复一个已经固定的问题，因为那不再是优先级了。它可能让人心烦，但如果它不增长或不扩大，就不是优先级。所以第一道关卡是：影响是什么？你今天在衡量或管理这个问题吗？是还是否？如果他们不知道，那也是个重要信息。如果他们说“不”，好，跳到下一个。这很有力——“不，我们没有在衡量或管理这个。”那可能就没戏。如果正在被衡量或管理，那么下一个问题就是：你们尝试过如何解决它？是通过刚雇的人吗？是通过另一个工具吗？还是说因为目前没有任何东西能解决它，所以它仍然是一个缺口？了解他们在尝试填补缺口方面的成熟度。这些都是获取情报、缩小差距的秘诀时刻。

---

### [00:41:06] Lenny Rachitsky

**English:**
That's awesome. And essentially it's showing you that there's a pain here that they're paying attention to and are trying to solve.

**中文翻译:**
太棒了。本质上这向你展示了这里有一个他们正在关注并试图解决的痛苦。

---

### [00:41:14] Jen Abel

**English:**
And what you're psychologically doing is now you're flipping them into a buyer where they're like, wait a second, hold on. I need to bring on so-and-so on the next call, they also think that this is not good enough.

**中文翻译:**
你在心理上做的是，现在你正把他们转变为买家，他们会觉得：“等等，稍等。我下次得把某某也叫来，他们也觉得现在的方案不够好。”

---

### [00:41:26] Lenny Rachitsky

**English:**
That's funny because that's exactly what Wiz noticed, is they moved from people being like, oh, this is cool. I like it, I like it. To, okay, I'm going to pull in this person. I'm going to pull in this person to talk about it and make sure we're... And they were pulling in other people exactly as you described it, because they wanted to move forward on this thing.

**中文翻译:**
这很有趣，因为这正是 Wiz 注意到的：他们从人们说“噢，这很酷，我喜欢”转变为“好，我要拉这个人进来，我要拉那个人进来一起聊聊，确保我们……”他们正如你描述的那样拉其他人进来，因为他们想推进这件事。

---

### [00:41:44] Jen Abel

**English:**
Absolutely. And that's when you know there's some momentum behind it, which is when they're bringing in other colleagues. Whether it be the potential users, if you're reaching out to the executive, or the users like, hey, I actually want to bring my boss on to the next call.

**中文翻译:**
绝对是。当他们开始拉同事进来时，你就知道这件事有了势头。无论是潜在用户（如果你联系的是高管），还是用户说：“嘿，我其实想让我的老板也参加下一次通话。”

---

### [00:41:57] Lenny Rachitsky

**English:**
Good sign. Cool. Anything else along these lines of how to get someone excited slash understand if there's going to be pull there?

**中文翻译:**
好迹象。酷。关于如何让人兴奋，或者判断是否有市场拉力，还有什么建议吗？

---

### [00:42:04] Jen Abel

**English:**
I guess the one thing is please, please, please do not ask questions like what keeps you up at night? If you had a magic wand, what are your pain points today? I can guarantee you that answer changes every single day.

**中文翻译:**
我想说的一点是：请、请、千万不要问这类问题，比如“什么让你夜不能寐？”或者“如果你有一根魔法棒，你现在的痛点是什么？”我保证，这些问题的答案每天都在变。

---

### [00:42:19] Lenny Rachitsky

**English:**
That's super interesting. Is there any tip for how to end one of these calls, as someone that's never done sales is like-

**中文翻译:**
这非常有趣。对于从未做过销售的人来说，如何结束这类通话有什么技巧吗？

---

### [00:42:23] Jen Abel

**English:**
Yes.

**中文翻译:**
有。

---

### [00:42:24] Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好。

---

### [00:42:25] Jen Abel

**English:**
Get the second call booked on the first call.

**中文翻译:**
在第一次通话结束前，定好第二次通话的时间。

---

### [00:42:28] Lenny Rachitsky

**English:**
Love it.

**中文翻译:**
太赞了。

---

### [00:42:28] Jen Abel

**English:**
Pull up calendars. Look at calendars. Who else should be invited? It's just a natural evolution to ending the call.

**中文翻译:**
打开日历。看日历。还应该邀请谁？这是结束通话最自然的演变。

---

### [00:42:35] Lenny Rachitsky

**English:**
Great. So that's in 30 minutes though, right?

**中文翻译:**
太好了。不过那是在 30 分钟内完成的，对吧？

---

### [00:42:38] Jen Abel

**English:**
And if they say, ah, I'll email you.

**中文翻译:**
如果他们说：“啊，我会给你发邮件的。”

---

### [00:42:42] Lenny Rachitsky

**English:**
I could say.

**中文翻译:**
我能猜到。

---

### [00:42:44] Jen Abel

**English:**
That's also kind of a leading indicator. Yeah.

**中文翻译:**
那也是一种领先指标。是的。

---

### [00:42:46] Lenny Rachitsky

**English:**
So do you recommend not getting off the call, trying to avoid that, or is it just-

**中文翻译:**
所以你建议不要就这样挂断，尽量避免这种情况，还是说……

---

### [00:42:50] Jen Abel

**English:**
If they won't give you time on the calendar, you could say, listen, great. Feel free to email me. Maybe they're just being honest and they don't have their calendar available, but nine times out of 10, it's usually I don't have the heart to tell you I'm not interested.

**中文翻译:**
如果他们不肯在日历上定时间，你可以说：“听着，太好了，随时给我发邮件。”也许他们只是实话实说，现在没法看日历，但十有八九，这通常意味着“我不忍心告诉你我没兴趣”。

---

### [00:43:04] Lenny Rachitsky

**English:**
Yeah, it's hard. It's hard to tell people you're not interested. Very cool. Okay. This is amazing. Okay, so the next step, if I remember correctly, is kind of co-authoring and co...

**中文翻译:**
是的，很难。很难当面告诉别人你没兴趣。非常酷。好，这太棒了。那么下一步，如果我没记错的话，是“共同撰写”和“共同……”

---

### [00:43:13] Jen Abel

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:43:14] Lenny Rachitsky

**English:**
Okay, cool. Talk about that.

**中文翻译:**
好，酷。聊聊这个。

---

### [00:43:16] Jen Abel

**English:**
In the early, early days, one of the biggest ways you can get folks excited is it feels like it's going to be built specifically for them. The power of specificity, the power of being extremely focused. With that, you can literally turn a customer into a guide by asking them to co-author the scope. The scope of work. The co-authorship piece is important for two reasons. It helps you understand where they're on their biomaturity. Let me explain. If they do not have an existing process or strategy to solve X problem, they can't buy a technology yet, which means you need to sell them. And this is why I go back to you need to sell them some form of a service, right? Why? You want to be the one in there educating. You also want to get the logo. You also want to show the revenue. While it's not recurring revenue, it still shows intent.

**中文翻译:**
在极早期，让人们感到兴奋的最大方式之一，就是让他们觉得这个产品是专门为他们打造的。这就是“具体化”的力量，是“极度聚焦”的力量。有了这一点，你通过邀请他们共同撰写“工作范围”（Scope of Work），可以把客户变成你的向导。共同撰写之所以重要有两个原因。首先，它能帮你了解他们的“购买成熟度”。我解释一下：如果他们还没有现成的流程或策略来解决 X 问题，他们就还没法购买技术产品，这意味着你需要先卖给他们……这就是为什么我之前说，你需要卖给他们某种形式的“服务”，对吧？为什么？因为你想成为那个教育他们的人。你也想拿到他们的 Logo。你还想展示收入。虽然这不是经常性收入（recurring revenue），但它仍然展示了意向。

---

### [00:44:13] Jen Abel

**English:**
And I think that that's really important. Every founder I speak to is like, well, my investor really doesn't want service-based revenue. That's fine. But then you can also tell your investor, great, should I wait 18 months to when they're ready to buy a solution, and be the one that's not the one selling them because someone else educated them? These are all of the implications of waiting. So yes, is service-based revenue great? No, we all know why it's not great. But it's great in the sense that it shows intent. It's great in the sense that you can call them a customer. It's great in the sense that now you can use their logo. And it's great in the sense because you are getting paid to educate them. You are getting paid to help them design their process. This is where all the power lives. And this is why so many AI startups a year and two years ago were going in on services contracts, because they wanted to set the mindset with the buyer around what this would look like.

**中文翻译:**
我认为这非常重要。我遇到的每个创始人都说：“哎呀，我的投资者真的不想要基于服务的收入。”没关系。但你也可以告诉你的投资者：“好，那我是应该等 18 个月，等他们准备好购买方案时，却发现因为别人教育了他们，所以我卖不出去吗？”这就是等待的代价。所以，基于服务的收入好吗？不，我们都知道它为什么不好（不可规模化）。但它的好处在于它展示了意向。它的好处在于你可以称他们为客户。它的好处在于你现在可以使用他们的 Logo。而且它的好处还在于，你是在拿钱去教育他们，拿钱去帮他们设计流程。这就是力量所在。这就是为什么一两年前那么多 AI 初创公司都在签服务合同，因为他们想在买家心中建立起“这东西应该是什么样”的认知。

---

### [00:45:07] Lenny Rachitsky

**English:**
Is there anything you recommend to time box contain the services piece? Because I know a lot of companies-

**中文翻译:**
对于如何限制服务部分的时间范围，你有什么建议吗？因为我知道很多公司……

---

### [00:45:12] Jen Abel

**English:**
Yes, such a great point, Lenny. You absolutely need to time box this. I would time box it as 90 days and then what you can say in the next 90 days, we'll scope where we are and what you need. Scoping out more than 90 days, listen, so much is going to change. You might also not want to do it anymore, so you don't want to lock yourself up. So I would look at 90 day increments. A specific example. We had a founder that my colleague was working with, and they were selling a very specific technology to a non-traditional... Sorry, a very traditional industry. I don't want to be two bleeding with what it is, but a very traditional industry that's not used to working with startups, or necessarily plugging in a new technology right away. And they were very honest. They said, listen, we haven't changed vendors or partners in over five or six years.

**中文翻译:**
是的，Lenny，提得太好了。你绝对需要限制时间。我会把它定为 90 天，然后你可以说：“在接下来的 90 天里，我们会评估现状和您的需求。”规划超过 90 天的话，听着，变数太多了。你可能到时候也不想做了，所以你不想把自己锁死。所以我会以 90 天为一个增量。举个具体的例子：我同事合作过的一位创始人，他们向一个非常传统的行业销售一种非常具体的技术。我不便透露具体是什么，但那是一个非常传统的行业，不习惯与初创公司合作，也不习惯立即接入新技术。他们非常诚实，说：“听着，我们已经五六年没换过供应商或合作伙伴了。”

---

### [00:46:04] Jen Abel

**English:**
I actually don't even know how we would do that today. Could you come in and explain to us, understanding where our workflow is and how we would integrate this, before we even consider the technology? Which we did. We got paid a nominal amount, but we're now a customer and now we get to set the stage for how they think about this. And then they won the technology contract. But everyone is so focused on selling the technology really, really, really quickly. That works in markets that know how to buy that technology, have a process in place, have a strategy in place, have an implementation team in place.

**中文翻译:**
“我甚至不知道今天该怎么操作。在考虑技术之前，你们能不能进来给我们解释一下，了解我们的工作流，以及我们该如何集成这个东西？”我们照做了。我们收了一笔象征性的费用，但现在我们成了他们的供应商，我们可以主导他们对这件事的看法。最终，他们赢得了技术合同。但每个人都太急于非常、非常、非常快地推销技术。这只在那些知道如何购买该技术、有现成流程、有策略、有实施团队的市场才行得通。

---

### [00:46:40] Jen Abel

**English:**
If it's a new technology like AI right now, they need a strategy and process like who's the human in the loop? Is it them or is it you? How do we measure success? What does success look like? What risks should we be aware of? Our legal team's not even aware of all these risks. You want to be careful because legal can immediately, and procurement, can shut these things down if it seems too novel, where it's foreign versus they're so used to buying services, especially at market. It's their largest budget line item.

**中文翻译:**
如果是像现在的 AI 这样的新技术，他们需要策略和流程，比如：谁是环节中的人工（human in the loop）？是他们还是你们？我们如何衡量成功？成功看起来是什么样的？我们需要注意哪些风险？我们的法务团队甚至都不知道这些风险。你需要小心，因为如果东西看起来太新颖、太陌生，法务和采购部门可以立即叫停。相比之下，他们非常习惯购买服务，尤其是在大企业市场，那是他们最大的预算支出项。

---

### [00:47:10] Lenny Rachitsky

**English:**
So it's interesting because most founders are very afraid of moving into services. I hadn't heard this advice before.

**中文翻译:**
这很有趣，因为大多数创始人都非常害怕涉足服务。我以前没听过这种建议。

---

### [00:47:15] Jen Abel

**English:**
Probably going to get slapped for saying all this stuff, by the way.

**中文翻译:**
顺便说一下，我可能会因为说这些话而被同行“打脸”。

---

### [00:47:17] Lenny Rachitsky

**English:**
Well, so along those lines, what percentage of companies that you've worked with or see do that or have to do that step?

**中文翻译:**
那么，在你合作过或见过的公司中，有多少比例的公司会做或者必须做这一步？

---

### [00:47:25] Jen Abel

**English:**
This is going to be a shocking step. So I would 40 to 50% have to sell some form of service before they can sell a technology.

**中文翻译:**
这是一个令人震惊的比例。我会说 40% 到 50% 的公司在卖技术之前，必须先卖某种形式的服务。

---

### [00:47:34] Lenny Rachitsky

**English:**
Wow. Of B2B SaaS company?

**中文翻译:**
哇。是 B2B SaaS 公司吗？

---

### [00:47:36] Jen Abel

**English:**
A B2B SaaS. And this, again, this is specifically more top-down sales. But yeah, because the user and the buyer are different, which means there's user value, there's buyer value, there's all different players, there's procurement you have to go through. But yeah.

**中文翻译:**
B2B SaaS。再说一次，这特别是指“自上而下”的销售。是的，因为使用者和购买者是不同的，这意味着有使用者价值、购买者价值，还有各种不同的参与者，你还得通过采购部门。所以，没错。

---

### [00:47:50] Lenny Rachitsky

**English:**
And just to make it even clearer, what's an example of a service that you've seen company offer in a step?

**中文翻译:**
为了更清楚一点，你能举个例子吗？你见过公司在这一步提供什么样的服务？

---

### [00:47:55] Jen Abel

**English:**
So I've seen, hey, can you come in and actually help me pitch this, design a custom pitch to my boss as to why we should do this today? And we literally got paid to build a sales pitch.

**中文翻译:**
我见过这种：“嘿，你能不能进来帮我推销一下这个，为我的老板设计一个定制的提案，说明我们为什么要现在做这件事？”我们真的因为帮人写销售提案而拿到了钱。

---

### [00:48:09] Lenny Rachitsky

**English:**
So it's not necessarily providing a service. It could be just helping them sell this.

**中文翻译:**
所以不一定是提供某种功能性服务，可能只是帮他们内部推销。

---

### [00:48:15] Jen Abel

**English:**
Yeah. It could be helping them sell in a way that makes you... You need to get a lot more context on their business. It can also be, hey, we haven't actually thought about a process for how we can actually deploy something like this. We're currently using this technology, which we want to change from. You've kind of hit this at the right time. How would we implement or how is it best to integrate with this tool? Can we get both of you guys in a room to map this out?

**中文翻译:**
是的。这可能是帮他们推销，这会让你……你需要获得更多关于他们业务的背景信息。也可以是：“嘿，我们其实还没想好如何部署这类东西。我们目前正在使用这种技术，正想换掉。你来得正是时候。我们该如何实施？或者如何最好地与这个工具集成？我们能不能把你们两方都叫到一个房间里来规划一下？”

---

### [00:48:43] Lenny Rachitsky

**English:**
Got it. So it's like consultants almost, like coming in to help you solve this problem.

**中文翻译:**
明白了。所以有点像顾问，进来帮你解决这个问题。

---

### [00:48:47] Jen Abel

**English:**
It's a great point. It's consulting them towards the acquisition of the product. It's not consulting as one-off consulting.

**中文翻译:**
说得很好。这是为了引导他们购买产品而进行的咨询，而不是那种一次性的咨询业务。

---

### [00:48:53] Lenny Rachitsky

**English:**
Got it. And they know that obviously you're biased, but they also want the problem solved. And they're like, great, you're going to help us solve this problem, because it's on my plate and I need your help convincing leadership that this is-

**中文翻译:**
明白了。他们显然知道你有立场，但他们也想解决问题。他们会觉得：“太好了，你会帮我们解决这个问题，因为这是我的活儿，我需要你帮我向领导层证明这是……”

---

### [00:49:04] Jen Abel

**English:**
And I need to craft the storyline as to why we need to do it anyway, so I will pay you to do it, but here's the format it needs to be in.

**中文翻译:**
“而且我反正也得编一个为什么要这么做的故事，所以我愿意付钱让你来做，但必须按照这个格式来。”

---

### [00:49:10] Lenny Rachitsky

**English:**
Fascinating. Wow. Okay. Anything else along those lines?

**中文翻译:**
太迷人了。哇。好，还有别的吗？

---

### [00:49:15] Jen Abel

**English:**
And then of course, if you're in a position to actually sell the technology, because the market is able to acquire and adopt it and not have to create a new strategy or process, then obviously sell the technology. You don't need to be selling services.

**中文翻译:**
当然，如果你处于可以直接销售技术的位置，因为市场已经能够购买和采用它，不需要创建新的策略或流程，那就直接卖技术。你不需要去卖服务。

---

### [00:49:26] Lenny Rachitsky

**English:**
I want to come back real quick. The previous call, I wrote this note down as you were talking. You recommended not doing a demo and just talking about it broadly. Is that your advice there?

**中文翻译:**
我想快速回过头来。关于之前的通话，你在说话时我记下了这一点：你建议不要做演示（demo），只是泛泛而谈。那是你的建议吗？

---

### [00:49:34] Jen Abel

**English:**
On the first call. Yeah. On the first call, my fundamental belief is that the demo is a bit of the only carry you control in the sales process, right? Once they see it, it's kind of like pitching an investor. Once they take a look under the hood, that dreaminess in their eyes, they're like, oh, I saw it. So leave them wanting more. And the demo is that, leave them wanting more. Even when you do a demo, don't demo everything. Leave it for a second call. Let them invest a lot of time in you. Again, if it's qualified. Preface that, if it's qualified. But everyone races through the sales process like let's do a demo call as quickly as humanly possible.

**中文翻译:**
在第一次通话时，是的。在第一次通话中，我的基本信念是：演示是你在销售流程中唯一能控制的“杀手锏”，对吧？一旦他们看到了，就像给投资者做提案一样。一旦他们看了底层的逻辑，他们眼里的那种神秘感就消失了，他们会觉得：“哦，我看过了。”所以要让他们保持渴望。演示就是那个“吊胃口”的东西。即使你做演示，也不要演示所有功能。留到第二次通话。让他们在你身上投入大量时间。当然，前提是对方是“合格客户”（qualified）。大家总是急于推进销售流程，恨不得尽快进行演示通话。

---

### [00:50:20] Jen Abel

**English:**
Yes, that is important down market. That is important if you're selling a $3,000 tool, you absolutely want to be demoing as fast as humanly possible because it's a high-volume game. Upmarket, when you're talking about hundreds of thousands of dollars, you want to slow that down as fast as possible. Because you want to, one, make sure all of the right people are in the room. As soon as there's one lead on this, and if it requires other people involved, it doesn't feel like anyone else's baby. So you want it to make it feel like the group's baby versus this one individual's baby because it's very quick. Someone can easily say, I'd rather use this tool. And then there's this stalemate of nothing happens.

**中文翻译:**
是的，这在低端市场很重要。如果你卖的是 3000 美元的工具，你绝对希望尽快演示，因为那是跑量的游戏。但在高端市场，当你谈论几十万美元的交易时，你要尽可能慢下来。因为第一，你要确保所有正确的人都在场。一旦只有一个人负责这个，如果需要其他人参与，其他人就不会觉得这是“自己的孩子”。所以你要让它感觉像是整个团队的项目，而不是某个人的项目，因为如果太快，别人很容易说：“我宁愿用那个工具。”然后就会陷入僵局，什么也推进不了。

---

### [00:50:55] Lenny Rachitsky

**English:**
Just to maybe reiterate, so far we've talked about figure out who to talk to, pitching them on talking to you, then having that first conversation. Maybe there's another conversation in there to get them excited. And then there's just getting them past the finish line, keeping everyone aligned. Is that roughly the next step or how should we think about this?

**中文翻译:**
重申一下，到目前为止我们讨论了：确定联系对象、说服他们和你聊聊、进行第一次对话。也许中间还有一次对话让他们兴奋起来。然后就是让他们冲过终点线，保持所有人步调一致。这大概是下一步吗？我们该如何思考这一步？

---

### [00:51:14] Jen Abel

**English:**
Yeah, so if you are selling upmarket and you now need to go to procurement, who is the group involved in the bot. They're the professional buyers. Procurement is a very interesting function. They are very smart, very, very smart. They do this for a living. They are professional buyers. So there's a couple things that you need to be aware of. You need to sell them as well. You need to really make this sound... Don't over complicate it. Don't add in jargon. Make it feel like, okay, I can wrap my head around this. The second piece is it's got to feel different from anything else out there. Because the professional buyer, it's much easier to say, wait a second, we have these 17 other preferred vendors that do similar ish work. Why don't you just go use one of them? Because, oh, by the time this gets through procurement, it could be another three to four months.

**中文翻译:**
是的，如果你是向高端市场销售，你现在需要面对采购部门（procurement），他们是参与购买的专业群体。采购是一个非常有趣的职能。他们非常聪明，非常、非常聪明。他们以此为生，是专业买家。所以有几件事你需要注意。你也需要向他们推销。你需要让你的东西听起来……不要搞得太复杂，不要加术语。要让他们觉得：“好，我能听懂这个。”第二点是，它必须感觉与市面上的任何东西都不同。因为对于专业买家来说，他们很容易说：“等等，我们已经有 17 个首选供应商做类似的工作了。你为什么不去用他们中的一个？因为，噢，等这个通过采购流程，可能又要花三到四个月。”

---

### [00:52:05] Jen Abel

**English:**
I've seen deals die on the vine because procurement actually suggested they go use another vendor in the system, that this buyer wasn't even aware of, because they didn't differentiate. It didn't feel different. It just felt slightly better. That's how it was positioned. The third piece is when you get to procurement, you're going to have to do all the work. Make their job easy. You are probably a very small piece into the very large deals that a lot of these people buy. So you can get easily sidelined just because you're just a small buy. So do the work for them. Literally say, I want to make this as easy as possible for you. Give me the forms that you need to fill out. I'll fill them out for you, and you can do it yourself. You can edit them. Do the lift for them. If you don't, it's so easy for it to just go there and die.

**中文翻译:**
我见过很多交易胎死腹中，就是因为采购部门建议他们去用系统里已有的另一个供应商（而买家甚至都不知道那个供应商的存在），原因就是你没有做出差异化。它感觉不“不同”，只是感觉“稍微好一点”。这就是定位的问题。第三点是，当你面对采购时，你必须承担所有的工作。让他们的工作变得简单。在这些人处理的大宗交易中，你可能只是微不足道的一小部分。所以你很容易因为“买卖太小”而被边缘化。所以，替他们干活。直接说：“我想让这件事对您来说尽可能简单。把您需要填的表格给我，我帮您填好，您可以自己检查修改。”替他们分担压力。如果你不这样做，交易很容易就在那里无疾而终。

---

### [00:52:55] Jen Abel

**English:**
Another piece that's important with procurement is explaining exactly what you do and don't do. Because if you say you do a bunch of things and they can't really place you, they're going to send you to the kitchen sink of contracting an MSA, which is going to ask you for $5 million in an insurance policy and all sorts of other things. And the ability to look at your book at any point in time. And the reason they did that is because they can't classify you. So the easiest thing to do is classify you as high risk. So make it easy for them, make it simplified. You can also truncate your contracts, meaning let's say IT is maybe, and you want to ask this, how long does it take to get through IT due diligence? They might say, oh, it's a 90-day backup, it's a 60-day backup, it's a 30-day backup.

**中文翻译:**
关于采购的另一个重点是：准确解释你做什么和不做什么。因为如果你说你能做一堆事，而他们无法对你进行归类，他们就会把你扔进最复杂的 MSA（主服务协议）合同流程里，要求你提供 500 万美元的保险单以及各种乱七八糟的东西，还要随时查账。他们之所以这么做，是因为无法对你进行分类。所以最简单的做法就是把你归类为“高风险”。所以，让事情变得简单、明了。你也可以拆分合同，比如你可以问：“通过 IT 尽职调查需要多长时间？”他们可能会说：“噢，现在积压了 90 天，或者 60 天，或者 30 天。”

---

### [00:53:43] Jen Abel

**English:**
There's no backup. If there's a backup, you also don't want it to die and you want it to give an incentive. So this is when you want to truncate contracts to a technology contract and a service contract. Service contract allows you to onboard them, get them prepped, come in and educate all of the users about what they're about to go through. So that then there's an incentive to get that technology piece through. There's all these little things to think about, and I think everyone... Getting to procurement is also creative. And knowing who you're dealing with and how to make their job as easy as humanly possible. Because what you said and what April said is spot on, which is buying is just as hard as selling.

**中文翻译:**
如果没有积压最好。如果有积压，你不想让交易死掉，你想给他们一个动力。这时你可以把合同拆分为“技术合同”和“服务合同”。服务合同允许你先帮他们入驻、做好准备、进来教育所有用户他们即将经历的变化。这样一来，他们就有动力去推进那个技术合同。有很多这样的小细节需要考虑。我认为进入采购阶段也需要创意。要了解你在和谁打交道，以及如何让他们的工作尽可能简单。因为你和 April 说的都非常对：买东西和卖东西一样难。

---

### [00:54:23] Lenny Rachitsky

**English:**
As I'm hearing you describe this, I feel like we might be discouraging people from selling because this feels very not fun. All these steps, all these procurement work, anything you can say to get people to feel like, okay, this is worth it?

**中文翻译:**
听你描述这些，我觉得我们可能会让大家对销售望而却步，因为这听起来一点也不好玩。这么多步骤，这么多采购工作，你有什么话能让大家觉得“好，这一切都是值得的”吗？

---

### [00:54:35] Jen Abel

**English:**
Yes, I can get people very excited by this. Once you are in, you are in. Once you are in, you are now a preferred vendor. You now have the ability to cross over into other business units. You are now the reason that, hey, if your competitor comes in, well, you got there first. So what do you think procurement's going to say? This is why it's so important to get into the enterprise as fast as humanly possible. While it's a headache to get through, if you project manage it, you'll be good. If you make an accountability, just like if you were to go through fundraising. If you are a part of a team that had to raise money, it's no different. There's always some level of due diligence. There's always you doing more of the work than them. That's just enterprise sales. But if you prove value, your hundred thousand dollars deal could be $500,000 next year. Your $500,000 deal could be a million dollars the following year.

**中文翻译:**
有的，我可以让大家兴奋起来。一旦你进去了，你就真的进去了。一旦你进去了，你就成了“首选供应商”。你现在有能力跨入其他业务部门。你现在成了那个“先到者”，如果你的竞争对手想进来，你猜采购会说什么？这就是为什么尽可能快地进入大企业市场如此重要。虽然过程很头疼，但如果你能做好项目管理，就没问题。你要建立责任制，就像融资一样。如果你参与过融资，你会发现这没什么不同。总会有某种程度的尽职调查，总归是你干的活比他们多。这就是企业级销售。但如果你证明了价值，你今年 10 万美元的订单明年可能变成 50 万，后年可能变成 100 万。

---

### [00:55:36] Jen Abel

**English:**
This is where stuff begins to compound, and this is where your growth journey really gets accelerated. So the beauty with enterprise is once you're in, you're in. You beat out your competitor for a short period of time. There is a little bit of a moat there, but it's not forever. You all have intel that no one else will have. Meaning you're a part of the conversations, you have the badge, you can join the meetings, you can ask for introductions. They'll do it. It doesn't feel like sales anymore. You're now a partner. This is why it's so powerful to get into the enterprise because there's so many compounding effects. If you put the effort in on the sales side, the return is insane.

**中文翻译:**
这就是事情开始产生复利的地方，也是你的增长旅程真正加速的地方。所以企业级销售的美妙之处在于：一旦你进去了，你就稳了。你在短时间内击败了竞争对手，那里有一道小小的护城河，虽然不是永久的。你拥有别人没有的情报。这意味着你是对话的一部分，你有工牌，你可以参加会议，你可以要求引荐。他们会配合的。这感觉不再像是销售，你现在是一个合作伙伴。这就是进入大企业如此强大的原因，因为有太多的复利效应。如果你在销售端投入努力，回报是惊人的。

---

### [00:56:20] Lenny Rachitsky

**English:**
That was awesome. Nailed it. I'm excited. Just for folks that are listening, just to calibrate what size of company you're talking about selling to here, what's the size of the advice you've been sharing so far? Roughly?

**中文翻译:**
太棒了，说得太好了。我很兴奋。为了让听众有个概念，你刚才分享的这些建议，针对的主要是多大规模的公司？大概是多少人？

---

### [00:56:33] Jen Abel

**English:**
So I've been talking a lot about enterprise sales, which is I would say anywhere north of 500 to a thousand employees. Just mental model. I'm talking about enterprise sales specifically because there's so much nuance involved in it, because the user and the buyer are very different, right? As you go down market, let's talk about small business for a second. The user and the buyer are the same person. There's no procurement. If they like what you've built, it's pretty straightforward process. In the mid-market, mid-market is a funky place because you either are anchoring towards the lower end of mid-market, which is more upper end of small business, or you're anchoring towards lower end enterprise. Those are two very different divides. So mid-market, just if you're talking about lower end enterprise, again, this is all relative. If you're talking about lower end small business, again, your user and the buyer probably are the same person, which makes sales a lot more streamlined.

**中文翻译:**
我一直在谈论企业级销售，也就是 500 到 1000 人以上的公司。这只是个大致模型。我专门谈论企业级销售是因为它涉及很多细微差别，因为使用者和购买者非常不同，对吧？当你转向低端市场，比如小企业（SMB），使用者和购买者是同一个人。没有采购部门。如果他们喜欢你的产品，流程非常简单。至于中端市场（mid-market），那是个很微妙的地方，因为你要么倾向于中端市场的低端（更接近大型小企业），要么倾向于低端大企业。这是两个完全不同的领域。所以中端市场，如果你谈论的是低端大企业，那情况又不同了。如果你谈论的是低端小企业，使用者和购买者可能还是同一个人，这会让销售流程更精简。

---

### [00:57:31] Jen Abel

**English:**
But churn. Small business, challenge with small business is the churn. If they get pissed off, if they don't feel like it's good enough, they are gone faster than you don't even realize. And they might even tell you. They'll just cancel. And we always see this on Twitter. They'll call American Express and say, cancel these charges. I don't want to talk to these people anymore. They're just more irrational because sometimes maybe it's their money if they're a small business. So small business in mid-market, while sales is a bit faster, you really got to be on the product market fit side, worried about churn.

**中文翻译:**
但是有流失（churn）问题。小企业的挑战在于流失率。如果他们生气了，或者觉得产品不够好，他们消失的速度比你想象的还要快。他们甚至可能都不告诉你，直接取消订阅。我们经常在 Twitter 上看到这种事：他们会打电话给运通公司说“取消这些扣费，我不想再和这些人说话了”。他们更不理性，因为如果是小企业，那可能花的是他们自己的钱。所以，虽然小企业和中端市场的销售速度快一点，但你必须在 PMF 方面下功夫，担心流失问题。

---

### [00:58:07] Lenny Rachitsky

**English:**
And they also go out of business at a higher rate.

**中文翻译:**
而且他们的倒闭率也更高。

---

### [00:58:07] Jen Abel

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:58:07] Lenny Rachitsky

**English:**
And so you have that kind of churn.

**中文翻译:**
所以你会有那种流失。

---

### [00:58:12] Jen Abel

**English:**
A churn piece too. Yeah, exactly.

**中文翻译:**
流失也是一部分。是的，没错。

---

### [00:58:14] Lenny Rachitsky

**English:**
Amazing. Okay. What comes next? So we're kind of in procurement at this point.

**中文翻译:**
太棒了。好，接下来是什么？我们现在大概处于采购阶段。

---

### [00:58:19] Jen Abel

**English:**
Okay, so now we're at signature, right?

**中文翻译:**
好，现在到了签字阶段，对吧？

---

### [00:58:21] Jen Abel

**English:**
Okay. So as you enter procurement, okay, you want to know before you get to the next stage, who is signing this deal? Here are some examples of signers I've seen. Chief financial officer, chief legal officer, the business unit head themselves, the head of procurement. You want to know who that person is so that you can literally say to the head of procurement, hey, listen, I want to make sure this person has everything they need when they review this, to know what they're signing. Who is it and how can I give you a few bullets to share that you can maybe respond to, that we get tight so that they know exactly what they're looking at?

**中文翻译:**
好。当你进入采购阶段时，在进入下一阶段之前，你需要知道：谁来签这个合同？我见过的一些签字人包括：首席财务官（CFO）、首席法务官、业务部门负责人本人、采购主管。你需要知道那个人是谁，这样你就可以直接对采购主管说：“嘿，听着，我想确保那个人在审查合同时拥有所需的一切信息，清楚自己签的是什么。那是谁？我该如何给您提供几个要点，方便您转达或回复，好让他们确切知道自己在看什么？”

---

### [00:58:59] Jen Abel

**English:**
This was two or three years ago, I was involved in getting a deal over procurement that was just truly, it was a pharmaceutical company and it was very, very long process. And we got to the finish line and the CFO was the signature. And this is when I made the mistake. CFO responds back to the procurement lead who sent it to the business unit, who sent it to me and was like, what am I signing? I don't actually understand what these people are doing and why are we doing this?

**中文翻译:**
这是两三年前的事，我参与推进一个通过采购流程的交易，那是一家制药公司，流程非常、非常漫长。我们终于到了终点线，签字人是 CFO。就在这时我犯了个错。CFO 回复了采购主管，采购主管转给了业务部门，业务部门又转给了我，CFO 问：“我签的是什么？我其实并不理解这些人是干什么的，我们为什么要这么做？”

---

### [00:59:32] Jen Abel

**English:**
So then she quickly said to me, hey, listen, we need to defend this. Can you put together some bullets? And I'm like, well, what kind of bullets do I need? What does this person care about? And again, it created so much anxiety and now I'm back in the bottom of the queue. Probably he or she's looking at the things that come in in an order of priority. So now I've elongated this by another month simply because I didn't plan. So this is just to say I'm learning from my own mistake of know who the signature is, because if they don't know what they're looking at, they're going to kick it out and you're going to lose your queue spot.

**中文翻译:**
然后业务部门的人赶紧对我说：“嘿，听着，我们需要为此辩护。你能整理几个要点吗？”我当时想：“额，我需要什么样的要点？这个人关心什么？”这再次造成了巨大的焦虑，而且现在我又回到了队列的最底层。他或她可能会按优先级处理进来的事务。所以，仅仅因为我没有预先计划，我就把这个过程又延长了一个月。所以我想说的是，这是我从自己的错误中学到的：一定要知道签字人是谁，因为如果他们不知道自己在看什么，他们就会把它踢回去，你就会失去排队的位置。

---

### [01:00:06] Lenny Rachitsky

**English:**
So many ways to fail. And this was you selling Jellyfish or this was you working with a company?

**中文翻译:**
失败的方式真是千千万。这是你在卖 Jellyfish 的服务，还是你在帮别的公司？

---

### [01:00:11] Jen Abel

**English:**
This was me helping [inaudible 01:00:15].

**中文翻译:**
这是我在帮（某公司）。

---

### [01:00:15] Lenny Rachitsky

**English:**
Oh man. Okay. Anything else in that step that might be helpful to folks?

**中文翻译:**
噢天哪。好。在那一步还有什么对大家有帮助的吗？

---

### [01:00:19] Jen Abel

**English:**
Yes. One thing to caveat is you do not get paid until you are approved by finance, and procurement has a signature on the contract. Meaning don't start any work. Or if you do start work, know that there is no payment. The business unit can't just pay you. It's paid through a purchase order, which is paid through by finance.

**中文翻译:**
有的。有一点需要提醒：在财务部门批准且采购部门在合同上签字之前，你是拿不到钱的。这意味着不要开始任何工作。或者如果你真的开始了，要明白那是没有报酬的。业务部门不能直接给你打钱，必须通过采购订单（PO），由财务部门支付。

---

### [01:00:45] Lenny Rachitsky

**English:**
So don't rely on that money unless it's finally, unless the signature's on the paper. Quick tangent, thoughts on discounting at any parts of the journey?

**中文翻译:**
所以，除非签字落到纸上，否则不要指望那笔钱。插个话题，你对整个流程中任何阶段的“打折”怎么看？

---

### [01:00:54] Jen Abel

**English:**
If there is a reason as to why. So discounting just to get the deal over the line, you're negotiating with yourself. Unless they ask for it and then ask them to defend it. Certain segments, like small business, you should leave a little bit of room for buffer because sometimes that's their own money. It's like their own small business. Mid-market and enterprise, there's got to be a reason why and ask them. Be like, hey, so if I give you a 30% discount, can I remove 30% of the value? You can kind of play it a little bit like that. I don't recommend it, but that's kind of what they're saying. But discounting is great if they're doing something for you far and beyond. For example, if they're a design partner, if they're going to be a reference for two years, if they're going to give you something far beyond just using the technology, then yeah, I think a discount is a good reason to give back to somebody that's giving to you, but not as a strategy to get a deal done.

**中文翻译:**
除非有正当理由。如果仅仅为了达成交易而打折，那你是在和自己谈判。除非他们主动要求，然后让他们给出理由。在某些细分市场，比如小企业，你应该留一点缓冲空间，因为有时那是他们自己的钱，就像他们自己的小生意。但在中端市场和大企业，必须有理由，并且要问他们。比如：“嘿，如果我给你 30% 的折扣，我能不能减掉 30% 的价值？”你可以稍微这么玩一下。我不推荐这样做，但那本质上就是他们要求的。不过，如果他们为你提供了额外的价值，打折是很棒的。例如，如果他们是设计合作伙伴，或者愿意做两年的案例参考，或者愿意提供除了使用技术之外的其他帮助，那么我认为打折是回馈对方的好理由，但不应将其作为达成交易的策略。

---

### [01:01:57] Lenny Rachitsky

**English:**
Okay. Is there anything beyond this step of getting the signature? Are we done?

**中文翻译:**
好。拿到签字之后还有别的吗？我们算完成了吗？

---

### [01:02:01] Jen Abel

**English:**
Yeah. I hope you celebrate because-

**中文翻译:**
是的。我希望你能庆祝一下，因为……

---

### [01:02:03] Lenny Rachitsky

**English:**
Okay, great. You got a signature from this whole process.

**中文翻译:**
太好了。通过这整个流程，你拿到了签字。

---

### [01:02:08] Jen Abel

**English:**
Yeah. Hopefully I'm not making this sound too daunting. I'm just really trying to lay out all the mistakes I've made.

**中文翻译:**
是的。希望我没把它描述得太吓人。我只是想把我自己犯过的错都摆出来。

---

### [01:02:12] Lenny Rachitsky

**English:**
Yeah, no, this is exactly what people need. This is amazing. And your pep talk was really helpful too. Along the way. What's the general timeline for sales process like this in your experience, with these 500 plus ice companies?

**中文翻译:**
不，这正是大家需要的。这太棒了。你刚才的鼓励也很有帮助。在整个过程中，根据你的经验，针对这些 500 人以上的公司，销售周期通常是多久？

---

### [01:02:26] Jen Abel

**English:**
So there's three things that dictate sales cycle. One is how well are you project managing it? For example, I'll say, let's have our second or third call in two weeks. Two weeks? Do a week. Why are you elongating this? Keep your calls as tight as possible because that shortens your sales cycle. The second is just how complex the organization is. If you're dealing with a highly regulated industry, just know it's going to take a bit longer, sometimes 20 to 30% longer. So a highly regulated industry, nine to 12 months on conservative, on the conservative side. Again, it's tricky because is there a budget line item dictated towards it yet, or are you creating budget? How painful is the problem? And how senior have you gone? If you're talking to the SVP or chief of whatever, they're pretty good at about being able to navigate the traps.

**中文翻译:**
决定销售周期的有三件事。第一，你的项目管理做得多好？例如，我会说：“咱们两周后进行第二次或第三次通话。”两周？一周就行。为什么要拉长战线？尽可能缩短通话间隔，因为这能缩短销售周期。第二，组织的复杂程度。如果你面对的是一个受高度监管的行业，要知道这会花更长时间，有时会多出 20% 到 30%。所以，受高度监管的行业，保守估计需要 9 到 12 个月。再说一次，这很微妙，因为要看是否已经有了预算项，还是你在创造预算？问题有多痛苦？以及你接触的人级别有多高？如果你在和高级副总裁（SVP）或首席某某官交谈，他们通常很擅长避开那些陷阱。

---

### [01:03:28] Jen Abel

**English:**
If you're dealing with a director or mid-level person, they maybe have not purchased something before and just make some internal mistakes. I always say it can range anywhere. I've seen enterprise deals close in 90 days, believe it or not. Rare, but I've seen it. I've also seen enterprise deals typically take anywhere between six and 12 months. Really important but. Enterprises know that the process and the length to get the deal done is what costs more than the technology itself. Meaning the effort it takes to get through their system. That's why they're willing to spend so much. Sometimes that's actually more expensive than the technology itself. So don't negotiate with yourself, understand the value you're delivering, but don't be crazy. I've seen people try and go in with a million dollar deal as a seed stage startup. Oh, interesting thing. So interesting tactic. I've seen contracts in the enterprise that state that the deal cannot exceed more than 20% of the existing revenue.

**中文翻译:**
如果你面对的是总监或中层人员，他们可能以前没买过东西，可能会犯一些内部错误。我总说周期跨度很大。信不信由你，我见过大企业订单在 90 天内成交的。虽然罕见，但我见过。我也见过大企业订单通常需要 6 到 12 个月。但有一点很重要：大企业知道，达成交易所花费的过程和时间成本，往往比技术本身还要贵。也就是说，通过他们内部系统所耗费的精力。这就是为什么他们愿意花这么多钱。有时这确实比技术本身还贵。所以，不要和自己谈判，要理解你交付的价值，但也不要太离谱。我见过种子轮初创公司一上来就想谈 100 万美元的单子。噢，还有件趣事，一个有趣的策略：我见过大企业的合同规定，单笔交易金额不能超过供应商现有收入的 20%。

---

### [01:04:39] Jen Abel

**English:**
So there are these things just to be aware of. In most cases, you can ask them be like, is that a hard line? Is that hard, hard line? Or how negotiable is that? Sometimes it's negotiable. Sometimes it's like, no, this is a hard rule. But then it seems silly because you take a hundred thousand dollar deal and bring it down to 20,000. It's just be careful that you're stripping some of the value out. But I kid you not. I've seen an enterprise deal go from, it lands at 60 and it turns into 280,000 in four months. So again, I want to encourage, yes, this is a lot of work, but the payoff is exponential.

**中文翻译:**
所以这些事情是需要注意的。在大多数情况下，你可以问他们：“这是底线吗？是绝对不能碰的底线吗？还是有商量余地？”有时是可以商量的。有时他们会说：“不，这是硬性规定。”但如果因此把 10 万美元的单子降到 2 万美元，那就显得很傻。要注意不要因此剥离了价值。但我没开玩笑，我见过一个大企业订单从 6 万美元起步，四个月内变成了 28 万美元。所以，我还是想鼓励大家：是的，这很辛苦，但回报是指数级的。

---

### [01:05:19] Lenny Rachitsky

**English:**
What's a good ACV to start with if you're trying to sell to enterprise, to make it all worth it for your startup?

**中文翻译:**
如果你想卖给大企业，为了让初创公司的投入物有所值，一个理想的起始 ACV（年度合同价值）是多少？

---

### [01:05:25] Jen Abel

**English:**
I would say anywhere between 50 to 200K depending on the business unit you're selling to. That's kind of like sweet spot. They're used to something in that realm.

**中文翻译:**
我会说在 5 万到 20 万美元之间，取决于你卖给哪个业务部门。这算是一个“甜点区”。他们习惯于这个范围的价格。

---

### [01:05:35] Lenny Rachitsky

**English:**
And this is a startup selling [inaudible 01:05:38].

**中文翻译:**
这是一个初创公司在卖……

---

### [01:05:37] Jen Abel

**English:**
Early stage startup, like founder led, early stage.

**中文翻译:**
早期初创公司，比如创始人主导的、早期阶段的公司。

---

### [01:05:42] Lenny Rachitsky

**English:**
Initial contract. Wow.

**中文翻译:**
初始合同。哇。

---

### [01:05:42] Jen Abel

**English:**
Yep. Initial contract. I would say, okay, probably caters more towards like 50 to 100K. But I've seen people sell to... Again, it's how big is the problem? Who are you selling it to? Is it the SVP that you started with and they've got a large budget, and it's a pretty healthy business unit? Or are you selling to a director?

**中文翻译:**
是的，初始合同。我会说，可能更多倾向于 5 万到 10 万美元。但我见过有人卖到……再说一次，这取决于问题有多大？你卖给谁？你是从拥有巨额预算和健康业务部门的 SVP 开始谈的吗？还是卖给一个总监？

---

### [01:06:05] Lenny Rachitsky

**English:**
If you're not able to sell your product at that price? What's your advice to teams?

**中文翻译:**
如果你没法以那个价格卖出产品呢？你对这些团队有什么建议？

---

### [01:06:10] Jen Abel

**English:**
If you are a startup, I always ask the founder, did you build this for the enterprise and is that the model you want to play? Or did you build this for small business? Small business is a marketing game. Marketing intensive activity, right? It's high velocity, high volume, lots of dials. It's a very different game than enterprise. So which game do you want to play? Let's just start there. Which game is more attractive to the founder. Or who is more exciting to serve? What's the storyline you want to tell investors? That plays a lot of it into it too. And do you have an enterprise product? Are you solving an enterprise problem or do you think you're solving an enterprise problem but you're not sure yet?

**中文翻译:**
如果你是初创公司，我总是问创始人：你是为大企业开发的吗？那是你想玩的模式吗？还是你是为小企业开发的？小企业是营销的游戏。是营销密集型活动，对吧？高速度、高容量、大量的电话。这和企业级销售是完全不同的游戏。所以你想玩哪种游戏？让我们从这里开始。哪种游戏对创始人更有吸引力？或者服务谁让你更兴奋？你想给投资者讲什么样的故事？这些都有很大影响。你有企业级产品吗？你是在解决企业级问题吗？还是你觉得自己在解决企业级问题但还不确定？

---

### [01:06:53] Lenny Rachitsky

**English:**
And your point is also mid-market is it's rarely to be successful.

**中文翻译:**
你的观点也是，中端市场很难获得成功。

---

### [01:06:57] Jen Abel

**English:**
It's hard to start there because you're straddling two very different go-to-markets, right? One that's of high value, one that's of high volume. And also mid-market companies, this is where a lot of people don't... If it requires heavy integration, they don't have those resources. That's usually outsourced to an Accenture or some of these consulting firms, and now you're having to rely on third parties to be involved. It gets messy.

**中文翻译:**
很难从那里开始，因为你跨越了两个截然不同的进入市场（GTM）策略，对吧？一个是高价值，一个是高容量。而且中端市场公司，这是很多人没意识到的……如果需要繁重的集成工作，他们没有那些资源。那通常会外包给埃森哲或类似的咨询公司，现在你不得不依赖第三方参与。事情会变得很乱。

---

### [01:07:25] Lenny Rachitsky

**English:**
This is fascinating. I have a list of questions from the audience that you pulled from Twitter. You asked on Twitter what questions to ask you as you're coming on here. So there's one that's very related to this, which is someone said, if you're still very early in pre-product market fit, but get initial validation from both small to medium businesses and enterprise, how do you decide which one to focus on? Is there a counter argument against starting or SMB going up market over time like most companies do?

**中文翻译:**
这太有意思了。我有一份从 Twitter 上收集的观众提问。你在 Twitter 上问过大家想问你什么。有一个问题与此密切相关：有人问，如果你还处于非常早期的 PMF 前阶段，但同时从小企业和大企业都获得了初步验证，你该如何决定专注于哪一个？对于像大多数公司那样先从小企业开始，然后随着时间推移转向高端市场的做法，有什么反面论点吗？

---

### [01:07:51] Jen Abel

**English:**
I've seen companies successfully do in both of those motions. Truthfully. We know all of those. We know people that started small business and worked their way up into enterprise and were successful. We've seen people be really successful by starting at the enterprise, like a Wiz. That's more of an internal question, which is like, who did you build this for? Where's the problem most felt and which go-to-market game do you want to play?

**中文翻译:**
我见过公司在这两种模式下都取得了成功。说实话，我们都见过。我们见过从小企业起步，一路打入大企业并获得成功的人。我们也见过像 Wiz 这样从大企业起步并获得巨大成功的人。这更多是一个内部问题：你是为谁开发的？哪里对问题的感受最强烈？你想玩哪种进入市场的游戏？

---

### [01:08:15] Lenny Rachitsky

**English:**
And I think that latter part is so important. It sounds like why should it be what I want? It's like what's going to make a big business? But I think people forget, this is going to be your life for 10 years. Do you want to be selling to enterprises and building all the enterprise features? Would you prefer to build for small companies? Pros and cons to both but it's important to think about the life you're creating for yourself and your team.

**中文翻译:**
我认为后半部分非常重要。听起来像是“为什么非得是我想要的？”难道不应该是“什么能成就大事业”吗？但我觉得人们忘了，这可是你未来 10 年的生活。你想一直向大企业销售并开发所有大企业功能吗？还是你更愿意为小公司开发产品？两者各有利弊，但考虑你为自己和团队创造的生活方式非常重要。

---

### [01:08:36] Jen Abel

**English:**
A hundred percent. And I built my career in enterprise sales, upper-end mid-market enterprise sales, and yeah, that's just the game I know the best.

**中文翻译:**
百分之百同意。我的职业生涯建立在企业级销售、中高端企业级销售上，是的，那是我最擅长的游戏。

---

### [01:08:46] Lenny Rachitsky

**English:**
Yeah, that's also an important part of it. Just to double down on that is like what do you have experience doing? Not like...

**中文翻译:**
是的，那也是重要的一部分。进一步说，就是你有什么样的经验？而不是……

---

### [01:08:52] Jen Abel

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:08:53] Lenny Rachitsky

**English:**
Yeah. Where's the opportunity? Okay. Another question that I love is, and we touched on this initially, but I think it's good to come back to this. Someone said, customers are fascinated with what we're offering from the initial calls, but responsive momentum is too slow from their end. Would be great to know how to fix this.

**中文翻译:**
是的。机会在哪里？好。另一个我很喜欢的问题，虽然我们最初提到过，但我觉得值得再聊聊。有人问：“客户在最初的通话中对我们的产品非常着迷，但他们那边的响应势头太慢了。很想知道如何解决这个问题。”

---

### [01:09:10] Jen Abel

**English:**
Yeah, it's tough because unless you're in the weeds to understand why. I'll give you a few examples that it could be. Did you speak to a buyer who now is trying to sell this up to their boss, and it's just getting sidelined and they don't know the executive value? They've just been selling the buyer value the whole time. That's one reason things can slow down. Another reason things can slow down is you haven't really framed the problem well and they don't understand the full implications of why they need to solve it. So it's kind of just sitting there a little bit. The third is they've just been really nice and it's not going to go anywhere.

**中文翻译:**
是的，这很难，因为除非你深入细节去了解原因。我给你举几个可能的例子。第一，你是不是在和一个买家聊，而他现在正试图向老板推销，结果被搁置了，因为他们不知道“高管价值”？他们一直只在推销“买家价值”。这是进度变慢的一个原因。另一个原因是，你没有把问题描述清楚，他们不理解解决这个问题的全部意义。所以它就一直搁在那儿。第三种情况是，他们只是出于礼貌，其实根本没打算推进。

---

### [01:09:49] Lenny Rachitsky

**English:**
I guess that that's usually the latter. Was that true or it's kind of all over the place?

**中文翻译:**
我猜通常是最后一种。是这样吗？还是各种情况都有？

---

### [01:09:54] Jen Abel

**English:**
It's so hard to give a founder hard feedback. Because they've just dedicated their life to this thing. Who wants to be the bearer of bad news? And sometimes you just need to let the actions speak louder than words.

**中文翻译:**
给创始人负面反馈太难了。因为他们刚刚把生命都奉献给了这件事。谁想当那个报忧的人呢？有时候，你只需要让行动胜过言语。

---

### [01:10:11] Lenny Rachitsky

**English:**
We've talked about all these steps. I'm curious, when you come to a founder or your team, where do you find the most on lock often? Which of the steps of the sales process do you find the biggest opportunity to improve conversion in sales?

**中文翻译:**
我们聊了这么多步骤。我很好奇，当你面对创始人或团队时，你通常在哪里发现最大的突破口？在销售流程的哪些步骤中，你发现了提高销售转化率的最大机会？

---

### [01:10:25] Jen Abel

**English:**
It's qualification. Qualification because if you spend your time on the wrong leads, that equates to a zero. So if you don't get that first level right, let me put it this way, everyone that I know says they have a bottom of funnel problem. It's never a bottom of funnel problem. It's a top of funnel problem. I've actually never seen a bottom of funnel sales problem. It's always qualification, which is a symptom of not reaching out to the right person, not having the right messaging, not solving the right problem, or not being different enough.

**中文翻译:**
是“客户资格审核”（qualification）。因为如果你把时间花在错误的潜在客户身上，结果就是零。如果你第一关没把好，这么说吧，我认识的每个人都说他们有“漏斗底部”的问题。其实从来不是漏斗底部的问题，而是“漏斗顶部”的问题。我其实从未见过真正的漏斗底部销售问题。它总是资格审核的问题，这是没有联系到正确的人、没有正确的信息、没有解决正确的问题，或者不够独特的症状。

---

### [01:11:06] Lenny Rachitsky

**English:**
I love this. So basically the biggest pitfall people fall into, in your experience, is they're just talking to the wrong people, wasting their time?

**中文翻译:**
我喜欢这个观点。所以根据你的经验，人们掉进的最大陷阱基本上就是：一直在和错误的人聊天，浪费时间？

---

### [01:11:15] Jen Abel

**English:**
Yeah. Talking to the wrong people or using the wrong message or...

**中文翻译:**
是的。和错误的人聊天，或者使用错误的信息，或者……

---

### [01:11:20] Lenny Rachitsky

**English:**
Pitching them something they can't actually deliver.

**中文翻译:**
向他们推销一些你实际上无法交付的东西。

---

### [01:11:23] Jen Abel

**English:**
Yeah. Here's the other thing too. Sales is supposed to feel fun for the buyer. They should be like, this feels fun. This person's invigorating. They're going to change my world. They're going to make me see things differently. They're going to get me promoted. They're going to help me increase my influence internally. And so many salespeople are so boring. How many times have you got off a call and you're like, I can't wait to get off this call? And founders too, just like all of a sudden their passion, they go like stone cold face. And it's like bring the passion. Bring the energy. That is felt by the market. Remember, some of these people are in boring jobs. Give them an outlet.

**中文翻译:**
是的。还有一件事。销售应该让买家感到有趣。他们应该觉得：“这很有趣。这个人很有活力。他们会改变我的世界。他们会让我以不同的方式看问题。他们会让我升职。他们会帮我提高内部影响力。”而太多的销售人员太无聊了。你有多少次挂掉电话后想：“我真是一秒钟都不想多聊”？创始人也是，突然间他们的激情消失了，变得面无表情。要带入激情，带入能量。市场能感受到这一点。记住，这些人中有些人的工作很枯燥，给他们一个出口。

---

### [01:12:01] Lenny Rachitsky

**English:**
So along those lines, I think a lot of people are just not... Like me included. I feel weird doing sales. It's a weird experience trying to convince someone to buy something. Is there any advice you could share to get someone over that hump?

**中文翻译:**
说到这儿，我觉得很多人……包括我在内，做销售会觉得很别扭。试图说服别人买东西是一种很奇怪的体验。你有什么建议能帮大家跨过这个坎吗？

---

### [01:12:13] Jen Abel

**English:**
If you have built something that you believe in. Very hard to sell something you don't believe in. I think everyone agrees that. If you've built something you believe in and they have a problem, that's a beautiful thing. Truthfully, that's what makes the world go around, is I have a solution to your problem. Now you just need make sure that the problem, you just need to be honest, that the problem they have, your solution truly can solve for. And you're not short selling just to get a logo and a deal over the line, and see them churn in six months or nine months or three months. That what you are selling is truly going to solve their problem. And be honest about it. I can't tell you enough when I tell someone, listen, I don't think I'm the right fit for you. They try and sell you on them.

**中文翻译:**
如果你做出了你深信不疑的东西。卖你不相信的东西是非常难的，我想大家都同意。如果你做出了你相信的东西，而他们恰好有问题，那是一件美妙的事情。说实话，这就是世界运转的方式：我有一个能解决你问题的方案。现在你只需要确保——你必须诚实——他们的问题，你的方案确实能解决。你不是为了拿个 Logo 或达成交易而贱卖，然后看着他们在六个月、九个月或三个月后流失。你要确保你卖的东西真的能解决他们的问题。并且要诚实。我无法形容当我告诉某人“听着，我觉得我不适合你”时，他们反而会反过来向你推销他们自己。

---

### [01:12:58] Jen Abel

**English:**
They're like, well, wait a second. Hold on. What if we did this, this, and this? And it's like, no, no, no. Here's what we're great at. And then they can say, well, I also need that too. And all of a sudden, this level of trust comes out. And trust is the number one currency in sales. If you are a trusted salesperson, people will recommend you all day and every day. If you're a trusted founder, your market will continually send you leads and word of mouth. So don't try and sell something just to prove to investors you sold something, because it'll be quickly seen on the other side when they churn.

**中文翻译:**
他们会说：“等等，稍等。如果我们这样做、那样做呢？”我会说：“不不不，这是我们擅长的。”然后他们会说：“好吧，我也需要那个。”突然之间，这种信任感就建立了。信任是销售中的头号货币。如果你是一个值得信赖的销售人员，人们会整天、每天都推荐你。如果你是一个值得信赖的创始人，你的市场会不断地为你提供潜在客户和口碑。所以，不要为了向投资者证明你卖出了东西而卖东西，因为当客户流失时，一切都会很快穿帮。

---

### [01:13:32] Lenny Rachitsky

**English:**
Amazing. Okay, Jen, so I'm going to cut the lightning round. I know you also have to run and do real work. So let me give you a chance just to talk about what you do, how you help companies in case folks can find value in working with you.

**中文翻译:**
太棒了。好，Jen，我要跳过闪电问答环节了。我知道你还得赶去处理正事。让我给你个机会聊聊你是做什么的，你是如何帮助公司的，万一听众觉得和你合作有价值呢。

---

### [01:13:44] Jen Abel

**English:**
Deeply passionate about sales, as I'm sure you can tell. We specifically help founders through this pain. Navigating enterprise sales, mid-market sales, and really trying to crack that first million of ARR. Or sometimes even that first 500K of ARR if they move fast enough. And it is really hard. It's counterintuitive to what most people think, but it can be really, really fun when we show you the way.

**中文翻译:**
正如你所见，我对销售充满激情。我们专门帮助创始人度过这种痛苦。引导他们进行企业级销售、中端市场销售，并真正尝试突破第一个 100 万美元 ARR。或者如果他们动作够快，突破第一个 50 万美元 ARR。这确实很难，也违背大多数人的直觉，但当我们为你指明道路时，它会变得非常、非常有意思。

---

### [01:14:13] Lenny Rachitsky

**English:**
And you described to me how it works, and I think it's important to clarify this. You basically embed with the team and help them do this.

**中文翻译:**
你向我描述过它是如何运作的，我觉得有必要澄清一下：你基本上是嵌入到团队中，帮助他们完成这些工作。

---

### [01:14:19] Jen Abel

**English:**
Yes. So I fundamentally do not believe in outsourcing the heartbeat of the organization, which is sales. So what we do is we embed alongside the founder and drive a lot of the execution, but make sure that they are the tip of the spear engaging directly with their market, and learning directly from the market's mouth, not playing this game of telephone.

**中文翻译:**
是的。我从根本上不相信外包组织的“心脏”，也就是销售。所以我们做的是与创始人并肩作战，推动大量的执行工作，但确保他们是直接与市场互动的“矛头”，直接从市场口中学习，而不是玩那种“传声筒游戏”。

---

### [01:14:40] Lenny Rachitsky

**English:**
Amazing. And I mentioned this when we were chatting, but I think of it again, is when I was interviewing all these companies about how they started selling early on. One of the interesting threads that I heard again and again, is how many of them hired a coach or a consultant as a founder to help them learn to do sales. And that's essentially what you do. And I didn't even know a service like this existed, so this is super cool. It'll point people to what you do. I also have to ask you, the question I ask everyone at the end is just, how can listeners be useful to you?

**中文翻译:**
太棒了。我们聊天时我提到过，现在我又想起来了：当我采访所有这些公司关于他们早期如何开始销售时，我一再听到的一个有趣线索是，有多少创始人在早期雇佣了教练或顾问来帮助他们学习销售。而这正是你所做的。我甚至不知道还有这样的服务存在，所以这超级酷。这会让大家关注到你的工作。最后我还要问你一个我问每个人的问题：听众能为你做些什么？

---

### [01:15:08] Jen Abel

**English:**
Help each other out. I think so many people have helped me in my career, and in this journey, that the pay it forward model that exists in the technology space is so beautiful. So just don't let that die.

**中文翻译:**
互相帮助。在我的职业生涯和这段旅程中，有太多人帮助过我，科技领域这种“薪火相传”（pay it forward）的模式非常美好。所以，请不要让这种精神消失。

---

### [01:15:28] Lenny Rachitsky

**English:**
Beautiful. Well, Jen, thank you so much for being here.

**中文翻译:**
太美好了。Jen，非常感谢你能来。

---

### [01:15:32] Jen Abel

**English:**
Lenny, this was awesome. Thank you so much for having me.

**中文翻译:**
Lenny，这太棒了。非常感谢你邀请我。

---

### [01:15:34] Lenny Rachitsky

**English:**
So awesome. So excited for folks to hear it. I've learned a ton. Okay, I'll let you go. Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lennyspodcast.com. See you in the next episode.

**中文翻译:**
太棒了。很高兴能让大家听到。我学到了很多。好，我就不耽误你了。大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。另外，请考虑给我们评分或留下评论，这能极大地帮助其他听众找到这个播客。你可以在 Lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。