# Jerry Colonna - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Jerry Colonna.

---

### [00:00:00] Jerry Colonna

**English:**
We're socialized to bullshit not only ourselves, but everybody else, especially in the entrepreneurial community. All our companies are moving up into the right. Every product is working. We don't really have any problems because we're crushing it, and that's just a lie. The question that I often ask is how have I been complicit in creating the conditions I say I don't want. The purpose of this question is actually to evoke your own agency. A perfect example of that would be, I say I don't want to feel busy all the time, but the truth of the matter is I feel really unnerved and disconcerted if my agenda isn't jam-packed. So if you want to create a high-functioning team, do your work, and it starts with the person who has the most power.

**中文翻译:**
我们被社会化去欺骗自己，也欺骗别人，尤其是在创业圈。我们所有的公司都在稳步增长，每一款产品都很成功。我们觉得自己没有任何问题，因为我们正大获全胜，但这只是个谎言。我经常问的一个问题是：我是如何“同谋”创造了那些我口口声声说不想要的条件的？这个问题的目的实际上是为了唤起你自己的主观能动性。一个完美的例子是：我说我不希望整天忙忙碌碌，但事实是，如果我的日程表没排满，我会感到非常不安和困惑。所以，如果你想建立一支高效的团队，请先做好你自己的功课，而这一切要从权力最大的人开始。

---

### [00:00:49] Lenny Rachitsky

**English:**
Today, my guest is Jerry Colonna. Jerry is one of the most well-known and respected executive coaches in the world. He's co-founder and CEO of Reboot, an executive and leadership development firm grounded in the belief that better humans make better leaders. Prior to coaching, Jerry co-founded Flatiron Partners with Fred Wilson, which ended up being one of the most successful early-stage investment funds in the world. He's also a partner at JPMorgan Chase and the author of two books, Reboot and Reunion. As you might expect, this ended up being a very real and very open conversation about being busy and self-inquiry and the dangers of a growth mindset and the reasons that leaders and teams most often fail, and it's not what you think. Also, we talk about a very simple equation that Jerry and his team use to cultivate great leaders.

**中文翻译:**
今天的嘉宾是 Jerry Colonna。Jerry 是全球最知名、最受尊敬的高管教练之一。他是 Reboot 的联合创始人兼 CEO，这是一家高管和领导力发展公司，其核心理念是“更好的人成就更好的领导者”。在从事教练工作之前，Jerry 与 Fred Wilson 共同创立了 Flatiron Partners，这后来成为了世界上最成功的早期投资基金之一。他还是摩根大通的合伙人，并著有《重启》（Reboot）和《重聚》（Reunion）两本书。正如你所预料的，这最终成为了一场关于忙碌、自我探究、成长型思维的危险，以及领导者和团队失败最常见原因的非常真实且开放的对话，而且原因并非你所想的那样。此外，我们还讨论了 Jerry 和他的团队用来培养优秀领导者的一个非常简单的等式。

---

### [00:01:37] Lenny Rachitsky

**English:**
This is an episode that everybody should listen to and spend time with. It'll make you a better person, a better partner, and a better leader. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you now get a year free of Linear, Superhuman, Notion, Perplexity, and Granola. Check it out at lennysnewsletter.com and click bundle. With that, I bring you Jerry Colonna.

**中文翻译:**
这一集每个人都应该花时间听听。它会让你成为一个更好的人、更好的伴侣和更好的领导者。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯的年度订阅者，你现在可以免费获得一年 Linear、Superhuman、Notion、Perplexity 和 Granola 的使用权。请访问 lennysnewsletter.com 并点击“bundle”查看。下面，让我们欢迎 Jerry Colonna。

---

### [00:02:05] Lenny Rachitsky (Ad: Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next-generation A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams. Companies like Twitch, Miro, ClickUp and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and for understanding the performance of new features. And Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依赖 Eppo 来支持他们的实验。实验对于推动增长和了解新功能的表现越来越重要。Eppo 能够帮助你提高实验速度，同时解锁其他商业工具无法提供的严谨深度分析。

---

### [00:02:35] Lenny Rachitsky (Ad: Eppo continued)

**English:**
When I was at Airbnb, one of the things that I loved most was our experimentation platform where I could set up experiments easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more with advanced statistical methods that can help you shave weeks off experiment time and accessible UI for diving deeper into performance and out-of-the-box reporting that helps you avoid annoying prolonged analytics cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the A/B testing flywheel. Eppo powers experimentation across every use case, including product, growth, machine learning, monetization, and email marketing. Check out Eppo at geteppo.com/lenny and 10X your experiment velocity. That's geteppo.com/lenny.

**中文翻译:**
当我在 Airbnb 时，我最喜欢的事情之一就是我们的实验平台，在那里我可以轻松地设置实验、排除故障并独立分析表现。Eppo 不仅能做到这些，还拥有先进的统计方法，可以帮你缩短数周的实验时间，其易用的界面可用于深入研究表现，开箱即用的报告能帮你避免烦人的漫长分析周期。Eppo 还能让你轻松地与团队分享实验见解，激发 A/B 测试飞轮的新想法。Eppo 支持各种场景的实验，包括产品、增长、机器学习、变现和邮件营销。请访问 geteppo.com/lenny 查看 Eppo，让你的实验速度提升 10 倍。网址是 geteppo.com/lenny。

---

### [00:03:22] Lenny Rachitsky (Ad: Contentsquare)

**English:**
This episode is brought to you by Contentsquare, the analytics platform that helps companies build better digital experiences. Ever wonder why customers drop off before converting or why some pages perform better than others? Contentsquare takes the guesswork out of digital experiences, giving you real-time insights into how users interact with your site or app. With AI-powered analytics, automatic frustration detection, and clear visualizations, you'll know exactly what's working and what's holding your customers back. Whether you're optimizing an e-commerce checkout, refining a B2B lead flow, or improving a mobile app experience, Contentsquare pinpoints exactly what needs fixing and why. Contentsquare powers better customer journeys across 1.3 million websites and apps. Discover the insights you've been missing at contentsquare.com/lenny. Jerry, thank you so much for being here and welcome to the podcast.

**中文翻译:**
本集节目由 Contentsquare 赞助，这是一个帮助公司打造更好数字体验的分析平台。有没有想过为什么客户在转化前流失，或者为什么某些页面的表现优于其他页面？Contentsquare 消除了数字体验中的猜疑，为你提供用户如何与你的网站或应用互动的实时见解。通过 AI 驱动的分析、自动挫败感检测和清晰的可视化，你将确切知道哪些环节有效，哪些环节阻碍了客户。无论你是在优化电商结账、完善 B2B 潜在客户流程，还是改进移动应用体验，Contentsquare 都能精准指出需要修复的地方及其原因。Contentsquare 为 130 万个网站和应用的客户旅程提供支持。请访问 contentsquare.com/lenny，发现你一直错过的见解。Jerry，非常感谢你能来到这里，欢迎参加播客。

---

### [00:04:19] Jerry Colonna

**English:**
Well, thanks for having me, Lenny. It's really a delight to meet you and to be with you today.

**中文翻译:**
谢谢你的邀请，Lenny。很高兴见到你，也很高兴今天能和你在一起。

---

### [00:04:24] Lenny Rachitsky

**English:**
I want to start with a very classic Jerry Colonna piece of advice that I've heard you share in other places, and I just want more people to hear this advice, and this is a question that you ask people when things aren't going their way, and I'll give you a hint. The question contains the word complicit.

**中文翻译:**
我想从一个非常经典的 Jerry Colonna 式建议开始，我听你在其他地方分享过，我希望更多人能听到这个建议。这是你在事情进展不顺时会问别人的一个问题，我给你个提示，这个问题里包含“同谋”（complicit）这个词。

---

### [00:04:40] Jerry Colonna

**English:**
Right.

**中文翻译:**
没错。

---

### [00:04:41] Lenny Rachitsky

**English:**
Can you share this question and why it's so important to ask this of yourself?

**中文翻译:**
你能分享一下这个问题吗？为什么对自己问这个问题如此重要？

---

### [00:04:45] Jerry Colonna

**English:**
The question that I often ask is how have I been complicit in creating the conditions I say I don't want? And if it's helpful, let me break down the question a little bit.

**中文翻译:**
我经常问的问题是：我是如何“同谋”创造了那些我口口声声说不想要的条件的？如果对你有帮助的话，让我稍微拆解一下这个问题。

---

### [00:04:55] Lenny Rachitsky

**English:**
Please.

**中文翻译:**
请讲。

---

### [00:04:58] Jerry Colonna

**English:**
So I purposely chose the word complicit because complicit does not mean responsible, and that's a really important distinction. And as I often say, to understand the word complicit, think of the word accomplice. As I will share, you are driving the getaway car, you're not sticking up the bank teller. The second half of that question is I say I don't want. And sometimes people hear that question and they interpret it as, how have I been responsible for the shit in my life? And that is not the purpose of this question. The purpose of this question is actually to evoke your own agency, is to look at the ways in which you may have been diluting yourself.

**中文翻译:**
我特意选择了“同谋”这个词，因为“同谋”并不等同于“负责”，这是一个非常重要的区别。正如我常说的，要理解“同谋”，可以想想“帮凶”这个词。我会说，你是在开那辆逃跑用的车，而不是在抢劫银行出纳员。问题的后半部分是“我口口声声说不想要”。有时人们听到这个问题，会把它解读为：“我是如何对我生活中的烂事负责的？”但这并不是这个问题的目的。这个问题的目的实际上是为了唤起你自己的主观能动性，去审视你可能在哪些方面欺骗了自己。

---

### [00:05:56] Jerry Colonna

**English:**
A perfect example of that would be, I say I don't want to feel busy all the time, but the truth of the matter is I feel really unnerved and disconcerted if my agenda isn't jam-packed. And the reason that this is all really important is part of my approach not only to coaching, but to the process of growing up, is to use what I call radical self-inquiry, to really cut through our own delusions and say, how does it serve me to feel completely busy to the point where I feel exhausted? And perhaps there's another more conscious way of getting that feeling than feeling like crap all the time.

**中文翻译:**
一个完美的例子是：我说我不希望整天忙忙碌碌，但事实是，如果我的日程表没排满，我会感到非常不安和困惑。这一切之所以重要，是因为我的方法——不仅是教练方法，也是成长的过程——是使用我所谓的“激进的自我探究”（radical self-inquiry），去真正看穿我们自己的幻觉，并问自己：让自己忙到精疲力竭对我有什么好处？也许除了让自己感觉糟糕透顶之外，还有另一种更清醒的方式来获得那种成就感。

---

### [00:06:56] Lenny Rachitsky

**English:**
This is a good segue to something that I hear you. You have this equation that you and your firm use to think about how to create and cultivate great leaders, and it includes one of the variables is radical self-inquiry. Can you share this equation and just how you work with folks to build this in them?

**中文翻译:**
这正好可以引出我听你提到过的一件事。你和你的公司有一个等式，用来思考如何创造和培养优秀的领导者，其中一个变量就是“激进的自我探究”。你能分享一下这个等式，以及你是如何帮助人们建立这种能力的吗？

---

### [00:07:14] Jerry Colonna

**English:**
Sure. I'll tell a little story about that. I remember one time I was, this is how the equation came to be. I was doing a talk, I think here in Boulder at Naropa University where I used to be on the board of trustees. It's a Buddhist university, and as is often the case, I'm winging it as I go and I'm walking around probably without shoes on because that's what I do. And there was a dry erase board behind me and I was trying to explain what it was that I do, what it was that I encourage people to do. And I jumped up at the board and I wrote practical skills. And in writing that, what I was trying to convey, what it is that people typically come to a coach for. They want to understand how to do their job. They want to understand how to live. They want to understand the how.

**中文翻译:**
当然可以。我来讲个小故事。我记得有一次，这就是那个等式的由来。我当时在博尔德的纳罗帕大学（Naropa University）做演讲，我曾是那里的校董。那是一所佛教大学，通常情况下，我都是随兴发挥，可能还没穿鞋走来走去，因为我就是那样的人。我身后有一块白板，我试着解释我所做的事情，以及我鼓励人们去做的事情。我跳到白板前，写下了“实际技能”（practical skills）。写下这个词时，我想表达的是人们通常找教练是为了什么。他们想知道如何做工作，想知道如何生活，他们想知道“如何做”（the how）。

---

### [00:08:11] Jerry Colonna

**English:**
And then, I wrote plus, and then I sketched out radical self-inquiry. And I said in that moment, I said, "People will come and ask me how, and I will drive them crazy because I will say something like, tell me about your father, or tell me why you chose to be in the job you're in the first place, or tell me about your relationship to money, or tell me about your relationship to self-worth." And then, I expanded it and I put another plus sign and I said, "Shared experiences." And then, I drew an equals equation line underneath the whole thing, and I said, "Enhanced leadership plus greater resiliency."

**中文翻译:**
然后，我写了一个“加号”，接着写下了“激进的自我探究”。我当时说：“人们会来问我‘如何做’，而我会让他们发疯，因为我会说类似这样的话：‘跟我说说你父亲吧’，或者‘告诉我你最初为什么选择这份工作’，或者‘告诉我你与金钱的关系’，或者‘告诉我你与自我价值感的关系’。”接着，我扩展了它，又加了一个加号，写下“共同经历”（shared experiences）。最后，我在下面画了一条等号线，写道：“卓越的领导力 + 更强的韧性”。

---

### [00:09:05] Jerry Colonna

**English:**
And so, the equation is practical skills plus radical self-inquiry plus shared experiences, that is the process of actually talking about the craziness that goes on in your head equals greater leadership. That all makes sense. But then, there was this other piece, enhanced resilience. And when I do this on a dry erase board, I will often circle that phrase, and I say that is the purpose of this whole thing, because the truth is, if you follow my story at all, you know that in my late 30s, the depression that had really marked most of my life had gotten so bad that despite my outward success, I was suicidal and lost.

**中文翻译:**
所以，这个等式就是：实际技能 + 激进的自我探究 + 共同经历（即真正谈论你脑子里那些疯狂想法的过程）= 卓越的领导力。这听起来很合理。但还有另一部分，即“更强的韧性”。当我在白板上写这个时，我经常会圈出这个短语，并说这就是整件事的目的。因为事实是，如果你了解我的故事，你会知道在我 30 多岁快 40 岁时，伴随我大半辈子的抑郁症变得非常严重，尽管表面上很成功，但我当时却有自杀倾向且迷失了方向。

---

### [00:09:58] Jerry Colonna

**English:**
And I will turn to the audience and I say, "I get you want to be a great CEO, I get you want to be a great executive, but what I really care about is you not killing yourself in the process." So if we take a step back, the whole point of what we refer to as the equation really boils down to that point, how do we grow up and become the leaders, the adults we were born to be without feeling like crap?

**中文翻译:**
我会转向观众说：“我明白你想成为一名伟大的 CEO，我明白你想成为一名伟大的高管，但我真正关心的是你在这个过程中不要自寻短见。”所以，如果我们退一步看，我们所谓的这个等式的全部意义其实就归结为一点：我们如何成长并成为我们天生该成为的领导者和成年人，而在这个过程中不至于感到生不如死？

---

### [00:10:31] Lenny Rachitsky

**English:**
And there's this huge implication here that a lot of people think that when they reach a certain point, become successful, make a certain amount of money, get a beautiful house, still be happy. And essentially what you're saying here is that's very often not the case. Maybe in most cases, not the case.

**中文翻译:**
这里有一个巨大的暗示，即很多人认为当他们达到某个点，变得成功，赚到一定数量的钱，买到漂亮的房子，就会感到幸福。而你在这里基本上是说，情况往往并非如此。也许在大多数情况下，都不是这样。

---

### [00:10:48] Jerry Colonna

**English:**
It's not only not the case, it's the big lie that we're socialized with since childhood. I remember one time I was on the road doing a talk for, I was promoting my first book, Reboot, and I was at, I think it's called the Fitler Club in Philadelphia. I was doing a fireside chat. And after talking with my conversation partner, a guy named Chris Fralic who was one of the co-founders at First Round, really, really good guy. We turned to the audience and there was a Q&A as there often is, and this young guy shoots his hand up and he introduces himself and he says, "I'm 19." And he looks over to his right and his mother's sitting there and he says, "And my mother brought me here," which I laughed.

**中文翻译:**
不仅不是这样，这还是我们从小就被灌输的弥天大谎。我记得有一次我在巡回演讲推广我的第一本书《重启》，我在费城的一家叫 Fitler Club 的地方做炉边谈话。在与我的对话伙伴 Chris Fralic（First Round 的联合创始人之一，一个非常好的人）交谈后，我们转向观众进行问答环节。一个年轻人举起手自我介绍说：“我 19 岁。”他看了看右边坐着的母亲说：“是我妈妈带我来的。”我听了哈哈大笑。

---

### [00:11:40] Jerry Colonna

**English:**
And he said, "So what you're telling me is you don't have to be an asshole to be successful." And I could not think of a better summation of everything that I'm about than for a 19-year-old kid to look up and say, "You don't have to be an asshole to be successful." And of course, the corollary to that is you don't have to feel miserable just because you're trying to create a career.

**中文翻译:**
他说：“所以你告诉我的意思是，你不需要成为一个混蛋也能成功。”我想不出比这更好的总结了——一个 19 岁的孩子抬头说：“你不需要成为一个混蛋也能成功。”当然，由此得出的推论是，你不需要仅仅因为在开创事业就感到痛苦不堪。

---

### [00:12:12] Lenny Rachitsky

**English:**
As people start to think about this and think, okay, I feel like I've been heading in this direction of I just need to keep climbing the ladder, making more money, as they hear you talk, what's the pivot that folks should make in their mind around where they should actually be heading? What is a direction where they'll end up not wanting to kill themselves, in spite of being successful?

**中文翻译:**
当人们开始思考这个问题并意识到：“好吧，我感觉我一直朝着这个方向走，只是不断往上爬，赚更多的钱。”当他们听到你这么说时，他们应该在脑海中做出什么样的转变，去思考他们真正应该走向何方？什么样的方向能让他们在获得成功的同时，最终不会产生轻生的念头？

---

### [00:12:34] Jerry Colonna

**English:**
To be clear, not everyone ends up in that level of depression, but the hack, if you will, is consciousness. So what do I mean by that? Part of what makes radical self-inquiry radical is we're socialized not to ask certain kinds of questions. So for example, someone says, "It's really important for me to be ambitious and achieve a particular goal." What's radical, a radical question to ask is, and what will that do for you? What is it that you believe being "successful" will do for you? How do you define success? Where does that come from?

**中文翻译:**
需要明确的是，并非所有人都会陷入那种程度的抑郁，但如果说有什么“秘诀”的话，那就是“觉知”（consciousness）。我这么说是什么意思呢？“激进的自我探究”之所以激进，部分原因在于我们被社会化成不去问某些类型的问题。例如，有人说：“对我来说，有野心并实现某个特定目标非常重要。”那么激进的问题是：“那会为你带来什么？你认为‘成功’会为你带来什么？你如何定义成功？这种定义从何而来？”

---

### [00:13:30] Jerry Colonna

**English:**
In Reboot, my first book, I tell the story of what I refer to as my pursuit of lemon drops. And briefly, when I was a boy, there was a lot... I grew up with an enormous amount of chaos and insecurity, financial and otherwise. And a big source of stability in my life were my mother's parents, my grandfather and grandmother. And Grandpa Guido, who was an ice man and emigrated from southern Italy in early 20th century, always seemed to have, well, he had this endless supply of lemon drops, and they were always kept in this green pantry outside of the kitchen. And for me, the stability and what I considered wealth seemed to match to this notion of this endless supply of lemon drops. And when I got to my 30s and I was outwardly successful and I was a hot shot BC, I had lemon drops, but I didn't feel safe, which was a mindful.

**中文翻译:**
在我的第一本书《重启》中，我讲了一个我称之为“追求柠檬糖”的故事。简而言之，当我还是个孩子的时候，我的成长环境充满了混乱和不安全感，无论是财务上还是其他方面。我生活中一个重要的稳定来源是我外公外婆。我的外公 Guido 是个送冰人，20 世纪初从意大利南部移民过来，他似乎总是有……他有源源不断的柠檬糖，总是放在厨房外面的那个绿色储藏柜里。对我来说，那种稳定感和我所认为的财富，似乎就等同于这种源源不断的柠檬糖。当我到了 30 多岁，表面上很成功，是个顶尖的风投家时，我拥有了“柠檬糖”，但我并没有感到安全，这让我陷入了沉思。

---

### [00:15:02] Jerry Colonna

**English:**
And so, I told that story in Reboot as part of my exploration into the core question of how did my relationship to money shape my career choices, shape my school choices, shape my own sense of safety and self-worth? So long-winded response to your question, what I encourage people to do is to ask themselves these kinds of questions so that they can raise their level of consciousness so that they can be in the driver's seat of their lives and not some learned behavior that they developed as a child to answer perhaps their parents or grandparents' anxieties.

**中文翻译:**
所以，我在《重启》中讲了那个故事，作为我对核心问题探索的一部分：我与金钱的关系如何塑造了我的职业选择、学校选择，以及我自己的安全感和自我价值感？所以，长话短说，我鼓励人们去做的是问自己这类问题，从而提高他们的觉知水平，让他们能够掌控自己的人生，而不是被童年时期为了应对父母或祖父母的焦虑而养成的某种习得行为所左右。

---

### [00:15:56] Lenny Rachitsky

**English:**
I feel like a lot of people hearing this are afraid to ask these sorts of questions. The reason they don't ask these questions is because they worry that this is going to be like, okay, I got to quit my job, move to the woods, give up all these luxuries they have. I don't even want to think about that. I got a whole family to support. I got to succeed. Advice for getting over that hump of just like-

**中文翻译:**
我觉得很多人听到这些会害怕问这类问题。他们不问的原因是担心这会导致：“好吧，我得辞职，搬到森林里去，放弃我现在拥有的一切奢侈品。”我甚至不想去想那些。我有一大家子要养活，我必须成功。对于如何跨过这个坎，你有什么建议吗？

---

### [00:16:17] Jerry Colonna

**English:**
So let's just pause, Lenny. Okay, so what you're doing in this moment is empathetically imagining what may be going on for your listener, but the empathy is actually based on your own question because you invited me on the show, you knew I was going to get to this point. So I'm imagining that as you take this in, that thought stream shows up for you. "Jerry," says Lenny, "If I open up that closet, all the shit's going to fall out, and what am I going to do with it?" Does that resonate at all?

**中文翻译:**
让我们先停一下，Lenny。你现在是在共情地想象听众可能会有的想法，但这种共情实际上是基于你自己的疑问，因为你邀请我参加节目，你知道我会谈到这一点。所以我猜当你听这些时，你脑子里也出现了这样的念头：“Jerry，”Lenny 说，“如果我打开那个壁橱，所有的烂事都会掉出来，那我该怎么办？”这能引起你的共鸣吗？

---

### [00:16:58] Lenny Rachitsky

**English:**
This is why I was nervous to have you on this podcast. I knew what you-

**中文翻译:**
这就是为什么我邀请你参加播客时会感到紧张。我知道你会——

---

### [00:17:05] Jerry Colonna

**English:**
So answer my question.

**中文翻译:**
所以回答我的问题。

---

### [00:17:07] Lenny Rachitsky

**English:**
I don't think it's that strong for me to be afraid of that because I've taken a different path already and gotten off the career ladder climbing treadmill. On the other hand, back to your original question, we talked about being busy. I'm very guilty of that. I'm constantly trying to do less, but constantly doing more, and my life is just very busy.

**中文翻译:**
我不觉得那种恐惧对我来说有那么强烈，因为我已经走上了一条不同的道路，跳出了职业阶梯的跑步机。另一方面，回到你最初的问题，我们谈到了忙碌。我对此深感愧疚。我一直在努力少做点事，但却一直在做更多的事，我的生活非常忙碌。

---

### [00:17:28] Jerry Colonna

**English:**
Thank you for giving me more of that answer. And trust me, your listeners are going to appreciate you being fully there in just the way you were. So let's take a step back. The fear is, if I can reflect back to your original question, the fear is if I go there, I don't know what's going to happen as a consequence of that. If I pause and ask myself, is this relationship working out for me? I might end up leaving this relationship. If I pause and ask myself if this career isn't working for me, I might leave my career.

**中文翻译:**
谢谢你给我更深入的回答。相信我，你的听众会感激你刚才那样全身心地投入。让我们退一步看。恐惧在于——如果我能回应你最初的问题——恐惧在于如果我深入探究，我不知道后果会怎样。如果我停下来问自己：这段关系对我来说真的合适吗？我最终可能会离开这段关系。如果我停下来问自己这份职业是否真的适合我，我可能会离开我的职业。

---

### [00:18:25] Jerry Colonna

**English:**
And the good news bad news is that's true. That is absolutely true. And if we look at some of the other observations we were making before like anxiety and depression, we have this belief system that if I pay no attention to the thing that I'm afraid of, it's somehow going to magically go away. If we pay no attention to the source of discomfort, it's somehow going to go away. And that's not actually how life works. More often than not, what we do is we respond to the source of challenge, whether it's a discomfort in our relationship, whether it's a discomfort in the way my life has unfolded. We respond to it by plasting over band-aids and sometimes they're relatively healthy, we become obsessed with working out, or sometimes they're unhealthy. We become obsessed with work or substance abuse or that kind of thing. Or sometimes, and this is super popular right now, we lean into what I would call as a spiritual bypassing where we go to Peru and we go do ayahuasca or we spend the weekend doing mushrooms with friends...

**中文翻译:**
好消息也是坏消息是：那是真的。那是绝对的事实。如果我们看看之前提到的一些观察，比如焦虑和抑郁，我们有一种信念系统，认为如果我不去理会我害怕的事情，它就会以某种方式神奇地消失。如果我们不去理会不适的根源，它就会消失。但生活并非如此。通常情况下，我们应对挑战源的方式——无论是关系中的不适，还是生活展开方式中的不适——都是贴上创可贴。有时这些方式相对健康，比如我们变得痴迷于健身；有时则不健康，比如我们变得痴迷于工作、药物滥用之类的。或者有时（这在当下非常流行），我们倾向于我所谓的“灵性逃避”（spiritual bypassing），比如去秘鲁喝死藤水，或者周末和朋友一起吃蘑菇……

---

### [00:20:08] Jerry Colonna

**English:**
And what we're really not doing, Lenny, is confronting the parts of ourselves that need some tending to because we're afraid of the consequences. But I'll tell you a quick quote. One of my favorite books is Bruce Springsteen's autobiography, and about in the middle of the book, he has this passage where he talks about having spent 25 years in psychoanalysis. So let me just let that statement land. Bruce fucking Springsteen, 25 years in psychoanalysis. And he has this passage where he talks about the unsorted baggage of our childhood. And what he rightly asserts is that we all have unsorted baggage, and at some point we're going to pay the price of not sorting that baggage. And the price more often than not is in tears.

**中文翻译:**
Lenny，我们真正没做的是去面对那些需要照料的自我部分，因为我们害怕后果。但我给你引用一段话。我最喜欢的书之一是布鲁斯·斯普林斯汀（Bruce Springsteen）的自传，书的中部有一段话，他谈到自己接受了 25 年的心理分析。让我重复一遍：布鲁斯·斯普林斯汀，接受了 25 年的心理分析。他在那段话中谈到了童年时期“未整理的包袱”。他正确地断言，我们都有未整理的包袱，在某个时刻，我们会因为没有整理这些包袱而付出代价。而这个代价往往是泪水。

---

### [00:21:21] Jerry Colonna

**English:**
Now, this is Bruce Springsteen talking about this. This is not some airy-fairy transpersonal Jerry Colonna coach. And the reason I draw that out is we as children are socialized not to develop these consciousness skills. We are socialized to develop what I would call bypassing skills. And as he correctly points out, if you continue to bypass sorting out your baggage, there's going to come a day where you're going to have to pay that price. It could be in your own depression, it could be in, I've seen this a thousand times Lenny, entrepreneurs sabotaging their successful businesses because the belief system from their childhood goes something like, I don't deserve success so let me blow it up. We put this all under the rubric of midlife, but I don't know, when does midlife begin, 35? When does it end, 70? What I do know is it's the bulk of our adulthood.

**中文翻译:**
这可是布鲁斯·斯普林斯汀说的，不是什么玄之又玄的超个人教练 Jerry Colonna 说的。我之所以提这个，是因为我们从小就被社会化成不去培养这些觉知技能。我们被社会化去培养我所谓的“逃避技能”。正如他正确指出的，如果你继续逃避整理你的包袱，总有一天你必须付出代价。这可能是你自己的抑郁，也可能是——Lenny，我见过无数次这种情况——创业者破坏自己成功的生意，因为他们童年的信念系统在说：“我不配获得成功，所以让我毁掉它吧。”我们把这些都归类为“中年危机”，但我不知道中年什么时候开始，35 岁？什么时候结束，70 岁？我只知道这是我们成年生活的大部分时间。

---

### [00:22:46] Lenny Rachitsky

**English:**
Okay, I think you've done an excellent job convincing me and others to spend time on this now, and I think there's an assumption of it gets harder, the tears get more intense as you wait longer. There's this ticking time bomb that better some amount of tears now than 10 times more tears later. Is that right?

**中文翻译:**
好吧，我想你已经成功说服了我和其他人现在就花时间在这上面。我想有一种假设是，等待的时间越长，事情就越难，泪水就越猛烈。就像一个定时炸弹，现在流一些泪总比以后流十倍的泪要好。对吗？

---

### [00:23:04] Jerry Colonna

**English:**
Well said.

**中文翻译:**
说得好。

---

### [00:23:06] Lenny Rachitsky

**English:**
Okay. So coming back to this equation, I think I want to give people some things to do now that they may be likely convinced, okay, I should really rethink what I'm doing. So back to the equation, practical skills plus radical self-inquiry plus shared experiences equals enhanced leadership and greater resilience. So the three things you can work on are practical skills, radical self-inquiry, shared experiences, skills I think people get. So radical self-inquiry, these are essentially questions to dig into what drives you, what makes you happy. What are some questions again that people should be asking there as they're listening or maybe after they finish listening?

**中文翻译:**
好。回到这个等式，我想给那些可能已经被说服、觉得“好吧，我真的应该重新思考我在做什么”的人一些具体可做的事情。回到等式：实际技能 + 激进的自我探究 + 共同经历 = 卓越的领导力 + 更强的韧性。所以你可以从这三方面入手。实际技能我想大家都能理解。那么“激进的自我探究”，本质上是挖掘什么在驱动你、什么让你快乐的问题。在听节目时或者听完后，人们应该问自己哪些问题？

---

### [00:23:40] Jerry Colonna

**English:**
In the time since I've been a coach, which is now going on 27 years, the popularity of journaling has gone up, which is awesome. And part of what happens is people journal, but they don't know what they should be journaling or how they should. So let me give some questions then, and this is a way to approach it. Let's imagine that what we're trying to do, whether we're sitting in meditation, whether we're journaling, whether we're taking time away, we're just pausing and starting to ask ourselves questions. So my famous questions include things like, what am I not saying that I need to say? So let's imagine ourselves in a relationship that's not working.

**中文翻译:**
在我担任教练的 27 年里，写日记变得越来越流行，这很棒。但问题是，人们虽然写日记，却不知道该写什么或该怎么写。那么让我提供一些问题，这是一种切入方式。想象一下，无论我们是在冥想、写日记还是休假，我们只是停下来，开始问自己问题。我那些著名的问题包括：“有什么是我该说却没说的？”想象一下我们处于一段不顺的关系中。

---

### [00:24:30] Jerry Colonna

**English:**
Talk about something that could be terrifying. What am I not saying in that relationship that I need to say? By the way, this is a good question to ask if one is responsible for leading people too. Corollary questions to that would be, what am I saying that's not being heard? And then, of course, what's being said that I'm not hearing? So if we just pause and look at those four questions, how have I been complicit in creating the conditions I say I don't want? What am I not saying that I need to say? What am I saying that's not being heard? And what's being said that I'm not hearing? Can you feel the power of all of that in those questions?

**中文翻译:**
谈论一些可能令人恐惧的事情。在那段关系中，有什么是我该说却没说的？顺便说一句，如果你负责领导他人，这也是一个很好的问题。相关的推论问题是：“我说了什么却没被听到？”当然还有：“别人说了什么我却没听进去？”所以，如果我们停下来审视这四个问题：我是如何“同谋”创造了我不想要的条件的？有什么是我该说却没说的？我说了什么却没被听到？别人说了什么我却没听进去？你能感受到这些问题中蕴含的力量吗？

---

### [00:25:25] Lenny Rachitsky

**English:**
Yeah. Scary questions.

**中文翻译:**
是的。很吓人的问题。

---

### [00:25:27] Jerry Colonna

**English:**
They are scary questions. You know you're in the radical self-inquiry zone when the questions take your breath away, when the questions, and by the way, you don't have to share the answers to these questions with anybody but yourself. Now, there could be some power in sharing them in a group of friends and sharing them with a group of colleagues, sharing them with a coach, sharing them with a therapist. But the most important person with whom you should share the answers is oneself. This is a little bit of Buddhism here. Self-delusion along with attachment are the biggest contributors to our own suffering. Self-delusion. Everything's great. How you doing? Everything's great. Bullshit. Can we just not bullshit each other?

**中文翻译:**
它们确实很吓人。当你感到这些问题让你屏住呼吸时，你就知道自己进入了“激进的自我探究”地带。顺便说一句，你不需要向任何人分享这些问题的答案，除了你自己。当然，在朋友圈、同事圈、教练或治疗师面前分享这些答案可能会有某种力量。但你应该与之分享答案的最重要的人是你自己。这里有一点佛教的影子。自我欺骗（self-delusion）和执念（attachment）是我们痛苦的最大来源。自我欺骗就是：“一切都很好。你怎么样？一切都很好。”胡扯。我们能不能别再互相胡扯了？

---

### [00:26:30] Jerry Colonna

**English:**
So let me just pause. Those are just four questions. My first book Reboot has a set of questions after every single chapter. We also have a journal that we put out that has questions and questions, but the more important thing to take away from this is questions that startle us, questions that may cause us to be a little afraid of the answer, that's where the gold is.

**中文翻译:**
让我先停一下。那只是四个问题。我的第一本书《重启》在每一章后面都有一组问题。我们还出版了一本包含大量问题的日记本，但更重要的一点是：那些让我们吃惊的问题，那些可能让我们对答案感到有些害怕的问题，才是真正的宝藏所在。

---

### [00:27:02] Lenny Rachitsky

**English:**
And we'll point people to the book for many more of these questions and the worksheets. For the third party equation, shared experiences, can you explain what that is?

**中文翻译:**
我们会引导大家去书里找更多的问题和工作表。关于等式的第三部分“共同经历”，你能解释一下那是什么吗？

---

### [00:27:11] Jerry Colonna

**English:**
We were talking about socialization, for example. Prior to launching Reboot, the company, my co-founder, Ali Schultz and I, the roots of Reboot the company began with me designing, or Ali and I designing these boot camps. And the original iteration of the boot camp, we used to call CEO Boot Camp because it was originally we would get first-time CEOs together and we would do a bait and switch. We would pretend to sell them practical skills, and then I would start asking really tough questions like who would you be without the story of who you are? It's like what?

**中文翻译:**
我们刚才谈到了社会化。在创立 Reboot 公司之前，我和联合创始人 Ali Schultz 创办公司的根源在于我（或我们）设计的这些训练营。训练营最初的版本我们称之为“CEO 训练营”，因为最初我们会把第一次当 CEO 的人聚在一起，然后玩个“挂羊头卖狗肉”的小把戏。我们假装教他们实际技能，然后我开始问一些非常棘手的问题，比如：“如果没有关于‘你是谁’的那个故事，你会是谁？”他们会反应说：“什么？”

---

### [00:27:57] Jerry Colonna

**English:**
The notion of shared experience as an important component grew out of that. Because what would happen is imagine sitting in a circle of people who just have your back, who really care about you as a person. And imagine then discussing some of the answers to those questions. Who would you be without the story of who you are? What is it that you wish that people in your life knew about you, but you're too afraid to tell them? And imagine sitting in a group of people who can just hold that space without fixing you, without telling you what you're doing right or wrong? We, too often than not, especially in what I would say the entrepreneurial community are socialized to bullshit not only ourselves, but everybody else. All our companies are moving up into the right, every product that's working, we don't really have any problems because we're crushing it, and that's just a lie. Imagine having the capacity to be in relationship with people where you can just tell the truth. That's what shared experiences are about.

**中文翻译:**
“共同经历”作为一个重要组成部分的概念就是由此产生的。因为会发生的情况是，想象一下坐在一群支持你、真正关心你的人中间。然后想象一下讨论这些问题的答案。如果没有关于你是谁的故事，你会是谁？你希望生活中人们了解你什么，但你又太害怕告诉他们？想象一下坐在一群人中间，他们只是为你留出空间，而不去试图“修复”你，不去告诉你做对还是做错。我们往往（尤其是在创业圈）被社会化去欺骗自己和他人。我们所有的公司都在增长，每个产品都有效，我们没有任何问题，因为我们正大获全胜，但这只是个谎言。想象一下，你有能力与人建立一种可以直言不讳的关系。这就是共同经历的意义。

---

### [00:29:26] Lenny Rachitsky

**English:**
My wife does a women's circle where they gather and just share what's really going on within in their lives. And it's-

**中文翻译:**
我妻子参加了一个女性圈子，她们聚在一起分享生活中真实发生的事情。那是——

---

### [00:29:26] Jerry Colonna

**English:**
That's it.

**中文翻译:**
就是那样。

---

### [00:29:34] Lenny Rachitsky

**English:**
And it's very confidential. There's a ritual to it, and it feels like that's a really good avenue for things like that.

**中文翻译:**
而且非常保密。它有一种仪式感，感觉那是处理这类事情的一个非常好的途径。

---

### [00:29:42] Jerry Colonna

**English:**
What circle do you sit in?

**中文翻译:**
那你参加什么圈子？

---

### [00:29:44] Lenny Rachitsky

**English:**
No circles. This is my circle.

**中文翻译:**
没参加。这就是我的圈子（指播客）。

---

### [00:29:49] Jerry Colonna

**English:**
But there is something powerful here. I think in the last 15 years, the rise of podcasts, good podcasts. What I think what happens is let's hope this is happening for your audience right now, good quality intimate conversation between people who are authentic and real, creates space for someone to be authentic and real, even if it's just with themselves. So you're doing a mitzvah, you're doing a good deed by creating this space.

**中文翻译:**
但这其中确实蕴含着某种力量。我认为在过去的 15 年里，播客（好的播客）兴起了。我认为正在发生的是——希望现在对你的听众也是如此——真实的人之间高质量、亲密的对话，为某人创造了变得真实的空间，即使只是对自己真实。所以你是在行善（mitzvah），通过创造这个空间在做一件好事。

---

### [00:30:24] Lenny Rachitsky

**English:**
Thanks, Jerry. Let's go back to the busyness point, and I'll talk about myself a bit to get it real again, because I think it's also something a lot of people struggle with. I listen to this, they're just like, I'm so busy, and every time someone ask me how I'm doing, busy, so busy, like swirly eyes emoji, swirly eyes emoji.

**中文翻译:**
谢谢，Jerry。让我们回到忙碌这一点，我会谈谈我自己，让它变得更真实，因为我觉得这也是很多人挣扎的地方。听众可能会想：“我太忙了”，每次有人问我过得怎么样，我都会说：“忙，太忙了”，就像发那个晕头转向的表情符号一样。

---

### [00:30:45] Jerry Colonna

**English:**
With a little head shake.

**中文翻译:**
还要摇摇头。

---

### [00:30:47] Lenny Rachitsky

**English:**
That's right. And the melting face emoji. And that's very much me. And it's funny because I started this journey of the newsletter of just like I call the project avoid getting a real job. And it was just like, cool, just do this newsletter thing, not have the job. It'll be chill, write an email once a week. But I just find myself taking on endlessly more and more. And for me, I feel like the drive is it's just fun to see it grow and for it to keep building and doing well.

**中文翻译:**
没错，还有那个融化的脸的表情。我就是这样。很有趣，因为我开始写时事通讯的初衷，我把这个项目称为“逃避找份正经工作”。当时想的是：“酷，就写写时事通讯，不用上班。这会很轻松，每周写一封邮件就行。”但我发现自己无休止地承担得越来越多。对我来说，动力在于看到它增长、不断壮大并取得成功很有趣。

---

### [00:31:17] Lenny Rachitsky

**English:**
This reminds me, there's a quote that Will Smith shared once that I think you'll like. Someone asked him what it's like to be famous, and he's like, "Really awesome as you're going up to fame. Pretty okay as a famous person. Really bad when you lose that fame." And that's how it feels with the growth of this thing. It's just like growth is up. Oh, life's good, and then it starts to stall. I'm like, oh, no, it's all going to fall apart. So I think that's where a lot of that comes from for me. It's just like, oh, what's next? I got to, let's see what else I can do here.

**中文翻译:**
这让我想起威尔·史密斯（Will Smith）分享过的一句话，我想你会喜欢的。有人问他成名是什么感觉，他说：“在成名的路上感觉棒极了。成名后感觉还可以。但当你失去名声时，感觉糟透了。”这就是这个项目增长给我的感觉。增长上升时，生活很美好；一旦增长停滞，我就会想：“噢不，一切都要垮了。”所以我认为我的很多忙碌都源于此。就像是：“噢，下一步是什么？我得看看还能做点什么。”

---

### [00:31:44] Jerry Colonna

**English:**
Well, how do you feel about yourself when you're on that growth trajectory?

**中文翻译:**
那么，当你处于那种增长轨迹时，你对自己感觉如何？

---

### [00:31:50] Lenny Rachitsky

**English:**
I feel great.

**中文翻译:**
感觉棒极了。

---

### [00:31:52] Jerry Colonna

**English:**
Say more.

**中文翻译:**
多说一点。

---

### [00:31:53] Lenny Rachitsky

**English:**
I feel like I'm achieving and heading in a... Part of it is just fun. It's like fun to win. So it's just like, yeah, we're doing it. It's working.

**中文翻译:**
我觉得我正在取得成就，正朝着……部分原因就是有趣。赢的感觉很有趣。所以就像是：“耶，我们做到了。它起作用了。”

---

### [00:32:07] Jerry Colonna

**English:**
And when you're not growing, how do you feel about yourself?

**中文翻译:**
那当你没有增长时，你对自己感觉如何？

---

### [00:32:13] Lenny Rachitsky

**English:**
About myself. There's this sense that it's all over. Oh, maybe it's all going to fall apart, and maybe I'm not as good at this as I thought, and maybe-

**中文翻译:**
关于我自己。会有一种“一切都结束了”的感觉。噢，也许一切都要垮了，也许我并没有我想象的那么擅长这件事，也许——

---

### [00:32:25] Jerry Colonna

**English:**
Okay, so stay in that spot for a moment. So imagine, and I don't know that this is true, but I can imagine that there's a little whispery voice in your head that's always there that says, "Lenny, you're not as good as you think you are. In fact, Lenny, they might even find out."

**中文翻译:**
好，在那儿停一下。想象一下——我不知道这是否属实，但我可以想象——你脑子里一直有一个细微的声音在说：“Lenny，你没你想的那么好。事实上，Lenny，他们甚至可能会发现真相。”

---

### [00:32:50] Lenny Rachitsky

**English:**
Yep. Yeah, imposter syndrome.

**中文翻译:**
是的。没错，冒充者综合征。

---

### [00:32:52] Jerry Colonna

**English:**
Oh, shit. So by being busy and by being on that growth trajectory, that voice maybe sounds a little less persistent, maybe a little less loud. Now, I want to offer a different potential. What if you could enjoy the puzzle of trying to create something new, trying to create magic, something out of nothing, but it doesn't matter to your sense of self-esteem if you succeed or fail. What if what drove you was not quieting that voice, but what drove you was, oh, this is just fun? Seth Godin, who's a dear, dear friend of mine, talks about art projects.

**中文翻译:**
噢，天哪。所以通过让自己忙碌并保持增长轨迹，那个声音可能会变得没那么执着，或者没那么大声。现在，我想提供另一种可能性。如果你能享受创造新事物、创造奇迹、无中生有的过程，但无论成败都不影响你的自尊心，那会怎样？如果驱动你的不是为了压制那个声音，而是因为“噢，这很有趣”呢？我的好朋友塞斯·高汀（Seth Godin）谈到过“艺术项目”。

---

### [00:33:55] Lenny Rachitsky

**English:**
Also a former podcast guest.

**中文翻译:**
他也是以前的播客嘉宾。

---

### [00:33:57] Jerry Colonna

**English:**
So what if you just approached the project as if it was an art project? I think it's going to show up this way. What if it turns out it's wrong? What if it's this? What if it's that? And your sense of self-esteem is not attached to the outcome.

**中文翻译:**
所以，如果你把这个项目当作一个艺术项目来对待呢？我想它会以这种方式呈现。如果结果证明是错的呢？如果是这样呢？如果是那样呢？而你的自尊心并不取决于结果。

---

### [00:34:16] Lenny Rachitsky

**English:**
What's interesting is that's how I started this whole thing. I had no intention of it being a career and way I make a living. It was just, this is cool, people seem to like it, I enjoy it. Let's just see where it goes. No expectations.

**中文翻译:**
有趣的是，我最初就是这样开始的。我根本没打算把它当作职业或谋生手段。当时只是觉得：“这很酷，人们似乎很喜欢，我也很享受。看看它会发展成什么样吧。”没有任何期待。

---

### [00:34:28] Jerry Colonna

**English:**
And then what happened?

**中文翻译:**
然后发生了什么？

---

### [00:34:29] Lenny Rachitsky

**English:**
And then it worked.

**中文翻译:**
然后它成功了。

---

### [00:34:30] Jerry Colonna

**English:**
It became successful.

**中文翻译:**
它变得成功了。

---

### [00:34:31] Lenny Rachitsky

**English:**
That's right. It worked out.

**中文翻译:**
没错，它奏效了。

---

### [00:34:33] Jerry Colonna

**English:**
Right. It became successful, meaning you developed an audience, meaning you developed a following.

**中文翻译:**
对。它变得成功了，意味着你拥有了受众，意味着你拥有了追随者。

---

### [00:34:41] Lenny Rachitsky

**English:**
And then, income. That was a big part of it.

**中文翻译:**
然后，有了收入。那是很大一部分原因。

---

### [00:34:43] Jerry Colonna

**English:**
And then you developed an income, and then the stakes went up, and then all of a sudden, my heart, the anxiety.

**中文翻译:**
然后你有了收入，接着赌注变大了，突然之间，心跳加速，焦虑袭来。

---

### [00:34:54] Lenny Rachitsky

**English:**
Not quite that strongly. At times it is, but there's a bit of just, oh, wow, I am relying on this now. I can't just let it fall apart.

**中文翻译:**
没那么强烈。有时会，但更多的是一种：“噢，哇，我现在依赖这个生活。我不能让它垮掉。”

---

### [00:35:03] Jerry Colonna

**English:**
Because my life would fall apart if I let it fall apart.

**中文翻译:**
因为如果我让它垮掉，我的生活也会垮掉。

---

### [00:35:07] Lenny Rachitsky

**English:**
Yeah, life would change in a big way if this whole thing ends.

**中文翻译:**
是的，如果这一切结束，生活会发生巨大的变化。

---

### [00:35:11] Jerry Colonna

**English:**
Right. Right. So what you're talking about, what we're talking about right now, remember before I said in Buddhism, we talk about self-delusion and attachment. Now, we're talking about attachment. When we become attached to the outcome, we inadvertently fuel our own suffering. When we become attached, and in this case, okay, I get it. There's a financial reality. This is important because it helps pay the bills, if it doesn't entirely pay the bills. Great. Got it. Fabulous. But really the deeper attachment is see, I'm not nothing. See, I'm not a nobody, I'm a somebody, and that's the source of the suffering.

**中文翻译:**
对，没错。所以你所说的，我们现在讨论的，记得我之前说过佛教中提到的“自我欺骗”和“执念”吗？现在我们讨论的是“执念”。当我们对结果产生执念时，我们就不经意地助长了自己的痛苦。当我们产生执念时——在这种情况下，好吧，我明白。有财务现实。这很重要，因为它能帮你支付账单。太棒了，明白了。但真正深层的执念是：“看，我不是一事无成。看，我不是无名小卒，我是个人物。”这才是痛苦的根源。

---

### [00:36:09] Lenny Rachitsky

**English:**
That is so true. That is very much a part of what has driven me is I was always a very shy kid growing up, and I don't think people expected a lot of me except my mom and dad, I guess. And so, I always had the sense, I'll show them, I'll show them what I could do, and that's always, it's this chip on the shoulder thing that I know drives a lot of people.

**中文翻译:**
太对了。这确实是驱动我的很大一部分原因。我从小就是个非常害羞的孩子，我想除了我爸妈，没人对我抱有太大的期望。所以我总有一种感觉：“我会证明给他们看，我会让他们看看我能做什么。”这种“证明自己”的心态我知道驱动了很多人。

---

### [00:36:29] Jerry Colonna

**English:**
How old are you, Lenny?

**中文翻译:**
你多大了，Lenny？

---

### [00:36:30] Lenny Rachitsky

**English:**
43.

**中文翻译:**
43 岁。

---

### [00:36:30] Jerry Colonna

**English:**
Okay. So maybe now at 43, you can take in the fact that you are somebody regardless of what you do. What's your wife's name?

**中文翻译:**
好。那么也许现在 43 岁的你可以接受这样一个事实：无论你做什么，你都是一个有价值的人。你妻子叫什么名字？

---

### [00:36:48] Lenny Rachitsky

**English:**
Michelle.

**中文翻译:**
Michelle。

---

### [00:36:49] Jerry Colonna

**English:**
Is she going to love you even if the podcast fails?

**中文翻译:**
如果播客失败了，她还会爱你吗？

---

### [00:36:52] Lenny Rachitsky

**English:**
Absolutely.

**中文翻译:**
绝对会。

---

### [00:36:55] Jerry Colonna

**English:**
What, is she an idiot? No, she's a smart person. The people who actually know you and care about you may be proud of your efforts, but their love for you is not dependent upon its success. And that's like a rewiring. Do you have children?

**中文翻译:**
怎么，她是傻瓜吗？不，她是个聪明人。真正了解你、关心你的人可能会为你的努力感到自豪，但他们对你的爱并不取决于你的成功。这就像是一种思维重构。你有孩子吗？

---

### [00:37:27] Lenny Rachitsky

**English:**
Yeah, we got a 22-month-old now.

**中文翻译:**
有的，我们现在有一个 22 个月大的孩子。

---

### [00:37:30] Jerry Colonna

**English:**
Oh, mazel tov. That's wonderful. My children are 34, 32, and 28. So I'll speak like the old man that I am. When we take that test, that spelling test, and we stick it with magnets on the refrigerator, it's at a pride. The challenging message that we inadvertently can send to our children is that we only love them because they got an A on the spelling test. And so, it's really critically important that we as parents do our own internal work to convey that unconditional love that is our birthright as human beings. And we hold onto the goal because the goal is cool, because solving a puzzle is fun, because doing hard work and experiencing the reward from that is affirming, but your value as a human being is unshakable. Now, as a father, isn't that the feeling you want your child to have?

**中文翻译:**
噢，恭喜（mazel tov）。太棒了。我的孩子分别是 34 岁、32 岁和 28 岁。所以我就以一个老人的身份来说。当我们把拼写测试卷用磁铁贴在冰箱上时，那是出于自豪。但我们不经意间传达给孩子的具有挑战性的信息可能是：我们爱他们只是因为他们在拼写测试中得了 A。因此，作为父母，我们做好自己的内心功课，去传达那种作为人类与生俱来的无条件的爱，是非常关键的。我们坚持目标是因为目标很酷，因为解决难题很有趣，因为努力工作并获得回报是令人肯定的，但你作为人的价值是不可动摇的。现在，作为父亲，这难道不是你希望孩子拥有的感觉吗？

---

### [00:38:51] Lenny Rachitsky

**English:**
Absolutely. And there's a lot of parenting advice these days that helps you learn to do that. There's all these TikToks now, don't say good job. Just say good choice or great, hard work. Great job working hard on that.

**中文翻译:**
绝对是。现在有很多育儿建议可以帮你学会这样做。TikTok 上有很多视频说，不要说“做得好”，要说“很好的选择”或者“辛苦了，努力工作很棒”。

---

### [00:39:04] Jerry Colonna

**English:**
Right, right, right. I don't know how I feel about getting parenting advice from TikTok, but okay.

**中文翻译:**
对，对。我不知道该如何评价从 TikTok 上获取育儿建议，但好吧。

---

### [00:39:12] Lenny Rachitsky (Ad: OneSchema)

**English:**
I'm excited to have Andrew Luo joining us today. Andrew is CEO of OneSchema, one of our longtime podcast sponsors. Welcome, Andrew.

**中文翻译:**
很高兴今天邀请到 Andrew Luo。Andrew 是 OneSchema 的 CEO，OneSchema 是我们播客的长期赞助商之一。欢迎你，Andrew。

---

### [00:39:19] Andrew Luo

**English:**
Thanks for having me, Lenny. Great to be here.

**中文翻译:**
谢谢你的邀请，Lenny。很高兴来到这里。

---

### [00:39:21] Lenny Rachitsky

**English:**
So what is new with OneSchema, I know that you work with some of my favorite companies like Ramp and Vanta and Watershed. I heard you guys launch a new data intake product that automates the hours of manual work that teams spent importing and mapping and integrating CSV and Excel files.

**中文翻译:**
OneSchema 有什么新动态吗？我知道你们与 Ramp、Vanta 和 Watershed 等我最喜欢的公司合作。我听说你们推出了一个新的数据摄取产品，可以将团队在导入、映射和集成 CSV 及 Excel 文件上花费的数小时手动工作自动化。

---

### [00:39:37] Andrew Luo

**English:**
Yes. So we just launched the 2.0 of OneSchema file feeds. We've rebuilt it from the ground up with AI. We saw so many customers coming to us with teams of data engineers that struggled with the manual work required to clean messy spreadsheets. FileFeeds 2.0 allows non-technical teams to automate the process of transforming CSV and Excel files with just a simple prompt. We support all of the trickiest file integrations, SFTP, S3, and even email.

**中文翻译:**
是的。我们刚刚发布了 OneSchema FileFeeds 2.0。我们利用 AI 从头重构了它。我们看到很多客户的数据工程师团队都在为清理混乱的电子表格所需的手动工作而苦恼。FileFeeds 2.0 让非技术团队只需通过简单的提示词，就能自动完成 CSV 和 Excel 文件的转换过程。我们支持所有最棘手的文件集成，包括 SFTP、S3 甚至电子邮件。

---

### [00:40:03] Lenny Rachitsky

**English:**
I can tell you that if my team had to build integrations like this, how nice would it be to take this off our roadmap and instead use something like OneSchema?

**中文翻译:**
我可以告诉你，如果我的团队必须构建这样的集成，能把它从我们的路线图中拿掉，转而使用 OneSchema 之类的工具，那该有多好。

---

### [00:40:11] Andrew Luo

**English:**
Absolutely, Lenny. We've heard so many horror stories of outages from even just a single bad record in transactions, employee files, purchase orders, you name it. Debugging these issues is often like finding a needle in a haystack. OneSchema stops any bad data from entering your system and automatically validates your files, generating error reports with the exact issues in all bad files.

**中文翻译:**
绝对是这样，Lenny。我们听过太多因为交易记录、员工档案或采购订单中仅仅一条错误记录就导致系统崩溃的惨痛故事。调试这些问题通常就像大海捞针。OneSchema 能阻止任何错误数据进入你的系统，并自动验证你的文件，生成包含所有错误文件具体问题的错误报告。

---

### [00:40:32] Lenny Rachitsky

**English:**
I know that importing incorrect data can cause all kinds of pain for your customers and quickly lose their trust. Andrew, thank you so much for joining me. If you want to learn more, head on over to oneschema.co. That's oneschema.co.

**中文翻译:**
我知道导入错误数据会给客户带来各种痛苦，并迅速失去他们的信任。Andrew，非常感谢你加入我。如果你想了解更多信息，请访问 oneschema.co。网址是 oneschema.co。

---

### [00:40:46] Lenny Rachitsky

**English:**
Just to close loop on this, I think as people hear this, I feel like, okay, cool, everything falls apart. Sure, my parents will love me, my wife will love me, they won't think less of me. However, it's nice to get that really nice couch and that nice hotel and the income, the comfort that comes with income at a certain level is hard to give up. How do you help people get past that that might go away and feel comfortable?

**中文翻译:**
为了结束这个话题，我想当人们听到这些时，可能会觉得：“好吧，酷，就算一切都垮了，我父母会爱我，我妻子会爱我，他们不会看不起我。然而，拥有漂亮的沙发、高级的酒店和丰厚的收入还是很棒的，达到一定水平的收入所带来的舒适感很难放弃。”你如何帮助人们克服“这些可能会消失”的恐惧并感到坦然？

---

### [00:41:09] Jerry Colonna

**English:**
Well, the good news is, and again, this is a Buddhist reference. The good news is there's a wisdom tradition that teaches all about this. So very briefly, the Buddhist story is in his mid-30s, he wakes up to the truth of birth, old age, sickness, and death. Birth, old age, sickness and death. And he wanders into the forest and he becomes a wandering mendicant and he becomes a holy man, and he's still not satisfied. And as I like to tell the story, one day he decides, fuck it, I'm just going to sit under the Bodhi tree and I'm not going to move until I figure this shit out. And so, he sits and sits and sits, and the story is he sat for 40 days living on a single grain of rice every day because always right, crazy stuff.

**中文翻译:**
好消息是——这又是一个佛教典故。好消息是有一个智慧传统专门教导这些。简而言之，佛陀的故事是：在他 30 多岁时，他觉察到了生、老、病、死的真相。于是他走进森林，成为一名苦行僧，成为一名圣人，但他仍然不满足。正如我喜欢讲的故事那样，有一天他决定：“管它呢，我就坐在菩提树下，不把这事弄明白我就不起来。”于是他坐啊坐，传说他坐了 40 天，每天只靠一粒米维生，因为传说总是很疯狂。

---

### [00:42:05] Jerry Colonna

**English:**
And when he woke up, he woke up to the four noble truths and the four noble truths are life is filled with suffering, that which we do to push away suffering increases suffering. The third noble truth is that there's an end to suffering. That's a really important one. And the fourth noble truth is what's known as the eightfold path to the end of suffering.

**中文翻译:**
当他觉醒时，他悟出了“四圣谛”。四圣谛是：人生皆苦（苦谛）；我们为了推开痛苦所做的事情反而增加了痛苦（集谛）；痛苦是可以终结的（灭谛），这非常重要；第四个是通往痛苦终结的“八正道”（道谛）。

---

### [00:42:34] Jerry Colonna

**English:**
So let's focus on the second noble truth because that's really what you're talking about. When we acquire that nice couch, when we buy that nice house that stretches our income to its maximum, if we're doing it to enjoy the couch or the house, then A-OK. But if we're doing it because we're trying to push away the suffering of am I good enough to be loved, to feel safe, and that I belong, that which we do to push away suffering will increase suffering. And in this case, oh my God, what if they take my house away from me? Oh my God, what if I fall backwards down that staircase of life? Oh my God, what if all of those people who have signed up to my Substack suddenly disappear? You see how the attachment becomes that source of suffering? You see how the thing that we do to make ourselves feel better in fact fuels the tenuous hold that we have on our OK-ness? I'm okay just as I am. I'm okay.

**中文翻译:**
让我们关注第二圣谛，因为那正是你所谈论的。当我们买下那个漂亮的沙发，买下那栋让我们的收入达到极限的漂亮房子时，如果我们是为了享受沙发或房子，那没问题。但如果我们这样做是为了推开“我是否足够优秀到被爱、感到安全和有归属感”这种痛苦，那么我们为了推开痛苦所做的事反而会增加痛苦。在这种情况下，你会想：“噢天哪，如果他们把我的房子收走怎么办？噢天哪，如果我在人生的阶梯上跌落怎么办？噢天哪，如果所有订阅我 Substack 的人都突然消失了怎么办？”你看到执念是如何成为痛苦之源的吗？你看到我们为了让自己感觉更好而做的事情，实际上是如何加剧了我们对自己“现状尚可”的脆弱掌控吗？我就是我，这样就很好。我没问题。

---

### [00:44:03] Jerry Colonna

**English:**
It all comes down to why we're doing what we're doing. Now, to be clear, this is hard for me. I think it's hard for everybody. When my first book came out, Dan Harris, who's a really good friend and client from 10% Happier said to me, "Don't read the Amazon reviews." The truth is, I've read two reviews. I read it in the first hour after it was released, and I've never read a review since because there's no way I can experience those reviews without becoming attached to how people feel. So thank you. I'll put it over here and I'll just stay focused on the experience that I get from writing.

**中文翻译:**
这一切都归结为你为什么要这么做。需要明确的是，这对我也很难。我想对每个人都很难。当我的第一本书出版时，我的好朋友兼客户、来自《10% Happier》的 Dan Harris 对我说：“不要看亚马逊上的评论。”事实是，我只读过两条评论。我在书发布后的第一个小时读了它们，之后再也没读过，因为我无法在阅读那些评论时不产生对他人看法的执念。所以，谢谢，我会把评论放在一边，只专注于我从写作中获得的体验。

---

### [00:45:04] Jerry Colonna

**English:**
And yes, do I want to sell thousands of books? Do I want people to feel moved by my writing? I do, but you know who gets the most out of my writing? Me, because when I sit down, this is my file folder for whatever I might do for our next book, what I'm trying to do is answer questions that I have. For example, Captain Chaos is running the country right now. What is it that the world is going to need two or three years from now? And what's my contribution to that world? Now, just as I say that, how does that feel to you? It's kind of settling. So I know that in order for me to feel good about my existence on this planet, I have to ask myself these questions and I have to attempt to answer these questions. Whether it turns into a book that people buy or not is secondary, I have to do this work regardless.

**中文翻译:**
是的，我想卖出成千上万本书吗？我想让人们被我的文字感动吗？我想。但你知道谁从我的写作中获益最多吗？是我。因为当我坐下来（这是我为下一本书准备的文件夹），我试图做的是回答我自己的问题。例如，现在是“混乱队长”在治理国家。两三年后这个世界需要什么？我对那个世界的贡献是什么？现在，当我这么说的时候，你感觉如何？这让人感到安定。所以我知道，为了让我对在这个星球上的存在感到满意，我必须问自己这些问题，并尝试回答这些问题。它是否会变成一本畅销书是次要的，无论如何我都要做这项工作。

---

### [00:46:22] Lenny Rachitsky

**English:**
That super connects with exactly again, the way I started this whole thing is I started writing just to crystallize my own thinking, and it ends up being useful to other people.

**中文翻译:**
这与我开始这一切的方式完全契合。我开始写作只是为了理清自己的思绪，结果证明它对其他人也有用。

---

### [00:46:33] Jerry Colonna

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:46:35] Lenny Rachitsky

**English:**
People hear this and they're like, why would I want to give up this great couch and house and car and all these things? That's really hard. And risking that by just doing something that feels good versus it'll make income, but it actually works. That's what I found. If you focus on a thing that is useful to yourself and interesting and not come at it from how do I make the most amount of money and turn this into whole thing, but more just, this is really interesting. I'm going to see where this goes. It will work for me.

**中文翻译:**
人们听到这些可能会想：“为什么我要放弃这么好的沙发、房子、车子和所有这些东西？这太难了。”仅仅因为做一些感觉良好的事情而冒着失去这些的风险，而不是为了赚取收入，但这实际上是行得通的。这就是我的发现。如果你专注于一件对自己有用且有趣的事情，而不是从“我如何赚最多的钱并把它做大”的角度出发，而只是觉得“这很有趣，我想看看它会发展成什么样”，它就会为你带来回报。

---

### [00:47:00] Jerry Colonna

**English:**
Lenny, you implicitly asked a how question a few minutes ago. How do I do this? How do I do this radical self-inquiry? And I asked, I responded by offering a few questions. Let's build upon that for a moment, because what you are articulating right now is in the process of asking those questions, you can go back to what Simon Sinek would say is your why. You could go back to your core principle. You could go back to the centerpiece within you, which is what do I believe to be true about the world and how do I want to be in that world? You know what animates me right now is a question? With my children being fully fledged adults, I am really focused on what kind of ancestor to my descendants would I like to be? 20 years from now, 30 years from now, 40 years from now, I'll be gone. What would I like those who follow after me to believe to be true about me?

**中文翻译:**
Lenny，几分钟前你含蓄地问了一个“如何做”的问题。我该怎么做？我该如何进行这种激进的自我探究？我通过提供几个问题做出了回应。让我们在此基础上再深入一点，因为你现在所表达的是，在问这些问题的过程中，你可以回到西蒙·斯涅克（Simon Sinek）所说的你的“为什么”（Why）。你可以回到你的核心原则。你可以回到你内心的核心，即：我认为这个世界的真相是什么，我想在这个世界中如何存在？你知道现在激励我的是什么问题吗？随着我的孩子们完全成年，我非常关注：我想成为后代眼中什么样的祖先？20 年、30 年、40 年后，我将不在人世。我希望那些追随我的人相信关于我的什么事实？

---

### [00:48:11] Jerry Colonna

**English:**
And you just paused. I can tell from the Adam's apple jumping up and down, that that question landed for you. It's a question of legacy. It's a question of meaning and purpose. At the end of my days, this is a question in Reboot, at the end of my days, what would I like the people who come after me to say about me? And what I want people to say about me is that he gave a shit about the world, he cared, and he tried, and he was kind. Those are the things that matter to me.

**中文翻译:**
你刚才停顿了一下。我能从你喉结的起伏看出，这个问题触动了你。这是一个关于传承（legacy）的问题。这是一个关于意义和目的的问题。在我生命的尽头——这是《重启》中的一个问题——在我生命的尽头，我希望后人如何评价我？我希望人们评价我：他关心这个世界，他在乎，他努力过，而且他很善良。这些才是对我很重要的事情。

---

### [00:49:00] Lenny Rachitsky

**English:**
I'm always reminded of that frame of reference when I go to a funeral and people reading the eulogy and the old advice of what do you want your eulogy to say and making that your mission. But on the flip side, there's this viral video of Mike Tyson. Someone was coming up to him I think before his big match recently, and asked him about his legacy, and he's like, "I don't give a shit about my legacy. It's just a made up thing that doesn't matter." So let me just ask you this. Why is it important to think about legacy? Does legacy even matter? We're dead. What's the difference?

**中文翻译:**
当我参加葬礼，听人们读悼词时，我总会想起那个参考框架，以及那个古老的建议：你想让你的悼词说什么，就把它作为你的使命。但另一方面，有一个迈克·泰森（Mike Tyson）的疯传视频。我想是在他最近的大赛前，有人问他关于传承的事，他说：“我一点也不在乎什么传承。那只是编造出来的、无关紧要的东西。”所以我想问你：为什么思考传承很重要？传承真的重要吗？我们都死了，有什么区别？

---

### [00:49:33] Jerry Colonna

**English:**
Far be it for me to criticize Mike, and don't hit me Mike, because even as an old guy, I wouldn't want to be hit by Mike Tyson. I don't know what's behind his response, but I can tell you what's true for me. I made oblique reference to Captain Chaos in the world as it is right now. The world's a tough place right now. We live in a world where it's almost normalized that a teenager will shoot other teenagers in school. It's almost normalized that people are dragged off to jail. Something is happening, something that's really disturbing.

**中文翻译:**
我绝不敢批评迈克，迈克别打我，因为即使作为一个老头，我也不想被迈克·泰森打。我不知道他回答背后的深意，但我可以告诉你对我来说什么是真实的。我刚才委婉地提到了现在的世界和“混乱队长”。现在的世界是个艰难的地方。我们生活在一个青少年在学校枪击其他青少年几乎常态化的世界。人们被拖进监狱几乎也常态化了。有些事情正在发生，一些非常令人不安的事情。

---

### [00:50:28] Jerry Colonna

**English:**
Now, to be clear, we've always had disturbing times. I mean, I was reminded recently, I'm reading a book called Soldiers and Kings, which I highly recommend, which is about human smuggling from Central America into the United States, and it's an extraordinary book. And in reading that, I was reminded of policies that the US government has used over the years, whether it's supporting dictators in Central America or other sorts of things, things that I oppose, that feel immoral, if not directly immoral.

**中文翻译:**
当然，我们一直都有令人不安的时代。我最近在读一本叫《士兵与国王》（Soldiers and Kings）的书，我强烈推荐，它是关于从中美洲向美国偷渡人口的，这是一本非凡的书。读这本书时，我想起了美国政府多年来采取的一些政策，无论是支持中美洲的独裁者还是其他事情，这些都是我反对的，感觉即使不是直接不道德，也是有违道德的。

---

### [00:51:15] Jerry Colonna

**English:**
Why does this come up for me? I can't shake the feeling that someone down the line in my lineage is going to ask of me, "And what did you do, grandpa? And what did you do, great grandpa?" I know what I want that answer to be, which is I tried. Lenny, God gave me the ability to put two sentences together in a way that people listen. I feel a moral responsibility to use that God-given gift to help create the world, that I would like to see, a world of kindness and empathy, a world where poverty is diminished, a world where people feel safe however the fuck they identify. I don't give a damn. So is that my legacy? Yeah, and maybe there's some ego implicit in that, but can I go on for just a bit on this?

**中文翻译:**
为什么我会想到这些？我无法摆脱这样一种感觉：我的后代中总会有人问我：“爷爷，你当时做了什么？曾祖父，你当时做了什么？”我知道我希望那个答案是什么，那就是：我努力过了。Lenny，上帝给了我一种能力，让我能把句子组织得让人们愿意倾听。我觉得自己有一种道德责任，去利用这份天赋来帮助创造一个我希望看到的世界——一个充满善良和共情的世界，一个贫困减少的世界，一个无论人们如何定义自己都能感到安全的世界。我不在乎其他的。所以那是我的传承吗？是的，也许其中隐含着一些自我（ego），但我能就此多说一点吗？

---

### [00:52:54] Lenny Rachitsky

**English:**
Absolutely.

**中文翻译:**
当然可以。

---

### [00:52:55] Jerry Colonna

**English:**
At the end of Reboot, I write about this moment, and in this moment I am in Marin County. My wife Allie and I are together. And I'm once again torturing myself with this question. Have I been a good man? I drive myself crazy with that question. Have I been a good father? Have I been a good partner? Have I been a good man? And she says, in a very frustrated way, "All right, already. Enough. You're a good man. Stop." And so, I go for a walk, and as I'm walking, I encounter this toppled over oak tree and the roots are all torn up and you've seen trees like this, and clearly the tree died and clearly a wind came and clearly knocked the whole thing down. And I look at the tree and I say to myself, "Here lies a good man."

**中文翻译:**
在《重启》的结尾，我写到了这样一个时刻，当时我在马林县。我和妻子 Allie 在一起。我再次用这个问题折磨自己：我是一个好人吗？这个问题让我发疯。我是一个好父亲吗？我是一个好伴侣吗？我是一个好人吗？她非常沮丧地说：“行了，够了。你是个好人。别说了。”于是，我出去散步，走着走着，我遇到了一棵倒下的橡树，树根都被拔起来了，你见过那样的树，显然树已经死了，显然是一阵风把它吹倒了。我看着那棵树，对自己说：“这里躺着一个好人。”

---

### [00:53:57] Jerry Colonna

**English:**
And I liken myself to this toppled over oak tree, and I imagine that that tree had lived its life with its limbs gnarled and twisted by actions that it should have taken and actions that it shouldn't have taken, but good choices and bad choices. But that for the majority of its 75, 80 years, it lived into its purpose of providing shelter and shade for those that may have come from beneath it. And I make this point that at the end of my days, I want to be like this tree just slowly dissolving into the earth, having done the best job I could of being purposeful. I feel better. My suffering is eased when I can lean into that, which then makes me able to be present for the other person, whether it's a coaching client, whether it's a podcast conversation, whether it's just going for a walk with one of my children. I just feel better, and I think I am a better person when I think about things like that. So far be it from me to disagree with Mike Tyson, but I think he's wrong.

**中文翻译:**
我把自己比作这棵倒下的橡树，我想象这棵树的一生，它的枝干因为该做的和不该做的事情、正确的选择和错误的选择而变得粗糙扭曲。但在它 75、80 年的大部分时间里，它实现了自己的目标，为树下的人们提供庇护和阴凉。我想表达的是，在我生命的尽头，我想像这棵树一样，慢慢地消融在大地中，尽我所能地活出了意义。当我能倾向于这种想法时，我感觉好多了，我的痛苦减轻了，这让我能够全身心地投入到他人身上——无论是面对教练客户、播客对话，还是仅仅和我的一个孩子散步。我感觉更好，而且我认为当我思考这些事情时，我成为了一个更好的人。所以，我绝不是要反对迈克·泰森，但我认为他错了。

---

### [00:55:34] Lenny Rachitsky

**English:**
Good callback. It sounds like The Giving Tree to me.

**中文翻译:**
很好的回应。这听起来让我想起了《爱心树》（The Giving Tree）。

---

### [00:55:43] Jerry Colonna

**English:**
Oh, yes, yes. Shel Silverstein.

**中文翻译:**
噢，是的，谢尔·希尔弗斯坦的作品。

---

### [00:55:43] Lenny Rachitsky

**English:**
To give people something to do with this area of legacy. How did you approach coming up with figuring out what you wanted your legacy to be? Are there some questions you asked? Is there something you recommend folks do to help think through this for themselves?

**中文翻译:**
为了给人们在“传承”这个领域提供一些可做的事。你是如何思考并确定你想要的传承是什么的？你问了自己哪些问题？你有什么建议可以帮助大家自己思考这个问题吗？

---

### [00:55:57] Jerry Colonna

**English:**
Well, it's delightful that we've ended up here because I think that I'm still working through those questions. As I said before as we both connected with, I use my writing to find my way to answers to questions. So part of what I'm dealing with right now is, look, I'll turn 62 this year. That feels old, but it also feels settled. And part of what I'm trying to figure out is what do I want my elderhood to be like? And I'll be honest, I'm enjoying this time of my life where I'm finding myself being a voice of comfort, being a voice of maybe even sanity in a time where that feels really insane and challenging. So maybe that's what my legacy will be. I'm not 100% sure.

**中文翻译:**
很高兴我们谈到了这里，因为我认为我仍在努力解决这些问题。正如我之前所说，我们都深有体会，我利用写作来寻找问题的答案。所以我现在处理的一部分事情是：看，我今年就要 62 岁了。这感觉老了，但也感觉安定了。我正在努力弄清楚的是，我希望我的晚年生活是什么样的？老实说，我很享受人生的这段时光，我发现自己成为了一个安慰的声音，甚至可能是在这个疯狂且充满挑战的时代中一个理性的声音。所以也许这就是我的传承。我还不百分之百确定。

---

### [00:57:03] Lenny Rachitsky

**English:**
Is this maybe hinted the new book you're working on? Is this the topic you're thinking about or is this not?

**中文翻译:**
这是否暗示了你正在写的新书？这是你正在思考的主题吗？

---

### [00:57:09] Jerry Colonna

**English:**
Yeah, and other things. That's right. That's right.

**中文翻译:**
是的，还有其他一些事情。没错。

---

### [00:57:15] Lenny Rachitsky

**English:**
Speaking of the world being very crazy right now, you talked about your kids, AI is very top of mind for a lot of people in particular. It's stressing a lot of people out. In a lot of ways, it's quite unsettling in future careers, in skills, people-

**中文翻译:**
说到现在的世界非常疯狂，你提到了你的孩子，AI 尤其是很多人关注的焦点。它让很多人感到压力。在很多方面，它对未来的职业、技能都非常令人不安，人们——

---

### [00:57:29] Jerry Colonna

**English:**
It is unsettling, isn't it?

**中文翻译:**
确实令人不安，不是吗？

---

### [00:57:31] Lenny Rachitsky

**English:**
Quite unsettling, but there's a world where we don't need humans in the future, potentially. Just what advice do you share with clients to help them work through this period of worry with the future, with AI being the core of it?

**中文翻译:**
非常不安，未来可能会出现一个不需要人类的世界。对于如何帮助客户度过这段对未来的担忧期（以 AI 为核心），你有什么建议？

---

### [00:57:45] Jerry Colonna

**English:**
Well, if we go back to the equation for a moment, I think it's really important that we actually talk about these things. I would say a year ago, I likened it to the experience that I had. Remember, I'm old enough to remember when not everything had an IP address. Now, our refrigerators have IP addresses. I mean, it's freaking crazy. I'm old enough to remember when you had to install an IP stack into your personal computer in order to connect to the web. That's how old I am.

**中文翻译:**
如果我们回到那个等式，我认为真正去讨论这些事情非常重要。一年前，我把它比作我曾经的经历。记住，我年纪大到记得并不是所有东西都有 IP 地址的时代。现在连冰箱都有 IP 地址了，这简直疯了。我年纪大到记得为了连接网络，你必须在个人电脑里安装 IP 协议栈。我就是这么老。

---

### [00:58:22] Jerry Colonna

**English:**
Did you have the phone modem where you had to put the phone?

**中文翻译:**
你用过那种必须把电话放上去的电话调制解调器吗？

---

### [00:58:26] Jerry Colonna

**English:**
Absolutely. Absolutely. It was a big, big deal to go from 1,200 baud to 2,400 baud to 56K. Oh my God, it was like a rocket ship. A year ago, I thought we were going through a similar kind of transition. We're clearly not. This is different. And in the coaching therapeutic world, everybody's like, "Oh my God, ChatGPT is going to replace me." And I don't know, maybe. What I am finding is... I wear glasses. So for those of you who are only listening to the audio, you may find that news. What I am finding is in my own life, it's like I have put on a pair of glasses that are really, really sharp and helpful, and it is disturbing and unsettling because I think it does challenge this question of what is our role as human beings?

**中文翻译:**
当然，绝对用过。从 1200 波特率到 2400 再到 56K 是件天大的事。噢天哪，那感觉就像火箭一样。一年前，我以为我们正在经历类似的转型。显然不是，这次不一样。在教练和治疗领域，每个人都在说：“噢天哪，ChatGPT 要取代我了。”我不知道，也许吧。我发现的是……我戴眼镜，所以对于那些只听音频的人来说，这可能是个新闻。我发现的是，在我的生活中，这就像戴上了一副非常清晰且有帮助的眼镜，这令人不安，因为它确实挑战了“我们作为人类的角色是什么”这个问题。

---

### [00:59:46] Jerry Colonna

**English:**
Now, what I come back to, and I could be wrong, but what I come back to is we're talking through a medium, a mediated experience. My signal is bouncing up into the sky and to a satellite. I won't name the company, it's coming back down. I don't know what your access is. We're using this platform or a site to record this, but somehow we're still finding the capacity to be present for one another in a heart-to-heart way.

**中文翻译:**
现在，我回到的原点是——我也许是错的——我们正在通过一种媒介、一种被中介的体验在交谈。我的信号发射到天空，传到卫星，我不点名那家公司，然后又传回来。我不知道你的接入方式。我们正在使用这个平台或网站来录制，但不知何故，我们仍然能够以心贴心的方式为彼此存在。

---

### [01:00:30] Jerry Colonna

**English:**
And so, when I look at these phenomena, what I lift up is that. What I am hopeful about is that that which does not matter in the experience of being human gets burned away and is taken care of, call it by AI, but that that which matters, which is presence and connection, human-to-human contact, strategic thinking, formulation, you want to talk about it in terms of engineering, the conceptualization, that that gets elevated and our skills get better at doing that. And in the most optimistic point of view, what ends up happening is we spend more time on that which matters, and less time on that which doesn't matter. And I could be completely wrong and we could all be out of work and making sure that the robots are well-oiled, and that becomes our purpose.

**中文翻译:**
所以，当我审视这些现象时，我推崇的是这一点。我抱有希望的是，那些在人类体验中无关紧要的部分会被烧掉，并由 AI 来处理，但那些重要的部分——即临场感、连接、人与人的接触、战略思维、构思（如果你想用工程术语来说，就是概念化）——会得到提升，我们做这些事情的技能会变得更好。从最乐观的角度来看，最终的结果是我们花更多时间在重要的事情上，花更少时间在不重要的事情上。我也可能完全错了，我们可能都失业了，整天忙着给机器人上油，那成了我们的目标。

---

### [01:01:47] Lenny Rachitsky

**English:**
Along these lines of glasses and even coaching, the world of coaching, there's a really interesting use case I saw today that Dan Shipper shared that I think you'd love, which is now that ChatGPT has memory, remembers everything you've said, and you can think back, you can ask it, "What are blank spots in the way I see the world that I'm not seeing?" You could also upload all your chat transcripts from your meetings and ask it what could you do better in meetings?

**中文翻译:**
顺着眼镜和教练的话题，在教练领域，我今天看到 Dan Shipper 分享了一个很有趣的用例，我想你会喜欢的：既然 ChatGPT 有了记忆，能记住你说的每一句话，你可以回过头问它：“在我看待世界的方式中，有哪些我没看到的盲点？”你还可以上传所有会议的聊天记录，问它在会议中你可以做得更好。

---

### [01:02:14] Jerry Colonna

**English:**
Look, one of my colleagues in the coaching company, he has uploaded, he kept all of his journal entries, I think over 10 years journal entries from Evernote, and he uploaded that. I think he uses Claude, and he's asked Claude to highlight things. What am I not saying that I need to say? What am I saying that's not being heard? He's asked it to reflect back, and I think it's been incredibly helpful for him. I think the result is that he is a better coach, which is interesting, because the feeling is, well, does this replace it? I am finding, I'm using ChatGPT really as a writing and thinking partner in a way that I did not have before, and I'm still using my live real human writing buddies, which are really important to me. Where does this all end up? I had no idea. It is unsettling, it's uncanny, and it's also enlivening and exciting.

**中文翻译:**
看，我教练公司的一位同事，他上传了他所有的日记，我想是超过 10 年的 Evernote 日记。他用的是 Claude，他让 Claude 标出重点。有什么是我该说却没说的？我说了什么却没被听到？他让它进行反馈，我认为这对他的帮助大得惊人。我认为结果是他成了一个更好的教练，这很有趣，因为人们的感觉是：“这会取代它吗？”我发现，我真的把 ChatGPT 当作一个写作和思考伙伴，这是我以前从未有过的，同时我仍然在使用我那些真实的、活生生的人类写作伙伴，他们对我非常重要。这一切最终会走向何方？我不知道。它令人不安，它不可思议，但它也令人振奋和兴奋。

---

### [01:03:31] Lenny Rachitsky

**English:**
Well put. I love that you can ask these hard questions of Claude/ChatGPT, these questions that make you really scared could ask it what are the answers, and even not have to do the hard work and maybe get a better answer. I doubt that that will give you the best answers.

**中文翻译:**
说得好。我喜欢你可以向 Claude/ChatGPT 问这些难题，这些让你感到害怕的问题，你可以问它答案是什么，甚至不需要自己做艰苦的工作，也许还能得到更好的答案。不过我怀疑它是否能给你最好的答案。

---

### [01:03:47] Jerry Colonna

**English:**
Well, what it might do, which I think would be wonderful, is it might give you more questions to ask yourself. I'm a huge fan of powerful questions and the answer I give to a question like what am I not saying that I need to say? That question, you can ask yourself that question every single day. The question of how have I been complicit in creating the conditions I say I don't want? You can ask yourself that question every single day. To take a step back, the subtitle of my first book is Leadership in the Art of Growing Up. The Art of Growing Up is a practice. It's not a scientific moment where one day you wake up and you're done. It's an ongoing practice of not continuous improvement, but continuous inquiry that can feel exhausting when you contemplate it, but enlivening when you live it.

**中文翻译:**
嗯，它可能会做的一件事（我认为这很棒）是给你更多可以问自己的问题。我是“强有力的问题”的忠实粉丝。像“有什么是我该说却没说的？”这样的问题，你每天都可以问自己。像“我是如何‘同谋’创造了我不想要的条件的？”这样的问题，你每天也可以问自己。退一步说，我第一本书的副标题是《领导力与成长的艺术》。成长的艺术是一种修行。它不是一个科学瞬间，不是某天你醒来就完成了。它是一个持续不断的过程，不是持续改进，而是持续探究。当你思考它时可能会感到疲惫，但当你践行它时会感到充满活力。

---

### [01:04:57] Lenny Rachitsky

**English:**
All this, some people may think of as this whole idea of growth mindset. I know that you're not a big fan of this term, that it's used in a harmful way a lot of times. Can you just talk about that why you find that growth mindset as a concept isn't necessarily useful?

**中文翻译:**
所有这些，有些人可能会联想到“成长型思维”这个概念。我知道你不太喜欢这个词，因为它很多时候被以一种有害的方式使用。你能谈谈为什么你觉得成长型思维这个概念并不一定有用吗？

---

### [01:05:18] Jerry Colonna

**English:**
Here's what I have a problem with. First of all, having a growth mindset is a very, very helpful thing. What I have a problem is in having and how we can turn a notion like a growth mindset into a fixed mindset, which is, it's this funny little trick the ego does, and the ego says, "Okay, well, this is a growth mindset. Oh, this is not a growth mindset. Okay, then this is good. This is not good. This is bad. This is..." What Buddhism has taught me is that everything's falling apart all the time even our growth mindset. When we get too fixed on the proper way to do things, we're setting ourselves up for attachment and therefore suffering. So if you can hold something like a mindset loosely with that attachment, go for it. Have a blast. Enjoy it. But the minute you start to nail it down to the floor and say this is the way it ought to be, I ought to always have a growth mindset, you've become fixed. And that's what the ego does.

**中文翻译:**
我的问题在于：首先，拥有成长型思维是一件非常有帮助的事情。我的问题在于，我们如何将“成长型思维”这样的概念变成一种“固定型思维”。这是自我（ego）玩弄的一个有趣的小把戏，自我会说：“好吧，这是成长型思维。噢，这不是成长型思维。好吧，那么这是好的，那是不好的。这是坏的，这是……”佛教教给我的是，一切都在不断瓦解，甚至包括我们的成长型思维。当我们过于执着于做事的“正确方式”时，我们就是在为执念和痛苦埋下伏笔。所以，如果你能不带执念地灵活持有某种思维方式，那就去做吧，尽情享受。但一旦你开始把它钉死在地上，说“事情就该是这样，我应该永远保持成长型思维”，你就变得僵化了。这就是自我所做的。

---

### [01:06:48] Jerry Colonna

**English:**
To be more explicit about it from a business context for example, the great business writer Peter Senge says, "It is virtually impossible to challenge the assumptions that made you rich in the first place." So think about it in our experience of starting a business. We have what the Zen Buddhist would say, beginner's mind, all things are possible. And then, we experience, you were talking about it a little before, a little bit of success, and the ego, which is so terrified of not having success, start to say, "Aha, this is the way to do it." And then, we start to deviate from that because life happens and then the anxiety starts. So the question is, how do you hold a growth mindset loosely knowing that you ought to stay present to the world as it is, respond to the changing dynamics, figure out what's next because that's the growth. So put succinctly, stay attached to the growth and hold mindset a little loosely.

**中文翻译:**
在商业背景下说得更明确一点，伟大的商业作家彼得·圣吉（Peter Senge）曾说：“挑战那些最初让你致富的假设几乎是不可能的。”想想我们创业的经历。我们拥有禅宗所说的“初心”，万事皆有可能。然后，我们经历了一点点成功（就像你之前提到的），而那个极度恐惧失败的“自我”就开始说：“啊哈，这就是成功的方法。”接着，我们开始偏离初心，因为生活总在发生变化，于是焦虑就开始了。所以问题是，你如何灵活地持有成长型思维，同时知道你应该保持对现实世界的觉知，应对不断变化的动态，弄清楚下一步该做什么，因为那才是成长。简而言之：坚持成长，但灵活对待思维方式。

---

### [01:08:07] Lenny Rachitsky

**English:**
I love that. It reminds me of advice. I did a meditation retreat once, and there's always a sense with Buddhism, and it's interesting how often Buddhism and advice from Buddhist teachings comes up on this podcast by the way.

**中文翻译:**
我喜欢这个观点。这让我想起了一个建议。我参加过一次冥想静修，佛教中总有一种感觉——顺便说一句，很有趣的是，佛教和佛教教义的建议在这个播客中出现的频率非常高。

---

### [01:08:18] Jerry Colonna

**English:**
When the student is ready, the teacher will appear. You are inviting it in, but keep going.

**中文翻译:**
当学生准备好了，老师就会出现。是你把它引进来的，请继续。

---

### [01:08:25] Lenny Rachitsky

**English:**
That makes sense as you say that. Interesting. So there's this fear I think people have with Buddhist teachings that you will not be as ambitious and you will not achieve as much if you're not attaching.

**中文翻译:**
你这么说很有道理。有趣。我想人们对佛教教义有一种恐惧，即如果你不执着，你就不会那么有野心，也不会取得那么大的成就。

---

### [01:08:41] Jerry Colonna

**English:**
If you're not anxiously chasing something.

**中文翻译:**
如果你不是在焦虑地追逐某些东西。

---

### [01:08:42] Lenny Rachitsky

**English:**
Yeah, exactly. If you're just like, "Why do I need that? I don't need to be the CEO of the VP because like, oh, I won't attach to that." And then, so people fear that downside. So I asked this question at this retreat and the advice they shared there was don't attach to this idea, but just point your cart in that direction and head there.

**中文翻译:**
是的，没错。如果你想：“我为什么需要那个？我不需要成为 CEO 或副总裁，因为我不会执着于此。”人们害怕这种负面影响。所以我在那次静修中问了这个问题，他们分享的建议是：不要执着于这个想法，但要把你的车头指向那个方向，然后朝那里前进。

---

### [01:09:02] Jerry Colonna

**English:**
Yeah, I like that. Look, the fear you're talking about is the fear of complacency. And if we look at the structures of the mind and we look at our socialization, the way we're socialized to ward off complacency is anxiety. And so, if we go back to some of the things we were saying before, if I grow up believing that the way I'm going to make my parents love me is by achieving, then if I become complacent, then what's at risk is their love for me. So just like we made the connection before where unconditional love exists, unconditional positive regard for self, otherwise known as self-compassion can be a powerful motivator, especially when you get to the point where you say, "As painful as it is for me to write, I enjoy writing. I enjoy working out. I enjoy pushing myself. I don't necessarily enjoy it in the moment." But I certainly, when I look at two books on my desk and I say, "You know what? That feels good. That makes me happy."

**中文翻译:**
是的，我喜欢这个。看，你所说的恐惧是对“自满”或“懈怠”的恐惧。如果我们审视思维结构和社会化过程，我们被社会化去抵御懈怠的方式就是焦虑。所以，回到我们之前说过的，如果我从小相信让父母爱我的方式就是取得成就，那么如果我变得懈怠，面临风险的就是他们对我的爱。所以，就像我们之前建立的联系，当无条件的爱存在时，无条件的自我肯定（也就是自我慈悲）可以成为强大的动力。尤其是当你达到这样一个点，你会说：“虽然写作对我来说很痛苦，但我享受写作。我享受健身。我享受挑战自己。我不一定享受那个瞬间。”但当我看到桌上的两本书时，我会说：“你知道吗？这感觉很好。这让我很快乐。”

---

### [01:10:43] Jerry Colonna

**English:**
To me, the ability to hold the seeming contradiction of those things is a hallmark of my adulthood. It's to get satisfaction out of hard work for me is a much greater motivator than fear of complacency. As I've sort of slip-slided my way into that place, I have found... I work seven days a week. I don't have to, but I enjoy it.

**中文翻译:**
对我来说，能够容纳这些看似矛盾的事物是我成年的标志。从艰苦工作中获得满足感，对我来说是比“害怕懈怠”大得多的动力。当我逐渐进入这种状态后，我发现……我每周工作七天。我不是必须这样做，但我很享受。

---

### [01:11:29] Lenny Rachitsky

**English:**
There's another, maybe a last area I want to spend some time on, which is around teams and what often causes trouble for teams. What breaks teams? What breaks companies? You have this point, you make that it's rarely lack of talent on the team, lack of strategy, lack of execution, that it's something else. What is that something else? What often do you find as the source of the problem for teams that aren't working?

**中文翻译:**
还有另一个领域，也许是最后一个，我想花点时间讨论，那就是关于团队以及经常给团队带来麻烦的原因。是什么毁掉了团队？是什么毁掉了公司？你有一个观点，即很少是因为团队缺乏才华、缺乏战略或缺乏执行力，而是因为别的东西。那“别的东西”是什么？你经常发现那些运转不灵的团队的问题根源是什么？

---

### [01:11:56] Jerry Colonna

**English:**
Well, it's the unresolved, I'll be dramatic with the language, demons from their childhood. It's the unsorted baggage. Here's what happens. Teams are groups, and there are group dynamics that always happen. There is the scapegoat, there is the truth-teller who has to say, "Let me tell you what's really wrong with everything going on." Without the individual's radical self-inquiry skills, groups tend to be condemned to repeating patterns oftentimes of their family of origin.

**中文翻译:**
嗯，是那些未解决的——我用点戏剧性的词——童年阴影。是那些未整理的包袱。情况是这样的：团队是群体，群体动力学总是在发生。有“替罪羊”，有必须说出“让我告诉你到底哪里出了问题”的“真相讲述者”。如果没有个人的激进自我探究技能，群体往往注定会重复某些模式，而这些模式通常源自他们的原生家庭。

---

### [01:12:40] Jerry Colonna

**English:**
I'll tell you a quick story. There's a very famous software blogger, blogger-owned software that I coached for many years, and we were doing an executive team meeting, and something happened in the group as we were talking that I observed once, twice, and three times, and finally, I said, "Okay, guys, I'm seeing something happen here. Every time we get close to talking about something that's really painful, somebody makes a joke and all the energy disappears and everybody laughs and everybody's nice." And as soon as I said it, my client who was CEO at the time said, "Jesus Christ, that's just like my family." It was like, yes, that's just like your family.

**中文翻译:**
我给你讲个小故事。有一位非常著名的软件博主，他拥有一家软件公司，我辅导了他很多年。有一次我们在开高管团队会议，交谈中我观察到群体中发生了一些事情，一次、两次、三次。最后我说：“好了，各位，我看到这里发生了一些事情。每当我们接近谈论一些真正痛苦的事情时，总有人开个玩笑，所有的能量就消失了，大家哈哈大笑，气氛变得很融洽。”我刚说完，当时担任 CEO 的客户就说：“天哪，这简直和我家一模一样。”我说：“没错，这就像你的家庭。”

---

### [01:13:35] Jerry Colonna

**English:**
Carl Jung once said, "Until you make the unconscious conscious, it will direct your life and you will call it fate." Let's apply it here. Until you make conscious the unconscious patterns operating in the group, the group will continue to repeat those patterns and you will blame somebody in the group. Romantic relationships from a Buddhist perspective, part of what we do in romantic relationships is we find the perfect foil for us to work out our unconscious phenomena. When we join a group, when we form up in teams and organizations, we are unconsciously finding the perfect foils for us to work out our own shit. So if you want to create a high-functioning team, do your work, and it starts with the person who has the most power in the group. If that person refuses to do their work, the entire group will become a manifestation of early dysfunction in the individual's lives. Does that make any sense?

**中文翻译:**
卡尔·荣格（Carl Jung）曾说：“除非你将潜意识意识化，否则它将支配你的人生，而你将其称为命运。”让我们把它应用到这里。除非你意识到群体中运作的潜意识模式，否则群体将继续重复这些模式，而你会归咎于群体中的某个人。从佛教的角度看浪漫关系，我们在浪漫关系中所做的部分工作就是找到完美的“衬托”（foil），来解决我们的潜意识现象。当我们加入一个群体，当我们组建团队和组织时，我们是在潜意识里寻找完美的衬托来解决我们自己的烂事。所以，如果你想建立一支高效的团队，请做好你自己的功课，而这一切要从群体中权力最大的人开始。如果那个人拒绝做功课，整个群体就会变成个人生活中早期功能失调的体现。这有道理吗？

---

### [01:14:59] Lenny Rachitsky

**English:**
100%. And this comes up a number of times on this podcast, just the impact the leaders issues have on the rest of the team, and also just this idea that the conditions they're trying to avoid are the conditions they invite in because they're avoiding.

**中文翻译:**
百分之百有道理。这在播客中出现过很多次，即领导者的问题对团队其他成员的影响，以及这样一种观点：他们试图避免的条件，恰恰是因为他们的逃避而招致的条件。

---

### [01:15:14] Jerry Colonna

**English:**
That's it. That's it. One of my favorite teachers and dear friends is Parker Palmer, and he builds on, I think it was Socrates who said, "The unexamined life is not worth living." And he builds on that and makes a joke, and he says, "But if you choose to live an unexamined life, please don't take a job that involves other people." And that's it. You have a responsibility to examine your own shit.

**中文翻译:**
就是这样。我最喜欢的老师和亲爱的朋友之一是帕克·帕尔默（Parker Palmer），他在苏格拉底那句“未经审视的人生不值得过”的基础上开了一个玩笑，他说：“但如果你选择过未经审视的人生，请不要从事涉及他人的工作。”就是这样。你有责任审视你自己的烂事。

---

### [01:15:43] Lenny Rachitsky

**English:**
So say you're on this team, so there's two sides of this. You're on a team, the leaders clearly got some stuff that they need to work through, but they're not. Is there something you can do there other than just, "Hey, please, this is hurting us?" And then from the leader's perspective listening to this, what should they do? Is it get a coach? What can you do?

**中文翻译:**
假设你在这个团队中，这有两个方面。你在一个团队里，领导者显然有一些需要解决的问题，但他们没有去解决。除了说“嘿，拜托，这在伤害我们”之外，你还能做什么？然后从听这个节目的领导者的角度来看，他们应该怎么做？是找个教练吗？还能做什么？

---

### [01:16:01] Jerry Colonna

**English:**
So for the one who has less power?

**中文翻译:**
你是说对于权力较小的那个人？

---

### [01:16:04] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:16:05] Jerry Colonna

**English:**
One of the things to ask oneself is what draws me to this position in the first place? How have I been complicit, not responsible in creating the conditions I say I don't want. How have I benefited from the dysfunction that exists in this organization? And benefit is a funny word. It doesn't necessarily mean I'm making more money. It means, for example, a benefit might be, boy, this feels familiar. I always find myself working on teams that are dysfunctional in this way. What is there in that experience for me to learn? So that's one thing.

**中文翻译:**
要问自己的事情之一是：最初是什么吸引我来到这个职位的？我是如何“同谋”（而非负责）创造了我不想要的条件的？我从这个组织中存在的功能失调中获得了什么好处？“好处”是个有趣的词。它不一定意味着我赚了更多的钱。例如，一种好处可能是：“天哪，这感觉很熟悉。我总是发现自己在这种功能失调的团队中工作。”这段经历中有什么是值得我学习的？这是其一。

---

### [01:16:55] Jerry Colonna

**English:**
You asked about the person who has power. You were using the word leader. I will talk about power, and you threw out, well, should they get a coach? Let's put it into larger context. Should you examine your life with radical self-inquiry? Yes. I would argue that the more power you have, the more moral responsibility you have to actually pause and figure out what it is that you're doing to be complicit in creating the conditions you say you don't want.

**中文翻译:**
你问到有权力的人。你用了“领导者”这个词，而我会谈论“权力”。你提到他们是否应该找个教练？让我们把它放在更大的背景下。你应该通过激进的自我探究来审视你的人生吗？是的。我认为你拥有的权力越大，你就越有道德责任去停下来，弄清楚你到底做了什么，从而“同谋”创造了那些你口口声声说不想要的条件。

---

### [01:17:28] Jerry Colonna

**English:**
To be a very quick example what I'm talking about. A couple of years ago, I was doing a talk at a venture firm's CEO portfolio summit, the portfolio company's CEO summit. And we're sitting in a room, and of course I'm walking around again with shoes off and whatever, and people are firing questions at me. And one woman says, "Well, I'm the CEO of this 15-person company, and I have a question for you. Why is it that nobody on my team can make a decision without me?" And I said, "Who hired them?" And she, "Well..." I said, "Okay, how does it make you feel when they make a decision that you disagree with?" She said, "I'm furious." "Well, how can you hire people whom you expect to make decisions without running them through you if you can't tolerate them making a decision that you disagree with?"

**中文翻译:**
举一个我所说的简短例子。几年前，我在一家风投公司的 CEO 投资组合峰会上做演讲。我们坐在一间屋子里，当然我又没穿鞋走来走去，人们向我抛出各种问题。一位女性说：“我是这家 15 人公司的 CEO，我有一个问题。为什么我团队里的人没有我就做不了决定？”我问：“是谁雇了他们？”她说：“额……”我说：“好，当他们做了一个你不同意的决定时，你感觉如何？”她说：“我很愤怒。”“那么，如果你不能容忍他们做一个你不同意的决定，你又怎么能指望雇佣的人在不经过你同意的情况下做决定呢？”

---

### [01:18:37] Jerry Colonna

**English:**
You want to build a scaled leadership team, you have to be willing to have them make boneheaded decisions. And that's really, really hard, especially if we're "in founder mode" driving all the decisions. So that's your growth edge. We were talking about before about growth mindset. That's your growth edge. How can I be with the people in my life making boneheaded decisions about something that I care so much about and what is the best way for me to be in relationship about that?

**中文翻译:**
如果你想建立一支规模化的领导团队，你必须愿意让他们做一些愚蠢的决定。这非常非常难，尤其是当我们处于“创始人模式”并主导所有决策时。所以这就是你的“成长边缘”。我们之前谈到了成长型思维，这就是你的成长边缘：我该如何面对生活中那些在我非常在意的事情上做出愚蠢决定的人，以及我该以什么样的方式与他们相处？

---

### [01:19:18] Lenny Rachitsky

**English:**
So much of this comes back to that question we started this with of just how are you complicit in creating the conditions you don't want? A big takeaway for me here, and it just keeps coming up and again and again, is if you're struggling as a leader, if your company's not working as well as you wanted to, if you're having a hard time with your team, going back to that equation, it's not about building more skills like public speaking skills or email skills, or I don't know, financial skills. It's self-awareness, radical self-inquiry, understanding what drives you, what makes you happy. Is that generally correct?

**中文翻译:**
这一切又回到了我们开始时的那个问题：你是如何“同谋”创造了你不想要的条件的？对我来说，这里的一个重要收获（而且它不断出现）是：如果你作为领导者感到挣扎，如果你的公司运作不如预期，如果你在团队管理上遇到困难，回到那个等式，关键不在于培养更多技能，比如演讲技巧、邮件技巧或财务技能。而是自我觉察、激进的自我探究，了解什么在驱动你，什么让你快乐。大体上是这样吗？

---

### [01:19:51] Jerry Colonna

**English:**
Lenny, I was just going to say, you just made me so happy you saying what you just said. Yes. I've been coaching now, as I said for a couple of decades. Before that, I was a VC for 15, 17 years. What you just said is the wisdom of my 40 years as an adult. That's it. This is why radical self-inquiry is so damned important because it leads to a little bit less suffering and a lot more resilience.

**中文翻译:**
Lenny，我正想说，你刚才的话让我太开心了。是的。正如我所说，我已经做了几十年的教练，在那之前我做了 15 到 17 年的风投。你刚才所说的就是我作为成年人 40 年来的智慧结晶。就是这样。这就是为什么激进的自我探究如此重要，因为它能减少痛苦，增加韧性。

---

### [01:20:28] Lenny Rachitsky

**English:**
For folks that want to actually do that, well, they can rewind back to the middle of the episode where we actually ask the questions that are associated with the radical self-inquiry, and then obviously if they want to dig deeper, they can buy your book.

**中文翻译:**
对于那些真正想这样做的人，他们可以倒回到本集的中部，那里有我们提出的与激进自我探究相关的问题。当然，如果他们想深入挖掘，可以买你的书。

---

### [01:20:41] Jerry Colonna

**English:**
Or 10 copies of the book.

**中文翻译:**
或者买 10 本。

---

### [01:20:43] Lenny Rachitsky

**English:**
Or 100 copies for everyone at the company willing to Amazon. Jerry, is there anything else that we haven't touched on that you think is really important for people to hear maybe as the last piece of wisdom?

**中文翻译:**
或者在亚马逊上给公司每个人买 100 本。Jerry，还有什么我们没提到、但你认为对大家非常重要的最后一点智慧吗？

---

### [01:20:57] Jerry Colonna

**English:**
Now one of the hopes that I have you ask me at the start like what would be my hope is that we ended up being closer and friends, and I feel that. Let me extend that out to everybody. What I always hope from all of these intimate conversations that I try to do in podcasts is that people walk away going, "Geez, I'm not alone." We've made different references to the fact that it's a hard time. The truth is it's always a hard time. And what makes it hardest is to feel like I'm the only one who's going through this. So what I appreciate about what you do, Lenny, is that under the guise of talking about product, you're really talking about the process of being human. And that is a mitzvah. That's a good deed. And so, I hope in the process of listening to this, people walk away going, "Okay, I feel a little bit better today."

**中文翻译:**
你在开始时问我有什么期望，我的期望是我们能成为更亲近的朋友，我感受到了这一点。让我把这种期望延伸到每个人。我一直希望通过播客中这些亲密的对话，让人们在听完后会想：“天哪，我并不孤单。”我们多次提到现在是个艰难的时期。事实是，任何时候都是艰难的时期。而最艰难的部分是觉得只有我一个人在经历这些。所以，Lenny，我非常欣赏你所做的事情，因为在讨论产品的外表下，你实际上是在讨论作为人的过程。这是一件善事（mitzvah）。所以我希望在听完这期节目后，人们离开时会想：“好吧，我今天感觉好一点了。”

---

### [01:22:04] Lenny Rachitsky

**English:**
I really appreciate that. The way I think about these sorts of conversations and episodes, I call them Trojan Horse episodes where people come for the other stuff, tactical, practical stuff, and then they get stuff they really need to hear. And so, I appreciate you. Jerry, thank you so much for being here.

**中文翻译:**
我非常感激。我把这类对话和剧集称为“特洛伊木马”剧集，人们为了战术、实际的东西而来，却得到了他们真正需要听到的东西。所以我很感激你。Jerry，非常感谢你能来到这里。

---

### [01:22:19] Jerry Colonna

**English:**
Thank you for having me. It was a delight.

**中文翻译:**
谢谢你的邀请。非常愉快。

---

### [01:22:22] Lenny Rachitsky

**English:**
Same for me. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
我也是。再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。