# Jess Lachs - Lenny's Podcast

这是一份针对 Lenny's Podcast 与 DoorDash 数据科学副总裁 Jess Lachs 对话的深度分析报告。

---

# Jess Lachs - Lenny's Podcast 深度分析报告

---

## 🎙️ 主持人介绍

**Lenny Rachitsky**
- **身份**: 前 Airbnb 产品负责人，全球顶尖产品管理专家。
- **背景**: 在 Airbnb 工作 7 年，曾领导供应增长团队。他撰写的 Newsletter 是全球产品经理的“圣经”。
- **核心价值**: 擅长挖掘硅谷最成功公司背后的增长逻辑、组织架构和产品方法论。
- **社交媒体**:
  - LinkedIn: [Lenny Rachitsky](https://www.linkedin.com/in/lennyrachitsky/)
  - Newsletter: [Lenny's Newsletter](https://www.lennysnewsletter.com/)

---

## 🎤 嘉宾介绍

**Jess Lachs**
- **身份**: DoorDash 合伙人、数据科学与分析副总裁（VP of Analytics and Data Science）。
- **职业经历**:
  - **DoorDash** (2014 - 至今): 效力超过 10 年。最初是公司首位总经理（GM），负责从零开始启动波士顿等新市场，后转型并组建了全球顶尖的数据团队。
  - **GiftSimple** (2011 - 2014): 创始人，社交礼品初创公司。
  - **Lehman Brothers** (2006 - 2008): 投资银行分析师。
- **核心专长**: 数据驱动决策、组织架构设计（中心化模型）、指标定义与激励对齐、市场启动策略。
- **社交媒体**:
  - LinkedIn: [Jessica Lachs](https://www.linkedin.com/in/jessicalachs/)

---

## 📝 内容概要

本期播客深度探讨了 DoorDash 如何构建其极具影响力的分析团队。Jess Lachs 分享了她极具“逆向思维”的观点：**为什么数据团队应该采用中心化汇报架构而非嵌入式？** 她详细拆解了如何定义能够驱动业务增长的指标（而非虚荣指标），以及如何通过“通用货币”模型在复杂的四方市场（消费者、商家、骑手、平台）中做权衡决策。此外，她还分享了从投行精英到初创公司“扫地僧”的职业转变，以及 DoorDash 早期极度负责任（Extreme Ownership）的文化细节。

---

## 🏷️ 核心话题

`数据组织架构` `中心化模型` `输入指标 vs 输出指标` `极度负责任` `通用货币模型` `人才招聘`

---

## 💡 核心论点

### 论点一：中心化数据组织模型（Center of Excellence）优于嵌入式

**核心观点**: 数据人员应汇报给中心化数据负责人，而非业务部门负责人。

- **人才标准一致性**: 中心化管理能确保全公司数据人才的招聘门槛和技术水平高度统一，避免业务部门为了短期需求降低招聘标准。
- **职业成长路径**: 在业务部门内，数据人员往往面临晋升天花板；中心化架构提供了跨部门流动的机会（如从营销分析转到商户分析），有助于留住顶尖人才。
- **消除数据孤岛**: 避免不同部门对同一个指标（如“销售额”）有不同定义，确保全公司使用同一套方法论。

> "Analytics is a business impact driving function and not purely a service function."
> — Jess Lachs

### 论点二：留存率（Retention）是糟糕的考核目标

**核心观点**: 留存率是长期输出指标，难以在短期内通过实验直接驱动。

- **寻找输入指标**: 团队应寻找能驱动留存的短期可观测指标（Input Metrics）。
- **简单胜过复杂**: 避免使用复杂的加权复合指标。如果一个指标需要解释半天（如 0.35 的健康分），团队将失去直觉。
- **失败状态监控**: 除了关注平均值，必须关注“极端失败案例”（如 Never Delivered 订单），这些案例对品牌和留存的伤害远超平均值的波动。

### 论点三：建立业务决策的“通用货币”（Common Currency）

**核心观点**: 将所有业务动作（降价、提速、增加品类）转化为统一的价值衡量标准。

- **量化权衡**: 如果降低 1 美元配送费能带来 X 订单量，而缩短 1 分钟配送时间能带来 Y 订单量，通过模型将它们统一转化为 GOV（总交易额）影响，管理者就能清晰决定资源投向。
- **跨团队对齐**: 营销团队和物流团队不再争吵，因为大家都在用同一种“语言”讨论对业务的贡献。

---

## ✅ 数据验证结果

**验证项 1**: DoorDash 的“WeDash”计划（员工必须去送外卖）。
- 原文声称: "所有员工（包括高管）每年至少四次亲自送货或做客服。"
- 验证结果: ✅ 确认
- 来源: [DoorDash 官方新闻稿及财报说明](https://doordash.news/culture/doordash-reintroduces-wedash-employee-program/)
- 可信度: ⭐⭐⭐

**验证项 2**: 2014 年波士顿冬季气候对启动的影响。
- 原文声称: "2014 年冬天在波士顿街头分发带有 Kind Bars 的优惠券。"
- 验证结果: ✅ 确认。2014-2015 年冬季是波士顿历史上降雪量最大的年份之一，这对刚启动的配送业务是极大挑战。
- 来源: [National Weather Service 历史记录](https://www.weather.gov/box/winter2014-15)
- 可信度: ⭐⭐⭐

**验证项 3**: 留存率作为滞后指标的行业共识。
- 原文声称: "Retention is a terrible thing to goal on... it's a long-term output."
- 验证结果: ✅ 确认。Reforge 等顶级增长机构均强调“输入指标”管理。
- 来源: [Reforge: Retention is a Lagging Indicator](https://www.reforge.com/blog/retention-is-a-lagging-indicator)
- 可信度: ⭐⭐⭐

---

## 🎯 四维分类评估

### 🟢 高度正确（行业共识）

**观点 1**: 关注分布而非平均值。
- 验证依据: 在物流和配送行业，长尾的糟糕体验（如订单丢失）对用户流失的影响是非线性的。

**观点 2**: 招聘中的“好奇心”不可教。
- 验证依据: 顶级数据分析师的区别不在于 SQL 熟练度，而在于是否会主动追问数据背后的“为什么”。

### 🔵 当下可执行（实操建议）

**建议 1**: 建立“数据办公时间”（Office Hours）。
- 执行方法: 每周固定 2 小时，数据团队开放咨询，帮助非技术同事修改 SQL 或讨论业务逻辑，减少 Jira 工单堆积。

**建议 2**: 采用“通用货币”模型。
- 执行方法: 尝试将不同部门的 KPI（如转化率、点击率、配送时长）通过历史数据回归分析，统一折算为对核心指标（如 GMV）的贡献值。

### 🟡 理智质疑（需视情况而定）

**存疑点**: 中心化模型是否会导致响应速度变慢？
- 质疑原因: 许多初创公司发现，数据人员如果离业务太远，会不理解业务背景。Jess 的方案是通过“逻辑中心化、物理嵌入化”（Pod 结构）来平衡，但这需要极强的管理能力。

---

## 🔑 关键洞察

1. **分析不是服务，而是驱动**: 数据团队不应是“接单员”（Jira 票据处理者），而应是业务合伙人，主动提出“既然我们知道了这个，下一步该做什么？”。
2. **极度负责任（Extreme Ownership）**: 早期员工不分职位。数据科学家在系统宕机时应主动去送外卖或打客服电话，这种文化决定了公司的韧性。
3. **人才的“净进口”**: 优秀的组织应该能吸引非专业背景的人才（如运营、财务）转型加入并胜任，这说明组织的方法论具有普适性和教育能力。
4. **真理寻求者（Truth Seekers）**: 在信息爆炸时代，数据团队的核心价值是剥离噪音，寻找事实真相，即使真相令人痛苦（如发现某个营销渠道全是欺诈）。
5. **睡眠委员会**: 遇到复杂或情绪化问题，不要立即回复，让“睡眠委员会”处理一晚，第二天往往会有更清晰、理智的决策。

---

## 🛠️ 提到的工具/资源

**工具 1**: **Libby**
- 说明: Jess 强烈推荐的图书馆借阅 App，用于免费阅读电子书和听书。
- 链接: [Libby App](https://www.overdrive.com/apps/libby)

**工具 2**: **Ask Data AI**
- 说明: DoorDash 内部开发的 AI 聊天机器人，帮助非技术员工通过自然语言修改 SQL 查询。

**推荐阅读**: **《The Rose Code》 (Kate Quinn)**
- 说明: 关于二战女性密码破译员的历史小说，Jess 推荐，与其解决问题的职业本能契合。
- 链接: [Amazon 链接](https://www.amazon.com/Rose-Code-Novel-Kate-Quinn/dp/006294347X)

---

## 📋 行动建议

### 🚀 立即可做（今天）
- [ ] **检查你的 KPI**: 看看你的团队是否在考核“留存率”或“GMV”等无法直接控制的输出指标？如果是，尝试列出 3 个能驱动它们的输入指标。
- [ ] **停止回复情绪化邮件**: 实践 Jess 的“睡眠委员会”法则，明天早上再发。

### 📅 本周尝试
- [ ] **设立 Office Hours**: 在 Slack 或飞书上公布一个固定时间段，欢迎任何同事来咨询数据问题。
- [ ] **寻找“Never Delivered”**: 在你的业务中寻找那个发生率极低但伤害极大的“失败状态”，并为其建立监控。

---

## ⭐ 评分

**知识价值**: 9/10
- 提供了极高维度的组织设计和指标哲学思考。

**可执行性**: 8/10
- “通用货币”模型和“输入指标”理论非常落地。

**商业潜力**: 9/10
- 对于多边市场（Marketplace）从业者具有极强的指导意义。

**综合评分**: **9/10**

---

*来源*: Lenny's Podcast
*嘉宾*: Jess Lachs (VP of Analytics @ DoorDash)
*生成时间*: 2024-05-23