# Jessica Hische - 双语对照

This is the complete bilingual transcript of Lenny's Podcast featuring design legend Jessica Hische.

---

### (00:00:00) Jessica Hische

**English:**
Most people are better at understanding the feelings and sensations that typography and logos give us than they give themselves credit for, because what we are as people are endless absorbers of patterns, and information, and all this kind of stuff as we move throughout the world. We don't take time to sit and digest it, but it's still coming in and getting logged, and so even as a non-designer, I think you can look at examples of logos where something's not quite right and be like, "Something's not right here, I just don't know how to name it." But I think a good exercise is just like looking at fonts that are available in the world and asking yourself, "What feeling does this give me?"

**中文翻译:**
大多数人其实比他们想象中更擅长理解字体排印（Typography）和标志（Logos）带给我们的感觉。因为作为人类，我们在世界上行走时，本质上是模式、信息和各种事物的无尽吸收者。虽然我们没有花时间坐下来消化它，但这些信息仍在不断涌入并被记录下来。所以，即使作为一个非设计师，我认为当你看到一些不太对劲的标志时，你也会心想：“这里有点不对劲，我只是不知道该怎么描述它。”我觉得一个很好的练习就是观察世界上现有的字体，然后问自己：“这给了我什么样的感觉？”

---

### (00:00:47) Lenny Rachitsky

**English:**
Today, my guest is Jessica Hische. Jessica is a design legend, and it was such an honor to both have her on this podcast and also to work with her on a refresh of my newsletter and podcast logo and brand, which is launching around the same time as this episode comes out. Jessica is a lettering artist specializing in typographical work for logos, film, books, and other commercial applications. Her clients include Wes Anderson, the United States Postal Service, Apple, Nike, Tiffany and Company, The Gap, and Penguin Books, and her work has been featured in design and illustration annals, both in the U.S. and internationally. She's helped create logos for Philz Coffee, Eventbrite, and Mailchimp, is a best-selling children's book author, and if you live around the Bay Area, you've seen her work all over the city without knowing it. In our conversation, Jessica shares the process that she went through to update my logo and brand for my newsletter and podcast.

**中文翻译:**
今天的嘉宾是 Jessica Hische。Jessica 是设计界的传奇人物。能邀请她参加播客，并与她合作翻新我的时事通讯和播客的标志及品牌，我感到非常荣幸。这个新品牌将与本期节目同步发布。Jessica 是一位艺术字体家（Lettering Artist），专门从事标志、电影、书籍和其他商业应用的字体设计工作。她的客户包括韦斯·安德森（Wes Anderson）、美国邮政署、苹果、耐克、蒂芙尼、盖璞（The Gap）和企鹅出版集团。她的作品曾多次入选美国及国际的设计与插画年鉴。她曾协助创作了 Philz Coffee、Eventbrite 和 Mailchimp 的标志，还是一位畅销童书作家。如果你住在湾区，你可能在不知不觉中已经在城市各处见过她的作品。在我们的对话中，Jessica 分享了她为我的时事通讯和播客更新标志及品牌的过程。

---

### (00:01:38) Lenny Rachitsky

**English:**
What specific elements of a logo and brand impact how you feel about that brand, why a good enough logo is just buying for a long time for most startups, and when it makes sense to refresh your look, also some really clever productivity tips, design advice, and a bunch of really fun stories. Jessica is a master at what she does and I am excited to spread the Jessica Hische gospel. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes, and it helps the podcast tremendously. With that, I bring you Jessica Hische. Jessica, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
我们将讨论标志和品牌中的哪些具体元素会影响你对该品牌的感受，为什么对于大多数初创公司来说，一个“足够好”的标志可以维持很长时间，以及什么时候更新视觉形象才有意义。此外，还有一些非常聪明的生产力技巧、设计建议和一堆有趣的故事。Jessica 是她所在领域的专家，我很兴奋能传播“Jessica Hische 的设计福音”。如果你喜欢这个播客，别忘了在您常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最佳方式，也对播客有巨大的帮助。现在，让我们欢迎 Jessica Hische。Jessica，非常感谢你能来，欢迎来到播客。

---

### (00:02:19) Jessica Hische

**English:**
Happy to be here.

**中文翻译:**
很高兴来到这里。

---

### (00:02:21) Lenny Rachitsky

**English:**
I thought it'd be good to start with asking you just to describe what it is you do, because you're very atypical of the kinds of guests I have in this podcast and you also have very unique skillset.

**中文翻译:**
我想先请你描述一下你的工作内容，因为你和我这个播客以往邀请的嘉宾非常不同，你拥有一套非常独特的技能。

---

### (00:02:32) Jessica Hische

**English:**
Yes. Well, I will describe what I'm most prominently known for, because I'm a person who just does a lot of things, but the thing that I do the most professionally is custom typography, like bespoke lettering pieces. That translates to working for all kinds of things. Sometimes it's for film and television. I've done movie titles and things like that and television credits and stuff. Sometimes it's book covers. Actually, a lot of times, it's book covers, and then a big part of my business is doing logos, and logo refreshes, and things like that, so basically being the person who knows all the things so you don't have to have that person on staff when it comes to typography.

**中文翻译:**
好的。我会描述一下我最出名的身份，因为我是一个做很多事情的人。但我最专业的领域是定制字体设计（Custom Typography），比如定制的艺术字作品。这可以应用到各种领域。有时是电影和电视，我做过电影片名和电视片尾字幕之类的。有时是书封，实际上很多时候都是书封。此外，我业务的一大部分是设计标志、标志翻新等。基本上，我就是那个精通字体排印所有知识的人，这样公司就不必专门雇佣一名全职的字体专家。

---

### (00:03:17) Lenny Rachitsky (Sponsorship)

**English:**
This episode is brought to you by the Enterprise Ready Conference, a one-day event in San Francisco bringing together product and engineering leaders shaping the future of enterprise SaaS. The event features a curated list of speakers with direct experience building for the enterprise, including leaders from OpenAI, Vanta, Checkr, Dropbox, and Canva. Topics include advanced identity management, compliance, encryption, and logging, essentially at complex features that most enterprise customers require. If you're a founder, exec, product manager, or engineer tasked with the enterprise roadmap, this conference is for you. You'll get detailed insights from industry leaders that have years of experience navigating the same challenges that you face today. Best of all, it's completely free. Since it's hosted by WorkOS. Spots are filling up quickly, make sure to request an invite at enterpriseready.com. That's enterpriseready.com. I am excited to chat with Christina Gilbert, the founder of OneSchema, one of our longtime podcast sponsors. Hi, Christina.

**中文翻译:**
本期节目由 Enterprise Ready 大会赞助。这是一场在旧金山举行的为期一天的活动，汇集了塑造企业级 SaaS 未来的产品和工程领导者。活动邀请了具有构建企业级产品直接经验的演讲者，包括来自 OpenAI、Vanta、Checkr、Dropbox 和 Canva 的领导者。主题包括高级身份管理、合规性、加密和日志记录，基本上是大多数企业客户所需的复杂功能。如果你是负责企业路线图的创始人、高管、产品经理或工程师，这场会议非常适合你。你将从拥有多年应对挑战经验的行业领导者那里获得详细见解。最棒的是，它是完全免费的，由 WorkOS 主办。名额有限，请务必在 enterpriseready.com 申请邀请。接下来，我很高兴能与 OneSchema 的创始人 Christina Gilbert 聊天，她是我们的长期赞助商之一。你好，Christina。

---

### (00:04:21) Christina Gilbert

**English:**
Yes. Thank you for having me on, Lenny.

**中文翻译:**
是的，谢谢你邀请我，Lenny。

---

### (00:04:23) Lenny Rachitsky

**English:**
What is the latest with OneSchema? I know you now work with some of my favorite companies like Ramp, Vanta Scale, and Watershed. I heard that you just launched a new product to help product teams import CSVs from especially tricky systems like ERPs.

**中文翻译:**
OneSchema 最近有什么新动态？我知道你们现在与我最喜欢的一些公司合作，如 Ramp、Vanta Scale 和 Watershed。我听说你们刚刚推出了一款新产品，帮助产品团队从 ERP 等特别棘手的系统中导入 CSV 文件。

---

### (00:04:39) Christina Gilbert

**English:**
Yes. We just launched OneSchema FileFeeds, which allows you to build an integration with any system in 15 minutes as long as you can export a CSV to an SFTP folder. We see our customers all the time getting stuck with hacks and workarounds, and the product teams that we work with don't have to turn down prospects because their systems are too hard to integrate with. We allow our customers to offer thousands of integrations without involving their engineering team at all.

**中文翻译:**
是的。我们刚刚推出了 OneSchema FileFeeds，只要你能将 CSV 导出到 SFTP 文件夹，它就能让你在 15 分钟内构建与任何系统的集成。我们经常看到客户被各种临时方案和变通方法困扰，而与我们合作的产品团队不必因为系统太难集成而拒绝潜在客户。我们让客户能够提供数千种集成，而完全不需要工程团队参与。

---

### (00:05:01) Lenny Rachitsky

**English:**
I can tell you that if my team had to build integrations like this, how nice would it be to be able to take this off my roadmap and instead use something like OneSchema, and not just to build it but also to maintain it forever.

**中文翻译:**
我可以告诉你，如果我的团队必须构建这样的集成，能把它从我的路线图中拿掉并改用 OneSchema 这样的工具该有多好，不仅是构建，还包括永久的维护。

---

### (00:05:12) Christina Gilbert

**English:**
Absolutely, Lenny. We've heard so many horror stories of multiday outages from even just a handful of ad records. We are laser-focused on integration reliability to help teams end all of those distractions that come up with integrations. We have a built-in validation layer that stops any bad data from entering your system, and OneSchema will notify your team immediately of any data that looks incorrect.

**中文翻译:**
绝对如此，Lenny。我们听过太多关于哪怕只有几条广告记录就导致数天停机的恐怖故事。我们专注于集成的可靠性，帮助团队消除集成带来的所有干扰。我们有一个内置的验证层，可以阻止任何错误数据进入你的系统，OneSchema 会立即通知你的团队任何看起来不正确的数据。

---

### (00:05:32) Lenny Rachitsky

**English:**
I know that importing incorrect data can cause all kinds of pain for your customers and quickly lose their trust. Christina, thank you for joining us. If you want to learn more, head on over to oneschema.co. That's oneschema.co.
(00:05:47):
Part of the reason I was excited to have you on this podcast is that I was lucky enough to get to work with you on a refresh of my logo and brand for my newsletter and my podcast, which I'm very, very excited about. It's actually going to be launching right around the time of this episode going live, so this is, in part, a celebration of the new look, and logo, and brand. I thought it'd be an awesome excuse to bring you on the podcast and give an inside glimpse into the process of updating a logo and a brand. Partly, because I think it'll just be people are like, "What the hell? How did this change? Where did this come from? Why this versus that?" and also just for people that are thinking about this for their own product or business, to understand the process and understand when it might be right for them, when it might be not right for them. Broadly, how does that sound?

**中文翻译:**
我知道导入错误数据会给客户带来各种痛苦，并迅速失去他们的信任。Christina，谢谢你加入我们。如果你想了解更多，请访问 oneschema.co。
(00:05:47):
我很高兴邀请你参加这个播客的部分原因是，我很幸运能与你合作，为我的时事通讯和播客翻新标志和品牌，我对此非常兴奋。它实际上将在本集节目上线前后发布，所以这在某种程度上是对新形象、新标志和新品牌的庆祝。我想这是一个绝佳的借口，把你请到播客上，让大家深入了解更新标志和品牌的过程。部分原因是，我想人们会好奇：“天哪，这是怎么改变的？这是从哪儿来的？为什么选这个而不选那个？”同时也为了那些正在考虑为自己的产品或业务做这件事的人，让他们了解这个过程，并明白什么时候适合做，什么时候不适合。总的来说，你觉得怎么样？

---

### (00:06:32) Jessica Hische

**English:**
Sure. Yeah, of course. Everybody that starts a company knows that they need a logo. That is a big thing. Some people start a company and think the logo is going to drive the culture of the company, which I don't think that that is true. I think that the product itself, and the team you build, and the people you put together are the thing that should be driving things forward, but I do think the logo and the brand assets can generate a lot of both internal and external excitement and just tell people what to expect from the thing that they're about to engage with. Some people say don't judge a book by its cover. I'm the opposite, where any book... The cover of the book should be giving you incredible insight into what is on the interior of the book and setting the tone and setting the vibe so that when you open the book and read the book, it's a symbiotic thing where you're like, "Oh, I understand what I was getting into. This got me excited about starting it," and whatever. It keeps that ball rolling.

**中文翻译:**
当然可以。每个创办公司的人都知道他们需要一个标志，这是一件大事。有些人创办公司时认为标志会驱动公司的文化，但我认为事实并非如此。我认为产品本身、你建立的团队以及你聚集的人才才是推动事物前进的核心。但我确实认为标志和品牌资产可以产生大量的内部和外部兴奋感，并告诉人们对他们即将接触的事物有什么期待。有些人说“不要以貌取人（不要通过封面判断一本书）”，我恰恰相反。任何书的封面都应该让你对书的内容有深刻的洞察，并定下基调和氛围，这样当你打开书阅读时，它是一种共生关系，你会觉得：“哦，我明白我要读的是什么了。这让我对开始阅读感到兴奋。”它能让这种动力持续下去。

---

### (00:07:34) Jessica Hische

**English:**
But with the refresh work that I do, a lot of people start companies and they have a certain amount of money. If they're bootstrapping it, they have less. If they get venture money, they have a little bit more. But what they don't want to do is spend venture money on a massive brand exploration when you're still in the hiring process, you're still trying to get early stage engineers, and all that kind of stuff, and so I am sort of a weird contrarian in this way in the brand world where brand people are like, "Brand is everything. You need to take a significant investment in brand because that guides the vision of the product or whatever." But I think being a bit more of an insider within the tech world, I understand that sometimes people start companies and have an intention to do something.

**中文翻译:**
但在我所做的品牌翻新工作中，我发现很多人创办公司时资金有限。如果是自筹资金，钱就更少；如果是风险投资，钱会多一点。但当公司还处于招聘阶段、还在努力寻找早期工程师时，他们不想把风投的钱花在庞大的品牌探索上。在品牌界，我有点像个“异类”或“逆向思维者”，因为品牌专家通常会说：“品牌就是一切。你需要对品牌进行重大投资，因为它引导着产品的愿景。”但作为科技圈的内部人士，我明白有时候人们创办公司时是有某种意图的。

---

### (00:08:24) Jessica Hische

**English:**
While they're doing that, they're building the team, they're doing cool stuff, but then the company has to pivot for one reason or another, whether a competitor immediately comes out with a thing that you're doing or the technology that you're doing gets postponed, whatever's going to feed into it, and so if you invest super heavily on the whole brand vision from the jump, sometimes it's like throwing away money if you have to pivot. What I love about the work that I do is that I understand that a lot of people have to just have something to put on decks and have something to put on a holding page or whatever, and internal teams are totally capable of doing that early work. But then if it does become successful, you don't want to get locked into whatever it is that you had to throw together before an investor meeting or something.

**中文翻译:**
在他们建立团队、做酷事的过程中，公司可能会因为各种原因不得不转型（Pivot），比如竞争对手突然推出了类似的产品，或者你正在研发的技术被推迟了。如果你从一开始就在整个品牌愿景上投入巨资，一旦需要转型，那就像是在扔钱。我热爱我的工作的一点是，我理解很多人早期只需要一些东西放在演示文稿（Decks）或占位页面上，内部团队完全有能力完成这些早期工作。但如果公司真的成功了，你肯定不想被那些为了应付投资者会议而临时拼凑出来的东西给锁死。

---

### (00:09:15) Jessica Hische

**English:**
I come in then to take the existing vibe and smooth it out, address any of the concerns that came up. A lot of times, it's really utilitarian stuff like this doesn't scale well, or this thing falls apart in this context, or we never had a good avatar version of it, or whatever. Sometimes it's really specific utilitarian fixes, and sometimes it's just about growing it up and sophisticated it without losing what was there in the first place that people got excited about.

**中文翻译:**
我介入的时机通常是接手现有的氛围并将其打磨平滑，解决出现的任何问题。很多时候，这些问题是非常实用主义的，比如“这个标志缩小时看不清”、“在某种场景下效果很差”或者“我们一直没有一个好的头像版本”等等。有时是非常具体的实用性修复，有时则是为了让品牌变得更成熟、更精致，同时又不丢失最初让人们感到兴奋的特质。

---

### (00:09:46) Lenny Rachitsky

**English:**
To give people maybe a couple more tactical piece of advice here, what's a sign that it's maybe time to do something with your logo and brand from you took a first pass, it's good enough, your wife made one, your husband made you a logo, it's like, "Well, this is great. Let's just go with this"? What's a sign that maybe it's time to, "Okay, we should actually at least uplevel this, not necessarily hire studio but takes something to make it better"?

**中文翻译:**
为了给听众一些更具战术性的建议，如果一开始只是随便弄了一个“足够好”的标志，比如妻子或丈夫帮忙画了一个，当时觉得“挺好，就用这个吧”，那么出现什么迹象说明是时候该对标志和品牌做点什么了？什么时候该意识到“好吧，我们至少应该提升一下它的档次，不一定要雇佣工作室，但得做点什么让它变得更好”？

---

### (00:10:10) Jessica Hische

**English:**
Well, one of the things is if, suddenly, you're starting to deal with the greater rollout of the look and feel of the brand. If you, at first, just basically had a really beta website and small version of the app but you're about to do a new one that kind of updates and expands it, that could be a really good time to roll it out. One of the things that a lot of people do when they're starting a company is that they'll make a logo with a font that is really popular or widely available or free. If you are about to, let's say, print a bunch of swag for new hires, or you're hosting a conference, or whatever is that event where suddenly you're going to physically invest money in making stuff with your brand on it, that might be a good time to do it.

**中文翻译:**
嗯，其中一个迹象是，如果你突然开始处理品牌视觉形象的大规模推广。如果你最初只有一个非常简陋的测试版网站和应用，但现在准备推出一个更新、更全面的版本，那就是一个很好的时机。很多人在创业初期会使用非常流行、随处可见或免费的字体来制作标志。如果你准备为新员工印制一批周边（Swag），或者要举办一场会议，或者任何需要你投入真金白银去制作带有品牌标识的实物时，那可能就是个好时机。

---

### (00:11:03) Jessica Hische

**English:**
One of the reasons why I tell people why having a custom logo or custom typography can really matter is that if you're using something that's available to everyone, the chances of someone else coming in and copying you are very easy and high. You might be one of these lucky companies that just out the gate is outrageously successful, but with success comes people climbing up behind you trying to copy your success. If that success is very easily copyable and people will try to trick your customers into coming their way by repeating the things that you're doing, including the branding, one way to avoid that is by doing something that's more customized when it comes to the logo and brand.

**中文翻译:**
我告诉人们定制标志或定制字体之所以重要的原因之一是：如果你使用的是每个人都能轻易获得的东西，那么别人抄袭你的门槛就很低，可能性很高。你可能是那些一出门就获得巨大成功的幸运公司之一，但成功随之而来的是追随者试图复制你的成功。如果这种成功很容易被复制，而且人们试图通过重复你所做的事情（包括品牌设计）来诱导你的客户，那么避免这种情况的一种方法就是在标志和品牌上做一些更具定制化的东西。

---

### (00:11:47) Lenny Rachitsky

**English:**
Let's actually talk about the work that you put into updating my logo and brand. From that, we can spin off into lessons and insights that you have along these lines. Overall, just high level, what's the process you go through to go through a logo refresh?

**中文翻译:**
让我们谈谈你为更新我的标志和品牌所做的工作。我们可以以此为切入点，探讨你在这方面的经验和见解。总的来说，从宏观角度看，你进行标志翻新的流程是怎样的？

---

### (00:12:01) Jessica Hische

**English:**
Sure, of course. Super high level, it's figuring out what the goals are. Some people have a goal where they want their customers to not notice it at all. They're like, "Oh, everybody loves this, but I, the person with a design eye, can see all the problems with it. I need to roll something out that fixes the problems that I see but that no one else really notices." If that's one approach to it, which is a very close in refresh where we're just trying out little things to make it feel custom or fixing things that have come up when stress-tested, whether it looks crazy when you scale it and looks like horsey and heavy-handed when you scale it too big or when you scale it too small, you lose a lot of legibility and stuff like that. That's what would be a really close in exploration.

**中文翻译:**
当然。从最高层面来说，首先要弄清楚目标是什么。有些人的目标是让客户完全察觉不到变化。他们会说：“大家都喜欢这个，但我作为一个有设计眼光的人，能看出它所有的缺陷。我需要推出一个版本，修复我看到的这些问题，但又不让其他人察觉。”这是一种“微调式翻新（Close-in refresh）”，我们只是尝试一些小细节让它感觉更具定制感，或者修复压力测试中出现的问题——比如放大后是否显得笨重（Horsey），或者缩小后是否失去了可读性。这就是非常细微的探索。

---

### (00:12:53) Jessica Hische

**English:**
For other people, they might have bigger goals where they're about to pivot the company to try to attract a different audience or things like that. They might have this really cool and successful group of people that are super users but they're trying to expand it, so then it's about, "What can we do to shift the vibe to make it include these new people without excluding our core folks?" My first round is figuring out what that scope is, how experimental, how broad are we going to go for that first round, because then everything else cascades from there. If we go really broad for the first round, then we're in this process of narrowing down the scope as we go down. Whereas if we go really close in for the first round, we're already just talking about really technical stuff.

**中文翻译:**
对于另一些人，他们可能有更大的目标，比如公司即将转型以吸引不同的受众。他们可能已经拥有一群非常成功的核心超级用户，但他们想要扩大规模，所以问题就变成了：“我们如何改变氛围，在不排斥核心用户的前提下吸引新用户？”我的第一轮工作是确定范围：第一轮我们要走多远？实验性有多强？范围有多广？因为之后的一切都会由此展开。如果我们第一轮走得很广，那么接下来的过程就是不断缩小范围；如果我们第一轮就很聚焦，那么我们已经在讨论非常技术性的细节了。

---

### (00:13:45) Jessica Hische

**English:**
This is another thing that is a little bit unique to me that not everybody else does, but I will hand off files to clients to try in situ really early on if what we're trying to do is solve utilitarian issues. Most other people are like, "No, you don't get the files until we do the final because I don't want you to run away with this or whatever." There has to be some trust with it. Yeah, figure out what we're trying to accomplish and always keep those goals in mind, and then scope out the process based on what those goals are. For each round, we're addressing different things. First round might be about just capturing the overall look and trying things as broad as we can, and then the next round is, "Okay. Well, now we have generally a look that we want, but is it the right weight? Is it the right letter height? Do we have enough details?" That kind of thing, and then we get narrower and nerdier as we go along in the process.

**中文翻译:**
还有一点我比较独特，别人不一定这么做：如果我们的目标是解决实用性问题，我会很早就把文件交给客户，让他们在实际场景（In situ）中测试。大多数人会说：“不，在最终定稿前你拿不到文件，因为我不想让你拿着半成品跑掉。”这需要一定的信任。总之，先弄清楚我们要实现什么，始终牢记这些目标，然后根据目标确定流程。每一轮我们解决的问题都不同。第一轮可能是捕捉整体感觉，尽可能广泛地尝试；下一轮则是：“好吧，现在我们有了大致的方向，但粗细（Weight）对吗？字母高度对吗？细节够吗？”随着流程的推进，我们会变得越来越细致、越来越硬核（Nerdier）。

---

### (00:14:45) Lenny Rachitsky

**English:**
Awesome. In the experience of my podcast logo, I was an ass. At the end of it, I'm like, "No, this isn't right," because we narrowed, narrowed, narrowed, and then I was like, "No, I'm not feeling it," and then we unnarrowed it and went back. [inaudible 00:15:02]

**中文翻译:**
太棒了。在我的播客标志翻新过程中，我表现得挺难搞的。最后我居然说：“不，这不对。”因为我们一直在缩小范围、缩小范围，最后我却说：“不，我没感觉。”然后我们又推翻了之前的缩小，重新回去了。

---

### (00:15:01) Jessica Hische

**English:**
That is not an uncommon experience though. This is why there's a few things that I'm not opposed to that I know people that are very opposed to. I'm not opposed to Frankensteining options together. To me, it's like I'm giving you a menu of all the things that we can do, but I'm like a chef that puts a menu together where you can combine different appetizers and different mains and they all still make sense. Some people will give you a menu and if you try to do that, it's insane and it tastes terrible. But for me, everything that we're doing, I feel like, mixes and matches fairly well, and I will let you know if it doesn't.

**中文翻译:**
这其实并不罕见。这就是为什么有些事情我不反对，但我知道很多人非常反对。我不反对把不同的选项“拼凑（Frankensteining）”在一起。对我来说，这就像我给你提供了一份菜单，我像个厨师一样设计菜单，你可以组合不同的前菜和主菜，它们搭配起来依然合理。有些人给你的菜单，如果你尝试组合，那简直是灾难，味道极差。但对我来说，我觉得我们做的每一项都能很好地混搭，如果不行，我会告诉你的。

---

### (00:15:37) Jessica Hische

**English:**
It's not unreasonable for clients to go down one path and then use that as validation or confirmation that something that we did much earlier was actually the right way. In that way, if a client ever asks me to do something, they're like, "Let's see it in purple or whatever." There's designers that will really fight you tooth and nail, because they're like, "That is wrong, that is wrong," but I know that some people just have to see it before they can let it go. Sometimes you have to walk down a path before you're able to understand what the right thing to do was all along.

**中文翻译:**
客户沿着一条路走下去，然后以此来验证或确认我们早些时候做的某个方案其实才是正确的，这并非不合理。所以，如果客户要求我做某事，比如“让我们看看紫色的效果”，有些设计师会拼命反对，因为他们觉得“那是错的”。但我知道，有些人必须亲眼看到效果才能释怀。有时候，你必须走一段弯路，才能明白最初的选择才是对的。

---

### (00:16:10) Lenny Rachitsky

**English:**
That is exactly how it felt for me. Going back to the goals, the different goals people have when they're exploring this, you mentioned there's just little problems with the logo, it doesn't scale, it doesn't print well, that kind of thing. Another goal is people are pivoting and they want to change the vibe and the feel of the brand. What other goals might appear that you've come across why people want to do this?

**中文翻译:**
我当时的感觉正是如此。回到目标的话题，人们在探索时会有不同的目标。你提到了标志的小问题，比如缩放效果不好、印刷效果不佳等。另一个目标是公司转型，想要改变品牌的氛围和感觉。你还遇到过哪些人们想要翻新品牌的目标？

---

### (00:16:31) Jessica Hische

**English:**
Well, sometimes there's a legibility issue that is really glaring once you see it and then people are too close in to notice it, so this is why it's like you have to show it to a lot of people that aren't familiar with looking at those letter forms and stuff. The one that came to mind immediately when you asked was when I did a refresh for Jeni's Ice Cream, which is a really amazing ice cream brand based out of Columbus, Ohio. They had a few utilitarian things in mind. They had this long J that created this pocket of white space underneath it that made it really hard to design with, but then the biggest glaring one was that they decided to make the apostrophe of the Jeni's over the I as a cool thing. It made the word look like it said penis because of the way that J was drawn.

**中文翻译:**
嗯，有时候存在非常明显的易读性问题，但当局者迷。这就是为什么你必须把它展示给很多不熟悉这些字母形状的人看。你问这个问题时，我立刻想到的是我为 Jeni's Ice Cream（俄亥俄州哥伦布市的一个很棒的冰淇淋品牌）做的翻新。他们有一些实用性的考虑：那个长长的字母 J 下方产生了一块空白区域，导致设计很难排版。但最明显的问题是，他们为了耍酷，把 Jeni's 的撇号放在了字母 I 的上方。由于 J 的画法，这让整个单词看起来像 "penis"（男性生殖器）。

---

### (00:17:18) Jessica Hische

**English:**
It had a little loop at the top of the J. That was the most specific fix that I've ever had to do, is make the logo not say penis anymore. But yeah, I feel like a lot of it is misreads. When you think about logos and things like that, you want it to be something that, at a super fast glance, people can read it right away. That doesn't mean that everything has to be simple, but it just means that everything has to be incredibly legible, especially when you're starting a new company or you have a less recognizable brand. Because eventually, you become a household name and then people can look at just the color and recognize that it's you or whatever, but it takes a long time building equity before you get that. Until that, it's really important that the legibility is just super tight.

**中文翻译:**
那个 J 的顶部有一个小圆圈。那是我做过的最具体的修复工作：让标志看起来不再像那个不雅词汇。不过说真的，我觉得很多问题都源于误读。当你考虑标志时，你希望人们在极快的一瞥之下就能立刻读懂。这并不意味着一切都要简单，但意味着一切都必须极其易读，尤其是当你创办新公司或品牌知名度较低时。因为最终你会成为家喻户晓的名字，人们只要看到颜色就能认出你，但在达到那个境界之前，需要很长时间的品牌资产积累。在那之前，易读性必须非常严谨。

---

### (00:18:04) Lenny Rachitsky

**English:**
Let's talk about actually thinking through my new logo and brand. Can you just talk about what you had in mind as you started to explore directions and we started narrowing what was the mindset, and the approach, and the vibe?

**中文翻译:**
让我们谈谈构思我的新标志和品牌的过程。你能聊聊当你开始探索方向并逐渐缩小范围时，你的想法、方法和追求的氛围是什么吗？

---

### (00:18:18) Jessica Hische

**English:**
I think with the Lenny's brand, you are what I would call a person that has a beloved fan base that we don't want to exclude or offend by shifting gears super crazily. When I was looking at redoing your brand, it was about what's here that we can look at that we should keep or at least explore keeping in order to make sure that it still feels the same on the other side? We didn't want to do anything super drastic. Some of the things to think about in that way are you have this sort of handwritten approach to a lot of the parts of your brand, and I was like, "How do we do something that feels handwritten, that feels like it could jive with the handwriting scripts and stuff that you were using but might feel a little bit more refined moving forward and in a way that could blend with illustration so that the illustration and the letter forms all feel like they were created by the same hand?"

**中文翻译:**
我认为对于 Lenny 这个品牌，你拥有一个非常忠诚的粉丝群，我们不想通过过于疯狂的改变来排斥或冒犯他们。当我考虑重塑你的品牌时，重点在于：现有的元素中哪些是我们可以保留的，或者至少值得探索保留的，以确保翻新后感觉依然如初？我们不想做任何过于激进的改动。其中一个考虑点是，你的品牌很多部分都有一种手写感。我在想：“我们如何做出一种既有手写感、能与你之前使用的手写体契合，但又显得更精致、能与插画完美融合的东西，让插画和字母看起来像是出自同一人之手？”

---

### (00:19:17) Jessica Hische

**English:**
A lot of times for me, when it comes to doing an exploration like that, it's about how do we make sure everything feels like it was created at the same time and not that we just tacked on new things? Figuring out how to blend everything together is important. Color was also a big one. I feel like people's color stories are something that is an immediate read, where if you blur your eyes and look at a brand, you can recognize it by its color, and so I think keeping your color similar was a big one too. But then I really wanted to try different approaches with the typography, doing stuff that was a little bit more clean, doing stuff that still had a bit of a funky edge to it. Because your original Lenny's podcast type had this sort of cut papery, a little bit off kilter vibe to it, and so trying to capture that but with new cleaner typography. That was really fun.

**中文翻译:**
对我来说，进行这类探索时，关键在于如何确保所有元素看起来是同时创作的，而不是生硬地添加了新东西。弄清楚如何将一切融合在一起非常重要。颜色也是一个重点。我觉得品牌的颜色故事是人们的第一直觉，如果你眯起眼睛看一个品牌，你应该能通过颜色认出它。所以保持颜色相似也是一个大方向。但我也想在字体排印上尝试不同的方法，做一些更简洁的东西，同时保留一点“古灵精怪（Funky）”的边缘感。因为你原来的播客字体有一种剪纸感、一种稍微有点“歪斜”的氛围，所以我们尝试用更干净的新字体来捕捉那种感觉。这非常有趣。

---

### (00:20:13) Jessica Hische

**English:**
I was using a typeface Degular as part of it, which has a nice wonkiness to it. It was drawn by a friend of mine, James Edmondson, who I love all of his stuff. That was one of the things that we approached because I felt like it could capture the look of the original cut paperesque type. But yeah, it was really fun to try a lot of different things and work within the iconography that you had used on a few stuff with the microphones, and also marshmallows, and campfires, and all kinds of things, and just trying to make a more unified system.

**中文翻译:**
我使用了 Degular 字体作为其中的一部分，它有一种很棒的“不规则感（Wonkiness）”。它是由我的朋友 James Edmondson 设计的，我非常喜欢他的所有作品。我觉得它能捕捉到原始剪纸风格字体的神韵。总之，尝试很多不同的东西，并在你已经使用的图标（如麦克风、棉花糖、营火等）基础上工作，努力打造一个更统一的系统，这真的很有趣。

---

### (00:20:47) Lenny Rachitsky

**English:**
Are there things that didn't work as you tried to explore this process that you recall, that might be worth sharing of just like, "Oh, that was a cool concept," but didn't quite work the way you thought?

**中文翻译:**
在探索过程中，有没有什么你记得的行不通的事情？比如那种“哦，这概念很酷”，但实际效果不如预期的？

---

### (00:20:57) Jessica Hische

**English:**
With working on this refresh, so much of it was thinking about what are the immediate uses of the logo. Your logo, you have these very specific uses that you need it for, the avatar for the podcast being a top one. Some people, they'll design a logo and then have these illustrative versions of the logo that get rolled out for other things, but I feel like those layouts were actually more important than even just having a basic letterhead-esque logo. That's an interesting way to approach it, because usually, it's like let's start simple, and expand, and make it crazier. I felt like we had to always keep those things in play, so it was designing brand assets while also designing the logo. Sometimes you'll see examples of that in early explorations just because it makes it feel real to the client.

**中文翻译:**
在做这次翻新时，很大一部分精力花在思考标志的直接用途上。你的标志有非常具体的用途，播客头像就是重中之重。有些人设计标志后，会衍生出一些插画版本用于其他地方，但我感觉对于你来说，这些排版布局甚至比一个基础的信头式标志更重要。这是一个有趣的切入点，因为通常的做法是先从简单开始，再扩展到复杂。我觉得我们必须始终考虑这些应用场景，所以是在设计标志的同时设计品牌资产。有时在早期探索中展示这些，是为了让客户觉得它更真实。

---

### (00:21:53) Jessica Hische

**English:**
That's why there's always the tote bag. You got to put the logo on the tote bag and then it feels real or whatever. But in our case, we had really specific uses that needed to get explored very early on, and that made it a slightly different process for me. In terms of things that didn't work though, I think just trying to work on the level of detail within the illustration and type so that it could shrink down, because we knew... One of the primo examples of the logo being used was on that podcast avatar, and some of the versions felt a little bit too detailed to shrink down that much. Trying to get the balance of that, having the illustrations feel illustrative and whole, but not when they scaled up, to feel too simple like we just pulled it from a icon library. I think that was an interesting challenge.

**中文翻译:**
这就是为什么总会有帆布包（Tote bag）的原因——你得把标志印在包上，它才显得真实。但在我们的案例中，我们有非常具体的用途需要在早期就进行探索，这让我的流程略有不同。至于行不通的事情，我认为主要是插画和字体的细节程度。因为我们知道标志最重要的应用场景之一是播客头像，而有些版本细节太多，缩小后效果不好。要在“让插画感觉丰满且有手绘感”和“放大后不至于显得像从图标库里随便拉出来的那么简单”之间找到平衡，这是一个有趣的挑战。

---

### (00:22:46) Lenny Rachitsky

**English:**
One of the impetuses for changing my logo, for motivating me, is my wife's a designer, as you know. She's got strong opinions about my logo, and she always was making fun of my logo saying it looked like a clip art fireplace that anyone just could just plug and play. She's always like, "Oh, that's so bad. You got to change it." That was one of the motivators. I think I might have shared that when we started working together.

**中文翻译:**
我更换标志的一个动力，或者说激励我的原因，是因为我妻子是设计师，你也知道。她对我的标志有很多看法，总是嘲笑它看起来像个随处可见的剪贴画（Clip art）壁炉，谁都能拿来用。她总是说：“噢，太糟糕了，你得换掉它。”这是动力之一，我想我们在开始合作时我可能跟你提过。

---

### (00:23:08) Jessica Hische

**English:**
Yeah. Also too, I think that really talks to what I was saying earlier about making sure that everything feels like it was created together rather than it feeling like these disparate elements, because I think you can have an icon or logo that is quite simple as long as the rest of the brand matches that simplicity. I think, for you, the biggest thing was making the illustration and the typography just feel like it came from the same universe instead of feeling like these separate elements. When I first moved to San Francisco, I moved to San Francisco from New York, and as a New Yorker, I had an apartment with a full kitchen that never got used. I just ate at restaurants and did takeout for the seven years or whatever that I lived in New York.

**中文翻译:**
是的。这也印证了我之前说的，要确保所有元素感觉是浑然一体的，而不是零散的。我认为你可以有一个非常简单的图标或标志，只要品牌的其他部分也符合这种简洁感。我觉得对你来说，最大的挑战是让插画和字体感觉来自同一个宇宙，而不是互不相干。我刚搬到旧金山时是从纽约搬来的。作为一个纽约人，我当时的公寓有一个完整的厨房，但从来没用过。在纽约住的那七年里，我一直是在外面吃或叫外卖。

---

### (00:23:51) Jessica Hische

**English:**
Learning to cook, at first, when you learn how to cook, it's like you're making a pot full of ingredients and none of the ingredients are actually working together. But then the more you do it and the more you understand how these things are meant to blend and cook at different temperatures at different times, you start having this cohesive dish rather than hot ham water. You know what I mean? I feel like a lot of clients come to me and they have hot ham water when it comes to their brand. It's just about turning that into a soup, something that feels real.

**中文翻译:**
刚开始学做饭时，就像是煮了一锅食材，但食材之间完全不搭。但随着你做得越多，越理解这些东西该如何融合、如何在不同温度和时间下烹饪，你就会得到一道和谐的菜肴，而不是“热火腿水（Hot ham water，指平淡无味的东西）”。你明白我的意思吗？我觉得很多客户来找我时，他们的品牌就像是“热火腿水”。我的工作就是把它变成一锅浓汤，一种真实、有质感的东西。

---

### (00:24:25) Lenny Rachitsky

**English:**
I want to take a quick tangent. Most people listening to this podcast are not designers. They're product managers, founders, engineers, and folks building product. I've always wanted to see the world through the eyes of a designer, because there's so much I don't see and there's so much that affects how I think about something that I don't understand when I look at a logo, and so I thought it might be helpful just to spend a little time helping people see a designer a little bit. Let me just ask you this question. When people look at a logo or a brand, what are just elements that make it what it is, that make you feel the thing you want to feel that we may not recognize?

**中文翻译:**
我想稍微跑个题。听这个播客的大多数人不是设计师，他们是产品经理、创始人、工程师和产品构建者。我一直想通过设计师的眼睛看世界，因为有很多东西我看不到，有很多影响我思考的因素是我在看标志时无法理解的。所以我想，花点时间帮助大家了解一下设计师的视角可能会很有帮助。我想问你：当人们看一个标志或品牌时，有哪些元素构成了它的特质，并让你产生某种特定的感觉，而我们普通人可能意识不到？

---

### (00:25:06) Jessica Hische

**English:**
I think most people are better at understanding the feelings and sensations that typography and logos give us than they give themselves credit for, because what we are as people are endless absorbers of patterns, and information, and all this kind of stuff as we move throughout the world. We don't take time to sit and digest it, but it's still coming in and getting logged. That's why if you see something funky in the world, you're like, "That's weird. I don't like that. I don't know why I don't like it, but I know I don't like it." I think even as a non-designer, I can see that in typography. The whole being able to recognize patterns thing, I talked about this a bit at config, it's like it's a safety thing. Looking into the world, your eyes can spot that thing that's a little bit off, and that thing that's off feels not safe to you.

**中文翻译:**
我认为大多数人其实比他们想象中更擅长理解字体和标志带给我们的感觉。因为作为人类，我们在世界上行走时是模式和信息的无尽吸收者。我们虽然没花时间消化，但信息一直在被记录。这就是为什么当你看到一些奇怪的东西时，你会觉得：“这很怪，我不喜欢。我不知道为什么不喜欢，但我就是知道我不喜欢。”即使是非设计师，在看字体时也会有这种感觉。这种识别模式的能力，我在 Config 大会上也提到过，它其实是一种安全机制。观察世界时，你的眼睛能发现那些“不对劲”的小地方，而那些不对劲的地方会让你感到不安全。

---

### (00:26:08) Jessica Hische

**English:**
It's thinking about when we look at a meal and there's a thing on the plate that looks like it's moldy or something like that. You understand that doesn't look right to me, this doesn't smell right to me. Your body knows it before your brain knows it. Even as a non-designer, I think you can look at examples of logos where something's not quite right and be like, "Something's not right here, I just don't know how to name it." But I think a good exercise is just looking at fonts that are available in the world and asking yourself, "What feeling does this give me?" and just write them down. It doesn't matter, just give yourself permission to say whatever is happening in your mind, the first thing. Don't overanalyze it. Just look at it and be like, "That feels calm to me. That feels exciting to me. That feels whatever to me."

**中文翻译:**
这就像我们看一顿饭，如果盘子里有个东西看起来像发霉了，你会立刻意识到“这看起来不对劲，闻起来也不对”。你的身体比大脑先知道。即使是非设计师，当你看到一个不太对劲的标志时，也会觉得“这里有问题，但我不知道怎么形容”。我觉得一个很好的练习是观察世界上的各种字体，问自己：“这给了我什么感觉？”然后写下来。没关系，允许自己说出脑子里冒出的第一个想法。不要过度分析，只要看着它说：“这让我感到平静”、“这让我感到兴奋”或者“这让我感到如何如何”。

---

### (00:27:00) Jessica Hische

**English:**
The more you do that, the more you can start seeing similarities in the ones that feel exciting, and the ones that feel calm, and the ones that feel whatever, and then get into analyze mode of, "Oh, these 10 things that I said feel calm are a lighter weight, have more generous spacing, have rounded edges, have rounder bowls to the letter forms." You just start seeing commonalities between the things. It's just about seeing them all together to understand what those similarities are. I think anybody can do that. I mean, you're not going to have the language of the leg of the R and the tittle of the I. Don't worry about that. You don't have to know typography language to think about it, but anybody's capable of doing that. It can be really fun to just stop and ask yourself and notice.

**中文翻译:**
你做得越多，就越能发现那些让你感到“兴奋”的字体之间的相似之处，或者那些让你感到“平静”的字体之间的共性。然后进入分析模式：“哦，这 10 个让我感到平静的字体，它们的笔画更细（Lighter weight）、间距更宽（Generous spacing）、边缘更圆润、字母的弧度（Bowls）更饱满。”你开始发现事物间的共同点。关键在于把它们放在一起观察，从而理解这些相似性。我认为任何人都能做到。你不需要知道什么“字母 R 的腿”或“字母 I 的点（Tittle）”这些专业术语。不用担心，你不需要懂字体排印术语也能思考，每个人都有这种能力。停下来问问自己并去留意这些细节，其实非常有趣。

---

### (00:27:58) Lenny Rachitsky

**English:**
This is great. I want to go actually a little deeper. What I'm hearing is look at something, tap into the feeling you feel when you look at it, actually pay attention to it because there's wisdom in that. The specific things that you pointed out that impact that feeling are, you mentioned, spacing between the letters, the edges. I imagine there's just the color of it. What other specific elements impact the way someone feels when they look at a logo?

**中文翻译:**
太棒了。我想再深入一点。我听到的是：观察某样东西，捕捉你看到它时的感受，并真正去留意它，因为那里面蕴含着智慧。你提到的影响这种感觉的具体因素包括：字母间的间距、边缘的处理。我猜还有颜色。还有哪些具体元素会影响人们看标志时的感受？

---

### (00:28:26) Jessica Hische

**English:**
There's the width of the letter, so if it's really narrow versus really wide. I always think about the width, the weight, [inaudible 00:28:35] facing, sort of detailed treatment of things, whether things are very hard and jagged or soft and how soft it is. Sometimes we just add a tiny bit of softness so that it just feels printed. You can take a typeface like Helvetica, just the one everybody knows. But if you take Helvetica and just ever so slightly round the edges just a little bit, all of a sudden, you have this typeface that feels more vintage, or softer, or whatever, because we're perceiving it, we would perceive it if it were printed on paper versus perceiving it as this hard geometric piece of technology that we're viewing. You know what I mean?

**中文翻译:**
还有字母的宽度，是极窄还是极宽。我总是考虑宽度、粗细（Weight）、字间距以及细节处理——是坚硬且有棱角的，还是柔软的，以及柔软到什么程度。有时我们只需增加一点点柔软度，让它感觉像是印出来的。你可以拿 Helvetica 这种大家都认识的字体为例，如果你把它的边缘稍微磨圆一点点，突然之间，这种字体就会感觉更复古、更柔和。因为我们的身体会把它感知为印在纸上的东西，而不是我们在屏幕上看到的冰冷的几何技术产物。你明白我的意思吗？

---

### (00:29:20) Jessica Hische

**English:**
I know that it's because when you look at stuff printed on a page, it bleeds into the paper a little bit, which means that that softness reminds us in our bodies of a thing that we've seen that was printed. It's cool to sort of walk back your feelings also. You'll look at something and go, "That feels like this," and then ask yourself why does it feel like that. It might be because you saw it on a flyer for a band when you were 22, and it brought out that feeling in you of what it felt like to be 22 at that thing. That's a very specific feeling to you, but it can inform your decisions about design, because you can be like, "Oh, I'm not that much of a special snowflake." Other people might have that same reaction but have different experiences that are adjacent to that reaction.

**中文翻译:**
我知道这是因为当你看纸上的印刷品时，墨水会稍微渗入纸张，这种柔软感会在潜意识中提醒我们曾经见过的印刷品。追溯你的感受也很有趣。你会看着某样东西说：“这感觉像那个”，然后问自己为什么。可能是因为你 22 岁时在某个乐队传单上见过它，它唤起了你 22 岁时的那种感觉。虽然这对你来说是很私人的感受，但它可以指导你的设计决策，因为你会发现：“哦，我并不是那么特别的一个人。”其他人可能会有同样的反应，只是触发这种反应的经历略有不同。

---

### (00:30:08) Jessica Hische

**English:**
It's cool because you are reverse-justifying decisions. I think that's a really fun exercise to do, is to Song Exploder your intuition. You make a decision intuitively or look at something and intuit what you feel from it, and then really try to dive in, "Why do I feel that way? What could this have reminded me of that made me feel that way?" You have to be just so forgiving and loose with yourself as you do it because then you'll get into some really weird stuff, and that's really great inspiration juice for picking other things.

**中文翻译:**
这很酷，因为你是在为你的直觉寻找“事后理由”。我认为这是一个非常有趣的练习，就像《歌曲解构（Song Exploder）》节目一样去解构你的直觉。你凭直觉做一个决定，或者看某样东西并凭直觉感受它，然后努力深入挖掘：“我为什么会有这种感觉？这可能让我想起了什么？”在做这个练习时，你要对自己宽容、放松，因为你可能会想到一些非常奇怪的东西，而那些正是选择其他设计元素时的绝佳灵感来源。

---

### (00:30:51) Lenny Rachitsky

**English:**
I love the exercise that you gave. The one you gave earlier is look at a bunch of fonts, look at your font folder. Is that a place to go, just open up your font folder and just go through them?

**中文翻译:**
我喜欢你给出的这个练习。你之前说的是看一堆字体，看自己的字体文件夹。是直接打开字体文件夹一个一个看吗？

---

### (00:30:55) Jessica Hische

**English:**
Totally. Look at your font folder, or go to MyFonts, or a place where there's a ton of fonts, and just search for something. Search for sans serif or whatever. Search for a really basic category of fonts. Serif, sans serif, script, whatever, the top level edge of stuff, and then just page through, page through, page through. Screenshot stuff that you like and make a folder full of screenshots, and then you can take those screenshots and start categorizing them. "Oh, this one feels feminine. This one feels masculine, this one feels aggressive. This one feels whatever." Just take some notes on it. Then, you ask yourself, "Well, why did I feel that way?" You're like, "Oh, well, this feels feminine because it reminds me of wedding invitations," and wedding invitations feel inherently bridey versus groomy.

**中文翻译:**
完全正确。看你的字体文件夹，或者去 MyFonts 这种有很多字体的地方，随便搜点什么。搜“无衬线体（Sans serif）”之类的。搜索一些基础类别：衬线体、无衬线体、手写体（Script）等等，这些最顶层的分类。然后一页一页地翻。把你喜欢的截图存下来，建一个文件夹。然后你可以开始给这些截图分类：“哦，这个感觉很女性化，这个感觉很阳刚，这个感觉很有侵略性，这个感觉如何如何。”做点笔记。然后问自己：“我为什么会有这种感觉？”你会发现：“哦，这个感觉很女性化，因为它让我想起了婚礼请柬，而婚礼请柬天生就更有新娘感而非新郎感。”

---

### (00:32:10) Jessica Hische

**English:**
All of a sudden, you're like, "Okay. Well, now I know that if I'm going to use a script for something, this zone of script feels very wedding, so maybe I avoid that for this brand that's actually a cutting edge food packaging company or whatever because it feels too aligned with that industry." Stereotypes are real and trends are real, and what can sometimes happen is some industry usurps an entire style for a period of time. If you use anything within that style, it's like you're aligning yourself to that industry. I mean, everybody that does branding, one of the things that they do is they analyze the competitors of the company. You just look at a landscape of what are all the competitors doing, what is their visual vibe, and do I lean into that or do I avoid that? If I lean into it, then I'm immediately getting this... Everyone that looks at it understands I'm a FinTech company because I look like a FinTech company. If my whole thing is I'm trying to be divergent from that, I'm trying to show how different I am from the status quo, then you use it as a reactionary thing of I want to do nothing like that and do something really different so people understand this isn't just another FinTech company.

**中文翻译:**
突然之间，你会意识到：“好吧，现在我知道如果我要用手写体，这一类手写体感觉非常‘婚礼风’，所以如果我的品牌是一家前沿的食品包装公司，我可能要避开它，因为它和那个行业太契合了。”刻板印象是真实存在的，趋势也是。有时某个行业会在一段时间内占据某种特定的风格。如果你使用了那种风格，就等于把自己归类到了那个行业。做品牌设计的人都会分析竞争对手。你会观察整个行业图景：竞争对手都在做什么？他们的视觉氛围是什么？我是要靠拢还是避开？如果我靠拢，那么每个人一看就知道我是一家金融科技（FinTech）公司，因为我长得就像。如果我的目标是与众不同，展示我如何打破现状，那么我就要反其道而行之，做一些完全不同的东西，让人们明白这不只是另一家金融科技公司。

---

### (00:33:09) Lenny Rachitsky

**English:**
Yeah. I'm thinking green. The color green has to be a part of the logo if you want to be a FinTech company.

**中文翻译:**
是的。我在想绿色。如果你想成为一家金融科技公司，绿色似乎必须是标志的一部分。

---

### (00:33:13) Jessica Hische

**English:**
Yeah, exactly. If you're trying to be weird, then you're like teal.

**中文翻译:**
没错。如果你想显得特立独行，你可能会选青色（Teal）。

---

### (00:33:19) Lenny Rachitsky

**English:**
On this topic of seeing a designer, is there any other tip, just before we move on to a different topic, of just how someone could learn to see a designer a little bit more?

**中文翻译:**
关于“像设计师一样观察”这个话题，在进入下一个话题之前，还有什么建议能让普通人多学一点设计师的视角吗？

---

### (00:33:30) Jessica Hische

**English:**
Yeah. Another thing to notice, because I'm assuming you're... Product people, I feel like a lot of product people end up having some engineering background, whether or not they're engineers themselves. They have to interface with the engineers and they build stuff, and so they come at it from a data standpoint. I can always tell when there's an engineer that has suddenly got taken an interest in type design and is now a type designer, because everything is very, very regular. You can draw a grid on top of everything and the lines all line up perfectly. You see lots of reverse justification of that when people are making logos and they have a more engineering background. The thing to notice, that is interesting within type, is that, yes, you're absolutely following rules, but you're breaking those rules quite often to correct for optical tricks.

**中文翻译:**
有的。另一件值得注意的事，因为我假设你的听众……产品人，我觉得很多产品人最终都有一些工程背景，无论他们本身是不是工程师。他们必须与工程师对接并构建产品，所以他们会从数据的角度来看待问题。我总能一眼看出某个工程师是不是突然对字体设计感兴趣并开始自己动手了，因为一切都非常、非常规整。你可以在所有东西上面画网格，线条完美对齐。当有工程背景的人制作标志时，你会看到很多这种“过度合理化”的痕迹。但在字体设计中，有趣的一点是：虽然你确实在遵循规则，但你经常需要打破规则来修正“视觉错觉（Optical tricks）”。

---

### (00:34:24) Jessica Hische

**English:**
If you look at a geometric sans serif, for instance, that's like a category of sans serifs, and they're meant to have a lot of really strong geometry, be very regular, like most of the sans that you think of that you're like, "I'm in love with this over the last 10 years," like geometric sanses. But when you really start to examine them, you notice that there's all these little things that people are doing to make them look perfectly geometric even though they are not mathematically perfectly geometric. That's another thing that you can do, whether you're doing it in Figma or doing it somewhere else, is just type out a couple of lowercase letters. Lowercase specifically are really good for analyzing this because they're smaller than the uppercase letters. You usually have to accommodate for the weight a little bit differently. You'll notice that when strokes combine, so say I have an A and I'm combining the lower bowl of the A, I'm going to get a little thinner as I come into that.

**中文翻译:**
例如，如果你看几何无衬线体（Geometric sans serif），这是一类无衬线体，它们旨在拥有非常强的几何感，非常规整。过去 10 年里你喜欢的很多字体都是几何无衬线体。但当你真正开始检查它们时，你会发现设计师做了很多小动作，让它们看起来完美符合几何学，尽管在数学上它们并不完美。你可以做这样一个练习，无论是在 Figma 还是其他地方：打出几个小写字母。小写字母特别适合分析，因为它们比大写字母小，你通常需要以不同的方式处理它们的粗细。你会注意到，当笔画结合时——比如字母 a，当笔画进入下方的弧度（Bowl）时，它会变得稍微细一点。

---

### (00:35:23) Jessica Hische

**English:**
Or say I have a two-storey A, so a two-storey A is the one that's like this and then a bowl, you might notice that this vertical of the A there, the bowl actually eats into that stroke a little bit to erase a little bit of that added weight that would've been perceived optically had you kept everything perfectly regular. It's weird because you end up creating something that's perfect and then have to make it not perfect in order to make it be perceived as perfect. That's another just fun thing to start noticing. You notice it a lot more on typefaces and typography that is heavier in weight, because when things are heavier weight, you're constantly managing these really inky moments where things join together and you have to subtract a bunch of weight from that so that it doesn't get perceived as this dark mark where the letter is happening.

**中文翻译:**
或者说双层 a（Two-storey a，即顶部带钩的那种），你会注意到在垂直笔画和弧度结合的地方，弧度实际上会稍微“吃掉”一点垂直笔画，以抵消如果你保持一切规整而在视觉上产生的额外重量感。这很奇妙，因为你最终创造了一个完美的东西，却必须让它变得“不完美”，才能让它在视觉上被感知为“完美”。这是另一个值得留意的有趣现象。在笔画较粗的字体中，这种现象更明显，因为当笔画变粗时，你必须不断处理那些笔画交汇处的“墨水堆积感”，你必须减去一些重量，这样它才不会看起来像个黑疙瘩。

---

### (00:36:22) Jessica Hische

**English:**
I think about lowercase Rs and lowercase Ns, where the shoulder of the N or the R comes out, sometimes the top of the R is actually narrower at the top than it is on the bottom, and that's to try to subtract some of that weight in there where that join happens. Anyway, that's just a fun thing to notice that you have to do that. Once you start seeing it, you start seeing where it happens more often, and the answer of why it happens is because correcting for this optical weight issue. You're like, "Oh, man. Now I have x-ray vision. I can see all these weird things I've never seen before." It's very fun. But anyway, a lot of people, when they first start out doing typography, whether you're an engineer or whether you are a designer, they don't account for that. I can always just look at something and see whether someone is truly an expert at typography or whether this is a fun hobby for them when they're pretty fresh at it.

**中文翻译:**
我想到了小写 r 和小写 n，在 n 或 r 的“肩膀”伸出的地方，有时 r 的顶部实际上比底部窄，这是为了减去连接处的重量。总之，留意这些必须做的调整是很有趣的。一旦你开始注意到它，你就会发现它无处不在。原因就是为了修正这种视觉重量问题。你会觉得：“天哪，我现在有了 X 光眼，能看到以前从未见过的奇妙细节。”这非常有趣。但无论如何，很多刚开始做字体设计的人，无论是工程师还是设计师，往往不会考虑到这一点。我总能通过观察一眼看出某人是真正的字体专家，还是只是把它当作一个刚入门的有趣爱好。

---

### (00:37:20) Lenny Rachitsky

**English:**
The exercise here is open up Figma, start typing, and make it really big so you can basically see the font really zoomed in.

**中文翻译:**
所以练习就是：打开 Figma，开始打字，把字号调得非常大，这样你就能看到极度放大的字体细节。

---

### (00:37:20) Jessica Hische

**English:**
A single letter.

**中文翻译:**
就看一个字母。

---

### (00:37:27) Lenny Rachitsky

**English:**
A single letter.

**中文翻译:**
一个字母。

---

### (00:37:28) Jessica Hische

**English:**
Make a single letter the whole page and then just draw some vertical lines, or do the thing where you draw a little circle or whatever and see if that circle is the same size at the point where two strokes join together or the point where the stroke is just vertical and on its own. You'll notice that there's differences even in typography that's meant to look extremely rigid and geometric.

**中文翻译:**
让一个字母占据整个页面，然后画一些垂直线，或者画个小圆圈，看看在两个笔画交汇处和在单一垂直笔画处，圆圈的大小是否感觉一致。你会发现，即使是那些看起来极其严谨和几何化的字体，也存在这些差异。

---

### (00:37:53) Lenny Rachitsky

**English:**
I want to come back to my logo just to close the loop there. Talk about just the final result that we landed on, and why you think that was the final answer, and what you think people might get from it, whatever comes to mind.

**中文翻译:**
我想回到我的标志翻新上，把这个话题收个尾。谈谈我们最终确定的结果，为什么你认为那是最终答案，以及你认为人们会从中感受到什么？

---

### (00:38:07) Jessica Hische

**English:**
Yeah, totally. I think the final answer or the final logo, we took it down a lot of different paths trying to see where it was going to land, but ultimately ended up keeping it pretty close to home and really focusing on that asset of the fire. We tried so many different versions of it's microphones with the fire and marshmallows with the fire, et cetera. It was just about sometimes the simplest solution is the correct solution. I don't know, I just feel like in terms of what we were doing for blowing it out and making it really cohesive, we went a lot of directions where there might've been multiple versions of the logo depending on the scale and ultimately ended up in a place where it's much more in line and consistent across the bar.

**中文翻译:**
好的。关于最终的标志，我们尝试了很多不同的路径，想看看它会落脚在哪里。但最终我们决定保持它与原有的感觉接近，并真正专注于“火”这个元素。我们尝试了麦克风加火、棉花糖加火等各种版本。有时候，最简单的方案就是正确的方案。我觉得在扩展品牌并使其具有凝聚力的过程中，我们尝试过很多方向，比如根据不同比例设计多个版本的标志，但最终我们达到了一个在各方面都更加一致和连贯的状态。

---

### (00:38:55) Lenny Rachitsky

**English:**
Yeah. Maybe what I'll do is we'll share, I don't know if you're comfortable with that, we could just share all the iterations somewhere that we went through.

**中文翻译:**
是的。也许我会分享一下——如果你不介意的话——我们可以把我们经历过的所有迭代版本分享出来。

---

### (00:39:01) Jessica Hische

**English:**
Oh, yeah. I love sharing iterations. It's very fun. Yeah.

**中文翻译:**
噢，当然。我喜欢分享迭代过程，那非常有趣。

---

### (00:39:03) Lenny Rachitsky

**English:**
Okay, cool. Sweet. The biggest issue we had with the podcast logo specifically is, originally, I was thinking the mic made sense to differentiate it from the newsletter. At the end of it, it's just like, "Why do we have this freaking mic in there? It just feels strange." That's where we revisited the whole idea and killed the mic and went back to a different version of the fireplace but with marshmallows.

**中文翻译:**
太好了。我们在播客标志上遇到的最大问题是，最初我认为用麦克风来区分播客和时事通讯是有道理的。但到最后，我们觉得：“为什么非得放个麦克风在那儿？感觉很奇怪。”于是我们重新审视了整个想法，去掉了麦克风，回到了带有棉花糖的壁炉版本。

---

### (00:39:24) Jessica Hische

**English:**
Yeah, I love the marshmallows.

**中文翻译:**
是的，我喜欢那些棉花糖。

---

### (00:39:26) Lenny Rachitsky

**English:**
Awesome. I love it. That was my wife's... My wife loves the marshmallows also, and it's so versatile. We can use it in so many different ways.

**中文翻译:**
太棒了，我也喜欢。我妻子也非常喜欢棉花糖，而且它非常多才多艺，我们可以以很多不同的方式使用它。

---

### (00:39:33) Jessica Hische

**English:**
Indeed.

**中文翻译:**
确实如此。

---

### (00:39:34) Lenny Rachitsky

**English:**
I guess maybe one last thread there is we explored handwritten typography that you created from scratch, and then there's the block letters. Maybe just thoughts on those two options and benefits and why go one direction versus another?

**中文翻译:**
我想关于这个话题的最后一件事是：我们探索了你从零开始创作的手写字体，还有那种方块字（Block letters）。关于这两个选项的优缺点，以及为什么选择其中一个方向，你有什么想法吗？

---

### (00:39:51) Jessica Hische

**English:**
The handwritten one, I really liked because I felt like we could bring the line quality of the illustration into the handwriting, but then the only problem with the handwriting is that if you want to blow that out, if you want to include other handwriting throughout the rest of the brand, finding something that matches that perfectly without creating a custom typeface is a whole thing. I really like being able to combine the two, where we have this broader visual vocabulary that we can pull from, because you're going to have headlines, you're going to have subheads, you're going to have all these other uses for typography moving forward. If you just have one thing to pull from, it's a lot harder to work with. It's just nicer when you have a few elements to play with. It's like having a wardrobe. If you have only one shirt and one pair of pants, there's only so many things that you can do. But if you have all these things that work together and can recombine, then you can blow out a brand system much more easily.

**中文翻译:**
我非常喜欢手写体那个方案，因为我觉得我们可以把插画的线条质感融入到手写字中。但手写体唯一的问题是，如果你想扩展它，想在品牌的其他地方也使用手写元素，那么在不创建一整套定制字库的情况下，很难找到能完美匹配的字体。我非常喜欢将两者结合，这样我们就有了更丰富的视觉词汇可以调用。因为未来你会有标题、副标题以及各种其他的字体用途。如果你只有一个元素可以调用，工作起来会很难。有几个元素可以搭配会更好，就像衣橱一样：如果你只有一件衬衫和一条裤子，你能做的组合很有限；但如果你有很多可以互相搭配和重新组合的单品，你就能更轻松地扩展出一套品牌系统。

---

### (00:40:44) Lenny Rachitsky

**English:**
Yeah. That's one of my favorite things about working with you, is you create all these different variations of ways to use it. It doesn't always have to be the handwritten one. It could be the blocky outlining one. It's not like, "This is it, don't change anything about this. This is the only way to use it."

**中文翻译:**
是的。这也是我喜欢与你合作的原因之一：你创造了所有这些不同的变体和使用方式。不一定非得是手写体，也可以是带轮廓的方块字。而不是那种“这就是最终版，什么都别动，这是唯一的使用方式”。

---

### (00:40:57) Jessica Hische

**English:**
Well, part of that is because some brands, if you have a massive company, like hundreds of employees generating hundreds of things, sometimes having too many assets can overcomplicate stuff. Because unless you have a really, really well-written brand book outlining how to do everything that people are adhering to very closely, you can get the assets running rampant throughout all of the stuff and being used incorrectly. But because you're not a massive company and you have creative control over the things that are happening and can help direct that, we can be much more playful with the assets and give you the ability to use things in different ways. It depends on how much you trust all the people that are handling your assets.

**中文翻译:**
嗯，部分原因是对于某些品牌，如果你有一家拥有数百名员工、产出成百上千内容的大公司，资产太多有时会让事情变得过于复杂。因为除非你有一本写得极其详尽的品牌手册（Brand book），规定了每个人必须严格遵守的每一项操作，否则这些资产可能会在各种地方被乱用。但因为你不是一家巨型公司，你对正在发生的事情拥有创意控制权，并且可以亲自指导，所以我们可以让资产更具趣味性，让你有能力以不同的方式使用它们。这取决于你对处理这些资产的人有多信任。

---

### (00:41:43) Jessica Hische

**English:**
I am of the mind that you shouldn't need a 500-page brand book in order to direct how the brand is used moving forward, and that if you do, the brand might be quite complicated, or there might be even just parts of the logo that make it difficult to work with. My goal always when designing a logo is to design a logo that's so easy to use that you don't have to be an extremely skilled designer to design well with it. That's my number one goal, because I know not everybody is going to be at a stage where they have an internal brand team or a designer that's a rock star designer that can work with really complicated assets and make them look good.

**中文翻译:**
我一直认为，你不应该需要一本 500 页的品牌手册来指导品牌未来的使用。如果你真的需要，那说明品牌可能太复杂了，或者标志的某些部分让它很难被应用。我设计标志的目标始终是：让它变得如此易用，以至于你不需要成为一名极其出色的设计师也能用它做出好的设计。这是我的首要目标，因为我知道并非每个人都处于拥有内部品牌团队或顶级设计师的阶段，那些设计师能处理极其复杂的资产并让它们看起来很棒。

---

### (00:42:28) Jessica Hische

**English:**
I just want the assets to teach you themselves, by just how they exist, how to use it. You, as a person that has any taste whatsoever, and hopefully people that you're hiring for any job at your company have some degree of taste. If you hire an engineer, they have to have taste about how that happens. If you hire a marketing person, they have to have taste about how that happens. They should be able to look at that and intuit most of the way that you should be able to use it without being explicitly told, "Do not do this."

**中文翻译:**
我希望这些资产本身就能教会你如何使用它们。作为一个有品位的人——我也希望你公司雇佣的任何岗位的员工都有一定的品位。如果你雇佣一名工程师，他们对代码的实现也应该有品位；如果你雇佣一名营销人员，他们对营销方式也应该有品位。他们应该能够看着这些资产，凭直觉就知道大部分的使用方式，而不需要被明确告知“不要这样做”。

---

### (00:43:01) Lenny Rachitsky (Sponsorship)

**English:**
This episode is brought to you by Merge. Product leaders, yes, like you, cringe when they hear the word integration. They're not fun for you to scope, build, launch, or maintain, and integrations probably aren't what led you to product work in the first place. Lucky for you, the folks at Merge are obsessed with integrations. Their single API helps SaaS companies launch over 200 product integrations in weeks, not quarters. Think of Merge like Plaid, but for everything B2B SaaS. Organizations like Ramp, Dorado, and Electric use Merge to access their customer's accounting data to reconcile bill payments, file storage data to create searchable databases and their product, or HRAS data to auto provision and deprovision access for the customer's employees. Yes, if you need AI-ready data for your SaaS product, then Merge is the fastest way to get it. Want to solve your organization's integration dilemma once and for all, book and attend a meeting at merge.dev/lenny and receive a $50 Amazon gift card. That's merge.dev/lenny.

**中文翻译:**
本期节目由 Merge 赞助。产品领导者们，没错，说的就是你们，听到“集成（Integration）”这个词都会感到头疼。确定范围、构建、发布或维护集成一点都不好玩，而且集成可能最初并不是吸引你从事产品工作的原因。幸运的是，Merge 的团队对集成非常痴迷。他们的单一 API 可以帮助 SaaS 公司在几周内（而不是几个季度）发布 200 多种产品集成。把 Merge 想象成 B2B SaaS 领域的 Plaid。像 Ramp、Dorado 和 Electric 这样的组织使用 Merge 来访问客户的会计数据以对账账单支付，访问文件存储数据以在产品中创建可搜索的数据库，或者访问 HRIS 数据以自动为客户员工分配或取消访问权限。是的，如果你的 SaaS 产品需要 AI 就绪的数据，Merge 是最快获取它的方式。想要一劳永逸地解决组织的集成难题吗？请在 merge.dev/lenny 预约并参加会议，即可获得 50 美元的亚马逊礼品卡。

---

### (00:44:08) Lenny Rachitsky

**English:**
This is a good circle back to something you touched on earlier that I wanted to come back to, which is a lot of companies, in your opinion, put too much weight on the power of brand, and rebranding, and how much a brand can fix their problems. Can you just again share your perspective on just how this might be an issue for people where they almost overemphasize the power of brand? [inaudible 00:44:32]

**中文翻译:**
这正好回到了你之前提到的一个我想深入探讨的话题：在你看来，很多公司过于看重品牌的力量、品牌重塑的力量，以及品牌能在多大程度上解决他们的问题。你能再分享一下你的观点吗？为什么过度强调品牌的力量可能会成为一个问题？

---

### (00:44:31) Jessica Hische

**English:**
Yeah. Well, there's different companies. There's companies where brand is literally everything, where they're doing something that's not crazy innovative in the first place and the brand is the thing that is the whole company, and that's fine. That's a completely valid way to do stuff. It's like people that can take in information and recommunicate it in a way to another audience or whatever that they hit that audience in a way that the original information couldn't do. Think about all of the people who write books on psychology, and medicine, and all kinds of stuff that write it for a broader popular audience. They're the ones reading the medical papers, they're the ones digesting all of this really huge complicated data, and turning it into something that normal people can read. I think that there are companies that are doing that. They're taking a thing that is not innovative or isn't like they're not the only ones doing it, but they're repackaging it in a way that takes that and makes it so accessible to so many people.

**中文翻译:**
是的。公司有很多种。有些公司品牌确实就是一切，他们做的东西本身可能并不是极具创新性的，品牌就是整家公司的核心，这没问题，这是一种完全有效的方式。这就像有些人能够吸收信息，并以一种能触达特定受众的方式重新传播，而原始信息无法做到这一点。想想那些写心理学、医学等书籍的科普作家，他们阅读医学论文，消化庞大复杂的数据，并将其转化为普通人能读懂的内容。我认为有些公司也在做同样的事：他们拿出一个并不新颖、或者并非只有他们在做的东西，但通过重新包装，让它变得非常易于大众接受。

---

### (00:45:34) Jessica Hische

**English:**
In that case, brand can matter immensely, where the brand really is the thing that shows people that the thing that you're doing has value. But for a lot of people, the brand should be somewhat invisible so that the thing itself becomes the star. If we think about the experiences that we have using products, sometimes there's products where there's a ton of fun and delight built into how you use it, and that can happen through brand through design choices and things like that. Sometimes the delight is the fact that nothing is getting in your way as you're using that product. You just figure out what's your ethos of your company. Is the whole thing about doing a thing well, doing it simply, and making sure that everything gets out of the way of that experience, or is it like we're trying to generate this delightful thing or we're trying to open it up to a new audience or whatever? Depending on whatever that goal is, brand can have a different place in that equation.

**中文翻译:**
在这种情况下，品牌至关重要，因为品牌是向人们展示你所做的事情有价值的核心。但对于很多人来说，品牌应该是某种程度上“隐形”的，好让产品本身成为主角。想想我们使用产品的体验：有些产品在使用过程中充满了乐趣和惊喜，这可以通过品牌设计来实现；但有时，最好的体验是当你使用产品时，没有任何东西阻碍你。你只需要弄清楚公司的特质（Ethos）是什么：是为了把一件事做好、做简单，并确保一切都不干扰这种体验？还是为了创造某种令人愉悦的东西，或者为了开拓新受众？根据目标的不同，品牌在其中的地位也不同。

---

### (00:46:42) Lenny Rachitsky

**English:**
I think some of this unique perspective on the power brand and the need for it in tech companies comes from you're not like a tech person. You work with tech people, you work with tech companies. Do you feel like that has an impact on the way you think and the value that you bring to companies to give them this very outside perspective?

**中文翻译:**
我认为你对品牌力量以及科技公司对品牌需求的这种独特见解，部分源于你并不是一个典型的“科技圈人”。你与科技圈的人和公司合作，但你并不属于其中。你觉得这种身份是否影响了你的思维方式，以及你为公司提供这种“局外人视角”所带来的价值？

---

### (00:47:01) Jessica Hische

**English:**
I mean, most of the folks that I know that work in brand or traditional graphic design, print design, they don't necessarily have a lot of insight into how building companies works. They're not friends with a ton of startup founders and things like that. I've just had been in this very fun position being like everyone's token creative person in The Bay for a while, and this been for a long time. I remember speaking at a Silicon Valley event that was women in Silicon Valley in 2009 or 2010, something like that. It's interesting to be a person that has never actually, themselves, worked at a tech company but felt so involved and understanding about how all of that works. My partner, the reason why we're in The Bay is because he got hired by Facebook back in 2011. We were olds at the time. Take that with a grain of salt, don't judge me.

**中文翻译:**
我的意思是，我认识的大多数从事品牌、传统平面设计或印刷设计的人，并不一定了解公司是如何运作的。他们并不认识很多初创公司创始人。而我一直处于一个非常有趣的位置，在湾区很长一段时间里，我就像是大家公认的“创意代表”。我记得 2009 或 2010 年左右在硅谷的一个女性活动上演讲。作为一个从未真正在科技公司工作过，却对这一切运作方式如此了解并深度参与的人，这种感觉很有趣。我的伴侣，我们之所以在湾区是因为他在 2011 年被 Facebook 雇佣了。当时我们已经算“老人”了——别介意，别评判我。

---

### (00:48:02) Jessica Hische

**English:**
Because we were 28, 29 coming over to work at Facebook and everybody there was 23, 24, and so all the people that we ended up meeting in The Bay were more people our age that were moving on to start companies and things like that. We just got to see that perspective so clearly of what it is to branch out on your own, to fundraise, to do all this stuff, to pivot, to do little experimental apps and see where that goes to get acquired as a team versus getting acquired as a technology or whatever. I've been able to see that in a way that I feel like a lot of people that do my job don't get to see. That makes me very sympathetic and towards what it is to want to build a brand as a founder. I understand that you have limited resources and those resources aren't necessarily going to get devoted to doing a $200,000 brand exploration, because when you have $500,000 of money at all for a year to try to get things going, you certainly should not spend half of that money on branding.

**中文翻译:**
因为我们当时 28、29 岁去 Facebook 工作，而那里的人大多才 23、24 岁。所以我们在湾区结识的人大多是同龄人，他们后来都去创办了自己的公司。我们非常清晰地看到了独立创业、融资、转型、做实验性应用、被作为团队收购还是作为技术收购等等过程。我能以一种很多同行看不到的方式观察到这些。这让我对想要建立品牌的创始人非常有同理心。我明白你的资源有限，这些资源不一定非要投入到 20 万美元的品牌探索中。因为如果你一年总共只有 50 万美元来维持运转，你绝对不应该把一半的钱花在品牌设计上。

---

### (00:49:12) Jessica Hische

**English:**
That's my opinion, but that's not to say that brand can't be important and can't come in at some level or can't be thought of as a partnership between you and someone else where... There's this whole idea of fractional leadership now, which I feel like hasn't really infiltrated my world as much, but I don't know why it hasn't, because most people don't have internal comms teams, internal brand teams, until the company is very mature. The idea that you could bring someone in who is a real expert in whatever it's that they do, just as you need them, and they just get consultant equity kind of thing, that should be more present because people don't necessarily need to have internal brand teams for the first six months to a year of when they're doing stuff unless they grow really significantly.

**中文翻译:**
这是我的观点，但这并不是说品牌不重要，或者不能在某种程度上介入。现在流行“碎片化领导力（Fractional leadership）”的概念，虽然它还没怎么渗透到我的设计圈，但我不知道为什么没有。因为大多数公司在非常成熟之前都没有内部沟通团队或品牌团队。你可以根据需要引入某个领域的真正专家，给他们顾问股权之类的，这种模式应该更普及。因为在创业的前半年到一年里，除非增长非常迅猛，否则人们并不一定需要内部品牌团队。

---

### (00:50:05) Lenny Rachitsky

**English:**
Along these lines, you have a pretty unique way of pricing your work. For people that may want to explore this with you, share whatever you can about just how you think about pricing and ideally even an order magnitude of pricing so they're like, "Oh, okay. We should actually do this."

**中文翻译:**
说到这里，你的定价方式非常独特。对于那些想和你合作的人，能否分享一下你的定价思路，最好能给出一个大致的价格量级，让他们心里有个底：“哦，好吧，我们确实应该做这件事。”

---

### (00:50:21) Jessica Hische

**English:**
To go back to the process how it's always about figuring out what people are trying to accomplish, so a lot of my process scales depending on how broad of an exploration that we're doing. The way that I treat it is I treat my branding work not dissimilarly to how I treat commercial lettering, which is atypical. Brand people, what they typically do is because the client has to own the assets outright at the end no matter what, they tend to do is bill everything that the client owns everything as you are moving along. It's all sort of work for hire, but the idea being that it's a buyout of everything that is being made. What that means is that when a branding agency is pricing stuff for you, they're taking the buyout rights and baking it into every round of work so that every round gets more expensive because you are owning all of the work.

**中文翻译:**
回到流程上，重点始终是弄清楚人们想要实现什么，所以我的流程会根据探索的广度而缩放。我处理品牌工作的方式与处理商业艺术字体的方式类似，这很不寻常。品牌设计公司通常的做法是，因为客户最终必须完全拥有这些资产，所以他们会在过程中对所有东西计费。这有点像“雇佣作品（Work for hire）”，核心思想是买断所有产出的东西。这意味着当品牌代理机构为你定价时，他们会将买断权分摊到每一轮工作中，所以每一轮都会变得更贵，因为你拥有了所有的产出。

---

### (00:51:14) Jessica Hische

**English:**
What I do is I treat it much more like a commercial lettering project where I say, "You have to own the rights to this eventually, but hey, let's break that out and let's keep the creative process lighter and less expensive so then we have more room to explore. So then if some stakeholder comes in last minute and blows everything else up and we need to start over, you haven't already paid to own everything that we've created, you just pay to own the thing that we create in the end that gets chosen." I really like the idea of keeping the creation process more flexible and to try to scale to what people need versus having a really rigid way of approaching everything. Sometimes people will bring me on really early in the process, where if they have an internal team or if they're working with an external agency or something, they want me there from the get out.

**中文翻译:**
而我的做法更像是商业艺术字体项目。我会说：“你最终必须拥有版权，但嘿，让我们把版权费拆分出来，让创意过程变得更轻松、更便宜，这样我们就有更多的探索空间。这样一来，如果某个利益相关者在最后一刻介入并推翻了一切，我们需要重新开始，你也不必为我们之前创作的所有东西支付买断费，你只需要为你最终选中的那个作品支付版权费。”我非常喜欢保持创作过程的灵活性，并根据人们的需求进行缩放，而不是采用死板的方式。有时人们会在非常早期就邀请我加入，比如他们有内部团队或正在与外部代理机构合作，他们希望我从一开始就在场。

---

### (00:52:04) Jessica Hische

**English:**
Some people are like, "We have no money and we are going to try to do this as much as we can inside of our business, but then can we hire you at the end to make it look good? If we can get everybody bought in and get it 80% of the way there." Depending on what people's budgets are, I have different ways of working, or just depending on what their needs are. Because my whole thing too is I don't want to step on anybody's toes, because sometimes companies have these really amazing designers that are working in-house, and it sucks as a designer who started at a company and thinks that you might be able to get a chance to work on what is considered the most important asset in terms of the brand and they just farm it out to someone else instead of letting you touch it. To me, that's a recipe for anything that I create to be immediately killed, because someone inside is going to be like, "It's time to shine," and then they're just going to kill all my work.

**中文翻译:**
有些人会说：“我们没钱，我们会尽量在内部完成大部分工作，但最后能不能请你来把它变漂亮？如果我们能让大家达成共识并完成 80% 的话。”根据预算和需求的不同，我有不同的工作方式。我也不想冒犯任何人，因为有些公司内部有非常出色的设计师。如果一个设计师在公司工作，满心期待能参与最重要的品牌资产设计，结果公司却外包给了别人，那感觉糟透了。对我来说，这会导致我创作的任何东西都会被内部人员立刻否定，因为他们会觉得：“现在轮到我表现了”，然后把我的作品全盘推翻。

---

### (00:52:56) Jessica Hische

**English:**
I'm always like, "How do we collaborate? How do I make it so that I'm an asset to you? Not that I'm trying to step on your toes, not that I'm trying to take over what's the cool juicy work from the people who inside that are really excited to do it." I just want them to feel as bought in as I can be. But yeah, it becomes interesting. I feel like I get told by branding people that I'm too inexpensive because they're like, "Oh, for what you do, it should be 60 or $70,000 at a minimum to do all this kind of stuff." I'm like, I feel like the majority of the projects that I do end up being between 25 and 35, but depending on how you bring me in, it can be less if it's just as a consultant. It's not out of the realm of possibilities to hire a proper crazy expert at stuff. It's not like you're thinking about sinking half a million dollars into the brand. That's a very different experience.

**中文翻译:**
我总是问：“我们如何协作？我如何成为你们的助力？我不是来抢地盘的，也不是来抢走那些内部人员梦寐以求的酷工作的。”我希望他们能像我一样投入。不过这确实很有趣，品牌圈的人总说我收费太低，他们觉得：“噢，像你这种水平，起码得收 6 万或 7 万美元。”但我感觉我做的大多数项目最终都在 2.5 万到 3.5 万美元之间。根据介入方式的不同，如果只是作为顾问，费用还会更低。雇佣一个真正的顶级专家并不是遥不可及的，这不像你想象中要往品牌里砸 50 万美元，那是完全不同的体验。

---

### (00:53:51) Lenny Rachitsky

**English:**
Awesome. Thank you for sharing that. Before we get into other stuff that you do, because like you said at the top, there are many other things you do outside of this specific time of work, is there anything else you think might be helpful or important for people to know about working with you on a logo refresh or just thinking about logos and this whole space we talked about?

**中文翻译:**
太棒了，谢谢你的分享。在我们聊你做的其他事情之前（正如你开头所说，除了这类工作你还做很多别的事），你觉得还有什么关于标志翻新或标志设计领域的重要信息是大家应该知道的吗？

---

### (00:54:11) Jessica Hische

**English:**
The best thing is just seeing what's there and really being able to understand what's not working about it and what your goals are. Like I said with that reverse justification of intuition, I think if you know that the logo is not quite where you want it to be, just spend a couple days asking yourself why. "What is the thing about this that bothers me?" Don't get specific. Don't be like, "The way the R is," or whatever. Maybe that's the thing that we talk about down the line, but always think big picture before you think minutiae, because sometimes people think that... They'll throw a bunch of minutiae stuff at me, but it's because they haven't really stopped to think about what is the overall thing that's bothering them.

**中文翻译:**
最好的办法就是审视现状，真正理解哪些地方行不通以及你的目标是什么。就像我说的“为直觉寻找事后理由”，如果你觉得标志没达到预期，就花几天时间问自己为什么。“到底是什么地方让我不舒服？”不要太具体，不要一上来就说“字母 R 的写法不对”。那些细节我们可以以后再谈，但在考虑细节之前，一定要先看大局。因为有时候人们会扔给我一堆琐碎的问题，那是因为他们还没停下来思考到底整体上哪里让他们不满意。

---

### (00:54:59) Jessica Hische

**English:**
You just never get there if you're always trying to address detail before you address the big picture stuff. You have to just always start super top level, and really ask yourself very broad questions about why you think it's not working, and then go tighter, and tighter, and tighter, and be like... It really could be like, "This C has always bothered me," and then we can get real specific about that when I'm doing the refresh. But I think I also need to understand the overall reason why we're doing this, not just the little bugaboo that bothers you specifically but might not bother anybody else.

**中文翻译:**
如果你总是在解决大局问题之前纠结于细节，你永远无法达到目标。你必须始终从最高层面开始，问自己一些非常宽泛的问题：为什么我觉得它不行？然后逐渐收窄、收窄、再收窄。最后可能确实是“这个字母 C 一直让我不爽”，那么在翻新时我们可以针对性地解决。但我认为我也需要理解我们做这件事的整体原因，而不仅仅是那个只困扰你一个人、别人可能根本不在意的“小疙瘩”。

---

### (00:55:35) Lenny Rachitsky

**English:**
Yeah. When I was thinking about this, it feels like my whole feeling was this could be better. That's all it was for me initially, is just like I feel like it could be a lot better. I imagine that's enough for some people, just like, "I think this could be better," and then here's things [inaudible 00:55:50].

**中文翻译:**
是的。当我考虑这件事时，我最初的感觉就是“这可以做得更好”。这就是我最初的全部想法：我觉得它还有很大的提升空间。我想对某些人来说，这就足够了，只要说“我觉得这可以更好”，然后列出一些点。

---

### (00:55:49) Jessica Hische

**English:**
Yeah. That's definitely enough for some people, because I think sometimes... I think you, specifically, had a very clear vibe going on with all of your brand stuff. Some people, it's totally like a mishmash grab bag of random trends and there's no real voice that's coming through. But I feel like you've been doing this for a while, and when you see everything together, there's definitely a very clear vision and vibe that you get from everything. I always tell people that having terrible vision can be your best asset when it comes to logo and brand, because it allows you...

**中文翻译:**
是的，对某些人来说这确实足够了。因为我觉得……特别是你，你的所有品牌素材已经有了一个非常清晰的氛围。而有些人的品牌完全是各种随机趋势的杂乱堆砌，没有真正的灵魂。我觉得你已经做这件事一段时间了，当把所有东西放在一起看时，确实能感受到非常清晰的愿景和氛围。我常告诉人们，在处理标志和品牌时，视力不好（Terrible vision）反而是你最大的资产，因为它能让你……

---

### (00:56:30) Jessica Hische

**English:**
Just take your glasses off if you have terrible vision, and look at it, and get the feeling when you can't see the detail. You have to be looking at it with blurred eyes. What is the overall look of this thing? Just trying to get as broad and noodly as you can with it instead of it being about those really specific one by one stuff. I think when you blur your eyes on your brand, there was a really clear cohesiveness to it already. It was just about massaging it into a more consistent professional-looking place.

**中文翻译:**
如果你视力不好，就摘掉眼镜去看，在看不清细节的情况下感受它。你必须眯起眼睛看。这个东西的整体外观是什么？尽量从宏观、抽象的角度去感受，而不是纠结于那些具体的细节。我觉得当你眯起眼睛看你的品牌时，它已经具备了非常清晰的凝聚力。我的工作只是把它打磨得更一致、更专业。

---

### (00:57:07) Lenny Rachitsky

**English:**
Well, I can't look at the old logo anymore now that I've gotten this thing coming together, so I'm really excited for this to come out. Just a couple closing questions. One is you have a lot of other stuff going on that is not just typography and logo refreshes. You have children's books, you do lettering for classics, you have a store in Oakland. Talk about all these other things you got going on in case it might interest people.

**中文翻译:**
既然现在新标志已经成型，我简直没法再看旧标志了，所以我非常期待它的发布。最后还有几个问题。一个是，除了字体设计和标志翻新，你还有很多其他事情在忙。你有童书，你为经典著作做艺术字，你在奥克兰还有一家店。聊聊这些事情吧，也许听众会感兴趣。

---

### (00:57:32) Jessica Hische

**English:**
Sure. Yeah, of course. I'm based here in The Bay, as we've talked about, and I have a studio in Downtown Oakland. My studio is like Barbie's creative Dream house, where the top floor is my office, that's where I'm right now, and then the bottom floor on one side is a workshop. I do a lot of printmaking. I went to college at a school that was very focused on interdisciplinary work, and I feel like I bring a lot of manual analog processes into my work a lot. I find it really important to make physical things as a part of my creative process, so I do a lot of printmaking. On the other side downstairs is a brick and mortar store. I've always wanted to have a brick and mortar store because, as an artist, I think having people have a physical connection to your work can be really important.

**中文翻译:**
当然可以。正如我们所说，我住在湾区，在奥克兰市中心有一个工作室。我的工作室就像芭比的创意梦想屋：顶层是我的办公室（我现在就在这儿），底层的一侧是工作坊。我做很多版画（Printmaking）。我上的大学非常注重跨学科工作，我觉得我把很多手工、模拟的流程带入了我的工作中。我发现制作实物是我创意过程中非常重要的一部分。底层的另一侧是一家实体店。我一直想开一家实体店，因为作为一名艺术家，我认为让人们与你的作品产生物理连接非常重要。

---

### (00:58:20) Jessica Hische

**English:**
I think one of the reasons why people hire me to do things for them is because one of the gifts of working with someone that is a real nerd professional about whatever it is that they do is that they bring you along the journey and give you the language to talk about the thing through their eyes and through their experience. To me, the funnest thing for me is actually telling clients and teaching them about all the things that we are doing along the way so then they go out into the world as a newly-minted type nerd and can communicate all of these things to other people. That connection is just really important. The connection to the work, the story behind it, I feel like that's one of the ways that we create lasting work, is understanding that the work exists because there's a story behind it. Things, if they're just created because of the aesthetics or they're just created quickly or whatever, it's really easy to discard them because there's not a story behind it.

**中文翻译:**
我认为人们雇佣我的原因之一是：与某个领域的真正专家合作，他们会带你一起经历这段旅程，并赋予你从他们的视角和经验出发去谈论这件事的语言。对我来说，最有趣的事情其实是告诉客户并教给他们我们在过程中所做的一切，这样当他们回到现实世界时，就成了一个“新晋字体迷”，可以把这些知识传达给别人。这种连接非常重要。对作品的连接、作品背后的故事——我觉得这是创造持久作品的方法之一，即理解作品的存在是因为背后有故事。如果东西只是为了美观而创作，或者是为了快而创作，它们很容易被丢弃，因为背后没有故事。

---

### (00:59:22) Jessica Hische

**English:**
But if you think about all the objects in your life that have followed you throughout your life, what's a thing that you've had since you were in fifth grade or whatever that is still magically in your possession in your house? You have that because the story of that thing is so important to you. I think that the work that we create, the design that we create, can have that. It can be imbued with so much story and meaning, that when we think about moving on from it, we're like, "Ugh, but this." I think that's one of the ways to build a lasting brand, is to just make sure that the story of creating it feels so real, and visceral, and important. The store is a way for people to have a physical connection to other work that I create, like the prints and things like that.

**中文翻译:**
但如果你想想生活中那些陪伴你多年的物品——有什么东西是你从五年级开始就一直保留到现在，还神奇地放在你家里的？你留着它是因为它的故事对你很重要。我认为我们创作的作品、我们做的设计也可以拥有这种特质。它可以被赋予如此多的故事和意义，以至于当我们考虑放弃它时，会觉得：“呃，但是这个……”我认为建立持久品牌的秘诀之一，就是确保创作它的故事感觉如此真实、深刻且重要。我的店就是让人们与我创作的其他作品（如版画等）产生物理连接的一种方式。

---

### (01:00:07) Jessica Hische

**English:**
With the kids' book stuff, that's also about creating lasting stuff. I like creating physical things in the world. I like repackaging things that I've learned in therapy in a way that kids will appreciate and enjoy. I'm just always thinking about what's a way that I can say a thing that has been said before but hasn't been said in this way. If I can turn that into a physical object that people can have and appreciate, all the better. But yeah, I don't know. While, professionally, what I do is considered very niche, I feel like all the things that I do are quite diverse, because they tickle different parts of my brain. I have to use my hands in different ways and my mind in different ways. It's how I've been able to generally avoid feeling burnt out as a creative, is just being able to move on between different kinds of work and just feel excited about different things at different times.

**中文翻译:**
关于童书，那也是为了创造持久的东西。我喜欢在世界上创造实物。我喜欢把我在心理治疗中学到的东西重新包装，让孩子们能够理解和享受。我一直在思考：如何用一种前所未有的方式去表达一件已经被说过无数次的事情？如果我能把它变成一个人们可以拥有和欣赏的实物，那就更好了。虽然从职业角度看，我做的事情很小众，但我感觉我做的所有事情都非常多样化，因为它们触动了我大脑的不同部分。我必须以不同的方式使用我的双手和头脑。这就是我作为创意人能够避免职业倦怠的方法：在不同类型的工作之间切换，在不同时间对不同的事物感到兴奋。

---

### (01:01:05) Lenny Rachitsky

**English:**
For folks that want to maybe check out the store, how do they find it? It's called Jessica and Friends, is that right?

**中文翻译:**
如果有人想去店里看看，怎么找？是叫 "Jessica and Friends" 吗？

---

### (01:01:08) Jessica Hische

**English:**
Yes. It's called Jessica Hische and Friends.

**中文翻译:**
是的，叫 "Jessica Hische and Friends"。

---

### (01:01:10) Lenny Rachitsky

**English:**
Jessica Hische and Friends.

**中文翻译:**
Jessica Hische and Friends.

---

### (01:01:13) Jessica Hische

**English:**
You can just Google JH&F.

**中文翻译:**
你可以直接搜 "JH&F"。

---

### (01:01:14) Lenny Rachitsky

**English:**
Google Maps, yeah. [inaudible 01:01:17]

**中文翻译:**
谷歌地图，好的。

---

### (01:01:18) Jessica Hische

**English:**
Yeah. I put JH&F on as a part of the Google Maps name so I don't have to spell my name to strangers, because I have a weird German spelling last name. I also have a second store called Drawling, which is drawing with an L thrown in there. That one is an all-ages art supply store that's sort of a kids' art supply store. That one grew out of JH&F as well. Those two stores exist. With my books, if you just look up my last name on any of your favorite booksellers, you'll find me.

**中文翻译:**
是的。我在谷歌地图的名字里加了 JH&F，这样我就不用向陌生人拼写我的名字了，因为我的德语姓氏拼写很奇怪。我还有第二家店叫 "Drawling"（在 drawing 单词里加了个 L）。那是一家全年龄段的美术用品店，有点像儿童美术用品店。它也是从 JH&F 衍生出来的。这两家店都在。至于我的书，只要在任何书店搜索我的姓氏就能找到。

---

### (01:01:49) Lenny Rachitsky

**English:**
Last question. I'm just going to throw this out there in case something interesting comes up. We have a segment on this podcast called AI Corner, where I like to see how people have found ways to use AI in their work, in their life to be more productive, do cool things. Is there some way that you've found a way to use AI in the work that you do that makes you do more interesting stuff?

**中文翻译:**
最后一个问题。我想随便问问，看有没有什么有趣的发现。我们播客有一个叫“AI 角落”的环节，我喜欢了解人们如何利用 AI 来提高工作效率或做一些酷事。在你所做的工作中，你有没有发现什么使用 AI 的方法，能让你做出更有趣的东西？

---

### (01:02:09) Jessica Hische

**English:**
A little bit. I am in this really interesting position in terms of AI where my partner works at Meta on GenAI stuff. He's a director on the GenAI team at Meta and is very bought into AI as a whole thing. I am a little [inaudible 01:02:28] about its impact on a lot of the things that we do. I think, overall, it will become a tool and be very useful, especially in a lot of different fields. But I think this timeframe in which it's more novelty is going to have not the best impact on things like illustration, but eventually, we'll all come out of it and it'll be fine. In terms of how I've been able to integrate it into my process, I did some work for Salesforce last year where the theme for Dreamforce was going to be very AI-driven. I felt like I needed to explore AI as a part of the generative process for creating that art.

**中文翻译:**
有一点。在 AI 方面，我处于一个非常有趣的位置，因为我的伴侣在 Meta 负责生成式 AI（GenAI）的工作。他是 Meta 生成式 AI 团队的总监，非常看好 AI。而我对于它对我们所做事情的影响持保留态度。我认为总的来说，它会成为一个非常有用的工具，尤其是在很多不同领域。但在目前这个“新鲜劲”阶段，它对插画等领域的影响可能并不太好，但最终我们会渡过这个阶段。至于我如何将其融入流程，去年我为 Salesforce 做了一些工作，当时 Dreamforce 大会的主题是 AI 驱动的。我觉得我需要探索将 AI 作为创作艺术的生成过程的一部分。

---

### (01:03:08) Jessica Hische

**English:**
I did have fun creating custom lettering and then trying to run it through stable diffusion to get stable diffusion to generate instances of my lettering in different styles. We were making these clouds. We ultimately didn't end up using it, but it was still really neat to see. I could see the validity of that in the creative iterative process. I think the biggest thing for me is that I find that the sloggy, slow dregs of work is very fulfilling to me, that a lot of the evangelists of AI are like, "Oh, imagine if you could spend all of your time high level thinking, and coming up with the concepts, and guiding the vision, and whatever, and then just get AI to do everything else that you don't care about." For me, that just sounds like not the most holistic approach to how I work, because the reason why I do all the things that I do and why my process is the way that it is because while I love thinking and I love coming up with conceptual stuff, I find it to be very cerebrally taxing.

**中文翻译:**
我尝试了创作定制艺术字，然后用 Stable Diffusion 生成不同风格的变体，这很有趣。我们当时在做一些云朵。虽然最终没用上，但看到那个过程还是很酷的。我能看到它在创意迭代过程中的价值。但对我来说，最关键的一点是：我发现那些缓慢、枯燥的“苦活”对我来说非常有成就感。很多 AI 倡导者会说：“想象一下，如果你能把所有时间都花在高层思考、构思概念和引导愿景上，然后让 AI 去做那些你不在乎的琐事。”对我来说，这听起来并不是最完整的工作方式。因为我之所以做这些事，是因为虽然我喜欢思考和构思，但我发现那非常耗费脑力。

---

### (01:04:17) Jessica Hische

**English:**
I need a break from that by doing the more low-key production end of stuff. That's my favorite part of the process, is we know what we're doing, and now it's just about going in. When it comes to judging logos, for instance, the days that I spend knowing exactly what I'm going to do and all it is me just moving little Bezier handles around and getting it feeling right and whatever, those are pure therapeutic zen for me. I think I will always have that as a part of my work and will probably not have AI be outputting that part. But I have been able to have it be helpful in the iterative process a little bit, both through generating sketches with that project and then also through a lot of stuff with writing with my kids' books and things like that, is coming up with lists of words and concepts that are adjacent to each other, whatever.

**中文翻译:**
我需要通过做一些低强度的制作工作来换换脑子。那是流程中我最喜欢的部分：我们已经知道要做什么了，现在只需动手实现。比如在打磨标志时，那些我明确知道该做什么、只需移动贝塞尔曲线手柄（Bezier handles）让感觉对味的日子，对我来说是纯粹的疗愈和禅定。我认为这永远是我工作的一部分，我可能不会让 AI 来输出这部分。但在迭代过程中，AI 确实有一点帮助，比如在那个项目中生成草图，或者在写童书时帮我列出相关的词汇和概念。

---

### (01:05:17) Jessica Hische

**English:**
I have found that Claude and ChatGPT are very good for things like that. I'm working on another kids' book now, and I'm trying to think of the directions that it can take. One of them is sort of illustrating different feelings and things like that. I could sit there and brainstorm what are the different emotions or whatever, or I can just ask Claude like, "List 50 emotions," and then I can cherry-pick the ones that come up that feel right. I do find it's really good for that early brainstorming stuff, and that's been really nice.

**中文翻译:**
我发现 Claude 和 ChatGPT 在这方面非常出色。我现在正在写另一本童书，正在思考它的方向。其中一个方向是描绘不同的感受。我可以坐在那儿冥思苦想有哪些不同的情绪，也可以直接问 Claude：“列出 50 种情绪”，然后从中挑选出感觉对的。我确实发现它在早期头脑风暴阶段非常好用，这很棒。

---

### (01:05:50) Lenny Rachitsky

**English:**
Is there anything else that you want to share or leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
在进入我们非常精彩的闪电轮提问之前，你还有什么想分享或留给听众的吗？

---

### (01:05:58) Jessica Hische

**English:**
Yes. Well, I do have a new kid's book coming out in October.

**中文翻译:**
有的。我有一本新童书要在 10 月份出版了。

---

### (01:06:02) Lenny Rachitsky

**English:**
Oh, [inaudible 01:06:02].

**中文翻译:**
噢，太棒了。

---

### (01:06:02) Jessica Hische

**English:**
Aside from all the logo stuff, please do check out my kids' books. It's called My First Book of Fancy Letters, and it is like a new spin on an alphabet book, but instead of it being an alphabet book for brand new babies, which you could totally buy it for brand new babies because it is very simple, and fun, and they'll like the bright pictures, it's for the age where kids can recognize letters but can't necessarily read and write yet because they get so into seeing letters drawn in these different styles and imagining what other letters could be drawn in. Each of the letters is drawn to represent the word that it sounds like. Letters can be athletic, bubbly, or creepy, and then it's like, "Well, what does a creepy C look like?"

**中文翻译:**
除了标志设计，也请关注我的童书。这本叫《我的第一本华丽字母书》（My First Book of Fancy Letters），它是对字母书的一种全新诠释。它不只是给刚出生的婴儿看的（虽然你完全可以买给婴儿，因为它很简单、有趣，他们会喜欢鲜艳的图片），它更适合那些能认出字母但还不会读写的孩子。因为他们会非常沉迷于看到字母以不同的风格呈现，并想象其他字母可以怎么画。每个字母的画法都代表了它听起来像的那个词。字母可以是“运动风（Athletic）”、“泡泡风（Bubbly）”或“诡异风（Creepy）”，然后孩子们会想：“那诡异的 C 长什么样？”

---

### (01:06:49) Jessica Hische

**English:**
When kids are starting to understand letter sounds and recognizing letters, they can start thinking about what other words start with that letter sound, and then they start listing stuff out and become immediate over-the-shoulder art directors. It's been really fun showing it to other preschoolers, and TK, and kindergarten kids, because they're immediately like, "Well, R should be a river. It should be a river." I'm like, "Well, how do you draw a river?" It becomes this fun imagination exercise too, so definitely check that out. It's up for pre-order now and comes out October 22nd.

**中文翻译:**
当孩子们开始理解字母的发音并识别字母时，他们会开始思考还有哪些词是以这个音开头的，然后他们会列出一堆东西，立刻变成你身后的“艺术总监”。把这本书展示给学龄前儿童看非常有趣，因为他们会立刻说：“嗯，R 应该是河流（River），它应该是条河。”我会问：“那你要怎么画一条河呢？”这变成了一个有趣的想象力练习。所以一定要关注一下，现在已经可以预订了，10 月 22 日上市。

---

### (01:07:21) Lenny Rachitsky

**English:**
That is so delightful. I know you have multiple kids. Do you start to see the idea with one age of kid and then by the time the next kid reaches that age, it's ready and published? Does that work timing-wise?

**中文翻译:**
太有趣了。我知道你有好几个孩子。你是不是在某个孩子处于某个年龄段时产生灵感，等下一个孩子长到那个岁数时，书正好出版？时间上是这么凑巧吗？

---

### (01:07:31) Jessica Hische

**English:**
Yeah, the only thing is both of my... Well, my oldest child is a real super reader. She's always ahead of the game. The second that she could read, she was like, "Oh, picture books are for babies." Now she's reading, she goes into Pegasus books and is just like, "Where are your books for teenagers?" They're like, "You're nine. We're not going to show you that, but here are the middle grade books or whatever." There is a little bit of that. You are a parent, but you are a parent of a very young person. Kids don't want to buy anything you're selling as a parent. There's a little bit of that where I feel like I get so many wonderful letters from other families about how it's their favorite book, and they read it every night, and it's so important, and then my kids are like, "Yeah, yeah. It's just mom's book, whatever."

**中文翻译:**
是的，唯一的问题是……我的大女儿是个超级阅读者，她总是超前。她一学会阅读就说：“噢，绘本是给小宝宝看的。”现在她去书店会问：“你们的青少年读物在哪儿？”店员会说：“你才九岁，我们不能给你看那些，但这里有适合中年级读者的书。”确实有这种情况。你是个家长，但你是一个年幼孩子的家长。孩子们通常不想买家长的账。我经常收到其他家庭的来信，说这是他们最喜欢的书，每晚都读，非常重要。而我的孩子只会说：“行了行了，那只是妈妈写的书，随便吧。”

---

### (01:08:23) Lenny Rachitsky

**English:**
Yeah, that's bittersweet. Well, with that, Jessica, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
哈哈，真是苦乐参半。好了，Jessica，我们进入了非常精彩的闪电轮环节。准备好了吗？

---

### (01:08:30) Jessica Hische

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### (01:08:31) Lenny Rachitsky

**English:**
Speaking of books, first question, what are two or three books that you've recommended most to other people?

**中文翻译:**
说到书，第一个问题：你向别人推荐最多的两三本书是什么？

---

### (01:08:36) Jessica Hische

**English:**
Rick Reuben's creativity book is so good. Definitely recommend that. I haven't listened to it on audiobook. I read the physical book, but I also heard the audiobook is very zen. I feel like it's just a very good palate cleanser in terms of being an artist and creating because it feels both high level but also very actionable, so really recommend that. In terms of learning about and understanding typography, there's this book called Inside Paragraphs by Cyrus Highsmith. It's very small and very digestible. You can read it in one bathroom visit, and it's illustrated really well. It has cool illustrations. If you want to learn about some basics of type and typography, it's a really great book, and incredibly accessible, and not like reading Bringhurst or something like that, so big ups to that book. Oh, what's another book?

**中文翻译:**
Rick Rubin 的那本关于创造力的书（《创造行为：一种生活方式》）非常棒，绝对推荐。我没听过有声书，我读的是纸质书，但听说有声书非常“禅”。我觉得它对于艺术家和创作者来说是一次很好的“味觉清洗”，因为它既有高度又非常具有操作性。关于学习和理解字体排印，有一本书叫《段落内部》（Inside Paragraphs），作者是 Cyrus Highsmith。它非常小巧，易于消化，上一次厕所的时间就能读完。它的插图非常精美。如果你想学习字体和排版的基础知识，这是一本极好的入门书，非常平易近人，不像读 Bringhurst 的大部头那样枯燥。强烈推荐。哦，还有哪本？

---

### (01:09:33) Jessica Hische

**English:**
I don't know. I feel like I'm just going to end up recommending all the books that I'm currently reading. This month, I read both Patti Smith's Just Kids, which I loved also and was also... I feel like I'm reading a lot of books about being an artist more so than being a designer. That book, I found really interesting, just hearing her story of moving to New York and having nothing. Just trying to be an artist, and make art, and having that be the thing that drove everything that she and Robert Mapplethorpe did. I don't know, I just feel like I'm looking for ways to get out of my very business-driven sensibilities around art making and get into a space that's more loose, and free, and driven by passions and feelings more so than necessarily career-based milestones and things like that. This is a wild card one too. I just finished The Emperor of All Maladies. I'm just a big fan of reading things about human biology and things like that and found it totally fascinating, so do read that one too.

**中文翻译:**
我不知道，我感觉我最后会推荐所有我正在读的书。这个月我读了 Patti Smith 的《只是孩子》（Just Kids），我也非常喜欢。我觉得我最近读了很多关于“如何成为艺术家”而不是“如何成为设计师”的书。那本书非常有趣，听她讲述搬到纽约时一无所有，只是努力成为艺术家、创作艺术，并以此驱动她和 Robert Mapplethorpe 所做的一切。我感觉我正在寻找方法，让自己从那种非常商业驱动的艺术创作感性中跳出来，进入一个更松弛、更自由、由激情和感受驱动的空间，而不是仅仅为了职业里程碑。还有一个比较冷门的推荐：我刚读完《众病之王》（The Emperor of All Maladies，关于癌症的历史）。我很喜欢读关于人类生物学的东西，觉得它非常迷人，也推荐读读这本。

---

### (01:10:40) Lenny Rachitsky

**English:**
I can't help but ask, how do you have time to read, raise children, work on so many projects, have a run a store? What is your secret?

**中文翻译:**
我忍不住想问：你哪来的时间读书、养娃、做这么多项目，还要经营一家店？你的秘诀是什么？

---

### (01:10:50) Jessica Hische

**English:**
Well, you get pretty ruthless about your schedule when you're a parent, where when you're at the office, you are just heads in working, and so I think just trying to stay as focused as possible in that way. I do this thing where I bounce back and forth between projects a lot as I'm losing steam, and so having multiple things to work on keeps me motivated to keep working. I think it's kind of an ADHD thing, where I will start my day one way and then as soon as I start losing steam, I switch to a different thing, lose steam, switch to a different thing, lose steam, switch to a different thing. Rather than taking breaks, I just take a break by working on something that feels fresh. That can be super helpful.

**中文翻译:**
当你成为父母后，你会对自己的日程安排变得非常“冷酷”。在办公室时，你就只是埋头苦干，尽量保持专注。我会做一件事：当我在某个项目上感到疲倦时，我就在不同项目之间来回切换。同时处理多件事能让我保持工作的动力。我觉得这有点像 ADHD（多动症）的特质：我开始一天的工作，一旦动力下降，我就换一件事做，再下降，再换一件事。我不是通过休息来放松，而是通过做一些感觉新鲜的事情来“休息”。这非常管用。

---

### (01:11:35) Lenny Rachitsky

**English:**
That's an awesome tip.

**中文翻译:**
这是一个很棒的技巧。

---

### (01:11:36) Jessica Hische

**English:**
Yeah. I mean, it's incredible. I also would tell people when I had first started out, I had a full-time job and then was doing freelance in the evenings. People were like, "How do you not get burnt out, whatever?" It's because my day job was so different from my night job that it felt like I was doing two separate eight-hour shifts instead of one continual sixteen-hour shift. I think that's something to sort of think about, is that there's always going to be things that need to get done as a part of your work or things that you're interested in and passionate about. Just having enough diversity in what that means is going to allow you to maintain enthusiasm for doing all those different things for much longer. Actually, the more homogenous your life and career and job is, the faster you're going to burn out, so just making sure that you have enough variety and all the things that you do.

**中文翻译:**
是的，真的很神奇。我刚开始工作时，白天有一份全职工作，晚上做自由职业。人们问：“你怎么没累垮？”因为我的日间工作和夜间工作非常不同，感觉就像是做了两个独立的 8 小时轮班，而不是一个连续的 16 小时轮班。我觉得这是值得思考的一点：工作中总会有必须完成的事，也有你感兴趣和热爱的事。保持多样性会让你在更长时间内对这些事情保持热情。事实上，你的生活、职业和工作越单一，你就越容易倦怠。所以要确保你做的事情有足够的丰富性。

---

### (01:12:27) Lenny Rachitsky

**English:**
That was an awesome tip. I'm glad I went there. Okay, back on track to our lightning round. Is there a recent favorite movie or TV show you've really enjoyed?

**中文翻译:**
太棒了，很高兴我问了这个问题。好了，回到闪电轮。最近有没有什么你非常喜欢的电影或电视节目？

---

### (01:12:34) Jessica Hische

**English:**
Severance was my favorite TV show I think I've ever watched.

**中文翻译:**
《人生切割术》（Severance）可能是我看过的最喜欢的电视剧。

---

### (01:12:38) Lenny Rachitsky

**English:**
The second season's coming out.

**中文翻译:**
第二季快出了。

---

### (01:12:40) Jessica Hische

**English:**
I know. That came to mind because I knew the second season was coming out, so I'm just really excited about it, but I think that was probably tops for me.

**中文翻译:**
我知道。我想到它是因为我知道第二季要出了，我非常兴奋。那部剧对我来说绝对是顶级的。

---

### (01:12:48) Lenny Rachitsky

**English:**
Is there a favorite product you've recently discovered that you really love?

**中文翻译:**
最近有没有发现什么你非常喜欢的产品？

---

### (01:12:51) Jessica Hische

**English:**
Oh, yeah. Well, there's a few things. Well, there was one that's just a super random one that was just pure delight. There's a Japanese brand, Penco, and they make a lot of wonderful stuff. I carry a lot of their stuff in my store. One of the things I bought recently from them is a pen cup, a pencil cup. It's ceramic, but it looks like a paper bag, a lightly crumpled paper bag, and then it just has printed on it Penco, whatever. I just really like it when you take an existing object and give it a new form. I find that to be very delightful, and so that was, I think, one of the things that I really loved recently that I bought for the store.

**中文翻译:**
有的。有几样东西。其中一个非常随机，但纯粹是种享受。有一个日本品牌叫 Penco，他们做很多很棒的东西，我的店里也有卖。我最近买的是一个笔筒。它是陶瓷做的，但看起来像一个纸袋，一个微微揉皱的纸袋，上面印着 Penco。我非常喜欢这种把现有物品赋予新形式的设计。我觉得这非常令人愉悦。这是我最近为店里采购的非常喜欢的一件东西。

---

### (01:13:28) Lenny Rachitsky

**English:**
Awesome. Pick two more questions. Do you have a favorite life motto that you often think about, come back to share with folks, find useful, and work your life?

**中文翻译:**
太棒了。再选两个问题。你有没有什么经常想起、并愿意分享给别人的生活格言？你觉得它在生活和工作中很有用？

---

### (01:13:38) Jessica Hische

**English:**
It's funny being a lettering artist because I'm not much of a quotes gal, all things considered. I should be because I could make a million dollars by just making "live, laugh, love" pillows or whatever, but I am not usually continually collecting quotes. But I was just at a conference up in Portland called XOXO, and one of the presenters showed a quote on the screen that resonated with me more than most things that I've seen in recent memory. I feel like this is my new... It was one of those quotes that I was like maybe I should get a tattoo of that. When it gets to that level where you're considering a tattoo, you're like, "Okay, that's official." It was "hope is a discipline". I just really loved that. It's by Mariame Kaba or Mariame Kaba.

**中文翻译:**
作为一个艺术字体家，这挺逗的，因为我其实不太热衷于名言警句。我本该热衷的，因为我只要做点印着“热爱生活”之类的抱枕就能赚大钱，但我平时并不怎么收集名言。不过我最近在波特兰参加了一个叫 XOXO 的会议，一位演讲者在屏幕上展示了一句话，它比我最近看到的任何东西都更能引起我的共鸣。我觉得这是我新的……那是那种让我觉得“也许我该把它纹在身上”的话。当你考虑纹身时，说明它是认真的。那句话是：“希望是一种纪律（Hope is a discipline）”。我非常喜欢这句话。它是 Mariame Kaba 说的。

---

### (01:14:25) Jessica Hische

**English:**
The idea that we have to choose to create positivity, that it's like a choice, and that in order to dream of these things, you can actually create structure and discipline around it, and that it's not just something that is just inherent and comes, you have to actually have a practice around being hopeful and positive. I just really liked that as a concept because I feel that way just about navigating through life, that everything that we do is a choice and that we can choose to frame things one way or frame things another way. Understanding that you have power in that, I think, is really important, and so I just really loved that. Hope is a discipline.

**中文翻译:**
它的意思是，我们必须选择去创造积极性，这是一种选择。为了梦想这些美好的事物，你实际上可以围绕它建立结构和纪律。它不仅仅是某种天生就有的东西，你必须通过实践来保持希望和积极。我非常喜欢这个概念，因为我觉得生活就是这样：我们所做的一切都是一种选择，我们可以选择以这种方式或那种方式来解读事物。理解你拥有这种力量非常重要。所以我真的很喜欢这句话：希望是一种纪律。

---

### (01:15:14) Lenny Rachitsky

**English:**
I really love that. I love any quote that inspires you to not feel like a victim, and gives you agency, and reminds you that you have agency over.

**中文翻译:**
我非常喜欢这句话。我喜欢任何能激励你不要觉得自己是受害者、赋予你主动权并提醒你拥有掌控权的格言。

---

### (01:15:23) Jessica Hische

**English:**
Exactly. That's, I think, was the biggest thing for me is just... Because I feel very well-resourced in being able to deal with hardship because I'm always able to recontextualize and reframe. I think part of that is doing so much intuition justification, which is what we talked about, is walking through things, being like, "Why is this? Why does that happen, la, la, la?" When something bad happens, it's understanding why it happened and then understanding the paths that it can take forward and the different attitudes that you can bring to it that can help you come out of it.

**中文翻译:**
没错。我觉得这对我来说最重要的一点是……因为我觉得自己在应对困难方面很有办法，因为我总是能够重新审视和重新定义问题。我觉得这部分源于我做了很多“直觉合理化”的练习，就像我们讨论过的，去剖析事物：“为什么是这样？为什么会发生那种事？”当坏事发生时，去理解它为什么发生，然后理解未来的路径，以及你可以采取的不同态度，这些都能帮你走出来。

---

### (01:15:59) Lenny Rachitsky

**English:**
That's beautiful. Okay, final question. I know that you recently remodeled your home. It's quite stunning. You share photos of it online. You worked with this amazing architect to help make it as amazing as it is. As a designer, here's the question, how do you find the balance between trusting someone, their own perspective and design approach, versus pushing into a direction you think that it should go? How do you find a balance as a designer?

**中文翻译:**
太美了。好了，最后一个问题。我知道你最近重新装修了房子，非常漂亮，你在网上分享了照片。你和一位非常棒的建筑师合作完成了它。作为一个设计师，问题是：你如何在“信任对方的专业视角和设计方法”与“坚持你认为正确的方向”之间找到平衡？

---

### (01:16:28) Jessica Hische

**English:**
Well, I actually feel like it's quite easy for me to trust people to do their own thing, because as long as I go to them as being like, "I appreciate you and your vision and that's why I'm paying you," then the last thing that I want to do is micromanage them, because the reason why I'm paying them is because I don't have the bandwidth to do that myself. Because honestly, I'm one of those people that if I had nothing going on, if my job totally blew up or whatever, I would probably be one of those people that just specialize in a different thing every six months and would be like, "I'm going to build a house now from the ground up. I'm going to do this from now, whatever." I just feel very capable of doing anything that I want to do because I understand that I can find the resources for it.

**中文翻译:**
嗯，实际上我觉得信任别人去做他们擅长的事挺容易的。因为只要我去找他们时抱着“我欣赏你和你的愿景，这就是我付钱给你的原因”的态度，那么我最不想做的就是微观管理（Micromanage）他们。我付钱给他们就是因为我自己没有精力去做。老实说，如果我无事可做，或者我的工作彻底没了，我可能会成为那种每六个月就钻研一个新领域的人，比如“我现在要从头开始盖房子”。我觉得只要我想做，我就能做到，因为我知道如何寻找资源。

---

### (01:17:16) Jessica Hische

**English:**
When I hire people to help me do a thing, it's because there is this implicit trust in what they do and that that's why I want to work with them. With the house, I definitely had opinions about stuff. But in general, I'm just like, "Hey, this is your thing. You're the expert. What do you think? Let me give you the parameters and the things that we have to think about. Because you know more about wood resources, and you know more about the cabinet spacing, and whatever, you tell me what you think is going to work best based on all these things that I laid out for you." I found it to be quite easy. I only got really wigged out about a couple of different fine tune-y stuff.

**中文翻译:**
当我雇人帮我做事时，是因为我对他们的专业能力有种默契的信任，这就是我想和他们合作的原因。关于房子，我确实有自己的看法，但总的来说，我会说：“嘿，这是你的专业领域，你是专家。你怎么看？我给你提供参数和我们需要考虑的因素。因为你更了解木材资源，更了解橱柜间距，所以请根据我列出的这些要求，告诉我你认为最好的方案是什么。”我觉得这挺容易的，我只在极少数细节调整上感到过焦虑。

---

### (01:18:01) Lenny Rachitsky

**English:**
I imagine architects and designers are like, "Oh no, it's going to be a designer I'm working with. They have opinions." I'm glad it wasn't that bad.

**中文翻译:**
我能想象建筑师和设计师会想：“噢不，我要和一个设计师合作了，她肯定有很多意见。”很高兴情况没那么糟。

---

### (01:18:09) Jessica Hische

**English:**
I feel like my strength with the work that I do in general is just being incredibly decisive and understanding that there's 10 good answers to every one question. Some people are real maximalists about decision-making and need to look at every gray sofa that exists before they can choose the one gray sofa. Whereas I feel like I can look at 10 gray sofas and go, it feels like there's two or three categories of sofa here, and then within those categories, there's a couple of good options. Here's a brand that I recognize is known for being of high quality. That one's good enough. I can get to it really quickly, and I feel like not everybody can do that. And I think that that permeates through everything that I do in my life. It definitely is a huge part of the logo work, because you really can do anything when it comes to typography.

**中文翻译:**
我觉得我工作的强项在于我非常果断，并且明白每一个问题都有 10 个好的答案。有些人在做决定时是“完美主义者（Maximalists）”，在选一张灰色沙发之前必须看完世界上所有的灰色沙发。而我觉得我可以看 10 张灰色沙发，然后意识到这里大概有两三类沙发，每一类里都有几个不错的选择。然后选一个我知道质量好的品牌，那就足够好了。我可以很快做出决定，我觉得并不是每个人都能做到这一点。这种特质渗透到了我生活的方方面面。在标志设计中也是如此，因为在字体排印方面，你真的可以做任何尝试。

---

### (01:18:57) Jessica Hische

**English:**
It can go in 50 million directions. It's just about having someone tell you, "Yes, we could take this anywhere, but these are the valid paths. If we go down this path, this is the most intuitive and most correct way to do it that is closest and most accessible to us. We can noodle on it until kingdom come, but do we have to? This is good." I don't know. I feel like there's some weird knowledge around understanding that nothing is ever 100% perfect, and the most you can aspire and get to is 99.8 or whatever. That last 0.2%, you could spend your whole life trying to do that, or you could move on and do other things and understand that it's nearly perfect.

**中文翻译:**
它可以有五千万个方向。关键在于有人告诉你：“是的，我们可以往任何方向走，但这些是有效的路径。如果我们走这条路，这是最直观、最正确的方法。我们可以一直纠结下去，但有必要吗？这个已经很好了。”我不知道，这可能是一种奇怪的认知：明白没有任何东西是 100% 完美的，你最多能达到 99.8%。剩下的 0.2%，你可以花一辈子去追求，也可以选择放下，去干别的事，并接受它已经近乎完美了。

---

### (01:19:49) Lenny Rachitsky

**English:**
That is really good advice and a freeing piece of advice. Jessica, it's been an honor to work with you on this logo. I am really excited for people to see it, for it to be the new look of everything I'm doing. Two final questions. Where can folks find you online if they want to learn more and potentially work with you, and how can listeners be useful to you?

**中文翻译:**
这真是非常棒且让人释怀的建议。Jessica，能和你合作设计这个标志是我的荣幸。我非常期待大家看到它，期待它成为我所有工作的新形象。最后两个问题：如果大家想了解更多或与你合作，可以在哪里找到你？以及，听众们能为你做些什么？

---

### (01:20:07) Jessica Hische

**English:**
Oh, yeah. Of course. I have a website that I occasionally update. It is jessicahische.is/awesome. You'll notice I have a bunch of weird URLs on my website. That's a place to find me. Otherwise, I am on Instagram and Threads a lot. I was formerly a very active Twitter person, and now I'm not really there so much and I bop around with the Twitter clones, but I'm on Threads quite a bit. Instagram and Threads are good for social. Email, I'm easy, hello@jessicaHische.com. What your readers could do for me, I think it's the work that I do in terms of the logo refresh stuff. I feel like this audience is just totally my perfect audience for it because you guys are all a bunch of smart, awesome founders that want beautiful logos, but understand that sometimes you just got to get that first viable option out the door. Once you're ready, you come to me and I help you and it's great.

**中文翻译:**
噢，当然。我有一个偶尔更新的网站：jessicahische.is/awesome。你会发现我的网站有很多奇怪的 URL。那是找我的地方。此外，我经常上 Instagram 和 Threads。我以前在 Twitter 上很活跃，现在不怎么去了，虽然也会在各种 Twitter 替代品上转转，但我主要在 Threads 上。Instagram 和 Threads 是社交的好去处。邮件也很方便：hello@jessicaHische.com。至于听众能为我做什么，我觉得就是标志翻新这类工作。我觉得这个播客的听众简直是我的完美受众，因为你们都是聪明、优秀的创始人，想要漂亮的标志，但也明白有时候必须先推出第一个可行方案。等你准备好了，来找我，我会帮你，那会很棒。

---

### (01:21:12) Lenny Rachitsky

**English:**
A match made in heaven. Jessica, thank you so much for being here.

**中文翻译:**
简直是天作之合。Jessica，非常感谢你能来。

---

### (01:21:17) Jessica Hische

**English:**
Happy to be here. Great convo.

**中文翻译:**
很高兴来到这里，聊得很愉快。

---

### (01:21:19) Lenny Rachitsky

**English:**
So good. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
太棒了。再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。