# Jessica Livingston - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny’s Podcast featuring Jessica Livingston.

---

### [00:00:00] Lenny Rachitsky

**English:**
I want to start with a quote by someone you may know, Paul Graham, "Much of what's novel about YC is due to Jessica Livingston. If you don't know her, you don't understand YC."

**中文翻译:**
我想以一个你可能认识的人——保罗·格雷厄姆（Paul Graham）的一句话开始：“YC 的许多创新之处都归功于杰西卡·利文斯顿（Jessica Livingston）。如果你不了解她，你就不了解 YC。”

---

### [00:00:10] Jessica Livingston

**English:**
My three co-founders were deeply technical, but I would look at other things about founders. All these little social cues.

**中文翻译:**
我的三位联合创始人都有深厚的技术背景，但我会观察创始人的其他方面。所有这些细微的社交线索。

---

### [00:00:17] Lenny Rachitsky

**English:**
Your nickname was the Social Radar. Every interview, everyone always turned to you and they're like, "Jessica, what does their social radar say?"

**中文翻译:**
你的绰号是“社交雷达”。在每次面试中，大家总是转向你问：“杰西卡，你的社交雷达怎么说？”

---

### [00:00:24] Jessica Livingston

**English:**
I would look at, do the co-founders get along? Are these people committed? And if a founder would get defensive, that was always a bad sign.

**中文翻译:**
我会观察：联合创始人之间相处得好吗？这些人有决心吗？如果一个创始人表现出强烈的防卫心理，那通常是一个坏兆头。

---

### [00:00:33] Lenny Rachitsky

**English:**
Is there anything else along the Airbnb story that would be interesting to share?

**中文翻译:**
关于 Airbnb 的故事，还有什么有趣的细节可以分享吗？

---

### [00:00:36] Jessica Livingston

**English:**
He hated their idea, and Paul tried to get Brian and Joe and Nate to change it. But I remember specifically Joe brought out the cereal boxes, the Obama O's and Cap'n McCain's, and I just thought, oh my God, they're going to work hard to do whatever they can to make this company succeed.

**中文翻译:**
保罗当时讨厌他们的点子，他试图让布莱恩（Brian）、乔（Joe）和内特（Nate）改变主意。但我特别记得乔拿出了那些麦片盒——“奥巴马圈圈”（Obama O's）和“麦凯恩船长”（Cap'n McCain's），我当时就想：天哪，他们会竭尽全力做任何事来让这家公司成功。

---

### [00:00:52] Lenny Rachitsky

**English:**
You just talk a bit about this idea of just making shit happen, showing signs of being hustlers.

**中文翻译:**
你刚才谈到了这种“搞定一切”的想法，也就是展现出那种“拼命三郎”（hustlers）的迹象。

---

### [00:00:56] Jessica Livingston

**English:**
Do you sort of need that desperation. You have to burn the boat.

**中文翻译:**
你确实需要那种孤注一掷的劲头。你必须破釜沉舟。

---

### [00:01:03] Lenny Rachitsky

**English:**
Today, my guest is Jessica Livingston. Jessica is the co-founder of Y Combinator, the first and most famous startup accelerator, which since 2005 has funded over 5,000 companies, including over 200 unicorns now worth over a billion dollars, including companies like Airbnb, Stripe, DoorDash, Coinbase, Dropbox, Instacart, Reddit, the list goes on. Jessica is also the author of one of the bestselling books about startups, Founders at Work, and hosts the Social Radars Podcast. She lives in England with her husband, who you may know, and her two sons. In our conversation, we dive deep into Jessica's superpower of being the Social Radar. She got this nickname in the early days of YC because she can read people incredibly well. This becomes a huge unfair advantage when you're evaluating and investing in early stage startups and founders, but also becomes useful in every part of your life. There's actually a quiz that I'm going to link to in the show notes called Reading the Mind in the Eyes that I suggest you take to see how you do, and it'll give you a sense of how well you are at reading people.
(00:02:08):
Jessica got a perfect score, just as an example of her unique talents, reading people's emotions along with her superpower and tips on how you can develop your own social radar. We also talk about her fabulous podcast called The Social Radars, some wild early YC stories, including how the interview with the Airbnb founders actually went down, and so much more. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that, I bring you Jessica Livingston.
(00:02:45):
Jessica, thank you so much for being here and welcome to the podcast.

**中文翻译:**
今天的嘉宾是杰西卡·利文斯顿。杰西卡是 Y Combinator (YC) 的联合创始人，这是全球第一家也是最著名的创业加速器。自 2005 年以来，YC 已经资助了 5000 多家公司，其中包括 200 多家估值超过 10 亿美元的独角兽企业，如 Airbnb、Stripe、DoorDash、Coinbase、Dropbox、Instacart、Reddit 等等。杰西卡还是关于创业的畅销书《Founders at Work》（创办人志）的作者，并主持《The Social Radars》播客。她与丈夫（你可能认识他）以及两个儿子住在英国。在我们的谈话中，我们将深入探讨杰西卡的超级力量——“社交雷达”。她在 YC 早期获得这个绰号，是因为她极其擅长读懂人心。在评估和投资早期创业公司及创始人时，这成为了一种巨大的“不公平竞争优势”，而且在生活的方方面面都非常有用。我会在节目介绍中附上一个名为“眼神读心测试”（Reading the Mind in the Eyes）的链接，建议大家去测测看，这能让你了解自己读人的能力。
(00:02:08):
杰西卡在这个测试中得了满分，这足以证明她在解读他人情绪方面的独特天赋。我们将讨论她的超级力量，以及如何培养你自己的社交雷达。我们还会聊到她精彩的播客《The Social Radars》，一些 YC 早期的疯狂故事（包括 Airbnb 创始人的面试真相），以及更多内容。如果你喜欢这个播客，别忘了在应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对我们帮助巨大。下面，让我们欢迎杰西卡·利文斯顿。
(00:02:45):
杰西卡，非常感谢你能来，欢迎来到本播客。

---

### [00:02:50] Jessica Livingston

**English:**
Thanks, Lenny. I'm glad to be here.

**中文翻译:**
谢谢，莱尼。很高兴来到这里。

---

### [00:02:52] Lenny Rachitsky

**English:**
I want to start with a quote by someone you may know, Paul Graham. So he wrote, "A few months ago an article about Y Combinator said that early on it had been a one-man show. It's sadly common to read that sort of thing, but the problem with that description is not just that it's unfair, it's also misleading. Much of what's novel about YC is due to Jessica Livingston. If you don't know her, you don't understand YC." I'm hoping with this conversation we help a lot more people understand you. Kind of an implication of this quote that I wanted to ask you about is that there's an implication that you've never gotten the credit that you deserve for starting YC, for helping YC become what it's become. I'm just curious what that's been like for you.

**中文翻译:**
我想以一个你可能认识的人——保罗·格雷厄姆的一段话开始。他写道：“几个月前，一篇关于 Y Combinator 的文章说它早期是‘一个人的独角戏’。读到这类东西是很可悲且常见的，但这种描述的问题不仅在于它不公平，还在于它具有误导性。YC 的许多创新之处都归功于杰西卡·利文斯顿。如果你不了解她，你就不了解 YC。”我希望通过这次对话，能让更多人了解你。这句话隐含了一个意思，我想问问你：它暗示你从未因为创办 YC 并帮助它成就今日地位而获得应有的赞誉。我很想知道这对你来说是什么感觉。

---

### [00:03:41] Jessica Livingston

**English:**
It's sort of a hard question. It is true, I was one of the co-founders of Y Combinator, and yet I'm often sort of left out of news articles, Wikipedia people want to take my entry off of Wikipedia all the time. I'm not as notable and I'm sort of like, "Gosh, I'm a founder of Y Combinator, author of a best-selling book on startups. What does a girl have to do?" But it is what it is. It's the external views, and it doesn't matter to me. Do you know what I mean? People within YC know what I've done, the Y Combinator alumni know what I've done, my friends and family and people I respect in the Silicon Valley community know what I've done, most of them do. So that's fine.
(00:04:35):
But it is true, I've often been sort of erased, and in some cases it's annoying because it's a lot of people who have a certain narrative about Y Combinator that don't want me to exist, I'm maybe making that up a little bit, or the people that don't want me to be part of the narrative are the ones that think that Y Combinator, it's run by white men, only invests in white men. And gosh, if there was a woman on the founding team making choices of who to fund, that would undermine their narrative. So I think sometimes that's what happens too.

**中文翻译:**
这有点难回答。确实，我是 YC 的联合创始人之一，但我经常在新闻报道中被遗漏，维基百科上的人总想删掉我的词条。我好像不够“显著”，我有时会想：“天哪，我是 YC 的创始人，写过创业畅销书。一个女孩到底还要做到什么程度？”但事实就是这样。那是外界的看法，对我来说并不重要。你明白我的意思吗？YC 内部的人知道我做了什么，YC 的校友知道我做了什么，我的朋友、家人以及我在硅谷社区尊敬的人，大多数都知道。所以这没关系。
(00:04:35):
但确实，我经常被“抹去”。在某些情况下这挺烦人的，因为很多人对 YC 有一种特定的叙事，他们不希望我存在——也许我有点凭空猜测——或者那些不想让我出现在叙事中的人，是那些认为 YC 是由白人男性经营、只投资白人男性的人。天哪，如果创始团队中有一个女性在决定投资谁，那就会破坏他们的叙事。所以我认为有时情况就是这样。

---

### [00:05:15] Lenny Rachitsky

**English:**
Fascinating. Just a convenient story to tell sometimes.
(00:05:20):
This episode is brought to you by Enterpret. Enterpret unifies all of your customer interactions, from Gong calls to Zendesk tickets, to Twitter threads, to app store reviews, and makes it available for your product team. It's used by leading product orgs like Canva, Notion, Loom, Linear, and Descript to accurately integrate the voice of the customer into your product development process, helping you build best-in-class products.
(00:05:45):
What makes Enterpret special is its ability to build customer-specific adaptive AI models that provide the most granular and accurate categorization of all your customer feedback, and also connect customer feedback to revenue impact, to help product leaders confidently prioritize things that will actually move the needle for your business. If you want a custom model built for your organization so that you can automate your feedback loops and prioritize your roadmap with confidence, get in touch with the team at enterpret.com/Lenny. That's E-N-T-E-R-P-R-E-T dot com slash Lenny.

**中文翻译:**
很有意思。有时候这只是为了讲故事方便。
(00:05:20):
本集节目由 Enterpret 赞助。Enterpret 统一了你所有的客户互动——从 Gong 通话到 Zendesk 工单，从 Twitter 帖子到应用商店评论，并将其提供给你的产品团队。Canva、Notion、Loom、Linear 和 Descript 等领先的产品组织都在使用它，将客户的声音准确地整合到产品开发过程中，帮助你打造一流的产品。
(00:05:45):
Enterpret 的特别之处在于它能够构建针对特定客户的自适应 AI 模型，对所有客户反馈进行最细致、最准确的分类，并将客户反馈与收入影响联系起来，帮助产品领导者自信地确定真正能推动业务发展的优先级。如果你想为你的组织构建自定义模型，以便自动执行反馈循环并自信地规划路线图，请联系 enterpret.com/Lenny 团队。

---

### [00:06:24] Lenny Rachitsky

**English:**
This episode is brought to you by Anvil. Their document SDK helps product teams build and launch software for documents fast. Companies like Carta and Vouch Insurance use Anvil to accelerate the development of their document workflows. Getting to market fast is a top priority for product teams. And the last thing that you or your developers want is to build document workflows from scratch; it's time-consuming, expensive and distracts from core work. You could stitch together multiple tools and manage those integrations, or you can use an all-in-one document SDK. Most product managers will tell you, "Paperwork sucks." Anvil's document SDK helps teams get to market fast, incorporate your brand style and give you back time to focus on your company's core differentiated features.
(00:07:11):
For your users, paperwork often starts with an AI-powered web form styled and embedded in your application. From there, you can route data to your backend systems and to the correct fields in your PDFs via API. Complete the process with a white labeled e-signature. The best part about Anvil is the level of customization their SDK provides. Non-technical folks love Anvil's drag and drop builder, and developers love their flexible APIs and easy to understand documentation. Build documents software fast with Anvil. That's useanvil.com/Lenny to learn more or start a free trial. That's use A-N-V-I-L dot com slash Lenny.
(00:07:53):
So at YC, your nickname was the Social Radar. Your podcast is called The Social Radars. I haven't seen you talk too much about this skill anywhere else, and that's what I want to spend our time on together to better understand the skill that you've built of being this social radar. How does that sound?

**中文翻译:**
本集节目由 Anvil 赞助。他们的文档 SDK 帮助产品团队快速构建和发布文档软件。Carta 和 Vouch Insurance 等公司使用 Anvil 来加速其文档工作流的开发。快速进入市场是产品团队的首要任务。你或你的开发人员最不想做的就是从头开始构建文档工作流；这既耗时又昂贵，还会分散核心工作的注意力。你可以拼凑多个工具并管理这些集成，也可以使用一体化文档 SDK。大多数产品经理都会告诉你，“文书工作很烦人”。Anvil 的文档 SDK 帮助团队快速进入市场，融入你的品牌风格，让你有更多时间专注于公司的核心差异化功能。
(00:07:11):
对于你的用户来说，文书工作通常始于嵌入在应用程序中的 AI 驱动的网页表单。从那里，你可以通过 API 将数据路由到后端系统和 PDF 中的正确字段。通过白标电子签名完成整个过程。Anvil 最棒的地方在于其 SDK 提供的定制化程度。非技术人员喜欢 Anvil 的拖放式构建器，开发人员则喜欢其灵活的 API 和易于理解的文档。使用 Anvil 快速构建文档软件。访问 useanvil.com/Lenny 了解更多信息或开始免费试用。
(00:07:53):
在 YC，你的绰号是“社交雷达”。你的播客叫《The Social Radars》。我没见你在其他地方过多谈论这项技能，所以我想花点时间和你一起深入了解你作为“社交雷达”所建立的这项技能。你觉得怎么样？

---

### [00:08:13] Jessica Livingston

**English:**
I will try Lenny, I will try. I don't talk much about it because it's hard to talk about. I don't understand. It's hard to put into words exactly what it is about me, but it's true that my nickname at Y Combinator was the Social Radar. And I think it was because my three co-founders were deeply technical people, and I was not. But I would look at other things about founders. When we'd have these 10-minute interviews, I would look at, do the co-founders get along? Are these people committed? Do they really know about their product? Do they care? Are they going to quit their job? Or are they telling us that they are going to quit their job, but really aren't? All these little social cues that I'd try to pick up on.
(00:09:10):
And in a lot of cases, red flags about them that I'd add to the decision-making process. And so that's why they called me the Social Radar, and it just sort of stuck. And it's because I love people and the dynamics and understanding what's motivating people. I just love it and I love founder psychology, founders personalities. I am absolutely fascinated with it.

**中文翻译:**
我会努力的，莱尼。我不怎么谈论它是因为它很难描述。我也不太明白。很难用语言准确表达我身上的这种特质，但在 YC 我的绰号确实是“社交雷达”。我想这是因为我的三位联合创始人都是技术大牛，而我不是。但我会观察创始人的其他方面。当我们进行这些 10 分钟的面试时，我会看：联合创始人之间相处得好吗？这些人有决心吗？他们真的了解自己的产品吗？他们在乎吗？他们会辞职吗？还是他们只是口头上说要辞职，实际上却不会？我会尝试捕捉所有这些细微的社交线索。
(00:09:10):
在很多情况下，我会把发现的“危险信号”加入到决策过程中。这就是为什么他们叫我“社交雷达”，这个名字就这么传开了。这是因为我热爱观察人和人际动态，喜欢理解人们的动机。我非常热爱并痴迷于创始人心理学和创始人的个性。

---

### [00:09:38] Lenny Rachitsky

**English:**
I love it. Okay, so we're going to try to unpack as much as we can with the context that you're not exactly sure if you're able to articulate exactly how this power of yours works.

**中文翻译:**
太棒了。好，那我们就试着拆解一下，尽管你可能无法完全说清楚这种超能力是如何运作的。

---

### [00:09:46] Jessica Livingston

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:09:48] Lenny Rachitsky

**English:**
There's this line you wrote somewhere, and Paul's written this, and other people, that every interview that you all did early on at YC, everyone always turned to you and they're like, "Jessica, what do you think? What does their social radar say?" Can you just talk a bit about that role that you played in the early days of YC of kind of seeing that side of candidates?

**中文翻译:**
你在某处写过，保罗和其他人也写过：在 YC 早期，每次面试结束，大家总是转向你问：“杰西卡，你怎么看？你的社交雷达怎么说？”你能谈谈你在 YC 早期扮演的那个角色吗？就是观察候选人那一面的角色。

---

### [00:10:06] Jessica Livingston

**English:**
Well, in the early days, especially before I knew a lot, as much as I know now, about startups and founders, early on, I was learning a lot in the first few years. And in the first few years, it was just the four of us. So I would be in charge of going out telling people, "Wait here while we do the interview, come on in." I'd be in charge of the stopwatch that would time us. And I'd say, "Okay, our time's up." And it was very administrative, and I would observe. Paul, Robert and Trevor, my co-founders would be asking them all sorts of questions about their product and their technology and blah, blah, blah, blah, blah. I would occasionally ask questions, but I'd usually remain pretty silent. And so I don't think people even really noticed me. But I would be just watching them and sort of trying to observe as much as I could, not understanding sometimes even the technology that they were talking about. I let my co-founders do that.
(00:11:06):
And then after, we'd be talking, they'd look at me and they'd be like, "Should we fund them? Jessica, should we fund them?" And sometimes I could tell based on the conversation whether they thought that the technology was good or how they felt, and sometimes I'd say, "Absolutely we should." Or sometimes I'd say, "Guys, I'm a little nervous. Did you see how that founder interrupted the other founder and wouldn't let the other founder talk?" Because my three co-founders sometimes wouldn't notice this.
(00:11:39):
They'd be so caught up in the conversation they were having about the technology, especially Paul. Paul would get really into things. And sometimes I always tease Paul, because one of his defining qualities is that sometimes someone would have an idea that he'd get so excited about that by the end of the interview he'd be giving them ideas about how to grow their product and what they could become. And they'd sit there saying, "Yeah, yeah, that's a great idea." And then he'd say, "Fund them." And I'd say, "Whoa, whoa, whoa, Paul, you can't just fund this because you love the idea. Let's take a step back and let's look. Like these two founders are working at Google and they don't say they're going to quit. That's not good." And I'd point out these things that I had observed. But I mean, we always agreed. It was very rare that we wouldn't agree on funding something. We were usually on the same page.

**中文翻译:**
在早期，特别是在我对创业和创始人的了解还不如现在这么多的时候，我在头几年学到了很多。那时只有我们四个人。我会负责出去告诉大家：“面试时请在这里等候，请进。”我会负责计时用的秒表，然后说：“好了，时间到。”这非常行政化，而我则负责观察。保罗、罗伯特（Robert）和特雷弗（Trevor）——我的联合创始人——会问各种关于产品、技术之类的问题。我偶尔会提问，但通常保持沉默。所以我觉得人们甚至没注意到我。但我会一直盯着他们，尽可能多地观察，有时甚至听不懂他们谈论的技术。我让我的联合创始人们去处理那些。
(00:11:06):
面试结束后，我们会讨论，他们会看着我问：“我们该投他们吗？杰西卡，投吗？”有时我能根据谈话判断他们是否觉得技术不错，或者他们的感受，有时我会说：“绝对该投。”但有时我会说：“伙计们，我有点紧张。你们看到那个创始人是怎么打断另一个创始人，不让对方说话的吗？”因为我的三位联合创始人有时注意不到这些。
(00:11:39):
他们太沉浸在关于技术的对话中了，尤其是保罗。保罗会非常投入。我经常开保罗的玩笑，因为他的一个典型特质是，有时有人提出一个点子，他会兴奋到面试结束时已经在给他们出主意，告诉他们如何发展产品、未来会变成什么样。那些人坐在那儿说：“对，对，好主意。”然后保罗会说：“投他们。”我会说：“喔，喔，喔，保罗，你不能只因为喜欢这个点子就投。让我们退一步看看。比如这两个创始人在谷歌工作，他们没说要辞职。这可不好。”我会指出我观察到的这些事情。不过，我们总能达成一致。我们很少在是否投资某件事上产生分歧，通常意见是一致的。

---

### [00:12:33] Lenny Rachitsky

**English:**
I see. It's interesting that you talk about these behaviors, co-founders interrupting each other, or being kind of aggressive here and there. Some people believe that's okay for founders to be like this. A lot of successful founders, Elon, for example, Steve Jobs, who are kind of assholes a lot of times, I imagine, and I've read part of the reason you thought about just the type of person is you're trying to build a specific culture in the early days of YC and you're going to be around these people. So maybe can you talk a bit about just why those elements were important to you and why'd you look for those?

**中文翻译:**
我明白了。你谈到这些行为很有趣，比如联合创始人互相打断，或者表现得有些咄咄逼人。有些人认为创始人这样没问题。很多成功的创始人，比如埃隆（Elon）或者史蒂夫·乔布斯（Steve Jobs），我猜他们很多时候都挺“混蛋”的。我读到过，你考虑人的类型的部分原因是你想在 YC 早期建立一种特定的文化，而且你会经常和这些人在一起。所以，你能谈谈为什么这些因素对你很重要，以及你为什么要寻找这些特质吗？

---

### [00:13:08] Jessica Livingston

**English:**
I've definitely heard that Steve Jobs could be an. I've heard stories. But I think I would've funded him because he's so incredible and he was so smart and so interested in the product and knew... I'm very persuaded by people who know what they're talking about and love their product and are domain experts. But I did consciously, especially early on, less so later on, early on, I did sometimes tend to say, "I really think this person's an asshole, I do not want to fund them." And we often wouldn't. And very early on when we were just funding 10, 20, 30 startups a batch, sometimes I have been known to say, "I don't know if I can have dinner with them every week." It was that point. And I don't think we've ever regretted any of those. It didn't happen all the time, that was rare. But life's too short, and I wanted to be able to work with these founders.
(00:14:16):
And as it turns out, it was sort of important early on in weeding out explicit assholes because that was the basis of our Y Combinator community, which is now thousands of founders. Now, of course, all the founders aren't all running their company anymore, but I would say most all of the founders bring something useful and valuable to the table. So if you ask a question on Bookface, on our forum for founders, someone is going to be there to help you. And it's amazing. And that all started very early on, there was this culture of older batch mates helping newer ones, and this pay-it-forward mentality where everyone helped one another and rooted for one another and made introductions for each other. And I think it's a big part of our Y Combinator community now.

**中文翻译:**
我确实听说过史蒂夫·乔布斯可能挺难相处的。我听过那些故事。但我认为我还是会投他，因为他太出色了，非常聪明，对产品充满热情，而且非常懂行……我很容易被那些知道自己在说什么、热爱产品且是领域专家的人说服。但在早期（后期少一些），我确实会有意识地倾向于说：“我真的觉得这个人是个混蛋，我不想投他们。”我们通常也就真的不投。在非常早期，当我们每批只资助 10、20、30 家初创公司时，我有时会说：“我不知道我能不能每周都跟他们一起吃晚饭。”当时就是那种程度。我不认为我们后悔过任何这类决定。这种情况并不经常发生，很罕见。但人生苦短，我想和这些创始人愉快地合作。
(00:14:16):
事实证明，早期剔除明显的混蛋是很重要的，因为那是我们 YC 社区的基础，现在这个社区已经有数千名创始人了。当然，现在并不是所有创始人都在经营公司，但我敢说，几乎所有创始人都带来了有用且有价值的东西。如果你在 Bookface（我们的创始人论坛）上提问，总会有人在那儿帮你。这太神奇了。这一切都始于非常早期，那种老一批学员帮助新人的文化，这种“薪火相传”（pay-it-forward）的心态，每个人都互相帮助、互相支持、互相引荐。我认为这是现在 YC 社区的重要组成部分。

---

### [00:15:12] Lenny Rachitsky

**English:**
So I wrote down a few of the things that you mentioned you look for, and you looked for in the early days. So let me just share a few of them and let's spend a little more time here. So you looked for, did the founders get along? Are they committed to the idea? Are they ready to quit their job? Are there any red flags? So is there anything else that you remember you spent a lot of time thinking about or looking for then or even now?

**中文翻译:**
我记下了你提到的几点你早期寻找的特质。让我分享其中几个，我们再深入聊聊。你寻找的是：联合创始人相处得好吗？他们对这个点子有决心吗？他们准备好辞职了吗？有什么危险信号吗？除此之外，你还记得当时或现在你会花很多时间思考或寻找的其他特质吗？

---

### [00:15:36] Jessica Livingston

**English:**
There's looking for in the application and then there's looking for in the interview, and now we have software that looks for all of the red flags in the application that I used to do by hand. In the application, I'd look for just weird things, like was there a huge gap in the equity allocation? Did one founder have 99% and one founder have 1%? That's weird. I'd want to dig in on that. That doesn't feel right. Are they going to quit their job? Are they going to move to Silicon Valley? What are their current shareholders? Is like 90% of their company already owned by someone else? There all these weird things that we like to just flag. And we wouldn't necessarily not fund someone because of them, but it's just more data. So that was in the application that I'd look through all of those.
(00:16:33):
But in the interview I definitely was sort of, one thing I remember I would always look for was, when you'd have a conversation with us, a lot of times, Paul especially, but Robert and Trevor, would really be getting right into the idea and questioning you, and how do you know this? And what about this? And if a founder would get defensive, that was always a bad sign, always a bad sign. The best founders would say, "Gosh, I have thought about it and here's what I figured out." Or, they just have this almost a tennis match and a conversation rather than closing up and feeling like, oh, this person's interrogating me. You could just sort of, the open-mindedness, the flexible-mindedness of people was really important. I'd get really excited about domain expertise. Like my co-founders, we all loved that. If someone was fixing their own problem in a broken industry, we loved that.
(00:17:39):
Definitely, I'd look for co-founder relationships. And again, I'm not saying I was always right, but you could tell if... One founder, I'll give a story, one founder, once we asked a question and one person started to respond and the other founder put his arm in front of him and said, "I'll answer that question." And it was just so weird that he wouldn't let his co-founder speak. We'd have situations where we'd call people like hackers in a cage, where it's kind of obvious there'd be a business founder, business person, who had clearly convinced a programmer to join the team. They were given, the programmer was given, very little equity and just we called them programmers in a cage, like hackers in a cage. And sometimes that works out, I'm not saying it doesn't. But I'd always try to observe, okay, does this hacker in a cage have any say in the company, the direction of the product? That sort of thing. Because the programmer needs to have opinions.

**中文翻译:**
寻找特质分为申请书和面试两个阶段。现在我们有软件来寻找申请书中的危险信号，以前这些都是我手工完成的。在申请书中，我会寻找一些奇怪的地方，比如股权分配是否存在巨大差距？一个创始人占 99%，另一个占 1%？这很奇怪。我会想深入挖掘一下，这感觉不对劲。他们会辞职吗？他们会搬到硅谷吗？目前的股东是谁？公司 90% 的股份是否已经被别人持有了？所有这些奇怪的事情我们都会标记出来。我们不一定会因此就不投某人，但这只是更多的数据。这是我在申请书中会查看的内容。
(00:16:33):
但在面试中，我记得我总是会观察的一点是：当你与我们交谈时，很多时候，尤其是保罗，还有罗伯特和特雷弗，会直接切入点子并质问你：你怎么知道这个？那个怎么办？如果一个创始人变得很有防卫心，那总是一个坏兆头，绝对是坏兆头。最好的创始人会说：“天哪，我想过这个问题，这是我的发现。”或者，他们会像打网球一样进行对话，而不是封闭起来，觉得“哦，这个人在审问我”。那种开放的心态、灵活的思维非常重要。我对“领域专业知识”非常兴奋。就像我的联合创始人一样，我们都喜欢这一点。如果有人正在解决一个破败行业中他们自己遇到的问题，我们非常喜欢。
(00:17:39):
当然，我还会观察联合创始人的关系。我不是说我总是对的，但你能看出来……我讲个故事，有一次我们问了一个问题，其中一个人刚要回答，另一个创始人就把胳膊挡在他面前说：“我来回答这个问题。”他不让他的联合创始人说话，这太奇怪了。我们还会遇到一种情况，我们称之为“笼子里的黑客”，很明显是一个商务背景的创始人说服了一个程序员加入团队。程序员只拿到了极少的股权，我们称之为“笼子里的程序员”或“笼子里的黑客”。有时这也能成功，我不是说不行。但我总是尝试观察：这个“笼子里的黑客”在公司、在产品方向上有发言权吗？诸如此类。因为程序员需要有自己的见解。

---

### [00:18:50] Lenny Rachitsky

**English:**
It's so funny. I love this metaphor. And I totally get what you mean. I want to unpack a couple of these, because this is exactly where I was hoping we'd go. So this idea of looking for defensiveness and being open to change and being flexible, why do you think that was so important to successful founders? Why did you look for that? Why was that a predictor of success?

**中文翻译:**
太有趣了。我喜欢这个比喻。我完全明白你的意思。我想拆解其中几点，因为这正是我希望深入探讨的方向。关于寻找“防卫心”以及观察是否“乐于改变”和“灵活”，你为什么认为这对成功的创始人如此重要？你为什么要寻找这些？为什么这是成功的预测指标？

---

### [00:19:10] Jessica Livingston

**English:**
Several things. First of all, being defensive is really bad, if you're a startup founder, because you're always going to get people who question you. And it's your job to educate them, if it's a new area, you're doing something presumably pretty new, you're always going to have people who question it or say, "That product's already out there, why is yours better?" You have to educate them. You don't want to be defensive about it. Also, a lot of times, the first idea isn't bang right on, the right idea, and you have to be open-minded and maybe adjust it in a certain direction. The famous PayPal story, how it started off being the PalmPilot, or money transfer. And money transfer between the PalmPilots or whatever. And then all the customers were using a janky version on the web, and they were begging for this to be on the web. And finally, the founder said, "Oh, I see what most people want this for." You have to be open-minded to see what direction really is what your users want. And so if you find someone is defensive, usually they're not open-minded.
(00:20:26):
The other thing is that the best founders will want to learn from other people and listen to other people. You talk to the Collison brothers and say something, they ask you a question, they're listening to your answer. So many founders think, oh, I can't learn from anyone. But the best founders are always listening and having spirited debates about things. I mean, that's part of the process. And so I think when someone's defensive, it's just a bad sign. So I would look for that.
(00:21:01):
I loved when I'd find someone sort of showcase that they'd make something happen no matter what; they're scrappy, they're hustlers. I remember... Can I tell the story about the Airbnb interview?

**中文翻译:**
有几点原因。首先，如果你是创业者，防卫心强是非常糟糕的，因为总会有人质疑你。你的工作是教育他们，如果是一个新领域，你做的事情大概率很新颖，总会有人质疑或说：“那个产品已经有了，为什么你的更好？”你必须教育他们，而不是表现出防卫心。此外，很多时候，第一个点子并不完全正确，你必须保持开放的心态，也许需要调整方向。著名的 PayPal 故事，它最初是做 PalmPilot 上的货币转账。然后所有客户都在使用一个简陋的网页版，并恳求把它放在网上。最后创始人说：“哦，我明白大多数人想要什么了。”你必须保持开放，才能看到用户真正想要的方向。所以如果你发现某人防卫心强，通常他们并不开放。
(00:20:26):
另一件事是，最好的创始人会想向他人学习并倾听他人的意见。你和科里森兄弟（Collison brothers，Stripe 创始人）交谈，你说点什么，他们会问你问题，并倾听你的回答。很多创始人认为：“哦，我不需要向任何人学习。”但最好的创始人总是在倾听，并进行激烈的辩论。这是过程的一部分。所以我认为当某人防卫心强时，这就是个坏兆头。所以我会观察这一点。
(00:21:01):
我喜欢看到有人展示出无论如何都要把事情办成的劲头；他们很有韧性，是“拼命三郎”。我记得……我可以讲讲 Airbnb 面试的故事吗？

---

### [00:21:17] Lenny Rachitsky

**English:**
Please.

**中文翻译:**
请讲。

---

### [00:21:17] Jessica Livingston

**English:**
Okay, because that was definitely one I'll never forget. That was one that was clear the founders were really good. The market had just crashed basically with all the banks going out of business and everything. And so we were only funding startups that we felt had really scrappy founders and could be cockroaches, meaning could live off of very little amounts of money, or could charge customers and make money. And we didn't fund that many people in that winter '09 batch. So we're being very strict with ourselves, very disciplined about things. And the Airbnb guys came in, and I just remember they had a contagious amount of energy. They just had an energy about them the way that they talked about their product, which was crazy at the time, staying in someone's bed or airbed. In fact, it's a famous part of the story, we hated their idea and Paul tried to get Brian and Joe and Nate to change it. So we didn't even like the idea. But I remember specifically they brought, at the end, Joe brought out these, the cereal boxes, the Obama O's and Cap'n Crunch's or Cap'n McCain's or whatever.

**中文翻译:**
好，因为那绝对是我永远不会忘记的一次。那次很明显创始人非常优秀。当时市场刚刚崩溃，银行纷纷倒闭。所以我们只资助那些我们认为创始人非常有韧性、能像“蟑螂”一样生存的初创公司，意思是能靠极少的钱活下去，或者能向客户收费赚钱。在 2009 年冬季那一批，我们没投多少人。我们对自己非常严格，非常有纪律。Airbnb 的那几个人进来时，我记得他们身上有一种极具感染力的能量。他们谈论产品的方式充满活力，尽管在当时看来，住在别人的床上或气垫床上简直疯了。事实上，这是故事中著名的一部分：我们讨厌他们的点子，保罗试图让布莱恩、乔和内特改变主意。我们甚至不喜欢那个点子。但我特别记得，在最后，乔拿出了这些麦片盒——“奥巴马圈圈”和“麦凯恩船长”之类的。

---

### [00:22:33] Lenny Rachitsky

**English:**
Cap'n McCain's, yeah.

**中文翻译:**
麦凯恩船长，是的。

---

### [00:22:34] Jessica Livingston

**English:**
Yeah, Cap'n McCain's. They were saying that they went to some Costco or something and bought off-brand Cheerios and off-brand Cap'n Crunch's, took them out of the box, put them in this new box, glue-gunned it shut. And I just thought, oh my God, these guys are really going to great lengths for this. And for some reason, it was silly, but it really appealed to me. They're going to work hard to do whatever they can to make this company succeed. And even though we were skeptical about the idea, I think we definitely made the right bet on the founders, and it was just very clear in that interview.

**中文翻译:**
对，麦凯恩船长。他们说他们去 Costco 之类的地方买了廉价品牌的 Cheerios 和 Cap'n Crunch，把它们从盒子里拿出来，装进这个新盒子里，然后用热熔胶枪封好。我当时就想：天哪，这些家伙为了这个真的拼了。出于某种原因，虽然这很傻，但真的很吸引我。他们会努力做任何事来让公司成功。尽管我们对点子持怀疑态度，但我认为我们在创始人身上下对了赌注，在那次面试中这一点非常清晰。

---

### [00:23:17] Lenny Rachitsky

**English:**
I'm so happy you shared that story, I was definitely going to ask about it. It's so funny because I've heard that story at least a hundred times working at Airbnb, they tell the beginning of Airbnb every chance they get at every all-hands. It's like a recurring theme. And it's great to hear that basically it went exactly the way they describe. Oftentimes, there's a myth around what happened, but that's exactly how they describe it.

**中文翻译:**
我很高兴你分享了这个故事，我本来肯定要问的。太有趣了，因为我在 Airbnb 工作时听过这个故事至少一百遍，他们在每次全员大会上都会找机会讲 Airbnb 的起源。这就像一个反复出现的主题。很高兴听到事情基本上就是按照他们描述的那样发生的。通常，发生的事情会有很多传闻，但他们的描述完全一致。

---

### [00:23:41] Jessica Livingston

**English:**
No, it was definitely a whole crazy story and how Paul called them to accept them, and they were on the 280 or something or the 101 and the reception went down. And so he didn't hear if they were accepted or not. Did he tell that part?

**中文翻译:**
不，这绝对是一个疯狂的故事。保罗打电话通知录取他们时，他们正在 280 公路或 101 公路上，信号断了。所以他没听清到底有没有被录取。他讲过那部分吗？

---

### [00:23:58] Lenny Rachitsky

**English:**
No, I haven't heard that part.

**中文翻译:**
没，我没听过那部分。

---

### [00:23:58] Jessica Livingston

**English:**
Oh yeah, that's part of the story. And they had to keep driving to get to talk to Paul again and find out that they were accepted. Oh, yeah. It was just a crazy interview.

**中文翻译:**
噢是的，那是故事的一部分。他们不得不继续开车，直到能再次和保罗通话，才发现自己被录取了。噢，是的。那真是一次疯狂的面试。

---

### [00:24:09] Lenny Rachitsky

**English:**
The element of the story I'm also curious about is, the way Joe tells it, is he had the box in his backpack. And as they were walking out, Paul or you is like, "Hey, what's that? What's that cereal box doing there?" Is that how it went, or is it more like, "Hey, we have this cereal thing."?

**中文翻译:**
我对这个故事的一个细节也很好奇：按照乔的说法，他把盒子放在背包里。当他们正要走出去时，保罗或者你问：“嘿，那是什么？那个麦片盒在那儿干嘛？”事情是这样发生的吗？还是他们主动说：“嘿，我们做了这个麦片的东西。”？

---

### [00:24:24] Jessica Livingston

**English:**
I don't think Paul and I looked in his backpack and asked. I think there was definitely some pressure on Joe not to show us the cereal boxes. I think Nate was really down on that, especially. And I think they were walking out the door and they're like, "Hey, we just brought you a little something." I think Joe did pull it out, and we had an extra minute or so around the cereal boxes. That's how I heard about the glue gun story and everything. But I think Joe had been reluctant, but he did it at the end and I think it was a good call.

**中文翻译:**
我不认为保罗和我看了他的背包并提问。我想乔当时肯定面临着不要给我们看麦片盒的压力。我觉得内特（Nate）尤其反对这么做。我想当他们正要出门时，他们说：“嘿，我们给你们带了点小东西。”我想乔确实把它拿出来了，我们围绕麦片盒多聊了一分钟左右。我就是在那时听到热熔胶枪的故事之类的。我想乔之前一直很犹豫，但他最后还是做了，我认为这是一个明智的决定。

---

### [00:25:00] Lenny Rachitsky

**English:**
That's so funny. And after that meeting, what was that conversation like between you and Paul? Was it just like everyone's like, "We definitely got to do this."? Or was it like you being like, "Hey, these guys are really interesting."?

**中文翻译:**
太逗了。那次会面后，你和保罗之间的对话是怎样的？是大家都觉得“我们一定要投这个”？还是你觉得“嘿，这些家伙真的很有趣”？

---

### [00:25:10] Jessica Livingston

**English:**
No, I think we all liked them. We all liked them. But I remember saying, "We have got to..." I just remember being like, "We've got to fund these guys. I don't know about the idea. Maybe they'll change their idea, who knows? But they seem really great." Again, the energy level and the passion with which they spoke about their experience hosting, because they'd been around struggling, but had been a company with an idea for a little while before they applied to YC. We were there basically their Hail Mary, their last resort for them. And so they could tell us about their story about how they hosted the people at a conference, and there was definitely some magic to it, which was convincing.

**中文翻译:**
不，我想我们都喜欢他们。但我记得我说：“我们必须……”我只记得当时想：“我们必须资助这些家伙。我不确定那个点子行不行，也许他们会改主意，谁知道呢？但他们看起来真的很棒。”再次强调，是那种能量水平和他们谈论托管经历时的激情，因为他们在申请 YC 之前已经挣扎了一段时间，带着这个点子做了一阵子。我们基本上是他们的“孤注一掷”，是最后的希望。所以他们告诉我们关于在会议期间接待客人的故事，那里面确实有一种魔力，非常有说服力。

---

### [00:25:57] Lenny Rachitsky

**English:**
Is there anything else along the Airbnb story that would be interesting to share while we're on that topic?

**中文翻译:**
既然聊到这个话题，关于 Airbnb 的故事还有什么有趣的可以分享吗？

---

### [00:26:01] Jessica Livingston

**English:**
I mean, the only interesting thing as it relates to being the social radar is that there were just some interviews that I remember because I just thought, this is great. These founders are so good. I'm totally convinced. What they're working on might not work, but I feel like it's so worth the bet based on these founders. And that happened. There were definitely a couple other of our most successful companies that I clearly felt that way about. You just feel like they know what they're talking about, they thought about the problem. They're not solving this problem because it's sort of the problem du jour or fun and exciting. Some are very unsexy problems like when Parker Conrad applied with Zenefits, unsexy HR stuff, benefits stuff. But he knew how broken it was and was trying to fix it. And I love stories like that. There was one story in terms of... The one time I did sort of persuade the rest of the group to fund someone was, do you know the company GOAT, the sneaker?

**中文翻译:**
我想说，唯一与“社交雷达”相关的趣事是，有些面试我记忆犹新，因为我当时想：这太棒了，这些创始人太优秀了，我完全被说服了。他们正在做的东西可能行不通，但我觉得基于这些创始人，这非常值得一赌。这种情况确实发生过。对于我们其他几家最成功的公司，我显然也有这种感觉。你就是觉得他们知道自己在说什么，他们思考过这个问题。他们解决这个问题不是因为它是当下的热门话题或者好玩刺激。有些是非常“不性感”的问题，比如帕克·康拉德（Parker Conrad）带着 Zenefits 申请时，那是枯燥的 HR 和福利事务。但他知道这有多糟糕，并试图修复它。我喜欢那样的故事。还有一个故事……有一次我确实说服了其他人去资助某人，你知道 GOAT 这家球鞋公司吗？

---

### [00:27:13] Lenny Rachitsky

**English:**
Absolutely.

**中文翻译:**
当然知道。

---

### [00:27:13] Jessica Livingston

**English:**
Okay. When Eddie and Daishin applied, they were not doing the sneaker company, they were doing this group sort of book-a-group-dinner at a restaurant with people you don't know as a way to meet new people. And for some reason, I loved the idea because I thought maybe it could be a secret dating, like a Trojan Horse for a dating sort of site. But I really loved the two founders. And one of the reasons, again, they had this passion about their idea, but they had had this cream puff company before that they had run, and they just told these stories about how hard it was and all this stuff. And I, for some reason, just thought, these are hustlers. These guys are scrappy. They're going to make this succeed. And they didn't make that company succeed, but they pivoted and made GOAT succeed and it's doing really, really well. And I remember that one I definitely had to convince... I mean, not that Paul, Robert and Trevor didn't like them, but I think they really didn't think the idea was that great or just sort of were meh. I was like, "We have to fund them."

**中文翻译:**
好。当埃迪（Eddie）和戴信（Daishin）申请时，他们做的不是球鞋公司，而是那种预订餐厅团体晚餐，和陌生人一起吃饭来结识新朋友。出于某种原因，我喜欢这个点子，因为我觉得它可能是一个秘密约会网站，就像约会网站的“特洛伊木马”。但我真的很喜欢这两个创始人。原因之一还是那种激情，而且他们之前经营过一家泡芙公司，他们讲述了那有多难以及所有的经历。出于某种原因，我就是觉得：这些人是“拼命三郎”，很有韧性，他们会让这件事成功的。他们没让那家公司成功，但他们转型做了 GOAT 并大获成功，现在发展得非常好。我记得那次我肯定得说服其他人……我的意思是，不是说保罗、罗伯特和特雷弗不喜欢他们，但我觉得他们真的认为那个点子不怎么样，或者只是觉得一般。我说：“我们必须投他们。”

---

### [00:28:24] Lenny Rachitsky

**English:**
I love sharing these stories. If you have more to share, please keep throwing them out there.
(00:28:27):
So a few things I've noted so far, of things that you look for, and I think it's important to note this is very early stage evaluation where the founder and the team is, it's incredibly important, because the idea often shifts.

**中文翻译:**
我喜欢听这些故事。如果你还有更多，请继续分享。
(00:28:27):
到目前为止，我记下了几点你寻找的特质。我认为重要的一点是，这是非常早期的评估，创始人和团队至关重要，因为点子经常会变。

---

### [00:28:42] Jessica Livingston

**English:**
Oh, yeah. This is as early as it gets, Lenny.

**中文翻译:**
噢是的。莱尼，这已经是早得不能再早的阶段了。

---

### [00:28:43] Lenny Rachitsky

**English:**
Yeah. Oftentimes, just an idea, I imagine.

**中文翻译:**
是的。我猜很多时候只有一个点子。

---

### [00:28:47] Jessica Livingston

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:28:48] Lenny Rachitsky

**English:**
So a few things, so far, things that you found to be really valuable to look for. One is this idea of just making shit happen, showing signs of being hustlers, just getting shit done, Obama O's, things like that. And then I think along the same lines, just passion for this idea and just like almost charisma. Is that how you think about it? Or is it just like...

**中文翻译:**
所以到目前为止，你发现非常有价值的几点是：第一，那种“搞定一切”的想法，展现出“拼命三郎”的迹象，就是把事情办成，比如奥巴马圈圈之类的。然后我觉得类似的一点是，对点子的热情，甚至近乎一种魅力。你是这么想的吗？还是说……

---

### [00:29:11] Jessica Livingston

**English:**
I hate using the word charisma because there are a lot of charismatic people who are full of baloney, and are just doing a startup because it's a cool thing to do now. And I wouldn't want anyone to get fooled by charisma. There has to be some substance behind that charisma. Of course, we all love talking to more charismatic people than less, and I've certainly talked to my fair share of totally uncharismatic people, but sometimes they're really good founders too. If they know what they're doing and care about the user and are fixing a problem that they have a deep connection to. So I don't want to say someone who's charismatic, but it definitely helps because, as you know, as a founder, you have to do a lot of sales and you have to recruit people and you have to convince investors to fund you and you have to convince users to use your product and all of this stuff. So it does help being charismatic, definitely.

**中文翻译:**
我讨厌用“魅力”（charisma）这个词，因为有很多充满魅力的人其实满嘴胡话，他们创业只是因为现在这很酷。我不希望任何人被魅力所迷惑。魅力背后必须有实质内容。当然，比起没魅力的人，我们都更喜欢和有魅力的人交谈，我也确实见过不少完全没魅力的人，但有时他们也是非常优秀的创始人。如果他们知道自己在做什么，关心用户，并且正在解决一个与他们有深厚联系的问题。所以我不想说“有魅力的人”，但它确实有帮助，因为如你所知，作为创始人，你必须做大量的销售工作，必须招聘人才，必须说服投资者投你，必须说服用户使用你的产品等等。所以，有魅力肯定是有帮助的。

---

### [00:30:19] Lenny Rachitsky

**English:**
Okay. So there's being super hustler, making shit happen. Domain expertise, something you've mentioned a few times. Just like having deep domain expertise in an area, and I think that's probably where they probably don't pivot oftentimes, where they've actually have experience in that specific problem.

**中文翻译:**
好。所以有“超级拼命三郎”，搞定一切。还有你提到过几次的“领域专业知识”。就是在某个领域拥有深厚的专业知识，我想这可能就是他们通常不会轻易转型的地方，因为他们在那项特定问题上确实有经验。

---

### [00:30:33] Jessica Livingston

**English:**
They might pivot a little bit, they might pivot a little in terms of the actual solution. They might be trying to solve a problem and the first attempt doesn't really work. I haven't mentioned earnestness though.

**中文翻译:**
他们可能会稍微转型，在实际解决方案上做些调整。他们可能在尝试解决一个问题，但第一次尝试并不奏效。不过，我还没提到“真诚”（earnestness）。

---

### [00:30:45] Lenny Rachitsky

**English:**
Oh, do tell.

**中文翻译:**
噢，请讲。

---

### [00:30:47] Jessica Livingston

**English:**
Earnestness is one of the most important because earnest, sort of to me, is bucketed with authenticity. And to be a successful startup founder, you have to care so much about the problem you're trying to solve, the users you're serving and being earnest about it is so key to success. There are so many wannabe founders, so many people doing it because it's cool or they think this idea is cool, but they don't really, deep down, have what it takes. And I think we always try to fund earnest people.

**中文翻译:**
真诚是最重要的特质之一，因为对我来说，真诚与“真实性”（authenticity）是归为一类的。要成为一名成功的创业者，你必须非常关心你试图解决的问题和你服务的用户，而对此保持真诚是成功的关键。有太多的“投机型创始人”，很多人做这件事只是因为觉得酷，或者觉得点子很酷，但内心深处并不具备成功的素质。我认为我们总是倾向于资助真诚的人。

---

### [00:31:30] Lenny Rachitsky

**English:**
What does earnest look like in practice? And how does that come across?

**中文翻译:**
在实践中，“真诚”是什么样子的？它是如何表现出来的？

---

### [00:31:33] Jessica Livingston

**English:**
I think it means being sort of humble about... And if you get asked a question in the interview and you don't know the answer, they say, "I don't know the answer to that. I'd have to think about it." Or, "I don't know the answer. I've given it some thought and here's what I have come up with." And they're just honest about things, and they're not trying to do the whole smoke and mirrors thing, which we've definitely gotten people like that, that avoid the question or are doing it for the wrong reasons.
(00:32:08):
I remember there was one group that were 45-year-old men and they were building an app for teenagers in fashion. And I remember just thinking, we were asking them, "Why have you chosen teenagers in fashion?" And it was so clear that they thought they could make easy money, and it wasn't because they cared about fashion. It wasn't because, "Oh, I have a daughter who's really into fashion and I've seen this need." It was just like, they made up the idea. And that is not earnest, that is not authentic to me.

**中文翻译:**
我认为这意味着保持谦逊……如果在面试中被问到一个问题而你不知道答案，他们会说：“我不知道那个问题的答案，我得思考一下。”或者：“我不知道答案，但我思考过，这是我的想法。”他们对事情很诚实，不会玩那种“虚张声势”（smoke and mirrors）的把戏。我们确实遇到过那样的人，他们回避问题，或者出于错误的动机在创业。
(00:32:08):
我记得有一组人是 45 岁的男性，他们正在为时尚界的青少年开发一款应用。我记得当时在想，我们问他们：“为什么选择时尚界的青少年？”很明显，他们认为这能赚快钱，而不是因为他们关心时尚。不是因为“哦，我有一个非常喜欢时尚的女儿，我看到了这个需求”。他们只是编造了一个点子。对我来说，那不叫真诚，也不叫真实。

---

### [00:32:47] Lenny Rachitsky

**English:**
You talked about it, so there's this earnestness you look for, also not being defensive. There's this also spectrum of confidence and people believing in what they're doing. Do you have any thoughts on just how to find that? What does that look like when they're too defensive versus they're just confident and then they know what they're talking about?

**中文翻译:**
你谈到了真诚，还有不具防卫心。此外还有“自信”和“相信自己所做的事”这一维度。关于如何发现这一点，你有什么想法吗？当他们防卫心过重，与他们仅仅是自信且知道自己在说什么时，看起来有什么不同？

---

### [00:33:03] Jessica Livingston

**English:**
Confidence is good. You definitely want confidence. It's hard to... I think you can see it when you experience it. Like someone who's confident in answering your questions but isn't defensive, there's definitely a difference. And I don't know, this is why I'm saying it's sort of hard to articulate these things, but confidence means you can say, "I've thought about that and I don't know the answer." That's confidence. And they'll say, "But here's what I do to try to figure it out. Here are my plans to address that." Confidence, I should have put that upfront because that's very important, especially when it comes to fundraising, you cannot go into an investor meeting lacking confidence. You can come into YC's interview lacking confidence, but we will then help you in the next three months to gain more confidence.
(00:33:58):
And by the way, one of the things we do to help people gain more confidence is to make them believe that their startup is a great investment, to help them create a startup that truly is possibly going to make money or at least worth being a good bet. That's the thing, early stage, the best you can offer is like, "I might not succeed, but I'm definitely a good bet." And we help them with their product, we help them with their ideas, and we help them that, by demo day, they can get up on stage and legitimately say, "We're a good bet and here's why. Let me tell you about our idea." And so we definitely help with confidence.

**中文翻译:**
自信是好事。你肯定想要自信。很难……我想当你经历它时就能看出来。比如有人在回答问题时很自信但没有防卫心，这绝对是有区别的。我不知道，这就是为什么我说很难表达清楚，但自信意味着你可以说：“我想过那个问题，但我不知道答案。”这就是自信。他们会接着说：“但这是我为了弄清楚它所做的工作，这是我的应对计划。”自信，我本该把它放在最前面，因为它非常重要，尤其是在融资时，你绝不能在缺乏自信的情况下参加投资者会议。你可以带着不自信参加 YC 的面试，但在接下来的三个月里，我们会帮助你建立自信。
(00:33:58):
顺便说一下，我们帮助人们建立自信的方法之一，就是让他们相信自己的初创公司是一项伟大的投资，帮助他们创建一个真正可能赚钱、或者至少值得一赌的公司。在早期阶段，你能提供的最好的东西就是：“我可能不会成功，但我绝对值得一赌。”我们帮助他们完善产品和想法，帮助他们在演示日（demo day）能够站在台上理直气壮地说：“我们值得一赌，原因如下。让我给你们讲讲我们的点子。”所以我们肯定会在自信方面提供帮助。

---

### [00:34:43] Lenny Rachitsky

**English:**
Awesome. A couple other things you mentioned earlier, just to unpack a little bit. So being committed, something you look for, and co-founders getting along. In terms of committed, I imagine, these are very practical things. How are they actually going to stick to this? Are they actually excited to work on this? Maybe talk about that a little bit.

**中文翻译:**
太棒了。再拆解一下你之前提到的另外几点。比如“有决心”和你寻找的“联合创始人相处融洽”。关于“有决心”，我猜这些是非常实际的事情。他们实际上会如何坚持下去？他们真的对做这件事感到兴奋吗？能不能聊聊这个。

---

### [00:35:00] Jessica Livingston

**English:**
We all know how hard startups are, but I think you don't really know how hard it is until you actually do it. A lot of people would start a startup still having a job at Google or wherever, and they do it on the side. I do recommend, if people are just getting started and don't want to raise money yet, starting it on the side is a great way to get going, but at some point you have to commit, you have to burn the boat, because we found that founders who were still getting a paycheck and health insurance, once the going got tough, they did not quit their job. And you sort of need that desperation like, "I have to make this startup succeed because it's my job." Not like, "Oh, I'll just stay at Google." You need that. And we found that founders who weren't leaving their jobs, it was just not working out. Or that co-founder would always wind up leaving the company because they didn't want to actually leave their job.
(00:36:01):
And that's fine, there are people that can't leave their jobs for financial reasons. That's fine. You just shouldn't be starting a startup if you're not going to be prepared to leave your job. So that's the leaving of the job thing. And the co-founders getting along, oh my. I spent a lot of my time at Y Combinator when I was there all the time, full time, mediating co-founder disputes. And so many startups died or had near-death experiences because the co-founders didn't get along or broke up. It just happens all the time. And so that's why I think, during interviews, I was desperately trying to search for any clues that the co-founders didn't get along, or if they blatantly contradicted each other. But you could also tell if they were answering, finishing each other's sentences.
(00:36:59):
I love co-founders that have a history together; either they went to school together, they went to college together, work together, maybe they're siblings. Because when you have a long-term relationship, you trust each other and you know each other's weaknesses, and you're usually on the same page with your aspirations and everything. It's really scary when two founders get together just to start the startup and don't have any history. Massive red flag. Sometimes it works out like in the case of Dropbox, Drew and Arash both went to MIT, but I think they didn't know each other before they started Dropbox, and it worked out. But most of the time it doesn't.

**中文翻译:**
我们都知道创业有多难，但我认为直到你真正去做，你才真正知道它有多难。很多人在谷歌或其他地方还有工作时就开始创业，把它当作副业。我确实建议，如果人们刚刚开始且还不想融资，做副业是一个很好的开始方式，但在某个时刻你必须全身心投入，必须破釜沉舟。因为我们发现，那些还在领薪水、有医保的创始人，一旦情况变得艰难，他们就不会辞职。你需要那种“我必须让这家公司成功，因为这是我的工作”的迫切感，而不是“噢，大不了我继续留在谷歌”。你需要那种劲头。我们发现那些不辞职的创始人，项目往往做不成。或者那个联合创始人最终总是会离开公司，因为他们不想真的辞职。
(00:36:01):
这没关系，有些人因为经济原因无法辞职，这完全可以理解。但如果你不打算辞职，你就不应该开始创业。这就是辞职的问题。至于联合创始人相处融洽，噢天哪。我在 YC 全职工作时，花了大量时间调解联合创始人的纠纷。太多的初创公司因为联合创始人不和或分手而夭折或濒临倒闭。这种情况一直在发生。所以这就是为什么在面试中，我会拼命寻找联合创始人不和的任何线索，或者他们是否公然互相矛盾。但你也能看出来他们是否在默契配合，甚至能替对方把话说完。
(00:36:59):
我喜欢有共同背景的联合创始人；比如一起上过学、读过大学、共事过，或者是亲兄弟姐妹。因为当你有一段长期的关系时，你们互相信任，了解彼此的弱点，而且在抱负等方面通常是一致的。如果两个创始人只是为了创业才聚在一起，没有任何共同历史，那是非常可怕的。这是巨大的危险信号。有时也能成，比如 Dropbox，德鲁（Drew）和阿拉什（Arash）都去了 MIT，但我认为他们在创办 Dropbox 之前并不认识，结果也成功了。但大多数情况下并非如此。

---

### [00:37:46] Lenny Rachitsky

**English:**
So we've talked about co-founders getting along, looking for defensiveness, domain expertise, the sign of making shit happen, earnestness. Is there anything else that we've missed that you look for in the founders that tell you maybe we should, maybe we shouldn't?

**中文翻译:**
我们谈到了联合创始人相处融洽、观察防卫心、领域专业知识、搞定一切的迹象、真诚。还有什么我们遗漏的、你在创始人身上寻找的特质，能告诉你“也许我们该投”或“也许不该投”吗？

---

### [00:38:02] Jessica Livingston

**English:**
Relentlessly resourceful. Paul wrote a whole essay on that. Every founder is different, I never try to say, "Oh, this person doesn't have this. I'm not going to fund them." You always have to... Everyone's different. But I mean, you're an investor. I'm curious, do any of these things surprise you or do you care about these things too?

**中文翻译:**
“百折不挠且足智多谋”（Relentlessly resourceful）。保罗专门为此写过一篇文章。每个创始人都是不同的，我从不试图说：“噢，这个人没有这个特质，我不投他们。”你总是得……每个人都不同。不过，你也是投资者。我很好奇，这些特质中有让你感到惊讶的吗？或者你也看重这些吗？

---

### [00:38:24] Lenny Rachitsky

**English:**
No, absolutely not. Absolutely. And I actually try to avoid pre-seed and early stage because I'm not amazing at it, maybe. This is why I want to learn how to build my social radar skill.

**中文翻译:**
不，完全没有。绝对看重。实际上我尽量避开种子前（pre-seed）和早期阶段，因为我可能不太擅长。这就是为什么我想学习如何建立我的社交雷达技能。

---

### [00:38:37] Jessica Livingston

**English:**
Oh gosh, okay.

**中文翻译:**
噢天哪，好吧。

---

### [00:38:38] Lenny Rachitsky

**English:**
Yeah. Tough. It's so tough. It's like so few things actually work out.

**中文翻译:**
是的。很难。真的很难。因为真正能成功的项目太少了。

---

### [00:38:42] Jessica Livingston

**English:**
Well, it's because you don't have a lot of data. If someone is just applying with an idea, you have very little data. You can look at where they went to college, what have they built in the past, that's always a great predictor of their ability. And so on the YC's application, we ask them, "What project have you worked on before?" Or whatever. But it's really hard to tell when you're the first investor.

**中文翻译:**
嗯，那是因为你没有太多的数据。如果有人只是带着一个点子来申请，你的数据非常有限。你可以看他们在哪上的大学，过去做过什么，这通常是能力的一个很好的预测指标。所以在 YC 的申请书中，我们会问：“你以前做过什么项目？”之类的。但作为第一个投资者，确实很难判断。

---

### [00:39:07] Lenny Rachitsky

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast. Now, you can assess risk, secure the trust of your customers and automate compliance for SOC 2, ISO 27001, HIPAA and more with a single platform, Vanta. Vanta's market-leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risk. Plus, you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to vanta.com/Lenny. That's V-A-N-T-A dot com slash Lenny.
(00:40:00):
When did you first notice that you had this social radar-ish skill and you're better at this than other people?

**中文翻译:**
本集节目由 Vanta 赞助。在确保公司拥有顶尖的安全实践方面，事情很快就会变得复杂。现在，你可以通过 Vanta 这一个平台评估风险、获得客户信任并自动执行 SOC 2、ISO 27001、HIPAA 等合规性。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险。此外，你还可以通过 Vanta AI 完成安全问卷，从而节省数小时的时间。加入全球数千家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的公司。访问 vanta.com/Lenny 即可享受 1000 美元的优惠。
(00:40:00):
你是什么时候第一次注意到自己拥有这种“社交雷达”般的技能，并且比别人更擅长此道的？

---

### [00:40:08] Jessica Livingston

**English:**
Paul used to always call me Detective Livingston. Before I was a social radar, I was Detective Livingston. I cannot help myself noticing weird things, just dumb things, like if Paul had on a yellow T-shirt and then an hour later came in with a blue T-shirt, I'd be like, "Why do you have a blue T-shirt on?" I have to understand what happened in that hour where that T-shirt is different. Or people's what, their relationships, what drives them? I was always like this, and I think it goes back to my childhood.
(00:40:44):
I spent hours and hours on the phone with people, with my girlfriends, dissecting situations, and then all through high school, and college, I mean the amount of time we wasted discussing social matters with people, and boys, and things like that. It was just frightening how much time I wasted, but I just was genuinely interested in it. And what drives people and why did this happen? I don't know if I ever noticed I did this, but it was just, my point is, it's always been a part of me. And I definitely notice and having an aversion to phony people. I always have. I've never been one to fall for someone who's super phony and tried to have them as a friend or anything. I just can tell, and ugh, I hate it.

**中文翻译:**
保罗以前总是叫我“利文斯顿侦探”。在我被称为“社交雷达”之前，我是“利文斯顿侦探”。我忍不住会注意到一些奇怪的事情，甚至是一些无聊的小事，比如保罗穿了一件黄色 T 恤，一小时后换了一件蓝色的进来，我就会问：“你为什么换了件蓝色 T 恤？”我必须弄清楚在那一个小时里发生了什么，导致 T 恤变了。或者是人们的关系，他们的动力是什么？我一直都是这样，我想这可以追溯到我的童年。
(00:40:44):
我曾花好几个小时和朋友、闺蜜通电话，剖析各种情况。在整个高中和大学期间，我们在讨论社交问题、男生之类的事情上浪费的时间简直惊人。我浪费了那么多时间，这很可怕，但我确实对此发自内心地感兴趣。什么驱动着人们？为什么会发生这种事？我不确定我是否意识到自己在做这件事，但我的意思是，这一直是我的一部分。我肯定会注意到虚伪的人，并且非常反感。我一直如此。我从来不会被超级虚伪的人迷惑，也不会想和他们交朋友。我一眼就能看出来，呃，我讨厌虚伪。

---

### [00:41:34] Lenny Rachitsky

**English:**
Do you feel like it's almost all genetic or do you think there was something in your childhood that pushed you to be good at this?

**中文翻译:**
你觉得这几乎全是遗传，还是你认为童年中的某些经历促使你擅长此道？

---

### [00:41:42] Jessica Livingston

**English:**
I don't know. I really don't know. So this is why I think I'm going to be a bad guest, because I can't give a practical understanding. I mean, I don't really think... I can't say other people in my family are like that, and I can't say that it was part of my upbringing. I just notice these things. I don't know. I should be paying attention to other things, but I'm not, but I'm paying attention to this. I'll give you an example with you.

**中文翻译:**
我不知道。我真的不知道。所以这就是为什么我觉得我会是一个糟糕的嘉宾，因为我无法提供实际的理解。我的意思是，我不觉得……我不能说我家里的其他人也是这样，我也不能说这是我成长环境的一部分。我就是能注意到这些事。我不知道。我本该关注其他事情，但我没有，我只关注这个。我拿你举个例子。

---

### [00:41:42] Lenny Rachitsky

**English:**
Please.

**中文翻译:**
请讲。

---

### [00:42:13] Jessica Livingston

**English:**
So I looked up your bio to read a little bit about you, and I loved the Dalton Caldwell Podcast. I listened to that.

**中文翻译:**
我查了你的简历，了解了一下你，我很喜欢道尔顿·考德威尔（Dalton Caldwell）那一集播客。我听了。

---

### [00:42:23] Lenny Rachitsky

**English:**
Fourth most popular of all time.

**中文翻译:**
那是有史以来第四受欢迎的一集。

---

### [00:42:26] Jessica Livingston

**English:**
Dalton's was?

**中文翻译:**
道尔顿那集是吗？

---

### [00:42:27] Lenny Rachitsky

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:42:28] Jessica Livingston

**English:**
Oh, go Dalton. That's awesome. Yeah, it was really good. I learned a lot from it. I love listening to Dalton. But what I really want to know about you is, on the release that you sent, or on the instructions for this podcast, you said, "There might be some edge cases where your podcast isn't good enough to go out. We just want to warn you." And all I could think of is, what prompted that? There has to be a story of what prompted that. No one else would pay attention to that, but I'm just so curious. It's so weird. I'm just a weird person like this.

**中文翻译:**
噢，道尔顿真棒。太赞了。是的，那集非常好，我学到了很多。我喜欢听道尔顿说话。但我真正想了解你的是，在你发给我的发布说明或播客指南中，你说：“可能会有一些极端情况，导致你的播客不够好而无法发布。我们只是想提醒你。”我当时就在想：是什么促使你写下这句话的？背后肯定有一个故事。没人会注意到这一点，但我就是很好奇。这很奇怪，我就是这样一个奇怪的人。

---

### [00:43:07] Lenny Rachitsky

**English:**
Yes, I did add that. There's a story, basically, it was just an episode that wasn't amazing and we didn't have that caveat in the prep beforehand, and it felt bad to tell the person.

**中文翻译:**
是的，我确实加了那句。确实有个故事，基本上就是有一集录得不太理想，而我们事先没有在准备工作中加入那个免责声明，最后告诉对方时感觉很糟糕。

---

### [00:43:19] Jessica Livingston

**English:**
See, I knew it. I knew that that had happened.

**中文翻译:**
看吧，我就知道。我就知道发生过这种事。

---

### [00:43:23] Lenny Rachitsky

**English:**
That's exactly right. Is there kind of a way you've thought about honing this skill over time? Once you kind of got a sense, "Hey, people keep telling me I'm really good at this." Is there something you've done to help strengthen it?

**中文翻译:**
一点没错。随着时间的推移，你有没有想过磨练这项技能的方法？一旦你意识到“嘿，人们总说我在这方面很厉害”，你有没有做过什么来加强它？

---

### [00:43:35] Jessica Livingston

**English:**
No, but one of the things I do try to do is sort of reinforce. Sometimes I'll have a feeling about someone, maybe we fund them, maybe we don't. I'd sort of like to know what happens a few years later. I like to follow up. There definitely have been some situations where I haven't liked someone that we funded and it's taken 5 to 10 years before they failed. And in some cases, for a bad reason. Where I'll say, "Oh, thank God, I was right about that. I did have this feeling." Or, "I knew they'd be successful." Like the GOAT guys who I was saying before, there was definitely a period when Grubwithus, their first startup wasn't doing well, and they were starting, that maybe some people would've given up on them. And now I can say, "I was right about them. That feeling was right."
(00:44:35):
So I do try to sort of follow up with some of the really strong gut instincts that I had, to see if I was right. Often, when I have a gut instinct, it's like a negative thing. So we wind up not funding someone. So I really need to know if that person went on to be super successful. And I will answer your question right now, there's no one that I had a strong dislike for that I sort of said, "We should not fund them," that has gone on to be a super success. Thank God.

**中文翻译:**
没有，但我确实尝试做的一件事是某种形式的“强化”。有时我对某人有一种感觉，也许我们投了，也许没投。我想知道几年后发生了什么。我喜欢跟进。确实有些情况，我不喜欢某个我们资助的人，结果过了 5 到 10 年他们才失败。在某些情况下，是因为不好的原因。我会说：“噢，谢天谢地，我当时看准了。我确实有那种感觉。”或者，“我知道他们会成功。”就像我之前说的 GOAT 的那几个人，当他们的第一家初创公司 Grubwithus 表现不佳时，肯定有一段时间有些人会放弃他们。但现在我可以说：“我对他们的看法是对的，那种感觉是对的。”
(00:44:35):
所以我确实会尝试跟进一些我曾有过的强烈直觉，看看我是否正确。通常，当我产生直觉时，往往是负面的。所以我们最终没有资助某人。所以我真的需要知道那个人后来是否变得超级成功。我现在就可以回答你的问题：目前还没有一个我强烈反感并说“我们不该投”的人，后来获得了巨大的成功。谢天谢地。

---

### [00:45:10] Lenny Rachitsky

**English:**
Wow, interesting.

**中文翻译:**
哇，很有意思。

---

### [00:45:12] Jessica Livingston

**English:**
I mean, it doesn't happen all the time that I really put my foot down, but sometimes I have.

**中文翻译:**
我的意思是，我并不总是坚持己见，但有时我会。

---

### [00:45:18] Lenny Rachitsky

**English:**
And this feeling, is it like a visceral body thing for you? Or is it like intellectually, you notice, "Hey, this guy's interrupting her and this person doesn't..."?

**中文翻译:**
这种感觉对你来说是一种生理上的直觉吗？还是理智上的，比如你注意到“嘿，这家伙在打断她，而那个人没有……”？

---

### [00:45:26] Jessica Livingston

**English:**
More intellectual. But it does come from inside. I don't know how to hone it. It has to come naturally. You have to have a natural interest in people. And so I'm sometimes not listening to all the words and I'm sort of just observing them, I don't know.

**中文翻译:**
更多是理智上的。但它确实来自内心。我不知道如何磨练它，它必须自然而然地产生。你必须对人有天生的兴趣。所以有时我并没有在听所有的谈话内容，而只是在观察他们，我也不知道。

---

### [00:45:45] Lenny Rachitsky

**English:**
Have you ever been tricked by someone where you didn't see something you should have seen? Is there anything there?

**中文翻译:**
你有没有被某人欺骗过，或者没看到本该看到的东西？有这样的经历吗？

---

### [00:45:52] Jessica Livingston

**English:**
Oh, yeah, for sure. I can't really talk about the times I have been tricked just because I don't want to say anything really negative about people, but... Well, there was one example that I do feel comfortable sharing. Ilya Lichtenstein of MixRank. Do you know the guy that stole billions of dollars in Bitcoin from a crypto wallet? Do you not know this crazy, crazy story?

**中文翻译:**
噢，当然有。我不太想谈论被骗的经历，因为我不想对别人说太负面的话，但是……好吧，有一个例子我觉得可以分享。MixRank 的伊利亚·利希滕斯坦（Ilya Lichtenstein）。你知道那个从加密钱包里偷了价值数十亿美元比特币的家伙吗？你不知道这个极其疯狂的故事吗？

---

### [00:45:52] Lenny Rachitsky

**English:**
Please share.

**中文翻译:**
请分享一下。

---

### [00:46:21] Jessica Livingston

**English:**
I think he's in the joint now. He was definitely convicted of this, and his wife, and they stole billions of dollars. And I definitely don't remember thinking anything bad about him or thinking he could be that kind of person. So that definitely, there've been some doozies like that, where, did not see that one coming.

**中文翻译:**
我想他现在在监狱里。他和他的妻子肯定被定罪了，他们偷了数十亿美元。我完全不记得当时对他有什么不好的看法，或者觉得他会是那种人。所以肯定有过那样的“大翻车”，完全没预料到。

---

### [00:46:48] Lenny Rachitsky

**English:**
Oh my God. I think what's extraordinary about the fact that that happens rarely is that your interviews are 10 minutes long, and so you have very little time to actually find all these things. And plus, the actual product and the idea and growth strategy and all these things.

**中文翻译:**
我的天。我觉得这种事很少发生的原因在于，你们的面试只有 10 分钟，所以你实际上只有极短的时间去发现所有这些细节。而且还要考虑实际的产品、点子、增长策略等等。

---

### [00:47:04] Jessica Livingston

**English:**
Well, you find a lot can come in reading the application. That's a lot of legwork at the beginning. You read the application. But then the 10 minutes is kind of as long as you need, in most cases. Because we found when they were longer, like 20 minutes, you'd know in 10 minutes and be twiddling your thumbs trying to get through the interview for the next 10 minutes. So we kept them short so we could interview more people. But there have definitely been cases where we've interviewed people, accepted them, and then very soon afterward, we're sort of like, crestfallen like, "Oh, these people are very limp. What were we thinking?" Definitely, we've been tricked in that respect all the time. Or, "Oh gosh, they seem so impressive in the interview and now they're just posers who can't really do anything." Definitely, I'm tricked all the time in little ways. Or, I didn't notice two founders didn't get along and then one co-founder goes missing a week into the program or something crazy. There's all sorts of crazy stuff like that that happen.

**中文翻译:**
嗯，通过阅读申请书可以发现很多东西。那是前期的基础工作。但在大多数情况下，10 分钟就足够了。因为我们发现如果时间更长，比如 20 分钟，你其实在 10 分钟时就心里有数了，接下来的 10 分钟只能无聊地转手指等面试结束。所以我们保持短时间，以便面试更多人。但确实有些情况，我们面试并录取了他们，但很快我们就感到垂头丧气，心想：“噢，这些人太软弱了，我们当时在想什么？”在这些方面我们确实经常被骗。或者，“噢天哪，他们在面试中看起来很厉害，现在看来只是些什么都做不了的装腔作势者。”我确实经常在一些小地方被骗。或者，我没注意到两个创始人不和，结果项目开始一周后一个联合创始人就失踪了，或者其他疯狂的事。各种疯狂的事情都会发生。

---

### [00:48:14] Lenny Rachitsky

**English:**
I think in the game you're playing, I would expect some things to slip through.

**中文翻译:**
我觉得在你玩的这场“游戏”中，漏掉一些东西是在所难免的。

---

### [00:48:21] Jessica Livingston

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:48:21] Lenny Rachitsky

**English:**
You said that there's been kind of an operationalization of some of the things you used to look for in founders, now that you're not actually in the process. Is there a Jessica-as-a-service sort of thing? What kind of stuff have they built that looks for the sorts of things you used to look for in the interview process?

**中文翻译:**
你说过，既然你现在不直接参与流程，你以前在创始人身上寻找的一些特质已经被“流程化”了。有没有一种类似“杰西卡即服务”（Jessica-as-a-service）的东西？他们开发了什么样的工具来寻找你以前在面试过程中寻找的那些特质？

---

### [00:48:38] Jessica Livingston

**English:**
No, it's all just stuff in application that automatically flags certain things. I actually don't remember all of them, but it's just, all it is, is a, "Please pay attention to this, reader of the application." It's not, "This disqualifies anyone." It's, "Just please pay attention." And those are things like I mentioned, a really crazy equity structure, founders not quitting their job, things like that, that it's important that someone is voting on them and then interviewing them knows. Because I would often, some of the questions I'd ask at the end of the interview, I'd say, "It looks like you have 90% of the stock and your co-founder only has one. Can you tell us why that's the case?" And maybe they could make a case for it, who knows? But at least I'd ask. So the flags just say, "Pay attention to it."

**中文翻译:**
不，只是申请书中的一些内容会自动标记某些事项。我不记得所有的细节了，但它基本上只是在提醒：“请申请书阅读者注意这一点。”这并不是说“这会让某人失去资格”，而是“请务必留意”。就像我提到的，比如疯狂的股权结构、创始人不辞职之类的，这些信息对于投票和面试的人来说很重要。因为我经常在面试结束时问：“看起来你持有 90% 的股份，而你的联合创始人只有 1%。你能告诉我们为什么吗？”也许他们有合理的解释，谁知道呢？但至少我会问。所以这些标记只是说：“留意一下。”

---

### [00:49:37] Lenny Rachitsky

**English:**
Amazing. So if we were to zoom out, in early stage investing, the main thing you need to get right and evaluate as the founder, the social radar skill that you've had from childhood is such an incredible advantage in doing this well, and you could basically say YC is what it is because of this unfair advantage that you all had in the early days. I'm guessing many people listening to this are like, "We need a Jessica on our team. We need to build this skill ourselves. We need to figure out how to integrate social radar into our process." I know you're going to hate this question, but just, do you have any advice for people that want to try to build the skill, get better at this, notice some of these things?

**中文翻译:**
太棒了。所以如果放大来看，在早期投资中，你需要评估的最核心因素就是创始人。你从小就具备的这种“社交雷达”技能在做好这件事上具有不可思议的优势。基本上可以说，YC 能有今天，正是因为你们早期拥有的这种“不公平竞争优势”。我猜很多听众会想：“我们的团队也需要一个杰西卡。我们需要自己培养这项技能。我们需要弄清楚如何将社交雷达整合到我们的流程中。”我知道你会讨厌这个问题，但你对那些想要培养这项技能、变得更擅长观察这些细节的人有什么建议吗？

---

### [00:50:20] Jessica Livingston

**English:**
I really think that our advantage was that my three co-founders were deeply technical people. And I think a lot of investors back then weren't, didn't have that background. And I think that that background really helped YC choose good founders. So I don't want to make it sound like it was that big of a deal, but advice? Advice for how to hone... I mean, I think just try to pay attention to subtle cues. If you really feel like, gosh, I'm so clueless about these things, try to just tell yourself, "Okay, I'm going in to evaluate these founders, evaluate this investment opportunity. I know I'm bad at these kind of judgments. I'm going to remember, do they seem like they get along?" Because there are no trick questions. I don't have any trick questions that you could ask, or it's just paying attention. Have a conversation.
(00:51:26):
Do they understand their product well? Are they defensive? Maybe have your own little checklist that you think about. You don't have to have it written down, but you think about, and then afterward, you spend some time thinking, were they defensive? When I asked them why this is better than the competitor, how did that go? Or ask them, maybe do have some questions, if you don't know how long they've known each other, ask them that question. "How did you two meet? Have you ever worked together before? How's it going?" Just be a little bit more conscious about asking these types of questions to reveal some key information for your investment decision.

**中文翻译:**
我真的认为我们的优势在于我的三位联合创始人都是深厚的技术专家。我想当时的很多投资者并没有那样的背景。我认为那种背景确实帮助 YC 选择了优秀的创始人。所以我不想让它听起来像是什么了不起的大事。但建议吗？关于如何磨练……我的意思是，我认为只要尝试关注细微的线索。如果你真的觉得自己对这些事一窍不通，试着告诉自己：“好吧，我要去评估这些创始人，评估这个投资机会。我知道我不擅长这类判断。我要记住观察：他们看起来相处得好吗？”因为没有什么陷阱问题。我没有什么你可以问的秘诀问题，关键就是关注。进行对话。
(00:51:26):
他们对产品了解透彻吗？他们有防卫心吗？也许可以建立一个你关注的小清单。不需要写下来，但在心里过一遍。面试结束后，花点时间思考：他们有防卫心吗？当我问他们为什么比竞争对手更好时，他们的反应如何？或者问一些问题，如果你不知道他们认识多久了，就问：“你们两个是怎么认识的？以前一起工作过吗？进展如何？”在询问这类问题时更有意识一点，以揭示投资决策的关键信息。

---

### [00:52:09] Lenny Rachitsky

**English:**
That was an awesome summary of a lot of the stuff we talked about. If anyone ever doubts that you are very good at this, Paul tweeted this quiz, the Reading the Mind in the Eyes quiz, that I took, it's incredibly hard. You basically see a bunch of eyes and you're supposed to judge their emotion, and it's really hard. And you got 36 out of 36, which blows my mind.

**中文翻译:**
这是对我们谈论内容的精彩总结。如果有人怀疑你是否真的擅长此道，保罗曾在推特上发过那个“眼神读心测试”的链接。我也测了，非常难。你基本上只能看到一堆眼睛，然后要判断他们的情绪，这真的很难。而你得了 36 分（满分 36 分），这让我大吃一惊。

---

### [00:52:33] Jessica Livingston

**English:**
I did nail it. I do have to tell a funny story about this.

**中文翻译:**
我确实全对了。关于这个我得讲个有趣的故事。

---

### [00:52:33] Lenny Rachitsky

**English:**
Please.

**中文翻译:**
请讲。

---

### [00:52:36] Jessica Livingston

**English:**
So Paul, sort of late at night, and he emailed me, because I had gone to bed, but I had my thing, and he emailed me. He's like, "Check out this quiz. I got 25 out of 36. What can you get?" So I got my computer out because I was like, I have to beat Paul. And I did it, and it was really hard. They'd only show the eyes and then it would say, what is this person thinking? Are they happy, sad? But some of them were really hard to distinguish. Are they irritated or are they angry? It's kind of hard to tell the difference between irritated and angry. And I remember looking into these people's eyes saying, "What are they trying to communicate to me? Are they irritated with me or are they mad at me?" Kind of thing.
(00:53:24):
And as I went through, it would tell you if you got it correct. As I almost got to the end, I was like, "Oh my God, this is going to be a near-perfect score. I have to nail this." And when I got 36 out of 36, I was like, "Yes." And I told Paul, he tweeted it. We then, a week later, had this YC event in London, and I swear to God, about 10 people came up to me to talk about this eye quiz and how they had not done well, and what was my secret? It was very amusing. I never thought that anyone would think it was that interesting.

**中文翻译:**
那是深夜，保罗给我发了邮件，因为我已经上床睡觉了，但我带着设备。他发邮件说：“看看这个测试。我得了 25 分。你能得多少？”于是我拿出电脑，因为我想我一定要赢过保罗。我做了测试，真的很难。它只显示眼睛，然后问：这个人在想什么？是高兴还是悲伤？但有些情绪很难区分。是烦躁还是愤怒？烦躁和愤怒的区别很难看出来。我记得我盯着那些人的眼睛想：“他们想向我传达什么？他们是在烦我，还是在生我的气？”类似这种。
(00:53:24):
当你做题时，它会告诉你是否正确。当我快做完时，我想：“天哪，这快要拿满分了，我一定要全对。”当我拿到 36 分时，我心想：“太棒了。”我告诉了保罗，他发了推特。一周后，我们在伦敦举办了一场 YC 活动，我发誓，大约有 10 个人跑来跟我聊这个眼神测试，说他们做得有多差，问我有什么秘诀。这非常有趣，我从没想过会有人觉得这事儿这么有意思。

---

### [00:53:59] Lenny Rachitsky

**English:**
I love that there's this thing that totally shows this skill you have that is better than everyone else. I took it, all my friends have taken it after that tweet, and the highest we've gotten is 31 of all the people I know.

**中文翻译:**
我喜欢这个测试，它完全展示了你那项优于常人的技能。我测了，在那条推特之后我所有的朋友都测了，在我认识的所有人里，最高分也才 31 分。

---

### [00:54:11] Jessica Livingston

**English:**
Really?

**中文翻译:**
真的吗？

---

### [00:54:12] Lenny Rachitsky

**English:**
And I think when people take it, we'll link to it, they're going to be like, "How can you get 36 out of 36? Impossible."

**中文翻译:**
我想当人们去测的时候（我们会放链接），他们会想：“怎么可能得满分？这不可能。”

---

### [00:54:19] Jessica Livingston

**English:**
You have to look into their eyes and say, "What are they trying to tell me?" I hope you're not trying to tell me you're full of shit with your eyes.

**中文翻译:**
你必须盯着他们的眼睛问：“他们想告诉我什么？”我希望你没用眼神告诉我你在胡说八道。

---

### [00:54:28] Lenny Rachitsky

**English:**
I'm feeling despondent. Just kidding. That's one of the options. I'm like, "What does that even mean?"

**中文翻译:**
我感到很沮丧（despondent）。开玩笑的，那是选项之一。我当时想：“这词儿到底啥意思？”

---

### [00:54:32] Jessica Livingston

**English:**
I know. Well, that's the other thing I told Paul, also the challenge is, you really have to understand what each feeling, what that word means. He's like, "Oh, that didn't even occur to me." Because he's such a word person and knows the exact definition of every single word. But I thought some people will struggle understanding the complexities of the emotion.

**中文翻译:**
我知道。我也跟保罗说了，挑战在于你必须真正理解每种感受，理解那个词的意思。他说：“噢，我压根儿没想过这一点。”因为他是个文字专家，知道每个词的精确定义。但我认为有些人可能很难理解情绪的复杂性。

---

### [00:54:55] Lenny Rachitsky

**English:**
With the words, I almost felt like I had to do what you did where just like, "What does this word feel like when I'm reading it? Despondent, let's see if these eyes are despondent." I love that trick you shared. So basically you looked at the eyes and you're like, "What is this person trying to tell me?"

**中文翻译:**
对于那些词，我感觉我也得像你那样做：“当我读到这个词时，它是什么感觉？‘沮丧’，看看这双眼睛是不是沮丧。”我喜欢你分享的那个技巧。所以基本上你看着眼睛想：“这个人想告诉我什么？”

---

### [00:55:09] Jessica Livingston

**English:**
Yeah, that's the best I could do.

**中文翻译:**
是的，那是我能想到的最好办法。

---

### [00:55:12] Lenny Rachitsky

**English:**
Amazing. So we're going to link to that quiz. I'm curious what people, if you take it, please leave your score in the comments, see if anyone can get anywhere near Jessica's score. Okay. So speaking of social radar-ing, you have a podcast called The Social Radars. Let's talk about it.

**中文翻译:**
太棒了。我们会附上那个测试的链接。我很想知道大家测完后的分数，请在评论区留下你的分数，看看有没有人能接近杰西卡的分数。好，说到“社交雷达”，你有一个播客叫《The Social Radars》。我们聊聊这个吧。

---

### [00:55:27] Jessica Livingston

**English:**
Yes, okay.

**中文翻译:**
好的。

---

### [00:55:28] Lenny Rachitsky

**English:**
First of all, just why did you decide to start a podcast? There's a lot of podcasts in the world. What made you decide to start one?

**中文翻译:**
首先，你为什么决定开始做播客？世界上已经有这么多播客了，是什么让你决定做一个？

---

### [00:55:32] Jessica Livingston

**English:**
Well, I'm really excited that you're asking that question because no one has ever asked me about The Social Radars. Yes, I mean, it's pretty new, but we launched last year. I decided to start The Social Radars because I live off in the English countryside, not really as connected as I'd like to be with Silicon Valley, partly by choice, but I do miss it a lot. And I was finding that as I was catching up with YC alumni that would come visit or I'd see, I just loved the conversations we were having, and I missed that. I missed that connection with these people, and sort of sharing their stories of triumph and failure in some cases, but mostly triumph. At the same time, I became obsessed with this podcast called SmartLess. Have you ever heard of it?

**中文翻译:**
我很兴奋你问这个问题，因为从来没有人问过我关于《The Social Radars》的事。是的，它还很新，我们是去年推出的。我决定开始做这个播客是因为我住在英国乡村，与硅谷的联系不如我希望的那样紧密，部分是我自己的选择，但我确实很想念那里。我发现当我与来访或见面的 YC 校友叙旧时，我非常喜欢我们的对话，我很怀念那种感觉。我怀念与这些人的联系，分享他们成功的故事，有时也有失败，但主要是成功。与此同时，我迷上了一个叫《SmartLess》的播客。你听说过吗？

---

### [00:56:20] Lenny Rachitsky

**English:**
I've heard of it, haven't listened.

**中文翻译:**
听说过，但没听过。

---

### [00:56:21] Jessica Livingston

**English:**
Okay. So just for the listeners, it is a podcast hosted by three actors; Jason Bateman, Will Arnett and Sean Hayes. And they invite Hollywood people, actors, directors, musicians, sometimes athletes, on the show. And the thing is, one person, one of the hosts invites the guests, the other two don't know. So there's no preparation, and it's the most fascinating thing. I love movies and I love television, and I can tell you another weird eccentric gift of mine is I remember every name in Hollywood and know all their children and all this stuff because I've been reading People Magazine since I was 13. So I loved, you'd learn so much about the actors as people because they weren't talking from a script or their media messages for promoting a movie. It was like just genuine conversations. Most of the time these actors knew the people and were friends, and I just found it fascinating. I could not stop.
(00:57:25):
And I thought there should be a really informal conversation like this with startup founders so people could understand the people behind the startups. And it's not too scripted and not too, maybe, I don't want to say professional, because I hope it's professional sounding, but it's very conversational and authentic. I was trying to mimic that a little bit. I convinced my colleague and friend, Carolynn Levy, who of course has a full-time job being one of the amazing lawyers within YC, and she's super busy. I convinced her to do it with me so I could have a partner in crime. And then we just started and I said, "We'll do a few episodes, see how it goes, and we'll keep going if it's fun." And I have had so much fun catching up with all the people I've interviewed. At this point, I forget how many podcasts I've even done, but maybe-

**中文翻译:**
好。给听众们介绍一下，这是一个由三位演员主持的播客：杰森·贝特曼（Jason Bateman）、威尔·阿奈特（Will Arnett）和肖恩·海耶斯（Sean Hayes）。他们会邀请好莱坞人士、演员、导演、音乐家，有时还有运动员。关键在于，其中一位主持人邀请嘉宾，另外两位并不知道是谁。所以完全没有准备，这非常迷人。我喜欢电影和电视，我可以告诉你我的另一个古怪天赋：我记得好莱坞每一个人的名字，知道他们所有的孩子之类的信息，因为我从 13 岁起就一直在读《人物》杂志。所以我很喜欢这个节目，你可以了解到演员作为普通人的一面，因为他们不是在照本宣科，也不是在发布宣传电影的媒体信息。这就像是真正的对话。大多数时候，这些演员和嘉宾互相认识，是朋友，我觉得这太迷人了，根本停不下来。
(00:57:25):
我想，应该和创业创始人也进行这样一种非正式的对话，让人们了解创业公司背后的人。它不会太刻板，也不会太……我不想说“不专业”，因为我希望它听起来很专业，但它非常有对话感且真实。我试图模仿那种风格。我劝说我的同事兼好友卡罗琳·利维（Carolynn Levy）和我一起做，她当然有一份全职工作，是 YC 内部出色的律师之一，非常忙。我劝说她和我一起做，这样我就有了一个“共犯”。然后我们就开始了，我说：“我们先录几集，看看效果如何，如果好玩我们就继续。”我非常享受与我采访过的所有人叙旧的过程。到目前为止，我都忘了录了多少期了，可能……

---

### [00:58:24] Lenny Rachitsky

**English:**
I think about 27-ish.

**中文翻译:**
大概 27 期左右。

---

### [00:58:26] Jessica Livingston

**English:**
27 that have launched yet, and there's a few coming out. Season three, we're still in the middle of that, and still editing some and doing some. But it's been so much fun and I love it, and I hope that people enjoy listening. I hope I'm not just working this really small corner of the room. I hope people enjoy unstructured conversations. But people open up to me though, because what I copied from SmartLess that I liked, they'd say, "Hey, remember when we were at that Oscars party and this happened..." Because they had that relationship with the people they're interviewing, in a lot of cases, I feel like I've had that with a lot of people I'm interviewing and I could say, "Hey, Brian, remember when you interviewed and brought the cereal boxes?" And he could tell, he shared that story. I don't think I knew it before then that they were on the 101 and the phone went out, the reception went out before Paul said that they were accepted. So I learn a lot, and it's really just fascinating to me.

**中文翻译:**
已经发布了 27 期，还有几期即将推出。第三季我们还在进行中，还在剪辑和录制。但这真的很有趣，我很喜欢，希望大家也喜欢听。我希望我不只是在自娱自乐。我希望人们喜欢这种非结构化的对话。人们确实对我敞开心扉，因为我从《SmartLess》那里学到了一点：他们会说，“嘿，记得我们在奥斯卡派对上发生的那些事吗……”因为他们与受访者有那种关系。在很多情况下，我觉得我和很多受访者也有这种关系，我可以问：“嘿，布莱恩，记得你面试时带麦片盒的事吗？”然后他就会分享那个故事。在那之前我甚至不知道他们在 101 公路上信号中断的事。所以我学到了很多，这对我来说真的很有趣。

---

### [00:59:27] Lenny Rachitsky

**English:**
Well, it's an awesome podcast, I've been listening. I'm going to just read some of the guests that you've had on, just so people get a sense of who you're interviewing. So you actually just had Paul Graham on the podcast. He does very few podcast episodes. So that's an unfair advantage you have there. Patrick and John Collison, Brian Chesky, you mentioned Brian Armstrong, Emmett Shear, Tony Xu, like epic people.

**中文翻译:**
嗯，这是一个很棒的播客，我一直在听。我来读一下你邀请过的一些嘉宾，让大家了解一下你在采访谁。你最近刚请到了保罗·格雷厄姆。他很少参加播客，所以这是你的一个“不公平优势”。还有帕特里克和约翰·科里森、布莱恩·切斯基、你提到的布莱恩·阿姆斯特朗（Brian Armstrong）、埃米特·希尔（Emmett Shear）、徐迅（Tony Xu），都是些重量级人物。

---

### [00:59:48] Jessica Livingston

**English:**
Emmett Shear, by the way, the week after he was named OpenAI CEO for like 72 hours, that one launched. I was like, I could not have planned that timing better.

**中文翻译:**
顺便说一下，埃米特·希尔那一集是在他被任命为 OpenAI 首席执行官（大约 72 小时）后的那一周发布的。我想，时机抓得再准不过了。

---

### [00:59:58] Lenny Rachitsky

**English:**
Is there an episode you'd recommend people start with if they were start to explore your podcast and get into it?

**中文翻译:**
如果人们想开始探索你的播客，你有没有推荐哪一集作为入门？

---

### [01:00:04] Jessica Livingston

**English:**
Honestly, I truly believe this, I'm not BS-ing you, I think they're all really, really good, and there's so many interesting takeaways from every single one. If I were coming to it for the first time, I'd probably choose, I'd look at the guests and say, "Who am I interested in? Have I stayed at an Airbnb and I want to learn more about that?" Or, "Do I use Reddit?" Just see who the guests are and start with someone you're kind of interested in, and I guarantee you'll learn more about this person.

**中文翻译:**
老实说，我真心这么认为，不是在忽悠你，我觉得每一集都非常非常好，每一集都有很多有趣的收获。如果我是第一次听，我可能会先看嘉宾名单，然后想：“我对谁感兴趣？我住过 Airbnb 吗？我想了解更多吗？”或者，“我用 Reddit 吗？”看看嘉宾是谁，从你感兴趣的人开始，我保证你会对那个人有更深入的了解。

---

### [01:00:34] Lenny Rachitsky

**English:**
So across the podcast episodes you've done, I hate when people ask me this question, but I'm going to ask you this question. Is there any big lessons you've learned, any stories that have stuck with you? Any takeaways so far from interviewing all these incredibly successful founders and people?

**中文翻译:**
在你录过的这些播客中，我讨厌别人问我这个问题，但我还是要问你：你学到了什么重大的教训吗？有什么故事让你记忆犹新？到目前为止，采访了这么多极其成功的创始人和大咖，你有什么感悟吗？

---

### [01:00:48] Jessica Livingston

**English:**
My God, I love that question. I don't hate that question.

**中文翻译:**
天哪，我喜欢这个问题。我不讨厌这个问题。

---

### [01:00:48] Lenny Rachitsky

**English:**
Okay, I'm glad.

**中文翻译:**
好，那我就放心了。

---

### [01:00:52] Jessica Livingston

**English:**
I could talk for an hour just on... I want to learn from you as an expert podcaster, because I'm still a noob here. What I've learned the hard way, and you probably will nod your head when I say this, is that I talk way too much. I'm a huge windbag and I hate... I don't notice it now when I'm just talking to you and going off and talking, talking, talking. But when I'm editing the podcast and I'm listening to myself ask a question in 20 sentences when I could ask it in two. So I've really had to train myself to keep things short. You want regular short dialogue, you know this, but you also have to interrupt guests if they're going off too much. So the talking of the hosts should be frequent but short. That's the lesson that I've learned.

**中文翻译:**
我可以就这个话题聊上一个小时……我想向你这位专家级播客学习，因为我还是个菜鸟。我通过惨痛教训学到的一点是（我说的时候你可能会点头），那就是我话太多了。我简直是个话匣子，我讨厌……现在和你聊天时我没注意到自己在滔滔不绝，但当我剪辑播客，听到自己用 20 句话问一个本可以用两句话问完的问题时，我真的很抓狂。所以我真的必须训练自己保持简短。你需要规律的短对话，你懂的，但如果嘉宾跑题太远，你也必须打断他们。所以主持人的发言应该是频繁但简短的。这就是我学到的教训。

---

### [01:00:52] Lenny Rachitsky

**English:**
Totally agree.

**中文翻译:**
完全同意。

---

### [01:01:46] Jessica Livingston

**English:**
In terms of content, every single episode is a gem in its own right, and there aren't massive lessons because they're all sort of specific to that person, and I never know exactly which direction we're going in when we get into things. But it was interesting. There were definitely some themes with Adora Cheung and Tony Xu of DoorDash where they said they really made a mistake early on scaling into different cities before they had nailed the original city. And that's an important lesson. There's lessons for everyone, I think. In addition to really getting to know these founders, their personal side of their personality, there's some great lessons that they all tell.

**中文翻译:**
在内容方面，每一集本身都是一块瑰宝，并没有什么宏大的通用教训，因为它们都针对特定的人，我永远不知道谈话会走向何方。但很有趣。阿多拉·张（Adora Cheung）和 DoorDash 的徐迅确实提到了一些共同的主题，比如他们在还没搞定第一个城市之前就过早地扩张到其他城市，这确实是个失误。这是一个重要的教训。我认为每个人都能从中受益。除了真正了解这些创始人的个性和私人一面，他们讲述的故事中都有很棒的教训。

---

### [01:02:36] Lenny Rachitsky

**English:**
I love these lessons. Is there anything else you've learned about interviewing? That's something I'm always trying to get better at. I love this point you made. I say the same thing to every podcaster. You talk too much as a host, you should let the guest talk. Just ask the question and let them talk. Is there anything else that you've learned about just how to interview more effectively?

**中文翻译:**
我喜欢这些教训。关于采访，你还学到了什么吗？这是我一直试图改进的地方。我喜欢你提到的那一点。我对每个播客主持人都说同样的话：作为主持人，你话太多了，你应该让嘉宾多说。只要提出问题，然后让他们说。关于如何更有效地采访，你还学到了什么？

---

### [01:02:54] Jessica Livingston

**English:**
Remember, I've been interviewing people since YC started because I was working on Founders at Work simultaneously when we started YC, and so that was a collection of interviews. And back then, I can't say I was that good at it. I've gotten much better. And then I've since gone, I used to do a lot of interviews at startup school on stage with people, and now the podcast. I think one thing that is that the guests trust me. They trust that I'm not going to try to have a gotcha moment. I'm not trying to lure them into saying anything controversial. Do I love it when they say something that hasn't been said before? Yes. But I'm not trying to trick them.
(01:03:37):
And just like you, I tell them, "You will have a chance to review this before it goes public." And I think that disarms people and they say, "Okay, I can open up because I know if I regret saying something, it's not like talking to a reporter who's going to publish it." I care about them. I care about making them look good, and I'd never want to betray their trust, and they know that. So that's part of it too. For me, with the podcast, I have some questions that I do ahead of time just so I have something down, but I also just let the conversation go where it's going, and we get into some random tangents that I find are really fascinating.

**中文翻译:**
记住，从 YC 开始我就一直在采访别人，因为在 YC 成立的同时，我正在写《Founders at Work》，那是一本采访集。当时我不能说我很擅长。现在我进步了很多。后来我在创业学校（Startup School）的舞台上做过很多采访，现在又做播客。我认为有一点是嘉宾信任我。他们相信我不会搞那种“陷阱式提问”（gotcha moment）。我不会诱导他们说出任何有争议的话。我喜欢他们说出以前没说过的话吗？当然。但我不会试图算计他们。
(01:03:37):
和你一样，我会告诉他们：“在发布之前，你有机会审核内容。”我认为这能让人们放下戒备，他们会觉得：“好吧，我可以敞开心扉，因为我知道如果我后悔说了什么，这不像是在和记者谈话，他们会直接发出去。”我关心他们，我想让他们表现得体，我绝不想辜负他们的信任，他们也知道这一点。所以这也是原因之一。对我来说，做播客时我会提前准备一些问题，以便心里有数，但我也随性而谈，我们会聊到一些随机的话题，我觉得那非常迷人。

---

### [01:04:26] Lenny Rachitsky

**English:**
Is there a story that stand out to you just that sticks with you from the interviews that just like, "Wow, that was such an incredible story someone shared with me," or, "a lesson learnt."?

**中文翻译:**
在采访中，有没有哪个故事让你印象特别深刻，让你觉得“哇，某人分享的故事太不可思议了”，或者“学到了重要的一课”？

---

### [01:04:29] Jessica Livingston

**English:**
The podcast that really sticks with me is the Parker Conrad episode, of Rippling, but we spent a lot of time on Zenefits because if you didn't follow that story years ago, the press annihilated him. And in talking to him, I learned why. There was a smear campaign paid for by someone still at Zenefits. There were legal threats made to force him to sign this legal document that would allow them to have a non-compete in California so that he couldn't another company, basically making his life miserable, disparaging him. Stories planted in the press. And I had him come on and I had him tell what really happened.
(01:05:29):
And even I, who have seen so much shit behind the scenes with startups in Silicon Valley over the years, stuff you just couldn't believe. This was unbelievable. And the thing that really sticks with me is that no reporter ever, maybe no reporters listened to it, but no one said, "Hey, I got that wrong years ago. I shouldn't have written that. That wasn't true. Let me set the record straight." So he doesn't care. Parker's moved on, he's successful with Rippling, he doesn't think about this stuff. But I do. I care about justice. And it was a horrible thing that was done to him and it affected his health, it affected his life, and I just am glad to have sort of been a conduit to set the record straight.

**中文翻译:**
让我记忆犹新的是 Rippling 的帕克·康拉德那一集。我们花了很多时间聊 Zenefits，因为如果你几年前没关注那个故事，媒体当时简直把他毁了。在和他交谈中，我了解了原因。当时有一场由 Zenefits 内部人员资助的抹黑行动。他们通过法律威胁强迫他签署法律文件，以便在加州对他实施竞业禁止，让他无法创办另一家公司，基本上是想让他生活悲惨，诋毁他。媒体上到处都是被安插的故事。我请他来，让他讲述真相。
(01:05:29):
甚至是我，这些年来在硅谷创业圈见过这么多幕后烂事，有些你简直不敢相信。但这件事还是让人难以置信。最让我耿耿于怀的是，从来没有记者（也许没有记者听过这期播客）站出来说：“嘿，我几年前搞错了，我不该写那些，那不是真的，让我来澄清事实。”帕克本人并不在乎，他已经走出来了，Rippling 做得很成功，他不再想这些事。但我介意。我关心正义。对他所做的事太可怕了，影响了他的健康和生活，我很高兴能成为一个澄清事实的渠道。

---

### [01:06:24] Lenny Rachitsky

**English:**
That's an awesome episode maybe for people to start with if they want to check out the podcast. And then generally, I just love this rise of ways for tech people to share their story without this drive to create clicks and create gotcha moments and things like that. Just this, I think people call it techno optimism, this idea of just like tech is great, technology is doing great things for us, let's just tell these stories in a really positive way versus look at all the harm they're causing, technology stop, slow it down.

**中文翻译:**
对于想听这个播客的人来说，这可能是一个很好的开始。总的来说，我喜欢这种让技术人员分享故事的方式，没有那种为了点击率而制造陷阱的冲动。这就是人们所说的“技术乐观主义”（techno optimism），认为技术很棒，技术正在为我们做伟大的事情。让我们以积极的方式讲述这些故事，而不是只盯着它们造成的伤害，喊着“技术停下，慢一点”。

---

### [01:06:50] Jessica Livingston

**English:**
And I just want to have conversations that I personally find interesting. I'm very selfish about it, Lenny. As long as I have an interesting conversation, I tell Carolyn this all the time, as long as we have 20 listeners, that's all I need. 20 really interested listeners, we'll keep doing it.

**中文翻译:**
我只想进行我个人觉得有趣的对话。莱尼，在这方面我很自私。只要对话有趣，我总是告诉卡罗琳，只要我们有 20 个听众就足够了。只要有 20 个真正感兴趣的听众，我们就会继续做下去。

---

### [01:07:10] Lenny Rachitsky

**English:**
I love that attitude. I wish I had that same feeling. What I look for is, is it growing? That's the thing. I'm like, is it growing at least? If it's growing, no matter what it is, I'm feeling good.

**中文翻译:**
我喜欢这种态度。我希望我也有同样的感觉。我关注的是：它在增长吗？就是这样。我会想，至少它在增长吗？只要在增长，不管是什么，我感觉都很好。

---

### [01:07:20] Jessica Livingston

**English:**
I need to be a little bit more like that. I don't know any of my statistics. What statistic, you tell me as an experience podcaster, what statistics should I have taped up to my mirror every day and track?

**中文翻译:**
我需要多学学你。我完全不知道自己的数据。作为一名资深播客，你告诉我，我每天应该把什么数据贴在镜子上追踪？

---

### [01:07:34] Lenny Rachitsky

**English:**
There's the correct one and there's a simple one that I look at, which is just downloads of the episode. It's the most basic one you see everywhere. And downloads is a weird one because they might download and not listen to it, but that's just the one that podcast platforms tell you how many people have downloaded it. And that's the one that just tells you generally, are people listening? Are people continuing to listen? Did they remove it from their phone? In theory, you should be looking at retention like how many people are finishing the podcast episode?

**中文翻译:**
有一个“正确”的指标，还有一个我关注的简单指标，那就是单集下载量。这是到处都能看到的最基本的指标。下载量有点奇怪，因为人们可能下载了但不听，但这是播客平台告诉你的有多少人下载了。它能大致告诉你：人们在听吗？人们在持续听吗？他们把它从手机里删了吗？理论上，你应该关注留存率，比如有多少人听完了整集播客。

---

### [01:08:02] Jessica Livingston

**English:**
Can you tell that though? I thought these platforms don't share that with you.

**中文翻译:**
你能看到那个吗？我以为平台不分享这些数据。

---

### [01:08:06] Lenny Rachitsky

**English:**
Some do, some do. Spotify gives you some of that. Apple, gives you. The worst part about podcasting is the analytics are extremely bad and inconsistent, but there are some of those stats. The other one, okay, here's one to pay attention to, is number of subscribers on the different platforms, people that follow you. That actually is a really important metric to watch.

**中文翻译:**
有些会提供。Spotify 会给你一些数据，Apple 也会。播客最糟糕的一点是分析数据非常差且不一致，但确实有一些统计数据。另一个值得关注的是不同平台上的订阅人数，也就是关注你的人数。这实际上是一个非常重要的指标。

---

### [01:08:26] Jessica Livingston

**English:**
Number of subscribers, okay. One thing I also, this is just my personality, I can't bring myself to do what I want to, is ask people if you like The Social Radars, please subscribe and leave a rating and a review. I would do anything to have people leave rating and reviews.

**中文翻译:**
订阅人数，好的。还有一件事，这纯粹是我的个性使然，我总是开不了口要求别人：“如果你喜欢《The Social Radars》，请订阅并留下评分和评论。”但我真的很希望人们能留下评分和评论。

---

### [01:08:46] Lenny Rachitsky

**English:**
If you're listening and you either checking out the podcast or you're already a listener, please leave a rating and a review and subscribe and follow.

**中文翻译:**
如果你正在听，无论你是刚开始关注还是老听众，请留下评分和评论，并订阅关注。

---

### [01:08:54] Jessica Livingston

**English:**
Thank you. Can I ask you a question about podcasting really quickly?

**中文翻译:**
谢谢。我能很快问你一个关于播客的问题吗？

---

### [01:08:58] Lenny Rachitsky

**English:**
Sure, let's do it.

**中文翻译:**
当然，请讲。

---

### [01:08:59] Jessica Livingston

**English:**
When you do a podcast, after you hang up with a person, can you tell, do you have a gut instinct like, "Oh, that was a really great "?

**中文翻译:**
当你录完播客，挂断电话后，你能感觉到吗？你会有直觉说“噢，那次录得真棒”吗？

---

### [01:09:07] Lenny Rachitsky

**English:**
What's interesting is, the ones that I sometimes think, holy moly, that was incredible, don't do as well as I would think. And sometimes ones I think didn't go amazing, actually do a lot better than I think. And I think there's a difference between the energy and the fun of it versus the content and the interesting value of the actual conversation. And so sometimes you feel like that was so fun, so good, I loved it, but people are like, "Nah, I didn't learn anything." So those are interesting. That's something I've learned.

**中文翻译:**
有趣的是，有时我觉得“天哪，那次太精彩了”的剧集，表现却不如预期。而有时我觉得表现平平的，结果却比我想象的好得多。我认为现场的能量和趣味性，与实际对话的内容和价值之间是有区别的。有时你觉得过程很有趣、很棒，你很喜欢，但听众可能会觉得：“不，我没学到任何东西。”所以这很有意思，这是我学到的。

---

### [01:09:37] Jessica Livingston

**English:**
Okay. Yeah, because people come to yours expecting to learn things. Now I'm a little nervous, I'm going to get axed because I'm not teaching them anything valuable.

**中文翻译:**
好吧。是的，因为人们听你的播客是希望能学到东西。现在我有点紧张了，我会因为没教给他们任何有价值的东西而被“砍掉”。

---

### [01:09:46] Lenny Rachitsky

**English:**
You're so modest. This was incredible. I think we've taught people a lot of really important and really actionable things and I know you don't think you did, but you did. And with that, we've covered a ton of ground. We've talked through every single thing that I was hoping we talked through. Is there anything else you wanted to share or maybe leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
你太谦虚了。这次谈话非常精彩。我认为我们教给了大家很多非常重要且可操作的东西，我知道你不这么认为，但你确实做到了。到目前为止，我们已经涵盖了大量内容。我们聊完了我希望聊的每一件事。在进入令人兴奋的闪电问答环节之前，你还有什么想分享或留给听众的吗？

---

### [01:10:08] Jessica Livingston

**English:**
No, I mean, honestly I can't think of... I think I windbagged enough.

**中文翻译:**
没有了，老实说我想不出……我觉得我已经说得够多了。

---

### [01:10:14] Lenny Rachitsky

**English:**
This was incredible. You talked exactly the right amount of time. With that, we've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
这太棒了。你说话的时间恰到好处。现在，我们进入了非常刺激的闪电问答环节。我有六个问题要问你。准备好了吗？

---

### [01:10:24] Jessica Livingston

**English:**
Ready as I'll ever be.

**中文翻译:**
准备好了。

---

### [01:10:26] Lenny Rachitsky

**English:**
Okay. First question, what are two or three books that you recommended most to other people?

**中文翻译:**
好。第一个问题，你向别人推荐最多的两三本书是什么？

---

### [01:10:31] Jessica Livingston

**English:**
Well, I definitely would recommend my first, second and third books would all be P.G. Wodehouse books. Do you know him as an author?

**中文翻译:**
嗯，我肯定会推荐 P.G. 沃德豪斯（P.G. Wodehouse）的书，我的前三名都是他的。你知道这位作家吗？

---

### [01:10:40] Lenny Rachitsky

**English:**
No.

**中文翻译:**
不知道。

---

### [01:10:41] Jessica Livingston

**English:**
Ask Jeeves. Okay, so he was an old school author and he wrote the Ask Jeeves books about the Butler and Bertie Wooster.

**中文翻译:**
《万能管家》（Ask Jeeves）。他是一位老派作家，写了关于管家和伯蒂·伍斯特（Bertie Wooster）的《万能管家》系列。

---

### [01:10:52] Lenny Rachitsky

**English:**
Not the search engine.

**中文翻译:**
不是那个搜索引擎。

---

### [01:10:54] Jessica Livingston

**English:**
They're so funny and fabulously written. His use of words makes me laugh so hard. And so I would specifically recommend the starter books that... He wrote tons of books and he lived till he was like a hundred. Start with Very Good, Jeeves or Right ho, Jeeves, Carry On, Jeeves. Those three are really good books. And then I tend to read, so Paul's the big reader in the family, he reads riveting books on Roman grains and anything that has to do with medieval history. I tend to read biographies of people, especially musicians, especially English musicians, strangely. And so I've recommended, to a lot of people, if you really want a good autobiography, because I sometimes hate autobiographies because I feel like people hold back and don't really share everything. Keith Richards, his autobiography called Life, is really good if you're a fan of the Rolling Stones at all. That was really good.
(01:12:04):
And then I recently read Barbra Streisand's biography called, I think it's called, My Name is Barbra something, and I kept thinking as I was reading this, every female founder should read this book. And you're looking at me like that's so random, but it's because she was such a success within this totally male-dominated world of Hollywood and just treated like garbage and dismissed and called a diva when she was very particular about something. Whereas, a man would be called a great director and she was called a diva, and I felt like every woman should just read this to inspire them. It was such a great book. Long, but very good.

**中文翻译:**
它们非常幽默，文笔极佳。他的用词总能让我开怀大笑。我会特别推荐入门书……他写了大量的书，活到了将近一百岁。可以从《好样的，吉夫斯》（Very Good, Jeeves）、《没错，吉夫斯》（Right ho, Jeeves）或《加油，吉夫斯》（Carry On, Jeeves）开始。这三本都非常棒。另外我倾向于读传记。保罗是家里的读书大户，他读关于罗马谷物或任何与中世纪历史有关的引人入胜的书。我倾向于读人物传记，尤其是音乐家，奇怪的是，尤其是英国音乐家。我向很多人推荐过，如果你真的想要一本好的自传（我有时讨厌自传，因为我觉得人们会有所保留，不分享全部真相），基思·理查兹（Keith Richards）的自传《Life》非常棒，如果你是滚石乐队的粉丝的话。那本书真的很好。
(01:12:04):
最近我读了芭芭拉·史翠珊（Barbra Streisand）的传记，书名好像叫《My Name is Barbra》之类的。读的时候我一直在想，每个女性创始人都应该读读这本书。你看着我，觉得这很随机，但这是因为她在好莱坞这个完全由男性主导的世界里获得了巨大的成功，却被当作垃圾对待，被轻视，当她对某些细节很挑剔时就被称为“戏精”（diva）。而如果是男人，就会被称为伟大的导演。我觉得每个女性都应该读读这本书来激励自己。这是一本伟大的书，虽然很长，但非常好。

---

### [01:12:52] Lenny Rachitsky

**English:**
Incredible recommendations. Next question, do you have a favorite recent movie or TV show?

**中文翻译:**
非常棒的推荐。下一个问题，你最近有喜欢的电影或电视剧吗？

---

### [01:12:57] Jessica Livingston

**English:**
I don't tend to watch recent movies. I watch old school movies from the 50s through the 90s and stuff. My favorite new TV show, just off the top of my head right now, is Clarkson's Farm. Have you heard of that, on Amazon?

**中文翻译:**
我不怎么看最近的电影。我看 50 年代到 90 年代的老电影。我现在能想到的最喜欢的电视剧是《克拉克森的农场》（Clarkson's Farm）。你在亚马逊上听说过吗？

---

### [01:13:12] Lenny Rachitsky

**English:**
Nope.

**中文翻译:**
没有。

---

### [01:13:13] Jessica Livingston

**English:**
Jeremy Clarkson, he's in the show called Top Gear. I don't watch that. But he lives out in the English countryside. He has a farm, and he decided that he'd farm it. And the whole show is about him getting into this business that he knows nothing about, everything goes wrong, but it is hysterical and heartbreaking at the same time. I've learned so much about England and about where I live and the crops that are grown, and how hard it is for farmers. He's really shone a light on the difficulty of being a farmer these days and it's fabulous. Clarkson's Farm. And it has some bad language in it, but I do recommend that kids watch it, because it's just a good show to watch as a family if you can deal with a little foul language. The Brits drop a lot of F-bombs.

**中文翻译:**
杰里米·克拉克森（Jeremy Clarkson），他主持过《顶级跑车》（Top Gear）。我不看那个。但他住在英国乡村，他有一个农场，并决定亲自经营。整个节目讲述了他进入一个完全陌生的行业，各种状况百出，既让人捧腹大笑又让人心碎。我学到了很多关于英国、关于我居住的地方、关于农作物以及农民有多辛苦的知识。他真实地展现了当今农民的困境，非常精彩。就是《克拉克森的农场》。里面有一些脏话，但我还是建议孩子们看，因为如果你能忍受一点粗口，这是一个很好的家庭节目。英国人确实爱说脏话。

---

### [01:14:09] Lenny Rachitsky

**English:**
Do you have a favorite life motto that you often come back to, share with people, find useful in work or in life?

**中文翻译:**
你有没有最喜欢的人生格言，是你经常想起、分享给别人，并觉得在工作或生活中很有用的？

---

### [01:14:16] Jessica Livingston

**English:**
It's so boring, but I always try to treat people the way I'd like to be treated myself, really, is fundamental life lesson.

**中文翻译:**
这很无聊，但我总是努力以我希望被对待的方式对待他人。真的，这是最基本的人生教训。

---

### [01:14:26] Lenny Rachitsky

**English:**
It's like boring but so powerful and important. And I try to live that same way. And I think it's a good reminder to people, sometimes the most, I think it was Michael Pollan had said that, "Cliches are cliches because they're so true." They're so true, we're tired of hearing it. Sometimes it's important to be reminded of them. Who's most influenced you in your career? Who do you think of when you're like, this person's really had the most influence on me?

**中文翻译:**
虽然听起来无聊，但却非常强大且重要。我也努力以同样的方式生活。我认为这对人们是一个很好的提醒。我想是迈克尔·波伦（Michael Pollan）说过：“陈词滥调之所以成为陈词滥调，是因为它们太正确了。”它们太正确了，以至于我们听腻了。有时被提醒一下很重要。在你的职业生涯中，谁对你的影响最大？当你想到“这个人对我影响最大”时，你会想到谁？

---

### [01:14:51] Jessica Livingston

**English:**
In my career, I definitely have to say my husband, Paul Graham. I've just learned so much from him over the years, and he's such a good person and I think people who know him, all know that he is. It's just, he has such a big online personality either through Twitter or through his essays. And so he has a lot of people that don't like him, because he also speaks what he believes. And he is not afraid to say anything if he believes it's true and needs to be said. Whereas, I'm the exact opposite. I'm like, "Oh, I'm not going near that. I'm not touching that with a ten-foot pole. I don't even want to get in someone's crosshairs or fight with someone." And I admire that so much. There's so much that he's done with Y Combinator and just in our personal life that is just so admirable and I've really learned a lot from him.
(01:15:53):
It's such a boring thing to learn from your husband, but at the same time, I'm going to extend this, I'm going to windbag a little bit longer. I have learned so much from the founders that we funded. Some of them are just incredible people and have been through so much and survived so much and built these amazing companies that I couldn't have even imagined when we funded them, that these companies would be as successful as they are, and they're all, so many of them, are just great people. And they now teach me things, honestly. Like Brian Chesky teaches me things. The student has become the master. He knows so much more about me and running a business, and I often will go to him for advice. And so I'm really lucky to be surrounded by so many smart people in the startup world, because as a startup nerd, I could talk about startups and think about them all the time, and it's so great to have all these people around sort of lifting me up.

**中文翻译:**
在职业生涯中，我肯定得说是我的丈夫保罗·格雷厄姆。这些年来我从他身上学到了太多，他是个非常好的人，认识他的人都知道。只是他在网上（推特或文章中）的个性太鲜明了。所以有很多人不喜欢他，因为他总是直言不讳。如果他认为某件事是真的且需要说出来，他就不怕说任何话。而我恰恰相反，我会想：“噢，我才不碰那个，离得越远越好。我甚至不想成为别人的目标或与人争吵。”我非常钦佩他这一点。他在 YC 以及我们的个人生活中所做的一切都令人钦佩，我真的从他身上学到了很多。
(01:15:53):
从丈夫身上学习听起来挺无聊的，但与此同时，我要扩展一下，再啰嗦几句。我也从我们资助的创始人身上学到了很多。他们中有些人简直不可思议，经历了那么多，挺过了那么多，建立了这些了不起的公司。当我们资助他们时，我甚至无法想象这些公司会如此成功。他们中很多人都是非常优秀的人。老实说，他们现在反过来教我东西。比如布莱恩·切斯基会教我。学生已经变成了大师。他比我更懂得经营企业，我经常向他寻求建议。所以我很幸运，在创业世界里被这么多聪明人包围着。作为一个创业发烧友，我可以一直谈论创业、思考创业，有这么多人在身边激励我，感觉太棒了。

---

### [01:16:58] Lenny Rachitsky

**English:**
Would you believe that a cereal experience led to a 92 billion business today? I just looked it up, how big they've gotten.

**中文翻译:**
你能相信一次麦片盒的经历成就了今天价值 920 亿美元的业务吗？我刚刚查了一下他们现在的规模。

---

### [01:17:09] Jessica Livingston

**English:**
Honestly, I wouldn't. I wish I could say, "Oh, I knew they'd be this big." But the truth is, with all of the super successful startups, yeah you can remember feeling very positively about them and certainly feeling like, as they went along in the first few years, like they're doing really well, they're really determined, they're doing a great job, but you just never really think. They themselves, probably didn't realize that they'd ever be that big. Let's face it. That's just the way startups are.

**中文翻译:**
老实说，我不信。我希望我能说：“噢，我早就知道他们会做这么大。”但事实是，对于所有超级成功的初创公司，你确实记得对他们感觉非常正面，在最初几年里觉得他们做得很好、很有决心、干得很棒，但你永远不会想到这种规模。甚至他们自己可能也没意识到会做这么大。让我们面对现实吧，创业就是这样。

---

### [01:17:43] Lenny Rachitsky

**English:**
Okay. Here's the actual final question. Is there a fun story of early days YC, whether it's with Airbnb founders or Paul or anything that comes to mind as just like, wow, what a different time that was, or what a surprising thing that happened then?

**中文翻译:**
好。这是最后一个问题。有没有关于 YC 早期的趣事？无论是关于 Airbnb 创始人、保罗还是任何让你想起“哇，那时候真不一样”或“当时发生了件令人惊讶的事”的故事？

---

### [01:17:58] Jessica Livingston

**English:**
It's funny you ask, because actually one of my ideas I've had lately is that I want to start thinking about writing sort of a YC biography kind of book. I don't know when the time is, but the point is, I have to remember things because it's hard. When it's been 20 years to go way back, you have to remember specific things that happened. YC, I just remember the early days being so magical and so pure. When we started, no one knew about us, no one was bothering us. We just did what we were doing with no distractions. We were helping, albeit a very small group of founders, eight in that first summer, we were just doing what we loved doing and growing organically. And no one was scrutinizing us or blaming us for things or writing negative news stories about us. The negative stories in the press, because I'm a people-person and I'm very sensitive, Paul's not as sensitive as me, and so he doesn't care if there's a negative story in the press that's not true.
(01:19:09):
I do. It really affected me, and I hated when we got big enough that people would lie about us and say bad things. So I look back fondly when we first started of it was the most fun time of my life, the most productive time of my life, didn't have kids then, and I could just help the founders and learn about all these exciting things that happened in the startup world, because it was new to me then, the startup world was new when we started Y Combinator, so I had a lot of learning to do. And I met all these cool people, and it was just very authentic, no one was doing it to be cool.

**中文翻译:**
你问得很有趣，因为我最近确实有一个想法，想写一本类似 YC 传记的书。我不知道什么时候动笔，但重点是我必须回忆起那些事，这很难。20 年后再回首，你必须记住发生的具体细节。我只记得 YC 早期是那么神奇、那么纯粹。当我们开始时，没人知道我们，没人打扰我们。我们只是心无旁骛地做着自己的事。我们在帮助一小群创始人（第一个夏天只有 8 个），我们只是在做自己喜欢的事，并有机地成长。没有人审视我们，没有人指责我们，也没有人写关于我们的负面新闻。关于媒体上的负面报道，因为我是一个感性的人，非常敏感（保罗不像我这么敏感，他不在乎媒体上是否有不真实的负面报道）。
(01:19:09):
但我很在乎。这真的影响了我。我讨厌当我们规模变大后，人们开始撒谎诋毁我们。所以我深情地回忆起刚开始的时候，那是我一生中最快乐、最高效的时光。那时我还没有孩子，我可以全身心地帮助创始人，学习创业世界里发生的各种令人兴奋的事。因为当时对我来说一切都是新鲜的，当我们创办 YC 时，创业世界对我来说是全新的，所以我有很多东西要学。我遇到了所有这些酷人，一切都非常真实，没有人是为了装酷而创业。

---

### [01:19:56] Lenny Rachitsky

**English:**
Was there a moment when you felt like YC was working? When it felt like, wow, maybe this is going to make it?

**中文翻译:**
有没有哪一个时刻让你觉得 YC 成功了？让你觉得“哇，也许这行得通”？

---

### [01:19:56] Jessica Livingston

**English:**
There were sort of two moments that I remember I felt like YC was working, because remember, we started Y Combinator as 100% like an experiment. Could we fund younger founders with small amounts of money? That was it. Then that summer we created this batch investment idea, and then that became the idea of funding them in batches. And that was the first aha moment was after that first summer when we invited people to participate in the Summer Founders Program, which is what it was called. And remember, that first summer had Sam Altman, Emmett Shear, Justin Kan, Alexis and Steve of Reddit, they were in the first batch. And the batch thing worked really well because they all became friends. We could have dinner every week, and bring in guest speakers and then introduce them to investors at demo day, and that whole batch-investing thing was an aha moment and we said, "Oh my gosh, let's keep doing this. This really works." And so that was a moment where we knew we were onto something, and that's when we then did it in California in the winter.
(01:21:11):
But the second big moment was probably, I remember it was like a year later, and no reporter would write about us, investors really didn't think that much of us, but I remember when Reddit got bought by Condé Nast in 2006. It was that, and then at the same time, I think it was like Charles River Ventures or one of these Boston, maybe it wasn't even Boston, but it was a VC firm, did the seed program where they invested maybe a 100K in startups, and the press loved that. They wrote all about this $100,000 investment, and they'd sort of mentioned Y Combinator as doing small investments. And then that, coupled with the Reddit press, sort of made us feel like, oh my gosh, we are sort of legitimate, and the eyes of outsiders became sort of aware of who we were. And I sort of felt like we've arrived, we've been in the press, people are finally paying attention.

**中文翻译:**
我记得有两个时刻让我觉得 YC 行得通。记住，我们创办 YC 时完全是把它当作一个实验：我们能不能用少量的钱资助年轻的创始人？仅此而已。然后那个夏天我们想出了“批量投资”的点子，也就是成批地资助他们。第一个“顿悟时刻”是在第一个夏天之后，当时我们邀请人们参加“夏季创始人计划”（当时的名字）。记住，第一批里有山姆·奥特曼（Sam Altman）、埃米特·希尔、贾斯汀·坎（Justin Kan）、Reddit 的亚历克西斯（Alexis）和史蒂夫（Steve）。批量模式运作得非常好，因为他们都成了朋友。我们可以每周一起吃晚饭，邀请演讲嘉宾，然后在演示日把他们介绍给投资者。整个批量投资模式是一个巨大的突破，我们说：“天哪，让我们继续做下去，这真的有效。”那是我们意识到自己抓住了某种机遇的时刻，于是我们冬天在加州又做了一次。
(01:21:11):
第二个重大时刻大概是一年后。当时没有记者报道我们，投资者也不怎么看好我们。但我记得 2006 年 Reddit 被康泰纳仕（Condé Nast）收购时。那是其一。与此同时，我想是 Charles River Ventures 或波士顿的一家风投公司启动了一个种子计划，向初创公司投资 10 万美元，媒体对此疯狂报道。他们大肆宣传这 10 万美元的投资，并顺带提到了 YC 也在做小额投资。那件事加上 Reddit 的报道，让我们觉得：“天哪，我们算是‘名正言顺’了。”外界开始意识到我们的存在。我感觉我们终于“登场”了，媒体报道了我们，人们终于开始关注了。

---

### [01:22:17] Lenny Rachitsky

**English:**
That's amazing. And it's funny that Reddit just went public, it's kind of the other side of that coin.

**中文翻译:**
太神奇了。有趣的是 Reddit 刚刚上市，这就像是硬币的另一面。

---

### [01:22:21] Jessica Livingston

**English:**
I know. Pretty impressive. Definitely didn't necessarily think that was going to be happening.

**中文翻译:**
我知道。非常了不起。当时确实没预料到会发生这种事。

---

### [01:22:27] Lenny Rachitsky

**English:**
I know you have to run, but I can't help but ask around what you just talked about where you decided to invest in batches. You wrote this really interesting point that none of us had any experience angel investing, and that's where the idea of funding startups and batches came from. We decided to fund a bunch of startups at once during the summer so that we could learn how to invest. And I love that your inexperience in doing it, created this structure. That unique weakness/strength is what led to the way YC operates, and I think that's really interesting.

**中文翻译:**
我知道你得走了，但我忍不住想问问你刚才提到的批量投资。你写过一个非常有趣的观点：当时你们谁都没有天使投资的经验，这就是批量资助初创公司点子的由来。你们决定在夏天一次性资助一堆初创公司，这样你们就能学习如何投资。我喜欢这种因为“缺乏经验”而创造出这种结构的故事。这种独特的弱点（同时也是优点）造就了 YC 的运作方式，我觉得这非常有趣。

---

### [01:22:59] Jessica Livingston

**English:**
Yeah, we definitely wanted to learn more about how to be investors, so that's when we decided to do this summer founders program where we could invest in a whole bunch at once, and then the plan was to go to asynchronous investing like normal investors, but we realized that there was something magical about this batch thing. So sometimes, I always say we love domain experts, but sometimes maybe ignorance is sort of bliss and you just discover new things.

**中文翻译:**
是的，我们确实想学习如何成为投资者，所以我们决定做这个夏季创始人计划，一次性投资一大批。原本的计划是之后像普通投资者一样进行异步投资，但我们意识到这种“批量”模式中蕴含着某种魔力。所以有时我总说我们喜欢领域专家，但有时“无知也是一种福气”，让你能发现新事物。

---

### [01:23:27] Lenny Rachitsky

**English:**
Jessica, this was everything I hoped it would be. We covered so much ground. I think people are going to love it no matter what you think.

**中文翻译:**
杰西卡，这次谈话完全达到了我的预期。我们聊了非常多的内容。我想无论你怎么想，大家都会喜欢这一集的。

---

### [01:23:33] Jessica Livingston

**English:**
Oh, good. Good, good, good.

**中文翻译:**
噢，那就好。太好了。

---

### [01:23:35] Lenny Rachitsky

**English:**
Two final questions. Where can folks check out The Social Radars and anything else you want people to know about? And how can listeners be useful to you?

**中文翻译:**
最后两个问题。大家可以在哪里收听《The Social Radars》？还有什么你想让大家知道的吗？听众们能为你做些什么？

---

### [01:23:41] Jessica Livingston

**English:**
Well, you check out The Social Radars on all the podcast platforms; Apple, Spotify, Amazon, all of those. And then there's a website, socialradars.com. And they can be helpful by just listening to it and spreading the word because I don't do any marketing for it besides posting on Twitter, just because it's expensive doing a podcast and stuff. So I don't do any marketing. So if it resonates with you, if you find an episode interesting, please spread the word and write a review and rating.

**中文翻译:**
你可以在所有的播客平台收听《The Social Radars》，包括 Apple、Spotify、Amazon 等。还有一个网站 socialradars.com。大家可以通过收听和传播来帮助我，因为除了在推特上发帖，我没做任何营销，毕竟做播客已经很贵了。所以如果你觉得有共鸣，如果你觉得某一集很有趣，请帮忙传播，并写下评论和评分。

---

### [01:24:21] Lenny Rachitsky

**English:**
I was just going to add that, I'm glad you threw that in there. Jessica, thank you so much for being here.

**中文翻译:**
我正想补充这一点，很高兴你提到了。杰西卡，非常感谢你能来。

---

### [01:24:25] Jessica Livingston

**English:**
Thank you so much, Lenny. It was a lot of fun.

**中文翻译:**
非常感谢，莱尼。很有趣。

---

### [01:24:28] Lenny Rachitsky

**English:**
Same for me. Bye, everyone.

**中文翻译:**
我也是。大家再见。

---

### [01:24:30] Jessica Livingston

**English:**
Bye.

**中文翻译:**
再见。

---

### [01:24:32] Lenny Rachitsky

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得内容有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。