# Jiaona Zhang - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Jiaona Zhang (JZ).

---

### [00:00:00] Jiaona Zhang

**English:**
I think it's really important to become really good at and also known for something. You could be known for shepherding like the most complex launches because you're just so good at quarterbacking. Working with go-to-market teams and cross-functional stakeholders that could be like your thing. You could be known for working on the most technically complex problems, find something that you can be really, really good at. And the reason I give that advice is because when you do that, you can crush the projects that you get because you're making a name for yourself, reputation, and then you are giving more responsibility. People tend to flock and give responsibility to the people that are known for being excellent at something.

**中文翻译:**
我认为变得非常擅长某件事并因此而出名是非常重要的。你可能因为擅长“统筹全局”（quarterbacking）而以引导最复杂的发布活动著称。与进入市场（GTM）团队和跨职能利益相关者合作，这可以成为你的招牌。你也可以因为处理最复杂的技术问题而闻名，总之要找到一件你能做得非常非常出色的事情。我之所以给出这个建议，是因为当你做到这一点时，你就能出色地完成所接手的项目，因为你在为自己建立名声和声望，随后你会被赋予更多的责任。人们往往会聚集在那些以卓越著称的人身边，并将责任托付给他们。

---

### [00:00:43] Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful products. Today my guest is JZ. JZ is senior vice president of product at Webflow. She's also a lecture at Stanford, teaching a course on product management. Before this, she was senior director of product management at WeWork, a longtime product leader at Airbnb, where I got to work with JZ for a number of years and she's also PM at Dropbox and at a gaming company called Pocket Gems.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中辛苦换来的经验。今天的嘉宾是 JZ（Jiaona Zhang）。JZ 是 Webflow 的产品高级副总裁。她还是斯坦福大学的讲师，教授产品管理课程。在此之前，她是 WeWork 的产品管理高级总监，也是 Airbnb 的资深产品领导者（我在那里和 JZ 共事了好几年），她还曾在 Dropbox 以及一家名为 Pocket Gems 的游戏公司担任产品经理。

---

### [00:01:12] Lenny

**English:**
In her conversation, we dig into the most common mistakes early product managers make in their career. Plus JZ's biggest product mistake. We cover the concept of minimal lovable products versus minimal viable products. We talk about JZ's unique frameworks for road mapping and prioritization and OKRs and her take on how to structure your first 90 days as a product leader at a new company, plus what she's learned from her wild year at WeWork. Also, the best advice she's ever gotten around product and leadership and the story of Airbnb Plus and where it went wrong. I've been hoping to get JZ on the podcast for a while and I'm really happy that we finally made this happen. With that, I bring you JZ after a short word from our sponsors.

**中文翻译:**
在这次对话中，我们深入探讨了初级产品经理在职业生涯中最常犯的错误，以及 JZ 自己犯过的最大的产品错误。我们讨论了“最小讨喜产品”（Minimal Lovable Product, MLP）与“最小可行性产品”（Minimal Viable Product, MVP）的概念。我们还聊到了 JZ 独特的路线图规划（Roadmapping）、优先级排序和 OKR 框架，以及她对于作为产品领导者进入新公司后如何安排前 90 天的见解，还有她在 WeWork 那疯狂的一年中学到的东西。此外，还有她收到的关于产品和领导力的最佳建议，以及 Airbnb Plus 的故事及其失败的原因。我一直希望能邀请 JZ 来播客，很高兴我们终于实现了。在听完赞助商的简短介绍后，让我们开始与 JZ 的对话。

---

### [00:01:53] Lenny (Sponsor Message)

**English:**
Today's episode is brought to you by Brave Search and their newest product, the Brave Search API, an independent global search index you can use to power your search or AI apps. If your work involves AI, then you know how important new data is to train your LLMs and to power your AI applications. You might be building an incredible AI product, but if you are using the same datasets as your competitors to train your models, you don't have much of an advantage. Brave Search is the fastest growing search engine since Bing, and it's 100% independent from the big tech companies. Its index features billions of pages of high quality data from real humans and it's constantly updated thanks to being the default search engine in the Brave browser.

**中文翻译:**
本期节目由 Brave Search 及其最新产品 Brave Search API 赞助。这是一个独立的全球搜索索引，你可以用它来驱动你的搜索或 AI 应用。如果你的工作涉及 AI，那么你一定知道新数据对于训练大语言模型（LLM）和驱动 AI 应用有多重要。你可能正在构建一个了不起的 AI 产品，但如果你使用与竞争对手相同的训练数据集，你就没有太多优势。Brave Search 是自 Bing 以来增长最快的搜索引擎，且 100% 独立于大型科技公司。它的索引包含数十亿页来自真实人类的高质量数据，并且由于它是 Brave 浏览器的默认搜索引擎，数据会不断更新。

---

### [00:02:35] Lenny (Sponsor Message)

**English:**
If you're building products with search capabilities, you're probably experiencing soaring API costs or lack of viable global alternatives to Bing or Google. It's only going to be become harder to afford these challenges. The Brave Search API gives you access to its novel web scale data with competitive features, intuitive structuring and affordable costs. AI devs will particularly benefit from data containing thorough coverage of recent events. Lenny's podcast listeners can get started testing the API for free at brave.com/lenny. That's brave.com/lenny.

**中文翻译:**
如果你正在构建具有搜索功能的产品，你可能正面临 API 成本飙升，或者缺乏除 Bing 或 Google 之外可行的全球替代方案。应对这些挑战只会变得越来越难。Brave Search API 让你能够以具有竞争力的功能、直观的结构和实惠的价格访问其新颖的网络规模数据。AI 开发者将特别受益于涵盖近期事件的详尽数据。Lenny 播客的听众可以在 brave.com/lenny 免费开始测试该 API。

---

### [00:03:10] Lenny (Sponsor Message)

**English:**
Today's episode is brought to you by Miro, an online collaborative whiteboard that's designed specifically for teams like yours. The best way to see what Miro is all about and how it can help your team collaborate better is not to listen to me talk about it, but to go check it out for yourself. Go to miro.com/lenny. With the help of the Miro team, I created a super cool Miro board with two of my own favorite templates, my one-pager template and my managing up template that you can plug and play and start using immediately with your team. I've also embedded a handful of my favorite templates that other people publish in the Miro verse.

**中文翻译:**
本期节目由 Miro 赞助。Miro 是一个专门为像你们这样的团队设计的在线协作白板。了解 Miro 及其如何帮助团队更好协作的最佳方式不是听我在这说，而是亲自去看看。请访问 miro.com/lenny。在 Miro 团队的帮助下，我创建了一个非常酷的 Miro 画板，其中包含两个我最喜欢的模板：我的“一页纸项目书”（one-pager）模板和我的“向上管理”（managing up）模板，你可以即插即用，立即开始与团队一起使用。我还嵌入了一些其他人在 Miroverse 中发布的我最喜欢的模板。

---

### [00:03:45] Lenny (Sponsor Message)

**English:**
When you get to the board, you can also leave suggestions for the podcast, answer a question that I have for you, and generally just play around to get a sense of how it all works. Miro is a killer tool for brainstorming with your team, laying out your strategy, sharing user research findings, capturing ideas, giving feedback on wireframes, and generally just collaborating with your colleagues. Actually used Miro to collaborate with the Miro team on creating my own board, and it was super fun and super easy. Go check it out at miro.com/lenny. That's M-I-R-O.com/lenny.

**中文翻译:**
当你进入画板时，你还可以为播客留下建议，回答我为你准备的问题，或者只是随便玩玩，感受一下它是如何运作的。Miro 是一个非常棒的工具，适用于团队头脑风暴、制定战略、分享用户研究结果、捕捉创意、对原型图（wireframes）提供反馈，以及与同事进行全面协作。实际上，我就是用 Miro 与 Miro 团队协作创建了我自己的画板，过程非常有趣且简单。请访问 miro.com/lenny 查看。

---

### [00:04:22] Lenny

**English:**
JZ, welcome to the podcast.

**中文翻译:**
JZ，欢迎来到播客。

---

### [00:04:24] Jiaona Zhang

**English:**
Thanks for having me. I'm so excited to be here.

**中文翻译:**
谢谢邀请。我很高兴能来到这里。

---

### [00:04:26] Lenny

**English:**
It's 100% my pleasure. Amongst your many accomplishments, you teach product management at Stanford, which sounds very fancy. How long have you been doing this at this point?

**中文翻译:**
这是我的荣幸。在你众多的成就中，你在斯坦福大学教授产品管理，这听起来非常高级。到目前为止你教了多久了？

---

### [00:04:37] Jiaona Zhang

**English:**
I think six years. Yeah.

**中文翻译:**
我想有六年了。是的。

---

### [00:04:40] Lenny

**English:**
Okay. So my question, the real question I want to ask about this is, in that time you've seen a lot of new PMs and you've seen these PMs succeed, you've seen some fail. What are the most common mistakes that you find new PMs make in this experience of helping new PMs get into the field?

**中文翻译:**
好的。所以我的问题，我真正想问的是，在这段时间里你见过很多新入行的产品经理（PM），你见过他们成功，也见过一些人失败。在你帮助新 PM 进入这个领域的过程中，你发现他们最常犯的错误是什么？

---

### [00:04:56] Jiaona Zhang

**English:**
I think something that is really hard to untrain, but I think every human does it, is you jump to solutions. And so one of the biggest things I see, not just in my course but also just as a PM and some of the mistakes that you make as a PM is the idea of you get really attached to a solution, a way of implementing something that you can see in your head that you want to build. (00:05:16): And so that's the first thing I really want to unteach in our course. And so a lot of people will literally come in, they'll be like, "I want to build X startup" or "I want to do this thing," or "I'm in blank school and I've been doing a lot of research on this particular area." And so untraining that and being like, "Hey, we're going to go out there. We are not going to think at all about the thing that you want to build, but instead we're going to be focused on users and people in the real world and their problems. And the first step is to understand their problems and then understand if there's an opportunity here as opposed to, 'Hey, you want to build X thing for Y person.'" So that's the biggest mistake that you really have to unteach and retrain thinking around.

**中文翻译:**
我认为有一件事很难纠正，但我觉得每个人都会这么做，那就是“直接跳向解决方案”。我看到的最大的问题之一——不仅是在我的课程中，也包括作为一名 PM 观察到的——就是你对某个解决方案产生了强烈的执念，即你脑海中已经构思好了想要构建的某种实现方式。(00:05:16): 所以这是我在课程中首先想要让大家“忘掉”的东西。很多人进来时会说：“我想做一个 X 创业公司”或者“我想做这件事”，或者“我在某某学校，我对这个特定领域做了很多研究”。我们要纠正这种思维，告诉他们：“嘿，我们要走出去。我们根本不去想你想构建的东西，相反，我们要关注现实世界中的用户和人，以及他们的问题。第一步是理解他们的问题，然后看这里是否有机会，而不是‘嘿，你想为 Y 人群构建 X 东西’。”所以这是最需要纠正并重新训练思维的最大错误。

---

### [00:05:55] Lenny

**English:**
Does a lot of this come from people want to get into product management because they think "Finally I'll have the power, finally I'll be able to tell people what to build, finally my ideas really going to matter?" Is that where a lot lobby comes from?

**中文翻译:**
这是否在很大程度上源于人们想进入产品管理领域是因为他们觉得“终于我有权力了，终于我可以告诉别人该造什么了，终于我的想法真正重要了”？这种倾向是这样来的吗？

---

### [00:06:06] Jiaona Zhang

**English:**
I think there's a part of that. One of the first things I teach is you're not a CEO, you're, you're not here... You actually have very little true authority because you don't actually manage anyone. A lot of it is all through influence, and so that is also a piece where you have to kind of untrain that thinking. I do think a lot of people come into the product role thinking that I get to call the shots, I get to make the decisions, I get to decide what gets built. And really your job is not that. Your job is to understand here are the opportunities, and then you're kind of pulling together all the different possibilities and you're really editing. So I do think it comes from desire for a lot of people thinking that's what the product role is when it actually isn't.

**中文翻译:**
我觉得有一部分原因是这个。我教的第一件事就是：你不是 CEO，你不是来这……实际上你几乎没有真正的职权，因为你并不直接管理任何人。很多工作都是通过影响力完成的，所以这也是需要纠正思维的地方。我确实认为很多人进入产品角色时觉得“我可以发号施令，我可以做决定，我可以决定造什么”。但实际上你的工作并非如此。你的工作是理解机会在哪里，然后汇总所有不同的可能性，并进行“编辑”。所以我确实认为这源于很多人的渴望，他们误以为这就是产品角色的本质，而事实并非如此。

---

### [00:06:44] Lenny

**English:**
So let's go to the other side of this question. We talked about what mistakes new PMs make. I'm curious, what's the biggest product mistake that you've made?

**中文翻译:**
那我们来看看问题的另一面。我们谈到了新 PM 犯的错误。我很好奇，你犯过的最大的产品错误是什么？

---

### [00:06:53] Jiaona Zhang

**English:**
Wow, that's a good one. It's so interesting. I feel like as product people, we're always making mistakes and we're always learning. Maybe I'll give an example from Airbnb since you and I were both there. And this one does stand out to me, we were working on this concept called Airbnb Plus. If you took a step back, what we were really trying to do is to be like, "Hey, not everyone trusts Airbnb in terms of... It's a platform. It's not like it's managed inventory, it's not a hotel. How do you go in and really make sure that all the Airbnbs are meeting the quality bar?" But I do think we were very solution-first, and I think we're also competitor afraid at the time. So it was during a time where there were managed marketplaces, there were the Sonders out there, and I think that as a company we're very much like "[inaudible 00:07:36] what are we going to do in the world of managed marketplaces?" (00:07:38): And so we went really hard down the solution space. We essentially were like, "Let's go inspect our inventory, let's actually try to manage our inventory more." And really what we should have done is taken a step back and be like, "What's the real problem? The real problem is people want to know what they're getting themselves into. We need to represent the homes a lot better." And I think the other piece here that's really important is, what, as a company is your strategic strength and what's in your wheelhouse? So for example, Airbnb, we weren't that strong in operations. Again, we're this platform with this marketplace. And so if you don't have that muscle and then you're asking the company, the teams to essentially build it from the ground up, that's really, really difficult. Not to mention the unit economics, are the unit economics actually going to work even as you scale?

**中文翻译:**
哇，问得好。这很有趣。我觉得作为产品人，我们总是在犯错，也总是在学习。也许我可以举一个 Airbnb 的例子，因为你我当时都在那里。这个例子对我来说非常深刻，我们当时在做一个叫 Airbnb Plus 的概念。退一步讲，我们当时真正想做的是：“嘿，并不是每个人都信任 Airbnb……因为它是一个平台，不像酒店那样有统一管理的库存。你如何确保所有的 Airbnb 房源都达到质量标准？”但我认为我们当时非常“解决方案优先”，而且当时我们也对竞争对手感到恐惧。那是托管式市场（managed marketplaces）兴起的时候，比如 Sonder。作为一家公司，我们当时非常焦虑：“在托管式市场的世界里，我们要怎么办？” (00:07:38): 于是我们在解决方案上走得很极端。我们基本上是想：“让我们去检查房源，让我们尝试更多地管理库存。”而实际上我们应该做的是退后一步问：“真正的问题是什么？真正的问题是人们想知道他们预订的到底是什么。我们需要更好地展示这些房屋。”我认为另一个非常重要的点是：作为一家公司，你的战略优势是什么？你的擅长领域是什么？例如 Airbnb，我们在运营方面并不强。再说一次，我们是一个拥有市场的平台。如果你没有那种基因（muscle），却要求公司和团队从零开始构建运营能力，那是极其困难的。更不用说单位经济效益（unit economics）了，即使在规模化之后，单位经济效益真的能跑通吗？

---

### [00:08:22] Lenny

**English:**
Yeah, I feel like Airbnb Plus is an untold story that somebody should tell and that could be its own podcast, I guess.

**中文翻译:**
是的，我觉得 Airbnb Plus 是一个鲜为人知的故事，应该有人来讲讲，这本身就可以做成一期播客。

---

### [00:08:28] Jiaona Zhang

**English:**
You and I can tell it.

**中文翻译:**
你和我就可以讲。

---

### [00:08:30] Lenny

**English:**
We could tell this could be Airbnb Plus The Hidden Story. As you said, the problem it was trying to solve was people don't really trust... They don't want to even consider Airbnb because it's like, "No, I don't want to stay in someone's home. I don't know what it'll be. It's unpredictable." And so as an outsider, it felt like a really clever approach. "We're going to vet them, we're going to make sure they're awesome. There's a minimum bar." And I guess this is the question is do you think it was just like "This is never possible because we'll never make money as a business doing this because we don't make that much per booking and investing time, resources, sending people pillows, all that stuff is ever going to be economical"? Or do you think there was a path that was just not executed well?

**中文翻译:**
我们可以讲，标题就叫《Airbnb Plus：隐藏的故事》。正如你所说，它试图解决的问题是人们不信任……他们甚至不想考虑 Airbnb，因为觉得“不，我不想住在别人家里，我不知道会是什么样，不可预测”。所以作为一个局外人，这听起来像是一个非常聪明的办法。“我们要审核他们，确保他们很棒，设定一个最低门槛。”我想问的是，你认为这是否属于“根本不可能成功，因为作为一项业务我们永远无法从中赚钱，因为每笔订单的利润并不高，而投入时间、资源、给房东寄枕头之类的，这些永远不符合经济效益”？还是说其实有一条路，只是没执行好？

---

### [00:09:10] Jiaona Zhang

**English:**
I think there wasn't really a clear path. I think there was less of-

**中文翻译:**
我认为当时并没有一条清晰的路径。我觉得更多是缺乏——

---

### [00:09:10] Lenny

**English:**
Yeah, that's my impression.

**中文翻译:**
是的，这也是我的印象。

---

### [00:09:15] Jiaona Zhang

**English:**
Exactly. And it was more just like if you understood... Again, this is what my point around unit economics, there are things where I think you have magical thinking around unit economics. You're like, "When we get to the scale of X, it's all going to work out. We can make these things happen." I think you actually need to really make sure that unit economics work quite at the beginning. That is definitely one lesson. And I think the other thing is, and going back to spirit of what are you trying to achieve. If you're trying to achieve this idea of really knowing the quality of the place, and for a platform like Airbnb, the right way to go about doing is through our reviews, through our guest reviews, which are essentially free as opposed to literally sending out inspectors. (00:09:51): And I think that the other things are if you can get signal on what are the things around quality that people care about, is it cleaning? Is it, "Hey, I'm locked out"? And I think that there are other solutions besides inspection that then get at that. So for example, it is actually cheaper to go send everyone a lockbox than to deploy an inspector and go look at your property. It is actually cheaper to maybe do a partnership with a bunch of cleaners in different local areas and then get that as part of the fee, as opposed to doing the inspection. So again, it's really about what are you really trying to achieve? What is the user problem in each of these areas and can you target that problem with the particular listing that you're looking at? (00:10:33): And so I personally don't believe the unit economics ever would've really worked out. I think we should have known that or we should have dug into that more at the very beginning and then to get very tailored instead of one blunt instrument to solve it all, "Hey, we're going to go inspect." It's like what is the problem for this listing and what's the best solution to fix that problem?

**中文翻译:**
没错。而且更多的是，如果你理解……再次回到我关于单位经济效益的观点，有些时候我觉得人们对单位经济效益存在“奇迹般的幻想”。你会想：“当我们达到 X 规模时，一切都会好起来的，我们能让这些事发生。”我认为你实际上需要在最开始就确保单位经济效益是成立的。这绝对是一个教训。另一件事是，回到你想要实现的初衷。如果你想实现“确切了解房屋质量”的目标，对于像 Airbnb 这样的平台，正确的方法是通过我们的评价系统，通过房客的评价，这基本上是免费的，而不是真的派检查员过去。(00:09:51): 我认为其他方面是，如果你能获得关于人们关心的质量问题的信号，是清洁吗？是“嘿，我被锁在门外了”吗？除了实地检查，还有其他解决方案可以解决这些问题。例如，给每个房东寄一个密码钥匙盒（lockbox）实际上比派检查员去看房子要便宜。与不同地区的保洁公司合作，并将其作为费用的一部分，可能也比进行检查要便宜。所以，这归根结底在于你真正想实现什么？在每个领域用户的问题是什么？你能针对特定房源解决那个问题吗？(00:10:33): 所以我个人不认为单位经济效益能跑通。我认为我们本该在最开始就知道这一点，或者深入研究这一点，然后采取非常定制化的方案，而不是用一个笨拙的工具解决所有问题——“嘿，我们要去检查”。应该是：这个房源的问题是什么，解决这个问题的最佳方案是什么？

---

### [00:10:51] Lenny

**English:**
There's a couple things that I think are important product leadership lessons here. One is Airbnb and Brian and many great leaders are famous for imagining the ideal situation, imagining the great end result and then working backwards. And often that leads to great results when you're being really ambitious and "I don't know how we're going to get there, we're just going to shoot big and hopefully we figure it out." Sometimes it works out. In this case it didn't work out. And what you're finding, maybe you even knew this early on, is just like there's no possible world where this could have worked in this approach. Is there anything you've learned about just when to think big and not even like "Forget it. We're going to figure it out. I know this seems impossible, but we're just going to try it anyway"? Do you have any kind of framework of when to think big, then just go for it? Versus, "Oh, let's just work out the math today," is this ever possible?

**中文翻译:**
我觉得这里有几个重要的产品领导力教训。一是 Airbnb、Brian（创始人）和许多伟大的领导者都以“想象理想情境、想象伟大的最终结果然后倒推”而闻名。当你非常有野心，抱着“我不知道怎么达到那里，我们先定个大目标，希望能搞定”的心态时，往往会产生伟大的结果。有时这行得通，但在这种情况下没行通。而你发现的——也许你很早就知道了——是这种方法根本没有成功的可能。关于什么时候该“敢想敢做”（think big），甚至不去管“算了吧，我们会搞定的，我知道这看起来不可能，但我们还是要试一试”，你学到了什么吗？你有没有什么框架来决定什么时候该敢想敢做直接冲，什么时候该“今天先算算账，看这到底有没有可能”？

---

### [00:11:42] Jiaona Zhang

**English:**
I think it's really important for every company to be dreaming big. If you don't have a big vision, it's really hard for you to innovate, but you got to couple that really big vision with thoughtfulness around your execution. And so I think that one of the biggest tips I have is how do to be clear about the phase that you're in? So I think it's totally fine to be like, "Hey, we are going to try X for six months, three months, whatever it is, and we're explicitly going to go learn these types of things. We're going to learn why are people? Are there signals that we would that would indicate that again, the communication with host isn't great or this type of listing, if it's hosted by a person with multiple property?" I think there are factors we can be like, "Hey, we can learn this very explicit thing in a given period of time." (00:12:32): And you can do what I call unscalable things in that prototyping phase, in that early phase to go learn those lessons. But you just have to be very, very clear with your team on what phase you're in. "Hey, we're in the learning phase and we explicitly are trying to learn these things" versus, "Hey, we have this really big vision and we're just going to go at it." That is not recommended in my mind. It's breaking it down into these smaller chunks. That I think gets you the balance of thinking really, really big, but also being able to be like, "Okay, we are still going to be able to say, 'Okay, this path is not going to work out. We ran at it for a short period of time. We got these learnings, now let's go down this other path.'"

**中文翻译:**
我认为每家公司都必须有远大的梦想。如果你没有宏伟的愿景，就很难创新，但你必须将宏伟的愿景与周密的执行结合起来。所以我最大的建议之一是：如何明确你所处的阶段？我觉得这样说完全没问题：“嘿，我们要尝试 X 方案六个月或三个月，我们要明确地去学习这些东西。我们要学习为什么人们会这样？是否有信号表明与房东的沟通不好，或者这种由拥有多套房产的人托管的房源有问题？”我认为我们可以设定一些因素，比如“嘿，我们可以在特定时间内学习这个非常明确的东西”。(00:12:32): 在原型阶段或早期阶段，你可以做一些我称之为“不可规模化”（unscalable）的事情来吸取教训。但你必须对团队非常明确地说明你们处于什么阶段。“嘿，我们现在处于学习阶段，我们明确地在尝试学习这些东西”，而不是“嘿，我们有一个宏伟的愿景，我们就这么干吧”。在我看来，后者是不推荐的。应该把它分解成更小的块。我认为这能让你在“敢想敢做”和“能够及时止损”之间取得平衡，比如能说：“好吧，这条路行不通。我们尝试了一小段时间，学到了这些东西，现在让我们走另一条路。”

---

### [00:13:11] Lenny

**English:**
Yeah, there's also some cost fallacy that kicks in of just like, "Oh, I spend so much time and money and resources on this thing. Let's just go a little bit longer. Let's just see if we give it another quarter, maybe it'll work out."

**中文翻译:**
是的，还会产生“沉没成本谬误”（sunk cost fallacy），比如“噢，我在这件事上花了这么多时间、金钱和资源。让我们再坚持一下。看看如果再给一个季度，也许它就能成功。”

---

### [00:13:21] Jiaona Zhang

**English:**
You should articulate what success looks like and the milestones you want to hit in the small intervals that I talked about. So you don't get into this world where you're like, "Hey, I've gone for two years investing in this thing. Now we got to cut it." It's like, what is the quarter long milestone? Okay, what's the next quarter long milestone? And every single point, what is a go and no-go? And I think that really can help a team and a company say "It's okay. I invested a quarter in it, but I didn't invest two years."

**中文翻译:**
你应该在我提到的那些短间隔内，明确成功的定义以及你想达到的里程碑。这样你就不会陷入这种境地：“嘿，我已经投资这件事两年了，现在不得不砍掉它。”你应该问：本季度的里程碑是什么？好，下个季度的里程碑是什么？在每一个时间点，什么是“继续”或“停止”的判断标准？我认为这能真正帮助团队和公司说：“没关系，我只投入了一个季度，而不是两年。”

---

### [00:13:46] Lenny

**English:**
The other important lesson here is about the importance of as a product leader pushing back and convincing leadership that you are wrong and this shouldn't happen. I remember talking to one of our colleagues, Mike Lewis, who was leading a different team with Airbnb, and he was just like, "Oh, I realized I'm the person that should be saying, 'No, we shouldn't do this now'" because he was the head of product for one of the new [projects]. And I know maybe in that situation it was impossible because Brian was very into this and everyone was like, "We need to do this thing." (00:14:18): I guess is there anything you've learned about how to push back on these sorts of things that the founder's really into when it makes sense to go along? Like "Cool, let's do it. Let's buy in." As a leader, you have to be excited and he needs to feel like, "Oh, JZ is really excited about this too. We got to try it." Even though maybe you feel like it's not going to work out. So I guess the question is when do you think it makes sense to try convince the founder, "No, this is the bad idea" versus like "Let's go for it"?

**中文翻译:**
这里另一个重要的教训是，作为产品领导者，回绝（push back）并说服领导层“你是错的，这不该发生”的重要性。我记得和我们的同事 Mike Lewis 聊过，他当时在 Airbnb 领导另一个团队，他说：“噢，我意识到我应该是那个说‘不，我们现在不该做这个’的人”，因为他是其中一个新项目的负责人。我知道在那种情况下可能很难，因为 Brian 非常投入，每个人都觉得“我们必须做这件事”。(00:14:18): 我想问，关于如何回绝创始人非常热衷的事情，你学到了什么吗？什么时候该顺从，比如“酷，让我们做吧，我们全力支持”？作为领导者，你必须表现出兴奋，他需要感觉到“噢，JZ 对此也很兴奋，我们得试试”，即使你内心觉得这行不通。所以问题是，你认为什么时候该尝试说服创始人“不，这是个坏主意”，什么时候该说“让我们冲吧”？

---

### [00:14:42] Jiaona Zhang

**English:**
I think first it comes down to your conviction. Do you actually have conviction that this is a bad idea or are you personally still learning? Right. I think if you're at the point, if you're like, "I have total conviction," then your job is to say, no, you really... If you do not, you're not doing your job. And then the question is what are the tips in how to convince someone who's very bought into an idea that that's not the right idea? And there what I would say is it's understanding the spirit of what they're trying to achieve. Being able to go back with, "Hey, I understand the spirit. The spirit is that we're trying to get people who previously didn't consider Airbnb before to come and use Airbnb, but the right way to do it is not this very time-intensive, cost-intensive way to inspect all these homes. The way to do it is to be much more granular in what we ask people when they upload their home and more checks in that. And that could be automated and through technology as opposed to through humans." (00:15:37): It's coming back with actual options. It's like saying... And I think we did that a little bit to be honest, when we as a team evolve, we learn and we're like, "This isn't going to work." And I explicitly moved off the team and I was like, "I'm going to work on the review system. I'm going to continue to evolve this and make it better because that is the actual scalable way to do this as opposed to keep going at it in the very manual process." (00:15:59): And so I think that the biggest tip I would have for people in this situation is really understand whether it's the founder or your manager or whoever it is, what is it that they're trying to accomplish for the user and for the business? Remind them of that, get aligned on that. And then come back with better options. A lot of these people, they're very smart and they're very motivated. They ultimately want to just do the right thing for their users. When you come back with a much better solution and you have the data and you have the thinking behind it's very rare that someone will be like, "I still want to go after this solution despite the fact that it's not working and you proposed a much better path forward."

**中文翻译:**
我认为首先取决于你的信念（conviction）。你是否真的确信这是一个坏主意，还是你个人还在学习阶段？如果你已经到了“我完全确信”的地步，那么你的工作就是说“不”，真的……如果你不说，你就是在失职。接下来的问题是，如何说服一个非常认同某个想法的人，告诉他那不是个好主意？我会说，关键在于理解他们想要实现的“精神实质”。能够回应说：“嘿，我理解这个初衷。初衷是让那些以前不考虑 Airbnb 的人来使用它，但正确的方法不是这种耗时耗力地检查所有房屋。方法应该是对人们上传房源时的要求更加细化，并增加更多审核。这可以通过自动化和技术手段实现，而不是靠人力。” (00:15:37): 也就是带着实际的选项回来。说实话，我觉得我们当时做了一点尝试，当团队进化、学习后，我们意识到“这行不通”。我明确地离开了那个团队，我说：“我要去负责评价系统。我要继续改进它，因为它才是真正可扩展的方法，而不是继续这种非常手工化的流程。” (00:15:59): 所以对于处于这种情况的人，我最大的建议是：真正理解无论是创始人、经理还是其他人，他们想为用户和业务达成什么目标？提醒他们这一点，达成共识。然后带着更好的选项回来。这些人通常非常聪明且充满动力，他们最终只是想为用户做正确的事。当你带着更好的解决方案、数据和背后的思考回来时，很少有人会说：“尽管这个方案行不通，而且你提出了更好的路径，但我还是要坚持原来的方案。”

---

### [00:16:37] Lenny

**English:**
And I think to touch on what you've already said is also make sure it's actually... There's a world where this could work. Do some math to figure out if this is a business that will actually make some money in the future.

**中文翻译:**
而且我觉得补充你刚才说的，还要确保……在某种情境下这确实是可行的。做一些数学计算，看看这是否是一项未来真正能赚钱的业务。

---

### [00:16:49] Jiaona Zhang

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:16:50] Lenny

**English:**
Okay. I'm going to bounce around a little bit. I have a bunch of different questions around different topics. You popularized this concept of minimal lovable product versus this idea that everyone always comes back to, which is minimal viable product. Can you just talk about what is a minimal lovable product and then when does it make sense to go in that direction versus a traditional MVP?

**中文翻译:**
好的。我接下来会跳着问一些不同话题的问题。你推广了“最小讨喜产品”（Minimal Lovable Product, MLP）的概念，而不是大家总挂在嘴边的“最小可行性产品”（MVP）。你能谈谈什么是 MLP 吗？什么时候选择 MLP 而不是传统的 MVP 是有意义的？

---

### [00:17:10] Jiaona Zhang

**English:**
The reason I care so much about minimal lovable product is because I do think in a world where there are so many different options, it's hard to just feel like, "Hey, use this thing. It barely meets a quality bar." And so I think this idea of actually deeply understanding for the thing that you're working on, what is a lovable experience? What is the quality bar that resonates with your users? And again, especially in a world where there might be a lot of different options. Minimal lovable products is the new MVP. The new minimal viable product. (00:17:40): So I think that's the real point, but at the end of the day, it does come back to what are the options that a user has and what are they trying to do? So there's a world where your quality bar, your "Quality bar," or let's call it your polished bar, can be a little bit lower because the reality is the thing that you're "Competing against" or you're replacing is literally a manual workflow. It's like spreadsheets. It's doing something in a super terrible way. (00:18:05): So you want to get your product to market as quickly as possible, so it doesn't make sense for you to be like, "I'm going to build these 15 additional features." Because compared to what people are doing right now, your product without those 15 additional features is perfectly fine, perfectly usable, and perfectly quite honestly lovable. So it requires a lot of understanding of, again, your users and the space that you play in and the tolerance of your given user. So for example, a designer might have a lot higher of a bar of like "This is the kind of workflow I want, this is the kind of bar for my product." But again, someone sitting on the finance team or the IT team, their bar might be like, "Oh, I'm used to doing these 15 things and so your thing is just a lot better."

**中文翻译:**
我之所以如此看重 MLP，是因为我认为在这个选择如此之多的世界里，很难让人觉得“嘿，用这个东西吧，它勉强达到了质量标准”。所以我认为，对于你正在做的东西，要深入理解什么是“讨喜的体验”？什么是能引起用户共鸣的质量标准？尤其是在有很多竞争选项的情况下。MLP 就是新的 MVP。(00:17:40): 这就是核心点。但归根结底，这还是要回到用户有哪些选择以及他们想做什么。在某些情况下，你的质量标准，或者说“打磨程度”，可以稍微低一点，因为现实中你“竞争”或替代的对象是纯手工流程。比如 Excel 表格，或者某种极其糟糕的处理方式。(00:18:05): 在这种情况下，你想尽快把产品推向市场，所以你没必要去想“我要多做这 15 个功能”。因为与人们现在的做法相比，没有这 15 个功能的你的产品已经非常好了，完全可用，而且坦白说，非常讨喜。所以这需要对用户、你所处的领域以及特定用户的容忍度有很深的理解。例如，设计师可能对“我想要的这种工作流”有更高的标准。但对于财务团队或 IT 团队的人来说，他们的标准可能是：“噢，我以前得做这 15 件事，而你的东西比那好太多了。”

---

### [00:18:53] Lenny

**English:**
I'd love to go even one level deeper. Is there an example of something you've worked on that was minimal lovable product that you think about? Or is there something out there that's an example of here's maybe an example of a minimal lovable product versus MVP?

**中文翻译:**
我想再深入探讨一下。有没有什么你参与过的项目，你认为它是 MLP 的典型例子？或者市面上有什么产品可以作为 MLP 与 MVP 对比的例子？

---

### [00:19:08] Jiaona Zhang

**English:**
Again, it's very hard. I think every product team, every product person struggles with this idea of what is the minimal viable. Even that concept itself is difficult and not to mention minimal lovable. I'll give a Webflow example. Very recently, so have been investing in a couple of new features, memberships and logic, new functionality for our users. And what we realized at the end of the day after investing in these areas, we were like, "Hey, we can get to minimal viable, but we don't know if we can actually get to minimal lovable in a way that our users really, really want. And so does it make sense for us to continue to go down this path of continues to chip away to get to minimal lovable when we are maybe hitting diminishing returns for our user base? Or does it actually make sense to release what we have but then encourage our ecosystem to contribute the lovable piece?" (00:19:56): And again, it's not just like you put it out there and you hope, you have to have a very strong point of view of are we at minimal viable, are we at minimal lovable? Where in between are we? And so having that point of view and then being able to say, "Are we going to be able to meet it as a company? Are we going to rely on our ecosystem to help us meet it? What are we actually going to do?" And then even within the feature set, it's very much a how do we do some things well as opposed to do a little bit of everything? I think that is a big piece of minimal lovable, which is again... To me it's better to do five things instead of the 15 things in a really, really great way with a high degree of polish with a, "Oh, this really meets my need," versus trying to do everything and just doing a little bit of everything. And so every part of the experience feels a little bit clunky. It's not quite there. (00:20:45): People I think would actually respect this idea of "You've given me minimal lovable in five areas as opposed to minimal viable in 15 areas."

**中文翻译:**
这确实很难。我认为每个产品团队、每个产品人都在纠结什么是“最小可行”。甚至这个概念本身就很困难，更不用说“最小讨喜”了。我举一个 Webflow 的例子。最近我们一直在投资几个新功能：会员（memberships）和逻辑（logic），这是为用户提供的新功能。在投入这些领域后，我们意识到：“嘿，我们可以达到最小可行，但我们不知道是否能以用户真正想要的方式达到最小讨喜。那么，当我们可能面临用户群收益递减时，继续在这条路上死磕以达到最小讨喜是否有意义？还是说发布现有版本，然后鼓励我们的生态系统来贡献‘讨喜’的部分更有意义？” (00:19:56): 再次强调，这不只是发布出去然后祈祷，你必须有一个非常明确的观点：我们现在是最小可行，还是最小讨喜？我们处于中间的什么位置？有了这个观点，你才能决定：“作为一家公司，我们能达到这个标准吗？我们要依靠生态系统来帮助我们达到吗？我们到底要做什么？”即使在功能集中，关键也在于如何把几件事做好，而不是每件事都做一点。我认为这是 MLP 的重要组成部分，即……对我来说，与其做 15 件事但每件都平平，不如以极高的打磨程度把 5 件事做得非常出色，让人感叹“噢，这真的满足了我的需求”。如果尝试做所有事，每件事都只做一点，那么体验的每个部分都会感觉有点笨拙，不到位。(00:20:45): 我认为人们实际上会更尊重这种做法：“你在 5 个领域给了我‘最小讨喜’，而不是在 15 个领域给了我‘最小可行’。”

---

### [00:20:53] Lenny

**English:**
Is there anything you've seen of just that makes something lovable? I don't know. I know it's not easy to define, but what are things you've seen that makes something lovable? Is it delightful features? Or is it what you're saying, which is just things are actually good, there's fewer things, but they're each really good?

**中文翻译:**
你有没有见过什么东西让产品变得“讨喜”？我知道这很难定义，但你见过哪些因素能让东西变得讨喜？是令人愉悦的功能吗？还是像你说的，东西真的很好，虽然数量少，但每一件都很棒？

---

### [00:21:08] Jiaona Zhang

**English:**
There's definitely this idea of the thing is just good. It has all. High quality, it's not janky, it doesn't feel weird. I'll give you a very small example again, just from Webflow, this idea of keyboard shortcuts, feels small, but that is a piece that creates a lot of love from user base who are power users. And then there's this concept of pixie dusts, and maybe I'll pull out of call it like design tool space and we'll talk about some of the other things, whether it's Dropbox or Airbnb, but you can just do a little bit of that extra pixie dusts. So an example from Airbnb when we're doing the mobile app revamp where like "There's like these basic table stakes, but if we actually added in templates and we made it so that these templates could be maybe pre-populated in certain ways from the content they already have," that is lovable, that is that extra little bit of pixie dust and spending the time to do that. (00:21:55): Again, you can't pixie dust everything. At the end of the day, you basically have your time, your staffing and the scope of your project and something has to give. And so at the end of the day, you can't just keep investing, keep investing because it's going to push out your launch timeline, but can you pick a few different areas where you're like, "I'm going to scatter that pixie dust, I'm going to do a little bit more than what users are expecting"? And that creates that lovability.

**中文翻译:**
肯定有这种“东西就是好”的感觉。它具备一切：高质量、不卡顿、不让人觉得奇怪。我再举一个 Webflow 的小例子：快捷键。这看起来很小，但它是让高级用户（power users）产生大量好感的关键。还有一个概念叫“仙女粉”（pixie dust，指点睛之笔）。也许我可以跳出设计工具领域，谈谈 Dropbox 或 Airbnb。你可以加一点额外的“仙女粉”。比如 Airbnb 在做移动端 App 改版时，“有一些基础的必备功能（table stakes），但如果我们加入模板，并让这些模板能根据房东已有的内容自动填充”，那就是讨喜的，那就是额外的一点“仙女粉”，值得花时间去做。(00:21:55): 同样，你不能给所有东西都撒“仙女粉”。归根结底，你只有有限的时间、人员和项目范围，必须有所取舍。你不能一直无止境地投入，因为那会推迟发布时间。但你能不能选几个特定的领域，心想：“我要在这里撒点‘仙女粉’，我要做得比用户预期的多一点点”？这就是创造“讨喜感”的原因。

---

### [00:22:20] Lenny

**English:**
Shifting to a different topic, I know you have strong opinions about road mapping and OKRs, improvisation, and I know that's a big topic, but let me just ask, what's the most common advice you give around how to roadmap well, do OKRs, prioritize and/or just, I don't know, common mantras or things you always come back to be successful in these areas?

**中文翻译:**
换个话题。我知道你对路线图规划（roadmapping）、OKR 和优先级排序有很强的见解。这是一个大话题，但我只想问，关于如何做好路线图、OKR、优先级排序，你最常给出的建议是什么？或者说，为了在这些领域取得成功，你总是会回到哪些准则或口号上？

---

### [00:22:40] Jiaona Zhang

**English:**
Road mapping prioritization are one bucket for me. And then OKRs is another. So I'll maybe give you my biggest tip in each one of these buckets. (00:22:46): So for road mapping, my biggest thing that I tell my teams is "You're telling a story. So what I want from you is I want themes, I want a story. Why are these things the biggest things to invest in these levers, the biggest ones to pull?" And what I really don't want, what I think is a very common mistake from road mapping is people thinking a spreadsheet with a bunch of projects, the RICE framework, everything has an impact, a cost and an effort column filled out. They think that is prioritization and that is a roadmap. If you just do that right and then you present that to your team, they're off to the races. (00:23:26): But what people, what humans really crave is like, "Why am I doing this body of work?" And I think it's also really, really important to have that really crisply articulated in your own head because ultimately what happens is you'll learn things as a product person. You'll be like, "Oh, I assumed this in the narrative in my head about my users or about my product area, and then I learned why and therefore my thinking changed." So instead of it being this massive spreadsheet where you're going in, you're tweaking all the values, what is the story that you're telling about your roadmap that these inputs can then go and influence? (00:23:59): It could be like, "Hey, I just realized I didn't know before that we have a lot more power users on our," or "Maybe we have a lot more non-technical users." That input changes my roadmap and changes my themes in a pretty dramatic way. So skating at that level is really, really critical, I think for a roadmap as opposed to going down to the really granular details of the how. So that's the biggest thing on road mapping, which is like tell a story. What are your themes? Make it so that your team can come up with the actual how and the projects and all the little details, but really create that scaffolding for them to know what's important.

**中文翻译:**
路线图和优先级排序对我来说是一个范畴，OKR 是另一个。我给每个范畴提供一个最大的建议。(00:22:46): 对于路线图，我告诉团队最重要的一点是：“你是在讲一个故事。所以我想要的是主题（themes），是一个故事。为什么这些是最大的投资点？为什么这些杠杆是最值得拉动的？”我最不希望看到的，也是我认为路线图规划中最常见的错误，就是人们认为一个列满项目的 Excel 表格、套用 RICE 框架、填好影响力、成本和工作量列，那就是优先级排序，那就是路线图。他们觉得只要把这个做对，展示给团队，大家就能开干了。(00:23:26): 但人们——人类——真正渴望的是：“我为什么要干这堆活？”我认为在你自己脑子里清晰地表达出这一点也非常重要，因为最终作为产品人，你会学到新东西。你会发现：“噢，我之前在脑海中关于用户或产品领域的叙述中假设了这一点，后来我明白了原因，因此我的想法改变了。”所以，与其维护一个不断调整数值的庞大表格，不如想想：你关于路线图的故事是什么？这些输入数据如何影响这个故事？(00:23:59): 比如，“嘿，我刚刚意识到，以前我不知道我们有这么多高级用户”，或者“也许我们有更多非技术用户”。这个输入会以戏剧性的方式改变我的路线图和主题。我认为，在路线图层面，保持在这个高度（即讲故事和定主题）是至关重要的，而不是陷入“如何做”的极细微细节中。所以路线图最核心的是：讲一个故事。你的主题是什么？让你的团队去想具体的“如何做”、具体的项目和细节，但你要为他们搭建好脚手架，让他们知道什么是重要的。

---

### [00:24:33] Lenny

**English:**
Can I ask a follow-up question on that?

**中文翻译:**
我可以追问一个问题吗？

---

### [00:24:35] Jiaona Zhang

**English:**
Totally, yeah.

**中文翻译:**
当然可以。

---

### [00:24:36] Lenny

**English:**
It's easy to visualize the roadmap of a spreadsheet to help people visualize what you're suggesting there. What does that actual artifact look like? Is it a doc with maybe an ancillary spreadsheet of the actual prioritization? Is it a deck? How do you actually deliver this to you with like "JZ, here's our proposal for our team"?

**中文翻译:**
很容易想象表格形式的路线图。为了帮助大家想象你建议的形式，实际的产出物（artifact）长什么样？是一个文档，配上一个辅助的优先级排序表格吗？还是一个幻灯片（deck）？当团队向你提交建议时，他们是怎么呈现的？

---

### [00:24:55] Jiaona Zhang

**English:**
Yeah, I'm a big fan of docs and decks are obviously helpful if you're talking live, but I do think in a remote-first culture or lots of us are in hybrid remote cultures it's hard because decks typically require a voiceover. And so we have been doing a big push even on my teams where I'm like, "Write it down and document. Force yourself to write the pros because when you write the pros, you can actually add that level of granularity." So very much so the same way like "I'm a roadmap is a story. You're telling themes, you write a story in a notebook, you write a story on pages," and so a doc is definitely preferred. And even in the doc just being like, "Here's what we're trying to achieve, here are the big areas I want to invest in, here are my big themes." And then going into each of those themes and being like, "These are the big projects." (00:25:40): And then linking out, again, not even to a spreadsheet, but linking out to the artifacts and the systems that your team actually uses. So if your team uses Jira, go ahead and link out to Jira because so often docs get out of... Or spreadsheets get out of date, because they're like a snapshot of whatever it is that you needed at that point in time. But instead you link out to the actual things that your teams are working out of, you can always be like, "These are the themes. I will edit these if I learn major things that would change my themes. And then let's go link out to the Jira where you can just see the snapshot of the roadmap at any given point in time."

**中文翻译:**
是的，我是文档（docs）的忠实粉丝。如果你是现场讲解，幻灯片显然很有用，但在远程优先或混合办公文化中，幻灯片很难，因为它们通常需要旁白。所以即使在我的团队中，我也一直在大力推动：“把它写下来，形成文档。强迫自己写散文式的描述，因为当你写描述时，你才能增加那种细粒度的思考。”就像“路线图是一个故事，你在讲述主题，你在笔记本或页面上写故事”一样，文档绝对是首选。在文档中，只需写明：“这是我们要实现的目标，这是我想投资的大领域，这是我的大主题。”然后进入每个主题，说明：“这些是重点项目。” (00:25:40): 然后链接出去，甚至不是链接到表格，而是链接到团队实际使用的产出物和系统。如果你的团队用 Jira，那就链接到 Jira。因为文档或表格经常会过时，它们只是你在那个时间点所需的快照。但如果你链接到团队实际工作的工具，你可以始终保持：“这些是主题。如果我学到了会改变主题的重大事项，我会编辑这些主题。然后链接到 Jira，你可以在任何时间点看到路线图的实时快照。”

---

### [00:26:12] Lenny

**English:**
Do you have a template or common structure you suggest to teams for laying out this story or is it just depends on the quarter, it depends on the year?

**中文翻译:**
你有没有建议团队使用的模板或通用结构来铺陈这个故事？还是说这取决于季度或年份？

---

### [00:26:21] Jiaona Zhang

**English:**
I'll give a plug for a new thing coming out of Reforge, which is this concept of artifacts. And so we do have a lot of artifacts out there, so what's our general product development process? What are our templates for our specs? What are our templates for some of these things that we're talking about, a roadmap, like a broader roadmap instead of just a feature spec. So yes, we have a ton of those artifacts, are always evolving. I think every team takes it and tweaks it a little bit, but I'm a big believer of bringing those artifacts back and then sharing them across the team. And so product operations is also a function that we've invested in because it just really greases the wheels, gets all of our teams speaking the same language.

**中文翻译:**
我要为 Reforge 的一个新东西打个广告，就是“产出物”（artifacts）这个概念。我们确实有很多产出物，比如：我们的通用产品开发流程是什么？我们的规格说明书（specs）模板是什么？我们刚才讨论的这些东西的模板是什么——比如路线图，是一个宏观路线图而不仅仅是功能规格。所以是的，我们有很多这类产出物，并且一直在进化。我认为每个团队都会拿去并稍微调整一下，但我坚信应该把这些产出物带回来并在整个团队中共享。因此，产品运营（Product Operations）也是我们投入的一个职能，因为它能让流程更顺滑，让所有团队都使用同一种语言。

---

### [00:26:57] Lenny

**English:**
Awesome. (00:26:59): This episode is brought to you by Superhuman. How much time do you spend in email each day? How about your team? You may not realize this, but your email tools are wasting your time. Superhuman is blazingly fast email for high performing teams built to work with Gmail and Outlook. Teams who use Superhuman spend half the time in their inboxes respond to twice the number of emails and save over four hours a week. That's over a month of save time per year. With Superhuman, you can split your inbox into streams for VIPs, team members and emails from your favorite products to reduce context switching and make sure you never miss an important email. You can set reminders if you don't hear back so that you can follow up and never drop the ball on an email thread. You can also work faster than ever before with powerful AI features like writing, editing, summarizing and even translating. Join the ranks of the most productive teams and unleash the power of superhuman. Try one month free at superhuman.com/lenny. That's superhuman.com/lenny.

**中文翻译:**
太棒了。(00:26:59): 本期节目由 Superhuman 赞助。你每天花多少时间处理邮件？你的团队呢？你可能没意识到，你的邮件工具正在浪费你的时间。Superhuman 是为高效团队打造的极速邮件工具，支持 Gmail 和 Outlook。使用 Superhuman 的团队在收件箱上花费的时间减少了一半，处理的邮件数量增加了一倍，每周节省超过 4 小时。这相当于每年节省超过一个月的时间。通过 Superhuman，你可以将收件箱分成 VIP、团队成员和来自你最喜欢产品的邮件流，以减少上下文切换，确保你不会错过重要邮件。如果没收到回复，你可以设置提醒，以便跟进，永远不会在邮件线程中掉链子。你还可以利用强大的 AI 功能（如写作、编辑、总结甚至翻译）以前所未有的速度工作。加入最高效团队的行列，释放 Superhuman 的力量。在 superhuman.com/lenny 免费试用一个月。

---

### [00:28:02] Lenny

**English:**
Moving to a different topic, what is your number one piece of advice to new PMs who want to accelerate their career? What do you find most often is the blocker or thing holding them back or something they can change that'll accelerate things?

**中文翻译:**
换个话题。对于想要加速职业发展的初级 PM，你头号建议是什么？你发现最常见的阻碍或绊脚石是什么？或者他们可以改变什么来加速发展？

---

### [00:28:18] Jiaona Zhang

**English:**
There's so many parts to it, but I'll pick one. And there are many frameworks even beyond the one, but let's pick one for your question, which is I think it's really important to become really good at and also known for something. And what I mean by that is when you're known in your company for a particular thing.... I'll give you a couple examples. You could be known for shepherding the most complex launches because you're just so good at quarterbacking, working with go-to market teams and cross-functional stakeholders, that could be your thing. You could be known for working on the most technically complex problems. You could be known for working on things that are really regulatory complex. Find something that you can be really, really good at. And the reason I give that advice is because when you do that, you can crush the projects that you get. Because you're making a name for yourself, reputation, and then you are giving more responsibility. People tend to flock and give responsibility to the people that are known for being excellent at something.

**中文翻译:**
这涉及很多方面，但我选一个。除了这一个，还有很多框架，但针对你的问题，我选这一个：我认为变得非常擅长某件事并因此而出名是非常重要的。我的意思是，当你在公司里因为某件事而闻名时……我给你举几个例子。你可能因为擅长统筹全局、与 GTM 团队和跨职能利益相关者合作，从而以引导最复杂的发布活动而闻名，这可以成为你的招牌。你也可以因为处理最复杂的技术问题而闻名。或者因为处理监管极其复杂的事情而闻名。找一件你能做得非常非常出色的事情。我给出这个建议的原因是，当你做到这一点时，你就能出色地完成接手的项目。因为你在为自己建立名声和声望，随后你会被赋予更多的责任。人们往往会聚集在那些以卓越著称的人身边，并将责任托付给他们。

---

### [00:29:16] Lenny

**English:**
Is there something you were known to be excellent at in the course of your career?

**中文翻译:**
在你的职业生涯中，你曾以擅长什么而闻名？

---

### [00:29:20] Jiaona Zhang

**English:**
I would say early on in my career, it was actually the fact that I had a strong analytics background. And so when I joined gaming, I came from consulting, I didn't have any CS background or design background, and so it was really creating a reputation around being very analytical, around being able to analyze the datasets of my game and then make decisions. I also learned as I was doing that I was actually really good at execution, and so being able to keep a lot of plates spinning and working on the largest studio and managing all the complex pieces of that, that was what I discovered. I didn't know this, but I discovered as I started working in the role. (00:29:58): And so that was something I brought to Dropbox. When I joined Dropbox. It was like I knew that I could work with a lot of different teams and make sure that we hit a launch deadline, and so I would find myself trying to lean into that superpower and then when delivering upon that, getting more responsibility, "Hey, you just launched this really complex thing, this was a project that had to work across a lot of different platforms. We're using Griddle APIs." And it was a very, very small team and it had a very, very tight deadline. (00:30:29): So when you're like, "I can do something like this," you end up getting more responsibility because people were like, "Oh, she was able to do something that was really hard with a small team," and so that's how you get more responsibility. But it has evolved in my career. I think that at the beginning of your career, you do want to lean into some of these pieces. It makes sense, but also even when you start to manage, it shifts dramatically. Being known as the best executor is not necessarily the thing that gives you and your team the most responsibility. So as I've grown my career, whether it's at Airbnb or WeWork or other places I flex into maybe a different... It's like taking your core strength but then flexing it and finding different ways to bring it to life.

**中文翻译:**
我会说在职业生涯早期，实际上是因为我有很强的分析背景。当我加入游戏行业时，我来自咨询行业，没有计算机科学（CS）或设计背景，所以我建立的名声是非常理性、善于分析，能够分析游戏的数据集并据此做出决策。在做的过程中，我也发现自己其实非常擅长执行，能够同时处理很多事情（keep a lot of plates spinning），在最大的工作室工作并管理所有复杂的环节，这是我发现的。我以前不知道，但开始工作后发现了这一点。(00:29:58): 这也是我带到 Dropbox 的东西。当我加入 Dropbox 时，我知道我可以与许多不同的团队合作并确保我们按时发布，所以我发现自己会倾向于发挥这种“超能力”，并在交付成果后获得更多责任。“嘿，你刚刚发布了这个非常复杂的东西，这是一个需要跨多个平台协作的项目，我们使用了 Griddle API。”那是一个非常小的团队，而且期限非常紧。(00:30:29): 所以当你表现出“我能搞定这种事”时，你最终会获得更多责任，因为人们会觉得：“噢，她能带领一个小团队完成非常困难的任务。”这就是你获得更多责任的方式。但在我的职业生涯中，这也在进化。我认为在职业生涯初期，你确实想依靠这些特质，这很合理。但当你开始管理时，情况会发生巨大变化。被称为“最佳执行者”并不一定能为你和你的团队带来最多的责任。所以随着职业生涯的发展，无论是在 Airbnb、WeWork 还是其他地方，我都会转向不同的……就像是利用你的核心优势，但灵活运用它，找到不同的方式来体现它的价值。

---

### [00:31:09] Lenny

**English:**
Much of what I just heard is you just worked incredibly hard and just got shit done. And I think that's very, very important and often leads to a lot of success.

**中文翻译:**
我刚才听到的很大一部分就是你工作极其努力，并且“把事情搞定”（got shit done）。我认为这非常非常重要，而且往往能带来很多成功。

---

### [00:31:20] Jiaona Zhang

**English:**
PMs have to get shit done. Yeah, ultimately you're responsible for the outcome just no matter what happens.

**中文翻译:**
PM 必须把事情搞定。是的，无论发生什么，你最终都要对结果负责。

---

### [00:31:26] Lenny

**English:**
I like that. Be known for getting shit done and working really hard, and that's never going to serve you badly. I think that is just lasting advice for being successful as a PM. I realized that we were talking about your tips on prioritization, road mapping and then OKRs, and then I shifted topics and you never got to the OKR bucket. So let me come back to that.

**中文翻译:**
我喜欢这个。以“能搞定事”和“工作努力”而闻名，这永远不会对你有坏处。我认为这是作为 PM 成功的持久建议。我意识到我们刚才在聊关于优先级、路线图和 OKR 的建议，然后我换了话题，你还没聊到 OKR 那部分。所以让我们回到 OKR。

---

### [00:31:47] Jiaona Zhang

**English:**
Yes. My biggest tip on OKRs is actually get really, really crisp on qualitatively. What would make you say "Yes, we did a great job"? And the reason I pushed so hard on that is because I see so many teams get really mucked down by OKRs. They're like, "Oh man, if I don't hit my OKR, I feel like I'm going to have a really bad reputation, or maybe I won't get promoted." You just get all this fear around OKRs. And so you see people, you see people sandbagging, you see people being hesitant to put in numbers until the very last second until they're super, super confident. And that results in ultimately a failure for your company to innovate and move quickly. (00:32:29): And so what I really push on for OKRs is are you actually... What's the spirit... I think I asked this question maybe too much to my team, but what is the spirit of what you're trying to achieve and what would make you say, 'I really, really crushed it this past quarter'? And so it's less about I would rather have all the OKRs be red or yellow and we missed everything and we learned around why we missed it than everything to be green. In fact, when everything's green, you're like, "We definitely did not set ambitious enough OKRs." And so it really pushed a lot on what does it truly mean to crush it and be successful? What does it mean for our users? What does it mean for our business? What does that... For our users to feel X, can you describe that? Can you write that out? For our business to see this in terms of the revenue growth? (00:33:17): And I think it's really hard because a lot of times, you get your data scientists, you get the PM themselves being like, "Oh man, I'm owning an input metric, not an output metric. And so I definitely can't sign up for that revenue target because I have an input metric." And all of those things are true, but if you don't do the homework of really drawing that line of being like, "This is the ultimate thing I want to do for the company and for my users," then a lot of times you end up hitting all your OKRs, but the company and your users at large are like, "I don't feel anything different." Your company doesn't look at the things that you've worked on and they don't say like "This is a smashing success." Your users are feeling no differently. And so that is the worst outcome in my head where your OKRs, you're almost like doing OKRs for the sake of OKRs, as opposed to letting them be a guide to delivering really great product to your end customer.

**中文翻译:**
是的。关于 OKR，我最大的建议是：在定性上要非常非常清晰。什么样的情况会让你说“是的，我们做得非常棒”？我之所以强调这一点，是因为我看到太多团队被 OKR 困住了。他们会想：“噢天哪，如果我没达到 OKR，我觉得我的名声会变差，或者我可能没法晋升。”OKR 周围充满了恐惧。所以你会看到人们在“留一手”（sandbagging），看到人们犹豫不决，直到最后一刻、直到他们超级有信心时才肯填入数字。这最终导致公司无法创新和快速行动。(00:32:29): 所以我真正推崇的 OKR 是：你是否真的……初衷是什么……我觉得我问团队这个问题问得太多了，但你想要实现的初衷是什么？什么会让你说“上个季度我真的干得漂亮”？与其让所有 OKR 都变绿，我宁愿看到它们是红的或黄的，我们没达标，但我们学到了为什么没达标。事实上，当一切都是绿色时，你会觉得：“我们设定的 OKR 肯定不够宏大。”所以我非常强调：什么是真正的成功？对用户意味着什么？对业务意味着什么？为了让用户感受到 X，你能描述出来吗？你能写出来吗？为了让业务看到收入增长，具体是什么样？(00:33:17): 我认为这很难，因为很多时候，数据科学家或 PM 自己会说：“噢，我负责的是投入指标（input metric），不是产出指标（output metric）。所以我绝对不能承诺那个收入目标，因为我只负责投入指标。”这些都是事实，但如果你不做功课，不去真正划清那条线——“这是我最终想为公司和用户做的事”——那么很多时候你虽然完成了所有 OKR，但公司和广大用户却觉得：“我没感觉到有什么不同。”你的公司看着你做出的东西，不会说“这是一个巨大的成功”。你的用户感觉也没变化。在我看来，这是最糟糕的结果：你几乎是为了做 OKR 而做 OKR，而不是让它引导你为最终客户交付真正伟大的产品。

---

### [00:34:09] Lenny

**English:**
I like the idea of that, but imagine what often happens is you sign up for an ambitious OKR, you don't wait till the last second to commit to it and then ends up being red, and then you go into performance reviews and like, "Oh, Lenny didn't hit his OKRs. Look at this guy. His team is not doing great." How do you think about that as a product leader understanding if the team actually did well and the PM is performing well when they sign up for these really ambitious OKRs and their story's great and they're doing the right thing, but they fail?

**中文翻译:**
我喜欢这个想法，但想象一下经常发生的情况：你承诺了一个宏大的 OKR，你没有等到最后一刻才提交，结果最后变红了（未达标）。然后你去参加绩效评估，别人会说：“噢，Lenny 没达到他的 OKR。看看这家伙，他的团队做得不好。”作为产品领导者，当 PM 承诺了宏大的 OKR，故事讲得很好，做的事情也对，但最后失败了，你如何判断团队是否真的做得好，以及 PM 的表现是否优秀？

---

### [00:34:37] Jiaona Zhang

**English:**
First of all, I think it's creating a culture where you are not punished for that. Because I definitely don't want a culture where it's like you took a risk and you failed and therefore your performance is impacted. I'd much rather people take risks than to be safe. So I think that's the first thing. That being said, you're also not doing a good job as a PM if you're like, "This is my super, super ambitious thing," and you're like, "I have no idea how to achieve it." Your job is to dream big and also have a plan to go tackle it. And so what I would expect the PM to be able to say is, "This is my North Star. I'm not going to be able to do that in a quarter, that just is unreasonable, but here are the five milestones," whatever number, some number of milestones "That it's going to take me to do quarter over quarter to achieve this really, really ambitious thing. And let me draw you that path. Here's the milestone all the way across, and this is the first one. This is why it's so meaningful." (00:35:24): So I expect that combination where you're like, "I know where I'm going. It's really, really ambitious." And then you can then break it down. But again, I would much rather have someone shoot for the moon, even for someone to say like "This is the thing I really want to do. I don't know my path yet" than to be really, really safe. Because when you're safe, you're always going to be building something suboptimal. It's going to be suboptimal use of your resources as opposed to actually trying to figure out what the best swing that you can take is.

**中文翻译:**
首先，我认为要创造一种“不会因此受罚”的文化。因为我绝对不想要一种“你冒了险但失败了，因此绩效受影响”的文化。我宁愿人们去冒险，也不愿他们求稳。这是第一点。话虽如此，如果你作为一个 PM 说“这是我超级宏大的目标”，但又说“我完全不知道怎么实现它”，那你也没做好工作。你的工作是敢于梦想，同时也要有应对计划。所以我期望 PM 能够说：“这是我的北极星指标。我不可能在一个季度内完成，那不现实，但这里有五个里程碑（或者几个里程碑），我需要一个季度接一个季度地去实现这个宏大的目标。让我为你画出这条路径。这是全程的里程碑，这是第一个。这就是为什么它如此有意义。” (00:35:24): 所以我期望这种结合：你既知道要去哪里（非常宏大），又能将其分解。但再次强调，我宁愿有人“志存高远”（shoot for the moon），甚至有人说“这是我真正想做的事，我还没找到路径”，也不愿有人过于求稳。因为当你求稳时，你构建的东西永远是次优的。这会造成资源的次优利用，而不是真正尝试去寻找你能做出的最佳一击。

---

### [00:35:50] Lenny

**English:**
So it sounds like it comes back to the story of the roadmap and what they're trying to accomplish, and just as long as it feels like the story made sense, there's a path there. The team did their best, I think we know it was really ambitious. We kind of knew maybe they wouldn't get there. It sounds like that's kind of the thing you look for in a performance of the PM.

**中文翻译:**
所以听起来这又回到了路线图的故事以及他们想要实现的目标。只要故事听起来合理，有路径可循，团队尽了最大努力，而且我们知道这确实很宏大，甚至预料到可能达不到。听起来这就是你在评估 PM 绩效时看重的东西。

---

### [00:36:07] Jiaona Zhang

**English:**
Totally. Yeah.

**中文翻译:**
完全正确。是的。

---

### [00:36:10] Lenny

**English:**
Awesome. I mentioned WeWork and I want to spend a little time on WeWork. You were at WeWork for about a year, and I think it was in the middle of a lot of the craziness that went on at WeWork.

**中文翻译:**
太棒了。我提到了 WeWork，我想在 WeWork 的话题上花点时间。你在 WeWork 待了大约一年，我想那正是在 WeWork 发生很多疯狂事情的中间阶段。

---

### [00:36:18] Jiaona Zhang

**English:**
It was. It was 2019, I feel like that year it was either headlines were either about Trump or about WeWork in the news.

**中文翻译:**
是的。那是 2019 年，我觉得那年的新闻头条要么是关于特朗普，要么是关于 WeWork。

---

### [00:36:26] Lenny

**English:**
That's tough. So what was that like being a PM leader at a company in that craziness? And is there a takeaway from that experience that helps you be a better product manager, a leader, person?

**中文翻译:**
那真不容易。在那种疯狂的局面下，在一家公司担任 PM 领导者是什么感觉？那段经历有没有什么让你成为更好的产品经理、领导者或个人的感悟？

---

### [00:36:37] Jiaona Zhang

**English:**
Yeah, I learned a lot from my time there. I think the most important lesson I learned was really around... I think there's like a people leader management lesson, and then there's also just like a how do you build an org period. The people lesson I learned was just really around empathy. In fact, essentially what I was doing was I built a team. I spent the first six months of my time there actually growing my team a lot, and not just in the US but in Asia and in Europe. And then the second half of my time there was actually being like, "What do we do? If this is what's happening with WeWork, what are we actually going to do with all of these people who have come to WeWork to work?" (00:37:19): And there was so many lessons there around leadership, around how do you think about people? How do you think about giving them the right transition plans? It was a lot of learning. And I think probably a lot of people, even right now through the macroeconomic downturn, they're learning that lesson in a really hard way. And so it was definitely something that I got a crash course on, I think early. (00:37:44): And the second lesson really was around not over-hiring. And so I think that was huge, and I think I personally learned that lesson through my time there. And it's something that I'm very conscious of at any company that I go to. Just because laying off half your team is a terrible feeling. Literally having hired people and then having to let them go, it's not something you want to do. And so being really thoughtful around how do we not over-hire? How are we really clear about, again, these milestones of we got to get through these gates, we got to be able to show these types of results, and then we unlock hiring in X, Y, Z ways? That hygiene is really, really important.

**中文翻译:**
是的，我在那段时间学到了很多。我认为最重要的教训是关于……我觉得有一个关于人员领导和管理的教训，还有一个关于如何构建组织的教训。我学到的人员管理教训主要是关于“共情”（empathy）。事实上，我当时主要在做的是组建团队。前六个月我花了很多精力在扩充团队上，不仅是在美国，还有亚洲和欧洲。而我待在那里的后半年，实际上是在想：“我们该怎么办？如果 WeWork 发生了这些事，我们该如何安置这些来到 WeWork 工作的人？” (00:37:19): 关于领导力、关于如何看待人、关于如何给他们合适的过渡计划，有很多教训。那是一次深刻的学习。我想现在很多人在宏观经济低迷时期，也在以一种非常痛苦的方式学习这一课。所以这绝对是我早期经历的一次“速成课”。(00:37:44): 第二个教训是关于“不要过度招聘”。我认为这非常关键，我个人在那段经历中深刻体会到了这一点。无论我去哪家公司，我都会对此保持警惕。因为裁掉一半的团队成员感觉非常糟糕。亲手招来的人，然后不得不让他们离开，这不是你想做的事。所以要非常周密地考虑：我们如何不招人过剩？我们如何再次明确这些里程碑——我们必须通过这些关卡，必须展示这些结果，然后才以 X、Y、Z 的方式开启招聘？这种“管理卫生”（hygiene）非常重要。

---

### [00:38:22] Lenny

**English:**
Feels like this connects back to the Airbnb Plus story of "Let's just be really ambitious. We don't have any idea how we're going to get there, but we're just going to go for it, hire like crazy, scale, put a lot of investment in this thing and hopefully we'll figure it out."

**中文翻译:**
感觉这又回到了 Airbnb Plus 的故事：“让我们保持宏大野心。我们不知道怎么达到那里，但我们就这么干吧，疯狂招人、扩张规模、投入大量资金，希望能搞定。”

---

### [00:38:34] Jiaona Zhang

**English:**
I do think there was a little bit of that in the ethos of how WeWork was functioning, for sure. I think that what was really important for us to do was to be like, "We have this." Operationally, WeWork is really strong. In fact, I went to WeWork because having been at Airbnb, I was like, "I don't feel like we've dialed this operational muscle down," but I know from what I've seen and the way WeWork has expanded, that they're really, really excellent at the operations. But I think it was, again, we hired beyond our skis on the tech side. It's like we don't need a team of this size to go do the things that are needed for the product to feel really great. At the end of the day, it's about booking. And yes, there's technology that would accelerate that, but do we need it to be super platform aware? Do we need it to be super futuristic? That's actually not what people care about. (00:39:19): So this all goes back to what are people's core desires in whatever product that they're using, whatever thing that your business is trying to serve them? And so really understanding that will help you have a sense of, "Hey, you can still be really ambitious." Again, in a hybrid world, it's like why have real dedicated office space? Every company could go through WeWork as opposed to this dedicated space. That's still a really good idea, that's still a really big vision and a relevant vision, but what's the key piece of that vision? The key piece of that vision is around inventory, and then you make that inventory management easier. You make all of these things easier, but that's not a technology play in the same way as it is an operational play. So just really understanding, again, you can still dream really big, but you don't have to dream big and hire big in all the things in order to have a very ambitious vision that you deliver to the market.

**中文翻译:**
我确实认为 WeWork 当时的运作氛围中确实有这种成分。我认为对我们来说真正重要的是意识到：“我们拥有这个优势。”在运营上，WeWork 非常强大。事实上，我之所以去 WeWork，是因为在 Airbnb 待过之后，我觉得我们还没完全掌握这种运营基因，但我从 WeWork 的扩张方式中看到，他们在运营上非常出色。但我认为，我们在技术端招聘过度了（hired beyond our skis）。我们不需要这么大规模的团队来做那些让产品感觉很棒的事情。归根结底，核心是预订。是的，技术可以加速这个过程，但我们需要它具有超级平台意识吗？需要它超级未来感吗？那其实不是人们关心的。(00:39:19): 所以这又回到了：人们在使用任何产品、在接受你的业务服务时，他们的核心欲望是什么？真正理解这一点会让你意识到：“嘿，你仍然可以非常有野心。”比如在混合办公的世界里，为什么要有专门的办公室？每家公司都可以通过 WeWork 而不是租用专门空间。这仍然是一个很好的主意，仍然是一个宏大且相关的愿景，但这个愿景的关键部分是什么？关键部分是库存，然后你让库存管理变得更容易。你让所有这些事情变得更容易，但这更多是运营层面的博弈，而不是技术层面的。所以，再次强调，你仍然可以梦想远大，但你不需要在所有事情上都大举招聘，才能向市场交付一个宏大的愿景。

---

### [00:40:13] Lenny

**English:**
If you think back to WeWork, what was your favorite memory and what was your hardest, least happy memory if anything comes to mind?

**中文翻译:**
回想 WeWork，你最美好的回忆是什么？最艰难、最不快乐的回忆又是什么？

---

### [00:40:23] Jiaona Zhang

**English:**
I think this idea dream really big. I think everyone who had joined WeWork, they were like, "We could do a lot here." The idea of really the physical space infusing technology. I just feel like the people at WeWork were dreamers in the best possible way. So that definitely... I feel like for every company that I've been at, it's really about, you join... I personally joined for the product, but I stayed for the people you joined because you're like, "I want to work on this mission. This product is really motivating." And then you really stay for the people. And the people at We WeWork were really great. So that was definitely my favorite memory. (00:40:58): I think the hardest memory was, this gets a little bit personal, but I was actually in my first trimester when we were going through all of these layoffs and I basically was faced with a choice. It was like, "Hey, do I stay at WeWork? I would be guaranteed maternity leave." I was going to be moved onto this other team that was definitely going to stay. "Do I do that or do I actually..." And I think there just a last piece of... The thing I was wrestling with is I hired a lot of these people and I felt really responsible for the fact that I convinced them to come to this company that now was going through a lot of change. (00:41:33): And I specifically remember someone when I hired them, we had a long conversation about their visa and in my head I was like, "I just don't feel right. Again, laying someone off. That's only going to have so many days to be able to go find their new role." And so the hardest moment, I actually remember this very vividly, "Am I going to take this new role or am I going to put myself on a layoff list essentially and give the role to someone else on the team?" When I really think about it, yes, I was pregnant, but I would have more time and more freedom to go find my next thing versus someone who I brought to the company who was on a visa. (00:42:09): That to me just really stood out and goes back to this concept around leadership is so much about empathy and people as much as it's about understanding your market, your customers, and the strategy of your product.

**中文翻译:**
我认为是那种“敢于梦想”的氛围。我觉得每个加入 WeWork 的人都觉得：“我们在这里大有可为。”那种将技术注入物理空间的想法。我觉得 WeWork 的人都是最纯粹的梦想家。所以这绝对是……我觉得对于我待过的每家公司，都是这样：你因为产品而加入——我个人是因为产品加入的，但因为人而留下。你加入是因为你想为这个使命工作，这个产品很激励人心。然后你因为人而留下。WeWork 的人真的很棒。所以这绝对是我最美好的回忆。(00:40:58): 我认为最艰难的回忆是——这涉及一点私事——当我们经历所有这些裁员时，我正处于怀孕初期（前三个月），我面临一个选择。当时的情况是：“嘿，我要留在 WeWork 吗？我可以保证有产假。”我会被调到另一个肯定会保留的团队。“我是这样做，还是我实际上……”我当时纠结的是，我招了很多人，我感到非常有责任感，因为是我说服他们来到这家现在正经历剧变的公司。(00:41:33): 我特别记得招某个人时，我们关于他的签证聊了很久。我心里想：“我真的觉得不对劲。又要裁员了，而他只有有限的天数去寻找新工作。”所以我记得非常清楚那个最艰难的时刻：“我是要接受这个新职位，还是把自己放进裁员名单，把职位留给团队里的其他人？”当我仔细思考时，是的，我怀孕了，但我有更多的时间和自由去寻找下一份工作，而那个我带进公司的人正面临签证问题。(00:42:09): 这件事对我来说非常深刻，它回到了那个理念：领导力不仅关乎理解市场、客户和产品战略，同样也关乎共情和人。

---

### [00:42:24] Lenny

**English:**
Damn. What convinced you eventually to take off and try something different?

**中文翻译:**
天哪。最终是什么说服你离开并尝试不同的东西？

---

### [00:42:31] Jiaona Zhang

**English:**
I made the call of, in that particular case, I'd give the role to someone else. And then once I made that call, I was like, "I got to go find something. I know that this is my last day, so I have to go find something." And it was really interesting because I actually... I went through an interview process. I was in my second trimester and then ultimately I chose to join Webflow and I joined when I was literally at the beginning of my third trimester. So I had exactly 90 days before my first son was born.

**中文翻译:**
在那个特定的情况下，我决定把职位留给别人。一旦我做了那个决定，我就想：“我得去找点别的了。我知道这是我的最后一天，所以我必须去找工作。”这很有趣，因为我……我经历了一个面试过程。当时我处于怀孕中期，最终我选择加入 Webflow，我加入时正好是怀孕晚期（最后三个月）的开始。所以在我大儿子出生前，我正好有 90 天的时间。

---

### [00:43:01] Lenny

**English:**
That's a great segue to the question I was going to ask is around your 90-day plan that I know you put a lot of thought into how to think about the first 90 days, but before we get there, the movie on WeWork with Jared Leto, how similar to reality was that brought?

**中文翻译:**
这很好地引出了我正想问的问题，即关于你的“90 天计划”。我知道你对如何思考入职前 90 天投入了很多思考。但在那之前，Jared Leto 演的那部关于 WeWork 的电影（《初创玩家》），和现实有多接近？

---

### [00:43:16] Jiaona Zhang

**English:**
I actually have not watched it. Parent life, you don't have any time. And I do think there's... I feel like if you ask people at Uber, if they've watched some of the [shows] they're like, "It's not for me." Same way why I haven't watched Silicon Valley. You're like, "It's a little too close to home."

**中文翻译:**
我其实还没看。父母的生活就是这样，根本没时间。而且我觉得……就像如果你问 Uber 的人有没有看关于他们的剧，他们会说“那不适合我”。就像我也没看《硅谷》一样。你会觉得“那离生活太近了”。

---

### [00:43:35] Lenny

**English:**
It was quite a great movie and I really enjoyed it. I'm curious how close it was to real life. Okay, so then back to the 90-day questions. So I know you spent a lot of time thinking about your first 90 days at Webflow, you're pregnant as you described, and you have a perspective on just how to think about the first 90 days when you join a company. Can you just share what you've learned there, what you recommend there?

**中文翻译:**
那是一部很棒的电影，我很喜欢。我很好奇它和现实有多接近。好，回到 90 天的问题。我知道你花了很多时间思考在 Webflow 的前 90 天，正如你所说，当时你怀孕了。你对于加入一家公司后如何思考前 90 天有自己的见解。你能分享一下你学到了什么，以及你推荐的做法吗？

---

### [00:43:55] Jiaona Zhang

**English:**
Yeah, I do think the first 90 days, depending on your role is very different. But maybe I'll just talk a little bit about the first 90 days as a head of product. Because you're like, "Whoa." Or even just as a leader, how do you go in, how do you really absorb all the information and get all the context you need and then affect change? And I think what was unique about my first 90 days is it was time bound. It was literally something where you're like, "Sure, I'd love to absorb information for many months, but I just don't have the luxury of the time" and so- (00:44:21): Because you're going to go on mat leave right after? (00:44:23): Because yeah, essentially I was going to go on mat leave. (00:44:25): Got it. (00:44:25): That's right. And so the biggest things that I thought a lot about for my first 90 days was at the end of the day, yes, you have to really... The most important thing for anyone's for assigning days is to build context and to build context well. But what I had to think about a lot was, "How do I quickly build context probably faster than I would be given the luxury any other time in my life?" And so I thought a lot about who do I speak to at the company? How do I create even just a calendar of speaking to people? Yes, my leadership team, but also across a bunch of functions and then across a bunch of levels. So it was really important for me to even start talking to some of the engineers from the team, some of the engineers who had been there for the longest time to really understand, what's hard about our tech stack? What's going on? What's hard about your day to day? (00:45:15): And so I actually took time to really think about, "I want to speak to all of these types of people at the company." And I packed my first couple weeks with a lot of those meetings. And so I think that was one piece, which is like how do you build context as quickly as possible? And my tip there is again, it's not just with your peers, it's not even just with your team, but to really think across all the different functions and then think about where you're going to get the most amount of information in that particular function. I think that was one piece of it. (00:45:43): The other piece was I was like, "I'm going to be out." I was only out for two months, but I was like, "That's still a long period of time in the life of a startup." And so what it was really important to me was like, I did not go out having just listened and like "Great, I have the context, I'll see you in two months." But it was really important for me to actually have a plan in place before I went out for my team. (00:46:03): And so there were pieces where I was like, "I want to first, again, get that lay of the land. I want to have enough of a strategic, 'Hey, these things make sense. Keep going, keep executing.' 'These things don't make sense, let's identify what those things are and let's actually start to do research around these things so that when I do come back, we have a body of work that we can look at and be like, "Okay, this information, this data is making us choose to go down the path." Or "This is a go or no-go decision. We can make that decision now where we couldn't make that decision before."'" (00:46:34): So that was another big piece, which is getting all the strategic pieces in place, having a plan laid out and explicitly articulating in that plan, "Keep moving. These are things that we got to do a lot more research on." And then assigning people like, "Hey, you're going to do this research and then we're going to come back and talk about it in the two months that I was out." And I also took the time, I actually... Funny story, I think I literally had a board meeting the day before I went in for a checkup, and then in the checkup they're like, "You're in labor." And it was really important for me to do that because I was like, "For the things that I'm seeing, for the gaps that I'm seeing. I want everyone to be aware. I don't want to just be with one founder. I want the whole leadership team. I want all the founders, I want the board. I want everyone to be aware that." (00:47:14): For example, engineering hiring was really, really important. And I was communicating, "Hey, we are just not staffed in a way where we can deliver some of the ambitious things that we want to do." And so explicitly calling those things out and creating awareness around them and then asking other executives to step in and be accountable, those were big pieces of what I wanted to achieve in my first 90 days.

**中文翻译:**
是的，我认为前 90 天根据你的角色会有很大不同。但也许我可以谈谈作为产品负责人（Head of Product）的前 90 天。因为你会觉得“哇”。或者仅仅作为一名领导者，你如何进入公司，如何真正吸收所有信息，获得所需的所有背景（context），然后推动变革？我认为我前 90 天的独特之处在于它有时间限制。这真的是一种“当然，我很想花几个月时间吸收信息，但我没有那个奢侈的时间”的情况，所以——(00:44:21): 因为你之后马上就要休产假？(00:44:23): 是的，基本上我马上就要休产假了。(00:44:25): 明白了。(00:44:25): 没错。所以我前 90 天思考最多的事情是，归根结底，是的，你必须……对任何入职的人来说，最重要的事情是建立背景，并很好地建立背景。但我必须思考的是：“我如何快速建立背景，可能比我生命中任何其他时候都要快？”所以我花了很多心思在：我要和公司里的谁交谈？我如何制定一个交谈日程表？不仅是我的领导团队，还要跨职能、跨层级。对我来说，甚至开始与团队中的一些工程师交谈也非常重要，尤其是那些待得最久的工程师，去真正了解：我们的技术栈难点在哪？发生了什么？你日常工作的难点是什么？(00:45:15): 所以我真的花时间去想：“我想和公司里所有这些类型的人交谈。”我在头几周安排了大量的这类会议。我认为这是第一部分，即如何尽快建立背景？我的建议是，再次强调，不仅是与你的同级，甚至不仅是与你的团队，还要跨职能思考，并思考在那个特定职能中，你从哪里能获得最多的信息。这是其中一个方面。(00:45:43): 另一方面是，我当时想：“我要离开一段时间。”虽然我只离开了两个月，但对于一家初创公司来说，那仍然是一段很长的时间。所以对我来说非常重要的一点是：我不能只是听完背景后说“太好了，我有背景了，两个月后见”。对我来说，在休假前为团队制定好计划非常重要。(00:46:03): 所以有一些部分我会说：“首先，我要再次了解全局。我要有足够的战略判断，‘嘿，这些事情是合理的，继续执行。’‘这些事情不合理，让我们找出原因，并开始针对这些事情进行研究，这样当我回来时，我们有一套可以参考的工作成果，可以说：好的，这些信息和数据让我们选择走这条路。’或者‘这是一个继续或停止的决定，我们现在可以做决定了，而以前不能。’”(00:46:34): 所以这是另一个重点，即落实所有战略部分，制定好计划，并在计划中明确表达：“继续推进。这些是我们需要做更多研究的事情。”然后指派人员：“嘿，你负责这项研究，然后在我不在的两个月里，我们会回来讨论它。”我还花时间……有趣的故事，我记得就在我去产检的前一天，我还在开董事会，然后产检时他们说：“你要生了。”对我来说，做这些事非常重要，因为我想：“对于我看到的这些问题和差距，我希望每个人都意识到。我不想只跟一个创始人谈，我希望整个领导团队、所有创始人、董事会都知道。”(00:47:14): 例如，工程师招聘非常重要。我当时在沟通：“嘿，我们的人员配置根本无法交付我们想要做的那些宏大目标。”所以明确指出这些问题，提高大家的意识，然后要求其他高管介入并负责，这些都是我想在前 90 天实现的重要目标。

---

### [00:47:34] Lenny

**English:**
So I take notes on this. So the first is just get context, figure out who you need to talk to. Is there a tip there of just how many people? Because you could do this infinitely, meet everyone eventually. How many people did you end up maybe scheduling meetings with?

**中文翻译:**
我记下来了。第一步是获取背景，弄清楚你需要和谁谈。关于人数有什么建议吗？因为你可以无限期地做这件事，最终见完所有人。你最后大概安排了和多少人见面？

---

### [00:47:47] Jiaona Zhang

**English:**
Definitely everyone on my direct team and definitely everyone on the leadership team, so call it those two combined were maybe, I don't know, like 20 or so people, 25 people. But then it was really about finding the people in the other functions. And to me, for any given function, it was really getting a read from, again, that leader, but also someone closer to the actual work. And so you look at the functions, whether it's product marketing or engineering, whatever it was. Back then I didn't have designs, like design. And really getting a couple of data points for each one of those functions. So if you add that up, that probably was like 40 to 50 conversations. But again, if you're doing them back to back and you're really synthesizing, you're actually getting a really good picture of what's going on.

**中文翻译:**
肯定包括我直属团队的每一个人，以及领导团队的每一个人，这两部分加起来大概有 20 到 25 人。但接下来的关键是找到其他职能部门的人。对我来说，对于任何一个职能部门，我不仅要听取该负责人的看法，还要听取更接近实际工作的人的看法。所以你会看各个职能，无论是产品市场（PMM）还是工程。当时我还没负责设计。我真的会从每个职能部门获取几个数据点。所以加起来，大概有 40 到 50 次谈话。但如果你是连续进行这些谈话并进行综合分析，你实际上能对现状有一个非常清晰的了解。

---

### [00:48:35] Lenny

**English:**
And then the second bucket was identify things that need to be shifted, changed, flagged. I imagine there's also an element of trust and building trust. Was that a part of this, of how you thought about it? Or do you feel like as a product leader coming in that's less essential versus say an new PM joining it? A team as an IC?

**中文翻译:**
第二部分是识别需要调整、改变或标记的事情。我猜这里也有信任和建立信任的因素。这是你思考过程的一部分吗？还是你觉得作为产品领导者入职，这相对于新 PM 作为个人贡献者（IC）加入团队来说没那么重要？

---

### [00:48:53] Jiaona Zhang

**English:**
Trust is so important. Trust is everything. As a PM, the trust that your cross-functional partners have in you, the trust that the CEO has is you... It's huge. Trust is everything. And maybe here, I'll even talk about some of the mistakes I made in the first 90 days. I think I was so much like, "I only have 90 days. I got to go, go, go. We got to go." I was almost pushing too hard. I was pushing too hard for change. I think that's the tricky part that every product leader, especially if they're coming into a new role, has to figure out how do I gain trust and then take that trust and then push for change as opposed to push for change too quickly before I have that trust? (00:49:33): So again, it was a personal learning and I think part of it was really driven by the time-bound nature of it, but hopefully not everyone has only 90 days. So if you take that learning into mind, it's really thinking about your trust as a bank. It's like you're putting money into your bank and then at some point you're going to take money out, you're going to use that social capital, you're going to use that trust to go push for things, push for change, but you have to be thoughtful about how full your piggy bank is and you don't want to be spending when you don't have the trust in the bank.

**中文翻译:**
信任非常重要。信任就是一切。作为 PM，跨职能合作伙伴对你的信任，CEO 对你的信任……这至关重要。信任就是一切。也许在这里，我甚至可以谈谈我在前 90 天犯的一些错误。我想我当时太焦虑了：“我只有 90 天，我得冲，冲，冲，我们得行动。”我几乎推得太猛了，推动变革太急了。我认为这是每个产品领导者，尤其是进入新角色时，必须弄清楚的棘手部分：我如何获得信任，然后利用这种信任去推动变革，而不是在获得信任之前就过快地推动变革？(00:49:33): 所以，这又是一个个人教训，我认为部分原因确实是受时间限制驱动的，但希望不是每个人都只有 90 天。如果你记住这个教训，就要把信任看作一家银行。就像你在银行里存钱，然后在某个时刻你会取钱，你会利用这些社交资本，利用这些信任去推动事情、推动变革，但你必须考虑你的“存钱罐”有多满，你不想在银行里没有信任时就过度消费。

---

### [00:50:06] Lenny

**English:**
What were signs maybe looking back that you didn't necessarily have the trust that you thought you did or you should have had?

**中文翻译:**
回过头来看，有哪些迹象表明你当时可能并没有像你想象中那样拥有足够的信任，或者说没有达到应有的信任水平？

---

### [00:50:13] Jiaona Zhang

**English:**
I think something, a product like Webflow is a very complex product and there are so many pieces to it. It's very difficult to learn the product in the first 90 days, especially if I was also prioritizing all these conversations with the team. And so I think that again, without the time constraint, what I would recommend is to be like, "Hey, every product leader has to take the time to really go deep on the product." Given the complexity of Webflow and given the time-bound nature of when I had to go out, and given the fact I really also wanted to build that social context around what is working and not working from a function working together? Not just what the product is. What I wasn't able to do was spend enough time with the product to be able to have all of that in my back pocket to be able to be like, "Oh, I know how this, this and this works because I've literally used it a bunch." (00:51:06): So you had to choose. And in my head I was like, "I would much rather understand how the team is functioning together." And the reality is the team was comprised of a lot of people with a lot of deep product context. So ultimately as all things in product, you know this Lenny, everything's a trade off. And so it's a trade off. And so you had to make the call of what you wanted to trade off. And the thing I traded off the most was that product context in my first 90 days. And again, it got me some things because I was able to have the time to go deep on the things I mentioned, but it didn't give me enough trust in the piggy bank around the actual product fundamentals or product, the actual thing we're building as opposed to the discipline.

**中文翻译:**
我认为像 Webflow 这样的产品非常复杂，包含很多部分。在前 90 天内学会这个产品是非常困难的，尤其是当我还在优先处理与团队的所有这些谈话时。所以我想，如果没有时间限制，我会建议：“嘿，每个产品领导者都必须花时间深入研究产品。”考虑到 Webflow 的复杂性，以及我必须休假的紧迫性，再加上我真的很想建立关于“职能部门协作中哪些行得通、哪些行不通”的社交背景，而不仅仅是产品本身。我当时没能做到的是花足够的时间研究产品，以便能胸有成竹地说：“噢，我知道这个、这个和那个是怎么运作的，因为我亲自用过很多次。”(00:51:06): 所以你必须做出选择。在我脑子里，我想的是：“我宁愿先了解团队是如何协作的。”而现实是，团队中有很多拥有深厚产品背景的人。所以最终，就像产品中的所有事情一样，Lenny 你知道的，一切都是权衡（trade-off）。所以你必须决定你想牺牲什么。我在前 90 天牺牲最多的是“产品背景”。再次强调，这让我获得了一些东西，因为我有时间深入研究我提到的那些事，但它没能让我在“产品基本功”或“我们正在构建的实际产品”方面在信任银行里存入足够的钱，我存入的更多是关于“纪律和流程”的信任。

---

### [00:51:48] Lenny

**English:**
So at this point you've worked at four legendary companies, Dropbox, Airbnb, WeWork, Webflow. If we were to just go through each one, what's just one lesson that you take away from each of these companies in terms of how it's informed either how you build product or lead people, anything along those lines?

**中文翻译:**
到目前为止，你已经在四家传奇公司工作过：Dropbox、Airbnb、WeWork、Webflow。如果我们逐一梳理，你从每家公司学到的、对你构建产品或领导团队产生影响的一个教训是什么？

---

### [00:52:06] Jiaona Zhang

**English:**
I'm going to actually give you my biggest thing across all four on the product side. And then on the people side. There are so many nuances also, and we could spend another two hours talking about each one of these. But I think just to impart my biggest high level learning. On the product side, it's about really understanding why people love you and not forgetting to invest deeply in that core concept and then building everything around that. And so I'll walk you through the different companies. So specifically for Dropbox, I think we did waste cycles where we would be like, "Oh, we see X happening in the market. Slack is really taking off. Why don't we build a Slack competitor? Or why don't we build chat?" And I think that it really missed this idea of, "Why do people love Dropbox and what do we need to do to continue investing in that so that remains true?" People love Dropbox for simplicity, for how delightful it is, how easy it is to use. (00:53:08): I think we actually went for a period of time where we didn't invest enough in just performance of our client. How long it takes for the thing to sync is a big part of the experience of using Dropbox. And so I think that is a big, big learning where it's really understanding that would've shifted your investments into doing that performance work as opposed to chasing the competitive space. And I think going back to chasing the competitive space, it's this idea of what is your alpha? Again, why do people come to you? People come to Dropbox again for all the things I mentioned, but also ultimately we have your files. So if you're going and building a chat product, that's fine, but really the best chat experience or collaboration experience is going to be more around your files as opposed to around just the conversation. So I think really understanding that is a huge, huge learning. (00:54:01): And I think that same lesson can be... It's very true for Airbnb. So at the end of the day, Airbnb is known for all the homes, the fact that these are homes that real people put on the platform. We spent some time talking about Airbnb Plus. When you are thinking "I got to go in and I got to manage the inventory and inspect it," you're almost like taking away from the thing that is what makes Air Airbnb special as opposed to leaning into it. We also spend a lot of time on experiences. We dabbled in transportation, we spent a bunch of times on other things. But if you really sat back and you're like, "What makes Air Airbnb special and how do you double down on your strength?" It's spending the time to make that experience of really understanding what's in a home so people don't go and get surprised. Making that onboarding journey for the host and then discovery journey and guest booking journey really, really great. (00:54:52): So I think that that same lesson when applied to Airbnb, would've in my head changed the way we invested and I think we would've gotten more returns, as opposed to spreading ourselves and then having things that sort of work but then didn't quite work. And then again, same principle applies to WeWork, what is the thing that makes you really special? It's the inventory it. It's not actually like, "Oh, it's so amazing that I get to use this key card and this key card does 10 different things." That's not what makes the WeWork experience special. And so again, if you knew that you wouldn't spend all that time being like, "I'm going to really deeply invest in the tech team, I'm going to do all these interesting things." You'd be like, "I just need to make inventory management great. I need to make it so that the sales team, the operations team, they have the tools they need to go out and get the inventory on the platform." You wouldn't do all this other stuff that's just not the core. (00:55:44): And then finally, even at Webflow, we are learning this lesson all the time where at the end of the day, people really love our designer. They love the fact that they can use it. It does so much for them, it's so powerful. And then you add our CMS and it's really powerful. You can design with data. So investing deeply there as opposed to spreading ourselves too thin is also a lesson. I think across so many companies this lesson around understand why people love you, double down on that and then whatever else you build around it... Because again, you don't want to also be like... You're not like a single product company, you're not like a one trick pony. You are going to invest in these multi products, but when you invest in a new product, really go back to, again, what's the core of our advantage and how can that be something we leverage in delivering a really great product experience for our users in X adjacent area or x add-on?

**中文翻译:**
我实际上会给你一个贯穿这四家公司在产品端和人员端最大的感悟。这里有很多细微差别，我们可以再花两个小时讨论每一个。但我只想传达我最大的高层级学习成果。在产品端，关键在于真正理解“为什么人们爱你”，并且不要忘记深入投资于那个核心概念，然后围绕它构建一切。我带你梳理一下这几家公司。具体到 Dropbox，我认为我们确实浪费了一些周期，当时我们会想：“噢，我们看到市场上有 X 动态，Slack 真的很火，我们为什么不做一个 Slack 的竞争对手？或者为什么不做一个聊天功能？”我认为这真的忽略了：“为什么人们爱 Dropbox？我们需要做什么来继续投资这一点，使其保持真实？”人们爱 Dropbox 是因为它的简单、它的愉悦感、它的易用性。(00:53:08): 我认为我们实际上有一段时间没有在客户端性能上投入足够的精力。同步需要多长时间是使用 Dropbox 体验的重要组成部分。所以我认为这是一个巨大的教训：真正理解这一点本可以将你的投资转向性能工作，而不是去追逐竞争领域。回到追逐竞争领域，这关乎“你的超额优势（alpha）是什么？”再次强调，人们为什么来找你？人们来找 Dropbox 是因为我提到的所有原因，但归根结底是因为我们存着你的文件。所以如果你去开发聊天产品，那没问题，但真正最好的聊天或协作体验应该是围绕你的文件展开，而不是仅仅围绕对话。所以真正理解这一点是一个巨大的教训。(00:54:01): 同样的教训也适用于 Airbnb。归根结底，Airbnb 以其所有的房源而闻名，这些房源是真实的人放在平台上的。我们刚才聊了 Airbnb Plus。当你考虑“我要介入并管理库存并进行检查”时，你几乎是在削弱让 Airbnb 变得特别的东西，而不是强化它。我们还花了很多时间在“体验”上，涉足了交通，花了很多时间在其他事情上。但如果你真的坐下来想：“是什么让 Airbnb 特别？你如何加倍发挥你的优势？”那就是花时间让“真正了解房屋内况”的体验变得更好，这样人们就不会感到意外。让房东的入驻流程、房客的发现流程和预订流程变得非常非常棒。(00:54:52): 所以我认为同样的教训如果应用在 Airbnb 上，会改变我们的投资方式，我认为我们会获得更多回报，而不是分散精力去做一些“有点用但又不完全有用”的事情。同样的原则也适用于 WeWork：是什么让你真正特别？是库存。其实并不是“噢，太神奇了，我可以用这张门禁卡，这张卡能做 10 种不同的事”。那不是让 WeWork 体验变得特别的原因。所以，如果你知道这一点，你就不会花那么多时间去想“我要深度投资技术团队，我要做所有这些有趣的事”。你会觉得：“我只需要把库存管理做好。我需要确保销售团队、运营团队拥有他们所需的工具，以便在平台上获取库存。”你不会去做所有这些非核心的事情。(00:55:44): 最后，即使在 Webflow，我们也一直在学习这一课：归根结底，人们真的很喜欢我们的设计器（Designer）。他们喜欢可以使用它，它能为他们做这么多事，它如此强大。再加上我们的 CMS，它非常强大，你可以用数据进行设计。所以，深入投资于此，而不是分散精力，也是一个教训。我认为在这么多公司中，这个教训就是：理解为什么人们爱你，加倍投入，然后围绕它构建其他东西……因为你也不想成为一个单一产品公司，不想成为“只会一招的小马”。你会投资多产品，但当你投资新产品时，一定要回到：我们的核心优势是什么？我们如何利用它在相邻领域或插件中为用户提供真正伟大的产品体验？

---

### [00:56:34] Lenny

**English:**
Final question before we get to a very exciting lightning round.

**中文翻译:**
在进入非常刺激的闪电轮提问之前，最后一个问题。

---

### [00:56:38] Jiaona Zhang

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:56:38] Lenny

**English:**
What is the best advice that you've gotten that has transformed or impacted the way you build product or hire or lead? Does anything come to mind?

**中文翻译:**
你收到的改变或影响了你构建产品、招聘或领导方式的最佳建议是什么？有什么能想到的吗？

---

### [00:56:48] Jiaona Zhang

**English:**
I can't remember where I explicitly got this advice, but I feel like I got it in multiple forms and it just really sat with me. It's this idea of asking for help. I do think about that a lot because I think there are so many times when you're like, "Oh, I'm the leader of X thing, everyone's looking to me like the [buck] stops in me. I need to have my act together. I can't be asking for help. If I'm asking for help, is everyone feel like I don't know what I'm doing?" (00:57:13): And ever since I've been people managing, I've been pushing myself to be like, "I know it feels non-intuitive to go ask for help when everyone is looking to for you to give them advice, but if you don't ask for help, there's so many times where you're just going to be sitting there with your problems. Whatever you have in your mind is just not the global best thing and you have to go ask for help. You have to go ask for help from your partners, your peers, even your team, even being my team, I don't know. I really don't know. Here's the guidelines, here's how you might want to think about it, but I don't know the answer, you know the answer." Going out and getting mentorship. I think this idea of really being able to say, "Be honest about what you know and what you don't know and ask for help when you don't know something," that's probably the biggest thing that I hold as a core principle and just helps me build better products.

**中文翻译:**
我不记得具体是从哪里得到的这个建议，但我觉得我以多种形式收到过它，它深深地印在了我的脑海里。那就是“寻求帮助”。我经常思考这一点，因为很多时候你会觉得：“噢，我是 X 事情的领导者，每个人都看着我，责任在我。我得表现得很专业，我不能寻求帮助。如果我寻求帮助，大家会不会觉得我不知道自己在做什么？” (00:57:13): 自从我开始管理人员以来，我一直在强迫自己：“我知道当每个人都指望你给他们建议时，去寻求帮助感觉很不直观，但如果你不寻求帮助，很多时候你就会坐困愁城。你脑子里想的可能并不是全局最优解，你必须去寻求帮助。你必须向你的合作伙伴、同行甚至你的团队寻求帮助。甚至对我的团队说：‘我不知道，我真的不知道。这是准则，这是你们可以思考的方式，但我没有答案，你们才有答案。’”去寻找导师。我认为这种能够说出“诚实面对你知道和不知道的事情，并在不知道时寻求帮助”的能力，可能是我坚持的核心原则中最大的一点，它帮助我构建了更好的产品。

---

### [00:58:03] Lenny

**English:**
What's something that you've asked for help about recently as an example?

**中文翻译:**
举个例子，你最近在什么事情上寻求过帮助？

---

### [00:58:06] Jiaona Zhang

**English:**
So I'm working on our product strategy for the next three years. I'm thinking a lot about how do we really leverage AI to support all of our service providers and support all our users who come into Webflow and have a hard time sometimes learning how to use our product. And so I'm not an AI expert, so asking for help from the founders, from external folks, from engineers to be like, "What's happening?" Every single week I feel like LLMs are changing. What's possible in the world is changing. And so constantly asking for help to iterate on the strategy is a huge part of... It's happening every day for me and my job.

**中文翻译:**
我正在制定我们未来三年的产品战略。我一直在思考如何真正利用 AI 来支持我们所有的服务提供商，并支持那些进入 Webflow 但有时觉得学习成本很高的用户。我不是 AI 专家，所以我向创始人、外部人士和工程师寻求帮助，问他们：“现在进展如何？”我觉得每周大语言模型（LLM）都在变化，世界上可能实现的事情也在变化。所以，不断寻求帮助来迭代战略是我工作中每天都在发生的重要部分。

---

### [00:58:40] Lenny

**English:**
JZ, we've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
JZ，我们进入了非常刺激的闪电轮提问。我有六个问题要问你。准备好了吗？

---

### [00:58:44] Jiaona Zhang

**English:**
All right, let's do it.

**中文翻译:**
好，来吧。

---

### [00:58:46] Lenny

**English:**
What are two or three books that you've most recommended to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [00:58:50] Jiaona Zhang

**English:**
I love the Design Sprint by Google. I also really Julie's book around managing people how to be a good manager. That one's really great. And so those are my more business side of the house books. And then we can also talk about fantasy stuff if you want. But-

**中文翻译:**
我喜欢 Google 的《设计冲刺》（Design Sprint）。我也很喜欢 Julie Zhuo 的那本关于管理人的书（《经理人的养成》），那本书非常棒。这些是我在业务方面的推荐。如果你愿意，我们也可以聊聊奇幻小说。但是——

---

### [00:59:07] Lenny

**English:**
Yeah, give us some recs there.

**中文翻译:**
好啊，给点那方面的推荐。

---

### [00:59:09] Jiaona Zhang

**English:**
I'm a big fan of Brandon Sanderson. He completed the Wheel of Time series on behalf of the [original] author. He has the Mistborn series and so he's a great one. He actually has this... During the pandemic, he holed up and wrote a bunch of books and Vince was like, "I have a confession to make. I wrote four extra books." And the latest one is Tress by the Emerald Sea that I really love.

**中文翻译:**
我是 Brandon Sanderson 的大粉丝。他代表原作者完成了《时光之轮》（Wheel of Time）系列。他还有《迷雾之子》（Mistborn）系列，他非常出色。他在疫情期间闭关写了一堆书，然后说：“我要坦白一件事，我额外写了四本书。”最新的一本是《翠海的特雷丝》（Tress of the Emerald Sea），我非常喜欢。

---

### [00:59:32] Lenny

**English:**
I saw the video of him sharing that news and he's just like, "I wrote a book during COVID" and then, "Okay, I wrote a second book and then, oh, I wrote a third book also" and it just keeps going.

**中文翻译:**
我看了他分享那个消息的视频，他就像是：“我在新冠期间写了一本书”，然后“好吧，我还写了第二本，噢，我还写了第三本”，一直说下去。

---

### [00:59:43] Jiaona Zhang

**English:**
I think he was like, "I have a secret or I have a confession to make." And everyone was like, "Oh no, are you going to say that you have a ghost writer because you're so prolific?" And he's like, "Nope, I just wrote four more books."

**中文翻译:**
我想他当时说：“我有一个秘密或我要坦白一件事。”大家都想：“噢不，你是不是要说你有代笔，因为你产出太高了？”结果他说：“不，我只是又写了四本书。”

---

### [00:59:51] Lenny

**English:**
What a beast. Next question on that topic a little bit. What's a favorite recent movie or a TV show that you watched? And I know you said you don't get to watch much, but anything come to mind?

**中文翻译:**
真是个大神。下一个问题。你最近看过的最喜欢的电影或电视节目是什么？我知道你说你看得不多，但有什么能想到的吗？

---

### [01:00:01] Jiaona Zhang

**English:**
I feel like every night I'm watching Sesame Street like songs. We don't do TV, but we do do YouTube songs. I honestly don't have an answer to that other than we watch the Elmo song and the ABC song with my three year old.

**中文翻译:**
我觉得我每晚都在看《芝麻街》之类的儿歌。我们不看电视，但我们会看 YouTube 上的儿歌。老实说，除了和我三岁的孩子一起看 Elmo 之歌和 ABC 之歌，我没有别的答案。

---

### [01:00:18] Lenny

**English:**
There's been a lot of parenting advice on this podcast with my child coming soon. And so this is very on brand. Before we started this, you mentioned the painting behind you is referenced in like Arcane, it's connected to or the show Arcane, which I imagine-

**中文翻译:**
随着我的孩子即将出生，这个播客里出现了很多育儿建议。所以这很符合调性。在我们开始之前，你提到你身后的那幅画在《双城之战》（Arcane）中被引用了，或者说与之有关，我猜——

---

### [01:00:31] Jiaona Zhang

**English:**
Yes. I'm a big fan. So painted this a long time ago before Jinx and Vi were a thing, and when Arcane was made, both my husband and I were like, "What? How did we predict this? This is amazing." So it's a good one.

**中文翻译:**
是的。我是忠实粉丝。这幅画是很久以前在金克丝（Jinx）和蔚（Vi）出名之前画的，当《双城之战》播出时，我和我丈夫都惊呼：“什么？我们是怎么预见到的？太神奇了。”所以这很有意思。

---

### [01:00:45] Lenny

**English:**
There we go. Some adult content. What is a favorite interview question that you like to ask candidates?

**中文翻译:**
这就对了，来点成年人的内容。你最喜欢问应聘者的面试问题是什么？

---

### [01:00:53] Jiaona Zhang

**English:**
I do like to do behavioral questions, just really understanding when they've been in challenging situations, when they've been in ambiguous situations, how do they navigate ambiguity? Is a big one for me because at the end of the day, the PM job is really ambiguous. It's really hard to describe on a piece of paper all the things that you're going to encounter. So asking a lot of behavioral questions around that.

**中文翻译:**
我喜欢问行为面试题（behavioral questions），就是去真正了解当他们处于挑战性情境或模糊情境时，他们如何应对模糊性？对我来说这是一个重点，因为归根结底，PM 的工作非常模糊。很难在纸上描述你会遇到的所有事情。所以我会问很多相关的行为问题。

---

### [01:01:14] Lenny

**English:**
And is there anything specific you look for in their answer that tells you this is a good answer or not a good answer?

**中文翻译:**
在他们的回答中，你有没有什么特别看重的东西，能让你判断这是一个好回答还是不好的回答？

---

### [01:01:20] Jiaona Zhang

**English:**
Yeah. Good answers are people who put structure and a way forward through the ambiguity. That's what you look for. You want your PM to not just be like, "Oh no, we're swimming in ambiguity," but actually put a path forward. I think also looking for people who are seeking help, seeking those inputs as opposed to being like, "Yep, this is the way. This is very clear." Because again, the chances of whatever path you chart out for any product, for anything that you're doing is the right path from the first time that you do it, so rare. And so I want to see someone be able to get those inputs, be able to say, "This is the path, this is how I learned why I put this path together." And then going back to a lot of the stuff I think we touched upon in this podcast is like, what are the little milestones that make you say, "Hey, is this working? Is this not working?" And then make you either make a different decision. Seeing people do that really well is a big thing I look for.

**中文翻译:**
有的。好的回答是那些能在模糊中建立结构并找到前进道路的人。这就是你要找的。你希望你的 PM 不仅仅是说“噢不，我们正深陷模糊之中”，而是能真正提出一条路径。我认为还要寻找那些寻求帮助、寻求输入的人，而不是那种只会说“没错，就是这样，这很清晰”的人。因为再次强调，对于任何产品、任何你正在做的事情，你第一次规划出的路径就是正确路径的概率微乎其微。所以我希望看到有人能获取这些输入，能够说：“这是路径，这是我如何通过学习总结出这条路径的。”然后回到我们在这期播客中提到过的很多内容：有哪些小的里程碑能让你判断“嘿，这行得通吗？行不通吗？”，然后让你做出不同的决定。看到有人能把这些做得很好，是我非常看重的。

---

### [01:02:12] Lenny

**English:**
Awesome. What is a favorite product you've recently discovered that you love?

**中文翻译:**
太棒了。你最近发现并喜爱的产品是什么？

---

### [01:02:17] Jiaona Zhang

**English:**
I love... It's not recent, but I do love the SNOO and it's very top of mind because I just graduated my second son from the SNOO and it was a little bit like, "Oh my gosh, no more rocking of the baby." But I do think it does a good job of actually doing the thing and I'm also giving parents peace of mind. (01:02:34): The other thing I'm a big fan of, again, you'll see where my head's at, lots of child related things. Midjourney for your toddler is actually great because instead of it being absolute instant gratification of "I want to see a firetruck," and "Here you go, here's my phone." It's like, "Let's wait for Midjourney to create the firetruck." And specifically you can even tell Midjourney what you want. It could be like, "I would like it to be blue." He's obsessed with Jungle Book, "Wearing a fire hat next to a firetruck." And so you can actually create, and I do believe in the future, so much of what we are going to be doing as humans is literally what is the creative process? What's the idea? It's less about executing all the pieces of it, but it's so important to still be able to be like "This is the idea that I want to bring to life." And so I just think training that is huge.

**中文翻译:**
我喜欢……虽然不是最近才有的，但我真的很喜欢 SNOO（智能摇篮）。我现在满脑子都是它，因为我二儿子刚从 SNOO“毕业”，那种感觉就像是：“噢天哪，再也不用摇孩子了。”但我认为它在功能实现上做得很好，也让父母感到安心。(01:02:34): 另一件我非常推崇的事情——再次强调，你会发现我的心思都在孩子身上——给幼儿用 Midjourney 实际上非常棒。因为这不再是绝对的即时满足，比如孩子说“我想看消防车”，你就说“给你，这是我的手机”。相反，你可以说：“让我们等 Midjourney 生成消防车。”而且你可以告诉 Midjourney 你想要什么。比如：“我想要蓝色的。”他痴迷于《丛林之书》（Jungle Book），“戴着消防帽站在消防车旁边”。所以你实际上可以进行创作。我坚信在未来，人类要做的很大一部分工作就是：创意过程是什么？想法是什么？执行每个细节变得不再那么重要，但能够说出“这是我想赋予生命的想法”仍然非常重要。所以我认为训练这种能力非常有意义。

---

### [01:03:24] Lenny

**English:**
Feels like you've just defined your three-year strategy for Webflow right there with AI. (01:03:30): Next question, what is something that you've changed in the way you build product that might be relatively minor that had a big impact in your team's ability to execute?

**中文翻译:**
感觉你刚才用 AI 定义了 Webflow 的三年战略。(01:03:30): 下一个问题，你在构建产品的方式上做了哪些可能相对较小、但对团队执行能力产生重大影响的改变？

---

### [01:03:40] Jiaona Zhang

**English:**
There's so many different things that we've done at all the different companies. It really depends on the company. And what I mean by that is at a company like Webflow, where the tech stack is complex and where a given feature has so many different interactions, you're like "People depend on this workflow, this thing interacts with this thing. It's a whole platform." One of the biggest things we've been tweaking is like how do we do more of a tech spike at the beginning to be like, "Do we have a good sense of how difficult this is going to be? The unknowns? Can we get a little bit more detail on them so that we don't go down a path and be like, 'Oh, this doesn't make sense'?" So I feel like that that's a tweak in the process that has really made a big difference at a company like Webflow. (01:04:20): But when I look back to other companies, again, that might not be your biggest problem. Another problem could be like, "Hey, it's just so difficult to work with cross-functional partners and doing a little tweak in the process where you bring them in a kickoff meeting." That might be the thing that just changes that dynamic of how you work with teams. So it's really... I don't know if there's one thing, but it's almost like every day I'm thinking about small tweaks and process to make all of us more efficient.

**中文翻译:**
我们在不同的公司做过很多不同的尝试。这真的取决于公司。我的意思是，在像 Webflow 这样技术栈复杂、特定功能有许多不同交互的公司，你会觉得：“人们依赖这个工作流，这个东西与那个东西交互，这是一个完整的平台。”我们一直在调整的一件大事是：我们如何在开始时做更多的“技术预研”（tech spike），以确定：“我们是否清楚这会有多难？未知因素是什么？我们能否获得更多细节，以免走上一条死胡同，最后发现‘噢，这行不通’？”我觉得这是流程上的一个小调整，但在 Webflow 这样的公司确实产生了很大影响。(01:04:20): 但回想其他公司，这可能不是最大的问题。另一个问题可能是：“嘿，与跨职能合作伙伴合作太难了”，那么在流程中做一个小调整，比如让他们参加启动会议（kickoff meeting），可能就会改变你与团队合作的动态。所以……我不知道是否只有一件事，但几乎每天我都在思考流程中的微小调整，以使我们所有人更高效。

---

### [01:04:44] Lenny

**English:**
Final question, what is your number one pro-tip for using Webflow and being successful with Webflow?

**中文翻译:**
最后一个问题，使用 Webflow 并取得成功的头号专业建议是什么？

---

### [01:04:49] Jiaona Zhang

**English:**
My number one pro-tip is there's a lot of stuff coming out that I'm very excited about. I do think Webflow has traditionally had a high learning curve, and it's because we're a pro tool, we're a professional tool. We do really amazing stuff, so much power that we deliver you, but with that power has come with it's hard to learn. And so one of the things that I'm really excited about pro-tip for using Webflow in the future is we're really going to bring the magic of Webflow University, the magic of AI, all together so that you can just use and learn Webflow so much faster, learn webflow in the context of what you're doing as opposed to going into a different tab and looking for the Webflow University stuff. It's going to be in context to the product, being able to actually take action directly, prompting Webflow to be able to do things for you. It's just going to be so much easier in the future to use the product. That's what I'm excited about. We're working on it and it will be out in the future.

**中文翻译:**
我头号专业建议是：有很多即将推出的东西让我非常兴奋。我确实认为 Webflow 传统上学习曲线很高，因为我们是一个专业工具。我们能做非常了不起的事情，赋予你强大的力量，但这种力量也带来了学习难度。所以我对未来使用 Webflow 的专业建议是：我们将把 Webflow University 的魔力和 AI 的魔力结合在一起，这样你就可以更快地使用和学习 Webflow，在实际操作的情境中学习，而不是切换到另一个标签页去找教程。它将与产品情境结合，能够直接采取行动，通过提示词（prompting）让 Webflow 为你做事。未来使用这个产品会变得容易得多。这就是我兴奋的地方。我们正在努力，未来会发布。

---

### [01:05:42] Lenny

**English:**
Okay. No specific dates yet. Yeah, you could share, this sounds like breaking news of cool stuff coming.

**中文翻译:**
好的。还没有具体日期。你可以分享一下，这听起来像是关于即将到来的酷东西的重大新闻。

---

### [01:05:47] Jiaona Zhang

**English:**
Some things are in alpha and [some in] beta, but we do want to be developing it with our users and really learning is this the power that you're looking for? Is this thing that's going to get you over the activation hump that you've struggled with in the past?

**中文翻译:**
有些东西在内测（alpha），有些在公测（beta），但我们确实希望与用户一起开发，并真正了解：这是你想要的力量吗？这能帮你跨越过去一直挣扎的“激活门槛”吗？

---

### [01:06:00] Lenny

**English:**
JZ, I think we've made a maximally lovable podcast episode. Thank you so much for being here. Two final questions. How can listeners find you online if they want to reach out and how can listeners be useful to you?

**中文翻译:**
JZ，我想我们做了一期“最大程度讨喜”的播客节目。非常感谢你的到来。最后两个问题：如果听众想联系你，可以在哪里找到你？听众可以如何帮到你？

---

### [01:06:11] Jiaona Zhang

**English:**
I always love feedback, so if there's feedback on the podcast, send it my way. Or even just what would you want to learn? Send it my way. And the reason I ask that is because I'm actually working on a course, another course through Reforge, which is around managing your PM career. And so really just... I've talked to so many people advice around their career, but if you want to reach out and be like, "These are the problems that I'm facing," it would actually really help me as I am creating this course, which is going to launch in a couple of months. And so I'm excited to... Find me there if you want to chat more and send the problems that you're struggling with when it comes to your career, and that would help me refine my course.

**中文翻译:**
我一直很喜欢反馈，所以如果对这期播客有反馈，请发给我。或者你想学什么，也请发给我。我之所以这么问，是因为我正在 Reforge 开发另一门课程，是关于管理你的 PM 职业生涯的。我给很多人提供过职业建议，但如果你能联系我并说“这是我面临的问题”，这实际上会在我创建这门课程时给我很大帮助，这门课将在几个月后发布。所以，如果你想聊更多，请在那里找我，并发送你在职业生涯中遇到的难题，这会帮助我完善课程。

---

### [01:06:47] Lenny

**English:**
And that's just reforge.com? There's no URL yet specifically for that course?

**中文翻译:**
就是 reforge.com 吗？目前还没有该课程的专属链接？

---

### [01:06:51] Jiaona Zhang

**English:**
Not yet, but it will come soon. And maybe what I'll do is I'll post it on my website, which is built in Webflow, so my full name dotcom.

**中文翻译:**
还没有，但很快就会有了。也许我会把它发在我的网站上，那是用 Webflow 做的，网址就是我的全名（jiaonazhang.com）。

---

### [01:06:59] Lenny

**English:**
Got it. JZ, thank you so much for being here, and thanks again.

**中文翻译:**
明白了。JZ，非常感谢你来到这里，再次感谢。

---

### [01:07:03] Jiaona Zhang

**English:**
Thanks for having me.

**中文翻译:**
谢谢邀请。

---

### [01:07:05] Lenny

**English:**
Bye, everyone. (01:07:08): Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。(01:07:08): 非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。