# Joe Hudson - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Joe Hudson.

---

### [00:00:00] Joe Hudson

**English:**
A lot of the people in my circles may have spent hundreds of millions of dollars to try to arrange a life that they enjoy, and it doesn't fucking work.

**中文翻译:**
在我圈子里的很多人可能花了数亿美元试图安排一种他们喜欢的生活，但那真他妈的一点用都没有。

---

### [00:00:08] Lenny Rachitsky

**English:**
What is holding people back?

**中文翻译:**
是什么在阻碍人们前进？

---

### [00:00:09] Joe Hudson

**English:**
It's the fact that they have emotions that they are not sitting, feeling, or expressing. Whatever emotion that you're trying to avoid, you are inviting into your life in exactly the way that you're trying to avoid it.

**中文翻译:**
事实是，他们内心有许多情绪，但他们没有静下心来去感受或表达。无论你试图逃避什么情绪，你实际上都在以你试图逃避的方式，将这种情绪招致进你的生活。

---

### [00:00:20] Lenny Rachitsky

**English:**
What the hell? Why would... Why does this... You have this really amazing insight. The voice in your head is often telling you bullshit.

**中文翻译:**
搞什么？为什么会……为什么这……你有一个非常惊人的见解：你脑子里的那个声音经常在对你瞎扯。

---

### [00:00:27] Joe Hudson

**English:**
What most people try to do is they try to stop it, and that doesn't work very well. I think the best way to work with the voice in the head is to pick an experiment every day and respond to the voice in the head in a new way every day. One of my favorite responses is, "Oh, I see that you're really scared. Don't worry. I'm right here with you. I got you."

**中文翻译:**
大多数人尝试做的是阻止它，但这并不奏效。我认为处理脑中声音最好的方法是每天选择一个实验，每天用一种新的方式回应它。我最喜欢的回答之一是：“噢，我看到你真的很害怕。别担心，我就在这里陪着你。我挺你。”

---

### [00:00:43] Lenny Rachitsky

**English:**
You're really big on helping people feel joy.

**中文翻译:**
你非常看重帮助人们感受喜悦。

---

### [00:00:45] Joe Hudson

**English:**
It's such an important tool for productivity. If you say, I'm going to figure out how to enjoy what I do 10% more and you succeed, you are 10% more efficient. Not only that, usually, the quality is going to get a lot better too.

**中文翻译:**
这是提高生产力的重要工具。如果你说，我要想办法让自己做的事多出 10% 的乐趣，并且你做到了，那么你的效率就提高了 10%。不仅如此，通常工作的质量也会变得更好。

---

### [00:00:57] Lenny Rachitsky

**English:**
Is there just one thing you recommend that basically everyone try to experiment with?

**中文翻译:**
有没有哪一件事是你建议基本上每个人都应该尝试去实验的？

---

### [00:01:02] Joe Hudson

**English:**
Yeah, it'll change your life dramatically really quickly.

**中文翻译:**
有的，它会非常迅速地剧烈改变你的生活。

---

### [00:01:09] Lenny Rachitsky

**English:**
Today, my guest is Joe Hudson. Joe is one of the most sought-after executive coaches amongst tech leaders and has worked with folks from OpenAI, SpaceX, Apple, and other world-class companies. Joe's unique approach to coaching draws from his spiritual, psychological, and neurological practices. In his intimate courses that he runs a few times a year, and in his podcast, he helps people create the life that they want with enjoyment and ease. In our conversation, Joe shares the two things that he finds most often keep people stuck in their life and in their job, and how to work on getting these things unstuck. Why the critical voice in your head is always wrong, contradictory, and telling you bullshit, and how to build a different relationship with that voice.

(00:01:51):
Why falling in love with your emotions is so important and so powerful. Why you'd be better off focusing on what you want versus what you think you should do or think that you need to do, plus a bunch of amazing advice on how to make better decisions, help your team run more effectively, and why a seven-minute daily gratitude practice will change your life. This episode is basically for every single person. It will make your life and your work better. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and helps the podcast tremendously. With that, I bring you Joe Hudson. Joe, thank you so much for being here and welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Joe Hudson。Joe 是科技领袖中最受追捧的高管教练之一，曾与来自 OpenAI、SpaceX、苹果和其他世界级公司的精英合作。Joe 独特的教练方法借鉴了他的灵性、心理学和神经科学实践。在他每年举办几次的深度私密课程以及他的播客中，他帮助人们以享受和轻松的方式创造他们想要的生活。在我们的对话中，Joe 分享了他发现的最常让人们在生活和工作中陷入困境的两件事，以及如何摆脱这些困境。为什么你脑子里那个挑剔的声音总是错误的、矛盾的、在瞎扯，以及如何与那个声音建立一种不同的关系。

(00:01:51):
为什么爱上你的情绪如此重要且强大。为什么专注于你“想要”什么，而不是你认为“应该”做什么或“需要”做什么会让你过得更好。此外，还有关于如何做出更好决策、帮助团队更有效运行的大量精彩建议，以及为什么每天七分钟的感恩练习会改变你的生活。这一集基本上适合每一个人。它会让你的生活和工作变得更好。如果你喜欢这个播客，别忘了在你不喜欢的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对播客有巨大帮助。现在，让我们欢迎 Joe Hudson。Joe，非常感谢你能来，欢迎来到本播客。

---

### [00:02:34] Joe Hudson

**English:**
Oh, thanks. Good to be here.

**中文翻译:**
噢，谢谢。很高兴来到这里。

---

### [00:02:36] Lenny Rachitsky

**English:**
It's good to have you. I'm curious if there's any common themes that emerge often in terms of what is holding people back from success or just living the life that they want, especially ambitious tech people, which I know is a lot of the folks that you work with. Are there archetypes of like, here's the thing, often come up most often and hold people back?

**中文翻译:**
很高兴你能来。我很想知道，在阻碍人们获得成功或过上理想生活方面，是否有一些经常出现的共同主题，特别是对于那些雄心勃勃的科技界人士——我知道你经常和这类人打交道。有没有什么典型的模式，比如“就是这个东西”，经常出现并阻碍人们前进？

---

### [00:02:57] Joe Hudson

**English:**
A nonspecific answer to that would be a critical voice in their head and a relationship with that critical voice that is not productive. Oftentimes, the critical voice in the head says, "You need me to be productive," but it's usually a huge detriment to being able to really be successful. Even if you are successful with a really critical voice in your head, you never get to enjoy it. You might have the money, but then you're like, "Oh, shit, I'm still miserable." Or, "I got the car, I got the house, I got the money, I got the successful career, and why am I unhappy all the time?" That would be, I would say one of the biggest ones. Another really big one that in a large category I would say is their relationship with emotions is all fakata (messed up). They are either trying to pretend they don't have them or compartmentalizing them or trying to manage them rather than harnessing them and falling in love with them. That would be a big place.

**中文翻译:**
一个概括性的回答是：他们脑子里有一个挑剔的声音，并且他们与那个声音的关系是负面的。通常，脑子里的挑剔声音会说：“你需要我才能保持高效”，但它通常是真正成功的巨大障碍。即使你在脑子里充满挑剔声音的情况下获得了成功，你也永远无法享受它。你可能有了钱，但你会觉得：“噢，该死，我还是很痛苦。”或者，“我买了车，买了房，有了钱，事业有成，可为什么我还是整天不开心？”我会说这是最大的问题之一。另一个大类是，他们与情绪的关系一团糟（fakata）。他们要么假装没有情绪，要么把情绪隔绝开来，或者试图管理情绪，而不是去驾驭并爱上它们。这也是一个重要方面。

---

### [00:04:06] Lenny Rachitsky (Ad Segment)

**English:**
This episode is brought to you by BuildBetter.ai... (Ad content omitted for brevity in translation but included in full document if needed).

**中文翻译:**
本集节目由 BuildBetter.ai 赞助……（广告内容：BuildBetter 利用 AI 将产品和销售电话、支持工单等非结构化数据转化为结构化见解，帮助产品团队减少运营琐事。使用代码 LENNY 可获得 100 美元抵扣额度。）

---

### [00:05:19] Lenny Rachitsky (Ad Segment)

**English:**
This episode is brought to you by WorkOS... (Ad content omitted for brevity).

**中文翻译:**
本集节目由 WorkOS 赞助……（广告内容：WorkOS 帮助 SaaS 应用快速添加企业级功能，如 SAML 身份验证和 SCIM 配置。它支持高达 100 万月活用户免费使用。）

---

### [00:06:05] Lenny Rachitsky

**English:**
These are awesome. Okay, so the voice in your head, you have this really amazing insight that I heard on one of your podcast episodes that the voice in your head is often wrong, often contradictory, often telling you [bullshit], and that your advice is to learn how to work very differently with this voice in your head, which a lot of people just assume, oh, that's just like what it is. It's telling me how it's trying to help me, but it turns out it's not. Can you talk about that?

**中文翻译:**
这些都很棒。好，关于脑子里的声音，我在你的一集播客里听到了一个非常惊人的见解：你脑子里的声音经常是错的，经常是矛盾的，经常在对你瞎扯。你的建议是学习如何以一种完全不同的方式与这个声音共处。很多人只是假设：“哦，它就是那样的，它在告诉我它在努力帮我”，但事实证明并非如此。你能谈谈这个吗？

---

### [00:07:04] Joe Hudson

**English:**
I would say every single time the voice in your head is wrong. That critical voice in your head. To be specific, I'm talking about the voice in your head that is critical and repeats. There's the voice that says the same thing over and over again. You got to work out more, you got to work out more, you got to work out more. Whatever that is, it's always wrong, and that doesn't mean there isn't truth to what it says, but it's incorrect. As an example of this, you should work out more, you should work out more, you should work out more, or you need me or you just sit around on the couch as a great example of one. If I was your boss and I was sitting right next to you and I was criticizing you every couple of minutes, there's no way that you would say, "Wow, I really need you. I couldn't be productive without you." It's a bunch of crap. Or you should work out, you should work out.

(00:07:58):
I see the truth that I'd be healthier if I work out. I get that. Should I? Is it really a should? There's another question. What makes it not say, "Oh, hey, why don't you enjoy working out? How do we get you to enjoy working out? What would motivate you to work?" It's not doing any of that. It's, "You should work out, you should work out." It's never an accurate thing that's happening inside of your head. Until you can see through that, it's hard to work with the voice in your head. You can do it, but until you see through it. The second part that I would say is that if you want to work with the voice in your head a new way, what most people try to do is they try to stop it. They try to control the voice in the head, and that doesn't work very well. Instead, I say, change the way that you relate to the negative voice in your head.

(00:08:46):
Instead of being, "Okay, stop doing that, stop doing that." Say, "Oh, I see that you're really scared and I'm right here with you." Or sing a musical to it or just go, "Eh, I don't believe you." As a matter of fact, I think the best way to work with the voice in the head is to pick an experiment every day and respond to the voice in the head in a new way every day to have an experimental approach and say, "Oh, what's the relationship I want with this negative voice in my head?" Because right now, what it's typically doing for most people is that it says something and the person's like, "Yeah." Or, "Yeah, but I'm not going to do that, so fuck off." Or, "Yeah, that'll never work." Something like that is the response. What happens if you change the response to the voice in your head? That gives you a crap ton of freedom, and it's the beginning of what can be a state where the negative voice in the head disappears, which is really, really quite lovely.

**中文翻译:**
我会说，你脑子里的声音每一次都是错的。我是指你脑子里那个挑剔的声音。具体来说，我说的是那个不断重复的、挑剔的声音。那个一遍又一遍说同样话的声音：“你得多锻炼，你得多锻炼，你得多锻炼。”不管它说什么，它总是错的。这并不意味着它说的话里没有事实成分，但它是“不正确”的。举个例子，“你应该多锻炼，你应该多锻炼”，或者“你需要我，否则你只会瘫在沙发上”。如果我是你的老板，坐在你旁边每隔几分钟就批评你一次，你绝对不会说：“哇，我真的需要你，没有你我根本没法高效工作。”这纯属扯淡。或者“你应该锻炼，你应该锻炼”。

(00:07:58):
我明白如果我锻炼会更健康的这个事实。我懂。但我“应该”吗？这真的是个“应该”吗？这是另一个问题。为什么它不问：“噢，嘿，你为什么不享受锻炼呢？我们怎么才能让你享受锻炼？什么能激励你去锻炼？”它完全没做这些。它只是在说：“你应该锻炼，你应该锻炼。”你脑子里发生的这些事从来都不是准确的。除非你能看穿这一点，否则很难处理脑子里的声音。你可以尝试，但前提是看穿它。我要说的第二部分是，如果你想用一种新的方式处理脑子里的声音，大多数人尝试的是阻止它。他们试图控制脑子里的声音，但这并不管用。相反，我说，改变你与脑中负面声音的关系。

(00:08:46):
不要说：“好，别说了，别说了。”而是说：“噢，我看到你真的很害怕，我就在这里陪着你。”或者对着它唱一段音乐剧，或者干脆说：“额，我不信你。”事实上，我认为处理脑中声音最好的方法是每天选择一个实验，每天用一种新的方式回应它，采取一种实验性的方法，问自己：“噢，我想和脑子里这个负面声音建立什么样的关系？”因为现在，对大多数人来说，它说了一些话，人的反应通常是：“好吧。”或者“对，但我不想那么做，所以滚开。”或者“对，那永远行不通。”如果改变对脑中声音的回应会怎样？这会给你极大的自由，也是通往负面声音消失状态的开始，那真的是非常、非常美妙的。

---

### [00:09:43] Lenny Rachitsky

**English:**
Oh, wow. I love this so much because there's so much that comes from this thing in your head just shooting you down or scaring you about stuff. It's so hard. I hear this, but it's so hard. Next time I'm, I don't know, giving a big presentation, I'm going to hear like, "Oh, something could go wrong. You could look really stupid or you could totally forget what you're saying." It's hard to really intellectualize, okay, I don't have to listen to this. Is there anything more there just how to turn that around and be like, just shut up?

**中文翻译:**
噢，哇。我太喜欢这个了，因为脑子里这个东西不断打击你或吓唬你，会带来很多负面影响。这太难了。我听明白了，但做起来很难。下次当我，我不确定，比如做大型演讲时，我会听到：“噢，可能会出状况。你可能会看起来很蠢，或者你可能会完全忘词。”很难真正从理智上告诉自己：好吧，我没必要听这个。还有什么方法能扭转这种局面，而不是仅仅说“闭嘴”吗？

---

### [00:10:11] Joe Hudson

**English:**
The shut up usually doesn't work. Experiment with all of it. To me, one of my favorite responses is, "Oh, I see that you're really scared. Don't worry. I'm right here with you. I got you." Because part of the deal is that the voice in the head has assumed the position that it's like the boss, but it's really a little kid having a temper tantrum. If you listen to it, if you just dictated everything it said, it sounds like usually like a five-year-old having a temper tantrum, or it sounds like the way your mom used to chastise you or the way your dad used to chastise you or whatever, a teacher. It isn't, it's not logical, it's not thoughtful, it's typically not thoughtful, it's usually abusive. It's a lot of fear. It's one of my favorites, one of my favorite ways to respond.

(00:11:06):
I've tried, I mean, gosh, dozens of ways, and there's a lot of neat effective ways. I particularly think it's really good to set up a series of experiments rather than just take the one that I have because the experimental mindset means that you can never really fail. Typically, somebody, like worse with the voice in the head, they fail and they go, "Ah, fuck it." Because we have this part of our brain called the habenula, and the habenula basically is the part of our brain that is trying to teach us not to fail over and over again. It's the thing that when you go on a diet or you go to work out and then you don't do it one day and you say, "Ah, fuck it, I messed up," and then you don't try anymore or you don't try for a couple of weeks or whatever, that's basically what's happening in that part of the brain.

(00:11:48):
If you do it as an experimental thing, then you can't lose, you're just learning about yourself. You're learning about the voice in your head. The way I like thinking about that is people are like, "I understand the problem, but I don't have a solution." I'm always like, "If you understood the problem, there would be no question about the solution." If you fully understand the problem, you know the solution. All you have to do is really fully understand the voice in your head through a series of experiments and the whole thing goes away.

**中文翻译:**
“闭嘴”通常不起作用。去实验各种方法。对我来说，我最喜欢的反应之一是：“噢，我看到你真的很害怕。别担心，我就在这里陪着你。我挺你。”因为部分原因是，脑子里的声音占据了类似“老板”的位置，但它实际上只是一个在耍小脾气的孩子。如果你听它说话，如果你把它说的每一句话都记录下来，它听起来通常像一个五岁小孩在发脾气，或者像你妈妈以前责备你的样子，或者你爸爸责备你的样子，或者是某个老师。它不合逻辑，不周全，通常非常草率，而且往往带有虐待性。它充满了恐惧。这是我最喜欢的应对方式之一。

(00:11:06):
我尝试过，天哪，几十种方法，有很多巧妙有效的方法。我特别认为建立一系列实验比只采用我这一种方法要好，因为实验心态意味着你永远不会真正失败。通常，有人在处理脑中声音时失败了，他们会说：“啊，去他的，搞砸了。”因为我们大脑中有一个叫“缰核”（habenula）的部分，它基本上是教导我们不要重复失败的部分。当你节食或健身，有一天没坚持住，你说：“啊，去他的，我搞砸了”，然后你就不再尝试了，或者停上几周，这就是大脑那个部分在起作用。

(00:11:48):
如果你把它当作一个实验，你就不会输，你只是在了解自己。你在了解脑子里的声音。我喜欢这样思考：人们常说“我理解问题，但我没有解决方案”。我总是说：“如果你真的理解了问题，解决方案就不成问题了。”如果你完全理解了问题，你就知道解决方案。你所要做的就是通过一系列实验真正完全地了解你脑子里的声音，然后整个问题就会消失。

---

### [00:12:16] Lenny Rachitsky

**English:**
The advice here is next time you're hearing something in your head that you don't think is going to be helpful to you is try to respond to it in a different way from what you've been doing.

**中文翻译:**
这里的建议是，下次当你听到脑子里出现你认为对你没有帮助的声音时，尝试用一种不同于以往的方式去回应它。

---

### [00:12:25] Joe Hudson

**English:**
I would be even more subtle than that, which is I really wouldn't care if you think it's helpful to you or not. I would just experiment with different ways of interacting with it. I wouldn't even do it as a goal of, okay, I want the voice in the head to be nicer to me. I would do it with the goal of just, hey, how do I learn? How do I understand this thing? It's a far more productive self-development. Generally, it's far more productive to learn, say about the river valley by walking through it, putting your feet in the river, going down the river with a canoe, smelling the soil, looking at the plants, than it is to say, "Okay, I am going to dam this river valley and try to..." You're not going to understand it the same way. You're going to make some mistakes.

**中文翻译:**
我会说得更微妙一点，那就是我其实并不在乎你是否认为它对你有帮助。我只是建议实验不同的互动方式。我甚至不会把它设定为一个目标，比如“好，我要让脑子里的声音对我更友善”。我会把目标设定为：“嘿，我该如何学习？我该如何理解这个东西？”这是一种更高效的自我成长方式。通常，通过漫步河谷、把脚伸进河水、划着独木舟顺流而下、闻闻泥土、看看植物来了解河谷，要比说“好，我要在这个河谷筑坝并尝试……”有效得多。你不会以同样的方式理解它。你会犯一些错误。

---

### [00:13:18] Lenny Rachitsky

**English:**
Amazing. The second bucket that you shared of what you find most often is the root of what's holding people back is the way you described is your relationship with your emotions, which I don't think a lot of people would think of as the thing that's holding them back. Can you talk a bit more about what that looks like?

**中文翻译:**
太棒了。你分享的第二个经常阻碍人们前进的根源是：你与情绪的关系。我想很多人不会认为这是阻碍他们的因素。你能多谈谈那是种什么样的状态吗？

---

### [00:13:31] Joe Hudson

**English:**
Yeah, a great way to explain it. For the logical folks, so in 2012 or so, there was a person who wrote a book called Descartes' Error, and in Descartes' Error, the whole idea is that I think therefore I am, and this person's like, "Yeah, that's the error." It's a neuroscientist who looked at people who had damage in the emotional center of their brain, and they just basically ceased to be able to make decisions. Their IQ would stay the same, but it would take them half an hour to decide where to have lunch or decide what color pen to use. It would take hours and hours to make simple decisions, so their IQ would stay high, but their entire life would completely fall apart. What it tells us, and this is not exact, I'm paraphrasing for a podcast, but we make decisions in the emotional center of our brain. We use logic to try to figure out how we're going to feel.

(00:14:23):
You can see this just by asking yourself the question, how many decisions have you made to feel like a success or to not feel like a failure or to feel happier, to not feel trapped? There's these huge buckets of emotions that we are trying to feel and not feel, and we're making decisions based on those. There's no such thing as a logical decision. That idea is like, I'm just going to be logical and just make a logical decision, it doesn't. Neurologically, it's just untrue. If you learn to fall in love with all of your emotions, then solution sets become available that you didn't have before. If you are like, "Oh, I can't feel like a failure." Well, then you're probably not going to take certain risks. If you are, "Oh, I want to feel loved and I can't feel unliked by people." Well, then you're not going to say your truth, and then the world is going to not give you the things that are truthful to you.

(00:15:20):
I go into my boss, I say my truth, I get fired. Okay, I get fired, but then probably my next boss, I say my truth, I'm going to find a location where my truth is and how I want to be in the world is going to be acceptable. If I don't do that, if I'm constantly managing myself, then I'm not going to have that reality. It's really important, just for the decision-making part, how important emotions are to be able to fall in love with each of the emotional experiences so you're not making decisions based on your inability to feel stuff. That's like one, there's literally a thousand others. Most people, they feel stuck. They can have a big emotional release and they don't feel stuck anymore. When people feel overwhelmed, it's usually not the amount of crap that they have going on in their life. It's the fact that they have emotions that they are not sitting, feeling or expressing. That's another huge chunk of stuff.

(00:16:11):
Depression is usually unmoved anger, is another example. There's so many levels in which people not able to feel really limits their life. Just one that's like almost everybody can relate to is feeling excitement is something that most people can only do for about 10 to 20 seconds. Most people aren't like, "Oh, I'm excited." If you walked into a Denny's and there was this person, a 60-year-old man and just excited and was excited for 10 minutes, you'd be like, "What's wrong with this person?" When we're excited, it's contagious. I walk into a meeting and I'm excited, probably other people are going to walk out excited. We're limiting just our ability to create collaboration by the fact that we're limited by our excitement. I could go on forever. There's so many experiences like this.

**中文翻译:**
是的，这是一个很好的解释方式。对于讲逻辑的人来说，在 2012 年左右，有人写了一本书叫《笛卡尔的错误》（Descartes' Error）。笛卡尔的核心思想是“我思故我在”，而这本书的作者说：“没错，这就是错误所在。”这位神经科学家观察了大脑情绪中心受损的人，他们基本上失去了做决定的能力。他们的智商保持不变，但他们要花半小时才能决定去哪吃午饭，或者决定用什么颜色的笔。做简单的决定要花好几个小时，所以虽然智商很高，但他们的整个生活完全崩溃了。这告诉我们——这不完全精确，我是为了播客在转述——我们在大脑的情绪中心做决定。我们使用逻辑来试图弄清楚我们会“感觉”如何。

(00:14:23):
你可以通过问自己这个问题来看到这一点：你有多少决定是为了“感觉”像个成功者，或者为了“不感觉”像个失败者，或者为了感觉更快乐，或者为了不感到被困住？我们试图感受或不感受的情绪有很多大类，我们是基于这些来做决定的。根本不存在所谓的“逻辑决定”。那种“我只要保持理智，做一个逻辑决定”的想法，在神经科学上是不成立的。如果你学会爱上你所有的情绪，那么以前没有的解决方案集就会变得可用。如果你觉得“噢，我不能感到失败”，那么你可能就不会冒某些风险。如果你觉得“噢，我想被爱，我不能忍受别人不喜欢我”，那么你就不会说出你的真心话，那么世界也就不会给你那些对你真实的东西。

(00:15:20):
我去找老板，说了真话，我被解雇了。好，我被解雇了，但可能在我的下一个老板那里，我说出真话，我会找到一个能接受我的真实以及我想在这个世界上生存的方式的地方。如果我不这样做，如果我不断地管理（压抑）自己，我就不会拥有那种现实。情绪对于决策非常重要，爱上每一种情绪体验，这样你就不会因为“无法感受某些东西”而做决定。这只是其中一点，字面上还有成千上万的其他原因。大多数人感到被困住了，他们只要有一次大的情绪释放，就不再感到被困住了。当人们感到不堪重负时，通常不是因为生活中的琐事太多，而是因为他们有情绪没有去静坐感受或表达。这是另一大块内容。

(00:16:11):
抑郁通常是未被排解的愤怒，这是另一个例子。在很多层面上，无法感受情绪严重限制了人们的生活。举一个几乎每个人都能产生共鸣的例子：感受“兴奋”。大多数人只能持续兴奋 10 到 20 秒。大多数人不会一直说“噢，我很兴奋”。如果你走进一家餐厅，看到一个 60 岁的男人兴奋不已，并且持续兴奋了 10 分钟，你会觉得：“这个人怎么了？”当我们兴奋时，它是具有传染性的。我走进一个会议，我很兴奋，可能其他人离开时也会很兴奋。我们因为受限于自己的兴奋感，从而限制了我们创造协作的能力。我可以一直说下去，像这样的体验太多了。

---

### [00:17:06] Lenny Rachitsky

**English:**
What I'm hearing is the core issues, we're not able to feel our emotion, but there's something there, like we are angry or scared. Because we can't feel it, we just can't break through that.

**中文翻译:**
我听明白的是，核心问题是我们无法感受自己的情绪，但情绪就在那里，比如我们感到愤怒或恐惧。因为我们无法感受它，所以我们无法突破它。

---

### [00:17:17] Joe Hudson

**English:**
Not quite. If you have somebody who's experienced a lot of emotional abuse in their life, then they might not be able to feel the emotions that they're having, and particularly where you experienced the emotional abuse. That might be the case for them. For instance, if you had physical abuse and I put a quarter in one of your hands and a key in another one of your hands without telling you which was which, you wouldn't be able to tell me if you'd suffered enough physical abuse because you've literally cut that sensation off. Similarly, people who've experienced emotional abuse can often not tell what the emotions are. Now, emotional abuse is, it's a big word. Generally, people don't even like equating the two. Just to agree on terms here, when I say emotional abuse, I mean you were told that you weren't allowed to have a certain emotion. That's what I mean by emotional abuse.

(00:18:08):
Maybe you got fed every time you got angry or you got your love removed, or you got punished, or maybe every time you cried, you were made fun of. My particular background was that. It's when you weren't allowed to feel certain emotions, you were told to cut it off because it wasn't going to be safe because you're either going to get bribed out of it or punished out of it, or loved removed because of it or made fun of or whatever it is. That might be a step that one has to take, but the place you want to get to is where the emotions are fluid, where it just moves right through you. It doesn't mean that you lose control. As a matter of fact, losing control means that there's still resistance in it.

(00:18:53):
The way I think about this is that emotions are like a tube, let's say, and there's water moving through the tube. You kink a tube one way, the water comes out a little funny. Kink the tube the other way, it comes a little funny. Let's say you have anger and that's the tube of, and you kink it one way and it's like, "You son of a bitch. You blah, blah, blah, blah, blah." You kink get another way and it's like, "Nice dress. You crank it another way and it's guilt. It's like, "Why would you ever do that to me?" Then if it's unkinked, then it's like Gandhi or Martin Luther king. It's this very loving boundary that's set. It's this clarity of purpose. That's how I think about it. The idea is to get to fluidity, to unkink the hose so that all of the emotional experiences come out with love.

**中文翻译:**
不完全是。如果一个人在生活中经历过很多情感虐待，他们可能无法感受到自己正在产生的情绪，特别是在经历虐待的那个点上。对他们来说可能是这样。例如，如果你遭受过身体虐待，我往你的一只手里放一个硬币，另一只手里放一把钥匙，不告诉你是哪个，如果你遭受的身体虐待足够严重，你可能无法分辨，因为你字面上切断了那种感觉。同样，经历过情感虐待的人往往无法分辨情绪是什么。现在，“情感虐待”是一个很重的词。通常人们甚至不喜欢把两者等同起来。为了统一术语，当我提到情感虐待时，我的意思是：你被告知不允许拥有某种情绪。这就是我所说的情感虐待。

(00:18:08):
也许你每次生气时都会被塞吃的，或者被收回爱，或者受到惩罚，或者也许你每次哭的时候都会被嘲笑。我个人的背景就是这样。当你被禁止感受某些情绪时，你被告知要切断它，因为那不安全，你要么会被利诱放弃它，要么会被惩罚放弃它，或者因为这种情绪而被收回爱，或者被嘲笑等等。这可能是必须迈出的一步，但你想达到的境界是情绪是“流动的”，它直接穿过你。这并不意味着你失去了控制。事实上，失去控制意味着其中仍然存在阻力。

(00:18:53):
我对此的思考方式是，情绪就像一根管子，水在管子里流动。你把管子往一个方向扭结，出来的水就很奇怪。往另一个方向扭结，出来的水也很奇怪。假设你有愤怒，那是愤怒的管子，你往一个方向扭结，它就变成了：“你这个混蛋，你如何如何。”往另一个方向扭结，它变成了：“裙子不错（阴阳怪气）。”再往另一个方向扭结，它变成了内疚：“你怎么能那样对我？”如果管子没有扭结，它就像甘地或马丁·路德·金。它是一种充满爱的边界设定，是一种目标的清晰。这就是我的看法。核心是达到流动性，解开水管的扭结，让所有的情绪体验都带着爱流露出来。

---

### [00:19:44] Lenny Rachitsky

**English:**
I did a meditation retreat, a 10-day silent meditation retreat, which I know is a big part of your practice and something that led to the work you do now. A term that's coming up for me is non-judgmental awareness. Basically, experiencing the thing you're feeling and just letting it go, not attaching to it, not judging it. Is that along the lines of stuff you'd recommend?

**中文翻译:**
我参加过一次冥想静修，10 天的禁语冥想，我知道这也是你修行的一大部分，也是引导你从事现在工作的原因。我脑子里出现的一个词是“非评判性的觉知”。基本上就是体验你正在感受的东西，然后让它离去，不执着于它，不评判它。这是你推荐的那类方法吗？

---

### [00:20:03] Joe Hudson

**English:**
Yeah, it's definitely a huge part of it. There's a couple of things that I noticed get in the way, or the translation gets in the way there. One is it's like, think about emotions as like kids in your house. If a kid came into your house and you're like, "I will be non-judgmentally aware of you." You're probably going to get a very different response from the kid than if you're like, "Oh, I'm so excited to see you. I welcome you in my house." The emotions feel different if you're like, "I am non-judgmentally aware of this emotion," or, "Oh, cool. Oh cool, I'm sad. This is fantastic." If you have that welcoming invitation. One of the quotes that I'm most famous for is joy is the matriarch of a family of emotions and she won't come into a house where her children aren't welcome. A very joyful life is a life where all the other emotions are deeply welcomed, not accepted, not non-judgmentally aware of. I think those are really great steps, don't get me wrong. If you can be in non-judgmental awareness of an emotion, fantastic.

(00:21:14):
The other thing that's a little bit different about what you said is that emotions do need to be felt. If you stop feeling an emotion, you have to constrict your muscles. I can watch somebody come in, come up for one of my coaching rapid coaching sessions. By the crease in their eyebrow, I can know that there's repressed anger. By the hunch in their shoulders, I can tell you about the critical parent that they had. The body takes on a shape that's based on the emotions that you've been taught to hold. You don't just by sitting there, well, it's not entirely true, if you just sit there and feel them in that way without the full expression, they will move eventually, but it might take a couple of decades. You can actually just move them. You can actually make the sound, move your body. All mammals do it. Like mammals releasing fear, they all shake. It's part of how we exist. That's also a really big part of emotional fluidity. It's not just being still and feeling them, it's letting the muscles move, making the sounds.

**中文翻译:**
是的，这绝对是其中很大一部分。但我注意到有几件事会产生阻碍，或者说在转化过程中会有偏差。第一，把情绪想象成你家里的孩子。如果一个孩子进到你家，你说：“我会以非评判性的方式觉察到你。”孩子给你的反应，肯定和你对他大喊“噢，见到你太兴奋了，欢迎来我家”完全不同。如果你说“我正以非评判性的方式觉察这种情绪”，或者说“噢，酷，我很悲伤，这太棒了”，情绪的感觉是不一样的。如果你有那种欢迎的姿态。我最著名的一句话是：喜悦是情绪家族的女家长，如果她的孩子们不被欢迎，她是不会进屋的。一个充满喜悦的生活，是所有其他情绪都被深度欢迎的生活，而不仅仅是“接受”或“非评判性觉察”。别误会，我认为那些是非常棒的步骤。如果你能对情绪保持非评判性的觉察，那太棒了。

(00:21:14):
另一件和你说的略有不同的事是，情绪确实需要被“感受”。如果你停止感受一种情绪，你必须收紧肌肉。我观察一个人走进我的快速教练环节，通过他们眉间的皱纹，我就能知道那里有压抑的愤怒。通过他们耸起的肩膀，我就能告诉你他们曾有过怎样挑剔的父母。身体会根据你被教导去压抑的情绪而呈现出某种形状。你不能只是坐在那里——嗯，也不完全是，如果你只是坐在那里以那种方式感受它们而不进行充分表达，它们最终也会移动，但可能需要几十年。你实际上可以直接移动它们。你可以发出声音，移动身体。所有哺乳动物都这样做。比如哺乳动物释放恐惧时，它们都会颤抖。这是我们生存方式的一部分。这也是情绪流动性的一个重要部分：不仅仅是静止不动地感受它们，而是让肌肉动起来，发出声音。

---

### [00:22:22] Lenny Rachitsky

**English:**
For someone that wants to get better at the skill of feeling emotions, being more in touch with emotions, helping their emotions be more fluid. I know this is a lifelong practice and not something you would just hear on a podcast, okay, I've installed this. Is there anything tactically you can recommend to a listener of just like, here's something you could do this week that'll help you, along these lines?

**中文翻译:**
对于想要提高感受情绪技能、更多地接触情绪、帮助情绪变得更流动的人。我知道这是一辈子的修行，不是在播客里听一句“好，我安装了这个技能”就能搞定的。在战术层面上，你有没有什么可以推荐给听众的，比如这周可以做的一件事，能在这方面有所帮助？

---

### [00:22:40] Joe Hudson

**English:**
We have a free audio on our website called Emotional Inquiry, and that would be the easiest way that I would, that's a really good entry level first step into emotional fluidity. The bigger problem is that every step has a different thing. If you're in the not aware of emotions, then that step may not be the right step for you. Though, if you are aware two or three emotions and you can do emotional inquiry, usually, it'll open up a lot of the other ones. There might be a point where you really need expression, and so emotional inquiry is not going to work. Just generally, the emotional inquiry practice is a really good one. What it is, is imagine you're a little kid and you pick up a toad.

(00:23:28):
You're going to pick it up, you're going to look at it, you're going to feel it, you're going to smell it. Some little kids are even going to lick it a little bit. They're going to really want to explore this toad, and that's what emotional inquiry is, is a somatic mental experiencing of an emotional experience in your body and what is it like and what happens when you welcome it. What happens when you love it. What happens when you resist it. It's a series of experiments that you're playing with the emotion and observations and felt sense of the emotion, and that I find to be incredibly, incredibly useful for people.

**中文翻译:**
我们的网站上有一个免费音频叫《情绪探究》（Emotional Inquiry），那是我认为最简单的方式，是进入情绪流动性的一个很好的入门第一步。更大的问题是，每一步都有不同的重点。如果你处于完全察觉不到情绪的状态，那么这一步可能不适合你。但是，如果你能察觉到两三种情绪并进行情绪探究，通常它会开启许多其他情绪。可能在某个点上你真的需要表达，那么情绪探究就不起作用了。总的来说，情绪探究练习非常棒。它就像是：想象你是一个小孩，你捡到了一只蟾蜍。

(00:23:28):
你会把它捡起来，观察它，感受它，闻闻它。有些小孩甚至会舔它一下。他们真的想探索这只蟾蜍。情绪探究就是这样，它是对你身体里某种情绪体验的一种躯体和心理上的体验：它是什么感觉？当你欢迎它时会发生什么？当你爱它时会发生什么？当你抗拒它时又会发生什么？这是一系列你与情绪进行的实验、观察和体感，我发现这对人们极其、极其有用。

---

### [00:24:05] Lenny Rachitsky

**English:**
Just getting very curious.

**中文翻译:**
就是变得非常有好奇心。

---

### [00:24:06] Joe Hudson

**English:**
Yeah, a lot of wonder.

**中文翻译:**
是的，充满惊奇。

---

### [00:24:09] Lenny Rachitsky

**English:**
By the way, the quote you shared about joy being the matriarchy of all the other emotions, imagine people have said this, but Inside Out 2, I think is exactly a representation of what you're talking about, where joy is actually, she's like the protagonist almost. I don't know if you've seen it yet.

**中文翻译:**
顺便说一下，你分享的关于喜悦是所有其他情绪的女家长的名言，我想肯定有人提过，但《头脑特工队 2》（Inside Out 2）我认为正是你所说的完美体现，在那里喜悦几乎就是主角。不知道你看了没有。

---

### [00:24:25] Joe Hudson

**English:**
I think I've heard about this. I haven't watched it, but I think where you think it's all about being happy and you find out that you have to accept everything for happiness to really work, kind of.

**中文翻译:**
我听说过。我还没看，但我猜大概是：你以为一切都是为了快乐，结果发现你必须接受一切，快乐才能真正起作用，对吧？

---

### [00:24:34] Lenny Rachitsky

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:24:35] Joe Hudson

**English:**
Yeah, I have heard about it.

**中文翻译:**
是的，我听说过。

---

### [00:24:36] Lenny Rachitsky

**English:**
Anxiety takes over, and then things don't go well. Something else that I've noticed listening to a bunch of your conversations, you do these lightning round coaching sessions with people, and so I listen to a bunch of them. Something that was really interesting to me is that a lot of people come to you and they're like, "Hey, I have this problem. I can't do this hard thing I know I need to do." Or, "I have imposter syndrome just keeping me from doing this thing I need to do." you're often like, "No, that's not actually what's going on here. I can see that's not a problem for you. It's really this other thing." Is that super common where people think they need to work on this one thing, and it turns out that's not at all, they're actually okay at that and something totally else?

**中文翻译:**
焦虑占据了主导，然后事情就变得不顺利了。我在听你的一些对话时还注意到一件事，你经常和人进行那种“闪电式教练环节”，我听了很多。让我觉得很有趣的是，很多人来找你说：“嘿，我有这个问题。我没法做这件我知道我必须做的难事。”或者“我有冒充者综合征，它阻碍了我做该做的事。”而你经常会说：“不，事实并非如此。我能看出那对你来说不是问题，真正的问题是另一件事。”这种情况很普遍吗？就是人们认为自己需要解决某件事，结果发现那根本不是问题，他们在那里其实做得很好，问题出在完全不同的地方？

---

### [00:25:13] Joe Hudson

**English:**
I'd maybe put it a little bit differently. They're living in a story that describes an old version of themselves or they don't see themselves clearly enough to be able to see the whole issue, and so they're just kind of living with a story that's in the past. That's a really common thing. Oftentimes, if I do that in a coaching session, typically it's because they're showing me right there that it's not true. Somebody's like, "I'm so scared, I can't do anything." I'm like, "You just got in front of a hundred people to ask me a question. Clearly, you're not so scared that you can't do anything, so I'm not buying it." I don't do it quite like that, I do it with a lot more love than that.

(00:25:54):
Oftentimes, I see that people's stories are a culprit, like how they describe themselves. A great way that you can really see this in folks is that nine out of 10 times that you compliment somebody, I really appreciate this thing about you, they're going to go, "Nah." Or, "Well, my sister is even more." Or, "If you knew me." They're going to do some sort of version like that. It basically is one of the indicators that they can't actually feel who they are. They would rather, in effect, call you a liar. You're lying to me or you're wrong than they would to actually accept the experience of being seen in that way. It does a couple of things. One of the things it does is it stops people from seeing themselves clearly. The other thing it does is it makes people forever want to be seen and complimented and acknowledged and validated because they're getting the food, but they can't digest it.

**中文翻译:**
我可能会用一种略微不同的方式来表达。他们生活在一个描述“旧版自己”的故事里，或者他们对自己看得不够清楚，无法看到问题的全貌，所以他们只是生活在一个过去的故事里。这非常普遍。通常，如果我在教练环节中那样做，是因为他们当场就向我展示了那不是真的。有人说：“我太害怕了，我什么都做不了。”我会说：“你刚刚在一百人面前站起来问我问题。显然，你并没有害怕到什么都做不了的程度，所以我不信。”我不会说得那么直接，我会带着更多的爱去表达。

(00:25:54):
通常，我发现人们的故事是罪魁祸首，也就是他们如何描述自己。你可以在人们身上很清楚地看到这一点：十次里有九次，当你赞美某人说“我真的很欣赏你这一点”时，他们会说：“没啦。”或者“额，我姐姐更厉害。”或者“如果你了解我的话（你就不会这么说了）。”他们会用各种版本来否定。这基本上是一个指标，表明他们无法真正感受到自己是谁。他们宁愿实际上把你当成骗子——“你在骗我”或“你错了”——也不愿真正接受被那样看待的体验。这会产生几个后果：一是它阻止人们清晰地看待自己；二是它让人们永远渴望被看见、被赞美、被认可和被证实，因为他们得到了“食物”，却无法“消化”它。

---

### [00:27:09] Joe Hudson

**English:**
We have a set of five kind of what we think are foundational tools for transformation, and we do these free workshops on them, and one of them is question the assumption. That's a really great way to have people start to see through their stories. At the beginning, I said, "Nothing in the critical voice in your head says is true." This is how it applies, so typically, there's an assumption that you have to make for the problem to be real. If somebody says to you, for instance, if somebody comes to me and says, "I am an asshole to my girlfriend." That's their problem. One, you have to assume that the girlfriend doesn't want you to be an asshole, as an example. Two, you have to assume that you know what being an asshole actually is. It's not just what your mom told you an asshole was.

(00:28:04):
Three, there's some validation, there's another assumption, there's some clear thing that says this in the world. Everyone's like, that's an asshole and that's not, rather than what actually happens in the world, which is 50% of the people think that this person is an asshole and 50% think they're a hero. It's something like that. Also, another assumption there is that the problem is that you're an asshole, instead of that you're resisting the fact that you are an asshole, and therefore, it comes out sideways instead of really clear. There's so many assumptions in there. If you see through those assumptions, usually the problem starts fading away.

(00:28:40):
It's like, "Oh, okay, what do I mean by asshole, exactly? How do I define that?" It seems like a silly thing when I am using this example of asshole. I remember this moment in my own development, I was in Bodega Bay, out of all places, and this very good friend of mine at the time was like, "Joe, you're an asshole." I was like, "No, I'm not." He's like, "Why resist it? Just fall in love with the fact that you're an asshole. Just allow yourself to be an asshole for just a minute, just one minute." I stopped, and I thought of like, I was doing venture capital at the time, and I could think of all the things that I had done that somebody would call an asshole, and all the ways in which I was unattuned to people, and I could, "Oh, yeah, okay, I can totally see that I'm an asshole."

(00:29:32):
In that scene, not only in the scene of it, but as the shame fell away, oh, this is nothing I have to defend. This isn't something that I'm a bad person because of, I don't need to be ashamed of it. This is just some actions that I took. As that faded away, then and then over the next couple weeks, lo and behold, I became less of an asshole. It's a strange thing when you really grok (understand) that, that it's often shame that holds bad habits in place. Is it a problem that I'm an asshole, or is the problem that I'm ashamed of being an asshole? Is the problem that you're a smoker, is the problem that you're ashamed of being a smoker? Typically, there's so many assumptions built into everything that we call a problem, and if we look through those assumptions, the problems disappear. As in this case, it disappeared for me.

**中文翻译:**
我们有一套五个我们认为是转化的基础工具，我们会针对这些工具举办免费研讨会，其中之一就是“质疑假设”。这是让人们开始看穿自己故事的一个非常棒的方法。开头我说过，“脑子里那个挑剔的声音说的每一句话都不是真的”。这就是它的应用方式：通常，你必须先做一个假设，问题才会显得真实。例如，如果有人来找我说：“我对女朋友很混蛋。”这是他们的问题。第一，你必须假设女朋友不希望你是个混蛋；第二，你必须假设你真的知道什么是“混蛋”，而不仅仅是你妈妈告诉你的那种混蛋。

(00:28:04):
第三，还有一些验证，另一个假设是，世界上有某种明确的标准。每个人都觉得那是混蛋，而那不是。但现实世界中发生的是，50% 的人认为这个人是混蛋，另外 50% 的人认为他是英雄。类似这样。此外，还有一个假设是：问题在于你是个混蛋，而不是在于你在“抗拒”你是个混蛋这个事实，因此这种特质会以扭曲的方式表现出来，而不是清晰地呈现。这里面有太多的假设。如果你看穿了这些假设，通常问题就开始消散了。

(00:28:40):
就像是：“噢，好吧，我说的‘混蛋’到底是什么意思？我该如何定义它？”用“混蛋”做例子听起来可能有点傻。我记得在我成长的过程中，有一次在博德加湾（Bodega Bay），当时我一个很好的朋友对我说：“Joe，你是个混蛋。”我说：“不，我不是。”他说：“为什么要抗拒呢？就爱上你是个混蛋这个事实吧。就允许自己当一分钟混蛋，就一分钟。”我停下来想了想，当时我在做风险投资，我能想到所有我做过的、别人会称之为混蛋的事情，以及我对他人漠不关心的所有方式，然后我说：“噢，是的，好吧，我完全能看到我就是个混蛋。”

(00:29:32):
在那一刻，不仅是看清了事实，而且随着羞耻感的消失，我意识到：噢，这没什么好辩解的。这并不代表我是一个坏人，我不需要为此感到羞耻。这只是我采取的一些行动。随着羞耻感的消退，在接下来的几周里，你瞧，我反而变得没那么混蛋了。当你真正领悟（grok）到这一点时，你会发现这很奇妙：通常是“羞耻感”让坏习惯根深蒂固。问题在于我是一个混蛋，还是在于我为自己是个混蛋而感到羞耻？问题在于你是个烟民，还是在于你为自己是个烟民而感到羞耻？通常，我们称之为“问题”的每一件事里都植入了太多的假设，如果我们看穿这些假设，问题就会消失。就像在这个案例中，问题对我来说消失了。

---

### [00:30:25] Lenny Rachitsky

**English:**
Wow, okay. There's a lot there. It connects to something I know you recently talked about, which is the emotion we want to avoid is the thing we end up experiencing a lot by trying to avoid it. What's going on there?

**中文翻译:**
哇，好。这里面信息量很大。这连接到了你最近谈到的另一件事：我们想要逃避的情绪，最终往往会因为我们的逃避而让我们体验得更多。这是怎么回事？

---

### [00:30:46] Joe Hudson

**English:**
Since I'm coach executives, let's do an executive example, so conflict avoidant executive. I don't want to feel the out of control in this that I do when people argue. I don't want to feel that level of out of control, so I am going to be conflict avoidant. I'm going to avoid conflict. Every way that we go to avoid a feeling, becomes the way that, that feeling gets invited towards us. We all know what it's like to work for a conflict-avoidant CEO or a boss, people get really fucking upset. Eventually, people get really upset. Decisions aren't being made. There's all this tension. It's never relieved.

(00:31:30):
Then wow, sure enough, the conflict-avoidant CEO is dealing with a whole organization that's tense and they feel completely out of control and the fact that they can't do anything about, so that's an example. Or when I was younger, it was emotional abandonment. My dad was an alcoholic, and I didn't want to feel that emotional abandonment again, and so I would get really hard when I felt like people were leaving me, I'd be like, "What the dah, dah, dah, dah, dah?" Which of course, made them abandon me quicker, or I would try to caretaker people, which would build resentment, which would make people abandon me. Whatever emotion that you're trying to avoid, you are inviting into your life in exactly the way that you're trying to avoid it.

**中文翻译:**
既然我辅导高管，我们就举个高管的例子：一个逃避冲突的高管。我不希望在别人争论时感到那种失控感。我不想要那种失控的感觉，所以我选择逃避冲突。我避开冲突。我们逃避某种感觉的每一种方式，都会变成招致那种感觉的方式。我们都知道在逃避冲突的 CEO 或老板手下工作是什么感觉，员工会变得真他妈的烦躁。最终，大家都会非常生气。决策无法制定。到处都是紧张气氛。这种紧张从未得到缓解。

(00:31:30):
然后，哇，果不其然，这位逃避冲突的 CEO 面对的是一个关系紧张的整个组织，他们感到完全失控，而且对此无能为力。这就是一个例子。或者当我年轻的时候，是“情感遗弃”。我父亲是个酗酒者，我不想再次感受到那种被情感遗弃的感觉，所以当我感觉到别人要离开我时，我会变得非常强硬，我会说：“搞什么，哒哒哒哒哒。”这当然让他们更快地离开了我。或者我会尝试去照顾所有人，这会积累怨恨，最终导致人们离开我。无论你试图逃避什么情绪，你实际上都在以你试图逃避的方式，将这种情绪招致进你的生活。

---

### [00:32:14] Lenny Rachitsky

**English:**
What the hell? Why does this happen? This is counterproductive.

**中文翻译:**
搞什么？为什么会这样？这完全是适得其反。

---

### [00:32:20] Joe Hudson

**English:**
It is counterproductive. I think that the really cool thing about it is you can look at any issue that you're having in your life, so you can say, oh, one of the problems that I have in my life is that I am constantly in an argument with my girlfriend or boyfriend, let's say. What is the thing that you don't want to feel in that argument? I don't want to feel ashamed. You're getting in arguments because you don't want to feel ashamed, and that's making you feel more ashamed. What am I doing at that first time to not feel ashamed? I'm defending myself. Oh, and me defending myself is actually the thing that's starting the fight. You can backward engineer it to, oh, I don't want to feel ashamed, therefore I'm going to defend myself, which creates the fight, which makes me feel more ashamed.

(00:33:10):
Any problem that you're having, you can actually backwards engineer it and see, oh, I can solve that problem by just being okay with that feeling. God damn it, you didn't take out the trash. Oh, that's a shame I don't want to feel. I'm not going to defend myself. I'm going to feel that shame. Oh, yeah, then maybe I'm going to say I'm sorry I didn't take out the trash, or I'm going to say, I don't feel ashamed, I don't want to take out the trash. I have to defend myself to get in the fight, and then I'm going to feel ashamed. You can reverse engineer all your problems this way. It's like it's such a cool hack, but it's very hard. For somehow or another, it's very simple, but very hard for people to utilize.

**中文翻译:**
确实是适得其反。我认为最酷的一点是，你可以审视生活中遇到的任何问题。比如，你可以说：“噢，我生活中的一个问题是我经常和女朋友或男朋友吵架。”在那场争吵中，你最不想感受的是什么？“我不想感到羞耻。”你陷入争吵是因为你不想感到羞耻，而这反而让你感到更羞耻。我第一次为了不感到羞耻做了什么？“我在为自己辩护。”噢，而我的辩护恰恰是引发争吵的原因。你可以逆向推导：噢，我不想感到羞耻，所以我辩护，这引发了争吵，这让我感到更羞耻。

(00:33:10):
你遇到的任何问题，你都可以进行逆向推导并发现：噢，我可以通过“接受那种感觉”来解决那个问题。“该死，你没倒垃圾。”噢，那是我不想感受的羞耻感。我不打算辩解。我要去感受那种羞耻感。噢，是的，然后也许我会说“对不起我没倒垃圾”，或者我会说“我不觉得羞耻，我就是不想倒垃圾”。我必须通过辩解才能卷入争吵，然后我才会感到羞耻。你可以用这种方式逆向工程你所有的问题。这就像是一个非常酷的黑客技巧，但很难。不知为何，它非常简单，但人们很难运用。

---

### [00:33:53] Lenny Rachitsky

**English:**
This is amazing. The advice is basically feel the thing and just come to terms with this is the emotion I'm feeling, and maybe, like an example, the asshole. Well, maybe I'm an asshole.

**中文翻译:**
这太棒了。建议基本上就是去感受那个东西，接受“这就是我正在感受的情绪”，也许就像那个“混蛋”的例子一样——好吧，也许我就是个混蛋。

---

### [00:34:03] Joe Hudson

**English:**
It's what's required for you to love and accept yourself would be, and love and accept the emotion that you're having in the moment instead of resist it. There's that saying, what we resist persists. How do you fall in love with and stop resisting the reality on the ground? In doing so, it changes the reality on the ground.

**中文翻译:**
这是你爱自己、接纳自己所需要的，也就是爱并接纳你当下的情绪，而不是抗拒它。有句话说：你所抗拒的，会持续存在。你如何爱上并停止抗拒眼前的现实？通过这样做，现实本身就会发生改变。

---

### [00:34:30] Lenny Rachitsky

**English:**
In this argument with your supposed girlfriend, say you disagree about her perspective on what's going on. I guess that's not the root issue here. It's your feeling, it's not her perception.

**中文翻译:**
在与女朋友的争吵中，假设你不同意她对事情的看法。我想那不是根源所在。根源在于你的感受，而不是她的看法。

---

### [00:34:41] Joe Hudson

**English:**
Hey, sweetheart, I really hear you want me to take out the trash, and that's not my truth. That's going to be very different than defending that shame. The defending the shame is going to be like, no, it's not my job to take out the chat. You're trying not to feel the experience, which is what's going to do it. The response isn't the important thing. It's really where the response comes from. It's so interesting because people are taught constantly, this is something we teach in the connection courses that it's really not about the conversation, it's about where you're at in the conversation. For instance, when my friend said to me, "Hey, you're a dick." Here's what he didn't do, he's like, he didn't go, "You're a dick. You asshole. You're being an asshole. You're being a dick. Fucking stop it." He was like, "Eh, you're a dick, so what? What's the problem?" He was coming from a place of love for me, and so I could not be defended in my response to him. It's really where you come from.

(00:35:49):
It's the emotionally where you come from, that's the important part. Not as much what you say. You can see this, a perfect example of this is, this happens all the time in my work. Let's say there's a person who has a CEO and the person is scared of their CEO. Let's say this is the CMO, and they're, "I'm scared of the CEO. I can't say my truth. They're always getting upset. They're going to yell, blah, blah, blah, blah, blah, blah, blah, blah." I'll say, yeah, there's one person who says it though. The answer is always yes. That CEO has one person who they don't yell at, who they listen to, who they'll take the objection from, that they don't get angry with. It's because there's somebody who doesn't approach them in fear. It's because somebody approaches them a different way. Not with judgment, but like, "Hey, look, this is what we have to pay attention to." It's really about how you're coming at it and not what you're saying typically.

**中文翻译:**
“嘿，亲爱的，我确实听到你想让我去倒垃圾，但那不是我的真实想法。”这与为了掩盖羞耻感而辩解完全不同。掩盖羞耻感的辩解会是：“不，倒垃圾不是我的活儿。”你是在试图不去感受那种体验，而这正是问题所在。回应本身并不重要，重要的是回应的“出发点”。这很有趣，因为人们不断被教导——这也是我们在“连接课程”中教的内容——谈话的内容并不重要，重要的是你在谈话中所处的状态。例如，当我的朋友对我说“嘿，你是个混蛋”时，他没有说：“你个混蛋，你个烂人，你表现得像个混蛋，你真差劲，快他妈停下。”他是说：“额，你是个混蛋，那又怎样？有什么问题吗？”他是出于对我的爱说这话的，所以我对他没有防御心理。这取决于你的出发点。

(00:35:49):
你情绪上的出发点才是最重要的部分，而不是你说了什么。你可以看到这一点，一个完美的例子是——这在我的工作中经常发生。假设有一个人害怕他们的 CEO。比如这是一位 CMO（首席营销官），他们说：“我怕 CEO，我不敢说真话。他们总是生气，会大吼大叫，等等等等。”我会问，是不是总有一个人敢说真话？答案总是肯定的。那个 CEO 总有一个不吼的人，一个他们愿意倾听、愿意接受反对意见、不会对其发火的人。这是因为那个人没有带着恐惧去接近他们。因为那个人用另一种方式接近他们。不是带着评判，而是说：“嘿，看，这是我们需要注意的地方。”这通常取决于你如何切入，而不是你说了什么。

---

### [00:36:52] Lenny Rachitsky (Ad Segment)

**English:**
This episode is brought to you by Coda... (Ad content omitted for brevity).

**中文翻译:**
本集节目由 Coda 赞助……（广告内容：Coda 是一款集文档、表格和应用功能于一体的协作工具，帮助团队保持同步并加快交付。初创公司可获得 6 个月的免费团队计划。）

---

### [00:38:04] Joe Hudson

**English:**
You keep using the word advice, and I just want to, so for anybody who's listening, do not take my advice. Do not, do not, do not. Test it. Experiment. Set up an experiment, try it out. See if it's true for you. It's one, I just made this shit up. Somebody else could make up something different. It's like Jeff Bezos made up Amazon. We make stuff up, but we're humans. Two, is if you instead of just listen to it as a soundbite, if you actually do it and make an experiment out of it, you get to learn. It's in your bones. You get to see what's actually real for you. What's real for you in this moment might not be real for you what's in the next moment. For instance, I could give the advice that says, hey, you can't even control your thoughts.

(00:38:55):
You can't even decide what thought you are going to have next is, it's just going to fucking happen. you're completely out of control, and so it's all a gift. Can you look at life as all a gift? Wow, that could be really useful for one person, but the other person, they feel so disempowered that they're like, "I can't even control my own thoughts. Man, I am totally trapped." They might really need at that moment to learn that, "Oh, I have empowerment, I have choice." That's the advice that they need to hear. Do the experiment, find out what's true for you in this moment. If there's a piece of advice, that's the one I want to give.

**中文翻译:**
你一直在用“建议”这个词，我想对所有听众说：不要听从我的建议。千万不要，不要，不要。去测试它。去实验。设定一个实验，试一试。看看它对你是否真实。第一，这些都是我编出来的。别人也可以编出不同的东西。就像杰夫·贝佐斯创造了亚马逊一样。我们创造东西，因为我们是人类。第二，如果你不只是把它当成一段录音来听，而是真正去做并进行实验，你就能学到东西。它会刻在你的骨子里。你能看到对你来说什么是真实的。这一刻对你真实的，下一刻可能就不真实了。例如，我可以给出一个建议说：嘿，你甚至无法控制你的想法。

(00:38:55):
你甚至无法决定你的下一个念头是什么，它就是他妈的会发生。你完全无法控制，所以这一切都是礼物。你能把生活看作全是礼物吗？哇，这对一个人可能非常有用，但对另一个人，他们感到如此无力，以至于会想：“我甚至无法控制自己的想法。天哪，我完全被困住了。”在那一刻，他们可能真正需要学习的是：“噢，我有力量，我有选择。”那才是他们需要听到的建议。去做实验，发现此时此刻对你真实的东西。如果非要给一条建议，这就是我想给的那条。

---

### [00:39:40] Lenny Rachitsky

**English:**
let's share more experiments people can run. Another is this thread that I feel comes up a lot in your work is you're just really big on helping people feel joy. Feels like that's the core of what you're trying to help people is feel more joy. Why is that so important? Why is joy so important, so powerful?

**中文翻译:**
让我们分享更多人们可以进行的实验。另一个我觉得在你的工作中经常出现的主题是，你非常致力于帮助人们感受喜悦。感觉那是你试图帮助人们的核心：感受更多的喜悦。为什么这如此重要？为什么喜悦如此重要、如此强大？

---

### [00:39:57] Joe Hudson

**English:**
I definitely would not want anyone to feel joy. I wouldn't want to push somebody into or like, "Hey, you should feel joy." What I would say that's a close cousin to that is that enjoyment is such an important tool for productivity. Enjoyment is such an important tool for living a meaningful life. Enjoyment is an amazing tool. As an example, let's say you drive a Ferrari, you're not going to say, hey, that's an efficient car. That's a super-efficient car. You're going to say, no, that's a fast car. Somehow in our own lives, if we get something done quickly, we're efficient, but that's not efficient. You can go and get something done quickly and then you're so exhausted. What's efficient is if at the end of whatever you did, you feel like you have more energy, like you're stoked, like, oh, I can't wait to do this again tomorrow. That's efficiency, is that you've actually used the least amount of energy to get something done. If you say, oh, I'm going to figure out how to enjoy what I do 10% more and you succeed, you are 10% more efficient.

(00:41:13):
Not only that, usually, the quality is going to get a lot better too. If you enjoy running, you're probably going to run more than if you don't enjoy running. If you enjoy doing a podcast, you're probably going to make a better podcast and you're going to do it for longer if you enjoy doing it. There's something really, really important about enjoyment because it's not only a measure of efficiency, it also has a strong correlation with hire in most things has a strong correlation with how long you're going to do it, your staying power, the quality of what you're going to do, all of that. That's one of the reasons that I think enjoyment is really great. The other thing is that if you enjoy things, they feel different. I think one of the things that people do is they say this, they say, "I want to enjoy my life more, so I'm going to do less things, take out the trash, and I'm going to do more things like go on vacation."

(00:42:14):
That's not how enjoyment works. You can enjoy taking out the trash or you can hate taking out the trash. That's a choice. Right now, somebody listening to this as an experiment that they can run is like, okay, you're going to stay listening to this for the next minute. How do you enjoy it 10% more? Typically, what will happen is somebody will take a deeper breath, they'll settle into their body a little bit more, they'll relax a little bit more. They might physically get more comfortable. There's a thousand things that they might do to just enjoy the experience 10% more. That, and in that, they're becoming more efficient in that the quality is getting better in that they're hearing what I'm saying differently. It's just a really powerful tool. What I know the problem to be is that some people will go, "Okay, now I have to enjoy life. I'm going to disregard all these negative emotions so that I'm in enjoyment." That doesn't work. It's horrendous. It's just a recipe for shit stew.

**中文翻译:**
我绝对不想强迫任何人感受喜悦。我不想把某人推向喜悦，或者说“嘿，你应该感到喜悦”。我想说的是一个与此相近的概念：享受（enjoyment）是提高生产力的重要工具。享受是过上有意义生活的重要工具。享受是一个了不起的工具。举个例子，假设你开一辆法拉利，你不会说：“嘿，这是一辆高效的车，超级高效。”你会说：“不，这是一辆很快的车。”不知为何在我们的生活中，如果我们快速完成某件事，我们就认为自己是高效的，但那不是高效。你可以快速完成某件事，然后感到精疲力竭。真正的高效是，在你完成某件事后，你觉得更有能量了，你很兴奋，觉得“噢，我等不及明天再做一次了”。那才是高效，因为你实际上用了最少的能量完成了任务。如果你说，我要想办法让自己做的事多出 10% 的乐趣，并且你做到了，那么你的效率就提高了 10%。

(00:41:13):
不仅如此，通常质量也会变得更好。如果你享受跑步，你可能会比不享受跑步时跑得更多。如果你享受做播客，你可能会做出更好的播客，并且会坚持得更久。享受非常重要，因为它不仅是效率的衡量标准，还与大多数事情的持久力、质量等强相关。这就是为什么我认为享受非常棒。另一件事是，如果你享受某件事，感觉会完全不同。我认为人们常做的一件事是说：“我想更多地享受生活，所以我打算少做点事，比如倒垃圾，多做点事，比如去度假。”

(00:42:14):
享受不是那样运作的。你可以享受倒垃圾，也可以讨厌倒垃圾。那是一种选择。现在，正在听这段音频的人可以做一个实验：好，在接下来的一分钟里，你继续听这段话。你如何能多享受 10%？通常会发生的是，有人会深呼吸，身体更放松一点，或者调整一下坐姿让自己更舒服。他们可能会做一千种小事来让体验多出 10% 的乐趣。在那一刻，他们变得更高效了，质量变好了，他们听我说话的方式也不同了。这真的是一个非常强大的工具。我知道问题在于，有些人会说：“好，现在我必须享受生活，我要忽视所有负面情绪，这样我就能处于享受中。”那行不通。那太可怕了，简直是自讨苦吃。

---

### [00:43:18] Lenny Rachitsky

**English:**
Along these lines, how much of the work is learning to enjoy the thing you're doing more versus finding something that you innately enjoy? Which one is more powerful? I guess, which do you point people to? Which experiments do you find people should run more?

**中文翻译:**
沿着这个思路，有多少工作是学习去“更多地享受你正在做的事”，而有多少是去“寻找你天生就享受的事”？哪一个更强大？或者说，你更倾向于引导人们去做哪一个？你觉得人们应该多做哪种实验？

---

### [00:43:31] Joe Hudson

**English:**
In our society, typically, it's how to enjoy what you're doing more. What happens typically is that if you find a way to enjoy the thing that you're doing more, you're more likely to do the things that you enjoy. It's just an order of operations thing. As compared to there's people, a lot of the people in my circles because of who I coach and everything, they're billionaires and they have spent hundreds of millions of dollars to try to arrange life that they enjoy and it doesn't fucking work. They actually have more power to make everything that they're doing exactly what they want to do, but that doesn't work. Flying the jet or buying the island or blah, blah, blah, blah, blah, doesn't do it.

(00:44:25):
Whereas if you really learn to enjoy what's in front of you, all of a sudden, one thing that happens is that you're not as scared of enjoyment. You start saying, "Oh, wow, enjoyment makes me really effective, and so I'm want to do the things that I enjoy." You're more likely to do the things that you enjoy. Instead of having this story, I have to do X, Y, and Z so that at one point in the future, I can do what I enjoy. It's just an order of operations things. If you learn to enjoy the things that you're doing, you're going to naturally start doing the things you enjoy. If you only do the things you enjoy, you will not learn how to enjoy what you're doing very well.

**中文翻译:**
在我们的社会中，通常是“如何更多地享受你正在做的事”。通常发生的情况是，如果你找到了更多享受当前事情的方法，你就更有可能去做你真正享受的事情。这只是一个操作顺序的问题。相比之下，在我圈子里的很多人——因为我辅导的对象——他们是亿万富翁，他们花了数亿美元试图安排一种他们享受的生活，但那真他妈的一点用都没有。他们实际上有更大的权力让所做的每一件事都完全符合心意，但那没用。开私人飞机、买海岛等等，都做不到这一点。

(00:44:25):
而如果你真正学会享受眼前的事，突然之间，一件事发生了：你不再那么害怕享受了。你开始说：“噢，哇，享受让我非常高效，所以我想要做我享受的事情。”你更有可能去做你享受的事。而不是抱着这样的故事：“我必须做 X、Y 和 Z，这样在未来的某个时刻，我才能做我享受的事。”这只是顺序问题。如果你学会享受你正在做的事，你自然会开始做你享受的事。如果你只做你享受的事，你就学不会如何很好地享受你正在做的事。

---

### [00:45:03] Lenny Rachitsky

**English:**
You show this tip of how can I enjoy this 10% more? Just ask yourself, how can I enjoy this 10% more?

**中文翻译:**
你分享了这个技巧：我如何能多享受 10%？只要问自己：我如何能多享受 10%？

---

### [00:45:09] Joe Hudson

**English:**
Yes, right now.

**中文翻译:**
是的，就在当下。

---

### [00:45:10] Lenny Rachitsky

**English:**
Is there anything else that you find helpful for helping? Yeah, right now, how can I enjoy this 10% right now?

**中文翻译:**
还有什么你觉得有帮助的吗？是的，就在当下，我如何能现在就多享受 10%？

---

### [00:45:14] Joe Hudson

**English:**
That's right. It's not about changing anything in the external world.

**中文翻译:**
没错。这与改变外部世界的任何事物无关。

---

### [00:45:19] Lenny Rachitsky

**English:**
Got it. Internally, what can I do? What can I change about the way I'm experiencing this?

**中文翻译:**
明白了。在内心，我能做什么？我能改变什么关于我体验这件事的方式？

---

### [00:45:23] Joe Hudson

**English:**
Yeah. I like to ask it as how do you enjoy it 10% more, because if it's what can I change, then there's trying, trying is usually not more enjoyment. It's actually usually letting go of trying that creates more enjoyment. The phrasing can really make or break the question.

**中文翻译:**
是的。我喜欢问“你如何多享受 10%”，因为如果是“我能改变什么”，那就涉及到了“努力”，而努力通常不会带来更多享受。实际上，通常是“放下努力”创造了更多享受。措辞真的能决定这个问题的成败。

---

### [00:45:41] Lenny Rachitsky

**English:**
Enjoy it 10% more. Say someone's sitting in a boring meeting that's really sucking their soul, look, they should ask themselves this question, how can I enjoy this 10% more?

**中文翻译:**
多享受 10%。假设有人正坐在一个枯燥乏味、耗尽灵魂的会议上，他们应该问自己这个问题：我如何能多享受 10%？

---

### [00:45:51] Joe Hudson

**English:**
Well, should, they can. They get to, it's a great experiment.

**中文翻译:**
嗯，不是“应该”，是“可以”。他们有机会这样做，这是一个很棒的实验。

---

### [00:45:54] Lenny Rachitsky

**English:**
It's an experiment. Okay, perfect.

**中文翻译:**
这是一个实验。好，完美。

---

### [00:45:58] Joe Hudson

**English:**
The reason I do the should thing is that as soon as you say you should and then you don't then you can fail. If you fail, then you're less likely to try it again. That's why the should, it ends up usually in stagnation. If you think about the way it feels in your body when you say, I should do something, and there's a stagnation, there's a, hmm. whereas if you say something like, oh, I want to do it, or here's an experiment I can do, or here's what I enjoy, there's less stagnation, there's more movement.

**中文翻译:**
我之所以纠结“应该”这个词，是因为一旦你说“你应该”而你没做到，你就失败了。如果你失败了，你就不太可能再次尝试。这就是为什么“应该”通常会导致停滞。如果你思考一下当你对自己说“我应该做某事”时身体的感觉，那是一种停滞感。而如果你说“噢，我想做”，或者“这是一个我可以做的实验”，或者“这是我享受的”，停滞感就会减少，流动感会增加。

---

### [00:46:31] Lenny Rachitsky

**English:**
This touches on something else that you talk a lot about, and we've been circling around this idea of authenticity versus improvement, where you help people realize that you are good as you are, you don't need to necessarily improve. We've talked a lot about these sorts of things already, but just what else can you share there just how to help people learn this?

**中文翻译:**
这触及了你经常谈论的另一件事，我们一直围绕着“真实性 vs. 改进”这个想法。你帮助人们意识到，你现在的样子就很好，不一定非要改进。我们已经谈了很多这类事情，关于如何帮助人们理解这一点，你还有什么可以分享的吗？

---

### [00:46:49] Joe Hudson

**English:**
My favorite metaphor on this one is at what time in the journey of an oak tree is it perfect? Is it when it's an acorn, when it's sprout, when it's 20 years old, 40 years old, 150 years old, 200 years old, depending on the oak tree? Now, I'm perfect. The idea is ridiculous. It's a similar thing for us. The idea that I need to improve myself, it really disturbs the natural process that's at hand, which is we evolve. We as human beings evolve. If it's like, oh, I'm evolving and I can enjoy it, and I'm acting from my authenticity, then that has a lot of alacrity. That moves quick. If it's I need to improve, there's something wrong with me, I need to improve, I should do it, that all goes really fucking slow. Because there's a lot of emotional stagnation in that.

(00:47:55):
There's a lot of should shame. There's a lot of stagnation in that, and so you don't actually get that natural flow of life. The Taoist talk about this as kind of like a river always finds its way, it just always goes in that direction. We are naturally evolving. That is our nature. Then to put a whole bunch of shoulds and shits in the way just slows the process down. The other thing about authenticity that I think is really important too, is that if you are one of the few people, I'd say 10, 15%, who can say, I should be this way, this way, and this way, and then you do it, which is very few people can actually do that. What most people do is they say, I should do this, should do that, should do that, and then a decade later, they're still saying they should do the same things. Let's say you're one of those really successful people, then you have a life for not you. Then you have a life of who you think you should be, not for who you actually are.

(00:49:02):
If you move from authenticity, naturally, certain things aren't going to work, certain things are going to work. Certain people are going to work, certain people aren't going to work. Certain jobs are going to work. The ones that you end up with over time are going to be the ones that are right for you, not right, for who you think you should be. The most obvious of this is you meet a woman and you're like, oh, this is how I should be for them to love me, and you just do it. You just do everything that you think you should do, and then you get married, and then they love not you, they love who you think you should be. They don't love who you are. What kind of marriage is that? As opposed to, this is who I am and I'm going to be as genuine. I'm going to show you all my parts. I'm going to be as genuine as I can with you. Then if you do get married, you're married to the right person, you're married to the person who actually sees all that and loves that and wants that.

**中文翻译:**
我最喜欢的比喻是：一棵橡树在它生命的哪个阶段是完美的？是当它是一颗橡子时，还是发芽时，还是 20 岁、40 岁、150 岁、200 岁时？“现在，我完美了。”这种想法很荒谬。对我们来说也是一样。那种“我需要改进自己”的想法，实际上干扰了正在进行的自然过程，即“进化”。我们作为人类在进化。如果说“噢，我在进化，我可以享受这个过程，我正基于我的真实性行事”，那么这个过程会非常轻快（alacrity），进展神速。如果是“我需要改进，我身上有问题，我应该这样做”，那进展就会真他妈的慢。因为其中包含了大量的情绪停滞。

(00:47:55):
这里面有很多“应该”带来的羞耻感。这里面有很多停滞，所以你无法真正获得生命的自然流动。道家（Taoist）谈到这一点时，就像河流总能找到自己的路，它总是朝那个方向流去。我们天生就在进化，那是我们的本性。而在路上设置一堆“应该”和“烂事”只会减慢这个过程。关于真实性，我认为还有一点非常重要：如果你是那极少数（大约 10-15%）能说“我应该这样、那样、再那样”然后真的做到的人——其实很少有人能做到。大多数人是说“我应该做这个、做那个”，十年后他们还在说同样的话。假设你是那些非常成功的极少数人，那么你拥有的生活并不是为你准备的。你拥有的是一个“你认为你应该成为的人”的生活，而不是“真实的你”的生活。

(00:49:02):
如果你从真实性出发，自然地，某些事情会行不通，某些事情会行得通。某些人会合得来，某些人合不来。某些工作会合适。随着时间的推移，你最终留下的将是那些适合“你”的东西，而不是适合“你认为你应该成为的人”的东西。最明显的例子是：你遇到一个女人，你想“噢，为了让她爱我，我应该表现成这样”，然后你就照做了。你做了所有你认为应该做的事，然后你们结婚了，接着她爱的不是“你”，而是“你认为你应该成为的人”。她不爱真实的你。那是种什么样的婚姻？相反，如果你说“这就是我，我会尽可能真实。我会向你展示我所有的部分。我会尽可能对你真诚。”那么如果你真的结婚了，你是和对的人结婚了，你嫁/娶的是那个真正看到这一切、爱这一切并渴望这一切的人。

---

### [00:50:01] Lenny Rachitsky

**English:**
How do you hold that idea with I also want to get better, I want to develop myself, I want to feel my emotions more, those sorts of things?

**中文翻译:**
你如何将这个想法与“我也想变得更好，我想提升自己，我想更多地感受我的情绪”这类想法结合起来？

---

### [00:50:10] Joe Hudson

**English:**
I love that I want to, the better part is kind of just, gets a little bit in the way. We all want to, like a little kid wants to run faster. They might want to be a better runner, but the part that they missed, the reason that they develop so fucking quickly is because they don't think they're going to be a better person if they run faster. The idea is like, yeah, you have this natural want, that want is the thing that moves evolution. A plant is like, "Oh, there's sun. I want to move in that direction." As compared to I should. Both of them are human concepts, but the want, it's the thing that what allows us to know that's our evolutionary path. Oh, I have this want to be closer to people. Oh, I have this want for great sex. Oh, I have this want for being able to have a business that supports me.

(00:51:07):
These are great wants, and they show where the growth is occurring or wants to occur. It's like that's our natural evolution. It's great. What makes it need to be better? I want to be better. It just slows it down instead of, it's like saying that what I am is broken and therefore, the whole thing slows down. We try to word everything as more in the experimental framework, but also, we try to word everything as self-awareness, self-experimentation, self-discovery, instead of self-improvement. Because if you understand the problem, then the problem goes away. Just explore it. Just understand it as compared to making a list of things that you should do to get better, that you will eventually fail and then you'll just be stuck in this should loop where you beat yourself up and where most people hang out a lot.

**中文翻译:**
我喜欢“我想要”这个说法，而“更好”这个部分有点碍事。我们都有渴望，就像小孩想跑得更快。他们可能想成为更好的跑步者，但他们忽略的一点是——也是他们之所以能进步得真他妈快的原因——他们并不认为如果跑得快，他们就会成为一个“更好的人”。这个想法是：是的，你有一种天然的渴望，这种渴望是推动进化的力量。植物会想：“噢，那里有阳光，我想往那个方向生长。”这与“我应该”不同。两者都是人类的概念，但“渴望”是让我们知道那是我们的进化路径的东西。噢，我有这种想与人更亲近的渴望。噢，我有这种对美妙性生活的渴望。噢，我有这种想拥有一份能养活我的事业的渴望。

(00:51:07):
这些都是伟大的渴望，它们展示了成长正在发生或想要发生的地方。这就是我们的自然进化。这很棒。为什么非要说“变得更好”？“我想变得更好”只会减慢速度，这就像是在说“现在的我是残缺的”，因此整个过程都会慢下来。我们尝试将一切措辞都放在实验框架内，我们也尝试将一切措辞定为“自我觉察”、“自我实验”、“自我发现”，而不是“自我改进”。因为如果你理解了问题，问题就会消失。去探索它，去理解它，而不是列出一堆你“应该”做来变好的事情，因为你最终会失败，然后你会陷入这种“应该”的循环中不断自责，而这正是大多数人长期停留的地方。

---

### [00:52:10] Lenny Rachitsky

**English:**
The experiment here that I'm taking away is think more about your want versus the should, and then things you think you need is okay.

**中文翻译:**
我学到的实验是：多思考你的“想要”而不是“应该”，以及你认为你“需要”的东西，这样可以吗？

---

### [00:52:20] Joe Hudson

**English:**
Because typically, when you say, I want to improve, it means the subtext in that is once I do X, Y, and Z, then I'm lovable. Once I do X, Y and Z, then I'm okay. Once I do X, Y and Z, I'll be worthy. Once I do X, Y and Z, I'll be enlightened, whatever the fuck, the thing is. That's just not how it works. What works is the person who loves themselves has loving relationships. It's not the person who's done X, Y, and Z so that they can be lovable, has loving relationships. The people who do X, Y and Z, so they can be lovable have relationships where people are critical and constantly telling them that they have to be better.

**中文翻译:**
因为通常当你说“我想改进”时，潜台词是：一旦我做到了 X、Y 和 Z，我就是值得被爱的。一旦我做到了 X、Y 和 Z，我就没问题了。一旦我做到了 X、Y 和 Z，我就有价值了。一旦我做到了 X、Y 和 Z，我就开悟了，管他妈的是什么。但事实并非如此。事实是：爱自己的人拥有充满爱的关系。而不是那个为了变得值得被爱而做了 X、Y、Z 的人拥有充满爱的关系。那些为了变得值得被爱而去做 X、Y、Z 的人，他们拥有的关系中，对方往往也是挑剔的，并不断告诉他们必须变得更好。

---

### [00:53:01] Lenny Rachitsky

**English:**
Coming back, you just said this interesting quote that you also shared at the beginning. This idea, once we understand the problem, it goes away.

**中文翻译:**
回到刚才，你说了这句有趣的引言，你在开头也分享过。这个想法：一旦我们理解了问题，它就会消失。

---

### [00:53:06] Joe Hudson

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:53:07] Lenny Rachitsky

**English:**
Let's make sure people understand what that means. Is it related to this idea once you feel like I'm an asshole, okay, and then like, oh, okay, and then it starts to kind of away, is that the core?

**中文翻译:**
让我们确保大家理解这意味着什么。这是否与那个想法有关：一旦你感觉到“我就是个混蛋，好吧”，然后“噢，好吧”，接着它就开始消散了，这是核心吗？

---

### [00:53:15] Joe Hudson

**English:**
I just mean practically. It's like, can you really fully understand a problem if you don't understand the solution to it? There's a principle, and I can't remember the name of it, like it's Strickland principle or something. It's something that this CFO that I used to work with said, and he would say, "Problems get solved if you spend time on them. If you just give enough attention to a problem, the problem will solve." That's the way it works in business. An unsolvable problem, obviously, it's not going to work that way. The reason that, that works is because the more you spend time on a problem, the more you understand it.

(00:53:58):
Another one, love him or hate him, one of the things that Elon Musk has said that I found it very valuable in my time, is that if you really want to interview somebody and they claim that they've done something, you ask them six levels down. You improved sales. How did you do that, exactly? Well, we improved the pipeline. How'd you do that, exactly? Oh, well, we made the pipeline more measurable by having things that could be. How did you know? What were the seven stages of the pipeline and what made you pick them? You go six levels down and you can really understand if somebody was the person who solved the problem or if they're the person who is claiming that they solved the problem. It's the same thing.

(00:54:47):
If we just explore a problem enough, the solution is apparent. If we understand the problem enough, the solution is apparent. Typically, if we come to a problem with a kid's mind, wonder, if we come to it, what could I learn here? What's exciting? What are the experiments I can run? Then typically, that's the most efficient way, enjoyable way to solve a problem as compared to, I have to get to this problem by this time and we're going to do it this way. Usually, that doesn't work. I could geek out on why that lets democracies win over autocracies because they're far more experimental by nature, and it's not one person saying how things are going, but just generally, just we're more efficient when we're exploring. We're more efficient when we're exploring ourselves and understanding ourselves and trying to improve ourselves.

**中文翻译:**
我只是指实际操作层面。就像是，如果你不理解解决方案，你真的能完全理解问题吗？有一个原则，我不记得名字了，好像叫斯特里克兰原则之类的。这是我以前共事过的一位 CFO 说的，他会说：“如果你在问题上花时间，问题就会得到解决。如果你对一个问题给予足够的关注，问题就会迎刃而解。”在商业中就是这样运作的。当然，一个无法解决的问题显然不会这样。之所以有效，是因为你在一个问题上花的时间越多，你就越理解它。

(00:53:58):
另一个例子，不管你喜不喜欢他，埃隆·马斯克说过的一句话我觉得非常有价值：如果你真的想面试某人，而他们声称自己做成了某件事，你就往下追问六层。你提高了销售额，具体是怎么做的？“嗯，我们改进了销售漏斗。”具体是怎么改进的？“噢，我们通过增加可衡量的环节让漏斗更清晰。”你是怎么知道的？漏斗的七个阶段是什么，你为什么选择它们？你往下追问六层，你就能真正理解那个人到底是解决问题的人，还是声称自己解决了问题的人。道理是一样的。

(00:54:47):
如果我们对一个问题探索得足够多，解决方案就是显而易见的。如果我们对问题理解得足够深，解决方案就是显而易见的。通常，如果我们带着孩子般的好奇心去面对问题——我能在这里学到什么？什么是有趣的？我可以做哪些实验？——那么通常这就是解决问题最有效、最令人愉悦的方式。相比之下，“我必须在某个时间前解决这个问题，我们要这样做”，通常行不通。我可以深入探讨为什么这让民主政体胜过专制政体，因为民主政体本质上更具实验性，不是由一个人说了算。但总的来说，我们在探索时效率更高。当我们探索自己、理解自己而不是试图改进自己时，我们的效率更高。

---

### [00:55:46] Lenny Rachitsky

**English:**
There's a couple of more experiments I want to help people try to run. One is you have some really good advice around decision-making and how emotions and getting better at understanding and working with your emotions helps you make better decisions. Can you talk about that?

**中文翻译:**
我还想帮大家尝试做几个实验。一个是关于决策的，你有一些非常好的建议，关于情绪以及更好地理解和处理情绪如何帮助你做出更好的决策。你能谈谈这个吗？

---

### [00:55:59] Joe Hudson

**English:**
That's similar to what I said before, which is if you learn to fall in love with the emotional experiences, then you have more solution sets. Let's say I want to have all human beings, I want to be a part of a great team. Nobody has ever raised their hand and said, "I'd like to be a part of a team." Yet, grand majority of people at their work right now have shitty teams or not A teams, not great teams, even though nobody wants that. If one of the things you're unwilling to feel is that conflict, that tension, as we talked about if you're conflict avoidant, you're not going to be able to make an A team because there's nothing that is alive doesn't require tension. A cell requires tension. Breathing requires tension. Playing pickleball requires tension. A good team requires tension. If you're going to avoid that experience, you're not going to be as easily, if at all, be able to create a quality team.

(00:57:05):
To be able to look forward to any emotional experience, creates more and more solution sets for more and more optionality. In creating a great team, for instance, you need to be good with people hating you. You need to be good with drawing boundaries and having people upset. You need to be able to have high expectations. You have to be okay with somebody being disappointed with themselves. You have to be okay being disappointed with yourself. All these emotional experiences have to be available to you if you're going to find the solutions to make an A quality team. The more you can fall in love with each emotional experience, the more you have and then the clearer the decision making gets. That's one thing for making great decisions. The other one that I find really, really useful and very hard to execute on until you really understand it is creating a set of principles to live by.

(00:58:06):
We all have a set of principles to live by that we're doing it. For a lot of people, those principles are what do I have to do to get likes on Facebook? I'm going to make a decision based on getting likes on Facebook. I'm going to make decisions based on whatever it is. Pretending that I want to get wealthy or trying to get wealthy or there's a series of things. If you really take a look at what it is you're making your decisions on and then really think about, well, what would be the five or six things that if I made decisions with these principles, I'm guaranteed success? Then experiment with them and then refine those principles and then experiment with them. Then there'll be these moments where you don't want to do it, but those are your principles, so you're going to go and do it.

(00:59:03):
As an example for this, one of the principles that I live by is embrace intensity. It's not create intensity, it's embrace intensity. It means that right now, any moment in my body, for instance, there's going to be a sensation that's more intense. How do I welcome that sensation? At any moment in running my business, there's going to be something that we don't want to talk about. How do we lean in and talk about that? We start all of our meetings with what are you scared to say in our business? What are you scared to say? Not all of our meetings, but some of our meetings are started with what are you scared to say? Because we want to embrace that intensity because we know that if we lean into the thing that we're trying to avoid, our life is going to get better, our business is going to get better.

(00:59:57):
If you can see what those principles are for you, and then run experiments to see if they work and then refine them every once in a while. Because of that embrace intensity, if somebody comes to me and says, "You're fucking up this business. You're doing it all wrong." I don't have to think about what I'm going to do. I'm like, "Oh, cool. Tell me what I'm missing." It's going to be immediate because I live this way. Maybe I don't want to hear it. Maybe I'm having a bad day. Whatever it is. Maybe I'll say, "Hey, I want hear you give me, I'm not able to, give me a day and I'll come back to you." all of a sudden, my decisions get made automatically if I live by a set of principles and very effective, I find very effective living by a set of principles.

**中文翻译:**
这和我之前说的一样：如果你学会爱上各种情绪体验，你就会拥有更多的解决方案集。假设我想——所有人都想——成为一个优秀团队的一员。没有人会举手说：“我想加入一个烂团队。”然而，绝大多数人现在的工作团队都很糟糕，或者不是顶尖团队，尽管没人想要那样。如果你不愿意感受的是那种“冲突”或“紧张”，就像我们说的，如果你逃避冲突，你就无法打造一支顶尖团队，因为任何有生命力的东西都需要紧张感。细胞需要张力，呼吸需要张力，打匹克球（pickleball）需要张力，一个好的团队也需要张力。如果你逃避那种体验，你就很难（甚至根本无法）创建一个高质量的团队。

(00:57:05):
能够期待任何情绪体验，会为更多的选择创造越来越多的解决方案集。例如，在创建一个伟大的团队时，你需要能够接受别人讨厌你。你需要能够划定界限并接受别人因此不高兴。你需要能够设定高期望。你必须能够接受有人对自己感到失望。你必须能够接受对自己感到失望。如果你想找到打造顶尖团队的方案，所有这些情绪体验都必须是对你开放的。你越能爱上每一种情绪体验，你拥有的就越多，决策也就越清晰。这是做出伟大决策的一点。另一件我发现非常有用、但在你真正理解之前很难执行的事是：建立一套生活准则（principles）。

(00:58:06):
我们其实都有一套正在遵循的生活准则。对很多人来说，那些准则是：“我该怎么做才能在 Facebook 上获得点赞？”我会基于获得点赞来做决定。或者基于其他任何事情做决定：假装我想变富有，或者努力变富有，或者一系列事情。如果你真的审视一下你做决定的依据，然后认真思考：如果我根据这五六条准则做决定，哪几条能保证我获得成功？然后去实验它们，完善它们，再实验。会有那么一些时刻你不想照做，但那是你的准则，所以你会去做。

(00:59:03):
举个例子，我遵循的准则之一是“拥抱强度”（embrace intensity）。不是“创造强度”，而是“拥抱强度”。这意味着，比如现在，我身体里的任何时刻都可能有一种更强烈的感官体验，我该如何欢迎那种感觉？在经营业务的任何时刻，总会有一些我们不想谈论的事情，我们该如何切入并谈论它？我们所有的会议——不是全部，但有些会议——开头都会问：“在我们的业务中，你害怕说什么？”因为我们想拥抱那种强度，因为我们知道，如果我们直面那些试图逃避的事情，我们的生活会变得更好，我们的业务也会变得更好。

(00:59:57):
如果你能看清你的准则是什​​么，然后运行实验看看它们是否有效，并偶尔完善它们。因为“拥抱强度”这条准则，如果有人来对我说：“你把这生意搞砸了，你全做错了。”我不需要思考该怎么办。我会说：“噢，酷，告诉我我错过了什么。”这会是下意识的反应，因为我就是这样生活的。也许我不想听，也许我今天心情不好，不管怎样，也许我会说：“嘿，我想听你说，但我现在没法听，给我一天时间，我再找你。”突然之间，如果我按照一套准则生活，我的决策就会自动做出。我发现按照一套准则生活是非常有效的。

---

### [01:00:51] Lenny Rachitsky

**English:**
For someone that wants to create their own set of principles. Is there a guide you have? Is there any advice for how to actually go about starting this list, putting it together?

**中文翻译:**
对于想要创建自己的一套准则的人，你有什么指南吗？关于如何开始列清单、如何整合，有什么建议吗？

---

### [01:00:58] Joe Hudson

**English:**
We have a decisions course, which is a large part of it is about how to do that. It's a difficult one to explain because there's a lot of nuance in it. Just as for instance, one of the nuances is defining the principles, not just by what it is, but what it isn't is a really significant, very minor thing, but it ends up being incredibly major. If you're going to do your set of principles and you want to do them on your own, the main thing I would say is keep it to five. I wouldn't even do six. I don't do six, but I keep it to five. I would test each one of them for five days.

(01:01:39):
Make your principle and then see if it works for you for five days and then keep on experimenting until you find five. When you look at those five and you say, "If I do that, if I live by those principles, I am just almost a hundred, if not a hundred percent confident that, that's going to create the life I want if I live by those principles." Then you have a really good start and make them simple. Mine are things like embrace intensity or connection first or everything is in iteration. As soon as I live by them, things work, company works.

**中文翻译:**
我们有一个关于决策的课程，其中很大一部分就是关于如何做这件事。这很难解释，因为里面有很多细微差别。例如，其中一个细微差别是：定义准则时，不仅要定义它“是什么”，还要定义它“不是什么”。这是一个非常细小但最终极其重要的点。如果你打算自己制定准则，我想说的要点是：保持在五条以内。我甚至不会做六条。我不做六条，我只保留五条。我会对每一条进行为期五天的测试。

(01:01:39):
制定你的准则，然后看它在五天内对你是否有效，不断实验直到你找到五条。当你看着这五条准则并说：“如果我遵循这些准则生活，我有近乎 100% 的信心，这会创造我想要的生活。”那么你就有一个很好的开始了。让准则保持简单。我的准则是诸如“拥抱强度”、“连接第一”或“一切皆在迭代”。只要我遵循它们，事情就顺利，公司就运转良好。

---

### [01:02:20] Lenny Rachitsky

**English:**
Amazing. We'll point folks to that course if they want to take it themselves. Cool.

**中文翻译:**
太棒了。如果有人想参加，我们会引导他们去那个课程。酷。

---

### [01:02:25] Joe Hudson

**English:**
It's only once a year, so it's a rare one.

**中文翻译:**
一年只有一次，所以很稀有。

---

### [01:02:27] Lenny Rachitsky

**English:**
Oh, wow. When is the next one?

**中文翻译:**
噢，哇。下一次是什么时候？

---

### [01:02:29] Joe Hudson

**English:**
January.

**中文翻译:**
一月份。

---

### [01:02:30] Lenny Rachitsky

**English:**
Okay. Not too far away for folks to want to wait. Again, the two pieces of advice you shared, and that's our experiments that we can run to help become better decision makers. One is create a list of life principles, and there's a course that will point people to, to take that. The other is the thing you keep coming back to over and over and over, this idea of falling in love with your emotions, embracing your emotions, welcoming your emotions. There's also, I know you do a lot of work with teams. I imagine there's very similar advice for how to help your team be more effective. Principles, I imagine is a part of it, falling in love.

**中文翻译:**
好，那也不算太远。再次总结一下你分享的两条建议，也就是我们可以进行的实验，以帮助我们成为更好的决策者：一是创建一份生活准则清单；二是那个你反复提及的主题——爱上你的情绪，拥抱你的情绪，欢迎你的情绪。另外，我知道你和团队做了很多工作。我猜在帮助团队变得更有效方面，也有非常相似的建议。准则应该是其中的一部分，还有爱上情绪。

---

### [01:03:02] Joe Hudson

**English:**
We've run principles for teams, yeah. That's one of them. Teams would be more effective. We have a lot of, I mean I think I have, at this point, I have 12 things that I'll go into a company and do with a company. Typically, the way I like to do it is I will go in and I'll talk to the leader typically and they'll say, "This is what I want." Then I really want to assess. Typically, if the person who is a big part of creating the problem has a hard time seeing the way through the problem, or it wouldn't have been created generally. This is not demeaning any leader, we all have these issues. Usually, what I like to do is I like to go in and I like to talk to three or four people, see what their perspective, not just the leader's perspective.

(01:03:57):
Then I like to sit in a meeting or two and just see actually what the dynamic is. One of the things I like to say about how to change a company is that the atomic structure of a company is the meetings and the decisions. It's particularly true in Silicon Valley, but it's really true in all businesses that all we are as a company is a group of people's relationships and ideas. Especially, like Amazon, you got a couple of buildings and some servers. There's not a lot of hardware there, and they wouldn't be useful without the people anyways. Anybody, whether you're running a farm or a shoe factory or anybody's successful is going to tell you it's all about the people. The atomic structure is what are our meetings like and how do we make decisions? I'll just really pay attention to a meeting. One of the things we do is we talk about what we call five-star meetings, which is how do you make every meeting enjoyable?

(01:05:04):
Literally, how is it that everybody when they walk out of a meeting, they're like, oh, fuck, that was great? It turns out, we've all been in meetings that are hard as shit, and we've walked out and gone, oh, those are great meetings. We've all been in meetings where nothing happens and we're like, "Oh, God. Fuck, another one to just drive a nail through my head. I don't want to sit there." What's required to make one of your meetings five stars? If you do that, that's one of the things we'll do inside of a company is work with them to figure that out. If you do that, every single problem with your company will come to the surface. Every single one of them. I had ten five-star meetings, but these two meetings sucked. That tells me exactly where we need to focus as a company.

(01:05:53):
That tells me exactly where to look for the problem that's happening. It's the same thing with decisions. If you really start unpacking how the decisions are made where people are frustrated in the decision-making process, you're going to find exactly the problems in the company. An example of this, I was working with a friend and he's a content person, and we were just talking about how do you make every one of your meetings a five-star meeting? He's like, "Okay, great." He's like, "Yeah, I'm never going to do this." I was like, "Really? Tell me why." He's, "My YouTube meetings fucking suck." That's not where he makes most of his money, but these YouTube meetings suck. They're never going to get better.

(01:06:39):
Luckily, there's a couple other people around at the time and everyone's like, "No, wait, I love my YouTube meetings. What do you mean? How could this not work for you?" He noticed, oh, the team didn't, the content, none of it was working for him. None of it was him. He was just like, "Ugh." He changed it. He was like, "Okay, I'm going to commit to that. I'm going to see what it's like for me to just say every one of my YouTube meetings have to be something that's super enjoyable to me." When he did it, his YouTube numbers went off the charts in a very short period of time. It's just that common. Wherever the meeting is that sucks, it means there's something else that's a problem that needs to be worked on. That's typically how. I can just look at, usually sit in any team meeting and see at least three or four of the major problems that are happening in the company.

**中文翻译:**
我们确实为团队制定过准则。那是其中之一，能让团队更有效。目前我有 12 件事是我会进入公司去做的。通常我喜欢先和领导者谈谈，他们会说：“这就是我想要的。”然后我会进行评估。通常，如果一个人是制造问题的主要部分，他很难看清解决问题的路径，否则问题通常也就不会产生了。这并不是在贬低任何领导者，我们都有这些问题。通常我喜欢进去和三四个人聊聊，看看他们的视角，而不仅仅是领导者的视角。

(01:03:57):
然后我喜欢旁听一两场会议，看看实际的动态是怎样的。关于如何改变一家公司，我喜欢说：公司的“原子结构”就是会议和决策。这在硅谷尤其如此，但在所有行业都一样，一家公司本质上就是一群人的关系和想法。特别是像亚马逊，你只有几栋楼和一些服务器，没有人的话那些硬件也没用。任何人，无论经营农场还是鞋厂，只要是成功的，都会告诉你一切都在于人。原子结构就是：我们的会议是什么样的，以及我们如何做决定？我会非常关注会议。我们做的一件事是讨论所谓的“五星级会议”，即如何让每一次会议都令人愉悦？

(01:05:04):
字面意思就是，如何让每个人走出会议室时都觉得：“噢，天哪，太棒了！”事实证明，我们都参加过那种难得要命的会议，但走出来时会觉得：“噢，那是场伟大的会议。”我们也参加过那种什么都没发生、让人觉得“噢天哪，又来一个让人头大的会议，我真不想坐在那儿”的会议。让你的会议达到五星级需要什么？这是我们在公司内部会做的事情之一。如果你这样做，你公司的每一个问题都会浮出水面。每一个。我有十个五星级会议，但这两个会议很烂。这准确地告诉了我作为一家公司我们需要关注哪里。

(01:05:53):
这准确地告诉了我去哪里寻找正在发生的问题。决策也是一样。如果你开始拆解决策是如何做出的，以及人们在决策过程中哪里感到沮丧，你就会准确地找到公司里的问题。举个例子，我曾和一位做内容的朋友合作，我们讨论如何让他的每一次会议都成为五星级会议。他说：“好，太棒了。”接着又说：“但我永远做不到。”我问：“真的吗？告诉我为什么。”他说：“我的 YouTube 会议真他妈的烂。”那不是他赚大钱的地方，但那些 YouTube 会议很烂，而且永远不会变好。

(01:06:39):
幸运的是，当时周围还有几个人，大家都说：“不，等等，我喜欢我的 YouTube 会议。你什么意思？这怎么会对你没用呢？”他意识到，噢，那个团队、那些内容，没有一样是适合他的。那都不是他想要的。他只是觉得“呃”。于是他改变了。他说：“好，我承诺，我要看看如果我要求每一次 YouTube 会议都必须是我超级享受的事情，会发生什么。”当他这样做时，他的 YouTube 数据在很短的时间内就爆表了。就是这么普遍。哪里有糟糕的会议，就意味着哪里有其他需要解决的问题。通常就是这样。我只要坐在任何团队会议中，通常就能看到公司里存在的至少三四个主要问题。

---

### [01:07:29] Lenny Rachitsky

**English:**
Such a cool way of thinking about where to focus decision-making meetings. I love that the story comes back to something you shared earlier with the more you enjoy something, the more joy there is, the better it's going to go anyway. The more you can find those moments and make things enjoyable, the better.

**中文翻译:**
这种思考从哪里着手解决决策和会议问题的方式太酷了。我喜欢这个故事又回到了你之前分享的观点：你越享受某件事，其中的喜悦越多，事情无论如何都会进展得越好。你越能找到那些时刻并让事情变得令人愉悦，结果就越好。

---

### [01:07:45] Joe Hudson

**English:**
The other cool thing is most of the executives or the CEOs that I've worked with, when they get to a point, and it usually takes them like, we always have the goal of a month, it usually takes two months to make sure every one of their meetings is five-star meetings. Once they've done that, then it's like, how do you make sure all of your teams have five-star meetings? Usually, it's like within two months and they usually have half the amount of meetings at the end of it. Half the amount of meetings in their companies are more effective. It's an incredible tool.

**中文翻译:**
另一件酷的事情是，我合作过的大多数高管或 CEO，当他们达到那个点时——通常需要两个月，虽然我们的目标总是一个月——来确保他们的每一次会议都是五星级会议。一旦他们做到了，接下来就是：如何确保你所有的团队都有五星级会议？通常在两个月内，他们最终的会议数量会减少一半。他们公司的会议减少了一半，但效率却更高了。这是一个不可思议的工具。

---

### [01:08:18] Lenny Rachitsky

**English:**
I could see why people enjoy that if you were meeting as well. Is there anything more along those lines before we start to close out our conversation, either around teams or decision-making?

**中文翻译:**
我能理解为什么人们会喜欢会议减少。在结束对话之前，关于团队或决策，还有什么要补充的吗？

---

### [01:08:30] Joe Hudson

**English:**
I'll say for anybody who's running a team, Harvard has got a couple of these, but we used to do these tiny pulses. As a VC, one of the strategies that was really effective that I saw very few VCs doing was I would want these pulse, I would like to read the pulse of teams with these short surveys and stuff. It was the most effective way of not very happy, didn't want to come to work on Monday. They weren't going to make their numbers. The likelihood of them making their numbers is going down. There was this interesting thing that just about how Drucker, I think said it first and then the Virgin guy.

---

### [01:09:15] Lenny Rachitsky

**English:**
Branson?

**中文翻译:**
布兰森（Richard Branson）？

---

### [01:09:16] Joe Hudson

**English:**
Branson said it. He's like, "Culture eats strategy for breakfast," or some such. If that's true, then it's measurable and it can be a leading indicator, and it absolutely is. If you really pay attention to the culture on a team-by-team basis, it's an amazing, very effective way to drive results, but also, a very effective way to know when bad results are coming. What's interesting to me is most people feel like they can't control the culture, like most people feel like.

(01:09:52):
Most people, I notice, they feel like, it's more likely for me to hear from a CEO, "God damn it, everybody agrees when I get out of the table. When I get off the table, everyone's like, yeah, we're going to do it. Then they don't do it. Why aren't they doing it?" I'm going to hear that more often than I'm going to hear a CEO say, "Oh, wow. I really noticed that the way the email system was working in our company, we were disempowering people by not requiring an action after every..." I'm going to hear more complaints about why shit isn't working than I'm going to hear about strategies, like very gentle, simple strategies to change the culture. it's an amazing thing to me that it's so powerful and yet people feel so out of control with it.

**中文翻译:**
布兰森说的。他说：“文化把战略当早餐吃”（Culture eats strategy for breakfast），大概是这个意思。如果这是真的，那么它就是可衡量的，并且可以作为一个领先指标，事实也确实如此。如果你真的关注每一个团队的文化，这是一种惊人的、非常有效的驱动结果的方式，也是一种非常有效的预知糟糕结果何时到来的方式。让我觉得有趣的是，大多数人觉得他们无法控制文化。

(01:09:52):
我注意到，我更常听到 CEO 抱怨：“该死，我在桌上谈的时候大家都同意。当我离开桌子，大家都说‘好，我们要去做’，然后他们就不去做。为什么他们不去做？”我听到这种抱怨的频率，远高于听到一个 CEO 说：“噢，哇，我真的注意到我们公司的邮件系统运作方式让员工感到无力，因为我们没有要求在每封邮件后都有一个行动……”我听到的关于“为什么烂事不断”的抱怨，远多于关于改变文化的温和、简单的策略。对我来说，文化如此强大，但人们却感到如此失控，这真是一件神奇的事情。

---

### [01:10:40] Lenny Rachitsky

**English:**
To give people something they can do, say today or tomorrow to work on a lot of these things we've been talking about. Is there just one thing you recommend that basically everyone should try to experiment with in the next day, couple of days or weeks, just to help them be better and more successful and happier?

**中文翻译:**
为了给人们一些今天或明天就能做的事情，来实践我们谈论的这些内容。有没有哪一件事是你建议基本上每个人在接下来的一天、几天或几周内都应该尝试实验的，只是为了帮助他们变得更好、更成功、更快乐？

---

### [01:11:00] Joe Hudson

**English:**
I would do seven minutes, no less than seven minutes. You can do more than seven minutes. Seven minutes of gratitude with another person every day. It can't be, I'm grateful for this, I'm grateful for this, I'm grateful for this. It has to be feeling the gratitude and then seeing what comes out of your mouth when you're coming from the felt sense of gratitude and doing it back and forth. You're savoring the experience of gratitude and you're going back and forth with another human being. Call mom, dad, sister, brother, business partner, friend, and every day just express gratitude back and forth for seven minutes, coming from the feeling, not from the thought. If you have a full body sensation of gratitude and you experience that for seven minutes a day, it'll change your life dramatically really quickly. Really, really quickly.

**中文翻译:**
我会做七分钟，不少于七分钟。你可以做超过七分钟。每天和另一个人进行七分钟的感恩练习。不能只是说“我感谢这个，我感谢那个”。它必须是“感受”到感恩，然后看看当你处于那种感恩的体感中时，你嘴里会说出什么，并与对方来回互动。你在细细品味感恩的体验，并与另一个人类进行互动。给妈妈、爸爸、姐姐、哥哥、商业伙伴或朋友打电话，每天互相表达感恩七分钟，从感觉出发，而不是从想法出发。如果你有一种全身心的感恩感，并且每天体验七分钟，它会非常迅速地剧烈改变你的生活。真的非常、非常快。

---

### [01:12:02] Lenny Rachitsky

**English:**
Wow. I already feel it. The practice is you are expressing gratitude to the person you're with.

**中文翻译:**
哇。我已经感觉到了。这个练习是你向你身边的那个人表达感恩。

---

### [01:12:09] Joe Hudson

**English:**
It can be gratitude for anything in your life. As a matter of fact, I would say do it for a couple of weeks and then do it on the places where you feel lack. That's where the superpower comes in. In my own personal life, I was meditating. I spent seven, eight hours a day meditating for years.

**中文翻译:**
可以是为你生活中的任何事情感恩。事实上，我会说先做几周，然后针对你感到“匮乏”的地方做。那是超能力出现的地方。在我个人的生活中，我曾坚持冥想，多年来每天花七八个小时冥想。

---

### [01:12:31] Lenny Rachitsky

**English:**
That's a lot of hours.

**中文翻译:**
那花了很多时间。

---

### [01:12:32] Joe Hudson

**English:**
You can imagine, I didn't have a lot of money. The joke I used to make is I would meditate and worry about money most of my day. It's funny, but it's truth. One day, I was thinking about money and thinking I was driving in my car and I was thinking about this billionaire I knew and I was thinking about how I didn't have enough and then I thought, "Oh, this billionaire doesn't think they have enough either. I know I'm well enough." I'm like, "Oh, I have the experience of a billionaire right now." I was like, "He's probably driving in a car somewhere thinking he doesn't have enough, and I'm driving in a car somewhere thinking I don't have enough. This is great. I'm a billionaire."

(01:13:20):
It tickled me, the idea tickled me. Then I was like, well, what happens if I start focusing on everything I do have instead of focusing on what I don't have? Which is where the gratitude practice came from. My wife and I would sit every day and just be grateful for all the physical stuff that we had. We were living in a hobble (hovel), were living 15-year-old year cars. We had no money. I was in debt. I was in, I think $40,000 in credit card debt or some crazy shit. We just did it. Literally, was it three months later, my credit card debt was gone. Six months later, I had $60,000 in the bank. Entire life changed because I no longer defined myself by somebody who didn't have, I defined myself as somebody who did have. All of a sudden, I could look out the window and it wasn't, "Oh, shit, I can't have that. I can't have that. I can't have that."

(01:14:18):
I look out the window, I'd say somebody made money on that. Somebody made money on that. Every fucking thing I looked at, somebody made money on. 20 people, 20 companies made money on the fucking lamppost. The person who installed it, the energy company, the rubber company, there's just, holy crap, it's all over the place. Then in that definition, all of a sudden, it became really clear. It doesn't matter if the thing that you feel like you lack is time, or the thing that you feel like you lack is love or the thing that you feel like you lack is money. If you can really do a gratitude practice on the thing that you lack, there's a superpower in that one, changes everything.

**中文翻译:**
你可以想象，我当时没多少钱。我以前常开玩笑说，我一天中大部分时间都在冥想和担心钱。这很好笑，但却是事实。有一天，我正开着车想着钱的事，我想到了我认识的一个亿万富翁，我在想我拥有的不够多，然后我想到：“噢，那个亿万富翁也觉得自己拥有的不够多。我了解他。”我心想：“噢，我现在就拥有和亿万富翁一样的体验。”我想：“他可能正坐在车里某个地方觉得拥有的不够多，而我也正坐在车里某个地方觉得拥有的不够多。这太棒了，我是个亿万富翁。”

(01:13:20):
这个想法逗乐了我。然后我想，如果我开始专注于我“拥有”的一切，而不是专注于我“没有”的一切，会发生什么？这就是感恩练习的由来。我和妻子每天坐在一起，为我们拥有的所有物质财富感恩。当时我们住在简陋的小屋里，开着 15 年车龄的旧车。我们没钱。我负债累累，我想当时我有 4 万美元的信用卡债务，或者类似的烂摊子。我们就那样做了。字面上看，三个月后，我的信用卡债务清零了。六个月后，我银行里有了 6 万美元。整个生活都改变了，因为我不再把自己定义为“匮乏的人”，我把自己定义为“拥有的人”。突然之间，我看向窗外，不再是“噢该死，我买不起那个，我买不起那个”。

(01:14:18):
我看向窗外，我会说：有人在那上面赚到钱了。有人在那上面赚到钱了。我看到的每一件他妈的东西，都有人赚到钱了。20 个人、20 家公司在那根他妈的灯柱上赚到了钱。安装它的人、能源公司、橡胶公司，天哪，到处都是机会。在那样的定义下，突然之间，一切都变得清晰了。无论你觉得匮乏的是时间、爱还是金钱，如果你能真正针对你匮乏的东西进行感恩练习，那里面就有一种超能力，它能改变一切。

---

### [01:14:57] Lenny Rachitsky

**English:**
Do you still do this?

**中文翻译:**
你现在还这样做吗？

---

### [01:15:00] Joe Hudson

**English:**
I do gratitude, yes. Do I do gratitude on stuff I lack? I don't really have an experience of lack. That's not really...

**中文翻译:**
我做感恩练习，是的。我还会针对匮乏的东西做吗？我现在真的没有“匮乏”的体验了。那已经不再是……

---

### [01:15:07] Lenny Rachitsky

**English:**
You still do this gratitude, seven minutes?

**中文翻译:**
你还在做这七分钟的感恩练习吗？

---

### [01:15:09] Joe Hudson

**English:**
Of course, yes. That's like asking if I still have sex. Why would I give that up? It feels great.

**中文翻译:**
当然，是的。这就像问我是否还过性生活一样。我为什么要放弃它？感觉太棒了。

---

### [01:15:16] Lenny Rachitsky

**English:**
Just to be clear, you find someone seven minutes every morning, probably think about things you're grateful for and share back. Focus not on your intellectual thing you're grateful for, but just what's coming out of your emotional body.

**中文翻译:**
明确一下，你每天早上找一个人花七分钟，思考你感激的事情并分享。重点不在于你理智上感激的事，而在于你情绪身体里流露出的东西。

---

### [01:15:28] Joe Hudson

**English:**
Feel the gratitude.

**中文翻译:**
感受那份感恩。

---

### [01:15:30] Lenny Rachitsky

**English:**
Yeah, then gratitude.

**中文翻译:**
是的，然后感恩。

---

### [01:15:30] Joe Hudson

**English:**
Let the feeling of gratitude speak rather than your mind, so that you get the felt sense of it.

**中文翻译:**
让感恩的感觉说话，而不是你的头脑，这样你才能获得那种体感。

---

### [01:15:38] Lenny Rachitsky

**English:**
Joe, I'm incredibly grateful for you. I really appreciate you sharing so many experiments for people to run. I think this is going to make a real impact on a lot of people's lives. Two final questions. Where can folks find your courses? I know you have a podcast. Where can folks find the stuff they do online, and then how can listeners be useful to you?

**中文翻译:**
Joe，我非常感激你。非常感谢你分享了这么多人们可以进行的实验。我认为这会对很多人的生活产生真正的影​​响。最后两个问题：大家在哪里可以找到你的课程？我知道你有一个播客。大家在哪里可以找到你在网上做的内容？以及，听众可以为你做些什么？

---

### [01:15:55] Joe Hudson

**English:**
First of all, Art of Accomplishment, the podcast, it's Art of Accomplishment with Brett Kistler and Joe Hudson, I think. Then Art of Accomplishment, the website will show you where all the courses are. It'll give you a whole bunch of experiments you can run. There's all sorts of really great information there. The other thing that we just mentioned also is just that we really want to make sure that you think that the courses are for you. The way we do courses is that it's a very felt experience thing. It's not intellectual at all. It's really in your body. The way we like doing it is that you bring real problems that you're having and you use the tools that we teach you. The foundational course for that is called the Connection Course. If you want to get into it, go to the Connection Course.

(01:16:45):
To find out if it's right for you, if you're not already know that it's right for you, we do these little hour and a half free workshops and it'll give you a taste of what it is that we do because it's like anything that's going on out there. It's people doing, they're like, "What the hell was that?" It's just a completely different thing. It's not like learning in the normal way. You literally sit down with another person and run experiments face-to-face with how you're being in the moment. You learn all this stuff through direct experimentation. If you find out it's right for you, you can do it through these workshops, and I'm sure there'll be a place where they can find out where to go for that.

**中文翻译:**
首先，播客叫《成就的艺术》（Art of Accomplishment），我想是 Brett Kistler 和 Joe Hudson 主持的。然后是 Art of Accomplishment 网站，上面会显示所有的课程。它会提供一大堆你可以运行的实验。那里有各种非常棒的信息。另一件我们刚才提到的事是，我们真的想确保你觉得这些课程适合你。我们授课的方式是一种非常注重“体感体验”的方式。它一点也不理智化，它完全是在你的身体里。我们喜欢的方式是，你带着你遇到的真实问题，使用我们教给你的工具。其中的基础课程叫“连接课程”（Connection Course）。如果你想加入，就去搜 Connection Course。

(01:16:45):
为了弄清楚它是否适合你，如果你还不确定，我们会举办一个半小时的免费小型研讨会，让你体验一下我们所做的事情。因为它和外面的任何东西都不一样。人们做完后会说：“那到底是什么鬼？”这完全是另一回事。它不像普通的学习。你字面上是和另一个人坐下来，面对面地针对你当下的状态进行实验。你通过直接实验来学习所有这些东西。如果你发现它适合你，你可以通过这些研讨会加入，我相信会有地方能找到相关的入口。

---

### [01:17:27] Lenny Rachitsky

**English:**
There's one coming up in September, I believe.

**中文翻译:**
我相信九月份就有一个。

---

### [01:17:30] Joe Hudson

**English:**
The Connection Course is coming up in September. It's a great place to start. It's foundational for everything else we do.

**中文翻译:**
连接课程将在九月开始。这是一个很好的起点，它是我们所做的一切的基础。

---

### [01:17:37] Lenny Rachitsky

**English:**
Then how can listeners be useful to you?

**中文翻译:**
那么，听众可以为你做些什么？

---

### [01:17:39] Joe Hudson

**English:**
I want my children to grow up in a fantastic world. The best way that, that can happen is that if the people listening to this discover who they are and their nature and the truth of how they operate. Not for them, but for their children and their children's children. You want to do me a favor and make my daughter's world a better place.

**中文翻译:**
我希望我的孩子们在一个美妙的世界里长大。实现这一目标的最佳方式是，听这段对话的人能够发现他们是谁、他们的本性以及他们运作方式的真相。不是为了他们自己，而是为了他们的孩子和子孙后代。如果你想帮我个忙，那就让我的女儿所处的世界变得更美好。

---

### [01:18:08] Lenny Rachitsky

**English:**
I also just had a son, and so I totally resonate with that.

**中文翻译:**
我也刚有了一个儿子，所以我完全能产生共鸣。

---

### [01:18:11] Joe Hudson

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:18:13] Lenny Rachitsky

**English:**
Joe, thank you so much for being here. What an amazing podcast episode. This ended up being as I expected.

**中文翻译:**
Joe，非常感谢你能来。多么精彩的一集播客。结果正如我所料。

---

### [01:18:19] Joe Hudson

**English:**
Pleasure. Thanks for having me. Appreciate it, Lenny.

**中文翻译:**
我的荣幸。谢谢你邀请我。很感激，Lenny。

---

### [01:18:22] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢大家的收听。如果你觉得这集节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。