# John Cutler - 双语对照

This bilingual document captures the key insights from Lenny’s Podcast featuring John Cutler, focusing on product leadership, organizational dynamics, and the reality of building products in complex systems.

---

### [00:00:00] John Cutler

**English:**
Let's say you're a founder and you're trying to decide, should I invest more on processes, or should I invest more in people. The first thing is introspection. What do you believe in, really? What do you believe in, and what do the people around you believe in, and how can you be a coherent leader? And you know what? You can nudge yourself a little bit away from your happy plate, but you're not going to go super far. You're not going to go from like a process-driven meritocratic, X, Y, Z person all the way to like I'm going to start a collectivist company where everything is sort of a consensus decision to do that. You're not going to do that. But I think it starts with self-awareness and then that's how people form their authentic leadership vibe, and then they flex a little bit and then they embrace other perspectives.

**中文翻译:**
假设你是一位创始人，正在纠结是该在流程上投入更多，还是在人才上投入更多。首先要做的是内省。你到底相信什么？你相信什么，你周围的人又相信什么，以及你如何成为一名言行一致（coherent）的领导者？你要知道，你可以稍微让自己离开一点舒适区，但你不会走得太远。你不可能从一个流程驱动、崇尚精英管理（meritocratic）的人，摇身一变去创办一家集体主义公司，让所有事情都靠共识来决定。你做不到那一点。但我认为，这一切始于自我意识，人们由此形成自己真实的领导风格，然后进行微调，并开始接纳其他的观点。

---

### [00:00:49] Lenny

**English:**
Today my guest is John Cutler. John is one of the most prolific, beloved, and longtime writers and sharers of product wisdom online, and as you'll hear at the start of this episode, thanks to his really unique role at Amplitude, he's worked with a large percentage of product teams and product managers around the world. I've learned a lot from John's writings over the years and share his stuff often, and so it was a real honor to chat in depth with John. We chat about what differentiates the highest performing product teams from less well performing product teams, what it takes to create real change within a company, why you should be skeptical of frameworks and tools that you read about online, why all underperforming teams fail in similar ways but high performing teams succeed in many different ways, and so much more.

**中文翻译:**
今天的嘉宾是 John Cutler。John 是网络上最勤奋、最受喜爱且资深的产品智慧分享者之一。正如你在本集开头所听到的，得益于他在 Amplitude 担任的独特角色，他曾与全球很大比例的产品团队和产品经理合作过。多年来，我从 John 的文章中学到了很多，也经常分享他的内容，所以能与他深入交流是我的荣幸。我们聊到了高绩效产品团队与普通团队的区别、在公司内部创造真正变革需要什么、为什么你应该对网上读到的框架和工具保持怀疑、为什么所有表现不佳的团队失败的原因都大同小异，而高绩效团队的成功方式却各不相同，以及更多精彩内容。

---

### [00:05:50] John Cutler (On his role at Amplitude)

**English:**
My official title was product evangelist. I don't think that I super fit that role, but that was the title that we had, and basically my job was to wake up every morning and do things that would overlap Amplitude the product, but then help uplevel our customers, sort of uplevel the broader product community. I call them current customers and future customers. This product transformation's happening all around the world, just means it's a matter of time, eventually they'll become Amplitude customers, so I should just try to make them awesome and try to help them with different expertise. My day-to-day was spent a lot advocating for different ways of working, doing coaching, doing workshops. I had these things called product therapy sessions when I would just wake up in the morning and just kind of soak in whatever problem people were having for the day.

**中文翻译:**
我的正式头衔是“产品布道师”（Product Evangelist）。我不觉得自己完全契合这个角色，但那是我们的头衔。基本上，我的工作就是每天醒来做一些既与 Amplitude 产品相关，又能帮助提升客户水平、提升整个产品社区水平的事情。我把他们称为“现有客户”和“未来客户”。产品转型正在全球范围内发生，这意味着他们最终成为 Amplitude 的客户只是时间问题，所以我应该努力让他们变得更优秀，用不同的专业知识帮助他们。我的日常工作大部分时间都在倡导不同的工作方式、进行教练辅导和举办工作坊。我还有一种叫作“产品诊疗”（Product Therapy）的环节，每天早上醒来，我就去倾听并吸收人们当天遇到的各种问题。

---

### [00:14:26] John Cutler (On leaving and the power of context)

**English:**
One, you are talking to a bunch of different companies, achieving the almost similar results in very, very different ways. They behave in different ways, the context in the pandemic or the economy. You would see the pandemic kick in and then you would talk to 50 companies that were dealing with the ramifications of it. The power of context. The regional differences were so fascinating. I was on with a team that was based in India and just the passion and curiosity. There was not one jaded person in the room. There was not one person like, "Been there, done that. When's the performance review cycle ending?" or anything like that. It was just all-out passion and hunger for information.

**中文翻译:**
第一点，你会发现不同的公司在以截然不同的方式取得几乎相似的结果。受疫情或经济环境的影响，他们的行为模式各不相同。你会看到疫情爆发，然后与 50 家正在处理其后果的公司交流。这就是“背景”（Context）的力量。地域差异也非常迷人。我曾与一个印度团队交流，那里充满了激情和好奇心。房间里没有一个愤世嫉俗的人，没有一个人会说“我早就见过了，绩效考核什么时候结束？”之类的话。全是满腔的热情和对知识的渴望。

---

### [00:19:38] John Cutler (On "A Beautiful Mess" and complexity)

**English:**
I think that the first thing that I did was four years ago, I kind of scanned the product advice landscape and I noticed three things. First, there's sort of three perspectives that pervaded... success is tools, skills, mindset. The second... it was grounded in this idea of meritocracy. Success is primarily about merit, very highly individualistic. And then I think the third thing I realized was that it was very often very context free. I thought about the angle, about wanted to explore three things. I think the first one is this idea we do work in these complex adaptive systems. We work in environments. There's lots of things that are interdependent on each other. We don't work in closed systems. The systems are non-linear. The bird flapping its wings in Brazil creates the tornado type of stuff.

**中文翻译:**
四年前我审视了产品建议的现状，发现了三个普遍存在的观点：第一，认为成功取决于工具、技能和心态；第二，根植于精英管理（meritocracy）的理念，认为成功主要靠个人功劳，非常强调个人主义；第三，这些建议通常是脱离背景（context-free）的。于是我思考了自己的切入点，想要探索三件事。第一点就是：我们是在“复杂自适应系统”（Complex Adaptive Systems）中工作的。我们工作的环境中有许多相互依赖的因素。我们不是在封闭系统中工作。这些系统是非线性的，就像巴西的一只蝴蝶扇动翅膀会在其他地方引起龙卷风那样。

---

### [00:25:09] John Cutler (On counterintuitive dynamics)

**English:**
I'm obsessed with this idea of high work in progress (WIP), from a human level and a team level. How even though we know that if you try to do less at once, you'll be more effective, teams routinely just load themself up with work? And so, in the newsletter, I wanted to explore stuff like that, like why, when a bunch of people know irrationally that you should not load yourself up with work, why do really, really smart, capable, intelligent, passionate people in their personal lives and on their teams just load themself up with work? What are they optimizing about?

**中文翻译:**
我非常痴迷于“高在制品”（High WIP，即同时进行的工作过多）这个概念，无论是在个人层面还是团队层面。尽管我们知道如果一次少做点事效率会更高，但团队还是会习惯性地给自己塞满工作。所以在我的时事通讯中，我想探索这类问题：为什么当一群人理智上知道不该超负荷工作时，那些在个人生活和团队中都非常聪明、能干、有才华且充满激情的人，还是会把工作堆满？他们到底在优化什么指标？