# John Mark Nickels - 双语对照

以下是 Lenny's Podcast 与嘉宾 John Mark Nickels (J.M. Nickels) 对谈全集的英汉双语对照文档。

---

### [00:00:00] [John Mark Nickels]

**English:**
Get clear on your objective function, and one way that I've gotten clear on it is trying to think about it from future me because five years from now, I'm not going to give a [shit] if I made the presentation slightly better, but I'm going to care a lot about what kind of relationship I have with my daughters, and that means that the next action, the next thing I do today and tomorrow, those will translate into the relationship with her, right? Not to be morbid, but just again, most of us just aren't really tuned into an awareness that our lives will come to an end. We try to pretend like we're going to live forever and just not think about it. And the horror of it is that we succeed, right? We mostly manage to just go live our life and eat ice cream and go to work and go on vacation and do what we do. To me, an awareness and mindfulness that our lives will come to an end punctuates reality in a way that requires me to rethink my priorities.

**中文翻译:**
搞清楚你的“目标函数”（objective function），我理清它的一个方法是试着从“未来的我”的角度去思考。因为五年后，我根本不会在乎当年的那份演示文稿是否做得更完美了一点，但我会非常在意我和女儿们的关系。这意味着我今天和明天采取的每一个行动、做的每一件事，都会转化为与她的关系，对吧？不是要表现得太消极，但事实是，我们大多数人并没有真正意识到生命终将结束。我们试着假装自己会长生不老，尽量不去想这件事。而可怕的是，我们竟然“成功”地做到了这一点，对吧？我们大多时候只是在过日子、吃冰淇淋、上班、度假，做着该做的事。对我来说，意识到并觉察到生命是有终点的，这会以一种强有力的方式突显现实，迫使我重新审视自己的优先级。

---

### [00:00:56] [Lenny Rachitsky]

**English:**
Today my guest is J.M. Nickels. J.M. has been a product leader at Waymo, DoorDash and Uber. He's also an engineering manager at Groupon, and before that an equity trader at Getco. At Uber, he built and launched the very first version of Uber Pool and then went on to lead the team responsible for the infrastructure and algorithms powering the economic and logistics brain behind Uber's matching and pricing systems. At DoorDash, he was head of product for DoorDash platform. At Waymo, he led product for the commercialization of autonomous ride hailing and last mile delivery. And he recently returned to Uber to lead product for the mobility team.
(00:01:30):
This conversation is a unique and beautiful mixture of hard skills, soft skills, tactics, and emotions. I won't give away too much about the conversation, but this is a powerful one. Tears are shed, stories are shared, and I'm confident you'll become a better leader and human having listened to J.M.'s insights and lessons. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. With that, I bring you J.M. Nickels.
(00:02:05):
J.M., thank you so much for being here. Welcome to the podcast.

**中文翻译:**
今天的嘉宾是 J.M. Nickels。J.M. 曾在 Waymo、DoorDash 和 Uber 担任产品负责人。他还曾是 Groupon 的工程经理，在此之前是 Getco 的股票交易员。在 Uber，他开发并发布了最初版本的 Uber Pool，随后领导团队负责基础设施和算法，这些构成了 Uber 匹配和定价系统背后的经济与物流大脑。在 DoorDash，他曾担任平台产品负责人。在 Waymo，他领导了自动驾驶网约车和最后一公里配送商业化的产品工作。最近，他回到了 Uber，领导移动业务团队的产品工作。
(00:01:30):
这次对话是硬技能、软技能、策略和情感的独特而美妙的结合。我不会透露太多细节，但这是一次非常有力量的谈话。有泪水，有故事，我相信在听完 J.M. 的见解和教训后，你会成为一个更好的领导者和更好的人。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对播客有很大帮助。现在，让我们欢迎 J.M. Nickels。
(00:02:05):
J.M.，非常感谢你能来。欢迎来到播客。

---

### [00:02:08] [John Mark Nickels]

**English:**
Thank you, Lenny. Thanks for having me. I'm thrilled to be here. Really appreciate your dedication to helping product managers improve their craft and up-level. We've done a lot of great researches out there for that, and coaching and development, as I'm sure we'll get into, is a passion of mine as well, so we have a lot of shared interests there.

**中文翻译:**
谢谢你，Lenny。感谢邀请我。我很高兴能来到这里。非常感谢你致力于帮助产品经理提升技能和进阶。我们为此做了很多研究，而教练辅导和人才培养（正如我确信我们稍后会谈到的）也是我的热情所在，所以我们有很多共同兴趣。

---

### [00:02:26] [Lenny Rachitsky]

**English:**
Oh, I really appreciate that. I want to start with a phrase that came up again and again when I ask people what to talk to you about from your colleagues, and this phrase is conscious leadership. What is conscious leadership? What does this phrase mean?

**中文翻译:**
噢，非常感谢。我想从一个词开始，当我询问你的同事该和你聊些什么时，这个词反复出现，那就是“意识领导力”（conscious leadership）。什么是意识领导力？这个词是什么意思？

---

### [00:02:42] [John Mark Nickels]

**English:**
To me, leadership is broadly defined as having influence in the world, and so by that definition, to me, everyone is a leader because we all have influence in some way. It's not about whether you're a manager or not, it's like I have influence on my kids or my partner or my community, or the world, the way I vote, the way I show up. So we all have influence. We're all co-creating influences of each other. So that's the leadership piece. The conscious piece then is becoming more aware, waking up. To me, it's like learning more about my interior world, what my background is, my biases. We all inherit certain belief systems from our parents or our church or our community, and a lot of times they kind of go unquestioned and then they end up in conflict. And so it's really just about becoming more aware and then taking responsibility for the influence that I have. So yeah, taking responsibility for my influence in the world.

**中文翻译:**
对我来说，领导力的广义定义是在世界上产生影响力。按照这个定义，我认为每个人都是领导者，因为我们都在以某种方式产生影响。这与你是否是经理无关，比如我对我的孩子、伴侣、社区或世界都有影响，包括我投票的方式、我表现出的样子。所以我们都有影响力，我们都在共同创造彼此的影响。这就是“领导力”的部分。而“意识”的部分则是变得更加觉知，即“醒悟”。对我来说，这就像是更多地了解我的内心世界、我的背景和我的偏见。我们都从父母、教会或社区继承了某些信仰体系，很多时候这些东西从未被质疑，最后导致了冲突。所以，这其实就是变得更加觉知，然后为我所拥有的影响力负责。没错，就是为我在世界上的影响力负责。

---

### [00:03:42] [Lenny Rachitsky]

**English:**
As you talk about this, something that came up and something that I thought about as I was preparing for this episode is this idea of soft leadership, the power of soft skills and just how important that is in success. Is there something there that comes up when I say that? Just the power of soft skills and the importance of those in being successful.

**中文翻译:**
当你谈到这些时，我在准备这期节目时想到了一件事，那就是“软性领导力”的概念，即软技能的力量，以及它对成功有多么重要。当我提到这一点时，你有什么想法吗？关于软技能的力量及其在成功中的重要性。

---

### [00:03:59] [John Mark Nickels]

**English:**
Yeah, it's, what was it? Theodore Roosevelt, speak softly and carry a big stick? Yeah, I think I've evolved in that department. I think when I was younger in my career, I thought it was really important that we got to show up to the meeting and have the right slides and be the loudest, rightest voice in the room, and that's the way to have influence. And there's certainly a place for having leadership in a meeting and presenting a point of view and helping guide the narrative, but to me, yeah, I would say I've evolved more towards sitting back. It's also as I've become a more senior leader, I'm aware that there are power dynamics there. There's imbalances where junior folks don't feel as comfortable speaking up or I say something's not a good idea and then, "Well, I don't want to disagree with J.M."
(00:04:45):
So it's like, back to being more aware of my influence in the world. I really try to spend more time being mindful of that and say, I want to hear from other people first. I want to create space and I don't need to win the argument in the meeting. There can be a follow-up. It's not like this is my last chance to say something, but that's also more true when you're more senior because when you're more junior, it's like, well, this is the one presentation I have with Dara for the next six months. I really got to nail it. And so the pressure is a little bit different. Yeah.

**中文翻译:**
是的，那是谁说的？西奥多·罗斯福，“温言在口，大棒在手”（speak softly and carry a big stick）？我想我在这一块已经进化了。在我职业生涯早期，我认为在会议上表现出色、拥有完美的幻灯片、成为房间里声音最大且最正确的人是非常重要的，认为那是产生影响力的方式。当然，在会议中展现领导力、陈述观点并引导叙事是有其地位的，但对我来说，是的，我更多地转向了“退后一步”。随着我成为更资深的领导者，我意识到其中存在权力动态。存在不平衡，初级员工可能觉得发言不太自在，或者我说某个主意不好，他们会想：“好吧，我不想反驳 J.M.。”
(00:04:45):
所以，这又回到了对自己影响力的觉知。我真的试着花更多时间去留意这一点，并说：我想先听听别人的意见。我想创造空间，我不需要在会议上赢得争论。之后还可以跟进，这又不是我最后一次发言的机会。当然，当你职位更高时这更容易做到，因为当你更初级时，你会觉得：“这是我未来六个月里唯一一次向 Dara（Uber CEO）汇报的机会，我必须搞定它。”所以压力是不同的。

---

### [00:05:14] [Lenny Rachitsky] (Sponsor: Pendo)

**English:**
This episode is brought to you by Pendo, the only all-in-one product experience platform for any type of application... [Ad content omitted for brevity in translation but kept in English as per instructions] ...Visit pendo.io/lenny to create your free Pendo account today and start building better experiences across every corner of your product.

**中文翻译:**
本期节目由 Pendo 赞助，这是唯一一款适用于任何类型应用程序的全方位产品体验平台……[广告内容：Pendo 集成了产品分析、应用内指南、用户反馈和会话重放功能。]……请访问 pendo.io/lenny 立即创建您的免费 Pendo 账户，开始在产品的每个角落构建更好的体验。

---

### [00:06:39] [Lenny Rachitsky] (Sponsor: Enterprise Ready Conference)

**English:**
This episode is brought to you by the Enterprise Ready Conference, a one-day event in San Francisco... [Ad content omitted for brevity] ...Make sure to request an invite at enterpriseready.com. That's enterpriseready.com.

**中文翻译:**
本期节目由 Enterprise Ready 大会赞助，这是在旧金山举行的为期一天的活动，汇集了塑造企业级 SaaS 未来的产品和工程领导者……请务必在 enterpriseready.com 申请邀请。

---

### [00:07:35] [Lenny Rachitsky]

**English:**
There's a couple of threads I want to follow here, but first, I was thinking as you're talking, when people think Uber and people that work at Uber, I don't think they imagine people like you. And I know you were there early and then you joined again. Was that ever like a, "Is this a place for me?" Did you ever go through that struggle or is it just, yeah, I don't know?

**中文翻译:**
我想顺着几个思路聊聊，但首先，当你说话时我在想，当人们想到 Uber 以及在 Uber 工作的人时，我觉得他们想象不到像你这样的人。我知道你很早就加入了，后来又重新加入。你有没有产生过“这里适合我吗？”这样的想法？你经历过这种挣扎吗，还是说，我也不确定？

---

### [00:07:55] [John Mark Nickels]

**English:**
Yeah, yeah, I mean, I would say I have been fortunate to experience probably three Ubers at this point. We joke about Uber 1.0, the Travis era, and you hear a lot about in the media the kind of bad parts of that, but there were some really good parts too. I mean, I think there was a lot of... Like when I joined in 2014, there was this mission of making transportation as reliable as running water for anyone anywhere, which is bold, audacious, and maybe a little bit pretentious from a little bit of Silicon Valley edge, but you could feel the electricity in the air. There was this energy and excitement like we're doing something transformational, autonomy is coming, car ownership will change. And it just like, feel, like my vibration.
(00:08:37):
And then, yeah, the good parts of that era were, Travis was a very great visionary product leader, and we started ATG and Elevate and these future-forward things and the way he would conduct product reviews, I learned a lot. It was stressful at the time, but looking back, I was like, wow, I learned a lot. But yeah, I would say it was not a very conscious leadership sort of place. You're right, it was like many organizations that run on fear because you can do that, carrots and sticks do work. But actually that's kind of how I found this work is it was in 2015 and I was a very junior product manager at that point, in over my head in a fast-growing place. And in these weekly reviews with Travis as we were building out Uber Pool, and I had a six-month-old daughter, my firstborn, and we had just moved to San Francisco from Chicago. So my whole life was in flux and it was a very stressful place, and I was like, "I think I'm going to snap. I don't think I can handle this."
(00:09:31):
And that's kind of what led me to start to explore this sort of inner work and meditation and sort of finding a way out of that. And that's what got me interested in bringing it to teams too, is because I remember I was in one meeting where we were working on this future pricing thing, which is rider pricing, driver pricing, incentives, and how we bring surge pricing and all that together. And it gets very, I'll go heavy, and we have all these PhDs in the room, some of the best minds in the world. We were able to hire people like Garrett van Ryzin, who was the foremost [inaudible 00:10:04] more person from Columbia and other people.
(00:10:06):
But everyone's back to lizard brain, everyone's arguing. They're like, "Well, no, I think we should do it this way. We should do it this way." And I was like, huh. As much as I enjoy the content of this, believe me, I'm an algo PM end to end, I love that stuff. But I was like, I don't think this conversation actually needs another PhD, or I'm not even PhD, but content expert. It's like what we need here is a way to shift again, back out of that fear, threat, righteousness sort of state into a more co-creative, collaborative, open-minded, curious, trusting sort of space. And that got me interested in pursuing more skills in coaching of individuals and teams.
(00:10:49):
But yeah, to your Uber question, yeah, the Uber 1.0 was crazy. Uber 2.0 was kind of like, Travis is out, the board is feuding, is leaking to Mike Isaac, whatever. And then Dara comes in and the peacemaker and then tries to stabilize, but the IPO is rocky. And so now I would say we're in Uber 3.0, which it's full pirate ship to navy, in Reid Hoffman's words, a profitable company. We're printing free cashflow, we're in the S&P 500, we've established the independent contractor model in a lot of states and jurisdictions, and it's like there's less risk of that model changing.
(00:11:28):
And yeah, I would say we're in an era now of Cambrian explosion of different types of transportation. The company really just built the UberX model and scaled it out to the world. That's primarily how we got here. And now it's like we're going out for all these different new sort of modalities, whether it's reserving a ride in advance or shared rides or renting a car or buses, and then different supply types too. It's not just contracted, we have a lot of fleets in the platform, we now have a lot of taxi drivers in the platform. You've seen we've signed deals with Waymo and Cruise and other autonomist players. So I feel like we're now at the beginning of another era of Uber and transportation, that the next decade or two, it's going to be super exciting.

**中文翻译:**
是的，我想说我很幸运，到目前为止经历了大概三个阶段的 Uber。我们开玩笑说 Uber 1.0 是 Travis 时代，你在媒体上听到了很多关于那个时代的负面消息，但也有一些非常好的部分。我是说，当时有很多……比如我在 2014 年加入时，公司的使命是“让交通像自来水一样可靠，随时随地服务于任何人”，这很大胆、无畏，甚至带点硅谷式的狂妄，但你能感觉到空气中弥漫着电流。那种能量和兴奋感，就像我们正在做一些变革性的事情：自动驾驶即将到来，汽车所有权将发生变化。这非常符合我的共鸣。
(00:08:37):
然后，那个时代的优点是，Travis 是一位非常有远见的产品领导者，我们启动了 ATG（自动驾驶事业群）、Elevate（飞行汽车）等前瞻性项目。他主持产品评审的方式让我学到了很多。当时压力很大，但回过头来看，我觉得：哇，我学到了太多。但是，我也要说，那不是一个非常有“意识领导力”的地方。你说得对，它像许多靠恐惧驱动的组织一样，因为恐惧确实有效，胡萝卜加大棒是管用的。但实际上，这正是我发现这项工作（意识领导力）的原因。那是 2015 年，当时我还是一个非常初级的产品经理，在一个快速发展的公司里感到力不从心。在与 Travis 进行的关于 Uber Pool 的每周评审中，我当时有一个六个月大的女儿（我的大孩子），我们刚从芝加哥搬到旧金山。我整个生活都在变动中，压力巨大，我觉得自己快要崩溃了，无法承受。
(00:09:31):
这促使我开始探索内心修行、冥想，寻找解脱之道。这也让我对把这些带入团队产生了兴趣。我记得有一次会议，我们在讨论未来的定价系统，涉及乘客定价、司机定价、激励措施，以及如何将动态调价（surge pricing）整合在一起。这非常硬核，房间里全是博士，世界上最聪明的大脑。我们聘请了像 Garrett van Ryzin 这样的人，他是哥伦比亚大学最顶尖的专家。
(00:10:06):
但每个人都回到了“蜥蜴脑”（lizard brain，指原始的恐惧/防御反应）状态，每个人都在争论。他们说：“不，我觉得应该这样做。”我当时想，虽然我很喜欢这些内容（相信我，我是个彻头彻尾的算法 PM），但我认为这场对话不需要更多的博士或专家了。我们需要的是一种方式，再次从那种恐惧、威胁、自以为是的平衡状态，转向一个更具共同创造性、协作性、开放、好奇和信任的空间。这让我开始追求更多个人和团队教练的技能。
(00:10:49):
回到你关于 Uber 的问题，Uber 1.0 很疯狂。Uber 2.0 像是 Travis 离职，董事会内斗，消息泄露给 Mike Isaac（《超级膨胀》作者）等等。然后 Dara 来了，作为和事佬试图稳定局面，但 IPO 过程很坎坷。现在，我会说我们处于 Uber 3.0，用 Reid Hoffman 的话说是“从海盗船变成了正规海军”，一家盈利的公司。我们产生自由现金流，进入了标普 500 指数，在许多州和司法管辖区确立了独立承包商模式，这种模式改变的风险降低了。
(00:11:28):
而且，我认为我们现在正处于不同交通方式的“寒武纪大爆发”时代。公司最初只是建立了 UberX 模型并将其推广到全球，这是我们成功的基石。而现在，我们正在尝试各种新形态，无论是预订行程、拼车、租车还是巴士，还有不同的供应类型。不仅是合同工，平台上有大量车队，还有很多出租车司机。你也看到我们与 Waymo、Cruise 等自动驾驶公司签署了协议。我觉得我们正处于 Uber 和交通行业另一个时代的开端，未来一二十年将非常令人兴奋。

---

### [00:12:12] [Lenny Rachitsky]

**English:**
One quick tangent, UberX, a previous guest shared that the name UberX came from... it was just like the internal code name, UberX, we'll figure out a real name later, and then it stuck and no one had a better name. Is that true?

**中文翻译:**
插一个小话题，之前的一位嘉宾分享说 UberX 这个名字来源于……它最初只是个内部代号，叫 UberX，想着以后再起个正式名字，结果就这么沿用下来了，因为没人能想到更好的名字。是真的吗？

---

### [00:12:23] [John Mark Nickels]

**English:**
Yeah, that's right. I think that's right.

**中文翻译:**
是的，没错。我想是这样的。

---

### [00:12:24] [Lenny Rachitsky]

**English:**
Amazing.

**中文翻译:**
太神奇了。

---

### [00:12:26] [John Mark Nickels]

**English:**
When I joined, we were already scaling UberX rapidly. I joined in early 2014. That's amazing. But I did help name Uber Pool, Uber Pool, which I selflessly like to bring back. It got renamed to Share during my external APM rotation.

**中文翻译:**
我加入时，UberX 已经在快速扩张了。我是 2014 年初加入的。不过我确实参与了 Uber Pool 的命名，我挺喜欢这个名字的。在我去外面做 APM 轮岗期间，它被改名成了 Share。

---

### [00:12:42] [Lenny Rachitsky]

**English:**
Okay. I want to come back to the thread that I pushed us off of, which is you talked about, you made this really interesting point about emotions, and this is something I've been learning myself recently with having a kid and also a couple of previous guests. So you say that when you have... so you're in this meeting, you're stressed, there's a lizard brain kicking in. Something's like, "Oh, Dara's going to think I suck and it's going to really screw my career if I mess up this presentation." Your advice there is very counterintuitive, I think for a lot of people, which is accept that emotion. Because when I feel stressed and nervous in a meeting, I'm not, "Embrace the nervousness, let it out." It's more I'm just like, "No, it's fine. Going to be okay. Don't worry about it." Talk about why that is actually more effective.

**中文翻译:**
好。我想回到刚才被打断的话题，你谈到了关于情绪的一个非常有趣的观点，这也是我最近在有了孩子以及和几位嘉宾交流后一直在学习的东西。你说当你处于……比如你在会议中，压力很大，蜥蜴脑开始起作用。你会想：“噢，Dara 会觉得我很差劲，如果我搞砸了这次演示，我的职业生涯就完了。”你的建议对很多人来说是非常反直觉的，那就是：接受这种情绪。因为当我在会议中感到压力和紧张时，我不会想“拥抱紧张，释放它”，我更多是想“不，没事，会好起来的，别担心”。谈谈为什么接受情绪反而更有效。

---

### [00:13:28] [John Mark Nickels]

**English:**
Yeah, yeah. It's like my daughter the other day had some nightmares and she was like, "Dad, how do I stop thinking thoughts about the nightmare or whatever?" And I said, "You can't. Don't try to stop the thought. Just allow it. Let me show you why that doesn't work." I said, "Don't think of a pink elephant. What did you just think of?" And she's like, "A pink elephant." And then now she thinks it's hilarious and she tells her sister, "Don't think of a pink elephant."
(00:13:55):
But yeah, I think you're right. It is a little counterintuitive, but one of my first coaches actually had a great phrase, what you resist will persist and what you fear will appear. And so in my experience, this is another reason why becoming more aware of my internal world has been so important. I have more agency than I realized on the outcome of my experience. And so when I think a thought like, Dara might think I suck and then I have a thought that I suck, that can become a self-enforcing negative feedback loop where I have a thought that creates stress, anxiety, fear, and then that triggers more thoughts and we call it cognitive emotive loop where you're kind of in this cycle of thinking stressful thoughts and then having unpleasant, anxious, fearful feelings. And so one way to break that is to just allow it and not try to fight it with other thoughts.

**中文翻译:**
是的。就像我女儿前几天做了噩梦，她问：“爸爸，我怎么才能停止去想噩梦里的事？”我说：“你做不到。不要试图停止那个念头，只要允许它存在。让我告诉你为什么压抑没用。”我说：“不要去想一只粉色的大象。你刚才想到什么了？”她说：“一只粉色的大象。”现在她觉得这很好笑，还跑去告诉她妹妹：“不要想粉色的大象。”
(00:13:55):
你说得对，这确实有点反直觉。但我的一位早期教练曾说过一句名言：“你所抗拒的，将会持续；你所恐惧的，将会出现。”在我的经验中，这也是为什么觉察内心世界如此重要的原因。我对自己体验的结果拥有比想象中更大的主导权。当我产生“Dara 可能觉得我很差”的念头，接着又产生“我真的很差”的念头时，这会变成一个自我强化的负面反馈循环：一个念头产生压力、焦虑和恐惧，进而触发更多念头。我们称之为“认知-情绪循环”，你陷入了思考压力念头和产生不愉快、焦虑、恐惧感受的死循环。打破它的一个方法就是允许它存在，而不是试图用其他念头去对抗它。

---

### [00:14:50] [Lenny Rachitsky]

**English:**
So the advice is very tactically, so you're in a meeting with Dara, you're stressed about something. Just allow it, let it be. Don't try to pretend like it's not there or don't try to convince yourself-

**中文翻译:**
所以战术上的建议是，如果你在和 Dara 开会，你对某事感到压力，就允许它存在，顺其自然。不要试图假装它不存在，或者试图说服自己——

---

### [00:15:00] [John Mark Nickels]

**English:**
Well, that would be the first step, is just to allow whatever's here, thoughts and emotions are rising. They come, they go, they're transient. It's not permanent. There's a lot of wisdom I think in the Buddhist lineage around those concepts. And then the next piece for me, once I can take a breath and relax a little bit, is coming home to the fact that I... and this is a little more radical for some people, I don't actually need Dara to approve of me in my presentation in order to be okay. What I'm up to over here is trying to force self-worth and self-love from within. And so we talk about approval, control and security. It's very easy to look for that from the world. Do you approve of me? And if not, can I control outcomes to get approval or get security and get the job, the bank account, the house, whatever it is?
(00:15:52):
But what I kind of woke up to at one point was that as long as I was going out there looking for all that stuff to try to complete something inside of me that was missing, it's like I was a hungry ghost. It's like, it doesn't matter how many Michelin star meals and promotions and money and title and whatever. It's like it's never enough. It's like you kind of enjoy it for a little bit and then you get back to like, hm, you know? So it's like a never ending sugar addiction. And so that's the next step for me is allow it. Yes, allow the emotion, allow the thought. Come home to, "I am okay even Dara does think I suck." And then also it's not permanent, right? It's like sure, there might be some high stakes things in life where you only get one shot, but for the most part it's like if I didn't do a great job on this presentation, there'll be another one. It's okay.
(00:16:45):
And think of it as practice. The other thing is from the fear threat state, I'm like, uh-oh, this is a risk, alarm bells, my career could be over. Whereas if I'm in that trusting, curious, open space, it's like this is an opportunity for feedback. How can I learn? How can I get to become a better presenter? It's like the feedback from others is no longer a threat. It's actually a gift. It's like information that I can use or not use to alter how I show up in the future and the skills I develop and all that good stuff.

**中文翻译:**
第一步就是允许当下发生的一切，念头和情绪在升起。它们来来去去，是瞬时的，不是永恒的。我认为佛教传统中有很多关于这些概念的智慧。接下来的部分，一旦我能深呼吸并放松一点，就是回到这样一个事实：这对某些人来说可能有点激进——我其实并不需要 Dara 在演示中认可我，我才能过得好。我在这里要做的是从内在激发自我价值和自爱。我们常谈论认可、控制和安全感。向外界寻求这些很容易：你认可我吗？如果不认可，我能否控制结果来获得认可或安全感，获得工作、银行存款、房子等等？
(00:15:52):
但我后来意识到，只要我还在外面寻找这些东西来填补内心的缺失，我就像一个“饿鬼”。无论有多少顿米其林大餐、多少次晋升、多少金钱和头衔，永远都不够。你可能会享受一小会儿，然后又回到那种空虚感。这就像永无止境的糖瘾。所以我的下一步是：允许它。是的，允许情绪，允许念头。回到“即使 Dara 觉得我很差，我也没问题”的状态。而且，这不是永久的，对吧？虽然生活中确实有一些只有一次机会的高风险时刻，但大多数情况下，如果这次演示没做好，还会有下一次。没关系的。
(00:16:45):
把它看作练习。另一件事是，在恐惧威胁的状态下，我会觉得：“糟糕，这是风险，警报响了，我的职业生涯要完了。”但如果我处于那种信任、好奇、开放的空间，我会觉得：“这是一个获得反馈的机会。我能学到什么？我怎样才能成为更好的演讲者？”别人的反馈不再是威胁，而是一份礼物。它是我可以用来（或不用来）改变未来表现、提升技能的信息。

---

### [00:17:21] [Lenny Rachitsky]

**English:**
I imagine some people may hear this and feel like if Dara or Travis or whoever thinks I suck, my career is at stake and that really matters and everything's going to fall apart in my life because I get fired, there's stakes involved with messing up. Is there anything that helps you get past that and not worry so much about just this trickle effect of all the things that could go wrong if you mess something up in an important high stakes meeting or presentation?

**中文翻译:**
我想有些人听到这些可能会觉得，如果 Dara 或 Travis 觉得我很差，我的职业生涯就岌岌可危了，这真的很重要，如果我被解雇，我生活中的一切都会崩塌，搞砸是有代价的。有什么方法能帮你克服这种想法，不再那么担心如果搞砸了一次重要的高风险会议或演示，会产生一系列连锁反应吗？

---

### [00:17:46] [John Mark Nickels]

**English:**
Yeah. Again, and maybe it is a little paradoxical, but what I found was the more I focused on how I show up and optics and having a good deck and all this, the less I got promoted and then the more I dropped focusing all that. Because for my first few years of Uber, I was a senior PM and then I finally got my groove and started kind of moving through the product ladder. And it was really correlated to me at least, maybe causal, with dropping a lot of the focus on the presentation and how I show up and whether people like this or not, and just really focusing on the work. It's like, you know what? I am here to be a conduit from what wants to happen in the world of transportation and mobility and shared rides is one that I've always been particularly passionate about, so that's a good example, and then how can I get present and listen to what wants to happen next in the world of shared rides? And there's lots of different ways we can take the product and all that.
(00:18:45):
And it's really about, I want to make a fucking awesome product, right? And it's like, whether people like me or think I'm a good PM or presenter, as long as I manifest a great product into the world that makes riders better off, drivers better off, cities better off, less congestion, all these things, that to me is the reward. And sure, in order to manifest that, it is often helpful to communicate things, present, align, all those sort of things. But those are a means to a more powerful and transformative end than just my career. I'm tapping into a larger purpose and sense of belonging and identity and sort of meaning. And from that place, it's like I've just dropped the kind of egoic, self-centered focus on whether I did good in the presentation or not. And then yeah, maybe paradoxically, by doing that, it actually goes better and we do great work and it gets recognized.

**中文翻译:**
是的。这可能有点矛盾，但我发现，我越是关注自己的表现、外在形象（optics）以及幻灯片是否精美，我获得晋升的机会反而越少；而当我放下这些关注时，情况反而好转了。在 Uber 的前几年，我一直是高级 PM，后来我终于找到了节奏，开始在产品职级上晋升。对我来说，这至少是相关的，甚至可能是因果关系——即放下对演示、个人形象以及别人是否喜欢我的过度关注，转而真正专注于工作。就像是，你知道吗？我来到这里是为了成为交通和移动领域变革的管道，拼车（shared rides）一直是我特别热衷的领域，这就是个好例子。我如何能活在当下，倾听拼车领域下一步想要发生什么？我们可以通过很多不同的方式来打造产品。
(00:18:45):
核心在于，我想做一个超级牛的产品，对吧？无论人们是否喜欢我，或者是否认为我是一个优秀的 PM 或演讲者，只要我能把一个伟大的产品带到世界上，让乘客受益、司机受益、城市受益、减少拥堵，这些对我来说就是回报。当然，为了实现这一点，沟通、演示、达成共识通常是有帮助的。但这些只是实现一个比我个人职业生涯更强大、更具变革性的目标的手段。我正在接入一个更大的目标感、归属感、身份感和意义感。从那个高度出发，我就放下了那种以自我为中心的、纠结于演示好坏的念头。然后，也许矛盾的是，这样做反而让演示效果更好，工作更出色，并得到了认可。

---

### [00:19:41] [Lenny Rachitsky]

**English:**
Wow, that is fascinating. To make that work, you need to really connect with the mission of the company you're working at. You really need to believe this is very important and very meaningful. So maybe that could be an issue for people if they don't really care about what the company's doing, it's going to be hard to allow for that approach.

**中文翻译:**
哇，这太引人入胜了。要做到这一点，你需要真正认同你所在公司的使命。你真的需要相信这是非常重要且有意义的。所以对于那些并不真正关心公司在做什么的人来说，这可能是一个问题，很难采用这种方法。

---

### [00:19:58] [John Mark Nickels]

**English:**
Totally, totally.

**中文翻译:**
完全正确。

---

### [00:20:00] [Lenny Rachitsky]

**English:**
It's interesting that you say that optics aren't as important. I think the reason I think about this as you talk about, a lot of people feel like there's the work and then there's talking about the work, making the work, the optics of what you did is really, really important. And I love to hear. Nobody wants to do that, but they always get this advice. So important, optics, how you share the impact you've done, how you represent yourself. I guess, is there anything else you can share there about just helping people relax about that aspect of their job and without being so critical?

**中文翻译:**
你说“外在形象”（optics）没那么重要，这很有趣。我想我之所以思考这个问题，是因为很多人觉得，工作是一回事，谈论工作、展示工作、塑造工作的外在形象又是另一回事，而且后者非常重要。我很高兴听到你这么说。没人想做表面功夫，但他们总是得到这样的建议：外在形象很重要，如何分享你的影响力，如何展示自己。关于如何让人们在这一方面放松心态，而不过于苛求，你还有什么可以分享的吗？

---

### [00:20:31] [John Mark Nickels]

**English:**
Yeah. And to be clear, I do think it's important. It can't be all work and no optics or all optics and no work. There does need to be a balance there, and I think it does change depending on the size of the company and the level of seniority. When you're an IC (Individual Contributor), you're probably hopefully doing more actual work, and leaders are supporting them and presenting and communicating that work so that they get.
(00:20:56):
I mean, the optics does matter, right? At some senior level, you do spend more time on that, and it does have influence, back to the influence piece, which is like, how will I communicate an idea and the need for engineering resourcing and so forth might mean that team gets more engineers or doesn't get more engineers, or we do this project or we don't, right? Because at the end of the day, executive resource allocation is largely based on the, quote-unquote, "optics layer". So it does matter. I want to be clear. I'm not saying it doesn't matter, but to me, again, it's more about that's a means to an end. It's not about the optics itself. It's like say what the Buddha is saying, don't mistake the finger pointing at the moon for the moon. And the finger pointing at the moon could be the presentation, the OKR, you know, whatever. And it's like, that's not the actual outcome we care about. That's an input to the output that really matters, which is the work, the product.

**中文翻译:**
是的。我要澄清一下，我确实认为它很重要。不能只有工作没有展示，也不能只有展示没有工作。这需要平衡，而且我认为这取决于公司的规模和资历。当你是一名 IC（个人贡献者）时，你可能更多地在做实际工作，而领导者则支持他们，展示并沟通这些工作。
(00:20:56):
我的意思是，外在形象确实重要，对吧？在某些高级职位上，你确实会花更多时间在这上面，这会产生影响力。回到影响力的部分：我如何沟通一个想法以及对工程资源的需求，这可能意味着团队能否获得更多工程师，或者我们是否启动这个项目。因为归根结底，高层的资源分配很大程度上是基于所谓的“展示层”。所以它确实重要。我想明确一点，我不是说它不重要，但对我来说，它更多是达到目的的手段，而不是目的本身。就像佛家说的，不要把指向月亮的手指误认为是月亮。手指可能是演示文稿、OKR 等等，但那不是我们真正关心的结果。那只是对真正重要的产出（即工作和产品）的一种投入。

---

### [00:21:47] [Lenny Rachitsky]

**English:**
Okay. I'm going to shift this to hard skills and another kind of direction. So another thing that came up a bunch when I was asking people what you're amazing at and what you're really good at is strategy and vision. I had this quote from one of your colleagues, Brent Goldman, "J.M. thinks big, has lots of great ideas, will 'yes, and' to other people's ideas, will inspire everyone around him to be more creative, ambitious, and hardworking. He doesn't climb hills, he finds bigger mountains and will bring you there." So along these lines, say someone comes to you and wants to build these skills, wants to get better at strategy, wants to get better at vision, which is something basically every product leader is trying to get better at and every leader wants to get better at, what advice do you generally share? How does one improve in these areas?

**中文翻译:**
好。我想把话题转向硬技能和另一个方向。当我询问别人你擅长什么时，反复出现的一个词是“战略”和“愿景”。我这里有一段你同事 Brent Goldman 的评价：“J.M. 思考宏大，有很多好主意，会用‘是的，而且’（yes, and）来回应别人的想法，会激励身边的每个人变得更有创意、更有抱负、更努力。他不只是爬小山丘，他会找到更大的山脉并带你登顶。”沿着这个思路，如果有人来找你，想培养这些技能，想在战略和愿景方面做得更好（这是每个产品领导者和每个领导者都想提升的），你通常会给什么建议？一个人如何在这方面提高？

---

### [00:22:35] [John Mark Nickels]

**English:**
Yeah, thank you. I appreciate the compliment. Thank you, Brent. That is a great quote. Wow. Yeah, I mean there's no magic toolkit or manual. I've long ago given up on the notion that I'm one book away from the perfect elusive answer to whatever plagues you in life. And there's obviously lots of books about strategy and you get into all that. I guess for me, a couple of things have been helpful. One is you mentioned earlier finding a mission that you're really passionate about. I think it would be hard for me to come up with a strategy for improving the healthcare system. It's like, sure, it's important. I hope someone does it and figures out how to deal with HIPAA and whatever, all this stuff, but it's just not for me. It's not my purpose, mission and vision in life.
(00:23:24):
And so step one is, am I working at a place and in a product area in which I have a tremendous amount of passion? Because for me, that is the fuel and the motivation that helps me break through to getting the strategy. That's the first step. So that's where I feel enormously lucky because again, this revolutionizing transportation and car ownership and what happens with autonomy and form factors and future of cities is something that I'm super excited about. I think about my daughters growing up and having a different world to live in that's safer and more environmentally friendly, all this stuff, and I get really jazzed when I think about, wow, the work I do could actually impact their future lives and other people. It's like, whoa, I can feel the chills right now. It's just super motivating. So that's the first place, just getting myself fired up.
(00:24:10):
And then the next thing I guess that's been helpful is I've deeply immersed myself. I haven't really jumped around between crypto and gen AI, this stuff, and a lot of people do that. It's great, nothing wrong with that, but I've been in this largely focused on mobility space for 10 years now with some stints over in the restaurant tech and delivery side, but very related in terms of last mile logistics. And so I think it's hard to come up with a great strategy if you've only been working in an area for six months. Especially things like this, they're super nuanced. Shared rides is another a good example where it's a super hard problem to crack and it's going deep on that for a long time is a precursor to being successful.
(00:24:55):
The other thing I would say though is people always talk about first principles thinking, but if there's truth in it, I think that's like when Elon's like, "Well, why does the rocket cost a gazillion dollars to launch? And there's no reason they have to throw away the materials and blah, blah, blah." One example might be, why do we need a 4,000 pound vehicle to move a human three miles? Okay, well... Or even a couple of humans. We do an Uber Pool or a Share, and you move two humans or three humans, even then that's pretty inefficient. If you think about just the physics there, the energy expenditure.
(00:25:32):
And that's where I think you might come up with bikes and scooters and little other things. And sure it's not always, it's raining or you want the car, but that's sort of an example of why questioning why are things the way they are, and then is the way they are super inefficient or not optimal in some sense? And that is often a doorway to opportunity to see, okay, well maybe things could be different. And so I kind of extend that at a larger level to the future. My general thing is just like, yeah, that's the mountain thing is I try to just close my eyes and imagine the future as far out as I can.
(00:26:09):
It's like five years from now, 10 years from now, whatever. And it's develop a really salient picture of what that looks like. It's like, we could do this right now, it's okay. 10 years from now, what could San Francisco look like? Or some city? What happens to the parking spaces? Are there still parking garages? Are those parks now? What are the modes of transport? Are there bus-like things that are autonomous that are connecting people to bikes and scooters? And how are people living? Do they live in the far suburbs even more because autonomy and they have a nicer house and they come in, or is all the space repurposed and actually it's cheaper to live in the city because we compact things, blah, blah, blah. It's not even about having the right one, it's more just developing some sort of picture of the future that gets you fired up.
(00:26:57):
And then yeah, you got to go articulate that and communicate it and get people to come on the journey with you. But from that picture, it's like, well, first principle, what's going to be true 10, 20 years from now? Well, autonomy is a given. I think most people would probably agree with that, and we'll probably solve it with just cameras and won't need lidar because humans don't have lidar. The cost of vehicles and sensors will come down, remote support will come down, and at some point it'll be super cheap and it's like, okay, I can extrapolate, that will be a thing. Separate from which player wins. I'm not saying I can predict the ecosystem of companies that will win here. It's more about just the underlying dynamics. And then that would be one, and another one would be sharing. It's like, well, a lot of people are like, "Oh, well, once we have cheap autonomous cars, everyone can just have their own super cheap Uber, Tesla or whatever it is here in the city."
(00:27:45):
And you're like, "Well, that doesn't work because then we're going to hit this induced demand concept," which is what economists call it, and you used to, when text messages cost 50 cents a piece, how many did you send versus now when it's free, it's in the millions. Same thing when they add a lane to a highway, the traffic just gets just as bad as before because more people drive and so forth. So if we flood the streets with super cheap autonomous cars with single occupancy, we're just going to have even more good luck than we do right now. Maybe we'll do The Boring Company thing and dig tunnels, but that seems unlikely.
(00:28:16):
So then for me, it's like, well, from first principles, shared rides is going to continue to be an important part of the future of transportation. And other modalities where yeah, back to the three mile thing, it's like, well, there probably will be various form factors of bikes, scooters and little mini golf cart things and whatever we end up building. And so that's hopefully an example of how I try to think about what are the likely things to be true in the future, and then how does that lead to a potential ecosystem and strategy around what we might build towards that future.

**中文翻译:**
谢谢，我很感激这些赞美。谢谢 Brent。这段话写得真好。哇。我想说，并没有什么神奇的工具箱或手册。我很久以前就放弃了“只要读一本书就能找到解决生活中所有难题的完美答案”的想法。当然，关于战略的书有很多。对我来说，有几件事很有帮助。第一，正如你之前提到的，找到一个你真正热爱的使命。对我来说，要制定一个改善医疗体系的战略会很难。当然，它很重要，我希望有人能解决它，搞定 HIPAA（医疗保险隐私法案）之类的东西，但那不适合我，那不是我的人生目标、使命和愿景。
(00:23:24):
所以第一步是：我是否在一个我有极大热情的领域和产品领域工作？因为对我来说，那是帮助我突破并制定战略的燃料和动力。这是第一步。在这方面我感到非常幸运，因为彻底改变交通、汽车所有权、自动驾驶、产品形态以及城市的未来，这些都是让我超级兴奋的事情。想到我的女儿们长大后能生活在一个更安全、更环保的世界，想到我的工作实际上能影响她们和其他人的未来生活，我就感到热血沸腾。我现在都能感觉到那种激动。这非常有动力。所以第一点就是让自己燃起来。
(00:24:10):
接下来的第二点是深度沉浸。我没有在加密货币、生成式 AI 等领域跳来跳去，很多人这样做，这很好，没问题，但我这 10 年来基本上都专注于移动出行领域，中间在餐饮技术和配送领域待过一段时间，但在最后一公里物流方面是非常相关的。我认为如果你只在一个领域工作了六个月，很难制定出伟大的战略。特别是像这样非常微妙的领域。拼车是另一个好例子，这是一个极难攻克的难题，长时间深入研究是成功的前提。
(00:24:55):
另一件事是人们常说的“第一性原理”（first principles）思考。如果其中有真理，那就像埃隆·马斯克说的：“为什么发射火箭要花那么多钱？没理由非要把材料扔掉，等等。”一个例子可能是：为什么我们需要一辆 4000 磅重的车来运送一个人走三英里？好吧……或者即使是运送几个人。我们做 Uber Pool 或 Share，运送两三个人，即使那样效率也很低。如果你考虑物理学和能量消耗的话。
(00:25:32):
这就是为什么你会想到自行车、滑板车和其他小东西。当然，并不总是适用，比如下雨天你还是想要汽车。但这只是一个例子，说明为什么要质疑现状：为什么事情是现在这样的？现在的这种方式是否在某种意义上效率极低或并非最优？这通常是发现机会的门户，让你看到：好吧，也许事情可以变得不同。我把这种思考扩展到对未来的展望。我的通用方法就是“找大山”：我试着闭上眼睛，尽可能远地想象未来。
(00:26:09):
比如 5 年后、10 年后。描绘出一幅非常清晰的画面。10 年后的旧金山或某个城市会是什么样子？停车位会发生什么变化？还会有车库吗？那些地方会变成公园吗？交通方式有哪些？是否会有自动驾驶的类巴士工具将人们连接到自行车和滑板车？人们如何生活？他们会因为自动驾驶而住得离郊区更远吗？还是城市空间被重新利用，因为紧凑化而让城市生活更便宜？重点不在于预测得完全正确，而在于描绘出一幅让你兴奋的未来图景。
(00:26:57):
然后，你必须去阐述它、沟通它，让人们加入你的旅程。从那幅图景出发，思考：第一性原理，10 到 20 年后什么是必然的？自动驾驶是肯定的，大多数人都会同意。我们可能会只用摄像头解决它，不需要激光雷达，因为人类也没有激光雷达。车辆和传感器的成本会下降，远程支持成本也会下降，最终它会变得超级便宜。我可以推断，这将成为现实。这与哪家公司获胜无关。我不是在预测生态系统，而是在预测底层动态。另一个是“共享”。很多人说：“一旦有了便宜的自动驾驶汽车，每个人都可以拥有自己超级便宜的 Uber 或特斯拉。”
(00:27:45):
但你会发现：“这行不通，因为我们会遇到‘诱导性需求’（induced demand）的概念。”经济学家这么称呼它。以前短信 50 美分一条时你发多少？现在免费了你发多少？同样，高速公路增加一条车道，交通很快就会变得和以前一样糟糕，因为更多人开车。如果我们让街道充满超级便宜的单人自动驾驶汽车，我们只会遇到比现在更严重的交通瘫痪。也许我们会像 Boring Company 那样挖隧道，但这看起来不太可能。
(00:28:16):
所以对我来说，从第一性原理出发，拼车将继续是未来交通的重要组成部分。还有其他形式，回到三英里的问题，可能会有各种形态的自行车、滑板车和迷你高尔夫球车之类的东西。希望这是一个例子，说明我如何思考未来可能成真的事情，以及这如何引导出我们为那个未来所构建的潜在生态系统和战略。

---

### [00:28:50] [Lenny Rachitsky]

**English:**
This is great because this is something everyone can do, and there's all this talk of creating a vision, painting a vision, communicating a vision, and what you're describing is how to actually sit there and think about what it might look like. Sit there, close your eyes and in your head visualize in the next five or 10 years, what does the future actually look like? And do you do this in a state of if we were to do this product and change, or is it just even if we're not around, here's where the future is going to go most likely, which direction do you usually take?

**中文翻译:**
这太棒了，因为这是每个人都能做到的。人们总是在谈论创造愿景、描绘愿景、沟通愿景，而你描述的是如何真正坐在那里思考它可能的样子。坐在那里，闭上眼睛，在脑海中构思未来 5 到 10 年的样子。你是在“如果我们做了这个产品并改变了世界”的状态下做这件事，还是仅仅在想“即使我们不在，未来最可能的发展方向是什么”？你通常采取哪种方向？

---

### [00:29:20] [John Mark Nickels]

**English:**
Yeah, that's a good question. I think you could probably do either. I typically like to start with the former, which is just like, what will the world move towards absent of me? Just trying to pick a bird's-eye view of what I think the trajectories are and trends and what's going to happen. And then yeah, you could apply a lens of, okay, if we were to build product XYZ or have the strategy, how might we influence the outcome or benefit from it, or is it in congruence with that or is it rubbing against that and trying to change that? Either could be good, you might say it's a tailwind or a headwind, both are overcomeable, but having some awareness of the relationship between those things is good.

**中文翻译:**
好问题。我想两者都可以。我通常喜欢从后者开始，即：如果没有我，世界会向什么方向发展？试着以鸟瞰视角观察轨迹、趋势和即将发生的事情。然后，你可以套用一个镜头：如果我们开发了产品 XYZ 或采取了某种战略，我们将如何影响结果或从中受益？它是顺应趋势，还是逆流而上试图改变它？两者都可以，你可以说它是顺风或逆风，都是可以克服的，但意识到这些事物之间的关系是有好处的。

---

### [00:30:00] [Lenny Rachitsky]

**English:**
And I think transportation, Uber, Waymo, in theory it might be easier to visualize that future and how exciting that might be versus a B2B SaaS payroll app or some photo sharing thing. But on the other hand, not necessarily, right? What in the future in 10 years, how are people going to be paid? How do people work at companies? I think there's an opportunity to do that no matter what you're building. Is this something you actually do? You just sit there in the office, close your eyes and just imagine? Is this more of an iterative process where you get with your team, how do you actually practice this?

**中文翻译:**
我觉得交通、Uber、Waymo 在理论上可能比 B2B SaaS 工资应用或某些照片分享应用更容易可视化未来。但另一方面，也不一定，对吧？10 年后的未来，人们如何获得报酬？人们如何在公司工作？我认为无论你在构建什么，都有机会这样做。这是你实际会做的事吗？你就坐在办公室里，闭上眼睛想象？还是说这是一个与团队一起进行的迭代过程？你实际上是如何实践的？

---

### [00:30:31] [John Mark Nickels]

**English:**
Yeah, it's not like something you can just schedule 30 minutes for in the middle of your day of packed OKR reviews and random one-on-ones and meetings. It's like, I like to do it on my own at first unless it's something that I already have an outline for and I'm ready to move into a team space. So for me, it's like, yeah, can I get into a quiet contemplative space? So yeah, I like to go for a run and that obviously gives me ideas, or I'll go for a hike up in Marin and sometimes I'll just think of stuff or jot something down or make a voice note while I'm doing that to get things going. But yeah, the first step for me is just getting out of the craziness of day-to-day. To me, it's still insane how many product manager, leaders of all kinds just run the schedule of back to back meetings, 30-minute review, big meaty topics, you run out of time, run to the next thing, answer a bunch of emails, and then cram some PRDs in there. It's like, it doesn't work.
(00:31:27):
And so I'm a big fan of carving out time, again, first for myself, a couple hours, whatever, where I can just get out of the day-to-day craziness and get into that head space of five, 10 years from now. It's just a different place. So you need to transition to that. And then bring that to teams. If I have an outline of that kind of future of transportation in my head, I might share that with a group of folks and we'll come together also for some extended period of time. We recently had an all-day Monday thing where eight of us came into the office to talk about future of marketplace, and it was super productive. It was like, laptops down, we're going to spend all day together on a whiteboard. It's like a lost art. People don't use the whiteboards anymore.
(00:32:10):
But yeah, and then from there it's getting more people and then you can kind of iterate on it. It's like I had some vision of the future and someone points out something that is a little bit off with it or has a better idea. Then you move into co-creation. But I love that. It's like Pixar calls the brain trust. If you read [inaudible 00:32:28] book, how they come up with a Toy Story and Inside Out and all these things, is they have this group of people that just sits around riffing on ideas. And again, there's no judgment, there's no attachment to being right. They're in a co-creative sort of space where they're just like co-exploring and riffing with each other. And I love to be in that space with other PMs and engineers and data scientists.

**中文翻译:**
是的，这不像是在排满 OKR 评审、随机 1 对 1 面谈和会议的一天中，随手抽出 30 分钟就能做的事。我喜欢先自己思考，除非我已经有了一个大纲并准备好进入团队讨论空间。所以对我来说，关键是进入一个安静的沉思空间。我喜欢去跑步，这显然能给我灵感；或者去马林县徒步，有时我会边走边想，或者记下点什么，或者录个语音备忘录。第一步是跳出日常的疯狂。对我来说，看到那么多产品经理和各种领导者每天排满背靠背的会议——30 分钟评审、讨论重大话题、时间不够了赶紧跑向下一个、回一堆邮件、再塞进几个 PRD（产品需求文档）——这简直不可思议。这行不通。
(00:31:27):
所以我非常推崇留出时间，首先是给自己留出几个小时，让自己脱离日常琐事，进入 5 到 10 年后的思维空间。那是一个完全不同的地方，你需要进行转换。然后把它带给团队。如果我脑子里有了未来交通的轮廓，我会分享给一群人，我们会聚在一起待上一段时间。最近的一个周一，我们八个人在办公室待了一整天讨论“市场的未来”，效率极高。大家合上电脑，整天围着白板转。这像是一门失传的艺术，现在人们都不怎么用白板了。
(00:32:10):
从那里开始，吸引更多人加入，然后进行迭代。比如我对未来有个愿景，有人指出其中有些偏差，或者有更好的主意。然后就进入了“共同创造”。我喜欢这种方式，就像皮克斯（Pixar）所谓的“智囊团”（brain trust）。如果你读过相关的书，了解他们是如何构思《玩具总动员》和《头脑特工队》的，你会发现他们有一群人坐在一起即兴发挥。没有评判，不执着于谁是对的。他们处于一个共同创造的空间，共同探索和碰撞。我喜欢和 PM、工程师、数据科学家一起待在那个空间里。

---

### [00:32:52] [Lenny Rachitsky] (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast... [Ad content omitted for brevity] ...Get $1,000 off Vanta when you go to vanta.com/lenny. That's V-A-N-T-A dot com slash lenny.

**中文翻译:**
本期节目由 Vanta 赞助。在确保公司拥有顶尖安全实践方面，事情很快会变得复杂……[广告内容：Vanta 帮助自动化 SOC 2、ISO 27001 等合规认证。]……访问 vanta.com/lenny 即可享受 1000 美元的折扣。

---

### [00:33:44] [Lenny Rachitsky]

**English:**
Something I've started to do, which is hard, but I find really valuable is when I'm driving to not play anything on the radio, not listen to any podcasts, and it's so unnatural and it's like, oh, this is hard. I don't want my brain to just go... you don't trust your brain to go to a place that's fun, but it always does. It always ends up being like, oh, that was so interesting just to think of this idea that just came up. So I've been trying to do that, and that such a simple thing to do. Just don't turn anything on.

**中文翻译:**
我开始做的一件事（虽然很难，但我发现很有价值）是开车时不听收音机，不听任何播客。这感觉很不自然，甚至有点难受。我不希望我的大脑就那么……你不相信你的大脑会带你去一个有趣的地方，但它总是会。最后总是会变成：“噢，刚才想到的那个主意真有意思。”所以我一直在尝试这样做，这其实很简单：什么都别开。

---

### [00:34:13] [John Mark Nickels]

**English:**
Well, it's not really good for your podcast business to tell people not to listen to podcasts.

**中文翻译:**
额，告诉大家不要听播客，对你的播客生意可不太好。

---

### [00:34:16] [Lenny Rachitsky]

**English:**
Okay, everyone, we're cutting this. What I find really helpful is playing Lenny's podcast every time I'm out and about.

**中文翻译:**
好吧各位，这段剪掉。我发现非常有帮助的是，每次出门都播放 Lenny 的播客。

---

### [00:34:25] [John Mark Nickels]

**English:**
No, but there's something to what you said, which is there's always a lot of content out there to pursue, and I've been in that mode where I'm like, yeah, more content, more... But yeah, actually similar to you, spend a lot of time now not listening to anything. Go on a hike where you don't listen to a podcast or music on your commute and see what happens. You might be surprised.

**中文翻译:**
不，但你说得有道理。外面总是有很多内容可以追求，我也曾处于那种“想要更多内容”的模式。但实际上，和你类似，我现在花很多时间什么都不听。去徒步时不听播客，通勤时不听音乐，看看会发生什么。你可能会感到惊讶。

---

### [00:34:45] [Lenny Rachitsky]

**English:**
Yeah. And it always ends up being like, oh, that was cool. And that's where shower ideas come from and all these things. Maybe just to see if there's something here, in this meeting that you have, this ideation brainstorming meeting, is there anything that came out of that that was really surprising or new from a recent experience? Is there anything there of just like, oh wow, we really uncovered this potential wrinkle of the future that we really need to think about differently?

**中文翻译:**
是的。结果总是会变成：“噢，那太酷了。”这就是“洗澡时的灵感”之类的来源。也许我们可以看看，在你最近的那次构思头脑风暴会议中，有没有什么让你感到惊讶或新颖的东西？有没有什么发现让你觉得：“哇，我们真的发现了一个未来的潜在变数，我们需要以不同的方式去思考它”？

---

### [00:35:08] [John Mark Nickels]

**English:**
Well, it wasn't maybe a specific wrinkle, but one of the things that we're thinking a lot about, like I'm fortunate to be involved in trying to help develop and articulate a multi-year three-year product or even overall tech strategy for the mobility business at Uber. And one of the, I guess big ahas for us is as we move away from the, in some ways simpler world of UberX being the predominant product, which is it used to be pretty simple. It's kind of like a taxi meter on the driver's side. There's a time and distance rate that everybody gets, and then on the rider's side it's like, sure, there's some surge pricing based on supply and demand, but it's one product, it's pretty straightforward. And so this future of multi-modality and on the both demand side and the supply side is what makes the marketplace even more complex and challenging to build.
(00:36:00):
And so it was kind of all this around, okay, well now that we have taxis in the platform and we have fleet providers and we're starting to add Waymos and Cruise and other things, we have to have a marketplace that's aware of those different types of supply and which one might be available for what trips and how to think about cost and quality and allocation of trips and all that. And then on the demand side, it's like, yeah, we've got all these different products like shared rides and reserved rides and comfort and X and priority, and it's like how do we think about how to price those relative to each other? How do we think about which one's to show which user? How do you think about the ranking and so forth? And then that all has feedback loops into the pricing and matching itself as well.
(00:36:45):
So the dynamics of the thing, when I think about the future of marketplace, Uber, is like, whoa. And I don't think anyone's ever built that. That's the super cool thing about it. I think we have the best logistics marketplace tech on the planet and we built something that no one else has ever built, relative to digital marketplaces, for example, just different physical world requirements. And then this next arc of what I described of thinking about different types of supply and different kind of demand channels just adds even more complexity to that. But the aha was like, I guess, yeah, we got to think about all that stuff and think about how the supply and demand relate to each other and yeah, it's going to be cool.

**中文翻译:**
嗯，也许不是一个具体的变数，但我们思考很多的一件事是——我很幸运能参与制定和阐述 Uber 移动业务的多年（三年）产品甚至整体技术战略。对我们来说，一个重大的启发（aha moment）是，我们正在脱离那个以 UberX 为主导的、某种程度上更简单的世界。以前它很简单：司机端就像出租车计价器，每个人都有统一的时间和距离费率；乘客端虽然有基于供需的动态调价，但它只是单一产品，非常直观。而这种需求侧和供给侧都具备“多模态”（multi-modality）的未来，正是让市场平台构建变得更加复杂和具有挑战性的原因。
(00:36:00):
所以一切都围绕着：既然我们平台上有了出租车、有了车队供应商，并且开始加入 Waymo、Cruise 等自动驾驶车辆，我们就必须拥有一个能感知这些不同供应类型的市场平台。我们需要知道哪种供应适合哪种行程，如何考虑成本、质量和行程分配等等。在需求侧，我们有拼车、预订、舒适型、UberX、优先型等各种产品，我们如何考虑它们之间的相对定价？如何决定向哪个用户展示哪个产品？如何考虑排名等等？所有这些都会反馈到定价和匹配系统本身。
(00:36:45):
所以，当我思考 Uber 市场的未来动态时，感觉是：“哇。”我不认为有人曾经构建过这样的系统。这是最酷的地方。我认为我们拥有全球最好的物流市场技术，我们构建了一些别人从未构建过的东西，例如相对于纯数字市场，我们有不同的物理世界要求。而我描述的下一个阶段——考虑不同类型的供应和不同的需求渠道——只会增加更多的复杂性。但那个启发就是：是的，我们必须通盘考虑所有这些因素，思考供需如何相互关联。这会非常酷。

---

### [00:37:26] [Lenny Rachitsky]

**English:**
It's just an infinitely cited marketplace now. That's wild. One last nugget I wanted to just reinforce that you shared about how to become better at strategy and vision, developing great and interesting and innovative strategy, and vision is going really deep on a topic. So you've been in the space for a long time. There's this idea that Paul Graham talks about, I think, called your top idea or something like that, that when you have... Whatever your top ideas, the more you can just think about that and keep that top of mind as you go about your day and just have one core focus, the more likely it is you're going to come up with new interesting ideas because your brain's going to keep working on it when you're driving around listening to Lenny's podcast. Just kidding, or going on hike.
(00:38:09):
So I think that's a really important point is if you're finding you're not coming up with a great strategy or vision and just having struggles, part of it might just be you're not spending enough time in that space, you're not going deep enough in the problem area. One approach is just spend a decade in that space. Is there anything else just comes up as I say that of just how to do that?

**中文翻译:**
现在它变成了一个无限维度的市场，太疯狂了。关于如何提升战略和愿景能力，我想强化一下你分享的一个要点：制定伟大、有趣且创新的战略和愿景需要对一个课题进行极深的研究。你在这个领域待了很久。保罗·格雷厄姆（Paul Graham）曾提到过一个观点，好像叫“你的头号想法”（top idea），即当你有一个核心关注点时，你在日常生活中越多地思考它，就越有可能产生有趣的新想法。因为当你开车听 Lenny 的播客（开玩笑）或徒步时，你的大脑会持续处理它。
(00:38:09):
所以我认为这是一个非常重要的点：如果你发现自己想不出好的战略或愿景，感到很挣扎，部分原因可能只是你在这个领域花的时间不够，对问题领域的钻研不够深。一种方法就是在这个领域待上十年。关于如何做到这一点，你还有什么想法吗？

---

### [00:38:26] [John Mark Nickels]

**English:**
Yeah. Well there's also, that's at the macro level, maybe spending 10 years in a space, but at the micro level, back to kind of like defrag your day, don't just do the 20, 30 minute meetings on 20 different topics. Sure, sometimes you do that first and you got to do that. You have a large team like I do, obviously reviews across teams. I'm not saying I don't do that on some days, but it's like, yeah, what are my top few things, right? I think, you're right, I think it was Peter [inaudible 00:38:52] or PayPal guys talked about that too, going really deep and having a person or a leader really responsible for one core, deep thing for the company, and that's something they immerse themselves in. And in the micro, that to me again translates to, yeah, I don't have a to-do list of 20 things. I try to have a to-do list of three of the most important highest leverage things that could have impact broadly across the company and then try this, like you said, let that one top thing marinate and chew on it.

**中文翻译:**
是的。除了宏观层面的十年磨一剑，在微观层面，回到“整理你的日程”这一点：不要只是参加 20 个讨论不同主题的 20 到 30 分钟会议。当然，有时你必须这样做，尤其是像我这样管理大团队，需要进行跨团队评审。我不是说我某些日子不这样做，但关键是：我的头号任务是什么？你说得对，我想彼得·蒂尔（Peter Thiel）或 PayPal 的创始人们也谈过这一点：深入钻研，让一个人或领导者真正负责公司的一项核心、深度的事务，并沉浸其中。在微观上，这对我来说意味着：我没有一个包含 20 件事的待办清单。我试着只列出三件最重要的、杠杆率最高的、能对全公司产生广泛影响的事，然后像你说的，让那件头号大事在脑子里“腌制”和反复咀嚼。

---

### [00:39:22] [Lenny Rachitsky]

**English:**
I love that. And I recently had a post about all these productivity tricks, and one of the things that I find really helpful is at the beginning of each day and also at the beginning of each week, just write down, here's the one to three things that I need to do and get done. And everything else, I might have this really long list, but here's the three things if I get done, life will be good. I've done a lot. I've accomplished really great, important things.

**中文翻译:**
我喜欢这个。我最近发了一篇关于生产力技巧的文章，我发现非常有帮助的一点是：在每天开始和每周开始时，写下我需要完成的 1 到 3 件事。其他的可能有一个长长的清单，但如果我完成了这三件事，生活就会很美好，我就算完成了很多了不起的大事。

---

### [00:39:42] [John Mark Nickels]

**English:**
Totally. I tried to do the David Allen GTD thing once, the super complicated organization system. It was too much structure for me. I couldn't do it. At the end of the day, what you said is right. There's basically three things that I need to do next, and then there's just some random backlog that I can just scan through periodically and that's it. That gets you most of the way.

**中文翻译:**
完全正确。我曾经尝试过大卫·艾伦（David Allen）的 GTD（尽管去做），那个超级复杂的组织系统。对我来说结构太重了，我做不到。归根结底，你说得对：基本上就是我接下来需要做的三件事，然后是一些可以定期浏览的随机积压任务，仅此而已。这就能解决大部分问题。

---

### [00:40:01] [Lenny Rachitsky]

**English:**
It's crazy. I read that book 20 years ago at this point, and there's elements that still make things, like I leverage and benefit from. Even if you don't do the whole thing, that book I recommend people read because there's just like, if you pick a couple things from there, your life gets better. The things that have stuck with me, the main one is this waiting for concept of if you're waiting, if you email your designer and like, "Hey, I need you to review this product," just note, "Waiting for Dan to review design." And just having that thread written down and not in your head really helped me.

**中文翻译:**
太疯狂了，我读那本书已经是 20 年前的事了，但其中有些元素我至今仍在受益。即使你不执行全套系统，我也推荐人们读读那本书，因为只要采纳其中的几点，你的生活就会变好。对我影响最深的是“等待”（waiting for）的概念：如果你在等某人，比如你给设计师发了邮件说“嘿，我需要你评审这个产品”，就记下“等待 Dan 评审设计”。把这个线索写下来而不是记在脑子里，真的帮了我大忙。

---

### [00:40:36] [John Mark Nickels]

**English:**
Totally.

**中文翻译:**
完全同意。

---

### [00:40:36] [Lenny Rachitsky]

**English:**
Yeah. Anyway, I'm not going to go on that tangent.

**中文翻译:**
是的。总之，我不打算在这个话题上扯远了。

---

### [00:40:41] [John Mark Nickels]

**English:**
Yeah. It's the core concept of like, whatever steps you use. I think the most powerful takeaway from that book for me was if it's in your head, you're screwed because it's like you're trying to keep track of stuff and be creative and come up with the future of transportation and remember to pick up something from the pharmacy. It's a recipe for disaster. This whole idea of empty mind, beginner's mind, well, you have to empty the mind of all the to-dos first. Just get that out of the head.

**中文翻译:**
是的。无论你使用什么步骤，核心概念都是一样的。那本书对我来说最有力的启发是：如果事情记在脑子里，你就完蛋了。因为你一边试图追踪琐事，一边还要保持创意、构思交通的未来，同时还得记住去药店买东西。这是灾难的配方。所谓的“空灵之心”或“初心”，你必须先把所有的待办事项清空，把它们从脑子里拿出来。

---

### [00:41:04] [Lenny Rachitsky]

**English:**
Absolutely. I think it was mind like water, that's the one that stuck with me, where nothing you need to remember can be in your head. It needs to be written down somewhere Anyway, let's not go into a whole productivity podcast here.

**中文翻译:**
绝对是。我想那是“心如止水”（mind like water），这是让我印象最深的一点：任何你需要记住的事情都不能留在脑子里，必须写在某个地方。总之，我们别把这儿变成生产力专场播客了。

---

### [00:41:15] [John Mark Nickels]

**English:**
Perfect.

**中文翻译:**
太好了。

---

### [00:41:17] [Lenny Rachitsky]

**English:**
So we talked about vision strategy. So there's classically two problems people have with vision strategy. One is how do I get better at it? The other is just like, I need to actually get shit done. I can't spend all my time thinking about vision. You have a really good take on how to find this balance and you've seen it work well and not well, just vision versus execution. When do I go big vision, how much I spend on vision versus just get shit done, execute, execute, execute? What could you share about just what you've learned about how to find that balance and what you've seen work and not work?

**中文翻译:**
我们谈到了愿景和战略。通常人们在愿景战略上有两个问题：一是如何变得更擅长；二是“我得真正把事办成”，我不能把所有时间都花在思考愿景上。关于如何找到这种平衡，你有一个很好的见解，你也见过成功和失败的案例，即“愿景 vs 执行”。什么时候该追求宏大愿景，花多少精力在愿景上，什么时候该埋头苦干、执行、执行、再执行？关于如何找到这种平衡，以及你所见过的有效和无效的做法，你能分享些什么吗？

---

### [00:41:48] [John Mark Nickels]

**English:**
Yeah, I think you can go too far either direction, right? It's like everything in life is about balancing the polarity between two opposing forces. And so in this one it's like, yeah, you go too hard in division and theory land, I've seen that go off the axle, early Uber where again, back to the future of pricing, it's like we have all the data scientists and PhDs locked in a room for two weeks and there's a beautiful whiteboard diagram. What did it look like? And then it's like, why don't we actually build this thing? And engineers are like, this is like boiling the ocean. And you just get wrapped around the axle of like, well, that sounds really good in theory, but I have no idea how to even start executing on this. So that's probably an example of we tilted a little too far towards the vision theory land.

**中文翻译:**
是的，我认为任何一个方向走得太远都不行，对吧？生活中的一切都在于平衡两种对立力量之间的极性。在这个问题上，如果你在愿景和理论领域钻得太深，我见过这会导致失控。比如早期的 Uber，回到“定价的未来”那个项目，我们把所有的数据科学家和博士关在房间里两周，画出了精美的白板图。结果呢？当问到“我们为什么不真正把它造出来”时，工程师们会说：“这简直是在异想天开（boiling the ocean）。”你就会陷入困境：理论上听起来很棒，但我完全不知道该如何开始执行。这可能就是我们过于倾向愿景理论领域的例子。

---

### [00:42:34] [Lenny Rachitsky]

**English:**
And this was, you're describing the original plan to make a really good surge pricing algorithm?

**中文翻译:**
你描述的是最初那个想要做一个非常棒的动态调价算法的计划吗？

---

### [00:42:39] [John Mark Nickels]

**English:**
Yeah. This was a plan to try to bring together, say how we do driver pricing, time and distance rates, but also we do incentives for drivers where it's like if you drive this many hours a week, you get a bonus. And there's also surge pricing and how to tie all those systems together in a very sophisticated sort of way. This was back in 2017 or something and it winged a little too hard into theory land.
(00:43:03):
And we still have that bias sometimes. We joke about marketplace, especially when we talk about with other teams that are trying to integrate in the marketplace, let's say they add fleets or teams with a big new product. And then marketplace people would be like, "Well, have you thought about this one random problem that could happen two years from now if teams become this much of demand and blah blah blah, whatever." And it's just like we do get wrapped around the axle on that sometimes. But yeah, so the future of pricing is a good example, we winged a little too far into theory land. But you could probably go too far into execution land too. And I'd say DoorDash in my experience would do that sometimes where we used to actually even half joke there, some of us leaders would be like, "It's ready, fire, aim."
(00:43:49):
And it was like, people would be like, "I'm just going to run through a wall. I have no idea if that's the right wall to run through, but at least I know I'm running through a wall." So yeah, I think it's about balance and can you adjust. Again, it's dynamic. I think there's times where you're in a soul searching sort of, "What is our product strategy? We got to pivot." Maybe you're a startup and it's not working and you want to think about... And then it's like, okay, well pull off the gas a little bit, ease up on the execution and let's lean into the strategy vision piece. And there's times where the strategy and vision's pretty baked at least for the next whatever, six months, a year. And it's like, okay, pedal to the metal. Let's just go execute. Let's get it done.

**中文翻译:**
是的。这个计划试图整合司机定价、时长和距离费率，还有司机的激励措施（比如每周开满多少小时给奖金），以及动态调价，想用一种非常复杂的方式把所有系统联系起来。那是 2017 年左右的事，当时太偏向理论了。
(00:43:03):
我们现在有时仍有这种偏见。我们常拿市场平台团队开玩笑，特别是当其他团队想要接入市场平台时（比如他们增加了车队或推出了重大新产品），市场平台的人会说：“那么，你有没有考虑过两年后如果团队需求达到这个水平，可能会出现的某个随机问题？”我们确实有时会因此陷入僵局。所以“定价的未来”是一个偏向理论的例子。但你也可能在执行领域走得太远。根据我的经验，DoorDash 有时会这样，我们领导层甚至会半开玩笑说：“那是‘准备，开火，瞄准’（ready, fire, aim）。”
(00:43:49):
大家会觉得：“我就是要撞穿这堵墙。我不知道这是不是该撞的那堵墙，但至少我知道我正在撞墙。”所以，我认为关键在于平衡和调整。它是动态的。有时你处于灵魂拷问阶段：“我们的产品战略是什么？我们需要转型。”也许你是一家初创公司，现有的行不通，你需要思考。那时就应该松开油门，放缓执行，倾向于战略愿景。而有些时候，战略和愿景已经非常明确了（至少在未来半年或一年内），那就应该全力以赴，去执行，去完成它。

---

### [00:44:34] [Lenny Rachitsky]

**English:**
I just went to this Acquired Podcast event at the Chase Center. Zuck was there, and the CEO of Spotify was there too. And there's two quick anecdotes that you remind me of. One is, Zuck talked about how once Facebook and Zuck and the team align on here's where we're going, no matter how many walls appear in front of them, there's going to be a Mark shaped hole in the wall very soon because they're just going to run through and get things done that they need to get done. And I really love that mentality of once we're sure where we're going, we're going to bust through these walls.

**中文翻译:**
我刚参加了在 Chase Center 举行的 Acquired 播客活动。扎克伯格在那儿，Spotify 的 CEO 也在。你让我想起了两个小轶事。一是扎克伯格谈到，一旦 Facebook、他本人和团队达成一致，确定了方向，无论面前出现多少堵墙，很快墙上就会出现一个“马克形状”的大洞，因为他们会直接撞过去，完成必须完成的事。我非常喜欢这种心态：一旦确定了方向，就撞穿这些墙。

---

### [00:45:11] [John Mark Nickels]

**English:**
That's awesome.

**中文翻译:**
太棒了。

---

### [00:45:12] [Lenny Rachitsky]

**English:**
The other is a really interesting value at Spotify. So Daniel Ek shared this. He said, "At Spotify we have this core value, talk is cheap." And when you hear that you think it's saying talk is not valuable, and it's actually they look at it as a virtue. Talk is cheap, we can talk and it costs us no money, very little money compared to building something. So they actually spent a lot of time at Spotify refining their ideas and discussing until they're really sure something is right. And I guess any reaction to that? Because I thought that was really interesting.

**中文翻译:**
另一个是 Spotify 一个非常有趣的价值观。Daniel Ek 分享说：“在 Spotify，我们有一个核心价值观：言语是廉价的（talk is cheap）。”当你听到这句话时，你可能以为它是说沟通没有价值，但实际上他们把它看作一种美德。言语是廉价的，我们可以讨论，这不花钱，或者比起真正构建东西来说成本极低。所以他们在 Spotify 实际上花了很多时间完善想法和讨论，直到他们确信某件事是正确的。你对此有什么反应吗？因为我觉得这很有趣。

---

### [00:45:41] [John Mark Nickels]

**English:**
Yeah, I love that. It's almost a different flavor of, I think the base of saying of he's like, I like a crisp dock and a messy meeting. The whole Amazon thing, if you have the three-page or seven-page narrative, it's written with the clarity of angels singing from on high, at least describing how the problem statement or feature or whatever. And so it's super crisp and organized and well articulated. And then you might have a meeting where you pick it apart and you talk a lot. That's what made me think of that.

**中文翻译:**
是的，我喜欢这个。这几乎是另一种风格，让我想起一种说法：“我喜欢简洁的文档和混乱的会议。”就像亚马逊那一套，如果你有一份 3 页或 7 页的叙述文档，它写得像天使在云端歌唱一样清晰，至少描述了问题陈述或功能。它是非常简洁、有条理且表达清晰的。然后你可能会开一个会，把它拆解开来，进行大量的讨论。这让我想到了这一点。

---

### [00:46:12] [Lenny Rachitsky]

**English:**
Yeah. Awesome. Okay, couple more things I want to spend some time on. One is you've worked at a lot of really interesting successful hyper growth companies, DoorDash, Uber, Waymo. You were also in finance for a while. I want to pick on a few of these and just see what's a lesson you took away or what's an experience from that time that might be interesting or helpful to people?

**中文翻译:**
是的。太棒了。好，我还想花点时间聊聊几件事。一是你曾在很多非常有趣且成功的超高速增长公司工作过，比如 DoorDash、Uber、Waymo。你还在金融行业待过一段时间。我想挑几个聊聊，看看你从中吸取了什么教训，或者那段时间有什么对大家有趣或有帮助的经历？

---

### [00:46:34] [John Mark Nickels]

**English:**
Sure.

**中文翻译:**
当然可以。

---

### [00:46:35] [Lenny Rachitsky]

**English:**
So you talked about DoorDash a bit. What did you take away from your time at DoorDash? What's something you saw there that either is like, wow, that's a really cool thing I want to do in the future, or here's something they weren't amazing at that I learned to try to avoid?

**中文翻译:**
你刚才提到了 DoorDash。你在 DoorDash 的那段时间有什么收获？你在那里看到了什么让你觉得“哇，这太酷了，我以后也想这么做”，或者有什么他们做得不够好、让你学会去避免的事情？

---

### [00:46:47] [John Mark Nickels]

**English:**
Yeah, yeah, it's really amazing to get to see different places and pick the best of what you like. And also the other thing is back to like, for me, there's no right or wrong, it's just differences have pros and cons. There's always two sides of the coin. So what's interesting I think about Uber and DoorDash is first back to the mission and the strategy. They started with different DNA, right? So Uber started with it was to utilize blocked cars at the airport that were not doing trips, but it was more about the riders. It was like whatever origin story you believe, Travis and whoever can get a ride in Paris. And so then it was about better than taxi and all this stuff, but it was very rider centric. It was consumer centric in that sense.
(00:47:31):
And so for a long time, I think Uber kind of took that too far. We got to the polarity of drivers are a commodity, blah, blah, blah, and they had to flip that back and start really investing more on the driver's side of the marketplace. But you look at DoorDash and it's like, Tony grew up in his parents' restaurant kitchen and the DoorDash thesis was how can we help small businesses be more successful? And delivery was just the first instantiation of that sort of meta purpose of DoorDash. And so they're much more merchant centric as opposed to consumer centric. And by the way, the consumer centricism of Uber that started with rides than translated to Eats. I think when Uber started with Eats, it was like, "Well, we just want Lenny to have some great Thai food and sushi and have some options. But selection is a means to Lenny having a great eater experience." Whereas DoorDash with their merchant focus is like, "We want every Thai restaurant in this city to be successful and be on DoorDash."
(00:48:24):
So their motivation for selection is, "We want all of the merchants to thrive and survive." So that happens to give you better selection as a result. But the motivation was very different. So the analogy I use is Uber is to Amazon as DoorDash is to Shopify, if that makes sense. Amazon has always been more consumer focused, Shopify is obviously very merchant focused.

**中文翻译:**
是的，能看到不同的地方并挑选你喜欢的优点真的很棒。另外一点是，对我来说没有绝对的对错，只是差异各有优劣，凡事都有两面性。我觉得 Uber 和 DoorDash 有趣的地方首先在于使命和战略。它们的基因不同。Uber 的初衷是利用机场那些闲置的车辆，但它更多是关于乘客的。无论你相信哪个版本的起源故事，核心都是 Travis 他们在巴黎打不到车。所以它的目标是“比出租车更好”，非常以乘客为中心，也就是以消费者为中心。
(00:47:31):
在很长一段时间里，我认为 Uber 把这一点做得有点过头了。我们走向了另一个极端，认为司机只是“商品”，后来不得不扭转局面，开始在市场的司机端投入更多。但你看 DoorDash，创始人 Tony 是在父母的餐馆厨房里长大的，DoorDash 的论点是：我们如何帮助小企业变得更成功？外卖只是 DoorDash 这一元目标的第一个具体体现。所以他们更以商家为中心，而不是以消费者为中心。顺便说一下，Uber 以消费者为中心的理念从打车延续到了外卖（Eats）。我想当 Uber 开始做 Eats 时，想法是：“我们只想让 Lenny 能吃到美味的泰国菜和寿司，有更多选择。丰富度是让 Lenny 获得良好用餐体验的手段。”而 DoorDash 专注于商家，想法是：“我们希望这个城市的每家泰国餐馆都能成功并入驻 DoorDash。”
(00:48:24):
所以他们追求丰富度的动力是“希望所有商家都能蓬勃发展”。这在结果上也带给了你更好的选择，但动机非常不同。我用的类比是：Uber 之于亚马逊，就像 DoorDash 之于 Shopify。亚马逊一直更关注消费者，而 Shopify 显然非常关注商家。

---

### [00:48:46] [Lenny Rachitsky]

**English:**
Interesting.

**中文翻译:**
很有趣。

---

### [00:48:46] [John Mark Nickels]

**English:**
And by the way, either of those, again, there's no right or wrong, is a fine strategy. They're both great companies. And I actually don't know if you could do both. Is it possible to be Amazon and Shopify? To really focus on consumers and build all the merchant restaurant tech? And maybe with enough resources and time, but that would lose focus. So it's like there's a trade-off there. Yeah.

**中文翻译:**
顺便说一下，这两种策略都没有对错，都是很好的战略。它们都是伟大的公司。我其实不知道是否能两者兼顾。有没有可能既是亚马逊又是 Shopify？既真正关注消费者，又构建所有的商家餐厅技术？也许有足够的资源和时间可以做到，但那会失去焦点。所以这其中存在权衡。

---

### [00:49:08] [Lenny Rachitsky]

**English:**
Yeah. Like at Airbnb, there was always this, "Should we optimize for hosts? Should we optimize for guests?" And there's always this like, "This time, guests are most important. Right now hosts are more..." Make these trade-off decisions in the marketplace. So it's interesting that at Uber, your insight there is Uber is always very rider focused, and DoorDash from its DNA was very merchant focused. You also talk about at DoorDash, there's this mentality of just going before figuring out where to go. Is there anything more there that might be helpful, either as a cautionary tale or as a lesson?

**中文翻译:**
是的。就像在 Airbnb，总会有这样的争论：“我们应该为房东优化，还是为房客优化？”总会有这种反复：“这段时间房客最重要，现在房东更……”在市场平台中做这些权衡决策。所以很有趣，你在 Uber 的见解是它一直非常关注乘客，而 DoorDash 从基因上就非常关注商家。你还提到 DoorDash 有一种“在搞清楚去哪儿之前先出发”的心态。关于这一点，还有什么可以作为警示或教训分享的吗？

---

### [00:49:37] [John Mark Nickels]

**English:**
Yeah, I think it's a balance. It's back to I don't want to deliberate and pontificate for weeks on end about which door I should run through. And I don't want to go to the other extreme and just spend 30 seconds thinking about what to do and just go, go, go. So it's finding that kind of happy medium. If I had to pick one, I'd rather bias towards running through a wall than not doing anything, because you still get learnings from that and you either make progress or you don't, and that gives you feedback and you can run through another wall as a result. So I think the biggest failure case is probably erring on the other side of deliberating too long without action.

**中文翻译:**
是的，我认为这是一种平衡。回到刚才说的，我不想花好几周时间去研讨和空谈该冲进哪扇门，但我也不想走向另一个极端，只花 30 秒思考就盲目冲锋。所以要找到中间地带。如果非要选一个，我宁愿倾向于“撞墙”而不是无所作为，因为你仍然能从中学习，无论是否有进展，它都会给你反馈，从而让你接着去撞下一堵墙。所以我认为最大的失败案例通常是另一面：考虑太久而没有行动。

---

### [00:50:15] [Lenny Rachitsky]

**English:**
What about Waymo? What's something that you took away from that experience as a thing that you want to do more of or something you want to try to avoid?

**中文翻译:**
那 Waymo 呢？你从那段经历中学到了什么？有什么是你以后想多做的，或者想尽量避免的？

---

### [00:50:22] [John Mark Nickels]

**English:**
Waymo is, you've probably seen people in San Francisco, they're quite prolific now in terms of they're all over San Francisco and you see them all the time. And I'm not sure, I can't remember the last time I saw one towed, I don't want to say that they've solved self-driving, but they are obviously driving at scale with very minimal, at least real world intervention. You can't tell by looking at the cars how many humans behind the scenes might be helping provide guidance of the car or whatever. But yeah, I would say what's really interesting about Waymo is they've largely solved the self-driving piece, however they've done that, and in a complex environment like San Francisco, and you see them driving in fog and rain and puddles, and it's like, wow, that's pretty cool.
(00:51:07):
But I think what Waymo was learning, and I was trying help them learn is that building a self-driving car on a test track is a very different problem statement than scaling a fleet of thousands of cars. And how do you operate them, clean them, charge them, maintain them, and then how do you build the ride share network? It's like, okay, well we got to build an app and we got to acquire users and do classic growth stuff and think about that marketplace and matching and pricing and those are very different skills. And so it's like a warning that those are different things.
(00:51:41):
And trying to hire for that and build culture around that was hard, honestly. It's just like you're kind of a different thing than the host organism. Most of the host organism is just obsessed with perception and planning and all the core autonomy pieces and you're like, the commercialization people there, "Well, now we've going to make money with this thing." That's why I think that's an example where your overall vision would say Waymo is to build Waymo One. Just be mindful that it's more than just one. There's multiple pillars of that. There's the self-driving piece, there's getting a lot of cars at scale, financing them, operating the fleet, getting the demand, filling the cars with people, and then it has to all come together.

**中文翻译:**
Waymo 嘛，你可能在旧金山见过，它们现在非常普遍，到处都是。我不记得上次见到它们被拖走是什么时候了。我不想说他们已经彻底解决了自动驾驶，但他们显然已经在进行大规模行驶，且现实世界的干预非常少。你无法通过观察车辆知道幕后有多少人在提供引导。但我想说，Waymo 真正有趣的地方在于，他们很大程度上解决了自动驾驶的技术部分，而且是在旧金山这样复杂的环境中，在雾天、雨天和积水路面行驶，这真的很酷。
(00:51:07):
但我认为 Waymo 正在学习（我也在努力帮他们学习）的是：在测试跑道上制造一辆自动驾驶汽车，与运营一个拥有数千辆车的车队是完全不同的问题。你如何运营、清洁、充电、维护它们？然后你如何构建网约车网络？你需要开发 App、获取用户、做经典的增长工作，思考市场匹配和定价，这些都是非常不同的技能。所以这是一个提醒：这些是不同的事情。
(00:51:41):
老实说，为此进行招聘并建立文化是很困难的。你就像是母体组织中的一个异类。母体的大多数人只痴迷于感知、规划和所有核心自动驾驶技术，而你作为商业化团队的人在想：“好吧，现在我们要靠这玩意儿赚钱了。”这就是为什么我认为这是一个例子：你的整体愿景可能是建立 Waymo One，但要意识到这不仅仅是一个点，它有多个支柱。包括自动驾驶技术、大规模获取车辆、融资、车队运营、获取需求、让车里坐满人，所有这些必须整合在一起。

---

### [00:52:31] [Lenny Rachitsky]

**English:**
Right. Yeah. It's so interesting that your title is Lead Product for Commercialization of Autonomous Ride Hailing at Waymo, and now it's come full circle where at Uber, that's going to be in a sense the way that people call Waymo. And so it's so interesting that you've seen both sides of this.

**中文翻译:**
对。很有意思，你在 Waymo 的头衔是自动驾驶网约车商业化产品负责人，而现在在 Uber，这在某种意义上又回到了原点，因为人们会通过 Uber 叫 Waymo。你见证了这两端，这太有趣了。

---

### [00:52:50] [John Mark Nickels]

**English:**
Yeah. Well, we'll see what happens. I think Uber, it got out of the autonomy business when it divested Autonomous Technologies Group or Advanced Technologies Group. And right now our stated strategy is to be an aggregator. So it's like, we are partnering with Waymo, with Cruise, Motional, others in China, et cetera. And then the idea is to have every vehicle on the platform really, right? Autonomous or not. And then use the power of the platform, we have this big demand base, we have a lot of riders.
(00:53:22):
And so I think what you're seeing is, Waymo and Cruise and others are like, "Okay, now that we've developed autonomy, what's the path to profitability for us?" And so they can go it alone and try to build a ride-share network. And Waymo is doing that with Waymo One, but it turns out it takes a while. It's funny, I feel like engineers too are always skeptical of why other people's engineering problems take so much work. There'd be engineers at Waymo would be like, "Why does Uber have so many thousands of engineers? How hard can it be to build a ride-share app?"
(00:53:59):
But when you look at what made Uber successful, what we've been perfecting for the last decade, A, the marketplace tech that I alluded to earlier, but also how we manage a large rider base and doing rider support and driver support and logistics and all of the helping finance electric vehicles and working with regulators and cities and making sure we have safe and accessible pickup points and on and on and on. And those are all the depth of the iceberg that you don't really realize or think of when you're like, "Oh, I can just build a ride-share app." Right? Tesla publishes their sigma design and some earnings report and everyone goes crazy like, "Wow, okay, well I don't want to bet against Elon because that sounds scary," but there is more to it than just the app and the autonomy.
(00:54:46):
So yeah, I think these companies will have an interesting question. Do they go alone, build their own ride-share network to capture all the value, or do they say, "Well, I could just work with Uber and have a faster path to high utilization of the vehicles," which unlocks financing and more vehicles and that gets them to scale faster? And so if you look at the landscape right now, it's a bit of both, right? Waymo is obviously working with Uber in Phoenix and we just announced Cruise will come back to some city next year I think, but Waymo is also still building their own thing, so they're kind of hedging their bets at the moment.

**中文翻译:**
是的，拭目以待吧。Uber 在剥离 ATG（自动驾驶事业群）时退出了自动驾驶研发业务。目前我们明确的战略是做一个“聚合器”。我们与 Waymo、Cruise、Motional 以及中国的其他公司合作。我们的想法是让平台拥有每一种车辆，无论是否是自动驾驶。然后利用平台的优势——我们拥有庞大的需求基础和大量的乘客。
(00:53:22):
所以你看到的是，Waymo、Cruise 等公司在想：“既然我们已经开发出了自动驾驶技术，我们的盈利路径是什么？”他们可以单打独斗，尝试建立自己的网约车网络。Waymo 正在通过 Waymo One 这样做，但事实证明这需要很长时间。很有趣，我觉得工程师们总是怀疑为什么别人的工程问题需要这么多工作量。Waymo 的工程师可能会问：“为什么 Uber 有成千上万名工程师？做一个网约车 App 能有多难？”
(00:53:59):
但当你审视 Uber 成功的原因，以及我们过去十年一直在完善的东西：第一，我之前提到的市场平台技术；第二，我们如何管理庞大的乘客群、提供乘客和司机支持、物流管理、帮助电动汽车融资、与监管机构和城市合作、确保安全便捷的接送点等等。这些都是冰山之下的部分，当你觉得“噢，我只要做一个网约车 App”时，你根本意识不到这些。特斯拉发布了他们的设计和财报，大家就疯狂了：“哇，好吧，我不想赌埃隆输，因为那听起来很可怕。”但除了 App 和自动驾驶技术，还有很多其他东西。
(00:54:46):
所以，这些公司面临一个有趣的选择：是单打独斗、建立自己的网络以获取全部价值，还是说“我可以与 Uber 合作，更快地提高车辆利用率”，从而解锁融资和更多车辆，实现更快的规模扩张？如果你看现在的格局，两者兼有。Waymo 显然在凤凰城与 Uber 合作，我们也宣布 Cruise 明年将回归某个城市，但 Waymo 同时也仍在构建自己的体系，所以他们目前是在两头下注。

---

### [00:55:18] [Lenny Rachitsky]

**English:**
I want to take us to a recurring segment on the podcast that I call Contrarian Corner. I feel like you're going to have a good answer here. What's something that you believe that most other people don't believe?

**中文翻译:**
我想带大家进入播客的一个固定环节，我称之为“反直觉角落”（Contrarian Corner）。我觉得你在这里会有个很好的答案。有什么是你相信，但大多数人都不相信的事情？

---

### [00:55:32] [John Mark Nickels]

**English:**
One is back to being aware of your internal state and allowing emotions and thoughts is... Emotions in the workplace, a lot of people have the thing of like, "Well, there's no need for emotion in the workplace. We're going to be logical. We're going to be data-driven. Keep your feelings at home. Just show up and presentation J.M. Mode." And I guess in my experience, there's this thing around whole body intelligence and whole body, yes, which is yes, there is signal from the head and logic and data and left brain reasoning are amazing and it could be great, but there's also heart and gut. And to me, what is an emotion? It's just energy moving on the body. Often it's correlated with a thought too as well. I might have a thought that creates fear and so forth.
(00:56:23):
But to me there's wisdom in emotion and I can start to access noticing them more. Like where do I feel sadness in the body? I notice I feel fear in the kind of center of my chest, and then sadness is like a sinking feeling in my stomach. And I notice when I'm angry, my jaw gets tight and my eyes furrow a little bit. And so those are common ones, but you may have your own little signatures of you pick up where is joy, where is creative energy? Where is fear or sadness, anger? And then noticing those in a meeting or in a conversation or review. And actually if you're willing, even just voice it to other people, that's like the next step. But start with just acknowledging it to yourself.
(00:57:02):
And so for me, the wisdom of emotions is fear is something wants to be paid attention to. There can be the saber-toothed tiger is not really Dara disapproving of me, whatever. I shouldn't be afraid of that. But there are times where fear is applicable. There might be fear around, let's say back at Waymo, you want to be really intentional about safety and you want to be super... That's one of the things I love about Waymo is they're very committed to having a super strong safety record. And so there might be fear around did we really consider all the edge cases of what might happen if a dog runs in the street or a ball or child or whatever, and you might see wow, fear. It's great. The wisdom of that is something wants to be paid attention to and listened to. Okay, great.
(00:57:46):
Sadness for me is something wants to be let go of. There's a mourning, there's a letting go of I had an idea or vision for the future that will no longer be because whatever, something happened, other people don't want to do it, this or that. But it could be a vision of a relationship, it could be a vision of what you thought your life would look like, whatever. We all go through those sorts of things.
(00:58:07):
And there might be micro-moments of sadness of like, wow, that feature didn't work. It's like I really wanted it to be successful. I just let go of that, welcome the sadness. Anger to me is something is not of service to me or my people or my mission or whatever I'm up to. And so again, that can be a great signal to like, okay, I pay attention to that. I want to change something. And then joy is something that wants to be celebrated. We had a great win. We nailed the OKR, we had a great product launch. A lot of times we spend too much time moving back into the next, okay, let's set another goal. It's like, it's okay to stop and celebrate.
(00:58:45):
And then creative energy is something wants to be born into the world. It's like it's almost like I'm going to birth an idea or a vision or some new product thing and then just tuning into that. So yeah, I would say welcome emotions, maybe even talk about them, god forbid, in the workplace. Imagine that instead of having a OKR review where you're behind target and everyone's blaming other people, and you could tell when it's kind of fearful, if someone was just like, "Wow, I noticed that I just feel fear around this." Everyone was like, "Wow, I feel fear too." That would just totally change the tone of the conversation.

**中文翻译:**
一个是回到对内在状态的觉察，并允许情绪和念头存在。关于职场中的情绪，很多人认为：“职场不需要情绪。我们要讲逻辑，要数据驱动。把你的感情留在家里，上班时就开启‘演示模式’。”但在我的经验中，有一种东西叫“全身智能”（whole body intelligence）。是的，头脑的信号、逻辑、数据和左脑推理都很棒，但还有心灵和直觉。对我来说，情绪是什么？它只是在身体里流动的能量。它通常也与念头相关，比如一个念头产生了恐惧。
(00:56:23):
对我来说，情绪中蕴含着智慧，我可以开始更多地去察觉它们。比如，我在身体的哪个部位感受到悲伤？我注意到我在胸口中心感受到恐惧，而悲伤则像是胃里的一种下沉感。当我生气时，我的下巴会变紧，眉头会稍微皱起。这些是常见的，但你可能有自己的特征。去察觉哪里是喜悦，哪里是创造力？哪里是恐惧、悲伤或愤怒？然后在会议、对话或评审中注意到这些。如果你愿意，甚至可以向别人表达出来，那是下一步，但先从向自己承认开始。
(00:57:02):
对我来说，情绪的智慧在于：恐惧意味着某件事需要被关注。虽然 Dara 的不认可并不是真正的“剑齿虎”，我不该为此害怕，但有些时候恐惧是适用的。比如在 Waymo，你必须对安全非常谨慎。我喜欢 Waymo 的一点是他们致力于保持极强的安全记录。所以可能会有恐惧：“我们真的考虑了所有边缘案例吗？如果街上跑出一只狗、一个球或一个孩子会怎样？”这种恐惧是伟大的，它的智慧在于提醒你有些事需要被关注和倾听。
(00:57:46):
对我来说，悲伤意味着某件事需要被放下。这是一种哀悼，放下我曾经对未来的某个想法或愿景，因为它不再可能实现了（无论是因为发生了什么，还是别人不想做）。这可能是一个关于关系的愿景，或者你对生活的设想。我们都会经历这些。
(00:58:07):
也可能会有微小的悲伤时刻，比如：“哇，那个功能没奏效，我真的很希望它成功。”那就放下它，接纳这种悲伤。愤怒对我来说意味着某件事对我、我的团队或我的使命没有帮助。这又是一个信号：我需要改变一些事情。而喜悦是需要被庆祝的。我们取得了重大胜利，完成了 OKR，产品发布很成功。很多时候我们花太多时间直接跳到下一个目标。停下来庆祝一下是可以的。
(00:58:45):
创造性能量则是某种东西想要诞生到世界上。就像我要孕育一个想法、一个愿景或一个新产品，然后去感受它。所以，我会说，欢迎情绪，甚至在职场中谈论它们（天哪，想象一下）。想象一下，与其开一个指标落后、大家互相指责、充满恐惧的 OKR 评审会，如果有人说：“哇，我注意到我对这件事感到恐惧。”然后大家说：“哇，我也感到恐惧。”这会完全改变对话的基调。

---

### [00:59:20] [Lenny Rachitsky]

**English:**
The advice here is bring your emotions into work. Don't let emotions... What most people believe is leave your emotions at home, don't bring your emotions into the workplace, and what you've found is they actually can make you more effective and make your teams more effective. And you even talked about it helps you make decisions in a more intelligent way because your gut and lizard brain almost tells you things that you should pay attention to.

**中文翻译:**
这里的建议是把情绪带到工作中。大多数人相信要把情绪留在家里，不要带进职场，而你发现情绪实际上能让你和你的团队更有效率。你甚至提到它能帮你以更智能的方式做决策，因为你的直觉和原始大脑会告诉你应该注意什么。

---

### [00:59:46] [John Mark Nickels]

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:59:47] [Lenny Rachitsky]

**English:**
I love that. Okay, so I'm going to close with a question that is rooted in something that you shared with me when we were chatting about this podcast that I think is going to be helpful to a lot of people. What have you found to be keys to a successful, impactful, rich, fun life?

**中文翻译:**
我喜欢这个。好，我要以一个问题结束，这个问题源于我们聊这个播客时你分享给我的内容，我觉得这对很多人都会有帮助。你认为通往成功、有影响力、丰富且有趣的生活的关键是什么？

---

### [01:00:05] [John Mark Nickels]

**English:**
It's a great question, and I think lots of people have different prescriptions for that, and I don't claim to have the one truth around that, but the first thing I would say as a meta observation is I spend a lot of time thinking about objective functions. We design algorithms to do matching and pricing and think about short-term effects and long-term effects. And so I really am ingrained in this idea of we have an objective function for our life. And then the problem is that a lot of us aren't conscious of it. It's just like an implied OF that you inherited values from your church or community or what your parents valued or what you learned to be good at, and I do this for work and blah, blah, blah, and I'm just kind of bobbing along.
(01:00:49):
That's why I love Ray Dalio's principle thing where it's like, Hey, write down your values and your principles and get clear on what they are. Or Clayton Christensen wrote a great book that he's less known for, he's obviously known for Innovator's Dilemma, but he wrote a book called How Will You Measure Your Life? And he was trying to answer this question of, he teaches whatever, MBA students at Harvard, and he's like, "Wow, all these executives are super successful. They're like Fortune 500 execs. They're most super successful, but they're all divorced and their kids hate them and their personal lives are a mess. What's happening?" And so one of the key insights he comes to is like, it's Sunday night and you have the choice of playing with your daughter, or you're reading a book or playing a game, and you have a presentation to Dara on Monday. And he's like, "Well, I could make those slides a little bit better and I could go practice or knock out some emails," or whatever it is you want to do.
(01:01:49):
And so what he basically found was the type A exec, successful people are very short-term OF driven. They're like, "Well, presentation's tomorrow, and that can either go great or okay based on Sunday night." Whereas like, "My daughter will be here, I'll play with her next week." And the problem is that he's getting in this cycle where it's like, okay, you start working every Sunday night and then years and years go by and suddenly you don't have a relationship with your daughter who's now a teenager.
(01:02:16):
But I think we're just not conscious of that. So to me, the first piece of advice would be get clear on your objective function. And one way that I've gotten clear on it is trying to think about it from future me. Because five years from now, I'm not going to give a shit if I made the presentation slightly better, but I'm going to care a lot about what kind of relationship I have with my daughters. And that means that the next action, the next thing I do today and tomorrow, those will translate into the relationship with her. And I think a lot of us aren't just tuned into that.
(01:02:49):
I love the stoic stuff, being mindful of death, Seneca, Marcus Aurelius, all those great ones. Not to be morbid, but just again, most of us just aren't really tuned into an awareness that our lives will come to an end. And we try to avoid that and we try to pretend like we're going to live forever and just not think about it. And the horror of it is that we succeed. We mostly manage to just go live our life and eat ice cream and go to work and go on vacation and do what we do. And that can lead us to doing things that ultimately don't matter in the long run, and focusing on the wrong things.
(01:03:28):
And so to me, it's like an awareness and mindfulness that our lives will come to an end punctuates reality in a way that requires me to rethink my priorities, stop wasting time on things that don't matter with people who matter. This relationship, this journey, it will come to an end. I'm actually tearing up and feeling tingly just saying that. It's like even right now, come back to it. How am I going to spend my afternoon? Am I going to hug my daughters? Am I going to spend time with them after work or am I going to do email all night? What would I wish I had done when I'm in my last breath?

**中文翻译:**
这是一个非常棒的问题。我想很多人都有不同的处方，我并不声称拥有唯一的真理。但作为一种元观察（meta observation），我想说的第一点是：我花了很多时间思考“目标函数”（objective function）。我们设计算法进行匹配和定价，考虑短期和长期效应。我深信我们的生活也有一个目标函数。问题在于，我们中的许多人对此并无意识。它只是一个隐含的目标函数，你从教会、社区或父母那里继承了价值观，或者你学会了擅长什么，然后为了工作而做这些事，随波逐流。
(01:00:49):
这就是为什么我喜欢瑞·达利欧（Ray Dalio）的《原则》：写下你的价值观和原则，搞清楚它们是什么。克莱顿·克里斯坦森（Clayton Christensen）写过一本不太出名但很棒的书（他以《创新者的窘境》闻名），叫《你要如何衡量你的人生？》（How Will You Measure Your Life?）。他试图回答一个问题：他在哈佛教 MBA 学生，他发现：“哇，所有这些高管都超级成功，财富 500 强的高管。但他们都离婚了，孩子讨厌他们，个人生活一团糟。发生了什么？”他得出的一个核心见解是：比如周日晚上，你可以选择陪女儿玩、看书或玩游戏，而周一你要向 Dara 做演示。你会想：“我可以把幻灯片做得更好一点，去练习一下，或者处理几封邮件。”
(01:01:49):
他发现，那些 A 型人格的高管、成功人士，非常受短期目标函数的驱动。他们觉得：“演示就在明天，周日晚上的努力能决定它是出色还是平庸。”而“女儿总是在那儿，我下周再陪她”。问题在于，他陷入了这个循环：每个周日晚上都开始工作，年复一年，突然间你发现自己和已经成年的女儿完全没有关系了。
(01:02:16):
我认为我们只是没有意识到这一点。所以对我来说，第一个建议是：搞清楚你的目标函数。我理清它的一个方法是试着从“未来的我”的角度去思考。因为五年后，我根本不会在乎当年的演示文稿是否做得更完美了一点，但我会非常在意我和女儿们的关系。这意味着我今天和明天采取的每一个行动，都会转化为与她的关系。我想我们很多人并没有意识到这一点。
(01:02:49):
我喜欢斯多葛学派的东西，比如正视死亡，塞内卡、马可·奥勒留，所有那些伟大的思想家。不是要表现得太消极，但事实是，我们大多数人并没有真正意识到生命终将结束。我们试着逃避，假装自己会长生不老，尽量不去想。而可怕的是，我们竟然“成功”地做到了。我们大多时候只是在过日子、吃冰淇淋、上班、度假。这会导致我们去做那些从长远来看根本不重要的事情，关注错误的东西。
(01:03:28):
对我来说，意识到生命是有终点的，这会以一种强有力的方式突显现实，迫使我重新审视优先级，停止在不重要的事情上浪费时间，把时间留给重要的人。这段关系、这段旅程，终将结束。说这些话时我其实都流泪了，感到一阵战栗。就像现在，回到当下：我下午要怎么过？我是去拥抱我的女儿们，下班后陪她们，还是整晚回邮件？当我临终时，我会希望自己当时做了什么？

---

### [01:04:18] [Lenny Rachitsky]

**English:**
There's a quote that I heard once that really stuck with me that I think is going to hit a lot of people really hard, which is that the only people that will remember you working late every night is your kids.

**中文翻译:**
我听过一句话，让我印象非常深刻，我想这会让很多人深受触动：唯一会记住你每天晚上加班到很晚的人，是你的孩子。

---

### [01:04:32] [John Mark Nickels]

**English:**
Wow. Yeah.

**中文翻译:**
哇。是的。

---

### [01:04:34] [Lenny Rachitsky]

**English:**
Yeah. An important reminder. J.M., we've covered a lot of stuff. Is there anything else that you think might be helpful for people that you want to leave listeners with? Or we're going to have a lightning round coming up, but before we get that, we ended on a really powerful, impactful note. Is there anything else along these lines that you think might be helpful for people that you want to leave them with?

**中文翻译:**
是的，一个重要的提醒。J.M.，我们聊了很多内容。在进入闪电轮环节之前，还有什么你觉得对大家有帮助、想留给听众的吗？我们刚才结束在一个非常有力量、有冲击力的话题上。沿着这个思路，还有什么想分享的吗？

---

### [01:05:01] [John Mark Nickels]

**English:**
The one thing I'd encourage folks to do out of all of these we talked about is to see if you'd be willing to commit to breaking out of victim consciousness and mentality. And it's not to say there aren't victims in the world, there are real injustices and things happening, but most of us, I've experienced, I often can fall into the trap of living my life at the effect of, right? I'm at the effect of other people and what they do. I'm at the effect of circumstances like COVID or Trump or whatever. I'm at the effect of the conditions and circumstances of life, and I feel like life is happening to me.
(01:05:39):
And so to me, the most empowering and radical transformation that I've been able to cultivate and develop is shifting from that to a state of I I am willing to take responsibility for how I see the world. And I may not be able to change the weather or the election or all that, but I can change how I'm being in relationship to it and choose to see it as a growth opportunity, as learning, how am I co-creating it, even things that I play a small part in, injustice in the world, how am I perpetuating that and being willing to see the world as I'm the painter of my existence?
(01:06:11):
I think Viktor Frankl's Man's Search for Meaning is probably the best example of that. He's in a super oppressive situation that is very horrific and tragic, and the way he described his relationship with the people in the camp and the guards, and he given he gave a talk after he was free, the amount of compassion and empathy he had for his oppressors was just amazing. So I'm like, well, if he can do that in the face of those conditions, I can show up differently in a product review or in a conversation with my partner or meeting or whatever it is.

**中文翻译:**
在所有这些讨论中，我最想鼓励大家做的一件事是：看看你是否愿意承诺摆脱“受害者意识”和心态。这并不是说世界上没有受害者，确实存在不公正和悲剧。但在我的经验中，我们大多数人经常掉进一个陷阱，即生活在“被动受影响”的状态中，对吧？我受别人行为的影响，我受 COVID 或政治局势等环境的影响。我受生活条件的影响，我觉得生活是“发生在我身上”的。
(01:05:39):
对我来说，我所能培养出的最强大、最彻底的转变，就是从那种状态转变为：我愿意为我如何看待世界负责。我可能无法改变天气或选举，但我可以改变我与这些事物的关系，选择将其视为成长的机会、学习的机会。思考我是如何参与共同创造这些局面的？即使是我参与的一小部分，比如世界上的不公，我是如何让它持续存在的？并愿意将世界看作：我是我存在的画师。
(01:06:11):
我认为维克多·弗兰克尔（Viktor Frankl）的《活出生命的意义》（Man's Search for Meaning）是最好的例子。他处于极其压抑、恐怖和悲惨的境地，但他描述自己与集中营里的人和守卫的关系，以及他获释后的演讲，他对压迫者表现出的同情和共情简直令人惊叹。我想，如果他在那种条件下都能做到，那么我在产品评审、与伴侣的谈话或会议中，也一定能以不同的姿态出现。

---

### [01:06:46] [Lenny Rachitsky]

**English:**
Yeah, I think just that skill alone is such a powerful unlock for a lot of people instead of, here's all the things that I don't have and here's all the things that are setting you back and all the things that are hard for me versus other people. Shifting to, I need to take responsibility for my own success and no one else will. And just taking agency is a really powerful thing. It's easier said than done. There's a lot of hardships. People have a lot of things that they don't have that other people have that are hurting their career and hurting their ability to be successful, but still, the more you can take responsibility and have agency and the less you have this victim mentality, I 1,000% agree, there's so much power there. So that's an awesome lesson to end on. With that, we've reached our very exciting lightning round jam. Are you ready?

**中文翻译:**
是的，我认为单就这一项技能对很多人来说就是一个强大的开启。不再去想“我没有什么”、“是什么在阻碍我”、“为什么我比别人更难”，而是转向“我需要为自己的成功负责，没人会替我负责”。拥有主观能动性（agency）是一件非常强大的事情。这说起来容易做起来难，确实有很多困难，人们确实面临很多不公平，这些都在伤害他们的职业生涯和成功的能力。但即便如此，你越能承担责任、拥有主观能动性，越少有受害者心态，我就 1000% 地同意，其中蕴含着巨大的力量。这是一个很棒的结语。现在，我们进入了非常令人兴奋的闪电轮环节。准备好了吗？

---

### [01:07:34] [John Mark Nickels]

**English:**
I'm ready. Let's do it.

**中文翻译:**
准备好了。开始吧。

---

### [01:07:35] [Lenny Rachitsky]

**English:**
Okay. First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
好。第一个问题，你向别人推荐最多的两三本书是什么？

---

### [01:07:41] [John Mark Nickels]

**English:**
In the realm of the soft skills and conscious leadership, the best one is the 15 Commitments of Conscious Leadership by Diana Chapman and Jim Dethmer. And those were my early coaches and teachers almost 10 years ago, and Diana is still my coach. So I think that's a fantastic book that we'll go into more detail about some of the things we talked about around fear and threat versus trust and drawing a triangle and all that great stuff. That'd be one that I'd definitely recommend first. Another one more in the content world is I think you had Nancy Duarte on your podcast one point.
(01:08:17):
I love her book Resonate. I know she has some other ones too, on slide design and stuff. But what was so cool about that, I gave it to PMs all the time when I'm trying to help them develop their communication, storytelling, and presentation skills. And she goes through those TED talks and Martin Luther King, I have a dream, and going to the Moon, and basically make the spark line against it to understand this concept of resonance with the audience. It's actually a great skill for, back to vision and north-starring, she said what all these things do is they alternate tension between the world as it is and the world as it might be. And it's like, here's that beautiful future of transportation, San Francisco, blah, blah, blah, but here's why it sucks today, all these problems and this and that, but here's how it could look in a few years.
(01:09:05):
And then you're creating that tension and the audience at the end is like sweaty palms and like, "I want to help build that future." What do you need? You need money, you need time, resources, join your company. Great. So anyway, Resonate, Nancy Duarte, great book. Those would be some of the top two that I recommend. There's not one specific book, but I really love Alan Watts' books if you're into... He was one of the first people to articulate and kind of import Buddhism and that sort of Eastern thinking into the West, and he just has a very satirical, comical sort of not taking myself too seriously style and just like the way he explains a lot of those concepts. So that'd be another one.

**中文翻译:**
在软技能和意识领导力领域，最好的一本是 Diana Chapman 和 Jim Dethmer 写的《意识领导力的 15 个承诺》（The 15 Commitments of Conscious Leadership）。他们是快 10 年前我的早期教练和老师，Diana 现在仍是我的教练。这是一本极好的书，详细介绍了我们谈到的恐惧与威胁 vs 信任、画三角形等精彩内容。这是我首推的一本。另一本更偏向内容创作领域，我想你之前请过 Nancy Duarte 上播客。
(01:08:17):
我非常喜欢她的书《共鸣》（Resonate）。我知道她还有关于幻灯片设计之类的书。但这本书太酷了，当我试图帮助 PM 提升沟通、讲故事和演示技能时，我总是把这本书给他们。她分析了 TED 演讲、马丁·路德·金的《我有一个梦想》、登月计划，并画出了“火花线”（spark line）来理解与观众共鸣的概念。回到愿景和北极星指标，她说这些伟大的演讲所做的就是：在“现实世界”和“理想世界”之间交替制造张力。比如：“这是未来交通的美好愿景，旧金山，等等；但这是为什么现状很糟糕，有这么多问题；而这是几年后它可能的样子。”
(01:09:05):
你创造了那种张力，观众最后会手心冒汗，心想：“我想参与建设那个未来。”你需要什么？钱、时间、资源，还是加入你的公司？没问题。总之，Nancy Duarte 的《共鸣》是一本好书。这是我推荐的前两本。另外，如果你感兴趣，我非常喜欢 Alan Watts 的书。他是最早将佛教和东方思想引入西方的人之一，他的风格非常讽刺、幽默，不把自己太当回事，他解释那些概念的方式很棒。

---

### [01:09:47] [Lenny Rachitsky]

**English:**
He also has an amazing voice if you listen to recordings of him with music, it's just so fun to listen to.

**中文翻译:**
如果你听过他配着音乐的录音，他的声音也非常迷人，听起来很有趣。

---

### [01:09:52] [John Mark Nickels]

**English:**
Totally. Actually, Sam Harris's Waking Up app now has the entire... he worked with I think Alan Watts' son. So the Waking Up app has all 80 or 100 hours of recorded Alan Watts lectures.

**中文翻译:**
完全正确。实际上，Sam Harris 的 Waking Up 应用现在有完整的……我想他是和 Alan Watts 的儿子合作的。所以 Waking Up 应用里有全部 80 到 100 小时的 Alan Watts 演讲录音。

---

### [01:10:03] [Lenny Rachitsky]

**English:**
Oh my god. There's YouTube videos. There's some awesome YouTube videos of him that are worth watching, we'll link to some of those. And then Nancy Duarte, she shared exactly that lesson on the podcast that we had together. So if you don't want to read the book and listen to her give this tactic of this way to communicate a vision, you can listen to that episode, we'll link to it. Next question, do you have a favorite recent movie or TV show you have really enjoyed?

**中文翻译:**
天哪。YouTube 上也有一些他非常棒的视频值得一看，我们会放上链接。至于 Nancy Duarte，她在我们的播客节目中也分享了那个技巧。所以如果你不想看书，想听她讲解如何沟通愿景，可以听那一集，我们也会放链接。下一个问题，你最近有没有特别喜欢的电影或电视节目？

---

### [01:10:28] [John Mark Nickels]

**English:**
Yeah. The last movie I really enjoyed was Inside Out 2 with my kids, which is very-

**中文翻译:**
是的。我最近非常喜欢的是和孩子们一起看的《头脑特工队 2》（Inside Out 2），这非常——

---

### [01:10:34] [Lenny Rachitsky]

**English:**
I could see why you'd love that.

**中文翻译:**
我能理解你为什么喜欢那个。

---

### [01:10:36] [John Mark Nickels]

**English:**
Yes, consistent with the emotional awareness and allowing the different emotional parts and don't want to spoil the movie, maybe everyone hasn't seen it, but it's very simpatico with that lesson of you can't just let one emotion run the show, they all have wisdom. On the first one, Sadness, Joy learning that Sadness is necessary. It's all about integration, but it was beautiful the way kids understand it and it's a way to teach emotional literacy to your kids. So I think what they've done there with those Inside Out movies is just brilliant.

**中文翻译:**
是的，这与情感觉知和接纳不同的情感部分非常一致。我不想剧透，也许还有人没看，但它非常契合那个道理：你不能只让一种情绪主导，它们都有智慧。在第一部里，乐乐（Joy）学到了忧忧（Sadness）是必不可少的。这关乎整合。电影让孩子们理解这一点的方式非常美妙，也是教孩子情感素养的一种方式。我觉得《头脑特工队》系列做得非常出色。

---

### [01:11:06] [Lenny Rachitsky]

**English:**
Do you have a favorite product you've recently discovered that you really love? It could be an app, it could be something physical.

**中文翻译:**
你最近有没有发现什么特别喜欢的产品？可以是 App，也可以是实物。

---

### [01:11:11] [John Mark Nickels]

**English:**
Yeah, so Eight Sleep is a smart mattress company. They're on their third or fourth rev now, but it's like a Tempur-Pedic mattress, or you can put their cover on any mattress, but it has a cover that has little tubes of water, and then it has a little computer thing and you fill with water and then an app. And basically what you do is you program it and it learns, it has sensors, it can measure your heart rate, your HRV, body temperature, all that, but you're basically trying to program a temperature curve to help you maximize your kind of REM sleep and deep sleep and get more value out of the sleep that you do have.
(01:11:41):
And so for me, it's super cool early for deep sleep, and then it warms you up as you want to wake up, which is... or an alarm and all that. But it's back to my thing about wanting to show up with the right mindset and energy and aliveness. Having really high quality sleep has been a really key part of that, is like if I don't sleep well, I didn't get enough sleep or didn't sleep well, you're already starting off on a bad foot. So yeah, if you haven't checked out Eight Sleep, great product. No endorsement fee for me.

**中文翻译:**
有的，Eight Sleep 是一家智能床垫公司。他们现在已经出到第三或第四代了。它像是一个泰普尔（Tempur-Pedic）床垫，或者你可以把他们的床罩套在任何床垫上。床罩里有细小的水管，连接着一个小型电脑装置，你往里加水，然后通过 App 控制。基本上你可以对它进行编程，它会通过传感器学习并测量你的心率、HRV（心率变异性）、体温等。你实际上是在设定一个温度曲线，以帮助你最大化快速眼动睡眠（REM）和深度睡眠，提升睡眠质量。
(01:11:41):
对我来说，它在深度睡眠阶段保持凉爽非常棒，然后在你想起床时慢慢变暖，或者作为闹钟。这回到了我说的：想要以良好的心态、能量和活力出现，高质量的睡眠是关键。如果我没睡好或睡眠不足，一天就开始得不顺。所以，如果你还没试过 Eight Sleep，那是个很棒的产品。我没收代言费。

---

### [01:12:12] [Lenny Rachitsky]

**English:**
What's also cool about it is it tracks your sleep. It gives you all these stats. Instead of wearing a ring, and it gives you all these stats about your sleep quality. And there's this guy, Brian Johnson, I don't know if you follow him, he's like this guy that's trying to stay alive as long as possible, and he had a perfect sleep score for six months in a row to set the record.

**中文翻译:**
它很酷的一点是能追踪睡眠并提供统计数据，而不需要戴戒指。有个叫 Brian Johnson 的人（不知道你有没有关注他），他致力于尽可能长寿，他曾连续六个月获得完美的睡眠评分，创下了纪录。

---

### [01:12:30] [John Mark Nickels]

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:12:30] [Lenny Rachitsky]

**English:**
Yeah. He knows what he's doing over there. Okay, two more questions. Do you have a favorite life motto that you often come back to, think of, find useful in work or in life?

**中文翻译:**
是的，他很有一套。好，最后两个问题。你有没有什么特别喜欢的人生格言，是你经常回想、觉得在工作或生活中很有用的？

---

### [01:12:42] [John Mark Nickels]

**English:**
Yeah, I probably have had different ones over the years. The one right now that really serves me is there's this track called Sit Around the Fire by Jon Hopkins, but it's on Spotify, Apple Music, but it's basically music with one of Ram Dass' talks, lesser known talks. And so the mantra that's been really serving me recently is the very first part of that, which is he says, "Beyond all polarities, I am. Let the judgments and opinions of the mind be the judgments and opinions of the mind. And you exist behind that." So sometimes I have an abbreviated version of that where I'm noticing I'm activated, I'm clinging to an opinion, I'm arguing with somebody, and I'm just like, "Beyond all polarities."

**中文翻译:**
有的，这些年来我换过不同的格言。目前对我最有帮助的是 Jon Hopkins 的一首歌叫《坐在火堆旁》（Sit Around the Fire），它在 Spotify 和 Apple Music 上都有。它基本上是配乐加上拉姆·达斯（Ram Dass）的一次不太出名的演讲。最近一直激励我的咒语是其中的第一部分，他说：“超越所有极性，我即是我。让头脑的评判和意见留在头脑里，而你存在于那之后。”所以有时我会用它的缩减版，当我察觉到自己被激怒、固执己见或与人争论时，我会对自己说：“超越所有极性。”

---

### [01:13:44] [John Mark Nickels]

**English:**
I do that in front of my kids and they laugh at me like, "Daddy is so weird sometimes."

**中文翻译:**
我在孩子们面前这么做，他们会笑话我：“爸爸有时候真奇怪。”

---

### [01:13:47] [Lenny Rachitsky]

**English:**
Beyond all polarities, kids. That's so funny. Oh man. There's another Ram Dass line that I often use with my wife, Be Here Now, which is the title of his book that everyone sees with the blue cover. And I do that when she's on her phone and we're doing something. I'm like, "Be here now." And she's like, "Okay, okay. I'll put my phone away." Yeah. Final question. I was going to ask you about the line tracking and what you learned from that. You already shared an awesome lesson from that time. So let me ask you something else. I'll ask you about Travis. Any crazy, fun, memorable stories of working with Travis Kalanick? However you say his last name, Kalanick, Kalanick?

**中文翻译:**
“超越所有极性，孩子们。”太逗了。噢伙计，拉姆·达斯还有一句话我经常对妻子说：“活在当下”（Be Here Now），那是他那本蓝色封面书的名字。当她在玩手机而我们在做别的事时，我会说：“活在当下。”她会说：“好吧，好吧，我把手机收起来。”最后一个问题，我本来想问你关于交易员时期的经历，但你已经分享了一个很棒的教训。所以我问点别的，关于 Travis。在与 Travis Kalanick 共事期间，有没有什么疯狂、有趣或难忘的故事？（无论他的姓怎么读，Kalanick 还是 Kalanick？）

---

### [01:14:27] [John Mark Nickels]

**English:**
Travis Kalanick, yeah. Yeah. I'll share a quick one that's short but sweet or hilarious to me, and maybe lesser known. So we used to have the Uber office at 1455 Market, and so there was one conference room where we'd often do reviews with Travis, and it wasn't the war room, whatever whenever room it was. That was interior and no windows. So this room had windows overlooking, what was that? 11th street. So 11th and Market. And so we'd have a presentation up on the projector, some big screen we're about to go through something with Travis. And reliably, every time he'd come in, he would close the blinds of the windows. Everyone like, "Travis, what are we doing?" It's not because there was glare. They were orthogonal to the screen. And then one time I was like, "Why are you doing that?" He's like, "I'm pretty sure Lyft has drones outside the windows of our office and they're spying on our presentation."

**中文翻译:**
Travis Kalanick，是的。我分享一个简短但对我来说很搞笑、可能不太为人知的故事。我们以前在 Market 街 1455 号办公，有一间会议室我们经常和 Travis 在那里做评审。那不是“作战室”，那间房有窗户，俯瞰着第 11 街。我们会把演示文稿投在大屏幕上准备开始。每次 Travis 进来，他都会雷打不动地拉上窗帘。大家会问：“Travis，你在干嘛？”并不是因为反光，窗户和屏幕是垂直的。有一次我问：“你为什么要拉窗帘？”他说：“我敢肯定 Lyft 在我们办公室窗外停了无人机，正在偷看我们的演示文稿。”

---

### [01:15:19] [Lenny Rachitsky]

**English:**
Oh my gosh.

**中文翻译:**
我的天呐。

---

### [01:15:23] [John Mark Nickels]

**English:**
I was like, whoa, your competitor paranoia runs deep, man. Okay. Yeah, yeah. Anyway.

**中文翻译:**
我当时想：哇，伙计，你对竞争对手的偏执真的很深。好吧，总之。

---

### [01:15:32] [Lenny Rachitsky]

**English:**
It's hard to mention Lyft doing that. I could see Uber doing that to Lyft.

**中文翻译:**
很难想象 Lyft 会干这种事，但我能想象 Uber 对 Lyft 干这种事。

---

### [01:15:36] [John Mark Nickels]

**English:**
Old Uber. Uber 1.0

**中文翻译:**
那是老 Uber，Uber 1.0。

---

### [01:15:38] [Lenny Rachitsky]

**English:**
Old Uber. Yeah. Wow. That's amazing. It's like coaches in the NFL that are covering their lips always when they're telling and giving plays, just like, I wonder if people actually do that. That's amazing. Yeah, I get that. It's like high stakes. You never know. Might be a drone out there.

**中文翻译:**
老 Uber，是的。哇，太神奇了。就像 NFL 的教练在布置战术时总是捂着嘴，我好奇是不是真的有人在偷看。这太绝了。我能理解，毕竟赌注很高，谁知道呢，也许外面真有无人机。

---

### [01:15:54] [John Mark Nickels]

**English:**
Right.

**中文翻译:**
没错。

---

### [01:15:54] [Lenny Rachitsky]

**English:**
Amazing. J.M., what a roller coaster of a conversation. We covered so much ground. I can't even name all the things we covered. So let me just ask you two final questions. Where can folks find you online and reach out if they want to work with you? I know you work with folks, talk about that. And then finally, how can listeners be useful to you?

**中文翻译:**
太棒了。J.M.，这次对话真像过山车一样精彩。我们聊了太多内容，我都数不过来了。最后问两个问题：大家可以在哪里找到你？如果想和你合作该如何联系？我知道你也在做教练工作，聊聊这个。最后，听众们能为你做些什么？

---

### [01:16:13] [John Mark Nickels]

**English:**
Yeah, yeah. So I am occasionally on Twitter @NickelsJM, but I don't tweet a lot, but maybe I should start. But the best way to find more about my thoughts and thinking on the soft skill stuff is a website called rhythmofbeing.com. And I've got some blog posts and stuff there that go into detail on some of these things. And yeah, I do a little bit of coaching on the side with folks. I do very little now. My day job at Uber and my night job with my kids takes up most of my waking hours. But for the right person and a few select spots, I can make time. But yeah, that's the best place to find me, is rhythmofbeing.com.

**中文翻译:**
好的。我偶尔会上 Twitter，账号是 @NickelsJM，但我发得不多，也许我该开始多发点。但了解我关于软技能想法的最好方式是我的网站 rhythmofbeing.com。我在那里写了一些博客文章，详细介绍了今天谈到的一些内容。另外，我确实在业余时间做一点教练工作。现在做得很少，因为我在 Uber 的全职工作和晚上陪孩子几乎占据了我所有的清醒时间。但对于合适的人，如果还有名额，我可以挤出时间。总之，最好的联系方式是 rhythmofbeing.com。

---

### [01:16:55] [Lenny Rachitsky]

**English:**
And then how can listeners be useful to you?

**中文翻译:**
那听众们能为你做些什么？

---

### [01:16:57] [John Mark Nickels]

**English:**
Well, in the spirit of welcoming and embracing feedback, you could most be useful by reaching out, telling me what resonated, what didn't, what was useful, where did your energy go up when I talked, and where did your energy go down? Because that to me is a signal of where I'm back to tracking the life, where's the juice? And then that way in the future when I do other versions of this or other conversations, I'll pay more attention to the energy up stuff and go more there, and the energy down was like, okay, maybe that wasn't as interesting or didn't resonate. Great. No problem.

**中文翻译:**
本着欢迎和拥抱反馈的精神，大家对我最大的帮助就是联系我，告诉我哪些内容引起了共鸣，哪些没有，哪些是有用的。当我说话时，你在哪里感到兴奋（能量上升），在哪里感到乏味（能量下降）？对我来说，这是一个信号，让我追踪哪里更有生命力，哪里更有趣。这样以后当我再做类似的交流时，我会更多地关注那些让人兴奋的部分，而那些能量下降的部分，可能就是没那么有趣或没引起共鸣，那也没关系。

---

### [01:17:35] [Lenny Rachitsky]

**English:**
J.M., thank you so much for being here.

**中文翻译:**
J.M.，非常感谢你能来。

---

### [01:17:38] [John Mark Nickels]

**English:**
Thank you for having me.

**中文翻译:**
感谢邀请。

---

### [01:17:39] [Lenny Rachitsky]

**English:**
Bye everyone.
(01:17:42):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
各位再见。
(01:17:42):
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目再见。