# Jonathan Becker - 双语对照

This is the complete bilingual transcript for **Lenny’s Podcast** featuring **Jonathan Becker**.

---

### [00:00:00] Jonathan Becker

**English:**
There's a lot of different ways that we are beginning to use AI to do more with less, basically. The effect ultimately that we've seen from a human capital point of view is displacement. We have more people now than we've ever had, but the nature of the work that they do is more strategic. It's more about modeling, validation, asking the right questions, being focused around creative levers. And less so the like trench work of implementation and bid modifiers at the keyword level on Google search, and some of the really hardcore manual analysis we had to do.

**中文翻译:**
基本上，我们正开始通过许多不同的方式利用 AI 来实现“事半功倍”。从人力资本的角度来看，我们最终看到的效应是“位移”。我们现在的人员比以往任何时候都多，但他们工作的性质变得更具战略性。更多的是关于建模、验证、提出正确的问题，以及专注于创意杠杆。而不再是那些像在 Google 搜索的关键词层面进行执行和出价调整（bid modifiers）之类的“阵地战”工作，或者是我们以前必须做的那些非常硬核的手动分析。

---

### [00:00:35] Jonathan Becker

**English:**
On our creative group, we can come up with mockups, in literally, 1% of the time that it took. And so you still have to understand what questions to ask of the AI and be capable of iterating, but these rough drafts that you might show the artwork of to a client to say, "Do we like this more or do we like this more?" That's AI generated. It's really interesting.

**中文翻译:**
在我们的创意团队中，我们现在制作原型图（mockups）所需的时间简直只有以前的 1%。因此，你仍然需要理解该向 AI 提出什么问题，并具备迭代的能力，但这些你可能会展示给客户看并询问“我们更喜欢这个还是那个？”的艺术草案，现在都是 AI 生成的。这真的非常有趣。

---

### [00:01:01] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful products. Today my guest is Jonathan Becker. Jonathan is a legend and an OG in the world of performance marketing. On this podcast, we've done deep dives into the many aspects of growth, including SEO, sales, conversion optimization, retention, product led growth, product led sales. But this is the first episode where we get super deep on paid growth. 

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中辛勤换来的经验。今天的嘉宾是 Jonathan Becker。Jonathan 是绩效营销（Performance Marketing）领域的传奇人物和元老（OG）。在本播客中，我们深入探讨过增长的许多方面，包括 SEO、销售、转化优化、留存、产品驱动增长（PLG）和产品驱动销售。但这是我们第一集深入探讨“付费增长”（Paid Growth）的节目。

---

### [00:01:30] Lenny

**English:**
For the past decade plus, Jonathan and his team have planned, built, and executed more than $3.5 billion in paid acquisition budgets for companies like Uber, Asana, Square, Masterclass, Tempur-Pedic, and many more. And they've built their agency, Thrive Digital, into one of the preeminent independent digital marketing agencies. In our conversation, we get real deep into all things paid growth, including what's changed with recent privacy shifts, why focusing on creatives is the new biggest opportunity within paid growth. How to think about attribution, and what's changed there. What to look for in people you hire to run paid growth for you, how AI is already changing how paid growth teams operate, and so much more. Enjoy this episode with Jonathan Becker after a short word from our sponsors.

**中文翻译:**
在过去的十多年里，Jonathan 和他的团队为 Uber、Asana、Square、Masterclass、Tempur-Pedic 等公司规划、构建并执行了超过 35 亿美元的付费获客预算。他们将自己的代理机构 Thrive Digital 打造成为最卓越的独立数字营销机构之一。在我们的对话中，我们将深入探讨付费增长的所有细节，包括近期隐私政策变化带来的影响，为什么关注创意素材（Creatives）是付费增长中新的最大机会。如何思考归因（Attribution）以及该领域的变化。在招聘负责付费增长的人员时应看重什么，AI 如何改变付费增长团队的运作方式，等等。在听完赞助商的简短介绍后，请欣赏与 Jonathan Becker 的这集节目。

---

### [00:02:16] Lenny (Sponsor Break - Brain Trust)

**English:**
This episode is brought to you by Brain Trust, where the world's most innovative companies go to find talent fast so that they can innovate faster. Let's be honest, it's a lot of work to build a company. And if you want to stay ahead of the game, you need to be able to hire the right talent quickly and confidently. Brain Trust is the first decentralized talent network where you can find, hire, and manage high quality contractors in engineering, design, and product for a fraction of the cost of agencies. Brain Trust charges a flat rate of only 10%, unlike agency fees of up to 70%, so you can make your budget go four times further. Plus, they're the only network that takes 0% of what the talent makes, so they're able to attract and retain the world's best tech talent. Visit usebraintrust.com/lenny.

**中文翻译:**
本集节目由 Brain Trust 赞助。全球最具创新力的公司都在这里快速寻找人才，以便更快地进行创新。坦白说，创办一家公司需要做很多工作。如果你想保持领先，你需要能够快速且自信地聘请到合适的人才。Brain Trust 是首个去中心化的人才网络，你可以在这里以远低于代理机构的成本寻找、聘用和管理工程、设计和产品领域的高质量承包商。Brain Trust 仅收取 10% 的固定费率，而不像代理机构那样收取高达 70% 的费用，因此你可以让预算发挥四倍的作用。此外，他们是唯一一个不从人才收入中抽成的网络，因此能够吸引并留住世界上最顶尖的技术人才。请访问 usebraintrust.com/lenny。

---

### [00:03:35] Lenny (Sponsor Break - AssemblyAI)

**English:**
Today's episode is brought to you by AssemblyAI. If you're looking to build AI powered features in your audio and video products, then you need to know about AssemblyAI, which makes it easy to transcribe and understand speech at scale. What I love about AssemblyAI, is you can use their simple API to access the latest AI breakthroughs from top tier research labs. Product team that startups and enterprises are using AssemblyAI to automatically transcribe and summarize phone calls and virtual meetings, detect topics in podcasts, pinpoint when sensitive content is spoken, and lots more. Visit AssemblyAI.com/lenny to try their API for free.

**中文翻译:**
今天的节目由 AssemblyAI 赞助。如果你正寻求在音频和视频产品中构建 AI 驱动的功能，那么你需要了解 AssemblyAI，它能让你轻松地大规模转录和理解语音。我喜欢 AssemblyAI 的一点是，你可以通过他们简单的 API 访问来自顶级研究实验室的最新 AI 突破。初创公司和企业的项目团队正在使用 AssemblyAI 自动转录和总结电话及虚拟会议、检测播客中的主题、精准定位敏感内容等。访问 AssemblyAI.com/lenny 免费试用他们的 API。

---

### [00:04:46] Lenny

**English:**
Jonathan, welcome to the podcast.

**中文翻译:**
Jonathan，欢迎来到播客。

---

### [00:04:48] Jonathan Becker

**English:**
Thank you. It's a pleasure to be here.

**中文翻译:**
谢谢。很高兴来到这里。

---

### [00:04:50] Lenny

**English:**
It's my pleasure. What we're going to be doing with this episode, is we're going to be digging real deep into all things paid growth, which we've never done on this podcast yet. And normally I actually skip this part, but I thought it'd be actually helpful for you to spend a little bit of time to give us a little bit of background on your experience in the space of performance marketing, AKA paid growth, AKA paid ads. You tell us what the right term is for this genre. But yeah, just tell us what you've been up to in this area over the past decade and a half, I think.

**中文翻译:**
这是我的荣幸。在这一集里，我们将深入挖掘付费增长的所有内容，这是我们播客以前从未做过的。通常我会跳过背景介绍环节，但我认为让你花一点时间介绍一下你在绩效营销（又名付费增长，又名付费广告）领域的背景会很有帮助。你可以告诉我们这个领域的准确术语是什么。总之，请告诉我们你在过去大约 15 年里在这个领域都做了些什么。

---

### [00:05:20] Jonathan Becker

**English:**
Sure. No, that's a great way to kick things off. And again, thank you for having me here. If I think about it, my experience goes back about 15 years into this space. I started off as a web developer. And as I built and structured websites for people, I became pretty obsessed and fascinated with the fact that you could build landing pages or homepages, or whatever it was. Basically the content on a website, and structure it in a manner where you had the chance to surface in organic, so SEO results more prominently. And as I became a practitioner of SEO, SEO really being my first love of marketing, I started attracting attention and people wanted to hire me on as a freelancer. 

**中文翻译:**
好的，这是一个很好的开始。再次感谢邀请我。回想起来，我在这个领域的经验可以追溯到 15 年前。我最初是一名 Web 开发人员。当我为人们构建和组织网站结构时，我开始痴迷并着迷于这样一个事实：你可以构建落地页或首页，或者任何东西，基本上就是网站上的内容，并以某种方式组织它，让你有机会在自然搜索（即 SEO 结果）中更显著地出现。随着我成为一名 SEO 从业者——SEO 确实是我对营销的“初恋”——我开始引起关注，人们想聘请我做自由职业者。

---

### [00:06:25] Jonathan Becker

**English:**
And what I noticed is that as people started asking me questions like, what was the ROI of our SEO campaign? Or, how do I scale this, or whatnot? The answers to their questions ended up being a lot more aligned with what then was the biggest driver in the paid acquisition world, which was paid search. And so I started experimenting with paid search. And what I found was that it was a tangible format and lever through which we could basically give people the types of results they were expecting from SEO, but that were obfuscated in terms of Google's analysis algorithm from an organic point of view being somewhat intangible. 

**中文翻译:**
我注意到，当人们开始问我诸如“我们 SEO 活动的 ROI（投资回报率）是多少？”或者“我该如何规模化这个项目？”之类的问题时，这些问题的答案最终与当时付费获客领域最大的驱动力——付费搜索（Paid Search）——更加契合。于是我开始尝试付费搜索。我发现这是一种实实在在的形式和杠杆，通过它，我们基本上可以给人们提供他们期望从 SEO 中获得的那种结果，但 SEO 在 Google 的分析算法中从自然搜索的角度来看是有些模糊且难以捉摸的。

---

### [00:07:05] Jonathan Becker

**English:**
Google slowly removing a lot of the data early on that allowed you to guess and test more easily. 10 plus years later, what started off as this freelancer consultancy that I started running in a walk-in closet in my old apartment, became 130 people. And we manage about $500 million a year in ad spend for small and large companies, including Uber, Asana, Tempur-Pedic. We've worked with Lululemon. Very exciting companies, mostly from the United States, even though we randomly happen to be based in Vancouver, Canada.

**中文翻译:**
Google 早期慢慢移除了一些能让你更容易进行猜测和测试的数据。10 多年后，最初我在旧公寓的衣帽间里经营的自由职业咨询业务，已经发展到了 130 人的规模。我们每年为大大小小的公司管理约 5 亿美元的广告支出，包括 Uber、Asana、Tempur-Pedic。我们还与 Lululemon 合作过。这些都是非常令人兴奋的公司，大多来自美国，尽管我们公司恰好总部设在加拿大的温哥华。

---

### [00:07:26] Lenny

**English:**
There's a number of threads I'm going to pull on there over the course of our chat. But you mentioned Uber and you told me that you had a crazy story about how you actually landed Uber as a customer. Could you share that?

**中文翻译:**
在我们的聊天过程中，我会深入探讨其中的几个点。但你提到了 Uber，你曾告诉我你有一个关于如何赢得 Uber 这个客户的疯狂故事。你能分享一下吗？

---

### [00:07:35] Jonathan Becker

**English:**
I had been running Thrive for a couple years, and it was a very excellent regional agency in Canada with really cool local clients. In 2013, I got invited to go down to the TED conference, which was in Long Beach, California. And my friend Andrew Wilkinson asked me to join him at a dinner that night. I didn't know anybody from the TED community at the time. So we have dinner, and then afterwards as it goes at conferences, there's an after party. And so essentially I hop into a taxi, everybody else sped off in their cars, or however which way they were getting there. And as we're talking to the driver saying, "Hey, we're going to this place, can you take us?" There's a knock on the window and the person outside says, "Hey, I think I'm heading to the same destination. Do you mind if I hop in this car with you?"

**中文翻译:**
当时我经营 Thrive 已经几年了，它在加拿大是一家非常优秀的地区性代理机构，拥有一些很酷的本地客户。2013 年，我受邀参加在加州长滩举行的 TED 大会。我的朋友 Andrew Wilkinson 邀请我当晚一起吃晚饭。当时我不认识 TED 社区的任何人。我们吃完饭后，按照会议的惯例，有一个后续派对。于是我跳进了一辆出租车，其他人要么自己开车，要么以其他方式赶过去。当我们正跟司机说“嘿，我们要去这个地方，你能载我们吗？”时，有人敲了敲窗户，外面的人说：“嘿，我想我也要去同一个目的地。你介意我跟你拼车吗？”

---

### [00:08:25] Jonathan Becker

**English:**
And so we're like, of course. And I turn to him and I'm like, "I'm Jonathan. I run a 10 person agency out of Vancouver." And he says, "Hey, I'm Garrett Camp. I started a company called Uber." And so ironically, I meet the founder of Uber, the company that is in the process of disrupting the entire taxi industry worldwide in the back of a taxi cab. And what happened next basically changed my career forever. We end up at this party. At the time I was spamming Uber's referral program. Kind of a long story, but essentially I was using paid search to camp out on their branded keywords. And as people would sign up with my confusingly similar snippet to Uber's organic snippet, I was essentially siphoning off referral credits. So I would get $20 every single time someone signed up.

**中文翻译:**
我们说，当然可以。我转向他自我介绍说：“我是 Jonathan，在温哥华经营一家 10 人的代理机构。”他说：“嘿，我是 Garrett Camp，我创办了一家叫 Uber 的公司。”讽刺的是，我在出租车的后座遇到了 Uber 的创始人，而这家公司当时正处于颠覆全球出租车行业的过程中。接下来发生的事情基本上永远改变了我的职业生涯。我们最后到了派对。当时我正在“薅” Uber 推荐计划的羊毛。说来话长，但基本上我是利用付费搜索守在他们的品牌关键词上。当人们点击我那个与 Uber 自然搜索片段极其相似的广告并注册时，我实际上是在吸走推荐奖励。每当有人注册，我就会得到 20 美元。

---

### [00:09:18] Jonathan Becker

**English:**
And I ended up making tens of thousands of dollars doing this. And so fast-forward, I'm getting a drink at the bar next to Garrett, and in my head I'm like, should I tell him about this? Maybe I can land them as a client. This would be really interesting. And essentially I tell him, I'm like, "Hey, I'm doing this. I'm adding zero value, but this is a loophole in your marketing system, and someone should close it." He essentially is like, "I need to report this to the board, but here's my card, write me what you're doing and we'll contact you." And so I get contacted by a bunch of his lieutenants. If you've read the book, Super Pumped. All the people that we dealt with at the time are in the book.

**中文翻译:**
我通过这种方式赚了几万美元。镜头拉回到派对，我在吧台边遇到 Garrett 正在喝酒，我心里想：我该告诉他这件事吗？也许我能让他们成为我的客户。这会很有趣。于是我直接告诉他：“嘿，我正在干这事。我没创造任何价值，但这是你们营销系统的一个漏洞，得有人把它堵上。”他基本上是说：“我需要向董事会报告这件事，但这是我的名片，写信告诉我你具体是怎么做的，我们会联系你。”后来，他的几名部下联系了我。如果你读过《超级澎湃》（Super Pumped）那本书，我们当时打交道的所有人都在书里。

---

### [00:09:58] Lenny

**English:**
I watched the show.

**中文翻译:**
我看过那部剧。

---

### [00:10:00] Jonathan Becker

**English:**
Yeah, exactly. And they were like, "Hey, this is bad, you have to stop doing this. But can we hire you to solve the problem?" And so what started off as me running projects for local bars in Vancouver, or clothing stores, or whatever it was. Turned into me landing early stage Uber as a client, and really graduating us from competent professionals to leaders in our sector. And so it was a fascinating project, and we worked with Uber for 10 years.

**中文翻译:**
没错。他们说：“嘿，这很糟糕，你必须停止这么做。但我们能不能聘请你来解决这个问题？”于是，原本只是为温哥华当地酒吧或服装店做项目的我，变成了签下早期 Uber 作为客户，这真正让我们从称职的专业人士晋升为行业的领导者。那是一个非常迷人的项目，我们和 Uber 合作了 10 年。

---

### [00:10:32] Lenny

**English:**
That is an incredible story. I love the arbitrage game you're running there. It's basically siphoning VC money out of Uber. And I guess the lesson there a little bit is just sometimes it's this interesting combination of hustle in terms of just make some money, and also taking advantage of this opportunity you were plopped into.

**中文翻译:**
这真是一个不可思议的故事。我喜欢你玩的那个套利游戏。基本上是在从 Uber 身上吸走风投资金。我想这里的教训是，有时候成功就是这种有趣的结合：一方面是努力赚钱的劲头（hustle），另一方面是利用好你恰好掉进去的机会。

---

### [00:10:53] Jonathan Becker

**English:**
Yeah. I think people often talk about entrepreneurs who have been successful and they comment that they're lucky. Whereas, I actually look at that situation and I think that you have to make your own luck. I could have been like, oh, cool, I met this guy in the back of a taxi and that was it. But I decided to take a risk, being that I could get embarrassed or nothing could happen, or they could shut down this referral gimmicky thing that I was doing. I had very little to lose, I guess, ultimately. But a lot of people just don't make these moves in life because they're nervous, or they're worried too much about what the downside might be. And so I very much was like, I'm going to shoot my shot here. And you put yourself in situations where everybody has luck, but you have to capitalize on it basically. And so that was an example of being willing to take a risk, and it paying off pretty big time I think.

**中文翻译:**
是的。我认为人们谈论成功的企业家时常说他们很幸运。但我看那种情况时，我认为你必须创造自己的运气。我本可以想：噢，太酷了，我在出租车后座遇到了这家伙，然后就没下文了。但我决定冒个险，尽管我可能会感到尴尬，或者什么都不会发生，或者他们可能会关掉我正在做的那个推荐奖励的小把戏。我想最终我几乎没有什么可失去的。但很多人在生活中就是不敢迈出这一步，因为他们紧张，或者太担心负面后果。所以我当时的想法是：我要试一试。你把自己置于某种境地，每个人都有运气，但你必须利用好它。那是一个愿意冒险并获得巨大回报的例子。

---

### [00:11:46] Lenny

**English:**
Also, being at Ted, that seems like a good move. Networking, paying off. Love that he was in a taxi, that's hilarious. I was going to ask you about that. And clearly, he's doing some research.

**中文翻译:**
而且，去参加 TED 似乎也是个明智之举。人脉经营起到了作用。我喜欢他在出租车里这个细节，太搞笑了。我正想问你这个呢。显然，他当时也在做调研。

---

### [00:11:58] Lenny

**English:**
Let's start diving into the world of paid growth. And if you think about just paid growth.. And again, actually, what do you refer to this area as? Paid growth, performance marketing, paid ads?

**中文翻译:**
让我们开始深入探讨付费增长的世界。如果你思考付费增长……顺便问一下，你通常怎么称呼这个领域？付费增长（Paid Growth）、绩效营销（Performance Marketing）还是付费广告（Paid Ads）？

---

### [00:12:08] Jonathan Becker

**English:**
There's a lot of interchangeable terms. Performance marketing is a common term. Paid acquisition is a common term. Some people think of those two things as growth marketing, whereas I see growth marketing as a bigger practice area within which paid acquisition sits. And then of course there's subsets, there's social ads, there's paid search, there's programmatic. And so there's a lot of different ways of saying the same thing.

**中文翻译:**
有很多可以互换的术语。绩效营销是一个常用词。付费获客（Paid Acquisition）也是。有些人把这两者都看作增长营销（Growth Marketing），而我把增长营销看作一个更大的实践领域，付费获客只是其中的一部分。当然还有子集，比如社交广告、付费搜索、程序化广告。所以有很多不同的说法来表达同一件事。

---

### [00:12:31] Lenny

**English:**
I'm going to use performance marketing. I like that term because it really describes what it is. It's like marketing with you can measure performance. Let's see how that goes. As a channel, it's such an interesting mix of, on the one hand it's this incredible growth lever that allows basically any company to spend money and understand the ROI and acquiring the users. This thing that never existed before. Essentially Facebook and Google created these platforms. On the other hand, there's this sense that it's this drug that you start and then you get hooked on and you can never leave. And there's a lot of advice of just, avoid paid growth. That's just not a good healthy way of growing, especially as a startup. And so my question to you is just, how do you think about that element of it? And then even more specifically, what products do you find paid growth as a channel is right for and not right for?

**中文翻译:**
我会用“绩效营销”这个词。我喜欢这个术语，因为它真实地描述了它的本质：你可以衡量绩效的营销。让我们看看这个话题。作为一个渠道，它是一个非常有趣的混合体：一方面，它是一个令人难以置信的增长杠杆，基本上允许任何公司花钱并了解获客的 ROI。这在以前是不存在的，基本上是 Facebook 和 Google 创造了这些平台。另一方面，人们觉得它像一种“毒品”，一旦开始就会上瘾，永远无法离开。有很多建议说要避开付费增长，认为这不是一种健康增长方式，尤其是对初创公司而言。所以我的问题是，你如何看待这一面？更具体地说，你认为付费增长作为渠道适合哪些产品，不适合哪些产品？

---

### [00:13:33] Jonathan Becker

**English:**
Performance marketing can be seen as a drug, I suppose, when you are entirely reliant on it to fuel the revenue of your business. The analogy that I try and use here is that it would be very dangerous if I was advising you with your life savings and I told you to put it all in a single stock in the stock market. Stocks can be volatile. And as a result of that, your net worth would fluctuate quite a bit in the short-term and the long-term based on a lot of things that you don't control, like the external markets, or things that are happening within the performance of that particular company that you invested in. 

**中文翻译:**
我想，当你完全依赖绩效营销来维持业务收入时，它确实可以被视为一种“毒品”。我尝试用的类比是：如果我建议你把所有的积蓄都投进股市里的一只股票，那将是非常危险的。股票可能会波动。因此，你的净资产会在短期和长期内大幅波动，这取决于很多你无法控制的因素，比如外部市场，或者你投资的那家公司的业绩表现。

---

### [00:14:15] Jonathan Becker

**English:**
When I think about all of the marketing mix, so email, direct mail, linear television, performance, marketing, whatever it is, I think about it as investing capital with the expectation of a return. And in the same manner that I would not take all of your life savings and dump it into a single stock, I don't recommend putting all of your money into a single performance marketing channel, and then somewhat exposing you to the volatility of fluctuating CPCs or changing market conditions. I would agree with you that it is a drug, in a sense, if you have all of your eggs in one basket, and that basket takes you on a very intense rollercoaster in terms of performance. 

**中文翻译:**
当我思考所有的营销组合——电子邮件、直邮、线性电视、绩效营销等等——我把它看作是带着回报预期的资本投资。同样地，我不会把你的全部积蓄投进一只股票，我也不建议把你所有的钱都投进单一的绩效营销渠道，因为这会让你暴露在 CPC（单次点击成本）波动或市场状况变化的风险中。我同意你的看法，从某种意义上说，如果你把所有的鸡蛋都放在一个篮子里，而那个篮子在绩效上让你坐上了剧烈的过山车，那它确实像毒品。

---

### [00:15:00] Jonathan Becker

**English:**
But when I think about the fact that Thrive manages $500 million a year, I think of myself to a extent as a fund manager, we are managing people's money with the expectation of a return. And part of the strategy is to diversify across channels. And so we decrease the reliance of any individual project on a singular channel and its performance. And similarly, I always say to people that the first rule of performance marketing is not to forget about offline marketing and the classic marketing that works for organizations. In other words, direct mail can really work, email marketing works beautifully, SEO can really work. There's all of these wonderful things at your disposal. 

**中文翻译:**
但考虑到 Thrive 每年管理 5 亿美元的支出，我在某种程度上把自己看作一名基金经理，我们在管理人们的资金并期望获得回报。策略的一部分是跨渠道多元化。因此，我们降低了任何单个项目对单一渠道及其表现的依赖。同样，我总是告诉人们，绩效营销的第一条规则是不要忘记线下营销和对组织有效的经典营销。换句话说，直邮可能非常有效，邮件营销效果极佳，SEO 也非常有用。你有很多绝佳的工具可以使用。

---

### [00:16:19] Jonathan Becker

**English:**
The real crash and burn scenarios that I've seen are these, not fly by night brands, but brands that figured out... Just like with Uber, I figured out this weird tie-in where I could make free money from their referral system. Sometimes people find shortcuts, hacks if you will, to scale rapidly because of one specific nuance of the Facebook ad platform, or something like that. And what they fail to see is that those loopholes come and go. And so if they scale massively and their entire business is predicated on the performance of this one loophole that they found, or investing everything in a single channel, and then the conditions change, they're not going to be very happy and the business will suffer dramatically. 

**中文翻译:**
我见过的真正“车毁人亡”的场景是那些——不是那种骗子公司，而是那些发现了一些……就像我对 Uber 做的那样，我发现了一个奇怪的关联，可以从他们的推荐系统中赚到免费的钱。有时人们会发现捷径或“黑客手段”，利用 Facebook 广告平台的某个特定细微差别来快速扩张。但他们没看到的是，这些漏洞是会消失的。如果他们大规模扩张，而整个业务都建立在他们发现的这一个漏洞之上，或者把一切都投在一个渠道上，一旦情况发生变化，他们会非常痛苦，业务也会遭受重创。

---

### [00:16:48] Lenny

**English:**
What about the second part of that question of when you think about when companies come to you. What do you look for to help you understand this is going to be a really good fit for performance marketing and this is going to give them a lot of opportunity to growth, versus maybe not, maybe it'll be a small sliver but it's not going to be a massive success for them?

**中文翻译:**
那问题的第二部分呢？当公司来找你时，你会看重什么，来判断这是否非常适合绩效营销并能给他们带来巨大的增长机会，还是说可能只是杯水车薪，不会带来巨大的成功？

---

### [00:17:06] Jonathan Becker

**English:**
Yeah. I would say that the answer to that question is different at different stages of a company's life cycle. Early stage, look at what the company is doing, look at your own company. Have you established product market fit? Is this an idea that has yet to be tested, and are they entirely looking to performance marketing to scale everything? Are they at risk of it becoming an over-reliance on performance marketing? At a later stage we look at certain criteria that they might or might not possess. Typically, that will come down to resourcing.

**中文翻译:**
是的。我会说，这个问题的答案在公司生命周期的不同阶段是不同的。在早期阶段，要看公司在做什么，看你自己的公司。你是否已经建立了产品市场匹配（PMF）？这是否是一个尚未经过测试的想法，而他们是否完全指望绩效营销来规模化一切？他们是否有过度依赖绩效营销的风险？在后期阶段，我们会看他们是否具备某些标准。通常，这归结为资源配置。

---

### [00:18:00] Jonathan Becker

**English:**
The question at a later stage is not, does it work? But, to what scale can it work? And so we are looking at things like, do they have adequate creative resources and buy-in? Does creative resourcing tie into performance, and can we create a feedback loop there around testing? I'll talk to you about that in a bit. Do they have professional marketers on staff? Are there people who have experience doing what we do, that speak our language so to speak? Or is part of this an organizational educational, and creating buy-in through stakeholders process that needs to take place? Do they have technical resources? If we say, "Hey, tracking and attribution is broken, here's how to solve that." Can you implement it? 

**中文翻译:**
后期阶段的问题不是“它有效吗？”，而是“它能达到多大的规模？”。所以我们会看：他们是否有充足的创意资源和内部支持？创意资源是否与绩效挂钩，我们能否围绕测试建立反馈闭环？稍后我会详细谈谈这个。他们是否有专业的营销人员？是否有经验丰富、懂我们行话的人？或者这是否涉及到一个组织教育和通过利益相关者建立共识的过程？他们是否有技术资源？如果我们说“嘿，追踪和归因出问题了，这是解决方法”，你们能执行吗？

---

### [00:18:27] Jonathan Becker

**English:**
There's no one magic formula for what works or what type of company will be successful on performance marketing channels. Just as evidence of this, Google, which I think had a down quarter reported sales this week, and it was $70 billion in three months. And Facebook similarly just recorded yesterday evening, and it was $32 billion. That's $100 billion on just Google and Facebook in three months, and the majority of that revenue is from ads. This works really well for lots of different companies, it's just a question of at what scale.

**中文翻译:**
对于什么有效，或者哪种类型的公司会在绩效营销渠道上取得成功，并没有唯一的灵丹妙药。作为证据，Google 本周报告的销售额（尽管我认为那是一个下滑的季度）在三个月内达到了 700 亿美元。Facebook 昨晚也报告了 320 亿美元。仅仅 Google 和 Facebook 在三个月内就有 1000 亿美元的收入，而其中大部分收入来自广告。这说明它对许多不同的公司都非常有效，只是规模大小的问题。

---

### [00:19:06] Lenny

**English:**
Just to pull an thread a little bit more. Something I've heard from other guests is that paid ads are best for products where you get basically payback really quickly, basically to feed the flywheel of spend so that you're not sitting around waiting for someone to buy something in the future, or it's a small trickle of pay. How important is that, I guess? Do you find that you could just do paid growth for any company, it doesn't matter their business model? Or is there something you're like, okay, this needs to exist for you to invest serious resources? And even hire that team that you just talked about.

**中文翻译:**
再深入探讨一下。我从其他嘉宾那里听到过，付费广告最适合那些回本（payback）非常快的产品，基本上是为了喂养支出的飞轮，这样你就不用坐等未来有人买东西，或者只有零星的收入。你觉得这有多重要？你认为付费增长适合任何公司吗，无论其商业模式如何？还是说你觉得必须具备某些条件，才值得投入大量资源，甚至去组建你刚才提到的那个团队？

---

### [00:19:37] Jonathan Becker

**English:**
It's always nice when there's a quick turnaround on investment and return. And that's wonderful for like D2C or e-commerce style businesses where they're essentially taking the revenue to fuel additional inventory and operating costs. However, not all businesses work that way. And so, in a B2C or B2B lead generation scenario, we have to undertake pretty sophisticated modeling around these abstract concepts, like lifetime value. Which is difficult, because most businesses are relatively new that we work with, and so the idea of lifetime value is a misnomer. They don't know what that is yet.

**中文翻译:**
投资和回报能快速周转当然很好。这对于 D2C（直面消费者）或电商类业务非常棒，因为他们基本上是用收入来支付额外的库存和运营成本。然而，并非所有业务都这样运作。因此，在 B2C 或 B2B 的潜在客户生成（Lead Gen）场景中，我们必须围绕一些抽象概念进行相当复杂的建模，比如终身价值（LTV）。这很难，因为我们合作的大多数业务都相对较新，所以“终身价值”这个概念有点名不副实，他们还不知道那是什么。

---

### [00:20:15] Jonathan Becker

**English:**
But we have to model things like LTV to CAC, so cost per acquisition costs versus lifetime value and the period within which the payback occurs. You end up getting to a pretty sophisticated place where you can build out things like a lead scoring model, which predictively can determine in a statistically significant way the likelihood that one lead will convert to revenue over another. And so there are ways around the slower payback period that still end up being pretty accurate based on what you're bidding on today versus the latent revenue that will be accrued to those campaigns through attribution.

**中文翻译:**
但我们必须对 LTV 与 CAC（获客成本）的比率进行建模，即获客成本与终身价值以及回本周期。最终你会进入一个相当高级的阶段，你可以建立诸如潜在客户评分模型（Lead Scoring Model）之类的东西，它能以统计学上显著的方式预测一个潜在客户转化为收入的可能性。因此，即使回本周期较慢，也有办法解决，通过归因分析，根据你今天的出价与这些活动未来将产生的潜在收入，结果仍然可以相当准确。

---

### [00:20:58] Lenny

**English:**
Do you have any just rules of thumb for someone listening and trying to decide, is paid a real model for us, either on LTV or CAC, or payback period? Or something just like, here's what you probably should have, especially early stage for you to feel like paid growth is going to be a great lever for you to use, and maybe a primary lever.

**中文翻译:**
对于正在听节目并试图决定“付费模式是否适合我们”的人，你有什么经验法则吗？无论是关于 LTV、CAC 还是回本周期？或者有没有什么标准，尤其是对于早期阶段的公司，让他们觉得付费增长会是一个很好的杠杆，甚至是主要杠杆？

---

### [00:21:18] Jonathan Becker

**English:**
Product market fit. If you know that your business sells into audiences. Let's say you are a social media influencer or you had a really strong email marketing game, or organically your content surfaces within Google search results. Or, you did a lot of direct mail and linear television and billboard advertising and that worked. If other things work, it is highly likely that paid acquisition will work. The issue for most companies is in this incorrect assumption that the data that is provided through paid channels allows you to have full end-to-end understanding of attribution. Which is wrong, it's never been that way. 

**中文翻译:**
产品市场匹配。如果你知道你的业务能卖给受众。假设你是一个社交媒体红人，或者你有一套非常强大的邮件营销方案，或者你的内容能自然地出现在 Google 搜索结果中。或者，你做了大量的直邮、线性电视和广告牌广告且奏效了。如果其他方式有效，那么付费获客极有可能也会奏效。大多数公司的问题在于一个错误的假设：认为付费渠道提供的数据能让你对归因有完整的端到端理解。这是错误的，从来都不是那样的。

---

### [00:22:24] Jonathan Becker

**English:**
And the other aspect of this is the patience to understand that every business is unique, and these metrics that we know are important are different for every business. Lifetime value, like propensity to repurchase, ROAS, which is return on amount spent, CPA, CAC, all of these different things are different for every business. Even if I worked with two hotels in the same city, they would have different results based on the nuances of their budget, their brand, the market that they sit within, the services that they offer, and so on and so forth. I think that everything else, the main problem here is that nobody should expect an overnight turnaround with performance marketing. It is a very difficult channel to manage, and that's why people hire experts like us to help them with it because it's a never ending problem with constantly changing issues. 

**中文翻译:**
另一方面是耐心，要理解每家业务都是独特的，我们认为重要的这些指标对每家公司都不同。终身价值、复购倾向、ROAS（广告支出回报率）、CPA（单次行动成本）、CAC，所有这些对每家公司都不同。即使我与同一座城市的两家酒店合作，由于预算、品牌、所处市场、提供的服务等细微差别，结果也会不同。我认为除此之外，主要问题是没人应该指望绩效营销能带来一夜之间的转变。这是一个非常难以管理的渠道，这就是为什么人们聘请像我们这样的专家来帮忙，因为它是一个不断变化、永无止境的问题。

---

### [00:23:07] Lenny

**English:**
I have this framework of there's these four growth channels, basically growth engines is what I call them. There's paid/performance marketing. There's SEO, there's virality in their sales. And essentially there's some companies whose growth is almost primarily paid. A few that come to mind are booking.com, which we know well at Airbnb, which is almost all paid growth driven. Credit Karma comes to mind as a classic paid performance marketing. I keep coming to paid growth as my term, so I'm just going to stick with that. TikTok initially was very performance marketing, paid growth oriented. Wish was another one I think about. And I want to talk about how much things are changing within this realm. But before we get there, do you think there's still an opportunity for startups to emerge where they get to scale almost exclusively through performance marketing? 

**中文翻译:**
我有一个框架，即四个增长渠道，我称之为增长引擎：付费/绩效营销、SEO、病毒式传播和销售。本质上，有些公司的增长几乎完全由付费驱动。我能想到几个例子：booking.com（我们在 Airbnb 时很了解它），它几乎全是付费增长驱动的。Credit Karma 也是经典的绩效营销案例。我一直习惯用“付费增长”这个词，那就沿用它吧。TikTok 最初也是非常注重绩效营销和付费增长的。Wish 是另一个例子。我想谈谈这个领域发生了多大的变化。但在那之前，你认为现在初创公司是否还有机会几乎完全通过绩效营销来实现规模化增长？

---

### [00:24:06] Jonathan Becker

**English:**
I'll put it this way. Every unicorn from the 2010s era that scale did performance marketing, but not everyone during that time who did performance marketing scaled. So I want to remove the bias here that just because all the successful organizations did this didn't mean that it was a magical channel for everyone. We had plenty of projects that we worked on that flatlined during that period. And so the sense that there was a period of time where this was easy or it worked on any project is not correct in my opinion. With that said, we see companies that are spending millions of dollars a month on performance marketing channels like Google and Meta still, despite all the ups and downs that they have faced and they do so profitably.

**中文翻译:**
我这么说吧。2010 年代每一个实现规模化增长的独角兽都做了绩效营销，但并非那个时代所有做绩效营销的人都实现了规模化。所以我想消除这种偏见：仅仅因为成功的组织都这么做了，并不意味着它对每个人都是神奇的渠道。在那个时期，我们经手的很多项目也停滞不前。因此，认为曾经有一段时间这很容易或者对任何项目都有效，在我看来是不正确的。尽管如此，我们看到现在仍有公司每月在 Google 和 Meta 等绩效营销渠道上投入数百万美元，尽管面临各种起伏，他们依然能保持盈利。

---

### [00:24:55] Jonathan Becker

**English:**
And I think there's some really great examples of companies that have scaled in relatively recent times, almost exclusively through paid. Grammarly is a really good example of this. They have been good at solving for this problem that exists around understanding the cost per acquisition versus lifetime value, how sticky customers are, predicting how much revenue can come from a customer and backing out into therefore how much we can pay per click and per lead and so on and so forth. Athletic Greens is another good example. 

**中文翻译:**
我认为最近有一些非常棒的例子，公司几乎完全通过付费渠道实现规模化。Grammarly 就是一个很好的例子。他们擅长解决获客成本与终身价值之间的问题，了解客户的粘性，预测一个客户能带来多少收入，从而倒推出我们可以为每次点击或每个潜在客户支付多少钱。Athletic Greens 是另一个好例子。

---

### [00:26:07] Jonathan Becker

**English:**
Athletic Greens is actually a pretty old company. I think they've been around for 10 years. I think they have retail distribution. I think they have done a lot of the more classic marketing things that are important in terms of developing that channel mix. But I think the amplification of that brand really, really gained traction quite recently where now everybody knows what Athletic Greens is, and that's because they're buying loads of ads on TikTok. They're buying loads of ads on other social channels like Facebook. They're investing in podcasting partnerships. But this is all digital paid acquisition. And so it had a wonderful effect on this really interesting business that they had already built. So yes, it's still doable. We still see people doing it.

**中文翻译:**
Athletic Greens 实际上是一家相当老的公司，大概有 10 年了。他们有零售渠道，也做了很多经典的营销工作，这对于建立渠道组合很重要。但我认为该品牌的放大效应是最近才真正爆发的，现在每个人都知道 Athletic Greens，那是因为他们在 TikTok 上投放了大量广告，在 Facebook 等其他社交渠道也投了很多，还投资了播客合作伙伴关系。但这些都是数字付费获客。这对他们已经建立的有趣业务产生了极好的效果。所以，是的，这仍然是可行的，我们仍然看到有人在这样做。

---

### [00:27:08] Lenny

**English:**
I was definitely going to ask about that, and I love that you touched on it, just clearly a lot is changing in paid growth/performance marketing recently. You talked about the privacy stuff, you talked about COVID kind of shifted the way people spend and kind of dropped and then came back. So my question is who are you finding has the most success these days in performance marketing? And I will plant one seed, which from the examples you just shared, it feels like it's mostly companies that are very efficient. I think Grammarly, they're just super efficient as a business. And then I think Athletic Greens, they're a sponsor and their negotiations for sponsoring is just like, okay, here's the number that makes sense for them financially, and they're not going to go anywhere above that.

**中文翻译:**
我正想问这个，很高兴你提到了。显然，付费增长/绩效营销最近发生了很大变化。你谈到了隐私问题，谈到了 COVID 如何改变了人们的消费方式（先下降后回升）。所以我的问题是，你发现现在谁在绩效营销中取得了最大的成功？我先抛砖引玉：从你刚才分享的例子来看，感觉大多是非常高效的公司。Grammarly 的业务运作就极其高效。Athletic Greens 也是我们的赞助商，他们在谈赞助时的态度就是：这是财务上对我们合理的数字，我们绝不会多出一分钱。

---

### [00:28:18] Jonathan Becker

**English:**
I'm not going to really be able to point to this company is really getting it right and I think that you can do that, but it's like saying, a friend of mine who recently on Twitter tweeted this funny thing where he was like, this is the number that I used to win the lottery said every successful founder ever trying to give advice to other founders. And so in other words, just because they won the lottery doesn't mean you're going to be successful picking the same number. To that extent, there is a bit of a playbook around modern day performance marketing, and that includes everything from really stringent and rigorous creative testing and thinking about that correctly to understanding the subjectivity of attribution and its strengths and weaknesses, doing a lot of work around validity of these campaigns. 

**中文翻译:**
我无法具体指出哪家公司做得绝对正确。虽然可以举例，但这就像我一个朋友最近在 Twitter 上发的趣事：每个试图给其他创始人建议的成功创始人都在说“这就是我中彩票的号码”。换句话说，仅仅因为他们中了彩票，并不意味着你选同一个号码也会成功。就此而言，现代绩效营销确实有一套“剧本”，包括从非常严谨的创意测试并正确思考，到理解归因的主观性及其优缺点，以及围绕这些活动的有效性做大量工作。

---

### [00:29:39] Lenny

**English:**
When you were giving your intro, you talked about how you initially started doing SEO, that's where you started, and then you moved to paid growth. Well, how do you think about those two investments as a founder trying to decide which direction to go? What would your advice be of spend your time here versus there if X, Y, Z?

**中文翻译:**
你在自我介绍时提到，你最初是做 SEO 的，那是你的起点，然后你转向了付费增长。那么，作为一个试图决定发展方向的创始人，你如何看待这两项投资？你的建议会是什么？在什么情况下应该把时间花在这里，什么情况下花在那里？

---

### [00:29:56] Jonathan Becker

**English:**
When I'm asked a question of should we put money into organic search or paid search? My response is often that they're actually not mutually exclusive to one another. So it's a great idea to do both, and that backs into my strategy of diversification of channels. So don't build up exclusively in one area and create volatility within your marketing mix essentially. SEO is a wonderful marketing capability when it's built out correctly. I think the issues that you run into are cause and effect related. 

**中文翻译:**
当有人问我“我们应该把钱投在自然搜索还是付费搜索？”时，我的回答通常是：它们实际上并不互斥。两者都做是个好主意，这符合我渠道多元化的策略。本质上，不要只在一个领域发力，以免在营销组合中产生波动。SEO 如果构建得当，是一项极好的营销能力。我认为你遇到的问题通常与因果关系有关。

---

### [00:30:52] Jonathan Becker

**English:**
Search engine optimization is different in that the attribution can be tough. It's difficult to determine whether ultimately the actions that you took contributed to a rise in organic traffic. You have to essentially correlate that. And the reason is because when you build clusters of content and it's grouped thematically and you're targeting buckets of keywords, whatever it may be, you can publish all of that on your website. Google still has to crawl it. They run it through their analysis algorithm, which is comprised of 200 different signals, of which maybe 20 to 30 have been publicly disclosed. So it's a bit of a black box.

**中文翻译:**
搜索引擎优化的不同之处在于归因可能很困难。很难确定你采取的行动最终是否促成了自然流量的增长，你必须进行相关性分析。原因是当你构建内容集群、按主题分组并针对一系列关键词时，你可以把这些都发布在网站上，但 Google 仍需抓取它。他们通过包含 200 个不同信号的分析算法来运行它，而其中可能只有 20 到 30 个是公开披露的。所以它有点像个黑匣子。

---

### [00:31:37] Jonathan Becker

**English:**
We don't really know ultimately what ROI comes off of that unless you're very sophisticated, like probably one of your other guests, Ethan, in terms of measurement. Whereas paid, the ROI is still a difficult problem to solve, but there was a lot more of a linear relationship as it relates to attribution. And so paid being tangible was the reason why I leaned heavily into paid and ultimately away from SEO. But I do think that if you do SEO properly, the payoffs are indisputable and it is certainly an important part of a modern media mix.

**中文翻译:**
除非你像你的另一位嘉宾 Ethan 那样在衡量方面非常专业，否则我们很难知道最终的 ROI 是多少。而付费广告虽然 ROI 仍然是一个难题，但在归因方面有更多的线性关系。因此，付费广告的“可触达性”是我重仓付费并最终远离 SEO 的原因。但我确实认为，如果你正确地做 SEO，回报是无可争议的，它绝对是现代媒体组合的重要组成部分。

---

### [00:32:18] Lenny

**English:**
You mentioned this earlier, I've heard this more and more recently that one of the biggest levers these days in paid growth is around creatives. It's not tooling or smarter data, or you tell me if I'm wrong, but it's just getting better creatives. And so I'll let you actually explain, what are creatives? There's a term creatives that people outside the industry don't really necessarily get. And then broadly, what should people be doing to optimize the way they approach creatives?

**中文翻译:**
你之前提到过这一点，我最近也越来越多地听到：如今付费增长中最大的杠杆之一就是创意素材（Creatives）。不是工具，也不是更智能的数据（如果我错了请纠正我），而是更好的创意素材。所以我想请你解释一下，什么是“创意素材”？行业外的人不一定理解这个词。广义上讲，人们应该如何优化处理创意素材的方式？

---

### [00:32:46] Jonathan Becker

**English:**
Certainly. So when we say creative, we're referring to the assets that power typically visual programmatic or pay per click campaigns on social channels or display networks. And so literally the motion graphics ad that you see on Facebook, the user generated content that you see on TikTok or a static ad that you might see that has a pretty picture in it or whatever. And so I think that when we talk about creative as a big lever around efficiency and optimization, the underlying conversation there is that over time our industry has been heavily automated. 

**中文翻译:**
当然可以。当我们说“创意素材”时，我们指的是驱动社交渠道或展示网络上的视觉程序化广告或点击付费广告的资产。具体来说，就是你在 Facebook 上看到的动态图形广告，在 TikTok 上看到的用户生成内容（UGC），或者你看到的带有漂亮图片的静态广告等等。我认为，当我们谈论创意素材是效率和优化的巨大杠杆时，其潜在的背景是：随着时间的推移，我们的行业已经高度自动化了。

---

### [00:33:57] Jonathan Becker

**English:**
So a lot of the levers so to speak around performance have been automated by Google and Facebook over the last seven to 10 years. That's because originally when you ran these campaigns, you needed to have a rocket scientist in front of them. It was so complicated and there were so many different things that you could get wrong, and their solution, the channels like the big tech company solution to this is figuring it out for you. So eventually Google wants you to say, hey, I'm Google, give me your credit card and I'll take care of everything else. 

**中文翻译:**
在过去的 7 到 10 年里，Google 和 Facebook 已经将许多所谓的绩效杠杆自动化了。这是因为最初运行这些活动时，你需要像火箭科学家一样专业的人才。它太复杂了，有很多地方会出错。而这些大科技公司的解决方案就是替你搞定。最终，Google 希望你觉得：“嘿，我是 Google，把你的信用卡给我，剩下的我来负责。”

---

### [00:34:00] Lenny

**English:**
And the URL to point people to, and then we'll do the rest.

**中文翻译:**
再加上一个引导用户的 URL，剩下的交给他们。

---

### [00:34:03] Jonathan Becker

**English:**
Yeah. I don't know if that's a great idea for consumers, by the way. But in the meantime, there's certain things that have just been fully automated. In the context of creative, it's still one of these things that for now is not auto-generated in the world of AI and all the changes that we're seeing. Maybe that's something that will change. But for now, essentially creative directors and their teams are concepting and producing different types of assets. And so there's a bunch of problems that we typically see when people come to us. 

**中文翻译:**
是的。顺便说一句，我不知道这对消费者来说是不是个好主意。但与此同时，有些事情确实已经完全自动化了。在创意素材方面，尽管 AI 领域发生了这么多变化，但目前它仍然不是完全自动生成的。也许以后会变。但目前，基本上还是由创意总监及其团队在构思和制作不同类型的资产。当人们来找我们时，我们通常会看到一系列问题。

---

### [00:34:48] Jonathan Becker

**English:**
So number one, performance marketing and brand marketing in a lot of organizations are two different things. And the designers that occupy brand teams bandwidth and whatnot often don't have a sense of how paid acquisition works. And so one of the pitfalls of working with certain companies or the mistake that they make is the design team will hand off a file full of random assets for paid acquisition without any sense of how the channel works. And what I mean by that is these days we're using the analogy, the classic analogy of the funnel to organize our thinking around creative assets. 

**中文翻译:**
第一，在很多组织中，绩效营销和品牌营销是两回事。占据品牌团队带宽的那些设计师通常不了解付费获客是如何运作的。因此，与某些公司合作时的一个陷阱或他们犯的错误是：设计团队会交出一堆用于付费获客的随机资产，却完全不了解该渠道的运作方式。我的意思是，现在我们使用经典的“漏斗”类比来组织我们对创意资产的思考。

---

### [00:35:56] Jonathan Becker

**English:**
So you can think about this as generating intent at the top of funnel and capturing intent at the bottom of the funnel. When I think about an experience that I want a consumer to have on Facebook, audience targeting and creative, I think about us beginning a conversation at the top of funnel creatively with an audience, having that conversation change as we say different things, and the audience that we're targeting ultimately graduates through different behaviors on our website from one to another, and then ultimately it resulting in an end to the conversation where they take an action hopefully that the brand that we're working with is looking for. 

**中文翻译:**
你可以将其视为在漏斗顶部“产生意向”，在漏斗底部“捕捉意向”。当我思考我希望消费者在 Facebook 上获得的体验、受众定向和创意素材时，我想到的是我们在漏斗顶部通过创意与受众开始对话，随着我们说出不同的话，对话内容也会发生变化，而我们定向的受众最终通过在网站上的不同行为从一个阶段晋升到另一个阶段，最终以他们采取行动（希望是品牌所期望的行动）来结束这段对话。

---

### [00:36:30] Jonathan Becker

**English:**
And so there's a clear beginning, middle and end to that. And one of the major pitfalls that we see is that certain brands just dump one homogenous message into all of their targeting. You see the same ad over and over again. It creates banner blindness and it's a total lack of efficiency. The antidote to that is to have resources dedicated to paid and essentially iterate upon the creative assets themselves based on the data that we see coming from ad sets and campaigns in various channels. And so what that means is that you have to experiment. 

**中文翻译:**
所以这有一个清晰的开始、中间和结束。我们看到的一个主要陷阱是，某些品牌只是在所有的定向中投放单一、同质化的信息。你会一遍又一遍地看到同一个广告。这会导致“横幅盲区”（banner blindness），完全缺乏效率。解决方法是拥有专门用于付费渠道的资源，并根据我们从各个渠道的广告组和活动中看到的数据，对创意资产本身进行迭代。这意味着你必须进行实验。

---

### [00:37:11] Lenny

**English:**
Is there a specific example that comes to mind here as something we did that just dramatically changed the impact of a change to a creative? Or if you can't think of one, are there just specific tactics that you can suggest for people to improve the way they approach creatives?

**中文翻译:**
你能不能想到一个具体的例子，说明我们做的某次创意素材改动极大地改变了效果？或者如果你想不出来，有没有具体的策略可以建议大家用来改进处理创意素材的方式？

---

### [00:37:28] Jonathan Becker

**English:**
Yeah. So I think from a testing point of view, let's say I was running ads on Meta, beneath the campaign level when I create a campaign, the structure that my testing might take would be that I would have an audience, a single audience at the ad set level, and then I would have two nearly identical creatives within that ad set. The only thing being different across those two creative assets is a single variable. So it might be the copy, it might be an image or whatnot. That allows us to isolate a lot of variables and really test into one singular change across two creative assets. 

**中文翻译:**
好的。从测试的角度来看，假设我在 Meta 上投放广告，在创建广告系列（Campaign）时，我的测试结构可能是这样的：在广告组（Ad Set）级别设置一个单一受众，然后在该广告组中放入两个几乎完全相同的创意素材。这两个素材之间唯一的区别就是一个变量，比如文案、图片或其他。这让我们可以隔离大量变量，真正测试两个创意资产之间的单一变化。

---

### [00:38:31] Jonathan Becker

**English:**
There's a lot of nuance to this. So sometimes the ad-serving algorithms, even when we set up a test structurally in that way, we'll serve one ad a different number of impressions than the other ad, in which case we then have to say, what is a leveling factor that allows us to look at these two ads equally, even though one received dramatically more impressions than the other? This becomes where it becomes subjective in terms of how you want to determine success. But a good example is looking at the click-through rate, which is essentially a ratio or a metric like impressions until conversion, which is a leveling metric that allows us to determine, even though in a scenario where two ads facing the same audience within the same campaign received different numbers of impressions, we can still measure the efficiency or effectiveness of one ad over the other using metrics like that. 

**中文翻译:**
这其中有很多细微差别。有时即使我们按这种结构设置测试，广告投放算法也会给其中一个广告分配比另一个更多的展示次数。在这种情况下，我们就必须找到一个“平衡因子”，让我们能够公平地看待这两个广告，即使其中一个获得的展示次数多得多。在决定如何定义成功时，这会变得有些主观。但一个好的例子是看点击率（CTR），它本质上是一个比率；或者像“转化前的展示次数”这样的指标，这是一个平衡指标，让我们能够衡量一个广告相对于另一个广告的效率或有效性。

---

### [00:39:26] Jonathan Becker

**English:**
And so from a testing point of view, I think that this is one way that we might look at trying to assess ad performance so that we can gather learnings, send that back to a creative team and say, hey, it turns out that when this copy is used at this stage of the funnel, it converts 50% more frequently than this other copy. So let's now take that copy, use it as our base copy and challenge it with a different type of copy and see if we can continually iterate and refine. So that's a very practical example of how ad creative testing might work on a channel like Meta. 

**中文翻译:**
所以从测试的角度来看，我认为这是评估广告表现的一种方式，这样我们可以收集经验，反馈给创意团队说：“嘿，事实证明，在漏斗的这个阶段使用这段文案，其转化频率比另一段文案高 50%。”那么现在我们就把这段文案作为基础文案，再用另一种文案来挑战它，看看我们能否不断迭代和完善。这是一个关于广告创意测试在 Meta 这种渠道上如何运作的非常实际的例子。

---

### [00:40:00] Jonathan Becker

**English:**
You asked for specific examples where we've seen an unlock. There's two that come to mind. Several years ago we realized that highly produced ads from brand teams, and there's nothing wrong with brand teams, we work with them all the time. They do amazing work. I think we're just trying to work as a singular unit as opposed to being fragmented. But a lot of the brand guidelines of different companies would end up yielding these highly polished assets. And when you launch those on Instagram back in the day or something like that, what we found is that they would always underperform next to user generated assets. 

**中文翻译:**
你问到了我们看到突破的特定例子。我能想到两个。几年前我们意识到，品牌团队制作的那些精良广告（品牌团队没问题，我们经常合作，他们做得很棒，我们只是想作为一个整体而不是碎片化地工作）往往会产生非常精致的资产。但当你以前在 Instagram 之类的平台上发布这些广告时，我们发现它们的表现总是逊色于用户生成内容（UGC）。

---

### [00:40:45] Jonathan Becker

**English:**
So a brand that essentially has an influencer in front of it that says, I tried this product, I love it, I'm filming this ad from my iPhone. Look, check it out. Here's the product, here's me, I'm better off for it. Whatever it is that they're talking about. The unpolished iPhone, mobile phone creative, suddenly we realized massively outperformed these other channels because there was an authenticity to it. And rather than the brands themselves saying, hey, trust us, our product is great, here's a third party essentially validating what is so great about these brands, basically. 

**中文翻译:**
比如一个品牌找了个网红，对方说：“我试过这个产品，我很喜欢，我正用我的 iPhone 拍这个广告。看，瞧瞧这个，这是产品，这是我，用了它我感觉更好了。”不管他们说什么，这种未经修饰的 iPhone 手机创意素材，突然间我们发现其表现远超其他渠道，因为它有一种真实感。与其让品牌自己说“嘿，相信我们，我们的产品很棒”，不如让第三方来验证这些品牌到底好在哪里。

---

### [00:41:21] Jonathan Becker

**English:**
Another example is we worked with a furniture company several years ago, which scaled dramatically, but they were having difficulty early on thinking through how to scale social ads. And so paid search worked really well for them. Social ads, again, they had these highly produced styled rooms and one of the owners had their dog in the office all the time, and so they have these models sitting on furniture or whatever it was, and they would take these beautiful styled shots of their furniture in a room and one of the art directors was like, put the dog on the couch and let's take some photos of dogs on furniture, which made it more playful and approachable. That one change resulted in a total unlock of their performance on paid social channels. It would double or triple the ROAS that we were seeing type thing. 

**中文翻译:**
另一个例子是几年前我们合作的一家家具公司，他们规模扩张得很快，但早期在思考如何扩大社交广告规模时遇到了困难。付费搜索对他们很有效。但在社交广告上，他们还是用那些精心布置的样板间。其中一位老板总是把狗带到办公室，他们本来是让模特坐在家具上拍那些精美的照片。后来一位艺术总监提议：“把狗放在沙发上，拍些狗在家具上的照片吧。”这让品牌变得更有趣、更亲民。就这一个改变，彻底打开了他们在付费社交渠道上的表现，ROAS（广告支出回报率）直接翻了两三倍。

---

### [00:42:04] Lenny

**English:**
That reminds me of Airbnb. The photography team found, and actually the photography team was initially including people in the photos of listings, and that was the images of listing photos. And it turns out when there's no people in the listing photo, much higher conversion. And the theory basically people don't want to see other random strangers in a place they're going to sleep, and that was not expected.

**中文翻译:**
这让我想起了 Airbnb。摄影团队最初在房源照片里是放了人的，结果发现，当房源照片里没有人时，转化率反而高得多。理论上是因为人们不想在他们要睡觉的地方看到陌生的随机路人，这在当时是出乎意料的。

---

### [00:42:29] Jonathan Becker

**English:**
That's a really great example. And so the question becomes, as a company and as a brand, do you arrive at those learnings anecdotally by accident? Is it the brilliance of one person on the team that the whole brand is predicated upon in terms of performance? Or do you put a very rigorous structure around testing and the iteration of assets and how to determine whether something works over another thing that is a process that yields the outcomes that you're looking for? 

**中文翻译:**
这是一个非常棒的例子。所以问题在于，作为一个公司和品牌，你是靠偶然的传闻获得这些经验的吗？整个品牌的绩效是建立在团队中某一个人的才华之上吗？还是说你围绕测试和资产迭代建立了一套非常严谨的结构，并有一套流程来确定什么比什么更有效，从而产生你想要的结果？

---

### [00:43:28] Lenny

**English:**
Getting even more tactical with that idea of testing a bunch of creatives makes me think about a story from chatting with a guy from Wish who's had a growth at Wish about how they uploaded hundreds of variations. And I think Wish is the epitome of the opposite of brand highly polished ads or it's just the most ridiculous looking product with just banners and numbers and prices and crossouts and all kinds of stuff, just anything that would take to get people to click. Is there a tool or process that you can point people to to help them do this testing on creatives or is it mostly built into the existing tools now and there's nothing really fancy about it?

**中文翻译:**
谈到测试大量创意素材，这让我想起与 Wish 增长负责人的聊天，他们会上传数百个变体。我觉得 Wish 就是“精美品牌广告”的反面典型——全是些看起来很荒谬的产品，配上横幅、数字、价格、划线价等各种乱七八糟的东西，只要能让人们点击就行。有没有什么工具或流程可以推荐给大家，帮助他们进行创意素材测试？还是说现在这些功能大多已经内置在现有工具中了，没什么特别的？

---

### [00:44:04] Jonathan Becker

**English:**
We get asked this a lot and I think there are tools for different types of functions that we undertake in the process of running paid acquisition for different brands, but these days most of the testing that we do is within the channels themselves. So Meta ads, Google Ads, I keep touching on those two specifically because they're the most advanced in my opinion. They're really powerful. The good news here is that you don't necessarily need some exotic tool to do sophisticated creative testing. You can do it in platform and you can use the structure that I just kind of outlined as a starting point.

**中文翻译:**
很多人问我们这个问题。虽然在为不同品牌运行付费获客的过程中，针对不同功能有不同的工具，但如今我们做的大多数测试都是在渠道内部完成的。比如 Meta 广告、Google 广告，我一直强调这两个，因为在我看来它们最先进、最强大。好消息是，你并不一定需要什么奇特的工具来进行复杂的创意测试。你可以在平台内完成，并以我刚才概述的结构作为起点。

---

### [00:44:59] Lenny

**English:**
You mentioned Google and Facebook. What is your take on TikTok and YouTube and maybe Snap? Do you recommend people go there and there's a big opportunity? Do you think it's overblown? Do you think people should just take Google and Facebook basically at this point? What's your general advice?

**中文翻译:**
你提到了 Google 和 Facebook。你对 TikTok、YouTube 还有 Snap 怎么看？你建议大家去那里吗？那里有大机会吗？你觉得是不是被夸大了？你觉得大家现在是不是应该只盯着 Google 和 Facebook？你的一般建议是什么？

---

### [00:45:20] Jonathan Becker

**English:**
So when I say Google and I say Facebook, I'm talking about the Google ecosystem of channels inclusive of YouTube. And when I talk about Facebook, I'm talking about Facebook, Instagram, and probably eventually WhatsApp, which I think will probably launch ads later this year. With all that said, some interesting opportunities these days really exist on channels like Amazon and TikTok as well as a number of other challenger channels I think. Snap I'll talk a little bit less about because I think really there's just fewer and fewer people potentially using Snap. 

**中文翻译:**
当我说 Google 时，我指的是包括 YouTube 在内的 Google 渠道生态系统。当我说 Facebook 时，我指的是 Facebook、Instagram，可能最终还包括 WhatsApp（我认为今年晚些时候可能会推出广告）。话虽如此，现在一些有趣的机会确实存在于 Amazon 和 TikTok 等渠道，以及其他一些挑战者渠道。关于 Snap 我会说得少一点，因为我觉得使用 Snap 的人可能越来越少了。

---

### [00:45:58] Jonathan Becker

**English:**
I love TikTok. I'm a consumer of content on TikTok, not a producer of content on TikTok. Their ads platform kind of reminds me of where Facebook ads was like six, seven years ago. It's not super sophisticated and attribution is not great yet, but you can get cheap CPCs because there's just fewer organizations advertising there. Fewer companies have figured out how to make that work. And same thing with Amazon. Amazon is a bit of a bespoke channel. It doesn't work for a B2B SaaS company. It's more specific to D2C I would say. 

**中文翻译:**
我喜欢 TikTok。我是 TikTok 的内容消费者，不是生产者。他们的广告平台让我想起六七年前的 Facebook 广告。它还不是特别成熟，归因也做得不够好，但你可以获得廉价的 CPC，因为在那儿投放广告的组织还比较少，还没多少公司搞清楚怎么玩转它。Amazon 也是一样，它是一个比较定制化的渠道，不适合 B2B SaaS 公司，更多是针对 D2C。

---

### [00:46:53] Jonathan Becker

**English:**
And so the question becomes, will TikTok become as prominent as a social ads platform like Meta Ads? And we just don't know yet. What we see working very nicely on TikTok, by the way, are these founder led brands where the founder is the ambassador and they're doing those handheld videos with their iPhone. They're talking about the merits of the products that they make. They're talking about the problems that they solve. They are great at cultivating a following. Their content is highly engaging. Those types of organizations crush it. 

**中文翻译:**
所以问题在于，TikTok 是否会变得像 Meta 广告那样成为主流的社交广告平台？我们还不知道。顺便说一下，我们看到在 TikTok 上效果非常好的是那些“创始人驱动”的品牌，创始人就是代言人，他们用 iPhone 拍那些手持视频，讲述他们产品的优点，谈论他们解决的问题。他们擅长培养粉丝，内容参与度极高。这类组织在 TikTok 上非常吃香。

---

### [00:48:05] Lenny

**English:**
Just broadly, would you say TikTok advertising today is underrated, overrated, or just right?

**中文翻译:**
总的来说，你认为今天的 TikTok 广告是被低估了、被高估了，还是刚刚好？

---

### [00:48:16] Jonathan Becker

**English:**
If you are e-comm based, if you're wholesale, retail based, anything direct to consumer, you have to investigate TikTok and try and figure out whether there's a way of promoting your products there, basically. It's a massive, highly engaged audience with somewhat specific demographics. It's a very exciting opportunity. Other brands need to pay attention to this and figure out what their entry point is going to be. And just because the innovation hasn't happened for B2B SaaS yet on TikTok doesn't mean it won't. 

**中文翻译:**
如果你是做电商、批发、零售或任何直面消费者的业务，你必须研究 TikTok，并尝试找出在那里推广产品的方法。它拥有庞大且高度参与的受众，且具有特定的人口统计特征。这是一个非常令人兴奋的机会。其他品牌也需要关注这一点，并找出切入点。仅仅因为 TikTok 上还没有出现针对 B2B SaaS 的创新，并不意味着以后不会有。

---

### [00:49:15] Jonathan Becker

**English:**
The other problem with TikTok is that it's extraordinarily creative, asset dependent, and heavy. And so you are launching net new assets several times per week, it is hard for creative teams and brands to produce that much content. It takes a machine, and that's expensive, and so that all factors into the cost of not only just the ad dollars, but the creative resourcing and investment that's required to power that. So it can be done in a more nimble manner if you're spending less, but you can't really get to a million dollars a month on TikTok without having a huge amount of creative being pushed to that channel.

**中文翻译:**
TikTok 的另一个问题是它极度依赖创意资产，而且消耗量巨大。你每周都要发布好几次全新的素材，创意团队和品牌很难生产出这么多内容。这需要一套“内容机器”，而且成本很高，所以这不仅涉及广告费，还涉及驱动它所需的创意资源和投资。如果你预算较少，可以做得灵活些，但如果你想在 TikTok 上达到每月 100 万美元的支出，没有海量的创意素材持续投入是不可能的。

---

### [00:50:20] Jonathan Becker

**English:**
So I'm agnostic here in terms of where people should be spending money. I see this world in terms of impressions and clicks, and does that conform to the marketing economics of a project that needs to be achieved in order for it to grow. It's less about where to place your money and how to think about the placement of those funds. And so the common mistake that we see as people build out a funnel, so to speak, for B2B lead gen projects, or B2C lead gen projects, is they'll be overly reliant on the first of a sequence of metrics that ultimately yields a sale.

**中文翻译:**
在人们应该在哪里花钱的问题上，我持不可知论。我从展示量和点击量的角度来看待这个世界，看它是否符合项目增长所需的营销经济模型。重点不在于把钱投在哪里，而在于如何思考这些资金的投放。我们在人们为 B2B 或 B2C 潜在客户生成项目构建漏斗时看到的一个常见错误是，他们过度依赖最终导致销售的一系列指标中的第一个。

---

### [00:51:24] Jonathan Becker

**English:**
And so if I think about this world of lead generation on performance marketing platforms as a function of cost per lead in that sense that I just described, then the tendency is always to want to drive down the cost per lead, thinking that that's the efficiency, I can get more cheaper leads and that will yield more revenue. When in fact it turns out that if you flip that conversation on its head and say, not all opportunities and sales are equal, and instead of focusing upfront on a cost per lead, I now want to focus on what is a high value customer, so the cost per lead is actually higher, but the ROI of targeting those people is also higher. 

**中文翻译:**
如果我把绩效营销平台上的潜在客户生成看作是我刚才描述的那种“单次潜在客户成本”（CPL）的函数，那么倾向总是想降低 CPL，认为这就是效率——我可以获得更多更便宜的潜在客户，从而产生更多收入。但事实上，如果你把这个逻辑反过来想：并非所有的机会和销售都是平等的。与其预先关注 CPL，不如关注什么是“高价值客户”。虽然这些人的 CPL 可能更高，但针对他们的 ROI 也更高。

---

### [00:52:15] Jonathan Becker

**English:**
The antidote to this, it's interesting, so Thrive developed an ETL tool, an extract transfer load tool called Thrive Stack. It's not commercially available, but if you wanted a commercially available version of this, you can use something called Supermetrics. Basically Supermetrics is a data connector. There's a world of different data connectors out there, but it allows you to pipe, via an API, revenue data from your CRM into a third party database that can then be joined with data from the channel itself. 

**中文翻译:**
解决这个问题的方法很有趣。Thrive 开发了一个 ETL 工具（提取、转换、加载工具），叫做 Thrive Stack。它目前不对外商用，但如果你想要一个商用版本，可以使用 Supermetrics。基本上 Supermetrics 是一个数据连接器。市面上有很多不同的连接器，它允许你通过 API 将 CRM 中的收入数据导入第三方数据库，然后与渠道本身的数据结合。

---

### [00:53:08] Jonathan Becker

**English:**
And then you can build upon that what is known as a lead scoring model, which allows you to bid in real time on the audiences that have a higher likelihood to convert to high revenue generating customers. And so the magic there, we talked a little bit about rates of return and instant gratification in the performance marketing world, lead generation inherently is a slow gratification process. And so the problem is that if my pipeline is full of opportunities that yield revenue in two months, six months, sometimes 12 months, how do I determine how heavily to bid on different leads today in order to predictively have an outcome where I'm maximizing revenue? And a lead scoring model basically solves for that.

**中文翻译:**
然后你可以以此建立所谓的“潜在客户评分模型”，让你能够实时对那些更有可能转化为高收入客户的受众进行出价。这就是神奇之处。我们谈到了绩效营销世界中的回报率和即时满足，而潜在客户生成本质上是一个“延迟满足”的过程。问题在于，如果我的管道里全是两个月、六个月甚至 12 个月后才能产生收入的机会，我今天该如何决定对不同的潜在客户出价多少，才能预测性地实现收入最大化？潜在客户评分模型基本上解决了这个问题。

---

### [00:54:06] Lenny (Sponsor Break - Miro)

**English:**
Today's episode is brought to you by Miro, an online collaborative whiteboard that's designed specifically for teams like yours. I have a quick request, head on over to my Miro board at miro.com/lenny and let me know which guests you'd want me to have on this year. While you're on the Miro board, I encourage you to play around with the tool. It's a great shared space to capture ideas, get feedback, and collaborate with your colleagues on anything that you're working on. Head on over to miro.com/lenny to leave your suggestions.

**中文翻译:**
今天的节目由 Miro 赞助，这是一个专为像你们这样的团队设计的在线协作白板。我有一个小请求，请访问我的 Miro 看板 miro.com/lenny，告诉我你今年想让我邀请哪些嘉宾。当你访问 Miro 看板时，我鼓励你试用一下这个工具。它是一个捕捉创意、获取反馈并与同事协作处理任何工作的绝佳共享空间。请访问 miro.com/lenny 留下你的建议。

---

### [00:55:06] Lenny

**English:**
You talked about attribution, and I thought this would be a great time to get into that. So the way I think about this is oftentimes the biggest challenge in driving growth isn't the actual work you do to drive growth, it's measuring what impact your work is having and understanding where dollars are spent effectively. And things are changing heavily in attribution land with privacy shifts and ATT and iOS 14.5.1. And so my question is, what changed, is one, in terms of being able to do attribution. Maybe even explain what attribution means for folks that are just like, what the hell are you even talking about? And then finally, what do you recommend people do now to do attribution well in this new environment?

**中文翻译:**
你提到了归因（Attribution），我想现在是深入探讨这个话题的好时机。我对此的看法是，驱动增长最大的挑战往往不是实际的增长工作，而是衡量你的工作产生了什么影响，并了解钱是否花在了刀刃上。随着隐私政策的变化、ATT（应用追踪透明度）和 iOS 14.5.1 的推出，归因领域发生了巨大变化。所以我的问题是：第一，在归因能力方面发生了什么变化？也许可以先为那些完全不知道你在说什么的人解释一下什么是“归因”？最后，你建议大家现在如何在这个新环境下做好归因？

---

### [00:56:15] Jonathan Becker

**English:**
Attribution essentially is how we determine the relationship between what we did and what happened. In the context of performance marketing this means what ads did we serve, what campaigns did we launch, and generally what was the revenue ultimately that was derived from these campaigns? And so there's a funny quote that I love, someone named John Wanamaker in 1919 said, "I know half my marketing dollars are wasted, I just don't know which half."

**中文翻译:**
归因本质上是我们如何确定“我们做了什么”与“发生了什么”之间的关系。在绩效营销的背景下，这意味着我们投放了什么广告，启动了什么活动，以及这些活动最终产生了多少收入？我非常喜欢约翰·沃纳梅克（John Wanamaker）在 1919 年说的一句名言：“我知道我的营销费有一半浪费了，但我不知道是哪一半。”

---

### [00:57:00] Jonathan Becker

**English:**
He said this in 1919. The world was a very different place there, but oddly enough we still have these types of problems today and it's because the world of what I did and what happened because of what I did is very complicated. There's so many variables, some of which we know, and then some of which we don't know that we don't know, type thing. And so attribution, as it stands in our industry, is still an incredibly subjective art and somewhat of a science. 

**中文翻译:**
他在 1919 年就说了这话。那时的世界非常不同，但奇怪的是，我们今天仍然面临这类问题，因为“我做了什么”和“因为我做了什么而发生了什么”之间的世界非常复杂。有太多的变量，有些我们知道，有些我们甚至不知道自己不知道。因此，归因在我们的行业中仍然是一门极其主观的艺术，在某种程度上也是一门科学。

---

### [00:58:02] Jonathan Becker

**English:**
There's no one way necessarily of approaching attribution. The most classic and commonly held version of attribution used to be a cookie-based form of attribution called last click attribution, meaning that the last click in the sequence of clicks that yielded a conversion would be attributed with all the revenue from that conversion. Other models in a cookie-based world involved first touch attribution, so it's actually the first click. And then there's multi-touch attribution, which can take several different forms, but essentially is saying it's not one way or the other of the two first versus last click options, it's somewhere in between. 

**中文翻译:**
归因并没有唯一的处理方式。最经典、最常用的归因版本曾是基于 Cookie 的“末次点击归因”（Last Click Attribution），意味着导致转化的点击序列中的最后一次点击将被赋予该转化的全部收入功劳。基于 Cookie 的世界中的其他模型还包括“首次触达归因”（First Touch Attribution），即归功于第一次点击。还有“多触点归因”（Multi-touch Attribution），它有多种形式，但本质上是说功劳不全在第一下或最后一下，而是在两者之间。

---

### [00:59:34] Jonathan Becker

**English:**
So there was something called an IDFA that Apple allowed advertisers to use, and essentially what that was, it literally means ID for advertisers, and it allowed Facebook, Google, and other advertisers, Snap, TikTok, whoever was essentially selling ads that were predicated on being displayed on a Apple mobile device or a desktop device, it allowed the advertiser to provide attribution metrics and certain types of customer match metric metrics in their own platforms. And so when Apple ultimately launches its privacy changes, I believe in mid-2021, overnight it allows users to say, "Well, I don't want to share that information, I'm not going to share my IDFA anymore." 

**中文翻译:**
以前 Apple 允许广告商使用一种叫做 IDFA 的东西，字面意思就是“广告商标识符”。它允许 Facebook、Google、Snap、TikTok 等在 Apple 设备上展示广告的平台，在他们自己的平台内提供归因指标和某些类型的客户匹配指标。当 Apple 最终在 2021 年年中推出隐私政策变化时，一夜之间，它允许用户选择：“我不愿意分享这些信息，我不再分享我的 IDFA 了。”

---

### [01:00:43] Jonathan Becker

**English:**
And so what you see as a result of that is less of the core data that Facebook in particular would've required to make attribution more airtight and ultimately validate its advertising. So because we can no longer validate attribution on Facebook as seamlessly, we are in a situation where we're not sure any longer which audiences to target, and we're not sure how to run all of our creative testing, and ultimately we can't even determine the degree of revenue that's coming from particular campaigns that we've launched, and whatnot. 

**中文翻译:**
结果就是，尤其是 Facebook 所需的那些能让归因更严密、最终验证其广告效果的核心数据变少了。因为我们无法再像以前那样无缝地在 Facebook 上验证归因，我们陷入了困境：不再确定该针对哪些受众，不确定如何进行创意测试，最终甚至无法确定我们启动的特定活动带来了多少收入。

---

### [01:01:25] Jonathan Becker

**English:**
So the cookie based attribution, which had been probably the most popular version of attribution in the 2010s, really up to this point, is now one of the ways that we would look at this, but we would also include things like various forms of statistical modeling, customer surveys, population surveys. Statistical modeling, by the way, one thing that's very popular these days, which I think was originally created in the 1950s, is a form of statistical modeling called media mix modeling (MMM). It's essentially regression analysis, and it is trying to determine the causal relationship between, again, what you did and what the effect was on revenue. 

**中文翻译:**
因此，在 2010 年代最流行的基于 Cookie 的归因，现在只是我们看待问题的方式之一。我们还会加入各种形式的统计建模、客户调查、人口调查。顺便说一下，现在非常流行的一种统计建模叫做“媒介组合模型”（MMM），我认为它最初起源于 1950 年代。它本质上是回归分析，试图确定“你做了什么”与“对收入的影响”之间的因果关系。

---

### [01:02:42] Jonathan Becker

**English:**
The advice is that there's no single source of truth. Anyone who claims that they are a single source of truth, whether it's an individual, a model that they've created, or a tool that they've created, is not being accurate. I believe that the approach that works to attribution is that it's an ongoing investigation and it never stops, and essentially what you're doing is looking for evidence that validates the outcome of your performance marketing campaigns one way or the other.

**中文翻译:**
我的建议是：没有唯一的“真相来源”（Single Source of Truth）。任何声称自己是唯一真相来源的人——无论是个人、模型还是工具——都是不准确的。我认为有效的归因方法是将其视为一项永不停止的持续调查。本质上，你是在寻找证据，以某种方式验证你绩效营销活动的结果。

---

### [01:04:29] Lenny

**English:**
How has AI in any way impacted the work you're doing today, or the work of paid growth, performance marketing, and then where do you think this will go in the next few years?

**中文翻译:**
AI 在哪些方面影响了你今天的工作，或者付费增长、绩效营销的工作？你认为未来几年这会走向何方？

---

### [01:04:43] Jonathan Becker

**English:**
Interestingly, and I think I alluded to this earlier, but our industry has been influenced by AI for over a decade. So Google, Facebook, even Microsoft, these are some of the organizations that historically have been at the bleeding edge of artificial intelligence, and their goal was always to automate as much as possible within these platforms. And so the effect ultimately that we've seen from a human capital point of view is displacement. 

**中文翻译:**
有趣的是，我之前提到过，我们的行业受 AI 影响已经超过十年了。Google、Facebook 甚至 Microsoft，这些组织在历史上一直处于人工智能的最前沿，他们的目标始终是尽可能地实现平台内的自动化。因此，从人力资本的角度来看，我们最终看到的效应是“位移”。

---

### [01:05:19] Jonathan Becker

**English:**
So we're actually, we have more people now than we've ever had, but the nature of the work that they do is more strategic, it's more about modeling, validation, asking the right questions, being focused around creative levers, and less so the trench work of implementation and bid modifiers at the keyword level on Google search, and some of the really hardcore manual analysis we had to do.

**中文翻译:**
实际上，我们现在的人员比以往任何时候都多，但他们工作的性质变得更具战略性，更多的是关于建模、验证、提出正确的问题、专注于创意杠杆，而不再是 Google 搜索关键词层面的执行和出价调整等“阵地战”工作，以及我们以前必须做的那些非常硬核的手动分析。

---

### [01:06:00] Jonathan Becker

**English:**
And so on a practical level, though, some of these conversational AI models are very interesting for us in that when I think about creative testing, for instance, we can have ChatGPT come up with all kinds of variants of copy that we would not have necessarily thought of. It can do a lot of drafting of things like RFP responses, so we can feed ChatGPT 100 previous RFP responses that we've done and have it spit out net new responses to net new questions in a net new RFP, and it's like 80% good and still requires 10 hours of work to massage to the point where we can send it off to a client, but that replaces a week of work with five or six people that it would've previously taken.

**中文翻译:**
在实际操作层面，一些对话式 AI 模型对我们来说非常有趣。例如，在创意测试中，我们可以让 ChatGPT 生成各种我们未必能想到的文案变体。它还可以起草 RFP（竞标方案）响应。我们可以把以前做过的 100 份 RFP 响应喂给 ChatGPT，让它针对新 RFP 中的新问题生成全新的回答。效果大约能达到 80%，虽然仍需要 10 小时的人工润色才能发给客户，但这取代了以前五六个人一周的工作量。

---

### [01:07:13] Jonathan Becker

**English:**
Some of these AI-driven organizations that allow you to type in a prompt and it spits out an image, on our creative group we can come up with mockups in literally 1% of the time that it took. So you no longer have to draw the initial mockups for art. Suddenly what might have taken one person a week of work on a campaign takes an afternoon, type thing. You still have to understand what questions to ask of the AI and be capable of iterating, but these rough drafts that you might show the artwork of to a client to say, "Do we like this more or do we like this more?" That's AI generated. It's really interesting.

**中文翻译:**
还有一些 AI 驱动的工具，你输入提示词（prompt）它就能生成图像。在我们的创意团队中，我们制作原型图所需的时间简直只有以前的 1%。你不再需要亲手绘制艺术初稿。突然间，以前一个人在一项活动上可能需要一周的工作量，现在一个下午就能搞定。你仍然需要理解该向 AI 提出什么问题，并具备迭代的能力，但这些你展示给客户看的艺术草案现在都是 AI 生成的。这真的很有趣。

---

### [01:08:00] Lenny

**English:**
What's the tool your team uses for that, is it MidJourney or Dall-E or something else?

**中文翻译:**
你的团队用什么工具做这个？MidJourney、Dall-E 还是别的？

---

### [01:08:03] Jonathan Becker

**English:**
It's Dall-E and it's MidJourney, so you got it.

**中文翻译:**
是 Dall-E 和 MidJourney，你猜对了。

---

### [01:09:16] Jonathan Becker

**English:**
Now that person theoretically can use Dall-E to output what is inside their head, and they can refine that easily through subsequent prompts in Dall-E or MidJourney, or whatever it may be, and then just say, "Do you like this? This is my idea." And so in a way it's helped humans connect more easily in that context than we were capable of doing before, and then in the context of pitching a client on ideas, we are capable of generating more ideas faster and iterating upon them live. So I can have a Zoom call with you, I can present my screen, and if you don't like the output of Dall-E that I just prompted, I can re-prompt based on your feedback in real time.

**中文翻译:**
现在，一个人理论上可以使用 Dall-E 将脑海中的想法输出，并通过后续的提示词轻松进行完善，然后直接说：“你喜欢这个吗？这是我的想法。”在某种程度上，这帮助人类在创意沟通上比以前更容易建立联系。在向客户推销创意时，我们能够更快地生成更多想法并进行现场迭代。我可以和你开 Zoom 会议，共享屏幕，如果你不喜欢我刚才生成的 Dall-E 结果，我可以根据你的反馈实时重新输入提示词。

---

### [01:10:04] Jonathan Becker

**English:**
How many scribes do you know? Zero, I believe zero. Because we invented something called the printing press, and the printing press took over what was a cottage industry for very specific individuals that allowed them to control the flow of information. Yet today it's not like we have fewer writers or creative thinkers, they're just using different tools to arrive at the same place. 

**中文翻译:**
你认识多少抄写员？我相信一个都没有。因为我们发明了印刷机，印刷机接管了曾经由极少数特定人员控制信息流动的家庭手工业。然而今天，我们的作家或创意思想家并没有变少，他们只是在使用不同的工具来达到同样的目的。

---

### [01:11:47] Jonathan Becker

**English:**
This generation of people will be upset, and then there will be a subsequent generation that never knew anything different. So the way that I think about this is the people growing up these days have always had the internet, whereas you and I probably remember a time before the internet existed. AI is a platform like the internet and just as when the internet was launched, you couldn't conceive of amazon.com or all of these wonderful or social networks or whatever it was. 

**中文翻译:**
这一代人可能会感到不安，但下一代人将永远不会知道除此之外还有什么。我的看法是，现在成长起来的人一直都有互联网，而你和我可能还记得互联网出现之前的时代。AI 是一个像互联网一样的平台，就像互联网刚推出时，你无法想象会有 amazon.com 或所有这些精彩的社交网络一样。

---

### [01:13:03] Lenny

**English:**
There's always this question when you're starting to invest in paid growth, performance marketing of should we work at an agency? Should we hire someone junior to figure it out? Should we hire someone senior? What's your general advice for, say, an early stage startup when it makes sense to work with an agency versus bringing someone in-house?

**中文翻译:**
当你开始投资付费增长和绩效营销时，总会面临一个问题：我们应该找代理机构（Agency）吗？还是应该雇个初级人员来摸索？或者雇个资深人士？对于早期初创公司，你的一般建议是什么？什么时候该找代理机构，什么时候该内部招聘？

---

### [01:13:33] Jonathan Becker

**English:**
We need people in-house to do our jobs properly. Agencies are not mutually exclusive to personnel in-house. If we don't have a point of contact, for instance, at an earlier stage company and we're supposed to report to the CEO, CEOs tend to be very busy people and we often just can't get the information and approvals that we need to be successful. If you think that growth marketing is an opportunity and that performance marketing is a subset of growth marketing that you want some focus on, the reality is you're going to need expertise and you probably should start in-house and then hire an agency.

**中文翻译:**
我们需要内部人员配合才能做好工作。代理机构和内部人员并不互斥。例如，如果在早期公司我们没有对接人，而必须直接向 CEO 汇报，CEO 通常非常忙，我们往往无法获得成功所需的信息和审批。如果你认为增长营销是一个机会，而绩效营销是你想要重点关注的增长营销子集，现实是你需要专业知识，你可能应该先从内部招聘开始，然后再聘请代理机构。

---

### [01:15:39] Jonathan Becker

**English:**
As agencies, we're constantly solving people's problems in the market and as a result of that, I have a fairly large team of 130 people that think about performance marketing all day long. It's the first thing we think about when we have our morning coffee and it's the last thing we think about as we're leaving the office kind of thing. We have very sophisticated and built out capabilities as well as all kinds of software and processes and capabilities, I guess, that we've created that most in-house teams just don't have because they're smaller or newer or someone might be really sophisticated but they don't have the resources to implement it and stuff. 

**中文翻译:**
作为代理机构，我们不断解决市场上的各种问题。因此，我有一个 130 人的庞大团队，整天都在思考绩效营销。这是我们喝早咖啡时想的第一件事，也是离开办公室前想的最后一件事。我们拥有非常成熟的能力，以及我们创建的各种软件、流程和功能，这些是大多数内部团队所不具备的，因为他们规模较小或成立较晚，或者即使有人很专业，也没有资源去执行。

---

### [01:17:09] Lenny

**English:**
When you're looking to hire someone full-time to drive the paid growth channel and/or work with an agency, what do you recommend people look for specifically, especially things maybe they're not likely to think about when they're hiring someone that people often miss?

**中文翻译:**
当你打算招聘全职人员来驱动付费增长渠道，或者与代理机构合作时，你建议大家具体看重什么？尤其是那些人们在招聘时往往会忽略、不太容易想到的点？

---

### [01:17:39] Jonathan Becker

**English:**
I became a web developer and as I transitioned into a performance marketing role, I realized that being technical and having technical aptitudes was extraordinarily helpful in terms of being on the front line of what we were doing and solving problems. If you're making your first hire, you probably want them to have the ingenuity and capability to solve a lot of the problems that you're going to run into within the context of tracking, attribution, data visualization, and then campaign management. Number one, do they have a technical background? 

**中文翻译:**
我曾是一名 Web 开发人员，当我转型到绩效营销角色时，我意识到具备技术背景和技术天赋对于处于一线解决问题非常有帮助。如果你在招第一个人，你可能希望他们有足够的聪明才智和能力来解决你在追踪、归因、数据可视化以及活动管理中会遇到的各种问题。第一点，他们是否有技术背景？

---

### [01:19:29] Jonathan Becker

**English:**
I actually borrowed a Jeff Bezos question from early stage Amazon where I asked people without much warning in an interview, I'll ask them whether it's okay to do a bit of a thought experiment together and whether they are comfortable responding to a logic question. I'll ask the question of, "How many windows are there in New York City?" There's two things that I look for in this scenario. One is can they think on their feet? I'm not actually looking for the correct answer. It's a pretty difficult question to solve. 

**中文翻译:**
我实际上借用了早期 Amazon 杰夫·贝索斯（Jeff Bezos）的一个面试题。在面试中，我会毫无预警地问对方是否愿意一起做一个思想实验，是否愿意回答一个逻辑题。我会问：“纽约市有多少扇窗户？”在这种情况下，我考察两点：一是他们能否随机应变。我其实并不在乎正确答案，这是一个很难解决的问题。

---

### [01:20:33] Jonathan Becker

**English:**
But also from a client services point of view, I'm trying to see whether in a scenario where I've asked them something that they obviously probably weren't prepared for, that is a strange thing to ask and probably makes them feel a little bit uncomfortable, how they react in that situation. Do they remain composed or do they lose their composure and get frustrated or even angry that I asked them something that's pretty weird to ask? Their reaction there is often a good leading indicator of whether or not in a client scenario working with our clients, they can compose themselves in a difficult situation.

**中文翻译:**
但从客户服务的角度来看，我想看看当我问了一个他们显然没准备好、很奇怪且可能让他们感到不适的问题时，他们会如何反应。他们是保持冷静，还是失去分寸、感到沮丧，甚至因为我问了个怪问题而生气？他们的反应通常是一个很好的先行指标，预示着在面对客户的困难局面时，他们能否保持镇定。

---

### [01:23:23] Lenny

**English:**
Last question. We started with the story of how you landed Uber, and I know you also have an interesting story which I haven't heard of how you landed Snap/Snapchat as a client, so maybe tell that story.

**中文翻译:**
最后一个问题。我们以你如何签下 Uber 的故事开始，我知道你还有一个我没听过的关于如何签下 Snap/Snapchat 作为客户的有趣故事，也许可以讲讲那个。

---

### [01:23:38] Jonathan Becker

**English:**
The RFP process for Snap was somewhat complex and they asked a range of different questions and we find ourselves in LA at a hotel the night before, it's 2:00 in the morning, my business partner and another team member that we had brought down are sweating and we're like, "How are we going to build a presentation out of this? They're asking so many well-meaning but difficult questions that are zigging and zagging." 

**中文翻译:**
Snap 的 RFP（竞标）过程相当复杂，他们问了一系列不同的问题。前一天晚上我们在洛杉矶的一家酒店里，凌晨两点，我的合伙人和另一名团队成员满头大汗，心想：“我们该怎么根据这些做演示文稿？他们问了这么多出于好意但极其刁钻、东拉西扯的问题。”

---

### [01:25:54] Jonathan Becker

**English:**
I stand there in front of about 20 different executives from their organization and I say, "You have thoughtfully curated an RFP for us to respond to today, and you have asked us to respond to about 20 to 30 different questions. With the utmost respect, I am not going to answer any of your questions today. I'm standing here because you are looking for a marketing partner and you need expertise in this area and instead of telling you the answers to the questions that you asked, I'm going to tell you what I think you need to do to get where you want to go and if you agree with me and my logic and what I talk to you about here today, then you should hire us."

**中文翻译:**
我站在他们公司的约 20 名高管面前说：“你们精心准备了一份 RFP 让我们今天回应，你们要求我们回答大约 20 到 30 个不同的问题。出于最大的尊重，我今天不打算回答你们的任何问题。我站在这里是因为你们在寻找营销合作伙伴，你们需要这个领域的专业知识。与其告诉你们那些问题的答案，我打算告诉你们我认为你们需要做什么才能达到目标。如果你认同我今天的逻辑和内容，那么你应该聘请我们。”

---

### [01:27:12] Jonathan Becker

**English:**
Then about two hours later, I get a phone call and they were like, "We loved your approach. Congratulations. You're hired." Essentially the lesson was that you have to trust yourself and understand your strengths and weaknesses. In situations where someone is well-meaning but may not understand what they need, be brave and tell them what they need rather than just conforming to what they're asking for because sometimes inadvertently that leads you down the wrong path. 

**中文翻译:**
大约两个小时后，我接到一个电话，他们说：“我们非常喜欢你的方法。恭喜，你被录用了。”本质上的教训是，你必须相信自己，了解自己的优缺点。在某些情况下，对方虽然出于好意但可能并不真正了解自己需要什么，这时要勇敢地告诉他们需要什么，而不是仅仅顺从他们的要求，因为有时那会无意中把你带入歧途。

---

### [01:29:05] Lenny

**English:**
Okay, great. Okay, first question, what are two or three books that you've recommended most to other people?

**中文翻译:**
太棒了。好，第一个问题，你向别人推荐最多的两三本书是什么？

---

### [01:29:13] Jonathan Becker

**English:**
As a marketer, *Storyworthy* by Matthew Dicks is a wonderful book. As an entrepreneur, I love startup stories, so *Shoe Dog*, which is the startup story of Nike. Then a book by Nick Bilton called *American Kingpin*, which is the story of the startup of the Silk Road. It honestly should be a Hollywood movie. It reads like a Hollywood thriller. 

**中文翻译:**
作为营销人员，Matthew Dicks 的《Storyworthy》（故事力）是一本极好的书。作为企业家，我喜欢创业故事，比如《Shoe Dog》（鞋狗），那是 Nike 的创业故事。还有 Nick Bilton 的《American Kingpin》（美国毒枭），讲的是“丝绸之路”网站的创业故事。老实说，它应该被拍成好莱坞电影，读起来就像好莱坞惊悚片。

---

### [01:30:32] Lenny

**English:**
Favorite recent movie or a TV show.

**中文翻译:**
最近最喜欢的电影或电视节目。

---

### [01:30:35] Jonathan Becker

**English:**
I don't know how recent it is, but I love *The Big Short*. The reason why I like it is because someone found truth in the data they were analyzing and then capitalized on it, which is really an analog for what we do in performance marketing. Then recently I have fallen in love with *White Lotus*.

**中文翻译:**
我不知道这算不算最近的，但我很喜欢《大空头》（The Big Short）。我喜欢它的原因是有人在他们分析的数据中发现了真相，并利用了它，这实际上就是我们在绩效营销中所做工作的类比。最近我迷上了《白莲花度假村》（White Lotus）。

---

### [01:32:12] Lenny

**English:**
Speaking of tools, final question. What is your favorite most underrated tool for performance marketing work?

**中文翻译:**
说到工具，最后一个问题。在绩效营销工作中，你最喜欢且最被低估的工具是什么？

---

### [01:32:18] Jonathan Becker

**English:**
It's Thrive Stack. It's a tool that we built in-house that allows us to pipe third party data and anonymized customer level data into a database and then ultimately visualize it in a format like Data Studio. That has been a profoundly powerful platform from which we're capable of delivering insights that are built upon the data as opposed to just regurgitated data.

**中文翻译:**
是 Thrive Stack。这是我们内部构建的一个工具，它允许我们将第三方数据和匿名客户级数据导入数据库，最终以 Data Studio 等格式进行可视化。这是一个极其强大的平台，让我们能够提供基于数据的洞察，而不仅仅是重复陈述数据。

---

### [01:33:23] Lenny

**English:**
Jonathan, thank you so much for being here. Where can folks find you online?

**中文翻译:**
Jonathan，非常感谢你能来。大家可以在哪里在线找到你？

---

### [01:34:12] Jonathan Becker

**English:**
Thrivedigital.com. Personally, I'm on LinkedIn under my name Jonathan Becker or Twitter, JZBecker.

**中文翻译:**
Thrivedigital.com。个人方面，可以在 LinkedIn 上搜我的名字 Jonathan Becker，或者在 Twitter 上搜 JZBecker。

---

### [01:34:29] Lenny

**English:**
Bye, everyone. Thank you so much for listening. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。下期节目见。